"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFileLogDriver = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to json-file Logs.
 */
class JsonFileLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the JsonFileLogDriver class.
     *
     * @param props the json-file log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_JsonFileLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, JsonFileLogDriver);
            }
            throw error;
        }
        // Validation
        if (props.maxFile && props.maxFile < 0) {
            throw new Error('`maxFile` must be a positive integer.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(_containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            logDriver: 'json-file',
            options: utils_1.stringifyOptions({
                'max-size': this.props.maxSize,
                'max-file': this.props.maxFile,
                'compress': this.props.compress,
                'labels': utils_1.joinWithCommas(this.props.labels),
                'env': utils_1.joinWithCommas(this.props.env),
                'env-regex': this.props.envRegex,
            }),
        };
    }
}
exports.JsonFileLogDriver = JsonFileLogDriver;
_a = JSII_RTTI_SYMBOL_1;
JsonFileLogDriver[_a] = { fqn: "monocdk.aws_ecs.JsonFileLogDriver", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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