"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentdLogDriver = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to journald Logs.
 */
class FluentdLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the FluentdLogDriver class.
     *
     * @param props the fluentd log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_FluentdLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FluentdLogDriver);
            }
            throw error;
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(_containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            logDriver: 'fluentd',
            options: utils_1.stringifyOptions({
                'fluentd-address': this.props.address,
                'fluentd-async-connect': this.props.asyncConnect,
                'fluentd-buffer-limit': this.props.bufferLimit,
                'fluentd-retry-wait': this.props.retryWait && this.props.retryWait.toSeconds(),
                'fluentd-max-retries': this.props.maxRetries,
                'fluentd-sub-second-precision': this.props.subSecondPrecision,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.FluentdLogDriver = FluentdLogDriver;
_a = JSII_RTTI_SYMBOL_1;
FluentdLogDriver[_a] = { fqn: "monocdk.aws_ecs.FluentdLogDriver", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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