"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FireLensLogDriver = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * FireLens enables you to use task definition parameters to route logs to an AWS service
 *  or AWS Partner Network (APN) destination for log storage and analytics
 */
class FireLensLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the FireLensLogDriver class.
     * @param props the awsfirelens log driver configuration options.
     */
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_FireLensLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FireLensLogDriver);
            }
            throw error;
        }
        this.options = props.options;
        this.secretOptions = props.secretOptions;
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(_containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            logDriver: 'awsfirelens',
            ...(this.options && { options: utils_1.removeEmpty(this.options) }),
            secretOptions: this.secretOptions && utils_1.renderLogDriverSecretOptions(this.secretOptions, _containerDefinition.taskDefinition),
        };
    }
}
exports.FireLensLogDriver = FireLensLogDriver;
_a = JSII_RTTI_SYMBOL_1;
FireLensLogDriver[_a] = { fqn: "monocdk.aws_ecs.FireLensLogDriver", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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