"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLogDriver = exports.AwsLogDriverMode = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const logs = require("../../../aws-logs");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * awslogs provides two modes for delivering messages from the container to the log driver
 */
var AwsLogDriverMode;
(function (AwsLogDriverMode) {
    /**
     * (default) direct, blocking delivery from container to driver.
     */
    AwsLogDriverMode["BLOCKING"] = "blocking";
    /**
     * The non-blocking message delivery mode prevents applications from blocking due to logging back pressure.
     * Applications are likely to fail in unexpected ways when STDERR or STDOUT streams block.
     */
    AwsLogDriverMode["NON_BLOCKING"] = "non-blocking";
})(AwsLogDriverMode = exports.AwsLogDriverMode || (exports.AwsLogDriverMode = {}));
/**
 * A log driver that sends log information to CloudWatch Logs.
 */
class AwsLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the AwsLogDriver class.
     *
     * @param props the awslogs log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_AwsLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AwsLogDriver);
            }
            throw error;
        }
        if (props.logGroup && props.logRetention) {
            throw new Error('Cannot specify both `logGroup` and `logRetentionDays`.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(scope, containerDefinition) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.logGroup = this.props.logGroup || new logs.LogGroup(scope, 'LogGroup', {
            retention: this.props.logRetention || Infinity,
        });
        this.logGroup.grantWrite(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            logDriver: 'awslogs',
            options: utils_1.removeEmpty({
                'awslogs-group': this.logGroup.logGroupName,
                'awslogs-stream-prefix': this.props.streamPrefix,
                'awslogs-region': this.logGroup.env.region,
                'awslogs-datetime-format': this.props.datetimeFormat,
                'awslogs-multiline-pattern': this.props.multilinePattern,
                'mode': this.props.mode,
            }),
        };
    }
}
exports.AwsLogDriver = AwsLogDriver;
_a = JSII_RTTI_SYMBOL_1;
AwsLogDriver[_a] = { fqn: "monocdk.aws_ecs.AwsLogDriver", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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