"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TmpfsMountOption = exports.DevicePermission = exports.Capability = exports.LinuxParameters = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../core");
/**
 * Linux-specific options that are applied to the container.
 */
class LinuxParameters extends core_1.Construct {
    /**
     * Constructs a new instance of the LinuxParameters class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        /**
         * Capabilities to be added
         */
        this.capAdd = new Array();
        /**
         * Capabilities to be dropped
         */
        this.capDrop = new Array();
        /**
         * Device mounts
         */
        this.devices = new Array();
        /**
         * TmpFs mounts
         */
        this.tmpfs = new Array();
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_LinuxParametersProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LinuxParameters);
            }
            throw error;
        }
        this.sharedMemorySize = props.sharedMemorySize;
        this.initProcessEnabled = props.initProcessEnabled;
    }
    /**
     * Adds one or more Linux capabilities to the Docker configuration of a container.
     *
     * Only works with EC2 launch type.
     */
    addCapabilities(...cap) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_Capability(cap);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addCapabilities);
            }
            throw error;
        }
        this.capAdd.push(...cap);
    }
    /**
     * Removes one or more Linux capabilities to the Docker configuration of a container.
     *
     * Only works with EC2 launch type.
     */
    dropCapabilities(...cap) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_Capability(cap);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.dropCapabilities);
            }
            throw error;
        }
        this.capDrop.push(...cap);
    }
    /**
     * Adds one or more host devices to a container.
     */
    addDevices(...device) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_Device(device);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addDevices);
            }
            throw error;
        }
        this.devices.push(...device);
    }
    /**
     * Specifies the container path, mount options, and size (in MiB) of the tmpfs mount for a container.
     *
     * Only works with EC2 launch type.
     */
    addTmpfs(...tmpfs) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_Tmpfs(tmpfs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addTmpfs);
            }
            throw error;
        }
        this.tmpfs.push(...tmpfs);
    }
    /**
     * Renders the Linux parameters to a CloudFormation object.
     */
    renderLinuxParameters() {
        return {
            initProcessEnabled: this.initProcessEnabled,
            sharedMemorySize: this.sharedMemorySize,
            capabilities: {
                add: cdk.Lazy.list({ produce: () => this.capAdd }, { omitEmpty: true }),
                drop: cdk.Lazy.list({ produce: () => this.capDrop }, { omitEmpty: true }),
            },
            devices: cdk.Lazy.any({ produce: () => this.devices.map(renderDevice) }, { omitEmptyArray: true }),
            tmpfs: cdk.Lazy.any({ produce: () => this.tmpfs.map(renderTmpfs) }, { omitEmptyArray: true }),
        };
    }
}
exports.LinuxParameters = LinuxParameters;
_a = JSII_RTTI_SYMBOL_1;
LinuxParameters[_a] = { fqn: "monocdk.aws_ecs.LinuxParameters", version: "1.185.0" };
function renderDevice(device) {
    return {
        containerPath: device.containerPath,
        hostPath: device.hostPath,
        permissions: device.permissions,
    };
}
function renderTmpfs(tmpfs) {
    return {
        containerPath: tmpfs.containerPath,
        size: tmpfs.size,
        mountOptions: tmpfs.mountOptions,
    };
}
/**
 * A Linux capability
 */
var Capability;
(function (Capability) {
    Capability["ALL"] = "ALL";
    Capability["AUDIT_CONTROL"] = "AUDIT_CONTROL";
    Capability["AUDIT_WRITE"] = "AUDIT_WRITE";
    Capability["BLOCK_SUSPEND"] = "BLOCK_SUSPEND";
    Capability["CHOWN"] = "CHOWN";
    Capability["DAC_OVERRIDE"] = "DAC_OVERRIDE";
    Capability["DAC_READ_SEARCH"] = "DAC_READ_SEARCH";
    Capability["FOWNER"] = "FOWNER";
    Capability["FSETID"] = "FSETID";
    Capability["IPC_LOCK"] = "IPC_LOCK";
    Capability["IPC_OWNER"] = "IPC_OWNER";
    Capability["KILL"] = "KILL";
    Capability["LEASE"] = "LEASE";
    Capability["LINUX_IMMUTABLE"] = "LINUX_IMMUTABLE";
    Capability["MAC_ADMIN"] = "MAC_ADMIN";
    Capability["MAC_OVERRIDE"] = "MAC_OVERRIDE";
    Capability["MKNOD"] = "MKNOD";
    Capability["NET_ADMIN"] = "NET_ADMIN";
    Capability["NET_BIND_SERVICE"] = "NET_BIND_SERVICE";
    Capability["NET_BROADCAST"] = "NET_BROADCAST";
    Capability["NET_RAW"] = "NET_RAW";
    Capability["SETFCAP"] = "SETFCAP";
    Capability["SETGID"] = "SETGID";
    Capability["SETPCAP"] = "SETPCAP";
    Capability["SETUID"] = "SETUID";
    Capability["SYS_ADMIN"] = "SYS_ADMIN";
    Capability["SYS_BOOT"] = "SYS_BOOT";
    Capability["SYS_CHROOT"] = "SYS_CHROOT";
    Capability["SYS_MODULE"] = "SYS_MODULE";
    Capability["SYS_NICE"] = "SYS_NICE";
    Capability["SYS_PACCT"] = "SYS_PACCT";
    Capability["SYS_PTRACE"] = "SYS_PTRACE";
    Capability["SYS_RAWIO"] = "SYS_RAWIO";
    Capability["SYS_RESOURCE"] = "SYS_RESOURCE";
    Capability["SYS_TIME"] = "SYS_TIME";
    Capability["SYS_TTY_CONFIG"] = "SYS_TTY_CONFIG";
    Capability["SYSLOG"] = "SYSLOG";
    Capability["WAKE_ALARM"] = "WAKE_ALARM";
})(Capability = exports.Capability || (exports.Capability = {}));
/**
 * Permissions for device access
 */
var DevicePermission;
(function (DevicePermission) {
    /**
     * Read
     */
    DevicePermission["READ"] = "read";
    /**
     * Write
     */
    DevicePermission["WRITE"] = "write";
    /**
     * Make a node
     */
    DevicePermission["MKNOD"] = "mknod";
})(DevicePermission = exports.DevicePermission || (exports.DevicePermission = {}));
/**
 * The supported options for a tmpfs mount for a container.
 */
var TmpfsMountOption;
(function (TmpfsMountOption) {
    TmpfsMountOption["DEFAULTS"] = "defaults";
    TmpfsMountOption["RO"] = "ro";
    TmpfsMountOption["RW"] = "rw";
    TmpfsMountOption["SUID"] = "suid";
    TmpfsMountOption["NOSUID"] = "nosuid";
    TmpfsMountOption["DEV"] = "dev";
    TmpfsMountOption["NODEV"] = "nodev";
    TmpfsMountOption["EXEC"] = "exec";
    TmpfsMountOption["NOEXEC"] = "noexec";
    TmpfsMountOption["SYNC"] = "sync";
    TmpfsMountOption["ASYNC"] = "async";
    TmpfsMountOption["DIRSYNC"] = "dirsync";
    TmpfsMountOption["REMOUNT"] = "remount";
    TmpfsMountOption["MAND"] = "mand";
    TmpfsMountOption["NOMAND"] = "nomand";
    TmpfsMountOption["ATIME"] = "atime";
    TmpfsMountOption["NOATIME"] = "noatime";
    TmpfsMountOption["DIRATIME"] = "diratime";
    TmpfsMountOption["NODIRATIME"] = "nodiratime";
    TmpfsMountOption["BIND"] = "bind";
    TmpfsMountOption["RBIND"] = "rbind";
    TmpfsMountOption["UNBINDABLE"] = "unbindable";
    TmpfsMountOption["RUNBINDABLE"] = "runbindable";
    TmpfsMountOption["PRIVATE"] = "private";
    TmpfsMountOption["RPRIVATE"] = "rprivate";
    TmpfsMountOption["SHARED"] = "shared";
    TmpfsMountOption["RSHARED"] = "rshared";
    TmpfsMountOption["SLAVE"] = "slave";
    TmpfsMountOption["RSLAVE"] = "rslave";
    TmpfsMountOption["RELATIME"] = "relatime";
    TmpfsMountOption["NORELATIME"] = "norelatime";
    TmpfsMountOption["STRICTATIME"] = "strictatime";
    TmpfsMountOption["NOSTRICTATIME"] = "nostrictatime";
    TmpfsMountOption["MODE"] = "mode";
    TmpfsMountOption["UID"] = "uid";
    TmpfsMountOption["GID"] = "gid";
    TmpfsMountOption["NR_INODES"] = "nr_inodes";
    TmpfsMountOption["NR_BLOCKS"] = "nr_blocks";
    TmpfsMountOption["MPOL"] = "mpol";
})(TmpfsMountOption = exports.TmpfsMountOption || (exports.TmpfsMountOption = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGludXgtcGFyYW1ldGVycy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxpbnV4LXBhcmFtZXRlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsa0NBQWtDO0FBSWxDLGlHQUFpRztBQUNqRyw4REFBOEQ7QUFDOUQscUNBQXdEO0FBcUJ4RDs7R0FFRztBQUNILE1BQWEsZUFBZ0IsU0FBUSxnQkFBYTtJQStCaEQ7O09BRUc7SUFDSCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQThCLEVBQUU7UUFDeEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQXhCbkI7O1dBRUc7UUFDYyxXQUFNLEdBQUcsSUFBSSxLQUFLLEVBQWMsQ0FBQztRQUVsRDs7V0FFRztRQUNjLFlBQU8sR0FBRyxJQUFJLEtBQUssRUFBYyxDQUFDO1FBRW5EOztXQUVHO1FBQ2MsWUFBTyxHQUFHLElBQUksS0FBSyxFQUFVLENBQUM7UUFFL0M7O1dBRUc7UUFDYyxVQUFLLEdBQUcsSUFBSSxLQUFLLEVBQVMsQ0FBQzs7Ozs7OytDQTdCakMsZUFBZTs7OztRQXFDeEIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixDQUFDO0tBQ3BEO0lBRUQ7Ozs7T0FJRztJQUNJLGVBQWUsQ0FBQyxHQUFHLEdBQWlCOzs7Ozs7Ozs7O1FBQ3pDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsR0FBRyxDQUFDLENBQUM7S0FDMUI7SUFFRDs7OztPQUlHO0lBQ0ksZ0JBQWdCLENBQUMsR0FBRyxHQUFpQjs7Ozs7Ozs7OztRQUMxQyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLEdBQUcsQ0FBQyxDQUFDO0tBQzNCO0lBRUQ7O09BRUc7SUFDSSxVQUFVLENBQUMsR0FBRyxNQUFnQjs7Ozs7Ozs7OztRQUNuQyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLE1BQU0sQ0FBQyxDQUFDO0tBQzlCO0lBRUQ7Ozs7T0FJRztJQUNJLFFBQVEsQ0FBQyxHQUFHLEtBQWM7Ozs7Ozs7Ozs7UUFDL0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxLQUFLLENBQUMsQ0FBQztLQUMzQjtJQUVEOztPQUVHO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU87WUFDTCxrQkFBa0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO1lBQzNDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsWUFBWSxFQUFFO2dCQUNaLEdBQUcsRUFBRSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLEVBQUUsRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLENBQUM7Z0JBQ3ZFLElBQUksRUFBRSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEVBQUUsRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLENBQUM7YUFDMUU7WUFDRCxPQUFPLEVBQUUsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsWUFBWSxDQUFDLEVBQUUsRUFBRSxFQUFFLGNBQWMsRUFBRSxJQUFJLEVBQUUsQ0FBQztZQUNsRyxLQUFLLEVBQUUsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsV0FBVyxDQUFDLEVBQUUsRUFBRSxFQUFFLGNBQWMsRUFBRSxJQUFJLEVBQUUsQ0FBQztTQUM5RixDQUFDO0tBQ0g7O0FBekZILDBDQTBGQzs7O0FBMkJELFNBQVMsWUFBWSxDQUFDLE1BQWM7SUFDbEMsT0FBTztRQUNMLGFBQWEsRUFBRSxNQUFNLENBQUMsYUFBYTtRQUNuQyxRQUFRLEVBQUUsTUFBTSxDQUFDLFFBQVE7UUFDekIsV0FBVyxFQUFFLE1BQU0sQ0FBQyxXQUFXO0tBQ2hDLENBQUM7QUFDSixDQUFDO0FBdUJELFNBQVMsV0FBVyxDQUFDLEtBQVk7SUFDL0IsT0FBTztRQUNMLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtRQUNsQyxJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7UUFDaEIsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO0tBQ2pDLENBQUM7QUFDSixDQUFDO0FBRUQ7O0dBRUc7QUFDSCxJQUFZLFVBdUNYO0FBdkNELFdBQVksVUFBVTtJQUNwQix5QkFBVyxDQUFBO0lBQ1gsNkNBQStCLENBQUE7SUFDL0IseUNBQTJCLENBQUE7SUFDM0IsNkNBQStCLENBQUE7SUFDL0IsNkJBQWUsQ0FBQTtJQUNmLDJDQUE2QixDQUFBO0lBQzdCLGlEQUFtQyxDQUFBO0lBQ25DLCtCQUFpQixDQUFBO0lBQ2pCLCtCQUFpQixDQUFBO0lBQ2pCLG1DQUFxQixDQUFBO0lBQ3JCLHFDQUF1QixDQUFBO0lBQ3ZCLDJCQUFhLENBQUE7SUFDYiw2QkFBZSxDQUFBO0lBQ2YsaURBQW1DLENBQUE7SUFDbkMscUNBQXVCLENBQUE7SUFDdkIsMkNBQTZCLENBQUE7SUFDN0IsNkJBQWUsQ0FBQTtJQUNmLHFDQUF1QixDQUFBO0lBQ3ZCLG1EQUFxQyxDQUFBO0lBQ3JDLDZDQUErQixDQUFBO0lBQy9CLGlDQUFtQixDQUFBO0lBQ25CLGlDQUFtQixDQUFBO0lBQ25CLCtCQUFpQixDQUFBO0lBQ2pCLGlDQUFtQixDQUFBO0lBQ25CLCtCQUFpQixDQUFBO0lBQ2pCLHFDQUF1QixDQUFBO0lBQ3ZCLG1DQUFxQixDQUFBO0lBQ3JCLHVDQUF5QixDQUFBO0lBQ3pCLHVDQUF5QixDQUFBO0lBQ3pCLG1DQUFxQixDQUFBO0lBQ3JCLHFDQUF1QixDQUFBO0lBQ3ZCLHVDQUF5QixDQUFBO0lBQ3pCLHFDQUF1QixDQUFBO0lBQ3ZCLDJDQUE2QixDQUFBO0lBQzdCLG1DQUFxQixDQUFBO0lBQ3JCLCtDQUFpQyxDQUFBO0lBQ2pDLCtCQUFpQixDQUFBO0lBQ2pCLHVDQUF5QixDQUFBO0FBQzNCLENBQUMsRUF2Q1csVUFBVSxHQUFWLGtCQUFVLEtBQVYsa0JBQVUsUUF1Q3JCO0FBRUQ7O0dBRUc7QUFDSCxJQUFZLGdCQWVYO0FBZkQsV0FBWSxnQkFBZ0I7SUFDMUI7O09BRUc7SUFDSCxpQ0FBYSxDQUFBO0lBRWI7O09BRUc7SUFDSCxtQ0FBZSxDQUFBO0lBRWY7O09BRUc7SUFDSCxtQ0FBZSxDQUFBO0FBQ2pCLENBQUMsRUFmVyxnQkFBZ0IsR0FBaEIsd0JBQWdCLEtBQWhCLHdCQUFnQixRQWUzQjtBQUVEOztHQUVHO0FBQ0gsSUFBWSxnQkF3Q1g7QUF4Q0QsV0FBWSxnQkFBZ0I7SUFDMUIseUNBQXFCLENBQUE7SUFDckIsNkJBQVMsQ0FBQTtJQUNULDZCQUFTLENBQUE7SUFDVCxpQ0FBYSxDQUFBO0lBQ2IscUNBQWlCLENBQUE7SUFDakIsK0JBQVcsQ0FBQTtJQUNYLG1DQUFlLENBQUE7SUFDZixpQ0FBYSxDQUFBO0lBQ2IscUNBQWlCLENBQUE7SUFDakIsaUNBQWEsQ0FBQTtJQUNiLG1DQUFlLENBQUE7SUFDZix1Q0FBbUIsQ0FBQTtJQUNuQix1Q0FBbUIsQ0FBQTtJQUNuQixpQ0FBYSxDQUFBO0lBQ2IscUNBQWlCLENBQUE7SUFDakIsbUNBQWUsQ0FBQTtJQUNmLHVDQUFtQixDQUFBO0lBQ25CLHlDQUFxQixDQUFBO0lBQ3JCLDZDQUF5QixDQUFBO0lBQ3pCLGlDQUFhLENBQUE7SUFDYixtQ0FBZSxDQUFBO0lBQ2YsNkNBQXlCLENBQUE7SUFDekIsK0NBQTJCLENBQUE7SUFDM0IsdUNBQW1CLENBQUE7SUFDbkIseUNBQXFCLENBQUE7SUFDckIscUNBQWlCLENBQUE7SUFDakIsdUNBQW1CLENBQUE7SUFDbkIsbUNBQWUsQ0FBQTtJQUNmLHFDQUFpQixDQUFBO0lBQ2pCLHlDQUFxQixDQUFBO0lBQ3JCLDZDQUF5QixDQUFBO0lBQ3pCLCtDQUEyQixDQUFBO0lBQzNCLG1EQUErQixDQUFBO0lBQy9CLGlDQUFhLENBQUE7SUFDYiwrQkFBVyxDQUFBO0lBQ1gsK0JBQVcsQ0FBQTtJQUNYLDJDQUF1QixDQUFBO0lBQ3ZCLDJDQUF1QixDQUFBO0lBQ3ZCLGlDQUFhLENBQUE7QUFDZixDQUFDLEVBeENXLGdCQUFnQixHQUFoQix3QkFBZ0IsS0FBaEIsd0JBQWdCLFFBd0MzQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICcuLi8uLi9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuVGFza0RlZmluaXRpb24gfSBmcm9tICcuL2Vjcy5nZW5lcmF0ZWQnO1xuXG4vLyBrZWVwIHRoaXMgaW1wb3J0IHNlcGFyYXRlIGZyb20gb3RoZXIgaW1wb3J0cyB0byByZWR1Y2UgY2hhbmNlIGZvciBtZXJnZSBjb25mbGljdHMgd2l0aCB2Mi1tYWluXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tZHVwbGljYXRlLWltcG9ydHMsIGltcG9ydC9vcmRlclxuaW1wb3J0IHsgQ29uc3RydWN0IGFzIENvcmVDb25zdHJ1Y3QgfSBmcm9tICcuLi8uLi9jb3JlJztcblxuLyoqXG4gKiBUaGUgcHJvcGVydGllcyBmb3IgZGVmaW5pbmcgTGludXgtc3BlY2lmaWMgb3B0aW9ucyB0aGF0IGFyZSBhcHBsaWVkIHRvIHRoZSBjb250YWluZXIuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTGludXhQYXJhbWV0ZXJzUHJvcHMge1xuICAvKipcbiAgICogU3BlY2lmaWVzIHdoZXRoZXIgdG8gcnVuIGFuIGluaXQgcHJvY2VzcyBpbnNpZGUgdGhlIGNvbnRhaW5lciB0aGF0IGZvcndhcmRzIHNpZ25hbHMgYW5kIHJlYXBzIHByb2Nlc3Nlcy5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGluaXRQcm9jZXNzRW5hYmxlZD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSB2YWx1ZSBmb3IgdGhlIHNpemUgKGluIE1pQikgb2YgdGhlIC9kZXYvc2htIHZvbHVtZS5cbiAgICpcbiAgICogQGRlZmF1bHQgTm8gc2hhcmVkIG1lbW9yeS5cbiAgICovXG4gIHJlYWRvbmx5IHNoYXJlZE1lbW9yeVNpemU/OiBudW1iZXI7XG59XG5cbi8qKlxuICogTGludXgtc3BlY2lmaWMgb3B0aW9ucyB0aGF0IGFyZSBhcHBsaWVkIHRvIHRoZSBjb250YWluZXIuXG4gKi9cbmV4cG9ydCBjbGFzcyBMaW51eFBhcmFtZXRlcnMgZXh0ZW5kcyBDb3JlQ29uc3RydWN0IHtcbiAgLyoqXG4gICAqIFdoZXRoZXIgdGhlIGluaXQgcHJvY2VzcyBpcyBlbmFibGVkXG4gICAqL1xuICBwcml2YXRlIHJlYWRvbmx5IGluaXRQcm9jZXNzRW5hYmxlZD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSBzaGFyZWQgbWVtb3J5IHNpemUuIE5vdCB2YWxpZCBmb3IgRmFyZ2F0ZSBsYXVuY2ggdHlwZVxuICAgKi9cbiAgcHJpdmF0ZSByZWFkb25seSBzaGFyZWRNZW1vcnlTaXplPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBDYXBhYmlsaXRpZXMgdG8gYmUgYWRkZWRcbiAgICovXG4gIHByaXZhdGUgcmVhZG9ubHkgY2FwQWRkID0gbmV3IEFycmF5PENhcGFiaWxpdHk+KCk7XG5cbiAgLyoqXG4gICAqIENhcGFiaWxpdGllcyB0byBiZSBkcm9wcGVkXG4gICAqL1xuICBwcml2YXRlIHJlYWRvbmx5IGNhcERyb3AgPSBuZXcgQXJyYXk8Q2FwYWJpbGl0eT4oKTtcblxuICAvKipcbiAgICogRGV2aWNlIG1vdW50c1xuICAgKi9cbiAgcHJpdmF0ZSByZWFkb25seSBkZXZpY2VzID0gbmV3IEFycmF5PERldmljZT4oKTtcblxuICAvKipcbiAgICogVG1wRnMgbW91bnRzXG4gICAqL1xuICBwcml2YXRlIHJlYWRvbmx5IHRtcGZzID0gbmV3IEFycmF5PFRtcGZzPigpO1xuXG4gIC8qKlxuICAgKiBDb25zdHJ1Y3RzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBMaW51eFBhcmFtZXRlcnMgY2xhc3MuXG4gICAqL1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogTGludXhQYXJhbWV0ZXJzUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnNoYXJlZE1lbW9yeVNpemUgPSBwcm9wcy5zaGFyZWRNZW1vcnlTaXplO1xuICAgIHRoaXMuaW5pdFByb2Nlc3NFbmFibGVkID0gcHJvcHMuaW5pdFByb2Nlc3NFbmFibGVkO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgb25lIG9yIG1vcmUgTGludXggY2FwYWJpbGl0aWVzIHRvIHRoZSBEb2NrZXIgY29uZmlndXJhdGlvbiBvZiBhIGNvbnRhaW5lci5cbiAgICpcbiAgICogT25seSB3b3JrcyB3aXRoIEVDMiBsYXVuY2ggdHlwZS5cbiAgICovXG4gIHB1YmxpYyBhZGRDYXBhYmlsaXRpZXMoLi4uY2FwOiBDYXBhYmlsaXR5W10pIHtcbiAgICB0aGlzLmNhcEFkZC5wdXNoKC4uLmNhcCk7XG4gIH1cblxuICAvKipcbiAgICogUmVtb3ZlcyBvbmUgb3IgbW9yZSBMaW51eCBjYXBhYmlsaXRpZXMgdG8gdGhlIERvY2tlciBjb25maWd1cmF0aW9uIG9mIGEgY29udGFpbmVyLlxuICAgKlxuICAgKiBPbmx5IHdvcmtzIHdpdGggRUMyIGxhdW5jaCB0eXBlLlxuICAgKi9cbiAgcHVibGljIGRyb3BDYXBhYmlsaXRpZXMoLi4uY2FwOiBDYXBhYmlsaXR5W10pIHtcbiAgICB0aGlzLmNhcERyb3AucHVzaCguLi5jYXApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgb25lIG9yIG1vcmUgaG9zdCBkZXZpY2VzIHRvIGEgY29udGFpbmVyLlxuICAgKi9cbiAgcHVibGljIGFkZERldmljZXMoLi4uZGV2aWNlOiBEZXZpY2VbXSkge1xuICAgIHRoaXMuZGV2aWNlcy5wdXNoKC4uLmRldmljZSk7XG4gIH1cblxuICAvKipcbiAgICogU3BlY2lmaWVzIHRoZSBjb250YWluZXIgcGF0aCwgbW91bnQgb3B0aW9ucywgYW5kIHNpemUgKGluIE1pQikgb2YgdGhlIHRtcGZzIG1vdW50IGZvciBhIGNvbnRhaW5lci5cbiAgICpcbiAgICogT25seSB3b3JrcyB3aXRoIEVDMiBsYXVuY2ggdHlwZS5cbiAgICovXG4gIHB1YmxpYyBhZGRUbXBmcyguLi50bXBmczogVG1wZnNbXSkge1xuICAgIHRoaXMudG1wZnMucHVzaCguLi50bXBmcyk7XG4gIH1cblxuICAvKipcbiAgICogUmVuZGVycyB0aGUgTGludXggcGFyYW1ldGVycyB0byBhIENsb3VkRm9ybWF0aW9uIG9iamVjdC5cbiAgICovXG4gIHB1YmxpYyByZW5kZXJMaW51eFBhcmFtZXRlcnMoKTogQ2ZuVGFza0RlZmluaXRpb24uTGludXhQYXJhbWV0ZXJzUHJvcGVydHkge1xuICAgIHJldHVybiB7XG4gICAgICBpbml0UHJvY2Vzc0VuYWJsZWQ6IHRoaXMuaW5pdFByb2Nlc3NFbmFibGVkLFxuICAgICAgc2hhcmVkTWVtb3J5U2l6ZTogdGhpcy5zaGFyZWRNZW1vcnlTaXplLFxuICAgICAgY2FwYWJpbGl0aWVzOiB7XG4gICAgICAgIGFkZDogY2RrLkxhenkubGlzdCh7IHByb2R1Y2U6ICgpID0+IHRoaXMuY2FwQWRkIH0sIHsgb21pdEVtcHR5OiB0cnVlIH0pLFxuICAgICAgICBkcm9wOiBjZGsuTGF6eS5saXN0KHsgcHJvZHVjZTogKCkgPT4gdGhpcy5jYXBEcm9wIH0sIHsgb21pdEVtcHR5OiB0cnVlIH0pLFxuICAgICAgfSxcbiAgICAgIGRldmljZXM6IGNkay5MYXp5LmFueSh7IHByb2R1Y2U6ICgpID0+IHRoaXMuZGV2aWNlcy5tYXAocmVuZGVyRGV2aWNlKSB9LCB7IG9taXRFbXB0eUFycmF5OiB0cnVlIH0pLFxuICAgICAgdG1wZnM6IGNkay5MYXp5LmFueSh7IHByb2R1Y2U6ICgpID0+IHRoaXMudG1wZnMubWFwKHJlbmRlclRtcGZzKSB9LCB7IG9taXRFbXB0eUFycmF5OiB0cnVlIH0pLFxuICAgIH07XG4gIH1cbn1cblxuLyoqXG4gKiBBIGNvbnRhaW5lciBpbnN0YW5jZSBob3N0IGRldmljZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEZXZpY2Uge1xuICAvKipcbiAgICogVGhlIHBhdGggaW5zaWRlIHRoZSBjb250YWluZXIgYXQgd2hpY2ggdG8gZXhwb3NlIHRoZSBob3N0IGRldmljZS5cbiAgICpcbiAgICogQGRlZmF1bHQgU2FtZSBwYXRoIGFzIHRoZSBob3N0XG4gICAqL1xuICByZWFkb25seSBjb250YWluZXJQYXRoPzogc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBUaGUgcGF0aCBmb3IgdGhlIGRldmljZSBvbiB0aGUgaG9zdCBjb250YWluZXIgaW5zdGFuY2UuXG4gICAqL1xuICByZWFkb25seSBob3N0UGF0aDogc3RyaW5nLFxuXG4gIC8qKlxuICAgKiBUaGUgZXhwbGljaXQgcGVybWlzc2lvbnMgdG8gcHJvdmlkZSB0byB0aGUgY29udGFpbmVyIGZvciB0aGUgZGV2aWNlLlxuICAgKiBCeSBkZWZhdWx0LCB0aGUgY29udGFpbmVyIGhhcyBwZXJtaXNzaW9ucyBmb3IgcmVhZCwgd3JpdGUsIGFuZCBta25vZCBmb3IgdGhlIGRldmljZS5cbiAgICpcbiAgICogQGRlZmF1bHQgUmVhZG9ubHlcbiAgICovXG4gIHJlYWRvbmx5IHBlcm1pc3Npb25zPzogRGV2aWNlUGVybWlzc2lvbltdXG59XG5cbmZ1bmN0aW9uIHJlbmRlckRldmljZShkZXZpY2U6IERldmljZSk6IENmblRhc2tEZWZpbml0aW9uLkRldmljZVByb3BlcnR5IHtcbiAgcmV0dXJuIHtcbiAgICBjb250YWluZXJQYXRoOiBkZXZpY2UuY29udGFpbmVyUGF0aCxcbiAgICBob3N0UGF0aDogZGV2aWNlLmhvc3RQYXRoLFxuICAgIHBlcm1pc3Npb25zOiBkZXZpY2UucGVybWlzc2lvbnMsXG4gIH07XG59XG5cbi8qKlxuICogVGhlIGRldGFpbHMgb2YgYSB0bXBmcyBtb3VudCBmb3IgYSBjb250YWluZXIuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVG1wZnMge1xuICAvKipcbiAgICogVGhlIGFic29sdXRlIGZpbGUgcGF0aCB3aGVyZSB0aGUgdG1wZnMgdm9sdW1lIGlzIHRvIGJlIG1vdW50ZWQuXG4gICAqL1xuICByZWFkb25seSBjb250YWluZXJQYXRoOiBzdHJpbmcsXG5cbiAgLyoqXG4gICAqIFRoZSBzaXplIChpbiBNaUIpIG9mIHRoZSB0bXBmcyB2b2x1bWUuXG4gICAqL1xuICByZWFkb25seSBzaXplOiBudW1iZXIsXG5cbiAgLyoqXG4gICAqIFRoZSBsaXN0IG9mIHRtcGZzIHZvbHVtZSBtb3VudCBvcHRpb25zLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlXG4gICAqIFtUbXBmc01vdW50T3B0aW9uc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvbkVDUy9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9UbXBmcy5odG1sKS5cbiAgICovXG4gIHJlYWRvbmx5IG1vdW50T3B0aW9ucz86IFRtcGZzTW91bnRPcHRpb25bXSxcbn1cblxuZnVuY3Rpb24gcmVuZGVyVG1wZnModG1wZnM6IFRtcGZzKTogQ2ZuVGFza0RlZmluaXRpb24uVG1wZnNQcm9wZXJ0eSB7XG4gIHJldHVybiB7XG4gICAgY29udGFpbmVyUGF0aDogdG1wZnMuY29udGFpbmVyUGF0aCxcbiAgICBzaXplOiB0bXBmcy5zaXplLFxuICAgIG1vdW50T3B0aW9uczogdG1wZnMubW91bnRPcHRpb25zLFxuICB9O1xufVxuXG4vKipcbiAqIEEgTGludXggY2FwYWJpbGl0eVxuICovXG5leHBvcnQgZW51bSBDYXBhYmlsaXR5IHtcbiAgQUxMID0gJ0FMTCcsXG4gIEFVRElUX0NPTlRST0wgPSAnQVVESVRfQ09OVFJPTCcsXG4gIEFVRElUX1dSSVRFID0gJ0FVRElUX1dSSVRFJyxcbiAgQkxPQ0tfU1VTUEVORCA9ICdCTE9DS19TVVNQRU5EJyxcbiAgQ0hPV04gPSAnQ0hPV04nLFxuICBEQUNfT1ZFUlJJREUgPSAnREFDX09WRVJSSURFJyxcbiAgREFDX1JFQURfU0VBUkNIID0gJ0RBQ19SRUFEX1NFQVJDSCcsXG4gIEZPV05FUiA9ICdGT1dORVInLFxuICBGU0VUSUQgPSAnRlNFVElEJyxcbiAgSVBDX0xPQ0sgPSAnSVBDX0xPQ0snLFxuICBJUENfT1dORVIgPSAnSVBDX09XTkVSJyxcbiAgS0lMTCA9ICdLSUxMJyxcbiAgTEVBU0UgPSAnTEVBU0UnLFxuICBMSU5VWF9JTU1VVEFCTEUgPSAnTElOVVhfSU1NVVRBQkxFJyxcbiAgTUFDX0FETUlOID0gJ01BQ19BRE1JTicsXG4gIE1BQ19PVkVSUklERSA9ICdNQUNfT1ZFUlJJREUnLFxuICBNS05PRCA9ICdNS05PRCcsXG4gIE5FVF9BRE1JTiA9ICdORVRfQURNSU4nLFxuICBORVRfQklORF9TRVJWSUNFID0gJ05FVF9CSU5EX1NFUlZJQ0UnLFxuICBORVRfQlJPQURDQVNUID0gJ05FVF9CUk9BRENBU1QnLFxuICBORVRfUkFXID0gJ05FVF9SQVcnLFxuICBTRVRGQ0FQID0gJ1NFVEZDQVAnLFxuICBTRVRHSUQgPSAnU0VUR0lEJyxcbiAgU0VUUENBUCA9ICdTRVRQQ0FQJyxcbiAgU0VUVUlEID0gJ1NFVFVJRCcsXG4gIFNZU19BRE1JTiA9ICdTWVNfQURNSU4nLFxuICBTWVNfQk9PVCA9ICdTWVNfQk9PVCcsXG4gIFNZU19DSFJPT1QgPSAnU1lTX0NIUk9PVCcsXG4gIFNZU19NT0RVTEUgPSAnU1lTX01PRFVMRScsXG4gIFNZU19OSUNFID0gJ1NZU19OSUNFJyxcbiAgU1lTX1BBQ0NUID0gJ1NZU19QQUNDVCcsXG4gIFNZU19QVFJBQ0UgPSAnU1lTX1BUUkFDRScsXG4gIFNZU19SQVdJTyA9ICdTWVNfUkFXSU8nLFxuICBTWVNfUkVTT1VSQ0UgPSAnU1lTX1JFU09VUkNFJyxcbiAgU1lTX1RJTUUgPSAnU1lTX1RJTUUnLFxuICBTWVNfVFRZX0NPTkZJRyA9ICdTWVNfVFRZX0NPTkZJRycsXG4gIFNZU0xPRyA9ICdTWVNMT0cnLFxuICBXQUtFX0FMQVJNID0gJ1dBS0VfQUxBUk0nXG59XG5cbi8qKlxuICogUGVybWlzc2lvbnMgZm9yIGRldmljZSBhY2Nlc3NcbiAqL1xuZXhwb3J0IGVudW0gRGV2aWNlUGVybWlzc2lvbiB7XG4gIC8qKlxuICAgKiBSZWFkXG4gICAqL1xuICBSRUFEID0gJ3JlYWQnLFxuXG4gIC8qKlxuICAgKiBXcml0ZVxuICAgKi9cbiAgV1JJVEUgPSAnd3JpdGUnLFxuXG4gIC8qKlxuICAgKiBNYWtlIGEgbm9kZVxuICAgKi9cbiAgTUtOT0QgPSAnbWtub2QnLFxufVxuXG4vKipcbiAqIFRoZSBzdXBwb3J0ZWQgb3B0aW9ucyBmb3IgYSB0bXBmcyBtb3VudCBmb3IgYSBjb250YWluZXIuXG4gKi9cbmV4cG9ydCBlbnVtIFRtcGZzTW91bnRPcHRpb24ge1xuICBERUZBVUxUUyA9ICdkZWZhdWx0cycsXG4gIFJPID0gJ3JvJyxcbiAgUlcgPSAncncnLFxuICBTVUlEID0gJ3N1aWQnLFxuICBOT1NVSUQgPSAnbm9zdWlkJyxcbiAgREVWID0gJ2RldicsXG4gIE5PREVWID0gJ25vZGV2JyxcbiAgRVhFQyA9ICdleGVjJyxcbiAgTk9FWEVDID0gJ25vZXhlYycsXG4gIFNZTkMgPSAnc3luYycsXG4gIEFTWU5DID0gJ2FzeW5jJyxcbiAgRElSU1lOQyA9ICdkaXJzeW5jJyxcbiAgUkVNT1VOVCA9ICdyZW1vdW50JyxcbiAgTUFORCA9ICdtYW5kJyxcbiAgTk9NQU5EID0gJ25vbWFuZCcsXG4gIEFUSU1FID0gJ2F0aW1lJyxcbiAgTk9BVElNRSA9ICdub2F0aW1lJyxcbiAgRElSQVRJTUUgPSAnZGlyYXRpbWUnLFxuICBOT0RJUkFUSU1FID0gJ25vZGlyYXRpbWUnLFxuICBCSU5EID0gJ2JpbmQnLFxuICBSQklORCA9ICdyYmluZCcsXG4gIFVOQklOREFCTEUgPSAndW5iaW5kYWJsZScsXG4gIFJVTkJJTkRBQkxFID0gJ3J1bmJpbmRhYmxlJyxcbiAgUFJJVkFURSA9ICdwcml2YXRlJyxcbiAgUlBSSVZBVEUgPSAncnByaXZhdGUnLFxuICBTSEFSRUQgPSAnc2hhcmVkJyxcbiAgUlNIQVJFRCA9ICdyc2hhcmVkJyxcbiAgU0xBVkUgPSAnc2xhdmUnLFxuICBSU0xBVkUgPSAncnNsYXZlJyxcbiAgUkVMQVRJTUUgPSAncmVsYXRpbWUnLFxuICBOT1JFTEFUSU1FID0gJ25vcmVsYXRpbWUnLFxuICBTVFJJQ1RBVElNRSA9ICdzdHJpY3RhdGltZScsXG4gIE5PU1RSSUNUQVRJTUUgPSAnbm9zdHJpY3RhdGltZScsXG4gIE1PREUgPSAnbW9kZScsXG4gIFVJRCA9ICd1aWQnLFxuICBHSUQgPSAnZ2lkJyxcbiAgTlJfSU5PREVTID0gJ25yX2lub2RlcycsXG4gIE5SX0JMT0NLUyA9ICducl9ibG9ja3MnLFxuICBNUE9MID0gJ21wb2wnXG59XG4iXX0=