"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagParameterContainerImage = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../../core");
const container_image_1 = require("../container-image");
/**
 * A special type of {@link ContainerImage} that uses an ECR repository for the image,
 * but a CloudFormation Parameter for the tag of the image in that repository.
 * This allows providing this tag through the Parameter at deploy time,
 * for example in a CodePipeline that pushes a new tag of the image to the repository during a build step,
 * and then provides that new tag through the CloudFormation Parameter in the deploy step.
 *
 * @see #tagParameterName
 */
class TagParameterContainerImage extends container_image_1.ContainerImage {
    constructor(repository) {
        super();
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecr_IRepository(repository);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TagParameterContainerImage);
            }
            throw error;
        }
        this.repository = repository;
    }
    bind(scope, containerDefinition) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
        const imageTagParameter = new cdk.CfnParameter(scope, 'ImageTagParam');
        this.imageTagParameter = imageTagParameter;
        return {
            imageName: this.repository.repositoryUriForTag(imageTagParameter.valueAsString),
        };
    }
    /**
     * Returns the name of the CloudFormation Parameter that represents the tag of the image
     * in the ECR repository.
     */
    get tagParameterName() {
        return cdk.Lazy.string({
            produce: () => {
                if (this.imageTagParameter) {
                    return this.imageTagParameter.logicalId;
                }
                else {
                    throw new Error('TagParameterContainerImage must be used in a container definition when using tagParameterName');
                }
            },
        });
    }
    /**
     * Returns the value of the CloudFormation Parameter that represents the tag of the image
     * in the ECR repository.
     */
    get tagParameterValue() {
        return cdk.Lazy.string({
            produce: () => {
                if (this.imageTagParameter) {
                    return this.imageTagParameter.valueAsString;
                }
                else {
                    throw new Error('TagParameterContainerImage must be used in a container definition when using tagParameterValue');
                }
            },
        });
    }
}
exports.TagParameterContainerImage = TagParameterContainerImage;
_a = JSII_RTTI_SYMBOL_1;
TagParameterContainerImage[_a] = { fqn: "monocdk.aws_ecs.TagParameterContainerImage", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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