"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExternalService = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const base_service_1 = require("../base/base-service");
const from_service_attributes_1 = require("../base/from-service-attributes");
const task_definition_1 = require("../base/task-definition");
/**
 * This creates a service using the External launch type on an ECS cluster.
 *
 * @resource AWS::ECS::Service
 */
class ExternalService extends base_service_1.BaseService {
    /**
     * Constructs a new instance of the ExternalService class.
     */
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_ExternalServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ExternalService);
            }
            throw error;
        }
        if (props.minHealthyPercent !== undefined && props.maxHealthyPercent !== undefined && props.minHealthyPercent >= props.maxHealthyPercent) {
            throw new Error('Minimum healthy percent must be less than maximum healthy percent.');
        }
        if (props.taskDefinition.compatibility !== task_definition_1.Compatibility.EXTERNAL) {
            throw new Error('Supplied TaskDefinition is not configured for compatibility with ECS Anywhere cluster');
        }
        if (props.cluster.defaultCloudMapNamespace !== undefined) {
            throw new Error(`Cloud map integration is not supported for External service ${props.cluster.defaultCloudMapNamespace}`);
        }
        if (props.cloudMapOptions !== undefined) {
            throw new Error('Cloud map options are not supported for External service');
        }
        if (props.enableExecuteCommand !== undefined) {
            throw new Error('Enable Execute Command options are not supported for External service');
        }
        if (props.capacityProviderStrategies !== undefined) {
            throw new Error('Capacity Providers are not supported for External service');
        }
        const propagateTagsFromSource = props.propagateTags ?? base_service_1.PropagatedTagSource.NONE;
        super(scope, id, {
            ...props,
            desiredCount: props.desiredCount,
            maxHealthyPercent: props.maxHealthyPercent === undefined ? 100 : props.maxHealthyPercent,
            minHealthyPercent: props.minHealthyPercent === undefined ? 0 : props.minHealthyPercent,
            launchType: base_service_1.LaunchType.EXTERNAL,
            propagateTags: propagateTagsFromSource,
            enableECSManagedTags: props.enableECSManagedTags,
        }, {
            cluster: props.cluster.clusterName,
            taskDefinition: props.deploymentController?.type === base_service_1.DeploymentControllerType.EXTERNAL ? undefined : props.taskDefinition.taskDefinitionArn,
        }, props.taskDefinition);
        this.node.addValidation({
            validate: () => !this.taskDefinition.defaultContainer ? ['A TaskDefinition must have at least one essential container'] : [],
        });
        this.node.addValidation({
            validate: () => this.networkConfiguration !== undefined ? ['Network configurations not supported for an external service'] : [],
        });
    }
    /**
     * Imports from the specified service ARN.
     */
    static fromExternalServiceArn(scope, id, externalServiceArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = externalServiceArn;
                this.serviceName = core_1.Stack.of(scope).splitArn(externalServiceArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports from the specified service attributes.
     */
    static fromExternalServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_ExternalServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromExternalServiceAttributes);
            }
            throw error;
        }
        return from_service_attributes_1.fromServiceAttributes(scope, id, attrs);
    }
    /**
     * Overriden method to throw error as `attachToApplicationTargetGroup` is not supported for external service
     */
    attachToApplicationTargetGroup(_targetGroup) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_IApplicationTargetGroup(_targetGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attachToApplicationTargetGroup);
            }
            throw error;
        }
        throw new Error('Application load balancer cannot be attached to an external service');
    }
    /**
     * Overriden method to throw error as `loadBalancerTarget` is not supported for external service
     */
    loadBalancerTarget(_options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_LoadBalancerTargetOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.loadBalancerTarget);
            }
            throw error;
        }
        throw new Error('External service cannot be attached as load balancer targets');
    }
    /**
     * Overriden method to throw error as `registerLoadBalancerTargets` is not supported for external service
     */
    registerLoadBalancerTargets(..._targets) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_EcsTarget(_targets);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.registerLoadBalancerTargets);
            }
            throw error;
        }
        throw new Error('External service cannot be registered as load balancer targets');
    }
    /**
     * Overriden method to throw error as `configureAwsVpcNetworkingWithSecurityGroups` is not supported for external service
     */
    // eslint-disable-next-line max-len, no-unused-vars
    configureAwsVpcNetworkingWithSecurityGroups(_vpc, _assignPublicIp, _vpcSubnets, _securityGroups) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ec2_IVpc(_vpc);
            jsiiDeprecationWarnings.monocdk_aws_ec2_SubnetSelection(_vpcSubnets);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.configureAwsVpcNetworkingWithSecurityGroups);
            }
            throw error;
        }
        throw new Error('Only Bridge network mode is supported for external service');
    }
    /**
     * Overriden method to throw error as `autoScaleTaskCount` is not supported for external service
     */
    autoScaleTaskCount(_props) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_applicationautoscaling_EnableScalingProps(_props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.autoScaleTaskCount);
            }
            throw error;
        }
        throw new Error('Autoscaling not supported for external service');
    }
    /**
     * Overriden method to throw error as `enableCloudMap` is not supported for external service
     */
    enableCloudMap(_options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_CloudMapOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.enableCloudMap);
            }
            throw error;
        }
        throw new Error('Cloud map integration not supported for an external service');
    }
    /**
     * Overriden method to throw error as `associateCloudMapService` is not supported for external service
     */
    associateCloudMapService(_options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_AssociateCloudMapServiceOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.associateCloudMapService);
            }
            throw error;
        }
        throw new Error('Cloud map service association is not supported for an external service');
    }
}
exports.ExternalService = ExternalService;
_a = JSII_RTTI_SYMBOL_1;
ExternalService[_a] = { fqn: "monocdk.aws_ecs.ExternalService", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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