"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecret = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secretsmanager_1 = require("../../aws-secretsmanager");
const core_1 = require("../../core");
/**
 *
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends aws_secretsmanager_1.Secret {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_docdb_DatabaseSecretProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DatabaseSecret);
            }
            throw error;
        }
        const excludedCharacters = props.excludeCharacters ?? '"@/';
        super(scope, id, {
            secretName: props.secretName,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            encryptionKey: props.encryptionKey,
            // The CloudFormation resource provider for AWS::DocDB::DBCluster currently limits the DocDB master password to
            // 41 characters when pulling the password from secrets manager using a CloudFormation reference. This does not
            // line up with the CloudFormation resource specification which states a maximum of 100 characters:
            //
            // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-masteruserpassword
            //
            // When attempting to exceed 41 characters, a deployment fails with the message:
            // Length of value for property {/MasterUserPassword} is greater than maximum allowed length {41}
            generateSecretString: {
                passwordLength: 41,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: props.masterSecret?.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters: excludedCharacters,
            },
        });
        this._excludedCharacters = excludedCharacters;
    }
}
exports.DatabaseSecret = DatabaseSecret;
_a = JSII_RTTI_SYMBOL_1;
DatabaseSecret[_a] = { fqn: "monocdk.aws_docdb.DatabaseSecret", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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