"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnReplicationTask = exports.CfnReplicationSubnetGroup = exports.CfnReplicationInstance = exports.CfnEventSubscription = exports.CfnEndpoint = exports.CfnCertificate = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-12-27T19:34:44.244Z","fingerprint":"BR9bdxJFkoEzrEMwuPIKNJuCTIaHeKN8njNkPl2uRxk="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnCertificateProps`
 *
 * @param properties - the TypeScript properties of a `CfnCertificateProps`
 *
 * @returns the result of the validation.
 */
function CfnCertificatePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('certificateIdentifier', cdk.validateString)(properties.certificateIdentifier));
    errors.collect(cdk.propertyValidator('certificatePem', cdk.validateString)(properties.certificatePem));
    errors.collect(cdk.propertyValidator('certificateWallet', cdk.validateString)(properties.certificateWallet));
    return errors.wrap('supplied properties not correct for "CfnCertificateProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Certificate` resource
 *
 * @param properties - the TypeScript properties of a `CfnCertificateProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Certificate` resource.
 */
// @ts-ignore TS6133
function cfnCertificatePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCertificatePropsValidator(properties).assertSuccess();
    return {
        CertificateIdentifier: cdk.stringToCloudFormation(properties.certificateIdentifier),
        CertificatePem: cdk.stringToCloudFormation(properties.certificatePem),
        CertificateWallet: cdk.stringToCloudFormation(properties.certificateWallet),
    };
}
// @ts-ignore TS6133
function CfnCertificatePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('certificateIdentifier', 'CertificateIdentifier', properties.CertificateIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.CertificateIdentifier) : undefined);
    ret.addPropertyResult('certificatePem', 'CertificatePem', properties.CertificatePem != null ? cfn_parse.FromCloudFormation.getString(properties.CertificatePem) : undefined);
    ret.addPropertyResult('certificateWallet', 'CertificateWallet', properties.CertificateWallet != null ? cfn_parse.FromCloudFormation.getString(properties.CertificateWallet) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::Certificate`
 *
 * The `AWS::DMS::Certificate` resource creates an Secure Sockets Layer (SSL) certificate that encrypts connections between AWS DMS endpoints and the replication instance.
 *
 * @cloudformationResource AWS::DMS::Certificate
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html
 */
class CfnCertificate extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::Certificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnCertificate.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_dms_CfnCertificateProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnCertificate);
            }
            throw error;
        }
        this.certificateIdentifier = props.certificateIdentifier;
        this.certificatePem = props.certificatePem;
        this.certificateWallet = props.certificateWallet;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnCertificatePropsFromCloudFormation(resourceProperties);
        const ret = new CfnCertificate(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnCertificate.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            certificateIdentifier: this.certificateIdentifier,
            certificatePem: this.certificatePem,
            certificateWallet: this.certificateWallet,
        };
    }
    renderProperties(props) {
        return cfnCertificatePropsToCloudFormation(props);
    }
}
exports.CfnCertificate = CfnCertificate;
_a = JSII_RTTI_SYMBOL_1;
CfnCertificate[_a] = { fqn: "monocdk.aws_dms.CfnCertificate", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnCertificate.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::Certificate";
/**
 * Determine whether the given properties match those of a `CfnEndpointProps`
 *
 * @param properties - the TypeScript properties of a `CfnEndpointProps`
 *
 * @returns the result of the validation.
 */
function CfnEndpointPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('certificateArn', cdk.validateString)(properties.certificateArn));
    errors.collect(cdk.propertyValidator('databaseName', cdk.validateString)(properties.databaseName));
    errors.collect(cdk.propertyValidator('docDbSettings', CfnEndpoint_DocDbSettingsPropertyValidator)(properties.docDbSettings));
    errors.collect(cdk.propertyValidator('dynamoDbSettings', CfnEndpoint_DynamoDbSettingsPropertyValidator)(properties.dynamoDbSettings));
    errors.collect(cdk.propertyValidator('elasticsearchSettings', CfnEndpoint_ElasticsearchSettingsPropertyValidator)(properties.elasticsearchSettings));
    errors.collect(cdk.propertyValidator('endpointIdentifier', cdk.validateString)(properties.endpointIdentifier));
    errors.collect(cdk.propertyValidator('endpointType', cdk.requiredValidator)(properties.endpointType));
    errors.collect(cdk.propertyValidator('endpointType', cdk.validateString)(properties.endpointType));
    errors.collect(cdk.propertyValidator('engineName', cdk.requiredValidator)(properties.engineName));
    errors.collect(cdk.propertyValidator('engineName', cdk.validateString)(properties.engineName));
    errors.collect(cdk.propertyValidator('extraConnectionAttributes', cdk.validateString)(properties.extraConnectionAttributes));
    errors.collect(cdk.propertyValidator('gcpMySqlSettings', CfnEndpoint_GcpMySQLSettingsPropertyValidator)(properties.gcpMySqlSettings));
    errors.collect(cdk.propertyValidator('ibmDb2Settings', CfnEndpoint_IbmDb2SettingsPropertyValidator)(properties.ibmDb2Settings));
    errors.collect(cdk.propertyValidator('kafkaSettings', CfnEndpoint_KafkaSettingsPropertyValidator)(properties.kafkaSettings));
    errors.collect(cdk.propertyValidator('kinesisSettings', CfnEndpoint_KinesisSettingsPropertyValidator)(properties.kinesisSettings));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('microsoftSqlServerSettings', CfnEndpoint_MicrosoftSqlServerSettingsPropertyValidator)(properties.microsoftSqlServerSettings));
    errors.collect(cdk.propertyValidator('mongoDbSettings', CfnEndpoint_MongoDbSettingsPropertyValidator)(properties.mongoDbSettings));
    errors.collect(cdk.propertyValidator('mySqlSettings', CfnEndpoint_MySqlSettingsPropertyValidator)(properties.mySqlSettings));
    errors.collect(cdk.propertyValidator('neptuneSettings', CfnEndpoint_NeptuneSettingsPropertyValidator)(properties.neptuneSettings));
    errors.collect(cdk.propertyValidator('oracleSettings', CfnEndpoint_OracleSettingsPropertyValidator)(properties.oracleSettings));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('postgreSqlSettings', CfnEndpoint_PostgreSqlSettingsPropertyValidator)(properties.postgreSqlSettings));
    errors.collect(cdk.propertyValidator('redisSettings', CfnEndpoint_RedisSettingsPropertyValidator)(properties.redisSettings));
    errors.collect(cdk.propertyValidator('redshiftSettings', CfnEndpoint_RedshiftSettingsPropertyValidator)(properties.redshiftSettings));
    errors.collect(cdk.propertyValidator('resourceIdentifier', cdk.validateString)(properties.resourceIdentifier));
    errors.collect(cdk.propertyValidator('s3Settings', CfnEndpoint_S3SettingsPropertyValidator)(properties.s3Settings));
    errors.collect(cdk.propertyValidator('serverName', cdk.validateString)(properties.serverName));
    errors.collect(cdk.propertyValidator('sslMode', cdk.validateString)(properties.sslMode));
    errors.collect(cdk.propertyValidator('sybaseSettings', CfnEndpoint_SybaseSettingsPropertyValidator)(properties.sybaseSettings));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "CfnEndpointProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint` resource
 *
 * @param properties - the TypeScript properties of a `CfnEndpointProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint` resource.
 */
// @ts-ignore TS6133
function cfnEndpointPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointPropsValidator(properties).assertSuccess();
    return {
        EndpointType: cdk.stringToCloudFormation(properties.endpointType),
        EngineName: cdk.stringToCloudFormation(properties.engineName),
        CertificateArn: cdk.stringToCloudFormation(properties.certificateArn),
        DatabaseName: cdk.stringToCloudFormation(properties.databaseName),
        DocDbSettings: cfnEndpointDocDbSettingsPropertyToCloudFormation(properties.docDbSettings),
        DynamoDbSettings: cfnEndpointDynamoDbSettingsPropertyToCloudFormation(properties.dynamoDbSettings),
        ElasticsearchSettings: cfnEndpointElasticsearchSettingsPropertyToCloudFormation(properties.elasticsearchSettings),
        EndpointIdentifier: cdk.stringToCloudFormation(properties.endpointIdentifier),
        ExtraConnectionAttributes: cdk.stringToCloudFormation(properties.extraConnectionAttributes),
        GcpMySQLSettings: cfnEndpointGcpMySQLSettingsPropertyToCloudFormation(properties.gcpMySqlSettings),
        IbmDb2Settings: cfnEndpointIbmDb2SettingsPropertyToCloudFormation(properties.ibmDb2Settings),
        KafkaSettings: cfnEndpointKafkaSettingsPropertyToCloudFormation(properties.kafkaSettings),
        KinesisSettings: cfnEndpointKinesisSettingsPropertyToCloudFormation(properties.kinesisSettings),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MicrosoftSqlServerSettings: cfnEndpointMicrosoftSqlServerSettingsPropertyToCloudFormation(properties.microsoftSqlServerSettings),
        MongoDbSettings: cfnEndpointMongoDbSettingsPropertyToCloudFormation(properties.mongoDbSettings),
        MySqlSettings: cfnEndpointMySqlSettingsPropertyToCloudFormation(properties.mySqlSettings),
        NeptuneSettings: cfnEndpointNeptuneSettingsPropertyToCloudFormation(properties.neptuneSettings),
        OracleSettings: cfnEndpointOracleSettingsPropertyToCloudFormation(properties.oracleSettings),
        Password: cdk.stringToCloudFormation(properties.password),
        Port: cdk.numberToCloudFormation(properties.port),
        PostgreSqlSettings: cfnEndpointPostgreSqlSettingsPropertyToCloudFormation(properties.postgreSqlSettings),
        RedisSettings: cfnEndpointRedisSettingsPropertyToCloudFormation(properties.redisSettings),
        RedshiftSettings: cfnEndpointRedshiftSettingsPropertyToCloudFormation(properties.redshiftSettings),
        ResourceIdentifier: cdk.stringToCloudFormation(properties.resourceIdentifier),
        S3Settings: cfnEndpointS3SettingsPropertyToCloudFormation(properties.s3Settings),
        ServerName: cdk.stringToCloudFormation(properties.serverName),
        SslMode: cdk.stringToCloudFormation(properties.sslMode),
        SybaseSettings: cfnEndpointSybaseSettingsPropertyToCloudFormation(properties.sybaseSettings),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        Username: cdk.stringToCloudFormation(properties.username),
    };
}
// @ts-ignore TS6133
function CfnEndpointPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endpointType', 'EndpointType', cfn_parse.FromCloudFormation.getString(properties.EndpointType));
    ret.addPropertyResult('engineName', 'EngineName', cfn_parse.FromCloudFormation.getString(properties.EngineName));
    ret.addPropertyResult('certificateArn', 'CertificateArn', properties.CertificateArn != null ? cfn_parse.FromCloudFormation.getString(properties.CertificateArn) : undefined);
    ret.addPropertyResult('databaseName', 'DatabaseName', properties.DatabaseName != null ? cfn_parse.FromCloudFormation.getString(properties.DatabaseName) : undefined);
    ret.addPropertyResult('docDbSettings', 'DocDbSettings', properties.DocDbSettings != null ? CfnEndpointDocDbSettingsPropertyFromCloudFormation(properties.DocDbSettings) : undefined);
    ret.addPropertyResult('dynamoDbSettings', 'DynamoDbSettings', properties.DynamoDbSettings != null ? CfnEndpointDynamoDbSettingsPropertyFromCloudFormation(properties.DynamoDbSettings) : undefined);
    ret.addPropertyResult('elasticsearchSettings', 'ElasticsearchSettings', properties.ElasticsearchSettings != null ? CfnEndpointElasticsearchSettingsPropertyFromCloudFormation(properties.ElasticsearchSettings) : undefined);
    ret.addPropertyResult('endpointIdentifier', 'EndpointIdentifier', properties.EndpointIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointIdentifier) : undefined);
    ret.addPropertyResult('extraConnectionAttributes', 'ExtraConnectionAttributes', properties.ExtraConnectionAttributes != null ? cfn_parse.FromCloudFormation.getString(properties.ExtraConnectionAttributes) : undefined);
    ret.addPropertyResult('gcpMySqlSettings', 'GcpMySQLSettings', properties.GcpMySQLSettings != null ? CfnEndpointGcpMySQLSettingsPropertyFromCloudFormation(properties.GcpMySQLSettings) : undefined);
    ret.addPropertyResult('ibmDb2Settings', 'IbmDb2Settings', properties.IbmDb2Settings != null ? CfnEndpointIbmDb2SettingsPropertyFromCloudFormation(properties.IbmDb2Settings) : undefined);
    ret.addPropertyResult('kafkaSettings', 'KafkaSettings', properties.KafkaSettings != null ? CfnEndpointKafkaSettingsPropertyFromCloudFormation(properties.KafkaSettings) : undefined);
    ret.addPropertyResult('kinesisSettings', 'KinesisSettings', properties.KinesisSettings != null ? CfnEndpointKinesisSettingsPropertyFromCloudFormation(properties.KinesisSettings) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('microsoftSqlServerSettings', 'MicrosoftSqlServerSettings', properties.MicrosoftSqlServerSettings != null ? CfnEndpointMicrosoftSqlServerSettingsPropertyFromCloudFormation(properties.MicrosoftSqlServerSettings) : undefined);
    ret.addPropertyResult('mongoDbSettings', 'MongoDbSettings', properties.MongoDbSettings != null ? CfnEndpointMongoDbSettingsPropertyFromCloudFormation(properties.MongoDbSettings) : undefined);
    ret.addPropertyResult('mySqlSettings', 'MySqlSettings', properties.MySqlSettings != null ? CfnEndpointMySqlSettingsPropertyFromCloudFormation(properties.MySqlSettings) : undefined);
    ret.addPropertyResult('neptuneSettings', 'NeptuneSettings', properties.NeptuneSettings != null ? CfnEndpointNeptuneSettingsPropertyFromCloudFormation(properties.NeptuneSettings) : undefined);
    ret.addPropertyResult('oracleSettings', 'OracleSettings', properties.OracleSettings != null ? CfnEndpointOracleSettingsPropertyFromCloudFormation(properties.OracleSettings) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('postgreSqlSettings', 'PostgreSqlSettings', properties.PostgreSqlSettings != null ? CfnEndpointPostgreSqlSettingsPropertyFromCloudFormation(properties.PostgreSqlSettings) : undefined);
    ret.addPropertyResult('redisSettings', 'RedisSettings', properties.RedisSettings != null ? CfnEndpointRedisSettingsPropertyFromCloudFormation(properties.RedisSettings) : undefined);
    ret.addPropertyResult('redshiftSettings', 'RedshiftSettings', properties.RedshiftSettings != null ? CfnEndpointRedshiftSettingsPropertyFromCloudFormation(properties.RedshiftSettings) : undefined);
    ret.addPropertyResult('resourceIdentifier', 'ResourceIdentifier', properties.ResourceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceIdentifier) : undefined);
    ret.addPropertyResult('s3Settings', 'S3Settings', properties.S3Settings != null ? CfnEndpointS3SettingsPropertyFromCloudFormation(properties.S3Settings) : undefined);
    ret.addPropertyResult('serverName', 'ServerName', properties.ServerName != null ? cfn_parse.FromCloudFormation.getString(properties.ServerName) : undefined);
    ret.addPropertyResult('sslMode', 'SslMode', properties.SslMode != null ? cfn_parse.FromCloudFormation.getString(properties.SslMode) : undefined);
    ret.addPropertyResult('sybaseSettings', 'SybaseSettings', properties.SybaseSettings != null ? CfnEndpointSybaseSettingsPropertyFromCloudFormation(properties.SybaseSettings) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('username', 'Username', properties.Username != null ? cfn_parse.FromCloudFormation.getString(properties.Username) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::Endpoint`
 *
 * The `AWS::DMS::Endpoint` resource specifies an AWS DMS endpoint.
 *
 * Currently, AWS CloudFormation supports all AWS DMS endpoint types.
 *
 * @cloudformationResource AWS::DMS::Endpoint
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 */
class CfnEndpoint extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::Endpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnEndpoint.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_dms_CfnEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnEndpoint);
            }
            throw error;
        }
        cdk.requireProperty(props, 'endpointType', this);
        cdk.requireProperty(props, 'engineName', this);
        this.attrExternalId = cdk.Token.asString(this.getAtt('ExternalId'));
        this.endpointType = props.endpointType;
        this.engineName = props.engineName;
        this.certificateArn = props.certificateArn;
        this.databaseName = props.databaseName;
        this.docDbSettings = props.docDbSettings;
        this.dynamoDbSettings = props.dynamoDbSettings;
        this.elasticsearchSettings = props.elasticsearchSettings;
        this.endpointIdentifier = props.endpointIdentifier;
        this.extraConnectionAttributes = props.extraConnectionAttributes;
        this.gcpMySqlSettings = props.gcpMySqlSettings;
        this.ibmDb2Settings = props.ibmDb2Settings;
        this.kafkaSettings = props.kafkaSettings;
        this.kinesisSettings = props.kinesisSettings;
        this.kmsKeyId = props.kmsKeyId;
        this.microsoftSqlServerSettings = props.microsoftSqlServerSettings;
        this.mongoDbSettings = props.mongoDbSettings;
        this.mySqlSettings = props.mySqlSettings;
        this.neptuneSettings = props.neptuneSettings;
        this.oracleSettings = props.oracleSettings;
        this.password = props.password;
        this.port = props.port;
        this.postgreSqlSettings = props.postgreSqlSettings;
        this.redisSettings = props.redisSettings;
        this.redshiftSettings = props.redshiftSettings;
        this.resourceIdentifier = props.resourceIdentifier;
        this.s3Settings = props.s3Settings;
        this.serverName = props.serverName;
        this.sslMode = props.sslMode;
        this.sybaseSettings = props.sybaseSettings;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DMS::Endpoint", props.tags, { tagPropertyName: 'tags' });
        this.username = props.username;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEndpointPropsFromCloudFormation(resourceProperties);
        const ret = new CfnEndpoint(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEndpoint.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            endpointType: this.endpointType,
            engineName: this.engineName,
            certificateArn: this.certificateArn,
            databaseName: this.databaseName,
            docDbSettings: this.docDbSettings,
            dynamoDbSettings: this.dynamoDbSettings,
            elasticsearchSettings: this.elasticsearchSettings,
            endpointIdentifier: this.endpointIdentifier,
            extraConnectionAttributes: this.extraConnectionAttributes,
            gcpMySqlSettings: this.gcpMySqlSettings,
            ibmDb2Settings: this.ibmDb2Settings,
            kafkaSettings: this.kafkaSettings,
            kinesisSettings: this.kinesisSettings,
            kmsKeyId: this.kmsKeyId,
            microsoftSqlServerSettings: this.microsoftSqlServerSettings,
            mongoDbSettings: this.mongoDbSettings,
            mySqlSettings: this.mySqlSettings,
            neptuneSettings: this.neptuneSettings,
            oracleSettings: this.oracleSettings,
            password: this.password,
            port: this.port,
            postgreSqlSettings: this.postgreSqlSettings,
            redisSettings: this.redisSettings,
            redshiftSettings: this.redshiftSettings,
            resourceIdentifier: this.resourceIdentifier,
            s3Settings: this.s3Settings,
            serverName: this.serverName,
            sslMode: this.sslMode,
            sybaseSettings: this.sybaseSettings,
            tags: this.tags.renderTags(),
            username: this.username,
        };
    }
    renderProperties(props) {
        return cfnEndpointPropsToCloudFormation(props);
    }
}
exports.CfnEndpoint = CfnEndpoint;
_b = JSII_RTTI_SYMBOL_1;
CfnEndpoint[_b] = { fqn: "monocdk.aws_dms.CfnEndpoint", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEndpoint.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::Endpoint";
/**
 * Determine whether the given properties match those of a `DocDbSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `DocDbSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_DocDbSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('docsToInvestigate', cdk.validateNumber)(properties.docsToInvestigate));
    errors.collect(cdk.propertyValidator('extractDocId', cdk.validateBoolean)(properties.extractDocId));
    errors.collect(cdk.propertyValidator('nestingLevel', cdk.validateString)(properties.nestingLevel));
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    return errors.wrap('supplied properties not correct for "DocDbSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.DocDbSettings` resource
 *
 * @param properties - the TypeScript properties of a `DocDbSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.DocDbSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointDocDbSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_DocDbSettingsPropertyValidator(properties).assertSuccess();
    return {
        DocsToInvestigate: cdk.numberToCloudFormation(properties.docsToInvestigate),
        ExtractDocId: cdk.booleanToCloudFormation(properties.extractDocId),
        NestingLevel: cdk.stringToCloudFormation(properties.nestingLevel),
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
    };
}
// @ts-ignore TS6133
function CfnEndpointDocDbSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('docsToInvestigate', 'DocsToInvestigate', properties.DocsToInvestigate != null ? cfn_parse.FromCloudFormation.getNumber(properties.DocsToInvestigate) : undefined);
    ret.addPropertyResult('extractDocId', 'ExtractDocId', properties.ExtractDocId != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ExtractDocId) : undefined);
    ret.addPropertyResult('nestingLevel', 'NestingLevel', properties.NestingLevel != null ? cfn_parse.FromCloudFormation.getString(properties.NestingLevel) : undefined);
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DynamoDbSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `DynamoDbSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_DynamoDbSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('serviceAccessRoleArn', cdk.validateString)(properties.serviceAccessRoleArn));
    return errors.wrap('supplied properties not correct for "DynamoDbSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.DynamoDbSettings` resource
 *
 * @param properties - the TypeScript properties of a `DynamoDbSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.DynamoDbSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointDynamoDbSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_DynamoDbSettingsPropertyValidator(properties).assertSuccess();
    return {
        ServiceAccessRoleArn: cdk.stringToCloudFormation(properties.serviceAccessRoleArn),
    };
}
// @ts-ignore TS6133
function CfnEndpointDynamoDbSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('serviceAccessRoleArn', 'ServiceAccessRoleArn', properties.ServiceAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceAccessRoleArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ElasticsearchSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `ElasticsearchSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_ElasticsearchSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endpointUri', cdk.validateString)(properties.endpointUri));
    errors.collect(cdk.propertyValidator('errorRetryDuration', cdk.validateNumber)(properties.errorRetryDuration));
    errors.collect(cdk.propertyValidator('fullLoadErrorPercentage', cdk.validateNumber)(properties.fullLoadErrorPercentage));
    errors.collect(cdk.propertyValidator('serviceAccessRoleArn', cdk.validateString)(properties.serviceAccessRoleArn));
    return errors.wrap('supplied properties not correct for "ElasticsearchSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.ElasticsearchSettings` resource
 *
 * @param properties - the TypeScript properties of a `ElasticsearchSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.ElasticsearchSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointElasticsearchSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_ElasticsearchSettingsPropertyValidator(properties).assertSuccess();
    return {
        EndpointUri: cdk.stringToCloudFormation(properties.endpointUri),
        ErrorRetryDuration: cdk.numberToCloudFormation(properties.errorRetryDuration),
        FullLoadErrorPercentage: cdk.numberToCloudFormation(properties.fullLoadErrorPercentage),
        ServiceAccessRoleArn: cdk.stringToCloudFormation(properties.serviceAccessRoleArn),
    };
}
// @ts-ignore TS6133
function CfnEndpointElasticsearchSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endpointUri', 'EndpointUri', properties.EndpointUri != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointUri) : undefined);
    ret.addPropertyResult('errorRetryDuration', 'ErrorRetryDuration', properties.ErrorRetryDuration != null ? cfn_parse.FromCloudFormation.getNumber(properties.ErrorRetryDuration) : undefined);
    ret.addPropertyResult('fullLoadErrorPercentage', 'FullLoadErrorPercentage', properties.FullLoadErrorPercentage != null ? cfn_parse.FromCloudFormation.getNumber(properties.FullLoadErrorPercentage) : undefined);
    ret.addPropertyResult('serviceAccessRoleArn', 'ServiceAccessRoleArn', properties.ServiceAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceAccessRoleArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GcpMySQLSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `GcpMySQLSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_GcpMySQLSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('afterConnectScript', cdk.validateString)(properties.afterConnectScript));
    errors.collect(cdk.propertyValidator('cleanSourceMetadataOnMismatch', cdk.validateBoolean)(properties.cleanSourceMetadataOnMismatch));
    errors.collect(cdk.propertyValidator('databaseName', cdk.validateString)(properties.databaseName));
    errors.collect(cdk.propertyValidator('eventsPollInterval', cdk.validateNumber)(properties.eventsPollInterval));
    errors.collect(cdk.propertyValidator('maxFileSize', cdk.validateNumber)(properties.maxFileSize));
    errors.collect(cdk.propertyValidator('parallelLoadThreads', cdk.validateNumber)(properties.parallelLoadThreads));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    errors.collect(cdk.propertyValidator('serverName', cdk.validateString)(properties.serverName));
    errors.collect(cdk.propertyValidator('serverTimezone', cdk.validateString)(properties.serverTimezone));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "GcpMySQLSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.GcpMySQLSettings` resource
 *
 * @param properties - the TypeScript properties of a `GcpMySQLSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.GcpMySQLSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointGcpMySQLSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_GcpMySQLSettingsPropertyValidator(properties).assertSuccess();
    return {
        AfterConnectScript: cdk.stringToCloudFormation(properties.afterConnectScript),
        CleanSourceMetadataOnMismatch: cdk.booleanToCloudFormation(properties.cleanSourceMetadataOnMismatch),
        DatabaseName: cdk.stringToCloudFormation(properties.databaseName),
        EventsPollInterval: cdk.numberToCloudFormation(properties.eventsPollInterval),
        MaxFileSize: cdk.numberToCloudFormation(properties.maxFileSize),
        ParallelLoadThreads: cdk.numberToCloudFormation(properties.parallelLoadThreads),
        Password: cdk.stringToCloudFormation(properties.password),
        Port: cdk.numberToCloudFormation(properties.port),
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
        ServerName: cdk.stringToCloudFormation(properties.serverName),
        ServerTimezone: cdk.stringToCloudFormation(properties.serverTimezone),
        Username: cdk.stringToCloudFormation(properties.username),
    };
}
// @ts-ignore TS6133
function CfnEndpointGcpMySQLSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('afterConnectScript', 'AfterConnectScript', properties.AfterConnectScript != null ? cfn_parse.FromCloudFormation.getString(properties.AfterConnectScript) : undefined);
    ret.addPropertyResult('cleanSourceMetadataOnMismatch', 'CleanSourceMetadataOnMismatch', properties.CleanSourceMetadataOnMismatch != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CleanSourceMetadataOnMismatch) : undefined);
    ret.addPropertyResult('databaseName', 'DatabaseName', properties.DatabaseName != null ? cfn_parse.FromCloudFormation.getString(properties.DatabaseName) : undefined);
    ret.addPropertyResult('eventsPollInterval', 'EventsPollInterval', properties.EventsPollInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.EventsPollInterval) : undefined);
    ret.addPropertyResult('maxFileSize', 'MaxFileSize', properties.MaxFileSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxFileSize) : undefined);
    ret.addPropertyResult('parallelLoadThreads', 'ParallelLoadThreads', properties.ParallelLoadThreads != null ? cfn_parse.FromCloudFormation.getNumber(properties.ParallelLoadThreads) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addPropertyResult('serverName', 'ServerName', properties.ServerName != null ? cfn_parse.FromCloudFormation.getString(properties.ServerName) : undefined);
    ret.addPropertyResult('serverTimezone', 'ServerTimezone', properties.ServerTimezone != null ? cfn_parse.FromCloudFormation.getString(properties.ServerTimezone) : undefined);
    ret.addPropertyResult('username', 'Username', properties.Username != null ? cfn_parse.FromCloudFormation.getString(properties.Username) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `IbmDb2SettingsProperty`
 *
 * @param properties - the TypeScript properties of a `IbmDb2SettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_IbmDb2SettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('currentLsn', cdk.validateString)(properties.currentLsn));
    errors.collect(cdk.propertyValidator('maxKBytesPerRead', cdk.validateNumber)(properties.maxKBytesPerRead));
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    errors.collect(cdk.propertyValidator('setDataCaptureChanges', cdk.validateBoolean)(properties.setDataCaptureChanges));
    return errors.wrap('supplied properties not correct for "IbmDb2SettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.IbmDb2Settings` resource
 *
 * @param properties - the TypeScript properties of a `IbmDb2SettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.IbmDb2Settings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointIbmDb2SettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_IbmDb2SettingsPropertyValidator(properties).assertSuccess();
    return {
        CurrentLsn: cdk.stringToCloudFormation(properties.currentLsn),
        MaxKBytesPerRead: cdk.numberToCloudFormation(properties.maxKBytesPerRead),
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
        SetDataCaptureChanges: cdk.booleanToCloudFormation(properties.setDataCaptureChanges),
    };
}
// @ts-ignore TS6133
function CfnEndpointIbmDb2SettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('currentLsn', 'CurrentLsn', properties.CurrentLsn != null ? cfn_parse.FromCloudFormation.getString(properties.CurrentLsn) : undefined);
    ret.addPropertyResult('maxKBytesPerRead', 'MaxKBytesPerRead', properties.MaxKBytesPerRead != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxKBytesPerRead) : undefined);
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addPropertyResult('setDataCaptureChanges', 'SetDataCaptureChanges', properties.SetDataCaptureChanges != null ? cfn_parse.FromCloudFormation.getBoolean(properties.SetDataCaptureChanges) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KafkaSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `KafkaSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_KafkaSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('broker', cdk.validateString)(properties.broker));
    errors.collect(cdk.propertyValidator('includeControlDetails', cdk.validateBoolean)(properties.includeControlDetails));
    errors.collect(cdk.propertyValidator('includeNullAndEmpty', cdk.validateBoolean)(properties.includeNullAndEmpty));
    errors.collect(cdk.propertyValidator('includePartitionValue', cdk.validateBoolean)(properties.includePartitionValue));
    errors.collect(cdk.propertyValidator('includeTableAlterOperations', cdk.validateBoolean)(properties.includeTableAlterOperations));
    errors.collect(cdk.propertyValidator('includeTransactionDetails', cdk.validateBoolean)(properties.includeTransactionDetails));
    errors.collect(cdk.propertyValidator('messageFormat', cdk.validateString)(properties.messageFormat));
    errors.collect(cdk.propertyValidator('messageMaxBytes', cdk.validateNumber)(properties.messageMaxBytes));
    errors.collect(cdk.propertyValidator('noHexPrefix', cdk.validateBoolean)(properties.noHexPrefix));
    errors.collect(cdk.propertyValidator('partitionIncludeSchemaTable', cdk.validateBoolean)(properties.partitionIncludeSchemaTable));
    errors.collect(cdk.propertyValidator('saslPassword', cdk.validateString)(properties.saslPassword));
    errors.collect(cdk.propertyValidator('saslUserName', cdk.validateString)(properties.saslUserName));
    errors.collect(cdk.propertyValidator('securityProtocol', cdk.validateString)(properties.securityProtocol));
    errors.collect(cdk.propertyValidator('sslCaCertificateArn', cdk.validateString)(properties.sslCaCertificateArn));
    errors.collect(cdk.propertyValidator('sslClientCertificateArn', cdk.validateString)(properties.sslClientCertificateArn));
    errors.collect(cdk.propertyValidator('sslClientKeyArn', cdk.validateString)(properties.sslClientKeyArn));
    errors.collect(cdk.propertyValidator('sslClientKeyPassword', cdk.validateString)(properties.sslClientKeyPassword));
    errors.collect(cdk.propertyValidator('topic', cdk.validateString)(properties.topic));
    return errors.wrap('supplied properties not correct for "KafkaSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.KafkaSettings` resource
 *
 * @param properties - the TypeScript properties of a `KafkaSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.KafkaSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointKafkaSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_KafkaSettingsPropertyValidator(properties).assertSuccess();
    return {
        Broker: cdk.stringToCloudFormation(properties.broker),
        IncludeControlDetails: cdk.booleanToCloudFormation(properties.includeControlDetails),
        IncludeNullAndEmpty: cdk.booleanToCloudFormation(properties.includeNullAndEmpty),
        IncludePartitionValue: cdk.booleanToCloudFormation(properties.includePartitionValue),
        IncludeTableAlterOperations: cdk.booleanToCloudFormation(properties.includeTableAlterOperations),
        IncludeTransactionDetails: cdk.booleanToCloudFormation(properties.includeTransactionDetails),
        MessageFormat: cdk.stringToCloudFormation(properties.messageFormat),
        MessageMaxBytes: cdk.numberToCloudFormation(properties.messageMaxBytes),
        NoHexPrefix: cdk.booleanToCloudFormation(properties.noHexPrefix),
        PartitionIncludeSchemaTable: cdk.booleanToCloudFormation(properties.partitionIncludeSchemaTable),
        SaslPassword: cdk.stringToCloudFormation(properties.saslPassword),
        SaslUserName: cdk.stringToCloudFormation(properties.saslUserName),
        SecurityProtocol: cdk.stringToCloudFormation(properties.securityProtocol),
        SslCaCertificateArn: cdk.stringToCloudFormation(properties.sslCaCertificateArn),
        SslClientCertificateArn: cdk.stringToCloudFormation(properties.sslClientCertificateArn),
        SslClientKeyArn: cdk.stringToCloudFormation(properties.sslClientKeyArn),
        SslClientKeyPassword: cdk.stringToCloudFormation(properties.sslClientKeyPassword),
        Topic: cdk.stringToCloudFormation(properties.topic),
    };
}
// @ts-ignore TS6133
function CfnEndpointKafkaSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('broker', 'Broker', properties.Broker != null ? cfn_parse.FromCloudFormation.getString(properties.Broker) : undefined);
    ret.addPropertyResult('includeControlDetails', 'IncludeControlDetails', properties.IncludeControlDetails != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeControlDetails) : undefined);
    ret.addPropertyResult('includeNullAndEmpty', 'IncludeNullAndEmpty', properties.IncludeNullAndEmpty != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeNullAndEmpty) : undefined);
    ret.addPropertyResult('includePartitionValue', 'IncludePartitionValue', properties.IncludePartitionValue != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludePartitionValue) : undefined);
    ret.addPropertyResult('includeTableAlterOperations', 'IncludeTableAlterOperations', properties.IncludeTableAlterOperations != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeTableAlterOperations) : undefined);
    ret.addPropertyResult('includeTransactionDetails', 'IncludeTransactionDetails', properties.IncludeTransactionDetails != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeTransactionDetails) : undefined);
    ret.addPropertyResult('messageFormat', 'MessageFormat', properties.MessageFormat != null ? cfn_parse.FromCloudFormation.getString(properties.MessageFormat) : undefined);
    ret.addPropertyResult('messageMaxBytes', 'MessageMaxBytes', properties.MessageMaxBytes != null ? cfn_parse.FromCloudFormation.getNumber(properties.MessageMaxBytes) : undefined);
    ret.addPropertyResult('noHexPrefix', 'NoHexPrefix', properties.NoHexPrefix != null ? cfn_parse.FromCloudFormation.getBoolean(properties.NoHexPrefix) : undefined);
    ret.addPropertyResult('partitionIncludeSchemaTable', 'PartitionIncludeSchemaTable', properties.PartitionIncludeSchemaTable != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PartitionIncludeSchemaTable) : undefined);
    ret.addPropertyResult('saslPassword', 'SaslPassword', properties.SaslPassword != null ? cfn_parse.FromCloudFormation.getString(properties.SaslPassword) : undefined);
    ret.addPropertyResult('saslUserName', 'SaslUserName', properties.SaslUserName != null ? cfn_parse.FromCloudFormation.getString(properties.SaslUserName) : undefined);
    ret.addPropertyResult('securityProtocol', 'SecurityProtocol', properties.SecurityProtocol != null ? cfn_parse.FromCloudFormation.getString(properties.SecurityProtocol) : undefined);
    ret.addPropertyResult('sslCaCertificateArn', 'SslCaCertificateArn', properties.SslCaCertificateArn != null ? cfn_parse.FromCloudFormation.getString(properties.SslCaCertificateArn) : undefined);
    ret.addPropertyResult('sslClientCertificateArn', 'SslClientCertificateArn', properties.SslClientCertificateArn != null ? cfn_parse.FromCloudFormation.getString(properties.SslClientCertificateArn) : undefined);
    ret.addPropertyResult('sslClientKeyArn', 'SslClientKeyArn', properties.SslClientKeyArn != null ? cfn_parse.FromCloudFormation.getString(properties.SslClientKeyArn) : undefined);
    ret.addPropertyResult('sslClientKeyPassword', 'SslClientKeyPassword', properties.SslClientKeyPassword != null ? cfn_parse.FromCloudFormation.getString(properties.SslClientKeyPassword) : undefined);
    ret.addPropertyResult('topic', 'Topic', properties.Topic != null ? cfn_parse.FromCloudFormation.getString(properties.Topic) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KinesisSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `KinesisSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_KinesisSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('includeControlDetails', cdk.validateBoolean)(properties.includeControlDetails));
    errors.collect(cdk.propertyValidator('includeNullAndEmpty', cdk.validateBoolean)(properties.includeNullAndEmpty));
    errors.collect(cdk.propertyValidator('includePartitionValue', cdk.validateBoolean)(properties.includePartitionValue));
    errors.collect(cdk.propertyValidator('includeTableAlterOperations', cdk.validateBoolean)(properties.includeTableAlterOperations));
    errors.collect(cdk.propertyValidator('includeTransactionDetails', cdk.validateBoolean)(properties.includeTransactionDetails));
    errors.collect(cdk.propertyValidator('messageFormat', cdk.validateString)(properties.messageFormat));
    errors.collect(cdk.propertyValidator('noHexPrefix', cdk.validateBoolean)(properties.noHexPrefix));
    errors.collect(cdk.propertyValidator('partitionIncludeSchemaTable', cdk.validateBoolean)(properties.partitionIncludeSchemaTable));
    errors.collect(cdk.propertyValidator('serviceAccessRoleArn', cdk.validateString)(properties.serviceAccessRoleArn));
    errors.collect(cdk.propertyValidator('streamArn', cdk.validateString)(properties.streamArn));
    return errors.wrap('supplied properties not correct for "KinesisSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.KinesisSettings` resource
 *
 * @param properties - the TypeScript properties of a `KinesisSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.KinesisSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointKinesisSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_KinesisSettingsPropertyValidator(properties).assertSuccess();
    return {
        IncludeControlDetails: cdk.booleanToCloudFormation(properties.includeControlDetails),
        IncludeNullAndEmpty: cdk.booleanToCloudFormation(properties.includeNullAndEmpty),
        IncludePartitionValue: cdk.booleanToCloudFormation(properties.includePartitionValue),
        IncludeTableAlterOperations: cdk.booleanToCloudFormation(properties.includeTableAlterOperations),
        IncludeTransactionDetails: cdk.booleanToCloudFormation(properties.includeTransactionDetails),
        MessageFormat: cdk.stringToCloudFormation(properties.messageFormat),
        NoHexPrefix: cdk.booleanToCloudFormation(properties.noHexPrefix),
        PartitionIncludeSchemaTable: cdk.booleanToCloudFormation(properties.partitionIncludeSchemaTable),
        ServiceAccessRoleArn: cdk.stringToCloudFormation(properties.serviceAccessRoleArn),
        StreamArn: cdk.stringToCloudFormation(properties.streamArn),
    };
}
// @ts-ignore TS6133
function CfnEndpointKinesisSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('includeControlDetails', 'IncludeControlDetails', properties.IncludeControlDetails != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeControlDetails) : undefined);
    ret.addPropertyResult('includeNullAndEmpty', 'IncludeNullAndEmpty', properties.IncludeNullAndEmpty != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeNullAndEmpty) : undefined);
    ret.addPropertyResult('includePartitionValue', 'IncludePartitionValue', properties.IncludePartitionValue != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludePartitionValue) : undefined);
    ret.addPropertyResult('includeTableAlterOperations', 'IncludeTableAlterOperations', properties.IncludeTableAlterOperations != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeTableAlterOperations) : undefined);
    ret.addPropertyResult('includeTransactionDetails', 'IncludeTransactionDetails', properties.IncludeTransactionDetails != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeTransactionDetails) : undefined);
    ret.addPropertyResult('messageFormat', 'MessageFormat', properties.MessageFormat != null ? cfn_parse.FromCloudFormation.getString(properties.MessageFormat) : undefined);
    ret.addPropertyResult('noHexPrefix', 'NoHexPrefix', properties.NoHexPrefix != null ? cfn_parse.FromCloudFormation.getBoolean(properties.NoHexPrefix) : undefined);
    ret.addPropertyResult('partitionIncludeSchemaTable', 'PartitionIncludeSchemaTable', properties.PartitionIncludeSchemaTable != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PartitionIncludeSchemaTable) : undefined);
    ret.addPropertyResult('serviceAccessRoleArn', 'ServiceAccessRoleArn', properties.ServiceAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceAccessRoleArn) : undefined);
    ret.addPropertyResult('streamArn', 'StreamArn', properties.StreamArn != null ? cfn_parse.FromCloudFormation.getString(properties.StreamArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MicrosoftSqlServerSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `MicrosoftSqlServerSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_MicrosoftSqlServerSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('bcpPacketSize', cdk.validateNumber)(properties.bcpPacketSize));
    errors.collect(cdk.propertyValidator('controlTablesFileGroup', cdk.validateString)(properties.controlTablesFileGroup));
    errors.collect(cdk.propertyValidator('querySingleAlwaysOnNode', cdk.validateBoolean)(properties.querySingleAlwaysOnNode));
    errors.collect(cdk.propertyValidator('readBackupOnly', cdk.validateBoolean)(properties.readBackupOnly));
    errors.collect(cdk.propertyValidator('safeguardPolicy', cdk.validateString)(properties.safeguardPolicy));
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    errors.collect(cdk.propertyValidator('useBcpFullLoad', cdk.validateBoolean)(properties.useBcpFullLoad));
    errors.collect(cdk.propertyValidator('useThirdPartyBackupDevice', cdk.validateBoolean)(properties.useThirdPartyBackupDevice));
    return errors.wrap('supplied properties not correct for "MicrosoftSqlServerSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MicrosoftSqlServerSettings` resource
 *
 * @param properties - the TypeScript properties of a `MicrosoftSqlServerSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MicrosoftSqlServerSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointMicrosoftSqlServerSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_MicrosoftSqlServerSettingsPropertyValidator(properties).assertSuccess();
    return {
        BcpPacketSize: cdk.numberToCloudFormation(properties.bcpPacketSize),
        ControlTablesFileGroup: cdk.stringToCloudFormation(properties.controlTablesFileGroup),
        QuerySingleAlwaysOnNode: cdk.booleanToCloudFormation(properties.querySingleAlwaysOnNode),
        ReadBackupOnly: cdk.booleanToCloudFormation(properties.readBackupOnly),
        SafeguardPolicy: cdk.stringToCloudFormation(properties.safeguardPolicy),
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
        UseBcpFullLoad: cdk.booleanToCloudFormation(properties.useBcpFullLoad),
        UseThirdPartyBackupDevice: cdk.booleanToCloudFormation(properties.useThirdPartyBackupDevice),
    };
}
// @ts-ignore TS6133
function CfnEndpointMicrosoftSqlServerSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('bcpPacketSize', 'BcpPacketSize', properties.BcpPacketSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.BcpPacketSize) : undefined);
    ret.addPropertyResult('controlTablesFileGroup', 'ControlTablesFileGroup', properties.ControlTablesFileGroup != null ? cfn_parse.FromCloudFormation.getString(properties.ControlTablesFileGroup) : undefined);
    ret.addPropertyResult('querySingleAlwaysOnNode', 'QuerySingleAlwaysOnNode', properties.QuerySingleAlwaysOnNode != null ? cfn_parse.FromCloudFormation.getBoolean(properties.QuerySingleAlwaysOnNode) : undefined);
    ret.addPropertyResult('readBackupOnly', 'ReadBackupOnly', properties.ReadBackupOnly != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReadBackupOnly) : undefined);
    ret.addPropertyResult('safeguardPolicy', 'SafeguardPolicy', properties.SafeguardPolicy != null ? cfn_parse.FromCloudFormation.getString(properties.SafeguardPolicy) : undefined);
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addPropertyResult('useBcpFullLoad', 'UseBcpFullLoad', properties.UseBcpFullLoad != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseBcpFullLoad) : undefined);
    ret.addPropertyResult('useThirdPartyBackupDevice', 'UseThirdPartyBackupDevice', properties.UseThirdPartyBackupDevice != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseThirdPartyBackupDevice) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MongoDbSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `MongoDbSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_MongoDbSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('authMechanism', cdk.validateString)(properties.authMechanism));
    errors.collect(cdk.propertyValidator('authSource', cdk.validateString)(properties.authSource));
    errors.collect(cdk.propertyValidator('authType', cdk.validateString)(properties.authType));
    errors.collect(cdk.propertyValidator('databaseName', cdk.validateString)(properties.databaseName));
    errors.collect(cdk.propertyValidator('docsToInvestigate', cdk.validateString)(properties.docsToInvestigate));
    errors.collect(cdk.propertyValidator('extractDocId', cdk.validateString)(properties.extractDocId));
    errors.collect(cdk.propertyValidator('nestingLevel', cdk.validateString)(properties.nestingLevel));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    errors.collect(cdk.propertyValidator('serverName', cdk.validateString)(properties.serverName));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "MongoDbSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MongoDbSettings` resource
 *
 * @param properties - the TypeScript properties of a `MongoDbSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MongoDbSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointMongoDbSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_MongoDbSettingsPropertyValidator(properties).assertSuccess();
    return {
        AuthMechanism: cdk.stringToCloudFormation(properties.authMechanism),
        AuthSource: cdk.stringToCloudFormation(properties.authSource),
        AuthType: cdk.stringToCloudFormation(properties.authType),
        DatabaseName: cdk.stringToCloudFormation(properties.databaseName),
        DocsToInvestigate: cdk.stringToCloudFormation(properties.docsToInvestigate),
        ExtractDocId: cdk.stringToCloudFormation(properties.extractDocId),
        NestingLevel: cdk.stringToCloudFormation(properties.nestingLevel),
        Password: cdk.stringToCloudFormation(properties.password),
        Port: cdk.numberToCloudFormation(properties.port),
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
        ServerName: cdk.stringToCloudFormation(properties.serverName),
        Username: cdk.stringToCloudFormation(properties.username),
    };
}
// @ts-ignore TS6133
function CfnEndpointMongoDbSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('authMechanism', 'AuthMechanism', properties.AuthMechanism != null ? cfn_parse.FromCloudFormation.getString(properties.AuthMechanism) : undefined);
    ret.addPropertyResult('authSource', 'AuthSource', properties.AuthSource != null ? cfn_parse.FromCloudFormation.getString(properties.AuthSource) : undefined);
    ret.addPropertyResult('authType', 'AuthType', properties.AuthType != null ? cfn_parse.FromCloudFormation.getString(properties.AuthType) : undefined);
    ret.addPropertyResult('databaseName', 'DatabaseName', properties.DatabaseName != null ? cfn_parse.FromCloudFormation.getString(properties.DatabaseName) : undefined);
    ret.addPropertyResult('docsToInvestigate', 'DocsToInvestigate', properties.DocsToInvestigate != null ? cfn_parse.FromCloudFormation.getString(properties.DocsToInvestigate) : undefined);
    ret.addPropertyResult('extractDocId', 'ExtractDocId', properties.ExtractDocId != null ? cfn_parse.FromCloudFormation.getString(properties.ExtractDocId) : undefined);
    ret.addPropertyResult('nestingLevel', 'NestingLevel', properties.NestingLevel != null ? cfn_parse.FromCloudFormation.getString(properties.NestingLevel) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addPropertyResult('serverName', 'ServerName', properties.ServerName != null ? cfn_parse.FromCloudFormation.getString(properties.ServerName) : undefined);
    ret.addPropertyResult('username', 'Username', properties.Username != null ? cfn_parse.FromCloudFormation.getString(properties.Username) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MySqlSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `MySqlSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_MySqlSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('afterConnectScript', cdk.validateString)(properties.afterConnectScript));
    errors.collect(cdk.propertyValidator('cleanSourceMetadataOnMismatch', cdk.validateBoolean)(properties.cleanSourceMetadataOnMismatch));
    errors.collect(cdk.propertyValidator('eventsPollInterval', cdk.validateNumber)(properties.eventsPollInterval));
    errors.collect(cdk.propertyValidator('maxFileSize', cdk.validateNumber)(properties.maxFileSize));
    errors.collect(cdk.propertyValidator('parallelLoadThreads', cdk.validateNumber)(properties.parallelLoadThreads));
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    errors.collect(cdk.propertyValidator('serverTimezone', cdk.validateString)(properties.serverTimezone));
    errors.collect(cdk.propertyValidator('targetDbType', cdk.validateString)(properties.targetDbType));
    return errors.wrap('supplied properties not correct for "MySqlSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MySqlSettings` resource
 *
 * @param properties - the TypeScript properties of a `MySqlSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MySqlSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointMySqlSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_MySqlSettingsPropertyValidator(properties).assertSuccess();
    return {
        AfterConnectScript: cdk.stringToCloudFormation(properties.afterConnectScript),
        CleanSourceMetadataOnMismatch: cdk.booleanToCloudFormation(properties.cleanSourceMetadataOnMismatch),
        EventsPollInterval: cdk.numberToCloudFormation(properties.eventsPollInterval),
        MaxFileSize: cdk.numberToCloudFormation(properties.maxFileSize),
        ParallelLoadThreads: cdk.numberToCloudFormation(properties.parallelLoadThreads),
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
        ServerTimezone: cdk.stringToCloudFormation(properties.serverTimezone),
        TargetDbType: cdk.stringToCloudFormation(properties.targetDbType),
    };
}
// @ts-ignore TS6133
function CfnEndpointMySqlSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('afterConnectScript', 'AfterConnectScript', properties.AfterConnectScript != null ? cfn_parse.FromCloudFormation.getString(properties.AfterConnectScript) : undefined);
    ret.addPropertyResult('cleanSourceMetadataOnMismatch', 'CleanSourceMetadataOnMismatch', properties.CleanSourceMetadataOnMismatch != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CleanSourceMetadataOnMismatch) : undefined);
    ret.addPropertyResult('eventsPollInterval', 'EventsPollInterval', properties.EventsPollInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.EventsPollInterval) : undefined);
    ret.addPropertyResult('maxFileSize', 'MaxFileSize', properties.MaxFileSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxFileSize) : undefined);
    ret.addPropertyResult('parallelLoadThreads', 'ParallelLoadThreads', properties.ParallelLoadThreads != null ? cfn_parse.FromCloudFormation.getNumber(properties.ParallelLoadThreads) : undefined);
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addPropertyResult('serverTimezone', 'ServerTimezone', properties.ServerTimezone != null ? cfn_parse.FromCloudFormation.getString(properties.ServerTimezone) : undefined);
    ret.addPropertyResult('targetDbType', 'TargetDbType', properties.TargetDbType != null ? cfn_parse.FromCloudFormation.getString(properties.TargetDbType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NeptuneSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `NeptuneSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_NeptuneSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('errorRetryDuration', cdk.validateNumber)(properties.errorRetryDuration));
    errors.collect(cdk.propertyValidator('iamAuthEnabled', cdk.validateBoolean)(properties.iamAuthEnabled));
    errors.collect(cdk.propertyValidator('maxFileSize', cdk.validateNumber)(properties.maxFileSize));
    errors.collect(cdk.propertyValidator('maxRetryCount', cdk.validateNumber)(properties.maxRetryCount));
    errors.collect(cdk.propertyValidator('s3BucketFolder', cdk.validateString)(properties.s3BucketFolder));
    errors.collect(cdk.propertyValidator('s3BucketName', cdk.validateString)(properties.s3BucketName));
    errors.collect(cdk.propertyValidator('serviceAccessRoleArn', cdk.validateString)(properties.serviceAccessRoleArn));
    return errors.wrap('supplied properties not correct for "NeptuneSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.NeptuneSettings` resource
 *
 * @param properties - the TypeScript properties of a `NeptuneSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.NeptuneSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointNeptuneSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_NeptuneSettingsPropertyValidator(properties).assertSuccess();
    return {
        ErrorRetryDuration: cdk.numberToCloudFormation(properties.errorRetryDuration),
        IamAuthEnabled: cdk.booleanToCloudFormation(properties.iamAuthEnabled),
        MaxFileSize: cdk.numberToCloudFormation(properties.maxFileSize),
        MaxRetryCount: cdk.numberToCloudFormation(properties.maxRetryCount),
        S3BucketFolder: cdk.stringToCloudFormation(properties.s3BucketFolder),
        S3BucketName: cdk.stringToCloudFormation(properties.s3BucketName),
        ServiceAccessRoleArn: cdk.stringToCloudFormation(properties.serviceAccessRoleArn),
    };
}
// @ts-ignore TS6133
function CfnEndpointNeptuneSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('errorRetryDuration', 'ErrorRetryDuration', properties.ErrorRetryDuration != null ? cfn_parse.FromCloudFormation.getNumber(properties.ErrorRetryDuration) : undefined);
    ret.addPropertyResult('iamAuthEnabled', 'IamAuthEnabled', properties.IamAuthEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IamAuthEnabled) : undefined);
    ret.addPropertyResult('maxFileSize', 'MaxFileSize', properties.MaxFileSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxFileSize) : undefined);
    ret.addPropertyResult('maxRetryCount', 'MaxRetryCount', properties.MaxRetryCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxRetryCount) : undefined);
    ret.addPropertyResult('s3BucketFolder', 'S3BucketFolder', properties.S3BucketFolder != null ? cfn_parse.FromCloudFormation.getString(properties.S3BucketFolder) : undefined);
    ret.addPropertyResult('s3BucketName', 'S3BucketName', properties.S3BucketName != null ? cfn_parse.FromCloudFormation.getString(properties.S3BucketName) : undefined);
    ret.addPropertyResult('serviceAccessRoleArn', 'ServiceAccessRoleArn', properties.ServiceAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceAccessRoleArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OracleSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `OracleSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_OracleSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessAlternateDirectly', cdk.validateBoolean)(properties.accessAlternateDirectly));
    errors.collect(cdk.propertyValidator('addSupplementalLogging', cdk.validateBoolean)(properties.addSupplementalLogging));
    errors.collect(cdk.propertyValidator('additionalArchivedLogDestId', cdk.validateNumber)(properties.additionalArchivedLogDestId));
    errors.collect(cdk.propertyValidator('allowSelectNestedTables', cdk.validateBoolean)(properties.allowSelectNestedTables));
    errors.collect(cdk.propertyValidator('archivedLogDestId', cdk.validateNumber)(properties.archivedLogDestId));
    errors.collect(cdk.propertyValidator('archivedLogsOnly', cdk.validateBoolean)(properties.archivedLogsOnly));
    errors.collect(cdk.propertyValidator('asmPassword', cdk.validateString)(properties.asmPassword));
    errors.collect(cdk.propertyValidator('asmServer', cdk.validateString)(properties.asmServer));
    errors.collect(cdk.propertyValidator('asmUser', cdk.validateString)(properties.asmUser));
    errors.collect(cdk.propertyValidator('charLengthSemantics', cdk.validateString)(properties.charLengthSemantics));
    errors.collect(cdk.propertyValidator('directPathNoLog', cdk.validateBoolean)(properties.directPathNoLog));
    errors.collect(cdk.propertyValidator('directPathParallelLoad', cdk.validateBoolean)(properties.directPathParallelLoad));
    errors.collect(cdk.propertyValidator('enableHomogenousTablespace', cdk.validateBoolean)(properties.enableHomogenousTablespace));
    errors.collect(cdk.propertyValidator('extraArchivedLogDestIds', cdk.listValidator(cdk.validateNumber))(properties.extraArchivedLogDestIds));
    errors.collect(cdk.propertyValidator('failTasksOnLobTruncation', cdk.validateBoolean)(properties.failTasksOnLobTruncation));
    errors.collect(cdk.propertyValidator('numberDatatypeScale', cdk.validateNumber)(properties.numberDatatypeScale));
    errors.collect(cdk.propertyValidator('oraclePathPrefix', cdk.validateString)(properties.oraclePathPrefix));
    errors.collect(cdk.propertyValidator('parallelAsmReadThreads', cdk.validateNumber)(properties.parallelAsmReadThreads));
    errors.collect(cdk.propertyValidator('readAheadBlocks', cdk.validateNumber)(properties.readAheadBlocks));
    errors.collect(cdk.propertyValidator('readTableSpaceName', cdk.validateBoolean)(properties.readTableSpaceName));
    errors.collect(cdk.propertyValidator('replacePathPrefix', cdk.validateBoolean)(properties.replacePathPrefix));
    errors.collect(cdk.propertyValidator('retryInterval', cdk.validateNumber)(properties.retryInterval));
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerOracleAsmAccessRoleArn', cdk.validateString)(properties.secretsManagerOracleAsmAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerOracleAsmSecretId', cdk.validateString)(properties.secretsManagerOracleAsmSecretId));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    errors.collect(cdk.propertyValidator('securityDbEncryption', cdk.validateString)(properties.securityDbEncryption));
    errors.collect(cdk.propertyValidator('securityDbEncryptionName', cdk.validateString)(properties.securityDbEncryptionName));
    errors.collect(cdk.propertyValidator('spatialDataOptionToGeoJsonFunctionName', cdk.validateString)(properties.spatialDataOptionToGeoJsonFunctionName));
    errors.collect(cdk.propertyValidator('standbyDelayTime', cdk.validateNumber)(properties.standbyDelayTime));
    errors.collect(cdk.propertyValidator('useAlternateFolderForOnline', cdk.validateBoolean)(properties.useAlternateFolderForOnline));
    errors.collect(cdk.propertyValidator('useBFile', cdk.validateBoolean)(properties.useBFile));
    errors.collect(cdk.propertyValidator('useDirectPathFullLoad', cdk.validateBoolean)(properties.useDirectPathFullLoad));
    errors.collect(cdk.propertyValidator('useLogminerReader', cdk.validateBoolean)(properties.useLogminerReader));
    errors.collect(cdk.propertyValidator('usePathPrefix', cdk.validateString)(properties.usePathPrefix));
    return errors.wrap('supplied properties not correct for "OracleSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.OracleSettings` resource
 *
 * @param properties - the TypeScript properties of a `OracleSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.OracleSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointOracleSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_OracleSettingsPropertyValidator(properties).assertSuccess();
    return {
        AccessAlternateDirectly: cdk.booleanToCloudFormation(properties.accessAlternateDirectly),
        AddSupplementalLogging: cdk.booleanToCloudFormation(properties.addSupplementalLogging),
        AdditionalArchivedLogDestId: cdk.numberToCloudFormation(properties.additionalArchivedLogDestId),
        AllowSelectNestedTables: cdk.booleanToCloudFormation(properties.allowSelectNestedTables),
        ArchivedLogDestId: cdk.numberToCloudFormation(properties.archivedLogDestId),
        ArchivedLogsOnly: cdk.booleanToCloudFormation(properties.archivedLogsOnly),
        AsmPassword: cdk.stringToCloudFormation(properties.asmPassword),
        AsmServer: cdk.stringToCloudFormation(properties.asmServer),
        AsmUser: cdk.stringToCloudFormation(properties.asmUser),
        CharLengthSemantics: cdk.stringToCloudFormation(properties.charLengthSemantics),
        DirectPathNoLog: cdk.booleanToCloudFormation(properties.directPathNoLog),
        DirectPathParallelLoad: cdk.booleanToCloudFormation(properties.directPathParallelLoad),
        EnableHomogenousTablespace: cdk.booleanToCloudFormation(properties.enableHomogenousTablespace),
        ExtraArchivedLogDestIds: cdk.listMapper(cdk.numberToCloudFormation)(properties.extraArchivedLogDestIds),
        FailTasksOnLobTruncation: cdk.booleanToCloudFormation(properties.failTasksOnLobTruncation),
        NumberDatatypeScale: cdk.numberToCloudFormation(properties.numberDatatypeScale),
        OraclePathPrefix: cdk.stringToCloudFormation(properties.oraclePathPrefix),
        ParallelAsmReadThreads: cdk.numberToCloudFormation(properties.parallelAsmReadThreads),
        ReadAheadBlocks: cdk.numberToCloudFormation(properties.readAheadBlocks),
        ReadTableSpaceName: cdk.booleanToCloudFormation(properties.readTableSpaceName),
        ReplacePathPrefix: cdk.booleanToCloudFormation(properties.replacePathPrefix),
        RetryInterval: cdk.numberToCloudFormation(properties.retryInterval),
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerOracleAsmAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerOracleAsmAccessRoleArn),
        SecretsManagerOracleAsmSecretId: cdk.stringToCloudFormation(properties.secretsManagerOracleAsmSecretId),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
        SecurityDbEncryption: cdk.stringToCloudFormation(properties.securityDbEncryption),
        SecurityDbEncryptionName: cdk.stringToCloudFormation(properties.securityDbEncryptionName),
        SpatialDataOptionToGeoJsonFunctionName: cdk.stringToCloudFormation(properties.spatialDataOptionToGeoJsonFunctionName),
        StandbyDelayTime: cdk.numberToCloudFormation(properties.standbyDelayTime),
        UseAlternateFolderForOnline: cdk.booleanToCloudFormation(properties.useAlternateFolderForOnline),
        UseBFile: cdk.booleanToCloudFormation(properties.useBFile),
        UseDirectPathFullLoad: cdk.booleanToCloudFormation(properties.useDirectPathFullLoad),
        UseLogminerReader: cdk.booleanToCloudFormation(properties.useLogminerReader),
        UsePathPrefix: cdk.stringToCloudFormation(properties.usePathPrefix),
    };
}
// @ts-ignore TS6133
function CfnEndpointOracleSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('accessAlternateDirectly', 'AccessAlternateDirectly', properties.AccessAlternateDirectly != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AccessAlternateDirectly) : undefined);
    ret.addPropertyResult('addSupplementalLogging', 'AddSupplementalLogging', properties.AddSupplementalLogging != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AddSupplementalLogging) : undefined);
    ret.addPropertyResult('additionalArchivedLogDestId', 'AdditionalArchivedLogDestId', properties.AdditionalArchivedLogDestId != null ? cfn_parse.FromCloudFormation.getNumber(properties.AdditionalArchivedLogDestId) : undefined);
    ret.addPropertyResult('allowSelectNestedTables', 'AllowSelectNestedTables', properties.AllowSelectNestedTables != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowSelectNestedTables) : undefined);
    ret.addPropertyResult('archivedLogDestId', 'ArchivedLogDestId', properties.ArchivedLogDestId != null ? cfn_parse.FromCloudFormation.getNumber(properties.ArchivedLogDestId) : undefined);
    ret.addPropertyResult('archivedLogsOnly', 'ArchivedLogsOnly', properties.ArchivedLogsOnly != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ArchivedLogsOnly) : undefined);
    ret.addPropertyResult('asmPassword', 'AsmPassword', properties.AsmPassword != null ? cfn_parse.FromCloudFormation.getString(properties.AsmPassword) : undefined);
    ret.addPropertyResult('asmServer', 'AsmServer', properties.AsmServer != null ? cfn_parse.FromCloudFormation.getString(properties.AsmServer) : undefined);
    ret.addPropertyResult('asmUser', 'AsmUser', properties.AsmUser != null ? cfn_parse.FromCloudFormation.getString(properties.AsmUser) : undefined);
    ret.addPropertyResult('charLengthSemantics', 'CharLengthSemantics', properties.CharLengthSemantics != null ? cfn_parse.FromCloudFormation.getString(properties.CharLengthSemantics) : undefined);
    ret.addPropertyResult('directPathNoLog', 'DirectPathNoLog', properties.DirectPathNoLog != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DirectPathNoLog) : undefined);
    ret.addPropertyResult('directPathParallelLoad', 'DirectPathParallelLoad', properties.DirectPathParallelLoad != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DirectPathParallelLoad) : undefined);
    ret.addPropertyResult('enableHomogenousTablespace', 'EnableHomogenousTablespace', properties.EnableHomogenousTablespace != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableHomogenousTablespace) : undefined);
    ret.addPropertyResult('extraArchivedLogDestIds', 'ExtraArchivedLogDestIds', properties.ExtraArchivedLogDestIds != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getNumber)(properties.ExtraArchivedLogDestIds) : undefined);
    ret.addPropertyResult('failTasksOnLobTruncation', 'FailTasksOnLobTruncation', properties.FailTasksOnLobTruncation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.FailTasksOnLobTruncation) : undefined);
    ret.addPropertyResult('numberDatatypeScale', 'NumberDatatypeScale', properties.NumberDatatypeScale != null ? cfn_parse.FromCloudFormation.getNumber(properties.NumberDatatypeScale) : undefined);
    ret.addPropertyResult('oraclePathPrefix', 'OraclePathPrefix', properties.OraclePathPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.OraclePathPrefix) : undefined);
    ret.addPropertyResult('parallelAsmReadThreads', 'ParallelAsmReadThreads', properties.ParallelAsmReadThreads != null ? cfn_parse.FromCloudFormation.getNumber(properties.ParallelAsmReadThreads) : undefined);
    ret.addPropertyResult('readAheadBlocks', 'ReadAheadBlocks', properties.ReadAheadBlocks != null ? cfn_parse.FromCloudFormation.getNumber(properties.ReadAheadBlocks) : undefined);
    ret.addPropertyResult('readTableSpaceName', 'ReadTableSpaceName', properties.ReadTableSpaceName != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReadTableSpaceName) : undefined);
    ret.addPropertyResult('replacePathPrefix', 'ReplacePathPrefix', properties.ReplacePathPrefix != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReplacePathPrefix) : undefined);
    ret.addPropertyResult('retryInterval', 'RetryInterval', properties.RetryInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.RetryInterval) : undefined);
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerOracleAsmAccessRoleArn', 'SecretsManagerOracleAsmAccessRoleArn', properties.SecretsManagerOracleAsmAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerOracleAsmAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerOracleAsmSecretId', 'SecretsManagerOracleAsmSecretId', properties.SecretsManagerOracleAsmSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerOracleAsmSecretId) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addPropertyResult('securityDbEncryption', 'SecurityDbEncryption', properties.SecurityDbEncryption != null ? cfn_parse.FromCloudFormation.getString(properties.SecurityDbEncryption) : undefined);
    ret.addPropertyResult('securityDbEncryptionName', 'SecurityDbEncryptionName', properties.SecurityDbEncryptionName != null ? cfn_parse.FromCloudFormation.getString(properties.SecurityDbEncryptionName) : undefined);
    ret.addPropertyResult('spatialDataOptionToGeoJsonFunctionName', 'SpatialDataOptionToGeoJsonFunctionName', properties.SpatialDataOptionToGeoJsonFunctionName != null ? cfn_parse.FromCloudFormation.getString(properties.SpatialDataOptionToGeoJsonFunctionName) : undefined);
    ret.addPropertyResult('standbyDelayTime', 'StandbyDelayTime', properties.StandbyDelayTime != null ? cfn_parse.FromCloudFormation.getNumber(properties.StandbyDelayTime) : undefined);
    ret.addPropertyResult('useAlternateFolderForOnline', 'UseAlternateFolderForOnline', properties.UseAlternateFolderForOnline != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseAlternateFolderForOnline) : undefined);
    ret.addPropertyResult('useBFile', 'UseBFile', properties.UseBFile != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseBFile) : undefined);
    ret.addPropertyResult('useDirectPathFullLoad', 'UseDirectPathFullLoad', properties.UseDirectPathFullLoad != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseDirectPathFullLoad) : undefined);
    ret.addPropertyResult('useLogminerReader', 'UseLogminerReader', properties.UseLogminerReader != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseLogminerReader) : undefined);
    ret.addPropertyResult('usePathPrefix', 'UsePathPrefix', properties.UsePathPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.UsePathPrefix) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PostgreSqlSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `PostgreSqlSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_PostgreSqlSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('afterConnectScript', cdk.validateString)(properties.afterConnectScript));
    errors.collect(cdk.propertyValidator('captureDdls', cdk.validateBoolean)(properties.captureDdls));
    errors.collect(cdk.propertyValidator('ddlArtifactsSchema', cdk.validateString)(properties.ddlArtifactsSchema));
    errors.collect(cdk.propertyValidator('executeTimeout', cdk.validateNumber)(properties.executeTimeout));
    errors.collect(cdk.propertyValidator('failTasksOnLobTruncation', cdk.validateBoolean)(properties.failTasksOnLobTruncation));
    errors.collect(cdk.propertyValidator('heartbeatEnable', cdk.validateBoolean)(properties.heartbeatEnable));
    errors.collect(cdk.propertyValidator('heartbeatFrequency', cdk.validateNumber)(properties.heartbeatFrequency));
    errors.collect(cdk.propertyValidator('heartbeatSchema', cdk.validateString)(properties.heartbeatSchema));
    errors.collect(cdk.propertyValidator('maxFileSize', cdk.validateNumber)(properties.maxFileSize));
    errors.collect(cdk.propertyValidator('pluginName', cdk.validateString)(properties.pluginName));
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    errors.collect(cdk.propertyValidator('slotName', cdk.validateString)(properties.slotName));
    return errors.wrap('supplied properties not correct for "PostgreSqlSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.PostgreSqlSettings` resource
 *
 * @param properties - the TypeScript properties of a `PostgreSqlSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.PostgreSqlSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointPostgreSqlSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_PostgreSqlSettingsPropertyValidator(properties).assertSuccess();
    return {
        AfterConnectScript: cdk.stringToCloudFormation(properties.afterConnectScript),
        CaptureDdls: cdk.booleanToCloudFormation(properties.captureDdls),
        DdlArtifactsSchema: cdk.stringToCloudFormation(properties.ddlArtifactsSchema),
        ExecuteTimeout: cdk.numberToCloudFormation(properties.executeTimeout),
        FailTasksOnLobTruncation: cdk.booleanToCloudFormation(properties.failTasksOnLobTruncation),
        HeartbeatEnable: cdk.booleanToCloudFormation(properties.heartbeatEnable),
        HeartbeatFrequency: cdk.numberToCloudFormation(properties.heartbeatFrequency),
        HeartbeatSchema: cdk.stringToCloudFormation(properties.heartbeatSchema),
        MaxFileSize: cdk.numberToCloudFormation(properties.maxFileSize),
        PluginName: cdk.stringToCloudFormation(properties.pluginName),
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
        SlotName: cdk.stringToCloudFormation(properties.slotName),
    };
}
// @ts-ignore TS6133
function CfnEndpointPostgreSqlSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('afterConnectScript', 'AfterConnectScript', properties.AfterConnectScript != null ? cfn_parse.FromCloudFormation.getString(properties.AfterConnectScript) : undefined);
    ret.addPropertyResult('captureDdls', 'CaptureDdls', properties.CaptureDdls != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CaptureDdls) : undefined);
    ret.addPropertyResult('ddlArtifactsSchema', 'DdlArtifactsSchema', properties.DdlArtifactsSchema != null ? cfn_parse.FromCloudFormation.getString(properties.DdlArtifactsSchema) : undefined);
    ret.addPropertyResult('executeTimeout', 'ExecuteTimeout', properties.ExecuteTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.ExecuteTimeout) : undefined);
    ret.addPropertyResult('failTasksOnLobTruncation', 'FailTasksOnLobTruncation', properties.FailTasksOnLobTruncation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.FailTasksOnLobTruncation) : undefined);
    ret.addPropertyResult('heartbeatEnable', 'HeartbeatEnable', properties.HeartbeatEnable != null ? cfn_parse.FromCloudFormation.getBoolean(properties.HeartbeatEnable) : undefined);
    ret.addPropertyResult('heartbeatFrequency', 'HeartbeatFrequency', properties.HeartbeatFrequency != null ? cfn_parse.FromCloudFormation.getNumber(properties.HeartbeatFrequency) : undefined);
    ret.addPropertyResult('heartbeatSchema', 'HeartbeatSchema', properties.HeartbeatSchema != null ? cfn_parse.FromCloudFormation.getString(properties.HeartbeatSchema) : undefined);
    ret.addPropertyResult('maxFileSize', 'MaxFileSize', properties.MaxFileSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxFileSize) : undefined);
    ret.addPropertyResult('pluginName', 'PluginName', properties.PluginName != null ? cfn_parse.FromCloudFormation.getString(properties.PluginName) : undefined);
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addPropertyResult('slotName', 'SlotName', properties.SlotName != null ? cfn_parse.FromCloudFormation.getString(properties.SlotName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RedisSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `RedisSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_RedisSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('authPassword', cdk.validateString)(properties.authPassword));
    errors.collect(cdk.propertyValidator('authType', cdk.validateString)(properties.authType));
    errors.collect(cdk.propertyValidator('authUserName', cdk.validateString)(properties.authUserName));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('serverName', cdk.validateString)(properties.serverName));
    errors.collect(cdk.propertyValidator('sslCaCertificateArn', cdk.validateString)(properties.sslCaCertificateArn));
    errors.collect(cdk.propertyValidator('sslSecurityProtocol', cdk.validateString)(properties.sslSecurityProtocol));
    return errors.wrap('supplied properties not correct for "RedisSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.RedisSettings` resource
 *
 * @param properties - the TypeScript properties of a `RedisSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.RedisSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointRedisSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_RedisSettingsPropertyValidator(properties).assertSuccess();
    return {
        AuthPassword: cdk.stringToCloudFormation(properties.authPassword),
        AuthType: cdk.stringToCloudFormation(properties.authType),
        AuthUserName: cdk.stringToCloudFormation(properties.authUserName),
        Port: cdk.numberToCloudFormation(properties.port),
        ServerName: cdk.stringToCloudFormation(properties.serverName),
        SslCaCertificateArn: cdk.stringToCloudFormation(properties.sslCaCertificateArn),
        SslSecurityProtocol: cdk.stringToCloudFormation(properties.sslSecurityProtocol),
    };
}
// @ts-ignore TS6133
function CfnEndpointRedisSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('authPassword', 'AuthPassword', properties.AuthPassword != null ? cfn_parse.FromCloudFormation.getString(properties.AuthPassword) : undefined);
    ret.addPropertyResult('authType', 'AuthType', properties.AuthType != null ? cfn_parse.FromCloudFormation.getString(properties.AuthType) : undefined);
    ret.addPropertyResult('authUserName', 'AuthUserName', properties.AuthUserName != null ? cfn_parse.FromCloudFormation.getString(properties.AuthUserName) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('serverName', 'ServerName', properties.ServerName != null ? cfn_parse.FromCloudFormation.getString(properties.ServerName) : undefined);
    ret.addPropertyResult('sslCaCertificateArn', 'SslCaCertificateArn', properties.SslCaCertificateArn != null ? cfn_parse.FromCloudFormation.getString(properties.SslCaCertificateArn) : undefined);
    ret.addPropertyResult('sslSecurityProtocol', 'SslSecurityProtocol', properties.SslSecurityProtocol != null ? cfn_parse.FromCloudFormation.getString(properties.SslSecurityProtocol) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RedshiftSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `RedshiftSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_RedshiftSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('acceptAnyDate', cdk.validateBoolean)(properties.acceptAnyDate));
    errors.collect(cdk.propertyValidator('afterConnectScript', cdk.validateString)(properties.afterConnectScript));
    errors.collect(cdk.propertyValidator('bucketFolder', cdk.validateString)(properties.bucketFolder));
    errors.collect(cdk.propertyValidator('bucketName', cdk.validateString)(properties.bucketName));
    errors.collect(cdk.propertyValidator('caseSensitiveNames', cdk.validateBoolean)(properties.caseSensitiveNames));
    errors.collect(cdk.propertyValidator('compUpdate', cdk.validateBoolean)(properties.compUpdate));
    errors.collect(cdk.propertyValidator('connectionTimeout', cdk.validateNumber)(properties.connectionTimeout));
    errors.collect(cdk.propertyValidator('dateFormat', cdk.validateString)(properties.dateFormat));
    errors.collect(cdk.propertyValidator('emptyAsNull', cdk.validateBoolean)(properties.emptyAsNull));
    errors.collect(cdk.propertyValidator('encryptionMode', cdk.validateString)(properties.encryptionMode));
    errors.collect(cdk.propertyValidator('explicitIds', cdk.validateBoolean)(properties.explicitIds));
    errors.collect(cdk.propertyValidator('fileTransferUploadStreams', cdk.validateNumber)(properties.fileTransferUploadStreams));
    errors.collect(cdk.propertyValidator('loadTimeout', cdk.validateNumber)(properties.loadTimeout));
    errors.collect(cdk.propertyValidator('maxFileSize', cdk.validateNumber)(properties.maxFileSize));
    errors.collect(cdk.propertyValidator('removeQuotes', cdk.validateBoolean)(properties.removeQuotes));
    errors.collect(cdk.propertyValidator('replaceChars', cdk.validateString)(properties.replaceChars));
    errors.collect(cdk.propertyValidator('replaceInvalidChars', cdk.validateString)(properties.replaceInvalidChars));
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    errors.collect(cdk.propertyValidator('serverSideEncryptionKmsKeyId', cdk.validateString)(properties.serverSideEncryptionKmsKeyId));
    errors.collect(cdk.propertyValidator('serviceAccessRoleArn', cdk.validateString)(properties.serviceAccessRoleArn));
    errors.collect(cdk.propertyValidator('timeFormat', cdk.validateString)(properties.timeFormat));
    errors.collect(cdk.propertyValidator('trimBlanks', cdk.validateBoolean)(properties.trimBlanks));
    errors.collect(cdk.propertyValidator('truncateColumns', cdk.validateBoolean)(properties.truncateColumns));
    errors.collect(cdk.propertyValidator('writeBufferSize', cdk.validateNumber)(properties.writeBufferSize));
    return errors.wrap('supplied properties not correct for "RedshiftSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.RedshiftSettings` resource
 *
 * @param properties - the TypeScript properties of a `RedshiftSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.RedshiftSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointRedshiftSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_RedshiftSettingsPropertyValidator(properties).assertSuccess();
    return {
        AcceptAnyDate: cdk.booleanToCloudFormation(properties.acceptAnyDate),
        AfterConnectScript: cdk.stringToCloudFormation(properties.afterConnectScript),
        BucketFolder: cdk.stringToCloudFormation(properties.bucketFolder),
        BucketName: cdk.stringToCloudFormation(properties.bucketName),
        CaseSensitiveNames: cdk.booleanToCloudFormation(properties.caseSensitiveNames),
        CompUpdate: cdk.booleanToCloudFormation(properties.compUpdate),
        ConnectionTimeout: cdk.numberToCloudFormation(properties.connectionTimeout),
        DateFormat: cdk.stringToCloudFormation(properties.dateFormat),
        EmptyAsNull: cdk.booleanToCloudFormation(properties.emptyAsNull),
        EncryptionMode: cdk.stringToCloudFormation(properties.encryptionMode),
        ExplicitIds: cdk.booleanToCloudFormation(properties.explicitIds),
        FileTransferUploadStreams: cdk.numberToCloudFormation(properties.fileTransferUploadStreams),
        LoadTimeout: cdk.numberToCloudFormation(properties.loadTimeout),
        MaxFileSize: cdk.numberToCloudFormation(properties.maxFileSize),
        RemoveQuotes: cdk.booleanToCloudFormation(properties.removeQuotes),
        ReplaceChars: cdk.stringToCloudFormation(properties.replaceChars),
        ReplaceInvalidChars: cdk.stringToCloudFormation(properties.replaceInvalidChars),
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
        ServerSideEncryptionKmsKeyId: cdk.stringToCloudFormation(properties.serverSideEncryptionKmsKeyId),
        ServiceAccessRoleArn: cdk.stringToCloudFormation(properties.serviceAccessRoleArn),
        TimeFormat: cdk.stringToCloudFormation(properties.timeFormat),
        TrimBlanks: cdk.booleanToCloudFormation(properties.trimBlanks),
        TruncateColumns: cdk.booleanToCloudFormation(properties.truncateColumns),
        WriteBufferSize: cdk.numberToCloudFormation(properties.writeBufferSize),
    };
}
// @ts-ignore TS6133
function CfnEndpointRedshiftSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('acceptAnyDate', 'AcceptAnyDate', properties.AcceptAnyDate != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AcceptAnyDate) : undefined);
    ret.addPropertyResult('afterConnectScript', 'AfterConnectScript', properties.AfterConnectScript != null ? cfn_parse.FromCloudFormation.getString(properties.AfterConnectScript) : undefined);
    ret.addPropertyResult('bucketFolder', 'BucketFolder', properties.BucketFolder != null ? cfn_parse.FromCloudFormation.getString(properties.BucketFolder) : undefined);
    ret.addPropertyResult('bucketName', 'BucketName', properties.BucketName != null ? cfn_parse.FromCloudFormation.getString(properties.BucketName) : undefined);
    ret.addPropertyResult('caseSensitiveNames', 'CaseSensitiveNames', properties.CaseSensitiveNames != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CaseSensitiveNames) : undefined);
    ret.addPropertyResult('compUpdate', 'CompUpdate', properties.CompUpdate != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CompUpdate) : undefined);
    ret.addPropertyResult('connectionTimeout', 'ConnectionTimeout', properties.ConnectionTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.ConnectionTimeout) : undefined);
    ret.addPropertyResult('dateFormat', 'DateFormat', properties.DateFormat != null ? cfn_parse.FromCloudFormation.getString(properties.DateFormat) : undefined);
    ret.addPropertyResult('emptyAsNull', 'EmptyAsNull', properties.EmptyAsNull != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EmptyAsNull) : undefined);
    ret.addPropertyResult('encryptionMode', 'EncryptionMode', properties.EncryptionMode != null ? cfn_parse.FromCloudFormation.getString(properties.EncryptionMode) : undefined);
    ret.addPropertyResult('explicitIds', 'ExplicitIds', properties.ExplicitIds != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ExplicitIds) : undefined);
    ret.addPropertyResult('fileTransferUploadStreams', 'FileTransferUploadStreams', properties.FileTransferUploadStreams != null ? cfn_parse.FromCloudFormation.getNumber(properties.FileTransferUploadStreams) : undefined);
    ret.addPropertyResult('loadTimeout', 'LoadTimeout', properties.LoadTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.LoadTimeout) : undefined);
    ret.addPropertyResult('maxFileSize', 'MaxFileSize', properties.MaxFileSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxFileSize) : undefined);
    ret.addPropertyResult('removeQuotes', 'RemoveQuotes', properties.RemoveQuotes != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RemoveQuotes) : undefined);
    ret.addPropertyResult('replaceChars', 'ReplaceChars', properties.ReplaceChars != null ? cfn_parse.FromCloudFormation.getString(properties.ReplaceChars) : undefined);
    ret.addPropertyResult('replaceInvalidChars', 'ReplaceInvalidChars', properties.ReplaceInvalidChars != null ? cfn_parse.FromCloudFormation.getString(properties.ReplaceInvalidChars) : undefined);
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addPropertyResult('serverSideEncryptionKmsKeyId', 'ServerSideEncryptionKmsKeyId', properties.ServerSideEncryptionKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.ServerSideEncryptionKmsKeyId) : undefined);
    ret.addPropertyResult('serviceAccessRoleArn', 'ServiceAccessRoleArn', properties.ServiceAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceAccessRoleArn) : undefined);
    ret.addPropertyResult('timeFormat', 'TimeFormat', properties.TimeFormat != null ? cfn_parse.FromCloudFormation.getString(properties.TimeFormat) : undefined);
    ret.addPropertyResult('trimBlanks', 'TrimBlanks', properties.TrimBlanks != null ? cfn_parse.FromCloudFormation.getBoolean(properties.TrimBlanks) : undefined);
    ret.addPropertyResult('truncateColumns', 'TruncateColumns', properties.TruncateColumns != null ? cfn_parse.FromCloudFormation.getBoolean(properties.TruncateColumns) : undefined);
    ret.addPropertyResult('writeBufferSize', 'WriteBufferSize', properties.WriteBufferSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.WriteBufferSize) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3SettingsProperty`
 *
 * @param properties - the TypeScript properties of a `S3SettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_S3SettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('addColumnName', cdk.validateBoolean)(properties.addColumnName));
    errors.collect(cdk.propertyValidator('bucketFolder', cdk.validateString)(properties.bucketFolder));
    errors.collect(cdk.propertyValidator('bucketName', cdk.validateString)(properties.bucketName));
    errors.collect(cdk.propertyValidator('cannedAclForObjects', cdk.validateString)(properties.cannedAclForObjects));
    errors.collect(cdk.propertyValidator('cdcInsertsAndUpdates', cdk.validateBoolean)(properties.cdcInsertsAndUpdates));
    errors.collect(cdk.propertyValidator('cdcInsertsOnly', cdk.validateBoolean)(properties.cdcInsertsOnly));
    errors.collect(cdk.propertyValidator('cdcMaxBatchInterval', cdk.validateNumber)(properties.cdcMaxBatchInterval));
    errors.collect(cdk.propertyValidator('cdcMinFileSize', cdk.validateNumber)(properties.cdcMinFileSize));
    errors.collect(cdk.propertyValidator('cdcPath', cdk.validateString)(properties.cdcPath));
    errors.collect(cdk.propertyValidator('compressionType', cdk.validateString)(properties.compressionType));
    errors.collect(cdk.propertyValidator('csvDelimiter', cdk.validateString)(properties.csvDelimiter));
    errors.collect(cdk.propertyValidator('csvNoSupValue', cdk.validateString)(properties.csvNoSupValue));
    errors.collect(cdk.propertyValidator('csvNullValue', cdk.validateString)(properties.csvNullValue));
    errors.collect(cdk.propertyValidator('csvRowDelimiter', cdk.validateString)(properties.csvRowDelimiter));
    errors.collect(cdk.propertyValidator('dataFormat', cdk.validateString)(properties.dataFormat));
    errors.collect(cdk.propertyValidator('dataPageSize', cdk.validateNumber)(properties.dataPageSize));
    errors.collect(cdk.propertyValidator('datePartitionDelimiter', cdk.validateString)(properties.datePartitionDelimiter));
    errors.collect(cdk.propertyValidator('datePartitionEnabled', cdk.validateBoolean)(properties.datePartitionEnabled));
    errors.collect(cdk.propertyValidator('datePartitionSequence', cdk.validateString)(properties.datePartitionSequence));
    errors.collect(cdk.propertyValidator('datePartitionTimezone', cdk.validateString)(properties.datePartitionTimezone));
    errors.collect(cdk.propertyValidator('dictPageSizeLimit', cdk.validateNumber)(properties.dictPageSizeLimit));
    errors.collect(cdk.propertyValidator('enableStatistics', cdk.validateBoolean)(properties.enableStatistics));
    errors.collect(cdk.propertyValidator('encodingType', cdk.validateString)(properties.encodingType));
    errors.collect(cdk.propertyValidator('encryptionMode', cdk.validateString)(properties.encryptionMode));
    errors.collect(cdk.propertyValidator('externalTableDefinition', cdk.validateString)(properties.externalTableDefinition));
    errors.collect(cdk.propertyValidator('ignoreHeaderRows', cdk.validateNumber)(properties.ignoreHeaderRows));
    errors.collect(cdk.propertyValidator('includeOpForFullLoad', cdk.validateBoolean)(properties.includeOpForFullLoad));
    errors.collect(cdk.propertyValidator('maxFileSize', cdk.validateNumber)(properties.maxFileSize));
    errors.collect(cdk.propertyValidator('parquetTimestampInMillisecond', cdk.validateBoolean)(properties.parquetTimestampInMillisecond));
    errors.collect(cdk.propertyValidator('parquetVersion', cdk.validateString)(properties.parquetVersion));
    errors.collect(cdk.propertyValidator('preserveTransactions', cdk.validateBoolean)(properties.preserveTransactions));
    errors.collect(cdk.propertyValidator('rfc4180', cdk.validateBoolean)(properties.rfc4180));
    errors.collect(cdk.propertyValidator('rowGroupLength', cdk.validateNumber)(properties.rowGroupLength));
    errors.collect(cdk.propertyValidator('serverSideEncryptionKmsKeyId', cdk.validateString)(properties.serverSideEncryptionKmsKeyId));
    errors.collect(cdk.propertyValidator('serviceAccessRoleArn', cdk.validateString)(properties.serviceAccessRoleArn));
    errors.collect(cdk.propertyValidator('timestampColumnName', cdk.validateString)(properties.timestampColumnName));
    errors.collect(cdk.propertyValidator('useCsvNoSupValue', cdk.validateBoolean)(properties.useCsvNoSupValue));
    errors.collect(cdk.propertyValidator('useTaskStartTimeForFullLoadTimestamp', cdk.validateBoolean)(properties.useTaskStartTimeForFullLoadTimestamp));
    return errors.wrap('supplied properties not correct for "S3SettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.S3Settings` resource
 *
 * @param properties - the TypeScript properties of a `S3SettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.S3Settings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointS3SettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_S3SettingsPropertyValidator(properties).assertSuccess();
    return {
        AddColumnName: cdk.booleanToCloudFormation(properties.addColumnName),
        BucketFolder: cdk.stringToCloudFormation(properties.bucketFolder),
        BucketName: cdk.stringToCloudFormation(properties.bucketName),
        CannedAclForObjects: cdk.stringToCloudFormation(properties.cannedAclForObjects),
        CdcInsertsAndUpdates: cdk.booleanToCloudFormation(properties.cdcInsertsAndUpdates),
        CdcInsertsOnly: cdk.booleanToCloudFormation(properties.cdcInsertsOnly),
        CdcMaxBatchInterval: cdk.numberToCloudFormation(properties.cdcMaxBatchInterval),
        CdcMinFileSize: cdk.numberToCloudFormation(properties.cdcMinFileSize),
        CdcPath: cdk.stringToCloudFormation(properties.cdcPath),
        CompressionType: cdk.stringToCloudFormation(properties.compressionType),
        CsvDelimiter: cdk.stringToCloudFormation(properties.csvDelimiter),
        CsvNoSupValue: cdk.stringToCloudFormation(properties.csvNoSupValue),
        CsvNullValue: cdk.stringToCloudFormation(properties.csvNullValue),
        CsvRowDelimiter: cdk.stringToCloudFormation(properties.csvRowDelimiter),
        DataFormat: cdk.stringToCloudFormation(properties.dataFormat),
        DataPageSize: cdk.numberToCloudFormation(properties.dataPageSize),
        DatePartitionDelimiter: cdk.stringToCloudFormation(properties.datePartitionDelimiter),
        DatePartitionEnabled: cdk.booleanToCloudFormation(properties.datePartitionEnabled),
        DatePartitionSequence: cdk.stringToCloudFormation(properties.datePartitionSequence),
        DatePartitionTimezone: cdk.stringToCloudFormation(properties.datePartitionTimezone),
        DictPageSizeLimit: cdk.numberToCloudFormation(properties.dictPageSizeLimit),
        EnableStatistics: cdk.booleanToCloudFormation(properties.enableStatistics),
        EncodingType: cdk.stringToCloudFormation(properties.encodingType),
        EncryptionMode: cdk.stringToCloudFormation(properties.encryptionMode),
        ExternalTableDefinition: cdk.stringToCloudFormation(properties.externalTableDefinition),
        IgnoreHeaderRows: cdk.numberToCloudFormation(properties.ignoreHeaderRows),
        IncludeOpForFullLoad: cdk.booleanToCloudFormation(properties.includeOpForFullLoad),
        MaxFileSize: cdk.numberToCloudFormation(properties.maxFileSize),
        ParquetTimestampInMillisecond: cdk.booleanToCloudFormation(properties.parquetTimestampInMillisecond),
        ParquetVersion: cdk.stringToCloudFormation(properties.parquetVersion),
        PreserveTransactions: cdk.booleanToCloudFormation(properties.preserveTransactions),
        Rfc4180: cdk.booleanToCloudFormation(properties.rfc4180),
        RowGroupLength: cdk.numberToCloudFormation(properties.rowGroupLength),
        ServerSideEncryptionKmsKeyId: cdk.stringToCloudFormation(properties.serverSideEncryptionKmsKeyId),
        ServiceAccessRoleArn: cdk.stringToCloudFormation(properties.serviceAccessRoleArn),
        TimestampColumnName: cdk.stringToCloudFormation(properties.timestampColumnName),
        UseCsvNoSupValue: cdk.booleanToCloudFormation(properties.useCsvNoSupValue),
        UseTaskStartTimeForFullLoadTimestamp: cdk.booleanToCloudFormation(properties.useTaskStartTimeForFullLoadTimestamp),
    };
}
// @ts-ignore TS6133
function CfnEndpointS3SettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('addColumnName', 'AddColumnName', properties.AddColumnName != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AddColumnName) : undefined);
    ret.addPropertyResult('bucketFolder', 'BucketFolder', properties.BucketFolder != null ? cfn_parse.FromCloudFormation.getString(properties.BucketFolder) : undefined);
    ret.addPropertyResult('bucketName', 'BucketName', properties.BucketName != null ? cfn_parse.FromCloudFormation.getString(properties.BucketName) : undefined);
    ret.addPropertyResult('cannedAclForObjects', 'CannedAclForObjects', properties.CannedAclForObjects != null ? cfn_parse.FromCloudFormation.getString(properties.CannedAclForObjects) : undefined);
    ret.addPropertyResult('cdcInsertsAndUpdates', 'CdcInsertsAndUpdates', properties.CdcInsertsAndUpdates != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CdcInsertsAndUpdates) : undefined);
    ret.addPropertyResult('cdcInsertsOnly', 'CdcInsertsOnly', properties.CdcInsertsOnly != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CdcInsertsOnly) : undefined);
    ret.addPropertyResult('cdcMaxBatchInterval', 'CdcMaxBatchInterval', properties.CdcMaxBatchInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.CdcMaxBatchInterval) : undefined);
    ret.addPropertyResult('cdcMinFileSize', 'CdcMinFileSize', properties.CdcMinFileSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.CdcMinFileSize) : undefined);
    ret.addPropertyResult('cdcPath', 'CdcPath', properties.CdcPath != null ? cfn_parse.FromCloudFormation.getString(properties.CdcPath) : undefined);
    ret.addPropertyResult('compressionType', 'CompressionType', properties.CompressionType != null ? cfn_parse.FromCloudFormation.getString(properties.CompressionType) : undefined);
    ret.addPropertyResult('csvDelimiter', 'CsvDelimiter', properties.CsvDelimiter != null ? cfn_parse.FromCloudFormation.getString(properties.CsvDelimiter) : undefined);
    ret.addPropertyResult('csvNoSupValue', 'CsvNoSupValue', properties.CsvNoSupValue != null ? cfn_parse.FromCloudFormation.getString(properties.CsvNoSupValue) : undefined);
    ret.addPropertyResult('csvNullValue', 'CsvNullValue', properties.CsvNullValue != null ? cfn_parse.FromCloudFormation.getString(properties.CsvNullValue) : undefined);
    ret.addPropertyResult('csvRowDelimiter', 'CsvRowDelimiter', properties.CsvRowDelimiter != null ? cfn_parse.FromCloudFormation.getString(properties.CsvRowDelimiter) : undefined);
    ret.addPropertyResult('dataFormat', 'DataFormat', properties.DataFormat != null ? cfn_parse.FromCloudFormation.getString(properties.DataFormat) : undefined);
    ret.addPropertyResult('dataPageSize', 'DataPageSize', properties.DataPageSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.DataPageSize) : undefined);
    ret.addPropertyResult('datePartitionDelimiter', 'DatePartitionDelimiter', properties.DatePartitionDelimiter != null ? cfn_parse.FromCloudFormation.getString(properties.DatePartitionDelimiter) : undefined);
    ret.addPropertyResult('datePartitionEnabled', 'DatePartitionEnabled', properties.DatePartitionEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DatePartitionEnabled) : undefined);
    ret.addPropertyResult('datePartitionSequence', 'DatePartitionSequence', properties.DatePartitionSequence != null ? cfn_parse.FromCloudFormation.getString(properties.DatePartitionSequence) : undefined);
    ret.addPropertyResult('datePartitionTimezone', 'DatePartitionTimezone', properties.DatePartitionTimezone != null ? cfn_parse.FromCloudFormation.getString(properties.DatePartitionTimezone) : undefined);
    ret.addPropertyResult('dictPageSizeLimit', 'DictPageSizeLimit', properties.DictPageSizeLimit != null ? cfn_parse.FromCloudFormation.getNumber(properties.DictPageSizeLimit) : undefined);
    ret.addPropertyResult('enableStatistics', 'EnableStatistics', properties.EnableStatistics != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableStatistics) : undefined);
    ret.addPropertyResult('encodingType', 'EncodingType', properties.EncodingType != null ? cfn_parse.FromCloudFormation.getString(properties.EncodingType) : undefined);
    ret.addPropertyResult('encryptionMode', 'EncryptionMode', properties.EncryptionMode != null ? cfn_parse.FromCloudFormation.getString(properties.EncryptionMode) : undefined);
    ret.addPropertyResult('externalTableDefinition', 'ExternalTableDefinition', properties.ExternalTableDefinition != null ? cfn_parse.FromCloudFormation.getString(properties.ExternalTableDefinition) : undefined);
    ret.addPropertyResult('ignoreHeaderRows', 'IgnoreHeaderRows', properties.IgnoreHeaderRows != null ? cfn_parse.FromCloudFormation.getNumber(properties.IgnoreHeaderRows) : undefined);
    ret.addPropertyResult('includeOpForFullLoad', 'IncludeOpForFullLoad', properties.IncludeOpForFullLoad != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeOpForFullLoad) : undefined);
    ret.addPropertyResult('maxFileSize', 'MaxFileSize', properties.MaxFileSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxFileSize) : undefined);
    ret.addPropertyResult('parquetTimestampInMillisecond', 'ParquetTimestampInMillisecond', properties.ParquetTimestampInMillisecond != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ParquetTimestampInMillisecond) : undefined);
    ret.addPropertyResult('parquetVersion', 'ParquetVersion', properties.ParquetVersion != null ? cfn_parse.FromCloudFormation.getString(properties.ParquetVersion) : undefined);
    ret.addPropertyResult('preserveTransactions', 'PreserveTransactions', properties.PreserveTransactions != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PreserveTransactions) : undefined);
    ret.addPropertyResult('rfc4180', 'Rfc4180', properties.Rfc4180 != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Rfc4180) : undefined);
    ret.addPropertyResult('rowGroupLength', 'RowGroupLength', properties.RowGroupLength != null ? cfn_parse.FromCloudFormation.getNumber(properties.RowGroupLength) : undefined);
    ret.addPropertyResult('serverSideEncryptionKmsKeyId', 'ServerSideEncryptionKmsKeyId', properties.ServerSideEncryptionKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.ServerSideEncryptionKmsKeyId) : undefined);
    ret.addPropertyResult('serviceAccessRoleArn', 'ServiceAccessRoleArn', properties.ServiceAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceAccessRoleArn) : undefined);
    ret.addPropertyResult('timestampColumnName', 'TimestampColumnName', properties.TimestampColumnName != null ? cfn_parse.FromCloudFormation.getString(properties.TimestampColumnName) : undefined);
    ret.addPropertyResult('useCsvNoSupValue', 'UseCsvNoSupValue', properties.UseCsvNoSupValue != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseCsvNoSupValue) : undefined);
    ret.addPropertyResult('useTaskStartTimeForFullLoadTimestamp', 'UseTaskStartTimeForFullLoadTimestamp', properties.UseTaskStartTimeForFullLoadTimestamp != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseTaskStartTimeForFullLoadTimestamp) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SybaseSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `SybaseSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_SybaseSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    return errors.wrap('supplied properties not correct for "SybaseSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.SybaseSettings` resource
 *
 * @param properties - the TypeScript properties of a `SybaseSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.SybaseSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointSybaseSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_SybaseSettingsPropertyValidator(properties).assertSuccess();
    return {
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
    };
}
// @ts-ignore TS6133
function CfnEndpointSybaseSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnEventSubscriptionProps`
 *
 * @param properties - the TypeScript properties of a `CfnEventSubscriptionProps`
 *
 * @returns the result of the validation.
 */
function CfnEventSubscriptionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('eventCategories', cdk.listValidator(cdk.validateString))(properties.eventCategories));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.requiredValidator)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('sourceIds', cdk.listValidator(cdk.validateString))(properties.sourceIds));
    errors.collect(cdk.propertyValidator('sourceType', cdk.validateString)(properties.sourceType));
    errors.collect(cdk.propertyValidator('subscriptionName', cdk.validateString)(properties.subscriptionName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnEventSubscriptionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::EventSubscription` resource
 *
 * @param properties - the TypeScript properties of a `CfnEventSubscriptionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::EventSubscription` resource.
 */
// @ts-ignore TS6133
function cfnEventSubscriptionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEventSubscriptionPropsValidator(properties).assertSuccess();
    return {
        SnsTopicArn: cdk.stringToCloudFormation(properties.snsTopicArn),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        EventCategories: cdk.listMapper(cdk.stringToCloudFormation)(properties.eventCategories),
        SourceIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.sourceIds),
        SourceType: cdk.stringToCloudFormation(properties.sourceType),
        SubscriptionName: cdk.stringToCloudFormation(properties.subscriptionName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnEventSubscriptionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snsTopicArn', 'SnsTopicArn', cfn_parse.FromCloudFormation.getString(properties.SnsTopicArn));
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('eventCategories', 'EventCategories', properties.EventCategories != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EventCategories) : undefined);
    ret.addPropertyResult('sourceIds', 'SourceIds', properties.SourceIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SourceIds) : undefined);
    ret.addPropertyResult('sourceType', 'SourceType', properties.SourceType != null ? cfn_parse.FromCloudFormation.getString(properties.SourceType) : undefined);
    ret.addPropertyResult('subscriptionName', 'SubscriptionName', properties.SubscriptionName != null ? cfn_parse.FromCloudFormation.getString(properties.SubscriptionName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::EventSubscription`
 *
 * Use the `AWS::DMS::EventSubscription` resource to get notifications for AWS Database Migration Service events through the Amazon Simple Notification Service . For more information, see [Working with events and notifications in AWS Database Migration Service](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the *AWS Database Migration Service User Guide* .
 *
 * @cloudformationResource AWS::DMS::EventSubscription
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html
 */
class CfnEventSubscription extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::EventSubscription`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnEventSubscription.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_dms_CfnEventSubscriptionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnEventSubscription);
            }
            throw error;
        }
        cdk.requireProperty(props, 'snsTopicArn', this);
        this.snsTopicArn = props.snsTopicArn;
        this.enabled = props.enabled;
        this.eventCategories = props.eventCategories;
        this.sourceIds = props.sourceIds;
        this.sourceType = props.sourceType;
        this.subscriptionName = props.subscriptionName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DMS::EventSubscription", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEventSubscriptionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnEventSubscription(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEventSubscription.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            snsTopicArn: this.snsTopicArn,
            enabled: this.enabled,
            eventCategories: this.eventCategories,
            sourceIds: this.sourceIds,
            sourceType: this.sourceType,
            subscriptionName: this.subscriptionName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnEventSubscriptionPropsToCloudFormation(props);
    }
}
exports.CfnEventSubscription = CfnEventSubscription;
_c = JSII_RTTI_SYMBOL_1;
CfnEventSubscription[_c] = { fqn: "monocdk.aws_dms.CfnEventSubscription", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEventSubscription.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::EventSubscription";
/**
 * Determine whether the given properties match those of a `CfnReplicationInstanceProps`
 *
 * @param properties - the TypeScript properties of a `CfnReplicationInstanceProps`
 *
 * @returns the result of the validation.
 */
function CfnReplicationInstancePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allocatedStorage', cdk.validateNumber)(properties.allocatedStorage));
    errors.collect(cdk.propertyValidator('allowMajorVersionUpgrade', cdk.validateBoolean)(properties.allowMajorVersionUpgrade));
    errors.collect(cdk.propertyValidator('autoMinorVersionUpgrade', cdk.validateBoolean)(properties.autoMinorVersionUpgrade));
    errors.collect(cdk.propertyValidator('availabilityZone', cdk.validateString)(properties.availabilityZone));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('multiAz', cdk.validateBoolean)(properties.multiAz));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('publiclyAccessible', cdk.validateBoolean)(properties.publiclyAccessible));
    errors.collect(cdk.propertyValidator('replicationInstanceClass', cdk.requiredValidator)(properties.replicationInstanceClass));
    errors.collect(cdk.propertyValidator('replicationInstanceClass', cdk.validateString)(properties.replicationInstanceClass));
    errors.collect(cdk.propertyValidator('replicationInstanceIdentifier', cdk.validateString)(properties.replicationInstanceIdentifier));
    errors.collect(cdk.propertyValidator('replicationSubnetGroupIdentifier', cdk.validateString)(properties.replicationSubnetGroupIdentifier));
    errors.collect(cdk.propertyValidator('resourceIdentifier', cdk.validateString)(properties.resourceIdentifier));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupIds', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupIds));
    return errors.wrap('supplied properties not correct for "CfnReplicationInstanceProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::ReplicationInstance` resource
 *
 * @param properties - the TypeScript properties of a `CfnReplicationInstanceProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::ReplicationInstance` resource.
 */
// @ts-ignore TS6133
function cfnReplicationInstancePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReplicationInstancePropsValidator(properties).assertSuccess();
    return {
        ReplicationInstanceClass: cdk.stringToCloudFormation(properties.replicationInstanceClass),
        AllocatedStorage: cdk.numberToCloudFormation(properties.allocatedStorage),
        AllowMajorVersionUpgrade: cdk.booleanToCloudFormation(properties.allowMajorVersionUpgrade),
        AutoMinorVersionUpgrade: cdk.booleanToCloudFormation(properties.autoMinorVersionUpgrade),
        AvailabilityZone: cdk.stringToCloudFormation(properties.availabilityZone),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MultiAZ: cdk.booleanToCloudFormation(properties.multiAz),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        PubliclyAccessible: cdk.booleanToCloudFormation(properties.publiclyAccessible),
        ReplicationInstanceIdentifier: cdk.stringToCloudFormation(properties.replicationInstanceIdentifier),
        ReplicationSubnetGroupIdentifier: cdk.stringToCloudFormation(properties.replicationSubnetGroupIdentifier),
        ResourceIdentifier: cdk.stringToCloudFormation(properties.resourceIdentifier),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VpcSecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnReplicationInstancePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('replicationInstanceClass', 'ReplicationInstanceClass', cfn_parse.FromCloudFormation.getString(properties.ReplicationInstanceClass));
    ret.addPropertyResult('allocatedStorage', 'AllocatedStorage', properties.AllocatedStorage != null ? cfn_parse.FromCloudFormation.getNumber(properties.AllocatedStorage) : undefined);
    ret.addPropertyResult('allowMajorVersionUpgrade', 'AllowMajorVersionUpgrade', properties.AllowMajorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowMajorVersionUpgrade) : undefined);
    ret.addPropertyResult('autoMinorVersionUpgrade', 'AutoMinorVersionUpgrade', properties.AutoMinorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AutoMinorVersionUpgrade) : undefined);
    ret.addPropertyResult('availabilityZone', 'AvailabilityZone', properties.AvailabilityZone != null ? cfn_parse.FromCloudFormation.getString(properties.AvailabilityZone) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('multiAz', 'MultiAZ', properties.MultiAZ != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiAZ) : undefined);
    ret.addPropertyResult('preferredMaintenanceWindow', 'PreferredMaintenanceWindow', properties.PreferredMaintenanceWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow) : undefined);
    ret.addPropertyResult('publiclyAccessible', 'PubliclyAccessible', properties.PubliclyAccessible != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PubliclyAccessible) : undefined);
    ret.addPropertyResult('replicationInstanceIdentifier', 'ReplicationInstanceIdentifier', properties.ReplicationInstanceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationInstanceIdentifier) : undefined);
    ret.addPropertyResult('replicationSubnetGroupIdentifier', 'ReplicationSubnetGroupIdentifier', properties.ReplicationSubnetGroupIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationSubnetGroupIdentifier) : undefined);
    ret.addPropertyResult('resourceIdentifier', 'ResourceIdentifier', properties.ResourceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceIdentifier) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('vpcSecurityGroupIds', 'VpcSecurityGroupIds', properties.VpcSecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::ReplicationInstance`
 *
 * The `AWS::DMS::ReplicationInstance` resource creates an AWS DMS replication instance.
 *
 * @cloudformationResource AWS::DMS::ReplicationInstance
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html
 */
class CfnReplicationInstance extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::ReplicationInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReplicationInstance.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_dms_CfnReplicationInstanceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnReplicationInstance);
            }
            throw error;
        }
        cdk.requireProperty(props, 'replicationInstanceClass', this);
        this.attrReplicationInstancePrivateIpAddresses = cdk.Token.asString(this.getAtt('ReplicationInstancePrivateIpAddresses'));
        this.attrReplicationInstancePublicIpAddresses = cdk.Token.asString(this.getAtt('ReplicationInstancePublicIpAddresses'));
        this.replicationInstanceClass = props.replicationInstanceClass;
        this.allocatedStorage = props.allocatedStorage;
        this.allowMajorVersionUpgrade = props.allowMajorVersionUpgrade;
        this.autoMinorVersionUpgrade = props.autoMinorVersionUpgrade;
        this.availabilityZone = props.availabilityZone;
        this.engineVersion = props.engineVersion;
        this.kmsKeyId = props.kmsKeyId;
        this.multiAz = props.multiAz;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.publiclyAccessible = props.publiclyAccessible;
        this.replicationInstanceIdentifier = props.replicationInstanceIdentifier;
        this.replicationSubnetGroupIdentifier = props.replicationSubnetGroupIdentifier;
        this.resourceIdentifier = props.resourceIdentifier;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DMS::ReplicationInstance", props.tags, { tagPropertyName: 'tags' });
        this.vpcSecurityGroupIds = props.vpcSecurityGroupIds;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReplicationInstancePropsFromCloudFormation(resourceProperties);
        const ret = new CfnReplicationInstance(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReplicationInstance.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            replicationInstanceClass: this.replicationInstanceClass,
            allocatedStorage: this.allocatedStorage,
            allowMajorVersionUpgrade: this.allowMajorVersionUpgrade,
            autoMinorVersionUpgrade: this.autoMinorVersionUpgrade,
            availabilityZone: this.availabilityZone,
            engineVersion: this.engineVersion,
            kmsKeyId: this.kmsKeyId,
            multiAz: this.multiAz,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            publiclyAccessible: this.publiclyAccessible,
            replicationInstanceIdentifier: this.replicationInstanceIdentifier,
            replicationSubnetGroupIdentifier: this.replicationSubnetGroupIdentifier,
            resourceIdentifier: this.resourceIdentifier,
            tags: this.tags.renderTags(),
            vpcSecurityGroupIds: this.vpcSecurityGroupIds,
        };
    }
    renderProperties(props) {
        return cfnReplicationInstancePropsToCloudFormation(props);
    }
}
exports.CfnReplicationInstance = CfnReplicationInstance;
_d = JSII_RTTI_SYMBOL_1;
CfnReplicationInstance[_d] = { fqn: "monocdk.aws_dms.CfnReplicationInstance", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReplicationInstance.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationInstance";
/**
 * Determine whether the given properties match those of a `CfnReplicationSubnetGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnReplicationSubnetGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnReplicationSubnetGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('replicationSubnetGroupDescription', cdk.requiredValidator)(properties.replicationSubnetGroupDescription));
    errors.collect(cdk.propertyValidator('replicationSubnetGroupDescription', cdk.validateString)(properties.replicationSubnetGroupDescription));
    errors.collect(cdk.propertyValidator('replicationSubnetGroupIdentifier', cdk.validateString)(properties.replicationSubnetGroupIdentifier));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.requiredValidator)(properties.subnetIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnReplicationSubnetGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::ReplicationSubnetGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnReplicationSubnetGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::ReplicationSubnetGroup` resource.
 */
// @ts-ignore TS6133
function cfnReplicationSubnetGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReplicationSubnetGroupPropsValidator(properties).assertSuccess();
    return {
        ReplicationSubnetGroupDescription: cdk.stringToCloudFormation(properties.replicationSubnetGroupDescription),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        ReplicationSubnetGroupIdentifier: cdk.stringToCloudFormation(properties.replicationSubnetGroupIdentifier),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnReplicationSubnetGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('replicationSubnetGroupDescription', 'ReplicationSubnetGroupDescription', cfn_parse.FromCloudFormation.getString(properties.ReplicationSubnetGroupDescription));
    ret.addPropertyResult('subnetIds', 'SubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds));
    ret.addPropertyResult('replicationSubnetGroupIdentifier', 'ReplicationSubnetGroupIdentifier', properties.ReplicationSubnetGroupIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationSubnetGroupIdentifier) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::ReplicationSubnetGroup`
 *
 * The `AWS::DMS::ReplicationSubnetGroup` resource creates an AWS DMS replication subnet group. Subnet groups must contain at least two subnets in two different Availability Zones in the same AWS Region .
 *
 * > Resource creation fails if the `dms-vpc-role` AWS Identity and Access Management ( IAM ) role doesn't already exist. For more information, see [Creating the IAM Roles to Use With the AWS CLI and AWS DMS API](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.APIRole.html) in the *AWS Database Migration Service User Guide* .
 *
 * @cloudformationResource AWS::DMS::ReplicationSubnetGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html
 */
class CfnReplicationSubnetGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::ReplicationSubnetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReplicationSubnetGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_dms_CfnReplicationSubnetGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnReplicationSubnetGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'replicationSubnetGroupDescription', this);
        cdk.requireProperty(props, 'subnetIds', this);
        this.replicationSubnetGroupDescription = props.replicationSubnetGroupDescription;
        this.subnetIds = props.subnetIds;
        this.replicationSubnetGroupIdentifier = props.replicationSubnetGroupIdentifier;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DMS::ReplicationSubnetGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReplicationSubnetGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnReplicationSubnetGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReplicationSubnetGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            replicationSubnetGroupDescription: this.replicationSubnetGroupDescription,
            subnetIds: this.subnetIds,
            replicationSubnetGroupIdentifier: this.replicationSubnetGroupIdentifier,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnReplicationSubnetGroupPropsToCloudFormation(props);
    }
}
exports.CfnReplicationSubnetGroup = CfnReplicationSubnetGroup;
_e = JSII_RTTI_SYMBOL_1;
CfnReplicationSubnetGroup[_e] = { fqn: "monocdk.aws_dms.CfnReplicationSubnetGroup", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReplicationSubnetGroup.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationSubnetGroup";
/**
 * Determine whether the given properties match those of a `CfnReplicationTaskProps`
 *
 * @param properties - the TypeScript properties of a `CfnReplicationTaskProps`
 *
 * @returns the result of the validation.
 */
function CfnReplicationTaskPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cdcStartPosition', cdk.validateString)(properties.cdcStartPosition));
    errors.collect(cdk.propertyValidator('cdcStartTime', cdk.validateNumber)(properties.cdcStartTime));
    errors.collect(cdk.propertyValidator('cdcStopPosition', cdk.validateString)(properties.cdcStopPosition));
    errors.collect(cdk.propertyValidator('migrationType', cdk.requiredValidator)(properties.migrationType));
    errors.collect(cdk.propertyValidator('migrationType', cdk.validateString)(properties.migrationType));
    errors.collect(cdk.propertyValidator('replicationInstanceArn', cdk.requiredValidator)(properties.replicationInstanceArn));
    errors.collect(cdk.propertyValidator('replicationInstanceArn', cdk.validateString)(properties.replicationInstanceArn));
    errors.collect(cdk.propertyValidator('replicationTaskIdentifier', cdk.validateString)(properties.replicationTaskIdentifier));
    errors.collect(cdk.propertyValidator('replicationTaskSettings', cdk.validateString)(properties.replicationTaskSettings));
    errors.collect(cdk.propertyValidator('resourceIdentifier', cdk.validateString)(properties.resourceIdentifier));
    errors.collect(cdk.propertyValidator('sourceEndpointArn', cdk.requiredValidator)(properties.sourceEndpointArn));
    errors.collect(cdk.propertyValidator('sourceEndpointArn', cdk.validateString)(properties.sourceEndpointArn));
    errors.collect(cdk.propertyValidator('tableMappings', cdk.requiredValidator)(properties.tableMappings));
    errors.collect(cdk.propertyValidator('tableMappings', cdk.validateString)(properties.tableMappings));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('targetEndpointArn', cdk.requiredValidator)(properties.targetEndpointArn));
    errors.collect(cdk.propertyValidator('targetEndpointArn', cdk.validateString)(properties.targetEndpointArn));
    errors.collect(cdk.propertyValidator('taskData', cdk.validateString)(properties.taskData));
    return errors.wrap('supplied properties not correct for "CfnReplicationTaskProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::ReplicationTask` resource
 *
 * @param properties - the TypeScript properties of a `CfnReplicationTaskProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::ReplicationTask` resource.
 */
// @ts-ignore TS6133
function cfnReplicationTaskPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReplicationTaskPropsValidator(properties).assertSuccess();
    return {
        MigrationType: cdk.stringToCloudFormation(properties.migrationType),
        ReplicationInstanceArn: cdk.stringToCloudFormation(properties.replicationInstanceArn),
        SourceEndpointArn: cdk.stringToCloudFormation(properties.sourceEndpointArn),
        TableMappings: cdk.stringToCloudFormation(properties.tableMappings),
        TargetEndpointArn: cdk.stringToCloudFormation(properties.targetEndpointArn),
        CdcStartPosition: cdk.stringToCloudFormation(properties.cdcStartPosition),
        CdcStartTime: cdk.numberToCloudFormation(properties.cdcStartTime),
        CdcStopPosition: cdk.stringToCloudFormation(properties.cdcStopPosition),
        ReplicationTaskIdentifier: cdk.stringToCloudFormation(properties.replicationTaskIdentifier),
        ReplicationTaskSettings: cdk.stringToCloudFormation(properties.replicationTaskSettings),
        ResourceIdentifier: cdk.stringToCloudFormation(properties.resourceIdentifier),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TaskData: cdk.stringToCloudFormation(properties.taskData),
    };
}
// @ts-ignore TS6133
function CfnReplicationTaskPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('migrationType', 'MigrationType', cfn_parse.FromCloudFormation.getString(properties.MigrationType));
    ret.addPropertyResult('replicationInstanceArn', 'ReplicationInstanceArn', cfn_parse.FromCloudFormation.getString(properties.ReplicationInstanceArn));
    ret.addPropertyResult('sourceEndpointArn', 'SourceEndpointArn', cfn_parse.FromCloudFormation.getString(properties.SourceEndpointArn));
    ret.addPropertyResult('tableMappings', 'TableMappings', cfn_parse.FromCloudFormation.getString(properties.TableMappings));
    ret.addPropertyResult('targetEndpointArn', 'TargetEndpointArn', cfn_parse.FromCloudFormation.getString(properties.TargetEndpointArn));
    ret.addPropertyResult('cdcStartPosition', 'CdcStartPosition', properties.CdcStartPosition != null ? cfn_parse.FromCloudFormation.getString(properties.CdcStartPosition) : undefined);
    ret.addPropertyResult('cdcStartTime', 'CdcStartTime', properties.CdcStartTime != null ? cfn_parse.FromCloudFormation.getNumber(properties.CdcStartTime) : undefined);
    ret.addPropertyResult('cdcStopPosition', 'CdcStopPosition', properties.CdcStopPosition != null ? cfn_parse.FromCloudFormation.getString(properties.CdcStopPosition) : undefined);
    ret.addPropertyResult('replicationTaskIdentifier', 'ReplicationTaskIdentifier', properties.ReplicationTaskIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationTaskIdentifier) : undefined);
    ret.addPropertyResult('replicationTaskSettings', 'ReplicationTaskSettings', properties.ReplicationTaskSettings != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationTaskSettings) : undefined);
    ret.addPropertyResult('resourceIdentifier', 'ResourceIdentifier', properties.ResourceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceIdentifier) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('taskData', 'TaskData', properties.TaskData != null ? cfn_parse.FromCloudFormation.getString(properties.TaskData) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::ReplicationTask`
 *
 * The `AWS::DMS::ReplicationTask` resource creates an AWS DMS replication task.
 *
 * @cloudformationResource AWS::DMS::ReplicationTask
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html
 */
class CfnReplicationTask extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::ReplicationTask`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReplicationTask.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_dms_CfnReplicationTaskProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnReplicationTask);
            }
            throw error;
        }
        cdk.requireProperty(props, 'migrationType', this);
        cdk.requireProperty(props, 'replicationInstanceArn', this);
        cdk.requireProperty(props, 'sourceEndpointArn', this);
        cdk.requireProperty(props, 'tableMappings', this);
        cdk.requireProperty(props, 'targetEndpointArn', this);
        this.migrationType = props.migrationType;
        this.replicationInstanceArn = props.replicationInstanceArn;
        this.sourceEndpointArn = props.sourceEndpointArn;
        this.tableMappings = props.tableMappings;
        this.targetEndpointArn = props.targetEndpointArn;
        this.cdcStartPosition = props.cdcStartPosition;
        this.cdcStartTime = props.cdcStartTime;
        this.cdcStopPosition = props.cdcStopPosition;
        this.replicationTaskIdentifier = props.replicationTaskIdentifier;
        this.replicationTaskSettings = props.replicationTaskSettings;
        this.resourceIdentifier = props.resourceIdentifier;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DMS::ReplicationTask", props.tags, { tagPropertyName: 'tags' });
        this.taskData = props.taskData;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReplicationTaskPropsFromCloudFormation(resourceProperties);
        const ret = new CfnReplicationTask(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReplicationTask.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            migrationType: this.migrationType,
            replicationInstanceArn: this.replicationInstanceArn,
            sourceEndpointArn: this.sourceEndpointArn,
            tableMappings: this.tableMappings,
            targetEndpointArn: this.targetEndpointArn,
            cdcStartPosition: this.cdcStartPosition,
            cdcStartTime: this.cdcStartTime,
            cdcStopPosition: this.cdcStopPosition,
            replicationTaskIdentifier: this.replicationTaskIdentifier,
            replicationTaskSettings: this.replicationTaskSettings,
            resourceIdentifier: this.resourceIdentifier,
            tags: this.tags.renderTags(),
            taskData: this.taskData,
        };
    }
    renderProperties(props) {
        return cfnReplicationTaskPropsToCloudFormation(props);
    }
}
exports.CfnReplicationTask = CfnReplicationTask;
_f = JSII_RTTI_SYMBOL_1;
CfnReplicationTask[_f] = { fqn: "monocdk.aws_dms.CfnReplicationTask", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReplicationTask.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationTask";
//# sourceMappingURL=data:application/json;base64,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