"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentityPoolRoleAttachment = exports.RoleMappingMatchType = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cognito_1 = require("../../aws-cognito");
const core_1 = require("../../core");
/**
 * Types of matches allowed for Role Mapping
 */
var RoleMappingMatchType;
(function (RoleMappingMatchType) {
    /**
     * The Claim from the token must equal the given value in order for a match
     */
    RoleMappingMatchType["EQUALS"] = "Equals";
    /**
     * The Claim from the token must contain the given value in order for a match
     */
    RoleMappingMatchType["CONTAINS"] = "Contains";
    /**
     * The Claim from the token must start with the given value in order for a match
     */
    RoleMappingMatchType["STARTS_WITH"] = "StartsWith";
    /**
     * The Claim from the token must not equal the given value in order for a match
     */
    RoleMappingMatchType["NOTEQUAL"] = "NotEqual";
})(RoleMappingMatchType = exports.RoleMappingMatchType || (exports.RoleMappingMatchType = {}));
/**
 * Defines an Identity Pool Role Attachment
 *
 * @resource AWS::Cognito::IdentityPoolRoleAttachment
 */
class IdentityPoolRoleAttachment extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_aws_cognito_identitypool_IdentityPoolRoleAttachmentProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IdentityPoolRoleAttachment);
            }
            throw error;
        }
        this.identityPoolId = props.identityPool.identityPoolId;
        const mappings = props.roleMappings || [];
        let roles = undefined, roleMappings = undefined;
        if (props.authenticatedRole || props.unauthenticatedRole) {
            roles = {};
            if (props.authenticatedRole)
                roles.authenticated = props.authenticatedRole.roleArn;
            if (props.unauthenticatedRole)
                roles.unauthenticated = props.unauthenticatedRole.roleArn;
        }
        if (mappings) {
            roleMappings = this.configureRoleMappings(...mappings);
        }
        new aws_cognito_1.CfnIdentityPoolRoleAttachment(this, 'Resource', {
            identityPoolId: this.identityPoolId,
            roles,
            roleMappings,
        });
    }
    /**
     * Configures Role Mappings for Identity Pool Role Attachment
     */
    configureRoleMappings(...props) {
        if (!props || !props.length)
            return undefined;
        return props.reduce((acc, prop) => {
            let roleMapping = {
                ambiguousRoleResolution: prop.resolveAmbiguousRoles ? 'AuthenticatedRole' : 'Deny',
                type: prop.useToken ? 'Token' : 'Rules',
                identityProvider: prop.providerUrl.value,
            };
            if (roleMapping.type === 'Rules') {
                if (!prop.rules) {
                    throw new Error('IdentityPoolRoleMapping.rules is required when useToken is false');
                }
                roleMapping.rulesConfiguration = {
                    rules: prop.rules.map(rule => {
                        return {
                            claim: rule.claim,
                            value: rule.claimValue,
                            matchType: rule.matchType || RoleMappingMatchType.EQUALS,
                            roleArn: rule.mappedRole.roleArn,
                        };
                    }),
                };
            }
            ;
            acc[prop.providerUrl.value] = roleMapping;
            return acc;
        }, {});
    }
}
exports.IdentityPoolRoleAttachment = IdentityPoolRoleAttachment;
_a = JSII_RTTI_SYMBOL_1;
IdentityPoolRoleAttachment[_a] = { fqn: "monocdk.aws_cognito_identitypool.IdentityPoolRoleAttachment", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaWRlbnRpdHlwb29sLXJvbGUtYXR0YWNobWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImlkZW50aXR5cG9vbC1yb2xlLWF0dGFjaG1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsbURBRTJCO0FBSTNCLHFDQUdvQjtBQStFcEI7O0dBRUc7QUFDSCxJQUFZLG9CQW9CWDtBQXBCRCxXQUFZLG9CQUFvQjtJQUM5Qjs7T0FFRztJQUNILHlDQUFpQixDQUFBO0lBRWpCOztPQUVHO0lBQ0gsNkNBQXFCLENBQUE7SUFFckI7O09BRUc7SUFDSCxrREFBMEIsQ0FBQTtJQUUxQjs7T0FFRztJQUNILDZDQUFxQixDQUFBO0FBQ3ZCLENBQUMsRUFwQlcsb0JBQW9CLEdBQXBCLDRCQUFvQixLQUFwQiw0QkFBb0IsUUFvQi9CO0FBNEJEOzs7O0dBSUc7QUFDSCxNQUFhLDBCQUEyQixTQUFRLGVBQVE7SUFNdEQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFzQztRQUM5RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7K0NBUFIsMEJBQTBCOzs7O1FBUW5DLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQyxjQUFjLENBQUM7UUFDeEQsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLFlBQVksSUFBSSxFQUFFLENBQUM7UUFDMUMsSUFBSSxLQUFLLEdBQVEsU0FBUyxFQUFFLFlBQVksR0FBUSxTQUFTLENBQUM7UUFDMUQsSUFBSSxLQUFLLENBQUMsaUJBQWlCLElBQUksS0FBSyxDQUFDLG1CQUFtQixFQUFFO1lBQ3hELEtBQUssR0FBRyxFQUFFLENBQUM7WUFDWCxJQUFJLEtBQUssQ0FBQyxpQkFBaUI7Z0JBQUUsS0FBSyxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUMsT0FBTyxDQUFDO1lBQ25GLElBQUksS0FBSyxDQUFDLG1CQUFtQjtnQkFBRSxLQUFLLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLENBQUM7U0FDMUY7UUFDRCxJQUFJLFFBQVEsRUFBRTtZQUNaLFlBQVksR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsR0FBRyxRQUFRLENBQUMsQ0FBQztTQUN4RDtRQUNELElBQUksMkNBQTZCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNsRCxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsS0FBSztZQUNMLFlBQVk7U0FDYixDQUFDLENBQUM7S0FDSjtJQUVEOztPQUVHO0lBQ0sscUJBQXFCLENBQzNCLEdBQUcsS0FBZ0M7UUFFbkMsSUFBSSxDQUFDLEtBQUssSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNO1lBQUUsT0FBTyxTQUFTLENBQUM7UUFDOUMsT0FBTyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBRyxFQUFFLElBQUksRUFBRSxFQUFFO1lBQ2hDLElBQUksV0FBVyxHQUFRO2dCQUNyQix1QkFBdUIsRUFBRSxJQUFJLENBQUMscUJBQXFCLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxNQUFNO2dCQUNsRixJQUFJLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxPQUFPO2dCQUN2QyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUs7YUFDekMsQ0FBQztZQUNGLElBQUksV0FBVyxDQUFDLElBQUksS0FBSyxPQUFPLEVBQUU7Z0JBQ2hDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFO29CQUNmLE1BQU0sSUFBSSxLQUFLLENBQUMsa0VBQWtFLENBQUMsQ0FBQztpQkFDckY7Z0JBQ0QsV0FBVyxDQUFDLGtCQUFrQixHQUFHO29CQUMvQixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUU7d0JBQzNCLE9BQU87NEJBQ0wsS0FBSyxFQUFFLElBQUksQ0FBQyxLQUFLOzRCQUNqQixLQUFLLEVBQUUsSUFBSSxDQUFDLFVBQVU7NEJBQ3RCLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUyxJQUFJLG9CQUFvQixDQUFDLE1BQU07NEJBQ3hELE9BQU8sRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU87eUJBQ2pDLENBQUM7b0JBQ0osQ0FBQyxDQUFDO2lCQUNILENBQUM7YUFDSDtZQUFBLENBQUM7WUFDRixHQUFHLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsR0FBRyxXQUFXLENBQUM7WUFDMUMsT0FBTyxHQUFHLENBQUM7UUFDYixDQUFDLEVBQUUsRUFBMEUsQ0FBQyxDQUFDO0tBQ2hGOztBQXpESCxnRUEwREMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBDZm5JZGVudGl0eVBvb2xSb2xlQXR0YWNobWVudCxcbn0gZnJvbSAnLi4vLi4vYXdzLWNvZ25pdG8nO1xuaW1wb3J0IHtcbiAgSVJvbGUsXG59IGZyb20gJy4uLy4uL2F3cy1pYW0nO1xuaW1wb3J0IHtcbiAgUmVzb3VyY2UsXG4gIElSZXNvdXJjZSxcbn0gZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQge1xuICBDb25zdHJ1Y3QsXG59IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHtcbiAgSUlkZW50aXR5UG9vbCxcbiAgSWRlbnRpdHlQb29sUHJvdmlkZXJVcmwsXG59IGZyb20gJy4vaWRlbnRpdHlwb29sJztcblxuLyoqXG4gKiBSZXByZXNlbnRzIGFuIElkZW50aXR5IFBvb2wgUm9sZSBBdHRhY2htZW50XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUlkZW50aXR5UG9vbFJvbGVBdHRhY2htZW50IGV4dGVuZHMgSVJlc291cmNlIHtcbiAgLyoqXG4gICAqIElkIG9mIHRoZSBBdHRhY2htZW50cyBVbmRlcmx5aW5nIElkZW50aXR5IFBvb2xcbiAgICovXG4gIHJlYWRvbmx5IGlkZW50aXR5UG9vbElkOiBzdHJpbmc7XG59XG5cbi8qKlxuICogUHJvcHMgZm9yIGFuIElkZW50aXR5IFBvb2wgUm9sZSBBdHRhY2htZW50XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSWRlbnRpdHlQb29sUm9sZUF0dGFjaG1lbnRQcm9wcyB7XG5cbiAgLyoqXG4gICAqIElkIG9mIHRoZSBBdHRhY2htZW50cyBVbmRlcmx5aW5nIElkZW50aXR5IFBvb2xcbiAgICovXG4gIHJlYWRvbmx5IGlkZW50aXR5UG9vbDogSUlkZW50aXR5UG9vbDtcblxuICAvKipcbiAgICogRGVmYXVsdCBBdXRoZW50aWNhdGVkIChVc2VyKSBSb2xlXG4gICAqIEBkZWZhdWx0IC0gTm8gZGVmYXVsdCBhdXRoZW50aWNhdGVkIHJvbGUgd2lsbCBiZSBhZGRlZFxuICAgKi9cbiAgcmVhZG9ubHkgYXV0aGVudGljYXRlZFJvbGU/OiBJUm9sZTtcblxuICAvKipcbiAgICAqIERlZmF1bHQgVW5hdXRoZW50aWNhdGVkIChHdWVzdCkgUm9sZVxuICAgICogQGRlZmF1bHQgLSBObyBkZWZhdWx0IHVuYXV0aGVudGljYXRlZCByb2xlIHdpbGwgYmUgYWRkZWRcbiAgICAqL1xuICByZWFkb25seSB1bmF1dGhlbnRpY2F0ZWRSb2xlPzogSVJvbGU7XG5cbiAgLyoqXG4gICAqIFJ1bGVzIGZvciBtYXBwaW5nIHJvbGVzIHRvIHVzZXJzXG4gICAqIEBkZWZhdWx0IC0gbm8gUm9sZSBNYXBwaW5nc1xuICAgKi9cbiAgcmVhZG9ubHkgcm9sZU1hcHBpbmdzPzogSWRlbnRpdHlQb29sUm9sZU1hcHBpbmdbXTtcbn1cblxuLyoqXG4gKiBNYXAgcm9sZXMgdG8gdXNlcnMgaW4gdGhlIGlkZW50aXR5IHBvb2wgYmFzZWQgb24gY2xhaW1zIGZyb20gdGhlIElkZW50aXR5IFByb3ZpZGVyXG4gKiAgQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY29nbml0by1pZGVudGl0eXBvb2xyb2xlYXR0YWNobWVudC5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSWRlbnRpdHlQb29sUm9sZU1hcHBpbmcge1xuICAvKipcbiAgICogVGhlIHVybCBvZiB0aGUgcHJvdmlkZXIgb2YgZm9yIHdoaWNoIHRoZSByb2xlIGlzIG1hcHBlZFxuICAgKi9cbiAgcmVhZG9ubHkgcHJvdmlkZXJVcmw6IElkZW50aXR5UG9vbFByb3ZpZGVyVXJsO1xuXG4gIC8qKlxuICAgKiAgSWYgdHJ1ZSB0aGVuIG1hcHBlZCByb2xlcyBtdXN0IGJlIHBhc3NlZCB0aHJvdWdoIHRoZSBjb2duaXRvOnJvbGVzIG9yIGNvZ25pdG86cHJlZmVycmVkX3JvbGUgY2xhaW1zIGZyb20gaWRlbnRpdHkgcHJvdmlkZXIuXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvZ25pdG8vbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3JvbGUtYmFzZWQtYWNjZXNzLWNvbnRyb2wuaHRtbCN1c2luZy10b2tlbnMtdG8tYXNzaWduLXJvbGVzLXRvLXVzZXJzXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSB1c2VUb2tlbj86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIEFsbG93IGZvciByb2xlIGFzc3VtcHRpb24gd2hlbiByZXN1bHRzIG9mIHJvbGUgbWFwcGluZyBhcmUgYW1iaWd1b3VzXG4gICAqIEBkZWZhdWx0IGZhbHNlIC0gQW1iaWd1b3VzIHJvbGUgcmVzb2x1dGlvbnMgd2lsbCBsZWFkIHRvIHJlcXVlc3RlciBiZWluZyBkZW5pZWRcbiAgICovXG4gIHJlYWRvbmx5IHJlc29sdmVBbWJpZ3VvdXNSb2xlcz86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSBjbGFpbSBhbmQgdmFsdWUgdGhhdCBtdXN0IGJlIG1hdGNoZWQgaW4gb3JkZXIgdG8gYXNzdW1lIHRoZSByb2xlLiBSZXF1aXJlZCBpZiB1c2VUb2tlbiBpcyBmYWxzZVxuICAgKiBAZGVmYXVsdCAtIE5vIFJ1bGUgTWFwcGluZyBSdWxlXG4gICAqL1xuICByZWFkb25seSBydWxlcz86IFJvbGVNYXBwaW5nUnVsZVtdO1xufVxuXG4vKipcbiAqIFR5cGVzIG9mIG1hdGNoZXMgYWxsb3dlZCBmb3IgUm9sZSBNYXBwaW5nXG4gKi9cbmV4cG9ydCBlbnVtIFJvbGVNYXBwaW5nTWF0Y2hUeXBlIHtcbiAgLyoqXG4gICAqIFRoZSBDbGFpbSBmcm9tIHRoZSB0b2tlbiBtdXN0IGVxdWFsIHRoZSBnaXZlbiB2YWx1ZSBpbiBvcmRlciBmb3IgYSBtYXRjaFxuICAgKi9cbiAgRVFVQUxTID0gJ0VxdWFscycsXG5cbiAgLyoqXG4gICAqIFRoZSBDbGFpbSBmcm9tIHRoZSB0b2tlbiBtdXN0IGNvbnRhaW4gdGhlIGdpdmVuIHZhbHVlIGluIG9yZGVyIGZvciBhIG1hdGNoXG4gICAqL1xuICBDT05UQUlOUyA9ICdDb250YWlucycsXG5cbiAgLyoqXG4gICAqIFRoZSBDbGFpbSBmcm9tIHRoZSB0b2tlbiBtdXN0IHN0YXJ0IHdpdGggdGhlIGdpdmVuIHZhbHVlIGluIG9yZGVyIGZvciBhIG1hdGNoXG4gICAqL1xuICBTVEFSVFNfV0lUSCA9ICdTdGFydHNXaXRoJyxcblxuICAvKipcbiAgICogVGhlIENsYWltIGZyb20gdGhlIHRva2VuIG11c3Qgbm90IGVxdWFsIHRoZSBnaXZlbiB2YWx1ZSBpbiBvcmRlciBmb3IgYSBtYXRjaFxuICAgKi9cbiAgTk9URVFVQUwgPSAnTm90RXF1YWwnLFxufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgYW4gSWRlbnRpdHkgUG9vbCBSb2xlIEF0dGFjaG1lbnQgUm9sZSBNYXBwaW5nIFJ1bGVcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBSb2xlTWFwcGluZ1J1bGUge1xuICAvKipcbiAgICogVGhlIGtleSBzZW50IGluIHRoZSB0b2tlbiBieSB0aGUgZmVkZXJhdGVkIGlkZW50aXR5IHByb3ZpZGVyLlxuICAgKi9cbiAgcmVhZG9ubHkgY2xhaW06IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIFJvbGUgdG8gYmUgYXNzdW1lZCB3aGVuIENsYWltIFZhbHVlIGlzIG1hdGNoZWQuXG4gICAqL1xuICByZWFkb25seSBtYXBwZWRSb2xlOiBJUm9sZTtcblxuICAvKipcbiAgICogVGhlIHZhbHVlIG9mIHRoZSBjbGFpbSB0aGF0IG11c3QgYmUgbWF0Y2hlZFxuICAgKi9cbiAgcmVhZG9ubHkgY2xhaW1WYWx1ZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBIb3cgdG8gbWF0Y2ggd2l0aCB0aGUgQ2xhaW0gdmFsdWVcbiAgICogQGRlZmF1bHQgUm9sZU1hcHBpbmdNYXRjaFR5cGUuRVFVQUxTXG4gICovXG4gIHJlYWRvbmx5IG1hdGNoVHlwZT86IFJvbGVNYXBwaW5nTWF0Y2hUeXBlXG59XG5cbi8qKlxuICogRGVmaW5lcyBhbiBJZGVudGl0eSBQb29sIFJvbGUgQXR0YWNobWVudFxuICpcbiAqIEByZXNvdXJjZSBBV1M6OkNvZ25pdG86OklkZW50aXR5UG9vbFJvbGVBdHRhY2htZW50XG4gKi9cbmV4cG9ydCBjbGFzcyBJZGVudGl0eVBvb2xSb2xlQXR0YWNobWVudCBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUlkZW50aXR5UG9vbFJvbGVBdHRhY2htZW50IHtcbiAgLyoqXG4gICAqIElkIG9mIHRoZSB1bmRlcmx5aW5nIGlkZW50aXR5IHBvb2xcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBpZGVudGl0eVBvb2xJZDogc3RyaW5nXG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IElkZW50aXR5UG9vbFJvbGVBdHRhY2htZW50UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIHRoaXMuaWRlbnRpdHlQb29sSWQgPSBwcm9wcy5pZGVudGl0eVBvb2wuaWRlbnRpdHlQb29sSWQ7XG4gICAgY29uc3QgbWFwcGluZ3MgPSBwcm9wcy5yb2xlTWFwcGluZ3MgfHwgW107XG4gICAgbGV0IHJvbGVzOiBhbnkgPSB1bmRlZmluZWQsIHJvbGVNYXBwaW5nczogYW55ID0gdW5kZWZpbmVkO1xuICAgIGlmIChwcm9wcy5hdXRoZW50aWNhdGVkUm9sZSB8fCBwcm9wcy51bmF1dGhlbnRpY2F0ZWRSb2xlKSB7XG4gICAgICByb2xlcyA9IHt9O1xuICAgICAgaWYgKHByb3BzLmF1dGhlbnRpY2F0ZWRSb2xlKSByb2xlcy5hdXRoZW50aWNhdGVkID0gcHJvcHMuYXV0aGVudGljYXRlZFJvbGUucm9sZUFybjtcbiAgICAgIGlmIChwcm9wcy51bmF1dGhlbnRpY2F0ZWRSb2xlKSByb2xlcy51bmF1dGhlbnRpY2F0ZWQgPSBwcm9wcy51bmF1dGhlbnRpY2F0ZWRSb2xlLnJvbGVBcm47XG4gICAgfVxuICAgIGlmIChtYXBwaW5ncykge1xuICAgICAgcm9sZU1hcHBpbmdzID0gdGhpcy5jb25maWd1cmVSb2xlTWFwcGluZ3MoLi4ubWFwcGluZ3MpO1xuICAgIH1cbiAgICBuZXcgQ2ZuSWRlbnRpdHlQb29sUm9sZUF0dGFjaG1lbnQodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgaWRlbnRpdHlQb29sSWQ6IHRoaXMuaWRlbnRpdHlQb29sSWQsXG4gICAgICByb2xlcyxcbiAgICAgIHJvbGVNYXBwaW5ncyxcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDb25maWd1cmVzIFJvbGUgTWFwcGluZ3MgZm9yIElkZW50aXR5IFBvb2wgUm9sZSBBdHRhY2htZW50XG4gICAqL1xuICBwcml2YXRlIGNvbmZpZ3VyZVJvbGVNYXBwaW5ncyhcbiAgICAuLi5wcm9wczogSWRlbnRpdHlQb29sUm9sZU1hcHBpbmdbXVxuICApOiB7IFtuYW1lOnN0cmluZ106IENmbklkZW50aXR5UG9vbFJvbGVBdHRhY2htZW50LlJvbGVNYXBwaW5nUHJvcGVydHkgfSB8IHVuZGVmaW5lZCB7XG4gICAgaWYgKCFwcm9wcyB8fCAhcHJvcHMubGVuZ3RoKSByZXR1cm4gdW5kZWZpbmVkO1xuICAgIHJldHVybiBwcm9wcy5yZWR1Y2UoKGFjYywgcHJvcCkgPT4ge1xuICAgICAgbGV0IHJvbGVNYXBwaW5nOiBhbnkgPSB7XG4gICAgICAgIGFtYmlndW91c1JvbGVSZXNvbHV0aW9uOiBwcm9wLnJlc29sdmVBbWJpZ3VvdXNSb2xlcyA/ICdBdXRoZW50aWNhdGVkUm9sZScgOiAnRGVueScsXG4gICAgICAgIHR5cGU6IHByb3AudXNlVG9rZW4gPyAnVG9rZW4nIDogJ1J1bGVzJyxcbiAgICAgICAgaWRlbnRpdHlQcm92aWRlcjogcHJvcC5wcm92aWRlclVybC52YWx1ZSxcbiAgICAgIH07XG4gICAgICBpZiAocm9sZU1hcHBpbmcudHlwZSA9PT0gJ1J1bGVzJykge1xuICAgICAgICBpZiAoIXByb3AucnVsZXMpIHtcbiAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0lkZW50aXR5UG9vbFJvbGVNYXBwaW5nLnJ1bGVzIGlzIHJlcXVpcmVkIHdoZW4gdXNlVG9rZW4gaXMgZmFsc2UnKTtcbiAgICAgICAgfVxuICAgICAgICByb2xlTWFwcGluZy5ydWxlc0NvbmZpZ3VyYXRpb24gPSB7XG4gICAgICAgICAgcnVsZXM6IHByb3AucnVsZXMubWFwKHJ1bGUgPT4ge1xuICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgY2xhaW06IHJ1bGUuY2xhaW0sXG4gICAgICAgICAgICAgIHZhbHVlOiBydWxlLmNsYWltVmFsdWUsXG4gICAgICAgICAgICAgIG1hdGNoVHlwZTogcnVsZS5tYXRjaFR5cGUgfHwgUm9sZU1hcHBpbmdNYXRjaFR5cGUuRVFVQUxTLFxuICAgICAgICAgICAgICByb2xlQXJuOiBydWxlLm1hcHBlZFJvbGUucm9sZUFybixcbiAgICAgICAgICAgIH07XG4gICAgICAgICAgfSksXG4gICAgICAgIH07XG4gICAgICB9O1xuICAgICAgYWNjW3Byb3AucHJvdmlkZXJVcmwudmFsdWVdID0gcm9sZU1hcHBpbmc7XG4gICAgICByZXR1cm4gYWNjO1xuICAgIH0sIHt9IGFzIHsgW25hbWU6c3RyaW5nXTogQ2ZuSWRlbnRpdHlQb29sUm9sZUF0dGFjaG1lbnQuUm9sZU1hcHBpbmdQcm9wZXJ0eSB9KTtcbiAgfVxufSJdfQ==