"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceCatalogDeployActionBeta1 = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const iam = require("../../../aws-iam");
const action_1 = require("../action");
/**
 * CodePipeline action to connect to an existing ServiceCatalog product.
 *
 * **Note**: this class is still experimental, and may have breaking changes in the future!
 */
class ServiceCatalogDeployActionBeta1 extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            provider: 'ServiceCatalog',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.templatePath.artifact],
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_actions_ServiceCatalogDeployActionBeta1Props(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ServiceCatalogDeployActionBeta1);
            }
            throw error;
        }
        this.templatePath = props.templatePath.fileName;
        this.productVersionName = props.productVersionName;
        this.productVersionDescription = props.productVersionDescription;
        this.productId = props.productId;
        this.productType = 'CLOUD_FORMATION_TEMPLATE';
    }
    bound(_scope, _stage, options) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(_stage);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bound);
            }
            throw error;
        }
        options.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AWSServiceCatalogAdminFullAccess'));
        // Attempt at least privilege; using this alone fails with "invalid template".
        // Should construct ARN: 'arn:aws:catalog:<region>:<accountID>:product/' + this.scProductId
        // options.role.addToPolicy(new PolicyStatement({
        //   resources: ['*'],
        //   actions: ['servicecatalog:UpdateProduct', 'servicecatalog:ListProvisioningArtifacts', 'servicecatalog:CreateProvisioningArtifact'],
        // }));
        // the Action's Role needs to read from the Bucket to get artifacts
        options.bucket.grantRead(options.role);
        return {
            configuration: {
                TemplateFilePath: this.templatePath,
                ProductVersionName: this.productVersionName,
                ProductVersionDescription: this.productVersionDescription,
                ProductType: this.productType,
                ProductId: this.productId,
            },
        };
    }
}
exports.ServiceCatalogDeployActionBeta1 = ServiceCatalogDeployActionBeta1;
_a = JSII_RTTI_SYMBOL_1;
ServiceCatalogDeployActionBeta1[_a] = { fqn: "monocdk.aws_codepipeline_actions.ServiceCatalogDeployActionBeta1", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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