"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationDeployStackSetAction = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const action_1 = require("../action");
const common_1 = require("../common");
const singleton_policy_1 = require("./private/singleton-policy");
const stackset_types_1 = require("./stackset-types");
/**
 * CodePipeline action to deploy a stackset.
 *
 * CodePipeline offers the ability to perform AWS CloudFormation StackSets
 * operations as part of your CI/CD process. You use a stack set to create
 * stacks in AWS accounts across AWS Regions by using a single AWS
 * CloudFormation template. All the resources included in each stack are defined
 * by the stack set’s AWS CloudFormation template. When you create the stack
 * set, you specify the template to use, as well as any parameters and
 * capabilities that the template requires.
 *
 * For more information about concepts for AWS CloudFormation StackSets, see
 * [StackSets
 * concepts](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html)
 * in the AWS CloudFormation User Guide.
 *
 * If you use this action to make an update that includes adding stack
 * instances, the new instances are deployed first and the update is completed
 * last. The new instances first receive the old version, and then the update is
 * applied to all instances.
 *
 * As a best practice, you should construct your pipeline so that the stack set
 * is created and initially deploys to a subset or a single instance. After you
 * test your deployment and view the generated stack set, then add the
 * CloudFormationStackInstances action so that the remaining instances are
 * created and updated.
 */
class CloudFormationDeployStackSetAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            region: props.stackSetRegion,
            provider: 'CloudFormationStackSet',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 1,
                maxInputs: 3,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [
                ...props.template._artifactsReferenced ?? [],
                ...props.parameters?._artifactsReferenced ?? [],
                ...props.stackInstances?._artifactsReferenced ?? [],
            ],
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_actions_CloudFormationDeployStackSetActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudFormationDeployStackSetAction);
            }
            throw error;
        }
        this.props = props;
        this.deploymentModel = props.deploymentModel ?? stackset_types_1.StackSetDeploymentModel.selfManaged();
        common_1.validatePercentage('failureTolerancePercentage', props.failureTolerancePercentage);
        common_1.validatePercentage('maxAccountConcurrencyPercentage', props.maxAccountConcurrencyPercentage);
    }
    bound(scope, _stage, options) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(_stage);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bound);
            }
            throw error;
        }
        const singletonPolicy = singleton_policy_1.SingletonPolicy.forRole(options.role);
        singletonPolicy.grantCreateUpdateStackSet(this.props);
        const instancesResult = this.props.stackInstances?._bind(scope);
        const permissionModelBind = this.deploymentModel?._bind(scope);
        for (const role of permissionModelBind?.passedRoles ?? []) {
            singletonPolicy.grantPassRole(role);
        }
        if ((this.actionProperties.inputs || []).length > 0) {
            options.bucket.grantRead(singletonPolicy);
        }
        return {
            configuration: {
                StackSetName: this.props.stackSetName,
                Description: this.props.description,
                TemplatePath: this.props.template._render(),
                Parameters: this.props.parameters?._render(),
                Capabilities: singleton_policy_1.parseCapabilities(this.props.cfnCapabilities),
                FailureTolerancePercentage: this.props.failureTolerancePercentage,
                MaxConcurrentPercentage: this.props.maxAccountConcurrencyPercentage,
                ...instancesResult?.stackSetConfiguration,
                ...permissionModelBind?.stackSetConfiguration,
            },
        };
    }
}
exports.CloudFormationDeployStackSetAction = CloudFormationDeployStackSetAction;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationDeployStackSetAction[_a] = { fqn: "monocdk.aws_codepipeline_actions.CloudFormationDeployStackSetAction", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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