"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlexaSkillDeployAction = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const action_1 = require("../action");
/**
 * Deploys the skill to Alexa
 */
class AlexaSkillDeployAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.DEPLOY,
            owner: 'ThirdParty',
            provider: 'AlexaSkillsKit',
            artifactBounds: {
                minInputs: 1,
                maxInputs: 2,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: getInputs(props),
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_actions_AlexaSkillDeployActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AlexaSkillDeployAction);
            }
            throw error;
        }
        this.props = props;
    }
    bound(_scope, _stage, _options) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(_stage);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bound);
            }
            throw error;
        }
        return {
            configuration: {
                ClientId: this.props.clientId,
                ClientSecret: this.props.clientSecret.unsafeUnwrap(),
                RefreshToken: this.props.refreshToken.unsafeUnwrap(),
                SkillId: this.props.skillId,
            },
        };
    }
}
exports.AlexaSkillDeployAction = AlexaSkillDeployAction;
_a = JSII_RTTI_SYMBOL_1;
AlexaSkillDeployAction[_a] = { fqn: "monocdk.aws_codepipeline_actions.AlexaSkillDeployAction", version: "1.185.0" };
function getInputs(props) {
    const ret = [props.input];
    if (props.parameterOverridesArtifact) {
        ret.push(props.parameterOverridesArtifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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