"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancer = exports.LoadBalancerGeneration = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The generations of AWS load balancing solutions.
 */
var LoadBalancerGeneration;
(function (LoadBalancerGeneration) {
    /**
     * The first generation (ELB Classic).
     */
    LoadBalancerGeneration[LoadBalancerGeneration["FIRST"] = 0] = "FIRST";
    /**
     * The second generation (ALB and NLB).
     */
    LoadBalancerGeneration[LoadBalancerGeneration["SECOND"] = 1] = "SECOND";
})(LoadBalancerGeneration = exports.LoadBalancerGeneration || (exports.LoadBalancerGeneration = {}));
/**
 * An interface of an abstract load balancer, as needed by CodeDeploy.
 * Create instances using the static factory methods:
 * {@link #classic}, {@link #application} and {@link #network}.
 */
class LoadBalancer {
    /**
     * Creates a new CodeDeploy load balancer from a Classic ELB Load Balancer.
     *
     * @param loadBalancer a classic ELB Load Balancer
     */
    static classic(loadBalancer) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancing_LoadBalancer(loadBalancer);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.classic);
            }
            throw error;
        }
        class ClassicLoadBalancer extends LoadBalancer {
            constructor() {
                super(...arguments);
                this.generation = LoadBalancerGeneration.FIRST;
                this.name = loadBalancer.loadBalancerName;
            }
        }
        return new ClassicLoadBalancer();
    }
    /**
     * Creates a new CodeDeploy load balancer from an Application Load Balancer Target Group.
     *
     * @param albTargetGroup an ALB Target Group
     */
    static application(albTargetGroup) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_IApplicationTargetGroup(albTargetGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.application);
            }
            throw error;
        }
        class AlbLoadBalancer extends LoadBalancer {
            constructor() {
                super(...arguments);
                this.generation = LoadBalancerGeneration.SECOND;
                this.name = albTargetGroup.targetGroupName;
            }
        }
        return new AlbLoadBalancer();
    }
    /**
     * Creates a new CodeDeploy load balancer from a Network Load Balancer Target Group.
     *
     * @param nlbTargetGroup an NLB Target Group
     */
    static network(nlbTargetGroup) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_INetworkTargetGroup(nlbTargetGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.network);
            }
            throw error;
        }
        class NlbLoadBalancer extends LoadBalancer {
            constructor() {
                super(...arguments);
                this.generation = LoadBalancerGeneration.SECOND;
                this.name = nlbTargetGroup.targetGroupName;
            }
        }
        return new NlbLoadBalancer();
    }
}
exports.LoadBalancer = LoadBalancer;
_a = JSII_RTTI_SYMBOL_1;
LoadBalancer[_a] = { fqn: "monocdk.aws_codedeploy.LoadBalancer", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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