"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportGroup = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const cdk = require("../../core");
const codebuild_generated_1 = require("./codebuild.generated");
const report_group_utils_1 = require("./report-group-utils");
class ReportGroupBase extends cdk.Resource {
    grantWrite(identity) {
        const ret = iam.Grant.addToPrincipal({
            grantee: identity,
            actions: [
                'codebuild:CreateReport',
                'codebuild:UpdateReport',
                'codebuild:BatchPutTestCases',
            ],
            resourceArns: [this.reportGroupArn],
        });
        if (this.exportBucket) {
            this.exportBucket.grantWrite(identity);
        }
        return ret;
    }
}
/**
 * The ReportGroup resource class.
 */
class ReportGroup extends ReportGroupBase {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.reportGroupName,
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_codebuild_ReportGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ReportGroup);
            }
            throw error;
        }
        const resource = new codebuild_generated_1.CfnReportGroup(this, 'Resource', {
            type: 'TEST',
            exportConfig: {
                exportConfigType: props.exportBucket ? 'S3' : 'NO_EXPORT',
                s3Destination: props.exportBucket
                    ? {
                        bucket: props.exportBucket.bucketName,
                        encryptionDisabled: props.exportBucket.encryptionKey ? false : undefined,
                        encryptionKey: props.exportBucket.encryptionKey?.keyArn,
                        packaging: props.zipExport ? 'ZIP' : undefined,
                    }
                    : undefined,
            },
            name: props.reportGroupName,
        });
        resource.applyRemovalPolicy(props.removalPolicy, {
            default: cdk.RemovalPolicy.RETAIN,
        });
        this.reportGroupArn = this.getResourceArnAttribute(resource.attrArn, report_group_utils_1.reportGroupArnComponents(this.physicalName));
        this.reportGroupName = this.getResourceNameAttribute(
        // there is no separate name attribute,
        // so use Fn::Select + Fn::Split to make one
        cdk.Fn.select(1, cdk.Fn.split('/', resource.ref)));
        this.exportBucket = props.exportBucket;
    }
    /**
     * Reference an existing ReportGroup,
     * defined outside of the CDK code,
     * by name.
     */
    static fromReportGroupName(scope, id, reportGroupName) {
        class Import extends ReportGroupBase {
            constructor() {
                super(...arguments);
                this.reportGroupName = reportGroupName;
                this.reportGroupArn = report_group_utils_1.renderReportGroupArn(scope, reportGroupName);
                this.exportBucket = undefined;
            }
        }
        return new Import(scope, id);
    }
}
exports.ReportGroup = ReportGroup;
_a = JSII_RTTI_SYMBOL_1;
ReportGroup[_a] = { fqn: "monocdk.aws_codebuild.ReportGroup", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVwb3J0LWdyb3VwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicmVwb3J0LWdyb3VwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHFDQUFxQztBQUVyQyxrQ0FBa0M7QUFFbEMsK0RBQXVEO0FBQ3ZELDZEQUFzRjtBQStCdEYsTUFBZSxlQUFnQixTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBSzFDLFVBQVUsQ0FBQyxRQUF3QjtRQUN4QyxNQUFNLEdBQUcsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQztZQUNuQyxPQUFPLEVBQUUsUUFBUTtZQUNqQixPQUFPLEVBQUU7Z0JBQ1Asd0JBQXdCO2dCQUN4Qix3QkFBd0I7Z0JBQ3hCLDZCQUE2QjthQUM5QjtZQUNELFlBQVksRUFBRSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7U0FDcEMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxJQUFJLENBQUMsWUFBWSxFQUFFO1lBQ3JCLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1NBQ3hDO1FBRUQsT0FBTyxHQUFHLENBQUM7S0FDWjtDQUNGO0FBdUNEOztHQUVHO0FBQ0gsTUFBYSxXQUFZLFNBQVEsZUFBZTtJQXFCOUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUEwQixFQUFFO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsWUFBWSxFQUFFLEtBQUssQ0FBQyxlQUFlO1NBQ3BDLENBQUMsQ0FBQzs7Ozs7OytDQXhCTSxXQUFXOzs7O1FBMEJwQixNQUFNLFFBQVEsR0FBRyxJQUFJLG9DQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNwRCxJQUFJLEVBQUUsTUFBTTtZQUNaLFlBQVksRUFBRTtnQkFDWixnQkFBZ0IsRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLFdBQVc7Z0JBQ3pELGFBQWEsRUFBRSxLQUFLLENBQUMsWUFBWTtvQkFDL0IsQ0FBQyxDQUFDO3dCQUNBLE1BQU0sRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLFVBQVU7d0JBQ3JDLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLFNBQVM7d0JBQ3hFLGFBQWEsRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLGFBQWEsRUFBRSxNQUFNO3dCQUN2RCxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxTQUFTO3FCQUMvQztvQkFDRCxDQUFDLENBQUMsU0FBUzthQUNkO1lBQ0QsSUFBSSxFQUFFLEtBQUssQ0FBQyxlQUFlO1NBQzVCLENBQUMsQ0FBQztRQUNILFFBQVEsQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsYUFBYSxFQUFFO1lBQy9DLE9BQU8sRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLE1BQU07U0FDbEMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsdUJBQXVCLENBQUMsUUFBUSxDQUFDLE9BQU8sRUFDakUsNkNBQXdCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7UUFDL0MsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsd0JBQXdCO1FBQ2xELHVDQUF1QztRQUN2Qyw0Q0FBNEM7UUFDNUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxRQUFRLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FDbEQsQ0FBQztRQUNGLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztLQUN4QztJQWxERDs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLGVBQXVCO1FBQ3JGLE1BQU0sTUFBTyxTQUFRLGVBQWU7WUFBcEM7O2dCQUNrQixvQkFBZSxHQUFHLGVBQWUsQ0FBQztnQkFDbEMsbUJBQWMsR0FBRyx5Q0FBb0IsQ0FBQyxLQUFLLEVBQUUsZUFBZSxDQUFDLENBQUM7Z0JBQzNELGlCQUFZLEdBQUcsU0FBUyxDQUFDO1lBQzlDLENBQUM7U0FBQTtRQUVELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0tBQzlCOztBQWZILGtDQXFEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tICcuLi8uLi9hd3MtaWFtJztcbmltcG9ydCAqIGFzIHMzIGZyb20gJy4uLy4uL2F3cy1zMyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnLi4vLi4vY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmblJlcG9ydEdyb3VwIH0gZnJvbSAnLi9jb2RlYnVpbGQuZ2VuZXJhdGVkJztcbmltcG9ydCB7IHJlbmRlclJlcG9ydEdyb3VwQXJuLCByZXBvcnRHcm91cEFybkNvbXBvbmVudHMgfSBmcm9tICcuL3JlcG9ydC1ncm91cC11dGlscyc7XG5cbi8qKlxuICogVGhlIGludGVyZmFjZSByZXByZXNlbnRpbmcgdGhlIFJlcG9ydEdyb3VwIHJlc291cmNlIC1cbiAqIGVpdGhlciBhbiBleGlzdGluZyBvbmUsIGltcG9ydGVkIHVzaW5nIHRoZVxuICoge0BsaW5rIFJlcG9ydEdyb3VwLmZyb21SZXBvcnRHcm91cE5hbWV9IG1ldGhvZCxcbiAqIG9yIGEgbmV3IG9uZSwgY3JlYXRlZCB3aXRoIHRoZSB7QGxpbmsgUmVwb3J0R3JvdXB9IGNsYXNzLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElSZXBvcnRHcm91cCBleHRlbmRzIGNkay5JUmVzb3VyY2Uge1xuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgUmVwb3J0R3JvdXAuXG4gICAqXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHJlcG9ydEdyb3VwQXJuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBSZXBvcnRHcm91cC5cbiAgICpcbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgcmVwb3J0R3JvdXBOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEdyYW50cyB0aGUgZ2l2ZW4gZW50aXR5IHBlcm1pc3Npb25zIHRvIHdyaXRlXG4gICAqICh0aGF0IGlzLCB1cGxvYWQgcmVwb3J0cyB0bylcbiAgICogdGhpcyByZXBvcnQgZ3JvdXAuXG4gICAqL1xuICBncmFudFdyaXRlKGlkZW50aXR5OiBpYW0uSUdyYW50YWJsZSk6IGlhbS5HcmFudDtcbn1cblxuYWJzdHJhY3QgY2xhc3MgUmVwb3J0R3JvdXBCYXNlIGV4dGVuZHMgY2RrLlJlc291cmNlIGltcGxlbWVudHMgSVJlcG9ydEdyb3VwIHtcbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IHJlcG9ydEdyb3VwQXJuOiBzdHJpbmc7XG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSByZXBvcnRHcm91cE5hbWU6IHN0cmluZztcbiAgcHJvdGVjdGVkIGFic3RyYWN0IHJlYWRvbmx5IGV4cG9ydEJ1Y2tldD86IHMzLklCdWNrZXQ7XG5cbiAgcHVibGljIGdyYW50V3JpdGUoaWRlbnRpdHk6IGlhbS5JR3JhbnRhYmxlKTogaWFtLkdyYW50IHtcbiAgICBjb25zdCByZXQgPSBpYW0uR3JhbnQuYWRkVG9QcmluY2lwYWwoe1xuICAgICAgZ3JhbnRlZTogaWRlbnRpdHksXG4gICAgICBhY3Rpb25zOiBbXG4gICAgICAgICdjb2RlYnVpbGQ6Q3JlYXRlUmVwb3J0JyxcbiAgICAgICAgJ2NvZGVidWlsZDpVcGRhdGVSZXBvcnQnLFxuICAgICAgICAnY29kZWJ1aWxkOkJhdGNoUHV0VGVzdENhc2VzJyxcbiAgICAgIF0sXG4gICAgICByZXNvdXJjZUFybnM6IFt0aGlzLnJlcG9ydEdyb3VwQXJuXSxcbiAgICB9KTtcblxuICAgIGlmICh0aGlzLmV4cG9ydEJ1Y2tldCkge1xuICAgICAgdGhpcy5leHBvcnRCdWNrZXQuZ3JhbnRXcml0ZShpZGVudGl0eSk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHJldDtcbiAgfVxufVxuXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciB7QGxpbmsgUmVwb3J0R3JvdXB9LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJlcG9ydEdyb3VwUHJvcHMge1xuICAvKipcbiAgICogVGhlIHBoeXNpY2FsIG5hbWUgb2YgdGhlIHJlcG9ydCBncm91cC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBDbG91ZEZvcm1hdGlvbi1nZW5lcmF0ZWQgbmFtZVxuICAgKi9cbiAgcmVhZG9ubHkgcmVwb3J0R3JvdXBOYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBbiBvcHRpb25hbCBTMyBidWNrZXQgdG8gZXhwb3J0IHRoZSByZXBvcnRzIHRvLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHRoZSByZXBvcnRzIHdpbGwgbm90IGJlIGV4cG9ydGVkXG4gICAqL1xuICByZWFkb25seSBleHBvcnRCdWNrZXQ/OiBzMy5JQnVja2V0O1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIG91dHB1dCB0aGUgcmVwb3J0IGZpbGVzIGludG8gdGhlIGV4cG9ydCBidWNrZXQgYXMtaXMsXG4gICAqIG9yIGNyZWF0ZSBhIFpJUCBmcm9tIHRoZW0gYmVmb3JlIGRvaW5nIHRoZSBleHBvcnQuXG4gICAqIElnbm9yZWQgaWYge0BsaW5rIGV4cG9ydEJ1Y2tldH0gaGFzIG5vdCBiZWVuIHByb3ZpZGVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGZhbHNlICh0aGUgZmlsZXMgd2lsbCBub3QgYmUgWklQcGVkKVxuICAgKi9cbiAgcmVhZG9ubHkgemlwRXhwb3J0PzogYm9vbGVhbjtcblxuICAvKipcbiAgICogV2hhdCB0byBkbyB3aGVuIHRoaXMgcmVzb3VyY2UgaXMgZGVsZXRlZCBmcm9tIGEgc3RhY2suXG4gICAqIEFzIENvZGVCdWlsZCBkb2VzIG5vdCBhbGxvdyBkZWxldGluZyBhIFJlc291cmNlR3JvdXAgdGhhdCBoYXMgcmVwb3J0cyBpbnNpZGUgb2YgaXQsXG4gICAqIHRoaXMgaXMgc2V0IHRvIHJldGFpbiB0aGUgcmVzb3VyY2UgYnkgZGVmYXVsdC5cbiAgICpcbiAgICogQGRlZmF1bHQgUmVtb3ZhbFBvbGljeS5SRVRBSU5cbiAgICovXG4gIHJlYWRvbmx5IHJlbW92YWxQb2xpY3k/OiBjZGsuUmVtb3ZhbFBvbGljeTtcbn1cblxuLyoqXG4gKiBUaGUgUmVwb3J0R3JvdXAgcmVzb3VyY2UgY2xhc3MuXG4gKi9cbmV4cG9ydCBjbGFzcyBSZXBvcnRHcm91cCBleHRlbmRzIFJlcG9ydEdyb3VwQmFzZSB7XG5cbiAgLyoqXG4gICAqIFJlZmVyZW5jZSBhbiBleGlzdGluZyBSZXBvcnRHcm91cCxcbiAgICogZGVmaW5lZCBvdXRzaWRlIG9mIHRoZSBDREsgY29kZSxcbiAgICogYnkgbmFtZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVJlcG9ydEdyb3VwTmFtZShzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCByZXBvcnRHcm91cE5hbWU6IHN0cmluZyk6IElSZXBvcnRHcm91cCB7XG4gICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgUmVwb3J0R3JvdXBCYXNlIHtcbiAgICAgIHB1YmxpYyByZWFkb25seSByZXBvcnRHcm91cE5hbWUgPSByZXBvcnRHcm91cE5hbWU7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgcmVwb3J0R3JvdXBBcm4gPSByZW5kZXJSZXBvcnRHcm91cEFybihzY29wZSwgcmVwb3J0R3JvdXBOYW1lKTtcbiAgICAgIHByb3RlY3RlZCByZWFkb25seSBleHBvcnRCdWNrZXQgPSB1bmRlZmluZWQ7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIHB1YmxpYyByZWFkb25seSByZXBvcnRHcm91cEFybjogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgcmVwb3J0R3JvdXBOYW1lOiBzdHJpbmc7XG4gIHByb3RlY3RlZCByZWFkb25seSBleHBvcnRCdWNrZXQ/OiBzMy5JQnVja2V0O1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSZXBvcnRHcm91cFByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHBoeXNpY2FsTmFtZTogcHJvcHMucmVwb3J0R3JvdXBOYW1lLFxuICAgIH0pO1xuXG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuUmVwb3J0R3JvdXAodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgdHlwZTogJ1RFU1QnLFxuICAgICAgZXhwb3J0Q29uZmlnOiB7XG4gICAgICAgIGV4cG9ydENvbmZpZ1R5cGU6IHByb3BzLmV4cG9ydEJ1Y2tldCA/ICdTMycgOiAnTk9fRVhQT1JUJyxcbiAgICAgICAgczNEZXN0aW5hdGlvbjogcHJvcHMuZXhwb3J0QnVja2V0XG4gICAgICAgICAgPyB7XG4gICAgICAgICAgICBidWNrZXQ6IHByb3BzLmV4cG9ydEJ1Y2tldC5idWNrZXROYW1lLFxuICAgICAgICAgICAgZW5jcnlwdGlvbkRpc2FibGVkOiBwcm9wcy5leHBvcnRCdWNrZXQuZW5jcnlwdGlvbktleSA/IGZhbHNlIDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgZW5jcnlwdGlvbktleTogcHJvcHMuZXhwb3J0QnVja2V0LmVuY3J5cHRpb25LZXk/LmtleUFybixcbiAgICAgICAgICAgIHBhY2thZ2luZzogcHJvcHMuemlwRXhwb3J0ID8gJ1pJUCcgOiB1bmRlZmluZWQsXG4gICAgICAgICAgfVxuICAgICAgICAgIDogdW5kZWZpbmVkLFxuICAgICAgfSxcbiAgICAgIG5hbWU6IHByb3BzLnJlcG9ydEdyb3VwTmFtZSxcbiAgICB9KTtcbiAgICByZXNvdXJjZS5hcHBseVJlbW92YWxQb2xpY3kocHJvcHMucmVtb3ZhbFBvbGljeSwge1xuICAgICAgZGVmYXVsdDogY2RrLlJlbW92YWxQb2xpY3kuUkVUQUlOLFxuICAgIH0pO1xuICAgIHRoaXMucmVwb3J0R3JvdXBBcm4gPSB0aGlzLmdldFJlc291cmNlQXJuQXR0cmlidXRlKHJlc291cmNlLmF0dHJBcm4sXG4gICAgICByZXBvcnRHcm91cEFybkNvbXBvbmVudHModGhpcy5waHlzaWNhbE5hbWUpKTtcbiAgICB0aGlzLnJlcG9ydEdyb3VwTmFtZSA9IHRoaXMuZ2V0UmVzb3VyY2VOYW1lQXR0cmlidXRlKFxuICAgICAgLy8gdGhlcmUgaXMgbm8gc2VwYXJhdGUgbmFtZSBhdHRyaWJ1dGUsXG4gICAgICAvLyBzbyB1c2UgRm46OlNlbGVjdCArIEZuOjpTcGxpdCB0byBtYWtlIG9uZVxuICAgICAgY2RrLkZuLnNlbGVjdCgxLCBjZGsuRm4uc3BsaXQoJy8nLCByZXNvdXJjZS5yZWYpKSxcbiAgICApO1xuICAgIHRoaXMuZXhwb3J0QnVja2V0ID0gcHJvcHMuZXhwb3J0QnVja2V0O1xuICB9XG59XG4iXX0=