"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2Action = exports.Ec2InstanceAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * Types of EC2 actions available
 */
var Ec2InstanceAction;
(function (Ec2InstanceAction) {
    /**
     * Stop the instance
     */
    Ec2InstanceAction["STOP"] = "stop";
    /**
     * Terminatethe instance
     */
    Ec2InstanceAction["TERMINATE"] = "terminate";
    /**
     * Recover the instance
     */
    Ec2InstanceAction["RECOVER"] = "recover";
    /**
     * Reboot the instance
     */
    Ec2InstanceAction["REBOOT"] = "reboot";
})(Ec2InstanceAction = exports.Ec2InstanceAction || (exports.Ec2InstanceAction = {}));
/**
 * Use an EC2 action as an Alarm action
 */
class Ec2Action {
    constructor(instanceAction) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_cloudwatch_actions_Ec2InstanceAction(instanceAction);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Ec2Action);
            }
            throw error;
        }
        this.ec2Action = instanceAction;
    }
    /**
     * Returns an alarm action configuration to use an EC2 action as an alarm action
     */
    bind(_scope, _alarm) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_cloudwatch_IAlarm(_alarm);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return { alarmActionArn: `arn:${core_1.Stack.of(_scope).partition}:automate:${core_1.Stack.of(_scope).region}:ec2:${this.ec2Action}` };
    }
}
exports.Ec2Action = Ec2Action;
_a = JSII_RTTI_SYMBOL_1;
Ec2Action[_a] = { fqn: "monocdk.aws_cloudwatch_actions.Ec2Action", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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