"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupResource = exports.TagOperation = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * An operation that is applied to a key-value pair
 */
var TagOperation;
(function (TagOperation) {
    /**
     * StringEquals
     */
    TagOperation["STRING_EQUALS"] = "STRINGEQUALS";
    /**
     * Dummy member
     */
    TagOperation["DUMMY"] = "dummy";
})(TagOperation = exports.TagOperation || (exports.TagOperation = {}));
/**
 * A resource to backup
 */
class BackupResource {
    constructor(resource, tagCondition, construct) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_backup_TagCondition(tagCondition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BackupResource);
            }
            throw error;
        }
        this.resource = resource;
        this.tagCondition = tagCondition;
        this.construct = construct;
    }
    /**
     * Adds all supported resources in a construct
     *
     * @param construct The construct containing resources to backup
     */
    static fromConstruct(construct) {
        return new BackupResource(undefined, undefined, construct);
    }
    /**
     * A DynamoDB table
     */
    static fromDynamoDbTable(table) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_dynamodb_ITable(table);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromDynamoDbTable);
            }
            throw error;
        }
        return BackupResource.fromArn(table.tableArn);
    }
    /**
     * An EC2 instance
     */
    static fromEc2Instance(instance) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_ec2_IInstance(instance);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEc2Instance);
            }
            throw error;
        }
        return BackupResource.fromArn(core_1.Stack.of(instance).formatArn({
            service: 'ec2',
            resource: 'instance',
            resourceName: instance.instanceId,
        }));
    }
    /**
     * An EFS file system
     */
    static fromEfsFileSystem(fileSystem) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_efs_IFileSystem(fileSystem);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEfsFileSystem);
            }
            throw error;
        }
        return BackupResource.fromArn(core_1.Stack.of(fileSystem).formatArn({
            service: 'elasticfilesystem',
            resource: 'file-system',
            resourceName: fileSystem.fileSystemId,
        }));
    }
    /**
     * A RDS database instance
     */
    static fromRdsDatabaseInstance(instance) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_rds_IDatabaseInstance(instance);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromRdsDatabaseInstance);
            }
            throw error;
        }
        return BackupResource.fromArn(instance.instanceArn);
    }
    /**
     * A list of ARNs or match patterns such as
     * `arn:aws:ec2:us-east-1:123456789012:volume/*`
     */
    static fromArn(arn) {
        return new BackupResource(arn);
    }
    /**
     * A tag condition
     */
    static fromTag(key, value, operation) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_backup_TagOperation(operation);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromTag);
            }
            throw error;
        }
        return new BackupResource(undefined, {
            key,
            value,
            operation,
        });
    }
}
exports.BackupResource = BackupResource;
_a = JSII_RTTI_SYMBOL_1;
BackupResource[_a] = { fqn: "monocdk.aws_backup.BackupResource", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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