"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PredefinedMetric = exports.TargetTrackingScalingPolicy = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const autoscaling_generated_1 = require("./autoscaling.generated");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../core");
class TargetTrackingScalingPolicy extends core_1.Construct {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_autoscaling_TargetTrackingScalingPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TargetTrackingScalingPolicy);
            }
            throw error;
        }
        if ((props.customMetric === undefined) === (props.predefinedMetric === undefined)) {
            throw new Error('Exactly one of \'customMetric\' or \'predefinedMetric\' must be specified.');
        }
        if (props.predefinedMetric === PredefinedMetric.ALB_REQUEST_COUNT_PER_TARGET && !props.resourceLabel) {
            throw new Error('When tracking the ALBRequestCountPerTarget metric, the ALB identifier must be supplied in resourceLabel');
        }
        if (props.customMetric && !props.customMetric.toMetricConfig().metricStat) {
            throw new Error('Only direct metrics are supported for Target Tracking. Use Step Scaling or supply a Metric object.');
        }
        super(scope, id);
        this.resource = new autoscaling_generated_1.CfnScalingPolicy(this, 'Resource', {
            policyType: 'TargetTrackingScaling',
            autoScalingGroupName: props.autoScalingGroup.autoScalingGroupName,
            cooldown: props.cooldown && props.cooldown.toSeconds().toString(),
            estimatedInstanceWarmup: props.estimatedInstanceWarmup && props.estimatedInstanceWarmup.toSeconds(),
            targetTrackingConfiguration: {
                customizedMetricSpecification: renderCustomMetric(props.customMetric),
                disableScaleIn: props.disableScaleIn,
                predefinedMetricSpecification: props.predefinedMetric !== undefined ? {
                    predefinedMetricType: props.predefinedMetric,
                    resourceLabel: props.resourceLabel,
                } : undefined,
                targetValue: props.targetValue,
            },
        });
        this.scalingPolicyArn = this.resource.ref;
    }
}
exports.TargetTrackingScalingPolicy = TargetTrackingScalingPolicy;
_a = JSII_RTTI_SYMBOL_1;
TargetTrackingScalingPolicy[_a] = { fqn: "monocdk.aws_autoscaling.TargetTrackingScalingPolicy", version: "1.185.0" };
function renderCustomMetric(metric) {
    if (!metric) {
        return undefined;
    }
    const c = metric.toMetricConfig().metricStat;
    return {
        dimensions: c.dimensions,
        metricName: c.metricName,
        namespace: c.namespace,
        statistic: c.statistic,
        unit: c.unitFilter,
    };
}
/**
 * One of the predefined autoscaling metrics
 */
var PredefinedMetric;
(function (PredefinedMetric) {
    /**
     * Average CPU utilization of the Auto Scaling group
     */
    PredefinedMetric["ASG_AVERAGE_CPU_UTILIZATION"] = "ASGAverageCPUUtilization";
    /**
     * Average number of bytes received on all network interfaces by the Auto Scaling group
     */
    PredefinedMetric["ASG_AVERAGE_NETWORK_IN"] = "ASGAverageNetworkIn";
    /**
     * Average number of bytes sent out on all network interfaces by the Auto Scaling group
     */
    PredefinedMetric["ASG_AVERAGE_NETWORK_OUT"] = "ASGAverageNetworkOut";
    /**
     * Number of requests completed per target in an Application Load Balancer target group
     *
     * Specify the ALB to look at in the `resourceLabel` field.
     */
    PredefinedMetric["ALB_REQUEST_COUNT_PER_TARGET"] = "ALBRequestCountPerTarget";
})(PredefinedMetric = exports.PredefinedMetric || (exports.PredefinedMetric = {}));
//# sourceMappingURL=data:application/json;base64,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