"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketStage = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("../../../aws-iam");
const core_1 = require("../../../core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const base_1 = require("../common/base");
/**
 * Represents a stage where an instance of the API is deployed.
 * @resource AWS::ApiGatewayV2::Stage
 */
class WebSocketStage extends base_1.StageBase {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName,
        });
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_WebSocketStageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketStage);
            }
            throw error;
        }
        this.baseApi = props.webSocketApi;
        this.api = props.webSocketApi;
        this.stageName = this.physicalName;
        new apigatewayv2_generated_1.CfnStage(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
            defaultRouteSettings: !props.throttle ? undefined : {
                throttlingBurstLimit: props.throttle?.burstLimit,
                throttlingRateLimit: props.throttle?.rateLimit,
            },
        });
        if (props.domainMapping) {
            this._addDomainMapping(props.domainMapping);
        }
    }
    /**
     * Import an existing stage into this CDK app.
     */
    static fromWebSocketStageAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_WebSocketStageAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromWebSocketStageAttributes);
            }
            throw error;
        }
        class Import extends base_1.StageBase {
            constructor() {
                super(...arguments);
                this.baseApi = attrs.api;
                this.stageName = attrs.stageName;
                this.api = attrs.api;
            }
            get url() {
                throw new Error('url is not available for imported stages.');
            }
            get callbackUrl() {
                throw new Error('callback url is not available for imported stages.');
            }
        }
        return new Import(scope, id);
    }
    /**
     * The websocket URL to this stage.
     */
    get url() {
        const s = core_1.Stack.of(this);
        const urlPath = this.stageName;
        return `wss://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * The callback URL to this stage.
     */
    get callbackUrl() {
        const s = core_1.Stack.of(this);
        const urlPath = this.stageName;
        return `https://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * Grant access to the API Gateway management API for this WebSocket API Stage to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     */
    grantManagementApiAccess(identity) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_iam_IGrantable(identity);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.grantManagementApiAccess);
            }
            throw error;
        }
        const arn = core_1.Stack.of(this.api).formatArn({
            service: 'execute-api',
            resource: this.api.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/${this.stageName}/*/@connections/*`],
        });
    }
}
exports.WebSocketStage = WebSocketStage;
_a = JSII_RTTI_SYMBOL_1;
WebSocketStage[_a] = { fqn: "monocdk.aws_apigatewayv2.WebSocketStage", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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