"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNlbIntegration = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("../../../aws-elasticloadbalancingv2");
const integration_1 = require("./private/integration");
/**
 * The Network Load Balancer integration resource for HTTP API
 */
class HttpNlbIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param listener the ELB network listener
     * @param props properties to configure the integration
     */
    constructor(id, listener, props = {}) {
        super(id);
        this.listener = listener;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_INetworkListener(listener);
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_integrations_HttpNlbIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpNlbIntegration);
            }
            throw error;
        }
    }
    bind(options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_HttpRouteIntegrationBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        let vpc = this.props.vpcLink?.vpc;
        if (!vpc && (this.listener instanceof elbv2.NetworkListener)) {
            vpc = this.listener.loadBalancer.vpc;
        }
        if (!vpc) {
            throw new Error('The vpcLink property must be specified when using an imported Network Listener.');
        }
        const vpcLink = this._configureVpcLink(options, {
            vpcLink: this.props.vpcLink,
            vpc,
        });
        return {
            method: this.props.method ?? this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: vpcLink.vpcLinkId,
            uri: this.listener.listenerArn,
            secureServerName: this.props.secureServerName,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpNlbIntegration = HttpNlbIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpNlbIntegration[_a] = { fqn: "monocdk.aws_apigatewayv2_integrations.HttpNlbIntegration", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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