"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketLambdaAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("../../../aws-apigatewayv2");
const aws_iam_1 = require("../../../aws-iam");
const core_1 = require("../../../core");
/**
 * Authorize WebSocket Api routes via a lambda function
 */
class WebSocketLambdaAuthorizer {
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(handler);
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_authorizers_WebSocketLambdaAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketLambdaAuthorizer);
            }
            throw error;
        }
    }
    bind(options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_apigatewayv2_WebSocketRouteAuthorizerBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.webSocketApi && (this.webSocketApi.apiId !== options.route.webSocketApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            this.webSocketApi = options.route.webSocketApi;
            this.authorizer = new aws_apigatewayv2_1.WebSocketAuthorizer(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                identitySource: this.props.identitySource ?? [
                    'route.request.header.Authorization',
                ],
                type: aws_apigatewayv2_1.WebSocketAuthorizerType.LAMBDA,
                authorizerName: this.props.authorizerName ?? this.id,
                authorizerUri: lambdaAuthorizerArn(this.handler),
            });
            this.handler.addPermission(`${core_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: core_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.webSocketApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.WebSocketLambdaAuthorizer = WebSocketLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
WebSocketLambdaAuthorizer[_a] = { fqn: "monocdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizer", version: "1.185.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${core_1.Stack.of(handler).partition}:apigateway:${core_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,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