"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorizer = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const method_1 = require("./method");
const AUTHORIZER_SYMBOL = Symbol.for('@aws-cdk/aws-apigateway.Authorizer');
/**
 * Base class for all custom authorizers
 */
class Authorizer extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.authorizationType = method_1.AuthorizationType.CUSTOM;
        try {
            jsiiDeprecationWarnings.monocdk_ResourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Authorizer);
            }
            throw error;
        }
        Object.defineProperty(this, AUTHORIZER_SYMBOL, { value: true });
    }
    /**
     * Return whether the given object is an Authorizer.
     */
    static isAuthorizer(x) {
        return x !== null && typeof (x) === 'object' && AUTHORIZER_SYMBOL in x;
    }
}
exports.Authorizer = Authorizer;
_a = JSII_RTTI_SYMBOL_1;
Authorizer[_a] = { fqn: "monocdk.aws_apigateway.Authorizer", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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