"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isComplete = exports.onEvent = void 0;
// aws-sdk available at runtime for lambdas
// eslint-disable-next-line import/no-extraneous-dependencies
const aws_sdk_1 = require("aws-sdk");
const handler_1 = require("./handler");
const AMPLIFY_ASSET_DEPLOYMENT_RESOURCE_TYPE = 'Custom::AmplifyAssetDeployment';
aws_sdk_1.config.logger = console;
const amplify = new aws_sdk_1.Amplify();
const s3 = new aws_sdk_1.S3({ signatureVersion: 'v4' });
async function onEvent(event) {
    const provider = createResourceHandler(event);
    return provider.onEvent();
}
exports.onEvent = onEvent;
async function isComplete(event) {
    const provider = createResourceHandler(event);
    return provider.isComplete();
}
exports.isComplete = isComplete;
function createResourceHandler(event) {
    switch (event.ResourceType) {
        case AMPLIFY_ASSET_DEPLOYMENT_RESOURCE_TYPE:
            return new handler_1.AmplifyAssetDeploymentHandler(amplify, s3, event);
        default:
            throw new Error(`Unsupported resource type "${event.ResourceType}"`);
    }
}
//# sourceMappingURL=data:application/json;base64,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