'''
# AWS::WAFv2 Construct Library

This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.

```python
import monocdk as wafv2
```

<!--BEGIN CFNONLY DISCLAIMER-->

There are no official hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet. Here are some suggestions on how to proceed:

* Search [Construct Hub for WAFv2 construct libraries](https://constructs.dev/search?q=wafv2)
* Use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, in the same way you would use [the CloudFormation AWS::WAFv2 resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_WAFv2.html) directly.

<!--BEGIN CFNONLY DISCLAIMER-->

There are no hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet.
However, you can still use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, and use this service exactly as you would using CloudFormation directly.

For more information on the resources and properties available for this service, see the [CloudFormation documentation for AWS::WAFv2](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_WAFv2.html).

(Read the [CDK Contributing Guide](https://github.com/aws/aws-cdk/blob/master/CONTRIBUTING.md) and submit an RFC if you are interested in contributing to this construct library.)

<!--END CFNONLY DISCLAIMER-->
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

from .. import (
    CfnResource as _CfnResource_e0a482dc,
    CfnTag as _CfnTag_95fbdc29,
    Construct as _Construct_e78e779f,
    IInspectable as _IInspectable_82c04a63,
    IResolvable as _IResolvable_a771d0ef,
    TagManager as _TagManager_0b7ab120,
    TreeInspector as _TreeInspector_1cd1894e,
)


@jsii.implements(_IInspectable_82c04a63)
class CfnIPSet(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_wafv2.CfnIPSet",
):
    '''A CloudFormation ``AWS::WAFv2::IPSet``.

    .. epigraph::

       This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019. For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``IPSet`` to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure AWS WAF to block them using an IP set that lists those IP addresses.

    You use an IP set by providing its Amazon Resource Name (ARN) to the rule statement ``IPSetReferenceStatement`` , when you add a rule to a rule group or web ACL.

    :cloudformationResource: AWS::WAFv2::IPSet
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_wafv2 as wafv2
        
        cfn_iPSet = wafv2.CfnIPSet(self, "MyCfnIPSet",
            addresses=["addresses"],
            ip_address_version="ipAddressVersion",
            scope="scope",
        
            # the properties below are optional
            description="description",
            name="name",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope_: _Construct_e78e779f,
        id: builtins.str,
        *,
        addresses: typing.Sequence[builtins.str],
        ip_address_version: builtins.str,
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::WAFv2::IPSet``.

        :param scope_: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param addresses: Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for ``/0`` . Example address strings: - To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify ``192.0.2.44/32`` . - To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify ``192.0.2.0/24`` . - To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify ``1111:0000:0000:0000:0000:0000:0000:0111/128`` . - To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify ``1111:0000:0000:0000:0000:0000:0000:0000/64`` . For more information about CIDR notation, see the Wikipedia entry `Classless Inter-Domain Routing <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`_ . Example JSON ``Addresses`` specifications: - Empty array: ``"Addresses": []`` - Array with one address: ``"Addresses": ["192.0.2.44/32"]`` - Array with three addresses: ``"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]`` - INVALID specification: ``"Addresses": [""]`` INVALID
        :param ip_address_version: The version of the IP addresses, either ``IPV4`` or ``IPV6`` .
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the IP set that helps with identification.
        :param name: The name of the IP set. You cannot change the name of an ``IPSet`` after you create it.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__044f5775047634593a05d50291f88c1d53f08203938795ca5d9dec2ea3c01398)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnIPSetProps(
            addresses=addresses,
            ip_address_version=ip_address_version,
            scope=scope,
            description=description,
            name=name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__147c3958cb8c530b6db9c90cff8bed69a4f3f800e3ccbd240e933ca26fbd3688)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d5357d280b89d5336cbfe67028c1f623ed25d0e84d6abd39036a786db74a205a)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the IP set.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the IP set.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="addresses")
    def addresses(self) -> typing.List[builtins.str]:
        '''Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses.

        All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for ``/0`` .

        Example address strings:

        - To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify ``192.0.2.44/32`` .
        - To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify ``192.0.2.0/24`` .
        - To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify ``1111:0000:0000:0000:0000:0000:0000:0111/128`` .
        - To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify ``1111:0000:0000:0000:0000:0000:0000:0000/64`` .

        For more information about CIDR notation, see the Wikipedia entry `Classless Inter-Domain Routing <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`_ .

        Example JSON ``Addresses`` specifications:

        - Empty array: ``"Addresses": []``
        - Array with one address: ``"Addresses": ["192.0.2.44/32"]``
        - Array with three addresses: ``"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]``
        - INVALID specification: ``"Addresses": [""]`` INVALID

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-addresses
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "addresses"))

    @addresses.setter
    def addresses(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d2a24721908da1ba664a987a64d471cf2dd8f53672547d8b0ac3857d617c43a1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "addresses", value)

    @builtins.property
    @jsii.member(jsii_name="ipAddressVersion")
    def ip_address_version(self) -> builtins.str:
        '''The version of the IP addresses, either ``IPV4`` or ``IPV6`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-ipaddressversion
        '''
        return typing.cast(builtins.str, jsii.get(self, "ipAddressVersion"))

    @ip_address_version.setter
    def ip_address_version(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b94df72dff609a1c68afddb3d5675e2048537f5b39b8f07b671585554ba43da3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "ipAddressVersion", value)

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-scope
        '''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e25c51ca07a576def244c4446b576716afdf43aff975c6e37a92dbe8e371fbae)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the IP set that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dfed9ceed6451b6a817bb4a98eee8d9737126eec06264c3991bb5549e65f6788)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the IP set.

        You cannot change the name of an ``IPSet`` after you create it.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-name
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7c916beefcbe317557d115e8d935cb98bfc26455dba3c1ebbff37d3505f120da)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)


@jsii.data_type(
    jsii_type="monocdk.aws_wafv2.CfnIPSetProps",
    jsii_struct_bases=[],
    name_mapping={
        "addresses": "addresses",
        "ip_address_version": "ipAddressVersion",
        "scope": "scope",
        "description": "description",
        "name": "name",
        "tags": "tags",
    },
)
class CfnIPSetProps:
    def __init__(
        self,
        *,
        addresses: typing.Sequence[builtins.str],
        ip_address_version: builtins.str,
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnIPSet``.

        :param addresses: Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for ``/0`` . Example address strings: - To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify ``192.0.2.44/32`` . - To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify ``192.0.2.0/24`` . - To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify ``1111:0000:0000:0000:0000:0000:0000:0111/128`` . - To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify ``1111:0000:0000:0000:0000:0000:0000:0000/64`` . For more information about CIDR notation, see the Wikipedia entry `Classless Inter-Domain Routing <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`_ . Example JSON ``Addresses`` specifications: - Empty array: ``"Addresses": []`` - Array with one address: ``"Addresses": ["192.0.2.44/32"]`` - Array with three addresses: ``"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]`` - INVALID specification: ``"Addresses": [""]`` INVALID
        :param ip_address_version: The version of the IP addresses, either ``IPV4`` or ``IPV6`` .
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the IP set that helps with identification.
        :param name: The name of the IP set. You cannot change the name of an ``IPSet`` after you create it.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_wafv2 as wafv2
            
            cfn_iPSet_props = wafv2.CfnIPSetProps(
                addresses=["addresses"],
                ip_address_version="ipAddressVersion",
                scope="scope",
            
                # the properties below are optional
                description="description",
                name="name",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__00e2a34e2af1ea098b941a84b39f46ddbc554431dacbde7b0f2009b48dd52704)
            check_type(argname="argument addresses", value=addresses, expected_type=type_hints["addresses"])
            check_type(argname="argument ip_address_version", value=ip_address_version, expected_type=type_hints["ip_address_version"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "addresses": addresses,
            "ip_address_version": ip_address_version,
            "scope": scope,
        }
        if description is not None:
            self._values["description"] = description
        if name is not None:
            self._values["name"] = name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def addresses(self) -> typing.List[builtins.str]:
        '''Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses.

        All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports all IPv4 and IPv6 CIDR ranges except for ``/0`` .

        Example address strings:

        - To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify ``192.0.2.44/32`` .
        - To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify ``192.0.2.0/24`` .
        - To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify ``1111:0000:0000:0000:0000:0000:0000:0111/128`` .
        - To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify ``1111:0000:0000:0000:0000:0000:0000:0000/64`` .

        For more information about CIDR notation, see the Wikipedia entry `Classless Inter-Domain Routing <https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing>`_ .

        Example JSON ``Addresses`` specifications:

        - Empty array: ``"Addresses": []``
        - Array with one address: ``"Addresses": ["192.0.2.44/32"]``
        - Array with three addresses: ``"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]``
        - INVALID specification: ``"Addresses": [""]`` INVALID

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-addresses
        '''
        result = self._values.get("addresses")
        assert result is not None, "Required property 'addresses' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def ip_address_version(self) -> builtins.str:
        '''The version of the IP addresses, either ``IPV4`` or ``IPV6`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-ipaddressversion
        '''
        result = self._values.get("ip_address_version")
        assert result is not None, "Required property 'ip_address_version' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the IP set that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the IP set.

        You cannot change the name of an ``IPSet`` after you create it.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnIPSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnLoggingConfiguration(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_wafv2.CfnLoggingConfiguration",
):
    '''A CloudFormation ``AWS::WAFv2::LoggingConfiguration``.

    Defines an association between logging destinations and a web ACL resource, for logging from AWS WAF . As part of the association, you can specify parts of the standard logging fields to keep out of the logs and you can specify filters so that you log only a subset of the logging records.
    .. epigraph::

       You can define one logging destination per web ACL.

    You can access information about the traffic that AWS WAF inspects using the following steps:

    - Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose.

    The name that you give the destination must start with ``aws-waf-logs-`` . Depending on the type of destination, you might need to configure additional settings or permissions.

    For configuration requirements and pricing information for each destination type, see `Logging web ACL traffic <https://docs.aws.amazon.com/waf/latest/developerguide/logging.html>`_ in the *AWS WAF Developer Guide* .

    - Associate your logging destination to your web ACL using a ``PutLoggingConfiguration`` request.

    When you successfully enable logging using a ``PutLoggingConfiguration`` request, AWS WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, AWS WAF creates a resource policy on the log group. For an Amazon S3 bucket, AWS WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, AWS WAF creates a service-linked role.

    For additional information about web ACL logging, see `Logging web ACL traffic information <https://docs.aws.amazon.com/waf/latest/developerguide/logging.html>`_ in the *AWS WAF Developer Guide* .

    :cloudformationResource: AWS::WAFv2::LoggingConfiguration
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_wafv2 as wafv2
        
        # json_body: Any
        # logging_filter: Any
        # method: Any
        # query_string: Any
        # single_header: Any
        # uri_path: Any
        
        cfn_logging_configuration = wafv2.CfnLoggingConfiguration(self, "MyCfnLoggingConfiguration",
            log_destination_configs=["logDestinationConfigs"],
            resource_arn="resourceArn",
        
            # the properties below are optional
            logging_filter=logging_filter,
            redacted_fields=[wafv2.CfnLoggingConfiguration.FieldToMatchProperty(
                json_body=json_body,
                method=method,
                query_string=query_string,
                single_header=single_header,
                uri_path=uri_path
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        log_destination_configs: typing.Sequence[builtins.str],
        resource_arn: builtins.str,
        logging_filter: typing.Any = None,
        redacted_fields: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnLoggingConfiguration.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
    ) -> None:
        '''Create a new ``AWS::WAFv2::LoggingConfiguration``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param log_destination_configs: The logging destination configuration that you want to associate with the web ACL. .. epigraph:: You can associate one logging destination to a web ACL.
        :param resource_arn: The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .
        :param logging_filter: Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
        :param redacted_fields: The parts of the request that you want to keep out of the logs. For example, if you redact the ``SingleHeader`` field, the ``HEADER`` field in the logs will be ``xxx`` . .. epigraph:: You can specify only the following fields for redaction: ``UriPath`` , ``QueryString`` , ``SingleHeader`` , ``Method`` , and ``JsonBody`` .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__95459104629101fa3900f3cee6f0e1cc7e7341f29bf49172e681d05c15c3f500)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnLoggingConfigurationProps(
            log_destination_configs=log_destination_configs,
            resource_arn=resource_arn,
            logging_filter=logging_filter,
            redacted_fields=redacted_fields,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__942cc1e7889b7cf7339fcb335f2bd7e5ccff26c0161327ceda7976d7f1a6966f)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7df5078e13eb5b7d48123feb65567582b2687a1b0eee387d2ab6cdfa318fb823)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrManagedByFirewallManager")
    def attr_managed_by_firewall_manager(self) -> _IResolvable_a771d0ef:
        '''Indicates whether the logging configuration was created by AWS Firewall Manager , as part of an AWS WAF policy configuration.

        If true, only Firewall Manager can modify or delete the configuration.

        :cloudformationAttribute: ManagedByFirewallManager
        '''
        return typing.cast(_IResolvable_a771d0ef, jsii.get(self, "attrManagedByFirewallManager"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="logDestinationConfigs")
    def log_destination_configs(self) -> typing.List[builtins.str]:
        '''The logging destination configuration that you want to associate with the web ACL.

        .. epigraph::

           You can associate one logging destination to a web ACL.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-logdestinationconfigs
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "logDestinationConfigs"))

    @log_destination_configs.setter
    def log_destination_configs(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e8efa63e46097909f86834f571cf16c640a30d869e38acf5910f53e647e335e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "logDestinationConfigs", value)

    @builtins.property
    @jsii.member(jsii_name="loggingFilter")
    def logging_filter(self) -> typing.Any:
        '''Filtering that specifies which web requests are kept in the logs and which are dropped.

        You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-loggingfilter
        '''
        return typing.cast(typing.Any, jsii.get(self, "loggingFilter"))

    @logging_filter.setter
    def logging_filter(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b413b947b0fef0e1342a29a2d56baf3d9f55a97c52b342fc0d51c247ce80fa29)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "loggingFilter", value)

    @builtins.property
    @jsii.member(jsii_name="resourceArn")
    def resource_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-resourcearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "resourceArn"))

    @resource_arn.setter
    def resource_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__124aa5fb77f63ee2da27c0bb76ef499aedcbb921c92f49669f55343d9b1b283c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "resourceArn", value)

    @builtins.property
    @jsii.member(jsii_name="redactedFields")
    def redacted_fields(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnLoggingConfiguration.FieldToMatchProperty", _IResolvable_a771d0ef]]]]:
        '''The parts of the request that you want to keep out of the logs.

        For example, if you redact the ``SingleHeader`` field, the ``HEADER`` field in the logs will be ``xxx`` .
        .. epigraph::

           You can specify only the following fields for redaction: ``UriPath`` , ``QueryString`` , ``SingleHeader`` , ``Method`` , and ``JsonBody`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-redactedfields
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnLoggingConfiguration.FieldToMatchProperty", _IResolvable_a771d0ef]]]], jsii.get(self, "redactedFields"))

    @redacted_fields.setter
    def redacted_fields(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnLoggingConfiguration.FieldToMatchProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__90bee1029951f029b274716e903c01f1c21aac3423953b6b13ba8c2a15e55bbb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "redactedFields", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnLoggingConfiguration.ActionConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"action": "action"},
    )
    class ActionConditionProperty:
        def __init__(self, *, action: builtins.str) -> None:
            '''A single action condition for a ``Condition`` in a logging filter.

            :param action: The action setting that a log record must contain in order to meet the condition. This is the action that AWS WAF applied to the web request. For rule groups, this is either the configured rule action setting, or if you've applied a rule action override to the rule, it's the override action. The value ``EXCLUDED_AS_COUNT`` matches on excluded rules and also on rules that have a rule action override of Count.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-actioncondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                action_condition_property = wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                    action="action"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__38a3577b86c846bba3e27fc876741ceaf0d48d444c5ef8dd551e8ef69d660240)
                check_type(argname="argument action", value=action, expected_type=type_hints["action"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "action": action,
            }

        @builtins.property
        def action(self) -> builtins.str:
            '''The action setting that a log record must contain in order to meet the condition.

            This is the action that AWS WAF applied to the web request.

            For rule groups, this is either the configured rule action setting, or if you've applied a rule action override to the rule, it's the override action. The value ``EXCLUDED_AS_COUNT`` matches on excluded rules and also on rules that have a rule action override of Count.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-actioncondition.html#cfn-wafv2-loggingconfiguration-actioncondition-action
            '''
            result = self._values.get("action")
            assert result is not None, "Required property 'action' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ActionConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnLoggingConfiguration.ConditionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "action_condition": "actionCondition",
            "label_name_condition": "labelNameCondition",
        },
    )
    class ConditionProperty:
        def __init__(
            self,
            *,
            action_condition: typing.Optional[typing.Union[typing.Union["CfnLoggingConfiguration.ActionConditionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            label_name_condition: typing.Optional[typing.Union[typing.Union["CfnLoggingConfiguration.LabelNameConditionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''A single match condition for a ``Filter`` .

            :param action_condition: A single action condition. This is the action setting that a log record must contain in order to meet the condition.
            :param label_name_condition: A single label name condition. This is the fully qualified label name that a log record must contain in order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                condition_property = wafv2.CfnLoggingConfiguration.ConditionProperty(
                    action_condition=wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                        action="action"
                    ),
                    label_name_condition=wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                        label_name="labelName"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2269cd7b8470292fafdfafd7edf94fe7466518b20d3b9c89d025d6e5174fca51)
                check_type(argname="argument action_condition", value=action_condition, expected_type=type_hints["action_condition"])
                check_type(argname="argument label_name_condition", value=label_name_condition, expected_type=type_hints["label_name_condition"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if action_condition is not None:
                self._values["action_condition"] = action_condition
            if label_name_condition is not None:
                self._values["label_name_condition"] = label_name_condition

        @builtins.property
        def action_condition(
            self,
        ) -> typing.Optional[typing.Union["CfnLoggingConfiguration.ActionConditionProperty", _IResolvable_a771d0ef]]:
            '''A single action condition.

            This is the action setting that a log record must contain in order to meet the condition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html#cfn-wafv2-loggingconfiguration-condition-actioncondition
            '''
            result = self._values.get("action_condition")
            return typing.cast(typing.Optional[typing.Union["CfnLoggingConfiguration.ActionConditionProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def label_name_condition(
            self,
        ) -> typing.Optional[typing.Union["CfnLoggingConfiguration.LabelNameConditionProperty", _IResolvable_a771d0ef]]:
            '''A single label name condition.

            This is the fully qualified label name that a log record must contain in order to meet the condition. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-condition.html#cfn-wafv2-loggingconfiguration-condition-labelnamecondition
            '''
            result = self._values.get("label_name_condition")
            return typing.cast(typing.Optional[typing.Union["CfnLoggingConfiguration.LabelNameConditionProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnLoggingConfiguration.FieldToMatchProperty",
        jsii_struct_bases=[],
        name_mapping={
            "json_body": "jsonBody",
            "method": "method",
            "query_string": "queryString",
            "single_header": "singleHeader",
            "uri_path": "uriPath",
        },
    )
    class FieldToMatchProperty:
        def __init__(
            self,
            *,
            json_body: typing.Any = None,
            method: typing.Any = None,
            query_string: typing.Any = None,
            single_header: typing.Any = None,
            uri_path: typing.Any = None,
        ) -> None:
            '''The parts of the request that you want to keep out of the logs.

            This is used in the logging configuration ``RedactedFields`` specification.

            Example JSON for a ``QueryString`` field to match:

            ``"FieldToMatch": { "QueryString": {} }``

            Example JSON for a ``Method`` field to match specification:

            ``"FieldToMatch": { "Method": { "Name": "DELETE" } }``

            :param json_body: Redact the request body JSON.
            :param method: Redact the indicated HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
            :param query_string: Redact the query string. This is the part of a URL that appears after a ``?`` character, if any.
            :param single_header: Redact a single header. Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive. Example JSON: ``"SingleHeader": { "Name": "haystack" }``
            :param uri_path: Redact the request URI path. This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # json_body: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # uri_path: Any
                
                field_to_match_property = wafv2.CfnLoggingConfiguration.FieldToMatchProperty(
                    json_body=json_body,
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    uri_path=uri_path
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d1b40c170dd6e9dd553c39ce744fc6a2b980e30e7aec1e4fbdae9f99ed964739)
                check_type(argname="argument json_body", value=json_body, expected_type=type_hints["json_body"])
                check_type(argname="argument method", value=method, expected_type=type_hints["method"])
                check_type(argname="argument query_string", value=query_string, expected_type=type_hints["query_string"])
                check_type(argname="argument single_header", value=single_header, expected_type=type_hints["single_header"])
                check_type(argname="argument uri_path", value=uri_path, expected_type=type_hints["uri_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if json_body is not None:
                self._values["json_body"] = json_body
            if method is not None:
                self._values["method"] = method
            if query_string is not None:
                self._values["query_string"] = query_string
            if single_header is not None:
                self._values["single_header"] = single_header
            if uri_path is not None:
                self._values["uri_path"] = uri_path

        @builtins.property
        def json_body(self) -> typing.Any:
            '''Redact the request body JSON.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-jsonbody
            '''
            result = self._values.get("json_body")
            return typing.cast(typing.Any, result)

        @builtins.property
        def method(self) -> typing.Any:
            '''Redact the indicated HTTP method.

            The method indicates the type of operation that the request is asking the origin to perform.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-method
            '''
            result = self._values.get("method")
            return typing.cast(typing.Any, result)

        @builtins.property
        def query_string(self) -> typing.Any:
            '''Redact the query string.

            This is the part of a URL that appears after a ``?`` character, if any.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-querystring
            '''
            result = self._values.get("query_string")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_header(self) -> typing.Any:
            '''Redact a single header.

            Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-singleheader
            '''
            result = self._values.get("single_header")
            return typing.cast(typing.Any, result)

        @builtins.property
        def uri_path(self) -> typing.Any:
            '''Redact the request URI path.

            This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-fieldtomatch.html#cfn-wafv2-loggingconfiguration-fieldtomatch-uripath
            '''
            result = self._values.get("uri_path")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldToMatchProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnLoggingConfiguration.FilterProperty",
        jsii_struct_bases=[],
        name_mapping={
            "behavior": "behavior",
            "conditions": "conditions",
            "requirement": "requirement",
        },
    )
    class FilterProperty:
        def __init__(
            self,
            *,
            behavior: builtins.str,
            conditions: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnLoggingConfiguration.ConditionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
            requirement: builtins.str,
        ) -> None:
            '''A single logging filter, used in ``LoggingFilter`` .

            :param behavior: How to handle logs that satisfy the filter's conditions and requirement.
            :param conditions: Match conditions for the filter.
            :param requirement: Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                filter_property = wafv2.CfnLoggingConfiguration.FilterProperty(
                    behavior="behavior",
                    conditions=[wafv2.CfnLoggingConfiguration.ConditionProperty(
                        action_condition=wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                            action="action"
                        ),
                        label_name_condition=wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                            label_name="labelName"
                        )
                    )],
                    requirement="requirement"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6608a3642b25c9442c609911d86ae4501b0b968a5f6eb73e8b0f9c786508d3f1)
                check_type(argname="argument behavior", value=behavior, expected_type=type_hints["behavior"])
                check_type(argname="argument conditions", value=conditions, expected_type=type_hints["conditions"])
                check_type(argname="argument requirement", value=requirement, expected_type=type_hints["requirement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "behavior": behavior,
                "conditions": conditions,
                "requirement": requirement,
            }

        @builtins.property
        def behavior(self) -> builtins.str:
            '''How to handle logs that satisfy the filter's conditions and requirement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-behavior
            '''
            result = self._values.get("behavior")
            assert result is not None, "Required property 'behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def conditions(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnLoggingConfiguration.ConditionProperty", _IResolvable_a771d0ef]]]:
            '''Match conditions for the filter.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-conditions
            '''
            result = self._values.get("conditions")
            assert result is not None, "Required property 'conditions' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnLoggingConfiguration.ConditionProperty", _IResolvable_a771d0ef]]], result)

        @builtins.property
        def requirement(self) -> builtins.str:
            '''Logic to apply to the filtering conditions.

            You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-filter.html#cfn-wafv2-loggingconfiguration-filter-requirement
            '''
            result = self._values.get("requirement")
            assert result is not None, "Required property 'requirement' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FilterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnLoggingConfiguration.JsonBodyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "invalid_fallback_behavior": "invalidFallbackBehavior",
        },
    )
    class JsonBodyProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[typing.Union["CfnLoggingConfiguration.MatchPatternProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            match_scope: builtins.str,
            invalid_fallback_behavior: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request as JSON. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule's inspection criteria. AWS WAF inspects only the parts of the JSON that result from the matches that you indicate.

            Example JSON: ``"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }``

            :param match_pattern: The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
            :param match_scope: The parts of the JSON to match against using the ``MatchPattern`` . If you specify ``All`` , AWS WAF matches against keys and values.
            :param invalid_fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:. - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters. AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array. AWS WAF parses the JSON in the following examples as two valid key, value pairs: - Missing comma: ``{"key1":"value1""key2":"value2"}`` - Missing colon: ``{"key1":"value1","key2""value2"}`` - Extra colons: ``{"key1"::"value1","key2""value2"}``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_body_property = wafv2.CfnLoggingConfiguration.JsonBodyProperty(
                    match_pattern=wafv2.CfnLoggingConfiguration.MatchPatternProperty(
                        all=all,
                        included_paths=["includedPaths"]
                    ),
                    match_scope="matchScope",
                
                    # the properties below are optional
                    invalid_fallback_behavior="invalidFallbackBehavior"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b40fb4d875b72ed4802378d4c952d069228843b1bc4db1c4de6370d8fd58a2cb)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument invalid_fallback_behavior", value=invalid_fallback_behavior, expected_type=type_hints["invalid_fallback_behavior"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
            }
            if invalid_fallback_behavior is not None:
                self._values["invalid_fallback_behavior"] = invalid_fallback_behavior

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union["CfnLoggingConfiguration.MatchPatternProperty", _IResolvable_a771d0ef]:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union["CfnLoggingConfiguration.MatchPatternProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the JSON to match against using the ``MatchPattern`` .

            If you specify ``All`` , AWS WAF matches against keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def invalid_fallback_behavior(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.

            - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.

            AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array.

            AWS WAF parses the JSON in the following examples as two valid key, value pairs:

            - Missing comma: ``{"key1":"value1""key2":"value2"}``
            - Missing colon: ``{"key1":"value1","key2""value2"}``
            - Extra colons: ``{"key1"::"value1","key2""value2"}``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-jsonbody.html#cfn-wafv2-loggingconfiguration-jsonbody-invalidfallbackbehavior
            '''
            result = self._values.get("invalid_fallback_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnLoggingConfiguration.LabelNameConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"label_name": "labelName"},
    )
    class LabelNameConditionProperty:
        def __init__(self, *, label_name: builtins.str) -> None:
            '''A single label name condition for a ``Condition`` in a logging filter.

            :param label_name: The label name that a log record must contain in order to meet the condition. This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-labelnamecondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                label_name_condition_property = wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                    label_name="labelName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ca64992e4570fa79b21b71fb114dba6e2bf9077accfaa52111bbfb2d17a84224)
                check_type(argname="argument label_name", value=label_name, expected_type=type_hints["label_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "label_name": label_name,
            }

        @builtins.property
        def label_name(self) -> builtins.str:
            '''The label name that a log record must contain in order to meet the condition.

            This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-labelnamecondition.html#cfn-wafv2-loggingconfiguration-labelnamecondition-labelname
            '''
            result = self._values.get("label_name")
            assert result is not None, "Required property 'label_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelNameConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnLoggingConfiguration.LoggingFilterProperty",
        jsii_struct_bases=[],
        name_mapping={"default_behavior": "defaultBehavior", "filters": "filters"},
    )
    class LoggingFilterProperty:
        def __init__(
            self,
            *,
            default_behavior: builtins.str,
            filters: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnLoggingConfiguration.FilterProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        ) -> None:
            '''Filtering that specifies which web requests are kept in the logs and which are dropped, defined for a web ACL's ``LoggingConfiguration`` .

            You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.

            :param default_behavior: Default handling for logs that don't match any of the specified filtering conditions.
            :param filters: The filters that you want to apply to the logs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                logging_filter_property = wafv2.CfnLoggingConfiguration.LoggingFilterProperty(
                    default_behavior="defaultBehavior",
                    filters=[wafv2.CfnLoggingConfiguration.FilterProperty(
                        behavior="behavior",
                        conditions=[wafv2.CfnLoggingConfiguration.ConditionProperty(
                            action_condition=wafv2.CfnLoggingConfiguration.ActionConditionProperty(
                                action="action"
                            ),
                            label_name_condition=wafv2.CfnLoggingConfiguration.LabelNameConditionProperty(
                                label_name="labelName"
                            )
                        )],
                        requirement="requirement"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6b51feeb0dc0c73d2e5ae50399e9f67b301fbf206579f348493e656f7d4ca856)
                check_type(argname="argument default_behavior", value=default_behavior, expected_type=type_hints["default_behavior"])
                check_type(argname="argument filters", value=filters, expected_type=type_hints["filters"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "default_behavior": default_behavior,
                "filters": filters,
            }

        @builtins.property
        def default_behavior(self) -> builtins.str:
            '''Default handling for logs that don't match any of the specified filtering conditions.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html#cfn-wafv2-loggingconfiguration-loggingfilter-defaultbehavior
            '''
            result = self._values.get("default_behavior")
            assert result is not None, "Required property 'default_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def filters(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnLoggingConfiguration.FilterProperty", _IResolvable_a771d0ef]]]:
            '''The filters that you want to apply to the logs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-loggingfilter.html#cfn-wafv2-loggingconfiguration-loggingfilter-filters
            '''
            result = self._values.get("filters")
            assert result is not None, "Required property 'filters' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnLoggingConfiguration.FilterProperty", _IResolvable_a771d0ef]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LoggingFilterProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnLoggingConfiguration.MatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={"all": "all", "included_paths": "includedPaths"},
    )
    class MatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            included_paths: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''
            :param all: ``CfnLoggingConfiguration.MatchPatternProperty.All``.
            :param included_paths: ``CfnLoggingConfiguration.MatchPatternProperty.IncludedPaths``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                match_pattern_property = wafv2.CfnLoggingConfiguration.MatchPatternProperty(
                    all=all,
                    included_paths=["includedPaths"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e4f1260907cb1ffb27778d732d3a173ae79895fe88e66dcc9bb69cd8e7eab95e)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument included_paths", value=included_paths, expected_type=type_hints["included_paths"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if included_paths is not None:
                self._values["included_paths"] = included_paths

        @builtins.property
        def all(self) -> typing.Any:
            '''``CfnLoggingConfiguration.MatchPatternProperty.All``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html#cfn-wafv2-loggingconfiguration-matchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def included_paths(self) -> typing.Optional[typing.List[builtins.str]]:
            '''``CfnLoggingConfiguration.MatchPatternProperty.IncludedPaths``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-matchpattern.html#cfn-wafv2-loggingconfiguration-matchpattern-includedpaths
            '''
            result = self._values.get("included_paths")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnLoggingConfiguration.SingleHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class SingleHeaderProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Inspect one of the headers in the web request, identified by name, for example, ``User-Agent`` or ``Referer`` .

            The name isn't case sensitive.

            You can filter and inspect all headers with the ``FieldToMatch`` setting ``Headers`` .

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            :param name: The name of the query header to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-singleheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                single_header_property = wafv2.CfnLoggingConfiguration.SingleHeaderProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e747244337fa3dfa8c04a1471c366551de9d69f18b355c16678e65b7bfab1dcf)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query header to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-loggingconfiguration-singleheader.html#cfn-wafv2-loggingconfiguration-singleheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SingleHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_wafv2.CfnLoggingConfigurationProps",
    jsii_struct_bases=[],
    name_mapping={
        "log_destination_configs": "logDestinationConfigs",
        "resource_arn": "resourceArn",
        "logging_filter": "loggingFilter",
        "redacted_fields": "redactedFields",
    },
)
class CfnLoggingConfigurationProps:
    def __init__(
        self,
        *,
        log_destination_configs: typing.Sequence[builtins.str],
        resource_arn: builtins.str,
        logging_filter: typing.Any = None,
        redacted_fields: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union[CfnLoggingConfiguration.FieldToMatchProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnLoggingConfiguration``.

        :param log_destination_configs: The logging destination configuration that you want to associate with the web ACL. .. epigraph:: You can associate one logging destination to a web ACL.
        :param resource_arn: The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .
        :param logging_filter: Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
        :param redacted_fields: The parts of the request that you want to keep out of the logs. For example, if you redact the ``SingleHeader`` field, the ``HEADER`` field in the logs will be ``xxx`` . .. epigraph:: You can specify only the following fields for redaction: ``UriPath`` , ``QueryString`` , ``SingleHeader`` , ``Method`` , and ``JsonBody`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_wafv2 as wafv2
            
            # json_body: Any
            # logging_filter: Any
            # method: Any
            # query_string: Any
            # single_header: Any
            # uri_path: Any
            
            cfn_logging_configuration_props = wafv2.CfnLoggingConfigurationProps(
                log_destination_configs=["logDestinationConfigs"],
                resource_arn="resourceArn",
            
                # the properties below are optional
                logging_filter=logging_filter,
                redacted_fields=[wafv2.CfnLoggingConfiguration.FieldToMatchProperty(
                    json_body=json_body,
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    uri_path=uri_path
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ba70c41a12ae0b738355ae0a36b8dff3bca24cf1ac84630196d0d2d6b3194eb)
            check_type(argname="argument log_destination_configs", value=log_destination_configs, expected_type=type_hints["log_destination_configs"])
            check_type(argname="argument resource_arn", value=resource_arn, expected_type=type_hints["resource_arn"])
            check_type(argname="argument logging_filter", value=logging_filter, expected_type=type_hints["logging_filter"])
            check_type(argname="argument redacted_fields", value=redacted_fields, expected_type=type_hints["redacted_fields"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "log_destination_configs": log_destination_configs,
            "resource_arn": resource_arn,
        }
        if logging_filter is not None:
            self._values["logging_filter"] = logging_filter
        if redacted_fields is not None:
            self._values["redacted_fields"] = redacted_fields

    @builtins.property
    def log_destination_configs(self) -> typing.List[builtins.str]:
        '''The logging destination configuration that you want to associate with the web ACL.

        .. epigraph::

           You can associate one logging destination to a web ACL.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-logdestinationconfigs
        '''
        result = self._values.get("log_destination_configs")
        assert result is not None, "Required property 'log_destination_configs' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def resource_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the web ACL that you want to associate with ``LogDestinationConfigs`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-resourcearn
        '''
        result = self._values.get("resource_arn")
        assert result is not None, "Required property 'resource_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def logging_filter(self) -> typing.Any:
        '''Filtering that specifies which web requests are kept in the logs and which are dropped.

        You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-loggingfilter
        '''
        result = self._values.get("logging_filter")
        return typing.cast(typing.Any, result)

    @builtins.property
    def redacted_fields(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnLoggingConfiguration.FieldToMatchProperty, _IResolvable_a771d0ef]]]]:
        '''The parts of the request that you want to keep out of the logs.

        For example, if you redact the ``SingleHeader`` field, the ``HEADER`` field in the logs will be ``xxx`` .
        .. epigraph::

           You can specify only the following fields for redaction: ``UriPath`` , ``QueryString`` , ``SingleHeader`` , ``Method`` , and ``JsonBody`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-loggingconfiguration.html#cfn-wafv2-loggingconfiguration-redactedfields
        '''
        result = self._values.get("redacted_fields")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnLoggingConfiguration.FieldToMatchProperty, _IResolvable_a771d0ef]]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnLoggingConfigurationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnRegexPatternSet(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_wafv2.CfnRegexPatternSet",
):
    '''A CloudFormation ``AWS::WAFv2::RegexPatternSet``.

    .. epigraph::

       This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019. For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``RegexPatternSet`` to have AWS WAF inspect a web request component for a specific set of regular expression patterns.

    You use a regex pattern set by providing its Amazon Resource Name (ARN) to the rule statement ``RegexPatternSetReferenceStatement`` , when you add a rule to a rule group or web ACL.

    :cloudformationResource: AWS::WAFv2::RegexPatternSet
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_wafv2 as wafv2
        
        cfn_regex_pattern_set = wafv2.CfnRegexPatternSet(self, "MyCfnRegexPatternSet",
            regular_expression_list=["regularExpressionList"],
            scope="scope",
        
            # the properties below are optional
            description="description",
            name="name",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope_: _Construct_e78e779f,
        id: builtins.str,
        *,
        regular_expression_list: typing.Sequence[builtins.str],
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::WAFv2::RegexPatternSet``.

        :param scope_: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param regular_expression_list: The regular expression patterns in the set.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the set that helps with identification.
        :param name: The name of the set. You cannot change the name after you create the set.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__931385a79f20dd179dc451b893417bc7a675c0a1a297edd57bc6cbda6c23c8e2)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnRegexPatternSetProps(
            regular_expression_list=regular_expression_list,
            scope=scope,
            description=description,
            name=name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__de2ae28d4c5408e97b8cd00c8515ce6b327260941b60d6be6d319dea82a1d564)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77213f04fbe90a97888ea1a9e0aab9a375f9cd3f198fbda6cdee0426c30e935f)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the regex pattern set.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the regex pattern set.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="regularExpressionList")
    def regular_expression_list(self) -> typing.List[builtins.str]:
        '''The regular expression patterns in the set.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-regularexpressionlist
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "regularExpressionList"))

    @regular_expression_list.setter
    def regular_expression_list(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__266753c0de44a1c11a9b113e10b0655a6050bf4396b7a75c1db13757249b68f7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "regularExpressionList", value)

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-scope
        '''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__56f329955feefe74e0999d8d93ab603768df1942e56127c8ed132106a28f9c50)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the set that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4dec9f7f01cf49bb425de184c22f3cd2d3caf1a0f44644e5539be2eb221c43a9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the set.

        You cannot change the name after you create the set.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-name
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fa120be3c3c5a79c91a6e0fe45d73557539d92d5dec0c307bf0136c3bf2b1af3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)


@jsii.data_type(
    jsii_type="monocdk.aws_wafv2.CfnRegexPatternSetProps",
    jsii_struct_bases=[],
    name_mapping={
        "regular_expression_list": "regularExpressionList",
        "scope": "scope",
        "description": "description",
        "name": "name",
        "tags": "tags",
    },
)
class CfnRegexPatternSetProps:
    def __init__(
        self,
        *,
        regular_expression_list: typing.Sequence[builtins.str],
        scope: builtins.str,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnRegexPatternSet``.

        :param regular_expression_list: The regular expression patterns in the set.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param description: A description of the set that helps with identification.
        :param name: The name of the set. You cannot change the name after you create the set.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_wafv2 as wafv2
            
            cfn_regex_pattern_set_props = wafv2.CfnRegexPatternSetProps(
                regular_expression_list=["regularExpressionList"],
                scope="scope",
            
                # the properties below are optional
                description="description",
                name="name",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a56896abb887824aa333a481a18c0102d4b496d37857813e95f6470c7f82a7bc)
            check_type(argname="argument regular_expression_list", value=regular_expression_list, expected_type=type_hints["regular_expression_list"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "regular_expression_list": regular_expression_list,
            "scope": scope,
        }
        if description is not None:
            self._values["description"] = description
        if name is not None:
            self._values["name"] = name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def regular_expression_list(self) -> typing.List[builtins.str]:
        '''The regular expression patterns in the set.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-regularexpressionlist
        '''
        result = self._values.get("regular_expression_list")
        assert result is not None, "Required property 'regular_expression_list' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the set that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the set.

        You cannot change the name after you create the set.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRegexPatternSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnRuleGroup(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_wafv2.CfnRuleGroup",
):
    '''A CloudFormation ``AWS::WAFv2::RuleGroup``.

    .. epigraph::

       This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019. For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``RuleGroup`` to define a collection of rules for inspecting and controlling web requests. You use a rule group in an ``WebACL`` by providing its Amazon Resource Name (ARN) to the rule statement ``RuleGroupReferenceStatement`` , when you add rules to the web ACL.

    When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.

    :cloudformationResource: AWS::WAFv2::RuleGroup
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_wafv2 as wafv2
        
        # all: Any
        # allow: Any
        # all_query_arguments: Any
        # block: Any
        # captcha: Any
        # count: Any
        # method: Any
        # query_string: Any
        # single_header: Any
        # single_query_argument: Any
        # statement_property_: wafv2.CfnRuleGroup.StatementProperty
        # uri_path: Any
        
        cfn_rule_group = wafv2.CfnRuleGroup(self, "MyCfnRuleGroup",
            capacity=123,
            scope="scope",
            visibility_config=wafv2.CfnRuleGroup.VisibilityConfigProperty(
                cloud_watch_metrics_enabled=False,
                metric_name="metricName",
                sampled_requests_enabled=False
            ),
        
            # the properties below are optional
            available_labels=[wafv2.CfnRuleGroup.LabelSummaryProperty(
                name="name"
            )],
            consumed_labels=[wafv2.CfnRuleGroup.LabelSummaryProperty(
                name="name"
            )],
            custom_response_bodies={
                "custom_response_bodies_key": wafv2.CfnRuleGroup.CustomResponseBodyProperty(
                    content="content",
                    content_type="contentType"
                )
            },
            description="description",
            name="name",
            rules=[wafv2.CfnRuleGroup.RuleProperty(
                name="name",
                priority=123,
                statement=wafv2.CfnRuleGroup.StatementProperty(
                    and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                        statements=[statement_property_]
                    ),
                    byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        positional_constraint="positionalConstraint",
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )],
        
                        # the properties below are optional
                        search_string="searchString",
                        search_string_base64="searchStringBase64"
                    ),
                    geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                        country_codes=["countryCodes"],
                        forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                            fallback_behavior="fallbackBehavior",
                            header_name="headerName"
                        )
                    ),
                    ip_set_reference_statement={
                        "arn": "arn",
        
                        # the properties below are optional
                        "ip_set_forwarded_ip_config": {
                            "fallback_behavior": "fallbackBehavior",
                            "header_name": "headerName",
                            "position": "position"
                        }
                    },
                    label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                        key="key",
                        scope="scope"
                    ),
                    not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                        statement=statement_property_
                    ),
                    or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                        statements=[statement_property_]
                    ),
                    rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                        aggregate_key_type="aggregateKeyType",
                        limit=123,
        
                        # the properties below are optional
                        forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                            fallback_behavior="fallbackBehavior",
                            header_name="headerName"
                        ),
                        scope_down_statement=statement_property_
                    ),
                    regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        regex_string="regexString",
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                        arn="arn",
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                        comparison_operator="comparisonOperator",
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        size=123,
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )],
        
                        # the properties below are optional
                        sensitivity_level="sensitivityLevel"
                    ),
                    xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    )
                ),
                visibility_config=wafv2.CfnRuleGroup.VisibilityConfigProperty(
                    cloud_watch_metrics_enabled=False,
                    metric_name="metricName",
                    sampled_requests_enabled=False
                ),
        
                # the properties below are optional
                action=wafv2.CfnRuleGroup.RuleActionProperty(
                    allow=allow,
                    block=block,
                    captcha=captcha,
                    challenge=wafv2.CfnRuleGroup.ChallengeProperty(
                        custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    count=count
                ),
                captcha_config=wafv2.CfnRuleGroup.CaptchaConfigProperty(
                    immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                ),
                challenge_config=wafv2.CfnRuleGroup.ChallengeConfigProperty(
                    immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                ),
                rule_labels=[wafv2.CfnRuleGroup.LabelProperty(
                    name="name"
                )]
            )],
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope_: _Construct_e78e779f,
        id: builtins.str,
        *,
        capacity: jsii.Number,
        scope: builtins.str,
        visibility_config: typing.Union[typing.Union["CfnRuleGroup.VisibilityConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        available_labels: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.LabelSummaryProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        consumed_labels: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.LabelSummaryProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        custom_response_bodies: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[typing.Union["CfnRuleGroup.CustomResponseBodyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.RuleProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::WAFv2::RuleGroup``.

        :param scope_: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param capacity: The web ACL capacity units (WCUs) required for this rule group. When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit. AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
        :param available_labels: ``AWS::WAFv2::RuleGroup.AvailableLabels``.
        :param consumed_labels: ``AWS::WAFv2::RuleGroup.ConsumedLabels``.
        :param custom_response_bodies: A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ . For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .
        :param description: A description of the rule group that helps with identification.
        :param name: The name of the rule group. You cannot change the name of a rule group after you create it.
        :param rules: The rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d068b7181c7f3678a831cc306871923ab427170170ce3123c41d27d5f7bc25e9)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnRuleGroupProps(
            capacity=capacity,
            scope=scope,
            visibility_config=visibility_config,
            available_labels=available_labels,
            consumed_labels=consumed_labels,
            custom_response_bodies=custom_response_bodies,
            description=description,
            name=name,
            rules=rules,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c6cdde74a354f0de3e27e6d4bddee0e6ec90b38e8ee1bdb935d78bca0e4d404f)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__88d8bd37d358995f9f360fff634bfb3d36e558502354be421e24f5ac261c5c80)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the rule group.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the rule group.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="attrLabelNamespace")
    def attr_label_namespace(self) -> builtins.str:
        '''The label namespace prefix for this rule group.

        All labels added by rules in this rule group have this prefix.

        The syntax for the label namespace prefix for a rule group is the following: ``awswaf:<account ID>:rule group:<rule group name>:``

        When a rule with a label matches a web request, AWS WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon.

        :cloudformationAttribute: LabelNamespace
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLabelNamespace"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="capacity")
    def capacity(self) -> jsii.Number:
        '''The web ACL capacity units (WCUs) required for this rule group.

        When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit.

        AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-capacity
        '''
        return typing.cast(jsii.Number, jsii.get(self, "capacity"))

    @capacity.setter
    def capacity(self, value: jsii.Number) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a4f522109fe95f25d3a434b86192092ca87176e18f274a208e27b3be59c44d23)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "capacity", value)

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-scope
        '''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ee821852b25192d80478a42797d0b3de9647fb19a8d80df0dfea2fe4ee62855)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value)

    @builtins.property
    @jsii.member(jsii_name="visibilityConfig")
    def visibility_config(
        self,
    ) -> typing.Union["CfnRuleGroup.VisibilityConfigProperty", _IResolvable_a771d0ef]:
        '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-visibilityconfig
        '''
        return typing.cast(typing.Union["CfnRuleGroup.VisibilityConfigProperty", _IResolvable_a771d0ef], jsii.get(self, "visibilityConfig"))

    @visibility_config.setter
    def visibility_config(
        self,
        value: typing.Union["CfnRuleGroup.VisibilityConfigProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8eb80a69af1e31cf70dcf19cc8969c119d3df32e158a8f058e4c67a8cca3b092)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "visibilityConfig", value)

    @builtins.property
    @jsii.member(jsii_name="availableLabels")
    def available_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.LabelSummaryProperty", _IResolvable_a771d0ef]]]]:
        '''``AWS::WAFv2::RuleGroup.AvailableLabels``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-availablelabels
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.LabelSummaryProperty", _IResolvable_a771d0ef]]]], jsii.get(self, "availableLabels"))

    @available_labels.setter
    def available_labels(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.LabelSummaryProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f637c6fa2fdb49d77b3a1cb860c9e00ce784632a0d3d417053875467cf601260)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "availableLabels", value)

    @builtins.property
    @jsii.member(jsii_name="consumedLabels")
    def consumed_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.LabelSummaryProperty", _IResolvable_a771d0ef]]]]:
        '''``AWS::WAFv2::RuleGroup.ConsumedLabels``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-consumedlabels
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.LabelSummaryProperty", _IResolvable_a771d0ef]]]], jsii.get(self, "consumedLabels"))

    @consumed_labels.setter
    def consumed_labels(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.LabelSummaryProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af595015ec2f441ca84dc0f78a096bb42ea5e08ba71a07b369ec26e79d5363c8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "consumedLabels", value)

    @builtins.property
    @jsii.member(jsii_name="customResponseBodies")
    def custom_response_bodies(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union["CfnRuleGroup.CustomResponseBodyProperty", _IResolvable_a771d0ef]]]]:
        '''A map of custom response keys and content bodies.

        When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.

        For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

        For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-customresponsebodies
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union["CfnRuleGroup.CustomResponseBodyProperty", _IResolvable_a771d0ef]]]], jsii.get(self, "customResponseBodies"))

    @custom_response_bodies.setter
    def custom_response_bodies(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union["CfnRuleGroup.CustomResponseBodyProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ba0d675861e2d24a0a6376e319c55fd5043ebe95b25640058886e8cfd024439)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "customResponseBodies", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the rule group that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8d53e08df60f5cf7b79384c36323f661060f1cc52b6c420ebb44e96b642ad9e5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the rule group.

        You cannot change the name of a rule group after you create it.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-name
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66a856a1c0d37877b64ebcab054c8b714ebbbc4b21a02b0b67c8ed33afe43c14)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.RuleProperty", _IResolvable_a771d0ef]]]]:
        '''The rule statements used to identify the web requests that you want to allow, block, or count.

        Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-rules
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.RuleProperty", _IResolvable_a771d0ef]]]], jsii.get(self, "rules"))

    @rules.setter
    def rules(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.RuleProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__238ac1860e43d9f46315fa2e46747af3c0b1462096f9925805de7ff0d00aab4e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "rules", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.AllowProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class AllowProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param custom_request_handling: ``CfnRuleGroup.AllowProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-allow.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                allow_property = wafv2.CfnRuleGroup.AllowProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__23f6d81b6b289c2159e6c7979f482538fcc97c2a06050012782cbf9029bd95e6)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", _IResolvable_a771d0ef]]:
            '''``CfnRuleGroup.AllowProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-allow.html#cfn-wafv2-rulegroup-allow-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AllowProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.AndStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statements": "statements"},
    )
    class AndStatementProperty:
        def __init__(
            self,
            *,
            statements: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        ) -> None:
            '''A logical rule statement used to combine other rule statements with AND logic.

            You provide more than one ``Statement`` within the ``AndStatement`` .

            :param statements: The statements to combine with AND logic. You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-andstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                and_statement_property = wafv2.CfnRuleGroup.AndStatementProperty(
                    statements=[wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b8612e8939dcb617b7c52bda81129b1727b167f11c9fe3ea251596a66b819978)
                check_type(argname="argument statements", value=statements, expected_type=type_hints["statements"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statements": statements,
            }

        @builtins.property
        def statements(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.StatementProperty", _IResolvable_a771d0ef]]]:
            '''The statements to combine with AND logic.

            You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-andstatement.html#cfn-wafv2-rulegroup-andstatement-statements
            '''
            result = self._values.get("statements")
            assert result is not None, "Required property 'statements' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.StatementProperty", _IResolvable_a771d0ef]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AndStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.BlockProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_response": "customResponse"},
    )
    class BlockProperty:
        def __init__(
            self,
            *,
            custom_response: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.CustomResponseProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param custom_response: ``CfnRuleGroup.BlockProperty.CustomResponse``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-block.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                block_property = wafv2.CfnRuleGroup.BlockProperty(
                    custom_response=wafv2.CfnRuleGroup.CustomResponseProperty(
                        response_code=123,
                
                        # the properties below are optional
                        custom_response_body_key="customResponseBodyKey",
                        response_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9456e754f16d0e9e3548181914a89b2302461125888243676a214fc4d4915e2e)
                check_type(argname="argument custom_response", value=custom_response, expected_type=type_hints["custom_response"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_response is not None:
                self._values["custom_response"] = custom_response

        @builtins.property
        def custom_response(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.CustomResponseProperty", _IResolvable_a771d0ef]]:
            '''``CfnRuleGroup.BlockProperty.CustomResponse``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-block.html#cfn-wafv2-rulegroup-block-customresponse
            '''
            result = self._values.get("custom_response")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.CustomResponseProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlockProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.BodyProperty",
        jsii_struct_bases=[],
        name_mapping={"oversize_handling": "oversizeHandling"},
    )
    class BodyProperty:
        def __init__(
            self,
            *,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the body normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB. Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-body.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                body_property = wafv2.CfnRuleGroup.BodyProperty(
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d58630858ce33123094083717af0f9f481d07f74ef86296590ec7d59f6400990)
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the body normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB.

            Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-body.html#cfn-wafv2-rulegroup-body-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.ByteMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "positional_constraint": "positionalConstraint",
            "text_transformations": "textTransformations",
            "search_string": "searchString",
            "search_string_base64": "searchStringBase64",
        },
    )
    class ByteMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            positional_constraint: builtins.str,
            text_transformations: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
            search_string: typing.Optional[builtins.str] = None,
            search_string_base64: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement that defines a string match search for AWS WAF to apply to web requests.

            The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param positional_constraint: The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` . Valid values include the following: *CONTAINS* The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter. *CONTAINS_WORD* The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true: - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` . - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` . *EXACTLY* The value of the specified part of the web request must exactly match the value of ``SearchString`` . *STARTS_WITH* The value of ``SearchString`` must appear at the beginning of the specified part of the web request. *ENDS_WITH* The value of ``SearchString`` must appear at the end of the specified part of the web request.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.
            :param search_string: A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 50 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive. Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you. For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` . You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .
            :param search_string_base64: String to search for in a web request component, base64-encoded. If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead. You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                byte_match_statement_property = wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    positional_constraint="positionalConstraint",
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )],
                
                    # the properties below are optional
                    search_string="searchString",
                    search_string_base64="searchStringBase64"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3aedc0f8e60a6e154588c0bef33aac62c3eba320e64176468bf080a6f81f7428)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument positional_constraint", value=positional_constraint, expected_type=type_hints["positional_constraint"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
                check_type(argname="argument search_string", value=search_string, expected_type=type_hints["search_string"])
                check_type(argname="argument search_string_base64", value=search_string_base64, expected_type=type_hints["search_string_base64"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "positional_constraint": positional_constraint,
                "text_transformations": text_transformations,
            }
            if search_string is not None:
                self._values["search_string"] = search_string
            if search_string_base64 is not None:
                self._values["search_string_base64"] = search_string_base64

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def positional_constraint(self) -> builtins.str:
            '''The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` .

            Valid values include the following:

            *CONTAINS*

            The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter.

            *CONTAINS_WORD*

            The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true:

            - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` .
            - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` .

            *EXACTLY*

            The value of the specified part of the web request must exactly match the value of ``SearchString`` .

            *STARTS_WITH*

            The value of ``SearchString`` must appear at the beginning of the specified part of the web request.

            *ENDS_WITH*

            The value of ``SearchString`` must appear at the end of the specified part of the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-positionalconstraint
            '''
            result = self._values.get("positional_constraint")
            assert result is not None, "Required property 'positional_constraint' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]], result)

        @builtins.property
        def search_string(self) -> typing.Optional[builtins.str]:
            '''A string value that you want AWS WAF to search for.

            AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 50 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.

            Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.

            For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` .

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-searchstring
            '''
            result = self._values.get("search_string")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def search_string_base64(self) -> typing.Optional[builtins.str]:
            '''String to search for in a web request component, base64-encoded.

            If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead.

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-searchstringbase64
            '''
            result = self._values.get("search_string_base64")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ByteMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.CaptchaConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class CaptchaConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations.

            This is available at the web ACL level and in each rule.

            :param immunity_time_property: Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captchaconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                captcha_config_property = wafv2.CfnRuleGroup.CaptchaConfigProperty(
                    immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a7f76b99edf47066a5b87f4a647481c7598f58f5a6b5ad39af95465861132a8e)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.ImmunityTimePropertyProperty", _IResolvable_a771d0ef]]:
            '''Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captchaconfig.html#cfn-wafv2-rulegroup-captchaconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.ImmunityTimePropertyProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.CaptchaProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CaptchaProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param custom_request_handling: ``CfnRuleGroup.CaptchaProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captcha.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                captcha_property = wafv2.CfnRuleGroup.CaptchaProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__25c09ecc922deec3954d57a79d96f3568a8ae2e969cc5ee03ce8188a1adf0c29)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", _IResolvable_a771d0ef]]:
            '''``CfnRuleGroup.CaptchaProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-captcha.html#cfn-wafv2-rulegroup-captcha-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.ChallengeConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class ChallengeConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``Challenge`` evaluations.

            This is available at the web ACL level and in each rule.

            :param immunity_time_property: Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challengeconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                challenge_config_property = wafv2.CfnRuleGroup.ChallengeConfigProperty(
                    immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__091a7850d0163f4b69b90cea135231ebf07c616bab5fa4f8cef0f0d778d896fa)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.ImmunityTimePropertyProperty", _IResolvable_a771d0ef]]:
            '''Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challengeconfig.html#cfn-wafv2-rulegroup-challengeconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.ImmunityTimePropertyProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.ChallengeProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class ChallengeProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param custom_request_handling: ``CfnRuleGroup.ChallengeProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challenge.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                challenge_property = wafv2.CfnRuleGroup.ChallengeProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__594a08d941264cfee048e609c92b338c8ed7e28a4cff73e7474a47b225bdafb6)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", _IResolvable_a771d0ef]]:
            '''``CfnRuleGroup.ChallengeProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-challenge.html#cfn-wafv2-rulegroup-challenge-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.CookieMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_cookies": "excludedCookies",
            "included_cookies": "includedCookies",
        },
    )
    class CookieMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": {"KeyToInclude1", "KeyToInclude2", "KeyToInclude3"} }``

            :param all: Inspect all cookies.
            :param excluded_cookies: Inspect only the cookies whose keys don't match any of the strings specified here.
            :param included_cookies: Inspect only the cookies that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookie_match_pattern_property = wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                    all=all,
                    excluded_cookies=["excludedCookies"],
                    included_cookies=["includedCookies"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1bf121358ff90332b2a012ad15b0e00e87cd70461adbdcaecdc33e44bb9a0433)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_cookies", value=excluded_cookies, expected_type=type_hints["excluded_cookies"])
                check_type(argname="argument included_cookies", value=included_cookies, expected_type=type_hints["included_cookies"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_cookies is not None:
                self._values["excluded_cookies"] = excluded_cookies
            if included_cookies is not None:
                self._values["included_cookies"] = included_cookies

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all cookies.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html#cfn-wafv2-rulegroup-cookiematchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies whose keys don't match any of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html#cfn-wafv2-rulegroup-cookiematchpattern-excludedcookies
            '''
            result = self._values.get("excluded_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookiematchpattern.html#cfn-wafv2-rulegroup-cookiematchpattern-includedcookies
            '''
            result = self._values.get("included_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookieMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.CookiesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class CookiesProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[typing.Union["CfnRuleGroup.CookieMatchPatternProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect the cookies in the web request.

            You can specify the parts of the cookies to inspect and you can narrow the set of cookies to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"Cookies": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` . Example JSON: ``"MatchPattern": { "IncludedCookies": {"KeyToInclude1", "KeyToInclude2", "KeyToInclude3"} }``
            :param match_scope: The parts of the cookies to inspect with the rule inspection criteria. If you specify ``All`` , AWS WAF inspects both keys and values.
            :param oversize_handling: What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the cookies normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookies_property = wafv2.CfnRuleGroup.CookiesProperty(
                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                        all=all,
                        excluded_cookies=["excludedCookies"],
                        included_cookies=["includedCookies"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6921ed200d20f88ba975f8a4c0168128745ef25b21e00bf5c26aa056f301eba2)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union["CfnRuleGroup.CookieMatchPatternProperty", _IResolvable_a771d0ef]:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": {"KeyToInclude1", "KeyToInclude2", "KeyToInclude3"} }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html#cfn-wafv2-rulegroup-cookies-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.CookieMatchPatternProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the cookies to inspect with the rule inspection criteria.

            If you specify ``All`` , AWS WAF inspects both keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html#cfn-wafv2-rulegroup-cookies-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the cookies normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-cookies.html#cfn-wafv2-rulegroup-cookies-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookiesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.CountProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CountProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param custom_request_handling: ``CfnRuleGroup.CountProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-count.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                count_property = wafv2.CfnRuleGroup.CountProperty(
                    custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d92c928a21b8e05a0966908732c3e427457990b5c674eca36397cb59b1d18128)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", _IResolvable_a771d0ef]]:
            '''``CfnRuleGroup.CountProperty.CustomRequestHandling``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-count.html#cfn-wafv2-rulegroup-count-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.CustomRequestHandlingProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CountProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.CustomHTTPHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "value": "value"},
    )
    class CustomHTTPHeaderProperty:
        def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
            '''A custom header for custom request and response handling.

            This is used in ``CustomResponse`` and ``CustomRequestHandling`` .

            :param name: The name of the custom header. For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .
            :param value: The value of the custom header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customhttpheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                custom_hTTPHeader_property = wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                    name="name",
                    value="value"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__70a719c52fe0eb15009cb30304a0e1e09b189de0dc782e79e329d882e988f14b)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "value": value,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the custom header.

            For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customhttpheader.html#cfn-wafv2-rulegroup-customhttpheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> builtins.str:
            '''The value of the custom header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customhttpheader.html#cfn-wafv2-rulegroup-customhttpheader-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomHTTPHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.CustomRequestHandlingProperty",
        jsii_struct_bases=[],
        name_mapping={"insert_headers": "insertHeaders"},
    )
    class CustomRequestHandlingProperty:
        def __init__(
            self,
            *,
            insert_headers: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        ) -> None:
            '''Custom request handling behavior that inserts custom headers into a web request.

            You can add custom request handling for AWS WAF to use when the rule action doesn't block the request. For example, ``CaptchaAction`` for requests with valid t okens, and ``AllowAction`` .

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param insert_headers: The HTTP headers to insert into the request. Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customrequesthandling.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                custom_request_handling_property = wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                    insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7e8b1b4a4db73053f79b7d9dd18287b9e453dfc41627a692adf1d84bdd2e4601)
                check_type(argname="argument insert_headers", value=insert_headers, expected_type=type_hints["insert_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "insert_headers": insert_headers,
            }

        @builtins.property
        def insert_headers(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.CustomHTTPHeaderProperty", _IResolvable_a771d0ef]]]:
            '''The HTTP headers to insert into the request. Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customrequesthandling.html#cfn-wafv2-rulegroup-customrequesthandling-insertheaders
            '''
            result = self._values.get("insert_headers")
            assert result is not None, "Required property 'insert_headers' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.CustomHTTPHeaderProperty", _IResolvable_a771d0ef]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomRequestHandlingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.CustomResponseBodyProperty",
        jsii_struct_bases=[],
        name_mapping={"content": "content", "content_type": "contentType"},
    )
    class CustomResponseBodyProperty:
        def __init__(
            self,
            *,
            content: builtins.str,
            content_type: builtins.str,
        ) -> None:
            '''The response body to use in a custom response to a web request.

            This is referenced by key from ``CustomResponse`` ``CustomResponseBodyKey`` .

            :param content: The payload of the custom response. You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .
            :param content_type: The type of content in the payload that you are defining in the ``Content`` string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponsebody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                custom_response_body_property = wafv2.CfnRuleGroup.CustomResponseBodyProperty(
                    content="content",
                    content_type="contentType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fa6fb2e7acaa3c48c43a9418f0e1473cd029f12b3782283645b4f7444cfd3f15)
                check_type(argname="argument content", value=content, expected_type=type_hints["content"])
                check_type(argname="argument content_type", value=content_type, expected_type=type_hints["content_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "content": content,
                "content_type": content_type,
            }

        @builtins.property
        def content(self) -> builtins.str:
            '''The payload of the custom response.

            You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponsebody.html#cfn-wafv2-rulegroup-customresponsebody-content
            '''
            result = self._values.get("content")
            assert result is not None, "Required property 'content' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def content_type(self) -> builtins.str:
            '''The type of content in the payload that you are defining in the ``Content`` string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponsebody.html#cfn-wafv2-rulegroup-customresponsebody-contenttype
            '''
            result = self._values.get("content_type")
            assert result is not None, "Required property 'content_type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.CustomResponseProperty",
        jsii_struct_bases=[],
        name_mapping={
            "response_code": "responseCode",
            "custom_response_body_key": "customResponseBodyKey",
            "response_headers": "responseHeaders",
        },
    )
    class CustomResponseProperty:
        def __init__(
            self,
            *,
            response_code: jsii.Number,
            custom_response_body_key: typing.Optional[builtins.str] = None,
            response_headers: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        ) -> None:
            '''A custom response to send to the client.

            You can define a custom response for rule actions and default web ACL actions that are set to ``BlockAction`` .

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param response_code: The HTTP status code to return to the client. For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .
            :param custom_response_body_key: References the response body that you want AWS WAF to return to the web request client. You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.
            :param response_headers: The HTTP headers to use in the response. Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                custom_response_property = wafv2.CfnRuleGroup.CustomResponseProperty(
                    response_code=123,
                
                    # the properties below are optional
                    custom_response_body_key="customResponseBodyKey",
                    response_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__408875fcabb680d3eff824bf873e5ed3e30e92101e461827c3b84024dfc0b23d)
                check_type(argname="argument response_code", value=response_code, expected_type=type_hints["response_code"])
                check_type(argname="argument custom_response_body_key", value=custom_response_body_key, expected_type=type_hints["custom_response_body_key"])
                check_type(argname="argument response_headers", value=response_headers, expected_type=type_hints["response_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "response_code": response_code,
            }
            if custom_response_body_key is not None:
                self._values["custom_response_body_key"] = custom_response_body_key
            if response_headers is not None:
                self._values["response_headers"] = response_headers

        @builtins.property
        def response_code(self) -> jsii.Number:
            '''The HTTP status code to return to the client.

            For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html#cfn-wafv2-rulegroup-customresponse-responsecode
            '''
            result = self._values.get("response_code")
            assert result is not None, "Required property 'response_code' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def custom_response_body_key(self) -> typing.Optional[builtins.str]:
            '''References the response body that you want AWS WAF to return to the web request client.

            You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html#cfn-wafv2-rulegroup-customresponse-customresponsebodykey
            '''
            result = self._values.get("custom_response_body_key")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def response_headers(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.CustomHTTPHeaderProperty", _IResolvable_a771d0ef]]]]:
            '''The HTTP headers to use in the response. Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-customresponse.html#cfn-wafv2-rulegroup-customresponse-responseheaders
            '''
            result = self._values.get("response_headers")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.CustomHTTPHeaderProperty", _IResolvable_a771d0ef]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.FieldToMatchProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all_query_arguments": "allQueryArguments",
            "body": "body",
            "cookies": "cookies",
            "headers": "headers",
            "json_body": "jsonBody",
            "method": "method",
            "query_string": "queryString",
            "single_header": "singleHeader",
            "single_query_argument": "singleQueryArgument",
            "uri_path": "uriPath",
        },
    )
    class FieldToMatchProperty:
        def __init__(
            self,
            *,
            all_query_arguments: typing.Any = None,
            body: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.BodyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            cookies: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.CookiesProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            headers: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.HeadersProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            json_body: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.JsonBodyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            method: typing.Any = None,
            query_string: typing.Any = None,
            single_header: typing.Any = None,
            single_query_argument: typing.Any = None,
            uri_path: typing.Any = None,
        ) -> None:
            '''The part of the web request that you want AWS WAF to inspect.

            Include the single ``FieldToMatch`` type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in ``FieldToMatch`` for each rule statement that requires it. To inspect more than one component of the web request, create a separate rule statement for each component.

            Example JSON for a ``QueryString`` field to match:

            ``"FieldToMatch": { "QueryString": {} }``

            Example JSON for a ``Method`` field to match specification:

            ``"FieldToMatch": { "Method": { "Name": "DELETE" } }``

            :param all_query_arguments: Inspect all query arguments.
            :param body: Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the ``Body`` object configuration.
            :param cookies: Inspect the request cookies. You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
            :param headers: Inspect the request headers. You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
            :param json_body: Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.
            :param method: Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
            :param query_string: Inspect the query string. This is the part of a URL that appears after a ``?`` character, if any.
            :param single_header: Inspect a single header. Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive. Example JSON: ``"SingleHeader": { "Name": "haystack" }`` Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.
            :param single_query_argument: Inspect a single query argument. Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive. Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``
            :param uri_path: Inspect the request URI path. This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                field_to_match_property = wafv2.CfnRuleGroup.FieldToMatchProperty(
                    all_query_arguments=all_query_arguments,
                    body=wafv2.CfnRuleGroup.BodyProperty(
                        oversize_handling="oversizeHandling"
                    ),
                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                            all=all,
                            excluded_cookies=["excludedCookies"],
                            included_cookies=["includedCookies"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                            all=all,
                            excluded_headers=["excludedHeaders"],
                            included_headers=["includedHeaders"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                            all=all,
                            included_paths=["includedPaths"]
                        ),
                        match_scope="matchScope",
                
                        # the properties below are optional
                        invalid_fallback_behavior="invalidFallbackBehavior",
                        oversize_handling="oversizeHandling"
                    ),
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    single_query_argument=single_query_argument,
                    uri_path=uri_path
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f7f61e315ff3a6f25d93db711a6c8df294109b17b3c3a65175c075ed287e432e)
                check_type(argname="argument all_query_arguments", value=all_query_arguments, expected_type=type_hints["all_query_arguments"])
                check_type(argname="argument body", value=body, expected_type=type_hints["body"])
                check_type(argname="argument cookies", value=cookies, expected_type=type_hints["cookies"])
                check_type(argname="argument headers", value=headers, expected_type=type_hints["headers"])
                check_type(argname="argument json_body", value=json_body, expected_type=type_hints["json_body"])
                check_type(argname="argument method", value=method, expected_type=type_hints["method"])
                check_type(argname="argument query_string", value=query_string, expected_type=type_hints["query_string"])
                check_type(argname="argument single_header", value=single_header, expected_type=type_hints["single_header"])
                check_type(argname="argument single_query_argument", value=single_query_argument, expected_type=type_hints["single_query_argument"])
                check_type(argname="argument uri_path", value=uri_path, expected_type=type_hints["uri_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all_query_arguments is not None:
                self._values["all_query_arguments"] = all_query_arguments
            if body is not None:
                self._values["body"] = body
            if cookies is not None:
                self._values["cookies"] = cookies
            if headers is not None:
                self._values["headers"] = headers
            if json_body is not None:
                self._values["json_body"] = json_body
            if method is not None:
                self._values["method"] = method
            if query_string is not None:
                self._values["query_string"] = query_string
            if single_header is not None:
                self._values["single_header"] = single_header
            if single_query_argument is not None:
                self._values["single_query_argument"] = single_query_argument
            if uri_path is not None:
                self._values["uri_path"] = uri_path

        @builtins.property
        def all_query_arguments(self) -> typing.Any:
            '''Inspect all query arguments.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-allqueryarguments
            '''
            result = self._values.get("all_query_arguments")
            return typing.cast(typing.Any, result)

        @builtins.property
        def body(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.BodyProperty", _IResolvable_a771d0ef]]:
            '''Inspect the request body as plain text.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the ``Body`` object configuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-body
            '''
            result = self._values.get("body")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.BodyProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def cookies(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.CookiesProperty", _IResolvable_a771d0ef]]:
            '''Inspect the request cookies.

            You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-cookies
            '''
            result = self._values.get("cookies")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.CookiesProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def headers(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.HeadersProperty", _IResolvable_a771d0ef]]:
            '''Inspect the request headers.

            You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-headers
            '''
            result = self._values.get("headers")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.HeadersProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def json_body(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.JsonBodyProperty", _IResolvable_a771d0ef]]:
            '''Inspect the request body as JSON.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-jsonbody
            '''
            result = self._values.get("json_body")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.JsonBodyProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def method(self) -> typing.Any:
            '''Inspect the HTTP method.

            The method indicates the type of operation that the request is asking the origin to perform.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-method
            '''
            result = self._values.get("method")
            return typing.cast(typing.Any, result)

        @builtins.property
        def query_string(self) -> typing.Any:
            '''Inspect the query string.

            This is the part of a URL that appears after a ``?`` character, if any.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-querystring
            '''
            result = self._values.get("query_string")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_header(self) -> typing.Any:
            '''Inspect a single header.

            Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-singleheader
            '''
            result = self._values.get("single_header")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_query_argument(self) -> typing.Any:
            '''Inspect a single query argument.

            Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive.

            Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-singlequeryargument
            '''
            result = self._values.get("single_query_argument")
            return typing.cast(typing.Any, result)

        @builtins.property
        def uri_path(self) -> typing.Any:
            '''Inspect the request URI path.

            This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-uripath
            '''
            result = self._values.get("uri_path")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldToMatchProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
        },
    )
    class ForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used for ``GeoMatchStatement`` and ``RateBasedStatement`` . For ``IPSetReferenceStatement`` , use ``IPSetForwardedIPConfig`` instead.

            AWS WAF only evaluates the first IP address found in the specified HTTP header.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-forwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                forwarded_iPConfiguration_property = wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                    fallback_behavior="fallbackBehavior",
                    header_name="headerName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__dcd28153f03af17d75a16ade19b400910f325c7f4e7e3ab2dec2ec128c1e0e68)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-forwardedipconfiguration.html#cfn-wafv2-rulegroup-forwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-forwardedipconfiguration.html#cfn-wafv2-rulegroup-forwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.GeoMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "country_codes": "countryCodes",
            "forwarded_ip_config": "forwardedIpConfig",
        },
    )
    class GeoMatchStatementProperty:
        def __init__(
            self,
            *,
            country_codes: typing.Optional[typing.Sequence[builtins.str]] = None,
            forwarded_ip_config: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.ForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''A rule statement that labels web requests by country and region and that matches against web requests based on country code.

            A geo match rule labels every request that it inspects regardless of whether it finds a match.

            - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array.
            - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.

            AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` .

            If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` .

            If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` .

            For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param country_codes: An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard. When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
            :param forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-geomatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                geo_match_statement_property = wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                    country_codes=["countryCodes"],
                    forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                        fallback_behavior="fallbackBehavior",
                        header_name="headerName"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1632245f6d9e06eb68be2aa730db48d28a669773dbdb58ace29e1e3463eab733)
                check_type(argname="argument country_codes", value=country_codes, expected_type=type_hints["country_codes"])
                check_type(argname="argument forwarded_ip_config", value=forwarded_ip_config, expected_type=type_hints["forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if country_codes is not None:
                self._values["country_codes"] = country_codes
            if forwarded_ip_config is not None:
                self._values["forwarded_ip_config"] = forwarded_ip_config

        @builtins.property
        def country_codes(self) -> typing.Optional[typing.List[builtins.str]]:
            '''An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard.

            When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-geomatchstatement.html#cfn-wafv2-rulegroup-geomatchstatement-countrycodes
            '''
            result = self._values.get("country_codes")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.ForwardedIPConfigurationProperty", _IResolvable_a771d0ef]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-geomatchstatement.html#cfn-wafv2-rulegroup-geomatchstatement-forwardedipconfig
            '''
            result = self._values.get("forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.ForwardedIPConfigurationProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "GeoMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.HeaderMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_headers": "excludedHeaders",
            "included_headers": "includedHeaders",
        },
    )
    class HeaderMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }``

            :param all: Inspect all headers.
            :param excluded_headers: Inspect only the headers whose keys don't match any of the strings specified here.
            :param included_headers: Inspect only the headers that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                header_match_pattern_property = wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                    all=all,
                    excluded_headers=["excludedHeaders"],
                    included_headers=["includedHeaders"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5caab3e02f82f92508523bec6d458e985a4fcc5128b3207e653dbe40277f90ba)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_headers", value=excluded_headers, expected_type=type_hints["excluded_headers"])
                check_type(argname="argument included_headers", value=included_headers, expected_type=type_hints["included_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_headers is not None:
                self._values["excluded_headers"] = excluded_headers
            if included_headers is not None:
                self._values["included_headers"] = included_headers

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all headers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html#cfn-wafv2-rulegroup-headermatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers whose keys don't match any of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html#cfn-wafv2-rulegroup-headermatchpattern-excludedheaders
            '''
            result = self._values.get("excluded_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headermatchpattern.html#cfn-wafv2-rulegroup-headermatchpattern-includedheaders
            '''
            result = self._values.get("included_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeaderMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.HeadersProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class HeadersProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[typing.Union["CfnRuleGroup.HeaderMatchPatternProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect all headers in the web request.

            You can specify the parts of the headers to inspect and you can narrow the set of headers to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            If you want to inspect just the value of a single header, use the ``SingleHeader`` ``FieldToMatch`` setting instead.

            Example JSON: ``"Headers": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of headers to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` . Example JSON: ``"MatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }``
            :param match_scope: The parts of the headers to match with the rule inspection criteria. If you specify ``All`` , AWS WAF inspects both keys and values.
            :param oversize_handling: What AWS WAF should do if the headers of the request are larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the headers normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                headers_property = wafv2.CfnRuleGroup.HeadersProperty(
                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                        all=all,
                        excluded_headers=["excludedHeaders"],
                        included_headers=["includedHeaders"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a615a11ce9327dfbd957842aebbb771cb16f8f2df04819cf6afd12a131b79936)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union["CfnRuleGroup.HeaderMatchPatternProperty", _IResolvable_a771d0ef]:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html#cfn-wafv2-rulegroup-headers-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.HeaderMatchPatternProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the headers to match with the rule inspection criteria.

            If you specify ``All`` , AWS WAF inspects both keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html#cfn-wafv2-rulegroup-headers-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the headers of the request are larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the headers normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-headers.html#cfn-wafv2-rulegroup-headers-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeadersProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.IPSetForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
            "position": "position",
        },
    )
    class IPSetForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
            position: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used only for ``IPSetReferenceStatement`` . For ``GeoMatchStatement`` and ``RateBasedStatement`` , use ``ForwardedIPConfig`` instead.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
            :param position: The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through. The options for this setting are the following: - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP. - LAST - Inspect the last IP address in the list of IP addresses in the header. - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                i_pSet_forwarded_iPConfiguration_property = {
                    "fallback_behavior": "fallbackBehavior",
                    "header_name": "headerName",
                    "position": "position"
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b18faa8e3c1291e244b9955c3ed551529331e1d12bb887275bb22b71a6326119)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
                check_type(argname="argument position", value=position, expected_type=type_hints["position"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
                "position": position,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html#cfn-wafv2-rulegroup-ipsetforwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html#cfn-wafv2-rulegroup-ipsetforwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def position(self) -> builtins.str:
            '''The position in the header to search for the IP address.

            The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through.

            The options for this setting are the following:

            - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.
            - LAST - Inspect the last IP address in the list of IP addresses in the header.
            - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetforwardedipconfiguration.html#cfn-wafv2-rulegroup-ipsetforwardedipconfiguration-position
            '''
            result = self._values.get("position")
            assert result is not None, "Required property 'position' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.IPSetReferenceStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arn": "arn",
            "ip_set_forwarded_ip_config": "ipSetForwardedIpConfig",
        },
    )
    class IPSetReferenceStatementProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            ip_set_forwarded_ip_config: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.IPSetForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''A rule statement used to detect web requests coming from particular IP addresses or address ranges.

            To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement.

            Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :param arn: The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.
            :param ip_set_forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetreferencestatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                i_pSet_reference_statement_property = {
                    "arn": "arn",
                
                    # the properties below are optional
                    "ip_set_forwarded_ip_config": {
                        "fallback_behavior": "fallbackBehavior",
                        "header_name": "headerName",
                        "position": "position"
                    }
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4a04435de60fe4336aedf05e78bc14373d589929f7594d1ef7133f13e0c5aabe)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument ip_set_forwarded_ip_config", value=ip_set_forwarded_ip_config, expected_type=type_hints["ip_set_forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
            }
            if ip_set_forwarded_ip_config is not None:
                self._values["ip_set_forwarded_ip_config"] = ip_set_forwarded_ip_config

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetreferencestatement.html#cfn-wafv2-rulegroup-ipsetreferencestatement-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def ip_set_forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.IPSetForwardedIPConfigurationProperty", _IResolvable_a771d0ef]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetreferencestatement.html#cfn-wafv2-rulegroup-ipsetreferencestatement-ipsetforwardedipconfig
            '''
            result = self._values.get("ip_set_forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.IPSetForwardedIPConfigurationProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetReferenceStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.ImmunityTimePropertyProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time": "immunityTime"},
    )
    class ImmunityTimePropertyProperty:
        def __init__(self, *, immunity_time: jsii.Number) -> None:
            '''Used for CAPTCHA and challenge token settings.

            Determines how long a ``CAPTCHA`` or challenge timestamp remains valid after AWS WAF updates it for a successful ``CAPTCHA`` or challenge response.

            :param immunity_time: The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF . The default setting is 300. For the Challenge action, the minimum setting is 300.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-immunitytimeproperty.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                immunity_time_property_property = wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                    immunity_time=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e915cf7235df7e51eb71703cf7b5a2aca8fb62c9e70f3d48f4c67b3b5e715433)
                check_type(argname="argument immunity_time", value=immunity_time, expected_type=type_hints["immunity_time"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "immunity_time": immunity_time,
            }

        @builtins.property
        def immunity_time(self) -> jsii.Number:
            '''The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF .

            The default setting is 300.

            For the Challenge action, the minimum setting is 300.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-immunitytimeproperty.html#cfn-wafv2-rulegroup-immunitytimeproperty-immunitytime
            '''
            result = self._values.get("immunity_time")
            assert result is not None, "Required property 'immunity_time' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ImmunityTimePropertyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.JsonBodyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "invalid_fallback_behavior": "invalidFallbackBehavior",
            "oversize_handling": "oversizeHandling",
        },
    )
    class JsonBodyProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[typing.Union["CfnRuleGroup.JsonMatchPatternProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            match_scope: builtins.str,
            invalid_fallback_behavior: typing.Optional[builtins.str] = None,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request as JSON. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule's inspection criteria. AWS WAF inspects only the parts of the JSON that result from the matches that you indicate.

            Example JSON: ``"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }``

            :param match_pattern: The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
            :param match_scope: The parts of the JSON to match against using the ``MatchPattern`` . If you specify ``All`` , AWS WAF matches against keys and values.
            :param invalid_fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:. - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters. AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array. AWS WAF parses the JSON in the following examples as two valid key, value pairs: - Missing comma: ``{"key1":"value1""key2":"value2"}`` - Missing colon: ``{"key1":"value1","key2""value2"}`` - Extra colons: ``{"key1"::"value1","key2""value2"}``
            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the body normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB. Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_body_property = wafv2.CfnRuleGroup.JsonBodyProperty(
                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                        all=all,
                        included_paths=["includedPaths"]
                    ),
                    match_scope="matchScope",
                
                    # the properties below are optional
                    invalid_fallback_behavior="invalidFallbackBehavior",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bc2a72ae6fde4edd81579bc365caae350e6f258493180bb3554d2f8a3b6b547c)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument invalid_fallback_behavior", value=invalid_fallback_behavior, expected_type=type_hints["invalid_fallback_behavior"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
            }
            if invalid_fallback_behavior is not None:
                self._values["invalid_fallback_behavior"] = invalid_fallback_behavior
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union["CfnRuleGroup.JsonMatchPatternProperty", _IResolvable_a771d0ef]:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.JsonMatchPatternProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the JSON to match against using the ``MatchPattern`` .

            If you specify ``All`` , AWS WAF matches against keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def invalid_fallback_behavior(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.

            - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.

            AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array.

            AWS WAF parses the JSON in the following examples as two valid key, value pairs:

            - Missing comma: ``{"key1":"value1""key2":"value2"}``
            - Missing colon: ``{"key1":"value1","key2""value2"}``
            - Extra colons: ``{"key1"::"value1","key2""value2"}``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-invalidfallbackbehavior
            '''
            result = self._values.get("invalid_fallback_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the body normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB.

            Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonbody.html#cfn-wafv2-rulegroup-jsonbody-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.JsonMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={"all": "all", "included_paths": "includedPaths"},
    )
    class JsonMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            included_paths: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria. This is used with the ``FieldToMatch`` option ``JsonBody`` .

            :param all: Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. You must specify either this setting or the ``IncludedPaths`` setting, but not both.
            :param included_paths: Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . You must specify either this setting or the ``All`` setting, but not both. .. epigraph:: Don't use this option to include all paths. Instead, use the ``All`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonmatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_match_pattern_property = wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                    all=all,
                    included_paths=["includedPaths"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__857c764b20a4a999ffa8eea3244ef8ec57c5e5b132efa42e82a36593ae5c2afd)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument included_paths", value=included_paths, expected_type=type_hints["included_paths"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if included_paths is not None:
                self._values["included_paths"] = included_paths

        @builtins.property
        def all(self) -> typing.Any:
            '''Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            You must specify either this setting or the ``IncludedPaths`` setting, but not both.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonmatchpattern.html#cfn-wafv2-rulegroup-jsonmatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def included_paths(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            You must specify either this setting or the ``All`` setting, but not both.
            .. epigraph::

               Don't use this option to include all paths. Instead, use the ``All`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-jsonmatchpattern.html#cfn-wafv2-rulegroup-jsonmatchpattern-includedpaths
            '''
            result = self._values.get("included_paths")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.LabelMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"key": "key", "scope": "scope"},
    )
    class LabelMatchStatementProperty:
        def __init__(self, *, key: builtins.str, scope: builtins.str) -> None:
            '''A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.

            The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.

            :param key: The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:. - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name. - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates. Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .
            :param scope: Specify whether you want to match using the label name or just the namespace.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                label_match_statement_property = wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                    key="key",
                    scope="scope"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5cec20bf7989b5e5051ad05156bd6949412556fc67946b625368348f23132918)
                check_type(argname="argument key", value=key, expected_type=type_hints["key"])
                check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "key": key,
                "scope": scope,
            }

        @builtins.property
        def key(self) -> builtins.str:
            '''The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:.

            - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
            - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.

            Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelmatchstatement.html#cfn-wafv2-rulegroup-labelmatchstatement-key
            '''
            result = self._values.get("key")
            assert result is not None, "Required property 'key' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def scope(self) -> builtins.str:
            '''Specify whether you want to match using the label name or just the namespace.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelmatchstatement.html#cfn-wafv2-rulegroup-labelmatchstatement-scope
            '''
            result = self._values.get("scope")
            assert result is not None, "Required property 'scope' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.LabelProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class LabelProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''A single label container.

            This is used as an element of a label array in ``RuleLabels`` inside a rule.

            :param name: The label string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-label.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                label_property = wafv2.CfnRuleGroup.LabelProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e065c32f252ed89bc5b4aea29155311cfd5345424e3a6519e6bce19f1d77c200)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The label string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-label.html#cfn-wafv2-rulegroup-label-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.LabelSummaryProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class LabelSummaryProperty:
        def __init__(self, *, name: typing.Optional[builtins.str] = None) -> None:
            '''List of labels used by one or more of the rules of a ``RuleGroup`` .

            This summary object is used for the following rule group lists:

            - ``AvailableLabels`` - Labels that rules add to matching requests. These labels are defined in the ``RuleLabels`` for a rule.
            - ``ConsumedLabels`` - Labels that rules match against. These labels are defined in a ``LabelMatchStatement`` specification, in the ``Statement`` definition of a rule.

            :param name: An individual label specification.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelsummary.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                label_summary_property = wafv2.CfnRuleGroup.LabelSummaryProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0a3a3d23163f2b0bd8d7f6c197bd8605db787520e026c023437509e8d9789f49)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if name is not None:
                self._values["name"] = name

        @builtins.property
        def name(self) -> typing.Optional[builtins.str]:
            '''An individual label specification.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-labelsummary.html#cfn-wafv2-rulegroup-labelsummary-name
            '''
            result = self._values.get("name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelSummaryProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.NotStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statement": "statement"},
    )
    class NotStatementProperty:
        def __init__(
            self,
            *,
            statement: typing.Union[typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        ) -> None:
            '''A logical rule statement used to negate the results of another rule statement.

            You provide one ``Statement`` within the ``NotStatement`` .

            :param statement: The statement to negate. You can use any statement that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-notstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                not_statement_property = wafv2.CfnRuleGroup.NotStatementProperty(
                    statement=wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ad2cbe8d4b8624497af66dfc9f5f12f4a8ff73d4e95be699fa0df26be81c524f)
                check_type(argname="argument statement", value=statement, expected_type=type_hints["statement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statement": statement,
            }

        @builtins.property
        def statement(
            self,
        ) -> typing.Union["CfnRuleGroup.StatementProperty", _IResolvable_a771d0ef]:
            '''The statement to negate.

            You can use any statement that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-notstatement.html#cfn-wafv2-rulegroup-notstatement-statement
            '''
            result = self._values.get("statement")
            assert result is not None, "Required property 'statement' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.StatementProperty", _IResolvable_a771d0ef], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NotStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.OrStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statements": "statements"},
    )
    class OrStatementProperty:
        def __init__(
            self,
            *,
            statements: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        ) -> None:
            '''A logical rule statement used to combine other rule statements with OR logic.

            You provide more than one ``Statement`` within the ``OrStatement`` .

            :param statements: The statements to combine with OR logic. You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-orstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                or_statement_property = wafv2.CfnRuleGroup.OrStatementProperty(
                    statements=[wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__473f8d6fc3290ea8242c07f337e5a818496d1c6c237800c8ddf347629bc7278b)
                check_type(argname="argument statements", value=statements, expected_type=type_hints["statements"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statements": statements,
            }

        @builtins.property
        def statements(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.StatementProperty", _IResolvable_a771d0ef]]]:
            '''The statements to combine with OR logic.

            You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-orstatement.html#cfn-wafv2-rulegroup-orstatement-statements
            '''
            result = self._values.get("statements")
            assert result is not None, "Required property 'statements' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.StatementProperty", _IResolvable_a771d0ef]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OrStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.RateBasedStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "aggregate_key_type": "aggregateKeyType",
            "limit": "limit",
            "forwarded_ip_config": "forwardedIpConfig",
            "scope_down_statement": "scopeDownStatement",
        },
    )
    class RateBasedStatementProperty:
        def __init__(
            self,
            *,
            aggregate_key_type: builtins.str,
            limit: jsii.Number,
            forwarded_ip_config: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.ForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            scope_down_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span.

            You can use this to put a temporary block on requests from an IP address that is sending excessive requests.

            AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .

            When the rule action triggers, AWS WAF blocks additional requests from the IP address until the request rate falls below the limit.

            You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:

            - An IP match statement with an IP set that specified the address 192.0.2.44.
            - A string match statement that searches in the User-Agent header for the string BadBot.

            In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet the criteria of both of the nested statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet the criteria of both of the nested statements are not counted towards the rate limit and are not affected by this rule.

            You cannot nest a ``RateBasedStatement`` inside another statement, for example inside a ``NotStatement`` or ``OrStatement`` . You can define a ``RateBasedStatement`` inside a web ACL and inside a rule group.

            :param aggregate_key_type: Setting that indicates how to aggregate the request counts. The options are the following:. - IP - Aggregate the request counts on the IP address from the web request origin. - FORWARDED_IP - Aggregate the request counts on the first IP address in an HTTP header. If you use this, configure the ``ForwardedIPConfig`` , to specify the header to use.
            :param limit: The limit on requests per 5-minute period for a single originating IP address. If the statement includes a ``ScopeDownStatement`` , this limit is applied only to the requests that match the statement.
            :param forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. This is required if ``AggregateKeyType`` is set to ``FORWARDED_IP`` .
            :param scope_down_statement: An optional nested statement that narrows the scope of the web requests that are evaluated by the rate-based statement. Requests are only tracked by the rate-based statement if they match the scope-down statement. You can use any nestable ``Statement`` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                rate_based_statement_property = wafv2.CfnRuleGroup.RateBasedStatementProperty(
                    aggregate_key_type="aggregateKeyType",
                    limit=123,
                
                    # the properties below are optional
                    forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                        fallback_behavior="fallbackBehavior",
                        header_name="headerName"
                    ),
                    scope_down_statement=wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__458f2ab4bace93cd4366b0d6cb0c690aa7b61862cf5295dee8d427022618ef1b)
                check_type(argname="argument aggregate_key_type", value=aggregate_key_type, expected_type=type_hints["aggregate_key_type"])
                check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
                check_type(argname="argument forwarded_ip_config", value=forwarded_ip_config, expected_type=type_hints["forwarded_ip_config"])
                check_type(argname="argument scope_down_statement", value=scope_down_statement, expected_type=type_hints["scope_down_statement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "aggregate_key_type": aggregate_key_type,
                "limit": limit,
            }
            if forwarded_ip_config is not None:
                self._values["forwarded_ip_config"] = forwarded_ip_config
            if scope_down_statement is not None:
                self._values["scope_down_statement"] = scope_down_statement

        @builtins.property
        def aggregate_key_type(self) -> builtins.str:
            '''Setting that indicates how to aggregate the request counts. The options are the following:.

            - IP - Aggregate the request counts on the IP address from the web request origin.
            - FORWARDED_IP - Aggregate the request counts on the first IP address in an HTTP header. If you use this, configure the ``ForwardedIPConfig`` , to specify the header to use.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-aggregatekeytype
            '''
            result = self._values.get("aggregate_key_type")
            assert result is not None, "Required property 'aggregate_key_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def limit(self) -> jsii.Number:
            '''The limit on requests per 5-minute period for a single originating IP address.

            If the statement includes a ``ScopeDownStatement`` , this limit is applied only to the requests that match the statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-limit
            '''
            result = self._values.get("limit")
            assert result is not None, "Required property 'limit' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.ForwardedIPConfigurationProperty", _IResolvable_a771d0ef]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This is required if ``AggregateKeyType`` is set to ``FORWARDED_IP`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-forwardedipconfig
            '''
            result = self._values.get("forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.ForwardedIPConfigurationProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def scope_down_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.StatementProperty", _IResolvable_a771d0ef]]:
            '''An optional nested statement that narrows the scope of the web requests that are evaluated by the rate-based statement.

            Requests are only tracked by the rate-based statement if they match the scope-down statement. You can use any nestable ``Statement`` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatement.html#cfn-wafv2-rulegroup-ratebasedstatement-scopedownstatement
            '''
            result = self._values.get("scope_down_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.StatementProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RateBasedStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.RegexMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "regex_string": "regexString",
            "text_transformations": "textTransformations",
        },
    )
    class RegexMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            regex_string: builtins.str,
            text_transformations: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        ) -> None:
            '''A rule statement used to search web request components for a match against a single regular expression.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param regex_string: The string representing the regular expression.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                regex_match_statement_property = wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    regex_string="regexString",
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__05c98456019c719402a251f3915c59929c24624aec91860d35c0271b4d7c10e7)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument regex_string", value=regex_string, expected_type=type_hints["regex_string"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "regex_string": regex_string,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html#cfn-wafv2-rulegroup-regexmatchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def regex_string(self) -> builtins.str:
            '''The string representing the regular expression.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html#cfn-wafv2-rulegroup-regexmatchstatement-regexstring
            '''
            result = self._values.get("regex_string")
            assert result is not None, "Required property 'regex_string' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexmatchstatement.html#cfn-wafv2-rulegroup-regexmatchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RegexMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arn": "arn",
            "field_to_match": "fieldToMatch",
            "text_transformations": "textTransformations",
        },
    )
    class RegexPatternSetReferenceStatementProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            field_to_match: typing.Union[typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            text_transformations: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        ) -> None:
            '''A rule statement used to search web request components for matches with regular expressions.

            To use this, create a ``RegexPatternSet`` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.

            Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :param arn: The Amazon Resource Name (ARN) of the ``RegexPatternSet`` that this statement references.
            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                regex_pattern_set_reference_statement_property = wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                    arn="arn",
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6fe5b2abd92fa43b3d32e5ad565b61dc53510b7a5a6f616d30f44c6bbfd8b47d)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
                "field_to_match": field_to_match,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the ``RegexPatternSet`` that this statement references.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RegexPatternSetReferenceStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.RuleActionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "allow": "allow",
            "block": "block",
            "captcha": "captcha",
            "challenge": "challenge",
            "count": "count",
        },
    )
    class RuleActionProperty:
        def __init__(
            self,
            *,
            allow: typing.Any = None,
            block: typing.Any = None,
            captcha: typing.Any = None,
            challenge: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.ChallengeProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            count: typing.Any = None,
        ) -> None:
            '''The action that AWS WAF should take on a web request when it matches a rule's statement.

            Settings at the web ACL level can override the rule action setting.

            :param allow: Instructs AWS WAF to allow the web request.
            :param block: Instructs AWS WAF to block the web request.
            :param captcha: Specifies that AWS WAF should run a ``CAPTCHA`` check against the request:. - If the request includes a valid, unexpired ``CAPTCHA`` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` . - If the request doesn't include a valid, unexpired ``CAPTCHA`` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination. AWS WAF generates a response that it sends back to the client, which includes the following: - The header ``x-amzn-waf-action`` with a value of ``captcha`` . - The HTTP status code ``405 Method Not Allowed`` . - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a ``CAPTCHA`` challenge. You can configure the expiration time in the ``CaptchaConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting. This action option is available for rules. It isn't available for web ACL default actions.
            :param challenge: Instructs AWS WAF to run a ``Challenge`` check against the web request.
            :param count: Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # allow: Any
                # block: Any
                # captcha: Any
                # count: Any
                
                rule_action_property = wafv2.CfnRuleGroup.RuleActionProperty(
                    allow=allow,
                    block=block,
                    captcha=captcha,
                    challenge=wafv2.CfnRuleGroup.ChallengeProperty(
                        custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    count=count
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9a8b912bf559c03e6859b5d94728a569e2fa26c81722d1f92a10ff76e28533a6)
                check_type(argname="argument allow", value=allow, expected_type=type_hints["allow"])
                check_type(argname="argument block", value=block, expected_type=type_hints["block"])
                check_type(argname="argument captcha", value=captcha, expected_type=type_hints["captcha"])
                check_type(argname="argument challenge", value=challenge, expected_type=type_hints["challenge"])
                check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if allow is not None:
                self._values["allow"] = allow
            if block is not None:
                self._values["block"] = block
            if captcha is not None:
                self._values["captcha"] = captcha
            if challenge is not None:
                self._values["challenge"] = challenge
            if count is not None:
                self._values["count"] = count

        @builtins.property
        def allow(self) -> typing.Any:
            '''Instructs AWS WAF to allow the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-allow
            '''
            result = self._values.get("allow")
            return typing.cast(typing.Any, result)

        @builtins.property
        def block(self) -> typing.Any:
            '''Instructs AWS WAF to block the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-block
            '''
            result = self._values.get("block")
            return typing.cast(typing.Any, result)

        @builtins.property
        def captcha(self) -> typing.Any:
            '''Specifies that AWS WAF should run a ``CAPTCHA`` check against the request:.

            - If the request includes a valid, unexpired ``CAPTCHA`` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` .
            - If the request doesn't include a valid, unexpired ``CAPTCHA`` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

            AWS WAF generates a response that it sends back to the client, which includes the following:

            - The header ``x-amzn-waf-action`` with a value of ``captcha`` .
            - The HTTP status code ``405 Method Not Allowed`` .
            - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a ``CAPTCHA`` challenge.

            You can configure the expiration time in the ``CaptchaConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

            This action option is available for rules. It isn't available for web ACL default actions.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-captcha
            '''
            result = self._values.get("captcha")
            return typing.cast(typing.Any, result)

        @builtins.property
        def challenge(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.ChallengeProperty", _IResolvable_a771d0ef]]:
            '''Instructs AWS WAF to run a ``Challenge`` check against the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-challenge
            '''
            result = self._values.get("challenge")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.ChallengeProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def count(self) -> typing.Any:
            '''Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-count
            '''
            result = self._values.get("count")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RuleActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.RuleProperty",
        jsii_struct_bases=[],
        name_mapping={
            "name": "name",
            "priority": "priority",
            "statement": "statement",
            "visibility_config": "visibilityConfig",
            "action": "action",
            "captcha_config": "captchaConfig",
            "challenge_config": "challengeConfig",
            "rule_labels": "ruleLabels",
        },
    )
    class RuleProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            priority: jsii.Number,
            statement: typing.Union[typing.Union["CfnRuleGroup.StatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            visibility_config: typing.Union[typing.Union["CfnRuleGroup.VisibilityConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            action: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.RuleActionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            captcha_config: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.CaptchaConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            challenge_config: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.ChallengeConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            rule_labels: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.LabelProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        ) -> None:
            '''A single rule, which you can use in a ``WebACL`` or ``RuleGroup`` to identify web requests that you want to allow, block, or count.

            Each rule includes one top-level ``Statement`` that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.

            :param name: The name of the rule. You can't change the name of a ``Rule`` after you create it.
            :param priority: If you define more than one ``Rule`` in a ``WebACL`` , AWS WAF evaluates each request against the ``Rules`` in order based on the value of ``Priority`` . AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
            :param statement: The AWS WAF processing statement for the rule, for example ``ByteMatchStatement`` or ``SizeConstraintStatement`` .
            :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
            :param action: The action that AWS WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting.
            :param captcha_config: Specifies how AWS WAF should handle ``CAPTCHA`` evaluations. If you don't specify this, AWS WAF uses the ``CAPTCHA`` configuration that's defined for the web ACL.
            :param challenge_config: Specifies how AWS WAF should handle ``Challenge`` evaluations. If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.
            :param rule_labels: Labels to apply to web requests that match the rule match statement. AWS WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace. Rules that run after this rule in the web ACL can match against these labels using a ``LabelMatchStatement`` . For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines: - Separate each component of the label with a colon. - Each namespace or name can have up to 128 characters. - You can specify up to 5 namespaces in a label. - Don't use the following reserved words in your label specification: ``aws`` , ``waf`` , ``managed`` , ``rulegroup`` , ``webacl`` , ``regexpatternset`` , or ``ipset`` . For example, ``myLabelName`` or ``nameSpace1:nameSpace2:myLabelName`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # allow: Any
                # all_query_arguments: Any
                # block: Any
                # captcha: Any
                # count: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                rule_property = wafv2.CfnRuleGroup.RuleProperty(
                    name="name",
                    priority=123,
                    statement=wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    ),
                    visibility_config=wafv2.CfnRuleGroup.VisibilityConfigProperty(
                        cloud_watch_metrics_enabled=False,
                        metric_name="metricName",
                        sampled_requests_enabled=False
                    ),
                
                    # the properties below are optional
                    action=wafv2.CfnRuleGroup.RuleActionProperty(
                        allow=allow,
                        block=block,
                        captcha=captcha,
                        challenge=wafv2.CfnRuleGroup.ChallengeProperty(
                            custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                                insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                                    name="name",
                                    value="value"
                                )]
                            )
                        ),
                        count=count
                    ),
                    captcha_config=wafv2.CfnRuleGroup.CaptchaConfigProperty(
                        immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                            immunity_time=123
                        )
                    ),
                    challenge_config=wafv2.CfnRuleGroup.ChallengeConfigProperty(
                        immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                            immunity_time=123
                        )
                    ),
                    rule_labels=[wafv2.CfnRuleGroup.LabelProperty(
                        name="name"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ef9ffc2528c954220edd5eff49ef44e5e4e22131c15dbc960d16d5f27d1e79f7)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument priority", value=priority, expected_type=type_hints["priority"])
                check_type(argname="argument statement", value=statement, expected_type=type_hints["statement"])
                check_type(argname="argument visibility_config", value=visibility_config, expected_type=type_hints["visibility_config"])
                check_type(argname="argument action", value=action, expected_type=type_hints["action"])
                check_type(argname="argument captcha_config", value=captcha_config, expected_type=type_hints["captcha_config"])
                check_type(argname="argument challenge_config", value=challenge_config, expected_type=type_hints["challenge_config"])
                check_type(argname="argument rule_labels", value=rule_labels, expected_type=type_hints["rule_labels"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "priority": priority,
                "statement": statement,
                "visibility_config": visibility_config,
            }
            if action is not None:
                self._values["action"] = action
            if captcha_config is not None:
                self._values["captcha_config"] = captcha_config
            if challenge_config is not None:
                self._values["challenge_config"] = challenge_config
            if rule_labels is not None:
                self._values["rule_labels"] = rule_labels

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the rule.

            You can't change the name of a ``Rule`` after you create it.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def priority(self) -> jsii.Number:
            '''If you define more than one ``Rule`` in a ``WebACL`` , AWS WAF evaluates each request against the ``Rules`` in order based on the value of ``Priority`` .

            AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-priority
            '''
            result = self._values.get("priority")
            assert result is not None, "Required property 'priority' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def statement(
            self,
        ) -> typing.Union["CfnRuleGroup.StatementProperty", _IResolvable_a771d0ef]:
            '''The AWS WAF processing statement for the rule, for example ``ByteMatchStatement`` or ``SizeConstraintStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-statement
            '''
            result = self._values.get("statement")
            assert result is not None, "Required property 'statement' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.StatementProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def visibility_config(
            self,
        ) -> typing.Union["CfnRuleGroup.VisibilityConfigProperty", _IResolvable_a771d0ef]:
            '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-visibilityconfig
            '''
            result = self._values.get("visibility_config")
            assert result is not None, "Required property 'visibility_config' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.VisibilityConfigProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def action(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.RuleActionProperty", _IResolvable_a771d0ef]]:
            '''The action that AWS WAF should take on a web request when it matches the rule statement.

            Settings at the web ACL level can override the rule action setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-action
            '''
            result = self._values.get("action")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.RuleActionProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def captcha_config(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.CaptchaConfigProperty", _IResolvable_a771d0ef]]:
            '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations.

            If you don't specify this, AWS WAF uses the ``CAPTCHA`` configuration that's defined for the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-captchaconfig
            '''
            result = self._values.get("captcha_config")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.CaptchaConfigProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def challenge_config(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.ChallengeConfigProperty", _IResolvable_a771d0ef]]:
            '''Specifies how AWS WAF should handle ``Challenge`` evaluations.

            If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-challengeconfig
            '''
            result = self._values.get("challenge_config")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.ChallengeConfigProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def rule_labels(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.LabelProperty", _IResolvable_a771d0ef]]]]:
            '''Labels to apply to web requests that match the rule match statement.

            AWS WAF applies fully qualified labels to matching web requests. A fully qualified label is the concatenation of a label namespace and a rule label. The rule's rule group or web ACL defines the label namespace.

            Rules that run after this rule in the web ACL can match against these labels using a ``LabelMatchStatement`` .

            For each label, provide a case-sensitive string containing optional namespaces and a label name, according to the following guidelines:

            - Separate each component of the label with a colon.
            - Each namespace or name can have up to 128 characters.
            - You can specify up to 5 namespaces in a label.
            - Don't use the following reserved words in your label specification: ``aws`` , ``waf`` , ``managed`` , ``rulegroup`` , ``webacl`` , ``regexpatternset`` , or ``ipset`` .

            For example, ``myLabelName`` or ``nameSpace1:nameSpace2:myLabelName`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-rulelabels
            '''
            result = self._values.get("rule_labels")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.LabelProperty", _IResolvable_a771d0ef]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RuleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.SingleHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class SingleHeaderProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Inspect one of the headers in the web request, identified by name, for example, ``User-Agent`` or ``Referer`` .

            The name isn't case sensitive.

            You can filter and inspect all headers with the ``FieldToMatch`` setting ``Headers`` .

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            :param name: The name of the query header to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singleheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                single_header_property = wafv2.CfnRuleGroup.SingleHeaderProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__71790aa2e12c8b533faba92b77b1ba24af7bb00f703b7898ae80729647eff6e9)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query header to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singleheader.html#cfn-wafv2-rulegroup-singleheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SingleHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.SingleQueryArgumentProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class SingleQueryArgumentProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Inspect one query argument in the web request, identified by name, for example *UserName* or *SalesRegion* .

            The name isn't case sensitive.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``

            :param name: The name of the query argument to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singlequeryargument.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                single_query_argument_property = wafv2.CfnRuleGroup.SingleQueryArgumentProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a066959cbcd07fd3b9ec1a5dc688b14b66a033d679eacb8e62829426d98dcfb3)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the query argument to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-singlequeryargument.html#cfn-wafv2-rulegroup-singlequeryargument-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SingleQueryArgumentProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.SizeConstraintStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "comparison_operator": "comparisonOperator",
            "field_to_match": "fieldToMatch",
            "size": "size",
            "text_transformations": "textTransformations",
        },
    )
    class SizeConstraintStatementProperty:
        def __init__(
            self,
            *,
            comparison_operator: builtins.str,
            field_to_match: typing.Union[typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            size: jsii.Number,
            text_transformations: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        ) -> None:
            '''A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<).

            For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.

            If you configure AWS WAF to inspect the request body, AWS WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you could use a size constraint statement to block requests that have a request body greater than 8192 bytes.

            If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI ``/logo.jpg`` is nine characters long.

            :param comparison_operator: The operator to use to compare the request part to the size setting.
            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param size: The size, in byte, to compare to the request part, after any transformations.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                size_constraint_statement_property = wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                    comparison_operator="comparisonOperator",
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    size=123,
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cfc65c8deb614a8a7a04053a06d5f78f08b10871398d3ac0f90792bbb49c114a)
                check_type(argname="argument comparison_operator", value=comparison_operator, expected_type=type_hints["comparison_operator"])
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument size", value=size, expected_type=type_hints["size"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "comparison_operator": comparison_operator,
                "field_to_match": field_to_match,
                "size": size,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def comparison_operator(self) -> builtins.str:
            '''The operator to use to compare the request part to the size setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-comparisonoperator
            '''
            result = self._values.get("comparison_operator")
            assert result is not None, "Required property 'comparison_operator' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def size(self) -> jsii.Number:
            '''The size, in byte, to compare to the request part, after any transformations.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-size
            '''
            result = self._values.get("size")
            assert result is not None, "Required property 'size' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SizeConstraintStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.SqliMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "text_transformations": "textTransformations",
            "sensitivity_level": "sensitivityLevel",
        },
    )
    class SqliMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            text_transformations: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
            sensitivity_level: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement that inspects for malicious SQL code.

            Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.
            :param sensitivity_level: The sensitivity that you want AWS WAF to use to inspect for SQL injection attacks. ``HIGH`` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see `Testing and tuning <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html>`_ in the *AWS WAF Developer Guide* . ``LOW`` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives. Default: ``LOW``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                sqli_match_statement_property = wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )],
                
                    # the properties below are optional
                    sensitivity_level="sensitivityLevel"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__21f2f0106693d4950aa22a33a08476518abadeab8fbbf3d40551e4bd8daf7b45)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
                check_type(argname="argument sensitivity_level", value=sensitivity_level, expected_type=type_hints["sensitivity_level"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "text_transformations": text_transformations,
            }
            if sensitivity_level is not None:
                self._values["sensitivity_level"] = sensitivity_level

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html#cfn-wafv2-rulegroup-sqlimatchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html#cfn-wafv2-rulegroup-sqlimatchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]], result)

        @builtins.property
        def sensitivity_level(self) -> typing.Optional[builtins.str]:
            '''The sensitivity that you want AWS WAF to use to inspect for SQL injection attacks.

            ``HIGH`` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see `Testing and tuning <https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html>`_ in the *AWS WAF Developer Guide* .

            ``LOW`` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives.

            Default: ``LOW``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html#cfn-wafv2-rulegroup-sqlimatchstatement-sensitivitylevel
            '''
            result = self._values.get("sensitivity_level")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SqliMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.StatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "and_statement": "andStatement",
            "byte_match_statement": "byteMatchStatement",
            "geo_match_statement": "geoMatchStatement",
            "ip_set_reference_statement": "ipSetReferenceStatement",
            "label_match_statement": "labelMatchStatement",
            "not_statement": "notStatement",
            "or_statement": "orStatement",
            "rate_based_statement": "rateBasedStatement",
            "regex_match_statement": "regexMatchStatement",
            "regex_pattern_set_reference_statement": "regexPatternSetReferenceStatement",
            "size_constraint_statement": "sizeConstraintStatement",
            "sqli_match_statement": "sqliMatchStatement",
            "xss_match_statement": "xssMatchStatement",
        },
    )
    class StatementProperty:
        def __init__(
            self,
            *,
            and_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.AndStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            byte_match_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.ByteMatchStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            geo_match_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.GeoMatchStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            ip_set_reference_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.IPSetReferenceStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            label_match_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.LabelMatchStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            not_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.NotStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            or_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.OrStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            rate_based_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.RateBasedStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            regex_match_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.RegexMatchStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            regex_pattern_set_reference_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.RegexPatternSetReferenceStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            size_constraint_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.SizeConstraintStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            sqli_match_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.SqliMatchStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            xss_match_statement: typing.Optional[typing.Union[typing.Union["CfnRuleGroup.XssMatchStatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''The processing guidance for a rule, used by AWS WAF to determine whether a web request matches the rule.

            :param and_statement: A logical rule statement used to combine other rule statements with AND logic. You provide more than one ``Statement`` within the ``AndStatement`` .
            :param byte_match_statement: A rule statement that defines a string match search for AWS WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
            :param geo_match_statement: A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match. - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array. - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed. AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` . If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` . If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` . For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .
            :param ip_set_reference_statement: A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement. Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
            :param label_match_statement: A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL. The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
            :param not_statement: A logical rule statement used to negate the results of another rule statement. You provide one ``Statement`` within the ``NotStatement`` .
            :param or_statement: A logical rule statement used to combine other rule statements with OR logic. You provide more than one ``Statement`` within the ``OrStatement`` .
            :param rate_based_statement: A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span. You can use this to put a temporary block on requests from an IP address that is sending excessive requests. AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF . When the rule action triggers, AWS WAF blocks additional requests from the IP address until the request rate falls below the limit. You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements: - An IP match statement with an IP set that specified the address 192.0.2.44. - A string match statement that searches in the User-Agent header for the string BadBot. In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet the criteria of both of the nested statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet the criteria of both of the nested statements are not counted towards the rate limit and are not affected by this rule. You cannot nest a ``RateBasedStatement`` inside another statement, for example inside a ``NotStatement`` or ``OrStatement`` . You can define a ``RateBasedStatement`` inside a web ACL and inside a rule group.
            :param regex_match_statement: A rule statement used to search web request components for a match against a single regular expression.
            :param regex_pattern_set_reference_statement: A rule statement used to search web request components for matches with regular expressions. To use this, create a ``RegexPatternSet`` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set. Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
            :param size_constraint_statement: A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes. If you configure AWS WAF to inspect the request body, AWS WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you could use a size constraint statement to block requests that have a request body greater than 8192 bytes. If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI ``/logo.jpg`` is nine characters long.
            :param sqli_match_statement: A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
            :param xss_match_statement: A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # and_statement_property_: wafv2.CfnRuleGroup.AndStatementProperty
                # method: Any
                # not_statement_property_: wafv2.CfnRuleGroup.NotStatementProperty
                # or_statement_property_: wafv2.CfnRuleGroup.OrStatementProperty
                # query_string: Any
                # rate_based_statement_property_: wafv2.CfnRuleGroup.RateBasedStatementProperty
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnRuleGroup.StatementProperty
                # uri_path: Any
                
                statement_property = wafv2.CfnRuleGroup.StatementProperty(
                    and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                        statements=[wafv2.CfnRuleGroup.StatementProperty(
                            and_statement=and_statement_property_,
                            byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                positional_constraint="positionalConstraint",
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )],
                
                                # the properties below are optional
                                search_string="searchString",
                                search_string_base64="searchStringBase64"
                            ),
                            geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                                country_codes=["countryCodes"],
                                forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                    fallback_behavior="fallbackBehavior",
                                    header_name="headerName"
                                )
                            ),
                            ip_set_reference_statement={
                                "arn": "arn",
                
                                # the properties below are optional
                                "ip_set_forwarded_ip_config": {
                                    "fallback_behavior": "fallbackBehavior",
                                    "header_name": "headerName",
                                    "position": "position"
                                }
                            },
                            label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                                key="key",
                                scope="scope"
                            ),
                            not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                                statement=statement_property_
                            ),
                            or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                                statements=[statement_property_]
                            ),
                            rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                                aggregate_key_type="aggregateKeyType",
                                limit=123,
                
                                # the properties below are optional
                                forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                    fallback_behavior="fallbackBehavior",
                                    header_name="headerName"
                                ),
                                scope_down_statement=statement_property_
                            ),
                            regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                regex_string="regexString",
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                                arn="arn",
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                                comparison_operator="comparisonOperator",
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                size=123,
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )],
                
                                # the properties below are optional
                                sensitivity_level="sensitivityLevel"
                            ),
                            xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            )
                        )]
                    ),
                    byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        positional_constraint="positionalConstraint",
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )],
                
                        # the properties below are optional
                        search_string="searchString",
                        search_string_base64="searchStringBase64"
                    ),
                    geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                        country_codes=["countryCodes"],
                        forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                            fallback_behavior="fallbackBehavior",
                            header_name="headerName"
                        )
                    ),
                    ip_set_reference_statement={
                        "arn": "arn",
                
                        # the properties below are optional
                        "ip_set_forwarded_ip_config": {
                            "fallback_behavior": "fallbackBehavior",
                            "header_name": "headerName",
                            "position": "position"
                        }
                    },
                    label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                        key="key",
                        scope="scope"
                    ),
                    not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                        statement=wafv2.CfnRuleGroup.StatementProperty(
                            and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                                statements=[statement_property_]
                            ),
                            byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                positional_constraint="positionalConstraint",
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )],
                
                                # the properties below are optional
                                search_string="searchString",
                                search_string_base64="searchStringBase64"
                            ),
                            geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                                country_codes=["countryCodes"],
                                forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                    fallback_behavior="fallbackBehavior",
                                    header_name="headerName"
                                )
                            ),
                            ip_set_reference_statement={
                                "arn": "arn",
                
                                # the properties below are optional
                                "ip_set_forwarded_ip_config": {
                                    "fallback_behavior": "fallbackBehavior",
                                    "header_name": "headerName",
                                    "position": "position"
                                }
                            },
                            label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                                key="key",
                                scope="scope"
                            ),
                            not_statement=not_statement_property_,
                            or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                                statements=[statement_property_]
                            ),
                            rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                                aggregate_key_type="aggregateKeyType",
                                limit=123,
                
                                # the properties below are optional
                                forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                    fallback_behavior="fallbackBehavior",
                                    header_name="headerName"
                                ),
                                scope_down_statement=statement_property_
                            ),
                            regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                regex_string="regexString",
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                                arn="arn",
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                                comparison_operator="comparisonOperator",
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                size=123,
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )],
                
                                # the properties below are optional
                                sensitivity_level="sensitivityLevel"
                            ),
                            xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            )
                        )
                    ),
                    or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                        statements=[wafv2.CfnRuleGroup.StatementProperty(
                            and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                                statements=[statement_property_]
                            ),
                            byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                positional_constraint="positionalConstraint",
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )],
                
                                # the properties below are optional
                                search_string="searchString",
                                search_string_base64="searchStringBase64"
                            ),
                            geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                                country_codes=["countryCodes"],
                                forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                    fallback_behavior="fallbackBehavior",
                                    header_name="headerName"
                                )
                            ),
                            ip_set_reference_statement={
                                "arn": "arn",
                
                                # the properties below are optional
                                "ip_set_forwarded_ip_config": {
                                    "fallback_behavior": "fallbackBehavior",
                                    "header_name": "headerName",
                                    "position": "position"
                                }
                            },
                            label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                                key="key",
                                scope="scope"
                            ),
                            not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                                statement=statement_property_
                            ),
                            or_statement=or_statement_property_,
                            rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                                aggregate_key_type="aggregateKeyType",
                                limit=123,
                
                                # the properties below are optional
                                forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                    fallback_behavior="fallbackBehavior",
                                    header_name="headerName"
                                ),
                                scope_down_statement=statement_property_
                            ),
                            regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                regex_string="regexString",
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                                arn="arn",
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                                comparison_operator="comparisonOperator",
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                size=123,
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )],
                
                                # the properties below are optional
                                sensitivity_level="sensitivityLevel"
                            ),
                            xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            )
                        )]
                    ),
                    rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                        aggregate_key_type="aggregateKeyType",
                        limit=123,
                
                        # the properties below are optional
                        forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                            fallback_behavior="fallbackBehavior",
                            header_name="headerName"
                        ),
                        scope_down_statement=wafv2.CfnRuleGroup.StatementProperty(
                            and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                                statements=[statement_property_]
                            ),
                            byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                positional_constraint="positionalConstraint",
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )],
                
                                # the properties below are optional
                                search_string="searchString",
                                search_string_base64="searchStringBase64"
                            ),
                            geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                                country_codes=["countryCodes"],
                                forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                    fallback_behavior="fallbackBehavior",
                                    header_name="headerName"
                                )
                            ),
                            ip_set_reference_statement={
                                "arn": "arn",
                
                                # the properties below are optional
                                "ip_set_forwarded_ip_config": {
                                    "fallback_behavior": "fallbackBehavior",
                                    "header_name": "headerName",
                                    "position": "position"
                                }
                            },
                            label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                                key="key",
                                scope="scope"
                            ),
                            not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                                statement=statement_property_
                            ),
                            or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                                statements=[statement_property_]
                            ),
                            rate_based_statement=rate_based_statement_property_,
                            regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                regex_string="regexString",
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                                arn="arn",
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                                comparison_operator="comparisonOperator",
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                size=123,
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            ),
                            sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )],
                
                                # the properties below are optional
                                sensitivity_level="sensitivityLevel"
                            ),
                            xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                                field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                    all_query_arguments=all_query_arguments,
                                    body=wafv2.CfnRuleGroup.BodyProperty(
                                        oversize_handling="oversizeHandling"
                                    ),
                                    cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                        match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                            all=all,
                                            excluded_cookies=["excludedCookies"],
                                            included_cookies=["includedCookies"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    headers=wafv2.CfnRuleGroup.HeadersProperty(
                                        match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                            all=all,
                                            excluded_headers=["excludedHeaders"],
                                            included_headers=["includedHeaders"]
                                        ),
                                        match_scope="matchScope",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                        match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                            all=all,
                                            included_paths=["includedPaths"]
                                        ),
                                        match_scope="matchScope",
                
                                        # the properties below are optional
                                        invalid_fallback_behavior="invalidFallbackBehavior",
                                        oversize_handling="oversizeHandling"
                                    ),
                                    method=method,
                                    query_string=query_string,
                                    single_header=single_header,
                                    single_query_argument=single_query_argument,
                                    uri_path=uri_path
                                ),
                                text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                    priority=123,
                                    type="type"
                                )]
                            )
                        )
                    ),
                    regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        regex_string="regexString",
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                        arn="arn",
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                        comparison_operator="comparisonOperator",
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        size=123,
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )],
                
                        # the properties below are optional
                        sensitivity_level="sensitivityLevel"
                    ),
                    xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                        field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnRuleGroup.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnRuleGroup.HeadersProperty(
                                match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
                
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__663d051ac71c415d4ac5e60f32eaf04bcdfe270a365d7da38a71803d66554ed9)
                check_type(argname="argument and_statement", value=and_statement, expected_type=type_hints["and_statement"])
                check_type(argname="argument byte_match_statement", value=byte_match_statement, expected_type=type_hints["byte_match_statement"])
                check_type(argname="argument geo_match_statement", value=geo_match_statement, expected_type=type_hints["geo_match_statement"])
                check_type(argname="argument ip_set_reference_statement", value=ip_set_reference_statement, expected_type=type_hints["ip_set_reference_statement"])
                check_type(argname="argument label_match_statement", value=label_match_statement, expected_type=type_hints["label_match_statement"])
                check_type(argname="argument not_statement", value=not_statement, expected_type=type_hints["not_statement"])
                check_type(argname="argument or_statement", value=or_statement, expected_type=type_hints["or_statement"])
                check_type(argname="argument rate_based_statement", value=rate_based_statement, expected_type=type_hints["rate_based_statement"])
                check_type(argname="argument regex_match_statement", value=regex_match_statement, expected_type=type_hints["regex_match_statement"])
                check_type(argname="argument regex_pattern_set_reference_statement", value=regex_pattern_set_reference_statement, expected_type=type_hints["regex_pattern_set_reference_statement"])
                check_type(argname="argument size_constraint_statement", value=size_constraint_statement, expected_type=type_hints["size_constraint_statement"])
                check_type(argname="argument sqli_match_statement", value=sqli_match_statement, expected_type=type_hints["sqli_match_statement"])
                check_type(argname="argument xss_match_statement", value=xss_match_statement, expected_type=type_hints["xss_match_statement"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if and_statement is not None:
                self._values["and_statement"] = and_statement
            if byte_match_statement is not None:
                self._values["byte_match_statement"] = byte_match_statement
            if geo_match_statement is not None:
                self._values["geo_match_statement"] = geo_match_statement
            if ip_set_reference_statement is not None:
                self._values["ip_set_reference_statement"] = ip_set_reference_statement
            if label_match_statement is not None:
                self._values["label_match_statement"] = label_match_statement
            if not_statement is not None:
                self._values["not_statement"] = not_statement
            if or_statement is not None:
                self._values["or_statement"] = or_statement
            if rate_based_statement is not None:
                self._values["rate_based_statement"] = rate_based_statement
            if regex_match_statement is not None:
                self._values["regex_match_statement"] = regex_match_statement
            if regex_pattern_set_reference_statement is not None:
                self._values["regex_pattern_set_reference_statement"] = regex_pattern_set_reference_statement
            if size_constraint_statement is not None:
                self._values["size_constraint_statement"] = size_constraint_statement
            if sqli_match_statement is not None:
                self._values["sqli_match_statement"] = sqli_match_statement
            if xss_match_statement is not None:
                self._values["xss_match_statement"] = xss_match_statement

        @builtins.property
        def and_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.AndStatementProperty", _IResolvable_a771d0ef]]:
            '''A logical rule statement used to combine other rule statements with AND logic.

            You provide more than one ``Statement`` within the ``AndStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-andstatement
            '''
            result = self._values.get("and_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.AndStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def byte_match_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.ByteMatchStatementProperty", _IResolvable_a771d0ef]]:
            '''A rule statement that defines a string match search for AWS WAF to apply to web requests.

            The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-bytematchstatement
            '''
            result = self._values.get("byte_match_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.ByteMatchStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def geo_match_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.GeoMatchStatementProperty", _IResolvable_a771d0ef]]:
            '''A rule statement that labels web requests by country and region and that matches against web requests based on country code.

            A geo match rule labels every request that it inspects regardless of whether it finds a match.

            - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array.
            - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.

            AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` .

            If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` .

            If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` .

            For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-geomatchstatement
            '''
            result = self._values.get("geo_match_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.GeoMatchStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def ip_set_reference_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.IPSetReferenceStatementProperty", _IResolvable_a771d0ef]]:
            '''A rule statement used to detect web requests coming from particular IP addresses or address ranges.

            To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement.

            Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-ipsetreferencestatement
            '''
            result = self._values.get("ip_set_reference_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.IPSetReferenceStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def label_match_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.LabelMatchStatementProperty", _IResolvable_a771d0ef]]:
            '''A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.

            The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-labelmatchstatement
            '''
            result = self._values.get("label_match_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.LabelMatchStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def not_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.NotStatementProperty", _IResolvable_a771d0ef]]:
            '''A logical rule statement used to negate the results of another rule statement.

            You provide one ``Statement`` within the ``NotStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-notstatement
            '''
            result = self._values.get("not_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.NotStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def or_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.OrStatementProperty", _IResolvable_a771d0ef]]:
            '''A logical rule statement used to combine other rule statements with OR logic.

            You provide more than one ``Statement`` within the ``OrStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-orstatement
            '''
            result = self._values.get("or_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.OrStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def rate_based_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.RateBasedStatementProperty", _IResolvable_a771d0ef]]:
            '''A rate-based rule tracks the rate of requests for each originating IP address, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any 5-minute time span.

            You can use this to put a temporary block on requests from an IP address that is sending excessive requests.

            AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .

            When the rule action triggers, AWS WAF blocks additional requests from the IP address until the request rate falls below the limit.

            You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts requests that match the nested statement. For example, based on recent requests that you have seen from an attacker, you might create a rate-based rule with a nested AND rule statement that contains the following nested statements:

            - An IP match statement with an IP set that specified the address 192.0.2.44.
            - A string match statement that searches in the User-Agent header for the string BadBot.

            In this rate-based rule, you also define a rate limit. For this example, the rate limit is 1,000. Requests that meet the criteria of both of the nested statements are counted. If the count exceeds 1,000 requests per five minutes, the rule action triggers. Requests that do not meet the criteria of both of the nested statements are not counted towards the rate limit and are not affected by this rule.

            You cannot nest a ``RateBasedStatement`` inside another statement, for example inside a ``NotStatement`` or ``OrStatement`` . You can define a ``RateBasedStatement`` inside a web ACL and inside a rule group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-ratebasedstatement
            '''
            result = self._values.get("rate_based_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.RateBasedStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def regex_match_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.RegexMatchStatementProperty", _IResolvable_a771d0ef]]:
            '''A rule statement used to search web request components for a match against a single regular expression.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-regexmatchstatement
            '''
            result = self._values.get("regex_match_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.RegexMatchStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def regex_pattern_set_reference_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.RegexPatternSetReferenceStatementProperty", _IResolvable_a771d0ef]]:
            '''A rule statement used to search web request components for matches with regular expressions.

            To use this, create a ``RegexPatternSet`` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.

            Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-regexpatternsetreferencestatement
            '''
            result = self._values.get("regex_pattern_set_reference_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.RegexPatternSetReferenceStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def size_constraint_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.SizeConstraintStatementProperty", _IResolvable_a771d0ef]]:
            '''A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<).

            For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.

            If you configure AWS WAF to inspect the request body, AWS WAF inspects only the first 8192 bytes (8 KB). If the request body for your web requests never exceeds 8192 bytes, you could use a size constraint statement to block requests that have a request body greater than 8192 bytes.

            If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI ``/logo.jpg`` is nine characters long.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-sizeconstraintstatement
            '''
            result = self._values.get("size_constraint_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.SizeConstraintStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def sqli_match_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.SqliMatchStatementProperty", _IResolvable_a771d0ef]]:
            '''A rule statement that inspects for malicious SQL code.

            Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-sqlimatchstatement
            '''
            result = self._values.get("sqli_match_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.SqliMatchStatementProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def xss_match_statement(
            self,
        ) -> typing.Optional[typing.Union["CfnRuleGroup.XssMatchStatementProperty", _IResolvable_a771d0ef]]:
            '''A rule statement that inspects for cross-site scripting (XSS) attacks.

            In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statement.html#cfn-wafv2-rulegroup-statement-xssmatchstatement
            '''
            result = self._values.get("xss_match_statement")
            return typing.cast(typing.Optional[typing.Union["CfnRuleGroup.XssMatchStatementProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.TextTransformationProperty",
        jsii_struct_bases=[],
        name_mapping={"priority": "priority", "type": "type"},
    )
    class TextTransformationProperty:
        def __init__(self, *, priority: jsii.Number, type: builtins.str) -> None:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            :param priority: Sets the relative processing order for multiple transformations that are defined for a rule statement. AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.
            :param type: You can specify the following transformation types:. *BASE64_DECODE* - Decode a ``Base64`` -encoded string. *BASE64_DECODE_EXT* - Decode a ``Base64`` -encoded string, but use a forgiving implementation that ignores characters that aren't valid. *CMD_LINE* - Command-line transformations. These are helpful in reducing effectiveness of attackers who inject an operating system command-line command and use unusual formatting to disguise some or all of the command. - Delete the following characters: ``\\ " ' ^`` - Delete spaces before the following characters: ``/ (`` - Replace the following characters with a space: ``, ;`` - Replace multiple spaces with one space - Convert uppercase letters (A-Z) to lowercase (a-z) *COMPRESS_WHITE_SPACE* - Replace these characters with a space character (decimal 32): - ``\\f`` , formfeed, decimal 12 - ``\\t`` , tab, decimal 9 - ``\\n`` , newline, decimal 10 - ``\\r`` , carriage return, decimal 13 - ``\\v`` , vertical tab, decimal 11 - Non-breaking space, decimal 160 ``COMPRESS_WHITE_SPACE`` also replaces multiple spaces with one space. *CSS_DECODE* - Decode characters that were encoded using CSS 2.x escape rules ``syndata.html#characters`` . This function uses up to two bytes in the decoding process, so it can help to uncover ASCII characters that were encoded using CSS encoding that wouldn’t typically be encoded. It's also useful in countering evasion, which is a combination of a backslash and non-hexadecimal characters. For example, ``ja\\vascript`` for javascript. *ESCAPE_SEQ_DECODE* - Decode the following ANSI C escape sequences: ``\\a`` , ``\\b`` , ``\\f`` , ``\\n`` , ``\\r`` , ``\\t`` , ``\\v`` , ``\\\\`` , ``\\?`` , ``\\'`` , ``\\"`` , ``\\xHH`` (hexadecimal), ``\\0OOO`` (octal). Encodings that aren't valid remain in the output. *HEX_DECODE* - Decode a string of hexadecimal characters into a binary. *HTML_ENTITY_DECODE* - Replace HTML-encoded characters with unencoded characters. ``HTML_ENTITY_DECODE`` performs these operations: - Replaces ``(ampersand)quot;`` with ``"`` - Replaces ``(ampersand)nbsp;`` with a non-breaking space, decimal 160 - Replaces ``(ampersand)lt;`` with a "less than" symbol - Replaces ``(ampersand)gt;`` with ``>`` - Replaces characters that are represented in hexadecimal format, ``(ampersand)#xhhhh;`` , with the corresponding characters - Replaces characters that are represented in decimal format, ``(ampersand)#nnnn;`` , with the corresponding characters *JS_DECODE* - Decode JavaScript escape sequences. If a ``\\`` ``u`` ``HHHH`` code is in the full-width ASCII code range of ``FF01-FF5E`` , then the higher byte is used to detect and adjust the lower byte. If not, only the lower byte is used and the higher byte is zeroed, causing a possible loss of information. *LOWERCASE* - Convert uppercase letters (A-Z) to lowercase (a-z). *MD5* - Calculate an MD5 hash from the data in the input. The computed hash is in a raw binary form. *NONE* - Specify ``NONE`` if you don't want any text transformations. *NORMALIZE_PATH* - Remove multiple slashes, directory self-references, and directory back-references that are not at the beginning of the input from an input string. *NORMALIZE_PATH_WIN* - This is the same as ``NORMALIZE_PATH`` , but first converts backslash characters to forward slashes. *REMOVE_NULLS* - Remove all ``NULL`` bytes from the input. *REPLACE_COMMENTS* - Replace each occurrence of a C-style comment ( ``/* ... * /`` ) with a single space. Multiple consecutive occurrences are not compressed. Unterminated comments are also replaced with a space (ASCII 0x20). However, a standalone termination of a comment ( ``* /`` ) is not acted upon. *REPLACE_NULLS* - Replace NULL bytes in the input with space characters (ASCII ``0x20`` ). *SQL_HEX_DECODE* - Decode SQL hex data. Example ( ``0x414243`` ) will be decoded to ( ``ABC`` ). *URL_DECODE* - Decode a URL-encoded value. *URL_DECODE_UNI* - Like ``URL_DECODE`` , but with support for Microsoft-specific ``%u`` encoding. If the code is in the full-width ASCII code range of ``FF01-FF5E`` , the higher byte is used to detect and adjust the lower byte. Otherwise, only the lower byte is used and the higher byte is zeroed. *UTF8_TO_UNICODE* - Convert all UTF-8 character sequences to Unicode. This helps input normalization, and minimizing false-positives and false-negatives for non-English languages.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                text_transformation_property = wafv2.CfnRuleGroup.TextTransformationProperty(
                    priority=123,
                    type="type"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__feea3536e945554568d6d37b5d7ece54e5ce0b3bced2f5fdf66e74a47dfa23f6)
                check_type(argname="argument priority", value=priority, expected_type=type_hints["priority"])
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "priority": priority,
                "type": type,
            }

        @builtins.property
        def priority(self) -> jsii.Number:
            '''Sets the relative processing order for multiple transformations that are defined for a rule statement.

            AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html#cfn-wafv2-rulegroup-texttransformation-priority
            '''
            result = self._values.get("priority")
            assert result is not None, "Required property 'priority' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def type(self) -> builtins.str:
            '''You can specify the following transformation types:.

            *BASE64_DECODE* - Decode a ``Base64`` -encoded string.

            *BASE64_DECODE_EXT* - Decode a ``Base64`` -encoded string, but use a forgiving implementation that ignores characters that aren't valid.

            *CMD_LINE* - Command-line transformations. These are helpful in reducing effectiveness of attackers who inject an operating system command-line command and use unusual formatting to disguise some or all of the command.

            - Delete the following characters: ``\\ " ' ^``
            - Delete spaces before the following characters: ``/ (``
            - Replace the following characters with a space: ``, ;``
            - Replace multiple spaces with one space
            - Convert uppercase letters (A-Z) to lowercase (a-z)

            *COMPRESS_WHITE_SPACE* - Replace these characters with a space character (decimal 32):

            - ``\\f`` , formfeed, decimal 12
            - ``\\t`` , tab, decimal 9
            - ``\\n`` , newline, decimal 10
            - ``\\r`` , carriage return, decimal 13
            - ``\\v`` , vertical tab, decimal 11
            - Non-breaking space, decimal 160

            ``COMPRESS_WHITE_SPACE`` also replaces multiple spaces with one space.

            *CSS_DECODE* - Decode characters that were encoded using CSS 2.x escape rules ``syndata.html#characters`` . This function uses up to two bytes in the decoding process, so it can help to uncover ASCII characters that were encoded using CSS encoding that wouldn’t typically be encoded. It's also useful in countering evasion, which is a combination of a backslash and non-hexadecimal characters. For example, ``ja\\vascript`` for javascript.

            *ESCAPE_SEQ_DECODE* - Decode the following ANSI C escape sequences: ``\\a`` , ``\\b`` , ``\\f`` , ``\\n`` , ``\\r`` , ``\\t`` , ``\\v`` , ``\\\\`` , ``\\?`` , ``\\'`` , ``\\"`` , ``\\xHH`` (hexadecimal), ``\\0OOO`` (octal). Encodings that aren't valid remain in the output.

            *HEX_DECODE* - Decode a string of hexadecimal characters into a binary.

            *HTML_ENTITY_DECODE* - Replace HTML-encoded characters with unencoded characters. ``HTML_ENTITY_DECODE`` performs these operations:

            - Replaces ``(ampersand)quot;`` with ``"``
            - Replaces ``(ampersand)nbsp;`` with a non-breaking space, decimal 160
            - Replaces ``(ampersand)lt;`` with a "less than" symbol
            - Replaces ``(ampersand)gt;`` with ``>``
            - Replaces characters that are represented in hexadecimal format, ``(ampersand)#xhhhh;`` , with the corresponding characters
            - Replaces characters that are represented in decimal format, ``(ampersand)#nnnn;`` , with the corresponding characters

            *JS_DECODE* - Decode JavaScript escape sequences. If a ``\\`` ``u`` ``HHHH`` code is in the full-width ASCII code range of ``FF01-FF5E`` , then the higher byte is used to detect and adjust the lower byte. If not, only the lower byte is used and the higher byte is zeroed, causing a possible loss of information.

            *LOWERCASE* - Convert uppercase letters (A-Z) to lowercase (a-z).

            *MD5* - Calculate an MD5 hash from the data in the input. The computed hash is in a raw binary form.

            *NONE* - Specify ``NONE`` if you don't want any text transformations.

            *NORMALIZE_PATH* - Remove multiple slashes, directory self-references, and directory back-references that are not at the beginning of the input from an input string.

            *NORMALIZE_PATH_WIN* - This is the same as ``NORMALIZE_PATH`` , but first converts backslash characters to forward slashes.

            *REMOVE_NULLS* - Remove all ``NULL`` bytes from the input.

            *REPLACE_COMMENTS* - Replace each occurrence of a C-style comment ( ``/* ... * /`` ) with a single space. Multiple consecutive occurrences are not compressed. Unterminated comments are also replaced with a space (ASCII 0x20). However, a standalone termination of a comment ( ``* /`` ) is not acted upon.

            *REPLACE_NULLS* - Replace NULL bytes in the input with space characters (ASCII ``0x20`` ).

            *SQL_HEX_DECODE* - Decode SQL hex data. Example ( ``0x414243`` ) will be decoded to ( ``ABC`` ).

            *URL_DECODE* - Decode a URL-encoded value.

            *URL_DECODE_UNI* - Like ``URL_DECODE`` , but with support for Microsoft-specific ``%u`` encoding. If the code is in the full-width ASCII code range of ``FF01-FF5E`` , the higher byte is used to detect and adjust the lower byte. Otherwise, only the lower byte is used and the higher byte is zeroed.

            *UTF8_TO_UNICODE* - Convert all UTF-8 character sequences to Unicode. This helps input normalization, and minimizing false-positives and false-negatives for non-English languages.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html#cfn-wafv2-rulegroup-texttransformation-type
            '''
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TextTransformationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.VisibilityConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "cloud_watch_metrics_enabled": "cloudWatchMetricsEnabled",
            "metric_name": "metricName",
            "sampled_requests_enabled": "sampledRequestsEnabled",
        },
    )
    class VisibilityConfigProperty:
        def __init__(
            self,
            *,
            cloud_watch_metrics_enabled: typing.Union[builtins.bool, _IResolvable_a771d0ef],
            metric_name: builtins.str,
            sampled_requests_enabled: typing.Union[builtins.bool, _IResolvable_a771d0ef],
        ) -> None:
            '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

            :param cloud_watch_metrics_enabled: A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch. For the list of available metrics, see `AWS WAF Metrics <https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics>`_ .
            :param metric_name: A name of the Amazon CloudWatch metric. The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names reserved for AWS WAF , for example ``All`` and ``Default_Action`` .
            :param sampled_requests_enabled: A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                visibility_config_property = wafv2.CfnRuleGroup.VisibilityConfigProperty(
                    cloud_watch_metrics_enabled=False,
                    metric_name="metricName",
                    sampled_requests_enabled=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__47ccbf3cfea28e2c7348e1b182e7b5aaaf3c98ea4cc43ffbafdb8bd717ce726a)
                check_type(argname="argument cloud_watch_metrics_enabled", value=cloud_watch_metrics_enabled, expected_type=type_hints["cloud_watch_metrics_enabled"])
                check_type(argname="argument metric_name", value=metric_name, expected_type=type_hints["metric_name"])
                check_type(argname="argument sampled_requests_enabled", value=sampled_requests_enabled, expected_type=type_hints["sampled_requests_enabled"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "cloud_watch_metrics_enabled": cloud_watch_metrics_enabled,
                "metric_name": metric_name,
                "sampled_requests_enabled": sampled_requests_enabled,
            }

        @builtins.property
        def cloud_watch_metrics_enabled(
            self,
        ) -> typing.Union[builtins.bool, _IResolvable_a771d0ef]:
            '''A boolean indicating whether the associated resource sends metrics to Amazon CloudWatch.

            For the list of available metrics, see `AWS WAF Metrics <https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-cloudwatchmetricsenabled
            '''
            result = self._values.get("cloud_watch_metrics_enabled")
            assert result is not None, "Required property 'cloud_watch_metrics_enabled' is missing"
            return typing.cast(typing.Union[builtins.bool, _IResolvable_a771d0ef], result)

        @builtins.property
        def metric_name(self) -> builtins.str:
            '''A name of the Amazon CloudWatch metric.

            The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names reserved for AWS WAF , for example ``All`` and ``Default_Action`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-metricname
            '''
            result = self._values.get("metric_name")
            assert result is not None, "Required property 'metric_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def sampled_requests_enabled(
            self,
        ) -> typing.Union[builtins.bool, _IResolvable_a771d0ef]:
            '''A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules.

            You can view the sampled requests through the AWS WAF console.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-sampledrequestsenabled
            '''
            result = self._values.get("sampled_requests_enabled")
            assert result is not None, "Required property 'sampled_requests_enabled' is missing"
            return typing.cast(typing.Union[builtins.bool, _IResolvable_a771d0ef], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VisibilityConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnRuleGroup.XssMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "text_transformations": "textTransformations",
        },
    )
    class XssMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[typing.Union["CfnRuleGroup.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            text_transformations: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnRuleGroup.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        ) -> None:
            '''A rule statement that inspects for cross-site scripting (XSS) attacks.

            In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                xss_match_statement_property = wafv2.CfnRuleGroup.XssMatchStatementProperty(
                    field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnRuleGroup.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnRuleGroup.CookiesProperty(
                            match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnRuleGroup.HeadersProperty(
                            match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                            match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__335250d56f52ac30d856fc5b784854f8db20e8cdf9f4043df6b7b5f7a20f88cf)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "text_transformations": text_transformations,
            }

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html#cfn-wafv2-rulegroup-xssmatchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union["CfnRuleGroup.FieldToMatchProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html#cfn-wafv2-rulegroup-xssmatchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnRuleGroup.TextTransformationProperty", _IResolvable_a771d0ef]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "XssMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_wafv2.CfnRuleGroupProps",
    jsii_struct_bases=[],
    name_mapping={
        "capacity": "capacity",
        "scope": "scope",
        "visibility_config": "visibilityConfig",
        "available_labels": "availableLabels",
        "consumed_labels": "consumedLabels",
        "custom_response_bodies": "customResponseBodies",
        "description": "description",
        "name": "name",
        "rules": "rules",
        "tags": "tags",
    },
)
class CfnRuleGroupProps:
    def __init__(
        self,
        *,
        capacity: jsii.Number,
        scope: builtins.str,
        visibility_config: typing.Union[typing.Union[CfnRuleGroup.VisibilityConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        available_labels: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union[CfnRuleGroup.LabelSummaryProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        consumed_labels: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union[CfnRuleGroup.LabelSummaryProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        custom_response_bodies: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[typing.Union[CfnRuleGroup.CustomResponseBodyProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union[CfnRuleGroup.RuleProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnRuleGroup``.

        :param capacity: The web ACL capacity units (WCUs) required for this rule group. When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit. AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .
        :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
        :param available_labels: ``AWS::WAFv2::RuleGroup.AvailableLabels``.
        :param consumed_labels: ``AWS::WAFv2::RuleGroup.ConsumedLabels``.
        :param custom_response_bodies: A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ . For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .
        :param description: A description of the rule group that helps with identification.
        :param name: The name of the rule group. You cannot change the name of a rule group after you create it.
        :param rules: The rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_wafv2 as wafv2
            
            # all: Any
            # allow: Any
            # all_query_arguments: Any
            # block: Any
            # captcha: Any
            # count: Any
            # method: Any
            # query_string: Any
            # single_header: Any
            # single_query_argument: Any
            # statement_property_: wafv2.CfnRuleGroup.StatementProperty
            # uri_path: Any
            
            cfn_rule_group_props = wafv2.CfnRuleGroupProps(
                capacity=123,
                scope="scope",
                visibility_config=wafv2.CfnRuleGroup.VisibilityConfigProperty(
                    cloud_watch_metrics_enabled=False,
                    metric_name="metricName",
                    sampled_requests_enabled=False
                ),
            
                # the properties below are optional
                available_labels=[wafv2.CfnRuleGroup.LabelSummaryProperty(
                    name="name"
                )],
                consumed_labels=[wafv2.CfnRuleGroup.LabelSummaryProperty(
                    name="name"
                )],
                custom_response_bodies={
                    "custom_response_bodies_key": wafv2.CfnRuleGroup.CustomResponseBodyProperty(
                        content="content",
                        content_type="contentType"
                    )
                },
                description="description",
                name="name",
                rules=[wafv2.CfnRuleGroup.RuleProperty(
                    name="name",
                    priority=123,
                    statement=wafv2.CfnRuleGroup.StatementProperty(
                        and_statement=wafv2.CfnRuleGroup.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnRuleGroup.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
            
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnRuleGroup.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
            
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnRuleGroup.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        not_statement=wafv2.CfnRuleGroup.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnRuleGroup.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnRuleGroup.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
            
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnRuleGroup.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnRuleGroup.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnRuleGroup.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnRuleGroup.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnRuleGroup.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
            
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnRuleGroup.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnRuleGroup.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnRuleGroup.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnRuleGroup.CookiesProperty(
                                    match_pattern=wafv2.CfnRuleGroup.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnRuleGroup.HeadersProperty(
                                    match_pattern=wafv2.CfnRuleGroup.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnRuleGroup.JsonBodyProperty(
                                    match_pattern=wafv2.CfnRuleGroup.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
            
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnRuleGroup.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    ),
                    visibility_config=wafv2.CfnRuleGroup.VisibilityConfigProperty(
                        cloud_watch_metrics_enabled=False,
                        metric_name="metricName",
                        sampled_requests_enabled=False
                    ),
            
                    # the properties below are optional
                    action=wafv2.CfnRuleGroup.RuleActionProperty(
                        allow=allow,
                        block=block,
                        captcha=captcha,
                        challenge=wafv2.CfnRuleGroup.ChallengeProperty(
                            custom_request_handling=wafv2.CfnRuleGroup.CustomRequestHandlingProperty(
                                insert_headers=[wafv2.CfnRuleGroup.CustomHTTPHeaderProperty(
                                    name="name",
                                    value="value"
                                )]
                            )
                        ),
                        count=count
                    ),
                    captcha_config=wafv2.CfnRuleGroup.CaptchaConfigProperty(
                        immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                            immunity_time=123
                        )
                    ),
                    challenge_config=wafv2.CfnRuleGroup.ChallengeConfigProperty(
                        immunity_time_property=wafv2.CfnRuleGroup.ImmunityTimePropertyProperty(
                            immunity_time=123
                        )
                    ),
                    rule_labels=[wafv2.CfnRuleGroup.LabelProperty(
                        name="name"
                    )]
                )],
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f019d79e02c1d74651784993ea63e7f961dbfcd1b9c7e63ff2b68ecb86b8854)
            check_type(argname="argument capacity", value=capacity, expected_type=type_hints["capacity"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument visibility_config", value=visibility_config, expected_type=type_hints["visibility_config"])
            check_type(argname="argument available_labels", value=available_labels, expected_type=type_hints["available_labels"])
            check_type(argname="argument consumed_labels", value=consumed_labels, expected_type=type_hints["consumed_labels"])
            check_type(argname="argument custom_response_bodies", value=custom_response_bodies, expected_type=type_hints["custom_response_bodies"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "capacity": capacity,
            "scope": scope,
            "visibility_config": visibility_config,
        }
        if available_labels is not None:
            self._values["available_labels"] = available_labels
        if consumed_labels is not None:
            self._values["consumed_labels"] = consumed_labels
        if custom_response_bodies is not None:
            self._values["custom_response_bodies"] = custom_response_bodies
        if description is not None:
            self._values["description"] = description
        if name is not None:
            self._values["name"] = name
        if rules is not None:
            self._values["rules"] = rules
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def capacity(self) -> jsii.Number:
        '''The web ACL capacity units (WCUs) required for this rule group.

        When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit.

        AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-capacity
        '''
        result = self._values.get("capacity")
        assert result is not None, "Required property 'capacity' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-scope
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def visibility_config(
        self,
    ) -> typing.Union[CfnRuleGroup.VisibilityConfigProperty, _IResolvable_a771d0ef]:
        '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-visibilityconfig
        '''
        result = self._values.get("visibility_config")
        assert result is not None, "Required property 'visibility_config' is missing"
        return typing.cast(typing.Union[CfnRuleGroup.VisibilityConfigProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def available_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnRuleGroup.LabelSummaryProperty, _IResolvable_a771d0ef]]]]:
        '''``AWS::WAFv2::RuleGroup.AvailableLabels``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-availablelabels
        '''
        result = self._values.get("available_labels")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnRuleGroup.LabelSummaryProperty, _IResolvable_a771d0ef]]]], result)

    @builtins.property
    def consumed_labels(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnRuleGroup.LabelSummaryProperty, _IResolvable_a771d0ef]]]]:
        '''``AWS::WAFv2::RuleGroup.ConsumedLabels``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-consumedlabels
        '''
        result = self._values.get("consumed_labels")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnRuleGroup.LabelSummaryProperty, _IResolvable_a771d0ef]]]], result)

    @builtins.property
    def custom_response_bodies(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[CfnRuleGroup.CustomResponseBodyProperty, _IResolvable_a771d0ef]]]]:
        '''A map of custom response keys and content bodies.

        When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.

        For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

        For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-customresponsebodies
        '''
        result = self._values.get("custom_response_bodies")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[CfnRuleGroup.CustomResponseBodyProperty, _IResolvable_a771d0ef]]]], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the rule group that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the rule group.

        You cannot change the name of a rule group after you create it.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-name
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnRuleGroup.RuleProperty, _IResolvable_a771d0ef]]]]:
        '''The rule statements used to identify the web requests that you want to allow, block, or count.

        Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnRuleGroup.RuleProperty, _IResolvable_a771d0ef]]]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnRuleGroupProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnWebACL(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_wafv2.CfnWebACL",
):
    '''A CloudFormation ``AWS::WAFv2::WebACL``.

    .. epigraph::

       This is the latest version of *AWS WAF* , named AWS WAF V2, released in November, 2019. For information, including how to migrate your AWS WAF resources from the prior release, see the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

    Use an ``WebACL`` to define a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you specify a default action to take (allow, block) for any request that doesn't match any of the rules. The rules in a web ACL can contain rule statements that you define explicitly and rule statements that reference rule groups and managed rule groups. You can associate a web ACL with one or more AWS resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer , an AWS AppSync GraphQL API, or an Amazon Cognito user pool.

    :cloudformationResource: AWS::WAFv2::WebACL
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_wafv2 as wafv2
        
        # all: Any
        # all_query_arguments: Any
        # count: Any
        # method: Any
        # none: Any
        # query_string: Any
        # single_header: Any
        # single_query_argument: Any
        # statement_property_: wafv2.CfnWebACL.StatementProperty
        # uri_path: Any
        
        cfn_web_aCL = wafv2.CfnWebACL(self, "MyCfnWebACL",
            default_action=wafv2.CfnWebACL.DefaultActionProperty(
                allow=wafv2.CfnWebACL.AllowActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                ),
                block=wafv2.CfnWebACL.BlockActionProperty(
                    custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                        response_code=123,
        
                        # the properties below are optional
                        custom_response_body_key="customResponseBodyKey",
                        response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            ),
            scope="scope",
            visibility_config=wafv2.CfnWebACL.VisibilityConfigProperty(
                cloud_watch_metrics_enabled=False,
                metric_name="metricName",
                sampled_requests_enabled=False
            ),
        
            # the properties below are optional
            captcha_config=wafv2.CfnWebACL.CaptchaConfigProperty(
                immunity_time_property=wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                    immunity_time=123
                )
            ),
            challenge_config=wafv2.CfnWebACL.ChallengeConfigProperty(
                immunity_time_property=wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                    immunity_time=123
                )
            ),
            custom_response_bodies={
                "custom_response_bodies_key": wafv2.CfnWebACL.CustomResponseBodyProperty(
                    content="content",
                    content_type="contentType"
                )
            },
            description="description",
            name="name",
            rules=[wafv2.CfnWebACL.RuleProperty(
                name="name",
                priority=123,
                statement=wafv2.CfnWebACL.StatementProperty(
                    and_statement=wafv2.CfnWebACL.AndStatementProperty(
                        statements=[statement_property_]
                    ),
                    byte_match_statement=wafv2.CfnWebACL.ByteMatchStatementProperty(
                        field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnWebACL.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnWebACL.CookiesProperty(
                                match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnWebACL.HeadersProperty(
                                match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        positional_constraint="positionalConstraint",
                        text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )],
        
                        # the properties below are optional
                        search_string="searchString",
                        search_string_base64="searchStringBase64"
                    ),
                    geo_match_statement=wafv2.CfnWebACL.GeoMatchStatementProperty(
                        country_codes=["countryCodes"],
                        forwarded_ip_config=wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                            fallback_behavior="fallbackBehavior",
                            header_name="headerName"
                        )
                    ),
                    ip_set_reference_statement={
                        "arn": "arn",
        
                        # the properties below are optional
                        "ip_set_forwarded_ip_config": {
                            "fallback_behavior": "fallbackBehavior",
                            "header_name": "headerName",
                            "position": "position"
                        }
                    },
                    label_match_statement=wafv2.CfnWebACL.LabelMatchStatementProperty(
                        key="key",
                        scope="scope"
                    ),
                    managed_rule_group_statement=wafv2.CfnWebACL.ManagedRuleGroupStatementProperty(
                        name="name",
                        vendor_name="vendorName",
        
                        # the properties below are optional
                        excluded_rules=[wafv2.CfnWebACL.ExcludedRuleProperty(
                            name="name"
                        )],
                        managed_rule_group_configs=[wafv2.CfnWebACL.ManagedRuleGroupConfigProperty(
                            aws_managed_rules_bot_control_rule_set=wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty(
                                inspection_level="inspectionLevel"
                            ),
                            login_path="loginPath",
                            password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                identifier="identifier"
                            ),
                            payload_type="payloadType",
                            username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                identifier="identifier"
                            )
                        )],
                        rule_action_overrides=[wafv2.CfnWebACL.RuleActionOverrideProperty(
                            action_to_use=wafv2.CfnWebACL.RuleActionProperty(
                                allow=wafv2.CfnWebACL.AllowActionProperty(
                                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                            name="name",
                                            value="value"
                                        )]
                                    )
                                ),
                                block=wafv2.CfnWebACL.BlockActionProperty(
                                    custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                                        response_code=123,
        
                                        # the properties below are optional
                                        custom_response_body_key="customResponseBodyKey",
                                        response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                            name="name",
                                            value="value"
                                        )]
                                    )
                                ),
                                captcha=wafv2.CfnWebACL.CaptchaActionProperty(
                                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                            name="name",
                                            value="value"
                                        )]
                                    )
                                ),
                                challenge=wafv2.CfnWebACL.ChallengeActionProperty(
                                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                            name="name",
                                            value="value"
                                        )]
                                    )
                                ),
                                count=wafv2.CfnWebACL.CountActionProperty(
                                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                            name="name",
                                            value="value"
                                        )]
                                    )
                                )
                            ),
                            name="name"
                        )],
                        scope_down_statement=statement_property_,
                        version="version"
                    ),
                    not_statement=wafv2.CfnWebACL.NotStatementProperty(
                        statement=statement_property_
                    ),
                    or_statement=wafv2.CfnWebACL.OrStatementProperty(
                        statements=[statement_property_]
                    ),
                    rate_based_statement=wafv2.CfnWebACL.RateBasedStatementProperty(
                        aggregate_key_type="aggregateKeyType",
                        limit=123,
        
                        # the properties below are optional
                        forwarded_ip_config=wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                            fallback_behavior="fallbackBehavior",
                            header_name="headerName"
                        ),
                        scope_down_statement=statement_property_
                    ),
                    regex_match_statement=wafv2.CfnWebACL.RegexMatchStatementProperty(
                        field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnWebACL.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnWebACL.CookiesProperty(
                                match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnWebACL.HeadersProperty(
                                match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        regex_string="regexString",
                        text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    regex_pattern_set_reference_statement=wafv2.CfnWebACL.RegexPatternSetReferenceStatementProperty(
                        arn="arn",
                        field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnWebACL.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnWebACL.CookiesProperty(
                                match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnWebACL.HeadersProperty(
                                match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    rule_group_reference_statement=wafv2.CfnWebACL.RuleGroupReferenceStatementProperty(
                        arn="arn",
        
                        # the properties below are optional
                        excluded_rules=[wafv2.CfnWebACL.ExcludedRuleProperty(
                            name="name"
                        )],
                        rule_action_overrides=[wafv2.CfnWebACL.RuleActionOverrideProperty(
                            action_to_use=wafv2.CfnWebACL.RuleActionProperty(
                                allow=wafv2.CfnWebACL.AllowActionProperty(
                                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                            name="name",
                                            value="value"
                                        )]
                                    )
                                ),
                                block=wafv2.CfnWebACL.BlockActionProperty(
                                    custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                                        response_code=123,
        
                                        # the properties below are optional
                                        custom_response_body_key="customResponseBodyKey",
                                        response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                            name="name",
                                            value="value"
                                        )]
                                    )
                                ),
                                captcha=wafv2.CfnWebACL.CaptchaActionProperty(
                                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                            name="name",
                                            value="value"
                                        )]
                                    )
                                ),
                                challenge=wafv2.CfnWebACL.ChallengeActionProperty(
                                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                            name="name",
                                            value="value"
                                        )]
                                    )
                                ),
                                count=wafv2.CfnWebACL.CountActionProperty(
                                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                            name="name",
                                            value="value"
                                        )]
                                    )
                                )
                            ),
                            name="name"
                        )]
                    ),
                    size_constraint_statement=wafv2.CfnWebACL.SizeConstraintStatementProperty(
                        comparison_operator="comparisonOperator",
                        field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnWebACL.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnWebACL.CookiesProperty(
                                match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnWebACL.HeadersProperty(
                                match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        size=123,
                        text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    ),
                    sqli_match_statement=wafv2.CfnWebACL.SqliMatchStatementProperty(
                        field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnWebACL.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnWebACL.CookiesProperty(
                                match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnWebACL.HeadersProperty(
                                match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )],
        
                        # the properties below are optional
                        sensitivity_level="sensitivityLevel"
                    ),
                    xss_match_statement=wafv2.CfnWebACL.XssMatchStatementProperty(
                        field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                            all_query_arguments=all_query_arguments,
                            body=wafv2.CfnWebACL.BodyProperty(
                                oversize_handling="oversizeHandling"
                            ),
                            cookies=wafv2.CfnWebACL.CookiesProperty(
                                match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                    all=all,
                                    excluded_cookies=["excludedCookies"],
                                    included_cookies=["includedCookies"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            headers=wafv2.CfnWebACL.HeadersProperty(
                                match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                    all=all,
                                    excluded_headers=["excludedHeaders"],
                                    included_headers=["includedHeaders"]
                                ),
                                match_scope="matchScope",
                                oversize_handling="oversizeHandling"
                            ),
                            json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                    all=all,
                                    included_paths=["includedPaths"]
                                ),
                                match_scope="matchScope",
        
                                # the properties below are optional
                                invalid_fallback_behavior="invalidFallbackBehavior",
                                oversize_handling="oversizeHandling"
                            ),
                            method=method,
                            query_string=query_string,
                            single_header=single_header,
                            single_query_argument=single_query_argument,
                            uri_path=uri_path
                        ),
                        text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                            priority=123,
                            type="type"
                        )]
                    )
                ),
                visibility_config=wafv2.CfnWebACL.VisibilityConfigProperty(
                    cloud_watch_metrics_enabled=False,
                    metric_name="metricName",
                    sampled_requests_enabled=False
                ),
        
                # the properties below are optional
                action=wafv2.CfnWebACL.RuleActionProperty(
                    allow=wafv2.CfnWebACL.AllowActionProperty(
                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    block=wafv2.CfnWebACL.BlockActionProperty(
                        custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                            response_code=123,
        
                            # the properties below are optional
                            custom_response_body_key="customResponseBodyKey",
                            response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    captcha=wafv2.CfnWebACL.CaptchaActionProperty(
                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    challenge=wafv2.CfnWebACL.ChallengeActionProperty(
                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    count=wafv2.CfnWebACL.CountActionProperty(
                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    )
                ),
                captcha_config=wafv2.CfnWebACL.CaptchaConfigProperty(
                    immunity_time_property=wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                ),
                challenge_config=wafv2.CfnWebACL.ChallengeConfigProperty(
                    immunity_time_property=wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                ),
                override_action=wafv2.CfnWebACL.OverrideActionProperty(
                    count=count,
                    none=none
                ),
                rule_labels=[wafv2.CfnWebACL.LabelProperty(
                    name="name"
                )]
            )],
            tags=[CfnTag(
                key="key",
                value="value"
            )],
            token_domains=["tokenDomains"]
        )
    '''

    def __init__(
        self,
        scope_: _Construct_e78e779f,
        id: builtins.str,
        *,
        default_action: typing.Union[typing.Union["CfnWebACL.DefaultActionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        scope: builtins.str,
        visibility_config: typing.Union[typing.Union["CfnWebACL.VisibilityConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        captcha_config: typing.Optional[typing.Union[typing.Union["CfnWebACL.CaptchaConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        challenge_config: typing.Optional[typing.Union[typing.Union["CfnWebACL.ChallengeConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        custom_response_bodies: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union[typing.Union["CfnWebACL.CustomResponseBodyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        description: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        rules: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnWebACL.RuleProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
        token_domains: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Create a new ``AWS::WAFv2::WebACL``.

        :param scope_: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param default_action: The action to perform if none of the ``Rules`` contained in the ``WebACL`` match.
        :param scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` . .. epigraph:: For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` . For information about how to define the association of the web ACL with your resource, see ``WebACLAssociation`` .
        :param visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
        :param captcha_config: Specifies how AWS WAF should handle ``CAPTCHA`` evaluations for rules that don't have their own ``CaptchaConfig`` settings. If you don't specify this, AWS WAF uses its default settings for ``CaptchaConfig`` .
        :param challenge_config: Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own ``ChallengeConfig`` settings. If you don't specify this, AWS WAF uses its default settings for ``ChallengeConfig`` .
        :param custom_response_bodies: A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ . For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .
        :param description: A description of the web ACL that helps with identification.
        :param name: The name of the web ACL. You cannot change the name of a web ACL after you create it.
        :param rules: The rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
        :param tags: Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource. .. epigraph:: To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        :param token_domains: Specifies the domains that AWS WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d012cdd3d0b7666cb8d4f36f9e92e6593e1ee11efd139889dd73eb93caf166b)
            check_type(argname="argument scope_", value=scope_, expected_type=type_hints["scope_"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnWebACLProps(
            default_action=default_action,
            scope=scope,
            visibility_config=visibility_config,
            captcha_config=captcha_config,
            challenge_config=challenge_config,
            custom_response_bodies=custom_response_bodies,
            description=description,
            name=name,
            rules=rules,
            tags=tags,
            token_domains=token_domains,
        )

        jsii.create(self.__class__, self, [scope_, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__60c6e0f0f197fd874454ab823e48ad49aff397252e6886a47ddb1d02cd1c71be)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e365abb088b22f22b3f680c061218677b76bc068fd2b5cdee74234a527b25a9)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the web ACL.

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property
    @jsii.member(jsii_name="attrCapacity")
    def attr_capacity(self) -> jsii.Number:
        '''The web ACL capacity units (WCUs) currently being used by this web ACL.

        AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.

        :cloudformationAttribute: Capacity
        '''
        return typing.cast(jsii.Number, jsii.get(self, "attrCapacity"))

    @builtins.property
    @jsii.member(jsii_name="attrId")
    def attr_id(self) -> builtins.str:
        '''The ID of the web ACL.

        :cloudformationAttribute: Id
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrId"))

    @builtins.property
    @jsii.member(jsii_name="attrLabelNamespace")
    def attr_label_namespace(self) -> builtins.str:
        '''The label namespace prefix for this web ACL.

        All labels added by rules in this web ACL have this prefix.

        The syntax for the label namespace prefix for a web ACL is the following: ``awswaf:<account ID>:webacl:<web ACL name>:``

        When a rule with a label matches a web request, AWS WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon.

        :cloudformationAttribute: LabelNamespace
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrLabelNamespace"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''Key:value pairs associated with an AWS resource.

        The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
        .. epigraph::

           To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="defaultAction")
    def default_action(
        self,
    ) -> typing.Union["CfnWebACL.DefaultActionProperty", _IResolvable_a771d0ef]:
        '''The action to perform if none of the ``Rules`` contained in the ``WebACL`` match.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-defaultaction
        '''
        return typing.cast(typing.Union["CfnWebACL.DefaultActionProperty", _IResolvable_a771d0ef], jsii.get(self, "defaultAction"))

    @default_action.setter
    def default_action(
        self,
        value: typing.Union["CfnWebACL.DefaultActionProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e3ab5c55f8c1ce75578f722bc6e2247210505f67e7b21f78ad1a6bd72e72c43f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "defaultAction", value)

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> builtins.str:
        '''Specifies whether this is for an Amazon CloudFront distribution or for a regional application.

        A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, or an Amazon Cognito user pool. Valid Values are ``CLOUDFRONT`` and ``REGIONAL`` .
        .. epigraph::

           For ``CLOUDFRONT`` , you must create your WAFv2 resources in the US East (N. Virginia) Region, ``us-east-1`` .

        For information about how to define the association of the web ACL with your resource, see ``WebACLAssociation`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-scope
        '''
        return typing.cast(builtins.str, jsii.get(self, "scope"))

    @scope.setter
    def scope(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2d6da9fd70d2b64474ef85266362f412971ca1a62ad9e48b637447f5e5bd1380)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "scope", value)

    @builtins.property
    @jsii.member(jsii_name="visibilityConfig")
    def visibility_config(
        self,
    ) -> typing.Union["CfnWebACL.VisibilityConfigProperty", _IResolvable_a771d0ef]:
        '''Defines and enables Amazon CloudWatch metrics and web request sample collection.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-visibilityconfig
        '''
        return typing.cast(typing.Union["CfnWebACL.VisibilityConfigProperty", _IResolvable_a771d0ef], jsii.get(self, "visibilityConfig"))

    @visibility_config.setter
    def visibility_config(
        self,
        value: typing.Union["CfnWebACL.VisibilityConfigProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3cfc5039b891475acc3a9848e2705a235232366aa853ab79e9f8882c83ab6fd8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "visibilityConfig", value)

    @builtins.property
    @jsii.member(jsii_name="captchaConfig")
    def captcha_config(
        self,
    ) -> typing.Optional[typing.Union["CfnWebACL.CaptchaConfigProperty", _IResolvable_a771d0ef]]:
        '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations for rules that don't have their own ``CaptchaConfig`` settings.

        If you don't specify this, AWS WAF uses its default settings for ``CaptchaConfig`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-captchaconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnWebACL.CaptchaConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "captchaConfig"))

    @captcha_config.setter
    def captcha_config(
        self,
        value: typing.Optional[typing.Union["CfnWebACL.CaptchaConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1840f30031bf640780789fde1108bf771ac2e790250b493eb2694dfd21dab1ea)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "captchaConfig", value)

    @builtins.property
    @jsii.member(jsii_name="challengeConfig")
    def challenge_config(
        self,
    ) -> typing.Optional[typing.Union["CfnWebACL.ChallengeConfigProperty", _IResolvable_a771d0ef]]:
        '''Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own ``ChallengeConfig`` settings.

        If you don't specify this, AWS WAF uses its default settings for ``ChallengeConfig`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-challengeconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnWebACL.ChallengeConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "challengeConfig"))

    @challenge_config.setter
    def challenge_config(
        self,
        value: typing.Optional[typing.Union["CfnWebACL.ChallengeConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__600e0c0de457cb9302b187005fa23bac3e10dc8b6ba1c3cf59b1c22152e1c444)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "challengeConfig", value)

    @builtins.property
    @jsii.member(jsii_name="customResponseBodies")
    def custom_response_bodies(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union["CfnWebACL.CustomResponseBodyProperty", _IResolvable_a771d0ef]]]]:
        '''A map of custom response keys and content bodies.

        When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.

        For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

        For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-customresponsebodies
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union["CfnWebACL.CustomResponseBodyProperty", _IResolvable_a771d0ef]]]], jsii.get(self, "customResponseBodies"))

    @custom_response_bodies.setter
    def custom_response_bodies(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, typing.Union["CfnWebACL.CustomResponseBodyProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a4b54cbd4e67a0d07624f32a0c68bf38c8bcd6ac2115ec1b9989c8348b332466)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "customResponseBodies", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the web ACL that helps with identification.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__051fc7d0c8163f8914c9cdda83f47888bccaa444a806814d3d3f456ff15f4702)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the web ACL.

        You cannot change the name of a web ACL after you create it.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-name
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3736b8ab4adb1d4d6700010a9ac7e70c84da4b84ada39431b832ce76807c3b6c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnWebACL.RuleProperty", _IResolvable_a771d0ef]]]]:
        '''The rule statements used to identify the web requests that you want to allow, block, or count.

        Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-rules
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnWebACL.RuleProperty", _IResolvable_a771d0ef]]]], jsii.get(self, "rules"))

    @rules.setter
    def rules(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnWebACL.RuleProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c10d4bc9aab7b70a5292ae41b70e585d181d4a302fc1e65b1d8c9a300cd0adb9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "rules", value)

    @builtins.property
    @jsii.member(jsii_name="tokenDomains")
    def token_domains(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Specifies the domains that AWS WAF should accept in a web request token.

        This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-tokendomains
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "tokenDomains"))

    @token_domains.setter
    def token_domains(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ffb563e8d841eb431063aba876b45be16a1beea73249fc82a4288910cb32606d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tokenDomains", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty",
        jsii_struct_bases=[],
        name_mapping={"inspection_level": "inspectionLevel"},
    )
    class AWSManagedRulesBotControlRuleSetProperty:
        def __init__(self, *, inspection_level: builtins.str) -> None:
            '''Details for your use of the Bot Control managed rule group, used in ``ManagedRuleGroupConfig`` .

            :param inspection_level: The inspection level to use for the Bot Control rule group. The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                a_wSManaged_rules_bot_control_rule_set_property = wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty(
                    inspection_level="inspectionLevel"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__872f0007b59012528e4eb7ea52713cf4b5b6188dd0ce736da5708a7926a1850d)
                check_type(argname="argument inspection_level", value=inspection_level, expected_type=type_hints["inspection_level"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "inspection_level": inspection_level,
            }

        @builtins.property
        def inspection_level(self) -> builtins.str:
            '''The inspection level to use for the Bot Control rule group.

            The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html#cfn-wafv2-webacl-awsmanagedrulesbotcontrolruleset-inspectionlevel
            '''
            result = self._values.get("inspection_level")
            assert result is not None, "Required property 'inspection_level' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AWSManagedRulesBotControlRuleSetProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.AllowActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class AllowActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies that AWS WAF should allow the request and optionally defines additional custom handling for the request.

            This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.

            :param custom_request_handling: Defines custom handling for the web request. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-allowaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                allow_action_property = wafv2.CfnWebACL.AllowActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a8341a9fe018306ca34f9569ad46598b02bec05117421ff8c74ed7ddb57c9543)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.CustomRequestHandlingProperty", _IResolvable_a771d0ef]]:
            '''Defines custom handling for the web request.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-allowaction.html#cfn-wafv2-webacl-allowaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.CustomRequestHandlingProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AllowActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.AndStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"statements": "statements"},
    )
    class AndStatementProperty:
        def __init__(
            self,
            *,
            statements: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnWebACL.StatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        ) -> None:
            '''A logical rule statement used to combine other rule statements with AND logic.

            You provide more than one ``Statement`` within the ``AndStatement`` .

            :param statements: The statements to combine with AND logic. You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnWebACL.StatementProperty
                # uri_path: Any
                
                and_statement_property = wafv2.CfnWebACL.AndStatementProperty(
                    statements=[wafv2.CfnWebACL.StatementProperty(
                        and_statement=wafv2.CfnWebACL.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnWebACL.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnWebACL.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnWebACL.CookiesProperty(
                                    match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnWebACL.HeadersProperty(
                                    match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                    match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnWebACL.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnWebACL.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        managed_rule_group_statement=wafv2.CfnWebACL.ManagedRuleGroupStatementProperty(
                            name="name",
                            vendor_name="vendorName",
                
                            # the properties below are optional
                            excluded_rules=[wafv2.CfnWebACL.ExcludedRuleProperty(
                                name="name"
                            )],
                            managed_rule_group_configs=[wafv2.CfnWebACL.ManagedRuleGroupConfigProperty(
                                aws_managed_rules_bot_control_rule_set=wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty(
                                    inspection_level="inspectionLevel"
                                ),
                                login_path="loginPath",
                                password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                    identifier="identifier"
                                ),
                                payload_type="payloadType",
                                username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                    identifier="identifier"
                                )
                            )],
                            rule_action_overrides=[wafv2.CfnWebACL.RuleActionOverrideProperty(
                                action_to_use=wafv2.CfnWebACL.RuleActionProperty(
                                    allow=wafv2.CfnWebACL.AllowActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    block=wafv2.CfnWebACL.BlockActionProperty(
                                        custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                                            response_code=123,
                
                                            # the properties below are optional
                                            custom_response_body_key="customResponseBodyKey",
                                            response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    captcha=wafv2.CfnWebACL.CaptchaActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    challenge=wafv2.CfnWebACL.ChallengeActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    count=wafv2.CfnWebACL.CountActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    )
                                ),
                                name="name"
                            )],
                            scope_down_statement=statement_property_,
                            version="version"
                        ),
                        not_statement=wafv2.CfnWebACL.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnWebACL.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnWebACL.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnWebACL.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnWebACL.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnWebACL.CookiesProperty(
                                    match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnWebACL.HeadersProperty(
                                    match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                    match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            regex_string="regexString",
                            text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        regex_pattern_set_reference_statement=wafv2.CfnWebACL.RegexPatternSetReferenceStatementProperty(
                            arn="arn",
                            field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnWebACL.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnWebACL.CookiesProperty(
                                    match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnWebACL.HeadersProperty(
                                    match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                    match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        rule_group_reference_statement=wafv2.CfnWebACL.RuleGroupReferenceStatementProperty(
                            arn="arn",
                
                            # the properties below are optional
                            excluded_rules=[wafv2.CfnWebACL.ExcludedRuleProperty(
                                name="name"
                            )],
                            rule_action_overrides=[wafv2.CfnWebACL.RuleActionOverrideProperty(
                                action_to_use=wafv2.CfnWebACL.RuleActionProperty(
                                    allow=wafv2.CfnWebACL.AllowActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    block=wafv2.CfnWebACL.BlockActionProperty(
                                        custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                                            response_code=123,
                
                                            # the properties below are optional
                                            custom_response_body_key="customResponseBodyKey",
                                            response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    captcha=wafv2.CfnWebACL.CaptchaActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    challenge=wafv2.CfnWebACL.ChallengeActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    count=wafv2.CfnWebACL.CountActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    )
                                ),
                                name="name"
                            )]
                        ),
                        size_constraint_statement=wafv2.CfnWebACL.SizeConstraintStatementProperty(
                            comparison_operator="comparisonOperator",
                            field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnWebACL.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnWebACL.CookiesProperty(
                                    match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnWebACL.HeadersProperty(
                                    match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                    match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            size=123,
                            text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        ),
                        sqli_match_statement=wafv2.CfnWebACL.SqliMatchStatementProperty(
                            field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnWebACL.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnWebACL.CookiesProperty(
                                    match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnWebACL.HeadersProperty(
                                    match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                    match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            sensitivity_level="sensitivityLevel"
                        ),
                        xss_match_statement=wafv2.CfnWebACL.XssMatchStatementProperty(
                            field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnWebACL.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnWebACL.CookiesProperty(
                                    match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnWebACL.HeadersProperty(
                                    match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                    match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )]
                        )
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cb6dd7bce8e1d5159485541a41690270b92c1f27cf51d3f9f050013635cc2454)
                check_type(argname="argument statements", value=statements, expected_type=type_hints["statements"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "statements": statements,
            }

        @builtins.property
        def statements(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnWebACL.StatementProperty", _IResolvable_a771d0ef]]]:
            '''The statements to combine with AND logic.

            You can use any statements that can be nested.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatement.html#cfn-wafv2-webacl-andstatement-statements
            '''
            result = self._values.get("statements")
            assert result is not None, "Required property 'statements' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnWebACL.StatementProperty", _IResolvable_a771d0ef]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AndStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.BlockActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_response": "customResponse"},
    )
    class BlockActionProperty:
        def __init__(
            self,
            *,
            custom_response: typing.Optional[typing.Union[typing.Union["CfnWebACL.CustomResponseProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies that AWS WAF should block the request and optionally defines additional custom handling for the response to the web request.

            This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.

            :param custom_response: Defines a custom response for the web request. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-blockaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                block_action_property = wafv2.CfnWebACL.BlockActionProperty(
                    custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                        response_code=123,
                
                        # the properties below are optional
                        custom_response_body_key="customResponseBodyKey",
                        response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bec7d1e35b70b004826dce4d0751ea198ccc3c40cd1ac17d7620c06dadd73a2b)
                check_type(argname="argument custom_response", value=custom_response, expected_type=type_hints["custom_response"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_response is not None:
                self._values["custom_response"] = custom_response

        @builtins.property
        def custom_response(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.CustomResponseProperty", _IResolvable_a771d0ef]]:
            '''Defines a custom response for the web request.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-blockaction.html#cfn-wafv2-webacl-blockaction-customresponse
            '''
            result = self._values.get("custom_response")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.CustomResponseProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlockActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.BodyProperty",
        jsii_struct_bases=[],
        name_mapping={"oversize_handling": "oversizeHandling"},
    )
    class BodyProperty:
        def __init__(
            self,
            *,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the body normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB. Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-body.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                body_property = wafv2.CfnWebACL.BodyProperty(
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f6f2a2bb595e0c7ce99fb85b8cb9bfb3aba34ea87a9310d6f86912dcd55a1399)
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the body normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB.

            Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-body.html#cfn-wafv2-webacl-body-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.ByteMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "field_to_match": "fieldToMatch",
            "positional_constraint": "positionalConstraint",
            "text_transformations": "textTransformations",
            "search_string": "searchString",
            "search_string_base64": "searchStringBase64",
        },
    )
    class ByteMatchStatementProperty:
        def __init__(
            self,
            *,
            field_to_match: typing.Union[typing.Union["CfnWebACL.FieldToMatchProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            positional_constraint: builtins.str,
            text_transformations: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnWebACL.TextTransformationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
            search_string: typing.Optional[builtins.str] = None,
            search_string_base64: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement that defines a string match search for AWS WAF to apply to web requests.

            The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.

            :param field_to_match: The part of the web request that you want AWS WAF to inspect.
            :param positional_constraint: The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` . Valid values include the following: *CONTAINS* The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter. *CONTAINS_WORD* The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true: - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` . - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` . *EXACTLY* The value of the specified part of the web request must exactly match the value of ``SearchString`` . *STARTS_WITH* The value of ``SearchString`` must appear at the beginning of the specified part of the web request. *ENDS_WITH* The value of ``SearchString`` must appear at the end of the specified part of the web request.
            :param text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.
            :param search_string: A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 50 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive. Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you. For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` . You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .
            :param search_string_base64: String to search for in a web request component, base64-encoded. If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead. You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                byte_match_statement_property = wafv2.CfnWebACL.ByteMatchStatementProperty(
                    field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                        all_query_arguments=all_query_arguments,
                        body=wafv2.CfnWebACL.BodyProperty(
                            oversize_handling="oversizeHandling"
                        ),
                        cookies=wafv2.CfnWebACL.CookiesProperty(
                            match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                all=all,
                                excluded_cookies=["excludedCookies"],
                                included_cookies=["includedCookies"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        headers=wafv2.CfnWebACL.HeadersProperty(
                            match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                all=all,
                                excluded_headers=["excludedHeaders"],
                                included_headers=["includedHeaders"]
                            ),
                            match_scope="matchScope",
                            oversize_handling="oversizeHandling"
                        ),
                        json_body=wafv2.CfnWebACL.JsonBodyProperty(
                            match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                all=all,
                                included_paths=["includedPaths"]
                            ),
                            match_scope="matchScope",
                
                            # the properties below are optional
                            invalid_fallback_behavior="invalidFallbackBehavior",
                            oversize_handling="oversizeHandling"
                        ),
                        method=method,
                        query_string=query_string,
                        single_header=single_header,
                        single_query_argument=single_query_argument,
                        uri_path=uri_path
                    ),
                    positional_constraint="positionalConstraint",
                    text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                        priority=123,
                        type="type"
                    )],
                
                    # the properties below are optional
                    search_string="searchString",
                    search_string_base64="searchStringBase64"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7fc70dd50d5f80e9ece85a9b0acf8c406bb0f1e3ff01cae248d2138229426af7)
                check_type(argname="argument field_to_match", value=field_to_match, expected_type=type_hints["field_to_match"])
                check_type(argname="argument positional_constraint", value=positional_constraint, expected_type=type_hints["positional_constraint"])
                check_type(argname="argument text_transformations", value=text_transformations, expected_type=type_hints["text_transformations"])
                check_type(argname="argument search_string", value=search_string, expected_type=type_hints["search_string"])
                check_type(argname="argument search_string_base64", value=search_string_base64, expected_type=type_hints["search_string_base64"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "field_to_match": field_to_match,
                "positional_constraint": positional_constraint,
                "text_transformations": text_transformations,
            }
            if search_string is not None:
                self._values["search_string"] = search_string
            if search_string_base64 is not None:
                self._values["search_string_base64"] = search_string_base64

        @builtins.property
        def field_to_match(
            self,
        ) -> typing.Union["CfnWebACL.FieldToMatchProperty", _IResolvable_a771d0ef]:
            '''The part of the web request that you want AWS WAF to inspect.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-fieldtomatch
            '''
            result = self._values.get("field_to_match")
            assert result is not None, "Required property 'field_to_match' is missing"
            return typing.cast(typing.Union["CfnWebACL.FieldToMatchProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def positional_constraint(self) -> builtins.str:
            '''The area within the portion of the web request that you want AWS WAF to search for ``SearchString`` .

            Valid values include the following:

            *CONTAINS*

            The specified part of the web request must include the value of ``SearchString`` , but the location doesn't matter.

            *CONTAINS_WORD*

            The specified part of the web request must include the value of ``SearchString`` , and ``SearchString`` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, ``SearchString`` must be a word, which means that both of the following are true:

            - ``SearchString`` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and ``;BadBot`` .
            - ``SearchString`` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, ``BadBot;`` and ``-BadBot;`` .

            *EXACTLY*

            The value of the specified part of the web request must exactly match the value of ``SearchString`` .

            *STARTS_WITH*

            The value of ``SearchString`` must appear at the beginning of the specified part of the web request.

            *ENDS_WITH*

            The value of ``SearchString`` must appear at the end of the specified part of the web request.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-positionalconstraint
            '''
            result = self._values.get("positional_constraint")
            assert result is not None, "Required property 'positional_constraint' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def text_transformations(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnWebACL.TextTransformationProperty", _IResolvable_a771d0ef]]]:
            '''Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.

            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by ``FieldToMatch`` , starting from the lowest priority setting, before inspecting the content for a match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-texttransformations
            '''
            result = self._values.get("text_transformations")
            assert result is not None, "Required property 'text_transformations' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnWebACL.TextTransformationProperty", _IResolvable_a771d0ef]]], result)

        @builtins.property
        def search_string(self) -> typing.Optional[builtins.str]:
            '''A string value that you want AWS WAF to search for.

            AWS WAF searches only in the part of web requests that you designate for inspection in ``FieldToMatch`` . The maximum length of the value is 50 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.

            Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.

            For example, suppose the value of ``Type`` is ``HEADER`` and the value of ``Data`` is ``User-Agent`` . If you want to search the ``User-Agent`` header for the value ``BadBot`` , you provide the string ``BadBot`` in the value of ``SearchString`` .

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstring
            '''
            result = self._values.get("search_string")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def search_string_base64(self) -> typing.Optional[builtins.str]:
            '''String to search for in a web request component, base64-encoded.

            If you don't want to encode the string, specify the unencoded value in ``SearchString`` instead.

            You must specify either ``SearchString`` or ``SearchStringBase64`` in a ``ByteMatchStatement`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstringbase64
            '''
            result = self._values.get("search_string_base64")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ByteMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.CaptchaActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CaptchaActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies that AWS WAF should run a ``CAPTCHA`` check against the request:.

            - If the request includes a valid, unexpired ``CAPTCHA`` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` .
            - If the request doesn't include a valid, unexpired ``CAPTCHA`` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

            AWS WAF generates a response that it sends back to the client, which includes the following:

            - The header ``x-amzn-waf-action`` with a value of ``captcha`` .
            - The HTTP status code ``405 Method Not Allowed`` .
            - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a ``CAPTCHA`` challenge.

            You can configure the expiration time in the ``CaptchaConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

            This action option is available for rules. It isn't available for web ACL default actions.

            :param custom_request_handling: Defines custom handling for the web request, used when the ``CAPTCHA`` inspection determines that the request's token is valid and unexpired. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                captcha_action_property = wafv2.CfnWebACL.CaptchaActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8fa14e1410c28a206f8dc3009422fa39b049dcdd9d83a6cc8293fd6542e90978)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.CustomRequestHandlingProperty", _IResolvable_a771d0ef]]:
            '''Defines custom handling for the web request, used when the ``CAPTCHA`` inspection determines that the request's token is valid and unexpired.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaaction.html#cfn-wafv2-webacl-captchaaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.CustomRequestHandlingProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.CaptchaConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class CaptchaConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[typing.Union["CfnWebACL.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``CAPTCHA`` evaluations for rules that don't have their own ``CaptchaConfig`` settings.

            If you don't specify this, AWS WAF uses its default settings for ``CaptchaConfig`` .

            :param immunity_time_property: Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                captcha_config_property = wafv2.CfnWebACL.CaptchaConfigProperty(
                    immunity_time_property=wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8f8906d7f48189087914102fc30be5497527ca957002189aac67a730d69ddf32)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.ImmunityTimePropertyProperty", _IResolvable_a771d0ef]]:
            '''Determines how long a ``CAPTCHA`` timestamp in the token remains valid after the client successfully solves a ``CAPTCHA`` puzzle.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaconfig.html#cfn-wafv2-webacl-captchaconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.ImmunityTimePropertyProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptchaConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.ChallengeActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class ChallengeActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies that AWS WAF should run a ``Challenge`` check against the request to verify that the request is coming from a legitimate client session:  - If the request includes a valid, unexpired challenge token, AWS WAF applies any custom request handling and labels that you've configured and then allows the web request inspection to proceed to the next rule, similar to a ``CountAction`` .

            - If the request doesn't include a valid, unexpired challenge token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

            AWS WAF then generates a challenge response that it sends back to the client, which includes the following:

            - The header ``x-amzn-waf-action`` with a value of ``challenge`` .
            - The HTTP status code ``202 Request Accepted`` .
            - If the request contains an ``Accept`` header with a value of ``text/html`` , the response includes a JavaScript page interstitial with a challenge script.

            Challenges run silent browser interrogations in the background, and don't generally affect the end user experience.

            A challenge enforces token acquisition using an interstitial JavaScript challenge that inspects the client session for legitimate behavior. The challenge blocks bots or at least increases the cost of operating sophisticated bots.

            After the client session successfully responds to the challenge, it receives a new token from AWS WAF , which the challenge script uses to resubmit the original request.

            You can configure the expiration time in the ``ChallengeConfig`` ``ImmunityTimeProperty`` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

            This action option is available for rules. It isn't available for web ACL default actions.

            :param custom_request_handling: Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                challenge_action_property = wafv2.CfnWebACL.ChallengeActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f6308dac4f850a45657b3f9ba7667627fb6d98a7276132d3bd9bec085ebd21d6)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.CustomRequestHandlingProperty", _IResolvable_a771d0ef]]:
            '''Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeaction.html#cfn-wafv2-webacl-challengeaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.CustomRequestHandlingProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.ChallengeConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time_property": "immunityTimeProperty"},
    )
    class ChallengeConfigProperty:
        def __init__(
            self,
            *,
            immunity_time_property: typing.Optional[typing.Union[typing.Union["CfnWebACL.ImmunityTimePropertyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies how AWS WAF should handle ``Challenge`` evaluations.

            This is available at the web ACL level and in each rule.

            :param immunity_time_property: Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                challenge_config_property = wafv2.CfnWebACL.ChallengeConfigProperty(
                    immunity_time_property=wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                        immunity_time=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d973961c972e42731a2f8fc78fb488d44bc9dee4c8733adfbafc906b700b1ecd)
                check_type(argname="argument immunity_time_property", value=immunity_time_property, expected_type=type_hints["immunity_time_property"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if immunity_time_property is not None:
                self._values["immunity_time_property"] = immunity_time_property

        @builtins.property
        def immunity_time_property(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.ImmunityTimePropertyProperty", _IResolvable_a771d0ef]]:
            '''Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeconfig.html#cfn-wafv2-webacl-challengeconfig-immunitytimeproperty
            '''
            result = self._values.get("immunity_time_property")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.ImmunityTimePropertyProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ChallengeConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.CookieMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_cookies": "excludedCookies",
            "included_cookies": "includedCookies",
        },
    )
    class CookieMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_cookies: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": {"KeyToInclude1", "KeyToInclude2", "KeyToInclude3"} }``

            :param all: Inspect all cookies.
            :param excluded_cookies: Inspect only the cookies whose keys don't match any of the strings specified here.
            :param included_cookies: Inspect only the cookies that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookie_match_pattern_property = wafv2.CfnWebACL.CookieMatchPatternProperty(
                    all=all,
                    excluded_cookies=["excludedCookies"],
                    included_cookies=["includedCookies"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9e4286ece2b270fb9db61de1ec22db44c5761b1fb6d82b825d1283534ba629e7)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_cookies", value=excluded_cookies, expected_type=type_hints["excluded_cookies"])
                check_type(argname="argument included_cookies", value=included_cookies, expected_type=type_hints["included_cookies"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_cookies is not None:
                self._values["excluded_cookies"] = excluded_cookies
            if included_cookies is not None:
                self._values["included_cookies"] = included_cookies

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all cookies.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies whose keys don't match any of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-excludedcookies
            '''
            result = self._values.get("excluded_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_cookies(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the cookies that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-includedcookies
            '''
            result = self._values.get("included_cookies")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookieMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.CookiesProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class CookiesProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[typing.Union["CfnWebACL.CookieMatchPatternProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect the cookies in the web request.

            You can specify the parts of the cookies to inspect and you can narrow the set of cookies to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Example JSON: ``"Cookies": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` . Example JSON: ``"MatchPattern": { "IncludedCookies": {"KeyToInclude1", "KeyToInclude2", "KeyToInclude3"} }``
            :param match_scope: The parts of the cookies to inspect with the rule inspection criteria. If you specify ``All`` , AWS WAF inspects both keys and values.
            :param oversize_handling: What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the cookies normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                cookies_property = wafv2.CfnWebACL.CookiesProperty(
                    match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                        all=all,
                        excluded_cookies=["excludedCookies"],
                        included_cookies=["includedCookies"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5d5024ffeab82b88034253eb0a0e2e038d8d7287d82864381a60760647e8969c)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union["CfnWebACL.CookieMatchPatternProperty", _IResolvable_a771d0ef]:
            '''The filter to use to identify the subset of cookies to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedCookies`` , or ``ExcludedCookies`` .

            Example JSON: ``"MatchPattern": { "IncludedCookies": {"KeyToInclude1", "KeyToInclude2", "KeyToInclude3"} }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union["CfnWebACL.CookieMatchPatternProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the cookies to inspect with the rule inspection criteria.

            If you specify ``All`` , AWS WAF inspects both keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the cookies normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CookiesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.CountActionProperty",
        jsii_struct_bases=[],
        name_mapping={"custom_request_handling": "customRequestHandling"},
    )
    class CountActionProperty:
        def __init__(
            self,
            *,
            custom_request_handling: typing.Optional[typing.Union[typing.Union["CfnWebACL.CustomRequestHandlingProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies that AWS WAF should count the request. Optionally defines additional custom handling for the request.

            This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.

            :param custom_request_handling: Defines custom handling for the web request. For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-countaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                count_action_property = wafv2.CfnWebACL.CountActionProperty(
                    custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                        insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                            name="name",
                            value="value"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__992fe237f55a93e1c51916c6616a9b3caf98c7fee1ceea6e863916cb40826c83)
                check_type(argname="argument custom_request_handling", value=custom_request_handling, expected_type=type_hints["custom_request_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_request_handling is not None:
                self._values["custom_request_handling"] = custom_request_handling

        @builtins.property
        def custom_request_handling(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.CustomRequestHandlingProperty", _IResolvable_a771d0ef]]:
            '''Defines custom handling for the web request.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-countaction.html#cfn-wafv2-webacl-countaction-customrequesthandling
            '''
            result = self._values.get("custom_request_handling")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.CustomRequestHandlingProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CountActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.CustomHTTPHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "value": "value"},
    )
    class CustomHTTPHeaderProperty:
        def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
            '''A custom header for custom request and response handling.

            This is used in ``CustomResponse`` and ``CustomRequestHandling`` .

            :param name: The name of the custom header. For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .
            :param value: The value of the custom header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                custom_hTTPHeader_property = wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                    name="name",
                    value="value"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b6c857f1b53867929bd11c08043aa3c0507dea8402066141cc3fa3da3d2b0e0c)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
                "value": value,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the custom header.

            For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name ``x-amzn-waf-`` , to avoid confusion with the headers that are already in the request. For example, for the header name ``sample`` , AWS WAF inserts the header ``x-amzn-waf-sample`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html#cfn-wafv2-webacl-customhttpheader-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> builtins.str:
            '''The value of the custom header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html#cfn-wafv2-webacl-customhttpheader-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomHTTPHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.CustomRequestHandlingProperty",
        jsii_struct_bases=[],
        name_mapping={"insert_headers": "insertHeaders"},
    )
    class CustomRequestHandlingProperty:
        def __init__(
            self,
            *,
            insert_headers: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnWebACL.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        ) -> None:
            '''Custom request handling behavior that inserts custom headers into a web request.

            You can add custom request handling for AWS WAF to use when the rule action doesn't block the request. For example, ``CaptchaAction`` for requests with valid t okens, and ``AllowAction`` .

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param insert_headers: The HTTP headers to insert into the request. Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customrequesthandling.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                custom_request_handling_property = wafv2.CfnWebACL.CustomRequestHandlingProperty(
                    insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__541312ccf6ea6e8f62bd4f0345af01028fbb571a849b46208c9ebf387858b612)
                check_type(argname="argument insert_headers", value=insert_headers, expected_type=type_hints["insert_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "insert_headers": insert_headers,
            }

        @builtins.property
        def insert_headers(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnWebACL.CustomHTTPHeaderProperty", _IResolvable_a771d0ef]]]:
            '''The HTTP headers to insert into the request. Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customrequesthandling.html#cfn-wafv2-webacl-customrequesthandling-insertheaders
            '''
            result = self._values.get("insert_headers")
            assert result is not None, "Required property 'insert_headers' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnWebACL.CustomHTTPHeaderProperty", _IResolvable_a771d0ef]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomRequestHandlingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.CustomResponseBodyProperty",
        jsii_struct_bases=[],
        name_mapping={"content": "content", "content_type": "contentType"},
    )
    class CustomResponseBodyProperty:
        def __init__(
            self,
            *,
            content: builtins.str,
            content_type: builtins.str,
        ) -> None:
            '''The response body to use in a custom response to a web request.

            This is referenced by key from ``CustomResponse`` ``CustomResponseBodyKey`` .

            :param content: The payload of the custom response. You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .
            :param content_type: The type of content in the payload that you are defining in the ``Content`` string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                custom_response_body_property = wafv2.CfnWebACL.CustomResponseBodyProperty(
                    content="content",
                    content_type="contentType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3d294acdf6d004e056aa25c78bfb9c3fa0a072f87e786767c15072b2482ee564)
                check_type(argname="argument content", value=content, expected_type=type_hints["content"])
                check_type(argname="argument content_type", value=content_type, expected_type=type_hints["content_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "content": content,
                "content_type": content_type,
            }

        @builtins.property
        def content(self) -> builtins.str:
            '''The payload of the custom response.

            You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the ``ContentType`` setting.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html#cfn-wafv2-webacl-customresponsebody-content
            '''
            result = self._values.get("content")
            assert result is not None, "Required property 'content' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def content_type(self) -> builtins.str:
            '''The type of content in the payload that you are defining in the ``Content`` string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html#cfn-wafv2-webacl-customresponsebody-contenttype
            '''
            result = self._values.get("content_type")
            assert result is not None, "Required property 'content_type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.CustomResponseProperty",
        jsii_struct_bases=[],
        name_mapping={
            "response_code": "responseCode",
            "custom_response_body_key": "customResponseBodyKey",
            "response_headers": "responseHeaders",
        },
    )
    class CustomResponseProperty:
        def __init__(
            self,
            *,
            response_code: jsii.Number,
            custom_response_body_key: typing.Optional[builtins.str] = None,
            response_headers: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnWebACL.CustomHTTPHeaderProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        ) -> None:
            '''A custom response to send to the client.

            You can define a custom response for rule actions and default web ACL actions that are set to the block action.

            For information about customizing web requests and responses, see `Customizing web requests and responses in AWS WAF <https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param response_code: The HTTP status code to return to the client. For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .
            :param custom_response_body_key: References the response body that you want AWS WAF to return to the web request client. You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.
            :param response_headers: The HTTP headers to use in the response. Duplicate header names are not allowed. For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                custom_response_property = wafv2.CfnWebACL.CustomResponseProperty(
                    response_code=123,
                
                    # the properties below are optional
                    custom_response_body_key="customResponseBodyKey",
                    response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                        name="name",
                        value="value"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b8d4b29a666860780294a5d831dea7fc2e8d859d8e9e36978241789fc043ee41)
                check_type(argname="argument response_code", value=response_code, expected_type=type_hints["response_code"])
                check_type(argname="argument custom_response_body_key", value=custom_response_body_key, expected_type=type_hints["custom_response_body_key"])
                check_type(argname="argument response_headers", value=response_headers, expected_type=type_hints["response_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "response_code": response_code,
            }
            if custom_response_body_key is not None:
                self._values["custom_response_body_key"] = custom_response_body_key
            if response_headers is not None:
                self._values["response_headers"] = response_headers

        @builtins.property
        def response_code(self) -> jsii.Number:
            '''The HTTP status code to return to the client.

            For a list of status codes that you can use in your custom responses, see `Supported status codes for custom response <https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-responsecode
            '''
            result = self._values.get("response_code")
            assert result is not None, "Required property 'response_code' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def custom_response_body_key(self) -> typing.Optional[builtins.str]:
            '''References the response body that you want AWS WAF to return to the web request client.

            You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the ``CustomResponseBodies`` setting for the ``WebACL`` or ``RuleGroup`` where you want to use it. Then, in the rule action or web ACL default action ``BlockAction`` setting, you reference the response body using this key.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-customresponsebodykey
            '''
            result = self._values.get("custom_response_body_key")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def response_headers(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnWebACL.CustomHTTPHeaderProperty", _IResolvable_a771d0ef]]]]:
            '''The HTTP headers to use in the response. Duplicate header names are not allowed.

            For information about the limits on count and size for custom request and response settings, see `AWS WAF quotas <https://docs.aws.amazon.com/waf/latest/developerguide/limits.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-responseheaders
            '''
            result = self._values.get("response_headers")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnWebACL.CustomHTTPHeaderProperty", _IResolvable_a771d0ef]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomResponseProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.DefaultActionProperty",
        jsii_struct_bases=[],
        name_mapping={"allow": "allow", "block": "block"},
    )
    class DefaultActionProperty:
        def __init__(
            self,
            *,
            allow: typing.Optional[typing.Union[typing.Union["CfnWebACL.AllowActionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            block: typing.Optional[typing.Union[typing.Union["CfnWebACL.BlockActionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''In a ``WebACL`` , this is the action that you want AWS WAF to perform when a web request doesn't match any of the rules in the ``WebACL`` .

            The default action must be a terminating action.

            :param allow: Specifies that AWS WAF should allow requests by default.
            :param block: Specifies that AWS WAF should block requests by default.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                default_action_property = wafv2.CfnWebACL.DefaultActionProperty(
                    allow=wafv2.CfnWebACL.AllowActionProperty(
                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    ),
                    block=wafv2.CfnWebACL.BlockActionProperty(
                        custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                            response_code=123,
                
                            # the properties below are optional
                            custom_response_body_key="customResponseBodyKey",
                            response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                name="name",
                                value="value"
                            )]
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c395c29c5840405232325a1f9a2f3e4b143faadbee03d61aa4f2704fba296e55)
                check_type(argname="argument allow", value=allow, expected_type=type_hints["allow"])
                check_type(argname="argument block", value=block, expected_type=type_hints["block"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if allow is not None:
                self._values["allow"] = allow
            if block is not None:
                self._values["block"] = block

        @builtins.property
        def allow(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.AllowActionProperty", _IResolvable_a771d0ef]]:
            '''Specifies that AWS WAF should allow requests by default.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-allow
            '''
            result = self._values.get("allow")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.AllowActionProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def block(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.BlockActionProperty", _IResolvable_a771d0ef]]:
            '''Specifies that AWS WAF should block requests by default.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-block
            '''
            result = self._values.get("block")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.BlockActionProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DefaultActionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.ExcludedRuleProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class ExcludedRuleProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''Specifies a single rule in a rule group whose action you want to override to ``Count`` .

            .. epigraph::

               Instead of this option, use ``RuleActionOverrides`` . It accepts any valid action setting, including ``Count`` .

            :param name: The name of the rule whose action you want to override to ``Count`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                excluded_rule_property = wafv2.CfnWebACL.ExcludedRuleProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fda786d3195a3f18bbd73ee101416185acd352686a8a152b0e9d6f5ddf2aa1c7)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the rule whose action you want to override to ``Count`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html#cfn-wafv2-webacl-excludedrule-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ExcludedRuleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.FieldIdentifierProperty",
        jsii_struct_bases=[],
        name_mapping={"identifier": "identifier"},
    )
    class FieldIdentifierProperty:
        def __init__(self, *, identifier: builtins.str) -> None:
            '''The identifier of the username or password field, used in the ``ManagedRuleGroupConfig`` settings.

            :param identifier: The name of the username or password field, used in the ``ManagedRuleGroupConfig`` settings. When the ``PayloadType`` is ``JSON`` , the identifier must be in JSON pointer syntax. For example ``/form/username`` . For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . When the ``PayloadType`` is ``FORM_ENCODED`` , use the HTML form names. For example, ``username`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldidentifier.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                field_identifier_property = wafv2.CfnWebACL.FieldIdentifierProperty(
                    identifier="identifier"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3c92556632243e90416f6dbfb5ddf54a4aa3678c7768b8d4fc0a55c6b2eb583c)
                check_type(argname="argument identifier", value=identifier, expected_type=type_hints["identifier"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "identifier": identifier,
            }

        @builtins.property
        def identifier(self) -> builtins.str:
            '''The name of the username or password field, used in the ``ManagedRuleGroupConfig`` settings.

            When the ``PayloadType`` is ``JSON`` , the identifier must be in JSON pointer syntax. For example ``/form/username`` . For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            When the ``PayloadType`` is ``FORM_ENCODED`` , use the HTML form names. For example, ``username`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldidentifier.html#cfn-wafv2-webacl-fieldidentifier-identifier
            '''
            result = self._values.get("identifier")
            assert result is not None, "Required property 'identifier' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldIdentifierProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.FieldToMatchProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all_query_arguments": "allQueryArguments",
            "body": "body",
            "cookies": "cookies",
            "headers": "headers",
            "json_body": "jsonBody",
            "method": "method",
            "query_string": "queryString",
            "single_header": "singleHeader",
            "single_query_argument": "singleQueryArgument",
            "uri_path": "uriPath",
        },
    )
    class FieldToMatchProperty:
        def __init__(
            self,
            *,
            all_query_arguments: typing.Any = None,
            body: typing.Optional[typing.Union[typing.Union["CfnWebACL.BodyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            cookies: typing.Optional[typing.Union[typing.Union["CfnWebACL.CookiesProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            headers: typing.Optional[typing.Union[typing.Union["CfnWebACL.HeadersProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            json_body: typing.Optional[typing.Union[typing.Union["CfnWebACL.JsonBodyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            method: typing.Any = None,
            query_string: typing.Any = None,
            single_header: typing.Any = None,
            single_query_argument: typing.Any = None,
            uri_path: typing.Any = None,
        ) -> None:
            '''The part of the web request that you want AWS WAF to inspect.

            Include the single ``FieldToMatch`` type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in ``FieldToMatch`` for each rule statement that requires it. To inspect more than one component of the web request, create a separate rule statement for each component.

            Example JSON for a ``QueryString`` field to match:

            ``"FieldToMatch": { "QueryString": {} }``

            Example JSON for a ``Method`` field to match specification:

            ``"FieldToMatch": { "Method": { "Name": "DELETE" } }``

            :param all_query_arguments: Inspect all query arguments.
            :param body: Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the ``Body`` object configuration.
            :param cookies: Inspect the request cookies. You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
            :param headers: Inspect the request headers. You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects. Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
            :param json_body: Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form. Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.
            :param method: Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
            :param query_string: Inspect the query string. This is the part of a URL that appears after a ``?`` character, if any.
            :param single_header: Inspect a single header. Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive. Example JSON: ``"SingleHeader": { "Name": "haystack" }`` Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.
            :param single_query_argument: Inspect a single query argument. Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive. Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``
            :param uri_path: Inspect the request URI path. This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # uri_path: Any
                
                field_to_match_property = wafv2.CfnWebACL.FieldToMatchProperty(
                    all_query_arguments=all_query_arguments,
                    body=wafv2.CfnWebACL.BodyProperty(
                        oversize_handling="oversizeHandling"
                    ),
                    cookies=wafv2.CfnWebACL.CookiesProperty(
                        match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                            all=all,
                            excluded_cookies=["excludedCookies"],
                            included_cookies=["includedCookies"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    headers=wafv2.CfnWebACL.HeadersProperty(
                        match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                            all=all,
                            excluded_headers=["excludedHeaders"],
                            included_headers=["includedHeaders"]
                        ),
                        match_scope="matchScope",
                        oversize_handling="oversizeHandling"
                    ),
                    json_body=wafv2.CfnWebACL.JsonBodyProperty(
                        match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                            all=all,
                            included_paths=["includedPaths"]
                        ),
                        match_scope="matchScope",
                
                        # the properties below are optional
                        invalid_fallback_behavior="invalidFallbackBehavior",
                        oversize_handling="oversizeHandling"
                    ),
                    method=method,
                    query_string=query_string,
                    single_header=single_header,
                    single_query_argument=single_query_argument,
                    uri_path=uri_path
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7460211572678dbce46cb3d2161444512909e5cc4498f2dd036980d63e79acd5)
                check_type(argname="argument all_query_arguments", value=all_query_arguments, expected_type=type_hints["all_query_arguments"])
                check_type(argname="argument body", value=body, expected_type=type_hints["body"])
                check_type(argname="argument cookies", value=cookies, expected_type=type_hints["cookies"])
                check_type(argname="argument headers", value=headers, expected_type=type_hints["headers"])
                check_type(argname="argument json_body", value=json_body, expected_type=type_hints["json_body"])
                check_type(argname="argument method", value=method, expected_type=type_hints["method"])
                check_type(argname="argument query_string", value=query_string, expected_type=type_hints["query_string"])
                check_type(argname="argument single_header", value=single_header, expected_type=type_hints["single_header"])
                check_type(argname="argument single_query_argument", value=single_query_argument, expected_type=type_hints["single_query_argument"])
                check_type(argname="argument uri_path", value=uri_path, expected_type=type_hints["uri_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all_query_arguments is not None:
                self._values["all_query_arguments"] = all_query_arguments
            if body is not None:
                self._values["body"] = body
            if cookies is not None:
                self._values["cookies"] = cookies
            if headers is not None:
                self._values["headers"] = headers
            if json_body is not None:
                self._values["json_body"] = json_body
            if method is not None:
                self._values["method"] = method
            if query_string is not None:
                self._values["query_string"] = query_string
            if single_header is not None:
                self._values["single_header"] = single_header
            if single_query_argument is not None:
                self._values["single_query_argument"] = single_query_argument
            if uri_path is not None:
                self._values["uri_path"] = uri_path

        @builtins.property
        def all_query_arguments(self) -> typing.Any:
            '''Inspect all query arguments.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-allqueryarguments
            '''
            result = self._values.get("all_query_arguments")
            return typing.cast(typing.Any, result)

        @builtins.property
        def body(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.BodyProperty", _IResolvable_a771d0ef]]:
            '''Inspect the request body as plain text.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the ``Body`` object configuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-body
            '''
            result = self._values.get("body")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.BodyProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def cookies(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.CookiesProperty", _IResolvable_a771d0ef]]:
            '''Inspect the request cookies.

            You must configure scope and pattern matching filters in the ``Cookies`` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the ``Cookies`` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-cookies
            '''
            result = self._values.get("cookies")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.CookiesProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def headers(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.HeadersProperty", _IResolvable_a771d0ef]]:
            '''Inspect the request headers.

            You must configure scope and pattern matching filters in the ``Headers`` object, to define the set of headers to and the parts of the headers that AWS WAF inspects.

            Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the ``Headers`` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-headers
            '''
            result = self._values.get("headers")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.HeadersProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def json_body(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.JsonBodyProperty", _IResolvable_a771d0ef]]:
            '''Inspect the request body as JSON.

            The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

            Only the first 8 KB (8192 bytes) of the request body are forwarded to AWS WAF for inspection by the underlying host service. For information about how to handle oversized request bodies, see the ``JsonBody`` object configuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-jsonbody
            '''
            result = self._values.get("json_body")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.JsonBodyProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def method(self) -> typing.Any:
            '''Inspect the HTTP method.

            The method indicates the type of operation that the request is asking the origin to perform.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-method
            '''
            result = self._values.get("method")
            return typing.cast(typing.Any, result)

        @builtins.property
        def query_string(self) -> typing.Any:
            '''Inspect the query string.

            This is the part of a URL that appears after a ``?`` character, if any.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-querystring
            '''
            result = self._values.get("query_string")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_header(self) -> typing.Any:
            '''Inspect a single header.

            Provide the name of the header to inspect, for example, ``User-Agent`` or ``Referer`` . This setting isn't case sensitive.

            Example JSON: ``"SingleHeader": { "Name": "haystack" }``

            Alternately, you can filter and inspect all headers with the ``Headers`` ``FieldToMatch`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singleheader
            '''
            result = self._values.get("single_header")
            return typing.cast(typing.Any, result)

        @builtins.property
        def single_query_argument(self) -> typing.Any:
            '''Inspect a single query argument.

            Provide the name of the query argument to inspect, such as *UserName* or *SalesRegion* . The name can be up to 30 characters long and isn't case sensitive.

            Example JSON: ``"SingleQueryArgument": { "Name": "myArgument" }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singlequeryargument
            '''
            result = self._values.get("single_query_argument")
            return typing.cast(typing.Any, result)

        @builtins.property
        def uri_path(self) -> typing.Any:
            '''Inspect the request URI path.

            This is the part of the web request that identifies a resource, for example, ``/images/daily-ad.jpg`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-uripath
            '''
            result = self._values.get("uri_path")
            return typing.cast(typing.Any, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FieldToMatchProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.ForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
        },
    )
    class ForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used for ``GeoMatchStatement`` and ``RateBasedStatement`` . For ``IPSetReferenceStatement`` , use ``IPSetForwardedIPConfig`` instead.

            AWS WAF only evaluates the first IP address found in the specified HTTP header.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                forwarded_iPConfiguration_property = wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                    fallback_behavior="fallbackBehavior",
                    header_name="headerName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9b13d2036740003ef57380b12fd5b82c5eb02f8ddf8627a26123e443b22cad05)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html#cfn-wafv2-webacl-forwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html#cfn-wafv2-webacl-forwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.GeoMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "country_codes": "countryCodes",
            "forwarded_ip_config": "forwardedIpConfig",
        },
    )
    class GeoMatchStatementProperty:
        def __init__(
            self,
            *,
            country_codes: typing.Optional[typing.Sequence[builtins.str]] = None,
            forwarded_ip_config: typing.Optional[typing.Union[typing.Union["CfnWebACL.ForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''A rule statement that labels web requests by country and region and that matches against web requests based on country code.

            A geo match rule labels every request that it inspects regardless of whether it finds a match.

            - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the ``CountryCodes`` array.
            - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.

            AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match ``ForwardedIPConfig`` .

            If you use the web request origin, the label formats are ``awswaf:clientip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:clientip:geo:country:<ISO country code>`` .

            If you use a forwarded IP address, the label formats are ``awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>`` and ``awswaf:forwardedip:geo:country:<ISO country code>`` .

            For additional details, see `Geographic match rule statement <https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html>`_ in the `AWS WAF Developer Guide <https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html>`_ .

            :param country_codes: An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard. When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
            :param forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                geo_match_statement_property = wafv2.CfnWebACL.GeoMatchStatementProperty(
                    country_codes=["countryCodes"],
                    forwarded_ip_config=wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                        fallback_behavior="fallbackBehavior",
                        header_name="headerName"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__13c05afeb1d04d31be3cf453882998f2098b8b2b865b1514b30fcb3b6c95dd4f)
                check_type(argname="argument country_codes", value=country_codes, expected_type=type_hints["country_codes"])
                check_type(argname="argument forwarded_ip_config", value=forwarded_ip_config, expected_type=type_hints["forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if country_codes is not None:
                self._values["country_codes"] = country_codes
            if forwarded_ip_config is not None:
                self._values["forwarded_ip_config"] = forwarded_ip_config

        @builtins.property
        def country_codes(self) -> typing.Optional[typing.List[builtins.str]]:
            '''An array of two-character country codes that you want to match against, for example, ``[ "US", "CN" ]`` , from the alpha-2 country ISO codes of the ISO 3166 international standard.

            When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html#cfn-wafv2-webacl-geomatchstatement-countrycodes
            '''
            result = self._values.get("country_codes")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.ForwardedIPConfigurationProperty", _IResolvable_a771d0ef]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html#cfn-wafv2-webacl-geomatchstatement-forwardedipconfig
            '''
            result = self._values.get("forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.ForwardedIPConfigurationProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "GeoMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.HeaderMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={
            "all": "all",
            "excluded_headers": "excludedHeaders",
            "included_headers": "includedHeaders",
        },
    )
    class HeaderMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            excluded_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            included_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }``

            :param all: Inspect all headers.
            :param excluded_headers: Inspect only the headers whose keys don't match any of the strings specified here.
            :param included_headers: Inspect only the headers that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                header_match_pattern_property = wafv2.CfnWebACL.HeaderMatchPatternProperty(
                    all=all,
                    excluded_headers=["excludedHeaders"],
                    included_headers=["includedHeaders"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__06059bf872340e1c5f77d786ea93aec5cdf7d8ed7f6f178fc7fea014b88bc404)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument excluded_headers", value=excluded_headers, expected_type=type_hints["excluded_headers"])
                check_type(argname="argument included_headers", value=included_headers, expected_type=type_hints["included_headers"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if excluded_headers is not None:
                self._values["excluded_headers"] = excluded_headers
            if included_headers is not None:
                self._values["included_headers"] = included_headers

        @builtins.property
        def all(self) -> typing.Any:
            '''Inspect all headers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def excluded_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers whose keys don't match any of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-excludedheaders
            '''
            result = self._values.get("excluded_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def included_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Inspect only the headers that have a key that matches one of the strings specified here.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-includedheaders
            '''
            result = self._values.get("included_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeaderMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.HeadersProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "oversize_handling": "oversizeHandling",
        },
    )
    class HeadersProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[typing.Union["CfnWebACL.HeaderMatchPatternProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            match_scope: builtins.str,
            oversize_handling: builtins.str,
        ) -> None:
            '''Inspect all headers in the web request.

            You can specify the parts of the headers to inspect and you can narrow the set of headers to inspect by including or excluding specific keys.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            If you want to inspect just the value of a single header, use the ``SingleHeader`` ``FieldToMatch`` setting instead.

            Example JSON: ``"Headers": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }``

            :param match_pattern: The filter to use to identify the subset of headers to inspect in a web request. You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` . Example JSON: ``"MatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }``
            :param match_scope: The parts of the headers to match with the rule inspection criteria. If you specify ``All`` , AWS WAF inspects both keys and values.
            :param oversize_handling: What AWS WAF should do if the headers of the request are larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF . The options for oversize handling are the following: - ``CONTINUE`` - Inspect the headers normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                headers_property = wafv2.CfnWebACL.HeadersProperty(
                    match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                        all=all,
                        excluded_headers=["excludedHeaders"],
                        included_headers=["includedHeaders"]
                    ),
                    match_scope="matchScope",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d3a183b6fee810812b3f284c0b4dfcc51d5d0e80de3527fe7111de136c3ee43f)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
                "oversize_handling": oversize_handling,
            }

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union["CfnWebACL.HeaderMatchPatternProperty", _IResolvable_a771d0ef]:
            '''The filter to use to identify the subset of headers to inspect in a web request.

            You must specify exactly one setting: either ``All`` , ``IncludedHeaders`` , or ``ExcludedHeaders`` .

            Example JSON: ``"MatchPattern": { "ExcludedHeaders": {"KeyToExclude1", "KeyToExclude2"} }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union["CfnWebACL.HeaderMatchPatternProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the headers to match with the rule inspection criteria.

            If you specify ``All`` , AWS WAF inspects both keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def oversize_handling(self) -> builtins.str:
            '''What AWS WAF should do if the headers of the request are larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the headers normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            assert result is not None, "Required property 'oversize_handling' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HeadersProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.IPSetForwardedIPConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "fallback_behavior": "fallbackBehavior",
            "header_name": "headerName",
            "position": "position",
        },
    )
    class IPSetForwardedIPConfigurationProperty:
        def __init__(
            self,
            *,
            fallback_behavior: builtins.str,
            header_name: builtins.str,
            position: builtins.str,
        ) -> None:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            This configuration is used only for ``IPSetReferenceStatement`` . For ``GeoMatchStatement`` and ``RateBasedStatement`` , use ``ForwardedIPConfig`` instead.

            :param fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. You can specify the following fallback behaviors: - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement.
            :param header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` . .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
            :param position: The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through. The options for this setting are the following: - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP. - LAST - Inspect the last IP address in the list of IP addresses in the header. - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                i_pSet_forwarded_iPConfiguration_property = {
                    "fallback_behavior": "fallbackBehavior",
                    "header_name": "headerName",
                    "position": "position"
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a0a56b5a0e9a5d1aeb0eca81f40f540bd33613dbf85364979cb3dbd7a6084270)
                check_type(argname="argument fallback_behavior", value=fallback_behavior, expected_type=type_hints["fallback_behavior"])
                check_type(argname="argument header_name", value=header_name, expected_type=type_hints["header_name"])
                check_type(argname="argument position", value=position, expected_type=type_hints["position"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "fallback_behavior": fallback_behavior,
                "header_name": header_name,
                "position": position,
            }

        @builtins.property
        def fallback_behavior(self) -> builtins.str:
            '''The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            You can specify the following fallback behaviors:

            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-fallbackbehavior
            '''
            result = self._values.get("fallback_behavior")
            assert result is not None, "Required property 'fallback_behavior' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def header_name(self) -> builtins.str:
            '''The name of the HTTP header to use for the IP address.

            For example, to use the X-Forwarded-For (XFF) header, set this to ``X-Forwarded-For`` .
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-headername
            '''
            result = self._values.get("header_name")
            assert result is not None, "Required property 'header_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def position(self) -> builtins.str:
            '''The position in the header to search for the IP address.

            The header can contain IP addresses of the original client and also of proxies. For example, the header value could be ``10.1.1.1, 127.0.0.0, 10.10.10.10`` where the first IP address identifies the original client and the rest identify proxies that the request went through.

            The options for this setting are the following:

            - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.
            - LAST - Inspect the last IP address in the list of IP addresses in the header.
            - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-position
            '''
            result = self._values.get("position")
            assert result is not None, "Required property 'position' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetForwardedIPConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.IPSetReferenceStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arn": "arn",
            "ip_set_forwarded_ip_config": "ipSetForwardedIpConfig",
        },
    )
    class IPSetReferenceStatementProperty:
        def __init__(
            self,
            *,
            arn: builtins.str,
            ip_set_forwarded_ip_config: typing.Optional[typing.Union[typing.Union["CfnWebACL.IPSetForwardedIPConfigurationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''A rule statement used to detect web requests coming from particular IP addresses or address ranges.

            To use this, create an ``IPSet`` that specifies the addresses you want to detect, then use the ARN of that set in this statement.

            Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.

            :param arn: The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.
            :param ip_set_forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name. .. epigraph:: If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                i_pSet_reference_statement_property = {
                    "arn": "arn",
                
                    # the properties below are optional
                    "ip_set_forwarded_ip_config": {
                        "fallback_behavior": "fallbackBehavior",
                        "header_name": "headerName",
                        "position": "position"
                    }
                }
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bbd6a5b5ae3698a90568b446774b934409c34342317b67b4b1c7e57522c19dc2)
                check_type(argname="argument arn", value=arn, expected_type=type_hints["arn"])
                check_type(argname="argument ip_set_forwarded_ip_config", value=ip_set_forwarded_ip_config, expected_type=type_hints["ip_set_forwarded_ip_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "arn": arn,
            }
            if ip_set_forwarded_ip_config is not None:
                self._values["ip_set_forwarded_ip_config"] = ip_set_forwarded_ip_config

        @builtins.property
        def arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of the ``IPSet`` that this statement references.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html#cfn-wafv2-webacl-ipsetreferencestatement-arn
            '''
            result = self._values.get("arn")
            assert result is not None, "Required property 'arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def ip_set_forwarded_ip_config(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.IPSetForwardedIPConfigurationProperty", _IResolvable_a771d0ef]]:
            '''The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.

            Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
            .. epigraph::

               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html#cfn-wafv2-webacl-ipsetreferencestatement-ipsetforwardedipconfig
            '''
            result = self._values.get("ip_set_forwarded_ip_config")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.IPSetForwardedIPConfigurationProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "IPSetReferenceStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.ImmunityTimePropertyProperty",
        jsii_struct_bases=[],
        name_mapping={"immunity_time": "immunityTime"},
    )
    class ImmunityTimePropertyProperty:
        def __init__(self, *, immunity_time: jsii.Number) -> None:
            '''Used for CAPTCHA and challenge token settings.

            Determines how long a ``CAPTCHA`` or challenge timestamp remains valid after AWS WAF updates it for a successful ``CAPTCHA`` or challenge response.

            :param immunity_time: The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF . The default setting is 300. For the Challenge action, the minimum setting is 300.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-immunitytimeproperty.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                immunity_time_property_property = wafv2.CfnWebACL.ImmunityTimePropertyProperty(
                    immunity_time=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__197c43517b9a92f1b4e2386901aa9862c6c5cfe4aa5fdfd482c0d55794f8674a)
                check_type(argname="argument immunity_time", value=immunity_time, expected_type=type_hints["immunity_time"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "immunity_time": immunity_time,
            }

        @builtins.property
        def immunity_time(self) -> jsii.Number:
            '''The amount of time, in seconds, that a ``CAPTCHA`` or challenge timestamp is considered valid by AWS WAF .

            The default setting is 300.

            For the Challenge action, the minimum setting is 300.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-immunitytimeproperty.html#cfn-wafv2-webacl-immunitytimeproperty-immunitytime
            '''
            result = self._values.get("immunity_time")
            assert result is not None, "Required property 'immunity_time' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ImmunityTimePropertyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.JsonBodyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "match_pattern": "matchPattern",
            "match_scope": "matchScope",
            "invalid_fallback_behavior": "invalidFallbackBehavior",
            "oversize_handling": "oversizeHandling",
        },
    )
    class JsonBodyProperty:
        def __init__(
            self,
            *,
            match_pattern: typing.Union[typing.Union["CfnWebACL.JsonMatchPatternProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            match_scope: builtins.str,
            invalid_fallback_behavior: typing.Optional[builtins.str] = None,
            oversize_handling: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Inspect the body of the web request as JSON. The body immediately follows the request headers.

            This is used to indicate the web request component to inspect, in the ``FieldToMatch`` specification.

            Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule's inspection criteria. AWS WAF inspects only the parts of the JSON that result from the matches that you indicate.

            Example JSON: ``"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }``

            :param match_pattern: The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
            :param match_scope: The parts of the JSON to match against using the ``MatchPattern`` . If you specify ``All`` , AWS WAF matches against keys and values.
            :param invalid_fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:. - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters. AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array. AWS WAF parses the JSON in the following examples as two valid key, value pairs: - Missing comma: ``{"key1":"value1""key2":"value2"}`` - Missing colon: ``{"key1":"value1","key2""value2"}`` - Extra colons: ``{"key1"::"value1","key2""value2"}``
            :param oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service. The options for oversize handling are the following: - ``CONTINUE`` - Inspect the body normally, according to the rule inspection criteria. - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request. - ``NO_MATCH`` - Treat the web request as not matching the rule statement. You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB. Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_body_property = wafv2.CfnWebACL.JsonBodyProperty(
                    match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                        all=all,
                        included_paths=["includedPaths"]
                    ),
                    match_scope="matchScope",
                
                    # the properties below are optional
                    invalid_fallback_behavior="invalidFallbackBehavior",
                    oversize_handling="oversizeHandling"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__90b2f0e4438e43ab298148453903d4bba95b5a782bbe4b512f1fa58a21899616)
                check_type(argname="argument match_pattern", value=match_pattern, expected_type=type_hints["match_pattern"])
                check_type(argname="argument match_scope", value=match_scope, expected_type=type_hints["match_scope"])
                check_type(argname="argument invalid_fallback_behavior", value=invalid_fallback_behavior, expected_type=type_hints["invalid_fallback_behavior"])
                check_type(argname="argument oversize_handling", value=oversize_handling, expected_type=type_hints["oversize_handling"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "match_pattern": match_pattern,
                "match_scope": match_scope,
            }
            if invalid_fallback_behavior is not None:
                self._values["invalid_fallback_behavior"] = invalid_fallback_behavior
            if oversize_handling is not None:
                self._values["oversize_handling"] = oversize_handling

        @builtins.property
        def match_pattern(
            self,
        ) -> typing.Union["CfnWebACL.JsonMatchPatternProperty", _IResolvable_a771d0ef]:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-matchpattern
            '''
            result = self._values.get("match_pattern")
            assert result is not None, "Required property 'match_pattern' is missing"
            return typing.cast(typing.Union["CfnWebACL.JsonMatchPatternProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def match_scope(self) -> builtins.str:
            '''The parts of the JSON to match against using the ``MatchPattern`` .

            If you specify ``All`` , AWS WAF matches against keys and values.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-matchscope
            '''
            result = self._values.get("match_scope")
            assert result is not None, "Required property 'match_scope' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def invalid_fallback_behavior(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.

            - ``EVALUATE_AS_STRING`` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.

            AWS WAF does its best to parse the entire JSON body, but might be forced to stop for reasons such as invalid characters, duplicate keys, truncation, and any content whose root node isn't an object or an array.

            AWS WAF parses the JSON in the following examples as two valid key, value pairs:

            - Missing comma: ``{"key1":"value1""key2":"value2"}``
            - Missing colon: ``{"key1":"value1","key2""value2"}``
            - Extra colons: ``{"key1"::"value1","key2""value2"}``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-invalidfallbackbehavior
            '''
            result = self._values.get("invalid_fallback_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def oversize_handling(self) -> typing.Optional[builtins.str]:
            '''What AWS WAF should do if the body is larger than AWS WAF can inspect.

            AWS WAF does not support inspecting the entire contents of the body of a web request when the body exceeds 8 KB (8192 bytes). Only the first 8 KB of the request body are forwarded to AWS WAF by the underlying host service.

            The options for oversize handling are the following:

            - ``CONTINUE`` - Inspect the body normally, according to the rule inspection criteria.
            - ``MATCH`` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
            - ``NO_MATCH`` - Treat the web request as not matching the rule statement.

            You can combine the ``MATCH`` or ``NO_MATCH`` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over 8 KB.

            Default: ``CONTINUE``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-oversizehandling
            '''
            result = self._values.get("oversize_handling")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonBodyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.JsonMatchPatternProperty",
        jsii_struct_bases=[],
        name_mapping={"all": "all", "included_paths": "includedPaths"},
    )
    class JsonMatchPatternProperty:
        def __init__(
            self,
            *,
            all: typing.Any = None,
            included_paths: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''The patterns to look for in the JSON body.

            AWS WAF inspects the results of these pattern matches against the rule inspection criteria. This is used with the ``FieldToMatch`` option ``JsonBody`` .

            :param all: Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. You must specify either this setting or the ``IncludedPaths`` setting, but not both.
            :param included_paths: Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification. Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ . You must specify either this setting or the ``All`` setting, but not both. .. epigraph:: Don't use this option to include all paths. Instead, use the ``All`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                
                json_match_pattern_property = wafv2.CfnWebACL.JsonMatchPatternProperty(
                    all=all,
                    included_paths=["includedPaths"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__99452aaa3eca1ec3b9741dfbde2ba058314fb7072b4983117bae466fd86908d4)
                check_type(argname="argument all", value=all, expected_type=type_hints["all"])
                check_type(argname="argument included_paths", value=included_paths, expected_type=type_hints["included_paths"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if all is not None:
                self._values["all"] = all
            if included_paths is not None:
                self._values["included_paths"] = included_paths

        @builtins.property
        def all(self) -> typing.Any:
            '''Match all of the elements. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            You must specify either this setting or the ``IncludedPaths`` setting, but not both.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html#cfn-wafv2-webacl-jsonmatchpattern-all
            '''
            result = self._values.get("all")
            return typing.cast(typing.Any, result)

        @builtins.property
        def included_paths(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Match only the specified include paths. See also ``MatchScope`` in the ``JsonBody`` ``FieldToMatch`` specification.

            Provide the include paths using JSON Pointer syntax. For example, ``"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]`` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation `JavaScript Object Notation (JSON) Pointer <https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901>`_ .

            You must specify either this setting or the ``All`` setting, but not both.
            .. epigraph::

               Don't use this option to include all paths. Instead, use the ``All`` setting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html#cfn-wafv2-webacl-jsonmatchpattern-includedpaths
            '''
            result = self._values.get("included_paths")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonMatchPatternProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.LabelMatchStatementProperty",
        jsii_struct_bases=[],
        name_mapping={"key": "key", "scope": "scope"},
    )
    class LabelMatchStatementProperty:
        def __init__(self, *, key: builtins.str, scope: builtins.str) -> None:
            '''A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.

            The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.

            :param key: The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:. - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name. - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates. Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .
            :param scope: Specify whether you want to match using the label name or just the namespace.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                label_match_statement_property = wafv2.CfnWebACL.LabelMatchStatementProperty(
                    key="key",
                    scope="scope"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__5b1bbb6d420dd9d25c2c174a0291b141af1c95fa062f9fc52f185ba9afe14f3b)
                check_type(argname="argument key", value=key, expected_type=type_hints["key"])
                check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "key": key,
                "scope": scope,
            }

        @builtins.property
        def key(self) -> builtins.str:
            '''The string to match against. The setting you provide for this depends on the match statement's ``Scope`` setting:.

            - If the ``Scope`` indicates ``LABEL`` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
            - If the ``Scope`` indicates ``NAMESPACE`` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.

            Labels are case sensitive and components of a label must be separated by colon, for example ``NS1:NS2:name`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html#cfn-wafv2-webacl-labelmatchstatement-key
            '''
            result = self._values.get("key")
            assert result is not None, "Required property 'key' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def scope(self) -> builtins.str:
            '''Specify whether you want to match using the label name or just the namespace.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html#cfn-wafv2-webacl-labelmatchstatement-scope
            '''
            result = self._values.get("scope")
            assert result is not None, "Required property 'scope' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelMatchStatementProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.LabelProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name"},
    )
    class LabelProperty:
        def __init__(self, *, name: builtins.str) -> None:
            '''A single label container.

            This is used as an element of a label array in ``RuleLabels`` inside a rule.

            :param name: The label string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-label.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                label_property = wafv2.CfnWebACL.LabelProperty(
                    name="name"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__26fe734c3240bb0db814429969083d92a0abd196738e9795c251387b933f9ffd)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }

        @builtins.property
        def name(self) -> builtins.str:
            '''The label string.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-label.html#cfn-wafv2-webacl-label-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "LabelProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.ManagedRuleGroupConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "aws_managed_rules_bot_control_rule_set": "awsManagedRulesBotControlRuleSet",
            "login_path": "loginPath",
            "password_field": "passwordField",
            "payload_type": "payloadType",
            "username_field": "usernameField",
        },
    )
    class ManagedRuleGroupConfigProperty:
        def __init__(
            self,
            *,
            aws_managed_rules_bot_control_rule_set: typing.Optional[typing.Union[typing.Union["CfnWebACL.AWSManagedRulesBotControlRuleSetProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            login_path: typing.Optional[builtins.str] = None,
            password_field: typing.Optional[typing.Union[typing.Union["CfnWebACL.FieldIdentifierProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            payload_type: typing.Optional[builtins.str] = None,
            username_field: typing.Optional[typing.Union[typing.Union["CfnWebACL.FieldIdentifierProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Additional information that's used by a managed rule group. Many managed rule groups don't require this.

            Use the ``AWSManagedRulesBotControlRuleSet`` configuration object to configure the protection level that you want the Bot Control rule group to use.

            :param aws_managed_rules_bot_control_rule_set: Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ and `AWS WAF Bot Control <https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html>`_ in the *AWS WAF Developer Guide* .
            :param login_path: The path of the login endpoint for your application. For example, for the URL ``https://example.com/web/login`` , you would provide the path ``/web/login`` .
            :param password_field: Details about your login page password field.
            :param payload_type: The payload type for your login endpoint, either JSON or form encoded.
            :param username_field: Details about your login page username field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                managed_rule_group_config_property = wafv2.CfnWebACL.ManagedRuleGroupConfigProperty(
                    aws_managed_rules_bot_control_rule_set=wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty(
                        inspection_level="inspectionLevel"
                    ),
                    login_path="loginPath",
                    password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                        identifier="identifier"
                    ),
                    payload_type="payloadType",
                    username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                        identifier="identifier"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__773f60ee4a167fc1c95d6db4f552746dd64a0202d550d16800afcf0d5e0448c3)
                check_type(argname="argument aws_managed_rules_bot_control_rule_set", value=aws_managed_rules_bot_control_rule_set, expected_type=type_hints["aws_managed_rules_bot_control_rule_set"])
                check_type(argname="argument login_path", value=login_path, expected_type=type_hints["login_path"])
                check_type(argname="argument password_field", value=password_field, expected_type=type_hints["password_field"])
                check_type(argname="argument payload_type", value=payload_type, expected_type=type_hints["payload_type"])
                check_type(argname="argument username_field", value=username_field, expected_type=type_hints["username_field"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if aws_managed_rules_bot_control_rule_set is not None:
                self._values["aws_managed_rules_bot_control_rule_set"] = aws_managed_rules_bot_control_rule_set
            if login_path is not None:
                self._values["login_path"] = login_path
            if password_field is not None:
                self._values["password_field"] = password_field
            if payload_type is not None:
                self._values["payload_type"] = payload_type
            if username_field is not None:
                self._values["username_field"] = username_field

        @builtins.property
        def aws_managed_rules_bot_control_rule_set(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.AWSManagedRulesBotControlRuleSetProperty", _IResolvable_a771d0ef]]:
            '''Additional configuration for using the Bot Control managed rule group.

            Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see `AWS WAF Bot Control rule group <https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html>`_ and `AWS WAF Bot Control <https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html>`_ in the *AWS WAF Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesbotcontrolruleset
            '''
            result = self._values.get("aws_managed_rules_bot_control_rule_set")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.AWSManagedRulesBotControlRuleSetProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def login_path(self) -> typing.Optional[builtins.str]:
            '''The path of the login endpoint for your application.

            For example, for the URL ``https://example.com/web/login`` , you would provide the path ``/web/login`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-loginpath
            '''
            result = self._values.get("login_path")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def password_field(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.FieldIdentifierProperty", _IResolvable_a771d0ef]]:
            '''Details about your login page password field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-passwordfield
            '''
            result = self._values.get("password_field")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.FieldIdentifierProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def payload_type(self) -> typing.Optional[builtins.str]:
            '''The payload type for your login endpoint, either JSON or form encoded.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-payloadtype
            '''
            result = self._values.get("payload_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def username_field(
            self,
        ) -> typing.Optional[typing.Union["CfnWebACL.FieldIdentifierProperty", _IResolvable_a771d0ef]]:
            '''Details about your login page username field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-usernamefield
            '''
            result = self._values.get("username_field")
            return typing.cast(typing.Optional[typing.Union["CfnWebACL.FieldIdentifierProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ManagedRuleGroupConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_wafv2.CfnWebACL.ManagedRuleGroupStatementProperty",
        jsii_struct_bases=[],
        name_mapping={
            "name": "name",
            "vendor_name": "vendorName",
            "excluded_rules": "excludedRules",
            "managed_rule_group_configs": "managedRuleGroupConfigs",
            "rule_action_overrides": "ruleActionOverrides",
            "scope_down_statement": "scopeDownStatement",
            "version": "version",
        },
    )
    class ManagedRuleGroupStatementProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            vendor_name: builtins.str,
            excluded_rules: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnWebACL.ExcludedRuleProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
            managed_rule_group_configs: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnWebACL.ManagedRuleGroupConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
            rule_action_overrides: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnWebACL.RuleActionOverrideProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
            scope_down_statement: typing.Optional[typing.Union[typing.Union["CfnWebACL.StatementProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            version: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A rule statement used to run the rules that are defined in a managed rule group.

            To use this, provide the vendor name and the name of the rule group in this statement.

            You cannot nest a ``ManagedRuleGroupStatement`` , for example for use inside a ``NotStatement`` or ``OrStatement`` . It can only be referenced as a top-level statement within a rule.

            :param name: The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
            :param vendor_name: The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.
            :param excluded_rules: Rules in the referenced rule group whose actions are set to ``Count`` . .. epigraph:: Instead of this option, use ``RuleActionOverrides`` . It accepts any valid action setting, including ``Count`` .
            :param managed_rule_group_configs: Additional information that's used by a managed rule group. Many managed rule groups don't require this. Use the ``AWSManagedRulesBotControlRuleSet`` configuration object to configure the protection level that you want the Bot Control rule group to use.
            :param rule_action_overrides: Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. You can use overrides for testing, for example you can override all of rule actions to ``Count`` and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.
            :param scope_down_statement: An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group. Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable ``Statement`` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
            :param version: The version of the managed rule group to use. If you specify this, the version setting is fixed until you change it. If you don't specify this, AWS WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_wafv2 as wafv2
                
                # all: Any
                # all_query_arguments: Any
                # method: Any
                # query_string: Any
                # single_header: Any
                # single_query_argument: Any
                # statement_property_: wafv2.CfnWebACL.StatementProperty
                # uri_path: Any
                
                managed_rule_group_statement_property = wafv2.CfnWebACL.ManagedRuleGroupStatementProperty(
                    name="name",
                    vendor_name="vendorName",
                
                    # the properties below are optional
                    excluded_rules=[wafv2.CfnWebACL.ExcludedRuleProperty(
                        name="name"
                    )],
                    managed_rule_group_configs=[wafv2.CfnWebACL.ManagedRuleGroupConfigProperty(
                        aws_managed_rules_bot_control_rule_set=wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty(
                            inspection_level="inspectionLevel"
                        ),
                        login_path="loginPath",
                        password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                            identifier="identifier"
                        ),
                        payload_type="payloadType",
                        username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                            identifier="identifier"
                        )
                    )],
                    rule_action_overrides=[wafv2.CfnWebACL.RuleActionOverrideProperty(
                        action_to_use=wafv2.CfnWebACL.RuleActionProperty(
                            allow=wafv2.CfnWebACL.AllowActionProperty(
                                custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                    insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                        name="name",
                                        value="value"
                                    )]
                                )
                            ),
                            block=wafv2.CfnWebACL.BlockActionProperty(
                                custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                                    response_code=123,
                
                                    # the properties below are optional
                                    custom_response_body_key="customResponseBodyKey",
                                    response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                        name="name",
                                        value="value"
                                    )]
                                )
                            ),
                            captcha=wafv2.CfnWebACL.CaptchaActionProperty(
                                custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                    insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                        name="name",
                                        value="value"
                                    )]
                                )
                            ),
                            challenge=wafv2.CfnWebACL.ChallengeActionProperty(
                                custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                    insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                        name="name",
                                        value="value"
                                    )]
                                )
                            ),
                            count=wafv2.CfnWebACL.CountActionProperty(
                                custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                    insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                        name="name",
                                        value="value"
                                    )]
                                )
                            )
                        ),
                        name="name"
                    )],
                    scope_down_statement=wafv2.CfnWebACL.StatementProperty(
                        and_statement=wafv2.CfnWebACL.AndStatementProperty(
                            statements=[statement_property_]
                        ),
                        byte_match_statement=wafv2.CfnWebACL.ByteMatchStatementProperty(
                            field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnWebACL.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnWebACL.CookiesProperty(
                                    match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnWebACL.HeadersProperty(
                                    match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["includedHeaders"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                json_body=wafv2.CfnWebACL.JsonBodyProperty(
                                    match_pattern=wafv2.CfnWebACL.JsonMatchPatternProperty(
                                        all=all,
                                        included_paths=["includedPaths"]
                                    ),
                                    match_scope="matchScope",
                
                                    # the properties below are optional
                                    invalid_fallback_behavior="invalidFallbackBehavior",
                                    oversize_handling="oversizeHandling"
                                ),
                                method=method,
                                query_string=query_string,
                                single_header=single_header,
                                single_query_argument=single_query_argument,
                                uri_path=uri_path
                            ),
                            positional_constraint="positionalConstraint",
                            text_transformations=[wafv2.CfnWebACL.TextTransformationProperty(
                                priority=123,
                                type="type"
                            )],
                
                            # the properties below are optional
                            search_string="searchString",
                            search_string_base64="searchStringBase64"
                        ),
                        geo_match_statement=wafv2.CfnWebACL.GeoMatchStatementProperty(
                            country_codes=["countryCodes"],
                            forwarded_ip_config=wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            )
                        ),
                        ip_set_reference_statement={
                            "arn": "arn",
                
                            # the properties below are optional
                            "ip_set_forwarded_ip_config": {
                                "fallback_behavior": "fallbackBehavior",
                                "header_name": "headerName",
                                "position": "position"
                            }
                        },
                        label_match_statement=wafv2.CfnWebACL.LabelMatchStatementProperty(
                            key="key",
                            scope="scope"
                        ),
                        managed_rule_group_statement=wafv2.CfnWebACL.ManagedRuleGroupStatementProperty(
                            name="name",
                            vendor_name="vendorName",
                
                            # the properties below are optional
                            excluded_rules=[wafv2.CfnWebACL.ExcludedRuleProperty(
                                name="name"
                            )],
                            managed_rule_group_configs=[wafv2.CfnWebACL.ManagedRuleGroupConfigProperty(
                                aws_managed_rules_bot_control_rule_set=wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty(
                                    inspection_level="inspectionLevel"
                                ),
                                login_path="loginPath",
                                password_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                    identifier="identifier"
                                ),
                                payload_type="payloadType",
                                username_field=wafv2.CfnWebACL.FieldIdentifierProperty(
                                    identifier="identifier"
                                )
                            )],
                            rule_action_overrides=[wafv2.CfnWebACL.RuleActionOverrideProperty(
                                action_to_use=wafv2.CfnWebACL.RuleActionProperty(
                                    allow=wafv2.CfnWebACL.AllowActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    block=wafv2.CfnWebACL.BlockActionProperty(
                                        custom_response=wafv2.CfnWebACL.CustomResponseProperty(
                                            response_code=123,
                
                                            # the properties below are optional
                                            custom_response_body_key="customResponseBodyKey",
                                            response_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    captcha=wafv2.CfnWebACL.CaptchaActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    challenge=wafv2.CfnWebACL.ChallengeActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    ),
                                    count=wafv2.CfnWebACL.CountActionProperty(
                                        custom_request_handling=wafv2.CfnWebACL.CustomRequestHandlingProperty(
                                            insert_headers=[wafv2.CfnWebACL.CustomHTTPHeaderProperty(
                                                name="name",
                                                value="value"
                                            )]
                                        )
                                    )
                                ),
                                name="name"
                            )],
                            scope_down_statement=statement_property_,
                            version="version"
                        ),
                        not_statement=wafv2.CfnWebACL.NotStatementProperty(
                            statement=statement_property_
                        ),
                        or_statement=wafv2.CfnWebACL.OrStatementProperty(
                            statements=[statement_property_]
                        ),
                        rate_based_statement=wafv2.CfnWebACL.RateBasedStatementProperty(
                            aggregate_key_type="aggregateKeyType",
                            limit=123,
                
                            # the properties below are optional
                            forwarded_ip_config=wafv2.CfnWebACL.ForwardedIPConfigurationProperty(
                                fallback_behavior="fallbackBehavior",
                                header_name="headerName"
                            ),
                            scope_down_statement=statement_property_
                        ),
                        regex_match_statement=wafv2.CfnWebACL.RegexMatchStatementProperty(
                            field_to_match=wafv2.CfnWebACL.FieldToMatchProperty(
                                all_query_arguments=all_query_arguments,
                                body=wafv2.CfnWebACL.BodyProperty(
                                    oversize_handling="oversizeHandling"
                                ),
                                cookies=wafv2.CfnWebACL.CookiesProperty(
                                    match_pattern=wafv2.CfnWebACL.CookieMatchPatternProperty(
                                        all=all,
                                        excluded_cookies=["excludedCookies"],
                                        included_cookies=["includedCookies"]
                                    ),
                                    match_scope="matchScope",
                                    oversize_handling="oversizeHandling"
                                ),
                                headers=wafv2.CfnWebACL.HeadersProperty(
                                    match_pattern=wafv2.CfnWebACL.HeaderMatchPatternProperty(
                                        all=all,
                                        excluded_headers=["excludedHeaders"],
                                        included_headers=["inclu