'''
# Amazon SageMaker Construct Library

This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.

```python
import monocdk as sagemaker
```

<!--BEGIN CFNONLY DISCLAIMER-->

There are no official hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet. Here are some suggestions on how to proceed:

* Search [Construct Hub for SageMaker construct libraries](https://constructs.dev/search?q=sagemaker)
* Use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, in the same way you would use [the CloudFormation AWS::SageMaker resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_SageMaker.html) directly.

<!--BEGIN CFNONLY DISCLAIMER-->

There are no hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet.
However, you can still use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, and use this service exactly as you would using CloudFormation directly.

For more information on the resources and properties available for this service, see the [CloudFormation documentation for AWS::SageMaker](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_SageMaker.html).

(Read the [CDK Contributing Guide](https://github.com/aws/aws-cdk/blob/master/CONTRIBUTING.md) and submit an RFC if you are interested in contributing to this construct library.)

<!--END CFNONLY DISCLAIMER-->
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

from .. import (
    CfnResource as _CfnResource_e0a482dc,
    CfnTag as _CfnTag_95fbdc29,
    Construct as _Construct_e78e779f,
    IInspectable as _IInspectable_82c04a63,
    IResolvable as _IResolvable_a771d0ef,
    TagManager as _TagManager_0b7ab120,
    TreeInspector as _TreeInspector_1cd1894e,
)


@jsii.implements(_IInspectable_82c04a63)
class CfnApp(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnApp",
):
    '''A CloudFormation ``AWS::SageMaker::App``.

    Creates a running app for the specified UserProfile. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.

    :cloudformationResource: AWS::SageMaker::App
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        cfn_app = sagemaker.CfnApp(self, "MyCfnApp",
            app_name="appName",
            app_type="appType",
            domain_id="domainId",
            user_profile_name="userProfileName",
        
            # the properties below are optional
            resource_spec=sagemaker.CfnApp.ResourceSpecProperty(
                instance_type="instanceType",
                sage_maker_image_arn="sageMakerImageArn",
                sage_maker_image_version_arn="sageMakerImageVersionArn"
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        app_name: builtins.str,
        app_type: builtins.str,
        domain_id: builtins.str,
        user_profile_name: builtins.str,
        resource_spec: typing.Optional[typing.Union[typing.Union["CfnApp.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::App``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param app_name: The name of the app.
        :param app_type: The type of app. *Allowed Values* : ``JupyterServer | KernelGateway | RSessionGateway | RStudioServerPro | TensorBoard | Canvas``
        :param domain_id: The domain ID.
        :param user_profile_name: The user profile name.
        :param resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__24362e7a189dd9a152512fb21a34a422f6b0c297f8c6790022022eef08464b46)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnAppProps(
            app_name=app_name,
            app_type=app_type,
            domain_id=domain_id,
            user_profile_name=user_profile_name,
            resource_spec=resource_spec,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c737ee29060ada7336c13fc1b0c4760d238fe5f1a0c40633f513663ab60b7604)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e60cc29b3013584c3952704d1a8598fda6f5b3cb8d3ea8bb3b06c4b3201fb559)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrAppArn")
    def attr_app_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the app, such as ``arn:aws:sagemaker:us-west-2:account-id:app/my-app-name`` .

        :cloudformationAttribute: AppArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrAppArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="appName")
    def app_name(self) -> builtins.str:
        '''The name of the app.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-appname
        '''
        return typing.cast(builtins.str, jsii.get(self, "appName"))

    @app_name.setter
    def app_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dbf8dd1e21fc1bb8bb388cd604395fc56ba60a6ae78bdc7280102d59b5a61900)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appName", value)

    @builtins.property
    @jsii.member(jsii_name="appType")
    def app_type(self) -> builtins.str:
        '''The type of app.

        *Allowed Values* : ``JupyterServer | KernelGateway | RSessionGateway | RStudioServerPro | TensorBoard | Canvas``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-apptype
        '''
        return typing.cast(builtins.str, jsii.get(self, "appType"))

    @app_type.setter
    def app_type(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a2f3d8355f1b6230681ed10db408bf0473e540c0ffc6754f98dc99901d23963)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appType", value)

    @builtins.property
    @jsii.member(jsii_name="domainId")
    def domain_id(self) -> builtins.str:
        '''The domain ID.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-domainid
        '''
        return typing.cast(builtins.str, jsii.get(self, "domainId"))

    @domain_id.setter
    def domain_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b54cf553db7744d5aee3cb8a0d0ff23bf3b950fc3f9b116d423abd692ea0fed)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "domainId", value)

    @builtins.property
    @jsii.member(jsii_name="userProfileName")
    def user_profile_name(self) -> builtins.str:
        '''The user profile name.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-userprofilename
        '''
        return typing.cast(builtins.str, jsii.get(self, "userProfileName"))

    @user_profile_name.setter
    def user_profile_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__edd0014a2a2f2bcdc6db94d06c735881940f1fcdb330bbebed892ca817f35c13)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "userProfileName", value)

    @builtins.property
    @jsii.member(jsii_name="resourceSpec")
    def resource_spec(
        self,
    ) -> typing.Optional[typing.Union["CfnApp.ResourceSpecProperty", _IResolvable_a771d0ef]]:
        '''Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-resourcespec
        '''
        return typing.cast(typing.Optional[typing.Union["CfnApp.ResourceSpecProperty", _IResolvable_a771d0ef]], jsii.get(self, "resourceSpec"))

    @resource_spec.setter
    def resource_spec(
        self,
        value: typing.Optional[typing.Union["CfnApp.ResourceSpecProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ca390aa8bd546a9064aa71fd4a4cb8e384e5992d790eceedac7f2dd415775d9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "resourceSpec", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnApp.ResourceSpecProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_type": "instanceType",
            "sage_maker_image_arn": "sageMakerImageArn",
            "sage_maker_image_version_arn": "sageMakerImageVersionArn",
        },
    )
    class ResourceSpecProperty:
        def __init__(
            self,
            *,
            instance_type: typing.Optional[builtins.str] = None,
            sage_maker_image_arn: typing.Optional[builtins.str] = None,
            sage_maker_image_version_arn: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

            :param instance_type: The instance type that the image version runs on. .. epigraph:: *JupyterServer apps* only support the ``system`` value. For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.
            :param sage_maker_image_arn: The ARN of the SageMaker image that the image version belongs to.
            :param sage_maker_image_version_arn: The ARN of the image version created on the instance.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                resource_spec_property = sagemaker.CfnApp.ResourceSpecProperty(
                    instance_type="instanceType",
                    sage_maker_image_arn="sageMakerImageArn",
                    sage_maker_image_version_arn="sageMakerImageVersionArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e909dc98d2f0a2ac0662716be9395167e8eec3faf83d2a644d1aa0ade28a77ad)
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument sage_maker_image_arn", value=sage_maker_image_arn, expected_type=type_hints["sage_maker_image_arn"])
                check_type(argname="argument sage_maker_image_version_arn", value=sage_maker_image_version_arn, expected_type=type_hints["sage_maker_image_version_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if sage_maker_image_arn is not None:
                self._values["sage_maker_image_arn"] = sage_maker_image_arn
            if sage_maker_image_version_arn is not None:
                self._values["sage_maker_image_version_arn"] = sage_maker_image_version_arn

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            '''The instance type that the image version runs on.

            .. epigraph::

               *JupyterServer apps* only support the ``system`` value.

               For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-instancetype
            '''
            result = self._values.get("instance_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the SageMaker image that the image version belongs to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-sagemakerimagearn
            '''
            result = self._values.get("sage_maker_image_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_version_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the image version created on the instance.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-app-resourcespec.html#cfn-sagemaker-app-resourcespec-sagemakerimageversionarn
            '''
            result = self._values.get("sage_maker_image_version_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ResourceSpecProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_82c04a63)
class CfnAppImageConfig(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnAppImageConfig",
):
    '''A CloudFormation ``AWS::SageMaker::AppImageConfig``.

    Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.

    :cloudformationResource: AWS::SageMaker::AppImageConfig
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        cfn_app_image_config = sagemaker.CfnAppImageConfig(self, "MyCfnAppImageConfig",
            app_image_config_name="appImageConfigName",
        
            # the properties below are optional
            kernel_gateway_image_config=sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty(
                kernel_specs=[sagemaker.CfnAppImageConfig.KernelSpecProperty(
                    name="name",
        
                    # the properties below are optional
                    display_name="displayName"
                )],
        
                # the properties below are optional
                file_system_config=sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                    default_gid=123,
                    default_uid=123,
                    mount_path="mountPath"
                )
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        app_image_config_name: builtins.str,
        kernel_gateway_image_config: typing.Optional[typing.Union[typing.Union["CfnAppImageConfig.KernelGatewayImageConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::AppImageConfig``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param app_image_config_name: The name of the AppImageConfig. Must be unique to your account.
        :param kernel_gateway_image_config: The configuration for the file system and kernels in the SageMaker image.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a5d78e18093805cc816163eca2ef436af54a112d7b9041db965c34280189f345)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnAppImageConfigProps(
            app_image_config_name=app_image_config_name,
            kernel_gateway_image_config=kernel_gateway_image_config,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bde45cd74d8cc7cf1a3568d862f67d3260e94c29ed1f6d50c77b89fecaf34fa2)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8308ccdee03dc2c695b90e680daa57f41f6b694cf969b888cb5e17673548c2ce)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrAppImageConfigArn")
    def attr_app_image_config_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the AppImageConfig, such as ``arn:aws:sagemaker:us-west-2:account-id:app-image-config/my-app-image-config-name`` .

        :cloudformationAttribute: AppImageConfigArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrAppImageConfigArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="appImageConfigName")
    def app_image_config_name(self) -> builtins.str:
        '''The name of the AppImageConfig.

        Must be unique to your account.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-appimageconfigname
        '''
        return typing.cast(builtins.str, jsii.get(self, "appImageConfigName"))

    @app_image_config_name.setter
    def app_image_config_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5acdc68243f9e1ff4e3763baa7e5b2fa7a5f686936d465bf7254c4c4fa563925)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appImageConfigName", value)

    @builtins.property
    @jsii.member(jsii_name="kernelGatewayImageConfig")
    def kernel_gateway_image_config(
        self,
    ) -> typing.Optional[typing.Union["CfnAppImageConfig.KernelGatewayImageConfigProperty", _IResolvable_a771d0ef]]:
        '''The configuration for the file system and kernels in the SageMaker image.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnAppImageConfig.KernelGatewayImageConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "kernelGatewayImageConfig"))

    @kernel_gateway_image_config.setter
    def kernel_gateway_image_config(
        self,
        value: typing.Optional[typing.Union["CfnAppImageConfig.KernelGatewayImageConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ce10f36e020774ebf3b2c64b047d4444080020d6ac23801e7fdd6178dd7a934)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "kernelGatewayImageConfig", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnAppImageConfig.FileSystemConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "default_gid": "defaultGid",
            "default_uid": "defaultUid",
            "mount_path": "mountPath",
        },
    )
    class FileSystemConfigProperty:
        def __init__(
            self,
            *,
            default_gid: typing.Optional[jsii.Number] = None,
            default_uid: typing.Optional[jsii.Number] = None,
            mount_path: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.

            :param default_gid: The default POSIX group ID (GID). If not specified, defaults to ``100`` .
            :param default_uid: The default POSIX user ID (UID). If not specified, defaults to ``1000`` .
            :param mount_path: The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to * /home/sagemaker-user* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                file_system_config_property = sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                    default_gid=123,
                    default_uid=123,
                    mount_path="mountPath"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b8a5abefd8970e61cf12a8e738b167b232467d7fb3668fb6b97491c4e64d82b2)
                check_type(argname="argument default_gid", value=default_gid, expected_type=type_hints["default_gid"])
                check_type(argname="argument default_uid", value=default_uid, expected_type=type_hints["default_uid"])
                check_type(argname="argument mount_path", value=mount_path, expected_type=type_hints["mount_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if default_gid is not None:
                self._values["default_gid"] = default_gid
            if default_uid is not None:
                self._values["default_uid"] = default_uid
            if mount_path is not None:
                self._values["mount_path"] = mount_path

        @builtins.property
        def default_gid(self) -> typing.Optional[jsii.Number]:
            '''The default POSIX group ID (GID).

            If not specified, defaults to ``100`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultgid
            '''
            result = self._values.get("default_gid")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def default_uid(self) -> typing.Optional[jsii.Number]:
            '''The default POSIX user ID (UID).

            If not specified, defaults to ``1000`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-defaultuid
            '''
            result = self._values.get("default_uid")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def mount_path(self) -> typing.Optional[builtins.str]:
            '''The path within the image to mount the user's EFS home directory.

            The directory should be empty. If not specified, defaults to * /home/sagemaker-user* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-filesystemconfig.html#cfn-sagemaker-appimageconfig-filesystemconfig-mountpath
            '''
            result = self._values.get("mount_path")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FileSystemConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "kernel_specs": "kernelSpecs",
            "file_system_config": "fileSystemConfig",
        },
    )
    class KernelGatewayImageConfigProperty:
        def __init__(
            self,
            *,
            kernel_specs: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnAppImageConfig.KernelSpecProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
            file_system_config: typing.Optional[typing.Union[typing.Union["CfnAppImageConfig.FileSystemConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app.

            :param kernel_specs: The specification of the Jupyter kernels in the image.
            :param file_system_config: The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                kernel_gateway_image_config_property = sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty(
                    kernel_specs=[sagemaker.CfnAppImageConfig.KernelSpecProperty(
                        name="name",
                
                        # the properties below are optional
                        display_name="displayName"
                    )],
                
                    # the properties below are optional
                    file_system_config=sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                        default_gid=123,
                        default_uid=123,
                        mount_path="mountPath"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__740943eda3150da4c7554d774ebf18b5ee7a3a3bd9194b029158988ac8608757)
                check_type(argname="argument kernel_specs", value=kernel_specs, expected_type=type_hints["kernel_specs"])
                check_type(argname="argument file_system_config", value=file_system_config, expected_type=type_hints["file_system_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "kernel_specs": kernel_specs,
            }
            if file_system_config is not None:
                self._values["file_system_config"] = file_system_config

        @builtins.property
        def kernel_specs(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnAppImageConfig.KernelSpecProperty", _IResolvable_a771d0ef]]]:
            '''The specification of the Jupyter kernels in the image.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-kernelspecs
            '''
            result = self._values.get("kernel_specs")
            assert result is not None, "Required property 'kernel_specs' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnAppImageConfig.KernelSpecProperty", _IResolvable_a771d0ef]]], result)

        @builtins.property
        def file_system_config(
            self,
        ) -> typing.Optional[typing.Union["CfnAppImageConfig.FileSystemConfigProperty", _IResolvable_a771d0ef]]:
            '''The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelgatewayimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig-filesystemconfig
            '''
            result = self._values.get("file_system_config")
            return typing.cast(typing.Optional[typing.Union["CfnAppImageConfig.FileSystemConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "KernelGatewayImageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnAppImageConfig.KernelSpecProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "display_name": "displayName"},
    )
    class KernelSpecProperty:
        def __init__(
            self,
            *,
            name: builtins.str,
            display_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The specification of a Jupyter kernel.

            :param name: The name of the Jupyter kernel in the image. This value is case sensitive.
            :param display_name: The display name of the kernel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                kernel_spec_property = sagemaker.CfnAppImageConfig.KernelSpecProperty(
                    name="name",
                
                    # the properties below are optional
                    display_name="displayName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e28308948082e603ecacfc5de87c6dd2f1b0c3830867bf9b3d96d444f5160cef)
                check_type(argname="argument name", value=name, expected_type=type_hints["name"])
                check_type(argname="argument display_name", value=display_name, expected_type=type_hints["display_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "name": name,
            }
            if display_name is not None:
                self._values["display_name"] = display_name

        @builtins.property
        def name(self) -> builtins.str:
            '''The name of the Jupyter kernel in the image.

            This value is case sensitive.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-name
            '''
            result = self._values.get("name")
            assert result is not None, "Required property 'name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def display_name(self) -> typing.Optional[builtins.str]:
            '''The display name of the kernel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-appimageconfig-kernelspec.html#cfn-sagemaker-appimageconfig-kernelspec-displayname
            '''
            result = self._values.get("display_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "KernelSpecProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnAppImageConfigProps",
    jsii_struct_bases=[],
    name_mapping={
        "app_image_config_name": "appImageConfigName",
        "kernel_gateway_image_config": "kernelGatewayImageConfig",
        "tags": "tags",
    },
)
class CfnAppImageConfigProps:
    def __init__(
        self,
        *,
        app_image_config_name: builtins.str,
        kernel_gateway_image_config: typing.Optional[typing.Union[typing.Union[CfnAppImageConfig.KernelGatewayImageConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnAppImageConfig``.

        :param app_image_config_name: The name of the AppImageConfig. Must be unique to your account.
        :param kernel_gateway_image_config: The configuration for the file system and kernels in the SageMaker image.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            cfn_app_image_config_props = sagemaker.CfnAppImageConfigProps(
                app_image_config_name="appImageConfigName",
            
                # the properties below are optional
                kernel_gateway_image_config=sagemaker.CfnAppImageConfig.KernelGatewayImageConfigProperty(
                    kernel_specs=[sagemaker.CfnAppImageConfig.KernelSpecProperty(
                        name="name",
            
                        # the properties below are optional
                        display_name="displayName"
                    )],
            
                    # the properties below are optional
                    file_system_config=sagemaker.CfnAppImageConfig.FileSystemConfigProperty(
                        default_gid=123,
                        default_uid=123,
                        mount_path="mountPath"
                    )
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f001f5d96639cbc81dd2dd54a13eb3e71994193a6a78ace8783d4ab05e9a5d41)
            check_type(argname="argument app_image_config_name", value=app_image_config_name, expected_type=type_hints["app_image_config_name"])
            check_type(argname="argument kernel_gateway_image_config", value=kernel_gateway_image_config, expected_type=type_hints["kernel_gateway_image_config"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "app_image_config_name": app_image_config_name,
        }
        if kernel_gateway_image_config is not None:
            self._values["kernel_gateway_image_config"] = kernel_gateway_image_config
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def app_image_config_name(self) -> builtins.str:
        '''The name of the AppImageConfig.

        Must be unique to your account.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-appimageconfigname
        '''
        result = self._values.get("app_image_config_name")
        assert result is not None, "Required property 'app_image_config_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def kernel_gateway_image_config(
        self,
    ) -> typing.Optional[typing.Union[CfnAppImageConfig.KernelGatewayImageConfigProperty, _IResolvable_a771d0ef]]:
        '''The configuration for the file system and kernels in the SageMaker image.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-kernelgatewayimageconfig
        '''
        result = self._values.get("kernel_gateway_image_config")
        return typing.cast(typing.Optional[typing.Union[CfnAppImageConfig.KernelGatewayImageConfigProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-appimageconfig.html#cfn-sagemaker-appimageconfig-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnAppImageConfigProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnAppProps",
    jsii_struct_bases=[],
    name_mapping={
        "app_name": "appName",
        "app_type": "appType",
        "domain_id": "domainId",
        "user_profile_name": "userProfileName",
        "resource_spec": "resourceSpec",
        "tags": "tags",
    },
)
class CfnAppProps:
    def __init__(
        self,
        *,
        app_name: builtins.str,
        app_type: builtins.str,
        domain_id: builtins.str,
        user_profile_name: builtins.str,
        resource_spec: typing.Optional[typing.Union[typing.Union[CfnApp.ResourceSpecProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnApp``.

        :param app_name: The name of the app.
        :param app_type: The type of app. *Allowed Values* : ``JupyterServer | KernelGateway | RSessionGateway | RStudioServerPro | TensorBoard | Canvas``
        :param domain_id: The domain ID.
        :param user_profile_name: The user profile name.
        :param resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            cfn_app_props = sagemaker.CfnAppProps(
                app_name="appName",
                app_type="appType",
                domain_id="domainId",
                user_profile_name="userProfileName",
            
                # the properties below are optional
                resource_spec=sagemaker.CfnApp.ResourceSpecProperty(
                    instance_type="instanceType",
                    sage_maker_image_arn="sageMakerImageArn",
                    sage_maker_image_version_arn="sageMakerImageVersionArn"
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5e38bb98aa3cb82a89e967db3aa31f556e95b93e9302889bc399716ad30f633)
            check_type(argname="argument app_name", value=app_name, expected_type=type_hints["app_name"])
            check_type(argname="argument app_type", value=app_type, expected_type=type_hints["app_type"])
            check_type(argname="argument domain_id", value=domain_id, expected_type=type_hints["domain_id"])
            check_type(argname="argument user_profile_name", value=user_profile_name, expected_type=type_hints["user_profile_name"])
            check_type(argname="argument resource_spec", value=resource_spec, expected_type=type_hints["resource_spec"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "app_name": app_name,
            "app_type": app_type,
            "domain_id": domain_id,
            "user_profile_name": user_profile_name,
        }
        if resource_spec is not None:
            self._values["resource_spec"] = resource_spec
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def app_name(self) -> builtins.str:
        '''The name of the app.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-appname
        '''
        result = self._values.get("app_name")
        assert result is not None, "Required property 'app_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def app_type(self) -> builtins.str:
        '''The type of app.

        *Allowed Values* : ``JupyterServer | KernelGateway | RSessionGateway | RStudioServerPro | TensorBoard | Canvas``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-apptype
        '''
        result = self._values.get("app_type")
        assert result is not None, "Required property 'app_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def domain_id(self) -> builtins.str:
        '''The domain ID.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-domainid
        '''
        result = self._values.get("domain_id")
        assert result is not None, "Required property 'domain_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def user_profile_name(self) -> builtins.str:
        '''The user profile name.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-userprofilename
        '''
        result = self._values.get("user_profile_name")
        assert result is not None, "Required property 'user_profile_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_spec(
        self,
    ) -> typing.Optional[typing.Union[CfnApp.ResourceSpecProperty, _IResolvable_a771d0ef]]:
        '''Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-resourcespec
        '''
        result = self._values.get("resource_spec")
        return typing.cast(typing.Optional[typing.Union[CfnApp.ResourceSpecProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-app.html#cfn-sagemaker-app-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnAppProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnCodeRepository(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnCodeRepository",
):
    '''A CloudFormation ``AWS::SageMaker::CodeRepository``.

    Creates a Git repository as a resource in your SageMaker account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your SageMaker account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.

    The repository can be hosted either in `AWS CodeCommit <https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html>`_ or in any other Git repository.

    :cloudformationResource: AWS::SageMaker::CodeRepository
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        cfn_code_repository = sagemaker.CfnCodeRepository(self, "MyCfnCodeRepository",
            git_config=sagemaker.CfnCodeRepository.GitConfigProperty(
                repository_url="repositoryUrl",
        
                # the properties below are optional
                branch="branch",
                secret_arn="secretArn"
            ),
        
            # the properties below are optional
            code_repository_name="codeRepositoryName",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        git_config: typing.Union[typing.Union["CfnCodeRepository.GitConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        code_repository_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::CodeRepository``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param git_config: Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.
        :param code_repository_name: The name of the Git repository.
        :param tags: List of tags for Code Repository.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47b68ac7b9b7e668dbb48c32158e169738c6334c33bb8b679efc2639a2e07c53)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnCodeRepositoryProps(
            git_config=git_config, code_repository_name=code_repository_name, tags=tags
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7465cf51b69261a06059c1f214da21e0795519be7eaca11660c4e341f44093bd)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1f3bb7ce407c4a1a0ca7a3b534042987be2867e809a944b5602b4e2d5c1eb2bc)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCodeRepositoryName")
    def attr_code_repository_name(self) -> builtins.str:
        '''The name of the code repository, such as ``myCodeRepo`` .

        :cloudformationAttribute: CodeRepositoryName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCodeRepositoryName"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''List of tags for Code Repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="gitConfig")
    def git_config(
        self,
    ) -> typing.Union["CfnCodeRepository.GitConfigProperty", _IResolvable_a771d0ef]:
        '''Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
        '''
        return typing.cast(typing.Union["CfnCodeRepository.GitConfigProperty", _IResolvable_a771d0ef], jsii.get(self, "gitConfig"))

    @git_config.setter
    def git_config(
        self,
        value: typing.Union["CfnCodeRepository.GitConfigProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cfaf1efa82738838137388284ad40ae2fb06d2f1b4c141f751ce6d98b6610d54)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "gitConfig", value)

    @builtins.property
    @jsii.member(jsii_name="codeRepositoryName")
    def code_repository_name(self) -> typing.Optional[builtins.str]:
        '''The name of the Git repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "codeRepositoryName"))

    @code_repository_name.setter
    def code_repository_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0a2b5351c1bce4b9175e0d287b4c4075c75a7c8b7095d92de61ebb77a7eacf8f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "codeRepositoryName", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnCodeRepository.GitConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "repository_url": "repositoryUrl",
            "branch": "branch",
            "secret_arn": "secretArn",
        },
    )
    class GitConfigProperty:
        def __init__(
            self,
            *,
            repository_url: builtins.str,
            branch: typing.Optional[builtins.str] = None,
            secret_arn: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies configuration details for a Git repository in your AWS account.

            :param repository_url: The URL where the Git repository is located.
            :param branch: The default branch for the Git repository.
            :param secret_arn: The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of ``AWSCURRENT`` and must be in the following format: ``{"username": *UserName* , "password": *Password* }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                git_config_property = sagemaker.CfnCodeRepository.GitConfigProperty(
                    repository_url="repositoryUrl",
                
                    # the properties below are optional
                    branch="branch",
                    secret_arn="secretArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0eaafe3a2670c610bdc95c15afded6f07dae8ca9b1711497933367eb111dad13)
                check_type(argname="argument repository_url", value=repository_url, expected_type=type_hints["repository_url"])
                check_type(argname="argument branch", value=branch, expected_type=type_hints["branch"])
                check_type(argname="argument secret_arn", value=secret_arn, expected_type=type_hints["secret_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "repository_url": repository_url,
            }
            if branch is not None:
                self._values["branch"] = branch
            if secret_arn is not None:
                self._values["secret_arn"] = secret_arn

        @builtins.property
        def repository_url(self) -> builtins.str:
            '''The URL where the Git repository is located.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-repositoryurl
            '''
            result = self._values.get("repository_url")
            assert result is not None, "Required property 'repository_url' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def branch(self) -> typing.Optional[builtins.str]:
            '''The default branch for the Git repository.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-branch
            '''
            result = self._values.get("branch")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def secret_arn(self) -> typing.Optional[builtins.str]:
            '''The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository.

            The secret must have a staging label of ``AWSCURRENT`` and must be in the following format:

            ``{"username": *UserName* , "password": *Password* }``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-secretarn
            '''
            result = self._values.get("secret_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "GitConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnCodeRepositoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "git_config": "gitConfig",
        "code_repository_name": "codeRepositoryName",
        "tags": "tags",
    },
)
class CfnCodeRepositoryProps:
    def __init__(
        self,
        *,
        git_config: typing.Union[typing.Union[CfnCodeRepository.GitConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        code_repository_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnCodeRepository``.

        :param git_config: Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.
        :param code_repository_name: The name of the Git repository.
        :param tags: List of tags for Code Repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            cfn_code_repository_props = sagemaker.CfnCodeRepositoryProps(
                git_config=sagemaker.CfnCodeRepository.GitConfigProperty(
                    repository_url="repositoryUrl",
            
                    # the properties below are optional
                    branch="branch",
                    secret_arn="secretArn"
                ),
            
                # the properties below are optional
                code_repository_name="codeRepositoryName",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fa10e4d4dfa3d3dec8efa252f4408460f40ed886c95f61a5bf93eba1df52e1f8)
            check_type(argname="argument git_config", value=git_config, expected_type=type_hints["git_config"])
            check_type(argname="argument code_repository_name", value=code_repository_name, expected_type=type_hints["code_repository_name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "git_config": git_config,
        }
        if code_repository_name is not None:
            self._values["code_repository_name"] = code_repository_name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def git_config(
        self,
    ) -> typing.Union[CfnCodeRepository.GitConfigProperty, _IResolvable_a771d0ef]:
        '''Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
        '''
        result = self._values.get("git_config")
        assert result is not None, "Required property 'git_config' is missing"
        return typing.cast(typing.Union[CfnCodeRepository.GitConfigProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def code_repository_name(self) -> typing.Optional[builtins.str]:
        '''The name of the Git repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
        '''
        result = self._values.get("code_repository_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''List of tags for Code Repository.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnCodeRepositoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnDataQualityJobDefinition(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition",
):
    '''A CloudFormation ``AWS::SageMaker::DataQualityJobDefinition``.

    Creates a definition for a job that monitors data quality and drift. For information about model monitor, see `Amazon SageMaker Model Monitor <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html>`_ .

    :cloudformationResource: AWS::SageMaker::DataQualityJobDefinition
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        # json: Any
        
        cfn_data_quality_job_definition = sagemaker.CfnDataQualityJobDefinition(self, "MyCfnDataQualityJobDefinition",
            data_quality_app_specification=sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty(
                image_uri="imageUri",
        
                # the properties below are optional
                container_arguments=["containerArguments"],
                container_entrypoint=["containerEntrypoint"],
                environment={
                    "environment_key": "environment"
                },
                post_analytics_processor_source_uri="postAnalyticsProcessorSourceUri",
                record_preprocessor_source_uri="recordPreprocessorSourceUri"
            ),
            data_quality_job_input=sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty(
                batch_transform_input=sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=json,
                        parquet=False
                    ),
                    local_path="localPath",
        
                    # the properties below are optional
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                ),
                endpoint_input=sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
        
                    # the properties below are optional
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            ),
            data_quality_job_output_config=sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty(
                monitoring_outputs=[sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )],
        
                # the properties below are optional
                kms_key_id="kmsKeyId"
            ),
            job_resources=sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty(
                cluster_config=sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
        
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            ),
            role_arn="roleArn",
        
            # the properties below are optional
            data_quality_baseline_config=sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty(
                baselining_job_name="baseliningJobName",
                constraints_resource=sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                ),
                statistics_resource=sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                    s3_uri="s3Uri"
                )
            ),
            endpoint_name="endpointName",
            job_definition_name="jobDefinitionName",
            network_config=sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty(
                enable_inter_container_traffic_encryption=False,
                enable_network_isolation=False,
                vpc_config=sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            ),
            stopping_condition=sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty(
                max_runtime_in_seconds=123
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        data_quality_app_specification: typing.Union[typing.Union["CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        data_quality_job_input: typing.Union[typing.Union["CfnDataQualityJobDefinition.DataQualityJobInputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        data_quality_job_output_config: typing.Union[typing.Union["CfnDataQualityJobDefinition.MonitoringOutputConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        job_resources: typing.Union[typing.Union["CfnDataQualityJobDefinition.MonitoringResourcesProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        role_arn: builtins.str,
        data_quality_baseline_config: typing.Optional[typing.Union[typing.Union["CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        network_config: typing.Optional[typing.Union[typing.Union["CfnDataQualityJobDefinition.NetworkConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        stopping_condition: typing.Optional[typing.Union[typing.Union["CfnDataQualityJobDefinition.StoppingConditionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::DataQualityJobDefinition``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param data_quality_app_specification: Specifies the container that runs the monitoring job.
        :param data_quality_job_input: A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.
        :param data_quality_job_output_config: The output configuration for monitoring jobs.
        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param data_quality_baseline_config: Configures the constraints and baselines for the monitoring job.
        :param endpoint_name: ``AWS::SageMaker::DataQualityJobDefinition.EndpointName``.
        :param job_definition_name: The name for the monitoring job definition.
        :param network_config: Specifies networking configuration for the monitoring job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f839c3f0a79456935b058b9c6713c3cfff4923b007b638a7b5c5a2c86aa794d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDataQualityJobDefinitionProps(
            data_quality_app_specification=data_quality_app_specification,
            data_quality_job_input=data_quality_job_input,
            data_quality_job_output_config=data_quality_job_output_config,
            job_resources=job_resources,
            role_arn=role_arn,
            data_quality_baseline_config=data_quality_baseline_config,
            endpoint_name=endpoint_name,
            job_definition_name=job_definition_name,
            network_config=network_config,
            stopping_condition=stopping_condition,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c73ac0d925e74db0a002aaf2858b0532fc175bafe3c179703ed11b798a8a1217)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9869c33206419942eb2fd35038590054bb0da50e510907de419e5db64d6f2b7d)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCreationTime")
    def attr_creation_time(self) -> builtins.str:
        '''The time when the job definition was created.

        :cloudformationAttribute: CreationTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreationTime"))

    @builtins.property
    @jsii.member(jsii_name="attrJobDefinitionArn")
    def attr_job_definition_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the job definition.

        :cloudformationAttribute: JobDefinitionArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrJobDefinitionArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="dataQualityAppSpecification")
    def data_quality_app_specification(
        self,
    ) -> typing.Union["CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty", _IResolvable_a771d0ef]:
        '''Specifies the container that runs the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification
        '''
        return typing.cast(typing.Union["CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty", _IResolvable_a771d0ef], jsii.get(self, "dataQualityAppSpecification"))

    @data_quality_app_specification.setter
    def data_quality_app_specification(
        self,
        value: typing.Union["CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f167f93b9467db88dbc0bc346f62f994707b3ba3db50dd1db40040ad31604c3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityAppSpecification", value)

    @builtins.property
    @jsii.member(jsii_name="dataQualityJobInput")
    def data_quality_job_input(
        self,
    ) -> typing.Union["CfnDataQualityJobDefinition.DataQualityJobInputProperty", _IResolvable_a771d0ef]:
        '''A list of inputs for the monitoring job.

        Currently endpoints are supported as monitoring inputs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput
        '''
        return typing.cast(typing.Union["CfnDataQualityJobDefinition.DataQualityJobInputProperty", _IResolvable_a771d0ef], jsii.get(self, "dataQualityJobInput"))

    @data_quality_job_input.setter
    def data_quality_job_input(
        self,
        value: typing.Union["CfnDataQualityJobDefinition.DataQualityJobInputProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ee4242ba113054adc96fb75460975d34c78d33aab4ef35ab6b8c70d9182223c0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityJobInput", value)

    @builtins.property
    @jsii.member(jsii_name="dataQualityJobOutputConfig")
    def data_quality_job_output_config(
        self,
    ) -> typing.Union["CfnDataQualityJobDefinition.MonitoringOutputConfigProperty", _IResolvable_a771d0ef]:
        '''The output configuration for monitoring jobs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjoboutputconfig
        '''
        return typing.cast(typing.Union["CfnDataQualityJobDefinition.MonitoringOutputConfigProperty", _IResolvable_a771d0ef], jsii.get(self, "dataQualityJobOutputConfig"))

    @data_quality_job_output_config.setter
    def data_quality_job_output_config(
        self,
        value: typing.Union["CfnDataQualityJobDefinition.MonitoringOutputConfigProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff33df4a3b1f6f9848941be21c24d095d8a6f01e25b94253b8c4dbe2e38803b0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityJobOutputConfig", value)

    @builtins.property
    @jsii.member(jsii_name="jobResources")
    def job_resources(
        self,
    ) -> typing.Union["CfnDataQualityJobDefinition.MonitoringResourcesProperty", _IResolvable_a771d0ef]:
        '''Identifies the resources to deploy for a monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobresources
        '''
        return typing.cast(typing.Union["CfnDataQualityJobDefinition.MonitoringResourcesProperty", _IResolvable_a771d0ef], jsii.get(self, "jobResources"))

    @job_resources.setter
    def job_resources(
        self,
        value: typing.Union["CfnDataQualityJobDefinition.MonitoringResourcesProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__14459e5a372245209313a85ddf25415919639cef9c7adfd234ce4c39cadc6d7b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobResources", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-rolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9613f826fe870284865917adc8cfb57d8adfb0562e1ef2327cdcddaa41a62851)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value)

    @builtins.property
    @jsii.member(jsii_name="dataQualityBaselineConfig")
    def data_quality_baseline_config(
        self,
    ) -> typing.Optional[typing.Union["CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty", _IResolvable_a771d0ef]]:
        '''Configures the constraints and baselines for the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "dataQualityBaselineConfig"))

    @data_quality_baseline_config.setter
    def data_quality_baseline_config(
        self,
        value: typing.Optional[typing.Union["CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01ea8e482e5a6175ad837ed1fc2abce4dded5d35233d23106fe65d6def6f59d6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataQualityBaselineConfig", value)

    @builtins.property
    @jsii.member(jsii_name="endpointName")
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''``AWS::SageMaker::DataQualityJobDefinition.EndpointName``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-endpointname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointName"))

    @endpoint_name.setter
    def endpoint_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a94b2168f91023b6eb979e5d72697e2d835e77505c65ed941bf8863c78b52509)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointName", value)

    @builtins.property
    @jsii.member(jsii_name="jobDefinitionName")
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name for the monitoring job definition.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobdefinitionname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "jobDefinitionName"))

    @job_definition_name.setter
    def job_definition_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cd56b6cc25c54d35b52bdef8b84c8446264ec26521d9db7db76a6e68d6b001fc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobDefinitionName", value)

    @builtins.property
    @jsii.member(jsii_name="networkConfig")
    def network_config(
        self,
    ) -> typing.Optional[typing.Union["CfnDataQualityJobDefinition.NetworkConfigProperty", _IResolvable_a771d0ef]]:
        '''Specifies networking configuration for the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnDataQualityJobDefinition.NetworkConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "networkConfig"))

    @network_config.setter
    def network_config(
        self,
        value: typing.Optional[typing.Union["CfnDataQualityJobDefinition.NetworkConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__495ae53e236dfb3a1d194487f98c360126a657601d48b8dcfc9f7b24548c9496)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "networkConfig", value)

    @builtins.property
    @jsii.member(jsii_name="stoppingCondition")
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union["CfnDataQualityJobDefinition.StoppingConditionProperty", _IResolvable_a771d0ef]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition
        '''
        return typing.cast(typing.Optional[typing.Union["CfnDataQualityJobDefinition.StoppingConditionProperty", _IResolvable_a771d0ef]], jsii.get(self, "stoppingCondition"))

    @stopping_condition.setter
    def stopping_condition(
        self,
        value: typing.Optional[typing.Union["CfnDataQualityJobDefinition.StoppingConditionProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b983888e702387e9a83a3b8484507521a4a79d18df9546fa2d68c9ead912ceeb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "stoppingCondition", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_captured_destination_s3_uri": "dataCapturedDestinationS3Uri",
            "dataset_format": "datasetFormat",
            "local_path": "localPath",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
        },
    )
    class BatchTransformInputProperty:
        def __init__(
            self,
            *,
            data_captured_destination_s3_uri: builtins.str,
            dataset_format: typing.Union[typing.Union["CfnDataQualityJobDefinition.DatasetFormatProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            local_path: builtins.str,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''
            :param data_captured_destination_s3_uri: ``CfnDataQualityJobDefinition.BatchTransformInputProperty.DataCapturedDestinationS3Uri``.
            :param dataset_format: ``CfnDataQualityJobDefinition.BatchTransformInputProperty.DatasetFormat``.
            :param local_path: ``CfnDataQualityJobDefinition.BatchTransformInputProperty.LocalPath``.
            :param s3_data_distribution_type: ``CfnDataQualityJobDefinition.BatchTransformInputProperty.S3DataDistributionType``.
            :param s3_input_mode: ``CfnDataQualityJobDefinition.BatchTransformInputProperty.S3InputMode``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                # json: Any
                
                batch_transform_input_property = sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=json,
                        parquet=False
                    ),
                    local_path="localPath",
                
                    # the properties below are optional
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__adbb1ee78cc24954d4295a669729e739e8f2f24ba94d1d0c46e2ade8c2a0be48)
                check_type(argname="argument data_captured_destination_s3_uri", value=data_captured_destination_s3_uri, expected_type=type_hints["data_captured_destination_s3_uri"])
                check_type(argname="argument dataset_format", value=dataset_format, expected_type=type_hints["dataset_format"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_captured_destination_s3_uri": data_captured_destination_s3_uri,
                "dataset_format": dataset_format,
                "local_path": local_path,
            }
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode

        @builtins.property
        def data_captured_destination_s3_uri(self) -> builtins.str:
            '''``CfnDataQualityJobDefinition.BatchTransformInputProperty.DataCapturedDestinationS3Uri``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-datacaptureddestinations3uri
            '''
            result = self._values.get("data_captured_destination_s3_uri")
            assert result is not None, "Required property 'data_captured_destination_s3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def dataset_format(
            self,
        ) -> typing.Union["CfnDataQualityJobDefinition.DatasetFormatProperty", _IResolvable_a771d0ef]:
            '''``CfnDataQualityJobDefinition.BatchTransformInputProperty.DatasetFormat``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-datasetformat
            '''
            result = self._values.get("dataset_format")
            assert result is not None, "Required property 'dataset_format' is missing"
            return typing.cast(typing.Union["CfnDataQualityJobDefinition.DatasetFormatProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''``CfnDataQualityJobDefinition.BatchTransformInputProperty.LocalPath``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''``CfnDataQualityJobDefinition.BatchTransformInputProperty.S3DataDistributionType``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''``CfnDataQualityJobDefinition.BatchTransformInputProperty.S3InputMode``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-batchtransforminput.html#cfn-sagemaker-dataqualityjobdefinition-batchtransforminput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BatchTransformInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_count": "instanceCount",
            "instance_type": "instanceType",
            "volume_size_in_gb": "volumeSizeInGb",
            "volume_kms_key_id": "volumeKmsKeyId",
        },
    )
    class ClusterConfigProperty:
        def __init__(
            self,
            *,
            instance_count: jsii.Number,
            instance_type: builtins.str,
            volume_size_in_gb: jsii.Number,
            volume_kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration for the cluster of resources used to run the processing job.

            :param instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
            :param instance_type: The ML compute instance type for the processing job.
            :param volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
            :param volume_kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                cluster_config_property = sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
                
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__280fde6788410b97fb40002066110984aaa5b7e23574614be640f5813781a98b)
                check_type(argname="argument instance_count", value=instance_count, expected_type=type_hints["instance_count"])
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument volume_size_in_gb", value=volume_size_in_gb, expected_type=type_hints["volume_size_in_gb"])
                check_type(argname="argument volume_kms_key_id", value=volume_kms_key_id, expected_type=type_hints["volume_kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "instance_count": instance_count,
                "instance_type": instance_type,
                "volume_size_in_gb": volume_size_in_gb,
            }
            if volume_kms_key_id is not None:
                self._values["volume_kms_key_id"] = volume_kms_key_id

        @builtins.property
        def instance_count(self) -> jsii.Number:
            '''The number of ML compute instances to use in the model monitoring job.

            For distributed processing jobs, specify a value greater than 1. The default value is 1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-instancecount
            '''
            result = self._values.get("instance_count")
            assert result is not None, "Required property 'instance_count' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def instance_type(self) -> builtins.str:
            '''The ML compute instance type for the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-instancetype
            '''
            result = self._values.get("instance_type")
            assert result is not None, "Required property 'instance_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def volume_size_in_gb(self) -> jsii.Number:
            '''The size of the ML storage volume, in gigabytes, that you want to provision.

            You must specify sufficient ML storage for your scenario.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-volumesizeingb
            '''
            result = self._values.get("volume_size_in_gb")
            assert result is not None, "Required property 'volume_size_in_gb' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def volume_kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-volumekmskeyid
            '''
            result = self._values.get("volume_kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri"},
    )
    class ConstraintsResourceProperty:
        def __init__(self, *, s3_uri: typing.Optional[builtins.str] = None) -> None:
            '''The constraints resource for a monitoring job.

            :param s3_uri: The Amazon S3 URI for the constraints resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-constraintsresource.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                constraints_resource_property = sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6f3145b62608b085b26b921c591513a76d4fb64c018c721f27835f6f6505493e)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if s3_uri is not None:
                self._values["s3_uri"] = s3_uri

        @builtins.property
        def s3_uri(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 URI for the constraints resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-constraintsresource.html#cfn-sagemaker-dataqualityjobdefinition-constraintsresource-s3uri
            '''
            result = self._values.get("s3_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConstraintsResourceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.CsvProperty",
        jsii_struct_bases=[],
        name_mapping={"header": "header"},
    )
    class CsvProperty:
        def __init__(
            self,
            *,
            header: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param header: ``CfnDataQualityJobDefinition.CsvProperty.Header``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-csv.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                csv_property = sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                    header=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a19b12cc67bad0e41de889e4f2c0f44a1807c6658c922672a3af351f3de311d9)
                check_type(argname="argument header", value=header, expected_type=type_hints["header"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if header is not None:
                self._values["header"] = header

        @builtins.property
        def header(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''``CfnDataQualityJobDefinition.CsvProperty.Header``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-csv.html#cfn-sagemaker-dataqualityjobdefinition-csv-header
            '''
            result = self._values.get("header")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CsvProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "image_uri": "imageUri",
            "container_arguments": "containerArguments",
            "container_entrypoint": "containerEntrypoint",
            "environment": "environment",
            "post_analytics_processor_source_uri": "postAnalyticsProcessorSourceUri",
            "record_preprocessor_source_uri": "recordPreprocessorSourceUri",
        },
    )
    class DataQualityAppSpecificationProperty:
        def __init__(
            self,
            *,
            image_uri: builtins.str,
            container_arguments: typing.Optional[typing.Sequence[builtins.str]] = None,
            container_entrypoint: typing.Optional[typing.Sequence[builtins.str]] = None,
            environment: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
            post_analytics_processor_source_uri: typing.Optional[builtins.str] = None,
            record_preprocessor_source_uri: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Information about the container that a data quality monitoring job runs.

            :param image_uri: The container image that the data quality monitoring job runs.
            :param container_arguments: The arguments to send to the container that the monitoring job runs.
            :param container_entrypoint: The entrypoint for a container used to run a monitoring job.
            :param environment: Sets the environment variables in the container that the monitoring job runs.
            :param post_analytics_processor_source_uri: An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
            :param record_preprocessor_source_uri: An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                data_quality_app_specification_property = sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty(
                    image_uri="imageUri",
                
                    # the properties below are optional
                    container_arguments=["containerArguments"],
                    container_entrypoint=["containerEntrypoint"],
                    environment={
                        "environment_key": "environment"
                    },
                    post_analytics_processor_source_uri="postAnalyticsProcessorSourceUri",
                    record_preprocessor_source_uri="recordPreprocessorSourceUri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e567d1df0381015adf45ab20818cef725a70e8c23c365a6f26856db870f36e24)
                check_type(argname="argument image_uri", value=image_uri, expected_type=type_hints["image_uri"])
                check_type(argname="argument container_arguments", value=container_arguments, expected_type=type_hints["container_arguments"])
                check_type(argname="argument container_entrypoint", value=container_entrypoint, expected_type=type_hints["container_entrypoint"])
                check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
                check_type(argname="argument post_analytics_processor_source_uri", value=post_analytics_processor_source_uri, expected_type=type_hints["post_analytics_processor_source_uri"])
                check_type(argname="argument record_preprocessor_source_uri", value=record_preprocessor_source_uri, expected_type=type_hints["record_preprocessor_source_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "image_uri": image_uri,
            }
            if container_arguments is not None:
                self._values["container_arguments"] = container_arguments
            if container_entrypoint is not None:
                self._values["container_entrypoint"] = container_entrypoint
            if environment is not None:
                self._values["environment"] = environment
            if post_analytics_processor_source_uri is not None:
                self._values["post_analytics_processor_source_uri"] = post_analytics_processor_source_uri
            if record_preprocessor_source_uri is not None:
                self._values["record_preprocessor_source_uri"] = record_preprocessor_source_uri

        @builtins.property
        def image_uri(self) -> builtins.str:
            '''The container image that the data quality monitoring job runs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-imageuri
            '''
            result = self._values.get("image_uri")
            assert result is not None, "Required property 'image_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def container_arguments(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The arguments to send to the container that the monitoring job runs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-containerarguments
            '''
            result = self._values.get("container_arguments")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def container_entrypoint(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The entrypoint for a container used to run a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-containerentrypoint
            '''
            result = self._values.get("container_entrypoint")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def environment(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            '''Sets the environment variables in the container that the monitoring job runs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-environment
            '''
            result = self._values.get("environment")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]], result)

        @builtins.property
        def post_analytics_processor_source_uri(self) -> typing.Optional[builtins.str]:
            '''An Amazon S3 URI to a script that is called after analysis has been performed.

            Applicable only for the built-in (first party) containers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-postanalyticsprocessorsourceuri
            '''
            result = self._values.get("post_analytics_processor_source_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def record_preprocessor_source_uri(self) -> typing.Optional[builtins.str]:
            '''An Amazon S3 URI to a script that is called per row prior to running analysis.

            It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-recordpreprocessorsourceuri
            '''
            result = self._values.get("record_preprocessor_source_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataQualityAppSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "baselining_job_name": "baseliningJobName",
            "constraints_resource": "constraintsResource",
            "statistics_resource": "statisticsResource",
        },
    )
    class DataQualityBaselineConfigProperty:
        def __init__(
            self,
            *,
            baselining_job_name: typing.Optional[builtins.str] = None,
            constraints_resource: typing.Optional[typing.Union[typing.Union["CfnDataQualityJobDefinition.ConstraintsResourceProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            statistics_resource: typing.Optional[typing.Union[typing.Union["CfnDataQualityJobDefinition.StatisticsResourceProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Configuration for monitoring constraints and monitoring statistics.

            These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.

            :param baselining_job_name: The name of the job that performs baselining for the data quality monitoring job.
            :param constraints_resource: The constraints resource for a monitoring job.
            :param statistics_resource: Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                data_quality_baseline_config_property = sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    ),
                    statistics_resource=sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                        s3_uri="s3Uri"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0ef0fce87048a7d8e7ab050e6838f20bb478cc878ce96cebadb7de137e61d2ec)
                check_type(argname="argument baselining_job_name", value=baselining_job_name, expected_type=type_hints["baselining_job_name"])
                check_type(argname="argument constraints_resource", value=constraints_resource, expected_type=type_hints["constraints_resource"])
                check_type(argname="argument statistics_resource", value=statistics_resource, expected_type=type_hints["statistics_resource"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if baselining_job_name is not None:
                self._values["baselining_job_name"] = baselining_job_name
            if constraints_resource is not None:
                self._values["constraints_resource"] = constraints_resource
            if statistics_resource is not None:
                self._values["statistics_resource"] = statistics_resource

        @builtins.property
        def baselining_job_name(self) -> typing.Optional[builtins.str]:
            '''The name of the job that performs baselining for the data quality monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-baseliningjobname
            '''
            result = self._values.get("baselining_job_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def constraints_resource(
            self,
        ) -> typing.Optional[typing.Union["CfnDataQualityJobDefinition.ConstraintsResourceProperty", _IResolvable_a771d0ef]]:
            '''The constraints resource for a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-constraintsresource
            '''
            result = self._values.get("constraints_resource")
            return typing.cast(typing.Optional[typing.Union["CfnDataQualityJobDefinition.ConstraintsResourceProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def statistics_resource(
            self,
        ) -> typing.Optional[typing.Union["CfnDataQualityJobDefinition.StatisticsResourceProperty", _IResolvable_a771d0ef]]:
            '''Configuration for monitoring constraints and monitoring statistics.

            These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-statisticsresource
            '''
            result = self._values.get("statistics_resource")
            return typing.cast(typing.Optional[typing.Union["CfnDataQualityJobDefinition.StatisticsResourceProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataQualityBaselineConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "batch_transform_input": "batchTransformInput",
            "endpoint_input": "endpointInput",
        },
    )
    class DataQualityJobInputProperty:
        def __init__(
            self,
            *,
            batch_transform_input: typing.Optional[typing.Union[typing.Union["CfnDataQualityJobDefinition.BatchTransformInputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            endpoint_input: typing.Optional[typing.Union[typing.Union["CfnDataQualityJobDefinition.EndpointInputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''The input for the data quality monitoring job.

            Currently endpoints are supported for input.

            :param batch_transform_input: ``CfnDataQualityJobDefinition.DataQualityJobInputProperty.BatchTransformInput``.
            :param endpoint_input: Input object for the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                # json: Any
                
                data_quality_job_input_property = sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty(
                    batch_transform_input=sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=json,
                            parquet=False
                        ),
                        local_path="localPath",
                
                        # the properties below are optional
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    ),
                    endpoint_input=sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
                
                        # the properties below are optional
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1baf777cf959e096ff5aee04c49cef1d94a4deabb45a546f2647766335e676d2)
                check_type(argname="argument batch_transform_input", value=batch_transform_input, expected_type=type_hints["batch_transform_input"])
                check_type(argname="argument endpoint_input", value=endpoint_input, expected_type=type_hints["endpoint_input"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if batch_transform_input is not None:
                self._values["batch_transform_input"] = batch_transform_input
            if endpoint_input is not None:
                self._values["endpoint_input"] = endpoint_input

        @builtins.property
        def batch_transform_input(
            self,
        ) -> typing.Optional[typing.Union["CfnDataQualityJobDefinition.BatchTransformInputProperty", _IResolvable_a771d0ef]]:
            '''``CfnDataQualityJobDefinition.DataQualityJobInputProperty.BatchTransformInput``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput-batchtransforminput
            '''
            result = self._values.get("batch_transform_input")
            return typing.cast(typing.Optional[typing.Union["CfnDataQualityJobDefinition.BatchTransformInputProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def endpoint_input(
            self,
        ) -> typing.Optional[typing.Union["CfnDataQualityJobDefinition.EndpointInputProperty", _IResolvable_a771d0ef]]:
            '''Input object for the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput-endpointinput
            '''
            result = self._values.get("endpoint_input")
            return typing.cast(typing.Optional[typing.Union["CfnDataQualityJobDefinition.EndpointInputProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataQualityJobInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty",
        jsii_struct_bases=[],
        name_mapping={"csv": "csv", "json": "json", "parquet": "parquet"},
    )
    class DatasetFormatProperty:
        def __init__(
            self,
            *,
            csv: typing.Optional[typing.Union[typing.Union["CfnDataQualityJobDefinition.CsvProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            json: typing.Any = None,
            parquet: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param csv: ``CfnDataQualityJobDefinition.DatasetFormatProperty.Csv``.
            :param json: ``CfnDataQualityJobDefinition.DatasetFormatProperty.Json``.
            :param parquet: ``CfnDataQualityJobDefinition.DatasetFormatProperty.Parquet``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                # json: Any
                
                dataset_format_property = sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                    csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                        header=False
                    ),
                    json=json,
                    parquet=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__13dbbd46fbe28058aa4f5977684ac66a801165cbeef0ea6523e1920350713f53)
                check_type(argname="argument csv", value=csv, expected_type=type_hints["csv"])
                check_type(argname="argument json", value=json, expected_type=type_hints["json"])
                check_type(argname="argument parquet", value=parquet, expected_type=type_hints["parquet"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if csv is not None:
                self._values["csv"] = csv
            if json is not None:
                self._values["json"] = json
            if parquet is not None:
                self._values["parquet"] = parquet

        @builtins.property
        def csv(
            self,
        ) -> typing.Optional[typing.Union["CfnDataQualityJobDefinition.CsvProperty", _IResolvable_a771d0ef]]:
            '''``CfnDataQualityJobDefinition.DatasetFormatProperty.Csv``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html#cfn-sagemaker-dataqualityjobdefinition-datasetformat-csv
            '''
            result = self._values.get("csv")
            return typing.cast(typing.Optional[typing.Union["CfnDataQualityJobDefinition.CsvProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def json(self) -> typing.Any:
            '''``CfnDataQualityJobDefinition.DatasetFormatProperty.Json``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html#cfn-sagemaker-dataqualityjobdefinition-datasetformat-json
            '''
            result = self._values.get("json")
            return typing.cast(typing.Any, result)

        @builtins.property
        def parquet(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''``CfnDataQualityJobDefinition.DatasetFormatProperty.Parquet``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-datasetformat.html#cfn-sagemaker-dataqualityjobdefinition-datasetformat-parquet
            '''
            result = self._values.get("parquet")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DatasetFormatProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "endpoint_name": "endpointName",
            "local_path": "localPath",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
        },
    )
    class EndpointInputProperty:
        def __init__(
            self,
            *,
            endpoint_name: builtins.str,
            local_path: builtins.str,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Input object for the endpoint.

            :param endpoint_name: An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.
            :param local_path: Path to the filesystem where the endpoint data is available to the container.
            :param s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to ``FullyReplicated``
            :param s3_input_mode: Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job. ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                endpoint_input_property = sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
                
                    # the properties below are optional
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f15ddea284614bec17d23026d946ec181543627b01565263b5bbbc525e224330)
                check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "endpoint_name": endpoint_name,
                "local_path": local_path,
            }
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode

        @builtins.property
        def endpoint_name(self) -> builtins.str:
            '''An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-endpointname
            '''
            result = self._values.get("endpoint_name")
            assert result is not None, "Required property 'endpoint_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''Path to the filesystem where the endpoint data is available to the container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.

            Defaults to ``FullyReplicated``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job.

            ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EndpointInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.JsonProperty",
        jsii_struct_bases=[],
        name_mapping={"line": "line"},
    )
    class JsonProperty:
        def __init__(
            self,
            *,
            line: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param line: ``CfnDataQualityJobDefinition.JsonProperty.Line``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-json.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                json_property = sagemaker.CfnDataQualityJobDefinition.JsonProperty(
                    line=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d7e639fede27fcc7b5500356a255579b2408f367e19b0b8bef71b214a6f94f69)
                check_type(argname="argument line", value=line, expected_type=type_hints["line"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if line is not None:
                self._values["line"] = line

        @builtins.property
        def line(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''``CfnDataQualityJobDefinition.JsonProperty.Line``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-json.html#cfn-sagemaker-dataqualityjobdefinition-json-line
            '''
            result = self._values.get("line")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "monitoring_outputs": "monitoringOutputs",
            "kms_key_id": "kmsKeyId",
        },
    )
    class MonitoringOutputConfigProperty:
        def __init__(
            self,
            *,
            monitoring_outputs: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnDataQualityJobDefinition.MonitoringOutputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The output configuration for monitoring jobs.

            :param monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                monitoring_output_config_property = sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
                
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__af44a693cc0ab65a1a60a07ce785310b8eb75f3abb4c6a4935ed2f991fd9d981)
                check_type(argname="argument monitoring_outputs", value=monitoring_outputs, expected_type=type_hints["monitoring_outputs"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "monitoring_outputs": monitoring_outputs,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def monitoring_outputs(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnDataQualityJobDefinition.MonitoringOutputProperty", _IResolvable_a771d0ef]]]:
            '''Monitoring outputs for monitoring jobs.

            This is where the output of the periodic monitoring jobs is uploaded.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutputconfig-monitoringoutputs
            '''
            result = self._values.get("monitoring_outputs")
            assert result is not None, "Required property 'monitoring_outputs' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnDataQualityJobDefinition.MonitoringOutputProperty", _IResolvable_a771d0ef]]], result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_output": "s3Output"},
    )
    class MonitoringOutputProperty:
        def __init__(
            self,
            *,
            s3_output: typing.Union[typing.Union["CfnDataQualityJobDefinition.S3OutputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        ) -> None:
            '''The output object for a monitoring job.

            :param s3_output: The Amazon S3 storage location where the results of a monitoring job are saved.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                monitoring_output_property = sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
                
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__af6f4571495bd210098afffa620195c488e6eed0e986ba41ea20459e1d7bf95f)
                check_type(argname="argument s3_output", value=s3_output, expected_type=type_hints["s3_output"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_output": s3_output,
            }

        @builtins.property
        def s3_output(
            self,
        ) -> typing.Union["CfnDataQualityJobDefinition.S3OutputProperty", _IResolvable_a771d0ef]:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutput.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutput-s3output
            '''
            result = self._values.get("s3_output")
            assert result is not None, "Required property 's3_output' is missing"
            return typing.cast(typing.Union["CfnDataQualityJobDefinition.S3OutputProperty", _IResolvable_a771d0ef], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty",
        jsii_struct_bases=[],
        name_mapping={"cluster_config": "clusterConfig"},
    )
    class MonitoringResourcesProperty:
        def __init__(
            self,
            *,
            cluster_config: typing.Union[typing.Union["CfnDataQualityJobDefinition.ClusterConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        ) -> None:
            '''Identifies the resources to deploy for a monitoring job.

            :param cluster_config: The configuration for the cluster resources used to run the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringresources.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                monitoring_resources_property = sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
                
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6bd275dc8934cf0891f8174133d3a721b9da7951509da3c4bcc9b85b6b32cc0b)
                check_type(argname="argument cluster_config", value=cluster_config, expected_type=type_hints["cluster_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "cluster_config": cluster_config,
            }

        @builtins.property
        def cluster_config(
            self,
        ) -> typing.Union["CfnDataQualityJobDefinition.ClusterConfigProperty", _IResolvable_a771d0ef]:
            '''The configuration for the cluster resources used to run the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringresources.html#cfn-sagemaker-dataqualityjobdefinition-monitoringresources-clusterconfig
            '''
            result = self._values.get("cluster_config")
            assert result is not None, "Required property 'cluster_config' is missing"
            return typing.cast(typing.Union["CfnDataQualityJobDefinition.ClusterConfigProperty", _IResolvable_a771d0ef], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringResourcesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_inter_container_traffic_encryption": "enableInterContainerTrafficEncryption",
            "enable_network_isolation": "enableNetworkIsolation",
            "vpc_config": "vpcConfig",
        },
    )
    class NetworkConfigProperty:
        def __init__(
            self,
            *,
            enable_inter_container_traffic_encryption: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            enable_network_isolation: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            vpc_config: typing.Optional[typing.Union[typing.Union["CfnDataQualityJobDefinition.VpcConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.

            :param enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
            :param enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
            :param vpc_config: Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                network_config_property = sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__aa134b05a0fc128a42f94af284d5cabd7d180076eea5c5befd8e709293658c01)
                check_type(argname="argument enable_inter_container_traffic_encryption", value=enable_inter_container_traffic_encryption, expected_type=type_hints["enable_inter_container_traffic_encryption"])
                check_type(argname="argument enable_network_isolation", value=enable_network_isolation, expected_type=type_hints["enable_network_isolation"])
                check_type(argname="argument vpc_config", value=vpc_config, expected_type=type_hints["vpc_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if enable_inter_container_traffic_encryption is not None:
                self._values["enable_inter_container_traffic_encryption"] = enable_inter_container_traffic_encryption
            if enable_network_isolation is not None:
                self._values["enable_network_isolation"] = enable_network_isolation
            if vpc_config is not None:
                self._values["vpc_config"] = vpc_config

        @builtins.property
        def enable_inter_container_traffic_encryption(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''Whether to encrypt all communications between distributed processing jobs.

            Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-enableintercontainertrafficencryption
            '''
            result = self._values.get("enable_inter_container_traffic_encryption")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        @builtins.property
        def enable_network_isolation(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''Whether to allow inbound and outbound network calls to and from the containers used for the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-enablenetworkisolation
            '''
            result = self._values.get("enable_network_isolation")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        @builtins.property
        def vpc_config(
            self,
        ) -> typing.Optional[typing.Union["CfnDataQualityJobDefinition.VpcConfigProperty", _IResolvable_a771d0ef]]:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-vpcconfig
            '''
            result = self._values.get("vpc_config")
            return typing.cast(typing.Optional[typing.Union["CfnDataQualityJobDefinition.VpcConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NetworkConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.S3OutputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "local_path": "localPath",
            "s3_uri": "s3Uri",
            "s3_upload_mode": "s3UploadMode",
        },
    )
    class S3OutputProperty:
        def __init__(
            self,
            *,
            local_path: builtins.str,
            s3_uri: builtins.str,
            s3_upload_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :param local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
            :param s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
            :param s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                s3_output_property = sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                    local_path="localPath",
                    s3_uri="s3Uri",
                
                    # the properties below are optional
                    s3_upload_mode="s3UploadMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__43b5f91f65249842dde0a761218bfbbdf6170eeeee1729167931b6e9d9e41392)
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
                check_type(argname="argument s3_upload_mode", value=s3_upload_mode, expected_type=type_hints["s3_upload_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "local_path": local_path,
                "s3_uri": s3_uri,
            }
            if s3_upload_mode is not None:
                self._values["s3_upload_mode"] = s3_upload_mode

        @builtins.property
        def local_path(self) -> builtins.str:
            '''The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            LocalPath is an absolute path for the output data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_uri(self) -> builtins.str:
            '''A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-s3uri
            '''
            result = self._values.get("s3_uri")
            assert result is not None, "Required property 's3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_upload_mode(self) -> typing.Optional[builtins.str]:
            '''Whether to upload the results of the monitoring job continuously or after the job completes.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-s3uploadmode
            '''
            result = self._values.get("s3_upload_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "S3OutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri"},
    )
    class StatisticsResourceProperty:
        def __init__(self, *, s3_uri: typing.Optional[builtins.str] = None) -> None:
            '''The statistics resource for a monitoring job.

            :param s3_uri: The Amazon S3 URI for the statistics resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-statisticsresource.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                statistics_resource_property = sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                    s3_uri="s3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__83f4520f4f2998dfba7d3e47c479674eb86c2df8e599227013627cb9b6583c5c)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if s3_uri is not None:
                self._values["s3_uri"] = s3_uri

        @builtins.property
        def s3_uri(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 URI for the statistics resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-statisticsresource.html#cfn-sagemaker-dataqualityjobdefinition-statisticsresource-s3uri
            '''
            result = self._values.get("s3_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StatisticsResourceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"max_runtime_in_seconds": "maxRuntimeInSeconds"},
    )
    class StoppingConditionProperty:
        def __init__(self, *, max_runtime_in_seconds: jsii.Number) -> None:
            '''Specifies a limit to how long a model training job or model compilation job can run.

            It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training or compilation job. Use this API to cap model training costs.

            To stop a training job, SageMaker sends the algorithm the ``SIGTERM`` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.

            The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with ``CreateModel`` .
            .. epigraph::

               The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.

            :param max_runtime_in_seconds: The maximum length of time, in seconds, that a training or compilation job can run before it is stopped. For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model. For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days. The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-stoppingcondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                stopping_condition_property = sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__19bc9899871d6a41680d9ad8520faf0bc06fa0c127d2d9ee7f4deff376c4d71b)
                check_type(argname="argument max_runtime_in_seconds", value=max_runtime_in_seconds, expected_type=type_hints["max_runtime_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "max_runtime_in_seconds": max_runtime_in_seconds,
            }

        @builtins.property
        def max_runtime_in_seconds(self) -> jsii.Number:
            '''The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.

            For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.

            For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.

            The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-stoppingcondition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition-maxruntimeinseconds
            '''
            result = self._values.get("max_runtime_in_seconds")
            assert result is not None, "Required property 'max_runtime_in_seconds' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StoppingConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"security_group_ids": "securityGroupIds", "subnets": "subnets"},
    )
    class VpcConfigProperty:
        def __init__(
            self,
            *,
            security_group_ids: typing.Sequence[builtins.str],
            subnets: typing.Sequence[builtins.str],
        ) -> None:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC. For more information, see `Protect Endpoints by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html>`_ and `Protect Training Jobs by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html>`_ .

            :param security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the ``Subnets`` field.
            :param subnets: The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                vpc_config_property = sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4be6c6eccc99abadc44d721bc393a472831db47c3fb06a22d3ed1c1da22d6cdf)
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
                check_type(argname="argument subnets", value=subnets, expected_type=type_hints["subnets"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "security_group_ids": security_group_ids,
                "subnets": subnets,
            }

        @builtins.property
        def security_group_ids(self) -> typing.List[builtins.str]:
            '''The VPC security group IDs, in the form sg-xxxxxxxx.

            Specify the security groups for the VPC that is specified in the ``Subnets`` field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html#cfn-sagemaker-dataqualityjobdefinition-vpcconfig-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            assert result is not None, "Required property 'security_group_ids' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def subnets(self) -> typing.List[builtins.str]:
            '''The ID of the subnets in the VPC to which you want to connect your training job or model.

            For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html#cfn-sagemaker-dataqualityjobdefinition-vpcconfig-subnets
            '''
            result = self._values.get("subnets")
            assert result is not None, "Required property 'subnets' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VpcConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnDataQualityJobDefinitionProps",
    jsii_struct_bases=[],
    name_mapping={
        "data_quality_app_specification": "dataQualityAppSpecification",
        "data_quality_job_input": "dataQualityJobInput",
        "data_quality_job_output_config": "dataQualityJobOutputConfig",
        "job_resources": "jobResources",
        "role_arn": "roleArn",
        "data_quality_baseline_config": "dataQualityBaselineConfig",
        "endpoint_name": "endpointName",
        "job_definition_name": "jobDefinitionName",
        "network_config": "networkConfig",
        "stopping_condition": "stoppingCondition",
        "tags": "tags",
    },
)
class CfnDataQualityJobDefinitionProps:
    def __init__(
        self,
        *,
        data_quality_app_specification: typing.Union[typing.Union[CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        data_quality_job_input: typing.Union[typing.Union[CfnDataQualityJobDefinition.DataQualityJobInputProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        data_quality_job_output_config: typing.Union[typing.Union[CfnDataQualityJobDefinition.MonitoringOutputConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        job_resources: typing.Union[typing.Union[CfnDataQualityJobDefinition.MonitoringResourcesProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        role_arn: builtins.str,
        data_quality_baseline_config: typing.Optional[typing.Union[typing.Union[CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        network_config: typing.Optional[typing.Union[typing.Union[CfnDataQualityJobDefinition.NetworkConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        stopping_condition: typing.Optional[typing.Union[typing.Union[CfnDataQualityJobDefinition.StoppingConditionProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDataQualityJobDefinition``.

        :param data_quality_app_specification: Specifies the container that runs the monitoring job.
        :param data_quality_job_input: A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.
        :param data_quality_job_output_config: The output configuration for monitoring jobs.
        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param data_quality_baseline_config: Configures the constraints and baselines for the monitoring job.
        :param endpoint_name: ``AWS::SageMaker::DataQualityJobDefinition.EndpointName``.
        :param job_definition_name: The name for the monitoring job definition.
        :param network_config: Specifies networking configuration for the monitoring job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            # json: Any
            
            cfn_data_quality_job_definition_props = sagemaker.CfnDataQualityJobDefinitionProps(
                data_quality_app_specification=sagemaker.CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty(
                    image_uri="imageUri",
            
                    # the properties below are optional
                    container_arguments=["containerArguments"],
                    container_entrypoint=["containerEntrypoint"],
                    environment={
                        "environment_key": "environment"
                    },
                    post_analytics_processor_source_uri="postAnalyticsProcessorSourceUri",
                    record_preprocessor_source_uri="recordPreprocessorSourceUri"
                ),
                data_quality_job_input=sagemaker.CfnDataQualityJobDefinition.DataQualityJobInputProperty(
                    batch_transform_input=sagemaker.CfnDataQualityJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnDataQualityJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnDataQualityJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=json,
                            parquet=False
                        ),
                        local_path="localPath",
            
                        # the properties below are optional
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    ),
                    endpoint_input=sagemaker.CfnDataQualityJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
            
                        # the properties below are optional
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    )
                ),
                data_quality_job_output_config=sagemaker.CfnDataQualityJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnDataQualityJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnDataQualityJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
            
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
            
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                ),
                job_resources=sagemaker.CfnDataQualityJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnDataQualityJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
            
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                ),
                role_arn="roleArn",
            
                # the properties below are optional
                data_quality_baseline_config=sagemaker.CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnDataQualityJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    ),
                    statistics_resource=sagemaker.CfnDataQualityJobDefinition.StatisticsResourceProperty(
                        s3_uri="s3Uri"
                    )
                ),
                endpoint_name="endpointName",
                job_definition_name="jobDefinitionName",
                network_config=sagemaker.CfnDataQualityJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnDataQualityJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                ),
                stopping_condition=sagemaker.CfnDataQualityJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc49352eaf9bb69de57b8fcf69304d748115d99cad6508b0896f90cfa10befd9)
            check_type(argname="argument data_quality_app_specification", value=data_quality_app_specification, expected_type=type_hints["data_quality_app_specification"])
            check_type(argname="argument data_quality_job_input", value=data_quality_job_input, expected_type=type_hints["data_quality_job_input"])
            check_type(argname="argument data_quality_job_output_config", value=data_quality_job_output_config, expected_type=type_hints["data_quality_job_output_config"])
            check_type(argname="argument job_resources", value=job_resources, expected_type=type_hints["job_resources"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument data_quality_baseline_config", value=data_quality_baseline_config, expected_type=type_hints["data_quality_baseline_config"])
            check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
            check_type(argname="argument job_definition_name", value=job_definition_name, expected_type=type_hints["job_definition_name"])
            check_type(argname="argument network_config", value=network_config, expected_type=type_hints["network_config"])
            check_type(argname="argument stopping_condition", value=stopping_condition, expected_type=type_hints["stopping_condition"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "data_quality_app_specification": data_quality_app_specification,
            "data_quality_job_input": data_quality_job_input,
            "data_quality_job_output_config": data_quality_job_output_config,
            "job_resources": job_resources,
            "role_arn": role_arn,
        }
        if data_quality_baseline_config is not None:
            self._values["data_quality_baseline_config"] = data_quality_baseline_config
        if endpoint_name is not None:
            self._values["endpoint_name"] = endpoint_name
        if job_definition_name is not None:
            self._values["job_definition_name"] = job_definition_name
        if network_config is not None:
            self._values["network_config"] = network_config
        if stopping_condition is not None:
            self._values["stopping_condition"] = stopping_condition
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def data_quality_app_specification(
        self,
    ) -> typing.Union[CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty, _IResolvable_a771d0ef]:
        '''Specifies the container that runs the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification
        '''
        result = self._values.get("data_quality_app_specification")
        assert result is not None, "Required property 'data_quality_app_specification' is missing"
        return typing.cast(typing.Union[CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def data_quality_job_input(
        self,
    ) -> typing.Union[CfnDataQualityJobDefinition.DataQualityJobInputProperty, _IResolvable_a771d0ef]:
        '''A list of inputs for the monitoring job.

        Currently endpoints are supported as monitoring inputs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput
        '''
        result = self._values.get("data_quality_job_input")
        assert result is not None, "Required property 'data_quality_job_input' is missing"
        return typing.cast(typing.Union[CfnDataQualityJobDefinition.DataQualityJobInputProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def data_quality_job_output_config(
        self,
    ) -> typing.Union[CfnDataQualityJobDefinition.MonitoringOutputConfigProperty, _IResolvable_a771d0ef]:
        '''The output configuration for monitoring jobs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjoboutputconfig
        '''
        result = self._values.get("data_quality_job_output_config")
        assert result is not None, "Required property 'data_quality_job_output_config' is missing"
        return typing.cast(typing.Union[CfnDataQualityJobDefinition.MonitoringOutputConfigProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def job_resources(
        self,
    ) -> typing.Union[CfnDataQualityJobDefinition.MonitoringResourcesProperty, _IResolvable_a771d0ef]:
        '''Identifies the resources to deploy for a monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobresources
        '''
        result = self._values.get("job_resources")
        assert result is not None, "Required property 'job_resources' is missing"
        return typing.cast(typing.Union[CfnDataQualityJobDefinition.MonitoringResourcesProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-rolearn
        '''
        result = self._values.get("role_arn")
        assert result is not None, "Required property 'role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def data_quality_baseline_config(
        self,
    ) -> typing.Optional[typing.Union[CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty, _IResolvable_a771d0ef]]:
        '''Configures the constraints and baselines for the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig
        '''
        result = self._values.get("data_quality_baseline_config")
        return typing.cast(typing.Optional[typing.Union[CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''``AWS::SageMaker::DataQualityJobDefinition.EndpointName``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-endpointname
        '''
        result = self._values.get("endpoint_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name for the monitoring job definition.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobdefinitionname
        '''
        result = self._values.get("job_definition_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def network_config(
        self,
    ) -> typing.Optional[typing.Union[CfnDataQualityJobDefinition.NetworkConfigProperty, _IResolvable_a771d0ef]]:
        '''Specifies networking configuration for the monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig
        '''
        result = self._values.get("network_config")
        return typing.cast(typing.Optional[typing.Union[CfnDataQualityJobDefinition.NetworkConfigProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union[CfnDataQualityJobDefinition.StoppingConditionProperty, _IResolvable_a771d0ef]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition
        '''
        result = self._values.get("stopping_condition")
        return typing.cast(typing.Optional[typing.Union[CfnDataQualityJobDefinition.StoppingConditionProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDataQualityJobDefinitionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnDevice(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnDevice",
):
    '''A CloudFormation ``AWS::SageMaker::Device``.

    The ``AWS::SageMaker::Device`` resource is an Amazon SageMaker resource type that allows you to register your Devices against an existing SageMaker Edge Manager DeviceFleet. Each device must be listed individually in the CFN specification.

    :cloudformationResource: AWS::SageMaker::Device
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        cfn_device = sagemaker.CfnDevice(self, "MyCfnDevice",
            device_fleet_name="deviceFleetName",
        
            # the properties below are optional
            device=sagemaker.CfnDevice.DeviceProperty(
                device_name="deviceName",
        
                # the properties below are optional
                description="description",
                iot_thing_name="iotThingName"
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        device_fleet_name: builtins.str,
        device: typing.Optional[typing.Union[typing.Union["CfnDevice.DeviceProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::Device``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param device_fleet_name: The name of the fleet the device belongs to.
        :param device: Edge device you want to create.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your devices. Each tag consists of a key and a value, both of which you define.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b66269cf0c4d14edf671ad157da7f22bdb0bc7b2086aabf8030a9fa8161545c)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDeviceProps(
            device_fleet_name=device_fleet_name, device=device, tags=tags
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d305206df0a83ee639e4e09d4bfe91e327fc10e2a9a8ffdede7064bfbee9592)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aa8fe3c3b1870a5c5c16447ed2abe3c3c227e35faeaaf840c3b69132f2e54721)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your devices.

        Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="deviceFleetName")
    def device_fleet_name(self) -> builtins.str:
        '''The name of the fleet the device belongs to.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-devicefleetname
        '''
        return typing.cast(builtins.str, jsii.get(self, "deviceFleetName"))

    @device_fleet_name.setter
    def device_fleet_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c12a09d74c5f270082deaaa7fed2846b9c607d1e24733b2ec9a488b95996704)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "deviceFleetName", value)

    @builtins.property
    @jsii.member(jsii_name="device")
    def device(
        self,
    ) -> typing.Optional[typing.Union["CfnDevice.DeviceProperty", _IResolvable_a771d0ef]]:
        '''Edge device you want to create.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-device
        '''
        return typing.cast(typing.Optional[typing.Union["CfnDevice.DeviceProperty", _IResolvable_a771d0ef]], jsii.get(self, "device"))

    @device.setter
    def device(
        self,
        value: typing.Optional[typing.Union["CfnDevice.DeviceProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2bcf905e8e4accaac3a024a547fb22ab504f00f766ac697b92e15f591adb5a77)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "device", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDevice.DeviceProperty",
        jsii_struct_bases=[],
        name_mapping={
            "device_name": "deviceName",
            "description": "description",
            "iot_thing_name": "iotThingName",
        },
    )
    class DeviceProperty:
        def __init__(
            self,
            *,
            device_name: builtins.str,
            description: typing.Optional[builtins.str] = None,
            iot_thing_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Information of a particular device.

            :param device_name: The name of the device.
            :param description: Description of the device.
            :param iot_thing_name: AWS Internet of Things (IoT) object name.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                device_property = sagemaker.CfnDevice.DeviceProperty(
                    device_name="deviceName",
                
                    # the properties below are optional
                    description="description",
                    iot_thing_name="iotThingName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__db48b1b64d2d61de17c6ff5bdd4434f0965fe946c8e58419d6a1d085e40e52fd)
                check_type(argname="argument device_name", value=device_name, expected_type=type_hints["device_name"])
                check_type(argname="argument description", value=description, expected_type=type_hints["description"])
                check_type(argname="argument iot_thing_name", value=iot_thing_name, expected_type=type_hints["iot_thing_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "device_name": device_name,
            }
            if description is not None:
                self._values["description"] = description
            if iot_thing_name is not None:
                self._values["iot_thing_name"] = iot_thing_name

        @builtins.property
        def device_name(self) -> builtins.str:
            '''The name of the device.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-devicename
            '''
            result = self._values.get("device_name")
            assert result is not None, "Required property 'device_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def description(self) -> typing.Optional[builtins.str]:
            '''Description of the device.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-description
            '''
            result = self._values.get("description")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def iot_thing_name(self) -> typing.Optional[builtins.str]:
            '''AWS Internet of Things (IoT) object name.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-iotthingname
            '''
            result = self._values.get("iot_thing_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DeviceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_82c04a63)
class CfnDeviceFleet(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnDeviceFleet",
):
    '''A CloudFormation ``AWS::SageMaker::DeviceFleet``.

    The ``AWS::SageMaker::DeviceFleet`` resource is an Amazon SageMaker resource type that allows you to create a DeviceFleet that manages your SageMaker Edge Manager Devices. You must register your devices against the ``DeviceFleet`` separately.

    :cloudformationResource: AWS::SageMaker::DeviceFleet
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        cfn_device_fleet = sagemaker.CfnDeviceFleet(self, "MyCfnDeviceFleet",
            device_fleet_name="deviceFleetName",
            output_config=sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty(
                s3_output_location="s3OutputLocation",
        
                # the properties below are optional
                kms_key_id="kmsKeyId"
            ),
            role_arn="roleArn",
        
            # the properties below are optional
            description="description",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        device_fleet_name: builtins.str,
        output_config: typing.Union[typing.Union["CfnDeviceFleet.EdgeOutputConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        role_arn: builtins.str,
        description: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::DeviceFleet``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param device_fleet_name: Name of the device fleet.
        :param output_config: The output configuration for storing sample data collected by the fleet.
        :param role_arn: The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
        :param description: A description of the fleet.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your device fleets. Each tag consists of a key and a value, both of which you define.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f85d3a971bfe5dc9d72fac9b2c134d8dd2bc5d2af9a028fdc052633026fea1b4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDeviceFleetProps(
            device_fleet_name=device_fleet_name,
            output_config=output_config,
            role_arn=role_arn,
            description=description,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2495c3a90295fd48192cebe99801a7621f793bf1b3da0fb024cd8caa06736509)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e785f0858beb00d7fe5e02fbb01f32f778d6db4c768ba0eed35eea94258675c4)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your device fleets.

        Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="deviceFleetName")
    def device_fleet_name(self) -> builtins.str:
        '''Name of the device fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-devicefleetname
        '''
        return typing.cast(builtins.str, jsii.get(self, "deviceFleetName"))

    @device_fleet_name.setter
    def device_fleet_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7812ab1c9cd8a2e6fed8240e40d722396f62817e798da85a381754b68988f304)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "deviceFleetName", value)

    @builtins.property
    @jsii.member(jsii_name="outputConfig")
    def output_config(
        self,
    ) -> typing.Union["CfnDeviceFleet.EdgeOutputConfigProperty", _IResolvable_a771d0ef]:
        '''The output configuration for storing sample data collected by the fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-outputconfig
        '''
        return typing.cast(typing.Union["CfnDeviceFleet.EdgeOutputConfigProperty", _IResolvable_a771d0ef], jsii.get(self, "outputConfig"))

    @output_config.setter
    def output_config(
        self,
        value: typing.Union["CfnDeviceFleet.EdgeOutputConfigProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2d738d57350c92f8beda89c6d7ef46c5939d80a2d02dcd174afcf642803f0209)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "outputConfig", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-rolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c75410da26071d03ff9d7ccde80413ccf2c5e2375b299bb3ef958e9cb6cf55e7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c702912434874e63fa25402b57eed7c06d6b9ea4c8e08277d65a76a8b6a813fe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "s3_output_location": "s3OutputLocation",
            "kms_key_id": "kmsKeyId",
        },
    )
    class EdgeOutputConfigProperty:
        def __init__(
            self,
            *,
            s3_output_location: builtins.str,
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The output configuration for storing sample data collected by the fleet.

            :param s3_output_location: The Amazon Simple Storage (S3) bucket URI.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                edge_output_config_property = sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty(
                    s3_output_location="s3OutputLocation",
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__673fb808ff0aa893bed857524a53c4a994ab37b371eace31e28449f4788159de)
                check_type(argname="argument s3_output_location", value=s3_output_location, expected_type=type_hints["s3_output_location"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_output_location": s3_output_location,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def s3_output_location(self) -> builtins.str:
            '''The Amazon Simple Storage (S3) bucket URI.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html#cfn-sagemaker-devicefleet-edgeoutputconfig-s3outputlocation
            '''
            result = self._values.get("s3_output_location")
            assert result is not None, "Required property 's3_output_location' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job.

            If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html#cfn-sagemaker-devicefleet-edgeoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EdgeOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnDeviceFleetProps",
    jsii_struct_bases=[],
    name_mapping={
        "device_fleet_name": "deviceFleetName",
        "output_config": "outputConfig",
        "role_arn": "roleArn",
        "description": "description",
        "tags": "tags",
    },
)
class CfnDeviceFleetProps:
    def __init__(
        self,
        *,
        device_fleet_name: builtins.str,
        output_config: typing.Union[typing.Union[CfnDeviceFleet.EdgeOutputConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        role_arn: builtins.str,
        description: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDeviceFleet``.

        :param device_fleet_name: Name of the device fleet.
        :param output_config: The output configuration for storing sample data collected by the fleet.
        :param role_arn: The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).
        :param description: A description of the fleet.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your device fleets. Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            cfn_device_fleet_props = sagemaker.CfnDeviceFleetProps(
                device_fleet_name="deviceFleetName",
                output_config=sagemaker.CfnDeviceFleet.EdgeOutputConfigProperty(
                    s3_output_location="s3OutputLocation",
            
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                ),
                role_arn="roleArn",
            
                # the properties below are optional
                description="description",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1ef060738f9210d364320f10521aaf3ecc59e638e641b6fa112a5f27648d2e15)
            check_type(argname="argument device_fleet_name", value=device_fleet_name, expected_type=type_hints["device_fleet_name"])
            check_type(argname="argument output_config", value=output_config, expected_type=type_hints["output_config"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "device_fleet_name": device_fleet_name,
            "output_config": output_config,
            "role_arn": role_arn,
        }
        if description is not None:
            self._values["description"] = description
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def device_fleet_name(self) -> builtins.str:
        '''Name of the device fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-devicefleetname
        '''
        result = self._values.get("device_fleet_name")
        assert result is not None, "Required property 'device_fleet_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def output_config(
        self,
    ) -> typing.Union[CfnDeviceFleet.EdgeOutputConfigProperty, _IResolvable_a771d0ef]:
        '''The output configuration for storing sample data collected by the fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-outputconfig
        '''
        result = self._values.get("output_config")
        assert result is not None, "Required property 'output_config' is missing"
        return typing.cast(typing.Union[CfnDeviceFleet.EdgeOutputConfigProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) that has access to AWS Internet of Things (IoT).

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-rolearn
        '''
        result = self._values.get("role_arn")
        assert result is not None, "Required property 'role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A description of the fleet.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your device fleets.

        Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDeviceFleetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnDeviceProps",
    jsii_struct_bases=[],
    name_mapping={
        "device_fleet_name": "deviceFleetName",
        "device": "device",
        "tags": "tags",
    },
)
class CfnDeviceProps:
    def __init__(
        self,
        *,
        device_fleet_name: builtins.str,
        device: typing.Optional[typing.Union[typing.Union[CfnDevice.DeviceProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDevice``.

        :param device_fleet_name: The name of the fleet the device belongs to.
        :param device: Edge device you want to create.
        :param tags: An array of key-value pairs that contain metadata to help you categorize and organize your devices. Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            cfn_device_props = sagemaker.CfnDeviceProps(
                device_fleet_name="deviceFleetName",
            
                # the properties below are optional
                device=sagemaker.CfnDevice.DeviceProperty(
                    device_name="deviceName",
            
                    # the properties below are optional
                    description="description",
                    iot_thing_name="iotThingName"
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c684838b1c53c8f853cd7eb0a727afe9e8341f26efec8d3780334250f1f0361a)
            check_type(argname="argument device_fleet_name", value=device_fleet_name, expected_type=type_hints["device_fleet_name"])
            check_type(argname="argument device", value=device, expected_type=type_hints["device"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "device_fleet_name": device_fleet_name,
        }
        if device is not None:
            self._values["device"] = device
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def device_fleet_name(self) -> builtins.str:
        '''The name of the fleet the device belongs to.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-devicefleetname
        '''
        result = self._values.get("device_fleet_name")
        assert result is not None, "Required property 'device_fleet_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def device(
        self,
    ) -> typing.Optional[typing.Union[CfnDevice.DeviceProperty, _IResolvable_a771d0ef]]:
        '''Edge device you want to create.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-device
        '''
        result = self._values.get("device")
        return typing.cast(typing.Optional[typing.Union[CfnDevice.DeviceProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''An array of key-value pairs that contain metadata to help you categorize and organize your devices.

        Each tag consists of a key and a value, both of which you define.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDeviceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnDomain(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnDomain",
):
    '''A CloudFormation ``AWS::SageMaker::Domain``.

    Creates a ``Domain`` used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. An AWS account is limited to one domain per region. Users within a domain can share notebook files and other artifacts with each other.

    *EFS storage*

    When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.

    SageMaker uses the AWS Key Management Service ( AWS KMS) to encrypt the EFS volume attached to the domain with an AWS managed key by default. For more control, you can specify a customer managed key. For more information, see `Protect Data at Rest Using Encryption <https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html>`_ .

    *VPC configuration*

    All SageMaker Studio traffic between the domain and the EFS volume is through the specified VPC and subnets. For other Studio traffic, you can specify the ``AppNetworkAccessType`` parameter. ``AppNetworkAccessType`` corresponds to the network access type that you choose when you onboard to Studio. The following options are available:

    - ``PublicInternetOnly`` - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows internet access. This is the default value.
    - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway.

    When internet access is disabled, you won't be able to run a Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups allow outbound connections.
    .. epigraph::

       NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a SageMaker Studio app successfully.

    For more information, see `Connect SageMaker Studio Notebooks to Resources in a VPC <https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html>`_ .

    :cloudformationResource: AWS::SageMaker::Domain
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        cfn_domain = sagemaker.CfnDomain(self, "MyCfnDomain",
            auth_mode="authMode",
            default_user_settings=sagemaker.CfnDomain.UserSettingsProperty(
                execution_role="executionRole",
                jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                ),
                kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
        
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                ),
                r_session_app_settings=sagemaker.CfnDomain.RSessionAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
        
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                ),
                r_studio_server_pro_app_settings=sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                    access_status="accessStatus",
                    user_group="userGroup"
                ),
                security_groups=["securityGroups"],
                sharing_settings=sagemaker.CfnDomain.SharingSettingsProperty(
                    notebook_output_option="notebookOutputOption",
                    s3_kms_key_id="s3KmsKeyId",
                    s3_output_path="s3OutputPath"
                )
            ),
            domain_name="domainName",
            subnet_ids=["subnetIds"],
            vpc_id="vpcId",
        
            # the properties below are optional
            app_network_access_type="appNetworkAccessType",
            app_security_group_management="appSecurityGroupManagement",
            domain_settings=sagemaker.CfnDomain.DomainSettingsProperty(
                r_studio_server_pro_domain_settings=sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                    domain_execution_role_arn="domainExecutionRoleArn",
        
                    # the properties below are optional
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    r_studio_connect_url="rStudioConnectUrl",
                    r_studio_package_manager_url="rStudioPackageManagerUrl"
                ),
                security_group_ids=["securityGroupIds"]
            ),
            kms_key_id="kmsKeyId",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        auth_mode: builtins.str,
        default_user_settings: typing.Union[typing.Union["CfnDomain.UserSettingsProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        domain_name: builtins.str,
        subnet_ids: typing.Sequence[builtins.str],
        vpc_id: builtins.str,
        app_network_access_type: typing.Optional[builtins.str] = None,
        app_security_group_management: typing.Optional[builtins.str] = None,
        domain_settings: typing.Optional[typing.Union[typing.Union["CfnDomain.DomainSettingsProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::Domain``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param auth_mode: The mode of authentication that members use to access the Domain. *Valid Values* : ``SSO | IAM``
        :param default_user_settings: The default user settings.
        :param domain_name: The domain name.
        :param subnet_ids: The VPC subnets that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Array members* : Minimum number of 1 item. Maximum number of 16 items. *Pattern* : ``[-0-9a-zA-Z]+``
        :param vpc_id: The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Pattern* : ``[-0-9a-zA-Z]+``
        :param app_network_access_type: Specifies the VPC used for non-EFS traffic. The default value is ``PublicInternetOnly`` . - ``PublicInternetOnly`` - Non-EFS traffic is through a VPC managed by Amazon SageMaker , which allows direct internet access - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets *Valid Values* : ``PublicInternetOnly | VpcOnly``
        :param app_security_group_management: The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode. Required when ``CreateDomain.AppNetworkAccessType`` is ``VpcOnly`` and ``DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`` is provided.
        :param domain_settings: A collection of settings that apply to the ``SageMaker Domain`` . These settings are specified through the ``CreateDomain`` API call.
        :param kms_key_id: SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default. For more control, specify a customer managed CMK. *Length Constraints* : Maximum length of 2048. *Pattern* : ``.*``
        :param tags: Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. Tags that you specify for the Domain are also added to all apps that are launched in the Domain. *Array members* : Minimum number of 0 items. Maximum number of 50 items.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dca474f718fa68eb348dd386d1d252ca2f7de16f1917e2bdbdc17f32633e27a4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnDomainProps(
            auth_mode=auth_mode,
            default_user_settings=default_user_settings,
            domain_name=domain_name,
            subnet_ids=subnet_ids,
            vpc_id=vpc_id,
            app_network_access_type=app_network_access_type,
            app_security_group_management=app_security_group_management,
            domain_settings=domain_settings,
            kms_key_id=kms_key_id,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c2ab7d0d2082acc2c4637cc74e4c826ecc7fccf57bde7c0a0ed78f3c06a5ef9)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e7c6bf05e0e5e277a9b62589165375adbd311825729aecb2778cbdb6448e77d3)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrDomainArn")
    def attr_domain_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the Domain, such as ``arn:aws:sagemaker:us-west-2:account-id:domain/my-domain-name`` .

        :cloudformationAttribute: DomainArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrDomainArn"))

    @builtins.property
    @jsii.member(jsii_name="attrDomainId")
    def attr_domain_id(self) -> builtins.str:
        '''The Domain ID.

        :cloudformationAttribute: DomainId
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrDomainId"))

    @builtins.property
    @jsii.member(jsii_name="attrHomeEfsFileSystemId")
    def attr_home_efs_file_system_id(self) -> builtins.str:
        '''The ID of the Amazon Elastic File System (EFS) managed by this Domain.

        :cloudformationAttribute: HomeEfsFileSystemId
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrHomeEfsFileSystemId"))

    @builtins.property
    @jsii.member(jsii_name="attrSecurityGroupIdForDomainBoundary")
    def attr_security_group_id_for_domain_boundary(self) -> builtins.str:
        '''The ID of the security group that authorizes traffic between the ``RSessionGateway`` apps and the ``RStudioServerPro`` app.

        :cloudformationAttribute: SecurityGroupIdForDomainBoundary
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrSecurityGroupIdForDomainBoundary"))

    @builtins.property
    @jsii.member(jsii_name="attrSingleSignOnManagedApplicationInstanceId")
    def attr_single_sign_on_managed_application_instance_id(self) -> builtins.str:
        '''The IAM Identity Center managed application instance ID.

        :cloudformationAttribute: SingleSignOnManagedApplicationInstanceId
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrSingleSignOnManagedApplicationInstanceId"))

    @builtins.property
    @jsii.member(jsii_name="attrUrl")
    def attr_url(self) -> builtins.str:
        '''The URL for the Domain.

        :cloudformationAttribute: Url
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrUrl"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''Tags to associated with the Domain.

        Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.

        Tags that you specify for the Domain are also added to all apps that are launched in the Domain.

        *Array members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="authMode")
    def auth_mode(self) -> builtins.str:
        '''The mode of authentication that members use to access the Domain.

        *Valid Values* : ``SSO | IAM``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-authmode
        '''
        return typing.cast(builtins.str, jsii.get(self, "authMode"))

    @auth_mode.setter
    def auth_mode(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__75b270d0793748a907ca37ce3a3dabe9963e8a95c10874b0291a1f61627f6b5f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "authMode", value)

    @builtins.property
    @jsii.member(jsii_name="defaultUserSettings")
    def default_user_settings(
        self,
    ) -> typing.Union["CfnDomain.UserSettingsProperty", _IResolvable_a771d0ef]:
        '''The default user settings.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings
        '''
        return typing.cast(typing.Union["CfnDomain.UserSettingsProperty", _IResolvable_a771d0ef], jsii.get(self, "defaultUserSettings"))

    @default_user_settings.setter
    def default_user_settings(
        self,
        value: typing.Union["CfnDomain.UserSettingsProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__483590b7ce6e34e502718d1b363e0ab3ef4d79fd101ded972c8b5dd6a0fd19da)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "defaultUserSettings", value)

    @builtins.property
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> builtins.str:
        '''The domain name.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname
        '''
        return typing.cast(builtins.str, jsii.get(self, "domainName"))

    @domain_name.setter
    def domain_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7a0afb2de2c5e57d4aad193734f388ef22c8c432e617f8dfdbe9e8f1147c9cc1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "domainName", value)

    @builtins.property
    @jsii.member(jsii_name="subnetIds")
    def subnet_ids(self) -> typing.List[builtins.str]:
        '''The VPC subnets that Studio uses for communication.

        *Length Constraints* : Maximum length of 32.

        *Array members* : Minimum number of 1 item. Maximum number of 16 items.

        *Pattern* : ``[-0-9a-zA-Z]+``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-subnetids
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "subnetIds"))

    @subnet_ids.setter
    def subnet_ids(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__56b54794a71cf87a4f78982c287d555726198a2bc7e477555a4d93b1a364c0f9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "subnetIds", value)

    @builtins.property
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> builtins.str:
        '''The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication.

        *Length Constraints* : Maximum length of 32.

        *Pattern* : ``[-0-9a-zA-Z]+``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-vpcid
        '''
        return typing.cast(builtins.str, jsii.get(self, "vpcId"))

    @vpc_id.setter
    def vpc_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b95ca6823e55239d4cf251e07a0aeae39dfb6e5a1e88da6c2a21b893d0ffc5bd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vpcId", value)

    @builtins.property
    @jsii.member(jsii_name="appNetworkAccessType")
    def app_network_access_type(self) -> typing.Optional[builtins.str]:
        '''Specifies the VPC used for non-EFS traffic. The default value is ``PublicInternetOnly`` .

        - ``PublicInternetOnly`` - Non-EFS traffic is through a VPC managed by Amazon SageMaker , which allows direct internet access
        - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets

        *Valid Values* : ``PublicInternetOnly | VpcOnly``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appnetworkaccesstype
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "appNetworkAccessType"))

    @app_network_access_type.setter
    def app_network_access_type(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74c7c2e7c61221e7d1ec9cd2a256dfe01a9dd3fc85316c2b3c7bf1aa31f7cdbf)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appNetworkAccessType", value)

    @builtins.property
    @jsii.member(jsii_name="appSecurityGroupManagement")
    def app_security_group_management(self) -> typing.Optional[builtins.str]:
        '''The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode.

        Required when ``CreateDomain.AppNetworkAccessType`` is ``VpcOnly`` and ``DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`` is provided.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appsecuritygroupmanagement
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "appSecurityGroupManagement"))

    @app_security_group_management.setter
    def app_security_group_management(
        self,
        value: typing.Optional[builtins.str],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d317372ad37d256e6aa3b2c4f0b96a5ddfa1463b416bab686069cea5c9975de2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "appSecurityGroupManagement", value)

    @builtins.property
    @jsii.member(jsii_name="domainSettings")
    def domain_settings(
        self,
    ) -> typing.Optional[typing.Union["CfnDomain.DomainSettingsProperty", _IResolvable_a771d0ef]]:
        '''A collection of settings that apply to the ``SageMaker Domain`` .

        These settings are specified through the ``CreateDomain`` API call.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainsettings
        '''
        return typing.cast(typing.Optional[typing.Union["CfnDomain.DomainSettingsProperty", _IResolvable_a771d0ef]], jsii.get(self, "domainSettings"))

    @domain_settings.setter
    def domain_settings(
        self,
        value: typing.Optional[typing.Union["CfnDomain.DomainSettingsProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__446fbeaaabd983d342a5968e28cdf3bd00f5e215f8699c41f19ad5840e0a43fa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "domainSettings", value)

    @builtins.property
    @jsii.member(jsii_name="kmsKeyId")
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.

        For more control, specify a customer managed CMK.

        *Length Constraints* : Maximum length of 2048.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-kmskeyid
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "kmsKeyId"))

    @kms_key_id.setter
    def kms_key_id(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4673684b46cb7de8ea9222aef246a1847a8472d26cd72f527c9e63d1c3817bc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "kmsKeyId", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDomain.CustomImageProperty",
        jsii_struct_bases=[],
        name_mapping={
            "app_image_config_name": "appImageConfigName",
            "image_name": "imageName",
            "image_version_number": "imageVersionNumber",
        },
    )
    class CustomImageProperty:
        def __init__(
            self,
            *,
            app_image_config_name: builtins.str,
            image_name: builtins.str,
            image_version_number: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''A custom SageMaker image.

            For more information, see `Bring your own SageMaker image <https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html>`_ .

            :param app_image_config_name: The name of the AppImageConfig.
            :param image_name: The name of the CustomImage. Must be unique to your account.
            :param image_version_number: The version number of the CustomImage.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                custom_image_property = sagemaker.CfnDomain.CustomImageProperty(
                    app_image_config_name="appImageConfigName",
                    image_name="imageName",
                
                    # the properties below are optional
                    image_version_number=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__85c78e1c190a69e5148bd9a797033f4e3ec5ee986db49693e0e8394e5b3967bf)
                check_type(argname="argument app_image_config_name", value=app_image_config_name, expected_type=type_hints["app_image_config_name"])
                check_type(argname="argument image_name", value=image_name, expected_type=type_hints["image_name"])
                check_type(argname="argument image_version_number", value=image_version_number, expected_type=type_hints["image_version_number"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "app_image_config_name": app_image_config_name,
                "image_name": image_name,
            }
            if image_version_number is not None:
                self._values["image_version_number"] = image_version_number

        @builtins.property
        def app_image_config_name(self) -> builtins.str:
            '''The name of the AppImageConfig.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-appimageconfigname
            '''
            result = self._values.get("app_image_config_name")
            assert result is not None, "Required property 'app_image_config_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def image_name(self) -> builtins.str:
            '''The name of the CustomImage.

            Must be unique to your account.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imagename
            '''
            result = self._values.get("image_name")
            assert result is not None, "Required property 'image_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def image_version_number(self) -> typing.Optional[jsii.Number]:
            '''The version number of the CustomImage.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-customimage.html#cfn-sagemaker-domain-customimage-imageversionnumber
            '''
            result = self._values.get("image_version_number")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CustomImageProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDomain.DomainSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "r_studio_server_pro_domain_settings": "rStudioServerProDomainSettings",
            "security_group_ids": "securityGroupIds",
        },
    )
    class DomainSettingsProperty:
        def __init__(
            self,
            *,
            r_studio_server_pro_domain_settings: typing.Optional[typing.Union[typing.Union["CfnDomain.RStudioServerProDomainSettingsProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            security_group_ids: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''A collection of settings that apply to the ``SageMaker Domain`` .

            These settings are specified through the ``CreateDomain`` API call.

            :param r_studio_server_pro_domain_settings: A collection of settings that configure the ``RStudioServerPro`` Domain-level app.
            :param security_group_ids: The security groups for the Amazon Virtual Private Cloud that the ``Domain`` uses for communication between Domain-level apps and user apps.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                domain_settings_property = sagemaker.CfnDomain.DomainSettingsProperty(
                    r_studio_server_pro_domain_settings=sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                        domain_execution_role_arn="domainExecutionRoleArn",
                
                        # the properties below are optional
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        r_studio_connect_url="rStudioConnectUrl",
                        r_studio_package_manager_url="rStudioPackageManagerUrl"
                    ),
                    security_group_ids=["securityGroupIds"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__19e5d113f98a083a16e88af8b1abe59c1a832bf2c9e4721fae79a39fc0947854)
                check_type(argname="argument r_studio_server_pro_domain_settings", value=r_studio_server_pro_domain_settings, expected_type=type_hints["r_studio_server_pro_domain_settings"])
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if r_studio_server_pro_domain_settings is not None:
                self._values["r_studio_server_pro_domain_settings"] = r_studio_server_pro_domain_settings
            if security_group_ids is not None:
                self._values["security_group_ids"] = security_group_ids

        @builtins.property
        def r_studio_server_pro_domain_settings(
            self,
        ) -> typing.Optional[typing.Union["CfnDomain.RStudioServerProDomainSettingsProperty", _IResolvable_a771d0ef]]:
            '''A collection of settings that configure the ``RStudioServerPro`` Domain-level app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-rstudioserverprodomainsettings
            '''
            result = self._values.get("r_studio_server_pro_domain_settings")
            return typing.cast(typing.Optional[typing.Union["CfnDomain.RStudioServerProDomainSettingsProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def security_group_ids(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The security groups for the Amazon Virtual Private Cloud that the ``Domain`` uses for communication between Domain-level apps and user apps.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-domainsettings.html#cfn-sagemaker-domain-domainsettings-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DomainSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDomain.JupyterServerAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"default_resource_spec": "defaultResourceSpec"},
    )
    class JupyterServerAppSettingsProperty:
        def __init__(
            self,
            *,
            default_resource_spec: typing.Optional[typing.Union[typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''The JupyterServer app settings.

            :param default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                jupyter_server_app_settings_property = sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3896ab8f74c31b59e4ae2396370aa0c26806c6fd6522c29246b12c62309da572)
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union["CfnDomain.ResourceSpecProperty", _IResolvable_a771d0ef]]:
            '''The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-jupyterserverappsettings.html#cfn-sagemaker-domain-jupyterserverappsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union["CfnDomain.ResourceSpecProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JupyterServerAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDomain.KernelGatewayAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "custom_images": "customImages",
            "default_resource_spec": "defaultResourceSpec",
        },
    )
    class KernelGatewayAppSettingsProperty:
        def __init__(
            self,
            *,
            custom_images: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnDomain.CustomImageProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
            default_resource_spec: typing.Optional[typing.Union[typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''The KernelGateway app settings.

            :param custom_images: A list of custom SageMaker images that are configured to run as a KernelGateway app.
            :param default_resource_spec: The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app. .. epigraph:: The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS Command Line Interface or AWS CloudFormation and the instance type parameter value is not passed.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                kernel_gateway_app_settings_property = sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
                
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a61929b748cbeca114abf186c3675501d2acc3c5f5deaec37ff1b9e4bfe90082)
                check_type(argname="argument custom_images", value=custom_images, expected_type=type_hints["custom_images"])
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_images is not None:
                self._values["custom_images"] = custom_images
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec

        @builtins.property
        def custom_images(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnDomain.CustomImageProperty", _IResolvable_a771d0ef]]]]:
            '''A list of custom SageMaker images that are configured to run as a KernelGateway app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-customimages
            '''
            result = self._values.get("custom_images")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnDomain.CustomImageProperty", _IResolvable_a771d0ef]]]], result)

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union["CfnDomain.ResourceSpecProperty", _IResolvable_a771d0ef]]:
            '''The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.

            .. epigraph::

               The Amazon SageMaker Studio UI does not use the default instance type value set here. The default instance type set here is used when Apps are created using the AWS Command Line Interface or AWS CloudFormation and the instance type parameter value is not passed.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-kernelgatewayappsettings.html#cfn-sagemaker-domain-kernelgatewayappsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union["CfnDomain.ResourceSpecProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "KernelGatewayAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDomain.RSessionAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "custom_images": "customImages",
            "default_resource_spec": "defaultResourceSpec",
        },
    )
    class RSessionAppSettingsProperty:
        def __init__(
            self,
            *,
            custom_images: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnDomain.CustomImageProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
            default_resource_spec: typing.Optional[typing.Union[typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''A collection of settings that apply to an ``RSessionGateway`` app.

            :param custom_images: A list of custom SageMaker images that are configured to run as a RSession app.
            :param default_resource_spec: Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                r_session_app_settings_property = sagemaker.CfnDomain.RSessionAppSettingsProperty(
                    custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                        app_image_config_name="appImageConfigName",
                        image_name="imageName",
                
                        # the properties below are optional
                        image_version_number=123
                    )],
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4fbc24b2e45f8b57442b7eb03871333ca7871fe5462e2b462d318cb107279324)
                check_type(argname="argument custom_images", value=custom_images, expected_type=type_hints["custom_images"])
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if custom_images is not None:
                self._values["custom_images"] = custom_images
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec

        @builtins.property
        def custom_images(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnDomain.CustomImageProperty", _IResolvable_a771d0ef]]]]:
            '''A list of custom SageMaker images that are configured to run as a RSession app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html#cfn-sagemaker-domain-rsessionappsettings-customimages
            '''
            result = self._values.get("custom_images")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnDomain.CustomImageProperty", _IResolvable_a771d0ef]]]], result)

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union["CfnDomain.ResourceSpecProperty", _IResolvable_a771d0ef]]:
            '''Specifies the ARNs of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rsessionappsettings.html#cfn-sagemaker-domain-rsessionappsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union["CfnDomain.ResourceSpecProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RSessionAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDomain.RStudioServerProAppSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"access_status": "accessStatus", "user_group": "userGroup"},
    )
    class RStudioServerProAppSettingsProperty:
        def __init__(
            self,
            *,
            access_status: typing.Optional[builtins.str] = None,
            user_group: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A collection of settings that configure user interaction with the ``RStudioServerPro`` app.

            ``RStudioServerProAppSettings`` cannot be updated. The ``RStudioServerPro`` app must be deleted and a new one created to make any changes.

            :param access_status: Indicates whether the current user has access to the ``RStudioServerPro`` app.
            :param user_group: The level of permissions that the user has within the ``RStudioServerPro`` app. This value defaults to ``User``. The ``Admin`` value allows the user access to the RStudio Administrative Dashboard.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                r_studio_server_pro_app_settings_property = sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                    access_status="accessStatus",
                    user_group="userGroup"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b06cd704e7ec51f5fb6c24c78525a6f506bcaa1fd4f47d4c18f7b0db4ebd4993)
                check_type(argname="argument access_status", value=access_status, expected_type=type_hints["access_status"])
                check_type(argname="argument user_group", value=user_group, expected_type=type_hints["user_group"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if access_status is not None:
                self._values["access_status"] = access_status
            if user_group is not None:
                self._values["user_group"] = user_group

        @builtins.property
        def access_status(self) -> typing.Optional[builtins.str]:
            '''Indicates whether the current user has access to the ``RStudioServerPro`` app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html#cfn-sagemaker-domain-rstudioserverproappsettings-accessstatus
            '''
            result = self._values.get("access_status")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def user_group(self) -> typing.Optional[builtins.str]:
            '''The level of permissions that the user has within the ``RStudioServerPro`` app.

            This value defaults to ``User``. The ``Admin`` value allows the user access to the RStudio Administrative Dashboard.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverproappsettings.html#cfn-sagemaker-domain-rstudioserverproappsettings-usergroup
            '''
            result = self._values.get("user_group")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RStudioServerProAppSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "domain_execution_role_arn": "domainExecutionRoleArn",
            "default_resource_spec": "defaultResourceSpec",
            "r_studio_connect_url": "rStudioConnectUrl",
            "r_studio_package_manager_url": "rStudioPackageManagerUrl",
        },
    )
    class RStudioServerProDomainSettingsProperty:
        def __init__(
            self,
            *,
            domain_execution_role_arn: builtins.str,
            default_resource_spec: typing.Optional[typing.Union[typing.Union["CfnDomain.ResourceSpecProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            r_studio_connect_url: typing.Optional[builtins.str] = None,
            r_studio_package_manager_url: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A collection of settings that configure the ``RStudioServerPro`` Domain-level app.

            :param domain_execution_role_arn: The ARN of the execution role for the ``RStudioServerPro`` Domain-level app.
            :param default_resource_spec: A collection that defines the default ``InstanceType`` , ``SageMakerImageArn`` , and ``SageMakerImageVersionArn`` for the Domain.
            :param r_studio_connect_url: A URL pointing to an RStudio Connect server.
            :param r_studio_package_manager_url: A URL pointing to an RStudio Package Manager server.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                r_studio_server_pro_domain_settings_property = sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                    domain_execution_role_arn="domainExecutionRoleArn",
                
                    # the properties below are optional
                    default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                        instance_type="instanceType",
                        lifecycle_config_arn="lifecycleConfigArn",
                        sage_maker_image_arn="sageMakerImageArn",
                        sage_maker_image_version_arn="sageMakerImageVersionArn"
                    ),
                    r_studio_connect_url="rStudioConnectUrl",
                    r_studio_package_manager_url="rStudioPackageManagerUrl"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__4d2237946c5a4a06d7dda1321060b6221d13d38adb5b852a7f87f24a5c4fb9a4)
                check_type(argname="argument domain_execution_role_arn", value=domain_execution_role_arn, expected_type=type_hints["domain_execution_role_arn"])
                check_type(argname="argument default_resource_spec", value=default_resource_spec, expected_type=type_hints["default_resource_spec"])
                check_type(argname="argument r_studio_connect_url", value=r_studio_connect_url, expected_type=type_hints["r_studio_connect_url"])
                check_type(argname="argument r_studio_package_manager_url", value=r_studio_package_manager_url, expected_type=type_hints["r_studio_package_manager_url"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "domain_execution_role_arn": domain_execution_role_arn,
            }
            if default_resource_spec is not None:
                self._values["default_resource_spec"] = default_resource_spec
            if r_studio_connect_url is not None:
                self._values["r_studio_connect_url"] = r_studio_connect_url
            if r_studio_package_manager_url is not None:
                self._values["r_studio_package_manager_url"] = r_studio_package_manager_url

        @builtins.property
        def domain_execution_role_arn(self) -> builtins.str:
            '''The ARN of the execution role for the ``RStudioServerPro`` Domain-level app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-domainexecutionrolearn
            '''
            result = self._values.get("domain_execution_role_arn")
            assert result is not None, "Required property 'domain_execution_role_arn' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def default_resource_spec(
            self,
        ) -> typing.Optional[typing.Union["CfnDomain.ResourceSpecProperty", _IResolvable_a771d0ef]]:
            '''A collection that defines the default ``InstanceType`` , ``SageMakerImageArn`` , and ``SageMakerImageVersionArn`` for the Domain.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-defaultresourcespec
            '''
            result = self._values.get("default_resource_spec")
            return typing.cast(typing.Optional[typing.Union["CfnDomain.ResourceSpecProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def r_studio_connect_url(self) -> typing.Optional[builtins.str]:
            '''A URL pointing to an RStudio Connect server.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-rstudioconnecturl
            '''
            result = self._values.get("r_studio_connect_url")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def r_studio_package_manager_url(self) -> typing.Optional[builtins.str]:
            '''A URL pointing to an RStudio Package Manager server.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-rstudioserverprodomainsettings.html#cfn-sagemaker-domain-rstudioserverprodomainsettings-rstudiopackagemanagerurl
            '''
            result = self._values.get("r_studio_package_manager_url")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RStudioServerProDomainSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDomain.ResourceSpecProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_type": "instanceType",
            "lifecycle_config_arn": "lifecycleConfigArn",
            "sage_maker_image_arn": "sageMakerImageArn",
            "sage_maker_image_version_arn": "sageMakerImageVersionArn",
        },
    )
    class ResourceSpecProperty:
        def __init__(
            self,
            *,
            instance_type: typing.Optional[builtins.str] = None,
            lifecycle_config_arn: typing.Optional[builtins.str] = None,
            sage_maker_image_arn: typing.Optional[builtins.str] = None,
            sage_maker_image_version_arn: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.

            :param instance_type: The instance type that the image version runs on. .. epigraph:: *JupyterServer apps* only support the ``system`` value. For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.
            :param lifecycle_config_arn: The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
            :param sage_maker_image_arn: The ARN of the SageMaker image that the image version belongs to.
            :param sage_maker_image_version_arn: The ARN of the image version created on the instance.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                resource_spec_property = sagemaker.CfnDomain.ResourceSpecProperty(
                    instance_type="instanceType",
                    lifecycle_config_arn="lifecycleConfigArn",
                    sage_maker_image_arn="sageMakerImageArn",
                    sage_maker_image_version_arn="sageMakerImageVersionArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__863fd85cd1ed2c374a317c73f0739e7a6352c89c92b8d0b1b0ed3874b6f7253d)
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument lifecycle_config_arn", value=lifecycle_config_arn, expected_type=type_hints["lifecycle_config_arn"])
                check_type(argname="argument sage_maker_image_arn", value=sage_maker_image_arn, expected_type=type_hints["sage_maker_image_arn"])
                check_type(argname="argument sage_maker_image_version_arn", value=sage_maker_image_version_arn, expected_type=type_hints["sage_maker_image_version_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if lifecycle_config_arn is not None:
                self._values["lifecycle_config_arn"] = lifecycle_config_arn
            if sage_maker_image_arn is not None:
                self._values["sage_maker_image_arn"] = sage_maker_image_arn
            if sage_maker_image_version_arn is not None:
                self._values["sage_maker_image_version_arn"] = sage_maker_image_version_arn

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            '''The instance type that the image version runs on.

            .. epigraph::

               *JupyterServer apps* only support the ``system`` value.

               For *KernelGateway apps* , the ``system`` value is translated to ``ml.t3.medium`` . KernelGateway apps also support all other values for available instance types.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-instancetype
            '''
            result = self._values.get("instance_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def lifecycle_config_arn(self) -> typing.Optional[builtins.str]:
            '''The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-lifecycleconfigarn
            '''
            result = self._values.get("lifecycle_config_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the SageMaker image that the image version belongs to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimagearn
            '''
            result = self._values.get("sage_maker_image_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sage_maker_image_version_arn(self) -> typing.Optional[builtins.str]:
            '''The ARN of the image version created on the instance.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-resourcespec.html#cfn-sagemaker-domain-resourcespec-sagemakerimageversionarn
            '''
            result = self._values.get("sage_maker_image_version_arn")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ResourceSpecProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDomain.SharingSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "notebook_output_option": "notebookOutputOption",
            "s3_kms_key_id": "s3KmsKeyId",
            "s3_output_path": "s3OutputPath",
        },
    )
    class SharingSettingsProperty:
        def __init__(
            self,
            *,
            notebook_output_option: typing.Optional[builtins.str] = None,
            s3_kms_key_id: typing.Optional[builtins.str] = None,
            s3_output_path: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies options when sharing an Amazon SageMaker Studio notebook.

            These settings are specified as part of ``DefaultUserSettings`` when the `CreateDomain <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html>`_ API is called, and as part of ``UserSettings`` when the `CreateUserProfile <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html>`_ API is called.

            :param notebook_output_option: Whether to include the notebook cell output when sharing the notebook. The default is ``Disabled`` .
            :param s3_kms_key_id: When ``NotebookOutputOption`` is ``Allowed`` , the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
            :param s3_output_path: When ``NotebookOutputOption`` is ``Allowed`` , the Amazon S3 bucket used to store the shared notebook snapshots.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                sharing_settings_property = sagemaker.CfnDomain.SharingSettingsProperty(
                    notebook_output_option="notebookOutputOption",
                    s3_kms_key_id="s3KmsKeyId",
                    s3_output_path="s3OutputPath"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__80672ab31197e9615afcb61f15a9fc3ffbec1bee4d00191be4e1258952396288)
                check_type(argname="argument notebook_output_option", value=notebook_output_option, expected_type=type_hints["notebook_output_option"])
                check_type(argname="argument s3_kms_key_id", value=s3_kms_key_id, expected_type=type_hints["s3_kms_key_id"])
                check_type(argname="argument s3_output_path", value=s3_output_path, expected_type=type_hints["s3_output_path"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if notebook_output_option is not None:
                self._values["notebook_output_option"] = notebook_output_option
            if s3_kms_key_id is not None:
                self._values["s3_kms_key_id"] = s3_kms_key_id
            if s3_output_path is not None:
                self._values["s3_output_path"] = s3_output_path

        @builtins.property
        def notebook_output_option(self) -> typing.Optional[builtins.str]:
            '''Whether to include the notebook cell output when sharing the notebook.

            The default is ``Disabled`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-notebookoutputoption
            '''
            result = self._values.get("notebook_output_option")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_kms_key_id(self) -> typing.Optional[builtins.str]:
            '''When ``NotebookOutputOption`` is ``Allowed`` , the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3kmskeyid
            '''
            result = self._values.get("s3_kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_output_path(self) -> typing.Optional[builtins.str]:
            '''When ``NotebookOutputOption`` is ``Allowed`` , the Amazon S3 bucket used to store the shared notebook snapshots.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-sharingsettings.html#cfn-sagemaker-domain-sharingsettings-s3outputpath
            '''
            result = self._values.get("s3_output_path")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "SharingSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnDomain.UserSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "execution_role": "executionRole",
            "jupyter_server_app_settings": "jupyterServerAppSettings",
            "kernel_gateway_app_settings": "kernelGatewayAppSettings",
            "r_session_app_settings": "rSessionAppSettings",
            "r_studio_server_pro_app_settings": "rStudioServerProAppSettings",
            "security_groups": "securityGroups",
            "sharing_settings": "sharingSettings",
        },
    )
    class UserSettingsProperty:
        def __init__(
            self,
            *,
            execution_role: typing.Optional[builtins.str] = None,
            jupyter_server_app_settings: typing.Optional[typing.Union[typing.Union["CfnDomain.JupyterServerAppSettingsProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            kernel_gateway_app_settings: typing.Optional[typing.Union[typing.Union["CfnDomain.KernelGatewayAppSettingsProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            r_session_app_settings: typing.Optional[typing.Union[typing.Union["CfnDomain.RSessionAppSettingsProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            r_studio_server_pro_app_settings: typing.Optional[typing.Union[typing.Union["CfnDomain.RStudioServerProAppSettingsProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            security_groups: typing.Optional[typing.Sequence[builtins.str]] = None,
            sharing_settings: typing.Optional[typing.Union[typing.Union["CfnDomain.SharingSettingsProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''A collection of settings that apply to users of Amazon SageMaker Studio.

            These settings are specified when the `CreateUserProfile <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html>`_ API is called, and as ``DefaultUserSettings`` when the `CreateDomain <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html>`_ API is called.

            ``SecurityGroups`` is aggregated when specified in both calls. For all other settings in ``UserSettings`` , the values specified in ``CreateUserProfile`` take precedence over those specified in ``CreateDomain`` .

            :param execution_role: The execution role for the user.
            :param jupyter_server_app_settings: The Jupyter server's app settings.
            :param kernel_gateway_app_settings: The kernel gateway app settings.
            :param r_session_app_settings: A collection of settings that configure the ``RSessionGateway`` app.
            :param r_studio_server_pro_app_settings: A collection of settings that configure user interaction with the ``RStudioServerPro`` app.
            :param security_groups: The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication. Optional when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``PublicInternetOnly`` . Required when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``VpcOnly`` . Amazon SageMaker adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.
            :param sharing_settings: Specifies options for sharing SageMaker Studio notebooks.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                user_settings_property = sagemaker.CfnDomain.UserSettingsProperty(
                    execution_role="executionRole",
                    jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
                
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    r_session_app_settings=sagemaker.CfnDomain.RSessionAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
                
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    r_studio_server_pro_app_settings=sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                        access_status="accessStatus",
                        user_group="userGroup"
                    ),
                    security_groups=["securityGroups"],
                    sharing_settings=sagemaker.CfnDomain.SharingSettingsProperty(
                        notebook_output_option="notebookOutputOption",
                        s3_kms_key_id="s3KmsKeyId",
                        s3_output_path="s3OutputPath"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a926bec2d8d4d5c340525ccb7d0344f87937ecee7fb79f60fee53821b148853a)
                check_type(argname="argument execution_role", value=execution_role, expected_type=type_hints["execution_role"])
                check_type(argname="argument jupyter_server_app_settings", value=jupyter_server_app_settings, expected_type=type_hints["jupyter_server_app_settings"])
                check_type(argname="argument kernel_gateway_app_settings", value=kernel_gateway_app_settings, expected_type=type_hints["kernel_gateway_app_settings"])
                check_type(argname="argument r_session_app_settings", value=r_session_app_settings, expected_type=type_hints["r_session_app_settings"])
                check_type(argname="argument r_studio_server_pro_app_settings", value=r_studio_server_pro_app_settings, expected_type=type_hints["r_studio_server_pro_app_settings"])
                check_type(argname="argument security_groups", value=security_groups, expected_type=type_hints["security_groups"])
                check_type(argname="argument sharing_settings", value=sharing_settings, expected_type=type_hints["sharing_settings"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if execution_role is not None:
                self._values["execution_role"] = execution_role
            if jupyter_server_app_settings is not None:
                self._values["jupyter_server_app_settings"] = jupyter_server_app_settings
            if kernel_gateway_app_settings is not None:
                self._values["kernel_gateway_app_settings"] = kernel_gateway_app_settings
            if r_session_app_settings is not None:
                self._values["r_session_app_settings"] = r_session_app_settings
            if r_studio_server_pro_app_settings is not None:
                self._values["r_studio_server_pro_app_settings"] = r_studio_server_pro_app_settings
            if security_groups is not None:
                self._values["security_groups"] = security_groups
            if sharing_settings is not None:
                self._values["sharing_settings"] = sharing_settings

        @builtins.property
        def execution_role(self) -> typing.Optional[builtins.str]:
            '''The execution role for the user.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-executionrole
            '''
            result = self._values.get("execution_role")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def jupyter_server_app_settings(
            self,
        ) -> typing.Optional[typing.Union["CfnDomain.JupyterServerAppSettingsProperty", _IResolvable_a771d0ef]]:
            '''The Jupyter server's app settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-jupyterserverappsettings
            '''
            result = self._values.get("jupyter_server_app_settings")
            return typing.cast(typing.Optional[typing.Union["CfnDomain.JupyterServerAppSettingsProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def kernel_gateway_app_settings(
            self,
        ) -> typing.Optional[typing.Union["CfnDomain.KernelGatewayAppSettingsProperty", _IResolvable_a771d0ef]]:
            '''The kernel gateway app settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-kernelgatewayappsettings
            '''
            result = self._values.get("kernel_gateway_app_settings")
            return typing.cast(typing.Optional[typing.Union["CfnDomain.KernelGatewayAppSettingsProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def r_session_app_settings(
            self,
        ) -> typing.Optional[typing.Union["CfnDomain.RSessionAppSettingsProperty", _IResolvable_a771d0ef]]:
            '''A collection of settings that configure the ``RSessionGateway`` app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-rsessionappsettings
            '''
            result = self._values.get("r_session_app_settings")
            return typing.cast(typing.Optional[typing.Union["CfnDomain.RSessionAppSettingsProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def r_studio_server_pro_app_settings(
            self,
        ) -> typing.Optional[typing.Union["CfnDomain.RStudioServerProAppSettingsProperty", _IResolvable_a771d0ef]]:
            '''A collection of settings that configure user interaction with the ``RStudioServerPro`` app.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-rstudioserverproappsettings
            '''
            result = self._values.get("r_studio_server_pro_app_settings")
            return typing.cast(typing.Optional[typing.Union["CfnDomain.RStudioServerProAppSettingsProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def security_groups(self) -> typing.Optional[typing.List[builtins.str]]:
            '''The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.

            Optional when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``PublicInternetOnly`` .

            Required when the ``CreateDomain.AppNetworkAccessType`` parameter is set to ``VpcOnly`` .

            Amazon SageMaker adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-securitygroups
            '''
            result = self._values.get("security_groups")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def sharing_settings(
            self,
        ) -> typing.Optional[typing.Union["CfnDomain.SharingSettingsProperty", _IResolvable_a771d0ef]]:
            '''Specifies options for sharing SageMaker Studio notebooks.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-domain-usersettings.html#cfn-sagemaker-domain-usersettings-sharingsettings
            '''
            result = self._values.get("sharing_settings")
            return typing.cast(typing.Optional[typing.Union["CfnDomain.SharingSettingsProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "UserSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnDomainProps",
    jsii_struct_bases=[],
    name_mapping={
        "auth_mode": "authMode",
        "default_user_settings": "defaultUserSettings",
        "domain_name": "domainName",
        "subnet_ids": "subnetIds",
        "vpc_id": "vpcId",
        "app_network_access_type": "appNetworkAccessType",
        "app_security_group_management": "appSecurityGroupManagement",
        "domain_settings": "domainSettings",
        "kms_key_id": "kmsKeyId",
        "tags": "tags",
    },
)
class CfnDomainProps:
    def __init__(
        self,
        *,
        auth_mode: builtins.str,
        default_user_settings: typing.Union[typing.Union[CfnDomain.UserSettingsProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        domain_name: builtins.str,
        subnet_ids: typing.Sequence[builtins.str],
        vpc_id: builtins.str,
        app_network_access_type: typing.Optional[builtins.str] = None,
        app_security_group_management: typing.Optional[builtins.str] = None,
        domain_settings: typing.Optional[typing.Union[typing.Union[CfnDomain.DomainSettingsProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnDomain``.

        :param auth_mode: The mode of authentication that members use to access the Domain. *Valid Values* : ``SSO | IAM``
        :param default_user_settings: The default user settings.
        :param domain_name: The domain name.
        :param subnet_ids: The VPC subnets that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Array members* : Minimum number of 1 item. Maximum number of 16 items. *Pattern* : ``[-0-9a-zA-Z]+``
        :param vpc_id: The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication. *Length Constraints* : Maximum length of 32. *Pattern* : ``[-0-9a-zA-Z]+``
        :param app_network_access_type: Specifies the VPC used for non-EFS traffic. The default value is ``PublicInternetOnly`` . - ``PublicInternetOnly`` - Non-EFS traffic is through a VPC managed by Amazon SageMaker , which allows direct internet access - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets *Valid Values* : ``PublicInternetOnly | VpcOnly``
        :param app_security_group_management: The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode. Required when ``CreateDomain.AppNetworkAccessType`` is ``VpcOnly`` and ``DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`` is provided.
        :param domain_settings: A collection of settings that apply to the ``SageMaker Domain`` . These settings are specified through the ``CreateDomain`` API call.
        :param kms_key_id: SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default. For more control, specify a customer managed CMK. *Length Constraints* : Maximum length of 2048. *Pattern* : ``.*``
        :param tags: Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. Tags that you specify for the Domain are also added to all apps that are launched in the Domain. *Array members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            cfn_domain_props = sagemaker.CfnDomainProps(
                auth_mode="authMode",
                default_user_settings=sagemaker.CfnDomain.UserSettingsProperty(
                    execution_role="executionRole",
                    jupyter_server_app_settings=sagemaker.CfnDomain.JupyterServerAppSettingsProperty(
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    kernel_gateway_app_settings=sagemaker.CfnDomain.KernelGatewayAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
            
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    r_session_app_settings=sagemaker.CfnDomain.RSessionAppSettingsProperty(
                        custom_images=[sagemaker.CfnDomain.CustomImageProperty(
                            app_image_config_name="appImageConfigName",
                            image_name="imageName",
            
                            # the properties below are optional
                            image_version_number=123
                        )],
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        )
                    ),
                    r_studio_server_pro_app_settings=sagemaker.CfnDomain.RStudioServerProAppSettingsProperty(
                        access_status="accessStatus",
                        user_group="userGroup"
                    ),
                    security_groups=["securityGroups"],
                    sharing_settings=sagemaker.CfnDomain.SharingSettingsProperty(
                        notebook_output_option="notebookOutputOption",
                        s3_kms_key_id="s3KmsKeyId",
                        s3_output_path="s3OutputPath"
                    )
                ),
                domain_name="domainName",
                subnet_ids=["subnetIds"],
                vpc_id="vpcId",
            
                # the properties below are optional
                app_network_access_type="appNetworkAccessType",
                app_security_group_management="appSecurityGroupManagement",
                domain_settings=sagemaker.CfnDomain.DomainSettingsProperty(
                    r_studio_server_pro_domain_settings=sagemaker.CfnDomain.RStudioServerProDomainSettingsProperty(
                        domain_execution_role_arn="domainExecutionRoleArn",
            
                        # the properties below are optional
                        default_resource_spec=sagemaker.CfnDomain.ResourceSpecProperty(
                            instance_type="instanceType",
                            lifecycle_config_arn="lifecycleConfigArn",
                            sage_maker_image_arn="sageMakerImageArn",
                            sage_maker_image_version_arn="sageMakerImageVersionArn"
                        ),
                        r_studio_connect_url="rStudioConnectUrl",
                        r_studio_package_manager_url="rStudioPackageManagerUrl"
                    ),
                    security_group_ids=["securityGroupIds"]
                ),
                kms_key_id="kmsKeyId",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4add8ed13f24e65617985edb7d116d35868fe10a70c67a173b70318e5f3c4f83)
            check_type(argname="argument auth_mode", value=auth_mode, expected_type=type_hints["auth_mode"])
            check_type(argname="argument default_user_settings", value=default_user_settings, expected_type=type_hints["default_user_settings"])
            check_type(argname="argument domain_name", value=domain_name, expected_type=type_hints["domain_name"])
            check_type(argname="argument subnet_ids", value=subnet_ids, expected_type=type_hints["subnet_ids"])
            check_type(argname="argument vpc_id", value=vpc_id, expected_type=type_hints["vpc_id"])
            check_type(argname="argument app_network_access_type", value=app_network_access_type, expected_type=type_hints["app_network_access_type"])
            check_type(argname="argument app_security_group_management", value=app_security_group_management, expected_type=type_hints["app_security_group_management"])
            check_type(argname="argument domain_settings", value=domain_settings, expected_type=type_hints["domain_settings"])
            check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "auth_mode": auth_mode,
            "default_user_settings": default_user_settings,
            "domain_name": domain_name,
            "subnet_ids": subnet_ids,
            "vpc_id": vpc_id,
        }
        if app_network_access_type is not None:
            self._values["app_network_access_type"] = app_network_access_type
        if app_security_group_management is not None:
            self._values["app_security_group_management"] = app_security_group_management
        if domain_settings is not None:
            self._values["domain_settings"] = domain_settings
        if kms_key_id is not None:
            self._values["kms_key_id"] = kms_key_id
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def auth_mode(self) -> builtins.str:
        '''The mode of authentication that members use to access the Domain.

        *Valid Values* : ``SSO | IAM``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-authmode
        '''
        result = self._values.get("auth_mode")
        assert result is not None, "Required property 'auth_mode' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def default_user_settings(
        self,
    ) -> typing.Union[CfnDomain.UserSettingsProperty, _IResolvable_a771d0ef]:
        '''The default user settings.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-defaultusersettings
        '''
        result = self._values.get("default_user_settings")
        assert result is not None, "Required property 'default_user_settings' is missing"
        return typing.cast(typing.Union[CfnDomain.UserSettingsProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def domain_name(self) -> builtins.str:
        '''The domain name.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainname
        '''
        result = self._values.get("domain_name")
        assert result is not None, "Required property 'domain_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def subnet_ids(self) -> typing.List[builtins.str]:
        '''The VPC subnets that Studio uses for communication.

        *Length Constraints* : Maximum length of 32.

        *Array members* : Minimum number of 1 item. Maximum number of 16 items.

        *Pattern* : ``[-0-9a-zA-Z]+``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-subnetids
        '''
        result = self._values.get("subnet_ids")
        assert result is not None, "Required property 'subnet_ids' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def vpc_id(self) -> builtins.str:
        '''The ID of the Amazon Virtual Private Cloud (Amazon VPC) that Studio uses for communication.

        *Length Constraints* : Maximum length of 32.

        *Pattern* : ``[-0-9a-zA-Z]+``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-vpcid
        '''
        result = self._values.get("vpc_id")
        assert result is not None, "Required property 'vpc_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def app_network_access_type(self) -> typing.Optional[builtins.str]:
        '''Specifies the VPC used for non-EFS traffic. The default value is ``PublicInternetOnly`` .

        - ``PublicInternetOnly`` - Non-EFS traffic is through a VPC managed by Amazon SageMaker , which allows direct internet access
        - ``VpcOnly`` - All Studio traffic is through the specified VPC and subnets

        *Valid Values* : ``PublicInternetOnly | VpcOnly``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appnetworkaccesstype
        '''
        result = self._values.get("app_network_access_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def app_security_group_management(self) -> typing.Optional[builtins.str]:
        '''The entity that creates and manages the required security groups for inter-app communication in ``VpcOnly`` mode.

        Required when ``CreateDomain.AppNetworkAccessType`` is ``VpcOnly`` and ``DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`` is provided.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-appsecuritygroupmanagement
        '''
        result = self._values.get("app_security_group_management")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def domain_settings(
        self,
    ) -> typing.Optional[typing.Union[CfnDomain.DomainSettingsProperty, _IResolvable_a771d0ef]]:
        '''A collection of settings that apply to the ``SageMaker Domain`` .

        These settings are specified through the ``CreateDomain`` API call.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-domainsettings
        '''
        result = self._values.get("domain_settings")
        return typing.cast(typing.Optional[typing.Union[CfnDomain.DomainSettingsProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''SageMaker uses AWS KMS to encrypt the EFS volume attached to the Domain with an AWS managed customer master key (CMK) by default.

        For more control, specify a customer managed CMK.

        *Length Constraints* : Maximum length of 2048.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-kmskeyid
        '''
        result = self._values.get("kms_key_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''Tags to associated with the Domain.

        Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.

        Tags that you specify for the Domain are also added to all apps that are launched in the Domain.

        *Array members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-domain.html#cfn-sagemaker-domain-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnDomainProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnEndpoint(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnEndpoint",
):
    '''A CloudFormation ``AWS::SageMaker::Endpoint``.

    Use the ``AWS::SageMaker::Endpoint`` resource to create an endpoint using the specified configuration in the request. Amazon SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource. For more information, see `Deploy a Model on Amazon SageMaker Hosting Services <https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-hosting.html>`_ in the *Amazon SageMaker Developer Guide* .

    :cloudformationResource: AWS::SageMaker::Endpoint
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        cfn_endpoint = sagemaker.CfnEndpoint(self, "MyCfnEndpoint",
            endpoint_config_name="endpointConfigName",
        
            # the properties below are optional
            deployment_config=sagemaker.CfnEndpoint.DeploymentConfigProperty(
                blue_green_update_policy=sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                    traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                        type="type",
        
                        # the properties below are optional
                        canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        wait_interval_in_seconds=123
                    ),
        
                    # the properties below are optional
                    maximum_execution_timeout_in_seconds=123,
                    termination_wait_in_seconds=123
                ),
        
                # the properties below are optional
                auto_rollback_configuration=sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                    alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                        alarm_name="alarmName"
                    )]
                )
            ),
            endpoint_name="endpointName",
            exclude_retained_variant_properties=[sagemaker.CfnEndpoint.VariantPropertyProperty(
                variant_property_type="variantPropertyType"
            )],
            retain_all_variant_properties=False,
            retain_deployment_config=False,
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        endpoint_config_name: builtins.str,
        deployment_config: typing.Optional[typing.Union[typing.Union["CfnEndpoint.DeploymentConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        exclude_retained_variant_properties: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnEndpoint.VariantPropertyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        retain_all_variant_properties: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        retain_deployment_config: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::Endpoint``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param endpoint_config_name: The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .
        :param deployment_config: The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
        :param endpoint_name: The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in ``CreateEndpoint`` , but the case is preserved and must be matched in ` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html>`_ .
        :param exclude_retained_variant_properties: When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .
        :param retain_all_variant_properties: When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set ``RetainAllVariantProperties`` to ``true`` . To use the variant properties specified in a new ``EndpointConfig`` call when updating an endpoint, set ``RetainAllVariantProperties`` to ``false`` . Use this property only when updating endpoint resources, not when creating new endpoint resources.
        :param retain_deployment_config: Specifies whether to reuse the last deployment configuration. The default value is false (the configuration is not reused).
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__13d0fbc83e26befbc519e166bb2784575da499915ae169394d5803f3724429aa)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnEndpointProps(
            endpoint_config_name=endpoint_config_name,
            deployment_config=deployment_config,
            endpoint_name=endpoint_name,
            exclude_retained_variant_properties=exclude_retained_variant_properties,
            retain_all_variant_properties=retain_all_variant_properties,
            retain_deployment_config=retain_deployment_config,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__54b309ffc54375a1b92db78b2491397d48ee15cdf4e0233d1d83ea0644e9f66c)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20e6dd5a36d0357554e7ddb482ca96f792309338a549b1179bfe08e216e476ef)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrEndpointName")
    def attr_endpoint_name(self) -> builtins.str:
        '''The name of the endpoint, such as ``MyEndpoint`` .

        :cloudformationAttribute: EndpointName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrEndpointName"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="endpointConfigName")
    def endpoint_config_name(self) -> builtins.str:
        '''The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
        '''
        return typing.cast(builtins.str, jsii.get(self, "endpointConfigName"))

    @endpoint_config_name.setter
    def endpoint_config_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__416ee3d1607b931e8a207041f2f120647634168b4738e61578286bd9d8b137e9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointConfigName", value)

    @builtins.property
    @jsii.member(jsii_name="deploymentConfig")
    def deployment_config(
        self,
    ) -> typing.Optional[typing.Union["CfnEndpoint.DeploymentConfigProperty", _IResolvable_a771d0ef]]:
        '''The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnEndpoint.DeploymentConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "deploymentConfig"))

    @deployment_config.setter
    def deployment_config(
        self,
        value: typing.Optional[typing.Union["CfnEndpoint.DeploymentConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6df8d7fc21beccc9f0bb8e13238103bdac9019ef2fec31f3e65eecfd688da7b1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "deploymentConfig", value)

    @builtins.property
    @jsii.member(jsii_name="endpointName")
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in ``CreateEndpoint`` , but the case is preserved and must be matched in ` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointName"))

    @endpoint_name.setter
    def endpoint_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__06c4727274d296ab38ee125dfd99a42fab1e6e8219ed884832e0c8375912984d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointName", value)

    @builtins.property
    @jsii.member(jsii_name="excludeRetainedVariantProperties")
    def exclude_retained_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpoint.VariantPropertyProperty", _IResolvable_a771d0ef]]]]:
        '''When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpoint.VariantPropertyProperty", _IResolvable_a771d0ef]]]], jsii.get(self, "excludeRetainedVariantProperties"))

    @exclude_retained_variant_properties.setter
    def exclude_retained_variant_properties(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpoint.VariantPropertyProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__91f7ce84588271b5dc76553a9c31f9b37480cafa155273ced702a7ee735b55d3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "excludeRetainedVariantProperties", value)

    @builtins.property
    @jsii.member(jsii_name="retainAllVariantProperties")
    def retain_all_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        '''When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight.

        To retain the variant properties of an endpoint when updating it, set ``RetainAllVariantProperties`` to ``true`` . To use the variant properties specified in a new ``EndpointConfig`` call when updating an endpoint, set ``RetainAllVariantProperties`` to ``false`` . Use this property only when updating endpoint resources, not when creating new endpoint resources.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
        '''
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], jsii.get(self, "retainAllVariantProperties"))

    @retain_all_variant_properties.setter
    def retain_all_variant_properties(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__816ffcf0a8785609ad31bdd74da5425ae74af9afe1221211eb2e71eb63b82df6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "retainAllVariantProperties", value)

    @builtins.property
    @jsii.member(jsii_name="retainDeploymentConfig")
    def retain_deployment_config(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        '''Specifies whether to reuse the last deployment configuration.

        The default value is false (the configuration is not reused).

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retaindeploymentconfig
        '''
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], jsii.get(self, "retainDeploymentConfig"))

    @retain_deployment_config.setter
    def retain_deployment_config(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b3a1cf2ad0a28c3be8dca595b36e33344b7d3229f5196121200657e5d362897e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "retainDeploymentConfig", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpoint.AlarmProperty",
        jsii_struct_bases=[],
        name_mapping={"alarm_name": "alarmName"},
    )
    class AlarmProperty:
        def __init__(self, *, alarm_name: builtins.str) -> None:
            '''An Amazon CloudWatch alarm configured to monitor metrics on an endpoint.

            :param alarm_name: The name of a CloudWatch alarm in your account.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                alarm_property = sagemaker.CfnEndpoint.AlarmProperty(
                    alarm_name="alarmName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__603a43b9a96b4432930ba161e63edc9eba49b2348c65b24fd323dda379750308)
                check_type(argname="argument alarm_name", value=alarm_name, expected_type=type_hints["alarm_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "alarm_name": alarm_name,
            }

        @builtins.property
        def alarm_name(self) -> builtins.str:
            '''The name of a CloudWatch alarm in your account.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html#cfn-sagemaker-endpoint-alarm-alarmname
            '''
            result = self._values.get("alarm_name")
            assert result is not None, "Required property 'alarm_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AlarmProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpoint.AutoRollbackConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"alarms": "alarms"},
    )
    class AutoRollbackConfigProperty:
        def __init__(
            self,
            *,
            alarms: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnEndpoint.AlarmProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        ) -> None:
            '''Automatic rollback configuration for handling endpoint deployment failures and recovery.

            :param alarms: List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                auto_rollback_config_property = sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                    alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                        alarm_name="alarmName"
                    )]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2842f0567d5f8a65f43b129b4903ebba41e416a37b347c41c955afc0fab7e160)
                check_type(argname="argument alarms", value=alarms, expected_type=type_hints["alarms"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "alarms": alarms,
            }

        @builtins.property
        def alarms(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpoint.AlarmProperty", _IResolvable_a771d0ef]]]:
            '''List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint.

            If any alarms are tripped during a deployment, SageMaker rolls back the deployment.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html#cfn-sagemaker-endpoint-autorollbackconfig-alarms
            '''
            result = self._values.get("alarms")
            assert result is not None, "Required property 'alarms' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpoint.AlarmProperty", _IResolvable_a771d0ef]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AutoRollbackConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty",
        jsii_struct_bases=[],
        name_mapping={
            "traffic_routing_configuration": "trafficRoutingConfiguration",
            "maximum_execution_timeout_in_seconds": "maximumExecutionTimeoutInSeconds",
            "termination_wait_in_seconds": "terminationWaitInSeconds",
        },
    )
    class BlueGreenUpdatePolicyProperty:
        def __init__(
            self,
            *,
            traffic_routing_configuration: typing.Union[typing.Union["CfnEndpoint.TrafficRoutingConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            maximum_execution_timeout_in_seconds: typing.Optional[jsii.Number] = None,
            termination_wait_in_seconds: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Update policy for a blue/green deployment.

            If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.

            :param traffic_routing_configuration: Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment.
            :param maximum_execution_timeout_in_seconds: Maximum execution timeout for the deployment. Note that the timeout value should be larger than the total waiting time specified in ``TerminationWaitInSeconds`` and ``WaitIntervalInSeconds`` .
            :param termination_wait_in_seconds: Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet. Default is 0.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                blue_green_update_policy_property = sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                    traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                        type="type",
                
                        # the properties below are optional
                        canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                            type="type",
                            value=123
                        ),
                        wait_interval_in_seconds=123
                    ),
                
                    # the properties below are optional
                    maximum_execution_timeout_in_seconds=123,
                    termination_wait_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ab77703863ec140a5b1758294867c42412c9b8ccf0de4d28a3ad4a1df3010eb7)
                check_type(argname="argument traffic_routing_configuration", value=traffic_routing_configuration, expected_type=type_hints["traffic_routing_configuration"])
                check_type(argname="argument maximum_execution_timeout_in_seconds", value=maximum_execution_timeout_in_seconds, expected_type=type_hints["maximum_execution_timeout_in_seconds"])
                check_type(argname="argument termination_wait_in_seconds", value=termination_wait_in_seconds, expected_type=type_hints["termination_wait_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "traffic_routing_configuration": traffic_routing_configuration,
            }
            if maximum_execution_timeout_in_seconds is not None:
                self._values["maximum_execution_timeout_in_seconds"] = maximum_execution_timeout_in_seconds
            if termination_wait_in_seconds is not None:
                self._values["termination_wait_in_seconds"] = termination_wait_in_seconds

        @builtins.property
        def traffic_routing_configuration(
            self,
        ) -> typing.Union["CfnEndpoint.TrafficRoutingConfigProperty", _IResolvable_a771d0ef]:
            '''Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-trafficroutingconfiguration
            '''
            result = self._values.get("traffic_routing_configuration")
            assert result is not None, "Required property 'traffic_routing_configuration' is missing"
            return typing.cast(typing.Union["CfnEndpoint.TrafficRoutingConfigProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def maximum_execution_timeout_in_seconds(self) -> typing.Optional[jsii.Number]:
            '''Maximum execution timeout for the deployment.

            Note that the timeout value should be larger than the total waiting time specified in ``TerminationWaitInSeconds`` and ``WaitIntervalInSeconds`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-maximumexecutiontimeoutinseconds
            '''
            result = self._values.get("maximum_execution_timeout_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def termination_wait_in_seconds(self) -> typing.Optional[jsii.Number]:
            '''Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet.

            Default is 0.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-terminationwaitinseconds
            '''
            result = self._values.get("termination_wait_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlueGreenUpdatePolicyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpoint.CapacitySizeProperty",
        jsii_struct_bases=[],
        name_mapping={"type": "type", "value": "value"},
    )
    class CapacitySizeProperty:
        def __init__(self, *, type: builtins.str, value: jsii.Number) -> None:
            '''Specifies the endpoint capacity to activate for production.

            :param type: Specifies the endpoint capacity type. - ``INSTANCE_COUNT`` : The endpoint activates based on the number of instances. - ``CAPACITY_PERCENT`` : The endpoint activates based on the specified percentage of capacity.
            :param value: Defines the capacity size, either as a number of instances or a capacity percentage.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                capacity_size_property = sagemaker.CfnEndpoint.CapacitySizeProperty(
                    type="type",
                    value=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b9ff03d3afc1cb94b6d6115687f9301ce7abb7073764b4672b53f819bc7e55ba)
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
                check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "type": type,
                "value": value,
            }

        @builtins.property
        def type(self) -> builtins.str:
            '''Specifies the endpoint capacity type.

            - ``INSTANCE_COUNT`` : The endpoint activates based on the number of instances.
            - ``CAPACITY_PERCENT`` : The endpoint activates based on the specified percentage of capacity.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-type
            '''
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def value(self) -> jsii.Number:
            '''Defines the capacity size, either as a number of instances or a capacity percentage.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-value
            '''
            result = self._values.get("value")
            assert result is not None, "Required property 'value' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CapacitySizeProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpoint.DeploymentConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "blue_green_update_policy": "blueGreenUpdatePolicy",
            "auto_rollback_configuration": "autoRollbackConfiguration",
        },
    )
    class DeploymentConfigProperty:
        def __init__(
            self,
            *,
            blue_green_update_policy: typing.Union[typing.Union["CfnEndpoint.BlueGreenUpdatePolicyProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            auto_rollback_configuration: typing.Optional[typing.Union[typing.Union["CfnEndpoint.AutoRollbackConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.

            :param blue_green_update_policy: Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.
            :param auto_rollback_configuration: Automatic rollback configuration for handling endpoint deployment failures and recovery.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                deployment_config_property = sagemaker.CfnEndpoint.DeploymentConfigProperty(
                    blue_green_update_policy=sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                        traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                            type="type",
                
                            # the properties below are optional
                            canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            wait_interval_in_seconds=123
                        ),
                
                        # the properties below are optional
                        maximum_execution_timeout_in_seconds=123,
                        termination_wait_in_seconds=123
                    ),
                
                    # the properties below are optional
                    auto_rollback_configuration=sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                        alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                            alarm_name="alarmName"
                        )]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e27c3f9e4ed6bb5085631b92053e0c8f01900587d6a24cc177d279561c673d9b)
                check_type(argname="argument blue_green_update_policy", value=blue_green_update_policy, expected_type=type_hints["blue_green_update_policy"])
                check_type(argname="argument auto_rollback_configuration", value=auto_rollback_configuration, expected_type=type_hints["auto_rollback_configuration"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "blue_green_update_policy": blue_green_update_policy,
            }
            if auto_rollback_configuration is not None:
                self._values["auto_rollback_configuration"] = auto_rollback_configuration

        @builtins.property
        def blue_green_update_policy(
            self,
        ) -> typing.Union["CfnEndpoint.BlueGreenUpdatePolicyProperty", _IResolvable_a771d0ef]:
            '''Update policy for a blue/green deployment.

            If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-bluegreenupdatepolicy
            '''
            result = self._values.get("blue_green_update_policy")
            assert result is not None, "Required property 'blue_green_update_policy' is missing"
            return typing.cast(typing.Union["CfnEndpoint.BlueGreenUpdatePolicyProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def auto_rollback_configuration(
            self,
        ) -> typing.Optional[typing.Union["CfnEndpoint.AutoRollbackConfigProperty", _IResolvable_a771d0ef]]:
            '''Automatic rollback configuration for handling endpoint deployment failures and recovery.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-autorollbackconfiguration
            '''
            result = self._values.get("auto_rollback_configuration")
            return typing.cast(typing.Optional[typing.Union["CfnEndpoint.AutoRollbackConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DeploymentConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpoint.TrafficRoutingConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "type": "type",
            "canary_size": "canarySize",
            "linear_step_size": "linearStepSize",
            "wait_interval_in_seconds": "waitIntervalInSeconds",
        },
    )
    class TrafficRoutingConfigProperty:
        def __init__(
            self,
            *,
            type: builtins.str,
            canary_size: typing.Optional[typing.Union[typing.Union["CfnEndpoint.CapacitySizeProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            linear_step_size: typing.Optional[typing.Union[typing.Union["CfnEndpoint.CapacitySizeProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            wait_interval_in_seconds: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Defines the traffic routing strategy during an endpoint deployment to shift traffic from the old fleet to the new fleet.

            :param type: Traffic routing strategy type. - ``ALL_AT_ONCE`` : Endpoint traffic shifts to the new fleet in a single step. - ``CANARY`` : Endpoint traffic shifts to the new fleet in two steps. The first step is the canary, which is a small portion of the traffic. The second step is the remainder of the traffic. - ``LINEAR`` : Endpoint traffic shifts to the new fleet in n steps of a configurable size.
            :param canary_size: Batch size for the first step to turn on traffic on the new endpoint fleet. ``Value`` must be less than or equal to 50% of the variant's total instance count.
            :param linear_step_size: Batch size for each step to turn on traffic on the new endpoint fleet. ``Value`` must be 10-50% of the variant's total instance count.
            :param wait_interval_in_seconds: The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                traffic_routing_config_property = sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                    type="type",
                
                    # the properties below are optional
                    canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                        type="type",
                        value=123
                    ),
                    linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                        type="type",
                        value=123
                    ),
                    wait_interval_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__adaf23cb0a7e5a9b43a3c08460fd9477faedb4a048ed1814c8ba1c06f8bb1d63)
                check_type(argname="argument type", value=type, expected_type=type_hints["type"])
                check_type(argname="argument canary_size", value=canary_size, expected_type=type_hints["canary_size"])
                check_type(argname="argument linear_step_size", value=linear_step_size, expected_type=type_hints["linear_step_size"])
                check_type(argname="argument wait_interval_in_seconds", value=wait_interval_in_seconds, expected_type=type_hints["wait_interval_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "type": type,
            }
            if canary_size is not None:
                self._values["canary_size"] = canary_size
            if linear_step_size is not None:
                self._values["linear_step_size"] = linear_step_size
            if wait_interval_in_seconds is not None:
                self._values["wait_interval_in_seconds"] = wait_interval_in_seconds

        @builtins.property
        def type(self) -> builtins.str:
            '''Traffic routing strategy type.

            - ``ALL_AT_ONCE`` : Endpoint traffic shifts to the new fleet in a single step.
            - ``CANARY`` : Endpoint traffic shifts to the new fleet in two steps. The first step is the canary, which is a small portion of the traffic. The second step is the remainder of the traffic.
            - ``LINEAR`` : Endpoint traffic shifts to the new fleet in n steps of a configurable size.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-type
            '''
            result = self._values.get("type")
            assert result is not None, "Required property 'type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def canary_size(
            self,
        ) -> typing.Optional[typing.Union["CfnEndpoint.CapacitySizeProperty", _IResolvable_a771d0ef]]:
            '''Batch size for the first step to turn on traffic on the new endpoint fleet.

            ``Value`` must be less than or equal to 50% of the variant's total instance count.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-canarysize
            '''
            result = self._values.get("canary_size")
            return typing.cast(typing.Optional[typing.Union["CfnEndpoint.CapacitySizeProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def linear_step_size(
            self,
        ) -> typing.Optional[typing.Union["CfnEndpoint.CapacitySizeProperty", _IResolvable_a771d0ef]]:
            '''Batch size for each step to turn on traffic on the new endpoint fleet.

            ``Value`` must be 10-50% of the variant's total instance count.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-linearstepsize
            '''
            result = self._values.get("linear_step_size")
            return typing.cast(typing.Optional[typing.Union["CfnEndpoint.CapacitySizeProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def wait_interval_in_seconds(self) -> typing.Optional[jsii.Number]:
            '''The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-waitintervalinseconds
            '''
            result = self._values.get("wait_interval_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "TrafficRoutingConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpoint.VariantPropertyProperty",
        jsii_struct_bases=[],
        name_mapping={"variant_property_type": "variantPropertyType"},
    )
    class VariantPropertyProperty:
        def __init__(
            self,
            *,
            variant_property_type: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies a production variant property type for an Endpoint.

            If you are updating an Endpoint with the `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ option set to ``true`` , the ``VarientProperty`` objects listed in `ExcludeRetainedVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-ExcludeRetainedVariantProperties>`_ override the existing variant properties of the Endpoint.

            :param variant_property_type: The type of variant property. The supported values are:. - ``DesiredInstanceCount`` : Overrides the existing variant instance counts using the `InitialInstanceCount <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialInstanceCount>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ . - ``DesiredWeight`` : Overrides the existing variant weights using the `InitialVariantWeight <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialVariantWeight>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ . - ``DataCaptureConfig`` : (Not currently supported.)

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                variant_property_property = sagemaker.CfnEndpoint.VariantPropertyProperty(
                    variant_property_type="variantPropertyType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b1a312426ab0e31c1c90b2ea74d46c926dcd51518386aadb0bb755f427d1645a)
                check_type(argname="argument variant_property_type", value=variant_property_type, expected_type=type_hints["variant_property_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if variant_property_type is not None:
                self._values["variant_property_type"] = variant_property_type

        @builtins.property
        def variant_property_type(self) -> typing.Optional[builtins.str]:
            '''The type of variant property. The supported values are:.

            - ``DesiredInstanceCount`` : Overrides the existing variant instance counts using the `InitialInstanceCount <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialInstanceCount>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ .
            - ``DesiredWeight`` : Overrides the existing variant weights using the `InitialVariantWeight <https://docs.aws.amazon.com/sagemaker/latest/dg/API_ProductionVariant.html#SageMaker-Type-ProductionVariant-InitialVariantWeight>`_ values in the `ProductionVariants <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html#SageMaker-CreateEndpointConfig-request-ProductionVariants>`_ .
            - ``DataCaptureConfig`` : (Not currently supported.)

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html#cfn-sagemaker-endpoint-variantproperty-variantpropertytype
            '''
            result = self._values.get("variant_property_type")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VariantPropertyProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_82c04a63)
class CfnEndpointConfig(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig",
):
    '''A CloudFormation ``AWS::SageMaker::EndpointConfig``.

    The ``AWS::SageMaker::EndpointConfig`` resource creates a configuration for an Amazon SageMaker endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ in the *SageMaker Developer Guide* .

    :cloudformationResource: AWS::SageMaker::EndpointConfig
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        cfn_endpoint_config = sagemaker.CfnEndpointConfig(self, "MyCfnEndpointConfig",
            production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                initial_variant_weight=123,
                model_name="modelName",
                variant_name="variantName",
        
                # the properties below are optional
                accelerator_type="acceleratorType",
                container_startup_health_check_timeout_in_seconds=123,
                initial_instance_count=123,
                instance_type="instanceType",
                model_data_download_timeout_in_seconds=123,
                serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                    max_concurrency=123,
                    memory_size_in_mb=123
                ),
                volume_size_in_gb=123
            )],
        
            # the properties below are optional
            async_inference_config=sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty(
                output_config=sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                    s3_output_path="s3OutputPath",
        
                    # the properties below are optional
                    kms_key_id="kmsKeyId",
                    notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                        error_topic="errorTopic",
                        success_topic="successTopic"
                    )
                ),
        
                # the properties below are optional
                client_config=sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                    max_concurrent_invocations_per_instance=123
                )
            ),
            data_capture_config=sagemaker.CfnEndpointConfig.DataCaptureConfigProperty(
                capture_options=[sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                    capture_mode="captureMode"
                )],
                destination_s3_uri="destinationS3Uri",
                initial_sampling_percentage=123,
        
                # the properties below are optional
                capture_content_type_header=sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                    csv_content_types=["csvContentTypes"],
                    json_content_types=["jsonContentTypes"]
                ),
                enable_capture=False,
                kms_key_id="kmsKeyId"
            ),
            endpoint_config_name="endpointConfigName",
            explainer_config=sagemaker.CfnEndpointConfig.ExplainerConfigProperty(
                clarify_explainer_config=sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                    shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                        shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                            mime_type="mimeType",
                            shap_baseline="shapBaseline",
                            shap_baseline_uri="shapBaselineUri"
                        ),
        
                        # the properties below are optional
                        number_of_samples=123,
                        seed=123,
                        text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                            granularity="granularity",
                            language="language"
                        ),
                        use_logit=False
                    ),
        
                    # the properties below are optional
                    enable_explanations="enableExplanations",
                    inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                        content_template="contentTemplate",
                        feature_headers=["featureHeaders"],
                        features_attribute="featuresAttribute",
                        feature_types=["featureTypes"],
                        label_attribute="labelAttribute",
                        label_headers=["labelHeaders"],
                        label_index=123,
                        max_payload_in_mb=123,
                        max_record_count=123,
                        probability_attribute="probabilityAttribute",
                        probability_index=123
                    )
                )
            ),
            kms_key_id="kmsKeyId",
            shadow_production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                initial_variant_weight=123,
                model_name="modelName",
                variant_name="variantName",
        
                # the properties below are optional
                accelerator_type="acceleratorType",
                container_startup_health_check_timeout_in_seconds=123,
                initial_instance_count=123,
                instance_type="instanceType",
                model_data_download_timeout_in_seconds=123,
                serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                    max_concurrency=123,
                    memory_size_in_mb=123
                ),
                volume_size_in_gb=123
            )],
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        production_variants: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnEndpointConfig.ProductionVariantProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        async_inference_config: typing.Optional[typing.Union[typing.Union["CfnEndpointConfig.AsyncInferenceConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        data_capture_config: typing.Optional[typing.Union[typing.Union["CfnEndpointConfig.DataCaptureConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        endpoint_config_name: typing.Optional[builtins.str] = None,
        explainer_config: typing.Optional[typing.Union[typing.Union["CfnEndpointConfig.ExplainerConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        shadow_production_variants: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnEndpointConfig.ProductionVariantProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::EndpointConfig``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param production_variants: A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.
        :param async_inference_config: Specifies configuration for how an endpoint performs asynchronous inference.
        :param data_capture_config: Specifies how to capture endpoint data for model monitor. The data capture configuration applies to all production variants hosted at the endpoint.
        :param endpoint_config_name: The name of the endpoint configuration.
        :param explainer_config: ``AWS::SageMaker::EndpointConfig.ExplainerConfig``.
        :param kms_key_id: The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. - Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab`` - Key ARN: ``arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`` - Alias name: ``alias/ExampleAlias`` - Alias name ARN: ``arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`` The KMS key policy must grant permission to the IAM role that you specify in your ``CreateEndpoint`` , ``UpdateEndpoint`` requests. For more information, refer to the AWS Key Management Service section `Using Key Policies in AWS KMS <https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html>`_ .. epigraph:: Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a ``KmsKeyId`` when using an instance type with local storage. If any of the models that you specify in the ``ProductionVariants`` parameter use nitro-based instances with local storage, do not specify a value for the ``KmsKeyId`` parameter. If you specify a value for ``KmsKeyId`` when using any nitro-based instances with local storage, the call to ``CreateEndpointConfig`` fails. For a list of instance types that support local instance storage, see `Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes>`_ . For more information about local instance storage encryption, see `SSD Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html>`_ .
        :param shadow_production_variants: Array of ``ProductionVariant`` objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ``ProductionVariants`` . If you use this field, you can only specify one variant for ``ProductionVariants`` and one variant for ``ShadowProductionVariants`` .
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__093f99338f434b0e15487787f0559f17a03e135e20c6422344f5f3fdc3c05138)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnEndpointConfigProps(
            production_variants=production_variants,
            async_inference_config=async_inference_config,
            data_capture_config=data_capture_config,
            endpoint_config_name=endpoint_config_name,
            explainer_config=explainer_config,
            kms_key_id=kms_key_id,
            shadow_production_variants=shadow_production_variants,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__36c0991ba3be554b867b41f4d06b24f50c04aed5a8519731f76166439cd4234f)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf60c92ddc3ff254f8d564d5d33c83e24f1287bd2e2932fc80ec7aea37e2cd10)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrEndpointConfigName")
    def attr_endpoint_config_name(self) -> builtins.str:
        '''The name of the endpoint configuration, such as ``MyEndpointConfiguration`` .

        :cloudformationAttribute: EndpointConfigName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrEndpointConfigName"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="productionVariants")
    def production_variants(
        self,
    ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpointConfig.ProductionVariantProperty", _IResolvable_a771d0ef]]]:
        '''A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
        '''
        return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpointConfig.ProductionVariantProperty", _IResolvable_a771d0ef]]], jsii.get(self, "productionVariants"))

    @production_variants.setter
    def production_variants(
        self,
        value: typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpointConfig.ProductionVariantProperty", _IResolvable_a771d0ef]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bdbefc22154d6d83131198d915d91ecd1770eabecc7c1f4be7a1ea12eddae1dd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "productionVariants", value)

    @builtins.property
    @jsii.member(jsii_name="asyncInferenceConfig")
    def async_inference_config(
        self,
    ) -> typing.Optional[typing.Union["CfnEndpointConfig.AsyncInferenceConfigProperty", _IResolvable_a771d0ef]]:
        '''Specifies configuration for how an endpoint performs asynchronous inference.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnEndpointConfig.AsyncInferenceConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "asyncInferenceConfig"))

    @async_inference_config.setter
    def async_inference_config(
        self,
        value: typing.Optional[typing.Union["CfnEndpointConfig.AsyncInferenceConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e445a1fcdc879aacfc400fd2772a354af3396dbc3a61ad7ba3c4b1aeb802ff4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "asyncInferenceConfig", value)

    @builtins.property
    @jsii.member(jsii_name="dataCaptureConfig")
    def data_capture_config(
        self,
    ) -> typing.Optional[typing.Union["CfnEndpointConfig.DataCaptureConfigProperty", _IResolvable_a771d0ef]]:
        '''Specifies how to capture endpoint data for model monitor.

        The data capture configuration applies to all production variants hosted at the endpoint.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnEndpointConfig.DataCaptureConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "dataCaptureConfig"))

    @data_capture_config.setter
    def data_capture_config(
        self,
        value: typing.Optional[typing.Union["CfnEndpointConfig.DataCaptureConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bf1a3722a2c67bcf75ab9e0527606e5c7478b37c6af2ff30be080340ce5b6e6a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dataCaptureConfig", value)

    @builtins.property
    @jsii.member(jsii_name="endpointConfigName")
    def endpoint_config_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint configuration.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointConfigName"))

    @endpoint_config_name.setter
    def endpoint_config_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fefbdf07be23cd5b71cb244488a030b20523016ab6f4608d1e820459c2d14ffc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointConfigName", value)

    @builtins.property
    @jsii.member(jsii_name="explainerConfig")
    def explainer_config(
        self,
    ) -> typing.Optional[typing.Union["CfnEndpointConfig.ExplainerConfigProperty", _IResolvable_a771d0ef]]:
        '''``AWS::SageMaker::EndpointConfig.ExplainerConfig``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-explainerconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnEndpointConfig.ExplainerConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "explainerConfig"))

    @explainer_config.setter
    def explainer_config(
        self,
        value: typing.Optional[typing.Union["CfnEndpointConfig.ExplainerConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7bc2b2b077cab48b20d38f0eb1ab1485599f5e50830191c21be6b1a1a38905fa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "explainerConfig", value)

    @builtins.property
    @jsii.member(jsii_name="kmsKeyId")
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.

        - Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab``
        - Key ARN: ``arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab``
        - Alias name: ``alias/ExampleAlias``
        - Alias name ARN: ``arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias``

        The KMS key policy must grant permission to the IAM role that you specify in your ``CreateEndpoint`` , ``UpdateEndpoint`` requests. For more information, refer to the AWS Key Management Service section `Using Key Policies in AWS KMS <https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html>`_
        .. epigraph::

           Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a ``KmsKeyId`` when using an instance type with local storage. If any of the models that you specify in the ``ProductionVariants`` parameter use nitro-based instances with local storage, do not specify a value for the ``KmsKeyId`` parameter. If you specify a value for ``KmsKeyId`` when using any nitro-based instances with local storage, the call to ``CreateEndpointConfig`` fails.

           For a list of instance types that support local instance storage, see `Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes>`_ .

           For more information about local instance storage encryption, see `SSD Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "kmsKeyId"))

    @kms_key_id.setter
    def kms_key_id(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__735380ae075b546826e36bbdca274bc31b83b9d2031a9444568253b2cd4e7f15)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "kmsKeyId", value)

    @builtins.property
    @jsii.member(jsii_name="shadowProductionVariants")
    def shadow_production_variants(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpointConfig.ProductionVariantProperty", _IResolvable_a771d0ef]]]]:
        '''Array of ``ProductionVariant`` objects.

        There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ``ProductionVariants`` . If you use this field, you can only specify one variant for ``ProductionVariants`` and one variant for ``ShadowProductionVariants`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-shadowproductionvariants
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpointConfig.ProductionVariantProperty", _IResolvable_a771d0ef]]]], jsii.get(self, "shadowProductionVariants"))

    @shadow_production_variants.setter
    def shadow_production_variants(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpointConfig.ProductionVariantProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__854508399914af635f7685689f3f25aced9f08bef6b2066e4966cbec0388f4ef)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "shadowProductionVariants", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "max_concurrent_invocations_per_instance": "maxConcurrentInvocationsPerInstance",
        },
    )
    class AsyncInferenceClientConfigProperty:
        def __init__(
            self,
            *,
            max_concurrent_invocations_per_instance: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.

            :param max_concurrent_invocations_per_instance: The maximum number of concurrent requests sent by the SageMaker client to the model container. If no value is provided, SageMaker will choose an optimal value for you.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceclientconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                async_inference_client_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                    max_concurrent_invocations_per_instance=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__8beb7f9026f1bf338d7729f8e41f8d817c57683e9a2a14f1d7327e0fa1ccdaa9)
                check_type(argname="argument max_concurrent_invocations_per_instance", value=max_concurrent_invocations_per_instance, expected_type=type_hints["max_concurrent_invocations_per_instance"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if max_concurrent_invocations_per_instance is not None:
                self._values["max_concurrent_invocations_per_instance"] = max_concurrent_invocations_per_instance

        @builtins.property
        def max_concurrent_invocations_per_instance(
            self,
        ) -> typing.Optional[jsii.Number]:
            '''The maximum number of concurrent requests sent by the SageMaker client to the model container.

            If no value is provided, SageMaker will choose an optimal value for you.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceclientconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceclientconfig-maxconcurrentinvocationsperinstance
            '''
            result = self._values.get("max_concurrent_invocations_per_instance")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceClientConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "output_config": "outputConfig",
            "client_config": "clientConfig",
        },
    )
    class AsyncInferenceConfigProperty:
        def __init__(
            self,
            *,
            output_config: typing.Union[typing.Union["CfnEndpointConfig.AsyncInferenceOutputConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            client_config: typing.Optional[typing.Union[typing.Union["CfnEndpointConfig.AsyncInferenceClientConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies configuration for how an endpoint performs asynchronous inference.

            :param output_config: Specifies the configuration for asynchronous inference invocation outputs.
            :param client_config: Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                async_inference_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty(
                    output_config=sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                        s3_output_path="s3OutputPath",
                
                        # the properties below are optional
                        kms_key_id="kmsKeyId",
                        notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                            error_topic="errorTopic",
                            success_topic="successTopic"
                        )
                    ),
                
                    # the properties below are optional
                    client_config=sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                        max_concurrent_invocations_per_instance=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f5d8e87612c93bda350d7315d98f855e369a31a53dc09a960f338eeaad18676a)
                check_type(argname="argument output_config", value=output_config, expected_type=type_hints["output_config"])
                check_type(argname="argument client_config", value=client_config, expected_type=type_hints["client_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "output_config": output_config,
            }
            if client_config is not None:
                self._values["client_config"] = client_config

        @builtins.property
        def output_config(
            self,
        ) -> typing.Union["CfnEndpointConfig.AsyncInferenceOutputConfigProperty", _IResolvable_a771d0ef]:
            '''Specifies the configuration for asynchronous inference invocation outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig-outputconfig
            '''
            result = self._values.get("output_config")
            assert result is not None, "Required property 'output_config' is missing"
            return typing.cast(typing.Union["CfnEndpointConfig.AsyncInferenceOutputConfigProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def client_config(
            self,
        ) -> typing.Optional[typing.Union["CfnEndpointConfig.AsyncInferenceClientConfigProperty", _IResolvable_a771d0ef]]:
            '''Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig-clientconfig
            '''
            result = self._values.get("client_config")
            return typing.cast(typing.Optional[typing.Union["CfnEndpointConfig.AsyncInferenceClientConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"error_topic": "errorTopic", "success_topic": "successTopic"},
    )
    class AsyncInferenceNotificationConfigProperty:
        def __init__(
            self,
            *,
            error_topic: typing.Optional[builtins.str] = None,
            success_topic: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the configuration for notifications of inference results for asynchronous inference.

            :param error_topic: Amazon SNS topic to post a notification to when an inference fails. If no topic is provided, no notification is sent on failure.
            :param success_topic: Amazon SNS topic to post a notification to when an inference completes successfully. If no topic is provided, no notification is sent on success.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                async_inference_notification_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                    error_topic="errorTopic",
                    success_topic="successTopic"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__9d354ef38e0956bfeaf15c39b100500c7d634bff07f52e0b3e845da7dd8f9967)
                check_type(argname="argument error_topic", value=error_topic, expected_type=type_hints["error_topic"])
                check_type(argname="argument success_topic", value=success_topic, expected_type=type_hints["success_topic"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if error_topic is not None:
                self._values["error_topic"] = error_topic
            if success_topic is not None:
                self._values["success_topic"] = success_topic

        @builtins.property
        def error_topic(self) -> typing.Optional[builtins.str]:
            '''Amazon SNS topic to post a notification to when an inference fails.

            If no topic is provided, no notification is sent on failure.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-errortopic
            '''
            result = self._values.get("error_topic")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def success_topic(self) -> typing.Optional[builtins.str]:
            '''Amazon SNS topic to post a notification to when an inference completes successfully.

            If no topic is provided, no notification is sent on success.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-successtopic
            '''
            result = self._values.get("success_topic")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceNotificationConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "s3_output_path": "s3OutputPath",
            "kms_key_id": "kmsKeyId",
            "notification_config": "notificationConfig",
        },
    )
    class AsyncInferenceOutputConfigProperty:
        def __init__(
            self,
            *,
            s3_output_path: builtins.str,
            kms_key_id: typing.Optional[builtins.str] = None,
            notification_config: typing.Optional[typing.Union[typing.Union["CfnEndpointConfig.AsyncInferenceNotificationConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies the configuration for asynchronous inference invocation outputs.

            :param s3_output_path: The Amazon S3 location to upload inference responses to.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
            :param notification_config: Specifies the configuration for notifications of inference results for asynchronous inference.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                async_inference_output_config_property = sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                    s3_output_path="s3OutputPath",
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId",
                    notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                        error_topic="errorTopic",
                        success_topic="successTopic"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__81e8904a28c47107558df1e7478b08471dc174f9ce30cf32f98a3772d86672c3)
                check_type(argname="argument s3_output_path", value=s3_output_path, expected_type=type_hints["s3_output_path"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
                check_type(argname="argument notification_config", value=notification_config, expected_type=type_hints["notification_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_output_path": s3_output_path,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id
            if notification_config is not None:
                self._values["notification_config"] = notification_config

        @builtins.property
        def s3_output_path(self) -> builtins.str:
            '''The Amazon S3 location to upload inference responses to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-s3outputpath
            '''
            result = self._values.get("s3_output_path")
            assert result is not None, "Required property 's3_output_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def notification_config(
            self,
        ) -> typing.Optional[typing.Union["CfnEndpointConfig.AsyncInferenceNotificationConfigProperty", _IResolvable_a771d0ef]]:
            '''Specifies the configuration for notifications of inference results for asynchronous inference.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-notificationconfig
            '''
            result = self._values.get("notification_config")
            return typing.cast(typing.Optional[typing.Union["CfnEndpointConfig.AsyncInferenceNotificationConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AsyncInferenceOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty",
        jsii_struct_bases=[],
        name_mapping={
            "csv_content_types": "csvContentTypes",
            "json_content_types": "jsonContentTypes",
        },
    )
    class CaptureContentTypeHeaderProperty:
        def __init__(
            self,
            *,
            csv_content_types: typing.Optional[typing.Sequence[builtins.str]] = None,
            json_content_types: typing.Optional[typing.Sequence[builtins.str]] = None,
        ) -> None:
            '''Specifies the JSON and CSV content types of the data that the endpoint captures.

            :param csv_content_types: A list of the CSV content types of the data that the endpoint captures. For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.
            :param json_content_types: A list of the JSON content types of the data that the endpoint captures. For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                capture_content_type_header_property = sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                    csv_content_types=["csvContentTypes"],
                    json_content_types=["jsonContentTypes"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6de7a09a06518228bb0f38381a9d08436fb40f45ff9266351cf0c023cfb49e18)
                check_type(argname="argument csv_content_types", value=csv_content_types, expected_type=type_hints["csv_content_types"])
                check_type(argname="argument json_content_types", value=json_content_types, expected_type=type_hints["json_content_types"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if csv_content_types is not None:
                self._values["csv_content_types"] = csv_content_types
            if json_content_types is not None:
                self._values["json_content_types"] = json_content_types

        @builtins.property
        def csv_content_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''A list of the CSV content types of the data that the endpoint captures.

            For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-csvcontenttypes
            '''
            result = self._values.get("csv_content_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def json_content_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''A list of the JSON content types of the data that the endpoint captures.

            For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-jsoncontenttypes
            '''
            result = self._values.get("json_content_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptureContentTypeHeaderProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.CaptureOptionProperty",
        jsii_struct_bases=[],
        name_mapping={"capture_mode": "captureMode"},
    )
    class CaptureOptionProperty:
        def __init__(self, *, capture_mode: builtins.str) -> None:
            '''Specifies whether the endpoint captures input data or output data.

            :param capture_mode: Specifies whether the endpoint captures input data or output data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                capture_option_property = sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                    capture_mode="captureMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ef06f07a27053165fd3a7b2fc4a9fbc24861ddc96d58c32ab39dad84e658cf54)
                check_type(argname="argument capture_mode", value=capture_mode, expected_type=type_hints["capture_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "capture_mode": capture_mode,
            }

        @builtins.property
        def capture_mode(self) -> builtins.str:
            '''Specifies whether the endpoint captures input data or output data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html#cfn-sagemaker-endpointconfig-captureoption-capturemode
            '''
            result = self._values.get("capture_mode")
            assert result is not None, "Required property 'capture_mode' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptureOptionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "shap_config": "shapConfig",
            "enable_explanations": "enableExplanations",
            "inference_config": "inferenceConfig",
        },
    )
    class ClarifyExplainerConfigProperty:
        def __init__(
            self,
            *,
            shap_config: typing.Union[typing.Union["CfnEndpointConfig.ClarifyShapConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            enable_explanations: typing.Optional[builtins.str] = None,
            inference_config: typing.Optional[typing.Union[typing.Union["CfnEndpointConfig.ClarifyInferenceConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param shap_config: ``CfnEndpointConfig.ClarifyExplainerConfigProperty.ShapConfig``.
            :param enable_explanations: ``CfnEndpointConfig.ClarifyExplainerConfigProperty.EnableExplanations``.
            :param inference_config: ``CfnEndpointConfig.ClarifyExplainerConfigProperty.InferenceConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                clarify_explainer_config_property = sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                    shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                        shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                            mime_type="mimeType",
                            shap_baseline="shapBaseline",
                            shap_baseline_uri="shapBaselineUri"
                        ),
                
                        # the properties below are optional
                        number_of_samples=123,
                        seed=123,
                        text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                            granularity="granularity",
                            language="language"
                        ),
                        use_logit=False
                    ),
                
                    # the properties below are optional
                    enable_explanations="enableExplanations",
                    inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                        content_template="contentTemplate",
                        feature_headers=["featureHeaders"],
                        features_attribute="featuresAttribute",
                        feature_types=["featureTypes"],
                        label_attribute="labelAttribute",
                        label_headers=["labelHeaders"],
                        label_index=123,
                        max_payload_in_mb=123,
                        max_record_count=123,
                        probability_attribute="probabilityAttribute",
                        probability_index=123
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__399eeca675673bbba4e79cf254c776436e61c6e2b64a501418f2c4d2191bc331)
                check_type(argname="argument shap_config", value=shap_config, expected_type=type_hints["shap_config"])
                check_type(argname="argument enable_explanations", value=enable_explanations, expected_type=type_hints["enable_explanations"])
                check_type(argname="argument inference_config", value=inference_config, expected_type=type_hints["inference_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "shap_config": shap_config,
            }
            if enable_explanations is not None:
                self._values["enable_explanations"] = enable_explanations
            if inference_config is not None:
                self._values["inference_config"] = inference_config

        @builtins.property
        def shap_config(
            self,
        ) -> typing.Union["CfnEndpointConfig.ClarifyShapConfigProperty", _IResolvable_a771d0ef]:
            '''``CfnEndpointConfig.ClarifyExplainerConfigProperty.ShapConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-shapconfig
            '''
            result = self._values.get("shap_config")
            assert result is not None, "Required property 'shap_config' is missing"
            return typing.cast(typing.Union["CfnEndpointConfig.ClarifyShapConfigProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def enable_explanations(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyExplainerConfigProperty.EnableExplanations``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-enableexplanations
            '''
            result = self._values.get("enable_explanations")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def inference_config(
            self,
        ) -> typing.Optional[typing.Union["CfnEndpointConfig.ClarifyInferenceConfigProperty", _IResolvable_a771d0ef]]:
            '''``CfnEndpointConfig.ClarifyExplainerConfigProperty.InferenceConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-inferenceconfig
            '''
            result = self._values.get("inference_config")
            return typing.cast(typing.Optional[typing.Union["CfnEndpointConfig.ClarifyInferenceConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyExplainerConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "content_template": "contentTemplate",
            "feature_headers": "featureHeaders",
            "features_attribute": "featuresAttribute",
            "feature_types": "featureTypes",
            "label_attribute": "labelAttribute",
            "label_headers": "labelHeaders",
            "label_index": "labelIndex",
            "max_payload_in_mb": "maxPayloadInMb",
            "max_record_count": "maxRecordCount",
            "probability_attribute": "probabilityAttribute",
            "probability_index": "probabilityIndex",
        },
    )
    class ClarifyInferenceConfigProperty:
        def __init__(
            self,
            *,
            content_template: typing.Optional[builtins.str] = None,
            feature_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            features_attribute: typing.Optional[builtins.str] = None,
            feature_types: typing.Optional[typing.Sequence[builtins.str]] = None,
            label_attribute: typing.Optional[builtins.str] = None,
            label_headers: typing.Optional[typing.Sequence[builtins.str]] = None,
            label_index: typing.Optional[jsii.Number] = None,
            max_payload_in_mb: typing.Optional[jsii.Number] = None,
            max_record_count: typing.Optional[jsii.Number] = None,
            probability_attribute: typing.Optional[builtins.str] = None,
            probability_index: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''
            :param content_template: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.ContentTemplate``.
            :param feature_headers: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeatureHeaders``.
            :param features_attribute: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeaturesAttribute``.
            :param feature_types: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeatureTypes``.
            :param label_attribute: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelAttribute``.
            :param label_headers: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelHeaders``.
            :param label_index: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelIndex``.
            :param max_payload_in_mb: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.MaxPayloadInMB``.
            :param max_record_count: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.MaxRecordCount``.
            :param probability_attribute: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.ProbabilityAttribute``.
            :param probability_index: ``CfnEndpointConfig.ClarifyInferenceConfigProperty.ProbabilityIndex``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                clarify_inference_config_property = sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                    content_template="contentTemplate",
                    feature_headers=["featureHeaders"],
                    features_attribute="featuresAttribute",
                    feature_types=["featureTypes"],
                    label_attribute="labelAttribute",
                    label_headers=["labelHeaders"],
                    label_index=123,
                    max_payload_in_mb=123,
                    max_record_count=123,
                    probability_attribute="probabilityAttribute",
                    probability_index=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__35a7f23ccdf836393be554f4b9a21afacd98c48900b3a172cfd18bc0f04e1cc6)
                check_type(argname="argument content_template", value=content_template, expected_type=type_hints["content_template"])
                check_type(argname="argument feature_headers", value=feature_headers, expected_type=type_hints["feature_headers"])
                check_type(argname="argument features_attribute", value=features_attribute, expected_type=type_hints["features_attribute"])
                check_type(argname="argument feature_types", value=feature_types, expected_type=type_hints["feature_types"])
                check_type(argname="argument label_attribute", value=label_attribute, expected_type=type_hints["label_attribute"])
                check_type(argname="argument label_headers", value=label_headers, expected_type=type_hints["label_headers"])
                check_type(argname="argument label_index", value=label_index, expected_type=type_hints["label_index"])
                check_type(argname="argument max_payload_in_mb", value=max_payload_in_mb, expected_type=type_hints["max_payload_in_mb"])
                check_type(argname="argument max_record_count", value=max_record_count, expected_type=type_hints["max_record_count"])
                check_type(argname="argument probability_attribute", value=probability_attribute, expected_type=type_hints["probability_attribute"])
                check_type(argname="argument probability_index", value=probability_index, expected_type=type_hints["probability_index"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if content_template is not None:
                self._values["content_template"] = content_template
            if feature_headers is not None:
                self._values["feature_headers"] = feature_headers
            if features_attribute is not None:
                self._values["features_attribute"] = features_attribute
            if feature_types is not None:
                self._values["feature_types"] = feature_types
            if label_attribute is not None:
                self._values["label_attribute"] = label_attribute
            if label_headers is not None:
                self._values["label_headers"] = label_headers
            if label_index is not None:
                self._values["label_index"] = label_index
            if max_payload_in_mb is not None:
                self._values["max_payload_in_mb"] = max_payload_in_mb
            if max_record_count is not None:
                self._values["max_record_count"] = max_record_count
            if probability_attribute is not None:
                self._values["probability_attribute"] = probability_attribute
            if probability_index is not None:
                self._values["probability_index"] = probability_index

        @builtins.property
        def content_template(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.ContentTemplate``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-contenttemplate
            '''
            result = self._values.get("content_template")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def feature_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeatureHeaders``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featureheaders
            '''
            result = self._values.get("feature_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def features_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeaturesAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featuresattribute
            '''
            result = self._values.get("features_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def feature_types(self) -> typing.Optional[typing.List[builtins.str]]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.FeatureTypes``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featuretypes
            '''
            result = self._values.get("feature_types")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def label_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelattribute
            '''
            result = self._values.get("label_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def label_headers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelHeaders``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelheaders
            '''
            result = self._values.get("label_headers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def label_index(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.LabelIndex``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelindex
            '''
            result = self._values.get("label_index")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def max_payload_in_mb(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.MaxPayloadInMB``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-maxpayloadinmb
            '''
            result = self._values.get("max_payload_in_mb")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def max_record_count(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.MaxRecordCount``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-maxrecordcount
            '''
            result = self._values.get("max_record_count")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def probability_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.ProbabilityAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-probabilityattribute
            '''
            result = self._values.get("probability_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_index(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyInferenceConfigProperty.ProbabilityIndex``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-probabilityindex
            '''
            result = self._values.get("probability_index")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyInferenceConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "mime_type": "mimeType",
            "shap_baseline": "shapBaseline",
            "shap_baseline_uri": "shapBaselineUri",
        },
    )
    class ClarifyShapBaselineConfigProperty:
        def __init__(
            self,
            *,
            mime_type: typing.Optional[builtins.str] = None,
            shap_baseline: typing.Optional[builtins.str] = None,
            shap_baseline_uri: typing.Optional[builtins.str] = None,
        ) -> None:
            '''
            :param mime_type: ``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.MimeType``.
            :param shap_baseline: ``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.ShapBaseline``.
            :param shap_baseline_uri: ``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.ShapBaselineUri``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                clarify_shap_baseline_config_property = sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                    mime_type="mimeType",
                    shap_baseline="shapBaseline",
                    shap_baseline_uri="shapBaselineUri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__12f572c4f99e0d62ef58a65307d118e3ced2089c475d4039476f64af6bd0a504)
                check_type(argname="argument mime_type", value=mime_type, expected_type=type_hints["mime_type"])
                check_type(argname="argument shap_baseline", value=shap_baseline, expected_type=type_hints["shap_baseline"])
                check_type(argname="argument shap_baseline_uri", value=shap_baseline_uri, expected_type=type_hints["shap_baseline_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if mime_type is not None:
                self._values["mime_type"] = mime_type
            if shap_baseline is not None:
                self._values["shap_baseline"] = shap_baseline
            if shap_baseline_uri is not None:
                self._values["shap_baseline_uri"] = shap_baseline_uri

        @builtins.property
        def mime_type(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.MimeType``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-mimetype
            '''
            result = self._values.get("mime_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def shap_baseline(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.ShapBaseline``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-shapbaseline
            '''
            result = self._values.get("shap_baseline")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def shap_baseline_uri(self) -> typing.Optional[builtins.str]:
            '''``CfnEndpointConfig.ClarifyShapBaselineConfigProperty.ShapBaselineUri``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-shapbaselineuri
            '''
            result = self._values.get("shap_baseline_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyShapBaselineConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "shap_baseline_config": "shapBaselineConfig",
            "number_of_samples": "numberOfSamples",
            "seed": "seed",
            "text_config": "textConfig",
            "use_logit": "useLogit",
        },
    )
    class ClarifyShapConfigProperty:
        def __init__(
            self,
            *,
            shap_baseline_config: typing.Union[typing.Union["CfnEndpointConfig.ClarifyShapBaselineConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            number_of_samples: typing.Optional[jsii.Number] = None,
            seed: typing.Optional[jsii.Number] = None,
            text_config: typing.Optional[typing.Union[typing.Union["CfnEndpointConfig.ClarifyTextConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            use_logit: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param shap_baseline_config: ``CfnEndpointConfig.ClarifyShapConfigProperty.ShapBaselineConfig``.
            :param number_of_samples: ``CfnEndpointConfig.ClarifyShapConfigProperty.NumberOfSamples``.
            :param seed: ``CfnEndpointConfig.ClarifyShapConfigProperty.Seed``.
            :param text_config: ``CfnEndpointConfig.ClarifyShapConfigProperty.TextConfig``.
            :param use_logit: ``CfnEndpointConfig.ClarifyShapConfigProperty.UseLogit``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                clarify_shap_config_property = sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                    shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                        mime_type="mimeType",
                        shap_baseline="shapBaseline",
                        shap_baseline_uri="shapBaselineUri"
                    ),
                
                    # the properties below are optional
                    number_of_samples=123,
                    seed=123,
                    text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                        granularity="granularity",
                        language="language"
                    ),
                    use_logit=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__ad6d2a5e808c0acbdf4f66ae1c985c64d9004256ad625da386fdeb5c88e7b36c)
                check_type(argname="argument shap_baseline_config", value=shap_baseline_config, expected_type=type_hints["shap_baseline_config"])
                check_type(argname="argument number_of_samples", value=number_of_samples, expected_type=type_hints["number_of_samples"])
                check_type(argname="argument seed", value=seed, expected_type=type_hints["seed"])
                check_type(argname="argument text_config", value=text_config, expected_type=type_hints["text_config"])
                check_type(argname="argument use_logit", value=use_logit, expected_type=type_hints["use_logit"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "shap_baseline_config": shap_baseline_config,
            }
            if number_of_samples is not None:
                self._values["number_of_samples"] = number_of_samples
            if seed is not None:
                self._values["seed"] = seed
            if text_config is not None:
                self._values["text_config"] = text_config
            if use_logit is not None:
                self._values["use_logit"] = use_logit

        @builtins.property
        def shap_baseline_config(
            self,
        ) -> typing.Union["CfnEndpointConfig.ClarifyShapBaselineConfigProperty", _IResolvable_a771d0ef]:
            '''``CfnEndpointConfig.ClarifyShapConfigProperty.ShapBaselineConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-shapbaselineconfig
            '''
            result = self._values.get("shap_baseline_config")
            assert result is not None, "Required property 'shap_baseline_config' is missing"
            return typing.cast(typing.Union["CfnEndpointConfig.ClarifyShapBaselineConfigProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def number_of_samples(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyShapConfigProperty.NumberOfSamples``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-numberofsamples
            '''
            result = self._values.get("number_of_samples")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def seed(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ClarifyShapConfigProperty.Seed``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-seed
            '''
            result = self._values.get("seed")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def text_config(
            self,
        ) -> typing.Optional[typing.Union["CfnEndpointConfig.ClarifyTextConfigProperty", _IResolvable_a771d0ef]]:
            '''``CfnEndpointConfig.ClarifyShapConfigProperty.TextConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-textconfig
            '''
            result = self._values.get("text_config")
            return typing.cast(typing.Optional[typing.Union["CfnEndpointConfig.ClarifyTextConfigProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def use_logit(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''``CfnEndpointConfig.ClarifyShapConfigProperty.UseLogit``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-uselogit
            '''
            result = self._values.get("use_logit")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyShapConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"granularity": "granularity", "language": "language"},
    )
    class ClarifyTextConfigProperty:
        def __init__(
            self,
            *,
            granularity: builtins.str,
            language: builtins.str,
        ) -> None:
            '''
            :param granularity: ``CfnEndpointConfig.ClarifyTextConfigProperty.Granularity``.
            :param language: ``CfnEndpointConfig.ClarifyTextConfigProperty.Language``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                clarify_text_config_property = sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                    granularity="granularity",
                    language="language"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__207e2d5199bb7445a881da6d20b96fc55584d54aa0538ff7e8fa68dff31b0a93)
                check_type(argname="argument granularity", value=granularity, expected_type=type_hints["granularity"])
                check_type(argname="argument language", value=language, expected_type=type_hints["language"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "granularity": granularity,
                "language": language,
            }

        @builtins.property
        def granularity(self) -> builtins.str:
            '''``CfnEndpointConfig.ClarifyTextConfigProperty.Granularity``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html#cfn-sagemaker-endpointconfig-clarifytextconfig-granularity
            '''
            result = self._values.get("granularity")
            assert result is not None, "Required property 'granularity' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def language(self) -> builtins.str:
            '''``CfnEndpointConfig.ClarifyTextConfigProperty.Language``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html#cfn-sagemaker-endpointconfig-clarifytextconfig-language
            '''
            result = self._values.get("language")
            assert result is not None, "Required property 'language' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClarifyTextConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.DataCaptureConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "capture_options": "captureOptions",
            "destination_s3_uri": "destinationS3Uri",
            "initial_sampling_percentage": "initialSamplingPercentage",
            "capture_content_type_header": "captureContentTypeHeader",
            "enable_capture": "enableCapture",
            "kms_key_id": "kmsKeyId",
        },
    )
    class DataCaptureConfigProperty:
        def __init__(
            self,
            *,
            capture_options: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnEndpointConfig.CaptureOptionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
            destination_s3_uri: builtins.str,
            initial_sampling_percentage: jsii.Number,
            capture_content_type_header: typing.Optional[typing.Union[typing.Union["CfnEndpointConfig.CaptureContentTypeHeaderProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            enable_capture: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies the configuration of your endpoint for model monitor data capture.

            :param capture_options: Specifies whether the endpoint captures input data to your model, output data from your model, or both.
            :param destination_s3_uri: The S3 bucket where model monitor stores captured data.
            :param initial_sampling_percentage: The percentage of data to capture.
            :param capture_content_type_header: A list of the JSON and CSV content type that the endpoint captures.
            :param enable_capture: Set to ``True`` to enable data capture.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the captured data at rest using Amazon S3 server-side encryption. The KmsKeyId can be any of the following formats: Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab Alias name: alias/ExampleAlias Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the Amazon Simple Storage Service Developer Guide. The KMS key policy must grant permission to the IAM role that you specify in your CreateModel (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html) request. For more information, see Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the AWS Key Management Service Developer Guide.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                data_capture_config_property = sagemaker.CfnEndpointConfig.DataCaptureConfigProperty(
                    capture_options=[sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                        capture_mode="captureMode"
                    )],
                    destination_s3_uri="destinationS3Uri",
                    initial_sampling_percentage=123,
                
                    # the properties below are optional
                    capture_content_type_header=sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                        csv_content_types=["csvContentTypes"],
                        json_content_types=["jsonContentTypes"]
                    ),
                    enable_capture=False,
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f5ad1b705d9b053dcffe5fbb860d4e079a8be68887145fe94f018ec1a89fd528)
                check_type(argname="argument capture_options", value=capture_options, expected_type=type_hints["capture_options"])
                check_type(argname="argument destination_s3_uri", value=destination_s3_uri, expected_type=type_hints["destination_s3_uri"])
                check_type(argname="argument initial_sampling_percentage", value=initial_sampling_percentage, expected_type=type_hints["initial_sampling_percentage"])
                check_type(argname="argument capture_content_type_header", value=capture_content_type_header, expected_type=type_hints["capture_content_type_header"])
                check_type(argname="argument enable_capture", value=enable_capture, expected_type=type_hints["enable_capture"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "capture_options": capture_options,
                "destination_s3_uri": destination_s3_uri,
                "initial_sampling_percentage": initial_sampling_percentage,
            }
            if capture_content_type_header is not None:
                self._values["capture_content_type_header"] = capture_content_type_header
            if enable_capture is not None:
                self._values["enable_capture"] = enable_capture
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def capture_options(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpointConfig.CaptureOptionProperty", _IResolvable_a771d0ef]]]:
            '''Specifies whether the endpoint captures input data to your model, output data from your model, or both.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-captureoptions
            '''
            result = self._values.get("capture_options")
            assert result is not None, "Required property 'capture_options' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnEndpointConfig.CaptureOptionProperty", _IResolvable_a771d0ef]]], result)

        @builtins.property
        def destination_s3_uri(self) -> builtins.str:
            '''The S3 bucket where model monitor stores captured data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-destinations3uri
            '''
            result = self._values.get("destination_s3_uri")
            assert result is not None, "Required property 'destination_s3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def initial_sampling_percentage(self) -> jsii.Number:
            '''The percentage of data to capture.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-initialsamplingpercentage
            '''
            result = self._values.get("initial_sampling_percentage")
            assert result is not None, "Required property 'initial_sampling_percentage' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def capture_content_type_header(
            self,
        ) -> typing.Optional[typing.Union["CfnEndpointConfig.CaptureContentTypeHeaderProperty", _IResolvable_a771d0ef]]:
            '''A list of the JSON and CSV content type that the endpoint captures.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader
            '''
            result = self._values.get("capture_content_type_header")
            return typing.cast(typing.Optional[typing.Union["CfnEndpointConfig.CaptureContentTypeHeaderProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def enable_capture(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''Set to ``True`` to enable data capture.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-enablecapture
            '''
            result = self._values.get("enable_capture")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the captured data at rest using Amazon S3 server-side encryption.

            The KmsKeyId can be any of the following formats: Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab Alias name: alias/ExampleAlias Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the Amazon Simple Storage Service Developer Guide. The KMS key policy must grant permission to the IAM role that you specify in your CreateModel (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html) request. For more information, see Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the AWS Key Management Service Developer Guide.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataCaptureConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.ExplainerConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"clarify_explainer_config": "clarifyExplainerConfig"},
    )
    class ExplainerConfigProperty:
        def __init__(
            self,
            *,
            clarify_explainer_config: typing.Optional[typing.Union[typing.Union["CfnEndpointConfig.ClarifyExplainerConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param clarify_explainer_config: ``CfnEndpointConfig.ExplainerConfigProperty.ClarifyExplainerConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-explainerconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                explainer_config_property = sagemaker.CfnEndpointConfig.ExplainerConfigProperty(
                    clarify_explainer_config=sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                        shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                            shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                                mime_type="mimeType",
                                shap_baseline="shapBaseline",
                                shap_baseline_uri="shapBaselineUri"
                            ),
                
                            # the properties below are optional
                            number_of_samples=123,
                            seed=123,
                            text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                                granularity="granularity",
                                language="language"
                            ),
                            use_logit=False
                        ),
                
                        # the properties below are optional
                        enable_explanations="enableExplanations",
                        inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                            content_template="contentTemplate",
                            feature_headers=["featureHeaders"],
                            features_attribute="featuresAttribute",
                            feature_types=["featureTypes"],
                            label_attribute="labelAttribute",
                            label_headers=["labelHeaders"],
                            label_index=123,
                            max_payload_in_mb=123,
                            max_record_count=123,
                            probability_attribute="probabilityAttribute",
                            probability_index=123
                        )
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b2264d319791ce9db1e4327989b3e1076eb5581a3e557a6cb28b6d1740bad87c)
                check_type(argname="argument clarify_explainer_config", value=clarify_explainer_config, expected_type=type_hints["clarify_explainer_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if clarify_explainer_config is not None:
                self._values["clarify_explainer_config"] = clarify_explainer_config

        @builtins.property
        def clarify_explainer_config(
            self,
        ) -> typing.Optional[typing.Union["CfnEndpointConfig.ClarifyExplainerConfigProperty", _IResolvable_a771d0ef]]:
            '''``CfnEndpointConfig.ExplainerConfigProperty.ClarifyExplainerConfig``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-explainerconfig.html#cfn-sagemaker-endpointconfig-explainerconfig-clarifyexplainerconfig
            '''
            result = self._values.get("clarify_explainer_config")
            return typing.cast(typing.Optional[typing.Union["CfnEndpointConfig.ClarifyExplainerConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ExplainerConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.ProductionVariantProperty",
        jsii_struct_bases=[],
        name_mapping={
            "initial_variant_weight": "initialVariantWeight",
            "model_name": "modelName",
            "variant_name": "variantName",
            "accelerator_type": "acceleratorType",
            "container_startup_health_check_timeout_in_seconds": "containerStartupHealthCheckTimeoutInSeconds",
            "initial_instance_count": "initialInstanceCount",
            "instance_type": "instanceType",
            "model_data_download_timeout_in_seconds": "modelDataDownloadTimeoutInSeconds",
            "serverless_config": "serverlessConfig",
            "volume_size_in_gb": "volumeSizeInGb",
        },
    )
    class ProductionVariantProperty:
        def __init__(
            self,
            *,
            initial_variant_weight: jsii.Number,
            model_name: builtins.str,
            variant_name: builtins.str,
            accelerator_type: typing.Optional[builtins.str] = None,
            container_startup_health_check_timeout_in_seconds: typing.Optional[jsii.Number] = None,
            initial_instance_count: typing.Optional[jsii.Number] = None,
            instance_type: typing.Optional[builtins.str] = None,
            model_data_download_timeout_in_seconds: typing.Optional[jsii.Number] = None,
            serverless_config: typing.Optional[typing.Union[typing.Union["CfnEndpointConfig.ServerlessConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            volume_size_in_gb: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Specifies a model that you want to host and the resources to deploy for hosting it.

            If you are deploying multiple models, tell Amazon SageMaker how to distribute traffic among the models by specifying the ``InitialVariantWeight`` objects.

            :param initial_variant_weight: Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the ``VariantWeight`` to the sum of all ``VariantWeight`` values across all ProductionVariants. If unspecified, it defaults to 1.0.
            :param model_name: The name of the model that you want to host. This is the name that you specified when creating the model.
            :param variant_name: The name of the production variant.
            :param accelerator_type: The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ . For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ .
            :param container_startup_health_check_timeout_in_seconds: ``CfnEndpointConfig.ProductionVariantProperty.ContainerStartupHealthCheckTimeoutInSeconds``.
            :param initial_instance_count: Number of instances to launch initially.
            :param instance_type: The ML compute instance type.
            :param model_data_download_timeout_in_seconds: ``CfnEndpointConfig.ProductionVariantProperty.ModelDataDownloadTimeoutInSeconds``.
            :param serverless_config: The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
            :param volume_size_in_gb: ``CfnEndpointConfig.ProductionVariantProperty.VolumeSizeInGB``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                production_variant_property = sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                    initial_variant_weight=123,
                    model_name="modelName",
                    variant_name="variantName",
                
                    # the properties below are optional
                    accelerator_type="acceleratorType",
                    container_startup_health_check_timeout_in_seconds=123,
                    initial_instance_count=123,
                    instance_type="instanceType",
                    model_data_download_timeout_in_seconds=123,
                    serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                        max_concurrency=123,
                        memory_size_in_mb=123
                    ),
                    volume_size_in_gb=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bdb76a4691d9bdb8d3bee90f1d1540c59b6fb27f667d935ca7c425d7f2a33ad9)
                check_type(argname="argument initial_variant_weight", value=initial_variant_weight, expected_type=type_hints["initial_variant_weight"])
                check_type(argname="argument model_name", value=model_name, expected_type=type_hints["model_name"])
                check_type(argname="argument variant_name", value=variant_name, expected_type=type_hints["variant_name"])
                check_type(argname="argument accelerator_type", value=accelerator_type, expected_type=type_hints["accelerator_type"])
                check_type(argname="argument container_startup_health_check_timeout_in_seconds", value=container_startup_health_check_timeout_in_seconds, expected_type=type_hints["container_startup_health_check_timeout_in_seconds"])
                check_type(argname="argument initial_instance_count", value=initial_instance_count, expected_type=type_hints["initial_instance_count"])
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument model_data_download_timeout_in_seconds", value=model_data_download_timeout_in_seconds, expected_type=type_hints["model_data_download_timeout_in_seconds"])
                check_type(argname="argument serverless_config", value=serverless_config, expected_type=type_hints["serverless_config"])
                check_type(argname="argument volume_size_in_gb", value=volume_size_in_gb, expected_type=type_hints["volume_size_in_gb"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "initial_variant_weight": initial_variant_weight,
                "model_name": model_name,
                "variant_name": variant_name,
            }
            if accelerator_type is not None:
                self._values["accelerator_type"] = accelerator_type
            if container_startup_health_check_timeout_in_seconds is not None:
                self._values["container_startup_health_check_timeout_in_seconds"] = container_startup_health_check_timeout_in_seconds
            if initial_instance_count is not None:
                self._values["initial_instance_count"] = initial_instance_count
            if instance_type is not None:
                self._values["instance_type"] = instance_type
            if model_data_download_timeout_in_seconds is not None:
                self._values["model_data_download_timeout_in_seconds"] = model_data_download_timeout_in_seconds
            if serverless_config is not None:
                self._values["serverless_config"] = serverless_config
            if volume_size_in_gb is not None:
                self._values["volume_size_in_gb"] = volume_size_in_gb

        @builtins.property
        def initial_variant_weight(self) -> jsii.Number:
            '''Determines initial traffic distribution among all of the models that you specify in the endpoint configuration.

            The traffic to a production variant is determined by the ratio of the ``VariantWeight`` to the sum of all ``VariantWeight`` values across all ProductionVariants. If unspecified, it defaults to 1.0.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
            '''
            result = self._values.get("initial_variant_weight")
            assert result is not None, "Required property 'initial_variant_weight' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def model_name(self) -> builtins.str:
            '''The name of the model that you want to host.

            This is the name that you specified when creating the model.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
            '''
            result = self._values.get("model_name")
            assert result is not None, "Required property 'model_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def variant_name(self) -> builtins.str:
            '''The name of the production variant.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
            '''
            result = self._values.get("variant_name")
            assert result is not None, "Required property 'variant_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def accelerator_type(self) -> typing.Optional[builtins.str]:
            '''The size of the Elastic Inference (EI) instance to use for the production variant.

            EI instances provide on-demand GPU computing for inference. For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ . For more information, see `Using Elastic Inference in Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
            '''
            result = self._values.get("accelerator_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def container_startup_health_check_timeout_in_seconds(
            self,
        ) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ProductionVariantProperty.ContainerStartupHealthCheckTimeoutInSeconds``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-containerstartuphealthchecktimeoutinseconds
            '''
            result = self._values.get("container_startup_health_check_timeout_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def initial_instance_count(self) -> typing.Optional[jsii.Number]:
            '''Number of instances to launch initially.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
            '''
            result = self._values.get("initial_instance_count")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def instance_type(self) -> typing.Optional[builtins.str]:
            '''The ML compute instance type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
            '''
            result = self._values.get("instance_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def model_data_download_timeout_in_seconds(
            self,
        ) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ProductionVariantProperty.ModelDataDownloadTimeoutInSeconds``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modeldatadownloadtimeoutinseconds
            '''
            result = self._values.get("model_data_download_timeout_in_seconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def serverless_config(
            self,
        ) -> typing.Optional[typing.Union["CfnEndpointConfig.ServerlessConfigProperty", _IResolvable_a771d0ef]]:
            '''The serverless configuration for an endpoint.

            Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-serverlessconfig
            '''
            result = self._values.get("serverless_config")
            return typing.cast(typing.Optional[typing.Union["CfnEndpointConfig.ServerlessConfigProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def volume_size_in_gb(self) -> typing.Optional[jsii.Number]:
            '''``CfnEndpointConfig.ProductionVariantProperty.VolumeSizeInGB``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-volumesizeingb
            '''
            result = self._values.get("volume_size_in_gb")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ProductionVariantProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnEndpointConfig.ServerlessConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "max_concurrency": "maxConcurrency",
            "memory_size_in_mb": "memorySizeInMb",
        },
    )
    class ServerlessConfigProperty:
        def __init__(
            self,
            *,
            max_concurrency: jsii.Number,
            memory_size_in_mb: jsii.Number,
        ) -> None:
            '''Specifies the serverless configuration for an endpoint variant.

            :param max_concurrency: The maximum number of concurrent invocations your serverless endpoint can process.
            :param memory_size_in_mb: The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant-serverlessconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                serverless_config_property = sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                    max_concurrency=123,
                    memory_size_in_mb=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a9de6713783d2ed0343f0da75e6d5940d675bee2d5f2940d180052801eace591)
                check_type(argname="argument max_concurrency", value=max_concurrency, expected_type=type_hints["max_concurrency"])
                check_type(argname="argument memory_size_in_mb", value=memory_size_in_mb, expected_type=type_hints["memory_size_in_mb"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "max_concurrency": max_concurrency,
                "memory_size_in_mb": memory_size_in_mb,
            }

        @builtins.property
        def max_concurrency(self) -> jsii.Number:
            '''The maximum number of concurrent invocations your serverless endpoint can process.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant-serverlessconfig.html#cfn-sagemaker-endpointconfig-productionvariant-serverlessconfig-maxconcurrency
            '''
            result = self._values.get("max_concurrency")
            assert result is not None, "Required property 'max_concurrency' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def memory_size_in_mb(self) -> jsii.Number:
            '''The memory size of your serverless endpoint.

            Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant-serverlessconfig.html#cfn-sagemaker-endpointconfig-productionvariant-serverlessconfig-memorysizeinmb
            '''
            result = self._values.get("memory_size_in_mb")
            assert result is not None, "Required property 'memory_size_in_mb' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ServerlessConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnEndpointConfigProps",
    jsii_struct_bases=[],
    name_mapping={
        "production_variants": "productionVariants",
        "async_inference_config": "asyncInferenceConfig",
        "data_capture_config": "dataCaptureConfig",
        "endpoint_config_name": "endpointConfigName",
        "explainer_config": "explainerConfig",
        "kms_key_id": "kmsKeyId",
        "shadow_production_variants": "shadowProductionVariants",
        "tags": "tags",
    },
)
class CfnEndpointConfigProps:
    def __init__(
        self,
        *,
        production_variants: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union[CfnEndpointConfig.ProductionVariantProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        async_inference_config: typing.Optional[typing.Union[typing.Union[CfnEndpointConfig.AsyncInferenceConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        data_capture_config: typing.Optional[typing.Union[typing.Union[CfnEndpointConfig.DataCaptureConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        endpoint_config_name: typing.Optional[builtins.str] = None,
        explainer_config: typing.Optional[typing.Union[typing.Union[CfnEndpointConfig.ExplainerConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        shadow_production_variants: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union[CfnEndpointConfig.ProductionVariantProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnEndpointConfig``.

        :param production_variants: A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.
        :param async_inference_config: Specifies configuration for how an endpoint performs asynchronous inference.
        :param data_capture_config: Specifies how to capture endpoint data for model monitor. The data capture configuration applies to all production variants hosted at the endpoint.
        :param endpoint_config_name: The name of the endpoint configuration.
        :param explainer_config: ``AWS::SageMaker::EndpointConfig.ExplainerConfig``.
        :param kms_key_id: The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. - Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab`` - Key ARN: ``arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`` - Alias name: ``alias/ExampleAlias`` - Alias name ARN: ``arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`` The KMS key policy must grant permission to the IAM role that you specify in your ``CreateEndpoint`` , ``UpdateEndpoint`` requests. For more information, refer to the AWS Key Management Service section `Using Key Policies in AWS KMS <https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html>`_ .. epigraph:: Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a ``KmsKeyId`` when using an instance type with local storage. If any of the models that you specify in the ``ProductionVariants`` parameter use nitro-based instances with local storage, do not specify a value for the ``KmsKeyId`` parameter. If you specify a value for ``KmsKeyId`` when using any nitro-based instances with local storage, the call to ``CreateEndpointConfig`` fails. For a list of instance types that support local instance storage, see `Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes>`_ . For more information about local instance storage encryption, see `SSD Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html>`_ .
        :param shadow_production_variants: Array of ``ProductionVariant`` objects. There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ``ProductionVariants`` . If you use this field, you can only specify one variant for ``ProductionVariants`` and one variant for ``ShadowProductionVariants`` .
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            cfn_endpoint_config_props = sagemaker.CfnEndpointConfigProps(
                production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                    initial_variant_weight=123,
                    model_name="modelName",
                    variant_name="variantName",
            
                    # the properties below are optional
                    accelerator_type="acceleratorType",
                    container_startup_health_check_timeout_in_seconds=123,
                    initial_instance_count=123,
                    instance_type="instanceType",
                    model_data_download_timeout_in_seconds=123,
                    serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                        max_concurrency=123,
                        memory_size_in_mb=123
                    ),
                    volume_size_in_gb=123
                )],
            
                # the properties below are optional
                async_inference_config=sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty(
                    output_config=sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty(
                        s3_output_path="s3OutputPath",
            
                        # the properties below are optional
                        kms_key_id="kmsKeyId",
                        notification_config=sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty(
                            error_topic="errorTopic",
                            success_topic="successTopic"
                        )
                    ),
            
                    # the properties below are optional
                    client_config=sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty(
                        max_concurrent_invocations_per_instance=123
                    )
                ),
                data_capture_config=sagemaker.CfnEndpointConfig.DataCaptureConfigProperty(
                    capture_options=[sagemaker.CfnEndpointConfig.CaptureOptionProperty(
                        capture_mode="captureMode"
                    )],
                    destination_s3_uri="destinationS3Uri",
                    initial_sampling_percentage=123,
            
                    # the properties below are optional
                    capture_content_type_header=sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty(
                        csv_content_types=["csvContentTypes"],
                        json_content_types=["jsonContentTypes"]
                    ),
                    enable_capture=False,
                    kms_key_id="kmsKeyId"
                ),
                endpoint_config_name="endpointConfigName",
                explainer_config=sagemaker.CfnEndpointConfig.ExplainerConfigProperty(
                    clarify_explainer_config=sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty(
                        shap_config=sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty(
                            shap_baseline_config=sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty(
                                mime_type="mimeType",
                                shap_baseline="shapBaseline",
                                shap_baseline_uri="shapBaselineUri"
                            ),
            
                            # the properties below are optional
                            number_of_samples=123,
                            seed=123,
                            text_config=sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty(
                                granularity="granularity",
                                language="language"
                            ),
                            use_logit=False
                        ),
            
                        # the properties below are optional
                        enable_explanations="enableExplanations",
                        inference_config=sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty(
                            content_template="contentTemplate",
                            feature_headers=["featureHeaders"],
                            features_attribute="featuresAttribute",
                            feature_types=["featureTypes"],
                            label_attribute="labelAttribute",
                            label_headers=["labelHeaders"],
                            label_index=123,
                            max_payload_in_mb=123,
                            max_record_count=123,
                            probability_attribute="probabilityAttribute",
                            probability_index=123
                        )
                    )
                ),
                kms_key_id="kmsKeyId",
                shadow_production_variants=[sagemaker.CfnEndpointConfig.ProductionVariantProperty(
                    initial_variant_weight=123,
                    model_name="modelName",
                    variant_name="variantName",
            
                    # the properties below are optional
                    accelerator_type="acceleratorType",
                    container_startup_health_check_timeout_in_seconds=123,
                    initial_instance_count=123,
                    instance_type="instanceType",
                    model_data_download_timeout_in_seconds=123,
                    serverless_config=sagemaker.CfnEndpointConfig.ServerlessConfigProperty(
                        max_concurrency=123,
                        memory_size_in_mb=123
                    ),
                    volume_size_in_gb=123
                )],
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0264444c7f05ec057089f4edb4cf8cec2c76349f36714b3cb81b8852892f0384)
            check_type(argname="argument production_variants", value=production_variants, expected_type=type_hints["production_variants"])
            check_type(argname="argument async_inference_config", value=async_inference_config, expected_type=type_hints["async_inference_config"])
            check_type(argname="argument data_capture_config", value=data_capture_config, expected_type=type_hints["data_capture_config"])
            check_type(argname="argument endpoint_config_name", value=endpoint_config_name, expected_type=type_hints["endpoint_config_name"])
            check_type(argname="argument explainer_config", value=explainer_config, expected_type=type_hints["explainer_config"])
            check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            check_type(argname="argument shadow_production_variants", value=shadow_production_variants, expected_type=type_hints["shadow_production_variants"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "production_variants": production_variants,
        }
        if async_inference_config is not None:
            self._values["async_inference_config"] = async_inference_config
        if data_capture_config is not None:
            self._values["data_capture_config"] = data_capture_config
        if endpoint_config_name is not None:
            self._values["endpoint_config_name"] = endpoint_config_name
        if explainer_config is not None:
            self._values["explainer_config"] = explainer_config
        if kms_key_id is not None:
            self._values["kms_key_id"] = kms_key_id
        if shadow_production_variants is not None:
            self._values["shadow_production_variants"] = shadow_production_variants
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def production_variants(
        self,
    ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnEndpointConfig.ProductionVariantProperty, _IResolvable_a771d0ef]]]:
        '''A list of ``ProductionVariant`` objects, one for each model that you want to host at this endpoint.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
        '''
        result = self._values.get("production_variants")
        assert result is not None, "Required property 'production_variants' is missing"
        return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnEndpointConfig.ProductionVariantProperty, _IResolvable_a771d0ef]]], result)

    @builtins.property
    def async_inference_config(
        self,
    ) -> typing.Optional[typing.Union[CfnEndpointConfig.AsyncInferenceConfigProperty, _IResolvable_a771d0ef]]:
        '''Specifies configuration for how an endpoint performs asynchronous inference.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig
        '''
        result = self._values.get("async_inference_config")
        return typing.cast(typing.Optional[typing.Union[CfnEndpointConfig.AsyncInferenceConfigProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def data_capture_config(
        self,
    ) -> typing.Optional[typing.Union[CfnEndpointConfig.DataCaptureConfigProperty, _IResolvable_a771d0ef]]:
        '''Specifies how to capture endpoint data for model monitor.

        The data capture configuration applies to all production variants hosted at the endpoint.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
        '''
        result = self._values.get("data_capture_config")
        return typing.cast(typing.Optional[typing.Union[CfnEndpointConfig.DataCaptureConfigProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def endpoint_config_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint configuration.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
        '''
        result = self._values.get("endpoint_config_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def explainer_config(
        self,
    ) -> typing.Optional[typing.Union[CfnEndpointConfig.ExplainerConfigProperty, _IResolvable_a771d0ef]]:
        '''``AWS::SageMaker::EndpointConfig.ExplainerConfig``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-explainerconfig
        '''
        result = self._values.get("explainer_config")
        return typing.cast(typing.Optional[typing.Union[CfnEndpointConfig.ExplainerConfigProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.

        - Key ID: ``1234abcd-12ab-34cd-56ef-1234567890ab``
        - Key ARN: ``arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab``
        - Alias name: ``alias/ExampleAlias``
        - Alias name ARN: ``arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias``

        The KMS key policy must grant permission to the IAM role that you specify in your ``CreateEndpoint`` , ``UpdateEndpoint`` requests. For more information, refer to the AWS Key Management Service section `Using Key Policies in AWS KMS <https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html>`_
        .. epigraph::

           Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a ``KmsKeyId`` when using an instance type with local storage. If any of the models that you specify in the ``ProductionVariants`` parameter use nitro-based instances with local storage, do not specify a value for the ``KmsKeyId`` parameter. If you specify a value for ``KmsKeyId`` when using any nitro-based instances with local storage, the call to ``CreateEndpointConfig`` fails.

           For a list of instance types that support local instance storage, see `Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes>`_ .

           For more information about local instance storage encryption, see `SSD Instance Store Volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
        '''
        result = self._values.get("kms_key_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def shadow_production_variants(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnEndpointConfig.ProductionVariantProperty, _IResolvable_a771d0ef]]]]:
        '''Array of ``ProductionVariant`` objects.

        There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on ``ProductionVariants`` . If you use this field, you can only specify one variant for ``ProductionVariants`` and one variant for ``ShadowProductionVariants`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-shadowproductionvariants
        '''
        result = self._values.get("shadow_production_variants")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnEndpointConfig.ProductionVariantProperty, _IResolvable_a771d0ef]]]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnEndpointConfigProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnEndpointProps",
    jsii_struct_bases=[],
    name_mapping={
        "endpoint_config_name": "endpointConfigName",
        "deployment_config": "deploymentConfig",
        "endpoint_name": "endpointName",
        "exclude_retained_variant_properties": "excludeRetainedVariantProperties",
        "retain_all_variant_properties": "retainAllVariantProperties",
        "retain_deployment_config": "retainDeploymentConfig",
        "tags": "tags",
    },
)
class CfnEndpointProps:
    def __init__(
        self,
        *,
        endpoint_config_name: builtins.str,
        deployment_config: typing.Optional[typing.Union[typing.Union[CfnEndpoint.DeploymentConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        endpoint_name: typing.Optional[builtins.str] = None,
        exclude_retained_variant_properties: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union[CfnEndpoint.VariantPropertyProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        retain_all_variant_properties: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        retain_deployment_config: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnEndpoint``.

        :param endpoint_config_name: The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .
        :param deployment_config: The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
        :param endpoint_name: The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in ``CreateEndpoint`` , but the case is preserved and must be matched in ` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html>`_ .
        :param exclude_retained_variant_properties: When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .
        :param retain_all_variant_properties: When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set ``RetainAllVariantProperties`` to ``true`` . To use the variant properties specified in a new ``EndpointConfig`` call when updating an endpoint, set ``RetainAllVariantProperties`` to ``false`` . Use this property only when updating endpoint resources, not when creating new endpoint resources.
        :param retain_deployment_config: Specifies whether to reuse the last deployment configuration. The default value is false (the configuration is not reused).
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            cfn_endpoint_props = sagemaker.CfnEndpointProps(
                endpoint_config_name="endpointConfigName",
            
                # the properties below are optional
                deployment_config=sagemaker.CfnEndpoint.DeploymentConfigProperty(
                    blue_green_update_policy=sagemaker.CfnEndpoint.BlueGreenUpdatePolicyProperty(
                        traffic_routing_configuration=sagemaker.CfnEndpoint.TrafficRoutingConfigProperty(
                            type="type",
            
                            # the properties below are optional
                            canary_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            linear_step_size=sagemaker.CfnEndpoint.CapacitySizeProperty(
                                type="type",
                                value=123
                            ),
                            wait_interval_in_seconds=123
                        ),
            
                        # the properties below are optional
                        maximum_execution_timeout_in_seconds=123,
                        termination_wait_in_seconds=123
                    ),
            
                    # the properties below are optional
                    auto_rollback_configuration=sagemaker.CfnEndpoint.AutoRollbackConfigProperty(
                        alarms=[sagemaker.CfnEndpoint.AlarmProperty(
                            alarm_name="alarmName"
                        )]
                    )
                ),
                endpoint_name="endpointName",
                exclude_retained_variant_properties=[sagemaker.CfnEndpoint.VariantPropertyProperty(
                    variant_property_type="variantPropertyType"
                )],
                retain_all_variant_properties=False,
                retain_deployment_config=False,
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fe61c284150334b221d1ee9a1ab2c9e5d939ec8633e7bb70ecbac2b293635e43)
            check_type(argname="argument endpoint_config_name", value=endpoint_config_name, expected_type=type_hints["endpoint_config_name"])
            check_type(argname="argument deployment_config", value=deployment_config, expected_type=type_hints["deployment_config"])
            check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
            check_type(argname="argument exclude_retained_variant_properties", value=exclude_retained_variant_properties, expected_type=type_hints["exclude_retained_variant_properties"])
            check_type(argname="argument retain_all_variant_properties", value=retain_all_variant_properties, expected_type=type_hints["retain_all_variant_properties"])
            check_type(argname="argument retain_deployment_config", value=retain_deployment_config, expected_type=type_hints["retain_deployment_config"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoint_config_name": endpoint_config_name,
        }
        if deployment_config is not None:
            self._values["deployment_config"] = deployment_config
        if endpoint_name is not None:
            self._values["endpoint_name"] = endpoint_name
        if exclude_retained_variant_properties is not None:
            self._values["exclude_retained_variant_properties"] = exclude_retained_variant_properties
        if retain_all_variant_properties is not None:
            self._values["retain_all_variant_properties"] = retain_all_variant_properties
        if retain_deployment_config is not None:
            self._values["retain_deployment_config"] = retain_deployment_config
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def endpoint_config_name(self) -> builtins.str:
        '''The name of the `AWS::SageMaker::EndpointConfig <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html>`_ resource that specifies the configuration for the endpoint. For more information, see `CreateEndpointConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
        '''
        result = self._values.get("endpoint_config_name")
        assert result is not None, "Required property 'endpoint_config_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def deployment_config(
        self,
    ) -> typing.Optional[typing.Union[CfnEndpoint.DeploymentConfigProperty, _IResolvable_a771d0ef]]:
        '''The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig
        '''
        result = self._values.get("deployment_config")
        return typing.cast(typing.Optional[typing.Union[CfnEndpoint.DeploymentConfigProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''The name of the endpoint.The name must be unique within an AWS Region in your AWS account. The name is case-insensitive in ``CreateEndpoint`` , but the case is preserved and must be matched in ` <https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
        '''
        result = self._values.get("endpoint_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def exclude_retained_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnEndpoint.VariantPropertyProperty, _IResolvable_a771d0ef]]]]:
        '''When you are updating endpoint resources with `RetainAllVariantProperties <https://docs.aws.amazon.com/sagemaker/latest/dg/API_UpdateEndpoint.html#SageMaker-UpdateEndpoint-request-RetainAllVariantProperties>`_ whose value is set to ``true`` , ``ExcludeRetainedVariantProperties`` specifies the list of type `VariantProperty <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html>`_ to override with the values provided by ``EndpointConfig`` . If you don't specify a value for ``ExcludeAllVariantProperties`` , no variant properties are overridden. Don't use this property when creating new endpoint resources or when ``RetainAllVariantProperties`` is set to ``false`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
        '''
        result = self._values.get("exclude_retained_variant_properties")
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnEndpoint.VariantPropertyProperty, _IResolvable_a771d0ef]]]], result)

    @builtins.property
    def retain_all_variant_properties(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        '''When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight.

        To retain the variant properties of an endpoint when updating it, set ``RetainAllVariantProperties`` to ``true`` . To use the variant properties specified in a new ``EndpointConfig`` call when updating an endpoint, set ``RetainAllVariantProperties`` to ``false`` . Use this property only when updating endpoint resources, not when creating new endpoint resources.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
        '''
        result = self._values.get("retain_all_variant_properties")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

    @builtins.property
    def retain_deployment_config(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        '''Specifies whether to reuse the last deployment configuration.

        The default value is false (the configuration is not reused).

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retaindeploymentconfig
        '''
        result = self._values.get("retain_deployment_config")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnEndpointProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnFeatureGroup(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnFeatureGroup",
):
    '''A CloudFormation ``AWS::SageMaker::FeatureGroup``.

    Create a new ``FeatureGroup`` . A ``FeatureGroup`` is a group of ``Features`` defined in the ``FeatureStore`` to describe a ``Record`` .

    The ``FeatureGroup`` defines the schema and features contained in the FeatureGroup. A ``FeatureGroup`` definition is composed of a list of ``Features`` , a ``RecordIdentifierFeatureName`` , an ``EventTimeFeatureName`` and configurations for its ``OnlineStore`` and ``OfflineStore`` . Check `AWS service quotas <https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html>`_ to see the ``FeatureGroup`` s quota for your AWS account.
    .. epigraph::

       You must include at least one of ``OnlineStoreConfig`` and ``OfflineStoreConfig`` to create a ``FeatureGroup`` .

    :cloudformationResource: AWS::SageMaker::FeatureGroup
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        # offline_store_config: Any
        # online_store_config: Any
        
        cfn_feature_group = sagemaker.CfnFeatureGroup(self, "MyCfnFeatureGroup",
            event_time_feature_name="eventTimeFeatureName",
            feature_definitions=[sagemaker.CfnFeatureGroup.FeatureDefinitionProperty(
                feature_name="featureName",
                feature_type="featureType"
            )],
            feature_group_name="featureGroupName",
            record_identifier_feature_name="recordIdentifierFeatureName",
        
            # the properties below are optional
            description="description",
            offline_store_config=offline_store_config,
            online_store_config=online_store_config,
            role_arn="roleArn",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        event_time_feature_name: builtins.str,
        feature_definitions: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnFeatureGroup.FeatureDefinitionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        feature_group_name: builtins.str,
        record_identifier_feature_name: builtins.str,
        description: typing.Optional[builtins.str] = None,
        offline_store_config: typing.Any = None,
        online_store_config: typing.Any = None,
        role_arn: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::FeatureGroup``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param event_time_feature_name: The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` . A ``EventTime`` is point in time when a new event occurs that corresponds to the creation or update of a ``Record`` in ``FeatureGroup`` . All ``Records`` in the ``FeatureGroup`` must have a corresponding ``EventTime`` .
        :param feature_definitions: A list of ``Feature`` s. Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` . Valid ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` . ``FeatureName`` s cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` . You can create up to 2,500 ``FeatureDefinition`` s per ``FeatureGroup`` .
        :param feature_group_name: The name of the ``FeatureGroup`` .
        :param record_identifier_feature_name: The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .
        :param description: A free form description of a ``FeatureGroup`` .
        :param offline_store_config: The configuration of an ``OfflineStore`` .
        :param online_store_config: The configuration of an ``OnlineStore`` .
        :param role_arn: The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
        :param tags: Tags used to define a ``FeatureGroup`` .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1539af6dee6a8f8ca3acbba505e6cacf4aa54420980ada114b59ac5fcd4826a5)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnFeatureGroupProps(
            event_time_feature_name=event_time_feature_name,
            feature_definitions=feature_definitions,
            feature_group_name=feature_group_name,
            record_identifier_feature_name=record_identifier_feature_name,
            description=description,
            offline_store_config=offline_store_config,
            online_store_config=online_store_config,
            role_arn=role_arn,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a43290e025522269f09b05debabbc2b31e61491c0f311df2e5dc9f97bc6422f3)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47ab5835353101f1d7076b132aa14956ba43d3d039504a2d55bf250e4d28b745)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''Tags used to define a ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="eventTimeFeatureName")
    def event_time_feature_name(self) -> builtins.str:
        '''The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` .

        A ``EventTime`` is point in time when a new event occurs that corresponds to the creation or update of a ``Record`` in ``FeatureGroup`` . All ``Records`` in the ``FeatureGroup`` must have a corresponding ``EventTime`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-eventtimefeaturename
        '''
        return typing.cast(builtins.str, jsii.get(self, "eventTimeFeatureName"))

    @event_time_feature_name.setter
    def event_time_feature_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cb0f376a548eda7b79c9da04f216fb261106748e6d172bbf3a125628a11a14e4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "eventTimeFeatureName", value)

    @builtins.property
    @jsii.member(jsii_name="featureDefinitions")
    def feature_definitions(
        self,
    ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnFeatureGroup.FeatureDefinitionProperty", _IResolvable_a771d0ef]]]:
        '''A list of ``Feature`` s. Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` .

        Valid ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` .

        ``FeatureName`` s cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` .

        You can create up to 2,500 ``FeatureDefinition`` s per ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions
        '''
        return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnFeatureGroup.FeatureDefinitionProperty", _IResolvable_a771d0ef]]], jsii.get(self, "featureDefinitions"))

    @feature_definitions.setter
    def feature_definitions(
        self,
        value: typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnFeatureGroup.FeatureDefinitionProperty", _IResolvable_a771d0ef]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1a72ec85eec04a1a539e850f85fb70200d378435fb229330a3e8e40b726e6ed5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "featureDefinitions", value)

    @builtins.property
    @jsii.member(jsii_name="featureGroupName")
    def feature_group_name(self) -> builtins.str:
        '''The name of the ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuregroupname
        '''
        return typing.cast(builtins.str, jsii.get(self, "featureGroupName"))

    @feature_group_name.setter
    def feature_group_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2001d26e2aac6ed5b0ee07a8121527bae7db2dd83228a725c35acbe5d65b60b2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "featureGroupName", value)

    @builtins.property
    @jsii.member(jsii_name="offlineStoreConfig")
    def offline_store_config(self) -> typing.Any:
        '''The configuration of an ``OfflineStore`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-offlinestoreconfig
        '''
        return typing.cast(typing.Any, jsii.get(self, "offlineStoreConfig"))

    @offline_store_config.setter
    def offline_store_config(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0d9761acd50f8c3a48a2b8809e1de8b3e4548fc5f257b207e09a5517239a7031)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "offlineStoreConfig", value)

    @builtins.property
    @jsii.member(jsii_name="onlineStoreConfig")
    def online_store_config(self) -> typing.Any:
        '''The configuration of an ``OnlineStore`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-onlinestoreconfig
        '''
        return typing.cast(typing.Any, jsii.get(self, "onlineStoreConfig"))

    @online_store_config.setter
    def online_store_config(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cbfce1a942e3f3896f26304d25113de69c7638f22797e2859fe899954458cd57)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "onlineStoreConfig", value)

    @builtins.property
    @jsii.member(jsii_name="recordIdentifierFeatureName")
    def record_identifier_feature_name(self) -> builtins.str:
        '''The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-recordidentifierfeaturename
        '''
        return typing.cast(builtins.str, jsii.get(self, "recordIdentifierFeatureName"))

    @record_identifier_feature_name.setter
    def record_identifier_feature_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ff3a413d5343065ecb3d12b58371a0aeebb01a2ab82c9a69e7fc744aed5b9ce5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "recordIdentifierFeatureName", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''A free form description of a ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-description
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aa70d777611e3fe3508fd9a0ec3c5c70c882cd978bdf2d17501289d5b536802b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-rolearn
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc402576b9ce8fa789521bdb9c1784b8bf9114588f502f4391d6dd5bf75f0e47)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnFeatureGroup.DataCatalogConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "catalog": "catalog",
            "database": "database",
            "table_name": "tableName",
        },
    )
    class DataCatalogConfigProperty:
        def __init__(
            self,
            *,
            catalog: builtins.str,
            database: builtins.str,
            table_name: builtins.str,
        ) -> None:
            '''The meta data of the Glue table which serves as data catalog for the ``OfflineStore`` .

            :param catalog: The name of the Glue table catalog.
            :param database: The name of the Glue table database.
            :param table_name: The name of the Glue table.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                data_catalog_config_property = sagemaker.CfnFeatureGroup.DataCatalogConfigProperty(
                    catalog="catalog",
                    database="database",
                    table_name="tableName"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__e61230ea9941d94239d732342a4a39f4ec558da7f650cff34f183f148f14656f)
                check_type(argname="argument catalog", value=catalog, expected_type=type_hints["catalog"])
                check_type(argname="argument database", value=database, expected_type=type_hints["database"])
                check_type(argname="argument table_name", value=table_name, expected_type=type_hints["table_name"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "catalog": catalog,
                "database": database,
                "table_name": table_name,
            }

        @builtins.property
        def catalog(self) -> builtins.str:
            '''The name of the Glue table catalog.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-catalog
            '''
            result = self._values.get("catalog")
            assert result is not None, "Required property 'catalog' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def database(self) -> builtins.str:
            '''The name of the Glue table database.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-database
            '''
            result = self._values.get("database")
            assert result is not None, "Required property 'database' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def table_name(self) -> builtins.str:
            '''The name of the Glue table.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-tablename
            '''
            result = self._values.get("table_name")
            assert result is not None, "Required property 'table_name' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DataCatalogConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnFeatureGroup.FeatureDefinitionProperty",
        jsii_struct_bases=[],
        name_mapping={"feature_name": "featureName", "feature_type": "featureType"},
    )
    class FeatureDefinitionProperty:
        def __init__(
            self,
            *,
            feature_name: builtins.str,
            feature_type: builtins.str,
        ) -> None:
            '''A list of features.

            You must include ``FeatureName`` and ``FeatureType`` . Valid feature ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` .

            :param feature_name: The name of a feature. The type must be a string. ``FeatureName`` cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` .
            :param feature_type: The value type of a feature. Valid values are Integral, Fractional, or String.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                feature_definition_property = sagemaker.CfnFeatureGroup.FeatureDefinitionProperty(
                    feature_name="featureName",
                    feature_type="featureType"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__121ad11c7787478a42be0e8ab6963acdb3b20af4c101b28b06b2b23ed10ecb99)
                check_type(argname="argument feature_name", value=feature_name, expected_type=type_hints["feature_name"])
                check_type(argname="argument feature_type", value=feature_type, expected_type=type_hints["feature_type"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "feature_name": feature_name,
                "feature_type": feature_type,
            }

        @builtins.property
        def feature_name(self) -> builtins.str:
            '''The name of a feature.

            The type must be a string. ``FeatureName`` cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featurename
            '''
            result = self._values.get("feature_name")
            assert result is not None, "Required property 'feature_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def feature_type(self) -> builtins.str:
            '''The value type of a feature.

            Valid values are Integral, Fractional, or String.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featuretype
            '''
            result = self._values.get("feature_type")
            assert result is not None, "Required property 'feature_type' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FeatureDefinitionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnFeatureGroup.OfflineStoreConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "s3_storage_config": "s3StorageConfig",
            "data_catalog_config": "dataCatalogConfig",
            "disable_glue_table_creation": "disableGlueTableCreation",
            "table_format": "tableFormat",
        },
    )
    class OfflineStoreConfigProperty:
        def __init__(
            self,
            *,
            s3_storage_config: typing.Union[typing.Union["CfnFeatureGroup.S3StorageConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            data_catalog_config: typing.Optional[typing.Union[typing.Union["CfnFeatureGroup.DataCatalogConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            disable_glue_table_creation: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            table_format: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration of an ``OfflineStore`` .

            Provide an ``OfflineStoreConfig`` in a request to ``CreateFeatureGroup`` to create an ``OfflineStore`` .

            To encrypt an ``OfflineStore`` using at rest data encryption, specify AWS Key Management Service (KMS) key ID, or ``KMSKeyId`` , in ``S3StorageConfig`` .

            :param s3_storage_config: The Amazon Simple Storage (Amazon S3) location of ``OfflineStore`` .
            :param data_catalog_config: The meta data of the Glue table that is autogenerated when an ``OfflineStore`` is created.
            :param disable_glue_table_creation: Set to ``True`` to disable the automatic creation of an AWS Glue table when configuring an ``OfflineStore`` .
            :param table_format: Format for the offline store table. Supported formats are Glue (Default) and `Apache Iceberg <https://docs.aws.amazon.com/https://iceberg.apache.org/>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                offline_store_config_property = sagemaker.CfnFeatureGroup.OfflineStoreConfigProperty(
                    s3_storage_config=sagemaker.CfnFeatureGroup.S3StorageConfigProperty(
                        s3_uri="s3Uri",
                
                        # the properties below are optional
                        kms_key_id="kmsKeyId"
                    ),
                
                    # the properties below are optional
                    data_catalog_config=sagemaker.CfnFeatureGroup.DataCatalogConfigProperty(
                        catalog="catalog",
                        database="database",
                        table_name="tableName"
                    ),
                    disable_glue_table_creation=False,
                    table_format="tableFormat"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__b80bbed85685bb0e1c6b08295a320d084f0decc4481f9a0116d071136643188a)
                check_type(argname="argument s3_storage_config", value=s3_storage_config, expected_type=type_hints["s3_storage_config"])
                check_type(argname="argument data_catalog_config", value=data_catalog_config, expected_type=type_hints["data_catalog_config"])
                check_type(argname="argument disable_glue_table_creation", value=disable_glue_table_creation, expected_type=type_hints["disable_glue_table_creation"])
                check_type(argname="argument table_format", value=table_format, expected_type=type_hints["table_format"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_storage_config": s3_storage_config,
            }
            if data_catalog_config is not None:
                self._values["data_catalog_config"] = data_catalog_config
            if disable_glue_table_creation is not None:
                self._values["disable_glue_table_creation"] = disable_glue_table_creation
            if table_format is not None:
                self._values["table_format"] = table_format

        @builtins.property
        def s3_storage_config(
            self,
        ) -> typing.Union["CfnFeatureGroup.S3StorageConfigProperty", _IResolvable_a771d0ef]:
            '''The Amazon Simple Storage (Amazon S3) location of ``OfflineStore`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-s3storageconfig
            '''
            result = self._values.get("s3_storage_config")
            assert result is not None, "Required property 's3_storage_config' is missing"
            return typing.cast(typing.Union["CfnFeatureGroup.S3StorageConfigProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def data_catalog_config(
            self,
        ) -> typing.Optional[typing.Union["CfnFeatureGroup.DataCatalogConfigProperty", _IResolvable_a771d0ef]]:
            '''The meta data of the Glue table that is autogenerated when an ``OfflineStore`` is created.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-datacatalogconfig
            '''
            result = self._values.get("data_catalog_config")
            return typing.cast(typing.Optional[typing.Union["CfnFeatureGroup.DataCatalogConfigProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def disable_glue_table_creation(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''Set to ``True`` to disable the automatic creation of an AWS Glue table when configuring an ``OfflineStore`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-disablegluetablecreation
            '''
            result = self._values.get("disable_glue_table_creation")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        @builtins.property
        def table_format(self) -> typing.Optional[builtins.str]:
            '''Format for the offline store table.

            Supported formats are Glue (Default) and `Apache Iceberg <https://docs.aws.amazon.com/https://iceberg.apache.org/>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-tableformat
            '''
            result = self._values.get("table_format")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OfflineStoreConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnFeatureGroup.OnlineStoreConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_online_store": "enableOnlineStore",
            "security_config": "securityConfig",
        },
    )
    class OnlineStoreConfigProperty:
        def __init__(
            self,
            *,
            enable_online_store: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            security_config: typing.Optional[typing.Union[typing.Union["CfnFeatureGroup.OnlineStoreSecurityConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Use this to specify the AWS Key Management Service (KMS) Key ID, or ``KMSKeyId`` , for at rest data encryption.

            You can turn ``OnlineStore`` on or off by specifying the ``EnableOnlineStore`` flag at General Assembly; the default value is ``False`` .

            :param enable_online_store: Turn ``OnlineStore`` off by specifying ``False`` for the ``EnableOnlineStore`` flag. Turn ``OnlineStore`` on by specifying ``True`` for the ``EnableOnlineStore`` flag. The default value is ``False`` .
            :param security_config: Use to specify KMS Key ID ( ``KMSKeyId`` ) for at-rest encryption of your ``OnlineStore`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                online_store_config_property = sagemaker.CfnFeatureGroup.OnlineStoreConfigProperty(
                    enable_online_store=False,
                    security_config=sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty(
                        kms_key_id="kmsKeyId"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__21d1ccebdf6deb10803b6d765f3fbe77b32d2f6c45994a6497edb9e499648bd6)
                check_type(argname="argument enable_online_store", value=enable_online_store, expected_type=type_hints["enable_online_store"])
                check_type(argname="argument security_config", value=security_config, expected_type=type_hints["security_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if enable_online_store is not None:
                self._values["enable_online_store"] = enable_online_store
            if security_config is not None:
                self._values["security_config"] = security_config

        @builtins.property
        def enable_online_store(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''Turn ``OnlineStore`` off by specifying ``False`` for the ``EnableOnlineStore`` flag.

            Turn ``OnlineStore`` on by specifying ``True`` for the ``EnableOnlineStore`` flag.

            The default value is ``False`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-enableonlinestore
            '''
            result = self._values.get("enable_online_store")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        @builtins.property
        def security_config(
            self,
        ) -> typing.Optional[typing.Union["CfnFeatureGroup.OnlineStoreSecurityConfigProperty", _IResolvable_a771d0ef]]:
            '''Use to specify KMS Key ID ( ``KMSKeyId`` ) for at-rest encryption of your ``OnlineStore`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-securityconfig
            '''
            result = self._values.get("security_config")
            return typing.cast(typing.Optional[typing.Union["CfnFeatureGroup.OnlineStoreSecurityConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OnlineStoreConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"kms_key_id": "kmsKeyId"},
    )
    class OnlineStoreSecurityConfigProperty:
        def __init__(self, *, kms_key_id: typing.Optional[builtins.str] = None) -> None:
            '''The security configuration for ``OnlineStore`` .

            :param kms_key_id: The ID of the AWS Key Management Service ( AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption. The caller (either IAM user or IAM role) of ``CreateFeatureGroup`` must have below permissions to the ``OnlineStore`` ``KmsKeyId`` : - ``"kms:Encrypt"`` - ``"kms:Decrypt"`` - ``"kms:DescribeKey"`` - ``"kms:CreateGrant"`` - ``"kms:RetireGrant"`` - ``"kms:ReEncryptFrom"`` - ``"kms:ReEncryptTo"`` - ``"kms:GenerateDataKey"`` - ``"kms:ListAliases"`` - ``"kms:ListGrants"`` - ``"kms:RevokeGrant"`` The caller (either IAM user or IAM role) to all DataPlane operations ( ``PutRecord`` , ``GetRecord`` , ``DeleteRecord`` ) must have the following permissions to the ``KmsKeyId`` : - ``"kms:Decrypt"``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoresecurityconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                online_store_security_config_property = sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty(
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__3186235b478ccf5e965841ae6abbbf0e0dff5f2f1373cb76e9a02c4e2f01be1d)
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The ID of the AWS Key Management Service ( AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.

            The caller (either IAM user or IAM role) of ``CreateFeatureGroup`` must have below permissions to the ``OnlineStore`` ``KmsKeyId`` :

            - ``"kms:Encrypt"``
            - ``"kms:Decrypt"``
            - ``"kms:DescribeKey"``
            - ``"kms:CreateGrant"``
            - ``"kms:RetireGrant"``
            - ``"kms:ReEncryptFrom"``
            - ``"kms:ReEncryptTo"``
            - ``"kms:GenerateDataKey"``
            - ``"kms:ListAliases"``
            - ``"kms:ListGrants"``
            - ``"kms:RevokeGrant"``

            The caller (either IAM user or IAM role) to all DataPlane operations ( ``PutRecord`` , ``GetRecord`` , ``DeleteRecord`` ) must have the following permissions to the ``KmsKeyId`` :

            - ``"kms:Decrypt"``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoresecurityconfig.html#cfn-sagemaker-featuregroup-onlinestoresecurityconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OnlineStoreSecurityConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnFeatureGroup.S3StorageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri", "kms_key_id": "kmsKeyId"},
    )
    class S3StorageConfigProperty:
        def __init__(
            self,
            *,
            s3_uri: builtins.str,
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon Simple Storage (Amazon S3) location and and security configuration for ``OfflineStore`` .

            :param s3_uri: The S3 URI, or location in Amazon S3, of ``OfflineStore`` . S3 URIs have a format similar to the following: ``s3://example-bucket/prefix/`` .
            :param kms_key_id: The AWS Key Management Service (KMS) key ID of the key used to encrypt any objects written into the ``OfflineStore`` S3 location. The IAM ``roleARN`` that is passed as a parameter to ``CreateFeatureGroup`` must have below permissions to the ``KmsKeyId`` : - ``"kms:GenerateDataKey"``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                s3_storage_config_property = sagemaker.CfnFeatureGroup.S3StorageConfigProperty(
                    s3_uri="s3Uri",
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a833215420cea012de6d8d531d2d786cdcc5a64d38450a17c3d60fa7c7fcadb4)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_uri": s3_uri,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def s3_uri(self) -> builtins.str:
            '''The S3 URI, or location in Amazon S3, of ``OfflineStore`` .

            S3 URIs have a format similar to the following: ``s3://example-bucket/prefix/`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html#cfn-sagemaker-featuregroup-s3storageconfig-s3uri
            '''
            result = self._values.get("s3_uri")
            assert result is not None, "Required property 's3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service (KMS) key ID of the key used to encrypt any objects written into the ``OfflineStore`` S3 location.

            The IAM ``roleARN`` that is passed as a parameter to ``CreateFeatureGroup`` must have below permissions to the ``KmsKeyId`` :

            - ``"kms:GenerateDataKey"``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html#cfn-sagemaker-featuregroup-s3storageconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "S3StorageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnFeatureGroupProps",
    jsii_struct_bases=[],
    name_mapping={
        "event_time_feature_name": "eventTimeFeatureName",
        "feature_definitions": "featureDefinitions",
        "feature_group_name": "featureGroupName",
        "record_identifier_feature_name": "recordIdentifierFeatureName",
        "description": "description",
        "offline_store_config": "offlineStoreConfig",
        "online_store_config": "onlineStoreConfig",
        "role_arn": "roleArn",
        "tags": "tags",
    },
)
class CfnFeatureGroupProps:
    def __init__(
        self,
        *,
        event_time_feature_name: builtins.str,
        feature_definitions: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union[CfnFeatureGroup.FeatureDefinitionProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
        feature_group_name: builtins.str,
        record_identifier_feature_name: builtins.str,
        description: typing.Optional[builtins.str] = None,
        offline_store_config: typing.Any = None,
        online_store_config: typing.Any = None,
        role_arn: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnFeatureGroup``.

        :param event_time_feature_name: The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` . A ``EventTime`` is point in time when a new event occurs that corresponds to the creation or update of a ``Record`` in ``FeatureGroup`` . All ``Records`` in the ``FeatureGroup`` must have a corresponding ``EventTime`` .
        :param feature_definitions: A list of ``Feature`` s. Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` . Valid ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` . ``FeatureName`` s cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` . You can create up to 2,500 ``FeatureDefinition`` s per ``FeatureGroup`` .
        :param feature_group_name: The name of the ``FeatureGroup`` .
        :param record_identifier_feature_name: The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .
        :param description: A free form description of a ``FeatureGroup`` .
        :param offline_store_config: The configuration of an ``OfflineStore`` .
        :param online_store_config: The configuration of an ``OnlineStore`` .
        :param role_arn: The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
        :param tags: Tags used to define a ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            # offline_store_config: Any
            # online_store_config: Any
            
            cfn_feature_group_props = sagemaker.CfnFeatureGroupProps(
                event_time_feature_name="eventTimeFeatureName",
                feature_definitions=[sagemaker.CfnFeatureGroup.FeatureDefinitionProperty(
                    feature_name="featureName",
                    feature_type="featureType"
                )],
                feature_group_name="featureGroupName",
                record_identifier_feature_name="recordIdentifierFeatureName",
            
                # the properties below are optional
                description="description",
                offline_store_config=offline_store_config,
                online_store_config=online_store_config,
                role_arn="roleArn",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__13c57900f5ef4ff2456e60f7d5814cc9d1df1d1e41b78ddb76d60519f929af8f)
            check_type(argname="argument event_time_feature_name", value=event_time_feature_name, expected_type=type_hints["event_time_feature_name"])
            check_type(argname="argument feature_definitions", value=feature_definitions, expected_type=type_hints["feature_definitions"])
            check_type(argname="argument feature_group_name", value=feature_group_name, expected_type=type_hints["feature_group_name"])
            check_type(argname="argument record_identifier_feature_name", value=record_identifier_feature_name, expected_type=type_hints["record_identifier_feature_name"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument offline_store_config", value=offline_store_config, expected_type=type_hints["offline_store_config"])
            check_type(argname="argument online_store_config", value=online_store_config, expected_type=type_hints["online_store_config"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "event_time_feature_name": event_time_feature_name,
            "feature_definitions": feature_definitions,
            "feature_group_name": feature_group_name,
            "record_identifier_feature_name": record_identifier_feature_name,
        }
        if description is not None:
            self._values["description"] = description
        if offline_store_config is not None:
            self._values["offline_store_config"] = offline_store_config
        if online_store_config is not None:
            self._values["online_store_config"] = online_store_config
        if role_arn is not None:
            self._values["role_arn"] = role_arn
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def event_time_feature_name(self) -> builtins.str:
        '''The name of the feature that stores the ``EventTime`` of a Record in a ``FeatureGroup`` .

        A ``EventTime`` is point in time when a new event occurs that corresponds to the creation or update of a ``Record`` in ``FeatureGroup`` . All ``Records`` in the ``FeatureGroup`` must have a corresponding ``EventTime`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-eventtimefeaturename
        '''
        result = self._values.get("event_time_feature_name")
        assert result is not None, "Required property 'event_time_feature_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def feature_definitions(
        self,
    ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnFeatureGroup.FeatureDefinitionProperty, _IResolvable_a771d0ef]]]:
        '''A list of ``Feature`` s. Each ``Feature`` must include a ``FeatureName`` and a ``FeatureType`` .

        Valid ``FeatureType`` s are ``Integral`` , ``Fractional`` and ``String`` .

        ``FeatureName`` s cannot be any of the following: ``is_deleted`` , ``write_time`` , ``api_invocation_time`` .

        You can create up to 2,500 ``FeatureDefinition`` s per ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions
        '''
        result = self._values.get("feature_definitions")
        assert result is not None, "Required property 'feature_definitions' is missing"
        return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union[CfnFeatureGroup.FeatureDefinitionProperty, _IResolvable_a771d0ef]]], result)

    @builtins.property
    def feature_group_name(self) -> builtins.str:
        '''The name of the ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuregroupname
        '''
        result = self._values.get("feature_group_name")
        assert result is not None, "Required property 'feature_group_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def record_identifier_feature_name(self) -> builtins.str:
        '''The name of the ``Feature`` whose value uniquely identifies a ``Record`` defined in the ``FeatureGroup`` ``FeatureDefinitions`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-recordidentifierfeaturename
        '''
        result = self._values.get("record_identifier_feature_name")
        assert result is not None, "Required property 'record_identifier_feature_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''A free form description of a ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-description
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def offline_store_config(self) -> typing.Any:
        '''The configuration of an ``OfflineStore`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-offlinestoreconfig
        '''
        result = self._values.get("offline_store_config")
        return typing.cast(typing.Any, result)

    @builtins.property
    def online_store_config(self) -> typing.Any:
        '''The configuration of an ``OnlineStore`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-onlinestoreconfig
        '''
        result = self._values.get("online_store_config")
        return typing.cast(typing.Any, result)

    @builtins.property
    def role_arn(self) -> typing.Optional[builtins.str]:
        '''The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-rolearn
        '''
        result = self._values.get("role_arn")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''Tags used to define a ``FeatureGroup`` .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnFeatureGroupProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnImage(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnImage",
):
    '''A CloudFormation ``AWS::SageMaker::Image``.

    Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a container image stored in Amazon Elastic Container Registry (ECR). For more information, see `Bring your own SageMaker image <https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html>`_ .

    :cloudformationResource: AWS::SageMaker::Image
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        cfn_image = sagemaker.CfnImage(self, "MyCfnImage",
            image_name="imageName",
            image_role_arn="imageRoleArn",
        
            # the properties below are optional
            image_description="imageDescription",
            image_display_name="imageDisplayName",
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        image_name: builtins.str,
        image_role_arn: builtins.str,
        image_description: typing.Optional[builtins.str] = None,
        image_display_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::Image``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param image_name: The name of the Image. Must be unique by region in your account. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``
        :param image_role_arn: The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. *Length Constraints* : Minimum length of 20. Maximum length of 2048. *Pattern* : ``^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$``
        :param image_description: The description of the image. *Length Constraints* : Minimum length of 1. Maximum length of 512. *Pattern* : ``.*``
        :param image_display_name: The display name of the image. *Length Constraints* : Minimum length of 1. Maximum length of 128. *Pattern* : ``^\\S(.*\\S)?$``
        :param tags: A list of key-value pairs to apply to this resource. *Array Members* : Minimum number of 0 items. Maximum number of 50 items.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__21c4efe1c9ed2cf09e2e6ce61906112b83a13a9d97e566cabb4ab1eb15127b38)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnImageProps(
            image_name=image_name,
            image_role_arn=image_role_arn,
            image_description=image_description,
            image_display_name=image_display_name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c17938cbadb35ee0dedb439e3681f4fc945bba52545607ba07886ff208eb7e7d)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5fd54c071e7cfcae0218be35ec44e6676a82cd98da5a04d44efb5c4bfe4fc69f)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrImageArn")
    def attr_image_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the image.

        *Type* : String

        *Length Constraints* : Maximum length of 256.

        *Pattern* : ``^arn:aws(-[\\w]+)*:sagemaker:.+:[0-9]{12}:image/[a-z0-9]([-.]?[a-z0-9])*$``

        :cloudformationAttribute: ImageArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrImageArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''A list of key-value pairs to apply to this resource.

        *Array Members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="imageName")
    def image_name(self) -> builtins.str:
        '''The name of the Image. Must be unique by region in your account.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagename
        '''
        return typing.cast(builtins.str, jsii.get(self, "imageName"))

    @image_name.setter
    def image_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b967aa8fe761100c393b191bb4277c98a1a41f79cc819a8d2750247a8eaf84b4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageName", value)

    @builtins.property
    @jsii.member(jsii_name="imageRoleArn")
    def image_role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.

        *Length Constraints* : Minimum length of 20. Maximum length of 2048.

        *Pattern* : ``^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagerolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "imageRoleArn"))

    @image_role_arn.setter
    def image_role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d4f4e3e6cfe5202a3aff8f5d91e9dbb620b10a5678bcf55f7ce2839ea341f694)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageRoleArn", value)

    @builtins.property
    @jsii.member(jsii_name="imageDescription")
    def image_description(self) -> typing.Optional[builtins.str]:
        '''The description of the image.

        *Length Constraints* : Minimum length of 1. Maximum length of 512.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedescription
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "imageDescription"))

    @image_description.setter
    def image_description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f132ebf5a2b1ab856897da5e9cbb7c54b510013ad63b7f15d3e5db788b581ac)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageDescription", value)

    @builtins.property
    @jsii.member(jsii_name="imageDisplayName")
    def image_display_name(self) -> typing.Optional[builtins.str]:
        '''The display name of the image.

        *Length Constraints* : Minimum length of 1. Maximum length of 128.

        *Pattern* : ``^\\S(.*\\S)?$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedisplayname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "imageDisplayName"))

    @image_display_name.setter
    def image_display_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__234e86cc0a5c0dea3ec9e8ee3ce25fc606d12c3aedf40423cb899fd552f84392)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageDisplayName", value)


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnImageProps",
    jsii_struct_bases=[],
    name_mapping={
        "image_name": "imageName",
        "image_role_arn": "imageRoleArn",
        "image_description": "imageDescription",
        "image_display_name": "imageDisplayName",
        "tags": "tags",
    },
)
class CfnImageProps:
    def __init__(
        self,
        *,
        image_name: builtins.str,
        image_role_arn: builtins.str,
        image_description: typing.Optional[builtins.str] = None,
        image_display_name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnImage``.

        :param image_name: The name of the Image. Must be unique by region in your account. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``
        :param image_role_arn: The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. *Length Constraints* : Minimum length of 20. Maximum length of 2048. *Pattern* : ``^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$``
        :param image_description: The description of the image. *Length Constraints* : Minimum length of 1. Maximum length of 512. *Pattern* : ``.*``
        :param image_display_name: The display name of the image. *Length Constraints* : Minimum length of 1. Maximum length of 128. *Pattern* : ``^\\S(.*\\S)?$``
        :param tags: A list of key-value pairs to apply to this resource. *Array Members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            cfn_image_props = sagemaker.CfnImageProps(
                image_name="imageName",
                image_role_arn="imageRoleArn",
            
                # the properties below are optional
                image_description="imageDescription",
                image_display_name="imageDisplayName",
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__79c0aea06b8ed8696195aa44932d5ee174124eef57a616c4a29429201a3673c4)
            check_type(argname="argument image_name", value=image_name, expected_type=type_hints["image_name"])
            check_type(argname="argument image_role_arn", value=image_role_arn, expected_type=type_hints["image_role_arn"])
            check_type(argname="argument image_description", value=image_description, expected_type=type_hints["image_description"])
            check_type(argname="argument image_display_name", value=image_display_name, expected_type=type_hints["image_display_name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "image_name": image_name,
            "image_role_arn": image_role_arn,
        }
        if image_description is not None:
            self._values["image_description"] = image_description
        if image_display_name is not None:
            self._values["image_display_name"] = image_display_name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def image_name(self) -> builtins.str:
        '''The name of the Image. Must be unique by region in your account.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagename
        '''
        result = self._values.get("image_name")
        assert result is not None, "Required property 'image_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def image_role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.

        *Length Constraints* : Minimum length of 20. Maximum length of 2048.

        *Pattern* : ``^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagerolearn
        '''
        result = self._values.get("image_role_arn")
        assert result is not None, "Required property 'image_role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def image_description(self) -> typing.Optional[builtins.str]:
        '''The description of the image.

        *Length Constraints* : Minimum length of 1. Maximum length of 512.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedescription
        '''
        result = self._values.get("image_description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def image_display_name(self) -> typing.Optional[builtins.str]:
        '''The display name of the image.

        *Length Constraints* : Minimum length of 1. Maximum length of 128.

        *Pattern* : ``^\\S(.*\\S)?$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-imagedisplayname
        '''
        result = self._values.get("image_display_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''A list of key-value pairs to apply to this resource.

        *Array Members* : Minimum number of 0 items. Maximum number of 50 items.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-image.html#cfn-sagemaker-image-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnImageProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnImageVersion(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnImageVersion",
):
    '''A CloudFormation ``AWS::SageMaker::ImageVersion``.

    Creates a version of the SageMaker image specified by ``ImageName`` . The version represents the Amazon Container Registry (ECR) container image specified by ``BaseImage`` .
    .. epigraph::

       You can use the ``DependsOn`` attribute to specify that the creation of a specific resource follows another. You can use it for the following use cases. For more information, see ```DependsOn`` attribute <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html>`_ .

       1. ``DependsOn`` can be used to establish a parent/child relationship between ``ImageVersion`` and ``Image`` where the ``ImageVersion`` ``DependsOn`` the ``Image`` .
       2. ``DependsOn`` can be used to establish order among ``ImageVersion`` s within the same ``Image`` namespace. For example, if ImageVersionB ``DependsOn`` ImageVersionA and both share the same parent ``Image`` , then ImageVersionA is version N and ImageVersionB is N+1.

    :cloudformationResource: AWS::SageMaker::ImageVersion
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        cfn_image_version = sagemaker.CfnImageVersion(self, "MyCfnImageVersion",
            base_image="baseImage",
            image_name="imageName"
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        base_image: builtins.str,
        image_name: builtins.str,
    ) -> None:
        '''Create a new ``AWS::SageMaker::ImageVersion``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param base_image: The container image that the SageMaker image version is based on. *Length Constraints* : Minimum length of 1. Maximum length of 255. *Pattern* : ``.*``
        :param image_name: The name of the parent image. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__225b629ad42fb0f54f243b7959716655b1e6ab97b24788346b8dc2ef867b288e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnImageVersionProps(base_image=base_image, image_name=image_name)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cbe38e7703b22fe77075c5bac3b3cf50e009d6e239f1b3cbaa476dc86cdf5038)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__044022492381c3ca9d8440c3e841212fe2e00c3bea9bf13606dcf975f1eaee46)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrContainerImage")
    def attr_container_image(self) -> builtins.str:
        '''The URI of the container image version referenced by ImageVersion.

        :cloudformationAttribute: ContainerImage
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrContainerImage"))

    @builtins.property
    @jsii.member(jsii_name="attrImageArn")
    def attr_image_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the parent Image.

        :cloudformationAttribute: ImageArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrImageArn"))

    @builtins.property
    @jsii.member(jsii_name="attrImageVersionArn")
    def attr_image_version_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the image version.

        *Type* : String

        *Length Constraints* : Maximum length of 256.

        *Pattern* : ``^arn:aws(-[\\w]+)*:sagemaker:.+:[0-9]{12}:image-version/[a-z0-9]([-.]?[a-z0-9])* /[0-9]+$``

        :cloudformationAttribute: ImageVersionArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrImageVersionArn"))

    @builtins.property
    @jsii.member(jsii_name="attrVersion")
    def attr_version(self) -> jsii.Number:
        '''The version of the image.

        :cloudformationAttribute: Version
        '''
        return typing.cast(jsii.Number, jsii.get(self, "attrVersion"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="baseImage")
    def base_image(self) -> builtins.str:
        '''The container image that the SageMaker image version is based on.

        *Length Constraints* : Minimum length of 1. Maximum length of 255.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-baseimage
        '''
        return typing.cast(builtins.str, jsii.get(self, "baseImage"))

    @base_image.setter
    def base_image(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d9abe29322fed02dd61e5e5c230cd984abfa28e4cff391834acb256078b917da)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "baseImage", value)

    @builtins.property
    @jsii.member(jsii_name="imageName")
    def image_name(self) -> builtins.str:
        '''The name of the parent image.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-imagename
        '''
        return typing.cast(builtins.str, jsii.get(self, "imageName"))

    @image_name.setter
    def image_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__789c39f6d1c8a352ff0c9002011a3945fe21676c94f63d62be3ad044d2dd90df)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "imageName", value)


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnImageVersionProps",
    jsii_struct_bases=[],
    name_mapping={"base_image": "baseImage", "image_name": "imageName"},
)
class CfnImageVersionProps:
    def __init__(self, *, base_image: builtins.str, image_name: builtins.str) -> None:
        '''Properties for defining a ``CfnImageVersion``.

        :param base_image: The container image that the SageMaker image version is based on. *Length Constraints* : Minimum length of 1. Maximum length of 255. *Pattern* : ``.*``
        :param image_name: The name of the parent image. *Length Constraints* : Minimum length of 1. Maximum length of 63. *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            cfn_image_version_props = sagemaker.CfnImageVersionProps(
                base_image="baseImage",
                image_name="imageName"
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6b12e5d4d0c08aec157c56acce41875ce6a5646bdd107b8500e7b76c643cb587)
            check_type(argname="argument base_image", value=base_image, expected_type=type_hints["base_image"])
            check_type(argname="argument image_name", value=image_name, expected_type=type_hints["image_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "base_image": base_image,
            "image_name": image_name,
        }

    @builtins.property
    def base_image(self) -> builtins.str:
        '''The container image that the SageMaker image version is based on.

        *Length Constraints* : Minimum length of 1. Maximum length of 255.

        *Pattern* : ``.*``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-baseimage
        '''
        result = self._values.get("base_image")
        assert result is not None, "Required property 'base_image' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def image_name(self) -> builtins.str:
        '''The name of the parent image.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : ``^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$``

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-imageversion.html#cfn-sagemaker-imageversion-imagename
        '''
        result = self._values.get("image_name")
        assert result is not None, "Required property 'image_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnImageVersionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnModel(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnModel",
):
    '''A CloudFormation ``AWS::SageMaker::Model``.

    The ``AWS::SageMaker::Model`` resource to create a model to host at an Amazon SageMaker endpoint. For more information, see `Deploying a Model on Amazon SageMaker Hosting Services <https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-hosting.html>`_ in the *Amazon SageMaker Developer Guide* .

    :cloudformationResource: AWS::SageMaker::Model
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        # environment: Any
        
        cfn_model = sagemaker.CfnModel(self, "MyCfnModel",
            execution_role_arn="executionRoleArn",
        
            # the properties below are optional
            containers=[sagemaker.CfnModel.ContainerDefinitionProperty(
                container_hostname="containerHostname",
                environment=environment,
                image="image",
                image_config=sagemaker.CfnModel.ImageConfigProperty(
                    repository_access_mode="repositoryAccessMode",
        
                    # the properties below are optional
                    repository_auth_config=sagemaker.CfnModel.RepositoryAuthConfigProperty(
                        repository_credentials_provider_arn="repositoryCredentialsProviderArn"
                    )
                ),
                inference_specification_name="inferenceSpecificationName",
                mode="mode",
                model_data_url="modelDataUrl",
                model_package_name="modelPackageName",
                multi_model_config=sagemaker.CfnModel.MultiModelConfigProperty(
                    model_cache_setting="modelCacheSetting"
                )
            )],
            enable_network_isolation=False,
            inference_execution_config=sagemaker.CfnModel.InferenceExecutionConfigProperty(
                mode="mode"
            ),
            model_name="modelName",
            primary_container=sagemaker.CfnModel.ContainerDefinitionProperty(
                container_hostname="containerHostname",
                environment=environment,
                image="image",
                image_config=sagemaker.CfnModel.ImageConfigProperty(
                    repository_access_mode="repositoryAccessMode",
        
                    # the properties below are optional
                    repository_auth_config=sagemaker.CfnModel.RepositoryAuthConfigProperty(
                        repository_credentials_provider_arn="repositoryCredentialsProviderArn"
                    )
                ),
                inference_specification_name="inferenceSpecificationName",
                mode="mode",
                model_data_url="modelDataUrl",
                model_package_name="modelPackageName",
                multi_model_config=sagemaker.CfnModel.MultiModelConfigProperty(
                    model_cache_setting="modelCacheSetting"
                )
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )],
            vpc_config=sagemaker.CfnModel.VpcConfigProperty(
                security_group_ids=["securityGroupIds"],
                subnets=["subnets"]
            )
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        execution_role_arn: builtins.str,
        containers: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnModel.ContainerDefinitionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        enable_network_isolation: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        inference_execution_config: typing.Optional[typing.Union[typing.Union["CfnModel.InferenceExecutionConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        model_name: typing.Optional[builtins.str] = None,
        primary_container: typing.Optional[typing.Union[typing.Union["CfnModel.ContainerDefinitionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
        vpc_config: typing.Optional[typing.Union[typing.Union["CfnModel.VpcConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::Model``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param execution_role_arn: The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs. Deploying on ML compute instances is part of model hosting. For more information, see `SageMaker Roles <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html>`_ . .. epigraph:: To be able to pass this role to SageMaker, the caller of this API must have the ``iam:PassRole`` permission.
        :param containers: Specifies the containers in the inference pipeline.
        :param enable_network_isolation: Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
        :param inference_execution_config: Specifies details of how containers in a multi-container endpoint are called.
        :param model_name: The name of the new model.
        :param primary_container: The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions.
        :param tags: A list of key-value pairs to apply to this resource. For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .
        :param vpc_config: A `VpcConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_VpcConfig.html>`_ object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. ``VpcConfig`` is used in hosting services and in batch transform. For more information, see `Protect Endpoints by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html>`_ and `Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c44d3c1d22de9ec0312ba589fd5884d2387cd60bd434000a58cd1a44079162f0)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnModelProps(
            execution_role_arn=execution_role_arn,
            containers=containers,
            enable_network_isolation=enable_network_isolation,
            inference_execution_config=inference_execution_config,
            model_name=model_name,
            primary_container=primary_container,
            tags=tags,
            vpc_config=vpc_config,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f96be53e43fe203feab2abe6e98bc4c918870ab61aa37eea10ef547a350b69f8)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4140a55b2f4fc03e47b92fb69253fca469fdb866f77355c6093075ace952521a)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrModelName")
    def attr_model_name(self) -> builtins.str:
        '''The name of the model, such as ``MyModel`` .

        :cloudformationAttribute: ModelName
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrModelName"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''A list of key-value pairs to apply to this resource.

        For more information, see `Resource Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ and `Using Cost Allocation Tags <https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what>`_ in the *AWS Billing and Cost Management User Guide* .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="executionRoleArn")
    def execution_role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs.

        Deploying on ML compute instances is part of model hosting. For more information, see `SageMaker Roles <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html>`_ .
        .. epigraph::

           To be able to pass this role to SageMaker, the caller of this API must have the ``iam:PassRole`` permission.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "executionRoleArn"))

    @execution_role_arn.setter
    def execution_role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d2ef9565c768783f9d5c7c50501f9aceeea510f114a22a0ffeadb6e5e809307)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "executionRoleArn", value)

    @builtins.property
    @jsii.member(jsii_name="containers")
    def containers(
        self,
    ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnModel.ContainerDefinitionProperty", _IResolvable_a771d0ef]]]]:
        '''Specifies the containers in the inference pipeline.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
        '''
        return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnModel.ContainerDefinitionProperty", _IResolvable_a771d0ef]]]], jsii.get(self, "containers"))

    @containers.setter
    def containers(
        self,
        value: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnModel.ContainerDefinitionProperty", _IResolvable_a771d0ef]]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e845d8952b6faa36d505453301cb2ca90124ec5a9d61ab9c7189a5fe3ab1d4eb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "containers", value)

    @builtins.property
    @jsii.member(jsii_name="enableNetworkIsolation")
    def enable_network_isolation(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
        '''Isolates the model container.

        No inbound or outbound network calls can be made to or from the model container.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-enablenetworkisolation
        '''
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], jsii.get(self, "enableNetworkIsolation"))

    @enable_network_isolation.setter
    def enable_network_isolation(
        self,
        value: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ef1b7040030e29e0c6a453e5788311468a230f6187626924f7987c9457649270)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enableNetworkIsolation", value)

    @builtins.property
    @jsii.member(jsii_name="inferenceExecutionConfig")
    def inference_execution_config(
        self,
    ) -> typing.Optional[typing.Union["CfnModel.InferenceExecutionConfigProperty", _IResolvable_a771d0ef]]:
        '''Specifies details of how containers in a multi-container endpoint are called.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-inferenceexecutionconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnModel.InferenceExecutionConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "inferenceExecutionConfig"))

    @inference_execution_config.setter
    def inference_execution_config(
        self,
        value: typing.Optional[typing.Union["CfnModel.InferenceExecutionConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d814cf205c887d2cabc5d737edeab046176a093e44375fa6c7c0513c8f2fdb1b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "inferenceExecutionConfig", value)

    @builtins.property
    @jsii.member(jsii_name="modelName")
    def model_name(self) -> typing.Optional[builtins.str]:
        '''The name of the new model.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "modelName"))

    @model_name.setter
    def model_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77ae20bbd722b52a2eb5524abff5406da20143036b7ec77c7eb02a221c9a7893)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelName", value)

    @builtins.property
    @jsii.member(jsii_name="primaryContainer")
    def primary_container(
        self,
    ) -> typing.Optional[typing.Union["CfnModel.ContainerDefinitionProperty", _IResolvable_a771d0ef]]:
        '''The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
        '''
        return typing.cast(typing.Optional[typing.Union["CfnModel.ContainerDefinitionProperty", _IResolvable_a771d0ef]], jsii.get(self, "primaryContainer"))

    @primary_container.setter
    def primary_container(
        self,
        value: typing.Optional[typing.Union["CfnModel.ContainerDefinitionProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0946cdfce517cdf28e54899a98409e094ae7a181245145f2d41fee402a6e7569)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "primaryContainer", value)

    @builtins.property
    @jsii.member(jsii_name="vpcConfig")
    def vpc_config(
        self,
    ) -> typing.Optional[typing.Union["CfnModel.VpcConfigProperty", _IResolvable_a771d0ef]]:
        '''A `VpcConfig <https://docs.aws.amazon.com/sagemaker/latest/dg/API_VpcConfig.html>`_ object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. ``VpcConfig`` is used in hosting services and in batch transform. For more information, see `Protect Endpoints by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html>`_ and `Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnModel.VpcConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "vpcConfig"))

    @vpc_config.setter
    def vpc_config(
        self,
        value: typing.Optional[typing.Union["CfnModel.VpcConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6bd9635c3f24f06a8960a92003df4a896362839d11c2f8ee6cf09f046bca8051)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "vpcConfig", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModel.ContainerDefinitionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "container_hostname": "containerHostname",
            "environment": "environment",
            "image": "image",
            "image_config": "imageConfig",
            "inference_specification_name": "inferenceSpecificationName",
            "mode": "mode",
            "model_data_url": "modelDataUrl",
            "model_package_name": "modelPackageName",
            "multi_model_config": "multiModelConfig",
        },
    )
    class ContainerDefinitionProperty:
        def __init__(
            self,
            *,
            container_hostname: typing.Optional[builtins.str] = None,
            environment: typing.Any = None,
            image: typing.Optional[builtins.str] = None,
            image_config: typing.Optional[typing.Union[typing.Union["CfnModel.ImageConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            inference_specification_name: typing.Optional[builtins.str] = None,
            mode: typing.Optional[builtins.str] = None,
            model_data_url: typing.Optional[builtins.str] = None,
            model_package_name: typing.Optional[builtins.str] = None,
            multi_model_config: typing.Optional[typing.Union[typing.Union["CfnModel.MultiModelConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Describes the container, as part of model definition.

            :param container_hostname: This parameter is ignored for models that contain only a ``PrimaryContainer`` . When a ``ContainerDefinition`` is part of an inference pipeline, the value of the parameter uniquely identifies the container for the purposes of logging and metrics. For information, see `Use Logs and Metrics to Monitor an Inference Pipeline <https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html>`_ . If you don't specify a value for this parameter for a ``ContainerDefinition`` that is part of an inference pipeline, a unique name is automatically assigned based on the position of the ``ContainerDefinition`` in the pipeline. If you specify a value for the ``ContainerHostName`` for any ``ContainerDefinition`` that is part of an inference pipeline, you must specify a value for the ``ContainerHostName`` parameter of every ``ContainerDefinition`` in that pipeline.
            :param environment: The environment variables to set in the Docker container. Each key and value in the ``Environment`` string to string map can have length of up to 1024. We support up to 16 entries in the map.
            :param image: The path where inference code is stored. This can be either in Amazon EC2 Container Registry or in a Docker registry that is accessible from the same VPC that you configure for your endpoint. If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both ``registry/repository[:tag]`` and ``registry/repository[@digest]`` image path formats. For more information, see `Using Your Own Algorithms with Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html>`_
            :param image_config: Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For information about storing containers in a private Docker registry, see `Use a Private Docker Registry for Real-Time Inference Containers <https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html>`_
            :param inference_specification_name: The inference specification name in the model package version.
            :param mode: Whether the container hosts a single model or multiple models.
            :param model_data_url: The S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for SageMaker built-in algorithms, but not if you use your own algorithms. For more information on built-in algorithms, see `Common Parameters <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html>`_ . .. epigraph:: The model artifacts must be in an S3 bucket that is in the same region as the model or endpoint you are creating. If you provide a value for this parameter, SageMaker uses AWS Security Token Service to download model artifacts from the S3 path you provide. AWS STS is activated in your IAM user account by default. If you previously deactivated AWS STS for a region, you need to reactivate AWS STS for that region. For more information, see `Activating and Deactivating AWS STS in an AWS Region <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html>`_ in the *AWS Identity and Access Management User Guide* . .. epigraph:: If you use a built-in algorithm to create a model, SageMaker requires that you provide a S3 path to the model artifacts in ``ModelDataUrl`` .
            :param model_package_name: The name or Amazon Resource Name (ARN) of the model package to use to create the model.
            :param multi_model_config: Specifies additional configuration for multi-model endpoints.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                # environment: Any
                
                container_definition_property = sagemaker.CfnModel.ContainerDefinitionProperty(
                    container_hostname="containerHostname",
                    environment=environment,
                    image="image",
                    image_config=sagemaker.CfnModel.ImageConfigProperty(
                        repository_access_mode="repositoryAccessMode",
                
                        # the properties below are optional
                        repository_auth_config=sagemaker.CfnModel.RepositoryAuthConfigProperty(
                            repository_credentials_provider_arn="repositoryCredentialsProviderArn"
                        )
                    ),
                    inference_specification_name="inferenceSpecificationName",
                    mode="mode",
                    model_data_url="modelDataUrl",
                    model_package_name="modelPackageName",
                    multi_model_config=sagemaker.CfnModel.MultiModelConfigProperty(
                        model_cache_setting="modelCacheSetting"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c19cd157ded4806078545942f0ddd870818a54c2ce895aae554941c7f5891d70)
                check_type(argname="argument container_hostname", value=container_hostname, expected_type=type_hints["container_hostname"])
                check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
                check_type(argname="argument image", value=image, expected_type=type_hints["image"])
                check_type(argname="argument image_config", value=image_config, expected_type=type_hints["image_config"])
                check_type(argname="argument inference_specification_name", value=inference_specification_name, expected_type=type_hints["inference_specification_name"])
                check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
                check_type(argname="argument model_data_url", value=model_data_url, expected_type=type_hints["model_data_url"])
                check_type(argname="argument model_package_name", value=model_package_name, expected_type=type_hints["model_package_name"])
                check_type(argname="argument multi_model_config", value=multi_model_config, expected_type=type_hints["multi_model_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if container_hostname is not None:
                self._values["container_hostname"] = container_hostname
            if environment is not None:
                self._values["environment"] = environment
            if image is not None:
                self._values["image"] = image
            if image_config is not None:
                self._values["image_config"] = image_config
            if inference_specification_name is not None:
                self._values["inference_specification_name"] = inference_specification_name
            if mode is not None:
                self._values["mode"] = mode
            if model_data_url is not None:
                self._values["model_data_url"] = model_data_url
            if model_package_name is not None:
                self._values["model_package_name"] = model_package_name
            if multi_model_config is not None:
                self._values["multi_model_config"] = multi_model_config

        @builtins.property
        def container_hostname(self) -> typing.Optional[builtins.str]:
            '''This parameter is ignored for models that contain only a ``PrimaryContainer`` .

            When a ``ContainerDefinition`` is part of an inference pipeline, the value of the parameter uniquely identifies the container for the purposes of logging and metrics. For information, see `Use Logs and Metrics to Monitor an Inference Pipeline <https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html>`_ . If you don't specify a value for this parameter for a ``ContainerDefinition`` that is part of an inference pipeline, a unique name is automatically assigned based on the position of the ``ContainerDefinition`` in the pipeline. If you specify a value for the ``ContainerHostName`` for any ``ContainerDefinition`` that is part of an inference pipeline, you must specify a value for the ``ContainerHostName`` parameter of every ``ContainerDefinition`` in that pipeline.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
            '''
            result = self._values.get("container_hostname")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def environment(self) -> typing.Any:
            '''The environment variables to set in the Docker container.

            Each key and value in the ``Environment`` string to string map can have length of up to 1024. We support up to 16 entries in the map.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
            '''
            result = self._values.get("environment")
            return typing.cast(typing.Any, result)

        @builtins.property
        def image(self) -> typing.Optional[builtins.str]:
            '''The path where inference code is stored.

            This can be either in Amazon EC2 Container Registry or in a Docker registry that is accessible from the same VPC that you configure for your endpoint. If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both ``registry/repository[:tag]`` and ``registry/repository[@digest]`` image path formats. For more information, see `Using Your Own Algorithms with Amazon SageMaker <https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html>`_

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
            '''
            result = self._values.get("image")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def image_config(
            self,
        ) -> typing.Optional[typing.Union["CfnModel.ImageConfigProperty", _IResolvable_a771d0ef]]:
            '''Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC).

            For information about storing containers in a private Docker registry, see `Use a Private Docker Registry for Real-Time Inference Containers <https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html>`_

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-imageconfig
            '''
            result = self._values.get("image_config")
            return typing.cast(typing.Optional[typing.Union["CfnModel.ImageConfigProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def inference_specification_name(self) -> typing.Optional[builtins.str]:
            '''The inference specification name in the model package version.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-inferencespecificationname
            '''
            result = self._values.get("inference_specification_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def mode(self) -> typing.Optional[builtins.str]:
            '''Whether the container hosts a single model or multiple models.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-mode
            '''
            result = self._values.get("mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def model_data_url(self) -> typing.Optional[builtins.str]:
            '''The S3 path where the model artifacts, which result from model training, are stored.

            This path must point to a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for SageMaker built-in algorithms, but not if you use your own algorithms. For more information on built-in algorithms, see `Common Parameters <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html>`_ .
            .. epigraph::

               The model artifacts must be in an S3 bucket that is in the same region as the model or endpoint you are creating.

            If you provide a value for this parameter, SageMaker uses AWS Security Token Service to download model artifacts from the S3 path you provide. AWS STS is activated in your IAM user account by default. If you previously deactivated AWS STS for a region, you need to reactivate AWS STS for that region. For more information, see `Activating and Deactivating AWS STS in an AWS Region <https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html>`_ in the *AWS Identity and Access Management User Guide* .
            .. epigraph::

               If you use a built-in algorithm to create a model, SageMaker requires that you provide a S3 path to the model artifacts in ``ModelDataUrl`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
            '''
            result = self._values.get("model_data_url")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def model_package_name(self) -> typing.Optional[builtins.str]:
            '''The name or Amazon Resource Name (ARN) of the model package to use to create the model.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modelpackagename
            '''
            result = self._values.get("model_package_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def multi_model_config(
            self,
        ) -> typing.Optional[typing.Union["CfnModel.MultiModelConfigProperty", _IResolvable_a771d0ef]]:
            '''Specifies additional configuration for multi-model endpoints.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-multimodelconfig
            '''
            result = self._values.get("multi_model_config")
            return typing.cast(typing.Optional[typing.Union["CfnModel.MultiModelConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ContainerDefinitionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModel.ImageConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "repository_access_mode": "repositoryAccessMode",
            "repository_auth_config": "repositoryAuthConfig",
        },
    )
    class ImageConfigProperty:
        def __init__(
            self,
            *,
            repository_access_mode: builtins.str,
            repository_auth_config: typing.Optional[typing.Union[typing.Union["CfnModel.RepositoryAuthConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC).

            :param repository_access_mode: Set this to one of the following values:. - ``Platform`` - The model image is hosted in Amazon ECR. - ``Vpc`` - The model image is hosted in a private Docker registry in your VPC.
            :param repository_auth_config: (Optional) Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified ``Vpc`` as the value for the ``RepositoryAccessMode`` field, and the private Docker registry where the model image is hosted requires authentication.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                image_config_property = sagemaker.CfnModel.ImageConfigProperty(
                    repository_access_mode="repositoryAccessMode",
                
                    # the properties below are optional
                    repository_auth_config=sagemaker.CfnModel.RepositoryAuthConfigProperty(
                        repository_credentials_provider_arn="repositoryCredentialsProviderArn"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c86b1a8143da8dc96c143ebd0780427816a6dc0c8764ed0a3ec60c560aa0a277)
                check_type(argname="argument repository_access_mode", value=repository_access_mode, expected_type=type_hints["repository_access_mode"])
                check_type(argname="argument repository_auth_config", value=repository_auth_config, expected_type=type_hints["repository_auth_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "repository_access_mode": repository_access_mode,
            }
            if repository_auth_config is not None:
                self._values["repository_auth_config"] = repository_auth_config

        @builtins.property
        def repository_access_mode(self) -> builtins.str:
            '''Set this to one of the following values:.

            - ``Platform`` - The model image is hosted in Amazon ECR.
            - ``Vpc`` - The model image is hosted in a private Docker registry in your VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig.html#cfn-sagemaker-model-containerdefinition-imageconfig-repositoryaccessmode
            '''
            result = self._values.get("repository_access_mode")
            assert result is not None, "Required property 'repository_access_mode' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def repository_auth_config(
            self,
        ) -> typing.Optional[typing.Union["CfnModel.RepositoryAuthConfigProperty", _IResolvable_a771d0ef]]:
            '''(Optional) Specifies an authentication configuration for the private docker registry where your model image is hosted.

            Specify a value for this property only if you specified ``Vpc`` as the value for the ``RepositoryAccessMode`` field, and the private Docker registry where the model image is hosted requires authentication.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig.html#cfn-sagemaker-model-containerdefinition-imageconfig-repositoryauthconfig
            '''
            result = self._values.get("repository_auth_config")
            return typing.cast(typing.Optional[typing.Union["CfnModel.RepositoryAuthConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ImageConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModel.InferenceExecutionConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"mode": "mode"},
    )
    class InferenceExecutionConfigProperty:
        def __init__(self, *, mode: builtins.str) -> None:
            '''Specifies details about how containers in a multi-container endpoint are run.

            :param mode: How containers in a multi-container are run. The following values are valid. - ``Serial`` - Containers run as a serial pipeline. - ``Direct`` - Only the individual container that you specify is run.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-inferenceexecutionconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                inference_execution_config_property = sagemaker.CfnModel.InferenceExecutionConfigProperty(
                    mode="mode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d9fa926a5979c7f6b594cf39d2e74a8f7f5cf2b85a4f153b27aa959cc1d80814)
                check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "mode": mode,
            }

        @builtins.property
        def mode(self) -> builtins.str:
            '''How containers in a multi-container are run. The following values are valid.

            - ``Serial`` - Containers run as a serial pipeline.
            - ``Direct`` - Only the individual container that you specify is run.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-inferenceexecutionconfig.html#cfn-sagemaker-model-inferenceexecutionconfig-mode
            '''
            result = self._values.get("mode")
            assert result is not None, "Required property 'mode' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InferenceExecutionConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModel.MultiModelConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"model_cache_setting": "modelCacheSetting"},
    )
    class MultiModelConfigProperty:
        def __init__(
            self,
            *,
            model_cache_setting: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Specifies additional configuration for hosting multi-model endpoints.

            :param model_cache_setting: Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so that a model does not have to be loaded into memory each time it is invoked. Some use cases do not benefit from model caching. For example, if an endpoint hosts a large number of models that are each invoked infrequently, the endpoint might perform better if you disable model caching. To disable model caching, set the value of this parameter to Disabled.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-multimodelconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                multi_model_config_property = sagemaker.CfnModel.MultiModelConfigProperty(
                    model_cache_setting="modelCacheSetting"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c625fe79b92318035fcbf50917daceb76751b426e01fb8ca09604f07dd6cbfed)
                check_type(argname="argument model_cache_setting", value=model_cache_setting, expected_type=type_hints["model_cache_setting"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if model_cache_setting is not None:
                self._values["model_cache_setting"] = model_cache_setting

        @builtins.property
        def model_cache_setting(self) -> typing.Optional[builtins.str]:
            '''Whether to cache models for a multi-model endpoint.

            By default, multi-model endpoints cache models so that a model does not have to be loaded into memory each time it is invoked. Some use cases do not benefit from model caching. For example, if an endpoint hosts a large number of models that are each invoked infrequently, the endpoint might perform better if you disable model caching. To disable model caching, set the value of this parameter to Disabled.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-multimodelconfig.html#cfn-sagemaker-model-containerdefinition-multimodelconfig-modelcachesetting
            '''
            result = self._values.get("model_cache_setting")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MultiModelConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModel.RepositoryAuthConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "repository_credentials_provider_arn": "repositoryCredentialsProviderArn",
        },
    )
    class RepositoryAuthConfigProperty:
        def __init__(
            self,
            *,
            repository_credentials_provider_arn: builtins.str,
        ) -> None:
            '''Specifies an authentication configuration for the private docker registry where your model image is hosted.

            Specify a value for this property only if you specified ``Vpc`` as the value for the ``RepositoryAccessMode`` field of the ``ImageConfig`` object that you passed to a call to ``CreateModel`` and the private Docker registry where the model image is hosted requires authentication.

            :param repository_credentials_provider_arn: The Amazon Resource Name (ARN) of an AWS Lambda function that provides credentials to authenticate to the private Docker registry where your model image is hosted. For information about how to create an AWS Lambda function, see `Create a Lambda function with the console <https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html>`_ in the *AWS Lambda Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig-repositoryauthconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                repository_auth_config_property = sagemaker.CfnModel.RepositoryAuthConfigProperty(
                    repository_credentials_provider_arn="repositoryCredentialsProviderArn"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__aefc4545d2af80288f07589422f685de5685ada9841d0945baddc5a5b0cf30b8)
                check_type(argname="argument repository_credentials_provider_arn", value=repository_credentials_provider_arn, expected_type=type_hints["repository_credentials_provider_arn"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "repository_credentials_provider_arn": repository_credentials_provider_arn,
            }

        @builtins.property
        def repository_credentials_provider_arn(self) -> builtins.str:
            '''The Amazon Resource Name (ARN) of an AWS Lambda function that provides credentials to authenticate to the private Docker registry where your model image is hosted.

            For information about how to create an AWS Lambda function, see `Create a Lambda function with the console <https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html>`_ in the *AWS Lambda Developer Guide* .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig-repositoryauthconfig.html#cfn-sagemaker-model-containerdefinition-imageconfig-repositoryauthconfig-repositorycredentialsproviderarn
            '''
            result = self._values.get("repository_credentials_provider_arn")
            assert result is not None, "Required property 'repository_credentials_provider_arn' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "RepositoryAuthConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModel.VpcConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"security_group_ids": "securityGroupIds", "subnets": "subnets"},
    )
    class VpcConfigProperty:
        def __init__(
            self,
            *,
            security_group_ids: typing.Sequence[builtins.str],
            subnets: typing.Sequence[builtins.str],
        ) -> None:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC. For more information, see `Protect Endpoints by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html>`_ and `Protect Training Jobs by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html>`_ .

            :param security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the ``Subnets`` field.
            :param subnets: The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                vpc_config_property = sagemaker.CfnModel.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__839e2b3deca07bbb690352efd47173e1ba5285b72e63165eb3ccbcc756a0151d)
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
                check_type(argname="argument subnets", value=subnets, expected_type=type_hints["subnets"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "security_group_ids": security_group_ids,
                "subnets": subnets,
            }

        @builtins.property
        def security_group_ids(self) -> typing.List[builtins.str]:
            '''The VPC security group IDs, in the form sg-xxxxxxxx.

            Specify the security groups for the VPC that is specified in the ``Subnets`` field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            assert result is not None, "Required property 'security_group_ids' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def subnets(self) -> typing.List[builtins.str]:
            '''The ID of the subnets in the VPC to which you want to connect your training job or model.

            For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
            '''
            result = self._values.get("subnets")
            assert result is not None, "Required property 'subnets' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VpcConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.implements(_IInspectable_82c04a63)
class CfnModelBiasJobDefinition(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition",
):
    '''A CloudFormation ``AWS::SageMaker::ModelBiasJobDefinition``.

    Creates the definition for a model bias job.

    :cloudformationResource: AWS::SageMaker::ModelBiasJobDefinition
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        # json: Any
        
        cfn_model_bias_job_definition = sagemaker.CfnModelBiasJobDefinition(self, "MyCfnModelBiasJobDefinition",
            job_resources=sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty(
                cluster_config=sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
        
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            ),
            model_bias_app_specification=sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty(
                config_uri="configUri",
                image_uri="imageUri",
        
                # the properties below are optional
                environment={
                    "environment_key": "environment"
                }
            ),
            model_bias_job_input=sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty(
                ground_truth_s3_input=sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty(
                    s3_uri="s3Uri"
                ),
        
                # the properties below are optional
                batch_transform_input=sagemaker.CfnModelBiasJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=json,
                        parquet=False
                    ),
                    local_path="localPath",
        
                    # the properties below are optional
                    end_time_offset="endTimeOffset",
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    probability_threshold_attribute=123,
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode",
                    start_time_offset="startTimeOffset"
                ),
                endpoint_input=sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
        
                    # the properties below are optional
                    end_time_offset="endTimeOffset",
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    probability_threshold_attribute=123,
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode",
                    start_time_offset="startTimeOffset"
                )
            ),
            model_bias_job_output_config=sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty(
                monitoring_outputs=[sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnModelBiasJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )],
        
                # the properties below are optional
                kms_key_id="kmsKeyId"
            ),
            role_arn="roleArn",
        
            # the properties below are optional
            endpoint_name="endpointName",
            job_definition_name="jobDefinitionName",
            model_bias_baseline_config=sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty(
                baselining_job_name="baseliningJobName",
                constraints_resource=sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                )
            ),
            network_config=sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty(
                enable_inter_container_traffic_encryption=False,
                enable_network_isolation=False,
                vpc_config=sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            ),
            stopping_condition=sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty(
                max_runtime_in_seconds=123
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        job_resources: typing.Union[typing.Union["CfnModelBiasJobDefinition.MonitoringResourcesProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_bias_app_specification: typing.Union[typing.Union["CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_bias_job_input: typing.Union[typing.Union["CfnModelBiasJobDefinition.ModelBiasJobInputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_bias_job_output_config: typing.Union[typing.Union["CfnModelBiasJobDefinition.MonitoringOutputConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        role_arn: builtins.str,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        model_bias_baseline_config: typing.Optional[typing.Union[typing.Union["CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        network_config: typing.Optional[typing.Union[typing.Union["CfnModelBiasJobDefinition.NetworkConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        stopping_condition: typing.Optional[typing.Union[typing.Union["CfnModelBiasJobDefinition.StoppingConditionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::ModelBiasJobDefinition``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param model_bias_app_specification: Configures the model bias job to run a specified Docker container image.
        :param model_bias_job_input: Inputs for the model bias job.
        :param model_bias_job_output_config: The output configuration for monitoring jobs.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param endpoint_name: ``AWS::SageMaker::ModelBiasJobDefinition.EndpointName``.
        :param job_definition_name: The name of the bias job definition. The name must be unique within an AWS Region in the AWS account.
        :param model_bias_baseline_config: The baseline configuration for a model bias job.
        :param network_config: Networking options for a model bias job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__02dd806ea112b31101101e94ffddc886f7830eb1d19e91cfa09511dc84baf2f6)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnModelBiasJobDefinitionProps(
            job_resources=job_resources,
            model_bias_app_specification=model_bias_app_specification,
            model_bias_job_input=model_bias_job_input,
            model_bias_job_output_config=model_bias_job_output_config,
            role_arn=role_arn,
            endpoint_name=endpoint_name,
            job_definition_name=job_definition_name,
            model_bias_baseline_config=model_bias_baseline_config,
            network_config=network_config,
            stopping_condition=stopping_condition,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5025d23bcd70cf2726c60ee0e15edbc7abb69303bb7b494f8277764fd7a7f39b)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__09d818af5081d2520654b7599f6c5222f4a7db8d32704d653a97d71f26a5ce7c)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCreationTime")
    def attr_creation_time(self) -> builtins.str:
        '''The time when the job definition was created.

        :cloudformationAttribute: CreationTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreationTime"))

    @builtins.property
    @jsii.member(jsii_name="attrJobDefinitionArn")
    def attr_job_definition_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the job definition.

        :cloudformationAttribute: JobDefinitionArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrJobDefinitionArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="jobResources")
    def job_resources(
        self,
    ) -> typing.Union["CfnModelBiasJobDefinition.MonitoringResourcesProperty", _IResolvable_a771d0ef]:
        '''Identifies the resources to deploy for a monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobresources
        '''
        return typing.cast(typing.Union["CfnModelBiasJobDefinition.MonitoringResourcesProperty", _IResolvable_a771d0ef], jsii.get(self, "jobResources"))

    @job_resources.setter
    def job_resources(
        self,
        value: typing.Union["CfnModelBiasJobDefinition.MonitoringResourcesProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__669978c15756ad4ff0a349d36fce1d03245c5f56ad7429a3e830cad1f68b4ec2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobResources", value)

    @builtins.property
    @jsii.member(jsii_name="modelBiasAppSpecification")
    def model_bias_app_specification(
        self,
    ) -> typing.Union["CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty", _IResolvable_a771d0ef]:
        '''Configures the model bias job to run a specified Docker container image.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification
        '''
        return typing.cast(typing.Union["CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty", _IResolvable_a771d0ef], jsii.get(self, "modelBiasAppSpecification"))

    @model_bias_app_specification.setter
    def model_bias_app_specification(
        self,
        value: typing.Union["CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d35c6b252934b7264fd644a5f729a0aa83b5a61656b44e869d5c3649f61650f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelBiasAppSpecification", value)

    @builtins.property
    @jsii.member(jsii_name="modelBiasJobInput")
    def model_bias_job_input(
        self,
    ) -> typing.Union["CfnModelBiasJobDefinition.ModelBiasJobInputProperty", _IResolvable_a771d0ef]:
        '''Inputs for the model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput
        '''
        return typing.cast(typing.Union["CfnModelBiasJobDefinition.ModelBiasJobInputProperty", _IResolvable_a771d0ef], jsii.get(self, "modelBiasJobInput"))

    @model_bias_job_input.setter
    def model_bias_job_input(
        self,
        value: typing.Union["CfnModelBiasJobDefinition.ModelBiasJobInputProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8f9bf9651e860a33b8e00bae7920c4b6f7e34506657a90a7ad2df0fa277f3911)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelBiasJobInput", value)

    @builtins.property
    @jsii.member(jsii_name="modelBiasJobOutputConfig")
    def model_bias_job_output_config(
        self,
    ) -> typing.Union["CfnModelBiasJobDefinition.MonitoringOutputConfigProperty", _IResolvable_a771d0ef]:
        '''The output configuration for monitoring jobs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjoboutputconfig
        '''
        return typing.cast(typing.Union["CfnModelBiasJobDefinition.MonitoringOutputConfigProperty", _IResolvable_a771d0ef], jsii.get(self, "modelBiasJobOutputConfig"))

    @model_bias_job_output_config.setter
    def model_bias_job_output_config(
        self,
        value: typing.Union["CfnModelBiasJobDefinition.MonitoringOutputConfigProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46959bd815cf95fb4491b322cbafe9f8cd9709733ee85512ba0f8b7ce5b5a59c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelBiasJobOutputConfig", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-rolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66923bf0d386bea8532c3ca4145641a65cf65137e40f4ce5d936dac89b292444)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value)

    @builtins.property
    @jsii.member(jsii_name="endpointName")
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''``AWS::SageMaker::ModelBiasJobDefinition.EndpointName``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-endpointname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointName"))

    @endpoint_name.setter
    def endpoint_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__984d34d8cf4701b8065b0ef28c9f703973ba3168e3967b945c24339a96c75f19)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointName", value)

    @builtins.property
    @jsii.member(jsii_name="jobDefinitionName")
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name of the bias job definition.

        The name must be unique within an AWS Region in the AWS account.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobdefinitionname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "jobDefinitionName"))

    @job_definition_name.setter
    def job_definition_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__310a0bf7e96cf5a5ffa4e89050e9ebd1cc98fbfa2e43c30b4e36a93edb9319ec)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobDefinitionName", value)

    @builtins.property
    @jsii.member(jsii_name="modelBiasBaselineConfig")
    def model_bias_baseline_config(
        self,
    ) -> typing.Optional[typing.Union["CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty", _IResolvable_a771d0ef]]:
        '''The baseline configuration for a model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "modelBiasBaselineConfig"))

    @model_bias_baseline_config.setter
    def model_bias_baseline_config(
        self,
        value: typing.Optional[typing.Union["CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__55ad541baa7e0f708e24841a3173a76b036c755ceeae21f252c0f40caacf12f8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelBiasBaselineConfig", value)

    @builtins.property
    @jsii.member(jsii_name="networkConfig")
    def network_config(
        self,
    ) -> typing.Optional[typing.Union["CfnModelBiasJobDefinition.NetworkConfigProperty", _IResolvable_a771d0ef]]:
        '''Networking options for a model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnModelBiasJobDefinition.NetworkConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "networkConfig"))

    @network_config.setter
    def network_config(
        self,
        value: typing.Optional[typing.Union["CfnModelBiasJobDefinition.NetworkConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8613db1e8611e250aff054d5e7c5f6796baf6cc2553b6a9b9687e15c9eca3a5a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "networkConfig", value)

    @builtins.property
    @jsii.member(jsii_name="stoppingCondition")
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union["CfnModelBiasJobDefinition.StoppingConditionProperty", _IResolvable_a771d0ef]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition
        '''
        return typing.cast(typing.Optional[typing.Union["CfnModelBiasJobDefinition.StoppingConditionProperty", _IResolvable_a771d0ef]], jsii.get(self, "stoppingCondition"))

    @stopping_condition.setter
    def stopping_condition(
        self,
        value: typing.Optional[typing.Union["CfnModelBiasJobDefinition.StoppingConditionProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1fe7d64dc5c2a4f2445f0c21254112538297a2d8ed2bcac662878f9f8f853897)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "stoppingCondition", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.BatchTransformInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_captured_destination_s3_uri": "dataCapturedDestinationS3Uri",
            "dataset_format": "datasetFormat",
            "local_path": "localPath",
            "end_time_offset": "endTimeOffset",
            "features_attribute": "featuresAttribute",
            "inference_attribute": "inferenceAttribute",
            "probability_attribute": "probabilityAttribute",
            "probability_threshold_attribute": "probabilityThresholdAttribute",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
            "start_time_offset": "startTimeOffset",
        },
    )
    class BatchTransformInputProperty:
        def __init__(
            self,
            *,
            data_captured_destination_s3_uri: builtins.str,
            dataset_format: typing.Union[typing.Union["CfnModelBiasJobDefinition.DatasetFormatProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            local_path: builtins.str,
            end_time_offset: typing.Optional[builtins.str] = None,
            features_attribute: typing.Optional[builtins.str] = None,
            inference_attribute: typing.Optional[builtins.str] = None,
            probability_attribute: typing.Optional[builtins.str] = None,
            probability_threshold_attribute: typing.Optional[jsii.Number] = None,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
            start_time_offset: typing.Optional[builtins.str] = None,
        ) -> None:
            '''
            :param data_captured_destination_s3_uri: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.DataCapturedDestinationS3Uri``.
            :param dataset_format: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.DatasetFormat``.
            :param local_path: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.LocalPath``.
            :param end_time_offset: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.EndTimeOffset``.
            :param features_attribute: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.FeaturesAttribute``.
            :param inference_attribute: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.InferenceAttribute``.
            :param probability_attribute: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.ProbabilityAttribute``.
            :param probability_threshold_attribute: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.ProbabilityThresholdAttribute``.
            :param s3_data_distribution_type: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.S3DataDistributionType``.
            :param s3_input_mode: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.S3InputMode``.
            :param start_time_offset: ``CfnModelBiasJobDefinition.BatchTransformInputProperty.StartTimeOffset``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                # json: Any
                
                batch_transform_input_property = sagemaker.CfnModelBiasJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=json,
                        parquet=False
                    ),
                    local_path="localPath",
                
                    # the properties below are optional
                    end_time_offset="endTimeOffset",
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    probability_threshold_attribute=123,
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode",
                    start_time_offset="startTimeOffset"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__428c00073182a8af91f304b02876db25dcefa62369de3b574e6979e14027ddca)
                check_type(argname="argument data_captured_destination_s3_uri", value=data_captured_destination_s3_uri, expected_type=type_hints["data_captured_destination_s3_uri"])
                check_type(argname="argument dataset_format", value=dataset_format, expected_type=type_hints["dataset_format"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument end_time_offset", value=end_time_offset, expected_type=type_hints["end_time_offset"])
                check_type(argname="argument features_attribute", value=features_attribute, expected_type=type_hints["features_attribute"])
                check_type(argname="argument inference_attribute", value=inference_attribute, expected_type=type_hints["inference_attribute"])
                check_type(argname="argument probability_attribute", value=probability_attribute, expected_type=type_hints["probability_attribute"])
                check_type(argname="argument probability_threshold_attribute", value=probability_threshold_attribute, expected_type=type_hints["probability_threshold_attribute"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
                check_type(argname="argument start_time_offset", value=start_time_offset, expected_type=type_hints["start_time_offset"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_captured_destination_s3_uri": data_captured_destination_s3_uri,
                "dataset_format": dataset_format,
                "local_path": local_path,
            }
            if end_time_offset is not None:
                self._values["end_time_offset"] = end_time_offset
            if features_attribute is not None:
                self._values["features_attribute"] = features_attribute
            if inference_attribute is not None:
                self._values["inference_attribute"] = inference_attribute
            if probability_attribute is not None:
                self._values["probability_attribute"] = probability_attribute
            if probability_threshold_attribute is not None:
                self._values["probability_threshold_attribute"] = probability_threshold_attribute
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode
            if start_time_offset is not None:
                self._values["start_time_offset"] = start_time_offset

        @builtins.property
        def data_captured_destination_s3_uri(self) -> builtins.str:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.DataCapturedDestinationS3Uri``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-datacaptureddestinations3uri
            '''
            result = self._values.get("data_captured_destination_s3_uri")
            assert result is not None, "Required property 'data_captured_destination_s3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def dataset_format(
            self,
        ) -> typing.Union["CfnModelBiasJobDefinition.DatasetFormatProperty", _IResolvable_a771d0ef]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.DatasetFormat``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-datasetformat
            '''
            result = self._values.get("dataset_format")
            assert result is not None, "Required property 'dataset_format' is missing"
            return typing.cast(typing.Union["CfnModelBiasJobDefinition.DatasetFormatProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.LocalPath``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def end_time_offset(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.EndTimeOffset``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-endtimeoffset
            '''
            result = self._values.get("end_time_offset")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def features_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.FeaturesAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-featuresattribute
            '''
            result = self._values.get("features_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def inference_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.InferenceAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-inferenceattribute
            '''
            result = self._values.get("inference_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.ProbabilityAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-probabilityattribute
            '''
            result = self._values.get("probability_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_threshold_attribute(self) -> typing.Optional[jsii.Number]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.ProbabilityThresholdAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-probabilitythresholdattribute
            '''
            result = self._values.get("probability_threshold_attribute")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.S3DataDistributionType``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.S3InputMode``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def start_time_offset(self) -> typing.Optional[builtins.str]:
            '''``CfnModelBiasJobDefinition.BatchTransformInputProperty.StartTimeOffset``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-batchtransforminput.html#cfn-sagemaker-modelbiasjobdefinition-batchtransforminput-starttimeoffset
            '''
            result = self._values.get("start_time_offset")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BatchTransformInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_count": "instanceCount",
            "instance_type": "instanceType",
            "volume_size_in_gb": "volumeSizeInGb",
            "volume_kms_key_id": "volumeKmsKeyId",
        },
    )
    class ClusterConfigProperty:
        def __init__(
            self,
            *,
            instance_count: jsii.Number,
            instance_type: builtins.str,
            volume_size_in_gb: jsii.Number,
            volume_kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration for the cluster resources used to run the processing job.

            :param instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
            :param instance_type: The ML compute instance type for the processing job.
            :param volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
            :param volume_kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                cluster_config_property = sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
                
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d5f709f8d07abfd68f0a871f45a422c12644e335285b55b9d991463673aae28b)
                check_type(argname="argument instance_count", value=instance_count, expected_type=type_hints["instance_count"])
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument volume_size_in_gb", value=volume_size_in_gb, expected_type=type_hints["volume_size_in_gb"])
                check_type(argname="argument volume_kms_key_id", value=volume_kms_key_id, expected_type=type_hints["volume_kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "instance_count": instance_count,
                "instance_type": instance_type,
                "volume_size_in_gb": volume_size_in_gb,
            }
            if volume_kms_key_id is not None:
                self._values["volume_kms_key_id"] = volume_kms_key_id

        @builtins.property
        def instance_count(self) -> jsii.Number:
            '''The number of ML compute instances to use in the model monitoring job.

            For distributed processing jobs, specify a value greater than 1. The default value is 1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-instancecount
            '''
            result = self._values.get("instance_count")
            assert result is not None, "Required property 'instance_count' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def instance_type(self) -> builtins.str:
            '''The ML compute instance type for the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-instancetype
            '''
            result = self._values.get("instance_type")
            assert result is not None, "Required property 'instance_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def volume_size_in_gb(self) -> jsii.Number:
            '''The size of the ML storage volume, in gigabytes, that you want to provision.

            You must specify sufficient ML storage for your scenario.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-volumesizeingb
            '''
            result = self._values.get("volume_size_in_gb")
            assert result is not None, "Required property 'volume_size_in_gb' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def volume_kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-volumekmskeyid
            '''
            result = self._values.get("volume_kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri"},
    )
    class ConstraintsResourceProperty:
        def __init__(self, *, s3_uri: typing.Optional[builtins.str] = None) -> None:
            '''The constraints resource for a monitoring job.

            :param s3_uri: The Amazon S3 URI for the constraints resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-constraintsresource.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                constraints_resource_property = sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__1d5828987cd579a9649eec583743f3d3b221789cec3d3d22236566982a97bcdc)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if s3_uri is not None:
                self._values["s3_uri"] = s3_uri

        @builtins.property
        def s3_uri(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 URI for the constraints resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-constraintsresource.html#cfn-sagemaker-modelbiasjobdefinition-constraintsresource-s3uri
            '''
            result = self._values.get("s3_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConstraintsResourceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.CsvProperty",
        jsii_struct_bases=[],
        name_mapping={"header": "header"},
    )
    class CsvProperty:
        def __init__(
            self,
            *,
            header: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param header: ``CfnModelBiasJobDefinition.CsvProperty.Header``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-csv.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                csv_property = sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                    header=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c12ad5520e01cbbfc0b4ed3e4095fefff4a8495d014f9067ffc619a83b229a5e)
                check_type(argname="argument header", value=header, expected_type=type_hints["header"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if header is not None:
                self._values["header"] = header

        @builtins.property
        def header(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''``CfnModelBiasJobDefinition.CsvProperty.Header``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-csv.html#cfn-sagemaker-modelbiasjobdefinition-csv-header
            '''
            result = self._values.get("header")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CsvProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty",
        jsii_struct_bases=[],
        name_mapping={"csv": "csv", "json": "json", "parquet": "parquet"},
    )
    class DatasetFormatProperty:
        def __init__(
            self,
            *,
            csv: typing.Optional[typing.Union[typing.Union["CfnModelBiasJobDefinition.CsvProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            json: typing.Any = None,
            parquet: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param csv: ``CfnModelBiasJobDefinition.DatasetFormatProperty.Csv``.
            :param json: ``CfnModelBiasJobDefinition.DatasetFormatProperty.Json``.
            :param parquet: ``CfnModelBiasJobDefinition.DatasetFormatProperty.Parquet``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-datasetformat.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                # json: Any
                
                dataset_format_property = sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty(
                    csv=sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                        header=False
                    ),
                    json=json,
                    parquet=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__87b68ccaee1e6c361ea5e2901848f0da427afb71acf518668158551def388cec)
                check_type(argname="argument csv", value=csv, expected_type=type_hints["csv"])
                check_type(argname="argument json", value=json, expected_type=type_hints["json"])
                check_type(argname="argument parquet", value=parquet, expected_type=type_hints["parquet"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if csv is not None:
                self._values["csv"] = csv
            if json is not None:
                self._values["json"] = json
            if parquet is not None:
                self._values["parquet"] = parquet

        @builtins.property
        def csv(
            self,
        ) -> typing.Optional[typing.Union["CfnModelBiasJobDefinition.CsvProperty", _IResolvable_a771d0ef]]:
            '''``CfnModelBiasJobDefinition.DatasetFormatProperty.Csv``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-datasetformat.html#cfn-sagemaker-modelbiasjobdefinition-datasetformat-csv
            '''
            result = self._values.get("csv")
            return typing.cast(typing.Optional[typing.Union["CfnModelBiasJobDefinition.CsvProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def json(self) -> typing.Any:
            '''``CfnModelBiasJobDefinition.DatasetFormatProperty.Json``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-datasetformat.html#cfn-sagemaker-modelbiasjobdefinition-datasetformat-json
            '''
            result = self._values.get("json")
            return typing.cast(typing.Any, result)

        @builtins.property
        def parquet(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''``CfnModelBiasJobDefinition.DatasetFormatProperty.Parquet``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-datasetformat.html#cfn-sagemaker-modelbiasjobdefinition-datasetformat-parquet
            '''
            result = self._values.get("parquet")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DatasetFormatProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "endpoint_name": "endpointName",
            "local_path": "localPath",
            "end_time_offset": "endTimeOffset",
            "features_attribute": "featuresAttribute",
            "inference_attribute": "inferenceAttribute",
            "probability_attribute": "probabilityAttribute",
            "probability_threshold_attribute": "probabilityThresholdAttribute",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
            "start_time_offset": "startTimeOffset",
        },
    )
    class EndpointInputProperty:
        def __init__(
            self,
            *,
            endpoint_name: builtins.str,
            local_path: builtins.str,
            end_time_offset: typing.Optional[builtins.str] = None,
            features_attribute: typing.Optional[builtins.str] = None,
            inference_attribute: typing.Optional[builtins.str] = None,
            probability_attribute: typing.Optional[builtins.str] = None,
            probability_threshold_attribute: typing.Optional[jsii.Number] = None,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
            start_time_offset: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Input object for the endpoint.

            :param endpoint_name: An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.
            :param local_path: Path to the filesystem where the endpoint data is available to the container.
            :param end_time_offset: If specified, monitoring jobs substract this time from the end time. For information about using offsets for scheduling monitoring jobs, see `Schedule Model Quality Monitoring Jobs <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html>`_ .
            :param features_attribute: The attributes of the input data that are the input features.
            :param inference_attribute: The attribute of the input data that represents the ground truth label.
            :param probability_attribute: In a classification problem, the attribute that represents the class probability.
            :param probability_threshold_attribute: The threshold for the class probability to be evaluated as a positive result.
            :param s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to ``FullyReplicated``
            :param s3_input_mode: Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job. ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .
            :param start_time_offset: If specified, monitoring jobs substract this time from the start time. For information about using offsets for scheduling monitoring jobs, see `Schedule Model Quality Monitoring Jobs <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                endpoint_input_property = sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
                
                    # the properties below are optional
                    end_time_offset="endTimeOffset",
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    probability_threshold_attribute=123,
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode",
                    start_time_offset="startTimeOffset"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__574e873b0c1050bc2502fe1aa4063b6b9eca34335fb3503f5c5c8e14ba543ac7)
                check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument end_time_offset", value=end_time_offset, expected_type=type_hints["end_time_offset"])
                check_type(argname="argument features_attribute", value=features_attribute, expected_type=type_hints["features_attribute"])
                check_type(argname="argument inference_attribute", value=inference_attribute, expected_type=type_hints["inference_attribute"])
                check_type(argname="argument probability_attribute", value=probability_attribute, expected_type=type_hints["probability_attribute"])
                check_type(argname="argument probability_threshold_attribute", value=probability_threshold_attribute, expected_type=type_hints["probability_threshold_attribute"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
                check_type(argname="argument start_time_offset", value=start_time_offset, expected_type=type_hints["start_time_offset"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "endpoint_name": endpoint_name,
                "local_path": local_path,
            }
            if end_time_offset is not None:
                self._values["end_time_offset"] = end_time_offset
            if features_attribute is not None:
                self._values["features_attribute"] = features_attribute
            if inference_attribute is not None:
                self._values["inference_attribute"] = inference_attribute
            if probability_attribute is not None:
                self._values["probability_attribute"] = probability_attribute
            if probability_threshold_attribute is not None:
                self._values["probability_threshold_attribute"] = probability_threshold_attribute
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode
            if start_time_offset is not None:
                self._values["start_time_offset"] = start_time_offset

        @builtins.property
        def endpoint_name(self) -> builtins.str:
            '''An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-endpointname
            '''
            result = self._values.get("endpoint_name")
            assert result is not None, "Required property 'endpoint_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''Path to the filesystem where the endpoint data is available to the container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def end_time_offset(self) -> typing.Optional[builtins.str]:
            '''If specified, monitoring jobs substract this time from the end time.

            For information about using offsets for scheduling monitoring jobs, see `Schedule Model Quality Monitoring Jobs <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-endtimeoffset
            '''
            result = self._values.get("end_time_offset")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def features_attribute(self) -> typing.Optional[builtins.str]:
            '''The attributes of the input data that are the input features.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-featuresattribute
            '''
            result = self._values.get("features_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def inference_attribute(self) -> typing.Optional[builtins.str]:
            '''The attribute of the input data that represents the ground truth label.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-inferenceattribute
            '''
            result = self._values.get("inference_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_attribute(self) -> typing.Optional[builtins.str]:
            '''In a classification problem, the attribute that represents the class probability.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-probabilityattribute
            '''
            result = self._values.get("probability_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_threshold_attribute(self) -> typing.Optional[jsii.Number]:
            '''The threshold for the class probability to be evaluated as a positive result.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-probabilitythresholdattribute
            '''
            result = self._values.get("probability_threshold_attribute")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.

            Defaults to ``FullyReplicated``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job.

            ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def start_time_offset(self) -> typing.Optional[builtins.str]:
            '''If specified, monitoring jobs substract this time from the start time.

            For information about using offsets for scheduling monitoring jobs, see `Schedule Model Quality Monitoring Jobs <https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-starttimeoffset
            '''
            result = self._values.get("start_time_offset")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EndpointInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.JsonProperty",
        jsii_struct_bases=[],
        name_mapping={"line": "line"},
    )
    class JsonProperty:
        def __init__(
            self,
            *,
            line: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param line: ``CfnModelBiasJobDefinition.JsonProperty.Line``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-json.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                json_property = sagemaker.CfnModelBiasJobDefinition.JsonProperty(
                    line=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2ef8a9cdeafa505161601a81b118c3a77872ed18ba908e4ddb6ace5645143980)
                check_type(argname="argument line", value=line, expected_type=type_hints["line"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if line is not None:
                self._values["line"] = line

        @builtins.property
        def line(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''``CfnModelBiasJobDefinition.JsonProperty.Line``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-json.html#cfn-sagemaker-modelbiasjobdefinition-json-line
            '''
            result = self._values.get("line")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "config_uri": "configUri",
            "image_uri": "imageUri",
            "environment": "environment",
        },
    )
    class ModelBiasAppSpecificationProperty:
        def __init__(
            self,
            *,
            config_uri: builtins.str,
            image_uri: builtins.str,
            environment: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        ) -> None:
            '''Docker container image configuration object for the model bias job.

            :param config_uri: JSON formatted S3 file that defines bias parameters. For more information on this JSON configuration file, see `Configure bias parameters <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-bias-parameters.html>`_ .
            :param image_uri: The container image to be run by the model bias job.
            :param environment: Sets the environment variables in the Docker container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                model_bias_app_specification_property = sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty(
                    config_uri="configUri",
                    image_uri="imageUri",
                
                    # the properties below are optional
                    environment={
                        "environment_key": "environment"
                    }
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7dc7ea9bddc69aa2a775297c6e13c1c39414ca7748d6b55397fb4de201cc1770)
                check_type(argname="argument config_uri", value=config_uri, expected_type=type_hints["config_uri"])
                check_type(argname="argument image_uri", value=image_uri, expected_type=type_hints["image_uri"])
                check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "config_uri": config_uri,
                "image_uri": image_uri,
            }
            if environment is not None:
                self._values["environment"] = environment

        @builtins.property
        def config_uri(self) -> builtins.str:
            '''JSON formatted S3 file that defines bias parameters.

            For more information on this JSON configuration file, see `Configure bias parameters <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-bias-parameters.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-configuri
            '''
            result = self._values.get("config_uri")
            assert result is not None, "Required property 'config_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def image_uri(self) -> builtins.str:
            '''The container image to be run by the model bias job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-imageuri
            '''
            result = self._values.get("image_uri")
            assert result is not None, "Required property 'image_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def environment(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            '''Sets the environment variables in the Docker container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-environment
            '''
            result = self._values.get("environment")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ModelBiasAppSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "baselining_job_name": "baseliningJobName",
            "constraints_resource": "constraintsResource",
        },
    )
    class ModelBiasBaselineConfigProperty:
        def __init__(
            self,
            *,
            baselining_job_name: typing.Optional[builtins.str] = None,
            constraints_resource: typing.Optional[typing.Union[typing.Union["CfnModelBiasJobDefinition.ConstraintsResourceProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''The configuration for a baseline model bias job.

            :param baselining_job_name: The name of the baseline model bias job.
            :param constraints_resource: The constraints resource for a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                model_bias_baseline_config_property = sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7d815ae69b0d71cb6ba7ca03623c8d0881a2e6e45c080208c864892a822bfa7f)
                check_type(argname="argument baselining_job_name", value=baselining_job_name, expected_type=type_hints["baselining_job_name"])
                check_type(argname="argument constraints_resource", value=constraints_resource, expected_type=type_hints["constraints_resource"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if baselining_job_name is not None:
                self._values["baselining_job_name"] = baselining_job_name
            if constraints_resource is not None:
                self._values["constraints_resource"] = constraints_resource

        @builtins.property
        def baselining_job_name(self) -> typing.Optional[builtins.str]:
            '''The name of the baseline model bias job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig-baseliningjobname
            '''
            result = self._values.get("baselining_job_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def constraints_resource(
            self,
        ) -> typing.Optional[typing.Union["CfnModelBiasJobDefinition.ConstraintsResourceProperty", _IResolvable_a771d0ef]]:
            '''The constraints resource for a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig-constraintsresource
            '''
            result = self._values.get("constraints_resource")
            return typing.cast(typing.Optional[typing.Union["CfnModelBiasJobDefinition.ConstraintsResourceProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ModelBiasBaselineConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "ground_truth_s3_input": "groundTruthS3Input",
            "batch_transform_input": "batchTransformInput",
            "endpoint_input": "endpointInput",
        },
    )
    class ModelBiasJobInputProperty:
        def __init__(
            self,
            *,
            ground_truth_s3_input: typing.Union[typing.Union["CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            batch_transform_input: typing.Optional[typing.Union[typing.Union["CfnModelBiasJobDefinition.BatchTransformInputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            endpoint_input: typing.Optional[typing.Union[typing.Union["CfnModelBiasJobDefinition.EndpointInputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Inputs for the model bias job.

            :param ground_truth_s3_input: Location of ground truth labels to use in model bias job.
            :param batch_transform_input: ``CfnModelBiasJobDefinition.ModelBiasJobInputProperty.BatchTransformInput``.
            :param endpoint_input: Input object for the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                # json: Any
                
                model_bias_job_input_property = sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty(
                    ground_truth_s3_input=sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty(
                        s3_uri="s3Uri"
                    ),
                
                    # the properties below are optional
                    batch_transform_input=sagemaker.CfnModelBiasJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=json,
                            parquet=False
                        ),
                        local_path="localPath",
                
                        # the properties below are optional
                        end_time_offset="endTimeOffset",
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        probability_threshold_attribute=123,
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode",
                        start_time_offset="startTimeOffset"
                    ),
                    endpoint_input=sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
                
                        # the properties below are optional
                        end_time_offset="endTimeOffset",
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        probability_threshold_attribute=123,
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode",
                        start_time_offset="startTimeOffset"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__bc990ebbe2d3705a464dc41f2957c2de86026a9934b4f74a22e3f10956a8ffab)
                check_type(argname="argument ground_truth_s3_input", value=ground_truth_s3_input, expected_type=type_hints["ground_truth_s3_input"])
                check_type(argname="argument batch_transform_input", value=batch_transform_input, expected_type=type_hints["batch_transform_input"])
                check_type(argname="argument endpoint_input", value=endpoint_input, expected_type=type_hints["endpoint_input"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "ground_truth_s3_input": ground_truth_s3_input,
            }
            if batch_transform_input is not None:
                self._values["batch_transform_input"] = batch_transform_input
            if endpoint_input is not None:
                self._values["endpoint_input"] = endpoint_input

        @builtins.property
        def ground_truth_s3_input(
            self,
        ) -> typing.Union["CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty", _IResolvable_a771d0ef]:
            '''Location of ground truth labels to use in model bias job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput-groundtruths3input
            '''
            result = self._values.get("ground_truth_s3_input")
            assert result is not None, "Required property 'ground_truth_s3_input' is missing"
            return typing.cast(typing.Union["CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def batch_transform_input(
            self,
        ) -> typing.Optional[typing.Union["CfnModelBiasJobDefinition.BatchTransformInputProperty", _IResolvable_a771d0ef]]:
            '''``CfnModelBiasJobDefinition.ModelBiasJobInputProperty.BatchTransformInput``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput-batchtransforminput
            '''
            result = self._values.get("batch_transform_input")
            return typing.cast(typing.Optional[typing.Union["CfnModelBiasJobDefinition.BatchTransformInputProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def endpoint_input(
            self,
        ) -> typing.Optional[typing.Union["CfnModelBiasJobDefinition.EndpointInputProperty", _IResolvable_a771d0ef]]:
            '''Input object for the endpoint.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput-endpointinput
            '''
            result = self._values.get("endpoint_input")
            return typing.cast(typing.Optional[typing.Union["CfnModelBiasJobDefinition.EndpointInputProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ModelBiasJobInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri"},
    )
    class MonitoringGroundTruthS3InputProperty:
        def __init__(self, *, s3_uri: builtins.str) -> None:
            '''The ground truth labels for the dataset used for the monitoring job.

            :param s3_uri: The address of the Amazon S3 location of the ground truth labels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                monitoring_ground_truth_s3_input_property = sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty(
                    s3_uri="s3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2e07ffac4878925c5ba8e846f42e1b877a2616bc2681c277da988ca87261e37a)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_uri": s3_uri,
            }

        @builtins.property
        def s3_uri(self) -> builtins.str:
            '''The address of the Amazon S3 location of the ground truth labels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input.html#cfn-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input-s3uri
            '''
            result = self._values.get("s3_uri")
            assert result is not None, "Required property 's3_uri' is missing"
            return typing.cast(builtins.str, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringGroundTruthS3InputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "monitoring_outputs": "monitoringOutputs",
            "kms_key_id": "kmsKeyId",
        },
    )
    class MonitoringOutputConfigProperty:
        def __init__(
            self,
            *,
            monitoring_outputs: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnModelBiasJobDefinition.MonitoringOutputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The output configuration for monitoring jobs.

            :param monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                monitoring_output_config_property = sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnModelBiasJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
                
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__cc12a22af125757eec33bda01fe058e37d3aabb5f1bde07b2bd18c276f0ffee6)
                check_type(argname="argument monitoring_outputs", value=monitoring_outputs, expected_type=type_hints["monitoring_outputs"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "monitoring_outputs": monitoring_outputs,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def monitoring_outputs(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnModelBiasJobDefinition.MonitoringOutputProperty", _IResolvable_a771d0ef]]]:
            '''Monitoring outputs for monitoring jobs.

            This is where the output of the periodic monitoring jobs is uploaded.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutputconfig-monitoringoutputs
            '''
            result = self._values.get("monitoring_outputs")
            assert result is not None, "Required property 'monitoring_outputs' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnModelBiasJobDefinition.MonitoringOutputProperty", _IResolvable_a771d0ef]]], result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_output": "s3Output"},
    )
    class MonitoringOutputProperty:
        def __init__(
            self,
            *,
            s3_output: typing.Union[typing.Union["CfnModelBiasJobDefinition.S3OutputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        ) -> None:
            '''The output object for a monitoring job.

            :param s3_output: The Amazon S3 storage location where the results of a monitoring job are saved.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                monitoring_output_property = sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnModelBiasJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
                
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__37e95f6ca0b8bd9be043828cfa552bcc6c8e9d576c19d74802c9d38b545644f9)
                check_type(argname="argument s3_output", value=s3_output, expected_type=type_hints["s3_output"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_output": s3_output,
            }

        @builtins.property
        def s3_output(
            self,
        ) -> typing.Union["CfnModelBiasJobDefinition.S3OutputProperty", _IResolvable_a771d0ef]:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutput.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutput-s3output
            '''
            result = self._values.get("s3_output")
            assert result is not None, "Required property 's3_output' is missing"
            return typing.cast(typing.Union["CfnModelBiasJobDefinition.S3OutputProperty", _IResolvable_a771d0ef], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty",
        jsii_struct_bases=[],
        name_mapping={"cluster_config": "clusterConfig"},
    )
    class MonitoringResourcesProperty:
        def __init__(
            self,
            *,
            cluster_config: typing.Union[typing.Union["CfnModelBiasJobDefinition.ClusterConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        ) -> None:
            '''Identifies the resources to deploy for a monitoring job.

            :param cluster_config: The configuration for the cluster resources used to run the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringresources.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                monitoring_resources_property = sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
                
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2f67e4ede66f6c9e005e47e618c585818076999ac2d5e3ecd43872710b505dd6)
                check_type(argname="argument cluster_config", value=cluster_config, expected_type=type_hints["cluster_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "cluster_config": cluster_config,
            }

        @builtins.property
        def cluster_config(
            self,
        ) -> typing.Union["CfnModelBiasJobDefinition.ClusterConfigProperty", _IResolvable_a771d0ef]:
            '''The configuration for the cluster resources used to run the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringresources.html#cfn-sagemaker-modelbiasjobdefinition-monitoringresources-clusterconfig
            '''
            result = self._values.get("cluster_config")
            assert result is not None, "Required property 'cluster_config' is missing"
            return typing.cast(typing.Union["CfnModelBiasJobDefinition.ClusterConfigProperty", _IResolvable_a771d0ef], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringResourcesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_inter_container_traffic_encryption": "enableInterContainerTrafficEncryption",
            "enable_network_isolation": "enableNetworkIsolation",
            "vpc_config": "vpcConfig",
        },
    )
    class NetworkConfigProperty:
        def __init__(
            self,
            *,
            enable_inter_container_traffic_encryption: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            enable_network_isolation: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            vpc_config: typing.Optional[typing.Union[typing.Union["CfnModelBiasJobDefinition.VpcConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.

            :param enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
            :param enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
            :param vpc_config: Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                network_config_property = sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2bffe91e8fb5ae2f2c476ca37302c913c37c61976bb2ca5cf57bd01a554ad903)
                check_type(argname="argument enable_inter_container_traffic_encryption", value=enable_inter_container_traffic_encryption, expected_type=type_hints["enable_inter_container_traffic_encryption"])
                check_type(argname="argument enable_network_isolation", value=enable_network_isolation, expected_type=type_hints["enable_network_isolation"])
                check_type(argname="argument vpc_config", value=vpc_config, expected_type=type_hints["vpc_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if enable_inter_container_traffic_encryption is not None:
                self._values["enable_inter_container_traffic_encryption"] = enable_inter_container_traffic_encryption
            if enable_network_isolation is not None:
                self._values["enable_network_isolation"] = enable_network_isolation
            if vpc_config is not None:
                self._values["vpc_config"] = vpc_config

        @builtins.property
        def enable_inter_container_traffic_encryption(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''Whether to encrypt all communications between distributed processing jobs.

            Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-enableintercontainertrafficencryption
            '''
            result = self._values.get("enable_inter_container_traffic_encryption")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        @builtins.property
        def enable_network_isolation(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''Whether to allow inbound and outbound network calls to and from the containers used for the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-enablenetworkisolation
            '''
            result = self._values.get("enable_network_isolation")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        @builtins.property
        def vpc_config(
            self,
        ) -> typing.Optional[typing.Union["CfnModelBiasJobDefinition.VpcConfigProperty", _IResolvable_a771d0ef]]:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-vpcconfig
            '''
            result = self._values.get("vpc_config")
            return typing.cast(typing.Optional[typing.Union["CfnModelBiasJobDefinition.VpcConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NetworkConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.S3OutputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "local_path": "localPath",
            "s3_uri": "s3Uri",
            "s3_upload_mode": "s3UploadMode",
        },
    )
    class S3OutputProperty:
        def __init__(
            self,
            *,
            local_path: builtins.str,
            s3_uri: builtins.str,
            s3_upload_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :param local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. ``LocalPath`` is an absolute path for the output data.
            :param s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
            :param s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                s3_output_property = sagemaker.CfnModelBiasJobDefinition.S3OutputProperty(
                    local_path="localPath",
                    s3_uri="s3Uri",
                
                    # the properties below are optional
                    s3_upload_mode="s3UploadMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__81e80b7c92c0fcc09878b2bc647c055e83528fd7ce5844f325e68e994f67ccb6)
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
                check_type(argname="argument s3_upload_mode", value=s3_upload_mode, expected_type=type_hints["s3_upload_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "local_path": local_path,
                "s3_uri": s3_uri,
            }
            if s3_upload_mode is not None:
                self._values["s3_upload_mode"] = s3_upload_mode

        @builtins.property
        def local_path(self) -> builtins.str:
            '''The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            ``LocalPath`` is an absolute path for the output data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_uri(self) -> builtins.str:
            '''A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-s3uri
            '''
            result = self._values.get("s3_uri")
            assert result is not None, "Required property 's3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_upload_mode(self) -> typing.Optional[builtins.str]:
            '''Whether to upload the results of the monitoring job continuously or after the job completes.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-s3uploadmode
            '''
            result = self._values.get("s3_upload_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "S3OutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"max_runtime_in_seconds": "maxRuntimeInSeconds"},
    )
    class StoppingConditionProperty:
        def __init__(self, *, max_runtime_in_seconds: jsii.Number) -> None:
            '''Specifies a limit to how long a model training job or model compilation job can run.

            It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training or compilation job. Use this API to cap model training costs.

            To stop a training job, SageMaker sends the algorithm the ``SIGTERM`` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.

            The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with ``CreateModel`` .
            .. epigraph::

               The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.

            :param max_runtime_in_seconds: The maximum length of time, in seconds, that a training or compilation job can run before it is stopped. For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model. For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days. The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-stoppingcondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                stopping_condition_property = sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__0ef36d9b877f9d009809258cf09be1a2a8178fc4533b0e9c5760b009f6b5c9ec)
                check_type(argname="argument max_runtime_in_seconds", value=max_runtime_in_seconds, expected_type=type_hints["max_runtime_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "max_runtime_in_seconds": max_runtime_in_seconds,
            }

        @builtins.property
        def max_runtime_in_seconds(self) -> jsii.Number:
            '''The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.

            For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.

            For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.

            The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-stoppingcondition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition-maxruntimeinseconds
            '''
            result = self._values.get("max_runtime_in_seconds")
            assert result is not None, "Required property 'max_runtime_in_seconds' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StoppingConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"security_group_ids": "securityGroupIds", "subnets": "subnets"},
    )
    class VpcConfigProperty:
        def __init__(
            self,
            *,
            security_group_ids: typing.Sequence[builtins.str],
            subnets: typing.Sequence[builtins.str],
        ) -> None:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC. For more information, see `Protect Endpoints by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html>`_ and `Protect Training Jobs by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html>`_ .

            :param security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the ``Subnets`` field.
            :param subnets: The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                vpc_config_property = sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6955414bf931481831d20a8dd474bbdd93fc1d3cd808c0c4155b5a5a19d3d3fb)
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
                check_type(argname="argument subnets", value=subnets, expected_type=type_hints["subnets"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "security_group_ids": security_group_ids,
                "subnets": subnets,
            }

        @builtins.property
        def security_group_ids(self) -> typing.List[builtins.str]:
            '''The VPC security group IDs, in the form sg-xxxxxxxx.

            Specify the security groups for the VPC that is specified in the ``Subnets`` field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html#cfn-sagemaker-modelbiasjobdefinition-vpcconfig-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            assert result is not None, "Required property 'security_group_ids' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def subnets(self) -> typing.List[builtins.str]:
            '''The ID of the subnets in the VPC to which you want to connect your training job or model.

            For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html#cfn-sagemaker-modelbiasjobdefinition-vpcconfig-subnets
            '''
            result = self._values.get("subnets")
            assert result is not None, "Required property 'subnets' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VpcConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnModelBiasJobDefinitionProps",
    jsii_struct_bases=[],
    name_mapping={
        "job_resources": "jobResources",
        "model_bias_app_specification": "modelBiasAppSpecification",
        "model_bias_job_input": "modelBiasJobInput",
        "model_bias_job_output_config": "modelBiasJobOutputConfig",
        "role_arn": "roleArn",
        "endpoint_name": "endpointName",
        "job_definition_name": "jobDefinitionName",
        "model_bias_baseline_config": "modelBiasBaselineConfig",
        "network_config": "networkConfig",
        "stopping_condition": "stoppingCondition",
        "tags": "tags",
    },
)
class CfnModelBiasJobDefinitionProps:
    def __init__(
        self,
        *,
        job_resources: typing.Union[typing.Union[CfnModelBiasJobDefinition.MonitoringResourcesProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_bias_app_specification: typing.Union[typing.Union[CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_bias_job_input: typing.Union[typing.Union[CfnModelBiasJobDefinition.ModelBiasJobInputProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_bias_job_output_config: typing.Union[typing.Union[CfnModelBiasJobDefinition.MonitoringOutputConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        role_arn: builtins.str,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        model_bias_baseline_config: typing.Optional[typing.Union[typing.Union[CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        network_config: typing.Optional[typing.Union[typing.Union[CfnModelBiasJobDefinition.NetworkConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        stopping_condition: typing.Optional[typing.Union[typing.Union[CfnModelBiasJobDefinition.StoppingConditionProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnModelBiasJobDefinition``.

        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param model_bias_app_specification: Configures the model bias job to run a specified Docker container image.
        :param model_bias_job_input: Inputs for the model bias job.
        :param model_bias_job_output_config: The output configuration for monitoring jobs.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param endpoint_name: ``AWS::SageMaker::ModelBiasJobDefinition.EndpointName``.
        :param job_definition_name: The name of the bias job definition. The name must be unique within an AWS Region in the AWS account.
        :param model_bias_baseline_config: The baseline configuration for a model bias job.
        :param network_config: Networking options for a model bias job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            # json: Any
            
            cfn_model_bias_job_definition_props = sagemaker.CfnModelBiasJobDefinitionProps(
                job_resources=sagemaker.CfnModelBiasJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnModelBiasJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
            
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                ),
                model_bias_app_specification=sagemaker.CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty(
                    config_uri="configUri",
                    image_uri="imageUri",
            
                    # the properties below are optional
                    environment={
                        "environment_key": "environment"
                    }
                ),
                model_bias_job_input=sagemaker.CfnModelBiasJobDefinition.ModelBiasJobInputProperty(
                    ground_truth_s3_input=sagemaker.CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty(
                        s3_uri="s3Uri"
                    ),
            
                    # the properties below are optional
                    batch_transform_input=sagemaker.CfnModelBiasJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnModelBiasJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnModelBiasJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=json,
                            parquet=False
                        ),
                        local_path="localPath",
            
                        # the properties below are optional
                        end_time_offset="endTimeOffset",
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        probability_threshold_attribute=123,
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode",
                        start_time_offset="startTimeOffset"
                    ),
                    endpoint_input=sagemaker.CfnModelBiasJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
            
                        # the properties below are optional
                        end_time_offset="endTimeOffset",
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        probability_threshold_attribute=123,
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode",
                        start_time_offset="startTimeOffset"
                    )
                ),
                model_bias_job_output_config=sagemaker.CfnModelBiasJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnModelBiasJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnModelBiasJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
            
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
            
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                ),
                role_arn="roleArn",
            
                # the properties below are optional
                endpoint_name="endpointName",
                job_definition_name="jobDefinitionName",
                model_bias_baseline_config=sagemaker.CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnModelBiasJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    )
                ),
                network_config=sagemaker.CfnModelBiasJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnModelBiasJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                ),
                stopping_condition=sagemaker.CfnModelBiasJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d3e3de1206f441bb905ec4211858ede46304c9af3ef5824d63272a4066714961)
            check_type(argname="argument job_resources", value=job_resources, expected_type=type_hints["job_resources"])
            check_type(argname="argument model_bias_app_specification", value=model_bias_app_specification, expected_type=type_hints["model_bias_app_specification"])
            check_type(argname="argument model_bias_job_input", value=model_bias_job_input, expected_type=type_hints["model_bias_job_input"])
            check_type(argname="argument model_bias_job_output_config", value=model_bias_job_output_config, expected_type=type_hints["model_bias_job_output_config"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
            check_type(argname="argument job_definition_name", value=job_definition_name, expected_type=type_hints["job_definition_name"])
            check_type(argname="argument model_bias_baseline_config", value=model_bias_baseline_config, expected_type=type_hints["model_bias_baseline_config"])
            check_type(argname="argument network_config", value=network_config, expected_type=type_hints["network_config"])
            check_type(argname="argument stopping_condition", value=stopping_condition, expected_type=type_hints["stopping_condition"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "job_resources": job_resources,
            "model_bias_app_specification": model_bias_app_specification,
            "model_bias_job_input": model_bias_job_input,
            "model_bias_job_output_config": model_bias_job_output_config,
            "role_arn": role_arn,
        }
        if endpoint_name is not None:
            self._values["endpoint_name"] = endpoint_name
        if job_definition_name is not None:
            self._values["job_definition_name"] = job_definition_name
        if model_bias_baseline_config is not None:
            self._values["model_bias_baseline_config"] = model_bias_baseline_config
        if network_config is not None:
            self._values["network_config"] = network_config
        if stopping_condition is not None:
            self._values["stopping_condition"] = stopping_condition
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def job_resources(
        self,
    ) -> typing.Union[CfnModelBiasJobDefinition.MonitoringResourcesProperty, _IResolvable_a771d0ef]:
        '''Identifies the resources to deploy for a monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobresources
        '''
        result = self._values.get("job_resources")
        assert result is not None, "Required property 'job_resources' is missing"
        return typing.cast(typing.Union[CfnModelBiasJobDefinition.MonitoringResourcesProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def model_bias_app_specification(
        self,
    ) -> typing.Union[CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty, _IResolvable_a771d0ef]:
        '''Configures the model bias job to run a specified Docker container image.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification
        '''
        result = self._values.get("model_bias_app_specification")
        assert result is not None, "Required property 'model_bias_app_specification' is missing"
        return typing.cast(typing.Union[CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def model_bias_job_input(
        self,
    ) -> typing.Union[CfnModelBiasJobDefinition.ModelBiasJobInputProperty, _IResolvable_a771d0ef]:
        '''Inputs for the model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput
        '''
        result = self._values.get("model_bias_job_input")
        assert result is not None, "Required property 'model_bias_job_input' is missing"
        return typing.cast(typing.Union[CfnModelBiasJobDefinition.ModelBiasJobInputProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def model_bias_job_output_config(
        self,
    ) -> typing.Union[CfnModelBiasJobDefinition.MonitoringOutputConfigProperty, _IResolvable_a771d0ef]:
        '''The output configuration for monitoring jobs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjoboutputconfig
        '''
        result = self._values.get("model_bias_job_output_config")
        assert result is not None, "Required property 'model_bias_job_output_config' is missing"
        return typing.cast(typing.Union[CfnModelBiasJobDefinition.MonitoringOutputConfigProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-rolearn
        '''
        result = self._values.get("role_arn")
        assert result is not None, "Required property 'role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''``AWS::SageMaker::ModelBiasJobDefinition.EndpointName``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-endpointname
        '''
        result = self._values.get("endpoint_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name of the bias job definition.

        The name must be unique within an AWS Region in the AWS account.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobdefinitionname
        '''
        result = self._values.get("job_definition_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def model_bias_baseline_config(
        self,
    ) -> typing.Optional[typing.Union[CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty, _IResolvable_a771d0ef]]:
        '''The baseline configuration for a model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig
        '''
        result = self._values.get("model_bias_baseline_config")
        return typing.cast(typing.Optional[typing.Union[CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def network_config(
        self,
    ) -> typing.Optional[typing.Union[CfnModelBiasJobDefinition.NetworkConfigProperty, _IResolvable_a771d0ef]]:
        '''Networking options for a model bias job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig
        '''
        result = self._values.get("network_config")
        return typing.cast(typing.Optional[typing.Union[CfnModelBiasJobDefinition.NetworkConfigProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union[CfnModelBiasJobDefinition.StoppingConditionProperty, _IResolvable_a771d0ef]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition
        '''
        result = self._values.get("stopping_condition")
        return typing.cast(typing.Optional[typing.Union[CfnModelBiasJobDefinition.StoppingConditionProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnModelBiasJobDefinitionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnModelExplainabilityJobDefinition(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition",
):
    '''A CloudFormation ``AWS::SageMaker::ModelExplainabilityJobDefinition``.

    Creates the definition for a model explainability job.

    :cloudformationResource: AWS::SageMaker::ModelExplainabilityJobDefinition
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        # json: Any
        
        cfn_model_explainability_job_definition = sagemaker.CfnModelExplainabilityJobDefinition(self, "MyCfnModelExplainabilityJobDefinition",
            job_resources=sagemaker.CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty(
                cluster_config=sagemaker.CfnModelExplainabilityJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
        
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            ),
            model_explainability_app_specification=sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty(
                config_uri="configUri",
                image_uri="imageUri",
        
                # the properties below are optional
                environment={
                    "environment_key": "environment"
                }
            ),
            model_explainability_job_input=sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty(
                batch_transform_input=sagemaker.CfnModelExplainabilityJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnModelExplainabilityJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnModelExplainabilityJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=json,
                        parquet=False
                    ),
                    local_path="localPath",
        
                    # the properties below are optional
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                ),
                endpoint_input=sagemaker.CfnModelExplainabilityJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
        
                    # the properties below are optional
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            ),
            model_explainability_job_output_config=sagemaker.CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty(
                monitoring_outputs=[sagemaker.CfnModelExplainabilityJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnModelExplainabilityJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )],
        
                # the properties below are optional
                kms_key_id="kmsKeyId"
            ),
            role_arn="roleArn",
        
            # the properties below are optional
            endpoint_name="endpointName",
            job_definition_name="jobDefinitionName",
            model_explainability_baseline_config=sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty(
                baselining_job_name="baseliningJobName",
                constraints_resource=sagemaker.CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                )
            ),
            network_config=sagemaker.CfnModelExplainabilityJobDefinition.NetworkConfigProperty(
                enable_inter_container_traffic_encryption=False,
                enable_network_isolation=False,
                vpc_config=sagemaker.CfnModelExplainabilityJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            ),
            stopping_condition=sagemaker.CfnModelExplainabilityJobDefinition.StoppingConditionProperty(
                max_runtime_in_seconds=123
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )]
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        job_resources: typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_explainability_app_specification: typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_explainability_job_input: typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_explainability_job_output_config: typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        role_arn: builtins.str,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        model_explainability_baseline_config: typing.Optional[typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        network_config: typing.Optional[typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.NetworkConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        stopping_condition: typing.Optional[typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.StoppingConditionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::ModelExplainabilityJobDefinition``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param model_explainability_app_specification: Configures the model explainability job to run a specified Docker container image.
        :param model_explainability_job_input: Inputs for the model explainability job.
        :param model_explainability_job_output_config: The output configuration for monitoring jobs.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param endpoint_name: ``AWS::SageMaker::ModelExplainabilityJobDefinition.EndpointName``.
        :param job_definition_name: The name of the model explainability job definition. The name must be unique within an AWS Region in the AWS account.
        :param model_explainability_baseline_config: The baseline configuration for a model explainability job.
        :param network_config: Networking options for a model explainability job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74c7dbe6c391857331381b280dfa14490d49908c4e1ddbf36b3cd66ddc972014)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CfnModelExplainabilityJobDefinitionProps(
            job_resources=job_resources,
            model_explainability_app_specification=model_explainability_app_specification,
            model_explainability_job_input=model_explainability_job_input,
            model_explainability_job_output_config=model_explainability_job_output_config,
            role_arn=role_arn,
            endpoint_name=endpoint_name,
            job_definition_name=job_definition_name,
            model_explainability_baseline_config=model_explainability_baseline_config,
            network_config=network_config,
            stopping_condition=stopping_condition,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: _TreeInspector_1cd1894e) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b8ea3b2b9264d7a3b6155388239f4d2c4980d2953956f06c49b56b28806b013e)
            check_type(argname="argument inspector", value=inspector, expected_type=type_hints["inspector"])
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aa345d5dea708900f42ec681ed0176d56428f725eab76b664e87eb96adf99c01)
            check_type(argname="argument props", value=props, expected_type=type_hints["props"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property
    @jsii.member(jsii_name="attrCreationTime")
    def attr_creation_time(self) -> builtins.str:
        '''The time when the job definition was created.

        :cloudformationAttribute: CreationTime
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrCreationTime"))

    @builtins.property
    @jsii.member(jsii_name="attrJobDefinitionArn")
    def attr_job_definition_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of the job definition.

        :cloudformationAttribute: JobDefinitionArn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrJobDefinitionArn"))

    @builtins.property
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> _TagManager_0b7ab120:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-tags
        '''
        return typing.cast(_TagManager_0b7ab120, jsii.get(self, "tags"))

    @builtins.property
    @jsii.member(jsii_name="jobResources")
    def job_resources(
        self,
    ) -> typing.Union["CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty", _IResolvable_a771d0ef]:
        '''Identifies the resources to deploy for a monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobresources
        '''
        return typing.cast(typing.Union["CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty", _IResolvable_a771d0ef], jsii.get(self, "jobResources"))

    @job_resources.setter
    def job_resources(
        self,
        value: typing.Union["CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1f49d85950dbb850f4f10b1596eea823aeb99c8c15437750e2dd5a2af2c0f050)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobResources", value)

    @builtins.property
    @jsii.member(jsii_name="modelExplainabilityAppSpecification")
    def model_explainability_app_specification(
        self,
    ) -> typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty", _IResolvable_a771d0ef]:
        '''Configures the model explainability job to run a specified Docker container image.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification
        '''
        return typing.cast(typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty", _IResolvable_a771d0ef], jsii.get(self, "modelExplainabilityAppSpecification"))

    @model_explainability_app_specification.setter
    def model_explainability_app_specification(
        self,
        value: typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bca2dcb66d811697138cbdf0421da93aef4d9f69c5e13a593654a0278828c4b6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelExplainabilityAppSpecification", value)

    @builtins.property
    @jsii.member(jsii_name="modelExplainabilityJobInput")
    def model_explainability_job_input(
        self,
    ) -> typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty", _IResolvable_a771d0ef]:
        '''Inputs for the model explainability job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput
        '''
        return typing.cast(typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty", _IResolvable_a771d0ef], jsii.get(self, "modelExplainabilityJobInput"))

    @model_explainability_job_input.setter
    def model_explainability_job_input(
        self,
        value: typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66ba32a670ab7461f4f9f86c8d5c6ea3953d09fa6b249bcf2677a67f6c5b6dc7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelExplainabilityJobInput", value)

    @builtins.property
    @jsii.member(jsii_name="modelExplainabilityJobOutputConfig")
    def model_explainability_job_output_config(
        self,
    ) -> typing.Union["CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty", _IResolvable_a771d0ef]:
        '''The output configuration for monitoring jobs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjoboutputconfig
        '''
        return typing.cast(typing.Union["CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty", _IResolvable_a771d0ef], jsii.get(self, "modelExplainabilityJobOutputConfig"))

    @model_explainability_job_output_config.setter
    def model_explainability_job_output_config(
        self,
        value: typing.Union["CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty", _IResolvable_a771d0ef],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3461c79ac5aeea2bc6032e3447afbd94fa5fb01fb0cb7223a6d5e8c5dd4efc19)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelExplainabilityJobOutputConfig", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-rolearn
        '''
        return typing.cast(builtins.str, jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df3cee22c246ee18b2ea063bca2f6362fcff1bd59df86b99b8f51be390de6e63)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleArn", value)

    @builtins.property
    @jsii.member(jsii_name="endpointName")
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''``AWS::SageMaker::ModelExplainabilityJobDefinition.EndpointName``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "endpointName"))

    @endpoint_name.setter
    def endpoint_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea24e3b87f55afc656689826d2d28ad77f07f1885a4d2c2e0894db1f36898966)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "endpointName", value)

    @builtins.property
    @jsii.member(jsii_name="jobDefinitionName")
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name of the model explainability job definition.

        The name must be unique within an AWS Region in the AWS account.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobdefinitionname
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "jobDefinitionName"))

    @job_definition_name.setter
    def job_definition_name(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__363f64088ad35eb9e8f2809a96b25fe6a49607b15d5426ab58a17a8383f569f3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "jobDefinitionName", value)

    @builtins.property
    @jsii.member(jsii_name="modelExplainabilityBaselineConfig")
    def model_explainability_baseline_config(
        self,
    ) -> typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty", _IResolvable_a771d0ef]]:
        '''The baseline configuration for a model explainability job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "modelExplainabilityBaselineConfig"))

    @model_explainability_baseline_config.setter
    def model_explainability_baseline_config(
        self,
        value: typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3dae1394496031d7ee5611d25d64da9f25427c280b0be2d38b86372c22a14688)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "modelExplainabilityBaselineConfig", value)

    @builtins.property
    @jsii.member(jsii_name="networkConfig")
    def network_config(
        self,
    ) -> typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.NetworkConfigProperty", _IResolvable_a771d0ef]]:
        '''Networking options for a model explainability job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig
        '''
        return typing.cast(typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.NetworkConfigProperty", _IResolvable_a771d0ef]], jsii.get(self, "networkConfig"))

    @network_config.setter
    def network_config(
        self,
        value: typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.NetworkConfigProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6b3d6ec22f60c5f212ca6fc1f4519f4a276cfec850cef1d609c2f90b7b0e9342)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "networkConfig", value)

    @builtins.property
    @jsii.member(jsii_name="stoppingCondition")
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.StoppingConditionProperty", _IResolvable_a771d0ef]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-stoppingcondition
        '''
        return typing.cast(typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.StoppingConditionProperty", _IResolvable_a771d0ef]], jsii.get(self, "stoppingCondition"))

    @stopping_condition.setter
    def stopping_condition(
        self,
        value: typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.StoppingConditionProperty", _IResolvable_a771d0ef]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__be2fc0486e916eebddf08d2cbb6bbd19468d98ad9bd22954c1541beba30a7958)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "stoppingCondition", value)

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.BatchTransformInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "data_captured_destination_s3_uri": "dataCapturedDestinationS3Uri",
            "dataset_format": "datasetFormat",
            "local_path": "localPath",
            "features_attribute": "featuresAttribute",
            "inference_attribute": "inferenceAttribute",
            "probability_attribute": "probabilityAttribute",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
        },
    )
    class BatchTransformInputProperty:
        def __init__(
            self,
            *,
            data_captured_destination_s3_uri: builtins.str,
            dataset_format: typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.DatasetFormatProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
            local_path: builtins.str,
            features_attribute: typing.Optional[builtins.str] = None,
            inference_attribute: typing.Optional[builtins.str] = None,
            probability_attribute: typing.Optional[builtins.str] = None,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''
            :param data_captured_destination_s3_uri: ``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.DataCapturedDestinationS3Uri``.
            :param dataset_format: ``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.DatasetFormat``.
            :param local_path: ``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.LocalPath``.
            :param features_attribute: ``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.FeaturesAttribute``.
            :param inference_attribute: ``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.InferenceAttribute``.
            :param probability_attribute: ``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.ProbabilityAttribute``.
            :param s3_data_distribution_type: ``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.S3DataDistributionType``.
            :param s3_input_mode: ``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.S3InputMode``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-batchtransforminput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                # json: Any
                
                batch_transform_input_property = sagemaker.CfnModelExplainabilityJobDefinition.BatchTransformInputProperty(
                    data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                    dataset_format=sagemaker.CfnModelExplainabilityJobDefinition.DatasetFormatProperty(
                        csv=sagemaker.CfnModelExplainabilityJobDefinition.CsvProperty(
                            header=False
                        ),
                        json=json,
                        parquet=False
                    ),
                    local_path="localPath",
                
                    # the properties below are optional
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__7f83d74caa93ffd4f7709e06c35853b7277ab5d9f5d46a2fe99a773cd55e6e65)
                check_type(argname="argument data_captured_destination_s3_uri", value=data_captured_destination_s3_uri, expected_type=type_hints["data_captured_destination_s3_uri"])
                check_type(argname="argument dataset_format", value=dataset_format, expected_type=type_hints["dataset_format"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument features_attribute", value=features_attribute, expected_type=type_hints["features_attribute"])
                check_type(argname="argument inference_attribute", value=inference_attribute, expected_type=type_hints["inference_attribute"])
                check_type(argname="argument probability_attribute", value=probability_attribute, expected_type=type_hints["probability_attribute"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "data_captured_destination_s3_uri": data_captured_destination_s3_uri,
                "dataset_format": dataset_format,
                "local_path": local_path,
            }
            if features_attribute is not None:
                self._values["features_attribute"] = features_attribute
            if inference_attribute is not None:
                self._values["inference_attribute"] = inference_attribute
            if probability_attribute is not None:
                self._values["probability_attribute"] = probability_attribute
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode

        @builtins.property
        def data_captured_destination_s3_uri(self) -> builtins.str:
            '''``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.DataCapturedDestinationS3Uri``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelexplainabilityjobdefinition-batchtransforminput-datacaptureddestinations3uri
            '''
            result = self._values.get("data_captured_destination_s3_uri")
            assert result is not None, "Required property 'data_captured_destination_s3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def dataset_format(
            self,
        ) -> typing.Union["CfnModelExplainabilityJobDefinition.DatasetFormatProperty", _IResolvable_a771d0ef]:
            '''``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.DatasetFormat``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelexplainabilityjobdefinition-batchtransforminput-datasetformat
            '''
            result = self._values.get("dataset_format")
            assert result is not None, "Required property 'dataset_format' is missing"
            return typing.cast(typing.Union["CfnModelExplainabilityJobDefinition.DatasetFormatProperty", _IResolvable_a771d0ef], result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.LocalPath``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelexplainabilityjobdefinition-batchtransforminput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def features_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.FeaturesAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelexplainabilityjobdefinition-batchtransforminput-featuresattribute
            '''
            result = self._values.get("features_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def inference_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.InferenceAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelexplainabilityjobdefinition-batchtransforminput-inferenceattribute
            '''
            result = self._values.get("inference_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_attribute(self) -> typing.Optional[builtins.str]:
            '''``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.ProbabilityAttribute``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelexplainabilityjobdefinition-batchtransforminput-probabilityattribute
            '''
            result = self._values.get("probability_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.S3DataDistributionType``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelexplainabilityjobdefinition-batchtransforminput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''``CfnModelExplainabilityJobDefinition.BatchTransformInputProperty.S3InputMode``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-batchtransforminput.html#cfn-sagemaker-modelexplainabilityjobdefinition-batchtransforminput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BatchTransformInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.ClusterConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "instance_count": "instanceCount",
            "instance_type": "instanceType",
            "volume_size_in_gb": "volumeSizeInGb",
            "volume_kms_key_id": "volumeKmsKeyId",
        },
    )
    class ClusterConfigProperty:
        def __init__(
            self,
            *,
            instance_count: jsii.Number,
            instance_type: builtins.str,
            volume_size_in_gb: jsii.Number,
            volume_kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration for the cluster resources used to run the processing job.

            :param instance_count: The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
            :param instance_type: The ML compute instance type for the processing job.
            :param volume_size_in_gb: The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
            :param volume_kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                cluster_config_property = sagemaker.CfnModelExplainabilityJobDefinition.ClusterConfigProperty(
                    instance_count=123,
                    instance_type="instanceType",
                    volume_size_in_gb=123,
                
                    # the properties below are optional
                    volume_kms_key_id="volumeKmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__f96e8c35d89868f551245c23445a3c271c41b9380be411616c29bc55ef60b42c)
                check_type(argname="argument instance_count", value=instance_count, expected_type=type_hints["instance_count"])
                check_type(argname="argument instance_type", value=instance_type, expected_type=type_hints["instance_type"])
                check_type(argname="argument volume_size_in_gb", value=volume_size_in_gb, expected_type=type_hints["volume_size_in_gb"])
                check_type(argname="argument volume_kms_key_id", value=volume_kms_key_id, expected_type=type_hints["volume_kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "instance_count": instance_count,
                "instance_type": instance_type,
                "volume_size_in_gb": volume_size_in_gb,
            }
            if volume_kms_key_id is not None:
                self._values["volume_kms_key_id"] = volume_kms_key_id

        @builtins.property
        def instance_count(self) -> jsii.Number:
            '''The number of ML compute instances to use in the model monitoring job.

            For distributed processing jobs, specify a value greater than 1. The default value is 1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-instancecount
            '''
            result = self._values.get("instance_count")
            assert result is not None, "Required property 'instance_count' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def instance_type(self) -> builtins.str:
            '''The ML compute instance type for the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-instancetype
            '''
            result = self._values.get("instance_type")
            assert result is not None, "Required property 'instance_type' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def volume_size_in_gb(self) -> jsii.Number:
            '''The size of the ML storage volume, in gigabytes, that you want to provision.

            You must specify sufficient ML storage for your scenario.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-volumesizeingb
            '''
            result = self._values.get("volume_size_in_gb")
            assert result is not None, "Required property 'volume_size_in_gb' is missing"
            return typing.cast(jsii.Number, result)

        @builtins.property
        def volume_kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-volumekmskeyid
            '''
            result = self._values.get("volume_kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ClusterConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_uri": "s3Uri"},
    )
    class ConstraintsResourceProperty:
        def __init__(self, *, s3_uri: typing.Optional[builtins.str] = None) -> None:
            '''Input object for the endpoint.

            :param s3_uri: The Amazon S3 URI for the constraints resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-constraintsresource.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                constraints_resource_property = sagemaker.CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty(
                    s3_uri="s3Uri"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2f35ad7615b2153db423ce14406009bd64e2d9b6623402f6650b97eb24c1615c)
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if s3_uri is not None:
                self._values["s3_uri"] = s3_uri

        @builtins.property
        def s3_uri(self) -> typing.Optional[builtins.str]:
            '''The Amazon S3 URI for the constraints resource.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-constraintsresource.html#cfn-sagemaker-modelexplainabilityjobdefinition-constraintsresource-s3uri
            '''
            result = self._values.get("s3_uri")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ConstraintsResourceProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.CsvProperty",
        jsii_struct_bases=[],
        name_mapping={"header": "header"},
    )
    class CsvProperty:
        def __init__(
            self,
            *,
            header: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param header: ``CfnModelExplainabilityJobDefinition.CsvProperty.Header``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-csv.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                csv_property = sagemaker.CfnModelExplainabilityJobDefinition.CsvProperty(
                    header=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a165588e144a7c6c97160b3c102c06793ec4c7e29c0759f65b046f03c5fe1a47)
                check_type(argname="argument header", value=header, expected_type=type_hints["header"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if header is not None:
                self._values["header"] = header

        @builtins.property
        def header(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''``CfnModelExplainabilityJobDefinition.CsvProperty.Header``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-csv.html#cfn-sagemaker-modelexplainabilityjobdefinition-csv-header
            '''
            result = self._values.get("header")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CsvProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.DatasetFormatProperty",
        jsii_struct_bases=[],
        name_mapping={"csv": "csv", "json": "json", "parquet": "parquet"},
    )
    class DatasetFormatProperty:
        def __init__(
            self,
            *,
            csv: typing.Optional[typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.CsvProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            json: typing.Any = None,
            parquet: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param csv: ``CfnModelExplainabilityJobDefinition.DatasetFormatProperty.Csv``.
            :param json: ``CfnModelExplainabilityJobDefinition.DatasetFormatProperty.Json``.
            :param parquet: ``CfnModelExplainabilityJobDefinition.DatasetFormatProperty.Parquet``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-datasetformat.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                # json: Any
                
                dataset_format_property = sagemaker.CfnModelExplainabilityJobDefinition.DatasetFormatProperty(
                    csv=sagemaker.CfnModelExplainabilityJobDefinition.CsvProperty(
                        header=False
                    ),
                    json=json,
                    parquet=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__feae26977fe5b76bcddbf46b12dda4e65c3121532a910d8ae7ac0d3644977264)
                check_type(argname="argument csv", value=csv, expected_type=type_hints["csv"])
                check_type(argname="argument json", value=json, expected_type=type_hints["json"])
                check_type(argname="argument parquet", value=parquet, expected_type=type_hints["parquet"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if csv is not None:
                self._values["csv"] = csv
            if json is not None:
                self._values["json"] = json
            if parquet is not None:
                self._values["parquet"] = parquet

        @builtins.property
        def csv(
            self,
        ) -> typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.CsvProperty", _IResolvable_a771d0ef]]:
            '''``CfnModelExplainabilityJobDefinition.DatasetFormatProperty.Csv``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-datasetformat.html#cfn-sagemaker-modelexplainabilityjobdefinition-datasetformat-csv
            '''
            result = self._values.get("csv")
            return typing.cast(typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.CsvProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def json(self) -> typing.Any:
            '''``CfnModelExplainabilityJobDefinition.DatasetFormatProperty.Json``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-datasetformat.html#cfn-sagemaker-modelexplainabilityjobdefinition-datasetformat-json
            '''
            result = self._values.get("json")
            return typing.cast(typing.Any, result)

        @builtins.property
        def parquet(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''``CfnModelExplainabilityJobDefinition.DatasetFormatProperty.Parquet``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-datasetformat.html#cfn-sagemaker-modelexplainabilityjobdefinition-datasetformat-parquet
            '''
            result = self._values.get("parquet")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DatasetFormatProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.EndpointInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "endpoint_name": "endpointName",
            "local_path": "localPath",
            "features_attribute": "featuresAttribute",
            "inference_attribute": "inferenceAttribute",
            "probability_attribute": "probabilityAttribute",
            "s3_data_distribution_type": "s3DataDistributionType",
            "s3_input_mode": "s3InputMode",
        },
    )
    class EndpointInputProperty:
        def __init__(
            self,
            *,
            endpoint_name: builtins.str,
            local_path: builtins.str,
            features_attribute: typing.Optional[builtins.str] = None,
            inference_attribute: typing.Optional[builtins.str] = None,
            probability_attribute: typing.Optional[builtins.str] = None,
            s3_data_distribution_type: typing.Optional[builtins.str] = None,
            s3_input_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Input object for the endpoint.

            :param endpoint_name: An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.
            :param local_path: Path to the filesystem where the endpoint data is available to the container.
            :param features_attribute: The attributes of the input data that are the input features.
            :param inference_attribute: The attribute of the input data that represents the ground truth label.
            :param probability_attribute: In a classification problem, the attribute that represents the class probability.
            :param s3_data_distribution_type: Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to ``FullyReplicated``
            :param s3_input_mode: Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job. ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                endpoint_input_property = sagemaker.CfnModelExplainabilityJobDefinition.EndpointInputProperty(
                    endpoint_name="endpointName",
                    local_path="localPath",
                
                    # the properties below are optional
                    features_attribute="featuresAttribute",
                    inference_attribute="inferenceAttribute",
                    probability_attribute="probabilityAttribute",
                    s3_data_distribution_type="s3DataDistributionType",
                    s3_input_mode="s3InputMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__6eb8179d6d6dab6530730a41fec20b291eb5245175e283b0fca926dca6bb42fc)
                check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument features_attribute", value=features_attribute, expected_type=type_hints["features_attribute"])
                check_type(argname="argument inference_attribute", value=inference_attribute, expected_type=type_hints["inference_attribute"])
                check_type(argname="argument probability_attribute", value=probability_attribute, expected_type=type_hints["probability_attribute"])
                check_type(argname="argument s3_data_distribution_type", value=s3_data_distribution_type, expected_type=type_hints["s3_data_distribution_type"])
                check_type(argname="argument s3_input_mode", value=s3_input_mode, expected_type=type_hints["s3_input_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "endpoint_name": endpoint_name,
                "local_path": local_path,
            }
            if features_attribute is not None:
                self._values["features_attribute"] = features_attribute
            if inference_attribute is not None:
                self._values["inference_attribute"] = inference_attribute
            if probability_attribute is not None:
                self._values["probability_attribute"] = probability_attribute
            if s3_data_distribution_type is not None:
                self._values["s3_data_distribution_type"] = s3_data_distribution_type
            if s3_input_mode is not None:
                self._values["s3_input_mode"] = s3_input_mode

        @builtins.property
        def endpoint_name(self) -> builtins.str:
            '''An endpoint in customer's account which has enabled ``DataCaptureConfig`` enabled.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-endpointname
            '''
            result = self._values.get("endpoint_name")
            assert result is not None, "Required property 'endpoint_name' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def local_path(self) -> builtins.str:
            '''Path to the filesystem where the endpoint data is available to the container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def features_attribute(self) -> typing.Optional[builtins.str]:
            '''The attributes of the input data that are the input features.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-featuresattribute
            '''
            result = self._values.get("features_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def inference_attribute(self) -> typing.Optional[builtins.str]:
            '''The attribute of the input data that represents the ground truth label.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-inferenceattribute
            '''
            result = self._values.get("inference_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def probability_attribute(self) -> typing.Optional[builtins.str]:
            '''In a classification problem, the attribute that represents the class probability.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-probabilityattribute
            '''
            result = self._values.get("probability_attribute")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_data_distribution_type(self) -> typing.Optional[builtins.str]:
            '''Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.

            Defaults to ``FullyReplicated``

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-s3datadistributiontype
            '''
            result = self._values.get("s3_data_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def s3_input_mode(self) -> typing.Optional[builtins.str]:
            '''Whether the ``Pipe`` or ``File`` is used as the input mode for transferring data for the monitoring job.

            ``Pipe`` mode is recommended for large datasets. ``File`` mode is useful for small files that fit in memory. Defaults to ``File`` .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-s3inputmode
            '''
            result = self._values.get("s3_input_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EndpointInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.JsonProperty",
        jsii_struct_bases=[],
        name_mapping={"line": "line"},
    )
    class JsonProperty:
        def __init__(
            self,
            *,
            line: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''
            :param line: ``CfnModelExplainabilityJobDefinition.JsonProperty.Line``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-json.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                json_property = sagemaker.CfnModelExplainabilityJobDefinition.JsonProperty(
                    line=False
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2ddf599b7eb41a65c9d49ccffc895c47ea800ce0962b69e6db10b38c258590af)
                check_type(argname="argument line", value=line, expected_type=type_hints["line"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if line is not None:
                self._values["line"] = line

        @builtins.property
        def line(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''``CfnModelExplainabilityJobDefinition.JsonProperty.Line``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-json.html#cfn-sagemaker-modelexplainabilityjobdefinition-json-line
            '''
            result = self._values.get("line")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "JsonProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "config_uri": "configUri",
            "image_uri": "imageUri",
            "environment": "environment",
        },
    )
    class ModelExplainabilityAppSpecificationProperty:
        def __init__(
            self,
            *,
            config_uri: builtins.str,
            image_uri: builtins.str,
            environment: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        ) -> None:
            '''Docker container image configuration object for the model explainability job.

            :param config_uri: JSON formatted S3 file that defines explainability parameters. For more information on this JSON configuration file, see `Configure model explainability parameters <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-model-explainability-parameters.html>`_ .
            :param image_uri: The container image to be run by the model explainability job.
            :param environment: Sets the environment variables in the Docker container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                model_explainability_app_specification_property = sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty(
                    config_uri="configUri",
                    image_uri="imageUri",
                
                    # the properties below are optional
                    environment={
                        "environment_key": "environment"
                    }
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__2321efdf4c1d56a0eeac2146332712d6ed89ddcaf24628d4ffb7b504978363b9)
                check_type(argname="argument config_uri", value=config_uri, expected_type=type_hints["config_uri"])
                check_type(argname="argument image_uri", value=image_uri, expected_type=type_hints["image_uri"])
                check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "config_uri": config_uri,
                "image_uri": image_uri,
            }
            if environment is not None:
                self._values["environment"] = environment

        @builtins.property
        def config_uri(self) -> builtins.str:
            '''JSON formatted S3 file that defines explainability parameters.

            For more information on this JSON configuration file, see `Configure model explainability parameters <https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-model-explainability-parameters.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification-configuri
            '''
            result = self._values.get("config_uri")
            assert result is not None, "Required property 'config_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def image_uri(self) -> builtins.str:
            '''The container image to be run by the model explainability job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification-imageuri
            '''
            result = self._values.get("image_uri")
            assert result is not None, "Required property 'image_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def environment(
            self,
        ) -> typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]]:
            '''Sets the environment variables in the Docker container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification-environment
            '''
            result = self._values.get("environment")
            return typing.cast(typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ModelExplainabilityAppSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "baselining_job_name": "baseliningJobName",
            "constraints_resource": "constraintsResource",
        },
    )
    class ModelExplainabilityBaselineConfigProperty:
        def __init__(
            self,
            *,
            baselining_job_name: typing.Optional[builtins.str] = None,
            constraints_resource: typing.Optional[typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''The configuration for a baseline model explainability job.

            :param baselining_job_name: The name of the baseline model explainability job.
            :param constraints_resource: The constraints resource for a model explainability job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                model_explainability_baseline_config_property = sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c11cbc95fd63eec1f09d3ac64d78ac26640d78aef0ee6b76120fc1488729fff5)
                check_type(argname="argument baselining_job_name", value=baselining_job_name, expected_type=type_hints["baselining_job_name"])
                check_type(argname="argument constraints_resource", value=constraints_resource, expected_type=type_hints["constraints_resource"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if baselining_job_name is not None:
                self._values["baselining_job_name"] = baselining_job_name
            if constraints_resource is not None:
                self._values["constraints_resource"] = constraints_resource

        @builtins.property
        def baselining_job_name(self) -> typing.Optional[builtins.str]:
            '''The name of the baseline model explainability job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig-baseliningjobname
            '''
            result = self._values.get("baselining_job_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def constraints_resource(
            self,
        ) -> typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty", _IResolvable_a771d0ef]]:
            '''The constraints resource for a model explainability job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig-constraintsresource
            '''
            result = self._values.get("constraints_resource")
            return typing.cast(typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ModelExplainabilityBaselineConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "batch_transform_input": "batchTransformInput",
            "endpoint_input": "endpointInput",
        },
    )
    class ModelExplainabilityJobInputProperty:
        def __init__(
            self,
            *,
            batch_transform_input: typing.Optional[typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.BatchTransformInputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
            endpoint_input: typing.Optional[typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.EndpointInputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Inputs for the model explainability job.

            :param batch_transform_input: ``CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty.BatchTransformInput``.
            :param endpoint_input: ``CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty.EndpointInput``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                # json: Any
                
                model_explainability_job_input_property = sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty(
                    batch_transform_input=sagemaker.CfnModelExplainabilityJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnModelExplainabilityJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnModelExplainabilityJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=json,
                            parquet=False
                        ),
                        local_path="localPath",
                
                        # the properties below are optional
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    ),
                    endpoint_input=sagemaker.CfnModelExplainabilityJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
                
                        # the properties below are optional
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c608f99c83b32a66bee2c9edbd509fa90b326eecf0357214063bb1123cdcc2f7)
                check_type(argname="argument batch_transform_input", value=batch_transform_input, expected_type=type_hints["batch_transform_input"])
                check_type(argname="argument endpoint_input", value=endpoint_input, expected_type=type_hints["endpoint_input"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if batch_transform_input is not None:
                self._values["batch_transform_input"] = batch_transform_input
            if endpoint_input is not None:
                self._values["endpoint_input"] = endpoint_input

        @builtins.property
        def batch_transform_input(
            self,
        ) -> typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.BatchTransformInputProperty", _IResolvable_a771d0ef]]:
            '''``CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty.BatchTransformInput``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput-batchtransforminput
            '''
            result = self._values.get("batch_transform_input")
            return typing.cast(typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.BatchTransformInputProperty", _IResolvable_a771d0ef]], result)

        @builtins.property
        def endpoint_input(
            self,
        ) -> typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.EndpointInputProperty", _IResolvable_a771d0ef]]:
            '''``CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty.EndpointInput``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput-endpointinput
            '''
            result = self._values.get("endpoint_input")
            return typing.cast(typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.EndpointInputProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ModelExplainabilityJobInputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "monitoring_outputs": "monitoringOutputs",
            "kms_key_id": "kmsKeyId",
        },
    )
    class MonitoringOutputConfigProperty:
        def __init__(
            self,
            *,
            monitoring_outputs: typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.MonitoringOutputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]],
            kms_key_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The output configuration for monitoring jobs.

            :param monitoring_outputs: Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
            :param kms_key_id: The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                monitoring_output_config_property = sagemaker.CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnModelExplainabilityJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnModelExplainabilityJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
                
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
                
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__fb06e1d0b35715797412bfeb595832a0cf49fb163fedb94e24cfc136c44c2d3c)
                check_type(argname="argument monitoring_outputs", value=monitoring_outputs, expected_type=type_hints["monitoring_outputs"])
                check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "monitoring_outputs": monitoring_outputs,
            }
            if kms_key_id is not None:
                self._values["kms_key_id"] = kms_key_id

        @builtins.property
        def monitoring_outputs(
            self,
        ) -> typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnModelExplainabilityJobDefinition.MonitoringOutputProperty", _IResolvable_a771d0ef]]]:
            '''Monitoring outputs for monitoring jobs.

            This is where the output of the periodic monitoring jobs is uploaded.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig-monitoringoutputs
            '''
            result = self._values.get("monitoring_outputs")
            assert result is not None, "Required property 'monitoring_outputs' is missing"
            return typing.cast(typing.Union[_IResolvable_a771d0ef, typing.List[typing.Union["CfnModelExplainabilityJobDefinition.MonitoringOutputProperty", _IResolvable_a771d0ef]]], result)

        @builtins.property
        def kms_key_id(self) -> typing.Optional[builtins.str]:
            '''The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig-kmskeyid
            '''
            result = self._values.get("kms_key_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.MonitoringOutputProperty",
        jsii_struct_bases=[],
        name_mapping={"s3_output": "s3Output"},
    )
    class MonitoringOutputProperty:
        def __init__(
            self,
            *,
            s3_output: typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.S3OutputProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        ) -> None:
            '''The output object for a monitoring job.

            :param s3_output: The Amazon S3 storage location where the results of a monitoring job are saved.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutput.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                monitoring_output_property = sagemaker.CfnModelExplainabilityJobDefinition.MonitoringOutputProperty(
                    s3_output=sagemaker.CfnModelExplainabilityJobDefinition.S3OutputProperty(
                        local_path="localPath",
                        s3_uri="s3Uri",
                
                        # the properties below are optional
                        s3_upload_mode="s3UploadMode"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__d21ffad868baea42cdc178c46f91a9478976f151ea3dc19a02f9345ebf8acc17)
                check_type(argname="argument s3_output", value=s3_output, expected_type=type_hints["s3_output"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "s3_output": s3_output,
            }

        @builtins.property
        def s3_output(
            self,
        ) -> typing.Union["CfnModelExplainabilityJobDefinition.S3OutputProperty", _IResolvable_a771d0ef]:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutput.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringoutput-s3output
            '''
            result = self._values.get("s3_output")
            assert result is not None, "Required property 's3_output' is missing"
            return typing.cast(typing.Union["CfnModelExplainabilityJobDefinition.S3OutputProperty", _IResolvable_a771d0ef], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringOutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty",
        jsii_struct_bases=[],
        name_mapping={"cluster_config": "clusterConfig"},
    )
    class MonitoringResourcesProperty:
        def __init__(
            self,
            *,
            cluster_config: typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.ClusterConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        ) -> None:
            '''Identifies the resources to deploy for a monitoring job.

            :param cluster_config: The configuration for the cluster resources used to run the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringresources.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                monitoring_resources_property = sagemaker.CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnModelExplainabilityJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
                
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__df725cf6bd5a9c82c0a02dfd8c38318717956196c9723df626dbcfe12434150c)
                check_type(argname="argument cluster_config", value=cluster_config, expected_type=type_hints["cluster_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "cluster_config": cluster_config,
            }

        @builtins.property
        def cluster_config(
            self,
        ) -> typing.Union["CfnModelExplainabilityJobDefinition.ClusterConfigProperty", _IResolvable_a771d0ef]:
            '''The configuration for the cluster resources used to run the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringresources.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringresources-clusterconfig
            '''
            result = self._values.get("cluster_config")
            assert result is not None, "Required property 'cluster_config' is missing"
            return typing.cast(typing.Union["CfnModelExplainabilityJobDefinition.ClusterConfigProperty", _IResolvable_a771d0ef], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MonitoringResourcesProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.NetworkConfigProperty",
        jsii_struct_bases=[],
        name_mapping={
            "enable_inter_container_traffic_encryption": "enableInterContainerTrafficEncryption",
            "enable_network_isolation": "enableNetworkIsolation",
            "vpc_config": "vpcConfig",
        },
    )
    class NetworkConfigProperty:
        def __init__(
            self,
            *,
            enable_inter_container_traffic_encryption: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            enable_network_isolation: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
            vpc_config: typing.Optional[typing.Union[typing.Union["CfnModelExplainabilityJobDefinition.VpcConfigProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        ) -> None:
            '''Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.

            :param enable_inter_container_traffic_encryption: Whether to encrypt all communications between distributed processing jobs. Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
            :param enable_network_isolation: Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
            :param vpc_config: Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                network_config_property = sagemaker.CfnModelExplainabilityJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnModelExplainabilityJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__24be8ad81b572117ff682586b867f7fbbcd69518947a42ca9740a5d299d3ad08)
                check_type(argname="argument enable_inter_container_traffic_encryption", value=enable_inter_container_traffic_encryption, expected_type=type_hints["enable_inter_container_traffic_encryption"])
                check_type(argname="argument enable_network_isolation", value=enable_network_isolation, expected_type=type_hints["enable_network_isolation"])
                check_type(argname="argument vpc_config", value=vpc_config, expected_type=type_hints["vpc_config"])
            self._values: typing.Dict[builtins.str, typing.Any] = {}
            if enable_inter_container_traffic_encryption is not None:
                self._values["enable_inter_container_traffic_encryption"] = enable_inter_container_traffic_encryption
            if enable_network_isolation is not None:
                self._values["enable_network_isolation"] = enable_network_isolation
            if vpc_config is not None:
                self._values["vpc_config"] = vpc_config

        @builtins.property
        def enable_inter_container_traffic_encryption(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''Whether to encrypt all communications between distributed processing jobs.

            Choose ``True`` to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig-enableintercontainertrafficencryption
            '''
            result = self._values.get("enable_inter_container_traffic_encryption")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        @builtins.property
        def enable_network_isolation(
            self,
        ) -> typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]]:
            '''Whether to allow inbound and outbound network calls to and from the containers used for the processing job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig-enablenetworkisolation
            '''
            result = self._values.get("enable_network_isolation")
            return typing.cast(typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]], result)

        @builtins.property
        def vpc_config(
            self,
        ) -> typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.VpcConfigProperty", _IResolvable_a771d0ef]]:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig-vpcconfig
            '''
            result = self._values.get("vpc_config")
            return typing.cast(typing.Optional[typing.Union["CfnModelExplainabilityJobDefinition.VpcConfigProperty", _IResolvable_a771d0ef]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NetworkConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.S3OutputProperty",
        jsii_struct_bases=[],
        name_mapping={
            "local_path": "localPath",
            "s3_uri": "s3Uri",
            "s3_upload_mode": "s3UploadMode",
        },
    )
    class S3OutputProperty:
        def __init__(
            self,
            *,
            local_path: builtins.str,
            s3_uri: builtins.str,
            s3_upload_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Amazon S3 storage location where the results of a monitoring job are saved.

            :param local_path: The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.
            :param s3_uri: A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
            :param s3_upload_mode: Whether to upload the results of the monitoring job continuously or after the job completes.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                s3_output_property = sagemaker.CfnModelExplainabilityJobDefinition.S3OutputProperty(
                    local_path="localPath",
                    s3_uri="s3Uri",
                
                    # the properties below are optional
                    s3_upload_mode="s3UploadMode"
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__70ad135faa07e04d159ce3b7ac495aac508e68cd922d2da5106170b902f5a009)
                check_type(argname="argument local_path", value=local_path, expected_type=type_hints["local_path"])
                check_type(argname="argument s3_uri", value=s3_uri, expected_type=type_hints["s3_uri"])
                check_type(argname="argument s3_upload_mode", value=s3_upload_mode, expected_type=type_hints["s3_upload_mode"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "local_path": local_path,
                "s3_uri": s3_uri,
            }
            if s3_upload_mode is not None:
                self._values["s3_upload_mode"] = s3_upload_mode

        @builtins.property
        def local_path(self) -> builtins.str:
            '''The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            LocalPath is an absolute path for the output data.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html#cfn-sagemaker-modelexplainabilityjobdefinition-s3output-localpath
            '''
            result = self._values.get("local_path")
            assert result is not None, "Required property 'local_path' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_uri(self) -> builtins.str:
            '''A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html#cfn-sagemaker-modelexplainabilityjobdefinition-s3output-s3uri
            '''
            result = self._values.get("s3_uri")
            assert result is not None, "Required property 's3_uri' is missing"
            return typing.cast(builtins.str, result)

        @builtins.property
        def s3_upload_mode(self) -> typing.Optional[builtins.str]:
            '''Whether to upload the results of the monitoring job continuously or after the job completes.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html#cfn-sagemaker-modelexplainabilityjobdefinition-s3output-s3uploadmode
            '''
            result = self._values.get("s3_upload_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "S3OutputProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.StoppingConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"max_runtime_in_seconds": "maxRuntimeInSeconds"},
    )
    class StoppingConditionProperty:
        def __init__(self, *, max_runtime_in_seconds: jsii.Number) -> None:
            '''Specifies a limit to how long a model training job or model compilation job can run.

            It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, SageMaker ends the training or compilation job. Use this API to cap model training costs.

            To stop a training job, SageMaker sends the algorithm the ``SIGTERM`` signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.

            The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with ``CreateModel`` .
            .. epigraph::

               The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.

            :param max_runtime_in_seconds: The maximum length of time, in seconds, that a training or compilation job can run before it is stopped. For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model. For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days. The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-stoppingcondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                stopping_condition_property = sagemaker.CfnModelExplainabilityJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__c693b747b0077af8954bf02fa176325558f124bdba7c2953df491f1a92b4b161)
                check_type(argname="argument max_runtime_in_seconds", value=max_runtime_in_seconds, expected_type=type_hints["max_runtime_in_seconds"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "max_runtime_in_seconds": max_runtime_in_seconds,
            }

        @builtins.property
        def max_runtime_in_seconds(self) -> jsii.Number:
            '''The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.

            For compilation jobs, if the job does not complete during this time, a ``TimeOut`` error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.

            For all other jobs, if the job does not complete during this time, SageMaker ends the job. When ``RetryStrategy`` is specified in the job request, ``MaxRuntimeInSeconds`` specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.

            The maximum time that a ``TrainingJob`` can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-stoppingcondition.html#cfn-sagemaker-modelexplainabilityjobdefinition-stoppingcondition-maxruntimeinseconds
            '''
            result = self._values.get("max_runtime_in_seconds")
            assert result is not None, "Required property 'max_runtime_in_seconds' is missing"
            return typing.cast(jsii.Number, result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "StoppingConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinition.VpcConfigProperty",
        jsii_struct_bases=[],
        name_mapping={"security_group_ids": "securityGroupIds", "subnets": "subnets"},
    )
    class VpcConfigProperty:
        def __init__(
            self,
            *,
            security_group_ids: typing.Sequence[builtins.str],
            subnets: typing.Sequence[builtins.str],
        ) -> None:
            '''Specifies a VPC that your training jobs and hosted models have access to.

            Control access to and from your training and model containers by configuring the VPC. For more information, see `Protect Endpoints by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html>`_ and `Protect Training Jobs by Using an Amazon Virtual Private Cloud <https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html>`_ .

            :param security_group_ids: The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the ``Subnets`` field.
            :param subnets: The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-vpcconfig.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                from monocdk import aws_sagemaker as sagemaker
                
                vpc_config_property = sagemaker.CfnModelExplainabilityJobDefinition.VpcConfigProperty(
                    security_group_ids=["securityGroupIds"],
                    subnets=["subnets"]
                )
            '''
            if __debug__:
                type_hints = typing.get_type_hints(_typecheckingstub__a08b86d9b146a5dca56f19de3b70f90e49662507b951e36cbc05797fb86dc0f1)
                check_type(argname="argument security_group_ids", value=security_group_ids, expected_type=type_hints["security_group_ids"])
                check_type(argname="argument subnets", value=subnets, expected_type=type_hints["subnets"])
            self._values: typing.Dict[builtins.str, typing.Any] = {
                "security_group_ids": security_group_ids,
                "subnets": subnets,
            }

        @builtins.property
        def security_group_ids(self) -> typing.List[builtins.str]:
            '''The VPC security group IDs, in the form sg-xxxxxxxx.

            Specify the security groups for the VPC that is specified in the ``Subnets`` field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-vpcconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-vpcconfig-securitygroupids
            '''
            result = self._values.get("security_group_ids")
            assert result is not None, "Required property 'security_group_ids' is missing"
            return typing.cast(typing.List[builtins.str], result)

        @builtins.property
        def subnets(self) -> typing.List[builtins.str]:
            '''The ID of the subnets in the VPC to which you want to connect your training job or model.

            For information about the availability of specific instance types, see `Supported Instance Types and Availability Zones <https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html>`_ .

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-vpcconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-vpcconfig-subnets
            '''
            result = self._values.get("subnets")
            assert result is not None, "Required property 'subnets' is missing"
            return typing.cast(typing.List[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "VpcConfigProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )


@jsii.data_type(
    jsii_type="monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinitionProps",
    jsii_struct_bases=[],
    name_mapping={
        "job_resources": "jobResources",
        "model_explainability_app_specification": "modelExplainabilityAppSpecification",
        "model_explainability_job_input": "modelExplainabilityJobInput",
        "model_explainability_job_output_config": "modelExplainabilityJobOutputConfig",
        "role_arn": "roleArn",
        "endpoint_name": "endpointName",
        "job_definition_name": "jobDefinitionName",
        "model_explainability_baseline_config": "modelExplainabilityBaselineConfig",
        "network_config": "networkConfig",
        "stopping_condition": "stoppingCondition",
        "tags": "tags",
    },
)
class CfnModelExplainabilityJobDefinitionProps:
    def __init__(
        self,
        *,
        job_resources: typing.Union[typing.Union[CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_explainability_app_specification: typing.Union[typing.Union[CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_explainability_job_input: typing.Union[typing.Union[CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        model_explainability_job_output_config: typing.Union[typing.Union[CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef],
        role_arn: builtins.str,
        endpoint_name: typing.Optional[builtins.str] = None,
        job_definition_name: typing.Optional[builtins.str] = None,
        model_explainability_baseline_config: typing.Optional[typing.Union[typing.Union[CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        network_config: typing.Optional[typing.Union[typing.Union[CfnModelExplainabilityJobDefinition.NetworkConfigProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        stopping_condition: typing.Optional[typing.Union[typing.Union[CfnModelExplainabilityJobDefinition.StoppingConditionProperty, typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for defining a ``CfnModelExplainabilityJobDefinition``.

        :param job_resources: Identifies the resources to deploy for a monitoring job.
        :param model_explainability_app_specification: Configures the model explainability job to run a specified Docker container image.
        :param model_explainability_job_input: Inputs for the model explainability job.
        :param model_explainability_job_output_config: The output configuration for monitoring jobs.
        :param role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
        :param endpoint_name: ``AWS::SageMaker::ModelExplainabilityJobDefinition.EndpointName``.
        :param job_definition_name: The name of the model explainability job definition. The name must be unique within an AWS Region in the AWS account.
        :param model_explainability_baseline_config: The baseline configuration for a model explainability job.
        :param network_config: Networking options for a model explainability job.
        :param stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping.
        :param tags: An array of key-value pairs to apply to this resource. For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
        :exampleMetadata: fixture=_generated

        Example::

            # The code below shows an example of how to instantiate this type.
            # The values are placeholders you should change.
            from monocdk import aws_sagemaker as sagemaker
            
            # json: Any
            
            cfn_model_explainability_job_definition_props = sagemaker.CfnModelExplainabilityJobDefinitionProps(
                job_resources=sagemaker.CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty(
                    cluster_config=sagemaker.CfnModelExplainabilityJobDefinition.ClusterConfigProperty(
                        instance_count=123,
                        instance_type="instanceType",
                        volume_size_in_gb=123,
            
                        # the properties below are optional
                        volume_kms_key_id="volumeKmsKeyId"
                    )
                ),
                model_explainability_app_specification=sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty(
                    config_uri="configUri",
                    image_uri="imageUri",
            
                    # the properties below are optional
                    environment={
                        "environment_key": "environment"
                    }
                ),
                model_explainability_job_input=sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty(
                    batch_transform_input=sagemaker.CfnModelExplainabilityJobDefinition.BatchTransformInputProperty(
                        data_captured_destination_s3_uri="dataCapturedDestinationS3Uri",
                        dataset_format=sagemaker.CfnModelExplainabilityJobDefinition.DatasetFormatProperty(
                            csv=sagemaker.CfnModelExplainabilityJobDefinition.CsvProperty(
                                header=False
                            ),
                            json=json,
                            parquet=False
                        ),
                        local_path="localPath",
            
                        # the properties below are optional
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    ),
                    endpoint_input=sagemaker.CfnModelExplainabilityJobDefinition.EndpointInputProperty(
                        endpoint_name="endpointName",
                        local_path="localPath",
            
                        # the properties below are optional
                        features_attribute="featuresAttribute",
                        inference_attribute="inferenceAttribute",
                        probability_attribute="probabilityAttribute",
                        s3_data_distribution_type="s3DataDistributionType",
                        s3_input_mode="s3InputMode"
                    )
                ),
                model_explainability_job_output_config=sagemaker.CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty(
                    monitoring_outputs=[sagemaker.CfnModelExplainabilityJobDefinition.MonitoringOutputProperty(
                        s3_output=sagemaker.CfnModelExplainabilityJobDefinition.S3OutputProperty(
                            local_path="localPath",
                            s3_uri="s3Uri",
            
                            # the properties below are optional
                            s3_upload_mode="s3UploadMode"
                        )
                    )],
            
                    # the properties below are optional
                    kms_key_id="kmsKeyId"
                ),
                role_arn="roleArn",
            
                # the properties below are optional
                endpoint_name="endpointName",
                job_definition_name="jobDefinitionName",
                model_explainability_baseline_config=sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty(
                    baselining_job_name="baseliningJobName",
                    constraints_resource=sagemaker.CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty(
                        s3_uri="s3Uri"
                    )
                ),
                network_config=sagemaker.CfnModelExplainabilityJobDefinition.NetworkConfigProperty(
                    enable_inter_container_traffic_encryption=False,
                    enable_network_isolation=False,
                    vpc_config=sagemaker.CfnModelExplainabilityJobDefinition.VpcConfigProperty(
                        security_group_ids=["securityGroupIds"],
                        subnets=["subnets"]
                    )
                ),
                stopping_condition=sagemaker.CfnModelExplainabilityJobDefinition.StoppingConditionProperty(
                    max_runtime_in_seconds=123
                ),
                tags=[CfnTag(
                    key="key",
                    value="value"
                )]
            )
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46c62421ac841ee8dacf7c05cde6588a9aff82ddf70c63a71657c5f8102ed14c)
            check_type(argname="argument job_resources", value=job_resources, expected_type=type_hints["job_resources"])
            check_type(argname="argument model_explainability_app_specification", value=model_explainability_app_specification, expected_type=type_hints["model_explainability_app_specification"])
            check_type(argname="argument model_explainability_job_input", value=model_explainability_job_input, expected_type=type_hints["model_explainability_job_input"])
            check_type(argname="argument model_explainability_job_output_config", value=model_explainability_job_output_config, expected_type=type_hints["model_explainability_job_output_config"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument endpoint_name", value=endpoint_name, expected_type=type_hints["endpoint_name"])
            check_type(argname="argument job_definition_name", value=job_definition_name, expected_type=type_hints["job_definition_name"])
            check_type(argname="argument model_explainability_baseline_config", value=model_explainability_baseline_config, expected_type=type_hints["model_explainability_baseline_config"])
            check_type(argname="argument network_config", value=network_config, expected_type=type_hints["network_config"])
            check_type(argname="argument stopping_condition", value=stopping_condition, expected_type=type_hints["stopping_condition"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "job_resources": job_resources,
            "model_explainability_app_specification": model_explainability_app_specification,
            "model_explainability_job_input": model_explainability_job_input,
            "model_explainability_job_output_config": model_explainability_job_output_config,
            "role_arn": role_arn,
        }
        if endpoint_name is not None:
            self._values["endpoint_name"] = endpoint_name
        if job_definition_name is not None:
            self._values["job_definition_name"] = job_definition_name
        if model_explainability_baseline_config is not None:
            self._values["model_explainability_baseline_config"] = model_explainability_baseline_config
        if network_config is not None:
            self._values["network_config"] = network_config
        if stopping_condition is not None:
            self._values["stopping_condition"] = stopping_condition
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def job_resources(
        self,
    ) -> typing.Union[CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty, _IResolvable_a771d0ef]:
        '''Identifies the resources to deploy for a monitoring job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobresources
        '''
        result = self._values.get("job_resources")
        assert result is not None, "Required property 'job_resources' is missing"
        return typing.cast(typing.Union[CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def model_explainability_app_specification(
        self,
    ) -> typing.Union[CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty, _IResolvable_a771d0ef]:
        '''Configures the model explainability job to run a specified Docker container image.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification
        '''
        result = self._values.get("model_explainability_app_specification")
        assert result is not None, "Required property 'model_explainability_app_specification' is missing"
        return typing.cast(typing.Union[CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def model_explainability_job_input(
        self,
    ) -> typing.Union[CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty, _IResolvable_a771d0ef]:
        '''Inputs for the model explainability job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput
        '''
        result = self._values.get("model_explainability_job_input")
        assert result is not None, "Required property 'model_explainability_job_input' is missing"
        return typing.cast(typing.Union[CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def model_explainability_job_output_config(
        self,
    ) -> typing.Union[CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty, _IResolvable_a771d0ef]:
        '''The output configuration for monitoring jobs.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjoboutputconfig
        '''
        result = self._values.get("model_explainability_job_output_config")
        assert result is not None, "Required property 'model_explainability_job_output_config' is missing"
        return typing.cast(typing.Union[CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty, _IResolvable_a771d0ef], result)

    @builtins.property
    def role_arn(self) -> builtins.str:
        '''The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-rolearn
        '''
        result = self._values.get("role_arn")
        assert result is not None, "Required property 'role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def endpoint_name(self) -> typing.Optional[builtins.str]:
        '''``AWS::SageMaker::ModelExplainabilityJobDefinition.EndpointName``.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointname
        '''
        result = self._values.get("endpoint_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def job_definition_name(self) -> typing.Optional[builtins.str]:
        '''The name of the model explainability job definition.

        The name must be unique within an AWS Region in the AWS account.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobdefinitionname
        '''
        result = self._values.get("job_definition_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def model_explainability_baseline_config(
        self,
    ) -> typing.Optional[typing.Union[CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty, _IResolvable_a771d0ef]]:
        '''The baseline configuration for a model explainability job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig
        '''
        result = self._values.get("model_explainability_baseline_config")
        return typing.cast(typing.Optional[typing.Union[CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def network_config(
        self,
    ) -> typing.Optional[typing.Union[CfnModelExplainabilityJobDefinition.NetworkConfigProperty, _IResolvable_a771d0ef]]:
        '''Networking options for a model explainability job.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig
        '''
        result = self._values.get("network_config")
        return typing.cast(typing.Optional[typing.Union[CfnModelExplainabilityJobDefinition.NetworkConfigProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def stopping_condition(
        self,
    ) -> typing.Optional[typing.Union[CfnModelExplainabilityJobDefinition.StoppingConditionProperty, _IResolvable_a771d0ef]]:
        '''A time limit for how long the monitoring job is allowed to run before stopping.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-stoppingcondition
        '''
        result = self._values.get("stopping_condition")
        return typing.cast(typing.Optional[typing.Union[CfnModelExplainabilityJobDefinition.StoppingConditionProperty, _IResolvable_a771d0ef]], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[_CfnTag_95fbdc29]]:
        '''An array of key-value pairs to apply to this resource.

        For more information, see `Tag <https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html>`_ .

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-tags
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List[_CfnTag_95fbdc29]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CfnModelExplainabilityJobDefinitionProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(_IInspectable_82c04a63)
class CfnModelPackage(
    _CfnResource_e0a482dc,
    metaclass=jsii.JSIIMeta,
    jsii_type="monocdk.aws_sagemaker.CfnModelPackage",
):
    '''A CloudFormation ``AWS::SageMaker::ModelPackage``.

    A versioned model that can be deployed for SageMaker inference.

    :cloudformationResource: AWS::SageMaker::ModelPackage
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        from monocdk import aws_sagemaker as sagemaker
        
        # model_input: Any
        
        cfn_model_package = sagemaker.CfnModelPackage(self, "MyCfnModelPackage",
            additional_inference_specification_definition=sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty(
                containers=[sagemaker.CfnModelPackage.ModelPackageContainerDefinitionProperty(
                    image="image",
        
                    # the properties below are optional
                    container_hostname="containerHostname",
                    environment={
                        "environment_key": "environment"
                    },
                    framework="framework",
                    framework_version="frameworkVersion",
                    image_digest="imageDigest",
                    model_data_url="modelDataUrl",
                    model_input=model_input,
                    nearest_model_name="nearestModelName",
                    product_id="productId"
                )],
                name="name",
        
                # the properties below are optional
                description="description",
                supported_content_types=["supportedContentTypes"],
                supported_realtime_inference_instance_types=["supportedRealtimeInferenceInstanceTypes"],
                supported_response_mime_types=["supportedResponseMimeTypes"],
                supported_transform_instance_types=["supportedTransformInstanceTypes"]
            ),
            additional_inference_specifications=[sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty(
                containers=[sagemaker.CfnModelPackage.ModelPackageContainerDefinitionProperty(
                    image="image",
        
                    # the properties below are optional
                    container_hostname="containerHostname",
                    environment={
                        "environment_key": "environment"
                    },
                    framework="framework",
                    framework_version="frameworkVersion",
                    image_digest="imageDigest",
                    model_data_url="modelDataUrl",
                    model_input=model_input,
                    nearest_model_name="nearestModelName",
                    product_id="productId"
                )],
                name="name",
        
                # the properties below are optional
                description="description",
                supported_content_types=["supportedContentTypes"],
                supported_realtime_inference_instance_types=["supportedRealtimeInferenceInstanceTypes"],
                supported_response_mime_types=["supportedResponseMimeTypes"],
                supported_transform_instance_types=["supportedTransformInstanceTypes"]
            )],
            additional_inference_specifications_to_add=[sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty(
                containers=[sagemaker.CfnModelPackage.ModelPackageContainerDefinitionProperty(
                    image="image",
        
                    # the properties below are optional
                    container_hostname="containerHostname",
                    environment={
                        "environment_key": "environment"
                    },
                    framework="framework",
                    framework_version="frameworkVersion",
                    image_digest="imageDigest",
                    model_data_url="modelDataUrl",
                    model_input=model_input,
                    nearest_model_name="nearestModelName",
                    product_id="productId"
                )],
                name="name",
        
                # the properties below are optional
                description="description",
                supported_content_types=["supportedContentTypes"],
                supported_realtime_inference_instance_types=["supportedRealtimeInferenceInstanceTypes"],
                supported_response_mime_types=["supportedResponseMimeTypes"],
                supported_transform_instance_types=["supportedTransformInstanceTypes"]
            )],
            approval_description="approvalDescription",
            certify_for_marketplace=False,
            client_token="clientToken",
            created_by=sagemaker.CfnModelPackage.UserContextProperty(
                domain_id="domainId",
                user_profile_arn="userProfileArn",
                user_profile_name="userProfileName"
            ),
            customer_metadata_properties={
                "customer_metadata_properties_key": "customerMetadataProperties"
            },
            domain="domain",
            drift_check_baselines=sagemaker.CfnModelPackage.DriftCheckBaselinesProperty(
                bias=sagemaker.CfnModelPackage.DriftCheckBiasProperty(
                    config_file=sagemaker.CfnModelPackage.FileSourceProperty(
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest",
                        content_type="contentType"
                    ),
                    post_training_constraints=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    ),
                    pre_training_constraints=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    )
                ),
                explainability=sagemaker.CfnModelPackage.DriftCheckExplainabilityProperty(
                    config_file=sagemaker.CfnModelPackage.FileSourceProperty(
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest",
                        content_type="contentType"
                    ),
                    constraints=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    )
                ),
                model_data_quality=sagemaker.CfnModelPackage.DriftCheckModelDataQualityProperty(
                    constraints=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    ),
                    statistics=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    )
                ),
                model_quality=sagemaker.CfnModelPackage.DriftCheckModelQualityProperty(
                    constraints=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    ),
                    statistics=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    )
                )
            ),
            environment={
                "environment_key": "environment"
            },
            inference_specification=sagemaker.CfnModelPackage.InferenceSpecificationProperty(
                containers=[sagemaker.CfnModelPackage.ModelPackageContainerDefinitionProperty(
                    image="image",
        
                    # the properties below are optional
                    container_hostname="containerHostname",
                    environment={
                        "environment_key": "environment"
                    },
                    framework="framework",
                    framework_version="frameworkVersion",
                    image_digest="imageDigest",
                    model_data_url="modelDataUrl",
                    model_input=model_input,
                    nearest_model_name="nearestModelName",
                    product_id="productId"
                )],
                supported_content_types=["supportedContentTypes"],
                supported_response_mime_types=["supportedResponseMimeTypes"],
        
                # the properties below are optional
                supported_realtime_inference_instance_types=["supportedRealtimeInferenceInstanceTypes"],
                supported_transform_instance_types=["supportedTransformInstanceTypes"]
            ),
            last_modified_by=sagemaker.CfnModelPackage.UserContextProperty(
                domain_id="domainId",
                user_profile_arn="userProfileArn",
                user_profile_name="userProfileName"
            ),
            last_modified_time="lastModifiedTime",
            metadata_properties=sagemaker.CfnModelPackage.MetadataPropertiesProperty(
                commit_id="commitId",
                generated_by="generatedBy",
                project_id="projectId",
                repository="repository"
            ),
            model_approval_status="modelApprovalStatus",
            model_metrics=sagemaker.CfnModelPackage.ModelMetricsProperty(
                bias=sagemaker.CfnModelPackage.BiasProperty(
                    post_training_report=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    ),
                    pre_training_report=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    ),
                    report=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    )
                ),
                explainability=sagemaker.CfnModelPackage.ExplainabilityProperty(
                    report=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    )
                ),
                model_data_quality=sagemaker.CfnModelPackage.ModelDataQualityProperty(
                    constraints=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    ),
                    statistics=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    )
                ),
                model_quality=sagemaker.CfnModelPackage.ModelQualityProperty(
                    constraints=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    ),
                    statistics=sagemaker.CfnModelPackage.MetricsSourceProperty(
                        content_type="contentType",
                        s3_uri="s3Uri",
        
                        # the properties below are optional
                        content_digest="contentDigest"
                    )
                )
            ),
            model_package_description="modelPackageDescription",
            model_package_group_name="modelPackageGroupName",
            model_package_name="modelPackageName",
            model_package_status_details=sagemaker.CfnModelPackage.ModelPackageStatusDetailsProperty(
                validation_statuses=[sagemaker.CfnModelPackage.ModelPackageStatusItemProperty(
                    name="name",
                    status="status",
        
                    # the properties below are optional
                    failure_reason="failureReason"
                )],
        
                # the properties below are optional
                image_scan_statuses=[sagemaker.CfnModelPackage.ModelPackageStatusItemProperty(
                    name="name",
                    status="status",
        
                    # the properties below are optional
                    failure_reason="failureReason"
                )]
            ),
            model_package_status_item=sagemaker.CfnModelPackage.ModelPackageStatusItemProperty(
                name="name",
                status="status",
        
                # the properties below are optional
                failure_reason="failureReason"
            ),
            model_package_version=123,
            sample_payload_url="samplePayloadUrl",
            source_algorithm_specification=sagemaker.CfnModelPackage.SourceAlgorithmSpecificationProperty(
                source_algorithms=[sagemaker.CfnModelPackage.SourceAlgorithmProperty(
                    algorithm_name="algorithmName",
        
                    # the properties below are optional
                    model_data_url="modelDataUrl"
                )]
            ),
            tags=[CfnTag(
                key="key",
                value="value"
            )],
            task="task",
            validation_specification=sagemaker.CfnModelPackage.ValidationSpecificationProperty(
                validation_profiles=[sagemaker.CfnModelPackage.ValidationProfileProperty(
                    profile_name="profileName",
                    transform_job_definition=sagemaker.CfnModelPackage.TransformJobDefinitionProperty(
                        transform_input=sagemaker.CfnModelPackage.TransformInputProperty(
                            data_source=sagemaker.CfnModelPackage.DataSourceProperty(
                                s3_data_source=sagemaker.CfnModelPackage.S3DataSourceProperty(
                                    s3_data_type="s3DataType",
                                    s3_uri="s3Uri"
                                )
                            ),
        
                            # the properties below are optional
                            compression_type="compressionType",
                            content_type="contentType",
                            split_type="splitType"
                        ),
                        transform_output=sagemaker.CfnModelPackage.TransformOutputProperty(
                            s3_output_path="s3OutputPath",
        
                            # the properties below are optional
                            accept="accept",
                            assemble_with="assembleWith",
                            kms_key_id="kmsKeyId"
                        ),
                        transform_resources=sagemaker.CfnModelPackage.TransformResourcesProperty(
                            instance_count=123,
                            instance_type="instanceType",
        
                            # the properties below are optional
                            volume_kms_key_id="volumeKmsKeyId"
                        ),
        
                        # the properties below are optional
                        batch_strategy="batchStrategy",
                        environment={
                            "environment_key": "environment"
                        },
                        max_concurrent_transforms=123,
                        max_payload_in_mb=123
                    )
                )],
                validation_role="validationRole"
            )
        )
    '''

    def __init__(
        self,
        scope: _Construct_e78e779f,
        id: builtins.str,
        *,
        additional_inference_specification_definition: typing.Optional[typing.Union[typing.Union["CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        additional_inference_specifications: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        additional_inference_specifications_to_add: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Sequence[typing.Union[typing.Union["CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]]]] = None,
        approval_description: typing.Optional[builtins.str] = None,
        certify_for_marketplace: typing.Optional[typing.Union[builtins.bool, _IResolvable_a771d0ef]] = None,
        client_token: typing.Optional[builtins.str] = None,
        created_by: typing.Optional[typing.Union[typing.Union["CfnModelPackage.UserContextProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        customer_metadata_properties: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        domain: typing.Optional[builtins.str] = None,
        drift_check_baselines: typing.Optional[typing.Union[typing.Union["CfnModelPackage.DriftCheckBaselinesProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        environment: typing.Optional[typing.Union[_IResolvable_a771d0ef, typing.Mapping[builtins.str, builtins.str]]] = None,
        inference_specification: typing.Optional[typing.Union[typing.Union["CfnModelPackage.InferenceSpecificationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        last_modified_by: typing.Optional[typing.Union[typing.Union["CfnModelPackage.UserContextProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        last_modified_time: typing.Optional[builtins.str] = None,
        metadata_properties: typing.Optional[typing.Union[typing.Union["CfnModelPackage.MetadataPropertiesProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        model_approval_status: typing.Optional[builtins.str] = None,
        model_metrics: typing.Optional[typing.Union[typing.Union["CfnModelPackage.ModelMetricsProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        model_package_description: typing.Optional[builtins.str] = None,
        model_package_group_name: typing.Optional[builtins.str] = None,
        model_package_name: typing.Optional[builtins.str] = None,
        model_package_status_details: typing.Optional[typing.Union[typing.Union["CfnModelPackage.ModelPackageStatusDetailsProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        model_package_status_item: typing.Optional[typing.Union[typing.Union["CfnModelPackage.ModelPackageStatusItemProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        model_package_version: typing.Optional[jsii.Number] = None,
        sample_payload_url: typing.Optional[builtins.str] = None,
        source_algorithm_specification: typing.Optional[typing.Union[typing.Union["CfnModelPackage.SourceAlgorithmSpecificationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[_CfnTag_95fbdc29, typing.Dict[builtins.str, typing.Any]]]] = None,
        task: typing.Optional[builtins.str] = None,
        validation_specification: typing.Optional[typing.Union[typing.Union["CfnModelPackage.ValidationSpecificationProperty", typing.Dict[builtins.str, typing.Any]], _IResolvable_a771d0ef]] = None,
    ) -> None:
        '''Create a new ``AWS::SageMaker::ModelPackage``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param additional_inference_specification_definition: A structure of additional Inference Specification. Additional Inference Specification specifies details about inference jobs that can be run with models based on this model package
        :param additional_inference_specifications: An array of additional Inference Specification objects.
        :param additional_inference_specifications_to_add: An array of additional Inference Specification objects to be added to the existing array. The total number of additional Inference Specification objects cannot exceed 15. Each additional Inference Specification object specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
        :param approval_description: A description provided when the model approval is set.
        :param certify_for_marketplace: Whether the model package is to be certified to be listed on AWS Marketplace. For information about listing model packages on AWS Marketplace, see `List Your Algorithm or Model Package on AWS Marketplace <https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html>`_ .
        :param client_token: A unique token that guarantees that the call to this API is idempotent.
        :param created_by: Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.
        :param customer_metadata_properties: The metadata properties for the model package.
        :param domain: The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.
        :param drift_check_baselines: Represents the drift check baselines that can be used when the model monitor is set using the model package.
        :param environment: The environment variables to set in the Docker container. Each key and value in the ``Environment`` string to string map can have length of up to 1024. We support up to 16 entries in the map.
        :param inference_specification: Defines how to perform inference generation after a training job is run.
        :param last_modified_by: Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.
        :param last_modified_time: The last time the model package was modified.
        :param metadata_properties: Metadata properties of the tracking entity, trial, or trial component.
        :param model_approval_status: The approval status of the model. This can be one of the following values. - ``APPROVED`` - The model is approved - ``REJECTED`` - The model is rejected. - ``PENDING_MANUAL_APPROVAL`` - The model is waiting for manual approval.
        :param model_metrics: Metrics for the model.
        :param model_package_description: The description of the model package.
        :param model_package_group_name: The model group to which the model belongs.
        :param model_package_name: The name of the model.
        :param model_package_status_details: Specifies the validation and image scan statuses of the model package.
        :param model_package_status_item: Represents the overall status of a model package.
        :param model_package_version: The version number of a versioned model.
        :param sample_payload_url: The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
        :param source_algorithm_specification: A list of algorithms that were used to create a model package.
        :param tags: A list of the tags associated with the model package. For more information, see `Tagging AWS resources <https://docs.aw