# Sciagraph: the performance and memory profiler for Python data processing

Whether it's detecting disease, modeling the electric grid, or whatever data processing you do with Python, inefficient code is a cost you can't afford to pay:

* If it takes 30 minutes for your code to run, debugging minor changes can waste your whole afternoon.
* If your program runs out of memory—it's dead, and you're not getting any results until you fix that.
* Once you're running in production at scale, inefficient software means throwing money at your cloud provider.
  You probably need that money more than they do.

On the other hand, the faster your software, the easier it will be for you to iterate and improve.
And the faster your software, the happier your users (and accountant) will be.

That's where profilers come in: tools that will help you find speed and memory bottlenecks in your code, so that instead of guessing, you can quickly fix the problem.
Unfortunately, profilers that work well for web applications don't necessary work as well when it comes to data processing.
You need a profiler designed for _your_ kind of software.

**Sciagraph is a profiler that gives you deep visibility into your Python code's speed and memory usage—with a focus on data science, scientific computing, and data processing.**
It's designed specifically for the needs of people like you, from measurements to visualizations to integrations (Jupyter, MLFlow, Celery, and more.)

Learn more at [https://sciagraph.com](https://sciagraph.com).
