"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildWebacl = void 0;
const waf = require("@aws-cdk/aws-wafv2");
const waf_defaults_1 = require("./waf-defaults");
const utils_1 = require("./utils");
function buildWebacl(scope, webaclScope, props) {
    let webAcl;
    if (props.existingWebaclObj && !props.webaclProps) { // Existing WAF web ACL
        webAcl = props.existingWebaclObj;
    }
    else { // Create a new WAF web ACL
        let finalWebaclProps;
        if (props.webaclProps) {
            finalWebaclProps = utils_1.overrideProps(waf_defaults_1.DefaultWafwebaclProps(webaclScope), props.webaclProps);
        }
        else {
            finalWebaclProps = waf_defaults_1.DefaultWafwebaclProps(webaclScope);
        }
        webAcl = new waf.CfnWebACL(scope, `${scope.node.id}-WebACL`, finalWebaclProps);
    }
    return webAcl;
}
exports.buildWebacl = buildWebacl;
//# sourceMappingURL=data:application/json;base64,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