"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildSecurityGroup = void 0;
// import { countResources } from "@aws-cdk/assert";
const ec2 = require("@aws-cdk/aws-ec2");
const utils_1 = require("./utils");
function buildSecurityGroup(scope, name, props, ingressRules, egressRules) {
    const newSecurityGroup = new ec2.SecurityGroup(scope, `${name}-security-group`, props);
    ingressRules.forEach(rule => {
        newSecurityGroup.addIngressRule(rule.peer, rule.connection, rule.description, rule.remoteRule);
    });
    egressRules.forEach(rule => {
        newSecurityGroup.addEgressRule(rule.peer, rule.connection, rule.description, rule.remoteRule);
    });
    utils_1.addCfnSuppressRules(newSecurityGroup, [
        {
            id: "W5",
            reason: "Egress of 0.0.0.0/0 is default and generally considered OK",
        },
        {
            id: "W40",
            reason: "Egress IPProtocol of -1 is default and generally considered OK",
        },
    ]);
    return newSecurityGroup;
}
exports.buildSecurityGroup = buildSecurityGroup;
//# sourceMappingURL=data:application/json;base64,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