"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisEventSourceProps = exports.S3EventSourceProps = exports.DynamoEventSourceProps = void 0;
const lambda = require("@aws-cdk/aws-lambda");
const utils_1 = require("./utils");
const aws_lambda_event_sources_1 = require("@aws-cdk/aws-lambda-event-sources");
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const sqs_helper_1 = require("./sqs-helper");
function DynamoEventSourceProps(scope, _dynamoEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: core_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_dynamoEventSourceProps === undefined || (_dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.deploySqsDlqQueue) === undefined
        || _dynamoEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultDynamoEventSourceProps = Object.assign(baseProps, extraProps);
    if (_dynamoEventSourceProps === null || _dynamoEventSourceProps === void 0 ? void 0 : _dynamoEventSourceProps.eventSourceProps) {
        return utils_1.overrideProps(defaultDynamoEventSourceProps, _dynamoEventSourceProps.eventSourceProps);
    }
    else {
        return defaultDynamoEventSourceProps;
    }
}
exports.DynamoEventSourceProps = DynamoEventSourceProps;
function S3EventSourceProps(_s3EventSourceProps) {
    const defaultS3EventSourceProps = {
        events: [s3.EventType.OBJECT_CREATED]
    };
    if (_s3EventSourceProps) {
        return utils_1.overrideProps(defaultS3EventSourceProps, _s3EventSourceProps, false);
    }
    else {
        return defaultS3EventSourceProps;
    }
}
exports.S3EventSourceProps = S3EventSourceProps;
function KinesisEventSourceProps(scope, _kinesisEventSourceProps) {
    const baseProps = {
        startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        bisectBatchOnError: true,
        maxRecordAge: core_1.Duration.hours(24),
        retryAttempts: 500
    };
    let extraProps = {};
    if (_kinesisEventSourceProps === undefined || (_kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.deploySqsDlqQueue) === undefined
        || _kinesisEventSourceProps.deploySqsDlqQueue) {
        const [sqsQueue] = sqs_helper_1.buildQueue(scope, 'SqsDlqQueue', {
            queueProps: _kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.sqsDlqQueueProps
        });
        extraProps = {
            onFailure: new aws_lambda_event_sources_1.SqsDlq(sqsQueue),
        };
    }
    const defaultKinesisEventSourceProps = Object.assign(baseProps, extraProps);
    if (_kinesisEventSourceProps === null || _kinesisEventSourceProps === void 0 ? void 0 : _kinesisEventSourceProps.eventSourceProps) {
        return utils_1.overrideProps(defaultKinesisEventSourceProps, _kinesisEventSourceProps.eventSourceProps);
    }
    else {
        return defaultKinesisEventSourceProps;
    }
}
exports.KinesisEventSourceProps = KinesisEventSourceProps;
//# sourceMappingURL=data:application/json;base64,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