"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueTableProps = void 0;
const core_1 = require("@aws-cdk/core");
function DefaultGlueTableProps(database, fieldSchema, sourceType, parameters) {
    let _tableProps;
    if (sourceType === 'kinesis') {
        const kinesisStreamName = parameters.STREAM_NAME;
        const _paths = fieldSchema.map((item) => {
            return item.name;
        }).join(',');
        _tableProps = {
            catalogId: database.catalogId,
            databaseName: database.ref,
            tableInput: {
                storageDescriptor: {
                    columns: fieldSchema,
                    location: kinesisStreamName,
                    inputFormat: "org.apache.hadoop.mapred.TextInputFormat",
                    outputFormat: "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat",
                    compressed: false,
                    numberOfBuckets: -1,
                    serdeInfo: {
                        serializationLibrary: "org.openx.data.jsonserde.JsonSerDe",
                        parameters: {
                            paths: _paths
                        }
                    },
                    parameters: {
                        endpointUrl: `https://kinesis.${core_1.Aws.REGION}.amazonaws.com`,
                        streamName: kinesisStreamName,
                        typeOfData: sourceType
                    }
                },
                tableType: 'EXTERNAL_TABLE',
                parameters: {
                    classification: 'json'
                }
            }
        };
        return _tableProps;
    }
    else {
        throw Error('Source Type not Supported. Valid Source Type not provided');
    }
}
exports.DefaultGlueTableProps = DefaultGlueTableProps;
//# sourceMappingURL=data:application/json;base64,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