"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultUserPoolProps = exports.DefaultUserPoolClientProps = exports.DefaultIdentityPoolProps = void 0;
const DefaultUserPoolProps = {};
exports.DefaultUserPoolProps = DefaultUserPoolProps;
function DefaultIdentityPoolProps(userPoolClientId, userPoolProviderName) {
    return {
        allowUnauthenticatedIdentities: false,
        cognitoIdentityProviders: [{
                clientId: userPoolClientId,
                providerName: userPoolProviderName,
                serverSideTokenCheck: true
            }]
    };
}
exports.DefaultIdentityPoolProps = DefaultIdentityPoolProps;
function DefaultUserPoolClientProps(userpool) {
    return {
        userPool: userpool
    };
}
exports.DefaultUserPoolClientProps = DefaultUserPoolClientProps;
//# sourceMappingURL=data:application/json;base64,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