__all__ = ["Result", "Results"]

from abc import ABCMeta, abstractmethod

from java.lang import Object


class Result(ABCMeta):
    @abstractmethod
    def getDisplayPath(cls):
        pass

    @abstractmethod
    def getPath(cls):
        pass

    @abstractmethod
    def getType(cls):
        pass

    @abstractmethod
    def hasChildren(cls):
        pass


class Results(Object):
    """The results of a browse operation.

    May only represent a partial result set, which can be determined by
    comparing the Total Available Size to the Returned Size. If there is
    a mismatch, the continuation point should be non-null and can be
    used in constructing the subsequent BrowseFilter to continue the
    browse.
    """

    def error(self, result):
        pass

    def getContinuationPoint(self):
        pass

    def getResultQuality(self):
        pass

    def getResults(self):
        pass

    def getReturnedSize(self):
        pass

    def getTotalAvailableSize(self):
        pass

    def of(self, arg):
        pass

    def setContinuationPoint(self, continuationPoint):
        pass

    def setResultQuality(self, value):
        pass

    def setResults(self, results):
        pass

    def setTotalAvailableResults(self, totalAvailableResults):
        pass
