import { Construct } from 'constructs';
import * as k8s from './imports/k8s';
export interface ServiceDeploymentOptions {
    /**
     * @default 1
     */
    readonly replicas?: number;
    /**
     * Container image.
     */
    readonly image: string;
    /**
     * Additional labels to apply to resources.
     * @default - none
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * Pod resource requirements
     * @default - cpu: '100m', memory: '100Mi'
     */
    readonly resources?: k8s.ResourceRequirements;
    /**
     * @default 80
     */
    readonly externalPort?: number;
    /**
     * @default 8080
     */
    readonly containerPort?: number;
    /**
     * Environment variables to pass to the pod
     */
    readonly env?: {
        [name: string]: string;
    };
    /**
     * The name of the container
     * @default 'app'
     */
    readonly containerName?: string;
    /**
     * The type of service resource.
     * @default ServiceType.CLUSTER_IP
     */
    readonly serviceType?: ServiceType;
}
export declare enum ServiceType {
    EXTERNAL_NAME = "ExternalName",
    CLUSTER_IP = "ClusterIP",
    NODE_PORT = "NodePort",
    LOAD_BALANCER = "LoadBalancer"
}
export declare class ServiceDeployment extends Construct {
    readonly host: string;
    constructor(scope: Construct, id: string, options: ServiceDeploymentOptions);
}
