# 使用方式
- 安裝 FastAPI
```shell
pip install fastapi
```
- 執行測試的 server，在這個 folder下執行
```shell
fastapi dev main.py
```
## 本地測試
 - 如果在 local 測試: http://127.0.0.1:8000/api/botrun/botrun_ask_folder/這裡接自己的 api 名稱
 - 線上測試：/api/botrun/botrun_ask_folder/這裡接自己的 api 名稱

## 要使用 firestore 來建立 queue ，需要幫它建 index
### 參考圖片  
![firestore index](https://i.ibb.co/PmqgtV7/2024-08-22-7-46-32.png)

## 測試 功能
### 青創貸款 
```bash
curl -X POST http://0.0.0.0:8080/api/botrun/botrun_ask_folder/pub-process-folder \
-H "Content-Type: application/json" \
-d '{"folder_id": "1qk5maEqbxtTcr1tsAHawVduonPedpHV0", "force":true}'
```

### 青創貸款 (不要 embed)
```bash
curl -X POST http://0.0.0.0:8080/api/botrun/botrun_ask_folder/pub-process-folder \
-H "Content-Type: application/json" \
-d '{"folder_id": "1qk5maEqbxtTcr1tsAHawVduonPedpHV0", "force":false, "embed":false}'
```

### 清除所有 job
```bash
curl -X POST http://0.0.0.0:8080/api/botrun/botrun_ask_folder/complete-all-jobs 
```
### 查看 folder 處理進度
```bash
curl -X POST http://0.0.0.0:8080/api/botrun/botrun_ask_folder/folder-status \
-H "Content-Type: application/json" \
-d '{"folder_id": "1qk5maEqbxtTcr1tsAHawVduonPedpHV0"}'
```

## Cloud run 測試
### 青創貸款 
```bash
curl -X POST https://botrun-ask-folder-fastapi-thrhobrjtq-de.a.run.app/api/botrun/botrun_ask_folder/pub-process-folder \
-H "Content-Type: application/json" \
-d '{"folder_id": "1qk5maEqbxtTcr1tsAHawVduonPedpHV0", "force":true}'
```

### 青創貸款 (不要 embed)
```bash
curl -X POST https://botrun-ask-folder-fastapi-thrhobrjtq-de.a.run.app/api/botrun/botrun_ask_folder/pub-process-folder \
-H "Content-Type: application/json" \
-d '{"folder_id": "1qk5maEqbxtTcr1tsAHawVduonPedpHV0", "force":true, "embed":false}'
```
### 清除所有 job
```bash
curl -X POST https://botrun-ask-folder-fastapi-thrhobrjtq-de.a.run.app/api/botrun/botrun_ask_folder/complete-all-jobs 
```

### 查看 folder 處理進度
```bash
curl -X POST https://botrun-ask-folder-fastapi-thrhobrjtq-de.a.run.app/api/botrun/botrun_ask_folder/folder-status \
-H "Content-Type: application/json" \
-d '{"folder_id": "1qk5maEqbxtTcr1tsAHawVduonPedpHV0"}'
```

### 做壓力測試的網頁
- https://botrun-ask-folder-fastapi-thrhobrjtq-de.a.run.app/api/botrun/botrun_ask_folder/stress