"use strict";
const cdk = require("@aws-cdk/core");
const stepfunctions = require("../lib");
function render(sm) {
    return new cdk.Stack().resolve(new stepfunctions.StateGraph(sm.startState, 'Test Graph').toGraphJson());
}
module.exports = {
    'State Machine With Parallel State'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const parallel = new stepfunctions.Parallel(stack, 'Parallel State');
        parallel.branch(new stepfunctions.Pass(stack, 'Branch 1'));
        parallel.branch(new stepfunctions.Pass(stack, 'Branch 2'));
        // THEN
        test.deepEqual(render(parallel), {
            StartAt: 'Parallel State',
            States: {
                'Parallel State': {
                    Type: 'Parallel',
                    End: true,
                    Branches: [
                        { StartAt: 'Branch 1', States: { 'Branch 1': { Type: 'Pass', End: true } } },
                        { StartAt: 'Branch 2', States: { 'Branch 2': { Type: 'Pass', End: true } } }
                    ]
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5wYXJhbGxlbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlc3QucGFyYWxsZWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHFDQUFxQztBQUVyQyx3Q0FBd0M7QUErQnhDLFNBQVMsTUFBTSxDQUFDLEVBQTRCO0lBQ3hDLE9BQU8sSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMsT0FBTyxDQUFDLElBQUksYUFBYSxDQUFDLFVBQVUsQ0FBQyxFQUFFLENBQUMsVUFBVSxFQUFFLFlBQVksQ0FBQyxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7QUFDNUcsQ0FBQztBQS9CRCxpQkFBUztJQUNMLG1DQUFtQyxDQUFDLElBQVU7UUFDMUMsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBRTlCLE9BQU87UUFDUCxNQUFNLFFBQVEsR0FBRyxJQUFJLGFBQWEsQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLGdCQUFnQixDQUFDLENBQUM7UUFDckUsUUFBUSxDQUFDLE1BQU0sQ0FBQyxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLFVBQVUsQ0FBQyxDQUFDLENBQUM7UUFDM0QsUUFBUSxDQUFDLE1BQU0sQ0FBQyxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLFVBQVUsQ0FBQyxDQUFDLENBQUM7UUFFM0QsT0FBTztRQUNQLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxFQUFFO1lBQzdCLE9BQU8sRUFBRSxnQkFBZ0I7WUFDekIsTUFBTSxFQUFFO2dCQUNKLGdCQUFnQixFQUFFO29CQUNkLElBQUksRUFBRSxVQUFVO29CQUNoQixHQUFHLEVBQUUsSUFBSTtvQkFDVCxRQUFRLEVBQUU7d0JBQ04sRUFBRSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sRUFBRSxFQUFFLFVBQVUsRUFBRSxFQUFFLElBQUksRUFBRSxNQUFNLEVBQUUsR0FBRyxFQUFFLElBQUksRUFBRSxFQUFFLEVBQUU7d0JBQzVFLEVBQUUsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLEVBQUUsRUFBRSxVQUFVLEVBQUUsRUFBRSxJQUFJLEVBQUUsTUFBTSxFQUFFLEdBQUcsRUFBRSxJQUFJLEVBQUUsRUFBRSxFQUFFO3FCQUMvRTtpQkFDSjthQUNKO1NBQ0osQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2hCLENBQUM7Q0FDSixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgVGVzdCB9IGZyb20gJ25vZGV1bml0JztcbmltcG9ydCAqIGFzIHN0ZXBmdW5jdGlvbnMgZnJvbSAnLi4vbGliJztcblxuZXhwb3J0ID0ge1xuICAgICdTdGF0ZSBNYWNoaW5lIFdpdGggUGFyYWxsZWwgU3RhdGUnKHRlc3Q6IFRlc3QpIHtcbiAgICAgICAgLy8gR0lWRU5cbiAgICAgICAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKCk7XG5cbiAgICAgICAgLy8gV0hFTlxuICAgICAgICBjb25zdCBwYXJhbGxlbCA9IG5ldyBzdGVwZnVuY3Rpb25zLlBhcmFsbGVsKHN0YWNrLCAnUGFyYWxsZWwgU3RhdGUnKTtcbiAgICAgICAgcGFyYWxsZWwuYnJhbmNoKG5ldyBzdGVwZnVuY3Rpb25zLlBhc3Moc3RhY2ssICdCcmFuY2ggMScpKTtcbiAgICAgICAgcGFyYWxsZWwuYnJhbmNoKG5ldyBzdGVwZnVuY3Rpb25zLlBhc3Moc3RhY2ssICdCcmFuY2ggMicpKTtcblxuICAgICAgICAvLyBUSEVOXG4gICAgICAgIHRlc3QuZGVlcEVxdWFsKHJlbmRlcihwYXJhbGxlbCksIHtcbiAgICAgICAgICAgIFN0YXJ0QXQ6ICdQYXJhbGxlbCBTdGF0ZScsXG4gICAgICAgICAgICBTdGF0ZXM6IHtcbiAgICAgICAgICAgICAgICAnUGFyYWxsZWwgU3RhdGUnOiB7XG4gICAgICAgICAgICAgICAgICAgIFR5cGU6ICdQYXJhbGxlbCcsXG4gICAgICAgICAgICAgICAgICAgIEVuZDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgQnJhbmNoZXM6IFtcbiAgICAgICAgICAgICAgICAgICAgICAgIHsgU3RhcnRBdDogJ0JyYW5jaCAxJywgU3RhdGVzOiB7ICdCcmFuY2ggMSc6IHsgVHlwZTogJ1Bhc3MnLCBFbmQ6IHRydWUgfSB9IH0sXG4gICAgICAgICAgICAgICAgICAgICAgICB7IFN0YXJ0QXQ6ICdCcmFuY2ggMicsIFN0YXRlczogeyAnQnJhbmNoIDInOiB7IFR5cGU6ICdQYXNzJywgRW5kOiB0cnVlIH0gfSB9XG4gICAgICAgICAgICAgICAgICAgIF1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pO1xuXG4gICAgICAgIHRlc3QuZG9uZSgpO1xuICAgIH1cbn07XG5cbmZ1bmN0aW9uIHJlbmRlcihzbTogc3RlcGZ1bmN0aW9ucy5JQ2hhaW5hYmxlKSB7XG4gICAgcmV0dXJuIG5ldyBjZGsuU3RhY2soKS5yZXNvbHZlKG5ldyBzdGVwZnVuY3Rpb25zLlN0YXRlR3JhcGgoc20uc3RhcnRTdGF0ZSwgJ1Rlc3QgR3JhcGgnKS50b0dyYXBoSnNvbigpKTtcbn1cbiJdfQ==