"use strict";
const lib_1 = require("../lib");
module.exports = {
    'deep replace correctly handles fields in arrays'(test) {
        test.deepEqual(lib_1.FieldUtils.renderObject({
            unknown: undefined,
            bool: true,
            literal: 'literal',
            field: lib_1.Data.stringAt('$.stringField'),
            listField: lib_1.Data.listAt('$.listField'),
            deep: [
                'literal',
                {
                    deepField: lib_1.Data.numberAt('$.numField'),
                }
            ]
        }), {
            'bool': true,
            'literal': 'literal',
            'field.$': '$.stringField',
            'listField.$': '$.listField',
            'deep': [
                'literal',
                {
                    'deepField.$': '$.numField'
                }
            ],
        });
        test.done();
    },
    'exercise contextpaths'(test) {
        test.deepEqual(lib_1.FieldUtils.renderObject({
            str: lib_1.Context.stringAt('$$.Execution.StartTime'),
            count: lib_1.Context.numberAt('$$.State.RetryCount'),
            token: lib_1.Context.taskToken,
            entire: lib_1.Context.entireContext
        }), {
            'str.$': '$$.Execution.StartTime',
            'count.$': '$$.State.RetryCount',
            'token.$': '$$.Task.Token',
            'entire.$': '$$'
        });
        test.done();
    },
    'find all referenced paths'(test) {
        test.deepEqual(lib_1.FieldUtils.findReferencedPaths({
            bool: false,
            literal: 'literal',
            field: lib_1.Data.stringAt('$.stringField'),
            listField: lib_1.Data.listAt('$.listField'),
            deep: [
                'literal',
                {
                    field: lib_1.Data.stringAt('$.stringField'),
                    deepField: lib_1.Data.numberAt('$.numField'),
                }
            ]
        }), [
            '$.listField',
            '$.numField',
            '$.stringField',
        ]);
        test.done();
    },
    'cannot have JsonPath fields in arrays'(test) {
        test.throws(() => {
            lib_1.FieldUtils.renderObject({
                deep: [lib_1.Data.stringAt('$.hello')]
            });
        }, /Cannot use JsonPath fields in an array/);
        test.done();
    },
    'datafield path must be correct'(test) {
        test.ok(lib_1.Data.stringAt('$'));
        test.throws(() => {
            lib_1.Data.stringAt('$hello');
        }, /exactly equal to '\$' or start with '\$.'/);
        test.throws(() => {
            lib_1.Data.stringAt('hello');
        }, /exactly equal to '\$' or start with '\$.'/);
        test.done();
    },
    'context path must be correct'(test) {
        test.ok(lib_1.Context.stringAt('$$'));
        test.throws(() => {
            lib_1.Context.stringAt('$$hello');
        }, /exactly equal to '\$\$' or start with '\$\$.'/);
        test.throws(() => {
            lib_1.Context.stringAt('hello');
        }, /exactly equal to '\$\$' or start with '\$\$.'/);
        test.done();
    },
    'test contains task token'(test) {
        test.equal(true, lib_1.FieldUtils.containsTaskToken({
            field: lib_1.Context.taskToken
        }));
        test.equal(true, lib_1.FieldUtils.containsTaskToken({
            field: lib_1.Context.stringAt('$$.Task'),
        }));
        test.equal(true, lib_1.FieldUtils.containsTaskToken({
            field: lib_1.Context.entireContext
        }));
        test.equal(false, lib_1.FieldUtils.containsTaskToken({
            oops: 'not here'
        }));
        test.equal(false, lib_1.FieldUtils.containsTaskToken({
            oops: lib_1.Context.stringAt('$$.Execution.StartTime')
        }));
        test.done();
    },
    'arbitrary JSONPath fields are not replaced'(test) {
        test.deepEqual(lib_1.FieldUtils.renderObject({
            field: '$.content',
        }), {
            field: '$.content'
        });
        test.done();
    },
    'fields cannot be used somewhere in a string interpolation'(test) {
        test.throws(() => {
            lib_1.FieldUtils.renderObject({
                field: `contains ${lib_1.Data.stringAt('$.hello')}`
            });
        }, /Field references must be the entire string/);
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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