"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Predefined error strings
 * Error names in Amazon States Language - https://docs.aws.amazon.com/step-functions/latest/dg/concepts-error-handling.html
 */
class Errors {
}
exports.Errors = Errors;
/**
 * Matches any Error.
 */
Errors.ALL = 'States.ALL';
/**
 * A Task State either ran longer than the “TimeoutSeconds” value, or
 * failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
 */
Errors.TIMEOUT = 'States.Timeout';
/**
 * A Task State failed during the execution.
 */
Errors.TASKS_FAILED = 'States.TaskFailed';
/**
 * A Task State failed because it had insufficient privileges to execute
 * the specified code.
 */
Errors.PERMISSIONS = 'States.Permissions';
/**
 * A Task State’s “ResultPath” field cannot be applied to the input the state received.
 */
Errors.RESULT_PATH_MATCH_FAILURE = 'States.ResultPathMatchFailure';
/**
 * A branch of a Parallel state failed.
 */
Errors.BRANCH_FAILED = 'States.BranchFailed';
/**
 * A Choice state failed to find a match for the condition field extracted
 * from its input.
 */
Errors.NO_CHOICE_MATCHED = 'States.NoChoiceMatched';
/**
 * Special string value to discard state input, output or result
 */
exports.DISCARD = 'DISCARD';
//# sourceMappingURL=data:application/json;base64,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