import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

water_MFP = np.array([
	[5.00000E+03, 1.7992702856E+00, 8.3554546461E+00, 2.3888074252E-02, 2.3508748507E-02, 3.5128247063E-01],
	[5.00500E+03, 1.8013278450E+00, 8.3502550737E+00, 2.3960541002E-02, 2.3579240226E-02, 3.5154097082E-01],
	[5.01000E+03, 1.8033856994E+00, 8.3450639239E+00, 2.4033154898E-02, 2.3649870654E-02, 3.5179914498E-01],
	[5.01500E+03, 1.8054438485E+00, 8.3398811747E+00, 2.4105916092E-02, 2.3720639914E-02, 3.5205699381E-01],
	[5.02000E+03, 1.8075022919E+00, 8.3347068042E+00, 2.4178824737E-02, 2.3791548128E-02, 3.5231451809E-01],
	[5.02500E+03, 1.8095610296E+00, 8.3295407904E+00, 2.4251880982E-02, 2.3862595420E-02, 3.5257171859E-01],
	[5.03000E+03, 1.8116200611E+00, 8.3243831116E+00, 2.4325084981E-02, 2.3933781913E-02, 3.5282859608E-01],
	[5.03500E+03, 1.8136793864E+00, 8.3192337461E+00, 2.4398436884E-02, 2.4005107729E-02, 3.5308515131E-01],
	[5.04000E+03, 1.8157390050E+00, 8.3140926722E+00, 2.4471936843E-02, 2.4076572992E-02, 3.5334138504E-01],
	[5.04500E+03, 1.8177989168E+00, 8.3089598683E+00, 2.4545585009E-02, 2.4148177823E-02, 3.5359729804E-01],
	[5.05000E+03, 1.8198591216E+00, 8.3038353131E+00, 2.4619381534E-02, 2.4219922345E-02, 3.5385289105E-01],
	[5.05500E+03, 1.8219551960E+00, 8.2989242386E+00, 2.4693326570E-02, 2.4291814765E-02, 3.5410816483E-01],
	[5.06000E+03, 1.8240560048E+00, 8.2940462370E+00, 2.4767420268E-02, 2.4363848199E-02, 3.5436312011E-01],
	[5.06500E+03, 1.8261571575E+00, 8.2891759161E+00, 2.4841662779E-02, 2.4436021777E-02, 3.5461775765E-01],
	[5.07000E+03, 1.8282586538E+00, 8.2843132564E+00, 2.4916054255E-02, 2.4508335622E-02, 3.5487207819E-01],
	[5.07500E+03, 1.8303604934E+00, 8.2794582381E+00, 2.4990594848E-02, 2.4580789857E-02, 3.5512608247E-01],
	[5.08000E+03, 1.8324626760E+00, 8.2746108419E+00, 2.5065284709E-02, 2.4653384604E-02, 3.5537977122E-01],
	[5.08500E+03, 1.8345652014E+00, 8.2697710482E+00, 2.5140123990E-02, 2.4726119987E-02, 3.5563314517E-01],
	[5.09000E+03, 1.8366680692E+00, 8.2649388377E+00, 2.5215112842E-02, 2.4798996127E-02, 3.5588620507E-01],
	[5.09500E+03, 1.8387712792E+00, 8.2601141910E+00, 2.5290251416E-02, 2.4872013146E-02, 3.5613895163E-01],
	[5.10000E+03, 1.8408748312E+00, 8.2552970889E+00, 2.5365539865E-02, 2.4945171169E-02, 3.5639138558E-01],
	[5.10500E+03, 1.8429787247E+00, 8.2504875123E+00, 2.5440978340E-02, 2.5018470315E-02, 3.5664350765E-01],
	[5.11000E+03, 1.8450829597E+00, 8.2456854420E+00, 2.5516566993E-02, 2.5091910709E-02, 3.5689531854E-01],
	[5.11500E+03, 1.8471875356E+00, 8.2408908589E+00, 2.5592305975E-02, 2.5165492473E-02, 3.5714681900E-01],
	[5.12000E+03, 1.8492924524E+00, 8.2361037442E+00, 2.5668195437E-02, 2.5239215727E-02, 3.5739800971E-01],
	[5.12500E+03, 1.8513977097E+00, 8.2313240788E+00, 2.5744235532E-02, 2.5313080595E-02, 3.5764889141E-01],
	[5.13000E+03, 1.8535033072E+00, 8.2265518440E+00, 2.5820426410E-02, 2.5387087198E-02, 3.5789946479E-01],
	[5.13500E+03, 1.8556092447E+00, 8.2217870210E+00, 2.5896768224E-02, 2.5461235659E-02, 3.5814973057E-01],
	[5.14000E+03, 1.8577155219E+00, 8.2170295910E+00, 2.5973261125E-02, 2.5535526099E-02, 3.5839968945E-01],
	[5.14500E+03, 1.8598221385E+00, 8.2122795354E+00, 2.6049905264E-02, 2.5609958640E-02, 3.5864934213E-01],
	[5.15000E+03, 1.8619290942E+00, 8.2075368357E+00, 2.6126700794E-02, 2.5684533404E-02, 3.5889868931E-01],
	[5.15500E+03, 1.8640363888E+00, 8.2028014733E+00, 2.6203647866E-02, 2.5759250512E-02, 3.5914773169E-01],
	[5.16000E+03, 1.8661440219E+00, 8.1980734297E+00, 2.6280746631E-02, 2.5834110086E-02, 3.5939646997E-01],
	[5.16500E+03, 1.8682519934E+00, 8.1933526866E+00, 2.6357997242E-02, 2.5909112248E-02, 3.5964490482E-01],
	[5.17000E+03, 1.8703603029E+00, 8.1886392257E+00, 2.6435399849E-02, 2.5984257119E-02, 3.5989303695E-01],
	[5.17500E+03, 1.8724689502E+00, 8.1839330287E+00, 2.6512954604E-02, 2.6059544821E-02, 3.6014086703E-01],
	[5.18000E+03, 1.8745779349E+00, 8.1792340773E+00, 2.6590661660E-02, 2.6134975474E-02, 3.6038839576E-01],
	[5.18500E+03, 1.8766872569E+00, 8.1745423536E+00, 2.6668521167E-02, 2.6210549200E-02, 3.6063562382E-01],
	[5.19000E+03, 1.8787969158E+00, 8.1698578393E+00, 2.6746533277E-02, 2.6286266120E-02, 3.6088255188E-01],
	[5.19500E+03, 1.8809069114E+00, 8.1651805165E+00, 2.6824698143E-02, 2.6362126355E-02, 3.6112918062E-01],
	[5.20000E+03, 1.8830172435E+00, 8.1605103673E+00, 2.6903015915E-02, 2.6438130027E-02, 3.6137551072E-01],
	[5.20500E+03, 1.8851279116E+00, 8.1558473737E+00, 2.6981486745E-02, 2.6514277257E-02, 3.6162154285E-01],
	[5.21000E+03, 1.8872389156E+00, 8.1511915179E+00, 2.7060110786E-02, 2.6590568164E-02, 3.6186727767E-01],
	[5.21500E+03, 1.8893502553E+00, 8.1465427822E+00, 2.7138888187E-02, 2.6667002871E-02, 3.6211271586E-01],
	[5.22000E+03, 1.8914619302E+00, 8.1419011489E+00, 2.7217819103E-02, 2.6743581497E-02, 3.6235785808E-01],
	[5.22500E+03, 1.8935739402E+00, 8.1372666003E+00, 2.7296903683E-02, 2.6820304164E-02, 3.6260270499E-01],
	[5.23000E+03, 1.8956862850E+00, 8.1326391189E+00, 2.7376142079E-02, 2.6897170992E-02, 3.6284725726E-01],
	[5.23500E+03, 1.8977989644E+00, 8.1280186871E+00, 2.7455534445E-02, 2.6974182102E-02, 3.6309151553E-01],
	[5.24000E+03, 1.8999119780E+00, 8.1234052875E+00, 2.7535080930E-02, 2.7051337614E-02, 3.6333548048E-01],
	[5.24500E+03, 1.9020253256E+00, 8.1187989027E+00, 2.7614781686E-02, 2.7128637649E-02, 3.6357915274E-01],
	[5.25000E+03, 1.9041390069E+00, 8.1141995154E+00, 2.7694636867E-02, 2.7206082326E-02, 3.6382253297E-01],
	[5.25500E+03, 1.9062754235E+00, 8.1097327876E+00, 2.7774646622E-02, 2.7283677779E-02, 3.6406562182E-01],
	[5.26000E+03, 1.9084271659E+00, 8.1053565740E+00, 2.7854811104E-02, 2.7361422200E-02, 3.6430841997E-01],
	[5.26500E+03, 1.9105792893E+00, 8.1009868765E+00, 2.7935130465E-02, 2.7439311716E-02, 3.6455092818E-01],
	[5.27000E+03, 1.9127317932E+00, 8.0966236793E+00, 2.8015604855E-02, 2.7517346446E-02, 3.6479314715E-01],
	[5.27500E+03, 1.9148846776E+00, 8.0922669663E+00, 2.8096234428E-02, 2.7595526512E-02, 3.6503507761E-01],
	[5.28000E+03, 1.9170379420E+00, 8.0879167220E+00, 2.8177019335E-02, 2.7673852034E-02, 3.6527672028E-01],
	[5.28500E+03, 1.9191915861E+00, 8.0835729306E+00, 2.8257959727E-02, 2.7752323132E-02, 3.6551807588E-01],
	[5.29000E+03, 1.9213456098E+00, 8.0792355764E+00, 2.8339055756E-02, 2.7830939926E-02, 3.6575914511E-01],
	[5.29500E+03, 1.9235000126E+00, 8.0749046438E+00, 2.8420307574E-02, 2.7909702536E-02, 3.6599992870E-01],
	[5.30000E+03, 1.9256547943E+00, 8.0705801173E+00, 2.8501715332E-02, 2.7988611084E-02, 3.6624042734E-01],
	[5.30500E+03, 1.9278099547E+00, 8.0662619813E+00, 2.8583279184E-02, 2.8067665688E-02, 3.6648064174E-01],
	[5.31000E+03, 1.9299654933E+00, 8.0619502204E+00, 2.8664999279E-02, 2.8146866469E-02, 3.6672057261E-01],
	[5.31500E+03, 1.9321214100E+00, 8.0576448193E+00, 2.8746875770E-02, 2.8226213547E-02, 3.6696022065E-01],
	[5.32000E+03, 1.9342777044E+00, 8.0533457624E+00, 2.8828908808E-02, 2.8305707042E-02, 3.6719958654E-01],
	[5.32500E+03, 1.9364343762E+00, 8.0490530346E+00, 2.8911098546E-02, 2.8385347073E-02, 3.6743867098E-01],
	[5.33000E+03, 1.9385914252E+00, 8.0447666206E+00, 2.8993445136E-02, 2.8465133760E-02, 3.6767747468E-01],
	[5.33500E+03, 1.9407488511E+00, 8.0404865052E+00, 2.9075948728E-02, 2.8545067223E-02, 3.6791599830E-01],
	[5.34000E+03, 1.9429066536E+00, 8.0362126733E+00, 2.9158609475E-02, 2.8625147581E-02, 3.6815424255E-01],
	[5.34500E+03, 1.9450648323E+00, 8.0319451098E+00, 2.9241427528E-02, 2.8705374954E-02, 3.6839220810E-01],
	[5.35000E+03, 1.9472233871E+00, 8.0276837995E+00, 2.9324403040E-02, 2.8785749461E-02, 3.6862989563E-01],
	[5.35500E+03, 1.9493823175E+00, 8.0234287276E+00, 2.9407536162E-02, 2.8866271222E-02, 3.6886730583E-01],
	[5.36000E+03, 1.9515416234E+00, 8.0191798791E+00, 2.9490827046E-02, 2.8946940356E-02, 3.6910443936E-01],
	[5.36500E+03, 1.9537013045E+00, 8.0149372390E+00, 2.9574275843E-02, 2.9027756983E-02, 3.6934129690E-01],
	[5.37000E+03, 1.9558613604E+00, 8.0107007926E+00, 2.9657882706E-02, 2.9108721220E-02, 3.6957787912E-01],
	[5.37500E+03, 1.9580217910E+00, 8.0064705250E+00, 2.9741647787E-02, 2.9189833188E-02, 3.6981418670E-01],
	[5.38000E+03, 1.9601825958E+00, 8.0022464215E+00, 2.9825571236E-02, 2.9271093005E-02, 3.7005022028E-01],
	[5.38500E+03, 1.9623437746E+00, 7.9980284675E+00, 2.9909653206E-02, 2.9352500791E-02, 3.7028598054E-01],
	[5.39000E+03, 1.9645053272E+00, 7.9938166481E+00, 2.9993893849E-02, 2.9434056664E-02, 3.7052146814E-01],
	[5.39500E+03, 1.9666672532E+00, 7.9896109490E+00, 3.0078293317E-02, 2.9515760742E-02, 3.7075668373E-01],
	[5.40000E+03, 1.9688295524E+00, 7.9854113554E+00, 3.0162851761E-02, 2.9597613146E-02, 3.7099162797E-01],
	[5.40500E+03, 1.9709922245E+00, 7.9812178529E+00, 3.0247569333E-02, 2.9679613993E-02, 3.7122630151E-01],
	[5.41000E+03, 1.9731552691E+00, 7.9770304270E+00, 3.0332446186E-02, 2.9761763402E-02, 3.7146070500E-01],
	[5.41500E+03, 1.9753186861E+00, 7.9728490634E+00, 3.0417482470E-02, 2.9844061491E-02, 3.7169483909E-01],
	[5.42000E+03, 1.9774824752E+00, 7.9686737476E+00, 3.0502678338E-02, 2.9926508379E-02, 3.7192870442E-01],
	[5.42500E+03, 1.9796466360E+00, 7.9645044654E+00, 3.0588033942E-02, 3.0009104184E-02, 3.7216230165E-01],
	[5.43000E+03, 1.9818111683E+00, 7.9603412025E+00, 3.0673549433E-02, 3.0091849025E-02, 3.7239563140E-01],
	[5.43500E+03, 1.9839760719E+00, 7.9561839446E+00, 3.0759224963E-02, 3.0174743020E-02, 3.7262869432E-01],
	[5.44000E+03, 1.9861413463E+00, 7.9520326776E+00, 3.0845060685E-02, 3.0257786286E-02, 3.7286149103E-01],
	[5.44500E+03, 1.9883069914E+00, 7.9478873873E+00, 3.0931056750E-02, 3.0340978943E-02, 3.7309402219E-01],
	[5.45000E+03, 1.9904730069E+00, 7.9437480598E+00, 3.1017213309E-02, 3.0424321107E-02, 3.7332628841E-01],
	[5.45500E+03, 1.9926393925E+00, 7.9396146809E+00, 3.1103530516E-02, 3.0507812897E-02, 3.7355829032E-01],
	[5.46000E+03, 1.9948061480E+00, 7.9354872366E+00, 3.1190008521E-02, 3.0591454431E-02, 3.7379002855E-01],
	[5.46500E+03, 1.9969976667E+00, 7.9314993918E+00, 3.1276647477E-02, 3.0675253581E-02, 3.7402150373E-01],
	[5.47000E+03, 1.9991999371E+00, 7.9275738309E+00, 3.1363447535E-02, 3.0759206081E-02, 3.7425271648E-01],
	[5.47500E+03, 2.0014026207E+00, 7.9236537969E+00, 3.1450408848E-02, 3.0843308774E-02, 3.7448366741E-01],
	[5.48000E+03, 2.0036057172E+00, 7.9197392769E+00, 3.1537921020E-02, 3.0927936313E-02, 3.7471435714E-01],
	[5.48500E+03, 2.0058092263E+00, 7.9158302582E+00, 3.1625910819E-02, 3.1013018159E-02, 3.7494478629E-01],
	[5.49000E+03, 2.0080131476E+00, 7.9119267280E+00, 3.1714065597E-02, 3.1098253590E-02, 3.7517495544E-01],
	[5.49500E+03, 2.0102174810E+00, 7.9080286736E+00, 3.1802385514E-02, 3.1183642731E-02, 3.7540486483E-01],
	[5.50000E+03, 2.0124222260E+00, 7.9041360825E+00, 3.1890870728E-02, 3.1269185705E-02, 3.7563451502E-01],
	[5.50500E+03, 2.0146273825E+00, 7.9002489418E+00, 3.1979521398E-02, 3.1354882634E-02, 3.7586390670E-01],
	[5.51000E+03, 2.0168329500E+00, 7.8963672392E+00, 3.2068337682E-02, 3.1440733643E-02, 3.7609304058E-01],
	[5.51500E+03, 2.0190389284E+00, 7.8924909620E+00, 3.2157319740E-02, 3.1526738854E-02, 3.7632191736E-01],
	[5.52000E+03, 2.0212453172E+00, 7.8886200978E+00, 3.2246467730E-02, 3.1612898390E-02, 3.7655053773E-01],
	[5.52500E+03, 2.0234521163E+00, 7.8847546341E+00, 3.2335781810E-02, 3.1699212374E-02, 3.7677890239E-01],
	[5.53000E+03, 2.0256593253E+00, 7.8808945585E+00, 3.2425262140E-02, 3.1785680929E-02, 3.7700701201E-01],
	[5.53500E+03, 2.0278669439E+00, 7.8770398587E+00, 3.2514908878E-02, 3.1872304178E-02, 3.7723486730E-01],
	[5.54000E+03, 2.0300749719E+00, 7.8731905222E+00, 3.2604722182E-02, 3.1959082244E-02, 3.7746246892E-01],
	[5.54500E+03, 2.0322834089E+00, 7.8693465368E+00, 3.2694702213E-02, 3.2046015249E-02, 3.7768981757E-01],
	[5.55000E+03, 2.0344922546E+00, 7.8655078903E+00, 3.2784849127E-02, 3.2133103316E-02, 3.7791691393E-01],
	[5.55500E+03, 2.0367015087E+00, 7.8616745705E+00, 3.2875163085E-02, 3.2220346567E-02, 3.7814375865E-01],
	[5.56000E+03, 2.0389111711E+00, 7.8578465650E+00, 3.2965644244E-02, 3.2307745125E-02, 3.7837035243E-01],
	[5.56500E+03, 2.0411212413E+00, 7.8540238620E+00, 3.3056292764E-02, 3.2395299112E-02, 3.7859669593E-01],
	[5.57000E+03, 2.0433317190E+00, 7.8502064491E+00, 3.3147108804E-02, 3.2483008651E-02, 3.7882278981E-01],
	[5.57500E+03, 2.0455426041E+00, 7.8463943144E+00, 3.3238092521E-02, 3.2570873863E-02, 3.7904863474E-01],
	[5.58000E+03, 2.0477538961E+00, 7.8425874459E+00, 3.3329244076E-02, 3.2658894871E-02, 3.7927423139E-01],
	[5.58500E+03, 2.0499655949E+00, 7.8387858315E+00, 3.3420563626E-02, 3.2747071798E-02, 3.7949958041E-01],
	[5.59000E+03, 2.0521777001E+00, 7.8349894593E+00, 3.3512051331E-02, 3.2835404764E-02, 3.7972468245E-01],
	[5.59500E+03, 2.0543902113E+00, 7.8311983174E+00, 3.3603707349E-02, 3.2923893891E-02, 3.7994953818E-01],
	[5.60000E+03, 2.0566031285E+00, 7.8274123940E+00, 3.3695531839E-02, 3.3012539303E-02, 3.8017414824E-01],
	[5.60500E+03, 2.0588164511E+00, 7.8236316772E+00, 3.3787524961E-02, 3.3101341120E-02, 3.8039851328E-01],
	[5.61000E+03, 2.0610301791E+00, 7.8198561551E+00, 3.3879686872E-02, 3.3190299464E-02, 3.8062263395E-01],
	[5.61500E+03, 2.0632443120E+00, 7.8160858162E+00, 3.3972017732E-02, 3.3279414457E-02, 3.8084651090E-01],
	[5.62000E+03, 2.0654588496E+00, 7.8123206485E+00, 3.4064517699E-02, 3.3368686219E-02, 3.8107014475E-01],
	[5.62500E+03, 2.0676737916E+00, 7.8085606405E+00, 3.4157186933E-02, 3.3458114874E-02, 3.8129353616E-01],
	[5.63000E+03, 2.0698891377E+00, 7.8048057805E+00, 3.4250025592E-02, 3.3547700542E-02, 3.8151668575E-01],
	[5.63500E+03, 2.0721048876E+00, 7.8010560569E+00, 3.4343033836E-02, 3.3637443344E-02, 3.8173959416E-01],
	[5.64000E+03, 2.0743210411E+00, 7.7973114581E+00, 3.4436211822E-02, 3.3727343402E-02, 3.8196226203E-01],
	[5.64500E+03, 2.0765375979E+00, 7.7935719725E+00, 3.4529559710E-02, 3.3817400836E-02, 3.8218468997E-01],
	[5.65000E+03, 2.0787545576E+00, 7.7898375888E+00, 3.4623077659E-02, 3.3907615768E-02, 3.8240687862E-01],
	[5.65500E+03, 2.0809719200E+00, 7.7861082953E+00, 3.4716765828E-02, 3.3997988319E-02, 3.8262882860E-01],
	[5.66000E+03, 2.0831896848E+00, 7.7823840807E+00, 3.4810624376E-02, 3.4088518610E-02, 3.8285054053E-01],
	[5.66500E+03, 2.0854078518E+00, 7.7786649336E+00, 3.4904653461E-02, 3.4179206762E-02, 3.8307201503E-01],
	[5.67000E+03, 2.0876264206E+00, 7.7749508426E+00, 3.4998853243E-02, 3.4270052894E-02, 3.8329325271E-01],
	[5.67500E+03, 2.0898453910E+00, 7.7712417964E+00, 3.5093223880E-02, 3.4361057129E-02, 3.8351425420E-01],
	[5.68000E+03, 2.0920690488E+00, 7.7675608892E+00, 3.5187765531E-02, 3.4452221204E-02, 3.8373502009E-01],
	[5.68500E+03, 2.0943209350E+00, 7.7640347106E+00, 3.5282478356E-02, 3.4543554168E-02, 3.8395555101E-01],
	[5.69000E+03, 2.0965732622E+00, 7.7605132306E+00, 3.5377362513E-02, 3.4635045699E-02, 3.8417584755E-01],
	[5.69500E+03, 2.0988260302E+00, 7.7569964389E+00, 3.5472418162E-02, 3.4726695918E-02, 3.8439591033E-01],
	[5.70000E+03, 2.1010792386E+00, 7.7534843249E+00, 3.5567645460E-02, 3.4818504944E-02, 3.8461573993E-01],
	[5.70500E+03, 2.1033328871E+00, 7.7499768785E+00, 3.5663044568E-02, 3.4910472899E-02, 3.8483533698E-01],
	[5.71000E+03, 2.1055869755E+00, 7.7464740894E+00, 3.5758615644E-02, 3.5002599904E-02, 3.8505470205E-01],
	[5.71500E+03, 2.1078415034E+00, 7.7429759472E+00, 3.5854358848E-02, 3.5094886078E-02, 3.8527383575E-01],
	[5.72000E+03, 2.1100964705E+00, 7.7394824418E+00, 3.5950274338E-02, 3.5187331543E-02, 3.8549273866E-01],
	[5.72500E+03, 2.1123518766E+00, 7.7359935630E+00, 3.6046362273E-02, 3.5279936420E-02, 3.8571141139E-01],
	[5.73000E+03, 2.1146077213E+00, 7.7325093006E+00, 3.6142622812E-02, 3.5372700827E-02, 3.8592985452E-01],
	[5.73500E+03, 2.1168640043E+00, 7.7290296445E+00, 3.6239056114E-02, 3.5465624887E-02, 3.8614806863E-01],
	[5.74000E+03, 2.1191207254E+00, 7.7255545846E+00, 3.6335662339E-02, 3.5558708718E-02, 3.8636605431E-01],
	[5.74500E+03, 2.1213778842E+00, 7.7220841108E+00, 3.6432441646E-02, 3.5651952441E-02, 3.8658381214E-01],
	[5.75000E+03, 2.1236354805E+00, 7.7186182131E+00, 3.6529394192E-02, 3.5745356176E-02, 3.8680134270E-01],
	[5.75500E+03, 2.1258935140E+00, 7.7151568815E+00, 3.6626520139E-02, 3.5838920043E-02, 3.8701864656E-01],
	[5.76000E+03, 2.1281519843E+00, 7.7117001060E+00, 3.6723819644E-02, 3.5932644162E-02, 3.8723572431E-01],
	[5.76500E+03, 2.1304108911E+00, 7.7082478767E+00, 3.6821292866E-02, 3.6026528652E-02, 3.8745257652E-01],
	[5.77000E+03, 2.1326702343E+00, 7.7048001836E+00, 3.6918939965E-02, 3.6120573635E-02, 3.8766920375E-01],
	[5.77500E+03, 2.1349300134E+00, 7.7013570169E+00, 3.7016761100E-02, 3.6214779228E-02, 3.8788560658E-01],
	[5.78000E+03, 2.1371902282E+00, 7.6979183666E+00, 3.7114756430E-02, 3.6309145552E-02, 3.8810178557E-01],
	[5.78500E+03, 2.1394508783E+00, 7.6944842231E+00, 3.7212926115E-02, 3.6403672726E-02, 3.8831774128E-01],
	[5.79000E+03, 2.1417119636E+00, 7.6910545765E+00, 3.7311270312E-02, 3.6498360869E-02, 3.8853347429E-01],
	[5.79500E+03, 2.1439734837E+00, 7.6876294170E+00, 3.7409789181E-02, 3.6593210102E-02, 3.8874898514E-01],
	[5.80000E+03, 2.1462354383E+00, 7.6842087349E+00, 3.7508482882E-02, 3.6688220543E-02, 3.8896427441E-01],
	[5.80500E+03, 2.1484978271E+00, 7.6807925205E+00, 3.7607351574E-02, 3.6783392311E-02, 3.8917934263E-01],
	[5.81000E+03, 2.1507606499E+00, 7.6773807641E+00, 3.7706395415E-02, 3.6878725525E-02, 3.8939419038E-01],
	[5.81500E+03, 2.1530239063E+00, 7.6739734561E+00, 3.7805614565E-02, 3.6974220305E-02, 3.8960881819E-01],
	[5.82000E+03, 2.1552875961E+00, 7.6705705868E+00, 3.7905009183E-02, 3.7069876770E-02, 3.8982322662E-01],
	[5.82500E+03, 2.1575517189E+00, 7.6671721467E+00, 3.8004579428E-02, 3.7165695038E-02, 3.9003741622E-01],
	[5.83000E+03, 2.1598162745E+00, 7.6637781262E+00, 3.8104325460E-02, 3.7261675228E-02, 3.9025138754E-01],
	[5.83500E+03, 2.1620812625E+00, 7.6603885158E+00, 3.8204247437E-02, 3.7357817458E-02, 3.9046514111E-01],
	[5.84000E+03, 2.1643466828E+00, 7.6570033059E+00, 3.8304345519E-02, 3.7454121849E-02, 3.9067867749E-01],
	[5.84500E+03, 2.1666125350E+00, 7.6536224872E+00, 3.8404619864E-02, 3.7550588517E-02, 3.9089199720E-01],
	[5.85000E+03, 2.1688788188E+00, 7.6502460501E+00, 3.8505070633E-02, 3.7647217581E-02, 3.9110510079E-01],
	[5.85500E+03, 2.1711455339E+00, 7.6468739852E+00, 3.8605697984E-02, 3.7744009161E-02, 3.9131798879E-01],
	[5.86000E+03, 2.1734126801E+00, 7.6435062832E+00, 3.8706502077E-02, 3.7840963373E-02, 3.9153066175E-01],
	[5.86500E+03, 2.1756802570E+00, 7.6401429346E+00, 3.8807483070E-02, 3.7938080337E-02, 3.9174312018E-01],
	[5.87000E+03, 2.1779482645E+00, 7.6367839303E+00, 3.8908641124E-02, 3.8035360171E-02, 3.9195536462E-01],
	[5.87500E+03, 2.1802167021E+00, 7.6334292607E+00, 3.9009976397E-02, 3.8132802991E-02, 3.9216739561E-01],
	[5.88000E+03, 2.1824855696E+00, 7.6300789168E+00, 3.9111489048E-02, 3.8230408918E-02, 3.9237921365E-01],
	[5.88500E+03, 2.1847548667E+00, 7.6267328892E+00, 3.9213179237E-02, 3.8328178068E-02, 3.9259081929E-01],
	[5.89000E+03, 2.1870245932E+00, 7.6233911686E+00, 3.9315047123E-02, 3.8426110559E-02, 3.9280221304E-01],
	[5.89500E+03, 2.1892947488E+00, 7.6200537460E+00, 3.9417092865E-02, 3.8524206509E-02, 3.9301339542E-01],
	[5.90000E+03, 2.1915653331E+00, 7.6167206122E+00, 3.9519316623E-02, 3.8622466035E-02, 3.9322436696E-01],
	[5.90500E+03, 2.1938363459E+00, 7.6133917579E+00, 3.9621718556E-02, 3.8720889256E-02, 3.9343512816E-01],
	[5.91000E+03, 2.1961321500E+00, 7.6101969832E+00, 3.9724298822E-02, 3.8819487279E-02, 3.9364567955E-01],
	[5.91500E+03, 2.1984335085E+00, 7.6070333641E+00, 3.9827057583E-02, 3.8918251627E-02, 3.9385602163E-01],
	[5.92000E+03, 2.2007353311E+00, 7.6038737315E+00, 3.9929994996E-02, 3.9017180131E-02, 3.9406615492E-01],
	[5.92500E+03, 2.2030376174E+00, 7.6007180772E+00, 4.0033111221E-02, 3.9116272907E-02, 3.9427607994E-01],
	[5.93000E+03, 2.2053403672E+00, 7.5975663927E+00, 4.0136406418E-02, 3.9215530074E-02, 3.9448579719E-01],
	[5.93500E+03, 2.2076435800E+00, 7.5944186697E+00, 4.0239880745E-02, 3.9314951750E-02, 3.9469530739E-01],
	[5.94000E+03, 2.2099472558E+00, 7.5912748998E+00, 4.0343534362E-02, 3.9414538051E-02, 3.9490461117E-01],
	[5.94500E+03, 2.2122513941E+00, 7.5881350749E+00, 4.0447367429E-02, 3.9514289096E-02, 3.9511370911E-01],
	[5.95000E+03, 2.2145559946E+00, 7.5849991866E+00, 4.0551380105E-02, 3.9614205002E-02, 3.9532260180E-01],
	[5.95500E+03, 2.2168610571E+00, 7.5818672267E+00, 4.0655572548E-02, 3.9714285885E-02, 3.9553128981E-01],
	[5.96000E+03, 2.2191665812E+00, 7.5787391871E+00, 4.0759944919E-02, 3.9814531864E-02, 3.9573977372E-01],
	[5.96500E+03, 2.2214725667E+00, 7.5756150594E+00, 4.0864497377E-02, 3.9914943055E-02, 3.9594805409E-01],
	[5.97000E+03, 2.2237790133E+00, 7.5724948355E+00, 4.0969230082E-02, 4.0015519576E-02, 3.9615613151E-01],
	[5.97500E+03, 2.2260859207E+00, 7.5693785074E+00, 4.1074143192E-02, 4.0116261543E-02, 3.9636400654E-01],
	[5.98000E+03, 2.2283932885E+00, 7.5662660668E+00, 4.1179236867E-02, 4.0217169073E-02, 3.9657167974E-01],
	[5.98500E+03, 2.2307011165E+00, 7.5631575057E+00, 4.1284511266E-02, 4.0318242283E-02, 3.9677915168E-01],
	[5.99000E+03, 2.2330094044E+00, 7.5600528161E+00, 4.1389966549E-02, 4.0419481290E-02, 3.9698642293E-01],
	[5.99500E+03, 2.2353181519E+00, 7.5569519898E+00, 4.1495602876E-02, 4.0520886210E-02, 3.9719349404E-01],
	[6.00000E+03, 2.2376273588E+00, 7.5538550188E+00, 4.1601420405E-02, 4.0622457160E-02, 3.9740036558E-01],
	[6.00500E+03, 2.2399370246E+00, 7.5507618952E+00, 4.1707856326E-02, 4.0724610924E-02, 3.9760703809E-01],
	[6.01000E+03, 2.2422471492E+00, 7.5476726109E+00, 4.1814475633E-02, 4.0826932655E-02, 3.9781351213E-01],
	[6.01500E+03, 2.2445577322E+00, 7.5445871581E+00, 4.1921278491E-02, 4.0929422475E-02, 3.9801978825E-01],
	[6.02000E+03, 2.2468687734E+00, 7.5415055287E+00, 4.2028265061E-02, 4.1032080500E-02, 3.9822586701E-01],
	[6.02500E+03, 2.2491802724E+00, 7.5384277149E+00, 4.2135435506E-02, 4.1134906851E-02, 3.9843174894E-01],
	[6.03000E+03, 2.2514922290E+00, 7.5353537088E+00, 4.2242789991E-02, 4.1237901646E-02, 3.9863743460E-01],
	[6.03500E+03, 2.2538046429E+00, 7.5322835025E+00, 4.2350328677E-02, 4.1341065004E-02, 3.9884292453E-01],
	[6.04000E+03, 2.2561175137E+00, 7.5292170882E+00, 4.2458051729E-02, 4.1444397044E-02, 3.9904821926E-01],
	[6.04500E+03, 2.2584308413E+00, 7.5261544581E+00, 4.2565959308E-02, 4.1547897884E-02, 3.9925331935E-01],
	[6.05000E+03, 2.2607446253E+00, 7.5230956043E+00, 4.2674051578E-02, 4.1651567643E-02, 3.9945822531E-01],
	[6.05500E+03, 2.2630588654E+00, 7.5200405192E+00, 4.2782328703E-02, 4.1755406439E-02, 3.9966293770E-01],
	[6.06000E+03, 2.2653735613E+00, 7.5169891949E+00, 4.2890790845E-02, 4.1859414391E-02, 3.9986745704E-01],
	[6.06500E+03, 2.2676887128E+00, 7.5139416237E+00, 4.2999438167E-02, 4.1963591616E-02, 4.0007178386E-01],
	[6.07000E+03, 2.2700043196E+00, 7.5108977980E+00, 4.3108270832E-02, 4.2067938234E-02, 4.0027591869E-01],
	[6.07500E+03, 2.2723203813E+00, 7.5078577100E+00, 4.3217289004E-02, 4.2172454362E-02, 4.0047986207E-01],
	[6.08000E+03, 2.2746368978E+00, 7.5048213521E+00, 4.3326492846E-02, 4.2277140119E-02, 4.0068361450E-01],
	[6.08500E+03, 2.2769538687E+00, 7.5017887166E+00, 4.3435882520E-02, 4.2381995621E-02, 4.0088717653E-01],
	[6.09000E+03, 2.2792712937E+00, 7.4987597959E+00, 4.3545458191E-02, 4.2487020987E-02, 4.0109054866E-01],
	[6.09500E+03, 2.2815891725E+00, 7.4957345825E+00, 4.3655220020E-02, 4.2592216336E-02, 4.0129373142E-01],
	[6.10000E+03, 2.2839075049E+00, 7.4927130687E+00, 4.3765168172E-02, 4.2697581783E-02, 4.0149672532E-01],
	[6.10500E+03, 2.2862262906E+00, 7.4896952471E+00, 4.3875302809E-02, 4.2803117448E-02, 4.0169953088E-01],
	[6.11000E+03, 2.2885455292E+00, 7.4866811100E+00, 4.3985624095E-02, 4.2908823447E-02, 4.0190214861E-01],
	[6.11500E+03, 2.2908652206E+00, 7.4836706500E+00, 4.4096132193E-02, 4.3014699898E-02, 4.0210457903E-01],
	[6.12000E+03, 2.2931853645E+00, 7.4806638595E+00, 4.4206827265E-02, 4.3120746919E-02, 4.0230682264E-01],
	[6.12500E+03, 2.2955059604E+00, 7.4776607312E+00, 4.4317709476E-02, 4.3226964626E-02, 4.0250887995E-01],
	[6.13000E+03, 2.2978270083E+00, 7.4746612576E+00, 4.4428778989E-02, 4.3333353136E-02, 4.0271075147E-01],
	[6.13500E+03, 2.3001485077E+00, 7.4716654312E+00, 4.4540035966E-02, 4.3439912568E-02, 4.0291243769E-01],
	[6.14000E+03, 2.3024704584E+00, 7.4686732446E+00, 4.4651480570E-02, 4.3546643037E-02, 4.0311393914E-01],
	[6.14500E+03, 2.3048121050E+00, 7.4657861434E+00, 4.4763112967E-02, 4.3653555033E-02, 4.0331525629E-01],
	[6.15000E+03, 2.3071619592E+00, 7.4629432168E+00, 4.4874933317E-02, 4.3760642565E-02, 4.0351638965E-01],
	[6.15500E+03, 2.3095122965E+00, 7.4601036818E+00, 4.4986941785E-02, 4.3867901601E-02, 4.0371733972E-01],
	[6.16000E+03, 2.3118631167E+00, 7.4572675316E+00, 4.5099138534E-02, 4.3975332258E-02, 4.0391810700E-01],
	[6.16500E+03, 2.3142144196E+00, 7.4544347595E+00, 4.5211523727E-02, 4.4082934652E-02, 4.0411869197E-01],
	[6.17000E+03, 2.3165662047E+00, 7.4516053588E+00, 4.5324097528E-02, 4.4190708902E-02, 4.0431909513E-01],
	[6.17500E+03, 2.3189184718E+00, 7.4487793225E+00, 4.5436860099E-02, 4.4298655124E-02, 4.0451931696E-01],
	[6.18000E+03, 2.3212712207E+00, 7.4459566442E+00, 4.5549811605E-02, 4.4406773434E-02, 4.0471935795E-01],
	[6.18500E+03, 2.3236244509E+00, 7.4431373169E+00, 4.5662952208E-02, 4.4515063951E-02, 4.0491921860E-01],
	[6.19000E+03, 2.3259781624E+00, 7.4403213341E+00, 4.5776282072E-02, 4.4623526789E-02, 4.0511889938E-01],
	[6.19500E+03, 2.3283323546E+00, 7.4375086891E+00, 4.5889801359E-02, 4.4732162067E-02, 4.0531840077E-01],
	[6.20000E+03, 2.3306870274E+00, 7.4346993753E+00, 4.6003510235E-02, 4.4840969899E-02, 4.0551772326E-01],
	[6.20500E+03, 2.3330421805E+00, 7.4318933860E+00, 4.6117408861E-02, 4.4949950404E-02, 4.0571686733E-01],
	[6.21000E+03, 2.3353978136E+00, 7.4290907146E+00, 4.6231497401E-02, 4.5059103697E-02, 4.0591583345E-01],
	[6.21500E+03, 2.3377539264E+00, 7.4262913545E+00, 4.6345776018E-02, 4.5168429894E-02, 4.0611462210E-01],
	[6.22000E+03, 2.3401105185E+00, 7.4234952991E+00, 4.6460244877E-02, 4.5277929112E-02, 4.0631323375E-01],
	[6.22500E+03, 2.3424675898E+00, 7.4207025420E+00, 4.6574904140E-02, 4.5387601466E-02, 4.0651166887E-01],
	[6.23000E+03, 2.3448251399E+00, 7.4179130765E+00, 4.6689753970E-02, 4.5497447073E-02, 4.0670992794E-01],
	[6.23500E+03, 2.3471831685E+00, 7.4151268962E+00, 4.6804794532E-02, 4.5607466048E-02, 4.0690801142E-01],
	[6.24000E+03, 2.3495416754E+00, 7.4123439945E+00, 4.6920025987E-02, 4.5717658508E-02, 4.0710591979E-01],
	[6.24500E+03, 2.3519006603E+00, 7.4095643650E+00, 4.7035448501E-02, 4.5828024567E-02, 4.0730365350E-01],
	[6.25000E+03, 2.3542601228E+00, 7.4067880012E+00, 4.7151062236E-02, 4.5938564343E-02, 4.0750121302E-01],
	[6.25500E+03, 2.3566200627E+00, 7.4040148966E+00, 4.7266867356E-02, 4.6049277949E-02, 4.0769859881E-01],
	[6.26000E+03, 2.3589804797E+00, 7.4012450449E+00, 4.7382864025E-02, 4.6160165502E-02, 4.0789581133E-01],
	[6.26500E+03, 2.3613413736E+00, 7.3984784396E+00, 4.7499052404E-02, 4.6271227117E-02, 4.0809285105E-01],
	[6.27000E+03, 2.3637027440E+00, 7.3957150744E+00, 4.7615432659E-02, 4.6382462910E-02, 4.0828971841E-01],
	[6.27500E+03, 2.3660645907E+00, 7.3929549427E+00, 4.7732004953E-02, 4.6493872994E-02, 4.0848641389E-01],
	[6.28000E+03, 2.3684269133E+00, 7.3901980384E+00, 4.7848769449E-02, 4.6605457487E-02, 4.0868293792E-01],
	[6.28500E+03, 2.3707897116E+00, 7.3874443551E+00, 4.7965726310E-02, 4.6717216502E-02, 4.0887929096E-01],
	[6.29000E+03, 2.3731529853E+00, 7.3846938864E+00, 4.8082875700E-02, 4.6829150154E-02, 4.0907547346E-01],
	[6.29500E+03, 2.3755167342E+00, 7.3819466260E+00, 4.8200217783E-02, 4.6941258559E-02, 4.0927148588E-01],
	[6.30000E+03, 2.3778809579E+00, 7.3792025677E+00, 4.8317752722E-02, 4.7053541831E-02, 4.0946732866E-01],
	[6.30500E+03, 2.3802456561E+00, 7.3764617052E+00, 4.8435480681E-02, 4.7166000084E-02, 4.0966300225E-01],
	[6.31000E+03, 2.3826108286E+00, 7.3737240322E+00, 4.8553401823E-02, 4.7278633434E-02, 4.0985850709E-01],
	[6.31500E+03, 2.3849764752E+00, 7.3709895425E+00, 4.8671516312E-02, 4.7391441995E-02, 4.1005384362E-01],
	[6.32000E+03, 2.3873425954E+00, 7.3682582299E+00, 4.8789824310E-02, 4.7504425881E-02, 4.1024901229E-01],
	[6.32500E+03, 2.3897091891E+00, 7.3655300882E+00, 4.8908325983E-02, 4.7617585206E-02, 4.1044401354E-01],
	[6.33000E+03, 2.3920762559E+00, 7.3628051111E+00, 4.9027021493E-02, 4.7730920085E-02, 4.1063884780E-01],
	[6.33500E+03, 2.3944437957E+00, 7.3600832926E+00, 4.9145911005E-02, 4.7844430632E-02, 4.1083351552E-01],
	[6.34000E+03, 2.3968118080E+00, 7.3573646265E+00, 4.9264994680E-02, 4.7958116960E-02, 4.1102801714E-01],
	[6.34500E+03, 2.3991802926E+00, 7.3546491066E+00, 4.9384272684E-02, 4.8071979185E-02, 4.1122235325E-01],
	[6.35000E+03, 2.4015492493E+00, 7.3519367269E+00, 4.9503745180E-02, 4.8186017419E-02, 4.1141652433E-01],
	[6.35500E+03, 2.4039186778E+00, 7.3492274812E+00, 4.9623412331E-02, 4.8300231776E-02, 4.1161053087E-01],
	[6.36000E+03, 2.4062885777E+00, 7.3465213634E+00, 4.9743274302E-02, 4.8414622370E-02, 4.1180437333E-01],
	[6.36500E+03, 2.4086589488E+00, 7.3438183675E+00, 4.9863331255E-02, 4.8529189315E-02, 4.1199805218E-01],
	[6.37000E+03, 2.4110297909E+00, 7.3411184874E+00, 4.9983583354E-02, 4.8643932724E-02, 4.1219156790E-01],
	[6.37500E+03, 2.4134011037E+00, 7.3384217172E+00, 5.0104030763E-02, 4.8758852711E-02, 4.1238492096E-01],
	[6.38000E+03, 2.4157728868E+00, 7.3357280507E+00, 5.0224673646E-02, 4.8873949388E-02, 4.1257811183E-01],
	[6.38500E+03, 2.4181451401E+00, 7.3330374820E+00, 5.0345512166E-02, 4.8989222869E-02, 4.1277114096E-01],
	[6.39000E+03, 2.4205356010E+00, 7.3304426420E+00, 5.0466546487E-02, 4.9104684724E-02, 4.1296400882E-01],
	[6.39500E+03, 2.4229334334E+00, 7.3278866369E+00, 5.0587776772E-02, 4.9220328156E-02, 4.1315671588E-01],
	[6.40000E+03, 2.4253317644E+00, 7.3253335197E+00, 5.0709203186E-02, 4.9336148853E-02, 4.1334926259E-01],
	[6.40500E+03, 2.4277305937E+00, 7.3227832848E+00, 5.0830825893E-02, 4.9452146929E-02, 4.1354164941E-01],
	[6.41000E+03, 2.4301299208E+00, 7.3202359268E+00, 5.0952645054E-02, 4.9568322496E-02, 4.1373387680E-01],
	[6.41500E+03, 2.4325297457E+00, 7.3176914401E+00, 5.1074660836E-02, 4.9684675668E-02, 4.1392594521E-01],
	[6.42000E+03, 2.4349300679E+00, 7.3151498193E+00, 5.1196873400E-02, 4.9801206559E-02, 4.1411785511E-01],
	[6.42500E+03, 2.4373308872E+00, 7.3126110589E+00, 5.1319282911E-02, 4.9917915281E-02, 4.1430960693E-01],
	[6.43000E+03, 2.4397322033E+00, 7.3100751535E+00, 5.1441889533E-02, 5.0034801947E-02, 4.1450120114E-01],
	[6.43500E+03, 2.4421340159E+00, 7.3075420977E+00, 5.1564693430E-02, 5.0151866670E-02, 4.1469263818E-01],
	[6.44000E+03, 2.4445363248E+00, 7.3050118860E+00, 5.1687694765E-02, 5.0269109563E-02, 4.1488391849E-01],
	[6.44500E+03, 2.4469391296E+00, 7.3024845131E+00, 5.1810893701E-02, 5.0386530739E-02, 4.1507504253E-01],
	[6.45000E+03, 2.4493424302E+00, 7.2999599735E+00, 5.1934290404E-02, 5.0504130309E-02, 4.1526601073E-01],
	[6.45500E+03, 2.4517462261E+00, 7.2974382619E+00, 5.2057885036E-02, 5.0621908388E-02, 4.1545682355E-01],
	[6.46000E+03, 2.4541505171E+00, 7.2949193729E+00, 5.2181677761E-02, 5.0739865086E-02, 4.1564748141E-01],
	[6.46500E+03, 2.4565553029E+00, 7.2924033013E+00, 5.2305668743E-02, 5.0858000517E-02, 4.1583798477E-01],
	[6.47000E+03, 2.4589605834E+00, 7.2898900416E+00, 5.2429858147E-02, 5.0976314792E-02, 4.1602833406E-01],
	[6.47500E+03, 2.4613663580E+00, 7.2873795885E+00, 5.2554246135E-02, 5.1094808024E-02, 4.1621852971E-01],
	[6.48000E+03, 2.4637726267E+00, 7.2848719369E+00, 5.2678832872E-02, 5.1213480324E-02, 4.1640857216E-01],
	[6.48500E+03, 2.4661793891E+00, 7.2823670813E+00, 5.2803618521E-02, 5.1332331806E-02, 4.1659846185E-01],
	[6.49000E+03, 2.4685866449E+00, 7.2798650165E+00, 5.2928603246E-02, 5.1451362580E-02, 4.1678819920E-01],
	[6.49500E+03, 2.4709943938E+00, 7.2773657373E+00, 5.3053787212E-02, 5.1570572758E-02, 4.1697778465E-01],
	[6.50000E+03, 2.4734026357E+00, 7.2748692384E+00, 5.3179170581E-02, 5.1689962452E-02, 4.1716721863E-01],
	[6.50500E+03, 2.4758113701E+00, 7.2723755145E+00, 5.3304753519E-02, 5.1809531773E-02, 4.1735650156E-01],
	[6.51000E+03, 2.4782205968E+00, 7.2698845606E+00, 5.3430536188E-02, 5.1929280834E-02, 4.1754563387E-01],
	[6.51500E+03, 2.4806303156E+00, 7.2673963712E+00, 5.3556518753E-02, 5.2049209745E-02, 4.1773461599E-01],
	[6.52000E+03, 2.4830405261E+00, 7.2649109414E+00, 5.3682701377E-02, 5.2169318618E-02, 4.1792344834E-01],
	[6.52500E+03, 2.4854512282E+00, 7.2624282659E+00, 5.3809084225E-02, 5.2289607564E-02, 4.1811213133E-01],
	[6.53000E+03, 2.4878624214E+00, 7.2599483395E+00, 5.3935667461E-02, 5.2410076694E-02, 4.1830066540E-01],
	[6.53500E+03, 2.4902741056E+00, 7.2574711572E+00, 5.4062451247E-02, 5.2530726119E-02, 4.1848905096E-01],
	[6.54000E+03, 2.4926862804E+00, 7.2549967137E+00, 5.4189435749E-02, 5.2651555949E-02, 4.1867728842E-01],
	[6.54500E+03, 2.4950989456E+00, 7.2525250039E+00, 5.4316621130E-02, 5.2772566297E-02, 4.1886537821E-01],
	[6.55000E+03, 2.4975121009E+00, 7.2500560228E+00, 5.4444007554E-02, 5.2893757272E-02, 4.1905332074E-01],
	[6.55500E+03, 2.4999257460E+00, 7.2475897653E+00, 5.4571595185E-02, 5.3015128986E-02, 4.1924111641E-01],
	[6.56000E+03, 2.5023398807E+00, 7.2451262262E+00, 5.4699384187E-02, 5.3136681548E-02, 4.1942876566E-01],
	[6.56500E+03, 2.5047545047E+00, 7.2426654006E+00, 5.4827374725E-02, 5.3258415069E-02, 4.1961626888E-01],
	[6.57000E+03, 2.5071696177E+00, 7.2402072833E+00, 5.4955566961E-02, 5.3380329660E-02, 4.1980362648E-01],
	[6.57500E+03, 2.5095852194E+00, 7.2377518693E+00, 5.5083961060E-02, 5.3502425431E-02, 4.1999083887E-01],
	[6.58000E+03, 2.5120013096E+00, 7.2352991536E+00, 5.5212557187E-02, 5.3624702492E-02, 4.2017790647E-01],
	[6.58500E+03, 2.5144178880E+00, 7.2328491312E+00, 5.5341355504E-02, 5.3747160952E-02, 4.2036482967E-01],
	[6.59000E+03, 2.5168349543E+00, 7.2304017971E+00, 5.5470356176E-02, 5.3869800923E-02, 4.2055160887E-01],
	[6.59500E+03, 2.5192525082E+00, 7.2279571463E+00, 5.5599559368E-02, 5.3992622514E-02, 4.2073824449E-01],
	[6.60000E+03, 2.5216705495E+00, 7.2255151738E+00, 5.5728965242E-02, 5.4115625834E-02, 4.2092473692E-01],
	[6.60500E+03, 2.5240890779E+00, 7.2230758746E+00, 5.5858573964E-02, 5.4238810994E-02, 4.2111108656E-01],
	[6.61000E+03, 2.5265080932E+00, 7.2206392439E+00, 5.5988385696E-02, 5.4362178103E-02, 4.2129729382E-01],
	[6.61500E+03, 2.5289275950E+00, 7.2182052767E+00, 5.6118400604E-02, 5.4485727271E-02, 4.2148335908E-01],
	[6.62000E+03, 2.5313475831E+00, 7.2157739680E+00, 5.6248618852E-02, 5.4609458606E-02, 4.2166928275E-01],
	[6.62500E+03, 2.5337680572E+00, 7.2133453130E+00, 5.6379040602E-02, 5.4733372219E-02, 4.2185506521E-01],
	[6.63000E+03, 2.5361890171E+00, 7.2109193068E+00, 5.6509666021E-02, 5.4857468218E-02, 4.2204070687E-01],
	[6.63500E+03, 2.5386104625E+00, 7.2084959444E+00, 5.6640495270E-02, 5.4981746713E-02, 4.2222620812E-01],
	[6.64000E+03, 2.5410323931E+00, 7.2060752210E+00, 5.6771528516E-02, 5.5106207812E-02, 4.2241156934E-01],
	[6.64500E+03, 2.5434719994E+00, 7.2037469297E+00, 5.6902765921E-02, 5.5230865010E-02, 4.2259679093E-01],
	[6.65000E+03, 2.5459171448E+00, 7.2014474050E+00, 5.7034207650E-02, 5.5355709061E-02, 4.2278187327E-01],
	[6.65500E+03, 2.5483628004E+00, 7.1991503418E+00, 5.7165853867E-02, 5.5480736171E-02, 4.2296681676E-01],
	[6.66000E+03, 2.5508089659E+00, 7.1968557357E+00, 5.7297704736E-02, 5.5605946450E-02, 4.2315162177E-01],
	[6.66500E+03, 2.5532556410E+00, 7.1945635821E+00, 5.7429760421E-02, 5.5731340007E-02, 4.2333628870E-01],
	[6.67000E+03, 2.5557028255E+00, 7.1922738767E+00, 5.7562021087E-02, 5.5856916951E-02, 4.2352081792E-01],
	[6.67500E+03, 2.5581505192E+00, 7.1899866149E+00, 5.7694486898E-02, 5.5982677391E-02, 4.2370520982E-01],
	[6.68000E+03, 2.5605987216E+00, 7.1877017924E+00, 5.7827158017E-02, 5.6108621435E-02, 4.2388946478E-01],
	[6.68500E+03, 2.5630474326E+00, 7.1854194046E+00, 5.7960034609E-02, 5.6234749193E-02, 4.2407358319E-01],
	[6.69000E+03, 2.5654966519E+00, 7.1831394473E+00, 5.8093116839E-02, 5.6361060773E-02, 4.2425756541E-01],
	[6.69500E+03, 2.5679463792E+00, 7.1808619160E+00, 5.8226404869E-02, 5.6487556283E-02, 4.2444141182E-01],
	[6.70000E+03, 2.5703966141E+00, 7.1785868062E+00, 5.8359898866E-02, 5.6614235832E-02, 4.2462512282E-01],
	[6.70500E+03, 2.5728473566E+00, 7.1763141137E+00, 5.8493598992E-02, 5.6741099529E-02, 4.2480869875E-01],
	[6.71000E+03, 2.5752986062E+00, 7.1740438341E+00, 5.8627505411E-02, 5.6868147482E-02, 4.2499214001E-01],
	[6.71500E+03, 2.5777503627E+00, 7.1717759629E+00, 5.8761618289E-02, 5.6995379798E-02, 4.2517544697E-01],
	[6.72000E+03, 2.5802026259E+00, 7.1695104959E+00, 5.8895937790E-02, 5.7122796586E-02, 4.2535861999E-01],
	[6.72500E+03, 2.5826553954E+00, 7.1672474288E+00, 5.9030464077E-02, 5.7250397954E-02, 4.2554165947E-01],
	[6.73000E+03, 2.5851086710E+00, 7.1649867571E+00, 5.9165197315E-02, 5.7378184010E-02, 4.2572456585E-01],
	[6.73500E+03, 2.5875624525E+00, 7.1627284766E+00, 5.9300137668E-02, 5.7506154861E-02, 4.2590733953E-01],
	[6.74000E+03, 2.5900167394E+00, 7.1604725830E+00, 5.9435285301E-02, 5.7634310615E-02, 4.2608998091E-01],
	[6.74500E+03, 2.5924715317E+00, 7.1582190720E+00, 5.9570640377E-02, 5.7762651380E-02, 4.2627249035E-01],
	[6.75000E+03, 2.5949268289E+00, 7.1559679393E+00, 5.9706203061E-02, 5.7891177264E-02, 4.2645486826E-01],
	[6.75500E+03, 2.5973826309E+00, 7.1537191806E+00, 5.9841973518E-02, 5.8019888373E-02, 4.2663711501E-01],
	[6.76000E+03, 2.5998389374E+00, 7.1514727918E+00, 5.9977951911E-02, 5.8148784814E-02, 4.2681923098E-01],
	[6.76500E+03, 2.6022957480E+00, 7.1492287684E+00, 6.0114138405E-02, 5.8277866696E-02, 4.2700121656E-01],
	[6.77000E+03, 2.6047530626E+00, 7.1469871064E+00, 6.0250533164E-02, 5.8407134125E-02, 4.2718307212E-01],
	[6.77500E+03, 2.6072108808E+00, 7.1447478014E+00, 6.0387136353E-02, 5.8536587208E-02, 4.2736479804E-01],
	[6.78000E+03, 2.6096692024E+00, 7.1425108494E+00, 6.0523948136E-02, 5.8666226053E-02, 4.2754639470E-01],
	[6.78500E+03, 2.6121280271E+00, 7.1402762459E+00, 6.0660968676E-02, 5.8796050765E-02, 4.2772786247E-01],
	[6.79000E+03, 2.6145873547E+00, 7.1380439869E+00, 6.0798198140E-02, 5.8926061451E-02, 4.2790920174E-01],
	[6.79500E+03, 2.6170471848E+00, 7.1358140682E+00, 6.0935636690E-02, 5.9056258219E-02, 4.2809041286E-01],
	[6.80000E+03, 2.6195075173E+00, 7.1335864856E+00, 6.1073284491E-02, 5.9186641175E-02, 4.2827149622E-01],
	[6.80500E+03, 2.6219683518E+00, 7.1313612350E+00, 6.1211141709E-02, 5.9317210424E-02, 4.2845245219E-01],
	[6.81000E+03, 2.6244296881E+00, 7.1291383121E+00, 6.1349208506E-02, 5.9447966074E-02, 4.2863328113E-01],
	[6.81500E+03, 2.6268915260E+00, 7.1269177129E+00, 6.1487485047E-02, 5.9578908231E-02, 4.2881398342E-01],
	[6.82000E+03, 2.6293538650E+00, 7.1246994332E+00, 6.1625971498E-02, 5.9710037000E-02, 4.2899455941E-01],
	[6.82500E+03, 2.6318167051E+00, 7.1224834689E+00, 6.1764668021E-02, 5.9841352488E-02, 4.2917500949E-01],
	[6.83000E+03, 2.6342800458E+00, 7.1202698159E+00, 6.1903574783E-02, 5.9972854801E-02, 4.2935533401E-01],
	[6.83500E+03, 2.6367438871E+00, 7.1180584701E+00, 6.2042691946E-02, 6.0104544044E-02, 4.2953553333E-01],
	[6.84000E+03, 2.6392082285E+00, 7.1158494274E+00, 6.2182019676E-02, 6.0236420323E-02, 4.2971560783E-01],
	[6.84500E+03, 2.6416730698E+00, 7.1136426837E+00, 6.2321558136E-02, 6.0368483743E-02, 4.2989555785E-01],
	[6.85000E+03, 2.6441384108E+00, 7.1114382349E+00, 6.2461307492E-02, 6.0500734412E-02, 4.3007538378E-01],
	[6.85500E+03, 2.6466042512E+00, 7.1092360771E+00, 6.2601267908E-02, 6.0633172432E-02, 4.3025508595E-01],
	[6.86000E+03, 2.6490705908E+00, 7.1070362061E+00, 6.2741439548E-02, 6.0765797911E-02, 4.3043466473E-01],
	[6.86500E+03, 2.6515374292E+00, 7.1048386178E+00, 6.2881822577E-02, 6.0898610953E-02, 4.3061412049E-01],
	[6.87000E+03, 2.6540047662E+00, 7.1026433084E+00, 6.3022417160E-02, 6.1031611663E-02, 4.3079345356E-01],
	[6.87500E+03, 2.6564726016E+00, 7.1004502737E+00, 6.3163223460E-02, 6.1164800147E-02, 4.3097266432E-01],
	[6.88000E+03, 2.6589409350E+00, 7.0982595097E+00, 6.3304241642E-02, 6.1298176508E-02, 4.3115175311E-01],
	[6.88500E+03, 2.6614097663E+00, 7.0960710125E+00, 6.3445471870E-02, 6.1431740853E-02, 4.3133072029E-01],
	[6.89000E+03, 2.6638790952E+00, 7.0938847781E+00, 6.3586914311E-02, 6.1565493286E-02, 4.3150956621E-01],
	[6.89500E+03, 2.6663489213E+00, 7.0917008024E+00, 6.3728569126E-02, 6.1699433910E-02, 4.3168829122E-01],
	[6.90000E+03, 2.6688192445E+00, 7.0895190816E+00, 6.3870436482E-02, 6.1833562832E-02, 4.3186689567E-01],
	[6.90500E+03, 2.6712900645E+00, 7.0873396116E+00, 6.4012516543E-02, 6.1967880155E-02, 4.3204537991E-01],
	[6.91000E+03, 2.6737771234E+00, 7.0852455427E+00, 6.4154809474E-02, 6.2102400864E-02, 4.3222374428E-01],
	[6.91500E+03, 2.6762687725E+00, 7.0831751113E+00, 6.4297315438E-02, 6.2237114155E-02, 4.3240198914E-01],
	[6.92000E+03, 2.6787609400E+00, 7.0811067807E+00, 6.4440034601E-02, 6.2372016294E-02, 4.3258011482E-01],
	[6.92500E+03, 2.6812536257E+00, 7.0790405474E+00, 6.4582967126E-02, 6.2507107385E-02, 4.3275812168E-01],
	[6.93000E+03, 2.6837468294E+00, 7.0769764077E+00, 6.4726113180E-02, 6.2642387535E-02, 4.3293601006E-01],
	[6.93500E+03, 2.6862405506E+00, 7.0749143579E+00, 6.4869472925E-02, 6.2777856846E-02, 4.3311378030E-01],
	[6.94000E+03, 2.6887347892E+00, 7.0728543945E+00, 6.5013046527E-02, 6.2913515423E-02, 4.3329143274E-01],
	[6.94500E+03, 2.6912295450E+00, 7.0707965138E+00, 6.5156834151E-02, 6.3049363371E-02, 4.3346896772E-01],
	[6.95000E+03, 2.6937248175E+00, 7.0687407123E+00, 6.5300835961E-02, 6.3185400793E-02, 4.3364638558E-01],
	[6.95500E+03, 2.6962206067E+00, 7.0666869863E+00, 6.5445052121E-02, 6.3321627794E-02, 4.3382368667E-01],
	[6.96000E+03, 2.6987169121E+00, 7.0646353322E+00, 6.5589482797E-02, 6.3458044476E-02, 4.3400087131E-01],
	[6.96500E+03, 2.7012137336E+00, 7.0625857465E+00, 6.5734128152E-02, 6.3594650945E-02, 4.3417793985E-01],
	[6.97000E+03, 2.7037110709E+00, 7.0605382256E+00, 6.5878988352E-02, 6.3731447304E-02, 4.3435489262E-01],
	[6.97500E+03, 2.7062089237E+00, 7.0584927659E+00, 6.6024063561E-02, 6.3868433656E-02, 4.3453172995E-01],
	[6.98000E+03, 2.7087072917E+00, 7.0564493639E+00, 6.6169353944E-02, 6.4005610104E-02, 4.3470845218E-01],
	[6.98500E+03, 2.7112061748E+00, 7.0544080161E+00, 6.6314859666E-02, 6.4142976753E-02, 4.3488505964E-01],
	[6.99000E+03, 2.7137055725E+00, 7.0523687189E+00, 6.6460580890E-02, 6.4280533705E-02, 4.3506155267E-01],
	[6.99500E+03, 2.7162054848E+00, 7.0503314688E+00, 6.6606517782E-02, 6.4418281064E-02, 4.3523793159E-01],
	[7.00000E+03, 2.7187059112E+00, 7.0482962623E+00, 6.6752670507E-02, 6.4556218932E-02, 4.3541419673E-01],
	[7.00500E+03, 2.7212068516E+00, 7.0462630958E+00, 6.6900475372E-02, 6.4695690457E-02, 4.3559034843E-01],
	[7.01000E+03, 2.7237083056E+00, 7.0442319660E+00, 6.7048501696E-02, 6.4835357364E-02, 4.3576638700E-01],
	[7.01500E+03, 2.7262102731E+00, 7.0422028692E+00, 6.7196749653E-02, 6.4975219763E-02, 4.3594231279E-01],
	[7.02000E+03, 2.7287127538E+00, 7.0401758020E+00, 6.7345219416E-02, 6.5115277762E-02, 4.3611812611E-01],
	[7.02500E+03, 2.7312157473E+00, 7.0381507609E+00, 6.7493911159E-02, 6.5255531471E-02, 4.3629382729E-01],
	[7.03000E+03, 2.7337192535E+00, 7.0361277425E+00, 6.7642825056E-02, 6.5395980997E-02, 4.3646941665E-01],
	[7.03500E+03, 2.7362232720E+00, 7.0341067432E+00, 6.7791961280E-02, 6.5536626450E-02, 4.3664489451E-01],
	[7.04000E+03, 2.7387278027E+00, 7.0320877598E+00, 6.7941320005E-02, 6.5677467937E-02, 4.3682026121E-01],
	[7.04500E+03, 2.7412328452E+00, 7.0300707886E+00, 6.8090901403E-02, 6.5818505569E-02, 4.3699551706E-01],
	[7.05000E+03, 2.7437383994E+00, 7.0280558264E+00, 6.8240705650E-02, 6.5959739451E-02, 4.3717066238E-01],
	[7.05500E+03, 2.7462444649E+00, 7.0260428696E+00, 6.8390732918E-02, 6.6101169694E-02, 4.3734569749E-01],
	[7.06000E+03, 2.7487510414E+00, 7.0240319148E+00, 6.8540983381E-02, 6.6242796404E-02, 4.3752062271E-01],
	[7.06500E+03, 2.7512581288E+00, 7.0220229587E+00, 6.8691457212E-02, 6.6384619690E-02, 4.3769543836E-01],
	[7.07000E+03, 2.7537657268E+00, 7.0200159978E+00, 6.8842154586E-02, 6.6526639659E-02, 4.3787014475E-01],
	[7.07500E+03, 2.7562738351E+00, 7.0180110288E+00, 6.8993075676E-02, 6.6668856420E-02, 4.3804474220E-01],
	[7.08000E+03, 2.7587824534E+00, 7.0160080482E+00, 6.9144220655E-02, 6.6811270080E-02, 4.3821923103E-01],
	[7.08500E+03, 2.7612915815E+00, 7.0140070528E+00, 6.9295589698E-02, 6.6953880746E-02, 4.3839361155E-01],
	[7.09000E+03, 2.7638012192E+00, 7.0120080390E+00, 6.9447182977E-02, 6.7096688525E-02, 4.3856788414E-01],
	[7.09500E+03, 2.7663113662E+00, 7.0100110037E+00, 6.9599000667E-02, 6.7239693526E-02, 4.3874204920E-01],
	[7.10000E+03, 2.7688220222E+00, 7.0080159433E+00, 6.9751042941E-02, 6.7382895856E-02, 4.3891610704E-01],
	[7.10500E+03, 2.7713331870E+00, 7.0060228546E+00, 6.9903309974E-02, 6.7526295620E-02, 4.3909005799E-01],
	[7.11000E+03, 2.7738448602E+00, 7.0040317343E+00, 7.0055801938E-02, 6.7669892928E-02, 4.3926390235E-01],
	[7.11500E+03, 2.7763570418E+00, 7.0020425790E+00, 7.0208519007E-02, 6.7813687884E-02, 4.3943764044E-01],
	[7.12000E+03, 2.7788697314E+00, 7.0000553853E+00, 7.0361461356E-02, 6.7957680596E-02, 4.3961127255E-01],
	[7.12500E+03, 2.7813829287E+00, 6.9980701501E+00, 7.0514629158E-02, 6.8101871171E-02, 4.3978479900E-01],
	[7.13000E+03, 2.7838966335E+00, 6.9960868699E+00, 7.0668022587E-02, 6.8246259715E-02, 4.3995822010E-01],
	[7.13500E+03, 2.7864108456E+00, 6.9941055416E+00, 7.0821641816E-02, 6.8390846335E-02, 4.4013153615E-01],
	[7.14000E+03, 2.7889255647E+00, 6.9921261617E+00, 7.0975487020E-02, 6.8535631137E-02, 4.4030474747E-01],
	[7.14500E+03, 2.7914407905E+00, 6.9901487271E+00, 7.1129558372E-02, 6.8680614227E-02, 4.4047785435E-01],
	[7.15000E+03, 2.7939565229E+00, 6.9881732344E+00, 7.1283856046E-02, 6.8825795712E-02, 4.4065085709E-01],
	[7.15500E+03, 2.7964727614E+00, 6.9861996804E+00, 7.1438380216E-02, 6.8971175696E-02, 4.4082375601E-01],
	[7.16000E+03, 2.7989895060E+00, 6.9842280618E+00, 7.1593131056E-02, 6.9116754287E-02, 4.4099655140E-01],
	[7.16500E+03, 2.8015067562E+00, 6.9822583755E+00, 7.1748108739E-02, 6.9262531590E-02, 4.4116924357E-01],
	[7.17000E+03, 2.8040245120E+00, 6.9802906181E+00, 7.1903313440E-02, 6.9408507711E-02, 4.4134183282E-01],
	[7.17500E+03, 2.8065427730E+00, 6.9783247864E+00, 7.2058745332E-02, 6.9554682754E-02, 4.4151431945E-01],
	[7.18000E+03, 2.8090615390E+00, 6.9763608772E+00, 7.2214404589E-02, 6.9701056827E-02, 4.4168670375E-01],
	[7.18500E+03, 2.8115932625E+00, 6.9744649834E+00, 7.2370291385E-02, 6.9847644348E-02, 4.4185898602E-01],
	[7.19000E+03, 2.8141307918E+00, 6.9725989551E+00, 7.2526405895E-02, 6.9994437305E-02, 4.4203116657E-01],
	[7.19500E+03, 2.8166688448E+00, 6.9707347228E+00, 7.2682748292E-02, 7.0141429749E-02, 4.4220324569E-01],
	[7.20000E+03, 2.8192074213E+00, 6.9688722834E+00, 7.2839318749E-02, 7.0288621787E-02, 4.4237522367E-01],
	[7.20500E+03, 2.8217465211E+00, 6.9670116340E+00, 7.2996117441E-02, 7.0436013524E-02, 4.4254710081E-01],
	[7.21000E+03, 2.8242861440E+00, 6.9651527717E+00, 7.3153144543E-02, 7.0583605065E-02, 4.4271887741E-01],
	[7.21500E+03, 2.8268262896E+00, 6.9632956935E+00, 7.3310400227E-02, 7.0731396516E-02, 4.4289055375E-01],
	[7.22000E+03, 2.8293669577E+00, 6.9614403964E+00, 7.3467884668E-02, 7.0879387981E-02, 4.4306213014E-01],
	[7.22500E+03, 2.8319081480E+00, 6.9595868775E+00, 7.3625598040E-02, 7.1027579567E-02, 4.4323360686E-01],
	[7.23000E+03, 2.8344498604E+00, 6.9577351338E+00, 7.3783540516E-02, 7.1175971377E-02, 4.4340498420E-01],
	[7.23500E+03, 2.8369920944E+00, 6.9558851625E+00, 7.3941712272E-02, 7.1324563517E-02, 4.4357626246E-01],
	[7.24000E+03, 2.8395348500E+00, 6.9540369607E+00, 7.4100113480E-02, 7.1473356091E-02, 4.4374744192E-01],
	[7.24500E+03, 2.8420781268E+00, 6.9521905253E+00, 7.4258744316E-02, 7.1622349205E-02, 4.4391852288E-01],
	[7.25000E+03, 2.8446219246E+00, 6.9503458535E+00, 7.4417604952E-02, 7.1771542962E-02, 4.4408950562E-01],
	[7.25500E+03, 2.8471662431E+00, 6.9485029425E+00, 7.4576695564E-02, 7.1920937468E-02, 4.4426039042E-01],
	[7.26000E+03, 2.8497110821E+00, 6.9466617892E+00, 7.4736016325E-02, 7.2070532826E-02, 4.4443117759E-01],
	[7.26500E+03, 2.8522564413E+00, 6.9448223909E+00, 7.4895567409E-02, 7.2220329140E-02, 4.4460186739E-01],
	[7.27000E+03, 2.8548023205E+00, 6.9429847446E+00, 7.5055348991E-02, 7.2370326516E-02, 4.4477246012E-01],
	[7.27500E+03, 2.8573487194E+00, 6.9411488475E+00, 7.5215361244E-02, 7.2520525056E-02, 4.4494295606E-01],
	[7.28000E+03, 2.8598956378E+00, 6.9393146967E+00, 7.5375604342E-02, 7.2670924864E-02, 4.4511335550E-01],
	[7.28500E+03, 2.8624430754E+00, 6.9374822893E+00, 7.5536078461E-02, 7.2821526045E-02, 4.4528365872E-01],
	[7.29000E+03, 2.8649910320E+00, 6.9356516226E+00, 7.5696783774E-02, 7.2972328702E-02, 4.4545386599E-01],
	[7.29500E+03, 2.8675395073E+00, 6.9338226936E+00, 7.5857720454E-02, 7.3123332939E-02, 4.4562397761E-01],
	[7.30000E+03, 2.8700885011E+00, 6.9319954995E+00, 7.6018888677E-02, 7.3274538859E-02, 4.4579399385E-01],
	[7.30500E+03, 2.8726380130E+00, 6.9301700374E+00, 7.6180288617E-02, 7.3425946565E-02, 4.4596391499E-01],
	[7.31000E+03, 2.8751880430E+00, 6.9283463047E+00, 7.6341920447E-02, 7.3577556160E-02, 4.4613374131E-01],
	[7.31500E+03, 2.8777385906E+00, 6.9265242984E+00, 7.6503784342E-02, 7.3729367749E-02, 4.4630347310E-01],
	[7.32000E+03, 2.8802896558E+00, 6.9247040157E+00, 7.6665880476E-02, 7.3881381433E-02, 4.4647311062E-01],
	[7.32500E+03, 2.8828412381E+00, 6.9228854538E+00, 7.6828209023E-02, 7.4033597315E-02, 4.4664265416E-01],
	[7.33000E+03, 2.8853933375E+00, 6.9210686099E+00, 7.6990770159E-02, 7.4186015499E-02, 4.4681210399E-01],
	[7.33500E+03, 2.8879459535E+00, 6.9192534813E+00, 7.7153564056E-02, 7.4338636087E-02, 4.4698146039E-01],
	[7.34000E+03, 2.8904990861E+00, 6.9174400651E+00, 7.7316590889E-02, 7.4491459181E-02, 4.4715072363E-01],
	[7.34500E+03, 2.8930527349E+00, 6.9156283585E+00, 7.7479850833E-02, 7.4644484884E-02, 4.4731989399E-01],
	[7.35000E+03, 2.8956068996E+00, 6.9138183588E+00, 7.7643344061E-02, 7.4797713299E-02, 4.4748897175E-01],
	[7.35500E+03, 2.8981615801E+00, 6.9120100633E+00, 7.7807070748E-02, 7.4951144527E-02, 4.4765795716E-01],
	[7.36000E+03, 2.9007167761E+00, 6.9102034691E+00, 7.7971031069E-02, 7.5104778670E-02, 4.4782685052E-01],
	[7.36500E+03, 2.9032724873E+00, 6.9083985735E+00, 7.8135225198E-02, 7.5258615831E-02, 4.4799565208E-01],
	[7.37000E+03, 2.9058287135E+00, 6.9065953737E+00, 7.8299653308E-02, 7.5412656112E-02, 4.4816436213E-01],
	[7.37500E+03, 2.9083854545E+00, 6.9047938671E+00, 7.8464315575E-02, 7.5566899614E-02, 4.4833298092E-01],
	[7.38000E+03, 2.9109427100E+00, 6.9029940508E+00, 7.8629212173E-02, 7.5721346438E-02, 4.4850150874E-01],
	[7.38500E+03, 2.9135004797E+00, 6.9011959222E+00, 7.8794343275E-02, 7.5875996687E-02, 4.4866994584E-01],
	[7.39000E+03, 2.9160587635E+00, 6.8993994785E+00, 7.8959709058E-02, 7.6030850462E-02, 4.4883829250E-01],
	[7.39500E+03, 2.9186175610E+00, 6.8976047170E+00, 7.9125309694E-02, 7.6185907864E-02, 4.4900654899E-01],
	[7.40000E+03, 2.9211768721E+00, 6.8958116349E+00, 7.9291145358E-02, 7.6341168994E-02, 4.4917471557E-01],
	[7.40500E+03, 2.9237366965E+00, 6.8940202297E+00, 7.9457216225E-02, 7.6496633953E-02, 4.4934279251E-01],
	[7.41000E+03, 2.9262970338E+00, 6.8922304986E+00, 7.9623522470E-02, 7.6652302843E-02, 4.4951078008E-01],
	[7.41500E+03, 2.9288578840E+00, 6.8904424388E+00, 7.9790064266E-02, 7.6808175764E-02, 4.4967867854E-01],
	[7.42000E+03, 2.9314192468E+00, 6.8886560478E+00, 7.9956841788E-02, 7.6964252817E-02, 4.4984648815E-01],
	[7.42500E+03, 2.9339811218E+00, 6.8868713227E+00, 8.0123855210E-02, 7.7120534102E-02, 4.5001420918E-01],
	[7.43000E+03, 2.9365435089E+00, 6.8850882611E+00, 8.0291104708E-02, 7.7277019721E-02, 4.5018184189E-01],
	[7.43500E+03, 2.9391064079E+00, 6.8833068601E+00, 8.0458590455E-02, 7.7433709773E-02, 4.5034938655E-01],
	[7.44000E+03, 2.9416698184E+00, 6.8815271171E+00, 8.0626312626E-02, 7.7590604358E-02, 4.5051684341E-01],
	[7.44500E+03, 2.9442337403E+00, 6.8797490295E+00, 8.0794271396E-02, 7.7747703578E-02, 4.5068421275E-01],
	[7.45000E+03, 2.9467981732E+00, 6.8779725947E+00, 8.0962466939E-02, 7.7905007531E-02, 4.5085149481E-01],
	[7.45500E+03, 2.9493631171E+00, 6.8761978099E+00, 8.1130899429E-02, 7.8062516319E-02, 4.5101868987E-01],
	[7.46000E+03, 2.9519285715E+00, 6.8744246725E+00, 8.1299569042E-02, 7.8220230040E-02, 4.5118579817E-01],
	[7.46500E+03, 2.9544945364E+00, 6.8726531799E+00, 8.1468475951E-02, 7.8378148794E-02, 4.5135281998E-01],
	[7.47000E+03, 2.9570675523E+00, 6.8709181446E+00, 8.1637620331E-02, 7.8536281844E-02, 4.5151975556E-01],
	[7.47500E+03, 2.9596504162E+00, 6.8692343184E+00, 8.1807002357E-02, 7.8694633296E-02, 4.5168660516E-01],
	[7.48000E+03, 2.9622338067E+00, 6.8675520304E+00, 8.1976622204E-02, 7.8853190232E-02, 4.5185336905E-01],
	[7.48500E+03, 2.9648177237E+00, 6.8658712781E+00, 8.2146480046E-02, 7.9011952749E-02, 4.5202004747E-01],
	[7.49000E+03, 2.9674021669E+00, 6.8641920591E+00, 8.2316576057E-02, 7.9170920950E-02, 4.5218664069E-01],
	[7.49500E+03, 2.9699871360E+00, 6.8625143710E+00, 8.2486910413E-02, 7.9330094932E-02, 4.5235314896E-01],
	[7.50000E+03, 2.9725726308E+00, 6.8608382113E+00, 8.2657483288E-02, 7.9489474796E-02, 4.5251957254E-01],
	[7.50500E+03, 2.9751586510E+00, 6.8591635778E+00, 8.2828294856E-02, 7.9649060641E-02, 4.5268591167E-01],
	[7.51000E+03, 2.9777451964E+00, 6.8574904678E+00, 8.2999345292E-02, 7.9808852566E-02, 4.5285216662E-01],
	[7.51500E+03, 2.9803322668E+00, 6.8558188792E+00, 8.3170634772E-02, 7.9968850671E-02, 4.5301833763E-01],
	[7.52000E+03, 2.9829198618E+00, 6.8541488093E+00, 8.3342163469E-02, 8.0129055054E-02, 4.5318442496E-01],
	[7.52500E+03, 2.9855079814E+00, 6.8524802560E+00, 8.3513931558E-02, 8.0289465815E-02, 4.5335042887E-01],
	[7.53000E+03, 2.9880966251E+00, 6.8508132167E+00, 8.3685939214E-02, 8.0450083052E-02, 4.5351634959E-01],
	[7.53500E+03, 2.9906857929E+00, 6.8491476892E+00, 8.3858186612E-02, 8.0610906864E-02, 4.5368218739E-01],
	[7.54000E+03, 2.9932754844E+00, 6.8474836710E+00, 8.4030673927E-02, 8.0771937350E-02, 4.5384794251E-01],
	[7.54500E+03, 2.9958656994E+00, 6.8458211598E+00, 8.4203401332E-02, 8.0933174607E-02, 4.5401361521E-01],
	[7.55000E+03, 2.9984564376E+00, 6.8441601531E+00, 8.4376369004E-02, 8.1094618736E-02, 4.5417920573E-01],
	[7.55500E+03, 3.0010476989E+00, 6.8425006487E+00, 8.4549577116E-02, 8.1256269833E-02, 4.5434471432E-01],
	[7.56000E+03, 3.0036394829E+00, 6.8408426443E+00, 8.4723025844E-02, 8.1418127996E-02, 4.5451014122E-01],
	[7.56500E+03, 3.0062317895E+00, 6.8391861373E+00, 8.4896715362E-02, 8.1580193325E-02, 4.5467548670E-01],
	[7.57000E+03, 3.0088246184E+00, 6.8375311256E+00, 8.5070645845E-02, 8.1742465916E-02, 4.5484075099E-01],
	[7.57500E+03, 3.0114179693E+00, 6.8358776068E+00, 8.5244817468E-02, 8.1904945868E-02, 4.5500593434E-01],
	[7.58000E+03, 3.0140118421E+00, 6.8342255785E+00, 8.5419230406E-02, 8.2067633279E-02, 4.5517103700E-01],
	[7.58500E+03, 3.0166062364E+00, 6.8325750384E+00, 8.5593884833E-02, 8.2230528245E-02, 4.5533605921E-01],
	[7.59000E+03, 3.0192011521E+00, 6.8309259843E+00, 8.5768780925E-02, 8.2393630864E-02, 4.5550100121E-01],
	[7.59500E+03, 3.0217965889E+00, 6.8292784137E+00, 8.5943918856E-02, 8.2556941234E-02, 4.5566586326E-01],
	[7.60000E+03, 3.0243925465E+00, 6.8276323244E+00, 8.6119298801E-02, 8.2720459451E-02, 4.5583064559E-01],
	[7.60500E+03, 3.0269890248E+00, 6.8259877140E+00, 8.6294920935E-02, 8.2884185613E-02, 4.5599534845E-01],
	[7.61000E+03, 3.0295860234E+00, 6.8243445804E+00, 8.6470785432E-02, 8.3048119818E-02, 4.5615997208E-01],
	[7.61500E+03, 3.0321835422E+00, 6.8227029211E+00, 8.6646892469E-02, 8.3212262160E-02, 4.5632451673E-01],
	[7.62000E+03, 3.0347815809E+00, 6.8210627339E+00, 8.6823242219E-02, 8.3376612739E-02, 4.5648898263E-01],
	[7.62500E+03, 3.0373801393E+00, 6.8194240165E+00, 8.6999834858E-02, 8.3541171649E-02, 4.5665337003E-01],
	[7.63000E+03, 3.0399792171E+00, 6.8177867666E+00, 8.7176670560E-02, 8.3705938988E-02, 4.5681767916E-01],
	[7.63500E+03, 3.0425788141E+00, 6.8161509819E+00, 8.7353749501E-02, 8.3870914851E-02, 4.5698191027E-01],
	[7.64000E+03, 3.0451789301E+00, 6.8145166603E+00, 8.7531071855E-02, 8.4036099336E-02, 4.5714606360E-01],
	[7.64500E+03, 3.0477795648E+00, 6.8128837993E+00, 8.7708637798E-02, 8.4201492538E-02, 4.5731013939E-01],
	[7.65000E+03, 3.0503807180E+00, 6.8112523968E+00, 8.7886447504E-02, 8.4367094554E-02, 4.5747413787E-01],
	[7.65500E+03, 3.0529823894E+00, 6.8096224505E+00, 8.8064501148E-02, 8.4532905479E-02, 4.5763805928E-01],
	[7.66000E+03, 3.0555845789E+00, 6.8079939582E+00, 8.8242798905E-02, 8.4698925408E-02, 4.5780190387E-01],
	[7.66500E+03, 3.0581872861E+00, 6.8063669175E+00, 8.8421340951E-02, 8.4865154439E-02, 4.5796567186E-01],
	[7.67000E+03, 3.0607905109E+00, 6.8047413264E+00, 8.8600127461E-02, 8.5031592666E-02, 4.5812936350E-01],
	[7.67500E+03, 3.0633942530E+00, 6.8031171824E+00, 8.8779158609E-02, 8.5198240184E-02, 4.5829297903E-01],
	[7.68000E+03, 3.0659985122E+00, 6.8014944835E+00, 8.8958434570E-02, 8.5365097089E-02, 4.5845651867E-01],
	[7.68500E+03, 3.0686032883E+00, 6.7998732273E+00, 8.9137955520E-02, 8.5532163477E-02, 4.5861998266E-01],
	[7.69000E+03, 3.0712085810E+00, 6.7982534117E+00, 8.9317721633E-02, 8.5699439442E-02, 4.5878337124E-01],
	[7.69500E+03, 3.0738143900E+00, 6.7966350344E+00, 8.9497733085E-02, 8.5866925079E-02, 4.5894668464E-01],
	[7.70000E+03, 3.0764207152E+00, 6.7950180932E+00, 8.9677990051E-02, 8.6034620483E-02, 4.5910992310E-01],
	[7.70500E+03, 3.0790275563E+00, 6.7934025860E+00, 8.9858492705E-02, 8.6202525749E-02, 4.5927308685E-01],
	[7.71000E+03, 3.0816349131E+00, 6.7917885104E+00, 9.0039241224E-02, 8.6370640972E-02, 4.5943617612E-01],
	[7.71500E+03, 3.0842427853E+00, 6.7901758645E+00, 9.0220235781E-02, 8.6538966245E-02, 4.5959919115E-01],
	[7.72000E+03, 3.0868511728E+00, 6.7885646458E+00, 9.0401476553E-02, 8.6707501664E-02, 4.5976213216E-01],
	[7.72500E+03, 3.0894600752E+00, 6.7869548523E+00, 9.0582963714E-02, 8.6876247322E-02, 4.5992499940E-01],
	[7.73000E+03, 3.0920694924E+00, 6.7853464817E+00, 9.0764697440E-02, 8.7045203313E-02, 4.6008779308E-01],
	[7.73500E+03, 3.0946794241E+00, 6.7837395320E+00, 9.0946677906E-02, 8.7214369733E-02, 4.6025051345E-01],
	[7.74000E+03, 3.0972898701E+00, 6.7821340008E+00, 9.1128905286E-02, 8.7383746673E-02, 4.6041316072E-01],
	[7.74500E+03, 3.0999008301E+00, 6.7805298862E+00, 9.1311379756E-02, 8.7553334229E-02, 4.6057573514E-01],
	[7.75000E+03, 3.1025123040E+00, 6.7789271857E+00, 9.1494101492E-02, 8.7723132494E-02, 4.6073823693E-01],
	[7.75500E+03, 3.1051242915E+00, 6.7773258975E+00, 9.1677070668E-02, 8.7893141561E-02, 4.6090066631E-01],
	[7.76000E+03, 3.1077367923E+00, 6.7757260192E+00, 9.1860287459E-02, 8.8063361524E-02, 4.6106302353E-01],
	[7.76500E+03, 3.1103498063E+00, 6.7741275487E+00, 9.2043752042E-02, 8.8233792476E-02, 4.6122530882E-01],
	[7.77000E+03, 3.1129750275E+00, 6.7725937356E+00, 9.2227464590E-02, 8.8404454719E-02, 4.6138752249E-01],
	[7.77500E+03, 3.1156030476E+00, 6.7710735425E+00, 9.2411425281E-02, 8.8575332209E-02, 4.6154966476E-01],
	[7.78000E+03, 3.1182315946E+00, 6.7695546677E+00, 9.2595634287E-02, 8.8746421127E-02, 4.6171173582E-01],
	[7.78500E+03, 3.1208606683E+00, 6.7680371090E+00, 9.2780091786E-02, 8.8917721565E-02, 4.6187373589E-01],
	[7.79000E+03, 3.1234902686E+00, 6.7665208646E+00, 9.2964797952E-02, 8.9089233617E-02, 4.6203566516E-01],
	[7.79500E+03, 3.1261203951E+00, 6.7650059324E+00, 9.3149752961E-02, 8.9260957375E-02, 4.6219752383E-01],
	[7.80000E+03, 3.1287510477E+00, 6.7634923105E+00, 9.3334956987E-02, 8.9432892933E-02, 4.6235931212E-01],
	[7.80500E+03, 3.1313822261E+00, 6.7619799968E+00, 9.3520410206E-02, 8.9605040384E-02, 4.6252103021E-01],
	[7.81000E+03, 3.1340139300E+00, 6.7604689895E+00, 9.3706112794E-02, 8.9777399820E-02, 4.6268267832E-01],
	[7.81500E+03, 3.1366461593E+00, 6.7589592866E+00, 9.3892064926E-02, 8.9949971335E-02, 4.6284425663E-01],
	[7.82000E+03, 3.1392789138E+00, 6.7574508861E+00, 9.4078266777E-02, 9.0122755020E-02, 4.6300576536E-01],
	[7.82500E+03, 3.1419121931E+00, 6.7559437860E+00, 9.4264718523E-02, 9.0295750969E-02, 4.6316720470E-01],
	[7.83000E+03, 3.1445459970E+00, 6.7544379844E+00, 9.4451420338E-02, 9.0468959273E-02, 4.6332857486E-01],
	[7.83500E+03, 3.1471803254E+00, 6.7529334794E+00, 9.4638372399E-02, 9.0642380025E-02, 4.6348987602E-01],
	[7.84000E+03, 3.1498151780E+00, 6.7514302690E+00, 9.4825574881E-02, 9.0816013317E-02, 4.6365110839E-01],
	[7.84500E+03, 3.1524505545E+00, 6.7499283512E+00, 9.5013027958E-02, 9.0989859241E-02, 4.6381227217E-01],
	[7.85000E+03, 3.1550864548E+00, 6.7484277242E+00, 9.5200731808E-02, 9.1163917888E-02, 4.6397336756E-01],
	[7.85500E+03, 3.1577228785E+00, 6.7469283860E+00, 9.5388686604E-02, 9.1338189351E-02, 4.6413439476E-01],
	[7.86000E+03, 3.1603598256E+00, 6.7454303347E+00, 9.5576892522E-02, 9.1512673721E-02, 4.6429535395E-01],
	[7.86500E+03, 3.1629972956E+00, 6.7439335683E+00, 9.5765349739E-02, 9.1687371089E-02, 4.6445624534E-01],
	[7.87000E+03, 3.1656352885E+00, 6.7424380850E+00, 9.5954058428E-02, 9.1862281547E-02, 4.6461706913E-01],
	[7.87500E+03, 3.1682738040E+00, 6.7409438828E+00, 9.6143018767E-02, 9.2037405186E-02, 4.6477782550E-01],
	[7.88000E+03, 3.1709128419E+00, 6.7394509598E+00, 9.6332230930E-02, 9.2212742098E-02, 4.6493851467E-01],
	[7.88500E+03, 3.1735524018E+00, 6.7379593141E+00, 9.6521695092E-02, 9.2388292372E-02, 4.6509913681E-01],
	[7.89000E+03, 3.1761924837E+00, 6.7364689439E+00, 9.6711411430E-02, 9.2564056101E-02, 4.6525969213E-01],
	[7.89500E+03, 3.1788330873E+00, 6.7349798471E+00, 9.6901380119E-02, 9.2740033374E-02, 4.6542018083E-01],
	[7.90000E+03, 3.1814742122E+00, 6.7334920220E+00, 9.7091601334E-02, 9.2916224283E-02, 4.6558060309E-01],
	[7.90500E+03, 3.1841158585E+00, 6.7320054666E+00, 9.7282075251E-02, 9.3092628918E-02, 4.6574095911E-01],
	[7.91000E+03, 3.1867580257E+00, 6.7305201790E+00, 9.7472802045E-02, 9.3269247369E-02, 4.6590124908E-01],
	[7.91500E+03, 3.1894007136E+00, 6.7290361574E+00, 9.7663781893E-02, 9.3446079727E-02, 4.6606147320E-01],
	[7.92000E+03, 3.1920439222E+00, 6.7275533999E+00, 9.7855014968E-02, 9.3623126081E-02, 4.6622163166E-01],
	[7.92500E+03, 3.1946876510E+00, 6.7260719046E+00, 9.8046501448E-02, 9.3800386522E-02, 4.6638172465E-01],
	[7.93000E+03, 3.1973318999E+00, 6.7245916696E+00, 9.8238241508E-02, 9.3977861140E-02, 4.6654175237E-01],
	[7.93500E+03, 3.1999766687E+00, 6.7231126931E+00, 9.8430235323E-02, 9.4155550023E-02, 4.6670171500E-01],
	[7.94000E+03, 3.2026219571E+00, 6.7216349732E+00, 9.8622483069E-02, 9.4333453263E-02, 4.6686161274E-01],
	[7.94500E+03, 3.2052677649E+00, 6.7201585080E+00, 9.8814984921E-02, 9.4511570949E-02, 4.6702144578E-01],
	[7.95000E+03, 3.2079140919E+00, 6.7186832958E+00, 9.9007741056E-02, 9.4689903169E-02, 4.6718121430E-01],
	[7.95500E+03, 3.2105609379E+00, 6.7172093346E+00, 9.9200751649E-02, 9.4868450013E-02, 4.6734091851E-01],
	[7.96000E+03, 3.2132083026E+00, 6.7157366226E+00, 9.9394016875E-02, 9.5047211570E-02, 4.6750055858E-01],
	[7.96500E+03, 3.2158561858E+00, 6.7142651580E+00, 9.9587536910E-02, 9.5226187930E-02, 4.6766013472E-01],
	[7.97000E+03, 3.2185045873E+00, 6.7127949389E+00, 9.9781311930E-02, 9.5405379181E-02, 4.6781964710E-01],
	[7.97500E+03, 3.2211535069E+00, 6.7113259635E+00, 9.9975342110E-02, 9.5584785412E-02, 4.6797909592E-01],
	[7.98000E+03, 3.2238029443E+00, 6.7098582299E+00, 1.0016962763E-01, 9.5764406711E-02, 4.6813848137E-01],
	[7.98500E+03, 3.2264528993E+00, 6.7083917364E+00, 1.0036416866E-01, 9.5944243168E-02, 4.6829780363E-01],
	[7.99000E+03, 3.2291033718E+00, 6.7069264810E+00, 1.0055896537E-01, 9.6124294870E-02, 4.6845706290E-01],
	[7.99500E+03, 3.2317543614E+00, 6.7054624621E+00, 1.0075401795E-01, 9.6304561906E-02, 4.6861625935E-01],
	[8.00000E+03, 3.2344058679E+00, 6.7039996777E+00, 1.0094932657E-01, 9.6485044363E-02, 4.6877539319E-01],
	[8.00500E+03, 3.2370578912E+00, 6.7025381261E+00, 1.0114577448E-01, 9.6666548928E-02, 4.6893446459E-01],
	[8.01000E+03, 3.2397104310E+00, 6.7010778054E+00, 1.0134248166E-01, 9.6848271507E-02, 4.6909347373E-01],
	[8.01500E+03, 3.2423634870E+00, 6.6996187139E+00, 1.0153944829E-01, 9.7030212192E-02, 4.6925242082E-01],
	[8.02000E+03, 3.2450170592E+00, 6.6981608497E+00, 1.0173667454E-01, 9.7212371072E-02, 4.6941130603E-01],
	[8.02500E+03, 3.2476711471E+00, 6.6967042111E+00, 1.0193416059E-01, 9.7394748237E-02, 4.6957012955E-01],
	[8.03000E+03, 3.2503257507E+00, 6.6952487963E+00, 1.0213190663E-01, 9.7577343778E-02, 4.6972889157E-01],
	[8.03500E+03, 3.2529808697E+00, 6.6937946034E+00, 1.0232991283E-01, 9.7760157784E-02, 4.6988759227E-01],
	[8.04000E+03, 3.2556365038E+00, 6.6923416307E+00, 1.0252817939E-01, 9.7943190345E-02, 4.7004623183E-01],
	[8.04500E+03, 3.2582926530E+00, 6.6908898764E+00, 1.0272670646E-01, 9.8126441550E-02, 4.7020481044E-01],
	[8.05000E+03, 3.2609493168E+00, 6.6894393387E+00, 1.0292549424E-01, 9.8309911490E-02, 4.7036332828E-01],
	[8.05500E+03, 3.2636064952E+00, 6.6879900158E+00, 1.0312454291E-01, 9.8493600253E-02, 4.7052178554E-01],
	[8.06000E+03, 3.2662641878E+00, 6.6865419061E+00, 1.0332385265E-01, 9.8677507929E-02, 4.7068018240E-01],
	[8.06500E+03, 3.2689223946E+00, 6.6850950076E+00, 1.0352342363E-01, 9.8861634606E-02, 4.7083851905E-01],
	[8.07000E+03, 3.2715811152E+00, 6.6836493187E+00, 1.0372325603E-01, 9.9045980374E-02, 4.7099679566E-01],
	[8.07500E+03, 3.2742403494E+00, 6.6822048376E+00, 1.0392335004E-01, 9.9230545321E-02, 4.7115501242E-01],
	[8.08000E+03, 3.2769109230E+00, 6.6808213850E+00, 1.0412370584E-01, 9.9415352748E-02, 4.7131316951E-01],
	[8.08500E+03, 3.2795834139E+00, 6.6794467645E+00, 1.0432432361E-01, 9.9600382674E-02, 4.7147126712E-01],
	[8.09000E+03, 3.2822564300E+00, 6.6780732765E+00, 1.0452520352E-01, 9.9785632213E-02, 4.7162930542E-01],
	[8.09500E+03, 3.2849299712E+00, 6.6767009192E+00, 1.0472634576E-01, 9.9971101453E-02, 4.7178728460E-01],
	[8.10000E+03, 3.2876040373E+00, 6.6753296912E+00, 1.0492775051E-01, 1.0015679048E-01, 4.7194520484E-01],
	[8.10500E+03, 3.2902786280E+00, 6.6739595906E+00, 1.0512941794E-01, 1.0034269939E-01, 4.7210306632E-01],
	[8.11000E+03, 3.2929537431E+00, 6.6725906160E+00, 1.0533134825E-01, 1.0052882827E-01, 4.7226086921E-01],
	[8.11500E+03, 3.2956293824E+00, 6.6712227656E+00, 1.0553354160E-01, 1.0071517721E-01, 4.7241861371E-01],
	[8.12000E+03, 3.2983055456E+00, 6.6698560379E+00, 1.0573599818E-01, 1.0090174628E-01, 4.7257629998E-01],
	[8.12500E+03, 3.3009822327E+00, 6.6684904313E+00, 1.0593871817E-01, 1.0108853559E-01, 4.7273392821E-01],
	[8.13000E+03, 3.3036594432E+00, 6.6671259442E+00, 1.0614170174E-01, 1.0127554523E-01, 4.7289149859E-01],
	[8.13500E+03, 3.3063371771E+00, 6.6657625749E+00, 1.0634494909E-01, 1.0146277527E-01, 4.7304901127E-01],
	[8.14000E+03, 3.3090154341E+00, 6.6644003218E+00, 1.0654846039E-01, 1.0165022580E-01, 4.7320646646E-01],
	[8.14500E+03, 3.3116942139E+00, 6.6630391834E+00, 1.0675223581E-01, 1.0183789692E-01, 4.7336386432E-01],
	[8.15000E+03, 3.3143735164E+00, 6.6616791580E+00, 1.0695627555E-01, 1.0202578871E-01, 4.7352120503E-01],
	[8.15500E+03, 3.3170533414E+00, 6.6603202441E+00, 1.0716057978E-01, 1.0221390126E-01, 4.7367848878E-01],
	[8.16000E+03, 3.3197336885E+00, 6.6589624401E+00, 1.0736514867E-01, 1.0240223466E-01, 4.7383571573E-01],
	[8.16500E+03, 3.3224145577E+00, 6.6576057444E+00, 1.0756998242E-01, 1.0259078899E-01, 4.7399288607E-01],
	[8.17000E+03, 3.3250959486E+00, 6.6562501553E+00, 1.0777508120E-01, 1.0277956434E-01, 4.7414999997E-01],
	[8.17500E+03, 3.3277778611E+00, 6.6548956714E+00, 1.0798044520E-01, 1.0296856080E-01, 4.7430705761E-01],
	[8.18000E+03, 3.3304602949E+00, 6.6535422911E+00, 1.0818607458E-01, 1.0315777845E-01, 4.7446405916E-01],
	[8.18500E+03, 3.3331432499E+00, 6.6521900127E+00, 1.0839196954E-01, 1.0334721738E-01, 4.7462100481E-01],
	[8.19000E+03, 3.3358267258E+00, 6.6508388347E+00, 1.0859813026E-01, 1.0353687768E-01, 4.7477789473E-01],
	[8.19500E+03, 3.3385107224E+00, 6.6494887556E+00, 1.0880455690E-01, 1.0372675944E-01, 4.7493472910E-01],
	[8.20000E+03, 3.3411952394E+00, 6.6481397737E+00, 1.0901124966E-01, 1.0391686273E-01, 4.7509150808E-01],
	[8.20500E+03, 3.3438802767E+00, 6.6467918876E+00, 1.0921820872E-01, 1.0410718765E-01, 4.7524823186E-01],
	[8.21000E+03, 3.3465658341E+00, 6.6454450956E+00, 1.0942543425E-01, 1.0429773428E-01, 4.7540490060E-01],
	[8.21500E+03, 3.3492519113E+00, 6.6440993963E+00, 1.0963292644E-01, 1.0448850271E-01, 4.7556151450E-01],
	[8.22000E+03, 3.3519385081E+00, 6.6427547879E+00, 1.0984068546E-01, 1.0467949302E-01, 4.7571807371E-01],
	[8.22500E+03, 3.3546256243E+00, 6.6414112691E+00, 1.1004871150E-01, 1.0487070530E-01, 4.7587457841E-01],
	[8.23000E+03, 3.3573132597E+00, 6.6400688383E+00, 1.1025700474E-01, 1.0506213963E-01, 4.7603102878E-01],
	[8.23500E+03, 3.3600014140E+00, 6.6387274939E+00, 1.1046556536E-01, 1.0525379611E-01, 4.7618742500E-01],
	[8.24000E+03, 3.3626900871E+00, 6.6373872343E+00, 1.1067439353E-01, 1.0544567481E-01, 4.7634376722E-01],
	[8.24500E+03, 3.3653792788E+00, 6.6360480581E+00, 1.1088348944E-01, 1.0563777581E-01, 4.7650005564E-01],
	[8.25000E+03, 3.3680689887E+00, 6.6347099638E+00, 1.1109285328E-01, 1.0583009922E-01, 4.7665629041E-01],
	[8.25500E+03, 3.3707592168E+00, 6.6333729497E+00, 1.1130248521E-01, 1.0602264510E-01, 4.7681247172E-01],
	[8.26000E+03, 3.3734499627E+00, 6.6320370144E+00, 1.1151238543E-01, 1.0621541355E-01, 4.7696859973E-01],
	[8.26500E+03, 3.3761412264E+00, 6.6307021563E+00, 1.1172255411E-01, 1.0640840464E-01, 4.7712467463E-01],
	[8.27000E+03, 3.3788330075E+00, 6.6293683740E+00, 1.1193299142E-01, 1.0660161847E-01, 4.7728069657E-01],
	[8.27500E+03, 3.3815253059E+00, 6.6280356658E+00, 1.1214369757E-01, 1.0679505512E-01, 4.7743666573E-01],
	[8.28000E+03, 3.3842181213E+00, 6.6267040304E+00, 1.1235467271E-01, 1.0698871467E-01, 4.7759258228E-01],
	[8.28500E+03, 3.3869114535E+00, 6.6253734661E+00, 1.1256591704E-01, 1.0718259720E-01, 4.7774844640E-01],
	[8.29000E+03, 3.3896053023E+00, 6.6240439715E+00, 1.1277743074E-01, 1.0737670281E-01, 4.7790425825E-01],
	[8.29500E+03, 3.3922996676E+00, 6.6227155450E+00, 1.1298921398E-01, 1.0757103156E-01, 4.7806001801E-01],
	[8.30000E+03, 3.3949945490E+00, 6.6213881853E+00, 1.1320126695E-01, 1.0776558356E-01, 4.7821572584E-01],
	[8.30500E+03, 3.3976899464E+00, 6.6200618907E+00, 1.1341358982E-01, 1.0796035887E-01, 4.7837138192E-01],
	[8.31000E+03, 3.4003858596E+00, 6.6187366598E+00, 1.1362618278E-01, 1.0815535759E-01, 4.7852698642E-01],
	[8.31500E+03, 3.4030822883E+00, 6.6174124910E+00, 1.1383904601E-01, 1.0835057979E-01, 4.7868253950E-01],
	[8.32000E+03, 3.4057792324E+00, 6.6160893830E+00, 1.1405217969E-01, 1.0854602556E-01, 4.7883804134E-01],
	[8.32500E+03, 3.4084766916E+00, 6.6147673341E+00, 1.1426558400E-01, 1.0874169499E-01, 4.7899349210E-01],
	[8.33000E+03, 3.4111746657E+00, 6.6134463430E+00, 1.1447925912E-01, 1.0893758815E-01, 4.7914889195E-01],
	[8.33500E+03, 3.4138731545E+00, 6.6121264082E+00, 1.1469320524E-01, 1.0913370513E-01, 4.7930424107E-01],
	[8.34000E+03, 3.4165721578E+00, 6.6108075280E+00, 1.1490742252E-01, 1.0933004601E-01, 4.7945953962E-01],
	[8.34500E+03, 3.4192716754E+00, 6.6094897012E+00, 1.1512191116E-01, 1.0952661087E-01, 4.7961478777E-01],
	[8.35000E+03, 3.4219717071E+00, 6.6081729262E+00, 1.1533667133E-01, 1.0972339980E-01, 4.7976998568E-01],
	[8.35500E+03, 3.4246722527E+00, 6.6068572016E+00, 1.1555170322E-01, 1.0992041288E-01, 4.7992513353E-01],
	[8.36000E+03, 3.4273733119E+00, 6.6055425258E+00, 1.1576700701E-01, 1.1011765018E-01, 4.8008023149E-01],
	[8.36500E+03, 3.4300748846E+00, 6.6042288975E+00, 1.1598258287E-01, 1.1031511180E-01, 4.8023527971E-01],
	[8.37000E+03, 3.4327769704E+00, 6.6029163151E+00, 1.1619843098E-01, 1.1051279781E-01, 4.8039027838E-01],
	[8.37500E+03, 3.4354795694E+00, 6.6016047772E+00, 1.1641455154E-01, 1.1071070829E-01, 4.8054522765E-01],
	[8.38000E+03, 3.4381826811E+00, 6.6002942824E+00, 1.1663094472E-01, 1.1090884333E-01, 4.8070012769E-01],
	[8.38500E+03, 3.4408863055E+00, 6.5989848292E+00, 1.1684761069E-01, 1.1110720301E-01, 4.8085497866E-01],
	[8.39000E+03, 3.4435904422E+00, 6.5976764162E+00, 1.1706454965E-01, 1.1130578741E-01, 4.8100978074E-01],
	[8.39500E+03, 3.4462950912E+00, 6.5963690418E+00, 1.1728176177E-01, 1.1150459660E-01, 4.8116453404E-01],
	[8.40000E+03, 3.4490052729E+00, 6.5950907125E+00, 1.1749924724E-01, 1.1170364398E-01, 4.8131923871E-01],
	[8.40500E+03, 3.4517217799E+00, 6.5938457625E+00, 1.1771700622E-01, 1.1190293183E-01, 4.8147389488E-01],
	[8.41000E+03, 3.4544388090E+00, 6.5926017876E+00, 1.1793503892E-01, 1.1210244490E-01, 4.8162850269E-01],
	[8.41500E+03, 3.4571563600E+00, 6.5913587866E+00, 1.1815334550E-01, 1.1230218326E-01, 4.8178306226E-01],
	[8.42000E+03, 3.4598744328E+00, 6.5901167580E+00, 1.1837192614E-01, 1.1250214701E-01, 4.8193757374E-01],
	[8.42500E+03, 3.4625930270E+00, 6.5888757007E+00, 1.1859078104E-01, 1.1270233622E-01, 4.8209203726E-01],
	[8.43000E+03, 3.4653121426E+00, 6.5876356131E+00, 1.1880991036E-01, 1.1290275098E-01, 4.8224645294E-01],
	[8.43500E+03, 3.4680317793E+00, 6.5863964940E+00, 1.1902931429E-01, 1.1310339136E-01, 4.8240082093E-01],
	[8.44000E+03, 3.4707519368E+00, 6.5851583421E+00, 1.1924899302E-01, 1.1330425744E-01, 4.8255514136E-01],
	[8.44500E+03, 3.4734726150E+00, 6.5839211560E+00, 1.1946894672E-01, 1.1350534930E-01, 4.8270941436E-01],
	[8.45000E+03, 3.4761938137E+00, 6.5826849345E+00, 1.1968917557E-01, 1.1370666703E-01, 4.8286364007E-01],
	[8.45500E+03, 3.4789155327E+00, 6.5814496761E+00, 1.1990967975E-01, 1.1390821071E-01, 4.8301781861E-01],
	[8.46000E+03, 3.4816377717E+00, 6.5802153796E+00, 1.2013045945E-01, 1.1410998040E-01, 4.8317195013E-01],
	[8.46500E+03, 3.4843605305E+00, 6.5789820436E+00, 1.2035151485E-01, 1.1431197621E-01, 4.8332603474E-01],
	[8.47000E+03, 3.4870838090E+00, 6.5777496669E+00, 1.2057284613E-01, 1.1451419820E-01, 4.8348007259E-01],
	[8.47500E+03, 3.4898076069E+00, 6.5765182481E+00, 1.2079445346E-01, 1.1471664645E-01, 4.8363406381E-01],
	[8.48000E+03, 3.4925319240E+00, 6.5752877859E+00, 1.2101633704E-01, 1.1491932104E-01, 4.8378800853E-01],
	[8.48500E+03, 3.4952567601E+00, 6.5740582791E+00, 1.2123849703E-01, 1.1512222206E-01, 4.8394190688E-01],
	[8.49000E+03, 3.4979821151E+00, 6.5728297262E+00, 1.2146093363E-01, 1.1532534957E-01, 4.8409575900E-01],
	[8.49500E+03, 3.5007079886E+00, 6.5716021261E+00, 1.2168364701E-01, 1.1552870367E-01, 4.8424956500E-01],
	[8.50000E+03, 3.5034343805E+00, 6.5703754773E+00, 1.2190663736E-01, 1.1573228443E-01, 4.8440332504E-01],
	[8.50500E+03, 3.5061612906E+00, 6.5691497787E+00, 1.2212990485E-01, 1.1593609192E-01, 4.8455703923E-01],
	[8.51000E+03, 3.5088887187E+00, 6.5679250288E+00, 1.2235344967E-01, 1.1614012623E-01, 4.8471070771E-01],
	[8.51500E+03, 3.5116166646E+00, 6.5667012265E+00, 1.2257727200E-01, 1.1634438744E-01, 4.8486433061E-01],
	[8.52000E+03, 3.5143451280E+00, 6.5654783705E+00, 1.2280137202E-01, 1.1654887562E-01, 4.8501790806E-01],
	[8.52500E+03, 3.5170741088E+00, 6.5642564593E+00, 1.2302574991E-01, 1.1675359085E-01, 4.8517144020E-01],
	[8.53000E+03, 3.5198036067E+00, 6.5630354919E+00, 1.2325040585E-01, 1.1695853321E-01, 4.8532492714E-01],
	[8.53500E+03, 3.5225336216E+00, 6.5618154668E+00, 1.2347534002E-01, 1.1716370278E-01, 4.8547836903E-01],
	[8.54000E+03, 3.5252641532E+00, 6.5605963828E+00, 1.2370055261E-01, 1.1736909963E-01, 4.8563176599E-01],
	[8.54500E+03, 3.5279952014E+00, 6.5593782387E+00, 1.2392604380E-01, 1.1757472385E-01, 4.8578511815E-01],
	[8.55000E+03, 3.5307267659E+00, 6.5581610331E+00, 1.2415181376E-01, 1.1778057550E-01, 4.8593842564E-01],
	[8.55500E+03, 3.5334588465E+00, 6.5569447648E+00, 1.2437786269E-01, 1.1798665467E-01, 4.8609168859E-01],
	[8.56000E+03, 3.5361914431E+00, 6.5557294325E+00, 1.2460419075E-01, 1.1819296144E-01, 4.8624490714E-01],
	[8.56500E+03, 3.5389245554E+00, 6.5545150350E+00, 1.2483079813E-01, 1.1839949588E-01, 4.8639808141E-01],
	[8.57000E+03, 3.5416581832E+00, 6.5533015709E+00, 1.2505768502E-01, 1.1860625807E-01, 4.8655121152E-01],
	[8.57500E+03, 3.5443923263E+00, 6.5520890391E+00, 1.2528485159E-01, 1.1881324809E-01, 4.8670429762E-01],
	[8.58000E+03, 3.5471269845E+00, 6.5508774382E+00, 1.2551229803E-01, 1.1902046601E-01, 4.8685733982E-01],
	[8.58500E+03, 3.5498621577E+00, 6.5496667671E+00, 1.2574002451E-01, 1.1922791190E-01, 4.8701033826E-01],
	[8.59000E+03, 3.5525978455E+00, 6.5484570244E+00, 1.2596803122E-01, 1.1943558585E-01, 4.8716329307E-01],
	[8.59500E+03, 3.5553340479E+00, 6.5472482089E+00, 1.2619631834E-01, 1.1964348794E-01, 4.8731620437E-01],
	[8.60000E+03, 3.5580707645E+00, 6.5460403193E+00, 1.2642488606E-01, 1.1985161823E-01, 4.8746907229E-01],
	[8.60500E+03, 3.5608079953E+00, 6.5448333545E+00, 1.2665373454E-01, 1.2005997680E-01, 4.8762189697E-01],
	[8.61000E+03, 3.5635457399E+00, 6.5436273131E+00, 1.2688286398E-01, 1.2026856374E-01, 4.8777467852E-01],
	[8.61500E+03, 3.5662839982E+00, 6.5424221939E+00, 1.2711227456E-01, 1.2047737910E-01, 4.8792741708E-01],
	[8.62000E+03, 3.5690227701E+00, 6.5412179957E+00, 1.2734196645E-01, 1.2068642298E-01, 4.8808011277E-01],
	[8.62500E+03, 3.5717620552E+00, 6.5400147172E+00, 1.2757193984E-01, 1.2089569545E-01, 4.8823276573E-01],
	[8.63000E+03, 3.5745018534E+00, 6.5388123573E+00, 1.2780219491E-01, 1.2110519658E-01, 4.8838537608E-01],
	[8.63500E+03, 3.5772421645E+00, 6.5376109146E+00, 1.2803273184E-01, 1.2131492644E-01, 4.8853794394E-01],
	[8.64000E+03, 3.5799829883E+00, 6.5364103880E+00, 1.2826355082E-01, 1.2152488512E-01, 4.8869046945E-01],
	[8.64500E+03, 3.5827243245E+00, 6.5352107762E+00, 1.2849465202E-01, 1.2173507268E-01, 4.8884295272E-01],
	[8.65000E+03, 3.5854661731E+00, 6.5340120779E+00, 1.2872603562E-01, 1.2194548920E-01, 4.8899539390E-01],
	[8.65500E+03, 3.5882085337E+00, 6.5328142921E+00, 1.2895770182E-01, 1.2215613476E-01, 4.8914779310E-01],
	[8.66000E+03, 3.5909514062E+00, 6.5316174173E+00, 1.2918965078E-01, 1.2236700943E-01, 4.8930015046E-01],
	[8.66500E+03, 3.5936947904E+00, 6.5304214525E+00, 1.2942188270E-01, 1.2257811328E-01, 4.8945246609E-01],
	[8.67000E+03, 3.5964386861E+00, 6.5292263965E+00, 1.2965439774E-01, 1.2278944640E-01, 4.8960474013E-01],
	[8.67500E+03, 3.5991830931E+00, 6.5280322479E+00, 1.2988719610E-01, 1.2300100884E-01, 4.8975697270E-01],
	[8.68000E+03, 3.6019280111E+00, 6.5268390056E+00, 1.3012027796E-01, 1.2321280069E-01, 4.8990916392E-01],
	[8.68500E+03, 3.6046734401E+00, 6.5256466683E+00, 1.3035364349E-01, 1.2342482202E-01, 4.9006131393E-01],
	[8.69000E+03, 3.6074193797E+00, 6.5244552350E+00, 1.3058729289E-01, 1.2363707291E-01, 4.9021342285E-01],
	[8.69500E+03, 3.6101658298E+00, 6.5232647043E+00, 1.3082122632E-01, 1.2384955342E-01, 4.9036549081E-01],
	[8.70000E+03, 3.6129127902E+00, 6.5220750750E+00, 1.3105544398E-01, 1.2406226364E-01, 4.9051751792E-01],
	[8.70500E+03, 3.6156602607E+00, 6.5208863461E+00, 1.3128994604E-01, 1.2427520363E-01, 4.9066950432E-01],
	[8.71000E+03, 3.6184082411E+00, 6.5196985161E+00, 1.3152473268E-01, 1.2448837346E-01, 4.9082145013E-01],
	[8.71500E+03, 3.6211567312E+00, 6.5185115841E+00, 1.3175980410E-01, 1.2470177321E-01, 4.9097335548E-01],
	[8.72000E+03, 3.6239057307E+00, 6.5173255487E+00, 1.3199516046E-01, 1.2491540296E-01, 4.9112522049E-01],
	[8.72500E+03, 3.6266552396E+00, 6.5161404088E+00, 1.3223080195E-01, 1.2512926277E-01, 4.9127704529E-01],
	[8.73000E+03, 3.6294052576E+00, 6.5149561632E+00, 1.3246672876E-01, 1.2534335272E-01, 4.9142883000E-01],
	[8.73500E+03, 3.6321602441E+00, 6.5137982268E+00, 1.3270294106E-01, 1.2555768766E-01, 4.9158057475E-01],
	[8.74000E+03, 3.6349207380E+00, 6.5126695962E+00, 1.3293943903E-01, 1.2577226955E-01, 4.9173227965E-01],
	[8.74500E+03, 3.6376817493E+00, 6.5115418065E+00, 1.3317622287E-01, 1.2598708197E-01, 4.9188394485E-01],
	[8.75000E+03, 3.6404432779E+00, 6.5104148566E+00, 1.3341329274E-01, 1.2620212502E-01, 4.9203557045E-01],
	[8.75500E+03, 3.6432053235E+00, 6.5092887453E+00, 1.3365064883E-01, 1.2641739875E-01, 4.9218715659E-01],
	[8.76000E+03, 3.6459678859E+00, 6.5081634716E+00, 1.3388829133E-01, 1.2663290323E-01, 4.9233870338E-01],
	[8.76500E+03, 3.6487309650E+00, 6.5070390343E+00, 1.3412622041E-01, 1.2684863855E-01, 4.9249021096E-01],
	[8.77000E+03, 3.6514945605E+00, 6.5059154324E+00, 1.3436443626E-01, 1.2706460477E-01, 4.9264167945E-01],
	[8.77500E+03, 3.6542586723E+00, 6.5047926647E+00, 1.3460293906E-01, 1.2728080197E-01, 4.9279310896E-01],
	[8.78000E+03, 3.6570233001E+00, 6.5036707302E+00, 1.3484172899E-01, 1.2749723021E-01, 4.9294449963E-01],
	[8.78500E+03, 3.6597884438E+00, 6.5025496278E+00, 1.3508080623E-01, 1.2771388956E-01, 4.9309585158E-01],
	[8.79000E+03, 3.6625541031E+00, 6.5014293564E+00, 1.3532017097E-01, 1.2793078011E-01, 4.9324716492E-01],
	[8.79500E+03, 3.6653202779E+00, 6.5003099149E+00, 1.3555982338E-01, 1.2814790192E-01, 4.9339843979E-01],
	[8.80000E+03, 3.6680869679E+00, 6.4991913022E+00, 1.3579976365E-01, 1.2836525506E-01, 4.9354967631E-01],
	[8.80500E+03, 3.6708541730E+00, 6.4980735172E+00, 1.3603999196E-01, 1.2858283960E-01, 4.9370087460E-01],
	[8.81000E+03, 3.6736218930E+00, 6.4969565589E+00, 1.3628050849E-01, 1.2880065562E-01, 4.9385203478E-01],
	[8.81500E+03, 3.6763901276E+00, 6.4958404261E+00, 1.3652131343E-01, 1.2901870318E-01, 4.9400315698E-01],
	[8.82000E+03, 3.6791588767E+00, 6.4947251178E+00, 1.3676240695E-01, 1.2923698235E-01, 4.9415424131E-01],
	[8.82500E+03, 3.6819281401E+00, 6.4936106330E+00, 1.3700378924E-01, 1.2945549321E-01, 4.9430528791E-01],
	[8.83000E+03, 3.6846979175E+00, 6.4924969705E+00, 1.3724546048E-01, 1.2967423583E-01, 4.9445629689E-01],
	[8.83500E+03, 3.6874682089E+00, 6.4913841292E+00, 1.3748742085E-01, 1.2989321027E-01, 4.9460726838E-01],
	[8.84000E+03, 3.6902390139E+00, 6.4902721081E+00, 1.3772967053E-01, 1.3011241661E-01, 4.9475820250E-01],
	[8.84500E+03, 3.6930103325E+00, 6.4891609062E+00, 1.3797220971E-01, 1.3033185491E-01, 4.9490909936E-01],
	[8.85000E+03, 3.6957821643E+00, 6.4880505224E+00, 1.3821503857E-01, 1.3055152525E-01, 4.9505995910E-01],
	[8.85500E+03, 3.6985545092E+00, 6.4869409555E+00, 1.3845815729E-01, 1.3077142769E-01, 4.9521078184E-01],
	[8.86000E+03, 3.7013273671E+00, 6.4858322046E+00, 1.3870156605E-01, 1.3099156231E-01, 4.9536156769E-01],
	[8.86500E+03, 3.7041007376E+00, 6.4847242685E+00, 1.3894526503E-01, 1.3121192918E-01, 4.9551231678E-01],
	[8.87000E+03, 3.7068746207E+00, 6.4836171463E+00, 1.3918925442E-01, 1.3143252835E-01, 4.9566302923E-01],
	[8.87500E+03, 3.7096490161E+00, 6.4825108368E+00, 1.3943353440E-01, 1.3165335991E-01, 4.9581370517E-01],
	[8.88000E+03, 3.7124239236E+00, 6.4814053390E+00, 1.3967810514E-01, 1.3187442392E-01, 4.9596434470E-01],
	[8.88500E+03, 3.7151993431E+00, 6.4803006519E+00, 1.3992296684E-01, 1.3209572045E-01, 4.9611494796E-01],
	[8.89000E+03, 3.7179752743E+00, 6.4791967744E+00, 1.4016811967E-01, 1.3231724957E-01, 4.9626551507E-01],
	[8.89500E+03, 3.7207517171E+00, 6.4780937055E+00, 1.4041356382E-01, 1.3253901134E-01, 4.9641604614E-01],
	[8.90000E+03, 3.7235286712E+00, 6.4769914441E+00, 1.4065929947E-01, 1.3276100584E-01, 4.9656654130E-01],
	[8.90500E+03, 3.7263061365E+00, 6.4758899891E+00, 1.4090532680E-01, 1.3298323313E-01, 4.9671700067E-01],
	[8.91000E+03, 3.7290841127E+00, 6.4747893396E+00, 1.4115164599E-01, 1.3320569329E-01, 4.9686742437E-01],
	[8.91500E+03, 3.7318625997E+00, 6.4736894944E+00, 1.4139825723E-01, 1.3342838637E-01, 4.9701781253E-01],
	[8.92000E+03, 3.7346415974E+00, 6.4725904526E+00, 1.4164516069E-01, 1.3365131245E-01, 4.9716816525E-01],
	[8.92500E+03, 3.7374211054E+00, 6.4714922131E+00, 1.4189235656E-01, 1.3387447160E-01, 4.9731848266E-01],
	[8.93000E+03, 3.7402011236E+00, 6.4703947749E+00, 1.4213984503E-01, 1.3409786388E-01, 4.9746876489E-01],
	[8.93500E+03, 3.7429816518E+00, 6.4692981370E+00, 1.4238762626E-01, 1.3432148935E-01, 4.9761901205E-01],
	[8.94000E+03, 3.7457626898E+00, 6.4682022982E+00, 1.4263570046E-01, 1.3454534810E-01, 4.9776922426E-01],
	[8.94500E+03, 3.7485442375E+00, 6.4671072576E+00, 1.4288406779E-01, 1.3476944018E-01, 4.9791940164E-01],
	[8.95000E+03, 3.7513262946E+00, 6.4660130142E+00, 1.4313272844E-01, 1.3499376565E-01, 4.9806954432E-01],
	[8.95500E+03, 3.7541088609E+00, 6.4649195669E+00, 1.4338168259E-01, 1.3521832460E-01, 4.9821965241E-01],
	[8.96000E+03, 3.7568919363E+00, 6.4638269147E+00, 1.4363093043E-01, 1.3544311708E-01, 4.9836972603E-01],
	[8.96500E+03, 3.7596755205E+00, 6.4627350566E+00, 1.4388047214E-01, 1.3566814316E-01, 4.9851976530E-01],
	[8.97000E+03, 3.7624596134E+00, 6.4616439916E+00, 1.4413030790E-01, 1.3589340291E-01, 4.9866977030E-01],
	[8.97500E+03, 3.7652442148E+00, 6.4605537186E+00, 1.4438043788E-01, 1.3611889639E-01, 4.9881974110E-01],
	[8.98000E+03, 3.7680293245E+00, 6.4594642367E+00, 1.4463086229E-01, 1.3634462366E-01, 4.9896967781E-01],
	[8.98500E+03, 3.7708149423E+00, 6.4583755448E+00, 1.4488158128E-01, 1.3657058481E-01, 4.9911958050E-01],
	[8.99000E+03, 3.7736010680E+00, 6.4572876419E+00, 1.4513259506E-01, 1.3679677988E-01, 4.9926944926E-01],
	[8.99500E+03, 3.7763877014E+00, 6.4562005269E+00, 1.4538390380E-01, 1.3702320895E-01, 4.9941928419E-01],
	[9.00000E+03, 3.7791748423E+00, 6.4551141990E+00, 1.4563550768E-01, 1.3724987208E-01, 4.9956908538E-01],
	[9.00500E+03, 3.7819624906E+00, 6.4540286571E+00, 1.4588904845E-01, 1.3747822708E-01, 4.9971885291E-01],
	[9.01000E+03, 3.7847506460E+00, 6.4529439001E+00, 1.4614288951E-01, 1.3770682007E-01, 4.9986858687E-01],
	[9.01500E+03, 3.7875393083E+00, 6.4518599271E+00, 1.4639703105E-01, 1.3793565111E-01, 5.0001828736E-01],
	[9.02000E+03, 3.7903284775E+00, 6.4507767371E+00, 1.4665147325E-01, 1.3816472029E-01, 5.0016795445E-01],
	[9.02500E+03, 3.7931181532E+00, 6.4496943290E+00, 1.4690621631E-01, 1.3839402765E-01, 5.0031758824E-01],
	[9.03000E+03, 3.7959083353E+00, 6.4486127020E+00, 1.4716126042E-01, 1.3862357328E-01, 5.0046718882E-01],
	[9.03500E+03, 3.7986990236E+00, 6.4475318549E+00, 1.4741660576E-01, 1.3885335724E-01, 5.0061675628E-01],
	[9.04000E+03, 3.8014902180E+00, 6.4464517868E+00, 1.4767225251E-01, 1.3908337959E-01, 5.0076629070E-01],
	[9.04500E+03, 3.8042819181E+00, 6.4453724967E+00, 1.4792820089E-01, 1.3931364041E-01, 5.0091579218E-01],
	[9.05000E+03, 3.8070741239E+00, 6.4442939836E+00, 1.4818445105E-01, 1.3954413975E-01, 5.0106526079E-01],
	[9.05500E+03, 3.8098668352E+00, 6.4432162465E+00, 1.4844100321E-01, 1.3977487770E-01, 5.0121469664E-01],
	[9.06000E+03, 3.8126600517E+00, 6.4421392845E+00, 1.4869785755E-01, 1.4000585431E-01, 5.0136409981E-01],
	[9.06500E+03, 3.8154537733E+00, 6.4410630965E+00, 1.4895501425E-01, 1.4023706965E-01, 5.0151347038E-01],
	[9.07000E+03, 3.8182479998E+00, 6.4399876815E+00, 1.4921247351E-01, 1.4046852379E-01, 5.0166280844E-01],
	[9.07500E+03, 3.8210427309E+00, 6.4389130387E+00, 1.4947023551E-01, 1.4070021680E-01, 5.0181211409E-01],
	[9.08000E+03, 3.8238379666E+00, 6.4378391669E+00, 1.4972830044E-01, 1.4093214873E-01, 5.0196138742E-01],
	[9.08500E+03, 3.8266403099E+00, 6.4368047804E+00, 1.4998666849E-01, 1.4116434727E-01, 5.0211062850E-01],
	[9.09000E+03, 3.8294447350E+00, 6.4357803364E+00, 1.5024533986E-01, 1.4139679162E-01, 5.0225983742E-01],
	[9.09500E+03, 3.8322496716E+00, 6.4347566186E+00, 1.5050431472E-01, 1.4162947530E-01, 5.0240901429E-01],
	[9.10000E+03, 3.8350551195E+00, 6.4337336263E+00, 1.5076359327E-01, 1.4186239837E-01, 5.0255815917E-01],
	[9.10500E+03, 3.8378610784E+00, 6.4327113583E+00, 1.5102317571E-01, 1.4209556089E-01, 5.0270727217E-01],
	[9.11000E+03, 3.8406675481E+00, 6.4316898139E+00, 1.5128306220E-01, 1.4232896295E-01, 5.0285635336E-01],
	[9.11500E+03, 3.8434745285E+00, 6.4306689920E+00, 1.5154325295E-01, 1.4256260459E-01, 5.0300540285E-01],
	[9.12000E+03, 3.8462820194E+00, 6.4296488919E+00, 1.5180374815E-01, 1.4279648589E-01, 5.0315442070E-01],
	[9.12500E+03, 3.8490900205E+00, 6.4286295126E+00, 1.5206454798E-01, 1.4303060692E-01, 5.0330340702E-01],
	[9.13000E+03, 3.8518985318E+00, 6.4276108531E+00, 1.5232565263E-01, 1.4326496773E-01, 5.0345236188E-01],
	[9.13500E+03, 3.8547075530E+00, 6.4265929127E+00, 1.5258706229E-01, 1.4349956839E-01, 5.0360128539E-01],
	[9.14000E+03, 3.8575170839E+00, 6.4255756903E+00, 1.5284877716E-01, 1.4373440898E-01, 5.0375017761E-01],
	[9.14500E+03, 3.8603271243E+00, 6.4245591852E+00, 1.5311079741E-01, 1.4396948954E-01, 5.0389903865E-01],
	[9.15000E+03, 3.8631376742E+00, 6.4235433963E+00, 1.5337312324E-01, 1.4420481016E-01, 5.0404786858E-01],
	[9.15500E+03, 3.8659487331E+00, 6.4225283229E+00, 1.5363575484E-01, 1.4444037088E-01, 5.0419666751E-01],
	[9.16000E+03, 3.8687603011E+00, 6.4215139639E+00, 1.5389869240E-01, 1.4467617179E-01, 5.0434543550E-01],
	[9.16500E+03, 3.8715723779E+00, 6.4205003186E+00, 1.5416193610E-01, 1.4491221293E-01, 5.0449417266E-01],
	[9.17000E+03, 3.8743849633E+00, 6.4194873859E+00, 1.5442548614E-01, 1.4514849439E-01, 5.0464287906E-01],
	[9.17500E+03, 3.8771980571E+00, 6.4184751651E+00, 1.5468934270E-01, 1.4538501621E-01, 5.0479155479E-01],
	[9.18000E+03, 3.8800116592E+00, 6.4174636553E+00, 1.5495350598E-01, 1.4562177847E-01, 5.0494019995E-01],
	[9.18500E+03, 3.8828257693E+00, 6.4164528555E+00, 1.5521797616E-01, 1.4585878122E-01, 5.0508881462E-01],
	[9.19000E+03, 3.8856403873E+00, 6.4154427649E+00, 1.5548275343E-01, 1.4609602453E-01, 5.0523739888E-01],
	[9.19500E+03, 3.8884555130E+00, 6.4144333826E+00, 1.5574783798E-01, 1.4633350847E-01, 5.0538595282E-01],
	[9.20000E+03, 3.8912711462E+00, 6.4134247076E+00, 1.5601323000E-01, 1.4657123310E-01, 5.0553447653E-01],
	[9.20500E+03, 3.8940872867E+00, 6.4124167393E+00, 1.5627892968E-01, 1.4680919848E-01, 5.0568297010E-01],
	[9.21000E+03, 3.8969039343E+00, 6.4114094765E+00, 1.5654493721E-01, 1.4704740467E-01, 5.0583143361E-01],
	[9.21500E+03, 3.8997210889E+00, 6.4104029186E+00, 1.5681125278E-01, 1.4728585174E-01, 5.0597986715E-01],
	[9.22000E+03, 3.9025387503E+00, 6.4093970645E+00, 1.5707787658E-01, 1.4752453975E-01, 5.0612827080E-01],
	[9.22500E+03, 3.9053569183E+00, 6.4083919135E+00, 1.5734480879E-01, 1.4776346876E-01, 5.0627664466E-01],
	[9.23000E+03, 3.9081755926E+00, 6.4073874646E+00, 1.5761204961E-01, 1.4800263884E-01, 5.0642498880E-01],
	[9.23500E+03, 3.9109947732E+00, 6.4063837170E+00, 1.5787959922E-01, 1.4824205004E-01, 5.0657330332E-01],
	[9.24000E+03, 3.9138144598E+00, 6.4053806698E+00, 1.5814745782E-01, 1.4848170244E-01, 5.0672158830E-01],
	[9.24500E+03, 3.9166346522E+00, 6.4043783222E+00, 1.5841562559E-01, 1.4872159608E-01, 5.0686984383E-01],
	[9.25000E+03, 3.9194553504E+00, 6.4033766732E+00, 1.5868410273E-01, 1.4896173103E-01, 5.0701807000E-01],
	[9.25500E+03, 3.9222765540E+00, 6.4023757221E+00, 1.5895288941E-01, 1.4920210736E-01, 5.0716626688E-01],
	[9.26000E+03, 3.9250982629E+00, 6.4013754679E+00, 1.5922198584E-01, 1.4944272513E-01, 5.0731443457E-01],
	[9.26500E+03, 3.9279204769E+00, 6.4003759098E+00, 1.5949139221E-01, 1.4968358439E-01, 5.0746257316E-01],
	[9.27000E+03, 3.9307431959E+00, 6.3993770470E+00, 1.5976110869E-01, 1.4992468521E-01, 5.0761068272E-01],
	[9.27500E+03, 3.9335664196E+00, 6.3983788785E+00, 1.6003113548E-01, 1.5016602766E-01, 5.0775876335E-01],
	[9.28000E+03, 3.9363901479E+00, 6.3973814036E+00, 1.6030147277E-01, 1.5040761178E-01, 5.0790681512E-01],
	[9.28500E+03, 3.9392143806E+00, 6.3963846213E+00, 1.6057212076E-01, 1.5064943764E-01, 5.0805483814E-01],
	[9.29000E+03, 3.9420391176E+00, 6.3953885308E+00, 1.6084307962E-01, 1.5089150530E-01, 5.0820283248E-01],
	[9.29500E+03, 3.9448643585E+00, 6.3943931312E+00, 1.6111434955E-01, 1.5113381482E-01, 5.0835079823E-01],
	[9.30000E+03, 3.9476901033E+00, 6.3933984218E+00, 1.6138593073E-01, 1.5137636627E-01, 5.0849873547E-01],
	[9.30500E+03, 3.9505163517E+00, 6.3924044017E+00, 1.6165782336E-01, 1.5161915970E-01, 5.0864664429E-01],
	[9.31000E+03, 3.9533431037E+00, 6.3914110699E+00, 1.6193002764E-01, 1.5186219517E-01, 5.0879452478E-01],
	[9.31500E+03, 3.9561703589E+00, 6.3904184257E+00, 1.6220254373E-01, 1.5210547274E-01, 5.0894237703E-01],
	[9.32000E+03, 3.9589981173E+00, 6.3894264683E+00, 1.6247537184E-01, 1.5234899248E-01, 5.0909020111E-01],
	[9.32500E+03, 3.9618263786E+00, 6.3884351967E+00, 1.6274851216E-01, 1.5259275443E-01, 5.0923799711E-01],
	[9.33000E+03, 3.9646551427E+00, 6.3874446101E+00, 1.6302196487E-01, 1.5283675867E-01, 5.0938576513E-01],
	[9.33500E+03, 3.9674844093E+00, 6.3864547078E+00, 1.6329573017E-01, 1.5308100524E-01, 5.0953350523E-01],
	[9.34000E+03, 3.9703141784E+00, 6.3854654888E+00, 1.6356980824E-01, 1.5332549422E-01, 5.0968121752E-01],
	[9.34500E+03, 3.9731444497E+00, 6.3844769523E+00, 1.6384419928E-01, 1.5357022565E-01, 5.0982890208E-01],
	[9.35000E+03, 3.9759752230E+00, 6.3834890975E+00, 1.6411890347E-01, 1.5381519959E-01, 5.0997655898E-01],
	[9.35500E+03, 3.9788064982E+00, 6.3825019235E+00, 1.6439392100E-01, 1.5406041611E-01, 5.1012418833E-01],
	[9.36000E+03, 3.9816382751E+00, 6.3815154296E+00, 1.6466925206E-01, 1.5430587527E-01, 5.1027179019E-01],
	[9.36500E+03, 3.9844705535E+00, 6.3805296148E+00, 1.6494489685E-01, 1.5455157711E-01, 5.1041936467E-01],
	[9.37000E+03, 3.9873033332E+00, 6.3795444784E+00, 1.6522085554E-01, 1.5479752171E-01, 5.1056691183E-01],
	[9.37500E+03, 3.9901366141E+00, 6.3785600196E+00, 1.6549712834E-01, 1.5504370911E-01, 5.1071443178E-01],
	[9.38000E+03, 3.9929703959E+00, 6.3775762374E+00, 1.6577371544E-01, 1.5529013937E-01, 5.1086192459E-01],
	[9.38500E+03, 3.9958046786E+00, 6.3765931311E+00, 1.6605061701E-01, 1.5553681256E-01, 5.1100939034E-01],
	[9.39000E+03, 3.9986394618E+00, 6.3756106999E+00, 1.6632783325E-01, 1.5578372873E-01, 5.1115682913E-01],
	[9.39500E+03, 4.0014747455E+00, 6.3746289429E+00, 1.6660536436E-01, 1.5603088793E-01, 5.1130424104E-01],
	[9.40000E+03, 4.0043105294E+00, 6.3736478593E+00, 1.6688321051E-01, 1.5627829023E-01, 5.1145162616E-01],
	[9.40500E+03, 4.0071468134E+00, 6.3726674482E+00, 1.6716137190E-01, 1.5652593569E-01, 5.1159898456E-01],
	[9.41000E+03, 4.0099835974E+00, 6.3716877090E+00, 1.6743984873E-01, 1.5677382435E-01, 5.1174631634E-01],
	[9.41500E+03, 4.0128208810E+00, 6.3707086407E+00, 1.6771864117E-01, 1.5702195627E-01, 5.1189362157E-01],
	[9.42000E+03, 4.0156586642E+00, 6.3697302425E+00, 1.6799774943E-01, 1.5727033152E-01, 5.1204090035E-01],
	[9.42500E+03, 4.0184969467E+00, 6.3687525137E+00, 1.6827717368E-01, 1.5751895014E-01, 5.1218815276E-01],
	[9.43000E+03, 4.0213357285E+00, 6.3677754533E+00, 1.6855691412E-01, 1.5776781220E-01, 5.1233537888E-01],
	[9.43500E+03, 4.0241750092E+00, 6.3667990607E+00, 1.6883697094E-01, 1.5801691774E-01, 5.1248257880E-01],
	[9.44000E+03, 4.0270147888E+00, 6.3658233350E+00, 1.6911734433E-01, 1.5826626684E-01, 5.1262975261E-01],
	[9.44500E+03, 4.0298576717E+00, 6.3648638298E+00, 1.6939803448E-01, 1.5851587321E-01, 5.1277690038E-01],
	[9.45000E+03, 4.0327055871E+00, 6.3639320180E+00, 1.6967904158E-01, 1.5876574717E-01, 5.1292402221E-01],
	[9.45500E+03, 4.0355540072E+00, 6.3630008354E+00, 1.6996036582E-01, 1.5901586505E-01, 5.1307111817E-01],
	[9.46000E+03, 4.0384029316E+00, 6.3620702812E+00, 1.7024200738E-01, 1.5926622691E-01, 5.1321818836E-01],
	[9.46500E+03, 4.0412523603E+00, 6.3611403547E+00, 1.7052396647E-01, 1.5951683281E-01, 5.1336523285E-01],
	[9.47000E+03, 4.0441022931E+00, 6.3602110552E+00, 1.7080624326E-01, 1.5976768279E-01, 5.1351225174E-01],
	[9.47500E+03, 4.0469527298E+00, 6.3592823819E+00, 1.7108883795E-01, 1.6001877692E-01, 5.1365924510E-01],
	[9.48000E+03, 4.0498036702E+00, 6.3583543339E+00, 1.7137175073E-01, 1.6027011525E-01, 5.1380621302E-01],
	[9.48500E+03, 4.0526551141E+00, 6.3574269107E+00, 1.7165498179E-01, 1.6052169783E-01, 5.1395315559E-01],
	[9.49000E+03, 4.0555070614E+00, 6.3565001114E+00, 1.7193853131E-01, 1.6077352473E-01, 5.1410007289E-01],
	[9.49500E+03, 4.0583595118E+00, 6.3555739352E+00, 1.7222239950E-01, 1.6102559598E-01, 5.1424696500E-01],
	[9.50000E+03, 4.0612124653E+00, 6.3546483815E+00, 1.7250658653E-01, 1.6127791166E-01, 5.1439383202E-01],
	[9.50500E+03, 4.0640659216E+00, 6.3537234495E+00, 1.7279109260E-01, 1.6153047182E-01, 5.1454067401E-01],
	[9.51000E+03, 4.0669198806E+00, 6.3527991384E+00, 1.7307591790E-01, 1.6178327650E-01, 5.1468749106E-01],
	[9.51500E+03, 4.0697743420E+00, 6.3518754475E+00, 1.7336106262E-01, 1.6203632577E-01, 5.1483428320E-01],
	[9.52000E+03, 4.0726293058E+00, 6.3509523761E+00, 1.7364652694E-01, 1.6228961967E-01, 5.1498105048E-01],
	[9.52500E+03, 4.0754847717E+00, 6.3500299233E+00, 1.7393231107E-01, 1.6254315827E-01, 5.1512779297E-01],
	[9.53000E+03, 4.0783407395E+00, 6.3491080886E+00, 1.7421841518E-01, 1.6279694160E-01, 5.1527451073E-01],
	[9.53500E+03, 4.0811972091E+00, 6.3481868711E+00, 1.7450483948E-01, 1.6305096974E-01, 5.1542120380E-01],
	[9.54000E+03, 4.0840541803E+00, 6.3472662701E+00, 1.7479158414E-01, 1.6330524273E-01, 5.1556787226E-01],
	[9.54500E+03, 4.0869116530E+00, 6.3463462849E+00, 1.7507864936E-01, 1.6355976063E-01, 5.1571451615E-01],
	[9.55000E+03, 4.0897696269E+00, 6.3454269147E+00, 1.7536603533E-01, 1.6381452348E-01, 5.1586113553E-01],
	[9.55500E+03, 4.0926281019E+00, 6.3445081588E+00, 1.7565374224E-01, 1.6406953135E-01, 5.1600773047E-01],
	[9.56000E+03, 4.0954870778E+00, 6.3435900165E+00, 1.7594177028E-01, 1.6432478428E-01, 5.1615430102E-01],
	[9.56500E+03, 4.0983465544E+00, 6.3426724870E+00, 1.7623011964E-01, 1.6458028232E-01, 5.1630084724E-01],
	[9.57000E+03, 4.1012065316E+00, 6.3417555696E+00, 1.7651879052E-01, 1.6483602554E-01, 5.1644736919E-01],
	[9.57500E+03, 4.1040670091E+00, 6.3408392636E+00, 1.7680778309E-01, 1.6509201398E-01, 5.1659386692E-01],
	[9.58000E+03, 4.1069279869E+00, 6.3399235683E+00, 1.7709709755E-01, 1.6534824769E-01, 5.1674034049E-01],
	[9.58500E+03, 4.1097894647E+00, 6.3390084829E+00, 1.7738673409E-01, 1.6560472673E-01, 5.1688678997E-01],
	[9.59000E+03, 4.1126514423E+00, 6.3380940067E+00, 1.7767669291E-01, 1.6586145114E-01, 5.1703321541E-01],
	[9.59500E+03, 4.1155139197E+00, 6.3371801390E+00, 1.7796697418E-01, 1.6611842099E-01, 5.1717961686E-01],
	[9.60000E+03, 4.1183768966E+00, 6.3362668790E+00, 1.7825757811E-01, 1.6637563631E-01, 5.1732599439E-01],
	[9.60500E+03, 4.1212403728E+00, 6.3353542261E+00, 1.7854850488E-01, 1.6663309717E-01, 5.1747234805E-01],
	[9.61000E+03, 4.1241043482E+00, 6.3344421795E+00, 1.7883975468E-01, 1.6689080361E-01, 5.1761867790E-01],
	[9.61500E+03, 4.1269688225E+00, 6.3335307385E+00, 1.7913132770E-01, 1.6714875569E-01, 5.1776498400E-01],
	[9.62000E+03, 4.1298337957E+00, 6.3326199024E+00, 1.7942322414E-01, 1.6740695345E-01, 5.1791126641E-01],
	[9.62500E+03, 4.1326992676E+00, 6.3317096705E+00, 1.7971544418E-01, 1.6766539695E-01, 5.1805752518E-01],
	[9.63000E+03, 4.1355652379E+00, 6.3308000420E+00, 1.8000798802E-01, 1.6792408624E-01, 5.1820376037E-01],
	[9.63500E+03, 4.1384317066E+00, 6.3298910163E+00, 1.8030085583E-01, 1.6818302136E-01, 5.1834997205E-01],
	[9.64000E+03, 4.1412986733E+00, 6.3289825926E+00, 1.8059404783E-01, 1.6844220238E-01, 5.1849616026E-01],
	[9.64500E+03, 4.1441661381E+00, 6.3280747702E+00, 1.8088756419E-01, 1.6870162933E-01, 5.1864232507E-01],
	[9.65000E+03, 4.1470341006E+00, 6.3271675484E+00, 1.8118140510E-01, 1.6896130226E-01, 5.1878846653E-01],
	[9.65500E+03, 4.1499025607E+00, 6.3262609266E+00, 1.8147557076E-01, 1.6922122124E-01, 5.1893458471E-01],
	[9.66000E+03, 4.1527715183E+00, 6.3253549039E+00, 1.8177006135E-01, 1.6948138630E-01, 5.1908067965E-01],
	[9.66500E+03, 4.1556409732E+00, 6.3244494797E+00, 1.8206487708E-01, 1.6974179750E-01, 5.1922675143E-01],
	[9.67000E+03, 4.1585109252E+00, 6.3235446533E+00, 1.8236001812E-01, 1.7000245489E-01, 5.1937280008E-01],
	[9.67500E+03, 4.1613813741E+00, 6.3226404240E+00, 1.8265548466E-01, 1.7026335851E-01, 5.1951882568E-01],
	[9.68000E+03, 4.1642523198E+00, 6.3217367911E+00, 1.8295127691E-01, 1.7052450842E-01, 5.1966482829E-01],
	[9.68500E+03, 4.1671237621E+00, 6.3208337539E+00, 1.8324739504E-01, 1.7078590466E-01, 5.1981080795E-01],
	[9.69000E+03, 4.1699957008E+00, 6.3199313116E+00, 1.8354383926E-01, 1.7104754728E-01, 5.1995676472E-01],
	[9.69500E+03, 4.1728681357E+00, 6.3190294636E+00, 1.8384060974E-01, 1.7130943633E-01, 5.2010269868E-01],
	[9.70000E+03, 4.1757410667E+00, 6.3181282092E+00, 1.8413770668E-01, 1.7157157187E-01, 5.2024860986E-01],
	[9.70500E+03, 4.1786144937E+00, 6.3172275477E+00, 1.8443513028E-01, 1.7183395392E-01, 5.2039449834E-01],
	[9.71000E+03, 4.1814884164E+00, 6.3163274784E+00, 1.8473288071E-01, 1.7209658256E-01, 5.2054036416E-01],
	[9.71500E+03, 4.1843628346E+00, 6.3154280005E+00, 1.8503095818E-01, 1.7235945781E-01, 5.2068620738E-01],
	[9.72000E+03, 4.1872377483E+00, 6.3145291135E+00, 1.8532936287E-01, 1.7262257974E-01, 5.2083202808E-01],
	[9.72500E+03, 4.1901131572E+00, 6.3136308166E+00, 1.8562809497E-01, 1.7288594839E-01, 5.2097782629E-01],
	[9.73000E+03, 4.1929890611E+00, 6.3127331091E+00, 1.8592715468E-01, 1.7314956380E-01, 5.2112360208E-01],
	[9.73500E+03, 4.1958654600E+00, 6.3118359904E+00, 1.8622654218E-01, 1.7341342602E-01, 5.2126935551E-01],
	[9.74000E+03, 4.1987423536E+00, 6.3109394597E+00, 1.8652625767E-01, 1.7367753511E-01, 5.2141508663E-01],
	[9.74500E+03, 4.2016197417E+00, 6.3100435163E+00, 1.8682630133E-01, 1.7394189110E-01, 5.2156079550E-01],
	[9.75000E+03, 4.2044976242E+00, 6.3091481596E+00, 1.8712667336E-01, 1.7420649405E-01, 5.2170648218E-01],
	[9.75500E+03, 4.2073760010E+00, 6.3082533890E+00, 1.8742737395E-01, 1.7447134399E-01, 5.2185214673E-01],
	[9.76000E+03, 4.2102548718E+00, 6.3073592036E+00, 1.8772840328E-01, 1.7473644099E-01, 5.2199778921E-01],
	[9.76500E+03, 4.2131342364E+00, 6.3064656028E+00, 1.8802976155E-01, 1.7500178507E-01, 5.2214340967E-01],
	[9.77000E+03, 4.2160140948E+00, 6.3055725860E+00, 1.8833144895E-01, 1.7526737630E-01, 5.2228900817E-01],
	[9.77500E+03, 4.2188944468E+00, 6.3046801524E+00, 1.8863346568E-01, 1.7553321471E-01, 5.2243458476E-01],
	[9.78000E+03, 4.2217752921E+00, 6.3037883014E+00, 1.8893581191E-01, 1.7579930035E-01, 5.2258013952E-01],
	[9.78500E+03, 4.2246566306E+00, 6.3028970324E+00, 1.8923848785E-01, 1.7606563327E-01, 5.2272567249E-01],
	[9.79000E+03, 4.2275384622E+00, 6.3020063445E+00, 1.8954149367E-01, 1.7633221351E-01, 5.2287118372E-01],
	[9.79500E+03, 4.2304207866E+00, 6.3011162372E+00, 1.8984482958E-01, 1.7659904112E-01, 5.2301667329E-01],
	[9.80000E+03, 4.2333036038E+00, 6.3002267098E+00, 1.9014849577E-01, 1.7686611614E-01, 5.2316214124E-01],
	[9.80500E+03, 4.2361869134E+00, 6.2993377616E+00, 1.9045249242E-01, 1.7713343862E-01, 5.2330758764E-01],
	[9.81000E+03, 4.2390707155E+00, 6.2984493919E+00, 1.9075681972E-01, 1.7740100860E-01, 5.2345301254E-01],
	[9.81500E+03, 4.2419550098E+00, 6.2975616000E+00, 1.9106147787E-01, 1.7766882613E-01, 5.2359841600E-01],
	[9.82000E+03, 4.2448399975E+00, 6.2966756241E+00, 1.9136646706E-01, 1.7793689259E-01, 5.2374379808E-01],
	[9.82500E+03, 4.2477314176E+00, 6.2958267278E+00, 1.9167178748E-01, 1.7820524640E-01, 5.2388915883E-01],
	[9.83000E+03, 4.2506233346E+00, 6.2949783777E+00, 1.9197743932E-01, 1.7847384810E-01, 5.2403449832E-01],
	[9.83500E+03, 4.2535157484E+00, 6.2941305733E+00, 1.9228342276E-01, 1.7874269776E-01, 5.2417981659E-01],
	[9.84000E+03, 4.2564086587E+00, 6.2932833138E+00, 1.9258973801E-01, 1.7901179540E-01, 5.2432511372E-01],
	[9.84500E+03, 4.2593020656E+00, 6.2924365988E+00, 1.9289638525E-01, 1.7928114108E-01, 5.2447038974E-01],
	[9.85000E+03, 4.2621959686E+00, 6.2915904275E+00, 1.9320336467E-01, 1.7955073483E-01, 5.2461564474E-01],
	[9.85500E+03, 4.2650903678E+00, 6.2907447993E+00, 1.9351067647E-01, 1.7982057671E-01, 5.2476087875E-01],
	[9.86000E+03, 4.2679852629E+00, 6.2898997136E+00, 1.9381832083E-01, 1.8009066676E-01, 5.2490609184E-01],
	[9.86500E+03, 4.2708806538E+00, 6.2890551698E+00, 1.9412629794E-01, 1.8036100501E-01, 5.2505128407E-01],
	[9.87000E+03, 4.2737765402E+00, 6.2882111672E+00, 1.9443460801E-01, 1.8063159152E-01, 5.2519645549E-01],
	[9.87500E+03, 4.2766729221E+00, 6.2873677053E+00, 1.9474325121E-01, 1.8090242633E-01, 5.2534160616E-01],
	[9.88000E+03, 4.2795697993E+00, 6.2865247833E+00, 1.9505222774E-01, 1.8117350947E-01, 5.2548673614E-01],
	[9.88500E+03, 4.2824671716E+00, 6.2856824008E+00, 1.9536153779E-01, 1.8144484100E-01, 5.2563184549E-01],
	[9.89000E+03, 4.2853650388E+00, 6.2848405571E+00, 1.9567118154E-01, 1.8171642096E-01, 5.2577693426E-01],
	[9.89500E+03, 4.2882634007E+00, 6.2839992515E+00, 1.9598115921E-01, 1.8198824938E-01, 5.2592200251E-01],
	[9.90000E+03, 4.2911622573E+00, 6.2831584834E+00, 1.9629147096E-01, 1.8226032632E-01, 5.2606705031E-01],
	[9.90500E+03, 4.2940616083E+00, 6.2823182523E+00, 1.9660211700E-01, 1.8253265181E-01, 5.2621207770E-01],
	[9.91000E+03, 4.2969614536E+00, 6.2814785575E+00, 1.9691309751E-01, 1.8280522590E-01, 5.2635708474E-01],
	[9.91500E+03, 4.2998617930E+00, 6.2806393984E+00, 1.9722441269E-01, 1.8307804862E-01, 5.2650207150E-01],
	[9.92000E+03, 4.3027626263E+00, 6.2798007744E+00, 1.9753606273E-01, 1.8335112003E-01, 5.2664703803E-01],
	[9.92500E+03, 4.3056639534E+00, 6.2789626848E+00, 1.9784804781E-01, 1.8362444016E-01, 5.2679198438E-01],
	[9.93000E+03, 4.3085657741E+00, 6.2781251292E+00, 1.9816036814E-01, 1.8389800905E-01, 5.2693691062E-01],
	[9.93500E+03, 4.3114680883E+00, 6.2772881068E+00, 1.9847302389E-01, 1.8417182675E-01, 5.2708181680E-01],
	[9.94000E+03, 4.3143708957E+00, 6.2764516170E+00, 1.9878601527E-01, 1.8444589330E-01, 5.2722670299E-01],
	[9.94500E+03, 4.3172741963E+00, 6.2756156593E+00, 1.9909934246E-01, 1.8472020873E-01, 5.2737156923E-01],
	[9.95000E+03, 4.3201779898E+00, 6.2747802331E+00, 1.9941300566E-01, 1.8499477310E-01, 5.2751641558E-01],
	[9.95500E+03, 4.3230822761E+00, 6.2739453376E+00, 1.9972700505E-01, 1.8526958643E-01, 5.2766124211E-01],
	[9.96000E+03, 4.3259870550E+00, 6.2731109725E+00, 2.0004134082E-01, 1.8554464878E-01, 5.2780604887E-01],
	[9.96500E+03, 4.3288923264E+00, 6.2722771369E+00, 2.0035601318E-01, 1.8581996017E-01, 5.2795083592E-01],
	[9.97000E+03, 4.3317980901E+00, 6.2714438304E+00, 2.0067102230E-01, 1.8609552066E-01, 5.2809560331E-01],
	[9.97500E+03, 4.3347043459E+00, 6.2706110523E+00, 2.0098636839E-01, 1.8637133028E-01, 5.2824035111E-01],
	[9.98000E+03, 4.3376110938E+00, 6.2697788020E+00, 2.0130205162E-01, 1.8664738907E-01, 5.2838507937E-01],
	[9.98500E+03, 4.3405183334E+00, 6.2689470790E+00, 2.0161807220E-01, 1.8692369707E-01, 5.2852978815E-01],
	[9.99000E+03, 4.3434260646E+00, 6.2681158825E+00, 2.0193443031E-01, 1.8720025432E-01, 5.2867447750E-01],
	[9.99500E+03, 4.3463342873E+00, 6.2672852122E+00, 2.0225112615E-01, 1.8747706086E-01, 5.2881914749E-01],
	[1.00000E+04, 4.3492430014E+00, 6.2664550672E+00, 2.0256815991E-01, 1.8775411674E-01, 5.2896379817E-01],
	[1.00050E+04, 4.3521522066E+00, 6.2656254471E+00, 2.0288661520E-01, 1.8803235257E-01, 5.2910842960E-01],
	[1.00100E+04, 4.3550619028E+00, 6.2647963513E+00, 2.0320541164E-01, 1.8831083993E-01, 5.2925304183E-01],
	[1.00150E+04, 4.3579720899E+00, 6.2639677791E+00, 2.0352454944E-01, 1.8858957886E-01, 5.2939763493E-01],
	[1.00200E+04, 4.3608827676E+00, 6.2631397300E+00, 2.0384402879E-01, 1.8886856939E-01, 5.2954220895E-01],
	[1.00250E+04, 4.3637939358E+00, 6.2623122034E+00, 2.0416384987E-01, 1.8914781157E-01, 5.2968676394E-01],
	[1.00300E+04, 4.3667055943E+00, 6.2614851986E+00, 2.0448401289E-01, 1.8942730544E-01, 5.2983129990E-01],
	[1.00350E+04, 4.3696177431E+00, 6.2606587152E+00, 2.0480451804E-01, 1.8970705104E-01, 5.2997581688E-01],
	[1.00400E+04, 4.3725303819E+00, 6.2598327524E+00, 2.0512536552E-01, 1.8998704840E-01, 5.3012031491E-01],
	[1.00450E+04, 4.3754435105E+00, 6.2590073098E+00, 2.0544655552E-01, 1.9026729757E-01, 5.3026479403E-01],
	[1.00500E+04, 4.3783571288E+00, 6.2581823867E+00, 2.0576808823E-01, 1.9054779858E-01, 5.3040925427E-01],
	[1.00550E+04, 4.3812712367E+00, 6.2573579825E+00, 2.0608996385E-01, 1.9082855147E-01, 5.3055369567E-01],
	[1.00600E+04, 4.3841858339E+00, 6.2565340968E+00, 2.0641218258E-01, 1.9110955628E-01, 5.3069811827E-01],
	[1.00650E+04, 4.3871009204E+00, 6.2557107288E+00, 2.0673474461E-01, 1.9139081306E-01, 5.3084252209E-01],
	[1.00700E+04, 4.3900164959E+00, 6.2548878780E+00, 2.0705765013E-01, 1.9167232183E-01, 5.3098690719E-01],
	[1.00750E+04, 4.3929325603E+00, 6.2540655438E+00, 2.0738089934E-01, 1.9195408264E-01, 5.3113127359E-01],
	[1.00800E+04, 4.3958491134E+00, 6.2532437256E+00, 2.0770449243E-01, 1.9223609552E-01, 5.3127562133E-01],
	[1.00850E+04, 4.3987661551E+00, 6.2524224229E+00, 2.0802842961E-01, 1.9251836052E-01, 5.3141995044E-01],
	[1.00900E+04, 4.4016836852E+00, 6.2516016351E+00, 2.0835271106E-01, 1.9280087767E-01, 5.3156426097E-01],
	[1.00950E+04, 4.4046017036E+00, 6.2507813616E+00, 2.0867733698E-01, 1.9308364700E-01, 5.3170855294E-01],
	[1.01000E+04, 4.4075202100E+00, 6.2499616018E+00, 2.0900230757E-01, 1.9336666857E-01, 5.3185282640E-01],
	[1.01050E+04, 4.4104392044E+00, 6.2491423552E+00, 2.0932762301E-01, 1.9364994239E-01, 5.3199708138E-01],
	[1.01100E+04, 4.4133586866E+00, 6.2483236211E+00, 2.0965328351E-01, 1.9393346851E-01, 5.3214131792E-01],
	[1.01150E+04, 4.4162786563E+00, 6.2475053991E+00, 2.0997928926E-01, 1.9421724697E-01, 5.3228553605E-01],
	[1.01200E+04, 4.4191991135E+00, 6.2466876885E+00, 2.1030564045E-01, 1.9450127780E-01, 5.3242973581E-01],
	[1.01250E+04, 4.4221200580E+00, 6.2458704887E+00, 2.1063233729E-01, 1.9478556104E-01, 5.3257391723E-01],
	[1.01300E+04, 4.4250414897E+00, 6.2450537992E+00, 2.1095937996E-01, 1.9507009673E-01, 5.3271808036E-01],
	[1.01350E+04, 4.4279634083E+00, 6.2442376194E+00, 2.1128676866E-01, 1.9535488490E-01, 5.3286222523E-01],
	[1.01400E+04, 4.4308858137E+00, 6.2434219488E+00, 2.1161450358E-01, 1.9563992559E-01, 5.3300635187E-01],
	[1.01450E+04, 4.4338087058E+00, 6.2426067867E+00, 2.1194258493E-01, 1.9592521883E-01, 5.3315046032E-01],
	[1.01500E+04, 4.4367320844E+00, 6.2417921327E+00, 2.1227101289E-01, 1.9621076466E-01, 5.3329455061E-01],
	[1.01550E+04, 4.4396559493E+00, 6.2409779861E+00, 2.1259978767E-01, 1.9649656311E-01, 5.3343862279E-01],
	[1.01600E+04, 4.4425803004E+00, 6.2401643463E+00, 2.1292890945E-01, 1.9678261423E-01, 5.3358267689E-01],
	[1.01650E+04, 4.4455051375E+00, 6.2393512129E+00, 2.1325837843E-01, 1.9706891804E-01, 5.3372671295E-01],
	[1.01700E+04, 4.4484304605E+00, 6.2385385852E+00, 2.1358819480E-01, 1.9735547459E-01, 5.3387073100E-01],
	[1.01750E+04, 4.4513562692E+00, 6.2377264627E+00, 2.1391835877E-01, 1.9764228389E-01, 5.3401473107E-01],
	[1.01800E+04, 4.4542825634E+00, 6.2369148449E+00, 2.1424887053E-01, 1.9792934600E-01, 5.3415871321E-01],
	[1.01850E+04, 4.4572093430E+00, 6.2361037311E+00, 2.1457973027E-01, 1.9821666095E-01, 5.3430267746E-01],
	[1.01900E+04, 4.4601366079E+00, 6.2352931208E+00, 2.1491093818E-01, 1.9850422876E-01, 5.3444662384E-01],
	[1.01950E+04, 4.4630643578E+00, 6.2344830134E+00, 2.1524249447E-01, 1.9879204947E-01, 5.3459055239E-01],
	[1.02000E+04, 4.4659925926E+00, 6.2336734084E+00, 2.1557439933E-01, 1.9908012313E-01, 5.3473446316E-01],
	[1.02050E+04, 4.4689213122E+00, 6.2328643053E+00, 2.1590665295E-01, 1.9936844975E-01, 5.3487835617E-01],
	[1.02100E+04, 4.4718505164E+00, 6.2320557034E+00, 2.1623925553E-01, 1.9965702938E-01, 5.3502223147E-01],
	[1.02150E+04, 4.4747842838E+00, 6.2312711859E+00, 2.1657220727E-01, 1.9994589447E-01, 5.3516608909E-01],
	[1.02200E+04, 4.4777203233E+00, 6.2304974602E+00, 2.1690550835E-01, 2.0023502702E-01, 5.3530992906E-01],
	[1.02250E+04, 4.4806568517E+00, 6.2297242090E+00, 2.1723915898E-01, 2.0052441291E-01, 5.3545375143E-01],
	[1.02300E+04, 4.4835938689E+00, 6.2289514317E+00, 2.1757315935E-01, 2.0081405218E-01, 5.3559755622E-01],
	[1.02350E+04, 4.4865313747E+00, 6.2281791278E+00, 2.1790750965E-01, 2.0110394487E-01, 5.3574134349E-01],
	[1.02400E+04, 4.4894693690E+00, 6.2274072968E+00, 2.1824221009E-01, 2.0139409100E-01, 5.3588511325E-01],
	[1.02450E+04, 4.4924078516E+00, 6.2266359381E+00, 2.1857726085E-01, 2.0168449061E-01, 5.3602886556E-01],
	[1.02500E+04, 4.4953468224E+00, 6.2258650513E+00, 2.1891266214E-01, 2.0197514373E-01, 5.3617260044E-01],
	[1.02550E+04, 4.4982862811E+00, 6.2250946358E+00, 2.1924841414E-01, 2.0226605040E-01, 5.3631631793E-01],
	[1.02600E+04, 4.5012262277E+00, 6.2243246911E+00, 2.1958451705E-01, 2.0255721064E-01, 5.3646001807E-01],
	[1.02650E+04, 4.5041666620E+00, 6.2235552167E+00, 2.1992097108E-01, 2.0284862450E-01, 5.3660370090E-01],
	[1.02700E+04, 4.5071075838E+00, 6.2227862120E+00, 2.2025777640E-01, 2.0314029200E-01, 5.3674736645E-01],
	[1.02750E+04, 4.5100489930E+00, 6.2220176766E+00, 2.2059493323E-01, 2.0343221318E-01, 5.3689101476E-01],
	[1.02800E+04, 4.5129908894E+00, 6.2212496100E+00, 2.2093244175E-01, 2.0372438806E-01, 5.3703464587E-01],
	[1.02850E+04, 4.5159332728E+00, 6.2204820115E+00, 2.2127030216E-01, 2.0401681668E-01, 5.3717825981E-01],
	[1.02900E+04, 4.5188761432E+00, 6.2197148808E+00, 2.2160851466E-01, 2.0430949907E-01, 5.3732185662E-01],
	[1.02950E+04, 4.5218195003E+00, 6.2189482173E+00, 2.2194707944E-01, 2.0460243527E-01, 5.3746543633E-01],
	[1.03000E+04, 4.5247633440E+00, 6.2181820205E+00, 2.2228599670E-01, 2.0489562530E-01, 5.3760899898E-01],
	[1.03050E+04, 4.5277076741E+00, 6.2174162898E+00, 2.2262526663E-01, 2.0518906919E-01, 5.3775254462E-01],
	[1.03100E+04, 4.5306524905E+00, 6.2166510249E+00, 2.2296488942E-01, 2.0548276698E-01, 5.3789607327E-01],
	[1.03150E+04, 4.5335977930E+00, 6.2158862251E+00, 2.2330486528E-01, 2.0577671869E-01, 5.3803958497E-01],
	[1.03200E+04, 4.5365435815E+00, 6.2151218899E+00, 2.2364519441E-01, 2.0607092437E-01, 5.3818307977E-01],
	[1.03250E+04, 4.5394898558E+00, 6.2143580189E+00, 2.2398587698E-01, 2.0636538403E-01, 5.3832655769E-01],
	[1.03300E+04, 4.5424366158E+00, 6.2135946115E+00, 2.2432691321E-01, 2.0666009770E-01, 5.3847001877E-01],
	[1.03350E+04, 4.5453838612E+00, 6.2128316673E+00, 2.2466830328E-01, 2.0695506543E-01, 5.3861346305E-01],
	[1.03400E+04, 4.5483315920E+00, 6.2120691856E+00, 2.2501004740E-01, 2.0725028724E-01, 5.3875689057E-01],
	[1.03450E+04, 4.5512798080E+00, 6.2113071662E+00, 2.2535214575E-01, 2.0754576315E-01, 5.3890030137E-01],
	[1.03500E+04, 4.5542285091E+00, 6.2105456083E+00, 2.2569459854E-01, 2.0784149320E-01, 5.3904369547E-01],
	[1.03550E+04, 4.5571776950E+00, 6.2097845115E+00, 2.2603740596E-01, 2.0813747742E-01, 5.3918707293E-01],
	[1.03600E+04, 4.5601273657E+00, 6.2090238754E+00, 2.2638056820E-01, 2.0843371584E-01, 5.3933043376E-01],
	[1.03650E+04, 4.5630775209E+00, 6.2082636994E+00, 2.2672408546E-01, 2.0873020848E-01, 5.3947377802E-01],
	[1.03700E+04, 4.5660281605E+00, 6.2075039830E+00, 2.2706795794E-01, 2.0902695537E-01, 5.3961710574E-01],
	[1.03750E+04, 4.5689792844E+00, 6.2067447257E+00, 2.2741218583E-01, 2.0932395655E-01, 5.3976041695E-01],
	[1.03800E+04, 4.5719308924E+00, 6.2059859271E+00, 2.2775676933E-01, 2.0962121204E-01, 5.3990371169E-01],
	[1.03850E+04, 4.5748829844E+00, 6.2052275865E+00, 2.2810170864E-01, 2.0991872188E-01, 5.4004699000E-01],
	[1.03900E+04, 4.5778355602E+00, 6.2044697036E+00, 2.2844700394E-01, 2.1021648608E-01, 5.4019025192E-01],
	[1.03950E+04, 4.5807886196E+00, 6.2037122778E+00, 2.2879265544E-01, 2.1051450468E-01, 5.4033349748E-01],
	[1.04000E+04, 4.5837421626E+00, 6.2029553087E+00, 2.2913866333E-01, 2.1081277770E-01, 5.4047672673E-01],
	[1.04050E+04, 4.5866961888E+00, 6.2021987957E+00, 2.2948502781E-01, 2.1111130517E-01, 5.4061993968E-01],
	[1.04100E+04, 4.5896506983E+00, 6.2014427383E+00, 2.2983174907E-01, 2.1141008713E-01, 5.4076313640E-01],
	[1.04150E+04, 4.5926056908E+00, 6.2006871361E+00, 2.3017882731E-01, 2.1170912360E-01, 5.4090631690E-01],
	[1.04200E+04, 4.5955611662E+00, 6.1999319885E+00, 2.3052626272E-01, 2.1200841459E-01, 5.4104948124E-01],
	[1.04250E+04, 4.5985171243E+00, 6.1991772951E+00, 2.3087405551E-01, 2.1230796016E-01, 5.4119262943E-01],
	[1.04300E+04, 4.6014735650E+00, 6.1984230554E+00, 2.3122220586E-01, 2.1260776031E-01, 5.4133576154E-01],
	[1.04350E+04, 4.6044304881E+00, 6.1976692689E+00, 2.3157071398E-01, 2.1290781507E-01, 5.4147887758E-01],
	[1.04400E+04, 4.6073878935E+00, 6.1969159350E+00, 2.3191958005E-01, 2.1320812448E-01, 5.4162197759E-01],
	[1.04450E+04, 4.6103457810E+00, 6.1961630534E+00, 2.3226880428E-01, 2.1350868856E-01, 5.4176506162E-01],
	[1.04500E+04, 4.6133041505E+00, 6.1954106235E+00, 2.3261838686E-01, 2.1380950733E-01, 5.4190812971E-01],
	[1.04550E+04, 4.6162630018E+00, 6.1946586448E+00, 2.3296832799E-01, 2.1411058083E-01, 5.4205118188E-01],
	[1.04600E+04, 4.6192223348E+00, 6.1939071169E+00, 2.3331862786E-01, 2.1441190907E-01, 5.4219421817E-01],
	[1.04650E+04, 4.6221821493E+00, 6.1931560392E+00, 2.3366928667E-01, 2.1471349208E-01, 5.4233723863E-01],
	[1.04700E+04, 4.6251424451E+00, 6.1924054113E+00, 2.3402030461E-01, 2.1501532989E-01, 5.4248024329E-01],
	[1.04750E+04, 4.6281032222E+00, 6.1916552327E+00, 2.3437168188E-01, 2.1531742253E-01, 5.4262323219E-01],
	[1.04800E+04, 4.6310644803E+00, 6.1909055030E+00, 2.3472341868E-01, 2.1561977002E-01, 5.4276620536E-01],
	[1.04850E+04, 4.6340262193E+00, 6.1901562215E+00, 2.3507551520E-01, 2.1592237238E-01, 5.4290916284E-01],
	[1.04900E+04, 4.6369884391E+00, 6.1894073879E+00, 2.3542797165E-01, 2.1622522963E-01, 5.4305210467E-01],
	[1.04950E+04, 4.6399511395E+00, 6.1886590017E+00, 2.3578078820E-01, 2.1652834182E-01, 5.4319503089E-01],
	[1.05000E+04, 4.6429143203E+00, 6.1879110623E+00, 2.3613396507E-01, 2.1683170895E-01, 5.4333794153E-01],
	[1.05050E+04, 4.6458779814E+00, 6.1871635693E+00, 2.3648750245E-01, 2.1713533105E-01, 5.4348083664E-01],
	[1.05100E+04, 4.6488421227E+00, 6.1864165223E+00, 2.3684140053E-01, 2.1743920815E-01, 5.4362371624E-01],
	[1.05150E+04, 4.6518067440E+00, 6.1856699207E+00, 2.3719565950E-01, 2.1774334027E-01, 5.4376658035E-01],
	[1.05200E+04, 4.6547718451E+00, 6.1849237641E+00, 2.3755027958E-01, 2.1804772743E-01, 5.4390942899E-01],
	[1.05250E+04, 4.6577374260E+00, 6.1841780520E+00, 2.3790526094E-01, 2.1835236966E-01, 5.4405226218E-01],
	[1.05300E+04, 4.6607034863E+00, 6.1834327839E+00, 2.3826060380E-01, 2.1865726699E-01, 5.4419507992E-01],
	[1.05350E+04, 4.6636700261E+00, 6.1826879594E+00, 2.3861630834E-01, 2.1896241943E-01, 5.4433788225E-01],
	[1.05400E+04, 4.6666370452E+00, 6.1819435779E+00, 2.3897237475E-01, 2.1926782700E-01, 5.4448066919E-01],
	[1.05450E+04, 4.6696045433E+00, 6.1811996390E+00, 2.3932880325E-01, 2.1957348974E-01, 5.4462344074E-01],
	[1.05500E+04, 4.6725725204E+00, 6.1804561423E+00, 2.3968559402E-01, 2.1987940766E-01, 5.4476619695E-01],
	[1.05550E+04, 4.6755409762E+00, 6.1797130872E+00, 2.4004274726E-01, 2.2018558079E-01, 5.4490893781E-01],
	[1.05600E+04, 4.6785099108E+00, 6.1789704733E+00, 2.4040026316E-01, 2.2049200915E-01, 5.4505166336E-01],
	[1.05650E+04, 4.6814793238E+00, 6.1782283000E+00, 2.4075814193E-01, 2.2079869276E-01, 5.4519437361E-01],
	[1.05700E+04, 4.6844492152E+00, 6.1774865671E+00, 2.4111638375E-01, 2.2110563164E-01, 5.4533706859E-01],
	[1.05750E+04, 4.6874195848E+00, 6.1767452739E+00, 2.4147498883E-01, 2.2141282582E-01, 5.4547974831E-01],
	[1.05800E+04, 4.6903904324E+00, 6.1760044200E+00, 2.4183395736E-01, 2.2172027532E-01, 5.4562241280E-01],
	[1.05850E+04, 4.6933617579E+00, 6.1752640049E+00, 2.4219328953E-01, 2.2202798015E-01, 5.4576506207E-01],
	[1.05900E+04, 4.6963335612E+00, 6.1745240282E+00, 2.4255298555E-01, 2.2233594035E-01, 5.4590769615E-01],
	[1.05950E+04, 4.6993058421E+00, 6.1737844894E+00, 2.4291304561E-01, 2.2264415592E-01, 5.4605031506E-01],
	[1.06000E+04, 4.7022786005E+00, 6.1730453880E+00, 2.4327346990E-01, 2.2295262690E-01, 5.4619291881E-01],
	[1.06050E+04, 4.7052518362E+00, 6.1723067236E+00, 2.4363425863E-01, 2.2326135330E-01, 5.4633550742E-01],
	[1.06100E+04, 4.7082255490E+00, 6.1715684958E+00, 2.4399541199E-01, 2.2357033515E-01, 5.4647808093E-01],
	[1.06150E+04, 4.7111997388E+00, 6.1708307039E+00, 2.4435693017E-01, 2.2387957246E-01, 5.4662063934E-01],
	[1.06200E+04, 4.7141758711E+00, 6.1701005760E+00, 2.4471881337E-01, 2.2418907811E-01, 5.4676318268E-01],
	[1.06250E+04, 4.7171572794E+00, 6.1693945246E+00, 2.4508106180E-01, 2.2449888151E-01, 5.4690571096E-01],
	[1.06300E+04, 4.7201391693E+00, 6.1686888861E+00, 2.4544367563E-01, 2.2480894071E-01, 5.4704822422E-01],
	[1.06350E+04, 4.7231215405E+00, 6.1679836601E+00, 2.4580665508E-01, 2.2511925572E-01, 5.4719072246E-01],
	[1.06400E+04, 4.7261043929E+00, 6.1672788462E+00, 2.4617000034E-01, 2.2542982657E-01, 5.4733320572E-01],
	[1.06450E+04, 4.7290877264E+00, 6.1665744438E+00, 2.4653371160E-01, 2.2574065328E-01, 5.4747567400E-01],
	[1.06500E+04, 4.7320715409E+00, 6.1658704527E+00, 2.4689778906E-01, 2.2605173587E-01, 5.4761812734E-01],
	[1.06550E+04, 4.7350558361E+00, 6.1651668723E+00, 2.4726223292E-01, 2.2636307435E-01, 5.4776056575E-01],
	[1.06600E+04, 4.7380406120E+00, 6.1644637022E+00, 2.4762704337E-01, 2.2667466874E-01, 5.4790298925E-01],
	[1.06650E+04, 4.7410258684E+00, 6.1637609420E+00, 2.4799222061E-01, 2.2698651908E-01, 5.4804539786E-01],
	[1.06700E+04, 4.7440116051E+00, 6.1630585912E+00, 2.4835776484E-01, 2.2729862537E-01, 5.4818779160E-01],
	[1.06750E+04, 4.7469978220E+00, 6.1623566495E+00, 2.4872367625E-01, 2.2761098763E-01, 5.4833017050E-01],
	[1.06800E+04, 4.7499845190E+00, 6.1616551163E+00, 2.4908995504E-01, 2.2792360589E-01, 5.4847253458E-01],
	[1.06850E+04, 4.7529716958E+00, 6.1609539914E+00, 2.4945660141E-01, 2.2823648016E-01, 5.4861488385E-01],
	[1.06900E+04, 4.7559593524E+00, 6.1602532741E+00, 2.4982361555E-01, 2.2854961047E-01, 5.4875721833E-01],
	[1.06950E+04, 4.7589474886E+00, 6.1595529642E+00, 2.5019099766E-01, 2.2886299682E-01, 5.4889953806E-01],
	[1.07000E+04, 4.7619361043E+00, 6.1588530611E+00, 2.5055874794E-01, 2.2917663925E-01, 5.4904184304E-01],
	[1.07050E+04, 4.7649251993E+00, 6.1581535645E+00, 2.5092686658E-01, 2.2949053776E-01, 5.4918413330E-01],
	[1.07100E+04, 4.7679147734E+00, 6.1574544740E+00, 2.5129535378E-01, 2.2980469237E-01, 5.4932640886E-01],
	[1.07150E+04, 4.7709048266E+00, 6.1567557890E+00, 2.5166420974E-01, 2.3011910311E-01, 5.4946866974E-01],
	[1.07200E+04, 4.7738953586E+00, 6.1560575092E+00, 2.5203343465E-01, 2.3043376999E-01, 5.4961091596E-01],
	[1.07250E+04, 4.7768863694E+00, 6.1553596342E+00, 2.5240302871E-01, 2.3074869303E-01, 5.4975314754E-01],
	[1.07300E+04, 4.7798778587E+00, 6.1546621635E+00, 2.5277299212E-01, 2.3106387224E-01, 5.4989536451E-01],
	[1.07350E+04, 4.7828698265E+00, 6.1539650967E+00, 2.5314332507E-01, 2.3137930765E-01, 5.5003756688E-01],
	[1.07400E+04, 4.7858622725E+00, 6.1532684334E+00, 2.5351402776E-01, 2.3169499927E-01, 5.5017975467E-01],
	[1.07450E+04, 4.7888551967E+00, 6.1525721731E+00, 2.5388510039E-01, 2.3201094711E-01, 5.5032192792E-01],
	[1.07500E+04, 4.7918485989E+00, 6.1518763155E+00, 2.5425654315E-01, 2.3232715120E-01, 5.5046408662E-01],
	[1.07550E+04, 4.7948424789E+00, 6.1511808602E+00, 2.5462835624E-01, 2.3264361154E-01, 5.5060623082E-01],
	[1.07600E+04, 4.7978368366E+00, 6.1504858066E+00, 2.5500053986E-01, 2.3296032817E-01, 5.5074836053E-01],
	[1.07650E+04, 4.8008316719E+00, 6.1497911545E+00, 2.5537309420E-01, 2.3327730108E-01, 5.5089047576E-01],
	[1.07700E+04, 4.8038269845E+00, 6.1490969033E+00, 2.5574601947E-01, 2.3359453030E-01, 5.5103257655E-01],
	[1.07750E+04, 4.8068227745E+00, 6.1484030526E+00, 2.5611931585E-01, 2.3391201585E-01, 5.5117466291E-01],
	[1.07800E+04, 4.8098190415E+00, 6.1477096021E+00, 2.5649298354E-01, 2.3422975774E-01, 5.5131673487E-01],
	[1.07850E+04, 4.8128157855E+00, 6.1470165513E+00, 2.5686702275E-01, 2.3454775598E-01, 5.5145879244E-01],
	[1.07900E+04, 4.8158130064E+00, 6.1463238998E+00, 2.5724143367E-01, 2.3486601060E-01, 5.5160083564E-01],
	[1.07950E+04, 4.8188107039E+00, 6.1456316472E+00, 2.5761621649E-01, 2.3518452159E-01, 5.5174286451E-01],
	[1.08000E+04, 4.8218088780E+00, 6.1449397931E+00, 2.5799137141E-01, 2.3550328899E-01, 5.5188487905E-01],
	[1.08050E+04, 4.8248075284E+00, 6.1442483371E+00, 2.5836689863E-01, 2.3582231281E-01, 5.5202687929E-01],
	[1.08100E+04, 4.8278066551E+00, 6.1435572786E+00, 2.5874279835E-01, 2.3614159305E-01, 5.5216886525E-01],
	[1.08150E+04, 4.8308062579E+00, 6.1428666175E+00, 2.5911907076E-01, 2.3646112974E-01, 5.5231083696E-01],
	[1.08200E+04, 4.8338063367E+00, 6.1421763531E+00, 2.5949571606E-01, 2.3678092289E-01, 5.5245279443E-01],
	[1.08250E+04, 4.8368068912E+00, 6.1414864852E+00, 2.5987273444E-01, 2.3710097251E-01, 5.5259473768E-01],
	[1.08300E+04, 4.8398079215E+00, 6.1407970132E+00, 2.6025012611E-01, 2.3742127862E-01, 5.5273666674E-01],
	[1.08350E+04, 4.8428094272E+00, 6.1401079369E+00, 2.6062789127E-01, 2.3774184123E-01, 5.5287858163E-01],
	[1.08400E+04, 4.8458114084E+00, 6.1394192557E+00, 2.6100603009E-01, 2.3806266035E-01, 5.5302048237E-01],
	[1.08450E+04, 4.8488138647E+00, 6.1387309693E+00, 2.6138454280E-01, 2.3838373600E-01, 5.5316236898E-01],
	[1.08500E+04, 4.8518167962E+00, 6.1380430773E+00, 2.6176342957E-01, 2.3870506819E-01, 5.5330424148E-01],
	[1.08550E+04, 4.8548202026E+00, 6.1373555793E+00, 2.6214269062E-01, 2.3902665693E-01, 5.5344609989E-01],
	[1.08600E+04, 4.8578240838E+00, 6.1366684747E+00, 2.6252232613E-01, 2.3934850224E-01, 5.5358794424E-01],
	[1.08650E+04, 4.8608284397E+00, 6.1359817634E+00, 2.6290233630E-01, 2.3967060413E-01, 5.5372977455E-01],
	[1.08700E+04, 4.8638332701E+00, 6.1352954447E+00, 2.6328272133E-01, 2.3999296261E-01, 5.5387159084E-01],
	[1.08750E+04, 4.8668385749E+00, 6.1346095185E+00, 2.6366348142E-01, 2.4031557769E-01, 5.5401339313E-01],
	[1.08800E+04, 4.8698443539E+00, 6.1339239841E+00, 2.6404461677E-01, 2.4063844939E-01, 5.5415518143E-01],
	[1.08850E+04, 4.8728506069E+00, 6.1332388412E+00, 2.6442612756E-01, 2.4096157772E-01, 5.5429695578E-01],
	[1.08900E+04, 4.8758573340E+00, 6.1325540895E+00, 2.6480801401E-01, 2.4128496269E-01, 5.5443871620E-01],
	[1.08950E+04, 4.8788645348E+00, 6.1318697285E+00, 2.6519027629E-01, 2.4160860430E-01, 5.5458046270E-01],
	[1.09000E+04, 4.8818722093E+00, 6.1311857579E+00, 2.6557291463E-01, 2.4193250259E-01, 5.5472219532E-01],
	[1.09050E+04, 4.8848803573E+00, 6.1305021771E+00, 2.6595592920E-01, 2.4225665754E-01, 5.5486391406E-01],
	[1.09100E+04, 4.8878889787E+00, 6.1298189858E+00, 2.6633932021E-01, 2.4258106918E-01, 5.5500561895E-01],
	[1.09150E+04, 4.8908980733E+00, 6.1291361837E+00, 2.6672308785E-01, 2.4290573752E-01, 5.5514731002E-01],
	[1.09200E+04, 4.8939076409E+00, 6.1284537703E+00, 2.6710723233E-01, 2.4323066257E-01, 5.5528898728E-01],
	[1.09250E+04, 4.8969176816E+00, 6.1277717452E+00, 2.6749175383E-01, 2.4355584433E-01, 5.5543065076E-01],
	[1.09300E+04, 4.8999281950E+00, 6.1270901080E+00, 2.6787665256E-01, 2.4388128282E-01, 5.5557230048E-01],
	[1.09350E+04, 4.9029391811E+00, 6.1264088583E+00, 2.6826192871E-01, 2.4420697805E-01, 5.5571393645E-01],
	[1.09400E+04, 4.9059506397E+00, 6.1257279958E+00, 2.6864758249E-01, 2.4453293002E-01, 5.5585555872E-01],
	[1.09450E+04, 4.9089625707E+00, 6.1250475200E+00, 2.6903361408E-01, 2.4485913876E-01, 5.5599716728E-01],
	[1.09500E+04, 4.9119749740E+00, 6.1243674305E+00, 2.6942002369E-01, 2.4518560426E-01, 5.5613876217E-01],
	[1.09550E+04, 4.9149878493E+00, 6.1236877269E+00, 2.6980681151E-01, 2.4551232654E-01, 5.5628034341E-01],
	[1.09600E+04, 4.9180011966E+00, 6.1230084089E+00, 2.7019397773E-01, 2.4583930561E-01, 5.5642191103E-01],
	[1.09650E+04, 4.9210150157E+00, 6.1223294761E+00, 2.7058152257E-01, 2.4616654147E-01, 5.5656346503E-01],
	[1.09700E+04, 4.9240293064E+00, 6.1216509279E+00, 2.7096944621E-01, 2.4649403414E-01, 5.5670500545E-01],
	[1.09750E+04, 4.9270440687E+00, 6.1209727642E+00, 2.7135774885E-01, 2.4682178362E-01, 5.5684653230E-01],
	[1.09800E+04, 4.9300593024E+00, 6.1202949844E+00, 2.7174643069E-01, 2.4714978992E-01, 5.5698804561E-01],
	[1.09850E+04, 4.9330750073E+00, 6.1196175881E+00, 2.7213549193E-01, 2.4747805306E-01, 5.5712954537E-01],
	[1.09900E+04, 4.9360911833E+00, 6.1189405751E+00, 2.7252493276E-01, 2.4780657303E-01, 5.5727103158E-01],
	[1.09950E+04, 4.9391078303E+00, 6.1182639448E+00, 2.7291475338E-01, 2.4813534986E-01, 5.5741250426E-01],
	[1.10000E+04, 4.9421249481E+00, 6.1175876970E+00, 2.7330495399E-01, 2.4846438353E-01, 5.5755396341E-01],
	[1.10050E+04, 4.9451425366E+00, 6.1169118311E+00, 2.7369553479E-01, 2.4879367407E-01, 5.5769540904E-01],
	[1.10100E+04, 4.9481605957E+00, 6.1162363469E+00, 2.7408649597E-01, 2.4912322148E-01, 5.5783684117E-01],
	[1.10150E+04, 4.9511791251E+00, 6.1155612439E+00, 2.7447783773E-01, 2.4945302577E-01, 5.5797825979E-01],
	[1.10200E+04, 4.9541981248E+00, 6.1148865218E+00, 2.7486956027E-01, 2.4978308695E-01, 5.5811966491E-01],
	[1.10250E+04, 4.9572175947E+00, 6.1142121801E+00, 2.7526166379E-01, 2.5011340501E-01, 5.5826105656E-01],
	[1.10300E+04, 4.9602375345E+00, 6.1135382185E+00, 2.7565414848E-01, 2.5044397998E-01, 5.5840243472E-01],
	[1.10350E+04, 4.9632579441E+00, 6.1128646365E+00, 2.7604701454E-01, 2.5077481185E-01, 5.5854379942E-01],
	[1.10400E+04, 4.9662788235E+00, 6.1121914339E+00, 2.7644026217E-01, 2.5110590064E-01, 5.5868515065E-01],
	[1.10450E+04, 4.9693036765E+00, 6.1115333103E+00, 2.7683389157E-01, 2.5143728019E-01, 5.5882648844E-01],
	[1.10500E+04, 4.9723321977E+00, 6.1108889536E+00, 2.7722790292E-01, 2.5176894777E-01, 5.5896781278E-01],
	[1.10550E+04, 4.9753611933E+00, 6.1102449562E+00, 2.7762229644E-01, 2.5210087258E-01, 5.5910912369E-01],
	[1.10600E+04, 4.9783906631E+00, 6.1096013179E+00, 2.7801707232E-01, 2.5243305463E-01, 5.5925042117E-01],
	[1.10650E+04, 4.9814206071E+00, 6.1089580383E+00, 2.7841223076E-01, 2.5276549393E-01, 5.5939170524E-01],
	[1.10700E+04, 4.9844510251E+00, 6.1083151169E+00, 2.7880777194E-01, 2.5309819048E-01, 5.5953297590E-01],
	[1.10750E+04, 4.9874819169E+00, 6.1076725535E+00, 2.7920369608E-01, 2.5343114429E-01, 5.5967423315E-01],
	[1.10800E+04, 4.9905132824E+00, 6.1070303477E+00, 2.7960000337E-01, 2.5376435536E-01, 5.5981547702E-01],
	[1.10850E+04, 4.9935451214E+00, 6.1063884991E+00, 2.7999669401E-01, 2.5409782371E-01, 5.5995670751E-01],
	[1.10900E+04, 4.9965774339E+00, 6.1057470074E+00, 2.8039376819E-01, 2.5443154933E-01, 5.6009792462E-01],
	[1.10950E+04, 4.9996102197E+00, 6.1051058721E+00, 2.8079122611E-01, 2.5476553224E-01, 5.6023912836E-01],
	[1.11000E+04, 5.0026434786E+00, 6.1044650930E+00, 2.8118906797E-01, 2.5509977243E-01, 5.6038031875E-01],
	[1.11050E+04, 5.0056772106E+00, 6.1038246697E+00, 2.8158729397E-01, 2.5543426991E-01, 5.6052149580E-01],
	[1.11100E+04, 5.0087114154E+00, 6.1031846018E+00, 2.8198590431E-01, 2.5576902470E-01, 5.6066265950E-01],
	[1.11150E+04, 5.0117460929E+00, 6.1025448890E+00, 2.8238489917E-01, 2.5610403678E-01, 5.6080380988E-01],
	[1.11200E+04, 5.0147812430E+00, 6.1019055309E+00, 2.8278427877E-01, 2.5643930617E-01, 5.6094494693E-01],
	[1.11250E+04, 5.0178168656E+00, 6.1012665271E+00, 2.8318404330E-01, 2.5677483287E-01, 5.6108607068E-01],
	[1.11300E+04, 5.0208529605E+00, 6.1006278774E+00, 2.8358419295E-01, 2.5711061689E-01, 5.6122718112E-01],
	[1.11350E+04, 5.0238895276E+00, 6.0999895813E+00, 2.8398472792E-01, 2.5744665822E-01, 5.6136827827E-01],
	[1.11400E+04, 5.0269265666E+00, 6.0993516385E+00, 2.8438564842E-01, 2.5778295688E-01, 5.6150936213E-01],
	[1.11450E+04, 5.0299640776E+00, 6.0987140486E+00, 2.8478695464E-01, 2.5811951287E-01, 5.6165043272E-01],
	[1.11500E+04, 5.0330020604E+00, 6.0980768113E+00, 2.8518864677E-01, 2.5845632619E-01, 5.6179149004E-01],
	[1.11550E+04, 5.0360405147E+00, 6.0974399262E+00, 2.8559072502E-01, 2.5879339684E-01, 5.6193253410E-01],
	[1.11600E+04, 5.0390794406E+00, 6.0968033930E+00, 2.8599318958E-01, 2.5913072483E-01, 5.6207356492E-01],
	[1.11650E+04, 5.0421188378E+00, 6.0961672114E+00, 2.8639604065E-01, 2.5946831015E-01, 5.6221458250E-01],
	[1.11700E+04, 5.0451587062E+00, 6.0955313809E+00, 2.8679927843E-01, 2.5980615282E-01, 5.6235558685E-01],
	[1.11750E+04, 5.0481990456E+00, 6.0948959012E+00, 2.8720290312E-01, 2.6014425284E-01, 5.6249657797E-01],
	[1.11800E+04, 5.0512398560E+00, 6.0942607720E+00, 2.8760691491E-01, 2.6048261020E-01, 5.6263755589E-01],
	[1.11850E+04, 5.0542811372E+00, 6.0936259930E+00, 2.8801412911E-01, 2.6082353359E-01, 5.6277852060E-01],
	[1.11900E+04, 5.0573228890E+00, 6.0929915637E+00, 2.8842191741E-01, 2.6116486633E-01, 5.6291947212E-01],
	[1.11950E+04, 5.0603651114E+00, 6.0923574838E+00, 2.8883010051E-01, 2.6150646121E-01, 5.6306041046E-01],
	[1.12000E+04, 5.0634078041E+00, 6.0917237530E+00, 2.8923867864E-01, 2.6184831823E-01, 5.6320133563E-01],
	[1.12050E+04, 5.0664509671E+00, 6.0910903710E+00, 2.8964765199E-01, 2.6219043740E-01, 5.6334224762E-01],
	[1.12100E+04, 5.0694946001E+00, 6.0904573373E+00, 2.9005702077E-01, 2.6253281871E-01, 5.6348314647E-01],
	[1.12150E+04, 5.0725387032E+00, 6.0898246517E+00, 2.9046678519E-01, 2.6287546218E-01, 5.6362403217E-01],
	[1.12200E+04, 5.0755832761E+00, 6.0891923137E+00, 2.9087694545E-01, 2.6321836780E-01, 5.6376490473E-01],
	[1.12250E+04, 5.0786283186E+00, 6.0885603231E+00, 2.9128750177E-01, 2.6356153558E-01, 5.6390576416E-01],
	[1.12300E+04, 5.0816738307E+00, 6.0879286795E+00, 2.9169845433E-01, 2.6390496551E-01, 5.6404661048E-01],
	[1.12350E+04, 5.0847198123E+00, 6.0872973826E+00, 2.9210980336E-01, 2.6424865761E-01, 5.6418744369E-01],
	[1.12400E+04, 5.0877662631E+00, 6.0866664319E+00, 2.9252154905E-01, 2.6459261188E-01, 5.6432826380E-01],
	[1.12450E+04, 5.0908131831E+00, 6.0860358272E+00, 2.9293369161E-01, 2.6493682831E-01, 5.6446907082E-01],
	[1.12500E+04, 5.0938605721E+00, 6.0854055682E+00, 2.9334623126E-01, 2.6528130691E-01, 5.6460986476E-01],
	[1.12550E+04, 5.0969084299E+00, 6.0847756544E+00, 2.9375916818E-01, 2.6562604768E-01, 5.6475064563E-01],
	[1.12600E+04, 5.0999567565E+00, 6.0841460855E+00, 2.9417250259E-01, 2.6597105062E-01, 5.6489141344E-01],
	[1.12650E+04, 5.1030055517E+00, 6.0835168613E+00, 2.9458623470E-01, 2.6631631573E-01, 5.6503216820E-01],
	[1.12700E+04, 5.1060548154E+00, 6.0828879813E+00, 2.9500036471E-01, 2.6666184302E-01, 5.6517290992E-01],
	[1.12750E+04, 5.1091045473E+00, 6.0822594452E+00, 2.9541489283E-01, 2.6700763248E-01, 5.6531363861E-01],
	[1.12800E+04, 5.1121547475E+00, 6.0816312527E+00, 2.9582981926E-01, 2.6735368411E-01, 5.6545435428E-01],
	[1.12850E+04, 5.1152054158E+00, 6.0810034034E+00, 2.9624514421E-01, 2.6769999792E-01, 5.6559505694E-01],
	[1.12900E+04, 5.1182565519E+00, 6.0803758970E+00, 2.9666086788E-01, 2.6804657391E-01, 5.6573574659E-01],
	[1.12950E+04, 5.1213081559E+00, 6.0797487331E+00, 2.9707699048E-01, 2.6839341208E-01, 5.6587642326E-01],
	[1.13000E+04, 5.1243602275E+00, 6.0791219115E+00, 2.9749351222E-01, 2.6874051242E-01, 5.6601708694E-01],
	[1.13050E+04, 5.1274127666E+00, 6.0784954317E+00, 2.9791043331E-01, 2.6908787493E-01, 5.6615773765E-01],
	[1.13100E+04, 5.1304657731E+00, 6.0778692935E+00, 2.9832775394E-01, 2.6943549963E-01, 5.6629837539E-01],
	[1.13150E+04, 5.1335192468E+00, 6.0772434965E+00, 2.9874547432E-01, 2.6978338649E-01, 5.6643900019E-01],
	[1.13200E+04, 5.1365731877E+00, 6.0766180403E+00, 2.9916359467E-01, 2.7013153554E-01, 5.6657961204E-01],
	[1.13250E+04, 5.1396275955E+00, 6.0759929247E+00, 2.9958211518E-01, 2.7047994675E-01, 5.6672021096E-01],
	[1.13300E+04, 5.1426824702E+00, 6.0753681493E+00, 3.0000103606E-01, 2.7082862014E-01, 5.6686079696E-01],
	[1.13350E+04, 5.1457378116E+00, 6.0747437137E+00, 3.0042035753E-01, 2.7117755570E-01, 5.6700137004E-01],
	[1.13400E+04, 5.1487936195E+00, 6.0741196176E+00, 3.0084007978E-01, 2.7152675343E-01, 5.6714193022E-01],
	[1.13450E+04, 5.1518498939E+00, 6.0734958608E+00, 3.0126020302E-01, 2.7187621333E-01, 5.6728247751E-01],
	[1.13500E+04, 5.1549066346E+00, 6.0728724428E+00, 3.0168072745E-01, 2.7222593539E-01, 5.6742301192E-01],
	[1.13550E+04, 5.1579638415E+00, 6.0722493633E+00, 3.0210165329E-01, 2.7257591962E-01, 5.6756353345E-01],
	[1.13600E+04, 5.1610215144E+00, 6.0716266220E+00, 3.0252298074E-01, 2.7292616601E-01, 5.6770404213E-01],
	[1.13650E+04, 5.1640796532E+00, 6.0710042186E+00, 3.0294471001E-01, 2.7327667455E-01, 5.6784453795E-01],
	[1.13700E+04, 5.1671382577E+00, 6.0703821526E+00, 3.0336684129E-01, 2.7362744526E-01, 5.6798502093E-01],
	[1.13750E+04, 5.1701973279E+00, 6.0697604239E+00, 3.0378937480E-01, 2.7397847812E-01, 5.6812549108E-01],
	[1.13800E+04, 5.1732568636E+00, 6.0691390321E+00, 3.0421231075E-01, 2.7432977313E-01, 5.6826594841E-01],
	[1.13850E+04, 5.1763168647E+00, 6.0685179767E+00, 3.0463564934E-01, 2.7468133029E-01, 5.6840639292E-01],
	[1.13900E+04, 5.1793773310E+00, 6.0678972576E+00, 3.0505939077E-01, 2.7503314960E-01, 5.6854682464E-01],
	[1.13950E+04, 5.1824382623E+00, 6.0672768744E+00, 3.0548353526E-01, 2.7538523104E-01, 5.6868724356E-01],
	[1.14000E+04, 5.1854996587E+00, 6.0666568266E+00, 3.0590808301E-01, 2.7573757463E-01, 5.6882764971E-01],
	[1.14050E+04, 5.1885615199E+00, 6.0660371142E+00, 3.0633303422E-01, 2.7609018034E-01, 5.6896804308E-01],
	[1.14100E+04, 5.1916238458E+00, 6.0654177366E+00, 3.0675838910E-01, 2.7644304819E-01, 5.6910842370E-01],
	[1.14150E+04, 5.1946866362E+00, 6.0647986935E+00, 3.0718414786E-01, 2.7679617817E-01, 5.6924879157E-01],
	[1.14200E+04, 5.1977498911E+00, 6.0641799847E+00, 3.0761031071E-01, 2.7714957026E-01, 5.6938914670E-01],
	[1.14250E+04, 5.2008136102E+00, 6.0635616098E+00, 3.0803687784E-01, 2.7750322447E-01, 5.6952948910E-01],
	[1.14300E+04, 5.2038777936E+00, 6.0629435685E+00, 3.0846384947E-01, 2.7785714079E-01, 5.6966981877E-01],
	[1.14350E+04, 5.2069424410E+00, 6.0623258604E+00, 3.0889122581E-01, 2.7821131923E-01, 5.6981013571E-01],
	[1.14400E+04, 5.2100075522E+00, 6.0617084853E+00, 3.0931900706E-01, 2.7856575976E-01, 5.6995043991E-01],
	[1.14450E+04, 5.2130731273E+00, 6.0610914427E+00, 3.0974719342E-01, 2.7892046239E-01, 5.7009073138E-01],
	[1.14500E+04, 5.2161391659E+00, 6.0604747325E+00, 3.1017578510E-01, 2.7927542711E-01, 5.7023101011E-01],
	[1.14550E+04, 5.2192056681E+00, 6.0598583541E+00, 3.1060478231E-01, 2.7963065391E-01, 5.7037127610E-01],
	[1.14600E+04, 5.2222726337E+00, 6.0592423075E+00, 3.1103418526E-01, 2.7998614280E-01, 5.7051152936E-01],
	[1.14650E+04, 5.2253400624E+00, 6.0586265921E+00, 3.1146399415E-01, 2.8034189375E-01, 5.7065176987E-01],
	[1.14700E+04, 5.2284079543E+00, 6.0580112077E+00, 3.1189420919E-01, 2.8069790678E-01, 5.7079199765E-01],
	[1.14750E+04, 5.2314763092E+00, 6.0573961540E+00, 3.1232483058E-01, 2.8105418187E-01, 5.7093221269E-01],
	[1.14800E+04, 5.2345451269E+00, 6.0567814307E+00, 3.1275585854E-01, 2.8141071901E-01, 5.7107241499E-01],
	[1.14850E+04, 5.2376175035E+00, 6.0561780980E+00, 3.1318729326E-01, 2.8176755110E-01, 5.7121260455E-01],
	[1.14900E+04, 5.2406943968E+00, 6.0555895531E+00, 3.1361913495E-01, 2.8212468851E-01, 5.7135278138E-01],
	[1.14950E+04, 5.2437717579E+00, 6.0550013215E+00, 3.1405138383E-01, 2.8248208831E-01, 5.7149294546E-01],
	[1.15000E+04, 5.2468495866E+00, 6.0544134028E+00, 3.1448404010E-01, 2.8283975046E-01, 5.7163309681E-01],
	[1.15050E+04, 5.2499278827E+00, 6.0538257967E+00, 3.1491710395E-01, 2.8319767498E-01, 5.7177323541E-01],
	[1.15100E+04, 5.2530066461E+00, 6.0532385030E+00, 3.1535057561E-01, 2.8355586185E-01, 5.7191336128E-01],
	[1.15150E+04, 5.2560858767E+00, 6.0526515212E+00, 3.1578445528E-01, 2.8391431107E-01, 5.7205347440E-01],
	[1.15200E+04, 5.2591655744E+00, 6.0520648511E+00, 3.1621874316E-01, 2.8427302262E-01, 5.7219357479E-01],
	[1.15250E+04, 5.2622457391E+00, 6.0514784924E+00, 3.1665343946E-01, 2.8463199651E-01, 5.7233366244E-01],
	[1.15300E+04, 5.2653263705E+00, 6.0508924448E+00, 3.1708854439E-01, 2.8499123272E-01, 5.7247373734E-01],
	[1.15350E+04, 5.2684074685E+00, 6.0503067081E+00, 3.1752405815E-01, 2.8535073124E-01, 5.7261379951E-01],
	[1.15400E+04, 5.2714890332E+00, 6.0497212818E+00, 3.1795998095E-01, 2.8571049208E-01, 5.7275384894E-01],
	[1.15450E+04, 5.2745710642E+00, 6.0491361658E+00, 3.1839631300E-01, 2.8607051521E-01, 5.7289388563E-01],
	[1.15500E+04, 5.2776535615E+00, 6.0485513596E+00, 3.1883305451E-01, 2.8643080064E-01, 5.7303390957E-01],
	[1.15550E+04, 5.2807365249E+00, 6.0479668631E+00, 3.1927020567E-01, 2.8679134835E-01, 5.7317392078E-01],
	[1.15600E+04, 5.2838199543E+00, 6.0473826758E+00, 3.1970776670E-01, 2.8715215833E-01, 5.7331391926E-01],
	[1.15650E+04, 5.2869038496E+00, 6.0467987976E+00, 3.2014573781E-01, 2.8751323058E-01, 5.7345390499E-01],
	[1.15700E+04, 5.2899882107E+00, 6.0462152281E+00, 3.2058411920E-01, 2.8787456509E-01, 5.7359387798E-01],
	[1.15750E+04, 5.2930730373E+00, 6.0456319670E+00, 3.2102291107E-01, 2.8823616184E-01, 5.7373383824E-01],
	[1.15800E+04, 5.2961583295E+00, 6.0450490141E+00, 3.2146211364E-01, 2.8859802083E-01, 5.7387378576E-01],
	[1.15850E+04, 5.2992440870E+00, 6.0444663689E+00, 3.2190172711E-01, 2.8896014206E-01, 5.7401372054E-01],
	[1.15900E+04, 5.3023303097E+00, 6.0438840313E+00, 3.2234175169E-01, 2.8932252550E-01, 5.7415364258E-01],
	[1.15950E+04, 5.3054169975E+00, 6.0433020010E+00, 3.2278218758E-01, 2.8968517115E-01, 5.7429355189E-01],
	[1.16000E+04, 5.3085041503E+00, 6.0427202775E+00, 3.2322303500E-01, 2.9004807899E-01, 5.7443344846E-01],
	[1.16050E+04, 5.3115917679E+00, 6.0421388608E+00, 3.2366429414E-01, 2.9041124903E-01, 5.7457333230E-01],
	[1.16100E+04, 5.3146798502E+00, 6.0415577503E+00, 3.2410596522E-01, 2.9077468125E-01, 5.7471320340E-01],
	[1.16150E+04, 5.3177683971E+00, 6.0409769460E+00, 3.2454804844E-01, 2.9113837563E-01, 5.7485306176E-01],
	[1.16200E+04, 5.3208574084E+00, 6.0403964474E+00, 3.2499054401E-01, 2.9150233217E-01, 5.7499290739E-01],
	[1.16250E+04, 5.3239468840E+00, 6.0398162543E+00, 3.2543345214E-01, 2.9186655086E-01, 5.7513274029E-01],
	[1.16300E+04, 5.3270368238E+00, 6.0392363664E+00, 3.2587677303E-01, 2.9223103168E-01, 5.7527256045E-01],
	[1.16350E+04, 5.3301272276E+00, 6.0386567833E+00, 3.2632050689E-01, 2.9259577462E-01, 5.7541236788E-01],
	[1.16400E+04, 5.3332180954E+00, 6.0380775049E+00, 3.2676465393E-01, 2.9296077967E-01, 5.7555216258E-01],
	[1.16450E+04, 5.3363094270E+00, 6.0374985308E+00, 3.2720921436E-01, 2.9332604683E-01, 5.7569194455E-01],
	[1.16500E+04, 5.3394012222E+00, 6.0369198607E+00, 3.2765418837E-01, 2.9369157607E-01, 5.7583171379E-01],
	[1.16550E+04, 5.3424934809E+00, 6.0363414943E+00, 3.2809957618E-01, 2.9405736739E-01, 5.7597147030E-01],
	[1.16600E+04, 5.3455862031E+00, 6.0357634314E+00, 3.2854537800E-01, 2.9442342077E-01, 5.7611121407E-01],
	[1.16650E+04, 5.3486793885E+00, 6.0351856716E+00, 3.2899159403E-01, 2.9478973620E-01, 5.7625094512E-01],
	[1.16700E+04, 5.3517730371E+00, 6.0346082147E+00, 3.2943822448E-01, 2.9515631367E-01, 5.7639066345E-01],
	[1.16750E+04, 5.3548671487E+00, 6.0340310604E+00, 3.2988526956E-01, 2.9552315317E-01, 5.7653036904E-01],
	[1.16800E+04, 5.3579617231E+00, 6.0334542083E+00, 3.3033272947E-01, 2.9589025468E-01, 5.7667006191E-01],
	[1.16850E+04, 5.3610567603E+00, 6.0328776583E+00, 3.3078060442E-01, 2.9625761818E-01, 5.7680974206E-01],
	[1.16900E+04, 5.3641522602E+00, 6.0323014099E+00, 3.3122889462E-01, 2.9662524368E-01, 5.7694940948E-01],
	[1.16950E+04, 5.3672482225E+00, 6.0317254630E+00, 3.3167760028E-01, 2.9699313114E-01, 5.7708906418E-01],
	[1.17000E+04, 5.3703446473E+00, 6.0311498172E+00, 3.3212672159E-01, 2.9736128057E-01, 5.7722870615E-01],
	[1.17050E+04, 5.3734415342E+00, 6.0305744723E+00, 3.3257625878E-01, 2.9772969194E-01, 5.7736833541E-01],
	[1.17100E+04, 5.3765388833E+00, 6.0299994279E+00, 3.3302621204E-01, 2.9809836524E-01, 5.7750795194E-01],
	[1.17150E+04, 5.3796366943E+00, 6.0294246839E+00, 3.3347658159E-01, 2.9846730045E-01, 5.7764755576E-01],
	[1.17200E+04, 5.3827349672E+00, 6.0288502398E+00, 3.3392736763E-01, 2.9883649757E-01, 5.7778714685E-01],
	[1.17250E+04, 5.3858337019E+00, 6.0282760954E+00, 3.3437857036E-01, 2.9920595657E-01, 5.7792672523E-01],
	[1.17300E+04, 5.3889328981E+00, 6.0277022505E+00, 3.3483019000E-01, 2.9957567745E-01, 5.7806629090E-01],
	[1.17350E+04, 5.3920325558E+00, 6.0271287047E+00, 3.3528222676E-01, 2.9994566018E-01, 5.7820584385E-01],
	[1.17400E+04, 5.3951326749E+00, 6.0265554577E+00, 3.3573468083E-01, 3.0031590476E-01, 5.7834538408E-01],
	[1.17450E+04, 5.3982332551E+00, 6.0259825094E+00, 3.3618755243E-01, 3.0068641116E-01, 5.7848491160E-01],
	[1.17500E+04, 5.4013342965E+00, 6.0254098593E+00, 3.3664084177E-01, 3.0105717937E-01, 5.7862442641E-01],
	[1.17550E+04, 5.4044357988E+00, 6.0248375073E+00, 3.3709454904E-01, 3.0142820938E-01, 5.7876392852E-01],
	[1.17600E+04, 5.4075377620E+00, 6.0242654529E+00, 3.3754867447E-01, 3.0179950117E-01, 5.7890341791E-01],
	[1.17650E+04, 5.4106401858E+00, 6.0236936961E+00, 3.3800321825E-01, 3.0217105472E-01, 5.7904289460E-01],
	[1.17700E+04, 5.4137430702E+00, 6.0231222364E+00, 3.3845818060E-01, 3.0254287001E-01, 5.7918235857E-01],
	[1.17750E+04, 5.4168464151E+00, 6.0225510736E+00, 3.3891356172E-01, 3.0291494704E-01, 5.7932180985E-01],
	[1.17800E+04, 5.4199502203E+00, 6.0219802074E+00, 3.3936936182E-01, 3.0328728578E-01, 5.7946124842E-01],
	[1.17850E+04, 5.4230544857E+00, 6.0214096375E+00, 3.3982558110E-01, 3.0365988622E-01, 5.7960067429E-01],
	[1.17900E+04, 5.4261592112E+00, 6.0208393637E+00, 3.4028221978E-01, 3.0403274833E-01, 5.7974008746E-01],
	[1.17950E+04, 5.4292643966E+00, 6.0202693856E+00, 3.4073927806E-01, 3.0440587211E-01, 5.7987948793E-01],
	[1.18000E+04, 5.4323700418E+00, 6.0196997030E+00, 3.4119675614E-01, 3.0477925753E-01, 5.8001887570E-01],
	[1.18050E+04, 5.4354761467E+00, 6.0191303157E+00, 3.4165465425E-01, 3.0515290458E-01, 5.8015825077E-01],
	[1.18100E+04, 5.4385827112E+00, 6.0185612233E+00, 3.4211297257E-01, 3.0552681324E-01, 5.8029761316E-01],
	[1.18150E+04, 5.4416897351E+00, 6.0179924255E+00, 3.4257171133E-01, 3.0590098349E-01, 5.8043696284E-01],
	[1.18200E+04, 5.4447972183E+00, 6.0174239222E+00, 3.4303087072E-01, 3.0627541532E-01, 5.8057629984E-01],
	[1.18250E+04, 5.4479051607E+00, 6.0168557129E+00, 3.4349045096E-01, 3.0665010870E-01, 5.8071562415E-01],
	[1.18300E+04, 5.4510135622E+00, 6.0162877974E+00, 3.4395045226E-01, 3.0702506361E-01, 5.8085493576E-01],
	[1.18350E+04, 5.4541224226E+00, 6.0157201755E+00, 3.4441087481E-01, 3.0740028005E-01, 5.8099423470E-01],
	[1.18400E+04, 5.4572317417E+00, 6.0151528469E+00, 3.4487171884E-01, 3.0777575798E-01, 5.8113352094E-01],
	[1.18450E+04, 5.4603415196E+00, 6.0145858113E+00, 3.4533298454E-01, 3.0815149739E-01, 5.8127279450E-01],
	[1.18500E+04, 5.4634517560E+00, 6.0140190684E+00, 3.4579467212E-01, 3.0852749827E-01, 5.8141205539E-01],
	[1.18550E+04, 5.4665624509E+00, 6.0134526180E+00, 3.4625678180E-01, 3.0890376058E-01, 5.8155130359E-01],
	[1.18600E+04, 5.4696736040E+00, 6.0128864597E+00, 3.4671931377E-01, 3.0928028432E-01, 5.8169053914E-01],
	[1.18650E+04, 5.4727852153E+00, 6.0123205933E+00, 3.4718226825E-01, 3.0965706945E-01, 5.8182976214E-01],
	[1.18700E+04, 5.4758972847E+00, 6.0117550186E+00, 3.4764564545E-01, 3.1003411597E-01, 5.8196897257E-01],
	[1.18750E+04, 5.4790098120E+00, 6.0111897352E+00, 3.4810944556E-01, 3.1041142385E-01, 5.8210817042E-01],
	[1.18800E+04, 5.4821227970E+00, 6.0106247429E+00, 3.4857366881E-01, 3.1078899308E-01, 5.8224735569E-01],
	[1.18850E+04, 5.4852362398E+00, 6.0100600415E+00, 3.4903831539E-01, 3.1116682362E-01, 5.8238652836E-01],
	[1.18900E+04, 5.4883501401E+00, 6.0094956305E+00, 3.4950338552E-01, 3.1154491546E-01, 5.8252568843E-01],
	[1.18950E+04, 5.4914644978E+00, 6.0089315099E+00, 3.4996887940E-01, 3.1192326858E-01, 5.8266483588E-01],
	[1.19000E+04, 5.4945793128E+00, 6.0083676792E+00, 3.5043479725E-01, 3.1230188296E-01, 5.8280397071E-01],
	[1.19050E+04, 5.4976945850E+00, 6.0078041382E+00, 3.5090113926E-01, 3.1268075858E-01, 5.8294309290E-01],
	[1.19100E+04, 5.5008103142E+00, 6.0072408867E+00, 3.5136790564E-01, 3.1305989541E-01, 5.8308220244E-01],
	[1.19150E+04, 5.5039265004E+00, 6.0066779244E+00, 3.5183509661E-01, 3.1343929344E-01, 5.8322129932E-01],
	[1.19200E+04, 5.5070431433E+00, 6.0061152510E+00, 3.5230271237E-01, 3.1381895264E-01, 5.8336038354E-01],
	[1.19250E+04, 5.5101602430E+00, 6.0055528663E+00, 3.5277075313E-01, 3.1419887298E-01, 5.8349945508E-01],
	[1.19300E+04, 5.5132777991E+00, 6.0049907699E+00, 3.5323921910E-01, 3.1457905446E-01, 5.8363851393E-01],
	[1.19350E+04, 5.5163958117E+00, 6.0044289617E+00, 3.5370811049E-01, 3.1495949704E-01, 5.8377756008E-01],
	[1.19400E+04, 5.5195142806E+00, 6.0038674412E+00, 3.5417742749E-01, 3.1534020070E-01, 5.8391659352E-01],
	[1.19450E+04, 5.5226395178E+00, 6.0033254110E+00, 3.5464717033E-01, 3.1572123917E-01, 5.8405561425E-01],
	[1.19500E+04, 5.5257665113E+00, 6.0027875959E+00, 3.5511733920E-01, 3.1610255414E-01, 5.8419462225E-01],
	[1.19550E+04, 5.5288939661E+00, 6.0022500539E+00, 3.5558793433E-01, 3.1648413051E-01, 5.8433361751E-01],
	[1.19600E+04, 5.5320218821E+00, 6.0017127849E+00, 3.5605895590E-01, 3.1686596825E-01, 5.8447260002E-01],
	[1.19650E+04, 5.5351502593E+00, 6.0011757884E+00, 3.5653040414E-01, 3.1724806733E-01, 5.8461156978E-01],
	[1.19700E+04, 5.5382790974E+00, 6.0006390643E+00, 3.5700227925E-01, 3.1763042773E-01, 5.8475052676E-01],
	[1.19750E+04, 5.5414083963E+00, 6.0001026123E+00, 3.5747458144E-01, 3.1801304944E-01, 5.8488947097E-01],
	[1.19800E+04, 5.5445381560E+00, 5.9995664322E+00, 3.5794731091E-01, 3.1839593242E-01, 5.8502840239E-01],
	[1.19850E+04, 5.5476683763E+00, 5.9990305238E+00, 3.5842046788E-01, 3.1877907665E-01, 5.8516732101E-01],
	[1.19900E+04, 5.5507990570E+00, 5.9984948866E+00, 3.5889405255E-01, 3.1916248212E-01, 5.8530622683E-01],
	[1.19950E+04, 5.5539301981E+00, 5.9979595207E+00, 3.5936806513E-01, 3.1954614879E-01, 5.8544511983E-01],
	[1.20000E+04, 5.5570617994E+00, 5.9974244255E+00, 3.5984250583E-01, 3.1993007665E-01, 5.8558400000E-01],
	[1.20050E+04, 5.5601938608E+00, 5.9968896010E+00, 3.6031737486E-01, 3.2031426566E-01, 5.8572286734E-01],
	[1.20100E+04, 5.5633263822E+00, 5.9963550469E+00, 3.6079267242E-01, 3.2069871581E-01, 5.8586172183E-01],
	[1.20150E+04, 5.5664593634E+00, 5.9958207629E+00, 3.6126839872E-01, 3.2108342707E-01, 5.8600056346E-01],
	[1.20200E+04, 5.5695928043E+00, 5.9952867487E+00, 3.6174455397E-01, 3.2146839941E-01, 5.8613939223E-01],
	[1.20250E+04, 5.5727267049E+00, 5.9947530042E+00, 3.6222113839E-01, 3.2185363282E-01, 5.8627820813E-01],
	[1.20300E+04, 5.5758610649E+00, 5.9942195290E+00, 3.6269815216E-01, 3.2223912726E-01, 5.8641701114E-01],
	[1.20350E+04, 5.5789958843E+00, 5.9936863230E+00, 3.6317559552E-01, 3.2262488271E-01, 5.8655580126E-01],
	[1.20400E+04, 5.5821311629E+00, 5.9931533858E+00, 3.6365346865E-01, 3.2301089915E-01, 5.8669457847E-01],
	[1.20450E+04, 5.5852669007E+00, 5.9926207173E+00, 3.6413177178E-01, 3.2339717655E-01, 5.8683334277E-01],
	[1.20500E+04, 5.5884030974E+00, 5.9920883172E+00, 3.6461050511E-01, 3.2378371488E-01, 5.8697209415E-01],
	[1.20550E+04, 5.5915397529E+00, 5.9915561852E+00, 3.6508966884E-01, 3.2417051412E-01, 5.8711083259E-01],
	[1.20600E+04, 5.5946768672E+00, 5.9910243210E+00, 3.6556926319E-01, 3.2455757424E-01, 5.8724955810E-01],
	[1.20650E+04, 5.5978144402E+00, 5.9904927246E+00, 3.6604928837E-01, 3.2494489523E-01, 5.8738827066E-01],
	[1.20700E+04, 5.6009524716E+00, 5.9899613955E+00, 3.6652974457E-01, 3.2533247704E-01, 5.8752697025E-01],
	[1.20750E+04, 5.6040909614E+00, 5.9894303336E+00, 3.6701063202E-01, 3.2572031965E-01, 5.8766565688E-01],
	[1.20800E+04, 5.6072299094E+00, 5.9888995386E+00, 3.6749195092E-01, 3.2610842304E-01, 5.8780433053E-01],
	[1.20850E+04, 5.6103693156E+00, 5.9883690103E+00, 3.6797370147E-01, 3.2649678718E-01, 5.8794299119E-01],
	[1.20900E+04, 5.6135091797E+00, 5.9878387483E+00, 3.6845588389E-01, 3.2688541204E-01, 5.8808163886E-01],
	[1.20950E+04, 5.6166495017E+00, 5.9873087526E+00, 3.6893849838E-01, 3.2727429760E-01, 5.8822027352E-01],
	[1.21000E+04, 5.6197902815E+00, 5.9867790228E+00, 3.6942154515E-01, 3.2766344383E-01, 5.8835889516E-01],
	[1.21050E+04, 5.6229315189E+00, 5.9862495587E+00, 3.6990502442E-01, 3.2805285070E-01, 5.8849750378E-01],
	[1.21100E+04, 5.6260732139E+00, 5.9857203600E+00, 3.7038893638E-01, 3.2844251817E-01, 5.8863609937E-01],
	[1.21150E+04, 5.6292153662E+00, 5.9851914266E+00, 3.7087328125E-01, 3.2883244624E-01, 5.8877468192E-01],
	[1.21200E+04, 5.6323579758E+00, 5.9846627581E+00, 3.7135805923E-01, 3.2922263486E-01, 5.8891325141E-01],
	[1.21250E+04, 5.6355010425E+00, 5.9841343543E+00, 3.7184327054E-01, 3.2961308401E-01, 5.8905180785E-01],
	[1.21300E+04, 5.6386445662E+00, 5.9836062150E+00, 3.7232891538E-01, 3.3000379366E-01, 5.8919035121E-01],
	[1.21350E+04, 5.6417885469E+00, 5.9830783399E+00, 3.7281499396E-01, 3.3039476377E-01, 5.8932888150E-01],
	[1.21400E+04, 5.6449329843E+00, 5.9825507289E+00, 3.7330150649E-01, 3.3078599433E-01, 5.8946739870E-01],
	[1.21450E+04, 5.6480778784E+00, 5.9820233816E+00, 3.7378845318E-01, 3.3117748531E-01, 5.8960590281E-01],
	[1.21500E+04, 5.6512232290E+00, 5.9814962978E+00, 3.7427583423E-01, 3.3156923666E-01, 5.8974439381E-01],
	[1.21550E+04, 5.6543690360E+00, 5.9809694772E+00, 3.7476364986E-01, 3.3196124837E-01, 5.8988287170E-01],
	[1.21600E+04, 5.6575152993E+00, 5.9804429198E+00, 3.7525190027E-01, 3.3235352041E-01, 5.9002133646E-01],
	[1.21650E+04, 5.6606620188E+00, 5.9799166251E+00, 3.7574058567E-01, 3.3274605273E-01, 5.9015978810E-01],
	[1.21700E+04, 5.6638091944E+00, 5.9793905930E+00, 3.7622970627E-01, 3.3313884533E-01, 5.9029822659E-01],
	[1.21750E+04, 5.6669568258E+00, 5.9788648231E+00, 3.7671926228E-01, 3.3353189815E-01, 5.9043665194E-01],
	[1.21800E+04, 5.6701049131E+00, 5.9783393154E+00, 3.7720925390E-01, 3.3392521118E-01, 5.9057506413E-01],
	[1.21850E+04, 5.6732534560E+00, 5.9778140695E+00, 3.7769968136E-01, 3.3431878439E-01, 5.9071346316E-01],
	[1.21900E+04, 5.6764024546E+00, 5.9772890853E+00, 3.7819054484E-01, 3.3471261773E-01, 5.9085184901E-01],
	[1.21950E+04, 5.6795519085E+00, 5.9767643623E+00, 3.7868184457E-01, 3.3510671119E-01, 5.9099022167E-01],
	[1.22000E+04, 5.6827018178E+00, 5.9762399006E+00, 3.7917358075E-01, 3.3550106473E-01, 5.9112858115E-01],
	[1.22050E+04, 5.6858521823E+00, 5.9757156997E+00, 3.7966575359E-01, 3.3589567832E-01, 5.9126692742E-01],
	[1.22100E+04, 5.6890030018E+00, 5.9751917594E+00, 3.8015836330E-01, 3.3629055192E-01, 5.9140526049E-01],
	[1.22150E+04, 5.6921542764E+00, 5.9746680796E+00, 3.8065141008E-01, 3.3668568551E-01, 5.9154358034E-01],
	[1.22200E+04, 5.6953060057E+00, 5.9741446600E+00, 3.8114489415E-01, 3.3708107906E-01, 5.9168188696E-01],
	[1.22250E+04, 5.6984581898E+00, 5.9736215003E+00, 3.8163881572E-01, 3.3747673253E-01, 5.9182018035E-01],
	[1.22300E+04, 5.7016108285E+00, 5.9730986003E+00, 3.8213317498E-01, 3.3787264589E-01, 5.9195846050E-01],
	[1.22350E+04, 5.7047639216E+00, 5.9725759598E+00, 3.8262797216E-01, 3.3826881910E-01, 5.9209672740E-01],
	[1.22400E+04, 5.7079174691E+00, 5.9720535786E+00, 3.8312320746E-01, 3.3866525214E-01, 5.9223498104E-01],
	[1.22450E+04, 5.7110714708E+00, 5.9715314563E+00, 3.8361888109E-01, 3.3906194497E-01, 5.9237322141E-01],
	[1.22500E+04, 5.7142259267E+00, 5.9710095929E+00, 3.8411499326E-01, 3.3945889757E-01, 5.9251144851E-01],
	[1.22550E+04, 5.7173808366E+00, 5.9704879879E+00, 3.8461154417E-01, 3.3985610989E-01, 5.9264966232E-01],
	[1.22600E+04, 5.7205362003E+00, 5.9699666413E+00, 3.8510853404E-01, 3.4025358190E-01, 5.9278786284E-01],
	[1.22650E+04, 5.7236920178E+00, 5.9694455528E+00, 3.8560596308E-01, 3.4065131357E-01, 5.9292605006E-01],
	[1.22700E+04, 5.7268482889E+00, 5.9689247221E+00, 3.8610383148E-01, 3.4104930487E-01, 5.9306422397E-01],
	[1.22750E+04, 5.7300050136E+00, 5.9684041490E+00, 3.8660213947E-01, 3.4144755575E-01, 5.9320238456E-01],
	[1.22800E+04, 5.7331621916E+00, 5.9678838332E+00, 3.8710088725E-01, 3.4184606620E-01, 5.9334053183E-01],
	[1.22850E+04, 5.7363198229E+00, 5.9673637747E+00, 3.8760007503E-01, 3.4224483617E-01, 5.9347866577E-01],
	[1.22900E+04, 5.7394779074E+00, 5.9668439730E+00, 3.8809970302E-01, 3.4264386563E-01, 5.9361678636E-01],
	[1.22950E+04, 5.7426364449E+00, 5.9663244280E+00, 3.8859977142E-01, 3.4304315455E-01, 5.9375489361E-01],
	[1.23000E+04, 5.7457954354E+00, 5.9658051395E+00, 3.8910028045E-01, 3.4344270289E-01, 5.9389298750E-01],
	[1.23050E+04, 5.7489548786E+00, 5.9652861072E+00, 3.8960123032E-01, 3.4384251061E-01, 5.9403106802E-01],
	[1.23100E+04, 5.7521147745E+00, 5.9647673309E+00, 3.9010262123E-01, 3.4424257768E-01, 5.9416913517E-01],
	[1.23150E+04, 5.7552751230E+00, 5.9642488103E+00, 3.9060445339E-01, 3.4464290407E-01, 5.9430718894E-01],
	[1.23200E+04, 5.7584359239E+00, 5.9637305453E+00, 3.9110672702E-01, 3.4504348973E-01, 5.9444522933E-01],
	[1.23250E+04, 5.7615971772E+00, 5.9632125355E+00, 3.9160944231E-01, 3.4544433464E-01, 5.9458325631E-01],
	[1.23300E+04, 5.7647588827E+00, 5.9626947809E+00, 3.9211259949E-01, 3.4584543876E-01, 5.9472126989E-01],
	[1.23350E+04, 5.7679210402E+00, 5.9621772810E+00, 3.9261619875E-01, 3.4624680205E-01, 5.9485927006E-01],
	[1.23400E+04, 5.7710836497E+00, 5.9616600358E+00, 3.9312024031E-01, 3.4664842448E-01, 5.9499725681E-01],
	[1.23450E+04, 5.7742467111E+00, 5.9611430450E+00, 3.9362472438E-01, 3.4705030600E-01, 5.9513523013E-01],
	[1.23500E+04, 5.7774102242E+00, 5.9606263083E+00, 3.9412965116E-01, 3.4745244659E-01, 5.9527319001E-01],
	[1.23550E+04, 5.7805741889E+00, 5.9601098256E+00, 3.9463502087E-01, 3.4785484620E-01, 5.9541113645E-01],
	[1.23600E+04, 5.7837386051E+00, 5.9595935966E+00, 3.9514083372E-01, 3.4825750481E-01, 5.9554906944E-01],
	[1.23650E+04, 5.7869034727E+00, 5.9590776210E+00, 3.9564708990E-01, 3.4866042236E-01, 5.9568698897E-01],
	[1.23700E+04, 5.7900687915E+00, 5.9585618987E+00, 3.9615378964E-01, 3.4906359883E-01, 5.9582489503E-01],
	[1.23750E+04, 5.7932345615E+00, 5.9580464294E+00, 3.9666093314E-01, 3.4946703418E-01, 5.9596278762E-01],
	[1.23800E+04, 5.7964007825E+00, 5.9575312129E+00, 3.9716852061E-01, 3.4987072837E-01, 5.9610066673E-01],
	[1.23850E+04, 5.7995674544E+00, 5.9570162489E+00, 3.9767655225E-01, 3.5027468136E-01, 5.9623853235E-01],
	[1.23900E+04, 5.8027345771E+00, 5.9565015373E+00, 3.9818502829E-01, 3.5067889311E-01, 5.9637638447E-01],
	[1.23950E+04, 5.8059021505E+00, 5.9559870779E+00, 3.9869394892E-01, 3.5108336359E-01, 5.9651422309E-01],
	[1.24000E+04, 5.8090701744E+00, 5.9554728703E+00, 3.9920331436E-01, 3.5148809276E-01, 5.9665204819E-01],
	[1.24050E+04, 5.8122386488E+00, 5.9549589144E+00, 3.9971312482E-01, 3.5189308058E-01, 5.9678985978E-01],
	[1.24100E+04, 5.8154075734E+00, 5.9544452099E+00, 4.0022338050E-01, 3.5229832700E-01, 5.9692765784E-01],
	[1.24150E+04, 5.8185769483E+00, 5.9539317566E+00, 4.0073408162E-01, 3.5270383200E-01, 5.9706544236E-01],
	[1.24200E+04, 5.8217514984E+00, 5.9534305905E+00, 4.0124522838E-01, 3.5310965526E-01, 5.9720321334E-01],
	[1.24250E+04, 5.8249300322E+00, 5.9529386560E+00, 4.0175682099E-01, 3.5351578195E-01, 5.9734097078E-01],
	[1.24300E+04, 5.8281090217E+00, 5.9524469602E+00, 4.0226885966E-01, 3.5392216750E-01, 5.9747871466E-01],
	[1.24350E+04, 5.8312884665E+00, 5.9519555026E+00, 4.0278134461E-01, 3.5432881190E-01, 5.9761644497E-01],
	[1.24400E+04, 5.8344683666E+00, 5.9514642832E+00, 4.0329427604E-01, 3.5473571508E-01, 5.9775416171E-01],
	[1.24450E+04, 5.8376487219E+00, 5.9509733017E+00, 4.0380765415E-01, 3.5514287703E-01, 5.9789186488E-01],
	[1.24500E+04, 5.8408295322E+00, 5.9504825578E+00, 4.0432147917E-01, 3.5555029768E-01, 5.9802955446E-01],
	[1.24550E+04, 5.8440107975E+00, 5.9499920515E+00, 4.0483575129E-01, 3.5595797702E-01, 5.9816723045E-01],
	[1.24600E+04, 5.8471925175E+00, 5.9495017825E+00, 4.0535047073E-01, 3.5636591499E-01, 5.9830489283E-01],
	[1.24650E+04, 5.8503746923E+00, 5.9490117505E+00, 4.0586563770E-01, 3.5677411156E-01, 5.9844254162E-01],
	[1.24700E+04, 5.8535573217E+00, 5.9485219554E+00, 4.0638125240E-01, 3.5718256669E-01, 5.9858017678E-01],
	[1.24750E+04, 5.8567404055E+00, 5.9480323969E+00, 4.0689731506E-01, 3.5759128033E-01, 5.9871779833E-01],
	[1.24800E+04, 5.8599239437E+00, 5.9475430749E+00, 4.0741382586E-01, 3.5800025245E-01, 5.9885540625E-01],
	[1.24850E+04, 5.8631079361E+00, 5.9470539891E+00, 4.0793078503E-01, 3.5840948301E-01, 5.9899300053E-01],
	[1.24900E+04, 5.8662923826E+00, 5.9465651394E+00, 4.0844819278E-01, 3.5881897196E-01, 5.9913058117E-01],
	[1.24950E+04, 5.8694772831E+00, 5.9460765254E+00, 4.0896604931E-01, 3.5922871927E-01, 5.9926814816E-01],
	[1.25000E+04, 5.8726626375E+00, 5.9455881471E+00, 4.0948435483E-01, 3.5963872489E-01, 5.9940570149E-01],
	[1.25050E+04, 5.8758484457E+00, 5.9451000042E+00, 4.1000335452E-01, 3.6004917770E-01, 5.9954324116E-01],
	[1.25100E+04, 5.8790347075E+00, 5.9446120964E+00, 4.1052280416E-01, 3.6045988905E-01, 5.9968076717E-01],
	[1.25150E+04, 5.8822214228E+00, 5.9441244237E+00, 4.1104270393E-01, 3.6087085889E-01, 5.9981827949E-01],
	[1.25200E+04, 5.8854085915E+00, 5.9436369857E+00, 4.1156305406E-01, 3.6128208720E-01, 5.9995577813E-01],
	[1.25250E+04, 5.8885962136E+00, 5.9431497823E+00, 4.1208385476E-01, 3.6169357391E-01, 6.0009326308E-01],
	[1.25300E+04, 5.8917842888E+00, 5.9426628133E+00, 4.1260510623E-01, 3.6210531900E-01, 6.0023073433E-01],
	[1.25350E+04, 5.8949728171E+00, 5.9421760784E+00, 4.1312680868E-01, 3.6251732242E-01, 6.0036819188E-01],
	[1.25400E+04, 5.8981617983E+00, 5.9416895775E+00, 4.1364896233E-01, 3.6292958412E-01, 6.0050563571E-01],
	[1.25450E+04, 5.9013512323E+00, 5.9412033103E+00, 4.1417156738E-01, 3.6334210407E-01, 6.0064306583E-01],
	[1.25500E+04, 5.9045411191E+00, 5.9407172767E+00, 4.1469462405E-01, 3.6375488222E-01, 6.0078048222E-01],
	[1.25550E+04, 5.9077314585E+00, 5.9402314764E+00, 4.1521813254E-01, 3.6416791853E-01, 6.0091788489E-01],
	[1.25600E+04, 5.9109222503E+00, 5.9397459092E+00, 4.1574209307E-01, 3.6458121296E-01, 6.0105527381E-01],
	[1.25650E+04, 5.9141134945E+00, 5.9392605750E+00, 4.1626650584E-01, 3.6499476546E-01, 6.0119264899E-01],
	[1.25700E+04, 5.9173051910E+00, 5.9387754735E+00, 4.1679137107E-01, 3.6540857598E-01, 6.0133001042E-01],
	[1.25750E+04, 5.9204973395E+00, 5.9382906045E+00, 4.1731668896E-01, 3.6582264449E-01, 6.0146735809E-01],
	[1.25800E+04, 5.9236899402E+00, 5.9378059678E+00, 4.1784245973E-01, 3.6623697095E-01, 6.0160469199E-01],
	[1.25850E+04, 5.9268829927E+00, 5.9373215633E+00, 4.1836868359E-01, 3.6665155530E-01, 6.0174201213E-01],
	[1.25900E+04, 5.9300764970E+00, 5.9368373906E+00, 4.1889536074E-01, 3.6706639750E-01, 6.0187931848E-01],
	[1.25950E+04, 5.9332704529E+00, 5.9363534497E+00, 4.1942249140E-01, 3.6748149751E-01, 6.0201661106E-01],
	[1.26000E+04, 5.9364648604E+00, 5.9358697402E+00, 4.1995007577E-01, 3.6789685529E-01, 6.0215388984E-01],
	[1.26050E+04, 5.9396597194E+00, 5.9353862621E+00, 4.2047811407E-01, 3.6831247079E-01, 6.0229115482E-01],
	[1.26100E+04, 5.9428550297E+00, 5.9349030151E+00, 4.2100660651E-01, 3.6872834396E-01, 6.0242840600E-01],
	[1.26150E+04, 5.9460507912E+00, 5.9344199989E+00, 4.2153555329E-01, 3.6914447476E-01, 6.0256564337E-01],
	[1.26200E+04, 5.9492470038E+00, 5.9339372135E+00, 4.2206495463E-01, 3.6956086314E-01, 6.0270286693E-01],
	[1.26250E+04, 5.9524436673E+00, 5.9334546585E+00, 4.2259481074E-01, 3.6997750906E-01, 6.0284007666E-01],
	[1.26300E+04, 5.9556407818E+00, 5.9329723338E+00, 4.2312512183E-01, 3.7039441248E-01, 6.0297727257E-01],
	[1.26350E+04, 5.9588383469E+00, 5.9324902393E+00, 4.2365588811E-01, 3.7081157334E-01, 6.0311445463E-01],
	[1.26400E+04, 5.9620363627E+00, 5.9320083746E+00, 4.2418710978E-01, 3.7122899161E-01, 6.0325162286E-01],
	[1.26450E+04, 5.9652348291E+00, 5.9315267396E+00, 4.2471878707E-01, 3.7164666723E-01, 6.0338877724E-01],
	[1.26500E+04, 5.9684337458E+00, 5.9310453341E+00, 4.2525092017E-01, 3.7206460015E-01, 6.0352591776E-01],
	[1.26550E+04, 5.9716331128E+00, 5.9305641579E+00, 4.2578350931E-01, 3.7248279034E-01, 6.0366304443E-01],
	[1.26600E+04, 5.9748329300E+00, 5.9300832107E+00, 4.2631655468E-01, 3.7290123775E-01, 6.0380015723E-01],
	[1.26650E+04, 5.9780331973E+00, 5.9296024925E+00, 4.2685005651E-01, 3.7331994232E-01, 6.0393725615E-01],
	[1.26700E+04, 5.9812339145E+00, 5.9291220029E+00, 4.2738401499E-01, 3.7373890402E-01, 6.0407434120E-01],
	[1.26750E+04, 5.9844350816E+00, 5.9286417419E+00, 4.2791843035E-01, 3.7415812279E-01, 6.0421141236E-01],
	[1.26800E+04, 5.9876366983E+00, 5.9281617091E+00, 4.2845330279E-01, 3.7457759858E-01, 6.0434846960E-01],
	[1.26850E+04, 5.9908387647E+00, 5.9276819045E+00, 4.2898863252E-01, 3.7499733136E-01, 6.0448551287E-01],
	[1.26900E+04, 5.9940412805E+00, 5.9272023277E+00, 4.2952441976E-01, 3.7541732107E-01, 6.0462254215E-01],
	[1.26950E+04, 5.9972442458E+00, 5.9267229786E+00, 4.3006066471E-01, 3.7583756766E-01, 6.0475955744E-01],
	[1.27000E+04, 6.0004476603E+00, 5.9262438570E+00, 4.3059736758E-01, 3.7625807108E-01, 6.0489655870E-01],
	[1.27050E+04, 6.0036515239E+00, 5.9257649628E+00, 4.3113452859E-01, 3.7667883129E-01, 6.0503354592E-01],
	[1.27100E+04, 6.0068558366E+00, 5.9252862956E+00, 4.3167214794E-01, 3.7709984824E-01, 6.0517051909E-01],
	[1.27150E+04, 6.0100605982E+00, 5.9248078553E+00, 4.3221022585E-01, 3.7752112188E-01, 6.0530747819E-01],
	[1.27200E+04, 6.0132658086E+00, 5.9243296418E+00, 4.3274876253E-01, 3.7794265217E-01, 6.0544442319E-01],
	[1.27250E+04, 6.0164714676E+00, 5.9238516548E+00, 4.3328775818E-01, 3.7836443904E-01, 6.0558135409E-01],
	[1.27300E+04, 6.0196775753E+00, 5.9233738941E+00, 4.3382721302E-01, 3.7878648245E-01, 6.0571827087E-01],
	[1.27350E+04, 6.0228841315E+00, 5.9228963595E+00, 4.3436712725E-01, 3.7920878236E-01, 6.0585517350E-01],
	[1.27400E+04, 6.0260911359E+00, 5.9224190508E+00, 4.3490750110E-01, 3.7963133871E-01, 6.0599206198E-01],
	[1.27450E+04, 6.0292985887E+00, 5.9219419679E+00, 4.3544833476E-01, 3.8005415146E-01, 6.0612893628E-01],
	[1.27500E+04, 6.0325064895E+00, 5.9214651105E+00, 4.3598962846E-01, 3.8047722055E-01, 6.0626579639E-01],
	[1.27550E+04, 6.0357148384E+00, 5.9209884785E+00, 4.3653138240E-01, 3.8090054593E-01, 6.0640264229E-01],
	[1.27600E+04, 6.0389236352E+00, 5.9205120716E+00, 4.3707359678E-01, 3.8132412756E-01, 6.0653947397E-01],
	[1.27650E+04, 6.0421328797E+00, 5.9200358896E+00, 4.3761627183E-01, 3.8174796538E-01, 6.0667629140E-01],
	[1.27700E+04, 6.0453425719E+00, 5.9195599324E+00, 4.3815940775E-01, 3.8217205935E-01, 6.0681309458E-01],
	[1.27750E+04, 6.0485527117E+00, 5.9190841998E+00, 4.3870300476E-01, 3.8259640940E-01, 6.0694988348E-01],
	[1.27800E+04, 6.0517632990E+00, 5.9186086916E+00, 4.3924706306E-01, 3.8302101549E-01, 6.0708665808E-01],
	[1.27850E+04, 6.0549743335E+00, 5.9181334075E+00, 4.3979158286E-01, 3.8344587758E-01, 6.0722341838E-01],
	[1.27900E+04, 6.0581858153E+00, 5.9176583474E+00, 4.4033656438E-01, 3.8387099560E-01, 6.0736016435E-01],
	[1.27950E+04, 6.0613977442E+00, 5.9171835111E+00, 4.4088200783E-01, 3.8429636951E-01, 6.0749689597E-01],
	[1.28000E+04, 6.0646101201E+00, 5.9167088984E+00, 4.4142791341E-01, 3.8472199925E-01, 6.0763361324E-01],
	[1.28050E+04, 6.0678229429E+00, 5.9162345091E+00, 4.4197428134E-01, 3.8514788478E-01, 6.0777031613E-01],
	[1.28100E+04, 6.0710362125E+00, 5.9157603430E+00, 4.4252111183E-01, 3.8557402604E-01, 6.0790700462E-01],
	[1.28150E+04, 6.0742499287E+00, 5.9152864000E+00, 4.4306840509E-01, 3.8600042298E-01, 6.0804367871E-01],
	[1.28200E+04, 6.0774640915E+00, 5.9148126797E+00, 4.4361616133E-01, 3.8642707554E-01, 6.0818033837E-01],
	[1.28250E+04, 6.0806787007E+00, 5.9143391821E+00, 4.4416438076E-01, 3.8685398367E-01, 6.0831698359E-01],
	[1.28300E+04, 6.0838937562E+00, 5.9138659070E+00, 4.4471306360E-01, 3.8728114733E-01, 6.0845361435E-01],
	[1.28350E+04, 6.0871092580E+00, 5.9133928541E+00, 4.4526221004E-01, 3.8770856646E-01, 6.0859023063E-01],
	[1.28400E+04, 6.0903252058E+00, 5.9129200233E+00, 4.4581182032E-01, 3.8813624100E-01, 6.0872683242E-01],
	[1.28450E+04, 6.0935415996E+00, 5.9124474143E+00, 4.4636189462E-01, 3.8856417090E-01, 6.0886341970E-01],
	[1.28500E+04, 6.0967584393E+00, 5.9119750270E+00, 4.4691243317E-01, 3.8899235610E-01, 6.0899999246E-01],
	[1.28550E+04, 6.0999757248E+00, 5.9115028612E+00, 4.4746343618E-01, 3.8942079657E-01, 6.0913655067E-01],
	[1.28600E+04, 6.1031934559E+00, 5.9110309168E+00, 4.4801490386E-01, 3.8984949223E-01, 6.0927309433E-01],
	[1.28650E+04, 6.1064116326E+00, 5.9105591934E+00, 4.4856683641E-01, 3.9027844304E-01, 6.0940962341E-01],
	[1.28700E+04, 6.1096302547E+00, 5.9100876910E+00, 4.4911923406E-01, 3.9070764894E-01, 6.0954613790E-01],
	[1.28750E+04, 6.1128493221E+00, 5.9096164093E+00, 4.4967209700E-01, 3.9113710988E-01, 6.0968263779E-01],
	[1.28800E+04, 6.1160688347E+00, 5.9091453481E+00, 4.5022542546E-01, 3.9156682581E-01, 6.0981912305E-01],
	[1.28850E+04, 6.1192887924E+00, 5.9086745073E+00, 4.5077921964E-01, 3.9199679666E-01, 6.0995559368E-01],
	[1.28900E+04, 6.1225091951E+00, 5.9082038866E+00, 4.5133347975E-01, 3.9242702238E-01, 6.1009204964E-01],
	[1.28950E+04, 6.1257300427E+00, 5.9077334860E+00, 4.5188820601E-01, 3.9285750293E-01, 6.1022849094E-01],
	[1.29000E+04, 6.1289513351E+00, 5.9072633051E+00, 4.5244339863E-01, 3.9328823823E-01, 6.1036491755E-01],
	[1.29050E+04, 6.1321730720E+00, 5.9067933439E+00, 4.5299905781E-01, 3.9371922825E-01, 6.1050132946E-01],
	[1.29100E+04, 6.1353952536E+00, 5.9063236020E+00, 4.5355518377E-01, 3.9415047292E-01, 6.1063772665E-01],
	[1.29150E+04, 6.1386230956E+00, 5.9058642088E+00, 4.5411177672E-01, 3.9458203895E-01, 6.1077410910E-01],
	[1.29200E+04, 6.1418562879E+00, 5.9054145438E+00, 4.5466883686E-01, 3.9501392262E-01, 6.1091047680E-01],
	[1.29250E+04, 6.1450899311E+00, 5.9049650870E+00, 4.5522636442E-01, 3.9544606127E-01, 6.1104682973E-01],
	[1.29300E+04, 6.1483240251E+00, 5.9045158382E+00, 4.5578435961E-01, 3.9587845483E-01, 6.1118316789E-01],
	[1.29350E+04, 6.1515585698E+00, 5.9040667972E+00, 4.5634282262E-01, 3.9631110325E-01, 6.1131949124E-01],
	[1.29400E+04, 6.1547935652E+00, 5.9036179640E+00, 4.5690175368E-01, 3.9674400648E-01, 6.1145579977E-01],
	[1.29450E+04, 6.1580290110E+00, 5.9031693382E+00, 4.5746115300E-01, 3.9717716445E-01, 6.1159209348E-01],
	[1.29500E+04, 6.1612649072E+00, 5.9027209198E+00, 4.5802102079E-01, 3.9761057712E-01, 6.1172837234E-01],
	[1.29550E+04, 6.1645012536E+00, 5.9022727085E+00, 4.5858135725E-01, 3.9804424443E-01, 6.1186463633E-01],
	[1.29600E+04, 6.1677380502E+00, 5.9018247041E+00, 4.5914216260E-01, 3.9847816632E-01, 6.1200088545E-01],
	[1.29650E+04, 6.1709752969E+00, 5.9013769066E+00, 4.5970343705E-01, 3.9891234273E-01, 6.1213711967E-01],
	[1.29700E+04, 6.1742129934E+00, 5.9009293157E+00, 4.6026518082E-01, 3.9934677361E-01, 6.1227333899E-01],
	[1.29750E+04, 6.1774511398E+00, 5.9004819312E+00, 4.6082739411E-01, 3.9978145891E-01, 6.1240954337E-01],
	[1.29800E+04, 6.1806897359E+00, 5.9000347530E+00, 4.6139007713E-01, 4.0021639855E-01, 6.1254573282E-01],
	[1.29850E+04, 6.1839287816E+00, 5.8995877809E+00, 4.6195323010E-01, 4.0065159249E-01, 6.1268190731E-01],
	[1.29900E+04, 6.1871682768E+00, 5.8991410147E+00, 4.6251685323E-01, 4.0108704067E-01, 6.1281806683E-01],
	[1.29950E+04, 6.1904082213E+00, 5.8986944542E+00, 4.6308094672E-01, 4.0152274304E-01, 6.1295421136E-01],
	[1.30000E+04, 6.1936486151E+00, 5.8982480993E+00, 4.6364551080E-01, 4.0195869952E-01, 6.1309034089E-01],
	[1.30050E+04, 6.1968894581E+00, 5.8978019499E+00, 4.6421054567E-01, 4.0239491008E-01, 6.1322645540E-01],
	[1.30100E+04, 6.2001307501E+00, 5.8973560056E+00, 4.6477605154E-01, 4.0283137464E-01, 6.1336255487E-01],
	[1.30150E+04, 6.2033724910E+00, 5.8969102664E+00, 4.6534202862E-01, 4.0326809315E-01, 6.1349863930E-01],
	[1.30200E+04, 6.2066146808E+00, 5.8964647321E+00, 4.6590847713E-01, 4.0370506555E-01, 6.1363470866E-01],
	[1.30250E+04, 6.2098573192E+00, 5.8960194025E+00, 4.6647539728E-01, 4.0414229178E-01, 6.1377076294E-01],
	[1.30300E+04, 6.2131004063E+00, 5.8955742774E+00, 4.6704278927E-01, 4.0457977178E-01, 6.1390680212E-01],
	[1.30350E+04, 6.2163439419E+00, 5.8951293566E+00, 4.6761065333E-01, 4.0501750551E-01, 6.1404282619E-01],
	[1.30400E+04, 6.2195879258E+00, 5.8946846401E+00, 4.6817898965E-01, 4.0545549288E-01, 6.1417883514E-01],
	[1.30450E+04, 6.2228323580E+00, 5.8942401276E+00, 4.6874779846E-01, 4.0589373385E-01, 6.1431482894E-01],
	[1.30500E+04, 6.2260772384E+00, 5.8937958189E+00, 4.6931707996E-01, 4.0633222836E-01, 6.1445080759E-01],
	[1.30550E+04, 6.2293225668E+00, 5.8933517139E+00, 4.6988683437E-01, 4.0677097635E-01, 6.1458677106E-01],
	[1.30600E+04, 6.2325683432E+00, 5.8929078124E+00, 4.7045706190E-01, 4.0720997775E-01, 6.1472271935E-01],
	[1.30650E+04, 6.2358145674E+00, 5.8924641142E+00, 4.7102776275E-01, 4.0764923251E-01, 6.1485865243E-01],
	[1.30700E+04, 6.2390612393E+00, 5.8920206192E+00, 4.7159893714E-01, 4.0808874057E-01, 6.1499457030E-01],
	[1.30750E+04, 6.2423083588E+00, 5.8915773272E+00, 4.7217058529E-01, 4.0852850186E-01, 6.1513047293E-01],
	[1.30800E+04, 6.2455559259E+00, 5.8911342380E+00, 4.7274270740E-01, 4.0896851633E-01, 6.1526636032E-01],
	[1.30850E+04, 6.2488039403E+00, 5.8906913515E+00, 4.7331530368E-01, 4.0940878391E-01, 6.1540223244E-01],
	[1.30900E+04, 6.2520524020E+00, 5.8902486674E+00, 4.7388837435E-01, 4.0984930455E-01, 6.1553808929E-01],
	[1.30950E+04, 6.2553013109E+00, 5.8898061856E+00, 4.7446191962E-01, 4.1029007818E-01, 6.1567393084E-01],
	[1.31000E+04, 6.2585506669E+00, 5.8893639060E+00, 4.7503593969E-01, 4.1073110475E-01, 6.1580975708E-01],
	[1.31050E+04, 6.2618004698E+00, 5.8889218283E+00, 4.7561043479E-01, 4.1117238418E-01, 6.1594556800E-01],
	[1.31100E+04, 6.2650507196E+00, 5.8884799525E+00, 4.7618540512E-01, 4.1161391642E-01, 6.1608136358E-01],
	[1.31150E+04, 6.2683014161E+00, 5.8880382783E+00, 4.7676085090E-01, 4.1205570141E-01, 6.1621714381E-01],
	[1.31200E+04, 6.2715525592E+00, 5.8875968055E+00, 4.7733677233E-01, 4.1249773909E-01, 6.1635290868E-01],
	[1.31250E+04, 6.2748041488E+00, 5.8871555340E+00, 4.7791316963E-01, 4.1294002938E-01, 6.1648865816E-01],
	[1.31300E+04, 6.2780561849E+00, 5.8867144637E+00, 4.7849004301E-01, 4.1338257224E-01, 6.1662439224E-01],
	[1.31350E+04, 6.2813086673E+00, 5.8862735943E+00, 4.7906739268E-01, 4.1382536760E-01, 6.1676011091E-01],
	[1.31400E+04, 6.2845615958E+00, 5.8858329257E+00, 4.7964521885E-01, 4.1426841539E-01, 6.1689581415E-01],
	[1.31450E+04, 6.2878149705E+00, 5.8853924577E+00, 4.8022352174E-01, 4.1471171556E-01, 6.1703150195E-01],
	[1.31500E+04, 6.2910687911E+00, 5.8849521902E+00, 4.8080230156E-01, 4.1515526803E-01, 6.1716717430E-01],
	[1.31550E+04, 6.2943230576E+00, 5.8845121230E+00, 4.8138155851E-01, 4.1559907275E-01, 6.1730283117E-01],
	[1.31600E+04, 6.2975777699E+00, 5.8840722559E+00, 4.8196129281E-01, 4.1604312966E-01, 6.1743847256E-01],
	[1.31650E+04, 6.3008329278E+00, 5.8836325887E+00, 4.8254150467E-01, 4.1648743868E-01, 6.1757409845E-01],
	[1.31700E+04, 6.3040885312E+00, 5.8831931213E+00, 4.8312219431E-01, 4.1693199976E-01, 6.1770970882E-01],
	[1.31750E+04, 6.3073445801E+00, 5.8827538536E+00, 4.8370336193E-01, 4.1737681284E-01, 6.1784530367E-01],
	[1.31800E+04, 6.3106010743E+00, 5.8823147853E+00, 4.8428500775E-01, 4.1782187784E-01, 6.1798088297E-01],
	[1.31850E+04, 6.3138580138E+00, 5.8818759163E+00, 4.8486713198E-01, 4.1826719470E-01, 6.1811644671E-01],
	[1.31900E+04, 6.3171153983E+00, 5.8814372464E+00, 4.8544973483E-01, 4.1871276337E-01, 6.1825199488E-01],
	[1.31950E+04, 6.3203732279E+00, 5.8809987754E+00, 4.8603281652E-01, 4.1915858377E-01, 6.1838752746E-01],
	[1.32000E+04, 6.3236315023E+00, 5.8805605033E+00, 4.8661637724E-01, 4.1960465584E-01, 6.1852304444E-01],
	[1.32050E+04, 6.3268902215E+00, 5.8801224297E+00, 4.8720041723E-01, 4.2005097952E-01, 6.1865854580E-01],
	[1.32100E+04, 6.3301493854E+00, 5.8796845547E+00, 4.8778493668E-01, 4.2049755473E-01, 6.1879403153E-01],
	[1.32150E+04, 6.3334089939E+00, 5.8792468779E+00, 4.8836993581E-01, 4.2094438143E-01, 6.1892950162E-01],
	[1.32200E+04, 6.3366690469E+00, 5.8788093992E+00, 4.8895541483E-01, 4.2139145953E-01, 6.1906495605E-01],
	[1.32250E+04, 6.3399295442E+00, 5.8783721186E+00, 4.8954137396E-01, 4.2183878897E-01, 6.1920039480E-01],
	[1.32300E+04, 6.3431904857E+00, 5.8779350357E+00, 4.9012781341E-01, 4.2228636970E-01, 6.1933581787E-01],
	[1.32350E+04, 6.3464518715E+00, 5.8774981504E+00, 4.9071473338E-01, 4.2273420163E-01, 6.1947122523E-01],
	[1.32400E+04, 6.3497137012E+00, 5.8770614626E+00, 4.9130213409E-01, 4.2318228472E-01, 6.1960661688E-01],
	[1.32450E+04, 6.3529759749E+00, 5.8766249722E+00, 4.9189001576E-01, 4.2363061888E-01, 6.1974199280E-01],
	[1.32500E+04, 6.3562386923E+00, 5.8761886788E+00, 4.9247837858E-01, 4.2407920406E-01, 6.1987735297E-01],
	[1.32550E+04, 6.3595018535E+00, 5.8757525825E+00, 4.9306722279E-01, 4.2452804018E-01, 6.2001269738E-01],
	[1.32600E+04, 6.3627654583E+00, 5.8753166830E+00, 4.9365654858E-01, 4.2497712719E-01, 6.2014802602E-01],
	[1.32650E+04, 6.3660295067E+00, 5.8748809801E+00, 4.9424635617E-01, 4.2542646501E-01, 6.2028333887E-01],
	[1.32700E+04, 6.3692939983E+00, 5.8744454737E+00, 4.9483664578E-01, 4.2587605357E-01, 6.2041863593E-01],
	[1.32750E+04, 6.3725589333E+00, 5.8740101637E+00, 4.9542741761E-01, 4.2632589281E-01, 6.2055391716E-01],
	[1.32800E+04, 6.3758243115E+00, 5.8735750498E+00, 4.9601867187E-01, 4.2677598267E-01, 6.2068918257E-01],
	[1.32850E+04, 6.3790901327E+00, 5.8731401319E+00, 4.9661040879E-01, 4.2722632307E-01, 6.2082443213E-01],
	[1.32900E+04, 6.3823563969E+00, 5.8727054099E+00, 4.9720262856E-01, 4.2767691394E-01, 6.2095966584E-01],
	[1.32950E+04, 6.3856231040E+00, 5.8722708835E+00, 4.9779533141E-01, 4.2812775522E-01, 6.2109488368E-01],
	[1.33000E+04, 6.3888902538E+00, 5.8718365527E+00, 4.9838851754E-01, 4.2857884685E-01, 6.2123008563E-01],
	[1.33050E+04, 6.3921578463E+00, 5.8714024172E+00, 4.9898218717E-01, 4.2903018874E-01, 6.2136527168E-01],
	[1.33100E+04, 6.3954258813E+00, 5.8709684769E+00, 4.9957634051E-01, 4.2948178084E-01, 6.2150044182E-01],
	[1.33150E+04, 6.3986943587E+00, 5.8705347317E+00, 5.0017097777E-01, 4.2993362307E-01, 6.2163559603E-01],
	[1.33200E+04, 6.4019632785E+00, 5.8701011813E+00, 5.0076609917E-01, 4.3038571537E-01, 6.2177073430E-01],
	[1.33250E+04, 6.4052326404E+00, 5.8696678257E+00, 5.0136170491E-01, 4.3083805766E-01, 6.2190585662E-01],
	[1.33300E+04, 6.4085024445E+00, 5.8692346646E+00, 5.0195779520E-01, 4.3129064988E-01, 6.2204096297E-01],
	[1.33350E+04, 6.4117726906E+00, 5.8688016978E+00, 5.0255437027E-01, 4.3174349196E-01, 6.2217605334E-01],
	[1.33400E+04, 6.4150433786E+00, 5.8683689254E+00, 5.0315143032E-01, 4.3219658382E-01, 6.2231112771E-01],
	[1.33450E+04, 6.4183145084E+00, 5.8679363470E+00, 5.0374897557E-01, 4.3264992541E-01, 6.2244618608E-01],
	[1.33500E+04, 6.4215860799E+00, 5.8675039625E+00, 5.0434700622E-01, 4.3310351664E-01, 6.2258122842E-01],
	[1.33550E+04, 6.4248580930E+00, 5.8670717717E+00, 5.0494552249E-01, 4.3355735746E-01, 6.2271625472E-01],
	[1.33600E+04, 6.4281305476E+00, 5.8666397746E+00, 5.0554452460E-01, 4.3401144778E-01, 6.2285126498E-01],
	[1.33650E+04, 6.4314034435E+00, 5.8662079709E+00, 5.0614401274E-01, 4.3446578754E-01, 6.2298625917E-01],
	[1.33700E+04, 6.4346767807E+00, 5.8657763605E+00, 5.0674398715E-01, 4.3492037666E-01, 6.2312123729E-01],
	[1.33750E+04, 6.4379505590E+00, 5.8653449432E+00, 5.0734444802E-01, 4.3537521509E-01, 6.2325619931E-01],
	[1.33800E+04, 6.4412247785E+00, 5.8649137188E+00, 5.0794539557E-01, 4.3583030274E-01, 6.2339114523E-01],
	[1.33850E+04, 6.4444994388E+00, 5.8644826873E+00, 5.0854683002E-01, 4.3628563954E-01, 6.2352607503E-01],
	[1.33900E+04, 6.4477745400E+00, 5.8640518484E+00, 5.0914875157E-01, 4.3674122543E-01, 6.2366098870E-01],
	[1.33950E+04, 6.4510500820E+00, 5.8636212019E+00, 5.0975116044E-01, 4.3719706033E-01, 6.2379588623E-01],
	[1.34000E+04, 6.4543260646E+00, 5.8631907478E+00, 5.1035405684E-01, 4.3765314417E-01, 6.2393076760E-01],
	[1.34050E+04, 6.4576024877E+00, 5.8627604859E+00, 5.1095744099E-01, 4.3810947688E-01, 6.2406563280E-01],
	[1.34100E+04, 6.4608793513E+00, 5.8623304160E+00, 5.1156131309E-01, 4.3856605839E-01, 6.2420048181E-01],
	[1.34150E+04, 6.4641566551E+00, 5.8619005380E+00, 5.1216567336E-01, 4.3902288862E-01, 6.2433531463E-01],
	[1.34200E+04, 6.4674343992E+00, 5.8614708516E+00, 5.1277052200E-01, 4.3947996750E-01, 6.2447013123E-01],
	[1.34250E+04, 6.4707125834E+00, 5.8610413568E+00, 5.1337585924E-01, 4.3993729497E-01, 6.2460493161E-01],
	[1.34300E+04, 6.4739975693E+00, 5.8606214878E+00, 5.1398168529E-01, 4.4039495365E-01, 6.2473971576E-01],
	[1.34350E+04, 6.4772891715E+00, 5.8602109535E+00, 5.1458800035E-01, 4.4085294143E-01, 6.2487448365E-01],
	[1.34400E+04, 6.4805812216E+00, 5.8598006007E+00, 5.1519480465E-01, 4.4131117814E-01, 6.2500923528E-01],
	[1.34450E+04, 6.4838737194E+00, 5.8593904292E+00, 5.1580209839E-01, 4.4176966372E-01, 6.2514397063E-01],
	[1.34500E+04, 6.4871666649E+00, 5.8589804390E+00, 5.1640988178E-01, 4.4222839809E-01, 6.2527868966E-01],
	[1.34550E+04, 6.4904600578E+00, 5.8585706298E+00, 5.1701815504E-01, 4.4268738117E-01, 6.2541339235E-01],
	[1.34600E+04, 6.4937538983E+00, 5.8581610015E+00, 5.1762691838E-01, 4.4314661291E-01, 6.2554807867E-01],
	[1.34650E+04, 6.4970481860E+00, 5.8577515539E+00, 5.1823617201E-01, 4.4360609322E-01, 6.2568274861E-01],
	[1.34700E+04, 6.5003429209E+00, 5.8573422870E+00, 5.1884591615E-01, 4.4406582203E-01, 6.2581740213E-01],
	[1.34750E+04, 6.5036381030E+00, 5.8569332006E+00, 5.1945615101E-01, 4.4452579927E-01, 6.2595203923E-01],
	[1.34800E+04, 6.5069337320E+00, 5.8565242945E+00, 5.2006687680E-01, 4.4498602486E-01, 6.2608665988E-01],
	[1.34850E+04, 6.5102298080E+00, 5.8561155685E+00, 5.2067809373E-01, 4.4544649874E-01, 6.2622126407E-01],
	[1.34900E+04, 6.5135263307E+00, 5.8557070226E+00, 5.2128980202E-01, 4.4590722082E-01, 6.2635585176E-01],
	[1.34950E+04, 6.5168233002E+00, 5.8552986566E+00, 5.2190200188E-01, 4.4636819104E-01, 6.2649042294E-01],
	[1.35000E+04, 6.5201207162E+00, 5.8548904703E+00, 5.2251469352E-01, 4.4682940932E-01, 6.2662497760E-01],
	[1.35050E+04, 6.5234185787E+00, 5.8544824636E+00, 5.2312787715E-01, 4.4729087559E-01, 6.2675951570E-01],
	[1.35100E+04, 6.5267168875E+00, 5.8540746363E+00, 5.2374155300E-01, 4.4775258977E-01, 6.2689403724E-01],
	[1.35150E+04, 6.5300156427E+00, 5.8536669884E+00, 5.2435572126E-01, 4.4821455179E-01, 6.2702854218E-01],
	[1.35200E+04, 6.5333148440E+00, 5.8532595196E+00, 5.2497038215E-01, 4.4867676157E-01, 6.2716303052E-01],
	[1.35250E+04, 6.5366144913E+00, 5.8528522298E+00, 5.2558553589E-01, 4.4913921904E-01, 6.2729750222E-01],
	[1.35300E+04, 6.5399145846E+00, 5.8524451188E+00, 5.2620118268E-01, 4.4960192412E-01, 6.2743195728E-01],
	[1.35350E+04, 6.5432151238E+00, 5.8520381866E+00, 5.2681732275E-01, 4.5006487675E-01, 6.2756639566E-01],
	[1.35400E+04, 6.5465161087E+00, 5.8516314330E+00, 5.2743395630E-01, 4.5052807684E-01, 6.2770081736E-01],
	[1.35450E+04, 6.5498175392E+00, 5.8512248578E+00, 5.2805108355E-01, 4.5099152431E-01, 6.2783522234E-01],
	[1.35500E+04, 6.5531194153E+00, 5.8508184609E+00, 5.2866870470E-01, 4.5145521910E-01, 6.2796961059E-01],
	[1.35550E+04, 6.5564217368E+00, 5.8504122422E+00, 5.2928681998E-01, 4.5191916113E-01, 6.2810398210E-01],
	[1.35600E+04, 6.5597245037E+00, 5.8500062014E+00, 5.2990542959E-01, 4.5238335032E-01, 6.2823833683E-01],
	[1.35650E+04, 6.5630277157E+00, 5.8496003385E+00, 5.3052453375E-01, 4.5284778659E-01, 6.2837267478E-01],
	[1.35700E+04, 6.5663313729E+00, 5.8491946533E+00, 5.3114413267E-01, 4.5331246987E-01, 6.2850699591E-01],
	[1.35750E+04, 6.5696354751E+00, 5.8487891457E+00, 5.3176422656E-01, 4.5377740009E-01, 6.2864130022E-01],
	[1.35800E+04, 6.5729400222E+00, 5.8483838155E+00, 5.3238481564E-01, 4.5424257716E-01, 6.2877558767E-01],
	[1.35850E+04, 6.5762450141E+00, 5.8479786626E+00, 5.3300590012E-01, 4.5470800101E-01, 6.2890985826E-01],
	[1.35900E+04, 6.5795504508E+00, 5.8475736869E+00, 5.3362748021E-01, 4.5517367157E-01, 6.2904411196E-01],
	[1.35950E+04, 6.5828563320E+00, 5.8471688881E+00, 5.3424955612E-01, 4.5563958875E-01, 6.2917834875E-01],
	[1.36000E+04, 6.5861626577E+00, 5.8467642662E+00, 5.3487212808E-01, 4.5610575248E-01, 6.2931256861E-01],
	[1.36050E+04, 6.5894694278E+00, 5.8463598210E+00, 5.3549519628E-01, 4.5657216267E-01, 6.2944677153E-01],
	[1.36100E+04, 6.5927766422E+00, 5.8459555524E+00, 5.3611876095E-01, 4.5703881927E-01, 6.2958095748E-01],
	[1.36150E+04, 6.5960843008E+00, 5.8455514603E+00, 5.3674282229E-01, 4.5750572218E-01, 6.2971512644E-01],
	[1.36200E+04, 6.5993924035E+00, 5.8451475444E+00, 5.3736738053E-01, 4.5797287132E-01, 6.2984927840E-01],
	[1.36250E+04, 6.6027009501E+00, 5.8447438046E+00, 5.3799243586E-01, 4.5844026663E-01, 6.2998341333E-01],
	[1.36300E+04, 6.6060099406E+00, 5.8443402409E+00, 5.3861798852E-01, 4.5890790802E-01, 6.3011753121E-01],
	[1.36350E+04, 6.6093193749E+00, 5.8439368530E+00, 5.3924403870E-01, 4.5937579541E-01, 6.3025163203E-01],
	[1.36400E+04, 6.6126292529E+00, 5.8435336409E+00, 5.3987058662E-01, 4.5984392872E-01, 6.3038571577E-01],
	[1.36450E+04, 6.6159395744E+00, 5.8431306043E+00, 5.4049763250E-01, 4.6031230789E-01, 6.3051978240E-01],
	[1.36500E+04, 6.6192503394E+00, 5.8427277432E+00, 5.4112517654E-01, 4.6078093281E-01, 6.3065383191E-01],
	[1.36550E+04, 6.6225615477E+00, 5.8423250573E+00, 5.4175321897E-01, 4.6124980343E-01, 6.3078786428E-01],
	[1.36600E+04, 6.6258731993E+00, 5.8419225467E+00, 5.4238175999E-01, 4.6171891966E-01, 6.3092187949E-01],
	[1.36650E+04, 6.6291852940E+00, 5.8415202110E+00, 5.4301079982E-01, 4.6218828141E-01, 6.3105587752E-01],
	[1.36700E+04, 6.6324978318E+00, 5.8411180503E+00, 5.4364033867E-01, 4.6265788862E-01, 6.3118985835E-01],
	[1.36750E+04, 6.6358108126E+00, 5.8407160643E+00, 5.4427037675E-01, 4.6312774120E-01, 6.3132382196E-01],
	[1.36800E+04, 6.6391242362E+00, 5.8403142528E+00, 5.4490091428E-01, 4.6359783906E-01, 6.3145776833E-01],
	[1.36850E+04, 6.6424381025E+00, 5.8399126159E+00, 5.4553195147E-01, 4.6406818214E-01, 6.3159169745E-01],
	[1.36900E+04, 6.6457524115E+00, 5.8395111532E+00, 5.4616348853E-01, 4.6453877035E-01, 6.3172560928E-01],
	[1.36950E+04, 6.6490671630E+00, 5.8391098648E+00, 5.4679729219E-01, 4.6501088120E-01, 6.3185950383E-01],
	[1.37000E+04, 6.6523823569E+00, 5.8387087504E+00, 5.4743448465E-01, 4.6548532471E-01, 6.3199338106E-01],
	[1.37050E+04, 6.6556979932E+00, 5.8383078099E+00, 5.4807218673E-01, 4.6596001775E-01, 6.3212724095E-01],
	[1.37100E+04, 6.6590140717E+00, 5.8379070431E+00, 5.4871039864E-01, 4.6643496023E-01, 6.3226108349E-01],
	[1.37150E+04, 6.6623305923E+00, 5.8375064500E+00, 5.4934912061E-01, 4.6691015207E-01, 6.3239490867E-01],
	[1.37200E+04, 6.6656475550E+00, 5.8371060304E+00, 5.4998835286E-01, 4.6738559320E-01, 6.3252871645E-01],
	[1.37250E+04, 6.6689649596E+00, 5.8367057841E+00, 5.5062809561E-01, 4.6786128352E-01, 6.3266250682E-01],
	[1.37300E+04, 6.6722828060E+00, 5.8363057111E+00, 5.5126834908E-01, 4.6833722296E-01, 6.3279627976E-01],
	[1.37350E+04, 6.6756010941E+00, 5.8359058111E+00, 5.5190911350E-01, 4.6881341144E-01, 6.3293003526E-01],
	[1.37400E+04, 6.6789198238E+00, 5.8355060840E+00, 5.5255038908E-01, 4.6928984887E-01, 6.3306377329E-01],
	[1.37450E+04, 6.6822389951E+00, 5.8351065298E+00, 5.5319217605E-01, 4.6976653517E-01, 6.3319749384E-01],
	[1.37500E+04, 6.6855586077E+00, 5.8347071482E+00, 5.5383447463E-01, 4.7024347025E-01, 6.3333119689E-01],
	[1.37550E+04, 6.6888786617E+00, 5.8343079391E+00, 5.5447728504E-01, 4.7072065405E-01, 6.3346488241E-01],
	[1.37600E+04, 6.6921991569E+00, 5.8339089025E+00, 5.5512060750E-01, 4.7119808646E-01, 6.3359855039E-01],
	[1.37650E+04, 6.6955200931E+00, 5.8335100380E+00, 5.5576444223E-01, 4.7167576741E-01, 6.3373220081E-01],
	[1.37700E+04, 6.6988414704E+00, 5.8331113457E+00, 5.5640878946E-01, 4.7215369681E-01, 6.3386583366E-01],
	[1.37750E+04, 6.7021632886E+00, 5.8327128254E+00, 5.5705364941E-01, 4.7263187459E-01, 6.3399944890E-01],
	[1.37800E+04, 6.7054855476E+00, 5.8323144769E+00, 5.5769902229E-01, 4.7311030065E-01, 6.3413304654E-01],
	[1.37850E+04, 6.7088082473E+00, 5.8319163001E+00, 5.5834490834E-01, 4.7358897492E-01, 6.3426662654E-01],
	[1.37900E+04, 6.7121313876E+00, 5.8315182949E+00, 5.5899130776E-01, 4.7406789731E-01, 6.3440018888E-01],
	[1.37950E+04, 6.7154549684E+00, 5.8311204611E+00, 5.5963822079E-01, 4.7454706773E-01, 6.3453373356E-01],
	[1.38000E+04, 6.7187789896E+00, 5.8307227986E+00, 5.6028564765E-01, 4.7502648610E-01, 6.3466726055E-01],
	[1.38050E+04, 6.7221034511E+00, 5.8303253072E+00, 5.6093358855E-01, 4.7550615234E-01, 6.3480076983E-01],
	[1.38100E+04, 6.7254283527E+00, 5.8299279869E+00, 5.6158204372E-01, 4.7598606636E-01, 6.3493426138E-01],
	[1.38150E+04, 6.7287536945E+00, 5.8295308375E+00, 5.6223101338E-01, 4.7646622808E-01, 6.3506773519E-01],
	[1.38200E+04, 6.7320794763E+00, 5.8291338588E+00, 5.6288049775E-01, 4.7694663740E-01, 6.3520119123E-01],
	[1.38250E+04, 6.7354056979E+00, 5.8287370507E+00, 5.6353049706E-01, 4.7742729426E-01, 6.3533462950E-01],
	[1.38300E+04, 6.7387323594E+00, 5.8283404131E+00, 5.6418101152E-01, 4.7790819855E-01, 6.3546804996E-01],
	[1.38350E+04, 6.7420594605E+00, 5.8279439459E+00, 5.6483204136E-01, 4.7838935020E-01, 6.3560145261E-01],
	[1.38400E+04, 6.7453870012E+00, 5.8275476489E+00, 5.6548358679E-01, 4.7887074912E-01, 6.3573483742E-01],
	[1.38450E+04, 6.7487149814E+00, 5.8271515219E+00, 5.6613564805E-01, 4.7935239523E-01, 6.3586820438E-01],
	[1.38500E+04, 6.7520434010E+00, 5.8267555649E+00, 5.6678822536E-01, 4.7983428843E-01, 6.3600155347E-01],
	[1.38550E+04, 6.7553722599E+00, 5.8263597777E+00, 5.6744131893E-01, 4.8031642864E-01, 6.3613488466E-01],
	[1.38600E+04, 6.7587015579E+00, 5.8259641602E+00, 5.6809492898E-01, 4.8079881578E-01, 6.3626819795E-01],
	[1.38650E+04, 6.7620312951E+00, 5.8255687123E+00, 5.6874905574E-01, 4.8128144975E-01, 6.3640149331E-01],
	[1.38700E+04, 6.7653614712E+00, 5.8251734337E+00, 5.6940369944E-01, 4.8176433048E-01, 6.3653477072E-01],
	[1.38750E+04, 6.7686920862E+00, 5.8247783244E+00, 5.7005886028E-01, 4.8224745787E-01, 6.3666803018E-01],
	[1.38800E+04, 6.7720231400E+00, 5.8243833843E+00, 5.7071453851E-01, 4.8273083183E-01, 6.3680127165E-01],
	[1.38850E+04, 6.7753546325E+00, 5.8239886131E+00, 5.7137073432E-01, 4.8321445229E-01, 6.3693449512E-01],
	[1.38900E+04, 6.7786865636E+00, 5.8235940109E+00, 5.7202744796E-01, 4.8369831915E-01, 6.3706770057E-01],
	[1.38950E+04, 6.7820189332E+00, 5.8231995773E+00, 5.7268467964E-01, 4.8418243233E-01, 6.3720088800E-01],
	[1.39000E+04, 6.7853517411E+00, 5.8228053124E+00, 5.7334242958E-01, 4.8466679173E-01, 6.3733405736E-01],
	[1.39050E+04, 6.7886849873E+00, 5.8224112160E+00, 5.7400069800E-01, 4.8515139727E-01, 6.3746720866E-01],
	[1.39100E+04, 6.7920186717E+00, 5.8220172879E+00, 5.7465948513E-01, 4.8563624886E-01, 6.3760034187E-01],
	[1.39150E+04, 6.7953527942E+00, 5.8216235280E+00, 5.7531879119E-01, 4.8612134641E-01, 6.3773345698E-01],
	[1.39200E+04, 6.7986873547E+00, 5.8212299362E+00, 5.7597861640E-01, 4.8660668984E-01, 6.3786655395E-01],
	[1.39250E+04, 6.8020223530E+00, 5.8208365123E+00, 5.7663896098E-01, 4.8709227906E-01, 6.3799963279E-01],
	[1.39300E+04, 6.8053577891E+00, 5.8204432563E+00, 5.7729982516E-01, 4.8757811397E-01, 6.3813269347E-01],
	[1.39350E+04, 6.8086936630E+00, 5.8200501679E+00, 5.7796120916E-01, 4.8806419449E-01, 6.3826573597E-01],
	[1.39400E+04, 6.8120299744E+00, 5.8196572471E+00, 5.7862311319E-01, 4.8855052052E-01, 6.3839876028E-01],
	[1.39450E+04, 6.8153667232E+00, 5.8192644937E+00, 5.7928553749E-01, 4.8903709199E-01, 6.3853176637E-01],
	[1.39500E+04, 6.8187039095E+00, 5.8188719076E+00, 5.7994848226E-01, 4.8952390880E-01, 6.3866475424E-01],
	[1.39550E+04, 6.8220415331E+00, 5.8184794887E+00, 5.8061194775E-01, 4.9001097085E-01, 6.3879772385E-01],
	[1.39600E+04, 6.8253795938E+00, 5.8180872368E+00, 5.8127593416E-01, 4.9049827807E-01, 6.3893067520E-01],
	[1.39650E+04, 6.8287239636E+00, 5.8177020281E+00, 5.8194044173E-01, 4.9098590969E-01, 6.3906360827E-01],
	[1.39700E+04, 6.8320779227E+00, 5.8173276904E+00, 5.8260547066E-01, 4.9147391033E-01, 6.3919652304E-01],
	[1.39750E+04, 6.8354323281E+00, 5.8169535108E+00, 5.8327102119E-01, 4.9196215653E-01, 6.3932941949E-01],
	[1.39800E+04, 6.8387871796E+00, 5.8165794891E+00, 5.8393709354E-01, 4.9245064820E-01, 6.3946229761E-01],
	[1.39850E+04, 6.8421424771E+00, 5.8162056251E+00, 5.8460368792E-01, 4.9293938527E-01, 6.3959515737E-01],
	[1.39900E+04, 6.8454982206E+00, 5.8158319189E+00, 5.8527080457E-01, 4.9342836763E-01, 6.3972799876E-01],
	[1.39950E+04, 6.8488544099E+00, 5.8154583701E+00, 5.8593844370E-01, 4.9391759520E-01, 6.3986082177E-01],
	[1.40000E+04, 6.8522110449E+00, 5.8150849788E+00, 5.8660660554E-01, 4.9440706788E-01, 6.3999362637E-01],
	[1.40050E+04, 6.8555681256E+00, 5.8147117448E+00, 5.8727529030E-01, 4.9489678559E-01, 6.4012641254E-01],
	[1.40100E+04, 6.8589256517E+00, 5.8143386679E+00, 5.8794449822E-01, 4.9538674824E-01, 6.4025918028E-01],
	[1.40150E+04, 6.8622836233E+00, 5.8139657481E+00, 5.8861422951E-01, 4.9587695574E-01, 6.4039192957E-01],
	[1.40200E+04, 6.8656420403E+00, 5.8135929852E+00, 5.8928448439E-01, 4.9636740799E-01, 6.4052466037E-01],
	[1.40250E+04, 6.8690009024E+00, 5.8132203791E+00, 5.8995526310E-01, 4.9685810491E-01, 6.4065737269E-01],
	[1.40300E+04, 6.8723602097E+00, 5.8128479297E+00, 5.9062656584E-01, 4.9734904640E-01, 6.4079006650E-01],
	[1.40350E+04, 6.8757199620E+00, 5.8124756369E+00, 5.9129839285E-01, 4.9784023238E-01, 6.4092274178E-01],
	[1.40400E+04, 6.8790801592E+00, 5.8121035005E+00, 5.9197074434E-01, 4.9833166275E-01, 6.4105539853E-01],
	[1.40450E+04, 6.8824408013E+00, 5.8117315204E+00, 5.9264362054E-01, 4.9882333742E-01, 6.4118803671E-01],
	[1.40500E+04, 6.8858018881E+00, 5.8113596965E+00, 5.9331702166E-01, 4.9931525629E-01, 6.4132065631E-01],
	[1.40550E+04, 6.8891634195E+00, 5.8109880287E+00, 5.9399094795E-01, 4.9980741929E-01, 6.4145325732E-01],
	[1.40600E+04, 6.8925253955E+00, 5.8106165168E+00, 5.9466539960E-01, 5.0029982631E-01, 6.4158583972E-01],
	[1.40650E+04, 6.8958878159E+00, 5.8102451608E+00, 5.9534037686E-01, 5.0079247726E-01, 6.4171840350E-01],
	[1.40700E+04, 6.8992506806E+00, 5.8098739605E+00, 5.9601587993E-01, 5.0128537206E-01, 6.4185094863E-01],
	[1.40750E+04, 6.9026139896E+00, 5.8095029157E+00, 5.9669190905E-01, 5.0177851060E-01, 6.4198347509E-01],
	[1.40800E+04, 6.9059777426E+00, 5.8091320265E+00, 5.9736846443E-01, 5.0227189280E-01, 6.4211598288E-01],
	[1.40850E+04, 6.9093419398E+00, 5.8087612926E+00, 5.9804554630E-01, 5.0276551856E-01, 6.4224847197E-01],
	[1.40900E+04, 6.9127065808E+00, 5.8083907139E+00, 5.9872315488E-01, 5.0325938780E-01, 6.4238094235E-01],
	[1.40950E+04, 6.9160716657E+00, 5.8080202903E+00, 5.9940129039E-01, 5.0375350041E-01, 6.4251339401E-01],
	[1.41000E+04, 6.9194371944E+00, 5.8076500217E+00, 6.0007995306E-01, 5.0424785630E-01, 6.4264582691E-01],
	[1.41050E+04, 6.9228031666E+00, 5.8072799080E+00, 6.0075914311E-01, 5.0474245539E-01, 6.4277824106E-01],
	[1.41100E+04, 6.9261695824E+00, 5.8069099490E+00, 6.0143886076E-01, 5.0523729757E-01, 6.4291063642E-01],
	[1.41150E+04, 6.9295364417E+00, 5.8065401447E+00, 6.0211910623E-01, 5.0573238276E-01, 6.4304301299E-01],
	[1.41200E+04, 6.9329037443E+00, 5.8061704949E+00, 6.0279987975E-01, 5.0622771085E-01, 6.4317537074E-01],
	[1.41250E+04, 6.9362714901E+00, 5.8058009995E+00, 6.0348118153E-01, 5.0672328177E-01, 6.4330770967E-01],
	[1.41300E+04, 6.9396396791E+00, 5.8054316583E+00, 6.0416301181E-01, 5.0721909540E-01, 6.4344002975E-01],
	[1.41350E+04, 6.9430083111E+00, 5.8050624713E+00, 6.0484537080E-01, 5.0771515166E-01, 6.4357233096E-01],
	[1.41400E+04, 6.9463773861E+00, 5.8046934383E+00, 6.0552825873E-01, 5.0821145045E-01, 6.4370461330E-01],
	[1.41450E+04, 6.9497469039E+00, 5.8043245593E+00, 6.0621167582E-01, 5.0870799169E-01, 6.4383687674E-01],
	[1.41500E+04, 6.9531168645E+00, 5.8039558340E+00, 6.0689562230E-01, 5.0920477526E-01, 6.4396912127E-01],
	[1.41550E+04, 6.9564872678E+00, 5.8035872625E+00, 6.0758009837E-01, 5.0970180108E-01, 6.4410134687E-01],
	[1.41600E+04, 6.9598581135E+00, 5.8032188445E+00, 6.0826510428E-01, 5.1019906906E-01, 6.4423355353E-01],
	[1.41650E+04, 6.9632294018E+00, 5.8028505799E+00, 6.0895064024E-01, 5.1069657909E-01, 6.4436574122E-01],
	[1.41700E+04, 6.9666011324E+00, 5.8024824687E+00, 6.0963670647E-01, 5.1119433108E-01, 6.4449790994E-01],
	[1.41750E+04, 6.9699733053E+00, 5.8021145106E+00, 6.1032330320E-01, 5.1169232494E-01, 6.4463005966E-01],
	[1.41800E+04, 6.9733459203E+00, 5.8017467057E+00, 6.1101043065E-01, 5.1219056057E-01, 6.4476219034E-01],
	[1.41850E+04, 6.9767189774E+00, 5.8013790537E+00, 6.1169808904E-01, 5.1268903788E-01, 6.4489430197E-01],
	[1.41900E+04, 6.9800924764E+00, 5.8010115546E+00, 6.1238627859E-01, 5.1318775676E-01, 6.4502639452E-01],
	[1.41950E+04, 6.9834664174E+00, 5.8006442082E+00, 6.1307499954E-01, 5.1368671713E-01, 6.4515846797E-01],
	[1.42000E+04, 6.9868408001E+00, 5.8002770145E+00, 6.1376425209E-01, 5.1418591888E-01, 6.4529052230E-01],
	[1.42050E+04, 6.9902156244E+00, 5.7999099732E+00, 6.1445403648E-01, 5.1468536192E-01, 6.4542255749E-01],
	[1.42100E+04, 6.9935908904E+00, 5.7995430843E+00, 6.1514435293E-01, 5.1518504616E-01, 6.4555457352E-01],
	[1.42150E+04, 6.9969665978E+00, 5.7991763477E+00, 6.1583520165E-01, 5.1568497149E-01, 6.4568657037E-01],
	[1.42200E+04, 7.0003427466E+00, 5.7988097633E+00, 6.1652658288E-01, 5.1618513781E-01, 6.4581854802E-01],
	[1.42250E+04, 7.0037193367E+00, 5.7984433309E+00, 6.1721849684E-01, 5.1668554504E-01, 6.4595050644E-01],
	[1.42300E+04, 7.0070963680E+00, 5.7980770504E+00, 6.1791094375E-01, 5.1718619307E-01, 6.4608244561E-01],
	[1.42350E+04, 7.0104738403E+00, 5.7977109217E+00, 6.1860392382E-01, 5.1768708181E-01, 6.4621436551E-01],
	[1.42400E+04, 7.0138517537E+00, 5.7973449447E+00, 6.1929743729E-01, 5.1818821115E-01, 6.4634626613E-01],
	[1.42450E+04, 7.0172301079E+00, 5.7969791193E+00, 6.1999148438E-01, 5.1868958101E-01, 6.4647814744E-01],
	[1.42500E+04, 7.0206089030E+00, 5.7966134453E+00, 6.2068606532E-01, 5.1919119127E-01, 6.4661000942E-01],
	[1.42550E+04, 7.0239881387E+00, 5.7962479226E+00, 6.2138118031E-01, 5.1969304185E-01, 6.4674185204E-01],
	[1.42600E+04, 7.0273678150E+00, 5.7958825512E+00, 6.2207682960E-01, 5.2019513265E-01, 6.4687367530E-01],
	[1.42650E+04, 7.0307479319E+00, 5.7955173309E+00, 6.2277301339E-01, 5.2069746356E-01, 6.4700547916E-01],
	[1.42700E+04, 7.0341284891E+00, 5.7951522616E+00, 6.2346973192E-01, 5.2120003449E-01, 6.4713726361E-01],
	[1.42750E+04, 7.0375094867E+00, 5.7947873431E+00, 6.2416698540E-01, 5.2170284535E-01, 6.4726902862E-01],
	[1.42800E+04, 7.0408909245E+00, 5.7944225755E+00, 6.2486477407E-01, 5.2220589602E-01, 6.4740077418E-01],
	[1.42850E+04, 7.0442728024E+00, 5.7940579584E+00, 6.2556309813E-01, 5.2270918641E-01, 6.4753250026E-01],
	[1.42900E+04, 7.0476551203E+00, 5.7936934919E+00, 6.2626195783E-01, 5.2321271642E-01, 6.4766420685E-01],
	[1.42950E+04, 7.0510378781E+00, 5.7933291759E+00, 6.2696135337E-01, 5.2371648596E-01, 6.4779589392E-01],
	[1.43000E+04, 7.0544210758E+00, 5.7929650101E+00, 6.2766128499E-01, 5.2422049492E-01, 6.4792756145E-01],
	[1.43050E+04, 7.0578047132E+00, 5.7926009945E+00, 6.2836175290E-01, 5.2472474320E-01, 6.4805920942E-01],
	[1.43100E+04, 7.0611887902E+00, 5.7922371290E+00, 6.2906275733E-01, 5.2522923070E-01, 6.4819083782E-01],
	[1.43150E+04, 7.0645733068E+00, 5.7918734134E+00, 6.2976429851E-01, 5.2573395733E-01, 6.4832244661E-01],
	[1.43200E+04, 7.0679582628E+00, 5.7915098477E+00, 6.3046637665E-01, 5.2623892297E-01, 6.4845403578E-01],
	[1.43250E+04, 7.0713436582E+00, 5.7911464317E+00, 6.3116899198E-01, 5.2674412754E-01, 6.4858560531E-01],
	[1.43300E+04, 7.0747294928E+00, 5.7907831653E+00, 6.3187214472E-01, 5.2724957094E-01, 6.4871715518E-01],
	[1.43350E+04, 7.0781157665E+00, 5.7904200484E+00, 6.3257583510E-01, 5.2775525305E-01, 6.4884868537E-01],
	[1.43400E+04, 7.0815024793E+00, 5.7900570810E+00, 6.3328006333E-01, 5.2826117378E-01, 6.4898019586E-01],
	[1.43450E+04, 7.0848896311E+00, 5.7896942628E+00, 6.3398482965E-01, 5.2876733303E-01, 6.4911168663E-01],
	[1.43500E+04, 7.0882772217E+00, 5.7893315937E+00, 6.3469013428E-01, 5.2927373069E-01, 6.4924315765E-01],
	[1.43550E+04, 7.0916652511E+00, 5.7889690737E+00, 6.3539597743E-01, 5.2978036667E-01, 6.4937460891E-01],
	[1.43600E+04, 7.0950537192E+00, 5.7886067027E+00, 6.3610235934E-01, 5.3028724087E-01, 6.4950604038E-01],
	[1.43650E+04, 7.0984426258E+00, 5.7882444805E+00, 6.3680928022E-01, 5.3079435318E-01, 6.4963745206E-01],
	[1.43700E+04, 7.1018319709E+00, 5.7878824069E+00, 6.3751674030E-01, 5.3130170350E-01, 6.4976884391E-01],
	[1.43750E+04, 7.1052217544E+00, 5.7875204820E+00, 6.3822473981E-01, 5.3180929172E-01, 6.4990021591E-01],
	[1.43800E+04, 7.1086119762E+00, 5.7871587056E+00, 6.3893327896E-01, 5.3231711776E-01, 6.5003156805E-01],
	[1.43850E+04, 7.1120026362E+00, 5.7867970775E+00, 6.3964235798E-01, 5.3282518149E-01, 6.5016290031E-01],
	[1.43900E+04, 7.1153937343E+00, 5.7864355977E+00, 6.4035197710E-01, 5.3333348283E-01, 6.5029421266E-01],
	[1.43950E+04, 7.1187852704E+00, 5.7860742661E+00, 6.4106213653E-01, 5.3384202167E-01, 6.5042550509E-01],
	[1.44000E+04, 7.1221772443E+00, 5.7857130824E+00, 6.4177283650E-01, 5.3435079790E-01, 6.5055677757E-01],
	[1.44050E+04, 7.1255696561E+00, 5.7853520467E+00, 6.4248407724E-01, 5.3485981142E-01, 6.5068803009E-01],
	[1.44100E+04, 7.1289625056E+00, 5.7849911589E+00, 6.4319585896E-01, 5.3536906214E-01, 6.5081926262E-01],
	[1.44150E+04, 7.1323557928E+00, 5.7846304187E+00, 6.4390818189E-01, 5.3587854994E-01, 6.5095047515E-01],
	[1.44200E+04, 7.1357495174E+00, 5.7842698261E+00, 6.4462104626E-01, 5.3638827472E-01, 6.5108166766E-01],
	[1.44250E+04, 7.1391436795E+00, 5.7839093810E+00, 6.4533445229E-01, 5.3689823638E-01, 6.5121284012E-01],
	[1.44300E+04, 7.1425382789E+00, 5.7835490832E+00, 6.4604840020E-01, 5.3740843482E-01, 6.5134399252E-01],
	[1.44350E+04, 7.1459333155E+00, 5.7831889327E+00, 6.4676289021E-01, 5.3791886993E-01, 6.5147512483E-01],
	[1.44400E+04, 7.1493287893E+00, 5.7828289293E+00, 6.4747792255E-01, 5.3842954161E-01, 6.5160623704E-01],
	[1.44450E+04, 7.1527247001E+00, 5.7824690730E+00, 6.4819349745E-01, 5.3894044975E-01, 6.5173732913E-01],
	[1.44500E+04, 7.1561210479E+00, 5.7821093636E+00, 6.4890961512E-01, 5.3945159424E-01, 6.5186840107E-01],
	[1.44550E+04, 7.1595178326E+00, 5.7817498010E+00, 6.4962627579E-01, 5.3996297500E-01, 6.5199945285E-01],
	[1.44600E+04, 7.1629150540E+00, 5.7813903851E+00, 6.5034347969E-01, 5.4047459190E-01, 6.5213048445E-01],
	[1.44650E+04, 7.1663127120E+00, 5.7810311158E+00, 6.5106122703E-01, 5.4098644484E-01, 6.5226149585E-01],
	[1.44700E+04, 7.1697108067E+00, 5.7806719930E+00, 6.5177951805E-01, 5.4149853373E-01, 6.5239248702E-01],
	[1.44750E+04, 7.1731093378E+00, 5.7803130165E+00, 6.5249835295E-01, 5.4201085845E-01, 6.5252345795E-01],
	[1.44800E+04, 7.1765083053E+00, 5.7799541863E+00, 6.5321773198E-01, 5.4252341890E-01, 6.5265440863E-01],
	[1.44850E+04, 7.1799077091E+00, 5.7795955023E+00, 6.5393765535E-01, 5.4303621497E-01, 6.5278533902E-01],
	[1.44900E+04, 7.1833075490E+00, 5.7792369643E+00, 6.5465812329E-01, 5.4354924656E-01, 6.5291624911E-01],
	[1.44950E+04, 7.1867078251E+00, 5.7788785722E+00, 6.5537913601E-01, 5.4406251356E-01, 6.5304713888E-01],
	[1.45000E+04, 7.1901085372E+00, 5.7785203259E+00, 6.5610069375E-01, 5.4457601587E-01, 6.5317800832E-01],
	[1.45050E+04, 7.1935096852E+00, 5.7781622253E+00, 6.5682279673E-01, 5.4508975338E-01, 6.5330885739E-01],
	[1.45100E+04, 7.1969112690E+00, 5.7778042704E+00, 6.5754544517E-01, 5.4560372598E-01, 6.5343968609E-01],
	[1.45150E+04, 7.2003132885E+00, 5.7774464609E+00, 6.5826863929E-01, 5.4611793357E-01, 6.5357049439E-01],
	[1.45200E+04, 7.2037157750E+00, 5.7770888265E+00, 6.5899237933E-01, 5.4663237649E-01, 6.5370128228E-01],
	[1.45250E+04, 7.2071362467E+00, 5.7767479509E+00, 6.5971666549E-01, 5.4714730437E-01, 6.5383204973E-01],
	[1.45300E+04, 7.2105571644E+00, 5.7764072126E+00, 6.6044149802E-01, 5.4766246769E-01, 6.5396279672E-01],
	[1.45350E+04, 7.2139785281E+00, 5.7760666118E+00, 6.6116687712E-01, 5.4817786636E-01, 6.5409352324E-01],
	[1.45400E+04, 7.2174003376E+00, 5.7757261481E+00, 6.6189280303E-01, 5.4869350026E-01, 6.5422422927E-01],
	[1.45450E+04, 7.2208225928E+00, 5.7753858215E+00, 6.6261927597E-01, 5.4920936929E-01, 6.5435491479E-01],
	[1.45500E+04, 7.2242452937E+00, 5.7750456320E+00, 6.6334629616E-01, 5.4972547334E-01, 6.5448557977E-01],
	[1.45550E+04, 7.2276684401E+00, 5.7747055794E+00, 6.6407386383E-01, 5.5024181231E-01, 6.5461622421E-01],
	[1.45600E+04, 7.2310920320E+00, 5.7743656635E+00, 6.6480197919E-01, 5.5075838609E-01, 6.5474684807E-01],
	[1.45650E+04, 7.2345160693E+00, 5.7740258844E+00, 6.6553064249E-01, 5.5127519458E-01, 6.5487745135E-01],
	[1.45700E+04, 7.2379405518E+00, 5.7736862419E+00, 6.6625985393E-01, 5.5179223766E-01, 6.5500803401E-01],
	[1.45750E+04, 7.2413654795E+00, 5.7733467359E+00, 6.6698961374E-01, 5.5230951522E-01, 6.5513859605E-01],
	[1.45800E+04, 7.2447908523E+00, 5.7730073663E+00, 6.6771992215E-01, 5.5282702717E-01, 6.5526913745E-01],
	[1.45850E+04, 7.2482166701E+00, 5.7726681330E+00, 6.6845077939E-01, 5.5334477340E-01, 6.5539965818E-01],
	[1.45900E+04, 7.2516429328E+00, 5.7723290359E+00, 6.6918218566E-01, 5.5386275379E-01, 6.5553015823E-01],
	[1.45950E+04, 7.2550696402E+00, 5.7719900749E+00, 6.6991414121E-01, 5.5438096825E-01, 6.5566063757E-01],
	[1.46000E+04, 7.2584967924E+00, 5.7716512499E+00, 6.7064664625E-01, 5.5489941665E-01, 6.5579109620E-01],
	[1.46050E+04, 7.2619243892E+00, 5.7713125608E+00, 6.7137970100E-01, 5.5541809890E-01, 6.5592153408E-01],
	[1.46100E+04, 7.2653524305E+00, 5.7709740075E+00, 6.7211330570E-01, 5.5593701488E-01, 6.5605195121E-01],
	[1.46150E+04, 7.2687809162E+00, 5.7706355898E+00, 6.7284746056E-01, 5.5645616450E-01, 6.5618234755E-01],
	[1.46200E+04, 7.2722098462E+00, 5.7702973078E+00, 6.7358216581E-01, 5.5697554763E-01, 6.5631272311E-01],
	[1.46250E+04, 7.2756392204E+00, 5.7699591613E+00, 6.7431742168E-01, 5.5749516417E-01, 6.5644307784E-01],
	[1.46300E+04, 7.2790690388E+00, 5.7696211501E+00, 6.7505322838E-01, 5.5801501401E-01, 6.5657341175E-01],
	[1.46350E+04, 7.2824993013E+00, 5.7692832743E+00, 6.7578958615E-01, 5.5853509705E-01, 6.5670372480E-01],
	[1.46400E+04, 7.2859300076E+00, 5.7689455336E+00, 6.7652649520E-01, 5.5905541318E-01, 6.5683401698E-01],
	[1.46450E+04, 7.2893611579E+00, 5.7686079280E+00, 6.7726395577E-01, 5.5957596227E-01, 6.5696428827E-01],
	[1.46500E+04, 7.2927927518E+00, 5.7682704574E+00, 6.7800196807E-01, 5.6009674424E-01, 6.5709453865E-01],
	[1.46550E+04, 7.2962247895E+00, 5.7679331217E+00, 6.7874053232E-01, 5.6061775896E-01, 6.5722476811E-01],
	[1.46600E+04, 7.2996572707E+00, 5.7675959208E+00, 6.7947964877E-01, 5.6113900633E-01, 6.5735497662E-01],
	[1.46650E+04, 7.3030901954E+00, 5.7672588546E+00, 6.8021931761E-01, 5.6166048623E-01, 6.5748516417E-01],
	[1.46700E+04, 7.3065235634E+00, 5.7669219230E+00, 6.8095953910E-01, 5.6218219856E-01, 6.5761533074E-01],
	[1.46750E+04, 7.3099573748E+00, 5.7665851259E+00, 6.8170031343E-01, 5.6270414321E-01, 6.5774547630E-01],
	[1.46800E+04, 7.3133916294E+00, 5.7662484631E+00, 6.8244164085E-01, 5.6322632007E-01, 6.5787560085E-01],
	[1.46850E+04, 7.3168263270E+00, 5.7659119347E+00, 6.8318352158E-01, 5.6374872902E-01, 6.5800570436E-01],
	[1.46900E+04, 7.3202614677E+00, 5.7655755404E+00, 6.8392595583E-01, 5.6427136996E-01, 6.5813578682E-01],
	[1.46950E+04, 7.3236970512E+00, 5.7652392803E+00, 6.8466894384E-01, 5.6479424278E-01, 6.5826584820E-01],
	[1.47000E+04, 7.3271330776E+00, 5.7649031541E+00, 6.8541248582E-01, 5.6531734736E-01, 6.5839588849E-01],
	[1.47050E+04, 7.3305695467E+00, 5.7645671618E+00, 6.8615658201E-01, 5.6584068360E-01, 6.5852590767E-01],
	[1.47100E+04, 7.3340064585E+00, 5.7642313034E+00, 6.8690123263E-01, 5.6636425138E-01, 6.5865590572E-01],
	[1.47150E+04, 7.3374438128E+00, 5.7638955786E+00, 6.8764643789E-01, 5.6688805059E-01, 6.5878588263E-01],
	[1.47200E+04, 7.3408816095E+00, 5.7635599874E+00, 6.8839219804E-01, 5.6741208112E-01, 6.5891583837E-01],
	[1.47250E+04, 7.3443198486E+00, 5.7632245298E+00, 6.8913851328E-01, 5.6793634286E-01, 6.5904577293E-01],
	[1.47300E+04, 7.3477585299E+00, 5.7628892055E+00, 6.8988538385E-01, 5.6846083569E-01, 6.5917568629E-01],
	[1.47350E+04, 7.3511976534E+00, 5.7625540145E+00, 6.9063280996E-01, 5.6898555952E-01, 6.5930557843E-01],
	[1.47400E+04, 7.3546372190E+00, 5.7622189568E+00, 6.9138079186E-01, 5.6951051421E-01, 6.5943544934E-01],
	[1.47450E+04, 7.3580772265E+00, 5.7618840321E+00, 6.9212932975E-01, 5.7003569967E-01, 6.5956529898E-01],
	[1.47500E+04, 7.3615176760E+00, 5.7615492405E+00, 6.9287842386E-01, 5.7056111577E-01, 6.5969512736E-01],
	[1.47550E+04, 7.3649585672E+00, 5.7612145818E+00, 6.9362807442E-01, 5.7108676242E-01, 6.5982493445E-01],
	[1.47600E+04, 7.3683999001E+00, 5.7608800558E+00, 6.9437828165E-01, 5.7161263948E-01, 6.5995472022E-01],
	[1.47650E+04, 7.3718416746E+00, 5.7605456626E+00, 6.9512904578E-01, 5.7213874686E-01, 6.6008448468E-01],
	[1.47700E+04, 7.3752838907E+00, 5.7602114021E+00, 6.9588036704E-01, 5.7266508444E-01, 6.6021422778E-01],
	[1.47750E+04, 7.3787265482E+00, 5.7598772740E+00, 6.9663224563E-01, 5.7319165210E-01, 6.6034394953E-01],
	[1.47800E+04, 7.3821696470E+00, 5.7595432784E+00, 6.9738468180E-01, 5.7371844973E-01, 6.6047364989E-01],
	[1.47850E+04, 7.3856131870E+00, 5.7592094151E+00, 6.9813767576E-01, 5.7424547723E-01, 6.6060332886E-01],
	[1.47900E+04, 7.3890571682E+00, 5.7588756840E+00, 6.9889122775E-01, 5.7477273447E-01, 6.6073298641E-01],
	[1.47950E+04, 7.3925015904E+00, 5.7585420851E+00, 6.9964533797E-01, 5.7530022134E-01, 6.6086262253E-01],
	[1.48000E+04, 7.3959464536E+00, 5.7582086182E+00, 7.0040000667E-01, 5.7582793773E-01, 6.6099223720E-01],
	[1.48050E+04, 7.3993917576E+00, 5.7578752832E+00, 7.0115523406E-01, 5.7635588352E-01, 6.6112183040E-01],
	[1.48100E+04, 7.4028375024E+00, 5.7575420801E+00, 7.0191102037E-01, 5.7688405861E-01, 6.6125140212E-01],
	[1.48150E+04, 7.4062836879E+00, 5.7572090087E+00, 7.0266736582E-01, 5.7741246287E-01, 6.6138095233E-01],
	[1.48200E+04, 7.4097303140E+00, 5.7568760690E+00, 7.0342427065E-01, 5.7794109619E-01, 6.6151048102E-01],
	[1.48250E+04, 7.4131773806E+00, 5.7565432608E+00, 7.0418173506E-01, 5.7846995846E-01, 6.6163998817E-01],
	[1.48300E+04, 7.4166248876E+00, 5.7562105841E+00, 7.0493975929E-01, 5.7899904956E-01, 6.6176947377E-01],
	[1.48350E+04, 7.4200728348E+00, 5.7558780388E+00, 7.0569834357E-01, 5.7952836939E-01, 6.6189893779E-01],
	[1.48400E+04, 7.4235212223E+00, 5.7555456247E+00, 7.0645748811E-01, 5.8005791781E-01, 6.6202838022E-01],
	[1.48450E+04, 7.4269700500E+00, 5.7552133418E+00, 7.0721719314E-01, 5.8058769472E-01, 6.6215780104E-01],
	[1.48500E+04, 7.4304193177E+00, 5.7548811899E+00, 7.0797745889E-01, 5.8111770001E-01, 6.6228720024E-01],
	[1.48550E+04, 7.4338690253E+00, 5.7545491690E+00, 7.0873828559E-01, 5.8164793355E-01, 6.6241657779E-01],
	[1.48600E+04, 7.4373191727E+00, 5.7542172790E+00, 7.0949967344E-01, 5.8217839523E-01, 6.6254593369E-01],
	[1.48650E+04, 7.4407697599E+00, 5.7538855198E+00, 7.1026162270E-01, 5.8270908494E-01, 6.6267526790E-01],
	[1.48700E+04, 7.4442207868E+00, 5.7535538913E+00, 7.1102413356E-01, 5.8324000257E-01, 6.6280458041E-01],
	[1.48750E+04, 7.4476722533E+00, 5.7532223934E+00, 7.1178720627E-01, 5.8377114798E-01, 6.6293387119E-01],
	[1.48800E+04, 7.4511241592E+00, 5.7528910260E+00, 7.1255084105E-01, 5.8430252108E-01, 6.6306314022E-01],
	[1.48850E+04, 7.4545765045E+00, 5.7525597890E+00, 7.1331503811E-01, 5.8483412173E-01, 6.6319238748E-01],
	[1.48900E+04, 7.4580292892E+00, 5.7522286823E+00, 7.1407979769E-01, 5.8536594984E-01, 6.6332161295E-01],
	[1.48950E+04, 7.4614825130E+00, 5.7518977058E+00, 7.1484512002E-01, 5.8589800527E-01, 6.6345081661E-01],
	[1.49000E+04, 7.4649361760E+00, 5.7515668594E+00, 7.1561100531E-01, 5.8643028792E-01, 6.6357999843E-01],
	[1.49050E+04, 7.4683902779E+00, 5.7512361430E+00, 7.1637745379E-01, 5.8696279766E-01, 6.6370915841E-01],
	[1.49100E+04, 7.4718448188E+00, 5.7509055566E+00, 7.1714446568E-01, 5.8749553438E-01, 6.6383829651E-01],
	[1.49150E+04, 7.4752997986E+00, 5.7505751000E+00, 7.1791204122E-01, 5.8802849796E-01, 6.6396741271E-01],
	[1.49200E+04, 7.4787552171E+00, 5.7502447732E+00, 7.1868018062E-01, 5.8856168829E-01, 6.6409650700E-01],
	[1.49250E+04, 7.4822110743E+00, 5.7499145760E+00, 7.1944888412E-01, 5.8909510524E-01, 6.6422557936E-01],
	[1.49300E+04, 7.4856673700E+00, 5.7495845083E+00, 7.2021815193E-01, 5.8962874871E-01, 6.6435462976E-01],
	[1.49350E+04, 7.4891241042E+00, 5.7492545701E+00, 7.2098798428E-01, 5.9016261857E-01, 6.6448365819E-01],
	[1.49400E+04, 7.4925812768E+00, 5.7489247613E+00, 7.2175838140E-01, 5.9069671470E-01, 6.6461266462E-01],
	[1.49450E+04, 7.4960388876E+00, 5.7485950818E+00, 7.2252934351E-01, 5.9123103698E-01, 6.6474164903E-01],
	[1.49500E+04, 7.4994969367E+00, 5.7482655314E+00, 7.2330087084E-01, 5.9176558531E-01, 6.6487061140E-01],
	[1.49550E+04, 7.5029554239E+00, 5.7479361101E+00, 7.2407296361E-01, 5.9230035956E-01, 6.6499955172E-01],
	[1.49600E+04, 7.5064143491E+00, 5.7476068178E+00, 7.2484562204E-01, 5.9283535961E-01, 6.6512846996E-01],
	[1.49650E+04, 7.5098737123E+00, 5.7472776543E+00, 7.2561884637E-01, 5.9337058534E-01, 6.6525736611E-01],
	[1.49700E+04, 7.5133335132E+00, 5.7469486197E+00, 7.2639263681E-01, 5.9390603663E-01, 6.6538624013E-01],
	[1.49750E+04, 7.5167937520E+00, 5.7466197138E+00, 7.2716699360E-01, 5.9444171338E-01, 6.6551509202E-01],
	[1.49800E+04, 7.5202544284E+00, 5.7462909365E+00, 7.2794191696E-01, 5.9497761545E-01, 6.6564392175E-01],
	[1.49850E+04, 7.5237155423E+00, 5.7459622877E+00, 7.2871740710E-01, 5.9551374272E-01, 6.6577272930E-01],
	[1.49900E+04, 7.5271770937E+00, 5.7456337674E+00, 7.2949346427E-01, 5.9605009509E-01, 6.6590151465E-01],
	[1.49950E+04, 7.5306390826E+00, 5.7453053754E+00, 7.3027008868E-01, 5.9658667242E-01, 6.6603027779E-01],
	[1.50000E+04, 7.5341015087E+00, 5.7449771116E+00, 7.3104728056E-01, 5.9712347461E-01, 6.6615901868E-01],
	[1.50050E+04, 7.5375643720E+00, 5.7446489760E+00, 7.3182673951E-01, 5.9766163492E-01, 6.6628773732E-01],
	[1.50100E+04, 7.5410276724E+00, 5.7443209684E+00, 7.3260676942E-01, 5.9820002114E-01, 6.6641643368E-01],
	[1.50150E+04, 7.5444914098E+00, 5.7439930888E+00, 7.3338737054E-01, 5.9873863313E-01, 6.6654510774E-01],
	[1.50200E+04, 7.5479555842E+00, 5.7436653371E+00, 7.3416854309E-01, 5.9927747078E-01, 6.6667375948E-01],
	[1.50250E+04, 7.5514201954E+00, 5.7433377132E+00, 7.3495028729E-01, 5.9981653397E-01, 6.6680238888E-01],
	[1.50300E+04, 7.5548852434E+00, 5.7430102169E+00, 7.3573260337E-01, 6.0035582257E-01, 6.6693099593E-01],
	[1.50350E+04, 7.5583507280E+00, 5.7426828482E+00, 7.3651549156E-01, 6.0089533647E-01, 6.6705958060E-01],
	[1.50400E+04, 7.5618166492E+00, 5.7423556071E+00, 7.3729895209E-01, 6.0143507554E-01, 6.6718814287E-01],
	[1.50450E+04, 7.5652830069E+00, 5.7420284933E+00, 7.3808298519E-01, 6.0197503967E-01, 6.6731668273E-01],
	[1.50500E+04, 7.5687498010E+00, 5.7417015069E+00, 7.3886759108E-01, 6.0251522873E-01, 6.6744520014E-01],
	[1.50550E+04, 7.5722170314E+00, 5.7413746477E+00, 7.3965277000E-01, 6.0305564259E-01, 6.6757369510E-01],
	[1.50600E+04, 7.5756846980E+00, 5.7410479156E+00, 7.4043852216E-01, 6.0359628115E-01, 6.6770216759E-01],
	[1.50650E+04, 7.5791528007E+00, 5.7407213106E+00, 7.4122484780E-01, 6.0413714427E-01, 6.6783061758E-01],
	[1.50700E+04, 7.5826213394E+00, 5.7403948325E+00, 7.4201174715E-01, 6.0467823183E-01, 6.6795904505E-01],
	[1.50750E+04, 7.5860903141E+00, 5.7400684813E+00, 7.4279922043E-01, 6.0521954372E-01, 6.6808744999E-01],
	[1.50800E+04, 7.5895597246E+00, 5.7397422568E+00, 7.4358726788E-01, 6.0576107980E-01, 6.6821583238E-01],
	[1.50850E+04, 7.5930295709E+00, 5.7394161590E+00, 7.4437588971E-01, 6.0630283997E-01, 6.6834419219E-01],
	[1.50900E+04, 7.5964998529E+00, 5.7390901879E+00, 7.4516508617E-01, 6.0684482409E-01, 6.6847252940E-01],
	[1.50950E+04, 7.5999705704E+00, 5.7387643432E+00, 7.4595485747E-01, 6.0738703204E-01, 6.6860084401E-01],
	[1.51000E+04, 7.6034451770E+00, 5.7384413047E+00, 7.4674520384E-01, 6.0792951585E-01, 6.6872913598E-01],
	[1.51050E+04, 7.6069371388E+00, 5.7381315121E+00, 7.4753612552E-01, 6.0847247918E-01, 6.6885740530E-01],
	[1.51100E+04, 7.6104295479E+00, 5.7378218387E+00, 7.4832762273E-01, 6.0901566688E-01, 6.6898565195E-01],
	[1.51150E+04, 7.6139224040E+00, 5.7375122845E+00, 7.4911969569E-01, 6.0955907881E-01, 6.6911387591E-01],
	[1.51200E+04, 7.6174157073E+00, 5.7372028494E+00, 7.4991234465E-01, 6.1010271486E-01, 6.6924207717E-01],
	[1.51250E+04, 7.6209094574E+00, 5.7368935332E+00, 7.5070556982E-01, 6.1064657491E-01, 6.6937025569E-01],
	[1.51300E+04, 7.6244036545E+00, 5.7365843360E+00, 7.5149937143E-01, 6.1119065883E-01, 6.6949841146E-01],
	[1.51350E+04, 7.6278982982E+00, 5.7362752576E+00, 7.5229374971E-01, 6.1173496650E-01, 6.6962654447E-01],
	[1.51400E+04, 7.6313933887E+00, 5.7359662979E+00, 7.5308870490E-01, 6.1227949780E-01, 6.6975465469E-01],
	[1.51450E+04, 7.6348889258E+00, 5.7356574569E+00, 7.5388423721E-01, 6.1282425260E-01, 6.6988274211E-01],
	[1.51500E+04, 7.6383849093E+00, 5.7353487344E+00, 7.5468034688E-01, 6.1336923078E-01, 6.7001080670E-01],
	[1.51550E+04, 7.6418813393E+00, 5.7350401304E+00, 7.5547703413E-01, 6.1391443222E-01, 6.7013884845E-01],
	[1.51600E+04, 7.6453782155E+00, 5.7347316448E+00, 7.5627429920E-01, 6.1445985680E-01, 6.7026686734E-01],
	[1.51650E+04, 7.6488755380E+00, 5.7344232775E+00, 7.5707214230E-01, 6.1500550439E-01, 6.7039486335E-01],
	[1.51700E+04, 7.6523733066E+00, 5.7341150285E+00, 7.5787056368E-01, 6.1555137487E-01, 6.7052283646E-01],
	[1.51750E+04, 7.6558715213E+00, 5.7338068976E+00, 7.5866956356E-01, 6.1609746812E-01, 6.7065078664E-01],
	[1.51800E+04, 7.6593701819E+00, 5.7334988847E+00, 7.5946914216E-01, 6.1664378401E-01, 6.7077871389E-01],
	[1.51850E+04, 7.6628692884E+00, 5.7331909898E+00, 7.6026929971E-01, 6.1719032241E-01, 6.7090661818E-01],
	[1.51900E+04, 7.6663688407E+00, 5.7328832129E+00, 7.6107003645E-01, 6.1773708321E-01, 6.7103449950E-01],
	[1.51950E+04, 7.6698688386E+00, 5.7325755537E+00, 7.6187135260E-01, 6.1828406628E-01, 6.7116235782E-01],
	[1.52000E+04, 7.6733692821E+00, 5.7322680122E+00, 7.6267324839E-01, 6.1883127149E-01, 6.7129019313E-01],
	[1.52050E+04, 7.6768701712E+00, 5.7319605884E+00, 7.6347572404E-01, 6.1937869873E-01, 6.7141800541E-01],
	[1.52100E+04, 7.6803715056E+00, 5.7316532822E+00, 7.6427877980E-01, 6.1992634786E-01, 6.7154579464E-01],
	[1.52150E+04, 7.6838732854E+00, 5.7313460934E+00, 7.6508241587E-01, 6.2047421876E-01, 6.7167356080E-01],
	[1.52200E+04, 7.6873755104E+00, 5.7310390220E+00, 7.6588663251E-01, 6.2102231131E-01, 6.7180130386E-01],
	[1.52250E+04, 7.6908781805E+00, 5.7307320679E+00, 7.6669142992E-01, 6.2157062538E-01, 6.7192902383E-01],
	[1.52300E+04, 7.6943812957E+00, 5.7304252310E+00, 7.6749680834E-01, 6.2211916084E-01, 6.7205672067E-01],
	[1.52350E+04, 7.6978848559E+00, 5.7301185113E+00, 7.6830276800E-01, 6.2266791758E-01, 6.7218439436E-01],
	[1.52400E+04, 7.7013888609E+00, 5.7298119086E+00, 7.6910930913E-01, 6.2321689547E-01, 6.7231204489E-01],
	[1.52450E+04, 7.7048933108E+00, 5.7295054229E+00, 7.6991643196E-01, 6.2376609437E-01, 6.7243967224E-01],
	[1.52500E+04, 7.7083982053E+00, 5.7291990541E+00, 7.7072413671E-01, 6.2431551417E-01, 6.7256727640E-01],
	[1.52550E+04, 7.7119035444E+00, 5.7288928021E+00, 7.7153242361E-01, 6.2486515474E-01, 6.7269485733E-01],
	[1.52600E+04, 7.7154093281E+00, 5.7285866668E+00, 7.7234129290E-01, 6.2541501595E-01, 6.7282241503E-01],
	[1.52650E+04, 7.7189155562E+00, 5.7282806481E+00, 7.7315074479E-01, 6.2596509768E-01, 6.7294994948E-01],
	[1.52700E+04, 7.7224222286E+00, 5.7279747460E+00, 7.7396077952E-01, 6.2651539980E-01, 6.7307746065E-01],
	[1.52750E+04, 7.7259293453E+00, 5.7276689604E+00, 7.7477139732E-01, 6.2706592218E-01, 6.7320494853E-01],
	[1.52800E+04, 7.7294369061E+00, 5.7273632912E+00, 7.7558259842E-01, 6.2761666470E-01, 6.7333241310E-01],
	[1.52850E+04, 7.7329449110E+00, 5.7270577383E+00, 7.7639438304E-01, 6.2816762724E-01, 6.7345985435E-01],
	[1.52900E+04, 7.7364533599E+00, 5.7267523016E+00, 7.7720675142E-01, 6.2871880965E-01, 6.7358727225E-01],
	[1.52950E+04, 7.7399622527E+00, 5.7264469811E+00, 7.7801970377E-01, 6.2927021183E-01, 6.7371466678E-01],
	[1.53000E+04, 7.7434715892E+00, 5.7261417766E+00, 7.7883324034E-01, 6.2982183363E-01, 6.7384203794E-01],
	[1.53050E+04, 7.7469813695E+00, 5.7258366881E+00, 7.7964736134E-01, 6.3037367494E-01, 6.7396938569E-01],
	[1.53100E+04, 7.7504915935E+00, 5.7255317156E+00, 7.8046206702E-01, 6.3092573563E-01, 6.7409671003E-01],
	[1.53150E+04, 7.7540022609E+00, 5.7252268588E+00, 7.8127735759E-01, 6.3147801556E-01, 6.7422401093E-01],
	[1.53200E+04, 7.7575133718E+00, 5.7249221178E+00, 7.8209323329E-01, 6.3203051462E-01, 6.7435128837E-01],
	[1.53250E+04, 7.7610249261E+00, 5.7246174924E+00, 7.8290969434E-01, 6.3258323267E-01, 6.7447854234E-01],
	[1.53300E+04, 7.7645369237E+00, 5.7243129826E+00, 7.8372674097E-01, 6.3313616958E-01, 6.7460577283E-01],
	[1.53350E+04, 7.7680493644E+00, 5.7240085883E+00, 7.8454437342E-01, 6.3368932524E-01, 6.7473297980E-01],
	[1.53400E+04, 7.7715622482E+00, 5.7237043094E+00, 7.8536259190E-01, 6.3424269950E-01, 6.7486016325E-01],
	[1.53450E+04, 7.7750755750E+00, 5.7234001458E+00, 7.8618139666E-01, 6.3479629224E-01, 6.7498732316E-01],
	[1.53500E+04, 7.7785893448E+00, 5.7230960975E+00, 7.8700078791E-01, 6.3535010334E-01, 6.7511445950E-01],
	[1.53550E+04, 7.7821035574E+00, 5.7227921643E+00, 7.8782076589E-01, 6.3590413266E-01, 6.7524157226E-01],
	[1.53600E+04, 7.7856182127E+00, 5.7224883463E+00, 7.8864133083E-01, 6.3645838008E-01, 6.7536866143E-01],
	[1.53650E+04, 7.7891333107E+00, 5.7221846432E+00, 7.8946248295E-01, 6.3701284547E-01, 6.7549572698E-01],
	[1.53700E+04, 7.7926488512E+00, 5.7218810551E+00, 7.9028422249E-01, 6.3756752869E-01, 6.7562276890E-01],
	[1.53750E+04, 7.7961648342E+00, 5.7215775818E+00, 7.9110654967E-01, 6.3812242962E-01, 6.7574978717E-01],
	[1.53800E+04, 7.7996812596E+00, 5.7212742232E+00, 7.9192946472E-01, 6.3867754813E-01, 6.7587678177E-01],
	[1.53850E+04, 7.8031981273E+00, 5.7209709794E+00, 7.9275296787E-01, 6.3923288410E-01, 6.7600375268E-01],
	[1.53900E+04, 7.8067154372E+00, 5.7206678501E+00, 7.9357705935E-01, 6.3978843738E-01, 6.7613069990E-01],
	[1.53950E+04, 7.8102331892E+00, 5.7203648354E+00, 7.9440173939E-01, 6.4034420786E-01, 6.7625762339E-01],
	[1.54000E+04, 7.8137513833E+00, 5.7200619351E+00, 7.9522700822E-01, 6.4090019540E-01, 6.7638452314E-01],
	[1.54050E+04, 7.8172700193E+00, 5.7197591492E+00, 7.9605286606E-01, 6.4145639987E-01, 6.7651139913E-01],
	[1.54100E+04, 7.8207890972E+00, 5.7194564775E+00, 7.9687931315E-01, 6.4201282115E-01, 6.7663825136E-01],
	[1.54150E+04, 7.8243086168E+00, 5.7191539200E+00, 7.9770634972E-01, 6.4256945909E-01, 6.7676507979E-01],
	[1.54200E+04, 7.8278285781E+00, 5.7188514767E+00, 7.9853397598E-01, 6.4312631358E-01, 6.7689188441E-01],
	[1.54250E+04, 7.8313489811E+00, 5.7185491474E+00, 7.9936219218E-01, 6.4368338448E-01, 6.7701866521E-01],
	[1.54300E+04, 7.8348698255E+00, 5.7182469321E+00, 8.0019099855E-01, 6.4424067166E-01, 6.7714542216E-01],
	[1.54350E+04, 7.8383911113E+00, 5.7179448306E+00, 8.0102039530E-01, 6.4479817500E-01, 6.7727215526E-01],
	[1.54400E+04, 7.8419128385E+00, 5.7176428429E+00, 8.0185038267E-01, 6.4535589435E-01, 6.7739886447E-01],
	[1.54450E+04, 7.8454350069E+00, 5.7173409690E+00, 8.0268096089E-01, 6.4591382959E-01, 6.7752554980E-01],
	[1.54500E+04, 7.8489576165E+00, 5.7170392087E+00, 8.0351213019E-01, 6.4647198059E-01, 6.7765221121E-01],
	[1.54550E+04, 7.8524806672E+00, 5.7167375620E+00, 8.0434389080E-01, 6.4703034722E-01, 6.7777884869E-01],
	[1.54600E+04, 7.8560041588E+00, 5.7164360287E+00, 8.0517624294E-01, 6.4758892934E-01, 6.7790546222E-01],
	[1.54650E+04, 7.8595280913E+00, 5.7161346088E+00, 8.0600918685E-01, 6.4814772683E-01, 6.7803205179E-01],
	[1.54700E+04, 7.8630524647E+00, 5.7158333023E+00, 8.0684272276E-01, 6.4870673955E-01, 6.7815861738E-01],
	[1.54750E+04, 7.8665772787E+00, 5.7155321090E+00, 8.0767685089E-01, 6.4926596737E-01, 6.7828515897E-01],
	[1.54800E+04, 7.8701025334E+00, 5.7152310289E+00, 8.0851157147E-01, 6.4982541016E-01, 6.7841167655E-01],
	[1.54850E+04, 7.8736282287E+00, 5.7149300618E+00, 8.0934688473E-01, 6.5038506779E-01, 6.7853817009E-01],
	[1.54900E+04, 7.8771543643E+00, 5.7146292078E+00, 8.1018279091E-01, 6.5094494012E-01, 6.7866463959E-01],
	[1.54950E+04, 7.8806809404E+00, 5.7143284667E+00, 8.1101929022E-01, 6.5150502703E-01, 6.7879108502E-01],
	[1.55000E+04, 7.8842079568E+00, 5.7140278384E+00, 8.1185638291E-01, 6.5206532838E-01, 6.7891750636E-01],
	[1.55050E+04, 7.8877354133E+00, 5.7137273229E+00, 8.1269406920E-01, 6.5262584404E-01, 6.7904390361E-01],
	[1.55100E+04, 7.8912633099E+00, 5.7134269201E+00, 8.1353234932E-01, 6.5318657387E-01, 6.7917027674E-01],
	[1.55150E+04, 7.8947916466E+00, 5.7131266299E+00, 8.1437122349E-01, 6.5374751774E-01, 6.7929662574E-01],
	[1.55200E+04, 7.8983204232E+00, 5.7128264523E+00, 8.1521069195E-01, 6.5430867553E-01, 6.7942295058E-01],
	[1.55250E+04, 7.9018496397E+00, 5.7125263871E+00, 8.1605075493E-01, 6.5487004710E-01, 6.7954925126E-01],
	[1.55300E+04, 7.9053792959E+00, 5.7122264342E+00, 8.1689141266E-01, 6.5543163231E-01, 6.7967552780E-01],
	[1.55350E+04, 7.9089093918E+00, 5.7119265937E+00, 8.1773266536E-01, 6.5599343103E-01, 6.7980178019E-01],
	[1.55400E+04, 7.9124399273E+00, 5.7116268654E+00, 8.1857451326E-01, 6.5655544312E-01, 6.7992800842E-01],
	[1.55450E+04, 7.9159709023E+00, 5.7113272492E+00, 8.1941695660E-01, 6.5711766847E-01, 6.8005421246E-01],
	[1.55500E+04, 7.9195023167E+00, 5.7110277451E+00, 8.2025999561E-01, 6.5768010692E-01, 6.8018039230E-01],
	[1.55550E+04, 7.9230341704E+00, 5.7107283530E+00, 8.2110363050E-01, 6.5824275835E-01, 6.8030654791E-01],
	[1.55600E+04, 7.9265664634E+00, 5.7104290728E+00, 8.2194786152E-01, 6.5880562263E-01, 6.8043267927E-01],
	[1.55650E+04, 7.9300991955E+00, 5.7101299045E+00, 8.2279268890E-01, 6.5936869961E-01, 6.8055878636E-01],
	[1.55700E+04, 7.9336323667E+00, 5.7098308478E+00, 8.2363811285E-01, 6.5993198917E-01, 6.8068486917E-01],
	[1.55750E+04, 7.9371659769E+00, 5.7095319029E+00, 8.2448413362E-01, 6.6049549117E-01, 6.8081092767E-01],
	[1.55800E+04, 7.9407000259E+00, 5.7092330696E+00, 8.2533075142E-01, 6.6105920548E-01, 6.8093696184E-01],
	[1.55850E+04, 7.9442345138E+00, 5.7089343477E+00, 8.2617796650E-01, 6.6162313196E-01, 6.8106297166E-01],
	[1.55900E+04, 7.9477694404E+00, 5.7086357373E+00, 8.2702577908E-01, 6.6218727048E-01, 6.8118895711E-01],
	[1.55950E+04, 7.9513048057E+00, 5.7083372383E+00, 8.2787418938E-01, 6.6275162090E-01, 6.8131491818E-01],
	[1.56000E+04, 7.9548406095E+00, 5.7080388506E+00, 8.2872319765E-01, 6.6331618309E-01, 6.8144085483E-01],
	[1.56050E+04, 7.9583768517E+00, 5.7077405741E+00, 8.2957280410E-01, 6.6388095692E-01, 6.8156676706E-01],
	[1.56100E+04, 7.9619135324E+00, 5.7074424087E+00, 8.3042300897E-01, 6.6444594224E-01, 6.8169265484E-01],
	[1.56150E+04, 7.9654506513E+00, 5.7071443544E+00, 8.3127381249E-01, 6.6501113892E-01, 6.8181851815E-01],
	[1.56200E+04, 7.9689882084E+00, 5.7068464110E+00, 8.3212521489E-01, 6.6557654683E-01, 6.8194435697E-01],
	[1.56250E+04, 7.9725262037E+00, 5.7065485786E+00, 8.3297721639E-01, 6.6614216584E-01, 6.8207017129E-01],
	[1.56300E+04, 7.9760646370E+00, 5.7062508570E+00, 8.3382981723E-01, 6.6670799580E-01, 6.8219596107E-01],
	[1.56350E+04, 7.9796035082E+00, 5.7059532461E+00, 8.3468301764E-01, 6.6727403658E-01, 6.8232172631E-01],
	[1.56400E+04, 7.9831428173E+00, 5.7056557460E+00, 8.3553681784E-01, 6.6784028805E-01, 6.8244746698E-01],
	[1.56450E+04, 7.9866825642E+00, 5.7053583564E+00, 8.3639121807E-01, 6.6840675006E-01, 6.8257318306E-01],
	[1.56500E+04, 7.9902227487E+00, 5.7050610773E+00, 8.3724621856E-01, 6.6897342249E-01, 6.8269887453E-01],
	[1.56550E+04, 7.9937633709E+00, 5.7047639087E+00, 8.3810181953E-01, 6.6954030520E-01, 6.8282454138E-01],
	[1.56600E+04, 7.9973044306E+00, 5.7044668504E+00, 8.3895802121E-01, 6.7010739804E-01, 6.8295018358E-01],
	[1.56650E+04, 8.0008459277E+00, 5.7041699025E+00, 8.3981482384E-01, 6.7067470089E-01, 6.8307580111E-01],
	[1.56700E+04, 8.0043878622E+00, 5.7038730647E+00, 8.4067222764E-01, 6.7124221361E-01, 6.8320139395E-01],
	[1.56750E+04, 8.0079302339E+00, 5.7035763371E+00, 8.4153023285E-01, 6.7180993606E-01, 6.8332696209E-01],
	[1.56800E+04, 8.0114730428E+00, 5.7032797196E+00, 8.4238883969E-01, 6.7237786810E-01, 6.8345250551E-01],
	[1.56850E+04, 8.0150162888E+00, 5.7029832120E+00, 8.4324804840E-01, 6.7294600960E-01, 6.8357802418E-01],
	[1.56900E+04, 8.0185599718E+00, 5.7026868144E+00, 8.4410785920E-01, 6.7351436042E-01, 6.8370351809E-01],
	[1.56950E+04, 8.0221040918E+00, 5.7023905266E+00, 8.4496827232E-01, 6.7408292042E-01, 6.8382898721E-01],
	[1.57000E+04, 8.0256486485E+00, 5.7020943485E+00, 8.4582928800E-01, 6.7465168946E-01, 6.8395443153E-01],
	[1.57050E+04, 8.0292105843E+00, 5.7018091147E+00, 8.4669090646E-01, 6.7522093918E-01, 6.8407985102E-01],
	[1.57100E+04, 8.0327796509E+00, 5.7015282586E+00, 8.4755312793E-01, 6.7579050574E-01, 6.8420524568E-01],
	[1.57150E+04, 8.0363491674E+00, 5.7012475056E+00, 8.4841595265E-01, 6.7636028196E-01, 6.8433061547E-01],
	[1.57200E+04, 8.0399191338E+00, 5.7009668558E+00, 8.4927938083E-01, 6.7693026771E-01, 6.8445596039E-01],
	[1.57250E+04, 8.0434895501E+00, 5.7006863091E+00, 8.5014341273E-01, 6.7750046286E-01, 6.8458128040E-01],
	[1.57300E+04, 8.0470604160E+00, 5.7004058653E+00, 8.5100804855E-01, 6.7807086725E-01, 6.8470657549E-01],
	[1.57350E+04, 8.0506317317E+00, 5.7001255244E+00, 8.5187328854E-01, 6.7864148077E-01, 6.8483184565E-01],
	[1.57400E+04, 8.0542034968E+00, 5.6998452864E+00, 8.5273913292E-01, 6.7921230327E-01, 6.8495709085E-01],
	[1.57450E+04, 8.0577757115E+00, 5.6995651512E+00, 8.5360558192E-01, 6.7978333461E-01, 6.8508231107E-01],
	[1.57500E+04, 8.0613483755E+00, 5.6992851187E+00, 8.5447263578E-01, 6.8035457466E-01, 6.8520750630E-01],
	[1.57550E+04, 8.0649214888E+00, 5.6990051888E+00, 8.5534029472E-01, 6.8092602328E-01, 6.8533267651E-01],
	[1.57600E+04, 8.0684950513E+00, 5.6987253615E+00, 8.5620855897E-01, 6.8149768033E-01, 6.8545782169E-01],
	[1.57650E+04, 8.0720690630E+00, 5.6984456367E+00, 8.5707742876E-01, 6.8206954568E-01, 6.8558294182E-01],
	[1.57700E+04, 8.0756435237E+00, 5.6981660143E+00, 8.5794690433E-01, 6.8264161919E-01, 6.8570803688E-01],
	[1.57750E+04, 8.0792184333E+00, 5.6978864943E+00, 8.5881698590E-01, 6.8321390071E-01, 6.8583310684E-01],
	[1.57800E+04, 8.0827937919E+00, 5.6976070765E+00, 8.5968767371E-01, 6.8378639011E-01, 6.8595815170E-01],
	[1.57850E+04, 8.0863695992E+00, 5.6973277610E+00, 8.6055896797E-01, 6.8435908726E-01, 6.8608317143E-01],
	[1.57900E+04, 8.0899458552E+00, 5.6970485476E+00, 8.6143086893E-01, 6.8493199202E-01, 6.8620816601E-01],
	[1.57950E+04, 8.0935225598E+00, 5.6967694363E+00, 8.6230337682E-01, 6.8550510424E-01, 6.8633313543E-01],
	[1.58000E+04, 8.0970997129E+00, 5.6964904270E+00, 8.6317649185E-01, 6.8607842379E-01, 6.8645807966E-01],
	[1.58050E+04, 8.1006773145E+00, 5.6962115197E+00, 8.6405021428E-01, 6.8665195053E-01, 6.8658299869E-01],
	[1.58100E+04, 8.1042553644E+00, 5.6959327142E+00, 8.6492454431E-01, 6.8722568432E-01, 6.8670789250E-01],
	[1.58150E+04, 8.1078338626E+00, 5.6956540105E+00, 8.6579948219E-01, 6.8779962502E-01, 6.8683276107E-01],
	[1.58200E+04, 8.1114128090E+00, 5.6953754085E+00, 8.6667502814E-01, 6.8837377250E-01, 6.8695760438E-01],
	[1.58250E+04, 8.1149922034E+00, 5.6950969082E+00, 8.6755118240E-01, 6.8894812661E-01, 6.8708242241E-01],
	[1.58300E+04, 8.1185720459E+00, 5.6948185095E+00, 8.6842794520E-01, 6.8952268722E-01, 6.8720721514E-01],
	[1.58350E+04, 8.1221523363E+00, 5.6945402124E+00, 8.6930531675E-01, 6.9009745419E-01, 6.8733198256E-01],
	[1.58400E+04, 8.1257330746E+00, 5.6942620166E+00, 8.7018329731E-01, 6.9067242737E-01, 6.8745672465E-01],
	[1.58450E+04, 8.1293142606E+00, 5.6939839223E+00, 8.7106188709E-01, 6.9124760663E-01, 6.8758144139E-01],
	[1.58500E+04, 8.1328958942E+00, 5.6937059293E+00, 8.7194108632E-01, 6.9182299183E-01, 6.8770613276E-01],
	[1.58550E+04, 8.1364779755E+00, 5.6934280375E+00, 8.7282089524E-01, 6.9239858282E-01, 6.8783079873E-01],
	[1.58600E+04, 8.1400605042E+00, 5.6931502469E+00, 8.7370131408E-01, 6.9297437948E-01, 6.8795543931E-01],
	[1.58650E+04, 8.1436434804E+00, 5.6928725574E+00, 8.7458234307E-01, 6.9355038165E-01, 6.8808005445E-01],
	[1.58700E+04, 8.1472269039E+00, 5.6925949689E+00, 8.7546398243E-01, 6.9412658921E-01, 6.8820464416E-01],
	[1.58750E+04, 8.1508107746E+00, 5.6923174815E+00, 8.7634623240E-01, 6.9470300200E-01, 6.8832920840E-01],
	[1.58800E+04, 8.1543950925E+00, 5.6920400949E+00, 8.7722909321E-01, 6.9527961989E-01, 6.8845374716E-01],
	[1.58850E+04, 8.1579798575E+00, 5.6917628091E+00, 8.7811256508E-01, 6.9585644274E-01, 6.8857826043E-01],
	[1.58900E+04, 8.1615650694E+00, 5.6914856242E+00, 8.7899664826E-01, 6.9643347040E-01, 6.8870274818E-01],
	[1.58950E+04, 8.1651507283E+00, 5.6912085399E+00, 8.7988134296E-01, 6.9701070274E-01, 6.8882721039E-01],
	[1.59000E+04, 8.1687368340E+00, 5.6909315563E+00, 8.8076664943E-01, 6.9758813962E-01, 6.8895164705E-01],
	[1.59050E+04, 8.1723233864E+00, 5.6906546732E+00, 8.8165256788E-01, 6.9816578090E-01, 6.8907605815E-01],
	[1.59100E+04, 8.1759103854E+00, 5.6903778906E+00, 8.8253909856E-01, 6.9874362642E-01, 6.8920044365E-01],
	[1.59150E+04, 8.1794978311E+00, 5.6901012084E+00, 8.8342624168E-01, 6.9932167606E-01, 6.8932480355E-01],
	[1.59200E+04, 8.1830857232E+00, 5.6898246266E+00, 8.8431399749E-01, 6.9989992968E-01, 6.8944913783E-01],
	[1.59250E+04, 8.1866740617E+00, 5.6895481451E+00, 8.8520236621E-01, 7.0047838712E-01, 6.8957344646E-01],
	[1.59300E+04, 8.1902628465E+00, 5.6892717638E+00, 8.8609134807E-01, 7.0105704825E-01, 6.8969772943E-01],
	[1.59350E+04, 8.1938520775E+00, 5.6889954827E+00, 8.8698094330E-01, 7.0163591293E-01, 6.8982198672E-01],
	[1.59400E+04, 8.1974417547E+00, 5.6887193016E+00, 8.8787115214E-01, 7.0221498102E-01, 6.8994621832E-01],
	[1.59450E+04, 8.2010318779E+00, 5.6884432206E+00, 8.8876197481E-01, 7.0279425237E-01, 6.9007042421E-01],
	[1.59500E+04, 8.2046224471E+00, 5.6881672395E+00, 8.8965341155E-01, 7.0337372684E-01, 6.9019460436E-01],
	[1.59550E+04, 8.2082134622E+00, 5.6878913583E+00, 8.9054546259E-01, 7.0395340429E-01, 6.9031875877E-01],
	[1.59600E+04, 8.2118049231E+00, 5.6876155770E+00, 8.9143812814E-01, 7.0453328458E-01, 6.9044288741E-01],
	[1.59650E+04, 8.2153968297E+00, 5.6873398953E+00, 8.9233140846E-01, 7.0511336756E-01, 6.9056699026E-01],
	[1.59700E+04, 8.2189891819E+00, 5.6870643134E+00, 8.9322530376E-01, 7.0569365310E-01, 6.9069106732E-01],
	[1.59750E+04, 8.2225819797E+00, 5.6867888310E+00, 8.9411981428E-01, 7.0627414105E-01, 6.9081511855E-01],
	[1.59800E+04, 8.2261752230E+00, 5.6865134483E+00, 8.9501494025E-01, 7.0685483127E-01, 6.9093914395E-01],
	[1.59850E+04, 8.2297689116E+00, 5.6862381650E+00, 8.9591068190E-01, 7.0743572362E-01, 6.9106314349E-01],
	[1.59900E+04, 8.2333630455E+00, 5.6859629811E+00, 8.9680703946E-01, 7.0801681794E-01, 6.9118711716E-01],
	[1.59950E+04, 8.2369576247E+00, 5.6856878965E+00, 8.9770401316E-01, 7.0859811411E-01, 6.9131106494E-01],
	[1.60000E+04, 8.2405526490E+00, 5.6854129113E+00, 8.9860160323E-01, 7.0917961197E-01, 6.9143498681E-01],
	[1.60050E+04, 8.2441481183E+00, 5.6851380252E+00, 8.9949980990E-01, 7.0976131139E-01, 6.9155888276E-01],
	[1.60100E+04, 8.2477440326E+00, 5.6848632383E+00, 9.0039863340E-01, 7.1034321222E-01, 6.9168275277E-01],
	[1.60150E+04, 8.2513403917E+00, 5.6845885505E+00, 9.0129807397E-01, 7.1092531431E-01, 6.9180659682E-01],
	[1.60200E+04, 8.2549371957E+00, 5.6843139617E+00, 9.0219813184E-01, 7.1150761753E-01, 6.9193041489E-01],
	[1.60250E+04, 8.2585344443E+00, 5.6840394718E+00, 9.0309880722E-01, 7.1209012173E-01, 6.9205420697E-01],
	[1.60300E+04, 8.2621321376E+00, 5.6837650808E+00, 9.0400010037E-01, 7.1267282676E-01, 6.9217797304E-01],
	[1.60350E+04, 8.2657302755E+00, 5.6834907886E+00, 9.0490201150E-01, 7.1325573249E-01, 6.9230171308E-01],
	[1.60400E+04, 8.2693288577E+00, 5.6832165952E+00, 9.0580454085E-01, 7.1383883876E-01, 6.9242542708E-01],
	[1.60450E+04, 8.2729278844E+00, 5.6829425005E+00, 9.0670768865E-01, 7.1442214544E-01, 6.9254911501E-01],
	[1.60500E+04, 8.2765273554E+00, 5.6826685043E+00, 9.0761145512E-01, 7.1500565238E-01, 6.9267277686E-01],
	[1.60550E+04, 8.2801272705E+00, 5.6823946067E+00, 9.0851584051E-01, 7.1558935944E-01, 6.9279641262E-01],
	[1.60600E+04, 8.2837276298E+00, 5.6821208076E+00, 9.0942084504E-01, 7.1617326646E-01, 6.9292002226E-01],
	[1.60650E+04, 8.2873284331E+00, 5.6818471069E+00, 9.1032646894E-01, 7.1675737332E-01, 6.9304360578E-01],
	[1.60700E+04, 8.2909296804E+00, 5.6815735046E+00, 9.1123271244E-01, 7.1734167985E-01, 6.9316716314E-01],
	[1.60750E+04, 8.2945313716E+00, 5.6813000006E+00, 9.1213957578E-01, 7.1792618593E-01, 6.9329069434E-01],
	[1.60800E+04, 8.2981335065E+00, 5.6810265947E+00, 9.1304705918E-01, 7.1851089140E-01, 6.9341419936E-01],
	[1.60850E+04, 8.3017360852E+00, 5.6807532870E+00, 9.1395516287E-01, 7.1909579611E-01, 6.9353767819E-01],
	[1.60900E+04, 8.3053391075E+00, 5.6804800774E+00, 9.1486388710E-01, 7.1968089993E-01, 6.9366113079E-01],
	[1.60950E+04, 8.3089425733E+00, 5.6802069659E+00, 9.1577323208E-01, 7.2026620270E-01, 6.9378455717E-01],
	[1.61000E+04, 8.3125464826E+00, 5.6799339522E+00, 9.1668319805E-01, 7.2085170429E-01, 6.9390795729E-01],
	[1.61050E+04, 8.3161508352E+00, 5.6796610365E+00, 9.1759378524E-01, 7.2143740454E-01, 6.9403133115E-01],
	[1.61100E+04, 8.3197556312E+00, 5.6793882186E+00, 9.1850499388E-01, 7.2202330332E-01, 6.9415467873E-01],
	[1.61150E+04, 8.3233608703E+00, 5.6791154984E+00, 9.1941682421E-01, 7.2260940047E-01, 6.9427800001E-01],
	[1.61200E+04, 8.3269665526E+00, 5.6788428760E+00, 9.2032927644E-01, 7.2319569586E-01, 6.9440129498E-01],
	[1.61250E+04, 8.3305726779E+00, 5.6785703512E+00, 9.2124235082E-01, 7.2378218932E-01, 6.9452456361E-01],
	[1.61300E+04, 8.3341792462E+00, 5.6782979239E+00, 9.2215604758E-01, 7.2436888073E-01, 6.9464780589E-01],
	[1.61350E+04, 8.3377862573E+00, 5.6780255941E+00, 9.2307036694E-01, 7.2495576992E-01, 6.9477102181E-01],
	[1.61400E+04, 8.3413937112E+00, 5.6777533618E+00, 9.2398530914E-01, 7.2554285677E-01, 6.9489421135E-01],
	[1.61450E+04, 8.3450016079E+00, 5.6774812268E+00, 9.2490087441E-01, 7.2613014111E-01, 6.9501737448E-01],
	[1.61500E+04, 8.3486099472E+00, 5.6772091892E+00, 9.2581706297E-01, 7.2671762281E-01, 6.9514051121E-01],
	[1.61550E+04, 8.3522187290E+00, 5.6769372487E+00, 9.2673387507E-01, 7.2730530171E-01, 6.9526362150E-01],
	[1.61600E+04, 8.3558279533E+00, 5.6766654055E+00, 9.2765131093E-01, 7.2789317768E-01, 6.9538670534E-01],
	[1.61650E+04, 8.3594376199E+00, 5.6763936594E+00, 9.2856937078E-01, 7.2848125056E-01, 6.9550976272E-01],
	[1.61700E+04, 8.3630477289E+00, 5.6761220103E+00, 9.2948805486E-01, 7.2906952020E-01, 6.9563279362E-01],
	[1.61750E+04, 8.3666582801E+00, 5.6758504581E+00, 9.3040736339E-01, 7.2965798647E-01, 6.9575579803E-01],
	[1.61800E+04, 8.3702692734E+00, 5.6755790029E+00, 9.3132729661E-01, 7.3024664921E-01, 6.9587877592E-01],
	[1.61850E+04, 8.3738807087E+00, 5.6753076446E+00, 9.3224785475E-01, 7.3083550827E-01, 6.9600172728E-01],
	[1.61900E+04, 8.3774925860E+00, 5.6750363830E+00, 9.3316903803E-01, 7.3142456351E-01, 6.9612465210E-01],
	[1.61950E+04, 8.3811049053E+00, 5.6747652181E+00, 9.3409084670E-01, 7.3201381479E-01, 6.9624755035E-01],
	[1.62000E+04, 8.3847176663E+00, 5.6744941499E+00, 9.3501328098E-01, 7.3260326195E-01, 6.9637042203E-01],
	[1.62050E+04, 8.3883308690E+00, 5.6742231783E+00, 9.3593634110E-01, 7.3319290484E-01, 6.9649326711E-01],
	[1.62100E+04, 8.3919445133E+00, 5.6739523033E+00, 9.3686002730E-01, 7.3378274333E-01, 6.9661608558E-01],
	[1.62150E+04, 8.3955585993E+00, 5.6736815247E+00, 9.3778433980E-01, 7.3437277725E-01, 6.9673887743E-01],
	[1.62200E+04, 8.3991731266E+00, 5.6734108425E+00, 9.3870927884E-01, 7.3496300647E-01, 6.9686164264E-01],
	[1.62250E+04, 8.4027880954E+00, 5.6731402566E+00, 9.3963484465E-01, 7.3555343083E-01, 6.9698438119E-01],
	[1.62300E+04, 8.4064035055E+00, 5.6728697670E+00, 9.4056103746E-01, 7.3614405019E-01, 6.9710709306E-01],
	[1.62350E+04, 8.4100193568E+00, 5.6725993736E+00, 9.4148785750E-01, 7.3673486440E-01, 6.9722977824E-01],
	[1.62400E+04, 8.4136356493E+00, 5.6723290763E+00, 9.4241530500E-01, 7.3732587331E-01, 6.9735243672E-01],
	[1.62450E+04, 8.4172523828E+00, 5.6720588752E+00, 9.4334338020E-01, 7.3791707677E-01, 6.9747506848E-01],
	[1.62500E+04, 8.4208695573E+00, 5.6717887700E+00, 9.4427208332E-01, 7.3850847464E-01, 6.9759767350E-01],
	[1.62550E+04, 8.4244871727E+00, 5.6715187608E+00, 9.4520141460E-01, 7.3910006676E-01, 6.9772025176E-01],
	[1.62600E+04, 8.4281052289E+00, 5.6712488475E+00, 9.4613137426E-01, 7.3969185299E-01, 6.9784280326E-01],
	[1.62650E+04, 8.4317237258E+00, 5.6709790300E+00, 9.4706196255E-01, 7.4028383317E-01, 6.9796532798E-01],
	[1.62700E+04, 8.4353426634E+00, 5.6707093083E+00, 9.4799317969E-01, 7.4087600716E-01, 6.9808782589E-01],
	[1.62750E+04, 8.4389620416E+00, 5.6704396823E+00, 9.4892502591E-01, 7.4146837482E-01, 6.9821029698E-01],
	[1.62800E+04, 8.4425818602E+00, 5.6701701519E+00, 9.4985750144E-01, 7.4206093598E-01, 6.9833274125E-01],
	[1.62850E+04, 8.4462021193E+00, 5.6699007171E+00, 9.5079060652E-01, 7.4265369050E-01, 6.9845515867E-01],
	[1.62900E+04, 8.4498228187E+00, 5.6696313778E+00, 9.5172434138E-01, 7.4324663824E-01, 6.9857754922E-01],
	[1.62950E+04, 8.4534439583E+00, 5.6693621339E+00, 9.5265870625E-01, 7.4383977904E-01, 6.9869991290E-01],
	[1.63000E+04, 8.4570655381E+00, 5.6690929854E+00, 9.5359370136E-01, 7.4443311275E-01, 6.9882224968E-01],
	[1.63050E+04, 8.4606875580E+00, 5.6688239323E+00, 9.5452932694E-01, 7.4502663922E-01, 6.9894455955E-01],
	[1.63100E+04, 8.4643100179E+00, 5.6685549744E+00, 9.5546558322E-01, 7.4562035831E-01, 6.9906684250E-01],
	[1.63150E+04, 8.4679329177E+00, 5.6682861117E+00, 9.5640247044E-01, 7.4621426986E-01, 6.9918909851E-01],
	[1.63200E+04, 8.4715562573E+00, 5.6680173441E+00, 9.5733998883E-01, 7.4680837373E-01, 6.9931132756E-01],
	[1.63250E+04, 8.4751800367E+00, 5.6677486716E+00, 9.5827813862E-01, 7.4740266975E-01, 6.9943352964E-01],
	[1.63300E+04, 8.4788166996E+00, 5.6674867510E+00, 9.5921692003E-01, 7.4799737060E-01, 6.9955570473E-01],
	[1.63350E+04, 8.4824684089E+00, 5.6672327293E+00, 9.6015633331E-01, 7.4859251377E-01, 6.9967785283E-01],
	[1.63400E+04, 8.4861205727E+00, 5.6669787967E+00, 9.6109637868E-01, 7.4918784982E-01, 6.9979997390E-01],
	[1.63450E+04, 8.4897731908E+00, 5.6667249531E+00, 9.6203705638E-01, 7.4978337861E-01, 6.9992206794E-01],
	[1.63500E+04, 8.4934262632E+00, 5.6664711986E+00, 9.6297836663E-01, 7.5037909999E-01, 7.0004413494E-01],
	[1.63550E+04, 8.4970797898E+00, 5.6662175330E+00, 9.6392030967E-01, 7.5097501381E-01, 7.0016617487E-01],
	[1.63600E+04, 8.5007337704E+00, 5.6659639564E+00, 9.6486288574E-01, 7.5157111992E-01, 7.0028818773E-01],
	[1.63650E+04, 8.5043882051E+00, 5.6657104685E+00, 9.6580609505E-01, 7.5216741816E-01, 7.0041017349E-01],
	[1.63700E+04, 8.5080430938E+00, 5.6654570694E+00, 9.6674993785E-01, 7.5276390840E-01, 7.0053213215E-01],
	[1.63750E+04, 8.5116984363E+00, 5.6652037590E+00, 9.6769441436E-01, 7.5336059048E-01, 7.0065406368E-01],
	[1.63800E+04, 8.5153542325E+00, 5.6649505373E+00, 9.6863952483E-01, 7.5395746425E-01, 7.0077596807E-01],
	[1.63850E+04, 8.5190104825E+00, 5.6646974042E+00, 9.6958526947E-01, 7.5455452956E-01, 7.0089784532E-01],
	[1.63900E+04, 8.5226671861E+00, 5.6644443596E+00, 9.7053164852E-01, 7.5515178626E-01, 7.0101969539E-01],
	[1.63950E+04, 8.5263243432E+00, 5.6641914035E+00, 9.7147866222E-01, 7.5574923420E-01, 7.0114151828E-01],
	[1.64000E+04, 8.5299819537E+00, 5.6639385358E+00, 9.7242631079E-01, 7.5634687323E-01, 7.0126331397E-01],
	[1.64050E+04, 8.5336400176E+00, 5.6636857565E+00, 9.7337459447E-01, 7.5694470320E-01, 7.0138508245E-01],
	[1.64100E+04, 8.5372985348E+00, 5.6634330655E+00, 9.7432351348E-01, 7.5754272396E-01, 7.0150682370E-01],
	[1.64150E+04, 8.5409575052E+00, 5.6631804628E+00, 9.7527306807E-01, 7.5814093536E-01, 7.0162853772E-01],
	[1.64200E+04, 8.5446169287E+00, 5.6629279482E+00, 9.7622325846E-01, 7.5873933725E-01, 7.0175022447E-01],
	[1.64250E+04, 8.5482768053E+00, 5.6626755218E+00, 9.7717408488E-01, 7.5933792948E-01, 7.0187188395E-01],
	[1.64300E+04, 8.5519371348E+00, 5.6624231834E+00, 9.7812554757E-01, 7.5993671190E-01, 7.0199351615E-01],
	[1.64350E+04, 8.5555979171E+00, 5.6621709331E+00, 9.7907764676E-01, 7.6053568435E-01, 7.0211512104E-01],
	[1.64400E+04, 8.5592591523E+00, 5.6619187707E+00, 9.8003038268E-01, 7.6113484669E-01, 7.0223669862E-01],
	[1.64450E+04, 8.5629208402E+00, 5.6616666963E+00, 9.8098375556E-01, 7.6173419876E-01, 7.0235824887E-01],
	[1.64500E+04, 8.5665829807E+00, 5.6614147097E+00, 9.8193776564E-01, 7.6233374041E-01, 7.0247977177E-01],
	[1.64550E+04, 8.5702455737E+00, 5.6611628109E+00, 9.8289241314E-01, 7.6293347150E-01, 7.0260126731E-01],
	[1.64600E+04, 8.5739086192E+00, 5.6609109998E+00, 9.8384769830E-01, 7.6353339187E-01, 7.0272273548E-01],
	[1.64650E+04, 8.5775721171E+00, 5.6606592763E+00, 9.8480362135E-01, 7.6413350136E-01, 7.0284417626E-01],
	[1.64700E+04, 8.5812360673E+00, 5.6604076406E+00, 9.8576018252E-01, 7.6473379984E-01, 7.0296558964E-01],
	[1.64750E+04, 8.5849004697E+00, 5.6601560923E+00, 9.8671738205E-01, 7.6533428714E-01, 7.0308697560E-01],
	[1.64800E+04, 8.5885653242E+00, 5.6599046316E+00, 9.8767522016E-01, 7.6593496311E-01, 7.0320833413E-01],
	[1.64850E+04, 8.5922306309E+00, 5.6596532583E+00, 9.8863369709E-01, 7.6653582760E-01, 7.0332966521E-01],
	[1.64900E+04, 8.5958963894E+00, 5.6594019724E+00, 9.8959281307E-01, 7.6713688047E-01, 7.0345096883E-01],
	[1.64950E+04, 8.5995625999E+00, 5.6591507739E+00, 9.9055256834E-01, 7.6773812155E-01, 7.0357224498E-01],
	[1.65000E+04, 8.6032292622E+00, 5.6588996626E+00, 9.9151296312E-01, 7.6833955070E-01, 7.0369349364E-01],
	[1.65050E+04, 8.6068963762E+00, 5.6586486385E+00, 9.9247399764E-01, 7.6894116777E-01, 7.0381471479E-01],
	[1.65100E+04, 8.6105639419E+00, 5.6583977016E+00, 9.9343567215E-01, 7.6954297259E-01, 7.0393590843E-01],
	[1.65150E+04, 8.6142319591E+00, 5.6581468518E+00, 9.9439798686E-01, 7.7014496502E-01, 7.0405707453E-01],
	[1.65200E+04, 8.6179004278E+00, 5.6578960891E+00, 9.9536094203E-01, 7.7074714491E-01, 7.0417821309E-01],
	[1.65250E+04, 8.6215693480E+00, 5.6576454133E+00, 9.9632453786E-01, 7.7134951211E-01, 7.0429932409E-01],
	[1.65300E+04, 8.6252387194E+00, 5.6573948245E+00, 9.9728877461E-01, 7.7195206645E-01, 7.0442040752E-01],
	[1.65350E+04, 8.6289085421E+00, 5.6571443226E+00, 9.9825365249E-01, 7.7255480779E-01, 7.0454146335E-01],
	[1.65400E+04, 8.6325788160E+00, 5.6568939075E+00, 9.9921917175E-01, 7.7315773598E-01, 7.0466249159E-01],
	[1.65450E+04, 8.6362495409E+00, 5.6566435792E+00, 1.0001853326E+00, 7.7376085086E-01, 7.0478349220E-01],
	[1.65500E+04, 8.6399207169E+00, 5.6563933376E+00, 1.0011521353E+00, 7.7436415228E-01, 7.0490446519E-01],
	[1.65550E+04, 8.6435923438E+00, 5.6561431826E+00, 1.0021195801E+00, 7.7496764008E-01, 7.0502541053E-01],
	[1.65600E+04, 8.6472644215E+00, 5.6558931142E+00, 1.0030876671E+00, 7.7557131412E-01, 7.0514632822E-01],
	[1.65650E+04, 8.6509369499E+00, 5.6556431324E+00, 1.0040563967E+00, 7.7617517423E-01, 7.0526721823E-01],
	[1.65700E+04, 8.6546099291E+00, 5.6553932371E+00, 1.0050257691E+00, 7.7677922027E-01, 7.0538808056E-01],
	[1.65750E+04, 8.6582833588E+00, 5.6551434281E+00, 1.0059957845E+00, 7.7738345209E-01, 7.0550891519E-01],
	[1.65800E+04, 8.6619572391E+00, 5.6548937056E+00, 1.0069664431E+00, 7.7798786952E-01, 7.0562972210E-01],
	[1.65850E+04, 8.6656315698E+00, 5.6546440694E+00, 1.0079377451E+00, 7.7859247241E-01, 7.0575050129E-01],
	[1.65900E+04, 8.6693063509E+00, 5.6543945195E+00, 1.0089096909E+00, 7.7919726062E-01, 7.0587125273E-01],
	[1.65950E+04, 8.6729815822E+00, 5.6541450557E+00, 1.0098822806E+00, 7.7980223398E-01, 7.0599197642E-01],
	[1.66000E+04, 8.6766572637E+00, 5.6538956781E+00, 1.0108555144E+00, 7.8040739235E-01, 7.0611267235E-01],
	[1.66050E+04, 8.6803333954E+00, 5.6536463866E+00, 1.0118293927E+00, 7.8101273556E-01, 7.0623334049E-01],
	[1.66100E+04, 8.6840099770E+00, 5.6533971812E+00, 1.0128039155E+00, 7.8161826347E-01, 7.0635398083E-01],
	[1.66150E+04, 8.6876870087E+00, 5.6531480617E+00, 1.0137790832E+00, 7.8222397592E-01, 7.0647459337E-01],
	[1.66200E+04, 8.6913644902E+00, 5.6528990282E+00, 1.0147548961E+00, 7.8282987275E-01, 7.0659517808E-01],
	[1.66250E+04, 8.6950424214E+00, 5.6526500805E+00, 1.0157313542E+00, 7.8343595382E-01, 7.0671573496E-01],
	[1.66300E+04, 8.6987208025E+00, 5.6524012187E+00, 1.0167084579E+00, 7.8404221896E-01, 7.0683626398E-01],
	[1.66350E+04, 8.7023996331E+00, 5.6521524426E+00, 1.0176862073E+00, 7.8464866802E-01, 7.0695676515E-01],
	[1.66400E+04, 8.7060789133E+00, 5.6519037522E+00, 1.0186646028E+00, 7.8525530085E-01, 7.0707723843E-01],
	[1.66450E+04, 8.7097586429E+00, 5.6516551475E+00, 1.0196436446E+00, 7.8586211729E-01, 7.0719768383E-01],
	[1.66500E+04, 8.7134388220E+00, 5.6514066284E+00, 1.0206233328E+00, 7.8646911718E-01, 7.0731810132E-01],
	[1.66550E+04, 8.7171194504E+00, 5.6511581948E+00, 1.0216036678E+00, 7.8707630038E-01, 7.0743849090E-01],
	[1.66600E+04, 8.7208005280E+00, 5.6509098467E+00, 1.0225846497E+00, 7.8768366673E-01, 7.0755885255E-01],
	[1.66650E+04, 8.7244820547E+00, 5.6506615840E+00, 1.0235662788E+00, 7.8829121606E-01, 7.0767918625E-01],
	[1.66700E+04, 8.7281640305E+00, 5.6504134068E+00, 1.0245485553E+00, 7.8889894824E-01, 7.0779949199E-01],
	[1.66750E+04, 8.7318464553E+00, 5.6501653148E+00, 1.0255314794E+00, 7.8950686309E-01, 7.0791976977E-01],
	[1.66800E+04, 8.7355293291E+00, 5.6499173081E+00, 1.0265150514E+00, 7.9011496047E-01, 7.0804001956E-01],
	[1.66850E+04, 8.7392126516E+00, 5.6496693866E+00, 1.0274992716E+00, 7.9072324021E-01, 7.0816024136E-01],
	[1.66900E+04, 8.7428964229E+00, 5.6494215503E+00, 1.0284841401E+00, 7.9133170218E-01, 7.0828043515E-01],
	[1.66950E+04, 8.7465806429E+00, 5.6491737991E+00, 1.0294696571E+00, 7.9194034619E-01, 7.0840060091E-01],
	[1.67000E+04, 8.7502653115E+00, 5.6489261329E+00, 1.0304558230E+00, 7.9254917211E-01, 7.0852073864E-01],
	[1.67050E+04, 8.7539504286E+00, 5.6486785517E+00, 1.0314426379E+00, 7.9315817978E-01, 7.0864084832E-01],
	[1.67100E+04, 8.7576359941E+00, 5.6484310555E+00, 1.0324301021E+00, 7.9376736904E-01, 7.0876092994E-01],
	[1.67150E+04, 8.7613220079E+00, 5.6481836441E+00, 1.0334182158E+00, 7.9437673973E-01, 7.0888098348E-01],
	[1.67200E+04, 8.7650084701E+00, 5.6479363176E+00, 1.0344069793E+00, 7.9498629169E-01, 7.0900100894E-01],
	[1.67250E+04, 8.7686953804E+00, 5.6476890758E+00, 1.0353963927E+00, 7.9559602478E-01, 7.0912100630E-01],
	[1.67300E+04, 8.7723827389E+00, 5.6474419188E+00, 1.0363864563E+00, 7.9620593883E-01, 7.0924097554E-01],
	[1.67350E+04, 8.7760705454E+00, 5.6471948464E+00, 1.0373771704E+00, 7.9681603370E-01, 7.0936091666E-01],
	[1.67400E+04, 8.7797587998E+00, 5.6469478587E+00, 1.0383685352E+00, 7.9742630921E-01, 7.0948082963E-01],
	[1.67450E+04, 8.7834475021E+00, 5.6467009555E+00, 1.0393605508E+00, 7.9803676521E-01, 7.0960071446E-01],
	[1.67500E+04, 8.7871366523E+00, 5.6464541368E+00, 1.0403532176E+00, 7.9864740156E-01, 7.0972057112E-01],
	[1.67550E+04, 8.7908262501E+00, 5.6462074026E+00, 1.0413465358E+00, 7.9925821809E-01, 7.0984039960E-01],
	[1.67600E+04, 8.7945162956E+00, 5.6459607527E+00, 1.0423405055E+00, 7.9986921464E-01, 7.0996019989E-01],
	[1.67650E+04, 8.7982067886E+00, 5.6457141872E+00, 1.0433351271E+00, 8.0048039105E-01, 7.1007997198E-01],
	[1.67700E+04, 8.8018977291E+00, 5.6454677060E+00, 1.0443304008E+00, 8.0109174718E-01, 7.1019971586E-01],
	[1.67750E+04, 8.8055891170E+00, 5.6452213090E+00, 1.0453263268E+00, 8.0170328286E-01, 7.1031943148E-01],
	[1.67800E+04, 8.8092809523E+00, 5.6449749962E+00, 1.0463229053E+00, 8.0231499793E-01, 7.1043911884E-01],
	[1.67850E+04, 8.8129732347E+00, 5.6447287676E+00, 1.0473201366E+00, 8.0292689225E-01, 7.1055877791E-01],
	[1.67900E+04, 8.8166659644E+00, 5.6444826230E+00, 1.0483180209E+00, 8.0353896564E-01, 7.1067840868E-01],
	[1.67950E+04, 8.8203591411E+00, 5.6442365624E+00, 1.0493165584E+00, 8.0415121796E-01, 7.1079801114E-01],
	[1.68000E+04, 8.8240527648E+00, 5.6439905858E+00, 1.0503157494E+00, 8.0476364904E-01, 7.1091758527E-01],
	[1.68050E+04, 8.8277468355E+00, 5.6437446931E+00, 1.0513155941E+00, 8.0537625873E-01, 7.1103713105E-01],
	[1.68100E+04, 8.8314413530E+00, 5.6434988842E+00, 1.0523160927E+00, 8.0598904687E-01, 7.1115664847E-01],
	[1.68150E+04, 8.8351363173E+00, 5.6432531592E+00, 1.0533172455E+00, 8.0660201330E-01, 7.1127613751E-01],
	[1.68200E+04, 8.8388317283E+00, 5.6430075179E+00, 1.0543190527E+00, 8.0721515786E-01, 7.1139559816E-01],
	[1.68250E+04, 8.8425275858E+00, 5.6427619603E+00, 1.0553215145E+00, 8.0782848040E-01, 7.1151503039E-01],
	[1.68300E+04, 8.8462238899E+00, 5.6425164863E+00, 1.0563246312E+00, 8.0844198076E-01, 7.1163443420E-01],
	[1.68350E+04, 8.8499206405E+00, 5.6422710960E+00, 1.0573284030E+00, 8.0905565878E-01, 7.1175380957E-01],
	[1.68400E+04, 8.8536178374E+00, 5.6420257891E+00, 1.0583328301E+00, 8.0966951429E-01, 7.1187315648E-01],
	[1.68450E+04, 8.8573154807E+00, 5.6417805658E+00, 1.0593379128E+00, 8.1028354715E-01, 7.1199247492E-01],
	[1.68500E+04, 8.8610135701E+00, 5.6415354259E+00, 1.0603436513E+00, 8.1089775720E-01, 7.1211176487E-01],
	[1.68550E+04, 8.8647121057E+00, 5.6412903694E+00, 1.0613500458E+00, 8.1151214426E-01, 7.1223102632E-01],
	[1.68600E+04, 8.8684110874E+00, 5.6410453962E+00, 1.0623570966E+00, 8.1212670820E-01, 7.1235025925E-01],
	[1.68650E+04, 8.8721105150E+00, 5.6408005062E+00, 1.0633648038E+00, 8.1274144884E-01, 7.1246946364E-01],
	[1.68700E+04, 8.8758103885E+00, 5.6405556995E+00, 1.0643731678E+00, 8.1335636603E-01, 7.1258863949E-01],
	[1.68750E+04, 8.8795107079E+00, 5.6403109760E+00, 1.0653821888E+00, 8.1397145962E-01, 7.1270778676E-01],
	[1.68800E+04, 8.8832114730E+00, 5.6400663355E+00, 1.0663918670E+00, 8.1458672943E-01, 7.1282690546E-01],
	[1.68850E+04, 8.8869126838E+00, 5.6398217781E+00, 1.0674022026E+00, 8.1520217531E-01, 7.1294599556E-01],
	[1.68900E+04, 8.8906143401E+00, 5.6395773038E+00, 1.0684131958E+00, 8.1581779711E-01, 7.1306505705E-01],
	[1.68950E+04, 8.8943164420E+00, 5.6393329124E+00, 1.0694248470E+00, 8.1643359466E-01, 7.1318408992E-01],
	[1.69000E+04, 8.8980189893E+00, 5.6390886038E+00, 1.0704371563E+00, 8.1704956780E-01, 7.1330309414E-01],
	[1.69050E+04, 8.9017219820E+00, 5.6388443782E+00, 1.0714501239E+00, 8.1766571638E-01, 7.1342206970E-01],
	[1.69100E+04, 8.9054254199E+00, 5.6386002353E+00, 1.0724637502E+00, 8.1828204024E-01, 7.1354101659E-01],
	[1.69150E+04, 8.9091293031E+00, 5.6383561752E+00, 1.0734780352E+00, 8.1889853921E-01, 7.1365993480E-01],
	[1.69200E+04, 8.9128336313E+00, 5.6381121978E+00, 1.0744929794E+00, 8.1951521313E-01, 7.1377882430E-01],
	[1.69250E+04, 8.9165384046E+00, 5.6378683030E+00, 1.0755085828E+00, 8.2013206185E-01, 7.1389768508E-01],
	[1.69300E+04, 8.9202436229E+00, 5.6376244908E+00, 1.0765248458E+00, 8.2074908521E-01, 7.1401651714E-01],
	[1.69350E+04, 8.9239492861E+00, 5.6373807611E+00, 1.0775417685E+00, 8.2136628304E-01, 7.1413532044E-01],
	[1.69400E+04, 8.9276553940E+00, 5.6371371139E+00, 1.0785593512E+00, 8.2198365519E-01, 7.1425409498E-01],
	[1.69450E+04, 8.9313619467E+00, 5.6368935491E+00, 1.0795775942E+00, 8.2260120149E-01, 7.1437284075E-01],
	[1.69500E+04, 8.9350689441E+00, 5.6366500668E+00, 1.0805964976E+00, 8.2321892179E-01, 7.1449155772E-01],
	[1.69550E+04, 8.9387763860E+00, 5.6364066667E+00, 1.0816160617E+00, 8.2383681593E-01, 7.1461024588E-01],
	[1.69600E+04, 8.9424842724E+00, 5.6361633489E+00, 1.0826362868E+00, 8.2445488374E-01, 7.1472890523E-01],
	[1.69650E+04, 8.9461926032E+00, 5.6359201134E+00, 1.0836571730E+00, 8.2507312507E-01, 7.1484753573E-01],
	[1.69700E+04, 8.9499013784E+00, 5.6356769600E+00, 1.0846787206E+00, 8.2569153975E-01, 7.1496613739E-01],
	[1.69750E+04, 8.9536105979E+00, 5.6354338887E+00, 1.0857009298E+00, 8.2631012762E-01, 7.1508471018E-01],
	[1.69800E+04, 8.9573265929E+00, 5.6351937691E+00, 1.0867238009E+00, 8.2692900428E-01, 7.1520325408E-01],
	[1.69850E+04, 8.9610672780E+00, 5.6349647127E+00, 1.0877473341E+00, 8.2754849771E-01, 7.1532176909E-01],
	[1.69900E+04, 8.9648084236E+00, 5.6347357331E+00, 1.0887715296E+00, 8.2816816516E-01, 7.1544025520E-01],
	[1.69950E+04, 8.9685500295E+00, 5.6345068301E+00, 1.0897963877E+00, 8.2878800648E-01, 7.1555871237E-01],
	[1.70000E+04, 8.9722920958E+00, 5.6342780038E+00, 1.0908219086E+00, 8.2940802151E-01, 7.1567714061E-01],
	[1.70050E+04, 8.9760346222E+00, 5.6340492541E+00, 1.0918480925E+00, 8.3002821010E-01, 7.1579553989E-01],
	[1.70100E+04, 8.9797776088E+00, 5.6338205809E+00, 1.0928749397E+00, 8.3064857208E-01, 7.1591391021E-01],
	[1.70150E+04, 8.9835210555E+00, 5.6335919842E+00, 1.0939024504E+00, 8.3126910728E-01, 7.1603225154E-01],
	[1.70200E+04, 8.9872649621E+00, 5.6333634639E+00, 1.0949306248E+00, 8.3188981557E-01, 7.1615056388E-01],
	[1.70250E+04, 8.9910093286E+00, 5.6331350200E+00, 1.0959594631E+00, 8.3251069676E-01, 7.1626884720E-01],
	[1.70300E+04, 8.9947541550E+00, 5.6329066524E+00, 1.0969889657E+00, 8.3313175070E-01, 7.1638710150E-01],
	[1.70350E+04, 8.9984994411E+00, 5.6326783611E+00, 1.0980191327E+00, 8.3375297724E-01, 7.1650532675E-01],
	[1.70400E+04, 9.0022451868E+00, 5.6324501461E+00, 1.0990499644E+00, 8.3437437621E-01, 7.1662352296E-01],
	[1.70450E+04, 9.0059913922E+00, 5.6322220073E+00, 1.1000814609E+00, 8.3499594744E-01, 7.1674169009E-01],
	[1.70500E+04, 9.0097380570E+00, 5.6319939446E+00, 1.1011136226E+00, 8.3561769079E-01, 7.1685982814E-01],
	[1.70550E+04, 9.0134851813E+00, 5.6317659581E+00, 1.1021464497E+00, 8.3623960609E-01, 7.1697793709E-01],
	[1.70600E+04, 9.0172327650E+00, 5.6315380475E+00, 1.1031799424E+00, 8.3686169318E-01, 7.1709601693E-01],
	[1.70650E+04, 9.0209808079E+00, 5.6313102130E+00, 1.1042141009E+00, 8.3748395190E-01, 7.1721406765E-01],
	[1.70700E+04, 9.0247293100E+00, 5.6310824545E+00, 1.1052489255E+00, 8.3810638209E-01, 7.1733208923E-01],
	[1.70750E+04, 9.0284782713E+00, 5.6308547718E+00, 1.1062844163E+00, 8.3872898358E-01, 7.1745008165E-01],
	[1.70800E+04, 9.0322276915E+00, 5.6306271651E+00, 1.1073205737E+00, 8.3935175622E-01, 7.1756804490E-01],
	[1.70850E+04, 9.0359775708E+00, 5.6303996341E+00, 1.1083573979E+00, 8.3997469985E-01, 7.1768597898E-01],
	[1.70900E+04, 9.0397279089E+00, 5.6301721789E+00, 1.1093948891E+00, 8.4059781430E-01, 7.1780388385E-01],
	[1.70950E+04, 9.0434787058E+00, 5.6299447994E+00, 1.1104330475E+00, 8.4122109941E-01, 7.1792175952E-01],
	[1.71000E+04, 9.0472299615E+00, 5.6297174956E+00, 1.1114718734E+00, 8.4184455503E-01, 7.1803960597E-01],
	[1.71050E+04, 9.0509816758E+00, 5.6294902675E+00, 1.1125113670E+00, 8.4246818099E-01, 7.1815742317E-01],
	[1.71100E+04, 9.0547338486E+00, 5.6292631149E+00, 1.1135515285E+00, 8.4309197713E-01, 7.1827521113E-01],
	[1.71150E+04, 9.0584864800E+00, 5.6290360378E+00, 1.1145923582E+00, 8.4371594328E-01, 7.1839296982E-01],
	[1.71200E+04, 9.0622395698E+00, 5.6288090362E+00, 1.1156338563E+00, 8.4434007930E-01, 7.1851069923E-01],
	[1.71250E+04, 9.0659931179E+00, 5.6285821101E+00, 1.1166760231E+00, 8.4496438501E-01, 7.1862839935E-01],
	[1.71300E+04, 9.0697471243E+00, 5.6283552594E+00, 1.1177188587E+00, 8.4558886025E-01, 7.1874607016E-01],
	[1.71350E+04, 9.0735015888E+00, 5.6281284839E+00, 1.1187623634E+00, 8.4621350487E-01, 7.1886371166E-01],
	[1.71400E+04, 9.0772565115E+00, 5.6279017838E+00, 1.1198065375E+00, 8.4683831869E-01, 7.1898132382E-01],
	[1.71450E+04, 9.0810118922E+00, 5.6276751590E+00, 1.1208513811E+00, 8.4746330157E-01, 7.1909890663E-01],
	[1.71500E+04, 9.0847677308E+00, 5.6274486093E+00, 1.1218968946E+00, 8.4808845333E-01, 7.1921646008E-01],
	[1.71550E+04, 9.0885240273E+00, 5.6272221348E+00, 1.1229430780E+00, 8.4871377381E-01, 7.1933398416E-01],
	[1.71600E+04, 9.0922807816E+00, 5.6269957354E+00, 1.1239899318E+00, 8.4933926286E-01, 7.1945147885E-01],
	[1.71650E+04, 9.0960379936E+00, 5.6267694111E+00, 1.1250374561E+00, 8.4996492031E-01, 7.1956894414E-01],
	[1.71700E+04, 9.0997956633E+00, 5.6265431618E+00, 1.1260856511E+00, 8.5059074600E-01, 7.1968638001E-01],
	[1.71750E+04, 9.1035537905E+00, 5.6263169875E+00, 1.1271345171E+00, 8.5121673976E-01, 7.1980378646E-01],
	[1.71800E+04, 9.1073123752E+00, 5.6260908880E+00, 1.1281840543E+00, 8.5184290144E-01, 7.1992116346E-01],
	[1.71850E+04, 9.1110714173E+00, 5.6258648635E+00, 1.1292342630E+00, 8.5246923086E-01, 7.2003851101E-01],
	[1.71900E+04, 9.1148309167E+00, 5.6256389138E+00, 1.1302851433E+00, 8.5309572788E-01, 7.2015582909E-01],
	[1.71950E+04, 9.1185908734E+00, 5.6254130388E+00, 1.1313366956E+00, 8.5372239232E-01, 7.2027311769E-01],
	[1.72000E+04, 9.1223512872E+00, 5.6251872386E+00, 1.1323889200E+00, 8.5434922403E-01, 7.2039037680E-01],
	[1.72050E+04, 9.1261121582E+00, 5.6249615131E+00, 1.1334418168E+00, 8.5497622283E-01, 7.2050760640E-01],
	[1.72100E+04, 9.1298734861E+00, 5.6247358623E+00, 1.1344953862E+00, 8.5560338857E-01, 7.2062480647E-01],
	[1.72150E+04, 9.1336352710E+00, 5.6245102860E+00, 1.1355496284E+00, 8.5623072109E-01, 7.2074197702E-01],
	[1.72200E+04, 9.1373975128E+00, 5.6242847843E+00, 1.1366045438E+00, 8.5685822022E-01, 7.2085911801E-01],
	[1.72250E+04, 9.1411602113E+00, 5.6240593571E+00, 1.1376601324E+00, 8.5748588580E-01, 7.2097622945E-01],
	[1.72300E+04, 9.1449233666E+00, 5.6238340043E+00, 1.1387163946E+00, 8.5811371766E-01, 7.2109331131E-01],
	[1.72350E+04, 9.1486869785E+00, 5.6236087260E+00, 1.1397733306E+00, 8.5874171565E-01, 7.2121036359E-01],
	[1.72400E+04, 9.1524510470E+00, 5.6233835220E+00, 1.1408309406E+00, 8.5936987960E-01, 7.2132738626E-01],
	[1.72450E+04, 9.1562155719E+00, 5.6231583923E+00, 1.1418892249E+00, 8.5999820934E-01, 7.2144437933E-01],
	[1.72500E+04, 9.1599805532E+00, 5.6229333370E+00, 1.1429481837E+00, 8.6062670472E-01, 7.2156134276E-01],
	[1.72550E+04, 9.1637459909E+00, 5.6227083558E+00, 1.1440078172E+00, 8.6125536556E-01, 7.2167827657E-01],
	[1.72600E+04, 9.1675118848E+00, 5.6224834488E+00, 1.1450681256E+00, 8.6188419171E-01, 7.2179518071E-01],
	[1.72650E+04, 9.1712782348E+00, 5.6222586160E+00, 1.1461291092E+00, 8.6251318300E-01, 7.2191205520E-01],
	[1.72700E+04, 9.1750450410E+00, 5.6220338572E+00, 1.1471907683E+00, 8.6314233927E-01, 7.2202890001E-01],
	[1.72750E+04, 9.1788123032E+00, 5.6218091725E+00, 1.1482531030E+00, 8.6377166036E-01, 7.2214571513E-01],
	[1.72800E+04, 9.1825800213E+00, 5.6215845618E+00, 1.1493161136E+00, 8.6440114609E-01, 7.2226250055E-01],
	[1.72850E+04, 9.1863481953E+00, 5.6213600251E+00, 1.1503798004E+00, 8.6503079632E-01, 7.2237925625E-01],
	[1.72900E+04, 9.1901168251E+00, 5.6211355622E+00, 1.1514441635E+00, 8.6566061086E-01, 7.2249598223E-01],
	[1.72950E+04, 9.1938859105E+00, 5.6209111732E+00, 1.1525092032E+00, 8.6629058957E-01, 7.2261267846E-01],
	[1.73000E+04, 9.1976554516E+00, 5.6206868580E+00, 1.1535749197E+00, 8.6692073227E-01, 7.2272934494E-01],
	[1.73050E+04, 9.2014254483E+00, 5.6204626166E+00, 1.1546413134E+00, 8.6755103880E-01, 7.2284598166E-01],
	[1.73100E+04, 9.2051959005E+00, 5.6202384490E+00, 1.1557083843E+00, 8.6818150900E-01, 7.2296258860E-01],
	[1.73150E+04, 9.2089668080E+00, 5.6200143550E+00, 1.1567761327E+00, 8.6881214270E-01, 7.2307916575E-01],
	[1.73200E+04, 9.2127381709E+00, 5.6197903346E+00, 1.1578445589E+00, 8.6944293973E-01, 7.2319571310E-01],
	[1.73250E+04, 9.2165099890E+00, 5.6195663878E+00, 1.1589136631E+00, 8.7007389994E-01, 7.2331223063E-01],
	[1.73300E+04, 9.2202822623E+00, 5.6193425146E+00, 1.1599834456E+00, 8.7070502316E-01, 7.2342871833E-01],
	[1.73350E+04, 9.2240549907E+00, 5.6191187148E+00, 1.1610539065E+00, 8.7133630923E-01, 7.2354517620E-01],
	[1.73400E+04, 9.2278281741E+00, 5.6188949885E+00, 1.1621250462E+00, 8.7196775797E-01, 7.2366160421E-01],
	[1.73450E+04, 9.2316018125E+00, 5.6186713356E+00, 1.1631968647E+00, 8.7259936923E-01, 7.2377800236E-01],
	[1.73500E+04, 9.2353759057E+00, 5.6184477561E+00, 1.1642693625E+00, 8.7323114284E-01, 7.2389437063E-01],
	[1.73550E+04, 9.2391504538E+00, 5.6182242499E+00, 1.1653425396E+00, 8.7386307864E-01, 7.2401070901E-01],
	[1.73600E+04, 9.2429254565E+00, 5.6180008170E+00, 1.1664163965E+00, 8.7449517645E-01, 7.2412701749E-01],
	[1.73650E+04, 9.2467009139E+00, 5.6177774573E+00, 1.1674909331E+00, 8.7512743612E-01, 7.2424329605E-01],
	[1.73700E+04, 9.2504768258E+00, 5.6175541707E+00, 1.1685661499E+00, 8.7575985748E-01, 7.2435954469E-01],
	[1.73750E+04, 9.2542531922E+00, 5.6173309573E+00, 1.1696420471E+00, 8.7639244037E-01, 7.2447576339E-01],
	[1.73800E+04, 9.2580300131E+00, 5.6171078170E+00, 1.1707186248E+00, 8.7702518462E-01, 7.2459195215E-01],
	[1.73850E+04, 9.2618072883E+00, 5.6168847498E+00, 1.1717958834E+00, 8.7765809006E-01, 7.2470811094E-01],
	[1.73900E+04, 9.2655850177E+00, 5.6166617555E+00, 1.1728738230E+00, 8.7829115653E-01, 7.2482423975E-01],
	[1.73950E+04, 9.2693632013E+00, 5.6164388342E+00, 1.1739524439E+00, 8.7892438386E-01, 7.2494033858E-01],
	[1.74000E+04, 9.2731418390E+00, 5.6162159858E+00, 1.1750317463E+00, 8.7955777190E-01, 7.2505640742E-01],
	[1.74050E+04, 9.2769209308E+00, 5.6159932103E+00, 1.1761117304E+00, 8.8019132047E-01, 7.2517244624E-01],
	[1.74100E+04, 9.2807004765E+00, 5.6157705076E+00, 1.1771923966E+00, 8.8082502940E-01, 7.2528845504E-01],
	[1.74150E+04, 9.2844804761E+00, 5.6155478776E+00, 1.1782737450E+00, 8.8145889854E-01, 7.2540443380E-01],
	[1.74200E+04, 9.2882609295E+00, 5.6153253204E+00, 1.1793557758E+00, 8.8209292771E-01, 7.2552038253E-01],
	[1.74250E+04, 9.2920418366E+00, 5.6151028359E+00, 1.1804384893E+00, 8.8272711676E-01, 7.2563630119E-01],
	[1.74300E+04, 9.2958231974E+00, 5.6148804241E+00, 1.1815218858E+00, 8.8336146551E-01, 7.2575218978E-01],
	[1.74350E+04, 9.2996050117E+00, 5.6146580848E+00, 1.1826059654E+00, 8.8399597380E-01, 7.2586804830E-01],
	[1.74400E+04, 9.3033872796E+00, 5.6144358181E+00, 1.1836907285E+00, 8.8463064146E-01, 7.2598387672E-01],
	[1.74450E+04, 9.3071700008E+00, 5.6142136239E+00, 1.1847761751E+00, 8.8526546832E-01, 7.2609967504E-01],
	[1.74500E+04, 9.3109531754E+00, 5.6139915021E+00, 1.1858623056E+00, 8.8590045423E-01, 7.2621544324E-01],
	[1.74550E+04, 9.3147368033E+00, 5.6137694528E+00, 1.1869491203E+00, 8.8653559902E-01, 7.2633118131E-01],
	[1.74600E+04, 9.3185208844E+00, 5.6135474759E+00, 1.1880366192E+00, 8.8717090251E-01, 7.2644688924E-01],
	[1.74650E+04, 9.3223054186E+00, 5.6133255713E+00, 1.1891248028E+00, 8.8780636454E-01, 7.2656256703E-01],
	[1.74700E+04, 9.3260904059E+00, 5.6131037389E+00, 1.1902136711E+00, 8.8844198495E-01, 7.2667821465E-01],
	[1.74750E+04, 9.3298758461E+00, 5.6128819788E+00, 1.1913032245E+00, 8.8907776357E-01, 7.2679383210E-01],
	[1.74800E+04, 9.3336617393E+00, 5.6126602910E+00, 1.1923934631E+00, 8.8971370023E-01, 7.2690941936E-01],
	[1.74850E+04, 9.3374480852E+00, 5.6124386752E+00, 1.1934843873E+00, 8.9034979477E-01, 7.2702497642E-01],
	[1.74900E+04, 9.3412348839E+00, 5.6122171316E+00, 1.1945759972E+00, 8.9098604702E-01, 7.2714050328E-01],
	[1.74950E+04, 9.3450221353E+00, 5.6119956601E+00, 1.1956682931E+00, 8.9162245681E-01, 7.2725599992E-01],
	[1.75000E+04, 9.3488098392E+00, 5.6117742605E+00, 1.1967612752E+00, 8.9225902398E-01, 7.2737146633E-01],
	[1.75050E+04, 9.3525979957E+00, 5.6115529330E+00, 1.1978638392E+00, 8.9290069096E-01, 7.2748690249E-01],
	[1.75100E+04, 9.3563866046E+00, 5.6113316774E+00, 1.1989671036E+00, 8.9354251866E-01, 7.2760230840E-01],
	[1.75150E+04, 9.3601756659E+00, 5.6111104936E+00, 1.2000710687E+00, 8.9418450691E-01, 7.2771768405E-01],
	[1.75200E+04, 9.3639651795E+00, 5.6108893818E+00, 1.2011757347E+00, 8.9482665554E-01, 7.2783302942E-01],
	[1.75250E+04, 9.3677551453E+00, 5.6106683417E+00, 1.2022811019E+00, 8.9546896438E-01, 7.2794834451E-01],
	[1.75300E+04, 9.3715455633E+00, 5.6104473734E+00, 1.2033871706E+00, 8.9611143325E-01, 7.2806362929E-01],
	[1.75350E+04, 9.3753364333E+00, 5.6102264768E+00, 1.2044939410E+00, 8.9675406199E-01, 7.2817888377E-01],
	[1.75400E+04, 9.3791277553E+00, 5.6100056518E+00, 1.2056014133E+00, 8.9739685043E-01, 7.2829410792E-01],
	[1.75450E+04, 9.3829195292E+00, 5.6097848985E+00, 1.2067095878E+00, 8.9803979839E-01, 7.2840930175E-01],
	[1.75500E+04, 9.3867117550E+00, 5.6095642168E+00, 1.2078184647E+00, 8.9868290571E-01, 7.2852446523E-01],
	[1.75550E+04, 9.3905044326E+00, 5.6093436066E+00, 1.2089280442E+00, 8.9932617221E-01, 7.2863959836E-01],
	[1.75600E+04, 9.3942975618E+00, 5.6091230680E+00, 1.2100383267E+00, 8.9996959773E-01, 7.2875470113E-01],
	[1.75650E+04, 9.3980911427E+00, 5.6089026007E+00, 1.2111493124E+00, 9.0061318208E-01, 7.2886977352E-01],
	[1.75700E+04, 9.4018851751E+00, 5.6086822049E+00, 1.2122610014E+00, 9.0125692511E-01, 7.2898481552E-01],
	[1.75750E+04, 9.4056796589E+00, 5.6084618805E+00, 1.2133733941E+00, 9.0190082663E-01, 7.2909982712E-01],
	[1.75800E+04, 9.4094745942E+00, 5.6082416274E+00, 1.2144864906E+00, 9.0254488648E-01, 7.2921480832E-01],
	[1.75850E+04, 9.4132699808E+00, 5.6080214455E+00, 1.2156002913E+00, 9.0318910449E-01, 7.2932975910E-01],
	[1.75900E+04, 9.4170658186E+00, 5.6078013349E+00, 1.2167147964E+00, 9.0383348049E-01, 7.2944467945E-01],
	[1.75950E+04, 9.4208621076E+00, 5.6075812955E+00, 1.2178300061E+00, 9.0447801430E-01, 7.2955956936E-01],
	[1.76000E+04, 9.4246588477E+00, 5.6073613272E+00, 1.2189459207E+00, 9.0512270575E-01, 7.2967442882E-01],
	[1.76050E+04, 9.4284560388E+00, 5.6071414301E+00, 1.2200625404E+00, 9.0576755467E-01, 7.2978925781E-01],
	[1.76100E+04, 9.4322536809E+00, 5.6069216040E+00, 1.2211798655E+00, 9.0641256089E-01, 7.2990405634E-01],
	[1.76150E+04, 9.4360517738E+00, 5.6067018489E+00, 1.2222978961E+00, 9.0705772424E-01, 7.3001882438E-01],
	[1.76200E+04, 9.4398503176E+00, 5.6064821648E+00, 1.2234166326E+00, 9.0770304454E-01, 7.3013356192E-01],
	[1.76250E+04, 9.4436493120E+00, 5.6062625517E+00, 1.2245360753E+00, 9.0834852163E-01, 7.3024826896E-01],
	[1.76300E+04, 9.4474487571E+00, 5.6060430094E+00, 1.2256562242E+00, 9.0899415533E-01, 7.3036294549E-01],
	[1.76350E+04, 9.4512486528E+00, 5.6058235380E+00, 1.2267770798E+00, 9.0963994547E-01, 7.3047759149E-01],
	[1.76400E+04, 9.4550489990E+00, 5.6056041374E+00, 1.2278986421E+00, 9.1028589187E-01, 7.3059220696E-01],
	[1.76450E+04, 9.4588497956E+00, 5.6053848075E+00, 1.2290209116E+00, 9.1093199438E-01, 7.3070679188E-01],
	[1.76500E+04, 9.4626510426E+00, 5.6051655484E+00, 1.2301438883E+00, 9.1157825281E-01, 7.3082134624E-01],
	[1.76550E+04, 9.4664527398E+00, 5.6049463600E+00, 1.2312675727E+00, 9.1222466699E-01, 7.3093587004E-01],
	[1.76600E+04, 9.4702808157E+00, 5.6047373314E+00, 1.2323919648E+00, 9.1287174532E-01, 7.3105036326E-01],
	[1.76650E+04, 9.4741176071E+00, 5.6045315793E+00, 1.2335170650E+00, 9.1351914217E-01, 7.3116482589E-01],
	[1.76700E+04, 9.4779548663E+00, 5.6043258930E+00, 1.2346428736E+00, 9.1416669573E-01, 7.3127925792E-01],
	[1.76750E+04, 9.4817925935E+00, 5.6041202725E+00, 1.2357693906E+00, 9.1481440585E-01, 7.3139365934E-01],
	[1.76800E+04, 9.4856307884E+00, 5.6039147176E+00, 1.2368966165E+00, 9.1546227234E-01, 7.3150803015E-01],
	[1.76850E+04, 9.4894694511E+00, 5.6037092284E+00, 1.2380245514E+00, 9.1611029503E-01, 7.3162237032E-01],
	[1.76900E+04, 9.4933085814E+00, 5.6035038048E+00, 1.2391531955E+00, 9.1675847376E-01, 7.3173667986E-01],
	[1.76950E+04, 9.4971481792E+00, 5.6032984468E+00, 1.2402825493E+00, 9.1740680835E-01, 7.3185095875E-01],
	[1.77000E+04, 9.5009882446E+00, 5.6030931544E+00, 1.2414126127E+00, 9.1805529863E-01, 7.3196520698E-01],
	[1.77050E+04, 9.5048287774E+00, 5.6028879274E+00, 1.2425433862E+00, 9.1870394443E-01, 7.3207942454E-01],
	[1.77100E+04, 9.5086697775E+00, 5.6026827659E+00, 1.2436748700E+00, 9.1935274558E-01, 7.3219361142E-01],
	[1.77150E+04, 9.5125112449E+00, 5.6024776699E+00, 1.2448070643E+00, 9.2000170190E-01, 7.3230776761E-01],
	[1.77200E+04, 9.5163531795E+00, 5.6022726392E+00, 1.2459399693E+00, 9.2065081323E-01, 7.3242189310E-01],
	[1.77250E+04, 9.5201955812E+00, 5.6020676738E+00, 1.2470735854E+00, 9.2130007939E-01, 7.3253598788E-01],
	[1.77300E+04, 9.5240384499E+00, 5.6018627738E+00, 1.2482079127E+00, 9.2194950022E-01, 7.3265005195E-01],
	[1.77350E+04, 9.5278817856E+00, 5.6016579390E+00, 1.2493429515E+00, 9.2259907553E-01, 7.3276408528E-01],
	[1.77400E+04, 9.5317255882E+00, 5.6014531695E+00, 1.2504787020E+00, 9.2324880516E-01, 7.3287808787E-01],
	[1.77450E+04, 9.5355698577E+00, 5.6012484652E+00, 1.2516151645E+00, 9.2389868894E-01, 7.3299205972E-01],
	[1.77500E+04, 9.5394145938E+00, 5.6010438260E+00, 1.2527523392E+00, 9.2454872669E-01, 7.3310600080E-01],
	[1.77550E+04, 9.5432597967E+00, 5.6008392519E+00, 1.2538902264E+00, 9.2519891824E-01, 7.3321991112E-01],
	[1.77600E+04, 9.5471054661E+00, 5.6006347428E+00, 1.2550288264E+00, 9.2584926343E-01, 7.3333379066E-01],
	[1.77650E+04, 9.5509516021E+00, 5.6004302988E+00, 1.2561681393E+00, 9.2649976207E-01, 7.3344763941E-01],
	[1.77700E+04, 9.5547982045E+00, 5.6002259199E+00, 1.2573081654E+00, 9.2715041399E-01, 7.3356145736E-01],
	[1.77750E+04, 9.5586452732E+00, 5.6000216058E+00, 1.2584489050E+00, 9.2780121903E-01, 7.3367524451E-01],
	[1.77800E+04, 9.5624928083E+00, 5.5998173567E+00, 1.2595903582E+00, 9.2845217702E-01, 7.3378900083E-01],
	[1.77850E+04, 9.5663408096E+00, 5.5996131724E+00, 1.2607325255E+00, 9.2910328777E-01, 7.3390272634E-01],
	[1.77900E+04, 9.5701892770E+00, 5.5994090530E+00, 1.2618754069E+00, 9.2975455111E-01, 7.3401642100E-01],
	[1.77950E+04, 9.5740382105E+00, 5.5992049984E+00, 1.2630190027E+00, 9.3040596688E-01, 7.3413008482E-01],
	[1.78000E+04, 9.5778876100E+00, 5.5990010085E+00, 1.2641633133E+00, 9.3105753491E-01, 7.3424371778E-01],
	[1.78050E+04, 9.5817374754E+00, 5.5987970834E+00, 1.2653083387E+00, 9.3170925501E-01, 7.3435731988E-01],
	[1.78100E+04, 9.5855878067E+00, 5.5985932230E+00, 1.2664540794E+00, 9.3236112702E-01, 7.3447089110E-01],
	[1.78150E+04, 9.5894386037E+00, 5.5983894271E+00, 1.2676005355E+00, 9.3301315076E-01, 7.3458443144E-01],
	[1.78200E+04, 9.5932898664E+00, 5.5981856959E+00, 1.2687477072E+00, 9.3366532606E-01, 7.3469794089E-01],
	[1.78250E+04, 9.5971415948E+00, 5.5979820293E+00, 1.2698955949E+00, 9.3431765275E-01, 7.3481141943E-01],
	[1.78300E+04, 9.6009937887E+00, 5.5977784272E+00, 1.2710441987E+00, 9.3497013066E-01, 7.3492486707E-01],
	[1.78350E+04, 9.6048464481E+00, 5.5975748896E+00, 1.2721935189E+00, 9.3562275961E-01, 7.3503828378E-01],
	[1.78400E+04, 9.6086995729E+00, 5.5973714164E+00, 1.2733435558E+00, 9.3627553943E-01, 7.3515166956E-01],
	[1.78450E+04, 9.6125531630E+00, 5.5971680077E+00, 1.2744943096E+00, 9.3692846994E-01, 7.3526502440E-01],
	[1.78500E+04, 9.6164072184E+00, 5.5969646633E+00, 1.2756457805E+00, 9.3758155098E-01, 7.3537834829E-01],
	[1.78550E+04, 9.6202617389E+00, 5.5967613832E+00, 1.2767979688E+00, 9.3823478237E-01, 7.3549164122E-01],
	[1.78600E+04, 9.6241167246E+00, 5.5965581675E+00, 1.2779508747E+00, 9.3888816394E-01, 7.3560490319E-01],
	[1.78650E+04, 9.6279721753E+00, 5.5963550160E+00, 1.2791044986E+00, 9.3954169551E-01, 7.3571813417E-01],
	[1.78700E+04, 9.6318280909E+00, 5.5961519287E+00, 1.2802588405E+00, 9.4019537691E-01, 7.3583133418E-01],
	[1.78750E+04, 9.6356844714E+00, 5.5959489056E+00, 1.2814139009E+00, 9.4084920797E-01, 7.3594450318E-01],
	[1.78800E+04, 9.6395413167E+00, 5.5957459467E+00, 1.2825696798E+00, 9.4150318852E-01, 7.3605764119E-01],
	[1.78850E+04, 9.6433986268E+00, 5.5955430518E+00, 1.2837261776E+00, 9.4215731837E-01, 7.3617074818E-01],
	[1.78900E+04, 9.6472564015E+00, 5.5953402211E+00, 1.2848833945E+00, 9.4281159736E-01, 7.3628382415E-01],
	[1.78950E+04, 9.6511146408E+00, 5.5951374543E+00, 1.2860413308E+00, 9.4346602532E-01, 7.3639686909E-01],
	[1.79000E+04, 9.6549733447E+00, 5.5949347516E+00, 1.2871999867E+00, 9.4412060206E-01, 7.3650988298E-01],
	[1.79050E+04, 9.6588325129E+00, 5.5947321128E+00, 1.2883593624E+00, 9.4477532743E-01, 7.3662286583E-01],
	[1.79100E+04, 9.6626921456E+00, 5.5945295379E+00, 1.2895194582E+00, 9.4543020123E-01, 7.3673581762E-01],
	[1.79150E+04, 9.6665522425E+00, 5.5943270269E+00, 1.2906802744E+00, 9.4608522330E-01, 7.3684873835E-01],
	[1.79200E+04, 9.6704128036E+00, 5.5941245798E+00, 1.2918418112E+00, 9.4674039347E-01, 7.3696162800E-01],
	[1.79250E+04, 9.6742738289E+00, 5.5939221964E+00, 1.2930040687E+00, 9.4739571156E-01, 7.3707448656E-01],
	[1.79300E+04, 9.6781353183E+00, 5.5937198768E+00, 1.2941670474E+00, 9.4805117740E-01, 7.3718731403E-01],
	[1.79350E+04, 9.6819972716E+00, 5.5935176209E+00, 1.2953307474E+00, 9.4870679081E-01, 7.3730011039E-01],
	[1.79400E+04, 9.6858596889E+00, 5.5933154287E+00, 1.2964951690E+00, 9.4936255162E-01, 7.3741287562E-01],
	[1.79450E+04, 9.6897225700E+00, 5.5931133002E+00, 1.2976603123E+00, 9.5001845966E-01, 7.3752560972E-01],
	[1.79500E+04, 9.6935859149E+00, 5.5929112353E+00, 1.2988261778E+00, 9.5067451475E-01, 7.3763831267E-01],
	[1.79550E+04, 9.6974497235E+00, 5.5927092339E+00, 1.2999927655E+00, 9.5133071671E-01, 7.3775098446E-01],
	[1.79600E+04, 9.7013139957E+00, 5.5925072961E+00, 1.3011600759E+00, 9.5198706538E-01, 7.3786362508E-01],
	[1.79650E+04, 9.7051787315E+00, 5.5923054218E+00, 1.3023281090E+00, 9.5264356058E-01, 7.3797623452E-01],
	[1.79700E+04, 9.7090439308E+00, 5.5921036110E+00, 1.3034968651E+00, 9.5330020213E-01, 7.3808881277E-01],
	[1.79750E+04, 9.7129095935E+00, 5.5919018635E+00, 1.3046663446E+00, 9.5395698986E-01, 7.3820135982E-01],
	[1.79800E+04, 9.7167757195E+00, 5.5917001795E+00, 1.3058365476E+00, 9.5461392360E-01, 7.3831387566E-01],
	[1.79850E+04, 9.7206423087E+00, 5.5914985588E+00, 1.3070074744E+00, 9.5527100316E-01, 7.3842636027E-01],
	[1.79900E+04, 9.7245093612E+00, 5.5912970014E+00, 1.3081791252E+00, 9.5592822839E-01, 7.3853881365E-01],
	[1.79950E+04, 9.7283768768E+00, 5.5910955073E+00, 1.3093515003E+00, 9.5658559910E-01, 7.3865123578E-01],
	[1.80000E+04, 9.7322448554E+00, 5.5908940765E+00, 1.3105245999E+00, 9.5724311511E-01, 7.3876362665E-01],
	[1.80050E+04, 9.7361132970E+00, 5.5906927088E+00, 1.3116984243E+00, 9.5790077626E-01, 7.3887598626E-01],
	[1.80100E+04, 9.7399822014E+00, 5.5904914043E+00, 1.3128729737E+00, 9.5855858237E-01, 7.3898831458E-01],
	[1.80150E+04, 9.7438515688E+00, 5.5902901629E+00, 1.3140482484E+00, 9.5921653325E-01, 7.3910061162E-01],
	[1.80200E+04, 9.7477213988E+00, 5.5900889846E+00, 1.3152242486E+00, 9.5987462875E-01, 7.3921287736E-01],
	[1.80250E+04, 9.7515916915E+00, 5.5898878694E+00, 1.3164009745E+00, 9.6053286869E-01, 7.3932511179E-01],
	[1.80300E+04, 9.7554624469E+00, 5.5896868172E+00, 1.3175784264E+00, 9.6119125288E-01, 7.3943731489E-01],
	[1.80350E+04, 9.7593336647E+00, 5.5894858279E+00, 1.3187566046E+00, 9.6184978115E-01, 7.3954948666E-01],
	[1.80400E+04, 9.7632053450E+00, 5.5892849016E+00, 1.3199355093E+00, 9.6250845334E-01, 7.3966162709E-01],
	[1.80450E+04, 9.7670774878E+00, 5.5890840382E+00, 1.3211151408E+00, 9.6316726925E-01, 7.3977373617E-01],
	[1.80500E+04, 9.7709500928E+00, 5.5888832376E+00, 1.3222954992E+00, 9.6382622873E-01, 7.3988581388E-01],
	[1.80550E+04, 9.7748231600E+00, 5.5886824999E+00, 1.3234765849E+00, 9.6448533159E-01, 7.3999786022E-01],
	[1.80600E+04, 9.7786966894E+00, 5.5884818250E+00, 1.3246583980E+00, 9.6514457766E-01, 7.4010987518E-01],
	[1.80650E+04, 9.7825706809E+00, 5.5882812128E+00, 1.3258409389E+00, 9.6580396677E-01, 7.4022185873E-01],
	[1.80700E+04, 9.7864451345E+00, 5.5880806633E+00, 1.3270242078E+00, 9.6646349873E-01, 7.4033381088E-01],
	[1.80750E+04, 9.7903200500E+00, 5.5878801765E+00, 1.3282082048E+00, 9.6712317337E-01, 7.4044573162E-01],
	[1.80800E+04, 9.7941954273E+00, 5.5876797524E+00, 1.3293929304E+00, 9.6778299052E-01, 7.4055762093E-01],
	[1.80850E+04, 9.7980712665E+00, 5.5874793908E+00, 1.3305783846E+00, 9.6844295001E-01, 7.4066947880E-01],
	[1.80900E+04, 9.8019475673E+00, 5.5872790919E+00, 1.3317645679E+00, 9.6910305165E-01, 7.4078130523E-01],
	[1.80950E+04, 9.8058243299E+00, 5.5870788554E+00, 1.3329514803E+00, 9.6976329527E-01, 7.4089310019E-01],
	[1.81000E+04, 9.8097015540E+00, 5.5868786815E+00, 1.3341391222E+00, 9.7042368070E-01, 7.4100486369E-01],
	[1.81050E+04, 9.8135792396E+00, 5.5866785700E+00, 1.3353274938E+00, 9.7108420775E-01, 7.4111659571E-01],
	[1.81100E+04, 9.8174573867E+00, 5.5864785209E+00, 1.3365165953E+00, 9.7174487626E-01, 7.4122829625E-01],
	[1.81150E+04, 9.8213359952E+00, 5.5862785342E+00, 1.3377064270E+00, 9.7240568605E-01, 7.4133996528E-01],
	[1.81200E+04, 9.8252150649E+00, 5.5860786099E+00, 1.3388969892E+00, 9.7306663695E-01, 7.4145160281E-01],
	[1.81250E+04, 9.8290945959E+00, 5.5858787479E+00, 1.3400882821E+00, 9.7372772877E-01, 7.4156320882E-01],
	[1.81300E+04, 9.8329745880E+00, 5.5856789481E+00, 1.3412803059E+00, 9.7438896134E-01, 7.4167478330E-01],
	[1.81350E+04, 9.8368550411E+00, 5.5854792106E+00, 1.3424730608E+00, 9.7505033448E-01, 7.4178632624E-01],
	[1.81400E+04, 9.8407359553E+00, 5.5852795353E+00, 1.3436665472E+00, 9.7571184803E-01, 7.4189783763E-01],
	[1.81450E+04, 9.8446173304E+00, 5.5850799222E+00, 1.3448607653E+00, 9.7637350180E-01, 7.4200931746E-01],
	[1.81500E+04, 9.8484991664E+00, 5.5848803711E+00, 1.3460557153E+00, 9.7703529562E-01, 7.4212076573E-01],
	[1.81550E+04, 9.8523814632E+00, 5.5846808822E+00, 1.3472513975E+00, 9.7769722931E-01, 7.4223218242E-01],
	[1.81600E+04, 9.8562642207E+00, 5.5844814554E+00, 1.3484478121E+00, 9.7835930269E-01, 7.4234356752E-01],
	[1.81650E+04, 9.8601474388E+00, 5.5842820905E+00, 1.3496449593E+00, 9.7902151560E-01, 7.4245492102E-01],
	[1.81700E+04, 9.8640311175E+00, 5.5840827876E+00, 1.3508428395E+00, 9.7968386785E-01, 7.4256624291E-01],
	[1.81750E+04, 9.8679152567E+00, 5.5838835467E+00, 1.3520414528E+00, 9.8034635926E-01, 7.4267753319E-01],
	[1.81800E+04, 9.8717998563E+00, 5.5836843677E+00, 1.3532407995E+00, 9.8100898967E-01, 7.4278879184E-01],
	[1.81850E+04, 9.8756849162E+00, 5.5834852506E+00, 1.3544408799E+00, 9.8167175889E-01, 7.4290001885E-01],
	[1.81900E+04, 9.8795704365E+00, 5.5832861953E+00, 1.3556416941E+00, 9.8233466675E-01, 7.4301121422E-01],
	[1.81950E+04, 9.8834564170E+00, 5.5830872018E+00, 1.3568432425E+00, 9.8299771307E-01, 7.4312237793E-01],
	[1.82000E+04, 9.8873428576E+00, 5.5828882700E+00, 1.3580455253E+00, 9.8366089767E-01, 7.4323350997E-01],
	[1.82050E+04, 9.8912297582E+00, 5.5826894000E+00, 1.3592485428E+00, 9.8432422039E-01, 7.4334461034E-01],
	[1.82100E+04, 9.8951171189E+00, 5.5824905917E+00, 1.3604522951E+00, 9.8498768104E-01, 7.4345567902E-01],
	[1.82150E+04, 9.8990049395E+00, 5.5822918451E+00, 1.3616567825E+00, 9.8565127944E-01, 7.4356671601E-01],
	[1.82200E+04, 9.9028932199E+00, 5.5820931601E+00, 1.3628620054E+00, 9.8631501542E-01, 7.4367772130E-01],
	[1.82250E+04, 9.9067819601E+00, 5.5818945366E+00, 1.3640679638E+00, 9.8697888881E-01, 7.4378869487E-01],
	[1.82300E+04, 9.9106711600E+00, 5.5816959747E+00, 1.3652746581E+00, 9.8764289942E-01, 7.4389963672E-01],
	[1.82350E+04, 9.9145608196E+00, 5.5814974743E+00, 1.3664820886E+00, 9.8830704708E-01, 7.4401054684E-01],
	[1.82400E+04, 9.9184509387E+00, 5.5812990354E+00, 1.3676902554E+00, 9.8897133162E-01, 7.4412142522E-01],
	[1.82450E+04, 9.9223415173E+00, 5.5811006580E+00, 1.3688991588E+00, 9.8963575285E-01, 7.4423227184E-01],
	[1.82500E+04, 9.9262325554E+00, 5.5809023419E+00, 1.3701087991E+00, 9.9030031059E-01, 7.4434308671E-01],
	[1.82550E+04, 9.9301240527E+00, 5.5807040872E+00, 1.3713191765E+00, 9.9096500468E-01, 7.4445386980E-01],
	[1.82600E+04, 9.9340160094E+00, 5.5805058939E+00, 1.3725302912E+00, 9.9162983494E-01, 7.4456462112E-01],
	[1.82650E+04, 9.9379084253E+00, 5.5803077618E+00, 1.3737421436E+00, 9.9229480119E-01, 7.4467534065E-01],
	[1.82700E+04, 9.9418013003E+00, 5.5801096910E+00, 1.3749547338E+00, 9.9295990324E-01, 7.4478602839E-01],
	[1.82750E+04, 9.9456946343E+00, 5.5799116814E+00, 1.3761680621E+00, 9.9362514093E-01, 7.4489668431E-01],
	[1.82800E+04, 9.9495884274E+00, 5.5797137331E+00, 1.3773821287E+00, 9.9429051408E-01, 7.4500730843E-01],
	[1.82850E+04, 9.9534826793E+00, 5.5795158458E+00, 1.3785969339E+00, 9.9495602251E-01, 7.4511790072E-01],
	[1.82900E+04, 9.9573773902E+00, 5.5793180197E+00, 1.3798124780E+00, 9.9562166604E-01, 7.4522846117E-01],
	[1.82950E+04, 9.9612725598E+00, 5.5791202547E+00, 1.3810287611E+00, 9.9628744450E-01, 7.4533898979E-01],
	[1.83000E+04, 9.9651681881E+00, 5.5789225508E+00, 1.3822457836E+00, 9.9695335770E-01, 7.4544948655E-01],
	[1.83050E+04, 9.9690642750E+00, 5.5787249078E+00, 1.3834635457E+00, 9.9761940548E-01, 7.4555995145E-01],
	[1.83100E+04, 9.9729608205E+00, 5.5785273258E+00, 1.3846820475E+00, 9.9828558765E-01, 7.4567038448E-01],
	[1.83150E+04, 9.9768578245E+00, 5.5783298048E+00, 1.3859012895E+00, 9.9895190404E-01, 7.4578078564E-01],
	[1.83200E+04, 9.9807552869E+00, 5.5781323447E+00, 1.3871212718E+00, 9.9961835446E-01, 7.4589115491E-01],
	[1.83250E+04, 9.9846532076E+00, 5.5779349454E+00, 1.3883419946E+00, 1.0002849388E+00, 7.4600149228E-01],
	[1.83300E+04, 9.9885515867E+00, 5.5777376070E+00, 1.3895634583E+00, 1.0009516567E+00, 7.4611179775E-01],
	[1.83350E+04, 9.9924504239E+00, 5.5775403294E+00, 1.3907856630E+00, 1.0016185082E+00, 7.4622207131E-01],
	[1.83400E+04, 9.9963497193E+00, 5.5773431125E+00, 1.3920086090E+00, 1.0022854930E+00, 7.4633231294E-01],
	[1.83450E+04, 1.0000249473E+01, 5.5771459564E+00, 1.3932322966E+00, 1.0029526110E+00, 7.4644252265E-01],
	[1.83500E+04, 1.0004149684E+01, 5.5769488610E+00, 1.3944567260E+00, 1.0036198619E+00, 7.4655270041E-01],
	[1.83550E+04, 1.0008050354E+01, 5.5767518262E+00, 1.3956818974E+00, 1.0042872457E+00, 7.4666284623E-01],
	[1.83600E+04, 1.0011951481E+01, 5.5765548520E+00, 1.3969078112E+00, 1.0049547620E+00, 7.4677296009E-01],
	[1.83650E+04, 1.0015887386E+01, 5.5763695794E+00, 1.3981344675E+00, 1.0056231353E+00, 7.4688304198E-01],
	[1.83700E+04, 1.0019827266E+01, 5.5761855501E+00, 1.3993618666E+00, 1.0062917164E+00, 7.4699309191E-01],
	[1.83750E+04, 1.0023767623E+01, 5.5760015768E+00, 1.4005900087E+00, 1.0069604311E+00, 7.4710310985E-01],
	[1.83800E+04, 1.0027708457E+01, 5.5758176598E+00, 1.4018188941E+00, 1.0076292795E+00, 7.4721309580E-01],
	[1.83850E+04, 1.0031649767E+01, 5.5756337988E+00, 1.4030485230E+00, 1.0082982611E+00, 7.4732304975E-01],
	[1.83900E+04, 1.0035591555E+01, 5.5754499938E+00, 1.4042788958E+00, 1.0089673760E+00, 7.4743297169E-01],
	[1.83950E+04, 1.0039533819E+01, 5.5752662449E+00, 1.4055100125E+00, 1.0096366239E+00, 7.4754286162E-01],
	[1.84000E+04, 1.0043476560E+01, 5.5750825520E+00, 1.4067418736E+00, 1.0103060046E+00, 7.4765271953E-01],
	[1.84050E+04, 1.0047419777E+01, 5.5748989150E+00, 1.4079744792E+00, 1.0109755180E+00, 7.4776254540E-01],
	[1.84100E+04, 1.0051363471E+01, 5.5747153340E+00, 1.4092078295E+00, 1.0116451639E+00, 7.4787233923E-01],
	[1.84150E+04, 1.0055307641E+01, 5.5745318089E+00, 1.4104419249E+00, 1.0123149421E+00, 7.4798210101E-01],
	[1.84200E+04, 1.0059252287E+01, 5.5743483396E+00, 1.4116767655E+00, 1.0129848524E+00, 7.4809183074E-01],
	[1.84250E+04, 1.0063197410E+01, 5.5741649261E+00, 1.4129123517E+00, 1.0136548946E+00, 7.4820152840E-01],
	[1.84300E+04, 1.0067143008E+01, 5.5739815685E+00, 1.4141486836E+00, 1.0143250687E+00, 7.4831119399E-01],
	[1.84350E+04, 1.0071089083E+01, 5.5737982666E+00, 1.4153857615E+00, 1.0149953743E+00, 7.4842082749E-01],
	[1.84400E+04, 1.0075035634E+01, 5.5736150204E+00, 1.4166235857E+00, 1.0156658114E+00, 7.4853042891E-01],
	[1.84450E+04, 1.0078982661E+01, 5.5734318300E+00, 1.4178621564E+00, 1.0163363797E+00, 7.4863999822E-01],
	[1.84500E+04, 1.0082930164E+01, 5.5732486952E+00, 1.4191014738E+00, 1.0170070791E+00, 7.4874953543E-01],
	[1.84550E+04, 1.0086878142E+01, 5.5730656161E+00, 1.4203415383E+00, 1.0176779094E+00, 7.4885904053E-01],
	[1.84600E+04, 1.0090826596E+01, 5.5728825926E+00, 1.4215823500E+00, 1.0183488704E+00, 7.4896851351E-01],
	[1.84650E+04, 1.0094775526E+01, 5.5726996246E+00, 1.4228239092E+00, 1.0190199620E+00, 7.4907795435E-01],
	[1.84700E+04, 1.0098724932E+01, 5.5725167122E+00, 1.4240662162E+00, 1.0196911839E+00, 7.4918736306E-01],
	[1.84750E+04, 1.0102674812E+01, 5.5723338553E+00, 1.4253092711E+00, 1.0203625360E+00, 7.4929673962E-01],
	[1.84800E+04, 1.0106625169E+01, 5.5721510539E+00, 1.4265530743E+00, 1.0210340181E+00, 7.4940608403E-01],
	[1.84850E+04, 1.0110576001E+01, 5.5719683079E+00, 1.4277976259E+00, 1.0217056300E+00, 7.4951539628E-01],
	[1.84900E+04, 1.0114527308E+01, 5.5717856173E+00, 1.4290429264E+00, 1.0223773716E+00, 7.4962467636E-01],
	[1.84950E+04, 1.0118479090E+01, 5.5716029822E+00, 1.4302889757E+00, 1.0230492427E+00, 7.4973392426E-01],
	[1.85000E+04, 1.0122431347E+01, 5.5714204023E+00, 1.4315357744E+00, 1.0237212431E+00, 7.4984313998E-01],
	[1.85050E+04, 1.0126384080E+01, 5.5712378778E+00, 1.4327833225E+00, 1.0243933726E+00, 7.4995232350E-01],
	[1.85100E+04, 1.0130337287E+01, 5.5710554086E+00, 1.4340316203E+00, 1.0250656310E+00, 7.5006147483E-01],
	[1.85150E+04, 1.0134290970E+01, 5.5708729946E+00, 1.4352806681E+00, 1.0257380182E+00, 7.5017059394E-01],
	[1.85200E+04, 1.0138245127E+01, 5.5706906359E+00, 1.4365304661E+00, 1.0264105340E+00, 7.5027968084E-01],
	[1.85250E+04, 1.0142199759E+01, 5.5705083324E+00, 1.4377810146E+00, 1.0270831782E+00, 7.5038873552E-01],
	[1.85300E+04, 1.0146154866E+01, 5.5703260840E+00, 1.4390323139E+00, 1.0277559507E+00, 7.5049775797E-01],
	[1.85350E+04, 1.0150110448E+01, 5.5701438907E+00, 1.4402843641E+00, 1.0284288512E+00, 7.5060674818E-01],
	[1.85400E+04, 1.0154066504E+01, 5.5699617526E+00, 1.4415371655E+00, 1.0291018796E+00, 7.5071570614E-01],
	[1.85450E+04, 1.0158023035E+01, 5.5697796695E+00, 1.4427907183E+00, 1.0297750356E+00, 7.5082463185E-01],
	[1.85500E+04, 1.0161980040E+01, 5.5695976414E+00, 1.4440450229E+00, 1.0304483192E+00, 7.5093352530E-01],
	[1.85550E+04, 1.0165937519E+01, 5.5694156684E+00, 1.4453000794E+00, 1.0311217302E+00, 7.5104238648E-01],
	[1.85600E+04, 1.0169895473E+01, 5.5692337503E+00, 1.4465558882E+00, 1.0317952683E+00, 7.5115121539E-01],
	[1.85650E+04, 1.0173853901E+01, 5.5690518872E+00, 1.4478124494E+00, 1.0324689335E+00, 7.5126001201E-01],
	[1.85700E+04, 1.0177812803E+01, 5.5688700790E+00, 1.4490697633E+00, 1.0331427254E+00, 7.5136877634E-01],
	[1.85750E+04, 1.0181772179E+01, 5.5686883256E+00, 1.4503278302E+00, 1.0338166440E+00, 7.5147750838E-01],
	[1.85800E+04, 1.0185732029E+01, 5.5685066271E+00, 1.4515866502E+00, 1.0344906890E+00, 7.5158620811E-01],
	[1.85850E+04, 1.0189692354E+01, 5.5683249834E+00, 1.4528462237E+00, 1.0351648603E+00, 7.5169487553E-01],
	[1.85900E+04, 1.0193653152E+01, 5.5681433945E+00, 1.4541065509E+00, 1.0358391577E+00, 7.5180351063E-01],
	[1.85950E+04, 1.0197614424E+01, 5.5679618604E+00, 1.4553676320E+00, 1.0365135811E+00, 7.5191211340E-01],
	[1.86000E+04, 1.0201576169E+01, 5.5677803810E+00, 1.4566294674E+00, 1.0371881302E+00, 7.5202068384E-01],
	[1.86050E+04, 1.0205538388E+01, 5.5675989563E+00, 1.4578920572E+00, 1.0378628048E+00, 7.5212922194E-01],
	[1.86100E+04, 1.0209501081E+01, 5.5674175862E+00, 1.4591554016E+00, 1.0385376049E+00, 7.5223772769E-01],
	[1.86150E+04, 1.0213464248E+01, 5.5672362707E+00, 1.4604195010E+00, 1.0392125301E+00, 7.5234620109E-01],
	[1.86200E+04, 1.0217427888E+01, 5.5670550099E+00, 1.4616843556E+00, 1.0398875804E+00, 7.5245464212E-01],
	[1.86250E+04, 1.0221392001E+01, 5.5668738036E+00, 1.4629499656E+00, 1.0405627556E+00, 7.5256305079E-01],
	[1.86300E+04, 1.0225356587E+01, 5.5666926519E+00, 1.4642163313E+00, 1.0412380554E+00, 7.5267142708E-01],
	[1.86350E+04, 1.0229321647E+01, 5.5665115546E+00, 1.4654834529E+00, 1.0419134798E+00, 7.5277977099E-01],
	[1.86400E+04, 1.0233287180E+01, 5.5663305119E+00, 1.4667513307E+00, 1.0425890284E+00, 7.5288808250E-01],
	[1.86450E+04, 1.0237253186E+01, 5.5661495235E+00, 1.4680199649E+00, 1.0432647012E+00, 7.5299636163E-01],
	[1.86500E+04, 1.0241219665E+01, 5.5659685896E+00, 1.4692893558E+00, 1.0439404980E+00, 7.5310460834E-01],
	[1.86550E+04, 1.0245186617E+01, 5.5657877101E+00, 1.4705595037E+00, 1.0446164186E+00, 7.5321282265E-01],
	[1.86600E+04, 1.0249154042E+01, 5.5656068849E+00, 1.4718304086E+00, 1.0452924627E+00, 7.5332100454E-01],
	[1.86650E+04, 1.0253121940E+01, 5.5654261141E+00, 1.4731020711E+00, 1.0459686303E+00, 7.5342915401E-01],
	[1.86700E+04, 1.0257090311E+01, 5.5652453975E+00, 1.4743744911E+00, 1.0466449212E+00, 7.5353727104E-01],
	[1.86750E+04, 1.0261059154E+01, 5.5650647352E+00, 1.4756476691E+00, 1.0473213351E+00, 7.5364535564E-01],
	[1.86800E+04, 1.0265028469E+01, 5.5648841271E+00, 1.4769216053E+00, 1.0479978720E+00, 7.5375340780E-01],
	[1.86850E+04, 1.0268998258E+01, 5.5647035732E+00, 1.4781962998E+00, 1.0486745315E+00, 7.5386142750E-01],
	[1.86900E+04, 1.0272968519E+01, 5.5645230734E+00, 1.4794717531E+00, 1.0493513136E+00, 7.5396941475E-01],
	[1.86950E+04, 1.0276939252E+01, 5.5643426278E+00, 1.4807479652E+00, 1.0500282181E+00, 7.5407736953E-01],
	[1.87000E+04, 1.0280910457E+01, 5.5641622363E+00, 1.4820249365E+00, 1.0507052447E+00, 7.5418529184E-01],
	[1.87050E+04, 1.0284882135E+01, 5.5639818989E+00, 1.4833026672E+00, 1.0513823934E+00, 7.5429318168E-01],
	[1.87100E+04, 1.0288854285E+01, 5.5638016155E+00, 1.4845811575E+00, 1.0520596638E+00, 7.5440103903E-01],
	[1.87150E+04, 1.0292826907E+01, 5.5636213862E+00, 1.4858604078E+00, 1.0527370560E+00, 7.5450886389E-01],
	[1.87200E+04, 1.0296800001E+01, 5.5634412108E+00, 1.4871404182E+00, 1.0534145696E+00, 7.5461665625E-01],
	[1.87250E+04, 1.0300773567E+01, 5.5632610893E+00, 1.4884211890E+00, 1.0540922044E+00, 7.5472441612E-01],
	[1.87300E+04, 1.0304747605E+01, 5.5630810218E+00, 1.4897027204E+00, 1.0547699604E+00, 7.5483214347E-01],
	[1.87350E+04, 1.0308722115E+01, 5.5629010082E+00, 1.4909850128E+00, 1.0554478374E+00, 7.5493983830E-01],
	[1.87400E+04, 1.0312697097E+01, 5.5627210484E+00, 1.4922680663E+00, 1.0561258351E+00, 7.5504750062E-01],
	[1.87450E+04, 1.0316672550E+01, 5.5625411425E+00, 1.4935518812E+00, 1.0568039533E+00, 7.5515513041E-01],
	[1.87500E+04, 1.0320648475E+01, 5.5623612903E+00, 1.4948364577E+00, 1.0574821920E+00, 7.5526272766E-01],
	[1.87550E+04, 1.0324624871E+01, 5.5621814919E+00, 1.4961217961E+00, 1.0581605509E+00, 7.5537029237E-01],
	[1.87600E+04, 1.0328601739E+01, 5.5620017473E+00, 1.4974078967E+00, 1.0588390298E+00, 7.5547782453E-01],
	[1.87650E+04, 1.0332579079E+01, 5.5618220563E+00, 1.4986947596E+00, 1.0595176286E+00, 7.5558532414E-01],
	[1.87700E+04, 1.0336556890E+01, 5.5616424191E+00, 1.4999823852E+00, 1.0601963471E+00, 7.5569279119E-01],
	[1.87750E+04, 1.0340535172E+01, 5.5614628355E+00, 1.5012707736E+00, 1.0608751850E+00, 7.5580022568E-01],
	[1.87800E+04, 1.0344513925E+01, 5.5612833055E+00, 1.5025599252E+00, 1.0615541423E+00, 7.5590762759E-01],
	[1.87850E+04, 1.0348493149E+01, 5.5611038290E+00, 1.5038498402E+00, 1.0622332188E+00, 7.5601499692E-01],
	[1.87900E+04, 1.0352472845E+01, 5.5609244062E+00, 1.5051405188E+00, 1.0629124142E+00, 7.5612233367E-01],
	[1.87950E+04, 1.0356453011E+01, 5.5607450368E+00, 1.5064319613E+00, 1.0635917284E+00, 7.5622963783E-01],
	[1.88000E+04, 1.0360433648E+01, 5.5605657210E+00, 1.5077241679E+00, 1.0642711612E+00, 7.5633690940E-01],
	[1.88050E+04, 1.0364414757E+01, 5.5603864586E+00, 1.5090171389E+00, 1.0649507125E+00, 7.5644414836E-01],
	[1.88100E+04, 1.0368396336E+01, 5.5602072497E+00, 1.5103108746E+00, 1.0656303820E+00, 7.5655135472E-01],
	[1.88150E+04, 1.0372378385E+01, 5.5600280941E+00, 1.5116053750E+00, 1.0663101695E+00, 7.5665852846E-01],
	[1.88200E+04, 1.0376360906E+01, 5.5598489920E+00, 1.5129006407E+00, 1.0669900750E+00, 7.5676566958E-01],
	[1.88250E+04, 1.0380343897E+01, 5.5596699431E+00, 1.5141966717E+00, 1.0676700982E+00, 7.5687277808E-01],
	[1.88300E+04, 1.0384327358E+01, 5.5594909476E+00, 1.5154934683E+00, 1.0683502389E+00, 7.5697985394E-01],
	[1.88350E+04, 1.0388311290E+01, 5.5593120054E+00, 1.5167910307E+00, 1.0690304970E+00, 7.5708689717E-01],
	[1.88400E+04, 1.0392295692E+01, 5.5591331164E+00, 1.5180893593E+00, 1.0697108723E+00, 7.5719390775E-01],
	[1.88450E+04, 1.0396280565E+01, 5.5589542807E+00, 1.5193884543E+00, 1.0703913645E+00, 7.5730088569E-01],
	[1.88500E+04, 1.0400265908E+01, 5.5587754981E+00, 1.5206883159E+00, 1.0710719736E+00, 7.5740783097E-01],
	[1.88550E+04, 1.0404251721E+01, 5.5585967687E+00, 1.5219889443E+00, 1.0717526993E+00, 7.5751474359E-01],
	[1.88600E+04, 1.0408238004E+01, 5.5584180925E+00, 1.5232903399E+00, 1.0724335415E+00, 7.5762162354E-01],
	[1.88650E+04, 1.0412224757E+01, 5.5582394693E+00, 1.5245925028E+00, 1.0731145000E+00, 7.5772847082E-01],
	[1.88700E+04, 1.0416211980E+01, 5.5580608992E+00, 1.5258954333E+00, 1.0737955746E+00, 7.5783528543E-01],
	[1.88750E+04, 1.0420199673E+01, 5.5578823822E+00, 1.5271991317E+00, 1.0744767651E+00, 7.5794206735E-01],
	[1.88800E+04, 1.0424187836E+01, 5.5577039182E+00, 1.5285035982E+00, 1.0751580713E+00, 7.5804881659E-01],
	[1.88850E+04, 1.0428176468E+01, 5.5575255071E+00, 1.5298088331E+00, 1.0758394931E+00, 7.5815553313E-01],
	[1.88900E+04, 1.0432165571E+01, 5.5573471490E+00, 1.5311148366E+00, 1.0765210303E+00, 7.5826221697E-01],
	[1.88950E+04, 1.0436155143E+01, 5.5571688439E+00, 1.5324216089E+00, 1.0772026827E+00, 7.5836886811E-01],
	[1.89000E+04, 1.0440145184E+01, 5.5569905916E+00, 1.5337291503E+00, 1.0778844501E+00, 7.5847548654E-01],
	[1.89050E+04, 1.0444135695E+01, 5.5568123922E+00, 1.5350374611E+00, 1.0785663324E+00, 7.5858207225E-01],
	[1.89100E+04, 1.0448126675E+01, 5.5566342457E+00, 1.5363465415E+00, 1.0792483294E+00, 7.5868862524E-01],
	[1.89150E+04, 1.0452118125E+01, 5.5564561519E+00, 1.5376563917E+00, 1.0799304408E+00, 7.5879514550E-01],
	[1.89200E+04, 1.0456110044E+01, 5.5562781109E+00, 1.5389670121E+00, 1.0806126666E+00, 7.5890163303E-01],
	[1.89250E+04, 1.0460102432E+01, 5.5561001227E+00, 1.5402784028E+00, 1.0812950065E+00, 7.5900808783E-01],
	[1.89300E+04, 1.0464095289E+01, 5.5559221872E+00, 1.5415905641E+00, 1.0819774603E+00, 7.5911450988E-01],
	[1.89350E+04, 1.0468088615E+01, 5.5557443044E+00, 1.5429034962E+00, 1.0826600279E+00, 7.5922089918E-01],
	[1.89400E+04, 1.0472082410E+01, 5.5555664742E+00, 1.5442171995E+00, 1.0833427091E+00, 7.5932725574E-01],
	[1.89450E+04, 1.0476076674E+01, 5.5553886967E+00, 1.5455316740E+00, 1.0840255038E+00, 7.5943357953E-01],
	[1.89500E+04, 1.0480071408E+01, 5.5552109717E+00, 1.5468469202E+00, 1.0847084116E+00, 7.5953987056E-01],
	[1.89550E+04, 1.0484066609E+01, 5.5550332994E+00, 1.5481629383E+00, 1.0853914325E+00, 7.5964612882E-01],
	[1.89600E+04, 1.0488062280E+01, 5.5548556795E+00, 1.5494797284E+00, 1.0860745663E+00, 7.5975235431E-01],
	[1.89650E+04, 1.0492058419E+01, 5.5546781122E+00, 1.5507972908E+00, 1.0867578128E+00, 7.5985854702E-01],
	[1.89700E+04, 1.0496055027E+01, 5.5545005974E+00, 1.5521156259E+00, 1.0874411718E+00, 7.5996470695E-01],
	[1.89750E+04, 1.0500052103E+01, 5.5543231350E+00, 1.5534347338E+00, 1.0881246431E+00, 7.6007083409E-01],
	[1.89800E+04, 1.0504049648E+01, 5.5541457251E+00, 1.5547546148E+00, 1.0888082266E+00, 7.6017692843E-01],
	[1.89850E+04, 1.0508047661E+01, 5.5539683675E+00, 1.5560752691E+00, 1.0894919221E+00, 7.6028298998E-01],
	[1.89900E+04, 1.0512046142E+01, 5.5537910623E+00, 1.5573966970E+00, 1.0901757294E+00, 7.6038901872E-01],
	[1.89950E+04, 1.0516045092E+01, 5.5536138094E+00, 1.5587188988E+00, 1.0908596483E+00, 7.6049501466E-01],
	[1.90000E+04, 1.0520044510E+01, 5.5534366089E+00, 1.5600418747E+00, 1.0915436786E+00, 7.6060097778E-01],
	[1.90050E+04, 1.0524044396E+01, 5.5532594606E+00, 1.5613656248E+00, 1.0922278202E+00, 7.6070690808E-01],
	[1.90100E+04, 1.0528044750E+01, 5.5530823646E+00, 1.5626901496E+00, 1.0929120729E+00, 7.6081280556E-01],
	[1.90150E+04, 1.0532045572E+01, 5.5529053208E+00, 1.5640154492E+00, 1.0935964365E+00, 7.6091867021E-01],
	[1.90200E+04, 1.0536046861E+01, 5.5527283292E+00, 1.5653415239E+00, 1.0942809108E+00, 7.6102450202E-01],
	[1.90250E+04, 1.0540048619E+01, 5.5525513897E+00, 1.5666683740E+00, 1.0949654956E+00, 7.6113030099E-01],
	[1.90300E+04, 1.0544050844E+01, 5.5523745024E+00, 1.5679959996E+00, 1.0956501908E+00, 7.6123606711E-01],
	[1.90350E+04, 1.0548053538E+01, 5.5521976671E+00, 1.5693244010E+00, 1.0963349962E+00, 7.6134180037E-01],
	[1.90400E+04, 1.0552056698E+01, 5.5520208840E+00, 1.5706535786E+00, 1.0970199116E+00, 7.6144750076E-01],
	[1.90450E+04, 1.0556060327E+01, 5.5518441529E+00, 1.5719835324E+00, 1.0977049368E+00, 7.6155316828E-01],
	[1.90500E+04, 1.0560064422E+01, 5.5516674738E+00, 1.5733142629E+00, 1.0983900716E+00, 7.6165880293E-01],
	[1.90550E+04, 1.0564068985E+01, 5.5514908467E+00, 1.5746457702E+00, 1.0990753160E+00, 7.6176440468E-01],
	[1.90600E+04, 1.0568074016E+01, 5.5513142716E+00, 1.5759780545E+00, 1.0997606696E+00, 7.6186997355E-01],
	[1.90650E+04, 1.0572079514E+01, 5.5511377483E+00, 1.5773111162E+00, 1.1004461323E+00, 7.6197550952E-01],
	[1.90700E+04, 1.0576085479E+01, 5.5509612770E+00, 1.5786449555E+00, 1.1011317039E+00, 7.6208101258E-01],
	[1.90750E+04, 1.0580091911E+01, 5.5507848576E+00, 1.5799795726E+00, 1.1018173843E+00, 7.6218648273E-01],
	[1.90800E+04, 1.0584098810E+01, 5.5506084900E+00, 1.5813149678E+00, 1.1025031732E+00, 7.6229191996E-01],
	[1.90850E+04, 1.0588106176E+01, 5.5504321742E+00, 1.5826511413E+00, 1.1031890705E+00, 7.6239732426E-01],
	[1.90900E+04, 1.0592114010E+01, 5.5502559102E+00, 1.5839880933E+00, 1.1038750760E+00, 7.6250269564E-01],
	[1.90950E+04, 1.0596140528E+01, 5.5500851243E+00, 1.5853258243E+00, 1.1045616025E+00, 7.6260803407E-01],
	[1.91000E+04, 1.0600190888E+01, 5.5499213451E+00, 1.5866643343E+00, 1.1052487675E+00, 7.6271333956E-01],
	[1.91050E+04, 1.0604241735E+01, 5.5497576136E+00, 1.5880036236E+00, 1.1059360419E+00, 7.6281861210E-01],
	[1.91100E+04, 1.0608293070E+01, 5.5495939297E+00, 1.5893436925E+00, 1.1066234256E+00, 7.6292385169E-01],
	[1.91150E+04, 1.0612344892E+01, 5.5494302935E+00, 1.5906845412E+00, 1.1073109184E+00, 7.6302905831E-01],
	[1.91200E+04, 1.0616397201E+01, 5.5492667049E+00, 1.5920261700E+00, 1.1079985201E+00, 7.6313423196E-01],
	[1.91250E+04, 1.0620449998E+01, 5.5491031639E+00, 1.5933685791E+00, 1.1086862306E+00, 7.6323937263E-01],
	[1.91300E+04, 1.0624503282E+01, 5.5489396705E+00, 1.5947117688E+00, 1.1093740496E+00, 7.6334448032E-01],
	[1.91350E+04, 1.0628557052E+01, 5.5487762246E+00, 1.5960557393E+00, 1.1100619770E+00, 7.6344955502E-01],
	[1.91400E+04, 1.0632611310E+01, 5.5486128262E+00, 1.5974004909E+00, 1.1107500126E+00, 7.6355459673E-01],
	[1.91450E+04, 1.0636666055E+01, 5.5484494754E+00, 1.5987460238E+00, 1.1114381562E+00, 7.6365960543E-01],
	[1.91500E+04, 1.0640721286E+01, 5.5482861720E+00, 1.6000923383E+00, 1.1121264076E+00, 7.6376458113E-01],
	[1.91550E+04, 1.0644777004E+01, 5.5481229160E+00, 1.6014394347E+00, 1.1128147667E+00, 7.6386952382E-01],
	[1.91600E+04, 1.0648833209E+01, 5.5479597074E+00, 1.6027873130E+00, 1.1135032333E+00, 7.6397443348E-01],
	[1.91650E+04, 1.0652889901E+01, 5.5477965462E+00, 1.6041359738E+00, 1.1141918072E+00, 7.6407931012E-01],
	[1.91700E+04, 1.0656947079E+01, 5.5476334324E+00, 1.6054854170E+00, 1.1148804882E+00, 7.6418415373E-01],
	[1.91750E+04, 1.0661004744E+01, 5.5474703659E+00, 1.6068356432E+00, 1.1155692762E+00, 7.6428896430E-01],
	[1.91800E+04, 1.0665062895E+01, 5.5473073467E+00, 1.6081866523E+00, 1.1162581709E+00, 7.6439374183E-01],
	[1.91850E+04, 1.0669121532E+01, 5.5471443748E+00, 1.6095384448E+00, 1.1169471722E+00, 7.6449848631E-01],
	[1.91900E+04, 1.0673180656E+01, 5.5469814502E+00, 1.6108910209E+00, 1.1176362800E+00, 7.6460319773E-01],
	[1.91950E+04, 1.0677240266E+01, 5.5468185728E+00, 1.6122443808E+00, 1.1183254939E+00, 7.6470787609E-01],
	[1.92000E+04, 1.0681300363E+01, 5.5466557425E+00, 1.6135985248E+00, 1.1190148140E+00, 7.6481252139E-01],
	[1.92050E+04, 1.0685360945E+01, 5.5464929595E+00, 1.6149534531E+00, 1.1197042399E+00, 7.6491713361E-01],
	[1.92100E+04, 1.0689422013E+01, 5.5463302236E+00, 1.6163091660E+00, 1.1203937714E+00, 7.6502171275E-01],
	[1.92150E+04, 1.0693483568E+01, 5.5461675348E+00, 1.6176656636E+00, 1.1210834086E+00, 7.6512625881E-01],
	[1.92200E+04, 1.0697545608E+01, 5.5460048932E+00, 1.6190229464E+00, 1.1217731510E+00, 7.6523077178E-01],
	[1.92250E+04, 1.0701608134E+01, 5.5458422986E+00, 1.6203810145E+00, 1.1224629986E+00, 7.6533525166E-01],
	[1.92300E+04, 1.0705671146E+01, 5.5456797510E+00, 1.6217398681E+00, 1.1231529512E+00, 7.6543969843E-01],
	[1.92350E+04, 1.0709734643E+01, 5.5455172505E+00, 1.6230995076E+00, 1.1238430086E+00, 7.6554411209E-01],
	[1.92400E+04, 1.0713798626E+01, 5.5453547969E+00, 1.6244599332E+00, 1.1245331706E+00, 7.6564849264E-01],
	[1.92450E+04, 1.0717863095E+01, 5.5451923904E+00, 1.6258211450E+00, 1.1252234370E+00, 7.6575284008E-01],
	[1.92500E+04, 1.0721928049E+01, 5.5450300308E+00, 1.6271831435E+00, 1.1259138077E+00, 7.6585715439E-01],
	[1.92550E+04, 1.0725993488E+01, 5.5448677181E+00, 1.6285459287E+00, 1.1266042825E+00, 7.6596143557E-01],
	[1.92600E+04, 1.0730059413E+01, 5.5447054522E+00, 1.6299095011E+00, 1.1272948613E+00, 7.6606568362E-01],
	[1.92650E+04, 1.0734125824E+01, 5.5445432333E+00, 1.6312738607E+00, 1.1279855437E+00, 7.6616989852E-01],
	[1.92700E+04, 1.0738192719E+01, 5.5443810612E+00, 1.6326390079E+00, 1.1286763297E+00, 7.6627408028E-01],
	[1.92750E+04, 1.0742260099E+01, 5.5442189359E+00, 1.6340049430E+00, 1.1293672190E+00, 7.6637822889E-01],
	[1.92800E+04, 1.0746327965E+01, 5.5440568574E+00, 1.6353716661E+00, 1.1300582116E+00, 7.6648234434E-01],
	[1.92850E+04, 1.0750396316E+01, 5.5438948257E+00, 1.6367391775E+00, 1.1307493071E+00, 7.6658642664E-01],
	[1.92900E+04, 1.0754465151E+01, 5.5437328407E+00, 1.6381074776E+00, 1.1314405055E+00, 7.6669047576E-01],
	[1.92950E+04, 1.0758534472E+01, 5.5435709024E+00, 1.6394765664E+00, 1.1321318066E+00, 7.6679449171E-01],
	[1.93000E+04, 1.0762604277E+01, 5.5434090108E+00, 1.6408464443E+00, 1.1328232101E+00, 7.6689847449E-01],
	[1.93050E+04, 1.0766674567E+01, 5.5432471658E+00, 1.6422171115E+00, 1.1335147159E+00, 7.6700242408E-01],
	[1.93100E+04, 1.0770745342E+01, 5.5430853675E+00, 1.6435885683E+00, 1.1342063238E+00, 7.6710634048E-01],
	[1.93150E+04, 1.0774816601E+01, 5.5429236158E+00, 1.6449608150E+00, 1.1348980337E+00, 7.6721022369E-01],
	[1.93200E+04, 1.0778888345E+01, 5.5427619107E+00, 1.6463338517E+00, 1.1355898453E+00, 7.6731407370E-01],
	[1.93250E+04, 1.0782960573E+01, 5.5426002522E+00, 1.6477076787E+00, 1.1362817585E+00, 7.6741789051E-01],
	[1.93300E+04, 1.0787033285E+01, 5.5424386402E+00, 1.6490822963E+00, 1.1369737731E+00, 7.6752167411E-01],
	[1.93350E+04, 1.0791106482E+01, 5.5422770747E+00, 1.6504577047E+00, 1.1376658890E+00, 7.6762542450E-01],
	[1.93400E+04, 1.0795180164E+01, 5.5421155556E+00, 1.6518339042E+00, 1.1383581058E+00, 7.6772914167E-01],
	[1.93450E+04, 1.0799254329E+01, 5.5419540831E+00, 1.6532108950E+00, 1.1390504236E+00, 7.6783282561E-01],
	[1.93500E+04, 1.0803328978E+01, 5.5417926570E+00, 1.6545886774E+00, 1.1397428420E+00, 7.6793647633E-01],
	[1.93550E+04, 1.0807404112E+01, 5.5416312772E+00, 1.6559672517E+00, 1.1404353609E+00, 7.6804009381E-01],
	[1.93600E+04, 1.0811479730E+01, 5.5414699439E+00, 1.6573466180E+00, 1.1411279802E+00, 7.6814367805E-01],
	[1.93650E+04, 1.0815555831E+01, 5.5413086569E+00, 1.6587267766E+00, 1.1418206996E+00, 7.6824722905E-01],
	[1.93700E+04, 1.0819632417E+01, 5.5411474162E+00, 1.6601077278E+00, 1.1425135189E+00, 7.6835074681E-01],
	[1.93750E+04, 1.0823709486E+01, 5.5409862219E+00, 1.6614894718E+00, 1.1432064381E+00, 7.6845423131E-01],
	[1.93800E+04, 1.0827787039E+01, 5.5408250738E+00, 1.6628720089E+00, 1.1438994569E+00, 7.6855768255E-01],
	[1.93850E+04, 1.0831865075E+01, 5.5406639720E+00, 1.6642553394E+00, 1.1445925751E+00, 7.6866110053E-01],
	[1.93900E+04, 1.0835943595E+01, 5.5405029164E+00, 1.6656394634E+00, 1.1452857925E+00, 7.6876448524E-01],
	[1.93950E+04, 1.0840022599E+01, 5.5403419070E+00, 1.6670243812E+00, 1.1459791091E+00, 7.6886783668E-01],
	[1.94000E+04, 1.0844102086E+01, 5.5401809438E+00, 1.6684100931E+00, 1.1466725245E+00, 7.6897115485E-01],
	[1.94050E+04, 1.0848182056E+01, 5.5400200268E+00, 1.6697965994E+00, 1.1473660386E+00, 7.6907443973E-01],
	[1.94100E+04, 1.0852262510E+01, 5.5398591559E+00, 1.6711839002E+00, 1.1480596513E+00, 7.6917769133E-01],
	[1.94150E+04, 1.0856343447E+01, 5.5396983311E+00, 1.6725719959E+00, 1.1487533623E+00, 7.6928090963E-01],
	[1.94200E+04, 1.0860424867E+01, 5.5395375523E+00, 1.6739608866E+00, 1.1494471715E+00, 7.6938409464E-01],
	[1.94250E+04, 1.0864506771E+01, 5.5393768197E+00, 1.6753505727E+00, 1.1501410787E+00, 7.6948724636E-01],
	[1.94300E+04, 1.0868589157E+01, 5.5392161330E+00, 1.6767410543E+00, 1.1508350838E+00, 7.6959036476E-01],
	[1.94350E+04, 1.0872672027E+01, 5.5390554924E+00, 1.6781323318E+00, 1.1515291864E+00, 7.6969344986E-01],
	[1.94400E+04, 1.0876755379E+01, 5.5388948977E+00, 1.6795244054E+00, 1.1522233866E+00, 7.6979650165E-01],
	[1.94450E+04, 1.0880839214E+01, 5.5387343490E+00, 1.6809172753E+00, 1.1529176840E+00, 7.6989952012E-01],
	[1.94500E+04, 1.0884923532E+01, 5.5385738462E+00, 1.6823109418E+00, 1.1536120785E+00, 7.7000250527E-01],
	[1.94550E+04, 1.0889008333E+01, 5.5384133893E+00, 1.6837054051E+00, 1.1543065700E+00, 7.7010545709E-01],
	[1.94600E+04, 1.0893093616E+01, 5.5382529783E+00, 1.6851006655E+00, 1.1550011581E+00, 7.7020837558E-01],
	[1.94650E+04, 1.0897179382E+01, 5.5380926132E+00, 1.6864967232E+00, 1.1556958429E+00, 7.7031126074E-01],
	[1.94700E+04, 1.0901265630E+01, 5.5379322939E+00, 1.6878935786E+00, 1.1563906240E+00, 7.7041411255E-01],
	[1.94750E+04, 1.0905352361E+01, 5.5377720204E+00, 1.6892912317E+00, 1.1570855014E+00, 7.7051693103E-01],
	[1.94800E+04, 1.0909439574E+01, 5.5376117927E+00, 1.6906896830E+00, 1.1577804748E+00, 7.7061971615E-01],
	[1.94850E+04, 1.0913527269E+01, 5.5374516107E+00, 1.6920889326E+00, 1.1584755440E+00, 7.7072246793E-01],
	[1.94900E+04, 1.0917615447E+01, 5.5372914744E+00, 1.6934889808E+00, 1.1591707089E+00, 7.7082518635E-01],
	[1.94950E+04, 1.0921704107E+01, 5.5371313839E+00, 1.6948898278E+00, 1.1598659693E+00, 7.7092787140E-01],
	[1.95000E+04, 1.0925793249E+01, 5.5369713390E+00, 1.6962914739E+00, 1.1605613250E+00, 7.7103052310E-01],
	[1.95050E+04, 1.0929882873E+01, 5.5368113398E+00, 1.6976939194E+00, 1.1612567759E+00, 7.7113314143E-01],
	[1.95100E+04, 1.0933972979E+01, 5.5366513863E+00, 1.6990971644E+00, 1.1619523217E+00, 7.7123572638E-01],
	[1.95150E+04, 1.0938063567E+01, 5.5364914783E+00, 1.7005012093E+00, 1.1626479622E+00, 7.7133827796E-01],
	[1.95200E+04, 1.0942154637E+01, 5.5363316159E+00, 1.7019060543E+00, 1.1633436974E+00, 7.7144079615E-01],
	[1.95250E+04, 1.0946246188E+01, 5.5361717991E+00, 1.7033116997E+00, 1.1640395270E+00, 7.7154328097E-01],
	[1.95300E+04, 1.0950338222E+01, 5.5360120278E+00, 1.7047181456E+00, 1.1647354508E+00, 7.7164573239E-01],
	[1.95350E+04, 1.0954430737E+01, 5.5358523020E+00, 1.7061253924E+00, 1.1654314687E+00, 7.7174815042E-01],
	[1.95400E+04, 1.0958523733E+01, 5.5356926217E+00, 1.7075334402E+00, 1.1661275805E+00, 7.7185053506E-01],
	[1.95450E+04, 1.0962617211E+01, 5.5355329869E+00, 1.7089422895E+00, 1.1668237860E+00, 7.7195288630E-01],
	[1.95500E+04, 1.0966711171E+01, 5.5353733975E+00, 1.7103519403E+00, 1.1675200850E+00, 7.7205520413E-01],
	[1.95550E+04, 1.0970805611E+01, 5.5352138535E+00, 1.7117623930E+00, 1.1682164773E+00, 7.7215748856E-01],
	[1.95600E+04, 1.0974900534E+01, 5.5350543549E+00, 1.7131736477E+00, 1.1689129628E+00, 7.7225973957E-01],
	[1.95650E+04, 1.0978995937E+01, 5.5348949016E+00, 1.7145857049E+00, 1.1696095413E+00, 7.7236195717E-01],
	[1.95700E+04, 1.0983091822E+01, 5.5347354937E+00, 1.7159985646E+00, 1.1703062126E+00, 7.7246414135E-01],
	[1.95750E+04, 1.0987188187E+01, 5.5345761311E+00, 1.7174122272E+00, 1.1710029765E+00, 7.7256629211E-01],
	[1.95800E+04, 1.0991285034E+01, 5.5344168138E+00, 1.7188266929E+00, 1.1716998329E+00, 7.7266840944E-01],
	[1.95850E+04, 1.0995382362E+01, 5.5342575417E+00, 1.7202419619E+00, 1.1723967815E+00, 7.7277049334E-01],
	[1.95900E+04, 1.0999480170E+01, 5.5340983149E+00, 1.7216580345E+00, 1.1730938222E+00, 7.7287254381E-01],
	[1.95950E+04, 1.1003578460E+01, 5.5339391333E+00, 1.7230749111E+00, 1.1737909549E+00, 7.7297456084E-01],
	[1.96000E+04, 1.1007677230E+01, 5.5337799969E+00, 1.7244925917E+00, 1.1744881792E+00, 7.7307654443E-01],
	[1.96050E+04, 1.1011776481E+01, 5.5336209057E+00, 1.7259110766E+00, 1.1751854952E+00, 7.7317849457E-01],
	[1.96100E+04, 1.1015876212E+01, 5.5334618596E+00, 1.7273303662E+00, 1.1758829025E+00, 7.7328041127E-01],
	[1.96150E+04, 1.1019976425E+01, 5.5333028586E+00, 1.7287504607E+00, 1.1765804010E+00, 7.7338229452E-01],
	[1.96200E+04, 1.1024077117E+01, 5.5331439027E+00, 1.7301713603E+00, 1.1772779905E+00, 7.7348414431E-01],
	[1.96250E+04, 1.1028178290E+01, 5.5329849919E+00, 1.7315930652E+00, 1.1779756708E+00, 7.7358596065E-01],
	[1.96300E+04, 1.1032279944E+01, 5.5328261261E+00, 1.7330155757E+00, 1.1786734418E+00, 7.7368774352E-01],
	[1.96350E+04, 1.1036382078E+01, 5.5326673053E+00, 1.7344388921E+00, 1.1793713033E+00, 7.7378949293E-01],
	[1.96400E+04, 1.1040484692E+01, 5.5325085295E+00, 1.7358630147E+00, 1.1800692551E+00, 7.7389120887E-01],
	[1.96450E+04, 1.1044587786E+01, 5.5323497987E+00, 1.7372879436E+00, 1.1807672970E+00, 7.7399289134E-01],
	[1.96500E+04, 1.1048691361E+01, 5.5321911129E+00, 1.7387136791E+00, 1.1814654289E+00, 7.7409454033E-01],
	[1.96550E+04, 1.1052795415E+01, 5.5320324720E+00, 1.7401402215E+00, 1.1821636505E+00, 7.7419615585E-01],
	[1.96600E+04, 1.1056899949E+01, 5.5318738759E+00, 1.7415675710E+00, 1.1828619617E+00, 7.7429773788E-01],
	[1.96650E+04, 1.1061004964E+01, 5.5317153248E+00, 1.7429957279E+00, 1.1835603623E+00, 7.7439928643E-01],
	[1.96700E+04, 1.1065110458E+01, 5.5315568185E+00, 1.7444246924E+00, 1.1842588521E+00, 7.7450080150E-01],
	[1.96750E+04, 1.1069216432E+01, 5.5313983570E+00, 1.7458544648E+00, 1.1849574310E+00, 7.7460228307E-01],
	[1.96800E+04, 1.1073322886E+01, 5.5312399403E+00, 1.7472850453E+00, 1.1856560988E+00, 7.7470373115E-01],
	[1.96850E+04, 1.1077429819E+01, 5.5310815684E+00, 1.7487164342E+00, 1.1863548552E+00, 7.7480514573E-01],
	[1.96900E+04, 1.1081537232E+01, 5.5309232413E+00, 1.7501486317E+00, 1.1870537002E+00, 7.7490652681E-01],
	[1.96950E+04, 1.1085645124E+01, 5.5307649589E+00, 1.7515816381E+00, 1.1877526335E+00, 7.7500787438E-01],
	[1.97000E+04, 1.1089753496E+01, 5.5306067212E+00, 1.7530154536E+00, 1.1884516549E+00, 7.7510918846E-01],
	[1.97050E+04, 1.1093862348E+01, 5.5304485281E+00, 1.7544500786E+00, 1.1891507643E+00, 7.7521046902E-01],
	[1.97100E+04, 1.1097971678E+01, 5.5302903798E+00, 1.7558855131E+00, 1.1898499615E+00, 7.7531171607E-01],
	[1.97150E+04, 1.1102081488E+01, 5.5301322760E+00, 1.7573217576E+00, 1.1905492463E+00, 7.7541292960E-01],
	[1.97200E+04, 1.1106191777E+01, 5.5299742169E+00, 1.7587588121E+00, 1.1912486186E+00, 7.7551410962E-01],
	[1.97250E+04, 1.1110302546E+01, 5.5298162024E+00, 1.7601966771E+00, 1.1919480781E+00, 7.7561525612E-01],
	[1.97300E+04, 1.1114413793E+01, 5.5296582324E+00, 1.7616353527E+00, 1.1926476247E+00, 7.7571636909E-01],
	[1.97350E+04, 1.1118525519E+01, 5.5295003070E+00, 1.7630748392E+00, 1.1933472582E+00, 7.7581744853E-01],
	[1.97400E+04, 1.1122637724E+01, 5.5293424261E+00, 1.7645151369E+00, 1.1940469784E+00, 7.7591849445E-01],
	[1.97450E+04, 1.1126750409E+01, 5.5291845896E+00, 1.7659562459E+00, 1.1947467852E+00, 7.7601950683E-01],
	[1.97500E+04, 1.1130863571E+01, 5.5290267977E+00, 1.7673981666E+00, 1.1954466783E+00, 7.7612048568E-01],
	[1.97550E+04, 1.1134977213E+01, 5.5288690502E+00, 1.7688408992E+00, 1.1961466577E+00, 7.7622143099E-01],
	[1.97600E+04, 1.1139091333E+01, 5.5287113471E+00, 1.7702844439E+00, 1.1968467230E+00, 7.7632234276E-01],
	[1.97650E+04, 1.1143205932E+01, 5.5285536884E+00, 1.7717288011E+00, 1.1975468742E+00, 7.7642322099E-01],
	[1.97700E+04, 1.1147321010E+01, 5.5283960740E+00, 1.7731739708E+00, 1.1982471110E+00, 7.7652406567E-01],
	[1.97750E+04, 1.1151436566E+01, 5.5282385041E+00, 1.7746199535E+00, 1.1989474332E+00, 7.7662487680E-01],
	[1.97800E+04, 1.1155552600E+01, 5.5280809784E+00, 1.7760667494E+00, 1.1996478408E+00, 7.7672565439E-01],
	[1.97850E+04, 1.1159669113E+01, 5.5279234971E+00, 1.7775143586E+00, 1.2003483335E+00, 7.7682639841E-01],
	[1.97900E+04, 1.1163786104E+01, 5.5277660600E+00, 1.7789627816E+00, 1.2010489111E+00, 7.7692710889E-01],
	[1.97950E+04, 1.1167903573E+01, 5.5276086672E+00, 1.7804120184E+00, 1.2017495735E+00, 7.7702778580E-01],
	[1.98000E+04, 1.1172021520E+01, 5.5274513186E+00, 1.7818620694E+00, 1.2024503204E+00, 7.7712842915E-01],
	[1.98050E+04, 1.1176139946E+01, 5.5272940142E+00, 1.7833129348E+00, 1.2031511518E+00, 7.7722903894E-01],
	[1.98100E+04, 1.1180258849E+01, 5.5271367540E+00, 1.7847646148E+00, 1.2038520673E+00, 7.7732961516E-01],
	[1.98150E+04, 1.1184378231E+01, 5.5269795380E+00, 1.7862171098E+00, 1.2045530670E+00, 7.7743015782E-01],
	[1.98200E+04, 1.1188498090E+01, 5.5268223661E+00, 1.7876704200E+00, 1.2052541504E+00, 7.7753066690E-01],
	[1.98250E+04, 1.1192618427E+01, 5.5266652383E+00, 1.7891245455E+00, 1.2059553176E+00, 7.7763114241E-01],
	[1.98300E+04, 1.1196739242E+01, 5.5265081546E+00, 1.7905794868E+00, 1.2066565682E+00, 7.7773158434E-01],
	[1.98350E+04, 1.1200860534E+01, 5.5263511149E+00, 1.7920352440E+00, 1.2073579022E+00, 7.7783199270E-01],
	[1.98400E+04, 1.1204982305E+01, 5.5261941193E+00, 1.7934918173E+00, 1.2080593194E+00, 7.7793236748E-01],
	[1.98450E+04, 1.1209104552E+01, 5.5260371678E+00, 1.7949492071E+00, 1.2087608195E+00, 7.7803270867E-01],
	[1.98500E+04, 1.1213227278E+01, 5.5258802602E+00, 1.7964074135E+00, 1.2094624024E+00, 7.7813301628E-01],
	[1.98550E+04, 1.1217356215E+01, 5.5257249107E+00, 1.7978664369E+00, 1.2101642072E+00, 7.7823329030E-01],
	[1.98600E+04, 1.1221525198E+01, 5.5255800466E+00, 1.7993262775E+00, 1.2108670569E+00, 7.7833353073E-01],
	[1.98650E+04, 1.1225694680E+01, 5.5254352229E+00, 1.8007869355E+00, 1.2115699908E+00, 7.7843373757E-01],
	[1.98700E+04, 1.1229864661E+01, 5.5252904393E+00, 1.8022484111E+00, 1.2122730086E+00, 7.7853391082E-01],
	[1.98750E+04, 1.1234035142E+01, 5.5251456960E+00, 1.8037107048E+00, 1.2129761103E+00, 7.7863405047E-01],
	[1.98800E+04, 1.1238206122E+01, 5.5250009929E+00, 1.8051738166E+00, 1.2136792956E+00, 7.7873415653E-01],
	[1.98850E+04, 1.1242377601E+01, 5.5248563300E+00, 1.8066377468E+00, 1.2143825644E+00, 7.7883422898E-01],
	[1.98900E+04, 1.1246549579E+01, 5.5247117072E+00, 1.8081024958E+00, 1.2150859165E+00, 7.7893426783E-01],
	[1.98950E+04, 1.1250722056E+01, 5.5245671245E+00, 1.8095680636E+00, 1.2157893517E+00, 7.7903427308E-01],
	[1.99000E+04, 1.1254895032E+01, 5.5244225820E+00, 1.8110344507E+00, 1.2164928698E+00, 7.7913424472E-01],
	[1.99050E+04, 1.1259068507E+01, 5.5242780796E+00, 1.8125016573E+00, 1.2171964706E+00, 7.7923418276E-01],
	[1.99100E+04, 1.1263242481E+01, 5.5241336172E+00, 1.8139696835E+00, 1.2179001541E+00, 7.7933408718E-01],
	[1.99150E+04, 1.1267416953E+01, 5.5239891949E+00, 1.8154385297E+00, 1.2186039200E+00, 7.7943395800E-01],
	[1.99200E+04, 1.1271591924E+01, 5.5238448126E+00, 1.8169081961E+00, 1.2193077680E+00, 7.7953379520E-01],
	[1.99250E+04, 1.1275767393E+01, 5.5237004703E+00, 1.8183786829E+00, 1.2200116982E+00, 7.7963359878E-01],
	[1.99300E+04, 1.1279943361E+01, 5.5235561680E+00, 1.8198499905E+00, 1.2207157101E+00, 7.7973336875E-01],
	[1.99350E+04, 1.1284119828E+01, 5.5234119057E+00, 1.8213221190E+00, 1.2214198038E+00, 7.7983310510E-01],
	[1.99400E+04, 1.1288296793E+01, 5.5232676833E+00, 1.8227950687E+00, 1.2221239790E+00, 7.7993280783E-01],
	[1.99450E+04, 1.1292474256E+01, 5.5231235009E+00, 1.8242688399E+00, 1.2228282356E+00, 7.8003247693E-01],
	[1.99500E+04, 1.1296652218E+01, 5.5229793583E+00, 1.8257434328E+00, 1.2235325733E+00, 7.8013211241E-01],
	[1.99550E+04, 1.1300830677E+01, 5.5228352556E+00, 1.8272188477E+00, 1.2242369919E+00, 7.8023171427E-01],
	[1.99600E+04, 1.1305009635E+01, 5.5226911928E+00, 1.8286950848E+00, 1.2249414914E+00, 7.8033128250E-01],
	[1.99650E+04, 1.1309189091E+01, 5.5225471699E+00, 1.8301721444E+00, 1.2256460715E+00, 7.8043081709E-01],
	[1.99700E+04, 1.1313369045E+01, 5.5224031867E+00, 1.8316500267E+00, 1.2263507321E+00, 7.8053031806E-01],
	[1.99750E+04, 1.1317549497E+01, 5.5222592434E+00, 1.8331287320E+00, 1.2270554730E+00, 7.8062978540E-01],
	[1.99800E+04, 1.1321730446E+01, 5.5221153398E+00, 1.8346082605E+00, 1.2277602939E+00, 7.8072921910E-01],
	[1.99850E+04, 1.1325911894E+01, 5.5219714760E+00, 1.8360886125E+00, 1.2284651948E+00, 7.8082861916E-01],
	[1.99900E+04, 1.1330093839E+01, 5.5218276519E+00, 1.8375697882E+00, 1.2291701754E+00, 7.8092798559E-01],
	[1.99950E+04, 1.1334276282E+01, 5.5216838675E+00, 1.8390517879E+00, 1.2298752355E+00, 7.8102731837E-01],
	[2.00000E+04, 1.1338459223E+01, 5.5215401228E+00, 1.8405346118E+00, 1.2305803751E+00, 7.8112661752E-01],
	[2.00050E+04, 1.1342642661E+01, 5.5213964178E+00, 1.8420189227E+00, 1.2312858898E+00, 7.8122588303E-01],
	[2.00100E+04, 1.1346826596E+01, 5.5212527525E+00, 1.8435040593E+00, 1.2319914838E+00, 7.8132511489E-01],
	[2.00150E+04, 1.1351011029E+01, 5.5211091268E+00, 1.8449900217E+00, 1.2326971567E+00, 7.8142431311E-01],
	[2.00200E+04, 1.1355195959E+01, 5.5209655406E+00, 1.8464768103E+00, 1.2334029084E+00, 7.8152347768E-01],
	[2.00250E+04, 1.1359381387E+01, 5.5208219941E+00, 1.8479644253E+00, 1.2341087388E+00, 7.8162260861E-01],
	[2.00300E+04, 1.1363567312E+01, 5.5206784872E+00, 1.8494528670E+00, 1.2348146476E+00, 7.8172170588E-01],
	[2.00350E+04, 1.1367753734E+01, 5.5205350198E+00, 1.8509421355E+00, 1.2355206347E+00, 7.8182076951E-01],
	[2.00400E+04, 1.1371940653E+01, 5.5203915919E+00, 1.8524322313E+00, 1.2362266998E+00, 7.8191979948E-01],
	[2.00450E+04, 1.1376128069E+01, 5.5202482035E+00, 1.8539231544E+00, 1.2369328429E+00, 7.8201879580E-01],
	[2.00500E+04, 1.1380315982E+01, 5.5201048546E+00, 1.8554149052E+00, 1.2376390638E+00, 7.8211775847E-01],
	[2.00550E+04, 1.1384504391E+01, 5.5199615452E+00, 1.8569074839E+00, 1.2383453622E+00, 7.8221668747E-01],
	[2.00600E+04, 1.1388693298E+01, 5.5198182752E+00, 1.8584008908E+00, 1.2390517380E+00, 7.8231558281E-01],
	[2.00650E+04, 1.1392882702E+01, 5.5196750446E+00, 1.8598951261E+00, 1.2397581910E+00, 7.8241444448E-01],
	[2.00700E+04, 1.1397072602E+01, 5.5195318535E+00, 1.8613901901E+00, 1.2404647211E+00, 7.8251327248E-01],
	[2.00750E+04, 1.1401262998E+01, 5.5193887017E+00, 1.8628860831E+00, 1.2411713280E+00, 7.8261206682E-01],
	[2.00800E+04, 1.1405453892E+01, 5.5192455893E+00, 1.8643828052E+00, 1.2418780116E+00, 7.8271082747E-01],
	[2.00850E+04, 1.1409645282E+01, 5.5191025162E+00, 1.8658803568E+00, 1.2425847717E+00, 7.8280955445E-01],
	[2.00900E+04, 1.1413837168E+01, 5.5189594825E+00, 1.8673787380E+00, 1.2432916081E+00, 7.8290824774E-01],
	[2.00950E+04, 1.1418029551E+01, 5.5188164880E+00, 1.8688779492E+00, 1.2439985207E+00, 7.8300690735E-01],
	[2.01000E+04, 1.1422222429E+01, 5.5186735328E+00, 1.8703779906E+00, 1.2447055092E+00, 7.8310553327E-01],
	[2.01050E+04, 1.1426415805E+01, 5.5185306169E+00, 1.8718788624E+00, 1.2454125735E+00, 7.8320412551E-01],
	[2.01100E+04, 1.1430609676E+01, 5.5183877402E+00, 1.8733805649E+00, 1.2461197135E+00, 7.8330268405E-01],
	[2.01150E+04, 1.1434804044E+01, 5.5182449028E+00, 1.8748830984E+00, 1.2468269289E+00, 7.8340120889E-01],
	[2.01200E+04, 1.1438998907E+01, 5.5181021045E+00, 1.8763864631E+00, 1.2475342196E+00, 7.8349970004E-01],
	[2.01250E+04, 1.1443194267E+01, 5.5179593454E+00, 1.8778906593E+00, 1.2482415853E+00, 7.8359815749E-01],
	[2.01300E+04, 1.1447390122E+01, 5.5178166255E+00, 1.8793956872E+00, 1.2489490260E+00, 7.8369658123E-01],
	[2.01350E+04, 1.1451586473E+01, 5.5176739447E+00, 1.8809015470E+00, 1.2496565414E+00, 7.8379497126E-01],
	[2.01400E+04, 1.1455783320E+01, 5.5175313030E+00, 1.8824082391E+00, 1.2503641313E+00, 7.8389332759E-01],
	[2.01450E+04, 1.1459980663E+01, 5.5173887004E+00, 1.8839157636E+00, 1.2510717957E+00, 7.8399165020E-01],
	[2.01500E+04, 1.1464178502E+01, 5.5172461369E+00, 1.8854241209E+00, 1.2517795342E+00, 7.8408993911E-01],
	[2.01550E+04, 1.1468376836E+01, 5.5171036124E+00, 1.8869333112E+00, 1.2524873468E+00, 7.8418819429E-01],
	[2.01600E+04, 1.1472575665E+01, 5.5169611270E+00, 1.8884433347E+00, 1.2531952332E+00, 7.8428641575E-01],
	[2.01650E+04, 1.1476774990E+01, 5.5168186806E+00, 1.8899541916E+00, 1.2539031933E+00, 7.8438460350E-01],
	[2.01700E+04, 1.1480974811E+01, 5.5166762732E+00, 1.8914658823E+00, 1.2546112269E+00, 7.8448275752E-01],
	[2.01750E+04, 1.1485175126E+01, 5.5165339047E+00, 1.8929784070E+00, 1.2553193338E+00, 7.8458087781E-01],
	[2.01800E+04, 1.1489375938E+01, 5.5163915752E+00, 1.8944917660E+00, 1.2560275139E+00, 7.8467896437E-01],
	[2.01850E+04, 1.1493577244E+01, 5.5162492846E+00, 1.8960059594E+00, 1.2567357669E+00, 7.8477701720E-01],
	[2.01900E+04, 1.1497779045E+01, 5.5161070330E+00, 1.8975209877E+00, 1.2574440927E+00, 7.8487503630E-01],
	[2.01950E+04, 1.1501981342E+01, 5.5159648202E+00, 1.8990368509E+00, 1.2581524911E+00, 7.8497302167E-01],
	[2.02000E+04, 1.1506184133E+01, 5.5158226463E+00, 1.9005535493E+00, 1.2588609620E+00, 7.8507097329E-01],
	[2.02050E+04, 1.1510387420E+01, 5.5156805113E+00, 1.9020710833E+00, 1.2595695051E+00, 7.8516889117E-01],
	[2.02100E+04, 1.1514591201E+01, 5.5155384150E+00, 1.9035894531E+00, 1.2602781203E+00, 7.8526677531E-01],
	[2.02150E+04, 1.1518795477E+01, 5.5153963576E+00, 1.9051086589E+00, 1.2609868074E+00, 7.8536462571E-01],
	[2.02200E+04, 1.1523000248E+01, 5.5152543390E+00, 1.9066287009E+00, 1.2616955663E+00, 7.8546244236E-01],
	[2.02250E+04, 1.1527205514E+01, 5.5151123592E+00, 1.9081495795E+00, 1.2624043967E+00, 7.8556022526E-01],
	[2.02300E+04, 1.1531411274E+01, 5.5149704181E+00, 1.9096712948E+00, 1.2631132985E+00, 7.8565797440E-01],
	[2.02350E+04, 1.1535617529E+01, 5.5148285157E+00, 1.9111938472E+00, 1.2638222714E+00, 7.8575568980E-01],
	[2.02400E+04, 1.1539824278E+01, 5.5146866521E+00, 1.9127172369E+00, 1.2645313154E+00, 7.8585337143E-01],
	[2.02450E+04, 1.1544031522E+01, 5.5145448271E+00, 1.9142414641E+00, 1.2652404303E+00, 7.8595101931E-01],
	[2.02500E+04, 1.1548239260E+01, 5.5144030408E+00, 1.9157665291E+00, 1.2659496158E+00, 7.8604863343E-01],
	[2.02550E+04, 1.1552447492E+01, 5.5142612931E+00, 1.9172924322E+00, 1.2666588718E+00, 7.8614621379E-01],
	[2.02600E+04, 1.1556656219E+01, 5.5141195841E+00, 1.9188191735E+00, 1.2673681982E+00, 7.8624376038E-01],
	[2.02650E+04, 1.1560865440E+01, 5.5139779137E+00, 1.9203467534E+00, 1.2680775947E+00, 7.8634127321E-01],
	[2.02700E+04, 1.1565075155E+01, 5.5138362819E+00, 1.9218751722E+00, 1.2687870611E+00, 7.8643875227E-01],
	[2.02750E+04, 1.1569285364E+01, 5.5136946886E+00, 1.9234044299E+00, 1.2694965974E+00, 7.8653619756E-01],
	[2.02800E+04, 1.1573496067E+01, 5.5135531339E+00, 1.9249345270E+00, 1.2702062032E+00, 7.8663360908E-01],
	[2.02850E+04, 1.1577707264E+01, 5.5134116177E+00, 1.9264654637E+00, 1.2709158785E+00, 7.8673098683E-01],
	[2.02900E+04, 1.1581918955E+01, 5.5132701400E+00, 1.9279972402E+00, 1.2716256231E+00, 7.8682833080E-01],
	[2.02950E+04, 1.1586131140E+01, 5.5131287009E+00, 1.9295298568E+00, 1.2723354367E+00, 7.8692564099E-01],
	[2.03000E+04, 1.1590343818E+01, 5.5129873001E+00, 1.9310633136E+00, 1.2730453193E+00, 7.8702291741E-01],
	[2.03050E+04, 1.1594556990E+01, 5.5128459379E+00, 1.9325976111E+00, 1.2737552706E+00, 7.8712016004E-01],
	[2.03100E+04, 1.1598770656E+01, 5.5127046140E+00, 1.9341327494E+00, 1.2744652904E+00, 7.8721736890E-01],
	[2.03150E+04, 1.1602984815E+01, 5.5125633286E+00, 1.9356687288E+00, 1.2751753786E+00, 7.8731454396E-01],
	[2.03200E+04, 1.1607199468E+01, 5.5124220816E+00, 1.9372055496E+00, 1.2758855351E+00, 7.8741168525E-01],
	[2.03250E+04, 1.1611414614E+01, 5.5122808729E+00, 1.9387432119E+00, 1.2765957595E+00, 7.8750879274E-01],
	[2.03300E+04, 1.1615630253E+01, 5.5121397026E+00, 1.9402817161E+00, 1.2773060518E+00, 7.8760586645E-01],
	[2.03350E+04, 1.1619846386E+01, 5.5119985706E+00, 1.9418210624E+00, 1.2780164118E+00, 7.8770290637E-01],
	[2.03400E+04, 1.1624063012E+01, 5.5118574769E+00, 1.9433612510E+00, 1.2787268393E+00, 7.8779991249E-01],
	[2.03450E+04, 1.1628280131E+01, 5.5117164215E+00, 1.9449022823E+00, 1.2794373341E+00, 7.8789688482E-01],
	[2.03500E+04, 1.1632497743E+01, 5.5115754044E+00, 1.9464441564E+00, 1.2801478961E+00, 7.8799382336E-01],
	[2.03550E+04, 1.1636715848E+01, 5.5114344255E+00, 1.9479868737E+00, 1.2808585250E+00, 7.8809072810E-01],
	[2.03600E+04, 1.1640934447E+01, 5.5112934849E+00, 1.9495304343E+00, 1.2815692208E+00, 7.8818759904E-01],
	[2.03650E+04, 1.1645153538E+01, 5.5111525825E+00, 1.9510748386E+00, 1.2822799831E+00, 7.8828443618E-01],
	[2.03700E+04, 1.1649373122E+01, 5.5110117182E+00, 1.9526200867E+00, 1.2829908119E+00, 7.8838123953E-01],
	[2.03750E+04, 1.1653593199E+01, 5.5108708921E+00, 1.9541661790E+00, 1.2837017070E+00, 7.8847800907E-01],
	[2.03800E+04, 1.1657813768E+01, 5.5107301042E+00, 1.9557131156E+00, 1.2844126682E+00, 7.8857474480E-01],
	[2.03850E+04, 1.1662034830E+01, 5.5105893544E+00, 1.9572608969E+00, 1.2851236953E+00, 7.8867144673E-01],
	[2.03900E+04, 1.1666256385E+01, 5.5104486428E+00, 1.9588095231E+00, 1.2858347881E+00, 7.8876811486E-01],
	[2.03950E+04, 1.1670478432E+01, 5.5103079692E+00, 1.9603589945E+00, 1.2865459465E+00, 7.8886474918E-01],
	[2.04000E+04, 1.1674700972E+01, 5.5101673337E+00, 1.9619093112E+00, 1.2872571703E+00, 7.8896134969E-01],
	[2.04050E+04, 1.1678924004E+01, 5.5100267362E+00, 1.9634604736E+00, 1.2879684593E+00, 7.8905791639E-01],
	[2.04100E+04, 1.1683147529E+01, 5.5098861768E+00, 1.9650124819E+00, 1.2886798134E+00, 7.8915444928E-01],
	[2.04150E+04, 1.1687371545E+01, 5.5097456554E+00, 1.9665653364E+00, 1.2893912323E+00, 7.8925094835E-01],
	[2.04200E+04, 1.1691596054E+01, 5.5096051720E+00, 1.9681190373E+00, 1.2901027159E+00, 7.8934741362E-01],
	[2.04250E+04, 1.1695821055E+01, 5.5094647266E+00, 1.9696735849E+00, 1.2908142640E+00, 7.8944384507E-01],
	[2.04300E+04, 1.1700046549E+01, 5.5093243191E+00, 1.9712289794E+00, 1.2915258765E+00, 7.8954024270E-01],
	[2.04350E+04, 1.1704272534E+01, 5.5091839495E+00, 1.9727852211E+00, 1.2922375531E+00, 7.8963660652E-01],
	[2.04400E+04, 1.1708499011E+01, 5.5090436179E+00, 1.9743423102E+00, 1.2929492937E+00, 7.8973293652E-01],
	[2.04450E+04, 1.1712725980E+01, 5.5089033242E+00, 1.9759002470E+00, 1.2936610981E+00, 7.8982923270E-01],
	[2.04500E+04, 1.1716953441E+01, 5.5087630683E+00, 1.9774590318E+00, 1.2943729662E+00, 7.8992549506E-01],
	[2.04550E+04, 1.1721181394E+01, 5.5086228503E+00, 1.9790186647E+00, 1.2950848977E+00, 7.9002172360E-01],
	[2.04600E+04, 1.1725409838E+01, 5.5084826702E+00, 1.9805791461E+00, 1.2957968925E+00, 7.9011791832E-01],
	[2.04650E+04, 1.1729638774E+01, 5.5083425278E+00, 1.9821404762E+00, 1.2965089504E+00, 7.9021407921E-01],
	[2.04700E+04, 1.1733868202E+01, 5.5082024233E+00, 1.9837026553E+00, 1.2972210713E+00, 7.9031020629E-01],
	[2.04750E+04, 1.1738098121E+01, 5.5080623565E+00, 1.9852656835E+00, 1.2979332549E+00, 7.9040629954E-01],
	[2.04800E+04, 1.1742328531E+01, 5.5079223275E+00, 1.9868295613E+00, 1.2986455011E+00, 7.9050235896E-01],
	[2.04850E+04, 1.1746559433E+01, 5.5077823363E+00, 1.9883942888E+00, 1.2993578097E+00, 7.9059838456E-01],
	[2.04900E+04, 1.1750790827E+01, 5.5076423827E+00, 1.9899598662E+00, 1.3000701805E+00, 7.9069437633E-01],
	[2.04950E+04, 1.1755022711E+01, 5.5075024669E+00, 1.9915262939E+00, 1.3007826135E+00, 7.9079033427E-01],
	[2.05000E+04, 1.1759255087E+01, 5.5073625888E+00, 1.9930935720E+00, 1.3014951082E+00, 7.9088625839E-01],
	[2.05050E+04, 1.1763487954E+01, 5.5072227483E+00, 1.9946617009E+00, 1.3022076647E+00, 7.9098214868E-01],
	[2.05100E+04, 1.1767721312E+01, 5.5070829454E+00, 1.9962306808E+00, 1.3029202828E+00, 7.9107800514E-01],
	[2.05150E+04, 1.1771955161E+01, 5.5069431802E+00, 1.9978005120E+00, 1.3036329622E+00, 7.9117382776E-01],
	[2.05200E+04, 1.1776189501E+01, 5.5068034526E+00, 1.9993711946E+00, 1.3043457028E+00, 7.9126961656E-01],
	[2.05250E+04, 1.1780424332E+01, 5.5066637626E+00, 2.0009427290E+00, 1.3050585043E+00, 7.9136537152E-01],
	[2.05300E+04, 1.1784659653E+01, 5.5065241101E+00, 2.0025151154E+00, 1.3057713668E+00, 7.9146109266E-01],
	[2.05350E+04, 1.1788895466E+01, 5.5063844952E+00, 2.0040883540E+00, 1.3064842899E+00, 7.9155677996E-01],
	[2.05400E+04, 1.1793131769E+01, 5.5062449178E+00, 2.0056624452E+00, 1.3071972734E+00, 7.9165243343E-01],
	[2.05450E+04, 1.1797368563E+01, 5.5061053779E+00, 2.0072373892E+00, 1.3079103173E+00, 7.9174805306E-01],
	[2.05500E+04, 1.1801605847E+01, 5.5059658756E+00, 2.0088131862E+00, 1.3086234213E+00, 7.9184363886E-01],
	[2.05550E+04, 1.1805843622E+01, 5.5058264107E+00, 2.0103898364E+00, 1.3093365853E+00, 7.9193919082E-01],
	[2.05600E+04, 1.1810081887E+01, 5.5056869832E+00, 2.0119673402E+00, 1.3100498091E+00, 7.9203470895E-01],
	[2.05650E+04, 1.1814320643E+01, 5.5055475932E+00, 2.0135456978E+00, 1.3107630924E+00, 7.9213019325E-01],
	[2.05700E+04, 1.1818559889E+01, 5.5054082406E+00, 2.0151249094E+00, 1.3114764353E+00, 7.9222564371E-01],
	[2.05750E+04, 1.1822799626E+01, 5.5052689253E+00, 2.0167049753E+00, 1.3121898373E+00, 7.9232106033E-01],
	[2.05800E+04, 1.1827039852E+01, 5.5051296475E+00, 2.0182858958E+00, 1.3129032985E+00, 7.9241644311E-01],
	[2.05850E+04, 1.1831280569E+01, 5.5049904070E+00, 2.0198676711E+00, 1.3136168186E+00, 7.9251179206E-01],
	[2.05900E+04, 1.1835521775E+01, 5.5048512039E+00, 2.0214503015E+00, 1.3143303974E+00, 7.9260710717E-01],
	[2.05950E+04, 1.1839763472E+01, 5.5047120380E+00, 2.0230337871E+00, 1.3150440348E+00, 7.9270238845E-01],
	[2.06000E+04, 1.1844005659E+01, 5.5045729095E+00, 2.0246181284E+00, 1.3157577305E+00, 7.9279763588E-01],
	[2.06050E+04, 1.1848248335E+01, 5.5044338183E+00, 2.0262033254E+00, 1.3164714845E+00, 7.9289284948E-01],
	[2.06100E+04, 1.1852491502E+01, 5.5042947643E+00, 2.0277893785E+00, 1.3171852965E+00, 7.9298802924E-01],
	[2.06150E+04, 1.1856735158E+01, 5.5041557475E+00, 2.0293762880E+00, 1.3178991664E+00, 7.9308317516E-01],
	[2.06200E+04, 1.1860979304E+01, 5.5040167680E+00, 2.0309640541E+00, 1.3186130940E+00, 7.9317828724E-01],
	[2.06250E+04, 1.1865223939E+01, 5.5038778257E+00, 2.0325526770E+00, 1.3193270791E+00, 7.9327336549E-01],
	[2.06300E+04, 1.1869469065E+01, 5.5037389205E+00, 2.0341421570E+00, 1.3200411216E+00, 7.9336840990E-01],
	[2.06350E+04, 1.1873714679E+01, 5.5036000526E+00, 2.0357324943E+00, 1.3207552212E+00, 7.9346342046E-01],
	[2.06400E+04, 1.1877960783E+01, 5.5034612217E+00, 2.0373236893E+00, 1.3214693778E+00, 7.9355839719E-01],
	[2.06450E+04, 1.1882207377E+01, 5.5033224281E+00, 2.0389157421E+00, 1.3221835912E+00, 7.9365334008E-01],
	[2.06500E+04, 1.1886489790E+01, 5.5031922096E+00, 2.0405086530E+00, 1.3228987923E+00, 7.9374824913E-01],
	[2.06550E+04, 1.1890785139E+01, 5.5030650283E+00, 2.0421024223E+00, 1.3236143791E+00, 7.9384312434E-01],
	[2.06600E+04, 1.1895081000E+01, 5.5029378807E+00, 2.0436970502E+00, 1.3243300242E+00, 7.9393796572E-01],
	[2.06650E+04, 1.1899377373E+01, 5.5028107668E+00, 2.0452925370E+00, 1.3250457274E+00, 7.9403277325E-01],
	[2.06700E+04, 1.1903674258E+01, 5.5026836866E+00, 2.0468888830E+00, 1.3257614887E+00, 7.9412754694E-01],
	[2.06750E+04, 1.1907971654E+01, 5.5025566401E+00, 2.0484860883E+00, 1.3264773077E+00, 7.9422228680E-01],
	[2.06800E+04, 1.1912269562E+01, 5.5024296272E+00, 2.0500841532E+00, 1.3271931843E+00, 7.9431699282E-01],
	[2.06850E+04, 1.1916567982E+01, 5.5023026480E+00, 2.0516830781E+00, 1.3279091185E+00, 7.9441166500E-01],
	[2.06900E+04, 1.1920866914E+01, 5.5021757024E+00, 2.0532828631E+00, 1.3286251099E+00, 7.9450630334E-01],
	[2.06950E+04, 1.1925166357E+01, 5.5020487904E+00, 2.0548835085E+00, 1.3293411584E+00, 7.9460090785E-01],
	[2.07000E+04, 1.1929466311E+01, 5.5019219119E+00, 2.0564850146E+00, 1.3300572638E+00, 7.9469547851E-01],
	[2.07050E+04, 1.1933766777E+01, 5.5017950671E+00, 2.0580873816E+00, 1.3307734260E+00, 7.9479001534E-01],
	[2.07100E+04, 1.1938067754E+01, 5.5016682558E+00, 2.0596906098E+00, 1.3314896448E+00, 7.9488451834E-01],
	[2.07150E+04, 1.1942369242E+01, 5.5015414780E+00, 2.0612946994E+00, 1.3322059201E+00, 7.9497898749E-01],
	[2.07200E+04, 1.1946671242E+01, 5.5014147337E+00, 2.0628996507E+00, 1.3329222515E+00, 7.9507342281E-01],
	[2.07250E+04, 1.1950973753E+01, 5.5012880230E+00, 2.0645054639E+00, 1.3336386391E+00, 7.9516782429E-01],
	[2.07300E+04, 1.1955276775E+01, 5.5011613457E+00, 2.0661121393E+00, 1.3343550826E+00, 7.9526219194E-01],
	[2.07350E+04, 1.1959580308E+01, 5.5010347019E+00, 2.0677196771E+00, 1.3350715817E+00, 7.9535652575E-01],
	[2.07400E+04, 1.1963884351E+01, 5.5009080916E+00, 2.0693280777E+00, 1.3357881365E+00, 7.9545082573E-01],
	[2.07450E+04, 1.1968188906E+01, 5.5007815146E+00, 2.0709373412E+00, 1.3365047466E+00, 7.9554509187E-01],
	[2.07500E+04, 1.1972493972E+01, 5.5006549711E+00, 2.0725474679E+00, 1.3372214119E+00, 7.9563932418E-01],
	[2.07550E+04, 1.1976799548E+01, 5.5005284610E+00, 2.0741584581E+00, 1.3379381323E+00, 7.9573352266E-01],
	[2.07600E+04, 1.1981105635E+01, 5.5004019843E+00, 2.0757703119E+00, 1.3386549076E+00, 7.9582768730E-01],
	[2.07650E+04, 1.1985412233E+01, 5.5002755409E+00, 2.0773830298E+00, 1.3393717375E+00, 7.9592181811E-01],
	[2.07700E+04, 1.1989719341E+01, 5.5001491309E+00, 2.0789966119E+00, 1.3400886220E+00, 7.9601591509E-01],
	[2.07750E+04, 1.1994026960E+01, 5.5000227542E+00, 2.0806110585E+00, 1.3408055608E+00, 7.9610997824E-01],
	[2.07800E+04, 1.1998335089E+01, 5.4998964109E+00, 2.0822263698E+00, 1.3415225538E+00, 7.9620400755E-01],
	[2.07850E+04, 1.2002643729E+01, 5.4997701008E+00, 2.0838425461E+00, 1.3422396008E+00, 7.9629800304E-01],
	[2.07900E+04, 1.2006952879E+01, 5.4996438240E+00, 2.0854595877E+00, 1.3429567016E+00, 7.9639196470E-01],
	[2.07950E+04, 1.2011262539E+01, 5.4995175805E+00, 2.0870774947E+00, 1.3436738561E+00, 7.9648589252E-01],
	[2.08000E+04, 1.2015572709E+01, 5.4993913702E+00, 2.0886962675E+00, 1.3443910641E+00, 7.9657978652E-01],
	[2.08050E+04, 1.2019883390E+01, 5.4992651931E+00, 2.0903159064E+00, 1.3451083254E+00, 7.9667364670E-01],
	[2.08100E+04, 1.2024194581E+01, 5.4991390493E+00, 2.0919364115E+00, 1.3458256399E+00, 7.9676747304E-01],
	[2.08150E+04, 1.2028506281E+01, 5.4990129387E+00, 2.0935577831E+00, 1.3465430073E+00, 7.9686126556E-01],
	[2.08200E+04, 1.2032818492E+01, 5.4988868612E+00, 2.0951800215E+00, 1.3472604275E+00, 7.9695502426E-01],
	[2.08250E+04, 1.2037131213E+01, 5.4987608169E+00, 2.0968031269E+00, 1.3479779003E+00, 7.9704874913E-01],
	[2.08300E+04, 1.2041444443E+01, 5.4986348058E+00, 2.0984270997E+00, 1.3486954256E+00, 7.9714244018E-01],
	[2.08350E+04, 1.2045758183E+01, 5.4985088278E+00, 2.1000519399E+00, 1.3494130032E+00, 7.9723609740E-01],
	[2.08400E+04, 1.2050072433E+01, 5.4983828829E+00, 2.1016776480E+00, 1.3501306329E+00, 7.9732972081E-01],
	[2.08450E+04, 1.2054387193E+01, 5.4982569711E+00, 2.1033042241E+00, 1.3508483146E+00, 7.9742331039E-01],
	[2.08500E+04, 1.2058702462E+01, 5.4981310923E+00, 2.1049316686E+00, 1.3515660480E+00, 7.9751686615E-01],
	[2.08550E+04, 1.2063018240E+01, 5.4980052467E+00, 2.1065599816E+00, 1.3522838330E+00, 7.9761038810E-01],
	[2.08600E+04, 1.2067334528E+01, 5.4978794341E+00, 2.1081891634E+00, 1.3530016695E+00, 7.9770387622E-01],
	[2.08650E+04, 1.2071651326E+01, 5.4977536545E+00, 2.1098192143E+00, 1.3537195571E+00, 7.9779733053E-01],
	[2.08700E+04, 1.2075968633E+01, 5.4976279079E+00, 2.1114501345E+00, 1.3544374959E+00, 7.9789075103E-01],
	[2.08750E+04, 1.2080286449E+01, 5.4975021944E+00, 2.1130819243E+00, 1.3551554856E+00, 7.9798413771E-01],
	[2.08800E+04, 1.2084604774E+01, 5.4973765138E+00, 2.1147145839E+00, 1.3558735260E+00, 7.9807749057E-01],
	[2.08850E+04, 1.2088923609E+01, 5.4972508662E+00, 2.1163481137E+00, 1.3565916170E+00, 7.9817080963E-01],
	[2.08900E+04, 1.2093242952E+01, 5.4971252515E+00, 2.1179825138E+00, 1.3573097584E+00, 7.9826409487E-01],
	[2.08950E+04, 1.2097562805E+01, 5.4969996697E+00, 2.1196177845E+00, 1.3580279500E+00, 7.9835734630E-01],
	[2.09000E+04, 1.2101883167E+01, 5.4968741209E+00, 2.1212539260E+00, 1.3587461917E+00, 7.9845056392E-01],
	[2.09050E+04, 1.2106204037E+01, 5.4967486050E+00, 2.1228909387E+00, 1.3594644833E+00, 7.9854374773E-01],
	[2.09100E+04, 1.2110525417E+01, 5.4966231219E+00, 2.1245288227E+00, 1.3601828245E+00, 7.9863689774E-01],
	[2.09150E+04, 1.2114847305E+01, 5.4964976718E+00, 2.1261675784E+00, 1.3609012153E+00, 7.9873001394E-01],
	[2.09200E+04, 1.2119169702E+01, 5.4963722544E+00, 2.1278072059E+00, 1.3616196555E+00, 7.9882309634E-01],
	[2.09250E+04, 1.2123492607E+01, 5.4962468699E+00, 2.1294477056E+00, 1.3623381449E+00, 7.9891614493E-01],
	[2.09300E+04, 1.2127816021E+01, 5.4961215182E+00, 2.1310890777E+00, 1.3630566833E+00, 7.9900915972E-01],
	[2.09350E+04, 1.2132139944E+01, 5.4959961994E+00, 2.1327313224E+00, 1.3637752705E+00, 7.9910214071E-01],
	[2.09400E+04, 1.2136464375E+01, 5.4958709133E+00, 2.1343744401E+00, 1.3644939065E+00, 7.9919508791E-01],
	[2.09450E+04, 1.2140789315E+01, 5.4957456599E+00, 2.1360184309E+00, 1.3652125909E+00, 7.9928800130E-01],
	[2.09500E+04, 1.2145114762E+01, 5.4956204393E+00, 2.1376632951E+00, 1.3659313237E+00, 7.9938088090E-01],
	[2.09550E+04, 1.2149440719E+01, 5.4954952515E+00, 2.1393090330E+00, 1.3666501046E+00, 7.9947372670E-01],
	[2.09600E+04, 1.2153767183E+01, 5.4953700964E+00, 2.1409556448E+00, 1.3673689336E+00, 7.9956653871E-01],
	[2.09650E+04, 1.2158094156E+01, 5.4952449739E+00, 2.1426031307E+00, 1.3680878104E+00, 7.9965931692E-01],
	[2.09700E+04, 1.2162421636E+01, 5.4951198842E+00, 2.1442514912E+00, 1.3688067348E+00, 7.9975206135E-01],
	[2.09750E+04, 1.2166749625E+01, 5.4949948271E+00, 2.1459007263E+00, 1.3695257068E+00, 7.9984477199E-01],
	[2.09800E+04, 1.2171078122E+01, 5.4948698027E+00, 2.1475508363E+00, 1.3702447260E+00, 7.9993744883E-01],
	[2.09850E+04, 1.2175407126E+01, 5.4947448109E+00, 2.1492018216E+00, 1.3709637924E+00, 8.0003009190E-01],
	[2.09900E+04, 1.2179736639E+01, 5.4946198517E+00, 2.1508536823E+00, 1.3716829058E+00, 8.0012270117E-01],
	[2.09950E+04, 1.2184066659E+01, 5.4944949252E+00, 2.1525064187E+00, 1.3724020660E+00, 8.0021527667E-01],
	[2.10000E+04, 1.2188397187E+01, 5.4943700312E+00, 2.1541600311E+00, 1.3731212728E+00, 8.0030781838E-01],
	[2.10050E+04, 1.2192728223E+01, 5.4942451698E+00, 2.1558145197E+00, 1.3738405261E+00, 8.0040032631E-01],
	[2.10100E+04, 1.2197059766E+01, 5.4941203409E+00, 2.1574698848E+00, 1.3745598256E+00, 8.0049280047E-01],
	[2.10150E+04, 1.2201391817E+01, 5.4939955446E+00, 2.1591261267E+00, 1.3752791713E+00, 8.0058524084E-01],
	[2.10200E+04, 1.2205724375E+01, 5.4938707808E+00, 2.1607832455E+00, 1.3759985630E+00, 8.0067764745E-01],
	[2.10250E+04, 1.2210057441E+01, 5.4937460495E+00, 2.1624412416E+00, 1.3767180004E+00, 8.0077002027E-01],
	[2.10300E+04, 1.2214391014E+01, 5.4936213507E+00, 2.1641001152E+00, 1.3774374834E+00, 8.0086235933E-01],
	[2.10350E+04, 1.2218725095E+01, 5.4934966844E+00, 2.1657598665E+00, 1.3781570119E+00, 8.0095466461E-01],
	[2.10400E+04, 1.2223059682E+01, 5.4933720506E+00, 2.1674204959E+00, 1.3788765856E+00, 8.0104693611E-01],
	[2.10450E+04, 1.2227394777E+01, 5.4932474491E+00, 2.1690820035E+00, 1.3795962045E+00, 8.0113917384E-01],
	[2.10500E+04, 1.2231730379E+01, 5.4931228801E+00, 2.1707443896E+00, 1.3803158683E+00, 8.0123137779E-01],
	[2.10550E+04, 1.2236066488E+01, 5.4929983436E+00, 2.1724076545E+00, 1.3810355768E+00, 8.0132354797E-01],
	[2.10600E+04, 1.2240403105E+01, 5.4928738394E+00, 2.1740717985E+00, 1.3817553299E+00, 8.0141568438E-01],
	[2.10650E+04, 1.2244740228E+01, 5.4927493675E+00, 2.1757368218E+00, 1.3824751275E+00, 8.0150778701E-01],
	[2.10700E+04, 1.2249077857E+01, 5.4926249281E+00, 2.1774027246E+00, 1.3831949693E+00, 8.0159985587E-01],
	[2.10750E+04, 1.2253415994E+01, 5.4925005210E+00, 2.1790695072E+00, 1.3839148551E+00, 8.0169189096E-01],
	[2.10800E+04, 1.2257754638E+01, 5.4923761462E+00, 2.1807371698E+00, 1.3846347849E+00, 8.0178389227E-01],
	[2.10850E+04, 1.2262093788E+01, 5.4922518037E+00, 2.1824057128E+00, 1.3853547584E+00, 8.0187585981E-01],
	[2.10900E+04, 1.2266433445E+01, 5.4921274936E+00, 2.1840751364E+00, 1.3860747755E+00, 8.0196779357E-01],
	[2.10950E+04, 1.2270773608E+01, 5.4920032157E+00, 2.1857454407E+00, 1.3867948360E+00, 8.0205969357E-01],
	[2.11000E+04, 1.2275114278E+01, 5.4918789700E+00, 2.1874166262E+00, 1.3875149398E+00, 8.0215155979E-01],
	[2.11050E+04, 1.2279455454E+01, 5.4917547566E+00, 2.1890886930E+00, 1.3882350865E+00, 8.0224339224E-01],
	[2.11100E+04, 1.2283797137E+01, 5.4916305755E+00, 2.1907616414E+00, 1.3889552762E+00, 8.0233519092E-01],
	[2.11150E+04, 1.2288139326E+01, 5.4915064266E+00, 2.1924354716E+00, 1.3896755086E+00, 8.0242695583E-01],
	[2.11200E+04, 1.2292482021E+01, 5.4913823098E+00, 2.1941101840E+00, 1.3903957836E+00, 8.0251868697E-01],
	[2.11250E+04, 1.2296825223E+01, 5.4912582253E+00, 2.1957857787E+00, 1.3911161009E+00, 8.0261038434E-01],
	[2.11300E+04, 1.2301168931E+01, 5.4911341729E+00, 2.1974622560E+00, 1.3918364605E+00, 8.0270204794E-01],
	[2.11350E+04, 1.2305513144E+01, 5.4910101527E+00, 2.1991396162E+00, 1.3925568620E+00, 8.0279367777E-01],
	[2.11400E+04, 1.2309857864E+01, 5.4908861646E+00, 2.2008178595E+00, 1.3932773055E+00, 8.0288527383E-01],
	[2.11450E+04, 1.2314203090E+01, 5.4907622086E+00, 2.2024969862E+00, 1.3939977907E+00, 8.0297683613E-01],
	[2.11500E+04, 1.2318548822E+01, 5.4906382848E+00, 2.2041769966E+00, 1.3947183174E+00, 8.0306836466E-01],
	[2.11550E+04, 1.2322895059E+01, 5.4905143930E+00, 2.2058578908E+00, 1.3954388855E+00, 8.0315985942E-01],
	[2.11600E+04, 1.2327241802E+01, 5.4903905333E+00, 2.2075396692E+00, 1.3961594947E+00, 8.0325132042E-01],
	[2.11650E+04, 1.2331589052E+01, 5.4902667056E+00, 2.2092223321E+00, 1.3968801450E+00, 8.0334274765E-01],
	[2.11700E+04, 1.2335936806E+01, 5.4901429100E+00, 2.2109058795E+00, 1.3976008362E+00, 8.0343414112E-01],
	[2.11750E+04, 1.2340285066E+01, 5.4900191465E+00, 2.2125903119E+00, 1.3983215680E+00, 8.0352550082E-01],
	[2.11800E+04, 1.2344633832E+01, 5.4898954149E+00, 2.2142756295E+00, 1.3990423404E+00, 8.0361682676E-01],
	[2.11850E+04, 1.2348983104E+01, 5.4897717153E+00, 2.2159618325E+00, 1.3997631531E+00, 8.0370811894E-01],
	[2.11900E+04, 1.2353332880E+01, 5.4896480477E+00, 2.2176489212E+00, 1.4004840060E+00, 8.0379937736E-01],
	[2.11950E+04, 1.2357683162E+01, 5.4895244121E+00, 2.2193368959E+00, 1.4012048989E+00, 8.0389060202E-01],
	[2.12000E+04, 1.2362033950E+01, 5.4894008084E+00, 2.2210257567E+00, 1.4019258317E+00, 8.0398179292E-01],
	[2.12050E+04, 1.2366385242E+01, 5.4892772366E+00, 2.2227155040E+00, 1.4026468041E+00, 8.0407295006E-01],
	[2.12100E+04, 1.2370737040E+01, 5.4891536968E+00, 2.2244061380E+00, 1.4033678160E+00, 8.0416407344E-01],
	[2.12150E+04, 1.2375089343E+01, 5.4890301889E+00, 2.2260976590E+00, 1.4040888673E+00, 8.0425516307E-01],
	[2.12200E+04, 1.2379442151E+01, 5.4889067128E+00, 2.2277900672E+00, 1.4048099578E+00, 8.0434621894E-01],
	[2.12250E+04, 1.2383795464E+01, 5.4887832686E+00, 2.2294833629E+00, 1.4055310872E+00, 8.0443724105E-01],
	[2.12300E+04, 1.2388149282E+01, 5.4886598563E+00, 2.2311775463E+00, 1.4062522555E+00, 8.0452822942E-01],
	[2.12350E+04, 1.2392503605E+01, 5.4885364757E+00, 2.2328726178E+00, 1.4069734624E+00, 8.0461918402E-01],
	[2.12400E+04, 1.2396858432E+01, 5.4884131271E+00, 2.2345685774E+00, 1.4076947079E+00, 8.0471010488E-01],
	[2.12450E+04, 1.2401213765E+01, 5.4882898102E+00, 2.2362654256E+00, 1.4084159917E+00, 8.0480099199E-01],
	[2.12500E+04, 1.2405569602E+01, 5.4881665251E+00, 2.2379631626E+00, 1.4091373136E+00, 8.0489184534E-01],
	[2.12550E+04, 1.2409925944E+01, 5.4880432718E+00, 2.2396617885E+00, 1.4098586735E+00, 8.0498266495E-01],
	[2.12600E+04, 1.2414282790E+01, 5.4879200502E+00, 2.2413613038E+00, 1.4105800712E+00, 8.0507345081E-01],
	[2.12650E+04, 1.2418640141E+01, 5.4877968604E+00, 2.2430617085E+00, 1.4113015066E+00, 8.0516420293E-01],
	[2.12700E+04, 1.2422997996E+01, 5.4876737023E+00, 2.2447630031E+00, 1.4120229795E+00, 8.0525492130E-01],
	[2.12750E+04, 1.2427356355E+01, 5.4875505759E+00, 2.2464651877E+00, 1.4127444897E+00, 8.0534560592E-01],
	[2.12800E+04, 1.2431715219E+01, 5.4874274812E+00, 2.2481682626E+00, 1.4134660371E+00, 8.0543625680E-01],
	[2.12850E+04, 1.2436074588E+01, 5.4873044182E+00, 2.2498722281E+00, 1.4141876214E+00, 8.0552687394E-01],
	[2.12900E+04, 1.2440434460E+01, 5.4871813869E+00, 2.2515770843E+00, 1.4149092425E+00, 8.0561745735E-01],
	[2.12950E+04, 1.2444794837E+01, 5.4870583872E+00, 2.2532828317E+00, 1.4156309003E+00, 8.0570800701E-01],
	[2.13000E+04, 1.2449155717E+01, 5.4869354191E+00, 2.2549894703E+00, 1.4163525946E+00, 8.0579852293E-01],
	[2.13050E+04, 1.2453517102E+01, 5.4868124827E+00, 2.2566970006E+00, 1.4170743252E+00, 8.0588900512E-01],
	[2.13100E+04, 1.2457878991E+01, 5.4866895778E+00, 2.2584054227E+00, 1.4177960919E+00, 8.0597945358E-01],
	[2.13150E+04, 1.2462241383E+01, 5.4865667046E+00, 2.2601147369E+00, 1.4185178946E+00, 8.0606986830E-01],
	[2.13200E+04, 1.2466604280E+01, 5.4864438629E+00, 2.2618249434E+00, 1.4192397331E+00, 8.0616024928E-01],
	[2.13250E+04, 1.2470967680E+01, 5.4863210527E+00, 2.2635360425E+00, 1.4199616072E+00, 8.0625059654E-01],
	[2.13300E+04, 1.2475331584E+01, 5.4861982742E+00, 2.2652480345E+00, 1.4206835168E+00, 8.0634091007E-01],
	[2.13350E+04, 1.2479695992E+01, 5.4860755271E+00, 2.2669609197E+00, 1.4214054617E+00, 8.0643118987E-01],
	[2.13400E+04, 1.2484060903E+01, 5.4859528115E+00, 2.2686746982E+00, 1.4221274417E+00, 8.0652143595E-01],
	[2.13450E+04, 1.2488426318E+01, 5.4858301275E+00, 2.2703893703E+00, 1.4228494568E+00, 8.0661164830E-01],
	[2.13500E+04, 1.2492792236E+01, 5.4857074749E+00, 2.2721049363E+00, 1.4235715066E+00, 8.0670182693E-01],
	[2.13550E+04, 1.2497158658E+01, 5.4855848537E+00, 2.2738213965E+00, 1.4242935910E+00, 8.0679197183E-01],
	[2.13600E+04, 1.2501525583E+01, 5.4854622641E+00, 2.2755387511E+00, 1.4250157099E+00, 8.0688208302E-01],
	[2.13650E+04, 1.2505893011E+01, 5.4853397058E+00, 2.2772570003E+00, 1.4257378631E+00, 8.0697216049E-01],
	[2.13700E+04, 1.2510260943E+01, 5.4852171790E+00, 2.2789761444E+00, 1.4264600505E+00, 8.0706220424E-01],
	[2.13750E+04, 1.2514629378E+01, 5.4850946835E+00, 2.2806961838E+00, 1.4271822718E+00, 8.0715221427E-01],
	[2.13800E+04, 1.2518998316E+01, 5.4849722195E+00, 2.2824171185E+00, 1.4279045269E+00, 8.0724219060E-01],
	[2.13850E+04, 1.2523367757E+01, 5.4848497868E+00, 2.2841389490E+00, 1.4286268156E+00, 8.0733213321E-01],
	[2.13900E+04, 1.2527737701E+01, 5.4847273855E+00, 2.2858616753E+00, 1.4293491378E+00, 8.0742204211E-01],
	[2.13950E+04, 1.2532108148E+01, 5.4846050155E+00, 2.2875852979E+00, 1.4300714933E+00, 8.0751191730E-01],
	[2.14000E+04, 1.2536479098E+01, 5.4844826768E+00, 2.2893098169E+00, 1.4307938820E+00, 8.0760175879E-01],
	[2.14050E+04, 1.2540850551E+01, 5.4843603695E+00, 2.2910352327E+00, 1.4315163036E+00, 8.0769156657E-01],
	[2.14100E+04, 1.2545222506E+01, 5.4842380934E+00, 2.2927615454E+00, 1.4322387579E+00, 8.0778134065E-01],
	[2.14150E+04, 1.2549594965E+01, 5.4841158487E+00, 2.2944887553E+00, 1.4329612450E+00, 8.0787108103E-01],
	[2.14200E+04, 1.2553967926E+01, 5.4839936351E+00, 2.2962168628E+00, 1.4336837644E+00, 8.0796078771E-01],
	[2.14250E+04, 1.2558341389E+01, 5.4838714529E+00, 2.2979458679E+00, 1.4344063162E+00, 8.0805046070E-01],
	[2.14300E+04, 1.2562715355E+01, 5.4837493018E+00, 2.2996757711E+00, 1.4351289001E+00, 8.0814009999E-01],
	[2.14350E+04, 1.2567089824E+01, 5.4836271820E+00, 2.3014065725E+00, 1.4358515160E+00, 8.0822970558E-01],
	[2.14400E+04, 1.2571464795E+01, 5.4835050934E+00, 2.3031382724E+00, 1.4365741636E+00, 8.0831927748E-01],
	[2.14450E+04, 1.2575840268E+01, 5.4833830359E+00, 2.3048708711E+00, 1.4372968429E+00, 8.0840881570E-01],
	[2.14500E+04, 1.2580216244E+01, 5.4832610097E+00, 2.3066043688E+00, 1.4380195537E+00, 8.0849832023E-01],
	[2.14550E+04, 1.2584592721E+01, 5.4831390146E+00, 2.3083387658E+00, 1.4387422957E+00, 8.0858779107E-01],
	[2.14600E+04, 1.2588969701E+01, 5.4830170506E+00, 2.3100740623E+00, 1.4394650689E+00, 8.0867722823E-01],
	[2.14650E+04, 1.2593347184E+01, 5.4828951178E+00, 2.3118102586E+00, 1.4401878730E+00, 8.0876663170E-01],
	[2.14700E+04, 1.2597726926E+01, 5.4827736102E+00, 2.3135473550E+00, 1.4409107582E+00, 8.0885600150E-01],
	[2.14750E+04, 1.2602155123E+01, 5.4826628796E+00, 2.3152853516E+00, 1.4416350446E+00, 8.0894533762E-01],
	[2.14800E+04, 1.2606583844E+01, 5.4825521771E+00, 2.3170242489E+00, 1.4423593635E+00, 8.0903464007E-01],
	[2.14850E+04, 1.2611013091E+01, 5.4824415026E+00, 2.3187640469E+00, 1.4430837148E+00, 8.0912390884E-01],
	[2.14900E+04, 1.2615442862E+01, 5.4823308560E+00, 2.3205047460E+00, 1.4438080984E+00, 8.0921314395E-01],
	[2.14950E+04, 1.2619873159E+01, 5.4822202375E+00, 2.3222463465E+00, 1.4445325140E+00, 8.0930234538E-01],
	[2.15000E+04, 1.2624303980E+01, 5.4821096468E+00, 2.3239888485E+00, 1.4452569616E+00, 8.0939151315E-01],
	[2.15050E+04, 1.2628735326E+01, 5.4819990842E+00, 2.3257322524E+00, 1.4459814408E+00, 8.0948064726E-01],
	[2.15100E+04, 1.2633167197E+01, 5.4818885494E+00, 2.3274765584E+00, 1.4467059517E+00, 8.0956974770E-01],
	[2.15150E+04, 1.2637599593E+01, 5.4817780426E+00, 2.3292217668E+00, 1.4474304940E+00, 8.0965881448E-01],
	[2.15200E+04, 1.2642032513E+01, 5.4816675637E+00, 2.3309678778E+00, 1.4481550675E+00, 8.0974784761E-01],
	[2.15250E+04, 1.2646465958E+01, 5.4815571127E+00, 2.3327148916E+00, 1.4488796721E+00, 8.0983684708E-01],
	[2.15300E+04, 1.2650899927E+01, 5.4814466895E+00, 2.3344628086E+00, 1.4496043076E+00, 8.0992581290E-01],
	[2.15350E+04, 1.2655334421E+01, 5.4813362943E+00, 2.3362116290E+00, 1.4503289738E+00, 8.1001474507E-01],
	[2.15400E+04, 1.2659769439E+01, 5.4812259268E+00, 2.3379613530E+00, 1.4510536706E+00, 8.1010364359E-01],
	[2.15450E+04, 1.2664204982E+01, 5.4811155873E+00, 2.3397119810E+00, 1.4517783979E+00, 8.1019250847E-01],
	[2.15500E+04, 1.2668641048E+01, 5.4810052755E+00, 2.3414635131E+00, 1.4525031554E+00, 8.1028133971E-01],
	[2.15550E+04, 1.2673077639E+01, 5.4808949915E+00, 2.3432159496E+00, 1.4532279430E+00, 8.1037013730E-01],
	[2.15600E+04, 1.2677514755E+01, 5.4807847354E+00, 2.3449692907E+00, 1.4539527606E+00, 8.1045890126E-01],
	[2.15650E+04, 1.2681952394E+01, 5.4806745070E+00, 2.3467235369E+00, 1.4546776079E+00, 8.1054763158E-01],
	[2.15700E+04, 1.2686390557E+01, 5.4805643064E+00, 2.3484786882E+00, 1.4554024848E+00, 8.1063632827E-01],
	[2.15750E+04, 1.2690829244E+01, 5.4804541336E+00, 2.3502347449E+00, 1.4561273911E+00, 8.1072499132E-01],
	[2.15800E+04, 1.2695268455E+01, 5.4803439885E+00, 2.3519917073E+00, 1.4568523267E+00, 8.1081362075E-01],
	[2.15850E+04, 1.2699708190E+01, 5.4802338711E+00, 2.3537495758E+00, 1.4575772914E+00, 8.1090221656E-01],
	[2.15900E+04, 1.2704148449E+01, 5.4801237814E+00, 2.3555083504E+00, 1.4583022850E+00, 8.1099077874E-01],
	[2.15950E+04, 1.2708589232E+01, 5.4800137195E+00, 2.3572680315E+00, 1.4590273074E+00, 8.1107930730E-01],
	[2.16000E+04, 1.2713030538E+01, 5.4799036852E+00, 2.3590286193E+00, 1.4597523585E+00, 8.1116780225E-01],
	[2.16050E+04, 1.2717472368E+01, 5.4797936786E+00, 2.3607901141E+00, 1.4604774380E+00, 8.1125626358E-01],
	[2.16100E+04, 1.2721914721E+01, 5.4796836997E+00, 2.3625525162E+00, 1.4612025457E+00, 8.1134469130E-01],
	[2.16150E+04, 1.2726357598E+01, 5.4795737484E+00, 2.3643158257E+00, 1.4619276816E+00, 8.1143308541E-01],
	[2.16200E+04, 1.2730800998E+01, 5.4794638248E+00, 2.3660800431E+00, 1.4626528455E+00, 8.1152144591E-01],
	[2.16250E+04, 1.2735244922E+01, 5.4793539288E+00, 2.3678451684E+00, 1.4633780371E+00, 8.1160977281E-01],
	[2.16300E+04, 1.2739689369E+01, 5.4792440604E+00, 2.3696112020E+00, 1.4641032564E+00, 8.1169806611E-01],
	[2.16350E+04, 1.2744134339E+01, 5.4791342196E+00, 2.3713781442E+00, 1.4648285031E+00, 8.1178632581E-01],
	[2.16400E+04, 1.2748579833E+01, 5.4790244064E+00, 2.3731459951E+00, 1.4655537772E+00, 8.1187455191E-01],
	[2.16450E+04, 1.2753025849E+01, 5.4789146207E+00, 2.3749147551E+00, 1.4662790783E+00, 8.1196274443E-01],
	[2.16500E+04, 1.2757472389E+01, 5.4788048626E+00, 2.3766844244E+00, 1.4670044065E+00, 8.1205090335E-01],
	[2.16550E+04, 1.2761919452E+01, 5.4786951321E+00, 2.3784550032E+00, 1.4677297614E+00, 8.1213902868E-01],
	[2.16600E+04, 1.2766367038E+01, 5.4785854291E+00, 2.3802264919E+00, 1.4684551431E+00, 8.1222712044E-01],
	[2.16650E+04, 1.2770815146E+01, 5.4784757535E+00, 2.3819988906E+00, 1.4691805512E+00, 8.1231517861E-01],
	[2.16700E+04, 1.2775263778E+01, 5.4783661055E+00, 2.3837721997E+00, 1.4699059856E+00, 8.1240320320E-01],
	[2.16750E+04, 1.2779712932E+01, 5.4782564850E+00, 2.3855464194E+00, 1.4706314461E+00, 8.1249119422E-01],
	[2.16800E+04, 1.2784162609E+01, 5.4781468920E+00, 2.3873215499E+00, 1.4713569327E+00, 8.1257915166E-01],
	[2.16850E+04, 1.2788612808E+01, 5.4780373264E+00, 2.3890975915E+00, 1.4720824451E+00, 8.1266707554E-01],
	[2.16900E+04, 1.2793063531E+01, 5.4779277883E+00, 2.3908745445E+00, 1.4728079832E+00, 8.1275496585E-01],
	[2.16950E+04, 1.2797514775E+01, 5.4778182776E+00, 2.3926524091E+00, 1.4735335468E+00, 8.1284282260E-01],
	[2.17000E+04, 1.2801966543E+01, 5.4777087944E+00, 2.3944311855E+00, 1.4742591357E+00, 8.1293064579E-01],
	[2.17050E+04, 1.2806418832E+01, 5.4775993385E+00, 2.3962108742E+00, 1.4749847498E+00, 8.1301843542E-01],
	[2.17100E+04, 1.2810871644E+01, 5.4774899101E+00, 2.3979914752E+00, 1.4757103889E+00, 8.1310619149E-01],
	[2.17150E+04, 1.2815324979E+01, 5.4773805090E+00, 2.3997729888E+00, 1.4764360529E+00, 8.1319391402E-01],
	[2.17200E+04, 1.2819778835E+01, 5.4772711353E+00, 2.4015554154E+00, 1.4771617415E+00, 8.1328160300E-01],
	[2.17250E+04, 1.2824233214E+01, 5.4771617890E+00, 2.4033387551E+00, 1.4778874547E+00, 8.1336925843E-01],
	[2.17300E+04, 1.2828688115E+01, 5.4770524700E+00, 2.4051230082E+00, 1.4786131923E+00, 8.1345688032E-01],
	[2.17350E+04, 1.2833143538E+01, 5.4769431783E+00, 2.4069081750E+00, 1.4793389540E+00, 8.1354446868E-01],
	[2.17400E+04, 1.2837599483E+01, 5.4768339140E+00, 2.4086942558E+00, 1.4800647398E+00, 8.1363202350E-01],
	[2.17450E+04, 1.2842055950E+01, 5.4767246770E+00, 2.4104812508E+00, 1.4807905495E+00, 8.1371954479E-01],
	[2.17500E+04, 1.2846512939E+01, 5.4766154672E+00, 2.4122691602E+00, 1.4815163829E+00, 8.1380703255E-01],
	[2.17550E+04, 1.2850970450E+01, 5.4765062848E+00, 2.4140579843E+00, 1.4822422399E+00, 8.1389448678E-01],
	[2.17600E+04, 1.2855428482E+01, 5.4763971296E+00, 2.4158477234E+00, 1.4829681202E+00, 8.1398190750E-01],
	[2.17650E+04, 1.2859887036E+01, 5.4762880016E+00, 2.4176383777E+00, 1.4836940238E+00, 8.1406929469E-01],
	[2.17700E+04, 1.2864346112E+01, 5.4761789009E+00, 2.4194299474E+00, 1.4844199504E+00, 8.1415664837E-01],
	[2.17750E+04, 1.2868805710E+01, 5.4760698275E+00, 2.4212224330E+00, 1.4851458999E+00, 8.1424396854E-01],
	[2.17800E+04, 1.2873265829E+01, 5.4759607812E+00, 2.4230158345E+00, 1.4858718722E+00, 8.1433125520E-01],
	[2.17850E+04, 1.2877726469E+01, 5.4758517622E+00, 2.4248101523E+00, 1.4865978671E+00, 8.1441850835E-01],
	[2.17900E+04, 1.2882187631E+01, 5.4757427703E+00, 2.4266053866E+00, 1.4873238843E+00, 8.1450572801E-01],
	[2.17950E+04, 1.2886649315E+01, 5.4756338056E+00, 2.4284015376E+00, 1.4880499239E+00, 8.1459291416E-01],
	[2.18000E+04, 1.2891111519E+01, 5.4755248681E+00, 2.4301986057E+00, 1.4887759855E+00, 8.1468006682E-01],
	[2.18050E+04, 1.2895574245E+01, 5.4754159577E+00, 2.4319965911E+00, 1.4895020691E+00, 8.1476718599E-01],
	[2.18100E+04, 1.2900037492E+01, 5.4753070745E+00, 2.4337954940E+00, 1.4902281744E+00, 8.1485427167E-01],
	[2.18150E+04, 1.2904501261E+01, 5.4751982183E+00, 2.4355953148E+00, 1.4909543013E+00, 8.1494132387E-01],
	[2.18200E+04, 1.2908965550E+01, 5.4750893893E+00, 2.4373960535E+00, 1.4916804497E+00, 8.1502834259E-01],
	[2.18250E+04, 1.2913430360E+01, 5.4749805874E+00, 2.4391977106E+00, 1.4924066194E+00, 8.1511532783E-01],
	[2.18300E+04, 1.2917895691E+01, 5.4748718126E+00, 2.4410002863E+00, 1.4931328102E+00, 8.1520227960E-01],
	[2.18350E+04, 1.2922361544E+01, 5.4747630648E+00, 2.4428037808E+00, 1.4938590220E+00, 8.1528919789E-01],
	[2.18400E+04, 1.2926827917E+01, 5.4746543441E+00, 2.4446081944E+00, 1.4945852545E+00, 8.1537608272E-01],
	[2.18450E+04, 1.2931294811E+01, 5.4745456505E+00, 2.4464135274E+00, 1.4953115077E+00, 8.1546293409E-01],
	[2.18500E+04, 1.2935762225E+01, 5.4744369839E+00, 2.4482197799E+00, 1.4960377814E+00, 8.1554975200E-01],
	[2.18550E+04, 1.2940230160E+01, 5.4743283443E+00, 2.4500269523E+00, 1.4967640754E+00, 8.1563653645E-01],
	[2.18600E+04, 1.2944698616E+01, 5.4742197317E+00, 2.4518350449E+00, 1.4974903896E+00, 8.1572328746E-01],
	[2.18650E+04, 1.2949167592E+01, 5.4741111461E+00, 2.4536440578E+00, 1.4982167237E+00, 8.1581000501E-01],
	[2.18700E+04, 1.2953637089E+01, 5.4740025875E+00, 2.4554539913E+00, 1.4989430777E+00, 8.1589668912E-01],
	[2.18750E+04, 1.2958107107E+01, 5.4738940558E+00, 2.4572648458E+00, 1.4996694514E+00, 8.1598333979E-01],
	[2.18800E+04, 1.2962577644E+01, 5.4737855511E+00, 2.4590766214E+00, 1.5003958446E+00, 8.1606995702E-01],
	[2.18850E+04, 1.2967048702E+01, 5.4736770734E+00, 2.4608893184E+00, 1.5011222571E+00, 8.1615654082E-01],
	[2.18900E+04, 1.2971520281E+01, 5.4735686226E+00, 2.4627029371E+00, 1.5018486888E+00, 8.1624309120E-01],
	[2.18950E+04, 1.2975992379E+01, 5.4734601987E+00, 2.4645174777E+00, 1.5025751396E+00, 8.1632960814E-01],
	[2.19000E+04, 1.2980464998E+01, 5.4733518017E+00, 2.4663329405E+00, 1.5033016092E+00, 8.1641609167E-01],
	[2.19050E+04, 1.2984938136E+01, 5.4732434315E+00, 2.4681493257E+00, 1.5040280975E+00, 8.1650254177E-01],
	[2.19100E+04, 1.2989411795E+01, 5.4731350883E+00, 2.4699666336E+00, 1.5047546044E+00, 8.1658895847E-01],
	[2.19150E+04, 1.2993885974E+01, 5.4730267720E+00, 2.4717848645E+00, 1.5054811297E+00, 8.1667534175E-01],
	[2.19200E+04, 1.2998360672E+01, 5.4729184824E+00, 2.4736040186E+00, 1.5062076731E+00, 8.1676169163E-01],
	[2.19250E+04, 1.3002835891E+01, 5.4728102198E+00, 2.4754240962E+00, 1.5069342347E+00, 8.1684800810E-01],
	[2.19300E+04, 1.3007311629E+01, 5.4727019839E+00, 2.4772450976E+00, 1.5076608142E+00, 8.1693429118E-01],
	[2.19350E+04, 1.3011787887E+01, 5.4725937749E+00, 2.4790670229E+00, 1.5083874114E+00, 8.1702054087E-01],
	[2.19400E+04, 1.3016264664E+01, 5.4724855927E+00, 2.4808898724E+00, 1.5091140262E+00, 8.1710675716E-01],
	[2.19450E+04, 1.3020741962E+01, 5.4723774372E+00, 2.4827136465E+00, 1.5098406584E+00, 8.1719294007E-01],
	[2.19500E+04, 1.3025219778E+01, 5.4722693086E+00, 2.4845383453E+00, 1.5105673079E+00, 8.1727908960E-01],
	[2.19550E+04, 1.3029698115E+01, 5.4721612067E+00, 2.4863639692E+00, 1.5112939745E+00, 8.1736520574E-01],
	[2.19600E+04, 1.3034176970E+01, 5.4720531315E+00, 2.4881905183E+00, 1.5120206580E+00, 8.1745128852E-01],
	[2.19650E+04, 1.3038656346E+01, 5.4719450831E+00, 2.4900179930E+00, 1.5127473583E+00, 8.1753733792E-01],
	[2.19700E+04, 1.3043136240E+01, 5.4718370614E+00, 2.4918463935E+00, 1.5134740753E+00, 8.1762335395E-01],
	[2.19750E+04, 1.3047616654E+01, 5.4717290665E+00, 2.4936757200E+00, 1.5142008087E+00, 8.1770933662E-01],
	[2.19800E+04, 1.3052097587E+01, 5.4716210982E+00, 2.4955059728E+00, 1.5149275584E+00, 8.1779528592E-01],
	[2.19850E+04, 1.3056579039E+01, 5.4715131566E+00, 2.4973371522E+00, 1.5156543243E+00, 8.1788120185E-01],
	[2.19900E+04, 1.3061061010E+01, 5.4714052417E+00, 2.4991692585E+00, 1.5163811062E+00, 8.1796708443E-01],
	[2.19950E+04, 1.3065543500E+01, 5.4712973535E+00, 2.5010022918E+00, 1.5171079039E+00, 8.1805293365E-01],
	[2.20000E+04, 1.3070026509E+01, 5.4711894919E+00, 2.5028362525E+00, 1.5178347172E+00, 8.1813874952E-01],
	[2.20050E+04, 1.3074510038E+01, 5.4710816569E+00, 2.5046711408E+00, 1.5185615461E+00, 8.1822453204E-01],
	[2.20100E+04, 1.3078994085E+01, 5.4709738486E+00, 2.5065069569E+00, 1.5192883903E+00, 8.1831028121E-01],
	[2.20150E+04, 1.3083478650E+01, 5.4708660669E+00, 2.5083437012E+00, 1.5200152497E+00, 8.1839599703E-01],
	[2.20200E+04, 1.3087963735E+01, 5.4707583117E+00, 2.5101813738E+00, 1.5207421242E+00, 8.1848167951E-01],
	[2.20250E+04, 1.3092449338E+01, 5.4706505832E+00, 2.5120199751E+00, 1.5214690135E+00, 8.1856732864E-01],
	[2.20300E+04, 1.3096935460E+01, 5.4705428812E+00, 2.5138595053E+00, 1.5221959175E+00, 8.1865294445E-01],
	[2.20350E+04, 1.3101422100E+01, 5.4704352058E+00, 2.5156999646E+00, 1.5229228361E+00, 8.1873852691E-01],
	[2.20400E+04, 1.3105909259E+01, 5.4703275570E+00, 2.5175413534E+00, 1.5236497690E+00, 8.1882407605E-01],
	[2.20450E+04, 1.3110396937E+01, 5.4702199347E+00, 2.5193836718E+00, 1.5243767162E+00, 8.1890959185E-01],
	[2.20500E+04, 1.3114885133E+01, 5.4701123389E+00, 2.5212269202E+00, 1.5251036775E+00, 8.1899507433E-01],
	[2.20550E+04, 1.3119373847E+01, 5.4700047696E+00, 2.5230710987E+00, 1.5258306527E+00, 8.1908052349E-01],
	[2.20600E+04, 1.3123863079E+01, 5.4698972268E+00, 2.5249162077E+00, 1.5265576417E+00, 8.1916593933E-01],
	[2.20650E+04, 1.3128352830E+01, 5.4697897105E+00, 2.5267622474E+00, 1.5272846443E+00, 8.1925132184E-01],
	[2.20700E+04, 1.3132843099E+01, 5.4696822207E+00, 2.5286092180E+00, 1.5280116603E+00, 8.1933667105E-01],
	[2.20750E+04, 1.3137333886E+01, 5.4695747573E+00, 2.5304571199E+00, 1.5287386896E+00, 8.1942198694E-01],
	[2.20800E+04, 1.3141825191E+01, 5.4694673204E+00, 2.5323059532E+00, 1.5294657320E+00, 8.1950726953E-01],
	[2.20850E+04, 1.3146317014E+01, 5.4693599099E+00, 2.5341557183E+00, 1.5301927873E+00, 8.1959251881E-01],
	[2.20900E+04, 1.3150809355E+01, 5.4692525259E+00, 2.5360064154E+00, 1.5309198555E+00, 8.1967773479E-01],
	[2.20950E+04, 1.3155302214E+01, 5.4691451682E+00, 2.5378580448E+00, 1.5316469364E+00, 8.1976291747E-01],
	[2.21000E+04, 1.3159795590E+01, 5.4690378370E+00, 2.5397106066E+00, 1.5323740297E+00, 8.1984806685E-01],
	[2.21050E+04, 1.3164289485E+01, 5.4689305321E+00, 2.5415641013E+00, 1.5331011354E+00, 8.1993318295E-01],
	[2.21100E+04, 1.3168783897E+01, 5.4688232536E+00, 2.5434185289E+00, 1.5338282532E+00, 8.2001826575E-01],
	[2.21150E+04, 1.3173278827E+01, 5.4687160015E+00, 2.5452738899E+00, 1.5345553831E+00, 8.2010331526E-01],
	[2.21200E+04, 1.3177774274E+01, 5.4686087757E+00, 2.5471301844E+00, 1.5352825248E+00, 8.2018833150E-01],
	[2.21250E+04, 1.3182270239E+01, 5.4685015763E+00, 2.5489874127E+00, 1.5360096782E+00, 8.2027331445E-01],
	[2.21300E+04, 1.3186766722E+01, 5.4683944032E+00, 2.5508455750E+00, 1.5367368432E+00, 8.2035826413E-01],
	[2.21350E+04, 1.3191263721E+01, 5.4682872564E+00, 2.5527046717E+00, 1.5374640195E+00, 8.2044318053E-01],
	[2.21400E+04, 1.3195761239E+01, 5.4681801358E+00, 2.5545647030E+00, 1.5381912071E+00, 8.2052806366E-01],
	[2.21450E+04, 1.3200259273E+01, 5.4680730416E+00, 2.5564256691E+00, 1.5389184058E+00, 8.2061291353E-01],
	[2.21500E+04, 1.3204757825E+01, 5.4679659737E+00, 2.5582875703E+00, 1.5396456153E+00, 8.2069773013E-01],
	[2.21550E+04, 1.3209256894E+01, 5.4678589320E+00, 2.5601504069E+00, 1.5403728356E+00, 8.2078251347E-01],
	[2.21600E+04, 1.3213756480E+01, 5.4677519166E+00, 2.5620141791E+00, 1.5411000666E+00, 8.2086726356E-01],
	[2.21650E+04, 1.3218256583E+01, 5.4676449274E+00, 2.5638788872E+00, 1.5418273079E+00, 8.2095198039E-01],
	[2.21700E+04, 1.3222757203E+01, 5.4675379644E+00, 2.5657445314E+00, 1.5425545596E+00, 8.2103666397E-01],
	[2.21750E+04, 1.3227258341E+01, 5.4674310276E+00, 2.5676111120E+00, 1.5432818213E+00, 8.2112131431E-01],
	[2.21800E+04, 1.3231759995E+01, 5.4673241171E+00, 2.5694786292E+00, 1.5440090931E+00, 8.2120593140E-01],
	[2.21850E+04, 1.3236262166E+01, 5.4672172327E+00, 2.5713470833E+00, 1.5447363746E+00, 8.2129051525E-01],
	[2.21900E+04, 1.3240764853E+01, 5.4671103745E+00, 2.5732164747E+00, 1.5454636658E+00, 8.2137506587E-01],
	[2.21950E+04, 1.3245268058E+01, 5.4670035425E+00, 2.5750868034E+00, 1.5461909665E+00, 8.2145958325E-01],
	[2.22000E+04, 1.3249771779E+01, 5.4668967366E+00, 2.5769580699E+00, 1.5469182765E+00, 8.2154406741E-01],
	[2.22050E+04, 1.3254276017E+01, 5.4667899568E+00, 2.5788302742E+00, 1.5476455958E+00, 8.2162851833E-01],
	[2.22100E+04, 1.3258780771E+01, 5.4666832032E+00, 2.5807034168E+00, 1.5483729240E+00, 8.2171293604E-01],
	[2.22150E+04, 1.3263286042E+01, 5.4665764757E+00, 2.5825774979E+00, 1.5491002611E+00, 8.2179732053E-01],
	[2.22200E+04, 1.3267791829E+01, 5.4664697743E+00, 2.5844525176E+00, 1.5498276070E+00, 8.2188167180E-01],
	[2.22250E+04, 1.3272298133E+01, 5.4663630990E+00, 2.5863284764E+00, 1.5505549614E+00, 8.2196598987E-01],
	[2.22300E+04, 1.3276804953E+01, 5.4662564498E+00, 2.5882053744E+00, 1.5512823242E+00, 8.2205027472E-01],
	[2.22350E+04, 1.3281312289E+01, 5.4661498266E+00, 2.5900832118E+00, 1.5520096952E+00, 8.2213452637E-01],
	[2.22400E+04, 1.3285820142E+01, 5.4660432295E+00, 2.5919619891E+00, 1.5527370743E+00, 8.2221874483E-01],
	[2.22450E+04, 1.3290328510E+01, 5.4659366584E+00, 2.5938417063E+00, 1.5534644614E+00, 8.2230293008E-01],
	[2.22500E+04, 1.3294837395E+01, 5.4658301133E+00, 2.5957223639E+00, 1.5541918562E+00, 8.2238708214E-01],
	[2.22550E+04, 1.3299346796E+01, 5.4657235943E+00, 2.5976039619E+00, 1.5549192587E+00, 8.2247120102E-01],
	[2.22600E+04, 1.3303856713E+01, 5.4656171013E+00, 2.5994865008E+00, 1.5556466686E+00, 8.2255528670E-01],
	[2.22650E+04, 1.3308367146E+01, 5.4655106342E+00, 2.6013699807E+00, 1.5563740858E+00, 8.2263933921E-01],
	[2.22700E+04, 1.3312878095E+01, 5.4654041932E+00, 2.6032544019E+00, 1.5571015102E+00, 8.2272335854E-01],
	[2.22750E+04, 1.3317389559E+01, 5.4652977781E+00, 2.6051397647E+00, 1.5578289416E+00, 8.2280734470E-01],
	[2.22800E+04, 1.3321901539E+01, 5.4651913890E+00, 2.6070260693E+00, 1.5585563798E+00, 8.2289129768E-01],
	[2.22850E+04, 1.3326414035E+01, 5.4650850258E+00, 2.6089133160E+00, 1.5592838246E+00, 8.2297521750E-01],
	[2.22900E+04, 1.3330927047E+01, 5.4649786885E+00, 2.6108015051E+00, 1.5600112761E+00, 8.2305910416E-01],
	[2.22950E+04, 1.3335440574E+01, 5.4648723772E+00, 2.6126906367E+00, 1.5607387338E+00, 8.2314295766E-01],
	[2.23000E+04, 1.3339954617E+01, 5.4647660917E+00, 2.6145807112E+00, 1.5614661978E+00, 8.2322677800E-01],
	[2.23050E+04, 1.3344469175E+01, 5.4646598322E+00, 2.6164717289E+00, 1.5621936679E+00, 8.2331056520E-01],
	[2.23100E+04, 1.3348984249E+01, 5.4645535985E+00, 2.6183636899E+00, 1.5629211439E+00, 8.2339431924E-01],
	[2.23150E+04, 1.3353499838E+01, 5.4644473907E+00, 2.6202565945E+00, 1.5636486256E+00, 8.2347804015E-01],
	[2.23200E+04, 1.3358015942E+01, 5.4643412088E+00, 2.6221504431E+00, 1.5643761129E+00, 8.2356172792E-01],
	[2.23250E+04, 1.3362532562E+01, 5.4642350527E+00, 2.6240452358E+00, 1.5651036057E+00, 8.2364538255E-01],
	[2.23300E+04, 1.3367089094E+01, 5.4641371125E+00, 2.6259409730E+00, 1.5658323169E+00, 8.2372900405E-01],
	[2.23350E+04, 1.3371658510E+01, 5.4640417626E+00, 2.6278376548E+00, 1.5665614153E+00, 8.2381259243E-01],
	[2.23400E+04, 1.3376228465E+01, 5.4639464358E+00, 2.6297352815E+00, 1.5672905209E+00, 8.2389614768E-01],
	[2.23450E+04, 1.3380798958E+01, 5.4638511319E+00, 2.6316338535E+00, 1.5680196335E+00, 8.2397966982E-01],
	[2.23500E+04, 1.3385369990E+01, 5.4637558510E+00, 2.6335333709E+00, 1.5687487529E+00, 8.2406315884E-01],
	[2.23550E+04, 1.3389941561E+01, 5.4636605931E+00, 2.6354338340E+00, 1.5694778790E+00, 8.2414661475E-01],
	[2.23600E+04, 1.3394513670E+01, 5.4635653581E+00, 2.6373352431E+00, 1.5702070116E+00, 8.2423003756E-01],
	[2.23650E+04, 1.3399086317E+01, 5.4634701461E+00, 2.6392508343E+00, 1.5709408399E+00, 8.2431342727E-01],
	[2.23700E+04, 1.3403659503E+01, 5.4633749570E+00, 2.6411695442E+00, 1.5716754387E+00, 8.2439678388E-01],
	[2.23750E+04, 1.3408233227E+01, 5.4632797909E+00, 2.6430892197E+00, 1.5724100447E+00, 8.2448010739E-01],
	[2.23800E+04, 1.3412807489E+01, 5.4631846477E+00, 2.6450098611E+00, 1.5731446576E+00, 8.2456339782E-01],
	[2.23850E+04, 1.3417382289E+01, 5.4630895274E+00, 2.6469314686E+00, 1.5738792773E+00, 8.2464665516E-01],
	[2.23900E+04, 1.3421957627E+01, 5.4629944300E+00, 2.6488540425E+00, 1.5746139035E+00, 8.2472987942E-01],
	[2.23950E+04, 1.3426533504E+01, 5.4628993555E+00, 2.6507775832E+00, 1.5753485363E+00, 8.2481307061E-01],
	[2.24000E+04, 1.3431109918E+01, 5.4628043039E+00, 2.6527020908E+00, 1.5760831754E+00, 8.2489622872E-01],
	[2.24050E+04, 1.3435686871E+01, 5.4627092751E+00, 2.6546275656E+00, 1.5768178206E+00, 8.2497935377E-01],
	[2.24100E+04, 1.3440264361E+01, 5.4626142692E+00, 2.6565540079E+00, 1.5775524718E+00, 8.2506244575E-01],
	[2.24150E+04, 1.3444842389E+01, 5.4625192861E+00, 2.6584814180E+00, 1.5782871288E+00, 8.2514550468E-01],
	[2.24200E+04, 1.3449420955E+01, 5.4624243259E+00, 2.6604097961E+00, 1.5790217915E+00, 8.2522853055E-01],
	[2.24250E+04, 1.3454000058E+01, 5.4623293885E+00, 2.6623391425E+00, 1.5797564597E+00, 8.2531152337E-01],
	[2.24300E+04, 1.3458579700E+01, 5.4622344739E+00, 2.6642694575E+00, 1.5804911333E+00, 8.2539448315E-01],
	[2.24350E+04, 1.3463159878E+01, 5.4621395822E+00, 2.6662007413E+00, 1.5812258121E+00, 8.2547740988E-01],
	[2.24400E+04, 1.3467740595E+01, 5.4620447132E+00, 2.6681329943E+00, 1.5819604960E+00, 8.2556030358E-01],
	[2.24450E+04, 1.3472321849E+01, 5.4619498670E+00, 2.6700662166E+00, 1.5826951847E+00, 8.2564316425E-01],
	[2.24500E+04, 1.3476903640E+01, 5.4618550435E+00, 2.6720004086E+00, 1.5834298782E+00, 8.2572599189E-01],
	[2.24550E+04, 1.3481485968E+01, 5.4617602429E+00, 2.6739355706E+00, 1.5841645762E+00, 8.2580878651E-01],
	[2.24600E+04, 1.3486068834E+01, 5.4616654650E+00, 2.6758717027E+00, 1.5848992787E+00, 8.2589154810E-01],
	[2.24650E+04, 1.3490652238E+01, 5.4615707098E+00, 2.6778088053E+00, 1.5856339854E+00, 8.2597427669E-01],
	[2.24700E+04, 1.3495236178E+01, 5.4614759773E+00, 2.6797468786E+00, 1.5863686963E+00, 8.2605697226E-01],
	[2.24750E+04, 1.3499820655E+01, 5.4613812676E+00, 2.6816859230E+00, 1.5871034111E+00, 8.2613963483E-01],
	[2.24800E+04, 1.3504405670E+01, 5.4612865806E+00, 2.6836259386E+00, 1.5878381297E+00, 8.2622226441E-01],
	[2.24850E+04, 1.3508991222E+01, 5.4611919163E+00, 2.6855669258E+00, 1.5885728519E+00, 8.2630486098E-01],
	[2.24900E+04, 1.3513577310E+01, 5.4610972747E+00, 2.6875088848E+00, 1.5893075776E+00, 8.2638742457E-01],
	[2.24950E+04, 1.3518163936E+01, 5.4610026557E+00, 2.6894518159E+00, 1.5900423067E+00, 8.2646995516E-01],
	[2.25000E+04, 1.3522751098E+01, 5.4609080594E+00, 2.6913957193E+00, 1.5907770389E+00, 8.2655245278E-01],
	[2.25050E+04, 1.3527338797E+01, 5.4608134858E+00, 2.6933405954E+00, 1.5915117741E+00, 8.2663491742E-01],
	[2.25100E+04, 1.3531927033E+01, 5.4607189348E+00, 2.6952864444E+00, 1.5922465122E+00, 8.2671734909E-01],
	[2.25150E+04, 1.3536515806E+01, 5.4606244065E+00, 2.6972332665E+00, 1.5929812530E+00, 8.2679974779E-01],
	[2.25200E+04, 1.3541105115E+01, 5.4605299008E+00, 2.6991810621E+00, 1.5937159963E+00, 8.2688211353E-01],
	[2.25250E+04, 1.3545694961E+01, 5.4604354177E+00, 2.7011298314E+00, 1.5944507420E+00, 8.2696444631E-01],
	[2.25300E+04, 1.3550285343E+01, 5.4603409572E+00, 2.7030795747E+00, 1.5951854900E+00, 8.2704674614E-01],
	[2.25350E+04, 1.3554876262E+01, 5.4602465193E+00, 2.7050302922E+00, 1.5959202400E+00, 8.2712901302E-01],
	[2.25400E+04, 1.3559467717E+01, 5.4601521040E+00, 2.7069819843E+00, 1.5966549920E+00, 8.2721124696E-01],
	[2.25450E+04, 1.3564059709E+01, 5.4600577112E+00, 2.7089346512E+00, 1.5973897457E+00, 8.2729344796E-01],
	[2.25500E+04, 1.3568652237E+01, 5.4599633410E+00, 2.7108882931E+00, 1.5981245010E+00, 8.2737561602E-01],
	[2.25550E+04, 1.3573245301E+01, 5.4598689934E+00, 2.7128429103E+00, 1.5988592578E+00, 8.2745775116E-01],
	[2.25600E+04, 1.3577838901E+01, 5.4597746683E+00, 2.7147985032E+00, 1.5995940159E+00, 8.2753985337E-01],
	[2.25650E+04, 1.3582433037E+01, 5.4596803658E+00, 2.7167550719E+00, 1.6003287751E+00, 8.2762192267E-01],
	[2.25700E+04, 1.3587027710E+01, 5.4595860857E+00, 2.7187126168E+00, 1.6010635354E+00, 8.2770395905E-01],
	[2.25750E+04, 1.3591622918E+01, 5.4594918282E+00, 2.7206711381E+00, 1.6017982964E+00, 8.2778596252E-01],
	[2.25800E+04, 1.3596218663E+01, 5.4593975932E+00, 2.7226306361E+00, 1.6025330582E+00, 8.2786793309E-01],
	[2.25850E+04, 1.3600814943E+01, 5.4593033807E+00, 2.7245911111E+00, 1.6032678205E+00, 8.2794987076E-01],
	[2.25900E+04, 1.3605411759E+01, 5.4592091906E+00, 2.7265525633E+00, 1.6040025831E+00, 8.2803177553E-01],
	[2.25950E+04, 1.3610009111E+01, 5.4591150230E+00, 2.7285149930E+00, 1.6047373460E+00, 8.2811364742E-01],
	[2.26000E+04, 1.3614606999E+01, 5.4590208779E+00, 2.7304784004E+00, 1.6054721089E+00, 8.2819548642E-01],
	[2.26050E+04, 1.3619205422E+01, 5.4589267553E+00, 2.7324427859E+00, 1.6062068717E+00, 8.2827729255E-01],
	[2.26100E+04, 1.3623804381E+01, 5.4588326550E+00, 2.7344081497E+00, 1.6069416343E+00, 8.2835906580E-01],
	[2.26150E+04, 1.3628403876E+01, 5.4587385772E+00, 2.7363744921E+00, 1.6076763965E+00, 8.2844080618E-01],
	[2.26200E+04, 1.3633003906E+01, 5.4586445218E+00, 2.7383418134E+00, 1.6084111581E+00, 8.2852251370E-01],
	[2.26250E+04, 1.3637604471E+01, 5.4585504889E+00, 2.7403101137E+00, 1.6091459190E+00, 8.2860418836E-01],
	[2.26300E+04, 1.3642205572E+01, 5.4584564783E+00, 2.7422793935E+00, 1.6098806791E+00, 8.2868583016E-01],
	[2.26350E+04, 1.3646807209E+01, 5.4583624901E+00, 2.7442496529E+00, 1.6106154381E+00, 8.2876743912E-01],
	[2.26400E+04, 1.3651409380E+01, 5.4582685243E+00, 2.7462208923E+00, 1.6113501960E+00, 8.2884901524E-01],
	[2.26450E+04, 1.3656012087E+01, 5.4581745809E+00, 2.7481931119E+00, 1.6120849525E+00, 8.2893055852E-01],
	[2.26500E+04, 1.3660615329E+01, 5.4580806598E+00, 2.7501663119E+00, 1.6128197075E+00, 8.2901206896E-01],
	[2.26550E+04, 1.3665219106E+01, 5.4579867610E+00, 2.7521404927E+00, 1.6135544610E+00, 8.2909354658E-01],
	[2.26600E+04, 1.3669823418E+01, 5.4578928846E+00, 2.7541156546E+00, 1.6142892126E+00, 8.2917499138E-01],
	[2.26650E+04, 1.3674428265E+01, 5.4577990305E+00, 2.7560917977E+00, 1.6150239623E+00, 8.2925640336E-01],
	[2.26700E+04, 1.3679033647E+01, 5.4577051988E+00, 2.7580689224E+00, 1.6157587098E+00, 8.2933778253E-01],
	[2.26750E+04, 1.3683639564E+01, 5.4576113893E+00, 2.7600470289E+00, 1.6164934552E+00, 8.2941912889E-01],
	[2.26800E+04, 1.3688246016E+01, 5.4575176022E+00, 2.7620261175E+00, 1.6172281981E+00, 8.2950044245E-01],
	[2.26850E+04, 1.3692853002E+01, 5.4574238373E+00, 2.7640061885E+00, 1.6179629385E+00, 8.2958172322E-01],
	[2.26900E+04, 1.3697460524E+01, 5.4573300947E+00, 2.7659872421E+00, 1.6186976761E+00, 8.2966297120E-01],
	[2.26950E+04, 1.3702068580E+01, 5.4572363743E+00, 2.7679692787E+00, 1.6194324109E+00, 8.2974418639E-01],
	[2.27000E+04, 1.3706677170E+01, 5.4571426762E+00, 2.7699522984E+00, 1.6201671427E+00, 8.2982536880E-01],
	[2.27050E+04, 1.3711286295E+01, 5.4570490004E+00, 2.7719363016E+00, 1.6209018713E+00, 8.2990651844E-01],
	[2.27100E+04, 1.3715895955E+01, 5.4569553468E+00, 2.7739212885E+00, 1.6216365965E+00, 8.2998763531E-01],
	[2.27150E+04, 1.3720506149E+01, 5.4568617154E+00, 2.7759072595E+00, 1.6223713183E+00, 8.3006871942E-01],
	[2.27200E+04, 1.3725116878E+01, 5.4567681063E+00, 2.7778942147E+00, 1.6231060365E+00, 8.3014977077E-01],
	[2.27250E+04, 1.3729728140E+01, 5.4566745193E+00, 2.7798821544E+00, 1.6238407509E+00, 8.3023078937E-01],
	[2.27300E+04, 1.3734339938E+01, 5.4565809545E+00, 2.7818710790E+00, 1.6245754613E+00, 8.3031177522E-01],
	[2.27350E+04, 1.3738952269E+01, 5.4564874119E+00, 2.7838609886E+00, 1.6253101677E+00, 8.3039272833E-01],
	[2.27400E+04, 1.3743565134E+01, 5.4563938915E+00, 2.7858518836E+00, 1.6260448698E+00, 8.3047364871E-01],
	[2.27450E+04, 1.3748178534E+01, 5.4563003933E+00, 2.7878437642E+00, 1.6267795675E+00, 8.3055453635E-01],
	[2.27500E+04, 1.3752792468E+01, 5.4562069172E+00, 2.7898366308E+00, 1.6275142607E+00, 8.3063539127E-01],
	[2.27550E+04, 1.3757406935E+01, 5.4561134632E+00, 2.7918304835E+00, 1.6282489492E+00, 8.3071621348E-01],
	[2.27600E+04, 1.3762021937E+01, 5.4560200314E+00, 2.7938253226E+00, 1.6289836328E+00, 8.3079700297E-01],
	[2.27650E+04, 1.3766637472E+01, 5.4559266217E+00, 2.7958211484E+00, 1.6297183114E+00, 8.3087775975E-01],
	[2.27700E+04, 1.3771253542E+01, 5.4558332341E+00, 2.7978179613E+00, 1.6304529849E+00, 8.3095848383E-01],
	[2.27750E+04, 1.3775870145E+01, 5.4557398686E+00, 2.7998157614E+00, 1.6311876530E+00, 8.3103917521E-01],
	[2.27800E+04, 1.3780487281E+01, 5.4556465252E+00, 2.8018145490E+00, 1.6319223157E+00, 8.3111983390E-01],
	[2.27850E+04, 1.3785104952E+01, 5.4555532039E+00, 2.8038143244E+00, 1.6326569728E+00, 8.3120045991E-01],
	[2.27900E+04, 1.3789723156E+01, 5.4554599047E+00, 2.8058150878E+00, 1.6333916241E+00, 8.3128105324E-01],
	[2.27950E+04, 1.3794341894E+01, 5.4553666275E+00, 2.8078168397E+00, 1.6341262695E+00, 8.3136161389E-01],
	[2.28000E+04, 1.3798961165E+01, 5.4552733724E+00, 2.8098195801E+00, 1.6348609088E+00, 8.3144214188E-01],
	[2.28050E+04, 1.3803580969E+01, 5.4551801393E+00, 2.8118233094E+00, 1.6355955420E+00, 8.3152263721E-01],
	[2.28100E+04, 1.3808201307E+01, 5.4550869282E+00, 2.8138280278E+00, 1.6363301687E+00, 8.3160309987E-01],
	[2.28150E+04, 1.3812822179E+01, 5.4549937392E+00, 2.8158337357E+00, 1.6370647889E+00, 8.3168352989E-01],
	[2.28200E+04, 1.3817443583E+01, 5.4549005722E+00, 2.8178404333E+00, 1.6377994024E+00, 8.3176392726E-01],
	[2.28250E+04, 1.3822065521E+01, 5.4548074272E+00, 2.8198481208E+00, 1.6385340091E+00, 8.3184429200E-01],
	[2.28300E+04, 1.3826687992E+01, 5.4547143042E+00, 2.8218567986E+00, 1.6392686089E+00, 8.3192462410E-01],
	[2.28350E+04, 1.3831310996E+01, 5.4546212031E+00, 2.8238664669E+00, 1.6400032015E+00, 8.3200492357E-01],
	[2.28400E+04, 1.3835934534E+01, 5.4545281241E+00, 2.8258771260E+00, 1.6407377868E+00, 8.3208519042E-01],
	[2.28450E+04, 1.3840558604E+01, 5.4544350669E+00, 2.8278887761E+00, 1.6414723647E+00, 8.3216542466E-01],
	[2.28500E+04, 1.3845183207E+01, 5.4543420318E+00, 2.8299014176E+00, 1.6422069350E+00, 8.3224562629E-01],
	[2.28550E+04, 1.3849808343E+01, 5.4542490186E+00, 2.8319150506E+00, 1.6429414976E+00, 8.3232579531E-01],
	[2.28600E+04, 1.3854434012E+01, 5.4541560273E+00, 2.8339296755E+00, 1.6436760522E+00, 8.3240593173E-01],
	[2.28650E+04, 1.3859060213E+01, 5.4540630579E+00, 2.8359452926E+00, 1.6444105989E+00, 8.3248603556E-01],
	[2.28700E+04, 1.3863686948E+01, 5.4539701105E+00, 2.8379619020E+00, 1.6451451374E+00, 8.3256610679E-01],
	[2.28750E+04, 1.3868314215E+01, 5.4538771849E+00, 2.8399795041E+00, 1.6458796675E+00, 8.3264614544E-01],
	[2.28800E+04, 1.3872942014E+01, 5.4537842813E+00, 2.8419980992E+00, 1.6466141891E+00, 8.3272615151E-01],
	[2.28850E+04, 1.3877570347E+01, 5.4536913995E+00, 2.8440176876E+00, 1.6473487021E+00, 8.3280612500E-01],
	[2.28900E+04, 1.3882199211E+01, 5.4535985396E+00, 2.8460382694E+00, 1.6480832063E+00, 8.3288606592E-01],
	[2.28950E+04, 1.3886828609E+01, 5.4535057016E+00, 2.8480598449E+00, 1.6488177016E+00, 8.3296597427E-01],
	[2.29000E+04, 1.3891458538E+01, 5.4534128854E+00, 2.8500824146E+00, 1.6495521878E+00, 8.3304585006E-01],
	[2.29050E+04, 1.3896089000E+01, 5.4533200911E+00, 2.8521059785E+00, 1.6502866647E+00, 8.3312569329E-01],
	[2.29100E+04, 1.3900719994E+01, 5.4532273186E+00, 2.8541305370E+00, 1.6510211323E+00, 8.3320550396E-01],
	[2.29150E+04, 1.3905351521E+01, 5.4531345679E+00, 2.8561560904E+00, 1.6517555903E+00, 8.3328528209E-01],
	[2.29200E+04, 1.3909983579E+01, 5.4530418390E+00, 2.8581826388E+00, 1.6524900386E+00, 8.3336502767E-01],
	[2.29250E+04, 1.3914616170E+01, 5.4529491319E+00, 2.8602101827E+00, 1.6532244771E+00, 8.3344474071E-01],
	[2.29300E+04, 1.3919249293E+01, 5.4528564467E+00, 2.8622387223E+00, 1.6539589056E+00, 8.3352442122E-01],
	[2.29350E+04, 1.3923882948E+01, 5.4527637832E+00, 2.8642682578E+00, 1.6546933240E+00, 8.3360406919E-01],
	[2.29400E+04, 1.3928517134E+01, 5.4526711414E+00, 2.8662987895E+00, 1.6554277320E+00, 8.3368368464E-01],
	[2.29450E+04, 1.3933151853E+01, 5.4525785215E+00, 2.8683303177E+00, 1.6561621296E+00, 8.3376326757E-01],
	[2.29500E+04, 1.3937787104E+01, 5.4524859233E+00, 2.8703628426E+00, 1.6568965167E+00, 8.3384281798E-01],
	[2.29550E+04, 1.3942422886E+01, 5.4523933468E+00, 2.8723963646E+00, 1.6576308930E+00, 8.3392233589E-01],
	[2.29600E+04, 1.3947059200E+01, 5.4523007921E+00, 2.8744308839E+00, 1.6583652584E+00, 8.3400182128E-01],
	[2.29650E+04, 1.3951696046E+01, 5.4522082591E+00, 2.8764664007E+00, 1.6590996128E+00, 8.3408127418E-01],
	[2.29700E+04, 1.3956333423E+01, 5.4521157478E+00, 2.8785029154E+00, 1.6598339559E+00, 8.3416069458E-01],
	[2.29750E+04, 1.3960971332E+01, 5.4520232582E+00, 2.8805404282E+00, 1.6605682878E+00, 8.3424008248E-01],
	[2.29800E+04, 1.3965609773E+01, 5.4519307903E+00, 2.8825789394E+00, 1.6613026082E+00, 8.3431943791E-01],
	[2.29850E+04, 1.3970248744E+01, 5.4518383441E+00, 2.8846184492E+00, 1.6620369169E+00, 8.3439876084E-01],
	[2.29900E+04, 1.3974888248E+01, 5.4517459196E+00, 2.8866589580E+00, 1.6627712139E+00, 8.3447805131E-01],
	[2.29950E+04, 1.3979528282E+01, 5.4516535167E+00, 2.8887004660E+00, 1.6635054989E+00, 8.3455730930E-01],
	[2.30000E+04, 1.3984168848E+01, 5.4515611355E+00, 2.8907429734E+00, 1.6642397718E+00, 8.3463653482E-01],
	[2.30050E+04, 1.3988809946E+01, 5.4514687760E+00, 2.8927864806E+00, 1.6649740325E+00, 8.3471572789E-01],
	[2.30100E+04, 1.3993451574E+01, 5.4513764380E+00, 2.8948309878E+00, 1.6657082809E+00, 8.3479488849E-01],
	[2.30150E+04, 1.3998093734E+01, 5.4512841217E+00, 2.8968764953E+00, 1.6664425167E+00, 8.3487401665E-01],
	[2.30200E+04, 1.4002736424E+01, 5.4511918271E+00, 2.8989230033E+00, 1.6671767398E+00, 8.3495311236E-01],
	[2.30250E+04, 1.4007379646E+01, 5.4510995540E+00, 2.9009705122E+00, 1.6679109501E+00, 8.3503217562E-01],
	[2.30300E+04, 1.4012023399E+01, 5.4510073025E+00, 2.9030190222E+00, 1.6686451475E+00, 8.3511120645E-01],
	[2.30350E+04, 1.4016667682E+01, 5.4509150726E+00, 2.9050685336E+00, 1.6693793317E+00, 8.3519020485E-01],
	[2.30400E+04, 1.4021312497E+01, 5.4508228643E+00, 2.9071190466E+00, 1.6701135026E+00, 8.3526917083E-01],
	[2.30450E+04, 1.4025957842E+01, 5.4507306775E+00, 2.9091705616E+00, 1.6708476602E+00, 8.3534810438E-01],
	[2.30500E+04, 1.4030603718E+01, 5.4506385123E+00, 2.9112230787E+00, 1.6715818041E+00, 8.3542700552E-01],
	[2.30550E+04, 1.4035250124E+01, 5.4505463687E+00, 2.9132765983E+00, 1.6723159344E+00, 8.3550587425E-01],
	[2.30600E+04, 1.4039897062E+01, 5.4504542466E+00, 2.9153311206E+00, 1.6730500508E+00, 8.3558471057E-01],
	[2.30650E+04, 1.4044544530E+01, 5.4503621460E+00, 2.9173866460E+00, 1.6737841532E+00, 8.3566351449E-01],
	[2.30700E+04, 1.4049192528E+01, 5.4502700670E+00, 2.9194431746E+00, 1.6745182414E+00, 8.3574228602E-01],
	[2.30750E+04, 1.4053841057E+01, 5.4501780094E+00, 2.9215007068E+00, 1.6752523154E+00, 8.3582102516E-01],
	[2.30800E+04, 1.4058490116E+01, 5.4500859734E+00, 2.9235592428E+00, 1.6759863749E+00, 8.3589973191E-01],
	[2.30850E+04, 1.4063139706E+01, 5.4499939588E+00, 2.9256187829E+00, 1.6767204198E+00, 8.3597840629E-01],
	[2.30900E+04, 1.4067789826E+01, 5.4499019657E+00, 2.9276793274E+00, 1.6774544499E+00, 8.3605704829E-01],
	[2.30950E+04, 1.4072440476E+01, 5.4498099941E+00, 2.9297408765E+00, 1.6781884652E+00, 8.3613565793E-01],
	[2.31000E+04, 1.4077091657E+01, 5.4497180440E+00, 2.9318034305E+00, 1.6789224654E+00, 8.3621423520E-01],
	[2.31050E+04, 1.4081743368E+01, 5.4496261153E+00, 2.9338669897E+00, 1.6796564504E+00, 8.3629278012E-01],
	[2.31100E+04, 1.4086395608E+01, 5.4495342080E+00, 2.9359315544E+00, 1.6803904201E+00, 8.3637129268E-01],
	[2.31150E+04, 1.4091048379E+01, 5.4494423222E+00, 2.9379971248E+00, 1.6811243743E+00, 8.3644977290E-01],
	[2.31200E+04, 1.4095701680E+01, 5.4493504578E+00, 2.9400637012E+00, 1.6818583129E+00, 8.3652822077E-01],
	[2.31250E+04, 1.4100355511E+01, 5.4492586148E+00, 2.9421312839E+00, 1.6825922357E+00, 8.3660663631E-01],
	[2.31300E+04, 1.4105009871E+01, 5.4491667933E+00, 2.9441998731E+00, 1.6833261426E+00, 8.3668501952E-01],
	[2.31350E+04, 1.4109664762E+01, 5.4490749931E+00, 2.9462694691E+00, 1.6840600334E+00, 8.3676337041E-01],
	[2.31400E+04, 1.4114320182E+01, 5.4489832143E+00, 2.9483400723E+00, 1.6847939080E+00, 8.3684168898E-01],
	[2.31450E+04, 1.4118976132E+01, 5.4488914568E+00, 2.9504116828E+00, 1.6855277663E+00, 8.3691997523E-01],
	[2.31500E+04, 1.4123632612E+01, 5.4487997208E+00, 2.9524843009E+00, 1.6862616080E+00, 8.3699822917E-01],
	[2.31550E+04, 1.4128289621E+01, 5.4487080061E+00, 2.9545579270E+00, 1.6869954331E+00, 8.3707645082E-01],
	[2.31600E+04, 1.4132947160E+01, 5.4486163127E+00, 2.9566325612E+00, 1.6877292414E+00, 8.3715464016E-01],
	[2.31650E+04, 1.4137605228E+01, 5.4485246407E+00, 2.9587082039E+00, 1.6884630327E+00, 8.3723279722E-01],
	[2.31700E+04, 1.4142263826E+01, 5.4484329900E+00, 2.9607848553E+00, 1.6891968070E+00, 8.3731092199E-01],
	[2.31750E+04, 1.4146922953E+01, 5.4483413606E+00, 2.9628625157E+00, 1.6899305640E+00, 8.3738901448E-01],
	[2.31800E+04, 1.4151582609E+01, 5.4482497525E+00, 2.9649411854E+00, 1.6906643036E+00, 8.3746707469E-01],
	[2.31850E+04, 1.4156242795E+01, 5.4481581657E+00, 2.9670208646E+00, 1.6913980257E+00, 8.3754510264E-01],
	[2.31900E+04, 1.4160903510E+01, 5.4480666002E+00, 2.9691015536E+00, 1.6921317301E+00, 8.3762309832E-01],
	[2.31950E+04, 1.4165564754E+01, 5.4479750560E+00, 2.9711832527E+00, 1.6928654167E+00, 8.3770106175E-01],
	[2.32000E+04, 1.4170226528E+01, 5.4478835331E+00, 2.9732659622E+00, 1.6935990853E+00, 8.3777899292E-01],
	[2.32050E+04, 1.4174888830E+01, 5.4477920314E+00, 2.9753496823E+00, 1.6943327359E+00, 8.3785689185E-01],
	[2.32100E+04, 1.4179551661E+01, 5.4477005510E+00, 2.9774344133E+00, 1.6950663681E+00, 8.3793475854E-01],
	[2.32150E+04, 1.4184215022E+01, 5.4476090918E+00, 2.9795201555E+00, 1.6957999820E+00, 8.3801259299E-01],
	[2.32200E+04, 1.4188914242E+01, 5.4475244666E+00, 2.9816069092E+00, 1.6965347432E+00, 8.3809039521E-01],
	[2.32250E+04, 1.4193632561E+01, 5.4474434376E+00, 2.9836946745E+00, 1.6972700996E+00, 8.3816816522E-01],
	[2.32300E+04, 1.4198351433E+01, 5.4473624272E+00, 2.9857834519E+00, 1.6980054395E+00, 8.3824590300E-01],
	[2.32350E+04, 1.4203070858E+01, 5.4472814354E+00, 2.9878732415E+00, 1.6987407625E+00, 8.3832360857E-01],
	[2.32400E+04, 1.4207790836E+01, 5.4472004623E+00, 2.9899640437E+00, 1.6994760687E+00, 8.3840128194E-01],
	[2.32450E+04, 1.4212511366E+01, 5.4471195077E+00, 2.9920558587E+00, 1.7002113578E+00, 8.3847892311E-01],
	[2.32500E+04, 1.4217232449E+01, 5.4470385718E+00, 2.9941486868E+00, 1.7009466297E+00, 8.3855653209E-01],
	[2.32550E+04, 1.4221954084E+01, 5.4469576545E+00, 2.9962425282E+00, 1.7016818843E+00, 8.3863410887E-01],
	[2.32600E+04, 1.4226676272E+01, 5.4468767558E+00, 2.9983373832E+00, 1.7024171214E+00, 8.3871165348E-01],
	[2.32650E+04, 1.4231399012E+01, 5.4467958757E+00, 3.0004332522E+00, 1.7031523409E+00, 8.3878916591E-01],
	[2.32700E+04, 1.4236122305E+01, 5.4467150142E+00, 3.0025301353E+00, 1.7038875425E+00, 8.3886664617E-01],
	[2.32750E+04, 1.4240846150E+01, 5.4466341712E+00, 3.0046280329E+00, 1.7046227263E+00, 8.3894409427E-01],
	[2.32800E+04, 1.4245570547E+01, 5.4465533468E+00, 3.0067269452E+00, 1.7053578920E+00, 8.3902151021E-01],
	[2.32850E+04, 1.4250295497E+01, 5.4464725410E+00, 3.0088268725E+00, 1.7060930395E+00, 8.3909889399E-01],
	[2.32900E+04, 1.4255020998E+01, 5.4463917537E+00, 3.0109278151E+00, 1.7068281686E+00, 8.3917624563E-01],
	[2.32950E+04, 1.4259747052E+01, 5.4463109849E+00, 3.0130297732E+00, 1.7075632792E+00, 8.3925356513E-01],
	[2.33000E+04, 1.4264473658E+01, 5.4462302347E+00, 3.0151327471E+00, 1.7082983712E+00, 8.3933085250E-01],
	[2.33050E+04, 1.4269200816E+01, 5.4461495030E+00, 3.0172367371E+00, 1.7090334445E+00, 8.3940810774E-01],
	[2.33100E+04, 1.4273928526E+01, 5.4460687898E+00, 3.0193417435E+00, 1.7097684987E+00, 8.3948533085E-01],
	[2.33150E+04, 1.4278656788E+01, 5.4459880952E+00, 3.0214477665E+00, 1.7105035340E+00, 8.3956252185E-01],
	[2.33200E+04, 1.4283385601E+01, 5.4459074190E+00, 3.0235548064E+00, 1.7112385500E+00, 8.3963968075E-01],
	[2.33250E+04, 1.4288114967E+01, 5.4458267613E+00, 3.0256628635E+00, 1.7119735466E+00, 8.3971680753E-01],
	[2.33300E+04, 1.4292844884E+01, 5.4457461221E+00, 3.0277719380E+00, 1.7127085238E+00, 8.3979390222E-01],
	[2.33350E+04, 1.4297575353E+01, 5.4456655014E+00, 3.0298820302E+00, 1.7134434813E+00, 8.3987096482E-01],
	[2.33400E+04, 1.4302306374E+01, 5.4455848991E+00, 3.0319931405E+00, 1.7141784190E+00, 8.3994799534E-01],
	[2.33450E+04, 1.4307037946E+01, 5.4455043153E+00, 3.0341052690E+00, 1.7149133368E+00, 8.4002499377E-01],
	[2.33500E+04, 1.4311770069E+01, 5.4454237499E+00, 3.0362184160E+00, 1.7156482345E+00, 8.4010196014E-01],
	[2.33550E+04, 1.4316502744E+01, 5.4453432030E+00, 3.0383325819E+00, 1.7163831120E+00, 8.4017889443E-01],
	[2.33600E+04, 1.4321235971E+01, 5.4452626745E+00, 3.0404477669E+00, 1.7171179692E+00, 8.4025579667E-01],
	[2.33650E+04, 1.4325969749E+01, 5.4451821645E+00, 3.0425639712E+00, 1.7178528058E+00, 8.4033266685E-01],
	[2.33700E+04, 1.4330704078E+01, 5.4451016728E+00, 3.0446811951E+00, 1.7185876219E+00, 8.4040950499E-01],
	[2.33750E+04, 1.4335438959E+01, 5.4450211996E+00, 3.0467994390E+00, 1.7193224171E+00, 8.4048631108E-01],
	[2.33800E+04, 1.4340174390E+01, 5.4449407448E+00, 3.0489187030E+00, 1.7200571914E+00, 8.4056308514E-01],
	[2.33850E+04, 1.4344910373E+01, 5.4448603083E+00, 3.0510389875E+00, 1.7207919446E+00, 8.4063982717E-01],
	[2.33900E+04, 1.4349646907E+01, 5.4447798903E+00, 3.0531602927E+00, 1.7215266766E+00, 8.4071653717E-01],
	[2.33950E+04, 1.4354383992E+01, 5.4446994906E+00, 3.0552826189E+00, 1.7222613873E+00, 8.4079321517E-01],
	[2.34000E+04, 1.4359121628E+01, 5.4446191093E+00, 3.0574059663E+00, 1.7229960765E+00, 8.4086986115E-01],
	[2.34050E+04, 1.4363859815E+01, 5.4445387464E+00, 3.0595303353E+00, 1.7237307440E+00, 8.4094647512E-01],
	[2.34100E+04, 1.4368598553E+01, 5.4444584018E+00, 3.0616557262E+00, 1.7244653898E+00, 8.4102305710E-01],
	[2.34150E+04, 1.4373337841E+01, 5.4443780755E+00, 3.0637821391E+00, 1.7252000136E+00, 8.4109960710E-01],
	[2.34200E+04, 1.4378077681E+01, 5.4442977676E+00, 3.0659095744E+00, 1.7259346154E+00, 8.4117612510E-01],
	[2.34250E+04, 1.4382818071E+01, 5.4442174780E+00, 3.0680380323E+00, 1.7266691949E+00, 8.4125261113E-01],
	[2.34300E+04, 1.4387559012E+01, 5.4441372067E+00, 3.0701675131E+00, 1.7274037521E+00, 8.4132906519E-01],
	[2.34350E+04, 1.4392300503E+01, 5.4440569538E+00, 3.0722980171E+00, 1.7281382869E+00, 8.4140548728E-01],
	[2.34400E+04, 1.4397042545E+01, 5.4439767191E+00, 3.0744295446E+00, 1.7288727990E+00, 8.4148187741E-01],
	[2.34450E+04, 1.4401785138E+01, 5.4438965028E+00, 3.0765620958E+00, 1.7296072883E+00, 8.4155823559E-01],
	[2.34500E+04, 1.4406528281E+01, 5.4438163047E+00, 3.0786956710E+00, 1.7303417547E+00, 8.4163456183E-01],
	[2.34550E+04, 1.4411271974E+01, 5.4437361249E+00, 3.0808302705E+00, 1.7310761981E+00, 8.4171085613E-01],
	[2.34600E+04, 1.4416016218E+01, 5.4436559634E+00, 3.0829658945E+00, 1.7318106183E+00, 8.4178711850E-01],
	[2.34650E+04, 1.4420761012E+01, 5.4435758201E+00, 3.0851025433E+00, 1.7325450151E+00, 8.4186334894E-01],
	[2.34700E+04, 1.4425506356E+01, 5.4434956951E+00, 3.0872402172E+00, 1.7332793884E+00, 8.4193954746E-01],
	[2.34750E+04, 1.4430252250E+01, 5.4434155883E+00, 3.0893789165E+00, 1.7340137382E+00, 8.4201571406E-01],
	[2.34800E+04, 1.4434998695E+01, 5.4433354998E+00, 3.0915186415E+00, 1.7347480642E+00, 8.4209184877E-01],
	[2.34850E+04, 1.4439745690E+01, 5.4432554295E+00, 3.0936593924E+00, 1.7354823663E+00, 8.4216795157E-01],
	[2.34900E+04, 1.4444493234E+01, 5.4431753775E+00, 3.0958011694E+00, 1.7362166443E+00, 8.4224402248E-01],
	[2.34950E+04, 1.4449241329E+01, 5.4430953436E+00, 3.0979439729E+00, 1.7369508982E+00, 8.4232006150E-01],
	[2.35000E+04, 1.4453989974E+01, 5.4430153280E+00, 3.1000878032E+00, 1.7376851277E+00, 8.4239606865E-01],
	[2.35050E+04, 1.4458739168E+01, 5.4429353305E+00, 3.1022326604E+00, 1.7384193328E+00, 8.4247204392E-01],
	[2.35100E+04, 1.4463488912E+01, 5.4428553513E+00, 3.1043785449E+00, 1.7391535133E+00, 8.4254798733E-01],
	[2.35150E+04, 1.4468239206E+01, 5.4427753902E+00, 3.1065254570E+00, 1.7398876690E+00, 8.4262389887E-01],
	[2.35200E+04, 1.4472990050E+01, 5.4426954473E+00, 3.1086733969E+00, 1.7406217999E+00, 8.4269977857E-01],
	[2.35250E+04, 1.4477741444E+01, 5.4426155226E+00, 3.1108223649E+00, 1.7413559058E+00, 8.4277562642E-01],
	[2.35300E+04, 1.4482493387E+01, 5.4425356160E+00, 3.1129723613E+00, 1.7420899864E+00, 8.4285144243E-01],
	[2.35350E+04, 1.4487245879E+01, 5.4424557276E+00, 3.1151233864E+00, 1.7428240418E+00, 8.4292722660E-01],
	[2.35400E+04, 1.4491998921E+01, 5.4423758573E+00, 3.1172754403E+00, 1.7435580718E+00, 8.4300297895E-01],
	[2.35450E+04, 1.4496752513E+01, 5.4422960051E+00, 3.1194285235E+00, 1.7442920761E+00, 8.4307869949E-01],
	[2.35500E+04, 1.4501506654E+01, 5.4422161711E+00, 3.1215826361E+00, 1.7450260548E+00, 8.4315438821E-01],
	[2.35550E+04, 1.4506261344E+01, 5.4421363552E+00, 3.1237377785E+00, 1.7457600076E+00, 8.4323004512E-01],
	[2.35600E+04, 1.4511016583E+01, 5.4420565574E+00, 3.1258939509E+00, 1.7464939343E+00, 8.4330567024E-01],
	[2.35650E+04, 1.4515772372E+01, 5.4419767777E+00, 3.1280511535E+00, 1.7472278350E+00, 8.4338126357E-01],
	[2.35700E+04, 1.4520528710E+01, 5.4418970162E+00, 3.1302093868E+00, 1.7479617094E+00, 8.4345682511E-01],
	[2.35750E+04, 1.4525285597E+01, 5.4418172727E+00, 3.1323686508E+00, 1.7486955573E+00, 8.4353235487E-01],
	[2.35800E+04, 1.4530043033E+01, 5.4417375472E+00, 3.1345289460E+00, 1.7494293787E+00, 8.4360785286E-01],
	[2.35850E+04, 1.4534801018E+01, 5.4416578399E+00, 3.1366902726E+00, 1.7501631734E+00, 8.4368331909E-01],
	[2.35900E+04, 1.4539559552E+01, 5.4415781506E+00, 3.1388526308E+00, 1.7508969413E+00, 8.4375875356E-01],
	[2.35950E+04, 1.4544318635E+01, 5.4414984793E+00, 3.1410160210E+00, 1.7516306822E+00, 8.4383415628E-01],
	[2.36000E+04, 1.4549078267E+01, 5.4414188262E+00, 3.1431804433E+00, 1.7523643959E+00, 8.4390952726E-01],
	[2.36050E+04, 1.4553838448E+01, 5.4413391910E+00, 3.1453458982E+00, 1.7530980825E+00, 8.4398486650E-01],
	[2.36100E+04, 1.4558599177E+01, 5.4412595739E+00, 3.1475123857E+00, 1.7538317416E+00, 8.4406017402E-01],
	[2.36150E+04, 1.4563360455E+01, 5.4411799748E+00, 3.1496799064E+00, 1.7545653732E+00, 8.4413544981E-01],
	[2.36200E+04, 1.4568122282E+01, 5.4411003937E+00, 3.1518484603E+00, 1.7552989772E+00, 8.4421069388E-01],
	[2.36250E+04, 1.4572884657E+01, 5.4410208307E+00, 3.1540180478E+00, 1.7560325533E+00, 8.4428590625E-01],
	[2.36300E+04, 1.4577647581E+01, 5.4409412856E+00, 3.1561886691E+00, 1.7567661016E+00, 8.4436108692E-01],
	[2.36350E+04, 1.4582411054E+01, 5.4408617585E+00, 3.1583603245E+00, 1.7574996217E+00, 8.4443623589E-01],
	[2.36400E+04, 1.4587175075E+01, 5.4407822494E+00, 3.1605330144E+00, 1.7582331136E+00, 8.4451135317E-01],
	[2.36450E+04, 1.4591939644E+01, 5.4407027583E+00, 3.1627067389E+00, 1.7589665771E+00, 8.4458643878E-01],
	[2.36500E+04, 1.4596704761E+01, 5.4406232852E+00, 3.1648814983E+00, 1.7597000122E+00, 8.4466149271E-01],
	[2.36550E+04, 1.4601470427E+01, 5.4405438300E+00, 3.1670572930E+00, 1.7604334186E+00, 8.4473651498E-01],
	[2.36600E+04, 1.4606236641E+01, 5.4404643927E+00, 3.1692341232E+00, 1.7611667963E+00, 8.4481150559E-01],
	[2.36650E+04, 1.4611003403E+01, 5.4403849734E+00, 3.1714119891E+00, 1.7619001450E+00, 8.4488646454E-01],
	[2.36700E+04, 1.4615770714E+01, 5.4403055721E+00, 3.1735908910E+00, 1.7626334647E+00, 8.4496139186E-01],
	[2.36750E+04, 1.4620538572E+01, 5.4402261887E+00, 3.1757708293E+00, 1.7633667552E+00, 8.4503628753E-01],
	[2.36800E+04, 1.4625306979E+01, 5.4401468232E+00, 3.1779518042E+00, 1.7641000164E+00, 8.4511115158E-01],
	[2.36850E+04, 1.4630075933E+01, 5.4400674756E+00, 3.1801338159E+00, 1.7648332481E+00, 8.4518598400E-01],
	[2.36900E+04, 1.4634845435E+01, 5.4399881459E+00, 3.1823168647E+00, 1.7655664503E+00, 8.4526078481E-01],
	[2.36950E+04, 1.4639615485E+01, 5.4399088341E+00, 3.1845009510E+00, 1.7662996227E+00, 8.4533555400E-01],
	[2.37000E+04, 1.4644386083E+01, 5.4398295402E+00, 3.1866860749E+00, 1.7670327652E+00, 8.4541029160E-01],
	[2.37050E+04, 1.4649157229E+01, 5.4397502642E+00, 3.1888722368E+00, 1.7677658778E+00, 8.4548499760E-01],
	[2.37100E+04, 1.4653928922E+01, 5.4396710061E+00, 3.1910594369E+00, 1.7684989602E+00, 8.4555967202E-01],
	[2.37150E+04, 1.4658701163E+01, 5.4395917658E+00, 3.1932476755E+00, 1.7692320123E+00, 8.4563431486E-01],
	[2.37200E+04, 1.4663473952E+01, 5.4395125434E+00, 3.1954369529E+00, 1.7699650340E+00, 8.4570892612E-01],
	[2.37250E+04, 1.4668247288E+01, 5.4394333388E+00, 3.1976272693E+00, 1.7706980251E+00, 8.4578350582E-01],
	[2.37300E+04, 1.4673021172E+01, 5.4393541521E+00, 3.1998186251E+00, 1.7714309855E+00, 8.4585805395E-01],
	[2.37350E+04, 1.4677795603E+01, 5.4392749832E+00, 3.2020110205E+00, 1.7721639152E+00, 8.4593257053E-01],
	[2.37400E+04, 1.4682570581E+01, 5.4391958322E+00, 3.2042044557E+00, 1.7728968138E+00, 8.4600705557E-01],
	[2.37450E+04, 1.4687346107E+01, 5.4391166990E+00, 3.2063989311E+00, 1.7736296814E+00, 8.4608150905E-01],
	[2.37500E+04, 1.4692122180E+01, 5.4390375835E+00, 3.2085944469E+00, 1.7743625177E+00, 8.4615593101E-01],
	[2.37550E+04, 1.4696898800E+01, 5.4389584859E+00, 3.2107910034E+00, 1.7750953226E+00, 8.4623032143E-01],
	[2.37600E+04, 1.4701675968E+01, 5.4388794061E+00, 3.2129886008E+00, 1.7758280961E+00, 8.4630468032E-01],
	[2.37650E+04, 1.4706453682E+01, 5.4388003441E+00, 3.2151872395E+00, 1.7765608379E+00, 8.4637900770E-01],
	[2.37700E+04, 1.4711231944E+01, 5.4387212998E+00, 3.2173869197E+00, 1.7772935479E+00, 8.4645330356E-01],
	[2.37750E+04, 1.4716010753E+01, 5.4386422733E+00, 3.2195876418E+00, 1.7780262260E+00, 8.4652756792E-01],
	[2.37800E+04, 1.4720790108E+01, 5.4385632646E+00, 3.2217894058E+00, 1.7787588720E+00, 8.4660180078E-01],
	[2.37850E+04, 1.4725570011E+01, 5.4384842737E+00, 3.2239922122E+00, 1.7794914859E+00, 8.4667600214E-01],
	[2.37900E+04, 1.4730350460E+01, 5.4384053005E+00, 3.2261960613E+00, 1.7802240674E+00, 8.4675017202E-01],
	[2.37950E+04, 1.4735131456E+01, 5.4383263450E+00, 3.2284009532E+00, 1.7809566165E+00, 8.4682431041E-01],
	[2.38000E+04, 1.4739912999E+01, 5.4382474073E+00, 3.2306068883E+00, 1.7816891330E+00, 8.4689841733E-01],
	[2.38050E+04, 1.4744695089E+01, 5.4381684873E+00, 3.2328138668E+00, 1.7824216167E+00, 8.4697249278E-01],
	[2.38100E+04, 1.4749477725E+01, 5.4380895850E+00, 3.2350218890E+00, 1.7831540676E+00, 8.4704653677E-01],
	[2.38150E+04, 1.4754260908E+01, 5.4380107005E+00, 3.2372309552E+00, 1.7838864855E+00, 8.4712054929E-01],
	[2.38200E+04, 1.4759044637E+01, 5.4379318336E+00, 3.2394410657E+00, 1.7846188702E+00, 8.4719453037E-01],
	[2.38250E+04, 1.4763828913E+01, 5.4378529844E+00, 3.2416522207E+00, 1.7853512217E+00, 8.4726848001E-01],
	[2.38300E+04, 1.4768613736E+01, 5.4377741530E+00, 3.2438644205E+00, 1.7860835398E+00, 8.4734239821E-01],
	[2.38350E+04, 1.4773399104E+01, 5.4376953392E+00, 3.2460776653E+00, 1.7868158243E+00, 8.4741628497E-01],
	[2.38400E+04, 1.4778185019E+01, 5.4376165430E+00, 3.2482919556E+00, 1.7875480752E+00, 8.4749014031E-01],
	[2.38450E+04, 1.4782971481E+01, 5.4375377646E+00, 3.2505072915E+00, 1.7882802923E+00, 8.4756396424E-01],
	[2.38500E+04, 1.4787758488E+01, 5.4374590038E+00, 3.2527236732E+00, 1.7890124754E+00, 8.4763775674E-01],
	[2.38550E+04, 1.4792546042E+01, 5.4373802606E+00, 3.2549411012E+00, 1.7897446244E+00, 8.4771151785E-01],
	[2.38600E+04, 1.4797334142E+01, 5.4373015351E+00, 3.2571595756E+00, 1.7904767392E+00, 8.4778524755E-01],
	[2.38650E+04, 1.4802122788E+01, 5.4372228273E+00, 3.2593790967E+00, 1.7912088197E+00, 8.4785894586E-01],
	[2.38700E+04, 1.4806911980E+01, 5.4371441370E+00, 3.2615996649E+00, 1.7919408657E+00, 8.4793261279E-01],
	[2.38750E+04, 1.4811701718E+01, 5.4370654644E+00, 3.2638212803E+00, 1.7926728770E+00, 8.4800624833E-01],
	[2.38800E+04, 1.4816492002E+01, 5.4369868094E+00, 3.2660439432E+00, 1.7934048537E+00, 8.4807985250E-01],
	[2.38850E+04, 1.4821282831E+01, 5.4369081720E+00, 3.2682676540E+00, 1.7941367954E+00, 8.4815342531E-01],
	[2.38900E+04, 1.4826074207E+01, 5.4368295522E+00, 3.2704924129E+00, 1.7948687021E+00, 8.4822696675E-01],
	[2.38950E+04, 1.4830866128E+01, 5.4367509500E+00, 3.2727182202E+00, 1.7956005737E+00, 8.4830047684E-01],
	[2.39000E+04, 1.4835658595E+01, 5.4366723653E+00, 3.2749450761E+00, 1.7963324100E+00, 8.4837395558E-01],
	[2.39050E+04, 1.4840451608E+01, 5.4365937983E+00, 3.2771729809E+00, 1.7970642109E+00, 8.4844740298E-01],
	[2.39100E+04, 1.4845245166E+01, 5.4365152488E+00, 3.2794019350E+00, 1.7977959762E+00, 8.4852081905E-01],
	[2.39150E+04, 1.4850039270E+01, 5.4364367168E+00, 3.2816319385E+00, 1.7985277058E+00, 8.4859420378E-01],
	[2.39200E+04, 1.4854833919E+01, 5.4363582024E+00, 3.2838629917E+00, 1.7992593996E+00, 8.4866755720E-01],
	[2.39250E+04, 1.4859629114E+01, 5.4362797056E+00, 3.2860950950E+00, 1.7999910575E+00, 8.4874087930E-01],
	[2.39300E+04, 1.4864424854E+01, 5.4362012263E+00, 3.2883282486E+00, 1.8007226792E+00, 8.4881417010E-01],
	[2.39350E+04, 1.4869221140E+01, 5.4361227645E+00, 3.2905624527E+00, 1.8014542648E+00, 8.4888742959E-01],
	[2.39400E+04, 1.4874017970E+01, 5.4360443203E+00, 3.2927977077E+00, 1.8021858140E+00, 8.4896065778E-01],
	[2.39450E+04, 1.4878815346E+01, 5.4359658935E+00, 3.2950340138E+00, 1.8029173267E+00, 8.4903385469E-01],
	[2.39500E+04, 1.4883613268E+01, 5.4358874843E+00, 3.2972713713E+00, 1.8036488028E+00, 8.4910702032E-01],
	[2.39550E+04, 1.4888411734E+01, 5.4358090925E+00, 3.2995097805E+00, 1.8043802422E+00, 8.4918015468E-01],
	[2.39600E+04, 1.4893210745E+01, 5.4357307183E+00, 3.3017492416E+00, 1.8051116446E+00, 8.4925325776E-01],
	[2.39650E+04, 1.4898010302E+01, 5.4356523615E+00, 3.3039897549E+00, 1.8058430101E+00, 8.4932632959E-01],
	[2.39700E+04, 1.4902810403E+01, 5.4355740222E+00, 3.3062313207E+00, 1.8065743384E+00, 8.4939937016E-01],
	[2.39750E+04, 1.4907611050E+01, 5.4354957004E+00, 3.3084739393E+00, 1.8073056294E+00, 8.4947237948E-01],
	[2.39800E+04, 1.4912412241E+01, 5.4354173961E+00, 3.3107176110E+00, 1.8080368830E+00, 8.4954535756E-01],
	[2.39850E+04, 1.4917213977E+01, 5.4353391092E+00, 3.3129623359E+00, 1.8087680991E+00, 8.4961830441E-01],
	[2.39900E+04, 1.4922016258E+01, 5.4352608397E+00, 3.3152081145E+00, 1.8094992775E+00, 8.4969122003E-01],
	[2.39950E+04, 1.4926819083E+01, 5.4351825877E+00, 3.3174549469E+00, 1.8102304181E+00, 8.4976410442E-01],
	[2.40000E+04, 1.4931622453E+01, 5.4351043531E+00, 3.3197028334E+00, 1.8109615207E+00, 8.4983695761E-01],
	[2.40050E+04, 1.4936426368E+01, 5.4350261359E+00, 3.3219517744E+00, 1.8116925853E+00, 8.4990977959E-01],
	[2.40100E+04, 1.4941230828E+01, 5.4349479361E+00, 3.3242017701E+00, 1.8124236116E+00, 8.4998257037E-01],
	[2.40150E+04, 1.4946035832E+01, 5.4348697538E+00, 3.3264528207E+00, 1.8131545996E+00, 8.5005532995E-01],
	[2.40200E+04, 1.4950841380E+01, 5.4347915889E+00, 3.3287049266E+00, 1.8138855492E+00, 8.5012805835E-01],
	[2.40250E+04, 1.4955647473E+01, 5.4347134413E+00, 3.3309580880E+00, 1.8146164602E+00, 8.5020075558E-01],
	[2.40300E+04, 1.4960454110E+01, 5.4346353111E+00, 3.3332123051E+00, 1.8153473324E+00, 8.5027342162E-01],
	[2.40350E+04, 1.4965261291E+01, 5.4345571983E+00, 3.3354675784E+00, 1.8160781657E+00, 8.5034605651E-01],
	[2.40400E+04, 1.4970069017E+01, 5.4344791029E+00, 3.3377239080E+00, 1.8168089601E+00, 8.5041866023E-01],
	[2.40450E+04, 1.4974877287E+01, 5.4344010249E+00, 3.3399812941E+00, 1.8175397154E+00, 8.5049123281E-01],
	[2.40500E+04, 1.4979686101E+01, 5.4343229642E+00, 3.3422397372E+00, 1.8182704313E+00, 8.5056377424E-01],
	[2.40550E+04, 1.4984495459E+01, 5.4342449208E+00, 3.3444992375E+00, 1.8190011079E+00, 8.5063628453E-01],
	[2.40600E+04, 1.4989305362E+01, 5.4341668948E+00, 3.3467597952E+00, 1.8197317450E+00, 8.5070876369E-01],
	[2.40650E+04, 1.4994115808E+01, 5.4340888861E+00, 3.3490214106E+00, 1.8204623424E+00, 8.5078121173E-01],
	[2.40700E+04, 1.4998926798E+01, 5.4340108948E+00, 3.3512840840E+00, 1.8211929001E+00, 8.5085362865E-01],
	[2.40750E+04, 1.5003738332E+01, 5.4339329207E+00, 3.3535478157E+00, 1.8219234178E+00, 8.5092601446E-01],
	[2.40800E+04, 1.5008550410E+01, 5.4338549640E+00, 3.3558126059E+00, 1.8226538955E+00, 8.5099836917E-01],
	[2.40850E+04, 1.5013363032E+01, 5.4337770246E+00, 3.3580784549E+00, 1.8233843331E+00, 8.5107069279E-01],
	[2.40900E+04, 1.5018176197E+01, 5.4336991024E+00, 3.3603453630E+00, 1.8241147303E+00, 8.5114298531E-01],
	[2.40950E+04, 1.5022989906E+01, 5.4336211976E+00, 3.3626133305E+00, 1.8248450871E+00, 8.5121524676E-01],
	[2.41000E+04, 1.5027804159E+01, 5.4335433101E+00, 3.3648823576E+00, 1.8255754033E+00, 8.5128747713E-01],
	[2.41050E+04, 1.5032618955E+01, 5.4334654398E+00, 3.3671524446E+00, 1.8263056788E+00, 8.5135967644E-01],
	[2.41100E+04, 1.5037434295E+01, 5.4333875868E+00, 3.3694235918E+00, 1.8270359135E+00, 8.5143184469E-01],
	[2.41150E+04, 1.5042250179E+01, 5.4333097510E+00, 3.3716957995E+00, 1.8277661073E+00, 8.5150398188E-01],
	[2.41200E+04, 1.5047066605E+01, 5.4332319325E+00, 3.3739690680E+00, 1.8284962600E+00, 8.5157608803E-01],
	[2.41250E+04, 1.5051883576E+01, 5.4331541312E+00, 3.3762433974E+00, 1.8292263714E+00, 8.5164816314E-01],
	[2.41300E+04, 1.5056701089E+01, 5.4330763472E+00, 3.3785187882E+00, 1.8299564416E+00, 8.5172020722E-01],
	[2.41350E+04, 1.5061519146E+01, 5.4329985804E+00, 3.3807952405E+00, 1.8306864702E+00, 8.5179222028E-01],
	[2.41400E+04, 1.5066337746E+01, 5.4329208308E+00, 3.3830727546E+00, 1.8314164572E+00, 8.5186420232E-01],
	[2.41450E+04, 1.5071181916E+01, 5.4328475750E+00, 3.3853513309E+00, 1.8321472815E+00, 8.5193615335E-01],
	[2.41500E+04, 1.5076057741E+01, 5.4327798963E+00, 3.3876309695E+00, 1.8328791576E+00, 8.5200807338E-01],
	[2.41550E+04, 1.5080934132E+01, 5.4327122325E+00, 3.3899116708E+00, 1.8336109939E+00, 8.5207996242E-01],
	[2.41600E+04, 1.5085811092E+01, 5.4326445835E+00, 3.3921934351E+00, 1.8343427903E+00, 8.5215182047E-01],
	[2.41650E+04, 1.5090688619E+01, 5.4325769493E+00, 3.3944762626E+00, 1.8350745467E+00, 8.5222364754E-01],
	[2.41700E+04, 1.5095566713E+01, 5.4325093300E+00, 3.3967601536E+00, 1.8358062629E+00, 8.5229544364E-01],
	[2.41750E+04, 1.5100445374E+01, 5.4324417255E+00, 3.3990451083E+00, 1.8365379389E+00, 8.5236720877E-01],
	[2.41800E+04, 1.5105324603E+01, 5.4323741358E+00, 3.4013311271E+00, 1.8372695745E+00, 8.5243894294E-01],
	[2.41850E+04, 1.5110204399E+01, 5.4323065609E+00, 3.4036182102E+00, 1.8380011695E+00, 8.5251064617E-01],
	[2.41900E+04, 1.5115084763E+01, 5.4322390009E+00, 3.4059063579E+00, 1.8387327239E+00, 8.5258231845E-01],
	[2.41950E+04, 1.5119965693E+01, 5.4321714556E+00, 3.4081955705E+00, 1.8394642375E+00, 8.5265395979E-01],
	[2.42000E+04, 1.5124847191E+01, 5.4321039252E+00, 3.4104858482E+00, 1.8401957102E+00, 8.5272557021E-01],
	[2.42050E+04, 1.5129729255E+01, 5.4320364095E+00, 3.4127771913E+00, 1.8409271419E+00, 8.5279714971E-01],
	[2.42100E+04, 1.5134611887E+01, 5.4319689087E+00, 3.4150696002E+00, 1.8416585324E+00, 8.5286869829E-01],
	[2.42150E+04, 1.5139495085E+01, 5.4319014226E+00, 3.4173630750E+00, 1.8423898816E+00, 8.5294021597E-01],
	[2.42200E+04, 1.5144378851E+01, 5.4318339512E+00, 3.4196576160E+00, 1.8431211893E+00, 8.5301170274E-01],
	[2.42250E+04, 1.5149263183E+01, 5.4317664947E+00, 3.4219532236E+00, 1.8438524555E+00, 8.5308315863E-01],
	[2.42300E+04, 1.5154148082E+01, 5.4316990529E+00, 3.4242498979E+00, 1.8445836800E+00, 8.5315458363E-01],
	[2.42350E+04, 1.5159033547E+01, 5.4316316258E+00, 3.4265476394E+00, 1.8453148628E+00, 8.5322597776E-01],
	[2.42400E+04, 1.5163919580E+01, 5.4315642135E+00, 3.4288464482E+00, 1.8460460035E+00, 8.5329734102E-01],
	[2.42450E+04, 1.5168806179E+01, 5.4314968159E+00, 3.4311463246E+00, 1.8467771022E+00, 8.5336867342E-01],
	[2.42500E+04, 1.5173693344E+01, 5.4314294331E+00, 3.4334472689E+00, 1.8475081588E+00, 8.5343997497E-01],
	[2.42550E+04, 1.5178581077E+01, 5.4313620650E+00, 3.4357492814E+00, 1.8482391730E+00, 8.5351124566E-01],
	[2.42600E+04, 1.5183469375E+01, 5.4312947116E+00, 3.4380523623E+00, 1.8489701447E+00, 8.5358248553E-01],
	[2.42650E+04, 1.5188358240E+01, 5.4312273730E+00, 3.4403565120E+00, 1.8497010739E+00, 8.5365369456E-01],
	[2.42700E+04, 1.5193247672E+01, 5.4311600490E+00, 3.4426617307E+00, 1.8504319604E+00, 8.5372487276E-01],
	[2.42750E+04, 1.5198137669E+01, 5.4310927398E+00, 3.4449680186E+00, 1.8511628040E+00, 8.5379602015E-01],
	[2.42800E+04, 1.5203028233E+01, 5.4310254452E+00, 3.4472753761E+00, 1.8518936047E+00, 8.5386713674E-01],
	[2.42850E+04, 1.5207919364E+01, 5.4309581653E+00, 3.4495838034E+00, 1.8526243623E+00, 8.5393822252E-01],
	[2.42900E+04, 1.5212811060E+01, 5.4308909001E+00, 3.4518933009E+00, 1.8533550767E+00, 8.5400927751E-01],
	[2.42950E+04, 1.5217703322E+01, 5.4308236496E+00, 3.4542038687E+00, 1.8540857478E+00, 8.5408030171E-01],
	[2.43000E+04, 1.5222596151E+01, 5.4307564138E+00, 3.4565155071E+00, 1.8548163754E+00, 8.5415129514E-01],
	[2.43050E+04, 1.5227489546E+01, 5.4306891926E+00, 3.4588282165E+00, 1.8555469594E+00, 8.5422225780E-01],
	[2.43100E+04, 1.5232383506E+01, 5.4306219861E+00, 3.4611419971E+00, 1.8562774997E+00, 8.5429318970E-01],
	[2.43150E+04, 1.5237278033E+01, 5.4305547943E+00, 3.4634568492E+00, 1.8570079961E+00, 8.5436409084E-01],
	[2.43200E+04, 1.5242173125E+01, 5.4304876170E+00, 3.4657727731E+00, 1.8577384486E+00, 8.5443496123E-01],
	[2.43250E+04, 1.5247068783E+01, 5.4304204545E+00, 3.4680897689E+00, 1.8584688570E+00, 8.5450580089E-01],
	[2.43300E+04, 1.5251965007E+01, 5.4303533065E+00, 3.4704078371E+00, 1.8591992212E+00, 8.5457660982E-01],
	[2.43350E+04, 1.5256861797E+01, 5.4302861732E+00, 3.4727269779E+00, 1.8599295410E+00, 8.5464738802E-01],
	[2.43400E+04, 1.5261759152E+01, 5.4302190545E+00, 3.4750471915E+00, 1.8606598164E+00, 8.5471813551E-01],
	[2.43450E+04, 1.5266657073E+01, 5.4301519505E+00, 3.4773684783E+00, 1.8613900471E+00, 8.5478885228E-01],
	[2.43500E+04, 1.5271555559E+01, 5.4300848610E+00, 3.4796908385E+00, 1.8621202332E+00, 8.5485953836E-01],
	[2.43550E+04, 1.5276454611E+01, 5.4300177862E+00, 3.4820142723E+00, 1.8628503744E+00, 8.5493019375E-01],
	[2.43600E+04, 1.5281354229E+01, 5.4299507259E+00, 3.4843387802E+00, 1.8635804706E+00, 8.5500081845E-01],
	[2.43650E+04, 1.5286254411E+01, 5.4298836802E+00, 3.4866643622E+00, 1.8643105217E+00, 8.5507141248E-01],
	[2.43700E+04, 1.5291155160E+01, 5.4298166491E+00, 3.4889910188E+00, 1.8650405276E+00, 8.5514197583E-01],
	[2.43750E+04, 1.5296056473E+01, 5.4297496326E+00, 3.4913187502E+00, 1.8657704881E+00, 8.5521250853E-01],
	[2.43800E+04, 1.5300958352E+01, 5.4296826307E+00, 3.4936475567E+00, 1.8665004032E+00, 8.5528301057E-01],
	[2.43850E+04, 1.5305860796E+01, 5.4296156433E+00, 3.4959774384E+00, 1.8672302726E+00, 8.5535348197E-01],
	[2.43900E+04, 1.5310763805E+01, 5.4295486705E+00, 3.4983083959E+00, 1.8679600964E+00, 8.5542392273E-01],
	[2.43950E+04, 1.5315667379E+01, 5.4294817123E+00, 3.5006404292E+00, 1.8686898742E+00, 8.5549433286E-01],
	[2.44000E+04, 1.5320571518E+01, 5.4294147686E+00, 3.5029735386E+00, 1.8694196062E+00, 8.5556471237E-01],
	[2.44050E+04, 1.5325476222E+01, 5.4293478394E+00, 3.5053077246E+00, 1.8701492920E+00, 8.5563506127E-01],
	[2.44100E+04, 1.5330381491E+01, 5.4292809248E+00, 3.5076429872E+00, 1.8708789315E+00, 8.5570537956E-01],
	[2.44150E+04, 1.5335287326E+01, 5.4292140247E+00, 3.5099793268E+00, 1.8716085248E+00, 8.5577566725E-01],
	[2.44200E+04, 1.5340193724E+01, 5.4291471391E+00, 3.5123167438E+00, 1.8723380715E+00, 8.5584592436E-01],
	[2.44250E+04, 1.5345100688E+01, 5.4290802680E+00, 3.5146552382E+00, 1.8730675717E+00, 8.5591615088E-01],
	[2.44300E+04, 1.5350008217E+01, 5.4290134115E+00, 3.5169948105E+00, 1.8737970251E+00, 8.5598634683E-01],
	[2.44350E+04, 1.5354916310E+01, 5.4289465694E+00, 3.5193354609E+00, 1.8745264317E+00, 8.5605651221E-01],
	[2.44400E+04, 1.5359824968E+01, 5.4288797419E+00, 3.5216771897E+00, 1.8752557913E+00, 8.5612664704E-01],
	[2.44450E+04, 1.5364734190E+01, 5.4288129288E+00, 3.5240199972E+00, 1.8759851038E+00, 8.5619675131E-01],
	[2.44500E+04, 1.5369643977E+01, 5.4287461303E+00, 3.5263638835E+00, 1.8767143691E+00, 8.5626682505E-01],
	[2.44550E+04, 1.5374554328E+01, 5.4286793462E+00, 3.5287088491E+00, 1.8774435871E+00, 8.5633686825E-01],
	[2.44600E+04, 1.5379465244E+01, 5.4286125766E+00, 3.5310548942E+00, 1.8781727576E+00, 8.5640688092E-01],
	[2.44650E+04, 1.5384376724E+01, 5.4285458214E+00, 3.5334020190E+00, 1.8789018805E+00, 8.5647686308E-01],
	[2.44700E+04, 1.5389288769E+01, 5.4284790808E+00, 3.5357502238E+00, 1.8796309557E+00, 8.5654681473E-01],
	[2.44750E+04, 1.5394201378E+01, 5.4284123545E+00, 3.5380995090E+00, 1.8803599830E+00, 8.5661673588E-01],
	[2.44800E+04, 1.5399114551E+01, 5.4283456428E+00, 3.5404498747E+00, 1.8810889624E+00, 8.5668662653E-01],
	[2.44850E+04, 1.5404028288E+01, 5.4282789454E+00, 3.5428013214E+00, 1.8818178937E+00, 8.5675648670E-01],
	[2.44900E+04, 1.5408942590E+01, 5.4282122625E+00, 3.5451538491E+00, 1.8825467768E+00, 8.5682631639E-01],
	[2.44950E+04, 1.5413857455E+01, 5.4281455941E+00, 3.5475074583E+00, 1.8832756116E+00, 8.5689611562E-01],
	[2.45000E+04, 1.5418772885E+01, 5.4280789401E+00, 3.5498621492E+00, 1.8840043979E+00, 8.5696588438E-01],
	[2.45050E+04, 1.5423688879E+01, 5.4280123004E+00, 3.5522179220E+00, 1.8847331356E+00, 8.5703562269E-01],
	[2.45100E+04, 1.5428605436E+01, 5.4279456752E+00, 3.5545747771E+00, 1.8854618246E+00, 8.5710533056E-01],
	[2.45150E+04, 1.5433522557E+01, 5.4278790644E+00, 3.5569327147E+00, 1.8861904648E+00, 8.5717500799E-01],
	[2.45200E+04, 1.5438440243E+01, 5.4278124681E+00, 3.5592917351E+00, 1.8869190561E+00, 8.5724465499E-01],
	[2.45250E+04, 1.5443358492E+01, 5.4277458861E+00, 3.5616518385E+00, 1.8876475983E+00, 8.5731427157E-01],
	[2.45300E+04, 1.5448277304E+01, 5.4276793185E+00, 3.5640130254E+00, 1.8883760913E+00, 8.5738385774E-01],
	[2.45350E+04, 1.5453196681E+01, 5.4276127652E+00, 3.5663752958E+00, 1.8891045350E+00, 8.5745341351E-01],
	[2.45400E+04, 1.5458116621E+01, 5.4275462264E+00, 3.5687386502E+00, 1.8898329293E+00, 8.5752293888E-01],
	[2.45450E+04, 1.5463037125E+01, 5.4274797019E+00, 3.5711030887E+00, 1.8905612740E+00, 8.5759243387E-01],
	[2.45500E+04, 1.5467958192E+01, 5.4274131918E+00, 3.5734686117E+00, 1.8912895690E+00, 8.5766189848E-01],
	[2.45550E+04, 1.5472879823E+01, 5.4273466960E+00, 3.5758352194E+00, 1.8920178142E+00, 8.5773133271E-01],
	[2.45600E+04, 1.5477802017E+01, 5.4272802147E+00, 3.5782029121E+00, 1.8927460095E+00, 8.5780073659E-01],
	[2.45650E+04, 1.5482724774E+01, 5.4272137476E+00, 3.5805716902E+00, 1.8934741547E+00, 8.5787011010E-01],
	[2.45700E+04, 1.5487648095E+01, 5.4271472949E+00, 3.5829415537E+00, 1.8942022498E+00, 8.5793945326E-01],
	[2.45750E+04, 1.5492571979E+01, 5.4270808565E+00, 3.5853125032E+00, 1.8949302946E+00, 8.5800876608E-01],
	[2.45800E+04, 1.5497496427E+01, 5.4270144325E+00, 3.5876845387E+00, 1.8956582890E+00, 8.5807804857E-01],
	[2.45850E+04, 1.5502421437E+01, 5.4269480228E+00, 3.5900576606E+00, 1.8963862328E+00, 8.5814730072E-01],
	[2.45900E+04, 1.5507347011E+01, 5.4268816274E+00, 3.5924318692E+00, 1.8971141260E+00, 8.5821652256E-01],
	[2.45950E+04, 1.5512273148E+01, 5.4268152463E+00, 3.5948071647E+00, 1.8978419684E+00, 8.5828571408E-01],
	[2.46000E+04, 1.5517199847E+01, 5.4267488795E+00, 3.5971835475E+00, 1.8985697599E+00, 8.5835487529E-01],
	[2.46050E+04, 1.5522127110E+01, 5.4266825270E+00, 3.5995610177E+00, 1.8992975004E+00, 8.5842400620E-01],
	[2.46100E+04, 1.5527054936E+01, 5.4266161888E+00, 3.6019395757E+00, 1.9000251898E+00, 8.5849310682E-01],
	[2.46150E+04, 1.5531983324E+01, 5.4265498649E+00, 3.6043192218E+00, 1.9007528279E+00, 8.5856217715E-01],
	[2.46200E+04, 1.5536912276E+01, 5.4264835553E+00, 3.6066999562E+00, 1.9014804146E+00, 8.5863121720E-01],
	[2.46250E+04, 1.5541841790E+01, 5.4264172599E+00, 3.6090817792E+00, 1.9022079498E+00, 8.5870022699E-01],
	[2.46300E+04, 1.5546771867E+01, 5.4263509788E+00, 3.6114646910E+00, 1.9029354334E+00, 8.5876920650E-01],
	[2.46350E+04, 1.5551702507E+01, 5.4262847120E+00, 3.6138486921E+00, 1.9036628653E+00, 8.5883815577E-01],
	[2.46400E+04, 1.5556633709E+01, 5.4262184594E+00, 3.6162337825E+00, 1.9043902452E+00, 8.5890707478E-01],
	[2.46450E+04, 1.5561565474E+01, 5.4261522211E+00, 3.6186199627E+00, 1.9051175732E+00, 8.5897596355E-01],
	[2.46500E+04, 1.5566497801E+01, 5.4260859971E+00, 3.6210072329E+00, 1.9058448491E+00, 8.5904482209E-01],
	[2.46550E+04, 1.5571430691E+01, 5.4260197872E+00, 3.6233955933E+00, 1.9065720728E+00, 8.5911365039E-01],
	[2.46600E+04, 1.5576364143E+01, 5.4259535917E+00, 3.6257850443E+00, 1.9072992441E+00, 8.5918244848E-01],
	[2.46650E+04, 1.5581298158E+01, 5.4258874103E+00, 3.6281755860E+00, 1.9080263630E+00, 8.5925121636E-01],
	[2.46700E+04, 1.5586232735E+01, 5.4258212432E+00, 3.6305672189E+00, 1.9087534293E+00, 8.5931995403E-01],
	[2.46750E+04, 1.5591167874E+01, 5.4257550902E+00, 3.6329599431E+00, 1.9094804428E+00, 8.5938866150E-01],
	[2.46800E+04, 1.5596103576E+01, 5.4256889515E+00, 3.6353537590E+00, 1.9102074036E+00, 8.5945733879E-01],
	[2.46850E+04, 1.5601039840E+01, 5.4256228270E+00, 3.6377486668E+00, 1.9109343114E+00, 8.5952598588E-01],
	[2.46900E+04, 1.5605976665E+01, 5.4255567167E+00, 3.6401446668E+00, 1.9116611661E+00, 8.5959460281E-01],
	[2.46950E+04, 1.5610914053E+01, 5.4254906206E+00, 3.6425417593E+00, 1.9123879676E+00, 8.5966318956E-01],
	[2.47000E+04, 1.5615852003E+01, 5.4254245386E+00, 3.6449399445E+00, 1.9131147159E+00, 8.5973174616E-01],
	[2.47050E+04, 1.5620790515E+01, 5.4253584709E+00, 3.6473392228E+00, 1.9138414107E+00, 8.5980027260E-01],
	[2.47100E+04, 1.5625729589E+01, 5.4252924173E+00, 3.6497395944E+00, 1.9145680520E+00, 8.5986876890E-01],
	[2.47150E+04, 1.5630669225E+01, 5.4252263779E+00, 3.6521410595E+00, 1.9152946396E+00, 8.5993723506E-01],
	[2.47200E+04, 1.5635609423E+01, 5.4251603526E+00, 3.6545436185E+00, 1.9160211734E+00, 8.6000567108E-01],
	[2.47250E+04, 1.5640550182E+01, 5.4250943415E+00, 3.6569472717E+00, 1.9167476533E+00, 8.6007407699E-01],
	[2.47300E+04, 1.5645491503E+01, 5.4250283446E+00, 3.6593520193E+00, 1.9174740793E+00, 8.6014245278E-01],
	[2.47350E+04, 1.5650433386E+01, 5.4249623618E+00, 3.6617578615E+00, 1.9182004510E+00, 8.6021079846E-01],
	[2.47400E+04, 1.5655375830E+01, 5.4248963931E+00, 3.6641647987E+00, 1.9189267685E+00, 8.6027911404E-01],
	[2.47450E+04, 1.5660318836E+01, 5.4248304386E+00, 3.6665728312E+00, 1.9196530317E+00, 8.6034739953E-01],
	[2.47500E+04, 1.5665262404E+01, 5.4247644982E+00, 3.6689819592E+00, 1.9203792403E+00, 8.6041565493E-01],
	[2.47550E+04, 1.5670206533E+01, 5.4246985719E+00, 3.6713921830E+00, 1.9211053944E+00, 8.6048388026E-01],
	[2.47600E+04, 1.5675151224E+01, 5.4246326598E+00, 3.6738035028E+00, 1.9218314937E+00, 8.6055207551E-01],
	[2.47650E+04, 1.5680096475E+01, 5.4245667617E+00, 3.6762159190E+00, 1.9225575381E+00, 8.6062024070E-01],
	[2.47700E+04, 1.5685042289E+01, 5.4245008777E+00, 3.6786294319E+00, 1.9232835276E+00, 8.6068837584E-01],
	[2.47750E+04, 1.5689988663E+01, 5.4244350079E+00, 3.6810440416E+00, 1.9240094620E+00, 8.6075648093E-01],
	[2.47800E+04, 1.5694935599E+01, 5.4243691521E+00, 3.6834597486E+00, 1.9247353412E+00, 8.6082455599E-01],
	[2.47850E+04, 1.5699883096E+01, 5.4243033105E+00, 3.6858765530E+00, 1.9254611651E+00, 8.6089260101E-01],
	[2.47900E+04, 1.5704831154E+01, 5.4242374829E+00, 3.6882944551E+00, 1.9261869335E+00, 8.6096061600E-01],
	[2.47950E+04, 1.5709779773E+01, 5.4241716693E+00, 3.6907134552E+00, 1.9269126464E+00, 8.6102860098E-01],
	[2.48000E+04, 1.5714728953E+01, 5.4241058699E+00, 3.6931335537E+00, 1.9276383036E+00, 8.6109655595E-01],
	[2.48050E+04, 1.5719678695E+01, 5.4240400845E+00, 3.6955547507E+00, 1.9283639050E+00, 8.6116448092E-01],
	[2.48100E+04, 1.5724628997E+01, 5.4239743132E+00, 3.6979770465E+00, 1.9290894505E+00, 8.6123237590E-01],
	[2.48150E+04, 1.5729579860E+01, 5.4239085559E+00, 3.7004004415E+00, 1.9298149399E+00, 8.6130024089E-01],
	[2.48200E+04, 1.5734531284E+01, 5.4238428127E+00, 3.7028249359E+00, 1.9305403732E+00, 8.6136807591E-01],
	[2.48250E+04, 1.5739483268E+01, 5.4237770835E+00, 3.7052505299E+00, 1.9312657503E+00, 8.6143588095E-01],
	[2.48300E+04, 1.5744435814E+01, 5.4237113683E+00, 3.7076772239E+00, 1.9319910710E+00, 8.6150365604E-01],
	[2.48350E+04, 1.5749388920E+01, 5.4236456672E+00, 3.7101050182E+00, 1.9327163352E+00, 8.6157140117E-01],
	[2.48400E+04, 1.5754342587E+01, 5.4235799800E+00, 3.7125339129E+00, 1.9334415427E+00, 8.6163911635E-01],
	[2.48450E+04, 1.5759296814E+01, 5.4235143069E+00, 3.7149639084E+00, 1.9341666935E+00, 8.6170680159E-01],
	[2.48500E+04, 1.5764251602E+01, 5.4234486479E+00, 3.7173950050E+00, 1.9348917875E+00, 8.6177445691E-01],
	[2.48550E+04, 1.5769206950E+01, 5.4233830028E+00, 3.7198272030E+00, 1.9356168246E+00, 8.6184208230E-01],
	[2.48600E+04, 1.5774162859E+01, 5.4233173717E+00, 3.7222605025E+00, 1.9363418045E+00, 8.6190967778E-01],
	[2.48650E+04, 1.5779119328E+01, 5.4232517546E+00, 3.7246949039E+00, 1.9370667272E+00, 8.6197724335E-01],
	[2.48700E+04, 1.5784076358E+01, 5.4231861515E+00, 3.7271304076E+00, 1.9377915927E+00, 8.6204477902E-01],
	[2.48750E+04, 1.5789033948E+01, 5.4231205624E+00, 3.7295670136E+00, 1.9385164007E+00, 8.6211228480E-01],
	[2.48800E+04, 1.5793992098E+01, 5.4230549872E+00, 3.7320047224E+00, 1.9392411511E+00, 8.6217976069E-01],
	[2.48850E+04, 1.5798950808E+01, 5.4229894260E+00, 3.7344435342E+00, 1.9399658439E+00, 8.6224720672E-01],
	[2.48900E+04, 1.5803910079E+01, 5.4229238788E+00, 3.7368834493E+00, 1.9406904789E+00, 8.6231462287E-01],
	[2.48950E+04, 1.5808869909E+01, 5.4228583456E+00, 3.7393244679E+00, 1.9414150560E+00, 8.6238200916E-01],
	[2.49000E+04, 1.5813830300E+01, 5.4227928263E+00, 3.7417665904E+00, 1.9421395751E+00, 8.6244936561E-01],
	[2.49050E+04, 1.5818791251E+01, 5.4227273209E+00, 3.7442098170E+00, 1.9428640361E+00, 8.6251669221E-01],
	[2.49100E+04, 1.5823752761E+01, 5.4226618295E+00, 3.7466541479E+00, 1.9435884388E+00, 8.6258398897E-01],
	[2.49150E+04, 1.5828714832E+01, 5.4225963520E+00, 3.7490995836E+00, 1.9443127832E+00, 8.6265125591E-01],
	[2.49200E+04, 1.5833677462E+01, 5.4225308885E+00, 3.7515461242E+00, 1.9450370691E+00, 8.6271849303E-01],
	[2.49250E+04, 1.5838640652E+01, 5.4224654388E+00, 3.7539937700E+00, 1.9457612964E+00, 8.6278570034E-01],
	[2.49300E+04, 1.5843604402E+01, 5.4224000031E+00, 3.7564425213E+00, 1.9464854650E+00, 8.6285287784E-01],
	[2.49350E+04, 1.5848568712E+01, 5.4223345813E+00, 3.7588923784E+00, 1.9472095748E+00, 8.6292002555E-01],
	[2.49400E+04, 1.5853533581E+01, 5.4222691734E+00, 3.7613433415E+00, 1.9479336257E+00, 8.6298714347E-01],
	[2.49450E+04, 1.5858499010E+01, 5.4222037794E+00, 3.7637954110E+00, 1.9486576175E+00, 8.6305423161E-01],
	[2.49500E+04, 1.5863464998E+01, 5.4221383993E+00, 3.7662485870E+00, 1.9493815501E+00, 8.6312128998E-01],
	[2.49550E+04, 1.5868431546E+01, 5.4220730331E+00, 3.7687028700E+00, 1.9501054235E+00, 8.6318831859E-01],
	[2.49600E+04, 1.5873398654E+01, 5.4220076808E+00, 3.7711582601E+00, 1.9508292374E+00, 8.6325531745E-01],
	[2.49650E+04, 1.5878366321E+01, 5.4219423424E+00, 3.7736147577E+00, 1.9515529919E+00, 8.6332228655E-01],
	[2.49700E+04, 1.5883334547E+01, 5.4218770178E+00, 3.7760723630E+00, 1.9522766867E+00, 8.6338922592E-01],
	[2.49750E+04, 1.5888303332E+01, 5.4218117071E+00, 3.7785310763E+00, 1.9530003218E+00, 8.6345613556E-01],
	[2.49800E+04, 1.5893272677E+01, 5.4217464102E+00, 3.7809908979E+00, 1.9537238970E+00, 8.6352301548E-01],
	[2.49850E+04, 1.5898242581E+01, 5.4216811272E+00, 3.7834518280E+00, 1.9544474123E+00, 8.6358986568E-01],
	[2.49900E+04, 1.5903213045E+01, 5.4216158581E+00, 3.7859138669E+00, 1.9551708675E+00, 8.6365668618E-01],
	[2.49950E+04, 1.5908184067E+01, 5.4215506028E+00, 3.7883770150E+00, 1.9558942625E+00, 8.6372347698E-01],
	[2.50000E+04, 1.5913155648E+01, 5.4214853613E+00, 3.7908412724E+00, 1.9566175971E+00, 8.6379023809E-01],
	[2.50050E+04, 1.5918127789E+01, 5.4214201337E+00, 3.7933094903E+00, 1.9573416304E+00, 8.6385696952E-01],
	[2.50100E+04, 1.5923100488E+01, 5.4213549199E+00, 3.7957788213E+00, 1.9580656032E+00, 8.6392367127E-01],
	[2.50150E+04, 1.5928073746E+01, 5.4212897199E+00, 3.7982492656E+00, 1.9587895152E+00, 8.6399034336E-01],
	[2.50200E+04, 1.5933047563E+01, 5.4212245337E+00, 3.8007208236E+00, 1.9595133665E+00, 8.6405698580E-01],
	[2.50250E+04, 1.5938021939E+01, 5.4211593613E+00, 3.8031934955E+00, 1.9602371569E+00, 8.6412359858E-01],
	[2.50300E+04, 1.5942996874E+01, 5.4210942028E+00, 3.8056672816E+00, 1.9609608863E+00, 8.6419018173E-01],
	[2.50350E+04, 1.5947972368E+01, 5.4210290580E+00, 3.8081421821E+00, 1.9616845545E+00, 8.6425673525E-01],
	[2.50400E+04, 1.5952948420E+01, 5.4209639270E+00, 3.8106181974E+00, 1.9624081615E+00, 8.6432325914E-01],
	[2.50450E+04, 1.5957925031E+01, 5.4208988099E+00, 3.8130953278E+00, 1.9631317072E+00, 8.6438975342E-01],
	[2.50500E+04, 1.5962902200E+01, 5.4208337065E+00, 3.8155735735E+00, 1.9638551913E+00, 8.6445621809E-01],
	[2.50550E+04, 1.5967879928E+01, 5.4207686168E+00, 3.8180529347E+00, 1.9645786139E+00, 8.6452265316E-01],
	[2.50600E+04, 1.5972858214E+01, 5.4207035410E+00, 3.8205334119E+00, 1.9653019749E+00, 8.6458905864E-01],
	[2.50650E+04, 1.5977837059E+01, 5.4206384789E+00, 3.8230150051E+00, 1.9660252740E+00, 8.6465543454E-01],
	[2.50700E+04, 1.5982816463E+01, 5.4205734305E+00, 3.8254977149E+00, 1.9667485112E+00, 8.6472178087E-01],
	[2.50750E+04, 1.5987796424E+01, 5.4205083960E+00, 3.8279815413E+00, 1.9674716863E+00, 8.6478809763E-01],
	[2.50800E+04, 1.5992776944E+01, 5.4204433751E+00, 3.8304664847E+00, 1.9681947993E+00, 8.6485438484E-01],
	[2.50850E+04, 1.5997758022E+01, 5.4203783680E+00, 3.8329525454E+00, 1.9689178501E+00, 8.6492064250E-01],
	[2.50900E+04, 1.6002739658E+01, 5.4203133747E+00, 3.8354397236E+00, 1.9696408384E+00, 8.6498687061E-01],
	[2.50950E+04, 1.6007721853E+01, 5.4202483950E+00, 3.8379280197E+00, 1.9703637643E+00, 8.6505306920E-01],
	[2.51000E+04, 1.6012704605E+01, 5.4201834291E+00, 3.8404174339E+00, 1.9710866276E+00, 8.6511923827E-01],
	[2.51050E+04, 1.6017687916E+01, 5.4201184769E+00, 3.8429079664E+00, 1.9718094282E+00, 8.6518537782E-01],
	[2.51100E+04, 1.6022720862E+01, 5.4200617601E+00, 3.8453996177E+00, 1.9725339987E+00, 8.6525148786E-01],
	[2.51150E+04, 1.6027763138E+01, 5.4200065207E+00, 3.8478923879E+00, 1.9732588350E+00, 8.6531756841E-01],
	[2.51200E+04, 1.6032805997E+01, 5.4199512928E+00, 3.8503862773E+00, 1.9739836105E+00, 8.6538361946E-01],
	[2.51250E+04, 1.6037849439E+01, 5.4198960766E+00, 3.8528812862E+00, 1.9747083251E+00, 8.6544964104E-01],
	[2.51300E+04, 1.6042893462E+01, 5.4198408719E+00, 3.8553774149E+00, 1.9754329786E+00, 8.6551563315E-01],
	[2.51350E+04, 1.6047938069E+01, 5.4197856787E+00, 3.8578746636E+00, 1.9761575710E+00, 8.6558159579E-01],
	[2.51400E+04, 1.6052983257E+01, 5.4197304970E+00, 3.8603730328E+00, 1.9768821021E+00, 8.6564752897E-01],
	[2.51450E+04, 1.6058029028E+01, 5.4196753269E+00, 3.8628725225E+00, 1.9776065717E+00, 8.6571343272E-01],
	[2.51500E+04, 1.6063075382E+01, 5.4196201684E+00, 3.8653731331E+00, 1.9783309799E+00, 8.6577930702E-01],
	[2.51550E+04, 1.6068122317E+01, 5.4195650213E+00, 3.8678748650E+00, 1.9790553265E+00, 8.6584515189E-01],
	[2.51600E+04, 1.6073169835E+01, 5.4195098858E+00, 3.8703777182E+00, 1.9797796114E+00, 8.6591096734E-01],
	[2.51650E+04, 1.6078217935E+01, 5.4194547618E+00, 3.8728816933E+00, 1.9805038344E+00, 8.6597675338E-01],
	[2.51700E+04, 1.6083266617E+01, 5.4193996493E+00, 3.8753867903E+00, 1.9812279955E+00, 8.6604251002E-01],
	[2.51750E+04, 1.6088315881E+01, 5.4193445483E+00, 3.8778930097E+00, 1.9819520945E+00, 8.6610823726E-01],
	[2.51800E+04, 1.6093365726E+01, 5.4192894588E+00, 3.8804003516E+00, 1.9826761313E+00, 8.6617393512E-01],
	[2.51850E+04, 1.6098416154E+01, 5.4192343808E+00, 3.8829088165E+00, 1.9834001059E+00, 8.6623960359E-01],
	[2.51900E+04, 1.6103467164E+01, 5.4191793143E+00, 3.8854184044E+00, 1.9841240180E+00, 8.6630524270E-01],
	[2.51950E+04, 1.6108518756E+01, 5.4191242593E+00, 3.8879291158E+00, 1.9848478677E+00, 8.6637085245E-01],
	[2.52000E+04, 1.6113570929E+01, 5.4190692158E+00, 3.8904409509E+00, 1.9855716548E+00, 8.6643643284E-01],
	[2.52050E+04, 1.6118623684E+01, 5.4190141838E+00, 3.8929539099E+00, 1.9862953791E+00, 8.6650198389E-01],
	[2.52100E+04, 1.6123677021E+01, 5.4189591632E+00, 3.8954679932E+00, 1.9870190406E+00, 8.6656750561E-01],
	[2.52150E+04, 1.6128730939E+01, 5.4189041541E+00, 3.8979832011E+00, 1.9877426391E+00, 8.6663299800E-01],
	[2.52200E+04, 1.6133785440E+01, 5.4188491565E+00, 3.9004995338E+00, 1.9884661746E+00, 8.6669846108E-01],
	[2.52250E+04, 1.6138840521E+01, 5.4187941703E+00, 3.9030169916E+00, 1.9891896470E+00, 8.6676389484E-01],
	[2.52300E+04, 1.6143896184E+01, 5.4187391956E+00, 3.9055355747E+00, 1.9899130560E+00, 8.6682929931E-01],
	[2.52350E+04, 1.6148952429E+01, 5.4186842323E+00, 3.9080552836E+00, 1.9906364017E+00, 8.6689467448E-01],
	[2.52400E+04, 1.6154009255E+01, 5.4186292805E+00, 3.9105761183E+00, 1.9913596838E+00, 8.6696002037E-01],
	[2.52450E+04, 1.6159066662E+01, 5.4185743401E+00, 3.9130980793E+00, 1.9920829024E+00, 8.6702533699E-01],
	[2.52500E+04, 1.6164124651E+01, 5.4185194112E+00, 3.9156211668E+00, 1.9928060572E+00, 8.6709062435E-01],
	[2.52550E+04, 1.6169183221E+01, 5.4184644937E+00, 3.9181453811E+00, 1.9935291482E+00, 8.6715588244E-01],
	[2.52600E+04, 1.6174242372E+01, 5.4184095876E+00, 3.9206707224E+00, 1.9942521753E+00, 8.6722111129E-01],
	[2.52650E+04, 1.6179302104E+01, 5.4183546929E+00, 3.9231971911E+00, 1.9949751383E+00, 8.6728631090E-01],
	[2.52700E+04, 1.6184362418E+01, 5.4182998097E+00, 3.9257247874E+00, 1.9956980372E+00, 8.6735148128E-01],
	[2.52750E+04, 1.6189423312E+01, 5.4182449379E+00, 3.9282535116E+00, 1.9964208718E+00, 8.6741662244E-01],
	[2.52800E+04, 1.6194484788E+01, 5.4181900774E+00, 3.9307833640E+00, 1.9971436420E+00, 8.6748173439E-01],
	[2.52850E+04, 1.6199546844E+01, 5.4181352284E+00, 3.9333143448E+00, 1.9978663477E+00, 8.6754681714E-01],
	[2.52900E+04, 1.6204609481E+01, 5.4180803908E+00, 3.9358464544E+00, 1.9985889889E+00, 8.6761187068E-01],
	[2.52950E+04, 1.6209672700E+01, 5.4180255646E+00, 3.9383796930E+00, 1.9993115653E+00, 8.6767689505E-01],
	[2.53000E+04, 1.6214736499E+01, 5.4179707498E+00, 3.9409140609E+00, 2.0000340769E+00, 8.6774189023E-01],
	[2.53050E+04, 1.6219800879E+01, 5.4179159463E+00, 3.9434495584E+00, 2.0007565236E+00, 8.6780685625E-01],
	[2.53100E+04, 1.6224865839E+01, 5.4178611543E+00, 3.9459861857E+00, 2.0014789053E+00, 8.6787179311E-01],
	[2.53150E+04, 1.6229931380E+01, 5.4178063736E+00, 3.9485239432E+00, 2.0022012218E+00, 8.6793670082E-01],
	[2.53200E+04, 1.6234997502E+01, 5.4177516043E+00, 3.9510628311E+00, 2.0029234731E+00, 8.6800157939E-01],
	[2.53250E+04, 1.6240064205E+01, 5.4176968464E+00, 3.9536028497E+00, 2.0036456590E+00, 8.6806642882E-01],
	[2.53300E+04, 1.6245131488E+01, 5.4176420998E+00, 3.9561439993E+00, 2.0043677795E+00, 8.6813124913E-01],
	[2.53350E+04, 1.6250199351E+01, 5.4175873646E+00, 3.9586862802E+00, 2.0050898344E+00, 8.6819604033E-01],
	[2.53400E+04, 1.6255267795E+01, 5.4175326407E+00, 3.9612296926E+00, 2.0058118236E+00, 8.6826080242E-01],
	[2.53450E+04, 1.6260336820E+01, 5.4174779282E+00, 3.9637742368E+00, 2.0065337470E+00, 8.6832553541E-01],
	[2.53500E+04, 1.6265406424E+01, 5.4174232270E+00, 3.9663199131E+00, 2.0072556045E+00, 8.6839023931E-01],
	[2.53550E+04, 1.6270476609E+01, 5.4173685372E+00, 3.9688667218E+00, 2.0079773960E+00, 8.6845491416E-01],
	[2.53600E+04, 1.6275547375E+01, 5.4173138587E+00, 3.9714146632E+00, 2.0086991214E+00, 8.6851955997E-01],
	[2.53650E+04, 1.6280618720E+01, 5.4172591916E+00, 3.9739637375E+00, 2.0094207806E+00, 8.6858417676E-01],
	[2.53700E+04, 1.6285690646E+01, 5.4172045357E+00, 3.9765139450E+00, 2.0101423734E+00, 8.6864876454E-01],
	[2.53750E+04, 1.6290763151E+01, 5.4171498912E+00, 3.9790652861E+00, 2.0108638998E+00, 8.6871332331E-01],
	[2.53800E+04, 1.6295836237E+01, 5.4170952580E+00, 3.9816177609E+00, 2.0115853596E+00, 8.6877785308E-01],
	[2.53850E+04, 1.6300909903E+01, 5.4170406361E+00, 3.9841713698E+00, 2.0123067528E+00, 8.6884235386E-01],
	[2.53900E+04, 1.6305984149E+01, 5.4169860256E+00, 3.9867261130E+00, 2.0130280793E+00, 8.6890682566E-01],
	[2.53950E+04, 1.6311058974E+01, 5.4169314263E+00, 3.9892819909E+00, 2.0137493388E+00, 8.6897126847E-01],
	[2.54000E+04, 1.6316134380E+01, 5.4168768383E+00, 3.9918390037E+00, 2.0144705314E+00, 8.6903568231E-01],
	[2.54050E+04, 1.6321210365E+01, 5.4168222616E+00, 3.9943971516E+00, 2.0151916569E+00, 8.6910006719E-01],
	[2.54100E+04, 1.6326286930E+01, 5.4167676963E+00, 3.9969564351E+00, 2.0159127152E+00, 8.6916442312E-01],
	[2.54150E+04, 1.6331364075E+01, 5.4167131422E+00, 3.9995168542E+00, 2.0166337062E+00, 8.6922875009E-01],
	[2.54200E+04, 1.6336441799E+01, 5.4166585993E+00, 4.0020784094E+00, 2.0173546298E+00, 8.6929304813E-01],
	[2.54250E+04, 1.6341520104E+01, 5.4166040678E+00, 4.0046411009E+00, 2.0180754859E+00, 8.6935731723E-01],
	[2.54300E+04, 1.6346598987E+01, 5.4165495475E+00, 4.0072049290E+00, 2.0187962744E+00, 8.6942155740E-01],
	[2.54350E+04, 1.6351678450E+01, 5.4164950385E+00, 4.0097698940E+00, 2.0195169952E+00, 8.6948576865E-01],
	[2.54400E+04, 1.6356758493E+01, 5.4164405408E+00, 4.0123359961E+00, 2.0202376481E+00, 8.6954995099E-01],
	[2.54450E+04, 1.6361839115E+01, 5.4163860543E+00, 4.0149032357E+00, 2.0209582331E+00, 8.6961410443E-01],
	[2.54500E+04, 1.6366920317E+01, 5.4163315791E+00, 4.0174716129E+00, 2.0216787500E+00, 8.6967822897E-01],
	[2.54550E+04, 1.6372002098E+01, 5.4162771151E+00, 4.0200411282E+00, 2.0223991988E+00, 8.6974232462E-01],
	[2.54600E+04, 1.6377084458E+01, 5.4162226623E+00, 4.0226117817E+00, 2.0231195793E+00, 8.6980639139E-01],
	[2.54650E+04, 1.6382167397E+01, 5.4161682208E+00, 4.0251835738E+00, 2.0238398915E+00, 8.6987042928E-01],
	[2.54700E+04, 1.6387250916E+01, 5.4161137906E+00, 4.0277565047E+00, 2.0245601352E+00, 8.6993443831E-01],
	[2.54750E+04, 1.6392335014E+01, 5.4160593716E+00, 4.0303305747E+00, 2.0252803103E+00, 8.6999841847E-01],
	[2.54800E+04, 1.6397419690E+01, 5.4160049638E+00, 4.0329057841E+00, 2.0260004168E+00, 8.7006236979E-01],
	[2.54850E+04, 1.6402504946E+01, 5.4159505672E+00, 4.0354821332E+00, 2.0267204544E+00, 8.7012629226E-01],
	[2.54900E+04, 1.6407590781E+01, 5.4158961818E+00, 4.0380596222E+00, 2.0274404232E+00, 8.7019018589E-01],
	[2.54950E+04, 1.6412677195E+01, 5.4158418077E+00, 4.0406382515E+00, 2.0281603230E+00, 8.7025405069E-01],
	[2.55000E+04, 1.6417764188E+01, 5.4157874447E+00, 4.0432180213E+00, 2.0288801536E+00, 8.7031788667E-01],
	[2.55050E+04, 1.6422851759E+01, 5.4157330930E+00, 4.0457989319E+00, 2.0295999151E+00, 8.7038169384E-01],
	[2.55100E+04, 1.6427939910E+01, 5.4156787524E+00, 4.0483809835E+00, 2.0303196072E+00, 8.7044547220E-01],
	[2.55150E+04, 1.6433028639E+01, 5.4156244231E+00, 4.0509641766E+00, 2.0310392299E+00, 8.7050922176E-01],
	[2.55200E+04, 1.6438117947E+01, 5.4155701049E+00, 4.0535485112E+00, 2.0317587831E+00, 8.7057294253E-01],
	[2.55250E+04, 1.6443207834E+01, 5.4155157980E+00, 4.0561339878E+00, 2.0324782667E+00, 8.7063663452E-01],
	[2.55300E+04, 1.6448298299E+01, 5.4154615022E+00, 4.0587206066E+00, 2.0331976805E+00, 8.7070029773E-01],
	[2.55350E+04, 1.6453389343E+01, 5.4154072176E+00, 4.0613083679E+00, 2.0339170245E+00, 8.7076393217E-01],
	[2.55400E+04, 1.6458480965E+01, 5.4153529441E+00, 4.0638972719E+00, 2.0346362986E+00, 8.7082753785E-01],
	[2.55450E+04, 1.6463573166E+01, 5.4152986819E+00, 4.0664873190E+00, 2.0353555026E+00, 8.7089111477E-01],
	[2.55500E+04, 1.6468665945E+01, 5.4152444308E+00, 4.0690785094E+00, 2.0360746364E+00, 8.7095466295E-01],
	[2.55550E+04, 1.6473759303E+01, 5.4151901908E+00, 4.0716708434E+00, 2.0367937000E+00, 8.7101818240E-01],
	[2.55600E+04, 1.6478853239E+01, 5.4151359620E+00, 4.0742643213E+00, 2.0375126933E+00, 8.7108167311E-01],
	[2.55650E+04, 1.6483947753E+01, 5.4150817444E+00, 4.0768589433E+00, 2.0382316160E+00, 8.7114513510E-01],
	[2.55700E+04, 1.6489042845E+01, 5.4150275379E+00, 4.0794547098E+00, 2.0389504682E+00, 8.7120856838E-01],
	[2.55750E+04, 1.6494138516E+01, 5.4149733425E+00, 4.0820516211E+00, 2.0396692497E+00, 8.7127197295E-01],
	[2.55800E+04, 1.6499234765E+01, 5.4149191583E+00, 4.0846496773E+00, 2.0403879605E+00, 8.7133534882E-01],
	[2.55850E+04, 1.6504331592E+01, 5.4148649852E+00, 4.0872488788E+00, 2.0411066003E+00, 8.7139869599E-01],
	[2.55900E+04, 1.6509428997E+01, 5.4148108232E+00, 4.0898492259E+00, 2.0418251692E+00, 8.7146201449E-01],
	[2.55950E+04, 1.6514526980E+01, 5.4147566724E+00, 4.0924507189E+00, 2.0425436670E+00, 8.7152530431E-01],
	[2.56000E+04, 1.6519625541E+01, 5.4147025327E+00, 4.0950533580E+00, 2.0432620935E+00, 8.7158856546E-01],
	[2.56050E+04, 1.6524724680E+01, 5.4146484041E+00, 4.0976571435E+00, 2.0439804488E+00, 8.7165179795E-01],
	[2.56100E+04, 1.6529824396E+01, 5.4145942866E+00, 4.1002620756E+00, 2.0446987327E+00, 8.7171500179E-01],
	[2.56150E+04, 1.6534924691E+01, 5.4145401802E+00, 4.1028681548E+00, 2.0454169451E+00, 8.7177817699E-01],
	[2.56200E+04, 1.6540025563E+01, 5.4144860849E+00, 4.1054753812E+00, 2.0461350859E+00, 8.7184132355E-01],
	[2.56250E+04, 1.6545127013E+01, 5.4144320007E+00, 4.1080837552E+00, 2.0468531549E+00, 8.7190444148E-01],
	[2.56300E+04, 1.6550229041E+01, 5.4143779276E+00, 4.1106932770E+00, 2.0475711522E+00, 8.7196753079E-01],
	[2.56350E+04, 1.6555331646E+01, 5.4143238656E+00, 4.1133039468E+00, 2.0482890775E+00, 8.7203059148E-01],
	[2.56400E+04, 1.6560434829E+01, 5.4142698147E+00, 4.1159157651E+00, 2.0490069308E+00, 8.7209362357E-01],
	[2.56450E+04, 1.6565538590E+01, 5.4142157748E+00, 4.1185287320E+00, 2.0497247120E+00, 8.7215662707E-01],
	[2.56500E+04, 1.6570642928E+01, 5.4141617461E+00, 4.1211428479E+00, 2.0504424210E+00, 8.7221960198E-01],
	[2.56550E+04, 1.6575747843E+01, 5.4141077284E+00, 4.1237581130E+00, 2.0511600576E+00, 8.7228254830E-01],
	[2.56600E+04, 1.6580853336E+01, 5.4140537217E+00, 4.1263745276E+00, 2.0518776218E+00, 8.7234546605E-01],
	[2.56650E+04, 1.6585959406E+01, 5.4139997261E+00, 4.1289920919E+00, 2.0525951135E+00, 8.7240835524E-01],
	[2.56700E+04, 1.6591066053E+01, 5.4139457416E+00, 4.1316108064E+00, 2.0533125325E+00, 8.7247121587E-01],
	[2.56750E+04, 1.6596173278E+01, 5.4138917681E+00, 4.1342306712E+00, 2.0540298788E+00, 8.7253404795E-01],
	[2.56800E+04, 1.6601281080E+01, 5.4138378057E+00, 4.1368516866E+00, 2.0547471522E+00, 8.7259685149E-01],
	[2.56850E+04, 1.6606389459E+01, 5.4137838543E+00, 4.1394738529E+00, 2.0554643527E+00, 8.7265962649E-01],
	[2.56900E+04, 1.6611498415E+01, 5.4137299140E+00, 4.1420971705E+00, 2.0561814802E+00, 8.7272237298E-01],
	[2.56950E+04, 1.6616607948E+01, 5.4136759847E+00, 4.1447216394E+00, 2.0568985345E+00, 8.7278509094E-01],
	[2.57000E+04, 1.6621718059E+01, 5.4136220664E+00, 4.1473472602E+00, 2.0576155156E+00, 8.7284778040E-01],
	[2.57050E+04, 1.6626828746E+01, 5.4135681592E+00, 4.1499740330E+00, 2.0583324233E+00, 8.7291044135E-01],
	[2.57100E+04, 1.6631940010E+01, 5.4135142629E+00, 4.1526019581E+00, 2.0590492576E+00, 8.7297307381E-01],
	[2.57150E+04, 1.6637051851E+01, 5.4134603777E+00, 4.1552310358E+00, 2.0597660183E+00, 8.7303567779E-01],
	[2.57200E+04, 1.6642164269E+01, 5.4134065035E+00, 4.1578612664E+00, 2.0604827054E+00, 8.7309825329E-01],
	[2.57250E+04, 1.6647277263E+01, 5.4133526403E+00, 4.1604926501E+00, 2.0611993187E+00, 8.7316080032E-01],
	[2.57300E+04, 1.6652390835E+01, 5.4132987882E+00, 4.1631251873E+00, 2.0619158581E+00, 8.7322331889E-01],
	[2.57350E+04, 1.6657504983E+01, 5.4132449470E+00, 4.1657588782E+00, 2.0626323236E+00, 8.7328580901E-01],
	[2.57400E+04, 1.6662619707E+01, 5.4131911168E+00, 4.1683937231E+00, 2.0633487150E+00, 8.7334827069E-01],
	[2.57450E+04, 1.6667735008E+01, 5.4131372976E+00, 4.1710297223E+00, 2.0640650323E+00, 8.7341070393E-01],
	[2.57500E+04, 1.6672850886E+01, 5.4130834894E+00, 4.1736668761E+00, 2.0647812753E+00, 8.7347310874E-01],
	[2.57550E+04, 1.6677967340E+01, 5.4130296921E+00, 4.1763051847E+00, 2.0654974439E+00, 8.7353548513E-01],
	[2.57600E+04, 1.6683084371E+01, 5.4129759059E+00, 4.1789446484E+00, 2.0662135381E+00, 8.7359783312E-01],
	[2.57650E+04, 1.6688201978E+01, 5.4129221306E+00, 4.1815852675E+00, 2.0669295577E+00, 8.7366015269E-01],
	[2.57700E+04, 1.6693320162E+01, 5.4128683663E+00, 4.1842270424E+00, 2.0676455027E+00, 8.7372244388E-01],
	[2.57750E+04, 1.6698438922E+01, 5.4128146129E+00, 4.1868699732E+00, 2.0683613728E+00, 8.7378470667E-01],
	[2.57800E+04, 1.6703558258E+01, 5.4127608705E+00, 4.1895140603E+00, 2.0690771682E+00, 8.7384694109E-01],
	[2.57850E+04, 1.6708678170E+01, 5.4127071391E+00, 4.1921593039E+00, 2.0697928885E+00, 8.7390914714E-01],
	[2.57900E+04, 1.6713798658E+01, 5.4126534186E+00, 4.1948057043E+00, 2.0705085338E+00, 8.7397132483E-01],
	[2.57950E+04, 1.6718919723E+01, 5.4125997091E+00, 4.1974532618E+00, 2.0712241039E+00, 8.7403347416E-01],
	[2.58000E+04, 1.6724041363E+01, 5.4125460105E+00, 4.2001019768E+00, 2.0719395988E+00, 8.7409559515E-01],
	[2.58050E+04, 1.6729163580E+01, 5.4124923228E+00, 4.2027518493E+00, 2.0726550182E+00, 8.7415768780E-01],
	[2.58100E+04, 1.6734286373E+01, 5.4124386461E+00, 4.2054028798E+00, 2.0733703623E+00, 8.7421975212E-01],
	[2.58150E+04, 1.6739409741E+01, 5.4123849803E+00, 4.2080550686E+00, 2.0740856307E+00, 8.7428178812E-01],
	[2.58200E+04, 1.6744533686E+01, 5.4123313255E+00, 4.2107084158E+00, 2.0748008235E+00, 8.7434379581E-01],
	[2.58250E+04, 1.6749658206E+01, 5.4122776815E+00, 4.2133629219E+00, 2.0755159405E+00, 8.7440577519E-01],
	[2.58300E+04, 1.6754783302E+01, 5.4122240485E+00, 4.2160185870E+00, 2.0762309817E+00, 8.7446772628E-01],
	[2.58350E+04, 1.6759908974E+01, 5.4121704264E+00, 4.2186754114E+00, 2.0769459469E+00, 8.7452964909E-01],
	[2.58400E+04, 1.6765035221E+01, 5.4121168152E+00, 4.2213333955E+00, 2.0776608360E+00, 8.7459154361E-01],
	[2.58450E+04, 1.6770162045E+01, 5.4120632149E+00, 4.2239925395E+00, 2.0783756490E+00, 8.7465340986E-01],
	[2.58500E+04, 1.6775289443E+01, 5.4120096255E+00, 4.2266528437E+00, 2.0790903857E+00, 8.7471524786E-01],
	[2.58550E+04, 1.6780417418E+01, 5.4119560469E+00, 4.2293143084E+00, 2.0798050460E+00, 8.7477705759E-01],
	[2.58600E+04, 1.6785545968E+01, 5.4119024793E+00, 4.2319769339E+00, 2.0805196299E+00, 8.7483883909E-01],
	[2.58650E+04, 1.6790675093E+01, 5.4118489226E+00, 4.2346407204E+00, 2.0812341372E+00, 8.7490059234E-01],
	[2.58700E+04, 1.6795804794E+01, 5.4117953767E+00, 4.2373056682E+00, 2.0819485679E+00, 8.7496231737E-01],
	[2.58750E+04, 1.6800935070E+01, 5.4117418418E+00, 4.2399717776E+00, 2.0826629218E+00, 8.7502401418E-01],
	[2.58800E+04, 1.6806065921E+01, 5.4116883177E+00, 4.2426390489E+00, 2.0833771988E+00, 8.7508568278E-01],
	[2.58850E+04, 1.6811197348E+01, 5.4116348044E+00, 4.2453074823E+00, 2.0840913989E+00, 8.7514732317E-01],
	[2.58900E+04, 1.6816329350E+01, 5.4115813021E+00, 4.2479770783E+00, 2.0848055220E+00, 8.7520893537E-01],
	[2.58950E+04, 1.6821461927E+01, 5.4115278106E+00, 4.2506478369E+00, 2.0855195679E+00, 8.7527051939E-01],
	[2.59000E+04, 1.6826595079E+01, 5.4114743299E+00, 4.2533197586E+00, 2.0862335365E+00, 8.7533207522E-01],
	[2.59050E+04, 1.6831728807E+01, 5.4114208601E+00, 4.2559928436E+00, 2.0869474278E+00, 8.7539360289E-01],
	[2.59100E+04, 1.6836863109E+01, 5.4113674012E+00, 4.2586670921E+00, 2.0876612417E+00, 8.7545510240E-01],
	[2.59150E+04, 1.6841997986E+01, 5.4113139531E+00, 4.2613425045E+00, 2.0883749780E+00, 8.7551657375E-01],
	[2.59200E+04, 1.6847133439E+01, 5.4112605158E+00, 4.2640190810E+00, 2.0890886367E+00, 8.7557801697E-01],
	[2.59250E+04, 1.6852269466E+01, 5.4112070894E+00, 4.2666968220E+00, 2.0898022176E+00, 8.7563943204E-01],
	[2.59300E+04, 1.6857406068E+01, 5.4111536738E+00, 4.2693757277E+00, 2.0905157207E+00, 8.7570081900E-01],
	[2.59350E+04, 1.6862543245E+01, 5.4111002690E+00, 4.2720557983E+00, 2.0912291459E+00, 8.7576217783E-01],
	[2.59400E+04, 1.6867680997E+01, 5.4110468750E+00, 4.2747370342E+00, 2.0919424931E+00, 8.7582350855E-01],
	[2.59450E+04, 1.6872819323E+01, 5.4109934919E+00, 4.2774194357E+00, 2.0926557621E+00, 8.7588481118E-01],
	[2.59500E+04, 1.6877958225E+01, 5.4109401196E+00, 4.2801030030E+00, 2.0933689529E+00, 8.7594608571E-01],
	[2.59550E+04, 1.6883097700E+01, 5.4108867580E+00, 4.2827877365E+00, 2.0940820653E+00, 8.7600733216E-01],
	[2.59600E+04, 1.6888237751E+01, 5.4108334073E+00, 4.2854736363E+00, 2.0947950994E+00, 8.7606855053E-01],
	[2.59650E+04, 1.6893378375E+01, 5.4107800674E+00, 4.2881607028E+00, 2.0955080549E+00, 8.7612974084E-01],
	[2.59700E+04, 1.6898519575E+01, 5.4107267383E+00, 4.2908489362E+00, 2.0962209318E+00, 8.7619090309E-01],
	[2.59750E+04, 1.6903661349E+01, 5.4106734200E+00, 4.2935383369E+00, 2.0969337300E+00, 8.7625203730E-01],
	[2.59800E+04, 1.6908803697E+01, 5.4106201125E+00, 4.2962289051E+00, 2.0976464494E+00, 8.7631314346E-01],
	[2.59850E+04, 1.6913946619E+01, 5.4105668157E+00, 4.2989206412E+00, 2.0983590899E+00, 8.7637422159E-01],
	[2.59900E+04, 1.6919090116E+01, 5.4105135297E+00, 4.3016135453E+00, 2.0990716514E+00, 8.7643527170E-01],
	[2.59950E+04, 1.6924234187E+01, 5.4104602545E+00, 4.3043076178E+00, 2.0997841338E+00, 8.7649629379E-01],
	[2.60000E+04, 1.6929378832E+01, 5.4104069901E+00, 4.3070028589E+00, 2.1004965370E+00, 8.7655728788E-01],
	[2.60050E+04, 1.6934524052E+01, 5.4103537364E+00, 4.3096992690E+00, 2.1012088609E+00, 8.7661825397E-01],
	[2.60100E+04, 1.6939669846E+01, 5.4103004935E+00, 4.3123968483E+00, 2.1019211054E+00, 8.7667919208E-01],
	[2.60150E+04, 1.6944816213E+01, 5.4102472614E+00, 4.3150955971E+00, 2.1026332705E+00, 8.7674010220E-01],
	[2.60200E+04, 1.6949963155E+01, 5.4101940400E+00, 4.3177955156E+00, 2.1033453559E+00, 8.7680098436E-01],
	[2.60250E+04, 1.6955110670E+01, 5.4101408294E+00, 4.3204966043E+00, 2.1040573617E+00, 8.7686183855E-01],
	[2.60300E+04, 1.6960258760E+01, 5.4100876295E+00, 4.3231988632E+00, 2.1047692877E+00, 8.7692266479E-01],
	[2.60350E+04, 1.6965407424E+01, 5.4100344403E+00, 4.3259022928E+00, 2.1054811339E+00, 8.7698346308E-01],
	[2.60400E+04, 1.6970556661E+01, 5.4099812619E+00, 4.3286068934E+00, 2.1061929001E+00, 8.7704423344E-01],
	[2.60450E+04, 1.6975706472E+01, 5.4099280942E+00, 4.3313126651E+00, 2.1069045862E+00, 8.7710497588E-01],
	[2.60500E+04, 1.6980856857E+01, 5.4098749373E+00, 4.3340196082E+00, 2.1076161922E+00, 8.7716569039E-01],
	[2.60550E+04, 1.6986007815E+01, 5.4098217911E+00, 4.3367277232E+00, 2.1083277179E+00, 8.7722637700E-01],
	[2.60600E+04, 1.6991159348E+01, 5.4097686556E+00, 4.3394370101E+00, 2.1090391633E+00, 8.7728703571E-01],
	[2.60650E+04, 1.6996311453E+01, 5.4097155308E+00, 4.3421474694E+00, 2.1097505283E+00, 8.7734766652E-01],
	[2.60700E+04, 1.7001464133E+01, 5.4096624167E+00, 4.3448591013E+00, 2.1104618127E+00, 8.7740826946E-01],
	[2.60750E+04, 1.7006617386E+01, 5.4096093133E+00, 4.3475719061E+00, 2.1111730165E+00, 8.7746884451E-01],
	[2.60800E+04, 1.7011771212E+01, 5.4095562206E+00, 4.3502858840E+00, 2.1118841395E+00, 8.7752939171E-01],
	[2.60850E+04, 1.7016925612E+01, 5.4095031387E+00, 4.3530010354E+00, 2.1125951818E+00, 8.7758991105E-01],
	[2.60900E+04, 1.7022080585E+01, 5.4094500674E+00, 4.3557173606E+00, 2.1133061431E+00, 8.7765040254E-01],
	[2.60950E+04, 1.7027236131E+01, 5.4093970068E+00, 4.3584348597E+00, 2.1140170234E+00, 8.7771086619E-01],
	[2.61000E+04, 1.7032392251E+01, 5.4093439569E+00, 4.3611535331E+00, 2.1147278227E+00, 8.7777130201E-01],
	[2.61050E+04, 1.7037548944E+01, 5.4092909177E+00, 4.3638733812E+00, 2.1154385407E+00, 8.7783171002E-01],
	[2.61100E+04, 1.7042739045E+01, 5.4092431923E+00, 4.3665944040E+00, 2.1161504953E+00, 8.7789209021E-01],
	[2.61150E+04, 1.7047954581E+01, 5.4091994886E+00, 4.3693166020E+00, 2.1168633673E+00, 8.7795244260E-01],
	[2.61200E+04, 1.7053170714E+01, 5.4091557937E+00, 4.3720399755E+00, 2.1175761600E+00, 8.7801276719E-01],
	[2.61250E+04, 1.7058387443E+01, 5.4091121074E+00, 4.3747645246E+00, 2.1182888732E+00, 8.7807306400E-01],
	[2.61300E+04, 1.7063604771E+01, 5.4090684298E+00, 4.3774902498E+00, 2.1190015070E+00, 8.7813333303E-01],
	[2.61350E+04, 1.7068822695E+01, 5.4090247610E+00, 4.3802171512E+00, 2.1197140611E+00, 8.7819357430E-01],
	[2.61400E+04, 1.7074041216E+01, 5.4089811009E+00, 4.3829452292E+00, 2.1204265356E+00, 8.7825378781E-01],
	[2.61450E+04, 1.7079260334E+01, 5.4089374494E+00, 4.3856744840E+00, 2.1211389302E+00, 8.7831397357E-01],
	[2.61500E+04, 1.7084480048E+01, 5.4088938067E+00, 4.3884049159E+00, 2.1218512450E+00, 8.7837413159E-01],
	[2.61550E+04, 1.7089700360E+01, 5.4088501727E+00, 4.3911365252E+00, 2.1225634798E+00, 8.7843426188E-01],
	[2.61600E+04, 1.7094921269E+01, 5.4088065473E+00, 4.3938693122E+00, 2.1232756344E+00, 8.7849436445E-01],
	[2.61650E+04, 1.7100142774E+01, 5.4087629307E+00, 4.3966032772E+00, 2.1239877090E+00, 8.7855443930E-01],
	[2.61700E+04, 1.7105364876E+01, 5.4087193227E+00, 4.3993384204E+00, 2.1246997032E+00, 8.7861448645E-01],
	[2.61750E+04, 1.7110587574E+01, 5.4086757234E+00, 4.4020747422E+00, 2.1254116171E+00, 8.7867450591E-01],
	[2.61800E+04, 1.7115810870E+01, 5.4086321328E+00, 4.4048122428E+00, 2.1261234506E+00, 8.7873449767E-01],
	[2.61850E+04, 1.7121034761E+01, 5.4085885509E+00, 4.4075509224E+00, 2.1268352035E+00, 8.7879446177E-01],
	[2.61900E+04, 1.7126259250E+01, 5.4085449776E+00, 4.4102907815E+00, 2.1275468758E+00, 8.7885439819E-01],
	[2.61950E+04, 1.7131484334E+01, 5.4085014130E+00, 4.4130318202E+00, 2.1282584673E+00, 8.7891430696E-01],
	[2.62000E+04, 1.7136710016E+01, 5.4084578571E+00, 4.4157740389E+00, 2.1289699780E+00, 8.7897418807E-01],
	[2.62050E+04, 1.7141936293E+01, 5.4084143098E+00, 4.4185174378E+00, 2.1296814078E+00, 8.7903404155E-01],
	[2.62100E+04, 1.7147163167E+01, 5.4083707712E+00, 4.4212620172E+00, 2.1303927566E+00, 8.7909386739E-01],
	[2.62150E+04, 1.7152390637E+01, 5.4083272413E+00, 4.4240077774E+00, 2.1311040243E+00, 8.7915366561E-01],
	[2.62200E+04, 1.7157618704E+01, 5.4082837200E+00, 4.4267547186E+00, 2.1318152108E+00, 8.7921343622E-01],
	[2.62250E+04, 1.7162847366E+01, 5.4082402073E+00, 4.4295028413E+00, 2.1325263160E+00, 8.7927317922E-01],
	[2.62300E+04, 1.7168076625E+01, 5.4081967033E+00, 4.4322521455E+00, 2.1332373398E+00, 8.7933289463E-01],
	[2.62350E+04, 1.7173306480E+01, 5.4081532079E+00, 4.4350026317E+00, 2.1339482822E+00, 8.7939258245E-01],
	[2.62400E+04, 1.7178536931E+01, 5.4081097212E+00, 4.4377543001E+00, 2.1346591430E+00, 8.7945224269E-01],
	[2.62450E+04, 1.7183767978E+01, 5.4080662431E+00, 4.4405071510E+00, 2.1353699221E+00, 8.7951187537E-01],
	[2.62500E+04, 1.7188999621E+01, 5.4080227737E+00, 4.4432611847E+00, 2.1360806195E+00, 8.7957148049E-01],
	[2.62550E+04, 1.7194231860E+01, 5.4079793128E+00, 4.4460164014E+00, 2.1367912351E+00, 8.7963105806E-01],
	[2.62600E+04, 1.7199464694E+01, 5.4079358606E+00, 4.4487728015E+00, 2.1375017687E+00, 8.7969060808E-01],
	[2.62650E+04, 1.7204698125E+01, 5.4078924171E+00, 4.4515303851E+00, 2.1382122203E+00, 8.7975013058E-01],
	[2.62700E+04, 1.7209932151E+01, 5.4078489821E+00, 4.4542891527E+00, 2.1389225898E+00, 8.7980962556E-01],
	[2.62750E+04, 1.7215166773E+01, 5.4078055557E+00, 4.4570491045E+00, 2.1396328770E+00, 8.7986909302E-01],
	[2.62800E+04, 1.7220401991E+01, 5.4077621380E+00, 4.4598102407E+00, 2.1403430820E+00, 8.7992853298E-01],
	[2.62850E+04, 1.7225637805E+01, 5.4077187289E+00, 4.4625725617E+00, 2.1410532046E+00, 8.7998794544E-01],
	[2.62900E+04, 1.7230874214E+01, 5.4076753284E+00, 4.4653360677E+00, 2.1417632447E+00, 8.8004733042E-01],
	[2.62950E+04, 1.7236111218E+01, 5.4076319364E+00, 4.4681007591E+00, 2.1424732022E+00, 8.8010668792E-01],
	[2.63000E+04, 1.7241348818E+01, 5.4075885531E+00, 4.4708666360E+00, 2.1431830771E+00, 8.8016601796E-01],
	[2.63050E+04, 1.7246587014E+01, 5.4075451784E+00, 4.4736336988E+00, 2.1438928692E+00, 8.8022532054E-01],
	[2.63100E+04, 1.7251825805E+01, 5.4075018122E+00, 4.4764019478E+00, 2.1446025785E+00, 8.8028459567E-01],
	[2.63150E+04, 1.7257065191E+01, 5.4074584547E+00, 4.4791713832E+00, 2.1453122048E+00, 8.8034384336E-01],
	[2.63200E+04, 1.7262305173E+01, 5.4074151057E+00, 4.4819420054E+00, 2.1460217481E+00, 8.8040306362E-01],
	[2.63250E+04, 1.7267545750E+01, 5.4073717654E+00, 4.4847138146E+00, 2.1467312083E+00, 8.8046225646E-01],
	[2.63300E+04, 1.7272786922E+01, 5.4073284335E+00, 4.4874868110E+00, 2.1474405852E+00, 8.8052142189E-01],
	[2.63350E+04, 1.7278028690E+01, 5.4072851103E+00, 4.4902609951E+00, 2.1481498789E+00, 8.8058055992E-01],
	[2.63400E+04, 1.7283271052E+01, 5.4072417957E+00, 4.4930363670E+00, 2.1488590892E+00, 8.8063967055E-01],
	[2.63450E+04, 1.7288514010E+01, 5.4071984896E+00, 4.4958129271E+00, 2.1495682160E+00, 8.8069875381E-01],
	[2.63500E+04, 1.7293757563E+01, 5.4071551920E+00, 4.4985906756E+00, 2.1502772592E+00, 8.8075780968E-01],
	[2.63550E+04, 1.7299001710E+01, 5.4071119031E+00, 4.5013696128E+00, 2.1509862188E+00, 8.8081683820E-01],
	[2.63600E+04, 1.7304246453E+01, 5.4070686227E+00, 4.5041497390E+00, 2.1516950946E+00, 8.8087583935E-01],
	[2.63650E+04, 1.7309491791E+01, 5.4070253508E+00, 4.5069310545E+00, 2.1524038865E+00, 8.8093481317E-01],
	[2.63700E+04, 1.7314737723E+01, 5.4069820875E+00, 4.5097135595E+00, 2.1531125946E+00, 8.8099375964E-01],
	[2.63750E+04, 1.7319984251E+01, 5.4069388328E+00, 4.5124972544E+00, 2.1538212186E+00, 8.8105267879E-01],
	[2.63800E+04, 1.7325231373E+01, 5.4068955866E+00, 4.5152821395E+00, 2.1545297585E+00, 8.8111157062E-01],
	[2.63850E+04, 1.7330479090E+01, 5.4068523489E+00, 4.5180682149E+00, 2.1552382142E+00, 8.8117043514E-01],
	[2.63900E+04, 1.7335727401E+01, 5.4068091198E+00, 4.5208554810E+00, 2.1559465856E+00, 8.8122927236E-01],
	[2.63950E+04, 1.7340976308E+01, 5.4067658992E+00, 4.5236439381E+00, 2.1566548727E+00, 8.8128808229E-01],
	[2.64000E+04, 1.7346225808E+01, 5.4067226871E+00, 4.5264335865E+00, 2.1573630752E+00, 8.8134686494E-01],
	[2.64050E+04, 1.7351475904E+01, 5.4066794836E+00, 4.5292244264E+00, 2.1580711932E+00, 8.8140562032E-01],
	[2.64100E+04, 1.7356726594E+01, 5.4066362886E+00, 4.5320164581E+00, 2.1587792266E+00, 8.8146434844E-01],
	[2.64150E+04, 1.7361977878E+01, 5.4065931021E+00, 4.5348096820E+00, 2.1594871752E+00, 8.8152304931E-01],
	[2.64200E+04, 1.7367229757E+01, 5.4065499242E+00, 4.5376040982E+00, 2.1601950390E+00, 8.8158172293E-01],
	[2.64250E+04, 1.7372482230E+01, 5.4065067547E+00, 4.5403997071E+00, 2.1609028179E+00, 8.8164036932E-01],
	[2.64300E+04, 1.7377735298E+01, 5.4064635938E+00, 4.5431965090E+00, 2.1616105118E+00, 8.8169898848E-01],
	[2.64350E+04, 1.7382988960E+01, 5.4064204414E+00, 4.5459945041E+00, 2.1623181206E+00, 8.8175758043E-01],
	[2.64400E+04, 1.7388243216E+01, 5.4063772974E+00, 4.5487936927E+00, 2.1630256442E+00, 8.8181614518E-01],
	[2.64450E+04, 1.7393498066E+01, 5.4063341620E+00, 4.5515940752E+00, 2.1637330825E+00, 8.8187468273E-01],
	[2.64500E+04, 1.7398753510E+01, 5.4062910351E+00, 4.5543956517E+00, 2.1644404355E+00, 8.8193319309E-01],
	[2.64550E+04, 1.7404009549E+01, 5.4062479167E+00, 4.5571984226E+00, 2.1651477030E+00, 8.8199167628E-01],
	[2.64600E+04, 1.7409266181E+01, 5.4062048068E+00, 4.5600023882E+00, 2.1658548850E+00, 8.8205013230E-01],
	[2.64650E+04, 1.7414523408E+01, 5.4061617053E+00, 4.5628075487E+00, 2.1665619814E+00, 8.8210856116E-01],
	[2.64700E+04, 1.7419781229E+01, 5.4061186124E+00, 4.5656139045E+00, 2.1672689920E+00, 8.8216696287E-01],
	[2.64750E+04, 1.7425039643E+01, 5.4060755279E+00, 4.5684214557E+00, 2.1679759169E+00, 8.8222533745E-01],
	[2.64800E+04, 1.7430298651E+01, 5.4060324519E+00, 4.5712302028E+00, 2.1686827559E+00, 8.8228368489E-01],
	[2.64850E+04, 1.7435558254E+01, 5.4059893844E+00, 4.5740401459E+00, 2.1693895089E+00, 8.8234200522E-01],
	[2.64900E+04, 1.7440818450E+01, 5.4059463253E+00, 4.5768512854E+00, 2.1700961758E+00, 8.8240029843E-01],
	[2.64950E+04, 1.7446079239E+01, 5.4059032747E+00, 4.5796636215E+00, 2.1708027566E+00, 8.8245856454E-01],
	[2.65000E+04, 1.7451340623E+01, 5.4058602326E+00, 4.5824771546E+00, 2.1715092511E+00, 8.8251680357E-01],
	[2.65050E+04, 1.7456602600E+01, 5.4058171990E+00, 4.5852918848E+00, 2.1722156593E+00, 8.8257501551E-01],
	[2.65100E+04, 1.7461865171E+01, 5.4057741738E+00, 4.5881078126E+00, 2.1729219811E+00, 8.8263320038E-01],
	[2.65150E+04, 1.7467128335E+01, 5.4057311571E+00, 4.5909249381E+00, 2.1736282164E+00, 8.8269135818E-01],
	[2.65200E+04, 1.7472392093E+01, 5.4056881488E+00, 4.5937432617E+00, 2.1743343651E+00, 8.8274948893E-01],
	[2.65250E+04, 1.7477656444E+01, 5.4056451490E+00, 4.5965627836E+00, 2.1750404272E+00, 8.8280759264E-01],
	[2.65300E+04, 1.7482921389E+01, 5.4056021576E+00, 4.5993835042E+00, 2.1757464025E+00, 8.8286566932E-01],
	[2.65350E+04, 1.7488186927E+01, 5.4055591747E+00, 4.6022054237E+00, 2.1764522909E+00, 8.8292371897E-01],
	[2.65400E+04, 1.7493453058E+01, 5.4055162002E+00, 4.6050285423E+00, 2.1771580924E+00, 8.8298174160E-01],
	[2.65450E+04, 1.7498719783E+01, 5.4054732341E+00, 4.6078528605E+00, 2.1778638068E+00, 8.8303973723E-01],
	[2.65500E+04, 1.7503987101E+01, 5.4054302765E+00, 4.6106783784E+00, 2.1785694342E+00, 8.8309770587E-01],
	[2.65550E+04, 1.7509255012E+01, 5.4053873273E+00, 4.6135050963E+00, 2.1792749743E+00, 8.8315564752E-01],
	[2.65600E+04, 1.7514523517E+01, 5.4053443865E+00, 4.6163330146E+00, 2.1799804272E+00, 8.8321356219E-01],
	[2.65650E+04, 1.7519792614E+01, 5.4053014542E+00, 4.6191621335E+00, 2.1806857927E+00, 8.8327144989E-01],
	[2.65700E+04, 1.7525062305E+01, 5.4052585302E+00, 4.6219924533E+00, 2.1813910708E+00, 8.8332931064E-01],
	[2.65750E+04, 1.7530332588E+01, 5.4052156147E+00, 4.6248239742E+00, 2.1820962613E+00, 8.8338714444E-01],
	[2.65800E+04, 1.7535603465E+01, 5.4051727076E+00, 4.6276566967E+00, 2.1828013641E+00, 8.8344495131E-01],
	[2.65850E+04, 1.7540874935E+01, 5.4051298090E+00, 4.6304906208E+00, 2.1835063793E+00, 8.8350273124E-01],
	[2.65900E+04, 1.7546146997E+01, 5.4050869187E+00, 4.6333257470E+00, 2.1842113066E+00, 8.8356048426E-01],
	[2.65950E+04, 1.7551419652E+01, 5.4050440368E+00, 4.6361620756E+00, 2.1849161461E+00, 8.8361821036E-01],
	[2.66000E+04, 1.7556692900E+01, 5.4050011634E+00, 4.6389996067E+00, 2.1856208976E+00, 8.8367590957E-01],
	[2.66050E+04, 1.7561966741E+01, 5.4049582983E+00, 4.6418383407E+00, 2.1863255611E+00, 8.8373358189E-01],
	[2.66100E+04, 1.7567241175E+01, 5.4049154416E+00, 4.6446782778E+00, 2.1870301363E+00, 8.8379122733E-01],
	[2.66150E+04, 1.7572516201E+01, 5.4048725933E+00, 4.6475194184E+00, 2.1877346234E+00, 8.8384884589E-01],
	[2.66200E+04, 1.7577791820E+01, 5.4048297534E+00, 4.6503617628E+00, 2.1884390222E+00, 8.8390643760E-01],
	[2.66250E+04, 1.7583068031E+01, 5.4047869219E+00, 4.6532053111E+00, 2.1891433325E+00, 8.8396400246E-01],
	[2.66300E+04, 1.7588344835E+01, 5.4047440988E+00, 4.6560500638E+00, 2.1898475544E+00, 8.8402154047E-01],
	[2.66350E+04, 1.7593622231E+01, 5.4047012841E+00, 4.6588960210E+00, 2.1905516877E+00, 8.8407905165E-01],
	[2.66400E+04, 1.7598900220E+01, 5.4046584777E+00, 4.6617431831E+00, 2.1912557323E+00, 8.8413653601E-01],
	[2.66450E+04, 1.7604178802E+01, 5.4046156797E+00, 4.6645915504E+00, 2.1919596882E+00, 8.8419399356E-01],
	[2.66500E+04, 1.7609457975E+01, 5.4045728901E+00, 4.6674411231E+00, 2.1926635552E+00, 8.8425142431E-01],
	[2.66550E+04, 1.7614737741E+01, 5.4045301088E+00, 4.6702919015E+00, 2.1933673334E+00, 8.8430882826E-01],
	[2.66600E+04, 1.7620018099E+01, 5.4044873359E+00, 4.6731438859E+00, 2.1940710226E+00, 8.8436620544E-01],
	[2.66650E+04, 1.7625299050E+01, 5.4044445713E+00, 4.6759970766E+00, 2.1947746226E+00, 8.8442355583E-01],
	[2.66700E+04, 1.7630580593E+01, 5.4044018152E+00, 4.6788514739E+00, 2.1954781335E+00, 8.8448087947E-01],
	[2.66750E+04, 1.7635862727E+01, 5.4043590673E+00, 4.6817070780E+00, 2.1961815552E+00, 8.8453817635E-01],
	[2.66800E+04, 1.7641145454E+01, 5.4043163278E+00, 4.6845638893E+00, 2.1968848875E+00, 8.8459544649E-01],
	[2.66850E+04, 1.7646428773E+01, 5.4042735967E+00, 4.6874219079E+00, 2.1975881304E+00, 8.8465268989E-01],
	[2.66900E+04, 1.7651712684E+01, 5.4042308739E+00, 4.6902811343E+00, 2.1982912838E+00, 8.8470990657E-01],
	[2.66950E+04, 1.7656997187E+01, 5.4041881595E+00, 4.6931415687E+00, 2.1989943476E+00, 8.8476709653E-01],
	[2.67000E+04, 1.7662282281E+01, 5.4041454534E+00, 4.6960032114E+00, 2.1996973218E+00, 8.8482425979E-01],
	[2.67050E+04, 1.7667567968E+01, 5.4041027556E+00, 4.6988660626E+00, 2.2004002062E+00, 8.8488139636E-01],
	[2.67100E+04, 1.7672854247E+01, 5.4040600661E+00, 4.7017301226E+00, 2.2011030007E+00, 8.8493850624E-01],
	[2.67150E+04, 1.7678141117E+01, 5.4040173850E+00, 4.7045953918E+00, 2.2018057053E+00, 8.8499558944E-01],
	[2.67200E+04, 1.7683428579E+01, 5.4039747122E+00, 4.7074618704E+00, 2.2025083200E+00, 8.8505264598E-01],
	[2.67250E+04, 1.7688716632E+01, 5.4039320477E+00, 4.7103295587E+00, 2.2032108445E+00, 8.8510967586E-01],
	[2.67300E+04, 1.7694005278E+01, 5.4038893916E+00, 4.7131984570E+00, 2.2039132788E+00, 8.8516667910E-01],
	[2.67350E+04, 1.7699294514E+01, 5.4038467437E+00, 4.7160685655E+00, 2.2046156229E+00, 8.8522365570E-01],
	[2.67400E+04, 1.7704584343E+01, 5.4038041042E+00, 4.7189398846E+00, 2.2053178767E+00, 8.8528060568E-01],
	[2.67450E+04, 1.7709874763E+01, 5.4037614730E+00, 4.7218124145E+00, 2.2060200400E+00, 8.8533752904E-01],
	[2.67500E+04, 1.7715165774E+01, 5.4037188501E+00, 4.7246861555E+00, 2.2067221128E+00, 8.8539442579E-01],
	[2.67550E+04, 1.7720457377E+01, 5.4036762354E+00, 4.7275611079E+00, 2.2074240951E+00, 8.8545129594E-01],
	[2.67600E+04, 1.7725749571E+01, 5.4036336291E+00, 4.7304372720E+00, 2.2081259866E+00, 8.8550813951E-01],
	[2.67650E+04, 1.7731042357E+01, 5.4035910311E+00, 4.7333146480E+00, 2.2088277874E+00, 8.8556495650E-01],
	[2.67700E+04, 1.7736335734E+01, 5.4035484414E+00, 4.7361932364E+00, 2.2095294974E+00, 8.8562174693E-01],
	[2.67750E+04, 1.7741629702E+01, 5.4035058599E+00, 4.7390730372E+00, 2.2102311164E+00, 8.8567851079E-01],
	[2.67800E+04, 1.7746924261E+01, 5.4034632868E+00, 4.7419540509E+00, 2.2109326444E+00, 8.8573524811E-01],
	[2.67850E+04, 1.7752219411E+01, 5.4034207219E+00, 4.7448362777E+00, 2.2116340814E+00, 8.8579195889E-01],
	[2.67900E+04, 1.7757515153E+01, 5.4033781653E+00, 4.7477197178E+00, 2.2123354272E+00, 8.8584864315E-01],
	[2.67950E+04, 1.7762811485E+01, 5.4033356170E+00, 4.7506043716E+00, 2.2130366817E+00, 8.8590530088E-01],
	[2.68000E+04, 1.7768108409E+01, 5.4032930770E+00, 4.7534902394E+00, 2.2137378449E+00, 8.8596193211E-01],
	[2.68050E+04, 1.7773405924E+01, 5.4032505452E+00, 4.7563773215E+00, 2.2144389166E+00, 8.8601853684E-01],
	[2.68100E+04, 1.7778704029E+01, 5.4032080217E+00, 4.7592656180E+00, 2.2151398969E+00, 8.8607511509E-01],
	[2.68150E+04, 1.7784002726E+01, 5.4031655065E+00, 4.7621551294E+00, 2.2158407856E+00, 8.8613166685E-01],
	[2.68200E+04, 1.7789302013E+01, 5.4031229995E+00, 4.7650458558E+00, 2.2165415826E+00, 8.8618819215E-01],
	[2.68250E+04, 1.7794601891E+01, 5.4030805008E+00, 4.7679377977E+00, 2.2172422879E+00, 8.8624469099E-01],
	[2.68300E+04, 1.7799902360E+01, 5.4030380103E+00, 4.7708309552E+00, 2.2179429013E+00, 8.8630116338E-01],
	[2.68350E+04, 1.7805203419E+01, 5.4029955281E+00, 4.7737253286E+00, 2.2186434229E+00, 8.8635760933E-01],
	[2.68400E+04, 1.7810505069E+01, 5.4029530542E+00, 4.7766209183E+00, 2.2193438524E+00, 8.8641402885E-01],
	[2.68450E+04, 1.7815807310E+01, 5.4029105885E+00, 4.7795177244E+00, 2.2200441899E+00, 8.8647042196E-01],
	[2.68500E+04, 1.7821110141E+01, 5.4028681310E+00, 4.7824157474E+00, 2.2207444352E+00, 8.8652678865E-01],
	[2.68550E+04, 1.7826413563E+01, 5.4028256818E+00, 4.7853149875E+00, 2.2214445883E+00, 8.8658312895E-01],
	[2.68600E+04, 1.7831717576E+01, 5.4027832408E+00, 4.7882154449E+00, 2.2221446491E+00, 8.8663944286E-01],
	[2.68650E+04, 1.7837022179E+01, 5.4027408080E+00, 4.7911171200E+00, 2.2228446175E+00, 8.8669573039E-01],
	[2.68700E+04, 1.7842327372E+01, 5.4026983835E+00, 4.7940200130E+00, 2.2235444934E+00, 8.8675199155E-01],
	[2.68750E+04, 1.7847633156E+01, 5.4026559672E+00, 4.7969241243E+00, 2.2242442767E+00, 8.8680822636E-01],
	[2.68800E+04, 1.7852939529E+01, 5.4026135591E+00, 4.7998294540E+00, 2.2249439674E+00, 8.8686443481E-01],
	[2.68850E+04, 1.7858246494E+01, 5.4025711592E+00, 4.8027360026E+00, 2.2256435654E+00, 8.8692061693E-01],
	[2.68900E+04, 1.7863554048E+01, 5.4025287676E+00, 4.8056437702E+00, 2.2263430705E+00, 8.8697677272E-01],
	[2.68950E+04, 1.7868862193E+01, 5.4024863841E+00, 4.8085527572E+00, 2.2270424828E+00, 8.8703290218E-01],
	[2.69000E+04, 1.7874170927E+01, 5.4024440089E+00, 4.8114629638E+00, 2.2277418022E+00, 8.8708900534E-01],
	[2.69050E+04, 1.7879480252E+01, 5.4024016419E+00, 4.8143743903E+00, 2.2284410284E+00, 8.8714508218E-01],
	[2.69100E+04, 1.7884790167E+01, 5.4023592831E+00, 4.8172870371E+00, 2.2291401616E+00, 8.8720113273E-01],
	[2.69150E+04, 1.7890100672E+01, 5.4023169325E+00, 4.8202009043E+00, 2.2298392016E+00, 8.8725715700E-01],
	[2.69200E+04, 1.7895411767E+01, 5.4022745901E+00, 4.8231159924E+00, 2.2305381482E+00, 8.8731315498E-01],
	[2.69250E+04, 1.7900723452E+01, 5.4022322559E+00, 4.8260323015E+00, 2.2312370015E+00, 8.8736912669E-01],
	[2.69300E+04, 1.7906035726E+01, 5.4021899298E+00, 4.8289498319E+00, 2.2319357614E+00, 8.8742507213E-01],
	[2.69350E+04, 1.7911348591E+01, 5.4021476120E+00, 4.8318685840E+00, 2.2326344277E+00, 8.8748099132E-01],
	[2.69400E+04, 1.7916662045E+01, 5.4021053024E+00, 4.8347885580E+00, 2.2333330005E+00, 8.8753688426E-01],
	[2.69450E+04, 1.7921976089E+01, 5.4020630009E+00, 4.8377097542E+00, 2.2340314795E+00, 8.8759275096E-01],
	[2.69500E+04, 1.7927290722E+01, 5.4020207076E+00, 4.8406321730E+00, 2.2347298648E+00, 8.8764859143E-01],
	[2.69550E+04, 1.7932605946E+01, 5.4019784225E+00, 4.8435558144E+00, 2.2354281562E+00, 8.8770440568E-01],
	[2.69600E+04, 1.7937921759E+01, 5.4019361456E+00, 4.8464806790E+00, 2.2361263537E+00, 8.8776019371E-01],
	[2.69650E+04, 1.7943238161E+01, 5.4018938768E+00, 4.8494067668E+00, 2.2368244572E+00, 8.8781595554E-01],
	[2.69700E+04, 1.7948555153E+01, 5.4018516163E+00, 4.8523340783E+00, 2.2375224667E+00, 8.8787169117E-01],
	[2.69750E+04, 1.7953872735E+01, 5.4018093638E+00, 4.8552626138E+00, 2.2382203819E+00, 8.8792740060E-01],
	[2.69800E+04, 1.7959190906E+01, 5.4017671196E+00, 4.8581923734E+00, 2.2389182030E+00, 8.8798308386E-01],
	[2.69850E+04, 1.7964509666E+01, 5.4017248835E+00, 4.8611233575E+00, 2.2396159297E+00, 8.8803874094E-01],
	[2.69900E+04, 1.7969829016E+01, 5.4016826555E+00, 4.8640555663E+00, 2.2403135620E+00, 8.8809437186E-01],
	[2.69950E+04, 1.7975148955E+01, 5.4016404357E+00, 4.8669890003E+00, 2.2410110998E+00, 8.8814997662E-01],
	[2.70000E+04, 1.7980469483E+01, 5.4015982241E+00, 4.8699236595E+00, 2.2417085431E+00, 8.8820555523E-01],
	[2.70050E+04, 1.7985790600E+01, 5.4015560205E+00, 4.8728595444E+00, 2.2424058917E+00, 8.8826110771E-01],
	[2.70100E+04, 1.7991112307E+01, 5.4015138252E+00, 4.8757966552E+00, 2.2431031456E+00, 8.8831663405E-01],
	[2.70150E+04, 1.7996434603E+01, 5.4014716380E+00, 4.8787349921E+00, 2.2438003048E+00, 8.8837213426E-01],
	[2.70200E+04, 1.8001757487E+01, 5.4014294589E+00, 4.8816745556E+00, 2.2444973690E+00, 8.8842760836E-01],
	[2.70250E+04, 1.8007080961E+01, 5.4013872879E+00, 4.8846153458E+00, 2.2451943383E+00, 8.8848305636E-01],
	[2.70300E+04, 1.8012405024E+01, 5.4013451251E+00, 4.8875573630E+00, 2.2458912126E+00, 8.8853847826E-01],
	[2.70350E+04, 1.8017729676E+01, 5.4013029704E+00, 4.8905006076E+00, 2.2465879918E+00, 8.8859387406E-01],
	[2.70400E+04, 1.8023054917E+01, 5.4012608238E+00, 4.8934450798E+00, 2.2472846758E+00, 8.8864924379E-01],
	[2.70450E+04, 1.8028380746E+01, 5.4012186854E+00, 4.8963907799E+00, 2.2479812645E+00, 8.8870458744E-01],
	[2.70500E+04, 1.8033707164E+01, 5.4011765551E+00, 4.8993377082E+00, 2.2486777579E+00, 8.8875990503E-01],
	[2.70550E+04, 1.8039034172E+01, 5.4011344329E+00, 4.9022858650E+00, 2.2493741559E+00, 8.8881519656E-01],
	[2.70600E+04, 1.8044361768E+01, 5.4010923188E+00, 4.9052352505E+00, 2.2500704583E+00, 8.8887046205E-01],
	[2.70650E+04, 1.8049689952E+01, 5.4010502128E+00, 4.9081858650E+00, 2.2507666652E+00, 8.8892570149E-01],
	[2.70700E+04, 1.8055018725E+01, 5.4010081149E+00, 4.9111377089E+00, 2.2514627765E+00, 8.8898091491E-01],
	[2.70750E+04, 1.8060348087E+01, 5.4009660251E+00, 4.9140907824E+00, 2.2521587920E+00, 8.8903610230E-01],
	[2.70800E+04, 1.8065678037E+01, 5.4009239434E+00, 4.9170450857E+00, 2.2528547117E+00, 8.8909126368E-01],
	[2.70850E+04, 1.8071008576E+01, 5.4008818698E+00, 4.9200006193E+00, 2.2535505355E+00, 8.8914639905E-01],
	[2.70900E+04, 1.8076339704E+01, 5.4008398043E+00, 4.9229573833E+00, 2.2542462634E+00, 8.8920150843E-01],
	[2.70950E+04, 1.8081671419E+01, 5.4007977469E+00, 4.9259153781E+00, 2.2549418952E+00, 8.8925659182E-01],
	[2.71000E+04, 1.8087003724E+01, 5.4007556976E+00, 4.9288746039E+00, 2.2556374310E+00, 8.8931164922E-01],
	[2.71050E+04, 1.8092336616E+01, 5.4007136564E+00, 4.9318350610E+00, 2.2563328705E+00, 8.8936668066E-01],
	[2.71100E+04, 1.8097670097E+01, 5.4006716233E+00, 4.9347967497E+00, 2.2570282137E+00, 8.8942168614E-01],
	[2.71150E+04, 1.8103004166E+01, 5.4006295982E+00, 4.9377596703E+00, 2.2577234606E+00, 8.8947666566E-01],
	[2.71200E+04, 1.8108338823E+01, 5.4005875812E+00, 4.9407238231E+00, 2.2584186111E+00, 8.8953161923E-01],
	[2.71250E+04, 1.8113674069E+01, 5.4005455723E+00, 4.9436892084E+00, 2.2591136651E+00, 8.8958654687E-01],
	[2.71300E+04, 1.8119009902E+01, 5.4005035714E+00, 4.9466558264E+00, 2.2598086225E+00, 8.8964144858E-01],
	[2.71350E+04, 1.8124346324E+01, 5.4004615786E+00, 4.9496236774E+00, 2.2605034833E+00, 8.8969632436E-01],
	[2.71400E+04, 1.8129683333E+01, 5.4004195939E+00, 4.9525927617E+00, 2.2611982473E+00, 8.8975117424E-01],
	[2.71450E+04, 1.8135020931E+01, 5.4003776173E+00, 4.9555630797E+00, 2.2618929145E+00, 8.8980599822E-01],
	[2.71500E+04, 1.8140376342E+01, 5.4003383467E+00, 4.9585346315E+00, 2.2625882265E+00, 8.8986079630E-01],
	[2.71550E+04, 1.8145772303E+01, 5.4003053400E+00, 4.9615074175E+00, 2.2632851625E+00, 8.8991556849E-01],
	[2.71600E+04, 1.8151168876E+01, 5.4002723395E+00, 4.9644814380E+00, 2.2639820037E+00, 8.8997031481E-01],
	[2.71650E+04, 1.8156566060E+01, 5.4002393454E+00, 4.9674566932E+00, 2.2646787498E+00, 8.9002503526E-01],
	[2.71700E+04, 1.8161963855E+01, 5.4002063575E+00, 4.9704331834E+00, 2.2653754007E+00, 8.9007972985E-01],
	[2.71750E+04, 1.8167362260E+01, 5.4001733759E+00, 4.9734109089E+00, 2.2660719565E+00, 8.9013439859E-01],
	[2.71800E+04, 1.8172761277E+01, 5.4001404006E+00, 4.9763898701E+00, 2.2667684170E+00, 8.9018904149E-01],
	[2.71850E+04, 1.8178160905E+01, 5.4001074315E+00, 4.9793700671E+00, 2.2674647822E+00, 8.9024365855E-01],
	[2.71900E+04, 1.8183561144E+01, 5.4000744687E+00, 4.9823515003E+00, 2.2681610519E+00, 8.9029824979E-01],
	[2.71950E+04, 1.8188961993E+01, 5.4000415121E+00, 4.9853341699E+00, 2.2688572262E+00, 8.9035281522E-01],
	[2.72000E+04, 1.8194363454E+01, 5.4000085619E+00, 4.9883180763E+00, 2.2695533048E+00, 8.9040735483E-01],
	[2.72050E+04, 1.8199765525E+01, 5.3999756178E+00, 4.9913032197E+00, 2.2702492879E+00, 8.9046186865E-01],
	[2.72100E+04, 1.8205168207E+01, 5.3999426801E+00, 4.9942896004E+00, 2.2709451752E+00, 8.9051635667E-01],
	[2.72150E+04, 1.8210571499E+01, 5.3999097485E+00, 4.9972772187E+00, 2.2716409667E+00, 8.9057081892E-01],
	[2.72200E+04, 1.8215975402E+01, 5.3998768233E+00, 5.0002660748E+00, 2.2723366623E+00, 8.9062525539E-01],
	[2.72250E+04, 1.8221379916E+01, 5.3998439042E+00, 5.0032561692E+00, 2.2730322620E+00, 8.9067966610E-01],
	[2.72300E+04, 1.8226785040E+01, 5.3998109915E+00, 5.0062475020E+00, 2.2737277656E+00, 8.9073405105E-01],
	[2.72350E+04, 1.8232190775E+01, 5.3997780849E+00, 5.0092400735E+00, 2.2744231732E+00, 8.9078841026E-01],
	[2.72400E+04, 1.8237597121E+01, 5.3997451847E+00, 5.0122338841E+00, 2.2751184846E+00, 8.9084274373E-01],
	[2.72450E+04, 1.8243004076E+01, 5.3997122906E+00, 5.0152289339E+00, 2.2758136997E+00, 8.9089705147E-01],
	[2.72500E+04, 1.8248411642E+01, 5.3996794028E+00, 5.0182252234E+00, 2.2765088185E+00, 8.9095133349E-01],
	[2.72550E+04, 1.8253819819E+01, 5.3996465212E+00, 5.0212227527E+00, 2.2772038409E+00, 8.9100558979E-01],
	[2.72600E+04, 1.8259228606E+01, 5.3996136459E+00, 5.0242215222E+00, 2.2778987669E+00, 8.9105982040E-01],
	[2.72650E+04, 1.8264638003E+01, 5.3995807767E+00, 5.0272215321E+00, 2.2785935962E+00, 8.9111402531E-01],
	[2.72700E+04, 1.8270048010E+01, 5.3995479138E+00, 5.0302227828E+00, 2.2792883290E+00, 8.9116820454E-01],
	[2.72750E+04, 1.8275458627E+01, 5.3995150572E+00, 5.0332252745E+00, 2.2799829651E+00, 8.9122235809E-01],
	[2.72800E+04, 1.8280869855E+01, 5.3994822067E+00, 5.0362290075E+00, 2.2806775044E+00, 8.9127648597E-01],
	[2.72850E+04, 1.8286281692E+01, 5.3994493625E+00, 5.0392339821E+00, 2.2813719468E+00, 8.9133058820E-01],
	[2.72900E+04, 1.8291694140E+01, 5.3994165245E+00, 5.0422401985E+00, 2.2820662923E+00, 8.9138466477E-01],
	[2.72950E+04, 1.8297107197E+01, 5.3993836927E+00, 5.0452476571E+00, 2.2827605409E+00, 8.9143871571E-01],
	[2.73000E+04, 1.8302520865E+01, 5.3993508671E+00, 5.0482563582E+00, 2.2834546923E+00, 8.9149274101E-01],
	[2.73050E+04, 1.8307935143E+01, 5.3993180478E+00, 5.0512663020E+00, 2.2841487467E+00, 8.9154674069E-01],
	[2.73100E+04, 1.8313350030E+01, 5.3992852346E+00, 5.0542774888E+00, 2.2848427038E+00, 8.9160071475E-01],
	[2.73150E+04, 1.8318765527E+01, 5.3992524277E+00, 5.0572899190E+00, 2.2855365636E+00, 8.9165466321E-01],
	[2.73200E+04, 1.8324181634E+01, 5.3992196269E+00, 5.0603035927E+00, 2.2862303261E+00, 8.9170858608E-01],
	[2.73250E+04, 1.8329598351E+01, 5.3991868324E+00, 5.0633185103E+00, 2.2869239911E+00, 8.9176248335E-01],
	[2.73300E+04, 1.8335015677E+01, 5.3991540440E+00, 5.0663346720E+00, 2.2876175586E+00, 8.9181635505E-01],
	[2.73350E+04, 1.8340433613E+01, 5.3991212619E+00, 5.0693520782E+00, 2.2883110285E+00, 8.9187020118E-01],
	[2.73400E+04, 1.8345852159E+01, 5.3990884859E+00, 5.0723707291E+00, 2.2890044008E+00, 8.9192402174E-01],
	[2.73450E+04, 1.8351271314E+01, 5.3990557161E+00, 5.0753906251E+00, 2.2896976753E+00, 8.9197781676E-01],
	[2.73500E+04, 1.8356691079E+01, 5.3990229526E+00, 5.0784117663E+00, 2.2903908521E+00, 8.9203158623E-01],
	[2.73550E+04, 1.8362111453E+01, 5.3989901952E+00, 5.0814341532E+00, 2.2910839309E+00, 8.9208533017E-01],
	[2.73600E+04, 1.8367532436E+01, 5.3989574440E+00, 5.0844577859E+00, 2.2917769118E+00, 8.9213904858E-01],
	[2.73650E+04, 1.8372954030E+01, 5.3989246990E+00, 5.0874826648E+00, 2.2924697947E+00, 8.9219274148E-01],
	[2.73700E+04, 1.8378376232E+01, 5.3988919601E+00, 5.0905087901E+00, 2.2931625795E+00, 8.9224640886E-01],
	[2.73750E+04, 1.8383799044E+01, 5.3988592275E+00, 5.0935361621E+00, 2.2938552661E+00, 8.9230005076E-01],
	[2.73800E+04, 1.8389222465E+01, 5.3988265010E+00, 5.0965647812E+00, 2.2945478545E+00, 8.9235366716E-01],
	[2.73850E+04, 1.8394646495E+01, 5.3987937807E+00, 5.0995946476E+00, 2.2952403446E+00, 8.9240725808E-01],
	[2.73900E+04, 1.8400071134E+01, 5.3987610666E+00, 5.1026257615E+00, 2.2959327363E+00, 8.9246082353E-01],
	[2.73950E+04, 1.8405496383E+01, 5.3987283586E+00, 5.1056581234E+00, 2.2966250295E+00, 8.9251436352E-01],
	[2.74000E+04, 1.8410922240E+01, 5.3986956568E+00, 5.1086917334E+00, 2.2973172242E+00, 8.9256787805E-01],
	[2.74050E+04, 1.8416348707E+01, 5.3986629612E+00, 5.1117265918E+00, 2.2980093203E+00, 8.9262136714E-01],
	[2.74100E+04, 1.8421775782E+01, 5.3986302717E+00, 5.1147626990E+00, 2.2987013177E+00, 8.9267483080E-01],
	[2.74150E+04, 1.8427203467E+01, 5.3985975884E+00, 5.1178000552E+00, 2.2993932164E+00, 8.9272826903E-01],
	[2.74200E+04, 1.8432631761E+01, 5.3985649113E+00, 5.1208386607E+00, 2.3000850162E+00, 8.9278168184E-01],
	[2.74250E+04, 1.8438060663E+01, 5.3985322403E+00, 5.1238785158E+00, 2.3007767172E+00, 8.9283506924E-01],
	[2.74300E+04, 1.8443490174E+01, 5.3984995754E+00, 5.1269196208E+00, 2.3014683192E+00, 8.9288843125E-01],
	[2.74350E+04, 1.8448920294E+01, 5.3984669167E+00, 5.1299619759E+00, 2.3021598222E+00, 8.9294176787E-01],
	[2.74400E+04, 1.8454351023E+01, 5.3984342642E+00, 5.1330055815E+00, 2.3028512260E+00, 8.9299507910E-01],
	[2.74450E+04, 1.8459782361E+01, 5.3984016178E+00, 5.1360504378E+00, 2.3035425307E+00, 8.9304836496E-01],
	[2.74500E+04, 1.8465214307E+01, 5.3983689775E+00, 5.1390965452E+00, 2.3042337362E+00, 8.9310162546E-01],
	[2.74550E+04, 1.8470646862E+01, 5.3983363434E+00, 5.1421439038E+00, 2.3049248423E+00, 8.9315486061E-01],
	[2.74600E+04, 1.8476080025E+01, 5.3983037155E+00, 5.1451925141E+00, 2.3056158490E+00, 8.9320807041E-01],
	[2.74650E+04, 1.8481513797E+01, 5.3982710936E+00, 5.1482423762E+00, 2.3063067563E+00, 8.9326125487E-01],
	[2.74700E+04, 1.8486948177E+01, 5.3982384779E+00, 5.1512934905E+00, 2.3069975640E+00, 8.9331441401E-01],
	[2.74750E+04, 1.8492383166E+01, 5.3982058684E+00, 5.1543458572E+00, 2.3076882721E+00, 8.9336754784E-01],
	[2.74800E+04, 1.8497818763E+01, 5.3981732650E+00, 5.1573994767E+00, 2.3083788806E+00, 8.9342065635E-01],
	[2.74850E+04, 1.8503254969E+01, 5.3981406677E+00, 5.1604543492E+00, 2.3090693893E+00, 8.9347373957E-01],
	[2.74900E+04, 1.8508691783E+01, 5.3981080765E+00, 5.1635104750E+00, 2.3097597982E+00, 8.9352679749E-01],
	[2.74950E+04, 1.8514129205E+01, 5.3980754914E+00, 5.1665678543E+00, 2.3104501072E+00, 8.9357983014E-01],
	[2.75000E+04, 1.8519567236E+01, 5.3980429125E+00, 5.1696264876E+00, 2.3111403162E+00, 8.9363283751E-01],
	[2.75050E+04, 1.8525005874E+01, 5.3980103397E+00, 5.1726863751E+00, 2.3118304252E+00, 8.9368581962E-01],
	[2.75100E+04, 1.8530445121E+01, 5.3979777730E+00, 5.1757475170E+00, 2.3125204341E+00, 8.9373877648E-01],
	[2.75150E+04, 1.8535884976E+01, 5.3979452124E+00, 5.1788099136E+00, 2.3132103429E+00, 8.9379170809E-01],
	[2.75200E+04, 1.8541325439E+01, 5.3979126579E+00, 5.1818735653E+00, 2.3139001514E+00, 8.9384461447E-01],
	[2.75250E+04, 1.8546766510E+01, 5.3978801096E+00, 5.1849384722E+00, 2.3145898596E+00, 8.9389749562E-01],
	[2.75300E+04, 1.8552208189E+01, 5.3978475673E+00, 5.1880046348E+00, 2.3152794674E+00, 8.9395035156E-01],
	[2.75350E+04, 1.8557650476E+01, 5.3978150312E+00, 5.1910720533E+00, 2.3159689747E+00, 8.9400318229E-01],
	[2.75400E+04, 1.8563093371E+01, 5.3977825012E+00, 5.1941407279E+00, 2.3166583816E+00, 8.9405598782E-01],
	[2.75450E+04, 1.8568536874E+01, 5.3977499772E+00, 5.1972106590E+00, 2.3173476878E+00, 8.9410876816E-01],
	[2.75500E+04, 1.8573980985E+01, 5.3977174594E+00, 5.2002818468E+00, 2.3180368934E+00, 8.9416152332E-01],
	[2.75550E+04, 1.8579425703E+01, 5.3976849477E+00, 5.2033542916E+00, 2.3187259983E+00, 8.9421425331E-01],
	[2.75600E+04, 1.8584871029E+01, 5.3976524420E+00, 5.2064279938E+00, 2.3194150024E+00, 8.9426695814E-01],
	[2.75650E+04, 1.8590316963E+01, 5.3976199425E+00, 5.2095029536E+00, 2.3201039055E+00, 8.9431963782E-01],
	[2.75700E+04, 1.8595763504E+01, 5.3975874490E+00, 5.2125791712E+00, 2.3207927078E+00, 8.9437229236E-01],
	[2.75750E+04, 1.8601210653E+01, 5.3975549616E+00, 5.2156566471E+00, 2.3214814091E+00, 8.9442492176E-01],
	[2.75800E+04, 1.8606658410E+01, 5.3975224803E+00, 5.2187353814E+00, 2.3221700092E+00, 8.9447752604E-01],
	[2.75850E+04, 1.8612106774E+01, 5.3974900051E+00, 5.2218153744E+00, 2.3228585082E+00, 8.9453010520E-01],
	[2.75900E+04, 1.8617555745E+01, 5.3974575360E+00, 5.2248966265E+00, 2.3235469061E+00, 8.9458265926E-01],
	[2.75950E+04, 1.8623005324E+01, 5.3974250730E+00, 5.2279791378E+00, 2.3242352026E+00, 8.9463518822E-01],
	[2.76000E+04, 1.8628455511E+01, 5.3973926160E+00, 5.2310629088E+00, 2.3249233978E+00, 8.9468769209E-01],
	[2.76050E+04, 1.8633906304E+01, 5.3973601651E+00, 5.2341479397E+00, 2.3256114915E+00, 8.9474017089E-01],
	[2.76100E+04, 1.8639357705E+01, 5.3973277203E+00, 5.2372342308E+00, 2.3262994838E+00, 8.9479262461E-01],
	[2.76150E+04, 1.8644809714E+01, 5.3972952815E+00, 5.2403217823E+00, 2.3269873745E+00, 8.9484505328E-01],
	[2.76200E+04, 1.8650262329E+01, 5.3972628488E+00, 5.2434105946E+00, 2.3276751635E+00, 8.9489745690E-01],
	[2.76250E+04, 1.8655715552E+01, 5.3972304222E+00, 5.2465006679E+00, 2.3283628509E+00, 8.9494983548E-01],
	[2.76300E+04, 1.8661169382E+01, 5.3971980017E+00, 5.2495920026E+00, 2.3290504365E+00, 8.9500218902E-01],
	[2.76350E+04, 1.8666623818E+01, 5.3971655872E+00, 5.2526845988E+00, 2.3297379203E+00, 8.9505451755E-01],
	[2.76400E+04, 1.8672078862E+01, 5.3971331787E+00, 5.2557784570E+00, 2.3304253022E+00, 8.9510682106E-01],
	[2.76450E+04, 1.8677534513E+01, 5.3971007764E+00, 5.2588735773E+00, 2.3311125821E+00, 8.9515909956E-01],
	[2.76500E+04, 1.8682990771E+01, 5.3970683800E+00, 5.2619699601E+00, 2.3317997599E+00, 8.9521135308E-01],
	[2.76550E+04, 1.8688447636E+01, 5.3970359898E+00, 5.2650676057E+00, 2.3324868357E+00, 8.9526358160E-01],
	[2.76600E+04, 1.8693905108E+01, 5.3970036055E+00, 5.2681665143E+00, 2.3331738093E+00, 8.9531578516E-01],
	[2.76650E+04, 1.8699363187E+01, 5.3969712274E+00, 5.2712666862E+00, 2.3338606806E+00, 8.9536796375E-01],
	[2.76700E+04, 1.8704821872E+01, 5.3969388552E+00, 5.2743681218E+00, 2.3345474497E+00, 8.9542011738E-01],
	[2.76750E+04, 1.8710281164E+01, 5.3969064891E+00, 5.2774708213E+00, 2.3352341163E+00, 8.9547224606E-01],
	[2.76800E+04, 1.8715741063E+01, 5.3968741291E+00, 5.2805747849E+00, 2.3359206805E+00, 8.9552434980E-01],
	[2.76850E+04, 1.8721201569E+01, 5.3968417751E+00, 5.2836800130E+00, 2.3366071422E+00, 8.9557642862E-01],
	[2.76900E+04, 1.8726662681E+01, 5.3968094271E+00, 5.2867865059E+00, 2.3372935014E+00, 8.9562848252E-01],
	[2.76950E+04, 1.8732124400E+01, 5.3967770852E+00, 5.2898942638E+00, 2.3379797578E+00, 8.9568051151E-01],
	[2.77000E+04, 1.8737586725E+01, 5.3967447493E+00, 5.2930032871E+00, 2.3386659116E+00, 8.9573251559E-01],
	[2.77050E+04, 1.8743049657E+01, 5.3967124194E+00, 5.2961135760E+00, 2.3393519626E+00, 8.9578449479E-01],
	[2.77100E+04, 1.8748513195E+01, 5.3966800956E+00, 5.2992251308E+00, 2.3400379107E+00, 8.9583644911E-01],
	[2.77150E+04, 1.8753977340E+01, 5.3966477777E+00, 5.3023379518E+00, 2.3407237559E+00, 8.9588837855E-01],
	[2.77200E+04, 1.8759442091E+01, 5.3966154660E+00, 5.3054520393E+00, 2.3414094981E+00, 8.9594028313E-01],
	[2.77250E+04, 1.8764907448E+01, 5.3965831602E+00, 5.3085673935E+00, 2.3420951373E+00, 8.9599216286E-01],
	[2.77300E+04, 1.8770373412E+01, 5.3965508604E+00, 5.3116840148E+00, 2.3427806734E+00, 8.9604401774E-01],
	[2.77350E+04, 1.8775839982E+01, 5.3965185667E+00, 5.3148019035E+00, 2.3434661062E+00, 8.9609584779E-01],
	[2.77400E+04, 1.8781307158E+01, 5.3964862790E+00, 5.3179210598E+00, 2.3441514359E+00, 8.9614765302E-01],
	[2.77450E+04, 1.8786774940E+01, 5.3964539972E+00, 5.3210414840E+00, 2.3448366622E+00, 8.9619943342E-01],
	[2.77500E+04, 1.8792243329E+01, 5.3964217215E+00, 5.3241631764E+00, 2.3455217851E+00, 8.9625118903E-01],
	[2.77550E+04, 1.8797712323E+01, 5.3963894518E+00, 5.3272861372E+00, 2.3462068046E+00, 8.9630291983E-01],
	[2.77600E+04, 1.8803181924E+01, 5.3963571882E+00, 5.3304103669E+00, 2.3468917206E+00, 8.9635462585E-01],
	[2.77650E+04, 1.8808652130E+01, 5.3963249305E+00, 5.3335358656E+00, 2.3475765329E+00, 8.9640630710E-01],
	[2.77700E+04, 1.8814122943E+01, 5.3962926788E+00, 5.3366626337E+00, 2.3482612417E+00, 8.9645796357E-01],
	[2.77750E+04, 1.8819594361E+01, 5.3962604331E+00, 5.3397906714E+00, 2.3489458467E+00, 8.9650959528E-01],
	[2.77800E+04, 1.8825066386E+01, 5.3962281934E+00, 5.3429199791E+00, 2.3496303479E+00, 8.9656120225E-01],
	[2.77850E+04, 1.8830539016E+01, 5.3961959597E+00, 5.3460505569E+00, 2.3503147453E+00, 8.9661278448E-01],
	[2.77900E+04, 1.8836012252E+01, 5.3961637320E+00, 5.3491824053E+00, 2.3509990388E+00, 8.9666434197E-01],
	[2.77950E+04, 1.8841486093E+01, 5.3961315103E+00, 5.3523155244E+00, 2.3516832283E+00, 8.9671587475E-01],
	[2.78000E+04, 1.8846960541E+01, 5.3960992946E+00, 5.3554499146E+00, 2.3523673138E+00, 8.9676738281E-01],
	[2.78050E+04, 1.8852435594E+01, 5.3960670849E+00, 5.3585855762E+00, 2.3530512952E+00, 8.9681886618E-01],
	[2.78100E+04, 1.8857911252E+01, 5.3960348811E+00, 5.3617225094E+00, 2.3537351723E+00, 8.9687032485E-01],
	[2.78150E+04, 1.8863387517E+01, 5.3960026833E+00, 5.3648607145E+00, 2.3544189453E+00, 8.9692175883E-01],
	[2.78200E+04, 1.8868864386E+01, 5.3959704915E+00, 5.3680001919E+00, 2.3551026139E+00, 8.9697316815E-01],
	[2.78250E+04, 1.8874341862E+01, 5.3959383057E+00, 5.3711409417E+00, 2.3557861782E+00, 8.9702455280E-01],
	[2.78300E+04, 1.8879819942E+01, 5.3959061259E+00, 5.3742829644E+00, 2.3564696380E+00, 8.9707591280E-01],
	[2.78350E+04, 1.8885298629E+01, 5.3958739520E+00, 5.3774262601E+00, 2.3571529934E+00, 8.9712724815E-01],
	[2.78400E+04, 1.8890777920E+01, 5.3958417841E+00, 5.3805708292E+00, 2.3578362441E+00, 8.9717855887E-01],
	[2.78450E+04, 1.8896257817E+01, 5.3958096222E+00, 5.3837166720E+00, 2.3585193903E+00, 8.9722984496E-01],
	[2.78500E+04, 1.8901738319E+01, 5.3957774662E+00, 5.3868637887E+00, 2.3592024317E+00, 8.9728110644E-01],
	[2.78550E+04, 1.8907219426E+01, 5.3957453162E+00, 5.3900121796E+00, 2.3598853684E+00, 8.9733234331E-01],
	[2.78600E+04, 1.8912701139E+01, 5.3957131722E+00, 5.3931618450E+00, 2.3605682003E+00, 8.9738355559E-01],
	[2.78650E+04, 1.8918183457E+01, 5.3956810341E+00, 5.3963127853E+00, 2.3612509272E+00, 8.9743474328E-01],
	[2.78700E+04, 1.8923666380E+01, 5.3956489020E+00, 5.3994650006E+00, 2.3619335492E+00, 8.9748590639E-01],
	[2.78750E+04, 1.8929149907E+01, 5.3956167758E+00, 5.4026184913E+00, 2.3626160662E+00, 8.9753704493E-01],
	[2.78800E+04, 1.8934634040E+01, 5.3955846556E+00, 5.4057732577E+00, 2.3632984782E+00, 8.9758815891E-01],
	[2.78850E+04, 1.8940118778E+01, 5.3955525414E+00, 5.4089293000E+00, 2.3639807849E+00, 8.9763924835E-01],
	[2.78900E+04, 1.8945604121E+01, 5.3955204331E+00, 5.4120866186E+00, 2.3646629865E+00, 8.9769031325E-01],
	[2.78950E+04, 1.8951090069E+01, 5.3954883307E+00, 5.4152452137E+00, 2.3653450828E+00, 8.9774135361E-01],
	[2.79000E+04, 1.8956576622E+01, 5.3954562343E+00, 5.4184050856E+00, 2.3660270737E+00, 8.9779236946E-01],
	[2.79050E+04, 1.8962063779E+01, 5.3954241438E+00, 5.4215662346E+00, 2.3667089593E+00, 8.9784336080E-01],
	[2.79100E+04, 1.8967551542E+01, 5.3953920593E+00, 5.4247286610E+00, 2.3673907394E+00, 8.9789432764E-01],
	[2.79150E+04, 1.8973039909E+01, 5.3953599807E+00, 5.4278923650E+00, 2.3680724139E+00, 8.9794526998E-01],
	[2.79200E+04, 1.8978528880E+01, 5.3953279080E+00, 5.4310573470E+00, 2.3687539829E+00, 8.9799618785E-01],
	[2.79250E+04, 1.8984018457E+01, 5.3952958413E+00, 5.4342236073E+00, 2.3694354462E+00, 8.9804708124E-01],
	[2.79300E+04, 1.8989508638E+01, 5.3952637805E+00, 5.4373911461E+00, 2.3701168038E+00, 8.9809795017E-01],
	[2.79350E+04, 1.8994999423E+01, 5.3952317256E+00, 5.4405599637E+00, 2.3707980556E+00, 8.9814879465E-01],
	[2.79400E+04, 1.9000490813E+01, 5.3951996767E+00, 5.4437300605E+00, 2.3714792015E+00, 8.9819961469E-01],
	[2.79450E+04, 1.9005982808E+01, 5.3951676337E+00, 5.4469014366E+00, 2.3721602416E+00, 8.9825041029E-01],
	[2.79500E+04, 1.9011475407E+01, 5.3951355966E+00, 5.4500740924E+00, 2.3728411756E+00, 8.9830118147E-01],
	[2.79550E+04, 1.9016968611E+01, 5.3951035654E+00, 5.4532480282E+00, 2.3735220037E+00, 8.9835192824E-01],
	[2.79600E+04, 1.9022462419E+01, 5.3950715402E+00, 5.4564232442E+00, 2.3742027256E+00, 8.9840265060E-01],
	[2.79650E+04, 1.9027956831E+01, 5.3950395208E+00, 5.4595997408E+00, 2.3748833414E+00, 8.9845334856E-01],
	[2.79700E+04, 1.9033451847E+01, 5.3950075074E+00, 5.4627775183E+00, 2.3755638509E+00, 8.9850402215E-01],
	[2.79750E+04, 1.9038947468E+01, 5.3949754999E+00, 5.4659565768E+00, 2.3762442542E+00, 8.9855467136E-01],
	[2.79800E+04, 1.9044443693E+01, 5.3949434983E+00, 5.4691369168E+00, 2.3769245511E+00, 8.9860529620E-01],
	[2.79850E+04, 1.9049940522E+01, 5.3949115026E+00, 5.4723185384E+00, 2.3776047415E+00, 8.9865589668E-01],
	[2.79900E+04, 1.9055437955E+01, 5.3948795128E+00, 5.4755014421E+00, 2.3782848256E+00, 8.9870647283E-01],
	[2.79950E+04, 1.9060935992E+01, 5.3948475289E+00, 5.4786856280E+00, 2.3789648030E+00, 8.9875702463E-01],
	[2.80000E+04, 1.9066434634E+01, 5.3948155510E+00, 5.4818710964E+00, 2.3796446739E+00, 8.9880755211E-01],
	[2.80050E+04, 1.9071933879E+01, 5.3947835789E+00, 5.4850578477E+00, 2.3803244381E+00, 8.9885805527E-01],
	[2.80100E+04, 1.9077433728E+01, 5.3947516127E+00, 5.4882458822E+00, 2.3810040956E+00, 8.9890853412E-01],
	[2.80150E+04, 1.9082934181E+01, 5.3947196524E+00, 5.4914352000E+00, 2.3816836463E+00, 8.9895898868E-01],
	[2.80200E+04, 1.9088435238E+01, 5.3946876980E+00, 5.4946258016E+00, 2.3823630902E+00, 8.9900941895E-01],
	[2.80250E+04, 1.9093936899E+01, 5.3946557495E+00, 5.4978176872E+00, 2.3830424271E+00, 8.9905982494E-01],
	[2.80300E+04, 1.9099439164E+01, 5.3946238069E+00, 5.5010108570E+00, 2.3837216571E+00, 8.9911020666E-01],
	[2.80350E+04, 1.9104942032E+01, 5.3945918702E+00, 5.5042053115E+00, 2.3844007800E+00, 8.9916056413E-01],
	[2.80400E+04, 1.9110445504E+01, 5.3945599393E+00, 5.5074010507E+00, 2.3850797958E+00, 8.9921089735E-01],
	[2.80450E+04, 1.9115949580E+01, 5.3945280144E+00, 5.5105980752E+00, 2.3857587045E+00, 8.9926120632E-01],
	[2.80500E+04, 1.9121454259E+01, 5.3944960953E+00, 5.5137963850E+00, 2.3864375059E+00, 8.9931149107E-01],
	[2.80550E+04, 1.9126959542E+01, 5.3944641821E+00, 5.5169959806E+00, 2.3871162001E+00, 8.9936175160E-01],
	[2.80600E+04, 1.9132465429E+01, 5.3944322748E+00, 5.5201968622E+00, 2.3877947869E+00, 8.9941198792E-01],
	[2.80650E+04, 1.9137971919E+01, 5.3944003733E+00, 5.5233990300E+00, 2.3884732664E+00, 8.9946220004E-01],
	[2.80700E+04, 1.9143479012E+01, 5.3943684777E+00, 5.5266024845E+00, 2.3891516383E+00, 8.9951238796E-01],
	[2.80750E+04, 1.9148986709E+01, 5.3943365880E+00, 5.5298072258E+00, 2.3898299027E+00, 8.9956255171E-01],
	[2.80800E+04, 1.9154495009E+01, 5.3943047042E+00, 5.5330132543E+00, 2.3905080596E+00, 8.9961269129E-01],
	[2.80850E+04, 1.9160003913E+01, 5.3942728262E+00, 5.5362205703E+00, 2.3911861088E+00, 8.9966280671E-01],
	[2.80900E+04, 1.9165513420E+01, 5.3942409541E+00, 5.5394291740E+00, 2.3918640503E+00, 8.9971289797E-01],
	[2.80950E+04, 1.9171023530E+01, 5.3942090878E+00, 5.5426390656E+00, 2.3925418840E+00, 8.9976296509E-01],
	[2.81000E+04, 1.9176534243E+01, 5.3941772274E+00, 5.5458502457E+00, 2.3932196099E+00, 8.9981300809E-01],
	[2.81050E+04, 1.9182045560E+01, 5.3941453729E+00, 5.5490627143E+00, 2.3938972279E+00, 8.9986302696E-01],
	[2.81100E+04, 1.9187557479E+01, 5.3941135242E+00, 5.5522764717E+00, 2.3945747379E+00, 8.9991302172E-01],
	[2.81150E+04, 1.9193070002E+01, 5.3940816813E+00, 5.5554915184E+00, 2.3952521399E+00, 8.9996299237E-01],
	[2.81200E+04, 1.9198583128E+01, 5.3940498444E+00, 5.5587078545E+00, 2.3959294339E+00, 9.0001293894E-01],
	[2.81250E+04, 1.9204096856E+01, 5.3940180132E+00, 5.5619254804E+00, 2.3966066197E+00, 9.0006286142E-01],
	[2.81300E+04, 1.9209611188E+01, 5.3939861879E+00, 5.5651443963E+00, 2.3972836973E+00, 9.0011275983E-01],
	[2.81350E+04, 1.9215126123E+01, 5.3939543685E+00, 5.5683646025E+00, 2.3979606667E+00, 9.0016263418E-01],
	[2.81400E+04, 1.9220641660E+01, 5.3939225549E+00, 5.5715860993E+00, 2.3986375278E+00, 9.0021248447E-01],
	[2.81450E+04, 1.9226157800E+01, 5.3938907471E+00, 5.5748088871E+00, 2.3993142804E+00, 9.0026231072E-01],
	[2.81500E+04, 1.9231674543E+01, 5.3938589452E+00, 5.5780329660E+00, 2.3999909247E+00, 9.0031211294E-01],
	[2.81550E+04, 1.9237191889E+01, 5.3938271491E+00, 5.5812583364E+00, 2.4006674604E+00, 9.0036189113E-01],
	[2.81600E+04, 1.9242709838E+01, 5.3937953588E+00, 5.5844849985E+00, 2.4013438876E+00, 9.0041164531E-01],
	[2.81650E+04, 1.9248228389E+01, 5.3937635744E+00, 5.5877129528E+00, 2.4020202062E+00, 9.0046137549E-01],
	[2.81700E+04, 1.9253747543E+01, 5.3937317958E+00, 5.5909421993E+00, 2.4026964161E+00, 9.0051108167E-01],
	[2.81750E+04, 1.9259267299E+01, 5.3937000231E+00, 5.5941727385E+00, 2.4033725173E+00, 9.0056076387E-01],
	[2.81800E+04, 1.9264787658E+01, 5.3936682561E+00, 5.5974045706E+00, 2.4040485097E+00, 9.0061042209E-01],
	[2.81850E+04, 1.9270308620E+01, 5.3936364950E+00, 5.6006376959E+00, 2.4047243933E+00, 9.0066005635E-01],
	[2.81900E+04, 1.9275830184E+01, 5.3936047397E+00, 5.6038721146E+00, 2.4054001679E+00, 9.0070966665E-01],
	[2.81950E+04, 1.9281352350E+01, 5.3935729902E+00, 5.6071078272E+00, 2.4060758335E+00, 9.0075925301E-01],
	[2.82000E+04, 1.9286875119E+01, 5.3935412465E+00, 5.6103448338E+00, 2.4067513902E+00, 9.0080881544E-01],
	[2.82050E+04, 1.9292398490E+01, 5.3935095087E+00, 5.6135831348E+00, 2.4074268377E+00, 9.0085835394E-01],
	[2.82100E+04, 1.9297922464E+01, 5.3934777767E+00, 5.6168227304E+00, 2.4081021761E+00, 9.0090786852E-01],
	[2.82150E+04, 1.9303447039E+01, 5.3934460504E+00, 5.6200636209E+00, 2.4087774053E+00, 9.0095735920E-01],
	[2.82200E+04, 1.9308972217E+01, 5.3934143300E+00, 5.6233058067E+00, 2.4094525252E+00, 9.0100682598E-01],
	[2.82250E+04, 1.9314497997E+01, 5.3933826154E+00, 5.6265492880E+00, 2.4101275358E+00, 9.0105626888E-01],
	[2.82300E+04, 1.9320024380E+01, 5.3933509066E+00, 5.6297940650E+00, 2.4108024370E+00, 9.0110568791E-01],
	[2.82350E+04, 1.9325592502E+01, 5.3933254556E+00, 5.6330401382E+00, 2.4114791192E+00, 9.0115508306E-01],
	[2.82400E+04, 1.9331176766E+01, 5.3933023677E+00, 5.6362875077E+00, 2.4121564068E+00, 9.0120445436E-01],
	[2.82450E+04, 1.9336761655E+01, 5.3932792840E+00, 5.6395361739E+00, 2.4128335869E+00, 9.0125380182E-01],
	[2.82500E+04, 1.9342347168E+01, 5.3932562045E+00, 5.6427861370E+00, 2.4135106592E+00, 9.0130312544E-01],
	[2.82550E+04, 1.9347933305E+01, 5.3932331291E+00, 5.6460373973E+00, 2.4141876239E+00, 9.0135242523E-01],
	[2.82600E+04, 1.9353520067E+01, 5.3932100579E+00, 5.6492899552E+00, 2.4148644808E+00, 9.0140170121E-01],
	[2.82650E+04, 1.9359107453E+01, 5.3931869909E+00, 5.6525438109E+00, 2.4155412298E+00, 9.0145095338E-01],
	[2.82700E+04, 1.9364695464E+01, 5.3931639281E+00, 5.6557989647E+00, 2.4162178710E+00, 9.0150018175E-01],
	[2.82750E+04, 1.9370284099E+01, 5.3931408695E+00, 5.6590554168E+00, 2.4168944043E+00, 9.0154938634E-01],
	[2.82800E+04, 1.9375873358E+01, 5.3931178150E+00, 5.6623131677E+00, 2.4175708295E+00, 9.0159856715E-01],
	[2.82850E+04, 1.9381463241E+01, 5.3930947647E+00, 5.6655722175E+00, 2.4182471467E+00, 9.0164772420E-01],
	[2.82900E+04, 1.9387053749E+01, 5.3930717186E+00, 5.6688325666E+00, 2.4189233558E+00, 9.0169685748E-01],
	[2.82950E+04, 1.9392644881E+01, 5.3930486767E+00, 5.6720942151E+00, 2.4195994567E+00, 9.0174596702E-01],
	[2.83000E+04, 1.9398236637E+01, 5.3930256389E+00, 5.6753571636E+00, 2.4202754494E+00, 9.0179505283E-01],
	[2.83050E+04, 1.9403829017E+01, 5.3930026053E+00, 5.6786214121E+00, 2.4209513337E+00, 9.0184411491E-01],
	[2.83100E+04, 1.9409422021E+01, 5.3929795759E+00, 5.6818869610E+00, 2.4216271098E+00, 9.0189315327E-01],
	[2.83150E+04, 1.9415015649E+01, 5.3929565506E+00, 5.6851538107E+00, 2.4223027774E+00, 9.0194216792E-01],
	[2.83200E+04, 1.9420609901E+01, 5.3929335295E+00, 5.6884219613E+00, 2.4229783366E+00, 9.0199115888E-01],
	[2.83250E+04, 1.9426204777E+01, 5.3929105126E+00, 5.6916914132E+00, 2.4236537872E+00, 9.0204012615E-01],
	[2.83300E+04, 1.9431800276E+01, 5.3928874998E+00, 5.6949621666E+00, 2.4243291293E+00, 9.0208906974E-01],
	[2.83350E+04, 1.9437396400E+01, 5.3928644911E+00, 5.6982342219E+00, 2.4250043627E+00, 9.0213798966E-01],
	[2.83400E+04, 1.9442993147E+01, 5.3928414867E+00, 5.7015075793E+00, 2.4256794874E+00, 9.0218688593E-01],
	[2.83450E+04, 1.9448590518E+01, 5.3928184864E+00, 5.7047822392E+00, 2.4263545034E+00, 9.0223575855E-01],
	[2.83500E+04, 1.9454188513E+01, 5.3927954902E+00, 5.7080582017E+00, 2.4270294106E+00, 9.0228460753E-01],
	[2.83550E+04, 1.9459787131E+01, 5.3927724982E+00, 5.7113354672E+00, 2.4277042089E+00, 9.0233343288E-01],
	[2.83600E+04, 1.9465386373E+01, 5.3927495104E+00, 5.7146140361E+00, 2.4283788983E+00, 9.0238223461E-01],
	[2.83650E+04, 1.9470986239E+01, 5.3927265267E+00, 5.7178939085E+00, 2.4290534787E+00, 9.0243101272E-01],
	[2.83700E+04, 1.9476586728E+01, 5.3927035471E+00, 5.7211750848E+00, 2.4297279501E+00, 9.0247976722E-01],
	[2.83750E+04, 1.9482187841E+01, 5.3926805717E+00, 5.7244575652E+00, 2.4304023124E+00, 9.0252849813E-01],
	[2.83800E+04, 1.9487789577E+01, 5.3926576004E+00, 5.7277413500E+00, 2.4310765655E+00, 9.0257720545E-01],
	[2.83850E+04, 1.9493391936E+01, 5.3926346333E+00, 5.7310264396E+00, 2.4317507094E+00, 9.0262588919E-01],
	[2.83900E+04, 1.9498994919E+01, 5.3926116704E+00, 5.7343128342E+00, 2.4324247441E+00, 9.0267454936E-01],
	[2.83950E+04, 1.9504598526E+01, 5.3925887115E+00, 5.7376005342E+00, 2.4330986694E+00, 9.0272318596E-01],
	[2.84000E+04, 1.9510202755E+01, 5.3925657568E+00, 5.7408895397E+00, 2.4337724854E+00, 9.0277179901E-01],
	[2.84050E+04, 1.9515807608E+01, 5.3925428063E+00, 5.7441798511E+00, 2.4344461920E+00, 9.0282038851E-01],
	[2.84100E+04, 1.9521413084E+01, 5.3925198599E+00, 5.7474714686E+00, 2.4351197890E+00, 9.0286895447E-01],
	[2.84150E+04, 1.9527019183E+01, 5.3924969176E+00, 5.7507643926E+00, 2.4357932765E+00, 9.0291749690E-01],
	[2.84200E+04, 1.9532625905E+01, 5.3924739795E+00, 5.7540586234E+00, 2.4364666544E+00, 9.0296601581E-01],
	[2.84250E+04, 1.9538233251E+01, 5.3924510454E+00, 5.7573541612E+00, 2.4371399227E+00, 9.0301451121E-01],
	[2.84300E+04, 1.9543841219E+01, 5.3924281156E+00, 5.7606510064E+00, 2.4378130812E+00, 9.0306298311E-01],
	[2.84350E+04, 1.9549449811E+01, 5.3924051898E+00, 5.7639491591E+00, 2.4384861300E+00, 9.0311143150E-01],
	[2.84400E+04, 1.9555059025E+01, 5.3923822682E+00, 5.7672486197E+00, 2.4391590689E+00, 9.0315985641E-01],
	[2.84450E+04, 1.9560668863E+01, 5.3923593507E+00, 5.7705493886E+00, 2.4398318980E+00, 9.0320825785E-01],
	[2.84500E+04, 1.9566279323E+01, 5.3923364373E+00, 5.7738514659E+00, 2.4405046171E+00, 9.0325663581E-01],
	[2.84550E+04, 1.9571890406E+01, 5.3923135281E+00, 5.7771548520E+00, 2.4411772263E+00, 9.0330499031E-01],
	[2.84600E+04, 1.9577502112E+01, 5.3922906230E+00, 5.7804595471E+00, 2.4418497254E+00, 9.0335332136E-01],
	[2.84650E+04, 1.9583114441E+01, 5.3922677220E+00, 5.7837655516E+00, 2.4425221144E+00, 9.0340162896E-01],
	[2.84700E+04, 1.9588727392E+01, 5.3922448251E+00, 5.7870728657E+00, 2.4431943932E+00, 9.0344991312E-01],
	[2.84750E+04, 1.9594340967E+01, 5.3922219323E+00, 5.7903814898E+00, 2.4438665618E+00, 9.0349817386E-01],
	[2.84800E+04, 1.9599955163E+01, 5.3921990437E+00, 5.7936914240E+00, 2.4445386202E+00, 9.0354641118E-01],
	[2.84850E+04, 1.9605569983E+01, 5.3921761591E+00, 5.7970026688E+00, 2.4452105682E+00, 9.0359462509E-01],
	[2.84900E+04, 1.9611185425E+01, 5.3921532787E+00, 5.8003152243E+00, 2.4458824059E+00, 9.0364281560E-01],
	[2.84950E+04, 1.9616801489E+01, 5.3921304024E+00, 5.8036290909E+00, 2.4465541331E+00, 9.0369098272E-01],
	[2.85000E+04, 1.9622418176E+01, 5.3921075302E+00, 5.8069442689E+00, 2.4472257498E+00, 9.0373912645E-01],
	[2.85050E+04, 1.9628035486E+01, 5.3920846621E+00, 5.8102607586E+00, 2.4478972560E+00, 9.0378724680E-01],
	[2.85100E+04, 1.9633653418E+01, 5.3920617982E+00, 5.8135785602E+00, 2.4485686516E+00, 9.0383534379E-01],
	[2.85150E+04, 1.9639271972E+01, 5.3920389383E+00, 5.8168976740E+00, 2.4492399365E+00, 9.0388341742E-01],
	[2.85200E+04, 1.9644891149E+01, 5.3920160825E+00, 5.8202181003E+00, 2.4499111108E+00, 9.0393146770E-01],
	[2.85250E+04, 1.9650510947E+01, 5.3919932309E+00, 5.8235398395E+00, 2.4505821743E+00, 9.0397949463E-01],
	[2.85300E+04, 1.9656131369E+01, 5.3919703833E+00, 5.8268628917E+00, 2.4512531269E+00, 9.0402749824E-01],
	[2.85350E+04, 1.9661752412E+01, 5.3919475398E+00, 5.8301872573E+00, 2.4519239687E+00, 9.0407547852E-01],
	[2.85400E+04, 1.9667374077E+01, 5.3919247005E+00, 5.8335129366E+00, 2.4525946996E+00, 9.0412343548E-01],
	[2.85450E+04, 1.9672996365E+01, 5.3919018652E+00, 5.8368399299E+00, 2.4532653195E+00, 9.0417136914E-01],
	[2.85500E+04, 1.9678619275E+01, 5.3918790341E+00, 5.8401682374E+00, 2.4539358283E+00, 9.0421927950E-01],
	[2.85550E+04, 1.9684242806E+01, 5.3918562070E+00, 5.8434978595E+00, 2.4546062261E+00, 9.0426716657E-01],
	[2.85600E+04, 1.9689866960E+01, 5.3918333840E+00, 5.8468287964E+00, 2.4552765127E+00, 9.0431503036E-01],
	[2.85650E+04, 1.9695491736E+01, 5.3918105651E+00, 5.8501610484E+00, 2.4559466881E+00, 9.0436287088E-01],
	[2.85700E+04, 1.9701117134E+01, 5.3917877503E+00, 5.8534946159E+00, 2.4566167523E+00, 9.0441068814E-01],
	[2.85750E+04, 1.9706743153E+01, 5.3917649396E+00, 5.8568294990E+00, 2.4572867052E+00, 9.0445848214E-01],
	[2.85800E+04, 1.9712369795E+01, 5.3917421330E+00, 5.8601656981E+00, 2.4579565467E+00, 9.0450625289E-01],
	[2.85850E+04, 1.9717997058E+01, 5.3917193305E+00, 5.8635032135E+00, 2.4586262769E+00, 9.0455400041E-01],
	[2.85900E+04, 1.9723624943E+01, 5.3916965320E+00, 5.8668420455E+00, 2.4592958955E+00, 9.0460172470E-01],
	[2.85950E+04, 1.9729253450E+01, 5.3916737376E+00, 5.8701821943E+00, 2.4599654027E+00, 9.0464942577E-01],
	[2.86000E+04, 1.9734882578E+01, 5.3916509474E+00, 5.8735236602E+00, 2.4606347982E+00, 9.0469710362E-01],
	[2.86050E+04, 1.9740512328E+01, 5.3916281612E+00, 5.8768664436E+00, 2.4613040822E+00, 9.0474475828E-01],
	[2.86100E+04, 1.9746142700E+01, 5.3916053790E+00, 5.8802105447E+00, 2.4619732545E+00, 9.0479238974E-01],
	[2.86150E+04, 1.9751773693E+01, 5.3915826010E+00, 5.8835559639E+00, 2.4626423150E+00, 9.0483999802E-01],
	[2.86200E+04, 1.9757405308E+01, 5.3915598270E+00, 5.8869027013E+00, 2.4633112638E+00, 9.0488758312E-01],
	[2.86250E+04, 1.9763037544E+01, 5.3915370571E+00, 5.8902507573E+00, 2.4639801007E+00, 9.0493514505E-01],
	[2.86300E+04, 1.9768670402E+01, 5.3915142913E+00, 5.8936001322E+00, 2.4646488257E+00, 9.0498268383E-01],
	[2.86350E+04, 1.9774303881E+01, 5.3914915295E+00, 5.8969508262E+00, 2.4653174388E+00, 9.0503019945E-01],
	[2.86400E+04, 1.9779937981E+01, 5.3914687718E+00, 5.9003028397E+00, 2.4659859399E+00, 9.0507769194E-01],
	[2.86450E+04, 1.9785572703E+01, 5.3914460182E+00, 5.9036561730E+00, 2.4666543290E+00, 9.0512516129E-01],
	[2.86500E+04, 1.9791208046E+01, 5.3914232687E+00, 5.9070108263E+00, 2.4673226060E+00, 9.0517260752E-01],
	[2.86550E+04, 1.9796844010E+01, 5.3914005232E+00, 5.9103667999E+00, 2.4679907708E+00, 9.0522003063E-01],
	[2.86600E+04, 1.9802480596E+01, 5.3913777818E+00, 5.9137240941E+00, 2.4686588234E+00, 9.0526743064E-01],
	[2.86650E+04, 1.9808117803E+01, 5.3913550444E+00, 5.9170827092E+00, 2.4693267637E+00, 9.0531480755E-01],
	[2.86700E+04, 1.9813755630E+01, 5.3913323111E+00, 5.9204426455E+00, 2.4699945918E+00, 9.0536216138E-01],
	[2.86750E+04, 1.9819394079E+01, 5.3913095819E+00, 5.9238039033E+00, 2.4706623075E+00, 9.0540949212E-01],
	[2.86800E+04, 1.9825033149E+01, 5.3912868567E+00, 5.9271664829E+00, 2.4713299107E+00, 9.0545679979E-01],
	[2.86850E+04, 1.9830672840E+01, 5.3912641356E+00, 5.9305303845E+00, 2.4719974015E+00, 9.0550408441E-01],
	[2.86900E+04, 1.9836313152E+01, 5.3912414186E+00, 5.9338956084E+00, 2.4726647798E+00, 9.0555134596E-01],
	[2.86950E+04, 1.9841954085E+01, 5.3912187056E+00, 5.9372621550E+00, 2.4733320456E+00, 9.0559858448E-01],
	[2.87000E+04, 1.9847595639E+01, 5.3911959966E+00, 5.9406300245E+00, 2.4739991987E+00, 9.0564579996E-01],
	[2.87050E+04, 1.9853237814E+01, 5.3911732917E+00, 5.9439992173E+00, 2.4746662391E+00, 9.0569299241E-01],
	[2.87100E+04, 1.9858880609E+01, 5.3911505908E+00, 5.9473697335E+00, 2.4753331668E+00, 9.0574016185E-01],
	[2.87150E+04, 1.9864524025E+01, 5.3911278940E+00, 5.9507415736E+00, 2.4759999817E+00, 9.0578730828E-01],
	[2.87200E+04, 1.9870168062E+01, 5.3911052013E+00, 5.9541147377E+00, 2.4766666838E+00, 9.0583443171E-01],
	[2.87250E+04, 1.9875812720E+01, 5.3910825126E+00, 5.9574892262E+00, 2.4773332731E+00, 9.0588153214E-01],
	[2.87300E+04, 1.9881457998E+01, 5.3910598279E+00, 5.9608650393E+00, 2.4779997494E+00, 9.0592860960E-01],
	[2.87350E+04, 1.9887103897E+01, 5.3910371473E+00, 5.9642421774E+00, 2.4786661127E+00, 9.0597566408E-01],
	[2.87400E+04, 1.9892750416E+01, 5.3910144707E+00, 5.9676206408E+00, 2.4793323630E+00, 9.0602269560E-01],
	[2.87450E+04, 1.9898397556E+01, 5.3909917982E+00, 5.9710004296E+00, 2.4799985002E+00, 9.0606970416E-01],
	[2.87500E+04, 1.9904045317E+01, 5.3909691297E+00, 5.9743815443E+00, 2.4806645242E+00, 9.0611668978E-01],
	[2.87550E+04, 1.9909693698E+01, 5.3909464652E+00, 5.9777639851E+00, 2.4813304351E+00, 9.0616365246E-01],
	[2.87600E+04, 1.9915342699E+01, 5.3909238048E+00, 5.9811477523E+00, 2.4819962327E+00, 9.0621059221E-01],
	[2.87650E+04, 1.9920992321E+01, 5.3909011484E+00, 5.9845328462E+00, 2.4826619171E+00, 9.0625750904E-01],
	[2.87700E+04, 1.9926642563E+01, 5.3908784960E+00, 5.9879192670E+00, 2.4833274881E+00, 9.0630440296E-01],
	[2.87750E+04, 1.9932293425E+01, 5.3908558477E+00, 5.9913070152E+00, 2.4839929458E+00, 9.0635127398E-01],
	[2.87800E+04, 1.9937944908E+01, 5.3908332034E+00, 5.9946960908E+00, 2.4846582899E+00, 9.0639812210E-01],
	[2.87850E+04, 1.9943597011E+01, 5.3908105631E+00, 5.9980864944E+00, 2.4853235206E+00, 9.0644494735E-01],
	[2.87900E+04, 1.9949249734E+01, 5.3907879269E+00, 6.0014782260E+00, 2.4859886378E+00, 9.0649174971E-01],
	[2.87950E+04, 1.9954903077E+01, 5.3907652947E+00, 6.0048712861E+00, 2.4866536414E+00, 9.0653852922E-01],
	[2.88000E+04, 1.9960557040E+01, 5.3907426665E+00, 6.0082656749E+00, 2.4873185313E+00, 9.0658528586E-01],
	[2.88050E+04, 1.9966211623E+01, 5.3907200423E+00, 6.0116613927E+00, 2.4879833075E+00, 9.0663201966E-01],
	[2.88100E+04, 1.9971866826E+01, 5.3906974222E+00, 6.0150584398E+00, 2.4886479700E+00, 9.0667873061E-01],
	[2.88150E+04, 1.9977522650E+01, 5.3906748060E+00, 6.0184568164E+00, 2.4893125188E+00, 9.0672541874E-01],
	[2.88200E+04, 1.9983179093E+01, 5.3906521939E+00, 6.0218565230E+00, 2.4899769536E+00, 9.0677208405E-01],
	[2.88250E+04, 1.9988836156E+01, 5.3906295858E+00, 6.0252575596E+00, 2.4906412746E+00, 9.0681872654E-01],
	[2.88300E+04, 1.9994493839E+01, 5.3906069818E+00, 6.0286599268E+00, 2.4913054816E+00, 9.0686534623E-01],
	[2.88350E+04, 2.0000152142E+01, 5.3905843817E+00, 6.0320636247E+00, 2.4919695747E+00, 9.0691194313E-01],
	[2.88400E+04, 2.0005811064E+01, 5.3905617857E+00, 6.0354686536E+00, 2.4926335537E+00, 9.0695851724E-01],
	[2.88450E+04, 2.0011470606E+01, 5.3905391936E+00, 6.0388750138E+00, 2.4932974186E+00, 9.0700506858E-01],
	[2.88500E+04, 2.0017130768E+01, 5.3905166056E+00, 6.0422827057E+00, 2.4939611693E+00, 9.0705159715E-01],
	[2.88550E+04, 2.0022791550E+01, 5.3904940216E+00, 6.0456917294E+00, 2.4946248059E+00, 9.0709810296E-01],
	[2.88600E+04, 2.0028452951E+01, 5.3904714416E+00, 6.0491020853E+00, 2.4952883283E+00, 9.0714458602E-01],
	[2.88650E+04, 2.0034114972E+01, 5.3904488656E+00, 6.0525137737E+00, 2.4959517363E+00, 9.0719104634E-01],
	[2.88700E+04, 2.0039777612E+01, 5.3904262936E+00, 6.0559267949E+00, 2.4966150300E+00, 9.0723748393E-01],
	[2.88750E+04, 2.0045440872E+01, 5.3904037256E+00, 6.0593411491E+00, 2.4972782094E+00, 9.0728389880E-01],
	[2.88800E+04, 2.0051104752E+01, 5.3903811616E+00, 6.0627568367E+00, 2.4979412743E+00, 9.0733029096E-01],
	[2.88850E+04, 2.0056769250E+01, 5.3903586016E+00, 6.0661738579E+00, 2.4986042247E+00, 9.0737666041E-01],
	[2.88900E+04, 2.0062434368E+01, 5.3903360456E+00, 6.0695922131E+00, 2.4992670605E+00, 9.0742300716E-01],
	[2.88950E+04, 2.0068100106E+01, 5.3903134936E+00, 6.0730119024E+00, 2.4999297818E+00, 9.0746933124E-01],
	[2.89000E+04, 2.0073766463E+01, 5.3902909456E+00, 6.0764329263E+00, 2.5005923885E+00, 9.0751563263E-01],
	[2.89050E+04, 2.0079433439E+01, 5.3902684016E+00, 6.0798552849E+00, 2.5012548805E+00, 9.0756191136E-01],
	[2.89100E+04, 2.0085101034E+01, 5.3902458616E+00, 6.0832789787E+00, 2.5019172577E+00, 9.0760816743E-01],
	[2.89150E+04, 2.0090769248E+01, 5.3902233256E+00, 6.0867040078E+00, 2.5025795202E+00, 9.0765440084E-01],
	[2.89200E+04, 2.0096438082E+01, 5.3902007936E+00, 6.0901303726E+00, 2.5032416678E+00, 9.0770061162E-01],
	[2.89250E+04, 2.0102107535E+01, 5.3901782655E+00, 6.0935580733E+00, 2.5039037006E+00, 9.0774679977E-01],
	[2.89300E+04, 2.0107777606E+01, 5.3901557415E+00, 6.0969871103E+00, 2.5045656185E+00, 9.0779296529E-01],
	[2.89350E+04, 2.0113448297E+01, 5.3901332214E+00, 6.1004174838E+00, 2.5052274213E+00, 9.0783910821E-01],
	[2.89400E+04, 2.0119119607E+01, 5.3901107053E+00, 6.1038491941E+00, 2.5058891092E+00, 9.0788522851E-01],
	[2.89450E+04, 2.0124791536E+01, 5.3900881932E+00, 6.1072822416E+00, 2.5065506820E+00, 9.0793132623E-01],
	[2.89500E+04, 2.0130464083E+01, 5.3900656851E+00, 6.1107166264E+00, 2.5072121397E+00, 9.0797740135E-01],
	[2.89550E+04, 2.0136137250E+01, 5.3900431810E+00, 6.1141523490E+00, 2.5078734822E+00, 9.0802345390E-01],
	[2.89600E+04, 2.0141811035E+01, 5.3900206809E+00, 6.1175894095E+00, 2.5085347095E+00, 9.0806948389E-01],
	[2.89650E+04, 2.0147485439E+01, 5.3899981847E+00, 6.1210278083E+00, 2.5091958215E+00, 9.0811549131E-01],
	[2.89700E+04, 2.0153160462E+01, 5.3899756925E+00, 6.1244675456E+00, 2.5098568183E+00, 9.0816147618E-01],
	[2.89750E+04, 2.0158836104E+01, 5.3899532043E+00, 6.1279086219E+00, 2.5105176996E+00, 9.0820743852E-01],
	[2.89800E+04, 2.0164512364E+01, 5.3899307200E+00, 6.1313510372E+00, 2.5111784656E+00, 9.0825337832E-01],
	[2.89850E+04, 2.0170189243E+01, 5.3899082397E+00, 6.1347947920E+00, 2.5118391161E+00, 9.0829929560E-01],
	[2.89900E+04, 2.0175866740E+01, 5.3898857634E+00, 6.1382398865E+00, 2.5124996512E+00, 9.0834519037E-01],
	[2.89950E+04, 2.0181544856E+01, 5.3898632911E+00, 6.1416863211E+00, 2.5131600706E+00, 9.0839106263E-01],
	[2.90000E+04, 2.0187223591E+01, 5.3898408228E+00, 6.1451340959E+00, 2.5138203745E+00, 9.0843691240E-01],
	[2.90050E+04, 2.0192902944E+01, 5.3898183584E+00, 6.1485832113E+00, 2.5144805628E+00, 9.0848273969E-01],
	[2.90100E+04, 2.0198582915E+01, 5.3897958979E+00, 6.1520336676E+00, 2.5151406353E+00, 9.0852854450E-01],
	[2.90150E+04, 2.0204263505E+01, 5.3897734415E+00, 6.1554854651E+00, 2.5158005922E+00, 9.0857432684E-01],
	[2.90200E+04, 2.0209944713E+01, 5.3897509890E+00, 6.1589386040E+00, 2.5164604332E+00, 9.0862008672E-01],
	[2.90250E+04, 2.0215626540E+01, 5.3897285404E+00, 6.1623930847E+00, 2.5171201584E+00, 9.0866582415E-01],
	[2.90300E+04, 2.0221308985E+01, 5.3897060958E+00, 6.1658489075E+00, 2.5177797678E+00, 9.0871153915E-01],
	[2.90350E+04, 2.0226992048E+01, 5.3896836552E+00, 6.1693060726E+00, 2.5184392612E+00, 9.0875723171E-01],
	[2.90400E+04, 2.0232675729E+01, 5.3896612186E+00, 6.1727645802E+00, 2.5190986386E+00, 9.0880290186E-01],
	[2.90450E+04, 2.0238360028E+01, 5.3896387858E+00, 6.1762244309E+00, 2.5197579001E+00, 9.0884854959E-01],
	[2.90500E+04, 2.0244044946E+01, 5.3896163571E+00, 6.1796856247E+00, 2.5204170454E+00, 9.0889417491E-01],
	[2.90550E+04, 2.0249730482E+01, 5.3895939323E+00, 6.1831481620E+00, 2.5210760747E+00, 9.0893977785E-01],
	[2.90600E+04, 2.0255416635E+01, 5.3895715114E+00, 6.1866120431E+00, 2.5217349878E+00, 9.0898535840E-01],
	[2.90650E+04, 2.0261103407E+01, 5.3895490945E+00, 6.1900772682E+00, 2.5223937847E+00, 9.0903091657E-01],
	[2.90700E+04, 2.0266790797E+01, 5.3895266816E+00, 6.1935438378E+00, 2.5230524654E+00, 9.0907645238E-01],
	[2.90750E+04, 2.0272478804E+01, 5.3895042726E+00, 6.1970117520E+00, 2.5237110298E+00, 9.0912196583E-01],
	[2.90800E+04, 2.0278167430E+01, 5.3894818675E+00, 6.2004810111E+00, 2.5243694778E+00, 9.0916745694E-01],
	[2.90850E+04, 2.0283856673E+01, 5.3894594664E+00, 6.2039516154E+00, 2.5250278094E+00, 9.0921292570E-01],
	[2.90900E+04, 2.0289546534E+01, 5.3894370693E+00, 6.2074235653E+00, 2.5256860246E+00, 9.0925837214E-01],
	[2.90950E+04, 2.0295237013E+01, 5.3894146761E+00, 6.2108968610E+00, 2.5263441234E+00, 9.0930379626E-01],
	[2.91000E+04, 2.0300928109E+01, 5.3893922868E+00, 6.2143715029E+00, 2.5270021056E+00, 9.0934919806E-01],
	[2.91050E+04, 2.0306619824E+01, 5.3893699014E+00, 6.2178474911E+00, 2.5276599712E+00, 9.0939457757E-01],
	[2.91100E+04, 2.0312312156E+01, 5.3893475200E+00, 6.2213248260E+00, 2.5283177202E+00, 9.0943993478E-01],
	[2.91150E+04, 2.0318005105E+01, 5.3893251426E+00, 6.2248035078E+00, 2.5289753526E+00, 9.0948526971E-01],
	[2.91200E+04, 2.0323698672E+01, 5.3893027690E+00, 6.2282835370E+00, 2.5296328682E+00, 9.0953058237E-01],
	[2.91250E+04, 2.0329392857E+01, 5.3892803994E+00, 6.2317649137E+00, 2.5302902671E+00, 9.0957587276E-01],
	[2.91300E+04, 2.0335087659E+01, 5.3892580338E+00, 6.2352476382E+00, 2.5309475492E+00, 9.0962114089E-01],
	[2.91350E+04, 2.0340783079E+01, 5.3892356720E+00, 6.2387317109E+00, 2.5316047145E+00, 9.0966638678E-01],
	[2.91400E+04, 2.0346479116E+01, 5.3892133142E+00, 6.2422171320E+00, 2.5322617629E+00, 9.0971161043E-01],
	[2.91450E+04, 2.0352175770E+01, 5.3891909604E+00, 6.2457039018E+00, 2.5329186943E+00, 9.0975681186E-01],
	[2.91500E+04, 2.0357873042E+01, 5.3891686104E+00, 6.2491920206E+00, 2.5335755088E+00, 9.0980199107E-01],
	[2.91550E+04, 2.0363570931E+01, 5.3891462644E+00, 6.2526814888E+00, 2.5342322062E+00, 9.0984714807E-01],
	[2.91600E+04, 2.0369269438E+01, 5.3891239223E+00, 6.2561723065E+00, 2.5348887866E+00, 9.0989228287E-01],
	[2.91650E+04, 2.0374968561E+01, 5.3891015841E+00, 6.2596644741E+00, 2.5355452498E+00, 9.0993739547E-01],
	[2.91700E+04, 2.0380668302E+01, 5.3890792499E+00, 6.2631579919E+00, 2.5362015959E+00, 9.0998248590E-01],
	[2.91750E+04, 2.0386368660E+01, 5.3890569195E+00, 6.2666528601E+00, 2.5368578248E+00, 9.1002755416E-01],
	[2.91800E+04, 2.0392069635E+01, 5.3890345931E+00, 6.2701490791E+00, 2.5375139364E+00, 9.1007260025E-01],
	[2.91850E+04, 2.0397771227E+01, 5.3890122706E+00, 6.2736466491E+00, 2.5381699308E+00, 9.1011762419E-01],
	[2.91900E+04, 2.0403473436E+01, 5.3889899521E+00, 6.2771455705E+00, 2.5388258078E+00, 9.1016262599E-01],
	[2.91950E+04, 2.0409176262E+01, 5.3889676374E+00, 6.2806458435E+00, 2.5394815674E+00, 9.1020760565E-01],
	[2.92000E+04, 2.0414879705E+01, 5.3889453266E+00, 6.2841474684E+00, 2.5401372096E+00, 9.1025256318E-01],
	[2.92050E+04, 2.0420583765E+01, 5.3889230198E+00, 6.2876504455E+00, 2.5407927343E+00, 9.1029749860E-01],
	[2.92100E+04, 2.0426288442E+01, 5.3889007169E+00, 6.2911547751E+00, 2.5414481415E+00, 9.1034241192E-01],
	[2.92150E+04, 2.0431993735E+01, 5.3888784179E+00, 6.2946604575E+00, 2.5421034312E+00, 9.1038730313E-01],
	[2.92200E+04, 2.0437699646E+01, 5.3888561228E+00, 6.2981674929E+00, 2.5427586033E+00, 9.1043217226E-01],
	[2.92250E+04, 2.0443406173E+01, 5.3888338316E+00, 6.3016758817E+00, 2.5434136577E+00, 9.1047701931E-01],
	[2.92300E+04, 2.0449113317E+01, 5.3888115443E+00, 6.3051856242E+00, 2.5440685944E+00, 9.1052184429E-01],
	[2.92350E+04, 2.0454821078E+01, 5.3887892609E+00, 6.3086967206E+00, 2.5447234133E+00, 9.1056664721E-01],
	[2.92400E+04, 2.0460529455E+01, 5.3887669814E+00, 6.3122091713E+00, 2.5453781145E+00, 9.1061142808E-01],
	[2.92450E+04, 2.0466238449E+01, 5.3887447058E+00, 6.3157229765E+00, 2.5460326979E+00, 9.1065618690E-01],
	[2.92500E+04, 2.0471948059E+01, 5.3887224341E+00, 6.3192381365E+00, 2.5466871634E+00, 9.1070092370E-01],
	[2.92550E+04, 2.0477658286E+01, 5.3887001663E+00, 6.3227546516E+00, 2.5473415110E+00, 9.1074563847E-01],
	[2.92600E+04, 2.0483369129E+01, 5.3886779024E+00, 6.3262725222E+00, 2.5479957406E+00, 9.1079033123E-01],
	[2.92650E+04, 2.0489080589E+01, 5.3886556424E+00, 6.3297917484E+00, 2.5486498523E+00, 9.1083500199E-01],
	[2.92700E+04, 2.0494792666E+01, 5.3886333863E+00, 6.3333123306E+00, 2.5493038459E+00, 9.1087965075E-01],
	[2.92750E+04, 2.0500505358E+01, 5.3886111341E+00, 6.3368342691E+00, 2.5499577214E+00, 9.1092427752E-01],
	[2.92800E+04, 2.0506218667E+01, 5.3885888858E+00, 6.3403575641E+00, 2.5506114788E+00, 9.1096888232E-01],
	[2.92850E+04, 2.0511932592E+01, 5.3885666414E+00, 6.3438822160E+00, 2.5512651180E+00, 9.1101346515E-01],
	[2.92900E+04, 2.0517647134E+01, 5.3885444009E+00, 6.3474082250E+00, 2.5519186390E+00, 9.1105802603E-01],
	[2.92950E+04, 2.0523362292E+01, 5.3885221642E+00, 6.3509355915E+00, 2.5525720418E+00, 9.1110256496E-01],
	[2.93000E+04, 2.0529078066E+01, 5.3884999315E+00, 6.3544643157E+00, 2.5532253262E+00, 9.1114708195E-01],
	[2.93050E+04, 2.0534794456E+01, 5.3884777026E+00, 6.3579943979E+00, 2.5538784923E+00, 9.1119157701E-01],
	[2.93100E+04, 2.0540511462E+01, 5.3884554776E+00, 6.3615258384E+00, 2.5545315400E+00, 9.1123605015E-01],
	[2.93150E+04, 2.0546229084E+01, 5.3884332565E+00, 6.3650586375E+00, 2.5551844693E+00, 9.1128050138E-01],
	[2.93200E+04, 2.0551947322E+01, 5.3884110393E+00, 6.3685927955E+00, 2.5558372801E+00, 9.1132493070E-01],
	[2.93250E+04, 2.0557666176E+01, 5.3883888259E+00, 6.3721283127E+00, 2.5564899724E+00, 9.1136933814E-01],
	[2.93300E+04, 2.0563385646E+01, 5.3883666165E+00, 6.3756651894E+00, 2.5571425462E+00, 9.1141372370E-01],
	[2.93350E+04, 2.0569105732E+01, 5.3883444109E+00, 6.3792034258E+00, 2.5577950013E+00, 9.1145808738E-01],
	[2.93400E+04, 2.0574826434E+01, 5.3883222092E+00, 6.3827430223E+00, 2.5584473378E+00, 9.1150242920E-01],
	[2.93450E+04, 2.0580547752E+01, 5.3883000113E+00, 6.3862839791E+00, 2.5590995556E+00, 9.1154674916E-01],
	[2.93500E+04, 2.0586269686E+01, 5.3882778173E+00, 6.3898262966E+00, 2.5597516547E+00, 9.1159104728E-01],
	[2.93550E+04, 2.0591992235E+01, 5.3882556273E+00, 6.3933699749E+00, 2.5604036351E+00, 9.1163532357E-01],
	[2.93600E+04, 2.0597744140E+01, 5.3882376839E+00, 6.3969150145E+00, 2.5610568994E+00, 9.1167957802E-01],
	[2.93650E+04, 2.0603524036E+01, 5.3882237823E+00, 6.4004614156E+00, 2.5617113817E+00, 9.1172381067E-01],
	[2.93700E+04, 2.0609304571E+01, 5.3882098831E+00, 6.4040091785E+00, 2.5623657470E+00, 9.1176802150E-01],
	[2.93750E+04, 2.0615085742E+01, 5.3881959864E+00, 6.4075583035E+00, 2.5630199953E+00, 9.1181221054E-01],
	[2.93800E+04, 2.0620867551E+01, 5.3881820920E+00, 6.4111087909E+00, 2.5636741264E+00, 9.1185637779E-01],
	[2.93850E+04, 2.0626649997E+01, 5.3881682000E+00, 6.4146606410E+00, 2.5643281403E+00, 9.1190052326E-01],
	[2.93900E+04, 2.0632433080E+01, 5.3881543105E+00, 6.4182138540E+00, 2.5649820370E+00, 9.1194464696E-01],
	[2.93950E+04, 2.0638216801E+01, 5.3881404233E+00, 6.4217684302E+00, 2.5656358165E+00, 9.1198874890E-01],
	[2.94000E+04, 2.0644001158E+01, 5.3881265385E+00, 6.4253243700E+00, 2.5662894787E+00, 9.1203282909E-01],
	[2.94050E+04, 2.0649786153E+01, 5.3881126561E+00, 6.4288816737E+00, 2.5669430235E+00, 9.1207688754E-01],
	[2.94100E+04, 2.0655571785E+01, 5.3880987762E+00, 6.4324403414E+00, 2.5675964510E+00, 9.1212092426E-01],
	[2.94150E+04, 2.0661358054E+01, 5.3880848986E+00, 6.4360003736E+00, 2.5682497610E+00, 9.1216493926E-01],
	[2.94200E+04, 2.0667144960E+01, 5.3880710234E+00, 6.4395617705E+00, 2.5689029536E+00, 9.1220893254E-01],
	[2.94250E+04, 2.0672932503E+01, 5.3880571506E+00, 6.4431245324E+00, 2.5695560287E+00, 9.1225290412E-01],
	[2.94300E+04, 2.0678720683E+01, 5.3880432802E+00, 6.4466886596E+00, 2.5702089862E+00, 9.1229685401E-01],
	[2.94350E+04, 2.0684509500E+01, 5.3880294122E+00, 6.4502541523E+00, 2.5708618261E+00, 9.1234078221E-01],
	[2.94400E+04, 2.0690298954E+01, 5.3880155465E+00, 6.4538210110E+00, 2.5715145485E+00, 9.1238468873E-01],
	[2.94450E+04, 2.0696089045E+01, 5.3880016833E+00, 6.4573892358E+00, 2.5721671531E+00, 9.1242857359E-01],
	[2.94500E+04, 2.0701879772E+01, 5.3879878225E+00, 6.4609588270E+00, 2.5728196400E+00, 9.1247243680E-01],
	[2.94550E+04, 2.0707671136E+01, 5.3879739640E+00, 6.4645297850E+00, 2.5734720092E+00, 9.1251627836E-01],
	[2.94600E+04, 2.0713463137E+01, 5.3879601080E+00, 6.4681021101E+00, 2.5741242606E+00, 9.1256009828E-01],
	[2.94650E+04, 2.0719255775E+01, 5.3879462543E+00, 6.4716758024E+00, 2.5747763942E+00, 9.1260389657E-01],
	[2.94700E+04, 2.0725049049E+01, 5.3879324030E+00, 6.4752508624E+00, 2.5754284099E+00, 9.1264767325E-01],
	[2.94750E+04, 2.0730842960E+01, 5.3879185541E+00, 6.4788272903E+00, 2.5760803076E+00, 9.1269142831E-01],
	[2.94800E+04, 2.0736637507E+01, 5.3879047076E+00, 6.4824050864E+00, 2.5767320874E+00, 9.1273516178E-01],
	[2.94850E+04, 2.0742432691E+01, 5.3878908634E+00, 6.4859842510E+00, 2.5773837492E+00, 9.1277887366E-01],
	[2.94900E+04, 2.0748228512E+01, 5.3878770217E+00, 6.4895647844E+00, 2.5780352930E+00, 9.1282256396E-01],
	[2.94950E+04, 2.0754024968E+01, 5.3878631823E+00, 6.4931466869E+00, 2.5786867187E+00, 9.1286623268E-01],
	[2.95000E+04, 2.0759822062E+01, 5.3878493453E+00, 6.4967299587E+00, 2.5793380262E+00, 9.1290987985E-01],
	[2.95050E+04, 2.0765619791E+01, 5.3878355107E+00, 6.5003146002E+00, 2.5799892156E+00, 9.1295350546E-01],
	[2.95100E+04, 2.0771418157E+01, 5.3878216785E+00, 6.5039006116E+00, 2.5806402868E+00, 9.1299710953E-01],
	[2.95150E+04, 2.0777217160E+01, 5.3878078486E+00, 6.5074879933E+00, 2.5812912398E+00, 9.1304069207E-01],
	[2.95200E+04, 2.0783016798E+01, 5.3877940211E+00, 6.5110767455E+00, 2.5819420745E+00, 9.1308425308E-01],
	[2.95250E+04, 2.0788817073E+01, 5.3877801961E+00, 6.5146668685E+00, 2.5825927908E+00, 9.1312779258E-01],
	[2.95300E+04, 2.0794617984E+01, 5.3877663733E+00, 6.5182583627E+00, 2.5832433888E+00, 9.1317131058E-01],
	[2.95350E+04, 2.0800419531E+01, 5.3877525530E+00, 6.5218512282E+00, 2.5838938684E+00, 9.1321480708E-01],
	[2.95400E+04, 2.0806221715E+01, 5.3877387350E+00, 6.5254454655E+00, 2.5845442295E+00, 9.1325828209E-01],
	[2.95450E+04, 2.0812024534E+01, 5.3877249194E+00, 6.5290410747E+00, 2.5851944722E+00, 9.1330173563E-01],
	[2.95500E+04, 2.0817827989E+01, 5.3877111062E+00, 6.5326380562E+00, 2.5858445963E+00, 9.1334516770E-01],
	[2.95550E+04, 2.0823632081E+01, 5.3876972954E+00, 6.5362364103E+00, 2.5864946018E+00, 9.1338857832E-01],
	[2.95600E+04, 2.0829436808E+01, 5.3876834869E+00, 6.5398361373E+00, 2.5871444888E+00, 9.1343196749E-01],
	[2.95650E+04, 2.0835242171E+01, 5.3876696808E+00, 6.5434372374E+00, 2.5877942571E+00, 9.1347533522E-01],
	[2.95700E+04, 2.0841048170E+01, 5.3876558770E+00, 6.5470397110E+00, 2.5884439067E+00, 9.1351868152E-01],
	[2.95750E+04, 2.0846854805E+01, 5.3876420757E+00, 6.5506435583E+00, 2.5890934376E+00, 9.1356200640E-01],
	[2.95800E+04, 2.0852662076E+01, 5.3876282767E+00, 6.5542487796E+00, 2.5897428498E+00, 9.1360530987E-01],
	[2.95850E+04, 2.0858469983E+01, 5.3876144800E+00, 6.5578553752E+00, 2.5903921431E+00, 9.1364859195E-01],
	[2.95900E+04, 2.0864278525E+01, 5.3876006858E+00, 6.5614633455E+00, 2.5910413176E+00, 9.1369185263E-01],
	[2.95950E+04, 2.0870087703E+01, 5.3875868939E+00, 6.5650726906E+00, 2.5916903732E+00, 9.1373509193E-01],
	[2.96000E+04, 2.0875897517E+01, 5.3875731044E+00, 6.5686834110E+00, 2.5923393099E+00, 9.1377830986E-01],
	[2.96050E+04, 2.0881707966E+01, 5.3875593172E+00, 6.5722955068E+00, 2.5929881276E+00, 9.1382150643E-01],
	[2.96100E+04, 2.0887519051E+01, 5.3875455324E+00, 6.5759089785E+00, 2.5936368264E+00, 9.1386468165E-01],
	[2.96150E+04, 2.0893330772E+01, 5.3875317499E+00, 6.5795238262E+00, 2.5942854061E+00, 9.1390783552E-01],
	[2.96200E+04, 2.0899143128E+01, 5.3875179699E+00, 6.5831400502E+00, 2.5949338667E+00, 9.1395096806E-01],
	[2.96250E+04, 2.0904956119E+01, 5.3875041921E+00, 6.5867576509E+00, 2.5955822082E+00, 9.1399407928E-01],
	[2.96300E+04, 2.0910769746E+01, 5.3874904168E+00, 6.5903766286E+00, 2.5962304305E+00, 9.1403716918E-01],
	[2.96350E+04, 2.0916584008E+01, 5.3874766438E+00, 6.5939969835E+00, 2.5968785337E+00, 9.1408023778E-01],
	[2.96400E+04, 2.0922398906E+01, 5.3874628731E+00, 6.5976187159E+00, 2.5975265176E+00, 9.1412328508E-01],
	[2.96450E+04, 2.0928214439E+01, 5.3874491049E+00, 6.6012418261E+00, 2.5981743822E+00, 9.1416631110E-01],
	[2.96500E+04, 2.0934030607E+01, 5.3874353389E+00, 6.6048663145E+00, 2.5988221275E+00, 9.1420931584E-01],
	[2.96550E+04, 2.0939847410E+01, 5.3874215754E+00, 6.6084921812E+00, 2.5994697535E+00, 9.1425229931E-01],
	[2.96600E+04, 2.0945664849E+01, 5.3874078142E+00, 6.6121194267E+00, 2.6001172601E+00, 9.1429526153E-01],
	[2.96650E+04, 2.0951482923E+01, 5.3873940553E+00, 6.6157480511E+00, 2.6007646473E+00, 9.1433820250E-01],
	[2.96700E+04, 2.0957301632E+01, 5.3873802988E+00, 6.6193780548E+00, 2.6014119150E+00, 9.1438112223E-01],
	[2.96750E+04, 2.0963120976E+01, 5.3873665446E+00, 6.6230094381E+00, 2.6020590632E+00, 9.1442402073E-01],
	[2.96800E+04, 2.0968940955E+01, 5.3873527928E+00, 6.6266422012E+00, 2.6027060918E+00, 9.1446689802E-01],
	[2.96850E+04, 2.0974761569E+01, 5.3873390434E+00, 6.6302763445E+00, 2.6033530009E+00, 9.1450975409E-01],
	[2.96900E+04, 2.0980582818E+01, 5.3873252963E+00, 6.6339118683E+00, 2.6039997904E+00, 9.1455258897E-01],
	[2.96950E+04, 2.0986404702E+01, 5.3873115516E+00, 6.6375487727E+00, 2.6046464602E+00, 9.1459540266E-01],
	[2.97000E+04, 2.0992227221E+01, 5.3872978092E+00, 6.6411870582E+00, 2.6052930103E+00, 9.1463819516E-01],
	[2.97050E+04, 2.0998050375E+01, 5.3872840691E+00, 6.6448267251E+00, 2.6059394407E+00, 9.1468096650E-01],
	[2.97100E+04, 2.1003874163E+01, 5.3872703314E+00, 6.6484677735E+00, 2.6065857513E+00, 9.1472371667E-01],
	[2.97150E+04, 2.1009698587E+01, 5.3872565961E+00, 6.6521102038E+00, 2.6072319421E+00, 9.1476644569E-01],
	[2.97200E+04, 2.1015523645E+01, 5.3872428630E+00, 6.6557540164E+00, 2.6078780130E+00, 9.1480915357E-01],
	[2.97250E+04, 2.1021349338E+01, 5.3872291324E+00, 6.6593992114E+00, 2.6085239641E+00, 9.1485184031E-01],
	[2.97300E+04, 2.1027175665E+01, 5.3872154041E+00, 6.6630457892E+00, 2.6091697952E+00, 9.1489450594E-01],
	[2.97350E+04, 2.1033002627E+01, 5.3872016781E+00, 6.6666937501E+00, 2.6098155064E+00, 9.1493715044E-01],
	[2.97400E+04, 2.1038830224E+01, 5.3871879545E+00, 6.6703430943E+00, 2.6104610976E+00, 9.1497977384E-01],
	[2.97450E+04, 2.1044658456E+01, 5.3871742332E+00, 6.6739938222E+00, 2.6111065688E+00, 9.1502237614E-01],
	[2.97500E+04, 2.1050487322E+01, 5.3871605142E+00, 6.6776459340E+00, 2.6117519199E+00, 9.1506495735E-01],
	[2.97550E+04, 2.1056316822E+01, 5.3871467976E+00, 6.6812994301E+00, 2.6123971509E+00, 9.1510751747E-01],
	[2.97600E+04, 2.1062146957E+01, 5.3871330833E+00, 6.6849543107E+00, 2.6130422617E+00, 9.1515005653E-01],
	[2.97650E+04, 2.1067977726E+01, 5.3871193714E+00, 6.6886105762E+00, 2.6136872524E+00, 9.1519257451E-01],
	[2.97700E+04, 2.1073809130E+01, 5.3871056618E+00, 6.6922682267E+00, 2.6143321228E+00, 9.1523507144E-01],
	[2.97750E+04, 2.1079641168E+01, 5.3870919546E+00, 6.6959272627E+00, 2.6149768730E+00, 9.1527754731E-01],
	[2.97800E+04, 2.1085473840E+01, 5.3870782496E+00, 6.6995876843E+00, 2.6156215029E+00, 9.1532000215E-01],
	[2.97850E+04, 2.1091307146E+01, 5.3870645471E+00, 6.7032494919E+00, 2.6162660125E+00, 9.1536243595E-01],
	[2.97900E+04, 2.1097141087E+01, 5.3870508468E+00, 6.7069126859E+00, 2.6169104017E+00, 9.1540484873E-01],
	[2.97950E+04, 2.1102975662E+01, 5.3870371489E+00, 6.7105772664E+00, 2.6175546705E+00, 9.1544724049E-01],
	[2.98000E+04, 2.1108810871E+01, 5.3870234533E+00, 6.7142432337E+00, 2.6181988188E+00, 9.1548961125E-01],
	[2.98050E+04, 2.1114646715E+01, 5.3870097601E+00, 6.7179105883E+00, 2.6188428467E+00, 9.1553196100E-01],
	[2.98100E+04, 2.1120483192E+01, 5.3869960692E+00, 6.7215793302E+00, 2.6194867541E+00, 9.1557428976E-01],
	[2.98150E+04, 2.1126320303E+01, 5.3869823806E+00, 6.7252494599E+00, 2.6201305409E+00, 9.1561659754E-01],
	[2.98200E+04, 2.1132158049E+01, 5.3869686943E+00, 6.7289209777E+00, 2.6207742071E+00, 9.1565888435E-01],
	[2.98250E+04, 2.1137996428E+01, 5.3869550104E+00, 6.7325938838E+00, 2.6214177527E+00, 9.1570115019E-01],
	[2.98300E+04, 2.1143835441E+01, 5.3869413288E+00, 6.7362681785E+00, 2.6220611777E+00, 9.1574339507E-01],
	[2.98350E+04, 2.1149675088E+01, 5.3869276495E+00, 6.7399438621E+00, 2.6227044819E+00, 9.1578561900E-01],
	[2.98400E+04, 2.1155515369E+01, 5.3869139726E+00, 6.7436209349E+00, 2.6233476655E+00, 9.1582782199E-01],
	[2.98450E+04, 2.1161356284E+01, 5.3869002980E+00, 6.7472993972E+00, 2.6239907282E+00, 9.1587000404E-01],
	[2.98500E+04, 2.1167197833E+01, 5.3868866257E+00, 6.7509792493E+00, 2.6246336702E+00, 9.1591216518E-01],
	[2.98550E+04, 2.1173040015E+01, 5.3868729557E+00, 6.7546604915E+00, 2.6252764913E+00, 9.1595430539E-01],
	[2.98600E+04, 2.1178882831E+01, 5.3868592881E+00, 6.7583431240E+00, 2.6259191916E+00, 9.1599642470E-01],
	[2.98650E+04, 2.1184726281E+01, 5.3868456228E+00, 6.7620271472E+00, 2.6265617709E+00, 9.1603852311E-01],
	[2.98700E+04, 2.1190570364E+01, 5.3868319598E+00, 6.7657125614E+00, 2.6272042293E+00, 9.1608060063E-01],
	[2.98750E+04, 2.1196415081E+01, 5.3868182991E+00, 6.7693993668E+00, 2.6278465667E+00, 9.1612265726E-01],
	[2.98800E+04, 2.1202260431E+01, 5.3868046407E+00, 6.7730875637E+00, 2.6284887831E+00, 9.1616469302E-01],
	[2.98850E+04, 2.1208106415E+01, 5.3867909847E+00, 6.7767771525E+00, 2.6291308785E+00, 9.1620670792E-01],
	[2.98900E+04, 2.1213953033E+01, 5.3867773310E+00, 6.7804681334E+00, 2.6297728527E+00, 9.1624870195E-01],
	[2.98950E+04, 2.1219800284E+01, 5.3867636796E+00, 6.7841605068E+00, 2.6304147059E+00, 9.1629067514E-01],
	[2.99000E+04, 2.1225648168E+01, 5.3867500305E+00, 6.7878542728E+00, 2.6310564378E+00, 9.1633262749E-01],
	[2.99050E+04, 2.1231496685E+01, 5.3867363837E+00, 6.7915494318E+00, 2.6316980486E+00, 9.1637455901E-01],
	[2.99100E+04, 2.1237345836E+01, 5.3867227393E+00, 6.7952459842E+00, 2.6323395382E+00, 9.1641646970E-01],
	[2.99150E+04, 2.1243195621E+01, 5.3867090972E+00, 6.7989439301E+00, 2.6329809065E+00, 9.1645835957E-01],
	[2.99200E+04, 2.1249046038E+01, 5.3866954574E+00, 6.8026432699E+00, 2.6336221535E+00, 9.1650022864E-01],
	[2.99250E+04, 2.1254897089E+01, 5.3866818198E+00, 6.8063440039E+00, 2.6342632791E+00, 9.1654207691E-01],
	[2.99300E+04, 2.1260748773E+01, 5.3866681847E+00, 6.8100461323E+00, 2.6349042834E+00, 9.1658390440E-01],
	[2.99350E+04, 2.1266601090E+01, 5.3866545518E+00, 6.8137496555E+00, 2.6355451663E+00, 9.1662571110E-01],
	[2.99400E+04, 2.1272454040E+01, 5.3866409212E+00, 6.8174545737E+00, 2.6361859277E+00, 9.1666749702E-01],
	[2.99450E+04, 2.1278307624E+01, 5.3866272930E+00, 6.8211608873E+00, 2.6368265677E+00, 9.1670926218E-01],
	[2.99500E+04, 2.1284161840E+01, 5.3866136670E+00, 6.8248685965E+00, 2.6374670862E+00, 9.1675100659E-01],
	[2.99550E+04, 2.1290016689E+01, 5.3866000434E+00, 6.8285777016E+00, 2.6381074831E+00, 9.1679273025E-01],
	[2.99600E+04, 2.1295872171E+01, 5.3865864221E+00, 6.8322882030E+00, 2.6387477584E+00, 9.1683443317E-01],
	[2.99650E+04, 2.1301728286E+01, 5.3865728030E+00, 6.8360001009E+00, 2.6393879122E+00, 9.1687611535E-01],
	[2.99700E+04, 2.1307585035E+01, 5.3865591863E+00, 6.8397133955E+00, 2.6400279443E+00, 9.1691777682E-01],
	[2.99750E+04, 2.1313442415E+01, 5.3865455719E+00, 6.8434280873E+00, 2.6406678547E+00, 9.1695941757E-01],
	[2.99800E+04, 2.1319300429E+01, 5.3865319598E+00, 6.8471441764E+00, 2.6413076434E+00, 9.1700103762E-01],
	[2.99850E+04, 2.1325159076E+01, 5.3865183500E+00, 6.8508616633E+00, 2.6419473103E+00, 9.1704263697E-01],
	[2.99900E+04, 2.1331018355E+01, 5.3865047425E+00, 6.8545805481E+00, 2.6425868555E+00, 9.1708421563E-01],
	[2.99950E+04, 2.1336878267E+01, 5.3864911373E+00, 6.8583008311E+00, 2.6432262788E+00, 9.1712577361E-01],
	[3.00000E+04, 2.1342738811E+01, 5.3864775344E+00, 6.8620225128E+00, 2.6438655803E+00, 9.1716731092E-01],
	[3.00050E+04, 2.1348599988E+01, 5.3864639338E+00, 6.8657703252E+00, 2.6445084291E+00, 9.1720882757E-01],
	[3.00100E+04, 2.1354461798E+01, 5.3864503356E+00, 6.8695195596E+00, 2.6451511550E+00, 9.1725032356E-01],
	[3.00150E+04, 2.1360324240E+01, 5.3864367396E+00, 6.8732702162E+00, 2.6457937578E+00, 9.1729179891E-01],
	[3.00200E+04, 2.1366187315E+01, 5.3864231459E+00, 6.8770222953E+00, 2.6464362376E+00, 9.1733325362E-01],
	[3.00250E+04, 2.1372051023E+01, 5.3864095545E+00, 6.8807757974E+00, 2.6470785943E+00, 9.1737468770E-01],
	[3.00300E+04, 2.1377915362E+01, 5.3863959654E+00, 6.8845307225E+00, 2.6477208280E+00, 9.1741610117E-01],
	[3.00350E+04, 2.1383780334E+01, 5.3863823786E+00, 6.8882870711E+00, 2.6483629385E+00, 9.1745749402E-01],
	[3.00400E+04, 2.1389645939E+01, 5.3863687941E+00, 6.8920448435E+00, 2.6490049258E+00, 9.1749886626E-01],
	[3.00450E+04, 2.1395512176E+01, 5.3863552119E+00, 6.8958040399E+00, 2.6496467899E+00, 9.1754021792E-01],
	[3.00500E+04, 2.1401379045E+01, 5.3863416320E+00, 6.8995646607E+00, 2.6502885307E+00, 9.1758154898E-01],
	[3.00550E+04, 2.1407246546E+01, 5.3863280544E+00, 6.9033267062E+00, 2.6509301483E+00, 9.1762285947E-01],
	[3.00600E+04, 2.1413114680E+01, 5.3863144790E+00, 6.9070901766E+00, 2.6515716426E+00, 9.1766414939E-01],
	[3.00650E+04, 2.1418983445E+01, 5.3863009060E+00, 6.9108550723E+00, 2.6522130135E+00, 9.1770541875E-01],
	[3.00700E+04, 2.1424852843E+01, 5.3862873353E+00, 6.9146213936E+00, 2.6528542611E+00, 9.1774666756E-01],
	[3.00750E+04, 2.1430722873E+01, 5.3862737668E+00, 6.9183891407E+00, 2.6534953852E+00, 9.1778789582E-01],
	[3.00800E+04, 2.1436593535E+01, 5.3862602006E+00, 6.9221583140E+00, 2.6541363859E+00, 9.1782910355E-01],
	[3.00850E+04, 2.1442464829E+01, 5.3862466368E+00, 6.9259289138E+00, 2.6547772631E+00, 9.1787029076E-01],
	[3.00900E+04, 2.1448336755E+01, 5.3862330752E+00, 6.9297009404E+00, 2.6554180168E+00, 9.1791145744E-01],
	[3.00950E+04, 2.1454209313E+01, 5.3862195159E+00, 6.9334743941E+00, 2.6560586470E+00, 9.1795260362E-01],
	[3.01000E+04, 2.1460082503E+01, 5.3862059589E+00, 6.9372492751E+00, 2.6566991535E+00, 9.1799372930E-01],
	[3.01050E+04, 2.1465956325E+01, 5.3861924042E+00, 6.9410255839E+00, 2.6573395365E+00, 9.1803483448E-01],
	[3.01100E+04, 2.1471830779E+01, 5.3861788517E+00, 6.9448033206E+00, 2.6579797958E+00, 9.1807591919E-01],
	[3.01150E+04, 2.1477705864E+01, 5.3861653016E+00, 6.9485824856E+00, 2.6586199314E+00, 9.1811698342E-01],
	[3.01200E+04, 2.1483581582E+01, 5.3861517537E+00, 6.9523630793E+00, 2.6592599433E+00, 9.1815802718E-01],
	[3.01250E+04, 2.1489457931E+01, 5.3861382081E+00, 6.9561451018E+00, 2.6598998314E+00, 9.1819905048E-01],
	[3.01300E+04, 2.1495334911E+01, 5.3861246648E+00, 6.9599285535E+00, 2.6605395958E+00, 9.1824005334E-01],
	[3.01350E+04, 2.1501212524E+01, 5.3861111238E+00, 6.9637134348E+00, 2.6611792364E+00, 9.1828103575E-01],
	[3.01400E+04, 2.1507090768E+01, 5.3860975850E+00, 6.9674997458E+00, 2.6618187531E+00, 9.1832199774E-01],
	[3.01450E+04, 2.1512969643E+01, 5.3860840486E+00, 6.9712874870E+00, 2.6624581459E+00, 9.1836293930E-01],
	[3.01500E+04, 2.1518849150E+01, 5.3860705144E+00, 6.9750766585E+00, 2.6630974148E+00, 9.1840386045E-01],
	[3.01550E+04, 2.1524729289E+01, 5.3860569825E+00, 6.9788672608E+00, 2.6637365598E+00, 9.1844476119E-01],
	[3.01600E+04, 2.1530610059E+01, 5.3860434528E+00, 6.9826592942E+00, 2.6643755807E+00, 9.1848564153E-01],
	[3.01650E+04, 2.1536491460E+01, 5.3860299255E+00, 6.9864527588E+00, 2.6650144777E+00, 9.1852650149E-01],
	[3.01700E+04, 2.1542373493E+01, 5.3860164004E+00, 6.9902476551E+00, 2.6656532506E+00, 9.1856734107E-01],
	[3.01750E+04, 2.1548256158E+01, 5.3860028776E+00, 6.9940439833E+00, 2.6662918995E+00, 9.1860816027E-01],
	[3.01800E+04, 2.1554139453E+01, 5.3859893571E+00, 6.9978417437E+00, 2.6669304242E+00, 9.1864895912E-01],
	[3.01850E+04, 2.1560023380E+01, 5.3859758388E+00, 7.0016409367E+00, 2.6675688248E+00, 9.1868973761E-01],
	[3.01900E+04, 2.1565907938E+01, 5.3859623229E+00, 7.0054415625E+00, 2.6682071012E+00, 9.1873049575E-01],
	[3.01950E+04, 2.1571793128E+01, 5.3859488091E+00, 7.0092436214E+00, 2.6688452534E+00, 9.1877123356E-01],
	[3.02000E+04, 2.1577678948E+01, 5.3859352977E+00, 7.0130471138E+00, 2.6694832813E+00, 9.1881195104E-01],
	[3.02050E+04, 2.1583565400E+01, 5.3859217885E+00, 7.0168520399E+00, 2.6701211850E+00, 9.1885264820E-01],
	[3.02100E+04, 2.1589452483E+01, 5.3859082816E+00, 7.0206584001E+00, 2.6707589644E+00, 9.1889332505E-01],
	[3.02150E+04, 2.1595340196E+01, 5.3858947770E+00, 7.0244661947E+00, 2.6713966194E+00, 9.1893398160E-01],
	[3.02200E+04, 2.1601228541E+01, 5.3858812747E+00, 7.0282754238E+00, 2.6720341501E+00, 9.1897461785E-01],
	[3.02250E+04, 2.1607117517E+01, 5.3858677746E+00, 7.0320860880E+00, 2.6726715564E+00, 9.1901523382E-01],
	[3.02300E+04, 2.1613007124E+01, 5.3858542767E+00, 7.0358981874E+00, 2.6733088382E+00, 9.1905582952E-01],
	[3.02350E+04, 2.1618897362E+01, 5.3858407812E+00, 7.0397117224E+00, 2.6739459956E+00, 9.1909640495E-01],
	[3.02400E+04, 2.1624788230E+01, 5.3858272879E+00, 7.0435266933E+00, 2.6745830285E+00, 9.1913696012E-01],
	[3.02450E+04, 2.1630679730E+01, 5.3858137969E+00, 7.0473431003E+00, 2.6752199368E+00, 9.1917749504E-01],
	[3.02500E+04, 2.1636571860E+01, 5.3858003081E+00, 7.0511609438E+00, 2.6758567206E+00, 9.1921800972E-01],
	[3.02550E+04, 2.1642464621E+01, 5.3857868216E+00, 7.0549802240E+00, 2.6764933798E+00, 9.1925850416E-01],
	[3.02600E+04, 2.1648358013E+01, 5.3857733374E+00, 7.0588009414E+00, 2.6771299144E+00, 9.1929897838E-01],
	[3.02650E+04, 2.1654252036E+01, 5.3857598554E+00, 7.0626230961E+00, 2.6777663243E+00, 9.1933943239E-01],
	[3.02700E+04, 2.1660146689E+01, 5.3857463757E+00, 7.0664466886E+00, 2.6784026095E+00, 9.1937986619E-01],
	[3.02750E+04, 2.1666041973E+01, 5.3857328982E+00, 7.0702717190E+00, 2.6790387700E+00, 9.1942027980E-01],
	[3.02800E+04, 2.1671937887E+01, 5.3857194230E+00, 7.0740981877E+00, 2.6796748058E+00, 9.1946067321E-01],
	[3.02850E+04, 2.1677834432E+01, 5.3857059501E+00, 7.0779260950E+00, 2.6803107167E+00, 9.1950104645E-01],
	[3.02900E+04, 2.1683731607E+01, 5.3856924794E+00, 7.0817554412E+00, 2.6809465029E+00, 9.1954139951E-01],
	[3.02950E+04, 2.1689629413E+01, 5.3856790110E+00, 7.0855862266E+00, 2.6815821642E+00, 9.1958173241E-01],
	[3.03000E+04, 2.1695527850E+01, 5.3856655448E+00, 7.0894184515E+00, 2.6822177007E+00, 9.1962204516E-01],
	[3.03050E+04, 2.1701426917E+01, 5.3856520809E+00, 7.0932521163E+00, 2.6828531122E+00, 9.1966233776E-01],
	[3.03100E+04, 2.1707326614E+01, 5.3856386192E+00, 7.0970872211E+00, 2.6834883988E+00, 9.1970261023E-01],
	[3.03150E+04, 2.1713226941E+01, 5.3856251598E+00, 7.1009237663E+00, 2.6841235605E+00, 9.1974286256E-01],
	[3.03200E+04, 2.1719127899E+01, 5.3856117027E+00, 7.1047617523E+00, 2.6847585971E+00, 9.1978309478E-01],
	[3.03250E+04, 2.1725029487E+01, 5.3855982478E+00, 7.1086011793E+00, 2.6853935087E+00, 9.1982330689E-01],
	[3.03300E+04, 2.1730931706E+01, 5.3855847952E+00, 7.1124420476E+00, 2.6860282953E+00, 9.1986349890E-01],
	[3.03350E+04, 2.1736834554E+01, 5.3855713448E+00, 7.1162843576E+00, 2.6866629568E+00, 9.1990367081E-01],
	[3.03400E+04, 2.1742738033E+01, 5.3855578966E+00, 7.1201281095E+00, 2.6872974931E+00, 9.1994382264E-01],
	[3.03450E+04, 2.1748642141E+01, 5.3855444507E+00, 7.1239733036E+00, 2.6879319043E+00, 9.1998395439E-01],
	[3.03500E+04, 2.1754546880E+01, 5.3855310071E+00, 7.1278199403E+00, 2.6885661903E+00, 9.2002406608E-01],
	[3.03550E+04, 2.1760452249E+01, 5.3855175657E+00, 7.1316680198E+00, 2.6892003511E+00, 9.2006415771E-01],
	[3.03600E+04, 2.1766358248E+01, 5.3855041265E+00, 7.1355175424E+00, 2.6898343867E+00, 9.2010422929E-01],
	[3.03650E+04, 2.1772264877E+01, 5.3854906896E+00, 7.1393685085E+00, 2.6904682970E+00, 9.2014428083E-01],
	[3.03700E+04, 2.1778172136E+01, 5.3854772550E+00, 7.1432209184E+00, 2.6911020820E+00, 9.2018431234E-01],
	[3.03750E+04, 2.1784080024E+01, 5.3854638226E+00, 7.1470747723E+00, 2.6917357416E+00, 9.2022432382E-01],
	[3.03800E+04, 2.1789988543E+01, 5.3854503924E+00, 7.1509300705E+00, 2.6923692759E+00, 9.2026431530E-01],
	[3.03850E+04, 2.1795897691E+01, 5.3854369645E+00, 7.1547868135E+00, 2.6930026848E+00, 9.2030428676E-01],
	[3.03900E+04, 2.1801807469E+01, 5.3854235388E+00, 7.1586450014E+00, 2.6936359683E+00, 9.2034423823E-01],
	[3.03950E+04, 2.1807717877E+01, 5.3854101154E+00, 7.1625046345E+00, 2.6942691263E+00, 9.2038416971E-01],
	[3.04000E+04, 2.1813628915E+01, 5.3853966942E+00, 7.1663657133E+00, 2.6949021589E+00, 9.2042408122E-01],
	[3.04050E+04, 2.1819540582E+01, 5.3853832752E+00, 7.1702282379E+00, 2.6955350659E+00, 9.2046397275E-01],
	[3.04100E+04, 2.1825452879E+01, 5.3853698585E+00, 7.1740922087E+00, 2.6961678474E+00, 9.2050384432E-01],
	[3.04150E+04, 2.1831365806E+01, 5.3853564440E+00, 7.1779576260E+00, 2.6968005033E+00, 9.2054369594E-01],
	[3.04200E+04, 2.1837279362E+01, 5.3853430318E+00, 7.1818244901E+00, 2.6974330337E+00, 9.2058352762E-01],
	[3.04250E+04, 2.1843193547E+01, 5.3853296218E+00, 7.1856928012E+00, 2.6980654384E+00, 9.2062333936E-01],
	[3.04300E+04, 2.1849108362E+01, 5.3853162140E+00, 7.1895625598E+00, 2.6986977174E+00, 9.2066313117E-01],
	[3.04350E+04, 2.1855023807E+01, 5.3853028085E+00, 7.1934337660E+00, 2.6993298708E+00, 9.2070290307E-01],
	[3.04400E+04, 2.1860939881E+01, 5.3852894052E+00, 7.1973064203E+00, 2.6999618984E+00, 9.2074265506E-01],
	[3.04450E+04, 2.1866856584E+01, 5.3852760042E+00, 7.2011805229E+00, 2.7005938003E+00, 9.2078238714E-01],
	[3.04500E+04, 2.1872773917E+01, 5.3852626053E+00, 7.2050560741E+00, 2.7012255764E+00, 9.2082209934E-01],
	[3.04550E+04, 2.1878691879E+01, 5.3852492087E+00, 7.2089330742E+00, 2.7018572267E+00, 9.2086179166E-01],
	[3.04600E+04, 2.1884610470E+01, 5.3852358144E+00, 7.2128115235E+00, 2.7024887512E+00, 9.2090146410E-01],
	[3.04650E+04, 2.1890529691E+01, 5.3852224223E+00, 7.2166914223E+00, 2.7031201498E+00, 9.2094111667E-01],
	[3.04700E+04, 2.1896449541E+01, 5.3852090324E+00, 7.2205727710E+00, 2.7037514225E+00, 9.2098074940E-01],
	[3.04750E+04, 2.1902370020E+01, 5.3851956447E+00, 7.2244555697E+00, 2.7043825693E+00, 9.2102036227E-01],
	[3.04800E+04, 2.1908291128E+01, 5.3851822593E+00, 7.2283398190E+00, 2.7050135902E+00, 9.2105995531E-01],
	[3.04850E+04, 2.1914212865E+01, 5.3851688761E+00, 7.2322255189E+00, 2.7056444850E+00, 9.2109952851E-01],
	[3.04900E+04, 2.1920135231E+01, 5.3851554951E+00, 7.2361126699E+00, 2.7062752539E+00, 9.2113908190E-01],
	[3.04950E+04, 2.1926058226E+01, 5.3851421163E+00, 7.2400012722E+00, 2.7069058968E+00, 9.2117861547E-01],
	[3.05000E+04, 2.1931981851E+01, 5.3851287398E+00, 7.2438913262E+00, 2.7075364135E+00, 9.2121812924E-01],
	[3.05050E+04, 2.1937906104E+01, 5.3851153655E+00, 7.2477828321E+00, 2.7081668042E+00, 9.2125762322E-01],
	[3.05100E+04, 2.1943830986E+01, 5.3851019935E+00, 7.2516757903E+00, 2.7087970688E+00, 9.2129709741E-01],
	[3.05150E+04, 2.1949756497E+01, 5.3850886236E+00, 7.2555702011E+00, 2.7094272072E+00, 9.2133655183E-01],
	[3.05200E+04, 2.1955682637E+01, 5.3850752560E+00, 7.2594660647E+00, 2.7100572194E+00, 9.2137598648E-01],
	[3.05250E+04, 2.1961609405E+01, 5.3850618906E+00, 7.2633633815E+00, 2.7106871054E+00, 9.2141540137E-01],
	[3.05300E+04, 2.1967554178E+01, 5.3850510302E+00, 7.2672621517E+00, 2.7113177644E+00, 9.2145479651E-01],
	[3.05350E+04, 2.1973537310E+01, 5.3850456037E+00, 7.2711623757E+00, 2.7119502499E+00, 9.2149417191E-01],
	[3.05400E+04, 2.1979521091E+01, 5.3850401781E+00, 7.2750640538E+00, 2.7125826109E+00, 9.2153352757E-01],
	[3.05450E+04, 2.1985505522E+01, 5.3850347534E+00, 7.2789671863E+00, 2.7132148473E+00, 9.2157286352E-01],
	[3.05500E+04, 2.1991490602E+01, 5.3850293296E+00, 7.2828717735E+00, 2.7138469592E+00, 9.2161217975E-01],
	[3.05550E+04, 2.1997476332E+01, 5.3850239067E+00, 7.2867778156E+00, 2.7144789463E+00, 9.2165147627E-01],
	[3.05600E+04, 2.2003462711E+01, 5.3850184847E+00, 7.2906853131E+00, 2.7151108088E+00, 9.2169075310E-01],
	[3.05650E+04, 2.2009449739E+01, 5.3850130635E+00, 7.2945942661E+00, 2.7157425467E+00, 9.2173001023E-01],
	[3.05700E+04, 2.2015437417E+01, 5.3850076433E+00, 7.2985046751E+00, 2.7163741598E+00, 9.2176924769E-01],
	[3.05750E+04, 2.2021425744E+01, 5.3850022240E+00, 7.3024165402E+00, 2.7170056481E+00, 9.2180846548E-01],
	[3.05800E+04, 2.2027414720E+01, 5.3849968055E+00, 7.3063298619E+00, 2.7176370117E+00, 9.2184766361E-01],
	[3.05850E+04, 2.2033404346E+01, 5.3849913880E+00, 7.3102446404E+00, 2.7182682504E+00, 9.2188684209E-01],
	[3.05900E+04, 2.2039394621E+01, 5.3849859713E+00, 7.3141608760E+00, 2.7188993644E+00, 9.2192600092E-01],
	[3.05950E+04, 2.2045385544E+01, 5.3849805555E+00, 7.3180785690E+00, 2.7195303535E+00, 9.2196514012E-01],
	[3.06000E+04, 2.2051377117E+01, 5.3849751406E+00, 7.3219977197E+00, 2.7201612177E+00, 9.2200425969E-01],
	[3.06050E+04, 2.2057369339E+01, 5.3849697266E+00, 7.3259183285E+00, 2.7207919569E+00, 9.2204335964E-01],
	[3.06100E+04, 2.2063362211E+01, 5.3849643135E+00, 7.3298403956E+00, 2.7214225713E+00, 9.2208243999E-01],
	[3.06150E+04, 2.2069355731E+01, 5.3849589013E+00, 7.3337639213E+00, 2.7220530606E+00, 9.2212150074E-01],
	[3.06200E+04, 2.2075349900E+01, 5.3849534900E+00, 7.3376889060E+00, 2.7226834250E+00, 9.2216054189E-01],
	[3.06250E+04, 2.2081344718E+01, 5.3849480795E+00, 7.3416153500E+00, 2.7233136643E+00, 9.2219956347E-01],
	[3.06300E+04, 2.2087340185E+01, 5.3849426700E+00, 7.3455432534E+00, 2.7239437786E+00, 9.2223856547E-01],
	[3.06350E+04, 2.2093336300E+01, 5.3849372613E+00, 7.3494726168E+00, 2.7245737678E+00, 9.2227754791E-01],
	[3.06400E+04, 2.2099333065E+01, 5.3849318536E+00, 7.3534034403E+00, 2.7252036319E+00, 9.2231651079E-01],
	[3.06450E+04, 2.2105330478E+01, 5.3849264467E+00, 7.3573357242E+00, 2.7258333708E+00, 9.2235545413E-01],
	[3.06500E+04, 2.2111328540E+01, 5.3849210407E+00, 7.3612694690E+00, 2.7264629846E+00, 9.2239437793E-01],
	[3.06550E+04, 2.2117327251E+01, 5.3849156356E+00, 7.3652046748E+00, 2.7270924732E+00, 9.2243328220E-01],
	[3.06600E+04, 2.2123326611E+01, 5.3849102314E+00, 7.3691413419E+00, 2.7277218366E+00, 9.2247216696E-01],
	[3.06650E+04, 2.2129326619E+01, 5.3849048280E+00, 7.3730794708E+00, 2.7283510747E+00, 9.2251103220E-01],
	[3.06700E+04, 2.2135327276E+01, 5.3848994256E+00, 7.3770190616E+00, 2.7289801876E+00, 9.2254987794E-01],
	[3.06750E+04, 2.2141328581E+01, 5.3848940240E+00, 7.3809601148E+00, 2.7296091752E+00, 9.2258870419E-01],
	[3.06800E+04, 2.2147330535E+01, 5.3848886233E+00, 7.3849026305E+00, 2.7302380374E+00, 9.2262751096E-01],
	[3.06850E+04, 2.2153333138E+01, 5.3848832235E+00, 7.3888466091E+00, 2.7308667743E+00, 9.2266629825E-01],
	[3.06900E+04, 2.2159336388E+01, 5.3848778246E+00, 7.3927920509E+00, 2.7314953858E+00, 9.2270506607E-01],
	[3.06950E+04, 2.2165340288E+01, 5.3848724266E+00, 7.3967389562E+00, 2.7321238719E+00, 9.2274381444E-01],
	[3.07000E+04, 2.2171344836E+01, 5.3848670295E+00, 7.4006873254E+00, 2.7327522326E+00, 9.2278254336E-01],
	[3.07050E+04, 2.2177350032E+01, 5.3848616332E+00, 7.4046371586E+00, 2.7333804678E+00, 9.2282125284E-01],
	[3.07100E+04, 2.2183355876E+01, 5.3848562378E+00, 7.4085884563E+00, 2.7340085775E+00, 9.2285994289E-01],
	[3.07150E+04, 2.2189362369E+01, 5.3848508434E+00, 7.4125412187E+00, 2.7346365617E+00, 9.2289861352E-01],
	[3.07200E+04, 2.2195369510E+01, 5.3848454498E+00, 7.4164954461E+00, 2.7352644204E+00, 9.2293726473E-01],
	[3.07250E+04, 2.2201377299E+01, 5.3848400570E+00, 7.4204511389E+00, 2.7358921535E+00, 9.2297589655E-01],
	[3.07300E+04, 2.2207385736E+01, 5.3848346652E+00, 7.4244082972E+00, 2.7365197611E+00, 9.2301450896E-01],
	[3.07350E+04, 2.2213394822E+01, 5.3848292743E+00, 7.4283669216E+00, 2.7371472430E+00, 9.2305310200E-01],
	[3.07400E+04, 2.2219404555E+01, 5.3848238842E+00, 7.4323270121E+00, 2.7377745992E+00, 9.2309167565E-01],
	[3.07450E+04, 2.2225414937E+01, 5.3848184950E+00, 7.4362885693E+00, 2.7384018298E+00, 9.2313022994E-01],
	[3.07500E+04, 2.2231425967E+01, 5.3848131067E+00, 7.4402515932E+00, 2.7390289347E+00, 9.2316876487E-01],
	[3.07550E+04, 2.2237437645E+01, 5.3848077193E+00, 7.4442160844E+00, 2.7396559139E+00, 9.2320728044E-01],
	[3.07600E+04, 2.2243449970E+01, 5.3848023327E+00, 7.4481820430E+00, 2.7402827673E+00, 9.2324577668E-01],
	[3.07650E+04, 2.2249462944E+01, 5.3847969471E+00, 7.4521494693E+00, 2.7409094950E+00, 9.2328425359E-01],
	[3.07700E+04, 2.2255476566E+01, 5.3847915623E+00, 7.4561183638E+00, 2.7415360969E+00, 9.2332271117E-01],
	[3.07750E+04, 2.2261490835E+01, 5.3847861784E+00, 7.4600887266E+00, 2.7421625729E+00, 9.2336114944E-01],
	[3.07800E+04, 2.2267505752E+01, 5.3847807953E+00, 7.4640605581E+00, 2.7427889231E+00, 9.2339956840E-01],
	[3.07850E+04, 2.2273521317E+01, 5.3847754132E+00, 7.4680338586E+00, 2.7434151474E+00, 9.2343796806E-01],
	[3.07900E+04, 2.2279537530E+01, 5.3847700319E+00, 7.4720086283E+00, 2.7440412458E+00, 9.2347634844E-01],
	[3.07950E+04, 2.2285554391E+01, 5.3847646516E+00, 7.4759848677E+00, 2.7446672183E+00, 9.2351470954E-01],
	[3.08000E+04, 2.2291571899E+01, 5.3847592721E+00, 7.4799625770E+00, 2.7452930648E+00, 9.2355305137E-01],
	[3.08050E+04, 2.2297590055E+01, 5.3847538934E+00, 7.4839417564E+00, 2.7459187854E+00, 9.2359137394E-01],
	[3.08100E+04, 2.2303608858E+01, 5.3847485157E+00, 7.4879224064E+00, 2.7465443799E+00, 9.2362967725E-01],
	[3.08150E+04, 2.2309628309E+01, 5.3847431388E+00, 7.4919045272E+00, 2.7471698485E+00, 9.2366796133E-01],
	[3.08200E+04, 2.2315648408E+01, 5.3847377628E+00, 7.4958881191E+00, 2.7477951909E+00, 9.2370622617E-01],
	[3.08250E+04, 2.2321669154E+01, 5.3847323877E+00, 7.4998731825E+00, 2.7484204073E+00, 9.2374447178E-01],
	[3.08300E+04, 2.2327690548E+01, 5.3847270135E+00, 7.5038597175E+00, 2.7490454976E+00, 9.2378269818E-01],
	[3.08350E+04, 2.2333712589E+01, 5.3847216401E+00, 7.5078477246E+00, 2.7496704618E+00, 9.2382090537E-01],
	[3.08400E+04, 2.2339735277E+01, 5.3847162676E+00, 7.5118372040E+00, 2.7502952998E+00, 9.2385909337E-01],
	[3.08450E+04, 2.2345758613E+01, 5.3847108960E+00, 7.5158281561E+00, 2.7509200116E+00, 9.2389726217E-01],
	[3.08500E+04, 2.2351782596E+01, 5.3847055253E+00, 7.5198205811E+00, 2.7515445972E+00, 9.2393541180E-01],
	[3.08550E+04, 2.2357807227E+01, 5.3847001554E+00, 7.5238144794E+00, 2.7521690566E+00, 9.2397354225E-01],
	[3.08600E+04, 2.2363832505E+01, 5.3846947864E+00, 7.5278098512E+00, 2.7527933898E+00, 9.2401165354E-01],
	[3.08650E+04, 2.2369858430E+01, 5.3846894183E+00, 7.5318066969E+00, 2.7534175966E+00, 9.2404974568E-01],
	[3.08700E+04, 2.2375885002E+01, 5.3846840511E+00, 7.5358050168E+00, 2.7540416772E+00, 9.2408781867E-01],
	[3.08750E+04, 2.2381912221E+01, 5.3846786847E+00, 7.5398048111E+00, 2.7546656315E+00, 9.2412587253E-01],
	[3.08800E+04, 2.2387940087E+01, 5.3846733193E+00, 7.5438060802E+00, 2.7552894593E+00, 9.2416390726E-01],
	[3.08850E+04, 2.2393968601E+01, 5.3846679547E+00, 7.5478088244E+00, 2.7559131609E+00, 9.2420192287E-01],
	[3.08900E+04, 2.2399997762E+01, 5.3846625909E+00, 7.5518130440E+00, 2.7565367360E+00, 9.2423991937E-01],
	[3.08950E+04, 2.2406027569E+01, 5.3846572281E+00, 7.5558187392E+00, 2.7571601847E+00, 9.2427789678E-01],
	[3.09000E+04, 2.2412058024E+01, 5.3846518661E+00, 7.5598259105E+00, 2.7577835069E+00, 9.2431585509E-01],
	[3.09050E+04, 2.2418089125E+01, 5.3846465050E+00, 7.5638345580E+00, 2.7584067027E+00, 9.2435379432E-01],
	[3.09100E+04, 2.2424120874E+01, 5.3846411447E+00, 7.5678446822E+00, 2.7590297720E+00, 9.2439171448E-01],
	[3.09150E+04, 2.2430153269E+01, 5.3846357854E+00, 7.5718562832E+00, 2.7596527147E+00, 9.2442961558E-01],
	[3.09200E+04, 2.2436186311E+01, 5.3846304269E+00, 7.5758693615E+00, 2.7602755309E+00, 9.2446749762E-01],
	[3.09250E+04, 2.2442220000E+01, 5.3846250692E+00, 7.5798839173E+00, 2.7608982206E+00, 9.2450536061E-01],
	[3.09300E+04, 2.2448254336E+01, 5.3846197125E+00, 7.5838999509E+00, 2.7615207836E+00, 9.2454320457E-01],
	[3.09350E+04, 2.2454289318E+01, 5.3846143566E+00, 7.5879174627E+00, 2.7621432201E+00, 9.2458102949E-01],
	[3.09400E+04, 2.2460324947E+01, 5.3846090016E+00, 7.5919364529E+00, 2.7627655299E+00, 9.2461883540E-01],
	[3.09450E+04, 2.2466361223E+01, 5.3846036474E+00, 7.5959569218E+00, 2.7633877130E+00, 9.2465662230E-01],
	[3.09500E+04, 2.2472398146E+01, 5.3845982942E+00, 7.5999788698E+00, 2.7640097695E+00, 9.2469439020E-01],
	[3.09550E+04, 2.2478435715E+01, 5.3845929418E+00, 7.6040022971E+00, 2.7646316992E+00, 9.2473213911E-01],
	[3.09600E+04, 2.2484473930E+01, 5.3845875902E+00, 7.6080272041E+00, 2.7652535022E+00, 9.2476986903E-01],
	[3.09650E+04, 2.2490512792E+01, 5.3845822396E+00, 7.6120535910E+00, 2.7658751784E+00, 9.2480757998E-01],
	[3.09700E+04, 2.2496552301E+01, 5.3845768898E+00, 7.6160814582E+00, 2.7664967279E+00, 9.2484527196E-01],
	[3.09750E+04, 2.2502592456E+01, 5.3845715409E+00, 7.6201108060E+00, 2.7671181506E+00, 9.2488294499E-01],
	[3.09800E+04, 2.2508633258E+01, 5.3845661928E+00, 7.6241416346E+00, 2.7677394464E+00, 9.2492059907E-01],
	[3.09850E+04, 2.2514674705E+01, 5.3845608456E+00, 7.6281739444E+00, 2.7683606154E+00, 9.2495823421E-01],
	[3.09900E+04, 2.2520716800E+01, 5.3845554993E+00, 7.6322077357E+00, 2.7689816575E+00, 9.2499585042E-01],
	[3.09950E+04, 2.2526759540E+01, 5.3845501538E+00, 7.6362430088E+00, 2.7696025727E+00, 9.2503344771E-01],
	[3.10000E+04, 2.2532802927E+01, 5.3845448093E+00, 7.6402797640E+00, 2.7702233610E+00, 9.2507102609E-01],
	[3.10050E+04, 2.2538846960E+01, 5.3845394656E+00, 7.6443180016E+00, 2.7708440223E+00, 9.2510858557E-01],
	[3.10100E+04, 2.2544891639E+01, 5.3845341227E+00, 7.6483577219E+00, 2.7714645567E+00, 9.2514612616E-01],
	[3.10150E+04, 2.2550936965E+01, 5.3845287807E+00, 7.6523989252E+00, 2.7720849641E+00, 9.2518364786E-01],
	[3.10200E+04, 2.2556982936E+01, 5.3845234396E+00, 7.6564416118E+00, 2.7727052445E+00, 9.2522115068E-01],
	[3.10250E+04, 2.2563029554E+01, 5.3845180994E+00, 7.6604857821E+00, 2.7733253978E+00, 9.2525863464E-01],
	[3.10300E+04, 2.2569076817E+01, 5.3845127600E+00, 7.6645314363E+00, 2.7739454241E+00, 9.2529609974E-01],
	[3.10350E+04, 2.2575124727E+01, 5.3845074215E+00, 7.6685785747E+00, 2.7745653233E+00, 9.2533354599E-01],
	[3.10400E+04, 2.2581173283E+01, 5.3845020838E+00, 7.6726271976E+00, 2.7751850954E+00, 9.2537097340E-01],
	[3.10450E+04, 2.2587222485E+01, 5.3844967470E+00, 7.6766773054E+00, 2.7758047404E+00, 9.2540838198E-01],
	[3.10500E+04, 2.2593272332E+01, 5.3844914111E+00, 7.6807288983E+00, 2.7764242582E+00, 9.2544577174E-01],
	[3.10550E+04, 2.2599322826E+01, 5.3844860760E+00, 7.6847819767E+00, 2.7770436489E+00, 9.2548314268E-01],
	[3.10600E+04, 2.2605373965E+01, 5.3844807418E+00, 7.6888365409E+00, 2.7776629123E+00, 9.2552049482E-01],
	[3.10650E+04, 2.2611425750E+01, 5.3844754085E+00, 7.6928925911E+00, 2.7782820486E+00, 9.2555782816E-01],
	[3.10700E+04, 2.2617478181E+01, 5.3844700760E+00, 7.6969501277E+00, 2.7789010576E+00, 9.2559514271E-01],
	[3.10750E+04, 2.2623531258E+01, 5.3844647444E+00, 7.7010091509E+00, 2.7795199393E+00, 9.2563243848E-01],
	[3.10800E+04, 2.2629584981E+01, 5.3844594137E+00, 7.7050696611E+00, 2.7801386938E+00, 9.2566971547E-01],
	[3.10850E+04, 2.2635639349E+01, 5.3844540838E+00, 7.7091316587E+00, 2.7807573210E+00, 9.2570697370E-01],
	[3.10900E+04, 2.2641694362E+01, 5.3844487548E+00, 7.7131951438E+00, 2.7813758208E+00, 9.2574421316E-01],
	[3.10950E+04, 2.2647750022E+01, 5.3844434267E+00, 7.7172601168E+00, 2.7819941933E+00, 9.2578143388E-01],
	[3.11000E+04, 2.2653806327E+01, 5.3844380994E+00, 7.7213265780E+00, 2.7826124384E+00, 9.2581863585E-01],
	[3.11050E+04, 2.2659863277E+01, 5.3844327729E+00, 7.7253945277E+00, 2.7832305562E+00, 9.2585581909E-01],
	[3.11100E+04, 2.2665920873E+01, 5.3844274474E+00, 7.7294639662E+00, 2.7838485465E+00, 9.2589298360E-01],
	[3.11150E+04, 2.2671979115E+01, 5.3844221227E+00, 7.7335348938E+00, 2.7844664094E+00, 9.2593012939E-01],
	[3.11200E+04, 2.2678038002E+01, 5.3844167988E+00, 7.7376073109E+00, 2.7850841448E+00, 9.2596725647E-01],
	[3.11250E+04, 2.2684097534E+01, 5.3844114758E+00, 7.7416812177E+00, 2.7857017528E+00, 9.2600436485E-01],
	[3.11300E+04, 2.2690157712E+01, 5.3844061537E+00, 7.7457566145E+00, 2.7863192332E+00, 9.2604145453E-01],
	[3.11350E+04, 2.2696218535E+01, 5.3844008324E+00, 7.7498335017E+00, 2.7869365861E+00, 9.2607852552E-01],
	[3.11400E+04, 2.2702280003E+01, 5.3843955120E+00, 7.7539118795E+00, 2.7875538115E+00, 9.2611557784E-01],
	[3.11450E+04, 2.2708342117E+01, 5.3843901925E+00, 7.7579917483E+00, 2.7881709094E+00, 9.2615261148E-01],
	[3.11500E+04, 2.2714404875E+01, 5.3843848738E+00, 7.7620731083E+00, 2.7887878796E+00, 9.2618962646E-01],
	[3.11550E+04, 2.2720468279E+01, 5.3843795560E+00, 7.7661559599E+00, 2.7894047222E+00, 9.2622662278E-01],
	[3.11600E+04, 2.2726532328E+01, 5.3843742390E+00, 7.7702403033E+00, 2.7900214372E+00, 9.2626360046E-01],
	[3.11650E+04, 2.2732597023E+01, 5.3843689229E+00, 7.7743261390E+00, 2.7906380246E+00, 9.2630055949E-01],
	[3.11700E+04, 2.2738662362E+01, 5.3843636076E+00, 7.7784134671E+00, 2.7912544843E+00, 9.2633749989E-01],
	[3.11750E+04, 2.2744728346E+01, 5.3843582932E+00, 7.7825022879E+00, 2.7918708162E+00, 9.2637442167E-01],
	[3.11800E+04, 2.2750794976E+01, 5.3843529797E+00, 7.7865926019E+00, 2.7924870205E+00, 9.2641132484E-01],
	[3.11850E+04, 2.2756862250E+01, 5.3843476670E+00, 7.7906844093E+00, 2.7931030971E+00, 9.2644820939E-01],
	[3.11900E+04, 2.2762930170E+01, 5.3843423552E+00, 7.7947777104E+00, 2.7937190459E+00, 9.2648507535E-01],
	[3.11950E+04, 2.2768998734E+01, 5.3843370442E+00, 7.7988725055E+00, 2.7943348669E+00, 9.2652192271E-01],
	[3.12000E+04, 2.2775067943E+01, 5.3843317341E+00, 7.8029687948E+00, 2.7949505601E+00, 9.2655875149E-01],
	[3.12050E+04, 2.2781137797E+01, 5.3843264249E+00, 7.8070665789E+00, 2.7955661255E+00, 9.2659556169E-01],
	[3.12100E+04, 2.2787208296E+01, 5.3843211165E+00, 7.8111658578E+00, 2.7961815631E+00, 9.2663235333E-01],
	[3.12150E+04, 2.2793279439E+01, 5.3843158089E+00, 7.8152666320E+00, 2.7967968728E+00, 9.2666912640E-01],
	[3.12200E+04, 2.2799351228E+01, 5.3843105023E+00, 7.8193689017E+00, 2.7974120546E+00, 9.2670588092E-01],
	[3.12250E+04, 2.2805423661E+01, 5.3843051964E+00, 7.8234726672E+00, 2.7980271085E+00, 9.2674261690E-01],
	[3.12300E+04, 2.2811496738E+01, 5.3842998914E+00, 7.8275779289E+00, 2.7986420345E+00, 9.2677933434E-01],
	[3.12350E+04, 2.2817570461E+01, 5.3842945873E+00, 7.8316846870E+00, 2.7992568326E+00, 9.2681603326E-01],
	[3.12400E+04, 2.2823644828E+01, 5.3842892841E+00, 7.8357929420E+00, 2.7998715027E+00, 9.2685271365E-01],
	[3.12450E+04, 2.2829719839E+01, 5.3842839816E+00, 7.8399026939E+00, 2.8004860449E+00, 9.2688937553E-01],
	[3.12500E+04, 2.2835795495E+01, 5.3842786801E+00, 7.8440139433E+00, 2.8011004590E+00, 9.2692601891E-01],
	[3.12550E+04, 2.2841871795E+01, 5.3842733794E+00, 7.8481266903E+00, 2.8017147451E+00, 9.2696264379E-01],
	[3.12600E+04, 2.2847948740E+01, 5.3842680795E+00, 7.8522409353E+00, 2.8023289032E+00, 9.2699925018E-01],
	[3.12650E+04, 2.2854026330E+01, 5.3842627805E+00, 7.8563566786E+00, 2.8029429332E+00, 9.2703583810E-01],
	[3.12700E+04, 2.2860104564E+01, 5.3842574824E+00, 7.8604739204E+00, 2.8035568351E+00, 9.2707240754E-01],
	[3.12750E+04, 2.2866183442E+01, 5.3842521851E+00, 7.8645926612E+00, 2.8041706089E+00, 9.2710895852E-01],
	[3.12800E+04, 2.2872262964E+01, 5.3842468886E+00, 7.8687129012E+00, 2.8047842546E+00, 9.2714549104E-01],
	[3.12850E+04, 2.2878343131E+01, 5.3842415930E+00, 7.8728346407E+00, 2.8053977722E+00, 9.2718200511E-01],
	[3.12900E+04, 2.2884423942E+01, 5.3842362983E+00, 7.8769578800E+00, 2.8060111616E+00, 9.2721850075E-01],
	[3.12950E+04, 2.2890505397E+01, 5.3842310044E+00, 7.8810826195E+00, 2.8066244228E+00, 9.2725497795E-01],
	[3.13000E+04, 2.2896587496E+01, 5.3842257114E+00, 7.8852088593E+00, 2.8072375558E+00, 9.2729143673E-01],
	[3.13050E+04, 2.2902670240E+01, 5.3842204192E+00, 7.8893365999E+00, 2.8078505606E+00, 9.2732787709E-01],
	[3.13100E+04, 2.2908753627E+01, 5.3842151278E+00, 7.8934658416E+00, 2.8084634372E+00, 9.2736429904E-01],
	[3.13150E+04, 2.2914837659E+01, 5.3842098373E+00, 7.8975965846E+00, 2.8090761855E+00, 9.2740070260E-01],
	[3.13200E+04, 2.2920922335E+01, 5.3842045477E+00, 7.9017288292E+00, 2.8096888055E+00, 9.2743708776E-01],
	[3.13250E+04, 2.2927007655E+01, 5.3841992589E+00, 7.9058625758E+00, 2.8103012973E+00, 9.2747345454E-01],
	[3.13300E+04, 2.2933093618E+01, 5.3841939710E+00, 7.9099978247E+00, 2.8109136607E+00, 9.2750980294E-01],
	[3.13350E+04, 2.2939180226E+01, 5.3841886839E+00, 7.9141345762E+00, 2.8115258958E+00, 9.2754613298E-01],
	[3.13400E+04, 2.2945267478E+01, 5.3841833976E+00, 7.9182728305E+00, 2.8121380025E+00, 9.2758244466E-01],
	[3.13450E+04, 2.2951355373E+01, 5.3841781123E+00, 7.9224125880E+00, 2.8127499808E+00, 9.2761873798E-01],
	[3.13500E+04, 2.2957443912E+01, 5.3841728277E+00, 7.9265538490E+00, 2.8133618308E+00, 9.2765501297E-01],
	[3.13550E+04, 2.2963533096E+01, 5.3841675440E+00, 7.9306966138E+00, 2.8139735523E+00, 9.2769126961E-01],
	[3.13600E+04, 2.2969622922E+01, 5.3841622612E+00, 7.9348408827E+00, 2.8145851454E+00, 9.2772750793E-01],
	[3.13650E+04, 2.2975713393E+01, 5.3841569792E+00, 7.9389866560E+00, 2.8151966101E+00, 9.2776372793E-01],
	[3.13700E+04, 2.2981804507E+01, 5.3841516980E+00, 7.9431339340E+00, 2.8158079463E+00, 9.2779992963E-01],
	[3.13750E+04, 2.2987896265E+01, 5.3841464177E+00, 7.9472827170E+00, 2.8164191540E+00, 9.2783611301E-01],
	[3.13800E+04, 2.2993988667E+01, 5.3841411382E+00, 7.9514330054E+00, 2.8170302332E+00, 9.2787227811E-01],
	[3.13850E+04, 2.3000081712E+01, 5.3841358596E+00, 7.9555847994E+00, 2.8176411839E+00, 9.2790842491E-01],
	[3.13900E+04, 2.3006175401E+01, 5.3841305819E+00, 7.9597380994E+00, 2.8182520060E+00, 9.2794455344E-01],
	[3.13950E+04, 2.3012269733E+01, 5.3841253049E+00, 7.9638929055E+00, 2.8188626996E+00, 9.2798066370E-01],
	[3.14000E+04, 2.3018364709E+01, 5.3841200289E+00, 7.9680492183E+00, 2.8194732645E+00, 9.2801675569E-01],
	[3.14050E+04, 2.3024460328E+01, 5.3841147536E+00, 7.9722070379E+00, 2.8200837009E+00, 9.2805282943E-01],
	[3.14100E+04, 2.3030556590E+01, 5.3841094792E+00, 7.9763663646E+00, 2.8206940087E+00, 9.2808888493E-01],
	[3.14150E+04, 2.3036653496E+01, 5.3841042057E+00, 7.9805271989E+00, 2.8213041878E+00, 9.2812492218E-01],
	[3.14200E+04, 2.3042751046E+01, 5.3840989330E+00, 7.9846895409E+00, 2.8219142383E+00, 9.2816094121E-01],
	[3.14250E+04, 2.3048849238E+01, 5.3840936611E+00, 7.9888533910E+00, 2.8225241601E+00, 9.2819694201E-01],
	[3.14300E+04, 2.3054948074E+01, 5.3840883901E+00, 7.9930187495E+00, 2.8231339532E+00, 9.2823292460E-01],
	[3.14350E+04, 2.3061047554E+01, 5.3840831200E+00, 7.9971856166E+00, 2.8237436176E+00, 9.2826888899E-01],
	[3.14400E+04, 2.3067147676E+01, 5.3840778506E+00, 8.0013539928E+00, 2.8243531533E+00, 9.2830483517E-01],
	[3.14450E+04, 2.3073248442E+01, 5.3840725822E+00, 8.0055238783E+00, 2.8249625602E+00, 9.2834076317E-01],
	[3.14500E+04, 2.3079349850E+01, 5.3840673145E+00, 8.0096952734E+00, 2.8255718384E+00, 9.2837667299E-01],
	[3.14550E+04, 2.3085451902E+01, 5.3840620477E+00, 8.0138681784E+00, 2.8261809877E+00, 9.2841256463E-01],
	[3.14600E+04, 2.3091554597E+01, 5.3840567818E+00, 8.0180425937E+00, 2.8267900083E+00, 9.2844843811E-01],
	[3.14650E+04, 2.3097657935E+01, 5.3840515167E+00, 8.0222185195E+00, 2.8273989001E+00, 9.2848429343E-01],
	[3.14700E+04, 2.3103761916E+01, 5.3840462524E+00, 8.0263959561E+00, 2.8280076630E+00, 9.2852013060E-01],
	[3.14750E+04, 2.3109866540E+01, 5.3840409890E+00, 8.0305749039E+00, 2.8286162971E+00, 9.2855594963E-01],
	[3.14800E+04, 2.3115971807E+01, 5.3840357264E+00, 8.0347553631E+00, 2.8292248023E+00, 9.2859175053E-01],
	[3.14850E+04, 2.3122077717E+01, 5.3840304646E+00, 8.0389373341E+00, 2.8298331786E+00, 9.2862753331E-01],
	[3.14900E+04, 2.3128184269E+01, 5.3840252037E+00, 8.0431208172E+00, 2.8304414260E+00, 9.2866329797E-01],
	[3.14950E+04, 2.3134291465E+01, 5.3840199437E+00, 8.0473058126E+00, 2.8310495445E+00, 9.2869904452E-01],
	[3.15000E+04, 2.3140399303E+01, 5.3840146845E+00, 8.0514923207E+00, 2.8316575340E+00, 9.2873477297E-01],
	[3.15050E+04, 2.3146507784E+01, 5.3840094261E+00, 8.0556803418E+00, 2.8322653946E+00, 9.2877048333E-01],
	[3.15100E+04, 2.3152616908E+01, 5.3840041685E+00, 8.0598698762E+00, 2.8328731262E+00, 9.2880617560E-01],
	[3.15150E+04, 2.3158726674E+01, 5.3839989118E+00, 8.0640609242E+00, 2.8334807288E+00, 9.2884184980E-01],
	[3.15200E+04, 2.3164837084E+01, 5.3839936560E+00, 8.0682534861E+00, 2.8340882024E+00, 9.2887750593E-01],
	[3.15250E+04, 2.3170948135E+01, 5.3839884009E+00, 8.0724475622E+00, 2.8346955470E+00, 9.2891314401E-01],
	[3.15300E+04, 2.3177059830E+01, 5.3839831467E+00, 8.0766431528E+00, 2.8353027625E+00, 9.2894876403E-01],
	[3.15350E+04, 2.3183172167E+01, 5.3839778934E+00, 8.0808402583E+00, 2.8359098490E+00, 9.2898436601E-01],
	[3.15400E+04, 2.3189285146E+01, 5.3839726409E+00, 8.0850388788E+00, 2.8365168064E+00, 9.2901994995E-01],
	[3.15450E+04, 2.3195398768E+01, 5.3839673892E+00, 8.0892390149E+00, 2.8371236347E+00, 9.2905551587E-01],
	[3.15500E+04, 2.3201513032E+01, 5.3839621384E+00, 8.0934406666E+00, 2.8377303338E+00, 9.2909106377E-01],
	[3.15550E+04, 2.3207627939E+01, 5.3839568884E+00, 8.0976438345E+00, 2.8383369039E+00, 9.2912659366E-01],
	[3.15600E+04, 2.3213743488E+01, 5.3839516392E+00, 8.1018485186E+00, 2.8389433448E+00, 9.2916210554E-01],
	[3.15650E+04, 2.3219859680E+01, 5.3839463909E+00, 8.1060547195E+00, 2.8395496565E+00, 9.2919759944E-01],
	[3.15700E+04, 2.3225976514E+01, 5.3839411434E+00, 8.1102624373E+00, 2.8401558391E+00, 9.2923307535E-01],
	[3.15750E+04, 2.3232093990E+01, 5.3839358967E+00, 8.1144716724E+00, 2.8407618925E+00, 9.2926853327E-01],
	[3.15800E+04, 2.3238212109E+01, 5.3839306509E+00, 8.1186824251E+00, 2.8413678166E+00, 9.2930397324E-01],
	[3.15850E+04, 2.3244330869E+01, 5.3839254059E+00, 8.1228946956E+00, 2.8419736115E+00, 9.2933939523E-01],
	[3.15900E+04, 2.3250450272E+01, 5.3839201618E+00, 8.1271084844E+00, 2.8425792772E+00, 9.2937479928E-01],
	[3.15950E+04, 2.3256570317E+01, 5.3839149185E+00, 8.1313237917E+00, 2.8431848136E+00, 9.2941018538E-01],
	[3.16000E+04, 2.3262691004E+01, 5.3839096760E+00, 8.1355406178E+00, 2.8437902207E+00, 9.2944555355E-01],
	[3.16050E+04, 2.3268812333E+01, 5.3839044344E+00, 8.1397589630E+00, 2.8443954986E+00, 9.2948090378E-01],
	[3.16100E+04, 2.3274934304E+01, 5.3838991936E+00, 8.1439788276E+00, 2.8450006471E+00, 9.2951623610E-01],
	[3.16150E+04, 2.3281056918E+01, 5.3838939536E+00, 8.1482002120E+00, 2.8456056663E+00, 9.2955155050E-01],
	[3.16200E+04, 2.3287180173E+01, 5.3838887144E+00, 8.1524231164E+00, 2.8462105561E+00, 9.2958684700E-01],
	[3.16250E+04, 2.3293304070E+01, 5.3838834761E+00, 8.1566475412E+00, 2.8468153166E+00, 9.2962212561E-01],
	[3.16300E+04, 2.3299428609E+01, 5.3838782387E+00, 8.1608734866E+00, 2.8474199477E+00, 9.2965738632E-01],
	[3.16350E+04, 2.3305553790E+01, 5.3838730020E+00, 8.1651009530E+00, 2.8480244494E+00, 9.2969262916E-01],
	[3.16400E+04, 2.3311679613E+01, 5.3838677662E+00, 8.1693299406E+00, 2.8486288218E+00, 9.2972785413E-01],
	[3.16450E+04, 2.3317806077E+01, 5.3838625312E+00, 8.1735604498E+00, 2.8492330646E+00, 9.2976306123E-01],
	[3.16500E+04, 2.3323933184E+01, 5.3838572971E+00, 8.1777924809E+00, 2.8498371781E+00, 9.2979825048E-01],
	[3.16550E+04, 2.3330060932E+01, 5.3838520638E+00, 8.1820260342E+00, 2.8504411621E+00, 9.2983342188E-01],
	[3.16600E+04, 2.3336189321E+01, 5.3838468313E+00, 8.1862611100E+00, 2.8510450166E+00, 9.2986857544E-01],
	[3.16650E+04, 2.3342318353E+01, 5.3838415996E+00, 8.1904977085E+00, 2.8516487416E+00, 9.2990371118E-01],
	[3.16700E+04, 2.3348448026E+01, 5.3838363688E+00, 8.1947358302E+00, 2.8522523371E+00, 9.2993882909E-01],
	[3.16750E+04, 2.3354578341E+01, 5.3838311388E+00, 8.1989754753E+00, 2.8528558031E+00, 9.2997392919E-01],
	[3.16800E+04, 2.3360709297E+01, 5.3838259097E+00, 8.2032166442E+00, 2.8534591396E+00, 9.3000901148E-01],
	[3.16850E+04, 2.3366840895E+01, 5.3838206814E+00, 8.2074593370E+00, 2.8540623465E+00, 9.3004407598E-01],
	[3.16900E+04, 2.3372973134E+01, 5.3838154539E+00, 8.2117035542E+00, 2.8546654239E+00, 9.3007912268E-01],
	[3.16950E+04, 2.3379106015E+01, 5.3838102272E+00, 8.2159492961E+00, 2.8552683717E+00, 9.3011415161E-01],
	[3.17000E+04, 2.3385239537E+01, 5.3838050014E+00, 8.2201965628E+00, 2.8558711898E+00, 9.3014916276E-01],
	[3.17050E+04, 2.3391373700E+01, 5.3837997764E+00, 8.2244453549E+00, 2.8564738784E+00, 9.3018415615E-01],
	[3.17100E+04, 2.3397508505E+01, 5.3837945522E+00, 8.2286956725E+00, 2.8570764373E+00, 9.3021913178E-01],
	[3.17150E+04, 2.3403643952E+01, 5.3837893288E+00, 8.2329475160E+00, 2.8576788666E+00, 9.3025408967E-01],
	[3.17200E+04, 2.3409780039E+01, 5.3837841063E+00, 8.2372008857E+00, 2.8582811663E+00, 9.3028902981E-01],
	[3.17250E+04, 2.3415916768E+01, 5.3837788846E+00, 8.2414557818E+00, 2.8588833362E+00, 9.3032395223E-01],
	[3.17300E+04, 2.3422054138E+01, 5.3837736638E+00, 8.2457122048E+00, 2.8594853765E+00, 9.3035885692E-01],
	[3.17350E+04, 2.3428192149E+01, 5.3837684437E+00, 8.2499701548E+00, 2.8600872871E+00, 9.3039374389E-01],
	[3.17400E+04, 2.3434330802E+01, 5.3837632245E+00, 8.2542296323E+00, 2.8606890679E+00, 9.3042861316E-01],
	[3.17450E+04, 2.3440470095E+01, 5.3837580061E+00, 8.2584906374E+00, 2.8612907191E+00, 9.3046346473E-01],
	[3.17500E+04, 2.3446651631E+01, 5.3837586699E+00, 8.2627531706E+00, 2.8618945222E+00, 9.3049829861E-01],
	[3.17550E+04, 2.3452845762E+01, 5.3837610210E+00, 8.2670172321E+00, 2.8624988516E+00, 9.3053311481E-01],
	[3.17600E+04, 2.3459040554E+01, 5.3837633718E+00, 8.2712828223E+00, 2.8631030529E+00, 9.3056791333E-01],
	[3.17650E+04, 2.3465236007E+01, 5.3837657222E+00, 8.2755499414E+00, 2.8637071260E+00, 9.3060269419E-01],
	[3.17700E+04, 2.3471432120E+01, 5.3837680723E+00, 8.2798185898E+00, 2.8643110709E+00, 9.3063745739E-01],
	[3.17750E+04, 2.3477628894E+01, 5.3837704219E+00, 8.2840887677E+00, 2.8649148876E+00, 9.3067220294E-01],
	[3.17800E+04, 2.3483826329E+01, 5.3837727712E+00, 8.2883604754E+00, 2.8655185760E+00, 9.3070693085E-01],
	[3.17850E+04, 2.3490024424E+01, 5.3837751202E+00, 8.2926337134E+00, 2.8661221361E+00, 9.3074164113E-01],
	[3.17900E+04, 2.3496223180E+01, 5.3837774687E+00, 8.2969084818E+00, 2.8667255680E+00, 9.3077633378E-01],
	[3.17950E+04, 2.3502422597E+01, 5.3837798169E+00, 8.3011847810E+00, 2.8673288716E+00, 9.3081100882E-01],
	[3.18000E+04, 2.3508622673E+01, 5.3837821648E+00, 8.3054626114E+00, 2.8679320468E+00, 9.3084566625E-01],
	[3.18050E+04, 2.3514823411E+01, 5.3837845122E+00, 8.3097419731E+00, 2.8685350938E+00, 9.3088030608E-01],
	[3.18100E+04, 2.3521024808E+01, 5.3837868593E+00, 8.3140228665E+00, 2.8691380124E+00, 9.3091492832E-01],
	[3.18150E+04, 2.3527226867E+01, 5.3837892060E+00, 8.3183052919E+00, 2.8697408027E+00, 9.3094953297E-01],
	[3.18200E+04, 2.3533429585E+01, 5.3837915524E+00, 8.3225892497E+00, 2.8703434646E+00, 9.3098412005E-01],
	[3.18250E+04, 2.3539632964E+01, 5.3837938984E+00, 8.3268747401E+00, 2.8709459981E+00, 9.3101868957E-01],
	[3.18300E+04, 2.3545837003E+01, 5.3837962440E+00, 8.3311617634E+00, 2.8715484033E+00, 9.3105324152E-01],
	[3.18350E+04, 2.3552041702E+01, 5.3837985893E+00, 8.3354503200E+00, 2.8721506800E+00, 9.3108777593E-01],
	[3.18400E+04, 2.3558247062E+01, 5.3838009341E+00, 8.3397404102E+00, 2.8727528283E+00, 9.3112229279E-01],
	[3.18450E+04, 2.3564453081E+01, 5.3838032787E+00, 8.3440320342E+00, 2.8733548482E+00, 9.3115679212E-01],
	[3.18500E+04, 2.3570659761E+01, 5.3838056228E+00, 8.3483251923E+00, 2.8739567396E+00, 9.3119127392E-01],
	[3.18550E+04, 2.3576867101E+01, 5.3838079666E+00, 8.3526198850E+00, 2.8745585026E+00, 9.3122573821E-01],
	[3.18600E+04, 2.3583075101E+01, 5.3838103100E+00, 8.3569161124E+00, 2.8751601370E+00, 9.3126018499E-01],
	[3.18650E+04, 2.3589283762E+01, 5.3838126531E+00, 8.3612138749E+00, 2.8757616430E+00, 9.3129461427E-01],
	[3.18700E+04, 2.3595493082E+01, 5.3838149958E+00, 8.3655131728E+00, 2.8763630205E+00, 9.3132902605E-01],
	[3.18750E+04, 2.3601703062E+01, 5.3838173381E+00, 8.3698140065E+00, 2.8769642694E+00, 9.3136342035E-01],
	[3.18800E+04, 2.3607913702E+01, 5.3838196800E+00, 8.3741163761E+00, 2.8775653898E+00, 9.3139779718E-01],
	[3.18850E+04, 2.3614125002E+01, 5.3838220216E+00, 8.3784202821E+00, 2.8781663817E+00, 9.3143215654E-01],
	[3.18900E+04, 2.3620336962E+01, 5.3838243628E+00, 8.3827257246E+00, 2.8787672450E+00, 9.3146649844E-01],
	[3.18950E+04, 2.3626549582E+01, 5.3838267037E+00, 8.3870327042E+00, 2.8793679797E+00, 9.3150082288E-01],
	[3.19000E+04, 2.3632762861E+01, 5.3838290442E+00, 8.3913412209E+00, 2.8799685858E+00, 9.3153512989E-01],
	[3.19050E+04, 2.3638976800E+01, 5.3838313843E+00, 8.3956512753E+00, 2.8805690634E+00, 9.3156941946E-01],
	[3.19100E+04, 2.3645191399E+01, 5.3838337240E+00, 8.3999628674E+00, 2.8811694122E+00, 9.3160369160E-01],
	[3.19150E+04, 2.3651406658E+01, 5.3838360634E+00, 8.4042759978E+00, 2.8817696325E+00, 9.3163794633E-01],
	[3.19200E+04, 2.3657622577E+01, 5.3838384025E+00, 8.4085906666E+00, 2.8823697241E+00, 9.3167218365E-01],
	[3.19250E+04, 2.3663839155E+01, 5.3838407411E+00, 8.4129068742E+00, 2.8829696871E+00, 9.3170640356E-01],
	[3.19300E+04, 2.3670056393E+01, 5.3838430794E+00, 8.4172246209E+00, 2.8835695213E+00, 9.3174060609E-01],
	[3.19350E+04, 2.3676274290E+01, 5.3838454173E+00, 8.4215439070E+00, 2.8841692269E+00, 9.3177479122E-01],
	[3.19400E+04, 2.3682492847E+01, 5.3838477549E+00, 8.4258647328E+00, 2.8847688038E+00, 9.3180895898E-01],
	[3.19450E+04, 2.3688712063E+01, 5.3838500921E+00, 8.4301870986E+00, 2.8853682520E+00, 9.3184310938E-01],
	[3.19500E+04, 2.3694931939E+01, 5.3838524289E+00, 8.4345110047E+00, 2.8859675714E+00, 9.3187724241E-01],
	[3.19550E+04, 2.3701152475E+01, 5.3838547654E+00, 8.4388364515E+00, 2.8865667621E+00, 9.3191135809E-01],
	[3.19600E+04, 2.3707373669E+01, 5.3838571015E+00, 8.4431634392E+00, 2.8871658241E+00, 9.3194545643E-01],
	[3.19650E+04, 2.3713595523E+01, 5.3838594373E+00, 8.4474919681E+00, 2.8877647572E+00, 9.3197953743E-01],
	[3.19700E+04, 2.3719818037E+01, 5.3838617726E+00, 8.4518220386E+00, 2.8883635616E+00, 9.3201360111E-01],
	[3.19750E+04, 2.3726041210E+01, 5.3838641076E+00, 8.4561536509E+00, 2.8889622372E+00, 9.3204764747E-01],
	[3.19800E+04, 2.3732265042E+01, 5.3838664423E+00, 8.4604868054E+00, 2.8895607840E+00, 9.3208167651E-01],
	[3.19850E+04, 2.3738489533E+01, 5.3838687766E+00, 8.4648215024E+00, 2.8901592019E+00, 9.3211568826E-01],
	[3.19900E+04, 2.3744714684E+01, 5.3838711105E+00, 8.4691577422E+00, 2.8907574911E+00, 9.3214968271E-01],
	[3.19950E+04, 2.3750940494E+01, 5.3838734441E+00, 8.4734955251E+00, 2.8913556513E+00, 9.3218365988E-01],
	[3.20000E+04, 2.3757166962E+01, 5.3838757773E+00, 8.4778348513E+00, 2.8919536828E+00, 9.3221761977E-01],
	[3.20050E+04, 2.3763394090E+01, 5.3838781101E+00, 8.4821757213E+00, 2.8925515853E+00, 9.3225156239E-01],
	[3.20100E+04, 2.3769621878E+01, 5.3838804425E+00, 8.4865181353E+00, 2.8931493590E+00, 9.3228548775E-01],
	[3.20150E+04, 2.3775850324E+01, 5.3838827747E+00, 8.4908620936E+00, 2.8937470037E+00, 9.3231939585E-01],
	[3.20200E+04, 2.3782079429E+01, 5.3838851064E+00, 8.4952075965E+00, 2.8943445196E+00, 9.3235328672E-01],
	[3.20250E+04, 2.3788309193E+01, 5.3838874378E+00, 8.4995546444E+00, 2.8949419065E+00, 9.3238716034E-01],
	[3.20300E+04, 2.3794539616E+01, 5.3838897688E+00, 8.5039032375E+00, 2.8955391645E+00, 9.3242101674E-01],
	[3.20350E+04, 2.3800770698E+01, 5.3838920994E+00, 8.5082533762E+00, 2.8961362935E+00, 9.3245485593E-01],
	[3.20400E+04, 2.3807002439E+01, 5.3838944297E+00, 8.5126050607E+00, 2.8967332936E+00, 9.3248867790E-01],
	[3.20450E+04, 2.3813234839E+01, 5.3838967596E+00, 8.5169582914E+00, 2.8973301647E+00, 9.3252248266E-01],
	[3.20500E+04, 2.3819467898E+01, 5.3838990892E+00, 8.5213130686E+00, 2.8979269068E+00, 9.3255627024E-01],
	[3.20550E+04, 2.3825701615E+01, 5.3839014184E+00, 8.5256693925E+00, 2.8985235199E+00, 9.3259004062E-01],
	[3.20600E+04, 2.3831935991E+01, 5.3839037472E+00, 8.5300272636E+00, 2.8991200040E+00, 9.3262379383E-01],
	[3.20650E+04, 2.3838171026E+01, 5.3839060757E+00, 8.5343866821E+00, 2.8997163590E+00, 9.3265752988E-01],
	[3.20700E+04, 2.3844406719E+01, 5.3839084038E+00, 8.5387476482E+00, 2.9003125851E+00, 9.3269124876E-01],
	[3.20750E+04, 2.3850643072E+01, 5.3839107316E+00, 8.5431101624E+00, 2.9009086821E+00, 9.3272495048E-01],
	[3.20800E+04, 2.3856880082E+01, 5.3839130590E+00, 8.5474742249E+00, 2.9015046500E+00, 9.3275863506E-01],
	[3.20850E+04, 2.3863117752E+01, 5.3839153860E+00, 8.5518398361E+00, 2.9021004888E+00, 9.3279230251E-01],
	[3.20900E+04, 2.3869356080E+01, 5.3839177127E+00, 8.5562069962E+00, 2.9026961986E+00, 9.3282595283E-01],
	[3.20950E+04, 2.3875595066E+01, 5.3839200390E+00, 8.5605757055E+00, 2.9032917793E+00, 9.3285958603E-01],
	[3.21000E+04, 2.3881834711E+01, 5.3839223649E+00, 8.5649459644E+00, 2.9038872308E+00, 9.3289320212E-01],
	[3.21050E+04, 2.3888075015E+01, 5.3839246905E+00, 8.5693177732E+00, 2.9044825532E+00, 9.3292680110E-01],
	[3.21100E+04, 2.3894315977E+01, 5.3839270157E+00, 8.5736911321E+00, 2.9050777466E+00, 9.3296038299E-01],
	[3.21150E+04, 2.3900557597E+01, 5.3839293406E+00, 8.5780660415E+00, 2.9056728107E+00, 9.3299394779E-01],
	[3.21200E+04, 2.3906799875E+01, 5.3839316651E+00, 8.5824425017E+00, 2.9062677457E+00, 9.3302749552E-01],
	[3.21250E+04, 2.3913042812E+01, 5.3839339892E+00, 8.5868205131E+00, 2.9068625515E+00, 9.3306102618E-01],
	[3.21300E+04, 2.3919286408E+01, 5.3839363130E+00, 8.5912000758E+00, 2.9074572282E+00, 9.3309453977E-01],
	[3.21350E+04, 2.3925530661E+01, 5.3839386364E+00, 8.5955811902E+00, 2.9080517757E+00, 9.3312803631E-01],
	[3.21400E+04, 2.3931775573E+01, 5.3839409595E+00, 8.5999638567E+00, 2.9086461939E+00, 9.3316151581E-01],
	[3.21450E+04, 2.3938021143E+01, 5.3839432822E+00, 8.6043480754E+00, 2.9092404830E+00, 9.3319497827E-01],
	[3.21500E+04, 2.3944267371E+01, 5.3839456045E+00, 8.6087338469E+00, 2.9098346428E+00, 9.3322842370E-01],
	[3.21550E+04, 2.3950514257E+01, 5.3839479265E+00, 8.6131211713E+00, 2.9104286734E+00, 9.3326185211E-01],
	[3.21600E+04, 2.3956761801E+01, 5.3839502481E+00, 8.6175100489E+00, 2.9110225747E+00, 9.3329526351E-01],
	[3.21650E+04, 2.3963010003E+01, 5.3839525694E+00, 8.6219004801E+00, 2.9116163468E+00, 9.3332865791E-01],
	[3.21700E+04, 2.3969258864E+01, 5.3839548903E+00, 8.6262924652E+00, 2.9122099896E+00, 9.3336203531E-01],
	[3.21750E+04, 2.3975508382E+01, 5.3839572108E+00, 8.6306860044E+00, 2.9128035031E+00, 9.3339539572E-01],
	[3.21800E+04, 2.3981758558E+01, 5.3839595310E+00, 8.6350810982E+00, 2.9133968873E+00, 9.3342873916E-01],
	[3.21850E+04, 2.3988009393E+01, 5.3839618508E+00, 8.6394777467E+00, 2.9139901422E+00, 9.3346206563E-01],
	[3.21900E+04, 2.3994260885E+01, 5.3839641703E+00, 8.6438759503E+00, 2.9145832678E+00, 9.3349537513E-01],
	[3.21950E+04, 2.4000513035E+01, 5.3839664894E+00, 8.6482757094E+00, 2.9151762641E+00, 9.3352866768E-01],
	[3.22000E+04, 2.4006765842E+01, 5.3839688081E+00, 8.6526770242E+00, 2.9157691311E+00, 9.3356194329E-01],
	[3.22050E+04, 2.4013019308E+01, 5.3839711265E+00, 8.6570798950E+00, 2.9163618686E+00, 9.3359520196E-01],
	[3.22100E+04, 2.4019273431E+01, 5.3839734445E+00, 8.6614843222E+00, 2.9169544769E+00, 9.3362844370E-01],
	[3.22150E+04, 2.4025528212E+01, 5.3839757622E+00, 8.6658903060E+00, 2.9175469557E+00, 9.3366166852E-01],
	[3.22200E+04, 2.4031783651E+01, 5.3839780795E+00, 8.6702978467E+00, 2.9181393052E+00, 9.3369487642E-01],
	[3.22250E+04, 2.4038039748E+01, 5.3839803964E+00, 8.6747069448E+00, 2.9187315253E+00, 9.3372806743E-01],
	[3.22300E+04, 2.4044296502E+01, 5.3839827130E+00, 8.6791176004E+00, 2.9193236160E+00, 9.3376124154E-01],
	[3.22350E+04, 2.4050553913E+01, 5.3839850292E+00, 8.6835298139E+00, 2.9199155772E+00, 9.3379439876E-01],
	[3.22400E+04, 2.4056811983E+01, 5.3839873451E+00, 8.6879435855E+00, 2.9205074091E+00, 9.3382753910E-01],
	[3.22450E+04, 2.4063070709E+01, 5.3839896606E+00, 8.6923589157E+00, 2.9210991115E+00, 9.3386066257E-01],
	[3.22500E+04, 2.4069330094E+01, 5.3839919758E+00, 8.6967758047E+00, 2.9216906845E+00, 9.3389376918E-01],
	[3.22550E+04, 2.4075590135E+01, 5.3839942906E+00, 8.7011942528E+00, 2.9222821280E+00, 9.3392685894E-01],
	[3.22600E+04, 2.4081850835E+01, 5.3839966050E+00, 8.7056142603E+00, 2.9228734420E+00, 9.3395993185E-01],
	[3.22650E+04, 2.4088112191E+01, 5.3839989191E+00, 8.7100358276E+00, 2.9234646266E+00, 9.3399298792E-01],
	[3.22700E+04, 2.4094374205E+01, 5.3840012328E+00, 8.7144589549E+00, 2.9240556816E+00, 9.3402602717E-01],
	[3.22750E+04, 2.4100636876E+01, 5.3840035462E+00, 8.7188836425E+00, 2.9246466072E+00, 9.3405904959E-01],
	[3.22800E+04, 2.4106900205E+01, 5.3840058592E+00, 8.7233098908E+00, 2.9252374033E+00, 9.3409205521E-01],
	[3.22850E+04, 2.4113164191E+01, 5.3840081718E+00, 8.7277377001E+00, 2.9258280699E+00, 9.3412504401E-01],
	[3.22900E+04, 2.4119428834E+01, 5.3840104841E+00, 8.7321670707E+00, 2.9264186069E+00, 9.3415801603E-01],
	[3.22950E+04, 2.4125694134E+01, 5.3840127961E+00, 8.7365980028E+00, 2.9270090144E+00, 9.3419097125E-01],
	[3.23000E+04, 2.4131960092E+01, 5.3840151077E+00, 8.7410304968E+00, 2.9275992923E+00, 9.3422390970E-01],
	[3.23050E+04, 2.4138226706E+01, 5.3840174189E+00, 8.7454645531E+00, 2.9281894407E+00, 9.3425683137E-01],
	[3.23100E+04, 2.4144493978E+01, 5.3840197297E+00, 8.7499001718E+00, 2.9287794595E+00, 9.3428973628E-01],
	[3.23150E+04, 2.4150761907E+01, 5.3840220403E+00, 8.7543373534E+00, 2.9293693488E+00, 9.3432262444E-01],
	[3.23200E+04, 2.4157030493E+01, 5.3840243504E+00, 8.7587760981E+00, 2.9299591084E+00, 9.3435549585E-01],
	[3.23250E+04, 2.4163299735E+01, 5.3840266602E+00, 8.7632164062E+00, 2.9305487385E+00, 9.3438835052E-01],
	[3.23300E+04, 2.4169569635E+01, 5.3840289697E+00, 8.7676582781E+00, 2.9311382389E+00, 9.3442118847E-01],
	[3.23350E+04, 2.4175840192E+01, 5.3840312787E+00, 8.7721017140E+00, 2.9317276097E+00, 9.3445400968E-01],
	[3.23400E+04, 2.4182111405E+01, 5.3840335875E+00, 8.7765467143E+00, 2.9323168510E+00, 9.3448681418E-01],
	[3.23450E+04, 2.4188383276E+01, 5.3840358958E+00, 8.7809932792E+00, 2.9329059625E+00, 9.3451960197E-01],
	[3.23500E+04, 2.4194655803E+01, 5.3840382039E+00, 8.7854414092E+00, 2.9334949444E+00, 9.3455237306E-01],
	[3.23550E+04, 2.4200928988E+01, 5.3840405115E+00, 8.7898911044E+00, 2.9340837967E+00, 9.3458512745E-01],
	[3.23600E+04, 2.4207202828E+01, 5.3840428188E+00, 8.7943423653E+00, 2.9346725193E+00, 9.3461786516E-01],
	[3.23650E+04, 2.4213477326E+01, 5.3840451258E+00, 8.7987951920E+00, 2.9352611122E+00, 9.3465058618E-01],
	[3.23700E+04, 2.4219752481E+01, 5.3840474324E+00, 8.8032495850E+00, 2.9358495755E+00, 9.3468329054E-01],
	[3.23750E+04, 2.4226028292E+01, 5.3840497386E+00, 8.8077055444E+00, 2.9364379090E+00, 9.3471597823E-01],
	[3.23800E+04, 2.4232304759E+01, 5.3840520445E+00, 8.8121630708E+00, 2.9370261129E+00, 9.3474864926E-01],
	[3.23850E+04, 2.4238581884E+01, 5.3840543500E+00, 8.8166221642E+00, 2.9376141870E+00, 9.3478130364E-01],
	[3.23900E+04, 2.4244859665E+01, 5.3840566552E+00, 8.8210828251E+00, 2.9382021315E+00, 9.3481394137E-01],
	[3.23950E+04, 2.4251138102E+01, 5.3840589600E+00, 8.8255450538E+00, 2.9387899461E+00, 9.3484656248E-01],
	[3.24000E+04, 2.4257417196E+01, 5.3840612645E+00, 8.8300088505E+00, 2.9393776311E+00, 9.3487916695E-01],
	[3.24050E+04, 2.4263696946E+01, 5.3840635686E+00, 8.8344742157E+00, 2.9399651863E+00, 9.3491175480E-01],
	[3.24100E+04, 2.4269977353E+01, 5.3840658724E+00, 8.8389411495E+00, 2.9405526117E+00, 9.3494432604E-01],
	[3.24150E+04, 2.4276258417E+01, 5.3840681758E+00, 8.8434096523E+00, 2.9411399074E+00, 9.3497688068E-01],
	[3.24200E+04, 2.4282540136E+01, 5.3840704788E+00, 8.8478797244E+00, 2.9417270733E+00, 9.3500941871E-01],
	[3.24250E+04, 2.4288822513E+01, 5.3840727815E+00, 8.8523513661E+00, 2.9423141095E+00, 9.3504194016E-01],
	[3.24300E+04, 2.4295105545E+01, 5.3840750838E+00, 8.8568245777E+00, 2.9429010158E+00, 9.3507444502E-01],
	[3.24350E+04, 2.4301389234E+01, 5.3840773858E+00, 8.8612993596E+00, 2.9434877923E+00, 9.3510693330E-01],
	[3.24400E+04, 2.4307673578E+01, 5.3840796875E+00, 8.8657757120E+00, 2.9440744390E+00, 9.3513940502E-01],
	[3.24450E+04, 2.4313958580E+01, 5.3840819887E+00, 8.8702536353E+00, 2.9446609559E+00, 9.3517186017E-01],
	[3.24500E+04, 2.4320244237E+01, 5.3840842897E+00, 8.8747331297E+00, 2.9452473430E+00, 9.3520429878E-01],
	[3.24550E+04, 2.4326530550E+01, 5.3840865902E+00, 8.8792141956E+00, 2.9458336002E+00, 9.3523672083E-01],
	[3.24600E+04, 2.4332817520E+01, 5.3840888904E+00, 8.8836968333E+00, 2.9464197276E+00, 9.3526912635E-01],
	[3.24650E+04, 2.4339105146E+01, 5.3840911903E+00, 8.8881810430E+00, 2.9470057252E+00, 9.3530151533E-01],
	[3.24700E+04, 2.4345393428E+01, 5.3840934898E+00, 8.8926668252E+00, 2.9475915929E+00, 9.3533388779E-01],
	[3.24750E+04, 2.4351682365E+01, 5.3840957890E+00, 8.8971541800E+00, 2.9481773307E+00, 9.3536624374E-01],
	[3.24800E+04, 2.4357971959E+01, 5.3840980878E+00, 8.9016431079E+00, 2.9487629386E+00, 9.3539858317E-01],
	[3.24850E+04, 2.4364262209E+01, 5.3841003862E+00, 8.9061336091E+00, 2.9493484166E+00, 9.3543090611E-01],
	[3.24900E+04, 2.4370553115E+01, 5.3841026843E+00, 8.9106256839E+00, 2.9499337648E+00, 9.3546321255E-01],
	[3.24950E+04, 2.4376844676E+01, 5.3841049821E+00, 8.9151193327E+00, 2.9505189830E+00, 9.3549550250E-01],
	[3.25000E+04, 2.4383136894E+01, 5.3841072795E+00, 8.9196145557E+00, 2.9511040714E+00, 9.3552777597E-01],
	[3.25050E+04, 2.4389429767E+01, 5.3841095765E+00, 8.9241113533E+00, 2.9516890298E+00, 9.3556003298E-01],
	[3.25100E+04, 2.4395723296E+01, 5.3841118732E+00, 8.9286097257E+00, 2.9522738583E+00, 9.3559227351E-01],
	[3.25150E+04, 2.4402017481E+01, 5.3841141695E+00, 8.9331096733E+00, 2.9528585568E+00, 9.3562449760E-01],
	[3.25200E+04, 2.4408312321E+01, 5.3841164655E+00, 8.9376111964E+00, 2.9534431254E+00, 9.3565670523E-01],
	[3.25250E+04, 2.4414607818E+01, 5.3841187612E+00, 8.9421142954E+00, 2.9540275641E+00, 9.3568889642E-01],
	[3.25300E+04, 2.4420903969E+01, 5.3841210564E+00, 8.9466189704E+00, 2.9546118728E+00, 9.3572107117E-01],
	[3.25350E+04, 2.4427200777E+01, 5.3841233514E+00, 8.9511252218E+00, 2.9551960515E+00, 9.3575322950E-01],
	[3.25400E+04, 2.4433498240E+01, 5.3841256459E+00, 8.9556330499E+00, 2.9557801003E+00, 9.3578537141E-01],
	[3.25450E+04, 2.4439796359E+01, 5.3841279402E+00, 8.9601424551E+00, 2.9563640191E+00, 9.3581749691E-01],
	[3.25500E+04, 2.4446095133E+01, 5.3841302340E+00, 8.9646534376E+00, 2.9569478078E+00, 9.3584960600E-01],
	[3.25550E+04, 2.4452394563E+01, 5.3841325276E+00, 8.9691659978E+00, 2.9575314666E+00, 9.3588169870E-01],
	[3.25600E+04, 2.4458694648E+01, 5.3841348207E+00, 8.9736801360E+00, 2.9581149954E+00, 9.3591377500E-01],
	[3.25650E+04, 2.4464995389E+01, 5.3841371136E+00, 8.9781958524E+00, 2.9586983942E+00, 9.3594583493E-01],
	[3.25700E+04, 2.4471296785E+01, 5.3841394060E+00, 8.9827131474E+00, 2.9592816629E+00, 9.3597787848E-01],
	[3.25750E+04, 2.4477598837E+01, 5.3841416982E+00, 8.9872320212E+00, 2.9598648016E+00, 9.3600990566E-01],
	[3.25800E+04, 2.4483901543E+01, 5.3841439899E+00, 8.9917524743E+00, 2.9604478103E+00, 9.3604191649E-01],
	[3.25850E+04, 2.4490204905E+01, 5.3841462813E+00, 8.9962745069E+00, 2.9610306890E+00, 9.3607391096E-01],
	[3.25900E+04, 2.4496508923E+01, 5.3841485724E+00, 9.0007981193E+00, 2.9616134375E+00, 9.3610588908E-01],
	[3.25950E+04, 2.4502813596E+01, 5.3841508631E+00, 9.0053233118E+00, 2.9621960561E+00, 9.3613785087E-01],
	[3.26000E+04, 2.4509118923E+01, 5.3841531535E+00, 9.0098500848E+00, 2.9627785445E+00, 9.3616979633E-01],
	[3.26050E+04, 2.4515424906E+01, 5.3841554435E+00, 9.0143784385E+00, 2.9633609029E+00, 9.3620172547E-01],
	[3.26100E+04, 2.4521731545E+01, 5.3841577332E+00, 9.0189083733E+00, 2.9639431312E+00, 9.3623363830E-01],
	[3.26150E+04, 2.4528038838E+01, 5.3841600225E+00, 9.0234398894E+00, 2.9645252294E+00, 9.3626553481E-01],
	[3.26200E+04, 2.4534346786E+01, 5.3841623114E+00, 9.0279729872E+00, 2.9651071976E+00, 9.3629741503E-01],
	[3.26250E+04, 2.4540655390E+01, 5.3841646001E+00, 9.0325076670E+00, 2.9656890356E+00, 9.3632927896E-01],
	[3.26300E+04, 2.4546964648E+01, 5.3841668883E+00, 9.0370439291E+00, 2.9662707435E+00, 9.3636112660E-01],
	[3.26350E+04, 2.4553274562E+01, 5.3841691762E+00, 9.0415817738E+00, 2.9668523213E+00, 9.3639295796E-01],
	[3.26400E+04, 2.4559585130E+01, 5.3841714638E+00, 9.0461212014E+00, 2.9674337690E+00, 9.3642477306E-01],
	[3.26450E+04, 2.4565896353E+01, 5.3841737510E+00, 9.0506622122E+00, 2.9680150866E+00, 9.3645657189E-01],
	[3.26500E+04, 2.4572208232E+01, 5.3841760379E+00, 9.0552048065E+00, 2.9685962740E+00, 9.3648835447E-01],
	[3.26550E+04, 2.4578520765E+01, 5.3841783244E+00, 9.0597489847E+00, 2.9691773312E+00, 9.3652012080E-01],
	[3.26600E+04, 2.4584833953E+01, 5.3841806106E+00, 9.0642947471E+00, 2.9697582584E+00, 9.3655187090E-01],
	[3.26650E+04, 2.4591147795E+01, 5.3841828964E+00, 9.0688420939E+00, 2.9703390553E+00, 9.3658360476E-01],
	[3.26700E+04, 2.4597462293E+01, 5.3841851819E+00, 9.0733910254E+00, 2.9709197221E+00, 9.3661532239E-01],
	[3.26750E+04, 2.4603777445E+01, 5.3841874670E+00, 9.0779415421E+00, 2.9715002588E+00, 9.3664702381E-01],
	[3.26800E+04, 2.4610093252E+01, 5.3841897518E+00, 9.0824936441E+00, 2.9720806652E+00, 9.3667870903E-01],
	[3.26850E+04, 2.4616409713E+01, 5.3841920362E+00, 9.0870473319E+00, 2.9726609415E+00, 9.3671037803E-01],
	[3.26900E+04, 2.4622726830E+01, 5.3841943203E+00, 9.0916026056E+00, 2.9732410876E+00, 9.3674203085E-01],
	[3.26950E+04, 2.4629044600E+01, 5.3841966040E+00, 9.0961594657E+00, 2.9738211035E+00, 9.3677366748E-01],
	[3.27000E+04, 2.4635363026E+01, 5.3841988874E+00, 9.1007179124E+00, 2.9744009892E+00, 9.3680528793E-01],
	[3.27050E+04, 2.4641682106E+01, 5.3842011704E+00, 9.1052779460E+00, 2.9749807447E+00, 9.3683689220E-01],
	[3.27100E+04, 2.4648001840E+01, 5.3842034531E+00, 9.1098395669E+00, 2.9755603699E+00, 9.3686848032E-01],
	[3.27150E+04, 2.4654322229E+01, 5.3842057354E+00, 9.1144027753E+00, 2.9761398650E+00, 9.3690005228E-01],
	[3.27200E+04, 2.4660643272E+01, 5.3842080174E+00, 9.1189675716E+00, 2.9767192298E+00, 9.3693160808E-01],
	[3.27250E+04, 2.4666964970E+01, 5.3842102991E+00, 9.1235339561E+00, 2.9772984644E+00, 9.3696314775E-01],
	[3.27300E+04, 2.4673287322E+01, 5.3842125804E+00, 9.1281019291E+00, 2.9778775687E+00, 9.3699467129E-01],
	[3.27350E+04, 2.4679610328E+01, 5.3842148613E+00, 9.1326714908E+00, 2.9784565428E+00, 9.3702617869E-01],
	[3.27400E+04, 2.4685933989E+01, 5.3842171419E+00, 9.1372426417E+00, 2.9790353867E+00, 9.3705766998E-01],
	[3.27450E+04, 2.4692258304E+01, 5.3842194222E+00, 9.1418153820E+00, 2.9796141003E+00, 9.3708914516E-01],
	[3.27500E+04, 2.4698583273E+01, 5.3842217021E+00, 9.1463897120E+00, 2.9801926836E+00, 9.3712060423E-01],
	[3.27550E+04, 2.4704908897E+01, 5.3842239816E+00, 9.1509656320E+00, 2.9807711367E+00, 9.3715204721E-01],
	[3.27600E+04, 2.4711235174E+01, 5.3842262608E+00, 9.1555431424E+00, 2.9813494594E+00, 9.3718347410E-01],
	[3.27650E+04, 2.4717562106E+01, 5.3842285397E+00, 9.1601222434E+00, 2.9819276519E+00, 9.3721488491E-01],
	[3.27700E+04, 2.4723889692E+01, 5.3842308182E+00, 9.1647029355E+00, 2.9825057142E+00, 9.3724627964E-01],
	[3.27750E+04, 2.4730217932E+01, 5.3842330964E+00, 9.1692852187E+00, 2.9830836461E+00, 9.3727765831E-01],
	[3.27800E+04, 2.4736546826E+01, 5.3842353742E+00, 9.1738690936E+00, 2.9836614477E+00, 9.3730902092E-01],
	[3.27850E+04, 2.4742876374E+01, 5.3842376517E+00, 9.1784545604E+00, 2.9842391190E+00, 9.3734036748E-01],
	[3.27900E+04, 2.4749206576E+01, 5.3842399288E+00, 9.1830416193E+00, 2.9848166600E+00, 9.3737169800E-01],
	[3.27950E+04, 2.4755537432E+01, 5.3842422056E+00, 9.1876302708E+00, 2.9853940707E+00, 9.3740301248E-01],
	[3.28000E+04, 2.4761868942E+01, 5.3842444820E+00, 9.1922205151E+00, 2.9859713511E+00, 9.3743431093E-01],
	[3.28050E+04, 2.4768201105E+01, 5.3842467581E+00, 9.1968123526E+00, 2.9865485012E+00, 9.3746559336E-01],
	[3.28100E+04, 2.4774533923E+01, 5.3842490339E+00, 9.2014057834E+00, 2.9871255209E+00, 9.3749685978E-01],
	[3.28150E+04, 2.4780867395E+01, 5.3842513093E+00, 9.2060008081E+00, 2.9877024102E+00, 9.3752811020E-01],
	[3.28200E+04, 2.4787201520E+01, 5.3842535843E+00, 9.2105974268E+00, 2.9882791693E+00, 9.3755934461E-01],
	[3.28250E+04, 2.4793536299E+01, 5.3842558590E+00, 9.2151956399E+00, 2.9888557980E+00, 9.3759056304E-01],
	[3.28300E+04, 2.4799871732E+01, 5.3842581334E+00, 9.2197954476E+00, 2.9894322963E+00, 9.3762176548E-01],
	[3.28350E+04, 2.4806207818E+01, 5.3842604074E+00, 9.2243968504E+00, 2.9900086643E+00, 9.3765295195E-01],
	[3.28400E+04, 2.4812544558E+01, 5.3842626811E+00, 9.2289998484E+00, 2.9905849019E+00, 9.3768412246E-01],
	[3.28450E+04, 2.4818881952E+01, 5.3842649544E+00, 9.2336044421E+00, 2.9911610091E+00, 9.3771527700E-01],
	[3.28500E+04, 2.4825219999E+01, 5.3842672274E+00, 9.2382106317E+00, 2.9917369860E+00, 9.3774641559E-01],
	[3.28550E+04, 2.4831558700E+01, 5.3842695000E+00, 9.2428184175E+00, 2.9923128325E+00, 9.3777753823E-01],
	[3.28600E+04, 2.4837898055E+01, 5.3842717723E+00, 9.2474277999E+00, 2.9928885486E+00, 9.3780864494E-01],
	[3.28650E+04, 2.4844238063E+01, 5.3842740443E+00, 9.2520387792E+00, 2.9934641343E+00, 9.3783973571E-01],
	[3.28700E+04, 2.4850578724E+01, 5.3842763159E+00, 9.2566513556E+00, 2.9940395897E+00, 9.3787081057E-01],
	[3.28750E+04, 2.4856920039E+01, 5.3842785871E+00, 9.2612655294E+00, 2.9946149146E+00, 9.3790186951E-01],
	[3.28800E+04, 2.4863262007E+01, 5.3842808580E+00, 9.2658813011E+00, 2.9951901091E+00, 9.3793291255E-01],
	[3.28850E+04, 2.4869604629E+01, 5.3842831286E+00, 9.2704986709E+00, 2.9957651732E+00, 9.3796393968E-01],
	[3.28900E+04, 2.4875947904E+01, 5.3842853988E+00, 9.2751176390E+00, 2.9963401069E+00, 9.3799495092E-01],
	[3.28950E+04, 2.4882291832E+01, 5.3842876687E+00, 9.2797382059E+00, 2.9969149102E+00, 9.3802594628E-01],
	[3.29000E+04, 2.4888636414E+01, 5.3842899383E+00, 9.2843603718E+00, 2.9974895831E+00, 9.3805692577E-01],
	[3.29050E+04, 2.4894981648E+01, 5.3842922074E+00, 9.2889841370E+00, 2.9980641255E+00, 9.3808788938E-01],
	[3.29100E+04, 2.4901327536E+01, 5.3842944763E+00, 9.2936095019E+00, 2.9986385375E+00, 9.3811883713E-01],
	[3.29150E+04, 2.4907674078E+01, 5.3842967448E+00, 9.2982364668E+00, 2.9992128191E+00, 9.3814976903E-01],
	[3.29200E+04, 2.4914021272E+01, 5.3842990130E+00, 9.3028650319E+00, 2.9997869702E+00, 9.3818068508E-01],
	[3.29250E+04, 2.4920369120E+01, 5.3843012808E+00, 9.3074951976E+00, 3.0003609909E+00, 9.3821158530E-01],
	[3.29300E+04, 2.4926717620E+01, 5.3843035483E+00, 9.3121269642E+00, 3.0009348811E+00, 9.3824246968E-01],
	[3.29350E+04, 2.4933066774E+01, 5.3843058154E+00, 9.3167603319E+00, 3.0015086409E+00, 9.3827333824E-01],
	[3.29400E+04, 2.4939416581E+01, 5.3843080822E+00, 9.3213953012E+00, 3.0020822702E+00, 9.3830419098E-01],
	[3.29450E+04, 2.4945767040E+01, 5.3843103486E+00, 9.3260318723E+00, 3.0026557690E+00, 9.3833502792E-01],
	[3.29500E+04, 2.4952118153E+01, 5.3843126147E+00, 9.3306700456E+00, 3.0032291374E+00, 9.3836584905E-01],
	[3.29550E+04, 2.4958469918E+01, 5.3843148805E+00, 9.3353098212E+00, 3.0038023753E+00, 9.3839665439E-01],
	[3.29600E+04, 2.4964822337E+01, 5.3843171459E+00, 9.3399511997E+00, 3.0043754828E+00, 9.3842744395E-01],
	[3.29650E+04, 2.4971175408E+01, 5.3843194110E+00, 9.3445941811E+00, 3.0049484597E+00, 9.3845821773E-01],
	[3.29700E+04, 2.4977529132E+01, 5.3843216757E+00, 9.3492387660E+00, 3.0055213062E+00, 9.3848897574E-01],
	[3.29750E+04, 2.4983883509E+01, 5.3843239401E+00, 9.3538849545E+00, 3.0060940222E+00, 9.3851971798E-01],
	[3.29800E+04, 2.4990238539E+01, 5.3843262041E+00, 9.3585327470E+00, 3.0066666077E+00, 9.3855044447E-01],
	[3.29850E+04, 2.4996594221E+01, 5.3843284678E+00, 9.3631821439E+00, 3.0072390627E+00, 9.3858115522E-01],
	[3.29900E+04, 2.5002950557E+01, 5.3843307312E+00, 9.3678331453E+00, 3.0078113872E+00, 9.3861185022E-01],
	[3.29950E+04, 2.5009307544E+01, 5.3843329942E+00, 9.3724857517E+00, 3.0083835812E+00, 9.3864252949E-01],
	[3.30000E+04, 2.5015665185E+01, 5.3843352569E+00, 9.3771399633E+00, 3.0089556447E+00, 9.3867319304E-01],
	[3.30050E+04, 2.5022023478E+01, 5.3843375192E+00, 9.3817957804E+00, 3.0095275777E+00, 9.3870384087E-01],
	[3.30100E+04, 2.5028382424E+01, 5.3843397812E+00, 9.3864532034E+00, 3.0100993801E+00, 9.3873447299E-01],
	[3.30150E+04, 2.5034769228E+01, 5.3843458307E+00, 9.3911122326E+00, 3.0106726298E+00, 9.3876508941E-01],
	[3.30200E+04, 2.5041181351E+01, 5.3843553112E+00, 9.3957728682E+00, 3.0112471797E+00, 9.3879569013E-01],
	[3.30250E+04, 2.5047594146E+01, 5.3843647902E+00, 9.4004351106E+00, 3.0118216005E+00, 9.3882627517E-01],
	[3.30300E+04, 2.5054007611E+01, 5.3843742679E+00, 9.4050989602E+00, 3.0123958922E+00, 9.3885684453E-01],
	[3.30350E+04, 2.5060421748E+01, 5.3843837441E+00, 9.4097644171E+00, 3.0129700548E+00, 9.3888739821E-01],
	[3.30400E+04, 2.5066836555E+01, 5.3843932189E+00, 9.4144314817E+00, 3.0135440883E+00, 9.3891793624E-01],
	[3.30450E+04, 2.5073252034E+01, 5.3844026923E+00, 9.4191001544E+00, 3.0141179927E+00, 9.3894845860E-01],
	[3.30500E+04, 2.5079668183E+01, 5.3844121642E+00, 9.4237704354E+00, 3.0146917681E+00, 9.3897896532E-01],
	[3.30550E+04, 2.5086085003E+01, 5.3844216348E+00, 9.4284423251E+00, 3.0152654143E+00, 9.3900945640E-01],
	[3.30600E+04, 2.5092502494E+01, 5.3844311039E+00, 9.4331158237E+00, 3.0158389314E+00, 9.3903993184E-01],
	[3.30650E+04, 2.5098920656E+01, 5.3844405716E+00, 9.4377909316E+00, 3.0164123194E+00, 9.3907039166E-01],
	[3.30700E+04, 2.5105339489E+01, 5.3844500380E+00, 9.4424676490E+00, 3.0169855783E+00, 9.3910083586E-01],
	[3.30750E+04, 2.5111758992E+01, 5.3844595029E+00, 9.4471459764E+00, 3.0175587081E+00, 9.3913126445E-01],
	[3.30800E+04, 2.5118179167E+01, 5.3844689663E+00, 9.4518259140E+00, 3.0181317087E+00, 9.3916167744E-01],
	[3.30850E+04, 2.5124600012E+01, 5.3844784284E+00, 9.4565074621E+00, 3.0187045802E+00, 9.3919207483E-01],
	[3.30900E+04, 2.5131021527E+01, 5.3844878890E+00, 9.4611906210E+00, 3.0192773226E+00, 9.3922245663E-01],
	[3.30950E+04, 2.5137443714E+01, 5.3844973483E+00, 9.4658753910E+00, 3.0198499358E+00, 9.3925282286E-01],
	[3.31000E+04, 2.5143866570E+01, 5.3845068061E+00, 9.4705617725E+00, 3.0204224199E+00, 9.3928317351E-01],
	[3.31050E+04, 2.5150290098E+01, 5.3845162625E+00, 9.4752497657E+00, 3.0209947749E+00, 9.3931350860E-01],
	[3.31100E+04, 2.5156714296E+01, 5.3845257175E+00, 9.4799393710E+00, 3.0215670007E+00, 9.3934382813E-01],
	[3.31150E+04, 2.5163139165E+01, 5.3845351711E+00, 9.4846305887E+00, 3.0221390974E+00, 9.3937413210E-01],
	[3.31200E+04, 2.5169564704E+01, 5.3845446233E+00, 9.4893234191E+00, 3.0227110649E+00, 9.3940442054E-01],
	[3.31250E+04, 2.5175990913E+01, 5.3845540741E+00, 9.4940178625E+00, 3.0232829033E+00, 9.3943469345E-01],
	[3.31300E+04, 2.5182417793E+01, 5.3845635234E+00, 9.4987139192E+00, 3.0238546125E+00, 9.3946495082E-01],
	[3.31350E+04, 2.5188845343E+01, 5.3845729714E+00, 9.5034115895E+00, 3.0244261925E+00, 9.3949519268E-01],
	[3.31400E+04, 2.5195273564E+01, 5.3845824179E+00, 9.5081108737E+00, 3.0249976434E+00, 9.3952541903E-01],
	[3.31450E+04, 2.5201702455E+01, 5.3845918631E+00, 9.5128117722E+00, 3.0255689651E+00, 9.3955562987E-01],
	[3.31500E+04, 2.5208132016E+01, 5.3846013068E+00, 9.5175142852E+00, 3.0261401576E+00, 9.3958582521E-01],
	[3.31550E+04, 2.5214562248E+01, 5.3846107491E+00, 9.5222184131E+00, 3.0267112210E+00, 9.3961600507E-01],
	[3.31600E+04, 2.5220993150E+01, 5.3846201900E+00, 9.5269241562E+00, 3.0272821551E+00, 9.3964616944E-01],
	[3.31650E+04, 2.5227424722E+01, 5.3846296295E+00, 9.5316315148E+00, 3.0278529601E+00, 9.3967631835E-01],
	[3.31700E+04, 2.5233856964E+01, 5.3846390676E+00, 9.5363404891E+00, 3.0284236359E+00, 9.3970645178E-01],
	[3.31750E+04, 2.5240289876E+01, 5.3846485043E+00, 9.5410510796E+00, 3.0289941825E+00, 9.3973656976E-01],
	[3.31800E+04, 2.5246723459E+01, 5.3846579396E+00, 9.5457632865E+00, 3.0295646000E+00, 9.3976667229E-01],
	[3.31850E+04, 2.5253157711E+01, 5.3846673735E+00, 9.5504771101E+00, 3.0301348882E+00, 9.3979675937E-01],
	[3.31900E+04, 2.5259592634E+01, 5.3846768060E+00, 9.5551925508E+00, 3.0307050472E+00, 9.3982683102E-01],
	[3.31950E+04, 2.5266028227E+01, 5.3846862370E+00, 9.5599096088E+00, 3.0312750770E+00, 9.3985688724E-01],
	[3.32000E+04, 2.5272464489E+01, 5.3846956667E+00, 9.5646282845E+00, 3.0318449777E+00, 9.3988692805E-01],
	[3.32050E+04, 2.5278901422E+01, 5.3847050950E+00, 9.5693485781E+00, 3.0324147491E+00, 9.3991695344E-01],
	[3.32100E+04, 2.5285339024E+01, 5.3847145218E+00, 9.5740704900E+00, 3.0329843913E+00, 9.3994696342E-01],
	[3.32150E+04, 2.5291777297E+01, 5.3847239473E+00, 9.5787940206E+00, 3.0335539043E+00, 9.3997695801E-01],
	[3.32200E+04, 2.5298216239E+01, 5.3847333714E+00, 9.5835191700E+00, 3.0341232881E+00, 9.4000693720E-01],
	[3.32250E+04, 2.5304655851E+01, 5.3847427940E+00, 9.5882459387E+00, 3.0346925427E+00, 9.4003690102E-01],
	[3.32300E+04, 2.5311096133E+01, 5.3847522153E+00, 9.5929743269E+00, 3.0352616680E+00, 9.4006684946E-01],
	[3.32350E+04, 2.5317537085E+01, 5.3847616351E+00, 9.5977043349E+00, 3.0358306641E+00, 9.4009678253E-01],
	[3.32400E+04, 2.5323978706E+01, 5.3847710536E+00, 9.6024359631E+00, 3.0363995310E+00, 9.4012670025E-01],
	[3.32450E+04, 2.5330420997E+01, 5.3847804706E+00, 9.6071692117E+00, 3.0369682687E+00, 9.4015660261E-01],
	[3.32500E+04, 2.5336863958E+01, 5.3847898863E+00, 9.6119040811E+00, 3.0375368771E+00, 9.4018648963E-01],
	[3.32550E+04, 2.5343307588E+01, 5.3847993005E+00, 9.6166405716E+00, 3.0381053564E+00, 9.4021636131E-01],
	[3.32600E+04, 2.5349751888E+01, 5.3848087134E+00, 9.6213786835E+00, 3.0386737063E+00, 9.4024621767E-01],
	[3.32650E+04, 2.5356196858E+01, 5.3848181248E+00, 9.6261184171E+00, 3.0392419271E+00, 9.4027605870E-01],
	[3.32700E+04, 2.5362642497E+01, 5.3848275349E+00, 9.6308597727E+00, 3.0398100186E+00, 9.4030588442E-01],
	[3.32750E+04, 2.5369088806E+01, 5.3848369436E+00, 9.6356027507E+00, 3.0403779808E+00, 9.4033569483E-01],
	[3.32800E+04, 2.5375535784E+01, 5.3848463508E+00, 9.6403473513E+00, 3.0409458139E+00, 9.4036548995E-01],
	[3.32850E+04, 2.5381983432E+01, 5.3848557567E+00, 9.6450935748E+00, 3.0415135176E+00, 9.4039526978E-01],
	[3.32900E+04, 2.5388431749E+01, 5.3848651611E+00, 9.6498414216E+00, 3.0420810922E+00, 9.4042503432E-01],
	[3.32950E+04, 2.5394880735E+01, 5.3848745642E+00, 9.6545908920E+00, 3.0426485374E+00, 9.4045478359E-01],
	[3.33000E+04, 2.5401330391E+01, 5.3848839659E+00, 9.6593419863E+00, 3.0432158535E+00, 9.4048451758E-01],
	[3.33050E+04, 2.5407780716E+01, 5.3848933662E+00, 9.6640947047E+00, 3.0437830402E+00, 9.4051423632E-01],
	[3.33100E+04, 2.5414231711E+01, 5.3849027651E+00, 9.6688490477E+00, 3.0443500977E+00, 9.4054393981E-01],
	[3.33150E+04, 2.5420683375E+01, 5.3849121626E+00, 9.6736050155E+00, 3.0449170260E+00, 9.4057362805E-01],
	[3.33200E+04, 2.5427135708E+01, 5.3849215587E+00, 9.6783626084E+00, 3.0454838250E+00, 9.4060330106E-01],
	[3.33250E+04, 2.5433588710E+01, 5.3849309534E+00, 9.6831218268E+00, 3.0460504947E+00, 9.4063295883E-01],
	[3.33300E+04, 2.5440042381E+01, 5.3849403467E+00, 9.6878826709E+00, 3.0466170352E+00, 9.4066260139E-01],
	[3.33350E+04, 2.5446496722E+01, 5.3849497386E+00, 9.6926451411E+00, 3.0471834464E+00, 9.4069222872E-01],
	[3.33400E+04, 2.5452951732E+01, 5.3849591291E+00, 9.6974092377E+00, 3.0477497283E+00, 9.4072184086E-01],
	[3.33450E+04, 2.5459407410E+01, 5.3849685183E+00, 9.7021749609E+00, 3.0483158810E+00, 9.4075143779E-01],
	[3.33500E+04, 2.5465863758E+01, 5.3849779060E+00, 9.7069423112E+00, 3.0488819044E+00, 9.4078101953E-01],
	[3.33550E+04, 2.5472320775E+01, 5.3849872924E+00, 9.7117112887E+00, 3.0494477985E+00, 9.4081058609E-01],
	[3.33600E+04, 2.5478778461E+01, 5.3849966773E+00, 9.7164818939E+00, 3.0500135634E+00, 9.4084013747E-01],
	[3.33650E+04, 2.5485236816E+01, 5.3850060609E+00, 9.7212541270E+00, 3.0505791989E+00, 9.4086967368E-01],
	[3.33700E+04, 2.5491695839E+01, 5.3850154431E+00, 9.7260279884E+00, 3.0511447052E+00, 9.4089919473E-01],
	[3.33750E+04, 2.5498155532E+01, 5.3850248239E+00, 9.7308034783E+00, 3.0517100823E+00, 9.4092870063E-01],
	[3.33800E+04, 2.5504615894E+01, 5.3850342033E+00, 9.7355805971E+00, 3.0522753300E+00, 9.4095819139E-01],
	[3.33850E+04, 2.5511076924E+01, 5.3850435813E+00, 9.7403593450E+00, 3.0528404485E+00, 9.4098766700E-01],
	[3.33900E+04, 2.5517538623E+01, 5.3850529579E+00, 9.7451397225E+00, 3.0534054377E+00, 9.4101712748E-01],
	[3.33950E+04, 2.5524000991E+01, 5.3850623332E+00, 9.7499217298E+00, 3.0539702975E+00, 9.4104657285E-01],
	[3.34000E+04, 2.5530464028E+01, 5.3850717070E+00, 9.7547053671E+00, 3.0545350282E+00, 9.4107600309E-01],
	[3.34050E+04, 2.5536927733E+01, 5.3850810795E+00, 9.7594906349E+00, 3.0550996295E+00, 9.4110541823E-01],
	[3.34100E+04, 2.5543392107E+01, 5.3850904506E+00, 9.7642775334E+00, 3.0556641015E+00, 9.4113481827E-01],
	[3.34150E+04, 2.5549857150E+01, 5.3850998203E+00, 9.7690660630E+00, 3.0562284443E+00, 9.4116420321E-01],
	[3.34200E+04, 2.5556322861E+01, 5.3851091886E+00, 9.7738562240E+00, 3.0567926577E+00, 9.4119357307E-01],
	[3.34250E+04, 2.5562789241E+01, 5.3851185555E+00, 9.7786480166E+00, 3.0573567419E+00, 9.4122292786E-01],
	[3.34300E+04, 2.5569256290E+01, 5.3851279210E+00, 9.7834414412E+00, 3.0579206968E+00, 9.4125226757E-01],
	[3.34350E+04, 2.5575724007E+01, 5.3851372852E+00, 9.7882364981E+00, 3.0584845224E+00, 9.4128159222E-01],
	[3.34400E+04, 2.5582192393E+01, 5.3851466480E+00, 9.7930331876E+00, 3.0590482186E+00, 9.4131090182E-01],
	[3.34450E+04, 2.5588661447E+01, 5.3851560094E+00, 9.7978315100E+00, 3.0596117856E+00, 9.4134019637E-01],
	[3.34500E+04, 2.5595131169E+01, 5.3851653694E+00, 9.8026314656E+00, 3.0601752233E+00, 9.4136947588E-01],
	[3.34550E+04, 2.5601601560E+01, 5.3851747280E+00, 9.8074330548E+00, 3.0607385317E+00, 9.4139874036E-01],
	[3.34600E+04, 2.5608072619E+01, 5.3851840852E+00, 9.8122362778E+00, 3.0613017108E+00, 9.4142798982E-01],
	[3.34650E+04, 2.5614544347E+01, 5.3851934411E+00, 9.8170411350E+00, 3.0618647606E+00, 9.4145722426E-01],
	[3.34700E+04, 2.5621016743E+01, 5.3852027955E+00, 9.8218476267E+00, 3.0624276812E+00, 9.4148644369E-01],
	[3.34750E+04, 2.5627489807E+01, 5.3852121486E+00, 9.8266557532E+00, 3.0629904724E+00, 9.4151564812E-01],
	[3.34800E+04, 2.5633963539E+01, 5.3852215004E+00, 9.8314655147E+00, 3.0635531343E+00, 9.4154483756E-01],
	[3.34850E+04, 2.5640437940E+01, 5.3852308507E+00, 9.8362769117E+00, 3.0641156669E+00, 9.4157401201E-01],
	[3.34900E+04, 2.5646913009E+01, 5.3852401996E+00, 9.8410899444E+00, 3.0646780702E+00, 9.4160317149E-01],
	[3.34950E+04, 2.5653388746E+01, 5.3852495472E+00, 9.8459046131E+00, 3.0652403442E+00, 9.4163231599E-01],
	[3.35000E+04, 2.5659865151E+01, 5.3852588934E+00, 9.8507209182E+00, 3.0658024889E+00, 9.4166144553E-01],
	[3.35050E+04, 2.5666342224E+01, 5.3852682382E+00, 9.8555388600E+00, 3.0663645043E+00, 9.4169056011E-01],
	[3.35100E+04, 2.5672819966E+01, 5.3852775817E+00, 9.8603584387E+00, 3.0669263904E+00, 9.4171965975E-01],
	[3.35150E+04, 2.5679298375E+01, 5.3852869237E+00, 9.8651796547E+00, 3.0674881472E+00, 9.4174874445E-01],
	[3.35200E+04, 2.5685777452E+01, 5.3852962644E+00, 9.8700025082E+00, 3.0680497746E+00, 9.4177781421E-01],
	[3.35250E+04, 2.5692257198E+01, 5.3853056037E+00, 9.8748269997E+00, 3.0686112728E+00, 9.4180686905E-01],
	[3.35300E+04, 2.5698737611E+01, 5.3853149416E+00, 9.8796531294E+00, 3.0691726417E+00, 9.4183590897E-01],
	[3.35350E+04, 2.5705218692E+01, 5.3853242782E+00, 9.8844808977E+00, 3.0697338813E+00, 9.4186493398E-01],
	[3.35400E+04, 2.5711700441E+01, 5.3853336134E+00, 9.8893103048E+00, 3.0702949915E+00, 9.4189394409E-01],
	[3.35450E+04, 2.5718182858E+01, 5.3853429472E+00, 9.8941413510E+00, 3.0708559725E+00, 9.4192293931E-01],
	[3.35500E+04, 2.5724665943E+01, 5.3853522796E+00, 9.8989740367E+00, 3.0714168241E+00, 9.4195191963E-01],
	[3.35550E+04, 2.5731149695E+01, 5.3853616107E+00, 9.9038083622E+00, 3.0719775465E+00, 9.4198088507E-01],
	[3.35600E+04, 2.5737634116E+01, 5.3853709403E+00, 9.9086443277E+00, 3.0725381395E+00, 9.4200983564E-01],
	[3.35650E+04, 2.5744119204E+01, 5.3853802686E+00, 9.9134819337E+00, 3.0730986033E+00, 9.4203877134E-01],
	[3.35700E+04, 2.5750604960E+01, 5.3853895956E+00, 9.9183211804E+00, 3.0736589377E+00, 9.4206769218E-01],
	[3.35750E+04, 2.5757091383E+01, 5.3853989211E+00, 9.9231620681E+00, 3.0742191428E+00, 9.4209659816E-01],
	[3.35800E+04, 2.5763578474E+01, 5.3854082453E+00, 9.9280045971E+00, 3.0747792186E+00, 9.4212548930E-01],
	[3.35850E+04, 2.5770066233E+01, 5.3854175681E+00, 9.9328487678E+00, 3.0753391651E+00, 9.4215436559E-01],
	[3.35900E+04, 2.5776554659E+01, 5.3854268896E+00, 9.9376945805E+00, 3.0758989823E+00, 9.4218322705E-01],
	[3.35950E+04, 2.5783043753E+01, 5.3854362096E+00, 9.9425420354E+00, 3.0764586702E+00, 9.4221207368E-01],
	[3.36000E+04, 2.5789533514E+01, 5.3854455283E+00, 9.9473911329E+00, 3.0770182288E+00, 9.4224090550E-01],
	[3.36050E+04, 2.5796023943E+01, 5.3854548457E+00, 9.9522418733E+00, 3.0775776581E+00, 9.4226972250E-01],
	[3.36100E+04, 2.5802515039E+01, 5.3854641616E+00, 9.9570942569E+00, 3.0781369581E+00, 9.4229852469E-01],
	[3.36150E+04, 2.5809006803E+01, 5.3854734762E+00, 9.9619482840E+00, 3.0786961288E+00, 9.4232731208E-01],
	[3.36200E+04, 2.5815499234E+01, 5.3854827894E+00, 9.9668039550E+00, 3.0792551702E+00, 9.4235608468E-01],
	[3.36250E+04, 2.5821992332E+01, 5.3854921013E+00, 9.9716612701E+00, 3.0798140822E+00, 9.4238484249E-01],
	[3.36300E+04, 2.5828486098E+01, 5.3855014118E+00, 9.9765202297E+00, 3.0803728650E+00, 9.4241358552E-01],
	[3.36350E+04, 2.5834980531E+01, 5.3855107209E+00, 9.9813808340E+00, 3.0809315185E+00, 9.4244231378E-01],
	[3.36400E+04, 2.5841475631E+01, 5.3855200286E+00, 9.9862430834E+00, 3.0814900426E+00, 9.4247102728E-01],
	[3.36450E+04, 2.5847971399E+01, 5.3855293350E+00, 9.9911069782E+00, 3.0820484375E+00, 9.4249972602E-01],
	[3.36500E+04, 2.5854467834E+01, 5.3855386400E+00, 9.9959725188E+00, 3.0826067031E+00, 9.4252841000E-01],
	[3.36550E+04, 2.5860964935E+01, 5.3855479437E+00, 1.0000839705E+01, 3.0831648393E+00, 9.4255707924E-01],
	[3.36600E+04, 2.5867462705E+01, 5.3855572460E+00, 1.0005708538E+01, 3.0837228463E+00, 9.4258573374E-01],
	[3.36650E+04, 2.5873961141E+01, 5.3855665469E+00, 1.0010579018E+01, 3.0842807239E+00, 9.4261437351E-01],
	[3.36700E+04, 2.5880460244E+01, 5.3855758464E+00, 1.0015451144E+01, 3.0848384723E+00, 9.4264299856E-01],
	[3.36750E+04, 2.5886960014E+01, 5.3855851446E+00, 1.0020324918E+01, 3.0853960914E+00, 9.4267160888E-01],
	[3.36800E+04, 2.5893460452E+01, 5.3855944414E+00, 1.0025200339E+01, 3.0859535811E+00, 9.4270020450E-01],
	[3.36850E+04, 2.5899961556E+01, 5.3856037369E+00, 1.0030077408E+01, 3.0865109416E+00, 9.4272878541E-01],
	[3.36900E+04, 2.5906463327E+01, 5.3856130310E+00, 1.0034956126E+01, 3.0870681728E+00, 9.4275735163E-01],
	[3.36950E+04, 2.5912965766E+01, 5.3856223237E+00, 1.0039836492E+01, 3.0876252747E+00, 9.4278590316E-01],
	[3.37000E+04, 2.5919468871E+01, 5.3856316151E+00, 1.0044718506E+01, 3.0881822473E+00, 9.4281444000E-01],
	[3.37050E+04, 2.5925972643E+01, 5.3856409051E+00, 1.0049602170E+01, 3.0887390906E+00, 9.4284296217E-01],
	[3.37100E+04, 2.5932477082E+01, 5.3856501937E+00, 1.0054487484E+01, 3.0892958046E+00, 9.4287146967E-01],
	[3.37150E+04, 2.5938982187E+01, 5.3856594810E+00, 1.0059374447E+01, 3.0898523893E+00, 9.4289996250E-01],
	[3.37200E+04, 2.5945487960E+01, 5.3856687669E+00, 1.0064263060E+01, 3.0904088447E+00, 9.4292844068E-01],
	[3.37250E+04, 2.5951994399E+01, 5.3856780515E+00, 1.0069153324E+01, 3.0909651709E+00, 9.4295690421E-01],
	[3.37300E+04, 2.5958501505E+01, 5.3856873347E+00, 1.0074045238E+01, 3.0915213677E+00, 9.4298535310E-01],
	[3.37350E+04, 2.5965009278E+01, 5.3856966165E+00, 1.0078938803E+01, 3.0920774353E+00, 9.4301378735E-01],
	[3.37400E+04, 2.5971517717E+01, 5.3857058970E+00, 1.0083834020E+01, 3.0926333736E+00, 9.4304220698E-01],
	[3.37450E+04, 2.5978026823E+01, 5.3857151761E+00, 1.0088730888E+01, 3.0931891826E+00, 9.4307061198E-01],
	[3.37500E+04, 2.5984536595E+01, 5.3857244539E+00, 1.0093629408E+01, 3.0937448623E+00, 9.4309900237E-01],
	[3.37550E+04, 2.5991047035E+01, 5.3857337303E+00, 1.0098529581E+01, 3.0943004127E+00, 9.4312737816E-01],
	[3.37600E+04, 2.5997558140E+01, 5.3857430053E+00, 1.0103431406E+01, 3.0948558339E+00, 9.4315573934E-01],
	[3.37650E+04, 2.6004069912E+01, 5.3857522790E+00, 1.0108334884E+01, 3.0954111258E+00, 9.4318408593E-01],
	[3.37700E+04, 2.6010582351E+01, 5.3857615513E+00, 1.0113240015E+01, 3.0959662884E+00, 9.4321241793E-01],
	[3.37750E+04, 2.6017095456E+01, 5.3857708223E+00, 1.0118146799E+01, 3.0965213217E+00, 9.4324073535E-01],
	[3.37800E+04, 2.6023609227E+01, 5.3857800919E+00, 1.0123055238E+01, 3.0970762257E+00, 9.4326903820E-01],
	[3.37850E+04, 2.6030123665E+01, 5.3857893602E+00, 1.0127965331E+01, 3.0976310005E+00, 9.4329732649E-01],
	[3.37900E+04, 2.6036638769E+01, 5.3857986271E+00, 1.0132877078E+01, 3.0981856461E+00, 9.4332560021E-01],
	[3.37950E+04, 2.6043154540E+01, 5.3858078926E+00, 1.0137790479E+01, 3.0987401623E+00, 9.4335385938E-01],
	[3.38000E+04, 2.6049670977E+01, 5.3858171568E+00, 1.0142705536E+01, 3.0992945493E+00, 9.4338210401E-01],
	[3.38050E+04, 2.6056188080E+01, 5.3858264197E+00, 1.0147622249E+01, 3.0998488070E+00, 9.4341033410E-01],
	[3.38100E+04, 2.6062705849E+01, 5.3858356812E+00, 1.0152540617E+01, 3.1004029354E+00, 9.4343854965E-01],
	[3.38150E+04, 2.6069224285E+01, 5.3858449413E+00, 1.0157460641E+01, 3.1009569346E+00, 9.4346675069E-01],
	[3.38200E+04, 2.6075743386E+01, 5.3858542001E+00, 1.0162382321E+01, 3.1015108046E+00, 9.4349493720E-01],
	[3.38250E+04, 2.6082263154E+01, 5.3858634575E+00, 1.0167305658E+01, 3.1020645452E+00, 9.4352310921E-01],
	[3.38300E+04, 2.6088783588E+01, 5.3858727136E+00, 1.0172230652E+01, 3.1026181567E+00, 9.4355126671E-01],
	[3.38350E+04, 2.6095304688E+01, 5.3858819683E+00, 1.0177157303E+01, 3.1031716388E+00, 9.4357940971E-01],
	[3.38400E+04, 2.6101826454E+01, 5.3858912217E+00, 1.0182085612E+01, 3.1037249917E+00, 9.4360753822E-01],
	[3.38450E+04, 2.6108348886E+01, 5.3859004737E+00, 1.0187015579E+01, 3.1042782154E+00, 9.4363565225E-01],
	[3.38500E+04, 2.6114871984E+01, 5.3859097243E+00, 1.0191947203E+01, 3.1048313098E+00, 9.4366375181E-01],
	[3.38550E+04, 2.6121395748E+01, 5.3859189737E+00, 1.0196880487E+01, 3.1053842750E+00, 9.4369183689E-01],
	[3.38600E+04, 2.6127920178E+01, 5.3859282216E+00, 1.0201815429E+01, 3.1059371109E+00, 9.4371990751E-01],
	[3.38650E+04, 2.6134445274E+01, 5.3859374683E+00, 1.0206752030E+01, 3.1064898176E+00, 9.4374796368E-01],
	[3.38700E+04, 2.6140971036E+01, 5.3859467135E+00, 1.0211690291E+01, 3.1070423950E+00, 9.4377600540E-01],
	[3.38750E+04, 2.6147497463E+01, 5.3859559574E+00, 1.0216630212E+01, 3.1075948432E+00, 9.4380403268E-01],
	[3.38800E+04, 2.6154024556E+01, 5.3859652000E+00, 1.0221571792E+01, 3.1081471622E+00, 9.4383204552E-01],
	[3.38850E+04, 2.6160552316E+01, 5.3859744412E+00, 1.0226515033E+01, 3.1086993519E+00, 9.4386004393E-01],
	[3.38900E+04, 2.6167080740E+01, 5.3859836811E+00, 1.0231459935E+01, 3.1092514124E+00, 9.4388802793E-01],
	[3.38950E+04, 2.6173609831E+01, 5.3859929196E+00, 1.0236406498E+01, 3.1098033437E+00, 9.4391599751E-01],
	[3.39000E+04, 2.6180139587E+01, 5.3860021568E+00, 1.0241354722E+01, 3.1103551458E+00, 9.4394395268E-01],
	[3.39050E+04, 2.6186670009E+01, 5.3860113927E+00, 1.0246304608E+01, 3.1109068186E+00, 9.4397189345E-01],
	[3.39100E+04, 2.6193201097E+01, 5.3860206272E+00, 1.0251256155E+01, 3.1114583622E+00, 9.4399981983E-01],
	[3.39150E+04, 2.6199732850E+01, 5.3860298603E+00, 1.0256209365E+01, 3.1120097766E+00, 9.4402773183E-01],
	[3.39200E+04, 2.6206265269E+01, 5.3860390921E+00, 1.0261164238E+01, 3.1125610618E+00, 9.4405562944E-01],
	[3.39250E+04, 2.6212798353E+01, 5.3860483225E+00, 1.0266120773E+01, 3.1131122177E+00, 9.4408351268E-01],
	[3.39300E+04, 2.6219332103E+01, 5.3860575517E+00, 1.0271078972E+01, 3.1136632445E+00, 9.4411138156E-01],
	[3.39350E+04, 2.6225866518E+01, 5.3860667794E+00, 1.0276038834E+01, 3.1142141420E+00, 9.4413923608E-01],
	[3.39400E+04, 2.6232401598E+01, 5.3860760058E+00, 1.0281000360E+01, 3.1147649103E+00, 9.4416707625E-01],
	[3.39450E+04, 2.6238937345E+01, 5.3860852309E+00, 1.0285963550E+01, 3.1153155495E+00, 9.4419490207E-01],
	[3.39500E+04, 2.6245473756E+01, 5.3860944547E+00, 1.0290928405E+01, 3.1158660594E+00, 9.4422271355E-01],
	[3.39550E+04, 2.6252010833E+01, 5.3861036770E+00, 1.0295894924E+01, 3.1164164401E+00, 9.4425051071E-01],
	[3.39600E+04, 2.6258548575E+01, 5.3861128981E+00, 1.0300863109E+01, 3.1169666917E+00, 9.4427829354E-01],
	[3.39650E+04, 2.6265086982E+01, 5.3861221178E+00, 1.0305832959E+01, 3.1175168140E+00, 9.4430606205E-01],
	[3.39700E+04, 2.6271626055E+01, 5.3861313362E+00, 1.0310804474E+01, 3.1180668072E+00, 9.4433381625E-01],
	[3.39750E+04, 2.6278165793E+01, 5.3861405532E+00, 1.0315777656E+01, 3.1186166712E+00, 9.4436155615E-01],
	[3.39800E+04, 2.6284706196E+01, 5.3861497689E+00, 1.0320752504E+01, 3.1191664059E+00, 9.4438928176E-01],
	[3.39850E+04, 2.6291247264E+01, 5.3861589832E+00, 1.0325729018E+01, 3.1197160115E+00, 9.4441699307E-01],
	[3.39900E+04, 2.6297788998E+01, 5.3861681962E+00, 1.0330707200E+01, 3.1202654880E+00, 9.4444469010E-01],
	[3.39950E+04, 2.6304331396E+01, 5.3861774079E+00, 1.0335687049E+01, 3.1208148352E+00, 9.4447237286E-01],
	[3.40000E+04, 2.6310874460E+01, 5.3861866182E+00, 1.0340668565E+01, 3.1213640533E+00, 9.4450004135E-01],
	[3.40050E+04, 2.6317418188E+01, 5.3861958272E+00, 1.0345651749E+01, 3.1219131422E+00, 9.4452769558E-01],
	[3.40100E+04, 2.6323962582E+01, 5.3862050349E+00, 1.0350636602E+01, 3.1224621020E+00, 9.4455533555E-01],
	[3.40150E+04, 2.6330507641E+01, 5.3862142412E+00, 1.0355623123E+01, 3.1230109326E+00, 9.4458296128E-01],
	[3.40200E+04, 2.6337053364E+01, 5.3862234462E+00, 1.0360611313E+01, 3.1235596340E+00, 9.4461057277E-01],
	[3.40250E+04, 2.6343599753E+01, 5.3862326498E+00, 1.0365601172E+01, 3.1241082063E+00, 9.4463817002E-01],
	[3.40300E+04, 2.6350146806E+01, 5.3862418521E+00, 1.0370592700E+01, 3.1246566494E+00, 9.4466575304E-01],
	[3.40350E+04, 2.6356694525E+01, 5.3862510531E+00, 1.0375585899E+01, 3.1252049634E+00, 9.4469332185E-01],
	[3.40400E+04, 2.6363242908E+01, 5.3862602527E+00, 1.0380580767E+01, 3.1257531482E+00, 9.4472087644E-01],
	[3.40450E+04, 2.6369791956E+01, 5.3862694510E+00, 1.0385577306E+01, 3.1263012039E+00, 9.4474841683E-01],
	[3.40500E+04, 2.6376341669E+01, 5.3862786479E+00, 1.0390575515E+01, 3.1268491304E+00, 9.4477594302E-01],
	[3.40550E+04, 2.6382892046E+01, 5.3862878436E+00, 1.0395575396E+01, 3.1273969278E+00, 9.4480345502E-01],
	[3.40600E+04, 2.6389443088E+01, 5.3862970379E+00, 1.0400576948E+01, 3.1279445961E+00, 9.4483095283E-01],
	[3.40650E+04, 2.6395994795E+01, 5.3863062308E+00, 1.0405580171E+01, 3.1284921352E+00, 9.4485843646E-01],
	[3.40700E+04, 2.6402547167E+01, 5.3863154224E+00, 1.0410585067E+01, 3.1290395453E+00, 9.4488590592E-01],
	[3.40750E+04, 2.6409100203E+01, 5.3863246127E+00, 1.0415591635E+01, 3.1295868262E+00, 9.4491336122E-01],
	[3.40800E+04, 2.6415653904E+01, 5.3863338017E+00, 1.0420599875E+01, 3.1301339780E+00, 9.4494080237E-01],
	[3.40850E+04, 2.6422208269E+01, 5.3863429893E+00, 1.0425609788E+01, 3.1306810006E+00, 9.4496822936E-01],
	[3.40900E+04, 2.6428763299E+01, 5.3863521756E+00, 1.0430621375E+01, 3.1312278942E+00, 9.4499564221E-01],
	[3.40950E+04, 2.6435318993E+01, 5.3863613606E+00, 1.0435634635E+01, 3.1317746586E+00, 9.4502304092E-01],
	[3.41000E+04, 2.6441875352E+01, 5.3863705442E+00, 1.0440649569E+01, 3.1323212940E+00, 9.4505042550E-01],
	[3.41050E+04, 2.6448432375E+01, 5.3863797265E+00, 1.0445666177E+01, 3.1328678002E+00, 9.4507779596E-01],
	[3.41100E+04, 2.6454990063E+01, 5.3863889075E+00, 1.0450684459E+01, 3.1334141774E+00, 9.4510515230E-01],
	[3.41150E+04, 2.6461548415E+01, 5.3863980871E+00, 1.0455704417E+01, 3.1339604255E+00, 9.4513249454E-01],
	[3.41200E+04, 2.6468107432E+01, 5.3864072654E+00, 1.0460726049E+01, 3.1345065444E+00, 9.4515982268E-01],
	[3.41250E+04, 2.6474667112E+01, 5.3864164424E+00, 1.0465749357E+01, 3.1350525343E+00, 9.4518713672E-01],
	[3.41300E+04, 2.6481227457E+01, 5.3864256180E+00, 1.0470774341E+01, 3.1355983951E+00, 9.4521443667E-01],
	[3.41350E+04, 2.6487788467E+01, 5.3864347923E+00, 1.0475801001E+01, 3.1361441269E+00, 9.4524172254E-01],
	[3.41400E+04, 2.6494350140E+01, 5.3864439653E+00, 1.0480829337E+01, 3.1366897295E+00, 9.4526899434E-01],
	[3.41450E+04, 2.6500912478E+01, 5.3864531370E+00, 1.0485859349E+01, 3.1372352031E+00, 9.4529625207E-01],
	[3.41500E+04, 2.6507475480E+01, 5.3864623073E+00, 1.0490891039E+01, 3.1377805476E+00, 9.4532349574E-01],
	[3.41550E+04, 2.6514039146E+01, 5.3864714764E+00, 1.0495924406E+01, 3.1383257631E+00, 9.4535072536E-01],
	[3.41600E+04, 2.6520603476E+01, 5.3864806440E+00, 1.0500959451E+01, 3.1388708495E+00, 9.4537794093E-01],
	[3.41650E+04, 2.6527168471E+01, 5.3864898104E+00, 1.0505996173E+01, 3.1394158069E+00, 9.4540514247E-01],
	[3.41700E+04, 2.6533734129E+01, 5.3864989754E+00, 1.0511034574E+01, 3.1399606352E+00, 9.4543232997E-01],
	[3.41750E+04, 2.6540300451E+01, 5.3865081391E+00, 1.0516074653E+01, 3.1405053345E+00, 9.4545950345E-01],
	[3.41800E+04, 2.6546867438E+01, 5.3865173015E+00, 1.0521116411E+01, 3.1410499047E+00, 9.4548666291E-01],
	[3.41850E+04, 2.6553435088E+01, 5.3865264626E+00, 1.0526159849E+01, 3.1415943459E+00, 9.4551380836E-01],
	[3.41900E+04, 2.6560003402E+01, 5.3865356223E+00, 1.0531204966E+01, 3.1421386581E+00, 9.4554093980E-01],
	[3.41950E+04, 2.6566572381E+01, 5.3865447807E+00, 1.0536251762E+01, 3.1426828412E+00, 9.4556805725E-01],
	[3.42000E+04, 2.6573142023E+01, 5.3865539378E+00, 1.0541300239E+01, 3.1432268953E+00, 9.4559516070E-01],
	[3.42050E+04, 2.6579712329E+01, 5.3865630936E+00, 1.0546350396E+01, 3.1437708204E+00, 9.4562225018E-01],
	[3.42100E+04, 2.6586283298E+01, 5.3865722480E+00, 1.0551402234E+01, 3.1443146165E+00, 9.4564932567E-01],
	[3.42150E+04, 2.6592854932E+01, 5.3865814011E+00, 1.0556455753E+01, 3.1448582836E+00, 9.4567638720E-01],
	[3.42200E+04, 2.6599427229E+01, 5.3865905529E+00, 1.0561510954E+01, 3.1454018217E+00, 9.4570343477E-01],
	[3.42250E+04, 2.6606000190E+01, 5.3865997034E+00, 1.0566567836E+01, 3.1459452308E+00, 9.4573046838E-01],
	[3.42300E+04, 2.6612573815E+01, 5.3866088526E+00, 1.0571626400E+01, 3.1464885109E+00, 9.4575748804E-01],
	[3.42350E+04, 2.6619148103E+01, 5.3866180004E+00, 1.0576686646E+01, 3.1470316620E+00, 9.4578449376E-01],
	[3.42400E+04, 2.6625723055E+01, 5.3866271469E+00, 1.0581748575E+01, 3.1475746841E+00, 9.4581148554E-01],
	[3.42450E+04, 2.6632298671E+01, 5.3866362921E+00, 1.0586812187E+01, 3.1481175772E+00, 9.4583846340E-01],
	[3.42500E+04, 2.6638874950E+01, 5.3866454360E+00, 1.0591877483E+01, 3.1486603413E+00, 9.4586542734E-01],
	[3.42550E+04, 2.6645451893E+01, 5.3866545785E+00, 1.0596944461E+01, 3.1492029765E+00, 9.4589237736E-01],
	[3.42600E+04, 2.6652029499E+01, 5.3866637198E+00, 1.0602013124E+01, 3.1497454827E+00, 9.4591931348E-01],
	[3.42650E+04, 2.6658607768E+01, 5.3866728597E+00, 1.0607083471E+01, 3.1502878600E+00, 9.4594623569E-01],
	[3.42700E+04, 2.6665186702E+01, 5.3866819983E+00, 1.0612155502E+01, 3.1508301083E+00, 9.4597314402E-01],
	[3.42750E+04, 2.6671766298E+01, 5.3866911355E+00, 1.0617229219E+01, 3.1513722276E+00, 9.4600003846E-01],
	[3.42800E+04, 2.6678346558E+01, 5.3867002715E+00, 1.0622304620E+01, 3.1519142180E+00, 9.4602691901E-01],
	[3.42850E+04, 2.6684927482E+01, 5.3867094062E+00, 1.0627381707E+01, 3.1524560795E+00, 9.4605378570E-01],
	[3.42900E+04, 2.6691509068E+01, 5.3867185395E+00, 1.0632460479E+01, 3.1529978120E+00, 9.4608063853E-01],
	[3.42950E+04, 2.6698091318E+01, 5.3867276715E+00, 1.0637540938E+01, 3.1535394156E+00, 9.4610747749E-01],
	[3.43000E+04, 2.6704674232E+01, 5.3867368022E+00, 1.0642623083E+01, 3.1540808903E+00, 9.4613430260E-01],
	[3.43050E+04, 2.6711257808E+01, 5.3867459316E+00, 1.0647706915E+01, 3.1546222360E+00, 9.4616111387E-01],
	[3.43100E+04, 2.6717842048E+01, 5.3867550596E+00, 1.0652792434E+01, 3.1551634528E+00, 9.4618791130E-01],
	[3.43150E+04, 2.6724426951E+01, 5.3867641864E+00, 1.0657879640E+01, 3.1557045407E+00, 9.4621469491E-01],
	[3.43200E+04, 2.6731012517E+01, 5.3867733118E+00, 1.0662968534E+01, 3.1562454997E+00, 9.4624146469E-01],
	[3.43250E+04, 2.6737598746E+01, 5.3867824360E+00, 1.0668059116E+01, 3.1567863298E+00, 9.4626822065E-01],
	[3.43300E+04, 2.6744194188E+01, 5.3867927346E+00, 1.0673151386E+01, 3.1573275541E+00, 9.4629496280E-01],
	[3.43350E+04, 2.6750831837E+01, 5.3868087437E+00, 1.0678245344E+01, 3.1578711916E+00, 9.4632169115E-01],
	[3.43400E+04, 2.6757470166E+01, 5.3868247505E+00, 1.0683340992E+01, 3.1584147015E+00, 9.4634840571E-01],
	[3.43450E+04, 2.6764109176E+01, 5.3868407551E+00, 1.0688438328E+01, 3.1589580838E+00, 9.4637510648E-01],
	[3.43500E+04, 2.6770748867E+01, 5.3868567573E+00, 1.0693537355E+01, 3.1595013386E+00, 9.4640179346E-01],
	[3.43550E+04, 2.6777389238E+01, 5.3868727573E+00, 1.0698638071E+01, 3.1600444657E+00, 9.4642846667E-01],
	[3.43600E+04, 2.6784030289E+01, 5.3868887550E+00, 1.0703740477E+01, 3.1605874654E+00, 9.4645512612E-01],
	[3.43650E+04, 2.6790672021E+01, 5.3869047505E+00, 1.0708844574E+01, 3.1611303374E+00, 9.4648177180E-01],
	[3.43700E+04, 2.6797314433E+01, 5.3869207436E+00, 1.0713950362E+01, 3.1616730819E+00, 9.4650840373E-01],
	[3.43750E+04, 2.6803957525E+01, 5.3869367345E+00, 1.0719057840E+01, 3.1622156988E+00, 9.4653502191E-01],
	[3.43800E+04, 2.6810601298E+01, 5.3869527231E+00, 1.0724167010E+01, 3.1627581882E+00, 9.4656162636E-01],
	[3.43850E+04, 2.6817245751E+01, 5.3869687094E+00, 1.0729277872E+01, 3.1633005501E+00, 9.4658821707E-01],
	[3.43900E+04, 2.6823890884E+01, 5.3869846934E+00, 1.0734390426E+01, 3.1638427844E+00, 9.4661479405E-01],
	[3.43950E+04, 2.6830536697E+01, 5.3870006752E+00, 1.0739504672E+01, 3.1643848912E+00, 9.4664135732E-01],
	[3.44000E+04, 2.6837183191E+01, 5.3870166546E+00, 1.0744620611E+01, 3.1649268705E+00, 9.4666790688E-01],
	[3.44050E+04, 2.6843830364E+01, 5.3870326318E+00, 1.0749738243E+01, 3.1654687222E+00, 9.4669444272E-01],
	[3.44100E+04, 2.6850478218E+01, 5.3870486068E+00, 1.0754857568E+01, 3.1660104465E+00, 9.4672096488E-01],
	[3.44150E+04, 2.6857126751E+01, 5.3870645794E+00, 1.0759978587E+01, 3.1665520432E+00, 9.4674747334E-01],
	[3.44200E+04, 2.6863775965E+01, 5.3870805498E+00, 1.0765101300E+01, 3.1670935124E+00, 9.4677396811E-01],
	[3.44250E+04, 2.6870425859E+01, 5.3870965179E+00, 1.0770225707E+01, 3.1676348541E+00, 9.4680044921E-01],
	[3.44300E+04, 2.6877076433E+01, 5.3871124838E+00, 1.0775351808E+01, 3.1681760683E+00, 9.4682691664E-01],
	[3.44350E+04, 2.6883727686E+01, 5.3871284473E+00, 1.0780479605E+01, 3.1687171551E+00, 9.4685337041E-01],
	[3.44400E+04, 2.6890379620E+01, 5.3871444086E+00, 1.0785609096E+01, 3.1692581143E+00, 9.4687981052E-01],
	[3.44450E+04, 2.6897032234E+01, 5.3871603677E+00, 1.0790740283E+01, 3.1697989461E+00, 9.4690623698E-01],
	[3.44500E+04, 2.6903685527E+01, 5.3871763244E+00, 1.0795873166E+01, 3.1703396504E+00, 9.4693264980E-01],
	[3.44550E+04, 2.6910339500E+01, 5.3871922789E+00, 1.0801007745E+01, 3.1708802272E+00, 9.4695904898E-01],
	[3.44600E+04, 2.6916994153E+01, 5.3872082312E+00, 1.0806144021E+01, 3.1714206766E+00, 9.4698543454E-01],
	[3.44650E+04, 2.6923649486E+01, 5.3872241811E+00, 1.0811281993E+01, 3.1719609985E+00, 9.4701180647E-01],
	[3.44700E+04, 2.6930305499E+01, 5.3872401288E+00, 1.0816421662E+01, 3.1725011929E+00, 9.4703816479E-01],
	[3.44750E+04, 2.6936962191E+01, 5.3872560742E+00, 1.0821563029E+01, 3.1730412600E+00, 9.4706450950E-01],
	[3.44800E+04, 2.6943619563E+01, 5.3872720174E+00, 1.0826706093E+01, 3.1735811995E+00, 9.4709084061E-01],
	[3.44850E+04, 2.6950277615E+01, 5.3872879583E+00, 1.0831850856E+01, 3.1741210117E+00, 9.4711715813E-01],
	[3.44900E+04, 2.6956936346E+01, 5.3873038969E+00, 1.0836997317E+01, 3.1746606964E+00, 9.4714346206E-01],
	[3.44950E+04, 2.6963595757E+01, 5.3873198333E+00, 1.0842145476E+01, 3.1752002537E+00, 9.4716975241E-01],
	[3.45000E+04, 2.6970255847E+01, 5.3873357674E+00, 1.0847295334E+01, 3.1757396835E+00, 9.4719602919E-01],
	[3.45050E+04, 2.6976916617E+01, 5.3873516992E+00, 1.0852446892E+01, 3.1762789860E+00, 9.4722229240E-01],
	[3.45100E+04, 2.6983578067E+01, 5.3873676288E+00, 1.0857600149E+01, 3.1768181610E+00, 9.4724854205E-01],
	[3.45150E+04, 2.6990240196E+01, 5.3873835561E+00, 1.0862755106E+01, 3.1773572087E+00, 9.4727477816E-01],
	[3.45200E+04, 2.6996903004E+01, 5.3873994812E+00, 1.0867911764E+01, 3.1778961289E+00, 9.4730100071E-01],
	[3.45250E+04, 2.7003566492E+01, 5.3874154040E+00, 1.0873070121E+01, 3.1784349218E+00, 9.4732720973E-01],
	[3.45300E+04, 2.7010230659E+01, 5.3874313245E+00, 1.0878230180E+01, 3.1789735873E+00, 9.4735340522E-01],
	[3.45350E+04, 2.7016895506E+01, 5.3874472428E+00, 1.0883391940E+01, 3.1795121254E+00, 9.4737958718E-01],
	[3.45400E+04, 2.7023561032E+01, 5.3874631588E+00, 1.0888555401E+01, 3.1800505361E+00, 9.4740575563E-01],
	[3.45450E+04, 2.7030227237E+01, 5.3874790726E+00, 1.0893720564E+01, 3.1805888195E+00, 9.4743191057E-01],
	[3.45500E+04, 2.7036894122E+01, 5.3874949841E+00, 1.0898887430E+01, 3.1811269755E+00, 9.4745805200E-01],
	[3.45550E+04, 2.7043561686E+01, 5.3875108934E+00, 1.0904055997E+01, 3.1816650041E+00, 9.4748417993E-01],
	[3.45600E+04, 2.7050229929E+01, 5.3875268004E+00, 1.0909226268E+01, 3.1822029054E+00, 9.4751029438E-01],
	[3.45650E+04, 2.7056898851E+01, 5.3875427051E+00, 1.0914398241E+01, 3.1827406794E+00, 9.4753639535E-01],
	[3.45700E+04, 2.7063568452E+01, 5.3875586076E+00, 1.0919571918E+01, 3.1832783260E+00, 9.4756248284E-01],
	[3.45750E+04, 2.7070238733E+01, 5.3875745079E+00, 1.0924747298E+01, 3.1838158453E+00, 9.4758855686E-01],
	[3.45800E+04, 2.7076909693E+01, 5.3875904059E+00, 1.0929924383E+01, 3.1843532373E+00, 9.4761461742E-01],
	[3.45850E+04, 2.7083581331E+01, 5.3876063016E+00, 1.0935103171E+01, 3.1848905019E+00, 9.4764066452E-01],
	[3.45900E+04, 2.7090253649E+01, 5.3876221951E+00, 1.0940283665E+01, 3.1854276393E+00, 9.4766669818E-01],
	[3.45950E+04, 2.7096926646E+01, 5.3876380863E+00, 1.0945465863E+01, 3.1859646493E+00, 9.4769271839E-01],
	[3.46000E+04, 2.7103600322E+01, 5.3876539753E+00, 1.0950649767E+01, 3.1865015321E+00, 9.4771872518E-01],
	[3.46050E+04, 2.7110274676E+01, 5.3876698620E+00, 1.0955835376E+01, 3.1870382875E+00, 9.4774471853E-01],
	[3.46100E+04, 2.7116949710E+01, 5.3876857465E+00, 1.0961022691E+01, 3.1875749157E+00, 9.4777069847E-01],
	[3.46150E+04, 2.7123625423E+01, 5.3877016288E+00, 1.0966211712E+01, 3.1881114166E+00, 9.4779666499E-01],
	[3.46200E+04, 2.7130301814E+01, 5.3877175088E+00, 1.0971402439E+01, 3.1886477902E+00, 9.4782261811E-01],
	[3.46250E+04, 2.7136978885E+01, 5.3877333865E+00, 1.0976594874E+01, 3.1891840365E+00, 9.4784855783E-01],
	[3.46300E+04, 2.7143656634E+01, 5.3877492620E+00, 1.0981789015E+01, 3.1897201556E+00, 9.4787448415E-01],
	[3.46350E+04, 2.7150335062E+01, 5.3877651353E+00, 1.0986984865E+01, 3.1902561474E+00, 9.4790039709E-01],
	[3.46400E+04, 2.7157014168E+01, 5.3877810063E+00, 1.0992182421E+01, 3.1907920120E+00, 9.4792629665E-01],
	[3.46450E+04, 2.7163693954E+01, 5.3877968751E+00, 1.0997381686E+01, 3.1913277494E+00, 9.4795218284E-01],
	[3.46500E+04, 2.7170374418E+01, 5.3878127416E+00, 1.1002582660E+01, 3.1918633595E+00, 9.4797805567E-01],
	[3.46550E+04, 2.7177055561E+01, 5.3878286059E+00, 1.1007785342E+01, 3.1923988424E+00, 9.4800391514E-01],
	[3.46600E+04, 2.7183737382E+01, 5.3878444679E+00, 1.1012989733E+01, 3.1929341980E+00, 9.4802976126E-01],
	[3.46650E+04, 2.7190419882E+01, 5.3878603277E+00, 1.1018195833E+01, 3.1934694265E+00, 9.4805559403E-01],
	[3.46700E+04, 2.7197103061E+01, 5.3878761853E+00, 1.1023403643E+01, 3.1940045277E+00, 9.4808141347E-01],
	[3.46750E+04, 2.7203786918E+01, 5.3878920406E+00, 1.1028613163E+01, 3.1945395018E+00, 9.4810721958E-01],
	[3.46800E+04, 2.7210471454E+01, 5.3879078937E+00, 1.1033824393E+01, 3.1950743486E+00, 9.4813301236E-01],
	[3.46850E+04, 2.7217156668E+01, 5.3879237445E+00, 1.1039037334E+01, 3.1956090683E+00, 9.4815879183E-01],
	[3.46900E+04, 2.7223842561E+01, 5.3879395931E+00, 1.1044251986E+01, 3.1961436607E+00, 9.4818455799E-01],
	[3.46950E+04, 2.7230529132E+01, 5.3879554395E+00, 1.1049468349E+01, 3.1966781260E+00, 9.4821031085E-01],
	[3.47000E+04, 2.7237216381E+01, 5.3879712836E+00, 1.1054686423E+01, 3.1972124642E+00, 9.4823605041E-01],
	[3.47050E+04, 2.7243904309E+01, 5.3879871255E+00, 1.1059906210E+01, 3.1977466752E+00, 9.4826177669E-01],
	[3.47100E+04, 2.7250592915E+01, 5.3880029651E+00, 1.1065127708E+01, 3.1982807590E+00, 9.4828748968E-01],
	[3.47150E+04, 2.7257282200E+01, 5.3880188026E+00, 1.1070350919E+01, 3.1988147157E+00, 9.4831318940E-01],
	[3.47200E+04, 2.7263972163E+01, 5.3880346378E+00, 1.1075575843E+01, 3.1993485452E+00, 9.4833887585E-01],
	[3.47250E+04, 2.7270662804E+01, 5.3880504707E+00, 1.1080802480E+01, 3.1998822476E+00, 9.4836454904E-01],
	[3.47300E+04, 2.7277354124E+01, 5.3880663014E+00, 1.1086030831E+01, 3.2004158229E+00, 9.4839020897E-01],
	[3.47350E+04, 2.7284046121E+01, 5.3880821299E+00, 1.1091260895E+01, 3.2009492711E+00, 9.4841585566E-01],
	[3.47400E+04, 2.7290738797E+01, 5.3880979562E+00, 1.1096492673E+01, 3.2014825921E+00, 9.4844148910E-01],
	[3.47450E+04, 2.7297432151E+01, 5.3881137802E+00, 1.1101726166E+01, 3.2020157861E+00, 9.4846710930E-01],
	[3.47500E+04, 2.7304126183E+01, 5.3881296020E+00, 1.1106961373E+01, 3.2025488529E+00, 9.4849271628E-01],
	[3.47550E+04, 2.7310820893E+01, 5.3881454216E+00, 1.1112198295E+01, 3.2030817927E+00, 9.4851831003E-01],
	[3.47600E+04, 2.7317516281E+01, 5.3881612389E+00, 1.1117436933E+01, 3.2036146054E+00, 9.4854389056E-01],
	[3.47650E+04, 2.7324212348E+01, 5.3881770540E+00, 1.1122677286E+01, 3.2041472910E+00, 9.4856945788E-01],
	[3.47700E+04, 2.7330909092E+01, 5.3881928669E+00, 1.1127919355E+01, 3.2046798495E+00, 9.4859501200E-01],
	[3.47750E+04, 2.7337606514E+01, 5.3882086775E+00, 1.1133163141E+01, 3.2052122810E+00, 9.4862055291E-01],
	[3.47800E+04, 2.7344304614E+01, 5.3882244859E+00, 1.1138408643E+01, 3.2057445854E+00, 9.4864608063E-01],
	[3.47850E+04, 2.7351003392E+01, 5.3882402921E+00, 1.1143655861E+01, 3.2062767628E+00, 9.4867159517E-01],
	[3.47900E+04, 2.7357702848E+01, 5.3882560961E+00, 1.1148904798E+01, 3.2068088132E+00, 9.4869709653E-01],
	[3.47950E+04, 2.7364402982E+01, 5.3882718979E+00, 1.1154155451E+01, 3.2073407365E+00, 9.4872258471E-01],
	[3.48000E+04, 2.7371103794E+01, 5.3882876974E+00, 1.1159407823E+01, 3.2078725328E+00, 9.4874805972E-01],
	[3.48050E+04, 2.7377805284E+01, 5.3883034947E+00, 1.1164661912E+01, 3.2084042020E+00, 9.4877352157E-01],
	[3.48100E+04, 2.7384507451E+01, 5.3883192898E+00, 1.1169917720E+01, 3.2089357443E+00, 9.4879897027E-01],
	[3.48150E+04, 2.7391210296E+01, 5.3883350826E+00, 1.1175175247E+01, 3.2094671596E+00, 9.4882440582E-01],
	[3.48200E+04, 2.7397913819E+01, 5.3883508732E+00, 1.1180434493E+01, 3.2099984478E+00, 9.4884982823E-01],
	[3.48250E+04, 2.7404618019E+01, 5.3883666617E+00, 1.1185695459E+01, 3.2105296091E+00, 9.4887523750E-01],
	[3.48300E+04, 2.7411322897E+01, 5.3883824478E+00, 1.1190958144E+01, 3.2110606434E+00, 9.4890063364E-01],
	[3.48350E+04, 2.7418028453E+01, 5.3883982318E+00, 1.1196222549E+01, 3.2115915508E+00, 9.4892601665E-01],
	[3.48400E+04, 2.7424734686E+01, 5.3884140136E+00, 1.1201488675E+01, 3.2121223312E+00, 9.4895138655E-01],
	[3.48450E+04, 2.7431441597E+01, 5.3884297931E+00, 1.1206756521E+01, 3.2126529846E+00, 9.4897674334E-01],
	[3.48500E+04, 2.7438149186E+01, 5.3884455704E+00, 1.1212026088E+01, 3.2131835110E+00, 9.4900208702E-01],
	[3.48550E+04, 2.7444857452E+01, 5.3884613455E+00, 1.1217297377E+01, 3.2137139106E+00, 9.4902741761E-01],
	[3.48600E+04, 2.7451566395E+01, 5.3884771184E+00, 1.1222570387E+01, 3.2142441832E+00, 9.4905273510E-01],
	[3.48650E+04, 2.7458276016E+01, 5.3884928891E+00, 1.1227845119E+01, 3.2147743289E+00, 9.4907803951E-01],
	[3.48700E+04, 2.7464986314E+01, 5.3885086575E+00, 1.1233121573E+01, 3.2153043476E+00, 9.4910333083E-01],
	[3.48750E+04, 2.7471697290E+01, 5.3885244238E+00, 1.1238399750E+01, 3.2158342395E+00, 9.4912860909E-01],
	[3.48800E+04, 2.7478408943E+01, 5.3885401878E+00, 1.1243679650E+01, 3.2163640044E+00, 9.4915387427E-01],
	[3.48850E+04, 2.7485121274E+01, 5.3885559496E+00, 1.1248961273E+01, 3.2168936425E+00, 9.4917912640E-01],
	[3.48900E+04, 2.7491834282E+01, 5.3885717092E+00, 1.1254244619E+01, 3.2174231536E+00, 9.4920436547E-01],
	[3.48950E+04, 2.7498547967E+01, 5.3885874666E+00, 1.1259529690E+01, 3.2179525379E+00, 9.4922959149E-01],
	[3.49000E+04, 2.7505262329E+01, 5.3886032217E+00, 1.1264816484E+01, 3.2184817954E+00, 9.4925480447E-01],
	[3.49050E+04, 2.7511977369E+01, 5.3886189747E+00, 1.1270105003E+01, 3.2190109259E+00, 9.4928000442E-01],
	[3.49100E+04, 2.7518693085E+01, 5.3886347254E+00, 1.1275395247E+01, 3.2195399297E+00, 9.4930519134E-01],
	[3.49150E+04, 2.7525409479E+01, 5.3886504740E+00, 1.1280687216E+01, 3.2200688065E+00, 9.4933036523E-01],
	[3.49200E+04, 2.7532126550E+01, 5.3886662203E+00, 1.1285980910E+01, 3.2205975566E+00, 9.4935552611E-01],
	[3.49250E+04, 2.7538844298E+01, 5.3886819644E+00, 1.1291276330E+01, 3.2211261798E+00, 9.4938067398E-01],
	[3.49300E+04, 2.7545562724E+01, 5.3886977064E+00, 1.1296573476E+01, 3.2216546762E+00, 9.4940580884E-01],
	[3.49350E+04, 2.7552281826E+01, 5.3887134461E+00, 1.1301872348E+01, 3.2221830457E+00, 9.4943093070E-01],
	[3.49400E+04, 2.7559001605E+01, 5.3887291836E+00, 1.1307172947E+01, 3.2227112885E+00, 9.4945603958E-01],
	[3.49450E+04, 2.7565722062E+01, 5.3887449189E+00, 1.1312475273E+01, 3.2232394045E+00, 9.4948113547E-01],
	[3.49500E+04, 2.7572443195E+01, 5.3887606520E+00, 1.1317779326E+01, 3.2237673937E+00, 9.4950621838E-01],
	[3.49550E+04, 2.7579165005E+01, 5.3887763828E+00, 1.1323085107E+01, 3.2242952561E+00, 9.4953128832E-01],
	[3.49600E+04, 2.7585887493E+01, 5.3887921115E+00, 1.1328392616E+01, 3.2248229917E+00, 9.4955634529E-01],
	[3.49650E+04, 2.7592610657E+01, 5.3888078380E+00, 1.1333701853E+01, 3.2253506006E+00, 9.4958138930E-01],
	[3.49700E+04, 2.7599334498E+01, 5.3888235623E+00, 1.1339012818E+01, 3.2258780827E+00, 9.4960642036E-01],
	[3.49750E+04, 2.7606059015E+01, 5.3888392843E+00, 1.1344325513E+01, 3.2264054381E+00, 9.4963143847E-01],
	[3.49800E+04, 2.7612784210E+01, 5.3888550042E+00, 1.1349639936E+01, 3.2269326667E+00, 9.4965644364E-01],
	[3.49850E+04, 2.7619510081E+01, 5.3888707219E+00, 1.1354956090E+01, 3.2274597686E+00, 9.4968143588E-01],
	[3.49900E+04, 2.7626236629E+01, 5.3888864374E+00, 1.1360273973E+01, 3.2279867438E+00, 9.4970641519E-01],
	[3.49950E+04, 2.7632963854E+01, 5.3889021506E+00, 1.1365593586E+01, 3.2285135923E+00, 9.4973138157E-01],
	[3.50000E+04, 2.7639691756E+01, 5.3889178617E+00, 1.1370914929E+01, 3.2290403141E+00, 9.4975633504E-01],
	[3.50050E+04, 2.7646420334E+01, 5.3889335706E+00, 1.1376239632E+01, 3.2295670404E+00, 9.4978127560E-01],
	[3.50100E+04, 2.7653149589E+01, 5.3889492772E+00, 1.1381566068E+01, 3.2300936401E+00, 9.4980620326E-01],
	[3.50150E+04, 2.7659879520E+01, 5.3889649817E+00, 1.1386894236E+01, 3.2306201129E+00, 9.4983111802E-01],
	[3.50200E+04, 2.7666610128E+01, 5.3889806840E+00, 1.1392224137E+01, 3.2311464591E+00, 9.4985601990E-01],
	[3.50250E+04, 2.7673341412E+01, 5.3889963841E+00, 1.1397555772E+01, 3.2316726785E+00, 9.4988090888E-01],
	[3.50300E+04, 2.7680073373E+01, 5.3890120820E+00, 1.1402889140E+01, 3.2321987712E+00, 9.4990578499E-01],
	[3.50350E+04, 2.7686806011E+01, 5.3890277777E+00, 1.1408224242E+01, 3.2327247373E+00, 9.4993064823E-01],
	[3.50400E+04, 2.7693539325E+01, 5.3890434712E+00, 1.1413561078E+01, 3.2332505766E+00, 9.4995549861E-01],
	[3.50450E+04, 2.7700273315E+01, 5.3890591625E+00, 1.1418899649E+01, 3.2337762893E+00, 9.4998033612E-01],
	[3.50500E+04, 2.7707007982E+01, 5.3890748516E+00, 1.1424239955E+01, 3.2343018752E+00, 9.5000516078E-01],
	[3.50550E+04, 2.7713743325E+01, 5.3890905385E+00, 1.1429581996E+01, 3.2348273346E+00, 9.5002997260E-01],
	[3.50600E+04, 2.7720479345E+01, 5.3891062232E+00, 1.1434925773E+01, 3.2353526672E+00, 9.5005477158E-01],
	[3.50650E+04, 2.7727216040E+01, 5.3891219058E+00, 1.1440271285E+01, 3.2358778733E+00, 9.5007955772E-01],
	[3.50700E+04, 2.7733953412E+01, 5.3891375861E+00, 1.1445618534E+01, 3.2364029527E+00, 9.5010433104E-01],
	[3.50750E+04, 2.7740691461E+01, 5.3891532643E+00, 1.1450967519E+01, 3.2369279054E+00, 9.5012909153E-01],
	[3.50800E+04, 2.7747430185E+01, 5.3891689403E+00, 1.1456318241E+01, 3.2374527316E+00, 9.5015383922E-01],
	[3.50850E+04, 2.7754169586E+01, 5.3891846140E+00, 1.1461670700E+01, 3.2379774311E+00, 9.5017857409E-01],
	[3.50900E+04, 2.7760909663E+01, 5.3892002856E+00, 1.1467024896E+01, 3.2385020040E+00, 9.5020329616E-01],
	[3.50950E+04, 2.7767650416E+01, 5.3892159550E+00, 1.1472380830E+01, 3.2390264504E+00, 9.5022800544E-01],
	[3.51000E+04, 2.7774391845E+01, 5.3892316223E+00, 1.1477738503E+01, 3.2395507701E+00, 9.5025270192E-01],
	[3.51050E+04, 2.7781133950E+01, 5.3892472873E+00, 1.1483097913E+01, 3.2400749633E+00, 9.5027738563E-01],
	[3.51100E+04, 2.7787876732E+01, 5.3892629501E+00, 1.1488459063E+01, 3.2405990299E+00, 9.5030205656E-01],
	[3.51150E+04, 2.7794620189E+01, 5.3892786108E+00, 1.1493821951E+01, 3.2411229700E+00, 9.5032671472E-01],
	[3.51200E+04, 2.7801364322E+01, 5.3892942693E+00, 1.1499186579E+01, 3.2416467835E+00, 9.5035136011E-01],
	[3.51250E+04, 2.7808109132E+01, 5.3893099256E+00, 1.1504552946E+01, 3.2421704705E+00, 9.5037599275E-01],
	[3.51300E+04, 2.7814854617E+01, 5.3893255797E+00, 1.1509921054E+01, 3.2426940310E+00, 9.5040061263E-01],
	[3.51350E+04, 2.7821600778E+01, 5.3893412316E+00, 1.1515290901E+01, 3.2432174649E+00, 9.5042521977E-01],
	[3.51400E+04, 2.7828347615E+01, 5.3893568814E+00, 1.1520662489E+01, 3.2437407724E+00, 9.5044981418E-01],
	[3.51450E+04, 2.7835095128E+01, 5.3893725289E+00, 1.1526035819E+01, 3.2442639533E+00, 9.5047439585E-01],
	[3.51500E+04, 2.7841843317E+01, 5.3893881743E+00, 1.1531410889E+01, 3.2447870078E+00, 9.5049896479E-01],
	[3.51550E+04, 2.7848592181E+01, 5.3894038175E+00, 1.1536787701E+01, 3.2453099357E+00, 9.5052352102E-01],
	[3.51600E+04, 2.7855341722E+01, 5.3894194585E+00, 1.1542166255E+01, 3.2458327372E+00, 9.5054806453E-01],
	[3.51650E+04, 2.7862091938E+01, 5.3894350974E+00, 1.1547546551E+01, 3.2463554123E+00, 9.5057259533E-01],
	[3.51700E+04, 2.7868842830E+01, 5.3894507341E+00, 1.1552928589E+01, 3.2468779608E+00, 9.5059711344E-01],
	[3.51750E+04, 2.7875594397E+01, 5.3894663686E+00, 1.1558312370E+01, 3.2474003830E+00, 9.5062161885E-01],
	[3.51800E+04, 2.7882346640E+01, 5.3894820009E+00, 1.1563697895E+01, 3.2479226787E+00, 9.5064611157E-01],
	[3.51850E+04, 2.7889099559E+01, 5.3894976310E+00, 1.1569085163E+01, 3.2484448480E+00, 9.5067059161E-01],
	[3.51900E+04, 2.7895853153E+01, 5.3895132590E+00, 1.1574474174E+01, 3.2489668908E+00, 9.5069505898E-01],
	[3.51950E+04, 2.7902607423E+01, 5.3895288848E+00, 1.1579864930E+01, 3.2494888073E+00, 9.5071951367E-01],
	[3.52000E+04, 2.7909362369E+01, 5.3895445084E+00, 1.1585257430E+01, 3.2500105974E+00, 9.5074395571E-01],
	[3.52050E+04, 2.7916117990E+01, 5.3895601298E+00, 1.1590651675E+01, 3.2505322611E+00, 9.5076838509E-01],
	[3.52100E+04, 2.7922874286E+01, 5.3895757491E+00, 1.1596047665E+01, 3.2510537984E+00, 9.5079280182E-01],
	[3.52150E+04, 2.7929631258E+01, 5.3895913662E+00, 1.1601445400E+01, 3.2515752093E+00, 9.5081720590E-01],
	[3.52200E+04, 2.7936388905E+01, 5.3896069811E+00, 1.1606844881E+01, 3.2520964939E+00, 9.5084159735E-01],
	[3.52250E+04, 2.7943147228E+01, 5.3896225939E+00, 1.1612246107E+01, 3.2526176522E+00, 9.5086597617E-01],
	[3.52300E+04, 2.7949906226E+01, 5.3896382044E+00, 1.1617649081E+01, 3.2531386841E+00, 9.5089034236E-01],
	[3.52350E+04, 2.7956665900E+01, 5.3896538128E+00, 1.1623053800E+01, 3.2536595897E+00, 9.5091469594E-01],
	[3.52400E+04, 2.7963426249E+01, 5.3896694191E+00, 1.1628460267E+01, 3.2541803689E+00, 9.5093903690E-01],
	[3.52450E+04, 2.7970187273E+01, 5.3896850232E+00, 1.1633868481E+01, 3.2547010219E+00, 9.5096336526E-01],
	[3.52500E+04, 2.7976948972E+01, 5.3897006251E+00, 1.1639278442E+01, 3.2552215486E+00, 9.5098768101E-01],
	[3.52550E+04, 2.7983711347E+01, 5.3897162248E+00, 1.1644690152E+01, 3.2557419489E+00, 9.5101198418E-01],
	[3.52600E+04, 2.7990474396E+01, 5.3897318224E+00, 1.1650103609E+01, 3.2562622230E+00, 9.5103627476E-01],
	[3.52650E+04, 2.7997238121E+01, 5.3897474178E+00, 1.1655518815E+01, 3.2567823709E+00, 9.5106055276E-01],
	[3.52700E+04, 2.8004002522E+01, 5.3897630110E+00, 1.1660935770E+01, 3.2573023924E+00, 9.5108481818E-01],
	[3.52750E+04, 2.8010767597E+01, 5.3897786021E+00, 1.1666354474E+01, 3.2578222878E+00, 9.5110907104E-01],
	[3.52800E+04, 2.8017533347E+01, 5.3897941910E+00, 1.1671774928E+01, 3.2583420569E+00, 9.5113331134E-01],
	[3.52850E+04, 2.8024299772E+01, 5.3898097777E+00, 1.1677197131E+01, 3.2588616997E+00, 9.5115753908E-01],
	[3.52900E+04, 2.8031066873E+01, 5.3898253623E+00, 1.1682621084E+01, 3.2593812164E+00, 9.5118175427E-01],
	[3.52950E+04, 2.8037834648E+01, 5.3898409447E+00, 1.1688046788E+01, 3.2599006068E+00, 9.5120595692E-01],
	[3.53000E+04, 2.8044603099E+01, 5.3898565250E+00, 1.1693474243E+01, 3.2604198711E+00, 9.5123014704E-01],
	[3.53050E+04, 2.8051372224E+01, 5.3898721031E+00, 1.1698903448E+01, 3.2609390091E+00, 9.5125432463E-01],
	[3.53100E+04, 2.8058142024E+01, 5.3898876790E+00, 1.1704334405E+01, 3.2614580210E+00, 9.5127848969E-01],
	[3.53150E+04, 2.8064912499E+01, 5.3899032528E+00, 1.1709767114E+01, 3.2619769067E+00, 9.5130264224E-01],
	[3.53200E+04, 2.8071683649E+01, 5.3899188244E+00, 1.1715201574E+01, 3.2624956663E+00, 9.5132678227E-01],
	[3.53250E+04, 2.8078455474E+01, 5.3899343938E+00, 1.1720637787E+01, 3.2630142997E+00, 9.5135090980E-01],
	[3.53300E+04, 2.8085227974E+01, 5.3899499611E+00, 1.1726075753E+01, 3.2635328070E+00, 9.5137502484E-01],
	[3.53350E+04, 2.8092001148E+01, 5.3899655262E+00, 1.1731515471E+01, 3.2640511881E+00, 9.5139912738E-01],
	[3.53400E+04, 2.8098774998E+01, 5.3899810892E+00, 1.1736956943E+01, 3.2645694432E+00, 9.5142321744E-01],
	[3.53450E+04, 2.8105549522E+01, 5.3899966500E+00, 1.1742400168E+01, 3.2650875721E+00, 9.5144729501E-01],
	[3.53500E+04, 2.8112324720E+01, 5.3900122087E+00, 1.1747845148E+01, 3.2656055749E+00, 9.5147136012E-01],
	[3.53550E+04, 2.8119100593E+01, 5.3900277652E+00, 1.1753291881E+01, 3.2661234517E+00, 9.5149541276E-01],
	[3.53600E+04, 2.8125877141E+01, 5.3900433196E+00, 1.1758740369E+01, 3.2666412024E+00, 9.5151945294E-01],
	[3.53650E+04, 2.8132654364E+01, 5.3900588718E+00, 1.1764190612E+01, 3.2671588270E+00, 9.5154348067E-01],
	[3.53700E+04, 2.8139432261E+01, 5.3900744218E+00, 1.1769642610E+01, 3.2676763256E+00, 9.5156749595E-01],
	[3.53750E+04, 2.8146210833E+01, 5.3900899697E+00, 1.1775096363E+01, 3.2681936981E+00, 9.5159149878E-01],
	[3.53800E+04, 2.8152990079E+01, 5.3901055154E+00, 1.1780551873E+01, 3.2687109446E+00, 9.5161548919E-01],
	[3.53850E+04, 2.8159770000E+01, 5.3901210590E+00, 1.1786009138E+01, 3.2692280651E+00, 9.5163946717E-01],
	[3.53900E+04, 2.8166550595E+01, 5.3901366005E+00, 1.1791468160E+01, 3.2697450596E+00, 9.5166343272E-01],
	[3.53950E+04, 2.8173331864E+01, 5.3901521398E+00, 1.1796928939E+01, 3.2702619280E+00, 9.5168738586E-01],
	[3.54000E+04, 2.8180113808E+01, 5.3901676769E+00, 1.1802391474E+01, 3.2707786705E+00, 9.5171132659E-01],
	[3.54050E+04, 2.8186896427E+01, 5.3901832119E+00, 1.1807855767E+01, 3.2712952870E+00, 9.5173525492E-01],
	[3.54100E+04, 2.8193679719E+01, 5.3901987447E+00, 1.1813321818E+01, 3.2718117776E+00, 9.5175917085E-01],
	[3.54150E+04, 2.8200463687E+01, 5.3902142754E+00, 1.1818789627E+01, 3.2723281421E+00, 9.5178307439E-01],
	[3.54200E+04, 2.8207248328E+01, 5.3902298039E+00, 1.1824259194E+01, 3.2728443808E+00, 9.5180696554E-01],
	[3.54250E+04, 2.8214033644E+01, 5.3902453303E+00, 1.1829730520E+01, 3.2733604935E+00, 9.5183084432E-01],
	[3.54300E+04, 2.8220819633E+01, 5.3902608546E+00, 1.1835203604E+01, 3.2738764803E+00, 9.5185471073E-01],
	[3.54350E+04, 2.8227606298E+01, 5.3902763767E+00, 1.1840678448E+01, 3.2743923411E+00, 9.5187856477E-01],
	[3.54400E+04, 2.8234393636E+01, 5.3902918966E+00, 1.1846155052E+01, 3.2749080761E+00, 9.5190240646E-01],
	[3.54450E+04, 2.8241181648E+01, 5.3903074144E+00, 1.1851633416E+01, 3.2754236851E+00, 9.5192623579E-01],
	[3.54500E+04, 2.8247970335E+01, 5.3903229301E+00, 1.1857113539E+01, 3.2759391683E+00, 9.5195005278E-01],
	[3.54550E+04, 2.8254759696E+01, 5.3903384436E+00, 1.1862595424E+01, 3.2764545257E+00, 9.5197385742E-01],
	[3.54600E+04, 2.8261549730E+01, 5.3903539550E+00, 1.1868079069E+01, 3.2769697571E+00, 9.5199764974E-01],
	[3.54650E+04, 2.8268340439E+01, 5.3903694643E+00, 1.1873564475E+01, 3.2774848627E+00, 9.5202142973E-01],
	[3.54700E+04, 2.8275131822E+01, 5.3903849713E+00, 1.1879051643E+01, 3.2779998425E+00, 9.5204519739E-01],
	[3.54750E+04, 2.8281923879E+01, 5.3904004763E+00, 1.1884540573E+01, 3.2785146965E+00, 9.5206895275E-01],
	[3.54800E+04, 2.8288716609E+01, 5.3904159791E+00, 1.1890031265E+01, 3.2790294246E+00, 9.5209269579E-01],
	[3.54850E+04, 2.8295510014E+01, 5.3904314798E+00, 1.1895523719E+01, 3.2795440269E+00, 9.5211642653E-01],
	[3.54900E+04, 2.8302304093E+01, 5.3904469783E+00, 1.1901017936E+01, 3.2800585035E+00, 9.5214014498E-01],
	[3.54950E+04, 2.8309098845E+01, 5.3904624747E+00, 1.1906513917E+01, 3.2805728542E+00, 9.5216385114E-01],
	[3.55000E+04, 2.8315894272E+01, 5.3904779690E+00, 1.1912011660E+01, 3.2810870792E+00, 9.5218754502E-01],
	[3.55050E+04, 2.8322690372E+01, 5.3904934611E+00, 1.1917511168E+01, 3.2816011784E+00, 9.5221122662E-01],
	[3.55100E+04, 2.8329487146E+01, 5.3905089511E+00, 1.1923012439E+01, 3.2821151519E+00, 9.5223489595E-01],
	[3.55150E+04, 2.8336284593E+01, 5.3905244389E+00, 1.1928515475E+01, 3.2826289997E+00, 9.5225855302E-01],
	[3.55200E+04, 2.8343082715E+01, 5.3905399246E+00, 1.1934020275E+01, 3.2831427217E+00, 9.5228219783E-01],
	[3.55250E+04, 2.8349881510E+01, 5.3905554082E+00, 1.1939526841E+01, 3.2836563180E+00, 9.5230583038E-01],
	[3.55300E+04, 2.8356680979E+01, 5.3905708897E+00, 1.1945035172E+01, 3.2841697886E+00, 9.5232945070E-01],
	[3.55350E+04, 2.8363481121E+01, 5.3905863690E+00, 1.1950545268E+01, 3.2846831335E+00, 9.5235305877E-01],
	[3.55400E+04, 2.8370281937E+01, 5.3906018461E+00, 1.1956057130E+01, 3.2851963527E+00, 9.5237665462E-01],
	[3.55450E+04, 2.8377083427E+01, 5.3906173212E+00, 1.1961570759E+01, 3.2857094463E+00, 9.5240023824E-01],
	[3.55500E+04, 2.8383885590E+01, 5.3906327941E+00, 1.1967086154E+01, 3.2862224142E+00, 9.5242380964E-01],
	[3.55550E+04, 2.8390688427E+01, 5.3906482649E+00, 1.1972603316E+01, 3.2867352564E+00, 9.5244736882E-01],
	[3.55600E+04, 2.8397491938E+01, 5.3906637335E+00, 1.1978122246E+01, 3.2872479731E+00, 9.5247091580E-01],
	[3.55650E+04, 2.8404296121E+01, 5.3906792000E+00, 1.1983642943E+01, 3.2877605641E+00, 9.5249445058E-01],
	[3.55700E+04, 2.8411100979E+01, 5.3906946644E+00, 1.1989165407E+01, 3.2882730294E+00, 9.5251797317E-01],
	[3.55750E+04, 2.8417906509E+01, 5.3907101267E+00, 1.1994689640E+01, 3.2887853692E+00, 9.5254148356E-01],
	[3.55800E+04, 2.8424712714E+01, 5.3907255868E+00, 1.2000215642E+01, 3.2892975834E+00, 9.5256498178E-01],
	[3.55850E+04, 2.8431519591E+01, 5.3907410448E+00, 1.2005743412E+01, 3.2898096721E+00, 9.5258846782E-01],
	[3.55900E+04, 2.8438327142E+01, 5.3907565007E+00, 1.2011272951E+01, 3.2903216351E+00, 9.5261194169E-01],
	[3.55950E+04, 2.8445135366E+01, 5.3907719544E+00, 1.2016804260E+01, 3.2908334726E+00, 9.5263540340E-01],
	[3.56000E+04, 2.8451944263E+01, 5.3907874060E+00, 1.2022337339E+01, 3.2913451846E+00, 9.5265885296E-01],
	[3.56050E+04, 2.8458753834E+01, 5.3908028555E+00, 1.2027872187E+01, 3.2918567710E+00, 9.5268229036E-01],
	[3.56100E+04, 2.8465564078E+01, 5.3908183029E+00, 1.2033408806E+01, 3.2923682319E+00, 9.5270571562E-01],
	[3.56150E+04, 2.8472374995E+01, 5.3908337481E+00, 1.2038947196E+01, 3.2928795673E+00, 9.5272912875E-01],
	[3.56200E+04, 2.8479186585E+01, 5.3908491912E+00, 1.2044487357E+01, 3.2933907772E+00, 9.5275252974E-01],
	[3.56250E+04, 2.8485998849E+01, 5.3908646322E+00, 1.2050029289E+01, 3.2939018616E+00, 9.5277591861E-01],
	[3.56300E+04, 2.8492811785E+01, 5.3908800711E+00, 1.2055572993E+01, 3.2944128206E+00, 9.5279929536E-01],
	[3.56350E+04, 2.8499625395E+01, 5.3908955079E+00, 1.2061118468E+01, 3.2949236541E+00, 9.5282265999E-01],
	[3.56400E+04, 2.8506439678E+01, 5.3909109425E+00, 1.2066665716E+01, 3.2954343621E+00, 9.5284601253E-01],
	[3.56450E+04, 2.8513254634E+01, 5.3909263750E+00, 1.2072214737E+01, 3.2959449447E+00, 9.5286935296E-01],
	[3.56500E+04, 2.8520070262E+01, 5.3909418054E+00, 1.2077765531E+01, 3.2964554019E+00, 9.5289268130E-01],
	[3.56550E+04, 2.8526886564E+01, 5.3909572336E+00, 1.2083318098E+01, 3.2969657336E+00, 9.5291599755E-01],
	[3.56600E+04, 2.8533703539E+01, 5.3909726598E+00, 1.2088872438E+01, 3.2974759400E+00, 9.5293930173E-01],
	[3.56650E+04, 2.8540521186E+01, 5.3909880838E+00, 1.2094428552E+01, 3.2979860210E+00, 9.5296259383E-01],
	[3.56700E+04, 2.8547339507E+01, 5.3910035057E+00, 1.2099986441E+01, 3.2984959766E+00, 9.5298587386E-01],
	[3.56750E+04, 2.8554158500E+01, 5.3910189255E+00, 1.2105546104E+01, 3.2990058068E+00, 9.5300914183E-01],
	[3.56800E+04, 2.8560978167E+01, 5.3910343432E+00, 1.2111107542E+01, 3.2995155117E+00, 9.5303239774E-01],
	[3.56850E+04, 2.8567798506E+01, 5.3910497588E+00, 1.2116670755E+01, 3.3000250912E+00, 9.5305564161E-01],
	[3.56900E+04, 2.8574619517E+01, 5.3910651722E+00, 1.2122235743E+01, 3.3005345454E+00, 9.5307887343E-01],
	[3.56950E+04, 2.8581441202E+01, 5.3910805835E+00, 1.2127802508E+01, 3.3010438743E+00, 9.5310209322E-01],
	[3.57000E+04, 2.8588278666E+01, 5.3910980398E+00, 1.2133371048E+01, 3.3015540471E+00, 9.5312530098E-01],
	[3.57050E+04, 2.8595150074E+01, 5.3911200004E+00, 1.2138941365E+01, 3.3020662293E+00, 9.5314849671E-01],
	[3.57100E+04, 2.8602022170E+01, 5.3911419580E+00, 1.2144513459E+01, 3.3025782874E+00, 9.5317168043E-01],
	[3.57150E+04, 2.8608894956E+01, 5.3911639126E+00, 1.2150087330E+01, 3.3030902213E+00, 9.5319485213E-01],
	[3.57200E+04, 2.8615768431E+01, 5.3911858642E+00, 1.2155662978E+01, 3.3036020312E+00, 9.5321801183E-01],
	[3.57250E+04, 2.8622642594E+01, 5.3912078129E+00, 1.2161240403E+01, 3.3041137169E+00, 9.5324115954E-01],
	[3.57300E+04, 2.8629517447E+01, 5.3912297585E+00, 1.2166819607E+01, 3.3046252786E+00, 9.5326429525E-01],
	[3.57350E+04, 2.8636392988E+01, 5.3912517012E+00, 1.2172400589E+01, 3.3051367163E+00, 9.5328741897E-01],
	[3.57400E+04, 2.8643269219E+01, 5.3912736409E+00, 1.2177983350E+01, 3.3056480298E+00, 9.5331053072E-01],
	[3.57450E+04, 2.8650146138E+01, 5.3912955776E+00, 1.2183567890E+01, 3.3061592194E+00, 9.5333363049E-01],
	[3.57500E+04, 2.8657023747E+01, 5.3913175114E+00, 1.2189154209E+01, 3.3066702849E+00, 9.5335671829E-01],
	[3.57550E+04, 2.8663902044E+01, 5.3913394421E+00, 1.2194742308E+01, 3.3071812264E+00, 9.5337979414E-01],
	[3.57600E+04, 2.8670781029E+01, 5.3913613699E+00, 1.2200332187E+01, 3.3076920438E+00, 9.5340285803E-01],
	[3.57650E+04, 2.8677660704E+01, 5.3913832947E+00, 1.2205923845E+01, 3.3082027373E+00, 9.5342590997E-01],
	[3.57700E+04, 2.8684541067E+01, 5.3914052166E+00, 1.2211517285E+01, 3.3087133068E+00, 9.5344894997E-01],
	[3.57750E+04, 2.8691422119E+01, 5.3914271354E+00, 1.2217112505E+01, 3.3092237524E+00, 9.5347197804E-01],
	[3.57800E+04, 2.8698303860E+01, 5.3914490513E+00, 1.2222709507E+01, 3.3097340739E+00, 9.5349499417E-01],
	[3.57850E+04, 2.8705186289E+01, 5.3914709642E+00, 1.2228308290E+01, 3.3102442716E+00, 9.5351799839E-01],
	[3.57900E+04, 2.8712069407E+01, 5.3914928742E+00, 1.2233908855E+01, 3.3107543453E+00, 9.5354099068E-01],
	[3.57950E+04, 2.8718953214E+01, 5.3915147811E+00, 1.2239511202E+01, 3.3112642950E+00, 9.5356397107E-01],
	[3.58000E+04, 2.8725837709E+01, 5.3915366851E+00, 1.2245115331E+01, 3.3117741209E+00, 9.5358693955E-01],
	[3.58050E+04, 2.8732722893E+01, 5.3915585861E+00, 1.2250721244E+01, 3.3122838229E+00, 9.5360989614E-01],
	[3.58100E+04, 2.8739608765E+01, 5.3915804842E+00, 1.2256328939E+01, 3.3127934010E+00, 9.5363284083E-01],
	[3.58150E+04, 2.8746495326E+01, 5.3916023793E+00, 1.2261938418E+01, 3.3133028552E+00, 9.5365577364E-01],
	[3.58200E+04, 2.8753382575E+01, 5.3916242714E+00, 1.2267549680E+01, 3.3138121855E+00, 9.5367869457E-01],
	[3.58250E+04, 2.8760270513E+01, 5.3916461606E+00, 1.2273162727E+01, 3.3143213920E+00, 9.5370160363E-01],
	[3.58300E+04, 2.8767159139E+01, 5.3916680468E+00, 1.2278777558E+01, 3.3148304746E+00, 9.5372450082E-01],
	[3.58350E+04, 2.8774048453E+01, 5.3916899300E+00, 1.2284394174E+01, 3.3153394335E+00, 9.5374738615E-01],
	[3.58400E+04, 2.8780938456E+01, 5.3917118102E+00, 1.2290012575E+01, 3.3158482685E+00, 9.5377025963E-01],
	[3.58450E+04, 2.8787829147E+01, 5.3917336875E+00, 1.2295632761E+01, 3.3163569797E+00, 9.5379312126E-01],
	[3.58500E+04, 2.8794720527E+01, 5.3917555619E+00, 1.2301254732E+01, 3.3168655671E+00, 9.5381597105E-01],
	[3.58550E+04, 2.8801612594E+01, 5.3917774332E+00, 1.2306878490E+01, 3.3173740308E+00, 9.5383880900E-01],
	[3.58600E+04, 2.8808505350E+01, 5.3917993016E+00, 1.2312504034E+01, 3.3178823706E+00, 9.5386163512E-01],
	[3.58650E+04, 2.8815398794E+01, 5.3918211671E+00, 1.2318131365E+01, 3.3183905868E+00, 9.5388444943E-01],
	[3.58700E+04, 2.8822292927E+01, 5.3918430296E+00, 1.2323760482E+01, 3.3188986791E+00, 9.5390725191E-01],
	[3.58750E+04, 2.8829187747E+01, 5.3918648891E+00, 1.2329391387E+01, 3.3194066478E+00, 9.5393004258E-01],
	[3.58800E+04, 2.8836083256E+01, 5.3918867457E+00, 1.2335024079E+01, 3.3199144927E+00, 9.5395282144E-01],
	[3.58850E+04, 2.8842979453E+01, 5.3919085993E+00, 1.2340658560E+01, 3.3204222140E+00, 9.5397558851E-01],
	[3.58900E+04, 2.8849876338E+01, 5.3919304500E+00, 1.2346294828E+01, 3.3209298115E+00, 9.5399834378E-01],
	[3.58950E+04, 2.8856773910E+01, 5.3919522977E+00, 1.2351932885E+01, 3.3214372854E+00, 9.5402108726E-01],
	[3.59000E+04, 2.8863672171E+01, 5.3919741424E+00, 1.2357572731E+01, 3.3219446356E+00, 9.5404381895E-01],
	[3.59050E+04, 2.8870571120E+01, 5.3919959842E+00, 1.2363214366E+01, 3.3224518621E+00, 9.5406653887E-01],
	[3.59100E+04, 2.8877470757E+01, 5.3920178230E+00, 1.2368857790E+01, 3.3229589650E+00, 9.5408924702E-01],
	[3.59150E+04, 2.8884371082E+01, 5.3920396589E+00, 1.2374503004E+01, 3.3234659443E+00, 9.5411194340E-01],
	[3.59200E+04, 2.8891272095E+01, 5.3920614919E+00, 1.2380150009E+01, 3.3239728000E+00, 9.5413462801E-01],
	[3.59250E+04, 2.8898173796E+01, 5.3920833219E+00, 1.2385798803E+01, 3.3244795320E+00, 9.5415730088E-01],
	[3.59300E+04, 2.8905076184E+01, 5.3921051489E+00, 1.2391449389E+01, 3.3249861405E+00, 9.5417996199E-01],
	[3.59350E+04, 2.8911979261E+01, 5.3921269730E+00, 1.2397101765E+01, 3.3254926254E+00, 9.5420261136E-01],
	[3.59400E+04, 2.8918883025E+01, 5.3921487941E+00, 1.2402755933E+01, 3.3259989867E+00, 9.5422524900E-01],
	[3.59450E+04, 2.8925787477E+01, 5.3921706123E+00, 1.2408411893E+01, 3.3265052244E+00, 9.5424787490E-01],
	[3.59500E+04, 2.8932692617E+01, 5.3921924276E+00, 1.2414069645E+01, 3.3270113387E+00, 9.5427048908E-01],
	[3.59550E+04, 2.8939598444E+01, 5.3922142399E+00, 1.2419729189E+01, 3.3275173293E+00, 9.5429309153E-01],
	[3.59600E+04, 2.8946504959E+01, 5.3922360492E+00, 1.2425390525E+01, 3.3280231965E+00, 9.5431568227E-01],
	[3.59650E+04, 2.8953412162E+01, 5.3922578557E+00, 1.2431053655E+01, 3.3285289402E+00, 9.5433826130E-01],
	[3.59700E+04, 2.8960320053E+01, 5.3922796591E+00, 1.2436718578E+01, 3.3290345604E+00, 9.5436082863E-01],
	[3.59750E+04, 2.8967228631E+01, 5.3923014596E+00, 1.2442385294E+01, 3.3295400571E+00, 9.5438338426E-01],
	[3.59800E+04, 2.8974137897E+01, 5.3923232572E+00, 1.2448053805E+01, 3.3300454303E+00, 9.5440592820E-01],
	[3.59850E+04, 2.8981047850E+01, 5.3923450519E+00, 1.2453724110E+01, 3.3305506801E+00, 9.5442846045E-01],
	[3.59900E+04, 2.8987958491E+01, 5.3923668436E+00, 1.2459396209E+01, 3.3310558064E+00, 9.5445098102E-01],
	[3.59950E+04, 2.8994869819E+01, 5.3923886324E+00, 1.2465070103E+01, 3.3315608094E+00, 9.5447348992E-01],
	[3.60000E+04, 2.9001781835E+01, 5.3924104182E+00, 1.2470745792E+01, 3.3320656889E+00, 9.5449598715E-01],
	[3.60050E+04, 2.9008694538E+01, 5.3924322011E+00, 1.2476423277E+01, 3.3325704450E+00, 9.5451847272E-01],
	[3.60100E+04, 2.9015607929E+01, 5.3924539810E+00, 1.2482102558E+01, 3.3330750777E+00, 9.5454094662E-01],
	[3.60150E+04, 2.9022522007E+01, 5.3924757580E+00, 1.2487783635E+01, 3.3335795870E+00, 9.5456340888E-01],
	[3.60200E+04, 2.9029436773E+01, 5.3924975321E+00, 1.2493466508E+01, 3.3340839730E+00, 9.5458585949E-01],
	[3.60250E+04, 2.9036352226E+01, 5.3925193033E+00, 1.2499151178E+01, 3.3345882356E+00, 9.5460829846E-01],
	[3.60300E+04, 2.9043268366E+01, 5.3925410715E+00, 1.2504837646E+01, 3.3350923749E+00, 9.5463072580E-01],
	[3.60350E+04, 2.9050185193E+01, 5.3925628368E+00, 1.2510525910E+01, 3.3355963909E+00, 9.5465314151E-01],
	[3.60400E+04, 2.9057102708E+01, 5.3925845991E+00, 1.2516215973E+01, 3.3361002835E+00, 9.5467554559E-01],
	[3.60450E+04, 2.9064020910E+01, 5.3926063585E+00, 1.2521907833E+01, 3.3366040529E+00, 9.5469793806E-01],
	[3.60500E+04, 2.9070939799E+01, 5.3926281150E+00, 1.2527601492E+01, 3.3371076990E+00, 9.5472031891E-01],
	[3.60550E+04, 2.9077859376E+01, 5.3926498686E+00, 1.2533296950E+01, 3.3376112218E+00, 9.5474268816E-01],
	[3.60600E+04, 2.9084779639E+01, 5.3926716192E+00, 1.2538994207E+01, 3.3381146213E+00, 9.5476504581E-01],
	[3.60650E+04, 2.9091700590E+01, 5.3926933669E+00, 1.2544693263E+01, 3.3386178976E+00, 9.5478739187E-01],
	[3.60700E+04, 2.9098622228E+01, 5.3927151117E+00, 1.2550394118E+01, 3.3391210507E+00, 9.5480972634E-01],
	[3.60750E+04, 2.9105544553E+01, 5.3927368535E+00, 1.2556096774E+01, 3.3396240805E+00, 9.5483204922E-01],
	[3.60800E+04, 2.9112467565E+01, 5.3927585925E+00, 1.2561801230E+01, 3.3401269872E+00, 9.5485436053E-01],
	[3.60850E+04, 2.9119391264E+01, 5.3927803285E+00, 1.2567507487E+01, 3.3406297706E+00, 9.5487666027E-01],
	[3.60900E+04, 2.9126315650E+01, 5.3928020615E+00, 1.2573215544E+01, 3.3411324309E+00, 9.5489894844E-01],
	[3.60950E+04, 2.9133240723E+01, 5.3928237917E+00, 1.2578925403E+01, 3.3416349680E+00, 9.5492122505E-01],
	[3.61000E+04, 2.9140166482E+01, 5.3928455189E+00, 1.2584637063E+01, 3.3421373819E+00, 9.5494349011E-01],
	[3.61050E+04, 2.9147092929E+01, 5.3928672432E+00, 1.2590350526E+01, 3.3426396728E+00, 9.5496574362E-01],
	[3.61100E+04, 2.9154020063E+01, 5.3928889646E+00, 1.2596065790E+01, 3.3431418404E+00, 9.5498798558E-01],
	[3.61150E+04, 2.9160947884E+01, 5.3929106831E+00, 1.2601782857E+01, 3.3436438850E+00, 9.5501021601E-01],
	[3.61200E+04, 2.9167876391E+01, 5.3929323986E+00, 1.2607501727E+01, 3.3441458065E+00, 9.5503243491E-01],
	[3.61250E+04, 2.9174805585E+01, 5.3929541112E+00, 1.2613222400E+01, 3.3446476049E+00, 9.5505464229E-01],
	[3.61300E+04, 2.9181735466E+01, 5.3929758210E+00, 1.2618944877E+01, 3.3451492802E+00, 9.5507683814E-01],
	[3.61350E+04, 2.9188666034E+01, 5.3929975278E+00, 1.2624669157E+01, 3.3456508324E+00, 9.5509902248E-01],
	[3.61400E+04, 2.9195597288E+01, 5.3930192316E+00, 1.2630395242E+01, 3.3461522617E+00, 9.5512119531E-01],
	[3.61450E+04, 2.9202529230E+01, 5.3930409326E+00, 1.2636123131E+01, 3.3466535678E+00, 9.5514335664E-01],
	[3.61500E+04, 2.9209461858E+01, 5.3930626306E+00, 1.2641852824E+01, 3.3471547510E+00, 9.5516550648E-01],
	[3.61550E+04, 2.9216395172E+01, 5.3930843258E+00, 1.2647584323E+01, 3.3476558111E+00, 9.5518764482E-01],
	[3.61600E+04, 2.9223329173E+01, 5.3931060180E+00, 1.2653317627E+01, 3.3481567483E+00, 9.5520977168E-01],
	[3.61650E+04, 2.9230263861E+01, 5.3931277073E+00, 1.2659052737E+01, 3.3486575625E+00, 9.5523188706E-01],
	[3.61700E+04, 2.9237199235E+01, 5.3931493937E+00, 1.2664789653E+01, 3.3491582537E+00, 9.5525399096E-01],
	[3.61750E+04, 2.9244135296E+01, 5.3931710772E+00, 1.2670528375E+01, 3.3496588220E+00, 9.5527608340E-01],
	[3.61800E+04, 2.9251072043E+01, 5.3931927578E+00, 1.2676268904E+01, 3.3501592673E+00, 9.5529816438E-01],
	[3.61850E+04, 2.9258009477E+01, 5.3932144354E+00, 1.2682011240E+01, 3.3506595897E+00, 9.5532023390E-01],
	[3.61900E+04, 2.9264947598E+01, 5.3932361102E+00, 1.2687755384E+01, 3.3511597892E+00, 9.5534229197E-01],
	[3.61950E+04, 2.9271886404E+01, 5.3932577821E+00, 1.2693501335E+01, 3.3516598658E+00, 9.5536433859E-01],
	[3.62000E+04, 2.9278825897E+01, 5.3932794510E+00, 1.2699249093E+01, 3.3521598195E+00, 9.5538637378E-01],
	[3.62050E+04, 2.9285766077E+01, 5.3933011171E+00, 1.2704998661E+01, 3.3526596503E+00, 9.5540839753E-01],
	[3.62100E+04, 2.9292706943E+01, 5.3933227802E+00, 1.2710750036E+01, 3.3531593583E+00, 9.5543040985E-01],
	[3.62150E+04, 2.9299648495E+01, 5.3933444404E+00, 1.2716503221E+01, 3.3536589435E+00, 9.5545241075E-01],
	[3.62200E+04, 2.9306590733E+01, 5.3933660978E+00, 1.2722258215E+01, 3.3541584058E+00, 9.5547440024E-01],
	[3.62250E+04, 2.9313533658E+01, 5.3933877522E+00, 1.2728015019E+01, 3.3546577453E+00, 9.5549637832E-01],
	[3.62300E+04, 2.9320477269E+01, 5.3934094037E+00, 1.2733773632E+01, 3.3551569620E+00, 9.5551834499E-01],
	[3.62350E+04, 2.9327421566E+01, 5.3934310523E+00, 1.2739534055E+01, 3.3556560559E+00, 9.5554030026E-01],
	[3.62400E+04, 2.9334366550E+01, 5.3934526981E+00, 1.2745296289E+01, 3.3561550270E+00, 9.5556224414E-01],
	[3.62450E+04, 2.9341312219E+01, 5.3934743409E+00, 1.2751060334E+01, 3.3566538754E+00, 9.5558417664E-01],
	[3.62500E+04, 2.9348258575E+01, 5.3934959808E+00, 1.2756826190E+01, 3.3571526011E+00, 9.5560609775E-01],
	[3.62550E+04, 2.9355205617E+01, 5.3935176178E+00, 1.2762593858E+01, 3.3576512040E+00, 9.5562800748E-01],
	[3.62600E+04, 2.9362153345E+01, 5.3935392520E+00, 1.2768363337E+01, 3.3581496842E+00, 9.5564990585E-01],
	[3.62650E+04, 2.9369101759E+01, 5.3935608832E+00, 1.2774134628E+01, 3.3586480416E+00, 9.5567179285E-01],
	[3.62700E+04, 2.9376050859E+01, 5.3935825115E+00, 1.2779907732E+01, 3.3591462764E+00, 9.5569366850E-01],
	[3.62750E+04, 2.9383000645E+01, 5.3936041370E+00, 1.2785682649E+01, 3.3596443886E+00, 9.5571553279E-01],
	[3.62800E+04, 2.9389951117E+01, 5.3936257595E+00, 1.2791459378E+01, 3.3601423780E+00, 9.5573738573E-01],
	[3.62850E+04, 2.9396902275E+01, 5.3936473792E+00, 1.2797237921E+01, 3.3606402448E+00, 9.5575922733E-01],
	[3.62900E+04, 2.9403854119E+01, 5.3936689960E+00, 1.2803018278E+01, 3.3611379890E+00, 9.5578105760E-01],
	[3.62950E+04, 2.9410806648E+01, 5.3936906098E+00, 1.2808800449E+01, 3.3616356106E+00, 9.5580287654E-01],
	[3.63000E+04, 2.9417759864E+01, 5.3937122208E+00, 1.2814584434E+01, 3.3621331095E+00, 9.5582468415E-01],
	[3.63050E+04, 2.9424713766E+01, 5.3937338289E+00, 1.2820370233E+01, 3.3626304859E+00, 9.5584648045E-01],
	[3.63100E+04, 2.9431668353E+01, 5.3937554341E+00, 1.2826157848E+01, 3.3631277396E+00, 9.5586826543E-01],
	[3.63150E+04, 2.9438623626E+01, 5.3937770364E+00, 1.2831947278E+01, 3.3636248709E+00, 9.5589003911E-01],
	[3.63200E+04, 2.9445579585E+01, 5.3937986359E+00, 1.2837738524E+01, 3.3641218795E+00, 9.5591180148E-01],
	[3.63250E+04, 2.9452536229E+01, 5.3938202324E+00, 1.2843531585E+01, 3.3646187657E+00, 9.5593355256E-01],
	[3.63300E+04, 2.9459493559E+01, 5.3938418261E+00, 1.2849326463E+01, 3.3651155293E+00, 9.5595529235E-01],
	[3.63350E+04, 2.9466451575E+01, 5.3938634168E+00, 1.2855123157E+01, 3.3656121704E+00, 9.5597702086E-01],
	[3.63400E+04, 2.9473410277E+01, 5.3938850047E+00, 1.2860921669E+01, 3.3661086890E+00, 9.5599873809E-01],
	[3.63450E+04, 2.9480369664E+01, 5.3939065897E+00, 1.2866721997E+01, 3.3666050852E+00, 9.5602044404E-01],
	[3.63500E+04, 2.9487329737E+01, 5.3939281718E+00, 1.2872524143E+01, 3.3671013588E+00, 9.5604213873E-01],
	[3.63550E+04, 2.9494290495E+01, 5.3939497511E+00, 1.2878328107E+01, 3.3675975101E+00, 9.5606382216E-01],
	[3.63600E+04, 2.9501251939E+01, 5.3939713274E+00, 1.2884133889E+01, 3.3680935389E+00, 9.5608549434E-01],
	[3.63650E+04, 2.9508214069E+01, 5.3939929009E+00, 1.2889941489E+01, 3.3685894452E+00, 9.5610715526E-01],
	[3.63700E+04, 2.9515176884E+01, 5.3940144715E+00, 1.2895750909E+01, 3.3690852292E+00, 9.5612880495E-01],
	[3.63750E+04, 2.9522140384E+01, 5.3940360392E+00, 1.2901562147E+01, 3.3695808908E+00, 9.5615044339E-01],
	[3.63800E+04, 2.9529104570E+01, 5.3940576041E+00, 1.2907375205E+01, 3.3700764300E+00, 9.5617207060E-01],
	[3.63850E+04, 2.9536069441E+01, 5.3940791660E+00, 1.2913190083E+01, 3.3705718468E+00, 9.5619368659E-01],
	[3.63900E+04, 2.9543034998E+01, 5.3941007251E+00, 1.2919006781E+01, 3.3710671413E+00, 9.5621529135E-01],
	[3.63950E+04, 2.9550001240E+01, 5.3941222813E+00, 1.2924825299E+01, 3.3715623134E+00, 9.5623688491E-01],
	[3.64000E+04, 2.9556968167E+01, 5.3941438346E+00, 1.2930645638E+01, 3.3720573633E+00, 9.5625846725E-01],
	[3.64050E+04, 2.9563935780E+01, 5.3941653851E+00, 1.2936467798E+01, 3.3725522908E+00, 9.5628003839E-01],
	[3.64100E+04, 2.9570904078E+01, 5.3941869327E+00, 1.2942291779E+01, 3.3730470960E+00, 9.5630159833E-01],
	[3.64150E+04, 2.9577873061E+01, 5.3942084774E+00, 1.2948117582E+01, 3.3735417790E+00, 9.5632314708E-01],
	[3.64200E+04, 2.9584842730E+01, 5.3942300192E+00, 1.2953945207E+01, 3.3740363397E+00, 9.5634468464E-01],
	[3.64250E+04, 2.9591813083E+01, 5.3942515582E+00, 1.2959774654E+01, 3.3745307781E+00, 9.5636621103E-01],
	[3.64300E+04, 2.9598784122E+01, 5.3942730943E+00, 1.2965605924E+01, 3.3750250943E+00, 9.5638772624E-01],
	[3.64350E+04, 2.9605755846E+01, 5.3942946275E+00, 1.2971439017E+01, 3.3755192883E+00, 9.5640923028E-01],
	[3.64400E+04, 2.9612728255E+01, 5.3943161579E+00, 1.2977273933E+01, 3.3760133601E+00, 9.5643072315E-01],
	[3.64450E+04, 2.9619701349E+01, 5.3943376854E+00, 1.2983110673E+01, 3.3765073097E+00, 9.5645220487E-01],
	[3.64500E+04, 2.9626675128E+01, 5.3943592100E+00, 1.2988949237E+01, 3.3770011372E+00, 9.5647367544E-01],
	[3.64550E+04, 2.9633649593E+01, 5.3943807318E+00, 1.2994789625E+01, 3.3774948425E+00, 9.5649513487E-01],
	[3.64600E+04, 2.9640624742E+01, 5.3944022507E+00, 1.3000631837E+01, 3.3779884256E+00, 9.5651658315E-01],
	[3.64650E+04, 2.9647600576E+01, 5.3944237667E+00, 1.3006475875E+01, 3.3784818866E+00, 9.5653802030E-01],
	[3.64700E+04, 2.9654577095E+01, 5.3944452799E+00, 1.3012321737E+01, 3.3789752255E+00, 9.5655944632E-01],
	[3.64750E+04, 2.9661554300E+01, 5.3944667902E+00, 1.3018169426E+01, 3.3794684423E+00, 9.5658086122E-01],
	[3.64800E+04, 2.9668532189E+01, 5.3944882976E+00, 1.3024018940E+01, 3.3799615370E+00, 9.5660226500E-01],
	[3.64850E+04, 2.9675510763E+01, 5.3945098022E+00, 1.3029870280E+01, 3.3804545096E+00, 9.5662365767E-01],
	[3.64900E+04, 2.9682490021E+01, 5.3945313039E+00, 1.3035723446E+01, 3.3809473602E+00, 9.5664503923E-01],
	[3.64950E+04, 2.9689469965E+01, 5.3945528028E+00, 1.3041578440E+01, 3.3814400887E+00, 9.5666640970E-01],
	[3.65000E+04, 2.9696450593E+01, 5.3945742987E+00, 1.3047435260E+01, 3.3819326952E+00, 9.5668776907E-01],
	[3.65050E+04, 2.9703431907E+01, 5.3945957919E+00, 1.3053293908E+01, 3.3824251797E+00, 9.5670911735E-01],
	[3.65100E+04, 2.9710413905E+01, 5.3946172822E+00, 1.3059154384E+01, 3.3829175422E+00, 9.5673045455E-01],
	[3.65150E+04, 2.9717396587E+01, 5.3946387696E+00, 1.3065016688E+01, 3.3834097827E+00, 9.5675178067E-01],
	[3.65200E+04, 2.9724379955E+01, 5.3946602541E+00, 1.3070880820E+01, 3.3839019013E+00, 9.5677309573E-01],
	[3.65250E+04, 2.9731364007E+01, 5.3946817359E+00, 1.3076746781E+01, 3.3843938979E+00, 9.5679439971E-01],
	[3.65300E+04, 2.9738348743E+01, 5.3947032147E+00, 1.3082614571E+01, 3.3848857725E+00, 9.5681569264E-01],
	[3.65350E+04, 2.9745334164E+01, 5.3947246907E+00, 1.3088484190E+01, 3.3853775253E+00, 9.5683697451E-01],
	[3.65400E+04, 2.9752320270E+01, 5.3947461639E+00, 1.3094355639E+01, 3.3858691561E+00, 9.5685824534E-01],
	[3.65450E+04, 2.9759307061E+01, 5.3947676341E+00, 1.3100228918E+01, 3.3863606650E+00, 9.5687950512E-01],
	[3.65500E+04, 2.9766294536E+01, 5.3947891016E+00, 1.3106104028E+01, 3.3868520521E+00, 9.5690075387E-01],
	[3.65550E+04, 2.9773282695E+01, 5.3948105662E+00, 1.3111980968E+01, 3.3873433173E+00, 9.5692199158E-01],
	[3.65600E+04, 2.9780271539E+01, 5.3948320279E+00, 1.3117859739E+01, 3.3878344607E+00, 9.5694321827E-01],
	[3.65650E+04, 2.9787261067E+01, 5.3948534868E+00, 1.3123740341E+01, 3.3883254822E+00, 9.5696443394E-01],
	[3.65700E+04, 2.9794251280E+01, 5.3948749428E+00, 1.3129622775E+01, 3.3888163819E+00, 9.5698563860E-01],
	[3.65750E+04, 2.9801242177E+01, 5.3948963960E+00, 1.3135507040E+01, 3.3893071598E+00, 9.5700683225E-01],
	[3.65800E+04, 2.9808233759E+01, 5.3949178464E+00, 1.3141393138E+01, 3.3897978160E+00, 9.5702801490E-01],
	[3.65850E+04, 2.9815226025E+01, 5.3949392939E+00, 1.3147281069E+01, 3.3902883503E+00, 9.5704918655E-01],
	[3.65900E+04, 2.9822218975E+01, 5.3949607385E+00, 1.3153170832E+01, 3.3907787629E+00, 9.5707034721E-01],
	[3.65950E+04, 2.9829212610E+01, 5.3949821804E+00, 1.3159062429E+01, 3.3912690538E+00, 9.5709149688E-01],
	[3.66000E+04, 2.9836206928E+01, 5.3950036193E+00, 1.3164955859E+01, 3.3917592229E+00, 9.5711263558E-01],
	[3.66050E+04, 2.9843201932E+01, 5.3950250554E+00, 1.3170851123E+01, 3.3922492703E+00, 9.5713376330E-01],
	[3.66100E+04, 2.9850197619E+01, 5.3950464887E+00, 1.3176748221E+01, 3.3927391960E+00, 9.5715488006E-01],
	[3.66150E+04, 2.9857193990E+01, 5.3950679192E+00, 1.3182647154E+01, 3.3932290001E+00, 9.5717598585E-01],
	[3.66200E+04, 2.9864191046E+01, 5.3950893467E+00, 1.3188547921E+01, 3.3937186825E+00, 9.5719708068E-01],
	[3.66250E+04, 2.9871188786E+01, 5.3951107715E+00, 1.3194450524E+01, 3.3942082432E+00, 9.5721816457E-01],
	[3.66300E+04, 2.9878187209E+01, 5.3951321934E+00, 1.3200354962E+01, 3.3946976823E+00, 9.5723923751E-01],
	[3.66350E+04, 2.9885186317E+01, 5.3951536125E+00, 1.3206261235E+01, 3.3951869998E+00, 9.5726029951E-01],
	[3.66400E+04, 2.9892186109E+01, 5.3951750287E+00, 1.3212169345E+01, 3.3956761957E+00, 9.5728135058E-01],
	[3.66450E+04, 2.9899186585E+01, 5.3951964421E+00, 1.3218079291E+01, 3.3961652700E+00, 9.5730239072E-01],
	[3.66500E+04, 2.9906187745E+01, 5.3952178527E+00, 1.3223991074E+01, 3.3966542227E+00, 9.5732341994E-01],
	[3.66550E+04, 2.9913189589E+01, 5.3952392604E+00, 1.3229904694E+01, 3.3971430539E+00, 9.5734443824E-01],
	[3.66600E+04, 2.9920192117E+01, 5.3952606653E+00, 1.3235820151E+01, 3.3976317635E+00, 9.5736544563E-01],
	[3.66650E+04, 2.9927195329E+01, 5.3952820674E+00, 1.3241737446E+01, 3.3981203516E+00, 9.5738644212E-01],
	[3.66700E+04, 2.9934199225E+01, 5.3953034666E+00, 1.3247656579E+01, 3.3986088182E+00, 9.5740742771E-01],
	[3.66750E+04, 2.9941203805E+01, 5.3953248630E+00, 1.3253577550E+01, 3.3990971633E+00, 9.5742840240E-01],
	[3.66800E+04, 2.9948209068E+01, 5.3953462566E+00, 1.3259500360E+01, 3.3995853869E+00, 9.5744936621E-01],
	[3.66850E+04, 2.9955215015E+01, 5.3953676473E+00, 1.3265425009E+01, 3.4000734891E+00, 9.5747031914E-01],
	[3.66900E+04, 2.9962221647E+01, 5.3953890352E+00, 1.3271351497E+01, 3.4005614698E+00, 9.5749126119E-01],
	[3.66950E+04, 2.9969228961E+01, 5.3954104203E+00, 1.3277279825E+01, 3.4010493291E+00, 9.5751219237E-01],
	[3.67000E+04, 2.9976236960E+01, 5.3954318025E+00, 1.3283209993E+01, 3.4015370669E+00, 9.5753311268E-01],
	[3.67050E+04, 2.9983245642E+01, 5.3954531819E+00, 1.3289142001E+01, 3.4020246834E+00, 9.5755402214E-01],
	[3.67100E+04, 2.9990255008E+01, 5.3954745585E+00, 1.3295075849E+01, 3.4025121784E+00, 9.5757492074E-01],
	[3.67150E+04, 2.9997265058E+01, 5.3954959323E+00, 1.3301011539E+01, 3.4029995521E+00, 9.5759580849E-01],
	[3.67200E+04, 3.0004275791E+01, 5.3955173032E+00, 1.3306949069E+01, 3.4034868045E+00, 9.5761668541E-01],
	[3.67250E+04, 3.0011287208E+01, 5.3955386713E+00, 1.3312888441E+01, 3.4039739355E+00, 9.5763755148E-01],
	[3.67300E+04, 3.0018299308E+01, 5.3955600366E+00, 1.3318829655E+01, 3.4044609452E+00, 9.5765840673E-01],
	[3.67350E+04, 3.0025312092E+01, 5.3955813990E+00, 1.3324772711E+01, 3.4049478336E+00, 9.5767925115E-01],
	[3.67400E+04, 3.0032325560E+01, 5.3956027587E+00, 1.3330717610E+01, 3.4054346007E+00, 9.5770008475E-01],
	[3.67450E+04, 3.0039339711E+01, 5.3956241155E+00, 1.3336664351E+01, 3.4059212465E+00, 9.5772090754E-01],
	[3.67500E+04, 3.0046354546E+01, 5.3956454695E+00, 1.3342612936E+01, 3.4064077710E+00, 9.5774171953E-01],
	[3.67550E+04, 3.0053370064E+01, 5.3956668207E+00, 1.3348563364E+01, 3.4068941743E+00, 9.5776252071E-01],
	[3.67600E+04, 3.0060386265E+01, 5.3956881690E+00, 1.3354515635E+01, 3.4073804564E+00, 9.5778331109E-01],
	[3.67650E+04, 3.0067403150E+01, 5.3957095145E+00, 1.3360469751E+01, 3.4078666173E+00, 9.5780409068E-01],
	[3.67700E+04, 3.0074420718E+01, 5.3957308573E+00, 1.3366425711E+01, 3.4083526570E+00, 9.5782485949E-01],
	[3.67750E+04, 3.0081438969E+01, 5.3957521972E+00, 1.3372383516E+01, 3.4088385755E+00, 9.5784561752E-01],
	[3.67800E+04, 3.0088457904E+01, 5.3957735342E+00, 1.3378343166E+01, 3.4093243728E+00, 9.5786636478E-01],
	[3.67850E+04, 3.0095477522E+01, 5.3957948685E+00, 1.3384304662E+01, 3.4098100490E+00, 9.5788710127E-01],
	[3.67900E+04, 3.0102497823E+01, 5.3958162000E+00, 1.3390268003E+01, 3.4102956040E+00, 9.5790782700E-01],
	[3.67950E+04, 3.0109518808E+01, 5.3958375286E+00, 1.3396233190E+01, 3.4107810379E+00, 9.5792854197E-01],
	[3.68000E+04, 3.0116540476E+01, 5.3958588544E+00, 1.3402200223E+01, 3.4112663508E+00, 9.5794924619E-01],
	[3.68050E+04, 3.0123562827E+01, 5.3958801774E+00, 1.3408169103E+01, 3.4117515425E+00, 9.5796993967E-01],
	[3.68100E+04, 3.0130585861E+01, 5.3959014976E+00, 1.3414139830E+01, 3.4122366132E+00, 9.5799062241E-01],
	[3.68150E+04, 3.0137609578E+01, 5.3959228150E+00, 1.3420112404E+01, 3.4127215628E+00, 9.5801129441E-01],
	[3.68200E+04, 3.0144633979E+01, 5.3959441296E+00, 1.3426086826E+01, 3.4132063914E+00, 9.5803195569E-01],
	[3.68250E+04, 3.0151659062E+01, 5.3959654413E+00, 1.3432063096E+01, 3.4136910989E+00, 9.5805260624E-01],
	[3.68300E+04, 3.0158684829E+01, 5.3959867503E+00, 1.3438041214E+01, 3.4141756855E+00, 9.5807324608E-01],
	[3.68350E+04, 3.0165711278E+01, 5.3960080564E+00, 1.3444021181E+01, 3.4146601511E+00, 9.5809387521E-01],
	[3.68400E+04, 3.0172738411E+01, 5.3960293598E+00, 1.3450002996E+01, 3.4151444957E+00, 9.5811449363E-01],
	[3.68450E+04, 3.0179766226E+01, 5.3960506603E+00, 1.3455986661E+01, 3.4156287193E+00, 9.5813510136E-01],
	[3.68500E+04, 3.0186794724E+01, 5.3960719580E+00, 1.3461972175E+01, 3.4161128220E+00, 9.5815569839E-01],
	[3.68550E+04, 3.0193823906E+01, 5.3960932529E+00, 1.3467959539E+01, 3.4165968038E+00, 9.5817628473E-01],
	[3.68600E+04, 3.0200853770E+01, 5.3961145451E+00, 1.3473948754E+01, 3.4170806647E+00, 9.5819686039E-01],
	[3.68650E+04, 3.0207884317E+01, 5.3961358344E+00, 1.3479939818E+01, 3.4175644046E+00, 9.5821742538E-01],
	[3.68700E+04, 3.0214915547E+01, 5.3961571209E+00, 1.3485932734E+01, 3.4180480237E+00, 9.5823797970E-01],
	[3.68750E+04, 3.0221947460E+01, 5.3961784046E+00, 1.3491927501E+01, 3.4185315220E+00, 9.5825852335E-01],
	[3.68800E+04, 3.0228980055E+01, 5.3961996855E+00, 1.3497924119E+01, 3.4190148994E+00, 9.5827905634E-01],
	[3.68850E+04, 3.0236013334E+01, 5.3962209636E+00, 1.3503922589E+01, 3.4194981559E+00, 9.5829957867E-01],
	[3.68900E+04, 3.0243047295E+01, 5.3962422389E+00, 1.3509922911E+01, 3.4199812917E+00, 9.5832009036E-01],
	[3.68950E+04, 3.0250081939E+01, 5.3962635114E+00, 1.3515925085E+01, 3.4204643066E+00, 9.5834059141E-01],
	[3.69000E+04, 3.0257117265E+01, 5.3962847811E+00, 1.3521929113E+01, 3.4209472008E+00, 9.5836108182E-01],
	[3.69050E+04, 3.0264153274E+01, 5.3963060480E+00, 1.3527934993E+01, 3.4214299742E+00, 9.5838156160E-01],
	[3.69100E+04, 3.0271189966E+01, 5.3963273121E+00, 1.3533942727E+01, 3.4219126269E+00, 9.5840203076E-01],
	[3.69150E+04, 3.0278227340E+01, 5.3963485734E+00, 1.3539952314E+01, 3.4223951589E+00, 9.5842248929E-01],
	[3.69200E+04, 3.0285265397E+01, 5.3963698319E+00, 1.3545963755E+01, 3.4228775701E+00, 9.5844293721E-01],
	[3.69250E+04, 3.0292304137E+01, 5.3963910876E+00, 1.3551977051E+01, 3.4233598606E+00, 9.5846337453E-01],
	[3.69300E+04, 3.0299343559E+01, 5.3964123406E+00, 1.3557992201E+01, 3.4238420305E+00, 9.5848380124E-01],
	[3.69350E+04, 3.0306383663E+01, 5.3964335907E+00, 1.3564009207E+01, 3.4243240797E+00, 9.5850421736E-01],
	[3.69400E+04, 3.0313424450E+01, 5.3964548380E+00, 1.3570028068E+01, 3.4248060082E+00, 9.5852462288E-01],
	[3.69450E+04, 3.0320465919E+01, 5.3964760826E+00, 1.3576048784E+01, 3.4252878161E+00, 9.5854501782E-01],
	[3.69500E+04, 3.0327508071E+01, 5.3964973243E+00, 1.3582071356E+01, 3.4257695034E+00, 9.5856540218E-01],
	[3.69550E+04, 3.0334550905E+01, 5.3965185633E+00, 1.3588095785E+01, 3.4262510701E+00, 9.5858577596E-01],
	[3.69600E+04, 3.0341594422E+01, 5.3965397995E+00, 1.3594122070E+01, 3.4267325163E+00, 9.5860613918E-01],
	[3.69650E+04, 3.0348638621E+01, 5.3965610329E+00, 1.3600150212E+01, 3.4272138418E+00, 9.5862649184E-01],
	[3.69700E+04, 3.0355683502E+01, 5.3965822635E+00, 1.3606180211E+01, 3.4276950468E+00, 9.5864683393E-01],
	[3.69750E+04, 3.0362729066E+01, 5.3966034913E+00, 1.3612212068E+01, 3.4281761313E+00, 9.5866716547E-01],
	[3.69800E+04, 3.0369775312E+01, 5.3966247163E+00, 1.3618245783E+01, 3.4286570952E+00, 9.5868748647E-01],
	[3.69850E+04, 3.0376822240E+01, 5.3966459385E+00, 1.3624281355E+01, 3.4291379387E+00, 9.5870779692E-01],
	[3.69900E+04, 3.0383869850E+01, 5.3966671580E+00, 1.3630318787E+01, 3.4296186617E+00, 9.5872809684E-01],
	[3.69950E+04, 3.0390918142E+01, 5.3966883746E+00, 1.3636358077E+01, 3.4300992642E+00, 9.5874838622E-01],
	[3.70000E+04, 3.0397967117E+01, 5.3967095885E+00, 1.3642399226E+01, 3.4305797463E+00, 9.5876866508E-01],
	[3.70050E+04, 3.0405016774E+01, 5.3967307996E+00, 1.3648442235E+01, 3.4310601079E+00, 9.5878893341E-01],
	[3.70100E+04, 3.0412067112E+01, 5.3967520079E+00, 1.3654487104E+01, 3.4315403491E+00, 9.5880919123E-01],
	[3.70150E+04, 3.0419118133E+01, 5.3967732135E+00, 1.3660533833E+01, 3.4320204699E+00, 9.5882943853E-01],
	[3.70200E+04, 3.0426169836E+01, 5.3967944162E+00, 1.3666582422E+01, 3.4325004703E+00, 9.5884967534E-01],
	[3.70250E+04, 3.0433222221E+01, 5.3968156162E+00, 1.3672632872E+01, 3.4329803504E+00, 9.5886990163E-01],
	[3.70300E+04, 3.0440275288E+01, 5.3968368134E+00, 1.3678685183E+01, 3.4334601101E+00, 9.5889011744E-01],
	[3.70350E+04, 3.0447329037E+01, 5.3968580078E+00, 1.3684739355E+01, 3.4339397495E+00, 9.5891032275E-01],
	[3.70400E+04, 3.0454383468E+01, 5.3968791995E+00, 1.3690795390E+01, 3.4344192686E+00, 9.5893051758E-01],
	[3.70450E+04, 3.0461438581E+01, 5.3969003883E+00, 1.3696853286E+01, 3.4348986673E+00, 9.5895070193E-01],
	[3.70500E+04, 3.0468494376E+01, 5.3969215744E+00, 1.3702913044E+01, 3.4353779458E+00, 9.5897087580E-01],
	[3.70550E+04, 3.0475550852E+01, 5.3969427577E+00, 1.3708974666E+01, 3.4358571041E+00, 9.5899103921E-01],
	[3.70600E+04, 3.0482608011E+01, 5.3969639382E+00, 1.3715038150E+01, 3.4363361420E+00, 9.5901119215E-01],
	[3.70650E+04, 3.0489665851E+01, 5.3969851160E+00, 1.3721103498E+01, 3.4368150598E+00, 9.5903133463E-01],
	[3.70700E+04, 3.0496724373E+01, 5.3970062910E+00, 1.3727170709E+01, 3.4372938573E+00, 9.5905146665E-01],
	[3.70750E+04, 3.0503783577E+01, 5.3970274632E+00, 1.3733239784E+01, 3.4377725346E+00, 9.5907158823E-01],
	[3.70800E+04, 3.0510843463E+01, 5.3970486326E+00, 1.3739310724E+01, 3.4382510918E+00, 9.5909169937E-01],
	[3.70850E+04, 3.0517904030E+01, 5.3970697993E+00, 1.3745383528E+01, 3.4387295288E+00, 9.5911180006E-01],
	[3.70900E+04, 3.0524965279E+01, 5.3970909632E+00, 1.3751458197E+01, 3.4392078456E+00, 9.5913189032E-01],
	[3.70950E+04, 3.0532027210E+01, 5.3971121243E+00, 1.3757534731E+01, 3.4396860423E+00, 9.5915197016E-01],
	[3.71000E+04, 3.0539089822E+01, 5.3971332827E+00, 1.3763613131E+01, 3.4401641189E+00, 9.5917203957E-01],
	[3.71050E+04, 3.0546153116E+01, 5.3971544383E+00, 1.3769693397E+01, 3.4406420754E+00, 9.5919209857E-01],
	[3.71100E+04, 3.0553217091E+01, 5.3971755911E+00, 1.3775775529E+01, 3.4411199118E+00, 9.5921214715E-01],
	[3.71150E+04, 3.0560281748E+01, 5.3971967412E+00, 1.3781859528E+01, 3.4415976282E+00, 9.5923218532E-01],
	[3.71200E+04, 3.0567347087E+01, 5.3972178885E+00, 1.3787945393E+01, 3.4420752245E+00, 9.5925221310E-01],
	[3.71250E+04, 3.0574437886E+01, 5.3972423326E+00, 1.3794033126E+01, 3.4425543573E+00, 9.5927223047E-01],
	[3.71300E+04, 3.0581551305E+01, 5.3972696929E+00, 1.3800122726E+01, 3.4430348367E+00, 9.5929223746E-01],
	[3.71350E+04, 3.0588665421E+01, 5.3972970498E+00, 1.3806214194E+01, 3.4435151971E+00, 9.5931223406E-01],
	[3.71400E+04, 3.0595780233E+01, 5.3973244031E+00, 1.3812307530E+01, 3.4439954385E+00, 9.5933222028E-01],
	[3.71450E+04, 3.0602895743E+01, 5.3973517528E+00, 1.3818402735E+01, 3.4444755610E+00, 9.5935219612E-01],
	[3.71500E+04, 3.0610011949E+01, 5.3973790990E+00, 1.3824499808E+01, 3.4449555646E+00, 9.5937216159E-01],
	[3.71550E+04, 3.0617128851E+01, 5.3974064417E+00, 1.3830598751E+01, 3.4454354492E+00, 9.5939211670E-01],
	[3.71600E+04, 3.0624246451E+01, 5.3974337808E+00, 1.3836699563E+01, 3.4459152150E+00, 9.5941206145E-01],
	[3.71650E+04, 3.0631364747E+01, 5.3974611164E+00, 1.3842802244E+01, 3.4463948619E+00, 9.5943199584E-01],
	[3.71700E+04, 3.0638483740E+01, 5.3974884485E+00, 1.3848906796E+01, 3.4468743899E+00, 9.5945191988E-01],
	[3.71750E+04, 3.0645603429E+01, 5.3975157770E+00, 1.3855013218E+01, 3.4473537991E+00, 9.5947183358E-01],
	[3.71800E+04, 3.0652723815E+01, 5.3975431020E+00, 1.3861121511E+01, 3.4478330895E+00, 9.5949173694E-01],
	[3.71850E+04, 3.0659844898E+01, 5.3975704234E+00, 1.3867231675E+01, 3.4483122611E+00, 9.5951162996E-01],
	[3.71900E+04, 3.0666966677E+01, 5.3975977413E+00, 1.3873343710E+01, 3.4487913138E+00, 9.5953151266E-01],
	[3.71950E+04, 3.0674089152E+01, 5.3976250557E+00, 1.3879457617E+01, 3.4492702478E+00, 9.5955138503E-01],
	[3.72000E+04, 3.0681212324E+01, 5.3976523665E+00, 1.3885573396E+01, 3.4497490631E+00, 9.5957124708E-01],
	[3.72050E+04, 3.0688336193E+01, 5.3976796738E+00, 1.3891691048E+01, 3.4502277596E+00, 9.5959109882E-01],
	[3.72100E+04, 3.0695460758E+01, 5.3977069776E+00, 1.3897810572E+01, 3.4507063373E+00, 9.5961094026E-01],
	[3.72150E+04, 3.0702586019E+01, 5.3977342778E+00, 1.3903931968E+01, 3.4511847964E+00, 9.5963077139E-01],
	[3.72200E+04, 3.0709711977E+01, 5.3977615745E+00, 1.3910055239E+01, 3.4516631367E+00, 9.5965059222E-01],
	[3.72250E+04, 3.0716838631E+01, 5.3977888677E+00, 1.3916180382E+01, 3.4521413584E+00, 9.5967040276E-01],
	[3.72300E+04, 3.0723965982E+01, 5.3978161574E+00, 1.3922307400E+01, 3.4526194615E+00, 9.5969020301E-01],
	[3.72350E+04, 3.0731094029E+01, 5.3978434435E+00, 1.3928436292E+01, 3.4530974458E+00, 9.5970999298E-01],
	[3.72400E+04, 3.0738222772E+01, 5.3978707261E+00, 1.3934567059E+01, 3.4535753116E+00, 9.5972977268E-01],
	[3.72450E+04, 3.0745352211E+01, 5.3978980052E+00, 1.3940699700E+01, 3.4540530588E+00, 9.5974954210E-01],
	[3.72500E+04, 3.0752482347E+01, 5.3979252807E+00, 1.3946834217E+01, 3.4545306873E+00, 9.5976930126E-01],
	[3.72550E+04, 3.0759613179E+01, 5.3979525528E+00, 1.3952970609E+01, 3.4550081973E+00, 9.5978905015E-01],
	[3.72600E+04, 3.0766744707E+01, 5.3979798213E+00, 1.3959108877E+01, 3.4554855888E+00, 9.5980878879E-01],
	[3.72650E+04, 3.0773876931E+01, 5.3980070862E+00, 1.3965249022E+01, 3.4559628616E+00, 9.5982851718E-01],
	[3.72700E+04, 3.0781009851E+01, 5.3980343477E+00, 1.3971391042E+01, 3.4564400160E+00, 9.5984823533E-01],
	[3.72750E+04, 3.0788143468E+01, 5.3980616057E+00, 1.3977534940E+01, 3.4569170519E+00, 9.5986794323E-01],
	[3.72800E+04, 3.0795277780E+01, 5.3980888601E+00, 1.3983680715E+01, 3.4573939693E+00, 9.5988764090E-01],
	[3.72850E+04, 3.0802412789E+01, 5.3981161110E+00, 1.3989828367E+01, 3.4578707682E+00, 9.5990732834E-01],
	[3.72900E+04, 3.0809548493E+01, 5.3981433584E+00, 1.3995977897E+01, 3.4583474486E+00, 9.5992700555E-01],
	[3.72950E+04, 3.0816684894E+01, 5.3981706023E+00, 1.4002129305E+01, 3.4588240106E+00, 9.5994667255E-01],
	[3.73000E+04, 3.0823821991E+01, 5.3981978426E+00, 1.4008282592E+01, 3.4593004542E+00, 9.5996632933E-01],
	[3.73050E+04, 3.0830959783E+01, 5.3982250795E+00, 1.4014437757E+01, 3.4597767794E+00, 9.5998597590E-01],
	[3.73100E+04, 3.0838098272E+01, 5.3982523128E+00, 1.4020594802E+01, 3.4602529862E+00, 9.6000561227E-01],
	[3.73150E+04, 3.0845237456E+01, 5.3982795426E+00, 1.4026753726E+01, 3.4607290746E+00, 9.6002523844E-01],
	[3.73200E+04, 3.0852377336E+01, 5.3983067690E+00, 1.4032914529E+01, 3.4612050447E+00, 9.6004485442E-01],
	[3.73250E+04, 3.0859517912E+01, 5.3983339918E+00, 1.4039077213E+01, 3.4616808964E+00, 9.6006446021E-01],
	[3.73300E+04, 3.0866659184E+01, 5.3983612111E+00, 1.4045241777E+01, 3.4621566298E+00, 9.6008405582E-01],
	[3.73350E+04, 3.0873801152E+01, 5.3983884268E+00, 1.4051408221E+01, 3.4626322449E+00, 9.6010364125E-01],
	[3.73400E+04, 3.0880943816E+01, 5.3984156391E+00, 1.4057576547E+01, 3.4631077417E+00, 9.6012321650E-01],
	[3.73450E+04, 3.0888087175E+01, 5.3984428479E+00, 1.4063746754E+01, 3.4635831203E+00, 9.6014278159E-01],
	[3.73500E+04, 3.0895231230E+01, 5.3984700532E+00, 1.4069918843E+01, 3.4640583806E+00, 9.6016233652E-01],
	[3.73550E+04, 3.0902375981E+01, 5.3984972549E+00, 1.4076092813E+01, 3.4645335227E+00, 9.6018188129E-01],
	[3.73600E+04, 3.0909521427E+01, 5.3985244532E+00, 1.4082268666E+01, 3.4650085465E+00, 9.6020141591E-01],
	[3.73650E+04, 3.0916667569E+01, 5.3985516479E+00, 1.4088446402E+01, 3.4654834522E+00, 9.6022094038E-01],
	[3.73700E+04, 3.0923814407E+01, 5.3985788392E+00, 1.4094626020E+01, 3.4659582397E+00, 9.6024045472E-01],
	[3.73750E+04, 3.0930961940E+01, 5.3986060269E+00, 1.4100807522E+01, 3.4664329090E+00, 9.6025995891E-01],
	[3.73800E+04, 3.0938110169E+01, 5.3986332112E+00, 1.4106990907E+01, 3.4669074601E+00, 9.6027945298E-01],
	[3.73850E+04, 3.0945259093E+01, 5.3986603919E+00, 1.4113176177E+01, 3.4673818932E+00, 9.6029893692E-01],
	[3.73900E+04, 3.0952408713E+01, 5.3986875692E+00, 1.4119363330E+01, 3.4678562081E+00, 9.6031841074E-01],
	[3.73950E+04, 3.0959559029E+01, 5.3987147430E+00, 1.4125552368E+01, 3.4683304049E+00, 9.6033787444E-01],
	[3.74000E+04, 3.0966710040E+01, 5.3987419132E+00, 1.4131743291E+01, 3.4688044837E+00, 9.6035732804E-01],
	[3.74050E+04, 3.0973861746E+01, 5.3987690800E+00, 1.4137936099E+01, 3.4692784444E+00, 9.6037677153E-01],
	[3.74100E+04, 3.0981014148E+01, 5.3987962433E+00, 1.4144130793E+01, 3.4697522870E+00, 9.6039620492E-01],
	[3.74150E+04, 3.0988167245E+01, 5.3988234030E+00, 1.4150327372E+01, 3.4702260116E+00, 9.6041562822E-01],
	[3.74200E+04, 3.0995321038E+01, 5.3988505593E+00, 1.4156525838E+01, 3.4706996182E+00, 9.6043504143E-01],
	[3.74250E+04, 3.1002475525E+01, 5.3988777121E+00, 1.4162726190E+01, 3.4711731069E+00, 9.6045444455E-01],
	[3.74300E+04, 3.1009630709E+01, 5.3989048614E+00, 1.4168928429E+01, 3.4716464775E+00, 9.6047383760E-01],
	[3.74350E+04, 3.1016786587E+01, 5.3989320072E+00, 1.4175132555E+01, 3.4721197302E+00, 9.6049322057E-01],
	[3.74400E+04, 3.1023943161E+01, 5.3989591495E+00, 1.4181338568E+01, 3.4725928649E+00, 9.6051259348E-01],
	[3.74450E+04, 3.1031100430E+01, 5.3989862884E+00, 1.4187546469E+01, 3.4730658818E+00, 9.6053195632E-01],
	[3.74500E+04, 3.1038258394E+01, 5.3990134237E+00, 1.4193756259E+01, 3.4735387807E+00, 9.6055130910E-01],
	[3.74550E+04, 3.1045417054E+01, 5.3990405556E+00, 1.4199967936E+01, 3.4740115617E+00, 9.6057065183E-01],
	[3.74600E+04, 3.1052576408E+01, 5.3990676840E+00, 1.4206181503E+01, 3.4744842249E+00, 9.6058998452E-01],
	[3.74650E+04, 3.1059736458E+01, 5.3990948089E+00, 1.4212396958E+01, 3.4749567702E+00, 9.6060930716E-01],
	[3.74700E+04, 3.1066897203E+01, 5.3991219303E+00, 1.4218614303E+01, 3.4754291977E+00, 9.6062861977E-01],
	[3.74750E+04, 3.1074058643E+01, 5.3991490482E+00, 1.4224833538E+01, 3.4759015073E+00, 9.6064792234E-01],
	[3.74800E+04, 3.1081220778E+01, 5.3991761626E+00, 1.4231054663E+01, 3.4763736992E+00, 9.6066721489E-01],
	[3.74850E+04, 3.1088383608E+01, 5.3992032736E+00, 1.4237277678E+01, 3.4768457733E+00, 9.6068649741E-01],
	[3.74900E+04, 3.1095547133E+01, 5.3992303811E+00, 1.4243502583E+01, 3.4773177296E+00, 9.6070576992E-01],
	[3.74950E+04, 3.1102711353E+01, 5.3992574851E+00, 1.4249729380E+01, 3.4777895682E+00, 9.6072503242E-01],
	[3.75000E+04, 3.1109876269E+01, 5.3992845856E+00, 1.4255958068E+01, 3.4782612890E+00, 9.6074428492E-01],
	[3.75050E+04, 3.1117041879E+01, 5.3993116827E+00, 1.4262188647E+01, 3.4787328922E+00, 9.6076352741E-01],
	[3.75100E+04, 3.1124208183E+01, 5.3993387762E+00, 1.4268421119E+01, 3.4792043776E+00, 9.6078275991E-01],
	[3.75150E+04, 3.1131375183E+01, 5.3993658663E+00, 1.4274655483E+01, 3.4796757454E+00, 9.6080198242E-01],
	[3.75200E+04, 3.1138542878E+01, 5.3993929530E+00, 1.4280891739E+01, 3.4801469955E+00, 9.6082119494E-01],
	[3.75250E+04, 3.1145711268E+01, 5.3994200361E+00, 1.4287129889E+01, 3.4806181279E+00, 9.6084039748E-01],
	[3.75300E+04, 3.1152880352E+01, 5.3994471158E+00, 1.4293369931E+01, 3.4810891428E+00, 9.6085959005E-01],
	[3.75350E+04, 3.1160050131E+01, 5.3994741920E+00, 1.4299611867E+01, 3.4815600400E+00, 9.6087877265E-01],
	[3.75400E+04, 3.1167220605E+01, 5.3995012647E+00, 1.4305855698E+01, 3.4820308197E+00, 9.6089794529E-01],
	[3.75450E+04, 3.1174391774E+01, 5.3995283340E+00, 1.4312101422E+01, 3.4825014817E+00, 9.6091710797E-01],
	[3.75500E+04, 3.1181563637E+01, 5.3995553998E+00, 1.4318349041E+01, 3.4829720263E+00, 9.6093626069E-01],
	[3.75550E+04, 3.1188736195E+01, 5.3995824621E+00, 1.4324598554E+01, 3.4834424532E+00, 9.6095540347E-01],
	[3.75600E+04, 3.1195909448E+01, 5.3996095210E+00, 1.4330849963E+01, 3.4839127627E+00, 9.6097453630E-01],
	[3.75650E+04, 3.1203083395E+01, 5.3996365764E+00, 1.4337103268E+01, 3.4843829547E+00, 9.6099365919E-01],
	[3.75700E+04, 3.1210258037E+01, 5.3996636283E+00, 1.4343358468E+01, 3.4848530292E+00, 9.6101277216E-01],
	[3.75750E+04, 3.1217433374E+01, 5.3996906768E+00, 1.4349615564E+01, 3.4853229862E+00, 9.6103187519E-01],
	[3.75800E+04, 3.1224609405E+01, 5.3997177218E+00, 1.4355874557E+01, 3.4857928258E+00, 9.6105096830E-01],
	[3.75850E+04, 3.1231786131E+01, 5.3997447633E+00, 1.4362135447E+01, 3.4862625480E+00, 9.6107005150E-01],
	[3.75900E+04, 3.1238963551E+01, 5.3997718014E+00, 1.4368398233E+01, 3.4867321527E+00, 9.6108912478E-01],
	[3.75950E+04, 3.1246141665E+01, 5.3997988360E+00, 1.4374662917E+01, 3.4872016401E+00, 9.6110818815E-01],
	[3.76000E+04, 3.1253320475E+01, 5.3998258672E+00, 1.4380929499E+01, 3.4876710101E+00, 9.6112724163E-01],
	[3.76050E+04, 3.1260499978E+01, 5.3998528949E+00, 1.4387197979E+01, 3.4881402627E+00, 9.6114628520E-01],
	[3.76100E+04, 3.1267680176E+01, 5.3998799191E+00, 1.4393468358E+01, 3.4886093980E+00, 9.6116531889E-01],
	[3.76150E+04, 3.1274861069E+01, 5.3999069399E+00, 1.4399740635E+01, 3.4890784159E+00, 9.6118434269E-01],
	[3.76200E+04, 3.1282042655E+01, 5.3999339572E+00, 1.4406014811E+01, 3.4895473166E+00, 9.6120335661E-01],
	[3.76250E+04, 3.1289224936E+01, 5.3999609711E+00, 1.4412290886E+01, 3.4900161000E+00, 9.6122236065E-01],
	[3.76300E+04, 3.1296407912E+01, 5.3999879815E+00, 1.4418568862E+01, 3.4904847661E+00, 9.6124135483E-01],
	[3.76350E+04, 3.1303591582E+01, 5.4000149884E+00, 1.4424848737E+01, 3.4909533150E+00, 9.6126033914E-01],
	[3.76400E+04, 3.1310775946E+01, 5.4000419920E+00, 1.4431130513E+01, 3.4914217466E+00, 9.6127931358E-01],
	[3.76450E+04, 3.1317961004E+01, 5.4000689920E+00, 1.4437414189E+01, 3.4918900610E+00, 9.6129827818E-01],
	[3.76500E+04, 3.1325146756E+01, 5.4000959886E+00, 1.4443699766E+01, 3.4923582583E+00, 9.6131723292E-01],
	[3.76550E+04, 3.1332333203E+01, 5.4001229818E+00, 1.4449987245E+01, 3.4928263383E+00, 9.6133617782E-01],
	[3.76600E+04, 3.1339520343E+01, 5.4001499715E+00, 1.4456276625E+01, 3.4932943012E+00, 9.6135511288E-01],
	[3.76650E+04, 3.1346708178E+01, 5.4001769577E+00, 1.4462567907E+01, 3.4937621470E+00, 9.6137403811E-01],
	[3.76700E+04, 3.1353896707E+01, 5.4002039406E+00, 1.4468861091E+01, 3.4942298756E+00, 9.6139295350E-01],
	[3.76750E+04, 3.1361085930E+01, 5.4002309199E+00, 1.4475156178E+01, 3.4946974872E+00, 9.6141185908E-01],
	[3.76800E+04, 3.1368275848E+01, 5.4002578958E+00, 1.4481453168E+01, 3.4951649816E+00, 9.6143075483E-01],
	[3.76850E+04, 3.1375466459E+01, 5.4002848683E+00, 1.4487752061E+01, 3.4956323590E+00, 9.6144964077E-01],
	[3.76900E+04, 3.1382657764E+01, 5.4003118373E+00, 1.4494052858E+01, 3.4960996193E+00, 9.6146851691E-01],
	[3.76950E+04, 3.1389849763E+01, 5.4003388029E+00, 1.4500355559E+01, 3.4965667626E+00, 9.6148738324E-01],
	[3.77000E+04, 3.1397042456E+01, 5.4003657651E+00, 1.4506660163E+01, 3.4970337889E+00, 9.6150623977E-01],
	[3.77050E+04, 3.1404235843E+01, 5.4003927238E+00, 1.4512966673E+01, 3.4975006982E+00, 9.6152508651E-01],
	[3.77100E+04, 3.1411429924E+01, 5.4004196790E+00, 1.4519275087E+01, 3.4979674905E+00, 9.6154392346E-01],
	[3.77150E+04, 3.1418624699E+01, 5.4004466309E+00, 1.4525585406E+01, 3.4984341658E+00, 9.6156275063E-01],
	[3.77200E+04, 3.1425820168E+01, 5.4004735793E+00, 1.4531897631E+01, 3.4989007242E+00, 9.6158156802E-01],
	[3.77250E+04, 3.1433016331E+01, 5.4005005242E+00, 1.4538211762E+01, 3.4993671657E+00, 9.6160037564E-01],
	[3.77300E+04, 3.1440213187E+01, 5.4005274657E+00, 1.4544527799E+01, 3.4998334903E+00, 9.6161917350E-01],
	[3.77350E+04, 3.1447410737E+01, 5.4005544038E+00, 1.4550845742E+01, 3.5002996980E+00, 9.6163796159E-01],
	[3.77400E+04, 3.1454608981E+01, 5.4005813384E+00, 1.4557165592E+01, 3.5007657889E+00, 9.6165673993E-01],
	[3.77450E+04, 3.1461807919E+01, 5.4006082697E+00, 1.4563487349E+01, 3.5012317628E+00, 9.6167550851E-01],
	[3.77500E+04, 3.1469007550E+01, 5.4006351974E+00, 1.4569811014E+01, 3.5016976200E+00, 9.6169426735E-01],
	[3.77550E+04, 3.1476207875E+01, 5.4006621218E+00, 1.4576136587E+01, 3.5021633603E+00, 9.6171301645E-01],
	[3.77600E+04, 3.1483408894E+01, 5.4006890427E+00, 1.4582464067E+01, 3.5026289839E+00, 9.6173175581E-01],
	[3.77650E+04, 3.1490610606E+01, 5.4007159602E+00, 1.4588793456E+01, 3.5030944906E+00, 9.6175048545E-01],
	[3.77700E+04, 3.1497813012E+01, 5.4007428742E+00, 1.4595124754E+01, 3.5035598806E+00, 9.6176920535E-01],
	[3.77750E+04, 3.1505016112E+01, 5.4007697848E+00, 1.4601457960E+01, 3.5040251539E+00, 9.6178791554E-01],
	[3.77800E+04, 3.1512219905E+01, 5.4007966920E+00, 1.4607793076E+01, 3.5044903105E+00, 9.6180661601E-01],
	[3.77850E+04, 3.1519424392E+01, 5.4008235958E+00, 1.4614130102E+01, 3.5049553503E+00, 9.6182530677E-01],
	[3.77900E+04, 3.1526629572E+01, 5.4008504962E+00, 1.4620469038E+01, 3.5054202735E+00, 9.6184398783E-01],
	[3.77950E+04, 3.1533835446E+01, 5.4008773931E+00, 1.4626809884E+01, 3.5058850800E+00, 9.6186265919E-01],
	[3.78000E+04, 3.1541042013E+01, 5.4009042866E+00, 1.4633152641E+01, 3.5063497698E+00, 9.6188132085E-01],
	[3.78050E+04, 3.1548249273E+01, 5.4009311766E+00, 1.4639497309E+01, 3.5068143430E+00, 9.6189997283E-01],
	[3.78100E+04, 3.1555457227E+01, 5.4009580633E+00, 1.4645843888E+01, 3.5072787997E+00, 9.6191861512E-01],
	[3.78150E+04, 3.1562665875E+01, 5.4009849465E+00, 1.4652192378E+01, 3.5077431397E+00, 9.6193724773E-01],
	[3.78200E+04, 3.1569875215E+01, 5.4010118263E+00, 1.4658542781E+01, 3.5082073631E+00, 9.6195587067E-01],
	[3.78250E+04, 3.1577085249E+01, 5.4010387027E+00, 1.4664895096E+01, 3.5086714700E+00, 9.6197448394E-01],
	[3.78300E+04, 3.1584295977E+01, 5.4010655757E+00, 1.4671249324E+01, 3.5091354604E+00, 9.6199308755E-01],
	[3.78350E+04, 3.1591507397E+01, 5.4010924452E+00, 1.4677605464E+01, 3.5095993342E+00, 9.6201168149E-01],
	[3.78400E+04, 3.1598719511E+01, 5.4011193114E+00, 1.4683963518E+01, 3.5100630915E+00, 9.6203026579E-01],
	[3.78450E+04, 3.1605932318E+01, 5.4011461741E+00, 1.4690323485E+01, 3.5105267324E+00, 9.6204884044E-01],
	[3.78500E+04, 3.1613145819E+01, 5.4011730334E+00, 1.4696685366E+01, 3.5109902568E+00, 9.6206740544E-01],
	[3.78550E+04, 3.1620360012E+01, 5.4011998893E+00, 1.4703049162E+01, 3.5114536647E+00, 9.6208596081E-01],
	[3.78600E+04, 3.1627574899E+01, 5.4012267417E+00, 1.4709414872E+01, 3.5119169562E+00, 9.6210450655E-01],
	[3.78650E+04, 3.1634790479E+01, 5.4012535908E+00, 1.4715782496E+01, 3.5123801314E+00, 9.6212304266E-01],
	[3.78700E+04, 3.1642006752E+01, 5.4012804365E+00, 1.4722152036E+01, 3.5128431901E+00, 9.6214156914E-01],
	[3.78750E+04, 3.1649223718E+01, 5.4013072787E+00, 1.4728523492E+01, 3.5133061324E+00, 9.6216008601E-01],
	[3.78800E+04, 3.1656441377E+01, 5.4013341175E+00, 1.4734896863E+01, 3.5137689584E+00, 9.6217859327E-01],
	[3.78850E+04, 3.1663659729E+01, 5.4013609529E+00, 1.4741272151E+01, 3.5142316681E+00, 9.6219709092E-01],
	[3.78900E+04, 3.1670878774E+01, 5.4013877850E+00, 1.4747649355E+01, 3.5146942615E+00, 9.6221557897E-01],
	[3.78950E+04, 3.1678098512E+01, 5.4014146136E+00, 1.4754028475E+01, 3.5151567385E+00, 9.6223405743E-01],
	[3.79000E+04, 3.1685318943E+01, 5.4014414388E+00, 1.4760409513E+01, 3.5156190993E+00, 9.6225252629E-01],
	[3.79050E+04, 3.1692540067E+01, 5.4014682606E+00, 1.4766792469E+01, 3.5160813439E+00, 9.6227098557E-01],
	[3.79100E+04, 3.1699761884E+01, 5.4014950789E+00, 1.4773177342E+01, 3.5165434722E+00, 9.6228943526E-01],
	[3.79150E+04, 3.1706984394E+01, 5.4015218939E+00, 1.4779564133E+01, 3.5170054842E+00, 9.6230787538E-01],
	[3.79200E+04, 3.1714207597E+01, 5.4015487055E+00, 1.4785952843E+01, 3.5174673801E+00, 9.6232630593E-01],
	[3.79250E+04, 3.1721431492E+01, 5.4015755137E+00, 1.4792343471E+01, 3.5179291598E+00, 9.6234472692E-01],
	[3.79300E+04, 3.1728656080E+01, 5.4016023185E+00, 1.4798736018E+01, 3.5183908233E+00, 9.6236313834E-01],
	[3.79350E+04, 3.1735881362E+01, 5.4016291198E+00, 1.4805130485E+01, 3.5188523707E+00, 9.6238154021E-01],
	[3.79400E+04, 3.1743107335E+01, 5.4016559178E+00, 1.4811526872E+01, 3.5193138019E+00, 9.6239993253E-01],
	[3.79450E+04, 3.1750334002E+01, 5.4016827124E+00, 1.4817925178E+01, 3.5197751171E+00, 9.6241831531E-01],
	[3.79500E+04, 3.1757561361E+01, 5.4017095036E+00, 1.4824325405E+01, 3.5202363161E+00, 9.6243668854E-01],
	[3.79550E+04, 3.1764789413E+01, 5.4017362914E+00, 1.4830727553E+01, 3.5206973991E+00, 9.6245505224E-01],
	[3.79600E+04, 3.1772018158E+01, 5.4017630758E+00, 1.4837131622E+01, 3.5211583661E+00, 9.6247340642E-01],
	[3.79650E+04, 3.1779247595E+01, 5.4017898568E+00, 1.4843537611E+01, 3.5216192170E+00, 9.6249175106E-01],
	[3.79700E+04, 3.1786477725E+01, 5.4018166344E+00, 1.4849945523E+01, 3.5220799519E+00, 9.6251008619E-01],
	[3.79750E+04, 3.1793708548E+01, 5.4018434086E+00, 1.4856355357E+01, 3.5225405708E+00, 9.6252841181E-01],
	[3.79800E+04, 3.1800940063E+01, 5.4018701794E+00, 1.4862767112E+01, 3.5230010737E+00, 9.6254672791E-01],
	[3.79850E+04, 3.1808172270E+01, 5.4018969468E+00, 1.4869180791E+01, 3.5234614606E+00, 9.6256503452E-01],
	[3.79900E+04, 3.1815405171E+01, 5.4019237108E+00, 1.4875596392E+01, 3.5239217317E+00, 9.6258333162E-01],
	[3.79950E+04, 3.1822638763E+01, 5.4019504715E+00, 1.4882013917E+01, 3.5243818868E+00, 9.6260161923E-01],
	[3.80000E+04, 3.1829873048E+01, 5.4019772287E+00, 1.4888433365E+01, 3.5248419260E+00, 9.6261989736E-01],
	[3.80050E+04, 3.1837108026E+01, 5.4020039826E+00, 1.4894854738E+01, 3.5253018493E+00, 9.6263816600E-01],
	[3.80100E+04, 3.1844343696E+01, 5.4020307331E+00, 1.4901278034E+01, 3.5257616567E+00, 9.6265642516E-01],
	[3.80150E+04, 3.1851580058E+01, 5.4020574802E+00, 1.4907703255E+01, 3.5262213484E+00, 9.6267467485E-01],
	[3.80200E+04, 3.1858817113E+01, 5.4020842239E+00, 1.4914130401E+01, 3.5266809242E+00, 9.6269291507E-01],
	[3.80250E+04, 3.1866054860E+01, 5.4021109642E+00, 1.4920559472E+01, 3.5271403841E+00, 9.6271114583E-01],
	[3.80300E+04, 3.1873293299E+01, 5.4021377012E+00, 1.4926990468E+01, 3.5275997283E+00, 9.6272936714E-01],
	[3.80350E+04, 3.1880532431E+01, 5.4021644347E+00, 1.4933423391E+01, 3.5280589568E+00, 9.6274757901E-01],
	[3.80400E+04, 3.1887772254E+01, 5.4021911649E+00, 1.4939858240E+01, 3.5285180695E+00, 9.6276578146E-01],
	[3.80450E+04, 3.1895012771E+01, 5.4022178917E+00, 1.4946295015E+01, 3.5289770664E+00, 9.6278397449E-01],
	[3.80500E+04, 3.1902253979E+01, 5.4022446151E+00, 1.4952733717E+01, 3.5294359477E+00, 9.6280215810E-01],
	[3.80550E+04, 3.1909495879E+01, 5.4022713351E+00, 1.4959174346E+01, 3.5298947132E+00, 9.6282033229E-01],
	[3.80600E+04, 3.1916738472E+01, 5.4022980518E+00, 1.4965616902E+01, 3.5303533631E+00, 9.6283849707E-01],
	[3.80650E+04, 3.1923981757E+01, 5.4023247651E+00, 1.4972061387E+01, 3.5308118973E+00, 9.6285665245E-01],
	[3.80700E+04, 3.1931225734E+01, 5.4023514750E+00, 1.4978507799E+01, 3.5312703159E+00, 9.6287479843E-01],
	[3.80750E+04, 3.1938470403E+01, 5.4023781815E+00, 1.4984956140E+01, 3.5317286189E+00, 9.6289293501E-01],
	[3.80800E+04, 3.1945715764E+01, 5.4024048847E+00, 1.4991406410E+01, 3.5321868063E+00, 9.6291106220E-01],
	[3.80850E+04, 3.1952961817E+01, 5.4024315844E+00, 1.4997858609E+01, 3.5326448781E+00, 9.6292918000E-01],
	[3.80900E+04, 3.1960208562E+01, 5.4024582809E+00, 1.5004312737E+01, 3.5331028343E+00, 9.6294728842E-01],
	[3.80950E+04, 3.1967456000E+01, 5.4024849739E+00, 1.5010768795E+01, 3.5335606750E+00, 9.6296538746E-01],
	[3.81000E+04, 3.1974704129E+01, 5.4025116635E+00, 1.5017226783E+01, 3.5340184002E+00, 9.6298347712E-01],
	[3.81050E+04, 3.1981952950E+01, 5.4025383498E+00, 1.5023686701E+01, 3.5344760099E+00, 9.6300155742E-01],
	[3.81100E+04, 3.1989202463E+01, 5.4025650328E+00, 1.5030148550E+01, 3.5349335041E+00, 9.6301962835E-01],
	[3.81150E+04, 3.1996452668E+01, 5.4025917123E+00, 1.5036612330E+01, 3.5353908829E+00, 9.6303768992E-01],
	[3.81200E+04, 3.2003703564E+01, 5.4026183885E+00, 1.5043078042E+01, 3.5358481462E+00, 9.6305574213E-01],
	[3.81250E+04, 3.2010955153E+01, 5.4026450613E+00, 1.5049545685E+01, 3.5363052941E+00, 9.6307378500E-01],
	[3.81300E+04, 3.2018207433E+01, 5.4026717308E+00, 1.5056015260E+01, 3.5367623266E+00, 9.6309181851E-01],
	[3.81350E+04, 3.2025460406E+01, 5.4026983969E+00, 1.5062486767E+01, 3.5372192437E+00, 9.6310984269E-01],
	[3.81400E+04, 3.2032714070E+01, 5.4027250596E+00, 1.5068960207E+01, 3.5376760454E+00, 9.6312785752E-01],
	[3.81450E+04, 3.2039968425E+01, 5.4027517189E+00, 1.5075435581E+01, 3.5381327318E+00, 9.6314586302E-01],
	[3.81500E+04, 3.2047223473E+01, 5.4027783749E+00, 1.5081912887E+01, 3.5385893028E+00, 9.6316385919E-01],
	[3.81550E+04, 3.2054479212E+01, 5.4028050276E+00, 1.5088392127E+01, 3.5390457586E+00, 9.6318184604E-01],
	[3.81600E+04, 3.2061735643E+01, 5.4028316768E+00, 1.5094873301E+01, 3.5395020990E+00, 9.6319982357E-01],
	[3.81650E+04, 3.2068992765E+01, 5.4028583228E+00, 1.5101356409E+01, 3.5399583242E+00, 9.6321779178E-01],
	[3.81700E+04, 3.2076250579E+01, 5.4028849653E+00, 1.5107841452E+01, 3.5404144342E+00, 9.6323575068E-01],
	[3.81750E+04, 3.2083509085E+01, 5.4029116045E+00, 1.5114328430E+01, 3.5408704289E+00, 9.6325370028E-01],
	[3.81800E+04, 3.2090768282E+01, 5.4029382403E+00, 1.5120817343E+01, 3.5413263084E+00, 9.6327164057E-01],
	[3.81850E+04, 3.2098028171E+01, 5.4029648728E+00, 1.5127308191E+01, 3.5417820727E+00, 9.6328957156E-01],
	[3.81900E+04, 3.2105288751E+01, 5.4029915019E+00, 1.5133800975E+01, 3.5422377218E+00, 9.6330749326E-01],
	[3.81950E+04, 3.2112550023E+01, 5.4030181277E+00, 1.5140295696E+01, 3.5426932558E+00, 9.6332540568E-01],
	[3.82000E+04, 3.2119811986E+01, 5.4030447501E+00, 1.5146792353E+01, 3.5431486747E+00, 9.6334330881E-01],
	[3.82050E+04, 3.2127074641E+01, 5.4030713692E+00, 1.5153290947E+01, 3.5436039784E+00, 9.6336120265E-01],
	[3.82100E+04, 3.2134337987E+01, 5.4030979849E+00, 1.5159791478E+01, 3.5440591670E+00, 9.6337908723E-01],
	[3.82150E+04, 3.2141602025E+01, 5.4031245973E+00, 1.5166293947E+01, 3.5445142406E+00, 9.6339696253E-01],
	[3.82200E+04, 3.2148866754E+01, 5.4031512063E+00, 1.5172798353E+01, 3.5449691991E+00, 9.6341482857E-01],
	[3.82250E+04, 3.2156132174E+01, 5.4031778119E+00, 1.5179304698E+01, 3.5454240426E+00, 9.6343268534E-01],
	[3.82300E+04, 3.2163398286E+01, 5.4032044142E+00, 1.5185812981E+01, 3.5458787710E+00, 9.6345053286E-01],
	[3.82350E+04, 3.2170665089E+01, 5.4032310132E+00, 1.5192323203E+01, 3.5463333845E+00, 9.6346837113E-01],
	[3.82400E+04, 3.2177932583E+01, 5.4032576088E+00, 1.5198835364E+01, 3.5467878830E+00, 9.6348620014E-01],
	[3.82450E+04, 3.2185200768E+01, 5.4032842011E+00, 1.5205349465E+01, 3.5472422665E+00, 9.6350401992E-01],
	[3.82500E+04, 3.2192469645E+01, 5.4033107900E+00, 1.5211865505E+01, 3.5476965351E+00, 9.6352183045E-01],
	[3.82550E+04, 3.2199739213E+01, 5.4033373756E+00, 1.5218383485E+01, 3.5481506888E+00, 9.6353963175E-01],
	[3.82600E+04, 3.2207009472E+01, 5.4033639578E+00, 1.5224903406E+01, 3.5486047275E+00, 9.6355742382E-01],
	[3.82650E+04, 3.2214280422E+01, 5.4033905367E+00, 1.5231425268E+01, 3.5490586514E+00, 9.6357520667E-01],
	[3.82700E+04, 3.2221552063E+01, 5.4034171123E+00, 1.5237949070E+01, 3.5495124604E+00, 9.6359298029E-01],
	[3.82750E+04, 3.2228824396E+01, 5.4034436845E+00, 1.5244474814E+01, 3.5499661546E+00, 9.6361074470E-01],
	[3.82800E+04, 3.2236097419E+01, 5.4034702533E+00, 1.5251002500E+01, 3.5504197340E+00, 9.6362849989E-01],
	[3.82850E+04, 3.2243371134E+01, 5.4034968189E+00, 1.5257532128E+01, 3.5508731985E+00, 9.6364624588E-01],
	[3.82900E+04, 3.2250645539E+01, 5.4035233811E+00, 1.5264063698E+01, 3.5513265483E+00, 9.6366398266E-01],
	[3.82950E+04, 3.2257920636E+01, 5.4035499399E+00, 1.5270597211E+01, 3.5517797833E+00, 9.6368171025E-01],
	[3.83000E+04, 3.2265196423E+01, 5.4035764954E+00, 1.5277132667E+01, 3.5522329036E+00, 9.6369942864E-01],
	[3.83050E+04, 3.2272472902E+01, 5.4036030476E+00, 1.5283670066E+01, 3.5526859092E+00, 9.6371713784E-01],
	[3.83100E+04, 3.2279750071E+01, 5.4036295965E+00, 1.5290209409E+01, 3.5531388000E+00, 9.6373483786E-01],
	[3.83150E+04, 3.2287027932E+01, 5.4036561420E+00, 1.5296750695E+01, 3.5535915762E+00, 9.6375252870E-01],
	[3.83200E+04, 3.2294306483E+01, 5.4036826841E+00, 1.5303293926E+01, 3.5540442377E+00, 9.6377021036E-01],
	[3.83250E+04, 3.2301585725E+01, 5.4037092230E+00, 1.5309839102E+01, 3.5544967845E+00, 9.6378788284E-01],
	[3.83300E+04, 3.2308865658E+01, 5.4037357585E+00, 1.5316386223E+01, 3.5549492167E+00, 9.6380554617E-01],
	[3.83350E+04, 3.2316146282E+01, 5.4037622907E+00, 1.5322935289E+01, 3.5554015343E+00, 9.6382320033E-01],
	[3.83400E+04, 3.2323427596E+01, 5.4037888195E+00, 1.5329486300E+01, 3.5558537374E+00, 9.6384084533E-01],
	[3.83450E+04, 3.2330709602E+01, 5.4038153450E+00, 1.5336039258E+01, 3.5563058258E+00, 9.6385848118E-01],
	[3.83500E+04, 3.2337992298E+01, 5.4038418672E+00, 1.5342594162E+01, 3.5567577998E+00, 9.6387610788E-01],
	[3.83550E+04, 3.2345275684E+01, 5.4038683861E+00, 1.5349151012E+01, 3.5572096592E+00, 9.6389372543E-01],
	[3.83600E+04, 3.2352559762E+01, 5.4038949016E+00, 1.5355709809E+01, 3.5576614040E+00, 9.6391133385E-01],
	[3.83650E+04, 3.2359844530E+01, 5.4039214139E+00, 1.5362270554E+01, 3.5581130344E+00, 9.6392893312E-01],
	[3.83700E+04, 3.2367129989E+01, 5.4039479227E+00, 1.5368833246E+01, 3.5585645504E+00, 9.6394652327E-01],
	[3.83750E+04, 3.2374416138E+01, 5.4039744283E+00, 1.5375397886E+01, 3.5590159519E+00, 9.6396410430E-01],
	[3.83800E+04, 3.2381702978E+01, 5.4040009305E+00, 1.5381964474E+01, 3.5594672389E+00, 9.6398167620E-01],
	[3.83850E+04, 3.2388990508E+01, 5.4040274295E+00, 1.5388533010E+01, 3.5599184116E+00, 9.6399923898E-01],
	[3.83900E+04, 3.2396278729E+01, 5.4040539251E+00, 1.5395103496E+01, 3.5603694698E+00, 9.6401679265E-01],
	[3.83950E+04, 3.2403567641E+01, 5.4040804173E+00, 1.5401675931E+01, 3.5608204137E+00, 9.6403433721E-01],
	[3.84000E+04, 3.2410857243E+01, 5.4041069063E+00, 1.5408250315E+01, 3.5612712433E+00, 9.6405187267E-01],
	[3.84050E+04, 3.2418147535E+01, 5.4041333919E+00, 1.5414826649E+01, 3.5617219585E+00, 9.6406939903E-01],
	[3.84100E+04, 3.2425438518E+01, 5.4041598742E+00, 1.5421404933E+01, 3.5621725594E+00, 9.6408691630E-01],
	[3.84150E+04, 3.2432730192E+01, 5.4041863532E+00, 1.5427985167E+01, 3.5626230460E+00, 9.6410442447E-01],
	[3.84200E+04, 3.2440022555E+01, 5.4042128289E+00, 1.5434567353E+01, 3.5630734184E+00, 9.6412192356E-01],
	[3.84250E+04, 3.2447315610E+01, 5.4042393013E+00, 1.5441151489E+01, 3.5635236765E+00, 9.6413941357E-01],
	[3.84300E+04, 3.2454609354E+01, 5.4042657703E+00, 1.5447737577E+01, 3.5639738203E+00, 9.6415689450E-01],
	[3.84350E+04, 3.2461903789E+01, 5.4042922361E+00, 1.5454325617E+01, 3.5644238500E+00, 9.6417436636E-01],
	[3.84400E+04, 3.2469198914E+01, 5.4043186985E+00, 1.5460915608E+01, 3.5648737655E+00, 9.6419182915E-01],
	[3.84450E+04, 3.2476494729E+01, 5.4043451576E+00, 1.5467507553E+01, 3.5653235668E+00, 9.6420928288E-01],
	[3.84500E+04, 3.2483791235E+01, 5.4043716134E+00, 1.5474101450E+01, 3.5657732539E+00, 9.6422672755E-01],
	[3.84550E+04, 3.2491088430E+01, 5.4043980659E+00, 1.5480697300E+01, 3.5662228269E+00, 9.6424416316E-01],
	[3.84600E+04, 3.2498386316E+01, 5.4044245151E+00, 1.5487295103E+01, 3.5666722858E+00, 9.6426158973E-01],
	[3.84650E+04, 3.2505684893E+01, 5.4044509610E+00, 1.5493894860E+01, 3.5671216307E+00, 9.6427900725E-01],
	[3.84700E+04, 3.2512984159E+01, 5.4044774035E+00, 1.5500496571E+01, 3.5675708614E+00, 9.6429641573E-01],
	[3.84750E+04, 3.2520284115E+01, 5.4045038428E+00, 1.5507100237E+01, 3.5680199781E+00, 9.6431381518E-01],
	[3.84800E+04, 3.2527584762E+01, 5.4045302788E+00, 1.5513705857E+01, 3.5684689808E+00, 9.6433120559E-01],
	[3.84850E+04, 3.2534886098E+01, 5.4045567114E+00, 1.5520313432E+01, 3.5689178695E+00, 9.6434858698E-01],
	[3.84900E+04, 3.2542188125E+01, 5.4045831408E+00, 1.5526922962E+01, 3.5693666441E+00, 9.6436595934E-01],
	[3.84950E+04, 3.2549490842E+01, 5.4046095668E+00, 1.5533534449E+01, 3.5698153048E+00, 9.6438332269E-01],
	[3.85000E+04, 3.2556794248E+01, 5.4046359895E+00, 1.5540147891E+01, 3.5702638516E+00, 9.6440067702E-01],
	[3.85050E+04, 3.2564098345E+01, 5.4046624090E+00, 1.5546763289E+01, 3.5707122844E+00, 9.6441802235E-01],
	[3.85100E+04, 3.2571403132E+01, 5.4046888251E+00, 1.5553380644E+01, 3.5711606033E+00, 9.6443535867E-01],
	[3.85150E+04, 3.2578708608E+01, 5.4047152379E+00, 1.5559999956E+01, 3.5716088084E+00, 9.6445268599E-01],
	[3.85200E+04, 3.2586014775E+01, 5.4047416475E+00, 1.5566621226E+01, 3.5720568995E+00, 9.6447000431E-01],
	[3.85250E+04, 3.2593321631E+01, 5.4047680537E+00, 1.5573244453E+01, 3.5725048768E+00, 9.6448731365E-01],
	[3.85300E+04, 3.2600629177E+01, 5.4047944566E+00, 1.5579869638E+01, 3.5729527403E+00, 9.6450461400E-01],
	[3.85350E+04, 3.2607937413E+01, 5.4048208563E+00, 1.5586496781E+01, 3.5734004900E+00, 9.6452190536E-01],
	[3.85400E+04, 3.2615246339E+01, 5.4048472526E+00, 1.5593125882E+01, 3.5738481259E+00, 9.6453918775E-01],
	[3.85450E+04, 3.2622555954E+01, 5.4048736456E+00, 1.5599756943E+01, 3.5742956480E+00, 9.6455646117E-01],
	[3.85500E+04, 3.2629866260E+01, 5.4049000354E+00, 1.5606389963E+01, 3.5747430563E+00, 9.6457372562E-01],
	[3.85550E+04, 3.2637177255E+01, 5.4049264219E+00, 1.5613024942E+01, 3.5751903510E+00, 9.6459098110E-01],
	[3.85600E+04, 3.2644488940E+01, 5.4049528050E+00, 1.5619661882E+01, 3.5756375319E+00, 9.6460822763E-01],
	[3.85650E+04, 3.2651801314E+01, 5.4049791849E+00, 1.5626300781E+01, 3.5760845992E+00, 9.6462546520E-01],
	[3.85700E+04, 3.2659114378E+01, 5.4050055615E+00, 1.5632941641E+01, 3.5765315527E+00, 9.6464269382E-01],
	[3.85750E+04, 3.2666428132E+01, 5.4050319348E+00, 1.5639584462E+01, 3.5769783926E+00, 9.6465991350E-01],
	[3.85800E+04, 3.2673742575E+01, 5.4050583048E+00, 1.5646229244E+01, 3.5774251189E+00, 9.6467712424E-01],
	[3.85850E+04, 3.2681057708E+01, 5.4050846715E+00, 1.5652875988E+01, 3.5778717316E+00, 9.6469432603E-01],
	[3.85900E+04, 3.2688373531E+01, 5.4051110349E+00, 1.5659524693E+01, 3.5783182307E+00, 9.6471151890E-01],
	[3.85950E+04, 3.2695690043E+01, 5.4051373950E+00, 1.5666175360E+01, 3.5787646163E+00, 9.6472870284E-01],
	[3.86000E+04, 3.2703007244E+01, 5.4051637519E+00, 1.5672827990E+01, 3.5792108883E+00, 9.6474587786E-01],
	[3.86050E+04, 3.2710342643E+01, 5.4051924048E+00, 1.5679482583E+01, 3.5796582649E+00, 9.6476304396E-01],
	[3.86100E+04, 3.2717706169E+01, 5.4052246562E+00, 1.5686139139E+01, 3.5801074370E+00, 9.6478020114E-01],
	[3.86150E+04, 3.2725070399E+01, 5.4052569037E+00, 1.5692797659E+01, 3.5805564965E+00, 9.6479734942E-01],
	[3.86200E+04, 3.2732435332E+01, 5.4052891471E+00, 1.5699458142E+01, 3.5810054435E+00, 9.6481448879E-01],
	[3.86250E+04, 3.2739800969E+01, 5.4053213866E+00, 1.5706120589E+01, 3.5814542779E+00, 9.6483161926E-01],
	[3.86300E+04, 3.2747167310E+01, 5.4053536221E+00, 1.5712785001E+01, 3.5819029997E+00, 9.6484874084E-01],
	[3.86350E+04, 3.2754534355E+01, 5.4053858536E+00, 1.5719451377E+01, 3.5823516091E+00, 9.6486585352E-01],
	[3.86400E+04, 3.2761902103E+01, 5.4054180811E+00, 1.5726119719E+01, 3.5828001059E+00, 9.6488295732E-01],
	[3.86450E+04, 3.2769270555E+01, 5.4054503046E+00, 1.5732790025E+01, 3.5832484903E+00, 9.6490005223E-01],
	[3.86500E+04, 3.2776639711E+01, 5.4054825242E+00, 1.5739462298E+01, 3.5836967622E+00, 9.6491713827E-01],
	[3.86550E+04, 3.2784009570E+01, 5.4055147398E+00, 1.5746136537E+01, 3.5841449217E+00, 9.6493421543E-01],
	[3.86600E+04, 3.2791380133E+01, 5.4055469514E+00, 1.5752812742E+01, 3.5845929687E+00, 9.6495128373E-01],
	[3.86650E+04, 3.2798751399E+01, 5.4055791590E+00, 1.5759490914E+01, 3.5850409034E+00, 9.6496834316E-01],
	[3.86700E+04, 3.2806123369E+01, 5.4056113627E+00, 1.5766171052E+01, 3.5854887256E+00, 9.6498539374E-01],
	[3.86750E+04, 3.2813496043E+01, 5.4056435624E+00, 1.5772853159E+01, 3.5859364356E+00, 9.6500243545E-01],
	[3.86800E+04, 3.2820869420E+01, 5.4056757581E+00, 1.5779537232E+01, 3.5863840331E+00, 9.6501946832E-01],
	[3.86850E+04, 3.2828243500E+01, 5.4057079499E+00, 1.5786223274E+01, 3.5868315184E+00, 9.6503649234E-01],
	[3.86900E+04, 3.2835618284E+01, 5.4057401377E+00, 1.5792911284E+01, 3.5872788913E+00, 9.6505350752E-01],
	[3.86950E+04, 3.2842993771E+01, 5.4057723215E+00, 1.5799601263E+01, 3.5877261520E+00, 9.6507051387E-01],
	[3.87000E+04, 3.2850369961E+01, 5.4058045014E+00, 1.5806293211E+01, 3.5881733004E+00, 9.6508751138E-01],
	[3.87050E+04, 3.2857746855E+01, 5.4058366773E+00, 1.5812987128E+01, 3.5886203366E+00, 9.6510450006E-01],
	[3.87100E+04, 3.2865124452E+01, 5.4058688492E+00, 1.5819683015E+01, 3.5890672606E+00, 9.6512147992E-01],
	[3.87150E+04, 3.2872502753E+01, 5.4059010171E+00, 1.5826380871E+01, 3.5895140723E+00, 9.6513845096E-01],
	[3.87200E+04, 3.2879881757E+01, 5.4059331811E+00, 1.5833080698E+01, 3.5899607719E+00, 9.6515541319E-01],
	[3.87250E+04, 3.2887261464E+01, 5.4059653412E+00, 1.5839782496E+01, 3.5904073593E+00, 9.6517236660E-01],
	[3.87300E+04, 3.2894641874E+01, 5.4059974973E+00, 1.5846486264E+01, 3.5908538346E+00, 9.6518931122E-01],
	[3.87350E+04, 3.2902022988E+01, 5.4060296494E+00, 1.5853192004E+01, 3.5913001978E+00, 9.6520624703E-01],
	[3.87400E+04, 3.2909404804E+01, 5.4060617975E+00, 1.5859899715E+01, 3.5917464488E+00, 9.6522317404E-01],
	[3.87450E+04, 3.2916787324E+01, 5.4060939417E+00, 1.5866609398E+01, 3.5921925878E+00, 9.6524009227E-01],
	[3.87500E+04, 3.2924170547E+01, 5.4061260820E+00, 1.5873321053E+01, 3.5926386147E+00, 9.6525700170E-01],
	[3.87550E+04, 3.2931554473E+01, 5.4061582183E+00, 1.5880034681E+01, 3.5930845296E+00, 9.6527390236E-01],
	[3.87600E+04, 3.2938939103E+01, 5.4061903506E+00, 1.5886750282E+01, 3.5935303325E+00, 9.6529079423E-01],
	[3.87650E+04, 3.2946324435E+01, 5.4062224790E+00, 1.5893467856E+01, 3.5939760233E+00, 9.6530767733E-01],
	[3.87700E+04, 3.2953710470E+01, 5.4062546034E+00, 1.5900187404E+01, 3.5944216022E+00, 9.6532455167E-01],
	[3.87750E+04, 3.2961097209E+01, 5.4062867239E+00, 1.5906908925E+01, 3.5948670692E+00, 9.6534141724E-01],
	[3.87800E+04, 3.2968484650E+01, 5.4063188404E+00, 1.5913632421E+01, 3.5953124241E+00, 9.6535827404E-01],
	[3.87850E+04, 3.2975872795E+01, 5.4063509530E+00, 1.5920357891E+01, 3.5957576672E+00, 9.6537512210E-01],
	[3.87900E+04, 3.2983261642E+01, 5.4063830616E+00, 1.5927085335E+01, 3.5962027984E+00, 9.6539196140E-01],
	[3.87950E+04, 3.2990651192E+01, 5.4064151663E+00, 1.5933814755E+01, 3.5966478177E+00, 9.6540879196E-01],
	[3.88000E+04, 3.2998041445E+01, 5.4064472670E+00, 1.5940546151E+01, 3.5970927251E+00, 9.6542561377E-01],
	[3.88050E+04, 3.3005432401E+01, 5.4064793638E+00, 1.5947279522E+01, 3.5975375207E+00, 9.6544242685E-01],
	[3.88100E+04, 3.3012824060E+01, 5.4065114566E+00, 1.5954014870E+01, 3.5979822045E+00, 9.6545923119E-01],
	[3.88150E+04, 3.3020216422E+01, 5.4065435455E+00, 1.5960752194E+01, 3.5984267764E+00, 9.6547602681E-01],
	[3.88200E+04, 3.3027609487E+01, 5.4065756304E+00, 1.5967491494E+01, 3.5988712366E+00, 9.6549281370E-01],
	[3.88250E+04, 3.3035003254E+01, 5.4066077115E+00, 1.5974232772E+01, 3.5993155851E+00, 9.6550959187E-01],
	[3.88300E+04, 3.3042397724E+01, 5.4066397885E+00, 1.5980976027E+01, 3.5997598218E+00, 9.6552636133E-01],
	[3.88350E+04, 3.3049792897E+01, 5.4066718617E+00, 1.5987721260E+01, 3.6002039468E+00, 9.6554312208E-01],
	[3.88400E+04, 3.3057188773E+01, 5.4067039308E+00, 1.5994468471E+01, 3.6006479600E+00, 9.6555987412E-01],
	[3.88450E+04, 3.3064585351E+01, 5.4067359961E+00, 1.6001217661E+01, 3.6010918616E+00, 9.6557661746E-01],
	[3.88500E+04, 3.3071982632E+01, 5.4067680574E+00, 1.6007968829E+01, 3.6015356516E+00, 9.6559335210E-01],
	[3.88550E+04, 3.3079380615E+01, 5.4068001148E+00, 1.6014721976E+01, 3.6019793299E+00, 9.6561007806E-01],
	[3.88600E+04, 3.3086779302E+01, 5.4068321682E+00, 1.6021477103E+01, 3.6024228966E+00, 9.6562679532E-01],
	[3.88650E+04, 3.3094178690E+01, 5.4068642177E+00, 1.6028234209E+01, 3.6028663517E+00, 9.6564350390E-01],
	[3.88700E+04, 3.3101578782E+01, 5.4068962633E+00, 1.6034993295E+01, 3.6033096952E+00, 9.6566020380E-01],
	[3.88750E+04, 3.3108979576E+01, 5.4069283050E+00, 1.6041754362E+01, 3.6037529272E+00, 9.6567689503E-01],
	[3.88800E+04, 3.3116381072E+01, 5.4069603427E+00, 1.6048517409E+01, 3.6041960476E+00, 9.6569357759E-01],
	[3.88850E+04, 3.3123783271E+01, 5.4069923765E+00, 1.6055282438E+01, 3.6046390566E+00, 9.6571025148E-01],
	[3.88900E+04, 3.3131186173E+01, 5.4070244063E+00, 1.6062049447E+01, 3.6050819540E+00, 9.6572691672E-01],
	[3.88950E+04, 3.3138589777E+01, 5.4070564322E+00, 1.6068818439E+01, 3.6055247399E+00, 9.6574357329E-01],
	[3.89000E+04, 3.3145994083E+01, 5.4070884542E+00, 1.6075589412E+01, 3.6059674144E+00, 9.6576022122E-01],
	[3.89050E+04, 3.3153399092E+01, 5.4071204723E+00, 1.6082362368E+01, 3.6064099775E+00, 9.6577686050E-01],
	[3.89100E+04, 3.3160804803E+01, 5.4071524865E+00, 1.6089137306E+01, 3.6068524291E+00, 9.6579349114E-01],
	[3.89150E+04, 3.3168211216E+01, 5.4071844967E+00, 1.6095914227E+01, 3.6072947694E+00, 9.6581011313E-01],
	[3.89200E+04, 3.3175618332E+01, 5.4072165030E+00, 1.6102693132E+01, 3.6077369983E+00, 9.6582672650E-01],
	[3.89250E+04, 3.3183026150E+01, 5.4072485054E+00, 1.6109474020E+01, 3.6081791158E+00, 9.6584333123E-01],
	[3.89300E+04, 3.3190434671E+01, 5.4072805038E+00, 1.6116256892E+01, 3.6086211220E+00, 9.6585992734E-01],
	[3.89350E+04, 3.3197843894E+01, 5.4073124984E+00, 1.6123041748E+01, 3.6090630169E+00, 9.6587651484E-01],
	[3.89400E+04, 3.3205253819E+01, 5.4073444890E+00, 1.6129828589E+01, 3.6095048005E+00, 9.6589309371E-01],
	[3.89450E+04, 3.3212664446E+01, 5.4073764757E+00, 1.6136617415E+01, 3.6099464728E+00, 9.6590966398E-01],
	[3.89500E+04, 3.3220075775E+01, 5.4074084585E+00, 1.6143408226E+01, 3.6103880339E+00, 9.6592622564E-01],
	[3.89550E+04, 3.3227487807E+01, 5.4074404373E+00, 1.6150201023E+01, 3.6108294837E+00, 9.6594277869E-01],
	[3.89600E+04, 3.3234900540E+01, 5.4074724123E+00, 1.6156995805E+01, 3.6112708223E+00, 9.6595932315E-01],
	[3.89650E+04, 3.3242313976E+01, 5.4075043833E+00, 1.6163792574E+01, 3.6117120498E+00, 9.6597585902E-01],
	[3.89700E+04, 3.3249728114E+01, 5.4075363505E+00, 1.6170591329E+01, 3.6121531660E+00, 9.6599238630E-01],
	[3.89750E+04, 3.3257142954E+01, 5.4075683137E+00, 1.6177392072E+01, 3.6125941712E+00, 9.6600890499E-01],
	[3.89800E+04, 3.3264558496E+01, 5.4076002730E+00, 1.6184194801E+01, 3.6130350652E+00, 9.6602541511E-01],
	[3.89850E+04, 3.3271974740E+01, 5.4076322284E+00, 1.6190999518E+01, 3.6134758480E+00, 9.6604191665E-01],
	[3.89900E+04, 3.3279391687E+01, 5.4076641798E+00, 1.6197806222E+01, 3.6139165198E+00, 9.6605840962E-01],
	[3.89950E+04, 3.3286809335E+01, 5.4076961274E+00, 1.6204614915E+01, 3.6143570806E+00, 9.6607489402E-01],
	[3.90000E+04, 3.3294227685E+01, 5.4077280711E+00, 1.6211425597E+01, 3.6147975303E+00, 9.6609136986E-01],
	[3.90050E+04, 3.3301646737E+01, 5.4077600108E+00, 1.6218238267E+01, 3.6152378689E+00, 9.6610783715E-01],
	[3.90100E+04, 3.3309066491E+01, 5.4077919467E+00, 1.6225052926E+01, 3.6156780966E+00, 9.6612429588E-01],
	[3.90150E+04, 3.3316486946E+01, 5.4078238786E+00, 1.6231869575E+01, 3.6161182132E+00, 9.6614074607E-01],
	[3.90200E+04, 3.3323908104E+01, 5.4078558067E+00, 1.6238688214E+01, 3.6165582189E+00, 9.6615718771E-01],
	[3.90250E+04, 3.3331329964E+01, 5.4078877308E+00, 1.6245508842E+01, 3.6169981137E+00, 9.6617362081E-01],
	[3.90300E+04, 3.3338752525E+01, 5.4079196511E+00, 1.6252331462E+01, 3.6174378975E+00, 9.6619004538E-01],
	[3.90350E+04, 3.3346175788E+01, 5.4079515674E+00, 1.6259156072E+01, 3.6178775705E+00, 9.6620646142E-01],
	[3.90400E+04, 3.3353599753E+01, 5.4079834799E+00, 1.6265982673E+01, 3.6183171325E+00, 9.6622286894E-01],
	[3.90450E+04, 3.3361024420E+01, 5.4080153884E+00, 1.6272811265E+01, 3.6187565837E+00, 9.6623926793E-01],
	[3.90500E+04, 3.3368449788E+01, 5.4080472930E+00, 1.6279641849E+01, 3.6191959241E+00, 9.6625565841E-01],
	[3.90550E+04, 3.3375875858E+01, 5.4080791938E+00, 1.6286474426E+01, 3.6196351536E+00, 9.6627204038E-01],
	[3.90600E+04, 3.3383302630E+01, 5.4081110906E+00, 1.6293308994E+01, 3.6200742723E+00, 9.6628841383E-01],
	[3.90650E+04, 3.3390730103E+01, 5.4081429836E+00, 1.6300145556E+01, 3.6205132803E+00, 9.6630477879E-01],
	[3.90700E+04, 3.3398158278E+01, 5.4081748727E+00, 1.6306984110E+01, 3.6209521774E+00, 9.6632113525E-01],
	[3.90750E+04, 3.3405587155E+01, 5.4082067578E+00, 1.6313824658E+01, 3.6213909639E+00, 9.6633748321E-01],
	[3.90800E+04, 3.3413016733E+01, 5.4082386391E+00, 1.6320667200E+01, 3.6218296396E+00, 9.6635382268E-01],
	[3.90850E+04, 3.3420447013E+01, 5.4082705165E+00, 1.6327511735E+01, 3.6222682047E+00, 9.6637015367E-01],
	[3.90900E+04, 3.3427877994E+01, 5.4083023900E+00, 1.6334358265E+01, 3.6227066590E+00, 9.6638647618E-01],
	[3.90950E+04, 3.3435309677E+01, 5.4083342596E+00, 1.6341206790E+01, 3.6231450027E+00, 9.6640279022E-01],
	[3.91000E+04, 3.3442742061E+01, 5.4083661253E+00, 1.6348057310E+01, 3.6235832358E+00, 9.6641909578E-01],
	[3.91050E+04, 3.3450175147E+01, 5.4083979872E+00, 1.6354909825E+01, 3.6240213583E+00, 9.6643539287E-01],
	[3.91100E+04, 3.3457608934E+01, 5.4084298451E+00, 1.6361764335E+01, 3.6244593701E+00, 9.6645168151E-01],
	[3.91150E+04, 3.3465043423E+01, 5.4084616992E+00, 1.6368620842E+01, 3.6248972714E+00, 9.6646796168E-01],
	[3.91200E+04, 3.3472478613E+01, 5.4084935494E+00, 1.6375479345E+01, 3.6253350621E+00, 9.6648423340E-01],
	[3.91250E+04, 3.3479914505E+01, 5.4085253957E+00, 1.6382339845E+01, 3.6257727423E+00, 9.6650049668E-01],
	[3.91300E+04, 3.3487351097E+01, 5.4085572381E+00, 1.6389202341E+01, 3.6262103120E+00, 9.6651675151E-01],
	[3.91350E+04, 3.3494788391E+01, 5.4085890766E+00, 1.6396066835E+01, 3.6266477712E+00, 9.6653299790E-01],
	[3.91400E+04, 3.3502226387E+01, 5.4086209113E+00, 1.6402933327E+01, 3.6270851200E+00, 9.6654923585E-01],
	[3.91450E+04, 3.3509665084E+01, 5.4086527420E+00, 1.6409801816E+01, 3.6275223583E+00, 9.6656546537E-01],
	[3.91500E+04, 3.3517104482E+01, 5.4086845689E+00, 1.6416672304E+01, 3.6279594861E+00, 9.6658168647E-01],
	[3.91550E+04, 3.3524544581E+01, 5.4087163920E+00, 1.6423544790E+01, 3.6283965036E+00, 9.6659789914E-01],
	[3.91600E+04, 3.3531985381E+01, 5.4087482111E+00, 1.6430419275E+01, 3.6288334106E+00, 9.6661410340E-01],
	[3.91650E+04, 3.3539426883E+01, 5.4087800264E+00, 1.6437295760E+01, 3.6292702073E+00, 9.6663029924E-01],
	[3.91700E+04, 3.3546869085E+01, 5.4088118378E+00, 1.6444174244E+01, 3.6297068937E+00, 9.6664648668E-01],
	[3.91750E+04, 3.3554311989E+01, 5.4088436453E+00, 1.6451054728E+01, 3.6301434697E+00, 9.6666266571E-01],
	[3.91800E+04, 3.3561755594E+01, 5.4088754489E+00, 1.6457937212E+01, 3.6305799354E+00, 9.6667883635E-01],
	[3.91850E+04, 3.3569199900E+01, 5.4089072487E+00, 1.6464821697E+01, 3.6310162908E+00, 9.6669499858E-01],
	[3.91900E+04, 3.3576644907E+01, 5.4089390446E+00, 1.6471708183E+01, 3.6314525360E+00, 9.6671115243E-01],
	[3.91950E+04, 3.3584090616E+01, 5.4089708366E+00, 1.6478596669E+01, 3.6318886710E+00, 9.6672729789E-01],
	[3.92000E+04, 3.3591537025E+01, 5.4090026248E+00, 1.6485487158E+01, 3.6323246957E+00, 9.6674343497E-01],
	[3.92050E+04, 3.3598984135E+01, 5.4090344091E+00, 1.6492379648E+01, 3.6327606102E+00, 9.6675956367E-01],
	[3.92100E+04, 3.3606431946E+01, 5.4090661896E+00, 1.6499274140E+01, 3.6331964145E+00, 9.6677568400E-01],
	[3.92150E+04, 3.3613880458E+01, 5.4090979661E+00, 1.6506170635E+01, 3.6336321087E+00, 9.6679179597E-01],
	[3.92200E+04, 3.3621329671E+01, 5.4091297388E+00, 1.6513069133E+01, 3.6340676927E+00, 9.6680789956E-01],
	[3.92250E+04, 3.3628779585E+01, 5.4091615077E+00, 1.6519969634E+01, 3.6345031667E+00, 9.6682399480E-01],
	[3.92300E+04, 3.3636230200E+01, 5.4091932726E+00, 1.6526872138E+01, 3.6349385305E+00, 9.6684008169E-01],
	[3.92350E+04, 3.3643681516E+01, 5.4092250338E+00, 1.6533776647E+01, 3.6353737843E+00, 9.6685616022E-01],
	[3.92400E+04, 3.3651133532E+01, 5.4092567910E+00, 1.6540683159E+01, 3.6358089280E+00, 9.6687223041E-01],
	[3.92450E+04, 3.3658586250E+01, 5.4092885444E+00, 1.6547591676E+01, 3.6362439616E+00, 9.6688829226E-01],
	[3.92500E+04, 3.3666039668E+01, 5.4093202939E+00, 1.6554502197E+01, 3.6366788853E+00, 9.6690434577E-01],
	[3.92550E+04, 3.3673493787E+01, 5.4093520396E+00, 1.6561414724E+01, 3.6371136990E+00, 9.6692039095E-01],
	[3.92600E+04, 3.3680948606E+01, 5.4093837814E+00, 1.6568329256E+01, 3.6375484027E+00, 9.6693642780E-01],
	[3.92650E+04, 3.3688404127E+01, 5.4094155194E+00, 1.6575245794E+01, 3.6379829964E+00, 9.6695245633E-01],
	[3.92700E+04, 3.3695860348E+01, 5.4094472535E+00, 1.6582164338E+01, 3.6384174802E+00, 9.6696847654E-01],
	[3.92750E+04, 3.3703317270E+01, 5.4094789838E+00, 1.6589084889E+01, 3.6388518541E+00, 9.6698448843E-01],
	[3.92800E+04, 3.3710774892E+01, 5.4095107102E+00, 1.6596007446E+01, 3.6392861182E+00, 9.6700049202E-01],
	[3.92850E+04, 3.3718233215E+01, 5.4095424327E+00, 1.6602932010E+01, 3.6397202723E+00, 9.6701648730E-01],
	[3.92900E+04, 3.3725692239E+01, 5.4095741514E+00, 1.6609858582E+01, 3.6401543166E+00, 9.6703247428E-01],
	[3.92950E+04, 3.3733151963E+01, 5.4096058663E+00, 1.6616787162E+01, 3.6405882511E+00, 9.6704845296E-01],
	[3.93000E+04, 3.3740612387E+01, 5.4096375773E+00, 1.6623717749E+01, 3.6410220758E+00, 9.6706442335E-01],
	[3.93050E+04, 3.3748073513E+01, 5.4096692844E+00, 1.6630650345E+01, 3.6414557907E+00, 9.6708038545E-01],
	[3.93100E+04, 3.3755535338E+01, 5.4097009877E+00, 1.6637584950E+01, 3.6418893959E+00, 9.6709633927E-01],
	[3.93150E+04, 3.3762997865E+01, 5.4097326872E+00, 1.6644521563E+01, 3.6423228913E+00, 9.6711228481E-01],
	[3.93200E+04, 3.3770461091E+01, 5.4097643828E+00, 1.6651460186E+01, 3.6427562770E+00, 9.6712822208E-01],
	[3.93250E+04, 3.3777925018E+01, 5.4097960746E+00, 1.6658400819E+01, 3.6431895530E+00, 9.6714415108E-01],
	[3.93300E+04, 3.3785389646E+01, 5.4098277625E+00, 1.6665343462E+01, 3.6436227193E+00, 9.6716007181E-01],
	[3.93350E+04, 3.3792854974E+01, 5.4098594466E+00, 1.6672288115E+01, 3.6440557759E+00, 9.6717598428E-01],
	[3.93400E+04, 3.3800321002E+01, 5.4098911268E+00, 1.6679234778E+01, 3.6444887230E+00, 9.6719188849E-01],
	[3.93450E+04, 3.3807787731E+01, 5.4099228032E+00, 1.6686183453E+01, 3.6449215604E+00, 9.6720778446E-01],
	[3.93500E+04, 3.3815255160E+01, 5.4099544758E+00, 1.6693134139E+01, 3.6453542882E+00, 9.6722367217E-01],
	[3.93550E+04, 3.3822723289E+01, 5.4099861445E+00, 1.6700086837E+01, 3.6457869064E+00, 9.6723955165E-01],
	[3.93600E+04, 3.3830192119E+01, 5.4100178094E+00, 1.6707041546E+01, 3.6462194151E+00, 9.6725542288E-01],
	[3.93650E+04, 3.3837661648E+01, 5.4100494704E+00, 1.6713998268E+01, 3.6466518143E+00, 9.6727128588E-01],
	[3.93700E+04, 3.3845131878E+01, 5.4100811276E+00, 1.6720957003E+01, 3.6470841040E+00, 9.6728714065E-01],
	[3.93750E+04, 3.3852602809E+01, 5.4101127810E+00, 1.6727917751E+01, 3.6475162841E+00, 9.6730298720E-01],
	[3.93800E+04, 3.3860074439E+01, 5.4101444305E+00, 1.6734880511E+01, 3.6479483548E+00, 9.6731882552E-01],
	[3.93850E+04, 3.3867546770E+01, 5.4101760762E+00, 1.6741845286E+01, 3.6483803161E+00, 9.6733465563E-01],
	[3.93900E+04, 3.3875019800E+01, 5.4102077181E+00, 1.6748812074E+01, 3.6488121679E+00, 9.6735047753E-01],
	[3.93950E+04, 3.3882493531E+01, 5.4102393561E+00, 1.6755780877E+01, 3.6492439104E+00, 9.6736629122E-01],
	[3.94000E+04, 3.3889967962E+01, 5.4102709904E+00, 1.6762751694E+01, 3.6496755434E+00, 9.6738209671E-01],
	[3.94050E+04, 3.3897443093E+01, 5.4103026207E+00, 1.6769724526E+01, 3.6501070671E+00, 9.6739789400E-01],
	[3.94100E+04, 3.3904918924E+01, 5.4103342473E+00, 1.6776699373E+01, 3.6505384815E+00, 9.6741368309E-01],
	[3.94150E+04, 3.3912395455E+01, 5.4103658700E+00, 1.6783676236E+01, 3.6509697865E+00, 9.6742946400E-01],
	[3.94200E+04, 3.3919872686E+01, 5.4103974889E+00, 1.6790655115E+01, 3.6514009823E+00, 9.6744523672E-01],
	[3.94250E+04, 3.3927350617E+01, 5.4104291040E+00, 1.6797636010E+01, 3.6518320687E+00, 9.6746100126E-01],
	[3.94300E+04, 3.3934829248E+01, 5.4104607153E+00, 1.6804618922E+01, 3.6522630459E+00, 9.6747675763E-01],
	[3.94350E+04, 3.3942308579E+01, 5.4104923227E+00, 1.6811603850E+01, 3.6526939139E+00, 9.6749250582E-01],
	[3.94400E+04, 3.3949788609E+01, 5.4105239263E+00, 1.6818590796E+01, 3.6531246727E+00, 9.6750824584E-01],
	[3.94450E+04, 3.3957269340E+01, 5.4105555261E+00, 1.6825579759E+01, 3.6535553222E+00, 9.6752397771E-01],
	[3.94500E+04, 3.3964750770E+01, 5.4105871220E+00, 1.6832570740E+01, 3.6539858626E+00, 9.6753970141E-01],
	[3.94550E+04, 3.3972232901E+01, 5.4106187142E+00, 1.6839563739E+01, 3.6544162939E+00, 9.6755541696E-01],
	[3.94600E+04, 3.3979715731E+01, 5.4106503025E+00, 1.6846558757E+01, 3.6548466160E+00, 9.6757112436E-01],
	[3.94650E+04, 3.3987199261E+01, 5.4106818870E+00, 1.6853555794E+01, 3.6552768290E+00, 9.6758682362E-01],
	[3.94700E+04, 3.3994683490E+01, 5.4107134677E+00, 1.6860554849E+01, 3.6557069330E+00, 9.6760251474E-01],
	[3.94750E+04, 3.4002168420E+01, 5.4107450446E+00, 1.6867555925E+01, 3.6561369278E+00, 9.6761819771E-01],
	[3.94800E+04, 3.4009654049E+01, 5.4107766176E+00, 1.6874559020E+01, 3.6565668137E+00, 9.6763387256E-01],
	[3.94850E+04, 3.4017140378E+01, 5.4108081869E+00, 1.6881564135E+01, 3.6569965905E+00, 9.6764953928E-01],
	[3.94900E+04, 3.4024627406E+01, 5.4108397523E+00, 1.6888571271E+01, 3.6574262583E+00, 9.6766519788E-01],
	[3.94950E+04, 3.4032115134E+01, 5.4108713139E+00, 1.6895580427E+01, 3.6578558171E+00, 9.6768084836E-01],
	[3.95000E+04, 3.4039603562E+01, 5.4109028717E+00, 1.6902591605E+01, 3.6582852670E+00, 9.6769649073E-01],
	[3.95050E+04, 3.4047092689E+01, 5.4109344257E+00, 1.6909604804E+01, 3.6587146079E+00, 9.6771212498E-01],
	[3.95100E+04, 3.4054582516E+01, 5.4109659759E+00, 1.6916620024E+01, 3.6591438399E+00, 9.6772775113E-01],
	[3.95150E+04, 3.4062073043E+01, 5.4109975223E+00, 1.6923637267E+01, 3.6595729630E+00, 9.6774336918E-01],
	[3.95200E+04, 3.4069564269E+01, 5.4110290649E+00, 1.6930656533E+01, 3.6600019773E+00, 9.6775897914E-01],
	[3.95250E+04, 3.4077056194E+01, 5.4110606036E+00, 1.6937677821E+01, 3.6604308827E+00, 9.6777458100E-01],
	[3.95300E+04, 3.4084548819E+01, 5.4110921386E+00, 1.6944701132E+01, 3.6608596792E+00, 9.6779017477E-01],
	[3.95350E+04, 3.4092042143E+01, 5.4111236697E+00, 1.6951726466E+01, 3.6612883670E+00, 9.6780576047E-01],
	[3.95400E+04, 3.4099536167E+01, 5.4111551971E+00, 1.6958753825E+01, 3.6617169460E+00, 9.6782133808E-01],
	[3.95450E+04, 3.4107030891E+01, 5.4111867206E+00, 1.6965783207E+01, 3.6621454162E+00, 9.6783690762E-01],
	[3.95500E+04, 3.4114526313E+01, 5.4112182404E+00, 1.6972814614E+01, 3.6625737776E+00, 9.6785246909E-01],
	[3.95550E+04, 3.4122022435E+01, 5.4112497563E+00, 1.6979848045E+01, 3.6630020304E+00, 9.6786802249E-01],
	[3.95600E+04, 3.4129519257E+01, 5.4112812685E+00, 1.6986883502E+01, 3.6634301744E+00, 9.6788356784E-01],
	[3.95650E+04, 3.4137016777E+01, 5.4113127768E+00, 1.6993920984E+01, 3.6638582098E+00, 9.6789910513E-01],
	[3.95700E+04, 3.4144514997E+01, 5.4113442814E+00, 1.7000960491E+01, 3.6642861365E+00, 9.6791463436E-01],
	[3.95750E+04, 3.4152013917E+01, 5.4113757821E+00, 1.7008002025E+01, 3.6647139545E+00, 9.6793015555E-01],
	[3.95800E+04, 3.4159513535E+01, 5.4114072791E+00, 1.7015045585E+01, 3.6651416640E+00, 9.6794566869E-01],
	[3.95850E+04, 3.4167013853E+01, 5.4114387722E+00, 1.7022091171E+01, 3.6655692648E+00, 9.6796117380E-01],
	[3.95900E+04, 3.4174514870E+01, 5.4114702616E+00, 1.7029138785E+01, 3.6659967571E+00, 9.6797667087E-01],
	[3.95950E+04, 3.4182016586E+01, 5.4115017472E+00, 1.7036188426E+01, 3.6664241408E+00, 9.6799215991E-01],
	[3.96000E+04, 3.4189519001E+01, 5.4115332289E+00, 1.7043240095E+01, 3.6668514160E+00, 9.6800764093E-01],
	[3.96050E+04, 3.4197022116E+01, 5.4115647069E+00, 1.7050293791E+01, 3.6672785827E+00, 9.6802311392E-01],
	[3.96100E+04, 3.4204525929E+01, 5.4115961811E+00, 1.7057349516E+01, 3.6677056409E+00, 9.6803857890E-01],
	[3.96150E+04, 3.4212030442E+01, 5.4116276515E+00, 1.7064407270E+01, 3.6681325906E+00, 9.6805403587E-01],
	[3.96200E+04, 3.4219535654E+01, 5.4116591181E+00, 1.7071467052E+01, 3.6685594319E+00, 9.6806948483E-01],
	[3.96250E+04, 3.4227041564E+01, 5.4116905810E+00, 1.7078528864E+01, 3.6689861647E+00, 9.6808492578E-01],
	[3.96300E+04, 3.4234548174E+01, 5.4117220400E+00, 1.7085592706E+01, 3.6694127892E+00, 9.6810035874E-01],
	[3.96350E+04, 3.4242055483E+01, 5.4117534953E+00, 1.7092658577E+01, 3.6698393053E+00, 9.6811578370E-01],
	[3.96400E+04, 3.4249563491E+01, 5.4117849467E+00, 1.7099726479E+01, 3.6702657130E+00, 9.6813120067E-01],
	[3.96450E+04, 3.4257072197E+01, 5.4118163944E+00, 1.7106796411E+01, 3.6706920124E+00, 9.6814660966E-01],
	[3.96500E+04, 3.4264581603E+01, 5.4118478383E+00, 1.7113868374E+01, 3.6711182034E+00, 9.6816201066E-01],
	[3.96550E+04, 3.4272091708E+01, 5.4118792785E+00, 1.7120942369E+01, 3.6715442862E+00, 9.6817740369E-01],
	[3.96600E+04, 3.4279602511E+01, 5.4119107148E+00, 1.7128018395E+01, 3.6719702607E+00, 9.6819278874E-01],
	[3.96650E+04, 3.4287114013E+01, 5.4119421474E+00, 1.7135096453E+01, 3.6723961269E+00, 9.6820816583E-01],
	[3.96700E+04, 3.4294626214E+01, 5.4119735761E+00, 1.7142176543E+01, 3.6728218849E+00, 9.6822353495E-01],
	[3.96750E+04, 3.4302139114E+01, 5.4120050011E+00, 1.7149258666E+01, 3.6732475347E+00, 9.6823889612E-01],
	[3.96800E+04, 3.4309652713E+01, 5.4120364224E+00, 1.7156342822E+01, 3.6736730763E+00, 9.6825424932E-01],
	[3.96850E+04, 3.4317167010E+01, 5.4120678398E+00, 1.7163429011E+01, 3.6740985098E+00, 9.6826959458E-01],
	[3.96900E+04, 3.4324682007E+01, 5.4120992535E+00, 1.7170517233E+01, 3.6745238351E+00, 9.6828493189E-01],
	[3.96950E+04, 3.4332197702E+01, 5.4121306634E+00, 1.7177607490E+01, 3.6749490522E+00, 9.6830026126E-01],
	[3.97000E+04, 3.4339714095E+01, 5.4121620695E+00, 1.7184699780E+01, 3.6753741613E+00, 9.6831558269E-01],
	[3.97050E+04, 3.4347231187E+01, 5.4121934719E+00, 1.7191794105E+01, 3.6757991623E+00, 9.6833089619E-01],
	[3.97100E+04, 3.4354748978E+01, 5.4122248704E+00, 1.7198890465E+01, 3.6762240552E+00, 9.6834620176E-01],
	[3.97150E+04, 3.4362267468E+01, 5.4122562652E+00, 1.7205988860E+01, 3.6766488401E+00, 9.6836149941E-01],
	[3.97200E+04, 3.4369786656E+01, 5.4122876563E+00, 1.7213089291E+01, 3.6770735170E+00, 9.6837678914E-01],
	[3.97250E+04, 3.4377306543E+01, 5.4123190435E+00, 1.7220191758E+01, 3.6774980859E+00, 9.6839207095E-01],
	[3.97300E+04, 3.4384827128E+01, 5.4123504270E+00, 1.7227296260E+01, 3.6779225468E+00, 9.6840734485E-01],
	[3.97350E+04, 3.4392348412E+01, 5.4123818068E+00, 1.7234402799E+01, 3.6783468998E+00, 9.6842261084E-01],
	[3.97400E+04, 3.4399870394E+01, 5.4124131827E+00, 1.7241511375E+01, 3.6787711448E+00, 9.6843786893E-01],
	[3.97450E+04, 3.4407393075E+01, 5.4124445549E+00, 1.7248621989E+01, 3.6791952820E+00, 9.6845311912E-01],
	[3.97500E+04, 3.4414916455E+01, 5.4124759234E+00, 1.7255734639E+01, 3.6796193112E+00, 9.6846836142E-01],
	[3.97550E+04, 3.4422440532E+01, 5.4125072880E+00, 1.7262849328E+01, 3.6800432326E+00, 9.6848359583E-01],
	[3.97600E+04, 3.4429965309E+01, 5.4125386490E+00, 1.7269966054E+01, 3.6804670461E+00, 9.6849882236E-01],
	[3.97650E+04, 3.4437490783E+01, 5.4125700061E+00, 1.7277084819E+01, 3.6808907518E+00, 9.6851404100E-01],
	[3.97700E+04, 3.4445016956E+01, 5.4126013595E+00, 1.7284205623E+01, 3.6813143498E+00, 9.6852925177E-01],
	[3.97750E+04, 3.4452543827E+01, 5.4126327091E+00, 1.7291328466E+01, 3.6817378399E+00, 9.6854445467E-01],
	[3.97800E+04, 3.4460071397E+01, 5.4126640550E+00, 1.7298453348E+01, 3.6821612223E+00, 9.6855964970E-01],
	[3.97850E+04, 3.4467599665E+01, 5.4126953971E+00, 1.7305580270E+01, 3.6825844969E+00, 9.6857483686E-01],
	[3.97900E+04, 3.4475128631E+01, 5.4127267354E+00, 1.7312709233E+01, 3.6830076639E+00, 9.6859001617E-01],
	[3.97950E+04, 3.4482658296E+01, 5.4127580700E+00, 1.7319840235E+01, 3.6834307231E+00, 9.6860518763E-01],
	[3.98000E+04, 3.4490188658E+01, 5.4127894009E+00, 1.7326973279E+01, 3.6838536747E+00, 9.6862035123E-01],
	[3.98050E+04, 3.4497719719E+01, 5.4128207280E+00, 1.7334108363E+01, 3.6842765186E+00, 9.6863550699E-01],
	[3.98100E+04, 3.4505251479E+01, 5.4128520513E+00, 1.7341245489E+01, 3.6846992549E+00, 9.6865065491E-01],
	[3.98150E+04, 3.4512783936E+01, 5.4128833709E+00, 1.7348384657E+01, 3.6851218836E+00, 9.6866579499E-01],
	[3.98200E+04, 3.4520317091E+01, 5.4129146867E+00, 1.7355525866E+01, 3.6855444047E+00, 9.6868092723E-01],
	[3.98250E+04, 3.4527850945E+01, 5.4129459988E+00, 1.7362669119E+01, 3.6859668183E+00, 9.6869605165E-01],
	[3.98300E+04, 3.4535385496E+01, 5.4129773071E+00, 1.7369814413E+01, 3.6863891243E+00, 9.6871116825E-01],
	[3.98350E+04, 3.4542920746E+01, 5.4130086117E+00, 1.7376961751E+01, 3.6868113228E+00, 9.6872627703E-01],
	[3.98400E+04, 3.4550456694E+01, 5.4130399125E+00, 1.7384111132E+01, 3.6872334138E+00, 9.6874137799E-01],
	[3.98450E+04, 3.4557993340E+01, 5.4130712096E+00, 1.7391262557E+01, 3.6876553973E+00, 9.6875647114E-01],
	[3.98500E+04, 3.4565530684E+01, 5.4131025029E+00, 1.7398416026E+01, 3.6880772734E+00, 9.6877155649E-01],
	[3.98550E+04, 3.4573068725E+01, 5.4131337925E+00, 1.7405571540E+01, 3.6884990420E+00, 9.6878663403E-01],
	[3.98600E+04, 3.4580607465E+01, 5.4131650784E+00, 1.7412729098E+01, 3.6889207032E+00, 9.6880170378E-01],
	[3.98650E+04, 3.4588146903E+01, 5.4131963605E+00, 1.7419888701E+01, 3.6893422571E+00, 9.6881676573E-01],
	[3.98700E+04, 3.4595687039E+01, 5.4132276388E+00, 1.7427050349E+01, 3.6897637035E+00, 9.6883181990E-01],
	[3.98750E+04, 3.4603227872E+01, 5.4132589134E+00, 1.7434214043E+01, 3.6901850427E+00, 9.6884686628E-01],
	[3.98800E+04, 3.4610769403E+01, 5.4132901843E+00, 1.7441379783E+01, 3.6906062745E+00, 9.6886190488E-01],
	[3.98850E+04, 3.4618311633E+01, 5.4133214515E+00, 1.7448547569E+01, 3.6910273990E+00, 9.6887693570E-01],
	[3.98900E+04, 3.4625854560E+01, 5.4133527149E+00, 1.7455717402E+01, 3.6914484162E+00, 9.6889195875E-01],
	[3.98950E+04, 3.4633398185E+01, 5.4133839745E+00, 1.7462889282E+01, 3.6918693262E+00, 9.6890697404E-01],
	[3.99000E+04, 3.4640942507E+01, 5.4134152304E+00, 1.7470063210E+01, 3.6922901289E+00, 9.6892198156E-01],
	[3.99050E+04, 3.4648487528E+01, 5.4134464826E+00, 1.7477239184E+01, 3.6927108245E+00, 9.6893698133E-01],
	[3.99100E+04, 3.4656033246E+01, 5.4134777311E+00, 1.7484417207E+01, 3.6931314128E+00, 9.6895197334E-01],
	[3.99150E+04, 3.4663579661E+01, 5.4135089758E+00, 1.7491597278E+01, 3.6935518940E+00, 9.6896695760E-01],
	[3.99200E+04, 3.4671126775E+01, 5.4135402168E+00, 1.7498779398E+01, 3.6939722680E+00, 9.6898193411E-01],
	[3.99250E+04, 3.4678674586E+01, 5.4135714540E+00, 1.7505963567E+01, 3.6943925349E+00, 9.6899690289E-01],
	[3.99300E+04, 3.4686223095E+01, 5.4136026876E+00, 1.7513149785E+01, 3.6948126947E+00, 9.6901186392E-01],
	[3.99350E+04, 3.4693772301E+01, 5.4136339174E+00, 1.7520338053E+01, 3.6952327474E+00, 9.6902681723E-01],
	[3.99400E+04, 3.4701322205E+01, 5.4136651434E+00, 1.7527528370E+01, 3.6956526930E+00, 9.6904176281E-01],
	[3.99450E+04, 3.4708872807E+01, 5.4136963658E+00, 1.7534720738E+01, 3.6960725316E+00, 9.6905670066E-01],
	[3.99500E+04, 3.4716424106E+01, 5.4137275844E+00, 1.7541915156E+01, 3.6964922632E+00, 9.6907163080E-01],
	[3.99550E+04, 3.4723976103E+01, 5.4137587992E+00, 1.7549111625E+01, 3.6969118878E+00, 9.6908655321E-01],
	[3.99600E+04, 3.4731528797E+01, 5.4137900104E+00, 1.7556310146E+01, 3.6973314054E+00, 9.6910146792E-01],
	[3.99650E+04, 3.4739082189E+01, 5.4138212178E+00, 1.7563510718E+01, 3.6977508161E+00, 9.6911637493E-01],
	[3.99700E+04, 3.4746636278E+01, 5.4138524215E+00, 1.7570713342E+01, 3.6981701198E+00, 9.6913127423E-01],
	[3.99750E+04, 3.4754191064E+01, 5.4138836215E+00, 1.7577918018E+01, 3.6985893166E+00, 9.6914616583E-01],
	[3.99800E+04, 3.4761746548E+01, 5.4139148178E+00, 1.7585124747E+01, 3.6990084066E+00, 9.6916104974E-01],
	[3.99850E+04, 3.4769302730E+01, 5.4139460103E+00, 1.7592333529E+01, 3.6994273897E+00, 9.6917592596E-01],
	[3.99900E+04, 3.4776859608E+01, 5.4139771991E+00, 1.7599544363E+01, 3.6998462659E+00, 9.6919079449E-01],
	[3.99950E+04, 3.4784417184E+01, 5.4140083842E+00, 1.7606757252E+01, 3.7002650353E+00, 9.6920565535E-01],
	[4.00000E+04, 3.4791975458E+01, 5.4140395656E+00, 1.7613972194E+01, 3.7006836979E+00, 9.6922050853E-01],
	[4.00050E+04, 3.4799534428E+01, 5.4140707432E+00, 1.7621216552E+01, 3.7011034608E+00, 9.6923535403E-01],
	[4.00100E+04, 3.4807094096E+01, 5.4141019172E+00, 1.7628462983E+01, 3.7015231164E+00, 9.6925019187E-01],
	[4.00150E+04, 3.4814654462E+01, 5.4141330874E+00, 1.7635711488E+01, 3.7019426646E+00, 9.6926502205E-01],
	[4.00200E+04, 3.4822215524E+01, 5.4141642539E+00, 1.7642962068E+01, 3.7023621055E+00, 9.6927984457E-01],
	[4.00250E+04, 3.4829777284E+01, 5.4141954167E+00, 1.7650214722E+01, 3.7027814392E+00, 9.6929465943E-01],
	[4.00300E+04, 3.4837339740E+01, 5.4142265758E+00, 1.7657469451E+01, 3.7032006656E+00, 9.6930946664E-01],
	[4.00350E+04, 3.4844902894E+01, 5.4142577312E+00, 1.7664726255E+01, 3.7036197847E+00, 9.6932426621E-01],
	[4.00400E+04, 3.4852466745E+01, 5.4142888828E+00, 1.7671985134E+01, 3.7040387966E+00, 9.6933905813E-01],
	[4.00450E+04, 3.4860031294E+01, 5.4143200308E+00, 1.7679246090E+01, 3.7044577013E+00, 9.6935384242E-01],
	[4.00500E+04, 3.4867596539E+01, 5.4143511750E+00, 1.7686509122E+01, 3.7048764989E+00, 9.6936861908E-01],
	[4.00550E+04, 3.4875162481E+01, 5.4143823155E+00, 1.7693774230E+01, 3.7052951893E+00, 9.6938338810E-01],
	[4.00600E+04, 3.4882729121E+01, 5.4144134524E+00, 1.7701041416E+01, 3.7057137726E+00, 9.6939814950E-01],
	[4.00650E+04, 3.4890296457E+01, 5.4144445855E+00, 1.7708310678E+01, 3.7061322487E+00, 9.6941290329E-01],
	[4.00700E+04, 3.4897864491E+01, 5.4144757149E+00, 1.7715582018E+01, 3.7065506178E+00, 9.6942764945E-01],
	[4.00750E+04, 3.4905433221E+01, 5.4145068406E+00, 1.7722855436E+01, 3.7069688798E+00, 9.6944238801E-01],
	[4.00800E+04, 3.4913002649E+01, 5.4145379626E+00, 1.7730130933E+01, 3.7073870348E+00, 9.6945711895E-01],
	[4.00850E+04, 3.4920572773E+01, 5.4145690809E+00, 1.7737408507E+01, 3.7078050828E+00, 9.6947184230E-01],
	[4.00900E+04, 3.4928143594E+01, 5.4146001955E+00, 1.7744688161E+01, 3.7082230237E+00, 9.6948655804E-01],
	[4.00950E+04, 3.4935715112E+01, 5.4146313064E+00, 1.7751969894E+01, 3.7086408577E+00, 9.6950126619E-01],
	[4.01000E+04, 3.4943287327E+01, 5.4146624136E+00, 1.7759253707E+01, 3.7090585847E+00, 9.6951596674E-01],
	[4.01050E+04, 3.4950860239E+01, 5.4146935170E+00, 1.7766539599E+01, 3.7094762048E+00, 9.6953065971E-01],
	[4.01100E+04, 3.4958433848E+01, 5.4147246168E+00, 1.7773827572E+01, 3.7098937180E+00, 9.6954534509E-01],
	[4.01150E+04, 3.4966008153E+01, 5.4147557129E+00, 1.7781117625E+01, 3.7103111244E+00, 9.6956002289E-01],
	[4.01200E+04, 3.4973583155E+01, 5.4147868053E+00, 1.7788409759E+01, 3.7107284238E+00, 9.6957469311E-01],
	[4.01250E+04, 3.4981158854E+01, 5.4148178940E+00, 1.7795703975E+01, 3.7111456164E+00, 9.6958935576E-01],
	[4.01300E+04, 3.4988735250E+01, 5.4148489790E+00, 1.7803000272E+01, 3.7115627022E+00, 9.6960401084E-01],
	[4.01350E+04, 3.4996312342E+01, 5.4148800603E+00, 1.7810298651E+01, 3.7119796812E+00, 9.6961865835E-01],
	[4.01400E+04, 3.5003890131E+01, 5.4149111380E+00, 1.7817599112E+01, 3.7123965534E+00, 9.6963329829E-01],
	[4.01450E+04, 3.5011487507E+01, 5.4149446554E+00, 1.7824901656E+01, 3.7128146801E+00, 9.6964793068E-01],
	[4.01500E+04, 3.5019109978E+01, 5.4149813237E+00, 1.7832206283E+01, 3.7132344581E+00, 9.6966255551E-01],
	[4.01550E+04, 3.5026733159E+01, 5.4150179876E+00, 1.7839512993E+01, 3.7136541301E+00, 9.6967717279E-01],
	[4.01600E+04, 3.5034357050E+01, 5.4150546471E+00, 1.7846821786E+01, 3.7140736963E+00, 9.6969178252E-01],
	[4.01650E+04, 3.5041981651E+01, 5.4150913024E+00, 1.7854132664E+01, 3.7144931565E+00, 9.6970638471E-01],
	[4.01700E+04, 3.5049606961E+01, 5.4151279533E+00, 1.7861445626E+01, 3.7149125109E+00, 9.6972097936E-01],
	[4.01750E+04, 3.5057232982E+01, 5.4151646000E+00, 1.7868760672E+01, 3.7153317594E+00, 9.6973556647E-01],
	[4.01800E+04, 3.5064859713E+01, 5.4152012423E+00, 1.7876077803E+01, 3.7157509021E+00, 9.6975014604E-01],
	[4.01850E+04, 3.5072487153E+01, 5.4152378803E+00, 1.7883397020E+01, 3.7161699390E+00, 9.6976471809E-01],
	[4.01900E+04, 3.5080115304E+01, 5.4152745140E+00, 1.7890718322E+01, 3.7165888701E+00, 9.6977928261E-01],
	[4.01950E+04, 3.5087744164E+01, 5.4153111434E+00, 1.7898041710E+01, 3.7170076955E+00, 9.6979383961E-01],
	[4.02000E+04, 3.5095373734E+01, 5.4153477685E+00, 1.7905367185E+01, 3.7174264151E+00, 9.6980838909E-01],
	[4.02050E+04, 3.5103004014E+01, 5.4153843893E+00, 1.7912694746E+01, 3.7178450290E+00, 9.6982293105E-01],
	[4.02100E+04, 3.5110635003E+01, 5.4154210057E+00, 1.7920024394E+01, 3.7182635372E+00, 9.6983746550E-01],
	[4.02150E+04, 3.5118266703E+01, 5.4154576179E+00, 1.7927356129E+01, 3.7186819397E+00, 9.6985199245E-01],
	[4.02200E+04, 3.5125899112E+01, 5.4154942258E+00, 1.7934689952E+01, 3.7191002365E+00, 9.6986651189E-01],
	[4.02250E+04, 3.5133532230E+01, 5.4155308293E+00, 1.7942025862E+01, 3.7195184278E+00, 9.6988102383E-01],
	[4.02300E+04, 3.5141166059E+01, 5.4155674286E+00, 1.7949363861E+01, 3.7199365134E+00, 9.6989552828E-01],
	[4.02350E+04, 3.5148800597E+01, 5.4156040235E+00, 1.7956703949E+01, 3.7203544934E+00, 9.6991002523E-01],
	[4.02400E+04, 3.5156435845E+01, 5.4156406142E+00, 1.7964046126E+01, 3.7207723679E+00, 9.6992451470E-01],
	[4.02450E+04, 3.5164071802E+01, 5.4156772005E+00, 1.7971390392E+01, 3.7211901368E+00, 9.6993899668E-01],
	[4.02500E+04, 3.5171708469E+01, 5.4157137826E+00, 1.7978736747E+01, 3.7216078002E+00, 9.6995347117E-01],
	[4.02550E+04, 3.5179345845E+01, 5.4157503604E+00, 1.7986085193E+01, 3.7220253581E+00, 9.6996793819E-01],
	[4.02600E+04, 3.5186983932E+01, 5.4157869338E+00, 1.7993435728E+01, 3.7224428106E+00, 9.6998239774E-01],
	[4.02650E+04, 3.5194622727E+01, 5.4158235030E+00, 1.8000788355E+01, 3.7228601575E+00, 9.6999684981E-01],
	[4.02700E+04, 3.5202262232E+01, 5.4158600679E+00, 1.8008143072E+01, 3.7232773991E+00, 9.7001129442E-01],
	[4.02750E+04, 3.5209902447E+01, 5.4158966285E+00, 1.8015499881E+01, 3.7236945352E+00, 9.7002573157E-01],
	[4.02800E+04, 3.5217543371E+01, 5.4159331847E+00, 1.8022858781E+01, 3.7241115659E+00, 9.7004016125E-01],
	[4.02850E+04, 3.5225185004E+01, 5.4159697367E+00, 1.8030219773E+01, 3.7245284913E+00, 9.7005458348E-01],
	[4.02900E+04, 3.5232827347E+01, 5.4160062844E+00, 1.8037582858E+01, 3.7249453113E+00, 9.7006899826E-01],
	[4.02950E+04, 3.5240470399E+01, 5.4160428279E+00, 1.8044948035E+01, 3.7253620260E+00, 9.7008340559E-01],
	[4.03000E+04, 3.5248114161E+01, 5.4160793670E+00, 1.8052315305E+01, 3.7257786354E+00, 9.7009780548E-01],
	[4.03050E+04, 3.5255758632E+01, 5.4161159019E+00, 1.8059684668E+01, 3.7261951395E+00, 9.7011219793E-01],
	[4.03100E+04, 3.5263403812E+01, 5.4161524324E+00, 1.8067056125E+01, 3.7266115383E+00, 9.7012658293E-01],
	[4.03150E+04, 3.5271049702E+01, 5.4161889587E+00, 1.8074429676E+01, 3.7270278319E+00, 9.7014096051E-01],
	[4.03200E+04, 3.5278696301E+01, 5.4162254807E+00, 1.8081805322E+01, 3.7274440203E+00, 9.7015533065E-01],
	[4.03250E+04, 3.5286343609E+01, 5.4162619984E+00, 1.8089183062E+01, 3.7278601035E+00, 9.7016969337E-01],
	[4.03300E+04, 3.5293991626E+01, 5.4162985118E+00, 1.8096562897E+01, 3.7282760815E+00, 9.7018404867E-01],
	[4.03350E+04, 3.5301640353E+01, 5.4163350210E+00, 1.8103944827E+01, 3.7286919544E+00, 9.7019839655E-01],
	[4.03400E+04, 3.5309289789E+01, 5.4163715258E+00, 1.8111328853E+01, 3.7291077222E+00, 9.7021273702E-01],
	[4.03450E+04, 3.5316939934E+01, 5.4164080264E+00, 1.8118714975E+01, 3.7295233848E+00, 9.7022707007E-01],
	[4.03500E+04, 3.5324590788E+01, 5.4164445227E+00, 1.8126103193E+01, 3.7299389423E+00, 9.7024139572E-01],
	[4.03550E+04, 3.5332242351E+01, 5.4164810148E+00, 1.8133493508E+01, 3.7303543948E+00, 9.7025571396E-01],
	[4.03600E+04, 3.5339894623E+01, 5.4165175025E+00, 1.8140885920E+01, 3.7307697423E+00, 9.7027002480E-01],
	[4.03650E+04, 3.5347547605E+01, 5.4165539860E+00, 1.8148280429E+01, 3.7311849847E+00, 9.7028432825E-01],
	[4.03700E+04, 3.5355201295E+01, 5.4165904652E+00, 1.8155677036E+01, 3.7316001221E+00, 9.7029862430E-01],
	[4.03750E+04, 3.5362855695E+01, 5.4166269402E+00, 1.8163075741E+01, 3.7320151546E+00, 9.7031291297E-01],
	[4.03800E+04, 3.5370510803E+01, 5.4166634109E+00, 1.8170476544E+01, 3.7324300821E+00, 9.7032719425E-01],
	[4.03850E+04, 3.5378166621E+01, 5.4166998773E+00, 1.8177879446E+01, 3.7328449047E+00, 9.7034146815E-01],
	[4.03900E+04, 3.5385823147E+01, 5.4167363394E+00, 1.8185284447E+01, 3.7332596224E+00, 9.7035573467E-01],
	[4.03950E+04, 3.5393480383E+01, 5.4167727972E+00, 1.8192691547E+01, 3.7336742351E+00, 9.7036999382E-01],
	[4.04000E+04, 3.5401138327E+01, 5.4168092508E+00, 1.8200100747E+01, 3.7340887431E+00, 9.7038424559E-01],
	[4.04050E+04, 3.5408796980E+01, 5.4168457002E+00, 1.8207512046E+01, 3.7345031461E+00, 9.7039849000E-01],
	[4.04100E+04, 3.5416456342E+01, 5.4168821452E+00, 1.8214925447E+01, 3.7349174444E+00, 9.7041272705E-01],
	[4.04150E+04, 3.5424116413E+01, 5.4169185860E+00, 1.8222340947E+01, 3.7353316378E+00, 9.7042695674E-01],
	[4.04200E+04, 3.5431777193E+01, 5.4169550226E+00, 1.8229758549E+01, 3.7357457265E+00, 9.7044117908E-01],
	[4.04250E+04, 3.5439438682E+01, 5.4169914549E+00, 1.8237178252E+01, 3.7361597104E+00, 9.7045539406E-01],
	[4.04300E+04, 3.5447100879E+01, 5.4170278829E+00, 1.8244600057E+01, 3.7365735896E+00, 9.7046960169E-01],
	[4.04350E+04, 3.5454763786E+01, 5.4170643066E+00, 1.8252023964E+01, 3.7369873641E+00, 9.7048380198E-01],
	[4.04400E+04, 3.5462427401E+01, 5.4171007261E+00, 1.8259449974E+01, 3.7374010339E+00, 9.7049799493E-01],
	[4.04450E+04, 3.5470091724E+01, 5.4171371414E+00, 1.8266878086E+01, 3.7378145990E+00, 9.7051218055E-01],
	[4.04500E+04, 3.5477756757E+01, 5.4171735523E+00, 1.8274308300E+01, 3.7382280595E+00, 9.7052635883E-01],
	[4.04550E+04, 3.5485422498E+01, 5.4172099591E+00, 1.8281740619E+01, 3.7386414153E+00, 9.7054052978E-01],
	[4.04600E+04, 3.5493088948E+01, 5.4172463615E+00, 1.8289175041E+01, 3.7390546666E+00, 9.7055469340E-01],
	[4.04650E+04, 3.5500756106E+01, 5.4172827598E+00, 1.8296611567E+01, 3.7394678132E+00, 9.7056884971E-01],
	[4.04700E+04, 3.5508423973E+01, 5.4173191537E+00, 1.8304050197E+01, 3.7398808554E+00, 9.7058299869E-01],
	[4.04750E+04, 3.5516092549E+01, 5.4173555434E+00, 1.8311490932E+01, 3.7402937929E+00, 9.7059714036E-01],
	[4.04800E+04, 3.5523761833E+01, 5.4173919289E+00, 1.8318933773E+01, 3.7407066260E+00, 9.7061127472E-01],
	[4.04850E+04, 3.5531431825E+01, 5.4174283101E+00, 1.8326378718E+01, 3.7411193546E+00, 9.7062540177E-01],
	[4.04900E+04, 3.5539102527E+01, 5.4174646871E+00, 1.8333825769E+01, 3.7415319787E+00, 9.7063952152E-01],
	[4.04950E+04, 3.5546773937E+01, 5.4175010598E+00, 1.8341274927E+01, 3.7419444983E+00, 9.7065363397E-01],
	[4.05000E+04, 3.5554446055E+01, 5.4175374283E+00, 1.8348726190E+01, 3.7423569136E+00, 9.7066773913E-01],
	[4.05050E+04, 3.5562118881E+01, 5.4175737925E+00, 1.8356179561E+01, 3.7427692244E+00, 9.7068183699E-01],
	[4.05100E+04, 3.5569792417E+01, 5.4176101525E+00, 1.8363635038E+01, 3.7431814309E+00, 9.7069592756E-01],
	[4.05150E+04, 3.5577466660E+01, 5.4176465082E+00, 1.8371092623E+01, 3.7435935330E+00, 9.7071001085E-01],
	[4.05200E+04, 3.5585141612E+01, 5.4176828597E+00, 1.8378552315E+01, 3.7440055307E+00, 9.7072408686E-01],
	[4.05250E+04, 3.5592817272E+01, 5.4177192070E+00, 1.8386014116E+01, 3.7444174242E+00, 9.7073815559E-01],
	[4.05300E+04, 3.5600493641E+01, 5.4177555500E+00, 1.8393478025E+01, 3.7448292133E+00, 9.7075221704E-01],
	[4.05350E+04, 3.5608170718E+01, 5.4177918887E+00, 1.8400944042E+01, 3.7452408982E+00, 9.7076627123E-01],
	[4.05400E+04, 3.5615848504E+01, 5.4178282233E+00, 1.8408412169E+01, 3.7456524788E+00, 9.7078031815E-01],
	[4.05450E+04, 3.5623526997E+01, 5.4178645536E+00, 1.8415882405E+01, 3.7460639552E+00, 9.7079435781E-01],
	[4.05500E+04, 3.5631206199E+01, 5.4179008796E+00, 1.8423354751E+01, 3.7464753274E+00, 9.7080839021E-01],
	[4.05550E+04, 3.5638886109E+01, 5.4179372015E+00, 1.8430829207E+01, 3.7468865955E+00, 9.7082241535E-01],
	[4.05600E+04, 3.5646566728E+01, 5.4179735191E+00, 1.8438305773E+01, 3.7472977593E+00, 9.7083643325E-01],
	[4.05650E+04, 3.5654248054E+01, 5.4180098324E+00, 1.8445784450E+01, 3.7477088191E+00, 9.7085044389E-01],
	[4.05700E+04, 3.5661930089E+01, 5.4180461415E+00, 1.8453265239E+01, 3.7481197747E+00, 9.7086444729E-01],
	[4.05750E+04, 3.5669612832E+01, 5.4180824464E+00, 1.8460748138E+01, 3.7485306262E+00, 9.7087844345E-01],
	[4.05800E+04, 3.5677296283E+01, 5.4181187471E+00, 1.8468233149E+01, 3.7489413736E+00, 9.7089243238E-01],
	[4.05850E+04, 3.5684980442E+01, 5.4181550435E+00, 1.8475720273E+01, 3.7493520170E+00, 9.7090641407E-01],
	[4.05900E+04, 3.5692665309E+01, 5.4181913357E+00, 1.8483209509E+01, 3.7497625564E+00, 9.7092038853E-01],
	[4.05950E+04, 3.5700350884E+01, 5.4182276237E+00, 1.8490700857E+01, 3.7501729918E+00, 9.7093435577E-01],
	[4.06000E+04, 3.5708037168E+01, 5.4182639075E+00, 1.8498194319E+01, 3.7505833232E+00, 9.7094831579E-01],
	[4.06050E+04, 3.5715724159E+01, 5.4183001870E+00, 1.8505689894E+01, 3.7509935506E+00, 9.7096226858E-01],
	[4.06100E+04, 3.5723411858E+01, 5.4183364623E+00, 1.8513187583E+01, 3.7514036741E+00, 9.7097621417E-01],
	[4.06150E+04, 3.5731100266E+01, 5.4183727334E+00, 1.8520687386E+01, 3.7518136936E+00, 9.7099015254E-01],
	[4.06200E+04, 3.5738789381E+01, 5.4184090002E+00, 1.8528189303E+01, 3.7522236093E+00, 9.7100408371E-01],
	[4.06250E+04, 3.5746479204E+01, 5.4184452629E+00, 1.8535693335E+01, 3.7526334211E+00, 9.7101800767E-01],
	[4.06300E+04, 3.5754169735E+01, 5.4184815213E+00, 1.8543199482E+01, 3.7530431291E+00, 9.7103192443E-01],
	[4.06350E+04, 3.5761860974E+01, 5.4185177755E+00, 1.8550707745E+01, 3.7534527332E+00, 9.7104583400E-01],
	[4.06400E+04, 3.5769552921E+01, 5.4185540255E+00, 1.8558218123E+01, 3.7538622335E+00, 9.7105973638E-01],
	[4.06450E+04, 3.5777245576E+01, 5.4185902712E+00, 1.8565730618E+01, 3.7542716301E+00, 9.7107363156E-01],
	[4.06500E+04, 3.5784938938E+01, 5.4186265128E+00, 1.8573245229E+01, 3.7546809229E+00, 9.7108751957E-01],
	[4.06550E+04, 3.5792633009E+01, 5.4186627501E+00, 1.8580761956E+01, 3.7550901119E+00, 9.7110140039E-01],
	[4.06600E+04, 3.5800327787E+01, 5.4186989832E+00, 1.8588280801E+01, 3.7554991972E+00, 9.7111527403E-01],
	[4.06650E+04, 3.5808023273E+01, 5.4187352121E+00, 1.8595801764E+01, 3.7559081789E+00, 9.7112914051E-01],
	[4.06700E+04, 3.5815719466E+01, 5.4187714368E+00, 1.8603324844E+01, 3.7563170568E+00, 9.7114299981E-01],
	[4.06750E+04, 3.5823416368E+01, 5.4188076573E+00, 1.8610850042E+01, 3.7567258311E+00, 9.7115685194E-01],
	[4.06800E+04, 3.5831113977E+01, 5.4188438736E+00, 1.8618377359E+01, 3.7571345018E+00, 9.7117069692E-01],
	[4.06850E+04, 3.5838812293E+01, 5.4188800856E+00, 1.8625906794E+01, 3.7575430689E+00, 9.7118453473E-01],
	[4.06900E+04, 3.5846511318E+01, 5.4189162935E+00, 1.8633438349E+01, 3.7579515324E+00, 9.7119836539E-01],
	[4.06950E+04, 3.5854211050E+01, 5.4189524971E+00, 1.8640972023E+01, 3.7583598923E+00, 9.7121218890E-01],
	[4.07000E+04, 3.5861911489E+01, 5.4189886966E+00, 1.8648507817E+01, 3.7587681487E+00, 9.7122600526E-01],
	[4.07050E+04, 3.5869612636E+01, 5.4190248918E+00, 1.8656045731E+01, 3.7591763016E+00, 9.7123981448E-01],
	[4.07100E+04, 3.5877314491E+01, 5.4190610828E+00, 1.8663585765E+01, 3.7595843510E+00, 9.7125361656E-01],
	[4.07150E+04, 3.5885017053E+01, 5.4190972697E+00, 1.8671127921E+01, 3.7599922969E+00, 9.7126741150E-01],
	[4.07200E+04, 3.5892720323E+01, 5.4191334523E+00, 1.8678672197E+01, 3.7604001394E+00, 9.7128119931E-01],
	[4.07250E+04, 3.5900424301E+01, 5.4191696307E+00, 1.8686218595E+01, 3.7608078784E+00, 9.7129497999E-01],
	[4.07300E+04, 3.5908128985E+01, 5.4192058049E+00, 1.8693767115E+01, 3.7612155141E+00, 9.7130875354E-01],
	[4.07350E+04, 3.5915834378E+01, 5.4192419750E+00, 1.8701317757E+01, 3.7616230463E+00, 9.7132251998E-01],
	[4.07400E+04, 3.5923540477E+01, 5.4192781408E+00, 1.8708870521E+01, 3.7620304752E+00, 9.7133627929E-01],
	[4.07450E+04, 3.5931247284E+01, 5.4193143024E+00, 1.8716425408E+01, 3.7624378008E+00, 9.7135003149E-01],
	[4.07500E+04, 3.5938954799E+01, 5.4193504599E+00, 1.8723982419E+01, 3.7628450230E+00, 9.7136377658E-01],
	[4.07550E+04, 3.5946663020E+01, 5.4193866131E+00, 1.8731541553E+01, 3.7632521420E+00, 9.7137751457E-01],
	[4.07600E+04, 3.5954371950E+01, 5.4194227621E+00, 1.8739102811E+01, 3.7636591576E+00, 9.7139124545E-01],
	[4.07650E+04, 3.5962081586E+01, 5.4194589070E+00, 1.8746666192E+01, 3.7640660701E+00, 9.7140496923E-01],
	[4.07700E+04, 3.5969791930E+01, 5.4194950477E+00, 1.8754231699E+01, 3.7644728792E+00, 9.7141868592E-01],
	[4.07750E+04, 3.5977502981E+01, 5.4195311841E+00, 1.8761799330E+01, 3.7648795852E+00, 9.7143239551E-01],
	[4.07800E+04, 3.5985214739E+01, 5.4195673164E+00, 1.8769369087E+01, 3.7652861881E+00, 9.7144609802E-01],
	[4.07850E+04, 3.5992927205E+01, 5.4196034445E+00, 1.8776940969E+01, 3.7656926877E+00, 9.7145979344E-01],
	[4.07900E+04, 3.6000640377E+01, 5.4196395684E+00, 1.8784514976E+01, 3.7660990842E+00, 9.7147348178E-01],
	[4.07950E+04, 3.6008354257E+01, 5.4196756881E+00, 1.8792091110E+01, 3.7665053776E+00, 9.7148716304E-01],
	[4.08000E+04, 3.6016068844E+01, 5.4197118036E+00, 1.8799669371E+01, 3.7669115679E+00, 9.7150083723E-01],
	[4.08050E+04, 3.6023784139E+01, 5.4197479150E+00, 1.8807249758E+01, 3.7673176552E+00, 9.7151450435E-01],
	[4.08100E+04, 3.6031500140E+01, 5.4197840221E+00, 1.8814832273E+01, 3.7677236394E+00, 9.7152816441E-01],
	[4.08150E+04, 3.6039216849E+01, 5.4198201251E+00, 1.8822416915E+01, 3.7681295205E+00, 9.7154181740E-01],
	[4.08200E+04, 3.6046934264E+01, 5.4198562239E+00, 1.8830003685E+01, 3.7685352987E+00, 9.7155546333E-01],
	[4.08250E+04, 3.6054652387E+01, 5.4198923185E+00, 1.8837592583E+01, 3.7689409739E+00, 9.7156910221E-01],
	[4.08300E+04, 3.6062371216E+01, 5.4199284090E+00, 1.8845183610E+01, 3.7693465461E+00, 9.7158273404E-01],
	[4.08350E+04, 3.6070090753E+01, 5.4199644952E+00, 1.8852776766E+01, 3.7697520154E+00, 9.7159635882E-01],
	[4.08400E+04, 3.6077810997E+01, 5.4200005773E+00, 1.8860372050E+01, 3.7701573817E+00, 9.7160997655E-01],
	[4.08450E+04, 3.6085531947E+01, 5.4200366552E+00, 1.8867969465E+01, 3.7705626452E+00, 9.7162358725E-01],
	[4.08500E+04, 3.6093253605E+01, 5.4200727289E+00, 1.8875569009E+01, 3.7709678058E+00, 9.7163719091E-01],
	[4.08550E+04, 3.6100975969E+01, 5.4201087985E+00, 1.8883170684E+01, 3.7713728636E+00, 9.7165078754E-01],
	[4.08600E+04, 3.6108699041E+01, 5.4201448638E+00, 1.8890774489E+01, 3.7717778185E+00, 9.7166437713E-01],
	[4.08650E+04, 3.6116422819E+01, 5.4201809250E+00, 1.8898380425E+01, 3.7721826706E+00, 9.7167795971E-01],
	[4.08700E+04, 3.6124147304E+01, 5.4202169821E+00, 1.8905988492E+01, 3.7725874200E+00, 9.7169153526E-01],
	[4.08750E+04, 3.6131872496E+01, 5.4202530349E+00, 1.8913598691E+01, 3.7729920666E+00, 9.7170510379E-01],
	[4.08800E+04, 3.6139598395E+01, 5.4202890836E+00, 1.8921211021E+01, 3.7733966105E+00, 9.7171866531E-01],
	[4.08850E+04, 3.6147325001E+01, 5.4203251281E+00, 1.8928825484E+01, 3.7738010516E+00, 9.7173221982E-01],
	[4.08900E+04, 3.6155052313E+01, 5.4203611685E+00, 1.8936442080E+01, 3.7742053901E+00, 9.7174576732E-01],
	[4.08950E+04, 3.6162780332E+01, 5.4203972047E+00, 1.8944060808E+01, 3.7746096259E+00, 9.7175930782E-01],
	[4.09000E+04, 3.6170509058E+01, 5.4204332367E+00, 1.8951681670E+01, 3.7750137590E+00, 9.7177284131E-01],
	[4.09050E+04, 3.6178238491E+01, 5.4204692645E+00, 1.8959304665E+01, 3.7754177895E+00, 9.7178636782E-01],
	[4.09100E+04, 3.6185968630E+01, 5.4205052882E+00, 1.8966929794E+01, 3.7758217174E+00, 9.7179988733E-01],
	[4.09150E+04, 3.6193699476E+01, 5.4205413078E+00, 1.8974557057E+01, 3.7762255428E+00, 9.7181339985E-01],
	[4.09200E+04, 3.6201431028E+01, 5.4205773231E+00, 1.8982186455E+01, 3.7766292656E+00, 9.7182690539E-01],
	[4.09250E+04, 3.6209163288E+01, 5.4206133343E+00, 1.8989817988E+01, 3.7770328858E+00, 9.7184040394E-01],
	[4.09300E+04, 3.6216896253E+01, 5.4206493414E+00, 1.8997451657E+01, 3.7774364036E+00, 9.7185389552E-01],
	[4.09350E+04, 3.6224629926E+01, 5.4206853443E+00, 1.9005087460E+01, 3.7778398188E+00, 9.7186738013E-01],
	[4.09400E+04, 3.6232364305E+01, 5.4207213430E+00, 1.9012725400E+01, 3.7782431316E+00, 9.7188085777E-01],
	[4.09450E+04, 3.6240099390E+01, 5.4207573375E+00, 1.9020365476E+01, 3.7786463419E+00, 9.7189432844E-01],
	[4.09500E+04, 3.6247835182E+01, 5.4207933280E+00, 1.9028007689E+01, 3.7790494499E+00, 9.7190779214E-01],
	[4.09550E+04, 3.6255571681E+01, 5.4208293142E+00, 1.9035652038E+01, 3.7794524554E+00, 9.7192124889E-01],
	[4.09600E+04, 3.6263308886E+01, 5.4208652963E+00, 1.9043298525E+01, 3.7798553585E+00, 9.7193469868E-01],
	[4.09650E+04, 3.6271046797E+01, 5.4209012743E+00, 1.9050947150E+01, 3.7802581593E+00, 9.7194814152E-01],
	[4.09700E+04, 3.6278785415E+01, 5.4209372481E+00, 1.9058597912E+01, 3.7806608578E+00, 9.7196157742E-01],
	[4.09750E+04, 3.6286524739E+01, 5.4209732177E+00, 1.9066250813E+01, 3.7810634539E+00, 9.7197500637E-01],
	[4.09800E+04, 3.6294264770E+01, 5.4210091832E+00, 1.9073905853E+01, 3.7814659478E+00, 9.7198842838E-01],
	[4.09850E+04, 3.6302005507E+01, 5.4210451445E+00, 1.9081563031E+01, 3.7818683394E+00, 9.7200184345E-01],
	[4.09900E+04, 3.6309746950E+01, 5.4210811017E+00, 1.9089222349E+01, 3.7822706287E+00, 9.7201525159E-01],
	[4.09950E+04, 3.6317489100E+01, 5.4211170548E+00, 1.9096883806E+01, 3.7826728159E+00, 9.7202865280E-01],
	[4.10000E+04, 3.6325231956E+01, 5.4211530037E+00, 1.9104547403E+01, 3.7830749008E+00, 9.7204204708E-01],
	[4.10050E+04, 3.6332975518E+01, 5.4211889484E+00, 1.9112213141E+01, 3.7834768836E+00, 9.7205543444E-01],
	[4.10100E+04, 3.6340719786E+01, 5.4212248891E+00, 1.9119881019E+01, 3.7838787642E+00, 9.7206881489E-01],
	[4.10150E+04, 3.6348464761E+01, 5.4212608255E+00, 1.9127551039E+01, 3.7842805427E+00, 9.7208218841E-01],
	[4.10200E+04, 3.6356210442E+01, 5.4212967579E+00, 1.9135223199E+01, 3.7846822191E+00, 9.7209555503E-01],
	[4.10250E+04, 3.6363956829E+01, 5.4213326860E+00, 1.9142897501E+01, 3.7850837933E+00, 9.7210891474E-01],
	[4.10300E+04, 3.6371703922E+01, 5.4213686101E+00, 1.9150573946E+01, 3.7854852656E+00, 9.7212226755E-01],
	[4.10350E+04, 3.6379451722E+01, 5.4214045300E+00, 1.9158252532E+01, 3.7858866358E+00, 9.7213561346E-01],
	[4.10400E+04, 3.6387200227E+01, 5.4214404458E+00, 1.9165933262E+01, 3.7862879039E+00, 9.7214895247E-01],
	[4.10450E+04, 3.6394949439E+01, 5.4214763574E+00, 1.9173616134E+01, 3.7866890701E+00, 9.7216228459E-01],
	[4.10500E+04, 3.6402699356E+01, 5.4215122649E+00, 1.9181301150E+01, 3.7870901343E+00, 9.7217560982E-01],
	[4.10550E+04, 3.6410449980E+01, 5.4215481682E+00, 1.9188988309E+01, 3.7874910966E+00, 9.7218892816E-01],
	[4.10600E+04, 3.6418201310E+01, 5.4215840675E+00, 1.9196677612E+01, 3.7878919569E+00, 9.7220223962E-01],
	[4.10650E+04, 3.6425953346E+01, 5.4216199625E+00, 1.9204369060E+01, 3.7882927153E+00, 9.7221554421E-01],
	[4.10700E+04, 3.6433706088E+01, 5.4216558535E+00, 1.9212062652E+01, 3.7886933719E+00, 9.7222884192E-01],
	[4.10750E+04, 3.6441459535E+01, 5.4216917403E+00, 1.9219758390E+01, 3.7890939265E+00, 9.7224213276E-01],
	[4.10800E+04, 3.6449213689E+01, 5.4217276230E+00, 1.9227456273E+01, 3.7894943794E+00, 9.7225541673E-01],
	[4.10850E+04, 3.6456968549E+01, 5.4217635016E+00, 1.9235156301E+01, 3.7898947304E+00, 9.7226869384E-01],
	[4.10900E+04, 3.6464724114E+01, 5.4217993760E+00, 1.9242858476E+01, 3.7902949796E+00, 9.7228196409E-01],
	[4.10950E+04, 3.6472480386E+01, 5.4218352463E+00, 1.9250562797E+01, 3.7906951271E+00, 9.7229522748E-01],
	[4.11000E+04, 3.6480237363E+01, 5.4218711125E+00, 1.9258269264E+01, 3.7910951728E+00, 9.7230848402E-01],
	[4.11050E+04, 3.6487995046E+01, 5.4219069746E+00, 1.9265977879E+01, 3.7914951168E+00, 9.7232173372E-01],
	[4.11100E+04, 3.6495753435E+01, 5.4219428325E+00, 1.9273688641E+01, 3.7918949591E+00, 9.7233497657E-01],
	[4.11150E+04, 3.6503512530E+01, 5.4219786863E+00, 1.9281401551E+01, 3.7922946997E+00, 9.7234821257E-01],
	[4.11200E+04, 3.6511272330E+01, 5.4220145360E+00, 1.9289116609E+01, 3.7926943387E+00, 9.7236144174E-01],
	[4.11250E+04, 3.6519032837E+01, 5.4220503816E+00, 1.9296833815E+01, 3.7930938760E+00, 9.7237466408E-01],
	[4.11300E+04, 3.6526794049E+01, 5.4220862230E+00, 1.9304553170E+01, 3.7934933117E+00, 9.7238787959E-01],
	[4.11350E+04, 3.6534555966E+01, 5.4221220603E+00, 1.9312274674E+01, 3.7938926458E+00, 9.7240108827E-01],
	[4.11400E+04, 3.6542318590E+01, 5.4221578935E+00, 1.9319998328E+01, 3.7942918784E+00, 9.7241429012E-01],
	[4.11450E+04, 3.6550081919E+01, 5.4221937226E+00, 1.9327724131E+01, 3.7946910094E+00, 9.7242748516E-01],
	[4.11500E+04, 3.6557845954E+01, 5.4222295476E+00, 1.9335452084E+01, 3.7950900389E+00, 9.7244067338E-01],
	[4.11550E+04, 3.6565610694E+01, 5.4222653684E+00, 1.9343182188E+01, 3.7954889668E+00, 9.7245385479E-01],
	[4.11600E+04, 3.6573376140E+01, 5.4223011852E+00, 1.9350914443E+01, 3.7958877934E+00, 9.7246702939E-01],
	[4.11650E+04, 3.6581142292E+01, 5.4223369978E+00, 1.9358648848E+01, 3.7962865184E+00, 9.7248019719E-01],
	[4.11700E+04, 3.6588909149E+01, 5.4223728063E+00, 1.9366385405E+01, 3.7966851420E+00, 9.7249335819E-01],
	[4.11750E+04, 3.6596676711E+01, 5.4224086107E+00, 1.9374124114E+01, 3.7970836642E+00, 9.7250651239E-01],
	[4.11800E+04, 3.6604444980E+01, 5.4224444110E+00, 1.9381864975E+01, 3.7974820851E+00, 9.7251965979E-01],
	[4.11850E+04, 3.6612213953E+01, 5.4224802071E+00, 1.9389607989E+01, 3.7978804045E+00, 9.7253280041E-01],
	[4.11900E+04, 3.6619983632E+01, 5.4225159992E+00, 1.9397353155E+01, 3.7982786227E+00, 9.7254593424E-01],
	[4.11950E+04, 3.6627754017E+01, 5.4225517872E+00, 1.9405100474E+01, 3.7986767395E+00, 9.7255906129E-01],
	[4.12000E+04, 3.6635525107E+01, 5.4225875710E+00, 1.9412849947E+01, 3.7990747550E+00, 9.7257218156E-01],
	[4.12050E+04, 3.6643296902E+01, 5.4226233508E+00, 1.9420601573E+01, 3.7994726692E+00, 9.7258529505E-01],
	[4.12100E+04, 3.6651069403E+01, 5.4226591264E+00, 1.9428355354E+01, 3.7998704822E+00, 9.7259840177E-01],
	[4.12150E+04, 3.6658842609E+01, 5.4226948979E+00, 1.9436111289E+01, 3.8002681939E+00, 9.7261150172E-01],
	[4.12200E+04, 3.6666616521E+01, 5.4227306654E+00, 1.9443869379E+01, 3.8006658045E+00, 9.7262459491E-01],
	[4.12250E+04, 3.6674391138E+01, 5.4227664287E+00, 1.9451629624E+01, 3.8010633139E+00, 9.7263768134E-01],
	[4.12300E+04, 3.6682166460E+01, 5.4228021879E+00, 1.9459392025E+01, 3.8014607221E+00, 9.7265076101E-01],
	[4.12350E+04, 3.6689942487E+01, 5.4228379430E+00, 1.9467156581E+01, 3.8018580291E+00, 9.7266383393E-01],
	[4.12400E+04, 3.6697719220E+01, 5.4228736941E+00, 1.9474923294E+01, 3.8022552351E+00, 9.7267690010E-01],
	[4.12450E+04, 3.6705496658E+01, 5.4229094410E+00, 1.9482692163E+01, 3.8026523399E+00, 9.7268995952E-01],
	[4.12500E+04, 3.6713274801E+01, 5.4229451838E+00, 1.9490463188E+01, 3.8030493437E+00, 9.7270301221E-01],
	[4.12550E+04, 3.6721053649E+01, 5.4229809226E+00, 1.9498236372E+01, 3.8034462465E+00, 9.7271605815E-01],
	[4.12600E+04, 3.6728833203E+01, 5.4230166572E+00, 1.9506011712E+01, 3.8038430482E+00, 9.7272909735E-01],
	[4.12650E+04, 3.6736613462E+01, 5.4230523877E+00, 1.9513789210E+01, 3.8042397489E+00, 9.7274212983E-01],
	[4.12700E+04, 3.6744394425E+01, 5.4230881142E+00, 1.9521568867E+01, 3.8046363486E+00, 9.7275515558E-01],
	[4.12750E+04, 3.6752176094E+01, 5.4231238366E+00, 1.9529350682E+01, 3.8050328474E+00, 9.7276817460E-01],
	[4.12800E+04, 3.6759958468E+01, 5.4231595548E+00, 1.9537134656E+01, 3.8054292452E+00, 9.7278118690E-01],
	[4.12850E+04, 3.6767741547E+01, 5.4231952690E+00, 1.9544920789E+01, 3.8058255422E+00, 9.7279419249E-01],
	[4.12900E+04, 3.6775525331E+01, 5.4232309791E+00, 1.9552709082E+01, 3.8062217382E+00, 9.7280719136E-01],
	[4.12950E+04, 3.6783309820E+01, 5.4232666851E+00, 1.9560499534E+01, 3.8066178334E+00, 9.7282018353E-01],
	[4.13000E+04, 3.6791095015E+01, 5.4233023870E+00, 1.9568292147E+01, 3.8070138277E+00, 9.7283316898E-01],
	[4.13050E+04, 3.6798880914E+01, 5.4233380848E+00, 1.9576086920E+01, 3.8074097212E+00, 9.7284614774E-01],
	[4.13100E+04, 3.6806667518E+01, 5.4233737785E+00, 1.9583883854E+01, 3.8078055139E+00, 9.7285911980E-01],
	[4.13150E+04, 3.6814454827E+01, 5.4234094682E+00, 1.9591682949E+01, 3.8082012059E+00, 9.7287208516E-01],
	[4.13200E+04, 3.6822242841E+01, 5.4234451537E+00, 1.9599484206E+01, 3.8085967971E+00, 9.7288504383E-01],
	[4.13250E+04, 3.6830031559E+01, 5.4234808352E+00, 1.9607287625E+01, 3.8089922875E+00, 9.7289799581E-01],
	[4.13300E+04, 3.6837820983E+01, 5.4235165126E+00, 1.9615093206E+01, 3.8093876773E+00, 9.7291094111E-01],
	[4.13350E+04, 3.6845611112E+01, 5.4235521859E+00, 1.9622900950E+01, 3.8097829663E+00, 9.7292387973E-01],
	[4.13400E+04, 3.6853401945E+01, 5.4235878552E+00, 1.9630710856E+01, 3.8101781547E+00, 9.7293681167E-01],
	[4.13450E+04, 3.6861193483E+01, 5.4236235203E+00, 1.9638522926E+01, 3.8105732425E+00, 9.7294973694E-01],
	[4.13500E+04, 3.6868985726E+01, 5.4236591814E+00, 1.9646337159E+01, 3.8109682296E+00, 9.7296265554E-01],
	[4.13550E+04, 3.6876778674E+01, 5.4236948384E+00, 1.9654153556E+01, 3.8113631161E+00, 9.7297556747E-01],
	[4.13600E+04, 3.6884572326E+01, 5.4237304914E+00, 1.9661972118E+01, 3.8117579021E+00, 9.7298847274E-01],
	[4.13650E+04, 3.6892366683E+01, 5.4237661402E+00, 1.9669792844E+01, 3.8121525875E+00, 9.7300137136E-01],
	[4.13700E+04, 3.6900161745E+01, 5.4238017850E+00, 1.9677615735E+01, 3.8125471724E+00, 9.7301426331E-01],
	[4.13750E+04, 3.6907957511E+01, 5.4238374257E+00, 1.9685440791E+01, 3.8129416568E+00, 9.7302714862E-01],
	[4.13800E+04, 3.6915753983E+01, 5.4238730623E+00, 1.9693268013E+01, 3.8133360407E+00, 9.7304002728E-01],
	[4.13850E+04, 3.6923551158E+01, 5.4239086949E+00, 1.9701097400E+01, 3.8137303242E+00, 9.7305289929E-01],
	[4.13900E+04, 3.6931349039E+01, 5.4239443234E+00, 1.9708928954E+01, 3.8141245072E+00, 9.7306576467E-01],
	[4.13950E+04, 3.6939147624E+01, 5.4239799478E+00, 1.9716762675E+01, 3.8145185898E+00, 9.7307862340E-01],
	[4.14000E+04, 3.6946946914E+01, 5.4240155681E+00, 1.9724598563E+01, 3.8149125720E+00, 9.7309147551E-01],
	[4.14050E+04, 3.6954746908E+01, 5.4240511844E+00, 1.9732436617E+01, 3.8153064539E+00, 9.7310432098E-01],
	[4.14100E+04, 3.6962547606E+01, 5.4240867966E+00, 1.9740276840E+01, 3.8157002354E+00, 9.7311715983E-01],
	[4.14150E+04, 3.6970349009E+01, 5.4241224048E+00, 1.9748119230E+01, 3.8160939165E+00, 9.7312999206E-01],
	[4.14200E+04, 3.6978151117E+01, 5.4241580089E+00, 1.9755963789E+01, 3.8164874974E+00, 9.7314281767E-01],
	[4.14250E+04, 3.6985953929E+01, 5.4241936089E+00, 1.9763810516E+01, 3.8168809780E+00, 9.7315563666E-01],
	[4.14300E+04, 3.6993757446E+01, 5.4242292048E+00, 1.9771659413E+01, 3.8172743584E+00, 9.7316844904E-01],
	[4.14350E+04, 3.7001561667E+01, 5.4242647967E+00, 1.9779510479E+01, 3.8176676385E+00, 9.7318125481E-01],
	[4.14400E+04, 3.7009366592E+01, 5.4243003846E+00, 1.9787363714E+01, 3.8180608184E+00, 9.7319405398E-01],
	[4.14450E+04, 3.7017172222E+01, 5.4243359683E+00, 1.9795219119E+01, 3.8184538981E+00, 9.7320684655E-01],
	[4.14500E+04, 3.7024978556E+01, 5.4243715480E+00, 1.9803076695E+01, 3.8188468776E+00, 9.7321963252E-01],
	[4.14550E+04, 3.7032785594E+01, 5.4244071237E+00, 1.9810936441E+01, 3.8192397571E+00, 9.7323241190E-01],
	[4.14600E+04, 3.7040593337E+01, 5.4244426953E+00, 1.9818798359E+01, 3.8196325363E+00, 9.7324518469E-01],
	[4.14650E+04, 3.7048401784E+01, 5.4244782628E+00, 1.9826662447E+01, 3.8200252155E+00, 9.7325795089E-01],
	[4.14700E+04, 3.7056210936E+01, 5.4245138263E+00, 1.9834528708E+01, 3.8204177947E+00, 9.7327071051E-01],
	[4.14750E+04, 3.7064020791E+01, 5.4245493858E+00, 1.9842397140E+01, 3.8208102737E+00, 9.7328346355E-01],
	[4.14800E+04, 3.7071831351E+01, 5.4245849411E+00, 1.9850267745E+01, 3.8212026528E+00, 9.7329621002E-01],
	[4.14850E+04, 3.7079642615E+01, 5.4246204925E+00, 1.9858140522E+01, 3.8215949318E+00, 9.7330894991E-01],
	[4.14900E+04, 3.7087454583E+01, 5.4246560397E+00, 1.9866015472E+01, 3.8219871109E+00, 9.7332168324E-01],
	[4.14950E+04, 3.7095267255E+01, 5.4246915830E+00, 1.9873892596E+01, 3.8223791900E+00, 9.7333441000E-01],
	[4.15000E+04, 3.7103080632E+01, 5.4247271221E+00, 1.9881771894E+01, 3.8227711692E+00, 9.7334713020E-01],
	[4.15050E+04, 3.7110894712E+01, 5.4247626573E+00, 1.9889653365E+01, 3.8231630484E+00, 9.7335984385E-01],
	[4.15100E+04, 3.7118709497E+01, 5.4247981883E+00, 1.9897537011E+01, 3.8235548278E+00, 9.7337255094E-01],
	[4.15150E+04, 3.7126524986E+01, 5.4248337154E+00, 1.9905422832E+01, 3.8239465073E+00, 9.7338525148E-01],
	[4.15200E+04, 3.7134341179E+01, 5.4248692384E+00, 1.9913310828E+01, 3.8243380869E+00, 9.7339794547E-01],
	[4.15250E+04, 3.7142158076E+01, 5.4249047573E+00, 1.9921200999E+01, 3.8247295668E+00, 9.7341063293E-01],
	[4.15300E+04, 3.7149975677E+01, 5.4249402722E+00, 1.9929093346E+01, 3.8251209468E+00, 9.7342331384E-01],
	[4.15350E+04, 3.7157793981E+01, 5.4249757830E+00, 1.9936987868E+01, 3.8255122271E+00, 9.7343598821E-01],
	[4.15400E+04, 3.7165612990E+01, 5.4250112899E+00, 1.9944884568E+01, 3.8259034076E+00, 9.7344865606E-01],
	[4.15450E+04, 3.7173432703E+01, 5.4250467926E+00, 1.9952783444E+01, 3.8262944883E+00, 9.7346131737E-01],
	[4.15500E+04, 3.7181253120E+01, 5.4250822914E+00, 1.9960684497E+01, 3.8266854694E+00, 9.7347397217E-01],
	[4.15550E+04, 3.7189074240E+01, 5.4251177860E+00, 1.9968587728E+01, 3.8270763507E+00, 9.7348662044E-01],
	[4.15600E+04, 3.7196896065E+01, 5.4251532767E+00, 1.9976493136E+01, 3.8274671325E+00, 9.7349926219E-01],
	[4.15650E+04, 3.7204718593E+01, 5.4251887633E+00, 1.9984400722E+01, 3.8278578145E+00, 9.7351189743E-01],
	[4.15700E+04, 3.7212541826E+01, 5.4252242459E+00, 1.9992310487E+01, 3.8282483970E+00, 9.7352452616E-01],
	[4.15750E+04, 3.7220365762E+01, 5.4252597244E+00, 2.0000222431E+01, 3.8286388798E+00, 9.7353714838E-01],
	[4.15800E+04, 3.7228190401E+01, 5.4252951989E+00, 2.0008136553E+01, 3.8290292631E+00, 9.7354976410E-01],
	[4.15850E+04, 3.7236015745E+01, 5.4253306694E+00, 2.0016052856E+01, 3.8294195468E+00, 9.7356237332E-01],
	[4.15900E+04, 3.7243841792E+01, 5.4253661358E+00, 2.0023971338E+01, 3.8298097310E+00, 9.7357497604E-01],
	[4.15950E+04, 3.7251668544E+01, 5.4254015983E+00, 2.0031892000E+01, 3.8301998157E+00, 9.7358757227E-01],
	[4.16000E+04, 3.7259495998E+01, 5.4254370566E+00, 2.0039814842E+01, 3.8305898010E+00, 9.7360016201E-01],
	[4.16050E+04, 3.7267324157E+01, 5.4254725110E+00, 2.0047739866E+01, 3.8309796867E+00, 9.7361274527E-01],
	[4.16100E+04, 3.7275153019E+01, 5.4255079613E+00, 2.0055667070E+01, 3.8313694731E+00, 9.7362532205E-01],
	[4.16150E+04, 3.7282982585E+01, 5.4255434076E+00, 2.0063596456E+01, 3.8317591600E+00, 9.7363789234E-01],
	[4.16200E+04, 3.7290812854E+01, 5.4255788499E+00, 2.0071528024E+01, 3.8321487475E+00, 9.7365045617E-01],
	[4.16250E+04, 3.7298643827E+01, 5.4256142881E+00, 2.0079461774E+01, 3.8325382357E+00, 9.7366301352E-01],
	[4.16300E+04, 3.7306475504E+01, 5.4256497223E+00, 2.0087397706E+01, 3.8329276245E+00, 9.7367556440E-01],
	[4.16350E+04, 3.7314307884E+01, 5.4256851525E+00, 2.0095335822E+01, 3.8333169140E+00, 9.7368810882E-01],
	[4.16400E+04, 3.7322140968E+01, 5.4257205787E+00, 2.0103276120E+01, 3.8337061042E+00, 9.7370064678E-01],
	[4.16450E+04, 3.7329974755E+01, 5.4257560008E+00, 2.0111218602E+01, 3.8340951951E+00, 9.7371317829E-01],
	[4.16500E+04, 3.7337809246E+01, 5.4257914189E+00, 2.0119163268E+01, 3.8344841867E+00, 9.7372570334E-01],
	[4.16550E+04, 3.7345644441E+01, 5.4258268330E+00, 2.0127110118E+01, 3.8348730792E+00, 9.7373822194E-01],
	[4.16600E+04, 3.7353480338E+01, 5.4258622431E+00, 2.0135059152E+01, 3.8352618724E+00, 9.7375073410E-01],
	[4.16650E+04, 3.7361316939E+01, 5.4258976492E+00, 2.0143010372E+01, 3.8356505664E+00, 9.7376323981E-01],
	[4.16700E+04, 3.7369154244E+01, 5.4259330512E+00, 2.0150963776E+01, 3.8360391613E+00, 9.7377573909E-01],
	[4.16750E+04, 3.7376992252E+01, 5.4259684493E+00, 2.0158919367E+01, 3.8364276571E+00, 9.7378823193E-01],
	[4.16800E+04, 3.7384830963E+01, 5.4260038433E+00, 2.0166877143E+01, 3.8368160537E+00, 9.7380071834E-01],
	[4.16850E+04, 3.7392670378E+01, 5.4260392333E+00, 2.0174837105E+01, 3.8372043512E+00, 9.7381319832E-01],
	[4.16900E+04, 3.7400510496E+01, 5.4260746192E+00, 2.0182799253E+01, 3.8375925497E+00, 9.7382567188E-01],
	[4.16950E+04, 3.7408351318E+01, 5.4261100012E+00, 2.0190763589E+01, 3.8379806491E+00, 9.7383813901E-01],
	[4.17000E+04, 3.7416192842E+01, 5.4261453792E+00, 2.0198730112E+01, 3.8383686495E+00, 9.7385059973E-01],
	[4.17050E+04, 3.7424035070E+01, 5.4261807531E+00, 2.0206698822E+01, 3.8387565509E+00, 9.7386305404E-01],
	[4.17100E+04, 3.7431878001E+01, 5.4262161231E+00, 2.0214669721E+01, 3.8391443533E+00, 9.7387550193E-01],
	[4.17150E+04, 3.7439721636E+01, 5.4262514890E+00, 2.0222642807E+01, 3.8395320567E+00, 9.7388794342E-01],
	[4.17200E+04, 3.7447565973E+01, 5.4262868509E+00, 2.0230618082E+01, 3.8399196612E+00, 9.7390037851E-01],
	[4.17250E+04, 3.7455411014E+01, 5.4263222088E+00, 2.0238595547E+01, 3.8403071668E+00, 9.7391280720E-01],
	[4.17300E+04, 3.7463256758E+01, 5.4263575627E+00, 2.0246575200E+01, 3.8406945735E+00, 9.7392522949E-01],
	[4.17350E+04, 3.7471103205E+01, 5.4263929126E+00, 2.0254557043E+01, 3.8410818814E+00, 9.7393764539E-01],
	[4.17400E+04, 3.7478950355E+01, 5.4264282585E+00, 2.0262541076E+01, 3.8414690904E+00, 9.7395005490E-01],
	[4.17450E+04, 3.7486806654E+01, 5.4264646611E+00, 2.0270527299E+01, 3.8418568209E+00, 9.7396245802E-01],
	[4.17500E+04, 3.7494697458E+01, 5.4265053031E+00, 2.0278515713E+01, 3.8422469352E+00, 9.7397485477E-01],
	[4.17550E+04, 3.7502588977E+01, 5.4265459406E+00, 2.0286506317E+01, 3.8426369514E+00, 9.7398724513E-01],
	[4.17600E+04, 3.7510481212E+01, 5.4265865735E+00, 2.0294499113E+01, 3.8430268695E+00, 9.7399962912E-01],
	[4.17650E+04, 3.7518374163E+01, 5.4266272019E+00, 2.0302494101E+01, 3.8434166895E+00, 9.7401200675E-01],
	[4.17700E+04, 3.7526267829E+01, 5.4266678257E+00, 2.0310491280E+01, 3.8438064114E+00, 9.7402437800E-01],
	[4.17750E+04, 3.7534162211E+01, 5.4267084449E+00, 2.0318490652E+01, 3.8441960354E+00, 9.7403674289E-01],
	[4.17800E+04, 3.7542057309E+01, 5.4267490596E+00, 2.0326492217E+01, 3.8445855613E+00, 9.7404910142E-01],
	[4.17850E+04, 3.7549953122E+01, 5.4267896697E+00, 2.0334495974E+01, 3.8449749892E+00, 9.7406145359E-01],
	[4.17900E+04, 3.7557849651E+01, 5.4268302753E+00, 2.0342501925E+01, 3.8453643192E+00, 9.7407379941E-01],
	[4.17950E+04, 3.7565746895E+01, 5.4268708763E+00, 2.0350510070E+01, 3.8457535513E+00, 9.7408613888E-01],
	[4.18000E+04, 3.7573644855E+01, 5.4269114728E+00, 2.0358520408E+01, 3.8461426854E+00, 9.7409847201E-01],
	[4.18050E+04, 3.7581543530E+01, 5.4269520647E+00, 2.0366532941E+01, 3.8465317217E+00, 9.7411079879E-01],
	[4.18100E+04, 3.7589442921E+01, 5.4269926520E+00, 2.0374547668E+01, 3.8469206601E+00, 9.7412311923E-01],
	[4.18150E+04, 3.7597343028E+01, 5.4270332348E+00, 2.0382564591E+01, 3.8473095006E+00, 9.7413543334E-01],
	[4.18200E+04, 3.7605243849E+01, 5.4270738131E+00, 2.0390583709E+01, 3.8476982434E+00, 9.7414774112E-01],
	[4.18250E+04, 3.7613145387E+01, 5.4271143868E+00, 2.0398605022E+01, 3.8480868883E+00, 9.7416004257E-01],
	[4.18300E+04, 3.7621047639E+01, 5.4271549560E+00, 2.0406628532E+01, 3.8484754354E+00, 9.7417233769E-01],
	[4.18350E+04, 3.7628950608E+01, 5.4271955206E+00, 2.0414654238E+01, 3.8488638848E+00, 9.7418462649E-01],
	[4.18400E+04, 3.7636854291E+01, 5.4272360807E+00, 2.0422682140E+01, 3.8492522365E+00, 9.7419690898E-01],
	[4.18450E+04, 3.7644758690E+01, 5.4272766362E+00, 2.0430712240E+01, 3.8496404904E+00, 9.7420918515E-01],
	[4.18500E+04, 3.7652663804E+01, 5.4273171872E+00, 2.0438744537E+01, 3.8500286467E+00, 9.7422145501E-01],
	[4.18550E+04, 3.7660569634E+01, 5.4273577336E+00, 2.0446779032E+01, 3.8504167053E+00, 9.7423371856E-01],
	[4.18600E+04, 3.7668476178E+01, 5.4273982755E+00, 2.0454815725E+01, 3.8508046662E+00, 9.7424597581E-01],
	[4.18650E+04, 3.7676383438E+01, 5.4274388129E+00, 2.0462854616E+01, 3.8511925296E+00, 9.7425822676E-01],
	[4.18700E+04, 3.7684291414E+01, 5.4274793457E+00, 2.0470895706E+01, 3.8515802953E+00, 9.7427047142E-01],
	[4.18750E+04, 3.7692200104E+01, 5.4275198740E+00, 2.0478938995E+01, 3.8519679635E+00, 9.7428270978E-01],
	[4.18800E+04, 3.7700109510E+01, 5.4275603978E+00, 2.0486984484E+01, 3.8523555341E+00, 9.7429494185E-01],
	[4.18850E+04, 3.7708019631E+01, 5.4276009170E+00, 2.0495032172E+01, 3.8527430071E+00, 9.7430716764E-01],
	[4.18900E+04, 3.7715930467E+01, 5.4276414317E+00, 2.0503082060E+01, 3.8531303827E+00, 9.7431938714E-01],
	[4.18950E+04, 3.7723842018E+01, 5.4276819418E+00, 2.0511134149E+01, 3.8535176608E+00, 9.7433160037E-01],
	[4.19000E+04, 3.7731754285E+01, 5.4277224475E+00, 2.0519188438E+01, 3.8539048414E+00, 9.7434380732E-01],
	[4.19050E+04, 3.7739667266E+01, 5.4277629485E+00, 2.0527244929E+01, 3.8542919246E+00, 9.7435600800E-01],
	[4.19100E+04, 3.7747580963E+01, 5.4278034451E+00, 2.0535303621E+01, 3.8546789103E+00, 9.7436820241E-01],
	[4.19150E+04, 3.7755495375E+01, 5.4278439371E+00, 2.0543364515E+01, 3.8550657987E+00, 9.7438039055E-01],
	[4.19200E+04, 3.7763410501E+01, 5.4278844246E+00, 2.0551427611E+01, 3.8554525897E+00, 9.7439257244E-01],
	[4.19250E+04, 3.7771326343E+01, 5.4279249076E+00, 2.0559492909E+01, 3.8558392833E+00, 9.7440474807E-01],
	[4.19300E+04, 3.7779242900E+01, 5.4279653861E+00, 2.0567560411E+01, 3.8562258796E+00, 9.7441691744E-01],
	[4.19350E+04, 3.7787160171E+01, 5.4280058600E+00, 2.0575630115E+01, 3.8566123786E+00, 9.7442908056E-01],
	[4.19400E+04, 3.7795078158E+01, 5.4280463294E+00, 2.0583702023E+01, 3.8569987804E+00, 9.7444123744E-01],
	[4.19450E+04, 3.7802996860E+01, 5.4280867943E+00, 2.0591776134E+01, 3.8573850848E+00, 9.7445338807E-01],
	[4.19500E+04, 3.7810916276E+01, 5.4281272546E+00, 2.0599852450E+01, 3.8577712920E+00, 9.7446553246E-01],
	[4.19550E+04, 3.7818836408E+01, 5.4281677104E+00, 2.0607930971E+01, 3.8581574020E+00, 9.7447767062E-01],
	[4.19600E+04, 3.7826757254E+01, 5.4282081618E+00, 2.0616011696E+01, 3.8585434149E+00, 9.7448980254E-01],
	[4.19650E+04, 3.7834678815E+01, 5.4282486086E+00, 2.0624094626E+01, 3.8589293305E+00, 9.7450192824E-01],
	[4.19700E+04, 3.7842601091E+01, 5.4282890508E+00, 2.0632179762E+01, 3.8593151490E+00, 9.7451404771E-01],
	[4.19750E+04, 3.7850524082E+01, 5.4283294886E+00, 2.0640267104E+01, 3.8597008704E+00, 9.7452616095E-01],
	[4.19800E+04, 3.7858447788E+01, 5.4283699219E+00, 2.0648356652E+01, 3.8600864946E+00, 9.7453826798E-01],
	[4.19850E+04, 3.7866372208E+01, 5.4284103506E+00, 2.0656448406E+01, 3.8604720218E+00, 9.7455036879E-01],
	[4.19900E+04, 3.7874297343E+01, 5.4284507748E+00, 2.0664542367E+01, 3.8608574519E+00, 9.7456246339E-01],
	[4.19950E+04, 3.7882223193E+01, 5.4284911945E+00, 2.0672638536E+01, 3.8612427850E+00, 9.7457455179E-01],
	[4.20000E+04, 3.7890149758E+01, 5.4285316097E+00, 2.0680736912E+01, 3.8616280211E+00, 9.7458663397E-01],
	[4.20050E+04, 3.7898077037E+01, 5.4285720204E+00, 2.0688837496E+01, 3.8620131602E+00, 9.7459870996E-01],
	[4.20100E+04, 3.7906005031E+01, 5.4286124266E+00, 2.0696940288E+01, 3.8623982023E+00, 9.7461077975E-01],
	[4.20150E+04, 3.7913933740E+01, 5.4286528282E+00, 2.0705045289E+01, 3.8627831475E+00, 9.7462284334E-01],
	[4.20200E+04, 3.7921863163E+01, 5.4286932254E+00, 2.0713152498E+01, 3.8631679957E+00, 9.7463490074E-01],
	[4.20250E+04, 3.7929793301E+01, 5.4287336181E+00, 2.0721261917E+01, 3.8635527471E+00, 9.7464695196E-01],
	[4.20300E+04, 3.7937724153E+01, 5.4287740062E+00, 2.0729373546E+01, 3.8639374015E+00, 9.7465899699E-01],
	[4.20350E+04, 3.7945655720E+01, 5.4288143899E+00, 2.0737487384E+01, 3.8643219591E+00, 9.7467103584E-01],
	[4.20400E+04, 3.7953588002E+01, 5.4288547690E+00, 2.0745603433E+01, 3.8647064199E+00, 9.7468306852E-01],
	[4.20450E+04, 3.7961520998E+01, 5.4288951436E+00, 2.0753721692E+01, 3.8650907839E+00, 9.7469509502E-01],
	[4.20500E+04, 3.7969454709E+01, 5.4289355138E+00, 2.0761842162E+01, 3.8654750511E+00, 9.7470711535E-01],
	[4.20550E+04, 3.7977389134E+01, 5.4289758794E+00, 2.0769964844E+01, 3.8658592215E+00, 9.7471912951E-01],
	[4.20600E+04, 3.7985324273E+01, 5.4290162406E+00, 2.0778089737E+01, 3.8662432951E+00, 9.7473113751E-01],
	[4.20650E+04, 3.7993260128E+01, 5.4290565972E+00, 2.0786216842E+01, 3.8666272721E+00, 9.7474313934E-01],
	[4.20700E+04, 3.8001196696E+01, 5.4290969494E+00, 2.0794346159E+01, 3.8670111523E+00, 9.7475513502E-01],
	[4.20750E+04, 3.8009133979E+01, 5.4291372970E+00, 2.0802477689E+01, 3.8673949359E+00, 9.7476712454E-01],
	[4.20800E+04, 3.8017071976E+01, 5.4291776402E+00, 2.0810611432E+01, 3.8677786228E+00, 9.7477910791E-01],
	[4.20850E+04, 3.8025010688E+01, 5.4292179788E+00, 2.0818747388E+01, 3.8681622131E+00, 9.7479108513E-01],
	[4.20900E+04, 3.8032950114E+01, 5.4292583130E+00, 2.0826885558E+01, 3.8685457068E+00, 9.7480305620E-01],
	[4.20950E+04, 3.8040890254E+01, 5.4292986427E+00, 2.0835025942E+01, 3.8689291039E+00, 9.7481502112E-01],
	[4.21000E+04, 3.8048831109E+01, 5.4293389679E+00, 2.0843168540E+01, 3.8693124044E+00, 9.7482697991E-01],
	[4.21050E+04, 3.8056772677E+01, 5.4293792886E+00, 2.0851313353E+01, 3.8696956084E+00, 9.7483893256E-01],
	[4.21100E+04, 3.8064714961E+01, 5.4294196048E+00, 2.0859460381E+01, 3.8700787159E+00, 9.7485087908E-01],
	[4.21150E+04, 3.8072657958E+01, 5.4294599165E+00, 2.0867609624E+01, 3.8704617269E+00, 9.7486281946E-01],
	[4.21200E+04, 3.8080601670E+01, 5.4295002238E+00, 2.0875761083E+01, 3.8708446414E+00, 9.7487475372E-01],
	[4.21250E+04, 3.8088546095E+01, 5.4295405265E+00, 2.0883914758E+01, 3.8712274594E+00, 9.7488668185E-01],
	[4.21300E+04, 3.8096491235E+01, 5.4295808248E+00, 2.0892070649E+01, 3.8716101811E+00, 9.7489860385E-01],
	[4.21350E+04, 3.8104437089E+01, 5.4296211186E+00, 2.0900228757E+01, 3.8719928063E+00, 9.7491051974E-01],
	[4.21400E+04, 3.8112383658E+01, 5.4296614079E+00, 2.0908389082E+01, 3.8723753351E+00, 9.7492242952E-01],
	[4.21450E+04, 3.8120330940E+01, 5.4297016927E+00, 2.0916551625E+01, 3.8727577676E+00, 9.7493433317E-01],
	[4.21500E+04, 3.8128278937E+01, 5.4297419730E+00, 2.0924716385E+01, 3.8731401038E+00, 9.7494623072E-01],
	[4.21550E+04, 3.8136227647E+01, 5.4297822489E+00, 2.0932883363E+01, 3.8735223436E+00, 9.7495812217E-01],
	[4.21600E+04, 3.8144177072E+01, 5.4298225203E+00, 2.0941052560E+01, 3.8739044871E+00, 9.7497000751E-01],
	[4.21650E+04, 3.8152127210E+01, 5.4298627872E+00, 2.0949223975E+01, 3.8742865344E+00, 9.7498188674E-01],
	[4.21700E+04, 3.8160078063E+01, 5.4299030496E+00, 2.0957397609E+01, 3.8746684854E+00, 9.7499375988E-01],
	[4.21750E+04, 3.8168029630E+01, 5.4299433076E+00, 2.0965573463E+01, 3.8750503402E+00, 9.7500562693E-01],
	[4.21800E+04, 3.8175981910E+01, 5.4299835611E+00, 2.0973751537E+01, 3.8754320988E+00, 9.7501748788E-01],
	[4.21850E+04, 3.8183934905E+01, 5.4300238101E+00, 2.0981931831E+01, 3.8758137612E+00, 9.7502934275E-01],
	[4.21900E+04, 3.8191888613E+01, 5.4300640546E+00, 2.0990114345E+01, 3.8761953274E+00, 9.7504119153E-01],
	[4.21950E+04, 3.8199843036E+01, 5.4301042947E+00, 2.0998299080E+01, 3.8765767976E+00, 9.7505303422E-01],
	[4.22000E+04, 3.8207798172E+01, 5.4301445303E+00, 2.1006486036E+01, 3.8769581716E+00, 9.7506487084E-01],
	[4.22050E+04, 3.8215754022E+01, 5.4301847614E+00, 2.1014675213E+01, 3.8773394495E+00, 9.7507670138E-01],
	[4.22100E+04, 3.8223710586E+01, 5.4302249880E+00, 2.1022866613E+01, 3.8777206313E+00, 9.7508852585E-01],
	[4.22150E+04, 3.8231667864E+01, 5.4302652102E+00, 2.1031060234E+01, 3.8781017171E+00, 9.7510034425E-01],
	[4.22200E+04, 3.8239625856E+01, 5.4303054280E+00, 2.1039256078E+01, 3.8784827069E+00, 9.7511215658E-01],
	[4.22250E+04, 3.8247584561E+01, 5.4303456412E+00, 2.1047454145E+01, 3.8788636007E+00, 9.7512396284E-01],
	[4.22300E+04, 3.8255543981E+01, 5.4303858500E+00, 2.1055654435E+01, 3.8792443985E+00, 9.7513576305E-01],
	[4.22350E+04, 3.8263504114E+01, 5.4304260544E+00, 2.1063856948E+01, 3.8796251003E+00, 9.7514755720E-01],
	[4.22400E+04, 3.8271464960E+01, 5.4304662542E+00, 2.1072061685E+01, 3.8800057063E+00, 9.7515934529E-01],
	[4.22450E+04, 3.8279426521E+01, 5.4305064496E+00, 2.1080268647E+01, 3.8803862163E+00, 9.7517112733E-01],
	[4.22500E+04, 3.8287388795E+01, 5.4305466406E+00, 2.1088477832E+01, 3.8807666304E+00, 9.7518290332E-01],
	[4.22550E+04, 3.8295351783E+01, 5.4305868271E+00, 2.1096689243E+01, 3.8811469486E+00, 9.7519467326E-01],
	[4.22600E+04, 3.8303315484E+01, 5.4306270091E+00, 2.1104902879E+01, 3.8815271711E+00, 9.7520643717E-01],
	[4.22650E+04, 3.8311279899E+01, 5.4306671867E+00, 2.1113118741E+01, 3.8819072976E+00, 9.7521819503E-01],
	[4.22700E+04, 3.8319245028E+01, 5.4307073598E+00, 2.1121336828E+01, 3.8822873284E+00, 9.7522994686E-01],
	[4.22750E+04, 3.8327210870E+01, 5.4307475285E+00, 2.1129557141E+01, 3.8826672635E+00, 9.7524169265E-01],
	[4.22800E+04, 3.8335177426E+01, 5.4307876927E+00, 2.1137779682E+01, 3.8830471027E+00, 9.7525343241E-01],
	[4.22850E+04, 3.8343144695E+01, 5.4308278525E+00, 2.1146004449E+01, 3.8834268463E+00, 9.7526516614E-01],
	[4.22900E+04, 3.8351112678E+01, 5.4308680078E+00, 2.1154231443E+01, 3.8838064941E+00, 9.7527689385E-01],
	[4.22950E+04, 3.8359081374E+01, 5.4309081587E+00, 2.1162460664E+01, 3.8841860463E+00, 9.7528861554E-01],
	[4.23000E+04, 3.8367050784E+01, 5.4309483051E+00, 2.1170692114E+01, 3.8845655028E+00, 9.7530033121E-01],
	[4.23050E+04, 3.8375020907E+01, 5.4309884470E+00, 2.1178925792E+01, 3.8849448636E+00, 9.7531204087E-01],
	[4.23100E+04, 3.8382991744E+01, 5.4310285846E+00, 2.1187161699E+01, 3.8853241289E+00, 9.7532374451E-01],
	[4.23150E+04, 3.8390963294E+01, 5.4310687176E+00, 2.1195399834E+01, 3.8857032985E+00, 9.7533544214E-01],
	[4.23200E+04, 3.8398935558E+01, 5.4311088463E+00, 2.1203640199E+01, 3.8860823726E+00, 9.7534713377E-01],
	[4.23250E+04, 3.8406908535E+01, 5.4311489704E+00, 2.1211882793E+01, 3.8864613511E+00, 9.7535881939E-01],
	[4.23300E+04, 3.8414882225E+01, 5.4311890902E+00, 2.1220127617E+01, 3.8868402341E+00, 9.7537049902E-01],
	[4.23350E+04, 3.8422856629E+01, 5.4312292055E+00, 2.1228374672E+01, 3.8872190216E+00, 9.7538217264E-01],
	[4.23400E+04, 3.8430831746E+01, 5.4312693163E+00, 2.1236623957E+01, 3.8875977136E+00, 9.7539384028E-01],
	[4.23450E+04, 3.8438807576E+01, 5.4313094227E+00, 2.1244875473E+01, 3.8879763102E+00, 9.7540550192E-01],
	[4.23500E+04, 3.8446784119E+01, 5.4313495247E+00, 2.1253129221E+01, 3.8883548113E+00, 9.7541715757E-01],
	[4.23550E+04, 3.8454761376E+01, 5.4313896222E+00, 2.1261385200E+01, 3.8887332170E+00, 9.7542880724E-01],
	[4.23600E+04, 3.8462739346E+01, 5.4314297153E+00, 2.1269643411E+01, 3.8891115274E+00, 9.7544045093E-01],
	[4.23650E+04, 3.8470718029E+01, 5.4314698040E+00, 2.1277903854E+01, 3.8894897423E+00, 9.7545208864E-01],
	[4.23700E+04, 3.8478697426E+01, 5.4315098882E+00, 2.1286166530E+01, 3.8898678619E+00, 9.7546372037E-01],
	[4.23750E+04, 3.8486677536E+01, 5.4315499680E+00, 2.1294431440E+01, 3.8902458862E+00, 9.7547534613E-01],
	[4.23800E+04, 3.8494658358E+01, 5.4315900434E+00, 2.1302698582E+01, 3.8906238152E+00, 9.7548696592E-01],
	[4.23850E+04, 3.8502639894E+01, 5.4316301143E+00, 2.1310967958E+01, 3.8910016489E+00, 9.7549857975E-01],
	[4.23900E+04, 3.8510622143E+01, 5.4316701808E+00, 2.1319239568E+01, 3.8913793874E+00, 9.7551018761E-01],
	[4.23950E+04, 3.8518605105E+01, 5.4317102429E+00, 2.1327513413E+01, 3.8917570306E+00, 9.7552178951E-01],
	[4.24000E+04, 3.8526588780E+01, 5.4317503005E+00, 2.1335789492E+01, 3.8921345786E+00, 9.7553338546E-01],
	[4.24050E+04, 3.8534573169E+01, 5.4317903537E+00, 2.1344067806E+01, 3.8925120314E+00, 9.7554497545E-01],
	[4.24100E+04, 3.8542558270E+01, 5.4318304025E+00, 2.1352348356E+01, 3.8928893891E+00, 9.7555655948E-01],
	[4.24150E+04, 3.8550544084E+01, 5.4318704469E+00, 2.1360631141E+01, 3.8932666516E+00, 9.7556813758E-01],
	[4.24200E+04, 3.8558530611E+01, 5.4319104868E+00, 2.1368916163E+01, 3.8936438190E+00, 9.7557970972E-01],
	[4.24250E+04, 3.8566517852E+01, 5.4319505223E+00, 2.1377203420E+01, 3.8940208913E+00, 9.7559127592E-01],
	[4.24300E+04, 3.8574505805E+01, 5.4319905534E+00, 2.1385492915E+01, 3.8943978685E+00, 9.7560283619E-01],
	[4.24350E+04, 3.8582494471E+01, 5.4320305800E+00, 2.1393784647E+01, 3.8947747507E+00, 9.7561439052E-01],
	[4.24400E+04, 3.8590483850E+01, 5.4320706023E+00, 2.1402078616E+01, 3.8951515379E+00, 9.7562593891E-01],
	[4.24450E+04, 3.8598473942E+01, 5.4321106201E+00, 2.1410374823E+01, 3.8955282300E+00, 9.7563748138E-01],
	[4.24500E+04, 3.8606464747E+01, 5.4321506335E+00, 2.1418673268E+01, 3.8959048272E+00, 9.7564901792E-01],
	[4.24550E+04, 3.8614456264E+01, 5.4321906425E+00, 2.1426973951E+01, 3.8962813294E+00, 9.7566054853E-01],
	[4.24600E+04, 3.8622448495E+01, 5.4322306471E+00, 2.1435276873E+01, 3.8966577366E+00, 9.7567207323E-01],
	[4.24650E+04, 3.8630441438E+01, 5.4322706472E+00, 2.1443582034E+01, 3.8970340490E+00, 9.7568359200E-01],
	[4.24700E+04, 3.8638435094E+01, 5.4323106429E+00, 2.1451889435E+01, 3.8974102664E+00, 9.7569510486E-01],
	[4.24750E+04, 3.8646429463E+01, 5.4323506343E+00, 2.1460199076E+01, 3.8977863890E+00, 9.7570661182E-01],
	[4.24800E+04, 3.8654424544E+01, 5.4323906212E+00, 2.1468510957E+01, 3.8981624167E+00, 9.7571811286E-01],
	[4.24850E+04, 3.8662420339E+01, 5.4324306037E+00, 2.1476825078E+01, 3.8985383497E+00, 9.7572960799E-01],
	[4.24900E+04, 3.8670416846E+01, 5.4324705817E+00, 2.1485141440E+01, 3.8989141878E+00, 9.7574109723E-01],
	[4.24950E+04, 3.8678414065E+01, 5.4325105554E+00, 2.1493460043E+01, 3.8992899311E+00, 9.7575258056E-01],
	[4.25000E+04, 3.8686411998E+01, 5.4325505247E+00, 2.1501780888E+01, 3.8996655797E+00, 9.7576405800E-01],
	[4.25050E+04, 3.8694410643E+01, 5.4325904895E+00, 2.1510103974E+01, 3.9000411335E+00, 9.7577552955E-01],
	[4.25100E+04, 3.8702410000E+01, 5.4326304500E+00, 2.1518429303E+01, 3.9004165926E+00, 9.7578699520E-01],
	[4.25150E+04, 3.8710410071E+01, 5.4326704060E+00, 2.1526756874E+01, 3.9007919570E+00, 9.7579845497E-01],
	[4.25200E+04, 3.8718410853E+01, 5.4327103577E+00, 2.1535086688E+01, 3.9011672268E+00, 9.7580990886E-01],
	[4.25250E+04, 3.8726412349E+01, 5.4327503049E+00, 2.1543418746E+01, 3.9015424019E+00, 9.7582135686E-01],
	[4.25300E+04, 3.8734414557E+01, 5.4327902478E+00, 2.1551753047E+01, 3.9019174824E+00, 9.7583279898E-01],
	[4.25350E+04, 3.8742417477E+01, 5.4328301862E+00, 2.1560089591E+01, 3.9022924683E+00, 9.7584423523E-01],
	[4.25400E+04, 3.8750421110E+01, 5.4328701202E+00, 2.1568428380E+01, 3.9026673596E+00, 9.7585566561E-01],
	[4.25450E+04, 3.8758425455E+01, 5.4329100498E+00, 2.1576769414E+01, 3.9030421564E+00, 9.7586709012E-01],
	[4.25500E+04, 3.8766430513E+01, 5.4329499751E+00, 2.1585112692E+01, 3.9034168586E+00, 9.7587850876E-01],
	[4.25550E+04, 3.8774436284E+01, 5.4329898959E+00, 2.1593458216E+01, 3.9037914663E+00, 9.7588992154E-01],
	[4.25600E+04, 3.8782442766E+01, 5.4330298123E+00, 2.1601805985E+01, 3.9041659796E+00, 9.7590132847E-01],
	[4.25650E+04, 3.8790449961E+01, 5.4330697244E+00, 2.1610156001E+01, 3.9045403984E+00, 9.7591272953E-01],
	[4.25700E+04, 3.8798457869E+01, 5.4331096320E+00, 2.1618508262E+01, 3.9049147227E+00, 9.7592412474E-01],
	[4.25750E+04, 3.8806466489E+01, 5.4331495353E+00, 2.1626862770E+01, 3.9052889526E+00, 9.7593551410E-01],
	[4.25800E+04, 3.8814475821E+01, 5.4331894341E+00, 2.1635219525E+01, 3.9056630881E+00, 9.7594689761E-01],
	[4.25850E+04, 3.8822485866E+01, 5.4332293286E+00, 2.1643578528E+01, 3.9060371293E+00, 9.7595827528E-01],
	[4.25900E+04, 3.8830496622E+01, 5.4332692187E+00, 2.1651939778E+01, 3.9064110761E+00, 9.7596964711E-01],
	[4.25950E+04, 3.8838508092E+01, 5.4333091044E+00, 2.1660303276E+01, 3.9067849285E+00, 9.7598101309E-01],
	[4.26000E+04, 3.8846520273E+01, 5.4333489857E+00, 2.1668669022E+01, 3.9071586867E+00, 9.7599237325E-01],
	[4.26050E+04, 3.8854533167E+01, 5.4333888626E+00, 2.1677037017E+01, 3.9075323506E+00, 9.7600372757E-01],
	[4.26100E+04, 3.8862546772E+01, 5.4334287351E+00, 2.1685407261E+01, 3.9079059202E+00, 9.7601507606E-01],
	[4.26150E+04, 3.8870561090E+01, 5.4334686032E+00, 2.1693779754E+01, 3.9082793956E+00, 9.7602641872E-01],
	[4.26200E+04, 3.8878576121E+01, 5.4335084670E+00, 2.1702154497E+01, 3.9086527767E+00, 9.7603775556E-01],
	[4.26250E+04, 3.8886591863E+01, 5.4335483264E+00, 2.1710531490E+01, 3.9090260637E+00, 9.7604908658E-01],
	[4.26300E+04, 3.8894608318E+01, 5.4335881813E+00, 2.1718910733E+01, 3.9093992565E+00, 9.7606041179E-01],
	[4.26350E+04, 3.8902625484E+01, 5.4336280319E+00, 2.1727292227E+01, 3.9097723552E+00, 9.7607173118E-01],
	[4.26400E+04, 3.8910643363E+01, 5.4336678782E+00, 2.1735675972E+01, 3.9101453597E+00, 9.7608304476E-01],
	[4.26450E+04, 3.8918661954E+01, 5.4337077200E+00, 2.1744061969E+01, 3.9105182701E+00, 9.7609435253E-01],
	[4.26500E+04, 3.8926681257E+01, 5.4337475575E+00, 2.1752450217E+01, 3.9108910865E+00, 9.7610565449E-01],
	[4.26550E+04, 3.8934701271E+01, 5.4337873906E+00, 2.1760840717E+01, 3.9112638087E+00, 9.7611695066E-01],
	[4.26600E+04, 3.8942721998E+01, 5.4338272193E+00, 2.1769233470E+01, 3.9116364370E+00, 9.7612824102E-01],
	[4.26650E+04, 3.8950743437E+01, 5.4338670436E+00, 2.1777628475E+01, 3.9120089712E+00, 9.7613952559E-01],
	[4.26700E+04, 3.8958765588E+01, 5.4339068636E+00, 2.1786025733E+01, 3.9123814115E+00, 9.7615080437E-01],
	[4.26750E+04, 3.8966788451E+01, 5.4339466791E+00, 2.1794425245E+01, 3.9127537578E+00, 9.7616207736E-01],
	[4.26800E+04, 3.8974812026E+01, 5.4339864903E+00, 2.1802827011E+01, 3.9131260101E+00, 9.7617334456E-01],
	[4.26850E+04, 3.8982836312E+01, 5.4340262972E+00, 2.1811231030E+01, 3.9134981686E+00, 9.7618460597E-01],
	[4.26900E+04, 3.8990861311E+01, 5.4340660997E+00, 2.1819637304E+01, 3.9138702331E+00, 9.7619586161E-01],
	[4.26950E+04, 3.8998887021E+01, 5.4341058977E+00, 2.1828045833E+01, 3.9142422037E+00, 9.7620711146E-01],
	[4.27000E+04, 3.9006913444E+01, 5.4341456915E+00, 2.1836456617E+01, 3.9146140805E+00, 9.7621835555E-01],
	[4.27050E+04, 3.9014940578E+01, 5.4341854808E+00, 2.1844869657E+01, 3.9149858635E+00, 9.7622959386E-01],
	[4.27100E+04, 3.9022968424E+01, 5.4342252658E+00, 2.1853284952E+01, 3.9153575527E+00, 9.7624082640E-01],
	[4.27150E+04, 3.9030996981E+01, 5.4342650465E+00, 2.1861702504E+01, 3.9157291480E+00, 9.7625205318E-01],
	[4.27200E+04, 3.9039026251E+01, 5.4343048227E+00, 2.1870122311E+01, 3.9161006496E+00, 9.7626327420E-01],
	[4.27250E+04, 3.9047056232E+01, 5.4343445946E+00, 2.1878544376E+01, 3.9164720575E+00, 9.7627448945E-01],
	[4.27300E+04, 3.9055086925E+01, 5.4343843621E+00, 2.1886968698E+01, 3.9168433717E+00, 9.7628569895E-01],
	[4.27350E+04, 3.9063118330E+01, 5.4344241253E+00, 2.1895395277E+01, 3.9172145921E+00, 9.7629690270E-01],
	[4.27400E+04, 3.9071150446E+01, 5.4344638841E+00, 2.1903824115E+01, 3.9175857189E+00, 9.7630810069E-01],
	[4.27450E+04, 3.9079183274E+01, 5.4345036386E+00, 2.1912255210E+01, 3.9179567520E+00, 9.7631929294E-01],
	[4.27500E+04, 3.9087216814E+01, 5.4345433887E+00, 2.1920688564E+01, 3.9183276916E+00, 9.7633047944E-01],
	[4.27550E+04, 3.9095251066E+01, 5.4345831344E+00, 2.1929124177E+01, 3.9186985375E+00, 9.7634166021E-01],
	[4.27600E+04, 3.9103286028E+01, 5.4346228758E+00, 2.1937562049E+01, 3.9190692898E+00, 9.7635283523E-01],
	[4.27650E+04, 3.9111321703E+01, 5.4346626128E+00, 2.1946002181E+01, 3.9194399485E+00, 9.7636400452E-01],
	[4.27700E+04, 3.9119358089E+01, 5.4347023455E+00, 2.1954444572E+01, 3.9198105138E+00, 9.7637516808E-01],
	[4.27750E+04, 3.9127395187E+01, 5.4347420738E+00, 2.1962889224E+01, 3.9201809855E+00, 9.7638632591E-01],
	[4.27800E+04, 3.9135432996E+01, 5.4347817977E+00, 2.1971336136E+01, 3.9205513637E+00, 9.7639747801E-01],
	[4.27850E+04, 3.9143471517E+01, 5.4348215173E+00, 2.1979785309E+01, 3.9209216484E+00, 9.7640862439E-01],
	[4.27900E+04, 3.9151510749E+01, 5.4348612326E+00, 2.1988236744E+01, 3.9212918397E+00, 9.7641976504E-01],
	[4.27950E+04, 3.9159550693E+01, 5.4349009435E+00, 2.1996690440E+01, 3.9216619376E+00, 9.7643089999E-01],
	[4.28000E+04, 3.9167591348E+01, 5.4349406500E+00, 2.2005146398E+01, 3.9220319421E+00, 9.7644202921E-01],
	[4.28050E+04, 3.9175632714E+01, 5.4349803523E+00, 2.2013604618E+01, 3.9224018532E+00, 9.7645315273E-01],
	[4.28100E+04, 3.9183674792E+01, 5.4350200501E+00, 2.2022065101E+01, 3.9227716710E+00, 9.7646427054E-01],
	[4.28150E+04, 3.9191717582E+01, 5.4350597436E+00, 2.2030527847E+01, 3.9231413954E+00, 9.7647538264E-01],
	[4.28200E+04, 3.9199761082E+01, 5.4350994328E+00, 2.2038992856E+01, 3.9235110265E+00, 9.7648648905E-01],
	[4.28250E+04, 3.9207805294E+01, 5.4351391176E+00, 2.2047460129E+01, 3.9238805643E+00, 9.7649758975E-01],
	[4.28300E+04, 3.9215850218E+01, 5.4351787981E+00, 2.2055929666E+01, 3.9242500088E+00, 9.7650868476E-01],
	[4.28350E+04, 3.9223895853E+01, 5.4352184742E+00, 2.2064401467E+01, 3.9246193601E+00, 9.7651977407E-01],
	[4.28400E+04, 3.9231942199E+01, 5.4352581460E+00, 2.2072875533E+01, 3.9249886182E+00, 9.7653085770E-01],
	[4.28450E+04, 3.9239989256E+01, 5.4352978135E+00, 2.2081351863E+01, 3.9253577831E+00, 9.7654193563E-01],
	[4.28500E+04, 3.9248037024E+01, 5.4353374766E+00, 2.2089830459E+01, 3.9257268548E+00, 9.7655300789E-01],
	[4.28550E+04, 3.9256085504E+01, 5.4353771354E+00, 2.2098311321E+01, 3.9260958334E+00, 9.7656407446E-01],
	[4.28600E+04, 3.9264134695E+01, 5.4354167898E+00, 2.2106794449E+01, 3.9264647188E+00, 9.7657513536E-01],
	[4.28650E+04, 3.9272184597E+01, 5.4354564399E+00, 2.2115279843E+01, 3.9268335111E+00, 9.7658619058E-01],
	[4.28700E+04, 3.9280235210E+01, 5.4354960857E+00, 2.2123767504E+01, 3.9272022104E+00, 9.7659724013E-01],
	[4.28750E+04, 3.9288286535E+01, 5.4355357271E+00, 2.2132257432E+01, 3.9275708166E+00, 9.7660828401E-01],
	[4.28800E+04, 3.9296338570E+01, 5.4355753642E+00, 2.2140749628E+01, 3.9279393297E+00, 9.7661932223E-01],
	[4.28850E+04, 3.9304391317E+01, 5.4356149970E+00, 2.2149244091E+01, 3.9283077498E+00, 9.7663035478E-01],
	[4.28900E+04, 3.9312444775E+01, 5.4356546254E+00, 2.2157740822E+01, 3.9286760770E+00, 9.7664138167E-01],
	[4.28950E+04, 3.9320498944E+01, 5.4356942495E+00, 2.2166239821E+01, 3.9290443111E+00, 9.7665240291E-01],
	[4.29000E+04, 3.9328553824E+01, 5.4357338693E+00, 2.2174741090E+01, 3.9294124523E+00, 9.7666341849E-01],
	[4.29050E+04, 3.9336609415E+01, 5.4357734847E+00, 2.2183244627E+01, 3.9297805006E+00, 9.7667442842E-01],
	[4.29100E+04, 3.9344665717E+01, 5.4358130959E+00, 2.2191750434E+01, 3.9301484560E+00, 9.7668543271E-01],
	[4.29150E+04, 3.9352722729E+01, 5.4358527027E+00, 2.2200258511E+01, 3.9305163185E+00, 9.7669643135E-01],
	[4.29200E+04, 3.9360780453E+01, 5.4358923051E+00, 2.2208768857E+01, 3.9308840881E+00, 9.7670742435E-01],
	[4.29250E+04, 3.9368838888E+01, 5.4359319033E+00, 2.2217281475E+01, 3.9312517649E+00, 9.7671841171E-01],
	[4.29300E+04, 3.9376898034E+01, 5.4359714971E+00, 2.2225796363E+01, 3.9316193489E+00, 9.7672939343E-01],
	[4.29350E+04, 3.9384957891E+01, 5.4360110866E+00, 2.2234313522E+01, 3.9319868401E+00, 9.7674036953E-01],
	[4.29400E+04, 3.9393018458E+01, 5.4360506717E+00, 2.2242832953E+01, 3.9323542386E+00, 9.7675133999E-01],
	[4.29450E+04, 3.9401079736E+01, 5.4360902526E+00, 2.2251354655E+01, 3.9327215443E+00, 9.7676230483E-01],
	[4.29500E+04, 3.9409141726E+01, 5.4361298291E+00, 2.2259878630E+01, 3.9330887572E+00, 9.7677326404E-01],
	[4.29550E+04, 3.9417204426E+01, 5.4361694013E+00, 2.2268404877E+01, 3.9334558775E+00, 9.7678421763E-01],
	[4.29600E+04, 3.9425267837E+01, 5.4362089692E+00, 2.2276933397E+01, 3.9338229051E+00, 9.7679516561E-01],
	[4.29650E+04, 3.9433331958E+01, 5.4362485328E+00, 2.2285464190E+01, 3.9341898400E+00, 9.7680610797E-01],
	[4.29700E+04, 3.9441396791E+01, 5.4362880921E+00, 2.2293997257E+01, 3.9345566823E+00, 9.7681704472E-01],
	[4.29750E+04, 3.9449462334E+01, 5.4363276470E+00, 2.2302532598E+01, 3.9349234320E+00, 9.7682797586E-01],
	[4.29800E+04, 3.9457528588E+01, 5.4363671977E+00, 2.2311070212E+01, 3.9352900891E+00, 9.7683890140E-01],
	[4.29850E+04, 3.9465595552E+01, 5.4364067440E+00, 2.2319610102E+01, 3.9356566537E+00, 9.7684982133E-01],
	[4.29900E+04, 3.9473663228E+01, 5.4364462860E+00, 2.2328152266E+01, 3.9360231257E+00, 9.7686073567E-01],
	[4.29950E+04, 3.9481731614E+01, 5.4364858237E+00, 2.2336696706E+01, 3.9363895052E+00, 9.7687164441E-01],
	[4.30000E+04, 3.9489800710E+01, 5.4365253571E+00, 2.2345243421E+01, 3.9367557922E+00, 9.7688254755E-01],
	[4.30050E+04, 3.9497870518E+01, 5.4365648861E+00, 2.2353792412E+01, 3.9371219867E+00, 9.7689344510E-01],
	[4.30100E+04, 3.9505941035E+01, 5.4366044109E+00, 2.2362343679E+01, 3.9374880887E+00, 9.7690433707E-01],
	[4.30150E+04, 3.9514012264E+01, 5.4366439314E+00, 2.2370897223E+01, 3.9378540984E+00, 9.7691522346E-01],
	[4.30200E+04, 3.9522084203E+01, 5.4366834475E+00, 2.2379453044E+01, 3.9382200156E+00, 9.7692610426E-01],
	[4.30250E+04, 3.9530156852E+01, 5.4367229594E+00, 2.2388011142E+01, 3.9385858404E+00, 9.7693697948E-01],
	[4.30300E+04, 3.9538230212E+01, 5.4367624669E+00, 2.2396571518E+01, 3.9389515729E+00, 9.7694784913E-01],
	[4.30350E+04, 3.9546304283E+01, 5.4368019702E+00, 2.2405134171E+01, 3.9393172131E+00, 9.7695871320E-01],
	[4.30400E+04, 3.9554379064E+01, 5.4368414691E+00, 2.2413699103E+01, 3.9396827609E+00, 9.7696957171E-01],
	[4.30450E+04, 3.9562454555E+01, 5.4368809637E+00, 2.2422266314E+01, 3.9400482165E+00, 9.7698042465E-01],
	[4.30500E+04, 3.9570530757E+01, 5.4369204541E+00, 2.2430835804E+01, 3.9404135797E+00, 9.7699127203E-01],
	[4.30550E+04, 3.9578607670E+01, 5.4369599401E+00, 2.2439407573E+01, 3.9407788507E+00, 9.7700211385E-01],
	[4.30600E+04, 3.9586685293E+01, 5.4369994219E+00, 2.2447981622E+01, 3.9411440295E+00, 9.7701295010E-01],
	[4.30650E+04, 3.9594763626E+01, 5.4370388993E+00, 2.2456557950E+01, 3.9415091161E+00, 9.7702378081E-01],
	[4.30700E+04, 3.9602842669E+01, 5.4370783724E+00, 2.2465136559E+01, 3.9418741105E+00, 9.7703460596E-01],
	[4.30750E+04, 3.9610922423E+01, 5.4371178413E+00, 2.2473717449E+01, 3.9422390128E+00, 9.7704542557E-01],
	[4.30800E+04, 3.9619002887E+01, 5.4371573058E+00, 2.2482300620E+01, 3.9426038229E+00, 9.7705623963E-01],
	[4.30850E+04, 3.9627084062E+01, 5.4371967661E+00, 2.2490886072E+01, 3.9429685409E+00, 9.7706704815E-01],
	[4.30900E+04, 3.9635165947E+01, 5.4372362221E+00, 2.2499473806E+01, 3.9433331669E+00, 9.7707785113E-01],
	[4.30950E+04, 3.9643248542E+01, 5.4372756738E+00, 2.2508063822E+01, 3.9436977007E+00, 9.7708864857E-01],
	[4.31000E+04, 3.9651331847E+01, 5.4373151211E+00, 2.2516656121E+01, 3.9440621425E+00, 9.7709944048E-01],
	[4.31050E+04, 3.9659415863E+01, 5.4373545642E+00, 2.2525250702E+01, 3.9444264923E+00, 9.7711022686E-01],
	[4.31100E+04, 3.9667500588E+01, 5.4373940030E+00, 2.2533847566E+01, 3.9447907501E+00, 9.7712100771E-01],
	[4.31150E+04, 3.9675586024E+01, 5.4374334376E+00, 2.2542446714E+01, 3.9451549159E+00, 9.7713178304E-01],
	[4.31200E+04, 3.9683672170E+01, 5.4374728678E+00, 2.2551048145E+01, 3.9455189898E+00, 9.7714255284E-01],
	[4.31250E+04, 3.9691759027E+01, 5.4375122937E+00, 2.2559651861E+01, 3.9458829717E+00, 9.7715331713E-01],
	[4.31300E+04, 3.9699846593E+01, 5.4375517154E+00, 2.2568257861E+01, 3.9462468617E+00, 9.7716407590E-01],
	[4.31350E+04, 3.9707934869E+01, 5.4375911328E+00, 2.2576866146E+01, 3.9466106599E+00, 9.7717482916E-01],
	[4.31400E+04, 3.9716023856E+01, 5.4376305459E+00, 2.2585476716E+01, 3.9469743662E+00, 9.7718557691E-01],
	[4.31450E+04, 3.9724113552E+01, 5.4376699547E+00, 2.2594089571E+01, 3.9473379806E+00, 9.7719631915E-01],
	[4.31500E+04, 3.9732203959E+01, 5.4377093592E+00, 2.2602704713E+01, 3.9477015032E+00, 9.7720705590E-01],
	[4.31550E+04, 3.9740295076E+01, 5.4377487595E+00, 2.2611322140E+01, 3.9480649340E+00, 9.7721778714E-01],
	[4.31600E+04, 3.9748386902E+01, 5.4377881554E+00, 2.2619941854E+01, 3.9484282731E+00, 9.7722851288E-01],
	[4.31650E+04, 3.9756479439E+01, 5.4378275471E+00, 2.2628563855E+01, 3.9487915204E+00, 9.7723923313E-01],
	[4.31700E+04, 3.9764572686E+01, 5.4378669345E+00, 2.2637188143E+01, 3.9491546759E+00, 9.7724994788E-01],
	[4.31750E+04, 3.9772666642E+01, 5.4379063177E+00, 2.2645814719E+01, 3.9495177398E+00, 9.7726065715E-01],
	[4.31800E+04, 3.9780761309E+01, 5.4379456966E+00, 2.2654443582E+01, 3.9498807120E+00, 9.7727136093E-01],
	[4.31850E+04, 3.9788856685E+01, 5.4379850711E+00, 2.2663074734E+01, 3.9502435925E+00, 9.7728205923E-01],
	[4.31900E+04, 3.9796952772E+01, 5.4380244415E+00, 2.2671708174E+01, 3.9506063814E+00, 9.7729275205E-01],
	[4.31950E+04, 3.9805049568E+01, 5.4380638075E+00, 2.2680343903E+01, 3.9509690787E+00, 9.7730343940E-01],
	[4.32000E+04, 3.9813147074E+01, 5.4381031693E+00, 2.2688981921E+01, 3.9513316843E+00, 9.7731412127E-01],
	[4.32050E+04, 3.9821245289E+01, 5.4381425268E+00, 2.2697622229E+01, 3.9516941985E+00, 9.7732479767E-01],
	[4.32100E+04, 3.9829344215E+01, 5.4381818800E+00, 2.2706264827E+01, 3.9520566210E+00, 9.7733546860E-01],
	[4.32150E+04, 3.9837443851E+01, 5.4382212290E+00, 2.2714909715E+01, 3.9524189521E+00, 9.7734613407E-01],
	[4.32200E+04, 3.9845544196E+01, 5.4382605737E+00, 2.2723556894E+01, 3.9527811916E+00, 9.7735679407E-01],
	[4.32250E+04, 3.9853645251E+01, 5.4382999141E+00, 2.2732206364E+01, 3.9531433397E+00, 9.7736744862E-01],
	[4.32300E+04, 3.9861747015E+01, 5.4383392503E+00, 2.2740858125E+01, 3.9535053963E+00, 9.7737809771E-01],
	[4.32350E+04, 3.9869849490E+01, 5.4383785822E+00, 2.2749512177E+01, 3.9538673614E+00, 9.7738874135E-01],
	[4.32400E+04, 3.9877952674E+01, 5.4384179098E+00, 2.2758168522E+01, 3.9542292352E+00, 9.7739937954E-01],
	[4.32450E+04, 3.9886056567E+01, 5.4384572332E+00, 2.2766827159E+01, 3.9545910176E+00, 9.7741001228E-01],
	[4.32500E+04, 3.9894161171E+01, 5.4384965523E+00, 2.2775488088E+01, 3.9549527086E+00, 9.7742063958E-01],
	[4.32550E+04, 3.9902266484E+01, 5.4385358671E+00, 2.2784151311E+01, 3.9553143082E+00, 9.7743126144E-01],
	[4.32600E+04, 3.9910372506E+01, 5.4385751777E+00, 2.2792816827E+01, 3.9556758166E+00, 9.7744187786E-01],
	[4.32650E+04, 3.9918479239E+01, 5.4386144840E+00, 2.2801484637E+01, 3.9560372336E+00, 9.7745248885E-01],
	[4.32700E+04, 3.9926586680E+01, 5.4386537861E+00, 2.2810154740E+01, 3.9563985594E+00, 9.7746309440E-01],
	[4.32750E+04, 3.9934694832E+01, 5.4386930839E+00, 2.2818827138E+01, 3.9567597939E+00, 9.7747369452E-01],
	[4.32800E+04, 3.9942803692E+01, 5.4387323775E+00, 2.2827501831E+01, 3.9571209372E+00, 9.7748428922E-01],
	[4.32850E+04, 3.9950913263E+01, 5.4387716668E+00, 2.2836178819E+01, 3.9574819892E+00, 9.7749487850E-01],
	[4.32900E+04, 3.9959023542E+01, 5.4388109518E+00, 2.2844858102E+01, 3.9578429501E+00, 9.7750546235E-01],
	[4.32950E+04, 3.9967134532E+01, 5.4388502326E+00, 2.2853539681E+01, 3.9582038199E+00, 9.7751604079E-01],
	[4.33000E+04, 3.9975246230E+01, 5.4388895091E+00, 2.2862223556E+01, 3.9585645985E+00, 9.7752661381E-01],
	[4.33050E+04, 3.9983358639E+01, 5.4389287814E+00, 2.2870909727E+01, 3.9589252859E+00, 9.7753718143E-01],
	[4.33100E+04, 3.9991471756E+01, 5.4389680495E+00, 2.2879598196E+01, 3.9592858823E+00, 9.7754774363E-01],
	[4.33150E+04, 3.9999585583E+01, 5.4390073133E+00, 2.2888288961E+01, 3.9596463876E+00, 9.7755830043E-01],
	[4.33200E+04, 4.0007700119E+01, 5.4390465728E+00, 2.2896982024E+01, 3.9600068019E+00, 9.7756885183E-01],
	[4.33250E+04, 4.0015815365E+01, 5.4390858281E+00, 2.2905677384E+01, 3.9603671251E+00, 9.7757939783E-01],
	[4.33300E+04, 4.0023931320E+01, 5.4391250791E+00, 2.2914375043E+01, 3.9607273573E+00, 9.7758993843E-01],
	[4.33350E+04, 4.0032047984E+01, 5.4391643259E+00, 2.2923075000E+01, 3.9610874986E+00, 9.7760047363E-01],
	[4.33400E+04, 4.0040165358E+01, 5.4392035685E+00, 2.2931777256E+01, 3.9614475488E+00, 9.7761100345E-01],
	[4.33450E+04, 4.0048283441E+01, 5.4392428068E+00, 2.2940481811E+01, 3.9618075082E+00, 9.7762152788E-01],
	[4.33500E+04, 4.0056402233E+01, 5.4392820409E+00, 2.2949188666E+01, 3.9621673766E+00, 9.7763204693E-01],
	[4.33550E+04, 4.0064521734E+01, 5.4393212707E+00, 2.2957897820E+01, 3.9625271542E+00, 9.7764256059E-01],
	[4.33600E+04, 4.0072641945E+01, 5.4393604963E+00, 2.2966609275E+01, 3.9628868408E+00, 9.7765306888E-01],
	[4.33650E+04, 4.0080762865E+01, 5.4393997176E+00, 2.2975323030E+01, 3.9632464366E+00, 9.7766357179E-01],
	[4.33700E+04, 4.0088884493E+01, 5.4394389347E+00, 2.2984039086E+01, 3.9636059416E+00, 9.7767406933E-01],
	[4.33750E+04, 4.0097006831E+01, 5.4394781476E+00, 2.2992757443E+01, 3.9639653558E+00, 9.7768456149E-01],
	[4.33800E+04, 4.0105129879E+01, 5.4395173562E+00, 2.3001478102E+01, 3.9643246793E+00, 9.7769504829E-01],
	[4.33850E+04, 4.0113253635E+01, 5.4395565606E+00, 2.3010201063E+01, 3.9646839119E+00, 9.7770552973E-01],
	[4.33900E+04, 4.0121378100E+01, 5.4395957608E+00, 2.3018926326E+01, 3.9650430539E+00, 9.7771600581E-01],
	[4.33950E+04, 4.0129503275E+01, 5.4396349567E+00, 2.3027653892E+01, 3.9654021051E+00, 9.7772647653E-01],
	[4.34000E+04, 4.0137629158E+01, 5.4396741484E+00, 2.3036383760E+01, 3.9657610656E+00, 9.7773694189E-01],
	[4.34050E+04, 4.0145755751E+01, 5.4397133359E+00, 2.3045115932E+01, 3.9661199355E+00, 9.7774740190E-01],
	[4.34100E+04, 4.0153890897E+01, 5.4397534743E+00, 2.3053850407E+01, 3.9664792992E+00, 9.7775785656E-01],
	[4.34150E+04, 4.0162060176E+01, 5.4397976778E+00, 2.3062587186E+01, 3.9668410623E+00, 9.7776830588E-01],
	[4.34200E+04, 4.0170230176E+01, 5.4398418766E+00, 2.3071326270E+01, 3.9672027354E+00, 9.7777874985E-01],
	[4.34250E+04, 4.0178400898E+01, 5.4398860706E+00, 2.3080067658E+01, 3.9675643185E+00, 9.7778918849E-01],
	[4.34300E+04, 4.0186572340E+01, 5.4399302599E+00, 2.3088811351E+01, 3.9679258116E+00, 9.7779962178E-01],
	[4.34350E+04, 4.0194744503E+01, 5.4399744445E+00, 2.3097557350E+01, 3.9682872147E+00, 9.7781004974E-01],
	[4.34400E+04, 4.0202917387E+01, 5.4400186243E+00, 2.3106305654E+01, 3.9686485279E+00, 9.7782047237E-01],
	[4.34450E+04, 4.0211090992E+01, 5.4400627994E+00, 2.3115056264E+01, 3.9690097512E+00, 9.7783088968E-01],
	[4.34500E+04, 4.0219265317E+01, 5.4401069698E+00, 2.3123809181E+01, 3.9693708845E+00, 9.7784130165E-01],
	[4.34550E+04, 4.0227440364E+01, 5.4401511355E+00, 2.3132564404E+01, 3.9697319280E+00, 9.7785170830E-01],
	[4.34600E+04, 4.0235616131E+01, 5.4401952964E+00, 2.3141321934E+01, 3.9700928815E+00, 9.7786210964E-01],
	[4.34650E+04, 4.0243792619E+01, 5.4402394526E+00, 2.3150081772E+01, 3.9704537453E+00, 9.7787250566E-01],
	[4.34700E+04, 4.0251969828E+01, 5.4402836041E+00, 2.3158843917E+01, 3.9708145192E+00, 9.7788289636E-01],
	[4.34750E+04, 4.0260147758E+01, 5.4403277509E+00, 2.3167608371E+01, 3.9711752034E+00, 9.7789328175E-01],
	[4.34800E+04, 4.0268326408E+01, 5.4403718930E+00, 2.3176375132E+01, 3.9715357977E+00, 9.7790366184E-01],
	[4.34850E+04, 4.0276505779E+01, 5.4404160303E+00, 2.3185144203E+01, 3.9718963024E+00, 9.7791403662E-01],
	[4.34900E+04, 4.0284685871E+01, 5.4404601629E+00, 2.3193915583E+01, 3.9722567172E+00, 9.7792440610E-01],
	[4.34950E+04, 4.0292866684E+01, 5.4405042908E+00, 2.3202689272E+01, 3.9726170424E+00, 9.7793477027E-01],
	[4.35000E+04, 4.0301048217E+01, 5.4405484140E+00, 2.3211465270E+01, 3.9729772779E+00, 9.7794512916E-01],
	[4.35050E+04, 4.0309230471E+01, 5.4405925325E+00, 2.3220243579E+01, 3.9733374237E+00, 9.7795548275E-01],
	[4.35100E+04, 4.0317413445E+01, 5.4406366463E+00, 2.3229024199E+01, 3.9736974799E+00, 9.7796583105E-01],
	[4.35150E+04, 4.0325597140E+01, 5.4406807553E+00, 2.3237807129E+01, 3.9740574465E+00, 9.7797617406E-01],
	[4.35200E+04, 4.0333781555E+01, 5.4407248597E+00, 2.3246592370E+01, 3.9744173235E+00, 9.7798651179E-01],
	[4.35250E+04, 4.0341966692E+01, 5.4407689593E+00, 2.3255379923E+01, 3.9747771109E+00, 9.7799684423E-01],
	[4.35300E+04, 4.0350152548E+01, 5.4408130543E+00, 2.3264169788E+01, 3.9751368087E+00, 9.7800717140E-01],
	[4.35350E+04, 4.0358339125E+01, 5.4408571445E+00, 2.3272961965E+01, 3.9754964171E+00, 9.7801749329E-01],
	[4.35400E+04, 4.0366526423E+01, 5.4409012300E+00, 2.3281756454E+01, 3.9758559359E+00, 9.7802780991E-01],
	[4.35450E+04, 4.0374714441E+01, 5.4409453108E+00, 2.3290553256E+01, 3.9762153652E+00, 9.7803812126E-01],
	[4.35500E+04, 4.0382903180E+01, 5.4409893869E+00, 2.3299352371E+01, 3.9765747051E+00, 9.7804842735E-01],
	[4.35550E+04, 4.0391092639E+01, 5.4410334583E+00, 2.3308153800E+01, 3.9769339555E+00, 9.7805872817E-01],
	[4.35600E+04, 4.0399282818E+01, 5.4410775250E+00, 2.3316957543E+01, 3.9772931165E+00, 9.7806902372E-01],
	[4.35650E+04, 4.0407473718E+01, 5.4411215870E+00, 2.3325763600E+01, 3.9776521881E+00, 9.7807931403E-01],
	[4.35700E+04, 4.0415665338E+01, 5.4411656443E+00, 2.3334571972E+01, 3.9780111704E+00, 9.7808959907E-01],
	[4.35750E+04, 4.0423857679E+01, 5.4412096969E+00, 2.3343382658E+01, 3.9783700632E+00, 9.7809987886E-01],
	[4.35800E+04, 4.0432050740E+01, 5.4412537448E+00, 2.3352195660E+01, 3.9787288668E+00, 9.7811015341E-01],
	[4.35850E+04, 4.0440244521E+01, 5.4412977880E+00, 2.3361010977E+01, 3.9790875810E+00, 9.7812042270E-01],
	[4.35900E+04, 4.0448439023E+01, 5.4413418265E+00, 2.3369828611E+01, 3.9794462060E+00, 9.7813068676E-01],
	[4.35950E+04, 4.0456634245E+01, 5.4413858603E+00, 2.3378648560E+01, 3.9798047417E+00, 9.7814094557E-01],
	[4.36000E+04, 4.0464830187E+01, 5.4414298895E+00, 2.3387470826E+01, 3.9801631882E+00, 9.7815119915E-01],
	[4.36050E+04, 4.0473026849E+01, 5.4414739139E+00, 2.3396295409E+01, 3.9805215454E+00, 9.7816144749E-01],
	[4.36100E+04, 4.0481224232E+01, 5.4415179336E+00, 2.3405122310E+01, 3.9808798135E+00, 9.7817169060E-01],
	[4.36150E+04, 4.0489422335E+01, 5.4415619487E+00, 2.3413951528E+01, 3.9812379923E+00, 9.7818192848E-01],
	[4.36200E+04, 4.0497621158E+01, 5.4416059590E+00, 2.3422783064E+01, 3.9815960820E+00, 9.7819216113E-01],
	[4.36250E+04, 4.0505820701E+01, 5.4416499647E+00, 2.3431616919E+01, 3.9819540826E+00, 9.7820238857E-01],
	[4.36300E+04, 4.0514020964E+01, 5.4416939657E+00, 2.3440453092E+01, 3.9823119941E+00, 9.7821261078E-01],
	[4.36350E+04, 4.0522221948E+01, 5.4417379620E+00, 2.3449291584E+01, 3.9826698165E+00, 9.7822282777E-01],
	[4.36400E+04, 4.0530423652E+01, 5.4417819536E+00, 2.3458132395E+01, 3.9830275498E+00, 9.7823303955E-01],
	[4.36450E+04, 4.0538626075E+01, 5.4418259405E+00, 2.3466975526E+01, 3.9833851941E+00, 9.7824324612E-01],
	[4.36500E+04, 4.0546829219E+01, 5.4418699227E+00, 2.3475820978E+01, 3.9837427494E+00, 9.7825344748E-01],
	[4.36550E+04, 4.0555033083E+01, 5.4419139003E+00, 2.3484668749E+01, 3.9841002157E+00, 9.7826364364E-01],
	[4.36600E+04, 4.0563237667E+01, 5.4419578732E+00, 2.3493518842E+01, 3.9844575930E+00, 9.7827383459E-01],
	[4.36650E+04, 4.0571442971E+01, 5.4420018414E+00, 2.3502371255E+01, 3.9848148813E+00, 9.7828402034E-01],
	[4.36700E+04, 4.0579648994E+01, 5.4420458049E+00, 2.3511225990E+01, 3.9851720807E+00, 9.7829420090E-01],
	[4.36750E+04, 4.0587855738E+01, 5.4420897637E+00, 2.3520083047E+01, 3.9855291912E+00, 9.7830437626E-01],
	[4.36800E+04, 4.0596063202E+01, 5.4421337179E+00, 2.3528942425E+01, 3.9858862128E+00, 9.7831454643E-01],
	[4.36850E+04, 4.0604271386E+01, 5.4421776674E+00, 2.3537804127E+01, 3.9862431456E+00, 9.7832471141E-01],
	[4.36900E+04, 4.0612480290E+01, 5.4422216122E+00, 2.3546668151E+01, 3.9865999895E+00, 9.7833487121E-01],
	[4.36950E+04, 4.0620689913E+01, 5.4422655523E+00, 2.3555534498E+01, 3.9869567446E+00, 9.7834502582E-01],
	[4.37000E+04, 4.0628900257E+01, 5.4423094878E+00, 2.3564403168E+01, 3.9873134109E+00, 9.7835517526E-01],
	[4.37050E+04, 4.0637111320E+01, 5.4423534186E+00, 2.3573274163E+01, 3.9876699884E+00, 9.7836531952E-01],
	[4.37100E+04, 4.0645323103E+01, 5.4423973447E+00, 2.3582147481E+01, 3.9880264772E+00, 9.7837545860E-01],
	[4.37150E+04, 4.0653535606E+01, 5.4424412662E+00, 2.3591023124E+01, 3.9883828772E+00, 9.7838559252E-01],
	[4.37200E+04, 4.0661748829E+01, 5.4424851829E+00, 2.3599901092E+01, 3.9887391885E+00, 9.7839572126E-01],
	[4.37250E+04, 4.0669962772E+01, 5.4425290951E+00, 2.3608781386E+01, 3.9890954112E+00, 9.7840584484E-01],
	[4.37300E+04, 4.0678177434E+01, 5.4425730025E+00, 2.3617664004E+01, 3.9894515451E+00, 9.7841596326E-01],
	[4.37350E+04, 4.0686392816E+01, 5.4426169053E+00, 2.3626548949E+01, 3.9898075905E+00, 9.7842607652E-01],
	[4.37400E+04, 4.0694608918E+01, 5.4426608034E+00, 2.3635436220E+01, 3.9901635472E+00, 9.7843618463E-01],
	[4.37450E+04, 4.0702825739E+01, 5.4427046969E+00, 2.3644325817E+01, 3.9905194153E+00, 9.7844628758E-01],
	[4.37500E+04, 4.0711043281E+01, 5.4427485856E+00, 2.3653217741E+01, 3.9908751948E+00, 9.7845638538E-01],
	[4.37550E+04, 4.0719261541E+01, 5.4427924698E+00, 2.3662111993E+01, 3.9912308858E+00, 9.7846647803E-01],
	[4.37600E+04, 4.0727480522E+01, 5.4428363492E+00, 2.3671008572E+01, 3.9915864883E+00, 9.7847656554E-01],
	[4.37650E+04, 4.0735700222E+01, 5.4428802241E+00, 2.3679907479E+01, 3.9919420022E+00, 9.7848664791E-01],
	[4.37700E+04, 4.0743920642E+01, 5.4429240942E+00, 2.3688808714E+01, 3.9922974277E+00, 9.7849672513E-01],
	[4.37750E+04, 4.0752141781E+01, 5.4429679597E+00, 2.3697712278E+01, 3.9926527647E+00, 9.7850679722E-01],
	[4.37800E+04, 4.0760363640E+01, 5.4430118205E+00, 2.3706618171E+01, 3.9930080132E+00, 9.7851686418E-01],
	[4.37850E+04, 4.0768586219E+01, 5.4430556767E+00, 2.3715526393E+01, 3.9933631733E+00, 9.7852692601E-01],
	[4.37900E+04, 4.0776809517E+01, 5.4430995282E+00, 2.3724436945E+01, 3.9937182451E+00, 9.7853698271E-01],
	[4.37950E+04, 4.0785033534E+01, 5.4431433751E+00, 2.3733349827E+01, 3.9940732284E+00, 9.7854703429E-01],
	[4.38000E+04, 4.0793258272E+01, 5.4431872173E+00, 2.3742265039E+01, 3.9944281234E+00, 9.7855708074E-01],
	[4.38050E+04, 4.0801483728E+01, 5.4432310549E+00, 2.3751182582E+01, 3.9947829301E+00, 9.7856712207E-01],
	[4.38100E+04, 4.0809709904E+01, 5.4432748878E+00, 2.3760102456E+01, 3.9951376484E+00, 9.7857715829E-01],
	[4.38150E+04, 4.0817936800E+01, 5.4433187161E+00, 2.3769024661E+01, 3.9954922785E+00, 9.7858718940E-01],
	[4.38200E+04, 4.0826164414E+01, 5.4433625397E+00, 2.3777949198E+01, 3.9958468203E+00, 9.7859721540E-01],
	[4.38250E+04, 4.0834392749E+01, 5.4434063587E+00, 2.3786876067E+01, 3.9962012738E+00, 9.7860723629E-01],
	[4.38300E+04, 4.0842621802E+01, 5.4434501730E+00, 2.3795805269E+01, 3.9965556391E+00, 9.7861725207E-01],
	[4.38350E+04, 4.0850851575E+01, 5.4434939827E+00, 2.3804736803E+01, 3.9969099163E+00, 9.7862726275E-01],
	[4.38400E+04, 4.0859082068E+01, 5.4435377877E+00, 2.3813670670E+01, 3.9972641052E+00, 9.7863726834E-01],
	[4.38450E+04, 4.0867313279E+01, 5.4435815881E+00, 2.3822606871E+01, 3.9976182060E+00, 9.7864726883E-01],
	[4.38500E+04, 4.0875545210E+01, 5.4436253838E+00, 2.3831545405E+01, 3.9979722187E+00, 9.7865726422E-01],
	[4.38550E+04, 4.0883777861E+01, 5.4436691750E+00, 2.3840486274E+01, 3.9983261432E+00, 9.7866725453E-01],
	[4.38600E+04, 4.0892011230E+01, 5.4437129614E+00, 2.3849429477E+01, 3.9986799797E+00, 9.7867723975E-01],
	[4.38650E+04, 4.0900245319E+01, 5.4437567433E+00, 2.3858375015E+01, 3.9990337281E+00, 9.7868721988E-01],
	[4.38700E+04, 4.0908480127E+01, 5.4438005204E+00, 2.3867322888E+01, 3.9993873885E+00, 9.7869719493E-01],
	[4.38750E+04, 4.0916715654E+01, 5.4438442930E+00, 2.3876273096E+01, 3.9997409608E+00, 9.7870716491E-01],
	[4.38800E+04, 4.0924951901E+01, 5.4438880609E+00, 2.3885225641E+01, 4.0000944451E+00, 9.7871712981E-01],
	[4.38850E+04, 4.0933188866E+01, 5.4439318242E+00, 2.3894180521E+01, 4.0004478415E+00, 9.7872708963E-01],
	[4.38900E+04, 4.0941426551E+01, 5.4439755829E+00, 2.3903137738E+01, 4.0008011499E+00, 9.7873704439E-01],
	[4.38950E+04, 4.0949664955E+01, 5.4440193369E+00, 2.3912097292E+01, 4.0011543703E+00, 9.7874699408E-01],
	[4.39000E+04, 4.0957904078E+01, 5.4440630863E+00, 2.3921059183E+01, 4.0015075029E+00, 9.7875693870E-01],
	[4.39050E+04, 4.0966143920E+01, 5.4441068310E+00, 2.3930023412E+01, 4.0018605475E+00, 9.7876687826E-01],
	[4.39100E+04, 4.0974384481E+01, 5.4441505711E+00, 2.3938989978E+01, 4.0022135043E+00, 9.7877681277E-01],
	[4.39150E+04, 4.0982625761E+01, 5.4441943066E+00, 2.3947958883E+01, 4.0025663732E+00, 9.7878674222E-01],
	[4.39200E+04, 4.0990867761E+01, 5.4442380375E+00, 2.3956930126E+01, 4.0029191544E+00, 9.7879666661E-01],
	[4.39250E+04, 4.0999110479E+01, 5.4442817637E+00, 2.3965903709E+01, 4.0032718477E+00, 9.7880658595E-01],
	[4.39300E+04, 4.1007353916E+01, 5.4443254853E+00, 2.3974879630E+01, 4.0036244532E+00, 9.7881650025E-01],
	[4.39350E+04, 4.1015598073E+01, 5.4443692023E+00, 2.3983857891E+01, 4.0039769710E+00, 9.7882640950E-01],
	[4.39400E+04, 4.1023842948E+01, 5.4444129147E+00, 2.3992838492E+01, 4.0043294010E+00, 9.7883631370E-01],
	[4.39450E+04, 4.1032088542E+01, 5.4444566224E+00, 2.4001821434E+01, 4.0046817434E+00, 9.7884621286E-01],
	[4.39500E+04, 4.1040334855E+01, 5.4445003256E+00, 2.4010806716E+01, 4.0050339980E+00, 9.7885610699E-01],
	[4.39550E+04, 4.1048581887E+01, 5.4445440241E+00, 2.4019794339E+01, 4.0053861650E+00, 9.7886599608E-01],
	[4.39600E+04, 4.1056829638E+01, 5.4445877179E+00, 2.4028784303E+01, 4.0057382443E+00, 9.7887588013E-01],
	[4.39650E+04, 4.1065078108E+01, 5.4446314072E+00, 2.4037776609E+01, 4.0060902360E+00, 9.7888575916E-01],
	[4.39700E+04, 4.1073327296E+01, 5.4446750918E+00, 2.4046771257E+01, 4.0064421401E+00, 9.7889563315E-01],
	[4.39750E+04, 4.1081577204E+01, 5.4447187719E+00, 2.4055768247E+01, 4.0067939566E+00, 9.7890550212E-01],
	[4.39800E+04, 4.1089827830E+01, 5.4447624473E+00, 2.4064767581E+01, 4.0071456856E+00, 9.7891536607E-01],
	[4.39850E+04, 4.1098079175E+01, 5.4448061181E+00, 2.4073769257E+01, 4.0074973270E+00, 9.7892522499E-01],
	[4.39900E+04, 4.1106331239E+01, 5.4448497842E+00, 2.4082773276E+01, 4.0078488809E+00, 9.7893507890E-01],
	[4.39950E+04, 4.1114584021E+01, 5.4448934458E+00, 2.4091779639E+01, 4.0082003473E+00, 9.7894492779E-01],
	[4.40000E+04, 4.1122837523E+01, 5.4449371028E+00, 2.4100788347E+01, 4.0085517263E+00, 9.7895477166E-01],
	[4.40050E+04, 4.1131091742E+01, 5.4449807551E+00, 2.4109799398E+01, 4.0089030178E+00, 9.7896461053E-01],
	[4.40100E+04, 4.1139346681E+01, 5.4450244028E+00, 2.4118812795E+01, 4.0092542218E+00, 9.7897444439E-01],
	[4.40150E+04, 4.1147602339E+01, 5.4450680460E+00, 2.4127828536E+01, 4.0096053385E+00, 9.7898427324E-01],
	[4.40200E+04, 4.1155858715E+01, 5.4451116845E+00, 2.4136846623E+01, 4.0099563678E+00, 9.7899409709E-01],
	[4.40250E+04, 4.1164115809E+01, 5.4451553184E+00, 2.4145867056E+01, 4.0103073097E+00, 9.7900391594E-01],
	[4.40300E+04, 4.1172373622E+01, 5.4451989477E+00, 2.4154889835E+01, 4.0106581643E+00, 9.7901372979E-01],
	[4.40350E+04, 4.1180632154E+01, 5.4452425724E+00, 2.4163914961E+01, 4.0110089316E+00, 9.7902353864E-01],
	[4.40400E+04, 4.1188891405E+01, 5.4452861925E+00, 2.4172942433E+01, 4.0113596115E+00, 9.7903334250E-01],
	[4.40450E+04, 4.1197151374E+01, 5.4453298080E+00, 2.4181972252E+01, 4.0117102042E+00, 9.7904314137E-01],
	[4.40500E+04, 4.1205412061E+01, 5.4453734189E+00, 2.4191004419E+01, 4.0120607097E+00, 9.7905293525E-01],
	[4.40550E+04, 4.1213673467E+01, 5.4454170252E+00, 2.4200038934E+01, 4.0124111279E+00, 9.7906272415E-01],
	[4.40600E+04, 4.1221935592E+01, 5.4454606269E+00, 2.4209075797E+01, 4.0127614590E+00, 9.7907250806E-01],
	[4.40650E+04, 4.1230198435E+01, 5.4455042240E+00, 2.4218115009E+01, 4.0131117028E+00, 9.7908228699E-01],
	[4.40700E+04, 4.1238461996E+01, 5.4455478165E+00, 2.4227156569E+01, 4.0134618595E+00, 9.7909206094E-01],
	[4.40750E+04, 4.1246726276E+01, 5.4455914044E+00, 2.4236200479E+01, 4.0138119290E+00, 9.7910182992E-01],
	[4.40800E+04, 4.1254991275E+01, 5.4456349877E+00, 2.4245246738E+01, 4.0141619114E+00, 9.7911159393E-01],
	[4.40850E+04, 4.1263256992E+01, 5.4456785664E+00, 2.4254295347E+01, 4.0145118068E+00, 9.7912135296E-01],
	[4.40900E+04, 4.1271523427E+01, 5.4457221405E+00, 2.4263346307E+01, 4.0148616150E+00, 9.7913110703E-01],
	[4.40950E+04, 4.1279790580E+01, 5.4457657100E+00, 2.4272399617E+01, 4.0152113362E+00, 9.7914085613E-01],
	[4.41000E+04, 4.1288058452E+01, 5.4458092750E+00, 2.4281455278E+01, 4.0155609704E+00, 9.7915060027E-01],
	[4.41050E+04, 4.1296327042E+01, 5.4458528353E+00, 2.4290513290E+01, 4.0159105176E+00, 9.7916033945E-01],
	[4.41100E+04, 4.1304596351E+01, 5.4458963911E+00, 2.4299573654E+01, 4.0162599778E+00, 9.7917007367E-01],
	[4.41150E+04, 4.1312866378E+01, 5.4459399422E+00, 2.4308636370E+01, 4.0166093510E+00, 9.7917980293E-01],
	[4.41200E+04, 4.1321137123E+01, 5.4459834888E+00, 2.4317701438E+01, 4.0169586373E+00, 9.7918952724E-01],
	[4.41250E+04, 4.1329408586E+01, 5.4460270308E+00, 2.4326768859E+01, 4.0173078366E+00, 9.7919924660E-01],
	[4.41300E+04, 4.1337680768E+01, 5.4460705682E+00, 2.4335838633E+01, 4.0176569491E+00, 9.7920896101E-01],
	[4.41350E+04, 4.1345953668E+01, 5.4461141010E+00, 2.4344910760E+01, 4.0180059747E+00, 9.7921867048E-01],
	[4.41400E+04, 4.1354227286E+01, 5.4461576293E+00, 2.4353985241E+01, 4.0183549134E+00, 9.7922837501E-01],
	[4.41450E+04, 4.1362501622E+01, 5.4462011529E+00, 2.4363062076E+01, 4.0187037653E+00, 9.7923807459E-01],
	[4.41500E+04, 4.1370776676E+01, 5.4462446720E+00, 2.4372141265E+01, 4.0190525304E+00, 9.7924776924E-01],
	[4.41550E+04, 4.1379052449E+01, 5.4462881865E+00, 2.4381222809E+01, 4.0194012087E+00, 9.7925745895E-01],
	[4.41600E+04, 4.1387328940E+01, 5.4463316964E+00, 2.4390306708E+01, 4.0197498003E+00, 9.7926714373E-01],
	[4.41650E+04, 4.1395606148E+01, 5.4463752017E+00, 2.4399392963E+01, 4.0200983051E+00, 9.7927682358E-01],
	[4.41700E+04, 4.1403884075E+01, 5.4464187025E+00, 2.4408481573E+01, 4.0204467232E+00, 9.7928649850E-01],
	[4.41750E+04, 4.1412162720E+01, 5.4464621986E+00, 2.4417572540E+01, 4.0207950546E+00, 9.7929616849E-01],
	[4.41800E+04, 4.1420442083E+01, 5.4465056902E+00, 2.4426665863E+01, 4.0211432993E+00, 9.7930583357E-01],
	[4.41850E+04, 4.1428722164E+01, 5.4465491773E+00, 2.4435761542E+01, 4.0214914574E+00, 9.7931549372E-01],
	[4.41900E+04, 4.1437002963E+01, 5.4465926597E+00, 2.4444859579E+01, 4.0218395288E+00, 9.7932514896E-01],
	[4.41950E+04, 4.1445284480E+01, 5.4466361376E+00, 2.4453959974E+01, 4.0221875136E+00, 9.7933479928E-01],
	[4.42000E+04, 4.1453566715E+01, 5.4466796109E+00, 2.4463062726E+01, 4.0225354118E+00, 9.7934444468E-01],
	[4.42050E+04, 4.1461849668E+01, 5.4467230797E+00, 2.4472167836E+01, 4.0228832235E+00, 9.7935408518E-01],
	[4.42100E+04, 4.1470133338E+01, 5.4467665438E+00, 2.4481275305E+01, 4.0232309486E+00, 9.7936372077E-01],
	[4.42150E+04, 4.1478417727E+01, 5.4468100034E+00, 2.4490385133E+01, 4.0235785872E+00, 9.7937335145E-01],
	[4.42200E+04, 4.1486702834E+01, 5.4468534585E+00, 2.4499497320E+01, 4.0239261393E+00, 9.7938297724E-01],
	[4.42250E+04, 4.1494988658E+01, 5.4468969089E+00, 2.4508611866E+01, 4.0242736049E+00, 9.7939259812E-01],
	[4.42300E+04, 4.1503275201E+01, 5.4469403548E+00, 2.4517728772E+01, 4.0246209841E+00, 9.7940221410E-01],
	[4.42350E+04, 4.1511562461E+01, 5.4469837962E+00, 2.4526848039E+01, 4.0249682768E+00, 9.7941182519E-01],
	[4.42400E+04, 4.1519850439E+01, 5.4470272330E+00, 2.4535969666E+01, 4.0253154831E+00, 9.7942143139E-01],
	[4.42450E+04, 4.1528139135E+01, 5.4470706652E+00, 2.4545093654E+01, 4.0256626031E+00, 9.7943103270E-01],
	[4.42500E+04, 4.1536428548E+01, 5.4471140928E+00, 2.4554220004E+01, 4.0260096366E+00, 9.7944062912E-01],
	[4.42550E+04, 4.1544718679E+01, 5.4471575159E+00, 2.4563348715E+01, 4.0263565839E+00, 9.7945022065E-01],
	[4.42600E+04, 4.1553009529E+01, 5.4472009344E+00, 2.4572479788E+01, 4.0267034448E+00, 9.7945980731E-01],
	[4.42650E+04, 4.1561301095E+01, 5.4472443484E+00, 2.4581613223E+01, 4.0270502193E+00, 9.7946938908E-01],
	[4.42700E+04, 4.1569593380E+01, 5.4472877578E+00, 2.4590749021E+01, 4.0273969077E+00, 9.7947896597E-01],
	[4.42750E+04, 4.1577886382E+01, 5.4473311627E+00, 2.4599887182E+01, 4.0277435097E+00, 9.7948853799E-01],
	[4.42800E+04, 4.1586180102E+01, 5.4473745630E+00, 2.4609027706E+01, 4.0280900255E+00, 9.7949810514E-01],
	[4.42850E+04, 4.1594474539E+01, 5.4474179587E+00, 2.4618170594E+01, 4.0284364551E+00, 9.7950766742E-01],
	[4.42900E+04, 4.1602769695E+01, 5.4474613499E+00, 2.4627315846E+01, 4.0287827985E+00, 9.7951722483E-01],
	[4.42950E+04, 4.1611065567E+01, 5.4475047366E+00, 2.4636463462E+01, 4.0291290558E+00, 9.7952677738E-01],
	[4.43000E+04, 4.1619362158E+01, 5.4475481186E+00, 2.4645613443E+01, 4.0294752269E+00, 9.7953632506E-01],
	[4.43050E+04, 4.1627659466E+01, 5.4475914962E+00, 2.4654765789E+01, 4.0298213119E+00, 9.7954586789E-01],
	[4.43100E+04, 4.1635957491E+01, 5.4476348692E+00, 2.4663920500E+01, 4.0301673107E+00, 9.7955540585E-01],
	[4.43150E+04, 4.1644256234E+01, 5.4476782376E+00, 2.4673077578E+01, 4.0305132235E+00, 9.7956493896E-01],
	[4.43200E+04, 4.1652555695E+01, 5.4477216015E+00, 2.4682237021E+01, 4.0308590502E+00, 9.7957446722E-01],
	[4.43250E+04, 4.1660855873E+01, 5.4477649608E+00, 2.4691398831E+01, 4.0312047909E+00, 9.7958399063E-01],
	[4.43300E+04, 4.1669156768E+01, 5.4478083156E+00, 2.4700563007E+01, 4.0315504456E+00, 9.7959350920E-01],
	[4.43350E+04, 4.1677458381E+01, 5.4478516659E+00, 2.4709729551E+01, 4.0318960143E+00, 9.7960302292E-01],
	[4.43400E+04, 4.1685760712E+01, 5.4478950116E+00, 2.4718898462E+01, 4.0322414970E+00, 9.7961253179E-01],
	[4.43450E+04, 4.1694063759E+01, 5.4479383528E+00, 2.4728069741E+01, 4.0325868937E+00, 9.7962203583E-01],
	[4.43500E+04, 4.1702367525E+01, 5.4479816894E+00, 2.4737243388E+01, 4.0329322046E+00, 9.7963153503E-01],
	[4.43550E+04, 4.1710672007E+01, 5.4480250215E+00, 2.4746419403E+01, 4.0332774295E+00, 9.7964102939E-01],
	[4.43600E+04, 4.1718977207E+01, 5.4480683490E+00, 2.4755597788E+01, 4.0336225685E+00, 9.7965051892E-01],
	[4.43650E+04, 4.1727283124E+01, 5.4481116720E+00, 2.4764778541E+01, 4.0339676217E+00, 9.7966000363E-01],
	[4.43700E+04, 4.1735589759E+01, 5.4481549905E+00, 2.4773961664E+01, 4.0343125890E+00, 9.7966948350E-01],
	[4.43750E+04, 4.1743897111E+01, 5.4481983044E+00, 2.4783147157E+01, 4.0346574705E+00, 9.7967895855E-01],
	[4.43800E+04, 4.1752205180E+01, 5.4482416138E+00, 2.4792335021E+01, 4.0350022663E+00, 9.7968842878E-01],
	[4.43850E+04, 4.1760513967E+01, 5.4482849187E+00, 2.4801525254E+01, 4.0353469762E+00, 9.7969789419E-01],
	[4.43900E+04, 4.1768823471E+01, 5.4483282190E+00, 2.4810717859E+01, 4.0356916004E+00, 9.7970735478E-01],
	[4.43950E+04, 4.1777133692E+01, 5.4483715148E+00, 2.4819912835E+01, 4.0360361389E+00, 9.7971681056E-01],
	[4.44000E+04, 4.1785444630E+01, 5.4484148061E+00, 2.4829110183E+01, 4.0363805916E+00, 9.7972626153E-01],
	[4.44050E+04, 4.1793756285E+01, 5.4484580928E+00, 2.4838309902E+01, 4.0367249587E+00, 9.7973570768E-01],
	[4.44100E+04, 4.1802068658E+01, 5.4485013750E+00, 2.4847511994E+01, 4.0370692401E+00, 9.7974514903E-01],
	[4.44150E+04, 4.1810381747E+01, 5.4485446527E+00, 2.4856716458E+01, 4.0374134359E+00, 9.7975458557E-01],
	[4.44200E+04, 4.1818695554E+01, 5.4485879258E+00, 2.4865923296E+01, 4.0377575460E+00, 9.7976401732E-01],
	[4.44250E+04, 4.1827010078E+01, 5.4486311944E+00, 2.4875132506E+01, 4.0381015706E+00, 9.7977344426E-01],
	[4.44300E+04, 4.1835325319E+01, 5.4486744585E+00, 2.4884344091E+01, 4.0384455095E+00, 9.7978286640E-01],
	[4.44350E+04, 4.1843641278E+01, 5.4487177181E+00, 2.4893558049E+01, 4.0387893630E+00, 9.7979228376E-01],
	[4.44400E+04, 4.1851957953E+01, 5.4487609731E+00, 2.4902774382E+01, 4.0391331308E+00, 9.7980169631E-01],
	[4.44450E+04, 4.1860275345E+01, 5.4488042237E+00, 2.4911993089E+01, 4.0394768132E+00, 9.7981110408E-01],
	[4.44500E+04, 4.1868593454E+01, 5.4488474697E+00, 2.4921214172E+01, 4.0398204101E+00, 9.7982050707E-01],
	[4.44550E+04, 4.1876912281E+01, 5.4488907111E+00, 2.4930437630E+01, 4.0401639215E+00, 9.7982990526E-01],
	[4.44600E+04, 4.1885231824E+01, 5.4489339481E+00, 2.4939663463E+01, 4.0405073475E+00, 9.7983929868E-01],
	[4.44650E+04, 4.1893552084E+01, 5.4489771805E+00, 2.4948891673E+01, 4.0408506881E+00, 9.7984868732E-01],
	[4.44700E+04, 4.1901873061E+01, 5.4490204085E+00, 2.4958122259E+01, 4.0411939432E+00, 9.7985807118E-01],
	[4.44750E+04, 4.1910194756E+01, 5.4490636319E+00, 2.4967355222E+01, 4.0415371130E+00, 9.7986745026E-01],
	[4.44800E+04, 4.1918517167E+01, 5.4491068507E+00, 2.4976590562E+01, 4.0418801974E+00, 9.7987682457E-01],
	[4.44850E+04, 4.1926840295E+01, 5.4491500651E+00, 2.4985828279E+01, 4.0422231965E+00, 9.7988619412E-01],
	[4.44900E+04, 4.1935164139E+01, 5.4491932750E+00, 2.4995068375E+01, 4.0425661102E+00, 9.7989555889E-01],
	[4.44950E+04, 4.1943488701E+01, 5.4492364803E+00, 2.5004310848E+01, 4.0429089387E+00, 9.7990491890E-01],
	[4.45000E+04, 4.1951813980E+01, 5.4492796811E+00, 2.5013555700E+01, 4.0432516819E+00, 9.7991427415E-01],
	[4.45050E+04, 4.1960139975E+01, 5.4493228775E+00, 2.5022802931E+01, 4.0435943399E+00, 9.7992362464E-01],
	[4.45100E+04, 4.1968466687E+01, 5.4493660693E+00, 2.5032052541E+01, 4.0439369126E+00, 9.7993297038E-01],
	[4.45150E+04, 4.1976794116E+01, 5.4494092566E+00, 2.5041304530E+01, 4.0442794001E+00, 9.7994231136E-01],
	[4.45200E+04, 4.1985122262E+01, 5.4494524394E+00, 2.5050558899E+01, 4.0446218025E+00, 9.7995164758E-01],
	[4.45250E+04, 4.1993451124E+01, 5.4494956176E+00, 2.5059815649E+01, 4.0449641197E+00, 9.7996097906E-01],
	[4.45300E+04, 4.2001780703E+01, 5.4495387914E+00, 2.5069074779E+01, 4.0453063517E+00, 9.7997030579E-01],
	[4.45350E+04, 4.2010110999E+01, 5.4495819607E+00, 2.5078336290E+01, 4.0456484986E+00, 9.7997962778E-01],
	[4.45400E+04, 4.2018442011E+01, 5.4496251254E+00, 2.5087600182E+01, 4.0459905605E+00, 9.7998894502E-01],
	[4.45450E+04, 4.2026773741E+01, 5.4496682857E+00, 2.5096866456E+01, 4.0463325373E+00, 9.7999825752E-01],
	[4.45500E+04, 4.2035106186E+01, 5.4497114415E+00, 2.5106135112E+01, 4.0466744290E+00, 9.8000756529E-01],
	[4.45550E+04, 4.2043439349E+01, 5.4497545927E+00, 2.5115406150E+01, 4.0470162357E+00, 9.8001686832E-01],
	[4.45600E+04, 4.2051773228E+01, 5.4497977395E+00, 2.5124679571E+01, 4.0473579573E+00, 9.8002616663E-01],
	[4.45650E+04, 4.2060107824E+01, 5.4498408817E+00, 2.5133955374E+01, 4.0476995940E+00, 9.8003546020E-01],
	[4.45700E+04, 4.2068443136E+01, 5.4498840195E+00, 2.5143233561E+01, 4.0480411458E+00, 9.8004474904E-01],
	[4.45750E+04, 4.2076779165E+01, 5.4499271528E+00, 2.5152514132E+01, 4.0483826126E+00, 9.8005403316E-01],
	[4.45800E+04, 4.2085115910E+01, 5.4499702815E+00, 2.5161797087E+01, 4.0487239945E+00, 9.8006331256E-01],
	[4.45850E+04, 4.2093453372E+01, 5.4500134058E+00, 2.5171082426E+01, 4.0490652914E+00, 9.8007258724E-01],
	[4.45900E+04, 4.2101791550E+01, 5.4500565256E+00, 2.5180370149E+01, 4.0494065035E+00, 9.8008185720E-01],
	[4.45950E+04, 4.2110130445E+01, 5.4500996409E+00, 2.5189660258E+01, 4.0497476308E+00, 9.8009112244E-01],
	[4.46000E+04, 4.2118470056E+01, 5.4501427517E+00, 2.5198952752E+01, 4.0500886732E+00, 9.8010038298E-01],
	[4.46050E+04, 4.2126810384E+01, 5.4501858580E+00, 2.5208247632E+01, 4.0504296308E+00, 9.8010963880E-01],
	[4.46100E+04, 4.2135151428E+01, 5.4502289598E+00, 2.5217544898E+01, 4.0507705037E+00, 9.8011888992E-01],
	[4.46150E+04, 4.2143493189E+01, 5.4502720571E+00, 2.5226844550E+01, 4.0511112917E+00, 9.8012813633E-01],
	[4.46200E+04, 4.2151835666E+01, 5.4503151499E+00, 2.5236146590E+01, 4.0514519950E+00, 9.8013737804E-01],
	[4.46250E+04, 4.2160178859E+01, 5.4503582382E+00, 2.5245451016E+01, 4.0517926136E+00, 9.8014661506E-01],
	[4.46300E+04, 4.2168522769E+01, 5.4504013221E+00, 2.5254757829E+01, 4.0521331475E+00, 9.8015584737E-01],
	[4.46350E+04, 4.2176867395E+01, 5.4504444015E+00, 2.5264067031E+01, 4.0524735967E+00, 9.8016507499E-01],
	[4.46400E+04, 4.2185212737E+01, 5.4504874763E+00, 2.5273378621E+01, 4.0528139613E+00, 9.8017429792E-01],
	[4.46450E+04, 4.2193558795E+01, 5.4505305467E+00, 2.5282692599E+01, 4.0531542412E+00, 9.8018351616E-01],
	[4.46500E+04, 4.2201905570E+01, 5.4505736127E+00, 2.5292008966E+01, 4.0534944365E+00, 9.8019272971E-01],
	[4.46550E+04, 4.2210253061E+01, 5.4506166741E+00, 2.5301327722E+01, 4.0538345473E+00, 9.8020193857E-01],
	[4.46600E+04, 4.2218601269E+01, 5.4506597310E+00, 2.5310648868E+01, 4.0541745734E+00, 9.8021114276E-01],
	[4.46650E+04, 4.2226950192E+01, 5.4507027835E+00, 2.5319972403E+01, 4.0545145150E+00, 9.8022034226E-01],
	[4.46700E+04, 4.2235299832E+01, 5.4507458315E+00, 2.5329298329E+01, 4.0548543721E+00, 9.8022953709E-01],
	[4.46750E+04, 4.2243650188E+01, 5.4507888750E+00, 2.5338626646E+01, 4.0551941447E+00, 9.8023872724E-01],
	[4.46800E+04, 4.2252001260E+01, 5.4508319140E+00, 2.5347957353E+01, 4.0555338328E+00, 9.8024791272E-01],
	[4.46850E+04, 4.2260353048E+01, 5.4508749486E+00, 2.5357290451E+01, 4.0558734364E+00, 9.8025709353E-01],
	[4.46900E+04, 4.2268705553E+01, 5.4509179787E+00, 2.5366625941E+01, 4.0562129556E+00, 9.8026626967E-01],
	[4.46950E+04, 4.2277058773E+01, 5.4509610043E+00, 2.5375963824E+01, 4.0565523904E+00, 9.8027544115E-01],
	[4.47000E+04, 4.2285412710E+01, 5.4510040254E+00, 2.5385304098E+01, 4.0568917408E+00, 9.8028460797E-01],
	[4.47050E+04, 4.2293767362E+01, 5.4510470421E+00, 2.5394646765E+01, 4.0572310068E+00, 9.8029377012E-01],
	[4.47100E+04, 4.2302122731E+01, 5.4510900543E+00, 2.5403991825E+01, 4.0575701885E+00, 9.8030292762E-01],
	[4.47150E+04, 4.2310478815E+01, 5.4511330620E+00, 2.5413339278E+01, 4.0579092858E+00, 9.8031208047E-01],
	[4.47200E+04, 4.2318835616E+01, 5.4511760653E+00, 2.5422689125E+01, 4.0582482989E+00, 9.8032122866E-01],
	[4.47250E+04, 4.2327193133E+01, 5.4512190641E+00, 2.5432041366E+01, 4.0585872276E+00, 9.8033037220E-01],
	[4.47300E+04, 4.2335551366E+01, 5.4512620584E+00, 2.5441396002E+01, 4.0589260721E+00, 9.8033951109E-01],
	[4.47350E+04, 4.2343910314E+01, 5.4513050482E+00, 2.5450753032E+01, 4.0592648323E+00, 9.8034864534E-01],
	[4.47400E+04, 4.2352269979E+01, 5.4513480336E+00, 2.5460112457E+01, 4.0596035084E+00, 9.8035777495E-01],
	[4.47450E+04, 4.2360630359E+01, 5.4513910145E+00, 2.5469474277E+01, 4.0599421002E+00, 9.8036689992E-01],
	[4.47500E+04, 4.2368991455E+01, 5.4514339910E+00, 2.5478838494E+01, 4.0602806078E+00, 9.8037602025E-01],
	[4.47550E+04, 4.2377353268E+01, 5.4514769630E+00, 2.5488205106E+01, 4.0606190313E+00, 9.8038513594E-01],
	[4.47600E+04, 4.2385715796E+01, 5.4515199305E+00, 2.5497574115E+01, 4.0609573707E+00, 9.8039424700E-01],
	[4.47650E+04, 4.2394079040E+01, 5.4515628936E+00, 2.5506945520E+01, 4.0612956260E+00, 9.8040335344E-01],
	[4.47700E+04, 4.2402443000E+01, 5.4516058522E+00, 2.5516319323E+01, 4.0616337971E+00, 9.8041245524E-01],
	[4.47750E+04, 4.2410807675E+01, 5.4516488063E+00, 2.5525695523E+01, 4.0619718842E+00, 9.8042155242E-01],
	[4.47800E+04, 4.2419173066E+01, 5.4516917560E+00, 2.5535074121E+01, 4.0623098873E+00, 9.8043064498E-01],
	[4.47850E+04, 4.2427539174E+01, 5.4517347013E+00, 2.5544455117E+01, 4.0626478063E+00, 9.8043973291E-01],
	[4.47900E+04, 4.2435905996E+01, 5.4517776420E+00, 2.5553838512E+01, 4.0629856414E+00, 9.8044881623E-01],
	[4.47950E+04, 4.2444273535E+01, 5.4518205784E+00, 2.5563224305E+01, 4.0633233924E+00, 9.8045789493E-01],
	[4.48000E+04, 4.2452641789E+01, 5.4518635102E+00, 2.5572612498E+01, 4.0636610595E+00, 9.8046696903E-01],
	[4.48050E+04, 4.2461010759E+01, 5.4519064377E+00, 2.5582003090E+01, 4.0639986427E+00, 9.8047603851E-01],
	[4.48100E+04, 4.2469380445E+01, 5.4519493606E+00, 2.5591396082E+01, 4.0643361419E+00, 9.8048510338E-01],
	[4.48150E+04, 4.2477750846E+01, 5.4519922791E+00, 2.5600791475E+01, 4.0646735573E+00, 9.8049416365E-01],
	[4.48200E+04, 4.2486121963E+01, 5.4520351932E+00, 2.5610189268E+01, 4.0650108888E+00, 9.8050321931E-01],
	[4.48250E+04, 4.2494493796E+01, 5.4520781028E+00, 2.5619589462E+01, 4.0653481364E+00, 9.8051227038E-01],
	[4.48300E+04, 4.2502866344E+01, 5.4521210080E+00, 2.5628992057E+01, 4.0656853002E+00, 9.8052131684E-01],
	[4.48350E+04, 4.2511239608E+01, 5.4521639087E+00, 2.5638397053E+01, 4.0660223802E+00, 9.8053035871E-01],
	[4.48400E+04, 4.2519613587E+01, 5.4522068050E+00, 2.5647804452E+01, 4.0663593765E+00, 9.8053939599E-01],
	[4.48450E+04, 4.2527988282E+01, 5.4522496968E+00, 2.5657214253E+01, 4.0666962889E+00, 9.8054842868E-01],
	[4.48500E+04, 4.2536363692E+01, 5.4522925842E+00, 2.5666626457E+01, 4.0670331177E+00, 9.8055745678E-01],
	[4.48550E+04, 4.2544739818E+01, 5.4523354671E+00, 2.5676041063E+01, 4.0673698627E+00, 9.8056648029E-01],
	[4.48600E+04, 4.2553116660E+01, 5.4523783456E+00, 2.5685458073E+01, 4.0677065240E+00, 9.8057549922E-01],
	[4.48650E+04, 4.2561494217E+01, 5.4524212197E+00, 2.5694877487E+01, 4.0680431016E+00, 9.8058451357E-01],
	[4.48700E+04, 4.2569872489E+01, 5.4524640893E+00, 2.5704299305E+01, 4.0683795956E+00, 9.8059352335E-01],
	[4.48750E+04, 4.2578251477E+01, 5.4525069544E+00, 2.5713723527E+01, 4.0687160059E+00, 9.8060252854E-01],
	[4.48800E+04, 4.2586631180E+01, 5.4525498152E+00, 2.5723150154E+01, 4.0690523327E+00, 9.8061152917E-01],
	[4.48850E+04, 4.2595011598E+01, 5.4525926715E+00, 2.5732579185E+01, 4.0693885758E+00, 9.8062052522E-01],
	[4.48900E+04, 4.2603392732E+01, 5.4526355233E+00, 2.5742010623E+01, 4.0697247354E+00, 9.8062951670E-01],
	[4.48950E+04, 4.2611774582E+01, 5.4526783708E+00, 2.5751444466E+01, 4.0700608115E+00, 9.8063850362E-01],
	[4.49000E+04, 4.2620157146E+01, 5.4527212137E+00, 2.5760880715E+01, 4.0703968040E+00, 9.8064748598E-01],
	[4.49050E+04, 4.2628540426E+01, 5.4527640523E+00, 2.5770319371E+01, 4.0707327130E+00, 9.8065646377E-01],
	[4.49100E+04, 4.2636924421E+01, 5.4528068864E+00, 2.5779760433E+01, 4.0710685386E+00, 9.8066543701E-01],
	[4.49150E+04, 4.2645309132E+01, 5.4528497161E+00, 2.5789203902E+01, 4.0714042807E+00, 9.8067440569E-01],
	[4.49200E+04, 4.2653694558E+01, 5.4528925414E+00, 2.5798649780E+01, 4.0717399393E+00, 9.8068336981E-01],
	[4.49250E+04, 4.2662080699E+01, 5.4529353622E+00, 2.5808098064E+01, 4.0720755146E+00, 9.8069232939E-01],
	[4.49300E+04, 4.2670467555E+01, 5.4529781786E+00, 2.5817548757E+01, 4.0724110064E+00, 9.8070128442E-01],
	[4.49350E+04, 4.2678855126E+01, 5.4530209906E+00, 2.5827001859E+01, 4.0727464149E+00, 9.8071023490E-01],
	[4.49400E+04, 4.2687243413E+01, 5.4530637981E+00, 2.5836457369E+01, 4.0730817400E+00, 9.8071918083E-01],
	[4.49450E+04, 4.2695632415E+01, 5.4531066012E+00, 2.5845915289E+01, 4.0734169819E+00, 9.8072812223E-01],
	[4.49500E+04, 4.2704022132E+01, 5.4531493999E+00, 2.5855375618E+01, 4.0737521404E+00, 9.8073705909E-01],
	[4.49550E+04, 4.2712412564E+01, 5.4531921942E+00, 2.5864838358E+01, 4.0740872156E+00, 9.8074599141E-01],
	[4.49600E+04, 4.2720803711E+01, 5.4532349840E+00, 2.5874303507E+01, 4.0744222075E+00, 9.8075491920E-01],
	[4.49650E+04, 4.2729195573E+01, 5.4532777694E+00, 2.5883771067E+01, 4.0747571163E+00, 9.8076384245E-01],
	[4.49700E+04, 4.2737588151E+01, 5.4533205504E+00, 2.5893241038E+01, 4.0750919418E+00, 9.8077276118E-01],
	[4.49750E+04, 4.2745981443E+01, 5.4533633270E+00, 2.5902713420E+01, 4.0754266841E+00, 9.8078167538E-01],
	[4.49800E+04, 4.2754375451E+01, 5.4534060992E+00, 2.5912188214E+01, 4.0757613432E+00, 9.8079058505E-01],
	[4.49850E+04, 4.2762770173E+01, 5.4534488669E+00, 2.5921665420E+01, 4.0760959192E+00, 9.8079949021E-01],
	[4.49900E+04, 4.2771165611E+01, 5.4534916302E+00, 2.5931145038E+01, 4.0764304121E+00, 9.8080839084E-01],
	[4.49950E+04, 4.2779561763E+01, 5.4535343891E+00, 2.5940627069E+01, 4.0767648218E+00, 9.8081728696E-01],
	[4.50000E+04, 4.2787958631E+01, 5.4535771436E+00, 2.5950111513E+01, 4.0770991485E+00, 9.8082617857E-01],
	[4.50050E+04, 4.2796356213E+01, 5.4536198937E+00, 2.5959619076E+01, 4.0774339029E+00, 9.8083506566E-01],
	[4.50100E+04, 4.2804754511E+01, 5.4536626393E+00, 2.5969129066E+01, 4.0777685740E+00, 9.8084394824E-01],
	[4.50150E+04, 4.2813153523E+01, 5.4537053806E+00, 2.5978641483E+01, 4.0781031618E+00, 9.8085282632E-01],
	[4.50200E+04, 4.2821553250E+01, 5.4537481174E+00, 2.5988156327E+01, 4.0784376664E+00, 9.8086169989E-01],
	[4.50250E+04, 4.2829953692E+01, 5.4537908498E+00, 2.5997673599E+01, 4.0787720877E+00, 9.8087056896E-01],
	[4.50300E+04, 4.2838354849E+01, 5.4538335779E+00, 2.6007193299E+01, 4.0791064258E+00, 9.8087943354E-01],
	[4.50350E+04, 4.2846756721E+01, 5.4538763015E+00, 2.6016715427E+01, 4.0794406807E+00, 9.8088829361E-01],
	[4.50400E+04, 4.2855159307E+01, 5.4539190206E+00, 2.6026239984E+01, 4.0797748525E+00, 9.8089714919E-01],
	[4.50450E+04, 4.2863562609E+01, 5.4539617354E+00, 2.6035766970E+01, 4.0801089411E+00, 9.8090600028E-01],
	[4.50500E+04, 4.2871966625E+01, 5.4540044458E+00, 2.6045296385E+01, 4.0804429465E+00, 9.8091484687E-01],
	[4.50550E+04, 4.2880371356E+01, 5.4540471518E+00, 2.6054828230E+01, 4.0807768689E+00, 9.8092368898E-01],
	[4.50600E+04, 4.2888776801E+01, 5.4540898534E+00, 2.6064362505E+01, 4.0811107081E+00, 9.8093252661E-01],
	[4.50650E+04, 4.2897182961E+01, 5.4541325505E+00, 2.6073899210E+01, 4.0814444643E+00, 9.8094135975E-01],
	[4.50700E+04, 4.2905589837E+01, 5.4541752433E+00, 2.6083438346E+01, 4.0817781374E+00, 9.8095018841E-01],
	[4.50750E+04, 4.2913997426E+01, 5.4542179316E+00, 2.6092979913E+01, 4.0821117275E+00, 9.8095901260E-01],
	[4.50800E+04, 4.2922405731E+01, 5.4542606156E+00, 2.6102523912E+01, 4.0824452347E+00, 9.8096783231E-01],
	[4.50850E+04, 4.2930814750E+01, 5.4543032952E+00, 2.6112070343E+01, 4.0827786588E+00, 9.8097664755E-01],
	[4.50900E+04, 4.2939224483E+01, 5.4543459703E+00, 2.6121619205E+01, 4.0831120000E+00, 9.8098545832E-01],
	[4.50950E+04, 4.2947634932E+01, 5.4543886411E+00, 2.6131170500E+01, 4.0834452582E+00, 9.8099426461E-01],
	[4.51000E+04, 4.2956046095E+01, 5.4544313074E+00, 2.6140724228E+01, 4.0837784335E+00, 9.8100306645E-01],
	[4.51050E+04, 4.2964457972E+01, 5.4544739694E+00, 2.6150280390E+01, 4.0841115260E+00, 9.8101186382E-01],
	[4.51100E+04, 4.2972870564E+01, 5.4545166270E+00, 2.6159838984E+01, 4.0844445355E+00, 9.8102065673E-01],
	[4.51150E+04, 4.2981283871E+01, 5.4545592802E+00, 2.6169400013E+01, 4.0847774622E+00, 9.8102944519E-01],
	[4.51200E+04, 4.2989697892E+01, 5.4546019289E+00, 2.6178963476E+01, 4.0851103061E+00, 9.8103822918E-01],
	[4.51250E+04, 4.2998112627E+01, 5.4546445733E+00, 2.6188529374E+01, 4.0854430672E+00, 9.8104700873E-01],
	[4.51300E+04, 4.3006528078E+01, 5.4546872133E+00, 2.6198097706E+01, 4.0857757455E+00, 9.8105578382E-01],
	[4.51350E+04, 4.3014944242E+01, 5.4547298489E+00, 2.6207668474E+01, 4.0861083410E+00, 9.8106455447E-01],
	[4.51400E+04, 4.3023361121E+01, 5.4547724802E+00, 2.6217241678E+01, 4.0864408538E+00, 9.8107332067E-01],
	[4.51450E+04, 4.3031814952E+01, 5.4548193788E+00, 2.6226817317E+01, 4.0867760085E+00, 9.8108208242E-01],
	[4.51500E+04, 4.3040273649E+01, 5.4548667607E+00, 2.6236395393E+01, 4.0871113923E+00, 9.8109083974E-01],
	[4.51550E+04, 4.3048733072E+01, 5.4549141378E+00, 2.6245975906E+01, 4.0874466939E+00, 9.8109959262E-01],
	[4.51600E+04, 4.3057193220E+01, 5.4549615101E+00, 2.6255558855E+01, 4.0877819133E+00, 9.8110834106E-01],
	[4.51650E+04, 4.3065654095E+01, 5.4550088775E+00, 2.6265144242E+01, 4.0881170505E+00, 9.8111708506E-01],
	[4.51700E+04, 4.3074115694E+01, 5.4550562401E+00, 2.6274732067E+01, 4.0884521056E+00, 9.8112582464E-01],
	[4.51750E+04, 4.3082578020E+01, 5.4551035978E+00, 2.6284322330E+01, 4.0887870785E+00, 9.8113455979E-01],
	[4.51800E+04, 4.3091041071E+01, 5.4551509507E+00, 2.6293915032E+01, 4.0891219694E+00, 9.8114329051E-01],
	[4.51850E+04, 4.3099504848E+01, 5.4551982988E+00, 2.6303510172E+01, 4.0894567782E+00, 9.8115201681E-01],
	[4.51900E+04, 4.3107969350E+01, 5.4552456421E+00, 2.6313107751E+01, 4.0897915049E+00, 9.8116073868E-01],
	[4.51950E+04, 4.3116434579E+01, 5.4552929806E+00, 2.6322707770E+01, 4.0901261496E+00, 9.8116945614E-01],
	[4.52000E+04, 4.3124900532E+01, 5.4553403142E+00, 2.6332310229E+01, 4.0904607123E+00, 9.8117816918E-01],
	[4.52050E+04, 4.3133367212E+01, 5.4553876430E+00, 2.6341915128E+01, 4.0907951930E+00, 9.8118687780E-01],
	[4.52100E+04, 4.3141834616E+01, 5.4554349669E+00, 2.6351522467E+01, 4.0911295917E+00, 9.8119558202E-01],
	[4.52150E+04, 4.3150302747E+01, 5.4554822861E+00, 2.6361132248E+01, 4.0914639084E+00, 9.8120428182E-01],
	[4.52200E+04, 4.3158771603E+01, 5.4555296004E+00, 2.6370744470E+01, 4.0917981433E+00, 9.8121297722E-01],
	[4.52250E+04, 4.3167241184E+01, 5.4555769099E+00, 2.6380359133E+01, 4.0921322962E+00, 9.8122166821E-01],
	[4.52300E+04, 4.3175711491E+01, 5.4556242146E+00, 2.6389976238E+01, 4.0924663672E+00, 9.8123035480E-01],
	[4.52350E+04, 4.3184182523E+01, 5.4556715144E+00, 2.6399595786E+01, 4.0928003564E+00, 9.8123903699E-01],
	[4.52400E+04, 4.3192654281E+01, 5.4557188095E+00, 2.6409217776E+01, 4.0931342637E+00, 9.8124771479E-01],
	[4.52450E+04, 4.3201126764E+01, 5.4557660997E+00, 2.6418842209E+01, 4.0934680892E+00, 9.8125638819E-01],
	[4.52500E+04, 4.3209599973E+01, 5.4558133851E+00, 2.6428469086E+01, 4.0938018329E+00, 9.8126505719E-01],
	[4.52550E+04, 4.3218073907E+01, 5.4558606657E+00, 2.6438098406E+01, 4.0941354949E+00, 9.8127372181E-01],
	[4.52600E+04, 4.3226548566E+01, 5.4559079415E+00, 2.6447730171E+01, 4.0944690750E+00, 9.8128238204E-01],
	[4.52650E+04, 4.3235023951E+01, 5.4559552124E+00, 2.6457364379E+01, 4.0948025735E+00, 9.8129103788E-01],
	[4.52700E+04, 4.3243500061E+01, 5.4560024786E+00, 2.6467001033E+01, 4.0951359902E+00, 9.8129968934E-01],
	[4.52750E+04, 4.3251976896E+01, 5.4560497399E+00, 2.6476640132E+01, 4.0954693252E+00, 9.8130833642E-01],
	[4.52800E+04, 4.3260454457E+01, 5.4560969965E+00, 2.6486281676E+01, 4.0958025786E+00, 9.8131697912E-01],
	[4.52850E+04, 4.3268932743E+01, 5.4561442482E+00, 2.6495925666E+01, 4.0961357503E+00, 9.8132561745E-01],
	[4.52900E+04, 4.3277411754E+01, 5.4561914951E+00, 2.6505572102E+01, 4.0964688403E+00, 9.8133425141E-01],
	[4.52950E+04, 4.3285891491E+01, 5.4562387372E+00, 2.6515220985E+01, 4.0968018488E+00, 9.8134288099E-01],
	[4.53000E+04, 4.3294371953E+01, 5.4562859745E+00, 2.6524872314E+01, 4.0971347757E+00, 9.8135150620E-01],
	[4.53050E+04, 4.3302853140E+01, 5.4563332070E+00, 2.6534526091E+01, 4.0974676210E+00, 9.8136012705E-01],
	[4.53100E+04, 4.3311335052E+01, 5.4563804347E+00, 2.6544182315E+01, 4.0978003848E+00, 9.8136874354E-01],
	[4.53150E+04, 4.3319817689E+01, 5.4564276576E+00, 2.6553840987E+01, 4.0981330670E+00, 9.8137735566E-01],
	[4.53200E+04, 4.3328301052E+01, 5.4564748757E+00, 2.6563502108E+01, 4.0984656677E+00, 9.8138596343E-01],
	[4.53250E+04, 4.3336785139E+01, 5.4565220890E+00, 2.6573165677E+01, 4.0987981870E+00, 9.8139456684E-01],
	[4.53300E+04, 4.3345269952E+01, 5.4565692975E+00, 2.6582831695E+01, 4.0991306248E+00, 9.8140316589E-01],
	[4.53350E+04, 4.3353755490E+01, 5.4566165012E+00, 2.6592500163E+01, 4.0994629812E+00, 9.8141176060E-01],
	[4.53400E+04, 4.3362241753E+01, 5.4566637001E+00, 2.6602171080E+01, 4.0997952561E+00, 9.8142035095E-01],
	[4.53450E+04, 4.3370728741E+01, 5.4567108942E+00, 2.6611844447E+01, 4.1001274497E+00, 9.8142893696E-01],
	[4.53500E+04, 4.3379216454E+01, 5.4567580835E+00, 2.6621520264E+01, 4.1004595619E+00, 9.8143751863E-01],
	[4.53550E+04, 4.3387704892E+01, 5.4568052680E+00, 2.6631198532E+01, 4.1007915927E+00, 9.8144609595E-01],
	[4.53600E+04, 4.3396194055E+01, 5.4568524477E+00, 2.6640879251E+01, 4.1011235422E+00, 9.8145466893E-01],
	[4.53650E+04, 4.3404683943E+01, 5.4568996227E+00, 2.6650562422E+01, 4.1014554104E+00, 9.8146323758E-01],
	[4.53700E+04, 4.3413174556E+01, 5.4569467928E+00, 2.6660248045E+01, 4.1017871973E+00, 9.8147180189E-01],
	[4.53750E+04, 4.3421665895E+01, 5.4569939581E+00, 2.6669936119E+01, 4.1021189029E+00, 9.8148036187E-01],
	[4.53800E+04, 4.3430157958E+01, 5.4570411187E+00, 2.6679626646E+01, 4.1024505273E+00, 9.8148891752E-01],
	[4.53850E+04, 4.3438650745E+01, 5.4570882744E+00, 2.6689319626E+01, 4.1027820704E+00, 9.8149746884E-01],
	[4.53900E+04, 4.3447144258E+01, 5.4571354254E+00, 2.6699015059E+01, 4.1031135324E+00, 9.8150601584E-01],
	[4.53950E+04, 4.3455638496E+01, 5.4571825716E+00, 2.6708712946E+01, 4.1034449131E+00, 9.8151455852E-01],
	[4.54000E+04, 4.3464133459E+01, 5.4572297130E+00, 2.6718413286E+01, 4.1037762128E+00, 9.8152309687E-01],
	[4.54050E+04, 4.3472629146E+01, 5.4572768496E+00, 2.6728116081E+01, 4.1041074312E+00, 9.8153163091E-01],
	[4.54100E+04, 4.3481125558E+01, 5.4573239815E+00, 2.6737821330E+01, 4.1044385686E+00, 9.8154016063E-01],
	[4.54150E+04, 4.3489622696E+01, 5.4573711085E+00, 2.6747529034E+01, 4.1047696248E+00, 9.8154868604E-01],
	[4.54200E+04, 4.3498120557E+01, 5.4574182308E+00, 2.6757239193E+01, 4.1051006000E+00, 9.8155720713E-01],
	[4.54250E+04, 4.3506619144E+01, 5.4574653483E+00, 2.6766951808E+01, 4.1054314941E+00, 9.8156572392E-01],
	[4.54300E+04, 4.3515118456E+01, 5.4575124610E+00, 2.6776666879E+01, 4.1057623072E+00, 9.8157423641E-01],
	[4.54350E+04, 4.3523618492E+01, 5.4575595690E+00, 2.6786384407E+01, 4.1060930393E+00, 9.8158274459E-01],
	[4.54400E+04, 4.3532119253E+01, 5.4576066721E+00, 2.6796104391E+01, 4.1064236904E+00, 9.8159124847E-01],
	[4.54450E+04, 4.3540620738E+01, 5.4576537705E+00, 2.6805826832E+01, 4.1067542605E+00, 9.8159974805E-01],
	[4.54500E+04, 4.3549122949E+01, 5.4577008641E+00, 2.6815551730E+01, 4.1070847497E+00, 9.8160824333E-01],
	[4.54550E+04, 4.3557625884E+01, 5.4577479530E+00, 2.6825279087E+01, 4.1074151579E+00, 9.8161673432E-01],
	[4.54600E+04, 4.3566129543E+01, 5.4577950370E+00, 2.6835008901E+01, 4.1077454853E+00, 9.8162522102E-01],
	[4.54650E+04, 4.3574633928E+01, 5.4578421163E+00, 2.6844741173E+01, 4.1080757317E+00, 9.8163370343E-01],
	[4.54700E+04, 4.3583139037E+01, 5.4578891908E+00, 2.6854475905E+01, 4.1084058973E+00, 9.8164218155E-01],
	[4.54750E+04, 4.3591644870E+01, 5.4579362606E+00, 2.6864213096E+01, 4.1087359821E+00, 9.8165065539E-01],
	[4.54800E+04, 4.3600151428E+01, 5.4579833255E+00, 2.6873952746E+01, 4.1090659860E+00, 9.8165912495E-01],
	[4.54850E+04, 4.3608658711E+01, 5.4580303858E+00, 2.6883694856E+01, 4.1093959091E+00, 9.8166759023E-01],
	[4.54900E+04, 4.3617166718E+01, 5.4580774412E+00, 2.6893439426E+01, 4.1097257515E+00, 9.8167605123E-01],
	[4.54950E+04, 4.3625675450E+01, 5.4581244919E+00, 2.6903186456E+01, 4.1100555131E+00, 9.8168450795E-01],
	[4.55000E+04, 4.3634184906E+01, 5.4581715378E+00, 2.6912935948E+01, 4.1103851939E+00, 9.8169296040E-01],
	[4.55050E+04, 4.3642695087E+01, 5.4582185789E+00, 2.6922687901E+01, 4.1107147941E+00, 9.8170140859E-01],
	[4.55100E+04, 4.3651205992E+01, 5.4582656153E+00, 2.6932442315E+01, 4.1110443135E+00, 9.8170985250E-01],
	[4.55150E+04, 4.3659717622E+01, 5.4583126469E+00, 2.6942199191E+01, 4.1113737523E+00, 9.8171829215E-01],
	[4.55200E+04, 4.3668229976E+01, 5.4583596738E+00, 2.6951958530E+01, 4.1117031104E+00, 9.8172672754E-01],
	[4.55250E+04, 4.3676743055E+01, 5.4584066959E+00, 2.6961720331E+01, 4.1120323879E+00, 9.8173515866E-01],
	[4.55300E+04, 4.3685256857E+01, 5.4584537132E+00, 2.6971484595E+01, 4.1123615848E+00, 9.8174358553E-01],
	[4.55350E+04, 4.3693771385E+01, 5.4585007258E+00, 2.6981251323E+01, 4.1126907011E+00, 9.8175200815E-01],
	[4.55400E+04, 4.3702286637E+01, 5.4585477336E+00, 2.6991020514E+01, 4.1130197368E+00, 9.8176042650E-01],
	[4.55450E+04, 4.3710802613E+01, 5.4585947367E+00, 2.7000792169E+01, 4.1133486920E+00, 9.8176884061E-01],
	[4.55500E+04, 4.3719319313E+01, 5.4586417350E+00, 2.7010566289E+01, 4.1136775667E+00, 9.8177725047E-01],
	[4.55550E+04, 4.3727836738E+01, 5.4586887286E+00, 2.7020342874E+01, 4.1140063609E+00, 9.8178565608E-01],
	[4.55600E+04, 4.3736354887E+01, 5.4587357174E+00, 2.7030121923E+01, 4.1143350745E+00, 9.8179405745E-01],
	[4.55650E+04, 4.3744873760E+01, 5.4587827015E+00, 2.7039903438E+01, 4.1146637078E+00, 9.8180245458E-01],
	[4.55700E+04, 4.3753393358E+01, 5.4588296808E+00, 2.7049687419E+01, 4.1149922606E+00, 9.8181084747E-01],
	[4.55750E+04, 4.3761913679E+01, 5.4588766553E+00, 2.7059473866E+01, 4.1153207329E+00, 9.8181923612E-01],
	[4.55800E+04, 4.3770434725E+01, 5.4589236251E+00, 2.7069262779E+01, 4.1156491249E+00, 9.8182762054E-01],
	[4.55850E+04, 4.3778956496E+01, 5.4589705902E+00, 2.7079054160E+01, 4.1159774365E+00, 9.8183600072E-01],
	[4.55900E+04, 4.3787478990E+01, 5.4590175505E+00, 2.7088848007E+01, 4.1163056677E+00, 9.8184437668E-01],
	[4.55950E+04, 4.3796002209E+01, 5.4590645061E+00, 2.7098644322E+01, 4.1166338186E+00, 9.8185274841E-01],
	[4.56000E+04, 4.3804526151E+01, 5.4591114569E+00, 2.7108443105E+01, 4.1169618892E+00, 9.8186111591E-01],
	[4.56050E+04, 4.3813050818E+01, 5.4591584030E+00, 2.7118244356E+01, 4.1172898795E+00, 9.8186947919E-01],
	[4.56100E+04, 4.3821576209E+01, 5.4592053443E+00, 2.7128048076E+01, 4.1176177896E+00, 9.8187783825E-01],
	[4.56150E+04, 4.3830102324E+01, 5.4592522809E+00, 2.7137854265E+01, 4.1179456194E+00, 9.8188619310E-01],
	[4.56200E+04, 4.3838629164E+01, 5.4592992127E+00, 2.7147662923E+01, 4.1182733689E+00, 9.8189454372E-01],
	[4.56250E+04, 4.3847156727E+01, 5.4593461398E+00, 2.7157474051E+01, 4.1186010383E+00, 9.8190289014E-01],
	[4.56300E+04, 4.3855685014E+01, 5.4593930622E+00, 2.7167287649E+01, 4.1189286275E+00, 9.8191123234E-01],
	[4.56350E+04, 4.3864214025E+01, 5.4594399798E+00, 2.7177103717E+01, 4.1192561365E+00, 9.8191957034E-01],
	[4.56400E+04, 4.3872743761E+01, 5.4594868927E+00, 2.7186922256E+01, 4.1195835653E+00, 9.8192790412E-01],
	[4.56450E+04, 4.3881274220E+01, 5.4595338009E+00, 2.7196743265E+01, 4.1199109141E+00, 9.8193623371E-01],
	[4.56500E+04, 4.3889805403E+01, 5.4595807043E+00, 2.7206566747E+01, 4.1202381827E+00, 9.8194455909E-01],
	[4.56550E+04, 4.3898337311E+01, 5.4596276030E+00, 2.7216392700E+01, 4.1205653713E+00, 9.8195288028E-01],
	[4.56600E+04, 4.3906869942E+01, 5.4596744969E+00, 2.7226221125E+01, 4.1208924798E+00, 9.8196119727E-01],
	[4.56650E+04, 4.3915403297E+01, 5.4597213862E+00, 2.7236052023E+01, 4.1212195083E+00, 9.8196951006E-01],
	[4.56700E+04, 4.3923937376E+01, 5.4597682707E+00, 2.7245885393E+01, 4.1215464567E+00, 9.8197781866E-01],
	[4.56750E+04, 4.3932472179E+01, 5.4598151504E+00, 2.7255721237E+01, 4.1218733252E+00, 9.8198612307E-01],
	[4.56800E+04, 4.3941007706E+01, 5.4598620255E+00, 2.7265559554E+01, 4.1222001137E+00, 9.8199442330E-01],
	[4.56850E+04, 4.3949543956E+01, 5.4599088958E+00, 2.7275400345E+01, 4.1225268222E+00, 9.8200271934E-01],
	[4.56900E+04, 4.3958080931E+01, 5.4599557613E+00, 2.7285243610E+01, 4.1228534508E+00, 9.8201101120E-01],
	[4.56950E+04, 4.3966618629E+01, 5.4600026222E+00, 2.7295089350E+01, 4.1231799995E+00, 9.8201929888E-01],
	[4.57000E+04, 4.3975157051E+01, 5.4600494783E+00, 2.7304937565E+01, 4.1235064683E+00, 9.8202758238E-01],
	[4.57050E+04, 4.3983696197E+01, 5.4600963297E+00, 2.7314788255E+01, 4.1238328573E+00, 9.8203586170E-01],
	[4.57100E+04, 4.3992236067E+01, 5.4601431764E+00, 2.7324641421E+01, 4.1241591664E+00, 9.8204413685E-01],
	[4.57150E+04, 4.4000776660E+01, 5.4601900184E+00, 2.7334497063E+01, 4.1244853956E+00, 9.8205240783E-01],
	[4.57200E+04, 4.4009317977E+01, 5.4602368556E+00, 2.7344355181E+01, 4.1248115451E+00, 9.8206067464E-01],
	[4.57250E+04, 4.4017860018E+01, 5.4602836881E+00, 2.7354215775E+01, 4.1251376148E+00, 9.8206893728E-01],
	[4.57300E+04, 4.4026402782E+01, 5.4603305159E+00, 2.7364078847E+01, 4.1254636047E+00, 9.8207719576E-01],
	[4.57350E+04, 4.4034946271E+01, 5.4603773390E+00, 2.7373944396E+01, 4.1257895149E+00, 9.8208545007E-01],
	[4.57400E+04, 4.4043490482E+01, 5.4604241573E+00, 2.7383812423E+01, 4.1261153453E+00, 9.8209370022E-01],
	[4.57450E+04, 4.4052035418E+01, 5.4604709710E+00, 2.7393682928E+01, 4.1264410961E+00, 9.8210194622E-01],
	[4.57500E+04, 4.4060581077E+01, 5.4605177799E+00, 2.7403555911E+01, 4.1267667672E+00, 9.8211018805E-01],
	[4.57550E+04, 4.4069127460E+01, 5.4605645841E+00, 2.7413431374E+01, 4.1270923586E+00, 9.8211842574E-01],
	[4.57600E+04, 4.4077674566E+01, 5.4606113836E+00, 2.7423309315E+01, 4.1274178704E+00, 9.8212665927E-01],
	[4.57650E+04, 4.4086222396E+01, 5.4606581784E+00, 2.7433189736E+01, 4.1277433026E+00, 9.8213488864E-01],
	[4.57700E+04, 4.4094770949E+01, 5.4607049685E+00, 2.7443072636E+01, 4.1280686552E+00, 9.8214311387E-01],
	[4.57750E+04, 4.4103320226E+01, 5.4607517539E+00, 2.7452958017E+01, 4.1283939282E+00, 9.8215133496E-01],
	[4.57800E+04, 4.4111870226E+01, 5.4607985345E+00, 2.7462845879E+01, 4.1287191216E+00, 9.8215955190E-01],
	[4.57850E+04, 4.4120420950E+01, 5.4608453105E+00, 2.7472736221E+01, 4.1290442356E+00, 9.8216776469E-01],
	[4.57900E+04, 4.4128972398E+01, 5.4608920817E+00, 2.7482629045E+01, 4.1293692700E+00, 9.8217597335E-01],
	[4.57950E+04, 4.4137524568E+01, 5.4609388483E+00, 2.7492524350E+01, 4.1296942249E+00, 9.8218417787E-01],
	[4.58000E+04, 4.4146077463E+01, 5.4609856101E+00, 2.7502422137E+01, 4.1300191004E+00, 9.8219237825E-01],
	[4.58050E+04, 4.4154631080E+01, 5.4610323672E+00, 2.7512322406E+01, 4.1303438964E+00, 9.8220057450E-01],
	[4.58100E+04, 4.4163185422E+01, 5.4610791196E+00, 2.7522225158E+01, 4.1306686130E+00, 9.8220876661E-01],
	[4.58150E+04, 4.4171740486E+01, 5.4611258674E+00, 2.7532130394E+01, 4.1309932502E+00, 9.8221695460E-01],
	[4.58200E+04, 4.4180296274E+01, 5.4611726104E+00, 2.7542038112E+01, 4.1313178080E+00, 9.8222513846E-01],
	[4.58250E+04, 4.4188852785E+01, 5.4612193487E+00, 2.7551948314E+01, 4.1316422865E+00, 9.8223331819E-01],
	[4.58300E+04, 4.4197410020E+01, 5.4612660823E+00, 2.7561861000E+01, 4.1319666856E+00, 9.8224149380E-01],
	[4.58350E+04, 4.4205967977E+01, 5.4613128113E+00, 2.7571776171E+01, 4.1322910054E+00, 9.8224966529E-01],
	[4.58400E+04, 4.4214526659E+01, 5.4613595355E+00, 2.7581693827E+01, 4.1326152459E+00, 9.8225783266E-01],
	[4.58450E+04, 4.4223086063E+01, 5.4614062550E+00, 2.7591613967E+01, 4.1329394071E+00, 9.8226599591E-01],
	[4.58500E+04, 4.4231646191E+01, 5.4614529698E+00, 2.7601536593E+01, 4.1332634890E+00, 9.8227415505E-01],
	[4.58550E+04, 4.4240207042E+01, 5.4614996800E+00, 2.7611461705E+01, 4.1335874918E+00, 9.8228231008E-01],
	[4.58600E+04, 4.4248768616E+01, 5.4615463854E+00, 2.7621389303E+01, 4.1339114153E+00, 9.8229046099E-01],
	[4.58650E+04, 4.4257330913E+01, 5.4615930862E+00, 2.7631319387E+01, 4.1342352596E+00, 9.8229860779E-01],
	[4.58700E+04, 4.4265893934E+01, 5.4616397822E+00, 2.7641251959E+01, 4.1345590247E+00, 9.8230675049E-01],
	[4.58750E+04, 4.4274457678E+01, 5.4616864736E+00, 2.7651187017E+01, 4.1348827107E+00, 9.8231488908E-01],
	[4.58800E+04, 4.4283022145E+01, 5.4617331603E+00, 2.7661124564E+01, 4.1352063176E+00, 9.8232302357E-01],
	[4.58850E+04, 4.4291587335E+01, 5.4617798423E+00, 2.7671064598E+01, 4.1355298454E+00, 9.8233115396E-01],
	[4.58900E+04, 4.4300153248E+01, 5.4618265196E+00, 2.7681007120E+01, 4.1358532940E+00, 9.8233928025E-01],
	[4.58950E+04, 4.4308719884E+01, 5.4618731922E+00, 2.7690952131E+01, 4.1361766636E+00, 9.8234740245E-01],
	[4.59000E+04, 4.4317287243E+01, 5.4619198601E+00, 2.7700899631E+01, 4.1364999542E+00, 9.8235552055E-01],
	[4.59050E+04, 4.4325855326E+01, 5.4619665234E+00, 2.7710849621E+01, 4.1368231657E+00, 9.8236363456E-01],
	[4.59100E+04, 4.4334424131E+01, 5.4620131819E+00, 2.7720802100E+01, 4.1371462982E+00, 9.8237174448E-01],
	[4.59150E+04, 4.4342993660E+01, 5.4620598358E+00, 2.7730757069E+01, 4.1374693518E+00, 9.8237985031E-01],
	[4.59200E+04, 4.4351563911E+01, 5.4621064850E+00, 2.7740714528E+01, 4.1377923264E+00, 9.8238795205E-01],
	[4.59250E+04, 4.4360134886E+01, 5.4621531295E+00, 2.7750674479E+01, 4.1381152220E+00, 9.8239604971E-01],
	[4.59300E+04, 4.4368706583E+01, 5.4621997694E+00, 2.7760636920E+01, 4.1384380387E+00, 9.8240414329E-01],
	[4.59350E+04, 4.4377279004E+01, 5.4622464045E+00, 2.7770601853E+01, 4.1387607766E+00, 9.8241223279E-01],
	[4.59400E+04, 4.4385852147E+01, 5.4622930350E+00, 2.7780569277E+01, 4.1390834355E+00, 9.8242031821E-01],
	[4.59450E+04, 4.4394426013E+01, 5.4623396608E+00, 2.7790539194E+01, 4.1394060156E+00, 9.8242839956E-01],
	[4.59500E+04, 4.4403000603E+01, 5.4623862819E+00, 2.7800511603E+01, 4.1397285169E+00, 9.8243647683E-01],
	[4.59550E+04, 4.4411575915E+01, 5.4624328984E+00, 2.7810486506E+01, 4.1400509393E+00, 9.8244455003E-01],
	[4.59600E+04, 4.4420151950E+01, 5.4624795102E+00, 2.7820463901E+01, 4.1403732829E+00, 9.8245261917E-01],
	[4.59650E+04, 4.4428728708E+01, 5.4625261173E+00, 2.7830443790E+01, 4.1406955478E+00, 9.8246068423E-01],
	[4.59700E+04, 4.4437306188E+01, 5.4625727197E+00, 2.7840426173E+01, 4.1410177339E+00, 9.8246874523E-01],
	[4.59750E+04, 4.4445884392E+01, 5.4626193175E+00, 2.7850411050E+01, 4.1413398413E+00, 9.8247680217E-01],
	[4.59800E+04, 4.4454463318E+01, 5.4626659106E+00, 2.7860398421E+01, 4.1416618700E+00, 9.8248485505E-01],
	[4.59850E+04, 4.4463042967E+01, 5.4627124990E+00, 2.7870388288E+01, 4.1419838200E+00, 9.8249290387E-01],
	[4.59900E+04, 4.4471623339E+01, 5.4627590827E+00, 2.7880380650E+01, 4.1423056913E+00, 9.8250094863E-01],
	[4.59950E+04, 4.4480204434E+01, 5.4628056618E+00, 2.7890375508E+01, 4.1426274840E+00, 9.8250898933E-01],
	[4.60000E+04, 4.4488786251E+01, 5.4628522363E+00, 2.7900372861E+01, 4.1429491980E+00, 9.8251702599E-01],
	[4.60050E+04, 4.4497368791E+01, 5.4628988060E+00, 2.7910372711E+01, 4.1432708335E+00, 9.8252505859E-01],
	[4.60100E+04, 4.4505952054E+01, 5.4629453711E+00, 2.7920375058E+01, 4.1435923903E+00, 9.8253308715E-01],
	[4.60150E+04, 4.4514536039E+01, 5.4629919315E+00, 2.7930379902E+01, 4.1439138686E+00, 9.8254111165E-01],
	[4.60200E+04, 4.4523120747E+01, 5.4630384873E+00, 2.7940387243E+01, 4.1442352684E+00, 9.8254913212E-01],
	[4.60250E+04, 4.4531706178E+01, 5.4630850384E+00, 2.7950397082E+01, 4.1445565896E+00, 9.8255714854E-01],
	[4.60300E+04, 4.4540292331E+01, 5.4631315849E+00, 2.7960409419E+01, 4.1448778323E+00, 9.8256516092E-01],
	[4.60350E+04, 4.4548879207E+01, 5.4631781267E+00, 2.7970424255E+01, 4.1451989966E+00, 9.8257316927E-01],
	[4.60400E+04, 4.4557466806E+01, 5.4632246638E+00, 2.7980441589E+01, 4.1455200824E+00, 9.8258117358E-01],
	[4.60450E+04, 4.4566055127E+01, 5.4632711963E+00, 2.7990461423E+01, 4.1458410897E+00, 9.8258917385E-01],
	[4.60500E+04, 4.4574644171E+01, 5.4633177241E+00, 2.8000483756E+01, 4.1461620187E+00, 9.8259717010E-01],
	[4.60550E+04, 4.4583233937E+01, 5.4633642472E+00, 2.8010508589E+01, 4.1464828692E+00, 9.8260516231E-01],
	[4.60600E+04, 4.4591824426E+01, 5.4634107657E+00, 2.8020535923E+01, 4.1468036414E+00, 9.8261315049E-01],
	[4.60650E+04, 4.4600415637E+01, 5.4634572796E+00, 2.8030565757E+01, 4.1471243352E+00, 9.8262113466E-01],
	[4.60700E+04, 4.4609007570E+01, 5.4635037888E+00, 2.8040598092E+01, 4.1474449507E+00, 9.8262911479E-01],
	[4.60750E+04, 4.4617600227E+01, 5.4635502933E+00, 2.8050632928E+01, 4.1477654879E+00, 9.8263709091E-01],
	[4.60800E+04, 4.4626193605E+01, 5.4635967932E+00, 2.8060670266E+01, 4.1480859467E+00, 9.8264506300E-01],
	[4.60850E+04, 4.4634787706E+01, 5.4636432885E+00, 2.8070710106E+01, 4.1484063273E+00, 9.8265303108E-01],
	[4.60900E+04, 4.4643382530E+01, 5.4636897791E+00, 2.8080752448E+01, 4.1487266297E+00, 9.8266099515E-01],
	[4.60950E+04, 4.4651978076E+01, 5.4637362650E+00, 2.8090797293E+01, 4.1490468538E+00, 9.8266895520E-01],
	[4.61000E+04, 4.4660574344E+01, 5.4637827463E+00, 2.8100844641E+01, 4.1493669997E+00, 9.8267691124E-01],
	[4.61050E+04, 4.4669171334E+01, 5.4638292230E+00, 2.8110894492E+01, 4.1496870675E+00, 9.8268486327E-01],
	[4.61100E+04, 4.4677769047E+01, 5.4638756950E+00, 2.8120946848E+01, 4.1500070570E+00, 9.8269281130E-01],
	[4.61150E+04, 4.4686367483E+01, 5.4639221624E+00, 2.8131001707E+01, 4.1503269685E+00, 9.8270075532E-01],
	[4.61200E+04, 4.4694966640E+01, 5.4639686251E+00, 2.8141059071E+01, 4.1506468018E+00, 9.8270869533E-01],
	[4.61250E+04, 4.4703566520E+01, 5.4640150832E+00, 2.8151118939E+01, 4.1509665570E+00, 9.8271663135E-01],
	[4.61300E+04, 4.4712167122E+01, 5.4640615366E+00, 2.8161181313E+01, 4.1512862341E+00, 9.8272456337E-01],
	[4.61350E+04, 4.4720768447E+01, 5.4641079855E+00, 2.8171246192E+01, 4.1516058331E+00, 9.8273249139E-01],
	[4.61400E+04, 4.4729370493E+01, 5.4641544296E+00, 2.8181313578E+01, 4.1519253541E+00, 9.8274041542E-01],
	[4.61450E+04, 4.4737973262E+01, 5.4642008691E+00, 2.8191383469E+01, 4.1522447971E+00, 9.8274833546E-01],
	[4.61500E+04, 4.4746576753E+01, 5.4642473040E+00, 2.8201455867E+01, 4.1525641621E+00, 9.8275625150E-01],
	[4.61550E+04, 4.4755180966E+01, 5.4642937343E+00, 2.8211530772E+01, 4.1528834491E+00, 9.8276416356E-01],
	[4.61600E+04, 4.4763785902E+01, 5.4643401599E+00, 2.8221608184E+01, 4.1532026582E+00, 9.8277207163E-01],
	[4.61650E+04, 4.4772391559E+01, 5.4643865809E+00, 2.8231688104E+01, 4.1535217893E+00, 9.8277997572E-01],
	[4.61700E+04, 4.4780997939E+01, 5.4644329973E+00, 2.8241770532E+01, 4.1538408425E+00, 9.8278787582E-01],
	[4.61750E+04, 4.4789605041E+01, 5.4644794090E+00, 2.8251855468E+01, 4.1541598178E+00, 9.8279577195E-01],
	[4.61800E+04, 4.4798212865E+01, 5.4645258161E+00, 2.8261942913E+01, 4.1544787153E+00, 9.8280366410E-01],
	[4.61850E+04, 4.4806821410E+01, 5.4645722185E+00, 2.8272032867E+01, 4.1547975349E+00, 9.8281155227E-01],
	[4.61900E+04, 4.4815430678E+01, 5.4646186164E+00, 2.8282125331E+01, 4.1551162766E+00, 9.8281943647E-01],
	[4.61950E+04, 4.4824040669E+01, 5.4646650096E+00, 2.8292220304E+01, 4.1554349406E+00, 9.8282731670E-01],
	[4.62000E+04, 4.4832651381E+01, 5.4647113981E+00, 2.8302317787E+01, 4.1557535267E+00, 9.8283519296E-01],
	[4.62050E+04, 4.4841262815E+01, 5.4647577821E+00, 2.8312417781E+01, 4.1560720351E+00, 9.8284306525E-01],
	[4.62100E+04, 4.4849874971E+01, 5.4648041614E+00, 2.8322520285E+01, 4.1563904657E+00, 9.8285093357E-01],
	[4.62150E+04, 4.4858487849E+01, 5.4648505361E+00, 2.8332625301E+01, 4.1567088186E+00, 9.8285879793E-01],
	[4.62200E+04, 4.4867101449E+01, 5.4648969062E+00, 2.8342732828E+01, 4.1570270938E+00, 9.8286665834E-01],
	[4.62250E+04, 4.4875715771E+01, 5.4649432716E+00, 2.8352842867E+01, 4.1573452913E+00, 9.8287451478E-01],
	[4.62300E+04, 4.4884330815E+01, 5.4649896325E+00, 2.8362955418E+01, 4.1576634112E+00, 9.8288236726E-01],
	[4.62350E+04, 4.4892946580E+01, 5.4650359887E+00, 2.8373070482E+01, 4.1579814534E+00, 9.8289021579E-01],
	[4.62400E+04, 4.4901563068E+01, 5.4650823403E+00, 2.8383188059E+01, 4.1582994180E+00, 9.8289806037E-01],
	[4.62450E+04, 4.4910180278E+01, 5.4651286872E+00, 2.8393308149E+01, 4.1586173049E+00, 9.8290590100E-01],
	[4.62500E+04, 4.4918798209E+01, 5.4651750296E+00, 2.8403430753E+01, 4.1589351143E+00, 9.8291373768E-01],
	[4.62550E+04, 4.4927416862E+01, 5.4652213673E+00, 2.8413555871E+01, 4.1592528462E+00, 9.8292157041E-01],
	[4.62600E+04, 4.4936036237E+01, 5.4652677004E+00, 2.8423683503E+01, 4.1595705004E+00, 9.8292939919E-01],
	[4.62650E+04, 4.4944656334E+01, 5.4653140289E+00, 2.8433813649E+01, 4.1598880772E+00, 9.8293722404E-01],
	[4.62700E+04, 4.4953277152E+01, 5.4653603528E+00, 2.8443946311E+01, 4.1602055765E+00, 9.8294504494E-01],
	[4.62750E+04, 4.4961898693E+01, 5.4654066721E+00, 2.8454081488E+01, 4.1605229983E+00, 9.8295286191E-01],
	[4.62800E+04, 4.4970520955E+01, 5.4654529868E+00, 2.8464219181E+01, 4.1608403426E+00, 9.8296067494E-01],
	[4.62850E+04, 4.4979143939E+01, 5.4654992968E+00, 2.8474359390E+01, 4.1611576095E+00, 9.8296848403E-01],
	[4.62900E+04, 4.4987767644E+01, 5.4655456023E+00, 2.8484502116E+01, 4.1614747990E+00, 9.8297628919E-01],
	[4.62950E+04, 4.4996392071E+01, 5.4655919031E+00, 2.8494647358E+01, 4.1617919111E+00, 9.8298409043E-01],
	[4.63000E+04, 4.5005017220E+01, 5.4656381993E+00, 2.8504795117E+01, 4.1621089458E+00, 9.8299188773E-01],
	[4.63050E+04, 4.5013643091E+01, 5.4656844910E+00, 2.8514945394E+01, 4.1624259032E+00, 9.8299968111E-01],
	[4.63100E+04, 4.5022269683E+01, 5.4657307780E+00, 2.8525098189E+01, 4.1627427832E+00, 9.8300747057E-01],
	[4.63150E+04, 4.5030896997E+01, 5.4657770604E+00, 2.8535253502E+01, 4.1630595859E+00, 9.8301525610E-01],
	[4.63200E+04, 4.5039525032E+01, 5.4658233382E+00, 2.8545411334E+01, 4.1633763113E+00, 9.8302303771E-01],
	[4.63250E+04, 4.5048153789E+01, 5.4658696114E+00, 2.8555571684E+01, 4.1636929595E+00, 9.8303081541E-01],
	[4.63300E+04, 4.5056783268E+01, 5.4659158800E+00, 2.8565734554E+01, 4.1640095304E+00, 9.8303858919E-01],
	[4.63350E+04, 4.5065413468E+01, 5.4659621440E+00, 2.8575899943E+01, 4.1643260241E+00, 9.8304635905E-01],
	[4.63400E+04, 4.5074044389E+01, 5.4660084034E+00, 2.8586067853E+01, 4.1646424405E+00, 9.8305412501E-01],
	[4.63450E+04, 4.5082676033E+01, 5.4660546582E+00, 2.8596238282E+01, 4.1649587798E+00, 9.8306188705E-01],
	[4.63500E+04, 4.5091308397E+01, 5.4661009084E+00, 2.8606411233E+01, 4.1652750419E+00, 9.8306964519E-01],
	[4.63550E+04, 4.5099941483E+01, 5.4661471540E+00, 2.8616586704E+01, 4.1655912269E+00, 9.8307739942E-01],
	[4.63600E+04, 4.5108575291E+01, 5.4661933950E+00, 2.8626764697E+01, 4.1659073347E+00, 9.8308514975E-01],
	[4.63650E+04, 4.5117209820E+01, 5.4662396314E+00, 2.8636945212E+01, 4.1662233655E+00, 9.8309289618E-01],
	[4.63700E+04, 4.5125845070E+01, 5.4662858632E+00, 2.8647128248E+01, 4.1665393191E+00, 9.8310063871E-01],
	[4.63750E+04, 4.5134481042E+01, 5.4663320904E+00, 2.8657313808E+01, 4.1668551957E+00, 9.8310837734E-01],
	[4.63800E+04, 4.5143117736E+01, 5.4663783131E+00, 2.8667501889E+01, 4.1671709952E+00, 9.8311611208E-01],
	[4.63850E+04, 4.5151755150E+01, 5.4664245311E+00, 2.8677692494E+01, 4.1674867178E+00, 9.8312384292E-01],
	[4.63900E+04, 4.5160393286E+01, 5.4664707445E+00, 2.8687885623E+01, 4.1678023633E+00, 9.8313156987E-01],
	[4.63950E+04, 4.5169032143E+01, 5.4665169534E+00, 2.8698081276E+01, 4.1681179318E+00, 9.8313929294E-01],
	[4.64000E+04, 4.5177671722E+01, 5.4665631577E+00, 2.8708279452E+01, 4.1684334234E+00, 9.8314701212E-01],
	[4.64050E+04, 4.5186312022E+01, 5.4666093573E+00, 2.8718480153E+01, 4.1687488381E+00, 9.8315472741E-01],
	[4.64100E+04, 4.5194953043E+01, 5.4666555524E+00, 2.8728683380E+01, 4.1690641758E+00, 9.8316243882E-01],
	[4.64150E+04, 4.5203594786E+01, 5.4667017429E+00, 2.8738889131E+01, 4.1693794366E+00, 9.8317014635E-01],
	[4.64200E+04, 4.5212237250E+01, 5.4667479288E+00, 2.8749097408E+01, 4.1696946206E+00, 9.8317785000E-01],
	[4.64250E+04, 4.5220880435E+01, 5.4667941102E+00, 2.8759308211E+01, 4.1700097277E+00, 9.8318554977E-01],
	[4.64300E+04, 4.5229524341E+01, 5.4668402869E+00, 2.8769521540E+01, 4.1703247579E+00, 9.8319324567E-01],
	[4.64350E+04, 4.5238168968E+01, 5.4668864591E+00, 2.8779737396E+01, 4.1706397114E+00, 9.8320093770E-01],
	[4.64400E+04, 4.5246814317E+01, 5.4669326267E+00, 2.8789955779E+01, 4.1709545880E+00, 9.8320862586E-01],
	[4.64450E+04, 4.5255460387E+01, 5.4669787897E+00, 2.8800176690E+01, 4.1712693879E+00, 9.8321631014E-01],
	[4.64500E+04, 4.5264107178E+01, 5.4670249481E+00, 2.8810400128E+01, 4.1715841110E+00, 9.8322399057E-01],
	[4.64550E+04, 4.5272754690E+01, 5.4670711020E+00, 2.8820626094E+01, 4.1718987574E+00, 9.8323166712E-01],
	[4.64600E+04, 4.5281402923E+01, 5.4671172512E+00, 2.8830854589E+01, 4.1722133271E+00, 9.8323933982E-01],
	[4.64650E+04, 4.5290051877E+01, 5.4671633959E+00, 2.8841085612E+01, 4.1725278201E+00, 9.8324700866E-01],
	[4.64700E+04, 4.5298701552E+01, 5.4672095360E+00, 2.8851319165E+01, 4.1728422364E+00, 9.8325467363E-01],
	[4.64750E+04, 4.5307351949E+01, 5.4672556716E+00, 2.8861555247E+01, 4.1731565761E+00, 9.8326233476E-01],
	[4.64800E+04, 4.5316003066E+01, 5.4673018026E+00, 2.8871793859E+01, 4.1734708391E+00, 9.8326999202E-01],
	[4.64850E+04, 4.5324654905E+01, 5.4673479289E+00, 2.8882035002E+01, 4.1737850256E+00, 9.8327764544E-01],
	[4.64900E+04, 4.5333307464E+01, 5.4673940508E+00, 2.8892278674E+01, 4.1740991354E+00, 9.8328529501E-01],
	[4.64950E+04, 4.5341960745E+01, 5.4674401680E+00, 2.8902524878E+01, 4.1744131687E+00, 9.8329294072E-01],
	[4.65000E+04, 4.5350614746E+01, 5.4674862807E+00, 2.8912773613E+01, 4.1747271254E+00, 9.8330058260E-01],
	[4.65050E+04, 4.5359269468E+01, 5.4675323888E+00, 2.8923024880E+01, 4.1750410056E+00, 9.8330822062E-01],
	[4.65100E+04, 4.5367924912E+01, 5.4675784924E+00, 2.8933278678E+01, 4.1753548094E+00, 9.8331585481E-01],
	[4.65150E+04, 4.5376581076E+01, 5.4676245913E+00, 2.8943535009E+01, 4.1756685366E+00, 9.8332348516E-01],
	[4.65200E+04, 4.5385237961E+01, 5.4676706857E+00, 2.8953793873E+01, 4.1759821873E+00, 9.8333111167E-01],
	[4.65250E+04, 4.5393895567E+01, 5.4677167756E+00, 2.8964055270E+01, 4.1762957616E+00, 9.8333873434E-01],
	[4.65300E+04, 4.5402553894E+01, 5.4677628609E+00, 2.8974319200E+01, 4.1766092595E+00, 9.8334635319E-01],
	[4.65350E+04, 4.5411212942E+01, 5.4678089416E+00, 2.8984585663E+01, 4.1769226810E+00, 9.8335396820E-01],
	[4.65400E+04, 4.5419872710E+01, 5.4678550177E+00, 2.8994854661E+01, 4.1772360261E+00, 9.8336157938E-01],
	[4.65450E+04, 4.5428533200E+01, 5.4679010893E+00, 2.9005126194E+01, 4.1775492949E+00, 9.8336918673E-01],
	[4.65500E+04, 4.5437194410E+01, 5.4679471564E+00, 2.9015400261E+01, 4.1778624873E+00, 9.8337679026E-01],
	[4.65550E+04, 4.5445856341E+01, 5.4679932188E+00, 2.9025676863E+01, 4.1781756034E+00, 9.8338438996E-01],
	[4.65600E+04, 4.5454518993E+01, 5.4680392768E+00, 2.9035956001E+01, 4.1784886432E+00, 9.8339198585E-01],
	[4.65650E+04, 4.5463182365E+01, 5.4680853301E+00, 2.9046237675E+01, 4.1788016067E+00, 9.8339957791E-01],
	[4.65700E+04, 4.5471846458E+01, 5.4681313789E+00, 2.9056521884E+01, 4.1791144940E+00, 9.8340716616E-01],
	[4.65750E+04, 4.5480511272E+01, 5.4681774231E+00, 2.9066808631E+01, 4.1794273050E+00, 9.8341475059E-01],
	[4.65800E+04, 4.5489176807E+01, 5.4682234628E+00, 2.9077097914E+01, 4.1797400398E+00, 9.8342233121E-01],
	[4.65850E+04, 4.5497843062E+01, 5.4682694980E+00, 2.9087389735E+01, 4.1800526984E+00, 9.8342990802E-01],
	[4.65900E+04, 4.5506510038E+01, 5.4683155285E+00, 2.9097684093E+01, 4.1803652808E+00, 9.8343748102E-01],
	[4.65950E+04, 4.5515177735E+01, 5.4683615546E+00, 2.9107980989E+01, 4.1806777871E+00, 9.8344505021E-01],
	[4.66000E+04, 4.5523846152E+01, 5.4684075761E+00, 2.9118280424E+01, 4.1809902172E+00, 9.8345261560E-01],
	[4.66050E+04, 4.5532515290E+01, 5.4684535930E+00, 2.9128582397E+01, 4.1813025713E+00, 9.8346017718E-01],
	[4.66100E+04, 4.5541185148E+01, 5.4684996054E+00, 2.9138886910E+01, 4.1816148492E+00, 9.8346773496E-01],
	[4.66150E+04, 4.5549855727E+01, 5.4685456132E+00, 2.9149193961E+01, 4.1819270511E+00, 9.8347528895E-01],
	[4.66200E+04, 4.5558527027E+01, 5.4685916165E+00, 2.9159503553E+01, 4.1822391769E+00, 9.8348283914E-01],
	[4.66250E+04, 4.5567199047E+01, 5.4686376152E+00, 2.9169815684E+01, 4.1825512267E+00, 9.8349038553E-01],
	[4.66300E+04, 4.5575871787E+01, 5.4686836094E+00, 2.9180130356E+01, 4.1828632005E+00, 9.8349792813E-01],
	[4.66350E+04, 4.5584545249E+01, 5.4687295990E+00, 2.9190447569E+01, 4.1831750982E+00, 9.8350546694E-01],
	[4.66400E+04, 4.5593219430E+01, 5.4687755841E+00, 2.9200767323E+01, 4.1834869201E+00, 9.8351300197E-01],
	[4.66450E+04, 4.5601894332E+01, 5.4688215647E+00, 2.9211089619E+01, 4.1837986659E+00, 9.8352053320E-01],
	[4.66500E+04, 4.5610569955E+01, 5.4688675407E+00, 2.9221414456E+01, 4.1841103359E+00, 9.8352806065E-01],
	[4.66550E+04, 4.5619246298E+01, 5.4689135122E+00, 2.9231741836E+01, 4.1844219299E+00, 9.8353558432E-01],
	[4.66600E+04, 4.5627923361E+01, 5.4689594791E+00, 2.9242071758E+01, 4.1847334480E+00, 9.8354310421E-01],
	[4.66650E+04, 4.5636601145E+01, 5.4690054415E+00, 2.9252404223E+01, 4.1850448903E+00, 9.8355062032E-01],
	[4.66700E+04, 4.5645279649E+01, 5.4690513993E+00, 2.9262739231E+01, 4.1853562567E+00, 9.8355813266E-01],
	[4.66750E+04, 4.5653958873E+01, 5.4690973527E+00, 2.9273076783E+01, 4.1856675473E+00, 9.8356564121E-01],
	[4.66800E+04, 4.5662638818E+01, 5.4691433014E+00, 2.9283416879E+01, 4.1859787621E+00, 9.8357314600E-01],
	[4.66850E+04, 4.5671319483E+01, 5.4691892457E+00, 2.9293759519E+01, 4.1862899011E+00, 9.8358064702E-01],
	[4.66900E+04, 4.5680000869E+01, 5.4692351854E+00, 2.9304104704E+01, 4.1866009644E+00, 9.8358814427E-01],
	[4.66950E+04, 4.5688682975E+01, 5.4692811206E+00, 2.9314452435E+01, 4.1869119519E+00, 9.8359563775E-01],
	[4.67000E+04, 4.5697365801E+01, 5.4693270512E+00, 2.9324802710E+01, 4.1872228637E+00, 9.8360312747E-01],
	[4.67050E+04, 4.5706049347E+01, 5.4693729773E+00, 2.9335155531E+01, 4.1875336998E+00, 9.8361061342E-01],
	[4.67100E+04, 4.5714733613E+01, 5.4694188989E+00, 2.9345510899E+01, 4.1878444602E+00, 9.8361809562E-01],
	[4.67150E+04, 4.5723418600E+01, 5.4694648160E+00, 2.9355868812E+01, 4.1881551449E+00, 9.8362557406E-01],
	[4.67200E+04, 4.5732104307E+01, 5.4695107285E+00, 2.9366229273E+01, 4.1884657540E+00, 9.8363304874E-01],
	[4.67250E+04, 4.5740790734E+01, 5.4695566365E+00, 2.9376592281E+01, 4.1887762875E+00, 9.8364051967E-01],
	[4.67300E+04, 4.5749477882E+01, 5.4696025400E+00, 2.9386957836E+01, 4.1890867454E+00, 9.8364798685E-01],
	[4.67350E+04, 4.5758165749E+01, 5.4696484389E+00, 2.9397325939E+01, 4.1893971277E+00, 9.8365545027E-01],
	[4.67400E+04, 4.5766854337E+01, 5.4696943333E+00, 2.9407696591E+01, 4.1897074344E+00, 9.8366290995E-01],
	[4.67450E+04, 4.5775543644E+01, 5.4697402232E+00, 2.9418069791E+01, 4.1900176656E+00, 9.8367036588E-01],
	[4.67500E+04, 4.5784233672E+01, 5.4697861086E+00, 2.9428445540E+01, 4.1903278213E+00, 9.8367781807E-01],
	[4.67550E+04, 4.5792924420E+01, 5.4698319894E+00, 2.9438823838E+01, 4.1906379015E+00, 9.8368526652E-01],
	[4.67600E+04, 4.5801615888E+01, 5.4698778658E+00, 2.9449204686E+01, 4.1909479062E+00, 9.8369271123E-01],
	[4.67650E+04, 4.5810308076E+01, 5.4699237376E+00, 2.9459588084E+01, 4.1912578354E+00, 9.8370015219E-01],
	[4.67700E+04, 4.5819000984E+01, 5.4699696049E+00, 2.9469974032E+01, 4.1915676892E+00, 9.8370758943E-01],
	[4.67750E+04, 4.5827694612E+01, 5.4700154676E+00, 2.9480362531E+01, 4.1918774676E+00, 9.8371502293E-01],
	[4.67800E+04, 4.5836388961E+01, 5.4700613259E+00, 2.9490753581E+01, 4.1921871706E+00, 9.8372245270E-01],
	[4.67850E+04, 4.5845084029E+01, 5.4701071796E+00, 2.9501147182E+01, 4.1924967983E+00, 9.8372987873E-01],
	[4.67900E+04, 4.5853779817E+01, 5.4701530288E+00, 2.9511543335E+01, 4.1928063505E+00, 9.8373730104E-01],
	[4.67950E+04, 4.5862476325E+01, 5.4701988735E+00, 2.9521942041E+01, 4.1931158275E+00, 9.8374471963E-01],
	[4.68000E+04, 4.5871173553E+01, 5.4702447137E+00, 2.9532343298E+01, 4.1934252291E+00, 9.8375213449E-01],
	[4.68050E+04, 4.5879871500E+01, 5.4702905494E+00, 2.9542747109E+01, 4.1937345554E+00, 9.8375954563E-01],
	[4.68100E+04, 4.5888570168E+01, 5.4703363806E+00, 2.9553153473E+01, 4.1940438065E+00, 9.8376695305E-01],
	[4.68150E+04, 4.5897269556E+01, 5.4703822072E+00, 2.9563562390E+01, 4.1943529823E+00, 9.8377435675E-01],
	[4.68200E+04, 4.5905969663E+01, 5.4704280294E+00, 2.9573973861E+01, 4.1946620829E+00, 9.8378175674E-01],
	[4.68250E+04, 4.5914670490E+01, 5.4704738470E+00, 2.9584387887E+01, 4.1949711082E+00, 9.8378915301E-01],
	[4.68300E+04, 4.5923372038E+01, 5.4705196601E+00, 2.9594804467E+01, 4.1952800584E+00, 9.8379654557E-01],
	[4.68350E+04, 4.5932074305E+01, 5.4705654687E+00, 2.9605223602E+01, 4.1955889334E+00, 9.8380393443E-01],
	[4.68400E+04, 4.5940777291E+01, 5.4706112728E+00, 2.9615645292E+01, 4.1958977333E+00, 9.8381131957E-01],
	[4.68450E+04, 4.5949480998E+01, 5.4706570724E+00, 2.9626069538E+01, 4.1962064580E+00, 9.8381870101E-01],
	[4.68500E+04, 4.5958185424E+01, 5.4707028675E+00, 2.9636496340E+01, 4.1965151076E+00, 9.8382607874E-01],
	[4.68550E+04, 4.5966890570E+01, 5.4707486581E+00, 2.9646925698E+01, 4.1968236821E+00, 9.8383345278E-01],
	[4.68600E+04, 4.5975596436E+01, 5.4707944442E+00, 2.9657357613E+01, 4.1971321816E+00, 9.8384082311E-01],
	[4.68650E+04, 4.5984303021E+01, 5.4708402258E+00, 2.9667792086E+01, 4.1974406060E+00, 9.8384818975E-01],
	[4.68700E+04, 4.5993010326E+01, 5.4708860029E+00, 2.9678229115E+01, 4.1977489554E+00, 9.8385555269E-01],
	[4.68750E+04, 4.6001718351E+01, 5.4709317755E+00, 2.9688668702E+01, 4.1980572298E+00, 9.8386291194E-01],
	[4.68800E+04, 4.6010427095E+01, 5.4709775436E+00, 2.9699110848E+01, 4.1983654292E+00, 9.8387026750E-01],
	[4.68850E+04, 4.6019136559E+01, 5.4710233072E+00, 2.9709555552E+01, 4.1986735536E+00, 9.8387761937E-01],
	[4.68900E+04, 4.6027846743E+01, 5.4710690663E+00, 2.9720002815E+01, 4.1989816031E+00, 9.8388496755E-01],
	[4.68950E+04, 4.6036557646E+01, 5.4711148209E+00, 2.9730452637E+01, 4.1992895776E+00, 9.8389231204E-01],
	[4.69000E+04, 4.6045269269E+01, 5.4711605710E+00, 2.9740905018E+01, 4.1995974773E+00, 9.8389965285E-01],
	[4.69050E+04, 4.6053981612E+01, 5.4712063166E+00, 2.9751359960E+01, 4.1999053020E+00, 9.8390698998E-01],
	[4.69100E+04, 4.6062694674E+01, 5.4712520577E+00, 2.9761817461E+01, 4.2002130519E+00, 9.8391432343E-01],
	[4.69150E+04, 4.6071408455E+01, 5.4712977943E+00, 2.9772277524E+01, 4.2005207270E+00, 9.8392165321E-01],
	[4.69200E+04, 4.6080122956E+01, 5.4713435264E+00, 2.9782740147E+01, 4.2008283272E+00, 9.8392897931E-01],
	[4.69250E+04, 4.6088838177E+01, 5.4713892541E+00, 2.9793205332E+01, 4.2011358526E+00, 9.8393630173E-01],
	[4.69300E+04, 4.6097554117E+01, 5.4714349772E+00, 2.9803673078E+01, 4.2014433033E+00, 9.8394362048E-01],
	[4.69350E+04, 4.6106270776E+01, 5.4714806959E+00, 2.9814143386E+01, 4.2017506791E+00, 9.8395093557E-01],
	[4.69400E+04, 4.6114988155E+01, 5.4715264101E+00, 2.9824616257E+01, 4.2020579803E+00, 9.8395824698E-01],
	[4.69450E+04, 4.6123737920E+01, 5.4715756923E+00, 2.9835091690E+01, 4.2023675769E+00, 9.8396555474E-01],
	[4.69500E+04, 4.6132496722E+01, 5.4716259069E+00, 2.9845569687E+01, 4.2026777210E+00, 9.8397285882E-01],
	[4.69550E+04, 4.6141256255E+01, 5.4716761166E+00, 2.9856050247E+01, 4.2029877909E+00, 9.8398015925E-01],
	[4.69600E+04, 4.6150016517E+01, 5.4717263214E+00, 2.9866533371E+01, 4.2032977864E+00, 9.8398745602E-01],
	[4.69650E+04, 4.6158777510E+01, 5.4717765213E+00, 2.9877019059E+01, 4.2036077077E+00, 9.8399474913E-01],
	[4.69700E+04, 4.6167539234E+01, 5.4718267164E+00, 2.9887507311E+01, 4.2039175547E+00, 9.8400203858E-01],
	[4.69750E+04, 4.6176301687E+01, 5.4718769066E+00, 2.9897998128E+01, 4.2042273276E+00, 9.8400932439E-01],
	[4.69800E+04, 4.6185064870E+01, 5.4719270919E+00, 2.9908491511E+01, 4.2045370262E+00, 9.8401660654E-01],
	[4.69850E+04, 4.6193828784E+01, 5.4719772723E+00, 2.9918987459E+01, 4.2048466507E+00, 9.8402388504E-01],
	[4.69900E+04, 4.6202593428E+01, 5.4720274478E+00, 2.9929485973E+01, 4.2051562010E+00, 9.8403115989E-01],
	[4.69950E+04, 4.6211358802E+01, 5.4720776185E+00, 2.9939987053E+01, 4.2054656772E+00, 9.8403843110E-01],
	[4.70000E+04, 4.6220124906E+01, 5.4721277842E+00, 2.9950490700E+01, 4.2057750793E+00, 9.8404569867E-01],
	[4.70050E+04, 4.6228891741E+01, 5.4721779451E+00, 2.9960996914E+01, 4.2060844073E+00, 9.8405296259E-01],
	[4.70100E+04, 4.6237659305E+01, 5.4722281012E+00, 2.9971505695E+01, 4.2063936612E+00, 9.8406022287E-01],
	[4.70150E+04, 4.6246427599E+01, 5.4722782523E+00, 2.9982017044E+01, 4.2067028411E+00, 9.8406747952E-01],
	[4.70200E+04, 4.6255196624E+01, 5.4723283986E+00, 2.9992530961E+01, 4.2070119469E+00, 9.8407473253E-01],
	[4.70250E+04, 4.6263966379E+01, 5.4723785400E+00, 3.0003047447E+01, 4.2073209787E+00, 9.8408198191E-01],
	[4.70300E+04, 4.6272736863E+01, 5.4724286765E+00, 3.0013566501E+01, 4.2076299365E+00, 9.8408922766E-01],
	[4.70350E+04, 4.6281508078E+01, 5.4724788082E+00, 3.0024088124E+01, 4.2079388204E+00, 9.8409646978E-01],
	[4.70400E+04, 4.6290280022E+01, 5.4725289350E+00, 3.0034612317E+01, 4.2082476302E+00, 9.8410370827E-01],
	[4.70450E+04, 4.6299052697E+01, 5.4725790569E+00, 3.0045139079E+01, 4.2085563662E+00, 9.8411094313E-01],
	[4.70500E+04, 4.6307826102E+01, 5.4726291739E+00, 3.0055668412E+01, 4.2088650283E+00, 9.8411817437E-01],
	[4.70550E+04, 4.6316600236E+01, 5.4726792861E+00, 3.0066200315E+01, 4.2091736164E+00, 9.8412540199E-01],
	[4.70600E+04, 4.6325375101E+01, 5.4727293934E+00, 3.0076734790E+01, 4.2094821307E+00, 9.8413262599E-01],
	[4.70650E+04, 4.6334150695E+01, 5.4727794959E+00, 3.0087271835E+01, 4.2097905711E+00, 9.8413984638E-01],
	[4.70700E+04, 4.6342927019E+01, 5.4728295935E+00, 3.0097811452E+01, 4.2100989377E+00, 9.8414706315E-01],
	[4.70750E+04, 4.6351704073E+01, 5.4728796862E+00, 3.0108353641E+01, 4.2104072305E+00, 9.8415427630E-01],
	[4.70800E+04, 4.6360481857E+01, 5.4729297741E+00, 3.0118898402E+01, 4.2107154495E+00, 9.8416148584E-01],
	[4.70850E+04, 4.6369260371E+01, 5.4729798571E+00, 3.0129445736E+01, 4.2110235947E+00, 9.8416869178E-01],
	[4.70900E+04, 4.6378039615E+01, 5.4730299352E+00, 3.0139995643E+01, 4.2113316661E+00, 9.8417589410E-01],
	[4.70950E+04, 4.6386819588E+01, 5.4730800085E+00, 3.0150548123E+01, 4.2116396639E+00, 9.8418309282E-01],
	[4.71000E+04, 4.6395600291E+01, 5.4731300770E+00, 3.0161103177E+01, 4.2119475879E+00, 9.8419028794E-01],
	[4.71050E+04, 4.6404381724E+01, 5.4731801405E+00, 3.0171660805E+01, 4.2122554382E+00, 9.8419747946E-01],
	[4.71100E+04, 4.6413163887E+01, 5.4732301993E+00, 3.0182221007E+01, 4.2125632148E+00, 9.8420466737E-01],
	[4.71150E+04, 4.6421946780E+01, 5.4732802531E+00, 3.0192783785E+01, 4.2128709178E+00, 9.8421185169E-01],
	[4.71200E+04, 4.6430730402E+01, 5.4733303021E+00, 3.0203349137E+01, 4.2131785472E+00, 9.8421903241E-01],
	[4.71250E+04, 4.6439514754E+01, 5.4733803463E+00, 3.0213917065E+01, 4.2134861029E+00, 9.8422620954E-01],
	[4.71300E+04, 4.6448299836E+01, 5.4734303856E+00, 3.0224487569E+01, 4.2137935851E+00, 9.8423338308E-01],
	[4.71350E+04, 4.6457085647E+01, 5.4734804200E+00, 3.0235060649E+01, 4.2141009937E+00, 9.8424055303E-01],
	[4.71400E+04, 4.6465872188E+01, 5.4735304496E+00, 3.0245636305E+01, 4.2144083287E+00, 9.8424771939E-01],
	[4.71450E+04, 4.6474659459E+01, 5.4735804744E+00, 3.0256214538E+01, 4.2147155902E+00, 9.8425488217E-01],
	[4.71500E+04, 4.6483447459E+01, 5.4736304943E+00, 3.0266795349E+01, 4.2150227782E+00, 9.8426204136E-01],
	[4.71550E+04, 4.6492236189E+01, 5.4736805094E+00, 3.0277378737E+01, 4.2153298926E+00, 9.8426919697E-01],
	[4.71600E+04, 4.6501025648E+01, 5.4737305196E+00, 3.0287964704E+01, 4.2156369336E+00, 9.8427634900E-01],
	[4.71650E+04, 4.6509815837E+01, 5.4737805249E+00, 3.0298553248E+01, 4.2159439012E+00, 9.8428349745E-01],
	[4.71700E+04, 4.6518606756E+01, 5.4738305255E+00, 3.0309144371E+01, 4.2162507953E+00, 9.8429064232E-01],
	[4.71750E+04, 4.6527398404E+01, 5.4738805212E+00, 3.0319738074E+01, 4.2165576160E+00, 9.8429778363E-01],
	[4.71800E+04, 4.6536190782E+01, 5.4739305120E+00, 3.0330334355E+01, 4.2168643633E+00, 9.8430492136E-01],
	[4.71850E+04, 4.6544983889E+01, 5.4739804980E+00, 3.0340933217E+01, 4.2171710373E+00, 9.8431205552E-01],
	[4.71900E+04, 4.6553777726E+01, 5.4740304791E+00, 3.0351534658E+01, 4.2174776378E+00, 9.8431918611E-01],
	[4.71950E+04, 4.6562572292E+01, 5.4740804555E+00, 3.0362138680E+01, 4.2177841651E+00, 9.8432631314E-01],
	[4.72000E+04, 4.6571367587E+01, 5.4741304269E+00, 3.0372745283E+01, 4.2180906190E+00, 9.8433343660E-01],
	[4.72050E+04, 4.6580163612E+01, 5.4741803936E+00, 3.0383354467E+01, 4.2183969997E+00, 9.8434055650E-01],
	[4.72100E+04, 4.6588960367E+01, 5.4742303554E+00, 3.0393966232E+01, 4.2187033070E+00, 9.8434767284E-01],
	[4.72150E+04, 4.6597757851E+01, 5.4742803124E+00, 3.0404580580E+01, 4.2190095411E+00, 9.8435478562E-01],
	[4.72200E+04, 4.6606556064E+01, 5.4743302645E+00, 3.0415197509E+01, 4.2193157020E+00, 9.8436189485E-01],
	[4.72250E+04, 4.6615355007E+01, 5.4743802118E+00, 3.0425817021E+01, 4.2196217897E+00, 9.8436900052E-01],
	[4.72300E+04, 4.6624154679E+01, 5.4744301543E+00, 3.0436439116E+01, 4.2199278041E+00, 9.8437610264E-01],
	[4.72350E+04, 4.6632955080E+01, 5.4744800919E+00, 3.0447063795E+01, 4.2202337454E+00, 9.8438320121E-01],
	[4.72400E+04, 4.6641756211E+01, 5.4745300247E+00, 3.0457691057E+01, 4.2205396135E+00, 9.8439029624E-01],
	[4.72450E+04, 4.6650558071E+01, 5.4745799527E+00, 3.0468320903E+01, 4.2208454085E+00, 9.8439738771E-01],
	[4.72500E+04, 4.6659360660E+01, 5.4746298759E+00, 3.0478953333E+01, 4.2211511304E+00, 9.8440447564E-01],
	[4.72550E+04, 4.6668163978E+01, 5.4746797942E+00, 3.0489588348E+01, 4.2214567792E+00, 9.8441156003E-01],
	[4.72600E+04, 4.6676968026E+01, 5.4747297077E+00, 3.0500225948E+01, 4.2217623549E+00, 9.8441864088E-01],
	[4.72650E+04, 4.6685772803E+01, 5.4747796164E+00, 3.0510866134E+01, 4.2220678575E+00, 9.8442571819E-01],
	[4.72700E+04, 4.6694578309E+01, 5.4748295202E+00, 3.0521508905E+01, 4.2223732871E+00, 9.8443279197E-01],
	[4.72750E+04, 4.6703384545E+01, 5.4748794192E+00, 3.0532154262E+01, 4.2226786437E+00, 9.8443986221E-01],
	[4.72800E+04, 4.6712191509E+01, 5.4749293134E+00, 3.0542802206E+01, 4.2229839273E+00, 9.8444692891E-01],
	[4.72850E+04, 4.6720999203E+01, 5.4749792028E+00, 3.0553452737E+01, 4.2232891379E+00, 9.8445399209E-01],
	[4.72900E+04, 4.6729807626E+01, 5.4750290874E+00, 3.0564105855E+01, 4.2235942756E+00, 9.8446105174E-01],
	[4.72950E+04, 4.6738616778E+01, 5.4750789671E+00, 3.0574761561E+01, 4.2238993403E+00, 9.8446810786E-01],
	[4.73000E+04, 4.6747426660E+01, 5.4751288420E+00, 3.0585419854E+01, 4.2242043321E+00, 9.8447516046E-01],
	[4.73050E+04, 4.6756237270E+01, 5.4751787121E+00, 3.0596080736E+01, 4.2245092510E+00, 9.8448220953E-01],
	[4.73100E+04, 4.6765048609E+01, 5.4752285774E+00, 3.0606744206E+01, 4.2248140971E+00, 9.8448925509E-01],
	[4.73150E+04, 4.6773860678E+01, 5.4752784379E+00, 3.0617410265E+01, 4.2251188702E+00, 9.8449629712E-01],
	[4.73200E+04, 4.6782673475E+01, 5.4753282936E+00, 3.0628078914E+01, 4.2254235706E+00, 9.8450333564E-01],
	[4.73250E+04, 4.6791487002E+01, 5.4753781444E+00, 3.0638750152E+01, 4.2257281981E+00, 9.8451037064E-01],
	[4.73300E+04, 4.6800301258E+01, 5.4754279904E+00, 3.0649423980E+01, 4.2260327528E+00, 9.8451740213E-01],
	[4.73350E+04, 4.6809116242E+01, 5.4754778317E+00, 3.0660100399E+01, 4.2263372347E+00, 9.8452443011E-01],
	[4.73400E+04, 4.6817931956E+01, 5.4755276681E+00, 3.0670779408E+01, 4.2266416439E+00, 9.8453145458E-01],
	[4.73450E+04, 4.6826748398E+01, 5.4755774997E+00, 3.0681461009E+01, 4.2269459803E+00, 9.8453847554E-01],
	[4.73500E+04, 4.6835565570E+01, 5.4756273265E+00, 3.0692145201E+01, 4.2272502440E+00, 9.8454549300E-01],
	[4.73550E+04, 4.6844383470E+01, 5.4756771484E+00, 3.0702831985E+01, 4.2275544351E+00, 9.8455250696E-01],
	[4.73600E+04, 4.6853202100E+01, 5.4757269656E+00, 3.0713521361E+01, 4.2278585534E+00, 9.8455951741E-01],
	[4.73650E+04, 4.6862021458E+01, 5.4757767780E+00, 3.0724213329E+01, 4.2281625991E+00, 9.8456652437E-01],
	[4.73700E+04, 4.6870841545E+01, 5.4758265855E+00, 3.0734907890E+01, 4.2284665721E+00, 9.8457352782E-01],
	[4.73750E+04, 4.6879662361E+01, 5.4758763883E+00, 3.0745605045E+01, 4.2287704725E+00, 9.8458052779E-01],
	[4.73800E+04, 4.6888483906E+01, 5.4759261863E+00, 3.0756304793E+01, 4.2290743003E+00, 9.8458752425E-01],
	[4.73850E+04, 4.6897306180E+01, 5.4759759794E+00, 3.0767007135E+01, 4.2293780556E+00, 9.8459451723E-01],
	[4.73900E+04, 4.6906129183E+01, 5.4760257678E+00, 3.0777712072E+01, 4.2296817382E+00, 9.8460150672E-01],
	[4.73950E+04, 4.6914952914E+01, 5.4760755513E+00, 3.0788419603E+01, 4.2299853484E+00, 9.8460849272E-01],
	[4.74000E+04, 4.6923777374E+01, 5.4761253301E+00, 3.0799129729E+01, 4.2302888860E+00, 9.8461547523E-01],
	[4.74050E+04, 4.6932602563E+01, 5.4761751040E+00, 3.0809842450E+01, 4.2305923511E+00, 9.8462245426E-01],
	[4.74100E+04, 4.6941428481E+01, 5.4762248732E+00, 3.0820557767E+01, 4.2308957437E+00, 9.8462942981E-01],
	[4.74150E+04, 4.6950255127E+01, 5.4762746375E+00, 3.0831275680E+01, 4.2311990639E+00, 9.8463640188E-01],
	[4.74200E+04, 4.6959082503E+01, 5.4763243971E+00, 3.0841996190E+01, 4.2315023116E+00, 9.8464337047E-01],
	[4.74250E+04, 4.6967910606E+01, 5.4763741519E+00, 3.0852719296E+01, 4.2318054869E+00, 9.8465033559E-01],
	[4.74300E+04, 4.6976739439E+01, 5.4764239019E+00, 3.0863445000E+01, 4.2321085897E+00, 9.8465729723E-01],
	[4.74350E+04, 4.6985569000E+01, 5.4764736471E+00, 3.0874173301E+01, 4.2324116203E+00, 9.8466425540E-01],
	[4.74400E+04, 4.6994399290E+01, 5.4765233874E+00, 3.0884904199E+01, 4.2327145784E+00, 9.8467121010E-01],
	[4.74450E+04, 4.7003230309E+01, 5.4765731231E+00, 3.0895637696E+01, 4.2330174642E+00, 9.8467816132E-01],
	[4.74500E+04, 4.7012062056E+01, 5.4766228539E+00, 3.0906373792E+01, 4.2333202777E+00, 9.8468510909E-01],
	[4.74550E+04, 4.7020894531E+01, 5.4766725799E+00, 3.0917112486E+01, 4.2336230188E+00, 9.8469205338E-01],
	[4.74600E+04, 4.7029727736E+01, 5.4767223011E+00, 3.0927853780E+01, 4.2339256877E+00, 9.8469899422E-01],
	[4.74650E+04, 4.7038561669E+01, 5.4767720176E+00, 3.0938597673E+01, 4.2342282843E+00, 9.8470593159E-01],
	[4.74700E+04, 4.7047396330E+01, 5.4768217293E+00, 3.0949344167E+01, 4.2345308087E+00, 9.8471286550E-01],
	[4.74750E+04, 4.7056231720E+01, 5.4768714361E+00, 3.0960093260E+01, 4.2348332608E+00, 9.8471979595E-01],
	[4.74800E+04, 4.7065067839E+01, 5.4769211382E+00, 3.0970844955E+01, 4.2351356408E+00, 9.8472672294E-01],
	[4.74850E+04, 4.7073904686E+01, 5.4769708355E+00, 3.0981599250E+01, 4.2354379485E+00, 9.8473364648E-01],
	[4.74900E+04, 4.7082742261E+01, 5.4770205281E+00, 3.0992356147E+01, 4.2357401841E+00, 9.8474056657E-01],
	[4.74950E+04, 4.7091580565E+01, 5.4770702158E+00, 3.1003115645E+01, 4.2360423475E+00, 9.8474748321E-01],
	[4.75000E+04, 4.7100419598E+01, 5.4771198988E+00, 3.1013877746E+01, 4.2363444388E+00, 9.8475439639E-01],
	[4.75050E+04, 4.7109259358E+01, 5.4771695770E+00, 3.1024642449E+01, 4.2366464580E+00, 9.8476130613E-01],
	[4.75100E+04, 4.7118099848E+01, 5.4772192504E+00, 3.1035409755E+01, 4.2369484051E+00, 9.8476821242E-01],
	[4.75150E+04, 4.7126941065E+01, 5.4772689191E+00, 3.1046179664E+01, 4.2372502802E+00, 9.8477511527E-01],
	[4.75200E+04, 4.7135783012E+01, 5.4773185829E+00, 3.1056952177E+01, 4.2375520832E+00, 9.8478201467E-01],
	[4.75250E+04, 4.7144625686E+01, 5.4773682420E+00, 3.1067727293E+01, 4.2378538141E+00, 9.8478891064E-01],
	[4.75300E+04, 4.7153469089E+01, 5.4774178963E+00, 3.1078505014E+01, 4.2381554731E+00, 9.8479580316E-01],
	[4.75350E+04, 4.7162313220E+01, 5.4774675459E+00, 3.1089285339E+01, 4.2384570600E+00, 9.8480269225E-01],
	[4.75400E+04, 4.7171158079E+01, 5.4775171906E+00, 3.1100068270E+01, 4.2387585750E+00, 9.8480957790E-01],
	[4.75450E+04, 4.7180003667E+01, 5.4775668306E+00, 3.1110853805E+01, 4.2390600181E+00, 9.8481646011E-01],
	[4.75500E+04, 4.7188849983E+01, 5.4776164659E+00, 3.1121641946E+01, 4.2393613892E+00, 9.8482333890E-01],
	[4.75550E+04, 4.7197697028E+01, 5.4776660963E+00, 3.1132432694E+01, 4.2396626884E+00, 9.8483021425E-01],
	[4.75600E+04, 4.7206544800E+01, 5.4777157220E+00, 3.1143226047E+01, 4.2399639157E+00, 9.8483708617E-01],
	[4.75650E+04, 4.7215393301E+01, 5.4777653429E+00, 3.1154022008E+01, 4.2402650711E+00, 9.8484395467E-01],
	[4.75700E+04, 4.7224242530E+01, 5.4778149591E+00, 3.1164820575E+01, 4.2405661547E+00, 9.8485081974E-01],
	[4.75750E+04, 4.7233092487E+01, 5.4778645705E+00, 3.1175621750E+01, 4.2408671664E+00, 9.8485768139E-01],
	[4.75800E+04, 4.7241943173E+01, 5.4779141771E+00, 3.1186425532E+01, 4.2411681064E+00, 9.8486453961E-01],
	[4.75850E+04, 4.7250794586E+01, 5.4779637790E+00, 3.1197231923E+01, 4.2414689745E+00, 9.8487139442E-01],
	[4.75900E+04, 4.7259646728E+01, 5.4780133761E+00, 3.1208040923E+01, 4.2417697709E+00, 9.8487824581E-01],
	[4.75950E+04, 4.7268499598E+01, 5.4780629684E+00, 3.1218852531E+01, 4.2420704955E+00, 9.8488509378E-01],
	[4.76000E+04, 4.7277353196E+01, 5.4781125560E+00, 3.1229666748E+01, 4.2423711484E+00, 9.8489193833E-01],
	[4.76050E+04, 4.7286207522E+01, 5.4781621388E+00, 3.1240483575E+01, 4.2426717295E+00, 9.8489877947E-01],
	[4.76100E+04, 4.7295062577E+01, 5.4782117169E+00, 3.1251303012E+01, 4.2429722390E+00, 9.8490561721E-01],
	[4.76150E+04, 4.7303918359E+01, 5.4782612902E+00, 3.1262125059E+01, 4.2432726768E+00, 9.8491245153E-01],
	[4.76200E+04, 4.7312774869E+01, 5.4783108587E+00, 3.1272949717E+01, 4.2435730429E+00, 9.8491928244E-01],
	[4.76250E+04, 4.7321632108E+01, 5.4783604225E+00, 3.1283776986E+01, 4.2438733374E+00, 9.8492610995E-01],
	[4.76300E+04, 4.7330490074E+01, 5.4784099815E+00, 3.1294606866E+01, 4.2441735603E+00, 9.8493293405E-01],
	[4.76350E+04, 4.7339348769E+01, 5.4784595358E+00, 3.1305439357E+01, 4.2444737116E+00, 9.8493975475E-01],
	[4.76400E+04, 4.7348208191E+01, 5.4785090853E+00, 3.1316274461E+01, 4.2447737913E+00, 9.8494657204E-01],
	[4.76450E+04, 4.7357068341E+01, 5.4785586301E+00, 3.1327112178E+01, 4.2450737994E+00, 9.8495338594E-01],
	[4.76500E+04, 4.7365929220E+01, 5.4786081701E+00, 3.1337952507E+01, 4.2453737360E+00, 9.8496019644E-01],
	[4.76550E+04, 4.7374790826E+01, 5.4786577054E+00, 3.1348795449E+01, 4.2456736011E+00, 9.8496700355E-01],
	[4.76600E+04, 4.7383653160E+01, 5.4787072359E+00, 3.1359641005E+01, 4.2459733947E+00, 9.8497380726E-01],
	[4.76650E+04, 4.7392516222E+01, 5.4787567617E+00, 3.1370489174E+01, 4.2462731168E+00, 9.8498060758E-01],
	[4.76700E+04, 4.7401380012E+01, 5.4788062827E+00, 3.1381339958E+01, 4.2465727674E+00, 9.8498740451E-01],
	[4.76750E+04, 4.7410244530E+01, 5.4788557990E+00, 3.1392193356E+01, 4.2468723466E+00, 9.8499419804E-01],
	[4.76800E+04, 4.7419109776E+01, 5.4789053106E+00, 3.1403049369E+01, 4.2471718544E+00, 9.8500098820E-01],
	[4.76850E+04, 4.7427975750E+01, 5.4789548173E+00, 3.1413907998E+01, 4.2474712908E+00, 9.8500777496E-01],
	[4.76900E+04, 4.7436842451E+01, 5.4790043194E+00, 3.1424769242E+01, 4.2477706558E+00, 9.8501455834E-01],
	[4.76950E+04, 4.7445709880E+01, 5.4790538167E+00, 3.1435633102E+01, 4.2480699494E+00, 9.8502133835E-01],
	[4.77000E+04, 4.7454578037E+01, 5.4791033093E+00, 3.1446499578E+01, 4.2483691717E+00, 9.8502811497E-01],
	[4.77050E+04, 4.7463446922E+01, 5.4791527971E+00, 3.1457368671E+01, 4.2486683227E+00, 9.8503488821E-01],
	[4.77100E+04, 4.7472316534E+01, 5.4792022802E+00, 3.1468240381E+01, 4.2489674023E+00, 9.8504165807E-01],
	[4.77150E+04, 4.7481186875E+01, 5.4792517585E+00, 3.1479114708E+01, 4.2492664107E+00, 9.8504842456E-01],
	[4.77200E+04, 4.7490057943E+01, 5.4793012321E+00, 3.1489991654E+01, 4.2495653478E+00, 9.8505518768E-01],
	[4.77250E+04, 4.7498929738E+01, 5.4793507010E+00, 3.1500871217E+01, 4.2498642137E+00, 9.8506194742E-01],
	[4.77300E+04, 4.7507802262E+01, 5.4794001651E+00, 3.1511753399E+01, 4.2501630083E+00, 9.8506870380E-01],
	[4.77350E+04, 4.7516675513E+01, 5.4794496245E+00, 3.1522638199E+01, 4.2504617317E+00, 9.8507545680E-01],
	[4.77400E+04, 4.7525549492E+01, 5.4794990792E+00, 3.1533525619E+01, 4.2507603840E+00, 9.8508220644E-01],
	[4.77450E+04, 4.7534424198E+01, 5.4795485291E+00, 3.1544415658E+01, 4.2510589650E+00, 9.8508895272E-01],
	[4.77500E+04, 4.7543299632E+01, 5.4795979743E+00, 3.1555308317E+01, 4.2513574750E+00, 9.8509569563E-01],
	[4.77550E+04, 4.7552175794E+01, 5.4796474148E+00, 3.1566203597E+01, 4.2516559138E+00, 9.8510243518E-01],
	[4.77600E+04, 4.7561052683E+01, 5.4796968505E+00, 3.1577101497E+01, 4.2519542814E+00, 9.8510917137E-01],
	[4.77650E+04, 4.7569930300E+01, 5.4797462816E+00, 3.1588002018E+01, 4.2522525780E+00, 9.8511590421E-01],
	[4.77700E+04, 4.7578808644E+01, 5.4797957078E+00, 3.1598905160E+01, 4.2525508036E+00, 9.8512263368E-01],
	[4.77750E+04, 4.7587687716E+01, 5.4798451294E+00, 3.1609810924E+01, 4.2528489580E+00, 9.8512935981E-01],
	[4.77800E+04, 4.7596567515E+01, 5.4798945462E+00, 3.1620719310E+01, 4.2531470415E+00, 9.8513608258E-01],
	[4.77850E+04, 4.7605448042E+01, 5.4799439583E+00, 3.1631630318E+01, 4.2534450539E+00, 9.8514280200E-01],
	[4.77900E+04, 4.7614329296E+01, 5.4799933657E+00, 3.1642543949E+01, 4.2537429954E+00, 9.8514951807E-01],
	[4.77950E+04, 4.7623211278E+01, 5.4800427684E+00, 3.1653460203E+01, 4.2540408658E+00, 9.8515623079E-01],
	[4.78000E+04, 4.7632093988E+01, 5.4800921663E+00, 3.1664379081E+01, 4.2543386653E+00, 9.8516294017E-01],
	[4.78050E+04, 4.7640977424E+01, 5.4801415595E+00, 3.1675300582E+01, 4.2546363939E+00, 9.8516964621E-01],
	[4.78100E+04, 4.7649861589E+01, 5.4801909480E+00, 3.1686224707E+01, 4.2549340516E+00, 9.8517634890E-01],
	[4.78150E+04, 4.7658746480E+01, 5.4802403318E+00, 3.1697151457E+01, 4.2552316383E+00, 9.8518304825E-01],
	[4.78200E+04, 4.7667632099E+01, 5.4802897108E+00, 3.1708080832E+01, 4.2555291542E+00, 9.8518974426E-01],
	[4.78250E+04, 4.7676518446E+01, 5.4803390852E+00, 3.1719012832E+01, 4.2558265993E+00, 9.8519643694E-01],
	[4.78300E+04, 4.7685405519E+01, 5.4803884548E+00, 3.1729947458E+01, 4.2561239735E+00, 9.8520312628E-01],
	[4.78350E+04, 4.7694293321E+01, 5.4804378197E+00, 3.1740884710E+01, 4.2564212768E+00, 9.8520981228E-01],
	[4.78400E+04, 4.7703181849E+01, 5.4804871799E+00, 3.1751824588E+01, 4.2567185094E+00, 9.8521649496E-01],
	[4.78450E+04, 4.7712071105E+01, 5.4805365353E+00, 3.1762767092E+01, 4.2570156712E+00, 9.8522317430E-01],
	[4.78500E+04, 4.7720961088E+01, 5.4805858861E+00, 3.1773712224E+01, 4.2573127623E+00, 9.8522985032E-01],
	[4.78550E+04, 4.7729851798E+01, 5.4806352321E+00, 3.1784659983E+01, 4.2576097826E+00, 9.8523652301E-01],
	[4.78600E+04, 4.7738743236E+01, 5.4806845735E+00, 3.1795610369E+01, 4.2579067321E+00, 9.8524319237E-01],
	[4.78650E+04, 4.7747635400E+01, 5.4807339101E+00, 3.1806563384E+01, 4.2582036110E+00, 9.8524985841E-01],
	[4.78700E+04, 4.7756528292E+01, 5.4807832420E+00, 3.1817519027E+01, 4.2585004192E+00, 9.8525652113E-01],
	[4.78750E+04, 4.7765421912E+01, 5.4808325692E+00, 3.1828477299E+01, 4.2587971568E+00, 9.8526318053E-01],
	[4.78800E+04, 4.7774316258E+01, 5.4808818917E+00, 3.1839438200E+01, 4.2590938237E+00, 9.8526983662E-01],
	[4.78850E+04, 4.7783211332E+01, 5.4809312095E+00, 3.1850401731E+01, 4.2593904199E+00, 9.8527648938E-01],
	[4.78900E+04, 4.7792107133E+01, 5.4809805226E+00, 3.1861367891E+01, 4.2596869456E+00, 9.8528313883E-01],
	[4.78950E+04, 4.7801003660E+01, 5.4810298310E+00, 3.1872336682E+01, 4.2599834007E+00, 9.8528978497E-01],
	[4.79000E+04, 4.7809900916E+01, 5.4810791347E+00, 3.1883308103E+01, 4.2602797852E+00, 9.8529642780E-01],
	[4.79050E+04, 4.7818798898E+01, 5.4811284336E+00, 3.1894282155E+01, 4.2605760992E+00, 9.8530306732E-01],
	[4.79100E+04, 4.7827697607E+01, 5.4811777279E+00, 3.1905258838E+01, 4.2608723426E+00, 9.8530970353E-01],
	[4.79150E+04, 4.7836597043E+01, 5.4812270175E+00, 3.1916238153E+01, 4.2611685155E+00, 9.8531633643E-01],
	[4.79200E+04, 4.7845497207E+01, 5.4812763023E+00, 3.1927220100E+01, 4.2614646180E+00, 9.8532296603E-01],
	[4.79250E+04, 4.7854398097E+01, 5.4813255825E+00, 3.1938204680E+01, 4.2617606500E+00, 9.8532959233E-01],
	[4.79300E+04, 4.7863299715E+01, 5.4813748580E+00, 3.1949191892E+01, 4.2620566115E+00, 9.8533621532E-01],
	[4.79350E+04, 4.7872202059E+01, 5.4814241288E+00, 3.1960181737E+01, 4.2623525026E+00, 9.8534283502E-01],
	[4.79400E+04, 4.7881105131E+01, 5.4814733949E+00, 3.1971174215E+01, 4.2626483233E+00, 9.8534945142E-01],
	[4.79450E+04, 4.7890008929E+01, 5.4815226562E+00, 3.1982169328E+01, 4.2629440736E+00, 9.8535606452E-01],
	[4.79500E+04, 4.7898913455E+01, 5.4815719129E+00, 3.1993167074E+01, 4.2632397535E+00, 9.8536267433E-01],
	[4.79550E+04, 4.7907818707E+01, 5.4816211649E+00, 3.2004167455E+01, 4.2635353631E+00, 9.8536928085E-01],
	[4.79600E+04, 4.7916724686E+01, 5.4816704122E+00, 3.2015170471E+01, 4.2638309023E+00, 9.8537588408E-01],
	[4.79650E+04, 4.7925631393E+01, 5.4817196549E+00, 3.2026176122E+01, 4.2641263713E+00, 9.8538248402E-01],
	[4.79700E+04, 4.7934538826E+01, 5.4817688928E+00, 3.2037184408E+01, 4.2644217699E+00, 9.8538908067E-01],
	[4.79750E+04, 4.7943446986E+01, 5.4818181260E+00, 3.2048195331E+01, 4.2647170983E+00, 9.8539567404E-01],
	[4.79800E+04, 4.7952355873E+01, 5.4818673546E+00, 3.2059208889E+01, 4.2650123564E+00, 9.8540226412E-01],
	[4.79850E+04, 4.7961265486E+01, 5.4819165784E+00, 3.2070225085E+01, 4.2653075442E+00, 9.8540885092E-01],
	[4.79900E+04, 4.7970175827E+01, 5.4819657976E+00, 3.2081243917E+01, 4.2656026619E+00, 9.8541543444E-01],
	[4.79950E+04, 4.7979086894E+01, 5.4820150121E+00, 3.2092265386E+01, 4.2658977094E+00, 9.8542201468E-01],
	[4.80000E+04, 4.7987998689E+01, 5.4820642219E+00, 3.2103289494E+01, 4.2661926866E+00, 9.8542859165E-01],
	[4.80050E+04, 4.7996911210E+01, 5.4821134270E+00, 3.2114316239E+01, 4.2664875937E+00, 9.8543516534E-01],
	[4.80100E+04, 4.8005824457E+01, 5.4821626274E+00, 3.2125345623E+01, 4.2667824307E+00, 9.8544173575E-01],
	[4.80150E+04, 4.8014738432E+01, 5.4822118232E+00, 3.2136377645E+01, 4.2670771976E+00, 9.8544830290E-01],
	[4.80200E+04, 4.8023653133E+01, 5.4822610142E+00, 3.2147412307E+01, 4.2673718943E+00, 9.8545486677E-01],
	[4.80250E+04, 4.8032568561E+01, 5.4823102006E+00, 3.2158449608E+01, 4.2676665210E+00, 9.8546142738E-01],
	[4.80300E+04, 4.8041484716E+01, 5.4823593823E+00, 3.2169489549E+01, 4.2679610776E+00, 9.8546798472E-01],
	[4.80350E+04, 4.8050401597E+01, 5.4824085594E+00, 3.2180532130E+01, 4.2682555642E+00, 9.8547453880E-01],
	[4.80400E+04, 4.8059319205E+01, 5.4824577317E+00, 3.2191577352E+01, 4.2685499807E+00, 9.8548108961E-01],
	[4.80450E+04, 4.8068237540E+01, 5.4825068994E+00, 3.2202625214E+01, 4.2688443273E+00, 9.8548763716E-01],
	[4.80500E+04, 4.8077156601E+01, 5.4825560624E+00, 3.2213675718E+01, 4.2691386038E+00, 9.8549418145E-01],
	[4.80550E+04, 4.8086076389E+01, 5.4826052207E+00, 3.2224728863E+01, 4.2694328104E+00, 9.8550072249E-01],
	[4.80600E+04, 4.8094996903E+01, 5.4826543744E+00, 3.2235784651E+01, 4.2697269470E+00, 9.8550726027E-01],
	[4.80650E+04, 4.8103918144E+01, 5.4827035234E+00, 3.2246843080E+01, 4.2700210137E+00, 9.8551379479E-01],
	[4.80700E+04, 4.8112840112E+01, 5.4827526677E+00, 3.2257904153E+01, 4.2703150106E+00, 9.8552032606E-01],
	[4.80750E+04, 4.8121762806E+01, 5.4828018073E+00, 3.2268967868E+01, 4.2706089375E+00, 9.8552685408E-01],
	[4.80800E+04, 4.8130686227E+01, 5.4828509423E+00, 3.2280034227E+01, 4.2709027945E+00, 9.8553337885E-01],
	[4.80850E+04, 4.8139610374E+01, 5.4829000726E+00, 3.2291103229E+01, 4.2711965817E+00, 9.8553990037E-01],
	[4.80900E+04, 4.8148535248E+01, 5.4829491982E+00, 3.2302174876E+01, 4.2714902991E+00, 9.8554641865E-01],
	[4.80950E+04, 4.8157460849E+01, 5.4829983192E+00, 3.2313249167E+01, 4.2717839466E+00, 9.8555293368E-01],
	[4.81000E+04, 4.8166387175E+01, 5.4830474355E+00, 3.2324326103E+01, 4.2720775244E+00, 9.8555944547E-01],
	[4.81050E+04, 4.8175314228E+01, 5.4830965471E+00, 3.2335405684E+01, 4.2723710324E+00, 9.8556595402E-01],
	[4.81100E+04, 4.8184242008E+01, 5.4831456541E+00, 3.2346487911E+01, 4.2726644706E+00, 9.8557245933E-01],
	[4.81150E+04, 4.8193170514E+01, 5.4831947564E+00, 3.2357572783E+01, 4.2729578391E+00, 9.8557896140E-01],
	[4.81200E+04, 4.8202099747E+01, 5.4832438540E+00, 3.2368660302E+01, 4.2732511379E+00, 9.8558546024E-01],
	[4.81250E+04, 4.8211029706E+01, 5.4832929470E+00, 3.2379750468E+01, 4.2735443669E+00, 9.8559195584E-01],
	[4.81300E+04, 4.8219960391E+01, 5.4833420353E+00, 3.2390843280E+01, 4.2738375263E+00, 9.8559844822E-01],
	[4.81350E+04, 4.8228891802E+01, 5.4833911190E+00, 3.2401938740E+01, 4.2741306161E+00, 9.8560493736E-01],
	[4.81400E+04, 4.8237823940E+01, 5.4834401980E+00, 3.2413036847E+01, 4.2744236362E+00, 9.8561142327E-01],
	[4.81450E+04, 4.8246756805E+01, 5.4834892723E+00, 3.2424137602E+01, 4.2747165867E+00, 9.8561790595E-01],
	[4.81500E+04, 4.8255690395E+01, 5.4835383420E+00, 3.2435241006E+01, 4.2750094676E+00, 9.8562438541E-01],
	[4.81550E+04, 4.8264624712E+01, 5.4835874070E+00, 3.2446347059E+01, 4.2753022789E+00, 9.8563086165E-01],
	[4.81600E+04, 4.8273559755E+01, 5.4836364674E+00, 3.2457455760E+01, 4.2755950206E+00, 9.8563733466E-01],
	[4.81650E+04, 4.8282495525E+01, 5.4836855231E+00, 3.2468567111E+01, 4.2758876928E+00, 9.8564380445E-01],
	[4.81700E+04, 4.8291432020E+01, 5.4837345742E+00, 3.2479681112E+01, 4.2761802955E+00, 9.8565027103E-01],
	[4.81750E+04, 4.8300369242E+01, 5.4837836206E+00, 3.2490797763E+01, 4.2764728286E+00, 9.8565673438E-01],
	[4.81800E+04, 4.8309307190E+01, 5.4838326623E+00, 3.2501917065E+01, 4.2767652923E+00, 9.8566319453E-01],
	[4.81850E+04, 4.8318245864E+01, 5.4838816994E+00, 3.2513039017E+01, 4.2770576865E+00, 9.8566965145E-01],
	[4.81900E+04, 4.8327185265E+01, 5.4839307319E+00, 3.2524163621E+01, 4.2773500113E+00, 9.8567610517E-01],
	[4.81950E+04, 4.8336125391E+01, 5.4839797597E+00, 3.2535290876E+01, 4.2776422666E+00, 9.8568255568E-01],
	[4.82000E+04, 4.8345066244E+01, 5.4840287829E+00, 3.2546420783E+01, 4.2779344526E+00, 9.8568900298E-01],
	[4.82050E+04, 4.8354007823E+01, 5.4840778014E+00, 3.2557553343E+01, 4.2782265691E+00, 9.8569544707E-01],
	[4.82100E+04, 4.8362950128E+01, 5.4841268152E+00, 3.2568688555E+01, 4.2785186163E+00, 9.8570188795E-01],
	[4.82150E+04, 4.8371893159E+01, 5.4841758245E+00, 3.2579826420E+01, 4.2788105941E+00, 9.8570832564E-01],
	[4.82200E+04, 4.8380836916E+01, 5.4842248291E+00, 3.2590966939E+01, 4.2791025026E+00, 9.8571476012E-01],
	[4.82250E+04, 4.8389781400E+01, 5.4842738290E+00, 3.2602110111E+01, 4.2793943417E+00, 9.8572119140E-01],
	[4.82300E+04, 4.8398726609E+01, 5.4843228243E+00, 3.2613255938E+01, 4.2796861116E+00, 9.8572761949E-01],
	[4.82350E+04, 4.8407672544E+01, 5.4843718149E+00, 3.2624404419E+01, 4.2799778122E+00, 9.8573404437E-01],
	[4.82400E+04, 4.8416619205E+01, 5.4844208010E+00, 3.2635555554E+01, 4.2802694436E+00, 9.8574046607E-01],
	[4.82450E+04, 4.8425566593E+01, 5.4844697823E+00, 3.2646709345E+01, 4.2805610057E+00, 9.8574688457E-01],
	[4.82500E+04, 4.8434514706E+01, 5.4845187591E+00, 3.2657865792E+01, 4.2808524986E+00, 9.8575329987E-01],
	[4.82550E+04, 4.8443463545E+01, 5.4845677312E+00, 3.2669024894E+01, 4.2811439223E+00, 9.8575971199E-01],
	[4.82600E+04, 4.8452413111E+01, 5.4846166986E+00, 3.2680186653E+01, 4.2814352768E+00, 9.8576612092E-01],
	[4.82650E+04, 4.8461363402E+01, 5.4846656614E+00, 3.2691351068E+01, 4.2817265621E+00, 9.8577252667E-01],
	[4.82700E+04, 4.8470314419E+01, 5.4847146196E+00, 3.2702518140E+01, 4.2820177783E+00, 9.8577892923E-01],
	[4.82750E+04, 4.8479266162E+01, 5.4847635732E+00, 3.2713687869E+01, 4.2823089254E+00, 9.8578532860E-01],
	[4.82800E+04, 4.8488218631E+01, 5.4848125221E+00, 3.2724860256E+01, 4.2826000034E+00, 9.8579172480E-01],
	[4.82850E+04, 4.8497171825E+01, 5.4848614664E+00, 3.2736035301E+01, 4.2828910123E+00, 9.8579811781E-01],
	[4.82900E+04, 4.8506125746E+01, 5.4849104060E+00, 3.2747213005E+01, 4.2831819522E+00, 9.8580450765E-01],
	[4.82950E+04, 4.8515080392E+01, 5.4849593411E+00, 3.2758393367E+01, 4.2834728230E+00, 9.8581089431E-01],
	[4.83000E+04, 4.8524035764E+01, 5.4850082715E+00, 3.2769576388E+01, 4.2837636247E+00, 9.8581727780E-01],
	[4.83050E+04, 4.8532991862E+01, 5.4850571972E+00, 3.2780762069E+01, 4.2840543575E+00, 9.8582365812E-01],
	[4.83100E+04, 4.8541948686E+01, 5.4851061184E+00, 3.2791950410E+01, 4.2843450212E+00, 9.8583003526E-01],
	[4.83150E+04, 4.8550906236E+01, 5.4851550349E+00, 3.2803141410E+01, 4.2846356160E+00, 9.8583640923E-01],
	[4.83200E+04, 4.8559864511E+01, 5.4852039468E+00, 3.2814335072E+01, 4.2849261419E+00, 9.8584278004E-01],
	[4.83250E+04, 4.8568823512E+01, 5.4852528541E+00, 3.2825531394E+01, 4.2852165988E+00, 9.8584914768E-01],
	[4.83300E+04, 4.8577783239E+01, 5.4853017567E+00, 3.2836730377E+01, 4.2855069868E+00, 9.8585551216E-01],
	[4.83350E+04, 4.8586743691E+01, 5.4853506547E+00, 3.2847932022E+01, 4.2857973059E+00, 9.8586187347E-01],
	[4.83400E+04, 4.8595704870E+01, 5.4853995481E+00, 3.2859136329E+01, 4.2860875562E+00, 9.8586823163E-01],
	[4.83450E+04, 4.8604666773E+01, 5.4854484369E+00, 3.2870343298E+01, 4.2863777376E+00, 9.8587458662E-01],
	[4.83500E+04, 4.8613629403E+01, 5.4854973210E+00, 3.2881552930E+01, 4.2866678501E+00, 9.8588093846E-01],
	[4.83550E+04, 4.8622592758E+01, 5.4855462006E+00, 3.2892765225E+01, 4.2869578938E+00, 9.8588728714E-01],
	[4.83600E+04, 4.8631556839E+01, 5.4855950755E+00, 3.2903980183E+01, 4.2872478688E+00, 9.8589363266E-01],
	[4.83650E+04, 4.8640521645E+01, 5.4856439458E+00, 3.2915197805E+01, 4.2875377749E+00, 9.8589997504E-01],
	[4.83700E+04, 4.8649487177E+01, 5.4856928115E+00, 3.2926418091E+01, 4.2878276123E+00, 9.8590631426E-01],
	[4.83750E+04, 4.8658453435E+01, 5.4857416725E+00, 3.2937641042E+01, 4.2881173810E+00, 9.8591265033E-01],
	[4.83800E+04, 4.8667420418E+01, 5.4857905290E+00, 3.2948866657E+01, 4.2884070809E+00, 9.8591898326E-01],
	[4.83850E+04, 4.8676388126E+01, 5.4858393808E+00, 3.2960094938E+01, 4.2886967121E+00, 9.8592531304E-01],
	[4.83900E+04, 4.8685356560E+01, 5.4858882280E+00, 3.2971325884E+01, 4.2889862747E+00, 9.8593163968E-01],
	[4.83950E+04, 4.8694325720E+01, 5.4859370707E+00, 3.2982559495E+01, 4.2892757685E+00, 9.8593796317E-01],
	[4.84000E+04, 4.8703295605E+01, 5.4859859087E+00, 3.2993795774E+01, 4.2895651938E+00, 9.8594428353E-01],
	[4.84050E+04, 4.8712266216E+01, 5.4860347420E+00, 3.3005034718E+01, 4.2898545504E+00, 9.8595060074E-01],
	[4.84100E+04, 4.8721237552E+01, 5.4860835708E+00, 3.3016276330E+01, 4.2901438384E+00, 9.8595691482E-01],
	[4.84150E+04, 4.8730209613E+01, 5.4861323950E+00, 3.3027520609E+01, 4.2904330578E+00, 9.8596322576E-01],
	[4.84200E+04, 4.8739182400E+01, 5.4861812146E+00, 3.3038767556E+01, 4.2907222086E+00, 9.8596953357E-01],
	[4.84250E+04, 4.8748155913E+01, 5.4862300295E+00, 3.3050017170E+01, 4.2910112909E+00, 9.8597583825E-01],
	[4.84300E+04, 4.8757130151E+01, 5.4862788399E+00, 3.3061269454E+01, 4.2913003047E+00, 9.8598213979E-01],
	[4.84350E+04, 4.8766105114E+01, 5.4863276456E+00, 3.3072524405E+01, 4.2915892499E+00, 9.8598843821E-01],
	[4.84400E+04, 4.8775080802E+01, 5.4863764468E+00, 3.3083782026E+01, 4.2918781266E+00, 9.8599473350E-01],
	[4.84450E+04, 4.8784057216E+01, 5.4864252433E+00, 3.3095042317E+01, 4.2921669349E+00, 9.8600102566E-01],
	[4.84500E+04, 4.8793034355E+01, 5.4864740352E+00, 3.3106305277E+01, 4.2924556747E+00, 9.8600731470E-01],
	[4.84550E+04, 4.8802012220E+01, 5.4865228226E+00, 3.3117570907E+01, 4.2927443461E+00, 9.8601360062E-01],
	[4.84600E+04, 4.8810990809E+01, 5.4865716053E+00, 3.3128839208E+01, 4.2930329491E+00, 9.8601988342E-01],
	[4.84650E+04, 4.8819970124E+01, 5.4866203835E+00, 3.3140110180E+01, 4.2933214836E+00, 9.8602616310E-01],
	[4.84700E+04, 4.8828950165E+01, 5.4866691570E+00, 3.3151383823E+01, 4.2936099498E+00, 9.8603243966E-01],
	[4.84750E+04, 4.8837930930E+01, 5.4867179259E+00, 3.3162660137E+01, 4.2938983476E+00, 9.8603871311E-01],
	[4.84800E+04, 4.8846912421E+01, 5.4867666903E+00, 3.3173939124E+01, 4.2941866771E+00, 9.8604498344E-01],
	[4.84850E+04, 4.8855894637E+01, 5.4868154500E+00, 3.3185220783E+01, 4.2944749383E+00, 9.8605125066E-01],
	[4.84900E+04, 4.8864877578E+01, 5.4868642052E+00, 3.3196505114E+01, 4.2947631311E+00, 9.8605751477E-01],
	[4.84950E+04, 4.8873861245E+01, 5.4869129558E+00, 3.3207792119E+01, 4.2950512557E+00, 9.8606377577E-01],
	[4.85000E+04, 4.8882845636E+01, 5.4869617017E+00, 3.3219081797E+01, 4.2953393120E+00, 9.8607003367E-01],
	[4.85050E+04, 4.8891830753E+01, 5.4870104431E+00, 3.3230374148E+01, 4.2956273000E+00, 9.8607628846E-01],
	[4.85100E+04, 4.8900816595E+01, 5.4870591799E+00, 3.3241669174E+01, 4.2959152199E+00, 9.8608254014E-01],
	[4.85150E+04, 4.8909803162E+01, 5.4871079121E+00, 3.3252966874E+01, 4.2962030715E+00, 9.8608878873E-01],
	[4.85200E+04, 4.8918790454E+01, 5.4871566397E+00, 3.3264267250E+01, 4.2964908549E+00, 9.8609503421E-01],
	[4.85250E+04, 4.8927778471E+01, 5.4872053627E+00, 3.3275570300E+01, 4.2967785701E+00, 9.8610127660E-01],
	[4.85300E+04, 4.8936767213E+01, 5.4872540811E+00, 3.3286876025E+01, 4.2970662172E+00, 9.8610751588E-01],
	[4.85350E+04, 4.8945756681E+01, 5.4873027950E+00, 3.3298184427E+01, 4.2973537962E+00, 9.8611375208E-01],
	[4.85400E+04, 4.8954746873E+01, 5.4873515042E+00, 3.3309495505E+01, 4.2976413070E+00, 9.8611998517E-01],
	[4.85450E+04, 4.8963737790E+01, 5.4874002089E+00, 3.3320809259E+01, 4.2979287498E+00, 9.8612621518E-01],
	[4.85500E+04, 4.8972729433E+01, 5.4874489090E+00, 3.3332125691E+01, 4.2982161245E+00, 9.8613244210E-01],
	[4.85550E+04, 4.8981721800E+01, 5.4874976045E+00, 3.3343444800E+01, 4.2985034311E+00, 9.8613866593E-01],
	[4.85600E+04, 4.8990714892E+01, 5.4875462954E+00, 3.3354766586E+01, 4.2987906696E+00, 9.8614488667E-01],
	[4.85650E+04, 4.8999708709E+01, 5.4875949818E+00, 3.3366091051E+01, 4.2990778402E+00, 9.8615110432E-01],
	[4.85700E+04, 4.9008703252E+01, 5.4876436635E+00, 3.3377418193E+01, 4.2993649427E+00, 9.8615731889E-01],
	[4.85750E+04, 4.9017698519E+01, 5.4876923407E+00, 3.3388748015E+01, 4.2996519773E+00, 9.8616353039E-01],
	[4.85800E+04, 4.9026694511E+01, 5.4877410133E+00, 3.3400080516E+01, 4.2999389439E+00, 9.8616973880E-01],
	[4.85850E+04, 4.9035691228E+01, 5.4877896813E+00, 3.3411415696E+01, 4.3002258426E+00, 9.8617594413E-01],
	[4.85900E+04, 4.9044688669E+01, 5.4878383448E+00, 3.3422753556E+01, 4.3005126733E+00, 9.8618214638E-01],
	[4.85950E+04, 4.9053686836E+01, 5.4878870036E+00, 3.3434094096E+01, 4.3007994361E+00, 9.8618834556E-01],
	[4.86000E+04, 4.9062685728E+01, 5.4879356579E+00, 3.3445437317E+01, 4.3010861310E+00, 9.8619454167E-01],
	[4.86050E+04, 4.9071685344E+01, 5.4879843077E+00, 3.3456783218E+01, 4.3013727581E+00, 9.8620073470E-01],
	[4.86100E+04, 4.9080685685E+01, 5.4880329528E+00, 3.3468131801E+01, 4.3016593173E+00, 9.8620692466E-01],
	[4.86150E+04, 4.9089686751E+01, 5.4880815934E+00, 3.3479483066E+01, 4.3019458087E+00, 9.8621311156E-01],
	[4.86200E+04, 4.9098688542E+01, 5.4881302294E+00, 3.3490837012E+01, 4.3022322323E+00, 9.8621929539E-01],
	[4.86250E+04, 4.9107691057E+01, 5.4881788608E+00, 3.3502193641E+01, 4.3025185880E+00, 9.8622547615E-01],
	[4.86300E+04, 4.9116694297E+01, 5.4882274877E+00, 3.3513552952E+01, 4.3028048760E+00, 9.8623165385E-01],
	[4.86350E+04, 4.9125698262E+01, 5.4882761100E+00, 3.3524914947E+01, 4.3030910963E+00, 9.8623782848E-01],
	[4.86400E+04, 4.9134702952E+01, 5.4883247277E+00, 3.3536279625E+01, 4.3033772488E+00, 9.8624400006E-01],
	[4.86450E+04, 4.9143708366E+01, 5.4883733409E+00, 3.3547646987E+01, 4.3036633335E+00, 9.8625016858E-01],
	[4.86500E+04, 4.9152714505E+01, 5.4884219495E+00, 3.3559017032E+01, 4.3039493506E+00, 9.8625633404E-01],
	[4.86550E+04, 4.9161721369E+01, 5.4884705535E+00, 3.3570389762E+01, 4.3042353000E+00, 9.8626249645E-01],
	[4.86600E+04, 4.9170728957E+01, 5.4885191530E+00, 3.3581765178E+01, 4.3045211818E+00, 9.8626865580E-01],
	[4.86650E+04, 4.9179737270E+01, 5.4885677479E+00, 3.3593143278E+01, 4.3048069958E+00, 9.8627481210E-01],
	[4.86700E+04, 4.9188746308E+01, 5.4886163382E+00, 3.3604524064E+01, 4.3050927423E+00, 9.8628096535E-01],
	[4.86750E+04, 4.9197756070E+01, 5.4886649240E+00, 3.3615907535E+01, 4.3053784212E+00, 9.8628711555E-01],
	[4.86800E+04, 4.9206766557E+01, 5.4887135052E+00, 3.3627293693E+01, 4.3056640324E+00, 9.8629326270E-01],
	[4.86850E+04, 4.9215777768E+01, 5.4887620819E+00, 3.3638682538E+01, 4.3059495761E+00, 9.8629940681E-01],
	[4.86900E+04, 4.9224789704E+01, 5.4888106540E+00, 3.3650074069E+01, 4.3062350523E+00, 9.8630554788E-01],
	[4.86950E+04, 4.9233802364E+01, 5.4888592216E+00, 3.3661468288E+01, 4.3065204609E+00, 9.8631168590E-01],
	[4.87000E+04, 4.9242815749E+01, 5.4889077845E+00, 3.3672865195E+01, 4.3068058020E+00, 9.8631782088E-01],
	[4.87050E+04, 4.9251829859E+01, 5.4889563430E+00, 3.3684264789E+01, 4.3070910756E+00, 9.8632395283E-01],
	[4.87100E+04, 4.9260844693E+01, 5.4890048969E+00, 3.3695667073E+01, 4.3073762817E+00, 9.8633008174E-01],
	[4.87150E+04, 4.9269860251E+01, 5.4890534462E+00, 3.3707072044E+01, 4.3076614204E+00, 9.8633620761E-01],
	[4.87200E+04, 4.9278876534E+01, 5.4891019909E+00, 3.3718479705E+01, 4.3079464917E+00, 9.8634233044E-01],
	[4.87250E+04, 4.9287893541E+01, 5.4891505312E+00, 3.3729890056E+01, 4.3082314955E+00, 9.8634845025E-01],
	[4.87300E+04, 4.9296911273E+01, 5.4891990668E+00, 3.3741303096E+01, 4.3085164319E+00, 9.8635456703E-01],
	[4.87350E+04, 4.9305929729E+01, 5.4892475979E+00, 3.3752718826E+01, 4.3088013010E+00, 9.8636068077E-01],
	[4.87400E+04, 4.9314948910E+01, 5.4892961245E+00, 3.3764137247E+01, 4.3090861026E+00, 9.8636679149E-01],
	[4.87450E+04, 4.9323968815E+01, 5.4893446465E+00, 3.3775558359E+01, 4.3093708370E+00, 9.8637289919E-01],
	[4.87500E+04, 4.9332989444E+01, 5.4893931640E+00, 3.3786982163E+01, 4.3096555040E+00, 9.8637900386E-01],
	[4.87550E+04, 4.9342010797E+01, 5.4894416769E+00, 3.3798408657E+01, 4.3099401037E+00, 9.8638510550E-01],
	[4.87600E+04, 4.9351032875E+01, 5.4894901853E+00, 3.3809837844E+01, 4.3102246361E+00, 9.8639120413E-01],
	[4.87650E+04, 4.9360055678E+01, 5.4895386891E+00, 3.3821269723E+01, 4.3105091012E+00, 9.8639729974E-01],
	[4.87700E+04, 4.9369079204E+01, 5.4895871884E+00, 3.3832704295E+01, 4.3107934991E+00, 9.8640339233E-01],
	[4.87750E+04, 4.9378103455E+01, 5.4896356831E+00, 3.3844141560E+01, 4.3110778298E+00, 9.8640948191E-01],
	[4.87800E+04, 4.9387128430E+01, 5.4896841733E+00, 3.3855581519E+01, 4.3113620932E+00, 9.8641556847E-01],
	[4.87850E+04, 4.9396154129E+01, 5.4897326590E+00, 3.3867024171E+01, 4.3116462895E+00, 9.8642165202E-01],
	[4.87900E+04, 4.9405180553E+01, 5.4897811401E+00, 3.3878469517E+01, 4.3119304186E+00, 9.8642773256E-01],
	[4.87950E+04, 4.9414207700E+01, 5.4898296167E+00, 3.3889917558E+01, 4.3122144805E+00, 9.8643381009E-01],
	[4.88000E+04, 4.9423235572E+01, 5.4898780887E+00, 3.3901368293E+01, 4.3124984753E+00, 9.8643988461E-01],
	[4.88050E+04, 4.9432264169E+01, 5.4899265562E+00, 3.3912821724E+01, 4.3127824029E+00, 9.8644595613E-01],
	[4.88100E+04, 4.9441293489E+01, 5.4899750192E+00, 3.3924277851E+01, 4.3130662635E+00, 9.8645202464E-01],
	[4.88150E+04, 4.9450336350E+01, 5.4900248592E+00, 3.3935736673E+01, 4.3133510073E+00, 9.8645809015E-01],
	[4.88200E+04, 4.9459406768E+01, 5.4900775859E+00, 3.3947198192E+01, 4.3136376732E+00, 9.8646415266E-01],
	[4.88250E+04, 4.9468477920E+01, 5.4901303077E+00, 3.3958662407E+01, 4.3139242724E+00, 9.8647021217E-01],
	[4.88300E+04, 4.9477549806E+01, 5.4901830246E+00, 3.3970129319E+01, 4.3142108048E+00, 9.8647626868E-01],
	[4.88350E+04, 4.9486622427E+01, 5.4902357366E+00, 3.3981598929E+01, 4.3144972706E+00, 9.8648232220E-01],
	[4.88400E+04, 4.9495695783E+01, 5.4902884437E+00, 3.3993071236E+01, 4.3147836697E+00, 9.8648837272E-01],
	[4.88450E+04, 4.9504769873E+01, 5.4903411459E+00, 3.4004546242E+01, 4.3150700021E+00, 9.8649442026E-01],
	[4.88500E+04, 4.9513844697E+01, 5.4903938433E+00, 3.4016023945E+01, 4.3153562679E+00, 9.8650046479E-01],
	[4.88550E+04, 4.9522920256E+01, 5.4904465357E+00, 3.4027504348E+01, 4.3156424671E+00, 9.8650650635E-01],
	[4.88600E+04, 4.9531996550E+01, 5.4904992233E+00, 3.4038987450E+01, 4.3159285997E+00, 9.8651254491E-01],
	[4.88650E+04, 4.9541073578E+01, 5.4905519060E+00, 3.4050473251E+01, 4.3162146657E+00, 9.8651858048E-01],
	[4.88700E+04, 4.9550151340E+01, 5.4906045838E+00, 3.4061961752E+01, 4.3165006651E+00, 9.8652461308E-01],
	[4.88750E+04, 4.9559229837E+01, 5.4906572567E+00, 3.4073452954E+01, 4.3167865980E+00, 9.8653064269E-01],
	[4.88800E+04, 4.9568309068E+01, 5.4907099248E+00, 3.4084946856E+01, 4.3170724644E+00, 9.8653666931E-01],
	[4.88850E+04, 4.9577389033E+01, 5.4907625879E+00, 3.4096443459E+01, 4.3173582643E+00, 9.8654269296E-01],
	[4.88900E+04, 4.9586469733E+01, 5.4908152462E+00, 3.4107942763E+01, 4.3176439976E+00, 9.8654871364E-01],
	[4.88950E+04, 4.9595551167E+01, 5.4908678996E+00, 3.4119444769E+01, 4.3179296646E+00, 9.8655473133E-01],
	[4.89000E+04, 4.9604633336E+01, 5.4909205481E+00, 3.4130949477E+01, 4.3182152650E+00, 9.8656074605E-01],
	[4.89050E+04, 4.9613716239E+01, 5.4909731917E+00, 3.4142456887E+01, 4.3185007990E+00, 9.8656675780E-01],
	[4.89100E+04, 4.9622799876E+01, 5.4910258305E+00, 3.4153967000E+01, 4.3187862666E+00, 9.8657276658E-01],
	[4.89150E+04, 4.9631884247E+01, 5.4910784643E+00, 3.4165479816E+01, 4.3190716679E+00, 9.8657877238E-01],
	[4.89200E+04, 4.9640969353E+01, 5.4911310934E+00, 3.4176995336E+01, 4.3193570027E+00, 9.8658477522E-01],
	[4.89250E+04, 4.9650055193E+01, 5.4911837175E+00, 3.4188513559E+01, 4.3196422712E+00, 9.8659077509E-01],
	[4.89300E+04, 4.9659141767E+01, 5.4912363367E+00, 3.4200034487E+01, 4.3199274733E+00, 9.8659677200E-01],
	[4.89350E+04, 4.9668229076E+01, 5.4912889511E+00, 3.4211558119E+01, 4.3202126091E+00, 9.8660276595E-01],
	[4.89400E+04, 4.9677317118E+01, 5.4913415606E+00, 3.4223084456E+01, 4.3204976786E+00, 9.8660875693E-01],
	[4.89450E+04, 4.9686405895E+01, 5.4913941653E+00, 3.4234613498E+01, 4.3207826818E+00, 9.8661474495E-01],
	[4.89500E+04, 4.9695495406E+01, 5.4914467650E+00, 3.4246145246E+01, 4.3210676188E+00, 9.8662073002E-01],
	[4.89550E+04, 4.9704585651E+01, 5.4914993599E+00, 3.4257679700E+01, 4.3213524895E+00, 9.8662671213E-01],
	[4.89600E+04, 4.9713676630E+01, 5.4915519500E+00, 3.4269216860E+01, 4.3216372939E+00, 9.8663269128E-01],
	[4.89650E+04, 4.9722768344E+01, 5.4916045352E+00, 3.4280756727E+01, 4.3219220322E+00, 9.8663866748E-01],
	[4.89700E+04, 4.9731860791E+01, 5.4916571155E+00, 3.4292299301E+01, 4.3222067042E+00, 9.8664464073E-01],
	[4.89750E+04, 4.9740953973E+01, 5.4917096909E+00, 3.4303844582E+01, 4.3224913101E+00, 9.8665061103E-01],
	[4.89800E+04, 4.9750047888E+01, 5.4917622615E+00, 3.4315392571E+01, 4.3227758498E+00, 9.8665657838E-01],
	[4.89850E+04, 4.9759142538E+01, 5.4918148272E+00, 3.4326943268E+01, 4.3230603234E+00, 9.8666254278E-01],
	[4.89900E+04, 4.9768237922E+01, 5.4918673880E+00, 3.4338496674E+01, 4.3233447309E+00, 9.8666850424E-01],
	[4.89950E+04, 4.9777334040E+01, 5.4919199440E+00, 3.4350052788E+01, 4.3236290722E+00, 9.8667446275E-01],
	[4.90000E+04, 4.9786430892E+01, 5.4919724951E+00, 3.4361611612E+01, 4.3239133475E+00, 9.8668041832E-01],
	[4.90050E+04, 4.9795528478E+01, 5.4920250414E+00, 3.4373173145E+01, 4.3241975567E+00, 9.8668637096E-01],
	[4.90100E+04, 4.9804626797E+01, 5.4920775828E+00, 3.4384737388E+01, 4.3244816999E+00, 9.8669232065E-01],
	[4.90150E+04, 4.9813725851E+01, 5.4921301194E+00, 3.4396304341E+01, 4.3247657770E+00, 9.8669826741E-01],
	[4.90200E+04, 4.9822825639E+01, 5.4921826511E+00, 3.4407874005E+01, 4.3250497881E+00, 9.8670421123E-01],
	[4.90250E+04, 4.9831926161E+01, 5.4922351779E+00, 3.4419446380E+01, 4.3253337332E+00, 9.8671015211E-01],
	[4.90300E+04, 4.9841027416E+01, 5.4922876999E+00, 3.4431021466E+01, 4.3256176124E+00, 9.8671609007E-01],
	[4.90350E+04, 4.9850129406E+01, 5.4923402170E+00, 3.4442599264E+01, 4.3259014256E+00, 9.8672202509E-01],
	[4.90400E+04, 4.9859232129E+01, 5.4923927293E+00, 3.4454179774E+01, 4.3261851728E+00, 9.8672795719E-01],
	[4.90450E+04, 4.9868335586E+01, 5.4924452367E+00, 3.4465762996E+01, 4.3264688542E+00, 9.8673388635E-01],
	[4.90500E+04, 4.9877439778E+01, 5.4924977393E+00, 3.4477348932E+01, 4.3267524696E+00, 9.8673981260E-01],
	[4.90550E+04, 4.9886544702E+01, 5.4925502370E+00, 3.4488937580E+01, 4.3270360191E+00, 9.8674573591E-01],
	[4.90600E+04, 4.9895650361E+01, 5.4926027299E+00, 3.4500528942E+01, 4.3273195028E+00, 9.8675165631E-01],
	[4.90650E+04, 4.9904756754E+01, 5.4926552179E+00, 3.4512123018E+01, 4.3276029206E+00, 9.8675757378E-01],
	[4.90700E+04, 4.9913863880E+01, 5.4927077011E+00, 3.4523719807E+01, 4.3278862726E+00, 9.8676348834E-01],
	[4.90750E+04, 4.9922971741E+01, 5.4927601794E+00, 3.4535319312E+01, 4.3281695588E+00, 9.8676939998E-01],
	[4.90800E+04, 4.9932080335E+01, 5.4928126529E+00, 3.4546921531E+01, 4.3284527792E+00, 9.8677530870E-01],
	[4.90850E+04, 4.9941189662E+01, 5.4928651216E+00, 3.4558526466E+01, 4.3287359338E+00, 9.8678121451E-01],
	[4.90900E+04, 4.9950299724E+01, 5.4929175854E+00, 3.4570134116E+01, 4.3290190227E+00, 9.8678711740E-01],
	[4.90950E+04, 4.9959410519E+01, 5.4929700443E+00, 3.4581744483E+01, 4.3293020458E+00, 9.8679301738E-01],
	[4.91000E+04, 4.9968522048E+01, 5.4930224985E+00, 3.4593357565E+01, 4.3295850032E+00, 9.8679891446E-01],
	[4.91050E+04, 4.9977634310E+01, 5.4930749477E+00, 3.4604973365E+01, 4.3298678949E+00, 9.8680480862E-01],
	[4.91100E+04, 4.9986747307E+01, 5.4931273922E+00, 3.4616591881E+01, 4.3301507209E+00, 9.8681069988E-01],
	[4.91150E+04, 4.9995861036E+01, 5.4931798318E+00, 3.4628213115E+01, 4.3304334813E+00, 9.8681658823E-01],
	[4.91200E+04, 5.0004975500E+01, 5.4932322665E+00, 3.4639837067E+01, 4.3307161760E+00, 9.8682247368E-01],
	[4.91250E+04, 5.0014090697E+01, 5.4932846965E+00, 3.4651463737E+01, 4.3309988051E+00, 9.8682835623E-01],
	[4.91300E+04, 5.0023206628E+01, 5.4933371216E+00, 3.4663093125E+01, 4.3312813685E+00, 9.8683423587E-01],
	[4.91350E+04, 5.0032323292E+01, 5.4933895418E+00, 3.4674725232E+01, 4.3315638664E+00, 9.8684011261E-01],
	[4.91400E+04, 5.0041440690E+01, 5.4934419572E+00, 3.4686360059E+01, 4.3318462987E+00, 9.8684598646E-01],
	[4.91450E+04, 5.0050558822E+01, 5.4934943678E+00, 3.4697997605E+01, 4.3321286655E+00, 9.8685185741E-01],
	[4.91500E+04, 5.0059677687E+01, 5.4935467736E+00, 3.4709637871E+01, 4.3324109667E+00, 9.8685772547E-01],
	[4.91550E+04, 5.0068797285E+01, 5.4935991745E+00, 3.4721280857E+01, 4.3326932023E+00, 9.8686359063E-01],
	[4.91600E+04, 5.0077917617E+01, 5.4936515706E+00, 3.4732926564E+01, 4.3329753725E+00, 9.8686945289E-01],
	[4.91650E+04, 5.0087038683E+01, 5.4937039619E+00, 3.4744574992E+01, 4.3332574772E+00, 9.8687531227E-01],
	[4.91700E+04, 5.0096160482E+01, 5.4937563483E+00, 3.4756226142E+01, 4.3335395165E+00, 9.8688116876E-01],
	[4.91750E+04, 5.0105283015E+01, 5.4938087299E+00, 3.4767880013E+01, 4.3338214903E+00, 9.8688702236E-01],
	[4.91800E+04, 5.0114406281E+01, 5.4938611067E+00, 3.4779536606E+01, 4.3341033986E+00, 9.8689287307E-01],
	[4.91850E+04, 5.0123530280E+01, 5.4939134787E+00, 3.4791195922E+01, 4.3343852416E+00, 9.8689872090E-01],
	[4.91900E+04, 5.0132655013E+01, 5.4939658458E+00, 3.4802857960E+01, 4.3346670191E+00, 9.8690456584E-01],
	[4.91950E+04, 5.0141780479E+01, 5.4940182081E+00, 3.4814522722E+01, 4.3349487313E+00, 9.8691040791E-01],
	[4.92000E+04, 5.0150906679E+01, 5.4940705656E+00, 3.4826190208E+01, 4.3352303781E+00, 9.8691624709E-01],
	[4.92050E+04, 5.0160033612E+01, 5.4941229183E+00, 3.4837860417E+01, 4.3355119596E+00, 9.8692208339E-01],
	[4.92100E+04, 5.0169161278E+01, 5.4941752661E+00, 3.4849533350E+01, 4.3357934758E+00, 9.8692791681E-01],
	[4.92150E+04, 5.0178289678E+01, 5.4942276091E+00, 3.4861209008E+01, 4.3360749266E+00, 9.8693374736E-01],
	[4.92200E+04, 5.0187418811E+01, 5.4942799473E+00, 3.4872887391E+01, 4.3363563122E+00, 9.8693957503E-01],
	[4.92250E+04, 5.0196548677E+01, 5.4943322807E+00, 3.4884568500E+01, 4.3366376325E+00, 9.8694539983E-01],
	[4.92300E+04, 5.0205679277E+01, 5.4943846093E+00, 3.4896252334E+01, 4.3369188876E+00, 9.8695122176E-01],
	[4.92350E+04, 5.0214810610E+01, 5.4944369331E+00, 3.4907938894E+01, 4.3372000774E+00, 9.8695704082E-01],
	[4.92400E+04, 5.0223942676E+01, 5.4944892520E+00, 3.4919628180E+01, 4.3374812020E+00, 9.8696285700E-01],
	[4.92450E+04, 5.0233075476E+01, 5.4945415661E+00, 3.4931320194E+01, 4.3377622614E+00, 9.8696867032E-01],
	[4.92500E+04, 5.0242209008E+01, 5.4945938754E+00, 3.4943014934E+01, 4.3380432557E+00, 9.8697448078E-01],
	[4.92550E+04, 5.0251343274E+01, 5.4946461799E+00, 3.4954712402E+01, 4.3383241848E+00, 9.8698028836E-01],
	[4.92600E+04, 5.0260478273E+01, 5.4946984796E+00, 3.4966412598E+01, 4.3386050488E+00, 9.8698609309E-01],
	[4.92650E+04, 5.0269614006E+01, 5.4947507745E+00, 3.4978115522E+01, 4.3388858476E+00, 9.8699189495E-01],
	[4.92700E+04, 5.0278750471E+01, 5.4948030646E+00, 3.4989821174E+01, 4.3391665813E+00, 9.8699769396E-01],
	[4.92750E+04, 5.0287887670E+01, 5.4948553498E+00, 3.5001529556E+01, 4.3394472500E+00, 9.8700349010E-01],
	[4.92800E+04, 5.0297025602E+01, 5.4949076303E+00, 3.5013240667E+01, 4.3397278535E+00, 9.8700928339E-01],
	[4.92850E+04, 5.0306164266E+01, 5.4949599059E+00, 3.5024954507E+01, 4.3400083921E+00, 9.8701507382E-01],
	[4.92900E+04, 5.0315303664E+01, 5.4950121768E+00, 3.5036671078E+01, 4.3402888656E+00, 9.8702086139E-01],
	[4.92950E+04, 5.0324443796E+01, 5.4950644428E+00, 3.5048390378E+01, 4.3405692741E+00, 9.8702664612E-01],
	[4.93000E+04, 5.0333584660E+01, 5.4951167040E+00, 3.5060112410E+01, 4.3408496176E+00, 9.8703242799E-01],
	[4.93050E+04, 5.0342726257E+01, 5.4951689605E+00, 3.5071837172E+01, 4.3411298961E+00, 9.8703820701E-01],
	[4.93100E+04, 5.0351868587E+01, 5.4952212121E+00, 3.5083564667E+01, 4.3414101096E+00, 9.8704398318E-01],
	[4.93150E+04, 5.0361011651E+01, 5.4952734589E+00, 3.5095294892E+01, 4.3416902582E+00, 9.8704975651E-01],
	[4.93200E+04, 5.0370155447E+01, 5.4953257010E+00, 3.5107027850E+01, 4.3419703419E+00, 9.8705552699E-01],
	[4.93250E+04, 5.0379299976E+01, 5.4953779382E+00, 3.5118763541E+01, 4.3422503607E+00, 9.8706129462E-01],
	[4.93300E+04, 5.0388445239E+01, 5.4954301706E+00, 3.5130501964E+01, 4.3425303146E+00, 9.8706705941E-01],
	[4.93350E+04, 5.0397591234E+01, 5.4954823982E+00, 3.5142243121E+01, 4.3428102037E+00, 9.8707282136E-01],
	[4.93400E+04, 5.0406737962E+01, 5.4955346211E+00, 3.5153987011E+01, 4.3430900278E+00, 9.8707858047E-01],
	[4.93450E+04, 5.0415885423E+01, 5.4955868391E+00, 3.5165733635E+01, 4.3433697872E+00, 9.8708433674E-01],
	[4.93500E+04, 5.0425033618E+01, 5.4956390523E+00, 3.5177482994E+01, 4.3436494817E+00, 9.8709009018E-01],
	[4.93550E+04, 5.0434182545E+01, 5.4956912608E+00, 3.5189235087E+01, 4.3439291115E+00, 9.8709584077E-01],
	[4.93600E+04, 5.0443332204E+01, 5.4957434644E+00, 3.5200989915E+01, 4.3442086764E+00, 9.8710158854E-01],
	[4.93650E+04, 5.0452482597E+01, 5.4957956633E+00, 3.5212747479E+01, 4.3444881766E+00, 9.8710733347E-01],
	[4.93700E+04, 5.0461633723E+01, 5.4958478574E+00, 3.5224507778E+01, 4.3447676121E+00, 9.8711307557E-01],
	[4.93750E+04, 5.0470785581E+01, 5.4959000467E+00, 3.5236270814E+01, 4.3450469828E+00, 9.8711881484E-01],
	[4.93800E+04, 5.0479938173E+01, 5.4959522312E+00, 3.5248036586E+01, 4.3453262889E+00, 9.8712455128E-01],
	[4.93850E+04, 5.0489091497E+01, 5.4960044109E+00, 3.5259805094E+01, 4.3456055302E+00, 9.8713028489E-01],
	[4.93900E+04, 5.0498245554E+01, 5.4960565858E+00, 3.5271576340E+01, 4.3458847069E+00, 9.8713601568E-01],
	[4.93950E+04, 5.0507400344E+01, 5.4961087559E+00, 3.5283350324E+01, 4.3461638189E+00, 9.8714174365E-01],
	[4.94000E+04, 5.0516555866E+01, 5.4961609213E+00, 3.5295127045E+01, 4.3464428663E+00, 9.8714746879E-01],
	[4.94050E+04, 5.0525712121E+01, 5.4962130818E+00, 3.5306906505E+01, 4.3467218491E+00, 9.8715319111E-01],
	[4.94100E+04, 5.0534869109E+01, 5.4962652376E+00, 3.5318688703E+01, 4.3470007672E+00, 9.8715891061E-01],
	[4.94150E+04, 5.0544026830E+01, 5.4963173886E+00, 3.5330473641E+01, 4.3472796208E+00, 9.8716462729E-01],
	[4.94200E+04, 5.0553185283E+01, 5.4963695348E+00, 3.5342261317E+01, 4.3475584098E+00, 9.8717034116E-01],
	[4.94250E+04, 5.0562344470E+01, 5.4964216762E+00, 3.5354051734E+01, 4.3478371343E+00, 9.8717605221E-01],
	[4.94300E+04, 5.0571504388E+01, 5.4964738129E+00, 3.5365844890E+01, 4.3481157943E+00, 9.8718176044E-01],
	[4.94350E+04, 5.0580665040E+01, 5.4965259447E+00, 3.5377640787E+01, 4.3483943897E+00, 9.8718746587E-01],
	[4.94400E+04, 5.0589826424E+01, 5.4965780718E+00, 3.5389439425E+01, 4.3486729207E+00, 9.8719316848E-01],
	[4.94450E+04, 5.0598988541E+01, 5.4966301942E+00, 3.5401240804E+01, 4.3489513872E+00, 9.8719886828E-01],
	[4.94500E+04, 5.0608151390E+01, 5.4966823117E+00, 3.5413044924E+01, 4.3492297892E+00, 9.8720456528E-01],
	[4.94550E+04, 5.0617314972E+01, 5.4967344245E+00, 3.5424851786E+01, 4.3495081268E+00, 9.8721025946E-01],
	[4.94600E+04, 5.0626479286E+01, 5.4967865325E+00, 3.5436661390E+01, 4.3497864000E+00, 9.8721595085E-01],
	[4.94650E+04, 5.0635644333E+01, 5.4968386357E+00, 3.5448473737E+01, 4.3500646087E+00, 9.8722163942E-01],
	[4.94700E+04, 5.0644810113E+01, 5.4968907341E+00, 3.5460288827E+01, 4.3503427531E+00, 9.8722732520E-01],
	[4.94750E+04, 5.0653976625E+01, 5.4969428278E+00, 3.5472106661E+01, 4.3506208331E+00, 9.8723300817E-01],
	[4.94800E+04, 5.0663143870E+01, 5.4969949167E+00, 3.5483927237E+01, 4.3508988488E+00, 9.8723868835E-01],
	[4.94850E+04, 5.0672311847E+01, 5.4970470008E+00, 3.5495750558E+01, 4.3511768002E+00, 9.8724436573E-01],
	[4.94900E+04, 5.0681480557E+01, 5.4970990802E+00, 3.5507576624E+01, 4.3514546872E+00, 9.8725004031E-01],
	[4.94950E+04, 5.0690649999E+01, 5.4971511548E+00, 3.5519405434E+01, 4.3517325099E+00, 9.8725571209E-01],
	[4.95000E+04, 5.0699820174E+01, 5.4972032246E+00, 3.5531236989E+01, 4.3520102684E+00, 9.8726138108E-01],
	[4.95050E+04, 5.0708991081E+01, 5.4972552897E+00, 3.5543071289E+01, 4.3522879626E+00, 9.8726704728E-01],
	[4.95100E+04, 5.0718162720E+01, 5.4973073500E+00, 3.5554908336E+01, 4.3525655926E+00, 9.8727271069E-01],
	[4.95150E+04, 5.0727335092E+01, 5.4973594055E+00, 3.5566748128E+01, 4.3528431583E+00, 9.8727837131E-01],
	[4.95200E+04, 5.0736508196E+01, 5.4974114563E+00, 3.5578590668E+01, 4.3531206599E+00, 9.8728402914E-01],
	[4.95250E+04, 5.0745682033E+01, 5.4974635023E+00, 3.5590435954E+01, 4.3533980972E+00, 9.8728968418E-01],
	[4.95300E+04, 5.0754856602E+01, 5.4975155435E+00, 3.5602283987E+01, 4.3536754704E+00, 9.8729533644E-01],
	[4.95350E+04, 5.0764031903E+01, 5.4975675800E+00, 3.5614134768E+01, 4.3539527794E+00, 9.8730098591E-01],
	[4.95400E+04, 5.0773207937E+01, 5.4976196117E+00, 3.5625988297E+01, 4.3542300244E+00, 9.8730663261E-01],
	[4.95450E+04, 5.0782384703E+01, 5.4976716387E+00, 3.5637844574E+01, 4.3545072051E+00, 9.8731227652E-01],
	[4.95500E+04, 5.0791562201E+01, 5.4977236609E+00, 3.5649703600E+01, 4.3547843218E+00, 9.8731791765E-01],
	[4.95550E+04, 5.0800740432E+01, 5.4977756784E+00, 3.5661565375E+01, 4.3550613744E+00, 9.8732355600E-01],
	[4.95600E+04, 5.0809919395E+01, 5.4978276911E+00, 3.5673429899E+01, 4.3553383630E+00, 9.8732919158E-01],
	[4.95650E+04, 5.0819099090E+01, 5.4978796990E+00, 3.5685297174E+01, 4.3556152875E+00, 9.8733482438E-01],
	[4.95700E+04, 5.0828279517E+01, 5.4979317022E+00, 3.5697167198E+01, 4.3558921480E+00, 9.8734045441E-01],
	[4.95750E+04, 5.0837460677E+01, 5.4979837006E+00, 3.5709039973E+01, 4.3561689445E+00, 9.8734608167E-01],
	[4.95800E+04, 5.0846642569E+01, 5.4980356943E+00, 3.5720915498E+01, 4.3564456770E+00, 9.8735170616E-01],
	[4.95850E+04, 5.0855825193E+01, 5.4980876832E+00, 3.5732793775E+01, 4.3567223455E+00, 9.8735732787E-01],
	[4.95900E+04, 5.0865008549E+01, 5.4981396674E+00, 3.5744674804E+01, 4.3569989500E+00, 9.8736294682E-01],
	[4.95950E+04, 5.0874192637E+01, 5.4981916468E+00, 3.5756558584E+01, 4.3572754907E+00, 9.8736856300E-01],
	[4.96000E+04, 5.0883377458E+01, 5.4982436215E+00, 3.5768445117E+01, 4.3575519674E+00, 9.8737417642E-01],
	[4.96050E+04, 5.0892563011E+01, 5.4982955914E+00, 3.5780334402E+01, 4.3578283802E+00, 9.8737978707E-01],
	[4.96100E+04, 5.0901749295E+01, 5.4983475566E+00, 3.5792226441E+01, 4.3581047291E+00, 9.8738539497E-01],
	[4.96150E+04, 5.0910936312E+01, 5.4983995171E+00, 3.5804121232E+01, 4.3583810141E+00, 9.8739100010E-01],
	[4.96200E+04, 5.0920124061E+01, 5.4984514728E+00, 3.5816018778E+01, 4.3586572354E+00, 9.8739660247E-01],
	[4.96250E+04, 5.0929312542E+01, 5.4985034237E+00, 3.5827919078E+01, 4.3589333927E+00, 9.8740220208E-01],
	[4.96300E+04, 5.0938501755E+01, 5.4985553699E+00, 3.5839822132E+01, 4.3592094863E+00, 9.8740779894E-01],
	[4.96350E+04, 5.0947691700E+01, 5.4986073114E+00, 3.5851727940E+01, 4.3594855161E+00, 9.8741339304E-01],
	[4.96400E+04, 5.0956882378E+01, 5.4986592481E+00, 3.5863636504E+01, 4.3597614821E+00, 9.8741898439E-01],
	[4.96450E+04, 5.0966073787E+01, 5.4987111801E+00, 3.5875547824E+01, 4.3600373843E+00, 9.8742457299E-01],
	[4.96500E+04, 5.0975265928E+01, 5.4987631073E+00, 3.5887461900E+01, 4.3603132228E+00, 9.8743015883E-01],
	[4.96550E+04, 5.0984458801E+01, 5.4988150298E+00, 3.5899378731E+01, 4.3605889976E+00, 9.8743574193E-01],
	[4.96600E+04, 5.0993652406E+01, 5.4988669476E+00, 3.5911298320E+01, 4.3608647087E+00, 9.8744132228E-01],
	[4.96650E+04, 5.1002846743E+01, 5.4989188606E+00, 3.5923220665E+01, 4.3611403560E+00, 9.8744689988E-01],
	[4.96700E+04, 5.1012041812E+01, 5.4989707689E+00, 3.5935145768E+01, 4.3614159398E+00, 9.8745247474E-01],
	[4.96750E+04, 5.1021237613E+01, 5.4990226725E+00, 3.5947073628E+01, 4.3616914598E+00, 9.8745804685E-01],
	[4.96800E+04, 5.1030434146E+01, 5.4990745713E+00, 3.5959004246E+01, 4.3619669162E+00, 9.8746361622E-01],
	[4.96850E+04, 5.1039631410E+01, 5.4991264654E+00, 3.5970937623E+01, 4.3622423091E+00, 9.8746918286E-01],
	[4.96900E+04, 5.1048829407E+01, 5.4991783547E+00, 3.5982873759E+01, 4.3625176383E+00, 9.8747474675E-01],
	[4.96950E+04, 5.1058028135E+01, 5.4992302393E+00, 3.5994812654E+01, 4.3627929039E+00, 9.8748030790E-01],
	[4.97000E+04, 5.1067227596E+01, 5.4992821192E+00, 3.6006754308E+01, 4.3630681060E+00, 9.8748586632E-01],
	[4.97050E+04, 5.1076427788E+01, 5.4993339944E+00, 3.6018698722E+01, 4.3633432445E+00, 9.8749142200E-01],
	[4.97100E+04, 5.1085628712E+01, 5.4993858648E+00, 3.6030645896E+01, 4.3636183195E+00, 9.8749697495E-01],
	[4.97150E+04, 5.1094830367E+01, 5.4994377306E+00, 3.6042595831E+01, 4.3638933310E+00, 9.8750252517E-01],
	[4.97200E+04, 5.1104032755E+01, 5.4994895915E+00, 3.6054548527E+01, 4.3641682790E+00, 9.8750807266E-01],
	[4.97250E+04, 5.1113235874E+01, 5.4995414478E+00, 3.6066503984E+01, 4.3644431635E+00, 9.8751361742E-01],
	[4.97300E+04, 5.1122439725E+01, 5.4995932993E+00, 3.6078462203E+01, 4.3647179846E+00, 9.8751915945E-01],
	[4.97350E+04, 5.1131644308E+01, 5.4996451461E+00, 3.6090423184E+01, 4.3649927422E+00, 9.8752469875E-01],
	[4.97400E+04, 5.1140849622E+01, 5.4996969882E+00, 3.6102386927E+01, 4.3652674364E+00, 9.8753023533E-01],
	[4.97450E+04, 5.1150055668E+01, 5.4997488256E+00, 3.6114353433E+01, 4.3655420672E+00, 9.8753576918E-01],
	[4.97500E+04, 5.1159262446E+01, 5.4998006582E+00, 3.6126322702E+01, 4.3658166346E+00, 9.8754130032E-01],
	[4.97550E+04, 5.1168469955E+01, 5.4998524861E+00, 3.6138294734E+01, 4.3660911386E+00, 9.8754682873E-01],
	[4.97600E+04, 5.1177678196E+01, 5.4999043093E+00, 3.6150269531E+01, 4.3663655793E+00, 9.8755235442E-01],
	[4.97650E+04, 5.1186887169E+01, 5.4999561278E+00, 3.6162247091E+01, 4.3666399567E+00, 9.8755787740E-01],
	[4.97700E+04, 5.1196096874E+01, 5.5000079416E+00, 3.6174227416E+01, 4.3669142708E+00, 9.8756339766E-01],
	[4.97750E+04, 5.1205307310E+01, 5.5000597506E+00, 3.6186210506E+01, 4.3671885215E+00, 9.8756891520E-01],
	[4.97800E+04, 5.1214518477E+01, 5.5001115549E+00, 3.6198196361E+01, 4.3674627090E+00, 9.8757443003E-01],
	[4.97850E+04, 5.1223730376E+01, 5.5001633545E+00, 3.6210184982E+01, 4.3677368332E+00, 9.8757994215E-01],
	[4.97900E+04, 5.1232943007E+01, 5.5002151494E+00, 3.6222176369E+01, 4.3680108941E+00, 9.8758545156E-01],
	[4.97950E+04, 5.1242156369E+01, 5.5002669396E+00, 3.6234170522E+01, 4.3682848919E+00, 9.8759095826E-01],
	[4.98000E+04, 5.1251370463E+01, 5.5003187251E+00, 3.6246167442E+01, 4.3685588264E+00, 9.8759646225E-01],
	[4.98050E+04, 5.1260585289E+01, 5.5003705059E+00, 3.6258167128E+01, 4.3688326977E+00, 9.8760196353E-01],
	[4.98100E+04, 5.1269800845E+01, 5.5004222819E+00, 3.6270169583E+01, 4.3691065059E+00, 9.8760746211E-01],
	[4.98150E+04, 5.1279017134E+01, 5.5004740533E+00, 3.6282174805E+01, 4.3693802509E+00, 9.8761295799E-01],
	[4.98200E+04, 5.1288234153E+01, 5.5005258199E+00, 3.6294182795E+01, 4.3696539328E+00, 9.8761845116E-01],
	[4.98250E+04, 5.1297451905E+01, 5.5005775818E+00, 3.6306193554E+01, 4.3699275515E+00, 9.8762394164E-01],
	[4.98300E+04, 5.1306670387E+01, 5.5006293390E+00, 3.6318207081E+01, 4.3702011072E+00, 9.8762942941E-01],
	[4.98350E+04, 5.1315889601E+01, 5.5006810915E+00, 3.6330223378E+01, 4.3704745997E+00, 9.8763491449E-01],
	[4.98400E+04, 5.1325109547E+01, 5.5007328393E+00, 3.6342242444E+01, 4.3707480292E+00, 9.8764039687E-01],
	[4.98450E+04, 5.1334330224E+01, 5.5007845824E+00, 3.6354264281E+01, 4.3710213957E+00, 9.8764587655E-01],
	[4.98500E+04, 5.1343551632E+01, 5.5008363208E+00, 3.6366288887E+01, 4.3712946991E+00, 9.8765135354E-01],
	[4.98550E+04, 5.1352773772E+01, 5.5008880545E+00, 3.6378316265E+01, 4.3715679395E+00, 9.8765682784E-01],
	[4.98600E+04, 5.1361996643E+01, 5.5009397835E+00, 3.6390346413E+01, 4.3718411169E+00, 9.8766229945E-01],
	[4.98650E+04, 5.1371220245E+01, 5.5009915078E+00, 3.6402379333E+01, 4.3721142313E+00, 9.8766776837E-01],
	[4.98700E+04, 5.1380444579E+01, 5.5010432274E+00, 3.6414415024E+01, 4.3723872827E+00, 9.8767323460E-01],
	[4.98750E+04, 5.1389669644E+01, 5.5010949423E+00, 3.6426453488E+01, 4.3726602712E+00, 9.8767869815E-01],
	[4.98800E+04, 5.1398895440E+01, 5.5011466525E+00, 3.6438494724E+01, 4.3729331968E+00, 9.8768415901E-01],
	[4.98850E+04, 5.1408121967E+01, 5.5011983580E+00, 3.6450538733E+01, 4.3732060595E+00, 9.8768961718E-01],
	[4.98900E+04, 5.1417349226E+01, 5.5012500588E+00, 3.6462585515E+01, 4.3734788593E+00, 9.8769507268E-01],
	[4.98950E+04, 5.1426577216E+01, 5.5013017549E+00, 3.6474635070E+01, 4.3737515962E+00, 9.8770052549E-01],
	[4.99000E+04, 5.1435805937E+01, 5.5013534463E+00, 3.6486687400E+01, 4.3740242702E+00, 9.8770597562E-01],
	[4.99050E+04, 5.1445035390E+01, 5.5014051330E+00, 3.6498742504E+01, 4.3742968814E+00, 9.8771142308E-01],
	[4.99100E+04, 5.1454265574E+01, 5.5014568151E+00, 3.6510800382E+01, 4.3745694298E+00, 9.8771686786E-01],
	[4.99150E+04, 5.1463496488E+01, 5.5015084924E+00, 3.6522861035E+01, 4.3748419154E+00, 9.8772230996E-01],
	[4.99200E+04, 5.1472728134E+01, 5.5015601650E+00, 3.6534924464E+01, 4.3751143382E+00, 9.8772774939E-01],
	[4.99250E+04, 5.1481960511E+01, 5.5016118330E+00, 3.6546990669E+01, 4.3753866982E+00, 9.8773318615E-01],
	[4.99300E+04, 5.1491193620E+01, 5.5016634963E+00, 3.6559059649E+01, 4.3756589955E+00, 9.8773862024E-01],
	[4.99350E+04, 5.1500427459E+01, 5.5017151548E+00, 3.6571131406E+01, 4.3759312300E+00, 9.8774405166E-01],
	[4.99400E+04, 5.1509662030E+01, 5.5017668087E+00, 3.6583205940E+01, 4.3762034018E+00, 9.8774948041E-01],
	[4.99450E+04, 5.1518897331E+01, 5.5018184579E+00, 3.6595283251E+01, 4.3764755110E+00, 9.8775490649E-01],
	[4.99500E+04, 5.1528133364E+01, 5.5018701024E+00, 3.6607363339E+01, 4.3767475574E+00, 9.8776032991E-01],
	[4.99550E+04, 5.1537370127E+01, 5.5019217423E+00, 3.6619446206E+01, 4.3770195412E+00, 9.8776575066E-01],
	[4.99600E+04, 5.1546607622E+01, 5.5019733774E+00, 3.6631531850E+01, 4.3772914623E+00, 9.8777116875E-01],
	[4.99650E+04, 5.1555845848E+01, 5.5020250079E+00, 3.6643620273E+01, 4.3775633208E+00, 9.8777658418E-01],
	[4.99700E+04, 5.1565084805E+01, 5.5020766337E+00, 3.6655711475E+01, 4.3778351167E+00, 9.8778199695E-01],
	[4.99750E+04, 5.1574324492E+01, 5.5021282548E+00, 3.6667805457E+01, 4.3781068500E+00, 9.8778740707E-01],
	[4.99800E+04, 5.1583564911E+01, 5.5021798712E+00, 3.6679902218E+01, 4.3783785207E+00, 9.8779281452E-01],
	[4.99850E+04, 5.1592806061E+01, 5.5022314829E+00, 3.6692001759E+01, 4.3786501289E+00, 9.8779821932E-01],
	[4.99900E+04, 5.1602047942E+01, 5.5022830900E+00, 3.6704104081E+01, 4.3789216745E+00, 9.8780362147E-01],
	[4.99950E+04, 5.1611290553E+01, 5.5023346924E+00, 3.6716209183E+01, 4.3791931576E+00, 9.8780902097E-01],
	[5.00000E+04, 5.1620533896E+01, 5.5023862901E+00, 3.6728317066E+01, 4.3794645782E+00, 9.8781441781E-01],
	[5.00050E+04, 5.1629777969E+01, 5.5024378831E+00, 3.6740431638E+01, 4.3797359918E+00, 9.8781981200E-01],
	[5.00100E+04, 5.1639022773E+01, 5.5024894715E+00, 3.6752548994E+01, 4.3800073430E+00, 9.8782520355E-01],
	[5.00150E+04, 5.1648268309E+01, 5.5025410552E+00, 3.6764669134E+01, 4.3802786316E+00, 9.8783059245E-01],
	[5.00200E+04, 5.1657514575E+01, 5.5025926342E+00, 3.6776792058E+01, 4.3805498578E+00, 9.8783597870E-01],
	[5.00250E+04, 5.1666761571E+01, 5.5026442085E+00, 3.6788917768E+01, 4.3808210215E+00, 9.8784136231E-01],
	[5.00300E+04, 5.1676009299E+01, 5.5026957782E+00, 3.6801046264E+01, 4.3810921228E+00, 9.8784674327E-01],
	[5.00350E+04, 5.1685257758E+01, 5.5027473432E+00, 3.6813177545E+01, 4.3813631617E+00, 9.8785212160E-01],
	[5.00400E+04, 5.1694506947E+01, 5.5027989035E+00, 3.6825311612E+01, 4.3816341382E+00, 9.8785749728E-01],
	[5.00450E+04, 5.1703756867E+01, 5.5028504592E+00, 3.6837448466E+01, 4.3819050523E+00, 9.8786287033E-01],
	[5.00500E+04, 5.1713007518E+01, 5.5029020102E+00, 3.6849588107E+01, 4.3821759040E+00, 9.8786824074E-01],
	[5.00550E+04, 5.1722258900E+01, 5.5029535565E+00, 3.6861730535E+01, 4.3824466935E+00, 9.8787360852E-01],
	[5.00600E+04, 5.1731511012E+01, 5.5030050982E+00, 3.6873875751E+01, 4.3827174205E+00, 9.8787897366E-01],
	[5.00650E+04, 5.1740763855E+01, 5.5030566352E+00, 3.6886023755E+01, 4.3829880853E+00, 9.8788433616E-01],
	[5.00700E+04, 5.1750017429E+01, 5.5031081675E+00, 3.6898174547E+01, 4.3832586878E+00, 9.8788969604E-01],
	[5.00750E+04, 5.1759271733E+01, 5.5031596952E+00, 3.6910328128E+01, 4.3835292280E+00, 9.8789505328E-01],
	[5.00800E+04, 5.1768526768E+01, 5.5032112182E+00, 3.6922484498E+01, 4.3837997060E+00, 9.8790040790E-01],
	[5.00850E+04, 5.1777782534E+01, 5.5032627365E+00, 3.6934643658E+01, 4.3840701217E+00, 9.8790575989E-01],
	[5.00900E+04, 5.1787039031E+01, 5.5033142502E+00, 3.6946805607E+01, 4.3843404752E+00, 9.8791110926E-01],
	[5.00950E+04, 5.1796296258E+01, 5.5033657592E+00, 3.6958970346E+01, 4.3846107665E+00, 9.8791645600E-01],
	[5.01000E+04, 5.1805554215E+01, 5.5034172636E+00, 3.6971137876E+01, 4.3848809956E+00, 9.8792180011E-01],
	[5.01050E+04, 5.1814812904E+01, 5.5034687633E+00, 3.6983308197E+01, 4.3851511626E+00, 9.8792714161E-01],
	[5.01100E+04, 5.1824072322E+01, 5.5035202583E+00, 3.6995481309E+01, 4.3854212674E+00, 9.8793248048E-01],
	[5.01150E+04, 5.1833332472E+01, 5.5035717487E+00, 3.7007657213E+01, 4.3856913100E+00, 9.8793781674E-01],
	[5.01200E+04, 5.1842593352E+01, 5.5036232345E+00, 3.7019835909E+01, 4.3859612906E+00, 9.8794315038E-01],
	[5.01250E+04, 5.1851854962E+01, 5.5036747156E+00, 3.7032017397E+01, 4.3862312090E+00, 9.8794848140E-01],
	[5.01300E+04, 5.1861117303E+01, 5.5037261920E+00, 3.7044201678E+01, 4.3865010654E+00, 9.8795380981E-01],
	[5.01350E+04, 5.1870380375E+01, 5.5037776638E+00, 3.7056388751E+01, 4.3867708597E+00, 9.8795913560E-01],
	[5.01400E+04, 5.1879644177E+01, 5.5038291309E+00, 3.7068578619E+01, 4.3870405920E+00, 9.8796445879E-01],
	[5.01450E+04, 5.1888908709E+01, 5.5038805934E+00, 3.7080771280E+01, 4.3873102622E+00, 9.8796977936E-01],
	[5.01500E+04, 5.1898173972E+01, 5.5039320512E+00, 3.7092966735E+01, 4.3875798704E+00, 9.8797509733E-01],
	[5.01550E+04, 5.1907439966E+01, 5.5039835044E+00, 3.7105164985E+01, 4.3878494166E+00, 9.8798041268E-01],
	[5.01600E+04, 5.1916706690E+01, 5.5040349529E+00, 3.7117366029E+01, 4.3881189009E+00, 9.8798572543E-01],
	[5.01650E+04, 5.1925974144E+01, 5.5040863968E+00, 3.7129569869E+01, 4.3883883232E+00, 9.8799103558E-01],
	[5.01700E+04, 5.1935242328E+01, 5.5041378360E+00, 3.7141776505E+01, 4.3886576835E+00, 9.8799634312E-01],
	[5.01750E+04, 5.1944511244E+01, 5.5041892706E+00, 3.7153985936E+01, 4.3889269820E+00, 9.8800164806E-01],
	[5.01800E+04, 5.1953780889E+01, 5.5042407005E+00, 3.7166198164E+01, 4.3891962185E+00, 9.8800695040E-01],
	[5.01850E+04, 5.1963051265E+01, 5.5042921258E+00, 3.7178413188E+01, 4.3894653931E+00, 9.8801225014E-01],
	[5.01900E+04, 5.1972322371E+01, 5.5043435465E+00, 3.7190631010E+01, 4.3897345058E+00, 9.8801754728E-01],
	[5.01950E+04, 5.1981594207E+01, 5.5043949625E+00, 3.7202851628E+01, 4.3900035567E+00, 9.8802284183E-01],
	[5.02000E+04, 5.1990866774E+01, 5.5044463739E+00, 3.7215075045E+01, 4.3902725458E+00, 9.8802813378E-01],
	[5.02050E+04, 5.2000140071E+01, 5.5044977806E+00, 3.7227301260E+01, 4.3905414730E+00, 9.8803342314E-01],
	[5.02100E+04, 5.2009414098E+01, 5.5045491827E+00, 3.7239530273E+01, 4.3908103385E+00, 9.8803870990E-01],
	[5.02150E+04, 5.2018688856E+01, 5.5046005802E+00, 3.7251762085E+01, 4.3910791421E+00, 9.8804399408E-01],
	[5.02200E+04, 5.2027964344E+01, 5.5046519730E+00, 3.7263996697E+01, 4.3913478840E+00, 9.8804927566E-01],
	[5.02250E+04, 5.2037240562E+01, 5.5047033612E+00, 3.7276234107E+01, 4.3916165641E+00, 9.8805455466E-01],
	[5.02300E+04, 5.2046517510E+01, 5.5047547447E+00, 3.7288474318E+01, 4.3918851825E+00, 9.8805983107E-01],
	[5.02350E+04, 5.2055795188E+01, 5.5048061236E+00, 3.7300717329E+01, 4.3921537392E+00, 9.8806510490E-01],
	[5.02400E+04, 5.2065073597E+01, 5.5048574979E+00, 3.7312963141E+01, 4.3924222342E+00, 9.8807037614E-01],
	[5.02450E+04, 5.2074352736E+01, 5.5049088675E+00, 3.7325211754E+01, 4.3926906675E+00, 9.8807564480E-01],
	[5.02500E+04, 5.2083632605E+01, 5.5049602325E+00, 3.7337463168E+01, 4.3929590391E+00, 9.8808091087E-01],
	[5.02550E+04, 5.2092913204E+01, 5.5050115929E+00, 3.7349717384E+01, 4.3932273491E+00, 9.8808617437E-01],
	[5.02600E+04, 5.2102194533E+01, 5.5050629487E+00, 3.7361974402E+01, 4.3934955975E+00, 9.8809143529E-01],
	[5.02650E+04, 5.2111476593E+01, 5.5051142998E+00, 3.7374234223E+01, 4.3937637842E+00, 9.8809669364E-01],
	[5.02700E+04, 5.2120759382E+01, 5.5051656463E+00, 3.7386496846E+01, 4.3940319094E+00, 9.8810194940E-01],
	[5.02750E+04, 5.2130042902E+01, 5.5052169881E+00, 3.7398762273E+01, 4.3942999730E+00, 9.8810720260E-01],
	[5.02800E+04, 5.2139327151E+01, 5.5052683254E+00, 3.7411030503E+01, 4.3945679750E+00, 9.8811245322E-01],
	[5.02850E+04, 5.2148612131E+01, 5.5053196580E+00, 3.7423301537E+01, 4.3948359154E+00, 9.8811770127E-01],
	[5.02900E+04, 5.2157897840E+01, 5.5053709860E+00, 3.7435575375E+01, 4.3951037944E+00, 9.8812294674E-01],
	[5.02950E+04, 5.2167184280E+01, 5.5054223093E+00, 3.7447852018E+01, 4.3953716118E+00, 9.8812818965E-01],
	[5.03000E+04, 5.2176471450E+01, 5.5054736280E+00, 3.7460131466E+01, 4.3956393677E+00, 9.8813343000E-01],
	[5.03050E+04, 5.2185759350E+01, 5.5055249422E+00, 3.7472413719E+01, 4.3959070622E+00, 9.8813866778E-01],
	[5.03100E+04, 5.2195047979E+01, 5.5055762516E+00, 3.7484698778E+01, 4.3961746952E+00, 9.8814390299E-01],
	[5.03150E+04, 5.2204337339E+01, 5.5056275565E+00, 3.7496986644E+01, 4.3964422668E+00, 9.8814913564E-01],
	[5.03200E+04, 5.2213627428E+01, 5.5056788568E+00, 3.7509277315E+01, 4.3967097769E+00, 9.8815436573E-01],
	[5.03250E+04, 5.2222918248E+01, 5.5057301524E+00, 3.7521570794E+01, 4.3969772257E+00, 9.8815959325E-01],
	[5.03300E+04, 5.2232209797E+01, 5.5057814434E+00, 3.7533867079E+01, 4.3972446130E+00, 9.8816481822E-01],
	[5.03350E+04, 5.2241502077E+01, 5.5058327298E+00, 3.7546166172E+01, 4.3975119390E+00, 9.8817004064E-01],
	[5.03400E+04, 5.2250795086E+01, 5.5058840116E+00, 3.7558468073E+01, 4.3977792036E+00, 9.8817526049E-01],
	[5.03450E+04, 5.2260088825E+01, 5.5059352887E+00, 3.7570772783E+01, 4.3980464069E+00, 9.8818047779E-01],
	[5.03500E+04, 5.2269383294E+01, 5.5059865613E+00, 3.7583080301E+01, 4.3983135489E+00, 9.8818569254E-01],
	[5.03550E+04, 5.2278678493E+01, 5.5060378292E+00, 3.7595390628E+01, 4.3985806296E+00, 9.8819090473E-01],
	[5.03600E+04, 5.2287974421E+01, 5.5060890925E+00, 3.7607703764E+01, 4.3988476489E+00, 9.8819611438E-01],
	[5.03650E+04, 5.2297271079E+01, 5.5061403512E+00, 3.7620019710E+01, 4.3991146070E+00, 9.8820132147E-01],
	[5.03700E+04, 5.2306568468E+01, 5.5061916053E+00, 3.7632338466E+01, 4.3993815039E+00, 9.8820652602E-01],
	[5.03750E+04, 5.2315866586E+01, 5.5062428548E+00, 3.7644660032E+01, 4.3996483395E+00, 9.8821172802E-01],
	[5.03800E+04, 5.2325165433E+01, 5.5062940997E+00, 3.7656984410E+01, 4.3999151140E+00, 9.8821692748E-01],
	[5.03850E+04, 5.2334465011E+01, 5.5063453400E+00, 3.7669311598E+01, 4.4001818272E+00, 9.8822212439E-01],
	[5.03900E+04, 5.2343765318E+01, 5.5063965756E+00, 3.7681641598E+01, 4.4004484792E+00, 9.8822731876E-01],
	[5.03950E+04, 5.2353066355E+01, 5.5064478067E+00, 3.7693974410E+01, 4.4007150701E+00, 9.8823251059E-01],
	[5.04000E+04, 5.2362368121E+01, 5.5064990331E+00, 3.7706310034E+01, 4.4009815998E+00, 9.8823769988E-01],
	[5.04050E+04, 5.2371670618E+01, 5.5065502550E+00, 3.7718648471E+01, 4.4012480684E+00, 9.8824288663E-01],
	[5.04100E+04, 5.2380973844E+01, 5.5066014722E+00, 3.7730989720E+01, 4.4015144759E+00, 9.8824807085E-01],
	[5.04150E+04, 5.2390277799E+01, 5.5066526848E+00, 3.7743333783E+01, 4.4017808223E+00, 9.8825325253E-01],
	[5.04200E+04, 5.2399582484E+01, 5.5067038929E+00, 3.7755680660E+01, 4.4020471076E+00, 9.8825843167E-01],
	[5.04250E+04, 5.2408887899E+01, 5.5067550963E+00, 3.7768030351E+01, 4.4023133318E+00, 9.8826360828E-01],
	[5.04300E+04, 5.2418194044E+01, 5.5068062951E+00, 3.7780382856E+01, 4.4025794950E+00, 9.8826878236E-01],
	[5.04350E+04, 5.2427500918E+01, 5.5068574894E+00, 3.7792738176E+01, 4.4028455972E+00, 9.8827395391E-01],
	[5.04400E+04, 5.2436808522E+01, 5.5069086790E+00, 3.7805096311E+01, 4.4031116383E+00, 9.8827912294E-01],
	[5.04450E+04, 5.2446116855E+01, 5.5069598640E+00, 3.7817457262E+01, 4.4033776185E+00, 9.8828428943E-01],
	[5.04500E+04, 5.2455425918E+01, 5.5070110444E+00, 3.7829821028E+01, 4.4036435377E+00, 9.8828945340E-01],
	[5.04550E+04, 5.2464735710E+01, 5.5070622203E+00, 3.7842187611E+01, 4.4039093959E+00, 9.8829461485E-01],
	[5.04600E+04, 5.2474046232E+01, 5.5071133915E+00, 3.7854557010E+01, 4.4041751932E+00, 9.8829977377E-01],
	[5.04650E+04, 5.2483357483E+01, 5.5071645582E+00, 3.7866929227E+01, 4.4044409296E+00, 9.8830493017E-01],
	[5.04700E+04, 5.2492669464E+01, 5.5072157202E+00, 3.7879304260E+01, 4.4047066050E+00, 9.8831008405E-01],
	[5.04750E+04, 5.2501982174E+01, 5.5072668777E+00, 3.7891682112E+01, 4.4049722196E+00, 9.8831523541E-01],
	[5.04800E+04, 5.2511295614E+01, 5.5073180305E+00, 3.7904062781E+01, 4.4052377733E+00, 9.8832038425E-01],
	[5.04850E+04, 5.2520609783E+01, 5.5073691788E+00, 3.7916446269E+01, 4.4055032661E+00, 9.8832553058E-01],
	[5.04900E+04, 5.2529924682E+01, 5.5074203225E+00, 3.7928832575E+01, 4.4057686981E+00, 9.8833067439E-01],
	[5.04950E+04, 5.2539240310E+01, 5.5074714616E+00, 3.7941221701E+01, 4.4060340693E+00, 9.8833581569E-01],
	[5.05000E+04, 5.2548556667E+01, 5.5075225961E+00, 3.7953613646E+01, 4.4062993797E+00, 9.8834095448E-01],
	[5.05050E+04, 5.2557873754E+01, 5.5075737260E+00, 3.7966008411E+01, 4.4065646293E+00, 9.8834609075E-01],
	[5.05100E+04, 5.2567191570E+01, 5.5076248514E+00, 3.7978405996E+01, 4.4068298181E+00, 9.8835122452E-01],
	[5.05150E+04, 5.2576510116E+01, 5.5076759721E+00, 3.7990806402E+01, 4.4070949461E+00, 9.8835635578E-01],
	[5.05200E+04, 5.2585829390E+01, 5.5077270883E+00, 3.8003209628E+01, 4.4073600135E+00, 9.8836148453E-01],
	[5.05250E+04, 5.2595149395E+01, 5.5077781998E+00, 3.8015615676E+01, 4.4076250201E+00, 9.8836661077E-01],
	[5.05300E+04, 5.2604470128E+01, 5.5078293068E+00, 3.8028024546E+01, 4.4078899660E+00, 9.8837173452E-01],
	[5.05350E+04, 5.2613791591E+01, 5.5078804092E+00, 3.8040436238E+01, 4.4081548512E+00, 9.8837685576E-01],
	[5.05400E+04, 5.2623113783E+01, 5.5079315071E+00, 3.8052850752E+01, 4.4084196757E+00, 9.8838197449E-01],
	[5.05450E+04, 5.2632436704E+01, 5.5079826003E+00, 3.8065268089E+01, 4.4086844396E+00, 9.8838709073E-01],
	[5.05500E+04, 5.2641760355E+01, 5.5080336890E+00, 3.8077688249E+01, 4.4089491429E+00, 9.8839220447E-01],
	[5.05550E+04, 5.2651084735E+01, 5.5080847731E+00, 3.8090111232E+01, 4.4092137856E+00, 9.8839731572E-01],
	[5.05600E+04, 5.2660409844E+01, 5.5081358526E+00, 3.8102537040E+01, 4.4094783676E+00, 9.8840242446E-01],
	[5.05650E+04, 5.2669735682E+01, 5.5081869275E+00, 3.8114965671E+01, 4.4097428891E+00, 9.8840753072E-01],
	[5.05700E+04, 5.2679062249E+01, 5.5082379979E+00, 3.8127397127E+01, 4.4100073500E+00, 9.8841263448E-01],
	[5.05750E+04, 5.2688389546E+01, 5.5082890636E+00, 3.8139831408E+01, 4.4102717503E+00, 9.8841773574E-01],
	[5.05800E+04, 5.2697717572E+01, 5.5083401249E+00, 3.8152268514E+01, 4.4105360901E+00, 9.8842283452E-01],
	[5.05850E+04, 5.2707046327E+01, 5.5083911815E+00, 3.8164708446E+01, 4.4108003694E+00, 9.8842793081E-01],
	[5.05900E+04, 5.2716375811E+01, 5.5084422335E+00, 3.8177151204E+01, 4.4110645882E+00, 9.8843302461E-01],
	[5.05950E+04, 5.2725706024E+01, 5.5084932810E+00, 3.8189596789E+01, 4.4113287466E+00, 9.8843811593E-01],
	[5.06000E+04, 5.2735036966E+01, 5.5085443239E+00, 3.8202045200E+01, 4.4115928444E+00, 9.8844320476E-01],
	[5.06050E+04, 5.2744368637E+01, 5.5085953623E+00, 3.8214496438E+01, 4.4118568818E+00, 9.8844829111E-01],
	[5.06100E+04, 5.2753701038E+01, 5.5086463961E+00, 3.8226950504E+01, 4.4121208588E+00, 9.8845337497E-01],
	[5.06150E+04, 5.2763034167E+01, 5.5086974253E+00, 3.8239407397E+01, 4.4123847754E+00, 9.8845845635E-01],
	[5.06200E+04, 5.2772368025E+01, 5.5087484499E+00, 3.8251867119E+01, 4.4126486316E+00, 9.8846353526E-01],
	[5.06250E+04, 5.2781702613E+01, 5.5087994700E+00, 3.8264329669E+01, 4.4129124274E+00, 9.8846861169E-01],
	[5.06300E+04, 5.2791037929E+01, 5.5088504855E+00, 3.8276795048E+01, 4.4131761628E+00, 9.8847368563E-01],
	[5.06350E+04, 5.2800373975E+01, 5.5089014964E+00, 3.8289263257E+01, 4.4134398379E+00, 9.8847875711E-01],
	[5.06400E+04, 5.2809710749E+01, 5.5089525028E+00, 3.8301734295E+01, 4.4137034527E+00, 9.8848382611E-01],
	[5.06450E+04, 5.2819048253E+01, 5.5090035046E+00, 3.8314208163E+01, 4.4139670071E+00, 9.8848889264E-01],
	[5.06500E+04, 5.2828386485E+01, 5.5090545018E+00, 3.8326684861E+01, 4.4142305013E+00, 9.8849395669E-01],
	[5.06550E+04, 5.2837725446E+01, 5.5091054945E+00, 3.8339164390E+01, 4.4144939351E+00, 9.8849901828E-01],
	[5.06600E+04, 5.2847065136E+01, 5.5091564826E+00, 3.8351646751E+01, 4.4147573088E+00, 9.8850407740E-01],
	[5.06650E+04, 5.2856405556E+01, 5.5092074662E+00, 3.8364131942E+01, 4.4150206221E+00, 9.8850913405E-01],
	[5.06700E+04, 5.2865746704E+01, 5.5092584452E+00, 3.8376619966E+01, 4.4152838753E+00, 9.8851418823E-01],
	[5.06750E+04, 5.2875088580E+01, 5.5093094196E+00, 3.8389110822E+01, 4.4155470682E+00, 9.8851923995E-01],
	[5.06800E+04, 5.2884431186E+01, 5.5093603895E+00, 3.8401604510E+01, 4.4158102010E+00, 9.8852428921E-01],
	[5.06850E+04, 5.2893774521E+01, 5.5094113549E+00, 3.8414101031E+01, 4.4160732736E+00, 9.8852933600E-01],
	[5.06900E+04, 5.2903118584E+01, 5.5094623156E+00, 3.8426600386E+01, 4.4163362860E+00, 9.8853438034E-01],
	[5.06950E+04, 5.2912463376E+01, 5.5095132718E+00, 3.8439102574E+01, 4.4165992383E+00, 9.8853942221E-01],
	[5.07000E+04, 5.2921808897E+01, 5.5095642235E+00, 3.8451607596E+01, 4.4168621304E+00, 9.8854446163E-01],
	[5.07050E+04, 5.2931155147E+01, 5.5096151706E+00, 3.8464115452E+01, 4.4171249625E+00, 9.8854949860E-01],
	[5.07100E+04, 5.2940502125E+01, 5.5096661132E+00, 3.8476626144E+01, 4.4173877344E+00, 9.8855453311E-01],
	[5.07150E+04, 5.2949849833E+01, 5.5097170512E+00, 3.8489139670E+01, 4.4176504463E+00, 9.8855956519E-01],
	[5.07200E+04, 5.2959198269E+01, 5.5097679846E+00, 3.8501656032E+01, 4.4179130981E+00, 9.8856459482E-01],
	[5.07250E+04, 5.2968547433E+01, 5.5098189136E+00, 3.8514175229E+01, 4.4181756899E+00, 9.8856962200E-01],
	[5.07300E+04, 5.2977897327E+01, 5.5098698379E+00, 3.8526697263E+01, 4.4184382217E+00, 9.8857464675E-01],
	[5.07350E+04, 5.2987247949E+01, 5.5099207577E+00, 3.8539222133E+01, 4.4187006934E+00, 9.8857966906E-01],
	[5.07400E+04, 5.2996599300E+01, 5.5099716730E+00, 3.8551749840E+01, 4.4189631052E+00, 9.8858468892E-01],
	[5.07450E+04, 5.3005951379E+01, 5.5100225837E+00, 3.8564280385E+01, 4.4192254570E+00, 9.8858970635E-01],
	[5.07500E+04, 5.3015304187E+01, 5.5100734899E+00, 3.8576813767E+01, 4.4194877488E+00, 9.8859472134E-01],
	[5.07550E+04, 5.3024657724E+01, 5.5101243915E+00, 3.8589349987E+01, 4.4197499807E+00, 9.8859973390E-01],
	[5.07600E+04, 5.3034011989E+01, 5.5101752886E+00, 3.8601889045E+01, 4.4200121527E+00, 9.8860474402E-01],
	[5.07650E+04, 5.3043403389E+01, 5.5102299049E+00, 3.8614430942E+01, 4.4202769139E+00, 9.8860975170E-01],
	[5.07700E+04, 5.3052798781E+01, 5.5102848492E+00, 3.8626975678E+01, 4.4205418522E+00, 9.8861475696E-01],
	[5.07750E+04, 5.3062194911E+01, 5.5103397886E+00, 3.8639523254E+01, 4.4208067309E+00, 9.8861975978E-01],
	[5.07800E+04, 5.3071591780E+01, 5.5103947231E+00, 3.8652073669E+01, 4.4210715500E+00, 9.8862476017E-01],
	[5.07850E+04, 5.3080989388E+01, 5.5104496528E+00, 3.8664626925E+01, 4.4213363096E+00, 9.8862975814E-01],
	[5.07900E+04, 5.3090387734E+01, 5.5105045776E+00, 3.8677183021E+01, 4.4216010095E+00, 9.8863475368E-01],
	[5.07950E+04, 5.3099786819E+01, 5.5105594975E+00, 3.8689741958E+01, 4.4218656499E+00, 9.8863974679E-01],
	[5.08000E+04, 5.3109186642E+01, 5.5106144126E+00, 3.8702303736E+01, 4.4221302308E+00, 9.8864473747E-01],
	[5.08050E+04, 5.3118587204E+01, 5.5106693228E+00, 3.8714868356E+01, 4.4223947521E+00, 9.8864972573E-01],
	[5.08100E+04, 5.3127988505E+01, 5.5107242282E+00, 3.8727435818E+01, 4.4226592140E+00, 9.8865471157E-01],
	[5.08150E+04, 5.3137390544E+01, 5.5107791287E+00, 3.8740006122E+01, 4.4229236164E+00, 9.8865969498E-01],
	[5.08200E+04, 5.3146793322E+01, 5.5108340244E+00, 3.8752579269E+01, 4.4231879593E+00, 9.8866467598E-01],
	[5.08250E+04, 5.3156196838E+01, 5.5108889152E+00, 3.8765155259E+01, 4.4234522428E+00, 9.8866965455E-01],
	[5.08300E+04, 5.3165601093E+01, 5.5109438012E+00, 3.8777734092E+01, 4.4237164668E+00, 9.8867463071E-01],
	[5.08350E+04, 5.3175006086E+01, 5.5109986823E+00, 3.8790315770E+01, 4.4239806314E+00, 9.8867960445E-01],
	[5.08400E+04, 5.3184411818E+01, 5.5110535585E+00, 3.8802900291E+01, 4.4242447366E+00, 9.8868457577E-01],
	[5.08450E+04, 5.3193818288E+01, 5.5111084299E+00, 3.8815487657E+01, 4.4245087825E+00, 9.8868954468E-01],
	[5.08500E+04, 5.3203225497E+01, 5.5111632965E+00, 3.8828077868E+01, 4.4247727690E+00, 9.8869451117E-01],
	[5.08550E+04, 5.3212633444E+01, 5.5112181582E+00, 3.8840670924E+01, 4.4250366961E+00, 9.8869947525E-01],
	[5.08600E+04, 5.3222042129E+01, 5.5112730151E+00, 3.8853266825E+01, 4.4253005639E+00, 9.8870443692E-01],
	[5.08650E+04, 5.3231451554E+01, 5.5113278671E+00, 3.8865865573E+01, 4.4255643724E+00, 9.8870939618E-01],
	[5.08700E+04, 5.3240861716E+01, 5.5113827143E+00, 3.8878467167E+01, 4.4258281215E+00, 9.8871435303E-01],
	[5.08750E+04, 5.3250272617E+01, 5.5114375566E+00, 3.8891071608E+01, 4.4260918114E+00, 9.8871930747E-01],
	[5.08800E+04, 5.3259684256E+01, 5.5114923941E+00, 3.8903678895E+01, 4.4263554421E+00, 9.8872425950E-01],
	[5.08850E+04, 5.3269096633E+01, 5.5115472267E+00, 3.8916289030E+01, 4.4266190135E+00, 9.8872920913E-01],
	[5.08900E+04, 5.3278509749E+01, 5.5116020545E+00, 3.8928902013E+01, 4.4268825256E+00, 9.8873415636E-01],
	[5.08950E+04, 5.3287923604E+01, 5.5116568774E+00, 3.8941517844E+01, 4.4271459785E+00, 9.8873910117E-01],
	[5.09000E+04, 5.3297338196E+01, 5.5117116955E+00, 3.8954136524E+01, 4.4274093723E+00, 9.8874404359E-01],
	[5.09050E+04, 5.3306753527E+01, 5.5117665088E+00, 3.8966758053E+01, 4.4276727068E+00, 9.8874898361E-01],
	[5.09100E+04, 5.3316169596E+01, 5.5118213173E+00, 3.8979382430E+01, 4.4279359822E+00, 9.8875392122E-01],
	[5.09150E+04, 5.3325586404E+01, 5.5118761208E+00, 3.8992009658E+01, 4.4281991985E+00, 9.8875885644E-01],
	[5.09200E+04, 5.3335003949E+01, 5.5119309196E+00, 3.9004639735E+01, 4.4284623556E+00, 9.8876378926E-01],
	[5.09250E+04, 5.3344422233E+01, 5.5119857135E+00, 3.9017272663E+01, 4.4287254535E+00, 9.8876871968E-01],
	[5.09300E+04, 5.3353841255E+01, 5.5120405026E+00, 3.9029908441E+01, 4.4289884924E+00, 9.8877364770E-01],
	[5.09350E+04, 5.3363261016E+01, 5.5120952869E+00, 3.9042547070E+01, 4.4292514722E+00, 9.8877857334E-01],
	[5.09400E+04, 5.3372681514E+01, 5.5121500663E+00, 3.9055188551E+01, 4.4295143930E+00, 9.8878349657E-01],
	[5.09450E+04, 5.3382102751E+01, 5.5122048409E+00, 3.9067832884E+01, 4.4297772547E+00, 9.8878841742E-01],
	[5.09500E+04, 5.3391524726E+01, 5.5122596106E+00, 3.9080480069E+01, 4.4300400573E+00, 9.8879333587E-01],
	[5.09550E+04, 5.3400947439E+01, 5.5123143756E+00, 3.9093130106E+01, 4.4303028009E+00, 9.8879825194E-01],
	[5.09600E+04, 5.3410370890E+01, 5.5123691357E+00, 3.9105782996E+01, 4.4305654856E+00, 9.8880316561E-01],
	[5.09650E+04, 5.3419795079E+01, 5.5124238909E+00, 3.9118438740E+01, 4.4308281112E+00, 9.8880807690E-01],
	[5.09700E+04, 5.3429220007E+01, 5.5124786414E+00, 3.9131097337E+01, 4.4310906779E+00, 9.8881298581E-01],
	[5.09750E+04, 5.3438645672E+01, 5.5125333870E+00, 3.9143758788E+01, 4.4313531856E+00, 9.8881789232E-01],
	[5.09800E+04, 5.3448072076E+01, 5.5125881278E+00, 3.9156423093E+01, 4.4316156344E+00, 9.8882279645E-01],
	[5.09850E+04, 5.3457499218E+01, 5.5126428637E+00, 3.9169090253E+01, 4.4318780243E+00, 9.8882769820E-01],
	[5.09900E+04, 5.3466927097E+01, 5.5126975949E+00, 3.9181760268E+01, 4.4321403553E+00, 9.8883259757E-01],
	[5.09950E+04, 5.3476355715E+01, 5.5127523212E+00, 3.9194433139E+01, 4.4324026274E+00, 9.8883749456E-01],
	[5.10000E+04, 5.3485785071E+01, 5.5128070427E+00, 3.9207108865E+01, 4.4326648406E+00, 9.8884238917E-01],
	[5.10050E+04, 5.3495215165E+01, 5.5128617594E+00, 3.9219787447E+01, 4.4329269950E+00, 9.8884728140E-01],
	[5.10100E+04, 5.3504645997E+01, 5.5129164712E+00, 3.9232468886E+01, 4.4331890905E+00, 9.8885217125E-01],
	[5.10150E+04, 5.3514077566E+01, 5.5129711782E+00, 3.9245153182E+01, 4.4334511272E+00, 9.8885705872E-01],
	[5.10200E+04, 5.3523509874E+01, 5.5130258804E+00, 3.9257840335E+01, 4.4337131051E+00, 9.8886194382E-01],
	[5.10250E+04, 5.3532942920E+01, 5.5130805778E+00, 3.9270530346E+01, 4.4339750243E+00, 9.8886682655E-01],
	[5.10300E+04, 5.3542376703E+01, 5.5131352704E+00, 3.9283223214E+01, 4.4342368846E+00, 9.8887170691E-01],
	[5.10350E+04, 5.3551811225E+01, 5.5131899582E+00, 3.9295918941E+01, 4.4344986862E+00, 9.8887658489E-01],
	[5.10400E+04, 5.3561246484E+01, 5.5132446411E+00, 3.9308617527E+01, 4.4347604291E+00, 9.8888146050E-01],
	[5.10450E+04, 5.3570682482E+01, 5.5132993193E+00, 3.9321318972E+01, 4.4350221132E+00, 9.8888633374E-01],
	[5.10500E+04, 5.3580119217E+01, 5.5133539926E+00, 3.9334023276E+01, 4.4352837387E+00, 9.8889120462E-01],
	[5.10550E+04, 5.3589556690E+01, 5.5134086611E+00, 3.9346730440E+01, 4.4355453054E+00, 9.8889607313E-01],
	[5.10600E+04, 5.3598994901E+01, 5.5134633248E+00, 3.9359440464E+01, 4.4358068135E+00, 9.8890093927E-01],
	[5.10650E+04, 5.3608433850E+01, 5.5135179837E+00, 3.9372153348E+01, 4.4360682629E+00, 9.8890580305E-01],
	[5.10700E+04, 5.3617873536E+01, 5.5135726377E+00, 3.9384869094E+01, 4.4363296537E+00, 9.8891066446E-01],
	[5.10750E+04, 5.3627313961E+01, 5.5136272870E+00, 3.9397587701E+01, 4.4365909859E+00, 9.8891552351E-01],
	[5.10800E+04, 5.3636755123E+01, 5.5136819315E+00, 3.9410309169E+01, 4.4368522594E+00, 9.8892038020E-01],
	[5.10850E+04, 5.3646197023E+01, 5.5137365711E+00, 3.9423033499E+01, 4.4371134744E+00, 9.8892523453E-01],
	[5.10900E+04, 5.3655639661E+01, 5.5137912059E+00, 3.9435760692E+01, 4.4373746308E+00, 9.8893008650E-01],
	[5.10950E+04, 5.3665083036E+01, 5.5138458360E+00, 3.9448490747E+01, 4.4376357286E+00, 9.8893493612E-01],
	[5.11000E+04, 5.3674527149E+01, 5.5139004612E+00, 3.9461223665E+01, 4.4378967679E+00, 9.8893978337E-01],
	[5.11050E+04, 5.3683972000E+01, 5.5139550816E+00, 3.9473959447E+01, 4.4381577487E+00, 9.8894462828E-01],
	[5.11100E+04, 5.3693417589E+01, 5.5140096973E+00, 3.9486698093E+01, 4.4384186710E+00, 9.8894947082E-01],
	[5.11150E+04, 5.3702863915E+01, 5.5140643081E+00, 3.9499439602E+01, 4.4386795348E+00, 9.8895431102E-01],
	[5.11200E+04, 5.3712310979E+01, 5.5141189141E+00, 3.9512183977E+01, 4.4389403401E+00, 9.8895914886E-01],
	[5.11250E+04, 5.3721758781E+01, 5.5141735153E+00, 3.9524931216E+01, 4.4392010869E+00, 9.8896398435E-01],
	[5.11300E+04, 5.3731207320E+01, 5.5142281118E+00, 3.9537681320E+01, 4.4394617753E+00, 9.8896881749E-01],
	[5.11350E+04, 5.3740656597E+01, 5.5142827034E+00, 3.9550434290E+01, 4.4397224053E+00, 9.8897364828E-01],
	[5.11400E+04, 5.3750106612E+01, 5.5143372902E+00, 3.9563190126E+01, 4.4399829769E+00, 9.8897847673E-01],
	[5.11450E+04, 5.3759557364E+01, 5.5143918723E+00, 3.9575948828E+01, 4.4402434900E+00, 9.8898330283E-01],
	[5.11500E+04, 5.3769008854E+01, 5.5144464495E+00, 3.9588710397E+01, 4.4405039448E+00, 9.8898812658E-01],
	[5.11550E+04, 5.3778461081E+01, 5.5145010219E+00, 3.9601474833E+01, 4.4407643413E+00, 9.8899294799E-01],
	[5.11600E+04, 5.3787914046E+01, 5.5145555896E+00, 3.9614242136E+01, 4.4410246794E+00, 9.8899776706E-01],
	[5.11650E+04, 5.3797367748E+01, 5.5146101524E+00, 3.9627012307E+01, 4.4412849592E+00, 9.8900258378E-01],
	[5.11700E+04, 5.3806822188E+01, 5.5146647105E+00, 3.9639785347E+01, 4.4415451806E+00, 9.8900739817E-01],
	[5.11750E+04, 5.3816277366E+01, 5.5147192638E+00, 3.9652561255E+01, 4.4418053438E+00, 9.8901221021E-01],
	[5.11800E+04, 5.3825733281E+01, 5.5147738123E+00, 3.9665340031E+01, 4.4420654487E+00, 9.8901701992E-01],
	[5.11850E+04, 5.3835189933E+01, 5.5148283560E+00, 3.9678121677E+01, 4.4423254953E+00, 9.8902182729E-01],
	[5.11900E+04, 5.3844647323E+01, 5.5148828949E+00, 3.9690906193E+01, 4.4425854837E+00, 9.8902663232E-01],
	[5.11950E+04, 5.3854105451E+01, 5.5149374290E+00, 3.9703693578E+01, 4.4428454138E+00, 9.8903143502E-01],
	[5.12000E+04, 5.3863564315E+01, 5.5149919583E+00, 3.9716483834E+01, 4.4431052858E+00, 9.8903623538E-01],
	[5.12050E+04, 5.3873023918E+01, 5.5150464829E+00, 3.9729276961E+01, 4.4433650995E+00, 9.8904103342E-01],
	[5.12100E+04, 5.3882484257E+01, 5.5151010026E+00, 3.9742072958E+01, 4.4436248551E+00, 9.8904582912E-01],
	[5.12150E+04, 5.3891945334E+01, 5.5151555176E+00, 3.9754871827E+01, 4.4438845525E+00, 9.8905062249E-01],
	[5.12200E+04, 5.3901407149E+01, 5.5152100278E+00, 3.9767673568E+01, 4.4441441917E+00, 9.8905541353E-01],
	[5.12250E+04, 5.3910869701E+01, 5.5152645332E+00, 3.9780478181E+01, 4.4444037729E+00, 9.8906020224E-01],
	[5.12300E+04, 5.3920332990E+01, 5.5153190338E+00, 3.9793285667E+01, 4.4446632959E+00, 9.8906498863E-01],
	[5.12350E+04, 5.3929797016E+01, 5.5153735297E+00, 3.9806096025E+01, 4.4449227608E+00, 9.8906977269E-01],
	[5.12400E+04, 5.3939261780E+01, 5.5154280207E+00, 3.9818909257E+01, 4.4451821676E+00, 9.8907455442E-01],
	[5.12450E+04, 5.3948727281E+01, 5.5154825070E+00, 3.9831725362E+01, 4.4454415164E+00, 9.8907933384E-01],
	[5.12500E+04, 5.3958193520E+01, 5.5155369886E+00, 3.9844544341E+01, 4.4457008071E+00, 9.8908411093E-01],
	[5.12550E+04, 5.3967660495E+01, 5.5155914653E+00, 3.9857366195E+01, 4.4459600397E+00, 9.8908888570E-01],
	[5.12600E+04, 5.3977128208E+01, 5.5156459372E+00, 3.9870190923E+01, 4.4462192144E+00, 9.8909365815E-01],
	[5.12650E+04, 5.3986596659E+01, 5.5157004044E+00, 3.9883018526E+01, 4.4464783311E+00, 9.8909842828E-01],
	[5.12700E+04, 5.3996065846E+01, 5.5157548668E+00, 3.9895849005E+01, 4.4467373897E+00, 9.8910319609E-01],
	[5.12750E+04, 5.4005535771E+01, 5.5158093245E+00, 3.9908682360E+01, 4.4469963904E+00, 9.8910796159E-01],
	[5.12800E+04, 5.4015006433E+01, 5.5158637773E+00, 3.9921518590E+01, 4.4472553332E+00, 9.8911272477E-01],
	[5.12850E+04, 5.4024477832E+01, 5.5159182254E+00, 3.9934357698E+01, 4.4475142180E+00, 9.8911748563E-01],
	[5.12900E+04, 5.4033949968E+01, 5.5159726688E+00, 3.9947199682E+01, 4.4477730449E+00, 9.8912224419E-01],
	[5.12950E+04, 5.4043422841E+01, 5.5160271073E+00, 3.9960044543E+01, 4.4480318139E+00, 9.8912700043E-01],
	[5.13000E+04, 5.4052896452E+01, 5.5160815411E+00, 3.9972892282E+01, 4.4482905250E+00, 9.8913175436E-01],
	[5.13050E+04, 5.4062370800E+01, 5.5161359701E+00, 3.9985742899E+01, 4.4485491782E+00, 9.8913650598E-01],
	[5.13100E+04, 5.4071845885E+01, 5.5161903944E+00, 3.9998596394E+01, 4.4488077736E+00, 9.8914125529E-01],
	[5.13150E+04, 5.4081321707E+01, 5.5162448138E+00, 4.0011452768E+01, 4.4490663112E+00, 9.8914600230E-01],
	[5.13200E+04, 5.4090798266E+01, 5.5162992286E+00, 4.0024312021E+01, 4.4493247909E+00, 9.8915074700E-01],
	[5.13250E+04, 5.4100275562E+01, 5.5163536385E+00, 4.0037174154E+01, 4.4495832128E+00, 9.8915548939E-01],
	[5.13300E+04, 5.4109753595E+01, 5.5164080437E+00, 4.0050039166E+01, 4.4498415769E+00, 9.8916022948E-01],
	[5.13350E+04, 5.4119232365E+01, 5.5164624441E+00, 4.0062907058E+01, 4.4500998833E+00, 9.8916496726E-01],
	[5.13400E+04, 5.4128711873E+01, 5.5165168398E+00, 4.0075777831E+01, 4.4503581319E+00, 9.8916970275E-01],
	[5.13450E+04, 5.4138192117E+01, 5.5165712307E+00, 4.0088651485E+01, 4.4506163227E+00, 9.8917443593E-01],
	[5.13500E+04, 5.4147673098E+01, 5.5166256168E+00, 4.0101528020E+01, 4.4508744558E+00, 9.8917916682E-01],
	[5.13550E+04, 5.4157154817E+01, 5.5166799982E+00, 4.0114407437E+01, 4.4511325313E+00, 9.8918389541E-01],
	[5.13600E+04, 5.4166637272E+01, 5.5167343748E+00, 4.0127289736E+01, 4.4513905490E+00, 9.8918862169E-01],
	[5.13650E+04, 5.4176120464E+01, 5.5167887467E+00, 4.0140174917E+01, 4.4516485090E+00, 9.8919334569E-01],
	[5.13700E+04, 5.4185604393E+01, 5.5168431138E+00, 4.0153062980E+01, 4.4519064114E+00, 9.8919806739E-01],
	[5.13750E+04, 5.4195089059E+01, 5.5168974762E+00, 4.0165953927E+01, 4.4521642562E+00, 9.8920278679E-01],
	[5.13800E+04, 5.4204574462E+01, 5.5169518338E+00, 4.0178847757E+01, 4.4524220433E+00, 9.8920750390E-01],
	[5.13850E+04, 5.4214060602E+01, 5.5170061866E+00, 4.0191744472E+01, 4.4526797728E+00, 9.8921221872E-01],
	[5.13900E+04, 5.4223547479E+01, 5.5170605347E+00, 4.0204644070E+01, 4.4529374447E+00, 9.8921693125E-01],
	[5.13950E+04, 5.4233035093E+01, 5.5171148781E+00, 4.0217546553E+01, 4.4531950590E+00, 9.8922164150E-01],
	[5.14000E+04, 5.4242523444E+01, 5.5171692166E+00, 4.0230451920E+01, 4.4534526158E+00, 9.8922634945E-01],
	[5.14050E+04, 5.4252012531E+01, 5.5172235505E+00, 4.0243360173E+01, 4.4537101150E+00, 9.8923105512E-01],
	[5.14100E+04, 5.4261502355E+01, 5.5172778796E+00, 4.0256271312E+01, 4.4539675567E+00, 9.8923575850E-01],
	[5.14150E+04, 5.4270992916E+01, 5.5173322039E+00, 4.0269185336E+01, 4.4542249409E+00, 9.8924045959E-01],
	[5.14200E+04, 5.4280484214E+01, 5.5173865235E+00, 4.0282102247E+01, 4.4544822676E+00, 9.8924515841E-01],
	[5.14250E+04, 5.4289976249E+01, 5.5174408383E+00, 4.0295022045E+01, 4.4547395368E+00, 9.8924985494E-01],
	[5.14300E+04, 5.4299469020E+01, 5.5174951484E+00, 4.0307944730E+01, 4.4549967485E+00, 9.8925454919E-01],
	[5.14350E+04, 5.4308962529E+01, 5.5175494538E+00, 4.0320870302E+01, 4.4552539028E+00, 9.8925924115E-01],
	[5.14400E+04, 5.4318456774E+01, 5.5176037544E+00, 4.0333798762E+01, 4.4555109996E+00, 9.8926393084E-01],
	[5.14450E+04, 5.4327951755E+01, 5.5176580503E+00, 4.0346730110E+01, 4.4557680391E+00, 9.8926861826E-01],
	[5.14500E+04, 5.4337447474E+01, 5.5177123414E+00, 4.0359664346E+01, 4.4560250211E+00, 9.8927330339E-01],
	[5.14550E+04, 5.4346943929E+01, 5.5177666278E+00, 4.0372601472E+01, 4.4562819457E+00, 9.8927798625E-01],
	[5.14600E+04, 5.4356441121E+01, 5.5178209094E+00, 4.0385541487E+01, 4.4565388130E+00, 9.8928266684E-01],
	[5.14650E+04, 5.4365939049E+01, 5.5178751863E+00, 4.0398484391E+01, 4.4567956229E+00, 9.8928734515E-01],
	[5.14700E+04, 5.4375437714E+01, 5.5179294585E+00, 4.0411430186E+01, 4.4570523755E+00, 9.8929202119E-01],
	[5.14750E+04, 5.4384937116E+01, 5.5179837259E+00, 4.0424378871E+01, 4.4573090708E+00, 9.8929669496E-01],
	[5.14800E+04, 5.4394437254E+01, 5.5180379886E+00, 4.0437330446E+01, 4.4575657087E+00, 9.8930136646E-01],
	[5.14850E+04, 5.4403938129E+01, 5.5180922465E+00, 4.0450284913E+01, 4.4578222894E+00, 9.8930603570E-01],
	[5.14900E+04, 5.4413439741E+01, 5.5181464998E+00, 4.0463242271E+01, 4.4580788128E+00, 9.8931070266E-01],
	[5.14950E+04, 5.4422942089E+01, 5.5182007482E+00, 4.0476202521E+01, 4.4583352789E+00, 9.8931536736E-01],
	[5.15000E+04, 5.4432445174E+01, 5.5182549920E+00, 4.0489165663E+01, 4.4585916878E+00, 9.8932002979E-01],
	[5.15050E+04, 5.4441948995E+01, 5.5183092310E+00, 4.0502131698E+01, 4.4588480395E+00, 9.8932468996E-01],
	[5.15100E+04, 5.4451453553E+01, 5.5183634653E+00, 4.0515100625E+01, 4.4591043339E+00, 9.8932934786E-01],
	[5.15150E+04, 5.4460958848E+01, 5.5184176948E+00, 4.0528072446E+01, 4.4593605712E+00, 9.8933400351E-01],
	[5.15200E+04, 5.4470464879E+01, 5.5184719196E+00, 4.0541047161E+01, 4.4596167513E+00, 9.8933865689E-01],
	[5.15250E+04, 5.4479971646E+01, 5.5185261397E+00, 4.0554024769E+01, 4.4598728742E+00, 9.8934330801E-01],
	[5.15300E+04, 5.4489479150E+01, 5.5185803551E+00, 4.0567005272E+01, 4.4601289400E+00, 9.8934795688E-01],
	[5.15350E+04, 5.4498987391E+01, 5.5186345657E+00, 4.0579988670E+01, 4.4603849487E+00, 9.8935260348E-01],
	[5.15400E+04, 5.4508496367E+01, 5.5186887716E+00, 4.0592974962E+01, 4.4606409002E+00, 9.8935724784E-01],
	[5.15450E+04, 5.4518006081E+01, 5.5187429728E+00, 4.0605964151E+01, 4.4608967947E+00, 9.8936188993E-01],
	[5.15500E+04, 5.4527516530E+01, 5.5187971693E+00, 4.0618956235E+01, 4.4611526320E+00, 9.8936652978E-01],
	[5.15550E+04, 5.4537027717E+01, 5.5188513610E+00, 4.0631951215E+01, 4.4614084123E+00, 9.8937116736E-01],
	[5.15600E+04, 5.4546539639E+01, 5.5189055480E+00, 4.0644949092E+01, 4.4616641356E+00, 9.8937580270E-01],
	[5.15650E+04, 5.4556052298E+01, 5.5189597303E+00, 4.0657949865E+01, 4.4619198018E+00, 9.8938043579E-01],
	[5.15700E+04, 5.4565565693E+01, 5.5190139079E+00, 4.0670953536E+01, 4.4621754110E+00, 9.8938506663E-01],
	[5.15750E+04, 5.4575079825E+01, 5.5190680807E+00, 4.0683960105E+01, 4.4624309632E+00, 9.8938969522E-01],
	[5.15800E+04, 5.4584594693E+01, 5.5191222488E+00, 4.0696969572E+01, 4.4626864585E+00, 9.8939432156E-01],
	[5.15850E+04, 5.4594110297E+01, 5.5191764122E+00, 4.0709981937E+01, 4.4629418967E+00, 9.8939894566E-01],
	[5.15900E+04, 5.4603626638E+01, 5.5192305709E+00, 4.0722997201E+01, 4.4631972780E+00, 9.8940356751E-01],
	[5.15950E+04, 5.4613143715E+01, 5.5192847249E+00, 4.0736015363E+01, 4.4634526024E+00, 9.8940818712E-01],
	[5.16000E+04, 5.4622661528E+01, 5.5193388741E+00, 4.0749036426E+01, 4.4637078698E+00, 9.8941280449E-01],
	[5.16050E+04, 5.4632180078E+01, 5.5193930187E+00, 4.0762060388E+01, 4.4639630804E+00, 9.8941741961E-01],
	[5.16100E+04, 5.4641699363E+01, 5.5194471585E+00, 4.0775087250E+01, 4.4642182340E+00, 9.8942203250E-01],
	[5.16150E+04, 5.4651219385E+01, 5.5195012936E+00, 4.0788117013E+01, 4.4644733308E+00, 9.8942664314E-01],
	[5.16200E+04, 5.4660740144E+01, 5.5195554240E+00, 4.0801149677E+01, 4.4647283708E+00, 9.8943125155E-01],
	[5.16250E+04, 5.4670261638E+01, 5.5196095497E+00, 4.0814185243E+01, 4.4649833539E+00, 9.8943585772E-01],
	[5.16300E+04, 5.4679783869E+01, 5.5196636706E+00, 4.0827223710E+01, 4.4652382801E+00, 9.8944046166E-01],
	[5.16350E+04, 5.4689306836E+01, 5.5197177869E+00, 4.0840265078E+01, 4.4654931496E+00, 9.8944506336E-01],
	[5.16400E+04, 5.4698830539E+01, 5.5197718985E+00, 4.0853309350E+01, 4.4657479622E+00, 9.8944966282E-01],
	[5.16450E+04, 5.4708354978E+01, 5.5198260053E+00, 4.0866356524E+01, 4.4660027181E+00, 9.8945426006E-01],
	[5.16500E+04, 5.4717880153E+01, 5.5198801074E+00, 4.0879406601E+01, 4.4662574173E+00, 9.8945885506E-01],
	[5.16550E+04, 5.4727406064E+01, 5.5199342049E+00, 4.0892459582E+01, 4.4665120596E+00, 9.8946344784E-01],
	[5.16600E+04, 5.4736932712E+01, 5.5199882976E+00, 4.0905515466E+01, 4.4667666453E+00, 9.8946803838E-01],
	[5.16650E+04, 5.4746460096E+01, 5.5200423856E+00, 4.0918574255E+01, 4.4670211742E+00, 9.8947262670E-01],
	[5.16700E+04, 5.4755988215E+01, 5.5200964689E+00, 4.0931635949E+01, 4.4672756465E+00, 9.8947721279E-01],
	[5.16750E+04, 5.4765517071E+01, 5.5201505475E+00, 4.0944700547E+01, 4.4675300621E+00, 9.8948179665E-01],
	[5.16800E+04, 5.4775046663E+01, 5.5202046214E+00, 4.0957768050E+01, 4.4677844210E+00, 9.8948637829E-01],
	[5.16850E+04, 5.4784576991E+01, 5.5202586906E+00, 4.0970838460E+01, 4.4680387232E+00, 9.8949095771E-01],
	[5.16900E+04, 5.4794108055E+01, 5.5203127551E+00, 4.0983911775E+01, 4.4682929688E+00, 9.8949553490E-01],
	[5.16950E+04, 5.4803639855E+01, 5.5203668149E+00, 4.0996987997E+01, 4.4685471578E+00, 9.8950010988E-01],
	[5.17000E+04, 5.4813172390E+01, 5.5204208700E+00, 4.1010067125E+01, 4.4688012902E+00, 9.8950468263E-01],
	[5.17050E+04, 5.4822705662E+01, 5.5204749204E+00, 4.1023149161E+01, 4.4690553661E+00, 9.8950925317E-01],
	[5.17100E+04, 5.4832239670E+01, 5.5205289661E+00, 4.1036234104E+01, 4.4693093853E+00, 9.8951382149E-01],
	[5.17150E+04, 5.4841774414E+01, 5.5205830072E+00, 4.1049321955E+01, 4.4695633480E+00, 9.8951838759E-01],
	[5.17200E+04, 5.4851309894E+01, 5.5206370435E+00, 4.1062412715E+01, 4.4698172542E+00, 9.8952295147E-01],
	[5.17250E+04, 5.4860846109E+01, 5.5206910751E+00, 4.1075506383E+01, 4.4700711038E+00, 9.8952751314E-01],
	[5.17300E+04, 5.4870383061E+01, 5.5207451020E+00, 4.1088602959E+01, 4.4703248969E+00, 9.8953207260E-01],
	[5.17350E+04, 5.4879920749E+01, 5.5207991243E+00, 4.1101702446E+01, 4.4705786336E+00, 9.8953662985E-01],
	[5.17400E+04, 5.4889459172E+01, 5.5208531418E+00, 4.1114804841E+01, 4.4708323137E+00, 9.8954118489E-01],
	[5.17450E+04, 5.4898998331E+01, 5.5209071547E+00, 4.1127910147E+01, 4.4710859375E+00, 9.8954573771E-01],
	[5.17500E+04, 5.4908538226E+01, 5.5209611628E+00, 4.1141018364E+01, 4.4713395047E+00, 9.8955028833E-01],
	[5.17550E+04, 5.4918078857E+01, 5.5210151663E+00, 4.1154129491E+01, 4.4715930156E+00, 9.8955483674E-01],
	[5.17600E+04, 5.4927620224E+01, 5.5210691651E+00, 4.1167243529E+01, 4.4718464700E+00, 9.8955938294E-01],
	[5.17650E+04, 5.4937162326E+01, 5.5211231592E+00, 4.1180360479E+01, 4.4720998680E+00, 9.8956392694E-01],
	[5.17700E+04, 5.4946705165E+01, 5.5211771486E+00, 4.1193480341E+01, 4.4723532097E+00, 9.8956846874E-01],
	[5.17750E+04, 5.4956248739E+01, 5.5212311333E+00, 4.1206603115E+01, 4.4726064950E+00, 9.8957300833E-01],
	[5.17800E+04, 5.4965793049E+01, 5.5212851133E+00, 4.1219728801E+01, 4.4728597240E+00, 9.8957754572E-01],
	[5.17850E+04, 5.4975338095E+01, 5.5213390887E+00, 4.1232857401E+01, 4.4731128966E+00, 9.8958208091E-01],
	[5.17900E+04, 5.4984883876E+01, 5.5213930593E+00, 4.1245988914E+01, 4.4733660129E+00, 9.8958661390E-01],
	[5.17950E+04, 5.4994430393E+01, 5.5214470253E+00, 4.1259123340E+01, 4.4736190729E+00, 9.8959114469E-01],
	[5.18000E+04, 5.5003977646E+01, 5.5215009866E+00, 4.1272260681E+01, 4.4738720766E+00, 9.8959567328E-01],
	[5.18050E+04, 5.5013525634E+01, 5.5215549432E+00, 4.1285400936E+01, 4.4741250241E+00, 9.8960019968E-01],
	[5.18100E+04, 5.5023074359E+01, 5.5216088952E+00, 4.1298544106E+01, 4.4743779153E+00, 9.8960472388E-01],
	[5.18150E+04, 5.5032623819E+01, 5.5216628424E+00, 4.1311690191E+01, 4.4746307502E+00, 9.8960924589E-01],
	[5.18200E+04, 5.5042174014E+01, 5.5217167850E+00, 4.1324839192E+01, 4.4748835290E+00, 9.8961376571E-01],
	[5.18250E+04, 5.5051724945E+01, 5.5217707229E+00, 4.1337991108E+01, 4.4751362515E+00, 9.8961828333E-01],
	[5.18300E+04, 5.5061276612E+01, 5.5218246562E+00, 4.1351145941E+01, 4.4753889179E+00, 9.8962279876E-01],
	[5.18350E+04, 5.5070829015E+01, 5.5218785847E+00, 4.1364303690E+01, 4.4756415281E+00, 9.8962731201E-01],
	[5.18400E+04, 5.5080382153E+01, 5.5219325086E+00, 4.1377464357E+01, 4.4758940821E+00, 9.8963182306E-01],
	[5.18450E+04, 5.5089936026E+01, 5.5219864278E+00, 4.1390627941E+01, 4.4761465800E+00, 9.8963633193E-01],
	[5.18500E+04, 5.5099490635E+01, 5.5220403423E+00, 4.1403794442E+01, 4.4763990217E+00, 9.8964083862E-01],
	[5.18550E+04, 5.5109045980E+01, 5.5220942522E+00, 4.1416963862E+01, 4.4766514074E+00, 9.8964534311E-01],
	[5.18600E+04, 5.5118602060E+01, 5.5221481574E+00, 4.1430136200E+01, 4.4769037369E+00, 9.8964984543E-01],
	[5.18650E+04, 5.5128158876E+01, 5.5222020579E+00, 4.1443311457E+01, 4.4771560104E+00, 9.8965434556E-01],
	[5.18700E+04, 5.5137716427E+01, 5.5222559537E+00, 4.1456489633E+01, 4.4774082278E+00, 9.8965884351E-01],
	[5.18750E+04, 5.5147274714E+01, 5.5223098449E+00, 4.1469670728E+01, 4.4776603892E+00, 9.8966333928E-01],
	[5.18800E+04, 5.5156833736E+01, 5.5223637314E+00, 4.1482854744E+01, 4.4779124945E+00, 9.8966783287E-01],
	[5.18850E+04, 5.5166393494E+01, 5.5224176132E+00, 4.1496041680E+01, 4.4781645439E+00, 9.8967232428E-01],
	[5.18900E+04, 5.5175953987E+01, 5.5224714904E+00, 4.1509231536E+01, 4.4784165372E+00, 9.8967681352E-01],
	[5.18950E+04, 5.5185515216E+01, 5.5225253629E+00, 4.1522424314E+01, 4.4786684745E+00, 9.8968130058E-01],
	[5.19000E+04, 5.5195077180E+01, 5.5225792308E+00, 4.1535620012E+01, 4.4789203559E+00, 9.8968578546E-01],
	[5.19050E+04, 5.5204639879E+01, 5.5226330940E+00, 4.1548818633E+01, 4.4791721813E+00, 9.8969026817E-01],
	[5.19100E+04, 5.5214203314E+01, 5.5226869525E+00, 4.1562020176E+01, 4.4794239508E+00, 9.8969474871E-01],
	[5.19150E+04, 5.5223767485E+01, 5.5227408063E+00, 4.1575224641E+01, 4.4796756644E+00, 9.8969922707E-01],
	[5.19200E+04, 5.5233332390E+01, 5.5227946555E+00, 4.1588432029E+01, 4.4799273220E+00, 9.8970370327E-01],
	[5.19250E+04, 5.5242898031E+01, 5.5228485000E+00, 4.1601642340E+01, 4.4801789238E+00, 9.8970817730E-01],
	[5.19300E+04, 5.5252464407E+01, 5.5229023399E+00, 4.1614855575E+01, 4.4804304697E+00, 9.8971264916E-01],
	[5.19350E+04, 5.5262031519E+01, 5.5229561751E+00, 4.1628071734E+01, 4.4806819598E+00, 9.8971711885E-01],
	[5.19400E+04, 5.5271599366E+01, 5.5230100057E+00, 4.1641290817E+01, 4.4809333940E+00, 9.8972158637E-01],
	[5.19450E+04, 5.5281167948E+01, 5.5230638316E+00, 4.1654512825E+01, 4.4811847723E+00, 9.8972605174E-01],
	[5.19500E+04, 5.5290737266E+01, 5.5231176528E+00, 4.1667737757E+01, 4.4814360949E+00, 9.8973051493E-01],
	[5.19550E+04, 5.5300307318E+01, 5.5231714694E+00, 4.1680965616E+01, 4.4816873617E+00, 9.8973497597E-01],
	[5.19600E+04, 5.5309878106E+01, 5.5232252813E+00, 4.1694196399E+01, 4.4819385727E+00, 9.8973943484E-01],
	[5.19650E+04, 5.5319449630E+01, 5.5232790886E+00, 4.1707430110E+01, 4.4821897279E+00, 9.8974389156E-01],
	[5.19700E+04, 5.5329021888E+01, 5.5233328912E+00, 4.1720666746E+01, 4.4824408274E+00, 9.8974834611E-01],
	[5.19750E+04, 5.5338594882E+01, 5.5233866892E+00, 4.1733906310E+01, 4.4826918711E+00, 9.8975279851E-01],
	[5.19800E+04, 5.5348168611E+01, 5.5234404825E+00, 4.1747148800E+01, 4.4829428592E+00, 9.8975724875E-01],
	[5.19850E+04, 5.5357743075E+01, 5.5234942712E+00, 4.1760394218E+01, 4.4831937915E+00, 9.8976169683E-01],
	[5.19900E+04, 5.5367318274E+01, 5.5235480552E+00, 4.1773642565E+01, 4.4834446681E+00, 9.8976614276E-01],
	[5.19950E+04, 5.5376894209E+01, 5.5236018346E+00, 4.1786893839E+01, 4.4836954891E+00, 9.8977058653E-01],
	[5.20000E+04, 5.5386470878E+01, 5.5236556093E+00, 4.1800148042E+01, 4.4839462545E+00, 9.8977502816E-01],
	[5.20050E+04, 5.5396048283E+01, 5.5237093794E+00, 4.1813405175E+01, 4.4841969641E+00, 9.8977946763E-01],
	[5.20100E+04, 5.5405626423E+01, 5.5237631448E+00, 4.1826665236E+01, 4.4844476182E+00, 9.8978390495E-01],
	[5.20150E+04, 5.5415205297E+01, 5.5238169056E+00, 4.1839928228E+01, 4.4846982167E+00, 9.8978834012E-01],
	[5.20200E+04, 5.5424784907E+01, 5.5238706618E+00, 4.1853194149E+01, 4.4849487595E+00, 9.8979277315E-01],
	[5.20250E+04, 5.5434365252E+01, 5.5239244133E+00, 4.1866463002E+01, 4.4851992468E+00, 9.8979720403E-01],
	[5.20300E+04, 5.5443946332E+01, 5.5239781601E+00, 4.1879734785E+01, 4.4854496786E+00, 9.8980163276E-01],
	[5.20350E+04, 5.5453528148E+01, 5.5240319023E+00, 4.1893009499E+01, 4.4857000548E+00, 9.8980605935E-01],
	[5.20400E+04, 5.5463110698E+01, 5.5240856399E+00, 4.1906287145E+01, 4.4859503754E+00, 9.8981048379E-01],
	[5.20450E+04, 5.5472693983E+01, 5.5241393729E+00, 4.1919567723E+01, 4.4862006406E+00, 9.8981490609E-01],
	[5.20500E+04, 5.5482278003E+01, 5.5241931012E+00, 4.1932851233E+01, 4.4864508502E+00, 9.8981932625E-01],
	[5.20550E+04, 5.5491862758E+01, 5.5242468248E+00, 4.1946137676E+01, 4.4867010044E+00, 9.8982374427E-01],
	[5.20600E+04, 5.5501448248E+01, 5.5243005438E+00, 4.1959427052E+01, 4.4869511031E+00, 9.8982816015E-01],
	[5.20650E+04, 5.5511034473E+01, 5.5243542582E+00, 4.1972719361E+01, 4.4872011464E+00, 9.8983257389E-01],
	[5.20700E+04, 5.5520621433E+01, 5.5244079680E+00, 4.1986014604E+01, 4.4874511342E+00, 9.8983698550E-01],
	[5.20750E+04, 5.5530209128E+01, 5.5244616731E+00, 4.1999312782E+01, 4.4877010666E+00, 9.8984139497E-01],
	[5.20800E+04, 5.5539797558E+01, 5.5245153735E+00, 4.2012613894E+01, 4.4879509436E+00, 9.8984580231E-01],
	[5.20850E+04, 5.5549386723E+01, 5.5245690694E+00, 4.2025917941E+01, 4.4882007652E+00, 9.8985020751E-01],
	[5.20900E+04, 5.5558976622E+01, 5.5246227606E+00, 4.2039224923E+01, 4.4884505315E+00, 9.8985461058E-01],
	[5.20950E+04, 5.5568567257E+01, 5.5246764472E+00, 4.2052534841E+01, 4.4887002424E+00, 9.8985901152E-01],
	[5.21000E+04, 5.5578158626E+01, 5.5247301291E+00, 4.2065847694E+01, 4.4889498979E+00, 9.8986341033E-01],
	[5.21050E+04, 5.5587750730E+01, 5.5247838064E+00, 4.2079163485E+01, 4.4891994982E+00, 9.8986780701E-01],
	[5.21100E+04, 5.5597343569E+01, 5.5248374791E+00, 4.2092482211E+01, 4.4894490431E+00, 9.8987220156E-01],
	[5.21150E+04, 5.5606937143E+01, 5.5248911472E+00, 4.2105803875E+01, 4.4896985327E+00, 9.8987659398E-01],
	[5.21200E+04, 5.5616531452E+01, 5.5249448106E+00, 4.2119128477E+01, 4.4899479670E+00, 9.8988098428E-01],
	[5.21250E+04, 5.5626126495E+01, 5.5249984694E+00, 4.2132456016E+01, 4.4901973461E+00, 9.8988537246E-01],
	[5.21300E+04, 5.5635722273E+01, 5.5250521236E+00, 4.2145786494E+01, 4.4904466699E+00, 9.8988975851E-01],
	[5.21350E+04, 5.5645318786E+01, 5.5251057732E+00, 4.2159119910E+01, 4.4906959385E+00, 9.8989414244E-01],
	[5.21400E+04, 5.5654916034E+01, 5.5251594181E+00, 4.2172456265E+01, 4.4909451519E+00, 9.8989852425E-01],
	[5.21450E+04, 5.5664514016E+01, 5.5252130584E+00, 4.2185795559E+01, 4.4911943101E+00, 9.8990290393E-01],
	[5.21500E+04, 5.