import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

cartilage_ICRP110_MFP = np.array([
	[5.0000000000E+03, 1.6214484677E+00, 7.8283034748E+00, 1.8653713206E-02, 1.8398213413E-02, 3.3746496776E-01],
	[5.0050000000E+03, 1.6232643569E+00, 7.8235132765E+00, 1.8709234299E-02, 1.8452430055E-02, 3.3772674597E-01],
	[5.0100000000E+03, 1.6250804636E+00, 7.8187307880E+00, 1.8764864697E-02, 1.8506750568E-02, 3.3798824774E-01],
	[5.0150000000E+03, 1.6268967875E+00, 7.8139559892E+00, 1.8820604504E-02, 1.8561175040E-02, 3.3824947363E-01],
	[5.0200000000E+03, 1.6287133284E+00, 7.8091888602E+00, 1.8876453825E-02, 1.8615703559E-02, 3.3851042422E-01],
	[5.0250000000E+03, 1.6305300862E+00, 7.8044293808E+00, 1.8932412766E-02, 1.8670336212E-02, 3.3877110008E-01],
	[5.0300000000E+03, 1.6323470606E+00, 7.7996775314E+00, 1.8988481431E-02, 1.8725073085E-02, 3.3903150178E-01],
	[5.0350000000E+03, 1.6341642516E+00, 7.7949332920E+00, 1.9044659925E-02, 1.8779914266E-02, 3.3929162988E-01],
	[5.0400000000E+03, 1.6359816588E+00, 7.7901966430E+00, 1.9100948353E-02, 1.8834859842E-02, 3.3955148496E-01],
	[5.0450000000E+03, 1.6377992821E+00, 7.7854675647E+00, 1.9157346820E-02, 1.8889909900E-02, 3.3981106757E-01],
	[5.0500000000E+03, 1.6396171214E+00, 7.7807460376E+00, 1.9213855431E-02, 1.8945064527E-02, 3.4007037827E-01],
	[5.0550000000E+03, 1.6414351764E+00, 7.7760320420E+00, 1.9270474290E-02, 1.9000323809E-02, 3.4032941769E-01],
	[5.0600000000E+03, 1.6432534469E+00, 7.7713255586E+00, 1.9327203504E-02, 1.9055687834E-02, 3.4058818649E-01],
	[5.0650000000E+03, 1.6450719327E+00, 7.7666265680E+00, 1.9384043176E-02, 1.9111156688E-02, 3.4084668529E-01],
	[5.0700000000E+03, 1.6468906337E+00, 7.7619350509E+00, 1.9440993411E-02, 1.9166730459E-02, 3.4110491475E-01],
	[5.0750000000E+03, 1.6487095497E+00, 7.7572509880E+00, 1.9498054315E-02, 1.9222409232E-02, 3.4136287547E-01],
	[5.0800000000E+03, 1.6505286805E+00, 7.7525743602E+00, 1.9555225993E-02, 1.9278193095E-02, 3.4162056810E-01],
	[5.0850000000E+03, 1.6523599427E+00, 7.7479826055E+00, 1.9612508548E-02, 1.9334084248E-02, 3.4187799325E-01],
	[5.0900000000E+03, 1.6541925913E+00, 7.7434055896E+00, 1.9669902086E-02, 1.9390080888E-02, 3.4213515155E-01],
	[5.0950000000E+03, 1.6560254702E+00, 7.7388357674E+00, 1.9727406713E-02, 1.9446182900E-02, 3.4239204363E-01],
	[5.1000000000E+03, 1.6578585792E+00, 7.7342731206E+00, 1.9785022532E-02, 1.9502390368E-02, 3.4264867009E-01],
	[5.1050000000E+03, 1.6596919180E+00, 7.7297176308E+00, 1.9842749648E-02, 1.9558703380E-02, 3.4290503156E-01],
	[5.1100000000E+03, 1.6615254865E+00, 7.7251692799E+00, 1.9900588167E-02, 1.9615122022E-02, 3.4316112865E-01],
	[5.1150000000E+03, 1.6633592844E+00, 7.7206280498E+00, 1.9958538194E-02, 1.9671646381E-02, 3.4341696196E-01],
	[5.1200000000E+03, 1.6651933116E+00, 7.7160939222E+00, 2.0016599832E-02, 1.9728276543E-02, 3.4367253213E-01],
	[5.1250000000E+03, 1.6670275679E+00, 7.7115668792E+00, 2.0074773188E-02, 1.9785012594E-02, 3.4392783974E-01],
	[5.1300000000E+03, 1.6688620531E+00, 7.7070469028E+00, 2.0133058365E-02, 1.9841854620E-02, 3.4418288541E-01],
	[5.1350000000E+03, 1.6706967669E+00, 7.7025339751E+00, 2.0191455469E-02, 1.9898802708E-02, 3.4443766973E-01],
	[5.1400000000E+03, 1.6725317093E+00, 7.6980280783E+00, 2.0249964604E-02, 1.9955856944E-02, 3.4469219332E-01],
	[5.1450000000E+03, 1.6743668800E+00, 7.6935291945E+00, 2.0308585875E-02, 2.0013017414E-02, 3.4494645677E-01],
	[5.1500000000E+03, 1.6762022787E+00, 7.6890373062E+00, 2.0367319388E-02, 2.0070284205E-02, 3.4520046068E-01],
	[5.1550000000E+03, 1.6780379054E+00, 7.6845523956E+00, 2.0426165246E-02, 2.0127657401E-02, 3.4545420565E-01],
	[5.1600000000E+03, 1.6798737598E+00, 7.6800744451E+00, 2.0485123555E-02, 2.0185137090E-02, 3.4570769226E-01],
	[5.1650000000E+03, 1.6817168926E+00, 7.6756487136E+00, 2.0544194419E-02, 2.0242724693E-02, 3.4596092111E-01],
	[5.1700000000E+03, 1.6835659438E+00, 7.6712662400E+00, 2.0603377943E-02, 2.0300420054E-02, 3.4621389279E-01],
	[5.1750000000E+03, 1.6854152378E+00, 7.6668905013E+00, 2.0662674233E-02, 2.0358222186E-02, 3.4646660788E-01],
	[5.1800000000E+03, 1.6872647743E+00, 7.6625214807E+00, 2.0722083392E-02, 2.0416131176E-02, 3.4671906698E-01],
	[5.1850000000E+03, 1.6891145530E+00, 7.6581591613E+00, 2.0781605526E-02, 2.0474147110E-02, 3.4697127066E-01],
	[5.1900000000E+03, 1.6909645739E+00, 7.6538035266E+00, 2.0841240738E-02, 2.0532270073E-02, 3.4722321951E-01],
	[5.1950000000E+03, 1.6928148367E+00, 7.6494545596E+00, 2.0900989135E-02, 2.0590500151E-02, 3.4747491410E-01],
	[5.2000000000E+03, 1.6946653411E+00, 7.6451122440E+00, 2.0960850821E-02, 2.0648837430E-02, 3.4772635502E-01],
	[5.2050000000E+03, 1.6965160870E+00, 7.6407765631E+00, 2.1020825900E-02, 2.0707281995E-02, 3.4797754283E-01],
	[5.2100000000E+03, 1.6983670743E+00, 7.6364475004E+00, 2.1080914477E-02, 2.0765833933E-02, 3.4822847812E-01],
	[5.2150000000E+03, 1.7002183026E+00, 7.6321250395E+00, 2.1141116657E-02, 2.0824493328E-02, 3.4847916146E-01],
	[5.2200000000E+03, 1.7020697718E+00, 7.6278091640E+00, 2.1201432544E-02, 2.0883260266E-02, 3.4872959340E-01],
	[5.2250000000E+03, 1.7039214817E+00, 7.6234998575E+00, 2.1261862245E-02, 2.0942134833E-02, 3.4897977453E-01],
	[5.2300000000E+03, 1.7057734321E+00, 7.6191971039E+00, 2.1322405862E-02, 2.1001117114E-02, 3.4922970541E-01],
	[5.2350000000E+03, 1.7076256228E+00, 7.6149008869E+00, 2.1383063501E-02, 2.1060207194E-02, 3.4947938659E-01],
	[5.2400000000E+03, 1.7094780535E+00, 7.6106111903E+00, 2.1443835266E-02, 2.1119405159E-02, 3.4972881866E-01],
	[5.2450000000E+03, 1.7113307242E+00, 7.6063279980E+00, 2.1504721263E-02, 2.1178711094E-02, 3.4997800215E-01],
	[5.2500000000E+03, 1.7131951953E+00, 7.6021245945E+00, 2.1565721595E-02, 2.1238127433E-02, 3.5022693764E-01],
	[5.2550000000E+03, 1.7150607519E+00, 7.5979327784E+00, 2.1626836368E-02, 2.1297652102E-02, 3.5047562568E-01],
	[5.2600000000E+03, 1.7169265629E+00, 7.5937472569E+00, 2.1688065686E-02, 2.1357285020E-02, 3.5072406682E-01],
	[5.2650000000E+03, 1.7187926281E+00, 7.5895680146E+00, 2.1749409655E-02, 2.1417026271E-02, 3.5097226162E-01],
	[5.2700000000E+03, 1.7206589472E+00, 7.5853950361E+00, 2.1810868377E-02, 2.1476875940E-02, 3.5122021063E-01],
	[5.2750000000E+03, 1.7225255201E+00, 7.5812283060E+00, 2.1872441959E-02, 2.1536834113E-02, 3.5146791440E-01],
	[5.2800000000E+03, 1.7243923466E+00, 7.5770678091E+00, 2.1934130505E-02, 2.1596900874E-02, 3.5171537347E-01],
	[5.2850000000E+03, 1.7262594264E+00, 7.5729135303E+00, 2.1995934119E-02, 2.1657076308E-02, 3.5196258839E-01],
	[5.2900000000E+03, 1.7281267593E+00, 7.5687654543E+00, 2.2057852907E-02, 2.1717360501E-02, 3.5220955971E-01],
	[5.2950000000E+03, 1.7299943452E+00, 7.5646235660E+00, 2.2119886972E-02, 2.1777753537E-02, 3.5245628796E-01],
	[5.3000000000E+03, 1.7318621839E+00, 7.5604878503E+00, 2.2182036420E-02, 2.1838255501E-02, 3.5270277369E-01],
	[5.3050000000E+03, 1.7337302751E+00, 7.5563582923E+00, 2.2244301355E-02, 2.1898866477E-02, 3.5294901743E-01],
	[5.3100000000E+03, 1.7355986186E+00, 7.5522348770E+00, 2.2306681881E-02, 2.1959586552E-02, 3.5319501973E-01],
	[5.3150000000E+03, 1.7374672142E+00, 7.5481175895E+00, 2.2369178104E-02, 2.2020415808E-02, 3.5344078111E-01],
	[5.3200000000E+03, 1.7393360617E+00, 7.5440064150E+00, 2.2431790128E-02, 2.2081354332E-02, 3.5368630212E-01],
	[5.3250000000E+03, 1.7412051610E+00, 7.5399013385E+00, 2.2494518057E-02, 2.2142402206E-02, 3.5393158325E-01],
	[5.3300000000E+03, 1.7430750460E+00, 7.5358056994E+00, 2.2557361997E-02, 2.2203559633E-02, 3.5417662475E-01],
	[5.3350000000E+03, 1.7449567006E+00, 7.5317883160E+00, 2.2620322051E-02, 2.2264829087E-02, 3.5442142710E-01],
	[5.3400000000E+03, 1.7468386209E+00, 7.5277768347E+00, 2.2683398324E-02, 2.2326208169E-02, 3.5466599091E-01],
	[5.3450000000E+03, 1.7487208068E+00, 7.5237712412E+00, 2.2746590921E-02, 2.2387696964E-02, 3.5491031679E-01],
	[5.3500000000E+03, 1.7506032579E+00, 7.5197715214E+00, 2.2809899947E-02, 2.2449295555E-02, 3.5515440533E-01],
	[5.3550000000E+03, 1.7524859741E+00, 7.5157776613E+00, 2.2873325506E-02, 2.2511004027E-02, 3.5539825713E-01],
	[5.3600000000E+03, 1.7543689553E+00, 7.5117896467E+00, 2.2936867702E-02, 2.2572822465E-02, 3.5564187278E-01],
	[5.3650000000E+03, 1.7562522010E+00, 7.5078074638E+00, 2.3000526641E-02, 2.2634750953E-02, 3.5588525289E-01],
	[5.3700000000E+03, 1.7581357113E+00, 7.5038310985E+00, 2.3064302426E-02, 2.2696789575E-02, 3.5612839804E-01],
	[5.3750000000E+03, 1.7600194858E+00, 7.4998605369E+00, 2.3128195163E-02, 2.2758938415E-02, 3.5637130882E-01],
	[5.3800000000E+03, 1.7619035243E+00, 7.4958957651E+00, 2.3192204955E-02, 2.2821197558E-02, 3.5661398582E-01],
	[5.3850000000E+03, 1.7637878267E+00, 7.4919367695E+00, 2.3256331908E-02, 2.2883567087E-02, 3.5685642962E-01],
	[5.3900000000E+03, 1.7656723927E+00, 7.4879835361E+00, 2.3320576126E-02, 2.2946047087E-02, 3.5709864081E-01],
	[5.3950000000E+03, 1.7675572221E+00, 7.4840360514E+00, 2.3384937713E-02, 2.3008637641E-02, 3.5734061997E-01],
	[5.4000000000E+03, 1.7694423147E+00, 7.4800943015E+00, 2.3449416774E-02, 2.3071338834E-02, 3.5758236768E-01],
	[5.4050000000E+03, 1.7713276703E+00, 7.4761582729E+00, 2.3514013413E-02, 2.3134150750E-02, 3.5782388452E-01],
	[5.4100000000E+03, 1.7732132888E+00, 7.4722279519E+00, 2.3578727735E-02, 2.3197073471E-02, 3.5806517105E-01],
	[5.4150000000E+03, 1.7750991698E+00, 7.4683033252E+00, 2.3643559845E-02, 2.3260107083E-02, 3.5830622785E-01],
	[5.4200000000E+03, 1.7769956638E+00, 7.4644485965E+00, 2.3708509847E-02, 2.3323254079E-02, 3.5854705550E-01],
	[5.4250000000E+03, 1.7788937927E+00, 7.4606078343E+00, 2.3773577845E-02, 2.3386512470E-02, 3.5878765457E-01],
	[5.4300000000E+03, 1.7807921977E+00, 7.4567725839E+00, 2.3838763945E-02, 2.3449882027E-02, 3.5902802561E-01],
	[5.4350000000E+03, 1.7826908785E+00, 7.4529428322E+00, 2.3904068249E-02, 2.3513362831E-02, 3.5926816919E-01],
	[5.4400000000E+03, 1.7845898350E+00, 7.4491185664E+00, 2.3969490864E-02, 2.3576954968E-02, 3.5950808589E-01],
	[5.4450000000E+03, 1.7864890670E+00, 7.4452997735E+00, 2.4035031893E-02, 2.3640658521E-02, 3.5974777625E-01],
	[5.4500000000E+03, 1.7883885742E+00, 7.4414864407E+00, 2.4100691441E-02, 2.3704473573E-02, 3.5998724084E-01],
	[5.4550000000E+03, 1.7902883565E+00, 7.4376785552E+00, 2.4166469612E-02, 2.3768400208E-02, 3.6022648021E-01],
	[5.4600000000E+03, 1.7921884135E+00, 7.4338761042E+00, 2.4232366511E-02, 2.3832438509E-02, 3.6046549492E-01],
	[5.4650000000E+03, 1.7940887452E+00, 7.4300790751E+00, 2.4298382242E-02, 2.3896588559E-02, 3.6070428553E-01],
	[5.4700000000E+03, 1.7959893512E+00, 7.4262874551E+00, 2.4364516910E-02, 2.3960850443E-02, 3.6094285258E-01],
	[5.4750000000E+03, 1.7978902315E+00, 7.4225012315E+00, 2.4430770618E-02, 2.4025224242E-02, 3.6118119662E-01],
	[5.4800000000E+03, 1.7997913857E+00, 7.4187203919E+00, 2.4497428583E-02, 2.4089985746E-02, 3.6141931821E-01],
	[5.4850000000E+03, 1.8016928137E+00, 7.4149449236E+00, 2.4564437139E-02, 2.4155082993E-02, 3.6165721788E-01],
	[5.4900000000E+03, 1.8035945152E+00, 7.4111748141E+00, 2.4631567388E-02, 2.4220294600E-02, 3.6189489618E-01],
	[5.4950000000E+03, 1.8054964900E+00, 7.4074100509E+00, 2.4698819438E-02, 2.4285620656E-02, 3.6213235365E-01],
	[5.5000000000E+03, 1.8073987380E+00, 7.4036506216E+00, 2.4766193398E-02, 2.4351061245E-02, 3.6236959084E-01],
	[5.5050000000E+03, 1.8093063419E+00, 7.3999277675E+00, 2.4833689378E-02, 2.4416617722E-02, 3.6260660827E-01],
	[5.5100000000E+03, 1.8112205109E+00, 7.3962487558E+00, 2.4901307486E-02, 2.4482290490E-02, 3.6284340650E-01],
	[5.5150000000E+03, 1.8131349661E+00, 7.3925749077E+00, 2.4969047831E-02, 2.4548078077E-02, 3.6307998604E-01],
	[5.5200000000E+03, 1.8150497073E+00, 7.3889062112E+00, 2.5036910523E-02, 2.4613980571E-02, 3.6331634744E-01],
	[5.5250000000E+03, 1.8169647341E+00, 7.3852426545E+00, 2.5104895670E-02, 2.4679998057E-02, 3.6355249122E-01],
	[5.5300000000E+03, 1.8188800464E+00, 7.3815842258E+00, 2.5173003382E-02, 2.4746130624E-02, 3.6378841791E-01],
	[5.5350000000E+03, 1.8207956441E+00, 7.3779309132E+00, 2.5241233767E-02, 2.4812378357E-02, 3.6402412805E-01],
	[5.5400000000E+03, 1.8227115268E+00, 7.3742827049E+00, 2.5309586935E-02, 2.4878741343E-02, 3.6425962215E-01],
	[5.5450000000E+03, 1.8246276943E+00, 7.3706395893E+00, 2.5378062994E-02, 2.4945219670E-02, 3.6449490075E-01],
	[5.5500000000E+03, 1.8265441465E+00, 7.3670015546E+00, 2.5446662053E-02, 2.5011813422E-02, 3.6472996435E-01],
	[5.5550000000E+03, 1.8284608831E+00, 7.3633685893E+00, 2.5515384222E-02, 2.5078522688E-02, 3.6496481349E-01],
	[5.5600000000E+03, 1.8303779039E+00, 7.3597406815E+00, 2.5584229609E-02, 2.5145347553E-02, 3.6519944868E-01],
	[5.5650000000E+03, 1.8322952087E+00, 7.3561178199E+00, 2.5653198324E-02, 2.5212288103E-02, 3.6543387044E-01],
	[5.5700000000E+03, 1.8342127973E+00, 7.3524999928E+00, 2.5722290475E-02, 2.5279344426E-02, 3.6566807927E-01],
	[5.5750000000E+03, 1.8361306694E+00, 7.3488871888E+00, 2.5791506171E-02, 2.5346516606E-02, 3.6590207571E-01],
	[5.5800000000E+03, 1.8380488249E+00, 7.3452793963E+00, 2.5860845522E-02, 2.5413804732E-02, 3.6613586025E-01],
	[5.5850000000E+03, 1.8399672636E+00, 7.3416766040E+00, 2.5930308636E-02, 2.5481208888E-02, 3.6636943341E-01],
	[5.5900000000E+03, 1.8418859852E+00, 7.3380788004E+00, 2.5999895622E-02, 2.5548729161E-02, 3.6660279570E-01],
	[5.5950000000E+03, 1.8438130361E+00, 7.3345349979E+00, 2.6069606589E-02, 2.5616367788E-02, 3.6683594761E-01],
	[5.6000000000E+03, 1.8457433598E+00, 7.3310142017E+00, 2.6139441647E-02, 2.5684123521E-02, 3.6706888967E-01],
	[5.6050000000E+03, 1.8476739790E+00, 7.3274982355E+00, 2.6209400904E-02, 2.5751995655E-02, 3.6730162236E-01],
	[5.6100000000E+03, 1.8496048933E+00, 7.3239870884E+00, 2.6279484468E-02, 2.5819984275E-02, 3.6753414620E-01],
	[5.6150000000E+03, 1.8515361027E+00, 7.3204807494E+00, 2.6349692450E-02, 2.5888089466E-02, 3.6776646167E-01],
	[5.6200000000E+03, 1.8534676069E+00, 7.3169792078E+00, 2.6420024958E-02, 2.5956311315E-02, 3.6799856929E-01],
	[5.6250000000E+03, 1.8553994057E+00, 7.3134824526E+00, 2.6490482101E-02, 2.6024649909E-02, 3.6823046954E-01],
	[5.6300000000E+03, 1.8573314989E+00, 7.3099904732E+00, 2.6561063987E-02, 2.6093105331E-02, 3.6846216293E-01],
	[5.6350000000E+03, 1.8592638862E+00, 7.3065032587E+00, 2.6631770727E-02, 2.6161677669E-02, 3.6869364993E-01],
	[5.6400000000E+03, 1.8611965674E+00, 7.3030207985E+00, 2.6702602428E-02, 2.6230367008E-02, 3.6892493106E-01],
	[5.6450000000E+03, 1.8631295423E+00, 7.2995430818E+00, 2.6773559200E-02, 2.6299173434E-02, 3.6915600679E-01],
	[5.6500000000E+03, 1.8650628108E+00, 7.2960700979E+00, 2.6844641151E-02, 2.6368097032E-02, 3.6938687761E-01],
	[5.6550000000E+03, 1.8669963725E+00, 7.2926018364E+00, 2.6915848391E-02, 2.6437137888E-02, 3.6961754402E-01],
	[5.6600000000E+03, 1.8689302273E+00, 7.2891382865E+00, 2.6987181029E-02, 2.6506296087E-02, 3.6984800649E-01],
	[5.6650000000E+03, 1.8708643750E+00, 7.2856794377E+00, 2.7058639173E-02, 2.6575571716E-02, 3.7007826552E-01],
	[5.6700000000E+03, 1.8727988153E+00, 7.2822252796E+00, 2.7130222932E-02, 2.6644964858E-02, 3.7030832158E-01],
	[5.6750000000E+03, 1.8747335480E+00, 7.2787758015E+00, 2.7201932415E-02, 2.6714475600E-02, 3.7053817515E-01],
	[5.6800000000E+03, 1.8766685730E+00, 7.2753309931E+00, 2.7273767731E-02, 2.6784104027E-02, 3.7076782671E-01],
	[5.6850000000E+03, 1.8786116583E+00, 7.2719378063E+00, 2.7345728990E-02, 2.6853852452E-02, 3.7099727675E-01],
	[5.6900000000E+03, 1.8805579608E+00, 7.2685667849E+00, 2.7417816299E-02, 2.6923719590E-02, 3.7122652573E-01],
	[5.6950000000E+03, 1.8825045674E+00, 7.2652002850E+00, 2.7490029768E-02, 2.6993704694E-02, 3.7145557413E-01],
	[5.7000000000E+03, 1.8844514781E+00, 7.2618382967E+00, 2.7562369506E-02, 2.7063807849E-02, 3.7168442243E-01],
	[5.7050000000E+03, 1.8863986926E+00, 7.2584808099E+00, 2.7634835621E-02, 2.7134029140E-02, 3.7191307109E-01],
	[5.7100000000E+03, 1.8883462107E+00, 7.2551278147E+00, 2.7707428223E-02, 2.7204368654E-02, 3.7214152059E-01],
	[5.7150000000E+03, 1.8902940321E+00, 7.2517793012E+00, 2.7780147420E-02, 2.7274826473E-02, 3.7236977140E-01],
	[5.7200000000E+03, 1.8922421567E+00, 7.2484352593E+00, 2.7852993322E-02, 2.7345402685E-02, 3.7259782397E-01],
	[5.7250000000E+03, 1.8941905843E+00, 7.2450956794E+00, 2.7925966036E-02, 2.7416097372E-02, 3.7282567879E-01],
	[5.7300000000E+03, 1.8961393145E+00, 7.2417605515E+00, 2.7999065673E-02, 2.7486910622E-02, 3.7305333630E-01],
	[5.7350000000E+03, 1.8980883473E+00, 7.2384298658E+00, 2.8072292340E-02, 2.7557842517E-02, 3.7328079698E-01],
	[5.7400000000E+03, 1.9000376823E+00, 7.2351036125E+00, 2.8145646147E-02, 2.7628893143E-02, 3.7350806128E-01],
	[5.7450000000E+03, 1.9019873194E+00, 7.2317817819E+00, 2.8219127203E-02, 2.7700062585E-02, 3.7373512967E-01],
	[5.7500000000E+03, 1.9039372583E+00, 7.2284643643E+00, 2.8292735616E-02, 2.7771350928E-02, 3.7396200260E-01],
	[5.7550000000E+03, 1.9058874988E+00, 7.2251513499E+00, 2.8366471496E-02, 2.7842758255E-02, 3.7418868053E-01],
	[5.7600000000E+03, 1.9078380408E+00, 7.2218427291E+00, 2.8440334951E-02, 2.7914284652E-02, 3.7441516391E-01],
	[5.7650000000E+03, 1.9097888840E+00, 7.2185384923E+00, 2.8514326089E-02, 2.7985930203E-02, 3.7464145321E-01],
	[5.7700000000E+03, 1.9117400281E+00, 7.2152386299E+00, 2.8588445021E-02, 2.8057694993E-02, 3.7486754887E-01],
	[5.7750000000E+03, 1.9136959672E+00, 7.2119701303E+00, 2.8662691854E-02, 2.8129580487E-02, 3.7509345134E-01],
	[5.7800000000E+03, 1.9156580588E+00, 7.2087410092E+00, 2.8737066698E-02, 2.8201587203E-02, 3.7531916107E-01],
	[5.7850000000E+03, 1.9176204629E+00, 7.2055161242E+00, 2.8811569661E-02, 2.8273713437E-02, 3.7554467852E-01],
	[5.7900000000E+03, 1.9195831793E+00, 7.2022954661E+00, 2.8886200853E-02, 2.8345959274E-02, 3.7577000412E-01],
	[5.7950000000E+03, 1.9215462078E+00, 7.1990790258E+00, 2.8960960382E-02, 2.8418324797E-02, 3.7599513833E-01],
	[5.8000000000E+03, 1.9235095481E+00, 7.1958667939E+00, 2.9035848356E-02, 2.8490810090E-02, 3.7622008158E-01],
	[5.8050000000E+03, 1.9254732001E+00, 7.1926587615E+00, 2.9110864885E-02, 2.8563415238E-02, 3.7644483433E-01],
	[5.8100000000E+03, 1.9274371635E+00, 7.1894549194E+00, 2.9186010078E-02, 2.8636140325E-02, 3.7666939701E-01],
	[5.8150000000E+03, 1.9294014381E+00, 7.1862552586E+00, 2.9261284043E-02, 2.8708985436E-02, 3.7689377006E-01],
	[5.8200000000E+03, 1.9313660238E+00, 7.1830597699E+00, 2.9336686890E-02, 2.8781950653E-02, 3.7711795393E-01],
	[5.8250000000E+03, 1.9333309201E+00, 7.1798684445E+00, 2.9412218726E-02, 2.8855036061E-02, 3.7734194904E-01],
	[5.8300000000E+03, 1.9352961271E+00, 7.1766812732E+00, 2.9487879661E-02, 2.8928241745E-02, 3.7756575584E-01],
	[5.8350000000E+03, 1.9372616444E+00, 7.1734982472E+00, 2.9563669804E-02, 2.9001567787E-02, 3.7778937483E-01],
	[5.8400000000E+03, 1.9392274718E+00, 7.1703193574E+00, 2.9639589263E-02, 2.9075014272E-02, 3.7801280668E-01],
	[5.8450000000E+03, 1.9411936090E+00, 7.1671445951E+00, 2.9715638148E-02, 2.9148581283E-02, 3.7823605190E-01],
	[5.8500000000E+03, 1.9431600560E+00, 7.1639739512E+00, 2.9791816566E-02, 2.9222268905E-02, 3.7845911095E-01],
	[5.8550000000E+03, 1.9451268125E+00, 7.1608074170E+00, 2.9868124627E-02, 2.9296077220E-02, 3.7868198433E-01],
	[5.8600000000E+03, 1.9470938782E+00, 7.1576449836E+00, 2.9944562440E-02, 2.9370006313E-02, 3.7890467249E-01],
	[5.8650000000E+03, 1.9490612529E+00, 7.1544866423E+00, 3.0021130113E-02, 2.9444056267E-02, 3.7912717593E-01],
	[5.8700000000E+03, 1.9510374106E+00, 7.1513829770E+00, 3.0097827756E-02, 2.9518229967E-02, 3.7934949512E-01],
	[5.8750000000E+03, 1.9530154088E+00, 7.1482923724E+00, 3.0174655476E-02, 2.9592525222E-02, 3.7957163051E-01],
	[5.8800000000E+03, 1.9549937270E+00, 7.1452057309E+00, 3.0251613383E-02, 2.9666941615E-02, 3.7979358260E-01],
	[5.8850000000E+03, 1.9569723651E+00, 7.1421230441E+00, 3.0328701586E-02, 2.9741479230E-02, 3.8001535184E-01],
	[5.8900000000E+03, 1.9589513228E+00, 7.1390443035E+00, 3.0405920193E-02, 2.9816138150E-02, 3.8023693870E-01],
	[5.8950000000E+03, 1.9609306000E+00, 7.1359695009E+00, 3.0483269313E-02, 2.9890918458E-02, 3.8045834365E-01],
	[5.9000000000E+03, 1.9629101964E+00, 7.1328986277E+00, 3.0560749054E-02, 2.9965820238E-02, 3.8067956716E-01],
	[5.9050000000E+03, 1.9648901117E+00, 7.1298316758E+00, 3.0638359527E-02, 3.0040843572E-02, 3.8090060968E-01],
	[5.9100000000E+03, 1.9668703459E+00, 7.1267686366E+00, 3.0716100838E-02, 3.0115988544E-02, 3.8112147167E-01],
	[5.9150000000E+03, 1.9688508985E+00, 7.1237095021E+00, 3.0793973098E-02, 3.0191255237E-02, 3.8134215360E-01],
	[5.9200000000E+03, 1.9708317696E+00, 7.1206542637E+00, 3.0871976414E-02, 3.0266643735E-02, 3.8156265593E-01],
	[5.9250000000E+03, 1.9728129587E+00, 7.1176029135E+00, 3.0950110897E-02, 3.0342154119E-02, 3.8178297911E-01],
	[5.9300000000E+03, 1.9747944657E+00, 7.1145554430E+00, 3.1028376653E-02, 3.0417786474E-02, 3.8200312360E-01],
	[5.9350000000E+03, 1.9767762904E+00, 7.1115118441E+00, 3.1106773793E-02, 3.0493540882E-02, 3.8222308984E-01],
	[5.9400000000E+03, 1.9787584326E+00, 7.1084721087E+00, 3.1185302424E-02, 3.0569417425E-02, 3.8244287830E-01],
	[5.9450000000E+03, 1.9807408920E+00, 7.1054362286E+00, 3.1263962656E-02, 3.0645416187E-02, 3.8266248943E-01],
	[5.9500000000E+03, 1.9827236684E+00, 7.1024041956E+00, 3.1342754597E-02, 3.0721537250E-02, 3.8288192367E-01],
	[5.9550000000E+03, 1.9847067617E+00, 7.0993760017E+00, 3.1421678356E-02, 3.0797780697E-02, 3.8310118146E-01],
	[5.9600000000E+03, 1.9866901715E+00, 7.0963516387E+00, 3.1500734042E-02, 3.0874146611E-02, 3.8332026327E-01],
	[5.9650000000E+03, 1.9886831804E+00, 7.0933862511E+00, 3.1579921763E-02, 3.0950638373E-02, 3.8353916953E-01],
	[5.9700000000E+03, 1.9906768864E+00, 7.0904267822E+00, 3.1659241629E-02, 3.1027252924E-02, 3.8375790068E-01],
	[5.9750000000E+03, 1.9926709196E+00, 7.0874710241E+00, 3.1738693747E-02, 3.1103990217E-02, 3.8397645718E-01],
	[5.9800000000E+03, 1.9946652797E+00, 7.0845189690E+00, 3.1818278227E-02, 3.1180850334E-02, 3.8419483945E-01],
	[5.9850000000E+03, 1.9966599666E+00, 7.0815706091E+00, 3.1897995177E-02, 3.1257833358E-02, 3.8441304794E-01],
	[5.9900000000E+03, 1.9986549799E+00, 7.0786259369E+00, 3.1977844707E-02, 3.1334939370E-02, 3.8463108309E-01],
	[5.9950000000E+03, 2.0006503195E+00, 7.0756849445E+00, 3.2057826924E-02, 3.1412168454E-02, 3.8484894533E-01],
	[6.0000000000E+03, 2.0026459852E+00, 7.0727476244E+00, 3.2137941937E-02, 3.1489520692E-02, 3.8506663510E-01],
	[6.0050000000E+03, 2.0046419768E+00, 7.0698139688E+00, 3.2218682089E-02, 3.1567468701E-02, 3.8528415283E-01],
	[6.0100000000E+03, 2.0066382939E+00, 7.0668839703E+00, 3.2299557357E-02, 3.1645541977E-02, 3.8550149896E-01],
	[6.0150000000E+03, 2.0086349365E+00, 7.0639576211E+00, 3.2380567851E-02, 3.1723740603E-02, 3.8571867392E-01],
	[6.0200000000E+03, 2.0106319042E+00, 7.0610349137E+00, 3.2461713687E-02, 3.1802064666E-02, 3.8593567813E-01],
	[6.0250000000E+03, 2.0126291970E+00, 7.0581158406E+00, 3.2542994975E-02, 3.1880514250E-02, 3.8615251202E-01],
	[6.0300000000E+03, 2.0146268145E+00, 7.0552003942E+00, 3.2624411829E-02, 3.1959089442E-02, 3.8636917603E-01],
	[6.0350000000E+03, 2.0166247565E+00, 7.0522885670E+00, 3.2705964361E-02, 3.2037790325E-02, 3.8658567057E-01],
	[6.0400000000E+03, 2.0186230228E+00, 7.0493803515E+00, 3.2787652685E-02, 3.2116616985E-02, 3.8680199608E-01],
	[6.0450000000E+03, 2.0206216133E+00, 7.0464757403E+00, 3.2869476913E-02, 3.2195569508E-02, 3.8701815297E-01],
	[6.0500000000E+03, 2.0226205277E+00, 7.0435747259E+00, 3.2951437157E-02, 3.2274647978E-02, 3.8723414166E-01],
	[6.0550000000E+03, 2.0246197657E+00, 7.0406773010E+00, 3.3033533530E-02, 3.2353852480E-02, 3.8744996259E-01],
	[6.0600000000E+03, 2.0266265410E+00, 7.0378259529E+00, 3.3115766145E-02, 3.2433185850E-02, 3.8766561616E-01],
	[6.0650000000E+03, 2.0286357859E+00, 7.0349906874E+00, 3.3198135114E-02, 3.2512646261E-02, 3.8788110279E-01],
	[6.0700000000E+03, 2.0306453646E+00, 7.0321588991E+00, 3.3280640551E-02, 3.2592232987E-02, 3.8809642291E-01],
	[6.0750000000E+03, 2.0326552770E+00, 7.0293305809E+00, 3.3363282568E-02, 3.2671946114E-02, 3.8831157692E-01],
	[6.0800000000E+03, 2.0346655227E+00, 7.0265057258E+00, 3.3446061278E-02, 3.2751785725E-02, 3.8852656524E-01],
	[6.0850000000E+03, 2.0366761015E+00, 7.0236843265E+00, 3.3528976792E-02, 3.2831751906E-02, 3.8874138829E-01],
	[6.0900000000E+03, 2.0386870133E+00, 7.0208663762E+00, 3.3612029225E-02, 3.2911844741E-02, 3.8895604647E-01],
	[6.0950000000E+03, 2.0406982578E+00, 7.0180518677E+00, 3.3695218688E-02, 3.2992064314E-02, 3.8917054019E-01],
	[6.1000000000E+03, 2.0427098348E+00, 7.0152407940E+00, 3.3778545295E-02, 3.3072410712E-02, 3.8938486987E-01],
	[6.1050000000E+03, 2.0447217440E+00, 7.0124331481E+00, 3.3862009158E-02, 3.3152884017E-02, 3.8959903591E-01],
	[6.1100000000E+03, 2.0467339854E+00, 7.0096289230E+00, 3.3945610389E-02, 3.3233484315E-02, 3.8981303872E-01],
	[6.1150000000E+03, 2.0487465585E+00, 7.0068281118E+00, 3.4029349102E-02, 3.3314211690E-02, 3.9002687870E-01],
	[6.1200000000E+03, 2.0507594633E+00, 7.0040307075E+00, 3.4113225409E-02, 3.3395066226E-02, 3.9024055626E-01],
	[6.1250000000E+03, 2.0527726995E+00, 7.0012367032E+00, 3.4197239422E-02, 3.3476048008E-02, 3.9045407179E-01],
	[6.1300000000E+03, 2.0547862669E+00, 6.9984460920E+00, 3.4281391255E-02, 3.3557157119E-02, 3.9066742571E-01],
	[6.1350000000E+03, 2.0568001652E+00, 6.9956588669E+00, 3.4365681020E-02, 3.3638393644E-02, 3.9088061842E-01],
	[6.1400000000E+03, 2.0588143944E+00, 6.9928750213E+00, 3.4450108830E-02, 3.3719757668E-02, 3.9109365030E-01],
	[6.1450000000E+03, 2.0608289540E+00, 6.9900945481E+00, 3.4534674797E-02, 3.3801249273E-02, 3.9130652177E-01],
	[6.1500000000E+03, 2.0628438441E+00, 6.9873174406E+00, 3.4619379034E-02, 3.3882868545E-02, 3.9151923321E-01],
	[6.1550000000E+03, 2.0648615374E+00, 6.9845580924E+00, 3.4704221653E-02, 3.3964616577E-02, 3.9173178502E-01],
	[6.1600000000E+03, 2.0668861752E+00, 6.9818405177E+00, 3.4789202768E-02, 3.4046495158E-02, 3.9194417760E-01],
	[6.1650000000E+03, 2.0689111530E+00, 6.9791262040E+00, 3.4874322491E-02, 3.4128501686E-02, 3.9215641135E-01],
	[6.1700000000E+03, 2.0709364707E+00, 6.9764151448E+00, 3.4959580935E-02, 3.4210636246E-02, 3.9236848664E-01],
	[6.1750000000E+03, 2.0729621281E+00, 6.9737073334E+00, 3.5044978212E-02, 3.4292898919E-02, 3.9258040387E-01],
	[6.1800000000E+03, 2.0749881249E+00, 6.9710027635E+00, 3.5130514435E-02, 3.4375289792E-02, 3.9279216344E-01],
	[6.1850000000E+03, 2.0770144609E+00, 6.9683014285E+00, 3.5216189717E-02, 3.4457808946E-02, 3.9300376574E-01],
	[6.1900000000E+03, 2.0790411358E+00, 6.9656033219E+00, 3.5302004170E-02, 3.4540456466E-02, 3.9321521114E-01],
	[6.1950000000E+03, 2.0810681495E+00, 6.9629084373E+00, 3.5387957907E-02, 3.4623232435E-02, 3.9342650003E-01],
	[6.2000000000E+03, 2.0830955018E+00, 6.9602167682E+00, 3.5474051041E-02, 3.4706136938E-02, 3.9363763281E-01],
	[6.2050000000E+03, 2.0851231924E+00, 6.9575283082E+00, 3.5560283684E-02, 3.4789170057E-02, 3.9384860986E-01],
	[6.2100000000E+03, 2.0871512211E+00, 6.9548430509E+00, 3.5646655949E-02, 3.4872331876E-02, 3.9405943155E-01],
	[6.2150000000E+03, 2.0891795878E+00, 6.9521609899E+00, 3.5733167948E-02, 3.4955622478E-02, 3.9427009827E-01],
	[6.2200000000E+03, 2.0912082921E+00, 6.9494821188E+00, 3.5819819795E-02, 3.5039041947E-02, 3.9448061041E-01],
	[6.2250000000E+03, 2.0932373338E+00, 6.9468064312E+00, 3.5906611601E-02, 3.5122590366E-02, 3.9469096833E-01],
	[6.2300000000E+03, 2.0952667129E+00, 6.9441339209E+00, 3.5993543480E-02, 3.5206267817E-02, 3.9490117243E-01],
	[6.2350000000E+03, 2.0972964289E+00, 6.9414645816E+00, 3.6080615544E-02, 3.5290074386E-02, 3.9511122307E-01],
	[6.2400000000E+03, 2.0993264818E+00, 6.9387984068E+00, 3.6167827906E-02, 3.5374010153E-02, 3.9532112063E-01],
	[6.2450000000E+03, 2.1013568713E+00, 6.9361353904E+00, 3.6255180679E-02, 3.5458075203E-02, 3.9553086550E-01],
	[6.2500000000E+03, 2.1033875972E+00, 6.9334755260E+00, 3.6342673975E-02, 3.5542269618E-02, 3.9574045803E-01],
	[6.2550000000E+03, 2.1054227082E+00, 6.9308421031E+00, 3.6430307906E-02, 3.5626595256E-02, 3.9594989862E-01],
	[6.2600000000E+03, 2.1074629288E+00, 6.9282391859E+00, 3.6518082586E-02, 3.5711052537E-02, 3.9615918762E-01],
	[6.2650000000E+03, 2.1095034951E+00, 6.9256393233E+00, 3.6605998126E-02, 3.5795639461E-02, 3.9636832541E-01],
	[6.2700000000E+03, 2.1115444070E+00, 6.9230425092E+00, 3.6694054641E-02, 3.5880356112E-02, 3.9657731237E-01],
	[6.2750000000E+03, 2.1135856642E+00, 6.9204487377E+00, 3.6782252241E-02, 3.5965202572E-02, 3.9678614885E-01],
	[6.2800000000E+03, 2.1156272664E+00, 6.9178580026E+00, 3.6870591041E-02, 3.6050178925E-02, 3.9699483522E-01],
	[6.2850000000E+03, 2.1176692136E+00, 6.9152702982E+00, 3.6959071152E-02, 3.6135285252E-02, 3.9720337187E-01],
	[6.2900000000E+03, 2.1197115055E+00, 6.9126856184E+00, 3.7047692688E-02, 3.6220521637E-02, 3.9741175914E-01],
	[6.2950000000E+03, 2.1217541417E+00, 6.9101039573E+00, 3.7136455760E-02, 3.6305888161E-02, 3.9761999740E-01],
	[6.3000000000E+03, 2.1237971223E+00, 6.9075253089E+00, 3.7225360481E-02, 3.6391384909E-02, 3.9782808703E-01],
	[6.3050000000E+03, 2.1258404468E+00, 6.9049496674E+00, 3.7314406965E-02, 3.6477011962E-02, 3.9803602848E-01],
	[6.3100000000E+03, 2.1278841152E+00, 6.9023770269E+00, 3.7403595324E-02, 3.6562769402E-02, 3.9824382219E-01],
	[6.3150000000E+03, 2.1299281271E+00, 6.8998073815E+00, 3.7492925669E-02, 3.6648657311E-02, 3.9845146852E-01],
	[6.3200000000E+03, 2.1319724824E+00, 6.8972407253E+00, 3.7582398115E-02, 3.6734675773E-02, 3.9865896785E-01],
	[6.3250000000E+03, 2.1340171809E+00, 6.8946770526E+00, 3.7672012774E-02, 3.6820824870E-02, 3.9886632055E-01],
	[6.3300000000E+03, 2.1360622223E+00, 6.8921163574E+00, 3.7761769757E-02, 3.6907104682E-02, 3.9907352700E-01],
	[6.3350000000E+03, 2.1381076065E+00, 6.8895586341E+00, 3.7851669179E-02, 3.6993515293E-02, 3.9928058756E-01],
	[6.3400000000E+03, 2.1401533332E+00, 6.8870038767E+00, 3.7941711151E-02, 3.7080056785E-02, 3.9948750262E-01],
	[6.3450000000E+03, 2.1421994022E+00, 6.8844520796E+00, 3.8031895786E-02, 3.7166729240E-02, 3.9969427253E-01],
	[6.3500000000E+03, 2.1442458133E+00, 6.8819032369E+00, 3.8122223196E-02, 3.7253532739E-02, 3.9990089767E-01],
	[6.3550000000E+03, 2.1462953636E+00, 6.8793732677E+00, 3.8212693495E-02, 3.7340468680E-02, 4.0010737840E-01],
	[6.3600000000E+03, 2.1483510111E+00, 6.8768789223E+00, 3.8303306795E-02, 3.7427538554E-02, 4.0031371509E-01],
	[6.3650000000E+03, 2.1504070098E+00, 6.8743874404E+00, 3.8394063209E-02, 3.7514739749E-02, 4.0051990810E-01],
	[6.3700000000E+03, 2.1524633593E+00, 6.8718988166E+00, 3.8484962849E-02, 3.7602072345E-02, 4.0072595781E-01],
	[6.3750000000E+03, 2.1545200594E+00, 6.8694130452E+00, 3.8576005827E-02, 3.7689536426E-02, 4.0093186457E-01],
	[6.3800000000E+03, 2.1565771100E+00, 6.8669301208E+00, 3.8667192257E-02, 3.7777132073E-02, 4.0113762874E-01],
	[6.3850000000E+03, 2.1586345108E+00, 6.8644500379E+00, 3.8758522251E-02, 3.7864859367E-02, 4.0134325068E-01],
	[6.3900000000E+03, 2.1606922615E+00, 6.8619727910E+00, 3.8849995922E-02, 3.7952718390E-02, 4.0154873076E-01],
	[6.3950000000E+03, 2.1627503620E+00, 6.8594983747E+00, 3.8941613381E-02, 3.8040709224E-02, 4.0175406934E-01],
	[6.4000000000E+03, 2.1648088121E+00, 6.8570267835E+00, 3.9033374743E-02, 3.8128831949E-02, 4.0195926676E-01],
	[6.4050000000E+03, 2.1668676116E+00, 6.8545580120E+00, 3.9125280119E-02, 3.8217086648E-02, 4.0216432340E-01],
	[6.4100000000E+03, 2.1689267602E+00, 6.8520920548E+00, 3.9217329622E-02, 3.8305473402E-02, 4.0236923960E-01],
	[6.4150000000E+03, 2.1709862577E+00, 6.8496289064E+00, 3.9309523365E-02, 3.8393992291E-02, 4.0257401572E-01],
	[6.4200000000E+03, 2.1730461039E+00, 6.8471685615E+00, 3.9401861460E-02, 3.8482643398E-02, 4.0277865211E-01],
	[6.4250000000E+03, 2.1751062986E+00, 6.8447110148E+00, 3.9494344020E-02, 3.8571426803E-02, 4.0298314913E-01],
	[6.4300000000E+03, 2.1771668416E+00, 6.8422562608E+00, 3.9586971157E-02, 3.8660342588E-02, 4.0318750712E-01],
	[6.4350000000E+03, 2.1792277326E+00, 6.8398042943E+00, 3.9679742985E-02, 3.8749390833E-02, 4.0339172644E-01],
	[6.4400000000E+03, 2.1812889715E+00, 6.8373551098E+00, 3.9772659615E-02, 3.8838571620E-02, 4.0359580744E-01],
	[6.4450000000E+03, 2.1833505581E+00, 6.8349087021E+00, 3.9865721160E-02, 3.8927885028E-02, 4.0379975047E-01],
	[6.4500000000E+03, 2.1854124921E+00, 6.8324650659E+00, 3.9958927734E-02, 3.9017331141E-02, 4.0400355587E-01],
	[6.4550000000E+03, 2.1874747733E+00, 6.8300241959E+00, 4.0052279447E-02, 3.9106910037E-02, 4.0420722399E-01],
	[6.4600000000E+03, 2.1895446150E+00, 6.8276267207E+00, 4.0145776414E-02, 3.9196625449E-02, 4.0441075518E-01],
	[6.4650000000E+03, 2.1916158784E+00, 6.8252379439E+00, 4.0239418747E-02, 3.9286474375E-02, 4.0461414978E-01],
	[6.4700000000E+03, 2.1936874977E+00, 6.8228518486E+00, 4.0333206557E-02, 3.9376456358E-02, 4.0481740814E-01],
	[6.4750000000E+03, 2.1957594726E+00, 6.8204684299E+00, 4.0427139959E-02, 3.9466571480E-02, 4.0502053060E-01],
	[6.4800000000E+03, 2.1978318029E+00, 6.8180876825E+00, 4.0521219064E-02, 3.9556819821E-02, 4.0522351749E-01],
	[6.4850000000E+03, 2.1999044883E+00, 6.8157096015E+00, 4.0615453509E-02, 3.9647210536E-02, 4.0542636917E-01],
	[6.4900000000E+03, 2.2019775287E+00, 6.8133341817E+00, 4.0709835578E-02, 3.9737736245E-02, 4.0562908597E-01],
	[6.4950000000E+03, 2.2040509239E+00, 6.8109614183E+00, 4.0804363733E-02, 3.9828395455E-02, 4.0583166824E-01],
	[6.5000000000E+03, 2.2061246736E+00, 6.8085913062E+00, 4.0899038085E-02, 3.9919188246E-02, 4.0603411630E-01],
	[6.5050000000E+03, 2.2081987776E+00, 6.8062238403E+00, 4.0993858749E-02, 4.0010114698E-02, 4.0623643049E-01],
	[6.5100000000E+03, 2.2102732357E+00, 6.8038590157E+00, 4.1088825835E-02, 4.0101174893E-02, 4.0643861116E-01],
	[6.5150000000E+03, 2.2123480477E+00, 6.8014968274E+00, 4.1183939458E-02, 4.0192368909E-02, 4.0664065864E-01],
	[6.5200000000E+03, 2.2144232135E+00, 6.7991372705E+00, 4.1279199730E-02, 4.0283696828E-02, 4.0684257326E-01],
	[6.5250000000E+03, 2.2164987326E+00, 6.7967803400E+00, 4.1374606763E-02, 4.0375158729E-02, 4.0704435536E-01],
	[6.5300000000E+03, 2.2185746051E+00, 6.7944260310E+00, 4.1470160670E-02, 4.0466754692E-02, 4.0724600527E-01],
	[6.5350000000E+03, 2.2206508306E+00, 6.7920743385E+00, 4.1565861564E-02, 4.0558484798E-02, 4.0744752332E-01],
	[6.5400000000E+03, 2.2227274090E+00, 6.7897252577E+00, 4.1661709557E-02, 4.0650349127E-02, 4.0764890984E-01],
	[6.5450000000E+03, 2.2248043399E+00, 6.7873787836E+00, 4.1757704762E-02, 4.0742347758E-02, 4.0785016516E-01],
	[6.5500000000E+03, 2.2268816234E+00, 6.7850349115E+00, 4.1853847292E-02, 4.0834480771E-02, 4.0805128961E-01],
	[6.5550000000E+03, 2.2289592590E+00, 6.7826936363E+00, 4.1950137259E-02, 4.0926748246E-02, 4.0825228353E-01],
	[6.5600000000E+03, 2.2310379334E+00, 6.7803587918E+00, 4.2046574776E-02, 4.1019150635E-02, 4.0845314722E-01],
	[6.5650000000E+03, 2.2331242832E+00, 6.7780674066E+00, 4.2143159956E-02, 4.1111691635E-02, 4.0865388104E-01],
	[6.5700000000E+03, 2.2352109935E+00, 6.7757785395E+00, 4.2239892911E-02, 4.1204367367E-02, 4.0885448529E-01],
	[6.5750000000E+03, 2.2372980639E+00, 6.7734921856E+00, 4.2336773754E-02, 4.1297177911E-02, 4.0905496030E-01],
	[6.5800000000E+03, 2.2393854944E+00, 6.7712083403E+00, 4.2433802597E-02, 4.1390123348E-02, 4.0925530640E-01],
	[6.5850000000E+03, 2.2414732847E+00, 6.7689269989E+00, 4.2530979554E-02, 4.1483203757E-02, 4.0945552391E-01],
	[6.5900000000E+03, 2.2435614345E+00, 6.7666481569E+00, 4.2628304737E-02, 4.1576419217E-02, 4.0965561315E-01],
	[6.5950000000E+03, 2.2456499437E+00, 6.7643718096E+00, 4.2725778258E-02, 4.1669769807E-02, 4.0985557445E-01],
	[6.6000000000E+03, 2.2477388121E+00, 6.7620979524E+00, 4.2823400230E-02, 4.1763255607E-02, 4.1005540812E-01],
	[6.6050000000E+03, 2.2498280395E+00, 6.7598265806E+00, 4.2921170766E-02, 4.1856876697E-02, 4.1025511448E-01],
	[6.6100000000E+03, 2.2519176255E+00, 6.7575576896E+00, 4.3019089978E-02, 4.1950633155E-02, 4.1045469386E-01],
	[6.6150000000E+03, 2.2540075701E+00, 6.7552912750E+00, 4.3117157979E-02, 4.2044525061E-02, 4.1065414657E-01],
	[6.6200000000E+03, 2.2560978730E+00, 6.7530273321E+00, 4.3215374882E-02, 4.2138552493E-02, 4.1085347292E-01],
	[6.6250000000E+03, 2.2581885340E+00, 6.7507658563E+00, 4.3313740800E-02, 4.2232715531E-02, 4.1105267324E-01],
	[6.6300000000E+03, 2.2602795530E+00, 6.7485068431E+00, 4.3412255844E-02, 4.2327014254E-02, 4.1125174783E-01],
	[6.6350000000E+03, 2.2623709296E+00, 6.7462502880E+00, 4.3510920128E-02, 4.2421448741E-02, 4.1145069702E-01],
	[6.6400000000E+03, 2.2644626637E+00, 6.7439961864E+00, 4.3609733764E-02, 4.2516019070E-02, 4.1164952112E-01],
	[6.6450000000E+03, 2.2665547550E+00, 6.7417445339E+00, 4.3708696865E-02, 4.2610725320E-02, 4.1184822044E-01],
	[6.6500000000E+03, 2.2686472035E+00, 6.7394953259E+00, 4.3807809544E-02, 4.2705567570E-02, 4.1204679529E-01],
	[6.6550000000E+03, 2.2707400088E+00, 6.7372485579E+00, 4.3907071912E-02, 4.2800545899E-02, 4.1224524598E-01],
	[6.6600000000E+03, 2.2728331707E+00, 6.7350042256E+00, 4.4006484083E-02, 4.2895660385E-02, 4.1244357283E-01],
	[6.6650000000E+03, 2.2749266891E+00, 6.7327623243E+00, 4.4106046170E-02, 4.2990911107E-02, 4.1264177614E-01],
	[6.6700000000E+03, 2.2770280361E+00, 6.7305642474E+00, 4.4205758285E-02, 4.3086302515E-02, 4.1283985622E-01],
	[6.6750000000E+03, 2.2791300124E+00, 6.7283700015E+00, 4.4305620540E-02, 4.3181830503E-02, 4.1303781339E-01],
	[6.6800000000E+03, 2.2812323529E+00, 6.7261781132E+00, 4.4405633048E-02, 4.3277494995E-02, 4.1323564794E-01],
	[6.6850000000E+03, 2.2833350575E+00, 6.7239885781E+00, 4.4505795923E-02, 4.3373296069E-02, 4.1343336019E-01],
	[6.6900000000E+03, 2.2854381260E+00, 6.7218013921E+00, 4.4606109275E-02, 4.3469233804E-02, 4.1363095044E-01],
	[6.6950000000E+03, 2.2875415582E+00, 6.7196165507E+00, 4.4706573219E-02, 4.3565308278E-02, 4.1382841900E-01],
	[6.7000000000E+03, 2.2896453537E+00, 6.7174340498E+00, 4.4807187867E-02, 4.3661519569E-02, 4.1402576617E-01],
	[6.7050000000E+03, 2.2917495125E+00, 6.7152538851E+00, 4.4907953331E-02, 4.3757867756E-02, 4.1422299225E-01],
	[6.7100000000E+03, 2.2938540344E+00, 6.7130760523E+00, 4.5008869724E-02, 4.3854352916E-02, 4.1442009755E-01],
	[6.7150000000E+03, 2.2959589190E+00, 6.7109005473E+00, 4.5109937158E-02, 4.3950975128E-02, 4.1461708236E-01],
	[6.7200000000E+03, 2.2980641663E+00, 6.7087273658E+00, 4.5211155747E-02, 4.4047734469E-02, 4.1481394700E-01],
	[6.7250000000E+03, 2.3001697759E+00, 6.7065565036E+00, 4.5312525602E-02, 4.4144631018E-02, 4.1501069176E-01],
	[6.7300000000E+03, 2.3022757478E+00, 6.7043879565E+00, 4.5414046837E-02, 4.4241664852E-02, 4.1520731693E-01],
	[6.7350000000E+03, 2.3043820816E+00, 6.7022217203E+00, 4.5515719564E-02, 4.4338836049E-02, 4.1540382284E-01],
	[6.7400000000E+03, 2.3064887772E+00, 6.7000577909E+00, 4.5617543895E-02, 4.4436144687E-02, 4.1560020999E-01],
	[6.7450000000E+03, 2.3085958344E+00, 6.6978961640E+00, 4.5719519944E-02, 4.4533590844E-02, 4.1579647876E-01],
	[6.7500000000E+03, 2.3107032530E+00, 6.6957368356E+00, 4.5821647822E-02, 4.4631174597E-02, 4.1599262944E-01],
	[6.7550000000E+03, 2.3128110327E+00, 6.6935798014E+00, 4.5923927643E-02, 4.4728896023E-02, 4.1618866231E-01],
	[6.7600000000E+03, 2.3149191734E+00, 6.6914250574E+00, 4.6026359519E-02, 4.4826755200E-02, 4.1638457766E-01],
	[6.7650000000E+03, 2.3170276748E+00, 6.6892725994E+00, 4.6128943563E-02, 4.4924752206E-02, 4.1658037578E-01],
	[6.7700000000E+03, 2.3191365368E+00, 6.6871224233E+00, 4.6231679887E-02, 4.5022887117E-02, 4.1677605695E-01],
	[6.7750000000E+03, 2.3212495326E+00, 6.6849953071E+00, 4.6334568603E-02, 4.5121162385E-02, 4.1697162145E-01],
	[6.7800000000E+03, 2.3233665829E+00, 6.6828907342E+00, 4.6437609825E-02, 4.5219578056E-02, 4.1716706956E-01],
	[6.7850000000E+03, 2.3254840011E+00, 6.6807883747E+00, 4.6540803666E-02, 4.5318131899E-02, 4.1736240158E-01],
	[6.7900000000E+03, 2.3276017872E+00, 6.6786882246E+00, 4.6644150237E-02, 4.5416823991E-02, 4.1755761777E-01],
	[6.7950000000E+03, 2.3297199409E+00, 6.6765902798E+00, 4.6747649651E-02, 4.5515654407E-02, 4.1775271842E-01],
	[6.8000000000E+03, 2.3318384619E+00, 6.6744945365E+00, 4.6851302021E-02, 4.5614623227E-02, 4.1794770382E-01],
	[6.8050000000E+03, 2.3339573501E+00, 6.6724009908E+00, 4.6955107459E-02, 4.5713730526E-02, 4.1814257423E-01],
	[6.8100000000E+03, 2.3360766053E+00, 6.6703096386E+00, 4.7059066079E-02, 4.5812976381E-02, 4.1833732995E-01],
	[6.8150000000E+03, 2.3381962273E+00, 6.6682204762E+00, 4.7163177992E-02, 4.5912360870E-02, 4.1853197124E-01],
	[6.8200000000E+03, 2.3403162158E+00, 6.6661334996E+00, 4.7267443311E-02, 4.6011884070E-02, 4.1872649838E-01],
	[6.8250000000E+03, 2.3424365707E+00, 6.6640487049E+00, 4.7371862149E-02, 4.6111546057E-02, 4.1892091166E-01],
	[6.8300000000E+03, 2.3445572917E+00, 6.6619660883E+00, 4.7476434619E-02, 4.6211346907E-02, 4.1911521135E-01],
	[6.8350000000E+03, 2.3466783787E+00, 6.6598856459E+00, 4.7581160832E-02, 4.6311286698E-02, 4.1930939771E-01],
	[6.8400000000E+03, 2.3487998315E+00, 6.6578073738E+00, 4.7686040902E-02, 4.6411365506E-02, 4.1950347104E-01],
	[6.8450000000E+03, 2.3509216497E+00, 6.6557312682E+00, 4.7791074942E-02, 4.6511583408E-02, 4.1969743159E-01],
	[6.8500000000E+03, 2.3530438333E+00, 6.6536573252E+00, 4.7896263063E-02, 4.6611940480E-02, 4.1989127965E-01],
	[6.8550000000E+03, 2.3551663821E+00, 6.6515855410E+00, 4.8001605378E-02, 4.6712436798E-02, 4.2008501548E-01],
	[6.8600000000E+03, 2.3572892957E+00, 6.6495159119E+00, 4.8107102000E-02, 4.6813072439E-02, 4.2027863937E-01],
	[6.8650000000E+03, 2.3594125741E+00, 6.6474484339E+00, 4.8212753042E-02, 4.6913847479E-02, 4.2047215157E-01],
	[6.8700000000E+03, 2.3615362170E+00, 6.6453831033E+00, 4.8318558616E-02, 4.7014761994E-02, 4.2066555237E-01],
	[6.8750000000E+03, 2.3636602242E+00, 6.6433199163E+00, 4.8424518835E-02, 4.7115816060E-02, 4.2085884203E-01],
	[6.8800000000E+03, 2.3657845955E+00, 6.6412588691E+00, 4.8530633810E-02, 4.7217009754E-02, 4.2105202081E-01],
	[6.8850000000E+03, 2.3679143633E+00, 6.6392275232E+00, 4.8636903656E-02, 4.7318346561E-02, 4.2124508900E-01],
	[6.8900000000E+03, 2.3700466560E+00, 6.6372100672E+00, 4.8743328484E-02, 4.7419824637E-02, 4.2143804685E-01],
	[6.8950000000E+03, 2.3721793199E+00, 6.6351946870E+00, 4.8849908407E-02, 4.7521442602E-02, 4.2163089464E-01],
	[6.9000000000E+03, 2.3743123548E+00, 6.6331813791E+00, 4.8956643537E-02, 4.7623200533E-02, 4.2182363262E-01],
	[6.9050000000E+03, 2.3764457605E+00, 6.6311701398E+00, 4.9063533988E-02, 4.7725098505E-02, 4.2201626108E-01],
	[6.9100000000E+03, 2.3785795367E+00, 6.6291609655E+00, 4.9170579871E-02, 4.7827136595E-02, 4.2220878026E-01],
	[6.9150000000E+03, 2.3807136834E+00, 6.6271538527E+00, 4.9277781300E-02, 4.7929314877E-02, 4.2240119045E-01],
	[6.9200000000E+03, 2.3828482003E+00, 6.6251487975E+00, 4.9385138386E-02, 4.8031633429E-02, 4.2259349189E-01],
	[6.9250000000E+03, 2.3849830871E+00, 6.6231457966E+00, 4.9492651243E-02, 4.8134092324E-02, 4.2278568487E-01],
	[6.9300000000E+03, 2.3871183438E+00, 6.6211448463E+00, 4.9600319982E-02, 4.8236691640E-02, 4.2297776963E-01],
	[6.9350000000E+03, 2.3892539700E+00, 6.6191459430E+00, 4.9708144717E-02, 4.8339431451E-02, 4.2316974644E-01],
	[6.9400000000E+03, 2.3913899655E+00, 6.6171490832E+00, 4.9816125561E-02, 4.8442311833E-02, 4.2336161556E-01],
	[6.9450000000E+03, 2.3935263303E+00, 6.6151542633E+00, 4.9924262625E-02, 4.8545332861E-02, 4.2355337725E-01],
	[6.9500000000E+03, 2.3956630640E+00, 6.6131614798E+00, 5.0032556022E-02, 4.8648494610E-02, 4.2374503178E-01],
	[6.9550000000E+03, 2.3978001665E+00, 6.6111707290E+00, 5.0141005865E-02, 4.8751797156E-02, 4.2393657941E-01],
	[6.9600000000E+03, 2.3999376376E+00, 6.6091820075E+00, 5.0249612266E-02, 4.8855240574E-02, 4.2412802038E-01],
	[6.9650000000E+03, 2.4020754770E+00, 6.6071953118E+00, 5.0358375338E-02, 4.8958824939E-02, 4.2431935497E-01],
	[6.9700000000E+03, 2.4042136846E+00, 6.6052106383E+00, 5.0467295194E-02, 4.9062550326E-02, 4.2451058343E-01],
	[6.9750000000E+03, 2.4063522601E+00, 6.6032279836E+00, 5.0576371945E-02, 4.9166416810E-02, 4.2470170602E-01],
	[6.9800000000E+03, 2.4084912034E+00, 6.6012473441E+00, 5.0685605705E-02, 4.9270424466E-02, 4.2489272299E-01],
	[6.9850000000E+03, 2.4106305143E+00, 6.5992687163E+00, 5.0794996587E-02, 4.9374573368E-02, 4.2508363460E-01],
	[6.9900000000E+03, 2.4127701925E+00, 6.5972920968E+00, 5.0904544702E-02, 4.9478863592E-02, 4.2527444110E-01],
	[6.9950000000E+03, 2.4149140015E+00, 6.5953379831E+00, 5.1014250163E-02, 4.9583297957E-02, 4.2546514276E-01],
	[7.0000000000E+03, 2.4170613424E+00, 6.5934030417E+00, 5.1124113083E-02, 4.9687876125E-02, 4.2565573983E-01],
	[7.0050000000E+03, 2.4192090574E+00, 6.5914700491E+00, 5.1235269518E-02, 4.9793668793E-02, 4.2584623255E-01],
	[7.0100000000E+03, 2.4213571463E+00, 6.5895390017E+00, 5.1346587759E-02, 4.9899606817E-02, 4.2603662119E-01],
	[7.0150000000E+03, 2.4235056089E+00, 6.5876098963E+00, 5.1458067923E-02, 5.0005690275E-02, 4.2622690599E-01],
	[7.0200000000E+03, 2.4256544449E+00, 6.5856827296E+00, 5.1569710131E-02, 5.0111919247E-02, 4.2641708721E-01],
	[7.0250000000E+03, 2.4278036543E+00, 6.5837574981E+00, 5.1681514501E-02, 5.0218293813E-02, 4.2660716510E-01],
	[7.0300000000E+03, 2.4299532368E+00, 6.5818341987E+00, 5.1793481152E-02, 5.0324814052E-02, 4.2679713992E-01],
	[7.0350000000E+03, 2.4321031922E+00, 6.5799128280E+00, 5.1905610205E-02, 5.0431480043E-02, 4.2698701190E-01],
	[7.0400000000E+03, 2.4342535202E+00, 6.5779933826E+00, 5.2017901777E-02, 5.0538291866E-02, 4.2717678131E-01],
	[7.0450000000E+03, 2.4364042208E+00, 6.5760758594E+00, 5.2130355989E-02, 5.0645249599E-02, 4.2736644838E-01],
	[7.0500000000E+03, 2.4385552937E+00, 6.5741602549E+00, 5.2242972958E-02, 5.0752353321E-02, 4.2755601338E-01],
	[7.0550000000E+03, 2.4407067386E+00, 6.5722465660E+00, 5.2355752806E-02, 5.0859603112E-02, 4.2774547655E-01],
	[7.0600000000E+03, 2.4428585555E+00, 6.5703347893E+00, 5.2468695650E-02, 5.0966999050E-02, 4.2793483813E-01],
	[7.0650000000E+03, 2.4450107440E+00, 6.5684249216E+00, 5.2581801610E-02, 5.1074541215E-02, 4.2812409837E-01],
	[7.0700000000E+03, 2.4471633040E+00, 6.5665169596E+00, 5.2695070805E-02, 5.1182229685E-02, 4.2831325753E-01],
	[7.0750000000E+03, 2.4493162354E+00, 6.5646109001E+00, 5.2808503354E-02, 5.1290064538E-02, 4.2850231584E-01],
	[7.0800000000E+03, 2.4514695378E+00, 6.5627067399E+00, 5.2922099377E-02, 5.1398045854E-02, 4.2869127355E-01],
	[7.0850000000E+03, 2.4536232111E+00, 6.5608044757E+00, 5.3035858993E-02, 5.1506173711E-02, 4.2888013091E-01],
	[7.0900000000E+03, 2.4557772552E+00, 6.5589041043E+00, 5.3149782320E-02, 5.1614448187E-02, 4.2906888815E-01],
	[7.0950000000E+03, 2.4579316697E+00, 6.5570056224E+00, 5.3263869479E-02, 5.1722869361E-02, 4.2925754554E-01],
	[7.1000000000E+03, 2.4600864546E+00, 6.5551090269E+00, 5.3378120588E-02, 5.1831437312E-02, 4.2944610330E-01],
	[7.1050000000E+03, 2.4622418139E+00, 6.5532154126E+00, 5.3492535766E-02, 5.1940152276E-02, 4.2963456168E-01],
	[7.1100000000E+03, 2.4644040637E+00, 6.5513586666E+00, 5.3607115134E-02, 5.2049019292E-02, 4.2982292093E-01],
	[7.1150000000E+03, 2.4665666902E+00, 6.5495037513E+00, 5.3721858809E-02, 5.2158033356E-02, 4.3001118128E-01],
	[7.1200000000E+03, 2.4687296933E+00, 6.5476506638E+00, 5.3836766911E-02, 5.2267194545E-02, 4.3019934298E-01],
	[7.1250000000E+03, 2.4708930728E+00, 6.5457994009E+00, 5.3951839560E-02, 5.2376502938E-02, 4.3038740627E-01],
	[7.1300000000E+03, 2.4730568284E+00, 6.5439499596E+00, 5.4067076874E-02, 5.2485958613E-02, 4.3057537138E-01],
	[7.1350000000E+03, 2.4752209600E+00, 6.5421023367E+00, 5.4182478973E-02, 5.2595561648E-02, 4.3076323856E-01],
	[7.1400000000E+03, 2.4773854674E+00, 6.5402565292E+00, 5.4298045976E-02, 5.2705312121E-02, 4.3095100805E-01],
	[7.1450000000E+03, 2.4795503504E+00, 6.5384125341E+00, 5.4413778003E-02, 5.2815210110E-02, 4.3113868008E-01],
	[7.1500000000E+03, 2.4817156087E+00, 6.5365703484E+00, 5.4529675171E-02, 5.2925255693E-02, 4.3132625490E-01],
	[7.1550000000E+03, 2.4838812423E+00, 6.5347299689E+00, 5.4645737602E-02, 5.3035448948E-02, 4.3151373274E-01],
	[7.1600000000E+03, 2.4860472508E+00, 6.5328913926E+00, 5.4761965413E-02, 5.3145789951E-02, 4.3170111383E-01],
	[7.1650000000E+03, 2.4882136341E+00, 6.5310546166E+00, 5.4878358725E-02, 5.3256278781E-02, 4.3188839843E-01],
	[7.1700000000E+03, 2.4903803920E+00, 6.5292196378E+00, 5.4994917656E-02, 5.3366915516E-02, 4.3207558675E-01],
	[7.1750000000E+03, 2.4925475243E+00, 6.5273864532E+00, 5.5111642325E-02, 5.3477700233E-02, 4.3226267904E-01],
	[7.1800000000E+03, 2.4947150308E+00, 6.5255550598E+00, 5.5228532853E-02, 5.3588633008E-02, 4.3244967553E-01],
	[7.1850000000E+03, 2.4968829113E+00, 6.5237254545E+00, 5.5345589357E-02, 5.3699713920E-02, 4.3263657646E-01],
	[7.1900000000E+03, 2.4990511657E+00, 6.5218976345E+00, 5.5462811958E-02, 5.3810943046E-02, 4.3282338207E-01],
	[7.1950000000E+03, 2.5012197936E+00, 6.5200715967E+00, 5.5580200774E-02, 5.3922320464E-02, 4.3301009257E-01],
	[7.2000000000E+03, 2.5033887949E+00, 6.5182473382E+00, 5.5697755925E-02, 5.4033846249E-02, 4.3319670822E-01],
	[7.2050000000E+03, 2.5055581695E+00, 6.5164248560E+00, 5.5815477530E-02, 5.4145520479E-02, 4.3338322924E-01],
	[7.2100000000E+03, 2.5077279171E+00, 6.5146041470E+00, 5.5933365708E-02, 5.4257343232E-02, 4.3356965586E-01],
	[7.2150000000E+03, 2.5098980375E+00, 6.5127852085E+00, 5.6051420579E-02, 5.4369314583E-02, 4.3375598831E-01],
	[7.2200000000E+03, 2.5120695427E+00, 6.5109733832E+00, 5.6169642261E-02, 5.4481435461E-02, 4.3394222683E-01],
	[7.2250000000E+03, 2.5142469530E+00, 6.5091925010E+00, 5.6288030874E-02, 5.4593709759E-02, 4.3412837165E-01],
	[7.2300000000E+03, 2.5164247423E+00, 6.5074133375E+00, 5.6406586538E-02, 5.4706132924E-02, 4.3431442300E-01],
	[7.2350000000E+03, 2.5186029105E+00, 6.5056358898E+00, 5.6525309371E-02, 5.4818705032E-02, 4.3450038111E-01],
	[7.2400000000E+03, 2.5207814574E+00, 6.5038601550E+00, 5.6644199493E-02, 5.4931426161E-02, 4.3468624620E-01],
	[7.2450000000E+03, 2.5229603827E+00, 6.5020861303E+00, 5.6763257023E-02, 5.5044296387E-02, 4.3487201851E-01],
	[7.2500000000E+03, 2.5251396863E+00, 6.5003138128E+00, 5.6882482080E-02, 5.5157315787E-02, 4.3505769826E-01],
	[7.2550000000E+03, 2.5273193679E+00, 6.4985431999E+00, 5.7001874783E-02, 5.5270484437E-02, 4.3524328569E-01],
	[7.2600000000E+03, 2.5294994274E+00, 6.4967742886E+00, 5.7121435252E-02, 5.5383802414E-02, 4.3542878102E-01],
	[7.2650000000E+03, 2.5316798645E+00, 6.4950070761E+00, 5.7241163606E-02, 5.5497269794E-02, 4.3561418447E-01],
	[7.2700000000E+03, 2.5338606791E+00, 6.4932415596E+00, 5.7361059965E-02, 5.5610886654E-02, 4.3579949628E-01],
	[7.2750000000E+03, 2.5360418711E+00, 6.4914777365E+00, 5.7481124447E-02, 5.5724653069E-02, 4.3598471667E-01],
	[7.2800000000E+03, 2.5382234401E+00, 6.4897156037E+00, 5.7601357171E-02, 5.5838569115E-02, 4.3616984587E-01],
	[7.2850000000E+03, 2.5404053859E+00, 6.4879551587E+00, 5.7721758258E-02, 5.5952634870E-02, 4.3635488410E-01],
	[7.2900000000E+03, 2.5425877085E+00, 6.4861963986E+00, 5.7842327826E-02, 5.6066850408E-02, 4.3653983158E-01],
	[7.2950000000E+03, 2.5447704076E+00, 6.4844393206E+00, 5.7963065995E-02, 5.6181215806E-02, 4.3672468855E-01],
	[7.3000000000E+03, 2.5469534830E+00, 6.4826839220E+00, 5.8083972883E-02, 5.6295731139E-02, 4.3690945522E-01],
	[7.3050000000E+03, 2.5491369346E+00, 6.4809302001E+00, 5.8205048611E-02, 5.6410396484E-02, 4.3709413182E-01],
	[7.3100000000E+03, 2.5513207620E+00, 6.4791781520E+00, 5.8326293297E-02, 5.6525211916E-02, 4.3727871857E-01],
	[7.3150000000E+03, 2.5535049652E+00, 6.4774277750E+00, 5.8447707060E-02, 5.6640177511E-02, 4.3746321569E-01],
	[7.3200000000E+03, 2.5556895440E+00, 6.4756790665E+00, 5.8569290021E-02, 5.6755293344E-02, 4.3764762342E-01],
	[7.3250000000E+03, 2.5578744981E+00, 6.4739320237E+00, 5.8691042298E-02, 5.6870559491E-02, 4.3783194196E-01],
	[7.3300000000E+03, 2.5600598273E+00, 6.4721866438E+00, 5.8812964010E-02, 5.6985976027E-02, 4.3801617154E-01],
	[7.3350000000E+03, 2.5622455315E+00, 6.4704429241E+00, 5.8935055277E-02, 5.7101543028E-02, 4.3820031238E-01],
	[7.3400000000E+03, 2.5644374044E+00, 6.4687309468E+00, 5.9057316218E-02, 5.7217265807E-02, 4.3838436470E-01],
	[7.3450000000E+03, 2.5666302257E+00, 6.4670235328E+00, 5.9179746952E-02, 5.7333139751E-02, 4.3856832872E-01],
	[7.3500000000E+03, 2.5688234278E+00, 6.4653177309E+00, 5.9302347599E-02, 5.7449164424E-02, 4.3875220467E-01],
	[7.3550000000E+03, 2.5710170107E+00, 6.4636135386E+00, 5.9425118278E-02, 5.7565339901E-02, 4.3893599275E-01],
	[7.3600000000E+03, 2.5732109741E+00, 6.4619109531E+00, 5.9548059108E-02, 5.7681666258E-02, 4.3911969320E-01],
	[7.3650000000E+03, 2.5754053179E+00, 6.4602099719E+00, 5.9671170208E-02, 5.7798143570E-02, 4.3930330622E-01],
	[7.3700000000E+03, 2.5776000418E+00, 6.4585105923E+00, 5.9794451698E-02, 5.7914771911E-02, 4.3948683204E-01],
	[7.3750000000E+03, 2.5797951457E+00, 6.4568128119E+00, 5.9917903698E-02, 5.8031551357E-02, 4.3967027087E-01],
	[7.3800000000E+03, 2.5819906293E+00, 6.4551166280E+00, 6.0041526325E-02, 5.8148481982E-02, 4.3985362293E-01],
	[7.3850000000E+03, 2.5841864925E+00, 6.4534220379E+00, 6.0165319700E-02, 5.8265563861E-02, 4.4003688844E-01],
	[7.3900000000E+03, 2.5863827351E+00, 6.4517290392E+00, 6.0289283943E-02, 5.8382797069E-02, 4.4022006762E-01],
	[7.3950000000E+03, 2.5885793569E+00, 6.4500376293E+00, 6.0413419171E-02, 5.8500181681E-02, 4.4040316067E-01],
	[7.4000000000E+03, 2.5907763576E+00, 6.4483478056E+00, 6.0537725505E-02, 5.8617717771E-02, 4.4058616782E-01],
	[7.4050000000E+03, 2.5929737372E+00, 6.4466595656E+00, 6.0662203064E-02, 5.8735405413E-02, 4.4076908927E-01],
	[7.4100000000E+03, 2.5951714954E+00, 6.4449729066E+00, 6.0786851966E-02, 5.8853244683E-02, 4.4095192526E-01],
	[7.4150000000E+03, 2.5973696321E+00, 6.4432878262E+00, 6.0911672333E-02, 5.8971235654E-02, 4.4113467598E-01],
	[7.4200000000E+03, 2.5995681469E+00, 6.4416043218E+00, 6.1036664282E-02, 5.9089378401E-02, 4.4131734165E-01],
	[7.4250000000E+03, 2.6017670399E+00, 6.4399223909E+00, 6.1161827933E-02, 5.9207672998E-02, 4.4149992250E-01],
	[7.4300000000E+03, 2.6039663106E+00, 6.4382420309E+00, 6.1287163405E-02, 5.9326119520E-02, 4.4168241872E-01],
	[7.4350000000E+03, 2.6061659591E+00, 6.4365632394E+00, 6.1412670818E-02, 5.9444718039E-02, 4.4186483054E-01],
	[7.4400000000E+03, 2.6083659850E+00, 6.4348860137E+00, 6.1538350291E-02, 5.9563468630E-02, 4.4204715816E-01],
	[7.4450000000E+03, 2.6105663882E+00, 6.4332103515E+00, 6.1664201943E-02, 5.9682371368E-02, 4.4222940179E-01],
	[7.4500000000E+03, 2.6127671685E+00, 6.4315362502E+00, 6.1790225894E-02, 5.9801426326E-02, 4.4241156166E-01],
	[7.4550000000E+03, 2.6149701332E+00, 6.4298729534E+00, 6.1916422263E-02, 5.9920635329E-02, 4.4259363797E-01],
	[7.4600000000E+03, 2.6171778475E+00, 6.4282335370E+00, 6.2042791169E-02, 6.0040000961E-02, 4.4277563093E-01],
	[7.4650000000E+03, 2.6193859446E+00, 6.4265956366E+00, 6.2169332732E-02, 6.0159519073E-02, 4.4295754075E-01],
	[7.4700000000E+03, 2.6215944242E+00, 6.4249592499E+00, 6.2296047070E-02, 6.0279189740E-02, 4.4313936764E-01],
	[7.4750000000E+03, 2.6238032864E+00, 6.4233243743E+00, 6.2422934304E-02, 6.0399013035E-02, 4.4332111181E-01],
	[7.4800000000E+03, 2.6260125307E+00, 6.4216910076E+00, 6.2549994552E-02, 6.0518989032E-02, 4.4350277348E-01],
	[7.4850000000E+03, 2.6282221571E+00, 6.4200591472E+00, 6.2677227934E-02, 6.0639117804E-02, 4.4368435284E-01],
	[7.4900000000E+03, 2.6304321653E+00, 6.4184287908E+00, 6.2804634569E-02, 6.0759399426E-02, 4.4386585011E-01],
	[7.4950000000E+03, 2.6326425552E+00, 6.4167999360E+00, 6.2932214576E-02, 6.0879833969E-02, 4.4404726550E-01],
	[7.5000000000E+03, 2.6348533266E+00, 6.4151725804E+00, 6.3059968076E-02, 6.1000421507E-02, 4.4422859921E-01],
	[7.5050000000E+03, 2.6370644793E+00, 6.4135467217E+00, 6.3187895186E-02, 6.1121162115E-02, 4.4440985145E-01],
	[7.5100000000E+03, 2.6392760131E+00, 6.4119223574E+00, 6.3315996027E-02, 6.1242055864E-02, 4.4459102244E-01],
	[7.5150000000E+03, 2.6414879278E+00, 6.4102994853E+00, 6.3444270718E-02, 6.1363102827E-02, 4.4477211237E-01],
	[7.5200000000E+03, 2.6437002232E+00, 6.4086781028E+00, 6.3572719378E-02, 6.1484303079E-02, 4.4495312145E-01],
	[7.5250000000E+03, 2.6459128992E+00, 6.4070582078E+00, 6.3701342126E-02, 6.1605656691E-02, 4.4513404989E-01],
	[7.5300000000E+03, 2.6481259555E+00, 6.4054397978E+00, 6.3830139082E-02, 6.1727163737E-02, 4.4531489788E-01],
	[7.5350000000E+03, 2.6503393920E+00, 6.4038228704E+00, 6.3959110366E-02, 6.1848824289E-02, 4.4549566568E-01],
	[7.5400000000E+03, 2.6525532085E+00, 6.4022074235E+00, 6.4088256096E-02, 6.1970638419E-02, 4.4567635347E-01],
	[7.5450000000E+03, 2.6547674047E+00, 6.4005934545E+00, 6.4217576391E-02, 6.2092606202E-02, 4.4585696142E-01],
	[7.5500000000E+03, 2.6569819806E+00, 6.3989809612E+00, 6.4347071372E-02, 6.2214727709E-02, 4.4603748969E-01],
	[7.5550000000E+03, 2.6591969358E+00, 6.3973699413E+00, 6.4476741157E-02, 6.2337003012E-02, 4.4621793847E-01],
	[7.5600000000E+03, 2.6614122703E+00, 6.3957603923E+00, 6.4606585867E-02, 6.2459432184E-02, 4.4639830792E-01],
	[7.5650000000E+03, 2.6636279839E+00, 6.3941523122E+00, 6.4736605619E-02, 6.2582015298E-02, 4.4657859822E-01],
	[7.5700000000E+03, 2.6658440763E+00, 6.3925456984E+00, 6.4866800534E-02, 6.2704752425E-02, 4.4675880954E-01],
	[7.5750000000E+03, 2.6680623107E+00, 6.3909494353E+00, 6.4997170731E-02, 6.2827645474E-02, 4.4693894205E-01],
	[7.5800000000E+03, 2.6702851560E+00, 6.3893759217E+00, 6.5127716329E-02, 6.2950697112E-02, 4.4711899592E-01],
	[7.5850000000E+03, 2.6725083856E+00, 6.3878038328E+00, 6.5258437448E-02, 6.3073903021E-02, 4.4729897132E-01],
	[7.5900000000E+03, 2.6747319993E+00, 6.3862331663E+00, 6.5389334207E-02, 6.3197263272E-02, 4.4747886843E-01],
	[7.5950000000E+03, 2.6769559970E+00, 6.3846639199E+00, 6.5520406725E-02, 6.3320777938E-02, 4.4765868740E-01],
	[7.6000000000E+03, 2.6791803784E+00, 6.3830960915E+00, 6.5651655121E-02, 6.3444447091E-02, 4.4783842842E-01],
	[7.6050000000E+03, 2.6814051434E+00, 6.3815296788E+00, 6.5783079516E-02, 6.3568270803E-02, 4.4801809165E-01],
	[7.6100000000E+03, 2.6836302918E+00, 6.3799646797E+00, 6.5914680028E-02, 6.3692249145E-02, 4.4819767726E-01],
	[7.6150000000E+03, 2.6858558234E+00, 6.3784010919E+00, 6.6046456777E-02, 6.3816382189E-02, 4.4837718541E-01],
	[7.6200000000E+03, 2.6880817380E+00, 6.3768389133E+00, 6.6178409882E-02, 6.3940670007E-02, 4.4855661629E-01],
	[7.6250000000E+03, 2.6903080354E+00, 6.3752781416E+00, 6.6310539463E-02, 6.4065112671E-02, 4.4873597005E-01],
	[7.6300000000E+03, 2.6925347155E+00, 6.3737187746E+00, 6.6442845638E-02, 6.4189710251E-02, 4.4891524687E-01],
	[7.6350000000E+03, 2.6947617780E+00, 6.3721608103E+00, 6.6575328528E-02, 6.4314462820E-02, 4.4909444691E-01],
	[7.6400000000E+03, 2.6969892228E+00, 6.3706042463E+00, 6.6707988251E-02, 6.4439370449E-02, 4.4927357033E-01],
	[7.6450000000E+03, 2.6992170497E+00, 6.3690490805E+00, 6.6840824927E-02, 6.4564433209E-02, 4.4945261732E-01],
	[7.6500000000E+03, 2.7014452584E+00, 6.3674953108E+00, 6.6973838675E-02, 6.4689651170E-02, 4.4963158802E-01],
	[7.6550000000E+03, 2.7036738489E+00, 6.3659429349E+00, 6.7107029616E-02, 6.4815024406E-02, 4.4981048262E-01],
	[7.6600000000E+03, 2.7059028210E+00, 6.3643919508E+00, 6.7240397867E-02, 6.4940552985E-02, 4.4998930127E-01],
	[7.6650000000E+03, 2.7081321743E+00, 6.3628423563E+00, 6.7373943549E-02, 6.5066236980E-02, 4.5016804415E-01],
	[7.6700000000E+03, 2.7103619089E+00, 6.3612941492E+00, 6.7507666780E-02, 6.5192076462E-02, 4.5034671141E-01],
	[7.6750000000E+03, 2.7125920244E+00, 6.3597473273E+00, 6.7641567681E-02, 6.5318071500E-02, 4.5052530323E-01],
	[7.6800000000E+03, 2.7148225207E+00, 6.3582018886E+00, 6.7775646370E-02, 6.5444222167E-02, 4.5070381976E-01],
	[7.6850000000E+03, 2.7170533977E+00, 6.3566578309E+00, 6.7909902967E-02, 6.5570528532E-02, 4.5088226118E-01],
	[7.6900000000E+03, 2.7192846551E+00, 6.3551151521E+00, 6.8044337592E-02, 6.5696990666E-02, 4.5106062764E-01],
	[7.6950000000E+03, 2.7215162927E+00, 6.3535738499E+00, 6.8178950364E-02, 6.5823608640E-02, 4.5123891932E-01],
	[7.7000000000E+03, 2.7237535931E+00, 6.3520601533E+00, 6.8313741401E-02, 6.5950388449E-02, 4.5141713637E-01],
	[7.7050000000E+03, 2.7259918041E+00, 6.3505504054E+00, 6.8448710824E-02, 6.6077324867E-02, 4.5159527896E-01],
	[7.7100000000E+03, 2.7282304005E+00, 6.3490419954E+00, 6.8583858752E-02, 6.6204417378E-02, 4.5177334726E-01],
	[7.7150000000E+03, 2.7304693822E+00, 6.3475349212E+00, 6.8719185304E-02, 6.6331666053E-02, 4.5195134142E-01],
	[7.7200000000E+03, 2.7327087489E+00, 6.3460291808E+00, 6.8854690600E-02, 6.6459070960E-02, 4.5212926161E-01],
	[7.7250000000E+03, 2.7349485006E+00, 6.3445247722E+00, 6.8990374759E-02, 6.6586632172E-02, 4.5230710800E-01],
	[7.7300000000E+03, 2.7371886371E+00, 6.3430216932E+00, 6.9126237900E-02, 6.6714349758E-02, 4.5248488073E-01],
	[7.7350000000E+03, 2.7394291580E+00, 6.3415199420E+00, 6.9262280144E-02, 6.6842223787E-02, 4.5266257999E-01],
	[7.7400000000E+03, 2.7416700633E+00, 6.3400195163E+00, 6.9398501608E-02, 6.6970254331E-02, 4.5284020592E-01],
	[7.7450000000E+03, 2.7439113529E+00, 6.3385204143E+00, 6.9534902413E-02, 6.7098441459E-02, 4.5301775869E-01],
	[7.7500000000E+03, 2.7461530264E+00, 6.3370226339E+00, 6.9671482679E-02, 6.7226785240E-02, 4.5319523847E-01],
	[7.7550000000E+03, 2.7483950837E+00, 6.3355261730E+00, 6.9808242523E-02, 6.7355285745E-02, 4.5337264541E-01],
	[7.7600000000E+03, 2.7506375247E+00, 6.3340310298E+00, 6.9945182067E-02, 6.7483943043E-02, 4.5354997967E-01],
	[7.7650000000E+03, 2.7528803491E+00, 6.3325372021E+00, 7.0082301429E-02, 6.7612757205E-02, 4.5372724141E-01],
	[7.7700000000E+03, 2.7551235568E+00, 6.3310446879E+00, 7.0219600728E-02, 6.7741728298E-02, 4.5390443080E-01],
	[7.7750000000E+03, 2.7573671476E+00, 6.3295534853E+00, 7.0357080084E-02, 6.7870856394E-02, 4.5408154799E-01],
	[7.7800000000E+03, 2.7596111212E+00, 6.3280635922E+00, 7.0494739617E-02, 6.8000141561E-02, 4.5425859315E-01],
	[7.7850000000E+03, 2.7618554777E+00, 6.3265750068E+00, 7.0632579446E-02, 6.8129583869E-02, 4.5443556643E-01],
	[7.7900000000E+03, 2.7641002166E+00, 6.3250877269E+00, 7.0770599691E-02, 6.8259183386E-02, 4.5461246799E-01],
	[7.7950000000E+03, 2.7663453380E+00, 6.3236017506E+00, 7.0908800469E-02, 6.8388940183E-02, 4.5478929799E-01],
	[7.8000000000E+03, 2.7685908415E+00, 6.3221170759E+00, 7.1047181902E-02, 6.8518854328E-02, 4.5496605660E-01],
	[7.8050000000E+03, 2.7708367271E+00, 6.3206337009E+00, 7.1185744109E-02, 6.8648925890E-02, 4.5514274396E-01],
	[7.8100000000E+03, 2.7730829944E+00, 6.3191516236E+00, 7.1324487208E-02, 6.8779154938E-02, 4.5531936024E-01],
	[7.8150000000E+03, 2.7753296434E+00, 6.3176708420E+00, 7.1463411320E-02, 6.8909541541E-02, 4.5549590560E-01],
	[7.8200000000E+03, 2.7775774174E+00, 6.3161949997E+00, 7.1602516564E-02, 6.9040086663E-02, 4.5567238018E-01],
	[7.8250000000E+03, 2.7798304508E+00, 6.3147443357E+00, 7.1741803059E-02, 6.9170795369E-02, 4.5584878416E-01],
	[7.8300000000E+03, 2.7820838709E+00, 6.3132949313E+00, 7.1881270924E-02, 6.9301661880E-02, 4.5602511769E-01],
	[7.8350000000E+03, 2.7843376773E+00, 6.3118467845E+00, 7.2020920280E-02, 6.9432686263E-02, 4.5620138092E-01],
	[7.8400000000E+03, 2.7865918701E+00, 6.3103998933E+00, 7.2160751245E-02, 6.9563868587E-02, 4.5637757401E-01],
	[7.8450000000E+03, 2.7888464489E+00, 6.3089542560E+00, 7.2300763939E-02, 6.9695208922E-02, 4.5655369713E-01],
	[7.8500000000E+03, 2.7911014136E+00, 6.3075098707E+00, 7.2440958481E-02, 6.9826707335E-02, 4.5672975041E-01],
	[7.8550000000E+03, 2.7933567640E+00, 6.3060667354E+00, 7.2581334991E-02, 6.9958363894E-02, 4.5690573403E-01],
	[7.8600000000E+03, 2.7956125000E+00, 6.3046248483E+00, 7.2721893588E-02, 7.0090178669E-02, 4.5708164813E-01],
	[7.8650000000E+03, 2.7978686213E+00, 6.3031842075E+00, 7.2862634392E-02, 7.0222151727E-02, 4.5725749287E-01],
	[7.8700000000E+03, 2.8001251278E+00, 6.3017448112E+00, 7.3003557522E-02, 7.0354283137E-02, 4.5743326841E-01],
	[7.8750000000E+03, 2.8023820193E+00, 6.3003066574E+00, 7.3144663097E-02, 7.0486572966E-02, 4.5760897490E-01],
	[7.8800000000E+03, 2.8046392957E+00, 6.2988697444E+00, 7.3285951237E-02, 7.0619021283E-02, 4.5778461250E-01],
	[7.8850000000E+03, 2.8068969567E+00, 6.2974340702E+00, 7.3427422062E-02, 7.0751628156E-02, 4.5796018136E-01],
	[7.8900000000E+03, 2.8091550021E+00, 6.2959996330E+00, 7.3569075690E-02, 7.0884393652E-02, 4.5813568164E-01],
	[7.8950000000E+03, 2.8114134318E+00, 6.2945664310E+00, 7.3710912242E-02, 7.1017317839E-02, 4.5831111348E-01],
	[7.9000000000E+03, 2.8136722457E+00, 6.2931344623E+00, 7.3852931836E-02, 7.1150400786E-02, 4.5848647705E-01],
	[7.9050000000E+03, 2.8159314434E+00, 6.2917037251E+00, 7.3995134592E-02, 7.1283642558E-02, 4.5866177250E-01],
	[7.9100000000E+03, 2.8181910250E+00, 6.2902742176E+00, 7.4137520630E-02, 7.1417043225E-02, 4.5883699998E-01],
	[7.9150000000E+03, 2.8204509901E+00, 6.2888459378E+00, 7.4280090069E-02, 7.1550602854E-02, 4.5901215964E-01],
	[7.9200000000E+03, 2.8227113386E+00, 6.2874188840E+00, 7.4422843028E-02, 7.1684321512E-02, 4.5918725164E-01],
	[7.9250000000E+03, 2.8249720703E+00, 6.2859930544E+00, 7.4565779628E-02, 7.1818199266E-02, 4.5936227613E-01],
	[7.9300000000E+03, 2.8272331851E+00, 6.2845684470E+00, 7.4708899986E-02, 7.1952236183E-02, 4.5953723326E-01],
	[7.9350000000E+03, 2.8294946827E+00, 6.2831450603E+00, 7.4852204223E-02, 7.2086432331E-02, 4.5971212319E-01],
	[7.9400000000E+03, 2.8317565631E+00, 6.2817228922E+00, 7.4995692459E-02, 7.2220787777E-02, 4.5988694606E-01],
	[7.9450000000E+03, 2.8340188259E+00, 6.2803019409E+00, 7.5139364812E-02, 7.2355302588E-02, 4.6006170204E-01],
	[7.9500000000E+03, 2.8362866680E+00, 6.2789073374E+00, 7.5283221403E-02, 7.2489983575E-02, 4.6023639126E-01],
	[7.9550000000E+03, 2.8385551356E+00, 6.2775150709E+00, 7.5427262350E-02, 7.2624824413E-02, 4.6041101388E-01],
	[7.9600000000E+03, 2.8408239904E+00, 6.2761239878E+00, 7.5571487773E-02, 7.2759824860E-02, 4.6058557006E-01],
	[7.9650000000E+03, 2.8430932323E+00, 6.2747340861E+00, 7.5715897791E-02, 7.2894984983E-02, 4.6076005994E-01],
	[7.9700000000E+03, 2.8453628611E+00, 6.2733453642E+00, 7.5860492525E-02, 7.3030304850E-02, 4.6093448368E-01],
	[7.9750000000E+03, 2.8476328766E+00, 6.2719578202E+00, 7.6005272093E-02, 7.3165784526E-02, 4.6110884142E-01],
	[7.9800000000E+03, 2.8499032787E+00, 6.2705714526E+00, 7.6150236614E-02, 7.3301424079E-02, 4.6128313331E-01],
	[7.9850000000E+03, 2.8521740671E+00, 6.2691862595E+00, 7.6295386210E-02, 7.3437223574E-02, 4.6145735951E-01],
	[7.9900000000E+03, 2.8544452417E+00, 6.2678022391E+00, 7.6440720998E-02, 7.3573183079E-02, 4.6163152017E-01],
	[7.9950000000E+03, 2.8567168024E+00, 6.2664193899E+00, 7.6586241098E-02, 7.3709302660E-02, 4.6180561543E-01],
	[8.0000000000E+03, 2.8589887488E+00, 6.2650377100E+00, 7.6731946630E-02, 7.3845582383E-02, 4.6197964545E-01],
	[8.0050000000E+03, 2.8612610810E+00, 6.2636571978E+00, 7.6878670214E-02, 7.3982793279E-02, 4.6215361037E-01],
	[8.0100000000E+03, 2.8635337986E+00, 6.2622778515E+00, 7.7025582147E-02, 7.4120166763E-02, 4.6232751034E-01],
	[8.0150000000E+03, 2.8658069015E+00, 6.2608996694E+00, 7.7172682552E-02, 7.4257702905E-02, 4.6250134551E-01],
	[8.0200000000E+03, 2.8680803896E+00, 6.2595226498E+00, 7.7319971552E-02, 7.4395401772E-02, 4.6267511603E-01],
	[8.0250000000E+03, 2.8703542626E+00, 6.2581467911E+00, 7.7467449271E-02, 7.4533263433E-02, 4.6284882206E-01],
	[8.0300000000E+03, 2.8726285204E+00, 6.2567720914E+00, 7.7615115833E-02, 7.4671287956E-02, 4.6302246373E-01],
	[8.0350000000E+03, 2.8749031628E+00, 6.2553985491E+00, 7.7762971360E-02, 7.4809475410E-02, 4.6319604119E-01],
	[8.0400000000E+03, 2.8771781897E+00, 6.2540261625E+00, 7.7911015975E-02, 7.4947825864E-02, 4.6336955459E-01],
	[8.0450000000E+03, 2.8794536008E+00, 6.2526549300E+00, 7.8059249803E-02, 7.5086339384E-02, 4.6354300409E-01],
	[8.0500000000E+03, 2.8817293960E+00, 6.2512848498E+00, 7.8207672967E-02, 7.5225016040E-02, 4.6371638982E-01],
	[8.0550000000E+03, 2.8840055751E+00, 6.2499159202E+00, 7.8356285589E-02, 7.5363855899E-02, 4.6388971194E-01],
	[8.0600000000E+03, 2.8862821380E+00, 6.2485481396E+00, 7.8505087794E-02, 7.5502859029E-02, 4.6406297059E-01],
	[8.0650000000E+03, 2.8885590844E+00, 6.2471815063E+00, 7.8654079704E-02, 7.5642025498E-02, 4.6423616592E-01],
	[8.0700000000E+03, 2.8908364143E+00, 6.2458160186E+00, 7.8803261443E-02, 7.5781355374E-02, 4.6440929807E-01],
	[8.0750000000E+03, 2.8931161119E+00, 6.2444610894E+00, 7.8952633135E-02, 7.5920851482E-02, 4.6458236719E-01],
	[8.0800000000E+03, 2.8953995071E+00, 6.2431229922E+00, 7.9102194902E-02, 7.6060515766E-02, 4.6475537343E-01],
	[8.0850000000E+03, 2.8976832903E+00, 6.2417860092E+00, 7.9251946869E-02, 7.6200343705E-02, 4.6492831693E-01],
	[8.0900000000E+03, 2.8999674613E+00, 6.2404501389E+00, 7.9401889157E-02, 7.6340335366E-02, 4.6510119784E-01],
	[8.0950000000E+03, 2.9022520199E+00, 6.2391153795E+00, 7.9552021892E-02, 7.6480490818E-02, 4.6527401631E-01],
	[8.1000000000E+03, 2.9045369659E+00, 6.2377817296E+00, 7.9702345195E-02, 7.6620810128E-02, 4.6544677248E-01],
	[8.1050000000E+03, 2.9068222991E+00, 6.2364491874E+00, 7.9852859192E-02, 7.6761293362E-02, 4.6561946649E-01],
	[8.1100000000E+03, 2.9091080194E+00, 6.2351177515E+00, 8.0003564004E-02, 7.6901940589E-02, 4.6579209849E-01],
	[8.1150000000E+03, 2.9113941267E+00, 6.2337874202E+00, 8.0154459756E-02, 7.7042751875E-02, 4.6596466862E-01],
	[8.1200000000E+03, 2.9136806206E+00, 6.2324581918E+00, 8.0305546570E-02, 7.7183727287E-02, 4.6613717704E-01],
	[8.1250000000E+03, 2.9159675011E+00, 6.2311300649E+00, 8.0456824570E-02, 7.7324866894E-02, 4.6630962387E-01],
	[8.1300000000E+03, 2.9182547680E+00, 6.2298030378E+00, 8.0608293880E-02, 7.7466170760E-02, 4.6648200928E-01],
	[8.1350000000E+03, 2.9205424211E+00, 6.2284771089E+00, 8.0759954623E-02, 7.7607638954E-02, 4.6665433340E-01],
	[8.1400000000E+03, 2.9228304603E+00, 6.2271522767E+00, 8.0911806922E-02, 7.7749271543E-02, 4.6682659637E-01],
	[8.1450000000E+03, 2.9251188853E+00, 6.2258285395E+00, 8.1063850901E-02, 7.7891068592E-02, 4.6699879834E-01],
	[8.1500000000E+03, 2.9274076960E+00, 6.2245058958E+00, 8.1216086683E-02, 7.8033030168E-02, 4.6717093946E-01],
	[8.1550000000E+03, 2.9296968923E+00, 6.2231843441E+00, 8.1368514391E-02, 7.8175156339E-02, 4.6734301986E-01],
	[8.1600000000E+03, 2.9319864739E+00, 6.2218638827E+00, 8.1521134149E-02, 7.8317447169E-02, 4.6751503969E-01],
	[8.1650000000E+03, 2.9342764407E+00, 6.2205445100E+00, 8.1673946081E-02, 7.8459902727E-02, 4.6768699910E-01],
	[8.1700000000E+03, 2.9365667924E+00, 6.2192262246E+00, 8.1826950309E-02, 7.8602523078E-02, 4.6785889821E-01],
	[8.1750000000E+03, 2.9388575291E+00, 6.2179090249E+00, 8.1980146958E-02, 7.8745308288E-02, 4.6803073719E-01],
	[8.1800000000E+03, 2.9411486504E+00, 6.2165929092E+00, 8.2133536150E-02, 7.8888258423E-02, 4.6820251616E-01],
	[8.1850000000E+03, 2.9434401562E+00, 6.2152778762E+00, 8.2287118009E-02, 7.9031373550E-02, 4.6837423528E-01],
	[8.1900000000E+03, 2.9457320463E+00, 6.2139639240E+00, 8.2440892659E-02, 7.9174653735E-02, 4.6854589468E-01],
	[8.1950000000E+03, 2.9480243206E+00, 6.2126510514E+00, 8.2594860223E-02, 7.9318099042E-02, 4.6871749450E-01],
	[8.2000000000E+03, 2.9503169788E+00, 6.2113392566E+00, 8.2749020823E-02, 7.9461709539E-02, 4.6888903489E-01],
	[8.2050000000E+03, 2.9526120038E+00, 6.2100377033E+00, 8.2903374585E-02, 7.9605488238E-02, 4.6906051599E-01],
	[8.2100000000E+03, 2.9549106309E+00, 6.2087520678E+00, 8.3057921631E-02, 7.9749437068E-02, 4.6923193794E-01],
	[8.2150000000E+03, 2.9572096464E+00, 6.2074674809E+00, 8.3212662084E-02, 7.9893551331E-02, 4.6940330088E-01],
	[8.2200000000E+03, 2.9595090501E+00, 6.2061839412E+00, 8.3367596068E-02, 8.0037831094E-02, 4.6957460496E-01],
	[8.2250000000E+03, 2.9618088418E+00, 6.2049014471E+00, 8.3522723707E-02, 8.0182276420E-02, 4.6974585030E-01],
	[8.2300000000E+03, 2.9641090214E+00, 6.2036199973E+00, 8.3678045124E-02, 8.0326887376E-02, 4.6991703706E-01],
	[8.2350000000E+03, 2.9664095888E+00, 6.2023395901E+00, 8.3833560443E-02, 8.0471664027E-02, 4.7008816537E-01],
	[8.2400000000E+03, 2.9687105436E+00, 6.2010602241E+00, 8.3989269786E-02, 8.0616606439E-02, 4.7025923538E-01],
	[8.2450000000E+03, 2.9710118859E+00, 6.1997818979E+00, 8.4145173277E-02, 8.0761714676E-02, 4.7043024722E-01],
	[8.2500000000E+03, 2.9733136153E+00, 6.1985046099E+00, 8.4301271041E-02, 8.0906988803E-02, 4.7060120101E-01],
	[8.2550000000E+03, 2.9756157318E+00, 6.1972283587E+00, 8.4457563199E-02, 8.1052428887E-02, 4.7077209686E-01],
	[8.2600000000E+03, 2.9779182352E+00, 6.1959531429E+00, 8.4614049876E-02, 8.1198034991E-02, 4.7094293484E-01],
	[8.2650000000E+03, 2.9802211252E+00, 6.1946789608E+00, 8.4770731196E-02, 8.1343807181E-02, 4.7111371508E-01],
	[8.2700000000E+03, 2.9825244017E+00, 6.1934058112E+00, 8.4927607281E-02, 8.1489745521E-02, 4.7128443767E-01],
	[8.2750000000E+03, 2.9848280647E+00, 6.1921336925E+00, 8.5084678255E-02, 8.1635850076E-02, 4.7145510272E-01],
	[8.2800000000E+03, 2.9871321137E+00, 6.1908626033E+00, 8.5241944242E-02, 8.1782120911E-02, 4.7162571035E-01],
	[8.2850000000E+03, 2.9894365489E+00, 6.1895925421E+00, 8.5399405365E-02, 8.1928558091E-02, 4.7179626065E-01],
	[8.2900000000E+03, 2.9917413698E+00, 6.1883235075E+00, 8.5557061747E-02, 8.2075161679E-02, 4.7196675374E-01],
	[8.2950000000E+03, 2.9940465765E+00, 6.1870554980E+00, 8.5714913512E-02, 8.2221931740E-02, 4.7213718971E-01],
	[8.3000000000E+03, 2.9963521686E+00, 6.1857885122E+00, 8.5872960784E-02, 8.2368868339E-02, 4.7230756869E-01],
	[8.3050000000E+03, 2.9986581461E+00, 6.1845225486E+00, 8.6031203686E-02, 8.2515971539E-02, 4.7247789076E-01],
	[8.3100000000E+03, 3.0009645088E+00, 6.1832576058E+00, 8.6189642342E-02, 8.2663241405E-02, 4.7264815604E-01],
	[8.3150000000E+03, 3.0032712565E+00, 6.1819936824E+00, 8.6348276874E-02, 8.2810678001E-02, 4.7281836463E-01],
	[8.3200000000E+03, 3.0055783890E+00, 6.1807307769E+00, 8.6507107407E-02, 8.2958281391E-02, 4.7298851665E-01],
	[8.3250000000E+03, 3.0078859062E+00, 6.1794688879E+00, 8.6666134064E-02, 8.3106051639E-02, 4.7315861218E-01],
	[8.3300000000E+03, 3.0101938080E+00, 6.1782080139E+00, 8.6825356969E-02, 8.3253988808E-02, 4.7332865135E-01],
	[8.3350000000E+03, 3.0125020940E+00, 6.1769481536E+00, 8.6984776244E-02, 8.3402092962E-02, 4.7349863425E-01],
	[8.3400000000E+03, 3.0148157121E+00, 6.1757115707E+00, 8.7144392014E-02, 8.3550372040E-02, 4.7366856100E-01],
	[8.3450000000E+03, 3.0171298732E+00, 6.1744766705E+00, 8.7304204403E-02, 8.3698818524E-02, 4.7383843168E-01],
	[8.3500000000E+03, 3.0194444228E+00, 6.1732427566E+00, 8.7464213532E-02, 8.3847432233E-02, 4.7400824642E-01],
	[8.3550000000E+03, 3.0217593610E+00, 6.1720098277E+00, 8.7624419527E-02, 8.3996213230E-02, 4.7417800531E-01],
	[8.3600000000E+03, 3.0240746874E+00, 6.1707778825E+00, 8.7784822510E-02, 8.4145161578E-02, 4.7434770847E-01],
	[8.3650000000E+03, 3.0263904019E+00, 6.1695469196E+00, 8.7945422605E-02, 8.4294277341E-02, 4.7451735598E-01],
	[8.3700000000E+03, 3.0287065043E+00, 6.1683169375E+00, 8.8106219936E-02, 8.4443560583E-02, 4.7468694797E-01],
	[8.3750000000E+03, 3.0310229945E+00, 6.1670879350E+00, 8.8267214627E-02, 8.4593011365E-02, 4.7485648453E-01],
	[8.3800000000E+03, 3.0333398723E+00, 6.1658599106E+00, 8.8428406799E-02, 8.4742629753E-02, 4.7502596576E-01],
	[8.3850000000E+03, 3.0356571375E+00, 6.1646328631E+00, 8.8589796578E-02, 8.4892415808E-02, 4.7519539178E-01],
	[8.3900000000E+03, 3.0379747900E+00, 6.1634067909E+00, 8.8751384087E-02, 8.5042369593E-02, 4.7536476268E-01],
	[8.3950000000E+03, 3.0402928297E+00, 6.1621816929E+00, 8.8913169449E-02, 8.5192491172E-02, 4.7553407857E-01],
	[8.4000000000E+03, 3.0426112562E+00, 6.1609575676E+00, 8.9075152788E-02, 8.5342780608E-02, 4.7570333955E-01],
	[8.4050000000E+03, 3.0449300695E+00, 6.1597344137E+00, 8.9237334228E-02, 8.5493237962E-02, 4.7587254573E-01],
	[8.4100000000E+03, 3.0472492695E+00, 6.1585122299E+00, 8.9399713891E-02, 8.5643863298E-02, 4.7604169721E-01],
	[8.4150000000E+03, 3.0495688558E+00, 6.1572910147E+00, 8.9562291901E-02, 8.5794656677E-02, 4.7621079410E-01],
	[8.4200000000E+03, 3.0518888285E+00, 6.1560707669E+00, 8.9725068383E-02, 8.5945618164E-02, 4.7637983649E-01],
	[8.4250000000E+03, 3.0542091872E+00, 6.1548514851E+00, 8.9888043459E-02, 8.6096747819E-02, 4.7654882449E-01],
	[8.4300000000E+03, 3.0565299319E+00, 6.1536331680E+00, 9.0051217254E-02, 8.6248045705E-02, 4.7671775820E-01],
	[8.4350000000E+03, 3.0588510624E+00, 6.1524158142E+00, 9.0214589890E-02, 8.6399511885E-02, 4.7688663773E-01],
	[8.4400000000E+03, 3.0611725785E+00, 6.1511994224E+00, 9.0378161491E-02, 8.6551146420E-02, 4.7705546317E-01],
	[8.4450000000E+03, 3.0634944801E+00, 6.1499839913E+00, 9.0541932181E-02, 8.6702949373E-02, 4.7722423464E-01],
	[8.4500000000E+03, 3.0658167669E+00, 6.1487695195E+00, 9.0705902084E-02, 8.6854920805E-02, 4.7739295223E-01],
	[8.4550000000E+03, 3.0681394389E+00, 6.1475560058E+00, 9.0870071322E-02, 8.7007060779E-02, 4.7756161605E-01],
	[8.4600000000E+03, 3.0704624958E+00, 6.1463434488E+00, 9.1034440020E-02, 8.7159369355E-02, 4.7773022620E-01],
	[8.4650000000E+03, 3.0727859375E+00, 6.1451318471E+00, 9.1199008301E-02, 8.7311846596E-02, 4.7789878277E-01],
	[8.4700000000E+03, 3.0751104283E+00, 6.1439241149E+00, 9.1363776289E-02, 8.7464493692E-02, 4.7806728588E-01],
	[8.4750000000E+03, 3.0774396440E+00, 6.1427363546E+00, 9.1528744107E-02, 8.7617316970E-02, 4.7823573563E-01],
	[8.4800000000E+03, 3.0797692486E+00, 6.1415495243E+00, 9.1693911879E-02, 8.7770309148E-02, 4.7840413211E-01],
	[8.4850000000E+03, 3.0820992419E+00, 6.1403636227E+00, 9.1859279728E-02, 8.7923470286E-02, 4.7857247544E-01],
	[8.4900000000E+03, 3.0844296239E+00, 6.1391786485E+00, 9.2024900482E-02, 8.8076848726E-02, 4.7874076570E-01],
	[8.4950000000E+03, 3.0867603942E+00, 6.1379946005E+00, 9.2190724865E-02, 8.8230399264E-02, 4.7890900300E-01],
	[8.5000000000E+03, 3.0890915528E+00, 6.1368114773E+00, 9.2356749879E-02, 8.8384119103E-02, 4.7907718745E-01],
	[8.5050000000E+03, 3.0914230995E+00, 6.1356292777E+00, 9.2522975649E-02, 8.8538008304E-02, 4.7924531915E-01],
	[8.5100000000E+03, 3.0937550342E+00, 6.1344480004E+00, 9.2689402298E-02, 8.8692066928E-02, 4.7941339819E-01],
	[8.5150000000E+03, 3.0960873566E+00, 6.1332676443E+00, 9.2856029950E-02, 8.8846295037E-02, 4.7958142468E-01],
	[8.5200000000E+03, 3.0984200667E+00, 6.1320882079E+00, 9.3022858728E-02, 8.9000692691E-02, 4.7974939872E-01],
	[8.5250000000E+03, 3.1007531642E+00, 6.1309096901E+00, 9.3189888758E-02, 8.9155259952E-02, 4.7991732040E-01],
	[8.5300000000E+03, 3.1030866489E+00, 6.1297320896E+00, 9.3357120162E-02, 8.9309996881E-02, 4.8008518984E-01],
	[8.5350000000E+03, 3.1054205208E+00, 6.1285554052E+00, 9.3524553065E-02, 8.9464903537E-02, 4.8025300713E-01],
	[8.5400000000E+03, 3.1077547797E+00, 6.1273796355E+00, 9.3692187590E-02, 8.9619979983E-02, 4.8042077237E-01],
	[8.5450000000E+03, 3.1100894253E+00, 6.1262047795E+00, 9.3860023862E-02, 8.9775226279E-02, 4.8058848567E-01],
	[8.5500000000E+03, 3.1124244576E+00, 6.1250308357E+00, 9.4028062004E-02, 8.9930642486E-02, 4.8075614712E-01],
	[8.5550000000E+03, 3.1147598763E+00, 6.1238578031E+00, 9.4196302140E-02, 9.0086228663E-02, 4.8092375682E-01],
	[8.5600000000E+03, 3.1170956814E+00, 6.1226856803E+00, 9.4364744394E-02, 9.0241984871E-02, 4.8109131487E-01],
	[8.5650000000E+03, 3.1194318726E+00, 6.1215144660E+00, 9.4533388891E-02, 9.0397911171E-02, 4.8125882138E-01],
	[8.5700000000E+03, 3.1217684498E+00, 6.1203441592E+00, 9.4702235753E-02, 9.0554007623E-02, 4.8142627645E-01],
	[8.5750000000E+03, 3.1241054128E+00, 6.1191747585E+00, 9.4871285105E-02, 9.0710274287E-02, 4.8159368016E-01],
	[8.5800000000E+03, 3.1264427614E+00, 6.1180062626E+00, 9.5040537071E-02, 9.0866711223E-02, 4.8176103264E-01],
	[8.5850000000E+03, 3.1287804956E+00, 6.1168386705E+00, 9.5209991775E-02, 9.1023318491E-02, 4.8192833396E-01],
	[8.5900000000E+03, 3.1311186151E+00, 6.1156719808E+00, 9.5379649340E-02, 9.1180096151E-02, 4.8209558424E-01],
	[8.5950000000E+03, 3.1334571198E+00, 6.1145061924E+00, 9.5549509891E-02, 9.1337044263E-02, 4.8226278357E-01],
	[8.6000000000E+03, 3.1357960095E+00, 6.1133413040E+00, 9.5719573551E-02, 9.1494162886E-02, 4.8242993205E-01],
	[8.6050000000E+03, 3.1381352841E+00, 6.1121773143E+00, 9.5889840444E-02, 9.1651452080E-02, 4.8259702979E-01],
	[8.6100000000E+03, 3.1404791809E+00, 6.1110323221E+00, 9.6060310695E-02, 9.1808919611E-02, 4.8276407688E-01],
	[8.6150000000E+03, 3.1428241340E+00, 6.1098910595E+00, 9.6230984428E-02, 9.1966559095E-02, 4.8293107341E-01],
	[8.6200000000E+03, 3.1451694760E+00, 6.1087506720E+00, 9.6401861765E-02, 9.2124369381E-02, 4.8309801950E-01],
	[8.6250000000E+03, 3.1475152067E+00, 6.1076111585E+00, 9.6572942832E-02, 9.2282350527E-02, 4.8326491523E-01],
	[8.6300000000E+03, 3.1498613259E+00, 6.1064725178E+00, 9.6744227751E-02, 9.2440502593E-02, 4.8343176071E-01],
	[8.6350000000E+03, 3.1522078334E+00, 6.1053347486E+00, 9.6915716648E-02, 9.2598825638E-02, 4.8359855604E-01],
	[8.6400000000E+03, 3.1545547292E+00, 6.1041978499E+00, 9.7087409646E-02, 9.2757319722E-02, 4.8376530131E-01],
	[8.6450000000E+03, 3.1569020130E+00, 6.1030618204E+00, 9.7259306868E-02, 9.2915984904E-02, 4.8393199662E-01],
	[8.6500000000E+03, 3.1592496847E+00, 6.1019266591E+00, 9.7431408440E-02, 9.3074821242E-02, 4.8409864208E-01],
	[8.6550000000E+03, 3.1615977441E+00, 6.1007923646E+00, 9.7603714485E-02, 9.3233828796E-02, 4.8426523777E-01],
	[8.6600000000E+03, 3.1639461910E+00, 6.0996589359E+00, 9.7776225126E-02, 9.3393007625E-02, 4.8443178381E-01],
	[8.6650000000E+03, 3.1662950254E+00, 6.0985263719E+00, 9.7948940488E-02, 9.3552357786E-02, 4.8459828028E-01],
	[8.6700000000E+03, 3.1686442470E+00, 6.0973946713E+00, 9.8121860695E-02, 9.3711879340E-02, 4.8476472728E-01],
	[8.6750000000E+03, 3.1709938557E+00, 6.0962638329E+00, 9.8294985871E-02, 9.3871572344E-02, 4.8493112492E-01],
	[8.6800000000E+03, 3.1733438513E+00, 6.0951338557E+00, 9.8468316139E-02, 9.4031436857E-02, 4.8509747328E-01],
	[8.6850000000E+03, 3.1756942337E+00, 6.0940047385E+00, 9.8641851624E-02, 9.4191472937E-02, 4.8526377248E-01],
	[8.6900000000E+03, 3.1780450026E+00, 6.0928764802E+00, 9.8815592450E-02, 9.4351680643E-02, 4.8543002260E-01],
	[8.6950000000E+03, 3.1803961580E+00, 6.0917490795E+00, 9.8989538740E-02, 9.4512060033E-02, 4.8559622375E-01],
	[8.7000000000E+03, 3.1827476997E+00, 6.0906225354E+00, 9.9163690619E-02, 9.4672611166E-02, 4.8576237601E-01],
	[8.7050000000E+03, 3.1850996276E+00, 6.0894968467E+00, 9.9338048211E-02, 9.4833334098E-02, 4.8592847950E-01],
	[8.7100000000E+03, 3.1874519414E+00, 6.0883720122E+00, 9.9512611639E-02, 9.4994228888E-02, 4.8609453430E-01],
	[8.7150000000E+03, 3.1898046410E+00, 6.0872480309E+00, 9.9687381028E-02, 9.5155295595E-02, 4.8626054051E-01],
	[8.7200000000E+03, 3.1921577262E+00, 6.0861249016E+00, 9.9862356502E-02, 9.5316534275E-02, 4.8642649824E-01],
	[8.7250000000E+03, 3.1945111970E+00, 6.0850026231E+00, 1.0003753818E-01, 9.5477944987E-02, 4.8659240757E-01],
	[8.7300000000E+03, 3.1968650531E+00, 6.0838811943E+00, 1.0021292620E-01, 9.5639527787E-02, 4.8675826861E-01],
	[8.7350000000E+03, 3.1992192943E+00, 6.0827606142E+00, 1.0038852067E-01, 9.5801282735E-02, 4.8692408144E-01],
	[8.7400000000E+03, 3.2015739206E+00, 6.0816408815E+00, 1.0056432172E-01, 9.5963209886E-02, 4.8708984618E-01],
	[8.7450000000E+03, 3.2039296809E+00, 6.0805251146E+00, 1.0074032948E-01, 9.6125310753E-02, 4.8725556291E-01],
	[8.7500000000E+03, 3.2062898834E+00, 6.0794270675E+00, 1.0091654406E-01, 9.6287591839E-02, 4.8742123174E-01],
	[8.7550000000E+03, 3.2086504747E+00, 6.0783298459E+00, 1.0109296560E-01, 9.6450045355E-02, 4.8758685275E-01],
	[8.7600000000E+03, 3.2110114548E+00, 6.0772334485E+00, 1.0126959421E-01, 9.6612671356E-02, 4.8775242605E-01],
	[8.7650000000E+03, 3.2133728234E+00, 6.0761378744E+00, 1.0144643003E-01, 9.6775469901E-02, 4.8791795172E-01],
	[8.7700000000E+03, 3.2157345804E+00, 6.0750431224E+00, 1.0162347317E-01, 9.6938441047E-02, 4.8808342988E-01],
	[8.7750000000E+03, 3.2180967257E+00, 6.0739491915E+00, 1.0180072376E-01, 9.7101584851E-02, 4.8824886061E-01],
	[8.7800000000E+03, 3.2204592590E+00, 6.0728560805E+00, 1.0197818192E-01, 9.7264901369E-02, 4.8841424401E-01],
	[8.7850000000E+03, 3.2228221803E+00, 6.0717637884E+00, 1.0215584778E-01, 9.7428390658E-02, 4.8857958017E-01],
	[8.7900000000E+03, 3.2251854893E+00, 6.0706723140E+00, 1.0233372146E-01, 9.7592052775E-02, 4.8874486920E-01],
	[8.7950000000E+03, 3.2275491859E+00, 6.0695816565E+00, 1.0251180308E-01, 9.7755887778E-02, 4.8891011119E-01],
	[8.8000000000E+03, 3.2299132700E+00, 6.0684918145E+00, 1.0269009277E-01, 9.7919895721E-02, 4.8907530622E-01],
	[8.8050000000E+03, 3.2322777414E+00, 6.0674027872E+00, 1.0286859066E-01, 9.8084076662E-02, 4.8924045441E-01],
	[8.8100000000E+03, 3.2346426000E+00, 6.0663145733E+00, 1.0304729686E-01, 9.8248430658E-02, 4.8940555584E-01],
	[8.8150000000E+03, 3.2370078455E+00, 6.0652271719E+00, 1.0322621150E-01, 9.8412957763E-02, 4.8957061062E-01],
	[8.8200000000E+03, 3.2393734778E+00, 6.0641405818E+00, 1.0340533471E-01, 9.8577658036E-02, 4.8973561883E-01],
	[8.8250000000E+03, 3.2417394969E+00, 6.0630548021E+00, 1.0358466661E-01, 9.8742531531E-02, 4.8990058057E-01],
	[8.8300000000E+03, 3.2441059024E+00, 6.0619698316E+00, 1.0376420732E-01, 9.8907578305E-02, 4.9006549593E-01],
	[8.8350000000E+03, 3.2464726943E+00, 6.0608856692E+00, 1.0394395697E-01, 9.9072798414E-02, 4.9023036502E-01],
	[8.8400000000E+03, 3.2488398724E+00, 6.0598023140E+00, 1.0412391568E-01, 9.9238191913E-02, 4.9039518793E-01],
	[8.8450000000E+03, 3.2512074366E+00, 6.0587197649E+00, 1.0430408357E-01, 9.9403758858E-02, 4.9055996475E-01],
	[8.8500000000E+03, 3.2535753866E+00, 6.0576380208E+00, 1.0448446077E-01, 9.9569499306E-02, 4.9072469557E-01],
	[8.8550000000E+03, 3.2559437224E+00, 6.0565570806E+00, 1.0466504741E-01, 9.9735413311E-02, 4.9088938050E-01],
	[8.8600000000E+03, 3.2583124438E+00, 6.0554769433E+00, 1.0484584361E-01, 9.9901500928E-02, 4.9105401962E-01],
	[8.8650000000E+03, 3.2606815506E+00, 6.0543976079E+00, 1.0502684948E-01, 1.0006776221E-01, 4.9121861304E-01],
	[8.8700000000E+03, 3.2630510427E+00, 6.0533190733E+00, 1.0520806516E-01, 1.0023419722E-01, 4.9138316084E-01],
	[8.8750000000E+03, 3.2654209199E+00, 6.0522413385E+00, 1.0538949078E-01, 1.0040080601E-01, 4.9154766312E-01],
	[8.8800000000E+03, 3.2677911820E+00, 6.0511644023E+00, 1.0557112644E-01, 1.0056758864E-01, 4.9171211997E-01],
	[8.8850000000E+03, 3.2701618381E+00, 6.0500883006E+00, 1.0575297228E-01, 1.0073454517E-01, 4.9187653150E-01],
	[8.8900000000E+03, 3.2725375754E+00, 6.0490320349E+00, 1.0593502843E-01, 1.0090168541E-01, 4.9204089779E-01],
	[8.8950000000E+03, 3.2749137014E+00, 6.0479765473E+00, 1.0611729500E-01, 1.0106899970E-01, 4.9220521894E-01],
	[8.9000000000E+03, 3.2772902159E+00, 6.0469218368E+00, 1.0629977212E-01, 1.0123648810E-01, 4.9236949504E-01],
	[8.9050000000E+03, 3.2796671188E+00, 6.0458679025E+00, 1.0648245992E-01, 1.0140415066E-01, 4.9253372618E-01],
	[8.9100000000E+03, 3.2820444099E+00, 6.0448147434E+00, 1.0666535851E-01, 1.0157198744E-01, 4.9269791246E-01],
	[8.9150000000E+03, 3.2844220891E+00, 6.0437623583E+00, 1.0684846803E-01, 1.0173999850E-01, 4.9286205391E-01],
	[8.9200000000E+03, 3.2868001562E+00, 6.0427107464E+00, 1.0703178859E-01, 1.0190818388E-01, 4.9302615058E-01],
	[8.9250000000E+03, 3.2891786110E+00, 6.0416599067E+00, 1.0721532033E-01, 1.0207654364E-01, 4.9319020254E-01],
	[8.9300000000E+03, 3.2915574535E+00, 6.0406098380E+00, 1.0739906336E-01, 1.0224507784E-01, 4.9335420985E-01],
	[8.9350000000E+03, 3.2939366834E+00, 6.0395605395E+00, 1.0758301780E-01, 1.0241378653E-01, 4.9351817259E-01],
	[8.9400000000E+03, 3.2963163005E+00, 6.0385120102E+00, 1.0776718379E-01, 1.0258266977E-01, 4.9368209081E-01],
	[8.9450000000E+03, 3.2986963049E+00, 6.0374642490E+00, 1.0795156145E-01, 1.0275172760E-01, 4.9384596459E-01],
	[8.9500000000E+03, 3.3010766962E+00, 6.0364172549E+00, 1.0813615090E-01, 1.0292096009E-01, 4.9400979399E-01],
	[8.9550000000E+03, 3.3034574743E+00, 6.0353710270E+00, 1.0832095226E-01, 1.0309036729E-01, 4.9417357908E-01],
	[8.9600000000E+03, 3.3058386391E+00, 6.0343255643E+00, 1.0850596567E-01, 1.0325994924E-01, 4.9433731993E-01],
	[8.9650000000E+03, 3.3082201905E+00, 6.0332808657E+00, 1.0869119123E-01, 1.0342970601E-01, 4.9450101659E-01],
	[8.9700000000E+03, 3.3106021282E+00, 6.0322369304E+00, 1.0887662909E-01, 1.0359963765E-01, 4.9466466915E-01],
	[8.9750000000E+03, 3.3129844521E+00, 6.0311937573E+00, 1.0906227936E-01, 1.0376974421E-01, 4.9482827765E-01],
	[8.9800000000E+03, 3.3153671622E+00, 6.0301513454E+00, 1.0924814216E-01, 1.0394002575E-01, 4.9499184218E-01],
	[8.9850000000E+03, 3.3177502581E+00, 6.0291096938E+00, 1.0943421762E-01, 1.0411048232E-01, 4.9515536279E-01],
	[8.9900000000E+03, 3.3201337398E+00, 6.0280688015E+00, 1.0962050587E-01, 1.0428111397E-01, 4.9531883955E-01],
	[8.9950000000E+03, 3.3225176071E+00, 6.0270286675E+00, 1.0980700702E-01, 1.0445192075E-01, 4.9548227253E-01],
	[9.0000000000E+03, 3.3249018598E+00, 6.0259892908E+00, 1.0999372121E-01, 1.0462290272E-01, 4.9564566179E-01],
	[9.0050000000E+03, 3.3272864979E+00, 6.0249506705E+00, 1.1018184988E-01, 1.0479514667E-01, 4.9580900740E-01],
	[9.0100000000E+03, 3.3296715211E+00, 6.0239128055E+00, 1.1037019527E-01, 1.0496756874E-01, 4.9597230943E-01],
	[9.0150000000E+03, 3.3320569294E+00, 6.0228756951E+00, 1.1055875749E-01, 1.0514016899E-01, 4.9613556793E-01],
	[9.0200000000E+03, 3.3344427224E+00, 6.0218393380E+00, 1.1074753668E-01, 1.0531294747E-01, 4.9629878299E-01],
	[9.0250000000E+03, 3.3368289002E+00, 6.0208037335E+00, 1.1093653297E-01, 1.0548590423E-01, 4.9646195466E-01],
	[9.0300000000E+03, 3.3392172871E+00, 6.0197760644E+00, 1.1112574648E-01, 1.0565904337E-01, 4.9662508300E-01],
	[9.0350000000E+03, 3.3416088595E+00, 6.0187601526E+00, 1.1131517735E-01, 1.0583236715E-01, 4.9678816809E-01],
	[9.0400000000E+03, 3.3440008203E+00, 6.0177449742E+00, 1.1150482569E-01, 1.0600586943E-01, 4.9695120999E-01],
	[9.0450000000E+03, 3.3463931692E+00, 6.0167305282E+00, 1.1169469165E-01, 1.0617955028E-01, 4.9711420877E-01],
	[9.0500000000E+03, 3.3487859061E+00, 6.0157168137E+00, 1.1188477535E-01, 1.0635340974E-01, 4.9727716448E-01],
	[9.0550000000E+03, 3.3511790308E+00, 6.0147038298E+00, 1.1207507691E-01, 1.0652744787E-01, 4.9744007721E-01],
	[9.0600000000E+03, 3.3535725432E+00, 6.0136915755E+00, 1.1226559648E-01, 1.0670166474E-01, 4.9760294700E-01],
	[9.0650000000E+03, 3.3559664432E+00, 6.0126800499E+00, 1.1245633416E-01, 1.0687606038E-01, 4.9776577393E-01],
	[9.0700000000E+03, 3.3583607306E+00, 6.0116692520E+00, 1.1264729010E-01, 1.0705063486E-01, 4.9792855807E-01],
	[9.0750000000E+03, 3.3607554052E+00, 6.0106591811E+00, 1.1283846442E-01, 1.0722538823E-01, 4.9809129947E-01],
	[9.0800000000E+03, 3.3631504669E+00, 6.0096498360E+00, 1.1302985725E-01, 1.0740032055E-01, 4.9825399820E-01],
	[9.0850000000E+03, 3.3655459156E+00, 6.0086412160E+00, 1.1322146872E-01, 1.0757543186E-01, 4.9841665434E-01],
	[9.0900000000E+03, 3.3679417510E+00, 6.0076333200E+00, 1.1341329896E-01, 1.0775072223E-01, 4.9857926794E-01],
	[9.0950000000E+03, 3.3703379731E+00, 6.0066261473E+00, 1.1360534810E-01, 1.0792619171E-01, 4.9874183906E-01],
	[9.1000000000E+03, 3.3727345817E+00, 6.0056196968E+00, 1.1379761626E-01, 1.0810184035E-01, 4.9890436779E-01],
	[9.1050000000E+03, 3.3751315766E+00, 6.0046139676E+00, 1.1399010357E-01, 1.0827766820E-01, 4.9906685417E-01],
	[9.1100000000E+03, 3.3775289577E+00, 6.0036089588E+00, 1.1418281016E-01, 1.0845367532E-01, 4.9922929827E-01],
	[9.1150000000E+03, 3.3799267248E+00, 6.0026046696E+00, 1.1437573617E-01, 1.0862986177E-01, 4.9939170017E-01],
	[9.1200000000E+03, 3.3823248779E+00, 6.0016010990E+00, 1.1456888171E-01, 1.0880622759E-01, 4.9955405992E-01],
	[9.1250000000E+03, 3.3847234166E+00, 6.0005982461E+00, 1.1476224693E-01, 1.0898277283E-01, 4.9971637759E-01],
	[9.1300000000E+03, 3.3871223410E+00, 5.9995961100E+00, 1.1495583193E-01, 1.0915949757E-01, 4.9987865324E-01],
	[9.1350000000E+03, 3.3895216508E+00, 5.9985946897E+00, 1.1514963687E-01, 1.0933640184E-01, 5.0004088695E-01],
	[9.1400000000E+03, 3.3919213459E+00, 5.9975939845E+00, 1.1534366186E-01, 1.0951348569E-01, 5.0020307876E-01],
	[9.1450000000E+03, 3.3943214262E+00, 5.9965939933E+00, 1.1553790703E-01, 1.0969074920E-01, 5.0036522876E-01],
	[9.1500000000E+03, 3.3967218914E+00, 5.9955947153E+00, 1.1573237251E-01, 1.0986819239E-01, 5.0052733700E-01],
	[9.1550000000E+03, 3.3991227415E+00, 5.9945961497E+00, 1.1592705843E-01, 1.1004581534E-01, 5.0068940355E-01],
	[9.1600000000E+03, 3.4015239763E+00, 5.9935982954E+00, 1.1612196492E-01, 1.1022361808E-01, 5.0085142847E-01],
	[9.1650000000E+03, 3.4039255957E+00, 5.9926011516E+00, 1.1631709211E-01, 1.1040160068E-01, 5.0101341183E-01],
	[9.1700000000E+03, 3.4063275994E+00, 5.9916047174E+00, 1.1651244012E-01, 1.1057976319E-01, 5.0117535369E-01],
	[9.1750000000E+03, 3.4087314862E+00, 5.9906146721E+00, 1.1670800908E-01, 1.1075810918E-01, 5.0133725412E-01],
	[9.1800000000E+03, 3.4111388459E+00, 5.9896370210E+00, 1.1690379913E-01, 1.1093664248E-01, 5.0149911318E-01],
	[9.1850000000E+03, 3.4135465936E+00, 5.9886600616E+00, 1.1709981039E-01, 1.1111535590E-01, 5.0166093093E-01],
	[9.1900000000E+03, 3.4159547291E+00, 5.9876837931E+00, 1.1729604300E-01, 1.1129424949E-01, 5.0182270745E-01],
	[9.1950000000E+03, 3.4183632521E+00, 5.9867082147E+00, 1.1749249707E-01, 1.1147332331E-01, 5.0198444279E-01],
	[9.2000000000E+03, 3.4207721627E+00, 5.9857333254E+00, 1.1768917273E-01, 1.1165257742E-01, 5.0214613702E-01],
	[9.2050000000E+03, 3.4231814606E+00, 5.9847591245E+00, 1.1788607013E-01, 1.1183201185E-01, 5.0230779020E-01],
	[9.2100000000E+03, 3.4255911457E+00, 5.9837856110E+00, 1.1808318938E-01, 1.1201162667E-01, 5.0246940241E-01],
	[9.2150000000E+03, 3.4280012178E+00, 5.9828127841E+00, 1.1828053061E-01, 1.1219142192E-01, 5.0263097369E-01],
	[9.2200000000E+03, 3.4304116768E+00, 5.9818406429E+00, 1.1847809396E-01, 1.1237139767E-01, 5.0279250412E-01],
	[9.2250000000E+03, 3.4328225226E+00, 5.9808691866E+00, 1.1867587954E-01, 1.1255155395E-01, 5.0295399376E-01],
	[9.2300000000E+03, 3.4352337549E+00, 5.9798984144E+00, 1.1887388750E-01, 1.1273189082E-01, 5.0311544268E-01],
	[9.2350000000E+03, 3.4376453737E+00, 5.9789283253E+00, 1.1907211795E-01, 1.1291240834E-01, 5.0327685093E-01],
	[9.2400000000E+03, 3.4400573788E+00, 5.9779589185E+00, 1.1927057103E-01, 1.1309310655E-01, 5.0343821859E-01],
	[9.2450000000E+03, 3.4424697700E+00, 5.9769901933E+00, 1.1946924687E-01, 1.1327398550E-01, 5.0359954572E-01],
	[9.2500000000E+03, 3.4448825473E+00, 5.9760221486E+00, 1.1966814559E-01, 1.1345504526E-01, 5.0376083237E-01],
	[9.2550000000E+03, 3.4472957104E+00, 5.9750547838E+00, 1.1986726733E-01, 1.1363628586E-01, 5.0392207862E-01],
	[9.2600000000E+03, 3.4497092592E+00, 5.9740880979E+00, 1.2006661221E-01, 1.1381770736E-01, 5.0408328453E-01],
	[9.2650000000E+03, 3.4521231936E+00, 5.9731220900E+00, 1.2026618036E-01, 1.1399930981E-01, 5.0424445017E-01],
	[9.2700000000E+03, 3.4545375134E+00, 5.9721567595E+00, 1.2046597190E-01, 1.1418109326E-01, 5.0440557559E-01],
	[9.2750000000E+03, 3.4569522185E+00, 5.9711921053E+00, 1.2066598698E-01, 1.1436305776E-01, 5.0456666086E-01],
	[9.2800000000E+03, 3.4593673087E+00, 5.9702281268E+00, 1.2086622571E-01, 1.1454520337E-01, 5.0472770604E-01],
	[9.2850000000E+03, 3.4617827838E+00, 5.9692648230E+00, 1.2106668823E-01, 1.1472753013E-01, 5.0488871120E-01],
	[9.2900000000E+03, 3.4641986439E+00, 5.9683021930E+00, 1.2126737467E-01, 1.1491003809E-01, 5.0504967641E-01],
	[9.2950000000E+03, 3.4666148886E+00, 5.9673402362E+00, 1.2146828514E-01, 1.1509272731E-01, 5.0521060172E-01],
	[9.3000000000E+03, 3.4690315178E+00, 5.9663789516E+00, 1.2166941979E-01, 1.1527559783E-01, 5.0537148720E-01],
	[9.3050000000E+03, 3.4714485314E+00, 5.9654183384E+00, 1.2187077874E-01, 1.1545864971E-01, 5.0553233291E-01],
	[9.3100000000E+03, 3.4738659293E+00, 5.9644583958E+00, 1.2207236212E-01, 1.1564188299E-01, 5.0569313892E-01],
	[9.3150000000E+03, 3.4762837113E+00, 5.9634991229E+00, 1.2227417006E-01, 1.1582529773E-01, 5.0585390529E-01],
	[9.3200000000E+03, 3.4787018773E+00, 5.9625405190E+00, 1.2247620268E-01, 1.1600889397E-01, 5.0601463208E-01],
	[9.3250000000E+03, 3.4811240300E+00, 5.9615956991E+00, 1.2267846012E-01, 1.1619268076E-01, 5.0617531936E-01],
	[9.3300000000E+03, 3.4835475209E+00, 5.9606549961E+00, 1.2288094251E-01, 1.1637665159E-01, 5.0633596719E-01],
	[9.3350000000E+03, 3.4859713993E+00, 5.9597149455E+00, 1.2308364997E-01, 1.1656080413E-01, 5.0649657564E-01],
	[9.3400000000E+03, 3.4883956650E+00, 5.9587755463E+00, 1.2328658263E-01, 1.1674513844E-01, 5.0665714476E-01],
	[9.3450000000E+03, 3.4908203177E+00, 5.9578367979E+00, 1.2348974062E-01, 1.1692965456E-01, 5.0681767462E-01],
	[9.3500000000E+03, 3.4932453575E+00, 5.9568986994E+00, 1.2369312407E-01, 1.1711435255E-01, 5.0697816529E-01],
	[9.3550000000E+03, 3.4956707841E+00, 5.9559612500E+00, 1.2389673311E-01, 1.1729923245E-01, 5.0713861683E-01],
	[9.3600000000E+03, 3.4980965973E+00, 5.9550244489E+00, 1.2410056787E-01, 1.1748429431E-01, 5.0729902929E-01],
	[9.3650000000E+03, 3.5005227972E+00, 5.9540882953E+00, 1.2430462847E-01, 1.1766953818E-01, 5.0745940275E-01],
	[9.3700000000E+03, 3.5029493834E+00, 5.9531527885E+00, 1.2450891505E-01, 1.1785496412E-01, 5.0761973727E-01],
	[9.3750000000E+03, 3.5053763559E+00, 5.9522179276E+00, 1.2471342773E-01, 1.1804057216E-01, 5.0778003290E-01],
	[9.3800000000E+03, 3.5078037145E+00, 5.9512837119E+00, 1.2491816665E-01, 1.1822636237E-01, 5.0794028972E-01],
	[9.3850000000E+03, 3.5102314590E+00, 5.9503501405E+00, 1.2512313192E-01, 1.1841233478E-01, 5.0810050779E-01],
	[9.3900000000E+03, 3.5126595894E+00, 5.9494172127E+00, 1.2532832369E-01, 1.1859848945E-01, 5.0826068716E-01],
	[9.3950000000E+03, 3.5150881055E+00, 5.9484849277E+00, 1.2553374208E-01, 1.1878482643E-01, 5.0842082791E-01],
	[9.4000000000E+03, 3.5175170071E+00, 5.9475532847E+00, 1.2573938721E-01, 1.1897134576E-01, 5.0858093009E-01],
	[9.4050000000E+03, 3.5199462940E+00, 5.9466222829E+00, 1.2594525922E-01, 1.1915804750E-01, 5.0874099377E-01],
	[9.4100000000E+03, 3.5223759663E+00, 5.9456919215E+00, 1.2615135824E-01, 1.1934493168E-01, 5.0890101902E-01],
	[9.4150000000E+03, 3.5248060236E+00, 5.9447621998E+00, 1.2635768439E-01, 1.1953199836E-01, 5.0906100588E-01],
	[9.4200000000E+03, 3.5272364659E+00, 5.9438331170E+00, 1.2656423780E-01, 1.1971924760E-01, 5.0922095444E-01],
	[9.4250000000E+03, 3.5296672930E+00, 5.9429046723E+00, 1.2677101861E-01, 1.1990667943E-01, 5.0938086474E-01],
	[9.4300000000E+03, 3.5320985048E+00, 5.9419768649E+00, 1.2697802694E-01, 1.2009429390E-01, 5.0954073686E-01],
	[9.4350000000E+03, 3.5345301011E+00, 5.9410496940E+00, 1.2718526291E-01, 1.2028209106E-01, 5.0970057085E-01],
	[9.4400000000E+03, 3.5369620818E+00, 5.9401231589E+00, 1.2739272667E-01, 1.2047007096E-01, 5.0986036678E-01],
	[9.4450000000E+03, 3.5393944467E+00, 5.9391972589E+00, 1.2760041833E-01, 1.2065823365E-01, 5.1002012471E-01],
	[9.4500000000E+03, 3.5418271957E+00, 5.9382719930E+00, 1.2780833803E-01, 1.2084657918E-01, 5.1017984471E-01],
	[9.4550000000E+03, 3.5442603287E+00, 5.9373473606E+00, 1.2801648590E-01, 1.2103510759E-01, 5.1033952683E-01],
	[9.4600000000E+03, 3.5466938455E+00, 5.9364233609E+00, 1.2822486206E-01, 1.2122381892E-01, 5.1049917114E-01],
	[9.4650000000E+03, 3.5491277460E+00, 5.9354999932E+00, 1.2843346664E-01, 1.2141271324E-01, 5.1065877770E-01],
	[9.4700000000E+03, 3.5515620300E+00, 5.9345772566E+00, 1.2864229978E-01, 1.2160179058E-01, 5.1081834658E-01],
	[9.4750000000E+03, 3.5540002242E+00, 5.9336674811E+00, 1.2885136159E-01, 1.2179106032E-01, 5.1097787783E-01],
	[9.4800000000E+03, 3.5564398001E+00, 5.9327618029E+00, 1.2906065222E-01, 1.2198051588E-01, 5.1113737152E-01],
	[9.4850000000E+03, 3.5588797630E+00, 5.9318567405E+00, 1.2927017179E-01, 1.2217015466E-01, 5.1129682771E-01],
	[9.4900000000E+03, 3.5613201126E+00, 5.9309522929E+00, 1.2947992042E-01, 1.2235997672E-01, 5.1145624647E-01],
	[9.4950000000E+03, 3.5637608489E+00, 5.9300484596E+00, 1.2968989825E-01, 1.2254998210E-01, 5.1161562785E-01],
	[9.5000000000E+03, 3.5662019716E+00, 5.9291452397E+00, 1.2990010540E-01, 1.2274017085E-01, 5.1177497193E-01],
	[9.5050000000E+03, 3.5686434807E+00, 5.9282426326E+00, 1.3011054201E-01, 1.2293054302E-01, 5.1193427875E-01],
	[9.5100000000E+03, 3.5710853760E+00, 5.9273406374E+00, 1.3032120820E-01, 1.2312109865E-01, 5.1209354838E-01],
	[9.5150000000E+03, 3.5735276574E+00, 5.9264392534E+00, 1.3053210411E-01, 1.2331183779E-01, 5.1225278090E-01],
	[9.5200000000E+03, 3.5759703247E+00, 5.9255384800E+00, 1.3074322985E-01, 1.2350276048E-01, 5.1241197635E-01],
	[9.5250000000E+03, 3.5784133778E+00, 5.9246383163E+00, 1.3095458557E-01, 1.2369386678E-01, 5.1257113479E-01],
	[9.5300000000E+03, 3.5808568165E+00, 5.9237387617E+00, 1.3116617138E-01, 1.2388515672E-01, 5.1273025624E-01],
	[9.5350000000E+03, 3.5833006407E+00, 5.9228398154E+00, 1.3137798743E-01, 1.2407663036E-01, 5.1288934073E-01],
	[9.5400000000E+03, 3.5857448503E+00, 5.9219414767E+00, 1.3159003382E-01, 1.2426828774E-01, 5.1304838831E-01],
	[9.5450000000E+03, 3.5881894451E+00, 5.9210437448E+00, 1.3180231071E-01, 1.2446012891E-01, 5.1320739900E-01],
	[9.5500000000E+03, 3.5906344250E+00, 5.9201466191E+00, 1.3201481821E-01, 1.2465215390E-01, 5.1336637286E-01],
	[9.5550000000E+03, 3.5930797898E+00, 5.9192500987E+00, 1.3222755645E-01, 1.2484436278E-01, 5.1352530992E-01],
	[9.5600000000E+03, 3.5955255394E+00, 5.9183541830E+00, 1.3244052557E-01, 1.2503675558E-01, 5.1368421022E-01],
	[9.5650000000E+03, 3.5979716736E+00, 5.9174588713E+00, 1.3265372569E-01, 1.2522933234E-01, 5.1384307381E-01],
	[9.5700000000E+03, 3.6004181924E+00, 5.9165641628E+00, 1.3286715694E-01, 1.2542209313E-01, 5.1400190073E-01],
	[9.5750000000E+03, 3.6028650955E+00, 5.9156700568E+00, 1.3308081945E-01, 1.2561503797E-01, 5.1416069101E-01],
	[9.5800000000E+03, 3.6053123829E+00, 5.9147765526E+00, 1.3329471334E-01, 1.2580816691E-01, 5.1431944469E-01],
	[9.5850000000E+03, 3.6077600543E+00, 5.9138836494E+00, 1.3350883876E-01, 1.2600148001E-01, 5.1447816183E-01],
	[9.5900000000E+03, 3.6102081097E+00, 5.9129913466E+00, 1.3372319582E-01, 1.2619497730E-01, 5.1463684245E-01],
	[9.5950000000E+03, 3.6126565490E+00, 5.9120996435E+00, 1.3393778466E-01, 1.2638865884E-01, 5.1479548660E-01],
	[9.6000000000E+03, 3.6151053718E+00, 5.9112085392E+00, 1.3415260540E-01, 1.2658252465E-01, 5.1495409431E-01],
	[9.6050000000E+03, 3.6175545782E+00, 5.9103180331E+00, 1.3436765817E-01, 1.2677657480E-01, 5.1511266564E-01],
	[9.6100000000E+03, 3.6200041680E+00, 5.9094281246E+00, 1.3458294311E-01, 1.2697080932E-01, 5.1527120062E-01],
	[9.6150000000E+03, 3.6224541411E+00, 5.9085388128E+00, 1.3479846034E-01, 1.2716522827E-01, 5.1542969929E-01],
	[9.6200000000E+03, 3.6249044973E+00, 5.9076500971E+00, 1.3501420999E-01, 1.2735983167E-01, 5.1558816169E-01],
	[9.6250000000E+03, 3.6273565182E+00, 5.9067662803E+00, 1.3523019219E-01, 1.2755462317E-01, 5.1574658786E-01],
	[9.6300000000E+03, 3.6298121312E+00, 5.9058938175E+00, 1.3544640707E-01, 1.2774960826E-01, 5.1590497785E-01],
	[9.6350000000E+03, 3.6322681306E+00, 5.9050219362E+00, 1.3566285475E-01, 1.2794477801E-01, 5.1606333169E-01],
	[9.6400000000E+03, 3.6347245163E+00, 5.9041506359E+00, 1.3587953537E-01, 1.2814013246E-01, 5.1622164942E-01],
	[9.6450000000E+03, 3.6371812882E+00, 5.9032799159E+00, 1.3609644906E-01, 1.2833567166E-01, 5.1637993108E-01],
	[9.6500000000E+03, 3.6396384460E+00, 5.9024097755E+00, 1.3631359594E-01, 1.2853139565E-01, 5.1653817673E-01],
	[9.6550000000E+03, 3.6420959898E+00, 5.9015402139E+00, 1.3653097615E-01, 1.2872730449E-01, 5.1669638638E-01],
	[9.6600000000E+03, 3.6445539193E+00, 5.9006712306E+00, 1.3674858980E-01, 1.2892339820E-01, 5.1685456010E-01],
	[9.6650000000E+03, 3.6470122344E+00, 5.8998028248E+00, 1.3696643704E-01, 1.2911967684E-01, 5.1701269791E-01],
	[9.6700000000E+03, 3.6494709349E+00, 5.8989349958E+00, 1.3718451799E-01, 1.2931614045E-01, 5.1717079986E-01],
	[9.6750000000E+03, 3.6519300208E+00, 5.8980677430E+00, 1.3740283278E-01, 1.2951278907E-01, 5.1732886598E-01],
	[9.6800000000E+03, 3.6543894918E+00, 5.8972010657E+00, 1.3762138154E-01, 1.2970962275E-01, 5.1748689633E-01],
	[9.6850000000E+03, 3.6568493479E+00, 5.8963349631E+00, 1.3784016440E-01, 1.2990664153E-01, 5.1764489093E-01],
	[9.6900000000E+03, 3.6593095889E+00, 5.8954694347E+00, 1.3805918149E-01, 1.3010384545E-01, 5.1780284983E-01],
	[9.6950000000E+03, 3.6617702147E+00, 5.8946044798E+00, 1.3827843293E-01, 1.3030123456E-01, 5.1796077307E-01],
	[9.7000000000E+03, 3.6642312250E+00, 5.8937400976E+00, 1.3849791885E-01, 1.3049880889E-01, 5.1811866070E-01],
	[9.7050000000E+03, 3.6666926199E+00, 5.8928762875E+00, 1.3871763939E-01, 1.3069656850E-01, 5.1827651274E-01],
	[9.7100000000E+03, 3.6691543991E+00, 5.8920130488E+00, 1.3893759467E-01, 1.3089451342E-01, 5.1843432924E-01],
	[9.7150000000E+03, 3.6716165625E+00, 5.8911503809E+00, 1.3915778483E-01, 1.3109264370E-01, 5.1859211025E-01],
	[9.7200000000E+03, 3.6740791100E+00, 5.8902882831E+00, 1.3937820998E-01, 1.3129095938E-01, 5.1874985580E-01],
	[9.7250000000E+03, 3.6765420415E+00, 5.8894267547E+00, 1.3959887027E-01, 1.3148946051E-01, 5.1890756593E-01],
	[9.7300000000E+03, 3.6790053567E+00, 5.8885657950E+00, 1.3981976582E-01, 1.3168814711E-01, 5.1906524069E-01],
	[9.7350000000E+03, 3.6814690556E+00, 5.8877054034E+00, 1.4004089675E-01, 1.3188701925E-01, 5.1922288011E-01],
	[9.7400000000E+03, 3.6839331380E+00, 5.8868455792E+00, 1.4026226320E-01, 1.3208607696E-01, 5.1938048423E-01],
	[9.7450000000E+03, 3.6863976038E+00, 5.8859863218E+00, 1.4048386530E-01, 1.3228532027E-01, 5.1953805310E-01],
	[9.7500000000E+03, 3.6888624529E+00, 5.8851276304E+00, 1.4070570318E-01, 1.3248474925E-01, 5.1969558675E-01],
	[9.7550000000E+03, 3.6913276850E+00, 5.8842695044E+00, 1.4092777696E-01, 1.3268436391E-01, 5.1985308523E-01],
	[9.7600000000E+03, 3.6937933002E+00, 5.8834119433E+00, 1.4115008677E-01, 1.3288416432E-01, 5.2001054858E-01],
	[9.7650000000E+03, 3.6962592981E+00, 5.8825549462E+00, 1.4137263275E-01, 1.3308415050E-01, 5.2016797683E-01],
	[9.7700000000E+03, 3.6987256788E+00, 5.8816985125E+00, 1.4159541502E-01, 1.3328432251E-01, 5.2032537003E-01],
	[9.7750000000E+03, 3.7011924421E+00, 5.8808426416E+00, 1.4181843371E-01, 1.3348468038E-01, 5.2048272822E-01],
	[9.7800000000E+03, 3.7036609258E+00, 5.8799916427E+00, 1.4204168895E-01, 1.3368522813E-01, 5.2064005143E-01],
	[9.7850000000E+03, 3.7061329122E+00, 5.8791512407E+00, 1.4226518088E-01, 1.3388597111E-01, 5.2079733971E-01],
	[9.7900000000E+03, 3.7086052844E+00, 5.8783113880E+00, 1.4248890961E-01, 1.3408690016E-01, 5.2095459311E-01],
	[9.7950000000E+03, 3.7110780423E+00, 5.8774720841E+00, 1.4271287527E-01, 1.3428801529E-01, 5.2111181165E-01],
	[9.8000000000E+03, 3.7135511858E+00, 5.8766333283E+00, 1.4293707801E-01, 1.3448931657E-01, 5.2126899538E-01],
	[9.8050000000E+03, 3.7160247146E+00, 5.8757951198E+00, 1.4316151794E-01, 1.3469080402E-01, 5.2142614433E-01],
	[9.8100000000E+03, 3.7184986288E+00, 5.8749574582E+00, 1.4338619520E-01, 1.3489247769E-01, 5.2158325856E-01],
	[9.8150000000E+03, 3.7209729280E+00, 5.8741203428E+00, 1.4361110991E-01, 1.3509433762E-01, 5.2174033810E-01],
	[9.8200000000E+03, 3.7234476123E+00, 5.8732837728E+00, 1.4383626221E-01, 1.3529638386E-01, 5.2189738300E-01],
	[9.8250000000E+03, 3.7259226815E+00, 5.8724477478E+00, 1.4406165222E-01, 1.3549861643E-01, 5.2205439328E-01],
	[9.8300000000E+03, 3.7283981353E+00, 5.8716122670E+00, 1.4428728007E-01, 1.3570103539E-01, 5.2221136899E-01],
	[9.8350000000E+03, 3.7308739738E+00, 5.8707773298E+00, 1.4451314589E-01, 1.3590364077E-01, 5.2236831018E-01],
	[9.8400000000E+03, 3.7333501967E+00, 5.8699429357E+00, 1.4473924981E-01, 1.3610643261E-01, 5.2252521688E-01],
	[9.8450000000E+03, 3.7358268039E+00, 5.8691090839E+00, 1.4496559197E-01, 1.3630941095E-01, 5.2268208913E-01],
	[9.8500000000E+03, 3.7383037954E+00, 5.8682757739E+00, 1.4519217248E-01, 1.3651257584E-01, 5.2283892697E-01],
	[9.8550000000E+03, 3.7407811708E+00, 5.8674430050E+00, 1.4541899147E-01, 1.3671592732E-01, 5.2299573045E-01],
	[9.8600000000E+03, 3.7432589302E+00, 5.8666107765E+00, 1.4564604909E-01, 1.3691946541E-01, 5.2315249960E-01],
	[9.8650000000E+03, 3.7457370734E+00, 5.8657790880E+00, 1.4587334545E-01, 1.3712319018E-01, 5.2330923446E-01],
	[9.8700000000E+03, 3.7482156002E+00, 5.8649479387E+00, 1.4610088069E-01, 1.3732710164E-01, 5.2346593508E-01],
	[9.8750000000E+03, 3.7506945105E+00, 5.8641173280E+00, 1.4632865493E-01, 1.3753119985E-01, 5.2362260150E-01],
	[9.8800000000E+03, 3.7531738042E+00, 5.8632872553E+00, 1.4655666831E-01, 1.3773548484E-01, 5.2377923375E-01],
	[9.8850000000E+03, 3.7556534811E+00, 5.8624577200E+00, 1.4678492095E-01, 1.3793995666E-01, 5.2393583187E-01],
	[9.8900000000E+03, 3.7581335412E+00, 5.8616287214E+00, 1.4701341298E-01, 1.3814461533E-01, 5.2409239591E-01],
	[9.8950000000E+03, 3.7606139842E+00, 5.8608002590E+00, 1.4724214453E-01, 1.3834946091E-01, 5.2424892590E-01],
	[9.9000000000E+03, 3.7630948100E+00, 5.8599723322E+00, 1.4747111573E-01, 1.3855449343E-01, 5.2440542189E-01],
	[9.9050000000E+03, 3.7655760186E+00, 5.8591449402E+00, 1.4770032672E-01, 1.3875971293E-01, 5.2456188392E-01],
	[9.9100000000E+03, 3.7680576097E+00, 5.8583180825E+00, 1.4792977761E-01, 1.3896511944E-01, 5.2471831202E-01],
	[9.9150000000E+03, 3.7705395832E+00, 5.8574917585E+00, 1.4815946854E-01, 1.3917071302E-01, 5.2487470624E-01],
	[9.9200000000E+03, 3.7730219390E+00, 5.8566659676E+00, 1.4838939964E-01, 1.3937649369E-01, 5.2503106662E-01],
	[9.9250000000E+03, 3.7755046771E+00, 5.8558407091E+00, 1.4861957104E-01, 1.3958246150E-01, 5.2518739320E-01],
	[9.9300000000E+03, 3.7779877971E+00, 5.8550159824E+00, 1.4884998286E-01, 1.3978861648E-01, 5.2534368601E-01],
	[9.9350000000E+03, 3.7804712990E+00, 5.8541917870E+00, 1.4908063523E-01, 1.3999495867E-01, 5.2549994510E-01],
	[9.9400000000E+03, 3.7829587973E+00, 5.8533792738E+00, 1.4931152829E-01, 1.4020149948E-01, 5.2565617051E-01],
	[9.9450000000E+03, 3.7854474945E+00, 5.8525697925E+00, 1.4954266217E-01, 1.4040823020E-01, 5.2581236227E-01],
	[9.9500000000E+03, 3.7879365769E+00, 5.8517608300E+00, 1.4977403699E-01, 1.4061514831E-01, 5.2596852044E-01],
	[9.9550000000E+03, 3.7904260442E+00, 5.8509523857E+00, 1.5000565288E-01, 1.4082225386E-01, 5.2612464504E-01],
	[9.9600000000E+03, 3.7929158963E+00, 5.8501444589E+00, 1.5023750997E-01, 1.4102954689E-01, 5.2628073612E-01],
	[9.9650000000E+03, 3.7954061331E+00, 5.8493370490E+00, 1.5046960839E-01, 1.4123702742E-01, 5.2643679372E-01],
	[9.9700000000E+03, 3.7978967545E+00, 5.8485301555E+00, 1.5070194827E-01, 1.4144469551E-01, 5.2659281788E-01],
	[9.9750000000E+03, 3.8003877603E+00, 5.8477237778E+00, 1.5093452975E-01, 1.4165255118E-01, 5.2674880864E-01],
	[9.9800000000E+03, 3.8028791504E+00, 5.8469179153E+00, 1.5116735294E-01, 1.4186059447E-01, 5.2690476604E-01],
	[9.9850000000E+03, 3.8053709246E+00, 5.8461125675E+00, 1.5140041797E-01, 1.4206882544E-01, 5.2706069012E-01],
	[9.9900000000E+03, 3.8078630828E+00, 5.8453077336E+00, 1.5163372499E-01, 1.4227724410E-01, 5.2721658092E-01],
	[9.9950000000E+03, 3.8103556250E+00, 5.8445034132E+00, 1.5186727411E-01, 1.4248585049E-01, 5.2737243847E-01],
	[1.0000000000E+04, 3.8128485509E+00, 5.8436996056E+00, 1.5210106547E-01, 1.4269464467E-01, 5.2752826283E-01],
	[1.0005000000E+04, 3.8153418604E+00, 5.8428963103E+00, 1.5233645812E-01, 1.4290482253E-01, 5.2768405403E-01],
	[1.0010000000E+04, 3.8178355534E+00, 5.8420935267E+00, 1.5257209686E-01, 1.4311519104E-01, 5.2783981211E-01],
	[1.0015000000E+04, 3.8203296298E+00, 5.8412912542E+00, 1.5280798182E-01, 1.4332575024E-01, 5.2799553711E-01],
	[1.0020000000E+04, 3.8228240894E+00, 5.8404894922E+00, 1.5304411313E-01, 1.4353650017E-01, 5.2815122907E-01],
	[1.0025000000E+04, 3.8253189321E+00, 5.8396882401E+00, 1.5328049092E-01, 1.4374744088E-01, 5.2830688803E-01],
	[1.0030000000E+04, 3.8278141577E+00, 5.8388874975E+00, 1.5351711533E-01, 1.4395857239E-01, 5.2846251404E-01],
	[1.0035000000E+04, 3.8303097662E+00, 5.8380872636E+00, 1.5375398650E-01, 1.4416989475E-01, 5.2861810712E-01],
	[1.0040000000E+04, 3.8328057573E+00, 5.8372875379E+00, 1.5399110455E-01, 1.4438140800E-01, 5.2877366733E-01],
	[1.0045000000E+04, 3.8353021311E+00, 5.8364883199E+00, 1.5422846962E-01, 1.4459311217E-01, 5.2892919469E-01],
	[1.0050000000E+04, 3.8377988873E+00, 5.8356896089E+00, 1.5446608184E-01, 1.4480500730E-01, 5.2908468926E-01],
	[1.0055000000E+04, 3.8402960257E+00, 5.8348914045E+00, 1.5470394135E-01, 1.4501709344E-01, 5.2924015107E-01],
	[1.0060000000E+04, 3.8427935464E+00, 5.8340937059E+00, 1.5494204828E-01, 1.4522937061E-01, 5.2939558016E-01],
	[1.0065000000E+04, 3.8452914490E+00, 5.8332965127E+00, 1.5518040276E-01, 1.4544183887E-01, 5.2955097658E-01],
	[1.0070000000E+04, 3.8477897336E+00, 5.8324998243E+00, 1.5541900494E-01, 1.4565449824E-01, 5.2970634035E-01],
	[1.0075000000E+04, 3.8502884000E+00, 5.8317036400E+00, 1.5565785493E-01, 1.4586734876E-01, 5.2986167153E-01],
	[1.0080000000E+04, 3.8527874480E+00, 5.8309079594E+00, 1.5589695288E-01, 1.4608039047E-01, 5.3001697015E-01],
	[1.0085000000E+04, 3.8552868775E+00, 5.8301127819E+00, 1.5613629892E-01, 1.4629362342E-01, 5.3017223625E-01],
	[1.0090000000E+04, 3.8577866884E+00, 5.8293181069E+00, 1.5637589318E-01, 1.4650704763E-01, 5.3032746988E-01],
	[1.0095000000E+04, 3.8602868805E+00, 5.8285239338E+00, 1.5661573579E-01, 1.4672066314E-01, 5.3048267106E-01],
	[1.0100000000E+04, 3.8627911414E+00, 5.8277410762E+00, 1.5685582690E-01, 1.4693448221E-01, 5.3063783985E-01],
	[1.0105000000E+04, 3.8652965676E+00, 5.8269610007E+00, 1.5709616663E-01, 1.4714849530E-01, 5.3079297626E-01],
	[1.0110000000E+04, 3.8678023782E+00, 5.8261814154E+00, 1.5733675512E-01, 1.4736269989E-01, 5.3094808030E-01],
	[1.0115000000E+04, 3.8703085732E+00, 5.8254023199E+00, 1.5757759250E-01, 1.4757709600E-01, 5.3110315200E-01],
	[1.0120000000E+04, 3.8728151523E+00, 5.8246237134E+00, 1.5781867890E-01, 1.4779168368E-01, 5.3125819136E-01],
	[1.0125000000E+04, 3.8753221155E+00, 5.8238455955E+00, 1.5806001446E-01, 1.4800646295E-01, 5.3141319843E-01],
	[1.0130000000E+04, 3.8778294625E+00, 5.8230679657E+00, 1.5830159932E-01, 1.4822143387E-01, 5.3156817322E-01],
	[1.0135000000E+04, 3.8803371934E+00, 5.8222908234E+00, 1.5854343360E-01, 1.4843659646E-01, 5.3172311576E-01],
	[1.0140000000E+04, 3.8828453079E+00, 5.8215141679E+00, 1.5878551744E-01, 1.4865195076E-01, 5.3187802606E-01],
	[1.0145000000E+04, 3.8853538059E+00, 5.8207379989E+00, 1.5902785097E-01, 1.4886749680E-01, 5.3203290416E-01],
	[1.0150000000E+04, 3.8878626873E+00, 5.8199623158E+00, 1.5927043433E-01, 1.4908323463E-01, 5.3218775007E-01],
	[1.0155000000E+04, 3.8903719520E+00, 5.8191871179E+00, 1.5951326766E-01, 1.4929916428E-01, 5.3234256382E-01],
	[1.0160000000E+04, 3.8928815998E+00, 5.8184124048E+00, 1.5975635108E-01, 1.4951528579E-01, 5.3249734544E-01],
	[1.0165000000E+04, 3.8953916306E+00, 5.8176381760E+00, 1.5999968472E-01, 1.4973159919E-01, 5.3265209495E-01],
	[1.0170000000E+04, 3.8979020443E+00, 5.8168644308E+00, 1.6024326873E-01, 1.4994810452E-01, 5.3280681236E-01],
	[1.0175000000E+04, 3.9004128407E+00, 5.8160911687E+00, 1.6048710324E-01, 1.5016480182E-01, 5.3296149771E-01],
	[1.0180000000E+04, 3.9029240197E+00, 5.8153183893E+00, 1.6073118837E-01, 1.5038169112E-01, 5.3311615102E-01],
	[1.0185000000E+04, 3.9054355812E+00, 5.8145460920E+00, 1.6097552427E-01, 1.5059877245E-01, 5.3327077231E-01],
	[1.0190000000E+04, 3.9079475251E+00, 5.8137742761E+00, 1.6122011107E-01, 1.5081604586E-01, 5.3342536160E-01],
	[1.0195000000E+04, 3.9104598512E+00, 5.8130029413E+00, 1.6146494890E-01, 1.5103351137E-01, 5.3357991892E-01],
	[1.0200000000E+04, 3.9129725593E+00, 5.8122320869E+00, 1.6171003789E-01, 1.5125116903E-01, 5.3373444430E-01],
	[1.0205000000E+04, 3.9154856495E+00, 5.8114617125E+00, 1.6195537819E-01, 1.5146901886E-01, 5.3388893775E-01],
	[1.0210000000E+04, 3.9179991214E+00, 5.8106918174E+00, 1.6220096991E-01, 1.5168706091E-01, 5.3404339930E-01],
	[1.0215000000E+04, 3.9205129751E+00, 5.8099224012E+00, 1.6244681321E-01, 1.5190529521E-01, 5.3419782898E-01],
	[1.0220000000E+04, 3.9230272104E+00, 5.8091534633E+00, 1.6269290820E-01, 1.5212372180E-01, 5.3435222680E-01],
	[1.0225000000E+04, 3.9255418270E+00, 5.8083850032E+00, 1.6293925503E-01, 1.5234234070E-01, 5.3450659280E-01],
	[1.0230000000E+04, 3.9280568251E+00, 5.8076170204E+00, 1.6318585382E-01, 1.5256115196E-01, 5.3466092699E-01],
	[1.0235000000E+04, 3.9305722043E+00, 5.8068495143E+00, 1.6343270472E-01, 1.5278015560E-01, 5.3481522940E-01],
	[1.0240000000E+04, 3.9330879645E+00, 5.8060824844E+00, 1.6367980786E-01, 1.5299935167E-01, 5.3496950005E-01],
	[1.0245000000E+04, 3.9356041057E+00, 5.8053159302E+00, 1.6392716336E-01, 1.5321874020E-01, 5.3512373896E-01],
	[1.0250000000E+04, 3.9381206277E+00, 5.8045498512E+00, 1.6417477137E-01, 1.5343832122E-01, 5.3527794617E-01],
	[1.0255000000E+04, 3.9406375304E+00, 5.8037842467E+00, 1.6442263202E-01, 1.5365809476E-01, 5.3543212169E-01],
	[1.0260000000E+04, 3.9431562699E+00, 5.8030231537E+00, 1.6467074543E-01, 1.5387806593E-01, 5.3558626555E-01],
	[1.0265000000E+04, 3.9456784976E+00, 5.8022711368E+00, 1.6491911176E-01, 1.5409824052E-01, 5.3574037777E-01],
	[1.0270000000E+04, 3.9482011091E+00, 5.8015195835E+00, 1.6516773112E-01, 1.5431860781E-01, 5.3589445837E-01],
	[1.0275000000E+04, 3.9507241045E+00, 5.8007684932E+00, 1.6541660365E-01, 1.5453916785E-01, 5.3604850739E-01],
	[1.0280000000E+04, 3.9532474834E+00, 5.8000178655E+00, 1.6566572949E-01, 1.5475992065E-01, 5.3620252483E-01],
	[1.0285000000E+04, 3.9557712459E+00, 5.7992676999E+00, 1.6591510878E-01, 1.5498086627E-01, 5.3635651073E-01],
	[1.0290000000E+04, 3.9582953918E+00, 5.7985179959E+00, 1.6616474163E-01, 1.5520200472E-01, 5.3651046512E-01],
	[1.0295000000E+04, 3.9608199209E+00, 5.7977687529E+00, 1.6641462820E-01, 1.5542333605E-01, 5.3666438801E-01],
	[1.0300000000E+04, 3.9633448331E+00, 5.7970199704E+00, 1.6666476861E-01, 1.5564486029E-01, 5.3681827942E-01],
	[1.0305000000E+04, 3.9658701284E+00, 5.7962716480E+00, 1.6691516300E-01, 1.5586657747E-01, 5.3697213939E-01],
	[1.0310000000E+04, 3.9683958065E+00, 5.7955237851E+00, 1.6716581149E-01, 1.5608848763E-01, 5.3712596793E-01],
	[1.0315000000E+04, 3.9709218674E+00, 5.7947763812E+00, 1.6741671423E-01, 1.5631059079E-01, 5.3727976508E-01],
	[1.0320000000E+04, 3.9734483109E+00, 5.7940294358E+00, 1.6766787135E-01, 1.5653288699E-01, 5.3743353085E-01],
	[1.0325000000E+04, 3.9759751368E+00, 5.7932829485E+00, 1.6791928298E-01, 1.5675537627E-01, 5.3758726526E-01],
	[1.0330000000E+04, 3.9785023452E+00, 5.7925369186E+00, 1.6817094926E-01, 1.5697805866E-01, 5.3774096835E-01],
	[1.0335000000E+04, 3.9810299357E+00, 5.7917913458E+00, 1.6842287032E-01, 1.5720093418E-01, 5.3789464013E-01],
	[1.0340000000E+04, 3.9835579084E+00, 5.7910462295E+00, 1.6867504629E-01, 1.5742400288E-01, 5.3804828064E-01],
	[1.0345000000E+04, 3.9860862631E+00, 5.7903015692E+00, 1.6892747731E-01, 1.5764726478E-01, 5.3820188988E-01],
	[1.0350000000E+04, 3.9886149996E+00, 5.7895573644E+00, 1.6918016351E-01, 1.5787071992E-01, 5.3835546790E-01],
	[1.0355000000E+04, 3.9911441179E+00, 5.7888136146E+00, 1.6943310503E-01, 1.5809436833E-01, 5.3850901471E-01],
	[1.0360000000E+04, 3.9936736177E+00, 5.7880703194E+00, 1.6968630200E-01, 1.5831821004E-01, 5.3866253033E-01],
	[1.0365000000E+04, 3.9962034991E+00, 5.7873274781E+00, 1.6993975455E-01, 1.5854224509E-01, 5.3881601479E-01],
	[1.0370000000E+04, 3.9987337617E+00, 5.7865850904E+00, 1.7019346282E-01, 1.5876647350E-01, 5.3896946811E-01],
	[1.0375000000E+04, 4.0012644056E+00, 5.7858431557E+00, 1.7044742694E-01, 1.5899089531E-01, 5.3912289033E-01],
	[1.0380000000E+04, 4.0037954306E+00, 5.7851016735E+00, 1.7070164705E-01, 1.5921551055E-01, 5.3927628145E-01],
	[1.0385000000E+04, 4.0063268366E+00, 5.7843606434E+00, 1.7095612328E-01, 1.5944031925E-01, 5.3942964151E-01],
	[1.0390000000E+04, 4.0088586234E+00, 5.7836200648E+00, 1.7121085576E-01, 1.5966532145E-01, 5.3958297053E-01],
	[1.0395000000E+04, 4.0113907909E+00, 5.7828799373E+00, 1.7146584463E-01, 1.5989051717E-01, 5.3973626853E-01],
	[1.0400000000E+04, 4.0139233390E+00, 5.7821402603E+00, 1.7172109002E-01, 1.6011590644E-01, 5.3988953555E-01],
	[1.0405000000E+04, 4.0164562676E+00, 5.7814010335E+00, 1.7197659207E-01, 1.6034148931E-01, 5.4004277159E-01],
	[1.0410000000E+04, 4.0189895765E+00, 5.7806622561E+00, 1.7223235091E-01, 1.6056726579E-01, 5.4019597669E-01],
	[1.0415000000E+04, 4.0215232656E+00, 5.7799239279E+00, 1.7248836667E-01, 1.6079323592E-01, 5.4034915087E-01],
	[1.0420000000E+04, 4.0240573349E+00, 5.7791860483E+00, 1.7274463949E-01, 1.6101939973E-01, 5.4050229416E-01],
	[1.0425000000E+04, 4.0265931348E+00, 5.7784521550E+00, 1.7300116950E-01, 1.6124576218E-01, 5.4065540657E-01],
	[1.0430000000E+04, 4.0291326240E+00, 5.7777273667E+00, 1.7325795684E-01, 1.6147233047E-01, 5.4080848813E-01],
	[1.0435000000E+04, 4.0316724965E+00, 5.7770030166E+00, 1.7351500164E-01, 1.6169909261E-01, 5.4096153888E-01],
	[1.0440000000E+04, 4.0342127522E+00, 5.7762791042E+00, 1.7377230404E-01, 1.6192604863E-01, 5.4111455882E-01],
	[1.0445000000E+04, 4.0367533911E+00, 5.7755556291E+00, 1.7402986416E-01, 1.6215319857E-01, 5.4126754799E-01],
	[1.0450000000E+04, 4.0392944129E+00, 5.7748325907E+00, 1.7428768214E-01, 1.6238054246E-01, 5.4142050640E-01],
	[1.0455000000E+04, 4.0418358176E+00, 5.7741099887E+00, 1.7454575812E-01, 1.6260808032E-01, 5.4157343410E-01],
	[1.0460000000E+04, 4.0443776050E+00, 5.7733878226E+00, 1.7480409223E-01, 1.6283581218E-01, 5.4172633108E-01],
	[1.0465000000E+04, 4.0469197750E+00, 5.7726660918E+00, 1.7506268461E-01, 1.6306373809E-01, 5.4187919739E-01],
	[1.0470000000E+04, 4.0494623274E+00, 5.7719447959E+00, 1.7532153538E-01, 1.6329185805E-01, 5.4203203305E-01],
	[1.0475000000E+04, 4.0520052622E+00, 5.7712239345E+00, 1.7558064469E-01, 1.6352017212E-01, 5.4218483808E-01],
	[1.0480000000E+04, 4.0545485792E+00, 5.7705035071E+00, 1.7584001266E-01, 1.6374868031E-01, 5.4233761250E-01],
	[1.0485000000E+04, 4.0570922783E+00, 5.7697835131E+00, 1.7609963944E-01, 1.6397738265E-01, 5.4249035633E-01],
	[1.0490000000E+04, 4.0596363594E+00, 5.7690639522E+00, 1.7635952515E-01, 1.6420627919E-01, 5.4264306962E-01],
	[1.0495000000E+04, 4.0621808223E+00, 5.7683448238E+00, 1.7661966993E-01, 1.6443536993E-01, 5.4279575236E-01],
	[1.0500000000E+04, 4.0647256669E+00, 5.7676261276E+00, 1.7688007391E-01, 1.6466465492E-01, 5.4294840461E-01],
	[1.0505000000E+04, 4.0672708932E+00, 5.7669078629E+00, 1.7714073723E-01, 1.6489413419E-01, 5.4310102636E-01],
	[1.0510000000E+04, 4.0698165009E+00, 5.7661900295E+00, 1.7740166002E-01, 1.6512380775E-01, 5.4325361766E-01],
	[1.0515000000E+04, 4.0723624899E+00, 5.7654726267E+00, 1.7766284242E-01, 1.6535367565E-01, 5.4340617852E-01],
	[1.0520000000E+04, 4.0749088602E+00, 5.7647556542E+00, 1.7792428456E-01, 1.6558373791E-01, 5.4355870896E-01],
	[1.0525000000E+04, 4.0774556116E+00, 5.7640391115E+00, 1.7818598657E-01, 1.6581399456E-01, 5.4371120902E-01],
	[1.0530000000E+04, 4.0800027439E+00, 5.7633229981E+00, 1.7844794859E-01, 1.6604444563E-01, 5.4386367872E-01],
	[1.0535000000E+04, 4.0825502571E+00, 5.7626073136E+00, 1.7871017075E-01, 1.6627509115E-01, 5.4401611808E-01],
	[1.0540000000E+04, 4.0850981510E+00, 5.7618920574E+00, 1.7897265319E-01, 1.6650593114E-01, 5.4416852713E-01],
	[1.0545000000E+04, 4.0876464255E+00, 5.7611772292E+00, 1.7923539604E-01, 1.6673696563E-01, 5.4432090588E-01],
	[1.0550000000E+04, 4.0901950805E+00, 5.7604628285E+00, 1.7949839944E-01, 1.6696819466E-01, 5.4447325437E-01],
	[1.0555000000E+04, 4.0927441158E+00, 5.7597488548E+00, 1.7976166351E-01, 1.6719961825E-01, 5.4462557262E-01],
	[1.0560000000E+04, 4.0952935314E+00, 5.7590353077E+00, 1.8002518839E-01, 1.6743123643E-01, 5.4477786065E-01],
	[1.0565000000E+04, 4.0978433271E+00, 5.7583221867E+00, 1.8028897423E-01, 1.6766304922E-01, 5.4493011848E-01],
	[1.0570000000E+04, 4.1003935028E+00, 5.7576094913E+00, 1.8055302114E-01, 1.6789505667E-01, 5.4508234615E-01],
	[1.0575000000E+04, 4.1029440583E+00, 5.7568972211E+00, 1.8081732927E-01, 1.6812725878E-01, 5.4523454368E-01],
	[1.0580000000E+04, 4.1054949936E+00, 5.7561853757E+00, 1.8108189875E-01, 1.6835965559E-01, 5.4538671109E-01],
	[1.0585000000E+04, 4.1080463084E+00, 5.7554739545E+00, 1.8134672972E-01, 1.6859224713E-01, 5.4553884840E-01],
	[1.0590000000E+04, 4.1105980028E+00, 5.7547629572E+00, 1.8161182230E-01, 1.6882503343E-01, 5.4569095564E-01],
	[1.0595000000E+04, 4.1131535436E+00, 5.7540609622E+00, 1.8187717664E-01, 1.6905802777E-01, 5.4584303283E-01],
	[1.0600000000E+04, 4.1157107557E+00, 5.7533625720E+00, 1.8214279286E-01, 1.6929122193E-01, 5.4599508000E-01],
	[1.0605000000E+04, 4.1182683505E+00, 5.7526645959E+00, 1.8240867110E-01, 1.6952461101E-01, 5.4614709718E-01],
	[1.0610000000E+04, 4.1208263280E+00, 5.7519670335E+00, 1.8267481150E-01, 1.6975819503E-01, 5.4629908438E-01],
	[1.0615000000E+04, 4.1233846881E+00, 5.7512698841E+00, 1.8294121419E-01, 1.6999197404E-01, 5.4645104163E-01],
	[1.0620000000E+04, 4.1259434306E+00, 5.7505731476E+00, 1.8320787930E-01, 1.7022594804E-01, 5.4660296896E-01],
	[1.0625000000E+04, 4.1285025554E+00, 5.7498768233E+00, 1.8347480696E-01, 1.7046011708E-01, 5.4675486639E-01],
	[1.0630000000E+04, 4.1310620623E+00, 5.7491809109E+00, 1.8374199733E-01, 1.7069448117E-01, 5.4690673394E-01],
	[1.0635000000E+04, 4.1336219513E+00, 5.7484854099E+00, 1.8400945051E-01, 1.7092904035E-01, 5.4705857164E-01],
	[1.0640000000E+04, 4.1361822222E+00, 5.7477903199E+00, 1.8427716666E-01, 1.7116379464E-01, 5.4721037952E-01],
	[1.0645000000E+04, 4.1387428749E+00, 5.7470956404E+00, 1.8454514590E-01, 1.7139874406E-01, 5.4736215760E-01],
	[1.0650000000E+04, 4.1413039093E+00, 5.7464013711E+00, 1.8481338837E-01, 1.7163388865E-01, 5.4751390589E-01],
	[1.0655000000E+04, 4.1438653253E+00, 5.7457075115E+00, 1.8508189421E-01, 1.7186922842E-01, 5.4766562439E-01],
	[1.0660000000E+04, 4.1464271227E+00, 5.7450140611E+00, 1.8535066354E-01, 1.7210476342E-01, 5.4781731312E-01],
	[1.0665000000E+04, 4.1489893014E+00, 5.7443210195E+00, 1.8561969651E-01, 1.7234049365E-01, 5.4796897208E-01],
	[1.0670000000E+04, 4.1515518613E+00, 5.7436283863E+00, 1.8588899324E-01, 1.7257641915E-01, 5.4812060129E-01],
	[1.0675000000E+04, 4.1541148023E+00, 5.7429361610E+00, 1.8615855387E-01, 1.7281253995E-01, 5.4827220076E-01],
	[1.0680000000E+04, 4.1566781242E+00, 5.7422443433E+00, 1.8642837853E-01, 1.7304885606E-01, 5.4842377050E-01],
	[1.0685000000E+04, 4.1592418269E+00, 5.7415529327E+00, 1.8669846737E-01, 1.7328536752E-01, 5.4857531052E-01],
	[1.0690000000E+04, 4.1618059104E+00, 5.7408619287E+00, 1.8696882051E-01, 1.7352207435E-01, 5.4872682083E-01],
	[1.0695000000E+04, 4.1643703744E+00, 5.7401713309E+00, 1.8723943808E-01, 1.7375897658E-01, 5.4887830145E-01],
	[1.0700000000E+04, 4.1669352189E+00, 5.7394811390E+00, 1.8751032023E-01, 1.7399607422E-01, 5.4902975239E-01],
	[1.0705000000E+04, 4.1695004438E+00, 5.7387913524E+00, 1.8778146708E-01, 1.7423336731E-01, 5.4918117366E-01],
	[1.0710000000E+04, 4.1720660488E+00, 5.7381019708E+00, 1.8805287878E-01, 1.7447085588E-01, 5.4933256527E-01],
	[1.0715000000E+04, 4.1746320340E+00, 5.7374129937E+00, 1.8832455545E-01, 1.7470853994E-01, 5.4948392723E-01],
	[1.0720000000E+04, 4.1771983991E+00, 5.7367244207E+00, 1.8859649723E-01, 1.7494641952E-01, 5.4963525956E-01],
	[1.0725000000E+04, 4.1797651441E+00, 5.7360362513E+00, 1.8886870425E-01, 1.7518449464E-01, 5.4978656227E-01],
	[1.0730000000E+04, 4.1823322688E+00, 5.7353484852E+00, 1.8914117665E-01, 1.7542276534E-01, 5.4993783536E-01],
	[1.0735000000E+04, 4.1848997732E+00, 5.7346611219E+00, 1.8941391456E-01, 1.7566123163E-01, 5.5008907886E-01],
	[1.0740000000E+04, 4.1874676570E+00, 5.7339741611E+00, 1.8968691812E-01, 1.7589989354E-01, 5.5024029277E-01],
	[1.0745000000E+04, 4.1900359202E+00, 5.7332876022E+00, 1.8996018746E-01, 1.7613875110E-01, 5.5039147711E-01],
	[1.0750000000E+04, 4.1926045627E+00, 5.7326014448E+00, 1.9023372272E-01, 1.7637780432E-01, 5.5054263189E-01],
	[1.0755000000E+04, 4.1951735843E+00, 5.7319156886E+00, 1.9050752402E-01, 1.7661705323E-01, 5.5069375711E-01],
	[1.0760000000E+04, 4.1977429849E+00, 5.7312303331E+00, 1.9078159151E-01, 1.7685649786E-01, 5.5084485280E-01],
	[1.0765000000E+04, 4.2003158113E+00, 5.7305525027E+00, 1.9105592532E-01, 1.7709615046E-01, 5.5099591897E-01],
	[1.0770000000E+04, 4.2028908267E+00, 5.7298792913E+00, 1.9133052558E-01, 1.7733600613E-01, 5.5114695562E-01],
	[1.0775000000E+04, 4.2054662244E+00, 5.7292064713E+00, 1.9160539243E-01, 1.7757605768E-01, 5.5129796277E-01],
	[1.0780000000E+04, 4.2080420043E+00, 5.7285340425E+00, 1.9188052600E-01, 1.7781630513E-01, 5.5144894043E-01],
	[1.0785000000E+04, 4.2106181663E+00, 5.7278620044E+00, 1.9215592643E-01, 1.7805674850E-01, 5.5159988861E-01],
	[1.0790000000E+04, 4.2131947102E+00, 5.7271903565E+00, 1.9243159384E-01, 1.7829738782E-01, 5.5175080733E-01],
	[1.0795000000E+04, 4.2157716361E+00, 5.7265190985E+00, 1.9270752838E-01, 1.7853822311E-01, 5.5190169660E-01],
	[1.0800000000E+04, 4.2183489436E+00, 5.7258482300E+00, 1.9298373018E-01, 1.7877925439E-01, 5.5205255643E-01],
	[1.0805000000E+04, 4.2209266328E+00, 5.7251777505E+00, 1.9326019938E-01, 1.7902048169E-01, 5.5220338683E-01],
	[1.0810000000E+04, 4.2235047035E+00, 5.7245076596E+00, 1.9353693610E-01, 1.7926190503E-01, 5.5235418782E-01],
	[1.0815000000E+04, 4.2260831556E+00, 5.7238379570E+00, 1.9381394048E-01, 1.7950352443E-01, 5.5250495940E-01],
	[1.0820000000E+04, 4.2286619889E+00, 5.7231686423E+00, 1.9409121266E-01, 1.7974533992E-01, 5.5265570160E-01],
	[1.0825000000E+04, 4.2312412034E+00, 5.7224997150E+00, 1.9436875278E-01, 1.7998735151E-01, 5.5280641441E-01],
	[1.0830000000E+04, 4.2338207989E+00, 5.7218311747E+00, 1.9464656095E-01, 1.8022955924E-01, 5.5295709786E-01],
	[1.0835000000E+04, 4.2364007753E+00, 5.7211630210E+00, 1.9492463733E-01, 1.8047196312E-01, 5.5310775196E-01],
	[1.0840000000E+04, 4.2389811324E+00, 5.7204952536E+00, 1.9520298204E-01, 1.8071456317E-01, 5.5325837672E-01],
	[1.0845000000E+04, 4.2415618703E+00, 5.7198278720E+00, 1.9548159523E-01, 1.8095735943E-01, 5.5340897214E-01],
	[1.0850000000E+04, 4.2441429886E+00, 5.7191608758E+00, 1.9576047701E-01, 1.8120035190E-01, 5.5355953826E-01],
	[1.0855000000E+04, 4.2467244874E+00, 5.7184942646E+00, 1.9603962754E-01, 1.8144354062E-01, 5.5371007507E-01],
	[1.0860000000E+04, 4.2493063665E+00, 5.7178280381E+00, 1.9631904693E-01, 1.8168692560E-01, 5.5386058259E-01],
	[1.0865000000E+04, 4.2518886258E+00, 5.7171621958E+00, 1.9659873534E-01, 1.8193050686E-01, 5.5401106083E-01],
	[1.0870000000E+04, 4.2544712651E+00, 5.7164967374E+00, 1.9687869288E-01, 1.8217428444E-01, 5.5416150980E-01],
	[1.0875000000E+04, 4.2570542844E+00, 5.7158316623E+00, 1.9715891970E-01, 1.8241825834E-01, 5.5431192953E-01],
	[1.0880000000E+04, 4.2596376835E+00, 5.7151669703E+00, 1.9743941593E-01, 1.8266242860E-01, 5.5446232001E-01],
	[1.0885000000E+04, 4.2622214623E+00, 5.7145026610E+00, 1.9772018171E-01, 1.8290679523E-01, 5.5461268127E-01],
	[1.0890000000E+04, 4.2648056207E+00, 5.7138387338E+00, 1.9800121716E-01, 1.8315135825E-01, 5.5476301331E-01],
	[1.0895000000E+04, 4.2673901586E+00, 5.7131751886E+00, 1.9828252243E-01, 1.8339611769E-01, 5.5491331614E-01],
	[1.0900000000E+04, 4.2699750758E+00, 5.7125120248E+00, 1.9856409765E-01, 1.8364107356E-01, 5.5506358979E-01],
	[1.0905000000E+04, 4.2725603723E+00, 5.7118492420E+00, 1.9884594295E-01, 1.8388622589E-01, 5.5521383426E-01],
	[1.0910000000E+04, 4.2751460479E+00, 5.7111868399E+00, 1.9912805846E-01, 1.8413157470E-01, 5.5536404957E-01],
	[1.0915000000E+04, 4.2777321025E+00, 5.7105248181E+00, 1.9941044433E-01, 1.8437712001E-01, 5.5551423573E-01],
	[1.0920000000E+04, 4.2803185359E+00, 5.7098631761E+00, 1.9969310069E-01, 1.8462286184E-01, 5.5566439274E-01],
	[1.0925000000E+04, 4.2829053481E+00, 5.7092019137E+00, 1.9997602766E-01, 1.8486880021E-01, 5.5581452063E-01],
	[1.0930000000E+04, 4.2854925390E+00, 5.7085410303E+00, 2.0025922540E-01, 1.8511493514E-01, 5.5596461941E-01],
	[1.0935000000E+04, 4.2880801084E+00, 5.7078805257E+00, 2.0054269402E-01, 1.8536126665E-01, 5.5611468909E-01],
	[1.0940000000E+04, 4.2906728986E+00, 5.7072310963E+00, 2.0082643367E-01, 1.8560781513E-01, 5.5626472968E-01],
	[1.0945000000E+04, 4.2932661825E+00, 5.7065822841E+00, 2.0111044447E-01, 1.8585456080E-01, 5.5641474119E-01],
	[1.0950000000E+04, 4.2958598482E+00, 5.7059338420E+00, 2.0139472657E-01, 1.8610150321E-01, 5.5656472364E-01],
	[1.0955000000E+04, 4.2984538958E+00, 5.7052857696E+00, 2.0167928010E-01, 1.8634864236E-01, 5.5671467705E-01],
	[1.0960000000E+04, 4.3010483250E+00, 5.7046380664E+00, 2.0196410519E-01, 1.8659597830E-01, 5.5686460141E-01],
	[1.0965000000E+04, 4.3036431357E+00, 5.7039907322E+00, 2.0224920198E-01, 1.8684351102E-01, 5.5701449676E-01],
	[1.0970000000E+04, 4.3062383279E+00, 5.7033437664E+00, 2.0253457060E-01, 1.8709124056E-01, 5.5716436309E-01],
	[1.0975000000E+04, 4.3088339013E+00, 5.7026971688E+00, 2.0282021118E-01, 1.8733916693E-01, 5.5731420042E-01],
	[1.0980000000E+04, 4.3114298560E+00, 5.7020509390E+00, 2.0310612387E-01, 1.8758729016E-01, 5.5746400877E-01],
	[1.0985000000E+04, 4.3140261917E+00, 5.7014050765E+00, 2.0339230879E-01, 1.8783561026E-01, 5.5761378815E-01],
	[1.0990000000E+04, 4.3166229083E+00, 5.7007595811E+00, 2.0367876608E-01, 1.8808412725E-01, 5.5776353857E-01],
	[1.0995000000E+04, 4.3192200058E+00, 5.7001144523E+00, 2.0396549588E-01, 1.8833284115E-01, 5.5791326005E-01],
	[1.1000000000E+04, 4.3218174840E+00, 5.6994696898E+00, 2.0425249832E-01, 1.8858175199E-01, 5.5806295259E-01],
	[1.1005000000E+04, 4.3244153427E+00, 5.6988252931E+00, 2.0453977353E-01, 1.8883085977E-01, 5.5821261621E-01],
	[1.1010000000E+04, 4.3270135820E+00, 5.6981812620E+00, 2.0482732165E-01, 1.8908016452E-01, 5.5836225093E-01],
	[1.1015000000E+04, 4.3296122016E+00, 5.6975375960E+00, 2.0511514281E-01, 1.8932966625E-01, 5.5851185675E-01],
	[1.1020000000E+04, 4.3322112015E+00, 5.6968942948E+00, 2.0540323715E-01, 1.8957936500E-01, 5.5866143369E-01],
	[1.1025000000E+04, 4.3348105815E+00, 5.6962513580E+00, 2.0569160481E-01, 1.8982926076E-01, 5.5881098177E-01],
	[1.1030000000E+04, 4.3374103415E+00, 5.6956087852E+00, 2.0598024591E-01, 1.9007935357E-01, 5.5896050099E-01],
	[1.1035000000E+04, 4.3400104813E+00, 5.6949665761E+00, 2.0626916059E-01, 1.9032964344E-01, 5.5910999136E-01],
	[1.1040000000E+04, 4.3426110010E+00, 5.6943247302E+00, 2.0655834899E-01, 1.9058013039E-01, 5.5925945292E-01],
	[1.1045000000E+04, 4.3452119003E+00, 5.6936832473E+00, 2.0684781124E-01, 1.9083081444E-01, 5.5940888565E-01],
	[1.1050000000E+04, 4.3478131792E+00, 5.6930421269E+00, 2.0713754747E-01, 1.9108169560E-01, 5.5955828959E-01],
	[1.1055000000E+04, 4.3504148375E+00, 5.6924013687E+00, 2.0742755783E-01, 1.9133277389E-01, 5.5970766473E-01],
	[1.1060000000E+04, 4.3530168751E+00, 5.6917609723E+00, 2.0771784244E-01, 1.9158404934E-01, 5.5985701110E-01],
	[1.1065000000E+04, 4.3556192919E+00, 5.6911209373E+00, 2.0800840144E-01, 1.9183552195E-01, 5.6000632871E-01],
	[1.1070000000E+04, 4.3582220878E+00, 5.6904812634E+00, 2.0829923496E-01, 1.9208719175E-01, 5.6015561757E-01],
	[1.1075000000E+04, 4.3608252626E+00, 5.6898419502E+00, 2.0859034314E-01, 1.9233905875E-01, 5.6030487769E-01],
	[1.1080000000E+04, 4.3634288163E+00, 5.6892029974E+00, 2.0888172612E-01, 1.9259112297E-01, 5.6045410909E-01],
	[1.1085000000E+04, 4.3660327487E+00, 5.6885644045E+00, 2.0917338403E-01, 1.9284338444E-01, 5.6060331179E-01],
	[1.1090000000E+04, 4.3686370597E+00, 5.6879261713E+00, 2.0946531699E-01, 1.9309584315E-01, 5.6075248578E-01],
	[1.1095000000E+04, 4.3712417492E+00, 5.6872882973E+00, 2.0975752516E-01, 1.9334849914E-01, 5.6090163110E-01],
	[1.1100000000E+04, 4.3738468171E+00, 5.6866507821E+00, 2.1005000866E-01, 1.9360135242E-01, 5.6105074774E-01],
	[1.1105000000E+04, 4.3764522633E+00, 5.6860136255E+00, 2.1034276762E-01, 1.9385440300E-01, 5.6119983573E-01],
	[1.1110000000E+04, 4.3790580876E+00, 5.6853768271E+00, 2.1063580219E-01, 1.9410765090E-01, 5.6134889508E-01],
	[1.1115000000E+04, 4.3816681786E+00, 5.6847485043E+00, 2.1092911249E-01, 1.9436111329E-01, 5.6149792580E-01],
	[1.1120000000E+04, 4.3842798164E+00, 5.6841229662E+00, 2.1122269867E-01, 1.9461477825E-01, 5.6164692790E-01],
	[1.1125000000E+04, 4.3868918358E+00, 5.6834977781E+00, 2.1151656085E-01, 1.9486864068E-01, 5.6179590140E-01],
	[1.1130000000E+04, 4.3895042367E+00, 5.6828729397E+00, 2.1181069917E-01, 1.9512270060E-01, 5.6194484631E-01],
	[1.1135000000E+04, 4.3921170188E+00, 5.6822484505E+00, 2.1210511376E-01, 1.9537695802E-01, 5.6209376265E-01],
	[1.1140000000E+04, 4.3947301822E+00, 5.6816243103E+00, 2.1239980477E-01, 1.9563141296E-01, 5.6224265042E-01],
	[1.1145000000E+04, 4.3973437266E+00, 5.6810005186E+00, 2.1269477232E-01, 1.9588606543E-01, 5.6239150965E-01],
	[1.1150000000E+04, 4.3999576520E+00, 5.6803770752E+00, 2.1299001655E-01, 1.9614091545E-01, 5.6254034034E-01],
	[1.1155000000E+04, 4.4025719583E+00, 5.6797539796E+00, 2.1328553760E-01, 1.9639596304E-01, 5.6268914251E-01],
	[1.1160000000E+04, 4.4051866453E+00, 5.6791312316E+00, 2.1358133559E-01, 1.9665120821E-01, 5.6283791617E-01],
	[1.1165000000E+04, 4.4078017130E+00, 5.6785088308E+00, 2.1387741067E-01, 1.9690665098E-01, 5.6298666134E-01],
	[1.1170000000E+04, 4.4104171611E+00, 5.6778867768E+00, 2.1417376296E-01, 1.9716229135E-01, 5.6313537802E-01],
	[1.1175000000E+04, 4.4130329897E+00, 5.6772650693E+00, 2.1447039261E-01, 1.9741812936E-01, 5.6328406621E-01],
	[1.1180000000E+04, 4.4156491985E+00, 5.6766437079E+00, 2.1476729975E-01, 1.9767416501E-01, 5.6343272591E-01],
	[1.1185000000E+04, 4.4182657875E+00, 5.6760226923E+00, 2.1506604030E-01, 1.9793171609E-01, 5.6358135712E-01],
	[1.1190000000E+04, 4.4208827566E+00, 5.6754020221E+00, 2.1536516159E-01, 1.9818955159E-01, 5.6372995985E-01],
	[1.1195000000E+04, 4.4235001056E+00, 5.6747816971E+00, 2.1566456456E-01, 1.9844758749E-01, 5.6387853410E-01],
	[1.1200000000E+04, 4.4261178344E+00, 5.6741617168E+00, 2.1596424936E-01, 1.9870582381E-01, 5.6402707987E-01],
	[1.1205000000E+04, 4.4287359429E+00, 5.6735420809E+00, 2.1626421611E-01, 1.9896426057E-01, 5.6417559718E-01],
	[1.1210000000E+04, 4.4313544310E+00, 5.6729227890E+00, 2.1656446496E-01, 1.9922289778E-01, 5.6432408601E-01],
	[1.1215000000E+04, 4.4339732986E+00, 5.6723038409E+00, 2.1686499604E-01, 1.9948173546E-01, 5.6447254639E-01],
	[1.1220000000E+04, 4.4365925456E+00, 5.6716852361E+00, 2.1716580951E-01, 1.9974077362E-01, 5.6462097830E-01],
	[1.1225000000E+04, 4.4392121718E+00, 5.6710669744E+00, 2.1746690548E-01, 2.0000001228E-01, 5.6476938176E-01],
	[1.1230000000E+04, 4.4418321771E+00, 5.6704490553E+00, 2.1776828411E-01, 2.0025945146E-01, 5.6491775676E-01],
	[1.1235000000E+04, 4.4444525615E+00, 5.6698314786E+00, 2.1806994553E-01, 2.0051909116E-01, 5.6506610332E-01],
	[1.1240000000E+04, 4.4470733248E+00, 5.6692142439E+00, 2.1837188988E-01, 2.0077893141E-01, 5.6521442144E-01],
	[1.1245000000E+04, 4.4496944669E+00, 5.6685973509E+00, 2.1867411730E-01, 2.0103897222E-01, 5.6536271111E-01],
	[1.1250000000E+04, 4.4523159876E+00, 5.6679807991E+00, 2.1897662793E-01, 2.0129921361E-01, 5.6551097235E-01],
	[1.1255000000E+04, 4.4549378869E+00, 5.6673645884E+00, 2.1927942190E-01, 2.0155965558E-01, 5.6565920516E-01],
	[1.1260000000E+04, 4.4575601647E+00, 5.6667487183E+00, 2.1958249936E-01, 2.0182029816E-01, 5.6580740954E-01],
	[1.1265000000E+04, 4.4601828209E+00, 5.6661331884E+00, 2.1988586044E-01, 2.0208114135E-01, 5.6595558550E-01],
	[1.1270000000E+04, 4.4628058552E+00, 5.6655179986E+00, 2.2018950529E-01, 2.0234218518E-01, 5.6610373304E-01],
	[1.1275000000E+04, 4.4654292677E+00, 5.6649031483E+00, 2.2049343403E-01, 2.0260342965E-01, 5.6625185216E-01],
	[1.1280000000E+04, 4.4680530581E+00, 5.6642886374E+00, 2.2079764682E-01, 2.0286487479E-01, 5.6639994287E-01],
	[1.1285000000E+04, 4.4706772265E+00, 5.6636744654E+00, 2.2110214378E-01, 2.0312652061E-01, 5.6654800518E-01],
	[1.1290000000E+04, 4.4733017726E+00, 5.6630606320E+00, 2.2140692507E-01, 2.0338836711E-01, 5.6669603908E-01],
	[1.1295000000E+04, 4.4759318242E+00, 5.6624572502E+00, 2.2171199080E-01, 2.0365043801E-01, 5.6684404459E-01],
	[1.1300000000E+04, 4.4785622857E+00, 5.6618542559E+00, 2.2201734113E-01, 2.0391270987E-01, 5.6699202170E-01],
	[1.1305000000E+04, 4.4811931283E+00, 5.6612515925E+00, 2.2232297620E-01, 2.0417518255E-01, 5.6713997042E-01],
	[1.1310000000E+04, 4.4838243520E+00, 5.6606492597E+00, 2.2262889614E-01, 2.0443785609E-01, 5.6728789076E-01],
	[1.1315000000E+04, 4.4864559567E+00, 5.6600472571E+00, 2.2293510109E-01, 2.0470073049E-01, 5.6743578271E-01],
	[1.1320000000E+04, 4.4890879422E+00, 5.6594455845E+00, 2.2324159119E-01, 2.0496380576E-01, 5.6758364629E-01],
	[1.1325000000E+04, 4.4917203085E+00, 5.6588442415E+00, 2.2354836657E-01, 2.0522708192E-01, 5.6773148150E-01],
	[1.1330000000E+04, 4.4943530555E+00, 5.6582432278E+00, 2.2385542739E-01, 2.0549055898E-01, 5.6787928834E-01],
	[1.1335000000E+04, 4.4969861830E+00, 5.6576425430E+00, 2.2416277377E-01, 2.0575423695E-01, 5.6802706682E-01],
	[1.1340000000E+04, 4.4996196909E+00, 5.6570421869E+00, 2.2447040586E-01, 2.0601811586E-01, 5.6817481694E-01],
	[1.1345000000E+04, 4.5022535790E+00, 5.6564421591E+00, 2.2477832379E-01, 2.0628219570E-01, 5.6832253870E-01],
	[1.1350000000E+04, 4.5048878474E+00, 5.6558424593E+00, 2.2508652770E-01, 2.0654647650E-01, 5.6847023212E-01],
	[1.1355000000E+04, 4.5075224959E+00, 5.6552430872E+00, 2.2539501773E-01, 2.0681095826E-01, 5.6861789719E-01],
	[1.1360000000E+04, 4.5101575243E+00, 5.6546440424E+00, 2.2570379403E-01, 2.0707564101E-01, 5.6876553392E-01],
	[1.1365000000E+04, 4.5127929326E+00, 5.6540453246E+00, 2.2601285672E-01, 2.0734052474E-01, 5.6891314231E-01],
	[1.1370000000E+04, 4.5154287206E+00, 5.6534469335E+00, 2.2632220596E-01, 2.0760560948E-01, 5.6906072237E-01],
	[1.1375000000E+04, 4.5180648883E+00, 5.6528488688E+00, 2.2663184186E-01, 2.0787089523E-01, 5.6920827411E-01],
	[1.1380000000E+04, 4.5207014354E+00, 5.6522511302E+00, 2.2694176459E-01, 2.0813638201E-01, 5.6935579752E-01],
	[1.1385000000E+04, 4.5233383620E+00, 5.6516537173E+00, 2.2725197427E-01, 2.0840206984E-01, 5.6950329262E-01],
	[1.1390000000E+04, 4.5259756678E+00, 5.6510566298E+00, 2.2756247104E-01, 2.0866795871E-01, 5.6965075940E-01],
	[1.1395000000E+04, 4.5286133529E+00, 5.6504598673E+00, 2.2787325504E-01, 2.0893404865E-01, 5.6979819787E-01],
	[1.1400000000E+04, 4.5312514170E+00, 5.6498634297E+00, 2.2818432642E-01, 2.0920033966E-01, 5.6994560805E-01],
	[1.1405000000E+04, 4.5338898600E+00, 5.6492673165E+00, 2.2849568530E-01, 2.0946683176E-01, 5.7009298992E-01],
	[1.1410000000E+04, 4.5365286819E+00, 5.6486715275E+00, 2.2880733184E-01, 2.0973352496E-01, 5.7024034350E-01],
	[1.1415000000E+04, 4.5391678826E+00, 5.6480760622E+00, 2.2911926616E-01, 2.1000041927E-01, 5.7038766879E-01],
	[1.1420000000E+04, 4.5418074618E+00, 5.6474809205E+00, 2.2943148841E-01, 2.1026751470E-01, 5.7053496580E-01],
	[1.1425000000E+04, 4.5444474196E+00, 5.6468861020E+00, 2.2974399872E-01, 2.1053481127E-01, 5.7068223453E-01],
	[1.1430000000E+04, 4.5470877557E+00, 5.6462916063E+00, 2.3005679724E-01, 2.1080230897E-01, 5.7082947498E-01],
	[1.1435000000E+04, 4.5497284702E+00, 5.6456974331E+00, 2.3036988410E-01, 2.1107000783E-01, 5.7097668716E-01],
	[1.1440000000E+04, 4.5523695628E+00, 5.6451035822E+00, 2.3068325944E-01, 2.1133790786E-01, 5.7112387108E-01],
	[1.1445000000E+04, 4.5550110335E+00, 5.6445100532E+00, 2.3099692341E-01, 2.1160600906E-01, 5.7127102674E-01],
	[1.1450000000E+04, 4.5576528821E+00, 5.6439168459E+00, 2.3131087613E-01, 2.1187431144E-01, 5.7141815415E-01],
	[1.1455000000E+04, 4.5602951086E+00, 5.6433239598E+00, 2.3162511775E-01, 2.1214281503E-01, 5.7156525331E-01],
	[1.1460000000E+04, 4.5629377128E+00, 5.6427313946E+00, 2.3193964841E-01, 2.1241151982E-01, 5.7171232422E-01],
	[1.1465000000E+04, 4.5655806946E+00, 5.6421391502E+00, 2.3225446825E-01, 2.1268042582E-01, 5.7185936689E-01],
	[1.1470000000E+04, 4.5682240539E+00, 5.6415472261E+00, 2.3256957740E-01, 2.1294953306E-01, 5.7200638133E-01],
	[1.1475000000E+04, 4.5708711753E+00, 5.6409619306E+00, 2.3288497601E-01, 2.1321885791E-01, 5.7215336754E-01],
	[1.1480000000E+04, 4.5735205509E+00, 5.6403804421E+00, 2.3320066421E-01, 2.1348839316E-01, 5.7230032552E-01],
	[1.1485000000E+04, 4.5761703074E+00, 5.6397992668E+00, 2.3351664215E-01, 2.1375812977E-01, 5.7244725528E-01],
	[1.1490000000E+04, 4.5788204448E+00, 5.6392184042E+00, 2.3383290995E-01, 2.1402806776E-01, 5.7259415684E-01],
	[1.1495000000E+04, 4.5814709629E+00, 5.6386378542E+00, 2.3414946777E-01, 2.1429820713E-01, 5.7274103018E-01],
	[1.1500000000E+04, 4.5841218617E+00, 5.6380576163E+00, 2.3446631574E-01, 2.1456854790E-01, 5.7288787531E-01],
	[1.1505000000E+04, 4.5867731410E+00, 5.6374776904E+00, 2.3478345399E-01, 2.1483909006E-01, 5.7303469225E-01],
	[1.1510000000E+04, 4.5894248007E+00, 5.6368980760E+00, 2.3510088267E-01, 2.1510983364E-01, 5.7318148100E-01],
	[1.1515000000E+04, 4.5920768407E+00, 5.6363187729E+00, 2.3541860192E-01, 2.1538077864E-01, 5.7332824156E-01],
	[1.1520000000E+04, 4.5947292610E+00, 5.6357397808E+00, 2.3573661187E-01, 2.1565192507E-01, 5.7347497393E-01],
	[1.1525000000E+04, 4.5973820613E+00, 5.6351610994E+00, 2.3605491267E-01, 2.1592327294E-01, 5.7362167813E-01],
	[1.1530000000E+04, 4.6000352416E+00, 5.6345827284E+00, 2.3637350445E-01, 2.1619482226E-01, 5.7376835415E-01],
	[1.1535000000E+04, 4.6026888018E+00, 5.6340046674E+00, 2.3669238736E-01, 2.1646657304E-01, 5.7391500201E-01],
	[1.1540000000E+04, 4.6053427417E+00, 5.6334269162E+00, 2.3701156152E-01, 2.1673852528E-01, 5.7406162171E-01],
	[1.1545000000E+04, 4.6079970613E+00, 5.6328494745E+00, 2.3733102709E-01, 2.1701067899E-01, 5.7420821325E-01],
	[1.1550000000E+04, 4.6106517604E+00, 5.6322723420E+00, 2.3765078420E-01, 2.1728303419E-01, 5.7435477664E-01],
	[1.1555000000E+04, 4.6133068389E+00, 5.6316955184E+00, 2.3797083298E-01, 2.1755559088E-01, 5.7450131188E-01],
	[1.1560000000E+04, 4.6159622967E+00, 5.6311190033E+00, 2.3829117358E-01, 2.1782834907E-01, 5.7464781899E-01],
	[1.1565000000E+04, 4.6186181338E+00, 5.6305427966E+00, 2.3861180614E-01, 2.1810130877E-01, 5.7479429795E-01],
	[1.1570000000E+04, 4.6212743499E+00, 5.6299668978E+00, 2.3893273079E-01, 2.1837446998E-01, 5.7494074879E-01],
	[1.1575000000E+04, 4.6239309451E+00, 5.6293913067E+00, 2.3925394768E-01, 2.1864783271E-01, 5.7508717151E-01],
	[1.1580000000E+04, 4.6265879191E+00, 5.6288160230E+00, 2.3957545694E-01, 2.1892139698E-01, 5.7523356611E-01],
	[1.1585000000E+04, 4.6292452719E+00, 5.6282410463E+00, 2.3989725872E-01, 2.1919516279E-01, 5.7537993259E-01],
	[1.1590000000E+04, 4.6319030033E+00, 5.6276663765E+00, 2.4021935315E-01, 2.1946913014E-01, 5.7552627097E-01],
	[1.1595000000E+04, 4.6345611133E+00, 5.6270920132E+00, 2.4054174037E-01, 2.1974329904E-01, 5.7567258125E-01],
	[1.1600000000E+04, 4.6372196017E+00, 5.6265179561E+00, 2.4086442051E-01, 2.2001766951E-01, 5.7581886343E-01],
	[1.1605000000E+04, 4.6398784685E+00, 5.6259442049E+00, 2.4118739373E-01, 2.2029224154E-01, 5.7596511752E-01],
	[1.1610000000E+04, 4.6425377134E+00, 5.6253707593E+00, 2.4151066016E-01, 2.2056701515E-01, 5.7611134353E-01],
	[1.1615000000E+04, 4.6451973365E+00, 5.6247976191E+00, 2.4183421993E-01, 2.2084199034E-01, 5.7625754145E-01],
	[1.1620000000E+04, 4.6478573376E+00, 5.6242247838E+00, 2.4215807319E-01, 2.2111716712E-01, 5.7640371131E-01],
	[1.1625000000E+04, 4.6505177166E+00, 5.6236522533E+00, 2.4248222008E-01, 2.2139254549E-01, 5.7654985309E-01],
	[1.1630000000E+04, 4.6531784734E+00, 5.6230800273E+00, 2.4280666073E-01, 2.2166812547E-01, 5.7669596682E-01],
	[1.1635000000E+04, 4.6558396078E+00, 5.6225081054E+00, 2.4313139528E-01, 2.2194390705E-01, 5.7684205248E-01],
	[1.1640000000E+04, 4.6585011198E+00, 5.6219364873E+00, 2.4345642388E-01, 2.2221989025E-01, 5.7698811010E-01],
	[1.1645000000E+04, 4.6611630093E+00, 5.6213651728E+00, 2.4378174666E-01, 2.2249607507E-01, 5.7713413967E-01],
	[1.1650000000E+04, 4.6638252761E+00, 5.6207941616E+00, 2.4410736376E-01, 2.2277246152E-01, 5.7728014120E-01],
	[1.1655000000E+04, 4.6664879201E+00, 5.6202234534E+00, 2.4443327532E-01, 2.2304904960E-01, 5.7742611470E-01],
	[1.1660000000E+04, 4.6691547361E+00, 5.6196597298E+00, 2.4475948148E-01, 2.2332585856E-01, 5.7757206018E-01],
	[1.1665000000E+04, 4.6718235000E+00, 5.6190990640E+00, 2.4508598238E-01, 2.2360287720E-01, 5.7771797763E-01],
	[1.1670000000E+04, 4.6744926447E+00, 5.6185386944E+00, 2.4541277816E-01, 2.2388009760E-01, 5.7786386706E-01],
	[1.1675000000E+04, 4.6771621700E+00, 5.6179786207E+00, 2.4573986895E-01, 2.2415751978E-01, 5.7800972846E-01],
	[1.1680000000E+04, 4.6798320758E+00, 5.6174188426E+00, 2.4606725490E-01, 2.2443514372E-01, 5.7815556185E-01],
	[1.1685000000E+04, 4.6825023621E+00, 5.6168593598E+00, 2.4639493615E-01, 2.2471296945E-01, 5.7830136720E-01],
	[1.1690000000E+04, 4.6851730286E+00, 5.6163001721E+00, 2.4672291283E-01, 2.2499099696E-01, 5.7844714453E-01],
	[1.1695000000E+04, 4.6878440753E+00, 5.6157412791E+00, 2.4705118508E-01, 2.2526922626E-01, 5.7859289382E-01],
	[1.1700000000E+04, 4.6905155022E+00, 5.6151826806E+00, 2.4737975305E-01, 2.2554765736E-01, 5.7873861508E-01],
	[1.1705000000E+04, 4.6931873090E+00, 5.6146243763E+00, 2.4770861687E-01, 2.2582629026E-01, 5.7888430830E-01],
	[1.1710000000E+04, 4.6958594956E+00, 5.6140663659E+00, 2.4803777668E-01, 2.2610512497E-01, 5.7902997348E-01],
	[1.1715000000E+04, 4.6985320621E+00, 5.6135086491E+00, 2.4836723262E-01, 2.2638416148E-01, 5.7917561061E-01],
	[1.1720000000E+04, 4.7012050082E+00, 5.6129512257E+00, 2.4869698483E-01, 2.2666339981E-01, 5.7932121970E-01],
	[1.1725000000E+04, 4.7038783338E+00, 5.6123940954E+00, 2.4902703345E-01, 2.2694283997E-01, 5.7946680075E-01],
	[1.1730000000E+04, 4.7065520389E+00, 5.6118372578E+00, 2.4935737862E-01, 2.2722248194E-01, 5.7961235374E-01],
	[1.1735000000E+04, 4.7092261233E+00, 5.6112807128E+00, 2.4968802048E-01, 2.2750232575E-01, 5.7975787868E-01],
	[1.1740000000E+04, 4.7119005869E+00, 5.6107244600E+00, 2.5001895916E-01, 2.2778237138E-01, 5.7990337557E-01],
	[1.1745000000E+04, 4.7145754297E+00, 5.6101684992E+00, 2.5035019481E-01, 2.2806261886E-01, 5.8004884439E-01],
	[1.1750000000E+04, 4.7172506514E+00, 5.6096128300E+00, 2.5068172756E-01, 2.2834306818E-01, 5.8019428516E-01],
	[1.1755000000E+04, 4.7199262521E+00, 5.6090574523E+00, 2.5101355756E-01, 2.2862371934E-01, 5.8033969787E-01],
	[1.1760000000E+04, 4.7226022315E+00, 5.6085023657E+00, 2.5134568494E-01, 2.2890457235E-01, 5.8048508251E-01],
	[1.1765000000E+04, 4.7252785896E+00, 5.6079475699E+00, 2.5167810985E-01, 2.2918562722E-01, 5.8063043909E-01],
	[1.1770000000E+04, 4.7279553263E+00, 5.6073930648E+00, 2.5201083241E-01, 2.2946688394E-01, 5.8077576759E-01],
	[1.1775000000E+04, 4.7306324415E+00, 5.6068388499E+00, 2.5234385278E-01, 2.2974834252E-01, 5.8092106803E-01],
	[1.1780000000E+04, 4.7333099351E+00, 5.6062849251E+00, 2.5267717109E-01, 2.3003000296E-01, 5.8106634039E-01],
	[1.1785000000E+04, 4.7359878068E+00, 5.6057312900E+00, 2.5301078748E-01, 2.3031186527E-01, 5.8121158468E-01],
	[1.1790000000E+04, 4.7386660568E+00, 5.6051779444E+00, 2.5334470209E-01, 2.3059392945E-01, 5.8135680089E-01],
	[1.1795000000E+04, 4.7413446848E+00, 5.6046248879E+00, 2.5367891506E-01, 2.3087619550E-01, 5.8150198903E-01],
	[1.1800000000E+04, 4.7440236907E+00, 5.6040721205E+00, 2.5401342652E-01, 2.3115866343E-01, 5.8164714908E-01],
	[1.1805000000E+04, 4.7467030744E+00, 5.6035196416E+00, 2.5434823662E-01, 2.3144133323E-01, 5.8179228105E-01],
	[1.1810000000E+04, 4.7493828359E+00, 5.6029674512E+00, 2.5468334550E-01, 2.3172420492E-01, 5.8193738493E-01],
	[1.1815000000E+04, 4.7520629750E+00, 5.6024155489E+00, 2.5501875330E-01, 2.3200727848E-01, 5.8208246073E-01],
	[1.1820000000E+04, 4.7547434915E+00, 5.6018639344E+00, 2.5535446015E-01, 2.3229055394E-01, 5.8222750844E-01],
	[1.1825000000E+04, 4.7574243855E+00, 5.6013126075E+00, 2.5569046619E-01, 2.3257403128E-01, 5.8237252806E-01],
	[1.1830000000E+04, 4.7601056568E+00, 5.6007615679E+00, 2.5602677157E-01, 2.3285771051E-01, 5.8251751958E-01],
	[1.1835000000E+04, 4.7627873053E+00, 5.6002108153E+00, 2.5636337642E-01, 2.3314159163E-01, 5.8266248301E-01],
	[1.1840000000E+04, 4.7654693308E+00, 5.5996603494E+00, 2.5670028089E-01, 2.3342567465E-01, 5.8280741835E-01],
	[1.1845000000E+04, 4.7681527010E+00, 5.5991117803E+00, 2.5703748510E-01, 2.3370996469E-01, 5.8295232558E-01],
	[1.1850000000E+04, 4.7708409492E+00, 5.5985709802E+00, 2.5737498921E-01, 2.3399448055E-01, 5.8309720472E-01],
	[1.1855000000E+04, 4.7735295781E+00, 5.5980304605E+00, 2.5771279335E-01, 2.3427919843E-01, 5.8324205576E-01],
	[1.1860000000E+04, 4.7762185874E+00, 5.5974902208E+00, 2.5805089766E-01, 2.3456411832E-01, 5.8338687869E-01],
	[1.1865000000E+04, 4.7789079771E+00, 5.5969502609E+00, 2.5838930227E-01, 2.3484924024E-01, 5.8353167352E-01],
	[1.1870000000E+04, 4.7815977471E+00, 5.5964105806E+00, 2.5872800734E-01, 2.3513456417E-01, 5.8367644024E-01],
	[1.1875000000E+04, 4.7842878973E+00, 5.5958711796E+00, 2.5906701299E-01, 2.3542009013E-01, 5.8382117885E-01],
	[1.1880000000E+04, 4.7869784276E+00, 5.5953320576E+00, 2.5940631937E-01, 2.3570581811E-01, 5.8396588935E-01],
	[1.1885000000E+04, 4.7896693378E+00, 5.5947932144E+00, 2.5974592662E-01, 2.3599174812E-01, 5.8411057174E-01],
	[1.1890000000E+04, 4.7923606280E+00, 5.5942546497E+00, 2.6008583488E-01, 2.3627788015E-01, 5.8425522602E-01],
	[1.1895000000E+04, 4.7950522978E+00, 5.5937163632E+00, 2.6042604428E-01, 2.3656421421E-01, 5.8439985219E-01],
	[1.1900000000E+04, 4.7977443474E+00, 5.5931783547E+00, 2.6076655496E-01, 2.3685075029E-01, 5.8454445023E-01],
	[1.1905000000E+04, 4.8004367765E+00, 5.5926406239E+00, 2.6110736707E-01, 2.3713748841E-01, 5.8468902016E-01],
	[1.1910000000E+04, 4.8031295850E+00, 5.5921031706E+00, 2.6144848075E-01, 2.3742442855E-01, 5.8483356198E-01],
	[1.1915000000E+04, 4.8058227729E+00, 5.5915659945E+00, 2.6178989612E-01, 2.3771157072E-01, 5.8497807567E-01],
	[1.1920000000E+04, 4.8085163399E+00, 5.5910290953E+00, 2.6213161334E-01, 2.3799891492E-01, 5.8512256124E-01],
	[1.1925000000E+04, 4.8112102862E+00, 5.5904924728E+00, 2.6247363254E-01, 2.3828646115E-01, 5.8526701869E-01],
	[1.1930000000E+04, 4.8139046114E+00, 5.5899561267E+00, 2.6281595387E-01, 2.3857420941E-01, 5.8541144801E-01],
	[1.1935000000E+04, 4.8165993156E+00, 5.5894200568E+00, 2.6315857745E-01, 2.3886215970E-01, 5.8555584921E-01],
	[1.1940000000E+04, 4.8192943985E+00, 5.5888842628E+00, 2.6350150344E-01, 2.3915031202E-01, 5.8570022228E-01],
	[1.1945000000E+04, 4.8219898602E+00, 5.5883487444E+00, 2.6384473196E-01, 2.3943866637E-01, 5.8584456722E-01],
	[1.1950000000E+04, 4.8246857005E+00, 5.5878135015E+00, 2.6418826317E-01, 2.3972722274E-01, 5.8598888403E-01],
	[1.1955000000E+04, 4.8273819192E+00, 5.5872785337E+00, 2.6453209719E-01, 2.4001598115E-01, 5.8613317271E-01],
	[1.1960000000E+04, 4.8300785164E+00, 5.5867438407E+00, 2.6487623417E-01, 2.4030494158E-01, 5.8627743326E-01],
	[1.1965000000E+04, 4.8327754918E+00, 5.5862094224E+00, 2.6522067425E-01, 2.4059410404E-01, 5.8642166568E-01],
	[1.1970000000E+04, 4.8354728454E+00, 5.5856752785E+00, 2.6556541757E-01, 2.4088346853E-01, 5.8656586996E-01],
	[1.1975000000E+04, 4.8381705771E+00, 5.5851414086E+00, 2.6591046426E-01, 2.4117303504E-01, 5.8671004611E-01],
	[1.1980000000E+04, 4.8408686867E+00, 5.5846078127E+00, 2.6625581447E-01, 2.4146280357E-01, 5.8685419412E-01],
	[1.1985000000E+04, 4.8435671742E+00, 5.5840744903E+00, 2.6660146834E-01, 2.4175277413E-01, 5.8699831399E-01],
	[1.1990000000E+04, 4.8462660395E+00, 5.5835414413E+00, 2.6694742600E-01, 2.4204294670E-01, 5.8714240573E-01],
	[1.1995000000E+04, 4.8489652824E+00, 5.5830086653E+00, 2.6729368760E-01, 2.4233332130E-01, 5.8728646932E-01],
	[1.2000000000E+04, 4.8516649029E+00, 5.5824761622E+00, 2.6764025327E-01, 2.4262389792E-01, 5.8743050477E-01],
	[1.2005000000E+04, 4.8543649008E+00, 5.5819439317E+00, 2.6798712315E-01, 2.4291467655E-01, 5.8757451209E-01],
	[1.2010000000E+04, 4.8570652760E+00, 5.5814119736E+00, 2.6833429739E-01, 2.4320565720E-01, 5.8771849126E-01],
	[1.2015000000E+04, 4.8597660285E+00, 5.5808802875E+00, 2.6868177612E-01, 2.4349683986E-01, 5.8786244229E-01],
	[1.2020000000E+04, 4.8624671581E+00, 5.5803488732E+00, 2.6902955948E-01, 2.4378822453E-01, 5.8800636517E-01],
	[1.2025000000E+04, 4.8651686648E+00, 5.5798177306E+00, 2.6937764762E-01, 2.4407981120E-01, 5.8815025991E-01],
	[1.2030000000E+04, 4.8678705484E+00, 5.5792868592E+00, 2.6972604066E-01, 2.4437159989E-01, 5.8829412650E-01],
	[1.2035000000E+04, 4.8705730439E+00, 5.5787566285E+00, 2.7007473876E-01, 2.4466359188E-01, 5.8843796494E-01],
	[1.2040000000E+04, 4.8732812556E+00, 5.5782350559E+00, 2.7042374205E-01, 2.4495581555E-01, 5.8858177524E-01],
	[1.2045000000E+04, 4.8759898478E+00, 5.5777137485E+00, 2.7077305067E-01, 2.4524824133E-01, 5.8872555739E-01],
	[1.2050000000E+04, 4.8786988204E+00, 5.5771927062E+00, 2.7112266476E-01, 2.4554086923E-01, 5.8886931139E-01],
	[1.2055000000E+04, 4.8814081732E+00, 5.5766719287E+00, 2.7147258445E-01, 2.4583369925E-01, 5.8901303724E-01],
	[1.2060000000E+04, 4.8841179063E+00, 5.5761514157E+00, 2.7182280990E-01, 2.4612673139E-01, 5.8915673493E-01],
	[1.2065000000E+04, 4.8868280194E+00, 5.5756311671E+00, 2.7217334124E-01, 2.4641996563E-01, 5.8930040448E-01],
	[1.2070000000E+04, 4.8895385124E+00, 5.5751111825E+00, 2.7252417860E-01, 2.4671340198E-01, 5.8944404588E-01],
	[1.2075000000E+04, 4.8922493853E+00, 5.5745914617E+00, 2.7287532213E-01, 2.4700704044E-01, 5.8958765912E-01],
	[1.2080000000E+04, 4.8949606380E+00, 5.5740720045E+00, 2.7322677197E-01, 2.4730088100E-01, 5.8973124421E-01],
	[1.2085000000E+04, 4.8976722703E+00, 5.5735528107E+00, 2.7357852825E-01, 2.4759492365E-01, 5.8987480115E-01],
	[1.2090000000E+04, 4.9003842822E+00, 5.5730338799E+00, 2.7393059112E-01, 2.4788916840E-01, 5.9001832993E-01],
	[1.2095000000E+04, 4.9030966735E+00, 5.5725152120E+00, 2.7428296072E-01, 2.4818361525E-01, 5.9016183055E-01],
	[1.2100000000E+04, 4.9058094442E+00, 5.5719968067E+00, 2.7463563718E-01, 2.4847826418E-01, 5.9030530303E-01],
	[1.2105000000E+04, 4.9085225941E+00, 5.5714786638E+00, 2.7498862065E-01, 2.4877311519E-01, 5.9044874734E-01],
	[1.2110000000E+04, 4.9112361231E+00, 5.5709607830E+00, 2.7534191126E-01, 2.4906816828E-01, 5.9059216350E-01],
	[1.2115000000E+04, 4.9139500311E+00, 5.5704431641E+00, 2.7569550916E-01, 2.4936342345E-01, 5.9073555150E-01],
	[1.2120000000E+04, 4.9166643181E+00, 5.5699258069E+00, 2.7604941448E-01, 2.4965888069E-01, 5.9087891135E-01],
	[1.2125000000E+04, 4.9193789839E+00, 5.5694087110E+00, 2.7640362737E-01, 2.4995454000E-01, 5.9102224303E-01],
	[1.2130000000E+04, 4.9220940284E+00, 5.5688918763E+00, 2.7675814796E-01, 2.5025040137E-01, 5.9116554656E-01],
	[1.2135000000E+04, 4.9248094516E+00, 5.5683753026E+00, 2.7711297639E-01, 2.5054646480E-01, 5.9130882193E-01],
	[1.2140000000E+04, 4.9275252532E+00, 5.5678589895E+00, 2.7746811280E-01, 2.5084273028E-01, 5.9145206915E-01],
	[1.2145000000E+04, 4.9302414332E+00, 5.5673429369E+00, 2.7782355734E-01, 2.5113919781E-01, 5.9159528820E-01],
	[1.2150000000E+04, 4.9329579916E+00, 5.5668271445E+00, 2.7817931014E-01, 2.5143586739E-01, 5.9173847909E-01],
	[1.2155000000E+04, 4.9356749281E+00, 5.5663116121E+00, 2.7853537134E-01, 2.5173273901E-01, 5.9188164183E-01],
	[1.2160000000E+04, 4.9383922428E+00, 5.5657963394E+00, 2.7889174109E-01, 2.5202981266E-01, 5.9202477640E-01],
	[1.2165000000E+04, 4.9411099355E+00, 5.5652813262E+00, 2.7924841951E-01, 2.5232708834E-01, 5.9216788281E-01],
	[1.2170000000E+04, 4.9438280060E+00, 5.5647665723E+00, 2.7960540676E-01, 2.5262456604E-01, 5.9231096107E-01],
	[1.2175000000E+04, 4.9465464543E+00, 5.5642520773E+00, 2.7996270296E-01, 2.5292224577E-01, 5.9245401116E-01],
	[1.2180000000E+04, 4.9492652804E+00, 5.5637378412E+00, 2.8032030827E-01, 2.5322012750E-01, 5.9259703309E-01],
	[1.2185000000E+04, 4.9519844840E+00, 5.5632238636E+00, 2.8067822281E-01, 2.5351821124E-01, 5.9274002687E-01],
	[1.2190000000E+04, 4.9547040651E+00, 5.5627101444E+00, 2.8103644674E-01, 2.5381649699E-01, 5.9288299248E-01],
	[1.2195000000E+04, 4.9574240235E+00, 5.5621966832E+00, 2.8139498019E-01, 2.5411498473E-01, 5.9302592993E-01],
	[1.2200000000E+04, 4.9601443593E+00, 5.5616834799E+00, 2.8175382329E-01, 2.5441367446E-01, 5.9316883922E-01],
	[1.2205000000E+04, 4.9628650722E+00, 5.5611705341E+00, 2.8211297619E-01, 2.5471256617E-01, 5.9331172035E-01],
	[1.2210000000E+04, 4.9655861622E+00, 5.5606578458E+00, 2.8247243903E-01, 2.5501165986E-01, 5.9345457331E-01],
	[1.2215000000E+04, 4.9683076292E+00, 5.5601454146E+00, 2.8283221195E-01, 2.5531095552E-01, 5.9359739812E-01],
	[1.2220000000E+04, 4.9710294730E+00, 5.5596332402E+00, 2.8319229509E-01, 2.5561045315E-01, 5.9374019477E-01],
	[1.2225000000E+04, 4.9737516936E+00, 5.5591213226E+00, 2.8355268859E-01, 2.5591015273E-01, 5.9388296325E-01],
	[1.2230000000E+04, 4.9764759579E+00, 5.5586121357E+00, 2.8391339258E-01, 2.5621006394E-01, 5.9402570358E-01],
	[1.2235000000E+04, 4.9792046148E+00, 5.5581091594E+00, 2.8427440721E-01, 2.5651020047E-01, 5.9416841574E-01],
	[1.2240000000E+04, 4.9819336522E+00, 5.5576064341E+00, 2.8463573262E-01, 2.5681053907E-01, 5.9431109974E-01],
	[1.2245000000E+04, 4.9846630698E+00, 5.5571039596E+00, 2.8499736895E-01, 2.5711107972E-01, 5.9445375558E-01],
	[1.2250000000E+04, 4.9873928676E+00, 5.5566017356E+00, 2.8535931633E-01, 2.5741182243E-01, 5.9459638327E-01],
	[1.2255000000E+04, 4.9901230454E+00, 5.5560997618E+00, 2.8572157491E-01, 2.5771276718E-01, 5.9473898279E-01],
	[1.2260000000E+04, 4.9928536032E+00, 5.5555980382E+00, 2.8608414482E-01, 2.5801391397E-01, 5.9488155415E-01],
	[1.2265000000E+04, 4.9955845408E+00, 5.5550965645E+00, 2.8644702621E-01, 2.5831526279E-01, 5.9502409735E-01],
	[1.2270000000E+04, 4.9983158582E+00, 5.5545953403E+00, 2.8681021922E-01, 2.5861681363E-01, 5.9516661239E-01],
	[1.2275000000E+04, 5.0010475552E+00, 5.5540943656E+00, 2.8717372398E-01, 2.5891856648E-01, 5.9530909928E-01],
	[1.2280000000E+04, 5.0037796317E+00, 5.5535936400E+00, 2.8753754063E-01, 2.5922052135E-01, 5.9545155800E-01],
	[1.2285000000E+04, 5.0065120877E+00, 5.5530931634E+00, 2.8790166933E-01, 2.5952267821E-01, 5.9559398857E-01],
	[1.2290000000E+04, 5.0092449231E+00, 5.5525929355E+00, 2.8826611019E-01, 2.5982503707E-01, 5.9573639098E-01],
	[1.2295000000E+04, 5.0119781377E+00, 5.5520929562E+00, 2.8863086337E-01, 2.6012759791E-01, 5.9587876523E-01],
	[1.2300000000E+04, 5.0147117314E+00, 5.5515932251E+00, 2.8899592901E-01, 2.6043036072E-01, 5.9602111132E-01],
	[1.2305000000E+04, 5.0174457041E+00, 5.5510937420E+00, 2.8936130724E-01, 2.6073332551E-01, 5.9616342925E-01],
	[1.2310000000E+04, 5.0201800558E+00, 5.5505945068E+00, 2.8972699821E-01, 2.6103649225E-01, 5.9630571903E-01],
	[1.2315000000E+04, 5.0229147863E+00, 5.5500955192E+00, 2.9009300205E-01, 2.6133986094E-01, 5.9644798065E-01],
	[1.2320000000E+04, 5.0256498956E+00, 5.5495967789E+00, 2.9045931890E-01, 2.6164343158E-01, 5.9659021412E-01],
	[1.2325000000E+04, 5.0283853834E+00, 5.5490982859E+00, 2.9082594891E-01, 2.6194720415E-01, 5.9673241943E-01],
	[1.2330000000E+04, 5.0311212498E+00, 5.5486000397E+00, 2.9119289221E-01, 2.6225117864E-01, 5.9687459659E-01],
	[1.2335000000E+04, 5.0338574947E+00, 5.5481020403E+00, 2.9156014894E-01, 2.6255535506E-01, 5.9701674559E-01],
	[1.2340000000E+04, 5.0365941178E+00, 5.5476042874E+00, 2.9192771925E-01, 2.6285973337E-01, 5.9715886644E-01],
	[1.2345000000E+04, 5.0393311192E+00, 5.5471067808E+00, 2.9229560327E-01, 2.6316431359E-01, 5.9730095914E-01],
	[1.2350000000E+04, 5.0420684987E+00, 5.5466095202E+00, 2.9266380115E-01, 2.6346909569E-01, 5.9744302368E-01],
	[1.2355000000E+04, 5.0448062563E+00, 5.5461125054E+00, 2.9303231301E-01, 2.6377407967E-01, 5.9758506007E-01],
	[1.2360000000E+04, 5.0475443917E+00, 5.5456157362E+00, 2.9340113902E-01, 2.6407926553E-01, 5.9772706831E-01],
	[1.2365000000E+04, 5.0502829050E+00, 5.5451192124E+00, 2.9377027929E-01, 2.6438465324E-01, 5.9786904840E-01],
	[1.2370000000E+04, 5.0530217960E+00, 5.5446229338E+00, 2.9413973397E-01, 2.6469024280E-01, 5.9801100034E-01],
	[1.2375000000E+04, 5.0557610646E+00, 5.5441269002E+00, 2.9450950321E-01, 2.6499603421E-01, 5.9815292413E-01],
	[1.2380000000E+04, 5.0585007107E+00, 5.5436311112E+00, 2.9487958714E-01, 2.6530202744E-01, 5.9829481977E-01],
	[1.2385000000E+04, 5.0612407343E+00, 5.5431355668E+00, 2.9524998591E-01, 2.6560822249E-01, 5.9843668726E-01],
	[1.2390000000E+04, 5.0639811352E+00, 5.5426402666E+00, 2.9562069964E-01, 2.6591461936E-01, 5.9857852661E-01],
	[1.2395000000E+04, 5.0667219133E+00, 5.5421452106E+00, 2.9599172849E-01, 2.6622121802E-01, 5.9872033781E-01],
	[1.2400000000E+04, 5.0694630685E+00, 5.5416503983E+00, 2.9636307259E-01, 2.6652801847E-01, 5.9886212086E-01],
	[1.2405000000E+04, 5.0722046007E+00, 5.5411558297E+00, 2.9673473209E-01, 2.6683502071E-01, 5.9900387577E-01],
	[1.2410000000E+04, 5.0749465098E+00, 5.5406615046E+00, 2.9710670711E-01, 2.6714222471E-01, 5.9914560254E-01],
	[1.2415000000E+04, 5.0776887958E+00, 5.5401674226E+00, 2.9747899781E-01, 2.6744963046E-01, 5.9928730116E-01],
	[1.2420000000E+04, 5.0804314585E+00, 5.5396735836E+00, 2.9785160432E-01, 2.6775723797E-01, 5.9942897164E-01],
	[1.2425000000E+04, 5.0831744978E+00, 5.5391799873E+00, 2.9822452678E-01, 2.6806504721E-01, 5.9957061398E-01],
	[1.2430000000E+04, 5.0859232541E+00, 5.5386941104E+00, 2.9859776533E-01, 2.6837309059E-01, 5.9971222818E-01],
	[1.2435000000E+04, 5.0886728493E+00, 5.5382091135E+00, 2.9897132012E-01, 2.6868133861E-01, 5.9985381424E-01],
	[1.2440000000E+04, 5.0914228247E+00, 5.5377243540E+00, 2.9934519127E-01, 2.6898978846E-01, 5.9999537216E-01],
	[1.2445000000E+04, 5.0941731803E+00, 5.5372398317E+00, 2.9971937894E-01, 2.6929844013E-01, 6.0013690194E-01],
	[1.2450000000E+04, 5.0969239159E+00, 5.5367555464E+00, 3.0009388326E-01, 2.6960729361E-01, 6.0027840359E-01],
	[1.2455000000E+04, 5.0996750315E+00, 5.5362714979E+00, 3.0046870437E-01, 2.6991634890E-01, 6.0041987710E-01],
	[1.2460000000E+04, 5.1024265269E+00, 5.5357876859E+00, 3.0084384241E-01, 2.7022560598E-01, 6.0056132248E-01],
	[1.2465000000E+04, 5.1051784021E+00, 5.5353041104E+00, 3.0121929753E-01, 2.7053506483E-01, 6.0070273973E-01],
	[1.2470000000E+04, 5.1079306569E+00, 5.5348207709E+00, 3.0159506986E-01, 2.7084472545E-01, 6.0084412884E-01],
	[1.2475000000E+04, 5.1106832912E+00, 5.5343376674E+00, 3.0197115954E-01, 2.7115458783E-01, 6.0098548982E-01],
	[1.2480000000E+04, 5.1134363051E+00, 5.5338547997E+00, 3.0234756671E-01, 2.7146465195E-01, 6.0112682267E-01],
	[1.2485000000E+04, 5.1161896982E+00, 5.5333721674E+00, 3.0272429151E-01, 2.7177491779E-01, 6.0126812739E-01],
	[1.2490000000E+04, 5.1189434706E+00, 5.5328897705E+00, 3.0310133408E-01, 2.7208538536E-01, 6.0140940399E-01],
	[1.2495000000E+04, 5.1216976222E+00, 5.5324076087E+00, 3.0347869457E-01, 2.7239605463E-01, 6.0155065245E-01],
	[1.2500000000E+04, 5.1244521528E+00, 5.5319256818E+00, 3.0385637310E-01, 2.7270692559E-01, 6.0169187279E-01],
	[1.2505000000E+04, 5.1272070623E+00, 5.5314439895E+00, 3.0423583044E-01, 2.7301917448E-01, 6.0183306501E-01],
	[1.2510000000E+04, 5.1299623508E+00, 5.5309625318E+00, 3.0461560929E-01, 2.7333162712E-01, 6.0197422911E-01],
	[1.2515000000E+04, 5.1327180179E+00, 5.5304813083E+00, 3.0499570980E-01, 2.7364428349E-01, 6.0211536508E-01],
	[1.2520000000E+04, 5.1354740637E+00, 5.5300003189E+00, 3.0537613212E-01, 2.7395714359E-01, 6.0225647293E-01],
	[1.2525000000E+04, 5.1382304881E+00, 5.5295195633E+00, 3.0575687639E-01, 2.7427020739E-01, 6.0239755267E-01],
	[1.2530000000E+04, 5.1409872909E+00, 5.5290390414E+00, 3.0613794275E-01, 2.7458347489E-01, 6.0253860428E-01],
	[1.2535000000E+04, 5.1437444721E+00, 5.5285587529E+00, 3.0651933135E-01, 2.7489694608E-01, 6.0267962778E-01],
	[1.2540000000E+04, 5.1465020315E+00, 5.5280786977E+00, 3.0690104232E-01, 2.7521062093E-01, 6.0282062317E-01],
	[1.2545000000E+04, 5.1492599691E+00, 5.5275988755E+00, 3.0728307582E-01, 2.7552449945E-01, 6.0296159044E-01],
	[1.2550000000E+04, 5.1520182847E+00, 5.5271192861E+00, 3.0766543198E-01, 2.7583858161E-01, 6.0310252960E-01],
	[1.2555000000E+04, 5.1547769783E+00, 5.5266399294E+00, 3.0804811095E-01, 2.7615286741E-01, 6.0324344064E-01],
	[1.2560000000E+04, 5.1575360498E+00, 5.5261608050E+00, 3.0843111287E-01, 2.7646735682E-01, 6.0338432358E-01],
	[1.2565000000E+04, 5.1602954990E+00, 5.5256819129E+00, 3.0881443789E-01, 2.7678204984E-01, 6.0352517841E-01],
	[1.2570000000E+04, 5.1630553259E+00, 5.5252032528E+00, 3.0919808614E-01, 2.7709694646E-01, 6.0366600513E-01],
	[1.2575000000E+04, 5.1658155303E+00, 5.5247248244E+00, 3.0958205778E-01, 2.7741204665E-01, 6.0380680375E-01],
	[1.2580000000E+04, 5.1685761122E+00, 5.5242466277E+00, 3.0996635294E-01, 2.7772735041E-01, 6.0394757427E-01],
	[1.2585000000E+04, 5.1713370715E+00, 5.5237686624E+00, 3.1035097178E-01, 2.7804285772E-01, 6.0408831668E-01],
	[1.2590000000E+04, 5.1740984081E+00, 5.5232909282E+00, 3.1073591442E-01, 2.7835856857E-01, 6.0422903099E-01],
	[1.2595000000E+04, 5.1768601218E+00, 5.5228134250E+00, 3.1112118102E-01, 2.7867448294E-01, 6.0436971720E-01],
	[1.2600000000E+04, 5.1796222126E+00, 5.5223361526E+00, 3.1150677172E-01, 2.7899060082E-01, 6.0451037537E-01],
	[1.2605000000E+04, 5.1823846803E+00, 5.5218591108E+00, 3.1189268665E-01, 2.7930692220E-01, 6.0465100583E-01],
	[1.2610000000E+04, 5.1851475250E+00, 5.5213822994E+00, 3.1227892598E-01, 2.7962344706E-01, 6.0479160865E-01],
	[1.2615000000E+04, 5.1879107464E+00, 5.5209057181E+00, 3.1266548983E-01, 2.7994017538E-01, 6.0493218380E-01],
	[1.2620000000E+04, 5.1906743445E+00, 5.5204293668E+00, 3.1305237836E-01, 2.8025710716E-01, 6.0507273127E-01],
	[1.2625000000E+04, 5.1934383192E+00, 5.5199532452E+00, 3.1343959170E-01, 2.8057424237E-01, 6.0521325106E-01],
	[1.2630000000E+04, 5.1962081882E+00, 5.5194845705E+00, 3.1382713001E-01, 2.8089161582E-01, 6.0535374316E-01],
	[1.2635000000E+04, 5.1989789533E+00, 5.5190167956E+00, 3.1421499341E-01, 2.8120919607E-01, 6.0549420755E-01],
	[1.2640000000E+04, 5.2017500987E+00, 5.5185492453E+00, 3.1460318206E-01, 2.8152697985E-01, 6.0563464422E-01],
	[1.2645000000E+04, 5.2045216243E+00, 5.5180819195E+00, 3.1499169610E-01, 2.8184496715E-01, 6.0577505316E-01],
	[1.2650000000E+04, 5.2072935301E+00, 5.5176148180E+00, 3.1538053567E-01, 2.8216315796E-01, 6.0591543437E-01],
	[1.2655000000E+04, 5.2100658159E+00, 5.5171479406E+00, 3.1576970092E-01, 2.8248155225E-01, 6.0605578782E-01],
	[1.2660000000E+04, 5.2128384816E+00, 5.5166812872E+00, 3.1615919199E-01, 2.8280015002E-01, 6.0619611352E-01],
	[1.2665000000E+04, 5.2156115272E+00, 5.5162148574E+00, 3.1654900902E-01, 2.8311895125E-01, 6.0633641145E-01],
	[1.2670000000E+04, 5.2183849525E+00, 5.5157486512E+00, 3.1693915216E-01, 2.8343795591E-01, 6.0647668159E-01],
	[1.2675000000E+04, 5.2211587575E+00, 5.5152826683E+00, 3.1732962155E-01, 2.8375716401E-01, 6.0661692394E-01],
	[1.2680000000E+04, 5.2239329420E+00, 5.5148169085E+00, 3.1772041734E-01, 2.8407657551E-01, 6.0675713850E-01],
	[1.2685000000E+04, 5.2267075059E+00, 5.5143513716E+00, 3.1811153966E-01, 2.8439619041E-01, 6.0689732524E-01],
	[1.2690000000E+04, 5.2294824492E+00, 5.5138860575E+00, 3.1850298866E-01, 2.8471600869E-01, 6.0703748415E-01],
	[1.2695000000E+04, 5.2322577717E+00, 5.5134209659E+00, 3.1889476448E-01, 2.8503603033E-01, 6.0717761524E-01],
	[1.2700000000E+04, 5.2350334734E+00, 5.5129560967E+00, 3.1928686728E-01, 2.8535625532E-01, 6.0731771848E-01],
	[1.2705000000E+04, 5.2378095541E+00, 5.5124914497E+00, 3.1967929718E-01, 2.8567668364E-01, 6.0745779386E-01],
	[1.2710000000E+04, 5.2405860138E+00, 5.5120270246E+00, 3.2007205434E-01, 2.8599731527E-01, 6.0759784139E-01],
	[1.2715000000E+04, 5.2433628523E+00, 5.5115628212E+00, 3.2046513890E-01, 2.8631815020E-01, 6.0773786103E-01],
	[1.2720000000E+04, 5.2461400697E+00, 5.5110988395E+00, 3.2085855100E-01, 2.8663918841E-01, 6.0787785280E-01],
	[1.2725000000E+04, 5.2489176656E+00, 5.5106350791E+00, 3.2125229078E-01, 2.8696042988E-01, 6.0801781667E-01],
	[1.2730000000E+04, 5.2516956402E+00, 5.5101715399E+00, 3.2164635839E-01, 2.8728187460E-01, 6.0815775263E-01],
	[1.2735000000E+04, 5.2544739932E+00, 5.5097082217E+00, 3.2204075398E-01, 2.8760352255E-01, 6.0829766068E-01],
	[1.2740000000E+04, 5.2572527246E+00, 5.5092451244E+00, 3.2243547768E-01, 2.8792537371E-01, 6.0843754081E-01],
	[1.2745000000E+04, 5.2600318342E+00, 5.5087822476E+00, 3.2283052964E-01, 2.8824742806E-01, 6.0857739300E-01],
	[1.2750000000E+04, 5.2628113221E+00, 5.5083195912E+00, 3.2322591001E-01, 2.8856968560E-01, 6.0871721724E-01],
	[1.2755000000E+04, 5.2655911880E+00, 5.5078571551E+00, 3.2362161892E-01, 2.8889214629E-01, 6.0885701353E-01],
	[1.2760000000E+04, 5.2683714319E+00, 5.5073949391E+00, 3.2401765652E-01, 2.8921481012E-01, 6.0899678185E-01],
	[1.2765000000E+04, 5.2711520537E+00, 5.5069329429E+00, 3.2441402296E-01, 2.8953767708E-01, 6.0913652220E-01],
	[1.2770000000E+04, 5.2739330533E+00, 5.5064711663E+00, 3.2481071837E-01, 2.8986074714E-01, 6.0927623457E-01],
	[1.2775000000E+04, 5.2767144305E+00, 5.5060096092E+00, 3.2520774290E-01, 2.9018402029E-01, 6.0941591894E-01],
	[1.2780000000E+04, 5.2794961854E+00, 5.5055482714E+00, 3.2560509670E-01, 2.9050749651E-01, 6.0955557530E-01],
	[1.2785000000E+04, 5.2822783178E+00, 5.5050871527E+00, 3.2600277991E-01, 2.9083117578E-01, 6.0969520365E-01],
	[1.2790000000E+04, 5.2850608276E+00, 5.5046262529E+00, 3.2640079267E-01, 2.9115505809E-01, 6.0983480398E-01],
	[1.2795000000E+04, 5.2878437147E+00, 5.5041655717E+00, 3.2679913512E-01, 2.9147914341E-01, 6.0997437627E-01],
	[1.2800000000E+04, 5.2906269790E+00, 5.5037051091E+00, 3.2719780742E-01, 2.9180343172E-01, 6.1011392052E-01],
	[1.2805000000E+04, 5.2934106204E+00, 5.5032448649E+00, 3.2759680969E-01, 2.9212792301E-01, 6.1025343672E-01],
	[1.2810000000E+04, 5.2961946389E+00, 5.5027848388E+00, 3.2799614210E-01, 2.9245261726E-01, 6.1039292485E-01],
	[1.2815000000E+04, 5.2989790342E+00, 5.5023250306E+00, 3.2839580477E-01, 2.9277751445E-01, 6.1053238491E-01],
	[1.2820000000E+04, 5.3017638064E+00, 5.5018654402E+00, 3.2879579785E-01, 2.9310261456E-01, 6.1067181689E-01],
	[1.2825000000E+04, 5.3045489554E+00, 5.5014060674E+00, 3.2919612150E-01, 2.9342791757E-01, 6.1081122077E-01],
	[1.2830000000E+04, 5.3073361587E+00, 5.5009489520E+00, 3.2959677584E-01, 2.9375343442E-01, 6.1095059656E-01],
	[1.2835000000E+04, 5.3101284169E+00, 5.5004977365E+00, 3.2999776103E-01, 2.9407918476E-01, 6.1108994423E-01],
	[1.2840000000E+04, 5.3129210557E+00, 5.5000467337E+00, 3.3039907721E-01, 2.9440513809E-01, 6.1122926378E-01],
	[1.2845000000E+04, 5.3157140751E+00, 5.4995959434E+00, 3.3080072452E-01, 2.9473129440E-01, 6.1136855521E-01],
	[1.2850000000E+04, 5.3185074750E+00, 5.4991453655E+00, 3.3120270310E-01, 2.9505765367E-01, 6.1150781849E-01],
	[1.2855000000E+04, 5.3213012552E+00, 5.4986949998E+00, 3.3160501311E-01, 2.9538421586E-01, 6.1164705363E-01],
	[1.2860000000E+04, 5.3240954156E+00, 5.4982448461E+00, 3.3200765468E-01, 2.9571098098E-01, 6.1178626060E-01],
	[1.2865000000E+04, 5.3268899562E+00, 5.4977949042E+00, 3.3241062795E-01, 2.9603794899E-01, 6.1192543941E-01],
	[1.2870000000E+04, 5.3296848769E+00, 5.4973451739E+00, 3.3281393308E-01, 2.9636511987E-01, 6.1206459005E-01],
	[1.2875000000E+04, 5.3324801776E+00, 5.4968956551E+00, 3.3321757020E-01, 2.9669249361E-01, 6.1220371250E-01],
	[1.2880000000E+04, 5.3352758581E+00, 5.4964463476E+00, 3.3362153945E-01, 2.9702007018E-01, 6.1234280675E-01],
	[1.2885000000E+04, 5.3380719184E+00, 5.4959972511E+00, 3.3402584099E-01, 2.9734784957E-01, 6.1248187280E-01],
	[1.2890000000E+04, 5.3408683584E+00, 5.4955483656E+00, 3.3443047496E-01, 2.9767583175E-01, 6.1262091064E-01],
	[1.2895000000E+04, 5.3436651780E+00, 5.4950996908E+00, 3.3483544149E-01, 2.9800401670E-01, 6.1275992025E-01],
	[1.2900000000E+04, 5.3464623771E+00, 5.4946512265E+00, 3.3524074074E-01, 2.9833240441E-01, 6.1289890163E-01],
	[1.2905000000E+04, 5.3492599556E+00, 5.4942029726E+00, 3.3564637284E-01, 2.9866099484E-01, 6.1303785477E-01],
	[1.2910000000E+04, 5.3520579133E+00, 5.4937549289E+00, 3.3605233794E-01, 2.9898978799E-01, 6.1317677966E-01],
	[1.2915000000E+04, 5.3548562503E+00, 5.4933070952E+00, 3.3645863619E-01, 2.9931878383E-01, 6.1331567629E-01],
	[1.2920000000E+04, 5.3576549664E+00, 5.4928594713E+00, 3.3686526773E-01, 2.9964798233E-01, 6.1345454466E-01],
	[1.2925000000E+04, 5.3604540615E+00, 5.4924120571E+00, 3.3727223269E-01, 2.9997738348E-01, 6.1359338475E-01],
	[1.2930000000E+04, 5.3632535356E+00, 5.4919648524E+00, 3.3767953124E-01, 3.0030698726E-01, 6.1373219655E-01],
	[1.2935000000E+04, 5.3660533884E+00, 5.4915178569E+00, 3.3808716350E-01, 3.0063679364E-01, 6.1387098006E-01],
	[1.2940000000E+04, 5.3688536200E+00, 5.4910710706E+00, 3.3849512962E-01, 3.0096680261E-01, 6.1400973526E-01],
	[1.2945000000E+04, 5.3716542302E+00, 5.4906244932E+00, 3.3890342975E-01, 3.0129701413E-01, 6.1414846215E-01],
	[1.2950000000E+04, 5.3744552190E+00, 5.4901781245E+00, 3.3931206404E-01, 3.0162742819E-01, 6.1428716072E-01],
	[1.2955000000E+04, 5.3772565862E+00, 5.4897319644E+00, 3.3972103261E-01, 3.0195804477E-01, 6.1442583096E-01],
	[1.2960000000E+04, 5.3800583317E+00, 5.4892860128E+00, 3.4013033563E-01, 3.0228886384E-01, 6.1456447286E-01],
	[1.2965000000E+04, 5.3828604555E+00, 5.4888402693E+00, 3.4053997323E-01, 3.0261988538E-01, 6.1470308642E-01],
	[1.2970000000E+04, 5.3856629575E+00, 5.4883947339E+00, 3.4094994555E-01, 3.0295110938E-01, 6.1484167162E-01],
	[1.2975000000E+04, 5.3884658375E+00, 5.4879494063E+00, 3.4136025274E-01, 3.0328253580E-01, 6.1498022845E-01],
	[1.2980000000E+04, 5.3912690955E+00, 5.4875042865E+00, 3.4177089495E-01, 3.0361416462E-01, 6.1511875691E-01],
	[1.2985000000E+04, 5.3940727314E+00, 5.4870593741E+00, 3.4218187231E-01, 3.0394599582E-01, 6.1525725699E-01],
	[1.2990000000E+04, 5.3968767451E+00, 5.4866146691E+00, 3.4259318498E-01, 3.0427802939E-01, 6.1539572867E-01],
	[1.2995000000E+04, 5.3996811364E+00, 5.4861701713E+00, 3.4300483309E-01, 3.0461026529E-01, 6.1553417196E-01],
	[1.3000000000E+04, 5.4024859053E+00, 5.4857258804E+00, 3.4341681679E-01, 3.0494270350E-01, 6.1567258684E-01],
	[1.3005000000E+04, 5.4052910518E+00, 5.4852817964E+00, 3.4382913622E-01, 3.0527534400E-01, 6.1581097330E-01],
	[1.3010000000E+04, 5.4080965756E+00, 5.4848379189E+00, 3.4424179153E-01, 3.0560818676E-01, 6.1594933134E-01],
	[1.3015000000E+04, 5.4109024767E+00, 5.4843942480E+00, 3.4465478286E-01, 3.0594123177E-01, 6.1608766095E-01],
	[1.3020000000E+04, 5.4137087551E+00, 5.4839507833E+00, 3.4506811036E-01, 3.0627447900E-01, 6.1622596211E-01],
	[1.3025000000E+04, 5.4165154106E+00, 5.4835075247E+00, 3.4548177416E-01, 3.0660792842E-01, 6.1636423483E-01],
	[1.3030000000E+04, 5.4193224431E+00, 5.4830644720E+00, 3.4589577442E-01, 3.0694158002E-01, 6.1650247908E-01],
	[1.3035000000E+04, 5.4221298525E+00, 5.4826216252E+00, 3.4631011127E-01, 3.0727543376E-01, 6.1664069487E-01],
	[1.3040000000E+04, 5.4249440479E+00, 5.4821862366E+00, 3.4672478486E-01, 3.0760953306E-01, 6.1677888219E-01],
	[1.3045000000E+04, 5.4277588968E+00, 5.4817513578E+00, 3.4713979534E-01, 3.0794383647E-01, 6.1691704102E-01],
	[1.3050000000E+04, 5.4305741267E+00, 5.4813166801E+00, 3.4755514284E-01, 3.0827834211E-01, 6.1705517136E-01],
	[1.3055000000E+04, 5.4333897375E+00, 5.4808822034E+00, 3.4797082752E-01, 3.0861304997E-01, 6.1719327320E-01],
	[1.3060000000E+04, 5.4362057291E+00, 5.4804479274E+00, 3.4838684951E-01, 3.0894796001E-01, 6.1733134653E-01],
	[1.3065000000E+04, 5.4390221014E+00, 5.4800138521E+00, 3.4880320896E-01, 3.0928307222E-01, 6.1746939134E-01],
	[1.3070000000E+04, 5.4418388544E+00, 5.4795799772E+00, 3.4921990602E-01, 3.0961838656E-01, 6.1760740764E-01],
	[1.3075000000E+04, 5.4446559880E+00, 5.4791463027E+00, 3.4963694082E-01, 3.0995390302E-01, 6.1774539540E-01],
	[1.3080000000E+04, 5.4474735019E+00, 5.4787128282E+00, 3.5005431351E-01, 3.1028962157E-01, 6.1788335461E-01],
	[1.3085000000E+04, 5.4502913963E+00, 5.4782795537E+00, 3.5047202424E-01, 3.1062554218E-01, 6.1802128529E-01],
	[1.3090000000E+04, 5.4531096709E+00, 5.4778464789E+00, 3.5089007316E-01, 3.1096166484E-01, 6.1815918740E-01],
	[1.3095000000E+04, 5.4559283256E+00, 5.4774136038E+00, 3.5130846039E-01, 3.1129798950E-01, 6.1829706095E-01],
	[1.3100000000E+04, 5.4587473604E+00, 5.4769809280E+00, 3.5172718609E-01, 3.1163451616E-01, 6.1843490593E-01],
	[1.3105000000E+04, 5.4615667752E+00, 5.4765484516E+00, 3.5214625040E-01, 3.1197124478E-01, 6.1857272232E-01],
	[1.3110000000E+04, 5.4643865699E+00, 5.4761161743E+00, 3.5256565347E-01, 3.1230817534E-01, 6.1871051013E-01],
	[1.3115000000E+04, 5.4672067444E+00, 5.4756840959E+00, 3.5298539544E-01, 3.1264530781E-01, 6.1884826935E-01],
	[1.3120000000E+04, 5.4700272986E+00, 5.4752522162E+00, 3.5340547645E-01, 3.1298264217E-01, 6.1898599995E-01],
	[1.3125000000E+04, 5.4728482323E+00, 5.4748205352E+00, 3.5382589665E-01, 3.1332017840E-01, 6.1912370195E-01],
	[1.3130000000E+04, 5.4756695456E+00, 5.4743890526E+00, 3.5424665618E-01, 3.1365791645E-01, 6.1926137533E-01],
	[1.3135000000E+04, 5.4784912383E+00, 5.4739577683E+00, 3.5466775519E-01, 3.1399585632E-01, 6.1939902008E-01],
	[1.3140000000E+04, 5.4813133103E+00, 5.4735266820E+00, 3.5508919381E-01, 3.1433399797E-01, 6.1953663620E-01],
	[1.3145000000E+04, 5.4841357616E+00, 5.4730957937E+00, 3.5551097220E-01, 3.1467234138E-01, 6.1967422367E-01],
	[1.3150000000E+04, 5.4869585920E+00, 5.4726651032E+00, 3.5593309050E-01, 3.1501088652E-01, 6.1981178249E-01],
	[1.3155000000E+04, 5.4897818014E+00, 5.4722346103E+00, 3.5635554885E-01, 3.1534963337E-01, 6.1994931265E-01],
	[1.3160000000E+04, 5.4926053898E+00, 5.4718043148E+00, 3.5677834739E-01, 3.1568858189E-01, 6.2008681415E-01],
	[1.3165000000E+04, 5.4954293570E+00, 5.4713742166E+00, 3.5720148628E-01, 3.1602773206E-01, 6.2022428698E-01],
	[1.3170000000E+04, 5.4982537030E+00, 5.4709443155E+00, 3.5762496565E-01, 3.1636708386E-01, 6.2036173112E-01],
	[1.3175000000E+04, 5.5010784276E+00, 5.4705146113E+00, 3.5804878564E-01, 3.1670663726E-01, 6.2049914658E-01],
	[1.3180000000E+04, 5.5039035309E+00, 5.4700851039E+00, 3.5847294641E-01, 3.1704639222E-01, 6.2063653334E-01],
	[1.3185000000E+04, 5.5067290126E+00, 5.4696557931E+00, 3.5889744810E-01, 3.1738634873E-01, 6.2077389139E-01],
	[1.3190000000E+04, 5.5095548727E+00, 5.4692266788E+00, 3.5932229084E-01, 3.1772650676E-01, 6.2091122074E-01],
	[1.3195000000E+04, 5.5123811111E+00, 5.4687977607E+00, 3.5974747479E-01, 3.1806686627E-01, 6.2104852136E-01],
	[1.3200000000E+04, 5.5152077277E+00, 5.4683690388E+00, 3.6017300009E-01, 3.1840742724E-01, 6.2118579326E-01],
	[1.3205000000E+04, 5.5180347224E+00, 5.4679405128E+00, 3.6059886688E-01, 3.1874818965E-01, 6.2132303643E-01],
	[1.3210000000E+04, 5.5208620952E+00, 5.4675121826E+00, 3.6102507531E-01, 3.1908915347E-01, 6.2146025086E-01],
	[1.3215000000E+04, 5.5236898458E+00, 5.4670840480E+00, 3.6145162552E-01, 3.1943031866E-01, 6.2159743654E-01],
	[1.3220000000E+04, 5.5265179743E+00, 5.4666561089E+00, 3.6187851765E-01, 3.1977168520E-01, 6.2173459346E-01],
	[1.3225000000E+04, 5.5293464806E+00, 5.4662283651E+00, 3.6230575185E-01, 3.2011325306E-01, 6.2187172162E-01],
	[1.3230000000E+04, 5.5321753645E+00, 5.4658008165E+00, 3.6273332827E-01, 3.2045502221E-01, 6.2200882101E-01],
	[1.3235000000E+04, 5.5350046259E+00, 5.4653734628E+00, 3.6316124704E-01, 3.2079699263E-01, 6.2214589163E-01],
	[1.3240000000E+04, 5.5378342649E+00, 5.4649463039E+00, 3.6358950831E-01, 3.2113916429E-01, 6.2228293346E-01],
	[1.3245000000E+04, 5.5406642812E+00, 5.4645193397E+00, 3.6401811223E-01, 3.2148153715E-01, 6.2241994650E-01],
	[1.3250000000E+04, 5.5435016126E+00, 5.4640998936E+00, 3.6444705894E-01, 3.2182415998E-01, 6.2255693074E-01],
	[1.3255000000E+04, 5.5463394001E+00, 5.4636807164E+00, 3.6487634858E-01, 3.2216698466E-01, 6.2269388617E-01],
	[1.3260000000E+04, 5.5491775691E+00, 5.4632617294E+00, 3.6530598131E-01, 3.2251001062E-01, 6.2283081280E-01],
	[1.3265000000E+04, 5.5520161197E+00, 5.4628429324E+00, 3.6573595725E-01, 3.2285323785E-01, 6.2296771060E-01],
	[1.3270000000E+04, 5.5548550517E+00, 5.4624243254E+00, 3.6616627656E-01, 3.2319666632E-01, 6.2310457957E-01],
	[1.3275000000E+04, 5.5576943650E+00, 5.4620059081E+00, 3.6659693938E-01, 3.2354029599E-01, 6.2324141972E-01],
	[1.3280000000E+04, 5.5605340596E+00, 5.4615876804E+00, 3.6702794585E-01, 3.2388412684E-01, 6.2337823102E-01],
	[1.3285000000E+04, 5.5633741353E+00, 5.4611696422E+00, 3.6745929613E-01, 3.2422815884E-01, 6.2351501347E-01],
	[1.3290000000E+04, 5.5662145922E+00, 5.4607517932E+00, 3.6789099035E-01, 3.2457239195E-01, 6.2365176707E-01],
	[1.3295000000E+04, 5.5690554299E+00, 5.4603341334E+00, 3.6832302865E-01, 3.2491682616E-01, 6.2378849181E-01],
	[1.3300000000E+04, 5.5718966486E+00, 5.4599166626E+00, 3.6875541119E-01, 3.2526146142E-01, 6.2392518767E-01],
	[1.3305000000E+04, 5.5747382481E+00, 5.4594993805E+00, 3.6918813810E-01, 3.2560629771E-01, 6.2406185467E-01],
	[1.3310000000E+04, 5.5775802282E+00, 5.4590822871E+00, 3.6962120953E-01, 3.2595133501E-01, 6.2419849278E-01],
	[1.3315000000E+04, 5.5804225890E+00, 5.4586653822E+00, 3.7005462563E-01, 3.2629657327E-01, 6.2433510200E-01],
	[1.3320000000E+04, 5.5832653302E+00, 5.4582486657E+00, 3.7048838654E-01, 3.2664201247E-01, 6.2447168233E-01],
	[1.3325000000E+04, 5.5861084519E+00, 5.4578321374E+00, 3.7092249239E-01, 3.2698765259E-01, 6.2460823375E-01],
	[1.3330000000E+04, 5.5889519539E+00, 5.4574157971E+00, 3.7135694335E-01, 3.2733349358E-01, 6.2474475627E-01],
	[1.3335000000E+04, 5.5917958362E+00, 5.4569996446E+00, 3.7179173955E-01, 3.2767953542E-01, 6.2488124986E-01],
	[1.3340000000E+04, 5.5946400986E+00, 5.4565836799E+00, 3.7222688113E-01, 3.2802577808E-01, 6.2501771454E-01],
	[1.3345000000E+04, 5.5974847410E+00, 5.4561679028E+00, 3.7266236824E-01, 3.2837222153E-01, 6.2515415029E-01],
	[1.3350000000E+04, 5.6003297634E+00, 5.4557523130E+00, 3.7309820103E-01, 3.2871886574E-01, 6.2529055710E-01],
	[1.3355000000E+04, 5.6031751657E+00, 5.4553369106E+00, 3.7353437963E-01, 3.2906571067E-01, 6.2542693497E-01],
	[1.3360000000E+04, 5.6060209478E+00, 5.4549216952E+00, 3.7397090420E-01, 3.2941275630E-01, 6.2556328389E-01],
	[1.3365000000E+04, 5.6088671095E+00, 5.4545066668E+00, 3.7440777487E-01, 3.2976000259E-01, 6.2569960385E-01],
	[1.3370000000E+04, 5.6117136508E+00, 5.4540918252E+00, 3.7484499180E-01, 3.3010744952E-01, 6.2583589485E-01],
	[1.3375000000E+04, 5.6145605717E+00, 5.4536771702E+00, 3.7528255512E-01, 3.3045509705E-01, 6.2597215689E-01],
	[1.3380000000E+04, 5.6174078719E+00, 5.4532627018E+00, 3.7572046498E-01, 3.3080294514E-01, 6.2610838994E-01],
	[1.3385000000E+04, 5.6202555515E+00, 5.4528484196E+00, 3.7615872152E-01, 3.3115099378E-01, 6.2624459402E-01],
	[1.3390000000E+04, 5.6231036103E+00, 5.4524343236E+00, 3.7659732490E-01, 3.3149924292E-01, 6.2638076911E-01],
	[1.3395000000E+04, 5.6259520483E+00, 5.4520204137E+00, 3.7703627524E-01, 3.3184769254E-01, 6.2651691520E-01],
	[1.3400000000E+04, 5.6288008653E+00, 5.4516066897E+00, 3.7747557271E-01, 3.3219634261E-01, 6.2665303230E-01],
	[1.3405000000E+04, 5.6316500612E+00, 5.4511931513E+00, 3.7791521743E-01, 3.3254519308E-01, 6.2678912038E-01],
	[1.3410000000E+04, 5.6344996360E+00, 5.4507797986E+00, 3.7835520956E-01, 3.3289424393E-01, 6.2692517946E-01],
	[1.3415000000E+04, 5.6373495896E+00, 5.4503666312E+00, 3.7879554924E-01, 3.3324349513E-01, 6.2706120951E-01],
	[1.3420000000E+04, 5.6401999219E+00, 5.4499536491E+00, 3.7923623662E-01, 3.3359294665E-01, 6.2719721054E-01],
	[1.3425000000E+04, 5.6430506328E+00, 5.4495408522E+00, 3.7967727183E-01, 3.3394259844E-01, 6.2733318253E-01],
	[1.3430000000E+04, 5.6459017221E+00, 5.4491282402E+00, 3.8011865503E-01, 3.3429245049E-01, 6.2746912549E-01],
	[1.3435000000E+04, 5.6487531899E+00, 5.4487158130E+00, 3.8056038636E-01, 3.3464250275E-01, 6.2760503940E-01],
	[1.3440000000E+04, 5.6516050360E+00, 5.4483035705E+00, 3.8100246595E-01, 3.3499275520E-01, 6.2774092426E-01],
	[1.3445000000E+04, 5.6544572604E+00, 5.4478915124E+00, 3.8144489397E-01, 3.3534320779E-01, 6.2787678007E-01],
	[1.3450000000E+04, 5.6573098628E+00, 5.4474796388E+00, 3.8188767054E-01, 3.3569386051E-01, 6.2801260681E-01],
	[1.3455000000E+04, 5.6601628434E+00, 5.4470679493E+00, 3.8233079582E-01, 3.3604471330E-01, 6.2814840448E-01],
	[1.3460000000E+04, 5.6630187282E+00, 5.4466589369E+00, 3.8277426995E-01, 3.3639578458E-01, 6.2828417308E-01],
	[1.3465000000E+04, 5.6658798127E+00, 5.4462548609E+00, 3.8321809307E-01, 3.3674709113E-01, 6.2841991260E-01],
	[1.3470000000E+04, 5.6687412798E+00, 5.4458509649E+00, 3.8366226533E-01, 3.3709859786E-01, 6.2855562302E-01],
	[1.3475000000E+04, 5.6716031292E+00, 5.4454472487E+00, 3.8410678688E-01, 3.3745030471E-01, 6.2869130432E-01],
	[1.3480000000E+04, 5.6744653609E+00, 5.4450437123E+00, 3.8455165785E-01, 3.3780221167E-01, 6.2882695648E-01],
	[1.3485000000E+04, 5.6773279747E+00, 5.4446403553E+00, 3.8499687839E-01, 3.3815431869E-01, 6.2896257949E-01],
	[1.3490000000E+04, 5.6801909707E+00, 5.4442371778E+00, 3.8544244865E-01, 3.3850662574E-01, 6.2909817333E-01],
	[1.3495000000E+04, 5.6830543487E+00, 5.4438341795E+00, 3.8588836877E-01, 3.3885913279E-01, 6.2923373799E-01],
	[1.3500000000E+04, 5.6859181086E+00, 5.4434313603E+00, 3.8633463890E-01, 3.3921183981E-01, 6.2936927347E-01],
	[1.3505000000E+04, 5.6887822503E+00, 5.4430287201E+00, 3.8678125917E-01, 3.3956474676E-01, 6.2950477974E-01],
	[1.3510000000E+04, 5.6916467738E+00, 5.4426262586E+00, 3.8722822974E-01, 3.3991785360E-01, 6.2964025680E-01],
	[1.3515000000E+04, 5.6945116789E+00, 5.4422239759E+00, 3.8767555075E-01, 3.4027116030E-01, 6.2977570464E-01],
	[1.3520000000E+04, 5.6973769656E+00, 5.4418218716E+00, 3.8812322234E-01, 3.4062466684E-01, 6.2991112323E-01],
	[1.3525000000E+04, 5.7002426337E+00, 5.4414199458E+00, 3.8857124465E-01, 3.4097837316E-01, 6.3004651258E-01],
	[1.3530000000E+04, 5.7031086832E+00, 5.4410181981E+00, 3.8901961784E-01, 3.4133227925E-01, 6.3018187266E-01],
	[1.3535000000E+04, 5.7059751140E+00, 5.4406166285E+00, 3.8946834204E-01, 3.4168638506E-01, 6.3031720347E-01],
	[1.3540000000E+04, 5.7088419259E+00, 5.4402152369E+00, 3.8991741741E-01, 3.4204069055E-01, 6.3045250499E-01],
	[1.3545000000E+04, 5.7117091190E+00, 5.4398140231E+00, 3.9036684408E-01, 3.4239519571E-01, 6.3058777721E-01],
	[1.3550000000E+04, 5.7145766931E+00, 5.4394129869E+00, 3.9081662220E-01, 3.4274990048E-01, 6.3072302012E-01],
	[1.3555000000E+04, 5.7174446481E+00, 5.4390121282E+00, 3.9126675191E-01, 3.4310480483E-01, 6.3085823371E-01],
	[1.3560000000E+04, 5.7203129840E+00, 5.4386114469E+00, 3.9171723337E-01, 3.4345990873E-01, 6.3099341797E-01],
	[1.3565000000E+04, 5.7231817006E+00, 5.4382109428E+00, 3.9216806670E-01, 3.4381521215E-01, 6.3112857288E-01],
	[1.3570000000E+04, 5.7260507978E+00, 5.4378106158E+00, 3.9261925207E-01, 3.4417071504E-01, 6.3126369843E-01],
	[1.3575000000E+04, 5.7289202757E+00, 5.4374104657E+00, 3.9307078960E-01, 3.4452641738E-01, 6.3139879461E-01],
	[1.3580000000E+04, 5.7317901340E+00, 5.4370104924E+00, 3.9352267946E-01, 3.4488231912E-01, 6.3153386141E-01],
	[1.3585000000E+04, 5.7346603726E+00, 5.4366106957E+00, 3.9397492177E-01, 3.4523842023E-01, 6.3166889881E-01],
	[1.3590000000E+04, 5.7375309916E+00, 5.4362110756E+00, 3.9442751669E-01, 3.4559472068E-01, 6.3180390681E-01],
	[1.3595000000E+04, 5.7404019908E+00, 5.4358116318E+00, 3.9488046436E-01, 3.4595122042E-01, 6.3193888539E-01],
	[1.3600000000E+04, 5.7432733701E+00, 5.4354123642E+00, 3.9533376493E-01, 3.4630791943E-01, 6.3207383455E-01],
	[1.3605000000E+04, 5.7461451294E+00, 5.4350132727E+00, 3.9578741854E-01, 3.4666481766E-01, 6.3220875426E-01],
	[1.3610000000E+04, 5.7490172687E+00, 5.4346143571E+00, 3.9624142533E-01, 3.4702191508E-01, 6.3234364453E-01],
	[1.3615000000E+04, 5.7518897878E+00, 5.4342156173E+00, 3.9669578544E-01, 3.4737921165E-01, 6.3247850533E-01],
	[1.3620000000E+04, 5.7547626866E+00, 5.4338170532E+00, 3.9715049904E-01, 3.4773670734E-01, 6.3261333665E-01],
	[1.3625000000E+04, 5.7576359652E+00, 5.4334186645E+00, 3.9760556625E-01, 3.4809440211E-01, 6.3274813849E-01],
	[1.3630000000E+04, 5.7605096233E+00, 5.4330204512E+00, 3.9806098722E-01, 3.4845229592E-01, 6.3288291083E-01],
	[1.3635000000E+04, 5.7633836609E+00, 5.4326224132E+00, 3.9851676210E-01, 3.4881038873E-01, 6.3301765367E-01],
	[1.3640000000E+04, 5.7662580779E+00, 5.4322245502E+00, 3.9897289103E-01, 3.4916868052E-01, 6.3315236698E-01],
	[1.3645000000E+04, 5.7691328742E+00, 5.4318268622E+00, 3.9942937416E-01, 3.4952717123E-01, 6.3328705076E-01],
	[1.3650000000E+04, 5.7720080498E+00, 5.4314293489E+00, 3.9988621163E-01, 3.4988586083E-01, 6.3342170500E-01],
	[1.3655000000E+04, 5.7748836045E+00, 5.4310320104E+00, 4.0034340358E-01, 3.5024474930E-01, 6.3355632968E-01],
	[1.3660000000E+04, 5.7777595382E+00, 5.4306348463E+00, 4.0080095016E-01, 3.5060383657E-01, 6.3369092480E-01],
	[1.3665000000E+04, 5.7806358509E+00, 5.4302378566E+00, 4.0125885152E-01, 3.5096312263E-01, 6.3382549034E-01],
	[1.3670000000E+04, 5.7835125424E+00, 5.4298410412E+00, 4.0171710780E-01, 3.5132260743E-01, 6.3396002629E-01],
	[1.3675000000E+04, 5.7863897046E+00, 5.4294444846E+00, 4.0217571915E-01, 3.5168229164E-01, 6.3409453264E-01],
	[1.3680000000E+04, 5.7892748387E+00, 5.4290551124E+00, 4.0263468570E-01, 3.5204223206E-01, 6.3422900939E-01],
	[1.3685000000E+04, 5.7921603563E+00, 5.4286659104E+00, 4.0309400760E-01, 3.5240237131E-01, 6.3436345651E-01],
	[1.3690000000E+04, 5.7950462573E+00, 5.4282768784E+00, 4.0355368500E-01, 3.5276270934E-01, 6.3449787400E-01],
	[1.3695000000E+04, 5.7979325415E+00, 5.4278880164E+00, 4.0401465098E-01, 3.5312395881E-01, 6.3463226184E-01],
	[1.3700000000E+04, 5.8008192089E+00, 5.4274993241E+00, 4.0447749809E-01, 3.5348657166E-01, 6.3476662003E-01],
	[1.3705000000E+04, 5.8037062593E+00, 5.4271108015E+00, 4.0494070577E-01, 3.5384938584E-01, 6.3490094856E-01],
	[1.3710000000E+04, 5.8065936928E+00, 5.4267224484E+00, 4.0540427419E-01, 3.5421240130E-01, 6.3503524741E-01],
	[1.3715000000E+04, 5.8094815092E+00, 5.4263342647E+00, 4.0586820347E-01, 3.5457561802E-01, 6.3516951657E-01],
	[1.3720000000E+04, 5.8123697084E+00, 5.4259462503E+00, 4.0633249379E-01, 3.5493903594E-01, 6.3530375603E-01],
	[1.3725000000E+04, 5.8152582903E+00, 5.4255584049E+00, 4.0679714527E-01, 3.5530265504E-01, 6.3543796578E-01],
	[1.3730000000E+04, 5.8181472549E+00, 5.4251707285E+00, 4.0726215807E-01, 3.5566647528E-01, 6.3557214582E-01],
	[1.3735000000E+04, 5.8210366021E+00, 5.4247832210E+00, 4.0772753235E-01, 3.5603049661E-01, 6.3570629612E-01],
	[1.3740000000E+04, 5.8239263317E+00, 5.4243958822E+00, 4.0819326824E-01, 3.5639471900E-01, 6.3584041668E-01],
	[1.3745000000E+04, 5.8268164436E+00, 5.4240087119E+00, 4.0865936590E-01, 3.5675914240E-01, 6.3597450749E-01],
	[1.3750000000E+04, 5.8297069379E+00, 5.4236217101E+00, 4.0912582547E-01, 3.5712376679E-01, 6.3610856853E-01],
	[1.3755000000E+04, 5.8325978144E+00, 5.4232348766E+00, 4.0959264711E-01, 3.5748859211E-01, 6.3624259980E-01],
	[1.3760000000E+04, 5.8354890730E+00, 5.4228482112E+00, 4.1005983096E-01, 3.5785361833E-01, 6.3637660129E-01],
	[1.3765000000E+04, 5.8383807136E+00, 5.4224617139E+00, 4.1052737718E-01, 3.5821884541E-01, 6.3651057298E-01],
	[1.3770000000E+04, 5.8412727361E+00, 5.4220753844E+00, 4.1099528590E-01, 3.5858427331E-01, 6.3664451487E-01],
	[1.3775000000E+04, 5.8441651405E+00, 5.4216892227E+00, 4.1146355728E-01, 3.5894990199E-01, 6.3677842694E-01],
	[1.3780000000E+04, 5.8470579266E+00, 5.4213032287E+00, 4.1193219147E-01, 3.5931573141E-01, 6.3691230919E-01],
	[1.3785000000E+04, 5.8499510945E+00, 5.4209174022E+00, 4.1240118862E-01, 3.5968176153E-01, 6.3704616159E-01],
	[1.3790000000E+04, 5.8528446439E+00, 5.4205317430E+00, 4.1287054887E-01, 3.6004799231E-01, 6.3717998415E-01],
	[1.3795000000E+04, 5.8557385747E+00, 5.4201462510E+00, 4.1334027237E-01, 3.6041442371E-01, 6.3731377685E-01],
	[1.3800000000E+04, 5.8586328870E+00, 5.4197609262E+00, 4.1381035928E-01, 3.6078105568E-01, 6.3744753969E-01],
	[1.3805000000E+04, 5.8615275807E+00, 5.4193757683E+00, 4.1428080974E-01, 3.6114788820E-01, 6.3758127264E-01],
	[1.3810000000E+04, 5.8644226555E+00, 5.4189907772E+00, 4.1475162390E-01, 3.6151492121E-01, 6.3771497571E-01],
	[1.3815000000E+04, 5.8673181115E+00, 5.4186059528E+00, 4.1522280191E-01, 3.6188215468E-01, 6.3784864887E-01],
	[1.3820000000E+04, 5.8702139486E+00, 5.4182212950E+00, 4.1569434391E-01, 3.6224958856E-01, 6.3798229213E-01],
	[1.3825000000E+04, 5.8731101666E+00, 5.4178368037E+00, 4.1616625007E-01, 3.6261722282E-01, 6.3811590546E-01],
	[1.3830000000E+04, 5.8760067655E+00, 5.4174524786E+00, 4.1663852051E-01, 3.6298505742E-01, 6.3824948887E-01],
	[1.3835000000E+04, 5.8789037452E+00, 5.4170683197E+00, 4.1711115541E-01, 3.6335309230E-01, 6.3838304234E-01],
	[1.3840000000E+04, 5.8818011055E+00, 5.4166843269E+00, 4.1758415489E-01, 3.6372132744E-01, 6.3851656585E-01],
	[1.3845000000E+04, 5.8846988466E+00, 5.4163004999E+00, 4.1805751912E-01, 3.6408976278E-01, 6.3865005941E-01],
	[1.3850000000E+04, 5.8875969681E+00, 5.4159168387E+00, 4.1853124823E-01, 3.6445839829E-01, 6.3878352299E-01],
	[1.3855000000E+04, 5.8904954701E+00, 5.4155333432E+00, 4.1900534239E-01, 3.6482723393E-01, 6.3891695659E-01],
	[1.3860000000E+04, 5.8933943524E+00, 5.4151500132E+00, 4.1947980173E-01, 3.6519626965E-01, 6.3905036020E-01],
	[1.3865000000E+04, 5.8962936150E+00, 5.4147668485E+00, 4.1995462641E-01, 3.6556550542E-01, 6.3918373382E-01],
	[1.3870000000E+04, 5.8991932578E+00, 5.4143838491E+00, 4.2042981658E-01, 3.6593494118E-01, 6.3931707742E-01],
	[1.3875000000E+04, 5.9020932807E+00, 5.4140010148E+00, 4.2090537238E-01, 3.6630457690E-01, 6.3945039100E-01],
	[1.3880000000E+04, 5.9049936835E+00, 5.4136183455E+00, 4.2138129396E-01, 3.6667441254E-01, 6.3958367454E-01],
	[1.3885000000E+04, 5.9078944663E+00, 5.4132358411E+00, 4.2185758148E-01, 3.6704444805E-01, 6.3971692805E-01],
	[1.3890000000E+04, 5.9107956290E+00, 5.4128535014E+00, 4.2233423508E-01, 3.6741468339E-01, 6.3985015151E-01],
	[1.3895000000E+04, 5.9136971714E+00, 5.4124713263E+00, 4.2281125491E-01, 3.6778511852E-01, 6.3998334491E-01],
	[1.3900000000E+04, 5.9166069794E+00, 5.4120961403E+00, 4.2328864111E-01, 3.6815581550E-01, 6.4011650824E-01],
	[1.3905000000E+04, 5.9195173136E+00, 5.4117212378E+00, 4.2376639385E-01, 3.6852671351E-01, 6.4024964148E-01],
	[1.3910000000E+04, 5.9224280322E+00, 5.4113464960E+00, 4.2424451326E-01, 3.6889781138E-01, 6.4038274464E-01],
	[1.3915000000E+04, 5.9253391352E+00, 5.4109719148E+00, 4.2472299949E-01, 3.6926910908E-01, 6.4051581770E-01],
	[1.3920000000E+04, 5.9282506225E+00, 5.4105974941E+00, 4.2520185271E-01, 3.6964060655E-01, 6.4064886065E-01],
	[1.3925000000E+04, 5.9311624941E+00, 5.4102232337E+00, 4.2568107304E-01, 3.7001230376E-01, 6.4078187348E-01],
	[1.3930000000E+04, 5.9340747497E+00, 5.4098491336E+00, 4.2616066065E-01, 3.7038420066E-01, 6.4091485618E-01],
	[1.3935000000E+04, 5.9369873895E+00, 5.4094751936E+00, 4.2664061567E-01, 3.7075629722E-01, 6.4104780875E-01],
	[1.3940000000E+04, 5.9399004131E+00, 5.4091014136E+00, 4.2712093827E-01, 3.7112859338E-01, 6.4118073117E-01],
	[1.3945000000E+04, 5.9428138207E+00, 5.4087277934E+00, 4.2760162859E-01, 3.7150108910E-01, 6.4131362343E-01],
	[1.3950000000E+04, 5.9457276120E+00, 5.4083543330E+00, 4.2808268677E-01, 3.7187378434E-01, 6.4144648552E-01],
	[1.3955000000E+04, 5.9486417870E+00, 5.4079810321E+00, 4.2856411298E-01, 3.7224667906E-01, 6.4157931744E-01],
	[1.3960000000E+04, 5.9515563457E+00, 5.4076078908E+00, 4.2904590734E-01, 3.7261977321E-01, 6.4171211917E-01],
	[1.3965000000E+04, 5.9544712878E+00, 5.4072349088E+00, 4.2952807003E-01, 3.7299306674E-01, 6.4184489071E-01],
	[1.3970000000E+04, 5.9573866134E+00, 5.4068620860E+00, 4.3001060117E-01, 3.7336655963E-01, 6.4197763204E-01],
	[1.3975000000E+04, 5.9603023224E+00, 5.4064894223E+00, 4.3049350093E-01, 3.7374025181E-01, 6.4211034316E-01],
	[1.3980000000E+04, 5.9632184146E+00, 5.4061169177E+00, 4.3097676945E-01, 3.7411414324E-01, 6.4224302406E-01],
	[1.3985000000E+04, 5.9661348899E+00, 5.4057445718E+00, 4.3146040688E-01, 3.7448823389E-01, 6.4237567472E-01],
	[1.3990000000E+04, 5.9690517484E+00, 5.4053723847E+00, 4.3194441337E-01, 3.7486252370E-01, 6.4250829514E-01],
	[1.3995000000E+04, 5.9719689899E+00, 5.4050003562E+00, 4.3242878907E-01, 3.7523701264E-01, 6.4264088531E-01],
	[1.4000000000E+04, 5.9748866143E+00, 5.4046284862E+00, 4.3291353413E-01, 3.7561170065E-01, 6.4277344523E-01],
	[1.4005000000E+04, 5.9778046215E+00, 5.4042567746E+00, 4.3339864869E-01, 3.7598658769E-01, 6.4290597487E-01],
	[1.4010000000E+04, 5.9807230114E+00, 5.4038852212E+00, 4.3388413291E-01, 3.7636167373E-01, 6.4303847423E-01],
	[1.4015000000E+04, 5.9836417840E+00, 5.4035138259E+00, 4.3436998694E-01, 3.7673695870E-01, 6.4317094331E-01],
	[1.4020000000E+04, 5.9865609392E+00, 5.4031425886E+00, 4.3485621092E-01, 3.7711244257E-01, 6.4330338209E-01],
	[1.4025000000E+04, 5.9894804769E+00, 5.4027715091E+00, 4.3534280500E-01, 3.7748812529E-01, 6.4343579056E-01],
	[1.4030000000E+04, 5.9924003969E+00, 5.4024005874E+00, 4.3582976933E-01, 3.7786400681E-01, 6.4356816872E-01],
	[1.4035000000E+04, 5.9953206993E+00, 5.4020298233E+00, 4.3631710407E-01, 3.7824008710E-01, 6.4370051656E-01],
	[1.4040000000E+04, 5.9982413839E+00, 5.4016592167E+00, 4.3680480935E-01, 3.7861636610E-01, 6.4383283406E-01],
	[1.4045000000E+04, 6.0011624506E+00, 5.4012887675E+00, 4.3729288533E-01, 3.7899284377E-01, 6.4396512122E-01],
	[1.4050000000E+04, 6.0040838994E+00, 5.4009184755E+00, 4.3778133216E-01, 3.7936952006E-01, 6.4409737803E-01],
	[1.4055000000E+04, 6.0070057301E+00, 5.4005483406E+00, 4.3827014999E-01, 3.7974639493E-01, 6.4422960449E-01],
	[1.4060000000E+04, 6.0099279428E+00, 5.4001783628E+00, 4.3875933897E-01, 3.8012346833E-01, 6.4436180057E-01],
	[1.4065000000E+04, 6.0128505372E+00, 5.3998085418E+00, 4.3924889924E-01, 3.8050074021E-01, 6.4449396627E-01],
	[1.4070000000E+04, 6.0157735133E+00, 5.3994388776E+00, 4.3973883095E-01, 3.8087821054E-01, 6.4462610159E-01],
	[1.4075000000E+04, 6.0186968711E+00, 5.3990693700E+00, 4.4022913426E-01, 3.8125587925E-01, 6.4475820652E-01],
	[1.4080000000E+04, 6.0216206104E+00, 5.3987000189E+00, 4.4071980931E-01, 3.8163374630E-01, 6.4489028104E-01],
	[1.4085000000E+04, 6.0245447311E+00, 5.3983308242E+00, 4.4121085625E-01, 3.8201181166E-01, 6.4502232514E-01],
	[1.4090000000E+04, 6.0274692332E+00, 5.3979617858E+00, 4.4170227523E-01, 3.8239007527E-01, 6.4515433883E-01],
	[1.4095000000E+04, 6.0303941166E+00, 5.3975929036E+00, 4.4219406640E-01, 3.8276853707E-01, 6.4528632209E-01],
	[1.4100000000E+04, 6.0333193812E+00, 5.3972241774E+00, 4.4268622992E-01, 3.8314719704E-01, 6.4541827491E-01],
	[1.4105000000E+04, 6.0362450269E+00, 5.3968556070E+00, 4.4317876592E-01, 3.8352605512E-01, 6.4555019728E-01],
	[1.4110000000E+04, 6.0391710536E+00, 5.3964871925E+00, 4.4367167455E-01, 3.8390511126E-01, 6.4568208919E-01],
	[1.4115000000E+04, 6.0420974612E+00, 5.3961189336E+00, 4.4416495598E-01, 3.8428436541E-01, 6.4581395064E-01],
	[1.4120000000E+04, 6.0450262923E+00, 5.3957524902E+00, 4.4465861034E-01, 3.8466383424E-01, 6.4594578162E-01],
	[1.4125000000E+04, 6.0479618373E+00, 5.3953913440E+00, 4.4515263778E-01, 3.8504355290E-01, 6.4607758212E-01],
	[1.4130000000E+04, 6.0508977681E+00, 5.3950303498E+00, 4.4564703846E-01, 3.8542346964E-01, 6.4620935212E-01],
	[1.4135000000E+04, 6.0538340846E+00, 5.3946695075E+00, 4.4614181252E-01, 3.8580358443E-01, 6.4634109163E-01],
	[1.4140000000E+04, 6.0567707868E+00, 5.3943088169E+00, 4.4663696012E-01, 3.8618389722E-01, 6.4647280063E-01],
	[1.4145000000E+04, 6.0597078746E+00, 5.3939482779E+00, 4.4713248139E-01, 3.8656440795E-01, 6.4660447912E-01],
	[1.4150000000E+04, 6.0626453479E+00, 5.3935878905E+00, 4.4762837650E-01, 3.8694511658E-01, 6.4673612708E-01],
	[1.4155000000E+04, 6.0655832066E+00, 5.3932276544E+00, 4.4812464558E-01, 3.8732602306E-01, 6.4686774452E-01],
	[1.4160000000E+04, 6.0685214506E+00, 5.3928675696E+00, 4.4862128880E-01, 3.8770712735E-01, 6.4699933141E-01],
	[1.4165000000E+04, 6.0714600798E+00, 5.3925076359E+00, 4.4911830629E-01, 3.8808842939E-01, 6.4713088775E-01],
	[1.4170000000E+04, 6.0743990942E+00, 5.3921478533E+00, 4.4961569821E-01, 3.8846992914E-01, 6.4726241353E-01],
	[1.4175000000E+04, 6.0773384937E+00, 5.3917882216E+00, 4.5011346471E-01, 3.8885162655E-01, 6.4739390875E-01],
	[1.4180000000E+04, 6.0802782781E+00, 5.3914287407E+00, 4.5061160594E-01, 3.8923352156E-01, 6.4752537340E-01],
	[1.4185000000E+04, 6.0832184474E+00, 5.3910694105E+00, 4.5111012204E-01, 3.8961561414E-01, 6.4765680747E-01],
	[1.4190000000E+04, 6.0861590016E+00, 5.3907102309E+00, 4.5160901316E-01, 3.8999790423E-01, 6.4778821094E-01],
	[1.4195000000E+04, 6.0890999405E+00, 5.3903512017E+00, 4.5210827946E-01, 3.9038039178E-01, 6.4791958382E-01],
	[1.4200000000E+04, 6.0920412640E+00, 5.3899923229E+00, 4.5260792108E-01, 3.9076307675E-01, 6.4805092609E-01],
	[1.4205000000E+04, 6.0949829720E+00, 5.3896335943E+00, 4.5310793817E-01, 3.9114595908E-01, 6.4818223775E-01],
	[1.4210000000E+04, 6.0979250645E+00, 5.3892750158E+00, 4.5360833089E-01, 3.9152903873E-01, 6.4831351879E-01],
	[1.4215000000E+04, 6.1008675414E+00, 5.3889165873E+00, 4.5410909937E-01, 3.9191231565E-01, 6.4844476920E-01],
	[1.4220000000E+04, 6.1038104026E+00, 5.3885583087E+00, 4.5461024378E-01, 3.9229578978E-01, 6.4857598896E-01],
	[1.4225000000E+04, 6.1067536481E+00, 5.3882001798E+00, 4.5511176425E-01, 3.9267946108E-01, 6.4870717809E-01],
	[1.4230000000E+04, 6.1096972776E+00, 5.3878422006E+00, 4.5561366095E-01, 3.9306332949E-01, 6.4883833656E-01],
	[1.4235000000E+04, 6.1126412912E+00, 5.3874843709E+00, 4.5611593401E-01, 3.9344739498E-01, 6.4896946436E-01],
	[1.4240000000E+04, 6.1155856887E+00, 5.3871266906E+00, 4.5661858359E-01, 3.9383165748E-01, 6.4910056150E-01],
	[1.4245000000E+04, 6.1185304702E+00, 5.3867691597E+00, 4.5712160983E-01, 3.9421611695E-01, 6.4923162796E-01],
	[1.4250000000E+04, 6.1214756354E+00, 5.3864117779E+00, 4.5762501289E-01, 3.9460077334E-01, 6.4936266373E-01],
	[1.4255000000E+04, 6.1244211843E+00, 5.3860545452E+00, 4.5812879292E-01, 3.9498562660E-01, 6.4949366882E-01],
	[1.4260000000E+04, 6.1273671168E+00, 5.3856974614E+00, 4.5863295006E-01, 3.9537067668E-01, 6.4962464320E-01],
	[1.4265000000E+04, 6.1303134329E+00, 5.3853405265E+00, 4.5913748447E-01, 3.9575592352E-01, 6.4975558687E-01],
	[1.4270000000E+04, 6.1332601324E+00, 5.3849837404E+00, 4.5964239629E-01, 3.9614136707E-01, 6.4988649982E-01],
	[1.4275000000E+04, 6.1362072153E+00, 5.3846271028E+00, 4.6014768567E-01, 3.9652700730E-01, 6.5001738205E-01],
	[1.4280000000E+04, 6.1391546815E+00, 5.3842706137E+00, 4.6065335276E-01, 3.9691284413E-01, 6.5014823355E-01],
	[1.4285000000E+04, 6.1421025308E+00, 5.3839142731E+00, 4.6115939772E-01, 3.9729887753E-01, 6.5027905431E-01],
	[1.4290000000E+04, 6.1450507633E+00, 5.3835580807E+00, 4.6166582068E-01, 3.9768510745E-01, 6.5040984431E-01],
	[1.4295000000E+04, 6.1479993788E+00, 5.3832020365E+00, 4.6217262181E-01, 3.9807153382E-01, 6.5054060353E-01],
	[1.4300000000E+04, 6.1509483773E+00, 5.3828461403E+00, 4.6267980124E-01, 3.9845815661E-01, 6.5067133196E-01],
	[1.4305000000E+04, 6.1538977586E+00, 5.3824903920E+00, 4.6318735914E-01, 3.9884497575E-01, 6.5080202960E-01],
	[1.4310000000E+04, 6.1568475227E+00, 5.3821347916E+00, 4.6369529564E-01, 3.9923199120E-01, 6.5093269642E-01],
	[1.4315000000E+04, 6.1597976695E+00, 5.3817793389E+00, 4.6420361090E-01, 3.9961920291E-01, 6.5106333241E-01],
	[1.4320000000E+04, 6.1627481988E+00, 5.3814240337E+00, 4.6471230507E-01, 4.0000661081E-01, 6.5119393757E-01],
	[1.4325000000E+04, 6.1656991108E+00, 5.3810688761E+00, 4.6522137829E-01, 4.0039421488E-01, 6.5132451188E-01],
	[1.4330000000E+04, 6.1686504051E+00, 5.3807138658E+00, 4.6573083072E-01, 4.0078201504E-01, 6.5145505532E-01],
	[1.4335000000E+04, 6.1716020818E+00, 5.3803590028E+00, 4.6624066251E-01, 4.0117001125E-01, 6.5158556790E-01],
	[1.4340000000E+04, 6.1745541408E+00, 5.3800042869E+00, 4.6675087380E-01, 4.0155820345E-01, 6.5171604959E-01],
	[1.4345000000E+04, 6.1775065820E+00, 5.3796497181E+00, 4.6726146474E-01, 4.0194659160E-01, 6.5184650038E-01],
	[1.4350000000E+04, 6.1804662573E+00, 5.3793005278E+00, 4.6777243549E-01, 4.0233523394E-01, 6.5197692027E-01],
	[1.4355000000E+04, 6.1834281924E+00, 5.3789529115E+00, 4.6828378619E-01, 4.0272408826E-01, 6.5210730924E-01],
	[1.4360000000E+04, 6.1863905147E+00, 5.3786054387E+00, 4.6879551699E-01, 4.0311313860E-01, 6.5223766727E-01],
	[1.4365000000E+04, 6.1893532241E+00, 5.3782581093E+00, 4.6930762805E-01, 4.0350238490E-01, 6.5236799437E-01],
	[1.4370000000E+04, 6.1923163207E+00, 5.3779109232E+00, 4.6982011950E-01, 4.0389182712E-01, 6.5249829051E-01],
	[1.4375000000E+04, 6.1952798042E+00, 5.3775638802E+00, 4.7033299151E-01, 4.0428146519E-01, 6.5262855568E-01],
	[1.4380000000E+04, 6.1982436746E+00, 5.3772169804E+00, 4.7084624422E-01, 4.0467129907E-01, 6.5275878987E-01],
	[1.4385000000E+04, 6.2012079319E+00, 5.3768702235E+00, 4.7135987778E-01, 4.0506132871E-01, 6.5288899308E-01],
	[1.4390000000E+04, 6.2041725759E+00, 5.3765236094E+00, 4.7187389234E-01, 4.0545155404E-01, 6.5301916528E-01],
	[1.4395000000E+04, 6.2071376065E+00, 5.3761771381E+00, 4.7238828805E-01, 4.0584197502E-01, 6.5314930647E-01],
	[1.4400000000E+04, 6.2101030238E+00, 5.3758308095E+00, 4.7290306505E-01, 4.0623259160E-01, 6.5327941664E-01],
	[1.4405000000E+04, 6.2130688275E+00, 5.3754846233E+00, 4.7341822350E-01, 4.0662340372E-01, 6.5340949578E-01],
	[1.4410000000E+04, 6.2160350176E+00, 5.3751385796E+00, 4.7393376356E-01, 4.0701441132E-01, 6.5353954387E-01],
	[1.4415000000E+04, 6.2190015941E+00, 5.3747926782E+00, 4.7444968535E-01, 4.0740561436E-01, 6.5366956090E-01],
	[1.4420000000E+04, 6.2219685568E+00, 5.3744469190E+00, 4.7496598905E-01, 4.0779701278E-01, 6.5379954686E-01],
	[1.4425000000E+04, 6.2249359056E+00, 5.3741013020E+00, 4.7548267479E-01, 4.0818860653E-01, 6.5392950174E-01],
	[1.4430000000E+04, 6.2279036405E+00, 5.3737558269E+00, 4.7599974273E-01, 4.0858039555E-01, 6.5405942553E-01],
	[1.4435000000E+04, 6.2308717615E+00, 5.3734104937E+00, 4.7651719301E-01, 4.0897237979E-01, 6.5418931822E-01],
	[1.4440000000E+04, 6.2338402683E+00, 5.3730653022E+00, 4.7703502579E-01, 4.0936455919E-01, 6.5431917979E-01],
	[1.4445000000E+04, 6.2368091609E+00, 5.3727202525E+00, 4.7755324121E-01, 4.0975693371E-01, 6.5444901024E-01],
	[1.4450000000E+04, 6.2397784393E+00, 5.3723753443E+00, 4.7807183942E-01, 4.1014950328E-01, 6.5457880955E-01],
	[1.4455000000E+04, 6.2427481033E+00, 5.3720305775E+00, 4.7859082058E-01, 4.1054226785E-01, 6.5470857772E-01],
	[1.4460000000E+04, 6.2457181529E+00, 5.3716859521E+00, 4.7911018483E-01, 4.1093522737E-01, 6.5483831473E-01],
	[1.4465000000E+04, 6.2486885880E+00, 5.3713414680E+00, 4.7962993233E-01, 4.1132838179E-01, 6.5496802057E-01],
	[1.4470000000E+04, 6.2516594084E+00, 5.3709971249E+00, 4.8015006321E-01, 4.1172173104E-01, 6.5509769523E-01],
	[1.4475000000E+04, 6.2546306142E+00, 5.3706529229E+00, 4.8067057764E-01, 4.1211527507E-01, 6.5522733870E-01],
	[1.4480000000E+04, 6.2576022053E+00, 5.3703088619E+00, 4.8119147576E-01, 4.1250901384E-01, 6.5535695096E-01],
	[1.4485000000E+04, 6.2605741815E+00, 5.3699649416E+00, 4.8171275772E-01, 4.1290294727E-01, 6.5548653202E-01],
	[1.4490000000E+04, 6.2635465428E+00, 5.3696211621E+00, 4.8223442367E-01, 4.1329707533E-01, 6.5561608185E-01],
	[1.4495000000E+04, 6.2665192890E+00, 5.3692775231E+00, 4.8275647377E-01, 4.1369139794E-01, 6.5574560044E-01],
	[1.4500000000E+04, 6.2694924202E+00, 5.3689340247E+00, 4.8327890815E-01, 4.1408591507E-01, 6.5587508779E-01],
	[1.4505000000E+04, 6.2724659362E+00, 5.3685906666E+00, 4.8380172697E-01, 4.1448062665E-01, 6.5600454389E-01],
	[1.4510000000E+04, 6.2754398369E+00, 5.3682474488E+00, 4.8432493038E-01, 4.1487553262E-01, 6.5613396872E-01],
	[1.4515000000E+04, 6.2784141223E+00, 5.3679043712E+00, 4.8484851853E-01, 4.1527063293E-01, 6.5626336227E-01],
	[1.4520000000E+04, 6.2813887922E+00, 5.3675614337E+00, 4.8537249157E-01, 4.1566592753E-01, 6.5639272453E-01],
	[1.4525000000E+04, 6.2843638467E+00, 5.3672186362E+00, 4.8589684965E-01, 4.1606141636E-01, 6.5652205550E-01],
	[1.4530000000E+04, 6.2873392855E+00, 5.3668759785E+00, 4.8642159291E-01, 4.1645709935E-01, 6.5665135515E-01],
	[1.4535000000E+04, 6.2903151087E+00, 5.3665334606E+00, 4.8694672151E-01, 4.1685297647E-01, 6.5678062349E-01],
	[1.4540000000E+04, 6.2932913161E+00, 5.3661910823E+00, 4.8747223560E-01, 4.1724904764E-01, 6.5690986050E-01],
	[1.4545000000E+04, 6.2962679077E+00, 5.3658488436E+00, 4.8799813533E-01, 4.1764531282E-01, 6.5703906616E-01],
	[1.4550000000E+04, 6.2992448834E+00, 5.3655067443E+00, 4.8852442084E-01, 4.1804177195E-01, 6.5716824048E-01],
	[1.4555000000E+04, 6.3022222431E+00, 5.3651647843E+00, 4.8905109229E-01, 4.1843842497E-01, 6.5729738343E-01],
	[1.4560000000E+04, 6.3051999866E+00, 5.3648229636E+00, 4.8957814983E-01, 4.1883527182E-01, 6.5742649501E-01],
	[1.4565000000E+04, 6.3081781140E+00, 5.3644812821E+00, 4.9010559360E-01, 4.1923231244E-01, 6.5755557521E-01],
	[1.4570000000E+04, 6.3111566252E+00, 5.3641397395E+00, 4.9063342376E-01, 4.1962954679E-01, 6.5768462401E-01],
	[1.4575000000E+04, 6.3141355200E+00, 5.3637983359E+00, 4.9116164045E-01, 4.2002697480E-01, 6.5781364141E-01],
	[1.4580000000E+04, 6.3171202001E+00, 5.3634609521E+00, 4.9169024382E-01, 4.2042464419E-01, 6.5794262740E-01],
	[1.4585000000E+04, 6.3201089464E+00, 5.3631263475E+00, 4.9221923404E-01, 4.2082253985E-01, 6.5807158197E-01],
	[1.4590000000E+04, 6.3230980817E+00, 5.3627918784E+00, 4.9274861123E-01, 4.2122062925E-01, 6.5820050510E-01],
	[1.4595000000E+04, 6.3260876057E+00, 5.3624575448E+00, 4.9327837556E-01, 4.2161891232E-01, 6.5832939679E-01],
	[1.4600000000E+04, 6.3290775185E+00, 5.3621233466E+00, 4.9380852718E-01, 4.2201738902E-01, 6.5845825702E-01],
	[1.4605000000E+04, 6.3320678199E+00, 5.3617892836E+00, 4.9433906622E-01, 4.2241605928E-01, 6.5858708579E-01],
	[1.4610000000E+04, 6.3350585098E+00, 5.3614553557E+00, 4.9486999286E-01, 4.2281492304E-01, 6.5871588308E-01],
	[1.4615000000E+04, 6.3380495883E+00, 5.3611215629E+00, 4.9540130722E-01, 4.2321398025E-01, 6.5884464889E-01],
	[1.4620000000E+04, 6.3410410551E+00, 5.3607879051E+00, 4.9593300947E-01, 4.2361323086E-01, 6.5897338321E-01],
	[1.4625000000E+04, 6.3440329102E+00, 5.3604543821E+00, 4.9646509975E-01, 4.2401267479E-01, 6.5910208602E-01],
	[1.4630000000E+04, 6.3470251535E+00, 5.3601209938E+00, 4.9699757821E-01, 4.2441231200E-01, 6.5923075732E-01],
	[1.4635000000E+04, 6.3500177850E+00, 5.3597877402E+00, 4.9753044501E-01, 4.2481214243E-01, 6.5935939709E-01],
	[1.4640000000E+04, 6.3530108046E+00, 5.3594546211E+00, 4.9806370029E-01, 4.2521216601E-01, 6.5948800533E-01],
	[1.4645000000E+04, 6.3560042121E+00, 5.3591216365E+00, 4.9859734420E-01, 4.2561238270E-01, 6.5961658202E-01],
	[1.4650000000E+04, 6.3589980075E+00, 5.3587887862E+00, 4.9913137689E-01, 4.2601279243E-01, 6.5974512716E-01],
	[1.4655000000E+04, 6.3619921907E+00, 5.3584560701E+00, 4.9966579851E-01, 4.2641339514E-01, 6.5987364073E-01],
	[1.4660000000E+04, 6.3649867617E+00, 5.3581234882E+00, 5.0020060922E-01, 4.2681419077E-01, 6.6000212273E-01],
	[1.4665000000E+04, 6.3679817203E+00, 5.3577910404E+00, 5.0073580915E-01, 4.2721517927E-01, 6.6013057315E-01],
	[1.4670000000E+04, 6.3709770664E+00, 5.3574587265E+00, 5.0127139847E-01, 4.2761636058E-01, 6.6025899198E-01],
	[1.4675000000E+04, 6.3739728001E+00, 5.3571265464E+00, 5.0180737732E-01, 4.2801773464E-01, 6.6038737920E-01],
	[1.4680000000E+04, 6.3769689211E+00, 5.3567945001E+00, 5.0234374585E-01, 4.2841930139E-01, 6.6051573481E-01],
	[1.4685000000E+04, 6.3799654295E+00, 5.3564625874E+00, 5.0288050421E-01, 4.2882106077E-01, 6.6064405879E-01],
	[1.4690000000E+04, 6.3829623251E+00, 5.3561308083E+00, 5.0341765255E-01, 4.2922301272E-01, 6.6077235115E-01],
	[1.4695000000E+04, 6.3859596079E+00, 5.3557991626E+00, 5.0395519102E-01, 4.2962515718E-01, 6.6090061186E-01],
	[1.4700000000E+04, 6.3889572777E+00, 5.3554676503E+00, 5.0449311977E-01, 4.3002749409E-01, 6.6102884092E-01],
	[1.4705000000E+04, 6.3919553346E+00, 5.3551362712E+00, 5.0503143896E-01, 4.3043002340E-01, 6.6115703833E-01],
	[1.4710000000E+04, 6.3949537783E+00, 5.3548050252E+00, 5.0557014872E-01, 4.3083274504E-01, 6.6128520406E-01],
	[1.4715000000E+04, 6.3979526089E+00, 5.3544739124E+00, 5.0610924921E-01, 4.3123565895E-01, 6.6141333811E-01],
	[1.4720000000E+04, 6.4009518262E+00, 5.3541429324E+00, 5.0664874058E-01, 4.3163876508E-01, 6.6154144047E-01],
	[1.4725000000E+04, 6.4039514302E+00, 5.3538120854E+00, 5.0718862298E-01, 4.3204206336E-01, 6.6166951114E-01],
	[1.4730000000E+04, 6.4069514208E+00, 5.3534813710E+00, 5.0772889657E-01, 4.3244555373E-01, 6.6179755009E-01],
	[1.4735000000E+04, 6.4099517979E+00, 5.3531507894E+00, 5.0826956148E-01, 4.3284923614E-01, 6.6192555733E-01],
	[1.4740000000E+04, 6.4129525614E+00, 5.3528203403E+00, 5.0881061787E-01, 4.3325311052E-01, 6.6205353285E-01],
	[1.4745000000E+04, 6.4159537113E+00, 5.3524900237E+00, 5.0935206589E-01, 4.3365717681E-01, 6.6218147663E-01],
	[1.4750000000E+04, 6.4189552474E+00, 5.3521598394E+00, 5.0989390569E-01, 4.3406143496E-01, 6.6230938866E-01],
	[1.4755000000E+04, 6.4219571697E+00, 5.3518297874E+00, 5.1043613742E-01, 4.3446588489E-01, 6.6243726894E-01],
	[1.4760000000E+04, 6.4249594781E+00, 5.3514998675E+00, 5.1097876123E-01, 4.3487052656E-01, 6.6256511745E-01],
	[1.4765000000E+04, 6.4279621725E+00, 5.3511700798E+00, 5.1152177727E-01, 4.3527535990E-01, 6.6269293419E-01],
	[1.4770000000E+04, 6.4309652528E+00, 5.3508404240E+00, 5.1206518569E-01, 4.3568038485E-01, 6.6282071916E-01],
	[1.4775000000E+04, 6.4339687190E+00, 5.3505109001E+00, 5.1260898663E-01, 4.3608560134E-01, 6.6294847233E-01],
	[1.4780000000E+04, 6.4369725710E+00, 5.3501815079E+00, 5.1315318026E-01, 4.3649100932E-01, 6.6307619370E-01],
	[1.4785000000E+04, 6.4399768086E+00, 5.3498522475E+00, 5.1369776672E-01, 4.3689660873E-01, 6.6320388326E-01],
	[1.4790000000E+04, 6.4429814319E+00, 5.3495231186E+00, 5.1424274615E-01, 4.3730239950E-01, 6.6333154100E-01],
	[1.4795000000E+04, 6.4459864407E+00, 5.3491941212E+00, 5.1478811872E-01, 4.3770838157E-01, 6.6345916692E-01],
	[1.4800000000E+04, 6.4489918349E+00, 5.3488652552E+00, 5.1533388456E-01, 4.3811455488E-01, 6.6358676100E-01],
	[1.4805000000E+04, 6.4519976146E+00, 5.3485365205E+00, 5.1588004383E-01, 4.3852091938E-01, 6.6371432323E-01],
	[1.4810000000E+04, 6.4550037795E+00, 5.3482079170E+00, 5.1642659668E-01, 4.3892747499E-01, 6.6384185361E-01],
	[1.4815000000E+04, 6.4580165681E+00, 5.3478836667E+00, 5.1697354327E-01, 4.3933427902E-01, 6.6396935213E-01],
	[1.4820000000E+04, 6.4610329483E+00, 5.3475617119E+00, 5.1752088373E-01, 4.3974130370E-01, 6.6409681878E-01],
	[1.4825000000E+04, 6.4640497192E+00, 5.3472398851E+00, 5.1806861822E-01, 4.4014851957E-01, 6.6422425354E-01],
	[1.4830000000E+04, 6.4670668807E+00, 5.3469181862E+00, 5.1861674689E-01, 4.4055592656E-01, 6.6435165642E-01],
	[1.4835000000E+04, 6.4700844326E+00, 5.3465966151E+00, 5.1916526989E-01, 4.4096352462E-01, 6.6447902740E-01],
	[1.4840000000E+04, 6.4731023750E+00, 5.3462751716E+00, 5.1971418736E-01, 4.4137131368E-01, 6.6460636648E-01],
	[1.4845000000E+04, 6.4761207078E+00, 5.3459538558E+00, 5.2026349947E-01, 4.4177929369E-01, 6.6473367363E-01],
	[1.4850000000E+04, 6.4791394308E+00, 5.3456326675E+00, 5.2081320636E-01, 4.4218746457E-01, 6.6486094887E-01],
	[1.4855000000E+04, 6.4821585439E+00, 5.3453116065E+00, 5.2136330818E-01, 4.4259582626E-01, 6.6498819217E-01],
	[1.4860000000E+04, 6.4851780472E+00, 5.3449906729E+00, 5.2191380507E-01, 4.4300437871E-01, 6.6511540353E-01],
	[1.4865000000E+04, 6.4881979405E+00, 5.3446698666E+00, 5.2246469720E-01, 4.4341312185E-01, 6.6524258294E-01],
	[1.4870000000E+04, 6.4912182237E+00, 5.3443491873E+00, 5.2301598471E-01, 4.4382205562E-01, 6.6536973039E-01],
	[1.4875000000E+04, 6.4942388968E+00, 5.3440286351E+00, 5.2356766774E-01, 4.4423117996E-01, 6.6549684587E-01],
	[1.4880000000E+04, 6.4972599596E+00, 5.3437082099E+00, 5.2411974646E-01, 4.4464049479E-01, 6.6562392938E-01],
	[1.4885000000E+04, 6.5002814121E+00, 5.3433879115E+00, 5.2467222101E-01, 4.4505000007E-01, 6.6575098091E-01],
	[1.4890000000E+04, 6.5033032543E+00, 5.3430677399E+00, 5.2522509154E-01, 4.4545969572E-01, 6.6587800044E-01],
	[1.4895000000E+04, 6.5063254860E+00, 5.3427476949E+00, 5.2577835819E-01, 4.4586958168E-01, 6.6600498797E-01],
	[1.4900000000E+04, 6.5093481071E+00, 5.3424277765E+00, 5.2633202113E-01, 4.4627965789E-01, 6.6613194349E-01],
	[1.4905000000E+04, 6.5123711176E+00, 5.3421079846E+00, 5.2688608050E-01, 4.4668992429E-01, 6.6625886700E-01],
	[1.4910000000E+04, 6.5153945174E+00, 5.3417883191E+00, 5.2744053645E-01, 4.4710038081E-01, 6.6638575848E-01],
	[1.4915000000E+04, 6.5184183064E+00, 5.3414687799E+00, 5.2799538913E-01, 4.4751102739E-01, 6.6651261792E-01],
	[1.4920000000E+04, 6.5214424845E+00, 5.3411493669E+00, 5.2855063870E-01, 4.4792186396E-01, 6.6663944533E-01],
	[1.4925000000E+04, 6.5244670517E+00, 5.3408300800E+00, 5.2910628529E-01, 4.4833289046E-01, 6.6676624068E-01],
	[1.4930000000E+04, 6.5274920078E+00, 5.3405109192E+00, 5.2966232906E-01, 4.4874410684E-01, 6.6689300397E-01],
	[1.4935000000E+04, 6.5305173528E+00, 5.3401918842E+00, 5.3021877017E-01, 4.4915551301E-01, 6.6701973520E-01],
	[1.4940000000E+04, 6.5335430866E+00, 5.3398729751E+00, 5.3077560876E-01, 4.4956710892E-01, 6.6714643435E-01],
	[1.4945000000E+04, 6.5365692092E+00, 5.3395541918E+00, 5.3133284498E-01, 4.4997889451E-01, 6.6727310141E-01],
	[1.4950000000E+04, 6.5395957204E+00, 5.3392355341E+00, 5.3189047898E-01, 4.5039086970E-01, 6.6739973639E-01],
	[1.4955000000E+04, 6.5426226202E+00, 5.3389170020E+00, 5.3244851092E-01, 4.5080303445E-01, 6.6752633926E-01],
	[1.4960000000E+04, 6.5456499084E+00, 5.3385985953E+00, 5.3300694093E-01, 4.5121538867E-01, 6.6765291003E-01],
	[1.4965000000E+04, 6.5486775851E+00, 5.3382803140E+00, 5.3356576918E-01, 4.5162793231E-01, 6.6777944868E-01],
	[1.4970000000E+04, 6.5517056501E+00, 5.3379621580E+00, 5.3412499582E-01, 4.5204066529E-01, 6.6790595521E-01],
	[1.4975000000E+04, 6.5547341033E+00, 5.3376441273E+00, 5.3468462098E-01, 4.5245358757E-01, 6.6803242961E-01],
	[1.4980000000E+04, 6.5577629448E+00, 5.3373262216E+00, 5.3524464483E-01, 4.5286669907E-01, 6.6815887187E-01],
	[1.4985000000E+04, 6.5607921742E+00, 5.3370084409E+00, 5.3580506752E-01, 4.5327999972E-01, 6.6828528198E-01],
	[1.4990000000E+04, 6.5638217917E+00, 5.3366907852E+00, 5.3636588918E-01, 4.5369348946E-01, 6.6841165993E-01],
	[1.4995000000E+04, 6.5668517972E+00, 5.3363732543E+00, 5.3692710998E-01, 4.5410716823E-01, 6.6853800572E-01],
	[1.5000000000E+04, 6.5698821905E+00, 5.3360558481E+00, 5.3748873007E-01, 4.5452103595E-01, 6.6866431934E-01],
	[1.5005000000E+04, 6.5729129715E+00, 5.3357385666E+00, 5.3805318051E-01, 4.5493683047E-01, 6.6879060078E-01],
	[1.5010000000E+04, 6.5759441402E+00, 5.3354214097E+00, 5.3861803492E-01, 4.5535281600E-01, 6.6891685004E-01],
	[1.5015000000E+04, 6.5789756966E+00, 5.3351043772E+00, 5.3918329345E-01, 4.5576899250E-01, 6.6904306710E-01],
	[1.5020000000E+04, 6.5820076404E+00, 5.3347874692E+00, 5.3974895626E-01, 4.5618535989E-01, 6.6916925196E-01],
	[1.5025000000E+04, 6.5850399718E+00, 5.3344706854E+00, 5.4031502351E-01, 4.5660191810E-01, 6.6929540460E-01],
	[1.5030000000E+04, 6.5880726905E+00, 5.3341540258E+00, 5.4088149534E-01, 4.5701866708E-01, 6.6942152503E-01],
	[1.5035000000E+04, 6.5911057965E+00, 5.3338374903E+00, 5.4144837191E-01, 4.5743560675E-01, 6.6954761324E-01],
	[1.5040000000E+04, 6.5941392896E+00, 5.3335210789E+00, 5.4201565338E-01, 4.5785273705E-01, 6.6967366921E-01],
	[1.5045000000E+04, 6.5971731700E+00, 5.3332047914E+00, 5.4258333989E-01, 4.5827005790E-01, 6.6979969295E-01],
	[1.5050000000E+04, 6.6002074374E+00, 5.3328886277E+00, 5.4315143161E-01, 4.5868756925E-01, 6.6992568443E-01],
	[1.5055000000E+04, 6.6032515911E+00, 5.3325786704E+00, 5.4371992868E-01, 4.5910536204E-01, 6.7005164366E-01],
	[1.5060000000E+04, 6.6062964191E+00, 5.3322690143E+00, 5.4428883126E-01, 4.5952334815E-01, 6.7017757063E-01],
	[1.5065000000E+04, 6.6093416396E+00, 5.3319594790E+00, 5.4485813951E-01, 4.5994152483E-01, 6.7030346531E-01],
	[1.5070000000E+04, 6.6123872526E+00, 5.3316500643E+00, 5.4542785358E-01, 4.6035989200E-01, 6.7042932770E-01],
	[1.5075000000E+04, 6.6154332581E+00, 5.3313407703E+00, 5.4599797361E-01, 4.6077844961E-01, 6.7055515779E-01],
	[1.5080000000E+04, 6.6184796558E+00, 5.3310315967E+00, 5.4656849978E-01, 4.6119719758E-01, 6.7068095556E-01],
	[1.5085000000E+04, 6.6215264458E+00, 5.3307225436E+00, 5.4713943222E-01, 4.6161613585E-01, 6.7080672101E-01],
	[1.5090000000E+04, 6.6245736280E+00, 5.3304136108E+00, 5.4771077110E-01, 4.6203526434E-01, 6.7093245412E-01],
	[1.5095000000E+04, 6.6276212023E+00, 5.3301047982E+00, 5.4828251657E-01, 4.6245458301E-01, 6.7105815488E-01],
	[1.5100000000E+04, 6.6306691686E+00, 5.3297961058E+00, 5.4885466878E-01, 4.6287409176E-01, 6.7118382329E-01],
	[1.5105000000E+04, 6.6337175269E+00, 5.3294875334E+00, 5.4942722788E-01, 4.6329379055E-01, 6.7130945933E-01],
	[1.5110000000E+04, 6.6367662769E+00, 5.3291790811E+00, 5.5000019404E-01, 4.6371367929E-01, 6.7143506300E-01],
	[1.5115000000E+04, 6.6398154188E+00, 5.3288707486E+00, 5.5057356740E-01, 4.6413375793E-01, 6.7156063427E-01],
	[1.5120000000E+04, 6.6428649524E+00, 5.3285625359E+00, 5.5114734812E-01, 4.6455402639E-01, 6.7168617315E-01],
	[1.5125000000E+04, 6.6459148776E+00, 5.3282544430E+00, 5.5172153635E-01, 4.6497448461E-01, 6.7181167962E-01],
	[1.5130000000E+04, 6.6489651943E+00, 5.3279464697E+00, 5.5229613225E-01, 4.6539513252E-01, 6.7193715367E-01],
	[1.5135000000E+04, 6.6520159025E+00, 5.3276386159E+00, 5.5287113597E-01, 4.6581597005E-01, 6.7206259529E-01],
	[1.5140000000E+04, 6.6550670020E+00, 5.3273308816E+00, 5.5344654767E-01, 4.6623699713E-01, 6.7218800447E-01],
	[1.5145000000E+04, 6.6581184929E+00, 5.3270232667E+00, 5.5402236749E-01, 4.6665821369E-01, 6.7231338119E-01],
	[1.5150000000E+04, 6.6611703750E+00, 5.3267157711E+00, 5.5459859560E-01, 4.6707961967E-01, 6.7243872546E-01],
	[1.5155000000E+04, 6.6642226482E+00, 5.3264083947E+00, 5.5517523215E-01, 4.6750121500E-01, 6.7256403726E-01],
	[1.5160000000E+04, 6.6672753125E+00, 5.3261011374E+00, 5.5575227728E-01, 4.6792299960E-01, 6.7268931657E-01],
	[1.5165000000E+04, 6.6703283678E+00, 5.3257939992E+00, 5.5632973117E-01, 4.6834497341E-01, 6.7281456340E-01],
	[1.5170000000E+04, 6.6733818139E+00, 5.3254869799E+00, 5.5690759395E-01, 4.6876713637E-01, 6.7293977772E-01],
	[1.5175000000E+04, 6.6764356510E+00, 5.3251800795E+00, 5.5748586578E-01, 4.6918948839E-01, 6.7306495953E-01],
	[1.5180000000E+04, 6.6794898787E+00, 5.3248732978E+00, 5.5806454683E-01, 4.6961202942E-01, 6.7319010882E-01],
	[1.5185000000E+04, 6.6825444971E+00, 5.3245666349E+00, 5.5864363724E-01, 4.7003475937E-01, 6.7331522558E-01],
	[1.5190000000E+04, 6.6855995062E+00, 5.3242600905E+00, 5.5922313716E-01, 4.7045767820E-01, 6.7344030980E-01],
	[1.5195000000E+04, 6.6886549057E+00, 5.3239536647E+00, 5.5980304675E-01, 4.7088078581E-01, 6.7356536147E-01],
	[1.5200000000E+04, 6.6917106957E+00, 5.3236473573E+00, 5.6038336617E-01, 4.7130408215E-01, 6.7369038057E-01],
	[1.5205000000E+04, 6.6947668760E+00, 5.3233411683E+00, 5.6096409557E-01, 4.7172756715E-01, 6.7381536711E-01],
	[1.5210000000E+04, 6.6978234466E+00, 5.3230350976E+00, 5.6154523510E-01, 4.7215124073E-01, 6.7394032106E-01],
	[1.5215000000E+04, 6.7008804074E+00, 5.3227291450E+00, 5.6212678492E-01, 4.7257510282E-01, 6.7406524242E-01],
	[1.5220000000E+04, 6.7039377583E+00, 5.3224233106E+00, 5.6270874518E-01, 4.7299915336E-01, 6.7419013118E-01],
	[1.5225000000E+04, 6.7069954993E+00, 5.3221175941E+00, 5.6329111604E-01, 4.7342339228E-01, 6.7431498733E-01],
	[1.5230000000E+04, 6.7100536302E+00, 5.3218119956E+00, 5.6387389764E-01, 4.7384781950E-01, 6.7443981086E-01],
	[1.5235000000E+04, 6.7131121510E+00, 5.3215065150E+00, 5.6445709015E-01, 4.7427243495E-01, 6.7456460176E-01],
	[1.5240000000E+04, 6.7161710616E+00, 5.3212011521E+00, 5.6504069372E-01, 4.7469723857E-01, 6.7468936002E-01],
	[1.5245000000E+04, 6.7192303620E+00, 5.3208959069E+00, 5.6562470850E-01, 4.7512223028E-01, 6.7481408563E-01],
	[1.5250000000E+04, 6.7222900520E+00, 5.3205907793E+00, 5.6620913465E-01, 4.7554741002E-01, 6.7493877859E-01],
	[1.5255000000E+04, 6.7253501316E+00, 5.3202857692E+00, 5.6679397232E-01, 4.7597277770E-01, 6.7506343887E-01],
	[1.5260000000E+04, 6.7284106006E+00, 5.3199808765E+00, 5.6737922167E-01, 4.7639833327E-01, 6.7518806648E-01],
	[1.5265000000E+04, 6.7314714591E+00, 5.3196761012E+00, 5.6796488285E-01, 4.7682407665E-01, 6.7531266140E-01],
	[1.5270000000E+04, 6.7345327069E+00, 5.3193714432E+00, 5.6855095601E-01, 4.7725000777E-01, 6.7543722362E-01],
	[1.5275000000E+04, 6.7375943440E+00, 5.3190669023E+00, 5.6913744131E-01, 4.7767612655E-01, 6.7556175314E-01],
	[1.5280000000E+04, 6.7406563703E+00, 5.3187624786E+00, 5.6972433890E-01, 4.7810243294E-01, 6.7568624993E-01],
	[1.5285000000E+04, 6.7437187856E+00, 5.3184581718E+00, 5.7031164894E-01, 4.7852892685E-01, 6.7581071401E-01],
	[1.5290000000E+04, 6.7467815900E+00, 5.3181539820E+00, 5.7089937158E-01, 4.7895560821E-01, 6.7593514535E-01],
	[1.5295000000E+04, 6.7498499575E+00, 5.3178530709E+00, 5.7148750697E-01, 4.7938252875E-01, 6.7605954395E-01],
	[1.5300000000E+04, 6.7529236135E+00, 5.3175552661E+00, 5.7207605528E-01, 4.7980968582E-01, 6.7618390979E-01],
	[1.5305000000E+04, 6.7559976643E+00, 5.3172575752E+00, 5.7266501665E-01, 4.8023703041E-01, 6.7630824287E-01],
	[1.5310000000E+04, 6.7590721096E+00, 5.3169599983E+00, 5.7325439124E-01, 4.8066456246E-01, 6.7643254318E-01],
	[1.5315000000E+04, 6.7621469494E+00, 5.3166625351E+00, 5.7384417920E-01, 4.8109228189E-01, 6.7655681070E-01],
	[1.5320000000E+04, 6.7652221836E+00, 5.3163651857E+00, 5.7443438069E-01, 4.8152018863E-01, 6.7668104544E-01],
	[1.5325000000E+04, 6.7682978122E+00, 5.3160679500E+00, 5.7502499586E-01, 4.8194828261E-01, 6.7680524738E-01],
	[1.5330000000E+04, 6.7713738351E+00, 5.3157708278E+00, 5.7561602487E-01, 4.8237656375E-01, 6.7692941651E-01],
	[1.5335000000E+04, 6.7744502521E+00, 5.3154738191E+00, 5.7620746787E-01, 4.8280503199E-01, 6.7705355282E-01],
	[1.5340000000E+04, 6.7775270632E+00, 5.3151769238E+00, 5.7679932501E-01, 4.8323368726E-01, 6.7717765631E-01],
	[1.5345000000E+04, 6.7806042684E+00, 5.3148801419E+00, 5.7739159645E-01, 4.8366252947E-01, 6.7730172696E-01],
	[1.5350000000E+04, 6.7836818675E+00, 5.3145834732E+00, 5.7798428235E-01, 4.8409155856E-01, 6.7742576476E-01],
	[1.5355000000E+04, 6.7867598605E+00, 5.3142869177E+00, 5.7857738285E-01, 4.8452077446E-01, 6.7754976971E-01],
	[1.5360000000E+04, 6.7898382473E+00, 5.3139904753E+00, 5.7917089812E-01, 4.8495017710E-01, 6.7767374180E-01],
	[1.5365000000E+04, 6.7929170278E+00, 5.3136941458E+00, 5.7976482830E-01, 4.8537976639E-01, 6.7779768102E-01],
	[1.5370000000E+04, 6.7959962020E+00, 5.3133979293E+00, 5.8035917355E-01, 4.8580954227E-01, 6.7792158736E-01],
	[1.5375000000E+04, 6.7990757697E+00, 5.3131018257E+00, 5.8095393403E-01, 4.8623950467E-01, 6.7804546081E-01],
	[1.5380000000E+04, 6.8021557309E+00, 5.3128058348E+00, 5.8154910989E-01, 4.8666965351E-01, 6.7816930136E-01],
	[1.5385000000E+04, 6.8052360855E+00, 5.3125099566E+00, 5.8214470129E-01, 4.8709998872E-01, 6.7829310900E-01],
	[1.5390000000E+04, 6.8083168334E+00, 5.3122141911E+00, 5.8274070837E-01, 4.8753051023E-01, 6.7841688373E-01],
	[1.5395000000E+04, 6.8113979746E+00, 5.3119185381E+00, 5.8333713130E-01, 4.8796121796E-01, 6.7854062554E-01],
	[1.5400000000E+04, 6.8144795090E+00, 5.3116229975E+00, 5.8393397023E-01, 4.8839211184E-01, 6.7866433441E-01],
	[1.5405000000E+04, 6.8175614365E+00, 5.3113275693E+00, 5.8453122530E-01, 4.8882319179E-01, 6.7878801034E-01],
	[1.5410000000E+04, 6.8206437570E+00, 5.3110322534E+00, 5.8512889669E-01, 4.8925445775E-01, 6.7891165332E-01],
	[1.5415000000E+04, 6.8237264704E+00, 5.3107370497E+00, 5.8572698454E-01, 4.8968590964E-01, 6.7903526334E-01],
	[1.5420000000E+04, 6.8268095767E+00, 5.3104419581E+00, 5.8632548900E-01, 4.9011754738E-01, 6.7915884039E-01],
	[1.5425000000E+04, 6.8298930758E+00, 5.3101469786E+00, 5.8692441023E-01, 4.9054937091E-01, 6.7928238447E-01],
	[1.5430000000E+04, 6.8329769676E+00, 5.3098521111E+00, 5.8752374839E-01, 4.9098138014E-01, 6.7940589556E-01],
	[1.5435000000E+04, 6.8360612520E+00, 5.3095573555E+00, 5.8812350363E-01, 4.9141357501E-01, 6.7952937366E-01],
	[1.5440000000E+04, 6.8391459290E+00, 5.3092627117E+00, 5.8872367610E-01, 4.9184595544E-01, 6.7965281876E-01],
	[1.5445000000E+04, 6.8422309984E+00, 5.3089681796E+00, 5.8932426596E-01, 4.9227852135E-01, 6.7977623085E-01],
	[1.5450000000E+04, 6.8453164603E+00, 5.3086737592E+00, 5.8992527336E-01, 4.9271127267E-01, 6.7989960992E-01],
	[1.5455000000E+04, 6.8484023145E+00, 5.3083794504E+00, 5.9052669846E-01, 4.9314420934E-01, 6.8002295597E-01],
	[1.5460000000E+04, 6.8514885609E+00, 5.3080852531E+00, 5.9112854141E-01, 4.9357733126E-01, 6.8014626898E-01],
	[1.5465000000E+04, 6.8545751995E+00, 5.3077911673E+00, 5.9173080237E-01, 4.9401063837E-01, 6.8026954895E-01],
	[1.5470000000E+04, 6.8576622302E+00, 5.3074971927E+00, 5.9233348149E-01, 4.9444413059E-01, 6.8039279586E-01],
	[1.5475000000E+04, 6.8607496530E+00, 5.3072033295E+00, 5.9293657892E-01, 4.9487780785E-01, 6.8051600972E-01],
	[1.5480000000E+04, 6.8638374676E+00, 5.3069095775E+00, 5.9354009483E-01, 4.9531167007E-01, 6.8063919051E-01],
	[1.5485000000E+04, 6.8669256741E+00, 5.3066159365E+00, 5.9414402936E-01, 4.9574571718E-01, 6.8076233822E-01],
	[1.5490000000E+04, 6.8700142724E+00, 5.3063224066E+00, 5.9474838267E-01, 4.9617994911E-01, 6.8088545285E-01],
	[1.5495000000E+04, 6.8731032625E+00, 5.3060289877E+00, 5.9535315492E-01, 4.9661436577E-01, 6.8100853438E-01],
	[1.5500000000E+04, 6.8761926441E+00, 5.3057356797E+00, 5.9595834625E-01, 4.9704896709E-01, 6.8113158282E-01],
	[1.5505000000E+04, 6.8792824173E+00, 5.3054424824E+00, 5.9656395683E-01, 4.9748375300E-01, 6.8125459815E-01],
	[1.5510000000E+04, 6.8823725820E+00, 5.3051493959E+00, 5.9716998680E-01, 4.9791872342E-01, 6.8137758036E-01],
	[1.5515000000E+04, 6.8854631381E+00, 5.3048564200E+00, 5.9777643633E-01, 4.9835387828E-01, 6.8150052944E-01],
	[1.5520000000E+04, 6.8885540855E+00, 5.3045635547E+00, 5.9838330556E-01, 4.9878921750E-01, 6.8162344540E-01],
	[1.5525000000E+04, 6.8916454242E+00, 5.3042708000E+00, 5.9899059466E-01, 4.9922474099E-01, 6.8174632821E-01],
	[1.5530000000E+04, 6.8947371540E+00, 5.3039781556E+00, 5.9959830377E-01, 4.9966044870E-01, 6.8186917787E-01],
	[1.5535000000E+04, 6.8978292749E+00, 5.3036856216E+00, 6.0020643305E-01, 5.0009634054E-01, 6.8199199438E-01],
	[1.5540000000E+04, 6.9009246488E+00, 5.3033948692E+00, 6.0081498266E-01, 5.0053244638E-01, 6.8211477773E-01],
	[1.5545000000E+04, 6.9040279108E+00, 5.3031086015E+00, 6.0142395275E-01, 5.0096881479E-01, 6.8223752790E-01],
	[1.5550000000E+04, 6.9071315695E+00, 5.3028224413E+00, 6.0203334347E-01, 5.0140536740E-01, 6.8236024489E-01],
	[1.5555000000E+04, 6.9102356250E+00, 5.3025363885E+00, 6.0264315499E-01, 5.0184210414E-01, 6.8248292870E-01],
	[1.5560000000E+04, 6.9133400771E+00, 5.3022504431E+00, 6.0325338744E-01, 5.0227902493E-01, 6.8260557931E-01],
	[1.5565000000E+04, 6.9164449259E+00, 5.3019646050E+00, 6.0386404100E-01, 5.0271612970E-01, 6.8272819672E-01],
	[1.5570000000E+04, 6.9195501712E+00, 5.3016788741E+00, 6.0447511581E-01, 5.0315341836E-01, 6.8285078091E-01],
	[1.5575000000E+04, 6.9226558129E+00, 5.3013932503E+00, 6.0508661203E-01, 5.0359089085E-01, 6.8297333189E-01],
	[1.5580000000E+04, 6.9257618511E+00, 5.3011077336E+00, 6.0569852981E-01, 5.0402854708E-01, 6.8309584964E-01],
	[1.5585000000E+04, 6.9288682855E+00, 5.3008223238E+00, 6.0631086932E-01, 5.0446638698E-01, 6.8321833416E-01],
	[1.5590000000E+04, 6.9319751161E+00, 5.3005370210E+00, 6.0692363069E-01, 5.0490441047E-01, 6.8334078544E-01],
	[1.5595000000E+04, 6.9350823429E+00, 5.3002518250E+00, 6.0753681409E-01, 5.0534261747E-01, 6.8346320347E-01],
	[1.5600000000E+04, 6.9381899657E+00, 5.2999667358E+00, 6.0815041967E-01, 5.0578100792E-01, 6.8358558824E-01],
	[1.5605000000E+04, 6.9412979845E+00, 5.2996817532E+00, 6.0876444759E-01, 5.0621958172E-01, 6.8370793975E-01],
	[1.5610000000E+04, 6.9444063993E+00, 5.2993968773E+00, 6.0937889800E-01, 5.0665833881E-01, 6.8383025799E-01],
	[1.5615000000E+04, 6.9475152098E+00, 5.2991121079E+00, 6.0999377106E-01, 5.0709727911E-01, 6.8395254295E-01],
	[1.5620000000E+04, 6.9506244162E+00, 5.2988274449E+00, 6.1060906692E-01, 5.0753640253E-01, 6.8407479462E-01],
	[1.5625000000E+04, 6.9537340182E+00, 5.2985428884E+00, 6.1122478573E-01, 5.0797570901E-01, 6.8419701300E-01],
	[1.5630000000E+04, 6.9568440158E+00, 5.2982584382E+00, 6.1184092766E-01, 5.0841519846E-01, 6.8431919808E-01],
	[1.5635000000E+04, 6.9599544089E+00, 5.2979740942E+00, 6.1245749285E-01, 5.0885487081E-01, 6.8444134985E-01],
	[1.5640000000E+04, 6.9630651975E+00, 5.2976898564E+00, 6.1307448146E-01, 5.0929472597E-01, 6.8456346831E-01],
	[1.5645000000E+04, 6.9661763815E+00, 5.2974057247E+00, 6.1369189364E-01, 5.0973476388E-01, 6.8468555344E-01],
	[1.5650000000E+04, 6.9692879608E+00, 5.2971216990E+00, 6.1430972956E-01, 5.1017498445E-01, 6.8480760525E-01],
	[1.5655000000E+04, 6.9723999353E+00, 5.2968377792E+00, 6.1492798936E-01, 5.1061538761E-01, 6.8492962371E-01],
	[1.5660000000E+04, 6.9755123050E+00, 5.2965539654E+00, 6.1554667320E-01, 5.1105597327E-01, 6.8505160884E-01],
	[1.5665000000E+04, 6.9786250697E+00, 5.2962702573E+00, 6.1616578123E-01, 5.1149674136E-01, 6.8517356061E-01],
	[1.5670000000E+04, 6.9817382294E+00, 5.2959866550E+00, 6.1678531361E-01, 5.1193769180E-01, 6.8529547902E-01],
	[1.5675000000E+04, 6.9848517841E+00, 5.2957031583E+00, 6.1740527050E-01, 5.1237882451E-01, 6.8541736407E-01],
	[1.5680000000E+04, 6.9879657336E+00, 5.2954197672E+00, 6.1802565204E-01, 5.1282013942E-01, 6.8553921575E-01],
	[1.5685000000E+04, 6.9910800779E+00, 5.2951364816E+00, 6.1864645840E-01, 5.1326163644E-01, 6.8566103404E-01],
	[1.5690000000E+04, 6.9941948168E+00, 5.2948533015E+00, 6.1926768973E-01, 5.1370331550E-01, 6.8578281895E-01],
	[1.5695000000E+04, 6.9973099504E+00, 5.2945702267E+00, 6.1988934618E-01, 5.1414517651E-01, 6.8590457047E-01],
	[1.5700000000E+04, 7.0004254785E+00, 5.2942872572E+00, 6.2051142791E-01, 5.1458721940E-01, 6.8602628859E-01],
	[1.5705000000E+04, 7.0035414011E+00, 5.2940043930E+00, 6.2113393507E-01, 5.1502944409E-01, 6.8614797330E-01],
	[1.5710000000E+04, 7.0066577181E+00, 5.2937216339E+00, 6.2175686782E-01, 5.1547185050E-01, 6.8626962459E-01],
	[1.5715000000E+04, 7.0097744294E+00, 5.2934389798E+00, 6.2238022631E-01, 5.1591443855E-01, 6.8639124246E-01],
	[1.5720000000E+04, 7.0128915350E+00, 5.2931564308E+00, 6.2300401070E-01, 5.1635720817E-01, 6.8651282691E-01],
	[1.5725000000E+04, 7.0160090347E+00, 5.2928739867E+00, 6.2362822115E-01, 5.1680015926E-01, 6.8663437792E-01],
	[1.5730000000E+04, 7.0191269285E+00, 5.2925916474E+00, 6.2425285780E-01, 5.1724329176E-01, 6.8675589549E-01],
	[1.5735000000E+04, 7.0222452163E+00, 5.2923094129E+00, 6.2487792081E-01, 5.1768660558E-01, 6.8687737961E-01],
	[1.5740000000E+04, 7.0253638980E+00, 5.2920272832E+00, 6.2550341034E-01, 5.1813010064E-01, 6.8699883028E-01],
	[1.5745000000E+04, 7.0284829736E+00, 5.2917452580E+00, 6.2612932654E-01, 5.1857377686E-01, 6.8712024748E-01],
	[1.5750000000E+04, 7.0316024430E+00, 5.2914633375E+00, 6.2675566957E-01, 5.1901763417E-01, 6.8724163122E-01],
	[1.5755000000E+04, 7.0347223061E+00, 5.2911815214E+00, 6.2738243958E-01, 5.1946167248E-01, 6.8736298148E-01],
	[1.5760000000E+04, 7.0378425629E+00, 5.2908998098E+00, 6.2800963673E-01, 5.1990589172E-01, 6.8748429826E-01],
	[1.5765000000E+04, 7.0409632132E+00, 5.2906182025E+00, 6.2863726117E-01, 5.2035029180E-01, 6.8760558156E-01],
	[1.5770000000E+04, 7.0440842570E+00, 5.2903366995E+00, 6.2926531306E-01, 5.2079487264E-01, 6.8772683135E-01],
	[1.5775000000E+04, 7.0472056942E+00, 5.2900553008E+00, 6.2989379255E-01, 5.2123963416E-01, 6.8784804765E-01],
	[1.5780000000E+04, 7.0503275247E+00, 5.2897740061E+00, 6.3052269980E-01, 5.2168457629E-01, 6.8796923044E-01],
	[1.5785000000E+04, 7.0534497485E+00, 5.2894928155E+00, 6.3115203496E-01, 5.2212969893E-01, 6.8809037971E-01],
	[1.5790000000E+04, 7.0565749871E+00, 5.2892131926E+00, 6.3178179818E-01, 5.2257503068E-01, 6.8821149547E-01],
	[1.5795000000E+04, 7.0597086465E+00, 5.2889381519E+00, 6.3241198963E-01, 5.2302063072E-01, 6.8833257769E-01],
	[1.5800000000E+04, 7.0628427051E+00, 5.2886632125E+00, 6.3304260945E-01, 5.2346641136E-01, 6.8845362638E-01],
	[1.5805000000E+04, 7.0659771627E+00, 5.2883883744E+00, 6.3367365781E-01, 5.2391237251E-01, 6.8857464152E-01],
	[1.5810000000E+04, 7.0691120192E+00, 5.2881136375E+00, 6.3430513486E-01, 5.2435851409E-01, 6.8869562309E-01],
	[1.5815000000E+04, 7.0722472746E+00, 5.2878390018E+00, 6.3493704074E-01, 5.2480483602E-01, 6.8881657110E-01],
	[1.5820000000E+04, 7.0753829288E+00, 5.2875644671E+00, 6.3556937562E-01, 5.2525133822E-01, 6.8893748554E-01],
	[1.5825000000E+04, 7.0785189817E+00, 5.2872900334E+00, 6.3620213966E-01, 5.2569802061E-01, 6.8905836638E-01],
	[1.5830000000E+04, 7.0816554333E+00, 5.2870157007E+00, 6.3683533300E-01, 5.2614488311E-01, 6.8917921364E-01],
	[1.5835000000E+04, 7.0847922835E+00, 5.2867414688E+00, 6.3746895581E-01, 5.2659192564E-01, 6.8930002729E-01],
	[1.5840000000E+04, 7.0879295321E+00, 5.2864673377E+00, 6.3810300823E-01, 5.2703914812E-01, 6.8942080733E-01],
	[1.5845000000E+04, 7.0910671792E+00, 5.2861933073E+00, 6.3873749042E-01, 5.2748655046E-01, 6.8954155375E-01],
	[1.5850000000E+04, 7.0942052246E+00, 5.2859193776E+00, 6.3937240254E-01, 5.2793413258E-01, 6.8966226654E-01],
	[1.5855000000E+04, 7.0973436683E+00, 5.2856455485E+00, 6.4000774475E-01, 5.2838189440E-01, 6.8978294569E-01],
	[1.5860000000E+04, 7.1004825102E+00, 5.2853718199E+00, 6.4064351719E-01, 5.2882983585E-01, 6.8990359120E-01],
	[1.5865000000E+04, 7.1036217503E+00, 5.2850981918E+00, 6.4127972002E-01, 5.2927795683E-01, 6.9002420305E-01],
	[1.5870000000E+04, 7.1067613883E+00, 5.2848246640E+00, 6.4191635340E-01, 5.2972625728E-01, 6.9014478125E-01],
	[1.5875000000E+04, 7.1099014244E+00, 5.2845512366E+00, 6.4255341749E-01, 5.3017473709E-01, 6.9026532576E-01],
	[1.5880000000E+04, 7.1130418583E+00, 5.2842779093E+00, 6.4319091243E-01, 5.3062339620E-01, 6.9038583660E-01],
	[1.5885000000E+04, 7.1161826901E+00, 5.2840046823E+00, 6.4382883838E-01, 5.3107223452E-01, 6.9050631375E-01],
	[1.5890000000E+04, 7.1193239196E+00, 5.2837315554E+00, 6.4446719551E-01, 5.3152125197E-01, 6.9062675721E-01],
	[1.5895000000E+04, 7.1224655468E+00, 5.2834585285E+00, 6.4510598396E-01, 5.3197044846E-01, 6.9074716695E-01],
	[1.5900000000E+04, 7.1256075716E+00, 5.2831856016E+00, 6.4574520388E-01, 5.3241982392E-01, 6.9086754299E-01],
	[1.5905000000E+04, 7.1287499940E+00, 5.2829127746E+00, 6.4638485544E-01, 5.3286937826E-01, 6.9098788530E-01],
	[1.5910000000E+04, 7.1318928137E+00, 5.2826400474E+00, 6.4702493879E-01, 5.3331911140E-01, 6.9110819388E-01],
	[1.5915000000E+04, 7.1350360309E+00, 5.2823674200E+00, 6.4766545408E-01, 5.3376902326E-01, 6.9122846873E-01],
	[1.5920000000E+04, 7.1381796453E+00, 5.2820948923E+00, 6.4830640147E-01, 5.3421911375E-01, 6.9134870983E-01],
	[1.5925000000E+04, 7.1413236570E+00, 5.2818224643E+00, 6.4894778111E-01, 5.3466938279E-01, 6.9146891717E-01],
	[1.5930000000E+04, 7.1444680658E+00, 5.2815501358E+00, 6.4958959317E-01, 5.3511983030E-01, 6.9158909075E-01],
	[1.5935000000E+04, 7.1476128718E+00, 5.2812779068E+00, 6.5023183779E-01, 5.3557045619E-01, 6.9170923056E-01],
	[1.5940000000E+04, 7.1507580747E+00, 5.2810057772E+00, 6.5087451512E-01, 5.3602126038E-01, 6.9182933659E-01],
	[1.5945000000E+04, 7.1539036745E+00, 5.2807337470E+00, 6.5151762534E-01, 5.3647224280E-01, 6.9194940883E-01],
	[1.5950000000E+04, 7.1570496712E+00, 5.2804618161E+00, 6.5216116858E-01, 5.3692340334E-01, 6.9206944728E-01],
	[1.5955000000E+04, 7.1601960647E+00, 5.2801899844E+00, 6.5280514501E-01, 5.3737474194E-01, 6.9218945192E-01],
	[1.5960000000E+04, 7.1633428549E+00, 5.2799182519E+00, 6.5344955478E-01, 5.3782625851E-01, 6.9230942275E-01],
	[1.5965000000E+04, 7.1664900417E+00, 5.2796466184E+00, 6.5409439804E-01, 5.3827795296E-01, 6.9242935977E-01],
	[1.5970000000E+04, 7.1696376250E+00, 5.2793750840E+00, 6.5473967496E-01, 5.3872982521E-01, 6.9254926295E-01],
	[1.5975000000E+04, 7.1727856049E+00, 5.2791036486E+00, 6.5538538568E-01, 5.3918187518E-01, 6.9266913230E-01],
	[1.5980000000E+04, 7.1759339812E+00, 5.2788323120E+00, 6.5603153037E-01, 5.3963410278E-01, 6.9278896781E-01],
	[1.5985000000E+04, 7.1790827538E+00, 5.2785610743E+00, 6.5667810917E-01, 5.4008650793E-01, 6.9290876947E-01],
	[1.5990000000E+04, 7.1822319226E+00, 5.2782899353E+00, 6.5732512224E-01, 5.4053909055E-01, 6.9302853727E-01],
	[1.5995000000E+04, 7.1853814877E+00, 5.2780188951E+00, 6.5797256974E-01, 5.4099185054E-01, 6.9314827120E-01],
	[1.6000000000E+04, 7.1885314488E+00, 5.2777479534E+00, 6.5862045182E-01, 5.4144478783E-01, 6.9326797126E-01],
	[1.6005000000E+04, 7.1916818060E+00, 5.2774771103E+00, 6.5926876864E-01, 5.4189790234E-01, 6.9338763744E-01],
	[1.6010000000E+04, 7.1948325592E+00, 5.2772063657E+00, 6.5991752036E-01, 5.4235119397E-01, 6.9350726973E-01],
	[1.6015000000E+04, 7.1979837082E+00, 5.2769357195E+00, 6.6056670712E-01, 5.4280466264E-01, 6.9362686812E-01],
	[1.6020000000E+04, 7.2011352531E+00, 5.2766651717E+00, 6.6121632909E-01, 5.4325830828E-01, 6.9374643261E-01],
	[1.6025000000E+04, 7.2042871937E+00, 5.2763947222E+00, 6.6186638641E-01, 5.4371213078E-01, 6.9386596319E-01],
	[1.6030000000E+04, 7.2074395300E+00, 5.2761243709E+00, 6.6251687925E-01, 5.4416613008E-01, 6.9398545984E-01],
	[1.6035000000E+04, 7.2105922618E+00, 5.2758541177E+00, 6.6316780776E-01, 5.4462030608E-01, 6.9410492257E-01],
	[1.6040000000E+04, 7.2137453892E+00, 5.2755839627E+00, 6.6381917209E-01, 5.4507465869E-01, 6.9422435136E-01],
	[1.6045000000E+04, 7.2169034056E+00, 5.2753163048E+00, 6.6447097240E-01, 5.4552923918E-01, 6.9434374622E-01],
	[1.6050000000E+04, 7.2200682689E+00, 5.2750521854E+00, 6.6512320885E-01, 5.4598406999E-01, 6.9446310712E-01],
	[1.6055000000E+04, 7.2232335335E+00, 5.2747881615E+00, 6.6577588159E-01, 5.4643907750E-01, 6.9458243406E-01],
	[1.6060000000E+04, 7.2263991996E+00, 5.2745242329E+00, 6.6642899078E-01, 5.4689426161E-01, 6.9470172705E-01],
	[1.6065000000E+04, 7.2295652670E+00, 5.2742603998E+00, 6.6708253657E-01, 5.4734962225E-01, 6.9482098606E-01],
	[1.6070000000E+04, 7.2327317356E+00, 5.2739966619E+00, 6.6773651911E-01, 5.4780515932E-01, 6.9494021109E-01],
	[1.6075000000E+04, 7.2358986055E+00, 5.2737330193E+00, 6.6839093857E-01, 5.4826087275E-01, 6.9505940213E-01],
	[1.6080000000E+04, 7.2390658764E+00, 5.2734694718E+00, 6.6904579510E-01, 5.4871676244E-01, 6.9517855918E-01],
	[1.6085000000E+04, 7.2422335483E+00, 5.2732060194E+00, 6.6970108885E-01, 5.4917282832E-01, 6.9529768223E-01],
	[1.6090000000E+04, 7.2454016212E+00, 5.2729426621E+00, 6.7035681997E-01, 5.4962907029E-01, 6.9541677128E-01],
	[1.6095000000E+04, 7.2485700950E+00, 5.2726793997E+00, 6.7101298863E-01, 5.5008548828E-01, 6.9553582631E-01],
	[1.6100000000E+04, 7.2517389695E+00, 5.2724162322E+00, 6.7166959499E-01, 5.5054208219E-01, 6.9565484731E-01],
	[1.6105000000E+04, 7.2549082448E+00, 5.2721531596E+00, 6.7232663918E-01, 5.5099885193E-01, 6.9577383429E-01],
	[1.6110000000E+04, 7.2580779208E+00, 5.2718901818E+00, 6.7298412138E-01, 5.5145579743E-01, 6.9589278723E-01],
	[1.6115000000E+04, 7.2612479973E+00, 5.2716272987E+00, 6.7364204173E-01, 5.5191291860E-01, 6.9601170613E-01],
	[1.6120000000E+04, 7.2644184744E+00, 5.2713645102E+00, 6.7430040039E-01, 5.5237021535E-01, 6.9613059097E-01],
	[1.6125000000E+04, 7.2675893518E+00, 5.2711018164E+00, 6.7495919752E-01, 5.5282768759E-01, 6.9624944177E-01],
	[1.6130000000E+04, 7.2707606297E+00, 5.2708392170E+00, 6.7561843327E-01, 5.5328533525E-01, 6.9636825849E-01],
	[1.6135000000E+04, 7.2739323078E+00, 5.2705767122E+00, 6.7627810779E-01, 5.5374315822E-01, 6.9648704115E-01],
	[1.6140000000E+04, 7.2771043861E+00, 5.2703143017E+00, 6.7693822125E-01, 5.5420115643E-01, 6.9660578972E-01],
	[1.6145000000E+04, 7.2802768646E+00, 5.2700519855E+00, 6.7759877380E-01, 5.5465932980E-01, 6.9672450422E-01],
	[1.6150000000E+04, 7.2834497432E+00, 5.2697897637E+00, 6.7825976559E-01, 5.5511767822E-01, 6.9684318462E-01],
	[1.6155000000E+04, 7.2866230217E+00, 5.2695276360E+00, 6.7892119678E-01, 5.5557620162E-01, 6.9696183092E-01],
	[1.6160000000E+04, 7.2897967002E+00, 5.2692656025E+00, 6.7958306753E-01, 5.5603489991E-01, 6.9708044311E-01],
	[1.6165000000E+04, 7.2929707785E+00, 5.2690036631E+00, 6.8024537799E-01, 5.5649377300E-01, 6.9719902120E-01],
	[1.6170000000E+04, 7.2961452566E+00, 5.2687418177E+00, 6.8090812831E-01, 5.5695282081E-01, 6.9731756517E-01],
	[1.6175000000E+04, 7.2993201344E+00, 5.2684800663E+00, 6.8157131865E-01, 5.5741204324E-01, 6.9743607501E-01],
	[1.6180000000E+04, 7.3024954118E+00, 5.2682184088E+00, 6.8223494917E-01, 5.5787144022E-01, 6.9755455072E-01],
	[1.6185000000E+04, 7.3056710887E+00, 5.2679568451E+00, 6.8289902002E-01, 5.5833101165E-01, 6.9767299229E-01],
	[1.6190000000E+04, 7.3088471652E+00, 5.2676953751E+00, 6.8356353136E-01, 5.5879075745E-01, 6.9779139971E-01],
	[1.6195000000E+04, 7.3120236410E+00, 5.2674339989E+00, 6.8422848334E-01, 5.5925067752E-01, 6.9790977298E-01],
	[1.6200000000E+04, 7.3152005162E+00, 5.2671727164E+00, 6.8489387612E-01, 5.5971077179E-01, 6.9802811210E-01],
	[1.6205000000E+04, 7.3183777906E+00, 5.2669115274E+00, 6.8555970986E-01, 5.6017104016E-01, 6.9814641705E-01],
	[1.6210000000E+04, 7.3215554643E+00, 5.2666504319E+00, 6.8622598470E-01, 5.6063148255E-01, 6.9826468783E-01],
	[1.6215000000E+04, 7.3247335370E+00, 5.2663894299E+00, 6.8689270081E-01, 5.6109209887E-01, 6.9838292443E-01],
	[1.6220000000E+04, 7.3279120088E+00, 5.2661285213E+00, 6.8755985834E-01, 5.6155288903E-01, 6.9850112685E-01],
	[1.6225000000E+04, 7.3310908796E+00, 5.2658677060E+00, 6.8822745745E-01, 5.6201385294E-01, 6.9861929507E-01],
	[1.6230000000E+04, 7.3342701492E+00, 5.2656069841E+00, 6.8889549829E-01, 5.6247499051E-01, 6.9873742910E-01],
	[1.6235000000E+04, 7.3374498177E+00, 5.2653463553E+00, 6.8956398102E-01, 5.6293630167E-01, 6.9885552893E-01],
	[1.6240000000E+04, 7.3406298849E+00, 5.2650858196E+00, 6.9023290579E-01, 5.6339778631E-01, 6.9897359454E-01],
	[1.6245000000E+04, 7.3438103508E+00, 5.2648253771E+00, 6.9090227276E-01, 5.6385944435E-01, 6.9909162595E-01],
	[1.6250000000E+04, 7.3469912154E+00, 5.2645650276E+00, 6.9157208208E-01, 5.6432127570E-01, 6.9920962312E-01],
	[1.6255000000E+04, 7.3501724784E+00, 5.2643047710E+00, 6.9224233391E-01, 5.6478328027E-01, 6.9932758607E-01],
	[1.6260000000E+04, 7.3533541399E+00, 5.2640446074E+00, 6.9291302841E-01, 5.6524545798E-01, 6.9944551479E-01],
	[1.6265000000E+04, 7.3565361998E+00, 5.2637845366E+00, 6.9358416573E-01, 5.6570780873E-01, 6.9956340927E-01],
	[1.6270000000E+04, 7.3597186580E+00, 5.2635245585E+00, 6.9425574603E-01, 5.6617033244E-01, 6.9968126949E-01],
	[1.6275000000E+04, 7.3629015145E+00, 5.2632646732E+00, 6.9492776946E-01, 5.6663302902E-01, 6.9979909547E-01],
	[1.6280000000E+04, 7.3660847691E+00, 5.2630048805E+00, 6.9560023618E-01, 5.6709589838E-01, 6.9991688719E-01],
	[1.6285000000E+04, 7.3692684218E+00, 5.2627451805E+00, 6.9627314634E-01, 5.6755894043E-01, 7.0003464464E-01],
	[1.6290000000E+04, 7.3724524725E+00, 5.2624855729E+00, 6.9694650010E-01, 5.6802215508E-01, 7.0015236782E-01],
	[1.6295000000E+04, 7.3756369212E+00, 5.2622260579E+00, 6.9762029761E-01, 5.6848554224E-01, 7.0027005672E-01],
	[1.6300000000E+04, 7.3788217678E+00, 5.2619666352E+00, 6.9829453904E-01, 5.6894910182E-01, 7.0038771134E-01],
	[1.6305000000E+04, 7.3820155190E+00, 5.2617116498E+00, 6.9896922453E-01, 5.6941293523E-01, 7.0050533168E-01],
	[1.6310000000E+04, 7.3852124072E+00, 5.2614581508E+00, 6.9964435425E-01, 5.6987697381E-01, 7.0062291771E-01],
	[1.6315000000E+04, 7.3884096993E+00, 5.2612047417E+00, 7.0031992834E-01, 5.7034118488E-01, 7.0074046945E-01],
	[1.6320000000E+04, 7.3916073952E+00, 5.2609514224E+00, 7.0099594697E-01, 5.7080556837E-01, 7.0085798688E-01],
	[1.6325000000E+04, 7.3948054950E+00, 5.2606981930E+00, 7.0167241028E-01, 5.7127012417E-01, 7.0097547000E-01],
	[1.6330000000E+04, 7.3980039984E+00, 5.2604450532E+00, 7.0234931844E-01, 5.7173485221E-01, 7.0109291880E-01],
	[1.6335000000E+04, 7.4012029055E+00, 5.2601920032E+00, 7.0302667160E-01, 5.7219975238E-01, 7.0121033327E-01],
	[1.6340000000E+04, 7.4044022162E+00, 5.2599390427E+00, 7.0370446992E-01, 5.7266482461E-01, 7.0132771342E-01],
	[1.6345000000E+04, 7.4076019303E+00, 5.2596861718E+00, 7.0438271355E-01, 5.7313006880E-01, 7.0144505923E-01],
	[1.6350000000E+04, 7.4108020479E+00, 5.2594333904E+00, 7.0506140264E-01, 5.7359548486E-01, 7.0156237070E-01],
	[1.6355000000E+04, 7.4140025688E+00, 5.2591806985E+00, 7.0574053736E-01, 5.7406107271E-01, 7.0167964782E-01],
	[1.6360000000E+04, 7.4172034931E+00, 5.2589280959E+00, 7.0642011786E-01, 5.7452683225E-01, 7.0179689059E-01],
	[1.6365000000E+04, 7.4204048205E+00, 5.2586755826E+00, 7.0710014430E-01, 5.7499276339E-01, 7.0191409900E-01],
	[1.6370000000E+04, 7.4236065510E+00, 5.2584231586E+00, 7.0778061682E-01, 5.7545886604E-01, 7.0203127305E-01],
	[1.6375000000E+04, 7.4268086846E+00, 5.2581708238E+00, 7.0846153559E-01, 5.7592514012E-01, 7.0214841273E-01],
	[1.6380000000E+04, 7.4300112212E+00, 5.2579185781E+00, 7.0914290077E-01, 5.7639158553E-01, 7.0226551804E-01],
	[1.6385000000E+04, 7.4332141608E+00, 5.2576664215E+00, 7.0982471250E-01, 5.7685820218E-01, 7.0238258896E-01],
	[1.6390000000E+04, 7.4364175031E+00, 5.2574143539E+00, 7.1050697094E-01, 5.7732498998E-01, 7.0249962550E-01],
	[1.6395000000E+04, 7.4396212483E+00, 5.2571623753E+00, 7.1118967625E-01, 5.7779194884E-01, 7.0261662765E-01],
	[1.6400000000E+04, 7.4428253961E+00, 5.2569104856E+00, 7.1187282859E-01, 5.7825907867E-01, 7.0273359541E-01],
	[1.6405000000E+04, 7.4460299466E+00, 5.2566586848E+00, 7.1255642811E-01, 5.7872637938E-01, 7.0285052876E-01],
	[1.6410000000E+04, 7.4492348996E+00, 5.2564069727E+00, 7.1324047497E-01, 5.7919385088E-01, 7.0296742770E-01],
	[1.6415000000E+04, 7.4524402551E+00, 5.2561553494E+00, 7.1392496932E-01, 5.7966149308E-01, 7.0308429224E-01],
	[1.6420000000E+04, 7.4556460130E+00, 5.2559038147E+00, 7.1460991132E-01, 5.8012930588E-01, 7.0320112235E-01],
	[1.6425000000E+04, 7.4588521733E+00, 5.2556523686E+00, 7.1529530112E-01, 5.8059728920E-01, 7.0331791804E-01],
	[1.6430000000E+04, 7.4620587358E+00, 5.2554010112E+00, 7.1598113889E-01, 5.8106544294E-01, 7.0343467931E-01],
	[1.6435000000E+04, 7.4652657005E+00, 5.2551497422E+00, 7.1666742477E-01, 5.8153376702E-01, 7.0355140614E-01],
	[1.6440000000E+04, 7.4684730674E+00, 5.2548985616E+00, 7.1735415892E-01, 5.8200226134E-01, 7.0366809853E-01],
	[1.6445000000E+04, 7.4716808363E+00, 5.2546474694E+00, 7.1804134150E-01, 5.8247092580E-01, 7.0378475648E-01],
	[1.6450000000E+04, 7.4748890072E+00, 5.2543964656E+00, 7.1872897266E-01, 5.8293976033E-01, 7.0390137998E-01],
	[1.6455000000E+04, 7.4780975800E+00, 5.2541455500E+00, 7.1941705256E-01, 5.8340876483E-01, 7.0401796902E-01],
	[1.6460000000E+04, 7.4813065546E+00, 5.2538947226E+00, 7.2010558136E-01, 5.8387793919E-01, 7.0413452361E-01],
	[1.6465000000E+04, 7.4845159310E+00, 5.2536439834E+00, 7.2079455920E-01, 5.8434728335E-01, 7.0425104373E-01],
	[1.6470000000E+04, 7.4877257090E+00, 5.2533933323E+00, 7.2148398626E-01, 5.8481679719E-01, 7.0436752939E-01],
	[1.6475000000E+04, 7.4909358888E+00, 5.2531427692E+00, 7.2217386268E-01, 5.8528648064E-01, 7.0448398057E-01],
	[1.6480000000E+04, 7.4941464700E+00, 5.2528922940E+00, 7.2286418862E-01, 5.8575633359E-01, 7.0460039727E-01],
	[1.6485000000E+04, 7.4973574527E+00, 5.2526419068E+00, 7.2355496423E-01, 5.8622635596E-01, 7.0471677948E-01],
	[1.6490000000E+04, 7.5005688369E+00, 5.2523916075E+00, 7.2424618967E-01, 5.8669654766E-01, 7.0483312721E-01],
	[1.6495000000E+04, 7.5037806223E+00, 5.2521413960E+00, 7.2493786510E-01, 5.8716690858E-01, 7.0494944045E-01],
	[1.6500000000E+04, 7.5069928091E+00, 5.2518912722E+00, 7.2562999067E-01, 5.8763743864E-01, 7.0506571918E-01],
	[1.6505000000E+04, 7.5102053970E+00, 5.2516412361E+00, 7.2632256654E-01, 5.8810813775E-01, 7.0518196341E-01],
	[1.6510000000E+04, 7.5134183861E+00, 5.2513912876E+00, 7.2701559286E-01, 5.8857900582E-01, 7.0529817311E-01],
	[1.6515000000E+04, 7.5166317762E+00, 5.2511414267E+00, 7.2770906980E-01, 5.8905004274E-01, 7.0541434830E-01],
	[1.6520000000E+04, 7.5198455672E+00, 5.2508916534E+00, 7.2840299750E-01, 5.8952124844E-01, 7.0553048895E-01],
	[1.6525000000E+04, 7.5230597592E+00, 5.2506419674E+00, 7.2909737612E-01, 5.8999262281E-01, 7.0564659507E-01],
	[1.6530000000E+04, 7.5262743520E+00, 5.2503923689E+00, 7.2979220582E-01, 5.9046416576E-01, 7.0576266665E-01],
	[1.6535000000E+04, 7.5294893456E+00, 5.2501428578E+00, 7.3048748676E-01, 5.9093587721E-01, 7.0587870367E-01],
	[1.6540000000E+04, 7.5327047399E+00, 5.2498934339E+00, 7.3118321908E-01, 5.9140775705E-01, 7.0599470614E-01],
	[1.6545000000E+04, 7.5359205348E+00, 5.2496440973E+00, 7.3187940295E-01, 5.9187980519E-01, 7.0611067404E-01],
	[1.6550000000E+04, 7.5391367302E+00, 5.2493948478E+00, 7.3257603853E-01, 5.9235202155E-01, 7.0622660737E-01],
	[1.6555000000E+04, 7.5423533261E+00, 5.2491456855E+00, 7.3327312596E-01, 5.9282440602E-01, 7.0634250613E-01],
	[1.6560000000E+04, 7.5455703225E+00, 5.2488966102E+00, 7.3397066540E-01, 5.9329695852E-01, 7.0645837030E-01],
	[1.6565000000E+04, 7.5487908508E+00, 5.2486491532E+00, 7.3466865702E-01, 5.9376971792E-01, 7.0657419989E-01],
	[1.6570000000E+04, 7.5520201940E+00, 5.2484058942E+00, 7.3536710096E-01, 5.9424275005E-01, 7.0668999487E-01],
	[1.6575000000E+04, 7.5552499437E+00, 5.2481627199E+00, 7.3606599738E-01, 5.9471595029E-01, 7.0680575525E-01],
	[1.6580000000E+04, 7.5584800999E+00, 5.2479196301E+00, 7.3676534644E-01, 5.9518931854E-01, 7.0692148103E-01],
	[1.6585000000E+04, 7.5617106625E+00, 5.2476766250E+00, 7.3746514830E-01, 5.9566285471E-01, 7.0703717218E-01],
	[1.6590000000E+04, 7.5649416315E+00, 5.2474337043E+00, 7.3816540310E-01, 5.9613655870E-01, 7.0715282872E-01],
	[1.6595000000E+04, 7.5681730068E+00, 5.2471908680E+00, 7.3886611102E-01, 5.9661043042E-01, 7.0726845062E-01],
	[1.6600000000E+04, 7.5714047883E+00, 5.2469481162E+00, 7.3956727219E-01, 5.9708446978E-01, 7.0738403790E-01],
	[1.6605000000E+04, 7.5746369759E+00, 5.2467054486E+00, 7.4026888678E-01, 5.9755867668E-01, 7.0749959052E-01],
	[1.6610000000E+04, 7.5778695696E+00, 5.2464628654E+00, 7.4097095495E-01, 5.9803305103E-01, 7.0761510851E-01],
	[1.6615000000E+04, 7.5811025692E+00, 5.2462203664E+00, 7.4167347684E-01, 5.9850759273E-01, 7.0773059183E-01],
	[1.6620000000E+04, 7.5843359749E+00, 5.2459779515E+00, 7.4237645263E-01, 5.9898230170E-01, 7.0784604050E-01],
	[1.6625000000E+04, 7.5875697863E+00, 5.2457356208E+00, 7.4307988245E-01, 5.9945717783E-01, 7.0796145450E-01],
	[1.6630000000E+04, 7.5908040036E+00, 5.2454933741E+00, 7.4378376648E-01, 5.9993222104E-01, 7.0807683383E-01],
	[1.6635000000E+04, 7.5940386265E+00, 5.2452512114E+00, 7.4448810486E-01, 6.0040743122E-01, 7.0819217848E-01],
	[1.6640000000E+04, 7.5972736551E+00, 5.2450091327E+00, 7.4519289775E-01, 6.0088280830E-01, 7.0830748844E-01],
	[1.6645000000E+04, 7.6005090893E+00, 5.2447671378E+00, 7.4589814530E-01, 6.0135835216E-01, 7.0842276372E-01],
	[1.6650000000E+04, 7.6037449289E+00, 5.2445252269E+00, 7.4660384768E-01, 6.0183406272E-01, 7.0853800429E-01],
	[1.6655000000E+04, 7.6069811740E+00, 5.2442833997E+00, 7.4731000504E-01, 6.0230993988E-01, 7.0865321016E-01],
	[1.6660000000E+04, 7.6102178245E+00, 5.2440416562E+00, 7.4801661754E-01, 6.0278598354E-01, 7.0876838133E-01],
	[1.6665000000E+04, 7.6134548802E+00, 5.2437999964E+00, 7.4872368532E-01, 6.0326219362E-01, 7.0888351778E-01],
	[1.6670000000E+04, 7.6166923411E+00, 5.2435584202E+00, 7.4943120856E-01, 6.0373857002E-01, 7.0899861951E-01],
	[1.6675000000E+04, 7.6199302072E+00, 5.2433169276E+00, 7.5013918739E-01, 6.0421511264E-01, 7.0911368651E-01],
	[1.6680000000E+04, 7.6231684784E+00, 5.2430755186E+00, 7.5084762199E-01, 6.0469182138E-01, 7.0922871878E-01],
	[1.6685000000E+04, 7.6264071546E+00, 5.2428341930E+00, 7.5155651250E-01, 6.0516869616E-01, 7.0934371631E-01],
	[1.6690000000E+04, 7.6296462357E+00, 5.2425929508E+00, 7.5226585909E-01, 6.0564573688E-01, 7.0945867909E-01],
	[1.6695000000E+04, 7.6328857216E+00, 5.2423517919E+00, 7.5297566190E-01, 6.0612294344E-01, 7.0957360713E-01],
	[1.6700000000E+04, 7.6361256124E+00, 5.2421107164E+00, 7.5368592110E-01, 6.0660031575E-01, 7.0968850041E-01],
	[1.6705000000E+04, 7.6393659079E+00, 5.2418697241E+00, 7.5439663684E-01, 6.0707785371E-01, 7.0980335893E-01],
	[1.6710000000E+04, 7.6426066080E+00, 5.2416288150E+00, 7.5510780928E-01, 6.0755555722E-01, 7.0991818268E-01],
	[1.6715000000E+04, 7.6458477127E+00, 5.2413879890E+00, 7.5581943856E-01, 6.0803342620E-01, 7.1003297165E-01],
	[1.6720000000E+04, 7.6490892219E+00, 5.2411472462E+00, 7.5653152486E-01, 6.0851146054E-01, 7.1014772585E-01],
	[1.6725000000E+04, 7.6523311355E+00, 5.2409065863E+00, 7.5724406833E-01, 6.0898966015E-01, 7.1026244527E-01],
	[1.6730000000E+04, 7.6555734535E+00, 5.2406660095E+00, 7.5795706911E-01, 6.0946802494E-01, 7.1037712989E-01],
	[1.6735000000E+04, 7.6588161758E+00, 5.2404255156E+00, 7.5867052737E-01, 6.0994655480E-01, 7.1049177972E-01],
	[1.6740000000E+04, 7.6620593024E+00, 5.2401851045E+00, 7.5938444327E-01, 6.1042524965E-01, 7.1060639475E-01],
	[1.6745000000E+04, 7.6653028331E+00, 5.2399447763E+00, 7.6009881696E-01, 6.1090410938E-01, 7.1072097498E-01],
	[1.6750000000E+04, 7.6685467678E+00, 5.2397045308E+00, 7.6081364859E-01, 6.1138313390E-01, 7.1083552039E-01],
	[1.6755000000E+04, 7.6717911066E+00, 5.2394643681E+00, 7.6152893833E-01, 6.1186232312E-01, 7.1095003098E-01],
	[1.6760000000E+04, 7.6750358494E+00, 5.2392242880E+00, 7.6224468633E-01, 6.1234167693E-01, 7.1106450675E-01],
	[1.6765000000E+04, 7.6782809960E+00, 5.2389842905E+00, 7.6296089274E-01, 6.1282119525E-01, 7.1117894769E-01],
	[1.6770000000E+04, 7.6815265464E+00, 5.2387443756E+00, 7.6367755772E-01, 6.1330087797E-01, 7.1129335380E-01],
	[1.6775000000E+04, 7.6847725006E+00, 5.2385045432E+00, 7.6439468143E-01, 6.1378072500E-01, 7.1140772507E-01],
	[1.6780000000E+04, 7.6880188584E+00, 5.2382647932E+00, 7.6511226403E-01, 6.1426073624E-01, 7.1152206150E-01],
	[1.6785000000E+04, 7.6912656198E+00, 5.2380251256E+00, 7.6583030566E-01, 6.1474091160E-01, 7.1163636308E-01],
	[1.6790000000E+04, 7.6945127847E+00, 5.2377855404E+00, 7.6654880649E-01, 6.1522125097E-01, 7.1175062980E-01],
	[1.6795000000E+04, 7.6977603531E+00, 5.2375460374E+00, 7.6726776668E-01, 6.1570175427E-01, 7.1186486167E-01],
	[1.6800000000E+04, 7.7010083249E+00, 5.2373066167E+00, 7.6798718637E-01, 6.1618242139E-01, 7.1197905866E-01],
	[1.6805000000E+04, 7.7042567000E+00, 5.2370672782E+00, 7.6870706573E-01, 6.1666325225E-01, 7.1209322079E-01],
	[1.6810000000E+04, 7.7075054783E+00, 5.2368280218E+00, 7.6942740492E-01, 6.1714424673E-01, 7.1220734805E-01],
	[1.6815000000E+04, 7.7107546598E+00, 5.2365888475E+00, 7.7014820408E-01, 6.1762540474E-01, 7.1232144042E-01],
	[1.6820000000E+04, 7.7140042444E+00, 5.2363497552E+00, 7.7086946337E-01, 6.1810672620E-01, 7.1243549791E-01],
	[1.6825000000E+04, 7.7172542320E+00, 5.2361107449E+00, 7.7159118296E-01, 6.1858821099E-01, 7.1254952051E-01],
	[1.6830000000E+04, 7.7205046226E+00, 5.2358718166E+00, 7.7231336299E-01, 6.1906985902E-01, 7.1266350821E-01],
	[1.6835000000E+04, 7.7237665677E+00, 5.2356381894E+00, 7.7303600363E-01, 6.1955181504E-01, 7.1277746101E-01],
	[1.6840000000E+04, 7.7270296223E+00, 5.2354049697E+00, 7.7375910503E-01, 6.2003394356E-01, 7.1289137891E-01],
	[1.6845000000E+04, 7.7302930861E+00, 5.2351718297E+00, 7.7448266734E-01, 6.2051623541E-01, 7.1300526190E-01],
	[1.6850000000E+04, 7.7335569590E+00, 5.2349387692E+00, 7.7520669073E-01, 6.2099869049E-01, 7.1311910997E-01],
	[1.6855000000E+04, 7.7368212410E+00, 5.2347057882E+00, 7.7593117534E-01, 6.2148130871E-01, 7.1323292312E-01],
	[1.6860000000E+04, 7.7400859321E+00, 5.2344728867E+00, 7.7665612134E-01, 6.2196408995E-01, 7.1334670135E-01],
	[1.6865000000E+04, 7.7433510321E+00, 5.2342400647E+00, 7.7738152889E-01, 6.2244703413E-01, 7.1346044465E-01],
	[1.6870000000E+04, 7.7466165410E+00, 5.2340073220E+00, 7.7810739813E-01, 6.2293014116E-01, 7.1357415301E-01],
	[1.6875000000E+04, 7.7498824587E+00, 5.2337746586E+00, 7.7883372922E-01, 6.2341341092E-01, 7.1368782644E-01],
	[1.6880000000E+04, 7.7531487851E+00, 5.2335420745E+00, 7.7956052233E-01, 6.2389684333E-01, 7.1380146492E-01],
	[1.6885000000E+04, 7.7564155202E+00, 5.2333095695E+00, 7.8028777760E-01, 6.2438043828E-01, 7.1391506845E-01],
	[1.6890000000E+04, 7.7596826639E+00, 5.2330771438E+00, 7.8101549520E-01, 6.2486419568E-01, 7.1402863703E-01],
	[1.6895000000E+04, 7.7629502162E+00, 5.2328447972E+00, 7.8174367528E-01, 6.2534811544E-01, 7.1414217065E-01],
	[1.6900000000E+04, 7.7662181769E+00, 5.2326125296E+00, 7.8247231799E-01, 6.2583219744E-01, 7.1425566931E-01],
	[1.6905000000E+04, 7.7694865459E+00, 5.2323803410E+00, 7.8320142350E-01, 6.2631644160E-01, 7.1436913301E-01],
	[1.6910000000E+04, 7.7727553233E+00, 5.2321482315E+00, 7.8393099196E-01, 6.2680084782E-01, 7.1448256173E-01],
	[1.6915000000E+04, 7.7760245090E+00, 5.2319162008E+00, 7.8466102352E-01, 6.2728541599E-01, 7.1459595547E-01],
	[1.6920000000E+04, 7.7792941028E+00, 5.2316842490E+00, 7.8539151835E-01, 6.2777014602E-01, 7.1470931424E-01],
	[1.6925000000E+04, 7.7825641048E+00, 5.2314523759E+00, 7.8612247659E-01, 6.2825503782E-01, 7.1482263802E-01],
	[1.6930000000E+04, 7.7858345148E+00, 5.2312205817E+00, 7.8685389841E-01, 6.2874009127E-01, 7.1493592681E-01],
	[1.6935000000E+04, 7.7891053327E+00, 5.2309888662E+00, 7.8758578396E-01, 6.2922530629E-01, 7.1504918061E-01],
	[1.6940000000E+04, 7.7923765586E+00, 5.2307572293E+00, 7.8831813340E-01, 6.2971068278E-01, 7.1516239941E-01],
	[1.6945000000E+04, 7.7956481923E+00, 5.2305256710E+00, 7.8905094689E-01, 6.3019622063E-01, 7.1527558320E-01],
	[1.6950000000E+04, 7.7989202337E+00, 5.2302941914E+00, 7.8978422458E-01, 6.3068191975E-01, 7.1538873199E-01],
	[1.6955000000E+04, 7.8021926829E+00, 5.2300627902E+00, 7.9051796662E-01, 6.3116778004E-01, 7.1550184577E-01],
	[1.6960000000E+04, 7.8054655397E+00, 5.2298314675E+00, 7.9125217318E-01, 6.3165380140E-01, 7.1561492454E-01],
	[1.6965000000E+04, 7.8087388040E+00, 5.2296002231E+00, 7.9198684441E-01, 6.3213998374E-01, 7.1572796828E-01],
	[1.6970000000E+04, 7.8120124758E+00, 5.2293690572E+00, 7.9272198047E-01, 6.3262632694E-01, 7.1584097700E-01],
	[1.6975000000E+04, 7.8152865551E+00, 5.2291379696E+00, 7.9345758151E-01, 6.3311283092E-01, 7.1595395069E-01],
	[1.6980000000E+04, 7.8185610416E+00, 5.2289069602E+00, 7.9419364769E-01, 6.3359949557E-01, 7.1606688935E-01],
	[1.6985000000E+04, 7.8218359355E+00, 5.2286760291E+00, 7.9493017917E-01, 6.3408632079E-01, 7.1617979298E-01],
	[1.6990000000E+04, 7.8251112366E+00, 5.2284451761E+00, 7.9566717610E-01, 6.3457330649E-01, 7.1629266156E-01],
	[1.6995000000E+04, 7.8283869448E+00, 5.2282144012E+00, 7.9640463864E-01, 6.3506045257E-01, 7.1640549510E-01],
	[1.7000000000E+04, 7.8316630601E+00, 5.2279837044E+00, 7.9714256695E-01, 6.3554775892E-01, 7.1651829359E-01],
	[1.7005000000E+04, 7.8349395823E+00, 5.2277530856E+00, 7.9788096118E-01, 6.3603522545E-01, 7.1663105703E-01],
	[1.7010000000E+04, 7.8382165115E+00, 5.2275225448E+00, 7.9861982149E-01, 6.3652285205E-01, 7.1674378541E-01],
	[1.7015000000E+04, 7.8414938476E+00, 5.2272920819E+00, 7.9935914804E-01, 6.3701063863E-01, 7.1685647873E-01],
	[1.7020000000E+04, 7.8447715905E+00, 5.2270616969E+00, 8.0009894098E-01, 6.3749858509E-01, 7.1696913698E-01],
	[1.7025000000E+04, 7.8480497401E+00, 5.2268313897E+00, 8.0083920047E-01, 6.3798669133E-01, 7.1708176017E-01],
	[1.7030000000E+04, 7.8513282963E+00, 5.2266011602E+00, 8.0157992666E-01, 6.3847495724E-01, 7.1719434829E-01],
	[1.7035000000E+04, 7.8546072591E+00, 5.2263710085E+00, 8.0232111972E-01, 6.3896338273E-01, 7.1730690133E-01],
	[1.7040000000E+04, 7.8578866285E+00, 5.2261409345E+00, 8.0306277980E-01, 6.3945196770E-01, 7.1741941929E-01],
	[1.7045000000E+04, 7.8611664043E+00, 5.2259109381E+00, 8.0380490705E-01, 6.3994071204E-01, 7.1753190216E-01],
	[1.7050000000E+04, 7.8644465865E+00, 5.2256810192E+00, 8.0454750164E-01, 6.4042961566E-01, 7.1764434995E-01],
	[1.7055000000E+04, 7.8677271749E+00, 5.2254511779E+00, 8.0529056371E-01, 6.4091867845E-01, 7.1775676265E-01],
	[1.7060000000E+04, 7.8710081697E+00, 5.2252214141E+00, 8.0603409343E-01, 6.4140790033E-01, 7.1786914025E-01],
	[1.7065000000E+04, 7.8742895706E+00, 5.2249917277E+00, 8.0677809096E-01, 6.4189728117E-01, 7.1798148275E-01],
	[1.7070000000E+04, 7.8775713776E+00, 5.2247621186E+00, 8.0752255644E-01, 6.4238682089E-01, 7.1809379015E-01],
	[1.7075000000E+04, 7.8808535906E+00, 5.2245325869E+00, 8.0826749003E-01, 6.4287651939E-01, 7.1820606245E-01],
	[1.7080000000E+04, 7.8841362096E+00, 5.2243031325E+00, 8.0901289190E-01, 6.4336637655E-01, 7.1831829963E-01],
	[1.7085000000E+04, 7.8874192345E+00, 5.2240737553E+00, 8.0975876220E-01, 6.4385639229E-01, 7.1843050171E-01],
	[1.7090000000E+04, 7.8907026653E+00, 5.2238444553E+00, 8.1050510109E-01, 6.4434656650E-01, 7.1854266866E-01],
	[1.7095000000E+04, 7.8939865018E+00, 5.2236152325E+00, 8.1125190871E-01, 6.4483689908E-01, 7.1865480050E-01],
	[1.7100000000E+04, 7.8972707440E+00, 5.2233860867E+00, 8.1199918524E-01, 6.4532738993E-01, 7.1876689721E-01],
	[1.7105000000E+04, 7.9005645380E+00, 5.2231611185E+00, 8.1274693082E-01, 6.4581816275E-01, 7.1887895879E-01],
	[1.7110000000E+04, 7.9038617608E+00, 5.2229375783E+00, 8.1349514561E-01, 6.4630913483E-01, 7.1899098525E-01],
	[1.7115000000E+04, 7.9071593955E+00, 5.2227141130E+00, 8.1424382977E-01, 6.4680026527E-01, 7.1910297656E-01],
	[1.7120000000E+04, 7.9104574423E+00, 5.2224907226E+00, 8.1499298346E-01, 6.4729155396E-01, 7.1921493275E-01],
	[1.7125000000E+04, 7.9137559010E+00, 5.2222674069E+00, 8.1574260683E-01, 6.4778300080E-01, 7.1932685379E-01],
	[1.7130000000E+04, 7.9170547716E+00, 5.2220441659E+00, 8.1649270004E-01, 6.4827460571E-01, 7.1943873968E-01],
	[1.7135000000E+04, 7.9203540539E+00, 5.2218209996E+00, 8.1724326325E-01, 6.4876636856E-01, 7.1955059043E-01],
	[1.7140000000E+04, 7.9236537480E+00, 5.2215979080E+00, 8.1799429661E-01, 6.4925828927E-01, 7.1966240603E-01],
	[1.7145000000E+04, 7.9269538537E+00, 5.2213748910E+00, 8.1874580027E-01, 6.4975036773E-01, 7.1977418647E-01],
	[1.7150000000E+04, 7.9302543710E+00, 5.2211519485E+00, 8.1949777441E-01, 6.5024260384E-01, 7.1988593176E-01],
	[1.7155000000E+04, 7.9335552998E+00, 5.2209290805E+00, 8.2025021916E-01, 6.5073499750E-01, 7.1999764188E-01],
	[1.7160000000E+04, 7.9368566401E+00, 5.2207062870E+00, 8.2100313470E-01, 6.5122754861E-01, 7.2010931685E-01],
	[1.7165000000E+04, 7.9401583917E+00, 5.2204835679E+00, 8.2175652117E-01, 6.5172025706E-01, 7.2022095664E-01],
	[1.7170000000E+04, 7.9434605546E+00, 5.2202609232E+00, 8.2251037874E-01, 6.5221312276E-01, 7.2033256126E-01],
	[1.7175000000E+04, 7.9467631288E+00, 5.2200383528E+00, 8.2326470755E-01, 6.5270614560E-01, 7.2044413070E-01],
	[1.7180000000E+04, 7.9500661142E+00, 5.2198158566E+00, 8.2401950777E-01, 6.5319932548E-01, 7.2055566494E-01],
	[1.7185000000E+04, 7.9533695106E+00, 5.2195934347E+00, 8.2477477956E-01, 6.5369266230E-01, 7.2066716398E-01],
	[1.7190000000E+04, 7.9566733181E+00, 5.2193710869E+00, 8.2553052306E-01, 6.5418615595E-01, 7.2077862782E-01],
	[1.7195000000E+04, 7.9599775366E+00, 5.2191488133E+00, 8.2628673844E-01, 6.5467980634E-01, 7.2089005645E-01],
	[1.7200000000E+04, 7.9632821659E+00, 5.2189266138E+00, 8.2704342586E-01, 6.5517361336E-01, 7.2100144987E-01],
	[1.7205000000E+04, 7.9665872061E+00, 5.2187044883E+00, 8.2780058547E-01, 6.5566757692E-01, 7.2111280807E-01],
	[1.7210000000E+04, 7.9698926571E+00, 5.2184824368E+00, 8.2855821742E-01, 6.5616169690E-01, 7.2122413105E-01],
	[1.7215000000E+04, 7.9731985187E+00, 5.2182604592E+00, 8.2931632188E-01, 6.5665597320E-01, 7.2133541881E-01],
	[1.7220000000E+04, 7.9765047910E+00, 5.2180385555E+00, 8.3007489900E-01, 6.5715040574E-01, 7.2144667134E-01],
	[1.7225000000E+04, 7.9798114738E+00, 5.2178167257E+00, 8.3083394893E-01, 6.5764499439E-01, 7.2155788863E-01],
	[1.7230000000E+04, 7.9831185671E+00, 5.2175949698E+00, 8.3159347185E-01, 6.5813973906E-01, 7.2166907069E-01],
	[1.7235000000E+04, 7.9864260708E+00, 5.2173732875E+00, 8.3235346789E-01, 6.5863463964E-01, 7.2178021751E-01],
	[1.7240000000E+04, 7.9897339849E+00, 5.2171516790E+00, 8.3311393722E-01, 6.5912969604E-01, 7.2189132908E-01],
	[1.7245000000E+04, 7.9930423092E+00, 5.2169301442E+00, 8.3387488000E-01, 6.5962490816E-01, 7.2200240541E-01],
	[1.7250000000E+04, 7.9963510438E+00, 5.2167086830E+00, 8.3463629638E-01, 6.6012027587E-01, 7.2211344647E-01],
	[1.7255000000E+04, 7.9996601885E+00, 5.2164872953E+00, 8.3539818652E-01, 6.6061579910E-01, 7.2222445229E-01],
	[1.7260000000E+04, 8.0029697433E+00, 5.2162659812E+00, 8.3616055057E-01, 6.6111147773E-01, 7.2233542284E-01],
	[1.7265000000E+04, 8.0062797081E+00, 5.2160447406E+00, 8.3692338870E-01, 6.6160731165E-01, 7.2244635812E-01],
	[1.7270000000E+04, 8.0095900829E+00, 5.2158235734E+00, 8.3768670105E-01, 6.6210330077E-01, 7.2255725814E-01],
	[1.7275000000E+04, 8.0129008675E+00, 5.2156024797E+00, 8.3845048780E-01, 6.6259944499E-01, 7.2266812288E-01],
	[1.7280000000E+04, 8.0162120619E+00, 5.2153814592E+00, 8.3921474908E-01, 6.6309574419E-01, 7.2277895235E-01],
	[1.7285000000E+04, 8.0195236661E+00, 5.2151605121E+00, 8.3997948507E-01, 6.6359219828E-01, 7.2288974654E-01],
	[1.7290000000E+04, 8.0228356799E+00, 5.2149396383E+00, 8.4074469591E-01, 6.6408880715E-01, 7.2300050544E-01],
	[1.7295000000E+04, 8.0261481034E+00, 5.2147188376E+00, 8.4151038177E-01, 6.6458557071E-01, 7.2311122905E-01],
	[1.7300000000E+04, 8.0294609363E+00, 5.2144981101E+00, 8.4227654280E-01, 6.6508248884E-01, 7.2322191737E-01],
	[1.7305000000E+04, 8.0327741788E+00, 5.2142774558E+00, 8.4304317916E-01, 6.6557956144E-01, 7.2333257040E-01],
	[1.7310000000E+04, 8.0360878306E+00, 5.2140568745E+00, 8.4381029100E-01, 6.6607678841E-01, 7.2344318813E-01],
	[1.7315000000E+04, 8.0394018918E+00, 5.2138363663E+00, 8.4457787848E-01, 6.6657416965E-01, 7.2355377055E-01],
	[1.7320000000E+04, 8.0427163623E+00, 5.2136159310E+00, 8.4534594177E-01, 6.6707170504E-01, 7.2366431766E-01],
	[1.7325000000E+04, 8.0460312419E+00, 5.2133955687E+00, 8.4611448101E-01, 6.6756939450E-01, 7.2377482947E-01],
	[1.7330000000E+04, 8.0493465307E+00, 5.2131752793E+00, 8.4688349636E-01, 6.6806723791E-01, 7.2388530596E-01],
	[1.7335000000E+04, 8.0526622285E+00, 5.2129550627E+00, 8.4765298798E-01, 6.6856523517E-01, 7.2399574714E-01],
	[1.7340000000E+04, 8.0559783353E+00, 5.2127349190E+00, 8.4842295603E-01, 6.6906338617E-01, 7.2410615299E-01],
	[1.7345000000E+04, 8.0592948511E+00, 5.2125148480E+00, 8.4919340066E-01, 6.6956169082E-01, 7.2421652352E-01],
	[1.7350000000E+04, 8.0626117757E+00, 5.2122948497E+00, 8.4996432203E-01, 6.7006014900E-01, 7.2432685872E-01],
	[1.7355000000E+04, 8.0659291091E+00, 5.2120749241E+00, 8.5073572030E-01, 6.7055876061E-01, 7.2443715859E-01],
	[1.7360000000E+04, 8.0692468513E+00, 5.2118550712E+00, 8.5150759563E-01, 6.7105752556E-01, 7.2454742312E-01],
	[1.7365000000E+04, 8.0725650020E+00, 5.2116352908E+00, 8.5227994816E-01, 6.7155644373E-01, 7.2465765232E-01],
	[1.7370000000E+04, 8.0758835614E+00, 5.2114155829E+00, 8.5305277807E-01, 6.7205551502E-01, 7.2476784618E-01],
	[1.7375000000E+04, 8.0792025293E+00, 5.2111959475E+00, 8.5382608550E-01, 6.7255473932E-01, 7.2487800469E-01],
	[1.7380000000E+04, 8.0825305217E+00, 5.2109800874E+00, 8.5459987061E-01, 6.7305423805E-01, 7.2498812785E-01],
	[1.7385000000E+04, 8.0858627882E+00, 5.2107659569E+00, 8.5537413357E-01, 6.7355394438E-01, 7.2509821566E-01],
	[1.7390000000E+04, 8.0891954698E+00, 5.2105518968E+00, 8.5614887452E-01, 6.7405380381E-01, 7.2520826811E-01],
	[1.7395000000E+04, 8.0925285662E+00, 5.2103379069E+00, 8.5692409362E-01, 6.7455381626E-01, 7.2531828521E-01],
	[1.7400000000E+04, 8.0958620775E+00, 5.2101239874E+00, 8.5769979104E-01, 6.7505398160E-01, 7.2542826695E-01],
	[1.7405000000E+04, 8.0991960037E+00, 5.2099101381E+00, 8.5847596692E-01, 6.7555429974E-01, 7.2553821332E-01],
	[1.7410000000E+04, 8.1025303445E+00, 5.2096963590E+00, 8.5925262143E-01, 6.7605477057E-01, 7.2564812433E-01],
	[1.7415000000E+04, 8.1058651000E+00, 5.2094826501E+00, 8.6002975472E-01, 6.7655539398E-01, 7.2575799996E-01],
	[1.7420000000E+04, 8.1092002701E+00, 5.2092690113E+00, 8.6080736695E-01, 6.7705616988E-01, 7.2586784022E-01],
	[1.7425000000E+04, 8.1125358547E+00, 5.2090554425E+00, 8.6158545827E-01, 6.7755709816E-01, 7.2597764511E-01],
	[1.7430000000E+04, 8.1158718538E+00, 5.2088419438E+00, 8.6236402885E-01, 6.7805817871E-01, 7.2608741461E-01],
	[1.7435000000E+04, 8.1192082673E+00, 5.2086285151E+00, 8.6314307884E-01, 6.7855941143E-01, 7.2619714873E-01],
	[1.7440000000E+04, 8.1225450951E+00, 5.2084151563E+00, 8.6392260840E-01, 6.7906079621E-01, 7.2630684747E-01],
	[1.7445000000E+04, 8.1258823371E+00, 5.2082018674E+00, 8.6470261768E-01, 6.7956233295E-01, 7.2641651082E-01],
	[1.7450000000E+04, 8.1292199933E+00, 5.2079886483E+00, 8.6548310684E-01, 6.8006402154E-01, 7.2652613877E-01],
	[1.7455000000E+04, 8.1325580637E+00, 5.2077754991E+00, 8.6626407604E-01, 6.8056586188E-01, 7.2663573133E-01],
	[1.7460000000E+04, 8.1358965481E+00, 5.2075624196E+00, 8.6704552544E-01, 6.8106785386E-01, 7.2674528850E-01],
	[1.7465000000E+04, 8.1392354465E+00, 5.2073494098E+00, 8.6782745519E-01, 6.8156999738E-01, 7.2685481026E-01],
	[1.7470000000E+04, 8.1425747588E+00, 5.2071364698E+00, 8.6860986545E-01, 6.8207229233E-01, 7.2696429662E-01],
	[1.7475000000E+04, 8.1459144850E+00, 5.2069235993E+00, 8.6939275638E-01, 6.8257473860E-01, 7.2707374758E-01],
	[1.7480000000E+04, 8.1492546250E+00, 5.2067107985E+00, 8.7017612813E-01, 6.8307733610E-01, 7.2718316312E-01],
	[1.7485000000E+04, 8.1525951786E+00, 5.2064980672E+00, 8.7095998087E-01, 6.8358008471E-01, 7.2729254326E-01],
	[1.7490000000E+04, 8.1559361460E+00, 5.2062854055E+00, 8.7174431474E-01, 6.8408298433E-01, 7.2740188798E-01],
	[1.7495000000E+04, 8.1592775269E+00, 5.2060728132E+00, 8.7252912991E-01, 6.8458603486E-01, 7.2751119728E-01],
	[1.7500000000E+04, 8.1626193213E+00, 5.2058602903E+00, 8.7331442653E-01, 6.8508923618E-01, 7.2762047049E-01],
	[1.7505000000E+04, 8.1659615292E+00, 5.2056478368E+00, 8.7410600277E-01, 6.8559615507E-01, 7.2772970716E-01],
	[1.7510000000E+04, 8.1693041504E+00, 5.2054354527E+00, 8.7489806955E-01, 6.8610322758E-01, 7.2783890735E-01],
	[1.7515000000E+04, 8.1726471850E+00, 5.2052231378E+00, 8.7569062703E-01, 6.8661045359E-01, 7.2794807113E-01],
	[1.7520000000E+04, 8.1759906328E+00, 5.2050108922E+00, 8.7648367537E-01, 6.8711783300E-01, 7.2805719859E-01],
	[1.7525000000E+04, 8.1793344938E+00, 5.2047987158E+00, 8.7727721474E-01, 6.8762536571E-01, 7.2816628978E-01],
	[1.7530000000E+04, 8.1826787680E+00, 5.2045866086E+00, 8.7807124530E-01, 6.8813305160E-01, 7.2827534479E-01],
	[1.7535000000E+04, 8.1860234551E+00, 5.2043745706E+00, 8.7886576722E-01, 6.8864089057E-01, 7.2838436368E-01],
	[1.7540000000E+04, 8.1893685553E+00, 5.2041626016E+00, 8.7966078065E-01, 6.8914888251E-01, 7.2849334652E-01],
	[1.7545000000E+04, 8.1927140683E+00, 5.2039507017E+00, 8.8045628577E-01, 6.8965702731E-01, 7.2860229339E-01],
	[1.7550000000E+04, 8.1960599943E+00, 5.2037388707E+00, 8.8125228273E-01, 6.9016532486E-01, 7.2871120436E-01],
	[1.7555000000E+04, 8.1994063329E+00, 5.2035271087E+00, 8.8204877169E-01, 6.9067377505E-01, 7.2882007949E-01],
	[1.7560000000E+04, 8.2027530844E+00, 5.2033154157E+00, 8.8284575283E-01, 6.9118237778E-01, 7.2892891886E-01],
	[1.7565000000E+04, 8.2061002484E+00, 5.2031037915E+00, 8.8364322630E-01, 6.9169113293E-01, 7.2903772254E-01],
	[1.7570000000E+04, 8.2094478251E+00, 5.2028922362E+00, 8.8444119227E-01, 6.9220004040E-01, 7.2914649060E-01],
	[1.7575000000E+04, 8.2127958142E+00, 5.2026807496E+00, 8.8523965090E-01, 6.9270910008E-01, 7.2925522311E-01],
	[1.7580000000E+04, 8.2161442158E+00, 5.2024693318E+00, 8.8603860235E-01, 6.9321831187E-01, 7.2936392014E-01],
	[1.7585000000E+04, 8.2194930298E+00, 5.2022579827E+00, 8.8683804679E-01, 6.9372767564E-01, 7.2947258176E-01],
	[1.7590000000E+04, 8.2228422561E+00, 5.2020467023E+00, 8.8763798438E-01, 6.9423719130E-01, 7.2958120804E-01],
	[1.7595000000E+04, 8.2261918947E+00, 5.2018354905E+00, 8.8843841529E-01, 6.9474685873E-01, 7.2968979906E-01],
	[1.7600000000E+04, 8.2295419454E+00, 5.2016243473E+00, 8.8923933967E-01, 6.9525667783E-01, 7.2979835487E-01],
	[1.7605000000E+04, 8.2328924082E+00, 5.2014132726E+00, 8.9004075770E-01, 6.9576664848E-01, 7.2990687555E-01],
	[1.7610000000E+04, 8.2362432831E+00, 5.2012022664E+00, 8.9084266952E-01, 6.9627677058E-01, 7.3001536117E-01],
	[1.7615000000E+04, 8.2395945700E+00, 5.2009913287E+00, 8.9164507532E-01, 6.9678704402E-01, 7.3012381181E-01],
	[1.7620000000E+04, 8.2429462688E+00, 5.2007804594E+00, 8.9244797525E-01, 6.9729746868E-01, 7.3023222752E-01],
	[1.7625000000E+04, 8.2462983795E+00, 5.2005696585E+00, 8.9325136947E-01, 6.9780804447E-01, 7.3034060838E-01],
	[1.7630000000E+04, 8.2496509019E+00, 5.2003589259E+00, 8.9405525815E-01, 6.9831877127E-01, 7.3044895445E-01],
	[1.7635000000E+04, 8.2530038361E+00, 5.2001482616E+00, 8.9485964145E-01, 6.9882964896E-01, 7.3055726582E-01],
	[1.7640000000E+04, 8.2563571819E+00, 5.1999376656E+00, 8.9566451953E-01, 6.9934067745E-01, 7.3066554254E-01],
	[1.7645000000E+04, 8.2597109393E+00, 5.1997271378E+00, 8.9646989257E-01, 6.9985185662E-01, 7.3077378468E-01],
	[1.7650000000E+04, 8.2630651082E+00, 5.1995166781E+00, 8.9727576071E-01, 7.0036318636E-01, 7.3088199231E-01],
	[1.7655000000E+04, 8.2664196885E+00, 5.1993062866E+00, 8.9808212413E-01, 7.0087466657E-01, 7.3099016551E-01],
	[1.7660000000E+04, 8.2697841279E+00, 5.1990998833E+00, 8.9888898299E-01, 7.0138643643E-01, 7.3109830434E-01],
	[1.7665000000E+04, 8.2731522550E+00, 5.1988949034E+00, 8.9969633745E-01, 7.0189840513E-01, 7.3120640886E-01],
	[1.7670000000E+04, 8.2765208000E+00, 5.1986899896E+00, 9.0050418768E-01, 7.0241052439E-01, 7.3131447916E-01],
	[1.7675000000E+04, 8.2798897630E+00, 5.1984851419E+00, 9.0131253383E-01, 7.0292279410E-01, 7.3142251529E-01],
	[1.7680000000E+04, 8.2832591438E+00, 5.1982803602E+00, 9.0212137608E-01, 7.0343521415E-01, 7.3153051732E-01],
	[1.7685000000E+04, 8.2866289424E+00, 5.1980756444E+00, 9.0293071458E-01, 7.0394778444E-01, 7.3163848532E-01],
	[1.7690000000E+04, 8.2899991587E+00, 5.1978709946E+00, 9.0374054950E-01, 7.0446050484E-01, 7.3174641936E-01],
	[1.7695000000E+04, 8.2933697927E+00, 5.1976664106E+00, 9.0455088101E-01, 7.0497337526E-01, 7.3185431951E-01],
	[1.7700000000E+04, 8.2967408444E+00, 5.1974618925E+00, 9.0536170926E-01, 7.0548639559E-01, 7.3196218583E-01],
	[1.7705000000E+04, 8.3001123135E+00, 5.1972574402E+00, 9.0617303442E-01, 7.0599956570E-01, 7.3207001840E-01],
	[1.7710000000E+04, 8.3034842001E+00, 5.1970530537E+00, 9.0698485666E-01, 7.0651288550E-01, 7.3217781727E-01],
	[1.7715000000E+04, 8.3068565041E+00, 5.1968487329E+00, 9.0779717613E-01, 7.0702635487E-01, 7.3228558252E-01],
	[1.7720000000E+04, 8.3102292254E+00, 5.1966444779E+00, 9.0860999300E-01, 7.0753997371E-01, 7.3239331422E-01],
	[1.7725000000E+04, 8.3136023640E+00, 5.1964402884E+00, 9.0942330744E-01, 7.0805374189E-01, 7.3250101243E-01],
	[1.7730000000E+04, 8.3169759198E+00, 5.1962361646E+00, 9.1023711960E-01, 7.0856765932E-01, 7.3260867721E-01],
	[1.7735000000E+04, 8.3203498927E+00, 5.1960321063E+00, 9.1105142966E-01, 7.0908172588E-01, 7.3271630864E-01],
	[1.7740000000E+04, 8.3237242827E+00, 5.1958281136E+00, 9.1186623777E-01, 7.0959594146E-01, 7.3282390678E-01],
	[1.7745000000E+04, 8.3270990896E+00, 5.1956241863E+00, 9.1268154410E-01, 7.1011030596E-01, 7.3293147170E-01],
	[1.7750000000E+04, 8.3304743136E+00, 5.1954203246E+00, 9.1349734881E-01, 7.1062481925E-01, 7.3303900347E-01],
	[1.7755000000E+04, 8.3338499544E+00, 5.1952165282E+00, 9.1431365207E-01, 7.1113948123E-01, 7.3314650215E-01],
	[1.7760000000E+04, 8.3372260119E+00, 5.1950127972E+00, 9.1513045403E-01, 7.1165429180E-01, 7.3325396780E-01],
	[1.7765000000E+04, 8.3406024863E+00, 5.1948091315E+00, 9.1594775487E-01, 7.1216925083E-01, 7.3336140050E-01],
	[1.7770000000E+04, 8.3439793773E+00, 5.1946055312E+00, 9.1676555474E-01, 7.1268435822E-01, 7.3346880032E-01],
	[1.7775000000E+04, 8.3473566849E+00, 5.1944019961E+00, 9.1758385382E-01, 7.1319961386E-01, 7.3357616730E-01],
	[1.7780000000E+04, 8.3507344090E+00, 5.1941985262E+00, 9.1840265226E-01, 7.1371501763E-01, 7.3368350153E-01],
	[1.7785000000E+04, 8.3541125496E+00, 5.1939951214E+00, 9.1922195022E-01, 7.1423056943E-01, 7.3379080307E-01],
	[1.7790000000E+04, 8.3574911066E+00, 5.1937917819E+00, 9.2004174788E-01, 7.1474626914E-01, 7.3389807199E-01],
	[1.7795000000E+04, 8.3608700800E+00, 5.1935885074E+00, 9.2086204539E-01, 7.1526211666E-01, 7.3400530834E-01],
	[1.7800000000E+04, 8.3642494697E+00, 5.1933852980E+00, 9.2168284292E-01, 7.1577811187E-01, 7.3411251220E-01],
	[1.7805000000E+04, 8.3676292755E+00, 5.1931821536E+00, 9.2250414064E-01, 7.1629425466E-01, 7.3421968363E-01],
	[1.7810000000E+04, 8.3710094975E+00, 5.1929790741E+00, 9.2332593869E-01, 7.1681054492E-01, 7.3432682270E-01],
	[1.7815000000E+04, 8.3743901356E+00, 5.1927760597E+00, 9.2414823726E-01, 7.1732698253E-01, 7.3443392947E-01],
	[1.7820000000E+04, 8.3777711897E+00, 5.1925731101E+00, 9.2497103650E-01, 7.1784356740E-01, 7.3454100403E-01],
	[1.7825000000E+04, 8.3811526597E+00, 5.1923702254E+00, 9.2579433658E-01, 7.1836029940E-01, 7.3464804647E-01],
	[1.7830000000E+04, 8.3845345456E+00, 5.1921674055E+00, 9.2661813765E-01, 7.1887717842E-01, 7.3475505676E-01],
	[1.7835000000E+04, 8.3879168474E+00, 5.1919646504E+00, 9.2744243989E-01, 7.1939420436E-01, 7.3486203491E-01],
	[1.7840000000E+04, 8.3912995648E+00, 5.1917619601E+00, 9.2826724346E-01, 7.1991137710E-01, 7.3496898091E-01],
	[1.7845000000E+04, 8.3946826980E+00, 5.1915593344E+00, 9.2909254852E-01, 7.2042869652E-01, 7.3507589476E-01],
	[1.7850000000E+04, 8.3980662468E+00, 5.1913567735E+00, 9.2991835524E-01, 7.2094616253E-01, 7.3518277644E-01],
	[1.7855000000E+04, 8.4014502112E+00, 5.1911542772E+00, 9.3074466377E-01, 7.2146377500E-01, 7.3528962596E-01],
	[1.7860000000E+04, 8.4048345910E+00, 5.1909518454E+00, 9.3157147429E-01, 7.2198153382E-01, 7.3539644330E-01],
	[1.7865000000E+04, 8.4082193863E+00, 5.1907494782E+00, 9.3239878696E-01, 7.2249943888E-01, 7.3550322846E-01],
	[1.7870000000E+04, 8.4116045969E+00, 5.1905471756E+00, 9.3322660193E-01, 7.2301749008E-01, 7.3560998144E-01],
	[1.7875000000E+04, 8.4149902228E+00, 5.1903449374E+00, 9.3405491938E-01, 7.2353568729E-01, 7.3571670222E-01],
	[1.7880000000E+04, 8.4183762640E+00, 5.1901427636E+00, 9.3488373947E-01, 7.2405403040E-01, 7.3582339081E-01],
	[1.7885000000E+04, 8.4217627203E+00, 5.1899406543E+00, 9.3571306235E-01, 7.2457251931E-01, 7.3593004719E-01],
	[1.7890000000E+04, 8.4251495917E+00, 5.1897386093E+00, 9.3654288821E-01, 7.2509115390E-01, 7.3603667137E-01],
	[1.7895000000E+04, 8.4285368781E+00, 5.1895366286E+00, 9.3737321719E-01, 7.2560993406E-01, 7.3614326333E-01],
	[1.7900000000E+04, 8.4319245795E+00, 5.1893347122E+00, 9.3820404947E-01, 7.2612885968E-01, 7.3624982307E-01],
	[1.7905000000E+04, 8.4353126958E+00, 5.1891328601E+00, 9.3903538520E-01, 7.2664793063E-01, 7.3635635059E-01],
	[1.7910000000E+04, 8.4387012270E+00, 5.1889310722E+00, 9.3986722455E-01, 7.2716714682E-01, 7.3646284587E-01],
	[1.7915000000E+04, 8.4420901729E+00, 5.1887293484E+00, 9.4069956769E-01, 7.2768650813E-01, 7.3656930892E-01],
	[1.7920000000E+04, 8.4454795335E+00, 5.1885276888E+00, 9.4153241478E-01, 7.2820601445E-01, 7.3667573973E-01],
	[1.7925000000E+04, 8.4488693088E+00, 5.1883260932E+00, 9.4236576598E-01, 7.2872566565E-01, 7.3678213828E-01],
	[1.7930000000E+04, 8.4522594987E+00, 5.1881245618E+00, 9.4319962145E-01, 7.2924546164E-01, 7.3688850458E-01],
	[1.7935000000E+04, 8.4556501030E+00, 5.1879230943E+00, 9.4403398136E-01, 7.2976540230E-01, 7.3699483863E-01],
	[1.7940000000E+04, 8.4590411219E+00, 5.1877216908E+00, 9.4486884588E-01, 7.3028548751E-01, 7.3710114041E-01],
	[1.7945000000E+04, 8.4624440916E+00, 5.1875250012E+00, 9.4570421517E-01, 7.3080589548E-01, 7.3720740991E-01],
	[1.7950000000E+04, 8.4658488440E+00, 5.1873289227E+00, 9.4654008938E-01, 7.3132646926E-01, 7.3731364715E-01],
	[1.7955000000E+04, 8.4692540174E+00, 5.1871329063E+00, 9.4737646870E-01, 7.3184718769E-01, 7.3741985210E-01],
	[1.7960000000E+04, 8.4726596117E+00, 5.1869369517E+00, 9.4821335327E-01, 7.3236805068E-01, 7.3752602476E-01],
	[1.7965000000E+04, 8.4760656270E+00, 5.1867410592E+00, 9.4905074326E-01, 7.3288905809E-01, 7.3763216514E-01],
	[1.7970000000E+04, 8.4794720630E+00, 5.1865452285E+00, 9.4988863885E-01, 7.3341020983E-01, 7.3773827321E-01],
	[1.7975000000E+04, 8.4828789198E+00, 5.1863494598E+00, 9.5072704018E-01, 7.3393150577E-01, 7.3784434899E-01],
	[1.7980000000E+04, 8.4862861973E+00, 5.1861537528E+00, 9.5156594743E-01, 7.3445294581E-01, 7.3795039245E-01],
	[1.7985000000E+04, 8.4896938954E+00, 5.1859581077E+00, 9.5240536075E-01, 7.3497452983E-01, 7.3805640361E-01],
	[1.7990000000E+04, 8.4931020141E+00, 5.1857625243E+00, 9.5324528032E-01, 7.3549625773E-01, 7.3816238244E-01],
	[1.7995000000E+04, 8.4965105533E+00, 5.1855670026E+00, 9.5408570630E-01, 7.3601812937E-01, 7.3826832895E-01],
	[1.8000000000E+04, 8.4999195129E+00, 5.1853715427E+00, 9.5492663885E-01, 7.3654014467E-01, 7.3837424314E-01],
	[1.8005000000E+04, 8.5033288929E+00, 5.1851761443E+00, 9.5576807813E-01, 7.3706230349E-01, 7.3848012499E-01],
	[1.8010000000E+04, 8.5067386932E+00, 5.1849808076E+00, 9.5661002431E-01, 7.3758460573E-01, 7.3858597450E-01],
	[1.8015000000E+04, 8.5101489137E+00, 5.1847855325E+00, 9.5745247755E-01, 7.3810705127E-01, 7.3869179167E-01],
	[1.8020000000E+04, 8.5135595544E+00, 5.1845903189E+00, 9.5829543802E-01, 7.3862964000E-01, 7.3879757649E-01],
	[1.8025000000E+04, 8.5169706152E+00, 5.1843951668E+00, 9.5913890588E-01, 7.3915237181E-01, 7.3890332895E-01],
	[1.8030000000E+04, 8.5203820961E+00, 5.1842000762E+00, 9.5998288130E-01, 7.3967524658E-01, 7.3900904906E-01],
	[1.8035000000E+04, 8.5237939969E+00, 5.1840050470E+00, 9.6082736443E-01, 7.4019826420E-01, 7.3911473680E-01],
	[1.8040000000E+04, 8.5272063176E+00, 5.1838100793E+00, 9.6167235545E-01, 7.4072142455E-01, 7.3922039217E-01],
	[1.8045000000E+04, 8.5306190582E+00, 5.1836151728E+00, 9.6251785451E-01, 7.4124472753E-01, 7.3932601517E-01],
	[1.8050000000E+04, 8.5340322186E+00, 5.1834203277E+00, 9.6336386178E-01, 7.4176817302E-01, 7.3943160579E-01],
	[1.8055000000E+04, 8.5374457987E+00, 5.1832255439E+00, 9.6421037743E-01, 7.4229176090E-01, 7.3953716403E-01],
	[1.8060000000E+04, 8.5408597984E+00, 5.1830308214E+00, 9.6505740161E-01, 7.4281549106E-01, 7.3964268988E-01],
	[1.8065000000E+04, 8.5442742177E+00, 5.1828361600E+00, 9.6590493450E-01, 7.4333936339E-01, 7.3974818333E-01],
	[1.8070000000E+04, 8.5476890566E+00, 5.1826415599E+00, 9.6675297626E-01, 7.4386337777E-01, 7.3985364439E-01],
	[1.8075000000E+04, 8.5511043149E+00, 5.1824470208E+00, 9.6760152705E-01, 7.4438753409E-01, 7.3995907305E-01],
	[1.8080000000E+04, 8.5545199926E+00, 5.1822525429E+00, 9.6845058703E-01, 7.4491183223E-01, 7.4006446930E-01],
	[1.8085000000E+04, 8.5579360897E+00, 5.1820581261E+00, 9.6930015637E-01, 7.4543627209E-01, 7.4016983313E-01],
	[1.8090000000E+04, 8.5613526060E+00, 5.1818637702E+00, 9.7015023523E-01, 7.4596085354E-01, 7.4027516455E-01],
	[1.8095000000E+04, 8.5647695415E+00, 5.1816694754E+00, 9.7100082378E-01, 7.4648557647E-01, 7.4038046355E-01],
	[1.8100000000E+04, 8.5681868961E+00, 5.1814752416E+00, 9.7185192218E-01, 7.4701044077E-01, 7.4048573012E-01],
	[1.8105000000E+04, 8.5716046699E+00, 5.1812810686E+00, 9.7270353060E-01, 7.4753544633E-01, 7.4059096426E-01],
	[1.8110000000E+04, 8.5750228626E+00, 5.1810869566E+00, 9.7355564919E-01, 7.4806059302E-01, 7.4069616597E-01],
	[1.8115000000E+04, 8.5784414743E+00, 5.1808929054E+00, 9.7440827813E-01, 7.4858588074E-01, 7.4080133523E-01],
	[1.8120000000E+04, 8.5818605049E+00, 5.1806989150E+00, 9.7526141758E-01, 7.4911130936E-01, 7.4090647206E-01],
	[1.8125000000E+04, 8.5852799542E+00, 5.1805049855E+00, 9.7611506770E-01, 7.4963687879E-01, 7.4101157643E-01],
	[1.8130000000E+04, 8.5886998224E+00, 5.1803111166E+00, 9.7696922865E-01, 7.5016258889E-01, 7.4111664835E-01],
	[1.8135000000E+04, 8.5921201092E+00, 5.1801173085E+00, 9.7782390061E-01, 7.5068843956E-01, 7.4122168781E-01],
	[1.8140000000E+04, 8.5955408146E+00, 5.1799235610E+00, 9.7867908373E-01, 7.5121443068E-01, 7.4132669481E-01],
	[1.8145000000E+04, 8.5989619386E+00, 5.1797298742E+00, 9.7953477818E-01, 7.5174056214E-01, 7.4143166934E-01],
	[1.8150000000E+04, 8.6023834811E+00, 5.1795362480E+00, 9.8039098412E-01, 7.5226683381E-01, 7.4153661141E-01],
	[1.8155000000E+04, 8.6058054421E+00, 5.1793426824E+00, 9.8124770171E-01, 7.5279324560E-01, 7.4164152099E-01],
	[1.8160000000E+04, 8.6092278214E+00, 5.1791491773E+00, 9.8210493113E-01, 7.5331979738E-01, 7.4174639810E-01],
	[1.8165000000E+04, 8.6126506190E+00, 5.1789557327E+00, 9.8296267253E-01, 7.5384648903E-01, 7.4185124273E-01],
	[1.8170000000E+04, 8.6160738348E+00, 5.1787623485E+00, 9.8382092608E-01, 7.5437332044E-01, 7.4195605486E-01],
	[1.8175000000E+04, 8.6194974688E+00, 5.1785690248E+00, 9.8467969195E-01, 7.5490029150E-01, 7.4206083451E-01],
	[1.8180000000E+04, 8.6229215210E+00, 5.1783757615E+00, 9.8553897029E-01, 7.5542740209E-01, 7.4216558165E-01],
	[1.8185000000E+04, 8.6263459911E+00, 5.1781825585E+00, 9.8639876128E-01, 7.5595465210E-01, 7.4227029630E-01],
	[1.8190000000E+04, 8.6297708793E+00, 5.1779894158E+00, 9.8725906507E-01, 7.5648204140E-01, 7.4237497844E-01],
	[1.8195000000E+04, 8.6331961854E+00, 5.1777963335E+00, 9.8811988183E-01, 7.5700956989E-01, 7.4247962807E-01],
	[1.8200000000E+04, 8.6366219093E+00, 5.1776033113E+00, 9.8898121172E-01, 7.5753723746E-01, 7.4258424519E-01],
	[1.8205000000E+04, 8.6400480510E+00, 5.1774103494E+00, 9.8984305492E-01, 7.5806504397E-01, 7.4268882979E-01],
	[1.8210000000E+04, 8.6434746105E+00, 5.1772174477E+00, 9.9070541158E-01, 7.5859298932E-01, 7.4279338187E-01],
	[1.8215000000E+04, 8.6469015876E+00, 5.1770246061E+00, 9.9156828186E-01, 7.5912107340E-01, 7.4289790143E-01],
	[1.8220000000E+04, 8.6503289823E+00, 5.1768318246E+00, 9.9243166594E-01, 7.5964929608E-01, 7.4300238845E-01],
	[1.8225000000E+04, 8.6537567946E+00, 5.1766391032E+00, 9.9329556397E-01, 7.6017765726E-01, 7.4310684295E-01],
	[1.8230000000E+04, 8.6571867348E+00, 5.1764471119E+00, 9.9415997612E-01, 7.6070618448E-01, 7.4321126490E-01],
	[1.8235000000E+04, 8.6606284623E+00, 5.1762596325E+00, 9.9502490256E-01, 7.6123503415E-01, 7.4331565432E-01],
	[1.8240000000E+04, 8.6640706140E+00, 5.1760722113E+00, 9.9589034345E-01, 7.6176402242E-01, 7.4342001119E-01],
	[1.8245000000E+04, 8.6675131897E+00, 5.1758848482E+00, 9.9675629894E-01, 7.6229314918E-01, 7.4352433551E-01],
	[1.8250000000E+04, 8.6709561895E+00, 5.1756975432E+00, 9.9762276922E-01, 7.6282241431E-01, 7.4362862727E-01],
	[1.8255000000E+04, 8.6743996132E+00, 5.1755102963E+00, 9.9848975444E-01, 7.6335181770E-01, 7.4373288648E-01],
	[1.8260000000E+04, 8.6778434608E+00, 5.1753231075E+00, 9.9935725476E-01, 7.6388135922E-01, 7.4383711313E-01],
	[1.8265000000E+04, 8.6812877322E+00, 5.1751359767E+00, 1.0002252704E+00, 7.6441103877E-01, 7.4394130722E-01],
	[1.8270000000E+04, 8.6847324273E+00, 5.1749489038E+00, 1.0010938014E+00, 7.6494085623E-01, 7.4404546874E-01],
	[1.8275000000E+04, 8.6881775462E+00, 5.1747618889E+00, 1.0019628480E+00, 7.6547081148E-01, 7.4414959768E-01],
	[1.8280000000E+04, 8.6916230886E+00, 5.1745749320E+00, 1.0028324104E+00, 7.6600090441E-01, 7.4425369405E-01],
	[1.8285000000E+04, 8.6950690546E+00, 5.1743880329E+00, 1.0037024887E+00, 7.6653113490E-01, 7.4435775785E-01],
	[1.8290000000E+04, 8.6985154442E+00, 5.1742011916E+00, 1.0045730831E+00, 7.6706150284E-01, 7.4446178905E-01],
	[1.8295000000E+04, 8.7019622571E+00, 5.1740144082E+00, 1.0054441938E+00, 7.6759200810E-01, 7.4456578768E-01],
	[1.8300000000E+04, 8.7054094934E+00, 5.1738276826E+00, 1.0063158209E+00, 7.6812265058E-01, 7.4466975371E-01],
	[1.8305000000E+04, 8.7088571531E+00, 5.1736410147E+00, 1.0071879646E+00, 7.6865343015E-01, 7.4477368715E-01],
	[1.8310000000E+04, 8.7123052359E+00, 5.1734544045E+00, 1.0080606250E+00, 7.6918434671E-01, 7.4487758799E-01],
	[1.8315000000E+04, 8.7157537420E+00, 5.1732678520E+00, 1.0089338023E+00, 7.6971540013E-01, 7.4498145623E-01],
	[1.8320000000E+04, 8.7192026711E+00, 5.1730813571E+00, 1.0098074967E+00, 7.7024659029E-01, 7.4508529187E-01],
	[1.8325000000E+04, 8.7226520233E+00, 5.1728949199E+00, 1.0106817084E+00, 7.7077791709E-01, 7.4518909490E-01],
	[1.8330000000E+04, 8.7261017985E+00, 5.1727085402E+00, 1.0115564374E+00, 7.7130938041E-01, 7.4529286532E-01],
	[1.8335000000E+04, 8.7295519967E+00, 5.1725222181E+00, 1.0124316841E+00, 7.7184098012E-01, 7.4539660312E-01],
	[1.8340000000E+04, 8.7330026177E+00, 5.1723359534E+00, 1.0133074485E+00, 7.7237271611E-01, 7.4550030831E-01],
	[1.8345000000E+04, 8.7364536614E+00, 5.1721497463E+00, 1.0141837307E+00, 7.7290458828E-01, 7.4560398087E-01],
	[1.8350000000E+04, 8.7399051280E+00, 5.1719635966E+00, 1.0150605311E+00, 7.7343659649E-01, 7.4570762081E-01],
	[1.8355000000E+04, 8.7433570171E+00, 5.1717775044E+00, 1.0159378496E+00, 7.7396874063E-01, 7.4581122812E-01],
	[1.8360000000E+04, 8.7468093289E+00, 5.1715914695E+00, 1.0168156866E+00, 7.7450102059E-01, 7.4591480280E-01],
	[1.8365000000E+04, 8.7502620633E+00, 5.1714054919E+00, 1.0176940421E+00, 7.7503343625E-01, 7.4601834485E-01],
	[1.8370000000E+04, 8.7537152201E+00, 5.1712195717E+00, 1.0185729163E+00, 7.7556598749E-01, 7.4612185426E-01],
	[1.8375000000E+04, 8.7571687993E+00, 5.1710337087E+00, 1.0194523095E+00, 7.7609867419E-01, 7.4622533103E-01],
	[1.8380000000E+04, 8.7606228009E+00, 5.1708479030E+00, 1.0203322217E+00, 7.7663149625E-01, 7.4632877515E-01],
	[1.8385000000E+04, 8.7640772248E+00, 5.1706621545E+00, 1.0212126531E+00, 7.7716445353E-01, 7.4643218662E-01],
	[1.8390000000E+04, 8.7675320709E+00, 5.1704764632E+00, 1.0220936038E+00, 7.7769754593E-01, 7.4653556545E-01],
	[1.8395000000E+04, 8.7709873391E+00, 5.1702908290E+00, 1.0229750742E+00, 7.7823077333E-01, 7.4663891162E-01],
	[1.8400000000E+04, 8.7744430295E+00, 5.1701052519E+00, 1.0238570642E+00, 7.7876413560E-01, 7.4674222514E-01],
	[1.8405000000E+04, 8.7778991419E+00, 5.1699197319E+00, 1.0247395741E+00, 7.7929763264E-01, 7.4684550599E-01],
	[1.8410000000E+04, 8.7813556763E+00, 5.1697342690E+00, 1.0256226040E+00, 7.7983126433E-01, 7.4694875418E-01],
	[1.8415000000E+04, 8.7848126326E+00, 5.1695488631E+00, 1.0265061542E+00, 7.8036503054E-01, 7.4705196971E-01],
	[1.8420000000E+04, 8.7882700107E+00, 5.1693635141E+00, 1.0273902247E+00, 7.8089893117E-01, 7.4715515257E-01],
	[1.8425000000E+04, 8.7917278106E+00, 5.1691782221E+00, 1.0282748158E+00, 7.8143296609E-01, 7.4725830275E-01],
	[1.8430000000E+04, 8.7951860323E+00, 5.1689929871E+00, 1.0291599275E+00, 7.8196713519E-01, 7.4736142026E-01],
	[1.8435000000E+04, 8.7986446756E+00, 5.1688078089E+00, 1.0300455601E+00, 7.8250143834E-01, 7.4746450509E-01],
	[1.8440000000E+04, 8.8021037405E+00, 5.1686226875E+00, 1.0309317137E+00, 7.8303587544E-01, 7.4756755725E-01],
	[1.8445000000E+04, 8.8055632269E+00, 5.1684376230E+00, 1.0318183886E+00, 7.8357044636E-01, 7.4767057671E-01],
	[1.8450000000E+04, 8.8090231348E+00, 5.1682526152E+00, 1.0327055847E+00, 7.8410515098E-01, 7.4777356348E-01],
	[1.8455000000E+04, 8.8124834641E+00, 5.1680676642E+00, 1.0335933024E+00, 7.8463998920E-01, 7.4787651755E-01],
	[1.8460000000E+04, 8.8159442148E+00, 5.1678827700E+00, 1.0344815418E+00, 7.8517496088E-01, 7.4797943891E-01],
	[1.8465000000E+04, 8.8194053867E+00, 5.1676979324E+00, 1.0353703031E+00, 7.8571006592E-01, 7.4808232757E-01],
	[1.8470000000E+04, 8.8228669799E+00, 5.1675131514E+00, 1.0362595863E+00, 7.8624530419E-01, 7.4818518351E-01],
	[1.8475000000E+04, 8.8263289942E+00, 5.1673284271E+00, 1.0371493917E+00, 7.8678067558E-01, 7.4828800675E-01],
	[1.8480000000E+04, 8.8297914296E+00, 5.1671437594E+00, 1.0380397195E+00, 7.8731617997E-01, 7.4839079726E-01],
	[1.8485000000E+04, 8.8332542860E+00, 5.1669591482E+00, 1.0389305698E+00, 7.8785181724E-01, 7.4849355505E-01],
	[1.8490000000E+04, 8.8367175634E+00, 5.1667745935E+00, 1.0398219427E+00, 7.8838758727E-01, 7.4859628012E-01],
	[1.8495000000E+04, 8.8401812617E+00, 5.1665900953E+00, 1.0407138385E+00, 7.8892348995E-01, 7.4869897245E-01],
	[1.8500000000E+04, 8.8436453809E+00, 5.1664056536E+00, 1.0416062573E+00, 7.8945952516E-01, 7.4880163206E-01],
	[1.8505000000E+04, 8.8471099208E+00, 5.1662212683E+00, 1.0424991993E+00, 7.8999569277E-01, 7.4890425893E-01],
	[1.8510000000E+04, 8.8505748815E+00, 5.1660369394E+00, 1.0433926645E+00, 7.9053199268E-01, 7.4900685306E-01],
	[1.8515000000E+04, 8.8540402628E+00, 5.1658526669E+00, 1.0442866533E+00, 7.9106842476E-01, 7.4910941444E-01],
	[1.8520000000E+04, 8.8575060647E+00, 5.1656684507E+00, 1.0451811658E+00, 7.9160498889E-01, 7.4921194308E-01],
	[1.8525000000E+04, 8.8609780859E+00, 5.1654864978E+00, 1.0460762020E+00, 7.9214178320E-01, 7.4931443898E-01],
	[1.8530000000E+04, 8.8644579951E+00, 5.1653074404E+00, 1.0469717623E+00, 7.9267883611E-01, 7.4941690212E-01],
	[1.8535000000E+04, 8.8679383315E+00, 5.1651284374E+00, 1.0478678467E+00, 7.9321602119E-01, 7.4951933250E-01],
	[1.8540000000E+04, 8.8714190951E+00, 5.1649494889E+00, 1.0487644554E+00, 7.9375333832E-01, 7.4962173013E-01],
	[1.8545000000E+04, 8.8749002857E+00, 5.1647705948E+00, 1.0496615886E+00, 7.9429078739E-01, 7.4972409499E-01],
	[1.8550000000E+04, 8.8783819034E+00, 5.1645917552E+00, 1.0505592465E+00, 7.9482836828E-01, 7.4982642709E-01],
	[1.8555000000E+04, 8.8818639481E+00, 5.1644129700E+00, 1.0514574292E+00, 7.9536608088E-01, 7.4992872641E-01],
	[1.8560000000E+04, 8.8853464196E+00, 5.1642342391E+00, 1.0523561368E+00, 7.9590392505E-01, 7.5003099297E-01],
	[1.8565000000E+04, 8.8888293180E+00, 5.1640555625E+00, 1.0532553696E+00, 7.9644190068E-01, 7.5013322675E-01],
	[1.8570000000E+04, 8.8923126432E+00, 5.1638769403E+00, 1.0541551277E+00, 7.9698000767E-01, 7.5023542776E-01],
	[1.8575000000E+04, 8.8957963951E+00, 5.1636983723E+00, 1.0550554113E+00, 7.9751824588E-01, 7.5033759598E-01],
	[1.8580000000E+04, 8.8992805737E+00, 5.1635198585E+00, 1.0559562205E+00, 7.9805661519E-01, 7.5043973142E-01],
	[1.8585000000E+04, 8.9027651788E+00, 5.1633413990E+00, 1.0568575555E+00, 7.9859511550E-01, 7.5054183407E-01],
	[1.8590000000E+04, 8.9062502105E+00, 5.1631629936E+00, 1.0577594165E+00, 7.9913374668E-01, 7.5064390393E-01],
	[1.8595000000E+04, 8.9097356687E+00, 5.1629846423E+00, 1.0586618036E+00, 7.9967250861E-01, 7.5074594100E-01],
	[1.8600000000E+04, 8.9132215532E+00, 5.1628063452E+00, 1.0595647170E+00, 8.0021140118E-01, 7.5084794527E-01],
	[1.8605000000E+04, 8.9167078642E+00, 5.1626281021E+00, 1.0604681569E+00, 8.0075042426E-01, 7.5094991675E-01],
	[1.8610000000E+04, 8.9201946013E+00, 5.1624499131E+00, 1.0613721234E+00, 8.0128957773E-01, 7.5105185542E-01],
	[1.8615000000E+04, 8.9236817647E+00, 5.1622717781E+00, 1.0622766167E+00, 8.0182886149E-01, 7.5115376128E-01],
	[1.8620000000E+04, 8.9271693543E+00, 5.1620936971E+00, 1.0631816369E+00, 8.0236827541E-01, 7.5125563434E-01],
	[1.8625000000E+04, 8.9306573699E+00, 5.1619156700E+00, 1.0640871843E+00, 8.0290781936E-01, 7.5135747459E-01],
	[1.8630000000E+04, 8.9341458116E+00, 5.1617376969E+00, 1.0649932589E+00, 8.0344749324E-01, 7.5145928203E-01],
	[1.8635000000E+04, 8.9376346793E+00, 5.1615597776E+00, 1.0658998610E+00, 8.0398729692E-01, 7.5156105665E-01],
	[1.8640000000E+04, 8.9411239728E+00, 5.1613819123E+00, 1.0668069908E+00, 8.0452723028E-01, 7.5166279845E-01],
	[1.8645000000E+04, 8.9446136922E+00, 5.1612041007E+00, 1.0677146482E+00, 8.0506729320E-01, 7.5176450743E-01],
	[1.8650000000E+04, 8.9481038374E+00, 5.1610263430E+00, 1.0686228337E+00, 8.0560748558E-01, 7.5186618358E-01],
	[1.8655000000E+04, 8.9515944083E+00, 5.1608486390E+00, 1.0695315472E+00, 8.0614780727E-01, 7.5196782691E-01],
	[1.8660000000E+04, 8.9550854049E+00, 5.1606709887E+00, 1.0704407891E+00, 8.0668825818E-01, 7.5206943740E-01],
	[1.8665000000E+04, 8.9585768271E+00, 5.1604933922E+00, 1.0713505593E+00, 8.0722883817E-01, 7.5217101507E-01],
	[1.8670000000E+04, 8.9620686747E+00, 5.1603158493E+00, 1.0722608582E+00, 8.0776954713E-01, 7.5227255990E-01],
	[1.8675000000E+04, 8.9655609479E+00, 5.1601383601E+00, 1.0731716858E+00, 8.0831038494E-01, 7.5237407189E-01],
	[1.8680000000E+04, 8.9690536465E+00, 5.1599609245E+00, 1.0740830424E+00, 8.0885135147E-01, 7.5247555105E-01],
	[1.8685000000E+04, 8.9725467704E+00, 5.1597835425E+00, 1.0749949280E+00, 8.0939244662E-01, 7.5257699736E-01],
	[1.8690000000E+04, 8.9760403196E+00, 5.1596062141E+00, 1.0759073430E+00, 8.0993367026E-01, 7.5267841082E-01],
	[1.8695000000E+04, 8.9795342940E+00, 5.1594289391E+00, 1.0768202873E+00, 8.1047502227E-01, 7.5277979144E-01],
	[1.8700000000E+04, 8.9830286936E+00, 5.1592517177E+00, 1.0777337613E+00, 8.1101650253E-01, 7.5288113921E-01],
	[1.8705000000E+04, 8.9865235183E+00, 5.1590745497E+00, 1.0786477650E+00, 8.1155811092E-01, 7.5298245413E-01],
	[1.8710000000E+04, 8.9900187680E+00, 5.1588974352E+00, 1.0795627826E+00, 8.1210012117E-01, 7.5308373619E-01],
	[1.8715000000E+04, 8.9935144427E+00, 5.1587203741E+00, 1.0804792710E+00, 8.1264279129E-01, 7.5318498539E-01],
	[1.8720000000E+04, 8.9970105423E+00, 5.1585433663E+00, 1.0813962918E+00, 8.1318558980E-01, 7.5328620173E-01],
	[1.8725000000E+04, 9.0005070668E+00, 5.1583664119E+00, 1.0823138452E+00, 8.1372851660E-01, 7.5338738522E-01],
	[1.8730000000E+04, 9.0040040161E+00, 5.1581895108E+00, 1.0832319313E+00, 8.1427157155E-01, 7.5348853583E-01],
	[1.8735000000E+04, 9.0075013900E+00, 5.1580126629E+00, 1.0841505502E+00, 8.1481475453E-01, 7.5358965359E-01],
	[1.8740000000E+04, 9.0109991887E+00, 5.1578358684E+00, 1.0850697023E+00, 8.1535806544E-01, 7.5369073847E-01],
	[1.8745000000E+04, 9.0144974119E+00, 5.1576591270E+00, 1.0859893875E+00, 8.1590150413E-01, 7.5379179048E-01],
	[1.8750000000E+04, 9.0179960597E+00, 5.1574824389E+00, 1.0869096061E+00, 8.1644507051E-01, 7.5389280965E-01],
	[1.8755000000E+04, 9.0214951320E+00, 5.1573058039E+00, 1.0878303583E+00, 8.1698876444E-01, 7.5399379605E-01],
	[1.8760000000E+04, 9.0249946287E+00, 5.1571292220E+00, 1.0887516442E+00, 8.1753258580E-01, 7.5409474971E-01],
	[1.8765000000E+04, 9.0284945498E+00, 5.1569526932E+00, 1.0896734640E+00, 8.1807653448E-01, 7.5419567066E-01],
	[1.8770000000E+04, 9.0319948951E+00, 5.1567762175E+00, 1.0905958179E+00, 8.1862061035E-01, 7.5429655893E-01],
	[1.8775000000E+04, 9.0354956647E+00, 5.1565997949E+00, 1.0915187059E+00, 8.1916481329E-01, 7.5439741456E-01],
	[1.8780000000E+04, 9.0389968585E+00, 5.1564234252E+00, 1.0924421284E+00, 8.1970914319E-01, 7.5449823755E-01],
	[1.8785000000E+04, 9.0424984763E+00, 5.1562471086E+00, 1.0933660854E+00, 8.2025359991E-01, 7.5459902796E-01],
	[1.8790000000E+04, 9.0460005182E+00, 5.1560708449E+00, 1.0942905771E+00, 8.2079818335E-01, 7.5469978580E-01],
	[1.8795000000E+04, 9.0495029841E+00, 5.1558946341E+00, 1.0952156037E+00, 8.2134289337E-01, 7.5480051111E-01],
	[1.8800000000E+04, 9.0530058740E+00, 5.1557184762E+00, 1.0961411653E+00, 8.2188772987E-01, 7.5490120392E-01],
	[1.8805000000E+04, 9.0565091877E+00, 5.1555423711E+00, 1.0970672622E+00, 8.2243269271E-01, 7.5500186424E-01],
	[1.8810000000E+04, 9.0600129252E+00, 5.1553663189E+00, 1.0979938945E+00, 8.2297778178E-01, 7.5510249212E-01],
	[1.8815000000E+04, 9.0635170864E+00, 5.1551903195E+00, 1.0989210623E+00, 8.2352299695E-01, 7.5520308758E-01],
	[1.8820000000E+04, 9.0670216713E+00, 5.1550143728E+00, 1.0998487658E+00, 8.2406833811E-01, 7.5530365066E-01],
	[1.8825000000E+04, 9.0705374242E+00, 5.1548424518E+00, 1.1007770052E+00, 8.2461399560E-01, 7.5540418137E-01],
	[1.8830000000E+04, 9.0740563120E+00, 5.1546715823E+00, 1.1017057807E+00, 8.2515982722E-01, 7.5550467975E-01],
	[1.8835000000E+04, 9.0775756302E+00, 5.1545007638E+00, 1.1026350923E+00, 8.2570578496E-01, 7.5560514583E-01],
	[1.8840000000E+04, 9.0810953786E+00, 5.1543299963E+00, 1.1035649404E+00, 8.2625186869E-01, 7.5570557963E-01],
	[1.8845000000E+04, 9.0846155573E+00, 5.1541592798E+00, 1.1044953250E+00, 8.2679807830E-01, 7.5580598119E-01],
	[1.8850000000E+04, 9.0881361661E+00, 5.1539886142E+00, 1.1054262463E+00, 8.2734441365E-01, 7.5590635054E-01],
	[1.8855000000E+04, 9.0916572050E+00, 5.1538179996E+00, 1.1063577046E+00, 8.2789087463E-01, 7.5600668769E-01],
	[1.8860000000E+04, 9.0951786740E+00, 5.1536474358E+00, 1.1072896998E+00, 8.2843746111E-01, 7.5610699269E-01],
	[1.8865000000E+04, 9.0987005729E+00, 5.1534769229E+00, 1.1082222323E+00, 8.2898417298E-01, 7.5620726556E-01],
	[1.8870000000E+04, 9.1022229017E+00, 5.1533064608E+00, 1.1091553022E+00, 8.2953101012E-01, 7.5630750632E-01],
	[1.8875000000E+04, 9.1057456604E+00, 5.1531360495E+00, 1.1100889096E+00, 8.3007797241E-01, 7.5640771501E-01],
	[1.8880000000E+04, 9.1092688488E+00, 5.1529656890E+00, 1.1110230547E+00, 8.3062505971E-01, 7.5650789166E-01],
	[1.8885000000E+04, 9.1127924670E+00, 5.1527953792E+00, 1.1119577378E+00, 8.3117227192E-01, 7.5660803629E-01],
	[1.8890000000E+04, 9.1163165148E+00, 5.1526251201E+00, 1.1128929588E+00, 8.3171960891E-01, 7.5670814893E-01],
	[1.8895000000E+04, 9.1198409923E+00, 5.1524549117E+00, 1.1138287181E+00, 8.3226707056E-01, 7.5680822961E-01],
	[1.8900000000E+04, 9.1233658993E+00, 5.1522847540E+00, 1.1147650158E+00, 8.3281465674E-01, 7.5690827836E-01],
	[1.8905000000E+04, 9.1268912357E+00, 5.1521146468E+00, 1.1157018520E+00, 8.3336236735E-01, 7.5700829521E-01],
	[1.8910000000E+04, 9.1304170016E+00, 5.1519445903E+00, 1.1166392270E+00, 8.3391020225E-01, 7.5710828018E-01],
	[1.8915000000E+04, 9.1339431968E+00, 5.1517745844E+00, 1.1175771408E+00, 8.3445816132E-01, 7.5720823331E-01],
	[1.8920000000E+04, 9.1374698214E+00, 5.1516046290E+00, 1.1185155937E+00, 8.3500624445E-01, 7.5730815462E-01],
	[1.8925000000E+04, 9.1409968751E+00, 5.1514347241E+00, 1.1194545858E+00, 8.3555445151E-01, 7.5740804414E-01],
	[1.8930000000E+04, 9.1445243580E+00, 5.1512648697E+00, 1.1203941173E+00, 8.3610278237E-01, 7.5750790190E-01],
	[1.8935000000E+04, 9.1480522701E+00, 5.1510950657E+00, 1.1213341883E+00, 8.3665123693E-01, 7.5760772792E-01],
	[1.8940000000E+04, 9.1515806112E+00, 5.1509253122E+00, 1.1222747991E+00, 8.3719981505E-01, 7.5770752224E-01],
	[1.8945000000E+04, 9.1551093813E+00, 5.1507556091E+00, 1.1232159497E+00, 8.3774851662E-01, 7.5780728488E-01],
	[1.8950000000E+04, 9.1586385803E+00, 5.1505859564E+00, 1.1241576404E+00, 8.3829734151E-01, 7.5790701587E-01],
	[1.8955000000E+04, 9.1621682082E+00, 5.1504163539E+00, 1.1250998713E+00, 8.3884628960E-01, 7.5800671524E-01],
	[1.8960000000E+04, 9.1656982648E+00, 5.1502468019E+00, 1.1260426426E+00, 8.3939536077E-01, 7.5810638302E-01],
	[1.8965000000E+04, 9.1692287503E+00, 5.1500773000E+00, 1.1269859545E+00, 8.3994455490E-01, 7.5820601923E-01],
	[1.8970000000E+04, 9.1727596644E+00, 5.1499078485E+00, 1.1279298070E+00, 8.4049387187E-01, 7.5830562390E-01],
	[1.8975000000E+04, 9.1762910071E+00, 5.1497384472E+00, 1.1288742005E+00, 8.4104331154E-01, 7.5840519706E-01],
	[1.8980000000E+04, 9.1798227784E+00, 5.1495690961E+00, 1.1298191350E+00, 8.4159287382E-01, 7.5850473874E-01],
	[1.8985000000E+04, 9.1833549782E+00, 5.1493997951E+00, 1.1307646108E+00, 8.4214255856E-01, 7.5860424896E-01],
	[1.8990000000E+04, 9.1868876064E+00, 5.1492305443E+00, 1.1317106279E+00, 8.4269236565E-01, 7.5870372776E-01],
	[1.8995000000E+04, 9.1904206631E+00, 5.1490613437E+00, 1.1326571866E+00, 8.4324229496E-01, 7.5880317516E-01],
	[1.9000000000E+04, 9.1939541480E+00, 5.1488921931E+00, 1.1336042869E+00, 8.4379234638E-01, 7.5890259119E-01],
	[1.9005000000E+04, 9.1974880612E+00, 5.1487230925E+00, 1.1345519292E+00, 8.4434251978E-01, 7.5900197587E-01],
	[1.9010000000E+04, 9.2010224026E+00, 5.1485540421E+00, 1.1355001136E+00, 8.4489281504E-01, 7.5910132924E-01],
	[1.9015000000E+04, 9.2045571721E+00, 5.1483850416E+00, 1.1364488401E+00, 8.4544323204E-01, 7.5920065132E-01],
	[1.9020000000E+04, 9.2080923697E+00, 5.1482160911E+00, 1.1373981091E+00, 8.4599377066E-01, 7.5929994214E-01],
	[1.9025000000E+04, 9.2116279953E+00, 5.1480471905E+00, 1.1383479206E+00, 8.4654443076E-01, 7.5939920172E-01],
	[1.9030000000E+04, 9.2151640489E+00, 5.1478783399E+00, 1.1392982748E+00, 8.4709521224E-01, 7.5949843010E-01],
	[1.9035000000E+04, 9.2187005303E+00, 5.1477095391E+00, 1.1402491719E+00, 8.4764611497E-01, 7.5959762730E-01],
	[1.9040000000E+04, 9.2222374396E+00, 5.1475407883E+00, 1.1412006121E+00, 8.4819713882E-01, 7.5969679334E-01],
	[1.9045000000E+04, 9.2257747767E+00, 5.1473720872E+00, 1.1421525955E+00, 8.4874828367E-01, 7.5979592827E-01],
	[1.9050000000E+04, 9.2293125415E+00, 5.1472034360E+00, 1.1431051223E+00, 8.4929954941E-01, 7.5989503193E-01],
	[1.9055000000E+04, 9.2328507339E+00, 5.1470348346E+00, 1.1440581926E+00, 8.4985093590E-01, 7.5999410405E-01],
	[1.9060000000E+04, 9.2363893539E+00, 5.1468662829E+00, 1.1450118067E+00, 8.5040244303E-01, 7.6009314463E-01],
	[1.9065000000E+04, 9.2399284015E+00, 5.1466977809E+00, 1.1459659647E+00, 8.5095407068E-01, 7.6019215366E-01],
	[1.9070000000E+04, 9.2434678765E+00, 5.1465293287E+00, 1.1469206667E+00, 8.5150581871E-01, 7.6029113113E-01],
	[1.9075000000E+04, 9.2470077789E+00, 5.1463609261E+00, 1.1478759129E+00, 8.5205768701E-01, 7.6039007704E-01],
	[1.9080000000E+04, 9.2505481087E+00, 5.1461925732E+00, 1.1488317036E+00, 8.5260967546E-01, 7.6048899140E-01],
	[1.9085000000E+04, 9.2540888657E+00, 5.1460242698E+00, 1.1497880388E+00, 8.5316178393E-01, 7.6058787418E-01],
	[1.9090000000E+04, 9.2576300500E+00, 5.1458560161E+00, 1.1507449187E+00, 8.5371401230E-01, 7.6068672540E-01],
	[1.9095000000E+04, 9.2611716615E+00, 5.1456878119E+00, 1.1517023435E+00, 8.5426636044E-01, 7.6078554505E-01],
	[1.9100000000E+04, 9.2647137000E+00, 5.1455196573E+00, 1.1526603134E+00, 8.5481882824E-01, 7.6088433312E-01],
	[1.9105000000E+04, 9.2682561657E+00, 5.1453515522E+00, 1.1536188285E+00, 8.5537141557E-01, 7.6098308961E-01],
	[1.9110000000E+04, 9.2717990582E+00, 5.1451834965E+00, 1.1545778890E+00, 8.5592412231E-01, 7.6108181451E-01],
	[1.9115000000E+04, 9.2753423778E+00, 5.1450154903E+00, 1.1555374950E+00, 8.5647694834E-01, 7.6118050783E-01],
	[1.9120000000E+04, 9.2788861242E+00, 5.1448475335E+00, 1.1564976468E+00, 8.5702989353E-01, 7.6127916955E-01],
	[1.9125000000E+04, 9.2824330296E+00, 5.1446806080E+00, 1.1574583445E+00, 8.5758300836E-01, 7.6137779969E-01],
	[1.9130000000E+04, 9.2859912713E+00, 5.1445176501E+00, 1.1584195882E+00, 8.5813644439E-01, 7.6147639822E-01],
	[1.9135000000E+04, 9.2895499467E+00, 5.1443547399E+00, 1.1593813782E+00, 8.5868999972E-01, 7.6157496515E-01],
	[1.9140000000E+04, 9.2931090555E+00, 5.1441918775E+00, 1.1603437146E+00, 8.5924367423E-01, 7.6167350048E-01],
	[1.9145000000E+04, 9.2966685978E+00, 5.1440290627E+00, 1.1613065975E+00, 8.5979746779E-01, 7.6177200420E-01],
	[1.9150000000E+04, 9.3002285734E+00, 5.1438662956E+00, 1.1622700272E+00, 8.6035138029E-01, 7.6187047631E-01],
	[1.9155000000E+04, 9.3037889823E+00, 5.1437035761E+00, 1.1632340037E+00, 8.6090541159E-01, 7.6196891680E-01],
	[1.9160000000E+04, 9.3073498245E+00, 5.1435409043E+00, 1.1641985273E+00, 8.6145956157E-01, 7.6206732567E-01],
	[1.9165000000E+04, 9.3109110999E+00, 5.1433782800E+00, 1.1651635982E+00, 8.6201383012E-01, 7.6216570292E-01],
	[1.9170000000E+04, 9.3144728084E+00, 5.1432157033E+00, 1.1661292165E+00, 8.6256821711E-01, 7.6226404855E-01],
	[1.9175000000E+04, 9.3180349500E+00, 5.1430531742E+00, 1.1670953823E+00, 8.6312272241E-01, 7.6236236255E-01],
	[1.9180000000E+04, 9.3215975246E+00, 5.1428906925E+00, 1.1680620958E+00, 8.6367734591E-01, 7.6246064491E-01],
	[1.9185000000E+04, 9.3251605321E+00, 5.1427282584E+00, 1.1690293573E+00, 8.6423208748E-01, 7.6255889564E-01],
	[1.9190000000E+04, 9.3287239726E+00, 5.1425658717E+00, 1.1699971668E+00, 8.6478694699E-01, 7.6265711474E-01],
	[1.9195000000E+04, 9.3322878459E+00, 5.1424035324E+00, 1.1709655246E+00, 8.6534192433E-01, 7.6275530219E-01],
	[1.9200000000E+04, 9.3358521519E+00, 5.1422412405E+00, 1.1719344307E+00, 8.6589701937E-01, 7.6285345799E-01],
	[1.9205000000E+04, 9.3394168906E+00, 5.1420789960E+00, 1.1729038855E+00, 8.6645223198E-01, 7.6295158215E-01],
	[1.9210000000E+04, 9.3429820620E+00, 5.1419167988E+00, 1.1738738889E+00, 8.6700756205E-01, 7.6304967466E-01],
	[1.9215000000E+04, 9.3465476660E+00, 5.1417546490E+00, 1.1748444413E+00, 8.6756300946E-01, 7.6314773552E-01],
	[1.9220000000E+04, 9.3501137025E+00, 5.1415925465E+00, 1.1758155428E+00, 8.6811857407E-01, 7.6324576471E-01],
	[1.9225000000E+04, 9.3536801715E+00, 5.1414304912E+00, 1.1767871934E+00, 8.6867425576E-01, 7.6334376225E-01],
	[1.9230000000E+04, 9.3572470729E+00, 5.1412684832E+00, 1.1777593935E+00, 8.6923005442E-01, 7.6344172813E-01],
	[1.9235000000E+04, 9.3608144067E+00, 5.1411065225E+00, 1.1787321432E+00, 8.6978596991E-01, 7.6353966233E-01],
	[1.9240000000E+04, 9.3643821727E+00, 5.1409446089E+00, 1.1797054426E+00, 8.7034200212E-01, 7.6363756487E-01],
	[1.9245000000E+04, 9.3679503709E+00, 5.1407827425E+00, 1.1806792919E+00, 8.7089815092E-01, 7.6373543574E-01],
	[1.9250000000E+04, 9.3715190014E+00, 5.1406209232E+00, 1.1816536913E+00, 8.7145441618E-01, 7.6383327493E-01],
	[1.9255000000E+04, 9.3750880639E+00, 5.1404591510E+00, 1.1826286409E+00, 8.7201079779E-01, 7.6393108245E-01],
	[1.9260000000E+04, 9.3786575585E+00, 5.1402974260E+00, 1.1836041409E+00, 8.7256729562E-01, 7.6402885828E-01],
	[1.9265000000E+04, 9.3822274851E+00, 5.1401357480E+00, 1.1845801915E+00, 8.7312390955E-01, 7.6412660243E-01],
	[1.9270000000E+04, 9.3857978436E+00, 5.1399741170E+00, 1.1855567929E+00, 8.7368063945E-01, 7.6422431490E-01],
	[1.9275000000E+04, 9.3893686340E+00, 5.1398125331E+00, 1.1865339451E+00, 8.7423748520E-01, 7.6432199567E-01],
	[1.9280000000E+04, 9.3929398562E+00, 5.1396509961E+00, 1.1875116485E+00, 8.7479444668E-01, 7.6441964476E-01],
	[1.9285000000E+04, 9.3965115101E+00, 5.1394895061E+00, 1.1884899031E+00, 8.7535152375E-01, 7.6451726215E-01],
	[1.9290000000E+04, 9.4000835957E+00, 5.1393280630E+00, 1.1894687091E+00, 8.7590871631E-01, 7.6461484784E-01],
	[1.9295000000E+04, 9.4036561130E+00, 5.1391666669E+00, 1.1904480666E+00, 8.7646602422E-01, 7.6471240183E-01],
	[1.9300000000E+04, 9.4072290618E+00, 5.1390053176E+00, 1.1914279760E+00, 8.7702344736E-01, 7.6480992412E-01],
	[1.9305000000E+04, 9.4108024421E+00, 5.1388440152E+00, 1.1924084372E+00, 8.7758098561E-01, 7.6490741470E-01],
	[1.9310000000E+04, 9.4143762539E+00, 5.1386827596E+00, 1.1933894505E+00, 8.7813863884E-01, 7.6500487358E-01],
	[1.9315000000E+04, 9.4179504971E+00, 5.1385215509E+00, 1.1943710161E+00, 8.7869640693E-01, 7.6510230074E-01],
	[1.9320000000E+04, 9.4215251716E+00, 5.1383603889E+00, 1.1953531341E+00, 8.7925428976E-01, 7.6519969620E-01],
	[1.9325000000E+04, 9.4251002774E+00, 5.1381992736E+00, 1.1963358046E+00, 8.7981228719E-01, 7.6529705993E-01],
	[1.9330000000E+04, 9.4286758144E+00, 5.1380382051E+00, 1.1973190280E+00, 8.8037039912E-01, 7.6539439195E-01],
	[1.9335000000E+04, 9.4322517826E+00, 5.1378771833E+00, 1.1983028042E+00, 8.8092862540E-01, 7.6549169225E-01],
	[1.9340000000E+04, 9.4358281818E+00, 5.1377162082E+00, 1.1992871335E+00, 8.8148696593E-01, 7.6558896082E-01],
	[1.9345000000E+04, 9.4394050121E+00, 5.1375552798E+00, 1.2002720161E+00, 8.8204542057E-01, 7.6568619767E-01],
	[1.9350000000E+04, 9.4429822734E+00, 5.1373943979E+00, 1.2012574521E+00, 8.8260398920E-01, 7.6578340279E-01],
	[1.9355000000E+04, 9.4465599655E+00, 5.1372335627E+00, 1.2022434417E+00, 8.8316267170E-01, 7.6588057618E-01],
	[1.9360000000E+04, 9.4501380886E+00, 5.1370727740E+00, 1.2032299850E+00, 8.8372146794E-01, 7.6597771783E-01],
	[1.9365000000E+04, 9.4537166424E+00, 5.1369120319E+00, 1.2042170823E+00, 8.8428037780E-01, 7.6607482776E-01],
	[1.9370000000E+04, 9.4572956269E+00, 5.1367513363E+00, 1.2052047336E+00, 8.8483940115E-01, 7.6617190594E-01],
	[1.9375000000E+04, 9.4608750422E+00, 5.1365906873E+00, 1.2061929392E+00, 8.8539853787E-01, 7.6626895238E-01],
	[1.9380000000E+04, 9.4644548881E+00, 5.1364300847E+00, 1.2071816993E+00, 8.8595778784E-01, 7.6636596708E-01],
	[1.9385000000E+04, 9.4680351645E+00, 5.1362695285E+00, 1.2081710139E+00, 8.8651715092E-01, 7.6646295004E-01],
	[1.9390000000E+04, 9.4716158714E+00, 5.1361090188E+00, 1.2091608833E+00, 8.8707662701E-01, 7.6655990125E-01],
	[1.9395000000E+04, 9.4751970087E+00, 5.1359485554E+00, 1.2101513076E+00, 8.8763621596E-01, 7.6665682071E-01],
	[1.9400000000E+04, 9.4787785765E+00, 5.1357881385E+00, 1.2111422870E+00, 8.8819591767E-01, 7.6675370842E-01],
	[1.9405000000E+04, 9.4823605746E+00, 5.1356277679E+00, 1.2121338217E+00, 8.8875573199E-01, 7.6685056438E-01],
	[1.9410000000E+04, 9.4859430029E+00, 5.1354674436E+00, 1.2131259118E+00, 8.8931565882E-01, 7.6694738858E-01],
	[1.9415000000E+04, 9.4895258614E+00, 5.1353071656E+00, 1.2141185575E+00, 8.8987569802E-01, 7.6704418102E-01],
	[1.9420000000E+04, 9.4931091501E+00, 5.1351469339E+00, 1.2151117590E+00, 8.9043584947E-01, 7.6714094170E-01],
	[1.9425000000E+04, 9.4966928689E+00, 5.1349867484E+00, 1.2161055163E+00, 8.9099611304E-01, 7.6723767062E-01],
	[1.9430000000E+04, 9.5002770176E+00, 5.1348266091E+00, 1.2170998298E+00, 8.9155648862E-01, 7.6733436778E-01],
	[1.9435000000E+04, 9.5038702595E+00, 5.1346695406E+00, 1.2180946996E+00, 8.9211714370E-01, 7.6743103317E-01],
	[1.9440000000E+04, 9.5074691064E+00, 5.1345143218E+00, 1.2190901258E+00, 8.9267801099E-01, 7.6752766679E-01],
	[1.9445000000E+04, 9.5110683901E+00, 5.1343591477E+00, 1.2200861086E+00, 8.9323899043E-01, 7.6762426865E-01],
	[1.9450000000E+04, 9.5146681105E+00, 5.1342040181E+00, 1.2210826482E+00, 8.9380008190E-01, 7.6772083873E-01],
	[1.9455000000E+04, 9.5182682675E+00, 5.1340489331E+00, 1.2220797447E+00, 8.9436128526E-01, 7.6781737703E-01],
	[1.9460000000E+04, 9.5218688611E+00, 5.1338938926E+00, 1.2230773983E+00, 8.9492260039E-01, 7.6791388357E-01],
	[1.9465000000E+04, 9.5254698912E+00, 5.1337388967E+00, 1.2240756092E+00, 8.9548402718E-01, 7.6801035832E-01],
	[1.9470000000E+04, 9.5290713577E+00, 5.1335839452E+00, 1.2250743775E+00, 8.9604556549E-01, 7.6810680129E-01],
	[1.9475000000E+04, 9.5326732607E+00, 5.1334290382E+00, 1.2260737034E+00, 8.9660721521E-01, 7.6820321248E-01],
	[1.9480000000E+04, 9.5362755999E+00, 5.1332741756E+00, 1.2270735871E+00, 8.9716897619E-01, 7.6829959189E-01],
	[1.9485000000E+04, 9.5398783755E+00, 5.1331193574E+00, 1.2280740288E+00, 8.9773084834E-01, 7.6839593952E-01],
	[1.9490000000E+04, 9.5434815872E+00, 5.1329645837E+00, 1.2290750285E+00, 8.9829283151E-01, 7.6849225535E-01],
	[1.9495000000E+04, 9.5470852351E+00, 5.1328098543E+00, 1.2300765866E+00, 8.9885492558E-01, 7.6858853940E-01],
	[1.9500000000E+04, 9.5506893191E+00, 5.1326551692E+00, 1.2310787030E+00, 8.9941713043E-01, 7.6868479166E-01],
	[1.9505000000E+04, 9.5542938391E+00, 5.1325005285E+00, 1.2320813781E+00, 8.9997944593E-01, 7.6878101213E-01],
	[1.9510000000E+04, 9.5578987951E+00, 5.1323459320E+00, 1.2330846120E+00, 9.0054187196E-01, 7.6887720080E-01],
	[1.9515000000E+04, 9.5615041870E+00, 5.1321913798E+00, 1.2340884048E+00, 9.0110440840E-01, 7.6897335767E-01],
	[1.9520000000E+04, 9.5651100148E+00, 5.1320368719E+00, 1.2350927568E+00, 9.0166705511E-01, 7.6906948275E-01],
	[1.9525000000E+04, 9.5687162784E+00, 5.1318824082E+00, 1.2360976680E+00, 9.0222981198E-01, 7.6916557603E-01],
	[1.9530000000E+04, 9.5723229777E+00, 5.1317279886E+00, 1.2371031387E+00, 9.0279267888E-01, 7.6926163751E-01],
	[1.9535000000E+04, 9.5759301127E+00, 5.1315736133E+00, 1.2381091690E+00, 9.0335565569E-01, 7.6935766719E-01],
	[1.9540000000E+04, 9.5795376833E+00, 5.1314192821E+00, 1.2391157590E+00, 9.0391874227E-01, 7.6945366507E-01],
	[1.9545000000E+04, 9.5831456895E+00, 5.1312649950E+00, 1.2401229091E+00, 9.0448193851E-01, 7.6954963114E-01],
	[1.9550000000E+04, 9.5867541312E+00, 5.1311107521E+00, 1.2411306192E+00, 9.0504524428E-01, 7.6964556540E-01],
	[1.9555000000E+04, 9.5903630084E+00, 5.1309565532E+00, 1.2421388897E+00, 9.0560865946E-01, 7.6974146785E-01],
	[1.9560000000E+04, 9.5939723209E+00, 5.1308023983E+00, 1.2431477206E+00, 9.0617218391E-01, 7.6983733850E-01],
	[1.9565000000E+04, 9.5975820687E+00, 5.1306482875E+00, 1.2441571121E+00, 9.0673581752E-01, 7.6993317734E-01],
	[1.9570000000E+04, 9.6011922518E+00, 5.1304942207E+00, 1.2451670644E+00, 9.0729956016E-01, 7.7002898436E-01],
	[1.9575000000E+04, 9.6048028702E+00, 5.1303401979E+00, 1.2461775777E+00, 9.0786341171E-01, 7.7012475957E-01],
	[1.9580000000E+04, 9.6084139237E+00, 5.1301862191E+00, 1.2471886521E+00, 9.0842737204E-01, 7.7022050296E-01],
	[1.9585000000E+04, 9.6120254122E+00, 5.1300322841E+00, 1.2482002878E+00, 9.0899144102E-01, 7.7031621454E-01],
	[1.9590000000E+04, 9.6156373359E+00, 5.1298783931E+00, 1.2492124850E+00, 9.0955561853E-01, 7.7041189429E-01],
	[1.9595000000E+04, 9.6192496944E+00, 5.1297245460E+00, 1.2502252437E+00, 9.1011990445E-01, 7.7050754223E-01],
	[1.9600000000E+04, 9.6228624879E+00, 5.1295707427E+00, 1.2512385643E+00, 9.1068429865E-01, 7.7060315835E-01],
	[1.9605000000E+04, 9.6264757163E+00, 5.1294169833E+00, 1.2522524469E+00, 9.1124880100E-01, 7.7069874265E-01],
	[1.9610000000E+04, 9.6300893795E+00, 5.1292632677E+00, 1.2532668916E+00, 9.1181341138E-01, 7.7079429513E-01],
	[1.9615000000E+04, 9.6337034774E+00, 5.1291095959E+00, 1.2542818986E+00, 9.1237812966E-01, 7.7088981578E-01],
	[1.9620000000E+04, 9.6373180100E+00, 5.1289559679E+00, 1.2552974681E+00, 9.1294295572E-01, 7.7098530460E-01],
	[1.9625000000E+04, 9.6409329772E+00, 5.1288023836E+00, 1.2563136002E+00, 9.1350788944E-01, 7.7108076160E-01],
	[1.9630000000E+04, 9.6445483790E+00, 5.1286488430E+00, 1.2573302951E+00, 9.1407293068E-01, 7.7117618677E-01],
	[1.9635000000E+04, 9.6481642152E+00, 5.1284953461E+00, 1.2583475529E+00, 9.1463807933E-01, 7.7127158011E-01],
	[1.9640000000E+04, 9.6517804860E+00, 5.1283418929E+00, 1.2593653740E+00, 9.1520333526E-01, 7.7136694163E-01],
	[1.9645000000E+04, 9.6553971911E+00, 5.1281884834E+00, 1.2603837583E+00, 9.1576869833E-01, 7.7146227131E-01],
	[1.9650000000E+04, 9.6590143306E+00, 5.1280351174E+00, 1.2614027061E+00, 9.1633416843E-01, 7.7155756916E-01],
	[1.9655000000E+04, 9.6626319043E+00, 5.1278817951E+00, 1.2624222175E+00, 9.1689974544E-01, 7.7165283517E-01],
	[1.9660000000E+04, 9.6662499122E+00, 5.1277285164E+00, 1.2634422928E+00, 9.1746542922E-01, 7.7174806936E-01],
	[1.9665000000E+04, 9.6698683544E+00, 5.1275752812E+00, 1.2644629321E+00, 9.1803121965E-01, 7.7184327170E-01],
	[1.9670000000E+04, 9.6734872306E+00, 5.1274220896E+00, 1.2654841354E+00, 9.1859711660E-01, 7.7193844221E-01],
	[1.9675000000E+04, 9.6771065408E+00, 5.1272689414E+00, 1.2665059031E+00, 9.1916311995E-01, 7.7203358089E-01],
	[1.9680000000E+04, 9.6807262850E+00, 5.1271158368E+00, 1.2675282353E+00, 9.1972922958E-01, 7.7212868772E-01],
	[1.9685000000E+04, 9.6843464632E+00, 5.1269627756E+00, 1.2685511322E+00, 9.2029544535E-01, 7.7222376272E-01],
	[1.9690000000E+04, 9.6879670752E+00, 5.1268097579E+00, 1.2695745938E+00, 9.2086176714E-01, 7.7231880588E-01],
	[1.9695000000E+04, 9.6915881210E+00, 5.1266567835E+00, 1.2705986205E+00, 9.2142819483E-01, 7.7241381719E-01],
	[1.9700000000E+04, 9.6952096006E+00, 5.1265038526E+00, 1.2716232123E+00, 9.2199472830E-01, 7.7250879667E-01],
	[1.9705000000E+04, 9.6988315139E+00, 5.1263509650E+00, 1.2726483694E+00, 9.2256136740E-01, 7.7260374430E-01],
	[1.9710000000E+04, 9.7024538608E+00, 5.1261981208E+00, 1.2736740920E+00, 9.2312811203E-01, 7.7269866009E-01],
	[1.9715000000E+04, 9.7060766412E+00, 5.1260453199E+00, 1.2747003803E+00, 9.2369496205E-01, 7.7279354403E-01],
	[1.9720000000E+04, 9.7096998552E+00, 5.1258925623E+00, 1.2757272344E+00, 9.2426191733E-01, 7.7288839613E-01],
	[1.9725000000E+04, 9.7133235027E+00, 5.1257398480E+00, 1.2767546545E+00, 9.2482897776E-01, 7.7298321639E-01],
	[1.9730000000E+04, 9.7169475835E+00, 5.1255871770E+00, 1.2777826407E+00, 9.2539614321E-01, 7.7307800480E-01],
	[1.9735000000E+04, 9.7205720977E+00, 5.1254345491E+00, 1.2788111933E+00, 9.2596341354E-01, 7.7317276136E-01],
	[1.9740000000E+04, 9.7241970452E+00, 5.1252819645E+00, 1.2798403124E+00, 9.2653078864E-01, 7.7326748607E-01],
	[1.9745000000E+04, 9.7278232809E+00, 5.1251297132E+00, 1.2808699982E+00, 9.2709828564E-01, 7.7336217894E-01],
	[1.9750000000E+04, 9.7314631263E+00, 5.1249819739E+00, 1.2819002507E+00, 9.2766615333E-01, 7.7345683996E-01],
	[1.9755000000E+04, 9.7351034116E+00, 5.1248342762E+00, 1.2829310703E+00, 9.2823412595E-01, 7.7355146913E-01],
	[1.9760000000E+04, 9.7387441370E+00, 5.1246866201E+00, 1.2839624571E+00, 9.2880220336E-01, 7.7364606644E-01],
	[1.9765000000E+04, 9.7423853023E+00, 5.1245390057E+00, 1.2849944112E+00, 9.2937038545E-01, 7.7374063191E-01],
	[1.9770000000E+04, 9.7460269074E+00, 5.1243914329E+00, 1.2860269328E+00, 9.2993867208E-01, 7.7383516553E-01],
	[1.9775000000E+04, 9.7496689524E+00, 5.1242439016E+00, 1.2870600221E+00, 9.3050706313E-01, 7.7392966729E-01],
	[1.9780000000E+04, 9.7533114370E+00, 5.1240964119E+00, 1.2880936792E+00, 9.3107555848E-01, 7.7402413720E-01],
	[1.9785000000E+04, 9.7569543614E+00, 5.1239489637E+00, 1.2891279043E+00, 9.3164415800E-01, 7.7411857526E-01],
	[1.9790000000E+04, 9.7605977254E+00, 5.1238015569E+00, 1.2901626976E+00, 9.3221286155E-01, 7.7421298147E-01],
	[1.9795000000E+04, 9.7642415290E+00, 5.1236541917E+00, 1.2911980592E+00, 9.3278166903E-01, 7.7430735582E-01],
	[1.9800000000E+04, 9.7678857721E+00, 5.1235068679E+00, 1.2922339894E+00, 9.3335058030E-01, 7.7440169832E-01],
	[1.9805000000E+04, 9.7715304546E+00, 5.1233595856E+00, 1.2932704882E+00, 9.3391959523E-01, 7.7449600897E-01],
	[1.9810000000E+04, 9.7751755765E+00, 5.1232123447E+00, 1.2943075559E+00, 9.3448871371E-01, 7.7459028776E-01],
	[1.9815000000E+04, 9.7788211378E+00, 5.1230651451E+00, 1.2953451927E+00, 9.3505793559E-01, 7.7468453469E-01],
	[1.9820000000E+04, 9.7824671384E+00, 5.1229179869E+00, 1.2963833985E+00, 9.3562726077E-01, 7.7477874977E-01],
	[1.9825000000E+04, 9.7861135781E+00, 5.1227708701E+00, 1.2974221738E+00, 9.3619668911E-01, 7.7487293300E-01],
	[1.9830000000E+04, 9.7897604571E+00, 5.1226237946E+00, 1.2984615186E+00, 9.3676622049E-01, 7.7496708437E-01],
	[1.9835000000E+04, 9.7934077751E+00, 5.1224767604E+00, 1.2995014330E+00, 9.3733585477E-01, 7.7506120388E-01],
	[1.9840000000E+04, 9.7970555322E+00, 5.1223297674E+00, 1.3005419174E+00, 9.3790559185E-01, 7.7515529153E-01],
	[1.9845000000E+04, 9.8007037283E+00, 5.1221828157E+00, 1.3015829717E+00, 9.3847543158E-01, 7.7524934733E-01],
	[1.9850000000E+04, 9.8043523633E+00, 5.1220359053E+00, 1.3026245962E+00, 9.3904537384E-01, 7.7534337127E-01],
	[1.9855000000E+04, 9.8080014372E+00, 5.1218890361E+00, 1.3036667912E+00, 9.3961541851E-01, 7.7543736336E-01],
	[1.9860000000E+04, 9.8116509499E+00, 5.1217422080E+00, 1.3047095566E+00, 9.4018556546E-01, 7.7553132358E-01],
	[1.9865000000E+04, 9.8153009014E+00, 5.1215954212E+00, 1.3057528927E+00, 9.4075581457E-01, 7.7562525195E-01],
	[1.9870000000E+04, 9.8189512916E+00, 5.1214486754E+00, 1.3067967997E+00, 9.4132616570E-01, 7.7571914846E-01],
	[1.9875000000E+04, 9.8226021204E+00, 5.1213019708E+00, 1.3078412778E+00, 9.4189661874E-01, 7.7581301312E-01],
	[1.9880000000E+04, 9.8262533878E+00, 5.1211553073E+00, 1.3088863270E+00, 9.4246717356E-01, 7.7590684592E-01],
	[1.9885000000E+04, 9.8299050937E+00, 5.1210086849E+00, 1.3099319476E+00, 9.4303783002E-01, 7.7600064685E-01],
	[1.9890000000E+04, 9.8335572382E+00, 5.1208621036E+00, 1.3109781398E+00, 9.4360858801E-01, 7.7609441593E-01],
	[1.9895000000E+04, 9.8372098210E+00, 5.1207155632E+00, 1.3120249036E+00, 9.4417944740E-01, 7.7618815316E-01],
	[1.9900000000E+04, 9.8408628422E+00, 5.1205690639E+00, 1.3130722393E+00, 9.4475040806E-01, 7.7628185852E-01],
	[1.9905000000E+04, 9.8445163016E+00, 5.1204226056E+00, 1.3141201471E+00, 9.4532146987E-01, 7.7637553203E-01],
	[1.9910000000E+04, 9.8481701994E+00, 5.1202761883E+00, 1.3151686271E+00, 9.4589263269E-01, 7.7646917368E-01],
	[1.9915000000E+04, 9.8518245353E+00, 5.1201298119E+00, 1.3162176795E+00, 9.4646389641E-01, 7.7656278347E-01],
	[1.9920000000E+04, 9.8554793093E+00, 5.1199834764E+00, 1.3172673044E+00, 9.4703526090E-01, 7.7665636140E-01],
	[1.9925000000E+04, 9.8591345214E+00, 5.1198371819E+00, 1.3183175020E+00, 9.4760672602E-01, 7.7674990748E-01],
	[1.9930000000E+04, 9.8627901715E+00, 5.1196909282E+00, 1.3193682725E+00, 9.4817829167E-01, 7.7684342170E-01],
	[1.9935000000E+04, 9.8664462596E+00, 5.1195447154E+00, 1.3204196161E+00, 9.4874995770E-01, 7.7693690406E-01],
	[1.9940000000E+04, 9.8701027855E+00, 5.1193985435E+00, 1.3214715329E+00, 9.4932172399E-01, 7.7703035456E-01],
	[1.9945000000E+04, 9.8737597493E+00, 5.1192524123E+00, 1.3225240231E+00, 9.4989359042E-01, 7.7712377321E-01],
	[1.9950000000E+04, 9.8774171509E+00, 5.1191063220E+00, 1.3235770868E+00, 9.5046555685E-01, 7.7721716000E-01],
	[1.9955000000E+04, 9.8810749902E+00, 5.1189602724E+00, 1.3246307243E+00, 9.5103762317E-01, 7.7731051493E-01],
	[1.9960000000E+04, 9.8847332672E+00, 5.1188142636E+00, 1.3256849356E+00, 9.5160978925E-01, 7.7740383801E-01],
	[1.9965000000E+04, 9.8883919818E+00, 5.1186682955E+00, 1.3267397210E+00, 9.5218205495E-01, 7.7749712923E-01],
	[1.9970000000E+04, 9.8920511339E+00, 5.1185223682E+00, 1.3277950807E+00, 9.5275442016E-01, 7.7759038859E-01],
	[1.9975000000E+04, 9.8957107236E+00, 5.1183764815E+00, 1.3288510147E+00, 9.5332688475E-01, 7.7768361610E-01],
	[1.9980000000E+04, 9.8993707506E+00, 5.1182306355E+00, 1.3299075234E+00, 9.5389944859E-01, 7.7777681176E-01],
	[1.9985000000E+04, 9.9030312151E+00, 5.1180848301E+00, 1.3309646067E+00, 9.5447211155E-01, 7.7786997556E-01],
	[1.9990000000E+04, 9.9066921169E+00, 5.1179390654E+00, 1.3320222650E+00, 9.5504487350E-01, 7.7796310750E-01],
	[1.9995000000E+04, 9.9103534559E+00, 5.1177933413E+00, 1.3330804983E+00, 9.5561773433E-01, 7.7805620759E-01],
	[2.0000000000E+04, 9.9140152322E+00, 5.1176476577E+00, 1.3341393068E+00, 9.5619069391E-01, 7.7814927583E-01],
	[2.0005000000E+04, 9.9176774456E+00, 5.1175020147E+00, 1.3352000336E+00, 9.5676444159E-01, 7.7824231222E-01],
	[2.0010000000E+04, 9.9213400961E+00, 5.1173564123E+00, 1.3362613378E+00, 9.5733828818E-01, 7.7833531675E-01],
	[2.0015000000E+04, 9.9250031836E+00, 5.1172108504E+00, 1.3373232196E+00, 9.5791223354E-01, 7.7842828943E-01],
	[2.0020000000E+04, 9.9286667082E+00, 5.1170653290E+00, 1.3383856792E+00, 9.5848627754E-01, 7.7852123025E-01],
	[2.0025000000E+04, 9.9323306696E+00, 5.1169198480E+00, 1.3394487166E+00, 9.5906042007E-01, 7.7861413923E-01],
	[2.0030000000E+04, 9.9359950679E+00, 5.1167744075E+00, 1.3405123322E+00, 9.5963466099E-01, 7.7870701635E-01],
	[2.0035000000E+04, 9.9396599030E+00, 5.1166290075E+00, 1.3415765261E+00, 9.6020900017E-01, 7.7879986163E-01],
	[2.0040000000E+04, 9.9433251749E+00, 5.1164836478E+00, 1.3426412983E+00, 9.6078343749E-01, 7.7889267505E-01],
	[2.0045000000E+04, 9.9469908835E+00, 5.1163383285E+00, 1.3437066492E+00, 9.6135797282E-01, 7.7898545663E-01],
	[2.0050000000E+04, 9.9506570287E+00, 5.1161930497E+00, 1.3447725789E+00, 9.6193260603E-01, 7.7907820636E-01],
	[2.0055000000E+04, 9.9543236105E+00, 5.1160478111E+00, 1.3458390875E+00, 9.6250733700E-01, 7.7917092424E-01],
	[2.0060000000E+04, 9.9579906288E+00, 5.1159026129E+00, 1.3469061752E+00, 9.6308216560E-01, 7.7926361027E-01],
	[2.0065000000E+04, 9.9616650520E+00, 5.1157597453E+00, 1.3479738423E+00, 9.6365723818E-01, 7.7935626446E-01],
	[2.0070000000E+04, 9.9653472160E+00, 5.1156193160E+00, 1.3490420887E+00, 9.6423256198E-01, 7.7944888680E-01],
	[2.0075000000E+04, 9.9690298232E+00, 5.1154789255E+00, 1.3501109148E+00, 9.6480798357E-01, 7.7954147729E-01],
	[2.0080000000E+04, 9.9727128738E+00, 5.1153385738E+00, 1.3511803207E+00, 9.6538350284E-01, 7.7963403594E-01],
	[2.0085000000E+04, 9.9763963676E+00, 5.1151982610E+00, 1.3522503066E+00, 9.6595911966E-01, 7.7972656275E-01],
	[2.0090000000E+04, 9.9800803045E+00, 5.1150579868E+00, 1.3533208725E+00, 9.6653483389E-01, 7.7981905771E-01],
	[2.0095000000E+04, 9.9837646845E+00, 5.1149177515E+00, 1.3543920188E+00, 9.6711064542E-01, 7.7991152083E-01],
	[2.0100000000E+04, 9.9874495075E+00, 5.1147775549E+00, 1.3554637456E+00, 9.6768655411E-01, 7.8000395211E-01],
	[2.0105000000E+04, 9.9911347736E+00, 5.1146373970E+00, 1.3565360530E+00, 9.6826255985E-01, 7.8009635155E-01],
	[2.0110000000E+04, 9.9948204825E+00, 5.1144972777E+00, 1.3576089412E+00, 9.6883866249E-01, 7.8018871915E-01],
	[2.0115000000E+04, 9.9985066344E+00, 5.1143571972E+00, 1.3586824104E+00, 9.6941486192E-01, 7.8028105491E-01],
	[2.0120000000E+04, 1.0002193229E+01, 5.1142171553E+00, 1.3597564607E+00, 9.6999115800E-01, 7.8037335883E-01],
	[2.0125000000E+04, 1.0005880266E+01, 5.1140771520E+00, 1.3608310924E+00, 9.7056755061E-01, 7.8046563092E-01],
	[2.0130000000E+04, 1.0009567747E+01, 5.1139371874E+00, 1.3619063056E+00, 9.7114403963E-01, 7.8055787117E-01],
	[2.0135000000E+04, 1.0013255669E+01, 5.1137972613E+00, 1.3629821004E+00, 9.7172062493E-01, 7.8065007958E-01],
	[2.0140000000E+04, 1.0016944035E+01, 5.1136573738E+00, 1.3640584770E+00, 9.7229730637E-01, 7.8074225616E-01],
	[2.0145000000E+04, 1.0020632842E+01, 5.1135175248E+00, 1.3651354357E+00, 9.7287408384E-01, 7.8083440091E-01],
	[2.0150000000E+04, 1.0024322093E+01, 5.1133777144E+00, 1.3662129765E+00, 9.7345095720E-01, 7.8092651382E-01],
	[2.0155000000E+04, 1.0028011786E+01, 5.1132379425E+00, 1.3672910996E+00, 9.7402792633E-01, 7.8101859490E-01],
	[2.0160000000E+04, 1.0031701921E+01, 5.1130982091E+00, 1.3683698053E+00, 9.7460499110E-01, 7.8111064416E-01],
	[2.0165000000E+04, 1.0035392498E+01, 5.1129585141E+00, 1.3694490936E+00, 9.7518215138E-01, 7.8120266158E-01],
	[2.0170000000E+04, 1.0039083518E+01, 5.1128188576E+00, 1.3705289648E+00, 9.7575940705E-01, 7.8129464717E-01],
	[2.0175000000E+04, 1.0042774980E+01, 5.1126792396E+00, 1.3716094190E+00, 9.7633675798E-01, 7.8138660094E-01],
	[2.0180000000E+04, 1.0046466884E+01, 5.1125396599E+00, 1.3726904564E+00, 9.7691420404E-01, 7.8147852288E-01],
	[2.0185000000E+04, 1.0050159230E+01, 5.1124001186E+00, 1.3737720772E+00, 9.7749174510E-01, 7.8157041300E-01],
	[2.0190000000E+04, 1.0053852018E+01, 5.1122606157E+00, 1.3748542814E+00, 9.7806938105E-01, 7.8166227129E-01],
	[2.0195000000E+04, 1.0057545248E+01, 5.1121211511E+00, 1.3759370694E+00, 9.7864711174E-01, 7.8175409776E-01],
	[2.0200000000E+04, 1.0061238920E+01, 5.1119817249E+00, 1.3770204413E+00, 9.7922493706E-01, 7.8184589241E-01],
	[2.0205000000E+04, 1.0064933033E+01, 5.1118423370E+00, 1.3781043971E+00, 9.7980285687E-01, 7.8193765524E-01],
	[2.0210000000E+04, 1.0068627589E+01, 5.1117029873E+00, 1.3791889372E+00, 9.8038087105E-01, 7.8202938621E-01],
	[2.0215000000E+04, 1.0072322586E+01, 5.1115636760E+00, 1.3802740617E+00, 9.8095897947E-01, 7.8212108535E-01],
	[2.0220000000E+04, 1.0076018025E+01, 5.1114244029E+00, 1.3813597707E+00, 9.8153718201E-01, 7.8221275264E-01],
	[2.0225000000E+04, 1.0079713906E+01, 5.1112851680E+00, 1.3824460644E+00, 9.8211547853E-01, 7.8230438809E-01],
	[2.0230000000E+04, 1.0083410228E+01, 5.1111459713E+00, 1.3835329430E+00, 9.8269386891E-01, 7.8239599170E-01],
	[2.0235000000E+04, 1.0087106992E+01, 5.1110068128E+00, 1.3846204067E+00, 9.8327235303E-01, 7.8248756346E-01],
	[2.0240000000E+04, 1.0090804197E+01, 5.1108676925E+00, 1.3857084555E+00, 9.8385093075E-01, 7.8257910338E-01],
	[2.0245000000E+04, 1.0094501844E+01, 5.1107286103E+00, 1.3867970898E+00, 9.8442960194E-01, 7.8267061146E-01],
	[2.0250000000E+04, 1.0098199932E+01, 5.1105895663E+00, 1.3878863097E+00, 9.8500836649E-01, 7.8276208769E-01],
	[2.0255000000E+04, 1.0101898461E+01, 5.1104505603E+00, 1.3889761152E+00, 9.8558722426E-01, 7.8285353209E-01],
	[2.0260000000E+04, 1.0105597431E+01, 5.1103115925E+00, 1.3900665067E+00, 9.8616617512E-01, 7.8294494464E-01],
	[2.0265000000E+04, 1.0109296843E+01, 5.1101726627E+00, 1.3911574843E+00, 9.8674521895E-01, 7.8303632535E-01],
	[2.0270000000E+04, 1.0112996695E+01, 5.1100337710E+00, 1.3922490481E+00, 9.8732435562E-01, 7.8312767422E-01],
	[2.0275000000E+04, 1.0116696989E+01, 5.1098949173E+00, 1.3933411983E+00, 9.8790358500E-01, 7.8321899125E-01],
	[2.0280000000E+04, 1.0120397724E+01, 5.1097561016E+00, 1.3944339351E+00, 9.8848290697E-01, 7.8331027644E-01],
	[2.0285000000E+04, 1.0124098900E+01, 5.1096173239E+00, 1.3955272586E+00, 9.8906232140E-01, 7.8340152979E-01],
	[2.0290000000E+04, 1.0127800516E+01, 5.1094785841E+00, 1.3966211691E+00, 9.8964182815E-01, 7.8349275131E-01],
	[2.0295000000E+04, 1.0131502574E+01, 5.1093398824E+00, 1.3977156667E+00, 9.9022142711E-01, 7.8358394098E-01],
	[2.0300000000E+04, 1.0135205072E+01, 5.1092012185E+00, 1.3988107515E+00, 9.9080111814E-01, 7.8367509881E-01],
	[2.0305000000E+04, 1.0138908011E+01, 5.1090625926E+00, 1.3999064238E+00, 9.9138090112E-01, 7.8376622481E-01],
	[2.0310000000E+04, 1.0142611390E+01, 5.1089240045E+00, 1.4010026836E+00, 9.9196077593E-01, 7.8385731896E-01],
	[2.0315000000E+04, 1.0146315211E+01, 5.1087854544E+00, 1.4020995313E+00, 9.9254074242E-01, 7.8394838128E-01],
	[2.0320000000E+04, 1.0150019471E+01, 5.1086469421E+00, 1.4031969668E+00, 9.9312080048E-01, 7.8403941177E-01],
	[2.0325000000E+04, 1.0153724173E+01, 5.1085084676E+00, 1.4042949905E+00, 9.9370094997E-01, 7.8413041042E-01],
	[2.0330000000E+04, 1.0157429314E+01, 5.1083700309E+00, 1.4053936025E+00, 9.9428119078E-01, 7.8422137723E-01],
	[2.0335000000E+04, 1.0161134897E+01, 5.1082316320E+00, 1.4064928029E+00, 9.9486152276E-01, 7.8431231221E-01],
	[2.0340000000E+04, 1.0164840919E+01, 5.1080932709E+00, 1.4075925920E+00, 9.9544194580E-01, 7.8440321535E-01],
	[2.0345000000E+04, 1.0168547382E+01, 5.1079549476E+00, 1.4086929698E+00, 9.9602245977E-01, 7.8449408666E-01],
	[2.0350000000E+04, 1.0172254285E+01, 5.1078166619E+00, 1.4097939366E+00, 9.9660306454E-01, 7.8458492614E-01],
	[2.0355000000E+04, 1.0175961628E+01, 5.1076784140E+00, 1.4108954926E+00, 9.9718375998E-01, 7.8467573378E-01],
	[2.0360000000E+04, 1.0179669411E+01, 5.1075402038E+00, 1.4119976378E+00, 9.9776454596E-01, 7.8476650960E-01],
	[2.0365000000E+04, 1.0183377634E+01, 5.1074020313E+00, 1.4131003725E+00, 9.9834542235E-01, 7.8485725358E-01],
	[2.0370000000E+04, 1.0187086297E+01, 5.1072638964E+00, 1.4142036969E+00, 9.9892638904E-01, 7.8494796573E-01],
	[2.0375000000E+04, 1.0190795401E+01, 5.1071257992E+00, 1.4153076110E+00, 9.9950744589E-01, 7.8503864606E-01],
	[2.0380000000E+04, 1.0194504944E+01, 5.1069877396E+00, 1.4164121152E+00, 1.0000885928E+00, 7.8512929455E-01],
	[2.0385000000E+04, 1.0198214927E+01, 5.1068497175E+00, 1.4175172095E+00, 1.0006698296E+00, 7.8521991122E-01],
	[2.0390000000E+04, 1.0201938376E+01, 5.1067158539E+00, 1.4186228941E+00, 1.0012514400E+00, 7.8531049606E-01],
	[2.0395000000E+04, 1.0205663843E+01, 5.1065825233E+00, 1.4197291692E+00, 1.0018331749E+00, 7.8540104907E-01],
	[2.0400000000E+04, 1.0209389756E+01, 5.1064492288E+00, 1.4208360350E+00, 1.0024149998E+00, 7.8549157026E-01],
	[2.0405000000E+04, 1.0213116116E+01, 5.1063159705E+00, 1.4219434916E+00, 1.0029969147E+00, 7.8558205963E-01],
	[2.0410000000E+04, 1.0216842922E+01, 5.1061827483E+00, 1.4230515392E+00, 1.0035789195E+00, 7.8567251717E-01],
	[2.0415000000E+04, 1.0220570175E+01, 5.1060495622E+00, 1.4241601780E+00, 1.0041610139E+00, 7.8576294289E-01],
	[2.0420000000E+04, 1.0224297875E+01, 5.1059164122E+00, 1.4252694081E+00, 1.0047431980E+00, 7.8585333679E-01],
	[2.0425000000E+04, 1.0228026020E+01, 5.1057832983E+00, 1.4263792298E+00, 1.0053254715E+00, 7.8594369886E-01],
	[2.0430000000E+04, 1.0231754613E+01, 5.1056502204E+00, 1.4274896431E+00, 1.0059078343E+00, 7.8603402912E-01],
	[2.0435000000E+04, 1.0235483651E+01, 5.1055171785E+00, 1.4286006483E+00, 1.0064902863E+00, 7.8612432756E-01],
	[2.0440000000E+04, 1.0239213136E+01, 5.1053841727E+00, 1.4297122455E+00, 1.0070728274E+00, 7.8621459418E-01],
	[2.0445000000E+04, 1.0242943067E+01, 5.1052512028E+00, 1.4308244349E+00, 1.0076554574E+00, 7.8630482898E-01],
	[2.0450000000E+04, 1.0246673445E+01, 5.1051182690E+00, 1.4319372167E+00, 1.0082381763E+00, 7.8639503197E-01],
	[2.0455000000E+04, 1.0250404268E+01, 5.1049853711E+00, 1.4330505909E+00, 1.0088209838E+00, 7.8648520314E-01],
	[2.0460000000E+04, 1.0254135537E+01, 5.1048525091E+00, 1.4341645579E+00, 1.0094038799E+00, 7.8657534251E-01],
	[2.0465000000E+04, 1.0257867253E+01, 5.1047196830E+00, 1.4352791178E+00, 1.0099868644E+00, 7.8666545005E-01],
	[2.0470000000E+04, 1.0261599414E+01, 5.1045868929E+00, 1.4363942707E+00, 1.0105699372E+00, 7.8675552579E-01],
	[2.0475000000E+04, 1.0265332021E+01, 5.1044541386E+00, 1.4375100169E+00, 1.0111530983E+00, 7.8684556972E-01],
	[2.0480000000E+04, 1.0269065074E+01, 5.1043214202E+00, 1.4386263564E+00, 1.0117363473E+00, 7.8693558184E-01],
	[2.0485000000E+04, 1.0272798573E+01, 5.1041887377E+00, 1.4397432894E+00, 1.0123196843E+00, 7.8702556215E-01],
	[2.0490000000E+04, 1.0276532518E+01, 5.1040560910E+00, 1.4408608162E+00, 1.0129031091E+00, 7.8711551065E-01],
	[2.0495000000E+04, 1.0280266908E+01, 5.1039234801E+00, 1.4419789369E+00, 1.0134866215E+00, 7.8720542735E-01],
	[2.0500000000E+04, 1.0284001744E+01, 5.1037909049E+00, 1.4430976517E+00, 1.0140702215E+00, 7.8729531225E-01],
	[2.0505000000E+04, 1.0287737025E+01, 5.1036583656E+00, 1.4442169607E+00, 1.0146539089E+00, 7.8738516534E-01],
	[2.0510000000E+04, 1.0291472752E+01, 5.1035258620E+00, 1.4453368640E+00, 1.0152376836E+00, 7.8747498663E-01],
	[2.0515000000E+04, 1.0295208924E+01, 5.1033933942E+00, 1.4464573620E+00, 1.0158215455E+00, 7.8756477613E-01],
	[2.0520000000E+04, 1.0298945542E+01, 5.1032609620E+00, 1.4475784547E+00, 1.0164054944E+00, 7.8765453382E-01],
	[2.0525000000E+04, 1.0302682605E+01, 5.1031285656E+00, 1.4487001424E+00, 1.0169895301E+00, 7.8774425971E-01],
	[2.0530000000E+04, 1.0306420113E+01, 5.1029962049E+00, 1.4498224251E+00, 1.0175736527E+00, 7.8783395381E-01],
	[2.0535000000E+04, 1.0310158067E+01, 5.1028638798E+00, 1.4509453030E+00, 1.0181578619E+00, 7.8792361612E-01],
	[2.0540000000E+04, 1.0313896466E+01, 5.1027315903E+00, 1.4520687764E+00, 1.0187421576E+00, 7.8801324663E-01],
	[2.0545000000E+04, 1.0317635309E+01, 5.1025993365E+00, 1.4531928454E+00, 1.0193265397E+00, 7.8810284535E-01],
	[2.0550000000E+04, 1.0321374598E+01, 5.1024671183E+00, 1.4543175102E+00, 1.0199110081E+00, 7.8819241228E-01],
	[2.0555000000E+04, 1.0325114332E+01, 5.1023349357E+00, 1.4554427709E+00, 1.0204955626E+00, 7.8828194742E-01],
	[2.0560000000E+04, 1.0328854511E+01, 5.1022027887E+00, 1.4565686277E+00, 1.0210802032E+00, 7.8837145078E-01],
	[2.0565000000E+04, 1.0332595134E+01, 5.1020706772E+00, 1.4576950808E+00, 1.0216649296E+00, 7.8846092235E-01],
	[2.0570000000E+04, 1.0336336203E+01, 5.1019386012E+00, 1.4588221303E+00, 1.0222497417E+00, 7.8855036213E-01],
	[2.0575000000E+04, 1.0340077716E+01, 5.1018065608E+00, 1.4599497765E+00, 1.0228346395E+00, 7.8863977013E-01],
	[2.0580000000E+04, 1.0343819674E+01, 5.1016745559E+00, 1.4610780194E+00, 1.0234196228E+00, 7.8872914635E-01],
	[2.0585000000E+04, 1.0347562077E+01, 5.1015425864E+00, 1.4622068593E+00, 1.0240046914E+00, 7.8881849079E-01],
	[2.0590000000E+04, 1.0351304924E+01, 5.1014106524E+00, 1.4633362963E+00, 1.0245898453E+00, 7.8890780345E-01],
	[2.0595000000E+04, 1.0355048216E+01, 5.1012787539E+00, 1.4644663307E+00, 1.0251750844E+00, 7.8899708434E-01],
	[2.0600000000E+04, 1.0358791952E+01, 5.1011468908E+00, 1.4655969625E+00, 1.0257604084E+00, 7.8908633345E-01],
	[2.0605000000E+04, 1.0362536133E+01, 5.1010150631E+00, 1.4667281919E+00, 1.0263458172E+00, 7.8917555079E-01],
	[2.0610000000E+04, 1.0366280758E+01, 5.1008832707E+00, 1.4678600192E+00, 1.0269313108E+00, 7.8926473635E-01],
	[2.0615000000E+04, 1.0370025828E+01, 5.1007515138E+00, 1.4689924444E+00, 1.0275168890E+00, 7.8935389015E-01],
	[2.0620000000E+04, 1.0373771341E+01, 5.1006197922E+00, 1.4701254678E+00, 1.0281025517E+00, 7.8944301218E-01],
	[2.0625000000E+04, 1.0377517299E+01, 5.1004881060E+00, 1.4712590895E+00, 1.0286882987E+00, 7.8953210244E-01],
	[2.0630000000E+04, 1.0381263701E+01, 5.1003564550E+00, 1.4723933097E+00, 1.0292741299E+00, 7.8962116094E-01],
	[2.0635000000E+04, 1.0385010548E+01, 5.1002248394E+00, 1.4735281285E+00, 1.0298600453E+00, 7.8971018767E-01],
	[2.0640000000E+04, 1.0388757838E+01, 5.1000932591E+00, 1.4746635462E+00, 1.0304460446E+00, 7.8979918265E-01],
	[2.0645000000E+04, 1.0392505572E+01, 5.0999617140E+00, 1.4757995629E+00, 1.0310321277E+00, 7.8988814586E-01],
	[2.0650000000E+04, 1.0396253751E+01, 5.0998302041E+00, 1.4769361788E+00, 1.0316182946E+00, 7.8997707732E-01],
	[2.0655000000E+04, 1.0400002373E+01, 5.0996987295E+00, 1.4780733940E+00, 1.0322045450E+00, 7.9006597702E-01],
	[2.0660000000E+04, 1.0403751439E+01, 5.0995672901E+00, 1.4792112087E+00, 1.0327908789E+00, 7.9015484497E-01],
	[2.0665000000E+04, 1.0407500949E+01, 5.0994358859E+00, 1.4803496231E+00, 1.0333772961E+00, 7.9024368117E-01],
	[2.0670000000E+04, 1.0411250902E+01, 5.0993045169E+00, 1.4814886374E+00, 1.0339637965E+00, 7.9033248562E-01],
	[2.0675000000E+04, 1.0415001299E+01, 5.0991731830E+00, 1.4826282517E+00, 1.0345503800E+00, 7.9042125831E-01],
	[2.0680000000E+04, 1.0418752140E+01, 5.0990418843E+00, 1.4837684662E+00, 1.0351370464E+00, 7.9050999927E-01],
	[2.0685000000E+04, 1.0422503424E+01, 5.0989106207E+00, 1.4849092810E+00, 1.0357237956E+00, 7.9059870848E-01],
	[2.0690000000E+04, 1.0426255152E+01, 5.0987793922E+00, 1.4860506964E+00, 1.0363106276E+00, 7.9068738594E-01],
	[2.0695000000E+04, 1.0430007324E+01, 5.0986481987E+00, 1.4871927125E+00, 1.0368975420E+00, 7.9077603167E-01],
	[2.0700000000E+04, 1.0433759938E+01, 5.0985170404E+00, 1.4883353295E+00, 1.0374845390E+00, 7.9086464566E-01],
	[2.0705000000E+04, 1.0437512997E+01, 5.0983859171E+00, 1.4894785475E+00, 1.0380716182E+00, 7.9095322791E-01],
	[2.0710000000E+04, 1.0441266498E+01, 5.0982548288E+00, 1.4906223668E+00, 1.0386587796E+00, 7.9104177843E-01],
	[2.0715000000E+04, 1.0445024276E+01, 5.0981249422E+00, 1.4917667874E+00, 1.0392461094E+00, 7.9113029721E-01],
	[2.0720000000E+04, 1.0448793609E+01, 5.0979984705E+00, 1.4929118096E+00, 1.0398337720E+00, 7.9121878427E-01],
	[2.0725000000E+04, 1.0452563392E+01, 5.0978720325E+00, 1.4940574335E+00, 1.0404215170E+00, 7.9130723960E-01],
	[2.0730000000E+04, 1.0456333626E+01, 5.0977456281E+00, 1.4952036594E+00, 1.0410093443E+00, 7.9139566320E-01],
	[2.0735000000E+04, 1.0460104310E+01, 5.0976192573E+00, 1.4963504873E+00, 1.0415972536E+00, 7.9148405508E-01],
	[2.0740000000E+04, 1.0463875444E+01, 5.0974929201E+00, 1.4974979174E+00, 1.0421852449E+00, 7.9157241524E-01],
	[2.0745000000E+04, 1.0467647028E+01, 5.0973666165E+00, 1.4986459500E+00, 1.0427733182E+00, 7.9166074368E-01],
	[2.0750000000E+04, 1.0471419062E+01, 5.0972403465E+00, 1.4997945851E+00, 1.0433614731E+00, 7.9174904040E-01],
	[2.0755000000E+04, 1.0475191546E+01, 5.0971141100E+00, 1.5009438230E+00, 1.0439497097E+00, 7.9183730541E-01],
	[2.0760000000E+04, 1.0478964480E+01, 5.0969879071E+00, 1.5020936638E+00, 1.0445380277E+00, 7.9192553868E-01],
	[2.0765000000E+04, 1.0482737864E+01, 5.0968617377E+00, 1.5032441077E+00, 1.0451264271E+00, 7.9201374019E-01],
	[2.0770000000E+04, 1.0486511697E+01, 5.0967356017E+00, 1.5043951549E+00, 1.0457149077E+00, 7.9210190997E-01],
	[2.0775000000E+04, 1.0490285981E+01, 5.0966094993E+00, 1.5055468055E+00, 1.0463034694E+00, 7.9219004801E-01],
	[2.0780000000E+04, 1.0494060714E+01, 5.0964834303E+00, 1.5066990597E+00, 1.0468921121E+00, 7.9227815432E-01],
	[2.0785000000E+04, 1.0497835896E+01, 5.0963573948E+00, 1.5078519177E+00, 1.0474808357E+00, 7.9236622890E-01],
	[2.0790000000E+04, 1.0501611529E+01, 5.0962313927E+00, 1.5090053796E+00, 1.0480696399E+00, 7.9245427178E-01],
	[2.0795000000E+04, 1.0505387610E+01, 5.0961054240E+00, 1.5101594457E+00, 1.0486585248E+00, 7.9254228295E-01],
	[2.0800000000E+04, 1.0509164141E+01, 5.0959794887E+00, 1.5113141160E+00, 1.0492474901E+00, 7.9263026242E-01],
	[2.0805000000E+04, 1.0512941122E+01, 5.0958535868E+00, 1.5124693908E+00, 1.0498365358E+00, 7.9271821020E-01],
	[2.0810000000E+04, 1.0516718552E+01, 5.0957277182E+00, 1.5136252703E+00, 1.0504256616E+00, 7.9280612629E-01],
	[2.0815000000E+04, 1.0520496431E+01, 5.0956018830E+00, 1.5147817545E+00, 1.0510148676E+00, 7.9289401071E-01],
	[2.0820000000E+04, 1.0524274760E+01, 5.0954760811E+00, 1.5159388437E+00, 1.0516041534E+00, 7.9298186346E-01],
	[2.0825000000E+04, 1.0528053537E+01, 5.0953503126E+00, 1.5170965381E+00, 1.0521935192E+00, 7.9306968455E-01],
	[2.0830000000E+04, 1.0531832764E+01, 5.0952245773E+00, 1.5182548377E+00, 1.0527829646E+00, 7.9315747399E-01],
	[2.0835000000E+04, 1.0535612440E+01, 5.0950988753E+00, 1.5194137429E+00, 1.0533724896E+00, 7.9324523178E-01],
	[2.0840000000E+04, 1.0539392565E+01, 5.0949732066E+00, 1.5205732537E+00, 1.0539620940E+00, 7.9333295793E-01],
	[2.0845000000E+04, 1.0543173139E+01, 5.0948475711E+00, 1.5217333703E+00, 1.0545517777E+00, 7.9342065246E-01],
	[2.0850000000E+04, 1.0546954161E+01, 5.0947219689E+00, 1.5228940929E+00, 1.0551415406E+00, 7.9350831536E-01],
	[2.0855000000E+04, 1.0550735633E+01, 5.0945963998E+00, 1.5240554217E+00, 1.0557313826E+00, 7.9359594664E-01],
	[2.0860000000E+04, 1.0554517553E+01, 5.0944708640E+00, 1.5252173568E+00, 1.0563213036E+00, 7.9368354632E-01],
	[2.0865000000E+04, 1.0558299923E+01, 5.0943453613E+00, 1.5263798984E+00, 1.0569113033E+00, 7.9377111439E-01],
	[2.0870000000E+04, 1.0562082741E+01, 5.0942198918E+00, 1.5275430467E+00, 1.0575013817E+00, 7.9385865088E-01],
	[2.0875000000E+04, 1.0565866007E+01, 5.0940944555E+00, 1.5287068019E+00, 1.0580915386E+00, 7.9394615578E-01],
	[2.0880000000E+04, 1.0569649722E+01, 5.0939690523E+00, 1.5298711640E+00, 1.0586817740E+00, 7.9403362910E-01],
	[2.0885000000E+04, 1.0573433886E+01, 5.0938436822E+00, 1.5310361334E+00, 1.0592720877E+00, 7.9412107085E-01],
	[2.0890000000E+04, 1.0577218498E+01, 5.0937183451E+00, 1.5322017101E+00, 1.0598624795E+00, 7.9420848104E-01],
	[2.0895000000E+04, 1.0581003559E+01, 5.0935930412E+00, 1.5333678944E+00, 1.0604529494E+00, 7.9429585967E-01],
	[2.0900000000E+04, 1.0584789068E+01, 5.0934677703E+00, 1.5345346863E+00, 1.0610434971E+00, 7.9438320676E-01],
	[2.0905000000E+04, 1.0588575025E+01, 5.0933425325E+00, 1.5357020862E+00, 1.0616341227E+00, 7.9447052231E-01],
	[2.0910000000E+04, 1.0592361430E+01, 5.0932173277E+00, 1.5368700940E+00, 1.0622248259E+00, 7.9455780633E-01],
	[2.0915000000E+04, 1.0596148284E+01, 5.0930921559E+00, 1.5380387101E+00, 1.0628156067E+00, 7.9464505883E-01],
	[2.0920000000E+04, 1.0599935586E+01, 5.0929670171E+00, 1.5392079346E+00, 1.0634064648E+00, 7.9473227980E-01],
	[2.0925000000E+04, 1.0603723336E+01, 5.0928419113E+00, 1.5403777676E+00, 1.0639974002E+00, 7.9481946928E-01],
	[2.0930000000E+04, 1.0607511534E+01, 5.0927168384E+00, 1.5415482094E+00, 1.0645884128E+00, 7.9490662724E-01],
	[2.0935000000E+04, 1.0611300180E+01, 5.0925917985E+00, 1.5427192600E+00, 1.0651795024E+00, 7.9499375372E-01],
	[2.0940000000E+04, 1.0615089274E+01, 5.0924667915E+00, 1.5438909198E+00, 1.0657706689E+00, 7.9508084871E-01],
	[2.0945000000E+04, 1.0618878816E+01, 5.0923418175E+00, 1.5450631887E+00, 1.0663619121E+00, 7.9516791223E-01],
	[2.0950000000E+04, 1.0622668806E+01, 5.0922168763E+00, 1.5462360671E+00, 1.0669532320E+00, 7.9525494427E-01],
	[2.0955000000E+04, 1.0626459243E+01, 5.0920919680E+00, 1.5474095550E+00, 1.0675446284E+00, 7.9534194485E-01],
	[2.0960000000E+04, 1.0630250128E+01, 5.0919670926E+00, 1.5485836527E+00, 1.0681361011E+00, 7.9542891398E-01],
	[2.0965000000E+04, 1.0634041461E+01, 5.0918422500E+00, 1.5497583604E+00, 1.0687276501E+00, 7.9551585166E-01],
	[2.0970000000E+04, 1.0637833242E+01, 5.0917174402E+00, 1.5509336781E+00, 1.0693192753E+00, 7.9560275790E-01],
	[2.0975000000E+04, 1.0641625470E+01, 5.0915926633E+00, 1.5521096061E+00, 1.0699109764E+00, 7.9568963271E-01],
	[2.0980000000E+04, 1.0645418145E+01, 5.0914679192E+00, 1.5532861445E+00, 1.0705027534E+00, 7.9577647610E-01],
	[2.0985000000E+04, 1.0649211268E+01, 5.0913432078E+00, 1.5544632935E+00, 1.0710946061E+00, 7.9586328807E-01],
	[2.0990000000E+04, 1.0653004839E+01, 5.0912185292E+00, 1.5556410533E+00, 1.0716865345E+00, 7.9595006864E-01],
	[2.0995000000E+04, 1.0656798857E+01, 5.0910938834E+00, 1.5568194240E+00, 1.0722785383E+00, 7.9603681780E-01],
	[2.1000000000E+04, 1.0660593322E+01, 5.0909692702E+00, 1.5579984059E+00, 1.0728706175E+00, 7.9612353557E-01],
	[2.1005000000E+04, 1.0664388234E+01, 5.0908446898E+00, 1.5591779991E+00, 1.0734627720E+00, 7.9621022196E-01],
	[2.1010000000E+04, 1.0668183593E+01, 5.0907201421E+00, 1.5603582037E+00, 1.0740550015E+00, 7.9629687697E-01],
	[2.1015000000E+04, 1.0671979400E+01, 5.0905956271E+00, 1.5615390199E+00, 1.0746473060E+00, 7.9638350061E-01],
	[2.1020000000E+04, 1.0675775654E+01, 5.0904711448E+00, 1.5627204480E+00, 1.0752396854E+00, 7.9647009289E-01],
	[2.1025000000E+04, 1.0679572355E+01, 5.0903466951E+00, 1.5639024880E+00, 1.0758321395E+00, 7.9655665382E-01],
	[2.1030000000E+04, 1.0683369502E+01, 5.0902222780E+00, 1.5650851401E+00, 1.0764246682E+00, 7.9664318340E-01],
	[2.1035000000E+04, 1.0687167097E+01, 5.0900978935E+00, 1.5662684046E+00, 1.0770172713E+00, 7.9672968164E-01],
	[2.1040000000E+04, 1.0690965138E+01, 5.0899735417E+00, 1.5674522816E+00, 1.0776099488E+00, 7.9681614855E-01],
	[2.1045000000E+04, 1.0694763627E+01, 5.0898492224E+00, 1.5686367712E+00, 1.0782027005E+00, 7.9690258415E-01],
	[2.1050000000E+04, 1.0698571188E+01, 5.0897274614E+00, 1.5698218736E+00, 1.0787957274E+00, 7.9698898842E-01],
	[2.1055000000E+04, 1.0702385869E+01, 5.0896076842E+00, 1.5710075891E+00, 1.0793889843E+00, 7.9707536139E-01],
	[2.1060000000E+04, 1.0706201004E+01, 5.0894879383E+00, 1.5721939177E+00, 1.0799823156E+00, 7.9716170306E-01],
	[2.1065000000E+04, 1.0710016593E+01, 5.0893682236E+00, 1.5733808597E+00, 1.0805757212E+00, 7.9724801345E-01],
	[2.1070000000E+04, 1.0713832636E+01, 5.0892485402E+00, 1.5745684151E+00, 1.0811692010E+00, 7.9733429254E-01],
	[2.1075000000E+04, 1.0717649133E+01, 5.0891288879E+00, 1.5757565843E+00, 1.0817627548E+00, 7.9742054037E-01],
	[2.1080000000E+04, 1.0721466083E+01, 5.0890092669E+00, 1.5769453673E+00, 1.0823563825E+00, 7.9750675692E-01],
	[2.1085000000E+04, 1.0725283487E+01, 5.0888896770E+00, 1.5781347643E+00, 1.0829500841E+00, 7.9759294222E-01],
	[2.1090000000E+04, 1.0729101344E+01, 5.0887701183E+00, 1.5793247755E+00, 1.0835438592E+00, 7.9767909627E-01],
	[2.1095000000E+04, 1.0732919655E+01, 5.0886505908E+00, 1.5805154011E+00, 1.0841377080E+00, 7.9776521907E-01],
	[2.1100000000E+04, 1.0736738420E+01, 5.0885310944E+00, 1.5817066412E+00, 1.0847316301E+00, 7.9785131064E-01],
	[2.1105000000E+04, 1.0740557638E+01, 5.0884116291E+00, 1.5828984961E+00, 1.0853256255E+00, 7.9793737098E-01],
	[2.1110000000E+04, 1.0744377309E+01, 5.0882921949E+00, 1.5840909658E+00, 1.0859196941E+00, 7.9802340009E-01],
	[2.1115000000E+04, 1.0748197433E+01, 5.0881727918E+00, 1.5852840506E+00, 1.0865138357E+00, 7.9810939800E-01],
	[2.1120000000E+04, 1.0752018011E+01, 5.0880534198E+00, 1.5864777505E+00, 1.0871080502E+00, 7.9819536470E-01],
	[2.1125000000E+04, 1.0755839042E+01, 5.0879340788E+00, 1.5876720659E+00, 1.0877023375E+00, 7.9828130021E-01],
	[2.1130000000E+04, 1.0759660526E+01, 5.0878147688E+00, 1.5888669969E+00, 1.0882966974E+00, 7.9836720453E-01],
	[2.1135000000E+04, 1.0763482464E+01, 5.0876954899E+00, 1.5900625435E+00, 1.0888911298E+00, 7.9845307767E-01],
	[2.1140000000E+04, 1.0767304854E+01, 5.0875762420E+00, 1.5912587061E+00, 1.0894856346E+00, 7.9853891964E-01],
	[2.1145000000E+04, 1.0771127697E+01, 5.0874570251E+00, 1.5924554848E+00, 1.0900802117E+00, 7.9862473044E-01],
	[2.1150000000E+04, 1.0774950993E+01, 5.0873378392E+00, 1.5936528797E+00, 1.0906748609E+00, 7.9871051009E-01],
	[2.1155000000E+04, 1.0778774742E+01, 5.0872186842E+00, 1.5948508910E+00, 1.0912695822E+00, 7.9879625858E-01],
	[2.1160000000E+04, 1.0782598944E+01, 5.0870995602E+00, 1.5960495189E+00, 1.0918643753E+00, 7.9888197594E-01],
	[2.1165000000E+04, 1.0786423599E+01, 5.0869804672E+00, 1.5972487636E+00, 1.0924592402E+00, 7.9896766217E-01],
	[2.1170000000E+04, 1.0790248706E+01, 5.0868614050E+00, 1.5984486252E+00, 1.0930541767E+00, 7.9905331727E-01],
	[2.1175000000E+04, 1.0794074267E+01, 5.0867423737E+00, 1.5996491039E+00, 1.0936491847E+00, 7.9913894125E-01],
	[2.1180000000E+04, 1.0797900279E+01, 5.0866233734E+00, 1.6008501999E+00, 1.0942442640E+00, 7.9922453413E-01],
	[2.1185000000E+04, 1.0801726745E+01, 5.0865044039E+00, 1.6020519133E+00, 1.0948394146E+00, 7.9931009590E-01],
	[2.1190000000E+04, 1.0805553662E+01, 5.0863854652E+00, 1.6032542444E+00, 1.0954346364E+00, 7.9939562658E-01],
	[2.1195000000E+04, 1.0809381033E+01, 5.0862665574E+00, 1.6044571932E+00, 1.0960299291E+00, 7.9948112618E-01],
	[2.1200000000E+04, 1.0813208855E+01, 5.0861476805E+00, 1.6056607600E+00, 1.0966252927E+00, 7.9956659470E-01],
	[2.1205000000E+04, 1.0817037130E+01, 5.0860288343E+00, 1.6068649449E+00, 1.0972207270E+00, 7.9965203215E-01],
	[2.1210000000E+04, 1.0820865857E+01, 5.0859100189E+00, 1.6080697481E+00, 1.0978162320E+00, 7.9973743855E-01],
	[2.1215000000E+04, 1.0824695037E+01, 5.0857912344E+00, 1.6092751698E+00, 1.0984118074E+00, 7.9982281388E-01],
	[2.1220000000E+04, 1.0828524669E+01, 5.0856724805E+00, 1.6104812102E+00, 1.0990074532E+00, 7.9990815818E-01],
	[2.1225000000E+04, 1.0832354752E+01, 5.0855537575E+00, 1.6116878693E+00, 1.0996031692E+00, 7.9999347144E-01],
	[2.1230000000E+04, 1.0836185288E+01, 5.0854350651E+00, 1.6128951475E+00, 1.1001989553E+00, 8.0007875367E-01],
	[2.1235000000E+04, 1.0840016276E+01, 5.0853164035E+00, 1.6141030448E+00, 1.1007948114E+00, 8.0016400488E-01],
	[2.1240000000E+04, 1.0843847716E+01, 5.0851977726E+00, 1.6153115614E+00, 1.1013907374E+00, 8.0024922507E-01],
	[2.1245000000E+04, 1.0847679608E+01, 5.0850791724E+00, 1.6165206975E+00, 1.1019867330E+00, 8.0033441427E-01],
	[2.1250000000E+04, 1.0851511952E+01, 5.0849606029E+00, 1.6177304533E+00, 1.1025827983E+00, 8.0041957246E-01],
	[2.1255000000E+04, 1.0855344747E+01, 5.0848420640E+00, 1.6189408290E+00, 1.1031789330E+00, 8.0050469967E-01],
	[2.1260000000E+04, 1.0859177995E+01, 5.0847235557E+00, 1.6201518246E+00, 1.1037751370E+00, 8.0058979590E-01],
	[2.1265000000E+04, 1.0863011694E+01, 5.0846050781E+00, 1.6213634405E+00, 1.1043714103E+00, 8.0067486116E-01],
	[2.1270000000E+04, 1.0866845844E+01, 5.0844866311E+00, 1.6225756767E+00, 1.1049677527E+00, 8.0075989545E-01],
	[2.1275000000E+04, 1.0870680447E+01, 5.0843682147E+00, 1.6237885334E+00, 1.1055641640E+00, 8.0084489879E-01],
	[2.1280000000E+04, 1.0874515501E+01, 5.0842498289E+00, 1.6250020108E+00, 1.1061606441E+00, 8.0092987117E-01],
	[2.1285000000E+04, 1.0878351006E+01, 5.0841314737E+00, 1.6262161091E+00, 1.1067571929E+00, 8.0101481262E-01],
	[2.1290000000E+04, 1.0882186963E+01, 5.0840131490E+00, 1.6274308284E+00, 1.1073538104E+00, 8.0109972314E-01],
	[2.1295000000E+04, 1.0886023371E+01, 5.0838948548E+00, 1.6286461690E+00, 1.1079504962E+00, 8.0118460273E-01],
	[2.1300000000E+04, 1.0889860230E+01, 5.0837765912E+00, 1.6298621309E+00, 1.1085472504E+00, 8.0126945132E-01],
	[2.1305000000E+04, 1.0893697541E+01, 5.0836583580E+00, 1.6310787144E+00, 1.1091440728E+00, 8.0135426889E-01],
	[2.1310000000E+04, 1.0897535303E+01, 5.0835401554E+00, 1.6322959196E+00, 1.1097409633E+00, 8.0143905543E-01],
	[2.1315000000E+04, 1.0901373516E+01, 5.0834219833E+00, 1.6335137467E+00, 1.1103379217E+00, 8.0152381095E-01],
	[2.1320000000E+04, 1.0905212181E+01, 5.0833038416E+00, 1.6347321959E+00, 1.1109349479E+00, 8.0160853544E-01],
	[2.1325000000E+04, 1.0909051296E+01, 5.0831857303E+00, 1.6359512673E+00, 1.1115320418E+00, 8.0169322892E-01],
	[2.1330000000E+04, 1.0912890863E+01, 5.0830676495E+00, 1.6371709611E+00, 1.1121292033E+00, 8.0177789138E-01],
	[2.1335000000E+04, 1.0916730880E+01, 5.0829495991E+00, 1.6383912775E+00, 1.1127264322E+00, 8.0186252283E-01],
	[2.1340000000E+04, 1.0920571348E+01, 5.0828315791E+00, 1.6396122167E+00, 1.1133237284E+00, 8.0194712326E-01],
	[2.1345000000E+04, 1.0924412268E+01, 5.0827135895E+00, 1.6408337788E+00, 1.1139210917E+00, 8.0203169268E-01],
	[2.1350000000E+04, 1.0928253638E+01, 5.0825956303E+00, 1.6420559639E+00, 1.1145185222E+00, 8.0211623110E-01],
	[2.1355000000E+04, 1.0932095458E+01, 5.0824777015E+00, 1.6432787724E+00, 1.1151160195E+00, 8.0220073851E-01],
	[2.1360000000E+04, 1.0935937730E+01, 5.0823598029E+00, 1.6445022043E+00, 1.1157135837E+00, 8.0228521492E-01],
	[2.1365000000E+04, 1.0939780452E+01, 5.0822419347E+00, 1.6457262598E+00, 1.1163112145E+00, 8.0236966032E-01],
	[2.1370000000E+04, 1.0943623625E+01, 5.0821240969E+00, 1.6469509391E+00, 1.1169089119E+00, 8.0245407473E-01],
	[2.1375000000E+04, 1.0947467248E+01, 5.0820062893E+00, 1.6481762423E+00, 1.1175066757E+00, 8.0253845814E-01],
	[2.1380000000E+04, 1.0951311322E+01, 5.0818885120E+00, 1.6494021697E+00, 1.1181045058E+00, 8.0262281056E-01],
	[2.1385000000E+04, 1.0955155846E+01, 5.0817707649E+00, 1.6506287213E+00, 1.1187024020E+00, 8.0270713198E-01],
	[2.1390000000E+04, 1.0959013309E+01, 5.0816565665E+00, 1.6518558974E+00, 1.1193006652E+00, 8.0279142242E-01],
	[2.1395000000E+04, 1.0962874393E+01, 5.0815432887E+00, 1.6530836982E+00, 1.1198990712E+00, 8.0287568187E-01],
	[2.1400000000E+04, 1.0966735935E+01, 5.0814300400E+00, 1.6543121238E+00, 1.1204975436E+00, 8.0295991034E-01],
	[2.1405000000E+04, 1.0970597935E+01, 5.0813168202E+00, 1.6555411743E+00, 1.1210960822E+00, 8.0304410782E-01],
	[2.1410000000E+04, 1.0974460392E+01, 5.0812036293E+00, 1.6567708500E+00, 1.1216946870E+00, 8.0312827433E-01],
	[2.1415000000E+04, 1.0978323306E+01, 5.0810904675E+00, 1.6580011511E+00, 1.1222933578E+00, 8.0321240986E-01],
	[2.1420000000E+04, 1.0982186678E+01, 5.0809773345E+00, 1.6592320776E+00, 1.1228920945E+00, 8.0329651441E-01],
	[2.1425000000E+04, 1.0986050507E+01, 5.0808642305E+00, 1.6604636298E+00, 1.1234908969E+00, 8.0338058799E-01],
	[2.1430000000E+04, 1.0989914794E+01, 5.0807511554E+00, 1.6616958078E+00, 1.1240897650E+00, 8.0346463061E-01],
	[2.1435000000E+04, 1.0993779538E+01, 5.0806381092E+00, 1.6629286119E+00, 1.1246886986E+00, 8.0354864225E-01],
	[2.1440000000E+04, 1.0997644739E+01, 5.0805250918E+00, 1.6641620421E+00, 1.1252876976E+00, 8.0363262294E-01],
	[2.1445000000E+04, 1.1001510397E+01, 5.0804121034E+00, 1.6653960987E+00, 1.1258867618E+00, 8.0371657266E-01],
	[2.1450000000E+04, 1.1005376512E+01, 5.0802991438E+00, 1.6666307818E+00, 1.1264858912E+00, 8.0380049142E-01],
	[2.1455000000E+04, 1.1009243085E+01, 5.0801862130E+00, 1.6678660916E+00, 1.1270850856E+00, 8.0388437923E-01],
	[2.1460000000E+04, 1.1013110114E+01, 5.0800733110E+00, 1.6691020283E+00, 1.1276843448E+00, 8.0396823608E-01],
	[2.1465000000E+04, 1.1016977601E+01, 5.0799604379E+00, 1.6703385920E+00, 1.1282836688E+00, 8.0405206198E-01],
	[2.1470000000E+04, 1.1020845544E+01, 5.0798475935E+00, 1.6715757829E+00, 1.1288830575E+00, 8.0413585693E-01],
	[2.1475000000E+04, 1.1024713944E+01, 5.0797347780E+00, 1.6728136012E+00, 1.1294825106E+00, 8.0421962094E-01],
	[2.1480000000E+04, 1.1028582801E+01, 5.0796219912E+00, 1.6740520471E+00, 1.1300820281E+00, 8.0430335401E-01],
	[2.1485000000E+04, 1.1032452114E+01, 5.0795092331E+00, 1.6752911207E+00, 1.1306816099E+00, 8.0438705613E-01],
	[2.1490000000E+04, 1.1036321885E+01, 5.0793965038E+00, 1.6765308222E+00, 1.1312812557E+00, 8.0447072732E-01],
	[2.1495000000E+04, 1.1040192112E+01, 5.0792838033E+00, 1.6777711517E+00, 1.1318809656E+00, 8.0455436758E-01],
	[2.1500000000E+04, 1.1044062795E+01, 5.0791711314E+00, 1.6790121095E+00, 1.1324807393E+00, 8.0463797690E-01],
	[2.1505000000E+04, 1.1047933935E+01, 5.0790584882E+00, 1.6802536957E+00, 1.1330805768E+00, 8.0472155529E-01],
	[2.1510000000E+04, 1.1051805532E+01, 5.0789458738E+00, 1.6814959105E+00, 1.1336804778E+00, 8.0480510276E-01],
	[2.1515000000E+04, 1.1055677585E+01, 5.0788332880E+00, 1.6827387540E+00, 1.1342804424E+00, 8.0488861930E-01],
	[2.1520000000E+04, 1.1059550094E+01, 5.0787207308E+00, 1.6839822265E+00, 1.1348804703E+00, 8.0497210493E-01],
	[2.1525000000E+04, 1.1063423060E+01, 5.0786082023E+00, 1.6852263281E+00, 1.1354805615E+00, 8.0505555963E-01],
	[2.1530000000E+04, 1.1067296482E+01, 5.0784957024E+00, 1.6864710589E+00, 1.1360807158E+00, 8.0513898343E-01],
	[2.1535000000E+04, 1.1071170360E+01, 5.0783832311E+00, 1.6877164192E+00, 1.1366809330E+00, 8.0522237631E-01],
	[2.1540000000E+04, 1.1075044694E+01, 5.0782707885E+00, 1.6889624091E+00, 1.1372812131E+00, 8.0530573828E-01],
	[2.1545000000E+04, 1.1078919485E+01, 5.0781583744E+00, 1.6902090288E+00, 1.1378815559E+00, 8.0538906934E-01],
	[2.1550000000E+04, 1.1082794731E+01, 5.0780459889E+00, 1.6914562784E+00, 1.1384819614E+00, 8.0547236951E-01],
	[2.1555000000E+04, 1.1086670434E+01, 5.0779336319E+00, 1.6927041581E+00, 1.1390824293E+00, 8.0555563877E-01],
	[2.1560000000E+04, 1.1090546592E+01, 5.0778213035E+00, 1.6939526682E+00, 1.1396829595E+00, 8.0563887714E-01],
	[2.1565000000E+04, 1.1094423206E+01, 5.0777090037E+00, 1.6952018087E+00, 1.1402835520E+00, 8.0572208461E-01],
	[2.1570000000E+04, 1.1098300277E+01, 5.0775967323E+00, 1.6964515799E+00, 1.1408842066E+00, 8.0580526119E-01],
	[2.1575000000E+04, 1.1102177803E+01, 5.0774844895E+00, 1.6977019819E+00, 1.1414849232E+00, 8.0588840689E-01],
	[2.1580000000E+04, 1.1106055784E+01, 5.0773722751E+00, 1.6989530149E+00, 1.1420857016E+00, 8.0597152170E-01],
	[2.1585000000E+04, 1.1109934222E+01, 5.0772600892E+00, 1.7002046790E+00, 1.1426865417E+00, 8.0605460562E-01],
	[2.1590000000E+04, 1.1113813115E+01, 5.0771479318E+00, 1.7014569745E+00, 1.1432874434E+00, 8.0613765867E-01],
	[2.1595000000E+04, 1.1117692464E+01, 5.0770358028E+00, 1.7027099014E+00, 1.1438884066E+00, 8.0622068085E-01],
	[2.1600000000E+04, 1.1121572268E+01, 5.0769237023E+00, 1.7039634601E+00, 1.1444894311E+00, 8.0630367215E-01],
	[2.1605000000E+04, 1.1125452528E+01, 5.0768116301E+00, 1.7052176505E+00, 1.1450905168E+00, 8.0638663258E-01],
	[2.1610000000E+04, 1.1129333243E+01, 5.0766995864E+00, 1.7064724730E+00, 1.1456916636E+00, 8.0646956215E-01],
	[2.1615000000E+04, 1.1133214413E+01, 5.0765875711E+00, 1.7077279277E+00, 1.1462928714E+00, 8.0655246085E-01],
	[2.1620000000E+04, 1.1137096039E+01, 5.0764755842E+00, 1.7089840148E+00, 1.1468941400E+00, 8.0663532870E-01],
	[2.1625000000E+04, 1.1140978120E+01, 5.0763636256E+00, 1.7102407343E+00, 1.1474954694E+00, 8.0671816569E-01],
	[2.1630000000E+04, 1.1144860657E+01, 5.0762516954E+00, 1.7114980866E+00, 1.1480968593E+00, 8.0680097182E-01],
	[2.1635000000E+04, 1.1148743648E+01, 5.0761397935E+00, 1.7127560718E+00, 1.1486983096E+00, 8.0688374711E-01],
	[2.1640000000E+04, 1.1152627095E+01, 5.0760279199E+00, 1.7140146900E+00, 1.1492998203E+00, 8.0696649155E-01],
	[2.1645000000E+04, 1.1156510997E+01, 5.0759160746E+00, 1.7152739414E+00, 1.1499013912E+00, 8.0704920515E-01],
	[2.1650000000E+04, 1.1160395354E+01, 5.0758042577E+00, 1.7165338262E+00, 1.1505030222E+00, 8.0713188790E-01],
	[2.1655000000E+04, 1.1164280165E+01, 5.0756924690E+00, 1.7177943446E+00, 1.1511047131E+00, 8.0721453982E-01],
	[2.1660000000E+04, 1.1168165432E+01, 5.0755807086E+00, 1.7190554967E+00, 1.1517064639E+00, 8.0729716091E-01],
	[2.1665000000E+04, 1.1172051153E+01, 5.0754689765E+00, 1.7203172827E+00, 1.1523082743E+00, 8.0737975117E-01],
	[2.1670000000E+04, 1.1175937330E+01, 5.0753572726E+00, 1.7215797028E+00, 1.1529101444E+00, 8.0746231060E-01],
	[2.1675000000E+04, 1.1179823961E+01, 5.0752455969E+00, 1.7228427571E+00, 1.1535120739E+00, 8.0754483920E-01],
	[2.1680000000E+04, 1.1183711047E+01, 5.0751339494E+00, 1.7241064459E+00, 1.1541140627E+00, 8.0762733699E-01],
	[2.1685000000E+04, 1.1187598587E+01, 5.0750223302E+00, 1.7253707692E+00, 1.1547161107E+00, 8.0770980396E-01],
	[2.1690000000E+04, 1.1191486582E+01, 5.0749107391E+00, 1.7266357273E+00, 1.1553182177E+00, 8.0779224012E-01],
	[2.1695000000E+04, 1.1195375032E+01, 5.0747991762E+00, 1.7279013204E+00, 1.1559203837E+00, 8.0787464547E-01],
	[2.1700000000E+04, 1.1199263936E+01, 5.0746876414E+00, 1.7291675485E+00, 1.1565226086E+00, 8.0795702001E-01],
	[2.1705000000E+04, 1.1203153295E+01, 5.0745761349E+00, 1.7304344120E+00, 1.1571248921E+00, 8.0803936375E-01],
	[2.1710000000E+04, 1.1207043108E+01, 5.0744646564E+00, 1.7317019108E+00, 1.1577272342E+00, 8.0812167669E-01],
	[2.1715000000E+04, 1.1210933375E+01, 5.0743532061E+00, 1.7329700454E+00, 1.1583296347E+00, 8.0820395883E-01],
	[2.1720000000E+04, 1.1214824097E+01, 5.0742417838E+00, 1.7342388157E+00, 1.1589320936E+00, 8.0828621019E-01],
	[2.1725000000E+04, 1.1218715273E+01, 5.0741303897E+00, 1.7355082219E+00, 1.1595346106E+00, 8.0836843075E-01],
	[2.1730000000E+04, 1.1222606903E+01, 5.0740190236E+00, 1.7367782643E+00, 1.1601371857E+00, 8.0845062053E-01],
	[2.1735000000E+04, 1.1226514055E+01, 5.0739117712E+00, 1.7380489431E+00, 1.1607401936E+00, 8.0853277953E-01],
	[2.1740000000E+04, 1.1230422618E+01, 5.0738048032E+00, 1.7393202583E+00, 1.1613432836E+00, 8.0861490775E-01],
	[2.1745000000E+04, 1.1234331642E+01, 5.0736978621E+00, 1.7405922101E+00, 1.1619464319E+00, 8.0869700520E-01],
	[2.1750000000E+04, 1.1238241128E+01, 5.0735909478E+00, 1.7418647988E+00, 1.1625496383E+00, 8.0877907187E-01],
	[2.1755000000E+04, 1.1242151076E+01, 5.0734840603E+00, 1.7431380245E+00, 1.1631529029E+00, 8.0886110778E-01],
	[2.1760000000E+04, 1.1246061484E+01, 5.0733771996E+00, 1.7444118874E+00, 1.1637562253E+00, 8.0894311293E-01],
	[2.1765000000E+04, 1.1249972354E+01, 5.0732703658E+00, 1.7456863876E+00, 1.1643596056E+00, 8.0902508732E-01],
	[2.1770000000E+04, 1.1253883686E+01, 5.0731635587E+00, 1.7469615253E+00, 1.1649630436E+00, 8.0910703095E-01],
	[2.1775000000E+04, 1.1257795478E+01, 5.0730567784E+00, 1.7482373007E+00, 1.1655665391E+00, 8.0918894383E-01],
	[2.1780000000E+04, 1.1261707732E+01, 5.0729500249E+00, 1.7495137139E+00, 1.1661700921E+00, 8.0927082596E-01],
	[2.1785000000E+04, 1.1265620446E+01, 5.0728432981E+00, 1.7507907652E+00, 1.1667737023E+00, 8.0935267734E-01],
	[2.1790000000E+04, 1.1269533622E+01, 5.0727365981E+00, 1.7520684547E+00, 1.1673773698E+00, 8.0943449799E-01],
	[2.1795000000E+04, 1.1273447258E+01, 5.0726299248E+00, 1.7533467826E+00, 1.1679810943E+00, 8.0951628789E-01],
	[2.1800000000E+04, 1.1277361356E+01, 5.0725232782E+00, 1.7546257490E+00, 1.1685848757E+00, 8.0959804707E-01],
	[2.1805000000E+04, 1.1281275914E+01, 5.0724166582E+00, 1.7559053541E+00, 1.1691887140E+00, 8.0967977551E-01],
	[2.1810000000E+04, 1.1285190933E+01, 5.0723100650E+00, 1.7571855981E+00, 1.1697926089E+00, 8.0976147323E-01],
	[2.1815000000E+04, 1.1289106413E+01, 5.0722034985E+00, 1.7584664812E+00, 1.1703965604E+00, 8.0984314023E-01],
	[2.1820000000E+04, 1.1293022354E+01, 5.0720969586E+00, 1.7597480035E+00, 1.1710005683E+00, 8.0992477651E-01],
	[2.1825000000E+04, 1.1296938755E+01, 5.0719904454E+00, 1.7610301652E+00, 1.1716046325E+00, 8.1000638207E-01],
	[2.1830000000E+04, 1.1300855617E+01, 5.0718839588E+00, 1.7623129665E+00, 1.1722087530E+00, 8.1008795693E-01],
	[2.1835000000E+04, 1.1304772940E+01, 5.0717774988E+00, 1.7635964076E+00, 1.1728129294E+00, 8.1016950107E-01],
	[2.1840000000E+04, 1.1308690723E+01, 5.0716710654E+00, 1.7648804885E+00, 1.1734171618E+00, 8.1025101452E-01],
	[2.1845000000E+04, 1.1312608966E+01, 5.0715646586E+00, 1.7661652096E+00, 1.1740214500E+00, 8.1033249727E-01],
	[2.1850000000E+04, 1.1316527670E+01, 5.0714582784E+00, 1.7674505709E+00, 1.1746257939E+00, 8.1041394932E-01],
	[2.1855000000E+04, 1.1320446834E+01, 5.0713519248E+00, 1.7687365727E+00, 1.1752301933E+00, 8.1049537068E-01],
	[2.1860000000E+04, 1.1324366459E+01, 5.0712455977E+00, 1.7700232151E+00, 1.1758346482E+00, 8.1057676135E-01],
	[2.1865000000E+04, 1.1328286543E+01, 5.0711392972E+00, 1.7713104982E+00, 1.1764391583E+00, 8.1065812134E-01],
	[2.1870000000E+04, 1.1332207088E+01, 5.0710330232E+00, 1.7725984223E+00, 1.1770437237E+00, 8.1073945066E-01],
	[2.1875000000E+04, 1.1336128093E+01, 5.0709267758E+00, 1.7738869876E+00, 1.1776483440E+00, 8.1082074930E-01],
	[2.1880000000E+04, 1.1340049559E+01, 5.0708205548E+00, 1.7751761941E+00, 1.1782530194E+00, 8.1090201726E-01],
	[2.1885000000E+04, 1.1343971484E+01, 5.0707143604E+00, 1.7764660421E+00, 1.1788577495E+00, 8.1098325456E-01],
	[2.1890000000E+04, 1.1347893869E+01, 5.0706081924E+00, 1.7777565317E+00, 1.1794625343E+00, 8.1106446120E-01],
	[2.1895000000E+04, 1.1351816714E+01, 5.0705020509E+00, 1.7790476632E+00, 1.1800673737E+00, 8.1114563718E-01],
	[2.1900000000E+04, 1.1355740019E+01, 5.0703959358E+00, 1.7803394366E+00, 1.1806722674E+00, 8.1122678251E-01],
	[2.1905000000E+04, 1.1359663784E+01, 5.0702898472E+00, 1.7816318522E+00, 1.1812772155E+00, 8.1130789718E-01],
	[2.1910000000E+04, 1.1363588009E+01, 5.0701837851E+00, 1.7829249102E+00, 1.1818822178E+00, 8.1138898121E-01],
	[2.1915000000E+04, 1.1367512693E+01, 5.0700777493E+00, 1.7842186106E+00, 1.1824872741E+00, 8.1147003460E-01],
	[2.1920000000E+04, 1.1371437838E+01, 5.0699717399E+00, 1.7855129537E+00, 1.1830923844E+00, 8.1155105735E-01],
	[2.1925000000E+04, 1.1375363441E+01, 5.0698657570E+00, 1.7868079397E+00, 1.1836975484E+00, 8.1163204946E-01],
	[2.1930000000E+04, 1.1379289505E+01, 5.0697598004E+00, 1.7881035687E+00, 1.1843027661E+00, 8.1171301095E-01],
	[2.1935000000E+04, 1.1383216028E+01, 5.0696538702E+00, 1.7893998408E+00, 1.1849080374E+00, 8.1179394180E-01],
	[2.1940000000E+04, 1.1387143010E+01, 5.0695479664E+00, 1.7906967564E+00, 1.1855133621E+00, 8.1187484204E-01],
	[2.1945000000E+04, 1.1391070452E+01, 5.0694420889E+00, 1.7919943154E+00, 1.1861187401E+00, 8.1195571166E-01],
	[2.1950000000E+04, 1.1394998353E+01, 5.0693362377E+00, 1.7932925182E+00, 1.1867241713E+00, 8.1203655067E-01],
	[2.1955000000E+04, 1.1398926713E+01, 5.0692304128E+00, 1.7945913649E+00, 1.1873296556E+00, 8.1211735907E-01],
	[2.1960000000E+04, 1.1402855533E+01, 5.0691246143E+00, 1.7958908556E+00, 1.1879351927E+00, 8.1219813687E-01],
	[2.1965000000E+04, 1.1406784812E+01, 5.0690188420E+00, 1.7971909905E+00, 1.1885407827E+00, 8.1227888407E-01],
	[2.1970000000E+04, 1.1410714550E+01, 5.0689130960E+00, 1.7984917698E+00, 1.1891464253E+00, 8.1235960067E-01],
	[2.1975000000E+04, 1.1414644748E+01, 5.0688073763E+00, 1.7997931937E+00, 1.1897521206E+00, 8.1244028668E-01],
	[2.1980000000E+04, 1.1418575404E+01, 5.0687016829E+00, 1.8010952624E+00, 1.1903578682E+00, 8.1252094210E-01],
	[2.1985000000E+04, 1.1422506520E+01, 5.0685960157E+00, 1.8023979759E+00, 1.1909636681E+00, 8.1260156694E-01],
	[2.1990000000E+04, 1.1426438094E+01, 5.0684903747E+00, 1.8037013345E+00, 1.1915695202E+00, 8.1268216120E-01],
	[2.1995000000E+04, 1.1430370127E+01, 5.0683847600E+00, 1.8050053384E+00, 1.1921754244E+00, 8.1276272489E-01],
	[2.2000000000E+04, 1.1434302619E+01, 5.0682791714E+00, 1.8063099877E+00, 1.1927813805E+00, 8.1284325801E-01],
	[2.2005000000E+04, 1.1438235571E+01, 5.0681736090E+00, 1.8076152827E+00, 1.1933873884E+00, 8.1292376056E-01],
	[2.2010000000E+04, 1.1442168980E+01, 5.0680680729E+00, 1.8089212234E+00, 1.1939934480E+00, 8.1300423255E-01],
	[2.2015000000E+04, 1.1446102849E+01, 5.0679625629E+00, 1.8102278100E+00, 1.1945995591E+00, 8.1308467399E-01],
	[2.2020000000E+04, 1.1450037176E+01, 5.0678570790E+00, 1.8115350428E+00, 1.1952057217E+00, 8.1316508487E-01],
	[2.2025000000E+04, 1.1453971962E+01, 5.0677516213E+00, 1.8128429218E+00, 1.1958119356E+00, 8.1324546521E-01],
	[2.2030000000E+04, 1.1457907206E+01, 5.0676461897E+00, 1.8141514473E+00, 1.1964182007E+00, 8.1332581500E-01],
	[2.2035000000E+04, 1.1461842909E+01, 5.0675407843E+00, 1.8154606195E+00, 1.1970245168E+00, 8.1340613426E-01],
	[2.2040000000E+04, 1.1465779070E+01, 5.0674354049E+00, 1.8167704384E+00, 1.1976308838E+00, 8.1348642298E-01],
	[2.2045000000E+04, 1.1469715690E+01, 5.0673300517E+00, 1.8180809044E+00, 1.1982373017E+00, 8.1356668117E-01],
	[2.2050000000E+04, 1.1473652768E+01, 5.0672247245E+00, 1.8193920175E+00, 1.1988437702E+00, 8.1364690884E-01],
	[2.2055000000E+04, 1.1477590305E+01, 5.0671194234E+00, 1.8207037779E+00, 1.1994502893E+00, 8.1372710599E-01],
	[2.2060000000E+04, 1.1481528300E+01, 5.0670141483E+00, 1.8220161858E+00, 1.2000568589E+00, 8.1380727262E-01],
	[2.2065000000E+04, 1.1485466752E+01, 5.0669088993E+00, 1.8233292413E+00, 1.2006634787E+00, 8.1388740874E-01],
	[2.2070000000E+04, 1.1489405664E+01, 5.0668036764E+00, 1.8246429448E+00, 1.2012701487E+00, 8.1396751435E-01],
	[2.2075000000E+04, 1.1493345033E+01, 5.0666984794E+00, 1.8259572962E+00, 1.2018768688E+00, 8.1404758947E-01],
	[2.2080000000E+04, 1.1497284860E+01, 5.0665933085E+00, 1.8272722958E+00, 1.2024836389E+00, 8.1412763408E-01],
	[2.2085000000E+04, 1.1501241125E+01, 5.0664923345E+00, 1.8285879438E+00, 1.2030908687E+00, 8.1420764820E-01],
	[2.2090000000E+04, 1.1505198264E+01, 5.0663914921E+00, 1.8299042403E+00, 1.2036981594E+00, 8.1428763184E-01],
	[2.2095000000E+04, 1.1509155869E+01, 5.0662906744E+00, 1.8312211855E+00, 1.2043055003E+00, 8.1436758499E-01],
	[2.2100000000E+04, 1.1513113939E+01, 5.0661898816E+00, 1.8325387796E+00, 1.2049128913E+00, 8.1444750766E-01],
	[2.2105000000E+04, 1.1517072475E+01, 5.0660891137E+00, 1.8338570227E+00, 1.2055203322E+00, 8.1452739986E-01],
	[2.2110000000E+04, 1.1521031475E+01, 5.0659883705E+00, 1.8351759151E+00, 1.2061278230E+00, 8.1460726158E-01],
	[2.2115000000E+04, 1.1524990941E+01, 5.0658876520E+00, 1.8364954568E+00, 1.2067353635E+00, 8.1468709285E-01],
	[2.2120000000E+04, 1.1528950872E+01, 5.0657869584E+00, 1.8378156481E+00, 1.2073429535E+00, 8.1476689365E-01],
	[2.2125000000E+04, 1.1532911269E+01, 5.0656862895E+00, 1.8391364892E+00, 1.2079505930E+00, 8.1484666400E-01],
	[2.2130000000E+04, 1.1536872130E+01, 5.0655856454E+00, 1.8404579801E+00, 1.2085582819E+00, 8.1492640390E-01],
	[2.2135000000E+04, 1.1540833457E+01, 5.0654850260E+00, 1.8417801212E+00, 1.2091660199E+00, 8.1500611335E-01],
	[2.2140000000E+04, 1.1544795248E+01, 5.0653844313E+00, 1.8431029125E+00, 1.2097738071E+00, 8.1508579236E-01],
	[2.2145000000E+04, 1.1548757504E+01, 5.0652838613E+00, 1.8444263542E+00, 1.2103816432E+00, 8.1516544094E-01],
	[2.2150000000E+04, 1.1552720226E+01, 5.0651833160E+00, 1.8457504465E+00, 1.2109895281E+00, 8.1524505908E-01],
	[2.2155000000E+04, 1.1556683412E+01, 5.0650827955E+00, 1.8470751896E+00, 1.2115974618E+00, 8.1532464680E-01],
	[2.2160000000E+04, 1.1560647063E+01, 5.0649822996E+00, 1.8484005836E+00, 1.2122054440E+00, 8.1540420410E-01],
	[2.2165000000E+04, 1.1564611179E+01, 5.0648818283E+00, 1.8497266288E+00, 1.2128134748E+00, 8.1548373098E-01],
	[2.2170000000E+04, 1.1568575759E+01, 5.0647813818E+00, 1.8510533252E+00, 1.2134215538E+00, 8.1556322745E-01],
	[2.2175000000E+04, 1.1572540804E+01, 5.0646809598E+00, 1.8523806731E+00, 1.2140296811E+00, 8.1564269351E-01],
	[2.2180000000E+04, 1.1576506314E+01, 5.0645805625E+00, 1.8537086726E+00, 1.2146378565E+00, 8.1572212917E-01],
	[2.2185000000E+04, 1.1580472288E+01, 5.0644801898E+00, 1.8550373240E+00, 1.2152460799E+00, 8.1580153443E-01],
	[2.2190000000E+04, 1.1584438727E+01, 5.0643798417E+00, 1.8563666273E+00, 1.2158543511E+00, 8.1588090930E-01],
	[2.2195000000E+04, 1.1588405630E+01, 5.0642795183E+00, 1.8576965828E+00, 1.2164626700E+00, 8.1596025378E-01],
	[2.2200000000E+04, 1.1592372997E+01, 5.0641792194E+00, 1.8590271905E+00, 1.2170710366E+00, 8.1603956788E-01],
	[2.2205000000E+04, 1.1596340829E+01, 5.0640789450E+00, 1.8603584508E+00, 1.2176794506E+00, 8.1611885160E-01],
	[2.2210000000E+04, 1.1600309125E+01, 5.0639786953E+00, 1.8616903638E+00, 1.2182879119E+00, 8.1619810495E-01],
	[2.2215000000E+04, 1.1604277886E+01, 5.0638784701E+00, 1.8630229296E+00, 1.2188964205E+00, 8.1627732794E-01],
	[2.2220000000E+04, 1.1608247110E+01, 5.0637782694E+00, 1.8643561484E+00, 1.2195049762E+00, 8.1635652056E-01],
	[2.2225000000E+04, 1.1612216799E+01, 5.0636780932E+00, 1.8656900204E+00, 1.2201135789E+00, 8.1643568282E-01],
	[2.2230000000E+04, 1.1616186952E+01, 5.0635779416E+00, 1.8670245457E+00, 1.2207222285E+00, 8.1651481473E-01],
	[2.2235000000E+04, 1.1620157569E+01, 5.0634778145E+00, 1.8683597246E+00, 1.2213309248E+00, 8.1659391630E-01],
	[2.2240000000E+04, 1.1624128650E+01, 5.0633777118E+00, 1.8696955572E+00, 1.2219396677E+00, 8.1667298752E-01],
	[2.2245000000E+04, 1.1628100195E+01, 5.0632776337E+00, 1.8710320437E+00, 1.2225484571E+00, 8.1675202840E-01],
	[2.2250000000E+04, 1.1632072203E+01, 5.0631775800E+00, 1.8723691842E+00, 1.2231572928E+00, 8.1683103895E-01],
	[2.2255000000E+04, 1.1636044676E+01, 5.0630775508E+00, 1.8737069789E+00, 1.2237661748E+00, 8.1691001918E-01],
	[2.2260000000E+04, 1.1640017612E+01, 5.0629775460E+00, 1.8750454281E+00, 1.2243751029E+00, 8.1698896908E-01],
	[2.2265000000E+04, 1.1643991012E+01, 5.0628775656E+00, 1.8763845318E+00, 1.2249840771E+00, 8.1706788867E-01],
	[2.2270000000E+04, 1.1647964876E+01, 5.0627776097E+00, 1.8777242902E+00, 1.2255930971E+00, 8.1714677794E-01],
	[2.2275000000E+04, 1.1651939204E+01, 5.0626776782E+00, 1.8790647036E+00, 1.2262021628E+00, 8.1722563691E-01],
	[2.2280000000E+04, 1.1655913995E+01, 5.0625777711E+00, 1.8804057720E+00, 1.2268112742E+00, 8.1730446558E-01],
	[2.2285000000E+04, 1.1659889249E+01, 5.0624778884E+00, 1.8817474957E+00, 1.2274204310E+00, 8.1738326395E-01],
	[2.2290000000E+04, 1.1663864967E+01, 5.0623780300E+00, 1.8830898748E+00, 1.2280296333E+00, 8.1746203203E-01],
	[2.2295000000E+04, 1.1667841149E+01, 5.0622781960E+00, 1.8844329095E+00, 1.2286388808E+00, 8.1754076982E-01],
	[2.2300000000E+04, 1.1671817794E+01, 5.0621783864E+00, 1.8857766000E+00, 1.2292481734E+00, 8.1761947734E-01],
	[2.2305000000E+04, 1.1675794902E+01, 5.0620786011E+00, 1.8871209464E+00, 1.2298575110E+00, 8.1769815457E-01],
	[2.2310000000E+04, 1.1679772473E+01, 5.0619788402E+00, 1.8884659490E+00, 1.2304668936E+00, 8.1777680154E-01],
	[2.2315000000E+04, 1.1683750508E+01, 5.0618791036E+00, 1.8898116079E+00, 1.2310763209E+00, 8.1785541825E-01],
	[2.2320000000E+04, 1.1687729006E+01, 5.0617793912E+00, 1.8911579232E+00, 1.2316857928E+00, 8.1793400469E-01],
	[2.2325000000E+04, 1.1691707967E+01, 5.0616797032E+00, 1.8925048951E+00, 1.2322953092E+00, 8.1801256088E-01],
	[2.2330000000E+04, 1.1695687392E+01, 5.0615800395E+00, 1.8938525239E+00, 1.2329048701E+00, 8.1809108682E-01],
	[2.2335000000E+04, 1.1699667279E+01, 5.0614804000E+00, 1.8952008096E+00, 1.2335144752E+00, 8.1816958252E-01],
	[2.2340000000E+04, 1.1703647629E+01, 5.0613807848E+00, 1.8965497526E+00, 1.2341241245E+00, 8.1824804797E-01],
	[2.2345000000E+04, 1.1707628442E+01, 5.0612811939E+00, 1.8978993528E+00, 1.2347338177E+00, 8.1832648320E-01],
	[2.2350000000E+04, 1.1711609718E+01, 5.0611816272E+00, 1.8992496105E+00, 1.2353435549E+00, 8.1840488818E-01],
	[2.2355000000E+04, 1.1715591457E+01, 5.0610820847E+00, 1.9006005259E+00, 1.2359533359E+00, 8.1848326295E-01],
	[2.2360000000E+04, 1.1719573659E+01, 5.0609825665E+00, 1.9019520992E+00, 1.2365631605E+00, 8.1856160749E-01],
	[2.2365000000E+04, 1.1723556324E+01, 5.0608830724E+00, 1.9033126500E+00, 1.2371765438E+00, 8.1863992181E-01],
	[2.2370000000E+04, 1.1727539451E+01, 5.0607836026E+00, 1.9046752242E+00, 1.2377905440E+00, 8.1871820591E-01],
	[2.2375000000E+04, 1.1731523041E+01, 5.0606841569E+00, 1.9060384684E+00, 1.2384045888E+00, 8.1879645981E-01],
	[2.2380000000E+04, 1.1735507093E+01, 5.0605847354E+00, 1.9074023827E+00, 1.2390186781E+00, 8.1887468350E-01],
	[2.2385000000E+04, 1.1739491608E+01, 5.0604853381E+00, 1.9087669674E+00, 1.2396328118E+00, 8.1895287699E-01],
	[2.2390000000E+04, 1.1743476585E+01, 5.0603859649E+00, 1.9101322225E+00, 1.2402469896E+00, 8.1903104028E-01],
	[2.2395000000E+04, 1.1747462025E+01, 5.0602866159E+00, 1.9114981484E+00, 1.2408612116E+00, 8.1910917337E-01],
	[2.2400000000E+04, 1.1751447928E+01, 5.0601872910E+00, 1.9128647451E+00, 1.2414754776E+00, 8.1918727628E-01],
	[2.2405000000E+04, 1.1755434292E+01, 5.0600879902E+00, 1.9142320129E+00, 1.2420897874E+00, 8.1926534901E-01],
	[2.2410000000E+04, 1.1759421119E+01, 5.0599887135E+00, 1.9155999519E+00, 1.2427041410E+00, 8.1934339155E-01],
	[2.2415000000E+04, 1.1763408409E+01, 5.0598894609E+00, 1.9169685622E+00, 1.2433185382E+00, 8.1942140392E-01],
	[2.2420000000E+04, 1.1767396160E+01, 5.0597902324E+00, 1.9183378442E+00, 1.2439329788E+00, 8.1949938612E-01],
	[2.2425000000E+04, 1.1771384374E+01, 5.0596910280E+00, 1.9197077980E+00, 1.2445474628E+00, 8.1957733815E-01],
	[2.2430000000E+04, 1.1775373049E+01, 5.0595918476E+00, 1.9210784236E+00, 1.2451619901E+00, 8.1965526002E-01],
	[2.2435000000E+04, 1.1779362187E+01, 5.0594926913E+00, 1.9224497215E+00, 1.2457765604E+00, 8.1973315173E-01],
	[2.2440000000E+04, 1.1783366592E+01, 5.0593972798E+00, 1.9238216916E+00, 1.2463915652E+00, 8.1981101328E-01],
	[2.2445000000E+04, 1.1787373427E+01, 5.0593023840E+00, 1.9251943341E+00, 1.2470066653E+00, 8.1988884469E-01],
	[2.2450000000E+04, 1.1791380731E+01, 5.0592075111E+00, 1.9265676494E+00, 1.2476218088E+00, 8.1996664596E-01],
	[2.2455000000E+04, 1.1795388504E+01, 5.0591126611E+00, 1.9279416375E+00, 1.2482369956E+00, 8.2004441708E-01],
	[2.2460000000E+04, 1.1799396747E+01, 5.0590178340E+00, 1.9293162986E+00, 1.2488522255E+00, 8.2012215807E-01],
	[2.2465000000E+04, 1.1803405460E+01, 5.0589230298E+00, 1.9306916329E+00, 1.2494674984E+00, 8.2019986893E-01],
	[2.2470000000E+04, 1.1807414642E+01, 5.0588282484E+00, 1.9320676405E+00, 1.2500828142E+00, 8.2027754966E-01],
	[2.2475000000E+04, 1.1811424293E+01, 5.0587334900E+00, 1.9334443218E+00, 1.2506981728E+00, 8.2035520027E-01],
	[2.2480000000E+04, 1.1815434413E+01, 5.0586387543E+00, 1.9348216767E+00, 1.2513135740E+00, 8.2043282077E-01],
	[2.2485000000E+04, 1.1819445003E+01, 5.0585440416E+00, 1.9361997056E+00, 1.2519290177E+00, 8.2051041115E-01],
	[2.2490000000E+04, 1.1823456061E+01, 5.0584493516E+00, 1.9375784086E+00, 1.2525445038E+00, 8.2058797142E-01],
	[2.2495000000E+04, 1.1827467589E+01, 5.0583546845E+00, 1.9389577858E+00, 1.2531600322E+00, 8.2066550160E-01],
	[2.2500000000E+04, 1.1831479586E+01, 5.0582600402E+00, 1.9403378375E+00, 1.2537756027E+00, 8.2074300167E-01],
	[2.2505000000E+04, 1.1835492052E+01, 5.0581654186E+00, 1.9417185639E+00, 1.2543912152E+00, 8.2082047165E-01],
	[2.2510000000E+04, 1.1839504986E+01, 5.0580708199E+00, 1.9430999650E+00, 1.2550068697E+00, 8.2089791154E-01],
	[2.2515000000E+04, 1.1843518390E+01, 5.0579762440E+00, 1.9444820411E+00, 1.2556225659E+00, 8.2097532134E-01],
	[2.2520000000E+04, 1.1847532263E+01, 5.0578816908E+00, 1.9458647924E+00, 1.2562383037E+00, 8.2105270107E-01],
	[2.2525000000E+04, 1.1851546604E+01, 5.0577871603E+00, 1.9472482191E+00, 1.2568540831E+00, 8.2113005072E-01],
	[2.2530000000E+04, 1.1855561414E+01, 5.0576926527E+00, 1.9486323213E+00, 1.2574699038E+00, 8.2120737030E-01],
	[2.2535000000E+04, 1.1859576693E+01, 5.0575981677E+00, 1.9500170992E+00, 1.2580857659E+00, 8.2128465981E-01],
	[2.2540000000E+04, 1.1863592440E+01, 5.0575037055E+00, 1.9514025529E+00, 1.2587016690E+00, 8.2136191927E-01],
	[2.2545000000E+04, 1.1867608656E+01, 5.0574092660E+00, 1.9527886828E+00, 1.2593176132E+00, 8.2143914866E-01],
	[2.2550000000E+04, 1.1871625341E+01, 5.0573148492E+00, 1.9541754889E+00, 1.2599335983E+00, 8.2151634801E-01],
	[2.2555000000E+04, 1.1875642494E+01, 5.0572204551E+00, 1.9555629714E+00, 1.2605496242E+00, 8.2159351731E-01],
	[2.2560000000E+04, 1.1879660116E+01, 5.0571260837E+00, 1.9569511305E+00, 1.2611656907E+00, 8.2167065657E-01],
	[2.2565000000E+04, 1.1883678206E+01, 5.0570317350E+00, 1.9583399664E+00, 1.2617817978E+00, 8.2174776579E-01],
	[2.2570000000E+04, 1.1887696764E+01, 5.0569374089E+00, 1.9597294792E+00, 1.2623979452E+00, 8.2182484498E-01],
	[2.2575000000E+04, 1.1891715791E+01, 5.0568431055E+00, 1.9611196692E+00, 1.2630141329E+00, 8.2190189415E-01],
	[2.2580000000E+04, 1.1895735285E+01, 5.0567488247E+00, 1.9625105366E+00, 1.2636303608E+00, 8.2197891329E-01],
	[2.2585000000E+04, 1.1899755249E+01, 5.0566545665E+00, 1.9639020814E+00, 1.2642466287E+00, 8.2205590241E-01],
	[2.2590000000E+04, 1.1903775680E+01, 5.0565603310E+00, 1.9652943039E+00, 1.2648629365E+00, 8.2213286153E-01],
	[2.2595000000E+04, 1.1907796579E+01, 5.0564661181E+00, 1.9666872043E+00, 1.2654792841E+00, 8.2220979063E-01],
	[2.2600000000E+04, 1.1911817947E+01, 5.0563719278E+00, 1.9680807827E+00, 1.2660956713E+00, 8.2228668973E-01],
	[2.2605000000E+04, 1.1915839782E+01, 5.0562777600E+00, 1.9694750393E+00, 1.2667120981E+00, 8.2236355884E-01],
	[2.2610000000E+04, 1.1919862086E+01, 5.0561836149E+00, 1.9708699743E+00, 1.2673285642E+00, 8.2244039795E-01],
	[2.2615000000E+04, 1.1923884857E+01, 5.0560894923E+00, 1.9722655879E+00, 1.2679450697E+00, 8.2251720708E-01],
	[2.2620000000E+04, 1.1927908096E+01, 5.0559953923E+00, 1.9736618803E+00, 1.2685616143E+00, 8.2259398622E-01],
	[2.2625000000E+04, 1.1931931803E+01, 5.0559013148E+00, 1.9750588516E+00, 1.2691781979E+00, 8.2267073538E-01],
	[2.2630000000E+04, 1.1935955978E+01, 5.0558072599E+00, 1.9764565020E+00, 1.2697948205E+00, 8.2274745458E-01],
	[2.2635000000E+04, 1.1939980621E+01, 5.0557132275E+00, 1.9778548317E+00, 1.2704114818E+00, 8.2282414380E-01],
	[2.2640000000E+04, 1.1944005731E+01, 5.0556192176E+00, 1.9792538409E+00, 1.2710281818E+00, 8.2290080306E-01],
	[2.2645000000E+04, 1.1948031309E+01, 5.0555252302E+00, 1.9806535298E+00, 1.2716449204E+00, 8.2297743237E-01],
	[2.2650000000E+04, 1.1952057354E+01, 5.0554312653E+00, 1.9820538985E+00, 1.2722616973E+00, 8.2305403172E-01],
	[2.2655000000E+04, 1.1956083867E+01, 5.0553373229E+00, 1.9834549471E+00, 1.2728785126E+00, 8.2313060113E-01],
	[2.2660000000E+04, 1.1960110848E+01, 5.0552434030E+00, 1.9848566760E+00, 1.2734953660E+00, 8.2320714059E-01],
	[2.2665000000E+04, 1.1964138295E+01, 5.0551495056E+00, 1.9862590853E+00, 1.2741122575E+00, 8.2328365012E-01],
	[2.2670000000E+04, 1.1968166211E+01, 5.0550556306E+00, 1.9876621751E+00, 1.2747291869E+00, 8.2336012971E-01],
	[2.2675000000E+04, 1.1972194593E+01, 5.0549617780E+00, 1.9890659457E+00, 1.2753461540E+00, 8.2343657938E-01],
	[2.2680000000E+04, 1.1976223443E+01, 5.0548679479E+00, 1.9904703971E+00, 1.2759631589E+00, 8.2351299913E-01],
	[2.2685000000E+04, 1.1980252760E+01, 5.0547741402E+00, 1.9918755297E+00, 1.2765802013E+00, 8.2358938896E-01],
	[2.2690000000E+04, 1.1984282544E+01, 5.0546803549E+00, 1.9932813435E+00, 1.2771972811E+00, 8.2366574888E-01],
	[2.2695000000E+04, 1.1988312796E+01, 5.0545865920E+00, 1.9946878388E+00, 1.2778143982E+00, 8.2374207889E-01],
	[2.2700000000E+04, 1.1992343514E+01, 5.0544928516E+00, 1.9960950157E+00, 1.2784315525E+00, 8.2381837900E-01],
	[2.2705000000E+04, 1.1996374700E+01, 5.0543991335E+00, 1.9975028744E+00, 1.2790487439E+00, 8.2389464922E-01],
	[2.2710000000E+04, 1.2000406352E+01, 5.0543054377E+00, 1.9989114151E+00, 1.2796659722E+00, 8.2397088954E-01],
	[2.2715000000E+04, 1.2004438472E+01, 5.0542117644E+00, 2.0003206380E+00, 1.2802832373E+00, 8.2404709998E-01],
	[2.2720000000E+04, 1.2008471058E+01, 5.0541181134E+00, 2.0017305432E+00, 1.2809005391E+00, 8.2412328055E-01],
	[2.2725000000E+04, 1.2012504111E+01, 5.0540244847E+00, 2.0031411310E+00, 1.2815178774E+00, 8.2419943123E-01],
	[2.2730000000E+04, 1.2016537631E+01, 5.0539308783E+00, 2.0045524014E+00, 1.2821352522E+00, 8.2427555205E-01],
	[2.2735000000E+04, 1.2020571618E+01, 5.0538372943E+00, 2.0059643548E+00, 1.2827526633E+00, 8.2435164300E-01],
	[2.2740000000E+04, 1.2024606071E+01, 5.0537437326E+00, 2.0073769912E+00, 1.2833701106E+00, 8.2442770410E-01],
	[2.2745000000E+04, 1.2028640991E+01, 5.0536501932E+00, 2.0087903109E+00, 1.2839875939E+00, 8.2450373534E-01],
	[2.2750000000E+04, 1.2032676378E+01, 5.0535566761E+00, 2.0102043139E+00, 1.2846051132E+00, 8.2457973673E-01],
	[2.2755000000E+04, 1.2036712231E+01, 5.0534631813E+00, 2.0116190006E+00, 1.2852226683E+00, 8.2465570828E-01],
	[2.2760000000E+04, 1.2040748551E+01, 5.0533697087E+00, 2.0130343711E+00, 1.2858402591E+00, 8.2473165000E-01],
	[2.2765000000E+04, 1.2044785337E+01, 5.0532762584E+00, 2.0144504256E+00, 1.2864578855E+00, 8.2480756188E-01],
	[2.2770000000E+04, 1.2048822590E+01, 5.0531828304E+00, 2.0158671642E+00, 1.2870755474E+00, 8.2488344393E-01],
	[2.2775000000E+04, 1.2052860309E+01, 5.0530894246E+00, 2.0172845871E+00, 1.2876932445E+00, 8.2495929617E-01],
	[2.2780000000E+04, 1.2056898494E+01, 5.0529960410E+00, 2.0187026945E+00, 1.2883109769E+00, 8.2503511859E-01],
	[2.2785000000E+04, 1.2060937145E+01, 5.0529026796E+00, 2.0201214867E+00, 1.2889287443E+00, 8.2511091120E-01],
	[2.2790000000E+04, 1.2064976263E+01, 5.0528093405E+00, 2.0215409636E+00, 1.2895465467E+00, 8.2518667400E-01],
	[2.2795000000E+04, 1.2069015847E+01, 5.0527160235E+00, 2.0229611257E+00, 1.2901643840E+00, 8.2526240700E-01],
	[2.2800000000E+04, 1.2073066986E+01, 5.0526254125E+00, 2.0243819729E+00, 1.2907825578E+00, 8.2533811021E-01],
	[2.2805000000E+04, 1.2077124657E+01, 5.0525362896E+00, 2.0258035056E+00, 1.2914009319E+00, 8.2541378364E-01],
	[2.2810000000E+04, 1.2081182803E+01, 5.0524471879E+00, 2.0272257238E+00, 1.2920193410E+00, 8.2548942728E-01],
	[2.2815000000E+04, 1.2085241422E+01, 5.0523581072E+00, 2.0286486278E+00, 1.2926377852E+00, 8.2556504114E-01],
	[2.2820000000E+04, 1.2089300515E+01, 5.0522690476E+00, 2.0300722178E+00, 1.2932562642E+00, 8.2564062523E-01],
	[2.2825000000E+04, 1.2093360081E+01, 5.0521800091E+00, 2.0314964938E+00, 1.2938747780E+00, 8.2571617955E-01],
	[2.2830000000E+04, 1.2097420121E+01, 5.0520909917E+00, 2.0329214562E+00, 1.2944933265E+00, 8.2579170412E-01],
	[2.2835000000E+04, 1.2101480634E+01, 5.0520019953E+00, 2.0343471050E+00, 1.2951119095E+00, 8.2586719892E-01],
	[2.2840000000E+04, 1.2105541621E+01, 5.0519130200E+00, 2.0357734406E+00, 1.2957305269E+00, 8.2594266398E-01],
	[2.2845000000E+04, 1.2109603081E+01, 5.0518240657E+00, 2.0372004629E+00, 1.2963491785E+00, 8.2601809930E-01],
	[2.2850000000E+04, 1.2113665015E+01, 5.0517351324E+00, 2.0386281723E+00, 1.2969678644E+00, 8.2609350487E-01],
	[2.2855000000E+04, 1.2117727422E+01, 5.0516462202E+00, 2.0400565689E+00, 1.2975865842E+00, 8.2616888072E-01],
	[2.2860000000E+04, 1.2121790303E+01, 5.0515573290E+00, 2.0414856529E+00, 1.2982053380E+00, 8.2624422683E-01],
	[2.2865000000E+04, 1.2125853656E+01, 5.0514684588E+00, 2.0429154244E+00, 1.2988241255E+00, 8.2631954323E-01],
	[2.2870000000E+04, 1.2129917483E+01, 5.0513796096E+00, 2.0443458837E+00, 1.2994429468E+00, 8.2639482991E-01],
	[2.2875000000E+04, 1.2133981783E+01, 5.0512907814E+00, 2.0457770309E+00, 1.3000618015E+00, 8.2647008687E-01],
	[2.2880000000E+04, 1.2138046555E+01, 5.0512019741E+00, 2.0472088661E+00, 1.3006806897E+00, 8.2654531414E-01],
	[2.2885000000E+04, 1.2142111801E+01, 5.0511131878E+00, 2.0486413897E+00, 1.3012996112E+00, 8.2662051170E-01],
	[2.2890000000E+04, 1.2146177520E+01, 5.0510244225E+00, 2.0500746018E+00, 1.3019185659E+00, 8.2669567957E-01],
	[2.2895000000E+04, 1.2150243712E+01, 5.0509356781E+00, 2.0515085024E+00, 1.3025375536E+00, 8.2677081776E-01],
	[2.2900000000E+04, 1.2154310377E+01, 5.0508469547E+00, 2.0529430919E+00, 1.3031565743E+00, 8.2684592626E-01],
	[2.2905000000E+04, 1.2158377514E+01, 5.0507582522E+00, 2.0543783704E+00, 1.3037756278E+00, 8.2692100509E-01],
	[2.2910000000E+04, 1.2162445125E+01, 5.0506695706E+00, 2.0558143381E+00, 1.3043947139E+00, 8.2699605425E-01],
	[2.2915000000E+04, 1.2166513208E+01, 5.0505809099E+00, 2.0572509952E+00, 1.3050138327E+00, 8.2707107374E-01],
	[2.2920000000E+04, 1.2170581764E+01, 5.0504922701E+00, 2.0586883418E+00, 1.3056329838E+00, 8.2714606357E-01],
	[2.2925000000E+04, 1.2174650792E+01, 5.0504036512E+00, 2.0601263781E+00, 1.3062521673E+00, 8.2722102375E-01],
	[2.2930000000E+04, 1.2178720293E+01, 5.0503150532E+00, 2.0615651043E+00, 1.3068713830E+00, 8.2729595429E-01],
	[2.2935000000E+04, 1.2182790267E+01, 5.0502264760E+00, 2.0630045206E+00, 1.3074906308E+00, 8.2737085518E-01],
	[2.2940000000E+04, 1.2186860713E+01, 5.0501379197E+00, 2.0644446271E+00, 1.3081099106E+00, 8.2744572644E-01],
	[2.2945000000E+04, 1.2190931632E+01, 5.0500493843E+00, 2.0658854241E+00, 1.3087292221E+00, 8.2752056806E-01],
	[2.2950000000E+04, 1.2195003022E+01, 5.0499608697E+00, 2.0673269117E+00, 1.3093485654E+00, 8.2759538007E-01],
	[2.2955000000E+04, 1.2199074886E+01, 5.0498723759E+00, 2.0687690901E+00, 1.3099679403E+00, 8.2767016245E-01],
	[2.2960000000E+04, 1.2203147221E+01, 5.0497839030E+00, 2.0702119595E+00, 1.3105873466E+00, 8.2774491523E-01],
	[2.2965000000E+04, 1.2207220029E+01, 5.0496954509E+00, 2.0716555201E+00, 1.3112067843E+00, 8.2781963839E-01],
	[2.2970000000E+04, 1.2211293309E+01, 5.0496070195E+00, 2.0730997719E+00, 1.3118262532E+00, 8.2789433196E-01],
	[2.2975000000E+04, 1.2215367062E+01, 5.0495186090E+00, 2.0745447154E+00, 1.3124457533E+00, 8.2796899593E-01],
	[2.2980000000E+04, 1.2219441286E+01, 5.0494302193E+00, 2.0759903505E+00, 1.3130652843E+00, 8.2804363032E-01],
	[2.2985000000E+04, 1.2223515982E+01, 5.0493418503E+00, 2.0774366775E+00, 1.3136848462E+00, 8.2811823512E-01],
	[2.2990000000E+04, 1.2227591151E+01, 5.0492535021E+00, 2.0788836965E+00, 1.3143044388E+00, 8.2819281034E-01],
	[2.2995000000E+04, 1.2231666791E+01, 5.0491651747E+00, 2.0803314078E+00, 1.3149240620E+00, 8.2826735600E-01],
	[2.3000000000E+04, 1.2235742904E+01, 5.0490768680E+00, 2.0817798115E+00, 1.3155437157E+00, 8.2834187209E-01],
	[2.3005000000E+04, 1.2239819488E+01, 5.0489885821E+00, 2.0832289079E+00, 1.3161633998E+00, 8.2841635862E-01],
	[2.3010000000E+04, 1.2243896544E+01, 5.0489003168E+00, 2.0846786970E+00, 1.3167831142E+00, 8.2849081560E-01],
	[2.3015000000E+04, 1.2247974072E+01, 5.0488120723E+00, 2.0861291790E+00, 1.3174028587E+00, 8.2856524303E-01],
	[2.3020000000E+04, 1.2252052071E+01, 5.0487238486E+00, 2.0875803542E+00, 1.3180226332E+00, 8.2863964092E-01],
	[2.3025000000E+04, 1.2256130543E+01, 5.0486356455E+00, 2.0890322228E+00, 1.3186424376E+00, 8.2871400928E-01],
	[2.3030000000E+04, 1.2260209486E+01, 5.0485474631E+00, 2.0904847848E+00, 1.3192622717E+00, 8.2878834811E-01],
	[2.3035000000E+04, 1.2264288900E+01, 5.0484593014E+00, 2.0919380405E+00, 1.3198821355E+00, 8.2886265741E-01],
	[2.3040000000E+04, 1.2268368786E+01, 5.0483711603E+00, 2.0933919901E+00, 1.3205020288E+00, 8.2893693720E-01],
	[2.3045000000E+04, 1.2272449144E+01, 5.0482830400E+00, 2.0948466337E+00, 1.3211219516E+00, 8.2901118748E-01],
	[2.3050000000E+04, 1.2276529973E+01, 5.0481949402E+00, 2.0963019715E+00, 1.3217419036E+00, 8.2908540825E-01],
	[2.3055000000E+04, 1.2280611273E+01, 5.0481068612E+00, 2.0977580037E+00, 1.3223618848E+00, 8.2915959953E-01],
	[2.3060000000E+04, 1.2284693045E+01, 5.0480188027E+00, 2.0992147306E+00, 1.3229818950E+00, 8.2923376131E-01],
	[2.3065000000E+04, 1.2288775288E+01, 5.0479307649E+00, 2.1006721521E+00, 1.3236019341E+00, 8.2930789361E-01],
	[2.3070000000E+04, 1.2292858002E+01, 5.0478427477E+00, 2.1021302687E+00, 1.3242220021E+00, 8.2938199643E-01],
	[2.3075000000E+04, 1.2296941187E+01, 5.0477547511E+00, 2.1035890803E+00, 1.3248420987E+00, 8.2945606978E-01],
	[2.3080000000E+04, 1.2301024844E+01, 5.0476667752E+00, 2.1050485873E+00, 1.3254622239E+00, 8.2953011365E-01],
	[2.3085000000E+04, 1.2305108972E+01, 5.0475788198E+00, 2.1065087897E+00, 1.3260823775E+00, 8.2960412807E-01],
	[2.3090000000E+04, 1.2309193571E+01, 5.0474908849E+00, 2.1079696878E+00, 1.3267025594E+00, 8.2967811303E-01],
	[2.3095000000E+04, 1.2313278640E+01, 5.0474029707E+00, 2.1094312817E+00, 1.3273227695E+00, 8.2975206854E-01],
	[2.3100000000E+04, 1.2317364181E+01, 5.0473150770E+00, 2.1108935717E+00, 1.3279430077E+00, 8.2982599461E-01],
	[2.3105000000E+04, 1.2321450193E+01, 5.0472272039E+00, 2.1123565578E+00, 1.3285632738E+00, 8.2989989124E-01],
	[2.3110000000E+04, 1.2325536676E+01, 5.0471393513E+00, 2.1138202404E+00, 1.3291835678E+00, 8.2997375844E-01],
	[2.3115000000E+04, 1.2329623629E+01, 5.0470515192E+00, 2.1152846195E+00, 1.3298038895E+00, 8.3004759622E-01],
	[2.3120000000E+04, 1.2333711053E+01, 5.0469637077E+00, 2.1167496954E+00, 1.3304242388E+00, 8.3012140458E-01],
	[2.3125000000E+04, 1.2337798948E+01, 5.0468759167E+00, 2.1182154682E+00, 1.3310446155E+00, 8.3019518353E-01],
	[2.3130000000E+04, 1.2341887314E+01, 5.0467881462E+00, 2.1196819380E+00, 1.3316650196E+00, 8.3026893307E-01],
	[2.3135000000E+04, 1.2345976150E+01, 5.0467003962E+00, 2.1211491052E+00, 1.3322854509E+00, 8.3034265321E-01],
	[2.3140000000E+04, 1.2350065457E+01, 5.0466126667E+00, 2.1226169699E+00, 1.3329059093E+00, 8.3041634396E-01],
	[2.3145000000E+04, 1.2354155234E+01, 5.0465249576E+00, 2.1240855321E+00, 1.3335263947E+00, 8.3049000533E-01],
	[2.3150000000E+04, 1.2358245482E+01, 5.0464372691E+00, 2.1255547923E+00, 1.3341469070E+00, 8.3056363731E-01],
	[2.3155000000E+04, 1.2362336200E+01, 5.0463496009E+00, 2.1270247504E+00, 1.3347674460E+00, 8.3063723992E-01],
	[2.3160000000E+04, 1.2366427389E+01, 5.0462619533E+00, 2.1284954067E+00, 1.3353880117E+00, 8.3071081316E-01],
	[2.3165000000E+04, 1.2370523384E+01, 5.0461753369E+00, 2.1299667614E+00, 1.3360087253E+00, 8.3078435704E-01],
	[2.3170000000E+04, 1.2374633057E+01, 5.0460918184E+00, 2.1314388146E+00, 1.3366298354E+00, 8.3085787157E-01],
	[2.3175000000E+04, 1.2378743209E+01, 5.0460083193E+00, 2.1329115665E+00, 1.3372509725E+00, 8.3093135675E-01],
	[2.3180000000E+04, 1.2382853838E+01, 5.0459248396E+00, 2.1343850174E+00, 1.3378721364E+00, 8.3100481258E-01],
	[2.3185000000E+04, 1.2386964946E+01, 5.0458413792E+00, 2.1358591673E+00, 1.3384933270E+00, 8.3107823908E-01],
	[2.3190000000E+04, 1.2391076532E+01, 5.0457579383E+00, 2.1373340165E+00, 1.3391145442E+00, 8.3115163625E-01],
	[2.3195000000E+04, 1.2395188595E+01, 5.0456745167E+00, 2.1388095652E+00, 1.3397357879E+00, 8.3122500410E-01],
	[2.3200000000E+04, 1.2399301136E+01, 5.0455911144E+00, 2.1402858135E+00, 1.3403570579E+00, 8.3129834263E-01],
	[2.3205000000E+04, 1.2403414155E+01, 5.0455077315E+00, 2.1417627616E+00, 1.3409783542E+00, 8.3137165185E-01],
	[2.3210000000E+04, 1.2407527652E+01, 5.0454243680E+00, 2.1432404097E+00, 1.3415996765E+00, 8.3144493177E-01],
	[2.3215000000E+04, 1.2411641627E+01, 5.0453410238E+00, 2.1447187580E+00, 1.3422210248E+00, 8.3151818239E-01],
	[2.3220000000E+04, 1.2415756079E+01, 5.0452576989E+00, 2.1461978066E+00, 1.3428423990E+00, 8.3159140372E-01],
	[2.3225000000E+04, 1.2419871009E+01, 5.0451743933E+00, 2.1476775557E+00, 1.3434637990E+00, 8.3166459576E-01],
	[2.3230000000E+04, 1.2423986416E+01, 5.0450911071E+00, 2.1491580056E+00, 1.3440852245E+00, 8.3173775853E-01],
	[2.3235000000E+04, 1.2428102301E+01, 5.0450078401E+00, 2.1506391563E+00, 1.3447066756E+00, 8.3181089203E-01],
	[2.3240000000E+04, 1.2432218664E+01, 5.0449245924E+00, 2.1521210081E+00, 1.3453281521E+00, 8.3188399626E-01],
	[2.3245000000E+04, 1.2436335503E+01, 5.0448413641E+00, 2.1536035612E+00, 1.3459496538E+00, 8.3195707123E-01],
	[2.3250000000E+04, 1.2440452821E+01, 5.0447581549E+00, 2.1550868157E+00, 1.3465711806E+00, 8.3203011696E-01],
	[2.3255000000E+04, 1.2444570615E+01, 5.0446749651E+00, 2.1565707718E+00, 1.3471927325E+00, 8.3210313343E-01],
	[2.3260000000E+04, 1.2448688887E+01, 5.0445917945E+00, 2.1580554298E+00, 1.3478143093E+00, 8.3217612067E-01],
	[2.3265000000E+04, 1.2452807636E+01, 5.0445086431E+00, 2.1595407897E+00, 1.3484359109E+00, 8.3224907868E-01],
	[2.3270000000E+04, 1.2456926863E+01, 5.0444255110E+00, 2.1610268517E+00, 1.3490575372E+00, 8.3232200746E-01],
	[2.3275000000E+04, 1.2461046566E+01, 5.0443423982E+00, 2.1625136161E+00, 1.3496791880E+00, 8.3239490702E-01],
	[2.3280000000E+04, 1.2465166747E+01, 5.0442593045E+00, 2.1640010830E+00, 1.3503008632E+00, 8.3246777737E-01],
	[2.3285000000E+04, 1.2469287404E+01, 5.0441762301E+00, 2.1654892526E+00, 1.3509225628E+00, 8.3254061851E-01],
	[2.3290000000E+04, 1.2473408539E+01, 5.0440931748E+00, 2.1669781250E+00, 1.3515442865E+00, 8.3261343046E-01],
	[2.3295000000E+04, 1.2477530150E+01, 5.0440101388E+00, 2.1684677006E+00, 1.3521660343E+00, 8.3268621321E-01],
	[2.3300000000E+04, 1.2481652239E+01, 5.0439271219E+00, 2.1699579793E+00, 1.3527878061E+00, 8.3275896678E-01],
	[2.3305000000E+04, 1.2485774804E+01, 5.0438441242E+00, 2.1714489615E+00, 1.3534096017E+00, 8.3283169116E-01],
	[2.3310000000E+04, 1.2489897846E+01, 5.0437611457E+00, 2.1729406473E+00, 1.3540314210E+00, 8.3290438638E-01],
	[2.3315000000E+04, 1.2494021365E+01, 5.0436781864E+00, 2.1744330369E+00, 1.3546532639E+00, 8.3297705243E-01],
	[2.3320000000E+04, 1.2498145361E+01, 5.0435952462E+00, 2.1759261304E+00, 1.3552751303E+00, 8.3304968932E-01],
	[2.3325000000E+04, 1.2502269833E+01, 5.0435123251E+00, 2.1774199281E+00, 1.3558970200E+00, 8.3312229706E-01],
	[2.3330000000E+04, 1.2506394782E+01, 5.0434294232E+00, 2.1789144301E+00, 1.3565189330E+00, 8.3319487566E-01],
	[2.3335000000E+04, 1.2510520208E+01, 5.0433465404E+00, 2.1804096365E+00, 1.3571408691E+00, 8.3326742517E-01],
	[2.3340000000E+04, 1.2514646110E+01, 5.0432636768E+00, 2.1819055477E+00, 1.3577628282E+00, 8.3333994559E-01],
	[2.3345000000E+04, 1.2518772489E+01, 5.0431808322E+00, 2.1834021638E+00, 1.3583848101E+00, 8.3341243693E-01],
	[2.3350000000E+04, 1.2522899344E+01, 5.0430980068E+00, 2.1848994848E+00, 1.3590068149E+00, 8.3348489918E-01],
	[2.3355000000E+04, 1.2527026675E+01, 5.0430152004E+00, 2.1863975111E+00, 1.3596288422E+00, 8.3355733237E-01],
	[2.3360000000E+04, 1.2531154483E+01, 5.0429324131E+00, 2.1878962428E+00, 1.3602508921E+00, 8.3362973648E-01],
	[2.3365000000E+04, 1.2535282767E+01, 5.0428496449E+00, 2.1893956801E+00, 1.3608729644E+00, 8.3370211153E-01],
	[2.3370000000E+04, 1.2539411527E+01, 5.0427668958E+00, 2.1908958232E+00, 1.3614950590E+00, 8.3377445753E-01],
	[2.3375000000E+04, 1.2543540764E+01, 5.0426841657E+00, 2.1923966722E+00, 1.3621171758E+00, 8.3384677447E-01],
	[2.3380000000E+04, 1.2547670477E+01, 5.0426014547E+00, 2.1938982273E+00, 1.3627393146E+00, 8.3391906236E-01],
	[2.3385000000E+04, 1.2551800665E+01, 5.0425187627E+00, 2.1954004888E+00, 1.3633614753E+00, 8.3399132121E-01],
	[2.3390000000E+04, 1.2555931330E+01, 5.0424360898E+00, 2.1969034567E+00, 1.3639836578E+00, 8.3406355103E-01],
	[2.3395000000E+04, 1.2560062471E+01, 5.0423534359E+00, 2.1984071313E+00, 1.3646058621E+00, 8.3413575181E-01],
	[2.3400000000E+04, 1.2564194088E+01, 5.0422708010E+00, 2.1999115127E+00, 1.3652280879E+00, 8.3420792356E-01],
	[2.3405000000E+04, 1.2568326181E+01, 5.0421881851E+00, 2.2014166012E+00, 1.3658503351E+00, 8.3428006630E-01],
	[2.3410000000E+04, 1.2572458749E+01, 5.0421055882E+00, 2.2029223969E+00, 1.3664726037E+00, 8.3435218001E-01],
	[2.3415000000E+04, 1.2576591794E+01, 5.0420230103E+00, 2.2044289000E+00, 1.3670948936E+00, 8.3442426472E-01],
	[2.3420000000E+04, 1.2580725314E+01, 5.0419404514E+00, 2.2059361106E+00, 1.3677172045E+00, 8.3449632042E-01],
	[2.3425000000E+04, 1.2584859310E+01, 5.0418579115E+00, 2.2074440290E+00, 1.3683395364E+00, 8.3456834712E-01],
	[2.3430000000E+04, 1.2588993782E+01, 5.0417753905E+00, 2.2089526554E+00, 1.3689618892E+00, 8.3464034483E-01],
	[2.3435000000E+04, 1.2593128729E+01, 5.0416928885E+00, 2.2104619898E+00, 1.3695842627E+00, 8.3471231355E-01],
	[2.3440000000E+04, 1.2597264152E+01, 5.0416104054E+00, 2.2119720326E+00, 1.3702066568E+00, 8.3478425328E-01],
	[2.3445000000E+04, 1.2601400051E+01, 5.0415279413E+00, 2.2134827838E+00, 1.3708290714E+00, 8.3485616404E-01],
	[2.3450000000E+04, 1.2605536425E+01, 5.0414454961E+00, 2.2149942437E+00, 1.3714515065E+00, 8.3492804582E-01],
	[2.3455000000E+04, 1.2609673274E+01, 5.0413630698E+00, 2.2165064124E+00, 1.3720739618E+00, 8.3499989863E-01],
	[2.3460000000E+04, 1.2613810599E+01, 5.0412806625E+00, 2.2180192901E+00, 1.3726964372E+00, 8.3507172249E-01],
	[2.3465000000E+04, 1.2617948399E+01, 5.0411982741E+00, 2.2195328771E+00, 1.3733189327E+00, 8.3514351738E-01],
	[2.3470000000E+04, 1.2622086675E+01, 5.0411159045E+00, 2.2210471734E+00, 1.3739414481E+00, 8.3521528333E-01],
	[2.3475000000E+04, 1.2626225426E+01, 5.0410335539E+00, 2.2225621793E+00, 1.3745639834E+00, 8.3528702033E-01],
	[2.3480000000E+04, 1.2630364652E+01, 5.0409512221E+00, 2.2240778949E+00, 1.3751865383E+00, 8.3535872839E-01],
	[2.3485000000E+04, 1.2634504353E+01, 5.0408689092E+00, 2.2255943204E+00, 1.3758091127E+00, 8.3543040751E-01],
	[2.3490000000E+04, 1.2638644529E+01, 5.0407866152E+00, 2.2271114561E+00, 1.3764317066E+00, 8.3550205771E-01],
	[2.3495000000E+04, 1.2642785181E+01, 5.0407043400E+00, 2.2286293020E+00, 1.3770543199E+00, 8.3557367898E-01],
	[2.3500000000E+04, 1.2646926307E+01, 5.0406220837E+00, 2.2301478584E+00, 1.3776769523E+00, 8.3564527133E-01],
	[2.3505000000E+04, 1.2651067909E+01, 5.0405398462E+00, 2.2316671254E+00, 1.3782996038E+00, 8.3571683477E-01],
	[2.3510000000E+04, 1.2655209985E+01, 5.0404576276E+00, 2.2331871033E+00, 1.3789222743E+00, 8.3578836931E-01],
	[2.3515000000E+04, 1.2659352536E+01, 5.0403754278E+00, 2.2347077921E+00, 1.3795449637E+00, 8.3585987494E-01],
	[2.3520000000E+04, 1.2663495562E+01, 5.0402932468E+00, 2.2362291922E+00, 1.3801676718E+00, 8.3593135168E-01],
	[2.3525000000E+04, 1.2667639063E+01, 5.0402110846E+00, 2.2377513036E+00, 1.3807903985E+00, 8.3600279952E-01],
	[2.3530000000E+04, 1.2671783039E+01, 5.0401289412E+00, 2.2392741266E+00, 1.3814131438E+00, 8.3607421849E-01],
	[2.3535000000E+04, 1.2675927490E+01, 5.0400468166E+00, 2.2407976613E+00, 1.3820359074E+00, 8.3614560857E-01],
	[2.3540000000E+04, 1.2680084366E+01, 5.0399673942E+00, 2.2423219079E+00, 1.3826590334E+00, 8.3621696978E-01],
	[2.3545000000E+04, 1.2684247712E+01, 5.0398893343E+00, 2.2438468666E+00, 1.3832823504E+00, 8.3628830213E-01],
	[2.3550000000E+04, 1.2688411541E+01, 5.0398112922E+00, 2.2453725376E+00, 1.3839056862E+00, 8.3635960561E-01],
	[2.3555000000E+04, 1.2692575852E+01, 5.0397332679E+00, 2.2468989210E+00, 1.3845290406E+00, 8.3643088023E-01],
	[2.3560000000E+04, 1.2696740645E+01, 5.0396552613E+00, 2.2484260171E+00, 1.3851524135E+00, 8.3650212601E-01],
	[2.3565000000E+04, 1.2700905921E+01, 5.0395772725E+00, 2.2499538259E+00, 1.3857758048E+00, 8.3657334294E-01],
	[2.3570000000E+04, 1.2705071679E+01, 5.0394993014E+00, 2.2514823478E+00, 1.3863992143E+00, 8.3664453103E-01],
	[2.3575000000E+04, 1.2709237919E+01, 5.0394213481E+00, 2.2530115829E+00, 1.3870226420E+00, 8.3671569029E-01],
	[2.3580000000E+04, 1.2713404642E+01, 5.0393434125E+00, 2.2545415313E+00, 1.3876460877E+00, 8.3678682072E-01],
	[2.3585000000E+04, 1.2717571847E+01, 5.0392654947E+00, 2.2560721932E+00, 1.3882695513E+00, 8.3685792233E-01],
	[2.3590000000E+04, 1.2721739534E+01, 5.0391875945E+00, 2.2576035689E+00, 1.3888930327E+00, 8.3692899512E-01],
	[2.3595000000E+04, 1.2725907703E+01, 5.0391097121E+00, 2.2591356585E+00, 1.3895165317E+00, 8.3700003910E-01],
	[2.3600000000E+04, 1.2730076354E+01, 5.0390318474E+00, 2.2606684621E+00, 1.3901400483E+00, 8.3707105428E-01],
	[2.3605000000E+04, 1.2734245487E+01, 5.0389540004E+00, 2.2622019800E+00, 1.3907635824E+00, 8.3714204066E-01],
	[2.3610000000E+04, 1.2738415102E+01, 5.0388761711E+00, 2.2637362124E+00, 1.3913871338E+00, 8.3721299825E-01],
	[2.3615000000E+04, 1.2742585199E+01, 5.0387983594E+00, 2.2652711594E+00, 1.3920107024E+00, 8.3728392705E-01],
	[2.3620000000E+04, 1.2746755778E+01, 5.0387205654E+00, 2.2668068212E+00, 1.3926342880E+00, 8.3735482707E-01],
	[2.3625000000E+04, 1.2750926838E+01, 5.0386427891E+00, 2.2683431979E+00, 1.3932578907E+00, 8.3742569832E-01],
	[2.3630000000E+04, 1.2755098381E+01, 5.0385650305E+00, 2.2698802899E+00, 1.3938815102E+00, 8.3749654079E-01],
	[2.3635000000E+04, 1.2759270405E+01, 5.0384872895E+00, 2.2714180972E+00, 1.3945051464E+00, 8.3756735451E-01],
	[2.3640000000E+04, 1.2763442911E+01, 5.0384095662E+00, 2.2729566200E+00, 1.3951287992E+00, 8.3763813946E-01],
	[2.3645000000E+04, 1.2767615898E+01, 5.0383318605E+00, 2.2744958585E+00, 1.3957524686E+00, 8.3770889567E-01],
	[2.3650000000E+04, 1.2771789367E+01, 5.0382541724E+00, 2.2760358129E+00, 1.3963761543E+00, 8.3777962313E-01],
	[2.3655000000E+04, 1.2775963318E+01, 5.0381765019E+00, 2.2775764834E+00, 1.3969998564E+00, 8.3785032184E-01],
	[2.3660000000E+04, 1.2780137750E+01, 5.0380988491E+00, 2.2791178702E+00, 1.3976235746E+00, 8.3792099183E-01],
	[2.3665000000E+04, 1.2784312663E+01, 5.0380212138E+00, 2.2806599733E+00, 1.3982473088E+00, 8.3799163309E-01],
	[2.3670000000E+04, 1.2788488058E+01, 5.0379435962E+00, 2.2822027931E+00, 1.3988710589E+00, 8.3806224562E-01],
	[2.3675000000E+04, 1.2792663935E+01, 5.0378659961E+00, 2.2837463297E+00, 1.3994948249E+00, 8.3813282944E-01],
	[2.3680000000E+04, 1.2796840292E+01, 5.0377884136E+00, 2.2852905833E+00, 1.4001186065E+00, 8.3820338455E-01],
	[2.3685000000E+04, 1.2801017131E+01, 5.0377108487E+00, 2.2868355540E+00, 1.4007424037E+00, 8.3827391096E-01],
	[2.3690000000E+04, 1.2805194451E+01, 5.0376333014E+00, 2.2883812421E+00, 1.4013662164E+00, 8.3834440867E-01],
	[2.3695000000E+04, 1.2809372252E+01, 5.0375557716E+00, 2.2899276477E+00, 1.4019900444E+00, 8.3841487769E-01],
	[2.3700000000E+04, 1.2813550535E+01, 5.0374782594E+00, 2.2914747710E+00, 1.4026138877E+00, 8.3848531802E-01],
	[2.3705000000E+04, 1.2817729298E+01, 5.0374007647E+00, 2.2930226122E+00, 1.4032377460E+00, 8.3855572967E-01],
	[2.3710000000E+04, 1.2821908543E+01, 5.0373232876E+00, 2.2945711714E+00, 1.4038616194E+00, 8.3862611265E-01],
	[2.3715000000E+04, 1.2826088268E+01, 5.0372458279E+00, 2.2961204489E+00, 1.4044855076E+00, 8.3869646696E-01],
	[2.3720000000E+04, 1.2830268475E+01, 5.0371683858E+00, 2.2976704448E+00, 1.4051094106E+00, 8.3876679262E-01],
	[2.3725000000E+04, 1.2834449162E+01, 5.0370909612E+00, 2.2992211593E+00, 1.4057333282E+00, 8.3883708961E-01],
	[2.3730000000E+04, 1.2838630330E+01, 5.0370135542E+00, 2.3007725926E+00, 1.4063572604E+00, 8.3890735796E-01],
	[2.3735000000E+04, 1.2842811979E+01, 5.0369361646E+00, 2.3023247449E+00, 1.4069812070E+00, 8.3897759766E-01],
	[2.3740000000E+04, 1.2846994109E+01, 5.0368587925E+00, 2.3038776164E+00, 1.4076051679E+00, 8.3904780873E-01],
	[2.3745000000E+04, 1.2851176719E+01, 5.0367814379E+00, 2.3054312071E+00, 1.4082291429E+00, 8.3911799117E-01],
	[2.3750000000E+04, 1.2855359810E+01, 5.0367041007E+00, 2.3069855174E+00, 1.4088531321E+00, 8.3918814498E-01],
	[2.3755000000E+04, 1.2859543382E+01, 5.0366267811E+00, 2.3085405474E+00, 1.4094771352E+00, 8.3925827017E-01],
	[2.3760000000E+04, 1.2863727434E+01, 5.0365494789E+00, 2.3100962972E+00, 1.4101011521E+00, 8.3932836675E-01],
	[2.3765000000E+04, 1.2867911967E+01, 5.0364721941E+00, 2.3116527671E+00, 1.4107251827E+00, 8.3939843473E-01],
	[2.3770000000E+04, 1.2872096981E+01, 5.0363949268E+00, 2.3132099572E+00, 1.4113492270E+00, 8.3946847411E-01],
	[2.3775000000E+04, 1.2876282474E+01, 5.0363176769E+00, 2.3147678678E+00, 1.4119732847E+00, 8.3953848489E-01],
	[2.3780000000E+04, 1.2880468448E+01, 5.0362404444E+00, 2.3163264990E+00, 1.4125973559E+00, 8.3960846709E-01],
	[2.3785000000E+04, 1.2884654903E+01, 5.0361632294E+00, 2.3178858509E+00, 1.4132214402E+00, 8.3967842070E-01],
	[2.3790000000E+04, 1.2888841838E+01, 5.0360860318E+00, 2.3194459238E+00, 1.4138455378E+00, 8.3974834575E-01],
	[2.3795000000E+04, 1.2893029253E+01, 5.0360088516E+00, 2.3210067179E+00, 1.4144696483E+00, 8.3981824222E-01],
	[2.3800000000E+04, 1.2897217148E+01, 5.0359316888E+00, 2.3225682332E+00, 1.4150937718E+00, 8.3988811013E-01],
	[2.3805000000E+04, 1.2901405523E+01, 5.0358545434E+00, 2.3241304701E+00, 1.4157179081E+00, 8.3995794948E-01],
	[2.3810000000E+04, 1.2905594379E+01, 5.0357774153E+00, 2.3256934287E+00, 1.4163420570E+00, 8.4002776029E-01],
	[2.3815000000E+04, 1.2909783714E+01, 5.0357003047E+00, 2.3272571091E+00, 1.4169662185E+00, 8.4009754255E-01],
	[2.3820000000E+04, 1.2913973530E+01, 5.0356232114E+00, 2.3288215116E+00, 1.4175903925E+00, 8.4016729628E-01],
	[2.3825000000E+04, 1.2918163825E+01, 5.0355461354E+00, 2.3303866363E+00, 1.4182145788E+00, 8.4023702147E-01],
	[2.3830000000E+04, 1.2922354601E+01, 5.0354690769E+00, 2.3319524835E+00, 1.4188387774E+00, 8.4030671815E-01],
	[2.3835000000E+04, 1.2926545856E+01, 5.0353920356E+00, 2.3335190532E+00, 1.4194629880E+00, 8.4037638630E-01],
	[2.3840000000E+04, 1.2930737592E+01, 5.0353150117E+00, 2.3350863457E+00, 1.4200872106E+00, 8.4044602594E-01],
	[2.3845000000E+04, 1.2934929807E+01, 5.0352380052E+00, 2.3366543611E+00, 1.4207114452E+00, 8.4051563708E-01],
	[2.3850000000E+04, 1.2939122501E+01, 5.0351610159E+00, 2.3382230997E+00, 1.4213356914E+00, 8.4058521972E-01],
	[2.3855000000E+04, 1.2943315676E+01, 5.0350840440E+00, 2.3397925617E+00, 1.4219599494E+00, 8.4065477386E-01],
	[2.3860000000E+04, 1.2947509330E+01, 5.0350070894E+00, 2.3413627471E+00, 1.4225842188E+00, 8.4072429953E-01],
	[2.3865000000E+04, 1.2951703464E+01, 5.0349301521E+00, 2.3429336562E+00, 1.4232084997E+00, 8.4079379671E-01],
	[2.3870000000E+04, 1.2955898077E+01, 5.0348532320E+00, 2.3445052891E+00, 1.4238327919E+00, 8.4086326542E-01],
	[2.3875000000E+04, 1.2960093170E+01, 5.0347763293E+00, 2.3460776461E+00, 1.4244570953E+00, 8.4093270566E-01],
	[2.3880000000E+04, 1.2964288742E+01, 5.0346994438E+00, 2.3476507274E+00, 1.4250814097E+00, 8.4100211744E-01],
	[2.3885000000E+04, 1.2968484794E+01, 5.0346225756E+00, 2.3492245330E+00, 1.4257057352E+00, 8.4107150077E-01],
	[2.3890000000E+04, 1.2972681325E+01, 5.0345457247E+00, 2.3507990632E+00, 1.4263300714E+00, 8.4114085565E-01],
	[2.3895000000E+04, 1.2976878335E+01, 5.0344688910E+00, 2.3523743182E+00, 1.4269544184E+00, 8.4121018210E-01],
	[2.3900000000E+04, 1.2981075825E+01, 5.0343920746E+00, 2.3539502982E+00, 1.4275787760E+00, 8.4127948010E-01],
	[2.3905000000E+04, 1.2985273794E+01, 5.0343152754E+00, 2.3555270033E+00, 1.4282031442E+00, 8.4134874968E-01],
	[2.3910000000E+04, 1.2989472242E+01, 5.0342384935E+00, 2.3571044337E+00, 1.4288275227E+00, 8.4141799084E-01],
	[2.3915000000E+04, 1.2993671170E+01, 5.0341617287E+00, 2.3586825895E+00, 1.4294519114E+00, 8.4148720359E-01],
	[2.3920000000E+04, 1.2997886805E+01, 5.0340884913E+00, 2.3602614711E+00, 1.4300767901E+00, 8.4155638793E-01],
	[2.3925000000E+04, 1.3002105045E+01, 5.0340157284E+00, 2.3618410785E+00, 1.4307017421E+00, 8.4162554386E-01],
	[2.3930000000E+04, 1.3006323772E+01, 5.0339429817E+00, 2.3634214120E+00, 1.4313267047E+00, 8.4169467140E-01],
	[2.3935000000E+04, 1.3010542986E+01, 5.0338702513E+00, 2.3650024717E+00, 1.4319516778E+00, 8.4176377056E-01],
	[2.3940000000E+04, 1.3014762687E+01, 5.0337975371E+00, 2.3665842578E+00, 1.4325766614E+00, 8.4183284133E-01],
	[2.3945000000E+04, 1.3018982875E+01, 5.0337248391E+00, 2.3681667705E+00, 1.4332016552E+00, 8.4190188373E-01],
	[2.3950000000E+04, 1.3023203550E+01, 5.0336521574E+00, 2.3697500099E+00, 1.4338266592E+00, 8.4197089776E-01],
	[2.3955000000E+04, 1.3027424711E+01, 5.0335794919E+00, 2.3713339763E+00, 1.4344516733E+00, 8.4203988342E-01],
	[2.3960000000E+04, 1.3031646360E+01, 5.0335068426E+00, 2.3729186698E+00, 1.4350766973E+00, 8.4210884074E-01],
	[2.3965000000E+04, 1.3035868495E+01, 5.0334342095E+00, 2.3745040906E+00, 1.4357017311E+00, 8.4217776970E-01],
	[2.3970000000E+04, 1.3040091117E+01, 5.0333615926E+00, 2.3760902390E+00, 1.4363267747E+00, 8.4224667032E-01],
	[2.3975000000E+04, 1.3044314226E+01, 5.0332889919E+00, 2.3776771149E+00, 1.4369518279E+00, 8.4231554261E-01],
	[2.3980000000E+04, 1.3048537821E+01, 5.0332164074E+00, 2.3792647188E+00, 1.4375768906E+00, 8.4238438657E-01],
	[2.3985000000E+04, 1.3052761903E+01, 5.0331438391E+00, 2.3808530507E+00, 1.4382019626E+00, 8.4245320221E-01],
	[2.3990000000E+04, 1.3056986471E+01, 5.0330712869E+00, 2.3824421108E+00, 1.4388270440E+00, 8.4252198953E-01],
	[2.3995000000E+04, 1.3061211526E+01, 5.0329987509E+00, 2.3840318993E+00, 1.4394521345E+00, 8.4259074854E-01],
	[2.4000000000E+04, 1.3065437067E+01, 5.0329262311E+00, 2.3856224163E+00, 1.4400772340E+00, 8.4265947925E-01],
	[2.4005000000E+04, 1.3069663095E+01, 5.0328537274E+00, 2.3872136622E+00, 1.4407023424E+00, 8.4272818167E-01],
	[2.4010000000E+04, 1.3073889609E+01, 5.0327812399E+00, 2.3888056370E+00, 1.4413274597E+00, 8.4279685580E-01],
	[2.4015000000E+04, 1.3078116609E+01, 5.0327087685E+00, 2.3903983409E+00, 1.4419525857E+00, 8.4286550165E-01],
	[2.4020000000E+04, 1.3082344095E+01, 5.0326363132E+00, 2.3919917741E+00, 1.4425777202E+00, 8.4293411923E-01],
	[2.4025000000E+04, 1.3086572068E+01, 5.0325638740E+00, 2.3935859368E+00, 1.4432028633E+00, 8.4300270853E-01],
	[2.4030000000E+04, 1.3090800527E+01, 5.0324914510E+00, 2.3951808292E+00, 1.4438280147E+00, 8.4307126958E-01],
	[2.4035000000E+04, 1.3095029472E+01, 5.0324190441E+00, 2.3967764514E+00, 1.4444531743E+00, 8.4313980237E-01],
	[2.4040000000E+04, 1.3099258903E+01, 5.0323466533E+00, 2.3983728036E+00, 1.4450783421E+00, 8.4320830691E-01],
	[2.4045000000E+04, 1.3103488820E+01, 5.0322742786E+00, 2.3999698861E+00, 1.4457035179E+00, 8.4327678321E-01],
	[2.4050000000E+04, 1.3107719223E+01, 5.0322019199E+00, 2.4015676990E+00, 1.4463287016E+00, 8.4334523128E-01],
	[2.4055000000E+04, 1.3111950112E+01, 5.0321295774E+00, 2.4031662424E+00, 1.4469538931E+00, 8.4341365113E-01],
	[2.4060000000E+04, 1.3116181487E+01, 5.0320572509E+00, 2.4047655166E+00, 1.4475790923E+00, 8.4348204275E-01],
	[2.4065000000E+04, 1.3120413347E+01, 5.0319849405E+00, 2.4063655218E+00, 1.4482042991E+00, 8.4355040616E-01],
	[2.4070000000E+04, 1.3124645694E+01, 5.0319126461E+00, 2.4079662581E+00, 1.4488295133E+00, 8.4361874136E-01],
	[2.4075000000E+04, 1.3128878526E+01, 5.0318403679E+00, 2.4095677256E+00, 1.4494547349E+00, 8.4368704837E-01],
	[2.4080000000E+04, 1.3133111844E+01, 5.0317681056E+00, 2.4111699247E+00, 1.4500799637E+00, 8.4375532718E-01],
	[2.4085000000E+04, 1.3137345648E+01, 5.0316958594E+00, 2.4127728554E+00, 1.4507051996E+00, 8.4382357780E-01],
	[2.4090000000E+04, 1.3141579937E+01, 5.0316236292E+00, 2.4143765180E+00, 1.4513304425E+00, 8.4389180025E-01],
	[2.4095000000E+04, 1.3145814712E+01, 5.0315514151E+00, 2.4159809126E+00, 1.4519556924E+00, 8.4395999452E-01],
	[2.4100000000E+04, 1.3150049972E+01, 5.0314792170E+00, 2.4175860394E+00, 1.4525809490E+00, 8.4402816063E-01],
	[2.4105000000E+04, 1.3154285718E+01, 5.0314070349E+00, 2.4191918986E+00, 1.4532062123E+00, 8.4409629859E-01],
	[2.4110000000E+04, 1.3158521949E+01, 5.0313348687E+00, 2.4207984904E+00, 1.4538314821E+00, 8.4416440839E-01],
	[2.4115000000E+04, 1.3162758665E+01, 5.0312627186E+00, 2.4224058149E+00, 1.4544567584E+00, 8.4423249004E-01],
	[2.4120000000E+04, 1.3166995867E+01, 5.0311905845E+00, 2.4240138724E+00, 1.4550820410E+00, 8.4430054356E-01],
	[2.4125000000E+04, 1.3171233554E+01, 5.0311184664E+00, 2.4256226630E+00, 1.4557073298E+00, 8.4436856895E-01],
	[2.4130000000E+04, 1.3175471727E+01, 5.0310463643E+00, 2.4272321869E+00, 1.4563326248E+00, 8.4443656622E-01],
	[2.4135000000E+04, 1.3179710385E+01, 5.0309742781E+00, 2.4288424443E+00, 1.4569579257E+00, 8.4450453537E-01],
	[2.4140000000E+04, 1.3183949528E+01, 5.0309022079E+00, 2.4304534354E+00, 1.4575832326E+00, 8.4457247641E-01],
	[2.4145000000E+04, 1.3188189156E+01, 5.0308301536E+00, 2.4320651603E+00, 1.4582085452E+00, 8.4464038935E-01],
	[2.4150000000E+04, 1.3192429269E+01, 5.0307581153E+00, 2.4336776192E+00, 1.4588338634E+00, 8.4470827419E-01],
	[2.4155000000E+04, 1.3196669867E+01, 5.0306860929E+00, 2.4352908124E+00, 1.4594591872E+00, 8.4477613095E-01],
	[2.4160000000E+04, 1.3200910950E+01, 5.0306140865E+00, 2.4369047399E+00, 1.4600845165E+00, 8.4484395962E-01],
	[2.4165000000E+04, 1.3205152518E+01, 5.0305420960E+00, 2.4385194020E+00, 1.4607098511E+00, 8.4491176023E-01],
	[2.4170000000E+04, 1.3209394571E+01, 5.0304701215E+00, 2.4401347989E+00, 1.4613351908E+00, 8.4497953276E-01],
	[2.4175000000E+04, 1.3213637108E+01, 5.0303981628E+00, 2.4417509307E+00, 1.4619605357E+00, 8.4504727723E-01],
	[2.4180000000E+04, 1.3217880131E+01, 5.0303262201E+00, 2.4433677976E+00, 1.4625858856E+00, 8.4511499365E-01],
	[2.4185000000E+04, 1.3222123638E+01, 5.0302542932E+00, 2.4449853999E+00, 1.4632112404E+00, 8.4518268203E-01],
	[2.4190000000E+04, 1.3226367630E+01, 5.0301823823E+00, 2.4466037376E+00, 1.4638365999E+00, 8.4525034237E-01],
	[2.4195000000E+04, 1.3230612107E+01, 5.0301104873E+00, 2.4482228109E+00, 1.4644619640E+00, 8.4531797467E-01],
	[2.4200000000E+04, 1.3234857068E+01, 5.0300386081E+00, 2.4498426202E+00, 1.4650873328E+00, 8.4538557895E-01],
	[2.4205000000E+04, 1.3239102514E+01, 5.0299667448E+00, 2.4514631654E+00, 1.4657127059E+00, 8.4545315522E-01],
	[2.4210000000E+04, 1.3243348445E+01, 5.0298948974E+00, 2.4530844469E+00, 1.4663380834E+00, 8.4552070347E-01],
	[2.4215000000E+04, 1.3247594860E+01, 5.0298230658E+00, 2.4547064647E+00, 1.4669634650E+00, 8.4558822372E-01],
	[2.4220000000E+04, 1.3251841759E+01, 5.0297512501E+00, 2.4563292192E+00, 1.4675888508E+00, 8.4565571598E-01],
	[2.4225000000E+04, 1.3256089143E+01, 5.0296794503E+00, 2.4579527104E+00, 1.4682142405E+00, 8.4572318024E-01],
	[2.4230000000E+04, 1.3260337011E+01, 5.0296076663E+00, 2.4595769385E+00, 1.4688396342E+00, 8.4579061653E-01],
	[2.4235000000E+04, 1.3264585363E+01, 5.0295358981E+00, 2.4612019037E+00, 1.4694650316E+00, 8.4585802484E-01],
	[2.4240000000E+04, 1.3268834200E+01, 5.0294641457E+00, 2.4628276063E+00, 1.4700904326E+00, 8.4592540518E-01],
	[2.4245000000E+04, 1.3273083521E+01, 5.0293924092E+00, 2.4644540463E+00, 1.4707158372E+00, 8.4599275757E-01],
	[2.4250000000E+04, 1.3277333326E+01, 5.0293206885E+00, 2.4660812240E+00, 1.4713412452E+00, 8.4606008200E-01],
	[2.4255000000E+04, 1.3281583615E+01, 5.0292489836E+00, 2.4677091396E+00, 1.4719666565E+00, 8.4612737848E-01],
	[2.4260000000E+04, 1.3285834389E+01, 5.0291772945E+00, 2.4693377931E+00, 1.4725920710E+00, 8.4619464703E-01],
	[2.4265000000E+04, 1.3290085646E+01, 5.0291056212E+00, 2.4709671849E+00, 1.4732174886E+00, 8.4626188765E-01],
	[2.4270000000E+04, 1.3294337387E+01, 5.0290339637E+00, 2.4725973151E+00, 1.4738429093E+00, 8.4632910034E-01],
	[2.4275000000E+04, 1.3298589613E+01, 5.0289623220E+00, 2.4742281838E+00, 1.4744683327E+00, 8.4639628511E-01],
	[2.4280000000E+04, 1.3302842322E+01, 5.0288906960E+00, 2.4758597913E+00, 1.4750937590E+00, 8.4646344198E-01],
	[2.4285000000E+04, 1.3307095515E+01, 5.0288190858E+00, 2.4774921378E+00, 1.4757191879E+00, 8.4653057095E-01],
	[2.4290000000E+04, 1.3311349192E+01, 5.0287474914E+00, 2.4791252234E+00, 1.4763446193E+00, 8.4659767202E-01],
	[2.4295000000E+04, 1.3315603353E+01, 5.0286759127E+00, 2.4807590482E+00, 1.4769700532E+00, 8.4666474520E-01],
	[2.4300000000E+04, 1.3319857997E+01, 5.0286043498E+00, 2.4823936126E+00, 1.4775954894E+00, 8.4673179050E-01],
	[2.4305000000E+04, 1.3324129689E+01, 5.0285362545E+00, 2.4840289166E+00, 1.4782214299E+00, 8.4679880793E-01],
	[2.4310000000E+04, 1.3328404070E+01, 5.0284686320E+00, 2.4856649605E+00, 1.4788474399E+00, 8.4686579750E-01],
	[2.4315000000E+04, 1.3332678942E+01, 5.0284010242E+00, 2.4873017444E+00, 1.4794734525E+00, 8.4693275921E-01],
	[2.4320000000E+04, 1.3336954306E+01, 5.0283334313E+00, 2.4889392685E+00, 1.4800994677E+00, 8.4699969306E-01],
	[2.4325000000E+04, 1.3341230162E+01, 5.0282658532E+00, 2.4905775330E+00, 1.4807254854E+00, 8.4706659907E-01],
	[2.4330000000E+04, 1.3345506509E+01, 5.0281982898E+00, 2.4922165381E+00, 1.4813515055E+00, 8.4713347725E-01],
	[2.4335000000E+04, 1.3349783348E+01, 5.0281307413E+00, 2.4938562840E+00, 1.4819775278E+00, 8.4720032760E-01],
	[2.4340000000E+04, 1.3354060678E+01, 5.0280632075E+00, 2.4954967707E+00, 1.4826035523E+00, 8.4726715013E-01],
	[2.4345000000E+04, 1.3358338500E+01, 5.0279956886E+00, 2.4971379986E+00, 1.4832295788E+00, 8.4733394484E-01],
	[2.4350000000E+04, 1.3362616813E+01, 5.0279281843E+00, 2.4987799679E+00, 1.4838556072E+00, 8.4740071175E-01],
	[2.4355000000E+04, 1.3366895618E+01, 5.0278606949E+00, 2.5004226786E+00, 1.4844816374E+00, 8.4746745085E-01],
	[2.4360000000E+04, 1.3371174914E+01, 5.0277932202E+00, 2.5020661309E+00, 1.4851076693E+00, 8.4753416217E-01],
	[2.4365000000E+04, 1.3375454701E+01, 5.0277257603E+00, 2.5037103251E+00, 1.4857337029E+00, 8.4760084570E-01],
	[2.4370000000E+04, 1.3379734980E+01, 5.0276583151E+00, 2.5053552614E+00, 1.4863597379E+00, 8.4766750145E-01],
	[2.4375000000E+04, 1.3384015749E+01, 5.0275908847E+00, 2.5070009399E+00, 1.4869857743E+00, 8.4773412944E-01],
	[2.4380000000E+04, 1.3388297010E+01, 5.0275234690E+00, 2.5086473607E+00, 1.4876118119E+00, 8.4780072966E-01],
	[2.4385000000E+04, 1.3392578762E+01, 5.0274560680E+00, 2.5102945242E+00, 1.4882378507E+00, 8.4786730213E-01],
	[2.4390000000E+04, 1.3396861005E+01, 5.0273886817E+00, 2.5119424304E+00, 1.4888638906E+00, 8.4793384685E-01],
	[2.4395000000E+04, 1.3401143740E+01, 5.0273213102E+00, 2.5135910795E+00, 1.4894899313E+00, 8.4800036383E-01],
	[2.4400000000E+04, 1.3405426965E+01, 5.0272539534E+00, 2.5152404718E+00, 1.4901159730E+00, 8.4806685308E-01],
	[2.4405000000E+04, 1.3409710681E+01, 5.0271866112E+00, 2.5168906074E+00, 1.4907420153E+00, 8.4813331461E-01],
	[2.4410000000E+04, 1.3413994888E+01, 5.0271192838E+00, 2.5185414864E+00, 1.4913680582E+00, 8.4819974842E-01],
	[2.4415000000E+04, 1.3418279586E+01, 5.0270519711E+00, 2.5201931092E+00, 1.4919941016E+00, 8.4826615451E-01],
	[2.4420000000E+04, 1.3422564775E+01, 5.0269846730E+00, 2.5218454758E+00, 1.4926201455E+00, 8.4833253291E-01],
	[2.4425000000E+04, 1.3426850454E+01, 5.0269173896E+00, 2.5234985864E+00, 1.4932461895E+00, 8.4839888361E-01],
	[2.4430000000E+04, 1.3431136624E+01, 5.0268501209E+00, 2.5251524412E+00, 1.4938722338E+00, 8.4846520663E-01],
	[2.4435000000E+04, 1.3435423285E+01, 5.0267828669E+00, 2.5268070405E+00, 1.4944982781E+00, 8.4853150196E-01],
	[2.4440000000E+04, 1.3439710437E+01, 5.0267156275E+00, 2.5284623843E+00, 1.4951243224E+00, 8.4859776962E-01],
	[2.4445000000E+04, 1.3443998079E+01, 5.0266484028E+00, 2.5301184729E+00, 1.4957503665E+00, 8.4866400962E-01],
	[2.4450000000E+04, 1.3448286211E+01, 5.0265811927E+00, 2.5317753064E+00, 1.4963764104E+00, 8.4873022196E-01],
	[2.4455000000E+04, 1.3452574835E+01, 5.0265139973E+00, 2.5334328851E+00, 1.4970024538E+00, 8.4879640666E-01],
	[2.4460000000E+04, 1.3456863948E+01, 5.0264468165E+00, 2.5350912091E+00, 1.4976284968E+00, 8.4886256371E-01],
	[2.4465000000E+04, 1.3461153552E+01, 5.0263796503E+00, 2.5367502786E+00, 1.4982545392E+00, 8.4892869312E-01],
	[2.4470000000E+04, 1.3465443647E+01, 5.0263124988E+00, 2.5384100937E+00, 1.4988805809E+00, 8.4899479491E-01],
	[2.4475000000E+04, 1.3469734231E+01, 5.0262453619E+00, 2.5400706547E+00, 1.4995066217E+00, 8.4906086909E-01],
	[2.4480000000E+04, 1.3474025306E+01, 5.0261782395E+00, 2.5417319618E+00, 1.5001326617E+00, 8.4912691564E-01],
	[2.4485000000E+04, 1.3478316872E+01, 5.0261111318E+00, 2.5433940150E+00, 1.5007587006E+00, 8.4919293460E-01],
	[2.4490000000E+04, 1.3482608927E+01, 5.0260440387E+00, 2.5450568147E+00, 1.5013847384E+00, 8.4925892596E-01],
	[2.4495000000E+04, 1.3486901473E+01, 5.0259769602E+00, 2.5467203610E+00, 1.5020107749E+00, 8.4932488973E-01],
	[2.4500000000E+04, 1.3491194508E+01, 5.0259098962E+00, 2.5483846540E+00, 1.5026368101E+00, 8.4939082592E-01],
	[2.4505000000E+04, 1.3495488034E+01, 5.0258428469E+00, 2.5500496939E+00, 1.5032628438E+00, 8.4945673454E-01],
	[2.4510000000E+04, 1.3499782050E+01, 5.0257758121E+00, 2.5517154811E+00, 1.5038888759E+00, 8.4952261559E-01],
	[2.4515000000E+04, 1.3504076556E+01, 5.0257087919E+00, 2.5533820155E+00, 1.5045149063E+00, 8.4958846909E-01],
	[2.4520000000E+04, 1.3508371552E+01, 5.0256417862E+00, 2.5550492974E+00, 1.5051409350E+00, 8.4965429503E-01],
	[2.4525000000E+04, 1.3512667037E+01, 5.0255747951E+00, 2.5567173270E+00, 1.5057669617E+00, 8.4972009343E-01],
	[2.4530000000E+04, 1.3516963013E+01, 5.0255078186E+00, 2.5583861045E+00, 1.5063929865E+00, 8.4978586430E-01],
	[2.4535000000E+04, 1.3521259478E+01, 5.0254408565E+00, 2.5600556300E+00, 1.5070190091E+00, 8.4985160764E-01],
	[2.4540000000E+04, 1.3525556433E+01, 5.0253739091E+00, 2.5617259037E+00, 1.5076450295E+00, 8.4991732346E-01],
	[2.4545000000E+04, 1.3529853878E+01, 5.0253069761E+00, 2.5633969258E+00, 1.5082710476E+00, 8.4998301177E-01],
	[2.4550000000E+04, 1.3534151812E+01, 5.0252400577E+00, 2.5650686966E+00, 1.5088970632E+00, 8.5004867257E-01],
	[2.4555000000E+04, 1.3538450236E+01, 5.0251731538E+00, 2.5667412161E+00, 1.5095230763E+00, 8.5011430588E-01],
	[2.4560000000E+04, 1.3542749150E+01, 5.0251062644E+00, 2.5684144845E+00, 1.5101490867E+00, 8.5017991170E-01],
	[2.4565000000E+04, 1.3547048553E+01, 5.0250393895E+00, 2.5700885021E+00, 1.5107750944E+00, 8.5024549004E-01],
	[2.4570000000E+04, 1.3551348445E+01, 5.0249725292E+00, 2.5717632691E+00, 1.5114010992E+00, 8.5031104091E-01],
	[2.4575000000E+04, 1.3555648827E+01, 5.0249056833E+00, 2.5734387855E+00, 1.5120271010E+00, 8.5037656431E-01],
	[2.4580000000E+04, 1.3559949699E+01, 5.0248388519E+00, 2.5751150516E+00, 1.5126530997E+00, 8.5044206025E-01],
	[2.4585000000E+04, 1.3564251060E+01, 5.0247720350E+00, 2.5767920676E+00, 1.5132790952E+00, 8.5050752874E-01],
	[2.4590000000E+04, 1.3568552910E+01, 5.0247052325E+00, 2.5784698336E+00, 1.5139050874E+00, 8.5057296980E-01],
	[2.4595000000E+04, 1.3572855249E+01, 5.0246384445E+00, 2.5801483499E+00, 1.5145310762E+00, 8.5063838341E-01],
	[2.4600000000E+04, 1.3577158078E+01, 5.0245716710E+00, 2.5818276165E+00, 1.5151570615E+00, 8.5070376961E-01],
	[2.4605000000E+04, 1.3581461396E+01, 5.0245049120E+00, 2.5835076338E+00, 1.5157830431E+00, 8.5076912838E-01],
	[2.4610000000E+04, 1.3585765203E+01, 5.0244381674E+00, 2.5851884018E+00, 1.5164090210E+00, 8.5083445974E-01],
	[2.4615000000E+04, 1.3590069499E+01, 5.0243714372E+00, 2.5868699208E+00, 1.5170349951E+00, 8.5089976370E-01],
	[2.4620000000E+04, 1.3594374284E+01, 5.0243047215E+00, 2.5885521910E+00, 1.5176609652E+00, 8.5096504027E-01],
	[2.4625000000E+04, 1.3598679558E+01, 5.0242380202E+00, 2.5902352125E+00, 1.5182869313E+00, 8.5103028945E-01],
	[2.4630000000E+04, 1.3602985321E+01, 5.0241713334E+00, 2.5919189855E+00, 1.5189128932E+00, 8.5109551124E-01],
	[2.4635000000E+04, 1.3607291573E+01, 5.0241046610E+00, 2.5936035102E+00, 1.5195388508E+00, 8.5116070567E-01],
	[2.4640000000E+04, 1.3611598314E+01, 5.0240380029E+00, 2.5952887867E+00, 1.5201648040E+00, 8.5122587274E-01],
	[2.4645000000E+04, 1.3615905544E+01, 5.0239713593E+00, 2.5969748153E+00, 1.5207907528E+00, 8.5129101244E-01],
	[2.4650000000E+04, 1.3620213262E+01, 5.0239047301E+00, 2.5986615962E+00, 1.5214166969E+00, 8.5135612480E-01],
	[2.4655000000E+04, 1.3624521470E+01, 5.0238381153E+00, 2.6003491294E+00, 1.5220426364E+00, 8.5142120982E-01],
	[2.4660000000E+04, 1.3628830166E+01, 5.0237715149E+00, 2.6020374153E+00, 1.5226685710E+00, 8.5148626751E-01],
	[2.4665000000E+04, 1.3633139350E+01, 5.0237049289E+00, 2.6037264540E+00, 1.5232945007E+00, 8.5155129788E-01],
	[2.4670000000E+04, 1.3637449023E+01, 5.0236383572E+00, 2.6054162456E+00, 1.5239204254E+00, 8.5161630092E-01],
	[2.4675000000E+04, 1.3641759185E+01, 5.0235717999E+00, 2.6071067904E+00, 1.5245463450E+00, 8.5168127666E-01],
	[2.4680000000E+04, 1.3646069836E+01, 5.0235052570E+00, 2.6087980885E+00, 1.5251722593E+00, 8.5174622510E-01],
	[2.4685000000E+04, 1.3650380975E+01, 5.0234387285E+00, 2.6104901401E+00, 1.5257981683E+00, 8.5181114625E-01],
	[2.4690000000E+04, 1.3654692602E+01, 5.0233722143E+00, 2.6121829454E+00, 1.5264240718E+00, 8.5187604011E-01],
	[2.4695000000E+04, 1.3659017025E+01, 5.0233081862E+00, 2.6138765047E+00, 1.5270503521E+00, 8.5194090669E-01],
	[2.4700000000E+04, 1.3663348817E+01, 5.0232455524E+00, 2.6155708179E+00, 1.5276768407E+00, 8.5200574601E-01],
	[2.4705000000E+04, 1.3667681106E+01, 5.0231829320E+00, 2.6172658854E+00, 1.5283033243E+00, 8.5207055807E-01],
	[2.4710000000E+04, 1.3672013891E+01, 5.0231203251E+00, 2.6189617074E+00, 1.5289298027E+00, 8.5213534287E-01],
	[2.4715000000E+04, 1.3676347173E+01, 5.0230577317E+00, 2.6206582839E+00, 1.5295562759E+00, 8.5220010043E-01],
	[2.4720000000E+04, 1.3680680951E+01, 5.0229951516E+00, 2.6223556153E+00, 1.5301827436E+00, 8.5226483075E-01],
	[2.4725000000E+04, 1.3685015225E+01, 5.0229325850E+00, 2.6240537016E+00, 1.5308092059E+00, 8.5232953384E-01],
	[2.4730000000E+04, 1.3689349996E+01, 5.0228700319E+00, 2.6257525431E+00, 1.5314356626E+00, 8.5239420971E-01],
	[2.4735000000E+04, 1.3693685264E+01, 5.0228074921E+00, 2.6274521399E+00, 1.5320621136E+00, 8.5245885837E-01],
	[2.4740000000E+04, 1.3698021027E+01, 5.0227449658E+00, 2.6291524923E+00, 1.5326885589E+00, 8.5252347983E-01],
	[2.4745000000E+04, 1.3702357287E+01, 5.0226824529E+00, 2.6308536003E+00, 1.5333149981E+00, 8.5258807408E-01],
	[2.4750000000E+04, 1.3706694043E+01, 5.0226199534E+00, 2.6325554643E+00, 1.5339414314E+00, 8.5265264115E-01],
	[2.4755000000E+04, 1.3711031295E+01, 5.0225574673E+00, 2.6342580843E+00, 1.5345678586E+00, 8.5271718104E-01],
	[2.4760000000E+04, 1.3715369043E+01, 5.0224949946E+00, 2.6359614606E+00, 1.5351942795E+00, 8.5278169376E-01],
	[2.4765000000E+04, 1.3719707287E+01, 5.0224325353E+00, 2.6376655933E+00, 1.5358206941E+00, 8.5284617931E-01],
	[2.4770000000E+04, 1.3724046027E+01, 5.0223700894E+00, 2.6393704826E+00, 1.5364471023E+00, 8.5291063770E-01],
	[2.4775000000E+04, 1.3728385263E+01, 5.0223076569E+00, 2.6410761287E+00, 1.5370735039E+00, 8.5297506895E-01],
	[2.4780000000E+04, 1.3732724995E+01, 5.0222452377E+00, 2.6427825318E+00, 1.5376998989E+00, 8.5303947305E-01],
	[2.4785000000E+04, 1.3737065223E+01, 5.0221828319E+00, 2.6444896921E+00, 1.5383262871E+00, 8.5310385002E-01],
	[2.4790000000E+04, 1.3741405947E+01, 5.0221204395E+00, 2.6461976098E+00, 1.5389526684E+00, 8.5316819987E-01],
	[2.4795000000E+04, 1.3745747166E+01, 5.0220580604E+00, 2.6479062849E+00, 1.5395790428E+00, 8.5323252260E-01],
	[2.4800000000E+04, 1.3750088881E+01, 5.0219956947E+00, 2.6496157178E+00, 1.5402054101E+00, 8.5329681823E-01],
	[2.4805000000E+04, 1.3754431092E+01, 5.0219333423E+00, 2.6513259086E+00, 1.5408317703E+00, 8.5336108675E-01],
	[2.4810000000E+04, 1.3758773799E+01, 5.0218710033E+00, 2.6530368574E+00, 1.5414581231E+00, 8.5342532818E-01],
	[2.4815000000E+04, 1.3763117001E+01, 5.0218086776E+00, 2.6547485645E+00, 1.5420844686E+00, 8.5348954253E-01],
	[2.4820000000E+04, 1.3767460699E+01, 5.0217463652E+00, 2.6564610301E+00, 1.5427108065E+00, 8.5355372980E-01],
	[2.4825000000E+04, 1.3771804892E+01, 5.0216840662E+00, 2.6581742543E+00, 1.5433371369E+00, 8.5361789000E-01],
	[2.4830000000E+04, 1.3776149581E+01, 5.0216217805E+00, 2.6598882373E+00, 1.5439634596E+00, 8.5368202315E-01],
	[2.4835000000E+04, 1.3780494765E+01, 5.0215595080E+00, 2.6616029793E+00, 1.5445897744E+00, 8.5374612924E-01],
	[2.4840000000E+04, 1.3784840445E+01, 5.0214972489E+00, 2.6633184805E+00, 1.5452160813E+00, 8.5381020829E-01],
	[2.4845000000E+04, 1.3789186619E+01, 5.0214350031E+00, 2.6650347410E+00, 1.5458423802E+00, 8.5387426031E-01],
	[2.4850000000E+04, 1.3793533290E+01, 5.0213727706E+00, 2.6667517611E+00, 1.5464686710E+00, 8.5393828529E-01],
	[2.4855000000E+04, 1.3797880455E+01, 5.0213105514E+00, 2.6684695409E+00, 1.5470949536E+00, 8.5400228326E-01],
	[2.4860000000E+04, 1.3802228116E+01, 5.0212483455E+00, 2.6701880806E+00, 1.5477212278E+00, 8.5406625422E-01],
	[2.4865000000E+04, 1.3806576272E+01, 5.0211861529E+00, 2.6719073804E+00, 1.5483474936E+00, 8.5413019818E-01],
	[2.4870000000E+04, 1.3810924923E+01, 5.0211239735E+00, 2.6736274405E+00, 1.5489737508E+00, 8.5419411514E-01],
	[2.4875000000E+04, 1.3815274069E+01, 5.0210618074E+00, 2.6753482610E+00, 1.5495999994E+00, 8.5425800512E-01],
	[2.4880000000E+04, 1.3819623710E+01, 5.0209996545E+00, 2.6770698422E+00, 1.5502262392E+00, 8.5432186811E-01],
	[2.4885000000E+04, 1.3823973846E+01, 5.0209375150E+00, 2.6787921841E+00, 1.5508524701E+00, 8.5438570414E-01],
	[2.4890000000E+04, 1.3828324478E+01, 5.0208753886E+00, 2.6805152871E+00, 1.5514786921E+00, 8.5444951321E-01],
	[2.4895000000E+04, 1.3832675604E+01, 5.0208132756E+00, 2.6822391513E+00, 1.5521049051E+00, 8.5451329532E-01],
	[2.4900000000E+04, 1.3837027225E+01, 5.0207511757E+00, 2.6839637769E+00, 1.5527311088E+00, 8.5457705049E-01],
	[2.4905000000E+04, 1.3841379340E+01, 5.0206890891E+00, 2.6856891640E+00, 1.5533573033E+00, 8.5464077873E-01],
	[2.4910000000E+04, 1.3845731951E+01, 5.0206270158E+00, 2.6874153128E+00, 1.5539834884E+00, 8.5470448003E-01],
	[2.4915000000E+04, 1.3850085056E+01, 5.0205649556E+00, 2.6891422235E+00, 1.5546096639E+00, 8.5476815441E-01],
	[2.4920000000E+04, 1.3854438656E+01, 5.0205029087E+00, 2.6908698964E+00, 1.5552358299E+00, 8.5483180188E-01],
	[2.4925000000E+04, 1.3858792751E+01, 5.0204408750E+00, 2.6925983315E+00, 1.5558619862E+00, 8.5489542245E-01],
	[2.4930000000E+04, 1.3863147340E+01, 5.0203788545E+00, 2.6943275291E+00, 1.5564881327E+00, 8.5495901612E-01],
	[2.4935000000E+04, 1.3867502424E+01, 5.0203168472E+00, 2.6960574894E+00, 1.5571142693E+00, 8.5502258291E-01],
	[2.4940000000E+04, 1.3871858002E+01, 5.0202548531E+00, 2.6977882125E+00, 1.5577403959E+00, 8.5508612281E-01],
	[2.4945000000E+04, 1.3876214075E+01, 5.0201928722E+00, 2.6995196986E+00, 1.5583665124E+00, 8.5514963585E-01],
	[2.4950000000E+04, 1.3880570643E+01, 5.0201309045E+00, 2.7012519479E+00, 1.5589926187E+00, 8.5521312202E-01],
	[2.4955000000E+04, 1.3884927704E+01, 5.0200689499E+00, 2.7029849606E+00, 1.5596187146E+00, 8.5527658134E-01],
	[2.4960000000E+04, 1.3889285260E+01, 5.0200070086E+00, 2.7047187368E+00, 1.5602448001E+00, 8.5534001381E-01],
	[2.4965000000E+04, 1.3893643311E+01, 5.0199450804E+00, 2.7064532768E+00, 1.5608708751E+00, 8.5540341945E-01],
	[2.4970000000E+04, 1.3898001855E+01, 5.0198831654E+00, 2.7081885807E+00, 1.5614969394E+00, 8.5546679825E-01],
	[2.4975000000E+04, 1.3902360894E+01, 5.0198212635E+00, 2.7099246487E+00, 1.5621229930E+00, 8.5553015024E-01],
	[2.4980000000E+04, 1.3906720427E+01, 5.0197593748E+00, 2.7116614811E+00, 1.5627490357E+00, 8.5559347541E-01],
	[2.4985000000E+04, 1.3911080455E+01, 5.0196974992E+00, 2.7133990779E+00, 1.5633750676E+00, 8.5565677378E-01],
	[2.4990000000E+04, 1.3915440976E+01, 5.0196356368E+00, 2.7151374393E+00, 1.5640010883E+00, 8.5572004535E-01],
	[2.4995000000E+04, 1.3919801991E+01, 5.0195737875E+00, 2.7168765656E+00, 1.5646270979E+00, 8.5578329013E-01],
	[2.5000000000E+04, 1.3924163501E+01, 5.0195119514E+00, 2.7186164570E+00, 1.5652530963E+00, 8.5584650814E-01],
	[2.5005000000E+04, 1.3928525504E+01, 5.0194501284E+00, 2.7203614189E+00, 1.5658805098E+00, 8.5590969937E-01],
	[2.5010000000E+04, 1.3932888002E+01, 5.0193883185E+00, 2.7221071510E+00, 1.5665079120E+00, 8.5597286384E-01],
	[2.5015000000E+04, 1.3937250993E+01, 5.0193265217E+00, 2.7238536534E+00, 1.5671353029E+00, 8.5603600156E-01],
	[2.5020000000E+04, 1.3941614478E+01, 5.0192647380E+00, 2.7256009263E+00, 1.5677626823E+00, 8.5609911253E-01],
	[2.5025000000E+04, 1.3945978457E+01, 5.0192029675E+00, 2.7273489699E+00, 1.5683900501E+00, 8.5616219677E-01],
	[2.5030000000E+04, 1.3950342929E+01, 5.0191412100E+00, 2.7290977843E+00, 1.5690174062E+00, 8.5622525427E-01],
	[2.5035000000E+04, 1.3954707896E+01, 5.0190794656E+00, 2.7308473699E+00, 1.5696447506E+00, 8.5628828506E-01],
	[2.5040000000E+04, 1.3959073356E+01, 5.0190177344E+00, 2.7325977267E+00, 1.5702720830E+00, 8.5635128913E-01],
	[2.5045000000E+04, 1.3963439309E+01, 5.0189560162E+00, 2.7343488549E+00, 1.5708994035E+00, 8.5641426650E-01],
	[2.5050000000E+04, 1.3967805756E+01, 5.0188943111E+00, 2.7361007547E+00, 1.5715267119E+00, 8.5647721717E-01],
	[2.5055000000E+04, 1.3972172697E+01, 5.0188326190E+00, 2.7378534264E+00, 1.5721540081E+00, 8.5654014116E-01],
	[2.5060000000E+04, 1.3976540131E+01, 5.0187709400E+00, 2.7396068700E+00, 1.5727812919E+00, 8.5660303846E-01],
	[2.5065000000E+04, 1.3980908059E+01, 5.0187092741E+00, 2.7413610858E+00, 1.5734085634E+00, 8.5666590910E-01],
	[2.5070000000E+04, 1.3985276480E+01, 5.0186476213E+00, 2.7431160740E+00, 1.5740358223E+00, 8.5672875308E-01],
	[2.5075000000E+04, 1.3989645395E+01, 5.0185859815E+00, 2.7448718348E+00, 1.5746630686E+00, 8.5679157040E-01],
	[2.5080000000E+04, 1.3994014803E+01, 5.0185243547E+00, 2.7466283682E+00, 1.5752903022E+00, 8.5685436108E-01],
	[2.5085000000E+04, 1.3998384704E+01, 5.0184627410E+00, 2.7483856746E+00, 1.5759175230E+00, 8.5691712512E-01],
	[2.5090000000E+04, 1.4002757838E+01, 5.0184016743E+00, 2.7501437541E+00, 1.5765448183E+00, 8.5697986253E-01],
	[2.5095000000E+04, 1.4007148196E+01, 5.0183438788E+00, 2.7519026069E+00, 1.5771726346E+00, 8.5704257332E-01],
	[2.5100000000E+04, 1.4011539055E+01, 5.0182860955E+00, 2.7536622331E+00, 1.5778004384E+00, 8.5710525750E-01],
	[2.5105000000E+04, 1.4015930416E+01, 5.0182283243E+00, 2.7554226331E+00, 1.5784282298E+00, 8.5716791508E-01],
	[2.5110000000E+04, 1.4020322278E+01, 5.0181705653E+00, 2.7571838068E+00, 1.5790560085E+00, 8.5723054607E-01],
	[2.5115000000E+04, 1.4024714641E+01, 5.0181128185E+00, 2.7589457546E+00, 1.5796837745E+00, 8.5729315047E-01],
	[2.5120000000E+04, 1.4029107506E+01, 5.0180550839E+00, 2.7607084766E+00, 1.5803115277E+00, 8.5735572829E-01],
	[2.5125000000E+04, 1.4033500872E+01, 5.0179973614E+00, 2.7624719730E+00, 1.5809392679E+00, 8.5741827954E-01],
	[2.5130000000E+04, 1.4037894739E+01, 5.0179396510E+00, 2.7642362440E+00, 1.5815669951E+00, 8.5748080424E-01],
	[2.5135000000E+04, 1.4042289107E+01, 5.0178819528E+00, 2.7660012898E+00, 1.5821947092E+00, 8.5754330238E-01],
	[2.5140000000E+04, 1.4046683976E+01, 5.0178242668E+00, 2.7677671106E+00, 1.5828224100E+00, 8.5760577398E-01],
	[2.5145000000E+04, 1.4051079347E+01, 5.0177665928E+00, 2.7695337065E+00, 1.5834500975E+00, 8.5766821904E-01],
	[2.5150000000E+04, 1.4055475218E+01, 5.0177089310E+00, 2.7713010777E+00, 1.5840777716E+00, 8.5773063758E-01],
	[2.5155000000E+04, 1.4059871591E+01, 5.0176512814E+00, 2.7730692244E+00, 1.5847054321E+00, 8.5779302960E-01],
	[2.5160000000E+04, 1.4064268464E+01, 5.0175936438E+00, 2.7748381469E+00, 1.5853330789E+00, 8.5785539511E-01],
	[2.5165000000E+04, 1.4068665838E+01, 5.0175360184E+00, 2.7766078452E+00, 1.5859607120E+00, 8.5791773412E-01],
	[2.5170000000E+04, 1.4073063713E+01, 5.0174784051E+00, 2.7783783196E+00, 1.5865883313E+00, 8.5798004664E-01],
	[2.5175000000E+04, 1.4077462089E+01, 5.0174208038E+00, 2.7801495702E+00, 1.5872159366E+00, 8.5804233267E-01],
	[2.5180000000E+04, 1.4081860966E+01, 5.0173632147E+00, 2.7819215974E+00, 1.5878435278E+00, 8.5810459223E-01],
	[2.5185000000E+04, 1.4086260344E+01, 5.0173056377E+00, 2.7836944011E+00, 1.5884711049E+00, 8.5816682532E-01],
	[2.5190000000E+04, 1.4090660222E+01, 5.0172480727E+00, 2.7854679816E+00, 1.5890986677E+00, 8.5822903196E-01],
	[2.5195000000E+04, 1.4095060601E+01, 5.0171905199E+00, 2.7872423392E+00, 1.5897262161E+00, 8.5829121215E-01],
	[2.5200000000E+04, 1.4099461480E+01, 5.0171329791E+00, 2.7890174739E+00, 1.5903537501E+00, 8.5835336589E-01],
	[2.5205000000E+04, 1.4103862860E+01, 5.0170754504E+00, 2.7907933861E+00, 1.5909812695E+00, 8.5841549319E-01],
	[2.5210000000E+04, 1.4108264741E+01, 5.0170179338E+00, 2.7925700757E+00, 1.5916087742E+00, 8.5847759407E-01],
	[2.5215000000E+04, 1.4112667122E+01, 5.0169604292E+00, 2.7943475432E+00, 1.5922362642E+00, 8.5853966852E-01],
	[2.5220000000E+04, 1.4117070003E+01, 5.0169029367E+00, 2.7961257885E+00, 1.5928637393E+00, 8.5860171655E-01],
	[2.5225000000E+04, 1.4121473385E+01, 5.0168454563E+00, 2.7979048120E+00, 1.5934911994E+00, 8.5866373817E-01],
	[2.5230000000E+04, 1.4125877267E+01, 5.0167879879E+00, 2.7996846138E+00, 1.5941186444E+00, 8.5872573339E-01],
	[2.5235000000E+04, 1.4130281650E+01, 5.0167305316E+00, 2.8014651940E+00, 1.5947460742E+00, 8.5878770221E-01],
	[2.5240000000E+04, 1.4134686533E+01, 5.0166730872E+00, 2.8032465530E+00, 1.5953734888E+00, 8.5884964464E-01],
	[2.5245000000E+04, 1.4139091916E+01, 5.0166156550E+00, 2.8050286908E+00, 1.5960008879E+00, 8.5891156069E-01],
	[2.5250000000E+04, 1.4143497799E+01, 5.0165582347E+00, 2.8068116076E+00, 1.5966282716E+00, 8.5897345037E-01],
	[2.5255000000E+04, 1.4147904182E+01, 5.0165008265E+00, 2.8085953037E+00, 1.5972556397E+00, 8.5903531368E-01],
	[2.5260000000E+04, 1.4152311066E+01, 5.0164434303E+00, 2.8103797791E+00, 1.5978829921E+00, 8.5909715062E-01],
	[2.5265000000E+04, 1.4156718449E+01, 5.0163860462E+00, 2.8121650342E+00, 1.5985103287E+00, 8.5915896122E-01],
	[2.5270000000E+04, 1.4161126333E+01, 5.0163286740E+00, 2.8139510691E+00, 1.5991376494E+00, 8.5922074546E-01],
	[2.5275000000E+04, 1.4165534716E+01, 5.0162713138E+00, 2.8157378840E+00, 1.5997649541E+00, 8.5928250337E-01],
	[2.5280000000E+04, 1.4169943600E+01, 5.0162139657E+00, 2.8175254790E+00, 1.6003922427E+00, 8.5934423494E-01],
	[2.5285000000E+04, 1.4174352983E+01, 5.0161566295E+00, 2.8193138543E+00, 1.6010195151E+00, 8.5940594019E-01],
	[2.5290000000E+04, 1.4178762866E+01, 5.0160993054E+00, 2.8211030102E+00, 1.6016467712E+00, 8.5946761912E-01],
	[2.5295000000E+04, 1.4183173249E+01, 5.0160419932E+00, 2.8228929468E+00, 1.6022740109E+00, 8.5952927174E-01],
	[2.5300000000E+04, 1.4187584132E+01, 5.0159846930E+00, 2.8246836643E+00, 1.6029012342E+00, 8.5959089805E-01],
	[2.5305000000E+04, 1.4191995515E+01, 5.0159274048E+00, 2.8264751629E+00, 1.6035284408E+00, 8.5965249807E-01],
	[2.5310000000E+04, 1.4196407397E+01, 5.0158701285E+00, 2.8282674428E+00, 1.6041556307E+00, 8.5971407180E-01],
	[2.5315000000E+04, 1.4200819779E+01, 5.0158128642E+00, 2.8300605041E+00, 1.6047828038E+00, 8.5977561924E-01],
	[2.5320000000E+04, 1.4205232660E+01, 5.0157556119E+00, 2.8318543471E+00, 1.6054099600E+00, 8.5983714041E-01],
	[2.5325000000E+04, 1.4209646041E+01, 5.0156983716E+00, 2.8336489719E+00, 1.6060370992E+00, 8.5989863531E-01],
	[2.5330000000E+04, 1.4214059921E+01, 5.0156411432E+00, 2.8354443787E+00, 1.6066642212E+00, 8.5996010395E-01],
	[2.5335000000E+04, 1.4218474301E+01, 5.0155839267E+00, 2.8372405678E+00, 1.6072913261E+00, 8.6002154634E-01],
	[2.5340000000E+04, 1.4222889181E+01, 5.0155267222E+00, 2.8390375392E+00, 1.6079184137E+00, 8.6008296248E-01],
	[2.5345000000E+04, 1.4227304559E+01, 5.0154695296E+00, 2.8408352932E+00, 1.6085454838E+00, 8.6014435238E-01],
	[2.5350000000E+04, 1.4231720438E+01, 5.0154123490E+00, 2.8426338299E+00, 1.6091725365E+00, 8.6020571605E-01],
	[2.5355000000E+04, 1.4236136815E+01, 5.0153551803E+00, 2.8444331497E+00, 1.6097995715E+00, 8.6026705349E-01],
	[2.5360000000E+04, 1.4240553692E+01, 5.0152980235E+00, 2.8462332525E+00, 1.6104265888E+00, 8.6032836472E-01],
	[2.5365000000E+04, 1.4244971067E+01, 5.0152408786E+00, 2.8480341387E+00, 1.6110535883E+00, 8.6038964974E-01],
	[2.5370000000E+04, 1.4249388942E+01, 5.0151837457E+00, 2.8498358083E+00, 1.6116805699E+00, 8.6045090855E-01],
	[2.5375000000E+04, 1.4253807317E+01, 5.0151266246E+00, 2.8516382617E+00, 1.6123075335E+00, 8.6051214116E-01],
	[2.5380000000E+04, 1.4258226190E+01, 5.0150695155E+00, 2.8534414989E+00, 1.6129344790E+00, 8.6057334759E-01],
	[2.5385000000E+04, 1.4262645562E+01, 5.0150124182E+00, 2.8552455202E+00, 1.6135614062E+00, 8.6063452784E-01],
	[2.5390000000E+04, 1.4267065434E+01, 5.0149553329E+00, 2.8570503257E+00, 1.6141883152E+00, 8.6069568191E-01],
	[2.5395000000E+04, 1.4271485804E+01, 5.0148982594E+00, 2.8588559157E+00, 1.6148152057E+00, 8.6075680982E-01],
	[2.5400000000E+04, 1.4275906673E+01, 5.0148411979E+00, 2.8606622903E+00, 1.6154420777E+00, 8.6081791156E-01],
	[2.5405000000E+04, 1.4280328041E+01, 5.0147841482E+00, 2.8624694497E+00, 1.6160689311E+00, 8.6087898716E-01],
	[2.5410000000E+04, 1.4284749908E+01, 5.0147271103E+00, 2.8642773941E+00, 1.6166957658E+00, 8.6094003661E-01],
	[2.5415000000E+04, 1.4289172274E+01, 5.0146700844E+00, 2.8660861237E+00, 1.6173225816E+00, 8.6100105992E-01],
	[2.5420000000E+04, 1.4293595138E+01, 5.0146130703E+00, 2.8678956387E+00, 1.6179493786E+00, 8.6106205710E-01],
	[2.5425000000E+04, 1.4298018501E+01, 5.0145560681E+00, 2.8697059392E+00, 1.6185761565E+00, 8.6112302816E-01],
	[2.5430000000E+04, 1.4302442363E+01, 5.0144990778E+00, 2.8715170254E+00, 1.6192029154E+00, 8.6118397311E-01],
	[2.5435000000E+04, 1.4306866724E+01, 5.0144420992E+00, 2.8733288975E+00, 1.6198296550E+00, 8.6124489194E-01],
	[2.5440000000E+04, 1.4311291583E+01, 5.0143851326E+00, 2.8751415558E+00, 1.6204563753E+00, 8.6130578468E-01],
	[2.5445000000E+04, 1.4315716940E+01, 5.0143281778E+00, 2.8769550004E+00, 1.6210830762E+00, 8.6136665132E-01],
	[2.5450000000E+04, 1.4320142797E+01, 5.0142712348E+00, 2.8787692314E+00, 1.6217097576E+00, 8.6142749188E-01],
	[2.5455000000E+04, 1.4324569151E+01, 5.0142143036E+00, 2.8805842491E+00, 1.6223364193E+00, 8.6148830636E-01],
	[2.5460000000E+04, 1.4328996004E+01, 5.0141573843E+00, 2.8824000537E+00, 1.6229630614E+00, 8.6154909476E-01],
	[2.5465000000E+04, 1.4333423356E+01, 5.0141004768E+00, 2.8842166453E+00, 1.6235896836E+00, 8.6160985711E-01],
	[2.5470000000E+04, 1.4337851205E+01, 5.0140435811E+00, 2.8860340241E+00, 1.6242162860E+00, 8.6167059340E-01],
	[2.5475000000E+04, 1.4342279553E+01, 5.0139866973E+00, 2.8878521903E+00, 1.6248428683E+00, 8.6173130364E-01],
	[2.5480000000E+04, 1.4346708400E+01, 5.0139298252E+00, 2.8896711442E+00, 1.6254694305E+00, 8.6179198783E-01],
	[2.5485000000E+04, 1.4351137744E+01, 5.0138729650E+00, 2.8914908858E+00, 1.6260959725E+00, 8.6185264600E-01],
	[2.5490000000E+04, 1.4355567587E+01, 5.0138161165E+00, 2.8933114154E+00, 1.6267224942E+00, 8.6191327814E-01],
	[2.5495000000E+04, 1.4360004933E+01, 5.0137606216E+00, 2.8951327331E+00, 1.6273492268E+00, 8.6197388426E-01],
	[2.5500000000E+04, 1.4364455234E+01, 5.0137075225E+00, 2.8969548392E+00, 1.6279763505E+00, 8.6203446436E-01],
	[2.5505000000E+04, 1.4368906040E+01, 5.0136544344E+00, 2.8987777338E+00, 1.6286034544E+00, 8.6209501847E-01],
	[2.5510000000E+04, 1.4373357353E+01, 5.0136013573E+00, 2.9006014171E+00, 1.6292305382E+00, 8.6215554657E-01],
	[2.5515000000E+04, 1.4377809172E+01, 5.0135482911E+00, 2.9024258894E+00, 1.6298576020E+00, 8.6221604869E-01],
	[2.5520000000E+04, 1.4382261497E+01, 5.0134952358E+00, 2.9042511507E+00, 1.6304846456E+00, 8.6227652483E-01],
	[2.5525000000E+04, 1.4386714328E+01, 5.0134421916E+00, 2.9060772013E+00, 1.6311116689E+00, 8.6233697499E-01],
	[2.5530000000E+04, 1.4391167666E+01, 5.0133891582E+00, 2.9079040413E+00, 1.6317386718E+00, 8.6239739919E-01],
	[2.5535000000E+04, 1.4395621509E+01, 5.0133361359E+00, 2.9097316710E+00, 1.6323656542E+00, 8.6245779743E-01],
	[2.5540000000E+04, 1.4400075858E+01, 5.0132831244E+00, 2.9115600905E+00, 1.6329926161E+00, 8.6251816972E-01],
	[2.5545000000E+04, 1.4404530713E+01, 5.0132301239E+00, 2.9133893000E+00, 1.6336195573E+00, 8.6257851606E-01],
	[2.5550000000E+04, 1.4408986074E+01, 5.0131771344E+00, 2.9152192998E+00, 1.6342464777E+00, 8.6263883647E-01],
	[2.5555000000E+04, 1.4413441941E+01, 5.0131241557E+00, 2.9170500899E+00, 1.6348733772E+00, 8.6269913095E-01],
	[2.5560000000E+04, 1.4417898314E+01, 5.0130711880E+00, 2.9188816706E+00, 1.6355002558E+00, 8.6275939950E-01],
	[2.5565000000E+04, 1.4422355192E+01, 5.0130182312E+00, 2.9207140421E+00, 1.6361271133E+00, 8.6281964215E-01],
	[2.5570000000E+04, 1.4426812577E+01, 5.0129652853E+00, 2.9225472045E+00, 1.6367539496E+00, 8.6287985889E-01],
	[2.5575000000E+04, 1.4431270466E+01, 5.0129123504E+00, 2.9243811580E+00, 1.6373807647E+00, 8.6294004973E-01],
	[2.5580000000E+04, 1.4435728862E+01, 5.0128594263E+00, 2.9262159029E+00, 1.6380075584E+00, 8.6300021468E-01],
	[2.5585000000E+04, 1.4440187763E+01, 5.0128065131E+00, 2.9280514393E+00, 1.6386343307E+00, 8.6306035374E-01],
	[2.5590000000E+04, 1.4444647170E+01, 5.0127536109E+00, 2.9298877674E+00, 1.6392610814E+00, 8.6312046693E-01],
	[2.5595000000E+04, 1.4449107082E+01, 5.0127007195E+00, 2.9317248873E+00, 1.6398878104E+00, 8.6318055426E-01],
	[2.5600000000E+04, 1.4453567500E+01, 5.0126478390E+00, 2.9335627993E+00, 1.6405145177E+00, 8.6324061572E-01],
	[2.5605000000E+04, 1.4458028423E+01, 5.0125949695E+00, 2.9354015036E+00, 1.6411412032E+00, 8.6330065133E-01],
	[2.5610000000E+04, 1.4462489851E+01, 5.0125421107E+00, 2.9372410003E+00, 1.6417678666E+00, 8.6336066109E-01],
	[2.5615000000E+04, 1.4466951785E+01, 5.0124892629E+00, 2.9390812896E+00, 1.6423945081E+00, 8.6342064502E-01],
	[2.5620000000E+04, 1.4471414224E+01, 5.0124364259E+00, 2.9409223718E+00, 1.6430211274E+00, 8.6348060312E-01],
	[2.5625000000E+04, 1.4475877168E+01, 5.0123835999E+00, 2.9427642469E+00, 1.6436477244E+00, 8.6354053540E-01],
	[2.5630000000E+04, 1.4480340618E+01, 5.0123307846E+00, 2.9446069152E+00, 1.6442742991E+00, 8.6360044186E-01],
	[2.5635000000E+04, 1.4484804573E+01, 5.0122779802E+00, 2.9464503769E+00, 1.6449008514E+00, 8.6366032252E-01],
	[2.5640000000E+04, 1.4489269033E+01, 5.0122251867E+00, 2.9482946321E+00, 1.6455273812E+00, 8.6372017737E-01],
	[2.5645000000E+04, 1.4493733998E+01, 5.0121724041E+00, 2.9501396811E+00, 1.6461538883E+00, 8.6378000644E-01],
	[2.5650000000E+04, 1.4498199468E+01, 5.0121196322E+00, 2.9519855240E+00, 1.6467803727E+00, 8.6383980972E-01],
	[2.5655000000E+04, 1.4502665443E+01, 5.0120668713E+00, 2.9538321611E+00, 1.6474068342E+00, 8.6389958723E-01],
	[2.5660000000E+04, 1.4507131923E+01, 5.0120141211E+00, 2.9556795924E+00, 1.6480332728E+00, 8.6395933897E-01],
	[2.5665000000E+04, 1.4511598908E+01, 5.0119613818E+00, 2.9575278182E+00, 1.6486596885E+00, 8.6401906495E-01],
	[2.5670000000E+04, 1.4516066398E+01, 5.0119086533E+00, 2.9593768387E+00, 1.6492860810E+00, 8.6407876517E-01],
	[2.5675000000E+04, 1.4520534393E+01, 5.0118559357E+00, 2.9612266541E+00, 1.6499124502E+00, 8.6413843965E-01],
	[2.5680000000E+04, 1.4525002892E+01, 5.0118032288E+00, 2.9630772645E+00, 1.6505387962E+00, 8.6419808840E-01],
	[2.5685000000E+04, 1.4529471897E+01, 5.0117505328E+00, 2.9649286701E+00, 1.6511651188E+00, 8.6425771141E-01],
	[2.5690000000E+04, 1.4533941406E+01, 5.0116978476E+00, 2.9667808711E+00, 1.6517914178E+00, 8.6431730871E-01],
	[2.5695000000E+04, 1.4538411419E+01, 5.0116451732E+00, 2.9686338678E+00, 1.6524176933E+00, 8.6437688028E-01],
	[2.5700000000E+04, 1.4542881938E+01, 5.0115925096E+00, 2.9704876603E+00, 1.6530439450E+00, 8.6443642616E-01],
	[2.5705000000E+04, 1.4547352961E+01, 5.0115398568E+00, 2.9723422487E+00, 1.6536701730E+00, 8.6449594633E-01],
	[2.5710000000E+04, 1.4551824488E+01, 5.0114872147E+00, 2.9741976333E+00, 1.6542963770E+00, 8.6455544082E-01],
	[2.5715000000E+04, 1.4556296520E+01, 5.0114345835E+00, 2.9760538142E+00, 1.6549225571E+00, 8.6461490962E-01],
	[2.5720000000E+04, 1.4560769057E+01, 5.0113819631E+00, 2.9779107917E+00, 1.6555487131E+00, 8.6467435275E-01],
	[2.5725000000E+04, 1.4565242098E+01, 5.0113293534E+00, 2.9797685659E+00, 1.6561748449E+00, 8.6473377021E-01],
	[2.5730000000E+04, 1.4569715643E+01, 5.0112767545E+00, 2.9816271370E+00, 1.6568009524E+00, 8.6479316201E-01],
	[2.5735000000E+04, 1.4574189693E+01, 5.0112241664E+00, 2.9834865052E+00, 1.6574270356E+00, 8.6485252816E-01],
	[2.5740000000E+04, 1.4578664247E+01, 5.0111715891E+00, 2.9853466707E+00, 1.6580530943E+00, 8.6491186866E-01],
	[2.5745000000E+04, 1.4583139306E+01, 5.0111190225E+00, 2.9872076337E+00, 1.6586791284E+00, 8.6497118353E-01],
	[2.5750000000E+04, 1.4587614868E+01, 5.0110664667E+00, 2.9890693943E+00, 1.6593051378E+00, 8.6503047278E-01],
	[2.5755000000E+04, 1.4592090935E+01, 5.0110139216E+00, 2.9909319528E+00, 1.6599311225E+00, 8.6508973640E-01],
	[2.5760000000E+04, 1.4596567506E+01, 5.0109613873E+00, 2.9927953093E+00, 1.6605570824E+00, 8.6514897441E-01],
	[2.5765000000E+04, 1.4601044581E+01, 5.0109088638E+00, 2.9946594640E+00, 1.6611830173E+00, 8.6520818681E-01],
	[2.5770000000E+04, 1.4605522160E+01, 5.0108563509E+00, 2.9965244171E+00, 1.6618089271E+00, 8.6526737362E-01],
	[2.5775000000E+04, 1.4610000243E+01, 5.0108038489E+00, 2.9983901688E+00, 1.6624348118E+00, 8.6532653484E-01],
	[2.5780000000E+04, 1.4614478830E+01, 5.0107513575E+00, 3.0002567193E+00, 1.6630606713E+00, 8.6538567048E-01],
	[2.5785000000E+04, 1.4618957921E+01, 5.0106988769E+00, 3.0021240688E+00, 1.6636865054E+00, 8.6544478055E-01],
	[2.5790000000E+04, 1.4623437516E+01, 5.0106464070E+00, 3.0039922173E+00, 1.6643123141E+00, 8.6550386505E-01],
	[2.5795000000E+04, 1.4627917615E+01, 5.0105939478E+00, 3.0058611653E+00, 1.6649380972E+00, 8.6556292400E-01],
	[2.5800000000E+04, 1.4632398218E+01, 5.0105414993E+00, 3.0077309127E+00, 1.6655638548E+00, 8.6562195740E-01],
	[2.5805000000E+04, 1.4636879324E+01, 5.0104890616E+00, 3.0096014599E+00, 1.6661895866E+00, 8.6568096525E-01],
	[2.5810000000E+04, 1.4641360934E+01, 5.0104366346E+00, 3.0114728069E+00, 1.6668152926E+00, 8.6573994757E-01],
	[2.5815000000E+04, 1.4645843048E+01, 5.0103842182E+00, 3.0133449541E+00, 1.6674409727E+00, 8.6579890437E-01],
	[2.5820000000E+04, 1.4650325666E+01, 5.0103318126E+00, 3.0152179015E+00, 1.6680666268E+00, 8.6585783565E-01],
	[2.5825000000E+04, 1.4654808787E+01, 5.0102794176E+00, 3.0170916493E+00, 1.6686922548E+00, 8.6591674142E-01],
	[2.5830000000E+04, 1.4659292412E+01, 5.0102270334E+00, 3.0189661978E+00, 1.6693178566E+00, 8.6597562169E-01],
	[2.5835000000E+04, 1.4663776540E+01, 5.0101746598E+00, 3.0208415471E+00, 1.6699434321E+00, 8.6603447646E-01],
	[2.5840000000E+04, 1.4668261172E+01, 5.0101222969E+00, 3.0227176975E+00, 1.6705689813E+00, 8.6609330575E-01],
	[2.5845000000E+04, 1.4672746307E+01, 5.0100699447E+00, 3.0245946490E+00, 1.6711945039E+00, 8.6615210957E-01],
	[2.5850000000E+04, 1.4677231946E+01, 5.0100176032E+00, 3.0264724019E+00, 1.6718200000E+00, 8.6621088791E-01],
	[2.5855000000E+04, 1.4681718088E+01, 5.0099652724E+00, 3.0283509564E+00, 1.6724454694E+00, 8.6626964079E-01],
	[2.5860000000E+04, 1.4686204733E+01, 5.0099129522E+00, 3.0302303127E+00, 1.6730709120E+00, 8.6632836822E-01],
	[2.5865000000E+04, 1.4690691882E+01, 5.0098606426E+00, 3.0321104709E+00, 1.6736963278E+00, 8.6638707020E-01],
	[2.5870000000E+04, 1.4695179533E+01, 5.0098083438E+00, 3.0339914312E+00, 1.6743217166E+00, 8.6644574674E-01],
	[2.5875000000E+04, 1.4699667689E+01, 5.0097560555E+00, 3.0358731939E+00, 1.6749470784E+00, 8.6650439786E-01],
	[2.5880000000E+04, 1.4704156347E+01, 5.0097037780E+00, 3.0377557591E+00, 1.6755724130E+00, 8.6656302355E-01],
	[2.5885000000E+04, 1.4708645508E+01, 5.0096515110E+00, 3.0396391269E+00, 1.6761977204E+00, 8.6662162383E-01],
	[2.5890000000E+04, 1.4713135173E+01, 5.0095992547E+00, 3.0415232977E+00, 1.6768230005E+00, 8.6668019870E-01],
	[2.5895000000E+04, 1.4717625340E+01, 5.0095470091E+00, 3.0434082715E+00, 1.6774482531E+00, 8.6673874818E-01],
	[2.5900000000E+04, 1.4722116011E+01, 5.0094947741E+00, 3.0452940486E+00, 1.6780734782E+00, 8.6679727227E-01],
	[2.5905000000E+04, 1.4726612597E+01, 5.0094435707E+00, 3.0471806291E+00, 1.6786988607E+00, 8.6685577097E-01],
	[2.5910000000E+04, 1.4731123686E+01, 5.0093950170E+00, 3.0490680132E+00, 1.6793246942E+00, 8.6691424431E-01],
	[2.5915000000E+04, 1.4735635285E+01, 5.0093464732E+00, 3.0509562012E+00, 1.6799505006E+00, 8.6697269227E-01],
	[2.5920000000E+04, 1.4740147396E+01, 5.0092979392E+00, 3.0528451931E+00, 1.6805762798E+00, 8.6703111488E-01],
	[2.5925000000E+04, 1.4744660017E+01, 5.0092494151E+00, 3.0547349892E+00, 1.6812020317E+00, 8.6708951214E-01],
	[2.5930000000E+04, 1.4749173150E+01, 5.0092009008E+00, 3.0566255898E+00, 1.6818277562E+00, 8.6714788406E-01],
	[2.5935000000E+04, 1.4753686793E+01, 5.0091523963E+00, 3.0585169948E+00, 1.6824534533E+00, 8.6720623065E-01],
	[2.5940000000E+04, 1.4758200947E+01, 5.0091039016E+00, 3.0604092047E+00, 1.6830791228E+00, 8.6726455191E-01],
	[2.5945000000E+04, 1.4762715612E+01, 5.0090554168E+00, 3.0623022194E+00, 1.6837047647E+00, 8.6732284786E-01],
	[2.5950000000E+04, 1.4767230787E+01, 5.0090069417E+00, 3.0641960393E+00, 1.6843303788E+00, 8.6738111849E-01],
	[2.5955000000E+04, 1.4771746473E+01, 5.0089584765E+00, 3.0660906645E+00, 1.6849559651E+00, 8.6743936383E-01],
	[2.5960000000E+04, 1.4776262670E+01, 5.0089100210E+00, 3.0679860951E+00, 1.6855815234E+00, 8.6749758387E-01],
	[2.5965000000E+04, 1.4780779378E+01, 5.0088615754E+00, 3.0698823315E+00, 1.6862070537E+00, 8.6755577863E-01],
	[2.5970000000E+04, 1.4785296595E+01, 5.0088131396E+00, 3.0717793737E+00, 1.6868325559E+00, 8.6761394811E-01],
	[2.5975000000E+04, 1.4789814324E+01, 5.0087647135E+00, 3.0736772220E+00, 1.6874580298E+00, 8.6767209233E-01],
	[2.5980000000E+04, 1.4794332563E+01, 5.0087162973E+00, 3.0755758766E+00, 1.6880834755E+00, 8.6773021128E-01],
	[2.5985000000E+04, 1.4798851312E+01, 5.0086678908E+00, 3.0774753375E+00, 1.6887088927E+00, 8.6778830498E-01],
	[2.5990000000E+04, 1.4803370572E+01, 5.0086194941E+00, 3.0793756051E+00, 1.6893342815E+00, 8.6784637344E-01],
	[2.5995000000E+04, 1.4807890342E+01, 5.0085711072E+00, 3.0812766795E+00, 1.6899596416E+00, 8.6790441666E-01],
	[2.6000000000E+04, 1.4812410622E+01, 5.0085227301E+00, 3.0831785608E+00, 1.6905849731E+00, 8.6796243466E-01],
	[2.6005000000E+04, 1.4816931413E+01, 5.0084743627E+00, 3.0850812494E+00, 1.6912102758E+00, 8.6802042744E-01],
	[2.6010000000E+04, 1.4821452714E+01, 5.0084260051E+00, 3.0869847453E+00, 1.6918355496E+00, 8.6807839500E-01],
	[2.6015000000E+04, 1.4825974525E+01, 5.0083776572E+00, 3.0888890487E+00, 1.6924607944E+00, 8.6813633737E-01],
	[2.6020000000E+04, 1.4830496846E+01, 5.0083293192E+00, 3.0907941599E+00, 1.6930860102E+00, 8.6819425453E-01],
	[2.6025000000E+04, 1.4835019678E+01, 5.0082809908E+00, 3.0927000790E+00, 1.6937111968E+00, 8.6825214652E-01],
	[2.6030000000E+04, 1.4839543019E+01, 5.0082326722E+00, 3.0946068062E+00, 1.6943363542E+00, 8.6831001332E-01],
	[2.6035000000E+04, 1.4844066870E+01, 5.0081843634E+00, 3.0965143418E+00, 1.6949614823E+00, 8.6836785495E-01],
	[2.6040000000E+04, 1.4848591232E+01, 5.0081360643E+00, 3.0984226858E+00, 1.6955865809E+00, 8.6842567142E-01],
	[2.6045000000E+04, 1.4853116103E+01, 5.0080877750E+00, 3.1003318384E+00, 1.6962116500E+00, 8.6848346274E-01],
	[2.6050000000E+04, 1.4857641484E+01, 5.0080394953E+00, 3.1022418000E+00, 1.6968366895E+00, 8.6854122891E-01],
	[2.6055000000E+04, 1.4862167376E+01, 5.0079912255E+00, 3.1041525705E+00, 1.6974616993E+00, 8.6859896995E-01],
	[2.6060000000E+04, 1.4866693777E+01, 5.0079429653E+00, 3.1060641504E+00, 1.6980866793E+00, 8.6865668586E-01],
	[2.6065000000E+04, 1.4871220687E+01, 5.0078947149E+00, 3.1079765396E+00, 1.6987116293E+00, 8.6871437664E-01],
	[2.6070000000E+04, 1.4875748108E+01, 5.0078464742E+00, 3.1098897384E+00, 1.6993365494E+00, 8.6877204231E-01],
	[2.6075000000E+04, 1.4880276038E+01, 5.0077982432E+00, 3.1118037470E+00, 1.6999614395E+00, 8.6882968288E-01],
	[2.6080000000E+04, 1.4884804478E+01, 5.0077500219E+00, 3.1137185657E+00, 1.7005862993E+00, 8.6888729835E-01],
	[2.6085000000E+04, 1.4889333427E+01, 5.0077018103E+00, 3.1156341944E+00, 1.7012111289E+00, 8.6894488874E-01],
	[2.6090000000E+04, 1.4893862886E+01, 5.0076536084E+00, 3.1175506336E+00, 1.7018359281E+00, 8.6900245405E-01],
	[2.6095000000E+04, 1.4898392855E+01, 5.0076054162E+00, 3.1194678832E+00, 1.7024606969E+00, 8.6905999428E-01],
	[2.6100000000E+04, 1.4902923333E+01, 5.0075572338E+00, 3.1213859436E+00, 1.7030854351E+00, 8.6911750945E-01],
	[2.6105000000E+04, 1.4907454321E+01, 5.0075090610E+00, 3.1233048149E+00, 1.7037101428E+00, 8.6917499957E-01],
	[2.6110000000E+04, 1.4911985818E+01, 5.0074608979E+00, 3.1252244973E+00, 1.7043348196E+00, 8.6923246464E-01],
	[2.6115000000E+04, 1.4916517824E+01, 5.0074127445E+00, 3.1271449910E+00, 1.7049594657E+00, 8.6928990467E-01],
	[2.6120000000E+04, 1.4921050340E+01, 5.0073646007E+00, 3.1290662962E+00, 1.7055840809E+00, 8.6934731967E-01],
	[2.6125000000E+04, 1.4925583365E+01, 5.0073164667E+00, 3.1309884130E+00, 1.7062086650E+00, 8.6940470965E-01],
	[2.6130000000E+04, 1.4930116899E+01, 5.0072683423E+00, 3.1329113417E+00, 1.7068332181E+00, 8.6946207462E-01],
	[2.6135000000E+04, 1.4934650942E+01, 5.0072202276E+00, 3.1348350825E+00, 1.7074577400E+00, 8.6951941458E-01],
	[2.6140000000E+04, 1.4939185495E+01, 5.0071721226E+00, 3.1367596354E+00, 1.7080822306E+00, 8.6957672955E-01],
	[2.6145000000E+04, 1.4943720557E+01, 5.0071240272E+00, 3.1386850008E+00, 1.7087066898E+00, 8.6963401952E-01],
	[2.6150000000E+04, 1.4948256128E+01, 5.0070759415E+00, 3.1406111787E+00, 1.7093311176E+00, 8.6969128452E-01],
	[2.6155000000E+04, 1.4952792207E+01, 5.0070278654E+00, 3.1425381695E+00, 1.7099555138E+00, 8.6974852455E-01],
	[2.6160000000E+04, 1.4957328796E+01, 5.0069797990E+00, 3.1444659732E+00, 1.7105798784E+00, 8.6980573961E-01],
	[2.6165000000E+04, 1.4961865894E+01, 5.0069317422E+00, 3.1463945900E+00, 1.7112042113E+00, 8.6986292972E-01],
	[2.6170000000E+04, 1.4966403501E+01, 5.0068836951E+00, 3.1483240202E+00, 1.7118285123E+00, 8.6992009488E-01],
	[2.6175000000E+04, 1.4970941617E+01, 5.0068356576E+00, 3.1502542640E+00, 1.7124527814E+00, 8.6997723510E-01],
	[2.6180000000E+04, 1.4975480242E+01, 5.0067876298E+00, 3.1521853215E+00, 1.7130770185E+00, 8.7003435040E-01],
	[2.6185000000E+04, 1.4980019375E+01, 5.0067396116E+00, 3.1541171928E+00, 1.7137012235E+00, 8.7009144077E-01],
	[2.6190000000E+04, 1.4984559017E+01, 5.0066916030E+00, 3.1560498783E+00, 1.7143253964E+00, 8.7014850623E-01],
	[2.6195000000E+04, 1.4989099168E+01, 5.0066436040E+00, 3.1579833781E+00, 1.7149495369E+00, 8.7020554678E-01],
	[2.6200000000E+04, 1.4993639828E+01, 5.0065956147E+00, 3.1599176923E+00, 1.7155736451E+00, 8.7026256244E-01],
	[2.6205000000E+04, 1.4998180996E+01, 5.0065476350E+00, 3.1618528211E+00, 1.7161977208E+00, 8.7031955321E-01],
	[2.6210000000E+04, 1.5002722673E+01, 5.0064996649E+00, 3.1637887649E+00, 1.7168217639E+00, 8.7037651910E-01],
	[2.6215000000E+04, 1.5007264859E+01, 5.0064517044E+00, 3.1657255236E+00, 1.7174457744E+00, 8.7043346012E-01],
	[2.6220000000E+04, 1.5011807553E+01, 5.0064037535E+00, 3.1676630976E+00, 1.7180697522E+00, 8.7049037627E-01],
	[2.6225000000E+04, 1.5016350755E+01, 5.0063558122E+00, 3.1696014869E+00, 1.7186936971E+00, 8.7054726757E-01],
	[2.6230000000E+04, 1.5020894466E+01, 5.0063078805E+00, 3.1715406919E+00, 1.7193176092E+00, 8.7060413403E-01],
	[2.6235000000E+04, 1.5025438686E+01, 5.0062599584E+00, 3.1734807126E+00, 1.7199414882E+00, 8.7066097565E-01],
	[2.6240000000E+04, 1.5029983413E+01, 5.0062120459E+00, 3.1754215493E+00, 1.7205653341E+00, 8.7071779243E-01],
	[2.6245000000E+04, 1.5034528650E+01, 5.0061641430E+00, 3.1773632022E+00, 1.7211891468E+00, 8.7077458440E-01],
	[2.6250000000E+04, 1.5039074394E+01, 5.0061162496E+00, 3.1793056714E+00, 1.7218129263E+00, 8.7083135156E-01],
	[2.6255000000E+04, 1.5043620647E+01, 5.0060683659E+00, 3.1812489571E+00, 1.7224366723E+00, 8.7088809391E-01],
	[2.6260000000E+04, 1.5048167408E+01, 5.0060204917E+00, 3.1831930595E+00, 1.7230603850E+00, 8.7094481146E-01],
	[2.6265000000E+04, 1.5052714677E+01, 5.0059726271E+00, 3.1851379789E+00, 1.7236840640E+00, 8.7100150423E-01],
	[2.6270000000E+04, 1.5057262454E+01, 5.0059247720E+00, 3.1870837153E+00, 1.7243077095E+00, 8.7105817222E-01],
	[2.6275000000E+04, 1.5061810739E+01, 5.0058769266E+00, 3.1890302690E+00, 1.7249313212E+00, 8.7111481544E-01],
	[2.6280000000E+04, 1.5066359532E+01, 5.0058290906E+00, 3.1909776402E+00, 1.7255548990E+00, 8.7117143390E-01],
	[2.6285000000E+04, 1.5070908834E+01, 5.0057812643E+00, 3.1929258290E+00, 1.7261784430E+00, 8.7122802761E-01],
	[2.6290000000E+04, 1.5075458643E+01, 5.0057334475E+00, 3.1948748356E+00, 1.7268019530E+00, 8.7128459657E-01],
	[2.6295000000E+04, 1.5080008960E+01, 5.0056856402E+00, 3.1968246603E+00, 1.7274254288E+00, 8.7134114079E-01],
	[2.6300000000E+04, 1.5084559786E+01, 5.0056378425E+00, 3.1987753032E+00, 1.7280488705E+00, 8.7139766029E-01],
	[2.6305000000E+04, 1.5089111119E+01, 5.0055900544E+00, 3.2007267645E+00, 1.7286722779E+00, 8.7145415507E-01],
	[2.6310000000E+04, 1.5093662959E+01, 5.0055422757E+00, 3.2026790444E+00, 1.7292956510E+00, 8.7151062513E-01],
	[2.6315000000E+04, 1.5098215308E+01, 5.0054945066E+00, 3.2046321430E+00, 1.7299189896E+00, 8.7156707050E-01],
	[2.6320000000E+04, 1.5102768164E+01, 5.0054467471E+00, 3.2065860606E+00, 1.7305422937E+00, 8.7162349117E-01],
	[2.6325000000E+04, 1.5107338495E+01, 5.0054021485E+00, 3.2085407974E+00, 1.7311661629E+00, 8.7167988715E-01],
	[2.6330000000E+04, 1.5111911735E+01, 5.0053580033E+00, 3.2104963535E+00, 1.7317900826E+00, 8.7173625846E-01],
	[2.6335000000E+04, 1.5116485490E+01, 5.0053138669E+00, 3.2124527291E+00, 1.7324139683E+00, 8.7179260510E-01],
	[2.6340000000E+04, 1.5121059761E+01, 5.0052697392E+00, 3.2144099244E+00, 1.7330378198E+00, 8.7184892708E-01],
	[2.6345000000E+04, 1.5125634548E+01, 5.0052256203E+00, 3.2163679397E+00, 1.7336616370E+00, 8.7190522441E-01],
	[2.6350000000E+04, 1.5130209850E+01, 5.0051815102E+00, 3.2183267750E+00, 1.7342854198E+00, 8.7196149709E-01],
	[2.6355000000E+04, 1.5134785667E+01, 5.0051374089E+00, 3.2202864306E+00, 1.7349091682E+00, 8.7201774514E-01],
	[2.6360000000E+04, 1.5139362000E+01, 5.0050933163E+00, 3.2222469066E+00, 1.7355328820E+00, 8.7207396857E-01],
	[2.6365000000E+04, 1.5143938848E+01, 5.0050492324E+00, 3.2242082033E+00, 1.7361565612E+00, 8.7213016738E-01],
	[2.6370000000E+04, 1.5148516212E+01, 5.0050051573E+00, 3.2261703208E+00, 1.7367802057E+00, 8.7218634158E-01],
	[2.6375000000E+04, 1.5153094091E+01, 5.0049610909E+00, 3.2281332594E+00, 1.7374038153E+00, 8.7224249118E-01],
	[2.6380000000E+04, 1.5157672485E+01, 5.0049170333E+00, 3.2300970191E+00, 1.7380273901E+00, 8.7229861619E-01],
	[2.6385000000E+04, 1.5162251395E+01, 5.0048729844E+00, 3.2320616003E+00, 1.7386509299E+00, 8.7235471661E-01],
	[2.6390000000E+04, 1.5166830819E+01, 5.0048289443E+00, 3.2340270030E+00, 1.7392744346E+00, 8.7241079246E-01],
	[2.6395000000E+04, 1.5171410759E+01, 5.0047849128E+00, 3.2359932275E+00, 1.7398979041E+00, 8.7246684375E-01],
	[2.6400000000E+04, 1.5175991214E+01, 5.0047408901E+00, 3.2379602740E+00, 1.7405213384E+00, 8.7252287047E-01],
	[2.6405000000E+04, 1.5180572184E+01, 5.0046968762E+00, 3.2399281426E+00, 1.7411447373E+00, 8.7257887265E-01],
	[2.6410000000E+04, 1.5185153669E+01, 5.0046528709E+00, 3.2418968335E+00, 1.7417681008E+00, 8.7263485029E-01],
	[2.6415000000E+04, 1.5189735670E+01, 5.0046088744E+00, 3.2438663470E+00, 1.7423914287E+00, 8.7269080340E-01],
	[2.6420000000E+04, 1.5194318185E+01, 5.0045648866E+00, 3.2458366832E+00, 1.7430147211E+00, 8.7274673198E-01],
	[2.6425000000E+04, 1.5198901215E+01, 5.0045209075E+00, 3.2478078423E+00, 1.7436379778E+00, 8.7280263605E-01],
	[2.6430000000E+04, 1.5203484759E+01, 5.0044769371E+00, 3.2497798244E+00, 1.7442611986E+00, 8.7285851561E-01],
	[2.6435000000E+04, 1.5208068819E+01, 5.0044329754E+00, 3.2517526298E+00, 1.7448843836E+00, 8.7291437068E-01],
	[2.6440000000E+04, 1.5212653394E+01, 5.0043890224E+00, 3.2537262587E+00, 1.7455075327E+00, 8.7297020126E-01],
	[2.6445000000E+04, 1.5217238483E+01, 5.0043450781E+00, 3.2557007113E+00, 1.7461306456E+00, 8.7302600735E-01],
	[2.6450000000E+04, 1.5221824087E+01, 5.0043011425E+00, 3.2576759876E+00, 1.7467537225E+00, 8.7308178898E-01],
	[2.6455000000E+04, 1.5226410206E+01, 5.0042572155E+00, 3.2596520880E+00, 1.7473767631E+00, 8.7313754614E-01],
	[2.6460000000E+04, 1.5230996839E+01, 5.0042132973E+00, 3.2616290126E+00, 1.7479997674E+00, 8.7319327885E-01],
	[2.6465000000E+04, 1.5235583987E+01, 5.0041693878E+00, 3.2636067616E+00, 1.7486227353E+00, 8.7324898711E-01],
	[2.6470000000E+04, 1.5240171649E+01, 5.0041254869E+00, 3.2655853352E+00, 1.7492456667E+00, 8.7330467094E-01],
	[2.6475000000E+04, 1.5244759826E+01, 5.0040815947E+00, 3.2675647335E+00, 1.7498685615E+00, 8.7336033034E-01],
	[2.6480000000E+04, 1.5249348518E+01, 5.0040377112E+00, 3.2695449568E+00, 1.7504914196E+00, 8.7341596532E-01],
	[2.6485000000E+04, 1.5253937724E+01, 5.0039938364E+00, 3.2715260052E+00, 1.7511142410E+00, 8.7347157588E-01],
	[2.6490000000E+04, 1.5258527444E+01, 5.0039499702E+00, 3.2735078790E+00, 1.7517370256E+00, 8.7352716205E-01],
	[2.6495000000E+04, 1.5263117679E+01, 5.0039061127E+00, 3.2754905783E+00, 1.7523597732E+00, 8.7358272382E-01],
	[2.6500000000E+04, 1.5267708428E+01, 5.0038622638E+00, 3.2774741033E+00, 1.7529824838E+00, 8.7363826120E-01],
	[2.6505000000E+04, 1.5272299691E+01, 5.0038184236E+00, 3.2794584542E+00, 1.7536051573E+00, 8.7369377421E-01],
	[2.6510000000E+04, 1.5276891469E+01, 5.0037745921E+00, 3.2814436312E+00, 1.7542277936E+00, 8.7374926286E-01],
	[2.6515000000E+04, 1.5281483761E+01, 5.0037307692E+00, 3.2834296345E+00, 1.7548503926E+00, 8.7380472714E-01],
	[2.6520000000E+04, 1.5286076567E+01, 5.0036869549E+00, 3.2854164642E+00, 1.7554729543E+00, 8.7386016707E-01],
	[2.6525000000E+04, 1.5290669887E+01, 5.0036431493E+00, 3.2874041205E+00, 1.7560954785E+00, 8.7391558266E-01],
	[2.6530000000E+04, 1.5295263721E+01, 5.0035993523E+00, 3.2893926037E+00, 1.7567179651E+00, 8.7397097392E-01],
	[2.6535000000E+04, 1.5299858070E+01, 5.0035555640E+00, 3.2913819139E+00, 1.7573404142E+00, 8.7402634085E-01],
	[2.6540000000E+04, 1.5304452932E+01, 5.0035117843E+00, 3.2933720514E+00, 1.7579628255E+00, 8.7408168346E-01],
	[2.6545000000E+04, 1.5309048308E+01, 5.0034680133E+00, 3.2953630162E+00, 1.7585851990E+00, 8.7413700177E-01],
	[2.6550000000E+04, 1.5313644198E+01, 5.0034242508E+00, 3.2973548086E+00, 1.7592075346E+00, 8.7419229578E-01],
	[2.6555000000E+04, 1.5318240602E+01, 5.0033804970E+00, 3.2993474288E+00, 1.7598298322E+00, 8.7424756550E-01],
	[2.6560000000E+04, 1.5322837520E+01, 5.0033367518E+00, 3.3013408769E+00, 1.7604520918E+00, 8.7430281094E-01],
	[2.6565000000E+04, 1.5327434952E+01, 5.0032930152E+00, 3.3033351532E+00, 1.7610743132E+00, 8.7435803211E-01],
	[2.6570000000E+04, 1.5332032898E+01, 5.0032492873E+00, 3.3053302578E+00, 1.7616964964E+00, 8.7441322902E-01],
	[2.6575000000E+04, 1.5336631357E+01, 5.0032055679E+00, 3.3073261909E+00, 1.7623186413E+00, 8.7446840167E-01],
	[2.6580000000E+04, 1.5341230330E+01, 5.0031618572E+00, 3.3093229528E+00, 1.7629407477E+00, 8.7452355007E-01],
	[2.6585000000E+04, 1.5345829817E+01, 5.0031181550E+00, 3.3113205435E+00, 1.7635628157E+00, 8.7457867423E-01],
	[2.6590000000E+04, 1.5350429817E+01, 5.0030744615E+00, 3.3133189633E+00, 1.7641848450E+00, 8.7463377417E-01],
	[2.6595000000E+04, 1.5355030331E+01, 5.0030307765E+00, 3.3153182124E+00, 1.7648068357E+00, 8.7468884989E-01],
	[2.6600000000E+04, 1.5359631358E+01, 5.0029871002E+00, 3.3173182910E+00, 1.7654287877E+00, 8.7474390139E-01],
	[2.6605000000E+04, 1.5364232899E+01, 5.0029434324E+00, 3.3193191992E+00, 1.7660507008E+00, 8.7479892869E-01],
	[2.6610000000E+04, 1.5368834953E+01, 5.0028997732E+00, 3.3213209373E+00, 1.7666725749E+00, 8.7485393180E-01],
	[2.6615000000E+04, 1.5373437521E+01, 5.0028561226E+00, 3.3233235053E+00, 1.7672944101E+00, 8.7490891073E-01],
	[2.6620000000E+04, 1.5378040602E+01, 5.0028124806E+00, 3.3253269036E+00, 1.7679162061E+00, 8.7496386547E-01],
	[2.6625000000E+04, 1.5382644197E+01, 5.0027688472E+00, 3.3273311323E+00, 1.7685379630E+00, 8.7501879605E-01],
	[2.6630000000E+04, 1.5387248305E+01, 5.0027252223E+00, 3.3293361916E+00, 1.7691596806E+00, 8.7507370247E-01],
	[2.6635000000E+04, 1.5391852926E+01, 5.0026816060E+00, 3.3313420816E+00, 1.7697813588E+00, 8.7512858474E-01],
	[2.6640000000E+04, 1.5396458060E+01, 5.0026379983E+00, 3.3333488026E+00, 1.7704029975E+00, 8.7518344287E-01],
	[2.6645000000E+04, 1.5401063707E+01, 5.0025943992E+00, 3.3353563547E+00, 1.7710245968E+00, 8.7523827687E-01],
	[2.6650000000E+04, 1.5405669868E+01, 5.0025508086E+00, 3.3373647382E+00, 1.7716461564E+00, 8.7529308674E-01],
	[2.6655000000E+04, 1.5410276542E+01, 5.0025072265E+00, 3.3393739532E+00, 1.7722676763E+00, 8.7534787250E-01],
	[2.6660000000E+04, 1.5414883729E+01, 5.0024636530E+00, 3.3413840000E+00, 1.7728891565E+00, 8.7540263415E-01],
	[2.6665000000E+04, 1.5419491429E+01, 5.0024200881E+00, 3.3433948786E+00, 1.7735105967E+00, 8.7545737170E-01],
	[2.6670000000E+04, 1.5424099642E+01, 5.0023765317E+00, 3.3454065893E+00, 1.7741319970E+00, 8.7551208516E-01],
	[2.6675000000E+04, 1.5428708367E+01, 5.0023329839E+00, 3.3474191323E+00, 1.7747533572E+00, 8.7556677455E-01],
	[2.6680000000E+04, 1.5433317606E+01, 5.0022894446E+00, 3.3494325078E+00, 1.7753746774E+00, 8.7562143986E-01],
	[2.6685000000E+04, 1.5437927358E+01, 5.0022459138E+00, 3.3514467159E+00, 1.7759959572E+00, 8.7567608111E-01],
	[2.6690000000E+04, 1.5442537622E+01, 5.0022023915E+00, 3.3534617568E+00, 1.7766171968E+00, 8.7573069831E-01],
	[2.6695000000E+04, 1.5447148399E+01, 5.0021588778E+00, 3.3554776308E+00, 1.7772383960E+00, 8.7578529146E-01],
	[2.6700000000E+04, 1.5451759689E+01, 5.0021153727E+00, 3.3574943380E+00, 1.7778595548E+00, 8.7583986057E-01],
	[2.6705000000E+04, 1.5456371492E+01, 5.0020718760E+00, 3.3595118786E+00, 1.7784806729E+00, 8.7589440566E-01],
	[2.6710000000E+04, 1.5460983808E+01, 5.0020283879E+00, 3.3615302528E+00, 1.7791017505E+00, 8.7594892673E-01],
	[2.6715000000E+04, 1.5465596636E+01, 5.0019849083E+00, 3.3635494607E+00, 1.7797227873E+00, 8.7600342379E-01],
	[2.6720000000E+04, 1.5470209976E+01, 5.0019414372E+00, 3.3655695027E+00, 1.7803437833E+00, 8.7605789685E-01],
	[2.6725000000E+04, 1.5474823830E+01, 5.0018979746E+00, 3.3675903788E+00, 1.7809647383E+00, 8.7611234592E-01],
	[2.6730000000E+04, 1.5479438195E+01, 5.0018545205E+00, 3.3696120892E+00, 1.7815856525E+00, 8.7616677100E-01],
	[2.6735000000E+04, 1.5484053074E+01, 5.0018110750E+00, 3.3716346342E+00, 1.7822065255E+00, 8.7622117211E-01],
	[2.6740000000E+04, 1.5488668464E+01, 5.0017676379E+00, 3.3736580138E+00, 1.7828273574E+00, 8.7627554926E-01],
	[2.6745000000E+04, 1.5493286899E+01, 5.0017246727E+00, 3.3756822284E+00, 1.7834482405E+00, 8.7632990244E-01],
	[2.6750000000E+04, 1.5497922627E+01, 5.0016847855E+00, 3.3777072781E+00, 1.7840696953E+00, 8.7638423168E-01],
	[2.6755000000E+04, 1.5502558875E+01, 5.0016449060E+00, 3.3797331630E+00, 1.7846911093E+00, 8.7643853698E-01],
	[2.6760000000E+04, 1.5507195644E+01, 5.0016050344E+00, 3.3817598835E+00, 1.7853124826E+00, 8.7649281835E-01],
	[2.6765000000E+04, 1.5511832932E+01, 5.0015651705E+00, 3.3837874396E+00, 1.7859338150E+00, 8.7654707580E-01],
	[2.6770000000E+04, 1.5516470741E+01, 5.0015253143E+00, 3.3858158315E+00, 1.7865551065E+00, 8.7660130934E-01],
	[2.6775000000E+04, 1.5521109070E+01, 5.0014854660E+00, 3.3878450595E+00, 1.7871763569E+00, 8.7665551897E-01],
	[2.6780000000E+04, 1.5525747919E+01, 5.0014456253E+00, 3.3898751236E+00, 1.7877975662E+00, 8.7670970471E-01],
	[2.6785000000E+04, 1.5530387287E+01, 5.0014057925E+00, 3.3919060242E+00, 1.7884187343E+00, 8.7676386656E-01],
	[2.6790000000E+04, 1.5535027176E+01, 5.0013659674E+00, 3.3939377614E+00, 1.7890398611E+00, 8.7681800453E-01],
	[2.6795000000E+04, 1.5539667585E+01, 5.0013261500E+00, 3.3959703354E+00, 1.7896609466E+00, 8.7687211864E-01],
	[2.6800000000E+04, 1.5544308514E+01, 5.0012863404E+00, 3.3980037464E+00, 1.7902819905E+00, 8.7692620888E-01],
	[2.6805000000E+04, 1.5548949962E+01, 5.0012465385E+00, 3.4000379945E+00, 1.7909029929E+00, 8.7698027528E-01],
	[2.6810000000E+04, 1.5553591930E+01, 5.0012067444E+00, 3.4020730799E+00, 1.7915239537E+00, 8.7703431783E-01],
	[2.6815000000E+04, 1.5558234419E+01, 5.0011669580E+00, 3.4041090029E+00, 1.7921448728E+00, 8.7708833655E-01],
	[2.6820000000E+04, 1.5562877426E+01, 5.0011271793E+00, 3.4061457637E+00, 1.7927657501E+00, 8.7714233145E-01],
	[2.6825000000E+04, 1.5567520954E+01, 5.0010874084E+00, 3.4081833623E+00, 1.7933865855E+00, 8.7719630253E-01],
	[2.6830000000E+04, 1.5572165001E+01, 5.0010476452E+00, 3.4102217990E+00, 1.7940073789E+00, 8.7725024980E-01],
	[2.6835000000E+04, 1.5576809568E+01, 5.0010078898E+00, 3.4122610741E+00, 1.7946281303E+00, 8.7730417328E-01],
	[2.6840000000E+04, 1.5581454655E+01, 5.0009681420E+00, 3.4143011876E+00, 1.7952488396E+00, 8.7735807297E-01],
	[2.6845000000E+04, 1.5586100261E+01, 5.0009284020E+00, 3.4163421397E+00, 1.7958695066E+00, 8.7741194888E-01],
	[2.6850000000E+04, 1.5590746386E+01, 5.0008886697E+00, 3.4183839308E+00, 1.7964901314E+00, 8.7746580102E-01],
	[2.6855000000E+04, 1.5595393031E+01, 5.0008489451E+00, 3.4204265608E+00, 1.7971107137E+00, 8.7751962939E-01],
	[2.6860000000E+04, 1.5600040196E+01, 5.0008092282E+00, 3.4224700301E+00, 1.7977312536E+00, 8.7757343402E-01],
	[2.6865000000E+04, 1.5604687880E+01, 5.0007695190E+00, 3.4245143388E+00, 1.7983517510E+00, 8.7762721490E-01],
	[2.6870000000E+04, 1.5609336083E+01, 5.0007298175E+00, 3.4265594871E+00, 1.7989722057E+00, 8.7768097204E-01],
	[2.6875000000E+04, 1.5613984805E+01, 5.0006901237E+00, 3.4286054753E+00, 1.7995926177E+00, 8.7773470546E-01],
	[2.6880000000E+04, 1.5618634047E+01, 5.0006504377E+00, 3.4306523033E+00, 1.8002129869E+00, 8.7778841516E-01],
	[2.6885000000E+04, 1.5623283808E+01, 5.0006107593E+00, 3.4326999716E+00, 1.8008333133E+00, 8.7784210115E-01],
	[2.6890000000E+04, 1.5627934089E+01, 5.0005710886E+00, 3.4347484802E+00, 1.8014535966E+00, 8.7789576344E-01],
	[2.6895000000E+04, 1.5632584888E+01, 5.0005314256E+00, 3.4367978294E+00, 1.8020738370E+00, 8.7794940205E-01],
	[2.6900000000E+04, 1.5637236207E+01, 5.0004917703E+00, 3.4388480193E+00, 1.8026940341E+00, 8.7800301697E-01],
	[2.6905000000E+04, 1.5641888044E+01, 5.0004521227E+00, 3.4408990501E+00, 1.8033141881E+00, 8.7805660821E-01],
	[2.6910000000E+04, 1.5646540401E+01, 5.0004124827E+00, 3.4429509220E+00, 1.8039342988E+00, 8.7811017580E-01],
	[2.6915000000E+04, 1.5651193277E+01, 5.0003728505E+00, 3.4450036353E+00, 1.8045543661E+00, 8.7816371973E-01],
	[2.6920000000E+04, 1.5655846671E+01, 5.0003332259E+00, 3.4470571900E+00, 1.8051743900E+00, 8.7821724001E-01],
	[2.6925000000E+04, 1.5660500585E+01, 5.0002936090E+00, 3.4491115864E+00, 1.8057943703E+00, 8.7827073665E-01],
	[2.6930000000E+04, 1.5665155018E+01, 5.0002539997E+00, 3.4511668246E+00, 1.8064143069E+00, 8.7832420967E-01],
	[2.6935000000E+04, 1.5669809969E+01, 5.0002143982E+00, 3.4532229049E+00, 1.8070341999E+00, 8.7837765907E-01],
	[2.6940000000E+04, 1.5674465439E+01, 5.0001748043E+00, 3.4552798274E+00, 1.8076540491E+00, 8.7843108486E-01],
	[2.6945000000E+04, 1.5679121428E+01, 5.0001352180E+00, 3.4573375924E+00, 1.8082738544E+00, 8.7848448704E-01],
	[2.6950000000E+04, 1.5683777936E+01, 5.0000956394E+00, 3.4593962000E+00, 1.8088936158E+00, 8.7853786562E-01],
	[2.6955000000E+04, 1.5688434962E+01, 5.0000560685E+00, 3.4614556504E+00, 1.8095133331E+00, 8.7859122061E-01],
	[2.6960000000E+04, 1.5693092507E+01, 5.0000165052E+00, 3.4635159438E+00, 1.8101330063E+00, 8.7864455202E-01],
	[2.6965000000E+04, 1.5697750571E+01, 4.9999769496E+00, 3.4655770803E+00, 1.8107526353E+00, 8.7869785985E-01],
	[2.6970000000E+04, 1.5702409154E+01, 4.9999374016E+00, 3.4676390602E+00, 1.8113722200E+00, 8.7875114412E-01],
	[2.6975000000E+04, 1.5707068254E+01, 4.9998978612E+00, 3.4697018837E+00, 1.8119917603E+00, 8.7880440483E-01],
	[2.6980000000E+04, 1.5711727874E+01, 4.9998583285E+00, 3.4717655509E+00, 1.8126112562E+00, 8.7885764198E-01],
	[2.6985000000E+04, 1.5716388012E+01, 4.9998188035E+00, 3.4738300621E+00, 1.8132307076E+00, 8.7891085559E-01],
	[2.6990000000E+04, 1.5721048668E+01, 4.9997792860E+00, 3.4758954174E+00, 1.8138501144E+00, 8.7896404567E-01],
	[2.6995000000E+04, 1.5725709843E+01, 4.9997397762E+00, 3.4779616170E+00, 1.8144694764E+00, 8.7901721221E-01],
	[2.7000000000E+04, 1.5730371536E+01, 4.9997002741E+00, 3.4800286610E+00, 1.8150887937E+00, 8.7907035524E-01],
	[2.7005000000E+04, 1.5735033747E+01, 4.9996607795E+00, 3.4820965498E+00, 1.8157080662E+00, 8.7912347475E-01],
	[2.7010000000E+04, 1.5739696477E+01, 4.9996212926E+00, 3.4841652835E+00, 1.8163272937E+00, 8.7917657075E-01],
	[2.7015000000E+04, 1.5744359725E+01, 4.9995818133E+00, 3.4862348622E+00, 1.8169464761E+00, 8.7922964326E-01],
	[2.7020000000E+04, 1.5749023491E+01, 4.9995423416E+00, 3.4883052861E+00, 1.8175656135E+00, 8.7928269228E-01],
	[2.7025000000E+04, 1.5753687775E+01, 4.9995028776E+00, 3.4903765555E+00, 1.8181847057E+00, 8.7933571782E-01],
	[2.7030000000E+04, 1.5758352578E+01, 4.9994634211E+00, 3.4924486705E+00, 1.8188037526E+00, 8.7938871988E-01],
	[2.7035000000E+04, 1.5763017898E+01, 4.9994239723E+00, 3.4945216314E+00, 1.8194227542E+00, 8.7944169847E-01],
	[2.7040000000E+04, 1.5767683737E+01, 4.9993845311E+00, 3.4965954382E+00, 1.8200417104E+00, 8.7949465361E-01],
	[2.7045000000E+04, 1.5772350093E+01, 4.9993450974E+00, 3.4986700912E+00, 1.8206606210E+00, 8.7954758529E-01],
	[2.7050000000E+04, 1.5777016968E+01, 4.9993056714E+00, 3.5007455906E+00, 1.8212794861E+00, 8.7960049353E-01],
	[2.7055000000E+04, 1.5781684360E+01, 4.9992662530E+00, 3.5028219366E+00, 1.8218983055E+00, 8.7965337834E-01],
	[2.7060000000E+04, 1.5786352271E+01, 4.9992268421E+00, 3.5048991293E+00, 1.8225170792E+00, 8.7970623972E-01],
	[2.7065000000E+04, 1.5791020699E+01, 4.9991874389E+00, 3.5069771690E+00, 1.8231358070E+00, 8.7975907767E-01],
	[2.7070000000E+04, 1.5795689645E+01, 4.9991480432E+00, 3.5090560558E+00, 1.8237544889E+00, 8.7981189222E-01],
	[2.7075000000E+04, 1.5800359109E+01, 4.9991086551E+00, 3.5111357900E+00, 1.8243731248E+00, 8.7986468336E-01],
	[2.7080000000E+04, 1.5805029090E+01, 4.9990692747E+00, 3.5132163716E+00, 1.8249917146E+00, 8.7991745111E-01],
	[2.7085000000E+04, 1.5809699590E+01, 4.9990299018E+00, 3.5152978009E+00, 1.8256102583E+00, 8.7997019546E-01],
	[2.7090000000E+04, 1.5814370607E+01, 4.9989905364E+00, 3.5173800782E+00, 1.8262287557E+00, 8.8002291644E-01],
	[2.7095000000E+04, 1.5819042141E+01, 4.9989511787E+00, 3.5194632035E+00, 1.8268472069E+00, 8.8007561404E-01],
	[2.7100000000E+04, 1.5823714194E+01, 4.9989118285E+00, 3.5215471770E+00, 1.8274656116E+00, 8.8012828828E-01],
	[2.7105000000E+04, 1.5828386763E+01, 4.9988724859E+00, 3.5236319991E+00, 1.8280839698E+00, 8.8018093916E-01],
	[2.7110000000E+04, 1.5833059851E+01, 4.9988331508E+00, 3.5257176697E+00, 1.8287022815E+00, 8.8023356669E-01],
	[2.7115000000E+04, 1.5837733455E+01, 4.9987938233E+00, 3.5278041892E+00, 1.8293205466E+00, 8.8028617088E-01],
	[2.7120000000E+04, 1.5842407578E+01, 4.9987545034E+00, 3.5298915577E+00, 1.8299387649E+00, 8.8033875174E-01],
	[2.7125000000E+04, 1.5847082217E+01, 4.9987151911E+00, 3.5319797754E+00, 1.8305569365E+00, 8.8039130927E-01],
	[2.7130000000E+04, 1.5851757374E+01, 4.9986758862E+00, 3.5340688425E+00, 1.8311750612E+00, 8.8044384348E-01],
	[2.7135000000E+04, 1.5856433048E+01, 4.9986365890E+00, 3.5361587592E+00, 1.8317931389E+00, 8.8049635438E-01],
	[2.7140000000E+04, 1.5861109240E+01, 4.9985972993E+00, 3.5382495256E+00, 1.8324111695E+00, 8.8054884198E-01],
	[2.7145000000E+04, 1.5865785949E+01, 4.9985580171E+00, 3.5403411421E+00, 1.8330291531E+00, 8.8060130629E-01],
	[2.7150000000E+04, 1.5870463175E+01, 4.9985187425E+00, 3.5424336086E+00, 1.8336470894E+00, 8.8065374731E-01],
	[2.7155000000E+04, 1.5875140918E+01, 4.9984794754E+00, 3.5445269255E+00, 1.8342649785E+00, 8.8070616505E-01],
	[2.7160000000E+04, 1.5879819179E+01, 4.9984402159E+00, 3.5466210929E+00, 1.8348828202E+00, 8.8075855952E-01],
	[2.7165000000E+04, 1.5884497956E+01, 4.9984009639E+00, 3.5487161111E+00, 1.8355006145E+00, 8.8081093073E-01],
	[2.7170000000E+04, 1.5889177250E+01, 4.9983617194E+00, 3.5508119801E+00, 1.8361183612E+00, 8.8086327868E-01],
	[2.7175000000E+04, 1.5893857479E+01, 4.9983225576E+00, 3.5529087002E+00, 1.8367360761E+00, 8.8091560339E-01],
	[2.7180000000E+04, 1.5898557068E+01, 4.9982867994E+00, 3.5550062716E+00, 1.8373544539E+00, 8.8096790485E-01],
	[2.7185000000E+04, 1.5903257183E+01, 4.9982510480E+00, 3.5571046945E+00, 1.8379727847E+00, 8.8102018309E-01],
	[2.7190000000E+04, 1.5907957822E+01, 4.9982153035E+00, 3.5592039690E+00, 1.8385910683E+00, 8.8107243811E-01],
	[2.7195000000E+04, 1.5912658986E+01, 4.9981795658E+00, 3.5613040954E+00, 1.8392093046E+00, 8.8112466990E-01],
	[2.7200000000E+04, 1.5917360675E+01, 4.9981438350E+00, 3.5634050738E+00, 1.8398274937E+00, 8.8117687850E-01],
	[2.7205000000E+04, 1.5922062888E+01, 4.9981081109E+00, 3.5655069044E+00, 1.8404456355E+00, 8.8122906389E-01],
	[2.7210000000E+04, 1.5926765626E+01, 4.9980723937E+00, 3.5676095874E+00, 1.8410637297E+00, 8.8128122609E-01],
	[2.7215000000E+04, 1.5931468889E+01, 4.9980366833E+00, 3.5697131230E+00, 1.8416817764E+00, 8.8133336511E-01],
	[2.7220000000E+04, 1.5936172676E+01, 4.9980009797E+00, 3.5718175115E+00, 1.8422997756E+00, 8.8138548095E-01],
	[2.7225000000E+04, 1.5940876987E+01, 4.9979652830E+00, 3.5739227528E+00, 1.8429177270E+00, 8.8143757363E-01],
	[2.7230000000E+04, 1.5945581823E+01, 4.9979295930E+00, 3.5760288474E+00, 1.8435356306E+00, 8.8148964315E-01],
	[2.7235000000E+04, 1.5950287183E+01, 4.9978939099E+00, 3.5781357953E+00, 1.8441534864E+00, 8.8154168951E-01],
	[2.7240000000E+04, 1.5954993068E+01, 4.9978582335E+00, 3.5802435967E+00, 1.8447712943E+00, 8.8159371273E-01],
	[2.7245000000E+04, 1.5959699477E+01, 4.9978225640E+00, 3.5823522519E+00, 1.8453890542E+00, 8.8164571282E-01],
	[2.7250000000E+04, 1.5964406410E+01, 4.9977869012E+00, 3.5844617610E+00, 1.8460067660E+00, 8.8169768978E-01],
	[2.7255000000E+04, 1.5969113867E+01, 4.9977512453E+00, 3.5865721242E+00, 1.8466244296E+00, 8.8174964362E-01],
	[2.7260000000E+04, 1.5973821849E+01, 4.9977155961E+00, 3.5886833417E+00, 1.8472420450E+00, 8.8180157435E-01],
	[2.7265000000E+04, 1.5978530355E+01, 4.9976799538E+00, 3.5907954137E+00, 1.8478596120E+00, 8.8185348197E-01],
	[2.7270000000E+04, 1.5983239384E+01, 4.9976443182E+00, 3.5929083403E+00, 1.8484771307E+00, 8.8190536651E-01],
	[2.7275000000E+04, 1.5987948938E+01, 4.9976086894E+00, 3.5950221218E+00, 1.8490946008E+00, 8.8195722795E-01],
	[2.7280000000E+04, 1.5992659016E+01, 4.9975730674E+00, 3.5971367584E+00, 1.8497120224E+00, 8.8200906631E-01],
	[2.7285000000E+04, 1.5997369618E+01, 4.9975374522E+00, 3.5992522502E+00, 1.8503293954E+00, 8.8206088161E-01],
	[2.7290000000E+04, 1.6002080744E+01, 4.9975018438E+00, 3.6013685974E+00, 1.8509467197E+00, 8.8211267384E-01],
	[2.7295000000E+04, 1.6006792394E+01, 4.9974662421E+00, 3.6034858002E+00, 1.8515639952E+00, 8.8216444301E-01],
	[2.7300000000E+04, 1.6011504568E+01, 4.9974306472E+00, 3.6056038589E+00, 1.8521812218E+00, 8.8221618914E-01],
	[2.7305000000E+04, 1.6016217266E+01, 4.9973950591E+00, 3.6077227735E+00, 1.8527983994E+00, 8.8226791223E-01],
	[2.7310000000E+04, 1.6020930487E+01, 4.9973594778E+00, 3.6098425443E+00, 1.8534155280E+00, 8.8231961228E-01],
	[2.7315000000E+04, 1.6025644233E+01, 4.9973239032E+00, 3.6119631715E+00, 1.8540326075E+00, 8.8237128932E-01],
	[2.7320000000E+04, 1.6030358502E+01, 4.9972883354E+00, 3.6140846552E+00, 1.8546496379E+00, 8.8242294334E-01],
	[2.7325000000E+04, 1.6035073294E+01, 4.9972527743E+00, 3.6162069957E+00, 1.8552666190E+00, 8.8247457435E-01],
	[2.7330000000E+04, 1.6039788611E+01, 4.9972172200E+00, 3.6183301931E+00, 1.8558835507E+00, 8.8252618237E-01],
	[2.7335000000E+04, 1.6044504451E+01, 4.9971816725E+00, 3.6204542477E+00, 1.8565004330E+00, 8.8257776739E-01],
	[2.7340000000E+04, 1.6049220815E+01, 4.9971461317E+00, 3.6225791595E+00, 1.8571172658E+00, 8.8262932943E-01],
	[2.7345000000E+04, 1.6053937702E+01, 4.9971105977E+00, 3.6247049289E+00, 1.8577340491E+00, 8.8268086850E-01],
	[2.7350000000E+04, 1.6058655113E+01, 4.9970750704E+00, 3.6268315560E+00, 1.8583507827E+00, 8.8273238460E-01],
	[2.7355000000E+04, 1.6063373047E+01, 4.9970395499E+00, 3.6289590409E+00, 1.8589674666E+00, 8.8278387774E-01],
	[2.7360000000E+04, 1.6068091504E+01, 4.9970040361E+00, 3.6310873839E+00, 1.8595841007E+00, 8.8283534794E-01],
	[2.7365000000E+04, 1.6072810485E+01, 4.9969685291E+00, 3.6332165852E+00, 1.8602006848E+00, 8.8288679519E-01],
	[2.7370000000E+04, 1.6077529990E+01, 4.9969330288E+00, 3.6353466449E+00, 1.8608172191E+00, 8.8293821950E-01],
	[2.7375000000E+04, 1.6082250018E+01, 4.9968975352E+00, 3.6374775632E+00, 1.8614337033E+00, 8.8298962089E-01],
	[2.7380000000E+04, 1.6086970569E+01, 4.9968620484E+00, 3.6396093404E+00, 1.8620501374E+00, 8.8304099937E-01],
	[2.7385000000E+04, 1.6091691643E+01, 4.9968265683E+00, 3.6417419765E+00, 1.8626665212E+00, 8.8309235493E-01],
	[2.7390000000E+04, 1.6096413241E+01, 4.9967910949E+00, 3.6438766082E+00, 1.8632831520E+00, 8.8314368759E-01],
	[2.7395000000E+04, 1.6101135361E+01, 4.9967556282E+00, 3.6460124212E+00, 1.8638998162E+00, 8.8319499736E-01],
	[2.7400000000E+04, 1.6105858005E+01, 4.9967201683E+00, 3.6481490952E+00, 1.8645164300E+00, 8.8324628424E-01],
	[2.7405000000E+04, 1.6110581172E+01, 4.9966847151E+00, 3.6502866305E+00, 1.8651329933E+00, 8.8329754825E-01],
	[2.7410000000E+04, 1.6115304862E+01, 4.9966492686E+00, 3.6524250272E+00, 1.8657495060E+00, 8.8334878939E-01],
	[2.7415000000E+04, 1.6120029075E+01, 4.9966138289E+00, 3.6545642856E+00, 1.8663659681E+00, 8.8340000767E-01],
	[2.7420000000E+04, 1.6124753811E+01, 4.9965783958E+00, 3.6567044059E+00, 1.8669823795E+00, 8.8345120309E-01],
	[2.7425000000E+04, 1.6129479070E+01, 4.9965429695E+00, 3.6588453882E+00, 1.8675987400E+00, 8.8350237567E-01],
	[2.7430000000E+04, 1.6134204852E+01, 4.9965075499E+00, 3.6609872327E+00, 1.8682150497E+00, 8.8355352541E-01],
	[2.7435000000E+04, 1.6138931157E+01, 4.9964721369E+00, 3.6631299396E+00, 1.8688313084E+00, 8.8360465233E-01],
	[2.7440000000E+04, 1.6143657985E+01, 4.9964367307E+00, 3.6652735091E+00, 1.8694475161E+00, 8.8365575642E-01],
	[2.7445000000E+04, 1.6148385335E+01, 4.9964013312E+00, 3.6674179415E+00, 1.8700636727E+00, 8.8370683771E-01],
	[2.7450000000E+04, 1.6153113209E+01, 4.9963659384E+00, 3.6695632368E+00, 1.8706797781E+00, 8.8375789619E-01],
	[2.7455000000E+04, 1.6157841605E+01, 4.9963305523E+00, 3.6717093952E+00, 1.8712958322E+00, 8.8380893187E-01],
	[2.7460000000E+04, 1.6162570523E+01, 4.9962951728E+00, 3.6738564171E+00, 1.8719118350E+00, 8.8385994477E-01],
	[2.7465000000E+04, 1.6167299965E+01, 4.9962598001E+00, 3.6760043025E+00, 1.8725277864E+00, 8.8391093488E-01],
	[2.7470000000E+04, 1.6172029929E+01, 4.9962244341E+00, 3.6781530516E+00, 1.8731436863E+00, 8.8396190223E-01],
	[2.7475000000E+04, 1.6176760415E+01, 4.9961890747E+00, 3.6803026647E+00, 1.8737595346E+00, 8.8401284682E-01],
	[2.7480000000E+04, 1.6181491424E+01, 4.9961537220E+00, 3.6824531418E+00, 1.8743753313E+00, 8.8406376865E-01],
	[2.7485000000E+04, 1.6186222956E+01, 4.9961183760E+00, 3.6846044833E+00, 1.8749910762E+00, 8.8411466773E-01],
	[2.7490000000E+04, 1.6190955010E+01, 4.9960830367E+00, 3.6867566893E+00, 1.8756067694E+00, 8.8416554407E-01],
	[2.7495000000E+04, 1.6195687587E+01, 4.9960477041E+00, 3.6889097600E+00, 1.8762224107E+00, 8.8421639769E-01],
	[2.7500000000E+04, 1.6200420686E+01, 4.9960123781E+00, 3.6910636955E+00, 1.8768380000E+00, 8.8426722858E-01],
	[2.7505000000E+04, 1.6205154307E+01, 4.9959770589E+00, 3.6932184961E+00, 1.8774535374E+00, 8.8431803676E-01],
	[2.7510000000E+04, 1.6209888450E+01, 4.9959417462E+00, 3.6953741620E+00, 1.8780690226E+00, 8.8436882224E-01],
	[2.7515000000E+04, 1.6214623116E+01, 4.9959064403E+00, 3.6975306933E+00, 1.8786844556E+00, 8.8441958502E-01],
	[2.7520000000E+04, 1.6219358304E+01, 4.9958711410E+00, 3.6996880903E+00, 1.8792998364E+00, 8.8447032511E-01],
	[2.7525000000E+04, 1.6224094015E+01, 4.9958358484E+00, 3.7018463531E+00, 1.8799151649E+00, 8.8452104252E-01],
	[2.7530000000E+04, 1.6228830247E+01, 4.9958005624E+00, 3.7040054819E+00, 1.8805304409E+00, 8.8457173725E-01],
	[2.7535000000E+04, 1.6233567002E+01, 4.9957652831E+00, 3.7061654769E+00, 1.8811456645E+00, 8.8462240932E-01],
	[2.7540000000E+04, 1.6238304279E+01, 4.9957300104E+00, 3.7083263383E+00, 1.8817608356E+00, 8.8467305874E-01],
	[2.7545000000E+04, 1.6243042077E+01, 4.9956947444E+00, 3.7104880663E+00, 1.8823759540E+00, 8.8472368551E-01],
	[2.7550000000E+04, 1.6247780398E+01, 4.9956594851E+00, 3.7126506611E+00, 1.8829910197E+00, 8.8477428964E-01],
	[2.7555000000E+04, 1.6252519241E+01, 4.9956242324E+00, 3.7148141228E+00, 1.8836060326E+00, 8.8482487114E-01],
	[2.7560000000E+04, 1.6257258606E+01, 4.9955889863E+00, 3.7169784517E+00, 1.8842209927E+00, 8.8487543002E-01],
	[2.7565000000E+04, 1.6261998492E+01, 4.9955537469E+00, 3.7191436479E+00, 1.8848358998E+00, 8.8492596628E-01],
	[2.7570000000E+04, 1.6266738901E+01, 4.9955185141E+00, 3.7213097117E+00, 1.8854507539E+00, 8.8497647993E-01],
	[2.7575000000E+04, 1.6271479831E+01, 4.9954832880E+00, 3.7234766432E+00, 1.8860655550E+00, 8.8502697099E-01],
	[2.7580000000E+04, 1.6276221284E+01, 4.9954480685E+00, 3.7256444426E+00, 1.8866803028E+00, 8.8507743946E-01],
	[2.7585000000E+04, 1.6280963258E+01, 4.9954128556E+00, 3.7278131101E+00, 1.8872949975E+00, 8.8512788534E-01],
	[2.7590000000E+04, 1.6285705753E+01, 4.9953776494E+00, 3.7299826459E+00, 1.8879096389E+00, 8.8517830866E-01],
	[2.7595000000E+04, 1.6290448771E+01, 4.9953424498E+00, 3.7321530501E+00, 1.8885242268E+00, 8.8522870940E-01],
	[2.7600000000E+04, 1.6295192310E+01, 4.9953072568E+00, 3.7343243231E+00, 1.8891387614E+00, 8.8527908760E-01],
	[2.7605000000E+04, 1.6299936370E+01, 4.9952720704E+00, 3.7364964649E+00, 1.8897532423E+00, 8.8532944324E-01],
	[2.7610000000E+04, 1.6304680952E+01, 4.9952368907E+00, 3.7386694758E+00, 1.8903676697E+00, 8.8537977634E-01],
	[2.7615000000E+04, 1.6309436157E+01, 4.9952035113E+00, 3.7408433559E+00, 1.8909824363E+00, 8.8543008691E-01],
	[2.7620000000E+04, 1.6314200997E+01, 4.9951717553E+00, 3.7430181054E+00, 1.8915975038E+00, 8.8548037496E-01],
	[2.7625000000E+04, 1.6318966366E+01, 4.9951400052E+00, 3.7451937246E+00, 1.8922125182E+00, 8.8553064049E-01],
	[2.7630000000E+04, 1.6323732263E+01, 4.9951082611E+00, 3.7473702136E+00, 1.8928274793E+00, 8.8558088352E-01],
	[2.7635000000E+04, 1.6328498690E+01, 4.9950765229E+00, 3.7495475726E+00, 1.8934423872E+00, 8.8563110405E-01],
	[2.7640000000E+04, 1.6333265646E+01, 4.9950447906E+00, 3.7517258017E+00, 1.8940572418E+00, 8.8568130209E-01],
	[2.7645000000E+04, 1.6338033132E+01, 4.9950130643E+00, 3.7539049013E+00, 1.8946720428E+00, 8.8573147764E-01],
	[2.7650000000E+04, 1.6342801146E+01, 4.9949813440E+00, 3.7560848714E+00, 1.8952867904E+00, 8.8578163073E-01],
	[2.7655000000E+04, 1.6347569689E+01, 4.9949496296E+00, 3.7582657123E+00, 1.8959014844E+00, 8.8583176134E-01],
	[2.7660000000E+04, 1.6352338761E+01, 4.9949179211E+00, 3.7604474241E+00, 1.8965161248E+00, 8.8588186950E-01],
	[2.7665000000E+04, 1.6357108362E+01, 4.9948862185E+00, 3.7626300071E+00, 1.8971307114E+00, 8.8593195522E-01],
	[2.7670000000E+04, 1.6361878491E+01, 4.9948545219E+00, 3.7648134614E+00, 1.8977452442E+00, 8.8598201849E-01],
	[2.7675000000E+04, 1.6366649150E+01, 4.9948228312E+00, 3.7669977872E+00, 1.8983597231E+00, 8.8603205933E-01],
	[2.7680000000E+04, 1.6371420337E+01, 4.9947911464E+00, 3.7691829848E+00, 1.8989741481E+00, 8.8608207774E-01],
	[2.7685000000E+04, 1.6376192053E+01, 4.9947594676E+00, 3.7713690542E+00, 1.8995885190E+00, 8.8613207375E-01],
	[2.7690000000E+04, 1.6380964298E+01, 4.9947277946E+00, 3.7735559958E+00, 1.9002028359E+00, 8.8618204734E-01],
	[2.7695000000E+04, 1.6385737071E+01, 4.9946961276E+00, 3.7757438096E+00, 1.9008170985E+00, 8.8623199854E-01],
	[2.7700000000E+04, 1.6390510374E+01, 4.9946644665E+00, 3.7779324959E+00, 1.9014313070E+00, 8.8628192734E-01],
	[2.7705000000E+04, 1.6395284204E+01, 4.9946328113E+00, 3.7801220548E+00, 1.9020454611E+00, 8.8633183377E-01],
	[2.7710000000E+04, 1.6400058563E+01, 4.9946011621E+00, 3.7823124866E+00, 1.9026595608E+00, 8.8638171782E-01],
	[2.7715000000E+04, 1.6404833451E+01, 4.9945695187E+00, 3.7845037914E+00, 1.9032736060E+00, 8.8643157950E-01],
	[2.7720000000E+04, 1.6409608867E+01, 4.9945378813E+00, 3.7866959695E+00, 1.9038875967E+00, 8.8648141883E-01],
	[2.7725000000E+04, 1.6414384812E+01, 4.9945062497E+00, 3.7888890210E+00, 1.9045015328E+00, 8.8653123582E-01],
	[2.7730000000E+04, 1.6419161285E+01, 4.9944746241E+00, 3.7910829461E+00, 1.9051154142E+00, 8.8658103046E-01],
	[2.7735000000E+04, 1.6423938287E+01, 4.9944430044E+00, 3.7932777450E+00, 1.9057292408E+00, 8.8663080277E-01],
	[2.7740000000E+04, 1.6428715817E+01, 4.9944113906E+00, 3.7954734178E+00, 1.9063430126E+00, 8.8668055275E-01],
	[2.7745000000E+04, 1.6433493875E+01, 4.9943797826E+00, 3.7976699649E+00, 1.9069567295E+00, 8.8673028043E-01],
	[2.7750000000E+04, 1.6438272461E+01, 4.9943481806E+00, 3.7998673863E+00, 1.9075703915E+00, 8.8677998579E-01],
	[2.7755000000E+04, 1.6443051576E+01, 4.9943165844E+00, 3.8020656823E+00, 1.9081839983E+00, 8.8682966886E-01],
	[2.7760000000E+04, 1.6447831219E+01, 4.9942849942E+00, 3.8042648531E+00, 1.9087975500E+00, 8.8687932964E-01],
	[2.7765000000E+04, 1.6452611390E+01, 4.9942534098E+00, 3.8064648988E+00, 1.9094110466E+00, 8.8692896814E-01],
	[2.7770000000E+04, 1.6457392089E+01, 4.9942218313E+00, 3.8086658196E+00, 1.9100244878E+00, 8.8697858436E-01],
	[2.7775000000E+04, 1.6462173316E+01, 4.9941902587E+00, 3.8108676157E+00, 1.9106378738E+00, 8.8702817832E-01],
	[2.7780000000E+04, 1.6466955071E+01, 4.9941586920E+00, 3.8130702874E+00, 1.9112512042E+00, 8.8707775003E-01],
	[2.7785000000E+04, 1.6471737354E+01, 4.9941271312E+00, 3.8152738347E+00, 1.9118644793E+00, 8.8712729948E-01],
	[2.7790000000E+04, 1.6476520165E+01, 4.9940955763E+00, 3.8174782579E+00, 1.9124776987E+00, 8.8717682670E-01],
	[2.7795000000E+04, 1.6481303505E+01, 4.9940640272E+00, 3.8196835573E+00, 1.9130908625E+00, 8.8722633169E-01],
	[2.7800000000E+04, 1.6486087372E+01, 4.9940324840E+00, 3.8218897328E+00, 1.9137039706E+00, 8.8727581445E-01],
	[2.7805000000E+04, 1.6490871767E+01, 4.9940009467E+00, 3.8240967849E+00, 1.9143170229E+00, 8.8732527500E-01],
	[2.7810000000E+04, 1.6495656689E+01, 4.9939694152E+00, 3.8263047136E+00, 1.9149300194E+00, 8.8737471335E-01],
	[2.7815000000E+04, 1.6500442140E+01, 4.9939378896E+00, 3.8285135191E+00, 1.9155429599E+00, 8.8742412950E-01],
	[2.7820000000E+04, 1.6505228118E+01, 4.9939063699E+00, 3.8307232017E+00, 1.9161558445E+00, 8.8747352346E-01],
	[2.7825000000E+04, 1.6510014624E+01, 4.9938748560E+00, 3.8329337615E+00, 1.9167686729E+00, 8.8752289524E-01],
	[2.7830000000E+04, 1.6514801658E+01, 4.9938433480E+00, 3.8351451987E+00, 1.9173814453E+00, 8.8757224485E-01],
	[2.7835000000E+04, 1.6519589219E+01, 4.9938118459E+00, 3.8373575135E+00, 1.9179941614E+00, 8.8762157229E-01],
	[2.7840000000E+04, 1.6524377308E+01, 4.9937803496E+00, 3.8395707061E+00, 1.9186068212E+00, 8.8767087758E-01],
	[2.7845000000E+04, 1.6529165924E+01, 4.9937488592E+00, 3.8417847767E+00, 1.9192194247E+00, 8.8772016073E-01],
	[2.7850000000E+04, 1.6533955068E+01, 4.9937173746E+00, 3.8439997254E+00, 1.9198319717E+00, 8.8776942173E-01],
	[2.7855000000E+04, 1.6538744740E+01, 4.9936858958E+00, 3.8462155526E+00, 1.9204444623E+00, 8.8781866061E-01],
	[2.7860000000E+04, 1.6543534939E+01, 4.9936544230E+00, 3.8484322582E+00, 1.9210568962E+00, 8.8786787737E-01],
	[2.7865000000E+04, 1.6548325665E+01, 4.9936229559E+00, 3.8506498426E+00, 1.9216692736E+00, 8.8791707201E-01],
	[2.7870000000E+04, 1.6553116919E+01, 4.9935914947E+00, 3.8528683060E+00, 1.9222815942E+00, 8.8796624455E-01],
	[2.7875000000E+04, 1.6557908700E+01, 4.9935600394E+00, 3.8550876484E+00, 1.9228938580E+00, 8.8801539499E-01],
	[2.7880000000E+04, 1.6562701008E+01, 4.9935285899E+00, 3.8573078702E+00, 1.9235060649E+00, 8.8806452335E-01],
	[2.7885000000E+04, 1.6567493844E+01, 4.9934971462E+00, 3.8595289715E+00, 1.9241182150E+00, 8.8811362963E-01],
	[2.7890000000E+04, 1.6572287207E+01, 4.9934657084E+00, 3.8617509525E+00, 1.9247303080E+00, 8.8816271384E-01],
	[2.7895000000E+04, 1.6577081097E+01, 4.9934342764E+00, 3.8639738133E+00, 1.9253423439E+00, 8.8821177598E-01],
	[2.7900000000E+04, 1.6581875514E+01, 4.9934028502E+00, 3.8661975543E+00, 1.9259543227E+00, 8.8826081607E-01],
	[2.7905000000E+04, 1.6586670459E+01, 4.9933714299E+00, 3.8684221754E+00, 1.9265662443E+00, 8.8830983412E-01],
	[2.7910000000E+04, 1.6591465930E+01, 4.9933400154E+00, 3.8706476771E+00, 1.9271781086E+00, 8.8835883013E-01],
	[2.7915000000E+04, 1.6596261929E+01, 4.9933086067E+00, 3.8728740594E+00, 1.9277899156E+00, 8.8840780412E-01],
	[2.7920000000E+04, 1.6601058455E+01, 4.9932772038E+00, 3.8751013225E+00, 1.9284016651E+00, 8.8845675608E-01],
	[2.7925000000E+04, 1.6605855507E+01, 4.9932458068E+00, 3.8773294667E+00, 1.9290133571E+00, 8.8850568604E-01],
	[2.7930000000E+04, 1.6610653087E+01, 4.9932144155E+00, 3.8795584920E+00, 1.9296249915E+00, 8.8855459399E-01],
	[2.7935000000E+04, 1.6615451193E+01, 4.9931830301E+00, 3.8817883988E+00, 1.9302365683E+00, 8.8860347994E-01],
	[2.7940000000E+04, 1.6620249826E+01, 4.9931516505E+00, 3.8840191872E+00, 1.9308480874E+00, 8.8865234392E-01],
	[2.7945000000E+04, 1.6625048987E+01, 4.9931202767E+00, 3.8862508573E+00, 1.9314595487E+00, 8.8870118591E-01],
	[2.7950000000E+04, 1.6629848673E+01, 4.9930889088E+00, 3.8884834095E+00, 1.9320709521E+00, 8.8875000594E-01],
	[2.7955000000E+04, 1.6634648887E+01, 4.9930575466E+00, 3.8907168438E+00, 1.9326822976E+00, 8.8879880401E-01],
	[2.7960000000E+04, 1.6639449628E+01, 4.9930261902E+00, 3.8929511604E+00, 1.9332935851E+00, 8.8884758012E-01],
	[2.7965000000E+04, 1.6644250895E+01, 4.9929948397E+00, 3.8951863596E+00, 1.9339048146E+00, 8.8889633430E-01],
	[2.7970000000E+04, 1.6649052689E+01, 4.9929634949E+00, 3.8974224416E+00, 1.9345159859E+00, 8.8894506653E-01],
	[2.7975000000E+04, 1.6653855009E+01, 4.9929321560E+00, 3.8996594064E+00, 1.9351270990E+00, 8.8899377685E-01],
	[2.7980000000E+04, 1.6658657856E+01, 4.9929008228E+00, 3.9018972544E+00, 1.9357381538E+00, 8.8904246524E-01],
	[2.7985000000E+04, 1.6663461230E+01, 4.9928694955E+00, 3.9041359857E+00, 1.9363491503E+00, 8.8909113173E-01],
	[2.7990000000E+04, 1.6668265130E+01, 4.9928381739E+00, 3.9063756005E+00, 1.9369600884E+00, 8.8913977632E-01],
	[2.7995000000E+04, 1.6673069556E+01, 4.9928068581E+00, 3.9086160990E+00, 1.9375709679E+00, 8.8918839901E-01],
	[2.8000000000E+04, 1.6677874509E+01, 4.9927755481E+00, 3.9108574813E+00, 1.9381817889E+00, 8.8923699982E-01],
	[2.8005000000E+04, 1.6682679988E+01, 4.9927442439E+00, 3.9130997478E+00, 1.9387925513E+00, 8.8928557876E-01],
	[2.8010000000E+04, 1.6687485994E+01, 4.9927129455E+00, 3.9153428985E+00, 1.9394032550E+00, 8.8933413583E-01],
	[2.8015000000E+04, 1.6692292526E+01, 4.9926816529E+00, 3.9175869336E+00, 1.9400138999E+00, 8.8938267104E-01],
	[2.8020000000E+04, 1.6697099585E+01, 4.9926503660E+00, 3.9198318534E+00, 1.9406244860E+00, 8.8943118441E-01],
	[2.8025000000E+04, 1.6701907169E+01, 4.9926190849E+00, 3.9220776580E+00, 1.9412350132E+00, 8.8947967593E-01],
	[2.8030000000E+04, 1.6706715280E+01, 4.9925878096E+00, 3.9243243476E+00, 1.9418454813E+00, 8.8952814562E-01],
	[2.8035000000E+04, 1.6711523917E+01, 4.9925565401E+00, 3.9265719225E+00, 1.9424558905E+00, 8.8957659349E-01],
	[2.8040000000E+04, 1.6716333080E+01, 4.9925252764E+00, 3.9288203827E+00, 1.9430662405E+00, 8.8962501954E-01],
	[2.8045000000E+04, 1.6721142769E+01, 4.9924940184E+00, 3.9310697286E+00, 1.9436765313E+00, 8.8967342379E-01],
	[2.8050000000E+04, 1.6725952985E+01, 4.9924627662E+00, 3.9333199602E+00, 1.9442867629E+00, 8.8972180624E-01],
	[2.8055000000E+04, 1.6730763726E+01, 4.9924315197E+00, 3.9355710778E+00, 1.9448969351E+00, 8.8977016690E-01],
	[2.8060000000E+04, 1.6735586901E+01, 4.9924023624E+00, 3.9378230816E+00, 1.9455075253E+00, 8.8981850578E-01],
	[2.8065000000E+04, 1.6740417857E+01, 4.9923744787E+00, 3.9400759717E+00, 1.9461183471E+00, 8.8986682288E-01],
	[2.8070000000E+04, 1.6745249347E+01, 4.9923466002E+00, 3.9423297483E+00, 1.9467291101E+00, 8.8991511823E-01],
	[2.8075000000E+04, 1.6750081371E+01, 4.9923187267E+00, 3.9445844117E+00, 1.9473398142E+00, 8.8996339181E-01],
	[2.8080000000E+04, 1.6754913928E+01, 4.9922908584E+00, 3.9468399621E+00, 1.9479504592E+00, 8.9001164366E-01],
	[2.8085000000E+04, 1.6759747018E+01, 4.9922629953E+00, 3.9490963995E+00, 1.9485610452E+00, 8.9005987376E-01],
	[2.8090000000E+04, 1.6764580642E+01, 4.9922351372E+00, 3.9513537243E+00, 1.9491715721E+00, 8.9010808213E-01],
	[2.8095000000E+04, 1.6769414799E+01, 4.9922072842E+00, 3.9536119365E+00, 1.9497820398E+00, 8.9015626879E-01],
	[2.8100000000E+04, 1.6774249490E+01, 4.9921794364E+00, 3.9558710364E+00, 1.9503924482E+00, 8.9020443373E-01],
	[2.8105000000E+04, 1.6779084714E+01, 4.9921515937E+00, 3.9581310243E+00, 1.9510027973E+00, 8.9025257697E-01],
	[2.8110000000E+04, 1.6783920471E+01, 4.9921237560E+00, 3.9603919001E+00, 1.9516130870E+00, 8.9030069851E-01],
	[2.8115000000E+04, 1.6788756761E+01, 4.9920959235E+00, 3.9626536643E+00, 1.9522233172E+00, 8.9034879837E-01],
	[2.8120000000E+04, 1.6793593585E+01, 4.9920680961E+00, 3.9649163169E+00, 1.9528334879E+00, 8.9039687654E-01],
	[2.8125000000E+04, 1.6798430942E+01, 4.9920402738E+00, 3.9671798581E+00, 1.9534435989E+00, 8.9044493305E-01],
	[2.8130000000E+04, 1.6803268832E+01, 4.9920124566E+00, 3.9694442882E+00, 1.9540536503E+00, 8.9049296790E-01],
	[2.8135000000E+04, 1.6808107255E+01, 4.9919846445E+00, 3.9717096073E+00, 1.9546636420E+00, 8.9054098110E-01],
	[2.8140000000E+04, 1.6812946211E+01, 4.9919568374E+00, 3.9739758156E+00, 1.9552735738E+00, 8.9058897265E-01],
	[2.8145000000E+04, 1.6817785700E+01, 4.9919290355E+00, 3.9762429133E+00, 1.9558834457E+00, 8.9063694257E-01],
	[2.8150000000E+04, 1.6822625722E+01, 4.9919012387E+00, 3.9785109006E+00, 1.9564932577E+00, 8.9068489086E-01],
	[2.8155000000E+04, 1.6827466276E+01, 4.9918734470E+00, 3.9807797776E+00, 1.9571030096E+00, 8.9073281753E-01],
	[2.8160000000E+04, 1.6832307364E+01, 4.9918456603E+00, 3.9830495447E+00, 1.9577127015E+00, 8.9078072260E-01],
	[2.8165000000E+04, 1.6837148985E+01, 4.9918178787E+00, 3.9853202019E+00, 1.9583223332E+00, 8.9082860606E-01],
	[2.8170000000E+04, 1.6841991139E+01, 4.9917901023E+00, 3.9875917495E+00, 1.9589319047E+00, 8.9087646793E-01],
	[2.8175000000E+04, 1.6846833825E+01, 4.9917623309E+00, 3.9898641876E+00, 1.9595414159E+00, 8.9092430822E-01],
	[2.8180000000E+04, 1.6851677044E+01, 4.9917345646E+00, 3.9921375165E+00, 1.9601508668E+00, 8.9097212693E-01],
	[2.8185000000E+04, 1.6856520796E+01, 4.9917068034E+00, 3.9944117362E+00, 1.9607602572E+00, 8.9101992408E-01],
	[2.8190000000E+04, 1.6861365080E+01, 4.9916790472E+00, 3.9966868471E+00, 1.9613695871E+00, 8.9106769967E-01],
	[2.8195000000E+04, 1.6866209897E+01, 4.9916512961E+00, 3.9989628493E+00, 1.9619788564E+00, 8.9111545371E-01],
	[2.8200000000E+04, 1.6871055247E+01, 4.9916235501E+00, 4.0012397431E+00, 1.9625880651E+00, 8.9116318621E-01],
	[2.8205000000E+04, 1.6875901129E+01, 4.9915958092E+00, 4.0035175285E+00, 1.9631972131E+00, 8.9121089718E-01],
	[2.8210000000E+04, 1.6880747544E+01, 4.9915680734E+00, 4.0057962057E+00, 1.9638063004E+00, 8.9125858662E-01],
	[2.8215000000E+04, 1.6885594492E+01, 4.9915403426E+00, 4.0080757751E+00, 1.9644153268E+00, 8.9130625456E-01],
	[2.8220000000E+04, 1.6890441972E+01, 4.9915126169E+00, 4.0103562367E+00, 1.9650242923E+00, 8.9135390098E-01],
	[2.8225000000E+04, 1.6895289984E+01, 4.9914848962E+00, 4.0126375908E+00, 1.9656331968E+00, 8.9140152591E-01],
	[2.8230000000E+04, 1.6900138529E+01, 4.9914571807E+00, 4.0149198375E+00, 1.9662420403E+00, 8.9144912935E-01],
	[2.8235000000E+04, 1.6904987606E+01, 4.9914294701E+00, 4.0172029770E+00, 1.9668508227E+00, 8.9149671131E-01],
	[2.8240000000E+04, 1.6909837215E+01, 4.9914017647E+00, 4.0194870096E+00, 1.9674595439E+00, 8.9154427179E-01],
	[2.8245000000E+04, 1.6914687357E+01, 4.9913740643E+00, 4.0217719354E+00, 1.9680682038E+00, 8.9159181082E-01],
	[2.8250000000E+04, 1.6919538031E+01, 4.9913463689E+00, 4.0240577546E+00, 1.9686768025E+00, 8.9163932839E-01],
	[2.8255000000E+04, 1.6924389237E+01, 4.9913186786E+00, 4.0263444673E+00, 1.9692853398E+00, 8.9168682451E-01],
	[2.8260000000E+04, 1.6929240975E+01, 4.9912909934E+00, 4.0286320739E+00, 1.9698938156E+00, 8.9173429920E-01],
	[2.8265000000E+04, 1.6934093246E+01, 4.9912633132E+00, 4.0309205745E+00, 1.9705022300E+00, 8.9178175246E-01],
	[2.8270000000E+04, 1.6938946048E+01, 4.9912356381E+00, 4.0332099692E+00, 1.9711105827E+00, 8.9182918430E-01],
	[2.8275000000E+04, 1.6943799383E+01, 4.9912079680E+00, 4.0355002583E+00, 1.9717188738E+00, 8.9187659473E-01],
	[2.8280000000E+04, 1.6948653250E+01, 4.9911803030E+00, 4.0377914419E+00, 1.9723271032E+00, 8.9192398375E-01],
	[2.8285000000E+04, 1.6953507649E+01, 4.9911526430E+00, 4.0400835203E+00, 1.9729352709E+00, 8.9197135139E-01],
	[2.8290000000E+04, 1.6958362579E+01, 4.9911249880E+00, 4.0423764936E+00, 1.9735433766E+00, 8.9201869764E-01],
	[2.8295000000E+04, 1.6963218042E+01, 4.9910973381E+00, 4.0446703620E+00, 1.9741514205E+00, 8.9206602251E-01],
	[2.8300000000E+04, 1.6968074037E+01, 4.9910696932E+00, 4.0469651257E+00, 1.9747594024E+00, 8.9211332601E-01],
	[2.8305000000E+04, 1.6972930563E+01, 4.9910420534E+00, 4.0492607850E+00, 1.9753673222E+00, 8.9216060815E-01],
	[2.8310000000E+04, 1.6977787621E+01, 4.9910144186E+00, 4.0515573399E+00, 1.9759751800E+00, 8.9220786895E-01],
	[2.8315000000E+04, 1.6982645211E+01, 4.9909867888E+00, 4.0538547907E+00, 1.9765829755E+00, 8.9225510840E-01],
	[2.8320000000E+04, 1.6987503333E+01, 4.9909591641E+00, 4.0561531376E+00, 1.9771907089E+00, 8.9230232652E-01],
	[2.8325000000E+04, 1.6992361987E+01, 4.9909315444E+00, 4.0584523808E+00, 1.9777983799E+00, 8.9234952331E-01],
	[2.8330000000E+04, 1.6997221172E+01, 4.9909039297E+00, 4.0607525204E+00, 1.9784059885E+00, 8.9239669879E-01],
	[2.8335000000E+04, 1.7002080889E+01, 4.9908763200E+00, 4.0630535567E+00, 1.9790135347E+00, 8.9244385296E-01],
	[2.8340000000E+04, 1.7006941137E+01, 4.9908487154E+00, 4.0653554898E+00, 1.9796210184E+00, 8.9249098583E-01],
	[2.8345000000E+04, 1.7011801917E+01, 4.9908211158E+00, 4.0676583199E+00, 1.9802284395E+00, 8.9253809741E-01],
	[2.8350000000E+04, 1.7016663229E+01, 4.9907935212E+00, 4.0699620473E+00, 1.9808357980E+00, 8.9258518771E-01],
	[2.8355000000E+04, 1.7021525072E+01, 4.9907659316E+00, 4.0722666720E+00, 1.9814430937E+00, 8.9263225674E-01],
	[2.8360000000E+04, 1.7026387447E+01, 4.9907383471E+00, 4.0745721944E+00, 1.9820503267E+00, 8.9267930451E-01],
	[2.8365000000E+04, 1.7031250353E+01, 4.9907107676E+00, 4.0768786146E+00, 1.9826574969E+00, 8.9272633102E-01],
	[2.8370000000E+04, 1.7036113790E+01, 4.9906831930E+00, 4.0791859327E+00, 1.9832646041E+00, 8.9277333628E-01],
	[2.8375000000E+04, 1.7040977759E+01, 4.9906556235E+00, 4.0814941491E+00, 1.9838716484E+00, 8.9282032030E-01],
	[2.8380000000E+04, 1.7045842259E+01, 4.9906280590E+00, 4.0838032638E+00, 1.9844786296E+00, 8.9286728310E-01],
	[2.8385000000E+04, 1.7050707290E+01, 4.9906004995E+00, 4.0861132770E+00, 1.9850855478E+00, 8.9291422467E-01],
	[2.8390000000E+04, 1.7055572853E+01, 4.9905729450E+00, 4.0884241890E+00, 1.9856924028E+00, 8.9296114503E-01],
	[2.8395000000E+04, 1.7060438947E+01, 4.9905453956E+00, 4.0907360000E+00, 1.9862991945E+00, 8.9300804419E-01],
	[2.8400000000E+04, 1.7065305572E+01, 4.9905178511E+00, 4.0930487100E+00, 1.9869059229E+00, 8.9305492216E-01],
	[2.8405000000E+04, 1.7070172728E+01, 4.9904903116E+00, 4.0953623194E+00, 1.9875125880E+00, 8.9310177893E-01],
	[2.8410000000E+04, 1.7075040416E+01, 4.9904627771E+00, 4.0976768283E+00, 1.9881191897E+00, 8.9314861454E-01],
	[2.8415000000E+04, 1.7079908634E+01, 4.9904352476E+00, 4.0999922369E+00, 1.9887257278E+00, 8.9319542897E-01],
	[2.8420000000E+04, 1.7084777384E+01, 4.9904077232E+00, 4.1023085454E+00, 1.9893322024E+00, 8.9324222224E-01],
	[2.8425000000E+04, 1.7089646664E+01, 4.9903802037E+00, 4.1046257540E+00, 1.9899386134E+00, 8.9328899436E-01],
	[2.8430000000E+04, 1.7094516475E+01, 4.9903526892E+00, 4.1069438629E+00, 1.9905449607E+00, 8.9333574534E-01],
	[2.8435000000E+04, 1.7099386818E+01, 4.9903251796E+00, 4.1092628722E+00, 1.9911512442E+00, 8.9338247518E-01],
	[2.8440000000E+04, 1.7104257691E+01, 4.9902976751E+00, 4.1115827822E+00, 1.9917574639E+00, 8.9342918390E-01],
	[2.8445000000E+04, 1.7109129095E+01, 4.9902701756E+00, 4.1139035930E+00, 1.9923636197E+00, 8.9347587151E-01],
	[2.8450000000E+04, 1.7114001030E+01, 4.9902426810E+00, 4.1162253049E+00, 1.9929697116E+00, 8.9352253800E-01],
	[2.8455000000E+04, 1.7118873496E+01, 4.9902151915E+00, 4.1185479180E+00, 1.9935757395E+00, 8.9356918340E-01],
	[2.8460000000E+04, 1.7123746493E+01, 4.9901877069E+00, 4.1208714325E+00, 1.9941817033E+00, 8.9361580770E-01],
	[2.8465000000E+04, 1.7128620020E+01, 4.9901602273E+00, 4.1231958486E+00, 1.9947876029E+00, 8.9366241093E-01],
	[2.8470000000E+04, 1.7133494078E+01, 4.9901327527E+00, 4.1255211666E+00, 1.9953934383E+00, 8.9370899308E-01],
	[2.8475000000E+04, 1.7138368667E+01, 4.9901052830E+00, 4.1278473865E+00, 1.9959992095E+00, 8.9375555416E-01],
	[2.8480000000E+04, 1.7143243786E+01, 4.9900778183E+00, 4.1301745086E+00, 1.9966049163E+00, 8.9380209419E-01],
	[2.8485000000E+04, 1.7148119436E+01, 4.9900503586E+00, 4.1325025331E+00, 1.9972105587E+00, 8.9384861318E-01],
	[2.8490000000E+04, 1.7152995616E+01, 4.9900229039E+00, 4.1348314602E+00, 1.9978161367E+00, 8.9389511112E-01],
	[2.8495000000E+04, 1.7157872327E+01, 4.9899954541E+00, 4.1371612900E+00, 1.9984216501E+00, 8.9394158804E-01],
	[2.8500000000E+04, 1.7162749568E+01, 4.9899680093E+00, 4.1394920228E+00, 1.9990270989E+00, 8.9398804393E-01],
	[2.8505000000E+04, 1.7167627340E+01, 4.9899405695E+00, 4.1418236587E+00, 1.9996324831E+00, 8.9403447881E-01],
	[2.8510000000E+04, 1.7172511106E+01, 4.9899140767E+00, 4.1441561979E+00, 2.0002380280E+00, 8.9408089269E-01],
	[2.8515000000E+04, 1.7177409047E+01, 4.9898899403E+00, 4.1464896407E+00, 2.0008440715E+00, 8.9412728558E-01],
	[2.8520000000E+04, 1.7182307525E+01, 4.9898658083E+00, 4.1488239871E+00, 2.0014500509E+00, 8.9417365747E-01],
	[2.8525000000E+04, 1.7187206541E+01, 4.9898416806E+00, 4.1511592375E+00, 2.0020559660E+00, 8.9422000839E-01],
	[2.8530000000E+04, 1.7192106095E+01, 4.9898175573E+00, 4.1534953920E+00, 2.0026618169E+00, 8.9426633835E-01],
	[2.8535000000E+04, 1.7197006187E+01, 4.9897934383E+00, 4.1558324507E+00, 2.0032676033E+00, 8.9431264734E-01],
	[2.8540000000E+04, 1.7201906816E+01, 4.9897693236E+00, 4.1581704140E+00, 2.0038733253E+00, 8.9435893538E-01],
	[2.8545000000E+04, 1.7206807983E+01, 4.9897452133E+00, 4.1605092819E+00, 2.0044789829E+00, 8.9440520247E-01],
	[2.8550000000E+04, 1.7211709688E+01, 4.9897211073E+00, 4.1628490547E+00, 2.0050845758E+00, 8.9445144864E-01],
	[2.8555000000E+04, 1.7216611930E+01, 4.9896970057E+00, 4.1651897325E+00, 2.0056901042E+00, 8.9449767388E-01],
	[2.8560000000E+04, 1.7221514710E+01, 4.9896729084E+00, 4.1675313155E+00, 2.0062955678E+00, 8.9454387820E-01],
	[2.8565000000E+04, 1.7226418028E+01, 4.9896488154E+00, 4.1698738040E+00, 2.0069009667E+00, 8.9459006161E-01],
	[2.8570000000E+04, 1.7231321883E+01, 4.9896247268E+00, 4.1722171981E+00, 2.0075063008E+00, 8.9463622413E-01],
	[2.8575000000E+04, 1.7236226275E+01, 4.9896006425E+00, 4.1745614981E+00, 2.0081115700E+00, 8.9468236575E-01],
	[2.8580000000E+04, 1.7241131205E+01, 4.9895765625E+00, 4.1769067040E+00, 2.0087167742E+00, 8.9472848649E-01],
	[2.8585000000E+04, 1.7246036672E+01, 4.9895524868E+00, 4.1792528162E+00, 2.0093219135E+00, 8.9477458635E-01],
	[2.8590000000E+04, 1.7250942677E+01, 4.9895284155E+00, 4.1815998347E+00, 2.0099269877E+00, 8.9482066534E-01],
	[2.8595000000E+04, 1.7255849219E+01, 4.9895043485E+00, 4.1839477598E+00, 2.0105319967E+00, 8.9486672346E-01],
	[2.8600000000E+04, 1.7260756298E+01, 4.9894802859E+00, 4.1862965917E+00, 2.0111369406E+00, 8.9491276074E-01],
	[2.8605000000E+04, 1.7265663915E+01, 4.9894562275E+00, 4.1886463305E+00, 2.0117418192E+00, 8.9495877717E-01],
	[2.8610000000E+04, 1.7270572069E+01, 4.9894321735E+00, 4.1909969765E+00, 2.0123466324E+00, 8.9500477275E-01],
	[2.8615000000E+04, 1.7275480760E+01, 4.9894081238E+00, 4.1933485298E+00, 2.0129513803E+00, 8.9505074751E-01],
	[2.8620000000E+04, 1.7280389988E+01, 4.9893840784E+00, 4.1957009907E+00, 2.0135560628E+00, 8.9509670145E-01],
	[2.8625000000E+04, 1.7285299753E+01, 4.9893600373E+00, 4.1980543593E+00, 2.0141606797E+00, 8.9514263456E-01],
	[2.8630000000E+04, 1.7290210056E+01, 4.9893360006E+00, 4.2004086358E+00, 2.0147652310E+00, 8.9518854688E-01],
	[2.8635000000E+04, 1.7295120895E+01, 4.9893119681E+00, 4.2027638205E+00, 2.0153697168E+00, 8.9523443839E-01],
	[2.8640000000E+04, 1.7300032271E+01, 4.9892879400E+00, 4.2051199134E+00, 2.0159741368E+00, 8.9528030910E-01],
	[2.8645000000E+04, 1.7304944185E+01, 4.9892639162E+00, 4.2074769148E+00, 2.0165784910E+00, 8.9532615904E-01],
	[2.8650000000E+04, 1.7309856635E+01, 4.9892398967E+00, 4.2098348249E+00, 2.0171827795E+00, 8.9537198819E-01],
	[2.8655000000E+04, 1.7314769622E+01, 4.9892158815E+00, 4.2121936439E+00, 2.0177870020E+00, 8.9541779658E-01],
	[2.8660000000E+04, 1.7319683147E+01, 4.9891918706E+00, 4.2145533720E+00, 2.0183911586E+00, 8.9546358421E-01],
	[2.8665000000E+04, 1.7324597208E+01, 4.9891678640E+00, 4.2169140093E+00, 2.0189952492E+00, 8.9550935108E-01],
	[2.8670000000E+04, 1.7329511805E+01, 4.9891438617E+00, 4.2192755560E+00, 2.0195992737E+00, 8.9555509721E-01],
	[2.8675000000E+04, 1.7334426940E+01, 4.9891198637E+00, 4.2216380124E+00, 2.0202032321E+00, 8.9560082260E-01],
	[2.8680000000E+04, 1.7339342611E+01, 4.9890958700E+00, 4.2240013786E+00, 2.0208071242E+00, 8.9564652725E-01],
	[2.8685000000E+04, 1.7344258819E+01, 4.9890718806E+00, 4.2263656549E+00, 2.0214109501E+00, 8.9569221119E-01],
	[2.8690000000E+04, 1.7349175564E+01, 4.9890478955E+00, 4.2287308413E+00, 2.0220147097E+00, 8.9573787441E-01],
	[2.8695000000E+04, 1.7354092845E+01, 4.9890239147E+00, 4.2310969382E+00, 2.0226184029E+00, 8.9578351693E-01],
	[2.8700000000E+04, 1.7359010663E+01, 4.9889999382E+00, 4.2334639456E+00, 2.0232220297E+00, 8.9582913874E-01],
	[2.8705000000E+04, 1.7363929018E+01, 4.9889759660E+00, 4.2358318639E+00, 2.0238255899E+00, 8.9587473987E-01],
	[2.8710000000E+04, 1.7368847909E+01, 4.9889519980E+00, 4.2382006931E+00, 2.0244290836E+00, 8.9592032031E-01],
	[2.8715000000E+04, 1.7373767336E+01, 4.9889280344E+00, 4.2405704335E+00, 2.0250325106E+00, 8.9596588007E-01],
	[2.8720000000E+04, 1.7378687300E+01, 4.9889040750E+00, 4.2429410853E+00, 2.0256358709E+00, 8.9601141917E-01],
	[2.8725000000E+04, 1.7383607801E+01, 4.9888801200E+00, 4.2453126486E+00, 2.0262391645E+00, 8.9605693760E-01],
	[2.8730000000E+04, 1.7388528838E+01, 4.9888561692E+00, 4.2476851236E+00, 2.0268423913E+00, 8.9610243539E-01],
	[2.8735000000E+04, 1.7393450411E+01, 4.9888322227E+00, 4.2500585106E+00, 2.0274455512E+00, 8.9614791253E-01],
	[2.8740000000E+04, 1.7398372520E+01, 4.9888082805E+00, 4.2524328097E+00, 2.0280486441E+00, 8.9619336903E-01],
	[2.8745000000E+04, 1.7403295166E+01, 4.9887843425E+00, 4.2548080212E+00, 2.0286516700E+00, 8.9623880491E-01],
	[2.8750000000E+04, 1.7408218348E+01, 4.9887604089E+00, 4.2571841451E+00, 2.0292546289E+00, 8.9628422016E-01],
	[2.8755000000E+04, 1.7413142066E+01, 4.9887364795E+00, 4.2595611817E+00, 2.0298575207E+00, 8.9632961480E-01],
	[2.8760000000E+04, 1.7418066321E+01, 4.9887125544E+00, 4.2619391313E+00, 2.0304603452E+00, 8.9637498883E-01],
	[2.8765000000E+04, 1.7422991111E+01, 4.9886886336E+00, 4.2643179939E+00, 2.0310631025E+00, 8.9642034227E-01],
	[2.8770000000E+04, 1.7427916438E+01, 4.9886647170E+00, 4.2666977698E+00, 2.0316657925E+00, 8.9646567512E-01],
	[2.8775000000E+04, 1.7432842300E+01, 4.9886408047E+00, 4.2690784591E+00, 2.0322684151E+00, 8.9651098738E-01],
	[2.8780000000E+04, 1.7437768699E+01, 4.9886168967E+00, 4.2714600622E+00, 2.0328709703E+00, 8.9655627908E-01],
	[2.8785000000E+04, 1.7442695634E+01, 4.9885929929E+00, 4.2738425790E+00, 2.0334734580E+00, 8.9660155020E-01],
	[2.8790000000E+04, 1.7447623105E+01, 4.9885690935E+00, 4.2762260099E+00, 2.0340758782E+00, 8.9664680077E-01],
	[2.8795000000E+04, 1.7452551111E+01, 4.9885451982E+00, 4.2786103551E+00, 2.0346782307E+00, 8.9669203079E-01],
	[2.8800000000E+04, 1.7457479654E+01, 4.9885213073E+00, 4.2809956146E+00, 2.0352805155E+00, 8.9673724026E-01],
	[2.8805000000E+04, 1.7462408732E+01, 4.9884974206E+00, 4.2833817888E+00, 2.0358827326E+00, 8.9678242920E-01],
	[2.8810000000E+04, 1.7467338347E+01, 4.9884735381E+00, 4.2857688778E+00, 2.0364848819E+00, 8.9682759761E-01],
	[2.8815000000E+04, 1.7472268497E+01, 4.9884496600E+00, 4.2881568818E+00, 2.0370869634E+00, 8.9687274550E-01],
	[2.8820000000E+04, 1.7477199182E+01, 4.9884257860E+00, 4.2905458009E+00, 2.0376889769E+00, 8.9691787289E-01],
	[2.8825000000E+04, 1.7482130404E+01, 4.9884019164E+00, 4.2929356355E+00, 2.0382909225E+00, 8.9696297976E-01],
	[2.8830000000E+04, 1.7487062161E+01, 4.9883780510E+00, 4.2953263856E+00, 2.0388928000E+00, 8.9700806615E-01],
	[2.8835000000E+04, 1.7491994454E+01, 4.9883541898E+00, 4.2977180515E+00, 2.0394946094E+00, 8.9705313204E-01],
	[2.8840000000E+04, 1.7496927283E+01, 4.9883303329E+00, 4.3001106334E+00, 2.0400963506E+00, 8.9709817746E-01],
	[2.8845000000E+04, 1.7501860647E+01, 4.9883064802E+00, 4.3025041313E+00, 2.0406980236E+00, 8.9714320240E-01],
	[2.8850000000E+04, 1.7506794546E+01, 4.9882826318E+00, 4.3048985457E+00, 2.0412996284E+00, 8.9718820688E-01],
	[2.8855000000E+04, 1.7511728982E+01, 4.9882587877E+00, 4.3072938765E+00, 2.0419011648E+00, 8.9723319090E-01],
	[2.8860000000E+04, 1.7516663952E+01, 4.9882349478E+00, 4.3096901241E+00, 2.0425026328E+00, 8.9727815448E-01],
	[2.8865000000E+04, 1.7521599458E+01, 4.9882111121E+00, 4.3120872886E+00, 2.0431040323E+00, 8.9732309762E-01],
	[2.8870000000E+04, 1.7526535500E+01, 4.9881872807E+00, 4.3144853702E+00, 2.0437053633E+00, 8.9736802032E-01],
	[2.8875000000E+04, 1.7531472077E+01, 4.9881634535E+00, 4.3168843691E+00, 2.0443066257E+00, 8.9741292260E-01],
	[2.8880000000E+04, 1.7536409189E+01, 4.9881396305E+00, 4.3192842855E+00, 2.0449078195E+00, 8.9745780446E-01],
	[2.8885000000E+04, 1.7541346837E+01, 4.9881158118E+00, 4.3216851195E+00, 2.0455089445E+00, 8.9750266591E-01],
	[2.8890000000E+04, 1.7546285020E+01, 4.9880919973E+00, 4.3240868714E+00, 2.0461100009E+00, 8.9754750696E-01],
	[2.8895000000E+04, 1.7551223738E+01, 4.9880681871E+00, 4.3264895414E+00, 2.0467109883E+00, 8.9759232762E-01],
	[2.8900000000E+04, 1.7556162991E+01, 4.9880443811E+00, 4.3288931297E+00, 2.0473119069E+00, 8.9763712789E-01],
	[2.8905000000E+04, 1.7561102779E+01, 4.9880205793E+00, 4.3312976364E+00, 2.0479127566E+00, 8.9768190779E-01],
	[2.8910000000E+04, 1.7566043103E+01, 4.9879967818E+00, 4.3337030617E+00, 2.0485135372E+00, 8.9772666732E-01],
	[2.8915000000E+04, 1.7570983962E+01, 4.9879729884E+00, 4.3361094058E+00, 2.0491142488E+00, 8.9777140648E-01],
	[2.8920000000E+04, 1.7575925355E+01, 4.9879491994E+00, 4.3385166690E+00, 2.0497148913E+00, 8.9781612530E-01],
	[2.8925000000E+04, 1.7580867284E+01, 4.9879254145E+00, 4.3409248514E+00, 2.0503154646E+00, 8.9786082376E-01],
	[2.8930000000E+04, 1.7585809748E+01, 4.9879016339E+00, 4.3433339532E+00, 2.0509159686E+00, 8.9790550189E-01],
	[2.8935000000E+04, 1.7590752747E+01, 4.9878778574E+00, 4.3457439746E+00, 2.0515164034E+00, 8.9795015969E-01],
	[2.8940000000E+04, 1.7595696281E+01, 4.9878540852E+00, 4.3481549157E+00, 2.0521167688E+00, 8.9799479717E-01],
	[2.8945000000E+04, 1.7600640349E+01, 4.9878303173E+00, 4.3505667769E+00, 2.0527170647E+00, 8.9803941434E-01],
	[2.8950000000E+04, 1.7605584953E+01, 4.9878065535E+00, 4.3529795582E+00, 2.0533172912E+00, 8.9808401120E-01],
	[2.8955000000E+04, 1.7610530091E+01, 4.9877827940E+00, 4.3553932599E+00, 2.0539174482E+00, 8.9812858776E-01],
	[2.8960000000E+04, 1.7615475764E+01, 4.9877590387E+00, 4.3578078821E+00, 2.0545175355E+00, 8.9817314403E-01],
	[2.8965000000E+04, 1.7620421972E+01, 4.9877352876E+00, 4.3602234251E+00, 2.0551175532E+00, 8.9821768002E-01],
	[2.8970000000E+04, 1.7625378167E+01, 4.9877131468E+00, 4.3626398890E+00, 2.0557179027E+00, 8.9826219573E-01],
	[2.8975000000E+04, 1.7630344500E+01, 4.9876926408E+00, 4.3650572740E+00, 2.0563185904E+00, 8.9830669118E-01],
	[2.8980000000E+04, 1.7635311375E+01, 4.9876721384E+00, 4.3674755804E+00, 2.0569192090E+00, 8.9835116637E-01],
	[2.8985000000E+04, 1.7640278792E+01, 4.9876516396E+00, 4.3698948082E+00, 2.0575197584E+00, 8.9839562131E-01],
	[2.8990000000E+04, 1.7645246751E+01, 4.9876311444E+00, 4.3723149578E+00, 2.0581202384E+00, 8.9844005601E-01],
	[2.8995000000E+04, 1.7650215252E+01, 4.9876106529E+00, 4.3747360293E+00, 2.0587206492E+00, 8.9848447047E-01],
	[2.9000000000E+04, 1.7655184295E+01, 4.9875901649E+00, 4.3771580228E+00, 2.0593209905E+00, 8.9852886471E-01],
	[2.9005000000E+04, 1.7660153880E+01, 4.9875696806E+00, 4.3795809387E+00, 2.0599212624E+00, 8.9857323873E-01],
	[2.9010000000E+04, 1.7665124006E+01, 4.9875491999E+00, 4.3820047770E+00, 2.0605214647E+00, 8.9861759254E-01],
	[2.9015000000E+04, 1.7670094675E+01, 4.9875287228E+00, 4.3844295379E+00, 2.0611215975E+00, 8.9866192614E-01],
	[2.9020000000E+04, 1.7675065885E+01, 4.9875082493E+00, 4.3868552217E+00, 2.0617216606E+00, 8.9870623955E-01],
	[2.9025000000E+04, 1.7680037638E+01, 4.9874877795E+00, 4.3892818286E+00, 2.0623216540E+00, 8.9875053278E-01],
	[2.9030000000E+04, 1.7685009931E+01, 4.9874673132E+00, 4.3917093587E+00, 2.0629215777E+00, 8.9879480582E-01],
	[2.9035000000E+04, 1.7689982767E+01, 4.9874468505E+00, 4.3941378122E+00, 2.0635214316E+00, 8.9883905870E-01],
	[2.9040000000E+04, 1.7694956144E+01, 4.9874263915E+00, 4.3965671893E+00, 2.0641212156E+00, 8.9888329141E-01],
	[2.9045000000E+04, 1.7699930063E+01, 4.9874059361E+00, 4.3989974903E+00, 2.0647209297E+00, 8.9892750397E-01],
	[2.9050000000E+04, 1.7704904524E+01, 4.9873854842E+00, 4.4014287153E+00, 2.0653205737E+00, 8.9897169638E-01],
	[2.9055000000E+04, 1.7709879526E+01, 4.9873650360E+00, 4.4038608644E+00, 2.0659201478E+00, 8.9901586865E-01],
	[2.9060000000E+04, 1.7714855070E+01, 4.9873445914E+00, 4.4062939380E+00, 2.0665196517E+00, 8.9906002079E-01],
	[2.9065000000E+04, 1.7719831155E+01, 4.9873241504E+00, 4.4087279361E+00, 2.0671190855E+00, 8.9910415281E-01],
	[2.9070000000E+04, 1.7724807781E+01, 4.9873037129E+00, 4.4111628590E+00, 2.0677184491E+00, 8.9914826472E-01],
	[2.9075000000E+04, 1.7729784949E+01, 4.9872832791E+00, 4.4135987068E+00, 2.0683177423E+00, 8.9919235651E-01],
	[2.9080000000E+04, 1.7734762659E+01, 4.9872628489E+00, 4.4160354798E+00, 2.0689169653E+00, 8.9923642821E-01],
	[2.9085000000E+04, 1.7739740909E+01, 4.9872424222E+00, 4.4184731782E+00, 2.0695161179E+00, 8.9928047982E-01],
	[2.9090000000E+04, 1.7744719701E+01, 4.9872219992E+00, 4.4209118021E+00, 2.0701152000E+00, 8.9932451135E-01],
	[2.9095000000E+04, 1.7749699035E+01, 4.9872015798E+00, 4.4233513517E+00, 2.0707142116E+00, 8.9936852280E-01],
	[2.9100000000E+04, 1.7754678909E+01, 4.9871811639E+00, 4.4257918273E+00, 2.0713131526E+00, 8.9941251418E-01],
	[2.9105000000E+04, 1.7759659325E+01, 4.9871607517E+00, 4.4282332289E+00, 2.0719120230E+00, 8.9945648550E-01],
	[2.9110000000E+04, 1.7764640282E+01, 4.9871403430E+00, 4.4306755569E+00, 2.0725108227E+00, 8.9950043678E-01],
	[2.9115000000E+04, 1.7769621781E+01, 4.9871199379E+00, 4.4331188113E+00, 2.0731095517E+00, 8.9954436801E-01],
	[2.9120000000E+04, 1.7774603820E+01, 4.9870995364E+00, 4.4355629925E+00, 2.0737082100E+00, 8.9958827921E-01],
	[2.9125000000E+04, 1.7779586400E+01, 4.9870791385E+00, 4.4380081005E+00, 2.0743067973E+00, 8.9963217038E-01],
	[2.9130000000E+04, 1.7784569522E+01, 4.9870587442E+00, 4.4404541356E+00, 2.0749053138E+00, 8.9967604153E-01],
	[2.9135000000E+04, 1.7789553184E+01, 4.9870383534E+00, 4.4429010980E+00, 2.0755037592E+00, 8.9971989267E-01],
	[2.9140000000E+04, 1.7794537388E+01, 4.9870179663E+00, 4.4453489878E+00, 2.0761021337E+00, 8.9976372380E-01],
	[2.9145000000E+04, 1.7799522132E+01, 4.9869975827E+00, 4.4477978053E+00, 2.0767004371E+00, 8.9980753495E-01],
	[2.9150000000E+04, 1.7804507418E+01, 4.9869772027E+00, 4.4502475506E+00, 2.0772986693E+00, 8.9985132610E-01],
	[2.9155000000E+04, 1.7809493244E+01, 4.9869568263E+00, 4.4526982240E+00, 2.0778968303E+00, 8.9989509728E-01],
	[2.9160000000E+04, 1.7814479611E+01, 4.9869364535E+00, 4.4551498255E+00, 2.0784949201E+00, 8.9993884849E-01],
	[2.9165000000E+04, 1.7819466519E+01, 4.9869160842E+00, 4.4576023555E+00, 2.0790929386E+00, 8.9998257973E-01],
	[2.9170000000E+04, 1.7824453967E+01, 4.9868957185E+00, 4.4600558141E+00, 2.0796908857E+00, 9.0002629102E-01],
	[2.9175000000E+04, 1.7829441957E+01, 4.9868753564E+00, 4.4625102015E+00, 2.0802887614E+00, 9.0006998236E-01],
	[2.9180000000E+04, 1.7834430487E+01, 4.9868549978E+00, 4.4649655179E+00, 2.0808865657E+00, 9.0011365377E-01],
	[2.9185000000E+04, 1.7839419558E+01, 4.9868346429E+00, 4.4674217635E+00, 2.0814842984E+00, 9.0015730524E-01],
	[2.9190000000E+04, 1.7844409169E+01, 4.9868142915E+00, 4.4698789384E+00, 2.0820819595E+00, 9.0020093679E-01],
	[2.9195000000E+04, 1.7849399321E+01, 4.9867939436E+00, 4.4723370429E+00, 2.0826795489E+00, 9.0024454843E-01],
	[2.9200000000E+04, 1.7854390014E+01, 4.9867735994E+00, 4.4747960772E+00, 2.0832770666E+00, 9.0028814016E-01],
	[2.9205000000E+04, 1.7859381247E+01, 4.9867532587E+00, 4.4772560414E+00, 2.0838745126E+00, 9.0033171199E-01],
	[2.9210000000E+04, 1.7864373021E+01, 4.9867329215E+00, 4.4797169358E+00, 2.0844718868E+00, 9.0037526393E-01],
	[2.9215000000E+04, 1.7869365335E+01, 4.9867125880E+00, 4.4821787605E+00, 2.0850691891E+00, 9.0041879599E-01],
	[2.9220000000E+04, 1.7874358190E+01, 4.9866922580E+00, 4.4846415157E+00, 2.0856664195E+00, 9.0046230818E-01],
	[2.9225000000E+04, 1.7879351585E+01, 4.9866719315E+00, 4.4871052017E+00, 2.0862635779E+00, 9.0050580050E-01],
	[2.9230000000E+04, 1.7884345520E+01, 4.9866516086E+00, 4.4895698185E+00, 2.0868606642E+00, 9.0054927296E-01],
	[2.9235000000E+04, 1.7889339996E+01, 4.9866312893E+00, 4.4920353665E+00, 2.0874576784E+00, 9.0059272557E-01],
	[2.9240000000E+04, 1.7894335012E+01, 4.9866109735E+00, 4.4945018458E+00, 2.0880546205E+00, 9.0063615834E-01],
	[2.9245000000E+04, 1.7899330568E+01, 4.9865906613E+00, 4.4969692565E+00, 2.0886514904E+00, 9.0067957127E-01],
	[2.9250000000E+04, 1.7904326665E+01, 4.9865703527E+00, 4.4994375989E+00, 2.0892482880E+00, 9.0072296438E-01],
	[2.9255000000E+04, 1.7909323301E+01, 4.9865500476E+00, 4.5019068733E+00, 2.0898450133E+00, 9.0076633767E-01],
	[2.9260000000E+04, 1.7914320478E+01, 4.9865297460E+00, 4.5043770796E+00, 2.0904416662E+00, 9.0080969115E-01],
	[2.9265000000E+04, 1.7919318195E+01, 4.9865094480E+00, 4.5068482182E+00, 2.0910382467E+00, 9.0085302483E-01],
	[2.9270000000E+04, 1.7924316452E+01, 4.9864891536E+00, 4.5093202893E+00, 2.0916347547E+00, 9.0089633872E-01],
	[2.9275000000E+04, 1.7929315249E+01, 4.9864688627E+00, 4.5117932930E+00, 2.0922311902E+00, 9.0093963282E-01],
	[2.9280000000E+04, 1.7934314587E+01, 4.9864485753E+00, 4.5142672296E+00, 2.0928275530E+00, 9.0098290714E-01],
	[2.9285000000E+04, 1.7939314464E+01, 4.9864282915E+00, 4.5167420991E+00, 2.0934238432E+00, 9.0102616170E-01],
	[2.9290000000E+04, 1.7944314881E+01, 4.9864080112E+00, 4.5192179019E+00, 2.0940200607E+00, 9.0106939649E-01],
	[2.9295000000E+04, 1.7949315838E+01, 4.9863877345E+00, 4.5216946381E+00, 2.0946162054E+00, 9.0111261153E-01],
	[2.9300000000E+04, 1.7954317335E+01, 4.9863674614E+00, 4.5241723079E+00, 2.0952122773E+00, 9.0115580682E-01],
	[2.9305000000E+04, 1.7959319372E+01, 4.9863471917E+00, 4.5266509115E+00, 2.0958082764E+00, 9.0119898238E-01],
	[2.9310000000E+04, 1.7964321949E+01, 4.9863269256E+00, 4.5291304490E+00, 2.0964042025E+00, 9.0124213820E-01],
	[2.9315000000E+04, 1.7969325065E+01, 4.9863066631E+00, 4.5316109208E+00, 2.0970000556E+00, 9.0128527431E-01],
	[2.9320000000E+04, 1.7974328722E+01, 4.9862864041E+00, 4.5340923269E+00, 2.0975958356E+00, 9.0132839070E-01],
	[2.9325000000E+04, 1.7979332918E+01, 4.9862661486E+00, 4.5365746676E+00, 2.0981915426E+00, 9.0137148739E-01],
	[2.9330000000E+04, 1.7984337653E+01, 4.9862458966E+00, 4.5390579430E+00, 2.0987871764E+00, 9.0141456438E-01],
	[2.9335000000E+04, 1.7989342929E+01, 4.9862256482E+00, 4.5415421534E+00, 2.0993827371E+00, 9.0145762168E-01],
	[2.9340000000E+04, 1.7994348744E+01, 4.9862054034E+00, 4.5440272989E+00, 2.0999782244E+00, 9.0150065931E-01],
	[2.9345000000E+04, 1.7999355098E+01, 4.9861851620E+00, 4.5465133797E+00, 2.1005736384E+00, 9.0154367726E-01],
	[2.9350000000E+04, 1.8004361992E+01, 4.9861649242E+00, 4.5490003961E+00, 2.1011689791E+00, 9.0158667554E-01],
	[2.9355000000E+04, 1.8009369426E+01, 4.9861446899E+00, 4.5514883482E+00, 2.1017642464E+00, 9.0162965417E-01],
	[2.9360000000E+04, 1.8014377399E+01, 4.9861244592E+00, 4.5539772362E+00, 2.1023594401E+00, 9.0167261315E-01],
	[2.9365000000E+04, 1.8019385912E+01, 4.9861042319E+00, 4.5564670602E+00, 2.1029545603E+00, 9.0171555249E-01],
	[2.9370000000E+04, 1.8024394964E+01, 4.9860840082E+00, 4.5589578206E+00, 2.1035496070E+00, 9.0175847220E-01],
	[2.9375000000E+04, 1.8029404555E+01, 4.9860637881E+00, 4.5614495175E+00, 2.1041445800E+00, 9.0180137228E-01],
	[2.9380000000E+04, 1.8034414686E+01, 4.9860435714E+00, 4.5639421510E+00, 2.1047394793E+00, 9.0184425275E-01],
	[2.9385000000E+04, 1.8039425356E+01, 4.9860233583E+00, 4.5664357214E+00, 2.1053343048E+00, 9.0188711361E-01],
	[2.9390000000E+04, 1.8044436566E+01, 4.9860031487E+00, 4.5689302288E+00, 2.1059290565E+00, 9.0192995487E-01],
	[2.9395000000E+04, 1.8049448314E+01, 4.9859829426E+00, 4.5714256736E+00, 2.1065237344E+00, 9.0197277654E-01],
	[2.9400000000E+04, 1.8054460602E+01, 4.9859627400E+00, 4.5739220557E+00, 2.1071183384E+00, 9.0201557863E-01],
	[2.9405000000E+04, 1.8059473429E+01, 4.9859425410E+00, 4.5764193755E+00, 2.1077128684E+00, 9.0205836114E-01],
	[2.9410000000E+04, 1.8064486795E+01, 4.9859223454E+00, 4.5789176331E+00, 2.1083073243E+00, 9.0210112408E-01],
	[2.9415000000E+04, 1.8069500701E+01, 4.9859021534E+00, 4.5814168287E+00, 2.1089017062E+00, 9.0214386747E-01],
	[2.9420000000E+04, 1.8074515145E+01, 4.9858819649E+00, 4.5839169626E+00, 2.1094960140E+00, 9.0218659130E-01],
	[2.9425000000E+04, 1.8079530128E+01, 4.9858617799E+00, 4.5864180348E+00, 2.1100902476E+00, 9.0222929559E-01],
	[2.9430000000E+04, 1.8084545651E+01, 4.9858415984E+00, 4.5889200457E+00, 2.1106844069E+00, 9.0227198034E-01],
	[2.9435000000E+04, 1.8089566056E+01, 4.9858221479E+00, 4.5914229953E+00, 2.1112786815E+00, 9.0231464557E-01],
	[2.9440000000E+04, 1.8094601655E+01, 4.9858051547E+00, 4.5939268840E+00, 2.1118735219E+00, 9.0235729128E-01],
	[2.9445000000E+04, 1.8099637800E+01, 4.9857881644E+00, 4.5964317117E+00, 2.1124682885E+00, 9.0239991748E-01],
	[2.9450000000E+04, 1.8104674492E+01, 4.9857711770E+00, 4.5989374789E+00, 2.1130629812E+00, 9.0244252418E-01],
	[2.9455000000E+04, 1.8109711730E+01, 4.9857541926E+00, 4.6014441856E+00, 2.1136576002E+00, 9.0248511138E-01],
	[2.9460000000E+04, 1.8114749514E+01, 4.9857372111E+00, 4.6039518321E+00, 2.1142521452E+00, 9.0252767910E-01],
	[2.9465000000E+04, 1.8119787844E+01, 4.9857202325E+00, 4.6064604185E+00, 2.1148466163E+00, 9.0257022733E-01],
	[2.9470000000E+04, 1.8124826720E+01, 4.9857032569E+00, 4.6089699451E+00, 2.1154410133E+00, 9.0261275610E-01],
	[2.9475000000E+04, 1.8129866143E+01, 4.9856862843E+00, 4.6114804120E+00, 2.1160353363E+00, 9.0265526541E-01],
	[2.9480000000E+04, 1.8134906111E+01, 4.9856693145E+00, 4.6139918194E+00, 2.1166295851E+00, 9.0269775526E-01],
	[2.9485000000E+04, 1.8139946625E+01, 4.9856523477E+00, 4.6165041675E+00, 2.1172237598E+00, 9.0274022567E-01],
	[2.9490000000E+04, 1.8144987685E+01, 4.9856353839E+00, 4.6190174565E+00, 2.1178178603E+00, 9.0278267664E-01],
	[2.9495000000E+04, 1.8150029291E+01, 4.9856184230E+00, 4.6215316866E+00, 2.1184118865E+00, 9.0282510818E-01],
	[2.9500000000E+04, 1.8155071443E+01, 4.9856014650E+00, 4.6240468580E+00, 2.1190058383E+00, 9.0286752030E-01],
	[2.9505000000E+04, 1.8160114141E+01, 4.9855845099E+00, 4.6265629709E+00, 2.1195997157E+00, 9.0290991300E-01],
	[2.9510000000E+04, 1.8165157385E+01, 4.9855675578E+00, 4.6290800254E+00, 2.1201935187E+00, 9.0295228630E-01],
	[2.9515000000E+04, 1.8170201174E+01, 4.9855506086E+00, 4.6315980219E+00, 2.1207872473E+00, 9.0299464021E-01],
	[2.9520000000E+04, 1.8175245509E+01, 4.9855336623E+00, 4.6341169604E+00, 2.1213809012E+00, 9.0303697472E-01],
	[2.9525000000E+04, 1.8180290390E+01, 4.9855167190E+00, 4.6366368411E+00, 2.1219744806E+00, 9.0307928986E-01],
	[2.9530000000E+04, 1.8185335817E+01, 4.9854997785E+00, 4.6391576643E+00, 2.1225679853E+00, 9.0312158562E-01],
	[2.9535000000E+04, 1.8190381789E+01, 4.9854828410E+00, 4.6416794301E+00, 2.1231614153E+00, 9.0316386202E-01],
	[2.9540000000E+04, 1.8195428307E+01, 4.9854659065E+00, 4.6442021387E+00, 2.1237547706E+00, 9.0320611906E-01],
	[2.9545000000E+04, 1.8200475370E+01, 4.9854489748E+00, 4.6467257904E+00, 2.1243480510E+00, 9.0324835676E-01],
	[2.9550000000E+04, 1.8205522979E+01, 4.9854320461E+00, 4.6492503853E+00, 2.1249412566E+00, 9.0329057511E-01],
	[2.9555000000E+04, 1.8210571134E+01, 4.9854151203E+00, 4.6517759236E+00, 2.1255343872E+00, 9.0333277413E-01],
	[2.9560000000E+04, 1.8215619834E+01, 4.9853981974E+00, 4.6543024055E+00, 2.1261274429E+00, 9.0337495383E-01],
	[2.9565000000E+04, 1.8220669079E+01, 4.9853812775E+00, 4.6568298312E+00, 2.1267204236E+00, 9.0341711421E-01],
	[2.9570000000E+04, 1.8225718870E+01, 4.9853643604E+00, 4.6593582008E+00, 2.1273133292E+00, 9.0345925529E-01],
	[2.9575000000E+04, 1.8230769206E+01, 4.9853474463E+00, 4.6618875147E+00, 2.1279061597E+00, 9.0350137707E-01],
	[2.9580000000E+04, 1.8235820087E+01, 4.9853305351E+00, 4.6644177729E+00, 2.1284989150E+00, 9.0354347955E-01],
	[2.9585000000E+04, 1.8240871514E+01, 4.9853136268E+00, 4.6669489756E+00, 2.1290915950E+00, 9.0358556275E-01],
	[2.9590000000E+04, 1.8245923486E+01, 4.9852967214E+00, 4.6694811231E+00, 2.1296841998E+00, 9.0362762668E-01],
	[2.9595000000E+04, 1.8250976004E+01, 4.9852798190E+00, 4.6720142156E+00, 2.1302767293E+00, 9.0366967134E-01],
	[2.9600000000E+04, 1.8256029066E+01, 4.9852629194E+00, 4.6745482532E+00, 2.1308691833E+00, 9.0371169675E-01],
	[2.9605000000E+04, 1.8261082674E+01, 4.9852460228E+00, 4.6770832362E+00, 2.1314615620E+00, 9.0375370290E-01],
	[2.9610000000E+04, 1.8266136827E+01, 4.9852291291E+00, 4.6796191646E+00, 2.1320538651E+00, 9.0379568981E-01],
	[2.9615000000E+04, 1.8271191525E+01, 4.9852122382E+00, 4.6821560388E+00, 2.1326460927E+00, 9.0383765748E-01],
	[2.9620000000E+04, 1.8276246768E+01, 4.9851953503E+00, 4.6846938589E+00, 2.1332382447E+00, 9.0387960593E-01],
	[2.9625000000E+04, 1.8281302556E+01, 4.9851784653E+00, 4.6872326251E+00, 2.1338303210E+00, 9.0392153517E-01],
	[2.9630000000E+04, 1.8286358889E+01, 4.9851615832E+00, 4.6897723375E+00, 2.1344223217E+00, 9.0396344519E-01],
	[2.9635000000E+04, 1.8291415767E+01, 4.9851447040E+00, 4.6923129965E+00, 2.1350142466E+00, 9.0400533601E-01],
	[2.9640000000E+04, 1.8296473190E+01, 4.9851278278E+00, 4.6948546021E+00, 2.1356060957E+00, 9.0404720764E-01],
	[2.9645000000E+04, 1.8301531158E+01, 4.9851109544E+00, 4.6973971546E+00, 2.1361978689E+00, 9.0408906008E-01],
	[2.9650000000E+04, 1.8306589671E+01, 4.9850940839E+00, 4.6999406542E+00, 2.1367895663E+00, 9.0413089335E-01],
	[2.9655000000E+04, 1.8311648729E+01, 4.9850772163E+00, 4.7024851011E+00, 2.1373811877E+00, 9.0417270745E-01],
	[2.9660000000E+04, 1.8316708331E+01, 4.9850603517E+00, 4.7050304953E+00, 2.1379727330E+00, 9.0421450238E-01],
	[2.9665000000E+04, 1.8321768478E+01, 4.9850434899E+00, 4.7075768373E+00, 2.1385642024E+00, 9.0425627817E-01],
	[2.9670000000E+04, 1.8326829170E+01, 4.9850266310E+00, 4.7101241270E+00, 2.1391555956E+00, 9.0429803480E-01],
	[2.9675000000E+04, 1.8331890407E+01, 4.9850097750E+00, 4.7126723648E+00, 2.1397469126E+00, 9.0433977231E-01],
	[2.9680000000E+04, 1.8336952188E+01, 4.9849929219E+00, 4.7152215508E+00, 2.1403381535E+00, 9.0438149068E-01],
	[2.9685000000E+04, 1.8342014514E+01, 4.9849760718E+00, 4.7177716852E+00, 2.1409293181E+00, 9.0442318994E-01],
	[2.9690000000E+04, 1.8347077385E+01, 4.9849592245E+00, 4.7203227682E+00, 2.1415204063E+00, 9.0446487008E-01],
	[2.9695000000E+04, 1.8352140800E+01, 4.9849423801E+00, 4.7228748000E+00, 2.1421114182E+00, 9.0450653112E-01],
	[2.9700000000E+04, 1.8357204760E+01, 4.9849255386E+00, 4.7254277808E+00, 2.1427023537E+00, 9.0454817307E-01],
	[2.9705000000E+04, 1.8362269264E+01, 4.9849086999E+00, 4.7279817108E+00, 2.1432932127E+00, 9.0458979592E-01],
	[2.9710000000E+04, 1.8367334313E+01, 4.9848918642E+00, 4.7305365902E+00, 2.1438839952E+00, 9.0463139970E-01],
	[2.9715000000E+04, 1.8372399906E+01, 4.9848750314E+00, 4.7330924191E+00, 2.1444747011E+00, 9.0467298441E-01],
	[2.9720000000E+04, 1.8377466044E+01, 4.9848582015E+00, 4.7356491978E+00, 2.1450653305E+00, 9.0471455005E-01],
	[2.9725000000E+04, 1.8382532726E+01, 4.9848413744E+00, 4.7382069264E+00, 2.1456558831E+00, 9.0475609664E-01],
	[2.9730000000E+04, 1.8387599952E+01, 4.9848245502E+00, 4.7407656052E+00, 2.1462463590E+00, 9.0479762419E-01],
	[2.9735000000E+04, 1.8392667723E+01, 4.9848077289E+00, 4.7433252344E+00, 2.1468367582E+00, 9.0483913269E-01],
	[2.9740000000E+04, 1.8397736038E+01, 4.9847909106E+00, 4.7458858140E+00, 2.1474270805E+00, 9.0488062217E-01],
	[2.9745000000E+04, 1.8402804897E+01, 4.9847740950E+00, 4.7484473444E+00, 2.1480173259E+00, 9.0492209262E-01],
	[2.9750000000E+04, 1.8407874301E+01, 4.9847572824E+00, 4.7510098257E+00, 2.1486074945E+00, 9.0496354406E-01],
	[2.9755000000E+04, 1.8412944248E+01, 4.9847404727E+00, 4.7535732581E+00, 2.1491975860E+00, 9.0500497649E-01],
	[2.9760000000E+04, 1.8418014740E+01, 4.9847236658E+00, 4.7561376418E+00, 2.1497876006E+00, 9.0504638993E-01],
	[2.9765000000E+04, 1.8423085776E+01, 4.9847068618E+00, 4.7587029770E+00, 2.1503775380E+00, 9.0508778437E-01],
	[2.9770000000E+04, 1.8428157356E+01, 4.9846900607E+00, 4.7612692639E+00, 2.1509673983E+00, 9.0512915984E-01],
	[2.9775000000E+04, 1.8433229480E+01, 4.9846732625E+00, 4.7638365026E+00, 2.1515571815E+00, 9.0517051633E-01],
	[2.9780000000E+04, 1.8438302148E+01, 4.9846564671E+00, 4.7664046935E+00, 2.1521468874E+00, 9.0521185386E-01],
	[2.9785000000E+04, 1.8443375360E+01, 4.9846396746E+00, 4.7689738366E+00, 2.1527365161E+00, 9.0525317243E-01],
	[2.9790000000E+04, 1.8448449116E+01, 4.9846228850E+00, 4.7715439321E+00, 2.1533260674E+00, 9.0529447205E-01],
	[2.9795000000E+04, 1.8453523416E+01, 4.9846060983E+00, 4.7741149803E+00, 2.1539155414E+00, 9.0533575273E-01],
	[2.9800000000E+04, 1.8458598260E+01, 4.9845893145E+00, 4.7766869814E+00, 2.1545049379E+00, 9.0537701449E-01],
	[2.9805000000E+04, 1.8463673647E+01, 4.9845725335E+00, 4.7792599355E+00, 2.1550942570E+00, 9.0541825731E-01],
	[2.9810000000E+04, 1.8468749579E+01, 4.9845557554E+00, 4.7818338428E+00, 2.1556834986E+00, 9.0545948122E-01],
	[2.9815000000E+04, 1.8473826054E+01, 4.9845389801E+00, 4.7844087035E+00, 2.1562726625E+00, 9.0550068622E-01],
	[2.9820000000E+04, 1.8478903073E+01, 4.9845222078E+00, 4.7869845179E+00, 2.1568617489E+00, 9.0554187233E-01],
	[2.9825000000E+04, 1.8483980636E+01, 4.9845054383E+00, 4.7895612861E+00, 2.1574507575E+00, 9.0558303954E-01],
	[2.9830000000E+04, 1.8489058742E+01, 4.9844886716E+00, 4.7921390082E+00, 2.1580396885E+00, 9.0562418787E-01],
	[2.9835000000E+04, 1.8494137392E+01, 4.9844719079E+00, 4.7947176846E+00, 2.1586285417E+00, 9.0566531732E-01],
	[2.9840000000E+04, 1.8499216586E+01, 4.9844551470E+00, 4.7972973153E+00, 2.1592173170E+00, 9.0570642791E-01],
	[2.9845000000E+04, 1.8504296323E+01, 4.9844383889E+00, 4.7998779006E+00, 2.1598060145E+00, 9.0574751964E-01],
	[2.9850000000E+04, 1.8509376604E+01, 4.9844216338E+00, 4.8024594407E+00, 2.1603946341E+00, 9.0578859252E-01],
	[2.9855000000E+04, 1.8514457428E+01, 4.9844048815E+00, 4.8050419358E+00, 2.1609831757E+00, 9.0582964656E-01],
	[2.9860000000E+04, 1.8519538796E+01, 4.9843881320E+00, 4.8076253860E+00, 2.1615716393E+00, 9.0587068176E-01],
	[2.9865000000E+04, 1.8524620707E+01, 4.9843713854E+00, 4.8102097915E+00, 2.1621600248E+00, 9.0591169813E-01],
	[2.9870000000E+04, 1.8529703162E+01, 4.9843546417E+00, 4.8127951526E+00, 2.1627483322E+00, 9.0595269569E-01],
	[2.9875000000E+04, 1.8534786160E+01, 4.9843379008E+00, 4.8153814695E+00, 2.1633365614E+00, 9.0599367444E-01],
	[2.9880000000E+04, 1.8539869702E+01, 4.9843211628E+00, 4.8179687423E+00, 2.1639247124E+00, 9.0603463439E-01],
	[2.9885000000E+04, 1.8544953786E+01, 4.9843044277E+00, 4.8205569711E+00, 2.1645127852E+00, 9.0607557555E-01],
	[2.9890000000E+04, 1.8550038414E+01, 4.9842876954E+00, 4.8231461563E+00, 2.1651007796E+00, 9.0611649792E-01],
	[2.9895000000E+04, 1.8555123586E+01, 4.9842709659E+00, 4.8257362980E+00, 2.1656886957E+00, 9.0615740151E-01],
	[2.9900000000E+04, 1.8560209300E+01, 4.9842542393E+00, 4.8283273965E+00, 2.1662765334E+00, 9.0619828633E-01],
	[2.9905000000E+04, 1.8565295558E+01, 4.9842375156E+00, 4.8309194518E+00, 2.1668642926E+00, 9.0623915240E-01],
	[2.9910000000E+04, 1.8570391060E+01, 4.9842222317E+00, 4.8335124641E+00, 2.1674523635E+00, 9.0627999971E-01],
	[2.9915000000E+04, 1.8575497340E+01, 4.9842086394E+00, 4.8361064338E+00, 2.1680408152E+00, 9.0632082828E-01],
	[2.9920000000E+04, 1.8580604170E+01, 4.9841950495E+00, 4.8387013609E+00, 2.1686291889E+00, 9.0636163811E-01],
	[2.9925000000E+04, 1.8585711550E+01, 4.9841814619E+00, 4.8412972457E+00, 2.1692174846E+00, 9.0640242921E-01],
	[2.9930000000E+04, 1.8590819481E+01, 4.9841678766E+00, 4.8438940884E+00, 2.1698057023E+00, 9.0644320160E-01],
	[2.9935000000E+04, 1.8595927962E+01, 4.9841542936E+00, 4.8464918891E+00, 2.1703938418E+00, 9.0648395527E-01],
	[2.9940000000E+04, 1.8601036993E+01, 4.9841407129E+00, 4.8490906480E+00, 2.1709819032E+00, 9.0652469024E-01],
	[2.9945000000E+04, 1.8606146574E+01, 4.9841271345E+00, 4.8516903654E+00, 2.1715698863E+00, 9.0656540652E-01],
	[2.9950000000E+04, 1.8611256705E+01, 4.9841135584E+00, 4.8542910414E+00, 2.1721577912E+00, 9.0660610410E-01],
	[2.9955000000E+04, 1.8616367386E+01, 4.9840999846E+00, 4.8568926763E+00, 2.1727456178E+00, 9.0664678301E-01],
	[2.9960000000E+04, 1.8621478618E+01, 4.9840864131E+00, 4.8594952701E+00, 2.1733333661E+00, 9.0668744325E-01],
	[2.9965000000E+04, 1.8626590399E+01, 4.9840728440E+00, 4.8620988232E+00, 2.1739210360E+00, 9.0672808483E-01],
	[2.9970000000E+04, 1.8631702730E+01, 4.9840592771E+00, 4.8647033356E+00, 2.1745086274E+00, 9.0676870775E-01],
	[2.9975000000E+04, 1.8636815612E+01, 4.9840457125E+00, 4.8673088077E+00, 2.1750961403E+00, 9.0680931203E-01],
	[2.9980000000E+04, 1.8641929043E+01, 4.9840321502E+00, 4.8699152395E+00, 2.1756835747E+00, 9.0684989767E-01],
	[2.9985000000E+04, 1.8647043024E+01, 4.9840185902E+00, 4.8725226313E+00, 2.1762709304E+00, 9.0689046468E-01],
	[2.9990000000E+04, 1.8652157555E+01, 4.9840050326E+00, 4.8751309833E+00, 2.1768582076E+00, 9.0693101307E-01],
	[2.9995000000E+04, 1.8657272636E+01, 4.9839914772E+00, 4.8777402957E+00, 2.1774454060E+00, 9.0697154284E-01],
	[3.0000000000E+04, 1.8662388267E+01, 4.9839779241E+00, 4.8803505686E+00, 2.1780325258E+00, 9.0701205401E-01],
	[3.0005000000E+04, 1.8667504447E+01, 4.9839643733E+00, 4.8829781959E+00, 2.1786228301E+00, 9.0705254658E-01],
	[3.0010000000E+04, 1.8672621178E+01, 4.9839508248E+00, 4.8856067990E+00, 2.1792130551E+00, 9.0709302057E-01],
	[3.0015000000E+04, 1.8677738458E+01, 4.9839372786E+00, 4.8882363781E+00, 2.1798032007E+00, 9.0713347597E-01],
	[3.0020000000E+04, 1.8682856287E+01, 4.9839237347E+00, 4.8908669333E+00, 2.1803932668E+00, 9.0717391280E-01],
	[3.0025000000E+04, 1.8687974666E+01, 4.9839101930E+00, 4.8934984649E+00, 2.1809832534E+00, 9.0721433107E-01],
	[3.0030000000E+04, 1.8693093595E+01, 4.9838966537E+00, 4.8961309731E+00, 2.1815731605E+00, 9.0725473078E-01],
	[3.0035000000E+04, 1.8698213074E+01, 4.9838831167E+00, 4.8987644581E+00, 2.1821629880E+00, 9.0729511195E-01],
	[3.0040000000E+04, 1.8703333102E+01, 4.9838695819E+00, 4.9013989201E+00, 2.1827527358E+00, 9.0733547457E-01],
	[3.0045000000E+04, 1.8708453679E+01, 4.9838560495E+00, 4.9040343592E+00, 2.1833424040E+00, 9.0737581866E-01],
	[3.0050000000E+04, 1.8713574806E+01, 4.9838425193E+00, 4.9066707757E+00, 2.1839319924E+00, 9.0741614423E-01],
	[3.0055000000E+04, 1.8718696482E+01, 4.9838289914E+00, 4.9093081698E+00, 2.1845215010E+00, 9.0745645129E-01],
	[3.0060000000E+04, 1.8723818708E+01, 4.9838154658E+00, 4.9119465416E+00, 2.1851109298E+00, 9.0749673983E-01],
	[3.0065000000E+04, 1.8728941483E+01, 4.9838019425E+00, 4.9145858915E+00, 2.1857002787E+00, 9.0753700988E-01],
	[3.0070000000E+04, 1.8734064808E+01, 4.9837884215E+00, 4.9172262195E+00, 2.1862895476E+00, 9.0757726144E-01],
	[3.0075000000E+04, 1.8739188681E+01, 4.9837749028E+00, 4.9198675258E+00, 2.1868787366E+00, 9.0761749452E-01],
	[3.0080000000E+04, 1.8744313105E+01, 4.9837613863E+00, 4.9225098108E+00, 2.1874678455E+00, 9.0765770912E-01],
	[3.0085000000E+04, 1.8749438077E+01, 4.9837478721E+00, 4.9251530745E+00, 2.1880568743E+00, 9.0769790526E-01],
	[3.0090000000E+04, 1.8754563598E+01, 4.9837343602E+00, 4.9277973172E+00, 2.1886458231E+00, 9.0773808293E-01],
	[3.0095000000E+04, 1.8759689669E+01, 4.9837208506E+00, 4.9304425390E+00, 2.1892346916E+00, 9.0777824216E-01],
	[3.0100000000E+04, 1.8764816289E+01, 4.9837073433E+00, 4.9330887402E+00, 2.1898234799E+00, 9.0781838295E-01],
	[3.0105000000E+04, 1.8769943458E+01, 4.9836938383E+00, 4.9357359210E+00, 2.1904121880E+00, 9.0785850530E-01],
	[3.0110000000E+04, 1.8775071176E+01, 4.9836803355E+00, 4.9383840815E+00, 2.1910008157E+00, 9.0789860923E-01],
	[3.0115000000E+04, 1.8780199443E+01, 4.9836668350E+00, 4.9410332221E+00, 2.1915893631E+00, 9.0793869475E-01],
	[3.0120000000E+04, 1.8785328260E+01, 4.9836533368E+00, 4.9436833427E+00, 2.1921778300E+00, 9.0797876185E-01],
	[3.0125000000E+04, 1.8790457625E+01, 4.9836398409E+00, 4.9463344438E+00, 2.1927662165E+00, 9.0801881055E-01],
	[3.0130000000E+04, 1.8795587539E+01, 4.9836263472E+00, 4.9489865254E+00, 2.1933545225E+00, 9.0805884085E-01],
	[3.0135000000E+04, 1.8800718002E+01, 4.9836128558E+00, 4.9516395878E+00, 2.1939427479E+00, 9.0809885277E-01],
	[3.0140000000E+04, 1.8805849014E+01, 4.9835993667E+00, 4.9542936311E+00, 2.1945308928E+00, 9.0813884630E-01],
	[3.0145000000E+04, 1.8810980575E+01, 4.9835858799E+00, 4.9569486556E+00, 2.1951189569E+00, 9.0817882146E-01],
	[3.0150000000E+04, 1.8816112684E+01, 4.9835723953E+00, 4.9596046615E+00, 2.1957069404E+00, 9.0821877826E-01],
	[3.0155000000E+04, 1.8821245343E+01, 4.9835589131E+00, 4.9622616489E+00, 2.1962948431E+00, 9.0825871669E-01],
	[3.0160000000E+04, 1.8826378550E+01, 4.9835454330E+00, 4.9649196181E+00, 2.1968826651E+00, 9.0829863678E-01],
	[3.0165000000E+04, 1.8831512306E+01, 4.9835319553E+00, 4.9675785693E+00, 2.1974704061E+00, 9.0833853852E-01],
	[3.0170000000E+04, 1.8836646610E+01, 4.9835184798E+00, 4.9702385026E+00, 2.1980580663E+00, 9.0837842192E-01],
	[3.0175000000E+04, 1.8841781464E+01, 4.9835050066E+00, 4.9728994182E+00, 2.1986456456E+00, 9.0841828700E-01],
	[3.0180000000E+04, 1.8846916866E+01, 4.9834915357E+00, 4.9755613165E+00, 2.1992331439E+00, 9.0845813375E-01],
	[3.0185000000E+04, 1.8852052816E+01, 4.9834780670E+00, 4.9782241975E+00, 2.1998205612E+00, 9.0849796219E-01],
	[3.0190000000E+04, 1.8857189315E+01, 4.9834646006E+00, 4.9808880614E+00, 2.2004078974E+00, 9.0853777232E-01],
	[3.0195000000E+04, 1.8862326363E+01, 4.9834511365E+00, 4.9835529085E+00, 2.2009951524E+00, 9.0857756415E-01],
	[3.0200000000E+04, 1.8867463959E+01, 4.9834376746E+00, 4.9862187390E+00, 2.2015823263E+00, 9.0861733769E-01],
	[3.0205000000E+04, 1.8872602103E+01, 4.9834242150E+00, 4.9888855530E+00, 2.2021694190E+00, 9.0865709295E-01],
	[3.0210000000E+04, 1.8877740796E+01, 4.9834107577E+00, 4.9915533508E+00, 2.2027564304E+00, 9.0869682993E-01],
	[3.0215000000E+04, 1.8882880038E+01, 4.9833973026E+00, 4.9942221325E+00, 2.2033433605E+00, 9.0873654864E-01],
	[3.0220000000E+04, 1.8888019828E+01, 4.9833838498E+00, 4.9968918984E+00, 2.2039302093E+00, 9.0877624908E-01],
	[3.0225000000E+04, 1.8893160166E+01, 4.9833703992E+00, 4.9995626486E+00, 2.2045169766E+00, 9.0881593127E-01],
	[3.0230000000E+04, 1.8898301052E+01, 4.9833569510E+00, 5.0022343834E+00, 2.2051036626E+00, 9.0885559522E-01],
	[3.0235000000E+04, 1.8903442487E+01, 4.9833435049E+00, 5.0049071030E+00, 2.2056902670E+00, 9.0889524092E-01],
	[3.0240000000E+04, 1.8908584470E+01, 4.9833300612E+00, 5.0075808075E+00, 2.2062767898E+00, 9.0893486839E-01],
	[3.0245000000E+04, 1.8913727001E+01, 4.9833166196E+00, 5.0102554972E+00, 2.2068632311E+00, 9.0897447764E-01],
	[3.0250000000E+04, 1.8918870081E+01, 4.9833031804E+00, 5.0129311722E+00, 2.2074495908E+00, 9.0901406866E-01],
	[3.0255000000E+04, 1.8924013708E+01, 4.9832897434E+00, 5.0156078328E+00, 2.2080358688E+00, 9.0905364148E-01],
	[3.0260000000E+04, 1.8929157884E+01, 4.9832763087E+00, 5.0182854791E+00, 2.2086220650E+00, 9.0909319610E-01],
	[3.0265000000E+04, 1.8934302608E+01, 4.9832628762E+00, 5.0209641113E+00, 2.2092081795E+00, 9.0913273251E-01],
	[3.0270000000E+04, 1.8939447879E+01, 4.9832494460E+00, 5.0236437298E+00, 2.2097942122E+00, 9.0917225074E-01],
	[3.0275000000E+04, 1.8944593699E+01, 4.9832360180E+00, 5.0263243345E+00, 2.2103801630E+00, 9.0921175079E-01],
	[3.0280000000E+04, 1.8949740067E+01, 4.9832225923E+00, 5.0290059259E+00, 2.2109660318E+00, 9.0925123267E-01],
	[3.0285000000E+04, 1.8954886983E+01, 4.9832091688E+00, 5.0316885040E+00, 2.2115518188E+00, 9.0929069638E-01],
	[3.0290000000E+04, 1.8960034447E+01, 4.9831957476E+00, 5.0343720690E+00, 2.2121375237E+00, 9.0933014193E-01],
	[3.0295000000E+04, 1.8965182458E+01, 4.9831823286E+00, 5.0370566212E+00, 2.2127231466E+00, 9.0936956933E-01],
	[3.0300000000E+04, 1.8970331018E+01, 4.9831689119E+00, 5.0397421607E+00, 2.2133086874E+00, 9.0940897859E-01],
	[3.0305000000E+04, 1.8975480125E+01, 4.9831554974E+00, 5.0424286878E+00, 2.2138941461E+00, 9.0944836971E-01],
	[3.0310000000E+04, 1.8980629780E+01, 4.9831420852E+00, 5.0451162026E+00, 2.2144795225E+00, 9.0948774270E-01],
	[3.0315000000E+04, 1.8985779983E+01, 4.9831286753E+00, 5.0478047054E+00, 2.2150648168E+00, 9.0952709757E-01],
	[3.0320000000E+04, 1.8990930733E+01, 4.9831152676E+00, 5.0504941963E+00, 2.2156500288E+00, 9.0956643433E-01],
	[3.0325000000E+04, 1.8996082032E+01, 4.9831018621E+00, 5.0531846756E+00, 2.2162351584E+00, 9.0960575298E-01],
	[3.0330000000E+04, 1.9001233877E+01, 4.9830884589E+00, 5.0558761434E+00, 2.2168202057E+00, 9.0964505353E-01],
	[3.0335000000E+04, 1.9006386271E+01, 4.9830750579E+00, 5.0585686000E+00, 2.2174051706E+00, 9.0968433600E-01],
	[3.0340000000E+04, 1.9011539212E+01, 4.9830616592E+00, 5.0612620455E+00, 2.2179900530E+00, 9.0972360037E-01],
	[3.0345000000E+04, 1.9016692701E+01, 4.9830482627E+00, 5.0639564801E+00, 2.2185748530E+00, 9.0976284667E-01],
	[3.0350000000E+04, 1.9021846737E+01, 4.9830348684E+00, 5.0666519042E+00, 2.2191595704E+00, 9.0980207490E-01],
	[3.0355000000E+04, 1.9027001321E+01, 4.9830214764E+00, 5.0693483177E+00, 2.2197442052E+00, 9.0984128507E-01],
	[3.0360000000E+04, 1.9032156452E+01, 4.9830080867E+00, 5.0720457210E+00, 2.2203287573E+00, 9.0988047719E-01],
	[3.0365000000E+04, 1.9037312131E+01, 4.9829946991E+00, 5.0747441143E+00, 2.2209132268E+00, 9.0991965126E-01],
	[3.0370000000E+04, 1.9042468357E+01, 4.9829813139E+00, 5.0774434977E+00, 2.2214976135E+00, 9.0995880729E-01],
	[3.0375000000E+04, 1.9047625131E+01, 4.9829679308E+00, 5.0801438714E+00, 2.2220819175E+00, 9.0999794529E-01],
	[3.0380000000E+04, 1.9052782451E+01, 4.9829545500E+00, 5.0828452357E+00, 2.2226661387E+00, 9.1003706526E-01],
	[3.0385000000E+04, 1.9057940320E+01, 4.9829411714E+00, 5.0855475907E+00, 2.2232502770E+00, 9.1007616722E-01],
	[3.0390000000E+04, 1.9063101837E+01, 4.9829283010E+00, 5.0882509367E+00, 2.2238344754E+00, 9.1011525117E-01],
	[3.0395000000E+04, 1.9068279602E+01, 4.9829179928E+00, 5.0909552738E+00, 2.2244193147E+00, 9.1015431711E-01],
	[3.0400000000E+04, 1.9073457922E+01, 4.9829076863E+00, 5.0936606023E+00, 2.2250040717E+00, 9.1019336506E-01],
	[3.0405000000E+04, 1.9078636796E+01, 4.9828973815E+00, 5.0963669223E+00, 2.2255887463E+00, 9.1023239503E-01],
	[3.0410000000E+04, 1.9083816224E+01, 4.9828870784E+00, 5.0990742341E+00, 2.2261733384E+00, 9.1027140701E-01],
	[3.0415000000E+04, 1.9088996206E+01, 4.9828767770E+00, 5.1017825378E+00, 2.2267578481E+00, 9.1031040103E-01],
	[3.0420000000E+04, 1.9094176743E+01, 4.9828664774E+00, 5.1044918336E+00, 2.2273422752E+00, 9.1034937708E-01],
	[3.0425000000E+04, 1.9099357833E+01, 4.9828561794E+00, 5.1072021218E+00, 2.2279266197E+00, 9.1038833517E-01],
	[3.0430000000E+04, 1.9104539478E+01, 4.9828458832E+00, 5.1099134026E+00, 2.2285108816E+00, 9.1042727531E-01],
	[3.0435000000E+04, 1.9109721677E+01, 4.9828355887E+00, 5.1126256761E+00, 2.2290950608E+00, 9.1046619751E-01],
	[3.0440000000E+04, 1.9114904430E+01, 4.9828252959E+00, 5.1153389425E+00, 2.2296791573E+00, 9.1050510178E-01],
	[3.0445000000E+04, 1.9120087737E+01, 4.9828150048E+00, 5.1180532021E+00, 2.2302631710E+00, 9.1054398812E-01],
	[3.0450000000E+04, 1.9125271598E+01, 4.9828047154E+00, 5.1207684550E+00, 2.2308471020E+00, 9.1058285653E-01],
	[3.0455000000E+04, 1.9130456014E+01, 4.9827944278E+00, 5.1234847014E+00, 2.2314309501E+00, 9.1062170704E-01],
	[3.0460000000E+04, 1.9135640982E+01, 4.9827841418E+00, 5.1262019416E+00, 2.2320147153E+00, 9.1066053964E-01],
	[3.0465000000E+04, 1.9140826505E+01, 4.9827738576E+00, 5.1289201758E+00, 2.2325983975E+00, 9.1069935435E-01],
	[3.0470000000E+04, 1.9146012582E+01, 4.9827635750E+00, 5.1316394040E+00, 2.2331819968E+00, 9.1073815117E-01],
	[3.0475000000E+04, 1.9151199213E+01, 4.9827532942E+00, 5.1343596267E+00, 2.2337655130E+00, 9.1077693010E-01],
	[3.0480000000E+04, 1.9156386397E+01, 4.9827430151E+00, 5.1370808439E+00, 2.2343489462E+00, 9.1081569116E-01],
	[3.0485000000E+04, 1.9161574135E+01, 4.9827327377E+00, 5.1398030558E+00, 2.2349322963E+00, 9.1085443435E-01],
	[3.0490000000E+04, 1.9166762427E+01, 4.9827224619E+00, 5.1425262626E+00, 2.2355155632E+00, 9.1089315968E-01],
	[3.0495000000E+04, 1.9171951273E+01, 4.9827121879E+00, 5.1452504646E+00, 2.2360987469E+00, 9.1093186716E-01],
	[3.0500000000E+04, 1.9177140672E+01, 4.9827019157E+00, 5.1479756620E+00, 2.2366818474E+00, 9.1097055680E-01],
	[3.0505000000E+04, 1.9182330625E+01, 4.9826916451E+00, 5.1507018549E+00, 2.2372648645E+00, 9.1100922860E-01],
	[3.0510000000E+04, 1.9187521132E+01, 4.9826813762E+00, 5.1534290435E+00, 2.2378477984E+00, 9.1104788256E-01],
	[3.0515000000E+04, 1.9192712192E+01, 4.9826711090E+00, 5.1561572281E+00, 2.2384306489E+00, 9.1108651871E-01],
	[3.0520000000E+04, 1.9197903806E+01, 4.9826608435E+00, 5.1588864088E+00, 2.2390134159E+00, 9.1112513704E-01],
	[3.0525000000E+04, 1.9203095973E+01, 4.9826505797E+00, 5.1616165858E+00, 2.2395960995E+00, 9.1116373757E-01],
	[3.0530000000E+04, 1.9208288694E+01, 4.9826403177E+00, 5.1643477595E+00, 2.2401786996E+00, 9.1120232029E-01],
	[3.0535000000E+04, 1.9213481968E+01, 4.9826300573E+00, 5.1670799298E+00, 2.2407612162E+00, 9.1124088522E-01],
	[3.0540000000E+04, 1.9218675796E+01, 4.9826197986E+00, 5.1698130971E+00, 2.2413436491E+00, 9.1127943237E-01],
	[3.0545000000E+04, 1.9223870177E+01, 4.9826095417E+00, 5.1725472615E+00, 2.2419259984E+00, 9.1131796174E-01],
	[3.0550000000E+04, 1.9229065111E+01, 4.9825992864E+00, 5.1752824233E+00, 2.2425082641E+00, 9.1135647335E-01],
	[3.0555000000E+04, 1.9234260599E+01, 4.9825890328E+00, 5.1780185826E+00, 2.2430904460E+00, 9.1139496718E-01],
	[3.0560000000E+04, 1.9239456640E+01, 4.9825787809E+00, 5.1807557397E+00, 2.2436725441E+00, 9.1143344327E-01],
	[3.0565000000E+04, 1.9244653235E+01, 4.9825685308E+00, 5.1834938947E+00, 2.2442545585E+00, 9.1147190161E-01],
	[3.0570000000E+04, 1.9249850382E+01, 4.9825582823E+00, 5.1862330478E+00, 2.2448364890E+00, 9.1151034220E-01],
	[3.0575000000E+04, 1.9255048083E+01, 4.9825480355E+00, 5.1889731993E+00, 2.2454183356E+00, 9.1154876507E-01],
	[3.0580000000E+04, 1.9260246337E+01, 4.9825377904E+00, 5.1917143494E+00, 2.2460000983E+00, 9.1158717021E-01],
	[3.0585000000E+04, 1.9265445144E+01, 4.9825275470E+00, 5.1944564981E+00, 2.2465817770E+00, 9.1162555764E-01],
	[3.0590000000E+04, 1.9270644504E+01, 4.9825173053E+00, 5.1971996459E+00, 2.2471633717E+00, 9.1166392735E-01],
	[3.0595000000E+04, 1.9275844418E+01, 4.9825070654E+00, 5.1999437927E+00, 2.2477448823E+00, 9.1170227936E-01],
	[3.0600000000E+04, 1.9281044884E+01, 4.9824968270E+00, 5.2026889390E+00, 2.2483263088E+00, 9.1174061368E-01],
	[3.0605000000E+04, 1.9286245903E+01, 4.9824865904E+00, 5.2054350847E+00, 2.2489076511E+00, 9.1177893031E-01],
	[3.0610000000E+04, 1.9291447476E+01, 4.9824763555E+00, 5.2081822302E+00, 2.2494889093E+00, 9.1181722926E-01],
	[3.0615000000E+04, 1.9296649601E+01, 4.9824661223E+00, 5.2109303757E+00, 2.2500700833E+00, 9.1185551054E-01],
	[3.0620000000E+04, 1.9301852279E+01, 4.9824558908E+00, 5.2136795212E+00, 2.2506511729E+00, 9.1189377416E-01],
	[3.0625000000E+04, 1.9307055511E+01, 4.9824456609E+00, 5.2164296672E+00, 2.2512321783E+00, 9.1193202012E-01],
	[3.0630000000E+04, 1.9312259295E+01, 4.9824354328E+00, 5.2191808137E+00, 2.2518130993E+00, 9.1197024843E-01],
	[3.0635000000E+04, 1.9317463631E+01, 4.9824252063E+00, 5.2219329609E+00, 2.2523939358E+00, 9.1200845909E-01],
	[3.0640000000E+04, 1.9322668521E+01, 4.9824149816E+00, 5.2246861090E+00, 2.2529746880E+00, 9.1204665213E-01],
	[3.0645000000E+04, 1.9327873963E+01, 4.9824047585E+00, 5.2274402584E+00, 2.2535553556E+00, 9.1208482753E-01],
	[3.0650000000E+04, 1.9333079959E+01, 4.9823945371E+00, 5.2301954090E+00, 2.2541359388E+00, 9.1212298532E-01],
	[3.0655000000E+04, 1.9338286506E+01, 4.9823843174E+00, 5.2329515612E+00, 2.2547164373E+00, 9.1216112549E-01],
	[3.0660000000E+04, 1.9343493607E+01, 4.9823740994E+00, 5.2357087152E+00, 2.2552968513E+00, 9.1219924807E-01],
	[3.0665000000E+04, 1.9348701260E+01, 4.9823638831E+00, 5.2384668711E+00, 2.2558771805E+00, 9.1223735304E-01],
	[3.0670000000E+04, 1.9353909466E+01, 4.9823536684E+00, 5.2412260291E+00, 2.2564574251E+00, 9.1227544042E-01],
	[3.0675000000E+04, 1.9359118224E+01, 4.9823434555E+00, 5.2439861895E+00, 2.2570375850E+00, 9.1231351023E-01],
	[3.0680000000E+04, 1.9364327535E+01, 4.9823332442E+00, 5.2467473525E+00, 2.2576176601E+00, 9.1235156246E-01],
	[3.0685000000E+04, 1.9369537399E+01, 4.9823230346E+00, 5.2495095181E+00, 2.2581976503E+00, 9.1238959712E-01],
	[3.0690000000E+04, 1.9374747815E+01, 4.9823128267E+00, 5.2522726868E+00, 2.2587775557E+00, 9.1242761422E-01],
	[3.0695000000E+04, 1.9379958783E+01, 4.9823026205E+00, 5.2550368586E+00, 2.2593573762E+00, 9.1246561378E-01],
	[3.0700000000E+04, 1.9385170304E+01, 4.9822924160E+00, 5.2578020337E+00, 2.2599371117E+00, 9.1250359578E-01],
	[3.0705000000E+04, 1.9390382377E+01, 4.9822822131E+00, 5.2605682124E+00, 2.2605167623E+00, 9.1254156025E-01],
	[3.0710000000E+04, 1.9395595002E+01, 4.9822720120E+00, 5.2633353948E+00, 2.2610963278E+00, 9.1257950720E-01],
	[3.0715000000E+04, 1.9400808180E+01, 4.9822618125E+00, 5.2661035812E+00, 2.2616758083E+00, 9.1261743662E-01],
	[3.0720000000E+04, 1.9406021910E+01, 4.9822516147E+00, 5.2688727717E+00, 2.2622552036E+00, 9.1265534853E-01],
	[3.0725000000E+04, 1.9411236193E+01, 4.9822414186E+00, 5.2716429666E+00, 2.2628345138E+00, 9.1269324293E-01],
	[3.0730000000E+04, 1.9416451027E+01, 4.9822312241E+00, 5.2744141660E+00, 2.2634137388E+00, 9.1273111983E-01],
	[3.0735000000E+04, 1.9421666414E+01, 4.9822210313E+00, 5.2771863701E+00, 2.2639928785E+00, 9.1276897924E-01],
	[3.0740000000E+04, 1.9426882353E+01, 4.9822108403E+00, 5.2799595793E+00, 2.2645719330E+00, 9.1280682117E-01],
	[3.0745000000E+04, 1.9432098845E+01, 4.9822006509E+00, 5.2827337935E+00, 2.2651509022E+00, 9.1284464562E-01],
	[3.0750000000E+04, 1.9437315888E+01, 4.9821904631E+00, 5.2855090132E+00, 2.2657297860E+00, 9.1288245260E-01],
	[3.0755000000E+04, 1.9442533483E+01, 4.9821802771E+00, 5.2882852383E+00, 2.2663085844E+00, 9.1292024212E-01],
	[3.0760000000E+04, 1.9447751631E+01, 4.9821700927E+00, 5.2910624693E+00, 2.2668872974E+00, 9.1295801419E-01],
	[3.0765000000E+04, 1.9452970330E+01, 4.9821599100E+00, 5.2938407061E+00, 2.2674659248E+00, 9.1299576881E-01],
	[3.0770000000E+04, 1.9458189581E+01, 4.9821497290E+00, 5.2966199492E+00, 2.2680444668E+00, 9.1303350600E-01],
	[3.0775000000E+04, 1.9463409385E+01, 4.9821395496E+00, 5.2994001985E+00, 2.2686229232E+00, 9.1307122575E-01],
	[3.0780000000E+04, 1.9468629740E+01, 4.9821293720E+00, 5.3021814545E+00, 2.2692012940E+00, 9.1310892808E-01],
	[3.0785000000E+04, 1.9473850647E+01, 4.9821191960E+00, 5.3049637172E+00, 2.2697795791E+00, 9.1314661299E-01],
	[3.0790000000E+04, 1.9479072106E+01, 4.9821090216E+00, 5.3077469868E+00, 2.2703577786E+00, 9.1318428050E-01],
	[3.0795000000E+04, 1.9484294117E+01, 4.9820988490E+00, 5.3105312636E+00, 2.2709358923E+00, 9.1322193060E-01],
	[3.0800000000E+04, 1.9489516680E+01, 4.9820886780E+00, 5.3133165478E+00, 2.2715139203E+00, 9.1325956331E-01],
	[3.0805000000E+04, 1.9494739794E+01, 4.9820785087E+00, 5.3161028395E+00, 2.2720918625E+00, 9.1329717864E-01],
	[3.0810000000E+04, 1.9499963460E+01, 4.9820683411E+00, 5.3188901389E+00, 2.2726697188E+00, 9.1333477658E-01],
	[3.0815000000E+04, 1.9505187678E+01, 4.9820581751E+00, 5.3216784463E+00, 2.2732474892E+00, 9.1337235716E-01],
	[3.0820000000E+04, 1.9510412447E+01, 4.9820480108E+00, 5.3244677619E+00, 2.2738251737E+00, 9.1340992037E-01],
	[3.0825000000E+04, 1.9515637768E+01, 4.9820378482E+00, 5.3272580859E+00, 2.2744027723E+00, 9.1344746623E-01],
	[3.0830000000E+04, 1.9520863641E+01, 4.9820276872E+00, 5.3300494183E+00, 2.2749802848E+00, 9.1348499474E-01],
	[3.0835000000E+04, 1.9526090065E+01, 4.9820175279E+00, 5.3328417596E+00, 2.2755577113E+00, 9.1352250591E-01],
	[3.0840000000E+04, 1.9531317041E+01, 4.9820073703E+00, 5.3356351098E+00, 2.2761350517E+00, 9.1355999975E-01],
	[3.0845000000E+04, 1.9536544569E+01, 4.9819972143E+00, 5.3384294691E+00, 2.2767123059E+00, 9.1359747626E-01],
	[3.0850000000E+04, 1.9541772648E+01, 4.9819870601E+00, 5.3412248379E+00, 2.2772894740E+00, 9.1363493546E-01],
	[3.0855000000E+04, 1.9547001278E+01, 4.9819769074E+00, 5.3440212161E+00, 2.2778665559E+00, 9.1367237734E-01],
	[3.0860000000E+04, 1.9552230460E+01, 4.9819667565E+00, 5.3468186042E+00, 2.2784435515E+00, 9.1370980192E-01],
	[3.0865000000E+04, 1.9557460193E+01, 4.9819566072E+00, 5.3496170022E+00, 2.2790204609E+00, 9.1374720921E-01],
	[3.0870000000E+04, 1.9562690477E+01, 4.9819464596E+00, 5.3524164104E+00, 2.2795972839E+00, 9.1378459921E-01],
	[3.0875000000E+04, 1.9567921313E+01, 4.9819363136E+00, 5.3552168289E+00, 2.2801740205E+00, 9.1382197193E-01],
	[3.0880000000E+04, 1.9573158666E+01, 4.9819271312E+00, 5.3580182580E+00, 2.2807509534E+00, 9.1385932737E-01],
	[3.0885000000E+04, 1.9578409246E+01, 4.9819199930E+00, 5.3608206978E+00, 2.2813284004E+00, 9.1389666555E-01],
	[3.0890000000E+04, 1.9583660383E+01, 4.9819128559E+00, 5.3636241486E+00, 2.2819057615E+00, 9.1393398648E-01],
	[3.0895000000E+04, 1.9588912079E+01, 4.9819057200E+00, 5.3664286106E+00, 2.2824830368E+00, 9.1397129015E-01],
	[3.0900000000E+04, 1.9594164333E+01, 4.9818985853E+00, 5.3692340839E+00, 2.2830602260E+00, 9.1400857658E-01],
	[3.0905000000E+04, 1.9599417146E+01, 4.9818914517E+00, 5.3720405688E+00, 2.2836373293E+00, 9.1404584578E-01],
	[3.0910000000E+04, 1.9604670516E+01, 4.9818843193E+00, 5.3748480655E+00, 2.2842143466E+00, 9.1408309775E-01],
	[3.0915000000E+04, 1.9609924444E+01, 4.9818771881E+00, 5.3776565741E+00, 2.2847912778E+00, 9.1412033250E-01],
	[3.0920000000E+04, 1.9615178931E+01, 4.9818700580E+00, 5.3804660949E+00, 2.2853681228E+00, 9.1415755004E-01],
	[3.0925000000E+04, 1.9620433975E+01, 4.9818629291E+00, 5.3832766281E+00, 2.2859448818E+00, 9.1419475038E-01],
	[3.0930000000E+04, 1.9625689577E+01, 4.9818558014E+00, 5.3860881738E+00, 2.2865215545E+00, 9.1423193351E-01],
	[3.0935000000E+04, 1.9630945737E+01, 4.9818486748E+00, 5.3889007323E+00, 2.2870981410E+00, 9.1426909946E-01],
	[3.0940000000E+04, 1.9636202455E+01, 4.9818415494E+00, 5.3917143038E+00, 2.2876746413E+00, 9.1430624823E-01],
	[3.0945000000E+04, 1.9641459731E+01, 4.9818344251E+00, 5.3945288885E+00, 2.2882510553E+00, 9.1434337982E-01],
	[3.0950000000E+04, 1.9646717565E+01, 4.9818273020E+00, 5.3973444865E+00, 2.2888273829E+00, 9.1438049425E-01],
	[3.0955000000E+04, 1.9651975956E+01, 4.9818201801E+00, 5.4001610981E+00, 2.2894036241E+00, 9.1441759151E-01],
	[3.0960000000E+04, 1.9657234906E+01, 4.9818130593E+00, 5.4029787234E+00, 2.2899797789E+00, 9.1445467163E-01],
	[3.0965000000E+04, 1.9662494413E+01, 4.9818059397E+00, 5.4057973627E+00, 2.2905558473E+00, 9.1449173460E-01],
	[3.0970000000E+04, 1.9667754477E+01, 4.9817988212E+00, 5.4086170162E+00, 2.2911318291E+00, 9.1452878043E-01],
	[3.0975000000E+04, 1.9673015100E+01, 4.9817917039E+00, 5.4114376841E+00, 2.2917077245E+00, 9.1456580914E-01],
	[3.0980000000E+04, 1.9678276280E+01, 4.9817845878E+00, 5.4142593665E+00, 2.2922835332E+00, 9.1460282072E-01],
	[3.0985000000E+04, 1.9683538017E+01, 4.9817774728E+00, 5.4170820638E+00, 2.2928592553E+00, 9.1463981519E-01],
	[3.0990000000E+04, 1.9688800313E+01, 4.9817703590E+00, 5.4199057760E+00, 2.2934348908E+00, 9.1467679256E-01],
	[3.0995000000E+04, 1.9694063165E+01, 4.9817632463E+00, 5.4227305033E+00, 2.2940104396E+00, 9.1471375282E-01],
	[3.1000000000E+04, 1.9699326575E+01, 4.9817561348E+00, 5.4255562461E+00, 2.2945859017E+00, 9.1475069600E-01],
	[3.1005000000E+04, 1.9704590543E+01, 4.9817490244E+00, 5.4283830044E+00, 2.2951612769E+00, 9.1478762209E-01],
	[3.1010000000E+04, 1.9709855068E+01, 4.9817419153E+00, 5.4312107785E+00, 2.2957365654E+00, 9.1482453111E-01],
	[3.1015000000E+04, 1.9715120151E+01, 4.9817348072E+00, 5.4340395686E+00, 2.2963117671E+00, 9.1486142305E-01],
	[3.1020000000E+04, 1.9720385791E+01, 4.9817277003E+00, 5.4368693748E+00, 2.2968868818E+00, 9.1489829794E-01],
	[3.1025000000E+04, 1.9725651988E+01, 4.9817205946E+00, 5.4397001975E+00, 2.2974619096E+00, 9.1493515577E-01],
	[3.1030000000E+04, 1.9730918743E+01, 4.9817134900E+00, 5.4425320367E+00, 2.2980368505E+00, 9.1497199656E-01],
	[3.1035000000E+04, 1.9736186055E+01, 4.9817063866E+00, 5.4453648927E+00, 2.2986117044E+00, 9.1500882031E-01],
	[3.1040000000E+04, 1.9741453924E+01, 4.9816992844E+00, 5.4481987657E+00, 2.2991864712E+00, 9.1504562702E-01],
	[3.1045000000E+04, 1.9746722351E+01, 4.9816921833E+00, 5.4510336559E+00, 2.2997611509E+00, 9.1508241672E-01],
	[3.1050000000E+04, 1.9751991334E+01, 4.9816850833E+00, 5.4538695634E+00, 2.3003357436E+00, 9.1511918940E-01],
	[3.1055000000E+04, 1.9757260875E+01, 4.9816779845E+00, 5.4567064886E+00, 2.3009102491E+00, 9.1515594507E-01],
	[3.1060000000E+04, 1.9762530973E+01, 4.9816708869E+00, 5.4595444315E+00, 2.3014846674E+00, 9.1519268374E-01],
	[3.1065000000E+04, 1.9767801628E+01, 4.9816637904E+00, 5.4623833924E+00, 2.3020589984E+00, 9.1522940542E-01],
	[3.1070000000E+04, 1.9773072841E+01, 4.9816566950E+00, 5.4652233715E+00, 2.3026332422E+00, 9.1526611011E-01],
	[3.1075000000E+04, 1.9778344610E+01, 4.9816496008E+00, 5.4680643690E+00, 2.3032073987E+00, 9.1530279783E-01],
	[3.1080000000E+04, 1.9783616936E+01, 4.9816425078E+00, 5.4709063850E+00, 2.3037814679E+00, 9.1533946857E-01],
	[3.1085000000E+04, 1.9788889819E+01, 4.9816354159E+00, 5.4737494199E+00, 2.3043554497E+00, 9.1537612235E-01],
	[3.1090000000E+04, 1.9794163260E+01, 4.9816283252E+00, 5.4765934738E+00, 2.3049293441E+00, 9.1541275918E-01],
	[3.1095000000E+04, 1.9799437257E+01, 4.9816212356E+00, 5.4794385468E+00, 2.3055031510E+00, 9.1544937906E-01],
	[3.1100000000E+04, 1.9804711811E+01, 4.9816141471E+00, 5.4822846392E+00, 2.3060768704E+00, 9.1548598200E-01],
	[3.1105000000E+04, 1.9809986922E+01, 4.9816070598E+00, 5.4851317513E+00, 2.3066505023E+00, 9.1552256801E-01],
	[3.1110000000E+04, 1.9815262590E+01, 4.9815999737E+00, 5.4879798831E+00, 2.3072240466E+00, 9.1555913709E-01],
	[3.1115000000E+04, 1.9820538814E+01, 4.9815928887E+00, 5.4908290349E+00, 2.3077975033E+00, 9.1559568925E-01],
	[3.1120000000E+04, 1.9825815596E+01, 4.9815858049E+00, 5.4936792069E+00, 2.3083708724E+00, 9.1563222451E-01],
	[3.1125000000E+04, 1.9831092934E+01, 4.9815787222E+00, 5.4965303993E+00, 2.3089441538E+00, 9.1566874286E-01],
	[3.1130000000E+04, 1.9836370828E+01, 4.9815716406E+00, 5.4993826123E+00, 2.3095173475E+00, 9.1570524432E-01],
	[3.1135000000E+04, 1.9841649280E+01, 4.9815645602E+00, 5.5022358461E+00, 2.3100904534E+00, 9.1574172889E-01],
	[3.1140000000E+04, 1.9846928288E+01, 4.9815574810E+00, 5.5050901009E+00, 2.3106634715E+00, 9.1577819659E-01],
	[3.1145000000E+04, 1.9852207853E+01, 4.9815504029E+00, 5.5079453769E+00, 2.3112364019E+00, 9.1581464741E-01],
	[3.1150000000E+04, 1.9857487974E+01, 4.9815433259E+00, 5.5108016743E+00, 2.3118092443E+00, 9.1585108136E-01],
	[3.1155000000E+04, 1.9862768652E+01, 4.9815362501E+00, 5.5136589933E+00, 2.3123819989E+00, 9.1588749846E-01],
	[3.1160000000E+04, 1.9868049886E+01, 4.9815291755E+00, 5.5165173341E+00, 2.3129546655E+00, 9.1592389871E-01],
	[3.1165000000E+04, 1.9873331677E+01, 4.9815221019E+00, 5.5193766970E+00, 2.3135272441E+00, 9.1596028212E-01],
	[3.1170000000E+04, 1.9878614025E+01, 4.9815150296E+00, 5.5222370820E+00, 2.3140997347E+00, 9.1599664869E-01],
	[3.1175000000E+04, 1.9883896929E+01, 4.9815079583E+00, 5.5250984894E+00, 2.3146721373E+00, 9.1603299844E-01],
	[3.1180000000E+04, 1.9889180389E+01, 4.9815008882E+00, 5.5279609194E+00, 2.3152444517E+00, 9.1606933137E-01],
	[3.1185000000E+04, 1.9894464406E+01, 4.9814938193E+00, 5.5308243722E+00, 2.3158166781E+00, 9.1610564749E-01],
	[3.1190000000E+04, 1.9899748979E+01, 4.9814867515E+00, 5.5336888481E+00, 2.3163888163E+00, 9.1614194680E-01],
	[3.1195000000E+04, 1.9905034108E+01, 4.9814796848E+00, 5.5365543471E+00, 2.3169608663E+00, 9.1617822932E-01],
	[3.1200000000E+04, 1.9910319793E+01, 4.9814726193E+00, 5.5394208696E+00, 2.3175328281E+00, 9.1621449504E-01],
	[3.1205000000E+04, 1.9915606035E+01, 4.9814655549E+00, 5.5422884157E+00, 2.3181047016E+00, 9.1625074399E-01],
	[3.1210000000E+04, 1.9920892833E+01, 4.9814584917E+00, 5.5451569855E+00, 2.3186764868E+00, 9.1628697616E-01],
	[3.1215000000E+04, 1.9926180187E+01, 4.9814514296E+00, 5.5480265794E+00, 2.3192481836E+00, 9.1632319157E-01],
	[3.1220000000E+04, 1.9931468098E+01, 4.9814443687E+00, 5.5508971975E+00, 2.3198197921E+00, 9.1635939022E-01],
	[3.1225000000E+04, 1.9936756564E+01, 4.9814373089E+00, 5.5537688401E+00, 2.3203913121E+00, 9.1639557212E-01],
	[3.1230000000E+04, 1.9942045587E+01, 4.9814302502E+00, 5.5566415072E+00, 2.3209627437E+00, 9.1643173727E-01],
	[3.1235000000E+04, 1.9947335166E+01, 4.9814231927E+00, 5.5595151992E+00, 2.3215340869E+00, 9.1646788569E-01],
	[3.1240000000E+04, 1.9952625300E+01, 4.9814161363E+00, 5.5623899161E+00, 2.3221053415E+00, 9.1650401738E-01],
	[3.1245000000E+04, 1.9957915991E+01, 4.9814090810E+00, 5.5652656583E+00, 2.3226765075E+00, 9.1654013235E-01],
	[3.1250000000E+04, 1.9963207238E+01, 4.9814020269E+00, 5.5681424259E+00, 2.3232475849E+00, 9.1657623060E-01],
	[3.1255000000E+04, 1.9968499041E+01, 4.9813949740E+00, 5.5710202192E+00, 2.3238185737E+00, 9.1661231215E-01],
	[3.1260000000E+04, 1.9973791399E+01, 4.9813879221E+00, 5.5738990382E+00, 2.3243894739E+00, 9.1664837700E-01],
	[3.1265000000E+04, 1.9979084314E+01, 4.9813808714E+00, 5.5767788833E+00, 2.3249602853E+00, 9.1668442517E-01],
	[3.1270000000E+04, 1.9984377784E+01, 4.9813738219E+00, 5.5796597546E+00, 2.3255310080E+00, 9.1672045664E-01],
	[3.1275000000E+04, 1.9989671810E+01, 4.9813667735E+00, 5.5825416524E+00, 2.3261016419E+00, 9.1675647145E-01],
	[3.1280000000E+04, 1.9994966392E+01, 4.9813597262E+00, 5.5854245767E+00, 2.3266721870E+00, 9.1679246958E-01],
	[3.1285000000E+04, 2.0000261530E+01, 4.9813526800E+00, 5.5883085279E+00, 2.3272426433E+00, 9.1682845105E-01],
	[3.1290000000E+04, 2.0005557223E+01, 4.9813456350E+00, 5.5911935061E+00, 2.3278130106E+00, 9.1686441588E-01],
	[3.1295000000E+04, 2.0010853473E+01, 4.9813385911E+00, 5.5940795116E+00, 2.3283832891E+00, 9.1690036405E-01],
	[3.1300000000E+04, 2.0016150277E+01, 4.9813315484E+00, 5.5969665444E+00, 2.3289534786E+00, 9.1693629559E-01],
	[3.1305000000E+04, 2.0021447638E+01, 4.9813245068E+00, 5.5998546049E+00, 2.3295235791E+00, 9.1697221050E-01],
	[3.1310000000E+04, 2.0026745554E+01, 4.9813174663E+00, 5.6027436933E+00, 2.3300935906E+00, 9.1700810878E-01],
	[3.1315000000E+04, 2.0032044026E+01, 4.9813104270E+00, 5.6056338097E+00, 2.3306635130E+00, 9.1704399045E-01],
	[3.1320000000E+04, 2.0037343053E+01, 4.9813033888E+00, 5.6085249543E+00, 2.3312333463E+00, 9.1707985552E-01],
	[3.1325000000E+04, 2.0042642636E+01, 4.9812963517E+00, 5.6114171273E+00, 2.3318030905E+00, 9.1711570398E-01],
	[3.1330000000E+04, 2.0047942774E+01, 4.9812893158E+00, 5.6143103290E+00, 2.3323727455E+00, 9.1715153585E-01],
	[3.1335000000E+04, 2.0053243468E+01, 4.9812822810E+00, 5.6172045595E+00, 2.3329423114E+00, 9.1718735114E-01],
	[3.1340000000E+04, 2.0058544717E+01, 4.9812752473E+00, 5.6200998191E+00, 2.3335117879E+00, 9.1722314984E-01],
	[3.1345000000E+04, 2.0063846521E+01, 4.9812682148E+00, 5.6229961079E+00, 2.3340811753E+00, 9.1725893198E-01],
	[3.1350000000E+04, 2.0069148881E+01, 4.9812611834E+00, 5.6258934261E+00, 2.3346504733E+00, 9.1729469756E-01],
	[3.1355000000E+04, 2.0074451796E+01, 4.9812541531E+00, 5.6287917740E+00, 2.3352196819E+00, 9.1733044658E-01],
	[3.1360000000E+04, 2.0079755267E+01, 4.9812471239E+00, 5.6316911518E+00, 2.3357888012E+00, 9.1736617905E-01],
	[3.1365000000E+04, 2.0085059293E+01, 4.9812400959E+00, 5.6345915595E+00, 2.3363578311E+00, 9.1740189499E-01],
	[3.1370000000E+04, 2.0090363874E+01, 4.9812330690E+00, 5.6374929976E+00, 2.3369267715E+00, 9.1743759439E-01],
	[3.1375000000E+04, 2.0095669010E+01, 4.9812260433E+00, 5.6403954661E+00, 2.3374956224E+00, 9.1747327727E-01],
	[3.1380000000E+04, 2.0100991328E+01, 4.9812216690E+00, 5.6432989652E+00, 2.3380651927E+00, 9.1750894363E-01],
	[3.1385000000E+04, 2.0106316054E+01, 4.9812175896E+00, 5.6462034952E+00, 2.3386347638E+00, 9.1754459348E-01],
	[3.1390000000E+04, 2.0111641341E+01, 4.9812135109E+00, 5.6491090562E+00, 2.3392042459E+00, 9.1758022683E-01],
	[3.1395000000E+04, 2.0116967191E+01, 4.9812094328E+00, 5.6520156485E+00, 2.3397736390E+00, 9.1761584368E-01],
	[3.1400000000E+04, 2.0122293602E+01, 4.9812053554E+00, 5.6549232722E+00, 2.3403429430E+00, 9.1765144405E-01],
	[3.1405000000E+04, 2.0127620575E+01, 4.9812012786E+00, 5.6578319276E+00, 2.3409121580E+00, 9.1768702794E-01],
	[3.1410000000E+04, 2.0132948110E+01, 4.9811972025E+00, 5.6607416149E+00, 2.3414812838E+00, 9.1772259536E-01],
	[3.1415000000E+04, 2.0138276207E+01, 4.9811931270E+00, 5.6636523342E+00, 2.3420503204E+00, 9.1775814631E-01],
	[3.1420000000E+04, 2.0143604866E+01, 4.9811890522E+00, 5.6665640858E+00, 2.3426192679E+00, 9.1779368081E-01],
	[3.1425000000E+04, 2.0148934086E+01, 4.9811849780E+00, 5.6694768698E+00, 2.3431881261E+00, 9.1782919885E-01],
	[3.1430000000E+04, 2.0154263868E+01, 4.9811809045E+00, 5.6723906865E+00, 2.3437568951E+00, 9.1786470046E-01],
	[3.1435000000E+04, 2.0159594212E+01, 4.9811768317E+00, 5.6753055361E+00, 2.3443255747E+00, 9.1790018563E-01],
	[3.1440000000E+04, 2.0164925117E+01, 4.9811727595E+00, 5.6782214187E+00, 2.3448941651E+00, 9.1793565438E-01],
	[3.1445000000E+04, 2.0170256584E+01, 4.9811686879E+00, 5.6811383346E+00, 2.3454626660E+00, 9.1797110670E-01],
	[3.1450000000E+04, 2.0175588613E+01, 4.9811646170E+00, 5.6840562839E+00, 2.3460310776E+00, 9.1800654262E-01],
	[3.1455000000E+04, 2.0180921203E+01, 4.9811605467E+00, 5.6869752670E+00, 2.3465993997E+00, 9.1804196213E-01],
	[3.1460000000E+04, 2.0186254354E+01, 4.9811564771E+00, 5.6898952839E+00, 2.3471676324E+00, 9.1807736524E-01],
	[3.1465000000E+04, 2.0191588067E+01, 4.9811524082E+00, 5.6928163348E+00, 2.3477357756E+00, 9.1811275196E-01],
	[3.1470000000E+04, 2.0196922342E+01, 4.9811483398E+00, 5.6957384201E+00, 2.3483038292E+00, 9.1814812231E-01],
	[3.1475000000E+04, 2.0202257178E+01, 4.9811442722E+00, 5.6986615398E+00, 2.3488717932E+00, 9.1818347628E-01],
	[3.1480000000E+04, 2.0207592576E+01, 4.9811402052E+00, 5.7015856942E+00, 2.3494396677E+00, 9.1821881388E-01],
	[3.1485000000E+04, 2.0212928534E+01, 4.9811361388E+00, 5.7045108835E+00, 2.3500074525E+00, 9.1825413513E-01],
	[3.1490000000E+04, 2.0218265055E+01, 4.9811320731E+00, 5.7074371078E+00, 2.3505751476E+00, 9.1828944002E-01],
	[3.1495000000E+04, 2.0223602136E+01, 4.9811280080E+00, 5.7103643674E+00, 2.3511427531E+00, 9.1832472857E-01],
	[3.1500000000E+04, 2.0228939779E+01, 4.9811239436E+00, 5.7132926625E+00, 2.3517102687E+00, 9.1836000079E-01],
	[3.1505000000E+04, 2.0234277983E+01, 4.9811198799E+00, 5.7162219933E+00, 2.3522776947E+00, 9.1839525667E-01],
	[3.1510000000E+04, 2.0239616748E+01, 4.9811158167E+00, 5.7191523600E+00, 2.3528450308E+00, 9.1843049623E-01],
	[3.1515000000E+04, 2.0244956075E+01, 4.9811117543E+00, 5.7220837628E+00, 2.3534122770E+00, 9.1846571949E-01],
	[3.1520000000E+04, 2.0250295962E+01, 4.9811076924E+00, 5.7250162018E+00, 2.3539794334E+00, 9.1850092643E-01],
	[3.1525000000E+04, 2.0255636411E+01, 4.9811036313E+00, 5.7279496774E+00, 2.3545464999E+00, 9.1853611708E-01],
	[3.1530000000E+04, 2.0260977421E+01, 4.9810995707E+00, 5.7308841896E+00, 2.3551134764E+00, 9.1857129143E-01],
	[3.1535000000E+04, 2.0266318992E+01, 4.9810955109E+00, 5.7338197387E+00, 2.3556803630E+00, 9.1860644950E-01],
	[3.1540000000E+04, 2.0271661124E+01, 4.9810914516E+00, 5.7367563249E+00, 2.3562471595E+00, 9.1864159130E-01],
	[3.1545000000E+04, 2.0277003817E+01, 4.9810873930E+00, 5.7396939485E+00, 2.3568138660E+00, 9.1867671683E-01],
	[3.1550000000E+04, 2.0282347071E+01, 4.9810833351E+00, 5.7426326095E+00, 2.3573804825E+00, 9.1871182609E-01],
	[3.1555000000E+04, 2.0287690886E+01, 4.9810792778E+00, 5.7455723082E+00, 2.3579470088E+00, 9.1874691910E-01],
	[3.1560000000E+04, 2.0293035262E+01, 4.9810752212E+00, 5.7485130448E+00, 2.3585134450E+00, 9.1878199587E-01],
	[3.1565000000E+04, 2.0298380199E+01, 4.9810711652E+00, 5.7514548195E+00, 2.3590797910E+00, 9.1881705640E-01],
	[3.1570000000E+04, 2.0303725697E+01, 4.9810671098E+00, 5.7543976325E+00, 2.3596460468E+00, 9.1885210070E-01],
	[3.1575000000E+04, 2.0309071755E+01, 4.9810630551E+00, 5.7573414840E+00, 2.3602122123E+00, 9.1888712877E-01],
	[3.1580000000E+04, 2.0314418374E+01, 4.9810590010E+00, 5.7602863742E+00, 2.3607782876E+00, 9.1892214063E-01],
	[3.1585000000E+04, 2.0319765554E+01, 4.9810549476E+00, 5.7632323033E+00, 2.3613442726E+00, 9.1895713628E-01],
	[3.1590000000E+04, 2.0325113295E+01, 4.9810508948E+00, 5.7661792715E+00, 2.3619101672E+00, 9.1899211573E-01],
	[3.1595000000E+04, 2.0330461597E+01, 4.9810468427E+00, 5.7691272791E+00, 2.3624759715E+00, 9.1902707898E-01],
	[3.1600000000E+04, 2.0335810459E+01, 4.9810427912E+00, 5.7720763261E+00, 2.3630416853E+00, 9.1906202605E-01],
	[3.1605000000E+04, 2.0341159882E+01, 4.9810387404E+00, 5.7750264129E+00, 2.3636073087E+00, 9.1909695693E-01],
	[3.1610000000E+04, 2.0346509866E+01, 4.9810346902E+00, 5.7779775395E+00, 2.3641728416E+00, 9.1913187164E-01],
	[3.1615000000E+04, 2.0351860410E+01, 4.9810306406E+00, 5.7809297063E+00, 2.3647382841E+00, 9.1916677018E-01],
	[3.1620000000E+04, 2.0357211514E+01, 4.9810265917E+00, 5.7838829134E+00, 2.3653036360E+00, 9.1920165256E-01],
	[3.1625000000E+04, 2.0362563180E+01, 4.9810225434E+00, 5.7868371610E+00, 2.3658688973E+00, 9.1923651879E-01],
	[3.1630000000E+04, 2.0367915405E+01, 4.9810184958E+00, 5.7897924494E+00, 2.3664340680E+00, 9.1927136887E-01],
	[3.1635000000E+04, 2.0373268192E+01, 4.9810144488E+00, 5.7927487787E+00, 2.3669991481E+00, 9.1930620281E-01],
	[3.1640000000E+04, 2.0378621538E+01, 4.9810104025E+00, 5.7957061490E+00, 2.3675641375E+00, 9.1934102062E-01],
	[3.1645000000E+04, 2.0383975445E+01, 4.9810063568E+00, 5.7986645608E+00, 2.3681290363E+00, 9.1937582230E-01],
	[3.1650000000E+04, 2.0389329913E+01, 4.9810023118E+00, 5.8016240140E+00, 2.3686938442E+00, 9.1941060786E-01],
	[3.1655000000E+04, 2.0394684941E+01, 4.9809982673E+00, 5.8045845090E+00, 2.3692585615E+00, 9.1944537731E-01],
	[3.1660000000E+04, 2.0400040529E+01, 4.9809942236E+00, 5.8075460459E+00, 2.3698231879E+00, 9.1948013065E-01],
	[3.1665000000E+04, 2.0405396677E+01, 4.9809901804E+00, 5.8105086249E+00, 2.3703877235E+00, 9.1951486789E-01],
	[3.1670000000E+04, 2.0410753386E+01, 4.9809861380E+00, 5.8134722463E+00, 2.3709521682E+00, 9.1954958904E-01],
	[3.1675000000E+04, 2.0416110655E+01, 4.9809820961E+00, 5.8164369102E+00, 2.3715165221E+00, 9.1958429411E-01],
	[3.1680000000E+04, 2.0421468484E+01, 4.9809780549E+00, 5.8194026168E+00, 2.3720807850E+00, 9.1961898310E-01],
	[3.1685000000E+04, 2.0426826874E+01, 4.9809740144E+00, 5.8223693664E+00, 2.3726449569E+00, 9.1965365601E-01],
	[3.1690000000E+04, 2.0432185823E+01, 4.9809699744E+00, 5.8253371591E+00, 2.3732090379E+00, 9.1968831287E-01],
	[3.1695000000E+04, 2.0437545333E+01, 4.9809659352E+00, 5.8283059951E+00, 2.3737730279E+00, 9.1972295366E-01],
	[3.1700000000E+04, 2.0442905403E+01, 4.9809618965E+00, 5.8312758747E+00, 2.3743369268E+00, 9.1975757841E-01],
	[3.1705000000E+04, 2.0448266032E+01, 4.9809578585E+00, 5.8342467981E+00, 2.3749007346E+00, 9.1979218711E-01],
	[3.1710000000E+04, 2.0453627222E+01, 4.9809538212E+00, 5.8372187654E+00, 2.3754644513E+00, 9.1982677977E-01],
	[3.1715000000E+04, 2.0458988972E+01, 4.9809497844E+00, 5.8401917768E+00, 2.3760280768E+00, 9.1986135641E-01],
	[3.1720000000E+04, 2.0464351282E+01, 4.9809457484E+00, 5.8431658326E+00, 2.3765916112E+00, 9.1989591702E-01],
	[3.1725000000E+04, 2.0469714152E+01, 4.9809417129E+00, 5.8461409329E+00, 2.3771550543E+00, 9.1993046161E-01],
	[3.1730000000E+04, 2.0475077581E+01, 4.9809376781E+00, 5.8491170780E+00, 2.3777184062E+00, 9.1996499020E-01],
	[3.1735000000E+04, 2.0480441571E+01, 4.9809336440E+00, 5.8520942681E+00, 2.3782816669E+00, 9.1999950278E-01],
	[3.1740000000E+04, 2.0485806120E+01, 4.9809296104E+00, 5.8550725033E+00, 2.3788448362E+00, 9.2003399937E-01],
	[3.1745000000E+04, 2.0491171229E+01, 4.9809255776E+00, 5.8580517838E+00, 2.3794079142E+00, 9.2006847997E-01],
	[3.1750000000E+04, 2.0496536898E+01, 4.9809215453E+00, 5.8610321100E+00, 2.3799709008E+00, 9.2010294459E-01],
	[3.1755000000E+04, 2.0501903127E+01, 4.9809175137E+00, 5.8640134818E+00, 2.3805337960E+00, 9.2013739323E-01],
	[3.1760000000E+04, 2.0507269916E+01, 4.9809134827E+00, 5.8669958997E+00, 2.3810965998E+00, 9.2017182591E-01],
	[3.1765000000E+04, 2.0512637264E+01, 4.9809094524E+00, 5.8699793637E+00, 2.3816593121E+00, 9.2020624262E-01],
	[3.1770000000E+04, 2.0518005172E+01, 4.9809054227E+00, 5.8729638741E+00, 2.3822219329E+00, 9.2024064338E-01],
	[3.1775000000E+04, 2.0523373639E+01, 4.9809013937E+00, 5.8759494310E+00, 2.3827844622E+00, 9.2027502820E-01],
	[3.1780000000E+04, 2.0528742666E+01, 4.9808973652E+00, 5.8789360348E+00, 2.3833469000E+00, 9.2030939707E-01],
	[3.1785000000E+04, 2.0534112253E+01, 4.9808933375E+00, 5.8819236855E+00, 2.3839092461E+00, 9.2034375001E-01],
	[3.1790000000E+04, 2.0539482399E+01, 4.9808893103E+00, 5.8849123833E+00, 2.3844715007E+00, 9.2037808702E-01],
	[3.1795000000E+04, 2.0544853105E+01, 4.9808852838E+00, 5.8879021286E+00, 2.3850336636E+00, 9.2041240812E-01],
	[3.1800000000E+04, 2.0550224370E+01, 4.9808812579E+00, 5.8908929214E+00, 2.3855957348E+00, 9.2044671330E-01],
	[3.1805000000E+04, 2.0555596195E+01, 4.9808772327E+00, 5.8938847620E+00, 2.3861577143E+00, 9.2048100257E-01],
	[3.1810000000E+04, 2.0560968579E+01, 4.9808732081E+00, 5.8968776506E+00, 2.3867196020E+00, 9.2051527595E-01],
	[3.1815000000E+04, 2.0566341523E+01, 4.9808691841E+00, 5.8998715874E+00, 2.3872813980E+00, 9.2054953344E-01],
	[3.1820000000E+04, 2.0571715026E+01, 4.9808651608E+00, 5.9028665725E+00, 2.3878431021E+00, 9.2058377504E-01],
	[3.1825000000E+04, 2.0577089088E+01, 4.9808611381E+00, 5.9058626063E+00, 2.3884047145E+00, 9.2061800076E-01],
	[3.1830000000E+04, 2.0582463710E+01, 4.9808571160E+00, 5.9088596888E+00, 2.3889662350E+00, 9.2065221061E-01],
	[3.1835000000E+04, 2.0587838891E+01, 4.9808530946E+00, 5.9118578203E+00, 2.3895276635E+00, 9.2068640460E-01],
	[3.1840000000E+04, 2.0593214631E+01, 4.9808490738E+00, 5.9148570010E+00, 2.3900890002E+00, 9.2072058273E-01],
	[3.1845000000E+04, 2.0598590930E+01, 4.9808450537E+00, 5.9178572311E+00, 2.3906502449E+00, 9.2075474501E-01],
	[3.1850000000E+04, 2.0603967789E+01, 4.9808410342E+00, 5.9208585108E+00, 2.3912113976E+00, 9.2078889144E-01],
	[3.1855000000E+04, 2.0609345207E+01, 4.9808370153E+00, 5.9238608404E+00, 2.3917724582E+00, 9.2082302204E-01],
	[3.1860000000E+04, 2.0614723184E+01, 4.9808329970E+00, 5.9268642199E+00, 2.3923334269E+00, 9.2085713681E-01],
	[3.1865000000E+04, 2.0620101720E+01, 4.9808289794E+00, 5.9298686496E+00, 2.3928943034E+00, 9.2089123576E-01],
	[3.1870000000E+04, 2.0625480815E+01, 4.9808249624E+00, 5.9328741297E+00, 2.3934550879E+00, 9.2092531889E-01],
	[3.1875000000E+04, 2.0630860469E+01, 4.9808209461E+00, 5.9358806604E+00, 2.3940157802E+00, 9.2095938621E-01],
	[3.1880000000E+04, 2.0636240682E+01, 4.9808169304E+00, 5.9388882419E+00, 2.3945763803E+00, 9.2099343773E-01],
	[3.1885000000E+04, 2.0641637551E+01, 4.9808154534E+00, 5.9418968745E+00, 2.3951376919E+00, 9.2102747345E-01],
	[3.1890000000E+04, 2.0647037191E+01, 4.9808143244E+00, 5.9449065582E+00, 2.3956990219E+00, 9.2106149339E-01],
	[3.1895000000E+04, 2.0652437396E+01, 4.9808131956E+00, 5.9479172934E+00, 2.3962602602E+00, 9.2109549755E-01],
	[3.1900000000E+04, 2.0657838167E+01, 4.9808120669E+00, 5.9509290802E+00, 2.3968214068E+00, 9.2112948593E-01],
	[3.1905000000E+04, 2.0663239504E+01, 4.9808109384E+00, 5.9539419188E+00, 2.3973824617E+00, 9.2116345854E-01],
	[3.1910000000E+04, 2.0668641406E+01, 4.9808098101E+00, 5.9569558094E+00, 2.3979434248E+00, 9.2119741539E-01],
	[3.1915000000E+04, 2.0674043873E+01, 4.9808086820E+00, 5.9599707522E+00, 2.3985042961E+00, 9.2123135649E-01],
	[3.1920000000E+04, 2.0679446906E+01, 4.9808075540E+00, 5.9629867475E+00, 2.3990650756E+00, 9.2126528185E-01],
	[3.1925000000E+04, 2.0684850504E+01, 4.9808064262E+00, 5.9660037954E+00, 2.3996257632E+00, 9.2129919146E-01],
	[3.1930000000E+04, 2.0690254668E+01, 4.9808052986E+00, 5.9690218961E+00, 2.4001863590E+00, 9.2133308534E-01],
	[3.1935000000E+04, 2.0695659397E+01, 4.9808041712E+00, 5.9720410499E+00, 2.4007468628E+00, 9.2136696349E-01],
	[3.1940000000E+04, 2.0701064692E+01, 4.9808030439E+00, 5.9750612568E+00, 2.4013072747E+00, 9.2140082593E-01],
	[3.1945000000E+04, 2.0706470552E+01, 4.9808019169E+00, 5.9780825173E+00, 2.4018675946E+00, 9.2143467265E-01],
	[3.1950000000E+04, 2.0711876977E+01, 4.9808007900E+00, 5.9811048313E+00, 2.4024278225E+00, 9.2146850367E-01],
	[3.1955000000E+04, 2.0717283967E+01, 4.9807996633E+00, 5.9841281992E+00, 2.4029879583E+00, 9.2150231899E-01],
	[3.1960000000E+04, 2.0722691523E+01, 4.9807985367E+00, 5.9871526211E+00, 2.4035480021E+00, 9.2153611862E-01],
	[3.1965000000E+04, 2.0728099644E+01, 4.9807974103E+00, 5.9901780973E+00, 2.4041079538E+00, 9.2156990256E-01],
	[3.1970000000E+04, 2.0733508330E+01, 4.9807962841E+00, 5.9932046279E+00, 2.4046678134E+00, 9.2160367083E-01],
	[3.1975000000E+04, 2.0738917581E+01, 4.9807951581E+00, 5.9962322132E+00, 2.4052275809E+00, 9.2163742342E-01],
	[3.1980000000E+04, 2.0744327397E+01, 4.9807940323E+00, 5.9992608533E+00, 2.4057872561E+00, 9.2167116035E-01],
	[3.1985000000E+04, 2.0749737779E+01, 4.9807929066E+00, 6.0022905485E+00, 2.4063468391E+00, 9.2170488163E-01],
	[3.1990000000E+04, 2.0755148725E+01, 4.9807917811E+00, 6.0053212989E+00, 2.4069063299E+00, 9.2173858726E-01],
	[3.1995000000E+04, 2.0760560236E+01, 4.9807906558E+00, 6.0083531047E+00, 2.4074657285E+00, 9.2177227724E-01],
	[3.2000000000E+04, 2.0765972313E+01, 4.9807895307E+00, 6.0113859663E+00, 2.4080250347E+00, 9.2180595158E-01],
	[3.2005000000E+04, 2.0771384954E+01, 4.9807884057E+00, 6.0144198836E+00, 2.4085842486E+00, 9.2183961030E-01],
	[3.2010000000E+04, 2.0776798161E+01, 4.9807872810E+00, 6.0174548571E+00, 2.4091433701E+00, 9.2187325340E-01],
	[3.2015000000E+04, 2.0782211932E+01, 4.9807861563E+00, 6.0204908868E+00, 2.4097023993E+00, 9.2190688088E-01],
	[3.2020000000E+04, 2.0787626268E+01, 4.9807850319E+00, 6.0235279730E+00, 2.4102613360E+00, 9.2194049275E-01],
	[3.2025000000E+04, 2.0793041169E+01, 4.9807839077E+00, 6.0265661158E+00, 2.4108201803E+00, 9.2197408902E-01],
	[3.2030000000E+04, 2.0798456635E+01, 4.9807827836E+00, 6.0296053155E+00, 2.4113789321E+00, 9.2200766970E-01],
	[3.2035000000E+04, 2.0803872666E+01, 4.9807816597E+00, 6.0326455723E+00, 2.4119375914E+00, 9.2204123478E-01],
	[3.2040000000E+04, 2.0809289262E+01, 4.9807805359E+00, 6.0356868864E+00, 2.4124961582E+00, 9.2207478429E-01],
	[3.2045000000E+04, 2.0814706422E+01, 4.9807794124E+00, 6.0387292579E+00, 2.4130546324E+00, 9.2210831823E-01],
	[3.2050000000E+04, 2.0820124147E+01, 4.9807782890E+00, 6.0417726871E+00, 2.4136130140E+00, 9.2214183659E-01],
	[3.2055000000E+04, 2.0825542436E+01, 4.9807771658E+00, 6.0448171742E+00, 2.4141713031E+00, 9.2217533940E-01],
	[3.2060000000E+04, 2.0830961290E+01, 4.9807760428E+00, 6.0478627194E+00, 2.4147294994E+00, 9.2220882665E-01],
	[3.2065000000E+04, 2.0836380709E+01, 4.9807749199E+00, 6.0509093228E+00, 2.4152876031E+00, 9.2224229836E-01],
	[3.2070000000E+04, 2.0841800693E+01, 4.9807737973E+00, 6.0539569848E+00, 2.4158456141E+00, 9.2227575453E-01],
	[3.2075000000E+04, 2.0847221241E+01, 4.9807726748E+00, 6.0570057054E+00, 2.4164035323E+00, 9.2230919517E-01],
	[3.2080000000E+04, 2.0852642353E+01, 4.9807715524E+00, 6.0600554849E+00, 2.4169613578E+00, 9.2234262028E-01],
	[3.2085000000E+04, 2.0858064031E+01, 4.9807704303E+00, 6.0631063235E+00, 2.4175190905E+00, 9.2237602988E-01],
	[3.2090000000E+04, 2.0863486272E+01, 4.9807693083E+00, 6.0661582214E+00, 2.4180767304E+00, 9.2240942396E-01],
	[3.2095000000E+04, 2.0868909078E+01, 4.9807681865E+00, 6.0692111789E+00, 2.4186342774E+00, 9.2244280254E-01],
	[3.2100000000E+04, 2.0874332448E+01, 4.9807670649E+00, 6.0722651960E+00, 2.4191917316E+00, 9.2247616562E-01],
	[3.2105000000E+04, 2.0879756383E+01, 4.9807659434E+00, 6.0753202730E+00, 2.4197490929E+00, 9.2250951321E-01],
	[3.2110000000E+04, 2.0885180882E+01, 4.9807648222E+00, 6.0783764101E+00, 2.4203063612E+00, 9.2254284531E-01],
	[3.2115000000E+04, 2.0890605946E+01, 4.9807637011E+00, 6.0814336075E+00, 2.4208635365E+00, 9.2257616194E-01],
	[3.2120000000E+04, 2.0896031574E+01, 4.9807625801E+00, 6.0844918655E+00, 2.4214206189E+00, 9.2260946310E-01],
	[3.2125000000E+04, 2.0901457766E+01, 4.9807614594E+00, 6.0875511841E+00, 2.4219776083E+00, 9.2264274880E-01],
	[3.2130000000E+04, 2.0906884522E+01, 4.9807603388E+00, 6.0906115637E+00, 2.4225345046E+00, 9.2267601904E-01],
	[3.2135000000E+04, 2.0912311843E+01, 4.9807592184E+00, 6.0936730043E+00, 2.4230913078E+00, 9.2270927383E-01],
	[3.2140000000E+04, 2.0917739727E+01, 4.9807580982E+00, 6.0967355063E+00, 2.4236480180E+00, 9.2274251318E-01],
	[3.2145000000E+04, 2.0923168176E+01, 4.9807569781E+00, 6.0997990698E+00, 2.4242046350E+00, 9.2277573709E-01],
	[3.2150000000E+04, 2.0928597189E+01, 4.9807558583E+00, 6.1028636951E+00, 2.4247611589E+00, 9.2280894558E-01],
	[3.2155000000E+04, 2.0934026766E+01, 4.9807547386E+00, 6.1059293822E+00, 2.4253175895E+00, 9.2284213864E-01],
	[3.2160000000E+04, 2.0939456908E+01, 4.9807536190E+00, 6.1089961315E+00, 2.4258739270E+00, 9.2287531629E-01],
	[3.2165000000E+04, 2.0944887613E+01, 4.9807524997E+00, 6.1120639432E+00, 2.4264301712E+00, 9.2290847853E-01],
	[3.2170000000E+04, 2.0950318882E+01, 4.9807513805E+00, 6.1151328173E+00, 2.4269863222E+00, 9.2294162538E-01],
	[3.2175000000E+04, 2.0955750715E+01, 4.9807502615E+00, 6.1182027542E+00, 2.4275423799E+00, 9.2297475682E-01],
	[3.2180000000E+04, 2.0961183112E+01, 4.9807491427E+00, 6.1212737540E+00, 2.4280983442E+00, 9.2300787289E-01],
	[3.2185000000E+04, 2.0966616073E+01, 4.9807480240E+00, 6.1243458170E+00, 2.4286542152E+00, 9.2304097357E-01],
	[3.2190000000E+04, 2.0972049598E+01, 4.9807469055E+00, 6.1274189433E+00, 2.4292099928E+00, 9.2307405888E-01],
	[3.2195000000E+04, 2.0977483687E+01, 4.9807457872E+00, 6.1304931331E+00, 2.4297656770E+00, 9.2310712882E-01],
	[3.2200000000E+04, 2.0982918340E+01, 4.9807446691E+00, 6.1335683867E+00, 2.4303212678E+00, 9.2314018340E-01],
	[3.2205000000E+04, 2.0988353556E+01, 4.9807435511E+00, 6.1366447043E+00, 2.4308767651E+00, 9.2317322263E-01],
	[3.2210000000E+04, 2.0993789337E+01, 4.9807424333E+00, 6.1397220860E+00, 2.4314321689E+00, 9.2320624652E-01],
	[3.2215000000E+04, 2.0999225681E+01, 4.9807413157E+00, 6.1428005320E+00, 2.4319874792E+00, 9.2323925507E-01],
	[3.2220000000E+04, 2.1004662588E+01, 4.9807401983E+00, 6.1458800426E+00, 2.4325426960E+00, 9.2327224828E-01],
	[3.2225000000E+04, 2.1010100060E+01, 4.9807390810E+00, 6.1489606180E+00, 2.4330978192E+00, 9.2330522617E-01],
	[3.2230000000E+04, 2.1015538095E+01, 4.9807379639E+00, 6.1520422583E+00, 2.4336528488E+00, 9.2333818875E-01],
	[3.2235000000E+04, 2.1020976694E+01, 4.9807368470E+00, 6.1551249638E+00, 2.4342077848E+00, 9.2337113601E-01],
	[3.2240000000E+04, 2.1026415856E+01, 4.9807357302E+00, 6.1582087346E+00, 2.4347626272E+00, 9.2340406797E-01],
	[3.2245000000E+04, 2.1031855582E+01, 4.9807346137E+00, 6.1612935711E+00, 2.4353173758E+00, 9.2343698463E-01],
	[3.2250000000E+04, 2.1037295871E+01, 4.9807334973E+00, 6.1643794732E+00, 2.4358720308E+00, 9.2346988601E-01],
	[3.2255000000E+04, 2.1042736724E+01, 4.9807323810E+00, 6.1674664414E+00, 2.4364265920E+00, 9.2350277210E-01],
	[3.2260000000E+04, 2.1048178141E+01, 4.9807312650E+00, 6.1705544757E+00, 2.4369810594E+00, 9.2353564291E-01],
	[3.2265000000E+04, 2.1053620120E+01, 4.9807301491E+00, 6.1736435765E+00, 2.4375354331E+00, 9.2356849846E-01],
	[3.2270000000E+04, 2.1059062664E+01, 4.9807290334E+00, 6.1767337438E+00, 2.4380897130E+00, 9.2360133874E-01],
	[3.2275000000E+04, 2.1064505771E+01, 4.9807279179E+00, 6.1798249778E+00, 2.4386438990E+00, 9.2363416377E-01],
	[3.2280000000E+04, 2.1069949441E+01, 4.9807268025E+00, 6.1829172789E+00, 2.4391979912E+00, 9.2366697355E-01],
	[3.2285000000E+04, 2.1075393674E+01, 4.9807256873E+00, 6.1860106472E+00, 2.4397519895E+00, 9.2369976808E-01],
	[3.2290000000E+04, 2.1080838471E+01, 4.9807245723E+00, 6.1891050828E+00, 2.4403058938E+00, 9.2373254739E-01],
	[3.2295000000E+04, 2.1086283831E+01, 4.9807234575E+00, 6.1922005860E+00, 2.4408597042E+00, 9.2376531146E-01],
	[3.2300000000E+04, 2.1091729754E+01, 4.9807223428E+00, 6.1952971571E+00, 2.4414134207E+00, 9.2379806032E-01],
	[3.2305000000E+04, 2.1097176241E+01, 4.9807212283E+00, 6.1983947961E+00, 2.4419670431E+00, 9.2383079396E-01],
	[3.2310000000E+04, 2.1102623290E+01, 4.9807201140E+00, 6.2014935033E+00, 2.4425205715E+00, 9.2386351239E-01],
	[3.2315000000E+04, 2.1108070903E+01, 4.9807189998E+00, 6.2045932790E+00, 2.4430740059E+00, 9.2389621563E-01],
	[3.2320000000E+04, 2.1113519079E+01, 4.9807178858E+00, 6.2076941232E+00, 2.4436273461E+00, 9.2392890367E-01],
	[3.2325000000E+04, 2.1118967818E+01, 4.9807167720E+00, 6.2107960362E+00, 2.4441805923E+00, 9.2396157653E-01],
	[3.2330000000E+04, 2.1124417121E+01, 4.9807156584E+00, 6.2138990183E+00, 2.4447337444E+00, 9.2399423420E-01],
	[3.2335000000E+04, 2.1129866986E+01, 4.9807145449E+00, 6.2170030696E+00, 2.4452868023E+00, 9.2402687671E-01],
	[3.2340000000E+04, 2.1135317414E+01, 4.9807134316E+00, 6.2201081902E+00, 2.4458397660E+00, 9.2405950405E-01],
	[3.2345000000E+04, 2.1140768406E+01, 4.9807123185E+00, 6.2232143806E+00, 2.4463926355E+00, 9.2409211623E-01],
	[3.2350000000E+04, 2.1146219960E+01, 4.9807112056E+00, 6.2263216407E+00, 2.4469454107E+00, 9.2412471325E-01],
	[3.2355000000E+04, 2.1151672077E+01, 4.9807100928E+00, 6.2294299708E+00, 2.4474980918E+00, 9.2415729514E-01],
	[3.2360000000E+04, 2.1157124757E+01, 4.9807089802E+00, 6.2325393712E+00, 2.4480506785E+00, 9.2418986188E-01],
	[3.2365000000E+04, 2.1162578000E+01, 4.9807078678E+00, 6.2356498420E+00, 2.4486031709E+00, 9.2422241350E-01],
	[3.2370000000E+04, 2.1168031806E+01, 4.9807067555E+00, 6.2387613834E+00, 2.4491555689E+00, 9.2425494999E-01],
	[3.2375000000E+04, 2.1173486175E+01, 4.9807056435E+00, 6.2418739957E+00, 2.4497078726E+00, 9.2428747137E-01],
	[3.2380000000E+04, 2.1178941106E+01, 4.9807045315E+00, 6.2449876790E+00, 2.4502600820E+00, 9.2431997763E-01],
	[3.2385000000E+04, 2.1184396600E+01, 4.9807034198E+00, 6.2481024335E+00, 2.4508121969E+00, 9.2435246879E-01],
	[3.2390000000E+04, 2.1189852657E+01, 4.9807023082E+00, 6.2512182595E+00, 2.4513642173E+00, 9.2438494486E-01],
	[3.2395000000E+04, 2.1195313494E+01, 4.9807018549E+00, 6.2543351572E+00, 2.4519163592E+00, 9.2441740584E-01],
	[3.2400000000E+04, 2.1200788806E+01, 4.9807035720E+00, 6.2574531266E+00, 2.4524691191E+00, 9.2444985173E-01],
	[3.2405000000E+04, 2.1206264688E+01, 4.9807052889E+00, 6.2605724419E+00, 2.4530218271E+00, 9.2448228255E-01],
	[3.2410000000E+04, 2.1211741139E+01, 4.9807070054E+00, 6.2636936089E+00, 2.4535745606E+00, 9.2451469830E-01],
	[3.2415000000E+04, 2.1217218158E+01, 4.9807087217E+00, 6.2668158493E+00, 2.4541272001E+00, 9.2454709899E-01],
	[3.2420000000E+04, 2.1222695747E+01, 4.9807104377E+00, 6.2699391633E+00, 2.4546797456E+00, 9.2457948462E-01],
	[3.2425000000E+04, 2.1228173905E+01, 4.9807121535E+00, 6.2730635512E+00, 2.4552321970E+00, 9.2461185520E-01],
	[3.2430000000E+04, 2.1233652632E+01, 4.9807138690E+00, 6.2761890130E+00, 2.4557845542E+00, 9.2464421075E-01],
	[3.2435000000E+04, 2.1239131929E+01, 4.9807155842E+00, 6.2793155490E+00, 2.4563368173E+00, 9.2467655126E-01],
	[3.2440000000E+04, 2.1244611794E+01, 4.9807172992E+00, 6.2824431594E+00, 2.4568889863E+00, 9.2470887674E-01],
	[3.2445000000E+04, 2.1250092228E+01, 4.9807190139E+00, 6.2855718444E+00, 2.4574410610E+00, 9.2474118721E-01],
	[3.2450000000E+04, 2.1255573231E+01, 4.9807207284E+00, 6.2887016042E+00, 2.4579930416E+00, 9.2477348266E-01],
	[3.2455000000E+04, 2.1261054803E+01, 4.9807224426E+00, 6.2918324391E+00, 2.4585449279E+00, 9.2480576310E-01],
	[3.2460000000E+04, 2.1266536943E+01, 4.9807241565E+00, 6.2949643492E+00, 2.4590967199E+00, 9.2483802854E-01],
	[3.2465000000E+04, 2.1272019653E+01, 4.9807258701E+00, 6.2980973346E+00, 2.4596484177E+00, 9.2487027900E-01],
	[3.2470000000E+04, 2.1277502932E+01, 4.9807275835E+00, 6.3012313957E+00, 2.4602000211E+00, 9.2490251446E-01],
	[3.2475000000E+04, 2.1282986779E+01, 4.9807292966E+00, 6.3043665327E+00, 2.4607515302E+00, 9.2493473495E-01],
	[3.2480000000E+04, 2.1288471195E+01, 4.9807310095E+00, 6.3075027456E+00, 2.4613029449E+00, 9.2496694046E-01],
	[3.2485000000E+04, 2.1293956180E+01, 4.9807327221E+00, 6.3106400348E+00, 2.4618542653E+00, 9.2499913101E-01],
	[3.2490000000E+04, 2.1299441733E+01, 4.9807344345E+00, 6.3137784004E+00, 2.4624054912E+00, 9.2503130661E-01],
	[3.2495000000E+04, 2.1304927856E+01, 4.9807361465E+00, 6.3169178427E+00, 2.4629566226E+00, 9.2506346725E-01],
	[3.2500000000E+04, 2.1310414546E+01, 4.9807378583E+00, 6.3200583618E+00, 2.4635076596E+00, 9.2509561294E-01],
	[3.2505000000E+04, 2.1315901806E+01, 4.9807395699E+00, 6.3231999579E+00, 2.4640586022E+00, 9.2512774370E-01],
	[3.2510000000E+04, 2.1321389634E+01, 4.9807412812E+00, 6.3263426313E+00, 2.4646094502E+00, 9.2515985953E-01],
	[3.2515000000E+04, 2.1326878031E+01, 4.9807429922E+00, 6.3294863822E+00, 2.4651602036E+00, 9.2519196044E-01],
	[3.2520000000E+04, 2.1332366996E+01, 4.9807447030E+00, 6.3326312107E+00, 2.4657108625E+00, 9.2522404643E-01],
	[3.2525000000E+04, 2.1337856530E+01, 4.9807464135E+00, 6.3357771170E+00, 2.4662614268E+00, 9.2525611751E-01],
	[3.2530000000E+04, 2.1343346632E+01, 4.9807481237E+00, 6.3389241014E+00, 2.4668118965E+00, 9.2528817368E-01],
	[3.2535000000E+04, 2.1348837302E+01, 4.9807498337E+00, 6.3420721641E+00, 2.4673622715E+00, 9.2532021496E-01],
	[3.2540000000E+04, 2.1354328542E+01, 4.9807515434E+00, 6.3452213053E+00, 2.4679125519E+00, 9.2535224135E-01],
	[3.2545000000E+04, 2.1359820349E+01, 4.9807532529E+00, 6.3483715251E+00, 2.4684627376E+00, 9.2538425286E-01],
	[3.2550000000E+04, 2.1365312725E+01, 4.9807549621E+00, 6.3515228238E+00, 2.4690128285E+00, 9.2541624949E-01],
	[3.2555000000E+04, 2.1370805669E+01, 4.9807566710E+00, 6.3546752015E+00, 2.4695628248E+00, 9.2544823126E-01],
	[3.2560000000E+04, 2.1376299182E+01, 4.9807583796E+00, 6.3578286586E+00, 2.4701127262E+00, 9.2548019816E-01],
	[3.2565000000E+04, 2.1381793262E+01, 4.9807600881E+00, 6.3609831951E+00, 2.4706625329E+00, 9.2551215021E-01],
	[3.2570000000E+04, 2.1387287912E+01, 4.9807617962E+00, 6.3641388113E+00, 2.4712122448E+00, 9.2554408741E-01],
	[3.2575000000E+04, 2.1392783129E+01, 4.9807635041E+00, 6.3672955074E+00, 2.4717618618E+00, 9.2557600978E-01],
	[3.2580000000E+04, 2.1398278914E+01, 4.9807652117E+00, 6.3704532836E+00, 2.4723113839E+00, 9.2560791730E-01],
	[3.2585000000E+04, 2.1403775268E+01, 4.9807669191E+00, 6.3736121401E+00, 2.4728608112E+00, 9.2563981000E-01],
	[3.2590000000E+04, 2.1409272190E+01, 4.9807686262E+00, 6.3767720771E+00, 2.4734101436E+00, 9.2567168788E-01],
	[3.2595000000E+04, 2.1414769680E+01, 4.9807703330E+00, 6.3799330948E+00, 2.4739593810E+00, 9.2570355095E-01],
	[3.2600000000E+04, 2.1420267738E+01, 4.9807720396E+00, 6.3830951934E+00, 2.4745085235E+00, 9.2573539921E-01],
	[3.2605000000E+04, 2.1425766364E+01, 4.9807737459E+00, 6.3862583731E+00, 2.4750575710E+00, 9.2576723267E-01],
	[3.2610000000E+04, 2.1431265558E+01, 4.9807754519E+00, 6.3894226342E+00, 2.4756065235E+00, 9.2579905134E-01],
	[3.2615000000E+04, 2.1436765320E+01, 4.9807771577E+00, 6.3925879767E+00, 2.4761553810E+00, 9.2583085522E-01],
	[3.2620000000E+04, 2.1442265650E+01, 4.9807788633E+00, 6.3957544010E+00, 2.4767041434E+00, 9.2586264432E-01],
	[3.2625000000E+04, 2.1447766548E+01, 4.9807805685E+00, 6.3989219071E+00, 2.4772528107E+00, 9.2589441865E-01],
	[3.2630000000E+04, 2.1453268014E+01, 4.9807822735E+00, 6.4020904955E+00, 2.4778013829E+00, 9.2592617822E-01],
	[3.2635000000E+04, 2.1458770048E+01, 4.9807839783E+00, 6.4052601661E+00, 2.4783498600E+00, 9.2595792303E-01],
	[3.2640000000E+04, 2.1464272650E+01, 4.9807856828E+00, 6.4084309193E+00, 2.4788982420E+00, 9.2598965308E-01],
	[3.2645000000E+04, 2.1469775819E+01, 4.9807873870E+00, 6.4116027552E+00, 2.4794465287E+00, 9.2602136840E-01],
	[3.2650000000E+04, 2.1475279557E+01, 4.9807890910E+00, 6.4147756740E+00, 2.4799947203E+00, 9.2605306897E-01],
	[3.2655000000E+04, 2.1480783862E+01, 4.9807907947E+00, 6.4179496760E+00, 2.4805428167E+00, 9.2608475482E-01],
	[3.2660000000E+04, 2.1486288734E+01, 4.9807924981E+00, 6.4211247614E+00, 2.4810908178E+00, 9.2611642594E-01],
	[3.2665000000E+04, 2.1491794175E+01, 4.9807942013E+00, 6.4243009303E+00, 2.4816387236E+00, 9.2614808234E-01],
	[3.2670000000E+04, 2.1497300183E+01, 4.9807959042E+00, 6.4274781829E+00, 2.4821865342E+00, 9.2617972404E-01],
	[3.2675000000E+04, 2.1502806759E+01, 4.9807976069E+00, 6.4306565195E+00, 2.4827342494E+00, 9.2621135103E-01],
	[3.2680000000E+04, 2.1508313903E+01, 4.9807993093E+00, 6.4338359403E+00, 2.4832818693E+00, 9.2624296332E-01],
	[3.2685000000E+04, 2.1513821614E+01, 4.9808010114E+00, 6.4370164454E+00, 2.4838293939E+00, 9.2627456093E-01],
	[3.2690000000E+04, 2.1519329893E+01, 4.9808027133E+00, 6.4401980351E+00, 2.4843768230E+00, 9.2630614385E-01],
	[3.2695000000E+04, 2.1524838739E+01, 4.9808044150E+00, 6.4433807096E+00, 2.4849241568E+00, 9.2633771210E-01],
	[3.2700000000E+04, 2.1530348153E+01, 4.9808061163E+00, 6.4465644690E+00, 2.4854713951E+00, 9.2636926567E-01],
	[3.2705000000E+04, 2.1535858134E+01, 4.9808078174E+00, 6.4497493136E+00, 2.4860185380E+00, 9.2640080459E-01],
	[3.2710000000E+04, 2.1541368683E+01, 4.9808095183E+00, 6.4529352436E+00, 2.4865655853E+00, 9.2643232885E-01],
	[3.2715000000E+04, 2.1546879799E+01, 4.9808112189E+00, 6.4561222592E+00, 2.4871125372E+00, 9.2646383846E-01],
	[3.2720000000E+04, 2.1552391483E+01, 4.9808129192E+00, 6.4593103606E+00, 2.4876593936E+00, 9.2649533344E-01],
	[3.2725000000E+04, 2.1557903734E+01, 4.9808146193E+00, 6.4624995480E+00, 2.4882061544E+00, 9.2652681377E-01],
	[3.2730000000E+04, 2.1563416552E+01, 4.9808163191E+00, 6.4656898215E+00, 2.4887528196E+00, 9.2655827948E-01],
	[3.2735000000E+04, 2.1568929937E+01, 4.9808180186E+00, 6.4688811815E+00, 2.4892993893E+00, 9.2658973057E-01],
	[3.2740000000E+04, 2.1574443890E+01, 4.9808197179E+00, 6.4720736280E+00, 2.4898458633E+00, 9.2662116705E-01],
	[3.2745000000E+04, 2.1579958411E+01, 4.9808214170E+00, 6.4752671614E+00, 2.4903922417E+00, 9.2665258892E-01],
	[3.2750000000E+04, 2.1585473498E+01, 4.9808231157E+00, 6.4784617818E+00, 2.4909385244E+00, 9.2668399619E-01],
	[3.2755000000E+04, 2.1590989153E+01, 4.9808248142E+00, 6.4816574894E+00, 2.4914847114E+00, 9.2671538886E-01],
	[3.2760000000E+04, 2.1596505375E+01, 4.9808265125E+00, 6.4848542844E+00, 2.4920308028E+00, 9.2674676695E-01],
	[3.2765000000E+04, 2.1602022163E+01, 4.9808282105E+00, 6.4880521670E+00, 2.4925767984E+00, 9.2677813046E-01],
	[3.2770000000E+04, 2.1607539520E+01, 4.9808299082E+00, 6.4912511375E+00, 2.4931226982E+00, 9.2680947940E-01],
	[3.2775000000E+04, 2.1613057443E+01, 4.9808316057E+00, 6.4944511959E+00, 2.4936685023E+00, 9.2684081377E-01],
	[3.2780000000E+04, 2.1618575933E+01, 4.9808333030E+00, 6.4976523426E+00, 2.4942142106E+00, 9.2687213358E-01],
	[3.2785000000E+04, 2.1624094990E+01, 4.9808349999E+00, 6.5008545778E+00, 2.4947598230E+00, 9.2690343884E-01],
	[3.2790000000E+04, 2.1629614615E+01, 4.9808366966E+00, 6.5040579016E+00, 2.4953053396E+00, 9.2693472956E-01],
	[3.2795000000E+04, 2.1635134806E+01, 4.9808383931E+00, 6.5072623142E+00, 2.4958507604E+00, 9.2696600574E-01],
	[3.2800000000E+04, 2.1640655564E+01, 4.9808400893E+00, 6.5104678158E+00, 2.4963960852E+00, 9.2699726738E-01],
	[3.2805000000E+04, 2.1646176889E+01, 4.9808417852E+00, 6.5136744068E+00, 2.4969413142E+00, 9.2702851450E-01],
	[3.2810000000E+04, 2.1651698781E+01, 4.9808434809E+00, 6.5168820871E+00, 2.4974864472E+00, 9.2705974711E-01],
	[3.2815000000E+04, 2.1657221240E+01, 4.9808451763E+00, 6.5200908571E+00, 2.4980314842E+00, 9.2709096520E-01],
	[3.2820000000E+04, 2.1662744266E+01, 4.9808468714E+00, 6.5233007170E+00, 2.4985764253E+00, 9.2712216879E-01],
	[3.2825000000E+04, 2.1668267859E+01, 4.9808485664E+00, 6.5265116670E+00, 2.4991212704E+00, 9.2715335788E-01],
	[3.2830000000E+04, 2.1673792018E+01, 4.9808502610E+00, 6.5297237072E+00, 2.4996660194E+00, 9.2718453248E-01],
	[3.2835000000E+04, 2.1679316744E+01, 4.9808519554E+00, 6.5329368379E+00, 2.5002106724E+00, 9.2721569260E-01],
	[3.2840000000E+04, 2.1684842037E+01, 4.9808536495E+00, 6.5361510592E+00, 2.5007552294E+00, 9.2724683824E-01],
	[3.2845000000E+04, 2.1690367897E+01, 4.9808553434E+00, 6.5393663715E+00, 2.5012996902E+00, 9.2727796941E-01],
	[3.2850000000E+04, 2.1695894323E+01, 4.9808570370E+00, 6.5425827748E+00, 2.5018440549E+00, 9.2730908612E-01],
	[3.2855000000E+04, 2.1701421316E+01, 4.9808587304E+00, 6.5458002694E+00, 2.5023883235E+00, 9.2734018837E-01],
	[3.2860000000E+04, 2.1706948875E+01, 4.9808604235E+00, 6.5490188555E+00, 2.5029324960E+00, 9.2737127617E-01],
	[3.2865000000E+04, 2.1712477001E+01, 4.9808621163E+00, 6.5522385332E+00, 2.5034765723E+00, 9.2740234953E-01],
	[3.2870000000E+04, 2.1718005694E+01, 4.9808638089E+00, 6.5554593029E+00, 2.5040205523E+00, 9.2743340846E-01],
	[3.2875000000E+04, 2.1723534953E+01, 4.9808655012E+00, 6.5586811647E+00, 2.5045644362E+00, 9.2746445295E-01],
	[3.2880000000E+04, 2.1729064779E+01, 4.9808671933E+00, 6.5619041188E+00, 2.5051082238E+00, 9.2749548303E-01],
	[3.2885000000E+04, 2.1734595171E+01, 4.9808688851E+00, 6.5651281654E+00, 2.5056519152E+00, 9.2752649869E-01],
	[3.2890000000E+04, 2.1740126130E+01, 4.9808705767E+00, 6.5683533047E+00, 2.5061955102E+00, 9.2755749994E-01],
	[3.2895000000E+04, 2.1745657655E+01, 4.9808722680E+00, 6.5715795369E+00, 2.5067390090E+00, 9.2758848679E-01],
	[3.2900000000E+04, 2.1751189746E+01, 4.9808739590E+00, 6.5748068622E+00, 2.5072824114E+00, 9.2761945924E-01],
	[3.2905000000E+04, 2.1756722404E+01, 4.9808756498E+00, 6.5780352809E+00, 2.5078257175E+00, 9.2765041731E-01],
	[3.2910000000E+04, 2.1762255628E+01, 4.9808773403E+00, 6.5812647931E+00, 2.5083689272E+00, 9.2768136100E-01],
	[3.2915000000E+04, 2.1767789418E+01, 4.9808790306E+00, 6.5844953990E+00, 2.5089120405E+00, 9.2771229031E-01],
	[3.2920000000E+04, 2.1773340528E+01, 4.9808833081E+00, 6.5877270988E+00, 2.5094559367E+00, 9.2774320526E-01],
	[3.2925000000E+04, 2.1778893407E+01, 4.9808877697E+00, 6.5909598928E+00, 2.5099997998E+00, 9.2777410584E-01],
	[3.2930000000E+04, 2.1784446858E+01, 4.9808922307E+00, 6.5941937811E+00, 2.5105435670E+00, 9.2780499207E-01],
	[3.2935000000E+04, 2.1790000883E+01, 4.9808966909E+00, 6.5974287640E+00, 2.5110872383E+00, 9.2783586396E-01],
	[3.2940000000E+04, 2.1795555479E+01, 4.9809011505E+00, 6.6006648416E+00, 2.5116308136E+00, 9.2786672150E-01],
	[3.2945000000E+04, 2.1801110648E+01, 4.9809056095E+00, 6.6039020142E+00, 2.5121742929E+00, 9.2789756471E-01],
	[3.2950000000E+04, 2.1806666390E+01, 4.9809100677E+00, 6.6071402819E+00, 2.5127176763E+00, 9.2792839360E-01],
	[3.2955000000E+04, 2.1812222705E+01, 4.9809145253E+00, 6.6103796450E+00, 2.5132609636E+00, 9.2795920817E-01],
	[3.2960000000E+04, 2.1817779591E+01, 4.9809189822E+00, 6.6136201036E+00, 2.5138041550E+00, 9.2799000842E-01],
	[3.2965000000E+04, 2.1823337051E+01, 4.9809234385E+00, 6.6168616580E+00, 2.5143472502E+00, 9.2802079437E-01],
	[3.2970000000E+04, 2.1828895082E+01, 4.9809278940E+00, 6.6201043084E+00, 2.5148902494E+00, 9.2805156602E-01],
	[3.2975000000E+04, 2.1834453686E+01, 4.9809323489E+00, 6.6233480550E+00, 2.5154331525E+00, 9.2808232337E-01],
	[3.2980000000E+04, 2.1840012862E+01, 4.9809368032E+00, 6.6265928979E+00, 2.5159759594E+00, 9.2811306644E-01],
	[3.2985000000E+04, 2.1845572611E+01, 4.9809412567E+00, 6.6298388375E+00, 2.5165186702E+00, 9.2814379524E-01],
	[3.2990000000E+04, 2.1851132932E+01, 4.9809457096E+00, 6.6330858738E+00, 2.5170612849E+00, 9.2817450976E-01],
	[3.2995000000E+04, 2.1856693825E+01, 4.9809501618E+00, 6.6363340071E+00, 2.5176038033E+00, 9.2820521002E-01],
	[3.3000000000E+04, 2.1862255291E+01, 4.9809546134E+00, 6.6395832376E+00, 2.5181462256E+00, 9.2823589601E-01],
	[3.3005000000E+04, 2.1867817329E+01, 4.9809590643E+00, 6.6428335655E+00, 2.5186885516E+00, 9.2826656775E-01],
	[3.3010000000E+04, 2.1873379939E+01, 4.9809635145E+00, 6.6460849910E+00, 2.5192307814E+00, 9.2829722525E-01],
	[3.3015000000E+04, 2.1878943121E+01, 4.9809679640E+00, 6.6493375143E+00, 2.5197729149E+00, 9.2832786851E-01],
	[3.3020000000E+04, 2.1884506875E+01, 4.9809724129E+00, 6.6525911356E+00, 2.5203149522E+00, 9.2835849753E-01],
	[3.3025000000E+04, 2.1890071201E+01, 4.9809768611E+00, 6.6558458551E+00, 2.5208568931E+00, 9.2838911232E-01],
	[3.3030000000E+04, 2.1895636100E+01, 4.9809813086E+00, 6.6591016731E+00, 2.5213987377E+00, 9.2841971289E-01],
	[3.3035000000E+04, 2.1901201570E+01, 4.9809857554E+00, 6.6623585897E+00, 2.5219404859E+00, 9.2845029925E-01],
	[3.3040000000E+04, 2.1906767612E+01, 4.9809902016E+00, 6.6656166051E+00, 2.5224821378E+00, 9.2848087139E-01],
	[3.3045000000E+04, 2.1912334227E+01, 4.9809946471E+00, 6.6688757195E+00, 2.5230236933E+00, 9.2851142934E-01],
	[3.3050000000E+04, 2.1917901413E+01, 4.9809990920E+00, 6.6721359331E+00, 2.5235651524E+00, 9.2854197308E-01],
	[3.3055000000E+04, 2.1923469172E+01, 4.9810035362E+00, 6.6753972462E+00, 2.5241065150E+00, 9.2857250264E-01],
	[3.3060000000E+04, 2.1929037502E+01, 4.9810079797E+00, 6.6786596590E+00, 2.5246477812E+00, 9.2860301801E-01],
	[3.3065000000E+04, 2.1934606404E+01, 4.9810124225E+00, 6.6819231716E+00, 2.5251889509E+00, 9.2863351921E-01],
	[3.3070000000E+04, 2.1940175878E+01, 4.9810168647E+00, 6.6851877842E+00, 2.5257300241E+00, 9.2866400623E-01],
	[3.3075000000E+04, 2.1945745924E+01, 4.9810213062E+00, 6.6884534971E+00, 2.5262710008E+00, 9.2869447909E-01],
	[3.3080000000E+04, 2.1951316542E+01, 4.9810257471E+00, 6.6917203104E+00, 2.5268118810E+00, 9.2872493779E-01],
	[3.3085000000E+04, 2.1956887731E+01, 4.9810301872E+00, 6.6949882245E+00, 2.5273526646E+00, 9.2875538234E-01],
	[3.3090000000E+04, 2.1962459492E+01, 4.9810346267E+00, 6.6982572393E+00, 2.5278933516E+00, 9.2878581274E-01],
	[3.3095000000E+04, 2.1968031825E+01, 4.9810390656E+00, 6.7015273553E+00, 2.5284339421E+00, 9.2881622900E-01],
	[3.3100000000E+04, 2.1973604730E+01, 4.9810435038E+00, 6.7047985725E+00, 2.5289744359E+00, 9.2884663113E-01],
	[3.3105000000E+04, 2.1979178206E+01, 4.9810479413E+00, 6.7080708912E+00, 2.5295148331E+00, 9.2887701913E-01],
	[3.3110000000E+04, 2.1984752254E+01, 4.9810523781E+00, 6.7113443116E+00, 2.5300551336E+00, 9.2890739301E-01],
	[3.3115000000E+04, 2.1990326873E+01, 4.9810568143E+00, 6.7146188338E+00, 2.5305953375E+00, 9.2893775278E-01],
	[3.3120000000E+04, 2.1995902065E+01, 4.9810612498E+00, 6.7178944582E+00, 2.5311354447E+00, 9.2896809843E-01],
	[3.3125000000E+04, 2.2001477827E+01, 4.9810656846E+00, 6.7211711848E+00, 2.5316754551E+00, 9.2899842999E-01],
	[3.3130000000E+04, 2.2007054161E+01, 4.9810701188E+00, 6.7244490140E+00, 2.5322153688E+00, 9.2902874745E-01],
	[3.3135000000E+04, 2.2012631067E+01, 4.9810745523E+00, 6.7277279458E+00, 2.5327551858E+00, 9.2905905082E-01],
	[3.3140000000E+04, 2.2018208544E+01, 4.9810789852E+00, 6.7310079806E+00, 2.5332949060E+00, 9.2908934011E-01],
	[3.3145000000E+04, 2.2023786593E+01, 4.9810834174E+00, 6.7342891184E+00, 2.5338345294E+00, 9.2911961532E-01],
	[3.3150000000E+04, 2.2029365213E+01, 4.9810878489E+00, 6.7375713596E+00, 2.5343740559E+00, 9.2914987646E-01],
	[3.3155000000E+04, 2.2034944404E+01, 4.9810922797E+00, 6.7408547043E+00, 2.5349134857E+00, 9.2918012353E-01],
	[3.3160000000E+04, 2.2040524167E+01, 4.9810967099E+00, 6.7441391527E+00, 2.5354528186E+00, 9.2921035655E-01],
	[3.3165000000E+04, 2.2046104501E+01, 4.9811011395E+00, 6.7474247051E+00, 2.5359920546E+00, 9.2924057552E-01],
	[3.3170000000E+04, 2.2051685406E+01, 4.9811055683E+00, 6.7507113615E+00, 2.5365311937E+00, 9.2927078044E-01],
	[3.3175000000E+04, 2.2057266883E+01, 4.9811099965E+00, 6.7539991224E+00, 2.5370702359E+00, 9.2930097132E-01],
	[3.3180000000E+04, 2.2062848931E+01, 4.9811144240E+00, 6.7572879877E+00, 2.5376091812E+00, 9.2933114817E-01],
	[3.3185000000E+04, 2.2068431550E+01, 4.9811188509E+00, 6.7605779578E+00, 2.5381480295E+00, 9.2936131099E-01],
	[3.3190000000E+04, 2.2074014740E+01, 4.9811232771E+00, 6.7638690328E+00, 2.5386867808E+00, 9.2939145979E-01],
	[3.3195000000E+04, 2.2079598501E+01, 4.9811277027E+00, 6.7671612130E+00, 2.5392254352E+00, 9.2942159458E-01],
	[3.3200000000E+04, 2.2085182834E+01, 4.9811321276E+00, 6.7704544986E+00, 2.5397639925E+00, 9.2945171536E-01],
	[3.3205000000E+04, 2.2090767738E+01, 4.9811365518E+00, 6.7737488897E+00, 2.5403024529E+00, 9.2948182214E-01],
	[3.3210000000E+04, 2.2096353213E+01, 4.9811409753E+00, 6.7770443865E+00, 2.5408408161E+00, 9.2951191493E-01],
	[3.3215000000E+04, 2.2101939258E+01, 4.9811453982E+00, 6.7803409894E+00, 2.5413790823E+00, 9.2954199373E-01],
	[3.3220000000E+04, 2.2107525875E+01, 4.9811498205E+00, 6.7836386984E+00, 2.5419172514E+00, 9.2957205854E-01],
	[3.3225000000E+04, 2.2113113063E+01, 4.9811542420E+00, 6.7869375138E+00, 2.5424553235E+00, 9.2960210938E-01],
	[3.3230000000E+04, 2.2118700822E+01, 4.9811586630E+00, 6.7902374357E+00, 2.5429932983E+00, 9.2963214625E-01],
	[3.3235000000E+04, 2.2124289152E+01, 4.9811630832E+00, 6.7935384645E+00, 2.5435311761E+00, 9.2966216916E-01],
	[3.3240000000E+04, 2.2129878052E+01, 4.9811675028E+00, 6.7968406002E+00, 2.5440689566E+00, 9.2969217810E-01],
	[3.3245000000E+04, 2.2135467524E+01, 4.9811719217E+00, 6.8001438431E+00, 2.5446066400E+00, 9.2972217310E-01],
	[3.3250000000E+04, 2.2141057566E+01, 4.9811763400E+00, 6.8034481935E+00, 2.5451442262E+00, 9.2975215416E-01],
	[3.3255000000E+04, 2.2146648180E+01, 4.9811807576E+00, 6.8067536514E+00, 2.5456817152E+00, 9.2978212127E-01],
	[3.3260000000E+04, 2.2152239364E+01, 4.9811851746E+00, 6.8100602171E+00, 2.5462191069E+00, 9.2981207446E-01],
	[3.3265000000E+04, 2.2157831119E+01, 4.9811895908E+00, 6.8133678909E+00, 2.5467564014E+00, 9.2984201371E-01],
	[3.3270000000E+04, 2.2163423444E+01, 4.9811940065E+00, 6.8166766728E+00, 2.5472935986E+00, 9.2987193905E-01],
	[3.3275000000E+04, 2.2169016341E+01, 4.9811984214E+00, 6.8199865632E+00, 2.5478306985E+00, 9.2990185048E-01],
	[3.3280000000E+04, 2.2174609808E+01, 4.9812028358E+00, 6.8232975622E+00, 2.5483677011E+00, 9.2993174800E-01],
	[3.3285000000E+04, 2.2180203845E+01, 4.9812072494E+00, 6.8266096700E+00, 2.5489046063E+00, 9.2996163162E-01],
	[3.3290000000E+04, 2.2185798454E+01, 4.9812116624E+00, 6.8299228869E+00, 2.5494414142E+00, 9.2999150134E-01],
	[3.3295000000E+04, 2.2191393633E+01, 4.9812160747E+00, 6.8332372130E+00, 2.5499781248E+00, 9.3002135718E-01],
	[3.3300000000E+04, 2.2196989382E+01, 4.9812204864E+00, 6.8365526485E+00, 2.5505147379E+00, 9.3005119914E-01],
	[3.3305000000E+04, 2.2202585702E+01, 4.9812248974E+00, 6.8398691937E+00, 2.5510512536E+00, 9.3008102722E-01],
	[3.3310000000E+04, 2.2208182593E+01, 4.9812293078E+00, 6.8431868487E+00, 2.5515876719E+00, 9.3011084143E-01],
	[3.3315000000E+04, 2.2213780054E+01, 4.9812337175E+00, 6.8465056138E+00, 2.5521239928E+00, 9.3014064178E-01],
	[3.3320000000E+04, 2.2219378086E+01, 4.9812381265E+00, 6.8498254892E+00, 2.5526602162E+00, 9.3017042827E-01],
	[3.3325000000E+04, 2.2224976688E+01, 4.9812425349E+00, 6.8531464750E+00, 2.5531963421E+00, 9.3020020092E-01],
	[3.3330000000E+04, 2.2230575860E+01, 4.9812469426E+00, 6.8564685714E+00, 2.5537323705E+00, 9.3022995972E-01],
	[3.3335000000E+04, 2.2236175603E+01, 4.9812513497E+00, 6.8597917787E+00, 2.5542683014E+00, 9.3025970468E-01],
	[3.3340000000E+04, 2.2241775916E+01, 4.9812557561E+00, 6.8631160972E+00, 2.5548041348E+00, 9.3028943581E-01],
	[3.3345000000E+04, 2.2247376800E+01, 4.9812601619E+00, 6.8664415268E+00, 2.5553398706E+00, 9.3031915312E-01],
	[3.3350000000E+04, 2.2252978254E+01, 4.9812645669E+00, 6.8697680680E+00, 2.5558755088E+00, 9.3034885661E-01],
	[3.3355000000E+04, 2.2258580278E+01, 4.9812689714E+00, 6.8730957209E+00, 2.5564110495E+00, 9.3037854628E-01],
	[3.3360000000E+04, 2.2264182873E+01, 4.9812733752E+00, 6.8764244856E+00, 2.5569464925E+00, 9.3040822215E-01],
	[3.3365000000E+04, 2.2269786037E+01, 4.9812777783E+00, 6.8797543625E+00, 2.5574818379E+00, 9.3043788422E-01],
	[3.3370000000E+04, 2.2275389772E+01, 4.9812821808E+00, 6.8830853516E+00, 2.5580170857E+00, 9.3046753250E-01],
	[3.3375000000E+04, 2.2280994077E+01, 4.9812865826E+00, 6.8864174532E+00, 2.5585522358E+00, 9.3049716699E-01],
	[3.3380000000E+04, 2.2286598952E+01, 4.9812909838E+00, 6.8897506676E+00, 2.5590872882E+00, 9.3052678770E-01],
	[3.3385000000E+04, 2.2292204398E+01, 4.9812953843E+00, 6.8930849949E+00, 2.5596222429E+00, 9.3055639464E-01],
	[3.3390000000E+04, 2.2297810413E+01, 4.9812997841E+00, 6.8964204353E+00, 2.5601570999E+00, 9.3058598781E-01],
	[3.3395000000E+04, 2.2303416999E+01, 4.9813041833E+00, 6.8997569890E+00, 2.5606918592E+00, 9.3061556721E-01],
	[3.3400000000E+04, 2.2309024154E+01, 4.9813085819E+00, 6.9030946562E+00, 2.5612265207E+00, 9.3064513286E-01],
	[3.3405000000E+04, 2.2314631880E+01, 4.9813129797E+00, 6.9064334372E+00, 2.5617610845E+00, 9.3067468477E-01],
	[3.3410000000E+04, 2.2320240175E+01, 4.9813173770E+00, 6.9097733321E+00, 2.5622955504E+00, 9.3070422292E-01],
	[3.3415000000E+04, 2.2325849040E+01, 4.9813217736E+00, 6.9131143411E+00, 2.5628299186E+00, 9.3073374735E-01],
	[3.3420000000E+04, 2.2331458476E+01, 4.9813261695E+00, 6.9164564645E+00, 2.5633641889E+00, 9.3076325804E-01],
	[3.3425000000E+04, 2.2337068481E+01, 4.9813305647E+00, 6.9197997025E+00, 2.5638983614E+00, 9.3079275501E-01],
	[3.3430000000E+04, 2.2342679056E+01, 4.9813349594E+00, 6.9231440552E+00, 2.5644324360E+00, 9.3082223826E-01],
	[3.3435000000E+04, 2.2348290201E+01, 4.9813393533E+00, 6.9264895228E+00, 2.5649664128E+00, 9.3085170780E-01],
	[3.3440000000E+04, 2.2353901916E+01, 4.9813437466E+00, 6.9298361056E+00, 2.5655002917E+00, 9.3088116363E-01],
	[3.3445000000E+04, 2.2359514201E+01, 4.9813481393E+00, 6.9331838038E+00, 2.5660340726E+00, 9.3091060576E-01],
	[3.3450000000E+04, 2.2365144021E+01, 4.9813551261E+00, 6.9365326176E+00, 2.5665686679E+00, 9.3094003421E-01],
	[3.3455000000E+04, 2.2370775218E+01, 4.9813622344E+00, 6.9398825471E+00, 2.5671032088E+00, 9.3096944896E-01],
	[3.3460000000E+04, 2.2376406991E+01, 4.9813693416E+00, 6.9432335926E+00, 2.5676376523E+00, 9.3099885004E-01],
	[3.3465000000E+04, 2.2382039340E+01, 4.9813764478E+00, 6.9465857543E+00, 2.5681719984E+00, 9.3102823744E-01],
	[3.3470000000E+04, 2.2387672265E+01, 4.9813835530E+00, 6.9499390324E+00, 2.5687062470E+00, 9.3105761118E-01],
	[3.3475000000E+04, 2.2393305766E+01, 4.9813906570E+00, 6.9532934271E+00, 2.5692403981E+00, 9.3108697125E-01],
	[3.3480000000E+04, 2.2398939843E+01, 4.9813977601E+00, 6.9566489385E+00, 2.5697744517E+00, 9.3111631767E-01],
	[3.3485000000E+04, 2.2404574496E+01, 4.9814048621E+00, 6.9600055670E+00, 2.5703084078E+00, 9.3114565044E-01],
	[3.3490000000E+04, 2.2410209724E+01, 4.9814119630E+00, 6.9633633127E+00, 2.5708422664E+00, 9.3117496957E-01],
	[3.3495000000E+04, 2.2415845529E+01, 4.9814190629E+00, 6.9667221758E+00, 2.5713760274E+00, 9.3120427507E-01],
	[3.3500000000E+04, 2.2421481909E+01, 4.9814261617E+00, 6.9700821565E+00, 2.5719096908E+00, 9.3123356693E-01],
	[3.3505000000E+04, 2.2427118864E+01, 4.9814332595E+00, 6.9734432551E+00, 2.5724432567E+00, 9.3126284517E-01],
	[3.3510000000E+04, 2.2432756396E+01, 4.9814403562E+00, 6.9768054716E+00, 2.5729767249E+00, 9.3129210979E-01],
	[3.3515000000E+04, 2.2438394503E+01, 4.9814474519E+00, 6.9801688064E+00, 2.5735100956E+00, 9.3132136081E-01],
	[3.3520000000E+04, 2.2444033186E+01, 4.9814545465E+00, 6.9835332596E+00, 2.5740433686E+00, 9.3135059821E-01],
	[3.3525000000E+04, 2.2449672445E+01, 4.9814616401E+00, 6.9868988315E+00, 2.5745765439E+00, 9.3137982202E-01],
	[3.3530000000E+04, 2.2455312279E+01, 4.9814687327E+00, 6.9902655222E+00, 2.5751096216E+00, 9.3140903224E-01],
	[3.3535000000E+04, 2.2460952688E+01, 4.9814758241E+00, 6.9936333320E+00, 2.5756426015E+00, 9.3143822887E-01],
	[3.3540000000E+04, 2.2466593673E+01, 4.9814829146E+00, 6.9970022610E+00, 2.5761754838E+00, 9.3146741193E-01],
	[3.3545000000E+04, 2.2472235234E+01, 4.9814900040E+00, 7.0003723095E+00, 2.5767082684E+00, 9.3149658141E-01],
	[3.3550000000E+04, 2.2477877370E+01, 4.9814970923E+00, 7.0037434776E+00, 2.5772409552E+00, 9.3152573732E-01],
	[3.3555000000E+04, 2.2483520082E+01, 4.9815041796E+00, 7.0071157656E+00, 2.5777735442E+00, 9.3155487967E-01],
	[3.3560000000E+04, 2.2489163369E+01, 4.9815112659E+00, 7.0104891737E+00, 2.5783060355E+00, 9.3158400847E-01],
	[3.3565000000E+04, 2.2494807232E+01, 4.9815183511E+00, 7.0138637020E+00, 2.5788384290E+00, 9.3161312372E-01],
	[3.3570000000E+04, 2.2500451670E+01, 4.9815254353E+00, 7.0172393509E+00, 2.5793707247E+00, 9.3164222543E-01],
	[3.3575000000E+04, 2.2506096683E+01, 4.9815325184E+00, 7.0206161204E+00, 2.5799029226E+00, 9.3167131361E-01],
	[3.3580000000E+04, 2.2511742272E+01, 4.9815396005E+00, 7.0239940108E+00, 2.5804350226E+00, 9.3170038825E-01],
	[3.3585000000E+04, 2.2517388436E+01, 4.9815466815E+00, 7.0273730223E+00, 2.5809670248E+00, 9.3172944937E-01],
	[3.3590000000E+04, 2.2523035175E+01, 4.9815537615E+00, 7.0307531551E+00, 2.5814989291E+00, 9.3175849698E-01],
	[3.3595000000E+04, 2.2528682490E+01, 4.9815608404E+00, 7.0341344094E+00, 2.5820307355E+00, 9.3178753107E-01],
	[3.3600000000E+04, 2.2534330379E+01, 4.9815679184E+00, 7.0375167854E+00, 2.5825624440E+00, 9.3181655167E-01],
	[3.3605000000E+04, 2.2539978844E+01, 4.9815749952E+00, 7.0409002833E+00, 2.5830940546E+00, 9.3184555876E-01],
	[3.3610000000E+04, 2.2545627884E+01, 4.9815820710E+00, 7.0442849034E+00, 2.5836255673E+00, 9.3187455236E-01],
	[3.3615000000E+04, 2.2551277500E+01, 4.9815891458E+00, 7.0476706458E+00, 2.5841569820E+00, 9.3190353248E-01],
	[3.3620000000E+04, 2.2556927690E+01, 4.9815962195E+00, 7.0510575107E+00, 2.5846882987E+00, 9.3193249912E-01],
	[3.3625000000E+04, 2.2562578455E+01, 4.9816032922E+00, 7.0544454983E+00, 2.5852195175E+00, 9.3196145228E-01],
	[3.3630000000E+04, 2.2568229796E+01, 4.9816103639E+00, 7.0578346089E+00, 2.5857506382E+00, 9.3199039198E-01],
	[3.3635000000E+04, 2.2573881711E+01, 4.9816174345E+00, 7.0612248426E+00, 2.5862816609E+00, 9.3201931822E-01],
	[3.3640000000E+04, 2.2579534202E+01, 4.9816245040E+00, 7.0646161997E+00, 2.5868125856E+00, 9.3204823101E-01],
	[3.3645000000E+04, 2.2585187268E+01, 4.9816315726E+00, 7.0680086803E+00, 2.5873434123E+00, 9.3207713034E-01],
	[3.3650000000E+04, 2.2590840908E+01, 4.9816386401E+00, 7.0714022846E+00, 2.5878741408E+00, 9.3210601624E-01],
	[3.3655000000E+04, 2.2596495124E+01, 4.9816457065E+00, 7.0747970130E+00, 2.5884047713E+00, 9.3213488870E-01],
	[3.3660000000E+04, 2.2602149914E+01, 4.9816527719E+00, 7.0781928655E+00, 2.5889353037E+00, 9.3216374774E-01],
	[3.3665000000E+04, 2.2607805279E+01, 4.9816598363E+00, 7.0815898423E+00, 2.5894657380E+00, 9.3219259335E-01],
	[3.3670000000E+04, 2.2613461219E+01, 4.9816668996E+00, 7.0849879438E+00, 2.5899960741E+00, 9.3222142554E-01],
	[3.3675000000E+04, 2.2619117734E+01, 4.9816739619E+00, 7.0883871700E+00, 2.5905263121E+00, 9.3225024433E-01],
	[3.3680000000E+04, 2.2624774824E+01, 4.9816810231E+00, 7.0917875212E+00, 2.5910564520E+00, 9.3227904971E-01],
	[3.3685000000E+04, 2.2630432488E+01, 4.9816880833E+00, 7.0951889976E+00, 2.5915864936E+00, 9.3230784169E-01],
	[3.3690000000E+04, 2.2636090727E+01, 4.9816951425E+00, 7.0985915994E+00, 2.5921164371E+00, 9.3233662029E-01],
	[3.3695000000E+04, 2.2641749541E+01, 4.9817022007E+00, 7.1019953268E+00, 2.5926462823E+00, 9.3236538549E-01],
	[3.3700000000E+04, 2.2647408930E+01, 4.9817092578E+00, 7.1054001800E+00, 2.5931760293E+00, 9.3239413732E-01],
	[3.3705000000E+04, 2.2653068893E+01, 4.9817163138E+00, 7.1088061592E+00, 2.5937056781E+00, 9.3242287578E-01],
	[3.3710000000E+04, 2.2658729431E+01, 4.9817233688E+00, 7.1122132646E+00, 2.5942352287E+00, 9.3245160087E-01],
	[3.3715000000E+04, 2.2664390544E+01, 4.9817304228E+00, 7.1156214965E+00, 2.5947646809E+00, 9.3248031261E-01],
	[3.3720000000E+04, 2.2670052231E+01, 4.9817374758E+00, 7.1190308549E+00, 2.5952940349E+00, 9.3250901098E-01],
	[3.3725000000E+04, 2.2675714492E+01, 4.9817445277E+00, 7.1224413402E+00, 2.5958232905E+00, 9.3253769601E-01],
	[3.3730000000E+04, 2.2681377328E+01, 4.9817515786E+00, 7.1258529525E+00, 2.5963524479E+00, 9.3256636770E-01],
	[3.3735000000E+04, 2.2687040739E+01, 4.9817586284E+00, 7.1292656921E+00, 2.5968815069E+00, 9.3259502606E-01],
	[3.3740000000E+04, 2.2692704724E+01, 4.9817656772E+00, 7.1326795591E+00, 2.5974104676E+00, 9.3262367109E-01],
	[3.3745000000E+04, 2.2698369284E+01, 4.9817727250E+00, 7.1360945538E+00, 2.5979393299E+00, 9.3265230279E-01],
	[3.3750000000E+04, 2.2704034418E+01, 4.9817797718E+00, 7.1395106763E+00, 2.5984680938E+00, 9.3268092118E-01],
	[3.3755000000E+04, 2.2709700126E+01, 4.9817868175E+00, 7.1429279268E+00, 2.5989967593E+00, 9.3270952626E-01],
	[3.3760000000E+04, 2.2715366409E+01, 4.9817938621E+00, 7.1463463057E+00, 2.5995253264E+00, 9.3273811804E-01],
	[3.3765000000E+04, 2.2721033266E+01, 4.9818009058E+00, 7.1497658130E+00, 2.6000537951E+00, 9.3276669651E-01],
	[3.3770000000E+04, 2.2726700697E+01, 4.9818079484E+00, 7.1531864489E+00, 2.6005821653E+00, 9.3279526170E-01],
	[3.3775000000E+04, 2.2732368703E+01, 4.9818149900E+00, 7.1566082138E+00, 2.6011104371E+00, 9.3282381360E-01],
	[3.3780000000E+04, 2.2738037283E+01, 4.9818220305E+00, 7.1600311077E+00, 2.6016386104E+00, 9.3285235223E-01],
	[3.3785000000E+04, 2.2743706437E+01, 4.9818290700E+00, 7.1634551309E+00, 2.6021666852E+00, 9.3288087758E-01],
	[3.3790000000E+04, 2.2749376166E+01, 4.9818361085E+00, 7.1668802837E+00, 2.6026946616E+00, 9.3290938967E-01],
	[3.3795000000E+04, 2.2755046468E+01, 4.9818431459E+00, 7.1703065661E+00, 2.6032225394E+00, 9.3293788850E-01],
	[3.3800000000E+04, 2.2760717345E+01, 4.9818501824E+00, 7.1737339784E+00, 2.6037503186E+00, 9.3296637407E-01],
	[3.3805000000E+04, 2.2766388796E+01, 4.9818572177E+00, 7.1771625208E+00, 2.6042779994E+00, 9.3299484640E-01],
	[3.3810000000E+04, 2.2772060821E+01, 4.9818642521E+00, 7.1805921935E+00, 2.6048055815E+00, 9.3302330548E-01],
	[3.3815000000E+04, 2.2777733420E+01, 4.9818712854E+00, 7.1840229968E+00, 2.6053330651E+00, 9.3305175133E-01],
	[3.3820000000E+04, 2.2783406593E+01, 4.9818783177E+00, 7.1874549308E+00, 2.6058604501E+00, 9.3308018396E-01],
	[3.3825000000E+04, 2.2789080340E+01, 4.9818853490E+00, 7.1908879957E+00, 2.6063877365E+00, 9.3310860336E-01],
	[3.3830000000E+04, 2.2794754661E+01, 4.9818923792E+00, 7.1943221917E+00, 2.6069149243E+00, 9.3313700954E-01],
	[3.3835000000E+04, 2.2800429556E+01, 4.9818994084E+00, 7.1977575190E+00, 2.6074420134E+00, 9.3316540251E-01],
	[3.3840000000E+04, 2.2806105025E+01, 4.9819064366E+00, 7.2011939780E+00, 2.6079690039E+00, 9.3319378229E-01],
	[3.3845000000E+04, 2.2811781068E+01, 4.9819134638E+00, 7.2046315686E+00, 2.6084958957E+00, 9.3322214886E-01],
	[3.3850000000E+04, 2.2817457684E+01, 4.9819204899E+00, 7.2080702912E+00, 2.6090226889E+00, 9.3325050224E-01],
	[3.3855000000E+04, 2.2823134875E+01, 4.9819275150E+00, 7.2115101460E+00, 2.6095493833E+00, 9.3327884244E-01],
	[3.3860000000E+04, 2.2828812639E+01, 4.9819345390E+00, 7.2149511331E+00, 2.6100759791E+00, 9.3330716946E-01],
	[3.3865000000E+04, 2.2834490978E+01, 4.9819415621E+00, 7.2183932528E+00, 2.6106024761E+00, 9.3333548331E-01],
	[3.3870000000E+04, 2.2840169889E+01, 4.9819485841E+00, 7.2218365053E+00, 2.6111288744E+00, 9.3336378399E-01],
	[3.3875000000E+04, 2.2845849375E+01, 4.9819556051E+00, 7.2252808907E+00, 2.6116551739E+00, 9.3339207152E-01],
	[3.3880000000E+04, 2.2851529435E+01, 4.9819626250E+00, 7.2287264094E+00, 2.6121813746E+00, 9.3342034588E-01],
	[3.3885000000E+04, 2.2857210068E+01, 4.9819696440E+00, 7.2321730614E+00, 2.6127074766E+00, 9.3344860711E-01],
	[3.3890000000E+04, 2.2862891275E+01, 4.9819766619E+00, 7.2356208470E+00, 2.6132334798E+00, 9.3347685519E-01],
	[3.3895000000E+04, 2.2868573055E+01, 4.9819836788E+00, 7.2390697664E+00, 2.6137593842E+00, 9.3350509013E-01],
	[3.3900000000E+04, 2.2874255409E+01, 4.9819906946E+00, 7.2425198198E+00, 2.6142851897E+00, 9.3353331195E-01],
	[3.3905000000E+04, 2.2879938337E+01, 4.9819977095E+00, 7.2459710074E+00, 2.6148108964E+00, 9.3356152064E-01],
	[3.3910000000E+04, 2.2885621838E+01, 4.9820047233E+00, 7.2494233295E+00, 2.6153365043E+00, 9.3358971622E-01],
	[3.3915000000E+04, 2.2891305913E+01, 4.9820117360E+00, 7.2528767861E+00, 2.6158620133E+00, 9.3361789869E-01],
	[3.3920000000E+04, 2.2896990561E+01, 4.9820187478E+00, 7.2563313776E+00, 2.6163874234E+00, 9.3364606806E-01],
	[3.3925000000E+04, 2.2902675783E+01, 4.9820257585E+00, 7.2597871041E+00, 2.6169127346E+00, 9.3367422432E-01],
	[3.3930000000E+04, 2.2908361578E+01, 4.9820327683E+00, 7.2632439658E+00, 2.6174379470E+00, 9.3370236750E-01],
	[3.3935000000E+04, 2.2914047947E+01, 4.9820397769E+00, 7.2667019630E+00, 2.6179630604E+00, 9.3373049759E-01],
	[3.3940000000E+04, 2.2919734889E+01, 4.9820467846E+00, 7.2701610958E+00, 2.6184880748E+00, 9.3375861460E-01],
	[3.3945000000E+04, 2.2925422404E+01, 4.9820537913E+00, 7.2736213645E+00, 2.6190129903E+00, 9.3378671854E-01],
	[3.3950000000E+04, 2.2931110493E+01, 4.9820607969E+00, 7.2770827692E+00, 2.6195378069E+00, 9.3381480942E-01],
	[3.3955000000E+04, 2.2936799155E+01, 4.9820678015E+00, 7.2805453102E+00, 2.6200625244E+00, 9.3384288723E-01],
	[3.3960000000E+04, 2.2942488391E+01, 4.9820748051E+00, 7.2840089877E+00, 2.6205871430E+00, 9.3387095199E-01],
	[3.3965000000E+04, 2.2948178199E+01, 4.9820818076E+00, 7.2874738018E+00, 2.6211116626E+00, 9.3389900370E-01],
	[3.3970000000E+04, 2.2953868581E+01, 4.9820888091E+00, 7.2909397528E+00, 2.6216360831E+00, 9.3392704238E-01],
	[3.3975000000E+04, 2.2959559536E+01, 4.9820958097E+00, 7.2944068409E+00, 2.6221604046E+00, 9.3395506801E-01],
	[3.3980000000E+04, 2.2965251064E+01, 4.9821028092E+00, 7.2978750662E+00, 2.6226846271E+00, 9.3398308062E-01],
	[3.3985000000E+04, 2.2970947919E+01, 4.9821105279E+00, 7.3013444291E+00, 2.6232090122E+00, 9.3401108020E-01],
	[3.3990000000E+04, 2.2976658175E+01, 4.9821201888E+00, 7.3048149296E+00, 2.6237340045E+00, 9.3403906677E-01],
	[3.3995000000E+04, 2.2982369010E+01, 4.9821298484E+00, 7.3082865681E+00, 2.6242588983E+00, 9.3406704033E-01],
	[3.4000000000E+04, 2.2988080424E+01, 4.9821395065E+00, 7.3117593446E+00, 2.6247836935E+00, 9.3409500088E-01],
	[3.4005000000E+04, 2.2993792417E+01, 4.9821491632E+00, 7.3152332595E+00, 2.6253083901E+00, 9.3412294843E-01],
	[3.4010000000E+04, 2.2999504990E+01, 4.9821588186E+00, 7.3187083129E+00, 2.6258329881E+00, 9.3415088300E-01],
	[3.4015000000E+04, 2.3005218142E+01, 4.9821684725E+00, 7.3221845050E+00, 2.6263574874E+00, 9.3417880458E-01],
	[3.4020000000E+04, 2.3010931872E+01, 4.9821781250E+00, 7.3256618360E+00, 2.6268818881E+00, 9.3420671317E-01],
	[3.4025000000E+04, 2.3016646182E+01, 4.9821877761E+00, 7.3291403062E+00, 2.6274061902E+00, 9.3423460880E-01],
	[3.4030000000E+04, 2.3022361071E+01, 4.9821974259E+00, 7.3326199157E+00, 2.6279303936E+00, 9.3426249146E-01],
	[3.4035000000E+04, 2.3028076539E+01, 4.9822070742E+00, 7.3361006647E+00, 2.6284544983E+00, 9.3429036116E-01],
	[3.4040000000E+04, 2.3033792587E+01, 4.9822167211E+00, 7.3395825535E+00, 2.6289785043E+00, 9.3431821790E-01],
	[3.4045000000E+04, 2.3039509213E+01, 4.9822263667E+00, 7.3430655822E+00, 2.6295024116E+00, 9.3434606170E-01],
	[3.4050000000E+04, 2.3045226418E+01, 4.9822360108E+00, 7.3465497511E+00, 2.6300262202E+00, 9.3437389255E-01],
	[3.4055000000E+04, 2.3050944202E+01, 4.9822456535E+00, 7.3500350604E+00, 2.6305499301E+00, 9.3440171047E-01],
	[3.4060000000E+04, 2.3056662564E+01, 4.9822552949E+00, 7.3535215103E+00, 2.6310735412E+00, 9.3442951545E-01],
	[3.4065000000E+04, 2.3062381506E+01, 4.9822649348E+00, 7.3570091009E+00, 2.6315970535E+00, 9.3445730752E-01],
	[3.4070000000E+04, 2.3068101027E+01, 4.9822745734E+00, 7.3604978325E+00, 2.6321204671E+00, 9.3448508667E-01],
	[3.4075000000E+04, 2.3073821126E+01, 4.9822842105E+00, 7.3639877052E+00, 2.6326437819E+00, 9.3451285290E-01],
	[3.4080000000E+04, 2.3079541804E+01, 4.9822938463E+00, 7.3674787194E+00, 2.6331669979E+00, 9.3454060623E-01],
	[3.4085000000E+04, 2.3085263061E+01, 4.9823034806E+00, 7.3709708752E+00, 2.6336901151E+00, 9.3456834666E-01],
	[3.4090000000E+04, 2.3090984897E+01, 4.9823131136E+00, 7.3744641728E+00, 2.6342131334E+00, 9.3459607420E-01],
	[3.4095000000E+04, 2.3096707311E+01, 4.9823227452E+00, 7.3779586123E+00, 2.6347360529E+00, 9.3462378886E-01],
	[3.4100000000E+04, 2.3102430304E+01, 4.9823323753E+00, 7.3814541941E+00, 2.6352588736E+00, 9.3465149063E-01],
	[3.4105000000E+04, 2.3108153876E+01, 4.9823420041E+00, 7.3849509183E+00, 2.6357815954E+00, 9.3467917953E-01],
	[3.4110000000E+04, 2.3113878027E+01, 4.9823516315E+00, 7.3884487851E+00, 2.6363042183E+00, 9.3470685556E-01],
	[3.4115000000E+04, 2.3119602756E+01, 4.9823612575E+00, 7.3919477948E+00, 2.6368267423E+00, 9.3473451873E-01],
	[3.4120000000E+04, 2.3125328063E+01, 4.9823708821E+00, 7.3954479475E+00, 2.6373491675E+00, 9.3476216905E-01],
	[3.4125000000E+04, 2.3131053949E+01, 4.9823805053E+00, 7.3989492434E+00, 2.6378714937E+00, 9.3478980652E-01],
	[3.4130000000E+04, 2.3136780414E+01, 4.9823901272E+00, 7.4024516828E+00, 2.6383937209E+00, 9.3481743114E-01],
	[3.4135000000E+04, 2.3142507457E+01, 4.9823997476E+00, 7.4059552658E+00, 2.6389158493E+00, 9.3484504293E-01],
	[3.4140000000E+04, 2.3148235079E+01, 4.9824093666E+00, 7.4094599927E+00, 2.6394378787E+00, 9.3487264188E-01],
	[3.4145000000E+04, 2.3153963279E+01, 4.9824189843E+00, 7.4129658637E+00, 2.6399598091E+00, 9.3490022801E-01],
	[3.4150000000E+04, 2.3159692058E+01, 4.9824286006E+00, 7.4164728789E+00, 2.6404816405E+00, 9.3492780133E-01],
	[3.4155000000E+04, 2.3165421415E+01, 4.9824382154E+00, 7.4199810385E+00, 2.6410033729E+00, 9.3495536183E-01],
	[3.4160000000E+04, 2.3171151350E+01, 4.9824478289E+00, 7.4234903429E+00, 2.6415250064E+00, 9.3498290952E-01],
	[3.4165000000E+04, 2.3176881864E+01, 4.9824574410E+00, 7.4270007921E+00, 2.6420465408E+00, 9.3501044442E-01],
	[3.4170000000E+04, 2.3182612956E+01, 4.9824670517E+00, 7.4305123865E+00, 2.6425679762E+00, 9.3503796652E-01],
	[3.4175000000E+04, 2.3188344626E+01, 4.9824766610E+00, 7.4340251261E+00, 2.6430893125E+00, 9.3506547583E-01],
	[3.4180000000E+04, 2.3194076875E+01, 4.9824862690E+00, 7.4375390112E+00, 2.6436105498E+00, 9.3509297237E-01],
	[3.4185000000E+04, 2.3199809702E+01, 4.9824958755E+00, 7.4410540420E+00, 2.6441316881E+00, 9.3512045613E-01],
	[3.4190000000E+04, 2.3205543107E+01, 4.9825054807E+00, 7.4445702188E+00, 2.6446527272E+00, 9.3514792712E-01],
	[3.4195000000E+04, 2.3211277090E+01, 4.9825150844E+00, 7.4480875416E+00, 2.6451736672E+00, 9.3517538534E-01],
	[3.4200000000E+04, 2.3217011652E+01, 4.9825246868E+00, 7.4516060108E+00, 2.6456945082E+00, 9.3520283081E-01],
	[3.4205000000E+04, 2.3222746791E+01, 4.9825342878E+00, 7.4551256265E+00, 2.6462152500E+00, 9.3523026353E-01],
	[3.4210000000E+04, 2.3228482509E+01, 4.9825438875E+00, 7.4586463889E+00, 2.6467358927E+00, 9.3525768351E-01],
	[3.4215000000E+04, 2.3234218805E+01, 4.9825534857E+00, 7.4621682983E+00, 2.6472564363E+00, 9.3528509075E-01],
	[3.4220000000E+04, 2.3239955679E+01, 4.9825630825E+00, 7.4656913548E+00, 2.6477768807E+00, 9.3531248525E-01],
	[3.4225000000E+04, 2.3245693131E+01, 4.9825726780E+00, 7.4692155586E+00, 2.6482972259E+00, 9.3533986703E-01],
	[3.4230000000E+04, 2.3251431161E+01, 4.9825822721E+00, 7.4727409100E+00, 2.6488174720E+00, 9.3536723610E-01],
	[3.4235000000E+04, 2.3257169769E+01, 4.9825918648E+00, 7.4762674092E+00, 2.6493376189E+00, 9.3539459244E-01],
	[3.4240000000E+04, 2.3262908954E+01, 4.9826014561E+00, 7.4797950564E+00, 2.6498576666E+00, 9.3542193608E-01],
	[3.4245000000E+04, 2.3268648718E+01, 4.9826110460E+00, 7.4833238517E+00, 2.6503776150E+00, 9.3544926702E-01],
	[3.4250000000E+04, 2.3274389060E+01, 4.9826206346E+00, 7.4868537953E+00, 2.6508974643E+00, 9.3547658527E-01],
	[3.4255000000E+04, 2.3280129979E+01, 4.9826302218E+00, 7.4903848876E+00, 2.6514172143E+00, 9.3550389082E-01],
	[3.4260000000E+04, 2.3285871477E+01, 4.9826398076E+00, 7.4939171287E+00, 2.6519368650E+00, 9.3553118370E-01],
	[3.4265000000E+04, 2.3291613552E+01, 4.9826493920E+00, 7.4974505187E+00, 2.6524564165E+00, 9.3555846389E-01],
	[3.4270000000E+04, 2.3297356205E+01, 4.9826589750E+00, 7.5009850580E+00, 2.6529758687E+00, 9.3558573142E-01],
	[3.4275000000E+04, 2.3303099436E+01, 4.9826685567E+00, 7.5045207466E+00, 2.6534952216E+00, 9.3561298628E-01],
	[3.4280000000E+04, 2.3308843244E+01, 4.9826781369E+00, 7.5080575849E+00, 2.6540144753E+00, 9.3564022849E-01],
	[3.4285000000E+04, 2.3314587631E+01, 4.9826877158E+00, 7.5115955729E+00, 2.6545336296E+00, 9.3566745804E-01],
	[3.4290000000E+04, 2.3320332595E+01, 4.9826972933E+00, 7.5151347110E+00, 2.6550526846E+00, 9.3569467495E-01],
	[3.4295000000E+04, 2.3326078136E+01, 4.9827068695E+00, 7.5186749994E+00, 2.6555716403E+00, 9.3572187922E-01],
	[3.4300000000E+04, 2.3331824256E+01, 4.9827164442E+00, 7.5222164381E+00, 2.6560904966E+00, 9.3574907085E-01],
	[3.4305000000E+04, 2.3337570953E+01, 4.9827260176E+00, 7.5257590275E+00, 2.6566092536E+00, 9.3577624986E-01],
	[3.4310000000E+04, 2.3343318227E+01, 4.9827355896E+00, 7.5293027677E+00, 2.6571279112E+00, 9.3580341624E-01],
	[3.4315000000E+04, 2.3349066079E+01, 4.9827451602E+00, 7.5328476590E+00, 2.6576464694E+00, 9.3583057001E-01],
	[3.4320000000E+04, 2.3354814509E+01, 4.9827547295E+00, 7.5363937016E+00, 2.6581649283E+00, 9.3585771118E-01],
	[3.4325000000E+04, 2.3360563516E+01, 4.9827642974E+00, 7.5399408956E+00, 2.6586832877E+00, 9.3588483974E-01],
	[3.4330000000E+04, 2.3366313101E+01, 4.9827738639E+00, 7.5434892412E+00, 2.6592015478E+00, 9.3591195570E-01],
	[3.4335000000E+04, 2.3372063263E+01, 4.9827834290E+00, 7.5470387388E+00, 2.6597197084E+00, 9.3593905907E-01],
	[3.4340000000E+04, 2.3377814002E+01, 4.9827929928E+00, 7.5505893884E+00, 2.6602377695E+00, 9.3596614986E-01],
	[3.4345000000E+04, 2.3383565319E+01, 4.9828025551E+00, 7.5541411903E+00, 2.6607557313E+00, 9.3599322807E-01],
	[3.4350000000E+04, 2.3389317213E+01, 4.9828121161E+00, 7.5576941447E+00, 2.6612735935E+00, 9.3602029370E-01],
	[3.4355000000E+04, 2.3395069685E+01, 4.9828216758E+00, 7.5612482517E+00, 2.6617913563E+00, 9.3604734677E-01],
	[3.4360000000E+04, 2.3400822734E+01, 4.9828312340E+00, 7.5648035117E+00, 2.6623090197E+00, 9.3607438728E-01],
	[3.4365000000E+04, 2.3406576360E+01, 4.9828407909E+00, 7.5683599248E+00, 2.6628265835E+00, 9.3610141522E-01],
	[3.4370000000E+04, 2.3412330564E+01, 4.9828503464E+00, 7.5719174912E+00, 2.6633440478E+00, 9.3612843062E-01],
	[3.4375000000E+04, 2.3418085345E+01, 4.9828599006E+00, 7.5754762111E+00, 2.6638614126E+00, 9.3615543348E-01],
	[3.4380000000E+04, 2.3423840703E+01, 4.9828694534E+00, 7.5790360848E+00, 2.6643786779E+00, 9.3618242379E-01],
	[3.4385000000E+04, 2.3429596638E+01, 4.9828790048E+00, 7.5825971123E+00, 2.6648958437E+00, 9.3620940157E-01],
	[3.4390000000E+04, 2.3435353150E+01, 4.9828885548E+00, 7.5861592940E+00, 2.6654129099E+00, 9.3623636683E-01],
	[3.4395000000E+04, 2.3441110240E+01, 4.9828981034E+00, 7.5897226301E+00, 2.6659298766E+00, 9.3626331956E-01],
	[3.4400000000E+04, 2.3446867907E+01, 4.9829076507E+00, 7.5932871207E+00, 2.6664467436E+00, 9.3629025977E-01],
	[3.4405000000E+04, 2.3452626150E+01, 4.9829171967E+00, 7.5968527660E+00, 2.6669635112E+00, 9.3631718748E-01],
	[3.4410000000E+04, 2.3458384971E+01, 4.9829267412E+00, 7.6004195663E+00, 2.6674801791E+00, 9.3634410268E-01],
	[3.4415000000E+04, 2.3464144369E+01, 4.9829362844E+00, 7.6039875218E+00, 2.6679967474E+00, 9.3637100538E-01],
	[3.4420000000E+04, 2.3469904344E+01, 4.9829458262E+00, 7.6075566326E+00, 2.6685132161E+00, 9.3639789558E-01],
	[3.4425000000E+04, 2.3475664896E+01, 4.9829553667E+00, 7.6111268990E+00, 2.6690295852E+00, 9.3642477330E-01],
	[3.4430000000E+04, 2.3481426025E+01, 4.9829649057E+00, 7.6146983212E+00, 2.6695458546E+00, 9.3645163854E-01],
	[3.4435000000E+04, 2.3487187731E+01, 4.9829744434E+00, 7.6182708994E+00, 2.6700620244E+00, 9.3647849130E-01],
	[3.4440000000E+04, 2.3492950013E+01, 4.9829839798E+00, 7.6218446337E+00, 2.6705780946E+00, 9.3650533159E-01],
	[3.4445000000E+04, 2.3498712873E+01, 4.9829935148E+00, 7.6254195245E+00, 2.6710940651E+00, 9.3653215942E-01],
	[3.4450000000E+04, 2.3504476309E+01, 4.9830030484E+00, 7.6289955719E+00, 2.6716099359E+00, 9.3655897478E-01],
	[3.4455000000E+04, 2.3510240323E+01, 4.9830125806E+00, 7.6325727761E+00, 2.6721257070E+00, 9.3658577769E-01],
	[3.4460000000E+04, 2.3516004913E+01, 4.9830221115E+00, 7.6361511373E+00, 2.6726413784E+00, 9.3661256816E-01],
	[3.4465000000E+04, 2.3521770080E+01, 4.9830316410E+00, 7.6397306557E+00, 2.6731569502E+00, 9.3663934618E-01],
	[3.4470000000E+04, 2.3527535823E+01, 4.9830411692E+00, 7.6433113315E+00, 2.6736724222E+00, 9.3666611177E-01],
	[3.4475000000E+04, 2.3533302144E+01, 4.9830506960E+00, 7.6468931650E+00, 2.6741877944E+00, 9.3669286492E-01],
	[3.4480000000E+04, 2.3539069041E+01, 4.9830602214E+00, 7.6504761563E+00, 2.6747030670E+00, 9.3671960565E-01],
	[3.4485000000E+04, 2.3544836515E+01, 4.9830697455E+00, 7.6540603057E+00, 2.6752182398E+00, 9.3674633396E-01],
	[3.4490000000E+04, 2.3550604565E+01, 4.9830792682E+00, 7.6576456133E+00, 2.6757333128E+00, 9.3677304986E-01],
	[3.4495000000E+04, 2.3556373192E+01, 4.9830887895E+00, 7.6612320794E+00, 2.6762482860E+00, 9.3679975335E-01],
	[3.4500000000E+04, 2.3562142396E+01, 4.9830983095E+00, 7.6648197041E+00, 2.6767631595E+00, 9.3682644444E-01],
	[3.4505000000E+04, 2.3567912176E+01, 4.9831078281E+00, 7.6684084877E+00, 2.6772779332E+00, 9.3685312313E-01],
	[3.4510000000E+04, 2.3573682533E+01, 4.9831173454E+00, 7.6719984304E+00, 2.6777926071E+00, 9.3687978943E-01],
	[3.4515000000E+04, 2.3579453466E+01, 4.9831268613E+00, 7.6755895323E+00, 2.6783071812E+00, 9.3690644335E-01],
	[3.4520000000E+04, 2.3585224976E+01, 4.9831363758E+00, 7.6791817938E+00, 2.6788216554E+00, 9.3693308488E-01],
	[3.4525000000E+04, 2.3590997062E+01, 4.9831458890E+00, 7.6827752149E+00, 2.6793360299E+00, 9.3695971404E-01],
	[3.4530000000E+04, 2.3596769725E+01, 4.9831554008E+00, 7.6863697959E+00, 2.6798503044E+00, 9.3698633084E-01],
	[3.4535000000E+04, 2.3602557783E+01, 4.9831671367E+00, 7.6899655371E+00, 2.6803653141E+00, 9.3701293527E-01],
	[3.4540000000E+04, 2.3608348991E+01, 4.9831792565E+00, 7.6935624385E+00, 2.6808803691E+00, 9.3703952735E-01],
	[3.4545000000E+04, 2.3614140781E+01, 4.9831913745E+00, 7.6971605005E+00, 2.6813953247E+00, 9.3706610707E-01],
	[3.4550000000E+04, 2.3619933153E+01, 4.9832034909E+00, 7.7007597232E+00, 2.6819101810E+00, 9.3709267445E-01],
	[3.4555000000E+04, 2.3625726108E+01, 4.9832156055E+00, 7.7043601068E+00, 2.6824249378E+00, 9.3711922949E-01],
	[3.4560000000E+04, 2.3631519645E+01, 4.9832277184E+00, 7.7079616515E+00, 2.6829395952E+00, 9.3714577220E-01],
	[3.4565000000E+04, 2.3637313765E+01, 4.9832398296E+00, 7.7115643576E+00, 2.6834541532E+00, 9.3717230258E-01],
	[3.4570000000E+04, 2.3643108467E+01, 4.9832519391E+00, 7.7151682253E+00, 2.6839686118E+00, 9.3719882063E-01],
	[3.4575000000E+04, 2.3648903750E+01, 4.9832640468E+00, 7.7187732547E+00, 2.6844829710E+00, 9.3722532637E-01],
	[3.4580000000E+04, 2.3654699616E+01, 4.9832761528E+00, 7.7223794460E+00, 2.6849972307E+00, 9.3725181980E-01],
	[3.4585000000E+04, 2.3660496065E+01, 4.9832882571E+00, 7.7259867995E+00, 2.6855113910E+00, 9.3727830092E-01],
	[3.4590000000E+04, 2.3666293095E+01, 4.9833003597E+00, 7.7295953154E+00, 2.6860254518E+00, 9.3730476975E-01],
	[3.4595000000E+04, 2.3672090708E+01, 4.9833124605E+00, 7.7332049938E+00, 2.6865394131E+00, 9.3733122628E-01],
	[3.4600000000E+04, 2.3677888902E+01, 4.9833245597E+00, 7.7368158351E+00, 2.6870532749E+00, 9.3735767052E-01],
	[3.4605000000E+04, 2.3683687679E+01, 4.9833366571E+00, 7.7404278393E+00, 2.6875670373E+00, 9.3738410248E-01],
	[3.4610000000E+04, 2.3689487038E+01, 4.9833487528E+00, 7.7440410067E+00, 2.6880807001E+00, 9.3741052216E-01],
	[3.4615000000E+04, 2.3695286978E+01, 4.9833608467E+00, 7.7476553375E+00, 2.6885942634E+00, 9.3743692957E-01],
	[3.4620000000E+04, 2.3701087501E+01, 4.9833729390E+00, 7.7512708320E+00, 2.6891077273E+00, 9.3746332472E-01],
	[3.4625000000E+04, 2.3706888605E+01, 4.9833850295E+00, 7.7548874902E+00, 2.6896210915E+00, 9.3748970760E-01],
	[3.4630000000E+04, 2.3712690292E+01, 4.9833971184E+00, 7.7585053125E+00, 2.6901343563E+00, 9.3751607824E-01],
	[3.4635000000E+04, 2.3718492561E+01, 4.9834092055E+00, 7.7621242989E+00, 2.6906475215E+00, 9.3754243662E-01],
	[3.4640000000E+04, 2.3724295411E+01, 4.9834212909E+00, 7.7657444499E+00, 2.6911605871E+00, 9.3756878276E-01],
	[3.4645000000E+04, 2.3730098843E+01, 4.9834333746E+00, 7.7693657654E+00, 2.6916735531E+00, 9.3759511667E-01],
	[3.4650000000E+04, 2.3735902857E+01, 4.9834454565E+00, 7.7729882458E+00, 2.6921864196E+00, 9.3762143834E-01],
	[3.4655000000E+04, 2.3741707453E+01, 4.9834575368E+00, 7.7766118912E+00, 2.6926991865E+00, 9.3764774779E-01],
	[3.4660000000E+04, 2.3747512631E+01, 4.9834696153E+00, 7.7802367019E+00, 2.6932118538E+00, 9.3767404502E-01],
	[3.4665000000E+04, 2.3753318390E+01, 4.9834816921E+00, 7.7838626781E+00, 2.6937244215E+00, 9.3770033003E-01],
	[3.4670000000E+04, 2.3759124731E+01, 4.9834937672E+00, 7.7874898199E+00, 2.6942368895E+00, 9.3772660284E-01],
	[3.4675000000E+04, 2.3764931654E+01, 4.9835058407E+00, 7.7911181276E+00, 2.6947492580E+00, 9.3775286344E-01],
	[3.4680000000E+04, 2.3770739158E+01, 4.9835179123E+00, 7.7947476014E+00, 2.6952615268E+00, 9.3777911184E-01],
	[3.4685000000E+04, 2.3776547245E+01, 4.9835299823E+00, 7.7983782414E+00, 2.6957736960E+00, 9.3780534806E-01],
	[3.4690000000E+04, 2.3782355912E+01, 4.9835420506E+00, 7.8020100480E+00, 2.6962857655E+00, 9.3783157209E-01],
	[3.4695000000E+04, 2.3788165162E+01, 4.9835541171E+00, 7.8056430212E+00, 2.6967977353E+00, 9.3785778394E-01],
	[3.4700000000E+04, 2.3793974993E+01, 4.9835661820E+00, 7.8092771614E+00, 2.6973096055E+00, 9.3788398361E-01],
	[3.4705000000E+04, 2.3799785405E+01, 4.9835782451E+00, 7.8129124686E+00, 2.6978213760E+00, 9.3791017112E-01],
	[3.4710000000E+04, 2.3805596399E+01, 4.9835903066E+00, 7.8165489432E+00, 2.6983330468E+00, 9.3793634646E-01],
	[3.4715000000E+04, 2.3811407975E+01, 4.9836023663E+00, 7.8201865853E+00, 2.6988446179E+00, 9.3796250964E-01],
	[3.4720000000E+04, 2.3817220132E+01, 4.9836144243E+00, 7.8238253951E+00, 2.6993560893E+00, 9.3798866068E-01],
	[3.4725000000E+04, 2.3823032870E+01, 4.9836264806E+00, 7.8274653729E+00, 2.6998674609E+00, 9.3801479956E-01],
	[3.4730000000E+04, 2.3828846190E+01, 4.9836385352E+00, 7.8311065188E+00, 2.7003787329E+00, 9.3804092631E-01],
	[3.4735000000E+04, 2.3834660091E+01, 4.9836505881E+00, 7.8347488331E+00, 2.7008899051E+00, 9.3806704093E-01],
	[3.4740000000E+04, 2.3840474574E+01, 4.9836626393E+00, 7.8383923159E+00, 2.7014009776E+00, 9.3809314341E-01],
	[3.4745000000E+04, 2.3846289638E+01, 4.9836746888E+00, 7.8420369674E+00, 2.7019119503E+00, 9.3811923377E-01],
	[3.4750000000E+04, 2.3852105283E+01, 4.9836867365E+00, 7.8456827880E+00, 2.7024228232E+00, 9.3814531201E-01],
	[3.4755000000E+04, 2.3857921510E+01, 4.9836987826E+00, 7.8493297777E+00, 2.7029335964E+00, 9.3817137814E-01],
	[3.4760000000E+04, 2.3863738317E+01, 4.9837108270E+00, 7.8529779368E+00, 2.7034442698E+00, 9.3819743217E-01],
	[3.4765000000E+04, 2.3869555706E+01, 4.9837228697E+00, 7.8566272654E+00, 2.7039548434E+00, 9.3822347409E-01],
	[3.4770000000E+04, 2.3875373677E+01, 4.9837349106E+00, 7.8602777639E+00, 2.7044653173E+00, 9.3824950392E-01],
	[3.4775000000E+04, 2.3881192228E+01, 4.9837469499E+00, 7.8639294323E+00, 2.7049756913E+00, 9.3827552167E-01],
	[3.4780000000E+04, 2.3887011361E+01, 4.9837589874E+00, 7.8675822710E+00, 2.7054859655E+00, 9.3830152732E-01],
	[3.4785000000E+04, 2.3892831075E+01, 4.9837710233E+00, 7.8712362801E+00, 2.7059961398E+00, 9.3832752090E-01],
	[3.4790000000E+04, 2.3898651370E+01, 4.9837830575E+00, 7.8748914597E+00, 2.7065062144E+00, 9.3835350241E-01],
	[3.4795000000E+04, 2.3904472246E+01, 4.9837950899E+00, 7.8785478102E+00, 2.7070161891E+00, 9.3837947185E-01],
	[3.4800000000E+04, 2.3910293703E+01, 4.9838071207E+00, 7.8822053318E+00, 2.7075260640E+00, 9.3840542923E-01],
	[3.4805000000E+04, 2.3916115741E+01, 4.9838191497E+00, 7.8858640245E+00, 2.7080358390E+00, 9.3843137456E-01],
	[3.4810000000E+04, 2.3921938360E+01, 4.9838311771E+00, 7.8895238888E+00, 2.7085455141E+00, 9.3845730783E-01],
	[3.4815000000E+04, 2.3927761560E+01, 4.9838432028E+00, 7.8931849246E+00, 2.7090550894E+00, 9.3848322907E-01],
	[3.4820000000E+04, 2.3933585341E+01, 4.9838552267E+00, 7.8968471323E+00, 2.7095645647E+00, 9.3850913826E-01],
	[3.4825000000E+04, 2.3939409703E+01, 4.9838672490E+00, 7.9005105121E+00, 2.7100739402E+00, 9.3853503542E-01],
	[3.4830000000E+04, 2.3945234646E+01, 4.9838792695E+00, 7.9041750641E+00, 2.7105832158E+00, 9.3856092056E-01],
	[3.4835000000E+04, 2.3951060170E+01, 4.9838912884E+00, 7.9078407886E+00, 2.7110923915E+00, 9.3858679367E-01],
	[3.4840000000E+04, 2.3956886274E+01, 4.9839033056E+00, 7.9115076858E+00, 2.7116014673E+00, 9.3861265477E-01],
	[3.4845000000E+04, 2.3962712960E+01, 4.9839153211E+00, 7.9151757559E+00, 2.7121104431E+00, 9.3863850386E-01],
	[3.4850000000E+04, 2.3968540226E+01, 4.9839273349E+00, 7.9188449991E+00, 2.7126193190E+00, 9.3866434094E-01],
	[3.4855000000E+04, 2.3974368073E+01, 4.9839393470E+00, 7.9225154155E+00, 2.7131280950E+00, 9.3869016603E-01],
	[3.4860000000E+04, 2.3980196501E+01, 4.9839513574E+00, 7.9261870055E+00, 2.7136367710E+00, 9.3871597912E-01],
	[3.4865000000E+04, 2.3986025510E+01, 4.9839633661E+00, 7.9298597692E+00, 2.7141453471E+00, 9.3874178023E-01],
	[3.4870000000E+04, 2.3991855099E+01, 4.9839753731E+00, 7.9335337068E+00, 2.7146538232E+00, 9.3876756935E-01],
	[3.4875000000E+04, 2.3997685269E+01, 4.9839873784E+00, 7.9372088185E+00, 2.7151621993E+00, 9.3879334650E-01],
	[3.4880000000E+04, 2.4003516019E+01, 4.9839993820E+00, 7.9408851045E+00, 2.7156704755E+00, 9.3881911168E-01],
	[3.4885000000E+04, 2.4009347351E+01, 4.9840113839E+00, 7.9445625651E+00, 2.7161786516E+00, 9.3884486489E-01],
	[3.4890000000E+04, 2.4015179262E+01, 4.9840233842E+00, 7.9482412004E+00, 2.7166867278E+00, 9.3887060615E-01],
	[3.4895000000E+04, 2.4021011755E+01, 4.9840353827E+00, 7.9519210107E+00, 2.7171947040E+00, 9.3889633545E-01],
	[3.4900000000E+04, 2.4026844828E+01, 4.9840473796E+00, 7.9556019961E+00, 2.7177025801E+00, 9.3892205281E-01],
	[3.4905000000E+04, 2.4032678481E+01, 4.9840593748E+00, 7.9592841569E+00, 2.7182103563E+00, 9.3894775822E-01],
	[3.4910000000E+04, 2.4038512715E+01, 4.9840713682E+00, 7.9629674933E+00, 2.7187180324E+00, 9.3897345170E-01],
	[3.4915000000E+04, 2.4044347530E+01, 4.9840833600E+00, 7.9666520054E+00, 2.7192256084E+00, 9.3899913324E-01],
	[3.4920000000E+04, 2.4050182925E+01, 4.9840953501E+00, 7.9703376935E+00, 2.7197330844E+00, 9.3902480287E-01],
	[3.4925000000E+04, 2.4056018900E+01, 4.9841073386E+00, 7.9740245578E+00, 2.7202404604E+00, 9.3905046057E-01],
	[3.4930000000E+04, 2.4061855456E+01, 4.9841193253E+00, 7.9777125985E+00, 2.7207477363E+00, 9.3907610636E-01],
	[3.4935000000E+04, 2.4067692592E+01, 4.9841313103E+00, 7.9814018158E+00, 2.7212549122E+00, 9.3910174024E-01],
	[3.4940000000E+04, 2.4073530309E+01, 4.9841432937E+00, 7.9850922100E+00, 2.7217619880E+00, 9.3912736222E-01],
	[3.4945000000E+04, 2.4079368605E+01, 4.9841552754E+00, 7.9887837811E+00, 2.7222689636E+00, 9.3915297230E-01],
	[3.4950000000E+04, 2.4085207483E+01, 4.9841672554E+00, 7.9924765294E+00, 2.7227758393E+00, 9.3917857049E-01],
	[3.4955000000E+04, 2.4091046940E+01, 4.9841792337E+00, 7.9961704552E+00, 2.7232826148E+00, 9.3920415680E-01],
	[3.4960000000E+04, 2.4096886978E+01, 4.9841912103E+00, 7.9998655586E+00, 2.7237892902E+00, 9.3922973123E-01],
	[3.4965000000E+04, 2.4102727596E+01, 4.9842031852E+00, 8.0035618398E+00, 2.7242958655E+00, 9.3925529378E-01],
	[3.4970000000E+04, 2.4108568794E+01, 4.9842151584E+00, 8.0072592991E+00, 2.7248023406E+00, 9.3928084446E-01],
	[3.4975000000E+04, 2.4114410572E+01, 4.9842271300E+00, 8.0109579366E+00, 2.7253087157E+00, 9.3930638328E-01],
	[3.4980000000E+04, 2.4120252930E+01, 4.9842390999E+00, 8.0146577526E+00, 2.7258149906E+00, 9.3933191025E-01],
	[3.4985000000E+04, 2.4126095869E+01, 4.9842510681E+00, 8.0183587473E+00, 2.7263211653E+00, 9.3935742536E-01],
	[3.4990000000E+04, 2.4131939387E+01, 4.9842630346E+00, 8.0220609208E+00, 2.7268272400E+00, 9.3938292863E-01],
	[3.4995000000E+04, 2.4137783486E+01, 4.9842749995E+00, 8.0257642735E+00, 2.7273332144E+00, 9.3940842005E-01],
	[3.5000000000E+04, 2.4143628165E+01, 4.9842869626E+00, 8.0294688054E+00, 2.7278390887E+00, 9.3943389965E-01],
	[3.5005000000E+04, 2.4149473424E+01, 4.9842989241E+00, 8.0331815492E+00, 2.7283456741E+00, 9.3945936741E-01],
	[3.5010000000E+04, 2.4155319262E+01, 4.9843108839E+00, 8.0368954784E+00, 2.7288521590E+00, 9.3948482335E-01],
	[3.5015000000E+04, 2.4161165681E+01, 4.9843228420E+00, 8.0406105932E+00, 2.7293585435E+00, 9.3951026747E-01],
	[3.5020000000E+04, 2.4167012680E+01, 4.9843347984E+00, 8.0443268937E+00, 2.7298648275E+00, 9.3953569979E-01],
	[3.5025000000E+04, 2.4172860258E+01, 4.9843467532E+00, 8.0480443802E+00, 2.7303710111E+00, 9.3956112029E-01],
	[3.5030000000E+04, 2.4178708417E+01, 4.9843587063E+00, 8.0517630528E+00, 2.7308770943E+00, 9.3958652899E-01],
	[3.5035000000E+04, 2.4184557155E+01, 4.9843706577E+00, 8.0554829118E+00, 2.7313830769E+00, 9.3961192590E-01],
	[3.5040000000E+04, 2.4190406473E+01, 4.9843826074E+00, 8.0592039574E+00, 2.7318889592E+00, 9.3963731102E-01],
	[3.5045000000E+04, 2.4196256371E+01, 4.9843945555E+00, 8.0629261898E+00, 2.7323947409E+00, 9.3966268436E-01],
	[3.5050000000E+04, 2.4202106849E+01, 4.9844065019E+00, 8.0666496092E+00, 2.7329004222E+00, 9.3968804592E-01],
	[3.5055000000E+04, 2.4207957907E+01, 4.9844184466E+00, 8.0703742158E+00, 2.7334060029E+00, 9.3971339570E-01],
	[3.5060000000E+04, 2.4213809544E+01, 4.9844303896E+00, 8.0741000099E+00, 2.7339114832E+00, 9.3973873372E-01],
	[3.5065000000E+04, 2.4219661761E+01, 4.9844423309E+00, 8.0778269916E+00, 2.7344168630E+00, 9.3976405998E-01],
	[3.5070000000E+04, 2.4225514558E+01, 4.9844542706E+00, 8.0815551611E+00, 2.7349221422E+00, 9.3978937448E-01],
	[3.5075000000E+04, 2.4231367934E+01, 4.9844662086E+00, 8.0852845186E+00, 2.7354273210E+00, 9.3981467723E-01],
	[3.5080000000E+04, 2.4237221891E+01, 4.9844781449E+00, 8.0890150645E+00, 2.7359323992E+00, 9.3983996824E-01],
	[3.5085000000E+04, 2.4243076426E+01, 4.9844900796E+00, 8.0927467987E+00, 2.7364373769E+00, 9.3986524750E-01],
	[3.5090000000E+04, 2.4248943113E+01, 4.9845037336E+00, 8.0964797217E+00, 2.7369429203E+00, 9.3989051504E-01],
	[3.5095000000E+04, 2.4254816012E+01, 4.9845182229E+00, 8.1002138336E+00, 2.7374486878E+00, 9.3991577085E-01],
	[3.5100000000E+04, 2.4260689498E+01, 4.9845327101E+00, 8.1039491345E+00, 2.7379543552E+00, 9.3994101493E-01],
	[3.5105000000E+04, 2.4266563568E+01, 4.9845471953E+00, 8.1076856248E+00, 2.7384599224E+00, 9.3996624730E-01],
	[3.5110000000E+04, 2.4272438224E+01, 4.9845616785E+00, 8.1114233045E+00, 2.7389653897E+00, 9.3999146796E-01],
	[3.5115000000E+04, 2.4278313466E+01, 4.9845761597E+00, 8.1151621740E+00, 2.7394707568E+00, 9.4001667692E-01],
	[3.5120000000E+04, 2.4284189292E+01, 4.9845906389E+00, 8.1189022334E+00, 2.7399760238E+00, 9.4004187417E-01],
	[3.5125000000E+04, 2.4290065704E+01, 4.9846051160E+00, 8.1226434830E+00, 2.7404811907E+00, 9.4006705973E-01],
	[3.5130000000E+04, 2.4295942701E+01, 4.9846195912E+00, 8.1263859228E+00, 2.7409862575E+00, 9.4009223360E-01],
	[3.5135000000E+04, 2.4301820284E+01, 4.9846340643E+00, 8.1301295533E+00, 2.7414912242E+00, 9.4011739579E-01],
	[3.5140000000E+04, 2.4307698451E+01, 4.9846485354E+00, 8.1338743745E+00, 2.7419960907E+00, 9.4014254631E-01],
	[3.5145000000E+04, 2.4313577204E+01, 4.9846630044E+00, 8.1376203867E+00, 2.7425008572E+00, 9.4016768515E-01],
	[3.5150000000E+04, 2.4319456542E+01, 4.9846774715E+00, 8.1413675901E+00, 2.7430055234E+00, 9.4019281232E-01],
	[3.5155000000E+04, 2.4325336465E+01, 4.9846919365E+00, 8.1451159848E+00, 2.7435100896E+00, 9.4021792784E-01],
	[3.5160000000E+04, 2.4331216974E+01, 4.9847063995E+00, 8.1488655712E+00, 2.7440145556E+00, 9.4024303170E-01],
	[3.5165000000E+04, 2.4337098067E+01, 4.9847208606E+00, 8.1526163493E+00, 2.7445189214E+00, 9.4026812391E-01],
	[3.5170000000E+04, 2.4342979745E+01, 4.9847353195E+00, 8.1563683195E+00, 2.7450231871E+00, 9.4029320448E-01],
	[3.5175000000E+04, 2.4348862009E+01, 4.9847497765E+00, 8.1601214819E+00, 2.7455273526E+00, 9.4031827342E-01],
	[3.5180000000E+04, 2.4354744857E+01, 4.9847642315E+00, 8.1638758368E+00, 2.7460314179E+00, 9.4034333071E-01],
	[3.5185000000E+04, 2.4360628291E+01, 4.9847786845E+00, 8.1676313843E+00, 2.7465353830E+00, 9.4036837639E-01],
	[3.5190000000E+04, 2.4366512309E+01, 4.9847931354E+00, 8.1713881246E+00, 2.7470392479E+00, 9.4039341044E-01],
	[3.5195000000E+04, 2.4372396912E+01, 4.9848075843E+00, 8.1751460580E+00, 2.7475430127E+00, 9.4041843288E-01],
	[3.5200000000E+04, 2.4378282101E+01, 4.9848220313E+00, 8.1789051847E+00, 2.7480466772E+00, 9.4044344370E-01],
	[3.5205000000E+04, 2.4384167874E+01, 4.9848364762E+00, 8.1826655049E+00, 2.7485502416E+00, 9.4046844293E-01],
	[3.5210000000E+04, 2.4390054232E+01, 4.9848509191E+00, 8.1864270187E+00, 2.7490537057E+00, 9.4049343055E-01],
	[3.5215000000E+04, 2.4395941174E+01, 4.9848653600E+00, 8.1901897265E+00, 2.7495570696E+00, 9.4051840658E-01],
	[3.5220000000E+04, 2.4401828702E+01, 4.9848797989E+00, 8.1939536283E+00, 2.7500603332E+00, 9.4054337103E-01],
	[3.5225000000E+04, 2.4407716814E+01, 4.9848942357E+00, 8.1977187245E+00, 2.7505634967E+00, 9.4056832389E-01],
	[3.5230000000E+04, 2.4413605512E+01, 4.9849086706E+00, 8.2014850152E+00, 2.7510665598E+00, 9.4059326518E-01],
	[3.5235000000E+04, 2.4419494793E+01, 4.9849231035E+00, 8.2052525007E+00, 2.7515695228E+00, 9.4061819490E-01],
	[3.5240000000E+04, 2.4425384660E+01, 4.9849375343E+00, 8.2090211810E+00, 2.7520723855E+00, 9.4064311305E-01],
	[3.5245000000E+04, 2.4431275111E+01, 4.9849519632E+00, 8.2127910566E+00, 2.7525751479E+00, 9.4066801964E-01],
	[3.5250000000E+04, 2.4437166147E+01, 4.9849663900E+00, 8.2165621275E+00, 2.7530778101E+00, 9.4069291468E-01],
	[3.5255000000E+04, 2.4443057768E+01, 4.9849808149E+00, 8.2203343939E+00, 2.7535803719E+00, 9.4071779817E-01],
	[3.5260000000E+04, 2.4448949973E+01, 4.9849952377E+00, 8.2241078562E+00, 2.7540828336E+00, 9.4074267012E-01],
	[3.5265000000E+04, 2.4454842763E+01, 4.9850096586E+00, 8.2278825144E+00, 2.7545851949E+00, 9.4076753053E-01],
	[3.5270000000E+04, 2.4460736137E+01, 4.9850240774E+00, 8.2316583688E+00, 2.7550874559E+00, 9.4079237941E-01],
	[3.5275000000E+04, 2.4466630096E+01, 4.9850384942E+00, 8.2354354196E+00, 2.7555896167E+00, 9.4081721676E-01],
	[3.5280000000E+04, 2.4472524639E+01, 4.9850529090E+00, 8.2392136671E+00, 2.7560916771E+00, 9.4084204260E-01],
	[3.5285000000E+04, 2.4478419767E+01, 4.9850673219E+00, 8.2429931114E+00, 2.7565936372E+00, 9.4086685691E-01],
	[3.5290000000E+04, 2.4484315480E+01, 4.9850817327E+00, 8.2467737527E+00, 2.7570954971E+00, 9.4089165972E-01],
	[3.5295000000E+04, 2.4490211776E+01, 4.9850961415E+00, 8.2505555912E+00, 2.7575972566E+00, 9.4091645103E-01],
	[3.5300000000E+04, 2.4496108658E+01, 4.9851105484E+00, 8.2543386272E+00, 2.7580989157E+00, 9.4094123084E-01],
	[3.5305000000E+04, 2.4502006123E+01, 4.9851249532E+00, 8.2581228609E+00, 2.7586004746E+00, 9.4096599916E-01],
	[3.5310000000E+04, 2.4507904173E+01, 4.9851393560E+00, 8.2619082924E+00, 2.7591019331E+00, 9.4099075599E-01],
	[3.5315000000E+04, 2.4513802807E+01, 4.9851537569E+00, 8.2656949221E+00, 2.7596032913E+00, 9.4101550134E-01],
	[3.5320000000E+04, 2.4519702026E+01, 4.9851681557E+00, 8.2694827500E+00, 2.7601045491E+00, 9.4104023521E-01],
	[3.5325000000E+04, 2.4525601829E+01, 4.9851825525E+00, 8.2732717764E+00, 2.7606057066E+00, 9.4106495761E-01],
	[3.5330000000E+04, 2.4531502216E+01, 4.9851969474E+00, 8.2770620015E+00, 2.7611067637E+00, 9.4108966855E-01],
	[3.5335000000E+04, 2.4537403187E+01, 4.9852113402E+00, 8.2808534255E+00, 2.7616077204E+00, 9.4111436803E-01],
	[3.5340000000E+04, 2.4543304743E+01, 4.9852257311E+00, 8.2846460487E+00, 2.7621085768E+00, 9.4113905606E-01],
	[3.5345000000E+04, 2.4549206883E+01, 4.9852401199E+00, 8.2884398711E+00, 2.7626093328E+00, 9.4116373264E-01],
	[3.5350000000E+04, 2.4555109607E+01, 4.9852545068E+00, 8.2922348932E+00, 2.7631099885E+00, 9.4118839777E-01],
	[3.5355000000E+04, 2.4561012915E+01, 4.9852688917E+00, 8.2960311149E+00, 2.7636105437E+00, 9.4121305147E-01],
	[3.5360000000E+04, 2.4566916807E+01, 4.9852832746E+00, 8.2998285367E+00, 2.7641109985E+00, 9.4123769374E-01],
	[3.5365000000E+04, 2.4572821283E+01, 4.9852976554E+00, 8.3036271586E+00, 2.7646113530E+00, 9.4126232459E-01],
	[3.5370000000E+04, 2.4578726343E+01, 4.9853120343E+00, 8.3074269809E+00, 2.7651116070E+00, 9.4128694401E-01],
	[3.5375000000E+04, 2.4584631988E+01, 4.9853264112E+00, 8.3112280038E+00, 2.7656117607E+00, 9.4131155202E-01],
	[3.5380000000E+04, 2.4590538216E+01, 4.9853407862E+00, 8.3150302275E+00, 2.7661118139E+00, 9.4133614862E-01],
	[3.5385000000E+04, 2.4596445029E+01, 4.9853551591E+00, 8.3188336522E+00, 2.7666117667E+00, 9.4136073382E-01],
	[3.5390000000E+04, 2.4602352425E+01, 4.9853695300E+00, 8.3226382781E+00, 2.7671116191E+00, 9.4138530762E-01],
	[3.5395000000E+04, 2.4608260405E+01, 4.9853838990E+00, 8.3264441054E+00, 2.7676113711E+00, 9.4140987003E-01],
	[3.5400000000E+04, 2.4614168969E+01, 4.9853982659E+00, 8.3302511344E+00, 2.7681110226E+00, 9.4143442105E-01],
	[3.5405000000E+04, 2.4620078118E+01, 4.9854126309E+00, 8.3340593652E+00, 2.7686105737E+00, 9.4145896069E-01],
	[3.5410000000E+04, 2.4625987850E+01, 4.9854269939E+00, 8.3378687981E+00, 2.7691100243E+00, 9.4148348896E-01],
	[3.5415000000E+04, 2.4631898165E+01, 4.9854413549E+00, 8.3416794332E+00, 2.7696093745E+00, 9.4150800585E-01],
	[3.5420000000E+04, 2.4637809065E+01, 4.9854557139E+00, 8.3454912708E+00, 2.7701086243E+00, 9.4153251138E-01],
	[3.5425000000E+04, 2.4643720548E+01, 4.9854700709E+00, 8.3493043111E+00, 2.7706077735E+00, 9.4155700556E-01],
	[3.5430000000E+04, 2.4649632616E+01, 4.9854844259E+00, 8.3531185543E+00, 2.7711068224E+00, 9.4158148837E-01],
	[3.5435000000E+04, 2.4655545266E+01, 4.9854987790E+00, 8.3569340005E+00, 2.7716057707E+00, 9.4160595985E-01],
	[3.5440000000E+04, 2.4661458501E+01, 4.9855131301E+00, 8.3607506501E+00, 2.7721046186E+00, 9.4163041998E-01],
	[3.5445000000E+04, 2.4667372319E+01, 4.9855274792E+00, 8.3645685032E+00, 2.7726033660E+00, 9.4165486877E-01],
	[3.5450000000E+04, 2.4673286721E+01, 4.9855418263E+00, 8.3683875601E+00, 2.7731020129E+00, 9.4167930623E-01],
	[3.5455000000E+04, 2.4679201707E+01, 4.9855561714E+00, 8.3722078209E+00, 2.7736005593E+00, 9.4170373237E-01],
	[3.5460000000E+04, 2.4685117276E+01, 4.9855705145E+00, 8.3760292858E+00, 2.7740990052E+00, 9.4172814718E-01],
	[3.5465000000E+04, 2.4691033429E+01, 4.9855848557E+00, 8.3798519551E+00, 2.7745973507E+00, 9.4175255069E-01],
	[3.5470000000E+04, 2.4696950166E+01, 4.9855991949E+00, 8.3836758289E+00, 2.7750955956E+00, 9.4177694288E-01],
	[3.5475000000E+04, 2.4702867486E+01, 4.9856135321E+00, 8.3875009075E+00, 2.7755937400E+00, 9.4180132377E-01],
	[3.5480000000E+04, 2.4708785389E+01, 4.9856278673E+00, 8.3913271911E+00, 2.7760917839E+00, 9.4182569336E-01],
	[3.5485000000E+04, 2.4714703876E+01, 4.9856422005E+00, 8.3951546799E+00, 2.7765897273E+00, 9.4185005166E-01],
	[3.5490000000E+04, 2.4720622947E+01, 4.9856565318E+00, 8.3989833741E+00, 2.7770875702E+00, 9.4187439867E-01],
	[3.5495000000E+04, 2.4726542600E+01, 4.9856708611E+00, 8.4028132739E+00, 2.7775853125E+00, 9.4189873440E-01],
	[3.5500000000E+04, 2.4732462838E+01, 4.9856851884E+00, 8.4066443796E+00, 2.7780829543E+00, 9.4192305886E-01],
	[3.5505000000E+04, 2.4738383658E+01, 4.9856995137E+00, 8.4104766912E+00, 2.7785804956E+00, 9.4194737205E-01],
	[3.5510000000E+04, 2.4744305063E+01, 4.9857138371E+00, 8.4143102091E+00, 2.7790779363E+00, 9.4197167397E-01],
	[3.5515000000E+04, 2.4750227050E+01, 4.9857281585E+00, 8.4181449335E+00, 2.7795752765E+00, 9.4199596463E-01],
	[3.5520000000E+04, 2.4756149621E+01, 4.9857424779E+00, 8.4219808645E+00, 2.7800725162E+00, 9.4202024404E-01],
	[3.5525000000E+04, 2.4762072775E+01, 4.9857567953E+00, 8.4258180024E+00, 2.7805696552E+00, 9.4204451220E-01],
	[3.5530000000E+04, 2.4767996512E+01, 4.9857711108E+00, 8.4296563473E+00, 2.7810666938E+00, 9.4206876912E-01],
	[3.5535000000E+04, 2.4773920833E+01, 4.9857854242E+00, 8.4334958996E+00, 2.7815636317E+00, 9.4209301480E-01],
	[3.5540000000E+04, 2.4779845736E+01, 4.9857997357E+00, 8.4373366593E+00, 2.7820604691E+00, 9.4211724925E-01],
	[3.5545000000E+04, 2.4785771223E+01, 4.9858140453E+00, 8.4411786268E+00, 2.7825572060E+00, 9.4214147247E-01],
	[3.5550000000E+04, 2.4791697294E+01, 4.9858283529E+00, 8.4450218022E+00, 2.7830538422E+00, 9.4216568448E-01],
	[3.5555000000E+04, 2.4797623947E+01, 4.9858426585E+00, 8.4488661856E+00, 2.7835503779E+00, 9.4218988527E-01],
	[3.5560000000E+04, 2.4803551183E+01, 4.9858569621E+00, 8.4527117775E+00, 2.7840468130E+00, 9.4221407484E-01],
	[3.5565000000E+04, 2.4809479003E+01, 4.9858712637E+00, 8.4565585778E+00, 2.7845431475E+00, 9.4223825322E-01],
	[3.5570000000E+04, 2.4815407406E+01, 4.9858855634E+00, 8.4604065870E+00, 2.7850393814E+00, 9.4226242040E-01],
	[3.5575000000E+04, 2.4821336391E+01, 4.9858998611E+00, 8.4642558051E+00, 2.7855355147E+00, 9.4228657638E-01],
	[3.5580000000E+04, 2.4827265960E+01, 4.9859141569E+00, 8.4681062323E+00, 2.7860315474E+00, 9.4231072118E-01],
	[3.5585000000E+04, 2.4833196112E+01, 4.9859284507E+00, 8.4719578690E+00, 2.7865274795E+00, 9.4233485479E-01],
	[3.5590000000E+04, 2.4839126846E+01, 4.9859427425E+00, 8.4758107152E+00, 2.7870233110E+00, 9.4235897723E-01],
	[3.5595000000E+04, 2.4845058164E+01, 4.9859570323E+00, 8.4796647712E+00, 2.7875190418E+00, 9.4238308850E-01],
	[3.5600000000E+04, 2.4850990065E+01, 4.9859713202E+00, 8.4835200373E+00, 2.7880146721E+00, 9.4240718860E-01],
	[3.5605000000E+04, 2.4856922548E+01, 4.9859856061E+00, 8.4873765135E+00, 2.7885102017E+00, 9.4243127754E-01],
	[3.5610000000E+04, 2.4862855614E+01, 4.9859998901E+00, 8.4912342002E+00, 2.7890056307E+00, 9.4245535533E-01],
	[3.5615000000E+04, 2.4868789264E+01, 4.9860141721E+00, 8.4950930976E+00, 2.7895009591E+00, 9.4247942197E-01],
	[3.5620000000E+04, 2.4874723496E+01, 4.9860284521E+00, 8.4989532058E+00, 2.7899961869E+00, 9.4250347747E-01],
	[3.5625000000E+04, 2.4880658310E+01, 4.9860427301E+00, 8.5028145250E+00, 2.7904913140E+00, 9.4252752182E-01],
	[3.5630000000E+04, 2.4886593708E+01, 4.9860570062E+00, 8.5066770555E+00, 2.7909863404E+00, 9.4255155505E-01],
	[3.5635000000E+04, 2.4892529688E+01, 4.9860712804E+00, 8.5105407975E+00, 2.7914812663E+00, 9.4257557715E-01],
	[3.5640000000E+04, 2.4898466251E+01, 4.9860855525E+00, 8.5144057512E+00, 2.7919760914E+00, 9.4259958816E-01],
	[3.5645000000E+04, 2.4904403397E+01, 4.9860998227E+00, 8.5182719167E+00, 2.7924708160E+00, 9.4262358806E-01],
	[3.5650000000E+04, 2.4910341126E+01, 4.9861140910E+00, 8.5221392944E+00, 2.7929654398E+00, 9.4264757687E-01],
	[3.5655000000E+04, 2.4916291420E+01, 4.9861301177E+00, 8.5260078844E+00, 2.7934606662E+00, 9.4267155460E-01],
	[3.5660000000E+04, 2.4922247356E+01, 4.9861468849E+00, 8.5298776869E+00, 2.7939560890E+00, 9.4269552125E-01],
	[3.5665000000E+04, 2.4928203881E+01, 4.9861636497E+00, 8.5337487022E+00, 2.7944514115E+00, 9.4271947681E-01],
	[3.5670000000E+04, 2.4934160995E+01, 4.9861804123E+00, 8.5376209304E+00, 2.7949466338E+00, 9.4274342131E-01],
	[3.5675000000E+04, 2.4940118696E+01, 4.9861971725E+00, 8.5414943717E+00, 2.7954417560E+00, 9.4276735474E-01],
	[3.5680000000E+04, 2.4946076986E+01, 4.9862139305E+00, 8.5453690264E+00, 2.7959367779E+00, 9.4279127711E-01],
	[3.5685000000E+04, 2.4952035864E+01, 4.9862306861E+00, 8.5492448947E+00, 2.7964316995E+00, 9.4281518842E-01],
	[3.5690000000E+04, 2.4957995330E+01, 4.9862474395E+00, 8.5531219768E+00, 2.7969265210E+00, 9.4283908867E-01],
	[3.5695000000E+04, 2.4963955385E+01, 4.9862641906E+00, 8.5570002728E+00, 2.7974212422E+00, 9.4286297788E-01],
	[3.5700000000E+04, 2.4969916027E+01, 4.9862809394E+00, 8.5608797831E+00, 2.7979158632E+00, 9.4288685605E-01],
	[3.5705000000E+04, 2.4975877258E+01, 4.9862976859E+00, 8.5647605078E+00, 2.7984103840E+00, 9.4291072318E-01],
	[3.5710000000E+04, 2.4981839077E+01, 4.9863144301E+00, 8.5686424471E+00, 2.7989048045E+00, 9.4293457928E-01],
	[3.5715000000E+04, 2.4987801484E+01, 4.9863311720E+00, 8.5725256012E+00, 2.7993991247E+00, 9.4295842435E-01],
	[3.5720000000E+04, 2.4993764480E+01, 4.9863479117E+00, 8.5764099704E+00, 2.7998933448E+00, 9.4298225840E-01],
	[3.5725000000E+04, 2.4999728063E+01, 4.9863646490E+00, 8.5802955548E+00, 2.8003874645E+00, 9.4300608143E-01],
	[3.5730000000E+04, 2.5005692234E+01, 4.9863813841E+00, 8.5841823547E+00, 2.8008814840E+00, 9.4302989345E-01],
	[3.5735000000E+04, 2.5011656993E+01, 4.9863981169E+00, 8.5880703702E+00, 2.8013754033E+00, 9.4305369446E-01],
	[3.5740000000E+04, 2.5017622341E+01, 4.9864148474E+00, 8.5919596017E+00, 2.8018692223E+00, 9.4307748446E-01],
	[3.5745000000E+04, 2.5023588276E+01, 4.9864315756E+00, 8.5958500492E+00, 2.8023629410E+00, 9.4310126347E-01],
	[3.5750000000E+04, 2.5029554799E+01, 4.9864483015E+00, 8.5997417130E+00, 2.8028565595E+00, 9.4312503149E-01],
	[3.5755000000E+04, 2.5035521910E+01, 4.9864650252E+00, 8.6036345933E+00, 2.8033500777E+00, 9.4314878852E-01],
	[3.5760000000E+04, 2.5041489609E+01, 4.9864817465E+00, 8.6075286904E+00, 2.8038434956E+00, 9.4317253456E-01],
	[3.5765000000E+04, 2.5047457896E+01, 4.9864984656E+00, 8.6114240043E+00, 2.8043368132E+00, 9.4319626963E-01],
	[3.5770000000E+04, 2.5053426771E+01, 4.9865151824E+00, 8.6153205354E+00, 2.8048300306E+00, 9.4321999372E-01],
	[3.5775000000E+04, 2.5059396233E+01, 4.9865318969E+00, 8.6192182839E+00, 2.8053231476E+00, 9.4324370685E-01],
	[3.5780000000E+04, 2.5065366283E+01, 4.9865486092E+00, 8.6231172499E+00, 2.8058161644E+00, 9.4326740901E-01],
	[3.5785000000E+04, 2.5071336922E+01, 4.9865653191E+00, 8.6270174337E+00, 2.8063090809E+00, 9.4329110022E-01],
	[3.5790000000E+04, 2.5077308147E+01, 4.9865820268E+00, 8.6309188354E+00, 2.8068018971E+00, 9.4331478047E-01],
	[3.5795000000E+04, 2.5083279961E+01, 4.9865987322E+00, 8.6348214554E+00, 2.8072946130E+00, 9.4333844977E-01],
	[3.5800000000E+04, 2.5089252362E+01, 4.9866154353E+00, 8.6387252937E+00, 2.8077872286E+00, 9.4336210813E-01],
	[3.5805000000E+04, 2.5095225351E+01, 4.9866321362E+00, 8.6426303507E+00, 2.8082797439E+00, 9.4338575555E-01],
	[3.5810000000E+04, 2.5101198928E+01, 4.9866488348E+00, 8.6465366264E+00, 2.8087721589E+00, 9.4340939204E-01],
	[3.5815000000E+04, 2.5107173092E+01, 4.9866655311E+00, 8.6504441212E+00, 2.8092644736E+00, 9.4343301759E-01],
	[3.5820000000E+04, 2.5113147843E+01, 4.9866822251E+00, 8.6543528352E+00, 2.8097566879E+00, 9.4345663223E-01],
	[3.5825000000E+04, 2.5119123183E+01, 4.9866989168E+00, 8.6582627687E+00, 2.8102488020E+00, 9.4348023594E-01],
	[3.5830000000E+04, 2.5125099110E+01, 4.9867156063E+00, 8.6621739218E+00, 2.8107408157E+00, 9.4350382875E-01],
	[3.5835000000E+04, 2.5131075624E+01, 4.9867322935E+00, 8.6660862948E+00, 2.8112327291E+00, 9.4352741064E-01],
	[3.5840000000E+04, 2.5137052726E+01, 4.9867489784E+00, 8.6699998879E+00, 2.8117245422E+00, 9.4355098163E-01],
	[3.5845000000E+04, 2.5143030415E+01, 4.9867656611E+00, 8.6739147012E+00, 2.8122162549E+00, 9.4357454172E-01],
	[3.5850000000E+04, 2.5149008692E+01, 4.9867823415E+00, 8.6778307350E+00, 2.8127078674E+00, 9.4359809091E-01],
	[3.5855000000E+04, 2.5154987557E+01, 4.9867990196E+00, 8.6817479896E+00, 2.8131993795E+00, 9.4362162922E-01],
	[3.5860000000E+04, 2.5160967008E+01, 4.9868156954E+00, 8.6856664651E+00, 2.8136907912E+00, 9.4364515664E-01],
	[3.5865000000E+04, 2.5166947047E+01, 4.9868323690E+00, 8.6895861616E+00, 2.8141821026E+00, 9.4366867318E-01],
	[3.5870000000E+04, 2.5172927674E+01, 4.9868490403E+00, 8.6935070795E+00, 2.8146733137E+00, 9.4369217885E-01],
	[3.5875000000E+04, 2.5178908888E+01, 4.9868657094E+00, 8.6974292190E+00, 2.8151644244E+00, 9.4371567365E-01],
	[3.5880000000E+04, 2.5184890689E+01, 4.9868823761E+00, 8.7013525802E+00, 2.8156554348E+00, 9.4373915759E-01],
	[3.5885000000E+04, 2.5190873077E+01, 4.9868990407E+00, 8.7052771634E+00, 2.8161463448E+00, 9.4376263066E-01],
	[3.5890000000E+04, 2.5196856053E+01, 4.9869157029E+00, 8.7092029687E+00, 2.8166371545E+00, 9.4378609288E-01],
	[3.5895000000E+04, 2.5202839615E+01, 4.9869323629E+00, 8.7131299965E+00, 2.8171278638E+00, 9.4380954425E-01],
	[3.5900000000E+04, 2.5208823766E+01, 4.9869490206E+00, 8.7170582468E+00, 2.8176184728E+00, 9.4383298478E-01],
	[3.5905000000E+04, 2.5214808503E+01, 4.9869656760E+00, 8.7209877199E+00, 2.8181089814E+00, 9.4385641446E-01],
	[3.5910000000E+04, 2.5220793827E+01, 4.9869823292E+00, 8.7249184161E+00, 2.8185993896E+00, 9.4387983332E-01],
	[3.5915000000E+04, 2.5226779739E+01, 4.9869989801E+00, 8.7288503354E+00, 2.8190896975E+00, 9.4390324134E-01],
	[3.5920000000E+04, 2.5232766237E+01, 4.9870156288E+00, 8.7327834782E+00, 2.8195799050E+00, 9.4392663853E-01],
	[3.5925000000E+04, 2.5238753323E+01, 4.9870322752E+00, 8.7367178447E+00, 2.8200700121E+00, 9.4395002491E-01],
	[3.5930000000E+04, 2.5244740996E+01, 4.9870489193E+00, 8.7406534350E+00, 2.8205600189E+00, 9.4397340047E-01],
	[3.5935000000E+04, 2.5250729256E+01, 4.9870655612E+00, 8.7445902493E+00, 2.8210499253E+00, 9.4399676522E-01],
	[3.5940000000E+04, 2.5256718103E+01, 4.9870822008E+00, 8.7485282880E+00, 2.8215397313E+00, 9.4402011917E-01],
	[3.5945000000E+04, 2.5262707537E+01, 4.9870988382E+00, 8.7524675511E+00, 2.8220294369E+00, 9.4404346232E-01],
	[3.5950000000E+04, 2.5268697558E+01, 4.9871154733E+00, 8.7564080389E+00, 2.8225190422E+00, 9.4406679467E-01],
	[3.5955000000E+04, 2.5274688165E+01, 4.9871321061E+00, 8.7603497516E+00, 2.8230085470E+00, 9.4409011623E-01],
	[3.5960000000E+04, 2.5280679360E+01, 4.9871487367E+00, 8.7642926894E+00, 2.8234979515E+00, 9.4411342700E-01],
	[3.5965000000E+04, 2.5286671142E+01, 4.9871653650E+00, 8.7682368525E+00, 2.8239872556E+00, 9.4413672700E-01],
	[3.5970000000E+04, 2.5292663510E+01, 4.9871819911E+00, 8.7721822412E+00, 2.8244764593E+00, 9.4416001621E-01],
	[3.5975000000E+04, 2.5298656466E+01, 4.9871986149E+00, 8.7761288556E+00, 2.8249655626E+00, 9.4418329466E-01],
	[3.5980000000E+04, 2.5304650008E+01, 4.9872152364E+00, 8.7800766960E+00, 2.8254545655E+00, 9.4420656234E-01],
	[3.5985000000E+04, 2.5310644137E+01, 4.9872318557E+00, 8.7840257625E+00, 2.8259434680E+00, 9.4422981926E-01],
	[3.5990000000E+04, 2.5316638852E+01, 4.9872484728E+00, 8.7879760554E+00, 2.8264322701E+00, 9.4425306543E-01],
	[3.5995000000E+04, 2.5322634155E+01, 4.9872650876E+00, 8.7919275749E+00, 2.8269209718E+00, 9.4427630084E-01],
	[3.6000000000E+04, 2.5328630044E+01, 4.9872817001E+00, 8.7958803212E+00, 2.8274095731E+00, 9.4429952551E-01],
	[3.6005000000E+04, 2.5334626520E+01, 4.9872983104E+00, 8.7998342945E+00, 2.8278980740E+00, 9.4432273944E-01],
	[3.6010000000E+04, 2.5340623583E+01, 4.9873149185E+00, 8.8037894950E+00, 2.8283864745E+00, 9.4434594263E-01],
	[3.6015000000E+04, 2.5346621232E+01, 4.9873315243E+00, 8.8077459229E+00, 2.8288747746E+00, 9.4436913509E-01],
	[3.6020000000E+04, 2.5352619468E+01, 4.9873481278E+00, 8.8117035784E+00, 2.8293629742E+00, 9.4439231682E-01],
	[3.6025000000E+04, 2.5358618290E+01, 4.9873647291E+00, 8.8156624618E+00, 2.8298510735E+00, 9.4441548784E-01],
	[3.6030000000E+04, 2.5364617700E+01, 4.9873813281E+00, 8.8196225733E+00, 2.8303390723E+00, 9.4443864813E-01],
	[3.6035000000E+04, 2.5370617695E+01, 4.9873979249E+00, 8.8235839130E+00, 2.8308269707E+00, 9.4446179771E-01],
	[3.6040000000E+04, 2.5376618277E+01, 4.9874145195E+00, 8.8275464812E+00, 2.8313147687E+00, 9.4448493659E-01],
	[3.6045000000E+04, 2.5382619446E+01, 4.9874311118E+00, 8.8315102780E+00, 2.8318024663E+00, 9.4450806477E-01],
	[3.6050000000E+04, 2.5388621201E+01, 4.9874477018E+00, 8.8354753038E+00, 2.8322900634E+00, 9.4453118225E-01],
	[3.6055000000E+04, 2.5394623543E+01, 4.9874642896E+00, 8.8394415587E+00, 2.8327775601E+00, 9.4455428903E-01],
	[3.6060000000E+04, 2.5400626471E+01, 4.9874808752E+00, 8.8434090428E+00, 2.8332649564E+00, 9.4457738514E-01],
	[3.6065000000E+04, 2.5406629986E+01, 4.9874974585E+00, 8.8473777565E+00, 2.8337522523E+00, 9.4460047055E-01],
	[3.6070000000E+04, 2.5412634087E+01, 4.9875140396E+00, 8.8513477000E+00, 2.8342394477E+00, 9.4462354530E-01],
	[3.6075000000E+04, 2.5418638774E+01, 4.9875306184E+00, 8.8553188733E+00, 2.8347265427E+00, 9.4464660936E-01],
	[3.6080000000E+04, 2.5424644048E+01, 4.9875471950E+00, 8.8592912769E+00, 2.8352135373E+00, 9.4466966277E-01],
	[3.6085000000E+04, 2.5430649907E+01, 4.9875637694E+00, 8.8632649108E+00, 2.8357004314E+00, 9.4469270551E-01],
	[3.6090000000E+04, 2.5436656354E+01, 4.9875803415E+00, 8.8672397752E+00, 2.8361872251E+00, 9.4471573759E-01],
	[3.6095000000E+04, 2.5442663386E+01, 4.9875969113E+00, 8.8712158705E+00, 2.8366739183E+00, 9.4473875902E-01],
	[3.6100000000E+04, 2.5448671005E+01, 4.9876134790E+00, 8.8751931967E+00, 2.8371605112E+00, 9.4476176980E-01],
	[3.6105000000E+04, 2.5454679210E+01, 4.9876300443E+00, 8.8791717542E+00, 2.8376470035E+00, 9.4478476994E-01],
	[3.6110000000E+04, 2.5460688001E+01, 4.9876466075E+00, 8.8831515431E+00, 2.8381333955E+00, 9.4480775945E-01],
	[3.6115000000E+04, 2.5466697379E+01, 4.9876631684E+00, 8.8871325636E+00, 2.8386196869E+00, 9.4483073832E-01],
	[3.6120000000E+04, 2.5472707342E+01, 4.9876797271E+00, 8.8911148159E+00, 2.8391058780E+00, 9.4485370656E-01],
	[3.6125000000E+04, 2.5478717892E+01, 4.9876962835E+00, 8.8950983003E+00, 2.8395919686E+00, 9.4487666418E-01],
	[3.6130000000E+04, 2.5484729028E+01, 4.9877128377E+00, 8.8990830169E+00, 2.8400779587E+00, 9.4489961118E-01],
	[3.6135000000E+04, 2.5490740749E+01, 4.9877293897E+00, 8.9030689660E+00, 2.8405638484E+00, 9.4492254757E-01],
	[3.6140000000E+04, 2.5496753057E+01, 4.9877459394E+00, 8.9070561478E+00, 2.8410496376E+00, 9.4494547335E-01],
	[3.6145000000E+04, 2.5502765951E+01, 4.9877624869E+00, 8.9110445624E+00, 2.8415353264E+00, 9.4496838853E-01],
	[3.6150000000E+04, 2.5508779431E+01, 4.9877790321E+00, 8.9150342102E+00, 2.8420209147E+00, 9.4499129310E-01],
	[3.6155000000E+04, 2.5514793497E+01, 4.9877955752E+00, 8.9190250913E+00, 2.8425064026E+00, 9.4501418709E-01],
	[3.6160000000E+04, 2.5520808149E+01, 4.9878121160E+00, 8.9230172059E+00, 2.8429917900E+00, 9.4503707049E-01],
	[3.6165000000E+04, 2.5526823387E+01, 4.9878286545E+00, 8.9270105542E+00, 2.8434770770E+00, 9.4505994330E-01],
	[3.6170000000E+04, 2.5532839211E+01, 4.9878451908E+00, 8.9310051364E+00, 2.8439622634E+00, 9.4508280554E-01],
	[3.6175000000E+04, 2.5538855620E+01, 4.9878617249E+00, 8.9350009528E+00, 2.8444473495E+00, 9.4510565720E-01],
	[3.6180000000E+04, 2.5544872616E+01, 4.9878782568E+00, 8.9389980036E+00, 2.8449323350E+00, 9.4512849829E-01],
	[3.6185000000E+04, 2.5550890197E+01, 4.9878947864E+00, 8.9429962889E+00, 2.8454172202E+00, 9.4515132882E-01],
	[3.6190000000E+04, 2.5556908364E+01, 4.9879113139E+00, 8.9469958090E+00, 2.8459020048E+00, 9.4517414879E-01],
	[3.6195000000E+04, 2.5562927117E+01, 4.9879278390E+00, 8.9509965641E+00, 2.8463866890E+00, 9.4519695821E-01],
	[3.6200000000E+04, 2.5568946456E+01, 4.9879443620E+00, 8.9549985544E+00, 2.8468712727E+00, 9.4521975707E-01],
	[3.6205000000E+04, 2.5574966380E+01, 4.9879608827E+00, 8.9590017801E+00, 2.8473557559E+00, 9.4524254540E-01],
	[3.6210000000E+04, 2.5580986890E+01, 4.9879774012E+00, 8.9630062414E+00, 2.8478401387E+00, 9.4526532318E-01],
	[3.6215000000E+04, 2.5587007986E+01, 4.9879939175E+00, 8.9670119386E+00, 2.8483244210E+00, 9.4528809043E-01],
	[3.6220000000E+04, 2.5593029668E+01, 4.9880104315E+00, 8.9710188718E+00, 2.8488086028E+00, 9.4531084715E-01],
	[3.6225000000E+04, 2.5599051935E+01, 4.9880269433E+00, 8.9750270412E+00, 2.8492926842E+00, 9.4533359335E-01],
	[3.6230000000E+04, 2.5605090234E+01, 4.9880456940E+00, 8.9790364471E+00, 2.8497775879E+00, 9.4535632902E-01],
	[3.6235000000E+04, 2.5611130554E+01, 4.9880646497E+00, 8.9830470897E+00, 2.8502624770E+00, 9.4537905418E-01],
	[3.6240000000E+04, 2.5617171465E+01, 4.9880836028E+00, 8.9870589692E+00, 2.8507472661E+00, 9.4540176884E-01],
	[3.6245000000E+04, 2.5623212967E+01, 4.9881025534E+00, 8.9910720857E+00, 2.8512319552E+00, 9.4542447298E-01],
	[3.6250000000E+04, 2.5629255061E+01, 4.9881215014E+00, 8.9950864396E+00, 2.8517165442E+00, 9.4544716663E-01],
	[3.6255000000E+04, 2.5635297746E+01, 4.9881404469E+00, 8.9991020310E+00, 2.8522010332E+00, 9.4546984978E-01],
	[3.6260000000E+04, 2.5641341021E+01, 4.9881593899E+00, 9.0031188601E+00, 2.8526854222E+00, 9.4549252244E-01],
	[3.6265000000E+04, 2.5647384888E+01, 4.9881783303E+00, 9.0071369271E+00, 2.8531697111E+00, 9.4551518462E-01],
	[3.6270000000E+04, 2.5653429346E+01, 4.9881972682E+00, 9.0111562323E+00, 2.8536539000E+00, 9.4553783632E-01],
	[3.6275000000E+04, 2.5659474395E+01, 4.9882162035E+00, 9.0151767758E+00, 2.8541379888E+00, 9.4556047754E-01],
	[3.6280000000E+04, 2.5665520035E+01, 4.9882351363E+00, 9.0191985579E+00, 2.8546219776E+00, 9.4558310829E-01],
	[3.6285000000E+04, 2.5671566266E+01, 4.9882540666E+00, 9.0232215788E+00, 2.8551058664E+00, 9.4560572857E-01],
	[3.6290000000E+04, 2.5677613088E+01, 4.9882729943E+00, 9.0272458386E+00, 2.8555896551E+00, 9.4562833840E-01],
	[3.6295000000E+04, 2.5683660501E+01, 4.9882919195E+00, 9.0312713377E+00, 2.8560733438E+00, 9.4565093777E-01],
	[3.6300000000E+04, 2.5689708504E+01, 4.9883108422E+00, 9.0352980761E+00, 2.8565569325E+00, 9.4567352668E-01],
	[3.6305000000E+04, 2.5695757099E+01, 4.9883297623E+00, 9.0393260542E+00, 2.8570404211E+00, 9.4569610515E-01],
	[3.6310000000E+04, 2.5701806285E+01, 4.9883486799E+00, 9.0433552721E+00, 2.8575238096E+00, 9.4571867319E-01],
	[3.6315000000E+04, 2.5707856061E+01, 4.9883675949E+00, 9.0473857301E+00, 2.8580070981E+00, 9.4574123078E-01],
	[3.6320000000E+04, 2.5713906428E+01, 4.9883865075E+00, 9.0514174283E+00, 2.8584902866E+00, 9.4576377794E-01],
	[3.6325000000E+04, 2.5719957386E+01, 4.9884054174E+00, 9.0554503669E+00, 2.8589733750E+00, 9.4578631468E-01],
	[3.6330000000E+04, 2.5726008935E+01, 4.9884243249E+00, 9.0594845462E+00, 2.8594563634E+00, 9.4580884099E-01],
	[3.6335000000E+04, 2.5732061074E+01, 4.9884432298E+00, 9.0635199665E+00, 2.8599392517E+00, 9.4583135689E-01],
	[3.6340000000E+04, 2.5738113805E+01, 4.9884621322E+00, 9.0675566278E+00, 2.8604220400E+00, 9.4585386238E-01],
	[3.6345000000E+04, 2.5744167126E+01, 4.9884810321E+00, 9.0715945304E+00, 2.8609047282E+00, 9.4587635746E-01],
	[3.6350000000E+04, 2.5750221037E+01, 4.9884999295E+00, 9.0756336745E+00, 2.8613873164E+00, 9.4589884214E-01],
	[3.6355000000E+04, 2.5756275539E+01, 4.9885188243E+00, 9.0796740603E+00, 2.8618698045E+00, 9.4592131642E-01],
	[3.6360000000E+04, 2.5762330632E+01, 4.9885377166E+00, 9.0837156881E+00, 2.8623521926E+00, 9.4594378031E-01],
	[3.6365000000E+04, 2.5768386316E+01, 4.9885566063E+00, 9.0877585580E+00, 2.8628344806E+00, 9.4596623381E-01],
	[3.6370000000E+04, 2.5774442590E+01, 4.9885754936E+00, 9.0918026702E+00, 2.8633166686E+00, 9.4598867693E-01],
	[3.6375000000E+04, 2.5780499455E+01, 4.9885943783E+00, 9.0958480251E+00, 2.8637987565E+00, 9.4601110968E-01],
	[3.6380000000E+04, 2.5786556910E+01, 4.9886132605E+00, 9.0998946227E+00, 2.8642807444E+00, 9.4603353205E-01],
	[3.6385000000E+04, 2.5792614956E+01, 4.9886321401E+00, 9.1039424633E+00, 2.8647626322E+00, 9.4605594405E-01],
	[3.6390000000E+04, 2.5798673592E+01, 4.9886510173E+00, 9.1079915470E+00, 2.8652444200E+00, 9.4607834569E-01],
	[3.6395000000E+04, 2.5804732818E+01, 4.9886698919E+00, 9.1120418742E+00, 2.8657261077E+00, 9.4610073697E-01],
	[3.6400000000E+04, 2.5810792636E+01, 4.9886887640E+00, 9.1160934450E+00, 2.8662076954E+00, 9.4612311790E-01],
	[3.6405000000E+04, 2.5816853043E+01, 4.9887076336E+00, 9.1201462597E+00, 2.8666891830E+00, 9.4614548848E-01],
	[3.6410000000E+04, 2.5822914041E+01, 4.9887265006E+00, 9.1242003184E+00, 2.8671705706E+00, 9.4616784872E-01],
	[3.6415000000E+04, 2.5828975629E+01, 4.9887453652E+00, 9.1282556213E+00, 2.8676518581E+00, 9.4619019862E-01],
	[3.6420000000E+04, 2.5835037808E+01, 4.9887642272E+00, 9.1323121687E+00, 2.8681330456E+00, 9.4621253819E-01],
	[3.6425000000E+04, 2.5841100577E+01, 4.9887830867E+00, 9.1363699607E+00, 2.8686141330E+00, 9.4623486743E-01],
	[3.6430000000E+04, 2.5847163936E+01, 4.9888019437E+00, 9.1404289977E+00, 2.8690951203E+00, 9.4625718634E-01],
	[3.6435000000E+04, 2.5853227886E+01, 4.9888207981E+00, 9.1444892797E+00, 2.8695760076E+00, 9.4627949494E-01],
	[3.6440000000E+04, 2.5859292426E+01, 4.9888396501E+00, 9.1485508070E+00, 2.8700567949E+00, 9.4630179322E-01],
	[3.6445000000E+04, 2.5865357556E+01, 4.9888584995E+00, 9.1526135799E+00, 2.8705374821E+00, 9.4632408119E-01],
	[3.6450000000E+04, 2.5871423276E+01, 4.9888773464E+00, 9.1566775984E+00, 2.8710180692E+00, 9.4634635886E-01],
	[3.6455000000E+04, 2.5877489586E+01, 4.9888961908E+00, 9.1607428629E+00, 2.8714985563E+00, 9.4636862623E-01],
	[3.6460000000E+04, 2.5883556487E+01, 4.9889150327E+00, 9.1648093736E+00, 2.8719789433E+00, 9.4639088331E-01],
	[3.6465000000E+04, 2.5889623978E+01, 4.9889338721E+00, 9.1688771306E+00, 2.8724592303E+00, 9.4641313009E-01],
	[3.6470000000E+04, 2.5895692058E+01, 4.9889527090E+00, 9.1729461341E+00, 2.8729394172E+00, 9.4643536659E-01],
	[3.6475000000E+04, 2.5901760729E+01, 4.9889715433E+00, 9.1770163845E+00, 2.8734195041E+00, 9.4645759282E-01],
	[3.6480000000E+04, 2.5907829990E+01, 4.9889903752E+00, 9.1810878818E+00, 2.8738994909E+00, 9.4647980876E-01],
	[3.6485000000E+04, 2.5913899841E+01, 4.9890092045E+00, 9.1851606264E+00, 2.8743793777E+00, 9.4650201444E-01],
	[3.6490000000E+04, 2.5919970283E+01, 4.9890280314E+00, 9.1892346183E+00, 2.8748591644E+00, 9.4652420985E-01],
	[3.6495000000E+04, 2.5926041314E+01, 4.9890468557E+00, 9.1933098579E+00, 2.8753388511E+00, 9.4654639501E-01],
	[3.6500000000E+04, 2.5932112935E+01, 4.9890656775E+00, 9.1973863452E+00, 2.8758184377E+00, 9.4656856990E-01],
	[3.6505000000E+04, 2.5938185146E+01, 4.9890844968E+00, 9.2014640807E+00, 2.8762979243E+00, 9.4659073455E-01],
	[3.6510000000E+04, 2.5944257947E+01, 4.9891033136E+00, 9.2055430644E+00, 2.8767773108E+00, 9.4661288895E-01],
	[3.6515000000E+04, 2.5950331337E+01, 4.9891221279E+00, 9.2096232965E+00, 2.8772565972E+00, 9.4663503311E-01],
	[3.6520000000E+04, 2.5956405318E+01, 4.9891409397E+00, 9.2137047773E+00, 2.8777357836E+00, 9.4665716704E-01],
	[3.6525000000E+04, 2.5962479889E+01, 4.9891597490E+00, 9.2177875070E+00, 2.8782148700E+00, 9.4667929073E-01],
	[3.6530000000E+04, 2.5968555049E+01, 4.9891785557E+00, 9.2218714858E+00, 2.8786938563E+00, 9.4670140420E-01],
	[3.6535000000E+04, 2.5974630799E+01, 4.9891973600E+00, 9.2259567139E+00, 2.8791727426E+00, 9.4672350745E-01],
	[3.6540000000E+04, 2.5980707139E+01, 4.9892161618E+00, 9.2300431915E+00, 2.8796515288E+00, 9.4674560048E-01],
	[3.6545000000E+04, 2.5986784069E+01, 4.9892349611E+00, 9.2341309189E+00, 2.8801302149E+00, 9.4676768330E-01],
	[3.6550000000E+04, 2.5992861588E+01, 4.9892537578E+00, 9.2382198962E+00, 2.8806088010E+00, 9.4678975591E-01],
	[3.6555000000E+04, 2.5998939698E+01, 4.9892725521E+00, 9.2423101236E+00, 2.8810872871E+00, 9.4681181833E-01],
	[3.6560000000E+04, 2.6005018396E+01, 4.9892913439E+00, 9.2464016014E+00, 2.8815656731E+00, 9.4683387054E-01],
	[3.6565000000E+04, 2.6011097685E+01, 4.9893101331E+00, 9.2504943297E+00, 2.8820439591E+00, 9.4685591256E-01],
	[3.6570000000E+04, 2.6017177563E+01, 4.9893289199E+00, 9.2545883089E+00, 2.8825221450E+00, 9.4687794440E-01],
	[3.6575000000E+04, 2.6023258031E+01, 4.9893477042E+00, 9.2586835390E+00, 2.8830002309E+00, 9.4689996605E-01],
	[3.6580000000E+04, 2.6029339088E+01, 4.9893664860E+00, 9.2627800203E+00, 2.8834782167E+00, 9.4692197753E-01],
	[3.6585000000E+04, 2.6035420735E+01, 4.9893852652E+00, 9.2668777531E+00, 2.8839561025E+00, 9.4694397883E-01],
	[3.6590000000E+04, 2.6041502972E+01, 4.9894040420E+00, 9.2709767375E+00, 2.8844338882E+00, 9.4696596997E-01],
	[3.6595000000E+04, 2.6047585798E+01, 4.9894228163E+00, 9.2750769737E+00, 2.8849115739E+00, 9.4698795094E-01],
	[3.6600000000E+04, 2.6053669214E+01, 4.9894415881E+00, 9.2791784619E+00, 2.8853891596E+00, 9.4700992176E-01],
	[3.6605000000E+04, 2.6059753219E+01, 4.9894603574E+00, 9.2832812024E+00, 2.8858666452E+00, 9.4703188242E-01],
	[3.6610000000E+04, 2.6065837813E+01, 4.9894791242E+00, 9.2873851954E+00, 2.8863440308E+00, 9.4705383294E-01],
	[3.6615000000E+04, 2.6071922997E+01, 4.9894978886E+00, 9.2914904410E+00, 2.8868213163E+00, 9.4707577331E-01],
	[3.6620000000E+04, 2.6078008770E+01, 4.9895166504E+00, 9.2955969396E+00, 2.8872985018E+00, 9.4709770354E-01],
	[3.6625000000E+04, 2.6084095133E+01, 4.9895354097E+00, 9.2997046912E+00, 2.8877755872E+00, 9.4711962364E-01],
	[3.6630000000E+04, 2.6090182085E+01, 4.9895541666E+00, 9.3038136962E+00, 2.8882525726E+00, 9.4714153361E-01],
	[3.6635000000E+04, 2.6096269627E+01, 4.9895729209E+00, 9.3079239547E+00, 2.8887294580E+00, 9.4716343346E-01],
	[3.6640000000E+04, 2.6102357757E+01, 4.9895916728E+00, 9.3120354669E+00, 2.8892062434E+00, 9.4718532319E-01],
	[3.6645000000E+04, 2.6108446477E+01, 4.9896104222E+00, 9.3161482330E+00, 2.8896829287E+00, 9.4720720280E-01],
	[3.6650000000E+04, 2.6114535787E+01, 4.9896291691E+00, 9.3202622533E+00, 2.8901595139E+00, 9.4722907231E-01],
	[3.6655000000E+04, 2.6120625685E+01, 4.9896479135E+00, 9.3243775280E+00, 2.8906359992E+00, 9.4725093171E-01],
	[3.6660000000E+04, 2.6126716173E+01, 4.9896666554E+00, 9.3284940572E+00, 2.8911123844E+00, 9.4727278101E-01],
	[3.6665000000E+04, 2.6132807250E+01, 4.9896853948E+00, 9.3326118413E+00, 2.8915886696E+00, 9.4729462021E-01],
	[3.6670000000E+04, 2.6138898916E+01, 4.9897041318E+00, 9.3367308803E+00, 2.8920648547E+00, 9.4731644933E-01],
	[3.6675000000E+04, 2.6144991171E+01, 4.9897228662E+00, 9.3408511746E+00, 2.8925409398E+00, 9.4733826836E-01],
	[3.6680000000E+04, 2.6151084016E+01, 4.9897415982E+00, 9.3449727242E+00, 2.8930169249E+00, 9.4736007731E-01],
	[3.6685000000E+04, 2.6157177449E+01, 4.9897603277E+00, 9.3490955295E+00, 2.8934928100E+00, 9.4738187619E-01],
	[3.6690000000E+04, 2.6163271472E+01, 4.9897790547E+00, 9.3532195906E+00, 2.8939685950E+00, 9.4740366499E-01],
	[3.6695000000E+04, 2.6169366084E+01, 4.9897977792E+00, 9.3573449078E+00, 2.8944442800E+00, 9.4742544373E-01],
	[3.6700000000E+04, 2.6175461284E+01, 4.9898165013E+00, 9.3614714813E+00, 2.8949198650E+00, 9.4744721241E-01],
	[3.6705000000E+04, 2.6181557074E+01, 4.9898352209E+00, 9.3655993112E+00, 2.8953953500E+00, 9.4746897103E-01],
	[3.6710000000E+04, 2.6187653453E+01, 4.9898539380E+00, 9.3697283978E+00, 2.8958707349E+00, 9.4749071960E-01],
	[3.6715000000E+04, 2.6193750421E+01, 4.9898726526E+00, 9.3738587413E+00, 2.8963460198E+00, 9.4751245813E-01],
	[3.6720000000E+04, 2.6199847977E+01, 4.9898913647E+00, 9.3779903419E+00, 2.8968212047E+00, 9.4753418661E-01],
	[3.6725000000E+04, 2.6205946123E+01, 4.9899100744E+00, 9.3821231999E+00, 2.8972962896E+00, 9.4755590506E-01],
	[3.6730000000E+04, 2.6212044857E+01, 4.9899287815E+00, 9.3862573153E+00, 2.8977712745E+00, 9.4757761348E-01],
	[3.6735000000E+04, 2.6218144181E+01, 4.9899474862E+00, 9.3903926886E+00, 2.8982461593E+00, 9.4759931186E-01],
	[3.6740000000E+04, 2.6224244093E+01, 4.9899661885E+00, 9.3945293197E+00, 2.8987209442E+00, 9.4762100023E-01],
	[3.6745000000E+04, 2.6230344594E+01, 4.9899848882E+00, 9.3986672090E+00, 2.8991956290E+00, 9.4764267858E-01],
	[3.6750000000E+04, 2.6236445684E+01, 4.9900035855E+00, 9.4028063567E+00, 2.8996702138E+00, 9.4766434692E-01],
	[3.6755000000E+04, 2.6242547362E+01, 4.9900222803E+00, 9.4069467630E+00, 2.9001446986E+00, 9.4768600525E-01],
	[3.6760000000E+04, 2.6248649629E+01, 4.9900409726E+00, 9.4110884281E+00, 2.9006190834E+00, 9.4770765357E-01],
	[3.6765000000E+04, 2.6254752486E+01, 4.9900596625E+00, 9.4152313522E+00, 2.9010933682E+00, 9.4772929190E-01],
	[3.6770000000E+04, 2.6260855930E+01, 4.9900783499E+00, 9.4193755355E+00, 2.9015675530E+00, 9.4775092024E-01],
	[3.6775000000E+04, 2.6266959964E+01, 4.9900970348E+00, 9.4235209782E+00, 2.9020416378E+00, 9.4777253858E-01],
	[3.6780000000E+04, 2.6273064586E+01, 4.9901157172E+00, 9.4276676806E+00, 2.9025156226E+00, 9.4779414695E-01],
	[3.6785000000E+04, 2.6279169797E+01, 4.9901343972E+00, 9.4318156428E+00, 2.9029895074E+00, 9.4781574533E-01],
	[3.6790000000E+04, 2.6285275596E+01, 4.9901530747E+00, 9.4359648651E+00, 2.9034632921E+00, 9.4783733374E-01],
	[3.6795000000E+04, 2.6291381984E+01, 4.9901717498E+00, 9.4401153476E+00, 2.9039369769E+00, 9.4785891219E-01],
	[3.6800000000E+04, 2.6297488961E+01, 4.9901904223E+00, 9.4442670907E+00, 2.9044105617E+00, 9.4788048066E-01],
	[3.6805000000E+04, 2.6303596526E+01, 4.9902090924E+00, 9.4484200944E+00, 2.9048840465E+00, 9.4790203918E-01],
	[3.6810000000E+04, 2.6309709345E+01, 4.9902284290E+00, 9.4525743590E+00, 2.9053577149E+00, 9.4792358775E-01],
	[3.6815000000E+04, 2.6315834798E+01, 4.9902494895E+00, 9.4567298848E+00, 2.9058320158E+00, 9.4794512636E-01],
	[3.6820000000E+04, 2.6321960845E+01, 4.9902705471E+00, 9.4608866719E+00, 2.9063062170E+00, 9.4796665503E-01],
	[3.6825000000E+04, 2.6328087486E+01, 4.9902916020E+00, 9.4650447205E+00, 2.9067803187E+00, 9.4798817376E-01],
	[3.6830000000E+04, 2.6334214721E+01, 4.9903126542E+00, 9.4692040309E+00, 2.9072543208E+00, 9.4800968256E-01],
	[3.6835000000E+04, 2.6340342550E+01, 4.9903337035E+00, 9.4733646032E+00, 2.9077282234E+00, 9.4803118142E-01],
	[3.6840000000E+04, 2.6346470973E+01, 4.9903547501E+00, 9.4775264378E+00, 2.9082020264E+00, 9.4805267036E-01],
	[3.6845000000E+04, 2.6352599990E+01, 4.9903757940E+00, 9.4816895347E+00, 2.9086757298E+00, 9.4807414938E-01],
	[3.6850000000E+04, 2.6358729600E+01, 4.9903968350E+00, 9.4858538942E+00, 2.9091493337E+00, 9.4809561848E-01],
	[3.6855000000E+04, 2.6364859805E+01, 4.9904178733E+00, 9.4900195165E+00, 2.9096228380E+00, 9.4811707767E-01],
	[3.6860000000E+04, 2.6370990603E+01, 4.9904389089E+00, 9.4941864018E+00, 2.9100962428E+00, 9.4813852695E-01],
	[3.6865000000E+04, 2.6377121995E+01, 4.9904599416E+00, 9.4983545503E+00, 2.9105695480E+00, 9.4815996634E-01],
	[3.6870000000E+04, 2.6383253981E+01, 4.9904809716E+00, 9.5025239623E+00, 2.9110427537E+00, 9.4818139582E-01],
	[3.6875000000E+04, 2.6389386560E+01, 4.9905019989E+00, 9.5066946380E+00, 2.9115158598E+00, 9.4820281542E-01],
	[3.6880000000E+04, 2.6395519733E+01, 4.9905230234E+00, 9.5108665775E+00, 2.9119888664E+00, 9.4822422512E-01],
	[3.6885000000E+04, 2.6401653500E+01, 4.9905440451E+00, 9.5150397811E+00, 2.9124617734E+00, 9.4824562495E-01],
	[3.6890000000E+04, 2.6407787860E+01, 4.9905650640E+00, 9.5192142489E+00, 2.9129345809E+00, 9.4826701490E-01],
	[3.6895000000E+04, 2.6413922814E+01, 4.9905860802E+00, 9.5233899813E+00, 2.9134072889E+00, 9.4828839497E-01],
	[3.6900000000E+04, 2.6420058362E+01, 4.9906070937E+00, 9.5275669784E+00, 2.9138798973E+00, 9.4830976518E-01],
	[3.6905000000E+04, 2.6426194503E+01, 4.9906281043E+00, 9.5317452404E+00, 2.9143524062E+00, 9.4833112552E-01],
	[3.6910000000E+04, 2.6432331238E+01, 4.9906491123E+00, 9.5359247675E+00, 2.9148248155E+00, 9.4835247601E-01],
	[3.6915000000E+04, 2.6438468566E+01, 4.9906701174E+00, 9.5401055600E+00, 2.9152971254E+00, 9.4837381664E-01],
	[3.6920000000E+04, 2.6444606488E+01, 4.9906911198E+00, 9.5442876180E+00, 2.9157693356E+00, 9.4839514742E-01],
	[3.6925000000E+04, 2.6450745004E+01, 4.9907121195E+00, 9.5484709417E+00, 2.9162414464E+00, 9.4841646836E-01],
	[3.6930000000E+04, 2.6456884113E+01, 4.9907331164E+00, 9.5526555315E+00, 2.9167134576E+00, 9.4843777946E-01],
	[3.6935000000E+04, 2.6463023815E+01, 4.9907541105E+00, 9.5568413874E+00, 2.9171853693E+00, 9.4845908073E-01],
	[3.6940000000E+04, 2.6469164111E+01, 4.9907751019E+00, 9.5610285098E+00, 2.9176571815E+00, 9.4848037217E-01],
	[3.6945000000E+04, 2.6475305000E+01, 4.9907960905E+00, 9.5652168987E+00, 2.9181288942E+00, 9.4850165378E-01],
	[3.6950000000E+04, 2.6481446482E+01, 4.9908170764E+00, 9.5694065545E+00, 2.9186005073E+00, 9.4852292557E-01],
	[3.6955000000E+04, 2.6487588558E+01, 4.9908380596E+00, 9.5735974773E+00, 2.9190720210E+00, 9.4854418755E-01],
	[3.6960000000E+04, 2.6493731227E+01, 4.9908590399E+00, 9.5777896674E+00, 2.9195434351E+00, 9.4856543972E-01],
	[3.6965000000E+04, 2.6499874490E+01, 4.9908800176E+00, 9.5819831249E+00, 2.9200147497E+00, 9.4858668208E-01],
	[3.6970000000E+04, 2.6506018345E+01, 4.9909009925E+00, 9.5861778500E+00, 2.9204859648E+00, 9.4860791464E-01],
	[3.6975000000E+04, 2.6512162794E+01, 4.9909219646E+00, 9.5903738431E+00, 2.9209570803E+00, 9.4862913740E-01],
	[3.6980000000E+04, 2.6518307837E+01, 4.9909429340E+00, 9.5945711042E+00, 2.9214280964E+00, 9.4865035038E-01],
	[3.6985000000E+04, 2.6524453472E+01, 4.9909639006E+00, 9.5987696336E+00, 2.9218990130E+00, 9.4867155356E-01],
	[3.6990000000E+04, 2.6530599701E+01, 4.9909848645E+00, 9.6029694316E+00, 2.9223698301E+00, 9.4869274697E-01],
	[3.6995000000E+04, 2.6536746523E+01, 4.9910058257E+00, 9.6071704982E+00, 2.9228405477E+00, 9.4871393060E-01],
	[3.7000000000E+04, 2.6542893938E+01, 4.9910267841E+00, 9.6113728338E+00, 2.9233111657E+00, 9.4873510446E-01],
	[3.7005000000E+04, 2.6549041946E+01, 4.9910477397E+00, 9.6155764386E+00, 2.9237816843E+00, 9.4875626855E-01],
	[3.7010000000E+04, 2.6555190547E+01, 4.9910686926E+00, 9.6197813127E+00, 2.9242521034E+00, 9.4877742287E-01],
	[3.7015000000E+04, 2.6561339741E+01, 4.9910896428E+00, 9.6239874563E+00, 2.9247224230E+00, 9.4879856744E-01],
	[3.7020000000E+04, 2.6567489529E+01, 4.9911105902E+00, 9.6281948698E+00, 2.9251926432E+00, 9.4881970226E-01],
	[3.7025000000E+04, 2.6573639909E+01, 4.9911315349E+00, 9.6324035532E+00, 2.9256627638E+00, 9.4884082733E-01],
	[3.7030000000E+04, 2.6579790883E+01, 4.9911524769E+00, 9.6366135069E+00, 2.9261327850E+00, 9.4886194265E-01],
	[3.7035000000E+04, 2.6585942449E+01, 4.9911734161E+00, 9.6408247309E+00, 2.9266027066E+00, 9.4888304824E-01],
	[3.7040000000E+04, 2.6592094608E+01, 4.9911943525E+00, 9.6450372256E+00, 2.9270725288E+00, 9.4890414409E-01],
	[3.7045000000E+04, 2.6598247361E+01, 4.9912152863E+00, 9.6492509911E+00, 2.9275422516E+00, 9.4892523022E-01],
	[3.7050000000E+04, 2.6604400706E+01, 4.9912362173E+00, 9.6534660277E+00, 2.9280118748E+00, 9.4894630662E-01],
	[3.7055000000E+04, 2.6610554644E+01, 4.9912571455E+00, 9.6576823355E+00, 2.9284813986E+00, 9.4896737330E-01],
	[3.7060000000E+04, 2.6616709175E+01, 4.9912780711E+00, 9.6618999148E+00, 2.9289508229E+00, 9.4898843026E-01],
	[3.7065000000E+04, 2.6622864299E+01, 4.9912989938E+00, 9.6661187658E+00, 2.9294201478E+00, 9.4900947752E-01],
	[3.7070000000E+04, 2.6629020016E+01, 4.9913199139E+00, 9.6703388886E+00, 2.9298893732E+00, 9.4903051507E-01],
	[3.7075000000E+04, 2.6635176325E+01, 4.9913408312E+00, 9.6745602836E+00, 2.9303584991E+00, 9.4905154292E-01],
	[3.7080000000E+04, 2.6641333227E+01, 4.9913617458E+00, 9.6787829509E+00, 2.9308275256E+00, 9.4907256107E-01],
	[3.7085000000E+04, 2.6647490722E+01, 4.9913826577E+00, 9.6830068907E+00, 2.9312964526E+00, 9.4909356954E-01],
	[3.7090000000E+04, 2.6653648810E+01, 4.9914035668E+00, 9.6872321033E+00, 2.9317652802E+00, 9.4911456832E-01],
	[3.7095000000E+04, 2.6659807491E+01, 4.9914244732E+00, 9.6914585888E+00, 2.9322340083E+00, 9.4913555741E-01],
	[3.7100000000E+04, 2.6665966764E+01, 4.9914453768E+00, 9.6956863475E+00, 2.9327026370E+00, 9.4915653683E-01],
	[3.7105000000E+04, 2.6672126630E+01, 4.9914662778E+00, 9.6999153795E+00, 2.9331711662E+00, 9.4917750658E-01],
	[3.7110000000E+04, 2.6678287088E+01, 4.9914871760E+00, 9.7041456851E+00, 2.9336395960E+00, 9.4919846666E-01],
	[3.7115000000E+04, 2.6684448139E+01, 4.9915080714E+00, 9.7083772646E+00, 2.9341079264E+00, 9.4921941708E-01],
	[3.7120000000E+04, 2.6690609783E+01, 4.9915289642E+00, 9.7126101180E+00, 2.9345761573E+00, 9.4924035784E-01],
	[3.7125000000E+04, 2.6696772019E+01, 4.9915498542E+00, 9.7168442457E+00, 2.9350442888E+00, 9.4926128895E-01],
	[3.7130000000E+04, 2.6702934848E+01, 4.9915707415E+00, 9.7210796477E+00, 2.9355123209E+00, 9.4928221041E-01],
	[3.7135000000E+04, 2.6709098269E+01, 4.9915916261E+00, 9.7253163245E+00, 2.9359802536E+00, 9.4930312222E-01],
	[3.7140000000E+04, 2.6715262283E+01, 4.9916125079E+00, 9.7295542761E+00, 2.9364480868E+00, 9.4932402440E-01],
	[3.7145000000E+04, 2.6721426889E+01, 4.9916333870E+00, 9.7337935027E+00, 2.9369158206E+00, 9.4934491694E-01],
	[3.7150000000E+04, 2.6727592088E+01, 4.9916542634E+00, 9.7380340046E+00, 2.9373834550E+00, 9.4936579986E-01],
	[3.7155000000E+04, 2.6733757880E+01, 4.9916751371E+00, 9.7422757821E+00, 2.9378509899E+00, 9.4938667315E-01],
	[3.7160000000E+04, 2.6739924263E+01, 4.9916960081E+00, 9.7465188352E+00, 2.9383184255E+00, 9.4940753682E-01],
	[3.7165000000E+04, 2.6746091239E+01, 4.9917168763E+00, 9.7507631642E+00, 2.9387857617E+00, 9.4942839088E-01],
	[3.7170000000E+04, 2.6752258808E+01, 4.9917377418E+00, 9.7550087694E+00, 2.9392529984E+00, 9.4944923532E-01],
	[3.7175000000E+04, 2.6758426968E+01, 4.9917586046E+00, 9.7592556508E+00, 2.9397201358E+00, 9.4947007016E-01],
	[3.7180000000E+04, 2.6764595722E+01, 4.9917794647E+00, 9.7635038089E+00, 2.9401871737E+00, 9.4949089540E-01],
	[3.7185000000E+04, 2.6770765067E+01, 4.9918003220E+00, 9.7677532437E+00, 2.9406541123E+00, 9.4951171105E-01],
	[3.7190000000E+04, 2.6776935005E+01, 4.9918211767E+00, 9.7720039555E+00, 2.9411209514E+00, 9.4953251710E-01],
	[3.7195000000E+04, 2.6783105535E+01, 4.9918420286E+00, 9.7762559444E+00, 2.9415876912E+00, 9.4955331357E-01],
	[3.7200000000E+04, 2.6789276657E+01, 4.9918628778E+00, 9.7805092107E+00, 2.9420543316E+00, 9.4957410045E-01],
	[3.7205000000E+04, 2.6795448371E+01, 4.9918837243E+00, 9.7847637547E+00, 2.9425208726E+00, 9.4959487776E-01],
	[3.7210000000E+04, 2.6801620678E+01, 4.9919045681E+00, 9.7890195765E+00, 2.9429873142E+00, 9.4961564550E-01],
	[3.7215000000E+04, 2.6807793577E+01, 4.9919254091E+00, 9.7932766763E+00, 2.9434536565E+00, 9.4963640367E-01],
	[3.7220000000E+04, 2.6813967067E+01, 4.9919462475E+00, 9.7975350543E+00, 2.9439198994E+00, 9.4965715227E-01],
	[3.7225000000E+04, 2.6820141150E+01, 4.9919670831E+00, 9.8017947108E+00, 2.9443860429E+00, 9.4967789132E-01],
	[3.7230000000E+04, 2.6826315826E+01, 4.9919879160E+00, 9.8060556459E+00, 2.9448520870E+00, 9.4969862082E-01],
	[3.7235000000E+04, 2.6832491093E+01, 4.9920087463E+00, 9.8103178599E+00, 2.9453180318E+00, 9.4971934076E-01],
	[3.7240000000E+04, 2.6838666952E+01, 4.9920295738E+00, 9.8145813531E+00, 2.9457838772E+00, 9.4974005116E-01],
	[3.7245000000E+04, 2.6844843403E+01, 4.9920503986E+00, 9.8188461255E+00, 2.9462496233E+00, 9.4976075203E-01],
	[3.7250000000E+04, 2.6851020447E+01, 4.9920712207E+00, 9.8231121774E+00, 2.9467152700E+00, 9.4978144336E-01],
	[3.7255000000E+04, 2.6857198082E+01, 4.9920920400E+00, 9.8273795090E+00, 2.9471808174E+00, 9.4980212516E-01],
	[3.7260000000E+04, 2.6863376309E+01, 4.9921128567E+00, 9.8316481206E+00, 2.9476462654E+00, 9.4982279743E-01],
	[3.7265000000E+04, 2.6869555128E+01, 4.9921336707E+00, 9.8359180123E+00, 2.9481116141E+00, 9.4984346018E-01],
	[3.7270000000E+04, 2.6875734539E+01, 4.9921544819E+00, 9.8401891844E+00, 2.9485768634E+00, 9.4986411342E-01],
	[3.7275000000E+04, 2.6881914542E+01, 4.9921752905E+00, 9.8444616370E+00, 2.9490420134E+00, 9.4988475715E-01],
	[3.7280000000E+04, 2.6888095137E+01, 4.9921960964E+00, 9.8487353705E+00, 2.9495070641E+00, 9.4990539137E-01],
	[3.7285000000E+04, 2.6894276324E+01, 4.9922168995E+00, 9.8530103849E+00, 2.9499720154E+00, 9.4992601609E-01],
	[3.7290000000E+04, 2.6900458102E+01, 4.9922377000E+00, 9.8572866805E+00, 2.9504368674E+00, 9.4994663132E-01],
	[3.7295000000E+04, 2.6906640473E+01, 4.9922584977E+00, 9.8615642575E+00, 2.9509016201E+00, 9.4996723705E-01],
	[3.7300000000E+04, 2.6912823435E+01, 4.9922792927E+00, 9.8658431162E+00, 2.9513662735E+00, 9.4998783329E-01],
	[3.7305000000E+04, 2.6919006989E+01, 4.9923000851E+00, 9.8701232567E+00, 2.9518308275E+00, 9.5000842006E-01],
	[3.7310000000E+04, 2.6925191134E+01, 4.9923208747E+00, 9.8744046793E+00, 2.9522952823E+00, 9.5002899734E-01],
	[3.7315000000E+04, 2.6931375871E+01, 4.9923416617E+00, 9.8786873841E+00, 2.9527596377E+00, 9.5004956515E-01],
	[3.7320000000E+04, 2.6937561200E+01, 4.9923624459E+00, 9.8829713714E+00, 2.9532238939E+00, 9.5007012349E-01],
	[3.7325000000E+04, 2.6943747121E+01, 4.9923832275E+00, 9.8872566414E+00, 2.9536880507E+00, 9.5009067237E-01],
	[3.7330000000E+04, 2.6949933633E+01, 4.9924040063E+00, 9.8915431942E+00, 2.9541521083E+00, 9.5011121179E-01],
	[3.7335000000E+04, 2.6956120737E+01, 4.9924247825E+00, 9.8958310302E+00, 2.9546160665E+00, 9.5013174176E-01],
	[3.7340000000E+04, 2.6962308433E+01, 4.9924455559E+00, 9.9001201495E+00, 2.9550799255E+00, 9.5015226228E-01],
	[3.7345000000E+04, 2.6968496720E+01, 4.9924663267E+00, 9.9044105524E+00, 2.9555436851E+00, 9.5017277335E-01],
	[3.7350000000E+04, 2.6974685598E+01, 4.9924870947E+00, 9.9087022390E+00, 2.9560073455E+00, 9.5019327498E-01],
	[3.7355000000E+04, 2.6980875069E+01, 4.9925078601E+00, 9.9129952095E+00, 2.9564709067E+00, 9.5021376717E-01],
	[3.7360000000E+04, 2.6987065130E+01, 4.9925286228E+00, 9.9172894642E+00, 2.9569343685E+00, 9.5023424994E-01],
	[3.7365000000E+04, 2.6993255784E+01, 4.9925493828E+00, 9.9215850033E+00, 2.9573977311E+00, 9.5025472328E-01],
	[3.7370000000E+04, 2.6999447028E+01, 4.9925701401E+00, 9.9258818270E+00, 2.9578609944E+00, 9.5027518720E-01],
	[3.7375000000E+04, 2.7005638864E+01, 4.9925908947E+00, 9.9301799355E+00, 2.9583241584E+00, 9.5029564170E-01],
	[3.7380000000E+04, 2.7011831292E+01, 4.9926116466E+00, 9.9344793290E+00, 2.9587872232E+00, 9.5031608678E-01],
	[3.7385000000E+04, 2.7018024311E+01, 4.9926323958E+00, 9.9387800077E+00, 2.9592501888E+00, 9.5033652247E-01],
	[3.7390000000E+04, 2.7024217921E+01, 4.9926531424E+00, 9.9430819719E+00, 2.9597130550E+00, 9.5035694875E-01],
	[3.7395000000E+04, 2.7030412122E+01, 4.9926738862E+00, 9.9473852217E+00, 2.9601758221E+00, 9.5037736563E-01],
	[3.7400000000E+04, 2.7036606915E+01, 4.9926946274E+00, 9.9516897574E+00, 2.9606384899E+00, 9.5039777311E-01],
	[3.7405000000E+04, 2.7042814960E+01, 4.9927171598E+00, 9.9559955792E+00, 2.9611018413E+00, 9.5041817121E-01],
	[3.7410000000E+04, 2.7049027477E+01, 4.9927402387E+00, 9.9603026872E+00, 2.9615653335E+00, 9.5043855993E-01],
	[3.7415000000E+04, 2.7055240592E+01, 4.9927633146E+00, 9.9646110818E+00, 2.9620287269E+00, 9.5045893926E-01],
	[3.7420000000E+04, 2.7061454302E+01, 4.9927863876E+00, 9.9689207631E+00, 2.9624920215E+00, 9.5047930922E-01],
	[3.7425000000E+04, 2.7067668610E+01, 4.9928094575E+00, 9.9732317313E+00, 2.9629552172E+00, 9.5049966982E-01],
	[3.7430000000E+04, 2.7073883514E+01, 4.9928325245E+00, 9.9775439866E+00, 2.9634183142E+00, 9.5052002104E-01],
	[3.7435000000E+04, 2.7080099014E+01, 4.9928555885E+00, 9.9818575292E+00, 2.9638813123E+00, 9.5054036291E-01],
	[3.7440000000E+04, 2.7086315111E+01, 4.9928786496E+00, 9.9861723595E+00, 2.9643442117E+00, 9.5056069542E-01],
	[3.7445000000E+04, 2.7092531805E+01, 4.9929017076E+00, 9.9904884775E+00, 2.9648070122E+00, 9.5058101858E-01],
	[3.7450000000E+04, 2.7098749095E+01, 4.9929247627E+00, 9.9948058835E+00, 2.9652697139E+00, 9.5060133239E-01],
	[3.7455000000E+04, 2.7104966981E+01, 4.9929478148E+00, 9.9991245776E+00, 2.9657323169E+00, 9.5062163686E-01],
	[3.7460000000E+04, 2.7111185464E+01, 4.9929708640E+00, 1.0003444560E+01, 2.9661948210E+00, 9.5064193199E-01],
	[3.7465000000E+04, 2.7117404544E+01, 4.9929939102E+00, 1.0007765831E+01, 2.9666572264E+00, 9.5066221779E-01],
	[3.7470000000E+04, 2.7123624219E+01, 4.9930169534E+00, 1.0012088391E+01, 2.9671195330E+00, 9.5068249427E-01],
	[3.7475000000E+04, 2.7129844491E+01, 4.9930399936E+00, 1.0016412241E+01, 2.9675817408E+00, 9.5070276141E-01],
	[3.7480000000E+04, 2.7136065360E+01, 4.9930630309E+00, 1.0020737379E+01, 2.9680438498E+00, 9.5072301925E-01],
	[3.7485000000E+04, 2.7142286824E+01, 4.9930860652E+00, 1.0025063807E+01, 2.9685058601E+00, 9.5074326776E-01],
	[3.7490000000E+04, 2.7148508885E+01, 4.9931090965E+00, 1.0029391524E+01, 2.9689677716E+00, 9.5076350697E-01],
	[3.7495000000E+04, 2.7154731543E+01, 4.9931321249E+00, 1.0033720532E+01, 2.9694295843E+00, 9.5078373687E-01],
	[3.7500000000E+04, 2.7160954796E+01, 4.9931551503E+00, 1.0038050829E+01, 2.9698912983E+00, 9.5080395748E-01],
	[3.7505000000E+04, 2.7167178646E+01, 4.9931781728E+00, 1.0042382417E+01, 2.9703529135E+00, 9.5082416879E-01],
	[3.7510000000E+04, 2.7173403092E+01, 4.9932011922E+00, 1.0046715295E+01, 2.9708144300E+00, 9.5084437080E-01],
	[3.7515000000E+04, 2.7179628134E+01, 4.9932242088E+00, 1.0051049464E+01, 2.9712758477E+00, 9.5086456354E-01],
	[3.7520000000E+04, 2.7185853773E+01, 4.9932472223E+00, 1.0055384924E+01, 2.9717371667E+00, 9.5088474699E-01],
	[3.7525000000E+04, 2.7192080007E+01, 4.9932702329E+00, 1.0059721675E+01, 2.9721983870E+00, 9.5090492116E-01],
	[3.7530000000E+04, 2.7198306838E+01, 4.9932932406E+00, 1.0064059718E+01, 2.9726595085E+00, 9.5092508606E-01],
	[3.7535000000E+04, 2.7204534265E+01, 4.9933162452E+00, 1.0068399052E+01, 2.9731205313E+00, 9.5094524170E-01],
	[3.7540000000E+04, 2.7210762287E+01, 4.9933392470E+00, 1.0072739678E+01, 2.9735814554E+00, 9.5096538807E-01],
	[3.7545000000E+04, 2.7216990906E+01, 4.9933622457E+00, 1.0077081596E+01, 2.9740422807E+00, 9.5098552518E-01],
	[3.7550000000E+04, 2.7223220121E+01, 4.9933852415E+00, 1.0081424806E+01, 2.9745030074E+00, 9.5100565304E-01],
	[3.7555000000E+04, 2.7229449932E+01, 4.9934082344E+00, 1.0085769309E+01, 2.9749636353E+00, 9.5102577166E-01],
	[3.7560000000E+04, 2.7235680339E+01, 4.9934312243E+00, 1.0090115104E+01, 2.9754241645E+00, 9.5104588102E-01],
	[3.7565000000E+04, 2.7241911342E+01, 4.9934542112E+00, 1.0094462192E+01, 2.9758845951E+00, 9.5106598115E-01],
	[3.7570000000E+04, 2.7248142941E+01, 4.9934771952E+00, 1.0098810573E+01, 2.9763449269E+00, 9.5108607205E-01],
	[3.7575000000E+04, 2.7254375135E+01, 4.9935001762E+00, 1.0103160248E+01, 2.9768051601E+00, 9.5110615371E-01],
	[3.7580000000E+04, 2.7260607926E+01, 4.9935231543E+00, 1.0107511216E+01, 2.9772652945E+00, 9.5112622615E-01],
	[3.7585000000E+04, 2.7266841312E+01, 4.9935461295E+00, 1.0111863477E+01, 2.9777253303E+00, 9.5114628936E-01],
	[3.7590000000E+04, 2.7273075295E+01, 4.9935691016E+00, 1.0116217033E+01, 2.9781852674E+00, 9.5116634336E-01],
	[3.7595000000E+04, 2.7279309873E+01, 4.9935920709E+00, 1.0120571882E+01, 2.9786451058E+00, 9.5118638815E-01],
	[3.7600000000E+04, 2.7285545047E+01, 4.9936150372E+00, 1.0124928027E+01, 2.9791048456E+00, 9.5120642374E-01],
	[3.7605000000E+04, 2.7291780817E+01, 4.9936380005E+00, 1.0129285465E+01, 2.9795644867E+00, 9.5122645011E-01],
	[3.7610000000E+04, 2.7298017182E+01, 4.9936609609E+00, 1.0133644199E+01, 2.9800240291E+00, 9.5124646730E-01],
	[3.7615000000E+04, 2.7304254143E+01, 4.9936839183E+00, 1.0138004227E+01, 2.9804834729E+00, 9.5126647528E-01],
	[3.7620000000E+04, 2.7310491700E+01, 4.9937068728E+00, 1.0142365550E+01, 2.9809428180E+00, 9.5128647408E-01],
	[3.7625000000E+04, 2.7316729853E+01, 4.9937298244E+00, 1.0146728169E+01, 2.9814020645E+00, 9.5130646370E-01],
	[3.7630000000E+04, 2.7322968601E+01, 4.9937527730E+00, 1.0151092084E+01, 2.9818612123E+00, 9.5132644414E-01],
	[3.7635000000E+04, 2.7329207945E+01, 4.9937757186E+00, 1.0155457294E+01, 2.9823202615E+00, 9.5134641540E-01],
	[3.7640000000E+04, 2.7335447885E+01, 4.9937986614E+00, 1.0159823801E+01, 2.9827792121E+00, 9.5136637749E-01],
	[3.7645000000E+04, 2.7341688420E+01, 4.9938216011E+00, 1.0164191604E+01, 2.9832380640E+00, 9.5138633042E-01],
	[3.7650000000E+04, 2.7347929551E+01, 4.9938445380E+00, 1.0168560703E+01, 2.9836968174E+00, 9.5140627418E-01],
	[3.7655000000E+04, 2.7354171277E+01, 4.9938674719E+00, 1.0172931099E+01, 2.9841554721E+00, 9.5142620879E-01],
	[3.7660000000E+04, 2.7360413599E+01, 4.9938904028E+00, 1.0177302791E+01, 2.9846140282E+00, 9.5144613425E-01],
	[3.7665000000E+04, 2.7366656517E+01, 4.9939133308E+00, 1.0181675781E+01, 2.9850724857E+00, 9.5146605056E-01],
	[3.7670000000E+04, 2.7372900030E+01, 4.9939362559E+00, 1.0186050068E+01, 2.9855308446E+00, 9.5148595773E-01],
	[3.7675000000E+04, 2.7379144138E+01, 4.9939591780E+00, 1.0190425653E+01, 2.9859891049E+00, 9.5150585576E-01],
	[3.7680000000E+04, 2.7385388842E+01, 4.9939820973E+00, 1.0194802535E+01, 2.9864472666E+00, 9.5152574466E-01],
	[3.7685000000E+04, 2.7391634141E+01, 4.9940050135E+00, 1.0199180716E+01, 2.9869053297E+00, 9.5154562443E-01],
	[3.7690000000E+04, 2.7397880036E+01, 4.9940279269E+00, 1.0203560194E+01, 2.9873632942E+00, 9.5156549507E-01],
	[3.7695000000E+04, 2.7404126526E+01, 4.9940508373E+00, 1.0207940971E+01, 2.9878211601E+00, 9.5158535660E-01],
	[3.7700000000E+04, 2.7410373612E+01, 4.9940737447E+00, 1.0212323047E+01, 2.9882789275E+00, 9.5160520901E-01],
	[3.7705000000E+04, 2.7416621292E+01, 4.9940966492E+00, 1.0216706421E+01, 2.9887365963E+00, 9.5162505231E-01],
	[3.7710000000E+04, 2.7422869569E+01, 4.9941195508E+00, 1.0221091094E+01, 2.9891941666E+00, 9.5164488651E-01],
	[3.7715000000E+04, 2.7429118440E+01, 4.9941424495E+00, 1.0225477067E+01, 2.9896516383E+00, 9.5166471160E-01],
	[3.7720000000E+04, 2.7435367907E+01, 4.9941653453E+00, 1.0229864339E+01, 2.9901090114E+00, 9.5168452760E-01],
	[3.7725000000E+04, 2.7441617969E+01, 4.9941882381E+00, 1.0234252911E+01, 2.9905662860E+00, 9.5170433451E-01],
	[3.7730000000E+04, 2.7447868626E+01, 4.9942111279E+00, 1.0238642782E+01, 2.9910234621E+00, 9.5172413232E-01],
	[3.7735000000E+04, 2.7454119878E+01, 4.9942340149E+00, 1.0243033954E+01, 2.9914805396E+00, 9.5174392106E-01],
	[3.7740000000E+04, 2.7460371726E+01, 4.9942568989E+00, 1.0247426425E+01, 2.9919375185E+00, 9.5176370072E-01],
	[3.7745000000E+04, 2.7466624168E+01, 4.9942797800E+00, 1.0251820198E+01, 2.9923943990E+00, 9.5178347130E-01],
	[3.7750000000E+04, 2.7472877206E+01, 4.9943026582E+00, 1.0256215271E+01, 2.9928511809E+00, 9.5180323282E-01],
	[3.7755000000E+04, 2.7479130839E+01, 4.9943255334E+00, 1.0260611645E+01, 2.9933078643E+00, 9.5182298527E-01],
	[3.7760000000E+04, 2.7485385067E+01, 4.9943484057E+00, 1.0265009320E+01, 2.9937644492E+00, 9.5184272867E-01],
	[3.7765000000E+04, 2.7491639890E+01, 4.9943712751E+00, 1.0269408296E+01, 2.9942209356E+00, 9.5186246300E-01],
	[3.7770000000E+04, 2.7497895309E+01, 4.9943941416E+00, 1.0273808574E+01, 2.9946773235E+00, 9.5188218829E-01],
	[3.7775000000E+04, 2.7504151322E+01, 4.9944170052E+00, 1.0278210154E+01, 2.9951336129E+00, 9.5190190453E-01],
	[3.7780000000E+04, 2.7510407930E+01, 4.9944398658E+00, 1.0282613036E+01, 2.9955898038E+00, 9.5192161173E-01],
	[3.7785000000E+04, 2.7516665133E+01, 4.9944627235E+00, 1.0287017220E+01, 2.9960458963E+00, 9.5194130989E-01],
	[3.7790000000E+04, 2.7522922932E+01, 4.9944855783E+00, 1.0291422706E+01, 2.9965018902E+00, 9.5196099902E-01],
	[3.7795000000E+04, 2.7529181325E+01, 4.9945084302E+00, 1.0295829495E+01, 2.9969577857E+00, 9.5198067912E-01],
	[3.7800000000E+04, 2.7535440313E+01, 4.9945312791E+00, 1.0300237587E+01, 2.9974135827E+00, 9.5200035020E-01],
	[3.7805000000E+04, 2.7541699896E+01, 4.9945541252E+00, 1.0304646982E+01, 2.9978692812E+00, 9.5202001227E-01],
	[3.7810000000E+04, 2.7547960074E+01, 4.9945769683E+00, 1.0309057680E+01, 2.9983248813E+00, 9.5203966531E-01],
	[3.7815000000E+04, 2.7554220846E+01, 4.9945998085E+00, 1.0313469682E+01, 2.9987803829E+00, 9.5205930935E-01],
	[3.7820000000E+04, 2.7560482214E+01, 4.9946226458E+00, 1.0317882987E+01, 2.9992357861E+00, 9.5207894438E-01],
	[3.7825000000E+04, 2.7566744176E+01, 4.9946454801E+00, 1.0322297597E+01, 2.9996910908E+00, 9.5209857042E-01],
	[3.7830000000E+04, 2.7573006733E+01, 4.9946683116E+00, 1.0326713510E+01, 3.0001462971E+00, 9.5211818745E-01],
	[3.7835000000E+04, 2.7579269885E+01, 4.9946911401E+00, 1.0331130728E+01, 3.0006014050E+00, 9.5213779550E-01],
	[3.7840000000E+04, 2.7585533632E+01, 4.9947139658E+00, 1.0335549250E+01, 3.0010564144E+00, 9.5215739456E-01],
	[3.7845000000E+04, 2.7591797973E+01, 4.9947367885E+00, 1.0339969077E+01, 3.0015113254E+00, 9.5217698464E-01],
	[3.7850000000E+04, 2.7598062909E+01, 4.9947596083E+00, 1.0344390209E+01, 3.0019661380E+00, 9.5219656574E-01],
	[3.7855000000E+04, 2.7604328440E+01, 4.9947824252E+00, 1.0348812646E+01, 3.0024208522E+00, 9.5221613786E-01],
	[3.7860000000E+04, 2.7610594565E+01, 4.9948052392E+00, 1.0353236388E+01, 3.0028754680E+00, 9.5223570102E-01],
	[3.7865000000E+04, 2.7616861285E+01, 4.9948280503E+00, 1.0357661436E+01, 3.0033299854E+00, 9.5225525522E-01],
	[3.7870000000E+04, 2.7623128600E+01, 4.9948508584E+00, 1.0362087790E+01, 3.0037844044E+00, 9.5227480045E-01],
	[3.7875000000E+04, 2.7629396509E+01, 4.9948736637E+00, 1.0366515450E+01, 3.0042387250E+00, 9.5229433674E-01],
	[3.7880000000E+04, 2.7635665012E+01, 4.9948964661E+00, 1.0370944416E+01, 3.0046929472E+00, 9.5231386407E-01],
	[3.7885000000E+04, 2.7641934111E+01, 4.9949192655E+00, 1.0375374689E+01, 3.0051470711E+00, 9.5233338245E-01],
	[3.7890000000E+04, 2.7648203804E+01, 4.9949420621E+00, 1.0379806268E+01, 3.0056010966E+00, 9.5235289190E-01],
	[3.7895000000E+04, 2.7654474091E+01, 4.9949648557E+00, 1.0384239154E+01, 3.0060550237E+00, 9.5237239240E-01],
	[3.7900000000E+04, 2.7660744973E+01, 4.9949876465E+00, 1.0388673347E+01, 3.0065088525E+00, 9.5239188398E-01],
	[3.7905000000E+04, 2.7667016449E+01, 4.9950104343E+00, 1.0393108848E+01, 3.0069625829E+00, 9.5241136663E-01],
	[3.7910000000E+04, 2.7673288520E+01, 4.9950332193E+00, 1.0397545655E+01, 3.0074162149E+00, 9.5243084035E-01],
	[3.7915000000E+04, 2.7679561185E+01, 4.9950560013E+00, 1.0401983771E+01, 3.0078697487E+00, 9.5245030516E-01],
	[3.7920000000E+04, 2.7685834444E+01, 4.9950787804E+00, 1.0406423195E+01, 3.0083231840E+00, 9.5246976105E-01],
	[3.7925000000E+04, 2.7692108298E+01, 4.9951015567E+00, 1.0410863927E+01, 3.0087765211E+00, 9.5248920804E-01],
	[3.7930000000E+04, 2.7698382746E+01, 4.9951243300E+00, 1.0415305967E+01, 3.0092297598E+00, 9.5250864612E-01],
	[3.7935000000E+04, 2.7704657789E+01, 4.9951471004E+00, 1.0419749315E+01, 3.0096829002E+00, 9.5252807530E-01],
	[3.7940000000E+04, 2.7710933425E+01, 4.9951698680E+00, 1.0424193973E+01, 3.0101359423E+00, 9.5254749558E-01],
	[3.7945000000E+04, 2.7717209657E+01, 4.9951926326E+00, 1.0428639939E+01, 3.0105888861E+00, 9.5256690697E-01],
	[3.7950000000E+04, 2.7723486482E+01, 4.9952153944E+00, 1.0433087215E+01, 3.0110417316E+00, 9.5258630948E-01],
	[3.7955000000E+04, 2.7729763901E+01, 4.9952381532E+00, 1.0437535800E+01, 3.0114944788E+00, 9.5260570310E-01],
	[3.7960000000E+04, 2.7736041915E+01, 4.9952609092E+00, 1.0441985695E+01, 3.0119471277E+00, 9.5262508785E-01],
	[3.7965000000E+04, 2.7742320523E+01, 4.9952836623E+00, 1.0446436900E+01, 3.0123996784E+00, 9.5264446372E-01],
	[3.7970000000E+04, 2.7748599725E+01, 4.9953064125E+00, 1.0450889414E+01, 3.0128521307E+00, 9.5266383072E-01],
	[3.7975000000E+04, 2.7754879522E+01, 4.9953291597E+00, 1.0455343239E+01, 3.0133044848E+00, 9.5268318886E-01],
	[3.7980000000E+04, 2.7761159912E+01, 4.9953519041E+00, 1.0459798375E+01, 3.0137567406E+00, 9.5270253814E-01],
	[3.7985000000E+04, 2.7767440897E+01, 4.9953746456E+00, 1.0464254821E+01, 3.0142088982E+00, 9.5272187857E-01],
	[3.7990000000E+04, 2.7773722475E+01, 4.9953973842E+00, 1.0468712578E+01, 3.0146609575E+00, 9.5274121014E-01],
	[3.7995000000E+04, 2.7780004648E+01, 4.9954201200E+00, 1.0473171646E+01, 3.0151129185E+00, 9.5276053287E-01],
	[3.8000000000E+04, 2.7786287415E+01, 4.9954428528E+00, 1.0477632026E+01, 3.0155647814E+00, 9.5277984676E-01],
	[3.8005000000E+04, 2.7792576402E+01, 4.9954663713E+00, 1.0482093717E+01, 3.0160168997E+00, 9.5279915181E-01],
	[3.8010000000E+04, 2.7798876720E+01, 4.9954913907E+00, 1.0486556719E+01, 3.0164695946E+00, 9.5281844803E-01],
	[3.8015000000E+04, 2.7805177637E+01, 4.9955164070E+00, 1.0491021034E+01, 3.0169221917E+00, 9.5283773542E-01],
	[3.8020000000E+04, 2.7811479154E+01, 4.9955414201E+00, 1.0495486661E+01, 3.0173746910E+00, 9.5285701398E-01],
	[3.8025000000E+04, 2.7817781269E+01, 4.9955664300E+00, 1.0499953601E+01, 3.0178270924E+00, 9.5287628373E-01],
	[3.8030000000E+04, 2.7824083984E+01, 4.9955914367E+00, 1.0504421853E+01, 3.0182793960E+00, 9.5289554466E-01],
	[3.8035000000E+04, 2.7830387298E+01, 4.9956164403E+00, 1.0508891417E+01, 3.0187316019E+00, 9.5291479679E-01],
	[3.8040000000E+04, 2.7836691210E+01, 4.9956414408E+00, 1.0513362295E+01, 3.0191837099E+00, 9.5293404010E-01],
	[3.8045000000E+04, 2.7842995722E+01, 4.9956664380E+00, 1.0517834486E+01, 3.0196357201E+00, 9.5295327462E-01],
	[3.8050000000E+04, 2.7849300833E+01, 4.9956914321E+00, 1.0522307991E+01, 3.0200876325E+00, 9.5297250034E-01],
	[3.8055000000E+04, 2.7855606543E+01, 4.9957164231E+00, 1.0526782809E+01, 3.0205394471E+00, 9.5299171727E-01],
	[3.8060000000E+04, 2.7861912853E+01, 4.9957414109E+00, 1.0531258941E+01, 3.0209911640E+00, 9.5301092541E-01],
	[3.8065000000E+04, 2.7868219761E+01, 4.9957663955E+00, 1.0535736387E+01, 3.0214427830E+00, 9.5303012477E-01],
	[3.8070000000E+04, 2.7874527268E+01, 4.9957913770E+00, 1.0540215148E+01, 3.0218943043E+00, 9.5304931534E-01],
	[3.8075000000E+04, 2.7880835374E+01, 4.9958163553E+00, 1.0544695223E+01, 3.0223457279E+00, 9.5306849715E-01],
	[3.8080000000E+04, 2.7887144079E+01, 4.9958413305E+00, 1.0549176613E+01, 3.0227970536E+00, 9.5308767018E-01],
	[3.8085000000E+04, 2.7893453383E+01, 4.9958663025E+00, 1.0553659318E+01, 3.0232482817E+00, 9.5310683445E-01],
	[3.8090000000E+04, 2.7899763286E+01, 4.9958912714E+00, 1.0558143338E+01, 3.0236994119E+00, 9.5312598996E-01],
	[3.8095000000E+04, 2.7906073787E+01, 4.9959162371E+00, 1.0562628673E+01, 3.0241504445E+00, 9.5314513672E-01],
	[3.8100000000E+04, 2.7912384888E+01, 4.9959411996E+00, 1.0567115324E+01, 3.0246013793E+00, 9.5316427471E-01],
	[3.8105000000E+04, 2.7918696587E+01, 4.9959661590E+00, 1.0571603290E+01, 3.0250522164E+00, 9.5318340396E-01],
	[3.8110000000E+04, 2.7925008886E+01, 4.9959911153E+00, 1.0576092573E+01, 3.0255029558E+00, 9.5320252447E-01],
	[3.8115000000E+04, 2.7931321783E+01, 4.9960160684E+00, 1.0580583172E+01, 3.0259535974E+00, 9.5322163623E-01],
	[3.8120000000E+04, 2.7937635278E+01, 4.9960410183E+00, 1.0585075087E+01, 3.0264041414E+00, 9.5324073925E-01],
	[3.8125000000E+04, 2.7943949373E+01, 4.9960659652E+00, 1.0589568320E+01, 3.0268545876E+00, 9.5325983354E-01],
	[3.8130000000E+04, 2.7950264066E+01, 4.9960909088E+00, 1.0594062868E+01, 3.0273049361E+00, 9.5327891910E-01],
	[3.8135000000E+04, 2.7956579358E+01, 4.9961158493E+00, 1.0598558734E+01, 3.0277551870E+00, 9.5329799593E-01],
	[3.8140000000E+04, 2.7962895249E+01, 4.9961407867E+00, 1.0603055918E+01, 3.0282053402E+00, 9.5331706404E-01],
	[3.8145000000E+04, 2.7969211738E+01, 4.9961657209E+00, 1.0607554418E+01, 3.0286553957E+00, 9.5333612343E-01],
	[3.8150000000E+04, 2.7975528826E+01, 4.9961906520E+00, 1.0612054237E+01, 3.0291053535E+00, 9.5335517411E-01],
	[3.8155000000E+04, 2.7981846512E+01, 4.9962155799E+00, 1.0616555373E+01, 3.0295552137E+00, 9.5337421608E-01],
	[3.8160000000E+04, 2.7988164797E+01, 4.9962405047E+00, 1.0621057828E+01, 3.0300049762E+00, 9.5339324934E-01],
	[3.8165000000E+04, 2.7994483681E+01, 4.9962654264E+00, 1.0625561601E+01, 3.0304546411E+00, 9.5341227391E-01],
	[3.8170000000E+04, 2.8000803163E+01, 4.9962903449E+00, 1.0630066692E+01, 3.0309042083E+00, 9.5343128977E-01],
	[3.8175000000E+04, 2.8007123244E+01, 4.9963152603E+00, 1.0634573103E+01, 3.0313536779E+00, 9.5345029694E-01],
	[3.8180000000E+04, 2.8013443923E+01, 4.9963401725E+00, 1.0639080832E+01, 3.0318030498E+00, 9.5346929542E-01],
	[3.8185000000E+04, 2.8019765201E+01, 4.9963650816E+00, 1.0643589881E+01, 3.0322523242E+00, 9.5348828521E-01],
	[3.8190000000E+04, 2.8026087077E+01, 4.9963899876E+00, 1.0648100248E+01, 3.0327015009E+00, 9.5350726632E-01],
	[3.8195000000E+04, 2.8032409552E+01, 4.9964148904E+00, 1.0652611936E+01, 3.0331505800E+00, 9.5352623875E-01],
	[3.8200000000E+04, 2.8038732625E+01, 4.9964397901E+00, 1.0657124943E+01, 3.0335995615E+00, 9.5354520251E-01],
	[3.8205000000E+04, 2.8045056296E+01, 4.9964646867E+00, 1.0661639271E+01, 3.0340484454E+00, 9.5356415760E-01],
	[3.8210000000E+04, 2.8051380566E+01, 4.9964895801E+00, 1.0666154919E+01, 3.0344972317E+00, 9.5358310403E-01],
	[3.8215000000E+04, 2.8057705435E+01, 4.9965144704E+00, 1.0670671887E+01, 3.0349459205E+00, 9.5360204179E-01],
	[3.8220000000E+04, 2.8064030901E+01, 4.9965393575E+00, 1.0675190176E+01, 3.0353945116E+00, 9.5362097089E-01],
	[3.8225000000E+04, 2.8070356966E+01, 4.9965642415E+00, 1.0679709786E+01, 3.0358430052E+00, 9.5363989134E-01],
	[3.8230000000E+04, 2.8076683629E+01, 4.9965891224E+00, 1.0684230717E+01, 3.0362914012E+00, 9.5365880314E-01],
	[3.8235000000E+04, 2.8083010890E+01, 4.9966140002E+00, 1.0688752969E+01, 3.0367396997E+00, 9.5367770629E-01],
	[3.8240000000E+04, 2.8089338750E+01, 4.9966388748E+00, 1.0693276543E+01, 3.0371879006E+00, 9.5369660081E-01],
	[3.8245000000E+04, 2.8095667208E+01, 4.9966637463E+00, 1.0697801438E+01, 3.0376360040E+00, 9.5371548668E-01],
	[3.8250000000E+04, 2.8101996264E+01, 4.9966886147E+00, 1.0702327656E+01, 3.0380840098E+00, 9.5373436392E-01],
	[3.8255000000E+04, 2.8108325918E+01, 4.9967134800E+00, 1.0706855196E+01, 3.0385319181E+00, 9.5375323253E-01],
	[3.8260000000E+04, 2.8114656171E+01, 4.9967383421E+00, 1.0711384058E+01, 3.0389797289E+00, 9.5377209251E-01],
	[3.8265000000E+04, 2.8120987021E+01, 4.9967632011E+00, 1.0715914243E+01, 3.0394274421E+00, 9.5379094387E-01],
	[3.8270000000E+04, 2.8127318470E+01, 4.9967880570E+00, 1.0720445750E+01, 3.0398750579E+00, 9.5380978662E-01],
	[3.8275000000E+04, 2.8133650517E+01, 4.9968129097E+00, 1.0724978581E+01, 3.0403225761E+00, 9.5382862075E-01],
	[3.8280000000E+04, 2.8139983162E+01, 4.9968377593E+00, 1.0729512735E+01, 3.0407699969E+00, 9.5384744627E-01],
	[3.8285000000E+04, 2.8146316405E+01, 4.9968626058E+00, 1.0734048212E+01, 3.0412173201E+00, 9.5386626318E-01],
	[3.8290000000E+04, 2.8152650245E+01, 4.9968874492E+00, 1.0738585013E+01, 3.0416645459E+00, 9.5388507149E-01],
	[3.8295000000E+04, 2.8158984684E+01, 4.9969122895E+00, 1.0743123138E+01, 3.0421116742E+00, 9.5390387121E-01],
	[3.8300000000E+04, 2.8165319721E+01, 4.9969371266E+00, 1.0747662587E+01, 3.0425587051E+00, 9.5392266233E-01],
	[3.8305000000E+04, 2.8171655356E+01, 4.9969619607E+00, 1.0752203361E+01, 3.0430056384E+00, 9.5394144486E-01],
	[3.8310000000E+04, 2.8177991589E+01, 4.9969867916E+00, 1.0756745459E+01, 3.0434524744E+00, 9.5396021880E-01],
	[3.8315000000E+04, 2.8184328420E+01, 4.9970116194E+00, 1.0761288881E+01, 3.0438992128E+00, 9.5397898416E-01],
	[3.8320000000E+04, 2.8190665848E+01, 4.9970364440E+00, 1.0765833629E+01, 3.0443458539E+00, 9.5399774094E-01],
	[3.8325000000E+04, 2.8197003875E+01, 4.9970612656E+00, 1.0770379702E+01, 3.0447923975E+00, 9.5401648915E-01],
	[3.8330000000E+04, 2.8203342499E+01, 4.9970860840E+00, 1.0774927100E+01, 3.0452388436E+00, 9.5403522879E-01],
	[3.8335000000E+04, 2.8209681721E+01, 4.9971108994E+00, 1.0779475824E+01, 3.0456851924E+00, 9.5405395986E-01],
	[3.8340000000E+04, 2.8216021542E+01, 4.9971357116E+00, 1.0784025873E+01, 3.0461314437E+00, 9.5407268238E-01],
	[3.8345000000E+04, 2.8222361959E+01, 4.9971605207E+00, 1.0788577249E+01, 3.0465775977E+00, 9.5409139633E-01],
	[3.8350000000E+04, 2.8228702975E+01, 4.9971853267E+00, 1.0793129951E+01, 3.0470236542E+00, 9.5411010173E-01],
	[3.8355000000E+04, 2.8235044588E+01, 4.9972101296E+00, 1.0797683979E+01, 3.0474696133E+00, 9.5412879858E-01],
	[3.8360000000E+04, 2.8241386799E+01, 4.9972349293E+00, 1.0802239334E+01, 3.0479154751E+00, 9.5414748688E-01],
	[3.8365000000E+04, 2.8247729608E+01, 4.9972597260E+00, 1.0806796016E+01, 3.0483612395E+00, 9.5416616664E-01],
	[3.8370000000E+04, 2.8254073015E+01, 4.9972845195E+00, 1.0811354025E+01, 3.0488069065E+00, 9.5418483786E-01],
	[3.8375000000E+04, 2.8260417019E+01, 4.9973093100E+00, 1.0815913361E+01, 3.0492524762E+00, 9.5420350055E-01],
	[3.8380000000E+04, 2.8266761620E+01, 4.9973340973E+00, 1.0820474025E+01, 3.0496979485E+00, 9.5422215470E-01],
	[3.8385000000E+04, 2.8273106820E+01, 4.9973588816E+00, 1.0825036016E+01, 3.0501433234E+00, 9.5424080033E-01],
	[3.8390000000E+04, 2.8279452617E+01, 4.9973836627E+00, 1.0829599336E+01, 3.0505886010E+00, 9.5425943744E-01],
	[3.8395000000E+04, 2.8285799011E+01, 4.9974084407E+00, 1.0834163983E+01, 3.0510337813E+00, 9.5427806603E-01],
	[3.8400000000E+04, 2.8292146003E+01, 4.9974332156E+00, 1.0838729959E+01, 3.0514788642E+00, 9.5429668611E-01],
	[3.8405000000E+04, 2.8298493593E+01, 4.9974579875E+00, 1.0843297264E+01, 3.0519238499E+00, 9.5431529768E-01],
	[3.8410000000E+04, 2.8304841780E+01, 4.9974827562E+00, 1.0847865897E+01, 3.0523687382E+00, 9.5433390074E-01],
	[3.8415000000E+04, 2.8311190565E+01, 4.9975075218E+00, 1.0852435860E+01, 3.0528135292E+00, 9.5435249529E-01],
	[3.8420000000E+04, 2.8317539947E+01, 4.9975322843E+00, 1.0857007151E+01, 3.0532582229E+00, 9.5437108135E-01],
	[3.8425000000E+04, 2.8323889927E+01, 4.9975570437E+00, 1.0861579772E+01, 3.0537028193E+00, 9.5438965891E-01],
	[3.8430000000E+04, 2.8330240503E+01, 4.9975818000E+00, 1.0866153723E+01, 3.0541473185E+00, 9.5440822799E-01],
	[3.8435000000E+04, 2.8336591678E+01, 4.9976065532E+00, 1.0870729003E+01, 3.0545917203E+00, 9.5442678858E-01],
	[3.8440000000E+04, 2.8342943450E+01, 4.9976313034E+00, 1.0875305614E+01, 3.0550360249E+00, 9.5444534068E-01],
	[3.8445000000E+04, 2.8349295819E+01, 4.9976560504E+00, 1.0879883555E+01, 3.0554802323E+00, 9.5446388431E-01],
	[3.8450000000E+04, 2.8355648785E+01, 4.9976807943E+00, 1.0884462826E+01, 3.0559243424E+00, 9.5448241946E-01],
	[3.8455000000E+04, 2.8362002349E+01, 4.9977055351E+00, 1.0889043428E+01, 3.0563683552E+00, 9.5450094614E-01],
	[3.8460000000E+04, 2.8368356510E+01, 4.9977302729E+00, 1.0893625361E+01, 3.0568122708E+00, 9.5451946435E-01],
	[3.8465000000E+04, 2.8374711268E+01, 4.9977550075E+00, 1.0898208625E+01, 3.0572560892E+00, 9.5453797411E-01],
	[3.8470000000E+04, 2.8381066624E+01, 4.9977797391E+00, 1.0902793221E+01, 3.0576998103E+00, 9.5455647540E-01],
	[3.8475000000E+04, 2.8387422577E+01, 4.9978044675E+00, 1.0907379148E+01, 3.0581434342E+00, 9.5457496824E-01],
	[3.8480000000E+04, 2.8393779127E+01, 4.9978291929E+00, 1.0911966407E+01, 3.0585869610E+00, 9.5459345262E-01],
	[3.8485000000E+04, 2.8400136274E+01, 4.9978539152E+00, 1.0916554998E+01, 3.0590303905E+00, 9.5461192857E-01],
	[3.8490000000E+04, 2.8406494019E+01, 4.9978786344E+00, 1.0921144921E+01, 3.0594737228E+00, 9.5463039606E-01],
	[3.8495000000E+04, 2.8412852360E+01, 4.9979033505E+00, 1.0925736176E+01, 3.0599169580E+00, 9.5464885512E-01],
	[3.8500000000E+04, 2.8419211299E+01, 4.9979280635E+00, 1.0930328764E+01, 3.0603600959E+00, 9.5466730575E-01],
	[3.8505000000E+04, 2.8425570835E+01, 4.9979527734E+00, 1.0934922685E+01, 3.0608031367E+00, 9.5468574794E-01],
	[3.8510000000E+04, 2.8431930967E+01, 4.9979774802E+00, 1.0939517939E+01, 3.0612460803E+00, 9.5470418171E-01],
	[3.8515000000E+04, 2.8438291697E+01, 4.9980021840E+00, 1.0944114527E+01, 3.0616889268E+00, 9.5472260705E-01],
	[3.8520000000E+04, 2.8444653024E+01, 4.9980268847E+00, 1.0948712447E+01, 3.0621316762E+00, 9.5474102398E-01],
	[3.8525000000E+04, 2.8451014948E+01, 4.9980515822E+00, 1.0953311702E+01, 3.0625743283E+00, 9.5475943249E-01],
	[3.8530000000E+04, 2.8457377469E+01, 4.9980762768E+00, 1.0957912290E+01, 3.0630168834E+00, 9.5477783259E-01],
	[3.8535000000E+04, 2.8463740587E+01, 4.9981009682E+00, 1.0962514213E+01, 3.0634593413E+00, 9.5479622428E-01],
	[3.8540000000E+04, 2.8470104302E+01, 4.9981256565E+00, 1.0967117470E+01, 3.0639017021E+00, 9.5481460757E-01],
	[3.8545000000E+04, 2.8476468614E+01, 4.9981503418E+00, 1.0971722061E+01, 3.0643439659E+00, 9.5483298246E-01],
	[3.8550000000E+04, 2.8482833523E+01, 4.9981750239E+00, 1.0976327987E+01, 3.0647861325E+00, 9.5485134895E-01],
	[3.8555000000E+04, 2.8489199028E+01, 4.9981997030E+00, 1.0980935248E+01, 3.0652282020E+00, 9.5486970706E-01],
	[3.8560000000E+04, 2.8495565131E+01, 4.9982243791E+00, 1.0985543845E+01, 3.0656701744E+00, 9.5488805677E-01],
	[3.8565000000E+04, 2.8501931830E+01, 4.9982490520E+00, 1.0990153777E+01, 3.0661120497E+00, 9.5490639810E-01],
	[3.8570000000E+04, 2.8508299126E+01, 4.9982737219E+00, 1.0994765044E+01, 3.0665538280E+00, 9.5492473106E-01],
	[3.8575000000E+04, 2.8514667019E+01, 4.9982983887E+00, 1.0999377647E+01, 3.0669955092E+00, 9.5494305564E-01],
	[3.8580000000E+04, 2.8521035509E+01, 4.9983230524E+00, 1.1003991586E+01, 3.0674370934E+00, 9.5496137184E-01],
	[3.8585000000E+04, 2.8527404595E+01, 4.9983477130E+00, 1.1008606862E+01, 3.0678785805E+00, 9.5497967968E-01],
	[3.8590000000E+04, 2.8533774279E+01, 4.9983723706E+00, 1.1013223474E+01, 3.0683199706E+00, 9.5499797916E-01],
	[3.8595000000E+04, 2.8540144559E+01, 4.9983970251E+00, 1.1017841423E+01, 3.0687612636E+00, 9.5501627027E-01],
	[3.8600000000E+04, 2.8546515435E+01, 4.9984216765E+00, 1.1022460708E+01, 3.0692024596E+00, 9.5503455303E-01],
	[3.8605000000E+04, 2.8552886908E+01, 4.9984463248E+00, 1.1027081331E+01, 3.0696435586E+00, 9.5505282744E-01],
	[3.8610000000E+04, 2.8559258978E+01, 4.9984709701E+00, 1.1031703291E+01, 3.0700845606E+00, 9.5507109351E-01],
	[3.8615000000E+04, 2.8565631645E+01, 4.9984956123E+00, 1.1036326588E+01, 3.0705254656E+00, 9.5508935122E-01],
	[3.8620000000E+04, 2.8572020825E+01, 4.9985224577E+00, 1.1040951224E+01, 3.0709672903E+00, 9.5510760060E-01],
	[3.8625000000E+04, 2.8578410870E+01, 4.9985493362E+00, 1.1045577197E+01, 3.0714090351E+00, 9.5512584164E-01],
	[3.8630000000E+04, 2.8584801516E+01, 4.9985762114E+00, 1.1050204509E+01, 3.0718506833E+00, 9.5514407435E-01],
	[3.8635000000E+04, 2.8591192764E+01, 4.9986030833E+00, 1.1054833158E+01, 3.0722922349E+00, 9.5516229874E-01],
	[3.8640000000E+04, 2.8597584613E+01, 4.9986299518E+00, 1.1059463147E+01, 3.0727336900E+00, 9.5518051479E-01],
	[3.8645000000E+04, 2.8603977064E+01, 4.9986568170E+00, 1.1064094474E+01, 3.0731750484E+00, 9.5519872253E-01],
	[3.8650000000E+04, 2.8610370117E+01, 4.9986836788E+00, 1.1068727141E+01, 3.0736163103E+00, 9.5521692195E-01],
	[3.8655000000E+04, 2.8616763772E+01, 4.9987105373E+00, 1.1073361146E+01, 3.0740574756E+00, 9.5523511307E-01],
	[3.8660000000E+04, 2.8623158028E+01, 4.9987373925E+00, 1.1077996491E+01, 3.0744985443E+00, 9.5525329587E-01],
	[3.8665000000E+04, 2.8629552885E+01, 4.9987642444E+00, 1.1082633176E+01, 3.0749395165E+00, 9.5527147037E-01],
	[3.8670000000E+04, 2.8635948344E+01, 4.9987910929E+00, 1.1087271201E+01, 3.0753803921E+00, 9.5528963656E-01],
	[3.8675000000E+04, 2.8642344405E+01, 4.9988179381E+00, 1.1091910565E+01, 3.0758211712E+00, 9.5530779446E-01],
	[3.8680000000E+04, 2.8648741067E+01, 4.9988447800E+00, 1.1096551270E+01, 3.0762618538E+00, 9.5532594407E-01],
	[3.8685000000E+04, 2.8655138330E+01, 4.9988716185E+00, 1.1101193316E+01, 3.0767024398E+00, 9.5534408539E-01],
	[3.8690000000E+04, 2.8661536195E+01, 4.9988984538E+00, 1.1105836702E+01, 3.0771429293E+00, 9.5536221843E-01],
	[3.8695000000E+04, 2.8667934662E+01, 4.9989252857E+00, 1.1110481429E+01, 3.0775833224E+00, 9.5538034319E-01],
	[3.8700000000E+04, 2.8674333729E+01, 4.9989521142E+00, 1.1115127498E+01, 3.0780236189E+00, 9.5539845966E-01],
	[3.8705000000E+04, 2.8680733398E+01, 4.9989789395E+00, 1.1119774908E+01, 3.0784638190E+00, 9.5541656787E-01],
	[3.8710000000E+04, 2.8687133669E+01, 4.9990057614E+00, 1.1124423659E+01, 3.0789039225E+00, 9.5543466781E-01],
	[3.8715000000E+04, 2.8693534541E+01, 4.9990325801E+00, 1.1129073752E+01, 3.0793439296E+00, 9.5545275948E-01],
	[3.8720000000E+04, 2.8699936014E+01, 4.9990593954E+00, 1.1133725187E+01, 3.0797838402E+00, 9.5547084289E-01],
	[3.8725000000E+04, 2.8706338088E+01, 4.9990862073E+00, 1.1138377965E+01, 3.0802236544E+00, 9.5548891805E-01],
	[3.8730000000E+04, 2.8712740764E+01, 4.9991130160E+00, 1.1143032085E+01, 3.0806633721E+00, 9.5550698495E-01],
	[3.8735000000E+04, 2.8719144041E+01, 4.9991398213E+00, 1.1147687548E+01, 3.0811029934E+00, 9.5552504360E-01],
	[3.8740000000E+04, 2.8725547919E+01, 4.9991666234E+00, 1.1152344353E+01, 3.0815425183E+00, 9.5554309401E-01],
	[3.8745000000E+04, 2.8731952399E+01, 4.9991934221E+00, 1.1157002502E+01, 3.0819819467E+00, 9.5556113618E-01],
	[3.8750000000E+04, 2.8738357479E+01, 4.9992202175E+00, 1.1161661993E+01, 3.0824212787E+00, 9.5557917011E-01],
	[3.8755000000E+04, 2.8744763161E+01, 4.9992470096E+00, 1.1166322829E+01, 3.0828605143E+00, 9.5559719581E-01],
	[3.8760000000E+04, 2.8751169444E+01, 4.9992737983E+00, 1.1170985008E+01, 3.0832996535E+00, 9.5561521327E-01],
	[3.8765000000E+04, 2.8757576328E+01, 4.9993005838E+00, 1.1175648531E+01, 3.0837386963E+00, 9.5563322251E-01],
	[3.8770000000E+04, 2.8763983814E+01, 4.9993273660E+00, 1.1180313398E+01, 3.0841776427E+00, 9.5565122353E-01],
	[3.8775000000E+04, 2.8770391900E+01, 4.9993541448E+00, 1.1184979610E+01, 3.0846164928E+00, 9.5566921634E-01],
	[3.8780000000E+04, 2.8776800587E+01, 4.9993809203E+00, 1.1189647166E+01, 3.0850552465E+00, 9.5568720093E-01],
	[3.8785000000E+04, 2.8783209875E+01, 4.9994076925E+00, 1.1194316067E+01, 3.0854939038E+00, 9.5570517731E-01],
	[3.8790000000E+04, 2.8789619765E+01, 4.9994344615E+00, 1.1198986313E+01, 3.0859324648E+00, 9.5572314548E-01],
	[3.8795000000E+04, 2.8796030255E+01, 4.9994612271E+00, 1.1203657904E+01, 3.0863709294E+00, 9.5574110545E-01],
	[3.8800000000E+04, 2.8802441347E+01, 4.9994879894E+00, 1.1208330841E+01, 3.0868092977E+00, 9.5575905723E-01],
	[3.8805000000E+04, 2.8808853039E+01, 4.9995147484E+00, 1.1213005123E+01, 3.0872475697E+00, 9.5577700080E-01],
	[3.8810000000E+04, 2.8815265332E+01, 4.9995415040E+00, 1.1217680752E+01, 3.0876857454E+00, 9.5579493619E-01],
	[3.8815000000E+04, 2.8821678226E+01, 4.9995682564E+00, 1.1222357726E+01, 3.0881238247E+00, 9.5581286340E-01],
	[3.8820000000E+04, 2.8828091722E+01, 4.9995950055E+00, 1.1227036047E+01, 3.0885618078E+00, 9.5583078242E-01],
	[3.8825000000E+04, 2.8834505818E+01, 4.9996217513E+00, 1.1231715714E+01, 3.0889996946E+00, 9.5584869326E-01],
	[3.8830000000E+04, 2.8840920514E+01, 4.9996484938E+00, 1.1236396727E+01, 3.0894374850E+00, 9.5586659593E-01],
	[3.8835000000E+04, 2.8847335812E+01, 4.9996752330E+00, 1.1241079088E+01, 3.0898751793E+00, 9.5588449043E-01],
	[3.8840000000E+04, 2.8853751710E+01, 4.9997019688E+00, 1.1245762796E+01, 3.0903127772E+00, 9.5590237676E-01],
	[3.8845000000E+04, 2.8860168210E+01, 4.9997287014E+00, 1.1250447851E+01, 3.0907502789E+00, 9.5592025493E-01],
	[3.8850000000E+04, 2.8866585310E+01, 4.9997554307E+00, 1.1255134254E+01, 3.0911876843E+00, 9.5593812494E-01],
	[3.8855000000E+04, 2.8873003010E+01, 4.9997821567E+00, 1.1259822005E+01, 3.0916249935E+00, 9.5595598680E-01],
	[3.8860000000E+04, 2.8879421312E+01, 4.9998088794E+00, 1.1264511104E+01, 3.0920622065E+00, 9.5597384050E-01],
	[3.8865000000E+04, 2.8885840214E+01, 4.9998355988E+00, 1.1269201551E+01, 3.0924993232E+00, 9.5599168606E-01],
	[3.8870000000E+04, 2.8892259717E+01, 4.9998623149E+00, 1.1273893346E+01, 3.0929363437E+00, 9.5600952348E-01],
	[3.8875000000E+04, 2.8898679821E+01, 4.9998890277E+00, 1.1278586490E+01, 3.0933732681E+00, 9.5602735275E-01],
	[3.8880000000E+04, 2.8905100525E+01, 4.9999157372E+00, 1.1283280983E+01, 3.0938100962E+00, 9.5604517390E-01],
	[3.8885000000E+04, 2.8911521830E+01, 4.9999424434E+00, 1.1287976825E+01, 3.0942468281E+00, 9.5606298691E-01],
	[3.8890000000E+04, 2.8917943735E+01, 4.9999691463E+00, 1.1292674016E+01, 3.0946834639E+00, 9.5608079179E-01],
	[3.8895000000E+04, 2.8924366241E+01, 4.9999958460E+00, 1.1297372556E+01, 3.0951200034E+00, 9.5609858855E-01],
	[3.8900000000E+04, 2.8930789348E+01, 5.0000225423E+00, 1.1302072447E+01, 3.0955564469E+00, 9.5611637719E-01],
	[3.8905000000E+04, 2.8937213055E+01, 5.0000492354E+00, 1.1306773687E+01, 3.0959927941E+00, 9.5613415771E-01],
	[3.8910000000E+04, 2.8943637362E+01, 5.0000759252E+00, 1.1311476278E+01, 3.0964290452E+00, 9.5615193012E-01],
	[3.8915000000E+04, 2.8950062270E+01, 5.0001026117E+00, 1.1316180219E+01, 3.0968652002E+00, 9.5616969443E-01],
	[3.8920000000E+04, 2.8956487779E+01, 5.0001292949E+00, 1.1320885510E+01, 3.0973012591E+00, 9.5618745063E-01],
	[3.8925000000E+04, 2.8962913888E+01, 5.0001559748E+00, 1.1325592152E+01, 3.0977372218E+00, 9.5620519873E-01],
	[3.8930000000E+04, 2.8969340597E+01, 5.0001826514E+00, 1.1330300145E+01, 3.0981730884E+00, 9.5622293873E-01],
	[3.8935000000E+04, 2.8975767907E+01, 5.0002093248E+00, 1.1335009490E+01, 3.0986088589E+00, 9.5624067064E-01],
	[3.8940000000E+04, 2.8982195817E+01, 5.0002359948E+00, 1.1339720186E+01, 3.0990445333E+00, 9.5625839447E-01],
	[3.8945000000E+04, 2.8988624328E+01, 5.0002626616E+00, 1.1344432233E+01, 3.0994801117E+00, 9.5627611021E-01],
	[3.8950000000E+04, 2.8995053439E+01, 5.0002893251E+00, 1.1349145633E+01, 3.0999155939E+00, 9.5629381787E-01],
	[3.8955000000E+04, 2.9001483150E+01, 5.0003159853E+00, 1.1353860384E+01, 3.1003509801E+00, 9.5631151745E-01],
	[3.8960000000E+04, 2.9007913462E+01, 5.0003426423E+00, 1.1358576488E+01, 3.1007862702E+00, 9.5632920896E-01],
	[3.8965000000E+04, 2.9014344374E+01, 5.0003692959E+00, 1.1363293944E+01, 3.1012214643E+00, 9.5634689240E-01],
	[3.8970000000E+04, 2.9020775886E+01, 5.0003959463E+00, 1.1368012753E+01, 3.1016565624E+00, 9.5636456778E-01],
	[3.8975000000E+04, 2.9027207998E+01, 5.0004225934E+00, 1.1372732915E+01, 3.1020915644E+00, 9.5638223509E-01],
	[3.8980000000E+04, 2.9033640711E+01, 5.0004492373E+00, 1.1377454430E+01, 3.1025264704E+00, 9.5639989435E-01],
	[3.8985000000E+04, 2.9040074024E+01, 5.0004758778E+00, 1.1382177298E+01, 3.1029612803E+00, 9.5641754555E-01],
	[3.8990000000E+04, 2.9046507937E+01, 5.0005025151E+00, 1.1386901520E+01, 3.1033959943E+00, 9.5643518871E-01],
	[3.8995000000E+04, 2.9052942450E+01, 5.0005291491E+00, 1.1391627095E+01, 3.1038306123E+00, 9.5645282382E-01],
	[3.9000000000E+04, 2.9059377563E+01, 5.0005557799E+00, 1.1396354025E+01, 3.1042651342E+00, 9.5647045089E-01],
	[3.9005000000E+04, 2.9065813277E+01, 5.0005824073E+00, 1.1401082309E+01, 3.1046995602E+00, 9.5648806992E-01],
	[3.9010000000E+04, 2.9072249590E+01, 5.0006090315E+00, 1.1405811947E+01, 3.1051338903E+00, 9.5650568092E-01],
	[3.9015000000E+04, 2.9078686504E+01, 5.0006356524E+00, 1.1410542940E+01, 3.1055681243E+00, 9.5652328389E-01],
	[3.9020000000E+04, 2.9085124017E+01, 5.0006622701E+00, 1.1415275288E+01, 3.1060022625E+00, 9.5654087883E-01],
	[3.9025000000E+04, 2.9091562131E+01, 5.0006888845E+00, 1.1420008991E+01, 3.1064363046E+00, 9.5655846575E-01],
	[3.9030000000E+04, 2.9098000845E+01, 5.0007154956E+00, 1.1424744049E+01, 3.1068702509E+00, 9.5657604465E-01],
	[3.9035000000E+04, 2.9104440158E+01, 5.0007421034E+00, 1.1429480463E+01, 3.1073041012E+00, 9.5659361554E-01],
	[3.9040000000E+04, 2.9110880072E+01, 5.0007687080E+00, 1.1434218232E+01, 3.1077378556E+00, 9.5661117841E-01],
	[3.9045000000E+04, 2.9117320585E+01, 5.0007953093E+00, 1.1438957357E+01, 3.1081715141E+00, 9.5662873329E-01],
	[3.9050000000E+04, 2.9123761699E+01, 5.0008219074E+00, 1.1443697839E+01, 3.1086050767E+00, 9.5664628015E-01],
	[3.9055000000E+04, 2.9130203412E+01, 5.0008485022E+00, 1.1448439676E+01, 3.1090385434E+00, 9.5666381902E-01],
	[3.9060000000E+04, 2.9136645726E+01, 5.0008750937E+00, 1.1453182871E+01, 3.1094719142E+00, 9.5668134990E-01],
	[3.9065000000E+04, 2.9143088639E+01, 5.0009016819E+00, 1.1457927422E+01, 3.1099051892E+00, 9.5669887278E-01],
	[3.9070000000E+04, 2.9149532152E+01, 5.0009282669E+00, 1.1462673330E+01, 3.1103383682E+00, 9.5671638768E-01],
	[3.9075000000E+04, 2.9155976265E+01, 5.0009548487E+00, 1.1467420595E+01, 3.1107714515E+00, 9.5673389459E-01],
	[3.9080000000E+04, 2.9162420977E+01, 5.0009814272E+00, 1.1472169218E+01, 3.1112044389E+00, 9.5675139352E-01],
	[3.9085000000E+04, 2.9168866290E+01, 5.0010080024E+00, 1.1476919198E+01, 3.1116373304E+00, 9.5676888448E-01],
	[3.9090000000E+04, 2.9175312202E+01, 5.0010345743E+00, 1.1481670536E+01, 3.1120701262E+00, 9.5678636747E-01],
	[3.9095000000E+04, 2.9181758714E+01, 5.0010611430E+00, 1.1486423232E+01, 3.1125028261E+00, 9.5680384249E-01],
	[3.9100000000E+04, 2.9188205826E+01, 5.0010877085E+00, 1.1491177287E+01, 3.1129354302E+00, 9.5682130955E-01],
	[3.9105000000E+04, 2.9194653537E+01, 5.0011142707E+00, 1.1495932700E+01, 3.1133679385E+00, 9.5683876864E-01],
	[3.9110000000E+04, 2.9201101848E+01, 5.0011408296E+00, 1.1500689471E+01, 3.1138003511E+00, 9.5685621978E-01],
	[3.9115000000E+04, 2.9207550759E+01, 5.0011673853E+00, 1.1505447602E+01, 3.1142326678E+00, 9.5687366297E-01],
	[3.9120000000E+04, 2.9214000269E+01, 5.0011939377E+00, 1.1510207092E+01, 3.1146648888E+00, 9.5689109821E-01],
	[3.9125000000E+04, 2.9220450379E+01, 5.0012204869E+00, 1.1514967941E+01, 3.1150970140E+00, 9.5690852550E-01],
	[3.9130000000E+04, 2.9226901088E+01, 5.0012470328E+00, 1.1519730149E+01, 3.1155290435E+00, 9.5692594486E-01],
	[3.9135000000E+04, 2.9233352397E+01, 5.0012735755E+00, 1.1524493718E+01, 3.1159609772E+00, 9.5694335627E-01],
	[3.9140000000E+04, 2.9239804306E+01, 5.0013001149E+00, 1.1529258646E+01, 3.1163928152E+00, 9.5696075976E-01],
	[3.9145000000E+04, 2.9246256814E+01, 5.0013266511E+00, 1.1534024935E+01, 3.1168245574E+00, 9.5697815531E-01],
	[3.9150000000E+04, 2.9252709922E+01, 5.0013531840E+00, 1.1538792584E+01, 3.1172562040E+00, 9.5699554294E-01],
	[3.9155000000E+04, 2.9259163629E+01, 5.0013797137E+00, 1.1543561593E+01, 3.1176877548E+00, 9.5701292265E-01],
	[3.9160000000E+04, 2.9265617936E+01, 5.0014062401E+00, 1.1548331964E+01, 3.1181192100E+00, 9.5703029444E-01],
	[3.9165000000E+04, 2.9272072842E+01, 5.0014327633E+00, 1.1553103695E+01, 3.1185505695E+00, 9.5704765832E-01],
	[3.9170000000E+04, 2.9278528347E+01, 5.0014592833E+00, 1.1557876788E+01, 3.1189818333E+00, 9.5706501429E-01],
	[3.9175000000E+04, 2.9284984452E+01, 5.0014858000E+00, 1.1562651242E+01, 3.1194130014E+00, 9.5708236235E-01],
	[3.9180000000E+04, 2.9291441157E+01, 5.0015123134E+00, 1.1567427058E+01, 3.1198440738E+00, 9.5709970251E-01],
	[3.9185000000E+04, 2.9297898460E+01, 5.0015388236E+00, 1.1572204236E+01, 3.1202750507E+00, 9.5711703478E-01],
	[3.9190000000E+04, 2.9304356363E+01, 5.0015653306E+00, 1.1576982776E+01, 3.1207059318E+00, 9.5713435915E-01],
	[3.9195000000E+04, 2.9310814866E+01, 5.0015918343E+00, 1.1581762679E+01, 3.1211367174E+00, 9.5715167562E-01],
	[3.9200000000E+04, 2.9317273967E+01, 5.0016183348E+00, 1.1586543944E+01, 3.1215674073E+00, 9.5716898422E-01],
	[3.9205000000E+04, 2.9323733668E+01, 5.0016448320E+00, 1.1591326571E+01, 3.1219980016E+00, 9.5718628493E-01],
	[3.9210000000E+04, 2.9330193968E+01, 5.0016713260E+00, 1.1596110562E+01, 3.1224285004E+00, 9.5720357776E-01],
	[3.9215000000E+04, 2.9336654868E+01, 5.0016978168E+00, 1.1600895916E+01, 3.1228589035E+00, 9.5722086271E-01],
	[3.9220000000E+04, 2.9343116366E+01, 5.0017243043E+00, 1.1605682633E+01, 3.1232892110E+00, 9.5723813980E-01],
	[3.9225000000E+04, 2.9349578464E+01, 5.0017507886E+00, 1.1610470714E+01, 3.1237194230E+00, 9.5725540901E-01],
	[3.9230000000E+04, 2.9356041161E+01, 5.0017772697E+00, 1.1615260159E+01, 3.1241495394E+00, 9.5727267037E-01],
	[3.9235000000E+04, 2.9362504457E+01, 5.0018037475E+00, 1.1620050968E+01, 3.1245795602E+00, 9.5728992386E-01],
	[3.9240000000E+04, 2.9368978807E+01, 5.0018316564E+00, 1.1624843141E+01, 3.1250101638E+00, 9.5730716950E-01],
	[3.9245000000E+04, 2.9375459297E+01, 5.0018603217E+00, 1.1629636678E+01, 3.1254410314E+00, 9.5732440729E-01],
	[3.9250000000E+04, 2.9381940391E+01, 5.0018889835E+00, 1.1634431581E+01, 3.1258718038E+00, 9.5734163722E-01],
	[3.9255000000E+04, 2.9388422090E+01, 5.0019176418E+00, 1.1639227848E+01, 3.1263024810E+00, 9.5735885932E-01],
	[3.9260000000E+04, 2.9394904392E+01, 5.0019462966E+00, 1.1644025480E+01, 3.1267330631E+00, 9.5737607357E-01],
	[3.9265000000E+04, 2.9401387299E+01, 5.0019749479E+00, 1.1648824478E+01, 3.1271635500E+00, 9.5739327999E-01],
	[3.9270000000E+04, 2.9407870810E+01, 5.0020035957E+00, 1.1653624841E+01, 3.1275939418E+00, 9.5741047858E-01],
	[3.9275000000E+04, 2.9414354924E+01, 5.0020322400E+00, 1.1658426570E+01, 3.1280242385E+00, 9.5742766933E-01],
	[3.9280000000E+04, 2.9420839643E+01, 5.0020608809E+00, 1.1663229665E+01, 3.1284544400E+00, 9.5744485226E-01],
	[3.9285000000E+04, 2.9427324966E+01, 5.0020895183E+00, 1.1668034126E+01, 3.1288845465E+00, 9.5746202737E-01],
	[3.9290000000E+04, 2.9433810892E+01, 5.0021181522E+00, 1.1672839954E+01, 3.1293145578E+00, 9.5747919467E-01],
	[3.9295000000E+04, 2.9440297423E+01, 5.0021467826E+00, 1.1677647148E+01, 3.1297444741E+00, 9.5749635415E-01],
	[3.9300000000E+04, 2.9446784557E+01, 5.0021754096E+00, 1.1682455709E+01, 3.1301742953E+00, 9.5751350582E-01],
	[3.9305000000E+04, 2.9453272295E+01, 5.0022040330E+00, 1.1687265637E+01, 3.1306040214E+00, 9.5753064968E-01],
	[3.9310000000E+04, 2.9459760637E+01, 5.0022326530E+00, 1.1692076932E+01, 3.1310336524E+00, 9.5754778574E-01],
	[3.9315000000E+04, 2.9466249583E+01, 5.0022612695E+00, 1.1696889595E+01, 3.1314631884E+00, 9.5756491401E-01],
	[3.9320000000E+04, 2.9472739133E+01, 5.0022898826E+00, 1.1701703626E+01, 3.1318926294E+00, 9.5758203448E-01],
	[3.9325000000E+04, 2.9479229286E+01, 5.0023184921E+00, 1.1706519024E+01, 3.1323219753E+00, 9.5759914716E-01],
	[3.9330000000E+04, 2.9485720044E+01, 5.0023470982E+00, 1.1711335791E+01, 3.1327512262E+00, 9.5761625205E-01],
	[3.9335000000E+04, 2.9492211405E+01, 5.0023757008E+00, 1.1716153926E+01, 3.1331803821E+00, 9.5763334916E-01],
	[3.9340000000E+04, 2.9498703370E+01, 5.0024043000E+00, 1.1720973429E+01, 3.1336094430E+00, 9.5765043849E-01],
	[3.9345000000E+04, 2.9505195938E+01, 5.0024328957E+00, 1.1725794301E+01, 3.1340384089E+00, 9.5766752005E-01],
	[3.9350000000E+04, 2.9511689110E+01, 5.0024614879E+00, 1.1730616543E+01, 3.1344672798E+00, 9.5768459383E-01],
	[3.9355000000E+04, 2.9518182886E+01, 5.0024900766E+00, 1.1735440153E+01, 3.1348960557E+00, 9.5770165985E-01],
	[3.9360000000E+04, 2.9524677266E+01, 5.0025186619E+00, 1.1740265133E+01, 3.1353247367E+00, 9.5771871811E-01],
	[3.9365000000E+04, 2.9531172249E+01, 5.0025472436E+00, 1.1745091482E+01, 3.1357533227E+00, 9.5773576860E-01],
	[3.9370000000E+04, 2.9537667835E+01, 5.0025758220E+00, 1.1749919202E+01, 3.1361818138E+00, 9.5775281134E-01],
	[3.9375000000E+04, 2.9544164026E+01, 5.0026043968E+00, 1.1754748291E+01, 3.1366102099E+00, 9.5776984632E-01],
	[3.9380000000E+04, 2.9550660820E+01, 5.0026329682E+00, 1.1759578751E+01, 3.1370385111E+00, 9.5778687356E-01],
	[3.9385000000E+04, 2.9557158217E+01, 5.0026615362E+00, 1.1764410581E+01, 3.1374667174E+00, 9.5780389305E-01],
	[3.9390000000E+04, 2.9563656218E+01, 5.0026901006E+00, 1.1769243781E+01, 3.1378948288E+00, 9.5782090481E-01],
	[3.9395000000E+04, 2.9570154823E+01, 5.0027186617E+00, 1.1774078353E+01, 3.1383228453E+00, 9.5783790882E-01],
	[3.9400000000E+04, 2.9576654031E+01, 5.0027472192E+00, 1.1778914296E+01, 3.1387507669E+00, 9.5785490510E-01],
	[3.9405000000E+04, 2.9583153842E+01, 5.0027757733E+00, 1.1783751610E+01, 3.1391785936E+00, 9.5787189366E-01],
	[3.9410000000E+04, 2.9589654257E+01, 5.0028043239E+00, 1.1788590296E+01, 3.1396063255E+00, 9.5788887449E-01],
	[3.9415000000E+04, 2.9596155275E+01, 5.0028328711E+00, 1.1793430354E+01, 3.1400339625E+00, 9.5790584759E-01],
	[3.9420000000E+04, 2.9602656897E+01, 5.0028614148E+00, 1.1798271783E+01, 3.1404615047E+00, 9.5792281298E-01],
	[3.9425000000E+04, 2.9609159122E+01, 5.0028899550E+00, 1.1803114585E+01, 3.1408889520E+00, 9.5793977065E-01],
	[3.9430000000E+04, 2.9615661950E+01, 5.0029184918E+00, 1.1807958759E+01, 3.1413163045E+00, 9.5795672062E-01],
	[3.9435000000E+04, 2.9622165382E+01, 5.0029470252E+00, 1.1812804306E+01, 3.1417435622E+00, 9.5797366287E-01],
	[3.9440000000E+04, 2.9628669417E+01, 5.0029755551E+00, 1.1817651225E+01, 3.1421707251E+00, 9.5799059743E-01],
	[3.9445000000E+04, 2.9635174056E+01, 5.0030040815E+00, 1.1822499518E+01, 3.1425977932E+00, 9.5800752429E-01],
	[3.9450000000E+04, 2.9641679297E+01, 5.0030326045E+00, 1.1827349184E+01, 3.1430247665E+00, 9.5802444345E-01],
	[3.9455000000E+04, 2.9648185142E+01, 5.0030611240E+00, 1.1832200223E+01, 3.1434516450E+00, 9.5804135492E-01],
	[3.9460000000E+04, 2.9654691591E+01, 5.0030896401E+00, 1.1837052636E+01, 3.1438784288E+00, 9.5805825870E-01],
	[3.9465000000E+04, 2.9661198642E+01, 5.0031181527E+00, 1.1841906423E+01, 3.1443051178E+00, 9.5807515480E-01],
	[3.9470000000E+04, 2.9667706297E+01, 5.0031466619E+00, 1.1846761585E+01, 3.1447317120E+00, 9.5809204322E-01],
	[3.9475000000E+04, 2.9674214554E+01, 5.0031751676E+00, 1.1851618120E+01, 3.1451582115E+00, 9.5810892396E-01],
	[3.9480000000E+04, 2.9680723415E+01, 5.0032036699E+00, 1.1856476030E+01, 3.1455846163E+00, 9.5812579703E-01],
	[3.9485000000E+04, 2.9687232879E+01, 5.0032321687E+00, 1.1861335315E+01, 3.1460109264E+00, 9.5814266243E-01],
	[3.9490000000E+04, 2.9693742947E+01, 5.0032606641E+00, 1.1866195975E+01, 3.1464371418E+00, 9.5815952017E-01],
	[3.9495000000E+04, 2.9700253617E+01, 5.0032891560E+00, 1.1871058010E+01, 3.1468632624E+00, 9.5817637025E-01],
	[3.9500000000E+04, 2.9706764890E+01, 5.0033176445E+00, 1.1875921420E+01, 3.1472892884E+00, 9.5819321267E-01],
	[3.9505000000E+04, 2.9713276767E+01, 5.0033461295E+00, 1.1880786206E+01, 3.1477152197E+00, 9.5821004744E-01],
	[3.9510000000E+04, 2.9719789246E+01, 5.0033746111E+00, 1.1885652368E+01, 3.1481410564E+00, 9.5822687455E-01],
	[3.9515000000E+04, 2.9726302329E+01, 5.0034030893E+00, 1.1890519906E+01, 3.1485667983E+00, 9.5824369403E-01],
	[3.9520000000E+04, 2.9732816014E+01, 5.0034315640E+00, 1.1895388821E+01, 3.1489924457E+00, 9.5826050586E-01],
	[3.9525000000E+04, 2.9739330303E+01, 5.0034600353E+00, 1.1900259111E+01, 3.1494179984E+00, 9.5827731005E-01],
	[3.9530000000E+04, 2.9745845194E+01, 5.0034885032E+00, 1.1905130779E+01, 3.1498434565E+00, 9.5829410661E-01],
	[3.9535000000E+04, 2.9752360688E+01, 5.0035169676E+00, 1.1910003823E+01, 3.1502688199E+00, 9.5831089553E-01],
	[3.9540000000E+04, 2.9758876786E+01, 5.0035454285E+00, 1.1914878245E+01, 3.1506940888E+00, 9.5832767683E-01],
	[3.9545000000E+04, 2.9765393486E+01, 5.0035738861E+00, 1.1919754044E+01, 3.1511192631E+00, 9.5834445051E-01],
	[3.9550000000E+04, 2.9771910789E+01, 5.0036023402E+00, 1.1924631220E+01, 3.1515443427E+00, 9.5836121657E-01],
	[3.9555000000E+04, 2.9778428695E+01, 5.0036307908E+00, 1.1929509774E+01, 3.1519693278E+00, 9.5837797501E-01],
	[3.9560000000E+04, 2.9784947203E+01, 5.0036592380E+00, 1.1934389707E+01, 3.1523942184E+00, 9.5839472584E-01],
	[3.9565000000E+04, 2.9791466315E+01, 5.0036876818E+00, 1.1939271017E+01, 3.1528190144E+00, 9.5841146907E-01],
	[3.9570000000E+04, 2.9797986029E+01, 5.0037161222E+00, 1.1944153706E+01, 3.1532437158E+00, 9.5842820469E-01],
	[3.9575000000E+04, 2.9804506346E+01, 5.0037445591E+00, 1.1949037773E+01, 3.1536683227E+00, 9.5844493271E-01],
	[3.9580000000E+04, 2.9811027266E+01, 5.0037729926E+00, 1.1953923220E+01, 3.1540928351E+00, 9.5846165313E-01],
	[3.9585000000E+04, 2.9817548788E+01, 5.0038014227E+00, 1.1958810045E+01, 3.1545172530E+00, 9.5847836596E-01],
	[3.9590000000E+04, 2.9824070914E+01, 5.0038298493E+00, 1.1963698250E+01, 3.1549415763E+00, 9.5849507120E-01],
	[3.9595000000E+04, 2.9830593641E+01, 5.0038582725E+00, 1.1968587834E+01, 3.1553658052E+00, 9.5851176886E-01],
	[3.9600000000E+04, 2.9837116972E+01, 5.0038866923E+00, 1.1973478798E+01, 3.1557899396E+00, 9.5852845893E-01],
	[3.9605000000E+04, 2.9843640905E+01, 5.0039151086E+00, 1.1978371141E+01, 3.1562139795E+00, 9.5854514143E-01],
	[3.9610000000E+04, 2.9850165441E+01, 5.0039435216E+00, 1.1983264865E+01, 3.1566379250E+00, 9.5856181635E-01],
	[3.9615000000E+04, 2.9856690580E+01, 5.0039719311E+00, 1.1988159970E+01, 3.1570617760E+00, 9.5857848371E-01],
	[3.9620000000E+04, 2.9863216321E+01, 5.0040003371E+00, 1.1993056454E+01, 3.1574855326E+00, 9.5859514349E-01],
	[3.9625000000E+04, 2.9869742664E+01, 5.0040287398E+00, 1.1997954320E+01, 3.1579091947E+00, 9.5861179572E-01],
	[3.9630000000E+04, 2.9876269610E+01, 5.0040571390E+00, 1.2002853567E+01, 3.1583327625E+00, 9.5862844038E-01],
	[3.9635000000E+04, 2.9882797159E+01, 5.0040855348E+00, 1.2007754195E+01, 3.1587562358E+00, 9.5864507749E-01],
	[3.9640000000E+04, 2.9889325310E+01, 5.0041139272E+00, 1.2012656204E+01, 3.1591796147E+00, 9.5866170705E-01],
	[3.9645000000E+04, 2.9895854064E+01, 5.0041423162E+00, 1.2017559595E+01, 3.1596028992E+00, 9.5867832907E-01],
	[3.9650000000E+04, 2.9902383420E+01, 5.0041707018E+00, 1.2022464368E+01, 3.1600260894E+00, 9.5869494353E-01],
	[3.9655000000E+04, 2.9908913379E+01, 5.0041990839E+00, 1.2027370522E+01, 3.1604491851E+00, 9.5871155046E-01],
	[3.9660000000E+04, 2.9915443940E+01, 5.0042274626E+00, 1.2032278060E+01, 3.1608721866E+00, 9.5872814985E-01],
	[3.9665000000E+04, 2.9921975103E+01, 5.0042558379E+00, 1.2037186979E+01, 3.1612950936E+00, 9.5874474171E-01],
	[3.9670000000E+04, 2.9928506869E+01, 5.0042842098E+00, 1.2042097282E+01, 3.1617179064E+00, 9.5876132604E-01],
	[3.9675000000E+04, 2.9935039237E+01, 5.0043125782E+00, 1.2047008967E+01, 3.1621406248E+00, 9.5877790285E-01],
	[3.9680000000E+04, 2.9941572207E+01, 5.0043409433E+00, 1.2051922035E+01, 3.1625632489E+00, 9.5879447214E-01],
	[3.9685000000E+04, 2.9948105780E+01, 5.0043693049E+00, 1.2056836487E+01, 3.1629857787E+00, 9.5881103390E-01],
	[3.9690000000E+04, 2.9954639955E+01, 5.0043976632E+00, 1.2061752322E+01, 3.1634082142E+00, 9.5882758816E-01],
	[3.9695000000E+04, 2.9961174732E+01, 5.0044260180E+00, 1.2066669542E+01, 3.1638305554E+00, 9.5884413490E-01],
	[3.9700000000E+04, 2.9967710112E+01, 5.0044543694E+00, 1.2071588145E+01, 3.1642528024E+00, 9.5886067414E-01],
	[3.9705000000E+04, 2.9974246094E+01, 5.0044827174E+00, 1.2076508132E+01, 3.1646749550E+00, 9.5887720587E-01],
	[3.9710000000E+04, 2.9980782678E+01, 5.0045110620E+00, 1.2081429504E+01, 3.1650970135E+00, 9.5889373011E-01],
	[3.9715000000E+04, 2.9987319864E+01, 5.0045394031E+00, 1.2086352260E+01, 3.1655189777E+00, 9.5891024685E-01],
	[3.9720000000E+04, 2.9993857653E+01, 5.0045677409E+00, 1.2091276402E+01, 3.1659408476E+00, 9.5892675610E-01],
	[3.9725000000E+04, 3.0000396043E+01, 5.0045960753E+00, 1.2096201928E+01, 3.1663626234E+00, 9.5894325786E-01],
	[3.9730000000E+04, 3.0006935036E+01, 5.0046244062E+00, 1.2101128840E+01, 3.1667843049E+00, 9.5895975214E-01],
	[3.9735000000E+04, 3.0013474631E+01, 5.0046527338E+00, 1.2106057137E+01, 3.1672058922E+00, 9.5897623894E-01],
	[3.9740000000E+04, 3.0020014828E+01, 5.0046810579E+00, 1.2110986820E+01, 3.1676273854E+00, 9.5899271826E-01],
	[3.9745000000E+04, 3.0026555627E+01, 5.0047093787E+00, 1.2115917889E+01, 3.1680487844E+00, 9.5900919011E-01],
	[3.9750000000E+04, 3.0033097028E+01, 5.0047376960E+00, 1.2120850344E+01, 3.1684700892E+00, 9.5902565449E-01],
	[3.9755000000E+04, 3.0039639031E+01, 5.0047660100E+00, 1.2125784185E+01, 3.1688912998E+00, 9.5904211141E-01],
	[3.9760000000E+04, 3.0046181636E+01, 5.0047943205E+00, 1.2130719413E+01, 3.1693124163E+00, 9.5905856086E-01],
	[3.9765000000E+04, 3.0052724843E+01, 5.0048226277E+00, 1.2135656028E+01, 3.1697334387E+00, 9.5907500286E-01],
	[3.9770000000E+04, 3.0059268652E+01, 5.0048509314E+00, 1.2140594030E+01, 3.1701543669E+00, 9.5909143741E-01],
	[3.9775000000E+04, 3.0065813064E+01, 5.0048792317E+00, 1.2145533419E+01, 3.1705752011E+00, 9.5910786450E-01],
	[3.9780000000E+04, 3.0072358077E+01, 5.0049075287E+00, 1.2150474195E+01, 3.1709959411E+00, 9.5912428415E-01],
	[3.9785000000E+04, 3.0078903691E+01, 5.0049358222E+00, 1.2155416359E+01, 3.1714165870E+00, 9.5914069635E-01],
	[3.9790000000E+04, 3.0085449908E+01, 5.0049641124E+00, 1.2160359911E+01, 3.1718371389E+00, 9.5915710112E-01],
	[3.9795000000E+04, 3.0091996727E+01, 5.0049923992E+00, 1.2165304851E+01, 3.1722575967E+00, 9.5917349845E-01],
	[3.9800000000E+04, 3.0098544147E+01, 5.0050206825E+00, 1.2170251179E+01, 3.1726779604E+00, 9.5918988834E-01],
	[3.9805000000E+04, 3.0105092170E+01, 5.0050489625E+00, 1.2175198896E+01, 3.1730982301E+00, 9.5920627081E-01],
	[3.9810000000E+04, 3.0111640794E+01, 5.0050772391E+00, 1.2180148002E+01, 3.1735184057E+00, 9.5922264586E-01],
	[3.9815000000E+04, 3.0118190020E+01, 5.0051055123E+00, 1.2185098496E+01, 3.1739384874E+00, 9.5923901349E-01],
	[3.9820000000E+04, 3.0124739848E+01, 5.0051337821E+00, 1.2190050380E+01, 3.1743584750E+00, 9.5925537370E-01],
	[3.9825000000E+04, 3.0131290277E+01, 5.0051620485E+00, 1.2195003653E+01, 3.1747783686E+00, 9.5927172649E-01],
	[3.9830000000E+04, 3.0137841308E+01, 5.0051903115E+00, 1.2199958316E+01, 3.1751981682E+00, 9.5928807188E-01],
	[3.9835000000E+04, 3.0144392941E+01, 5.0052185711E+00, 1.2204914368E+01, 3.1756178738E+00, 9.5930440986E-01],
	[3.9840000000E+04, 3.0150945176E+01, 5.0052468274E+00, 1.2209871811E+01, 3.1760374855E+00, 9.5932074045E-01],
	[3.9845000000E+04, 3.0157498012E+01, 5.0052750802E+00, 1.2214830644E+01, 3.1764570032E+00, 9.5933706363E-01],
	[3.9850000000E+04, 3.0164051450E+01, 5.0053033297E+00, 1.2219790867E+01, 3.1768764269E+00, 9.5935337942E-01],
	[3.9855000000E+04, 3.0170605489E+01, 5.0053315758E+00, 1.2224752481E+01, 3.1772957567E+00, 9.5936968781E-01],
	[3.9860000000E+04, 3.0177160131E+01, 5.0053598185E+00, 1.2229715485E+01, 3.1777149926E+00, 9.5938598882E-01],
	[3.9865000000E+04, 3.0183715373E+01, 5.0053880578E+00, 1.2234679881E+01, 3.1781341345E+00, 9.5940228245E-01],
	[3.9870000000E+04, 3.0190276310E+01, 5.0054169852E+00, 1.2239645668E+01, 3.1785535179E+00, 9.5941856870E-01],
	[3.9875000000E+04, 3.0196848567E+01, 5.0054473641E+00, 1.2244612847E+01, 3.1789735131E+00, 9.5943484757E-01],
	[3.9880000000E+04, 3.0203421430E+01, 5.0054777394E+00, 1.2249581417E+01, 3.1793934147E+00, 9.5945111907E-01],
	[3.9885000000E+04, 3.0209994900E+01, 5.0055081111E+00, 1.2254551380E+01, 3.1798132228E+00, 9.5946738320E-01],
	[3.9890000000E+04, 3.0216568977E+01, 5.0055384791E+00, 1.2259522734E+01, 3.1802329374E+00, 9.5948363997E-01],
	[3.9895000000E+04, 3.0223143659E+01, 5.0055688436E+00, 1.2264495481E+01, 3.1806525585E+00, 9.5949988938E-01],
	[3.9900000000E+04, 3.0229718948E+01, 5.0055992044E+00, 1.2269469621E+01, 3.1810720860E+00, 9.5951613143E-01],
	[3.9905000000E+04, 3.0236294844E+01, 5.0056295615E+00, 1.2274445153E+01, 3.1814915201E+00, 9.5953236612E-01],
	[3.9910000000E+04, 3.0242871345E+01, 5.0056599151E+00, 1.2279422079E+01, 3.1819108607E+00, 9.5954859347E-01],
	[3.9915000000E+04, 3.0249448453E+01, 5.0056902651E+00, 1.2284400397E+01, 3.1823301077E+00, 9.5956481347E-01],
	[3.9920000000E+04, 3.0256026167E+01, 5.0057206114E+00, 1.2289380109E+01, 3.1827492614E+00, 9.5958102612E-01],
	[3.9925000000E+04, 3.0262604488E+01, 5.0057509541E+00, 1.2294361215E+01, 3.1831683216E+00, 9.5959723144E-01],
	[3.9930000000E+04, 3.0269183414E+01, 5.0057812932E+00, 1.2299343715E+01, 3.1835872883E+00, 9.5961342942E-01],
	[3.9935000000E+04, 3.0275762947E+01, 5.0058116287E+00, 1.2304327608E+01, 3.1840061616E+00, 9.5962962007E-01],
	[3.9940000000E+04, 3.0282343086E+01, 5.0058419606E+00, 1.2309312896E+01, 3.1844249415E+00, 9.5964580340E-01],
	[3.9945000000E+04, 3.0288923831E+01, 5.0058722888E+00, 1.2314299579E+01, 3.1848436279E+00, 9.5966197940E-01],
	[3.9950000000E+04, 3.0295505183E+01, 5.0059026135E+00, 1.2319287656E+01, 3.1852622210E+00, 9.5967814808E-01],
	[3.9955000000E+04, 3.0302087140E+01, 5.0059329345E+00, 1.2324277129E+01, 3.1856807207E+00, 9.5969430944E-01],
	[3.9960000000E+04, 3.0308669704E+01, 5.0059632519E+00, 1.2329267996E+01, 3.1860991270E+00, 9.5971046349E-01],
	[3.9965000000E+04, 3.0315252873E+01, 5.0059935657E+00, 1.2334260259E+01, 3.1865174400E+00, 9.5972661023E-01],
	[3.9970000000E+04, 3.0321836649E+01, 5.0060238759E+00, 1.2339253918E+01, 3.1869356595E+00, 9.5974274966E-01],
	[3.9975000000E+04, 3.0328421031E+01, 5.0060541825E+00, 1.2344248972E+01, 3.1873537858E+00, 9.5975888180E-01],
	[3.9980000000E+04, 3.0335006018E+01, 5.0060844855E+00, 1.2349245422E+01, 3.1877718187E+00, 9.5977500663E-01],
	[3.9985000000E+04, 3.0341591612E+01, 5.0061147849E+00, 1.2354243269E+01, 3.1881897583E+00, 9.5979112417E-01],
	[3.9990000000E+04, 3.0348177812E+01, 5.0061450807E+00, 1.2359242512E+01, 3.1886076046E+00, 9.5980723442E-01],
	[3.9995000000E+04, 3.0354764617E+01, 5.0061753728E+00, 1.2364243152E+01, 3.1890253576E+00, 9.5982333738E-01],
	[4.0000000000E+04, 3.0361352029E+01, 5.0062056614E+00, 1.2369245189E+01, 3.1894430173E+00, 9.5983943306E-01],
	[4.0005000000E+04, 3.0367940046E+01, 5.0062359464E+00, 1.2374266937E+01, 3.1898618007E+00, 9.5985552146E-01],
	[4.0010000000E+04, 3.0374528670E+01, 5.0062662277E+00, 1.2379290095E+01, 3.1902804904E+00, 9.5987160258E-01],
	[4.0015000000E+04, 3.0381117899E+01, 5.0062965055E+00, 1.2384314664E+01, 3.1906990863E+00, 9.5988767643E-01],
	[4.0020000000E+04, 3.0387707734E+01, 5.0063267797E+00, 1.2389340643E+01, 3.1911175885E+00, 9.5990374301E-01],
	[4.0025000000E+04, 3.0394298175E+01, 5.0063570502E+00, 1.2394368032E+01, 3.1915359970E+00, 9.5991980233E-01],
	[4.0030000000E+04, 3.0400889222E+01, 5.0063873172E+00, 1.2399396832E+01, 3.1919543117E+00, 9.5993585438E-01],
	[4.0035000000E+04, 3.0407480875E+01, 5.0064175806E+00, 1.2404427043E+01, 3.1923725328E+00, 9.5995189918E-01],
	[4.0040000000E+04, 3.0414073133E+01, 5.0064478404E+00, 1.2409458666E+01, 3.1927906601E+00, 9.5996793672E-01],
	[4.0045000000E+04, 3.0420665997E+01, 5.0064780965E+00, 1.2414491699E+01, 3.1932086938E+00, 9.5998396701E-01],
	[4.0050000000E+04, 3.0427259467E+01, 5.0065083491E+00, 1.2419526145E+01, 3.1936266337E+00, 9.5999999006E-01],
	[4.0055000000E+04, 3.0433853543E+01, 5.0065385981E+00, 1.2424562002E+01, 3.1940444800E+00, 9.6001600586E-01],
	[4.0060000000E+04, 3.0440448224E+01, 5.0065688435E+00, 1.2429599272E+01, 3.1944622327E+00, 9.6003201442E-01],
	[4.0065000000E+04, 3.0447043511E+01, 5.0065990853E+00, 1.2434637953E+01, 3.1948798917E+00, 9.6004801575E-01],
	[4.0070000000E+04, 3.0453639403E+01, 5.0066293235E+00, 1.2439678048E+01, 3.1952974571E+00, 9.6006400984E-01],
	[4.0075000000E+04, 3.0460235902E+01, 5.0066595581E+00, 1.2444719555E+01, 3.1957149289E+00, 9.6007999671E-01],
	[4.0080000000E+04, 3.0466833006E+01, 5.0066897892E+00, 1.2449762475E+01, 3.1961323070E+00, 9.6009597635E-01],
	[4.0085000000E+04, 3.0473430715E+01, 5.0067200166E+00, 1.2454806808E+01, 3.1965495916E+00, 9.6011194877E-01],
	[4.0090000000E+04, 3.0480029030E+01, 5.0067502405E+00, 1.2459852554E+01, 3.1969667826E+00, 9.6012791397E-01],
	[4.0095000000E+04, 3.0486627951E+01, 5.0067804607E+00, 1.2464899715E+01, 3.1973838800E+00, 9.6014387196E-01],
	[4.0100000000E+04, 3.0493227477E+01, 5.0068106774E+00, 1.2469948289E+01, 3.1978008838E+00, 9.6015982273E-01],
	[4.0105000000E+04, 3.0499827609E+01, 5.0068408905E+00, 1.2474998277E+01, 3.1982177941E+00, 9.6017576630E-01],
	[4.0110000000E+04, 3.0506428346E+01, 5.0068711000E+00, 1.2480049679E+01, 3.1986346109E+00, 9.6019170267E-01],
	[4.0115000000E+04, 3.0513029688E+01, 5.0069013060E+00, 1.2485102496E+01, 3.1990513341E+00, 9.6020763184E-01],
	[4.0120000000E+04, 3.0519631636E+01, 5.0069315083E+00, 1.2490156728E+01, 3.1994679638E+00, 9.6022355381E-01],
	[4.0125000000E+04, 3.0526234190E+01, 5.0069617071E+00, 1.2495212374E+01, 3.1998845000E+00, 9.6023946859E-01],
	[4.0130000000E+04, 3.0532837349E+01, 5.0069919023E+00, 1.2500269436E+01, 3.2003009427E+00, 9.6025537618E-01],
	[4.0135000000E+04, 3.0539441113E+01, 5.0070220939E+00, 1.2505327913E+01, 3.2007172920E+00, 9.6027127659E-01],
	[4.0140000000E+04, 3.0546045483E+01, 5.0070522819E+00, 1.2510387806E+01, 3.2011335477E+00, 9.6028716982E-01],
	[4.0145000000E+04, 3.0552650458E+01, 5.0070824664E+00, 1.2515449115E+01, 3.2015497100E+00, 9.6030305587E-01],
	[4.0150000000E+04, 3.0559256039E+01, 5.0071126472E+00, 1.2520511839E+01, 3.2019657789E+00, 9.6031893474E-01],
	[4.0155000000E+04, 3.0565862224E+01, 5.0071428245E+00, 1.2525575980E+01, 3.2023817543E+00, 9.6033480644E-01],
	[4.0160000000E+04, 3.0572469015E+01, 5.0071729982E+00, 1.2530641538E+01, 3.2027976363E+00, 9.6035067098E-01],
	[4.0165000000E+04, 3.0579076412E+01, 5.0072031684E+00, 1.2535708512E+01, 3.2032134249E+00, 9.6036652836E-01],
	[4.0170000000E+04, 3.0585684413E+01, 5.0072333350E+00, 1.2540776903E+01, 3.2036291201E+00, 9.6038237857E-01],
	[4.0175000000E+04, 3.0592293020E+01, 5.0072634980E+00, 1.2545846711E+01, 3.2040447219E+00, 9.6039822163E-01],
	[4.0180000000E+04, 3.0598902232E+01, 5.0072936574E+00, 1.2550917936E+01, 3.2044602303E+00, 9.6041405754E-01],
	[4.0185000000E+04, 3.0605512049E+01, 5.0073238132E+00, 1.2555990579E+01, 3.2048756453E+00, 9.6042988630E-01],
	[4.0190000000E+04, 3.0612122472E+01, 5.0073539655E+00, 1.2561064640E+01, 3.2052909670E+00, 9.6044570791E-01],
	[4.0195000000E+04, 3.0618733499E+01, 5.0073841142E+00, 1.2566140119E+01, 3.2057061953E+00, 9.6046152238E-01],
	[4.0200000000E+04, 3.0625345132E+01, 5.0074142594E+00, 1.2571217016E+01, 3.2061213303E+00, 9.6047732972E-01],
	[4.0205000000E+04, 3.0631957370E+01, 5.0074444010E+00, 1.2576295332E+01, 3.2065363720E+00, 9.6049312992E-01],
	[4.0210000000E+04, 3.0638570213E+01, 5.0074745390E+00, 1.2581375066E+01, 3.2069513204E+00, 9.6050892299E-01],
	[4.0215000000E+04, 3.0645183661E+01, 5.0075046734E+00, 1.2586456219E+01, 3.2073661755E+00, 9.6052470894E-01],
	[4.0220000000E+04, 3.0651797714E+01, 5.0075348043E+00, 1.2591538791E+01, 3.2077809373E+00, 9.6054048776E-01],
	[4.0225000000E+04, 3.0658412372E+01, 5.0075649316E+00, 1.2596622783E+01, 3.2081956058E+00, 9.6055625946E-01],
	[4.0230000000E+04, 3.0665027635E+01, 5.0075950554E+00, 1.2601708194E+01, 3.2086101811E+00, 9.6057202404E-01],
	[4.0235000000E+04, 3.0671643504E+01, 5.0076251756E+00, 1.2606795025E+01, 3.2090246631E+00, 9.6058778152E-01],
	[4.0240000000E+04, 3.0678259977E+01, 5.0076552922E+00, 1.2611883276E+01, 3.2094390519E+00, 9.6060353188E-01],
	[4.0245000000E+04, 3.0684877055E+01, 5.0076854053E+00, 1.2616972947E+01, 3.2098533474E+00, 9.6061927514E-01],
	[4.0250000000E+04, 3.0691494738E+01, 5.0077155148E+00, 1.2622064038E+01, 3.2102675497E+00, 9.6063501130E-01],
	[4.0255000000E+04, 3.0698113026E+01, 5.0077456207E+00, 1.2627156551E+01, 3.2106816588E+00, 9.6065074036E-01],
	[4.0260000000E+04, 3.0704731919E+01, 5.0077757231E+00, 1.2632250484E+01, 3.2110956748E+00, 9.6066646233E-01],
	[4.0265000000E+04, 3.0711351416E+01, 5.0078058220E+00, 1.2637345838E+01, 3.2115095975E+00, 9.6068217720E-01],
	[4.0270000000E+04, 3.0717971519E+01, 5.0078359172E+00, 1.2642442613E+01, 3.2119234271E+00, 9.6069788499E-01],
	[4.0275000000E+04, 3.0724592226E+01, 5.0078660090E+00, 1.2647540810E+01, 3.2123371635E+00, 9.6071358570E-01],
	[4.0280000000E+04, 3.0731213539E+01, 5.0078960971E+00, 1.2652640429E+01, 3.2127508068E+00, 9.6072927932E-01],
	[4.0285000000E+04, 3.0737835456E+01, 5.0079261817E+00, 1.2657741470E+01, 3.2131643569E+00, 9.6074496587E-01],
	[4.0290000000E+04, 3.0744457978E+01, 5.0079562628E+00, 1.2662843933E+01, 3.2135778140E+00, 9.6076064535E-01],
	[4.0295000000E+04, 3.0751081104E+01, 5.0079863403E+00, 1.2667947818E+01, 3.2139911779E+00, 9.6077631775E-01],
	[4.0300000000E+04, 3.0757704836E+01, 5.0080164143E+00, 1.2673053126E+01, 3.2144044487E+00, 9.6079198310E-01],
	[4.0305000000E+04, 3.0764329172E+01, 5.0080464847E+00, 1.2678159857E+01, 3.2148176264E+00, 9.6080764138E-01],
	[4.0310000000E+04, 3.0770954112E+01, 5.0080765515E+00, 1.2683268010E+01, 3.2152307111E+00, 9.6082329260E-01],
	[4.0315000000E+04, 3.0777579658E+01, 5.0081066148E+00, 1.2688377588E+01, 3.2156437026E+00, 9.6083893677E-01],
	[4.0320000000E+04, 3.0784205808E+01, 5.0081366746E+00, 1.2693488588E+01, 3.2160566012E+00, 9.6085457388E-01],
	[4.0325000000E+04, 3.0790832563E+01, 5.0081667308E+00, 1.2698601013E+01, 3.2164694067E+00, 9.6087020395E-01],
	[4.0330000000E+04, 3.0797459922E+01, 5.0081967835E+00, 1.2703714861E+01, 3.2168821191E+00, 9.6088582698E-01],
	[4.0335000000E+04, 3.0804087886E+01, 5.0082268326E+00, 1.2708830133E+01, 3.2172947386E+00, 9.6090144296E-01],
	[4.0340000000E+04, 3.0810716455E+01, 5.0082568782E+00, 1.2713946830E+01, 3.2177072650E+00, 9.6091705191E-01],
	[4.0345000000E+04, 3.0817345628E+01, 5.0082869202E+00, 1.2719064952E+01, 3.2181196985E+00, 9.6093265382E-01],
	[4.0350000000E+04, 3.0823975406E+01, 5.0083169587E+00, 1.2724184498E+01, 3.2185320390E+00, 9.6094824871E-01],
	[4.0355000000E+04, 3.0830605788E+01, 5.0083469936E+00, 1.2729305469E+01, 3.2189442865E+00, 9.6096383657E-01],
	[4.0360000000E+04, 3.0837236775E+01, 5.0083770250E+00, 1.2734427866E+01, 3.2193564410E+00, 9.6097941741E-01],
	[4.0365000000E+04, 3.0843868366E+01, 5.0084070529E+00, 1.2739551688E+01, 3.2197685026E+00, 9.6099499122E-01],
	[4.0370000000E+04, 3.0850500562E+01, 5.0084370772E+00, 1.2744676936E+01, 3.2201804713E+00, 9.6101055803E-01],
	[4.0375000000E+04, 3.0857133362E+01, 5.0084670980E+00, 1.2749803609E+01, 3.2205923471E+00, 9.6102611782E-01],
	[4.0380000000E+04, 3.0863766766E+01, 5.0084971153E+00, 1.2754931709E+01, 3.2210041299E+00, 9.6104167060E-01],
	[4.0385000000E+04, 3.0870400775E+01, 5.0085271290E+00, 1.2760061235E+01, 3.2214158199E+00, 9.6105721638E-01],
	[4.0390000000E+04, 3.0877035389E+01, 5.0085571392E+00, 1.2765192188E+01, 3.2218274169E+00, 9.6107275516E-01],
	[4.0395000000E+04, 3.0883670606E+01, 5.0085871458E+00, 1.2770324568E+01, 3.2222389211E+00, 9.6108828694E-01],
	[4.0400000000E+04, 3.0890306428E+01, 5.0086171489E+00, 1.2775458374E+01, 3.2226503324E+00, 9.6110381173E-01],
	[4.0405000000E+04, 3.0896942855E+01, 5.0086471485E+00, 1.2780593608E+01, 3.2230616509E+00, 9.6111932952E-01],
	[4.0410000000E+04, 3.0903579886E+01, 5.0086771446E+00, 1.2785730269E+01, 3.2234728766E+00, 9.6113484033E-01],
	[4.0415000000E+04, 3.0910217520E+01, 5.0087071371E+00, 1.2790868358E+01, 3.2238840094E+00, 9.6115034415E-01],
	[4.0420000000E+04, 3.0916855760E+01, 5.0087371261E+00, 1.2796007875E+01, 3.2242950494E+00, 9.6116584100E-01],
	[4.0425000000E+04, 3.0923494603E+01, 5.0087671115E+00, 1.2801148820E+01, 3.2247059966E+00, 9.6118133086E-01],
	[4.0430000000E+04, 3.0930134051E+01, 5.0087970934E+00, 1.2806291194E+01, 3.2251168510E+00, 9.6119681375E-01],
	[4.0435000000E+04, 3.0936774103E+01, 5.0088270718E+00, 1.2811434995E+01, 3.2255276127E+00, 9.6121228967E-01],
	[4.0440000000E+04, 3.0943414759E+01, 5.0088570467E+00, 1.2816580226E+01, 3.2259382815E+00, 9.6122775862E-01],
	[4.0445000000E+04, 3.0950056019E+01, 5.0088870180E+00, 1.2821726886E+01, 3.2263488577E+00, 9.6124322060E-01],
	[4.0450000000E+04, 3.0956697884E+01, 5.0089169859E+00, 1.2826874975E+01, 3.2267593411E+00, 9.6125867562E-01],
	[4.0455000000E+04, 3.0963340352E+01, 5.0089469501E+00, 1.2832024493E+01, 3.2271697317E+00, 9.6127412368E-01],
	[4.0460000000E+04, 3.0969983425E+01, 5.0089769109E+00, 1.2837175441E+01, 3.2275800297E+00, 9.6128956479E-01],
	[4.0465000000E+04, 3.0976627102E+01, 5.0090068682E+00, 1.2842327819E+01, 3.2279902349E+00, 9.6130499894E-01],
	[4.0470000000E+04, 3.0983271383E+01, 5.0090368219E+00, 1.2847481627E+01, 3.2284003474E+00, 9.6132042615E-01],
	[4.0475000000E+04, 3.0989916268E+01, 5.0090667721E+00, 1.2852636865E+01, 3.2288103673E+00, 9.6133584640E-01],
	[4.0480000000E+04, 3.0996561757E+01, 5.0090967188E+00, 1.2857793534E+01, 3.2292202945E+00, 9.6135125972E-01],
	[4.0485000000E+04, 3.1003207849E+01, 5.0091266619E+00, 1.2862951633E+01, 3.2296301291E+00, 9.6136666610E-01],
	[4.0490000000E+04, 3.1009854546E+01, 5.0091566016E+00, 1.2868111164E+01, 3.2300398710E+00, 9.6138206554E-01],
	[4.0495000000E+04, 3.1016501847E+01, 5.0091865377E+00, 1.2873272126E+01, 3.2304495202E+00, 9.6139745804E-01],
	[4.0500000000E+04, 3.1023149752E+01, 5.0092164703E+00, 1.2878434519E+01, 3.2308590769E+00, 9.6141284362E-01],
	[4.0505000000E+04, 3.1029798261E+01, 5.0092463994E+00, 1.2883598344E+01, 3.2312685409E+00, 9.6142822227E-01],
	[4.0510000000E+04, 3.1036447374E+01, 5.0092763249E+00, 1.2888763600E+01, 3.2316779124E+00, 9.6144359400E-01],
	[4.0515000000E+04, 3.1043112106E+01, 5.0093082556E+00, 1.2893930289E+01, 3.2320881902E+00, 9.6145895881E-01],
	[4.0520000000E+04, 3.1049778125E+01, 5.0093402733E+00, 1.2899098410E+01, 3.2324984209E+00, 9.6147431670E-01],
	[4.0525000000E+04, 3.1056444752E+01, 5.0093722873E+00, 1.2904267963E+01, 3.2329085594E+00, 9.6148966767E-01],
	[4.0530000000E+04, 3.1063111988E+01, 5.0094042975E+00, 1.2909438950E+01, 3.2333186057E+00, 9.6150501174E-01],
	[4.0535000000E+04, 3.1069779833E+01, 5.0094363040E+00, 1.2914611369E+01, 3.2337285597E+00, 9.6152034890E-01],
	[4.0540000000E+04, 3.1076448287E+01, 5.0094683067E+00, 1.2919785221E+01, 3.2341384215E+00, 9.6153567915E-01],
	[4.0545000000E+04, 3.1083117349E+01, 5.0095003057E+00, 1.2924960507E+01, 3.2345481912E+00, 9.6155100250E-01],
	[4.0550000000E+04, 3.1089787019E+01, 5.0095323010E+00, 1.2930137226E+01, 3.2349578686E+00, 9.6156631896E-01],
	[4.0555000000E+04, 3.1096457299E+01, 5.0095642925E+00, 1.2935315380E+01, 3.2353674539E+00, 9.6158162852E-01],
	[4.0560000000E+04, 3.1103128186E+01, 5.0095962802E+00, 1.2940494967E+01, 3.2357769471E+00, 9.6159693119E-01],
	[4.0565000000E+04, 3.1109799682E+01, 5.0096282643E+00, 1.2945675989E+01, 3.2361863481E+00, 9.6161222697E-01],
	[4.0570000000E+04, 3.1116471787E+01, 5.0096602446E+00, 1.2950858445E+01, 3.2365956569E+00, 9.6162751587E-01],
	[4.0575000000E+04, 3.1123144500E+01, 5.0096922211E+00, 1.2956042335E+01, 3.2370048737E+00, 9.6164279789E-01],
	[4.0580000000E+04, 3.1129817821E+01, 5.0097241939E+00, 1.2961227661E+01, 3.2374139983E+00, 9.6165807303E-01],
	[4.0585000000E+04, 3.1136491751E+01, 5.0097561630E+00, 1.2966414422E+01, 3.2378230308E+00, 9.6167334129E-01],
	[4.0590000000E+04, 3.1143166290E+01, 5.0097881284E+00, 1.2971602618E+01, 3.2382319713E+00, 9.6168860268E-01],
	[4.0595000000E+04, 3.1149841436E+01, 5.0098200900E+00, 1.2976792250E+01, 3.2386408197E+00, 9.6170385720E-01],
	[4.0600000000E+04, 3.1156517191E+01, 5.0098520479E+00, 1.2981983318E+01, 3.2390495760E+00, 9.6171910486E-01],
	[4.0605000000E+04, 3.1163193555E+01, 5.0098840020E+00, 1.2987175821E+01, 3.2394582403E+00, 9.6173434565E-01],
	[4.0610000000E+04, 3.1169870526E+01, 5.0099159524E+00, 1.2992369761E+01, 3.2398668125E+00, 9.6174957959E-01],
	[4.0615000000E+04, 3.1176548106E+01, 5.0099478991E+00, 1.2997565138E+01, 3.2402752927E+00, 9.6176480667E-01],
	[4.0620000000E+04, 3.1183226295E+01, 5.0099798421E+00, 1.3002761951E+01, 3.2406836810E+00, 9.6178002690E-01],
	[4.0625000000E+04, 3.1189905091E+01, 5.0100117813E+00, 1.3007960201E+01, 3.2410919772E+00, 9.6179524027E-01],
	[4.0630000000E+04, 3.1196584496E+01, 5.0100437168E+00, 1.3013159888E+01, 3.2415001814E+00, 9.6181044680E-01],
	[4.0635000000E+04, 3.1203264509E+01, 5.0100756486E+00, 1.3018361012E+01, 3.2419082937E+00, 9.6182564649E-01],
	[4.0640000000E+04, 3.1209945130E+01, 5.0101075767E+00, 1.3023563574E+01, 3.2423163140E+00, 9.6184083934E-01],
	[4.0645000000E+04, 3.1216626359E+01, 5.0101395010E+00, 1.3028767574E+01, 3.2427242423E+00, 9.6185602535E-01],
	[4.0650000000E+04, 3.1223308197E+01, 5.0101714216E+00, 1.3033973012E+01, 3.2431320788E+00, 9.6187120453E-01],
	[4.0655000000E+04, 3.1229990643E+01, 5.0102033385E+00, 1.3039179888E+01, 3.2435398233E+00, 9.6188637688E-01],
	[4.0660000000E+04, 3.1236673696E+01, 5.0102352516E+00, 1.3044388203E+01, 3.2439474758E+00, 9.6190154241E-01],
	[4.0665000000E+04, 3.1243357358E+01, 5.0102671611E+00, 1.3049597956E+01, 3.2443550365E+00, 9.6191670110E-01],
	[4.0670000000E+04, 3.1250041628E+01, 5.0102990668E+00, 1.3054809148E+01, 3.2447625053E+00, 9.6193185298E-01],
	[4.0675000000E+04, 3.1256726506E+01, 5.0103309688E+00, 1.3060021779E+01, 3.2451698823E+00, 9.6194699804E-01],
	[4.0680000000E+04, 3.1263411992E+01, 5.0103628671E+00, 1.3065235850E+01, 3.2455771673E+00, 9.6196213629E-01],
	[4.0685000000E+04, 3.1270098087E+01, 5.0103947616E+00, 1.3070451360E+01, 3.2459843606E+00, 9.6197726772E-01],
	[4.0690000000E+04, 3.1276784789E+01, 5.0104266525E+00, 1.3075668310E+01, 3.2463914619E+00, 9.6199239235E-01],
	[4.0695000000E+04, 3.1283472099E+01, 5.0104585396E+00, 1.3080886700E+01, 3.2467984715E+00, 9.6200751018E-01],
	[4.0700000000E+04, 3.1290160017E+01, 5.0104904231E+00, 1.3086106530E+01, 3.2472053892E+00, 9.6202262120E-01],
	[4.0705000000E+04, 3.1296848543E+01, 5.0105223028E+00, 1.3091327801E+01, 3.2476122152E+00, 9.6203772542E-01],
	[4.0710000000E+04, 3.1303537677E+01, 5.0105541787E+00, 1.3096550512E+01, 3.2480189494E+00, 9.6205282285E-01],
	[4.0715000000E+04, 3.1310227419E+01, 5.0105860510E+00, 1.3101774664E+01, 3.2484255918E+00, 9.6206791349E-01],
	[4.0720000000E+04, 3.1316917768E+01, 5.0106179196E+00, 1.3107000257E+01, 3.2488321424E+00, 9.6208299734E-01],
	[4.0725000000E+04, 3.1323608726E+01, 5.0106497845E+00, 1.3112227292E+01, 3.2492386013E+00, 9.6209807440E-01],
	[4.0730000000E+04, 3.1330300292E+01, 5.0106816456E+00, 1.3117455768E+01, 3.2496449684E+00, 9.6211314469E-01],
	[4.0735000000E+04, 3.1336992465E+01, 5.0107135030E+00, 1.3122685685E+01, 3.2500512438E+00, 9.6212820819E-01],
	[4.0740000000E+04, 3.1343685246E+01, 5.0107453568E+00, 1.3127917045E+01, 3.2504574275E+00, 9.6214326492E-01],
	[4.0745000000E+04, 3.1350378635E+01, 5.0107772068E+00, 1.3133149847E+01, 3.2508635195E+00, 9.6215831487E-01],
	[4.0750000000E+04, 3.1357072632E+01, 5.0108090531E+00, 1.3138384092E+01, 3.2512695199E+00, 9.6217335806E-01],
	[4.0755000000E+04, 3.1363767236E+01, 5.0108408957E+00, 1.3143619779E+01, 3.2516754285E+00, 9.6218839448E-01],
	[4.0760000000E+04, 3.1370462448E+01, 5.0108727347E+00, 1.3148856908E+01, 3.2520812455E+00, 9.6220342414E-01],
	[4.0765000000E+04, 3.1377158268E+01, 5.0109045699E+00, 1.3154095481E+01, 3.2524869708E+00, 9.6221844703E-01],
	[4.0770000000E+04, 3.1383854696E+01, 5.0109364014E+00, 1.3159335498E+01, 3.2528926045E+00, 9.6223346318E-01],
	[4.0775000000E+04, 3.1390551731E+01, 5.0109682292E+00, 1.3164576957E+01, 3.2532981466E+00, 9.6224847256E-01],
	[4.0780000000E+04, 3.1397249374E+01, 5.0110000533E+00, 1.3169819861E+01, 3.2537035971E+00, 9.6226347520E-01],
	[4.0785000000E+04, 3.1403947624E+01, 5.0110318737E+00, 1.3175064208E+01, 3.2541089559E+00, 9.6227847109E-01],
	[4.0790000000E+04, 3.1410646483E+01, 5.0110636904E+00, 1.3180310000E+01, 3.2545142232E+00, 9.6229346024E-01],
	[4.0795000000E+04, 3.1417345948E+01, 5.0110955034E+00, 1.3185557236E+01, 3.2549193989E+00, 9.6230844265E-01],
	[4.0800000000E+04, 3.1424046022E+01, 5.0111273127E+00, 1.3190805917E+01, 3.2553244831E+00, 9.6232341832E-01],
	[4.0805000000E+04, 3.1430746703E+01, 5.0111591183E+00, 1.3196056042E+01, 3.2557294757E+00, 9.6233838725E-01],
	[4.0810000000E+04, 3.1437447991E+01, 5.0111909203E+00, 1.3201307613E+01, 3.2561343767E+00, 9.6235334945E-01],
	[4.0815000000E+04, 3.1444149887E+01, 5.0112227185E+00, 1.3206560629E+01, 3.2565391863E+00, 9.6236830493E-01],
	[4.0820000000E+04, 3.1450852390E+01, 5.0112545130E+00, 1.3211815090E+01, 3.2569439043E+00, 9.6238325368E-01],
	[4.0825000000E+04, 3.1457555501E+01, 5.0112863039E+00, 1.3217070997E+01, 3.2573485308E+00, 9.6239819571E-01],
	[4.0830000000E+04, 3.1464259220E+01, 5.0113180910E+00, 1.3222328350E+01, 3.2577530659E+00, 9.6241313103E-01],
	[4.0835000000E+04, 3.1470963546E+01, 5.0113498745E+00, 1.3227587149E+01, 3.2581575095E+00, 9.6242805962E-01],
	[4.0840000000E+04, 3.1477668479E+01, 5.0113816542E+00, 1.3232847395E+01, 3.2585618616E+00, 9.6244298151E-01],
	[4.0845000000E+04, 3.1484374020E+01, 5.0114134303E+00, 1.3238109087E+01, 3.2589661222E+00, 9.6245789669E-01],
	[4.0850000000E+04, 3.1491080168E+01, 5.0114452027E+00, 1.3243372226E+01, 3.2593702915E+00, 9.6247280516E-01],
	[4.0855000000E+04, 3.1497786923E+01, 5.0114769714E+00, 1.3248636812E+01, 3.2597743693E+00, 9.6248770693E-01],
	[4.0860000000E+04, 3.1504494286E+01, 5.0115087364E+00, 1.3253902845E+01, 3.2601783557E+00, 9.6250260200E-01],
	[4.0865000000E+04, 3.1511202256E+01, 5.0115404978E+00, 1.3259170326E+01, 3.2605822507E+00, 9.6251749037E-01],
	[4.0870000000E+04, 3.1517910833E+01, 5.0115722554E+00, 1.3264439254E+01, 3.2609860543E+00, 9.6253237206E-01],
	[4.0875000000E+04, 3.1524620018E+01, 5.0116040094E+00, 1.3269709631E+01, 3.2613897666E+00, 9.6254724705E-01],
	[4.0880000000E+04, 3.1531329810E+01, 5.0116357596E+00, 1.3274981455E+01, 3.2617933875E+00, 9.6256211536E-01],
	[4.0885000000E+04, 3.1538040209E+01, 5.0116675062E+00, 1.3280254728E+01, 3.2621969170E+00, 9.6257697698E-01],
	[4.0890000000E+04, 3.1544751216E+01, 5.0116992492E+00, 1.3285529449E+01, 3.2626003553E+00, 9.6259183192E-01],
	[4.0895000000E+04, 3.1551462830E+01, 5.0117309884E+00, 1.3290805620E+01, 3.2630037022E+00, 9.6260668019E-01],
	[4.0900000000E+04, 3.1558175050E+01, 5.0117627240E+00, 1.3296083239E+01, 3.2634069577E+00, 9.6262152178E-01],
	[4.0905000000E+04, 3.1564887878E+01, 5.0117944558E+00, 1.3301362307E+01, 3.2638101220E+00, 9.6263635670E-01],
	[4.0910000000E+04, 3.1571601314E+01, 5.0118261840E+00, 1.3306642825E+01, 3.2642131951E+00, 9.6265118496E-01],
	[4.0915000000E+04, 3.1578315356E+01, 5.0118579086E+00, 1.3311924793E+01, 3.2646161768E+00, 9.6266600655E-01],
	[4.0920000000E+04, 3.1585030005E+01, 5.0118896294E+00, 1.3317208211E+01, 3.2650190673E+00, 9.6268082148E-01],
	[4.0925000000E+04, 3.1591745262E+01, 5.0119213466E+00, 1.3322493078E+01, 3.2654218666E+00, 9.6269562975E-01],
	[4.0930000000E+04, 3.1598461126E+01, 5.0119530601E+00, 1.3327779396E+01, 3.2658245746E+00, 9.6271043137E-01],
	[4.0935000000E+04, 3.1605177596E+01, 5.0119847699E+00, 1.3333067165E+01, 3.2662271914E+00, 9.6272522634E-01],
	[4.0940000000E+04, 3.1611894674E+01, 5.0120164761E+00, 1.3338356385E+01, 3.2666297170E+00, 9.6274001465E-01],
	[4.0945000000E+04, 3.1618612359E+01, 5.0120481785E+00, 1.3343647055E+01, 3.2670321514E+00, 9.6275479633E-01],
	[4.0950000000E+04, 3.1625330651E+01, 5.0120798774E+00, 1.3348939177E+01, 3.2674344947E+00, 9.6276957136E-01],
	[4.0955000000E+04, 3.1632049549E+01, 5.0121115725E+00, 1.3354232750E+01, 3.2678367467E+00, 9.6278433975E-01],
	[4.0960000000E+04, 3.1638769055E+01, 5.0121432640E+00, 1.3359527774E+01, 3.2682389076E+00, 9.6279910151E-01],
	[4.0965000000E+04, 3.1645489168E+01, 5.0121749518E+00, 1.3364824251E+01, 3.2686409774E+00, 9.6281385663E-01],
	[4.0970000000E+04, 3.1652209887E+01, 5.0122066359E+00, 1.3370122180E+01, 3.2690429561E+00, 9.6282860513E-01],
	[4.0975000000E+04, 3.1658931214E+01, 5.0122383164E+00, 1.3375421561E+01, 3.2694448436E+00, 9.6284334700E-01],
	[4.0980000000E+04, 3.1665653147E+01, 5.0122699932E+00, 1.3380722395E+01, 3.2698466401E+00, 9.6285808225E-01],
	[4.0985000000E+04, 3.1672375687E+01, 5.0123016663E+00, 1.3386024681E+01, 3.2702483454E+00, 9.6287281087E-01],
	[4.0990000000E+04, 3.1679098834E+01, 5.0123333358E+00, 1.3391328421E+01, 3.2706499597E+00, 9.6288753288E-01],
	[4.0995000000E+04, 3.1685822588E+01, 5.0123650016E+00, 1.3396633613E+01, 3.2710514829E+00, 9.6290224828E-01],
	[4.1000000000E+04, 3.1692546949E+01, 5.0123966638E+00, 1.3401940259E+01, 3.2714529151E+00, 9.6291695707E-01],
	[4.1005000000E+04, 3.1699271916E+01, 5.0124283223E+00, 1.3407248359E+01, 3.2718542562E+00, 9.6293165925E-01],
	[4.1010000000E+04, 3.1705997490E+01, 5.0124599771E+00, 1.3412557913E+01, 3.2722555063E+00, 9.6294635482E-01],
	[4.1015000000E+04, 3.1712723671E+01, 5.0124916283E+00, 1.3417868920E+01, 3.2726566654E+00, 9.6296104380E-01],
	[4.1020000000E+04, 3.1719450459E+01, 5.0125232758E+00, 1.3423181382E+01, 3.2730577335E+00, 9.6297572618E-01],
	[4.1025000000E+04, 3.1726177853E+01, 5.0125549197E+00, 1.3428495299E+01, 3.2734587106E+00, 9.6299040196E-01],
	[4.1030000000E+04, 3.1732905855E+01, 5.0125865599E+00, 1.3433810670E+01, 3.2738595968E+00, 9.6300507115E-01],
	[4.1035000000E+04, 3.1739634462E+01, 5.0126181964E+00, 1.3439127496E+01, 3.2742603920E+00, 9.6301973376E-01],
	[4.1040000000E+04, 3.1746363677E+01, 5.0126498293E+00, 1.3444445778E+01, 3.2746610962E+00, 9.6303438978E-01],
	[4.1045000000E+04, 3.1753093498E+01, 5.0126814585E+00, 1.3449765515E+01, 3.2750617095E+00, 9.6304903921E-01],
	[4.1050000000E+04, 3.1759823926E+01, 5.0127130841E+00, 1.3455086707E+01, 3.2754622319E+00, 9.6306368207E-01],
	[4.1055000000E+04, 3.1766554960E+01, 5.0127447060E+00, 1.3460409356E+01, 3.2758626634E+00, 9.6307831836E-01],
	[4.1060000000E+04, 3.1773286601E+01, 5.0127763243E+00, 1.3465733460E+01, 3.2762630040E+00, 9.6309294807E-01],
	[4.1065000000E+04, 3.1780018848E+01, 5.0128079389E+00, 1.3471059021E+01, 3.2766632537E+00, 9.6310757121E-01],
	[4.1070000000E+04, 3.1786751702E+01, 5.0128395499E+00, 1.3476386038E+01, 3.2770634126E+00, 9.6312218779E-01],
	[4.1075000000E+04, 3.1793485162E+01, 5.0128711573E+00, 1.3481714512E+01, 3.2774634806E+00, 9.6313679780E-01],
	[4.1080000000E+04, 3.1800219229E+01, 5.0129027609E+00, 1.3487044443E+01, 3.2778634577E+00, 9.6315140125E-01],
	[4.1085000000E+04, 3.1806953903E+01, 5.0129343610E+00, 1.3492375831E+01, 3.2782633440E+00, 9.6316599815E-01],
	[4.1090000000E+04, 3.1813689183E+01, 5.0129659574E+00, 1.3497708677E+01, 3.2786631396E+00, 9.6318058849E-01],
	[4.1095000000E+04, 3.1820425069E+01, 5.0129975501E+00, 1.3503042980E+01, 3.2790628443E+00, 9.6319517229E-01],
	[4.1100000000E+04, 3.1827161562E+01, 5.0130291392E+00, 1.3508378741E+01, 3.2794624582E+00, 9.6320974953E-01],
	[4.1105000000E+04, 3.1833898661E+01, 5.0130607246E+00, 1.3513715960E+01, 3.2798619814E+00, 9.6322432024E-01],
	[4.1110000000E+04, 3.1840636367E+01, 5.0130923065E+00, 1.3519054638E+01, 3.2802614138E+00, 9.6323888440E-01],
	[4.1115000000E+04, 3.1847374679E+01, 5.0131238846E+00, 1.3524394774E+01, 3.2806607554E+00, 9.6325344202E-01],
	[4.1120000000E+04, 3.1854113597E+01, 5.0131554592E+00, 1.3529736368E+01, 3.2810600063E+00, 9.6326799311E-01],
	[4.1125000000E+04, 3.1860853122E+01, 5.0131870300E+00, 1.3535079422E+01, 3.2814591665E+00, 9.6328253767E-01],
	[4.1130000000E+04, 3.1867593252E+01, 5.0132185973E+00, 1.3540423934E+01, 3.2818582360E+00, 9.6329707570E-01],
	[4.1135000000E+04, 3.1874333990E+01, 5.0132501609E+00, 1.3545769907E+01, 3.2822572148E+00, 9.6331160720E-01],
	[4.1140000000E+04, 3.1881075333E+01, 5.0132817209E+00, 1.3551117338E+01, 3.2826561029E+00, 9.6332613219E-01],
	[4.1145000000E+04, 3.1887817283E+01, 5.0133132772E+00, 1.3556466230E+01, 3.2830549003E+00, 9.6334065065E-01],
	[4.1150000000E+04, 3.1894559839E+01, 5.0133448299E+00, 1.3561816582E+01, 3.2834536071E+00, 9.6335516260E-01],
	[4.1155000000E+04, 3.1901303001E+01, 5.0133763790E+00, 1.3567168393E+01, 3.2838522232E+00, 9.6336966804E-01],
	[4.1160000000E+04, 3.1908046769E+01, 5.0134079244E+00, 1.3572521666E+01, 3.2842507487E+00, 9.6338416696E-01],
	[4.1165000000E+04, 3.1914799336E+01, 5.0134405439E+00, 1.3577876399E+01, 3.2846497330E+00, 9.6339865938E-01],
	[4.1170000000E+04, 3.1921559927E+01, 5.0134741351E+00, 1.3583232593E+01, 3.2850491242E+00, 9.6341314530E-01],
	[4.1175000000E+04, 3.1928321128E+01, 5.0135077225E+00, 1.3588590248E+01, 3.2854484250E+00, 9.6342762472E-01],
	[4.1180000000E+04, 3.1935082941E+01, 5.0135413060E+00, 1.3593949365E+01, 3.2858476356E+00, 9.6344209764E-01],
	[4.1185000000E+04, 3.1941845364E+01, 5.0135748856E+00, 1.3599309943E+01, 3.2862467560E+00, 9.6345656407E-01],
	[4.1190000000E+04, 3.1948608399E+01, 5.0136084614E+00, 1.3604671983E+01, 3.2866457861E+00, 9.6347102400E-01],
	[4.1195000000E+04, 3.1955372044E+01, 5.0136420334E+00, 1.3610035485E+01, 3.2870447259E+00, 9.6348547745E-01],
	[4.1200000000E+04, 3.1962136299E+01, 5.0136756014E+00, 1.3615400449E+01, 3.2874435755E+00, 9.6349992442E-01],
	[4.1205000000E+04, 3.1968901166E+01, 5.0137091657E+00, 1.3620766876E+01, 3.2878423349E+00, 9.6351436490E-01],
	[4.1210000000E+04, 3.1975666643E+01, 5.0137427261E+00, 1.3626134765E+01, 3.2882410042E+00, 9.6352879891E-01],
	[4.1215000000E+04, 3.1982432731E+01, 5.0137762826E+00, 1.3631504118E+01, 3.2886395832E+00, 9.6354322644E-01],
	[4.1220000000E+04, 3.1989199429E+01, 5.0138098353E+00, 1.3636874933E+01, 3.2890380720E+00, 9.6355764750E-01],
	[4.1225000000E+04, 3.1995966739E+01, 5.0138433842E+00, 1.3642247212E+01, 3.2894364708E+00, 9.6357206209E-01],
	[4.1230000000E+04, 3.2002734658E+01, 5.0138769292E+00, 1.3647620955E+01, 3.2898347793E+00, 9.6358647022E-01],
	[4.1235000000E+04, 3.2009503189E+01, 5.0139104704E+00, 1.3652996161E+01, 3.2902329977E+00, 9.6360087188E-01],
	[4.1240000000E+04, 3.2016272330E+01, 5.0139440077E+00, 1.3658372831E+01, 3.2906311260E+00, 9.6361526708E-01],
	[4.1245000000E+04, 3.2023042081E+01, 5.0139775412E+00, 1.3663750966E+01, 3.2910291642E+00, 9.6362965583E-01],
	[4.1250000000E+04, 3.2029812444E+01, 5.0140110708E+00, 1.3669130565E+01, 3.2914271124E+00, 9.6364403812E-01],
	[4.1255000000E+04, 3.2036583416E+01, 5.0140445966E+00, 1.3674511628E+01, 3.2918249704E+00, 9.6365841397E-01],
	[4.1260000000E+04, 3.2043355000E+01, 5.0140781186E+00, 1.3679894157E+01, 3.2922227384E+00, 9.6367278337E-01],
	[4.1265000000E+04, 3.2050127193E+01, 5.0141116367E+00, 1.3685278151E+01, 3.2926204163E+00, 9.6368714632E-01],
	[4.1270000000E+04, 3.2056899998E+01, 5.0141451510E+00, 1.3690663610E+01, 3.2930180041E+00, 9.6370150284E-01],
	[4.1275000000E+04, 3.2063673412E+01, 5.0141786615E+00, 1.3696050534E+01, 3.2934155020E+00, 9.6371585291E-01],
	[4.1280000000E+04, 3.2070447437E+01, 5.0142121681E+00, 1.3701438925E+01, 3.2938129098E+00, 9.6373019655E-01],
	[4.1285000000E+04, 3.2077222073E+01, 5.0142456709E+00, 1.3706828781E+01, 3.2942102277E+00, 9.6374453377E-01],
	[4.1290000000E+04, 3.2083997319E+01, 5.0142791698E+00, 1.3712220104E+01, 3.2946074555E+00, 9.6375886455E-01],
	[4.1295000000E+04, 3.2090773175E+01, 5.0143126649E+00, 1.3717612893E+01, 3.2950045934E+00, 9.6377318891E-01],
	[4.1300000000E+04, 3.2097549642E+01, 5.0143461562E+00, 1.3723007149E+01, 3.2954016413E+00, 9.6378750684E-01],
	[4.1305000000E+04, 3.2104326719E+01, 5.0143796437E+00, 1.3728402872E+01, 3.2957985993E+00, 9.6380181836E-01],
	[4.1310000000E+04, 3.2111104406E+01, 5.0144131273E+00, 1.3733800062E+01, 3.2961954674E+00, 9.6381612346E-01],
	[4.1315000000E+04, 3.2117882704E+01, 5.0144466071E+00, 1.3739198719E+01, 3.2965922455E+00, 9.6383042215E-01],
	[4.1320000000E+04, 3.2124661612E+01, 5.0144800831E+00, 1.3744598843E+01, 3.2969889337E+00, 9.6384471444E-01],
	[4.1325000000E+04, 3.2131441130E+01, 5.0145135552E+00, 1.3750000436E+01, 3.2973855320E+00, 9.6385900031E-01],
	[4.1330000000E+04, 3.2138221259E+01, 5.0145470235E+00, 1.3755403496E+01, 3.2977820405E+00, 9.6387327978E-01],
	[4.1335000000E+04, 3.2145001998E+01, 5.0145804880E+00, 1.3760808025E+01, 3.2981784591E+00, 9.6388755285E-01],
	[4.1340000000E+04, 3.2151783347E+01, 5.0146139487E+00, 1.3766214022E+01, 3.2985747878E+00, 9.6390181953E-01],
	[4.1345000000E+04, 3.2158565306E+01, 5.0146474055E+00, 1.3771621488E+01, 3.2989710267E+00, 9.6391607981E-01],
	[4.1350000000E+04, 3.2165347875E+01, 5.0146808586E+00, 1.3777030423E+01, 3.2993671758E+00, 9.6393033370E-01],
	[4.1355000000E+04, 3.2172131055E+01, 5.0147143078E+00, 1.3782440827E+01, 3.2997632350E+00, 9.6394458120E-01],
	[4.1360000000E+04, 3.2178914845E+01, 5.0147477531E+00, 1.3787852700E+01, 3.3001592045E+00, 9.6395882232E-01],
	[4.1365000000E+04, 3.2185699244E+01, 5.0147811947E+00, 1.3793266043E+01, 3.3005550841E+00, 9.6397305706E-01],
	[4.1370000000E+04, 3.2192484254E+01, 5.0148146324E+00, 1.3798680855E+01, 3.3009508740E+00, 9.6398728542E-01],
	[4.1375000000E+04, 3.2199269874E+01, 5.0148480664E+00, 1.3804097137E+01, 3.3013465742E+00, 9.6400150740E-01],
	[4.1380000000E+04, 3.2206056104E+01, 5.0148814965E+00, 1.3809514890E+01, 3.3017421846E+00, 9.6401572301E-01],
	[4.1385000000E+04, 3.2212842944E+01, 5.0149149227E+00, 1.3814934113E+01, 3.3021377053E+00, 9.6402993225E-01],
	[4.1390000000E+04, 3.2219630395E+01, 5.0149483452E+00, 1.3820354807E+01, 3.3025331362E+00, 9.6404413513E-01],
	[4.1395000000E+04, 3.2226418455E+01, 5.0149817639E+00, 1.3825776972E+01, 3.3029284775E+00, 9.6405833164E-01],
	[4.1400000000E+04, 3.2233207125E+01, 5.0150151787E+00, 1.3831200607E+01, 3.3033237290E+00, 9.6407252180E-01],
	[4.1405000000E+04, 3.2239996405E+01, 5.0150485897E+00, 1.3836625714E+01, 3.3037188909E+00, 9.6408670560E-01],
	[4.1410000000E+04, 3.2246786295E+01, 5.0150819970E+00, 1.3842052293E+01, 3.3041139631E+00, 9.6410088304E-01],
	[4.1415000000E+04, 3.2253576795E+01, 5.0151154004E+00, 1.3847480343E+01, 3.3045089457E+00, 9.6411505414E-01],
	[4.1420000000E+04, 3.2260367905E+01, 5.0151488000E+00, 1.3852909865E+01, 3.3049038386E+00, 9.6412921888E-01],
	[4.1425000000E+04, 3.2267159625E+01, 5.0151821958E+00, 1.3858340860E+01, 3.3052986419E+00, 9.6414337729E-01],
	[4.1430000000E+04, 3.2273951954E+01, 5.0152155877E+00, 1.3863773327E+01, 3.3056933556E+00, 9.6415752935E-01],
	[4.1435000000E+04, 3.2280744894E+01, 5.0152489759E+00, 1.3869207266E+01, 3.3060879797E+00, 9.6417167507E-01],
	[4.1440000000E+04, 3.2287538443E+01, 5.0152823603E+00, 1.3874642679E+01, 3.3064825142E+00, 9.6418581446E-01],
	[4.1445000000E+04, 3.2294332603E+01, 5.0153157408E+00, 1.3880079564E+01, 3.3068769591E+00, 9.6419994752E-01],
	[4.1450000000E+04, 3.2301127372E+01, 5.0153491176E+00, 1.3885517923E+01, 3.3072713145E+00, 9.6421407425E-01],
	[4.1455000000E+04, 3.2307922750E+01, 5.0153824905E+00, 1.3890957755E+01, 3.3076655804E+00, 9.6422819465E-01],
	[4.1460000000E+04, 3.2314718739E+01, 5.0154158597E+00, 1.3896399061E+01, 3.3080597567E+00, 9.6424230873E-01],
	[4.1465000000E+04, 3.2321515337E+01, 5.0154492250E+00, 1.3901841842E+01, 3.3084538435E+00, 9.6425641649E-01],
	[4.1470000000E+04, 3.2328312545E+01, 5.0154825866E+00, 1.3907286096E+01, 3.3088478408E+00, 9.6427051794E-01],
	[4.1475000000E+04, 3.2335110363E+01, 5.0155159443E+00, 1.3912731824E+01, 3.3092417486E+00, 9.6428461307E-01],
	[4.1480000000E+04, 3.2341908791E+01, 5.0155492983E+00, 1.3918179028E+01, 3.3096355670E+00, 9.6429870189E-01],
	[4.1485000000E+04, 3.2348707828E+01, 5.0155826484E+00, 1.3923627706E+01, 3.3100292958E+00, 9.6431278441E-01],
	[4.1490000000E+04, 3.2355507475E+01, 5.0156159948E+00, 1.3929077859E+01, 3.3104229353E+00, 9.6432686062E-01],
	[4.1495000000E+04, 3.2362307731E+01, 5.0156493373E+00, 1.3934529487E+01, 3.3108164853E+00, 9.6434093053E-01],
	[4.1500000000E+04, 3.2369108597E+01, 5.0156826761E+00, 1.3939982591E+01, 3.3112099459E+00, 9.6435499414E-01],
	[4.1505000000E+04, 3.2375910073E+01, 5.0157160111E+00, 1.3945437171E+01, 3.3116033170E+00, 9.6436905146E-01],
	[4.1510000000E+04, 3.2382712158E+01, 5.0157493422E+00, 1.3950893227E+01, 3.3119965988E+00, 9.6438310248E-01],
	[4.1515000000E+04, 3.2389514853E+01, 5.0157826696E+00, 1.3956350759E+01, 3.3123897912E+00, 9.6439714722E-01],
	[4.1520000000E+04, 3.2396318157E+01, 5.0158159932E+00, 1.3961809767E+01, 3.3127828943E+00, 9.6441118567E-01],
	[4.1525000000E+04, 3.2403122071E+01, 5.0158493130E+00, 1.3967270252E+01, 3.3131759079E+00, 9.6442521784E-01],
	[4.1530000000E+04, 3.2409926594E+01, 5.0158826290E+00, 1.3972732214E+01, 3.3135688323E+00, 9.6443924373E-01],
	[4.1535000000E+04, 3.2416731727E+01, 5.0159159412E+00, 1.3978195653E+01, 3.3139616673E+00, 9.6445326334E-01],
	[4.1540000000E+04, 3.2423537469E+01, 5.0159492496E+00, 1.3983660569E+01, 3.3143544130E+00, 9.6446727668E-01],
	[4.1545000000E+04, 3.2430343821E+01, 5.0159825542E+00, 1.3989126962E+01, 3.3147470695E+00, 9.6448128375E-01],
	[4.1550000000E+04, 3.2437150782E+01, 5.0160158551E+00, 1.3994594834E+01, 3.3151396366E+00, 9.6449528456E-01],
	[4.1555000000E+04, 3.2443958352E+01, 5.0160491522E+00, 1.4000064183E+01, 3.3155321145E+00, 9.6450927910E-01],
	[4.1560000000E+04, 3.2450766532E+01, 5.0160824454E+00, 1.4005535010E+01, 3.3159245031E+00, 9.6452326737E-01],
	[4.1565000000E+04, 3.2457575322E+01, 5.0161157349E+00, 1.4011007316E+01, 3.3163168024E+00, 9.6453724939E-01],
	[4.1570000000E+04, 3.2464384720E+01, 5.0161490206E+00, 1.4016481101E+01, 3.3167090126E+00, 9.6455122516E-01],
	[4.1575000000E+04, 3.2471194728E+01, 5.0161823026E+00, 1.4021956364E+01, 3.3171011335E+00, 9.6456519468E-01],
	[4.1580000000E+04, 3.2478005346E+01, 5.0162155807E+00, 1.4027433106E+01, 3.3174931652E+00, 9.6457915794E-01],
	[4.1585000000E+04, 3.2484816572E+01, 5.0162488551E+00, 1.4032911328E+01, 3.3178851078E+00, 9.6459311496E-01],
	[4.1590000000E+04, 3.2491628408E+01, 5.0162821257E+00, 1.4038391029E+01, 3.3182769611E+00, 9.6460706574E-01],
	[4.1595000000E+04, 3.2498440853E+01, 5.0163153925E+00, 1.4043872210E+01, 3.3186687253E+00, 9.6462101028E-01],
	[4.1600000000E+04, 3.2505253908E+01, 5.0163486555E+00, 1.4049354870E+01, 3.3190604004E+00, 9.6463494858E-01],
	[4.1605000000E+04, 3.2512067571E+01, 5.0163819147E+00, 1.4054839011E+01, 3.3194519863E+00, 9.6464888065E-01],
	[4.1610000000E+04, 3.2518881844E+01, 5.0164151702E+00, 1.4060324633E+01, 3.3198434831E+00, 9.6466280649E-01],
	[4.1615000000E+04, 3.2525696726E+01, 5.0164484219E+00, 1.4065811735E+01, 3.3202348909E+00, 9.6467672610E-01],
	[4.1620000000E+04, 3.2532512217E+01, 5.0164816698E+00, 1.4071300317E+01, 3.3206262095E+00, 9.6469063948E-01],
	[4.1625000000E+04, 3.2539328318E+01, 5.0165149140E+00, 1.4076790381E+01, 3.3210174390E+00, 9.6470454665E-01],
	[4.1630000000E+04, 3.2546145027E+01, 5.0165481544E+00, 1.4082281926E+01, 3.3214085795E+00, 9.6471844760E-01],
	[4.1635000000E+04, 3.2552962345E+01, 5.0165813910E+00, 1.4087774953E+01, 3.3217996309E+00, 9.6473234233E-01],
	[4.1640000000E+04, 3.2559780273E+01, 5.0166146238E+00, 1.4093269461E+01, 3.3221905933E+00, 9.6474623085E-01],
	[4.1645000000E+04, 3.2566598810E+01, 5.0166478529E+00, 1.4098765451E+01, 3.3225814667E+00, 9.6476011317E-01],
	[4.1650000000E+04, 3.2573417956E+01, 5.0166810782E+00, 1.4104262923E+01, 3.3229722511E+00, 9.6477398927E-01],
	[4.1655000000E+04, 3.2580237710E+01, 5.0167142997E+00, 1.4109761878E+01, 3.3233629464E+00, 9.6478785918E-01],
	[4.1660000000E+04, 3.2587058074E+01, 5.0167475175E+00, 1.4115262315E+01, 3.3237535528E+00, 9.6480172288E-01],
	[4.1665000000E+04, 3.2593879047E+01, 5.0167807315E+00, 1.4120764236E+01, 3.3241440702E+00, 9.6481558039E-01],
	[4.1670000000E+04, 3.2600700629E+01, 5.0168139417E+00, 1.4126267639E+01, 3.3245344987E+00, 9.6482943170E-01],
	[4.1675000000E+04, 3.2607522819E+01, 5.0168471481E+00, 1.4131772525E+01, 3.3249248383E+00, 9.6484327683E-01],
	[4.1680000000E+04, 3.2614345619E+01, 5.0168803508E+00, 1.4137278895E+01, 3.3253150889E+00, 9.6485711576E-01],
	[4.1685000000E+04, 3.2621169028E+01, 5.0169135498E+00, 1.4142786749E+01, 3.3257052506E+00, 9.6487094851E-01],
	[4.1690000000E+04, 3.2627993045E+01, 5.0169467450E+00, 1.4148296086E+01, 3.3260953234E+00, 9.6488477508E-01],
	[4.1695000000E+04, 3.2634817672E+01, 5.0169799364E+00, 1.4153806908E+01, 3.3264853073E+00, 9.6489859548E-01],
	[4.1700000000E+04, 3.2641642907E+01, 5.0170131240E+00, 1.4159319214E+01, 3.3268752024E+00, 9.6491240969E-01],
	[4.1705000000E+04, 3.2648468751E+01, 5.0170463079E+00, 1.4164833004E+01, 3.3272650086E+00, 9.6492621774E-01],
	[4.1710000000E+04, 3.2655295204E+01, 5.0170794880E+00, 1.4170348280E+01, 3.3276547259E+00, 9.6494001961E-01],
	[4.1715000000E+04, 3.2662122265E+01, 5.0171126644E+00, 1.4175865040E+01, 3.3280443545E+00, 9.6495381532E-01],
	[4.1720000000E+04, 3.2668949936E+01, 5.0171458370E+00, 1.4181383286E+01, 3.3284338942E+00, 9.6496760487E-01],
	[4.1725000000E+04, 3.2675778215E+01, 5.0171790059E+00, 1.4186903017E+01, 3.3288233451E+00, 9.6498138826E-01],
	[4.1730000000E+04, 3.2682607103E+01, 5.0172121710E+00, 1.4192424234E+01, 3.3292127072E+00, 9.6499516549E-01],
	[4.1735000000E+04, 3.2689436600E+01, 5.0172453324E+00, 1.4197946937E+01, 3.3296019806E+00, 9.6500893656E-01],
	[4.1740000000E+04, 3.2696266706E+01, 5.0172784900E+00, 1.4203471126E+01, 3.3299911652E+00, 9.6502270149E-01],
	[4.1745000000E+04, 3.2703097420E+01, 5.0173116438E+00, 1.4208996801E+01, 3.3303802611E+00, 9.6503646026E-01],
	[4.1750000000E+04, 3.2709928743E+01, 5.0173447939E+00, 1.4214523963E+01, 3.3307692682E+00, 9.6505021289E-01],
	[4.1755000000E+04, 3.2716760674E+01, 5.0173779402E+00, 1.4220052612E+01, 3.3311581867E+00, 9.6506395938E-01],
	[4.1760000000E+04, 3.2723593214E+01, 5.0174110828E+00, 1.4225582747E+01, 3.3315470164E+00, 9.6507769973E-01],
	[4.1765000000E+04, 3.2730426363E+01, 5.0174442217E+00, 1.4231114370E+01, 3.3319357574E+00, 9.6509143395E-01],
	[4.1770000000E+04, 3.2737260120E+01, 5.0174773568E+00, 1.4236647481E+01, 3.3323244098E+00, 9.6510516203E-01],
	[4.1775000000E+04, 3.2744094486E+01, 5.0175104881E+00, 1.4242182079E+01, 3.3327129735E+00, 9.6511888398E-01],
	[4.1780000000E+04, 3.2750929461E+01, 5.0175436157E+00, 1.4247718165E+01, 3.3331014485E+00, 9.6513259981E-01],
	[4.1785000000E+04, 3.2757765044E+01, 5.0175767396E+00, 1.4253255739E+01, 3.3334898350E+00, 9.6514630951E-01],
	[4.1790000000E+04, 3.2764601236E+01, 5.0176098597E+00, 1.4258794801E+01, 3.3338781328E+00, 9.6516001310E-01],
	[4.1795000000E+04, 3.2771438036E+01, 5.0176429761E+00, 1.4264335353E+01, 3.3342663420E+00, 9.6517371056E-01],
	[4.1800000000E+04, 3.2778275444E+01, 5.0176760887E+00, 1.4269877392E+01, 3.3346544626E+00, 9.6518740191E-01],
	[4.1805000000E+04, 3.2785113461E+01, 5.0177091976E+00, 1.4275420921E+01, 3.3350424947E+00, 9.6520108715E-01],
	[4.1810000000E+04, 3.2791952087E+01, 5.0177423027E+00, 1.4280965939E+01, 3.3354304382E+00, 9.6521476628E-01],
	[4.1815000000E+04, 3.2798791321E+01, 5.0177754041E+00, 1.4286512447E+01, 3.3358182931E+00, 9.6522843930E-01],
	[4.1820000000E+04, 3.2805631163E+01, 5.0178085018E+00, 1.4292060444E+01, 3.3362060595E+00, 9.6524210622E-01],
	[4.1825000000E+04, 3.2812471614E+01, 5.0178415957E+00, 1.4297609931E+01, 3.3365937374E+00, 9.6525576705E-01],
	[4.1830000000E+04, 3.2819328087E+01, 5.0178766803E+00, 1.4303160909E+01, 3.3369823682E+00, 9.6526942177E-01],
	[4.1835000000E+04, 3.2826185278E+01, 5.0179117745E+00, 1.4308713376E+01, 3.3373709178E+00, 9.6528307040E-01],
	[4.1840000000E+04, 3.2833043082E+01, 5.0179468647E+00, 1.4314267334E+01, 3.3377593792E+00, 9.6529671295E-01],
	[4.1845000000E+04, 3.2839901498E+01, 5.0179819510E+00, 1.4319822783E+01, 3.3381477525E+00, 9.6531034940E-01],
	[4.1850000000E+04, 3.2846760528E+01, 5.0180170334E+00, 1.4325379723E+01, 3.3385360376E+00, 9.6532397977E-01],
	[4.1855000000E+04, 3.2853620170E+01, 5.0180521117E+00, 1.4330938155E+01, 3.3389242345E+00, 9.6533760406E-01],
	[4.1860000000E+04, 3.2860480425E+01, 5.0180871862E+00, 1.4336498077E+01, 3.3393123433E+00, 9.6535122227E-01],
	[4.1865000000E+04, 3.2867341294E+01, 5.0181222567E+00, 1.4342059492E+01, 3.3397003640E+00, 9.6536483441E-01],
	[4.1870000000E+04, 3.2874202775E+01, 5.0181573233E+00, 1.4347622398E+01, 3.3400882966E+00, 9.6537844047E-01],
	[4.1875000000E+04, 3.2881064869E+01, 5.0181923859E+00, 1.4353186796E+01, 3.3404761410E+00, 9.6539204046E-01],
	[4.1880000000E+04, 3.2887927575E+01, 5.0182274446E+00, 1.4358752687E+01, 3.3408638974E+00, 9.6540563439E-01],
	[4.1885000000E+04, 3.2894790895E+01, 5.0182624993E+00, 1.4364320070E+01, 3.3412515658E+00, 9.6541922225E-01],
	[4.1890000000E+04, 3.2901654827E+01, 5.0182975501E+00, 1.4369888946E+01, 3.3416391461E+00, 9.6543280406E-01],
	[4.1895000000E+04, 3.2908519372E+01, 5.0183325970E+00, 1.4375459316E+01, 3.3420266383E+00, 9.6544637980E-01],
	[4.1900000000E+04, 3.2915384530E+01, 5.0183676399E+00, 1.4381031178E+01, 3.3424140425E+00, 9.6545994950E-01],
	[4.1905000000E+04, 3.2922250301E+01, 5.0184026789E+00, 1.4386604534E+01, 3.3428013587E+00, 9.6547351314E-01],
	[4.1910000000E+04, 3.2929116684E+01, 5.0184377139E+00, 1.4392179383E+01, 3.3431885869E+00, 9.6548707073E-01],
	[4.1915000000E+04, 3.2935983680E+01, 5.0184727450E+00, 1.4397755726E+01, 3.3435757272E+00, 9.6550062228E-01],
	[4.1920000000E+04, 3.2942851288E+01, 5.0185077722E+00, 1.4403333564E+01, 3.3439627794E+00, 9.6551416778E-01],
	[4.1925000000E+04, 3.2949719510E+01, 5.0185427955E+00, 1.4408912895E+01, 3.3443497437E+00, 9.6552770725E-01],
	[4.1930000000E+04, 3.2956588343E+01, 5.0185778148E+00, 1.4414493722E+01, 3.3447366201E+00, 9.6554124068E-01],
	[4.1935000000E+04, 3.2963457790E+01, 5.0186128302E+00, 1.4420076043E+01, 3.3451234085E+00, 9.6555476808E-01],
	[4.1940000000E+04, 3.2970327849E+01, 5.0186478416E+00, 1.4425659859E+01, 3.3455101090E+00, 9.6556828944E-01],
	[4.1945000000E+04, 3.2977198521E+01, 5.0186828491E+00, 1.4431245170E+01, 3.3458967217E+00, 9.6558180478E-01],
	[4.1950000000E+04, 3.2984069805E+01, 5.0187178527E+00, 1.4436831977E+01, 3.3462832464E+00, 9.6559531410E-01],
	[4.1955000000E+04, 3.2990941702E+01, 5.0187528524E+00, 1.4442420279E+01, 3.3466696833E+00, 9.6560881739E-01],
	[4.1960000000E+04, 3.2997814211E+01, 5.0187878482E+00, 1.4448010078E+01, 3.3470560323E+00, 9.6562231467E-01],
	[4.1965000000E+04, 3.3004687333E+01, 5.0188228400E+00, 1.4453601372E+01, 3.3474422935E+00, 9.6563580593E-01],
	[4.1970000000E+04, 3.3011561067E+01, 5.0188578279E+00, 1.4459194163E+01, 3.3478284668E+00, 9.6564929118E-01],
	[4.1975000000E+04, 3.3018435414E+01, 5.0188928118E+00, 1.4464788450E+01, 3.3482145524E+00, 9.6566277042E-01],
	[4.1980000000E+04, 3.3025310373E+01, 5.0189277919E+00, 1.4470384234E+01, 3.3486005501E+00, 9.6567624365E-01],
	[4.1985000000E+04, 3.3032185945E+01, 5.0189627680E+00, 1.4475981515E+01, 3.3489864601E+00, 9.6568971088E-01],
	[4.1990000000E+04, 3.3039062129E+01, 5.0189977402E+00, 1.4481580294E+01, 3.3493722822E+00, 9.6570317211E-01],
	[4.1995000000E+04, 3.3045938925E+01, 5.0190327085E+00, 1.4487180569E+01, 3.3497580167E+00, 9.6571662734E-01],
	[4.2000000000E+04, 3.3052816334E+01, 5.0190676728E+00, 1.4492782343E+01, 3.3501436634E+00, 9.6573007657E-01],
	[4.2005000000E+04, 3.3059694355E+01, 5.0191026333E+00, 1.4498385614E+01, 3.3505292223E+00, 9.6574351982E-01],
	[4.2010000000E+04, 3.3066572989E+01, 5.0191375898E+00, 1.4503990383E+01, 3.3509146936E+00, 9.6575695708E-01],
	[4.2015000000E+04, 3.3073452234E+01, 5.0191725424E+00, 1.4509596651E+01, 3.3513000771E+00, 9.6577038835E-01],
	[4.2020000000E+04, 3.3080332092E+01, 5.0192074911E+00, 1.4515204417E+01, 3.3516853730E+00, 9.6578381364E-01],
	[4.2025000000E+04, 3.3087212563E+01, 5.0192424359E+00, 1.4520813682E+01, 3.3520705811E+00, 9.6579723295E-01],
	[4.2030000000E+04, 3.3094093646E+01, 5.0192773767E+00, 1.4526424447E+01, 3.3524557017E+00, 9.6581064628E-01],
	[4.2035000000E+04, 3.3100975340E+01, 5.0193123137E+00, 1.4532036710E+01, 3.3528407346E+00, 9.6582405364E-01],
	[4.2040000000E+04, 3.3107857648E+01, 5.0193472467E+00, 1.4537650472E+01, 3.3532256798E+00, 9.6583745503E-01],
	[4.2045000000E+04, 3.3114740567E+01, 5.0193821758E+00, 1.4543265735E+01, 3.3536105375E+00, 9.6585085046E-01],
	[4.2050000000E+04, 3.3121624099E+01, 5.0194171010E+00, 1.4548882497E+01, 3.3539953075E+00, 9.6586423991E-01],
	[4.2055000000E+04, 3.3128508242E+01, 5.0194520223E+00, 1.4554500759E+01, 3.3543799900E+00, 9.6587762341E-01],
	[4.2060000000E+04, 3.3135392998E+01, 5.0194869397E+00, 1.4560120522E+01, 3.3547645848E+00, 9.6589100095E-01],
	[4.2065000000E+04, 3.3142278366E+01, 5.0195218532E+00, 1.4565741785E+01, 3.3551490922E+00, 9.6590437253E-01],
	[4.2070000000E+04, 3.3149164346E+01, 5.0195567628E+00, 1.4571364549E+01, 3.3555335120E+00, 9.6591773816E-01],
	[4.2075000000E+04, 3.3156050938E+01, 5.0195916685E+00, 1.4576988814E+01, 3.3559178442E+00, 9.6593109784E-01],
	[4.2080000000E+04, 3.3162938143E+01, 5.0196265703E+00, 1.4582614580E+01, 3.3563020890E+00, 9.6594445157E-01],
	[4.2085000000E+04, 3.3169825959E+01, 5.0196614681E+00, 1.4588241848E+01, 3.3566862462E+00, 9.6595779936E-01],
	[4.2090000000E+04, 3.3176714388E+01, 5.0196963621E+00, 1.4593870617E+01, 3.3570703159E+00, 9.6597114121E-01],
	[4.2095000000E+04, 3.3183603428E+01, 5.0197312521E+00, 1.4599500888E+01, 3.3574542982E+00, 9.6598447712E-01],
	[4.2100000000E+04, 3.3190493081E+01, 5.0197661383E+00, 1.4605132661E+01, 3.3578381931E+00, 9.6599780710E-01],
	[4.2105000000E+04, 3.3197383345E+01, 5.0198010206E+00, 1.4610765937E+01, 3.3582220004E+00, 9.6601113114E-01],
	[4.2110000000E+04, 3.3204274221E+01, 5.0198358989E+00, 1.4616400715E+01, 3.3586057204E+00, 9.6602444926E-01],
	[4.2115000000E+04, 3.3211165710E+01, 5.0198707734E+00, 1.4622036996E+01, 3.3589893529E+00, 9.6603776145E-01],
	[4.2120000000E+04, 3.3218057810E+01, 5.0199056439E+00, 1.4627674780E+01, 3.3593728981E+00, 9.6605106771E-01],
	[4.2125000000E+04, 3.3224950522E+01, 5.0199405106E+00, 1.4633314067E+01, 3.3597563558E+00, 9.6606436806E-01],
	[4.2130000000E+04, 3.3231843846E+01, 5.0199753734E+00, 1.4638954857E+01, 3.3601397262E+00, 9.6607766249E-01],
	[4.2135000000E+04, 3.3238737782E+01, 5.0200102322E+00, 1.4644597151E+01, 3.3605230092E+00, 9.6609095100E-01],
	[4.2140000000E+04, 3.3245632330E+01, 5.0200450872E+00, 1.4650240949E+01, 3.3609062049E+00, 9.6610423361E-01],
	[4.2145000000E+04, 3.3252527490E+01, 5.0200799383E+00, 1.4655886251E+01, 3.3612893133E+00, 9.6611751030E-01],
	[4.2150000000E+04, 3.3259423262E+01, 5.0201147855E+00, 1.4661533058E+01, 3.3616723343E+00, 9.6613078109E-01],
	[4.2155000000E+04, 3.3266319645E+01, 5.0201496288E+00, 1.4667181369E+01, 3.3620552681E+00, 9.6614404598E-01],
	[4.2160000000E+04, 3.3273216640E+01, 5.0201844682E+00, 1.4672831184E+01, 3.3624381145E+00, 9.6615730497E-01],
	[4.2165000000E+04, 3.3280114247E+01, 5.0202193037E+00, 1.4678482505E+01, 3.3628208737E+00, 9.6617055806E-01],
	[4.2170000000E+04, 3.3287012466E+01, 5.0202541354E+00, 1.4684135331E+01, 3.3632035456E+00, 9.6618380526E-01],
	[4.2175000000E+04, 3.3293911296E+01, 5.0202889631E+00, 1.4689789662E+01, 3.3635861303E+00, 9.6619704657E-01],
	[4.2180000000E+04, 3.3300810738E+01, 5.0203237870E+00, 1.4695445499E+01, 3.3639686278E+00, 9.6621028199E-01],
	[4.2185000000E+04, 3.3307710792E+01, 5.0203586069E+00, 1.4701102842E+01, 3.3643510380E+00, 9.6622351153E-01],
	[4.2190000000E+04, 3.3314611457E+01, 5.0203934230E+00, 1.4706761691E+01, 3.3647333611E+00, 9.6623673518E-01],
	[4.2195000000E+04, 3.3321512734E+01, 5.0204282352E+00, 1.4712422046E+01, 3.3651155969E+00, 9.6624995296E-01],
	[4.2200000000E+04, 3.3328414623E+01, 5.0204630435E+00, 1.4718083908E+01, 3.3654977456E+00, 9.6626316486E-01],
	[4.2205000000E+04, 3.3335317124E+01, 5.0204978480E+00, 1.4723747276E+01, 3.3658798072E+00, 9.6627637089E-01],
	[4.2210000000E+04, 3.3342220236E+01, 5.0205326485E+00, 1.4729412152E+01, 3.3662617816E+00, 9.6628957105E-01],
	[4.2215000000E+04, 3.3349123959E+01, 5.0205674452E+00, 1.4735078535E+01, 3.3666436688E+00, 9.6630276534E-01],
	[4.2220000000E+04, 3.3356028294E+01, 5.0206022380E+00, 1.4740746425E+01, 3.3670254690E+00, 9.6631595377E-01],
	[4.2225000000E+04, 3.3362933241E+01, 5.0206370269E+00, 1.4746415823E+01, 3.3674071821E+00, 9.6632913633E-01],
	[4.2230000000E+04, 3.3369838799E+01, 5.0206718119E+00, 1.4752086728E+01, 3.3677888080E+00, 9.6634231304E-01],
	[4.2235000000E+04, 3.3376744969E+01, 5.0207065931E+00, 1.4757759142E+01, 3.3681703469E+00, 9.6635548389E-01],
	[4.2240000000E+04, 3.3383651750E+01, 5.0207413704E+00, 1.4763433064E+01, 3.3685517988E+00, 9.6636864889E-01],
	[4.2245000000E+04, 3.3390559143E+01, 5.0207761438E+00, 1.4769108495E+01, 3.3689331636E+00, 9.6638180804E-01],
	[4.2250000000E+04, 3.3397467147E+01, 5.0208109133E+00, 1.4774785434E+01, 3.3693144414E+00, 9.6639496135E-01],
	[4.2255000000E+04, 3.3404375763E+01, 5.0208456790E+00, 1.4780463882E+01, 3.3696956322E+00, 9.6640810881E-01],
	[4.2260000000E+04, 3.3411284990E+01, 5.0208804407E+00, 1.4786143840E+01, 3.3700767360E+00, 9.6642125043E-01],
	[4.2265000000E+04, 3.3418194828E+01, 5.0209151986E+00, 1.4791825307E+01, 3.3704577528E+00, 9.6643438622E-01],
	[4.2270000000E+04, 3.3425105278E+01, 5.0209499527E+00, 1.4797508284E+01, 3.3708386826E+00, 9.6644751616E-01],
	[4.2275000000E+04, 3.3432016340E+01, 5.0209847029E+00, 1.4803192770E+01, 3.3712195255E+00, 9.6646064028E-01],
	[4.2280000000E+04, 3.3438928012E+01, 5.0210194492E+00, 1.4808878767E+01, 3.3716002814E+00, 9.6647375857E-01],
	[4.2285000000E+04, 3.3445840296E+01, 5.0210541916E+00, 1.4814566274E+01, 3.3719809504E+00, 9.6648687103E-01],
	[4.2290000000E+04, 3.3452753191E+01, 5.0210889302E+00, 1.4820255291E+01, 3.3723615325E+00, 9.6649997767E-01],
	[4.2295000000E+04, 3.3459666698E+01, 5.0211236649E+00, 1.4825945819E+01, 3.3727420277E+00, 9.6651307849E-01],
	[4.2300000000E+04, 3.3466580816E+01, 5.0211583957E+00, 1.4831637858E+01, 3.3731224361E+00, 9.6652617349E-01],
	[4.2305000000E+04, 3.3473495545E+01, 5.0211931227E+00, 1.4837331409E+01, 3.3735027575E+00, 9.6653926268E-01],
	[4.2310000000E+04, 3.3480410885E+01, 5.0212278458E+00, 1.4843026471E+01, 3.3738829922E+00, 9.6655234606E-01],
	[4.2315000000E+04, 3.3487326836E+01, 5.0212625650E+00, 1.4848723044E+01, 3.3742631399E+00, 9.6656542363E-01],
	[4.2320000000E+04, 3.3494243399E+01, 5.0212972804E+00, 1.4854421129E+01, 3.3746432009E+00, 9.6657849539E-01],
	[4.2325000000E+04, 3.3501160573E+01, 5.0213319919E+00, 1.4860120727E+01, 3.3750231750E+00, 9.6659156135E-01],
	[4.2330000000E+04, 3.3508078358E+01, 5.0213666996E+00, 1.4865821837E+01, 3.3754030624E+00, 9.6660462151E-01],
	[4.2335000000E+04, 3.3514996754E+01, 5.0214014034E+00, 1.4871524459E+01, 3.3757828630E+00, 9.6661767588E-01],
	[4.2340000000E+04, 3.3521915762E+01, 5.0214361033E+00, 1.4877228594E+01, 3.3761625768E+00, 9.6663072445E-01],
	[4.2345000000E+04, 3.3528835380E+01, 5.0214707994E+00, 1.4882934242E+01, 3.3765422039E+00, 9.6664376723E-01],
	[4.2350000000E+04, 3.3535755610E+01, 5.0215054916E+00, 1.4888641403E+01, 3.3769217442E+00, 9.6665680422E-01],
	[4.2355000000E+04, 3.3542676450E+01, 5.0215401800E+00, 1.4894350078E+01, 3.3773011978E+00, 9.6666983543E-01],
	[4.2360000000E+04, 3.3549597902E+01, 5.0215748645E+00, 1.4900060266E+01, 3.3776805647E+00, 9.6668286086E-01],
	[4.2365000000E+04, 3.3556519965E+01, 5.0216095451E+00, 1.4905771968E+01, 3.3780598449E+00, 9.6669588050E-01],
	[4.2370000000E+04, 3.3563442639E+01, 5.0216442219E+00, 1.4911485184E+01, 3.3784390385E+00, 9.6670889437E-01],
	[4.2375000000E+04, 3.3570365923E+01, 5.0216788949E+00, 1.4917199915E+01, 3.3788181453E+00, 9.6672190247E-01],
	[4.2380000000E+04, 3.3577289819E+01, 5.0217135640E+00, 1.4922916160E+01, 3.3791971656E+00, 9.6673490479E-01],
	[4.2385000000E+04, 3.3584214326E+01, 5.0217482292E+00, 1.4928633920E+01, 3.3795760992E+00, 9.6674790135E-01],
	[4.2390000000E+04, 3.3591139443E+01, 5.0217828906E+00, 1.4934353194E+01, 3.3799549462E+00, 9.6676089215E-01],
	[4.2395000000E+04, 3.3598065172E+01, 5.0218175482E+00, 1.4940073984E+01, 3.3803337065E+00, 9.6677387718E-01],
	[4.2400000000E+04, 3.3604991512E+01, 5.0218522019E+00, 1.4945796290E+01, 3.3807123803E+00, 9.6678685645E-01],
	[4.2405000000E+04, 3.3611918462E+01, 5.0218868518E+00, 1.4951520111E+01, 3.3810909675E+00, 9.6679982997E-01],
	[4.2410000000E+04, 3.3618846023E+01, 5.0219214978E+00, 1.4957245448E+01, 3.3814694682E+00, 9.6681279773E-01],
	[4.2415000000E+04, 3.3625774195E+01, 5.0219561399E+00, 1.4962972301E+01, 3.3818478823E+00, 9.6682575975E-01],
	[4.2420000000E+04, 3.3632702978E+01, 5.0219907782E+00, 1.4968700670E+01, 3.3822262099E+00, 9.6683871602E-01],
	[4.2425000000E+04, 3.3639632372E+01, 5.0220254127E+00, 1.4974430556E+01, 3.3826044510E+00, 9.6685166654E-01],
	[4.2430000000E+04, 3.3646562377E+01, 5.0220600434E+00, 1.4980161959E+01, 3.3829826055E+00, 9.6686461132E-01],
	[4.2435000000E+04, 3.3653492992E+01, 5.0220946701E+00, 1.4985894878E+01, 3.3833606736E+00, 9.6687755036E-01],
	[4.2440000000E+04, 3.3660424218E+01, 5.0221292931E+00, 1.4991629315E+01, 3.3837386552E+00, 9.6689048367E-01],
	[4.2445000000E+04, 3.3667356055E+01, 5.0221639122E+00, 1.4997365269E+01, 3.3841165504E+00, 9.6690341124E-01],
	[4.2450000000E+04, 3.3674288503E+01, 5.0221985275E+00, 1.5003102741E+01, 3.3844943591E+00, 9.6691633309E-01],
	[4.2455000000E+04, 3.3681221561E+01, 5.0222331389E+00, 1.5008841731E+01, 3.3848720814E+00, 9.6692924921E-01],
	[4.2460000000E+04, 3.3688155230E+01, 5.0222677465E+00, 1.5014582239E+01, 3.3852497173E+00, 9.6694215960E-01],
	[4.2465000000E+04, 3.3695089510E+01, 5.0223023503E+00, 1.5020324265E+01, 3.3856272668E+00, 9.6695506427E-01],
	[4.2470000000E+04, 3.3702024401E+01, 5.0223369502E+00, 1.5026067810E+01, 3.3860047299E+00, 9.6696796323E-01],
	[4.2475000000E+04, 3.3708959902E+01, 5.0223715463E+00, 1.5031812873E+01, 3.3863821066E+00, 9.6698085646E-01],
	[4.2480000000E+04, 3.3715896013E+01, 5.0224061385E+00, 1.5037559456E+01, 3.3867593970E+00, 9.6699374399E-01],
	[4.2485000000E+04, 3.3722832736E+01, 5.0224407270E+00, 1.5043307557E+01, 3.3871366010E+00, 9.6700662581E-01],
	[4.2490000000E+04, 3.3729770068E+01, 5.0224753115E+00, 1.5049057178E+01, 3.3875137187E+00, 9.6701950192E-01],
	[4.2495000000E+04, 3.3736708012E+01, 5.0225098923E+00, 1.5054808319E+01, 3.3878907501E+00, 9.6703237232E-01],
	[4.2500000000E+04, 3.3743651626E+01, 5.0225451134E+00, 1.5060560980E+01, 3.3882680394E+00, 9.6704523703E-01],
	[4.2505000000E+04, 3.3750606218E+01, 5.0225816502E+00, 1.5066315160E+01, 3.3886459477E+00, 9.6705809603E-01],
	[4.2510000000E+04, 3.3757561425E+01, 5.0226181829E+00, 1.5072070861E+01, 3.3890237700E+00, 9.6707094934E-01],
	[4.2515000000E+04, 3.3764517247E+01, 5.0226547116E+00, 1.5077828083E+01, 3.3894015062E+00, 9.6708379696E-01],
	[4.2520000000E+04, 3.3771473684E+01, 5.0226912363E+00, 1.5083586825E+01, 3.3897791566E+00, 9.6709663889E-01],
	[4.2525000000E+04, 3.3778430736E+01, 5.0227277569E+00, 1.5089347089E+01, 3.3901567209E+00, 9.6710947513E-01],
	[4.2530000000E+04, 3.3785388403E+01, 5.0227642736E+00, 1.5095108873E+01, 3.3905341993E+00, 9.6712230569E-01],
	[4.2535000000E+04, 3.3792346685E+01, 5.0228007861E+00, 1.5100872179E+01, 3.3909115918E+00, 9.6713513057E-01],
	[4.2540000000E+04, 3.3799305582E+01, 5.0228372947E+00, 1.5106637007E+01, 3.3912888984E+00, 9.6714794977E-01],
	[4.2545000000E+04, 3.3806265094E+01, 5.0228737992E+00, 1.5112403356E+01, 3.3916661191E+00, 9.6716076329E-01],
	[4.2550000000E+04, 3.3813225220E+01, 5.0229102998E+00, 1.5118171228E+01, 3.3920432539E+00, 9.6717357115E-01],
	[4.2555000000E+04, 3.3820185962E+01, 5.0229467962E+00, 1.5123940621E+01, 3.3924203029E+00, 9.6718637333E-01],
	[4.2560000000E+04, 3.3827147319E+01, 5.0229832887E+00, 1.5129711538E+01, 3.3927972660E+00, 9.6719916985E-01],
	[4.2565000000E+04, 3.3834109290E+01, 5.0230197772E+00, 1.5135483977E+01, 3.3931741432E+00, 9.6721196070E-01],
	[4.2570000000E+04, 3.3841071876E+01, 5.0230562616E+00, 1.5141257939E+01, 3.3935509347E+00, 9.6722474589E-01],
	[4.2575000000E+04, 3.3848035077E+01, 5.0230927420E+00, 1.5147033425E+01, 3.3939276403E+00, 9.6723752542E-01],
	[4.2580000000E+04, 3.3854998893E+01, 5.0231292184E+00, 1.5152810433E+01, 3.3943042602E+00, 9.6725029930E-01],
	[4.2585000000E+04, 3.3861963324E+01, 5.0231656907E+00, 1.5158588966E+01, 3.3946807942E+00, 9.6726306753E-01],
	[4.2590000000E+04, 3.3868928369E+01, 5.0232021591E+00, 1.5164369022E+01, 3.3950572425E+00, 9.6727583011E-01],
	[4.2595000000E+04, 3.3875894029E+01, 5.0232386234E+00, 1.5170150602E+01, 3.3954336051E+00, 9.6728858704E-01],
	[4.2600000000E+04, 3.3882860304E+01, 5.0232750837E+00, 1.5175933707E+01, 3.3958098819E+00, 9.6730133832E-01],
	[4.2605000000E+04, 3.3889827194E+01, 5.0233115400E+00, 1.5181718336E+01, 3.3961860730E+00, 9.6731408396E-01],
	[4.2610000000E+04, 3.3896794698E+01, 5.0233479923E+00, 1.5187504491E+01, 3.3965621784E+00, 9.6732682397E-01],
	[4.2615000000E+04, 3.3903762817E+01, 5.0233844406E+00, 1.5193292170E+01, 3.3969381981E+00, 9.6733955833E-01],
	[4.2620000000E+04, 3.3910731551E+01, 5.0234208849E+00, 1.5199081374E+01, 3.3973141322E+00, 9.6735228707E-01],
	[4.2625000000E+04, 3.3917700899E+01, 5.0234573251E+00, 1.5204872103E+01, 3.3976899805E+00, 9.6736501017E-01],
	[4.2630000000E+04, 3.3924670862E+01, 5.0234937613E+00, 1.5210664359E+01, 3.3980657433E+00, 9.6737772764E-01],
	[4.2635000000E+04, 3.3931641439E+01, 5.0235301936E+00, 1.5216458140E+01, 3.3984414204E+00, 9.6739043948E-01],
	[4.2640000000E+04, 3.3938612631E+01, 5.0235666218E+00, 1.5222253447E+01, 3.3988170119E+00, 9.6740314570E-01],
	[4.2645000000E+04, 3.3945584438E+01, 5.0236030460E+00, 1.5228050281E+01, 3.3991925178E+00, 9.6741584630E-01],
	[4.2650000000E+04, 3.3952556859E+01, 5.0236394662E+00, 1.5233848641E+01, 3.3995679381E+00, 9.6742854129E-01],
	[4.2655000000E+04, 3.3959529895E+01, 5.0236758824E+00, 1.5239648528E+01, 3.3999432728E+00, 9.6744123065E-01],
	[4.2660000000E+04, 3.3966503545E+01, 5.0237122946E+00, 1.5245449942E+01, 3.4003185220E+00, 9.6745391440E-01],
	[4.2665000000E+04, 3.3973477809E+01, 5.0237487028E+00, 1.5251252883E+01, 3.4006936857E+00, 9.6746659254E-01],
	[4.2670000000E+04, 3.3980452689E+01, 5.0237851070E+00, 1.5257057352E+01, 3.4010687638E+00, 9.6747926508E-01],
	[4.2675000000E+04, 3.3987428182E+01, 5.0238215072E+00, 1.5262863348E+01, 3.4014437564E+00, 9.6749193201E-01],
	[4.2680000000E+04, 3.3994404290E+01, 5.0238579034E+00, 1.5268670872E+01, 3.4018186635E+00, 9.6750459333E-01],
	[4.2685000000E+04, 3.4001381013E+01, 5.0238942956E+00, 1.5274479924E+01, 3.4021934851E+00, 9.6751724905E-01],
	[4.2690000000E+04, 3.4008358350E+01, 5.0239306838E+00, 1.5280290505E+01, 3.4025682213E+00, 9.6752989918E-01],
	[4.2695000000E+04, 3.4015336301E+01, 5.0239670680E+00, 1.5286102614E+01, 3.4029428720E+00, 9.6754254371E-01],
	[4.2700000000E+04, 3.4022314867E+01, 5.0240034482E+00, 1.5291916252E+01, 3.4033174372E+00, 9.6755518265E-01],
	[4.2705000000E+04, 3.4029294047E+01, 5.0240398244E+00, 1.5297731419E+01, 3.4036919171E+00, 9.6756781600E-01],
	[4.2710000000E+04, 3.4036273841E+01, 5.0240761966E+00, 1.5303548115E+01, 3.4040663115E+00, 9.6758044376E-01],
	[4.2715000000E+04, 3.4043254250E+01, 5.0241125648E+00, 1.5309366340E+01, 3.4044406206E+00, 9.6759306594E-01],
	[4.2720000000E+04, 3.4050235273E+01, 5.0241489290E+00, 1.5315186096E+01, 3.4048148443E+00, 9.6760568254E-01],
	[4.2725000000E+04, 3.4057216910E+01, 5.0241852893E+00, 1.5321007381E+01, 3.4051889826E+00, 9.6761829355E-01],
	[4.2730000000E+04, 3.4064199161E+01, 5.0242216455E+00, 1.5326830196E+01, 3.4055630355E+00, 9.6763089899E-01],
	[4.2735000000E+04, 3.4071182027E+01, 5.0242579978E+00, 1.5332654541E+01, 3.4059370032E+00, 9.6764349885E-01],
	[4.2740000000E+04, 3.4078165507E+01, 5.0242943460E+00, 1.5338480417E+01, 3.4063108855E+00, 9.6765609315E-01],
	[4.2745000000E+04, 3.4085149601E+01, 5.0243306903E+00, 1.5344307824E+01, 3.4066846825E+00, 9.6766868187E-01],
	[4.2750000000E+04, 3.4092134310E+01, 5.0243670305E+00, 1.5350136762E+01, 3.4070583942E+00, 9.6768126503E-01],
	[4.2755000000E+04, 3.4099119632E+01, 5.0244033668E+00, 1.5355967231E+01, 3.4074320206E+00, 9.6769384262E-01],
	[4.2760000000E+04, 3.4106105569E+01, 5.0244396991E+00, 1.5361799232E+01, 3.4078055618E+00, 9.6770641465E-01],
	[4.2765000000E+04, 3.4113092120E+01, 5.0244760275E+00, 1.5367632764E+01, 3.4081790178E+00, 9.6771898113E-01],
	[4.2770000000E+04, 3.4120079285E+01, 5.0245123518E+00, 1.5373467828E+01, 3.4085523885E+00, 9.6773154204E-01],
	[4.2775000000E+04, 3.4127067064E+01, 5.0245486721E+00, 1.5379304424E+01, 3.4089256740E+00, 9.6774409741E-01],
	[4.2780000000E+04, 3.4134055457E+01, 5.0245849885E+00, 1.5385142553E+01, 3.4092988743E+00, 9.6775664722E-01],
	[4.2785000000E+04, 3.4141044464E+01, 5.0246213009E+00, 1.5390982214E+01, 3.4096719894E+00, 9.6776919149E-01],
	[4.2790000000E+04, 3.4148034086E+01, 5.0246576093E+00, 1.5396823408E+01, 3.4100450194E+00, 9.6778173021E-01],
	[4.2795000000E+04, 3.4155024321E+01, 5.0246939137E+00, 1.5402666134E+01, 3.4104179642E+00, 9.6779426338E-01],
	[4.2800000000E+04, 3.4162015170E+01, 5.0247302142E+00, 1.5408510395E+01, 3.4107908238E+00, 9.6780679102E-01],
	[4.2805000000E+04, 3.4169006634E+01, 5.0247665106E+00, 1.5414356188E+01, 3.4111635983E+00, 9.6781931312E-01],
	[4.2810000000E+04, 3.4175998711E+01, 5.0248028031E+00, 1.5420203515E+01, 3.4115362878E+00, 9.6783182968E-01],
	[4.2815000000E+04, 3.4182991402E+01, 5.0248390916E+00, 1.5426052376E+01, 3.4119088921E+00, 9.6784434071E-01],
	[4.2820000000E+04, 3.4189984707E+01, 5.0248753762E+00, 1.5431902772E+01, 3.4122814113E+00, 9.6785684621E-01],
	[4.2825000000E+04, 3.4196978626E+01, 5.0249116567E+00, 1.5437754701E+01, 3.4126538455E+00, 9.6786934618E-01],
	[4.2830000000E+04, 3.4203973159E+01, 5.0249479333E+00, 1.5443608165E+01, 3.4130261947E+00, 9.6788184063E-01],
	[4.2835000000E+04, 3.4210968306E+01, 5.0249842059E+00, 1.5449463164E+01, 3.4133984588E+00, 9.6789432955E-01],
	[4.2840000000E+04, 3.4217964067E+01, 5.0250204746E+00, 1.5455319698E+01, 3.4137706378E+00, 9.6790681296E-01],
	[4.2845000000E+04, 3.4224960442E+01, 5.0250567392E+00, 1.5461177767E+01, 3.4141427319E+00, 9.6791929085E-01],
	[4.2850000000E+04, 3.4231957430E+01, 5.0250929999E+00, 1.5467037372E+01, 3.4145147410E+00, 9.6793176322E-01],
	[4.2855000000E+04, 3.4238955033E+01, 5.0251292567E+00, 1.5472898512E+01, 3.4148866651E+00, 9.6794423008E-01],
	[4.2860000000E+04, 3.4245953249E+01, 5.0251655094E+00, 1.5478761188E+01, 3.4152585043E+00, 9.6795669143E-01],
	[4.2865000000E+04, 3.4252952079E+01, 5.0252017582E+00, 1.5484625401E+01, 3.4156302585E+00, 9.6796914728E-01],
	[4.2870000000E+04, 3.4259951522E+01, 5.0252380031E+00, 1.5490491149E+01, 3.4160019277E+00, 9.6798159762E-01],
	[4.2875000000E+04, 3.4266951580E+01, 5.0252742439E+00, 1.5496358435E+01, 3.4163735121E+00, 9.6799404246E-01],
	[4.2880000000E+04, 3.4273952251E+01, 5.0253104808E+00, 1.5502227257E+01, 3.4167450116E+00, 9.6800648180E-01],
	[4.2885000000E+04, 3.4280953536E+01, 5.0253467138E+00, 1.5508097616E+01, 3.4171164261E+00, 9.6801891565E-01],
	[4.2890000000E+04, 3.4287955434E+01, 5.0253829427E+00, 1.5513969512E+01, 3.4174877558E+00, 9.6803134400E-01],
	[4.2895000000E+04, 3.4294957946E+01, 5.0254191677E+00, 1.5519842946E+01, 3.4178590007E+00, 9.6804376686E-01],
	[4.2900000000E+04, 3.4301961072E+01, 5.0254553888E+00, 1.5525717917E+01, 3.4182301607E+00, 9.6805618423E-01],
	[4.2905000000E+04, 3.4308964812E+01, 5.0254916059E+00, 1.5531594427E+01, 3.4186012359E+00, 9.6806859611E-01],
	[4.2910000000E+04, 3.4315969165E+01, 5.0255278190E+00, 1.5537472474E+01, 3.4189722263E+00, 9.6808100251E-01],
	[4.2915000000E+04, 3.4322974131E+01, 5.0255640282E+00, 1.5543352060E+01, 3.4193431319E+00, 9.6809340343E-01],
	[4.2920000000E+04, 3.4329979712E+01, 5.0256002334E+00, 1.5549233184E+01, 3.4197139527E+00, 9.6810579887E-01],
	[4.2925000000E+04, 3.4336985906E+01, 5.0256364347E+00, 1.5555115847E+01, 3.4200846887E+00, 9.6811818884E-01],
	[4.2930000000E+04, 3.4343992713E+01, 5.0256726320E+00, 1.5561000050E+01, 3.4204553400E+00, 9.6813057333E-01],
	[4.2935000000E+04, 3.4351000134E+01, 5.0257088253E+00, 1.5566885791E+01, 3.4208259066E+00, 9.6814295235E-01],
	[4.2940000000E+04, 3.4358008169E+01, 5.0257450147E+00, 1.5572773072E+01, 3.4211963884E+00, 9.6815532591E-01],
	[4.2945000000E+04, 3.4365016816E+01, 5.0257812001E+00, 1.5578661893E+01, 3.4215667855E+00, 9.6816769400E-01],
	[4.2950000000E+04, 3.4372026078E+01, 5.0258173816E+00, 1.5584552253E+01, 3.4219370980E+00, 9.6818005662E-01],
	[4.2955000000E+04, 3.4379035953E+01, 5.0258535592E+00, 1.5590444154E+01, 3.4223073258E+00, 9.6819241379E-01],
	[4.2960000000E+04, 3.4386046441E+01, 5.0258897327E+00, 1.5596337595E+01, 3.4226774689E+00, 9.6820476550E-01],
	[4.2965000000E+04, 3.4393057543E+01, 5.0259259024E+00, 1.5602232576E+01, 3.4230475274E+00, 9.6821711175E-01],
	[4.2970000000E+04, 3.4400069258E+01, 5.0259620681E+00, 1.5608129099E+01, 3.4234175012E+00, 9.6822945255E-01],
	[4.2975000000E+04, 3.4407081587E+01, 5.0259982298E+00, 1.5614027162E+01, 3.4237873904E+00, 9.6824178790E-01],
	[4.2980000000E+04, 3.4414094529E+01, 5.0260343876E+00, 1.5619926767E+01, 3.4241571950E+00, 9.6825411780E-01],
	[4.2985000000E+04, 3.4421108084E+01, 5.0260705414E+00, 1.5625827913E+01, 3.4245269151E+00, 9.6826644226E-01],
	[4.2990000000E+04, 3.4428122253E+01, 5.0261066913E+00, 1.5631730601E+01, 3.4248965506E+00, 9.6827876128E-01],
	[4.2995000000E+04, 3.4435137035E+01, 5.0261428373E+00, 1.5637634831E+01, 3.4252661015E+00, 9.6829107486E-01],
	[4.3000000000E+04, 3.4442152430E+01, 5.0261789793E+00, 1.5643540603E+01, 3.4256355679E+00, 9.6830338299E-01],
	[4.3005000000E+04, 3.4449168439E+01, 5.0262151174E+00, 1.5649447917E+01, 3.4260049497E+00, 9.6831568570E-01],
	[4.3010000000E+04, 3.4456185061E+01, 5.0262512515E+00, 1.5655356774E+01, 3.4263742471E+00, 9.6832798297E-01],
	[4.3015000000E+04, 3.4463202296E+01, 5.0262873817E+00, 1.5661267173E+01, 3.4267434600E+00, 9.6834027482E-01],
	[4.3020000000E+04, 3.4470220144E+01, 5.0263235079E+00, 1.5667179116E+01, 3.4271125884E+00, 9.6835256123E-01],
	[4.3025000000E+04, 3.4477238605E+01, 5.0263596303E+00, 1.5673092602E+01, 3.4274816323E+00, 9.6836484222E-01],
	[4.3030000000E+04, 3.4484257680E+01, 5.0263957486E+00, 1.5679007632E+01, 3.4278505918E+00, 9.6837711780E-01],
	[4.3035000000E+04, 3.4491277368E+01, 5.0264318631E+00, 1.5684924205E+01, 3.4282194668E+00, 9.6838938795E-01],
	[4.3040000000E+04, 3.4498297669E+01, 5.0264679736E+00, 1.5690842322E+01, 3.4285882574E+00, 9.6840165268E-01],
	[4.3045000000E+04, 3.4505318583E+01, 5.0265040801E+00, 1.5696761983E+01, 3.4289569636E+00, 9.6841391200E-01],
	[4.3050000000E+04, 3.4512340111E+01, 5.0265401827E+00, 1.5702683189E+01, 3.4293255855E+00, 9.6842616591E-01],
	[4.3055000000E+04, 3.4519362251E+01, 5.0265762814E+00, 1.5708605939E+01, 3.4296941230E+00, 9.6843841441E-01],
	[4.3060000000E+04, 3.4526385005E+01, 5.0266123762E+00, 1.5714530234E+01, 3.4300625761E+00, 9.6845065751E-01],
	[4.3065000000E+04, 3.4533408371E+01, 5.0266484670E+00, 1.5720456074E+01, 3.4304309448E+00, 9.6846289520E-01],
	[4.3070000000E+04, 3.4540432351E+01, 5.0266845539E+00, 1.5726383459E+01, 3.4307992293E+00, 9.6847512749E-01],
	[4.3075000000E+04, 3.4547456944E+01, 5.0267206369E+00, 1.5732312390E+01, 3.4311674294E+00, 9.6848735438E-01],
	[4.3080000000E+04, 3.4554482150E+01, 5.0267567159E+00, 1.5738242867E+01, 3.4315355453E+00, 9.6849957588E-01],
	[4.3085000000E+04, 3.4561507968E+01, 5.0267927911E+00, 1.5744174889E+01, 3.4319035768E+00, 9.6851179198E-01],
	[4.3090000000E+04, 3.4568534400E+01, 5.0268288622E+00, 1.5750108458E+01, 3.4322715241E+00, 9.6852400269E-01],
	[4.3095000000E+04, 3.4575561445E+01, 5.0268649295E+00, 1.5756043573E+01, 3.4326393871E+00, 9.6853620801E-01],
	[4.3100000000E+04, 3.4582589102E+01, 5.0269009928E+00, 1.5761980234E+01, 3.4330071660E+00, 9.6854840795E-01],
	[4.3105000000E+04, 3.4589617373E+01, 5.0269370522E+00, 1.5767918443E+01, 3.4333748605E+00, 9.6856060250E-01],
	[4.3110000000E+04, 3.4596646256E+01, 5.0269731077E+00, 1.5773858198E+01, 3.4337424709E+00, 9.6857279168E-01],
	[4.3115000000E+04, 3.4603675753E+01, 5.0270091593E+00, 1.5779799501E+01, 3.4341099971E+00, 9.6858497547E-01],
	[4.3120000000E+04, 3.4610705862E+01, 5.0270452069E+00, 1.5785742351E+01, 3.4344774391E+00, 9.6859715389E-01],
	[4.3125000000E+04, 3.4617736584E+01, 5.0270812506E+00, 1.5791686749E+01, 3.4348447970E+00, 9.6860932694E-01],
	[4.3130000000E+04, 3.4624767919E+01, 5.0271172904E+00, 1.5797632695E+01, 3.4352120707E+00, 9.6862149461E-01],
	[4.3135000000E+04, 3.4631799867E+01, 5.0271533263E+00, 1.5803580190E+01, 3.4355792603E+00, 9.6863365692E-01],
	[4.3140000000E+04, 3.4638832428E+01, 5.0271893583E+00, 1.5809529232E+01, 3.4359463658E+00, 9.6864581386E-01],
	[4.3145000000E+04, 3.4645865601E+01, 5.0272253863E+00, 1.5815479823E+01, 3.4363133872E+00, 9.6865796544E-01],
	[4.3150000000E+04, 3.4652899387E+01, 5.0272614104E+00, 1.5821431963E+01, 3.4366803245E+00, 9.6867011166E-01],
	[4.3155000000E+04, 3.4659933786E+01, 5.0272974306E+00, 1.5827385652E+01, 3.4370471777E+00, 9.6868225253E-01],
	[4.3160000000E+04, 3.4666968798E+01, 5.0273334469E+00, 1.5833340890E+01, 3.4374139469E+00, 9.6869438803E-01],
	[4.3165000000E+04, 3.4674004422E+01, 5.0273694593E+00, 1.5839297678E+01, 3.4377806320E+00, 9.6870651819E-01],
	[4.3170000000E+04, 3.4681040659E+01, 5.0274054678E+00, 1.5845256016E+01, 3.4381472332E+00, 9.6871864299E-01],
	[4.3175000000E+04, 3.4688077509E+01, 5.0274414723E+00, 1.5851215903E+01, 3.4385137503E+00, 9.6873076245E-01],
	[4.3180000000E+04, 3.4695114972E+01, 5.0274774730E+00, 1.5857177341E+01, 3.4388801834E+00, 9.6874287656E-01],
	[4.3185000000E+04, 3.4702160633E+01, 5.0275144202E+00, 1.5863140329E+01, 3.4392470519E+00, 9.6875498533E-01],
	[4.3190000000E+04, 3.4709214652E+01, 5.0275523334E+00, 1.5869104868E+01, 3.4396143666E+00, 9.6876708876E-01],
	[4.3195000000E+04, 3.4716269289E+01, 5.0275902425E+00, 1.5875070957E+01, 3.4399815976E+00, 9.6877918686E-01],
	[4.3200000000E+04, 3.4723324543E+01, 5.0276281475E+00, 1.5881038598E+01, 3.4403487449E+00, 9.6879127962E-01],
	[4.3205000000E+04, 3.4730380414E+01, 5.0276660484E+00, 1.5887007790E+01, 3.4407158086E+00, 9.6880336704E-01],
	[4.3210000000E+04, 3.4737436902E+01, 5.0277039453E+00, 1.5892978533E+01, 3.4410827886E+00, 9.6881544914E-01],
	[4.3215000000E+04, 3.4744494007E+01, 5.0277418380E+00, 1.5898950828E+01, 3.4414496850E+00, 9.6882752591E-01],
	[4.3220000000E+04, 3.4751551729E+01, 5.0277797266E+00, 1.5904924675E+01, 3.4418164978E+00, 9.6883959735E-01],
	[4.3225000000E+04, 3.4758610068E+01, 5.0278176111E+00, 1.5910900075E+01, 3.4421832269E+00, 9.6885166348E-01],
	[4.3230000000E+04, 3.4765669023E+01, 5.0278554916E+00, 1.5916877026E+01, 3.4425498725E+00, 9.6886372428E-01],
	[4.3235000000E+04, 3.4772728596E+01, 5.0278933679E+00, 1.5922855531E+01, 3.4429164345E+00, 9.6887577977E-01],
	[4.3240000000E+04, 3.4779788786E+01, 5.0279312401E+00, 1.5928835588E+01, 3.4432829130E+00, 9.6888782994E-01],
	[4.3245000000E+04, 3.4786849592E+01, 5.0279691083E+00, 1.5934817198E+01, 3.4436493079E+00, 9.6889987480E-01],
	[4.3250000000E+04, 3.4793911016E+01, 5.0280069723E+00, 1.5940800362E+01, 3.4440156193E+00, 9.6891191435E-01],
	[4.3255000000E+04, 3.4800973056E+01, 5.0280448323E+00, 1.5946785079E+01, 3.4443818472E+00, 9.6892394860E-01],
	[4.3260000000E+04, 3.4808035713E+01, 5.0280826881E+00, 1.5952771350E+01, 3.4447479915E+00, 9.6893597754E-01],
	[4.3265000000E+04, 3.4815098987E+01, 5.0281205399E+00, 1.5958759174E+01, 3.4451140524E+00, 9.6894800118E-01],
	[4.3270000000E+04, 3.4822162878E+01, 5.0281583876E+00, 1.5964748553E+01, 3.4454800299E+00, 9.6896001952E-01],
	[4.3275000000E+04, 3.4829227385E+01, 5.0281962312E+00, 1.5970739487E+01, 3.4458459239E+00, 9.6897203256E-01],
	[4.3280000000E+04, 3.4836292509E+01, 5.0282340707E+00, 1.5976731975E+01, 3.4462117344E+00, 9.6898404031E-01],
	[4.3285000000E+04, 3.4843358250E+01, 5.0282719061E+00, 1.5982726018E+01, 3.4465774615E+00, 9.6899604277E-01],
	[4.3290000000E+04, 3.4850424608E+01, 5.0283097375E+00, 1.5988721616E+01, 3.4469431053E+00, 9.6900803994E-01],
	[4.3295000000E+04, 3.4857491583E+01, 5.0283475647E+00, 1.5994718769E+01, 3.4473086656E+00, 9.6902003182E-01],
	[4.3300000000E+04, 3.4864559174E+01, 5.0283853879E+00, 1.6000717478E+01, 3.4476741426E+00, 9.6903201842E-01],
	[4.3305000000E+04, 3.4871627382E+01, 5.0284232070E+00, 1.6006717743E+01, 3.4480395362E+00, 9.6904399974E-01],
	[4.3310000000E+04, 3.4878696206E+01, 5.0284610220E+00, 1.6012719564E+01, 3.4484048464E+00, 9.6905597577E-01],
	[4.3315000000E+04, 3.4885765647E+01, 5.0284988329E+00, 1.6018722940E+01, 3.4487700734E+00, 9.6906794654E-01],
	[4.3320000000E+04, 3.4892835705E+01, 5.0285366397E+00, 1.6024727874E+01, 3.4491352170E+00, 9.6907991202E-01],
	[4.3325000000E+04, 3.4899906380E+01, 5.0285744425E+00, 1.6030734364E+01, 3.4495002773E+00, 9.6909187224E-01],
	[4.3330000000E+04, 3.4906977671E+01, 5.0286122412E+00, 1.6036742410E+01, 3.4498652543E+00, 9.6910382719E-01],
	[4.3335000000E+04, 3.4914049578E+01, 5.0286500358E+00, 1.6042752014E+01, 3.4502301481E+00, 9.6911577687E-01],
	[4.3340000000E+04, 3.4921122102E+01, 5.0286878263E+00, 1.6048763175E+01, 3.4505949586E+00, 9.6912772129E-01],
	[4.3345000000E+04, 3.4928195243E+01, 5.0287256128E+00, 1.6054775894E+01, 3.4509596859E+00, 9.6913966045E-01],
	[4.3350000000E+04, 3.4935269000E+01, 5.0287633952E+00, 1.6060790171E+01, 3.4513243300E+00, 9.6915159435E-01],
	[4.3355000000E+04, 3.4942343374E+01, 5.0288011735E+00, 1.6066806005E+01, 3.4516888908E+00, 9.6916352299E-01],
	[4.3360000000E+04, 3.4949418364E+01, 5.0288389477E+00, 1.6072823398E+01, 3.4520533685E+00, 9.6917544638E-01],
	[4.3365000000E+04, 3.4956493971E+01, 5.0288767179E+00, 1.6078842349E+01, 3.4524177630E+00, 9.6918736452E-01],
	[4.3370000000E+04, 3.4963570194E+01, 5.0289144840E+00, 1.6084862859E+01, 3.4527820743E+00, 9.6919927741E-01],
	[4.3375000000E+04, 3.4970647033E+01, 5.0289522460E+00, 1.6090884928E+01, 3.4531463025E+00, 9.6921118505E-01],
	[4.3380000000E+04, 3.4977724489E+01, 5.0289900040E+00, 1.6096908556E+01, 3.4535104475E+00, 9.6922308745E-01],
	[4.3385000000E+04, 3.4984802562E+01, 5.0290277578E+00, 1.6102933743E+01, 3.4538745095E+00, 9.6923498461E-01],
	[4.3390000000E+04, 3.4991881251E+01, 5.0290655077E+00, 1.6108960490E+01, 3.4542384883E+00, 9.6924687654E-01],
	[4.3395000000E+04, 3.4998960556E+01, 5.0291032534E+00, 1.6114988796E+01, 3.4546023841E+00, 9.6925876322E-01],
	[4.3400000000E+04, 3.5006040477E+01, 5.0291409951E+00, 1.6121018663E+01, 3.4549661967E+00, 9.6927064467E-01],
	[4.3405000000E+04, 3.5013121015E+01, 5.0291787327E+00, 1.6127050089E+01, 3.4553299264E+00, 9.6928252089E-01],
	[4.3410000000E+04, 3.5020202169E+01, 5.0292164663E+00, 1.6133083077E+01, 3.4556935730E+00, 9.6929439189E-01],
	[4.3415000000E+04, 3.5027283940E+01, 5.0292541958E+00, 1.6139117625E+01, 3.4560571365E+00, 9.6930625766E-01],
	[4.3420000000E+04, 3.5034366326E+01, 5.0292919212E+00, 1.6145153733E+01, 3.4564206171E+00, 9.6931811820E-01],
	[4.3425000000E+04, 3.5041449329E+01, 5.0293296426E+00, 1.6151191403E+01, 3.4567840147E+00, 9.6932997352E-01],
	[4.3430000000E+04, 3.5048532949E+01, 5.0293673599E+00, 1.6157230635E+01, 3.4571473293E+00, 9.6934182363E-01],
	[4.3435000000E+04, 3.5055617184E+01, 5.0294050731E+00, 1.6163271427E+01, 3.4575105609E+00, 9.6935366852E-01],
	[4.3440000000E+04, 3.5062702036E+01, 5.0294427823E+00, 1.6169313782E+01, 3.4578737096E+00, 9.6936550819E-01],
	[4.3445000000E+04, 3.5069787504E+01, 5.0294804875E+00, 1.6175357699E+01, 3.4582367754E+00, 9.6937734266E-01],
	[4.3450000000E+04, 3.5076873588E+01, 5.0295181885E+00, 1.6181403178E+01, 3.4585997582E+00, 9.6938917191E-01],
	[4.3455000000E+04, 3.5083960288E+01, 5.0295558856E+00, 1.6187450219E+01, 3.4589626582E+00, 9.6940099597E-01],
	[4.3460000000E+04, 3.5091047604E+01, 5.0295935785E+00, 1.6193498823E+01, 3.4593254752E+00, 9.6941281481E-01],
	[4.3465000000E+04, 3.5098135537E+01, 5.0296312675E+00, 1.6199548990E+01, 3.4596882094E+00, 9.6942462846E-01],
	[4.3470000000E+04, 3.5105224085E+01, 5.0296689523E+00, 1.6205600720E+01, 3.4600508608E+00, 9.6943643691E-01],
	[4.3475000000E+04, 3.5112313250E+01, 5.0297066331E+00, 1.6211654013E+01, 3.4604134293E+00, 9.6944824017E-01],
	[4.3480000000E+04, 3.5119403031E+01, 5.0297443099E+00, 1.6217708870E+01, 3.4607759149E+00, 9.6946003823E-01],
	[4.3485000000E+04, 3.5126493428E+01, 5.0297819826E+00, 1.6223765291E+01, 3.4611383178E+00, 9.6947183110E-01],
	[4.3490000000E+04, 3.5133584441E+01, 5.0298196513E+00, 1.6229823276E+01, 3.4615006379E+00, 9.6948361878E-01],
	[4.3495000000E+04, 3.5140676069E+01, 5.0298573159E+00, 1.6235882825E+01, 3.4618628752E+00, 9.6949540127E-01],
	[4.3500000000E+04, 3.5147768314E+01, 5.0298949764E+00, 1.6241943939E+01, 3.4622250297E+00, 9.6950717859E-01],
	[4.3505000000E+04, 3.5154861175E+01, 5.0299326329E+00, 1.6248006617E+01, 3.4625871015E+00, 9.6951895072E-01],
	[4.3510000000E+04, 3.5161954652E+01, 5.0299702854E+00, 1.6254070860E+01, 3.4629490906E+00, 9.6953071767E-01],
	[4.3515000000E+04, 3.5169048745E+01, 5.0300079338E+00, 1.6260136669E+01, 3.4633109969E+00, 9.6954247945E-01],
	[4.3520000000E+04, 3.5176143454E+01, 5.0300455782E+00, 1.6266204043E+01, 3.4636728206E+00, 9.6955423606E-01],
	[4.3525000000E+04, 3.5183238778E+01, 5.0300832186E+00, 1.6272272982E+01, 3.4640345615E+00, 9.6956598749E-01],
	[4.3530000000E+04, 3.5190334719E+01, 5.0301208549E+00, 1.6278343487E+01, 3.4643962198E+00, 9.6957773376E-01],
	[4.3535000000E+04, 3.5197431275E+01, 5.0301584871E+00, 1.6284415558E+01, 3.4647577955E+00, 9.6958947486E-01],
	[4.3540000000E+04, 3.5204528448E+01, 5.0301961153E+00, 1.6290489196E+01, 3.4651192885E+00, 9.6960121080E-01],
	[4.3545000000E+04, 3.5211626236E+01, 5.0302337395E+00, 1.6296564400E+01, 3.4654806989E+00, 9.6961294158E-01],
	[4.3550000000E+04, 3.5218724640E+01, 5.0302713596E+00, 1.6302641170E+01, 3.4658420266E+00, 9.6962466720E-01],
	[4.3555000000E+04, 3.5225823659E+01, 5.0303089757E+00, 1.6308719508E+01, 3.4662032718E+00, 9.6963638766E-01],
	[4.3560000000E+04, 3.5232923295E+01, 5.0303465878E+00, 1.6314799413E+01, 3.4665644344E+00, 9.6964810297E-01],
	[4.3565000000E+04, 3.5240023546E+01, 5.0303841958E+00, 1.6320880885E+01, 3.4669255145E+00, 9.6965981313E-01],
	[4.3570000000E+04, 3.5247124414E+01, 5.0304217998E+00, 1.6326963925E+01, 3.4672865120E+00, 9.6967151815E-01],
	[4.3575000000E+04, 3.5254225896E+01, 5.0304593998E+00, 1.6333048532E+01, 3.4676474270E+00, 9.6968321801E-01],
	[4.3580000000E+04, 3.5261327995E+01, 5.0304969957E+00, 1.6339134708E+01, 3.4680082594E+00, 9.6969491274E-01],
	[4.3585000000E+04, 3.5268430709E+01, 5.0305345876E+00, 1.6345222452E+01, 3.4683690094E+00, 9.6970660232E-01],
	[4.3590000000E+04, 3.5275534039E+01, 5.0305721755E+00, 1.6351311764E+01, 3.4687296768E+00, 9.6971828676E-01],
	[4.3595000000E+04, 3.5282637985E+01, 5.0306097593E+00, 1.6357402646E+01, 3.4690902618E+00, 9.6972996607E-01],
	[4.3600000000E+04, 3.5289742546E+01, 5.0306473391E+00, 1.6363495096E+01, 3.4694507644E+00, 9.6974164025E-01],
	[4.3605000000E+04, 3.5296847723E+01, 5.0306849149E+00, 1.6369589115E+01, 3.4698111845E+00, 9.6975330929E-01],
	[4.3610000000E+04, 3.5303953516E+01, 5.0307224866E+00, 1.6375684704E+01, 3.4701715222E+00, 9.6976497321E-01],
	[4.3615000000E+04, 3.5311059924E+01, 5.0307600543E+00, 1.6381781862E+01, 3.4705317775E+00, 9.6977663200E-01],
	[4.3620000000E+04, 3.5318166948E+01, 5.0307976180E+00, 1.6387880590E+01, 3.4708919504E+00, 9.6978828567E-01],
	[4.3625000000E+04, 3.5325274587E+01, 5.0308351777E+00, 1.6393980888E+01, 3.4712520409E+00, 9.6979993422E-01],
	[4.3630000000E+04, 3.5332382842E+01, 5.0308727333E+00, 1.6400082757E+01, 3.4716120491E+00, 9.6981157765E-01],
	[4.3635000000E+04, 3.5339491713E+01, 5.0309102850E+00, 1.6406186196E+01, 3.4719719749E+00, 9.6982321596E-01],
	[4.3640000000E+04, 3.5346601199E+01, 5.0309478326E+00, 1.6412291206E+01, 3.4723318184E+00, 9.6983484916E-01],
	[4.3645000000E+04, 3.5353711300E+01, 5.0309853761E+00, 1.6418397787E+01, 3.4726915795E+00, 9.6984647725E-01],
	[4.3650000000E+04, 3.5360822017E+01, 5.0310229157E+00, 1.6424505939E+01, 3.4730512584E+00, 9.6985810023E-01],
	[4.3655000000E+04, 3.5367933350E+01, 5.0310604512E+00, 1.6430615662E+01, 3.4734108550E+00, 9.6986971811E-01],
	[4.3660000000E+04, 3.5375045298E+01, 5.0310979827E+00, 1.6436726957E+01, 3.4737703693E+00, 9.6988133088E-01],
	[4.3665000000E+04, 3.5382157861E+01, 5.0311355102E+00, 1.6442839824E+01, 3.4741298014E+00, 9.6989293855E-01],
	[4.3670000000E+04, 3.5389271040E+01, 5.0311730337E+00, 1.6448954263E+01, 3.4744891513E+00, 9.6990454112E-01],
	[4.3675000000E+04, 3.5396384834E+01, 5.0312105532E+00, 1.6455070274E+01, 3.4748484189E+00, 9.6991613860E-01],
	[4.3680000000E+04, 3.5403499243E+01, 5.0312480686E+00, 1.6461187858E+01, 3.4752076043E+00, 9.6992773098E-01],
	[4.3685000000E+04, 3.5410614268E+01, 5.0312855801E+00, 1.6467307014E+01, 3.4755667075E+00, 9.6993931828E-01],
	[4.3690000000E+04, 3.5417729909E+01, 5.0313230875E+00, 1.6473427744E+01, 3.4759257286E+00, 9.6995090048E-01],
	[4.3695000000E+04, 3.5424846164E+01, 5.0313605909E+00, 1.6479550047E+01, 3.4762846675E+00, 9.6996247760E-01],
	[4.3700000000E+04, 3.5431963035E+01, 5.0313980903E+00, 1.6485673923E+01, 3.4766435242E+00, 9.6997404963E-01],
	[4.3705000000E+04, 3.5439080521E+01, 5.0314355857E+00, 1.6491799373E+01, 3.4770022988E+00, 9.6998561659E-01],
	[4.3710000000E+04, 3.5446198623E+01, 5.0314730771E+00, 1.6497926396E+01, 3.4773609913E+00, 9.6999717846E-01],
	[4.3715000000E+04, 3.5453317340E+01, 5.0315105644E+00, 1.6504054994E+01, 3.4777196018E+00, 9.7000873526E-01],
	[4.3720000000E+04, 3.5460436672E+01, 5.0315480478E+00, 1.6510185166E+01, 3.4780781301E+00, 9.7002028699E-01],
	[4.3725000000E+04, 3.5467556619E+01, 5.0315855272E+00, 1.6516316913E+01, 3.4784365764E+00, 9.7003183364E-01],
	[4.3730000000E+04, 3.5474677181E+01, 5.0316230025E+00, 1.6522450234E+01, 3.4787949406E+00, 9.7004337522E-01],
	[4.3735000000E+04, 3.5481798359E+01, 5.0316604738E+00, 1.6528585131E+01, 3.4791532228E+00, 9.7005491174E-01],
	[4.3740000000E+04, 3.5488920152E+01, 5.0316979412E+00, 1.6534721603E+01, 3.4795114229E+00, 9.7006644320E-01],
	[4.3745000000E+04, 3.5496042560E+01, 5.0317354045E+00, 1.6540859650E+01, 3.4798695411E+00, 9.7007796959E-01],
	[4.3750000000E+04, 3.5503165583E+01, 5.0317728638E+00, 1.6546999272E+01, 3.4802275773E+00, 9.7008949093E-01],
	[4.3755000000E+04, 3.5510289221E+01, 5.0318103192E+00, 1.6553140471E+01, 3.4805855315E+00, 9.7010100721E-01],
	[4.3760000000E+04, 3.5517413474E+01, 5.0318477705E+00, 1.6559283246E+01, 3.4809434037E+00, 9.7011251843E-01],
	[4.3765000000E+04, 3.5524538343E+01, 5.0318852178E+00, 1.6565427597E+01, 3.4813011940E+00, 9.7012402461E-01],
	[4.3770000000E+04, 3.5531663826E+01, 5.0319226611E+00, 1.6571573525E+01, 3.4816589024E+00, 9.7013552573E-01],
	[4.3775000000E+04, 3.5538789925E+01, 5.0319601005E+00, 1.6577721029E+01, 3.4820165289E+00, 9.7014702181E-01],
	[4.3780000000E+04, 3.5545916638E+01, 5.0319975358E+00, 1.6583870111E+01, 3.4823740735E+00, 9.7015851284E-01],
	[4.3785000000E+04, 3.5553043967E+01, 5.0320349671E+00, 1.6590020769E+01, 3.4827315362E+00, 9.7016999884E-01],
	[4.3790000000E+04, 3.5560171911E+01, 5.0320723945E+00, 1.6596173005E+01, 3.4830889170E+00, 9.7018147979E-01],
	[4.3795000000E+04, 3.5567300469E+01, 5.0321098178E+00, 1.6602326819E+01, 3.4834462160E+00, 9.7019295571E-01],
	[4.3800000000E+04, 3.5574429643E+01, 5.0321472372E+00, 1.6608482211E+01, 3.4838034332E+00, 9.7020442659E-01],
	[4.3805000000E+04, 3.5581559431E+01, 5.0321846525E+00, 1.6614639181E+01, 3.4841605685E+00, 9.7021589244E-01],
	[4.3810000000E+04, 3.5588689835E+01, 5.0322220639E+00, 1.6620797729E+01, 3.4845176221E+00, 9.7022735326E-01],
	[4.3815000000E+04, 3.5595820853E+01, 5.0322594713E+00, 1.6626957856E+01, 3.4848745938E+00, 9.7023880906E-01],
	[4.3820000000E+04, 3.5602952487E+01, 5.0322968746E+00, 1.6633119562E+01, 3.4852314838E+00, 9.7025025983E-01],
	[4.3825000000E+04, 3.5610084735E+01, 5.0323342740E+00, 1.6639282846E+01, 3.4855882921E+00, 9.7026170557E-01],
	[4.3830000000E+04, 3.5617217598E+01, 5.0323716694E+00, 1.6645447710E+01, 3.4859450186E+00, 9.7027314630E-01],
	[4.3835000000E+04, 3.5624351076E+01, 5.0324090608E+00, 1.6651614154E+01, 3.4863016634E+00, 9.7028458202E-01],
	[4.3840000000E+04, 3.5631485168E+01, 5.0324464483E+00, 1.6657782177E+01, 3.4866582264E+00, 9.7029601271E-01],
	[4.3845000000E+04, 3.5638619876E+01, 5.0324838317E+00, 1.6663951780E+01, 3.4870147078E+00, 9.7030743840E-01],
	[4.3850000000E+04, 3.5645755198E+01, 5.0325212112E+00, 1.6670122963E+01, 3.4873711075E+00, 9.7031885907E-01],
	[4.3855000000E+04, 3.5652891135E+01, 5.0325585866E+00, 1.6676295727E+01, 3.4877274256E+00, 9.7033027474E-01],
	[4.3860000000E+04, 3.5660027687E+01, 5.0325959581E+00, 1.6682470071E+01, 3.4880836620E+00, 9.7034168541E-01],
	[4.3865000000E+04, 3.5667164854E+01, 5.0326333256E+00, 1.6688645996E+01, 3.4884398168E+00, 9.7035309107E-01],
	[4.3870000000E+04, 3.5674302635E+01, 5.0326706892E+00, 1.6694823502E+01, 3.4887958899E+00, 9.7036449173E-01],
	[4.3875000000E+04, 3.5681441031E+01, 5.0327080487E+00, 1.6701002589E+01, 3.4891518815E+00, 9.7037588739E-01],
	[4.3880000000E+04, 3.5688587031E+01, 5.0327462662E+00, 1.6707183258E+01, 3.4895082727E+00, 9.7038727806E-01],
	[4.3885000000E+04, 3.5695741888E+01, 5.0327854960E+00, 1.6713365508E+01, 3.4898651498E+00, 9.7039866374E-01],
	[4.3890000000E+04, 3.5702897365E+01, 5.0328247215E+00, 1.6719549341E+01, 3.4902219457E+00, 9.7041004443E-01],
	[4.3895000000E+04, 3.5710053461E+01, 5.0328639429E+00, 1.6725734755E+01, 3.4905786602E+00, 9.7042142013E-01],
	[4.3900000000E+04, 3.5717210175E+01, 5.0329031601E+00, 1.6731921752E+01, 3.4909352935E+00, 9.7043279084E-01],
	[4.3905000000E+04, 3.5724367509E+01, 5.0329423732E+00, 1.6738110332E+01, 3.4912918455E+00, 9.7044415657E-01],
	[4.3910000000E+04, 3.5731525461E+01, 5.0329815821E+00, 1.6744300494E+01, 3.4916483162E+00, 9.7045551732E-01],
	[4.3915000000E+04, 3.5738684033E+01, 5.0330207868E+00, 1.6750492240E+01, 3.4920047057E+00, 9.7046687310E-01],
	[4.3920000000E+04, 3.5745843223E+01, 5.0330599874E+00, 1.6756685568E+01, 3.4923610140E+00, 9.7047822389E-01],
	[4.3925000000E+04, 3.5753003032E+01, 5.0330991838E+00, 1.6762880481E+01, 3.4927172411E+00, 9.7048956972E-01],
	[4.3930000000E+04, 3.5760163460E+01, 5.0331383761E+00, 1.6769076977E+01, 3.4930733870E+00, 9.7050091057E-01],
	[4.3935000000E+04, 3.5767324508E+01, 5.0331775642E+00, 1.6775275057E+01, 3.4934294517E+00, 9.7051224646E-01],
	[4.3940000000E+04, 3.5774486173E+01, 5.0332167482E+00, 1.6781474721E+01, 3.4937854353E+00, 9.7052357738E-01],
	[4.3945000000E+04, 3.5781648458E+01, 5.0332559280E+00, 1.6787675969E+01, 3.4941413377E+00, 9.7053490334E-01],
	[4.3950000000E+04, 3.5788811362E+01, 5.0332951037E+00, 1.6793878803E+01, 3.4944971590E+00, 9.7054622433E-01],
	[4.3955000000E+04, 3.5795974884E+01, 5.0333342752E+00, 1.6800083221E+01, 3.4948528992E+00, 9.7055754037E-01],
	[4.3960000000E+04, 3.5803139025E+01, 5.0333734425E+00, 1.6806289224E+01, 3.4952085583E+00, 9.7056885145E-01],
	[4.3965000000E+04, 3.5810303785E+01, 5.0334126057E+00, 1.6812496812E+01, 3.4955641363E+00, 9.7058015758E-01],
	[4.3970000000E+04, 3.5817469164E+01, 5.0334517648E+00, 1.6818705986E+01, 3.4959196332E+00, 9.7059145876E-01],
	[4.3975000000E+04, 3.5824635161E+01, 5.0334909197E+00, 1.6824916746E+01, 3.4962750491E+00, 9.7060275499E-01],
	[4.3980000000E+04, 3.5831801777E+01, 5.0335300705E+00, 1.6831129092E+01, 3.4966303840E+00, 9.7061404627E-01],
	[4.3985000000E+04, 3.5838969012E+01, 5.0335692171E+00, 1.6837343024E+01, 3.4969856378E+00, 9.7062533261E-01],
	[4.3990000000E+04, 3.5846136866E+01, 5.0336083595E+00, 1.6843558542E+01, 3.4973408106E+00, 9.7063661401E-01],
	[4.3995000000E+04, 3.5853305338E+01, 5.0336474979E+00, 1.6849775647E+01, 3.4976959025E+00, 9.7064789047E-01],
	[4.4000000000E+04, 3.5860474429E+01, 5.0336866320E+00, 1.6855994339E+01, 3.4980509134E+00, 9.7065916199E-01],
	[4.4005000000E+04, 3.5867644138E+01, 5.0337257621E+00, 1.6862214618E+01, 3.4984058433E+00, 9.7067042858E-01],
	[4.4010000000E+04, 3.5874814466E+01, 5.0337648880E+00, 1.6868436484E+01, 3.4987606923E+00, 9.7068169023E-01],
	[4.4015000000E+04, 3.5881985413E+01, 5.0338040097E+00, 1.6874659938E+01, 3.4991154603E+00, 9.7069294696E-01],
	[4.4020000000E+04, 3.5889156979E+01, 5.0338431273E+00, 1.6880884979E+01, 3.4994701475E+00, 9.7070419876E-01],
	[4.4025000000E+04, 3.5896329162E+01, 5.0338822408E+00, 1.6887111609E+01, 3.4998247538E+00, 9.7071544564E-01],
	[4.4030000000E+04, 3.5903501965E+01, 5.0339213502E+00, 1.6893339827E+01, 3.5001792791E+00, 9.7072668759E-01],
	[4.4035000000E+04, 3.5910675386E+01, 5.0339604554E+00, 1.6899569633E+01, 3.5005337237E+00, 9.7073792463E-01],
	[4.4040000000E+04, 3.5917849425E+01, 5.0339995564E+00, 1.6905801028E+01, 3.5008880873E+00, 9.7074915675E-01],
	[4.4045000000E+04, 3.5925024083E+01, 5.0340386534E+00, 1.6912034012E+01, 3.5012423702E+00, 9.7076038395E-01],
	[4.4050000000E+04, 3.5932199360E+01, 5.0340777462E+00, 1.6918268585E+01, 3.5015965722E+00, 9.7077160624E-01],
	[4.4055000000E+04, 3.5939375255E+01, 5.0341168348E+00, 1.6924504747E+01, 3.5019506934E+00, 9.7078282362E-01],
	[4.4060000000E+04, 3.5946551768E+01, 5.0341559193E+00, 1.6930742499E+01, 3.5023047339E+00, 9.7079403609E-01],
	[4.4065000000E+04, 3.5953728900E+01, 5.0341949997E+00, 1.6936981840E+01, 3.5026586935E+00, 9.7080524366E-01],
	[4.4070000000E+04, 3.5960906650E+01, 5.0342340760E+00, 1.6943222772E+01, 3.5030125725E+00, 9.7081644633E-01],
	[4.4075000000E+04, 3.5968085019E+01, 5.0342731482E+00, 1.6949465294E+01, 3.5033663707E+00, 9.7082764409E-01],
	[4.4080000000E+04, 3.5975264006E+01, 5.0343122162E+00, 1.6955709406E+01, 3.5037200881E+00, 9.7083883696E-01],
	[4.4085000000E+04, 3.5982443611E+01, 5.0343512800E+00, 1.6961955109E+01, 3.5040737249E+00, 9.7085002493E-01],
	[4.4090000000E+04, 3.5989623835E+01, 5.0343903398E+00, 1.6968202403E+01, 3.5044272810E+00, 9.7086120801E-01],
	[4.4095000000E+04, 3.5996804677E+01, 5.0344293954E+00, 1.6974451288E+01, 3.5047807563E+00, 9.7087238620E-01],
	[4.4100000000E+04, 3.6003986137E+01, 5.0344684469E+00, 1.6980701765E+01, 3.5051341511E+00, 9.7088355950E-01],
	[4.4105000000E+04, 3.6011168216E+01, 5.0345074943E+00, 1.6986953833E+01, 3.5054874652E+00, 9.7089472792E-01],
	[4.4110000000E+04, 3.6018350913E+01, 5.0345465375E+00, 1.6993207492E+01, 3.5058406986E+00, 9.7090589145E-01],
	[4.4115000000E+04, 3.6025534228E+01, 5.0345855767E+00, 1.6999462744E+01, 3.5061938515E+00, 9.7091705010E-01],
	[4.4120000000E+04, 3.6032718162E+01, 5.0346246117E+00, 1.7005719588E+01, 3.5065469238E+00, 9.7092820387E-01],
	[4.4125000000E+04, 3.6039902713E+01, 5.0346636426E+00, 1.7011978025E+01, 3.5068999154E+00, 9.7093935277E-01],
	[4.4130000000E+04, 3.6047087883E+01, 5.0347026693E+00, 1.7018238054E+01, 3.5072528265E+00, 9.7095049679E-01],
	[4.4135000000E+04, 3.6054273671E+01, 5.0347416920E+00, 1.7024499676E+01, 3.5076056571E+00, 9.7096163594E-01],
	[4.4140000000E+04, 3.6061460078E+01, 5.0347807105E+00, 1.7030762892E+01, 3.5079584071E+00, 9.7097277023E-01],
	[4.4145000000E+04, 3.6068647102E+01, 5.0348197249E+00, 1.7037027701E+01, 3.5083110767E+00, 9.7098389964E-01],
	[4.4150000000E+04, 3.6075834745E+01, 5.0348587352E+00, 1.7043294103E+01, 3.5086636657E+00, 9.7099502419E-01],
	[4.4155000000E+04, 3.6083023006E+01, 5.0348977414E+00, 1.7049562099E+01, 3.5090161742E+00, 9.7100614388E-01],
	[4.4160000000E+04, 3.6090211884E+01, 5.0349367435E+00, 1.7055831689E+01, 3.5093686022E+00, 9.7101725871E-01],
	[4.4165000000E+04, 3.6097401381E+01, 5.0349757414E+00, 1.7062102874E+01, 3.5097209498E+00, 9.7102836869E-01],
	[4.4170000000E+04, 3.6104591496E+01, 5.0350147353E+00, 1.7068375653E+01, 3.5100732170E+00, 9.7103947381E-01],
	[4.4175000000E+04, 3.6111782229E+01, 5.0350537250E+00, 1.7074650027E+01, 3.5104254037E+00, 9.7105057407E-01],
	[4.4180000000E+04, 3.6118973581E+01, 5.0350927106E+00, 1.7080925995E+01, 3.5107775101E+00, 9.7106166949E-01],
	[4.4185000000E+04, 3.6126165550E+01, 5.0351316921E+00, 1.7087203559E+01, 3.5111295360E+00, 9.7107276006E-01],
	[4.4190000000E+04, 3.6133358137E+01, 5.0351706695E+00, 1.7093482719E+01, 3.5114814815E+00, 9.7108384579E-01],
	[4.4195000000E+04, 3.6140551342E+01, 5.0352096428E+00, 1.7099763473E+01, 3.5118333467E+00, 9.7109492667E-01],
	[4.4200000000E+04, 3.6147745165E+01, 5.0352486120E+00, 1.7106045824E+01, 3.5121851316E+00, 9.7110600271E-01],
	[4.4205000000E+04, 3.6154939606E+01, 5.0352875771E+00, 1.7112329771E+01, 3.5125368361E+00, 9.7111707392E-01],
	[4.4210000000E+04, 3.6162134665E+01, 5.0353265380E+00, 1.7118615314E+01, 3.5128884603E+00, 9.7112814029E-01],
	[4.4215000000E+04, 3.6169330342E+01, 5.0353654949E+00, 1.7124902454E+01, 3.5132400042E+00, 9.7113920183E-01],
	[4.4220000000E+04, 3.6176526637E+01, 5.0354044477E+00, 1.7131191190E+01, 3.5135914679E+00, 9.7115025853E-01],
	[4.4225000000E+04, 3.6183723550E+01, 5.0354433963E+00, 1.7137481524E+01, 3.5139428512E+00, 9.7116131041E-01],
	[4.4230000000E+04, 3.6190921081E+01, 5.0354823409E+00, 1.7143773454E+01, 3.5142941543E+00, 9.7117235746E-01],
	[4.4235000000E+04, 3.6198119229E+01, 5.0355212813E+00, 1.7150066982E+01, 3.5146453772E+00, 9.7118339969E-01],
	[4.4240000000E+04, 3.6205317996E+01, 5.0355602177E+00, 1.7156362108E+01, 3.5149965199E+00, 9.7119443710E-01],
	[4.4245000000E+04, 3.6212517380E+01, 5.0355991500E+00, 1.7162658831E+01, 3.5153475823E+00, 9.7120546969E-01],
	[4.4250000000E+04, 3.6219717382E+01, 5.0356380781E+00, 1.7168957153E+01, 3.5156985646E+00, 9.7121649746E-01],
	[4.4255000000E+04, 3.6226918002E+01, 5.0356770022E+00, 1.7175257073E+01, 3.5160494667E+00, 9.7122752042E-01],
	[4.4260000000E+04, 3.6234119239E+01, 5.0357159221E+00, 1.7181558591E+01, 3.5164002886E+00, 9.7123853857E-01],
	[4.4265000000E+04, 3.6241321095E+01, 5.0357548380E+00, 1.7187861708E+01, 3.5167510304E+00, 9.7124955191E-01],
	[4.4270000000E+04, 3.6248523568E+01, 5.0357937498E+00, 1.7194166425E+01, 3.5171016921E+00, 9.7126056044E-01],
	[4.4275000000E+04, 3.6255726659E+01, 5.0358326575E+00, 1.7200472740E+01, 3.5174522736E+00, 9.7127156417E-01],
	[4.4280000000E+04, 3.6262930367E+01, 5.0358715610E+00, 1.7206780655E+01, 3.5178027751E+00, 9.7128256309E-01],
	[4.4285000000E+04, 3.6270134693E+01, 5.0359104605E+00, 1.7213090170E+01, 3.5181531965E+00, 9.7129355722E-01],
	[4.4290000000E+04, 3.6277339637E+01, 5.0359493559E+00, 1.7219401284E+01, 3.5185035378E+00, 9.7130454655E-01],
	[4.4295000000E+04, 3.6284545199E+01, 5.0359882473E+00, 1.7225713999E+01, 3.5188537991E+00, 9.7131553108E-01],
	[4.4300000000E+04, 3.6291751378E+01, 5.0360271345E+00, 1.7232028313E+01, 3.5192039803E+00, 9.7132651082E-01],
	[4.4305000000E+04, 3.6298958175E+01, 5.0360660176E+00, 1.7238344229E+01, 3.5195540815E+00, 9.7133748578E-01],
	[4.4310000000E+04, 3.6306165589E+01, 5.0361048967E+00, 1.7244661745E+01, 3.5199041028E+00, 9.7134845594E-01],
	[4.4315000000E+04, 3.6313373621E+01, 5.0361437716E+00, 1.7250980862E+01, 3.5202540440E+00, 9.7135942132E-01],
	[4.4320000000E+04, 3.6320582271E+01, 5.0361826425E+00, 1.7257301581E+01, 3.5206039053E+00, 9.7137038191E-01],
	[4.4325000000E+04, 3.6327791538E+01, 5.0362215093E+00, 1.7263623901E+01, 3.5209536866E+00, 9.7138133773E-01],
	[4.4330000000E+04, 3.6335001423E+01, 5.0362603720E+00, 1.7269947823E+01, 3.5213033880E+00, 9.7139228877E-01],
	[4.4335000000E+04, 3.6342211925E+01, 5.0362992306E+00, 1.7276273346E+01, 3.5216530095E+00, 9.7140323503E-01],
	[4.4340000000E+04, 3.6349423045E+01, 5.0363380851E+00, 1.7282600472E+01, 3.5220025511E+00, 9.7141417651E-01],
	[4.4345000000E+04, 3.6356634782E+01, 5.0363769356E+00, 1.7288929200E+01, 3.5223520128E+00, 9.7142511323E-01],
	[4.4350000000E+04, 3.6363847137E+01, 5.0364157820E+00, 1.7295259531E+01, 3.5227013946E+00, 9.7143604518E-01],
	[4.4355000000E+04, 3.6371060109E+01, 5.0364546243E+00, 1.7301591464E+01, 3.5230506965E+00, 9.7144697236E-01],
	[4.4360000000E+04, 3.6378273698E+01, 5.0364934625E+00, 1.7307925001E+01, 3.5233999186E+00, 9.7145789478E-01],
	[4.4365000000E+04, 3.6385487906E+01, 5.0365322966E+00, 1.7314260140E+01, 3.5237490609E+00, 9.7146881243E-01],
	[4.4370000000E+04, 3.6392702730E+01, 5.0365711267E+00, 1.7320596884E+01, 3.5240981234E+00, 9.7147972533E-01],
	[4.4375000000E+04, 3.6399918172E+01, 5.0366099527E+00, 1.7326935231E+01, 3.5244471060E+00, 9.7149063347E-01],
	[4.4380000000E+04, 3.6407134231E+01, 5.0366487746E+00, 1.7333275181E+01, 3.5247960089E+00, 9.7150153685E-01],
	[4.4385000000E+04, 3.6414350908E+01, 5.0366875924E+00, 1.7339616736E+01, 3.5251448321E+00, 9.7151243549E-01],
	[4.4390000000E+04, 3.6421568201E+01, 5.0367264062E+00, 1.7345959896E+01, 3.5254935755E+00, 9.7152332937E-01],
	[4.4395000000E+04, 3.6428786113E+01, 5.0367652159E+00, 1.7352304660E+01, 3.5258422391E+00, 9.7153421850E-01],
	[4.4400000000E+04, 3.6436004641E+01, 5.0368040215E+00, 1.7358651029E+01, 3.5261908231E+00, 9.7154510289E-01],
	[4.4405000000E+04, 3.6443223787E+01, 5.0368428231E+00, 1.7364999003E+01, 3.5265393273E+00, 9.7155598254E-01],
	[4.4410000000E+04, 3.6450443550E+01, 5.0368816205E+00, 1.7371348582E+01, 3.5268877519E+00, 9.7156685745E-01],
	[4.4415000000E+04, 3.6457663930E+01, 5.0369204140E+00, 1.7377699767E+01, 3.5272360968E+00, 9.7157772762E-01],
	[4.4420000000E+04, 3.6464884928E+01, 5.0369592033E+00, 1.7384052557E+01, 3.5275843620E+00, 9.7158859305E-01],
	[4.4425000000E+04, 3.6472106543E+01, 5.0369979886E+00, 1.7390406954E+01, 3.5279325476E+00, 9.7159945375E-01],
	[4.4430000000E+04, 3.6479328775E+01, 5.0370367698E+00, 1.7396762956E+01, 3.5282806536E+00, 9.7161030972E-01],
	[4.4435000000E+04, 3.6486551624E+01, 5.0370755469E+00, 1.7403120565E+01, 3.5286286800E+00, 9.7162116096E-01],
	[4.4440000000E+04, 3.6493775091E+01, 5.0371143200E+00, 1.7409479781E+01, 3.5289766268E+00, 9.7163200747E-01],
	[4.4445000000E+04, 3.6500999174E+01, 5.0371530890E+00, 1.7415840604E+01, 3.5293244940E+00, 9.7164284926E-01],
	[4.4450000000E+04, 3.6508223875E+01, 5.0371918540E+00, 1.7422203033E+01, 3.5296722817E+00, 9.7165368633E-01],
	[4.4455000000E+04, 3.6515449193E+01, 5.0372306149E+00, 1.7428567070E+01, 3.5300199898E+00, 9.7166451868E-01],
	[4.4460000000E+04, 3.6522675128E+01, 5.0372693717E+00, 1.7434932714E+01, 3.5303676184E+00, 9.7167534631E-01],
	[4.4465000000E+04, 3.6529901680E+01, 5.0373081245E+00, 1.7441299967E+01, 3.5307151675E+00, 9.7168616923E-01],
	[4.4470000000E+04, 3.6537128849E+01, 5.0373468732E+00, 1.7447668827E+01, 3.5310626371E+00, 9.7169698744E-01],
	[4.4475000000E+04, 3.6544356635E+01, 5.0373856178E+00, 1.7454039295E+01, 3.5314100272E+00, 9.7170780093E-01],
	[4.4480000000E+04, 3.6551585038E+01, 5.0374243584E+00, 1.7460411372E+01, 3.5317573378E+00, 9.7171860972E-01],
	[4.4485000000E+04, 3.6558814058E+01, 5.0374630949E+00, 1.7466785057E+01, 3.5321045690E+00, 9.7172941381E-01],
	[4.4490000000E+04, 3.6566043695E+01, 5.0375018274E+00, 1.7473160352E+01, 3.5324517208E+00, 9.7174021319E-01],
	[4.4495000000E+04, 3.6573273950E+01, 5.0375405558E+00, 1.7479537255E+01, 3.5327987932E+00, 9.7175100787E-01],
	[4.4500000000E+04, 3.6580504821E+01, 5.0375792802E+00, 1.7485915768E+01, 3.5331457861E+00, 9.7176179785E-01],
	[4.4505000000E+04, 3.6587736309E+01, 5.0376180005E+00, 1.7492295890E+01, 3.5334926997E+00, 9.7177258313E-01],
	[4.4510000000E+04, 3.6594968414E+01, 5.0376567168E+00, 1.7498677623E+01, 3.5338395339E+00, 9.7178336373E-01],
	[4.4515000000E+04, 3.6602201136E+01, 5.0376954290E+00, 1.7505060965E+01, 3.5341862888E+00, 9.7179413963E-01],
	[4.4520000000E+04, 3.6609434475E+01, 5.0377341372E+00, 1.7511445917E+01, 3.5345329643E+00, 9.7180491084E-01],
	[4.4525000000E+04, 3.6616668431E+01, 5.0377728413E+00, 1.7517832480E+01, 3.5348795605E+00, 9.7181567736E-01],
	[4.4530000000E+04, 3.6623903003E+01, 5.0378115414E+00, 1.7524220653E+01, 3.5352260774E+00, 9.7182643921E-01],
	[4.4535000000E+04, 3.6631138193E+01, 5.0378502374E+00, 1.7530610438E+01, 3.5355725150E+00, 9.7183719637E-01],
	[4.4540000000E+04, 3.6638373999E+01, 5.0378889293E+00, 1.7537001833E+01, 3.5359188734E+00, 9.7184794885E-01],
	[4.4545000000E+04, 3.6645610422E+01, 5.0379276173E+00, 1.7543394840E+01, 3.5362651524E+00, 9.7185869665E-01],
	[4.4550000000E+04, 3.6652847462E+01, 5.0379663011E+00, 1.7549789459E+01, 3.5366113523E+00, 9.7186943978E-01],
	[4.4555000000E+04, 3.6660085119E+01, 5.0380049810E+00, 1.7556185689E+01, 3.5369574729E+00, 9.7188017824E-01],
	[4.4560000000E+04, 3.6667323393E+01, 5.0380436568E+00, 1.7562583531E+01, 3.5373035143E+00, 9.7189091202E-01],
	[4.4565000000E+04, 3.6674562283E+01, 5.0380823285E+00, 1.7568982986E+01, 3.5376494765E+00, 9.7190164114E-01],
	[4.4570000000E+04, 3.6681801790E+01, 5.0381209962E+00, 1.7575384053E+01, 3.5379953596E+00, 9.7191236559E-01],
	[4.4575000000E+04, 3.6689041914E+01, 5.0381596599E+00, 1.7581786732E+01, 3.5383411635E+00, 9.7192308538E-01],
	[4.4580000000E+04, 3.6696282654E+01, 5.0381983195E+00, 1.7588191025E+01, 3.5386868882E+00, 9.7193380051E-01],
	[4.4585000000E+04, 3.6703526805E+01, 5.0382373143E+00, 1.7594596931E+01, 3.5390327271E+00, 9.7194451098E-01],
	[4.4590000000E+04, 3.6710783907E+01, 5.0382778027E+00, 1.7601004450E+01, 3.5393793408E+00, 9.7195521680E-01],
	[4.4595000000E+04, 3.6718041630E+01, 5.0383182869E+00, 1.7607413583E+01, 3.5397258755E+00, 9.7196591796E-01],
	[4.4600000000E+04, 3.6725299974E+01, 5.0383587668E+00, 1.7613824330E+01, 3.5400723314E+00, 9.7197661446E-01],
	[4.4605000000E+04, 3.6732558939E+01, 5.0383992426E+00, 1.7620236690E+01, 3.5404187085E+00, 9.7198730632E-01],
	[4.4610000000E+04, 3.6739818525E+01, 5.0384397141E+00, 1.7626650665E+01, 3.5407650067E+00, 9.7199799354E-01],
	[4.4615000000E+04, 3.6747078732E+01, 5.0384801814E+00, 1.7633066255E+01, 3.5411112261E+00, 9.7200867610E-01],
	[4.4620000000E+04, 3.6754339560E+01, 5.0385206445E+00, 1.7639483459E+01, 3.5414573667E+00, 9.7201935403E-01],
	[4.4625000000E+04, 3.6761601008E+01, 5.0385611034E+00, 1.7645902278E+01, 3.5418034286E+00, 9.7203002732E-01],
	[4.4630000000E+04, 3.6768863078E+01, 5.0386015581E+00, 1.7652322712E+01, 3.5421494117E+00, 9.7204069596E-01],
	[4.4635000000E+04, 3.6776125768E+01, 5.0386420086E+00, 1.7658744762E+01, 3.5424953160E+00, 9.7205135998E-01],
	[4.4640000000E+04, 3.6783389079E+01, 5.0386824549E+00, 1.7665168428E+01, 3.5428411416E+00, 9.7206201936E-01],
	[4.4645000000E+04, 3.6790653010E+01, 5.0387228970E+00, 1.7671593709E+01, 3.5431868884E+00, 9.7207267411E-01],
	[4.4650000000E+04, 3.6797917563E+01, 5.0387633349E+00, 1.7678020606E+01, 3.5435325566E+00, 9.7208332423E-01],
	[4.4655000000E+04, 3.6805182736E+01, 5.0388037685E+00, 1.7684449120E+01, 3.5438781461E+00, 9.7209396972E-01],
	[4.4660000000E+04, 3.6812448530E+01, 5.0388441980E+00, 1.7690879250E+01, 3.5442236569E+00, 9.7210461059E-01],
	[4.4665000000E+04, 3.6819714944E+01, 5.0388846233E+00, 1.7697310997E+01, 3.5445690891E+00, 9.7211524684E-01],
	[4.4670000000E+04, 3.6826981980E+01, 5.0389250443E+00, 1.7703744361E+01, 3.5449144426E+00, 9.7212587847E-01],
	[4.4675000000E+04, 3.6834249636E+01, 5.0389654612E+00, 1.7710179342E+01, 3.5452597175E+00, 9.7213650549E-01],
	[4.4680000000E+04, 3.6841517912E+01, 5.0390058739E+00, 1.7716615940E+01, 3.5456049138E+00, 9.7214712788E-01],
	[4.4685000000E+04, 3.6848786810E+01, 5.0390462823E+00, 1.7723054156E+01, 3.5459500315E+00, 9.7215774567E-01],
	[4.4690000000E+04, 3.6856056327E+01, 5.0390866866E+00, 1.7729493990E+01, 3.5462950706E+00, 9.7216835884E-01],
	[4.4695000000E+04, 3.6863326466E+01, 5.0391270867E+00, 1.7735935442E+01, 3.5466400312E+00, 9.7217896741E-01],
	[4.4700000000E+04, 3.6870597225E+01, 5.0391674825E+00, 1.7742378513E+01, 3.5469849132E+00, 9.7218957136E-01],
	[4.4705000000E+04, 3.6877868605E+01, 5.0392078742E+00, 1.7748823202E+01, 3.5473297167E+00, 9.7220017072E-01],
	[4.4710000000E+04, 3.6885140605E+01, 5.0392482617E+00, 1.7755269510E+01, 3.5476744417E+00, 9.7221076547E-01],
	[4.4715000000E+04, 3.6892413226E+01, 5.0392886450E+00, 1.7761717437E+01, 3.5480190882E+00, 9.7222135562E-01],
	[4.4720000000E+04, 3.6899686467E+01, 5.0393290241E+00, 1.7768166983E+01, 3.5483636562E+00, 9.7223194117E-01],
	[4.4725000000E+04, 3.6906960329E+01, 5.0393693990E+00, 1.7774618148E+01, 3.5487081458E+00, 9.7224252213E-01],
	[4.4730000000E+04, 3.6914234811E+01, 5.0394097698E+00, 1.7781070933E+01, 3.5490525568E+00, 9.7225309849E-01],
	[4.4735000000E+04, 3.6921509914E+01, 5.0394501363E+00, 1.7787525338E+01, 3.5493968895E+00, 9.7226367026E-01],
	[4.4740000000E+04, 3.6928785637E+01, 5.0394904986E+00, 1.7793981364E+01, 3.5497411438E+00, 9.7227423744E-01],
	[4.4745000000E+04, 3.6936061981E+01, 5.0395308568E+00, 1.7800439009E+01, 3.5500853196E+00, 9.7228480003E-01],
	[4.4750000000E+04, 3.6943338945E+01, 5.0395712108E+00, 1.7806898275E+01, 3.5504294171E+00, 9.7229535804E-01],
	[4.4755000000E+04, 3.6950616529E+01, 5.0396115606E+00, 1.7813359162E+01, 3.5507734362E+00, 9.7230591146E-01],
	[4.4760000000E+04, 3.6957894734E+01, 5.0396519062E+00, 1.7819821670E+01, 3.5511173769E+00, 9.7231646030E-01],
	[4.4765000000E+04, 3.6965173559E+01, 5.0396922476E+00, 1.7826285800E+01, 3.5514612393E+00, 9.7232700457E-01],
	[4.4770000000E+04, 3.6972453005E+01, 5.0397325848E+00, 1.7832751550E+01, 3.5518050234E+00, 9.7233754425E-01],
	[4.4775000000E+04, 3.6979733071E+01, 5.0397729179E+00, 1.7839218923E+01, 3.5521487291E+00, 9.7234807937E-01],
	[4.4780000000E+04, 3.6987013757E+01, 5.0398132467E+00, 1.7845687917E+01, 3.5524923566E+00, 9.7235860990E-01],
	[4.4785000000E+04, 3.6994295064E+01, 5.0398535714E+00, 1.7852158534E+01, 3.5528359058E+00, 9.7236913587E-01],
	[4.4790000000E+04, 3.7001576990E+01, 5.0398938919E+00, 1.7858630773E+01, 3.5531793768E+00, 9.7237965727E-01],
	[4.4795000000E+04, 3.7008859538E+01, 5.0399342083E+00, 1.7865104634E+01, 3.5535227695E+00, 9.7239017410E-01],
	[4.4800000000E+04, 3.7016142705E+01, 5.0399745204E+00, 1.7871580119E+01, 3.5538660839E+00, 9.7240068637E-01],
	[4.4805000000E+04, 3.7023426493E+01, 5.0400148284E+00, 1.7878057226E+01, 3.5542093202E+00, 9.7241119408E-01],
	[4.4810000000E+04, 3.7030710901E+01, 5.0400551322E+00, 1.7884535957E+01, 3.5545524783E+00, 9.7242169723E-01],
	[4.4815000000E+04, 3.7037995929E+01, 5.0400954319E+00, 1.7891016311E+01, 3.5548955582E+00, 9.7243219581E-01],
	[4.4820000000E+04, 3.7045281577E+01, 5.0401357273E+00, 1.7897498289E+01, 3.5552385599E+00, 9.7244268985E-01],
	[4.4825000000E+04, 3.7052567845E+01, 5.0401760186E+00, 1.7903981891E+01, 3.5555814835E+00, 9.7245317933E-01],
	[4.4830000000E+04, 3.7059854734E+01, 5.0402163057E+00, 1.7910467117E+01, 3.5559243289E+00, 9.7246366425E-01],
	[4.4835000000E+04, 3.7067142243E+01, 5.0402565887E+00, 1.7916953968E+01, 3.5562670963E+00, 9.7247414463E-01],
	[4.4840000000E+04, 3.7074430372E+01, 5.0402968674E+00, 1.7923442443E+01, 3.5566097855E+00, 9.7248462046E-01],
	[4.4845000000E+04, 3.7081719121E+01, 5.0403371420E+00, 1.7929932543E+01, 3.5569523966E+00, 9.7249509175E-01],
	[4.4850000000E+04, 3.7089008490E+01, 5.0403774125E+00, 1.7936424268E+01, 3.5572949297E+00, 9.7250555849E-01],
	[4.4855000000E+04, 3.7096298479E+01, 5.0404176787E+00, 1.7942917618E+01, 3.5576373847E+00, 9.7251602069E-01],
	[4.4860000000E+04, 3.7103589088E+01, 5.0404579408E+00, 1.7949412594E+01, 3.5579797617E+00, 9.7252647835E-01],
	[4.4865000000E+04, 3.7110880318E+01, 5.0404981988E+00, 1.7955909196E+01, 3.5583220607E+00, 9.7253693148E-01],
	[4.4870000000E+04, 3.7118172167E+01, 5.0405384525E+00, 1.7962407424E+01, 3.5586642816E+00, 9.7254738007E-01],
	[4.4875000000E+04, 3.7125464636E+01, 5.0405787021E+00, 1.7968907278E+01, 3.5590064246E+00, 9.7255782412E-01],
	[4.4880000000E+04, 3.7132757726E+01, 5.0406189476E+00, 1.7975408758E+01, 3.5593484896E+00, 9.7256826365E-01],
	[4.4885000000E+04, 3.7140051435E+01, 5.0406591889E+00, 1.7981911865E+01, 3.5596904767E+00, 9.7257869865E-01],
	[4.4890000000E+04, 3.7147345765E+01, 5.0406994260E+00, 1.7988416599E+01, 3.5600323858E+00, 9.7258912912E-01],
	[4.4895000000E+04, 3.7154640714E+01, 5.0407396589E+00, 1.7994922960E+01, 3.5603742169E+00, 9.7259955507E-01],
	[4.4900000000E+04, 3.7161936283E+01, 5.0407798877E+00, 1.8001430948E+01, 3.5607159702E+00, 9.7260997650E-01],
	[4.4905000000E+04, 3.7169232472E+01, 5.0408201124E+00, 1.8007940564E+01, 3.5610576456E+00, 9.7262039340E-01],
	[4.4910000000E+04, 3.7176529281E+01, 5.0408603329E+00, 1.8014451808E+01, 3.5613992431E+00, 9.7263080579E-01],
	[4.4915000000E+04, 3.7183826710E+01, 5.0409005492E+00, 1.8020964680E+01, 3.5617407627E+00, 9.7264121366E-01],
	[4.4920000000E+04, 3.7191124759E+01, 5.0409407614E+00, 1.8027479180E+01, 3.5620822045E+00, 9.7265161702E-01],
	[4.4925000000E+04, 3.7198423427E+01, 5.0409809694E+00, 1.8033995308E+01, 3.5624235684E+00, 9.7266201587E-01],
	[4.4930000000E+04, 3.7205722716E+01, 5.0410211732E+00, 1.8040513065E+01, 3.5627648546E+00, 9.7267241021E-01],
	[4.4935000000E+04, 3.7213022624E+01, 5.0410613730E+00, 1.8047032451E+01, 3.5631060629E+00, 9.7268280004E-01],
	[4.4940000000E+04, 3.7220323152E+01, 5.0411015685E+00, 1.8053553467E+01, 3.5634471935E+00, 9.7269318537E-01],
	[4.4945000000E+04, 3.7227624300E+01, 5.0411417599E+00, 1.8060076111E+01, 3.5637882463E+00, 9.7270356619E-01],
	[4.4950000000E+04, 3.7234926068E+01, 5.0411819472E+00, 1.8066600385E+01, 3.5641292213E+00, 9.7271394251E-01],
	[4.4955000000E+04, 3.7242228455E+01, 5.0412221303E+00, 1.8073126289E+01, 3.5644701186E+00, 9.7272431433E-01],
	[4.4960000000E+04, 3.7249531462E+01, 5.0412623092E+00, 1.8079653823E+01, 3.5648109382E+00, 9.7273468166E-01],
	[4.4965000000E+04, 3.7256835089E+01, 5.0413024840E+00, 1.8086182988E+01, 3.5651516801E+00, 9.7274504449E-01],
	[4.4970000000E+04, 3.7264139336E+01, 5.0413426547E+00, 1.8092713782E+01, 3.5654923443E+00, 9.7275540283E-01],
	[4.4975000000E+04, 3.7271444202E+01, 5.0413828212E+00, 1.8099246208E+01, 3.5658329308E+00, 9.7276575668E-01],
	[4.4980000000E+04, 3.7278749688E+01, 5.0414229836E+00, 1.8105780264E+01, 3.5661734397E+00, 9.7277610604E-01],
	[4.4985000000E+04, 3.7286055793E+01, 5.0414631418E+00, 1.8112315952E+01, 3.5665138709E+00, 9.7278645091E-01],
	[4.4990000000E+04, 3.7293362518E+01, 5.0415032959E+00, 1.8118853271E+01, 3.5668542245E+00, 9.7279679130E-01],
	[4.4995000000E+04, 3.7300669863E+01, 5.0415434458E+00, 1.8125392222E+01, 3.5671945005E+00, 9.7280712720E-01],
	[4.5000000000E+04, 3.7307977828E+01, 5.0415835916E+00, 1.8131932804E+01, 3.5675346989E+00, 9.7281745863E-01],
	[4.5005000000E+04, 3.7315286412E+01, 5.0416237333E+00, 1.8138492565E+01, 3.5678754986E+00, 9.7282778558E-01],
	[4.5010000000E+04, 3.7322595615E+01, 5.0416638708E+00, 1.8145053969E+01, 3.5682162205E+00, 9.7283810805E-01],
	[4.5015000000E+04, 3.7329905438E+01, 5.0417040042E+00, 1.8151617016E+01, 3.5685568645E+00, 9.7284842605E-01],
	[4.5020000000E+04, 3.7337215881E+01, 5.0417441334E+00, 1.8158181707E+01, 3.5688974306E+00, 9.7285873958E-01],
	[4.5025000000E+04, 3.7344526943E+01, 5.0417842585E+00, 1.8164748041E+01, 3.5692379190E+00, 9.7286904864E-01],
	[4.5030000000E+04, 3.7351838625E+01, 5.0418243795E+00, 1.8171316020E+01, 3.5695783296E+00, 9.7287935323E-01],
	[4.5035000000E+04, 3.7359150926E+01, 5.0418644963E+00, 1.8177885642E+01, 3.5699186623E+00, 9.7288965336E-01],
	[4.5040000000E+04, 3.7366463847E+01, 5.0419046090E+00, 1.8184456910E+01, 3.5702589173E+00, 9.7289994902E-01],
	[4.5045000000E+04, 3.7373777387E+01, 5.0419447176E+00, 1.8191029822E+01, 3.5705990946E+00, 9.7291024022E-01],
	[4.5050000000E+04, 3.7381091547E+01, 5.0419848220E+00, 1.8197604379E+01, 3.5709391941E+00, 9.7292052696E-01],
	[4.5055000000E+04, 3.7388406326E+01, 5.0420249223E+00, 1.8204180581E+01, 3.5712792159E+00, 9.7293080925E-01],
	[4.5060000000E+04, 3.7395721724E+01, 5.0420650185E+00, 1.8210758429E+01, 3.5716191600E+00, 9.7294108708E-01],
	[4.5065000000E+04, 3.7403037742E+01, 5.0421051105E+00, 1.8217337922E+01, 3.5719590264E+00, 9.7295136045E-01],
	[4.5070000000E+04, 3.7410354379E+01, 5.0421451984E+00, 1.8223919061E+01, 3.5722988152E+00, 9.7296162938E-01],
	[4.5075000000E+04, 3.7417671636E+01, 5.0421852822E+00, 1.8230501846E+01, 3.5726385263E+00, 9.7297189386E-01],
	[4.5080000000E+04, 3.7424989512E+01, 5.0422253618E+00, 1.8237086277E+01, 3.5729781597E+00, 9.7298215389E-01],
	[4.5085000000E+04, 3.7432308007E+01, 5.0422654374E+00, 1.8243672355E+01, 3.5733177155E+00, 9.7299240948E-01],
	[4.5090000000E+04, 3.7439627122E+01, 5.0423055088E+00, 1.8250260080E+01, 3.5736571937E+00, 9.7300266062E-01],
	[4.5095000000E+04, 3.7446946855E+01, 5.0423455760E+00, 1.8256849452E+01, 3.5739965944E+00, 9.7301290733E-01],
	[4.5100000000E+04, 3.7454267209E+01, 5.0423856392E+00, 1.8263440471E+01, 3.5743359174E+00, 9.7302314959E-01],
	[4.5105000000E+04, 3.7461588181E+01, 5.0424256982E+00, 1.8270033137E+01, 3.5746751629E+00, 9.7303338742E-01],
	[4.5110000000E+04, 3.7468909773E+01, 5.0424657531E+00, 1.8276627452E+01, 3.5750143308E+00, 9.7304362082E-01],
	[4.5115000000E+04, 3.7476231983E+01, 5.0425058039E+00, 1.8283223414E+01, 3.5753534213E+00, 9.7305384978E-01],
	[4.5120000000E+04, 3.7483554814E+01, 5.0425458506E+00, 1.8289821024E+01, 3.5756924342E+00, 9.7306407432E-01],
	[4.5125000000E+04, 3.7490878263E+01, 5.0425858931E+00, 1.8296420283E+01, 3.5760313696E+00, 9.7307429443E-01],
	[4.5130000000E+04, 3.7498202331E+01, 5.0426259315E+00, 1.8303021190E+01, 3.5763702275E+00, 9.7308451011E-01],
	[4.5135000000E+04, 3.7505527019E+01, 5.0426659658E+00, 1.8309623746E+01, 3.5767090080E+00, 9.7309472136E-01],
	[4.5140000000E+04, 3.7512852326E+01, 5.0427059960E+00, 1.8316227951E+01, 3.5770477110E+00, 9.7310492820E-01],
	[4.5145000000E+04, 3.7520178252E+01, 5.0427460221E+00, 1.8322833805E+01, 3.5773863366E+00, 9.7311513062E-01],
	[4.5150000000E+04, 3.7527504797E+01, 5.0427860441E+00, 1.8329441309E+01, 3.5777248848E+00, 9.7312532862E-01],
	[4.5155000000E+04, 3.7534831961E+01, 5.0428260619E+00, 1.8336050463E+01, 3.5780633555E+00, 9.7313552220E-01],
	[4.5160000000E+04, 3.7542159744E+01, 5.0428660756E+00, 1.8342661267E+01, 3.5784017489E+00, 9.7314571137E-01],
	[4.5165000000E+04, 3.7549488146E+01, 5.0429060853E+00, 1.8349273721E+01, 3.5787400650E+00, 9.7315589613E-01],
	[4.5170000000E+04, 3.7556817168E+01, 5.0429460908E+00, 1.8355887825E+01, 3.5790783036E+00, 9.7316607648E-01],
	[4.5175000000E+04, 3.7564146808E+01, 5.0429860922E+00, 1.8362503580E+01, 3.5794164650E+00, 9.7317625243E-01],
	[4.5180000000E+04, 3.7571477068E+01, 5.0430260894E+00, 1.8369120986E+01, 3.5797545490E+00, 9.7318642396E-01],
	[4.5185000000E+04, 3.7578807946E+01, 5.0430660826E+00, 1.8375740043E+01, 3.5800925557E+00, 9.7319659110E-01],
	[4.5190000000E+04, 3.7586139443E+01, 5.0431060717E+00, 1.8382360751E+01, 3.5804304851E+00, 9.7320675384E-01],
	[4.5195000000E+04, 3.7593471560E+01, 5.0431460567E+00, 1.8388983111E+01, 3.5807683373E+00, 9.7321691217E-01],
	[4.5200000000E+04, 3.7600804295E+01, 5.0431860375E+00, 1.8395607123E+01, 3.5811061122E+00, 9.7322706611E-01],
	[4.5205000000E+04, 3.7608137649E+01, 5.0432260143E+00, 1.8402232787E+01, 3.5814438098E+00, 9.7323721566E-01],
	[4.5210000000E+04, 3.7615471623E+01, 5.0432659869E+00, 1.8408860103E+01, 3.5817814303E+00, 9.7324736081E-01],
	[4.5215000000E+04, 3.7622806215E+01, 5.0433059554E+00, 1.8415489071E+01, 3.5821189735E+00, 9.7325750158E-01],
	[4.5220000000E+04, 3.7630141426E+01, 5.0433459199E+00, 1.8422119692E+01, 3.5824564396E+00, 9.7326763795E-01],
	[4.5225000000E+04, 3.7637477256E+01, 5.0433858802E+00, 1.8428751967E+01, 3.5827938284E+00, 9.7327776994E-01],
	[4.5230000000E+04, 3.7644813704E+01, 5.0434258365E+00, 1.8435385894E+01, 3.5831311401E+00, 9.7328789754E-01],
	[4.5235000000E+04, 3.7652150772E+01, 5.0434657886E+00, 1.8442021475E+01, 3.5834683747E+00, 9.7329802077E-01],
	[4.5240000000E+04, 3.7659488458E+01, 5.0435057366E+00, 1.8448658709E+01, 3.5838055322E+00, 9.7330813961E-01],
	[4.5245000000E+04, 3.7666826764E+01, 5.0435456806E+00, 1.8455297598E+01, 3.5841426125E+00, 9.7331825407E-01],
	[4.5250000000E+04, 3.7674165688E+01, 5.0435856204E+00, 1.8461938140E+01, 3.5844796157E+00, 9.7332836416E-01],
	[4.5255000000E+04, 3.7681505230E+01, 5.0436255561E+00, 1.8468580337E+01, 3.5848165419E+00, 9.7333846988E-01],
	[4.5260000000E+04, 3.7688845392E+01, 5.0436654878E+00, 1.8475224188E+01, 3.5851533910E+00, 9.7334857122E-01],
	[4.5265000000E+04, 3.7696186172E+01, 5.0437054153E+00, 1.8481869694E+01, 3.5854901630E+00, 9.7335866819E-01],
	[4.5270000000E+04, 3.7703527571E+01, 5.0437453388E+00, 1.8488516855E+01, 3.5858268580E+00, 9.7336876080E-01],
	[4.5275000000E+04, 3.7710869589E+01, 5.0437852582E+00, 1.8495165672E+01, 3.5861634760E+00, 9.7337884904E-01],
	[4.5280000000E+04, 3.7718212225E+01, 5.0438251734E+00, 1.8501816143E+01, 3.5865000171E+00, 9.7338893292E-01],
	[4.5285000000E+04, 3.7725555480E+01, 5.0438650846E+00, 1.8508468271E+01, 3.5868364811E+00, 9.7339901244E-01],
	[4.5290000000E+04, 3.7732899354E+01, 5.0439049917E+00, 1.8515122054E+01, 3.5871728681E+00, 9.7340908759E-01],
	[4.5295000000E+04, 3.7740243847E+01, 5.0439448947E+00, 1.8521777494E+01, 3.5875091782E+00, 9.7341915839E-01],
	[4.5300000000E+04, 3.7747588958E+01, 5.0439847936E+00, 1.8528434590E+01, 3.5878454114E+00, 9.7342922484E-01],
	[4.5305000000E+04, 3.7754944267E+01, 5.0440258315E+00, 1.8535093343E+01, 3.5881822326E+00, 9.7343928693E-01],
	[4.5310000000E+04, 3.7762305679E+01, 5.0440675191E+00, 1.8541753752E+01, 3.5885193576E+00, 9.7344934467E-01],
	[4.5315000000E+04, 3.7769667714E+01, 5.0441092025E+00, 1.8548415819E+01, 3.5888564059E+00, 9.7345939806E-01],
	[4.5320000000E+04, 3.7777030372E+01, 5.0441508816E+00, 1.8555079542E+01, 3.5891933775E+00, 9.7346944710E-01],
	[4.5325000000E+04, 3.7784393653E+01, 5.0441925565E+00, 1.8561744924E+01, 3.5895302724E+00, 9.7347949180E-01],
	[4.5330000000E+04, 3.7791757556E+01, 5.0442342271E+00, 1.8568411963E+01, 3.5898670908E+00, 9.7348953216E-01],
	[4.5335000000E+04, 3.7799122082E+01, 5.0442758934E+00, 1.8575080660E+01, 3.5902038325E+00, 9.7349956818E-01],
	[4.5340000000E+04, 3.7806487231E+01, 5.0443175555E+00, 1.8581751015E+01, 3.5905404976E+00, 9.7350959985E-01],
	[4.5345000000E+04, 3.7813853003E+01, 5.0443592134E+00, 1.8588423029E+01, 3.5908770862E+00, 9.7351962719E-01],
	[4.5350000000E+04, 3.7821219397E+01, 5.0444008670E+00, 1.8595096702E+01, 3.5912135982E+00, 9.7352965020E-01],
	[4.5355000000E+04, 3.7828586414E+01, 5.0444425164E+00, 1.8601772033E+01, 3.5915500336E+00, 9.7353966887E-01],
	[4.5360000000E+04, 3.7835954053E+01, 5.0444841615E+00, 1.8608449024E+01, 3.5918863925E+00, 9.7354968322E-01],
	[4.5365000000E+04, 3.7843322315E+01, 5.0445258024E+00, 1.8615127674E+01, 3.5922226749E+00, 9.7355969323E-01],
	[4.5370000000E+04, 3.7850691200E+01, 5.0445674390E+00, 1.8621807983E+01, 3.5925588808E+00, 9.7356969892E-01],
	[4.5375000000E+04, 3.7858060707E+01, 5.0446090714E+00, 1.8628489952E+01, 3.5928950102E+00, 9.7357970029E-01],
	[4.5380000000E+04, 3.7865430837E+01, 5.0446506995E+00, 1.8635173582E+01, 3.5932310631E+00, 9.7358969733E-01],
	[4.5385000000E+04, 3.7872801590E+01, 5.0446923234E+00, 1.8641858871E+01, 3.5935670396E+00, 9.7359969005E-01],
	[4.5390000000E+04, 3.7880172965E+01, 5.0447339430E+00, 1.8648545821E+01, 3.5939029396E+00, 9.7360967845E-01],
	[4.5395000000E+04, 3.7887544962E+01, 5.0447755584E+00, 1.8655234432E+01, 3.5942387632E+00, 9.7361966254E-01],
	[4.5400000000E+04, 3.7894917582E+01, 5.0448171696E+00, 1.8661924704E+01, 3.5945745104E+00, 9.7362964232E-01],
	[4.5405000000E+04, 3.7902290825E+01, 5.0448587765E+00, 1.8668616637E+01, 3.5949101813E+00, 9.7363961778E-01],
	[4.5410000000E+04, 3.7909664690E+01, 5.0449003792E+00, 1.8675310232E+01, 3.5952457757E+00, 9.7364958893E-01],
	[4.5415000000E+04, 3.7917039178E+01, 5.0449419777E+00, 1.8682005488E+01, 3.5955812938E+00, 9.7365955577E-01],
	[4.5420000000E+04, 3.7924414288E+01, 5.0449835719E+00, 1.8688702406E+01, 3.5959167355E+00, 9.7366951831E-01],
	[4.5425000000E+04, 3.7931790020E+01, 5.0450251619E+00, 1.8695400986E+01, 3.5962521010E+00, 9.7367947655E-01],
	[4.5430000000E+04, 3.7939166375E+01, 5.0450667476E+00, 1.8702101229E+01, 3.5965873901E+00, 9.7368943048E-01],
	[4.5435000000E+04, 3.7946543352E+01, 5.0451083291E+00, 1.8708803134E+01, 3.5969226029E+00, 9.7369938011E-01],
	[4.5440000000E+04, 3.7953920952E+01, 5.0451499064E+00, 1.8715506702E+01, 3.5972577395E+00, 9.7370932545E-01],
	[4.5445000000E+04, 3.7961299174E+01, 5.0451914795E+00, 1.8722211932E+01, 3.5975927997E+00, 9.7371926649E-01],
	[4.5450000000E+04, 3.7968678018E+01, 5.0452330483E+00, 1.8728918827E+01, 3.5979277838E+00, 9.7372920324E-01],
	[4.5455000000E+04, 3.7976057485E+01, 5.0452746129E+00, 1.8735627384E+01, 3.5982626916E+00, 9.7373913569E-01],
	[4.5460000000E+04, 3.7983437574E+01, 5.0453161732E+00, 1.8742337606E+01, 3.5985975232E+00, 9.7374906386E-01],
	[4.5465000000E+04, 3.7990818285E+01, 5.0453577294E+00, 1.8749049491E+01, 3.5989322786E+00, 9.7375898774E-01],
	[4.5470000000E+04, 3.7998199619E+01, 5.0453992813E+00, 1.8755763040E+01, 3.5992669578E+00, 9.7376890733E-01],
	[4.5475000000E+04, 3.8005581575E+01, 5.0454408289E+00, 1.8762478254E+01, 3.5996015609E+00, 9.7377882264E-01],
	[4.5480000000E+04, 3.8012964153E+01, 5.0454823724E+00, 1.8769195133E+01, 3.5999360878E+00, 9.7378873367E-01],
	[4.5485000000E+04, 3.8020347353E+01, 5.0455239116E+00, 1.8775913676E+01, 3.6002705385E+00, 9.7379864042E-01],
	[4.5490000000E+04, 3.8027731176E+01, 5.0455654466E+00, 1.8782633885E+01, 3.6006049132E+00, 9.7380854289E-01],
	[4.5495000000E+04, 3.8035115621E+01, 5.0456069774E+00, 1.8789355759E+01, 3.6009392117E+00, 9.7381844109E-01],
	[4.5500000000E+04, 3.8042500688E+01, 5.0456485039E+00, 1.8796079298E+01, 3.6012734342E+00, 9.7382833501E-01],
	[4.5505000000E+04, 3.8049886377E+01, 5.0456900262E+00, 1.8802804503E+01, 3.6016075806E+00, 9.7383822467E-01],
	[4.5510000000E+04, 3.8057272688E+01, 5.0457315444E+00, 1.8809531374E+01, 3.6019416509E+00, 9.7384811005E-01],
	[4.5515000000E+04, 3.8064659622E+01, 5.0457730583E+00, 1.8816259912E+01, 3.6022756452E+00, 9.7385799117E-01],
	[4.5520000000E+04, 3.8072047177E+01, 5.0458145679E+00, 1.8822990116E+01, 3.6026095635E+00, 9.7386786802E-01],
	[4.5525000000E+04, 3.8079435355E+01, 5.0458560734E+00, 1.8829721986E+01, 3.6029434058E+00, 9.7387774061E-01],
	[4.5530000000E+04, 3.8086824155E+01, 5.0458975746E+00, 1.8836455524E+01, 3.6032771721E+00, 9.7388760894E-01],
	[4.5535000000E+04, 3.8094213577E+01, 5.0459390716E+00, 1.8843190728E+01, 3.6036108624E+00, 9.7389747301E-01],
	[4.5540000000E+04, 3.8101603621E+01, 5.0459805644E+00, 1.8849927601E+01, 3.6039444767E+00, 9.7390733282E-01],
	[4.5545000000E+04, 3.8108994287E+01, 5.0460220530E+00, 1.8856666140E+01, 3.6042780151E+00, 9.7391718838E-01],
	[4.5550000000E+04, 3.8116385575E+01, 5.0460635374E+00, 1.8863406348E+01, 3.6046114776E+00, 9.7392703968E-01],
	[4.5555000000E+04, 3.8123777485E+01, 5.0461050176E+00, 1.8870148223E+01, 3.6049448642E+00, 9.7393688674E-01],
	[4.5560000000E+04, 3.8131170017E+01, 5.0461464935E+00, 1.8876891767E+01, 3.6052781749E+00, 9.7394672955E-01],
	[4.5565000000E+04, 3.8138563171E+01, 5.0461879653E+00, 1.8883636980E+01, 3.6056114097E+00, 9.7395656811E-01],
	[4.5570000000E+04, 3.8145956947E+01, 5.0462294328E+00, 1.8890383861E+01, 3.6059445686E+00, 9.7396640242E-01],
	[4.5575000000E+04, 3.8153351346E+01, 5.0462708961E+00, 1.8897132411E+01, 3.6062776517E+00, 9.7397623249E-01],
	[4.5580000000E+04, 3.8160746366E+01, 5.0463123553E+00, 1.8903882630E+01, 3.6066106590E+00, 9.7398605833E-01],
	[4.5585000000E+04, 3.8168142007E+01, 5.0463538102E+00, 1.8910634519E+01, 3.6069435905E+00, 9.7399587992E-01],
	[4.5590000000E+04, 3.8175538271E+01, 5.0463952609E+00, 1.8917388078E+01, 3.6072764461E+00, 9.7400569728E-01],
	[4.5595000000E+04, 3.8182935157E+01, 5.0464367074E+00, 1.8924143306E+01, 3.6076092260E+00, 9.7401551040E-01],
	[4.5600000000E+04, 3.8190332665E+01, 5.0464781497E+00, 1.8930900205E+01, 3.6079419301E+00, 9.7402531929E-01],
	[4.5605000000E+04, 3.8197730794E+01, 5.0465195878E+00, 1.8937658774E+01, 3.6082745585E+00, 9.7403512395E-01],
	[4.5610000000E+04, 3.8205129545E+01, 5.0465610216E+00, 1.8944419013E+01, 3.6086071111E+00, 9.7404492438E-01],
	[4.5615000000E+04, 3.8212528918E+01, 5.0466024513E+00, 1.8951180924E+01, 3.6089395880E+00, 9.7405472059E-01],
	[4.5620000000E+04, 3.8219928913E+01, 5.0466438768E+00, 1.8957944505E+01, 3.6092719892E+00, 9.7406451257E-01],
	[4.5625000000E+04, 3.8227329530E+01, 5.0466852981E+00, 1.8964709758E+01, 3.6096043148E+00, 9.7407430033E-01],
	[4.5630000000E+04, 3.8234730769E+01, 5.0467267152E+00, 1.8971476682E+01, 3.6099365646E+00, 9.7408408387E-01],
	[4.5635000000E+04, 3.8242132629E+01, 5.0467681281E+00, 1.8978245278E+01, 3.6102687388E+00, 9.7409386319E-01],
	[4.5640000000E+04, 3.8249535111E+01, 5.0468095368E+00, 1.8985015546E+01, 3.6106008374E+00, 9.7410363829E-01],
	[4.5645000000E+04, 3.8256938215E+01, 5.0468509413E+00, 1.8991787486E+01, 3.6109328603E+00, 9.7411340918E-01],
	[4.5650000000E+04, 3.8264341940E+01, 5.0468923415E+00, 1.8998561099E+01, 3.6112648077E+00, 9.7412317586E-01],
	[4.5655000000E+04, 3.8271746287E+01, 5.0469337377E+00, 1.9005336384E+01, 3.6115966794E+00, 9.7413293833E-01],
	[4.5660000000E+04, 3.8279151256E+01, 5.0469751296E+00, 1.9012113342E+01, 3.6119284756E+00, 9.7414269659E-01],
	[4.5665000000E+04, 3.8286556847E+01, 5.0470165173E+00, 1.9018891974E+01, 3.6122601962E+00, 9.7415245064E-01],
	[4.5670000000E+04, 3.8293963059E+01, 5.0470579008E+00, 1.9025672278E+01, 3.6125918413E+00, 9.7416220049E-01],
	[4.5675000000E+04, 3.8301369893E+01, 5.0470992801E+00, 1.9032454257E+01, 3.6129234108E+00, 9.7417194614E-01],
	[4.5680000000E+04, 3.8308777348E+01, 5.0471406553E+00, 1.9039237909E+01, 3.6132549049E+00, 9.7418168758E-01],
	[4.5685000000E+04, 3.8316185425E+01, 5.0471820262E+00, 1.9046023235E+01, 3.6135863234E+00, 9.7419142483E-01],
	[4.5690000000E+04, 3.8323594124E+01, 5.0472233930E+00, 1.9052810235E+01, 3.6139176665E+00, 9.7420115789E-01],
	[4.5695000000E+04, 3.8331003444E+01, 5.0472647556E+00, 1.9059598910E+01, 3.6142489341E+00, 9.7421088675E-01],
	[4.5700000000E+04, 3.8338413386E+01, 5.0473061140E+00, 1.9066389259E+01, 3.6145801263E+00, 9.7422061141E-01],
	[4.5705000000E+04, 3.8345823949E+01, 5.0473474682E+00, 1.9073181284E+01, 3.6149112430E+00, 9.7423033189E-01],
	[4.5710000000E+04, 3.8353235134E+01, 5.0473888182E+00, 1.9079974984E+01, 3.6152422844E+00, 9.7424004818E-01],
	[4.5715000000E+04, 3.8360646941E+01, 5.0474301640E+00, 1.9086770359E+01, 3.6155732503E+00, 9.7424976028E-01],
	[4.5720000000E+04, 3.8368059369E+01, 5.0474715057E+00, 1.9093567410E+01, 3.6159041408E+00, 9.7425946820E-01],
	[4.5725000000E+04, 3.8375472418E+01, 5.0475128431E+00, 1.9100366136E+01, 3.6162349560E+00, 9.7426917194E-01],
	[4.5730000000E+04, 3.8382886089E+01, 5.0475541764E+00, 1.9107166539E+01, 3.6165656959E+00, 9.7427887150E-01],
	[4.5735000000E+04, 3.8390300381E+01, 5.0475955055E+00, 1.9113968618E+01, 3.6168963604E+00, 9.7428856688E-01],
	[4.5740000000E+04, 3.8397715295E+01, 5.0476368305E+00, 1.9120772374E+01, 3.6172269495E+00, 9.7429825808E-01],
	[4.5745000000E+04, 3.8405130830E+01, 5.0476781512E+00, 1.9127577806E+01, 3.6175574634E+00, 9.7430794511E-01],
	[4.5750000000E+04, 3.8412546986E+01, 5.0477194678E+00, 1.9134384916E+01, 3.6178879020E+00, 9.7431762797E-01],
	[4.5755000000E+04, 3.8419963764E+01, 5.0477607802E+00, 1.9141193702E+01, 3.6182182654E+00, 9.7432730666E-01],
	[4.5760000000E+04, 3.8427381163E+01, 5.0478020884E+00, 1.9148004167E+01, 3.6185485534E+00, 9.7433698118E-01],
	[4.5765000000E+04, 3.8434799184E+01, 5.0478433924E+00, 1.9154816309E+01, 3.6188787663E+00, 9.7434665154E-01],
	[4.5770000000E+04, 3.8442217826E+01, 5.0478846923E+00, 1.9161630128E+01, 3.6192089039E+00, 9.7435631773E-01],
	[4.5775000000E+04, 3.8449637089E+01, 5.0479259880E+00, 1.9168445626E+01, 3.6195389663E+00, 9.7436597976E-01],
	[4.5780000000E+04, 3.8457056974E+01, 5.0479672795E+00, 1.9175262803E+01, 3.6198689535E+00, 9.7437563763E-01],
	[4.5785000000E+04, 3.8464477480E+01, 5.0480085669E+00, 1.9182081658E+01, 3.6201988656E+00, 9.7438529134E-01],
	[4.5790000000E+04, 3.8471898607E+01, 5.0480498501E+00, 1.9188902192E+01, 3.6205287025E+00, 9.7439494090E-01],
	[4.5795000000E+04, 3.8479320355E+01, 5.0480911291E+00, 1.9195724405E+01, 3.6208584643E+00, 9.7440458630E-01],
	[4.5800000000E+04, 3.8486742725E+01, 5.0481324039E+00, 1.9202548297E+01, 3.6211881509E+00, 9.7441422755E-01],
	[4.5805000000E+04, 3.8494165716E+01, 5.0481736746E+00, 1.9209373869E+01, 3.6215177624E+00, 9.7442386465E-01],
	[4.5810000000E+04, 3.8501589328E+01, 5.0482149411E+00, 1.9216201121E+01, 3.6218472989E+00, 9.7443349760E-01],
	[4.5815000000E+04, 3.8509013561E+01, 5.0482562034E+00, 1.9223030052E+01, 3.6221767602E+00, 9.7444312641E-01],
	[4.5820000000E+04, 3.8516438416E+01, 5.0482974616E+00, 1.9229860664E+01, 3.6225061465E+00, 9.7445275107E-01],
	[4.5825000000E+04, 3.8523863891E+01, 5.0483387156E+00, 1.9236692957E+01, 3.6228354578E+00, 9.7446237159E-01],
	[4.5830000000E+04, 3.8531289988E+01, 5.0483799654E+00, 1.9243526930E+01, 3.6231646940E+00, 9.7447198797E-01],
	[4.5835000000E+04, 3.8538716706E+01, 5.0484212111E+00, 1.9250362584E+01, 3.6234938552E+00, 9.7448160022E-01],
	[4.5840000000E+04, 3.8546144045E+01, 5.0484624526E+00, 1.9257199919E+01, 3.6238229414E+00, 9.7449120833E-01],
	[4.5845000000E+04, 3.8553572005E+01, 5.0485036900E+00, 1.9264038935E+01, 3.6241519527E+00, 9.7450081230E-01],
	[4.5850000000E+04, 3.8561000586E+01, 5.0485449232E+00, 1.9270879634E+01, 3.6244808889E+00, 9.7451041214E-01],
	[4.5855000000E+04, 3.8568429788E+01, 5.0485861522E+00, 1.9277722014E+01, 3.6248097503E+00, 9.7452000785E-01],
	[4.5860000000E+04, 3.8575859612E+01, 5.0486273771E+00, 1.9284566076E+01, 3.6251385367E+00, 9.7452959944E-01],
	[4.5865000000E+04, 3.8583290056E+01, 5.0486685978E+00, 1.9291411820E+01, 3.6254672482E+00, 9.7453918690E-01],
	[4.5870000000E+04, 3.8590721122E+01, 5.0487098144E+00, 1.9298259247E+01, 3.6257958847E+00, 9.7454877023E-01],
	[4.5875000000E+04, 3.8598152808E+01, 5.0487510268E+00, 1.9305108357E+01, 3.6261244464E+00, 9.7455834945E-01],
	[4.5880000000E+04, 3.8605585115E+01, 5.0487922350E+00, 1.9311959149E+01, 3.6264529333E+00, 9.7456792454E-01],
	[4.5885000000E+04, 3.8613018044E+01, 5.0488334391E+00, 1.9318811625E+01, 3.6267813453E+00, 9.7457749551E-01],
	[4.5890000000E+04, 3.8620451593E+01, 5.0488746391E+00, 1.9325665785E+01, 3.6271096824E+00, 9.7458706237E-01],
	[4.5895000000E+04, 3.8627885763E+01, 5.0489158349E+00, 1.9332521628E+01, 3.6274379447E+00, 9.7459662512E-01],
	[4.5900000000E+04, 3.8635320554E+01, 5.0489570265E+00, 1.9339379155E+01, 3.6277661322E+00, 9.7460618375E-01],
	[4.5905000000E+04, 3.8642755966E+01, 5.0489982140E+00, 1.9346238366E+01, 3.6280942450E+00, 9.7461573828E-01],
	[4.5910000000E+04, 3.8650191999E+01, 5.0490393973E+00, 1.9353099261E+01, 3.6284222830E+00, 9.7462528869E-01],
	[4.5915000000E+04, 3.8657628653E+01, 5.0490805765E+00, 1.9359961841E+01, 3.6287502462E+00, 9.7463483500E-01],
	[4.5920000000E+04, 3.8665065928E+01, 5.0491217516E+00, 1.9366826106E+01, 3.6290781346E+00, 9.7464437721E-01],
	[4.5925000000E+04, 3.8672503824E+01, 5.0491629225E+00, 1.9373692056E+01, 3.6294059484E+00, 9.7465391531E-01],
	[4.5930000000E+04, 3.8679942340E+01, 5.0492040892E+00, 1.9380559691E+01, 3.6297336874E+00, 9.7466344932E-01],
	[4.5935000000E+04, 3.8687381477E+01, 5.0492452518E+00, 1.9387429012E+01, 3.6300613518E+00, 9.7467297922E-01],
	[4.5940000000E+04, 3.8694821235E+01, 5.0492864103E+00, 1.9394300019E+01, 3.6303889415E+00, 9.7468250503E-01],
	[4.5945000000E+04, 3.8702261614E+01, 5.0493275646E+00, 1.9401172711E+01, 3.6307164565E+00, 9.7469202675E-01],
	[4.5950000000E+04, 3.8709702613E+01, 5.0493687148E+00, 1.9408047090E+01, 3.6310438969E+00, 9.7470154437E-01],
	[4.5955000000E+04, 3.8717144234E+01, 5.0494098608E+00, 1.9414923155E+01, 3.6313712626E+00, 9.7471105791E-01],
	[4.5960000000E+04, 3.8724586475E+01, 5.0494510027E+00, 1.9421800907E+01, 3.6316985537E+00, 9.7472056735E-01],
	[4.5965000000E+04, 3.8732029337E+01, 5.0494921404E+00, 1.9428680346E+01, 3.6320257703E+00, 9.7473007271E-01],
	[4.5970000000E+04, 3.8739472819E+01, 5.0495332740E+00, 1.9435561471E+01, 3.6323529123E+00, 9.7473957399E-01],
	[4.5975000000E+04, 3.8746916922E+01, 5.0495744035E+00, 1.9442444285E+01, 3.6326799797E+00, 9.7474907118E-01],
	[4.5980000000E+04, 3.8754361646E+01, 5.0496155288E+00, 1.9449328786E+01, 3.6330069725E+00, 9.7475856429E-01],
	[4.5985000000E+04, 3.8761806991E+01, 5.0496566500E+00, 1.9456214974E+01, 3.6333338909E+00, 9.7476805333E-01],
	[4.5990000000E+04, 3.8769252956E+01, 5.0496977671E+00, 1.9463102851E+01, 3.6336607347E+00, 9.7477753829E-01],
	[4.5995000000E+04, 3.8776699542E+01, 5.0497388800E+00, 1.9469992416E+01, 3.6339875040E+00, 9.7478701917E-01],
	[4.6000000000E+04, 3.8784146748E+01, 5.0497799888E+00, 1.9476883669E+01, 3.6343141988E+00, 9.7479649598E-01],
	[4.6005000000E+04, 3.8791594575E+01, 5.0498210934E+00, 1.9483776611E+01, 3.6346408192E+00, 9.7480596873E-01],
	[4.6010000000E+04, 3.8799043022E+01, 5.0498621940E+00, 1.9490671243E+01, 3.6349673651E+00, 9.7481543740E-01],
	[4.6015000000E+04, 3.8806492091E+01, 5.0499032903E+00, 1.9497567563E+01, 3.6352938366E+00, 9.7482490201E-01],
	[4.6020000000E+04, 3.8813941779E+01, 5.0499443826E+00, 1.9504465573E+01, 3.6356202337E+00, 9.7483436255E-01],
	[4.6025000000E+04, 3.8821392088E+01, 5.0499854707E+00, 1.9511365272E+01, 3.6359465563E+00, 9.7484381903E-01],
	[4.6030000000E+04, 3.8828843018E+01, 5.0500265547E+00, 1.9518266662E+01, 3.6362728046E+00, 9.7485327145E-01],
	[4.6035000000E+04, 3.8836306249E+01, 5.0500690003E+00, 1.9525169741E+01, 3.6365997892E+00, 9.7486271981E-01],
	[4.6040000000E+04, 3.8843773465E+01, 5.0501118346E+00, 1.9532074511E+01, 3.6369269328E+00, 9.7487216412E-01],
	[4.6045000000E+04, 3.8851241306E+01, 5.0501546646E+00, 1.9538980971E+01, 3.6372540023E+00, 9.7488160437E-01],
	[4.6050000000E+04, 3.8858709771E+01, 5.0501974904E+00, 1.9545889123E+01, 3.6375809976E+00, 9.7489104056E-01],
	[4.6055000000E+04, 3.8866178861E+01, 5.0502403118E+00, 1.9552798965E+01, 3.6379079188E+00, 9.7490047271E-01],
	[4.6060000000E+04, 3.8873648576E+01, 5.0502831290E+00, 1.9559710498E+01, 3.6382347660E+00, 9.7490990081E-01],
	[4.6065000000E+04, 3.8881118915E+01, 5.0503259418E+00, 1.9566623723E+01, 3.6385615391E+00, 9.7491932486E-01],
	[4.6070000000E+04, 3.8888589879E+01, 5.0503687504E+00, 1.9573538640E+01, 3.6388882381E+00, 9.7492874487E-01],
	[4.6075000000E+04, 3.8896061467E+01, 5.0504115547E+00, 1.9580455249E+01, 3.6392148630E+00, 9.7493816084E-01],
	[4.6080000000E+04, 3.8903533679E+01, 5.0504543548E+00, 1.9587373550E+01, 3.6395414140E+00, 9.7494757276E-01],
	[4.6085000000E+04, 3.8911006517E+01, 5.0504971505E+00, 1.9594293543E+01, 3.6398678909E+00, 9.7495698064E-01],
	[4.6090000000E+04, 3.8918479978E+01, 5.0505399420E+00, 1.9601215229E+01, 3.6401942938E+00, 9.7496638449E-01],
	[4.6095000000E+04, 3.8925954064E+01, 5.0505827292E+00, 1.9608138608E+01, 3.6405206228E+00, 9.7497578431E-01],
	[4.6100000000E+04, 3.8933428775E+01, 5.0506255121E+00, 1.9615063680E+01, 3.6408468777E+00, 9.7498518009E-01],
	[4.6105000000E+04, 3.8940904110E+01, 5.0506682907E+00, 1.9621990445E+01, 3.6411730588E+00, 9.7499457184E-01],
	[4.6110000000E+04, 3.8948380069E+01, 5.0507110650E+00, 1.9628918904E+01, 3.6414991659E+00, 9.7500395956E-01],
	[4.6115000000E+04, 3.8955856653E+01, 5.0507538351E+00, 1.9635849057E+01, 3.6418251990E+00, 9.7501334325E-01],
	[4.6120000000E+04, 3.8963333861E+01, 5.0507966009E+00, 1.9642780903E+01, 3.6421511583E+00, 9.7502272292E-01],
	[4.6125000000E+04, 3.8970811694E+01, 5.0508393625E+00, 1.9649714444E+01, 3.6424770437E+00, 9.7503209856E-01],
	[4.6130000000E+04, 3.8978290150E+01, 5.0508821197E+00, 1.9656649680E+01, 3.6428028552E+00, 9.7504147019E-01],
	[4.6135000000E+04, 3.8985769232E+01, 5.0509248727E+00, 1.9663586610E+01, 3.6431285929E+00, 9.7505083779E-01],
	[4.6140000000E+04, 3.8993248937E+01, 5.0509676214E+00, 1.9670525235E+01, 3.6434542567E+00, 9.7506020138E-01],
	[4.6145000000E+04, 3.9000729267E+01, 5.0510103658E+00, 1.9677465555E+01, 3.6437798467E+00, 9.7506956095E-01],
	[4.6150000000E+04, 3.9008210221E+01, 5.0510531060E+00, 1.9684407571E+01, 3.6441053629E+00, 9.7507891651E-01],
	[4.6155000000E+04, 3.9015691799E+01, 5.0510958419E+00, 1.9691351282E+01, 3.6444308053E+00, 9.7508826806E-01],
	[4.6160000000E+04, 3.9023174002E+01, 5.0511385735E+00, 1.9698296689E+01, 3.6447561739E+00, 9.7509761560E-01],
	[4.6165000000E+04, 3.9030656829E+01, 5.0511813009E+00, 1.9705243793E+01, 3.6450814688E+00, 9.7510695913E-01],
	[4.6170000000E+04, 3.9038140280E+01, 5.0512240240E+00, 1.9712192592E+01, 3.6454066900E+00, 9.7511629865E-01],
	[4.6175000000E+04, 3.9045624355E+01, 5.0512667428E+00, 1.9719143088E+01, 3.6457318374E+00, 9.7512563418E-01],
	[4.6180000000E+04, 3.9053109055E+01, 5.0513094574E+00, 1.9726095281E+01, 3.6460569111E+00, 9.7513496570E-01],
	[4.6185000000E+04, 3.9060594378E+01, 5.0513521677E+00, 1.9733049171E+01, 3.6463819111E+00, 9.7514429322E-01],
	[4.6190000000E+04, 3.9068080326E+01, 5.0513948738E+00, 1.9740004759E+01, 3.6467068374E+00, 9.7515361674E-01],
	[4.6195000000E+04, 3.9075566898E+01, 5.0514375756E+00, 1.9746962043E+01, 3.6470316901E+00, 9.7516293627E-01],
	[4.6200000000E+04, 3.9083054094E+01, 5.0514802731E+00, 1.9753921026E+01, 3.6473564691E+00, 9.7517225180E-01],
	[4.6205000000E+04, 3.9090541915E+01, 5.0515229663E+00, 1.9760881706E+01, 3.6476811745E+00, 9.7518156334E-01],
	[4.6210000000E+04, 3.9098030359E+01, 5.0515656553E+00, 1.9767844085E+01, 3.6480058062E+00, 9.7519087089E-01],
	[4.6215000000E+04, 3.9105519427E+01, 5.0516083401E+00, 1.9774808161E+01, 3.6483303644E+00, 9.7520017446E-01],
	[4.6220000000E+04, 3.9113009120E+01, 5.0516510206E+00, 1.9781773937E+01, 3.6486548490E+00, 9.7520947403E-01],
	[4.6225000000E+04, 3.9120499436E+01, 5.0516936968E+00, 1.9788741411E+01, 3.6489792600E+00, 9.7521876963E-01],
	[4.6230000000E+04, 3.9127990377E+01, 5.0517363688E+00, 1.9795710585E+01, 3.6493035975E+00, 9.7522806124E-01],
	[4.6235000000E+04, 3.9135481941E+01, 5.0517790365E+00, 1.9802681458E+01, 3.6496278615E+00, 9.7523734887E-01],
	[4.6240000000E+04, 3.9142974130E+01, 5.0518217000E+00, 1.9809654030E+01, 3.6499520519E+00, 9.7524663252E-01],
	[4.6245000000E+04, 3.9150466943E+01, 5.0518643592E+00, 1.9816628302E+01, 3.6502761688E+00, 9.7525591220E-01],
	[4.6250000000E+04, 3.9157960379E+01, 5.0519070142E+00, 1.9823604274E+01, 3.6506002123E+00, 9.7526518790E-01],
	[4.6255000000E+04, 3.9165454440E+01, 5.0519496649E+00, 1.9830581947E+01, 3.6509241822E+00, 9.7527445963E-01],
	[4.6260000000E+04, 3.9172949124E+01, 5.0519923113E+00, 1.9837561320E+01, 3.6512480787E+00, 9.7528372739E-01],
	[4.6265000000E+04, 3.9180444433E+01, 5.0520349535E+00, 1.9844542393E+01, 3.6515719018E+00, 9.7529299118E-01],
	[4.6270000000E+04, 3.9187940365E+01, 5.0520775915E+00, 1.9851525168E+01, 3.6518956515E+00, 9.7530225100E-01],
	[4.6275000000E+04, 3.9195436921E+01, 5.0521202252E+00, 1.9858509644E+01, 3.6522193277E+00, 9.7531150686E-01],
	[4.6280000000E+04, 3.9202934101E+01, 5.0521628547E+00, 1.9865495821E+01, 3.6525429306E+00, 9.7532075876E-01],
	[4.6285000000E+04, 3.9210431905E+01, 5.0522054799E+00, 1.9872483699E+01, 3.6528664600E+00, 9.7533000669E-01],
	[4.6290000000E+04, 3.9217930333E+01, 5.0522481009E+00, 1.9879473280E+01, 3.6531899162E+00, 9.7533925067E-01],
	[4.6295000000E+04, 3.9225429385E+01, 5.0522907176E+00, 1.9886464562E+01, 3.6535132989E+00, 9.7534849069E-01],
	[4.6300000000E+04, 3.9232929060E+01, 5.0523333301E+00, 1.9893457547E+01, 3.6538366084E+00, 9.7535772675E-01],
	[4.6305000000E+04, 3.9240429359E+01, 5.0523759384E+00, 1.9900452235E+01, 3.6541598445E+00, 9.7536695886E-01],
	[4.6310000000E+04, 3.9247930283E+01, 5.0524185424E+00, 1.9907448625E+01, 3.6544830074E+00, 9.7537618702E-01],
	[4.6315000000E+04, 3.9255431829E+01, 5.0524611422E+00, 1.9914446718E+01, 3.6548060970E+00, 9.7538541123E-01],
	[4.6320000000E+04, 3.9262934000E+01, 5.0525037377E+00, 1.9921446515E+01, 3.6551291133E+00, 9.7539463150E-01],
	[4.6325000000E+04, 3.9270436794E+01, 5.0525463290E+00, 1.9928448015E+01, 3.6554520563E+00, 9.7540384781E-01],
	[4.6330000000E+04, 3.9277940212E+01, 5.0525889160E+00, 1.9935451218E+01, 3.6557749262E+00, 9.7541306019E-01],
	[4.6335000000E+04, 3.9285444254E+01, 5.0526314989E+00, 1.9942456126E+01, 3.6560977228E+00, 9.7542226862E-01],
	[4.6340000000E+04, 3.9292948920E+01, 5.0526740774E+00, 1.9949462738E+01, 3.6564204462E+00, 9.7543147312E-01],
	[4.6345000000E+04, 3.9300454209E+01, 5.0527166518E+00, 1.9956471054E+01, 3.6567430964E+00, 9.7544067367E-01],
	[4.6350000000E+04, 3.9307960122E+01, 5.0527592219E+00, 1.9963481075E+01, 3.6570656735E+00, 9.7544987029E-01],
	[4.6355000000E+04, 3.9315466658E+01, 5.0528017878E+00, 1.9970492800E+01, 3.6573881774E+00, 9.7545906298E-01],
	[4.6360000000E+04, 3.9322973818E+01, 5.0528443494E+00, 1.9977506231E+01, 3.6577106082E+00, 9.7546825173E-01],
	[4.6365000000E+04, 3.9330481602E+01, 5.0528869068E+00, 1.9984521367E+01, 3.6580329659E+00, 9.7547743656E-01],
	[4.6370000000E+04, 3.9337990010E+01, 5.0529294600E+00, 1.9991538208E+01, 3.6583552504E+00, 9.7548661745E-01],
	[4.6375000000E+04, 3.9345499040E+01, 5.0529720090E+00, 1.9998556756E+01, 3.6586774619E+00, 9.7549579442E-01],
	[4.6380000000E+04, 3.9353008695E+01, 5.0530145537E+00, 2.0005577009E+01, 3.6589996003E+00, 9.7550496747E-01],
	[4.6385000000E+04, 3.9360518973E+01, 5.0530570942E+00, 2.0012598968E+01, 3.6593216657E+00, 9.7551413659E-01],
	[4.6390000000E+04, 3.9368029875E+01, 5.0530996305E+00, 2.0019622634E+01, 3.6596436580E+00, 9.7552330180E-01],
	[4.6395000000E+04, 3.9375541400E+01, 5.0531421625E+00, 2.0026648007E+01, 3.6599655773E+00, 9.7553246308E-01],
	[4.6400000000E+04, 3.9383053549E+01, 5.0531846903E+00, 2.0033675087E+01, 3.6602874236E+00, 9.7554162045E-01],
	[4.6405000000E+04, 3.9390566321E+01, 5.0532272139E+00, 2.0040703873E+01, 3.6606091969E+00, 9.7555077391E-01],
	[4.6410000000E+04, 3.9398079716E+01, 5.0532697333E+00, 2.0047734367E+01, 3.6609308972E+00, 9.7555992345E-01],
	[4.6415000000E+04, 3.9405593735E+01, 5.0533122484E+00, 2.0054766569E+01, 3.6612525245E+00, 9.7556906908E-01],
	[4.6420000000E+04, 3.9413108378E+01, 5.0533547594E+00, 2.0061800479E+01, 3.6615740789E+00, 9.7557821080E-01],
	[4.6425000000E+04, 3.9420623644E+01, 5.0533972661E+00, 2.0068836096E+01, 3.6618955604E+00, 9.7558734861E-01],
	[4.6430000000E+04, 3.9428139533E+01, 5.0534397685E+00, 2.0075873422E+01, 3.6622169690E+00, 9.7559648252E-01],
	[4.6435000000E+04, 3.9435656046E+01, 5.0534822668E+00, 2.0082912457E+01, 3.6625383047E+00, 9.7560561253E-01],
	[4.6440000000E+04, 3.9443173182E+01, 5.0535247608E+00, 2.0089953200E+01, 3.6628595675E+00, 9.7561473864E-01],
	[4.6445000000E+04, 3.9450690942E+01, 5.0535672507E+00, 2.0096995652E+01, 3.6631807575E+00, 9.7562386084E-01],
	[4.6450000000E+04, 3.9458209325E+01, 5.0536097363E+00, 2.0104039813E+01, 3.6635018746E+00, 9.7563297915E-01],
	[4.6455000000E+04, 3.9465728331E+01, 5.0536522177E+00, 2.0111085684E+01, 3.6638229188E+00, 9.7564209356E-01],
	[4.6460000000E+04, 3.9473247961E+01, 5.0536946949E+00, 2.0118133265E+01, 3.6641438903E+00, 9.7565120408E-01],
	[4.6465000000E+04, 3.9480768214E+01, 5.0537371678E+00, 2.0125182555E+01, 3.6644647889E+00, 9.7566031071E-01],
	[4.6470000000E+04, 3.9488289090E+01, 5.0537796366E+00, 2.0132233556E+01, 3.6647856148E+00, 9.7566941345E-01],
	[4.6475000000E+04, 3.9495810589E+01, 5.0538221011E+00, 2.0139286267E+01, 3.6651063679E+00, 9.7567851230E-01],
	[4.6480000000E+04, 3.9503332712E+01, 5.0538645614E+00, 2.0146340689E+01, 3.6654270483E+00, 9.7568760727E-01],
	[4.6485000000E+04, 3.9510855458E+01, 5.0539070176E+00, 2.0153396821E+01, 3.6657476559E+00, 9.7569669835E-01],
	[4.6490000000E+04, 3.9518378827E+01, 5.0539494695E+00, 2.0160454664E+01, 3.6660681908E+00, 9.7570578554E-01],
	[4.6495000000E+04, 3.9525902820E+01, 5.0539919172E+00, 2.0167514219E+01, 3.6663886530E+00, 9.7571486886E-01],
	[4.6500000000E+04, 3.9533427436E+01, 5.0540343607E+00, 2.0174575486E+01, 3.6667090425E+00, 9.7572394830E-01],
	[4.6505000000E+04, 3.9540952674E+01, 5.0540767999E+00, 2.0181638464E+01, 3.6670293593E+00, 9.7573302387E-01],
	[4.6510000000E+04, 3.9548478536E+01, 5.0541192350E+00, 2.0188703154E+01, 3.6673496035E+00, 9.7574209556E-01],
	[4.6515000000E+04, 3.9556005022E+01, 5.0541616659E+00, 2.0195769556E+01, 3.6676697751E+00, 9.7575116337E-01],
	[4.6520000000E+04, 3.9563532130E+01, 5.0542040926E+00, 2.0202837671E+01, 3.6679898740E+00, 9.7576022732E-01],
	[4.6525000000E+04, 3.9571059861E+01, 5.0542465150E+00, 2.0209907498E+01, 3.6683099003E+00, 9.7576928739E-01],
	[4.6530000000E+04, 3.9578588216E+01, 5.0542889333E+00, 2.0216979039E+01, 3.6686298540E+00, 9.7577834360E-01],
	[4.6535000000E+04, 3.9586117194E+01, 5.0543313473E+00, 2.0224052292E+01, 3.6689497352E+00, 9.7578739595E-01],
	[4.6540000000E+04, 3.9593646794E+01, 5.0543737572E+00, 2.0231127259E+01, 3.6692695438E+00, 9.7579644443E-01],
	[4.6545000000E+04, 3.9601177018E+01, 5.0544161628E+00, 2.0238203939E+01, 3.6695892798E+00, 9.7580548905E-01],
	[4.6550000000E+04, 3.9608707865E+01, 5.0544585643E+00, 2.0245282334E+01, 3.6699089433E+00, 9.7581452981E-01],
	[4.6555000000E+04, 3.9616239335E+01, 5.0545009616E+00, 2.0252362442E+01, 3.6702285343E+00, 9.7582356672E-01],
	[4.6560000000E+04, 3.9623771428E+01, 5.0545433546E+00, 2.0259444265E+01, 3.6705480529E+00, 9.7583259977E-01],
	[4.6565000000E+04, 3.9631304144E+01, 5.0545857435E+00, 2.0266527802E+01, 3.6708674989E+00, 9.7584162896E-01],
	[4.6570000000E+04, 3.9638837483E+01, 5.0546281282E+00, 2.0273613054E+01, 3.6711868725E+00, 9.7585065431E-01],
	[4.6575000000E+04, 3.9646371445E+01, 5.0546705086E+00, 2.0280700021E+01, 3.6715061736E+00, 9.7585967580E-01],
	[4.6580000000E+04, 3.9653906029E+01, 5.0547128849E+00, 2.0287788703E+01, 3.6718254023E+00, 9.7586869345E-01],
	[4.6585000000E+04, 3.9661441237E+01, 5.0547552570E+00, 2.0294879100E+01, 3.6721445586E+00, 9.7587770725E-01],
	[4.6590000000E+04, 3.9668977068E+01, 5.0547976249E+00, 2.0301971214E+01, 3.6724636425E+00, 9.7588671720E-01],
	[4.6595000000E+04, 3.9676513521E+01, 5.0548399886E+00, 2.0309065043E+01, 3.6727826540E+00, 9.7589572331E-01],
	[4.6600000000E+04, 3.9684050598E+01, 5.0548823481E+00, 2.0316160588E+01, 3.6731015931E+00, 9.7590472559E-01],
	[4.6605000000E+04, 3.9691588297E+01, 5.0549247034E+00, 2.0323257850E+01, 3.6734204599E+00, 9.7591372402E-01],
	[4.6610000000E+04, 3.9699126620E+01, 5.0549670546E+00, 2.0330356828E+01, 3.6737392543E+00, 9.7592271862E-01],
	[4.6615000000E+04, 3.9706665565E+01, 5.0550094015E+00, 2.0337457523E+01, 3.6740579765E+00, 9.7593170938E-01],
	[4.6620000000E+04, 3.9714205133E+01, 5.0550517443E+00, 2.0344559935E+01, 3.6743766263E+00, 9.7594069631E-01],
	[4.6625000000E+04, 3.9721745323E+01, 5.0550940828E+00, 2.0351664065E+01, 3.6746952038E+00, 9.7594967941E-01],
	[4.6630000000E+04, 3.9729286137E+01, 5.0551364172E+00, 2.0358769912E+01, 3.6750137091E+00, 9.7595865868E-01],
	[4.6635000000E+04, 3.9736827573E+01, 5.0551787474E+00, 2.0365877476E+01, 3.6753321421E+00, 9.7596763413E-01],
	[4.6640000000E+04, 3.9744369632E+01, 5.0552210734E+00, 2.0372986759E+01, 3.6756505029E+00, 9.7597660574E-01],
	[4.6645000000E+04, 3.9751912314E+01, 5.0552633953E+00, 2.0380097760E+01, 3.6759687915E+00, 9.7598557354E-01],
	[4.6650000000E+04, 3.9759455619E+01, 5.0553057129E+00, 2.0387210479E+01, 3.6762870078E+00, 9.7599453751E-01],
	[4.6655000000E+04, 3.9766999546E+01, 5.0553480264E+00, 2.0394324917E+01, 3.6766051520E+00, 9.7600349767E-01],
	[4.6660000000E+04, 3.9774544096E+01, 5.0553903357E+00, 2.0401441074E+01, 3.6769232239E+00, 9.7601245401E-01],
	[4.6665000000E+04, 3.9782089269E+01, 5.0554326408E+00, 2.0408558951E+01, 3.6772412238E+00, 9.7602140656E-01],
	[4.6670000000E+04, 3.9789635065E+01, 5.0554749417E+00, 2.0415678546E+01, 3.6775591514E+00, 9.7603035530E-01],
	[4.6675000000E+04, 3.9797181483E+01, 5.0555172385E+00, 2.0422799861E+01, 3.6778770070E+00, 9.7603930024E-01],
	[4.6680000000E+04, 3.9804728523E+01, 5.0555595311E+00, 2.0429922896E+01, 3.6781947904E+00, 9.7604824138E-01],
	[4.6685000000E+04, 3.9812276187E+01, 5.0556018195E+00, 2.0437047651E+01, 3.6785125018E+00, 9.7605717873E-01],
	[4.6690000000E+04, 3.9819824473E+01, 5.0556441037E+00, 2.0444174126E+01, 3.6788301410E+00, 9.7606611228E-01],
	[4.6695000000E+04, 3.9827373381E+01, 5.0556863837E+00, 2.0451302322E+01, 3.6791477082E+00, 9.7607504203E-01],
	[4.6700000000E+04, 3.9834922913E+01, 5.0557286596E+00, 2.0458432238E+01, 3.6794652034E+00, 9.7608396799E-01],
	[4.6705000000E+04, 3.9842473066E+01, 5.0557709313E+00, 2.0465563876E+01, 3.6797826265E+00, 9.7609289016E-01],
	[4.6710000000E+04, 3.9850023843E+01, 5.0558131988E+00, 2.0472697235E+01, 3.6800999776E+00, 9.7610180855E-01],
	[4.6715000000E+04, 3.9857575242E+01, 5.0558554622E+00, 2.0479832315E+01, 3.6804172568E+00, 9.7611072314E-01],
	[4.6720000000E+04, 3.9865127263E+01, 5.0558977214E+00, 2.0486969117E+01, 3.6807344639E+00, 9.7611963395E-01],
	[4.6725000000E+04, 3.9872679907E+01, 5.0559399764E+00, 2.0494107640E+01, 3.6810515990E+00, 9.7612854097E-01],
	[4.6730000000E+04, 3.9880233173E+01, 5.0559822273E+00, 2.0501247886E+01, 3.6813686623E+00, 9.7613744422E-01],
	[4.6735000000E+04, 3.9887787062E+01, 5.0560244740E+00, 2.0508389855E+01, 3.6816856535E+00, 9.7614634368E-01],
	[4.6740000000E+04, 3.9895341574E+01, 5.0560667165E+00, 2.0515533545E+01, 3.6820025729E+00, 9.7615523936E-01],
	[4.6745000000E+04, 3.9902896708E+01, 5.0561089548E+00, 2.0522678959E+01, 3.6823194203E+00, 9.7616413126E-01],
	[4.6750000000E+04, 3.9910452464E+01, 5.0561511890E+00, 2.0529826096E+01, 3.6826361959E+00, 9.7617301939E-01],
	[4.6755000000E+04, 3.9918008842E+01, 5.0561934191E+00, 2.0536974956E+01, 3.6829528996E+00, 9.7618190375E-01],
	[4.6760000000E+04, 3.9925565844E+01, 5.0562356449E+00, 2.0544125539E+01, 3.6832695315E+00, 9.7619078433E-01],
	[4.6765000000E+04, 3.9933123467E+01, 5.0562778666E+00, 2.0551277847E+01, 3.6835860915E+00, 9.7619966114E-01],
	[4.6770000000E+04, 3.9940681713E+01, 5.0563200842E+00, 2.0558431878E+01, 3.6839025796E+00, 9.7620853418E-01],
	[4.6775000000E+04, 3.9948249128E+01, 5.0563632767E+00, 2.0565587633E+01, 3.6842195886E+00, 9.7621740345E-01],
	[4.6780000000E+04, 3.9955823645E+01, 5.0564072071E+00, 2.0572745113E+01, 3.6845369749E+00, 9.7622626896E-01],
	[4.6785000000E+04, 3.9963398789E+01, 5.0564511332E+00, 2.0579904318E+01, 3.6848542896E+00, 9.7623513071E-01],
	[4.6790000000E+04, 3.9970974559E+01, 5.0564950549E+00, 2.0587065248E+01, 3.6851715328E+00, 9.7624398869E-01],
	[4.6795000000E+04, 3.9978550955E+01, 5.0565389724E+00, 2.0594227902E+01, 3.6854887044E+00, 9.7625284291E-01],
	[4.6800000000E+04, 3.9986127978E+01, 5.0565828855E+00, 2.0601392282E+01, 3.6858058045E+00, 9.7626169337E-01],
	[4.6805000000E+04, 3.9993705627E+01, 5.0566267943E+00, 2.0608558388E+01, 3.6861228330E+00, 9.7627054007E-01],
	[4.6810000000E+04, 4.0001283903E+01, 5.0566706988E+00, 2.0615726219E+01, 3.6864397900E+00, 9.7627938301E-01],
	[4.6815000000E+04, 4.0008862805E+01, 5.0567145990E+00, 2.0622895777E+01, 3.6867566756E+00, 9.7628822221E-01],
	[4.6820000000E+04, 4.0016442333E+01, 5.0567584949E+00, 2.0630067061E+01, 3.6870734896E+00, 9.7629705764E-01],
	[4.6825000000E+04, 4.0024022487E+01, 5.0568023865E+00, 2.0637240071E+01, 3.6873902322E+00, 9.7630588933E-01],
	[4.6830000000E+04, 4.0031603268E+01, 5.0568462738E+00, 2.0644414808E+01, 3.6877069033E+00, 9.7631471727E-01],
	[4.6835000000E+04, 4.0039184675E+01, 5.0568901568E+00, 2.0651591272E+01, 3.6880235030E+00, 9.7632354146E-01],
	[4.6840000000E+04, 4.0046766708E+01, 5.0569340354E+00, 2.0658769463E+01, 3.6883400313E+00, 9.7633236190E-01],
	[4.6845000000E+04, 4.0054349368E+01, 5.0569779098E+00, 2.0665949382E+01, 3.6886564882E+00, 9.7634117860E-01],
	[4.6850000000E+04, 4.0061932653E+01, 5.0570217799E+00, 2.0673131029E+01, 3.6889728737E+00, 9.7634999156E-01],
	[4.6855000000E+04, 4.0069516565E+01, 5.0570656456E+00, 2.0680314403E+01, 3.6892891878E+00, 9.7635880077E-01],
	[4.6860000000E+04, 4.0077101103E+01, 5.0571095071E+00, 2.0687499505E+01, 3.6896054306E+00, 9.7636760625E-01],
	[4.6865000000E+04, 4.0084686268E+01, 5.0571533643E+00, 2.0694686336E+01, 3.6899216020E+00, 9.7637640799E-01],
	[4.6870000000E+04, 4.0092272058E+01, 5.0571972171E+00, 2.0701874896E+01, 3.6902377021E+00, 9.7638520599E-01],
	[4.6875000000E+04, 4.0099858474E+01, 5.0572410657E+00, 2.0709065184E+01, 3.6905537309E+00, 9.7639400025E-01],
	[4.6880000000E+04, 4.0107445517E+01, 5.0572849100E+00, 2.0716257201E+01, 3.6908696884E+00, 9.7640279078E-01],
	[4.6885000000E+04, 4.0115033186E+01, 5.0573287500E+00, 2.0723450948E+01, 3.6911855747E+00, 9.7641157759E-01],
	[4.6890000000E+04, 4.0122621481E+01, 5.0573725856E+00, 2.0730646424E+01, 3.6915013896E+00, 9.7642036066E-01],
	[4.6895000000E+04, 4.0130210402E+01, 5.0574164170E+00, 2.0737843630E+01, 3.6918171334E+00, 9.7642914000E-01],
	[4.6900000000E+04, 4.0137799949E+01, 5.0574602441E+00, 2.0745042566E+01, 3.6921328059E+00, 9.7643791562E-01],
	[4.6905000000E+04, 4.0145390122E+01, 5.0575040669E+00, 2.0752243232E+01, 3.6924484072E+00, 9.7644668751E-01],
	[4.6910000000E+04, 4.0152980921E+01, 5.0575478854E+00, 2.0759445628E+01, 3.6927639373E+00, 9.7645545568E-01],
	[4.6915000000E+04, 4.0160572346E+01, 5.0575916996E+00, 2.0766649756E+01, 3.6930793962E+00, 9.7646422013E-01],
	[4.6920000000E+04, 4.0168164397E+01, 5.0576355096E+00, 2.0773855614E+01, 3.6933947840E+00, 9.7647298085E-01],
	[4.6925000000E+04, 4.0175757075E+01, 5.0576793152E+00, 2.0781063203E+01, 3.6937101006E+00, 9.7648173786E-01],
	[4.6930000000E+04, 4.0183350378E+01, 5.0577231166E+00, 2.0788272524E+01, 3.6940253461E+00, 9.7649049115E-01],
	[4.6935000000E+04, 4.0190944307E+01, 5.0577669136E+00, 2.0795483576E+01, 3.6943405204E+00, 9.7649924073E-01],
	[4.6940000000E+04, 4.0198538862E+01, 5.0578107064E+00, 2.0802696360E+01, 3.6946556237E+00, 9.7650798660E-01],
	[4.6945000000E+04, 4.0206134043E+01, 5.0578544949E+00, 2.0809910876E+01, 3.6949706559E+00, 9.7651672875E-01],
	[4.6950000000E+04, 4.0213729850E+01, 5.0578982791E+00, 2.0817127125E+01, 3.6952856170E+00, 9.7652546719E-01],
	[4.6955000000E+04, 4.0221326282E+01, 5.0579420591E+00, 2.0824345106E+01, 3.6956005071E+00, 9.7653420192E-01],
	[4.6960000000E+04, 4.0228923341E+01, 5.0579858347E+00, 2.0831564820E+01, 3.6959153261E+00, 9.7654293295E-01],
	[4.6965000000E+04, 4.0236521026E+01, 5.0580296061E+00, 2.0838786266E+01, 3.6962300741E+00, 9.7655166027E-01],
	[4.6970000000E+04, 4.0244119336E+01, 5.0580733731E+00, 2.0846009446E+01, 3.6965447511E+00, 9.7656038389E-01],
	[4.6975000000E+04, 4.0251718272E+01, 5.0581171359E+00, 2.0853234360E+01, 3.6968593571E+00, 9.7656910381E-01],
	[4.6980000000E+04, 4.0259317834E+01, 5.0581608945E+00, 2.0860461007E+01, 3.6971738922E+00, 9.7657782002E-01],
	[4.6985000000E+04, 4.0266918022E+01, 5.0582046487E+00, 2.0867689388E+01, 3.6974883563E+00, 9.7658653254E-01],
	[4.6990000000E+04, 4.0274518836E+01, 5.0582483987E+00, 2.0874919503E+01, 3.6978027494E+00, 9.7659524136E-01],
	[4.6995000000E+04, 4.0282120275E+01, 5.0582921444E+00, 2.0882151353E+01, 3.6981170716E+00, 9.7660394648E-01],
	[4.7000000000E+04, 4.0289722340E+01, 5.0583358858E+00, 2.0889384937E+01, 3.6984313229E+00, 9.7661264791E-01],
	[4.7005000000E+04, 4.0297325031E+01, 5.0583796229E+00, 2.0896620256E+01, 3.6987455034E+00, 9.7662134565E-01],
	[4.7010000000E+04, 4.0304928348E+01, 5.0584233558E+00, 2.0903857310E+01, 3.6990596129E+00, 9.7663003970E-01],
	[4.7015000000E+04, 4.0312532291E+01, 5.0584670844E+00, 2.0911096099E+01, 3.6993736516E+00, 9.7663873006E-01],
	[4.7020000000E+04, 4.0320136859E+01, 5.0585108087E+00, 2.0918336624E+01, 3.6996876194E+00, 9.7664741673E-01],
	[4.7025000000E+04, 4.0327742052E+01, 5.0585545287E+00, 2.0925578885E+01, 3.7000015164E+00, 9.7665609972E-01],
	[4.7030000000E+04, 4.0335347872E+01, 5.0585982445E+00, 2.0932822881E+01, 3.7003153426E+00, 9.7666477903E-01],
	[4.7035000000E+04, 4.0342954317E+01, 5.0586419560E+00, 2.0940068614E+01, 3.7006290980E+00, 9.7667345465E-01],
	[4.7040000000E+04, 4.0350561388E+01, 5.0586856632E+00, 2.0947316083E+01, 3.7009427826E+00, 9.7668212659E-01],
	[4.7045000000E+04, 4.0358169084E+01, 5.0587293662E+00, 2.0954565289E+01, 3.7012563964E+00, 9.7669079485E-01],
	[4.7050000000E+04, 4.0365777406E+01, 5.0587730649E+00, 2.0961816232E+01, 3.7015699395E+00, 9.7669945943E-01],
	[4.7055000000E+04, 4.0373386354E+01, 5.0588167594E+00, 2.0969068913E+01, 3.7018834119E+00, 9.7670812034E-01],
	[4.7060000000E+04, 4.0380995927E+01, 5.0588604495E+00, 2.0976323330E+01, 3.7021968135E+00, 9.7671677757E-01],
	[4.7065000000E+04, 4.0388606126E+01, 5.0589041354E+00, 2.0983579485E+01, 3.7025101445E+00, 9.7672543114E-01],
	[4.7070000000E+04, 4.0396216950E+01, 5.0589478171E+00, 2.0990837378E+01, 3.7028234047E+00, 9.7673408103E-01],
	[4.7075000000E+04, 4.0403828400E+01, 5.0589914945E+00, 2.0998097009E+01, 3.7031365943E+00, 9.7674272725E-01],
	[4.7080000000E+04, 4.0411440476E+01, 5.0590351676E+00, 2.1005358378E+01, 3.7034497132E+00, 9.7675136980E-01],
	[4.7085000000E+04, 4.0419053176E+01, 5.0590788364E+00, 2.1012621486E+01, 3.7037627615E+00, 9.7676000869E-01],
	[4.7090000000E+04, 4.0426666503E+01, 5.0591225010E+00, 2.1019886333E+01, 3.7040757392E+00, 9.7676864392E-01],
	[4.7095000000E+04, 4.0434280455E+01, 5.0591661614E+00, 2.1027152918E+01, 3.7043886462E+00, 9.7677727548E-01],
	[4.7100000000E+04, 4.0441895032E+01, 5.0592098175E+00, 2.1034421243E+01, 3.7047014827E+00, 9.7678590338E-01],
	[4.7105000000E+04, 4.0449510235E+01, 5.0592534693E+00, 2.1041691308E+01, 3.7050142486E+00, 9.7679452762E-01],
	[4.7110000000E+04, 4.0457126063E+01, 5.0592971168E+00, 2.1048963112E+01, 3.7053269439E+00, 9.7680314820E-01],
	[4.7115000000E+04, 4.0464742517E+01, 5.0593407602E+00, 2.1056236655E+01, 3.7056395687E+00, 9.7681176513E-01],
	[4.7120000000E+04, 4.0472359596E+01, 5.0593843992E+00, 2.1063511940E+01, 3.7059521229E+00, 9.7682037840E-01],
	[4.7125000000E+04, 4.0479977300E+01, 5.0594280340E+00, 2.1070788964E+01, 3.7062646066E+00, 9.7682898802E-01],
	[4.7130000000E+04, 4.0487595630E+01, 5.0594716646E+00, 2.1078067729E+01, 3.7065770199E+00, 9.7683759399E-01],
	[4.7135000000E+04, 4.0495214585E+01, 5.0595152909E+00, 2.1085348235E+01, 3.7068893627E+00, 9.7684619631E-01],
	[4.7140000000E+04, 4.0502834166E+01, 5.0595589129E+00, 2.1092630482E+01, 3.7072016350E+00, 9.7685479498E-01],
	[4.7145000000E+04, 4.0510454372E+01, 5.0596025307E+00, 2.1099914470E+01, 3.7075138368E+00, 9.7686339001E-01],
	[4.7150000000E+04, 4.0518075203E+01, 5.0596461442E+00, 2.1107200200E+01, 3.7078259682E+00, 9.7687198139E-01],
	[4.7155000000E+04, 4.0525696659E+01, 5.0596897535E+00, 2.1114487672E+01, 3.7081380292E+00, 9.7688056912E-01],
	[4.7160000000E+04, 4.0533318741E+01, 5.0597333586E+00, 2.1121776886E+01, 3.7084500198E+00, 9.7688915322E-01],
	[4.7165000000E+04, 4.0540941448E+01, 5.0597769594E+00, 2.1129067842E+01, 3.7087619400E+00, 9.7689773368E-01],
	[4.7170000000E+04, 4.0548564780E+01, 5.0598205559E+00, 2.1136360540E+01, 3.7090737899E+00, 9.7690631049E-01],
	[4.7175000000E+04, 4.0556188738E+01, 5.0598641482E+00, 2.1143654981E+01, 3.7093855694E+00, 9.7691488367E-01],
	[4.7180000000E+04, 4.0563813320E+01, 5.0599077363E+00, 2.1150951165E+01, 3.7096972785E+00, 9.7692345322E-01],
	[4.7185000000E+04, 4.0571438528E+01, 5.0599513201E+00, 2.1158249092E+01, 3.7100089173E+00, 9.7693201913E-01],
	[4.7190000000E+04, 4.0579064362E+01, 5.0599948997E+00, 2.1165548763E+01, 3.7103204859E+00, 9.7694058142E-01],
	[4.7195000000E+04, 4.0586690820E+01, 5.0600384750E+00, 2.1172850177E+01, 3.7106319841E+00, 9.7694914007E-01],
	[4.7200000000E+04, 4.0594317903E+01, 5.0600820461E+00, 2.1180153335E+01, 3.7109434120E+00, 9.7695769509E-01],
	[4.7205000000E+04, 4.0601945612E+01, 5.0601256130E+00, 2.1187458237E+01, 3.7112547697E+00, 9.7696624649E-01],
	[4.7210000000E+04, 4.0609573946E+01, 5.0601691756E+00, 2.1194764883E+01, 3.7115660572E+00, 9.7697479426E-01],
	[4.7215000000E+04, 4.0617202905E+01, 5.0602127340E+00, 2.1202073274E+01, 3.7118772744E+00, 9.7698333840E-01],
	[4.7220000000E+04, 4.0624832489E+01, 5.0602562881E+00, 2.1209383410E+01, 3.7121884215E+00, 9.7699187893E-01],
	[4.7225000000E+04, 4.0632462698E+01, 5.0602998380E+00, 2.1216695291E+01, 3.7124994983E+00, 9.7700041583E-01],
	[4.7230000000E+04, 4.0640093532E+01, 5.0603433837E+00, 2.1224008917E+01, 3.7128105049E+00, 9.7700894912E-01],
	[4.7235000000E+04, 4.0647724991E+01, 5.0603869251E+00, 2.1231324289E+01, 3.7131214414E+00, 9.7701747879E-01],
	[4.7240000000E+04, 4.0655357075E+01, 5.0604304623E+00, 2.1238641406E+01, 3.7134323077E+00, 9.7702600484E-01],
	[4.7245000000E+04, 4.0662989784E+01, 5.0604739953E+00, 2.1245960269E+01, 3.7137431039E+00, 9.7703452728E-01],
	[4.7250000000E+04, 4.0670623119E+01, 5.0605175240E+00, 2.1253280878E+01, 3.7140538300E+00, 9.7704304611E-01],
	[4.7255000000E+04, 4.0678257078E+01, 5.0605610485E+00, 2.1260603234E+01, 3.7143644860E+00, 9.7705156133E-01],
	[4.7260000000E+04, 4.0685891662E+01, 5.0606045688E+00, 2.1267927336E+01, 3.7146750719E+00, 9.7706007294E-01],
	[4.7265000000E+04, 4.0693526872E+01, 5.0606480848E+00, 2.1275253186E+01, 3.7149855877E+00, 9.7706858094E-01],
	[4.7270000000E+04, 4.0701162706E+01, 5.0606915966E+00, 2.1282580782E+01, 3.7152960335E+00, 9.7707708534E-01],
	[4.7275000000E+04, 4.0708799165E+01, 5.0607351042E+00, 2.1289910126E+01, 3.7156064093E+00, 9.7708558613E-01],
	[4.7280000000E+04, 4.0716436249E+01, 5.0607786076E+00, 2.1297241217E+01, 3.7159167150E+00, 9.7709408332E-01],
	[4.7285000000E+04, 4.0724073958E+01, 5.0608221067E+00, 2.1304574056E+01, 3.7162269507E+00, 9.7710257690E-01],
	[4.7290000000E+04, 4.0731712292E+01, 5.0608656016E+00, 2.1311908643E+01, 3.7165371164E+00, 9.7711106689E-01],
	[4.7295000000E+04, 4.0739351251E+01, 5.0609090923E+00, 2.1319244978E+01, 3.7168472122E+00, 9.7711955329E-01],
	[4.7300000000E+04, 4.0746990834E+01, 5.0609525787E+00, 2.1326583062E+01, 3.7171572380E+00, 9.7712803608E-01],
	[4.7305000000E+04, 4.0754631043E+01, 5.0609960610E+00, 2.1333922895E+01, 3.7174671939E+00, 9.7713651528E-01],
	[4.7310000000E+04, 4.0762271876E+01, 5.0610395390E+00, 2.1341264476E+01, 3.7177770798E+00, 9.7714499089E-01],
	[4.7315000000E+04, 4.0769913334E+01, 5.0610830128E+00, 2.1348607807E+01, 3.7180868958E+00, 9.7715346291E-01],
	[4.7320000000E+04, 4.0777555417E+01, 5.0611264823E+00, 2.1355952887E+01, 3.7183966419E+00, 9.7716193134E-01],
	[4.7325000000E+04, 4.0785198125E+01, 5.0611699477E+00, 2.1363299716E+01, 3.7187063182E+00, 9.7717039618E-01],
	[4.7330000000E+04, 4.0792841457E+01, 5.0612134088E+00, 2.1370648296E+01, 3.7190159246E+00, 9.7717885743E-01],
	[4.7335000000E+04, 4.0800485414E+01, 5.0612568657E+00, 2.1377998625E+01, 3.7193254611E+00, 9.7718731510E-01],
	[4.7340000000E+04, 4.0808129996E+01, 5.0613003184E+00, 2.1385350705E+01, 3.7196349278E+00, 9.7719576919E-01],
	[4.7345000000E+04, 4.0815775203E+01, 5.0613437669E+00, 2.1392704536E+01, 3.7199443247E+00, 9.7720421969E-01],
	[4.7350000000E+04, 4.0823421034E+01, 5.0613872111E+00, 2.1400060117E+01, 3.7202536518E+00, 9.7721266662E-01],
	[4.7355000000E+04, 4.0831067491E+01, 5.0614306512E+00, 2.1407417450E+01, 3.7205629092E+00, 9.7722110996E-01],
	[4.7360000000E+04, 4.0838714571E+01, 5.0614740870E+00, 2.1414776533E+01, 3.7208720967E+00, 9.7722954973E-01],
	[4.7365000000E+04, 4.0846362277E+01, 5.0615175186E+00, 2.1422137369E+01, 3.7211812145E+00, 9.7723798593E-01],
	[4.7370000000E+04, 4.0854010607E+01, 5.0615609461E+00, 2.1429499955E+01, 3.7214902626E+00, 9.7724641855E-01],
	[4.7375000000E+04, 4.0861659562E+01, 5.0616043693E+00, 2.1436864294E+01, 3.7217992409E+00, 9.7725484760E-01],
	[4.7380000000E+04, 4.0869309141E+01, 5.0616477882E+00, 2.1444230385E+01, 3.7221081495E+00, 9.7726327308E-01],
	[4.7385000000E+04, 4.0876959345E+01, 5.0616912030E+00, 2.1451598229E+01, 3.7224169885E+00, 9.7727169499E-01],
	[4.7390000000E+04, 4.0884610174E+01, 5.0617346136E+00, 2.1458967825E+01, 3.7227257578E+00, 9.7728011334E-01],
	[4.7395000000E+04, 4.0892261627E+01, 5.0617780199E+00, 2.1466339174E+01, 3.7230344574E+00, 9.7728852812E-01],
	[4.7400000000E+04, 4.0899913705E+01, 5.0618214221E+00, 2.1473712276E+01, 3.7233430874E+00, 9.7729693934E-01],
	[4.7405000000E+04, 4.0907566407E+01, 5.0618648201E+00, 2.1481087131E+01, 3.7236516477E+00, 9.7730534699E-01],
	[4.7410000000E+04, 4.0915219734E+01, 5.0619082138E+00, 2.1488463740E+01, 3.7239601385E+00, 9.7731375108E-01],
	[4.7415000000E+04, 4.0922873685E+01, 5.0619516033E+00, 2.1495842103E+01, 3.7242685596E+00, 9.7732215162E-01],
	[4.7420000000E+04, 4.0930528261E+01, 5.0619949887E+00, 2.1503222220E+01, 3.7245769112E+00, 9.7733054860E-01],
	[4.7425000000E+04, 4.0938183462E+01, 5.0620383698E+00, 2.1510604091E+01, 3.7248851932E+00, 9.7733894202E-01],
	[4.7430000000E+04, 4.0945839286E+01, 5.0620817467E+00, 2.1517987717E+01, 3.7251934057E+00, 9.7734733189E-01],
	[4.7435000000E+04, 4.0953495736E+01, 5.0621251195E+00, 2.1525373097E+01, 3.7255015487E+00, 9.7735571820E-01],
	[4.7440000000E+04, 4.0961152810E+01, 5.0621684880E+00, 2.1532760233E+01, 3.7258096221E+00, 9.7736410097E-01],
	[4.7445000000E+04, 4.0968810508E+01, 5.0622118523E+00, 2.1540149123E+01, 3.7261176260E+00, 9.7737248019E-01],
	[4.7450000000E+04, 4.0976468830E+01, 5.0622552125E+00, 2.1547539769E+01, 3.7264255605E+00, 9.7738085585E-01],
	[4.7455000000E+04, 4.0984127777E+01, 5.0622985684E+00, 2.1554932171E+01, 3.7267334255E+00, 9.7738922798E-01],
	[4.7460000000E+04, 4.0991787349E+01, 5.0623419202E+00, 2.1562326328E+01, 3.7270412210E+00, 9.7739759656E-01],
	[4.7465000000E+04, 4.0999447544E+01, 5.0623852677E+00, 2.1569722242E+01, 3.7273489471E+00, 9.7740596159E-01],
	[4.7470000000E+04, 4.1007108365E+01, 5.0624286110E+00, 2.1577119912E+01, 3.7276566038E+00, 9.7741432309E-01],
	[4.7475000000E+04, 4.1014769809E+01, 5.0624719502E+00, 2.1584519339E+01, 3.7279641910E+00, 9.7742268104E-01],
	[4.7480000000E+04, 4.1022431878E+01, 5.0625152852E+00, 2.1591920522E+01, 3.7282717089E+00, 9.7743103546E-01],
	[4.7485000000E+04, 4.1030094571E+01, 5.0625586159E+00, 2.1599323463E+01, 3.7285791575E+00, 9.7743938634E-01],
	[4.7490000000E+04, 4.1037757888E+01, 5.0626019425E+00, 2.1606728161E+01, 3.7288865366E+00, 9.7744773369E-01],
	[4.7495000000E+04, 4.1045421830E+01, 5.0626452649E+00, 2.1614134616E+01, 3.7291938464E+00, 9.7745607750E-01],
	[4.7500000000E+04, 4.1053086396E+01, 5.0626885831E+00, 2.1621542829E+01, 3.7295010869E+00, 9.7746441778E-01],
	[4.7505000000E+04, 4.1060751586E+01, 5.0627318971E+00, 2.1628952800E+01, 3.7298082581E+00, 9.7747275454E-01],
	[4.7510000000E+04, 4.1068417401E+01, 5.0627752069E+00, 2.1636364529E+01, 3.7301153600E+00, 9.7748108776E-01],
	[4.7515000000E+04, 4.1076083839E+01, 5.0628185126E+00, 2.1643778017E+01, 3.7304223927E+00, 9.7748941746E-01],
	[4.7520000000E+04, 4.1083750902E+01, 5.0628618140E+00, 2.1651193263E+01, 3.7307293560E+00, 9.7749774363E-01],
	[4.7525000000E+04, 4.1091418589E+01, 5.0629051113E+00, 2.1658610269E+01, 3.7310362502E+00, 9.7750606628E-01],
	[4.7530000000E+04, 4.1099101534E+01, 5.0629500473E+00, 2.1666029033E+01, 3.7313440880E+00, 9.7751438541E-01],
	[4.7535000000E+04, 4.1106785478E+01, 5.0629950206E+00, 2.1673449557E+01, 3.7316518826E+00, 9.7752270101E-01],
	[4.7540000000E+04, 4.1114470050E+01, 5.0630399897E+00, 2.1680871840E+01, 3.7319596081E+00, 9.7753101310E-01],
	[4.7545000000E+04, 4.1122155250E+01, 5.0630849544E+00, 2.1688295884E+01, 3.7322672646E+00, 9.7753932167E-01],
	[4.7550000000E+04, 4.1129841079E+01, 5.0631299147E+00, 2.1695721687E+01, 3.7325748520E+00, 9.7754762673E-01],
	[4.7555000000E+04, 4.1137527535E+01, 5.0631748708E+00, 2.1703149250E+01, 3.7328823706E+00, 9.7755592827E-01],
	[4.7560000000E+04, 4.1145214620E+01, 5.0632198225E+00, 2.1710578575E+01, 3.7331898201E+00, 9.7756422630E-01],
	[4.7565000000E+04, 4.1152902333E+01, 5.0632647699E+00, 2.1718009659E+01, 3.7334972007E+00, 9.7757252082E-01],
	[4.7570000000E+04, 4.1160590674E+01, 5.0633097129E+00, 2.1725442505E+01, 3.7338045124E+00, 9.7758081183E-01],
	[4.7575000000E+04, 4.1168279643E+01, 5.0633546516E+00, 2.1732877112E+01, 3.7341117551E+00, 9.7758909934E-01],
	[4.7580000000E+04, 4.1175969240E+01, 5.0633995861E+00, 2.1740313481E+01, 3.7344189290E+00, 9.7759738333E-01],
	[4.7585000000E+04, 4.1183659465E+01, 5.0634445161E+00, 2.1747751611E+01, 3.7347260340E+00, 9.7760566383E-01],
	[4.7590000000E+04, 4.1191350318E+01, 5.0634894419E+00, 2.1755191503E+01, 3.7350330701E+00, 9.7761394082E-01],
	[4.7595000000E+04, 4.1199041799E+01, 5.0635343633E+00, 2.1762633158E+01, 3.7353400373E+00, 9.7762221431E-01],
	[4.7600000000E+04, 4.1206733908E+01, 5.0635792805E+00, 2.1770076575E+01, 3.7356469357E+00, 9.7763048430E-01],
	[4.7605000000E+04, 4.1214426645E+01, 5.0636241933E+00, 2.1777521754E+01, 3.7359537653E+00, 9.7763875079E-01],
	[4.7610000000E+04, 4.1222120010E+01, 5.0636691017E+00, 2.1784968696E+01, 3.7362605261E+00, 9.7764701379E-01],
	[4.7615000000E+04, 4.1229814003E+01, 5.0637140059E+00, 2.1792417401E+01, 3.7365672181E+00, 9.7765527329E-01],
	[4.7620000000E+04, 4.1237508624E+01, 5.0637589058E+00, 2.1799867870E+01, 3.7368738413E+00, 9.7766352930E-01],
	[4.7625000000E+04, 4.1245203873E+01, 5.0638038013E+00, 2.1807320102E+01, 3.7371803957E+00, 9.7767178182E-01],
	[4.7630000000E+04, 4.1252899749E+01, 5.0638486925E+00, 2.1814774098E+01, 3.7374868814E+00, 9.7768003084E-01],
	[4.7635000000E+04, 4.1260596254E+01, 5.0638935794E+00, 2.1822229858E+01, 3.7377932984E+00, 9.7768827638E-01],
	[4.7640000000E+04, 4.1268293387E+01, 5.0639384620E+00, 2.1829687382E+01, 3.7380996467E+00, 9.7769651844E-01],
	[4.7645000000E+04, 4.1275991147E+01, 5.0639833403E+00, 2.1837146671E+01, 3.7384059263E+00, 9.7770475700E-01],
	[4.7650000000E+04, 4.1283689535E+01, 5.0640282142E+00, 2.1844607724E+01, 3.7387121372E+00, 9.7771299209E-01],
	[4.7655000000E+04, 4.1291388551E+01, 5.0640730839E+00, 2.1852070542E+01, 3.7390182794E+00, 9.7772122369E-01],
	[4.7660000000E+04, 4.1299088195E+01, 5.0641179492E+00, 2.1859535126E+01, 3.7393243530E+00, 9.7772945181E-01],
	[4.7665000000E+04, 4.1306788467E+01, 5.0641628103E+00, 2.1867001474E+01, 3.7396303579E+00, 9.7773767646E-01],
	[4.7670000000E+04, 4.1314489367E+01, 5.0642076670E+00, 2.1874469589E+01, 3.7399362942E+00, 9.7774589762E-01],
	[4.7675000000E+04, 4.1322190894E+01, 5.0642525194E+00, 2.1881939469E+01, 3.7402421620E+00, 9.7775411531E-01],
	[4.7680000000E+04, 4.1329893049E+01, 5.0642973675E+00, 2.1889411116E+01, 3.7405479611E+00, 9.7776232953E-01],
	[4.7685000000E+04, 4.1337595832E+01, 5.0643422113E+00, 2.1896884528E+01, 3.7408536917E+00, 9.7777054028E-01],
	[4.7690000000E+04, 4.1345299242E+01, 5.0643870508E+00, 2.1904359708E+01, 3.7411593537E+00, 9.7777874755E-01],
	[4.7695000000E+04, 4.1353003281E+01, 5.0644318860E+00, 2.1911836654E+01, 3.7414649472E+00, 9.7778695136E-01],
	[4.7700000000E+04, 4.1360707947E+01, 5.0644767169E+00, 2.1919315367E+01, 3.7417704721E+00, 9.7779515169E-01],
	[4.7705000000E+04, 4.1368413240E+01, 5.0645215435E+00, 2.1926795847E+01, 3.7420759286E+00, 9.7780334857E-01],
	[4.7710000000E+04, 4.1376119162E+01, 5.0645663658E+00, 2.1934278095E+01, 3.7423813165E+00, 9.7781154197E-01],
	[4.7715000000E+04, 4.1383825711E+01, 5.0646111838E+00, 2.1941762110E+01, 3.7426866360E+00, 9.7781973192E-01],
	[4.7720000000E+04, 4.1391532887E+01, 5.0646559975E+00, 2.1949247894E+01, 3.7429918870E+00, 9.7782791840E-01],
	[4.7725000000E+04, 4.1399240692E+01, 5.0647008069E+00, 2.1956735446E+01, 3.7432970696E+00, 9.7783610143E-01],
	[4.7730000000E+04, 4.1406949123E+01, 5.0647456120E+00, 2.1964224766E+01, 3.7436021837E+00, 9.7784428099E-01],
	[4.7735000000E+04, 4.1414658183E+01, 5.0647904128E+00, 2.1971715855E+01, 3.7439072294E+00, 9.7785245710E-01],
	[4.7740000000E+04, 4.1422367870E+01, 5.0648352093E+00, 2.1979208712E+01, 3.7442122067E+00, 9.7786062976E-01],
	[4.7745000000E+04, 4.1430078185E+01, 5.0648800015E+00, 2.1986703339E+01, 3.7445171157E+00, 9.7786879896E-01],
	[4.7750000000E+04, 4.1437789127E+01, 5.0649247894E+00, 2.1994199735E+01, 3.7448219562E+00, 9.7787696471E-01],
	[4.7755000000E+04, 4.1445500697E+01, 5.0649695730E+00, 2.2001697901E+01, 3.7451267285E+00, 9.7788512701E-01],
	[4.7760000000E+04, 4.1453212894E+01, 5.0650143523E+00, 2.2009197836E+01, 3.7454314324E+00, 9.7789328586E-01],
	[4.7765000000E+04, 4.1460925719E+01, 5.0650591274E+00, 2.2016699542E+01, 3.7457360679E+00, 9.7790144127E-01],
	[4.7770000000E+04, 4.1468639171E+01, 5.0651038981E+00, 2.2024203017E+01, 3.7460406352E+00, 9.7790959323E-01],
	[4.7775000000E+04, 4.1476353251E+01, 5.0651486646E+00, 2.2031708264E+01, 3.7463451342E+00, 9.7791774175E-01],
	[4.7780000000E+04, 4.1484067958E+01, 5.0651934267E+00, 2.2039215281E+01, 3.7466495649E+00, 9.7792588682E-01],
	[4.7785000000E+04, 4.1491783293E+01, 5.0652381846E+00, 2.2046724069E+01, 3.7469539273E+00, 9.7793402845E-01],
	[4.7790000000E+04, 4.1499499255E+01, 5.0652829382E+00, 2.2054234628E+01, 3.7472582215E+00, 9.7794216665E-01],
	[4.7795000000E+04, 4.1507215845E+01, 5.0653276875E+00, 2.2061746959E+01, 3.7475624475E+00, 9.7795030140E-01],
	[4.7800000000E+04, 4.1514933062E+01, 5.0653724325E+00, 2.2069261061E+01, 3.7478666053E+00, 9.7795843273E-01],
	[4.7805000000E+04, 4.1522650906E+01, 5.0654171732E+00, 2.2076776935E+01, 3.7481706948E+00, 9.7796656061E-01],
	[4.7810000000E+04, 4.1530369378E+01, 5.0654619097E+00, 2.2084294581E+01, 3.7484747162E+00, 9.7797468507E-01],
	[4.7815000000E+04, 4.1538088477E+01, 5.0655066418E+00, 2.2091814000E+01, 3.7487786695E+00, 9.7798280609E-01],
	[4.7820000000E+04, 4.1545808204E+01, 5.0655513697E+00, 2.2099335191E+01, 3.7490825545E+00, 9.7799092369E-01],
	[4.7825000000E+04, 4.1553528557E+01, 5.0655960933E+00, 2.2106858155E+01, 3.7493863715E+00, 9.7799903785E-01],
	[4.7830000000E+04, 4.1561249539E+01, 5.0656408126E+00, 2.2114382892E+01, 3.7496901203E+00, 9.7800714859E-01],
	[4.7835000000E+04, 4.1568971147E+01, 5.0656855277E+00, 2.2121909403E+01, 3.7499938011E+00, 9.7801525591E-01],
	[4.7840000000E+04, 4.1576693383E+01, 5.0657302384E+00, 2.2129437687E+01, 3.7502974137E+00, 9.7802335980E-01],
	[4.7845000000E+04, 4.1584416246E+01, 5.0657749449E+00, 2.2136967745E+01, 3.7506009583E+00, 9.7803146027E-01],
	[4.7850000000E+04, 4.1592139736E+01, 5.0658196471E+00, 2.2144499576E+01, 3.7509044348E+00, 9.7803955732E-01],
	[4.7855000000E+04, 4.1599863854E+01, 5.0658643450E+00, 2.2152033182E+01, 3.7512078433E+00, 9.7804765096E-01],
	[4.7860000000E+04, 4.1607588599E+01, 5.0659090387E+00, 2.2159568562E+01, 3.7515111838E+00, 9.7805574117E-01],
	[4.7865000000E+04, 4.1615313971E+01, 5.0659537281E+00, 2.2167105717E+01, 3.7518144563E+00, 9.7806382797E-01],
	[4.7870000000E+04, 4.1623039970E+01, 5.0659984132E+00, 2.2174644647E+01, 3.7521176607E+00, 9.7807191136E-01],
	[4.7875000000E+04, 4.1630766597E+01, 5.0660430940E+00, 2.2182185352E+01, 3.7524207972E+00, 9.7807999133E-01],
	[4.7880000000E+04, 4.1638493850E+01, 5.0660877706E+00, 2.2189727833E+01, 3.7527238658E+00, 9.7808806790E-01],
	[4.7885000000E+04, 4.1646221731E+01, 5.0661324428E+00, 2.2197272089E+01, 3.7530268664E+00, 9.7809614105E-01],
	[4.7890000000E+04, 4.1653950239E+01, 5.0661771109E+00, 2.2204818121E+01, 3.7533297990E+00, 9.7810421080E-01],
	[4.7895000000E+04, 4.1661679374E+01, 5.0662217746E+00, 2.2212365929E+01, 3.7536326638E+00, 9.7811227714E-01],
	[4.7900000000E+04, 4.1669409136E+01, 5.0662664341E+00, 2.2219915513E+01, 3.7539354607E+00, 9.7812034008E-01],
	[4.7905000000E+04, 4.1677139526E+01, 5.0663110893E+00, 2.2227466874E+01, 3.7542381896E+00, 9.7812839962E-01],
	[4.7910000000E+04, 4.1684870542E+01, 5.0663557402E+00, 2.2235020012E+01, 3.7545408508E+00, 9.7813645575E-01],
	[4.7915000000E+04, 4.1692602185E+01, 5.0664003869E+00, 2.2242574926E+01, 3.7548434440E+00, 9.7814450849E-01],
	[4.7920000000E+04, 4.1700334456E+01, 5.0664450293E+00, 2.2250131618E+01, 3.7551459694E+00, 9.7815255783E-01],
	[4.7925000000E+04, 4.1708067354E+01, 5.0664896675E+00, 2.2257690087E+01, 3.7554484271E+00, 9.7816060377E-01],
	[4.7930000000E+04, 4.1715800878E+01, 5.0665343014E+00, 2.2265250334E+01, 3.7557508169E+00, 9.7816864631E-01],
	[4.7935000000E+04, 4.1723535030E+01, 5.0665789310E+00, 2.2272812359E+01, 3.7560531389E+00, 9.7817668547E-01],
	[4.7940000000E+04, 4.1731269808E+01, 5.0666235563E+00, 2.2280376162E+01, 3.7563553931E+00, 9.7818472123E-01],
	[4.7945000000E+04, 4.1739005214E+01, 5.0666681774E+00, 2.2287941744E+01, 3.7566575796E+00, 9.7819275360E-01],
	[4.7950000000E+04, 4.1746741247E+01, 5.0667127943E+00, 2.2295509104E+01, 3.7569596984E+00, 9.7820078258E-01],
	[4.7955000000E+04, 4.1754477906E+01, 5.0667574068E+00, 2.2303078243E+01, 3.7572617494E+00, 9.7820880818E-01],
	[4.7960000000E+04, 4.1762215193E+01, 5.0668020152E+00, 2.2310649161E+01, 3.7575637327E+00, 9.7821683039E-01],
	[4.7965000000E+04, 4.1769953106E+01, 5.0668466192E+00, 2.2318221858E+01, 3.7578656484E+00, 9.7822484921E-01],
	[4.7970000000E+04, 4.1777691647E+01, 5.0668912190E+00, 2.2325796335E+01, 3.7581674963E+00, 9.7823286466E-01],
	[4.7975000000E+04, 4.1785430814E+01, 5.0669358146E+00, 2.2333372592E+01, 3.7584692766E+00, 9.7824087672E-01],
	[4.7980000000E+04, 4.1793170608E+01, 5.0669804059E+00, 2.2340950629E+01, 3.7587709892E+00, 9.7824888541E-01],
	[4.7985000000E+04, 4.1800911029E+01, 5.0670249929E+00, 2.2348530446E+01, 3.7590726343E+00, 9.7825689071E-01],
	[4.7990000000E+04, 4.1808652077E+01, 5.0670695757E+00, 2.2356112043E+01, 3.7593742117E+00, 9.7826489265E-01],
	[4.7995000000E+04, 4.1816393752E+01, 5.0671141542E+00, 2.2363695422E+01, 3.7596757215E+00, 9.7827289120E-01],
	[4.8000000000E+04, 4.1824136053E+01, 5.0671587285E+00, 2.2371280581E+01, 3.7599771637E+00, 9.7828088639E-01],
	[4.8005000000E+04, 4.1831878981E+01, 5.0672032985E+00, 2.2378867521E+01, 3.7602785383E+00, 9.7828887820E-01],
	[4.8010000000E+04, 4.1839622537E+01, 5.0672478643E+00, 2.2386456243E+01, 3.7605798454E+00, 9.7829686664E-01],
	[4.8015000000E+04, 4.1847366719E+01, 5.0672924258E+00, 2.2394046746E+01, 3.7608810850E+00, 9.7830485172E-01],
	[4.8020000000E+04, 4.1855111527E+01, 5.0673369831E+00, 2.2401639032E+01, 3.7611822570E+00, 9.7831283343E-01],
	[4.8025000000E+04, 4.1862856963E+01, 5.0673815362E+00, 2.2409233099E+01, 3.7614833615E+00, 9.7832081177E-01],
	[4.8030000000E+04, 4.1870603025E+01, 5.0674260850E+00, 2.2416828949E+01, 3.7617843986E+00, 9.7832878675E-01],
	[4.8035000000E+04, 4.1878349714E+01, 5.0674706295E+00, 2.2424426581E+01, 3.7620853681E+00, 9.7833675837E-01],
	[4.8040000000E+04, 4.1886097030E+01, 5.0675151698E+00, 2.2432025996E+01, 3.7623862703E+00, 9.7834472663E-01],
	[4.8045000000E+04, 4.1893844972E+01, 5.0675597058E+00, 2.2439627194E+01, 3.7626871049E+00, 9.7835269153E-01],
	[4.8050000000E+04, 4.1901593541E+01, 5.0676042377E+00, 2.2447230176E+01, 3.7629878722E+00, 9.7836065307E-01],
	[4.8055000000E+04, 4.1909342737E+01, 5.0676487652E+00, 2.2454834941E+01, 3.7632885720E+00, 9.7836861126E-01],
	[4.8060000000E+04, 4.1917092559E+01, 5.0676932886E+00, 2.2462441490E+01, 3.7635892044E+00, 9.7837656609E-01],
	[4.8065000000E+04, 4.1924843008E+01, 5.0677378076E+00, 2.2470049822E+01, 3.7638897695E+00, 9.7838451757E-01],
	[4.8070000000E+04, 4.1932594084E+01, 5.0677823225E+00, 2.2477659939E+01, 3.7641902672E+00, 9.7839246570E-01],
	[4.8075000000E+04, 4.1940345786E+01, 5.0678268331E+00, 2.2485271840E+01, 3.7644906975E+00, 9.7840041048E-01],
	[4.8080000000E+04, 4.1948098115E+01, 5.0678713395E+00, 2.2492885526E+01, 3.7647910605E+00, 9.7840835191E-01],
	[4.8085000000E+04, 4.1955851070E+01, 5.0679158416E+00, 2.2500500997E+01, 3.7650913562E+00, 9.7841629000E-01],
	[4.8090000000E+04, 4.1963604652E+01, 5.0679603395E+00, 2.2508118253E+01, 3.7653915846E+00, 9.7842422474E-01],
	[4.8095000000E+04, 4.1971358861E+01, 5.0680048331E+00, 2.2515737295E+01, 3.7656917457E+00, 9.7843215614E-01],
	[4.8100000000E+04, 4.1979113696E+01, 5.0680493226E+00, 2.2523358122E+01, 3.7659918395E+00, 9.7844008420E-01],
	[4.8105000000E+04, 4.1986869158E+01, 5.0680938078E+00, 2.2530980735E+01, 3.7662918661E+00, 9.7844800891E-01],
	[4.8110000000E+04, 4.1994625246E+01, 5.0681382887E+00, 2.2538605133E+01, 3.7665918254E+00, 9.7845593029E-01],
	[4.8115000000E+04, 4.2002381960E+01, 5.0681827654E+00, 2.2546231319E+01, 3.7668917175E+00, 9.7846384833E-01],
	[4.8120000000E+04, 4.2010139301E+01, 5.0682272379E+00, 2.2553859290E+01, 3.7671915424E+00, 9.7847176304E-01],
	[4.8125000000E+04, 4.2017897269E+01, 5.0682717062E+00, 2.2561489049E+01, 3.7674913001E+00, 9.7847967441E-01],
	[4.8130000000E+04, 4.2025655863E+01, 5.0683161702E+00, 2.2569120594E+01, 3.7677909907E+00, 9.7848758245E-01],
	[4.8135000000E+04, 4.2033415083E+01, 5.0683606300E+00, 2.2576753927E+01, 3.7680906140E+00, 9.7849548716E-01],
	[4.8140000000E+04, 4.2041174930E+01, 5.0684050856E+00, 2.2584389047E+01, 3.7683901702E+00, 9.7850338854E-01],
	[4.8145000000E+04, 4.2048935404E+01, 5.0684495370E+00, 2.2592025955E+01, 3.7686896593E+00, 9.7851128659E-01],
	[4.8150000000E+04, 4.2056696503E+01, 5.0684939841E+00, 2.2599664651E+01, 3.7689890813E+00, 9.7851918132E-01],
	[4.8155000000E+04, 4.2064458229E+01, 5.0685384270E+00, 2.2607305135E+01, 3.7692884362E+00, 9.7852707272E-01],
	[4.8160000000E+04, 4.2072220582E+01, 5.0685828657E+00, 2.2614947407E+01, 3.7695877240E+00, 9.7853496080E-01],
	[4.8165000000E+04, 4.2079983560E+01, 5.0686273001E+00, 2.2622591468E+01, 3.7698869447E+00, 9.7854284556E-01],
	[4.8170000000E+04, 4.2087747166E+01, 5.0686717303E+00, 2.2630237318E+01, 3.7701860984E+00, 9.7855072699E-01],
	[4.8175000000E+04, 4.2095511397E+01, 5.0687161563E+00, 2.2637884957E+01, 3.7704851850E+00, 9.7855860511E-01],
	[4.8180000000E+04, 4.2103276255E+01, 5.0687605781E+00, 2.2645534385E+01, 3.7707842046E+00, 9.7856647992E-01],
	[4.8185000000E+04, 4.2111041739E+01, 5.0688049957E+00, 2.2653185603E+01, 3.7710831573E+00, 9.7857435140E-01],
	[4.8190000000E+04, 4.2118807849E+01, 5.0688494090E+00, 2.2660838610E+01, 3.7713820429E+00, 9.7858221958E-01],
	[4.8195000000E+04, 4.2126574586E+01, 5.0688938182E+00, 2.2668493408E+01, 3.7716808615E+00, 9.7859008444E-01],
	[4.8200000000E+04, 4.2134341948E+01, 5.0689382231E+00, 2.2676149995E+01, 3.7719796132E+00, 9.7859794599E-01],
	[4.8205000000E+04, 4.2142109937E+01, 5.0689826237E+00, 2.2683808374E+01, 3.7722782980E+00, 9.7860580423E-01],
	[4.8210000000E+04, 4.2149878553E+01, 5.0690270202E+00, 2.2691468543E+01, 3.7725769158E+00, 9.7861365917E-01],
	[4.8215000000E+04, 4.2157647794E+01, 5.0690714125E+00, 2.2699130503E+01, 3.7728754667E+00, 9.7862151080E-01],
	[4.8220000000E+04, 4.2165417662E+01, 5.0691158005E+00, 2.2706794254E+01, 3.7731739507E+00, 9.7862935912E-01],
	[4.8225000000E+04, 4.2173188156E+01, 5.0691601843E+00, 2.2714459796E+01, 3.7734723678E+00, 9.7863720415E-01],
	[4.8230000000E+04, 4.2180959276E+01, 5.0692045640E+00, 2.2722127130E+01, 3.7737707181E+00, 9.7864504587E-01],
	[4.8235000000E+04, 4.2188731022E+01, 5.0692489394E+00, 2.2729796256E+01, 3.7740690015E+00, 9.7865288429E-01],
	[4.8240000000E+04, 4.2196503394E+01, 5.0692933106E+00, 2.2737467175E+01, 3.7743672181E+00, 9.7866071941E-01],
	[4.8245000000E+04, 4.2204276393E+01, 5.0693376775E+00, 2.2745139885E+01, 3.7746653679E+00, 9.7866855124E-01],
	[4.8250000000E+04, 4.2212050017E+01, 5.0693820403E+00, 2.2752814388E+01, 3.7749634508E+00, 9.7867637977E-01],
	[4.8255000000E+04, 4.2219824268E+01, 5.0694263989E+00, 2.2760490684E+01, 3.7752614670E+00, 9.7868420500E-01],
	[4.8260000000E+04, 4.2227599144E+01, 5.0694707532E+00, 2.2768168773E+01, 3.7755594164E+00, 9.7869202695E-01],
	[4.8265000000E+04, 4.2235374647E+01, 5.0695151034E+00, 2.2775848655E+01, 3.7758572990E+00, 9.7869984561E-01],
	[4.8270000000E+04, 4.2243150776E+01, 5.0695594493E+00, 2.2783530331E+01, 3.7761551149E+00, 9.7870766097E-01],
	[4.8275000000E+04, 4.2250927531E+01, 5.0696037911E+00, 2.2791213800E+01, 3.7764528641E+00, 9.7871547305E-01],
	[4.8280000000E+04, 4.2258704911E+01, 5.0696481286E+00, 2.2798899064E+01, 3.7767505466E+00, 9.7872328184E-01],
	[4.8285000000E+04, 4.2266482918E+01, 5.0696924619E+00, 2.2806586121E+01, 3.7770481624E+00, 9.7873108735E-01],
	[4.8290000000E+04, 4.2274261551E+01, 5.0697367910E+00, 2.2814274973E+01, 3.7773457115E+00, 9.7873888958E-01],
	[4.8295000000E+04, 4.2282055153E+01, 5.0697826943E+00, 2.2821965620E+01, 3.7776441847E+00, 9.7874668852E-01],
	[4.8300000000E+04, 4.2289850024E+01, 5.0698286637E+00, 2.2829658062E+01, 3.7779426357E+00, 9.7875448419E-01],
	[4.8305000000E+04, 4.2297645526E+01, 5.0698746287E+00, 2.2837352298E+01, 3.7782410202E+00, 9.7876227658E-01],
	[4.8310000000E+04, 4.2305441657E+01, 5.0699205893E+00, 2.2845048330E+01, 3.7785393382E+00, 9.7877006569E-01],
	[4.8315000000E+04, 4.2313238418E+01, 5.0699665456E+00, 2.2852746158E+01, 3.7788375898E+00, 9.7877785152E-01],
	[4.8320000000E+04, 4.2321035809E+01, 5.0700124976E+00, 2.2860445782E+01, 3.7791357750E+00, 9.7878563408E-01],
	[4.8325000000E+04, 4.2328833830E+01, 5.0700584453E+00, 2.2868147201E+01, 3.7794338937E+00, 9.7879341337E-01],
	[4.8330000000E+04, 4.2336632480E+01, 5.0701043886E+00, 2.2875850417E+01, 3.7797319461E+00, 9.7880118939E-01],
	[4.8335000000E+04, 4.2344431761E+01, 5.0701503275E+00, 2.2883555430E+01, 3.7800299321E+00, 9.7880896214E-01],
	[4.8340000000E+04, 4.2352231671E+01, 5.0701962622E+00, 2.2891262239E+01, 3.7803278517E+00, 9.7881673163E-01],
	[4.8345000000E+04, 4.2360032211E+01, 5.0702421924E+00, 2.2898970845E+01, 3.7806257050E+00, 9.7882449784E-01],
	[4.8350000000E+04, 4.2367833381E+01, 5.0702881184E+00, 2.2906681248E+01, 3.7809234919E+00, 9.7883226079E-01],
	[4.8355000000E+04, 4.2375635181E+01, 5.0703340400E+00, 2.2914393449E+01, 3.7812212125E+00, 9.7884002049E-01],
	[4.8360000000E+04, 4.2383437610E+01, 5.0703799573E+00, 2.2922107448E+01, 3.7815188668E+00, 9.7884777691E-01],
	[4.8365000000E+04, 4.2391240669E+01, 5.0704258703E+00, 2.2929823244E+01, 3.7818164549E+00, 9.7885553008E-01],
	[4.8370000000E+04, 4.2399044358E+01, 5.0704717789E+00, 2.2937540839E+01, 3.7821139766E+00, 9.7886327999E-01],
	[4.8375000000E+04, 4.2406848677E+01, 5.0705176832E+00, 2.2945260232E+01, 3.7824114321E+00, 9.7887102665E-01],
	[4.8380000000E+04, 4.2414653625E+01, 5.0705635832E+00, 2.2952981424E+01, 3.7827088214E+00, 9.7887877005E-01],
	[4.8385000000E+04, 4.2422459203E+01, 5.0706094788E+00, 2.2960704414E+01, 3.7830061444E+00, 9.7888651019E-01],
	[4.8390000000E+04, 4.2430265410E+01, 5.0706553702E+00, 2.2968429204E+01, 3.7833034012E+00, 9.7889424709E-01],
	[4.8395000000E+04, 4.2438072248E+01, 5.0707012571E+00, 2.2976155793E+01, 3.7836005919E+00, 9.7890198073E-01],
	[4.8400000000E+04, 4.2445879715E+01, 5.0707471398E+00, 2.2983884181E+01, 3.7838977163E+00, 9.7890971112E-01],
	[4.8405000000E+04, 4.2453687811E+01, 5.0707930182E+00, 2.2991614370E+01, 3.7841947746E+00, 9.7891743827E-01],
	[4.8410000000E+04, 4.2461496537E+01, 5.0708388922E+00, 2.2999346358E+01, 3.7844917668E+00, 9.7892516217E-01],
	[4.8415000000E+04, 4.2469305893E+01, 5.0708847619E+00, 2.3007080147E+01, 3.7847886928E+00, 9.7893288283E-01],
	[4.8420000000E+04, 4.2477115878E+01, 5.0709306272E+00, 2.3014815736E+01, 3.7850855527E+00, 9.7894060024E-01],
	[4.8425000000E+04, 4.2484926493E+01, 5.0709764883E+00, 2.3022553125E+01, 3.7853823465E+00, 9.7894831441E-01],
	[4.8430000000E+04, 4.2492737738E+01, 5.0710223450E+00, 2.3030292316E+01, 3.7856790742E+00, 9.7895602534E-01],
	[4.8435000000E+04, 4.2500549612E+01, 5.0710681974E+00, 2.3038033308E+01, 3.7859757358E+00, 9.7896373304E-01],
	[4.8440000000E+04, 4.2508362115E+01, 5.0711140455E+00, 2.3045776101E+01, 3.7862723314E+00, 9.7897143749E-01],
	[4.8445000000E+04, 4.2516175248E+01, 5.0711598893E+00, 2.3053520696E+01, 3.7865688609E+00, 9.7897913871E-01],
	[4.8450000000E+04, 4.2523989011E+01, 5.0712057288E+00, 2.3061267093E+01, 3.7868653245E+00, 9.7898683670E-01],
	[4.8455000000E+04, 4.2531803403E+01, 5.0712515639E+00, 2.3069015292E+01, 3.7871617220E+00, 9.7899453146E-01],
	[4.8460000000E+04, 4.2539618424E+01, 5.0712973947E+00, 2.3076765294E+01, 3.7874580535E+00, 9.7900222298E-01],
	[4.8465000000E+04, 4.2547434075E+01, 5.0713432213E+00, 2.3084517097E+01, 3.7877543190E+00, 9.7900991128E-01],
	[4.8470000000E+04, 4.2555250356E+01, 5.0713890435E+00, 2.3092270704E+01, 3.7880505186E+00, 9.7901759635E-01],
	[4.8475000000E+04, 4.2563067266E+01, 5.0714348613E+00, 2.3100026114E+01, 3.7883466522E+00, 9.7902527819E-01],
	[4.8480000000E+04, 4.2570884805E+01, 5.0714806749E+00, 2.3107783327E+01, 3.7886427199E+00, 9.7903295680E-01],
	[4.8485000000E+04, 4.2578702973E+01, 5.0715264842E+00, 2.3115542344E+01, 3.7889387217E+00, 9.7904063220E-01],
	[4.8490000000E+04, 4.2586521771E+01, 5.0715722891E+00, 2.3123303164E+01, 3.7892346576E+00, 9.7904830437E-01],
	[4.8495000000E+04, 4.2594341199E+01, 5.0716180898E+00, 2.3131065788E+01, 3.7895305276E+00, 9.7905597332E-01],
	[4.8500000000E+04, 4.2602161256E+01, 5.0716638861E+00, 2.3138830217E+01, 3.7898263317E+00, 9.7906363906E-01],
	[4.8505000000E+04, 4.2609981942E+01, 5.0717096781E+00, 2.3146596450E+01, 3.7901220700E+00, 9.7907130157E-01],
	[4.8510000000E+04, 4.2617803257E+01, 5.0717554659E+00, 2.3154364487E+01, 3.7904177425E+00, 9.7907896088E-01],
	[4.8515000000E+04, 4.2625625202E+01, 5.0718012493E+00, 2.3162134330E+01, 3.7907133491E+00, 9.7908661696E-01],
	[4.8520000000E+04, 4.2633447776E+01, 5.0718470284E+00, 2.3169905978E+01, 3.7910088899E+00, 9.7909426984E-01],
	[4.8525000000E+04, 4.2641270979E+01, 5.0718928032E+00, 2.3177679431E+01, 3.7913043649E+00, 9.7910191950E-01],
	[4.8530000000E+04, 4.2649094812E+01, 5.0719385737E+00, 2.3185454689E+01, 3.7915997741E+00, 9.7910956596E-01],
	[4.8535000000E+04, 4.2656919274E+01, 5.0719843399E+00, 2.3193231754E+01, 3.7918951176E+00, 9.7911720920E-01],
	[4.8540000000E+04, 4.2664744365E+01, 5.0720301018E+00, 2.3201010625E+01, 3.7921903953E+00, 9.7912484924E-01],
	[4.8545000000E+04, 4.2672570085E+01, 5.0720758594E+00, 2.3208791301E+01, 3.7924856073E+00, 9.7913248608E-01],
	[4.8550000000E+04, 4.2680396434E+01, 5.0721216127E+00, 2.3216573785E+01, 3.7927807536E+00, 9.7914011971E-01],
	[4.8555000000E+04, 4.2688223413E+01, 5.0721673617E+00, 2.3224358075E+01, 3.7930758342E+00, 9.7914775014E-01],
	[4.8560000000E+04, 4.2696051021E+01, 5.0722131064E+00, 2.3232144172E+01, 3.7933708491E+00, 9.7915537737E-01],
	[4.8565000000E+04, 4.2703879258E+01, 5.0722588468E+00, 2.3239932077E+01, 3.7936657983E+00, 9.7916300140E-01],
	[4.8570000000E+04, 4.2711708124E+01, 5.0723045829E+00, 2.3247721789E+01, 3.7939606819E+00, 9.7917062223E-01],
	[4.8575000000E+04, 4.2719537620E+01, 5.0723503147E+00, 2.3255513309E+01, 3.7942554998E+00, 9.7917823987E-01],
	[4.8580000000E+04, 4.2727367744E+01, 5.0723960422E+00, 2.3263306636E+01, 3.7945502522E+00, 9.7918585431E-01],
	[4.8585000000E+04, 4.2735198498E+01, 5.0724417655E+00, 2.3271101772E+01, 3.7948449389E+00, 9.7919346557E-01],
	[4.8590000000E+04, 4.2743029881E+01, 5.0724874844E+00, 2.3278898716E+01, 3.7951395600E+00, 9.7920107362E-01],
	[4.8595000000E+04, 4.2750861892E+01, 5.0725331990E+00, 2.3286697469E+01, 3.7954341155E+00, 9.7920867849E-01],
	[4.8600000000E+04, 4.2758694533E+01, 5.0725789094E+00, 2.3294498031E+01, 3.7957286055E+00, 9.7921628018E-01],
	[4.8605000000E+04, 4.2766527803E+01, 5.0726246154E+00, 2.3302300402E+01, 3.7960230299E+00, 9.7922387867E-01],
	[4.8610000000E+04, 4.2774361702E+01, 5.0726703172E+00, 2.3310104582E+01, 3.7963173888E+00, 9.7923147398E-01],
	[4.8615000000E+04, 4.2782196230E+01, 5.0727160147E+00, 2.3317910571E+01, 3.7966116822E+00, 9.7923906610E-01],
	[4.8620000000E+04, 4.2790031387E+01, 5.0727617079E+00, 2.3325718371E+01, 3.7969059101E+00, 9.7924665505E-01],
	[4.8625000000E+04, 4.2797867173E+01, 5.0728073968E+00, 2.3333527980E+01, 3.7972000725E+00, 9.7925424081E-01],
	[4.8630000000E+04, 4.2805703588E+01, 5.0728530814E+00, 2.3341339400E+01, 3.7974941695E+00, 9.7926182339E-01],
	[4.8635000000E+04, 4.2813540632E+01, 5.0728987617E+00, 2.3349152631E+01, 3.7977882010E+00, 9.7926940280E-01],
	[4.8640000000E+04, 4.2821378305E+01, 5.0729444378E+00, 2.3356967672E+01, 3.7980821670E+00, 9.7927697903E-01],
	[4.8645000000E+04, 4.2829216607E+01, 5.0729901095E+00, 2.3364784524E+01, 3.7983760676E+00, 9.7928455208E-01],
	[4.8650000000E+04, 4.2837055538E+01, 5.0730357770E+00, 2.3372603187E+01, 3.7986699028E+00, 9.7929212197E-01],
	[4.8655000000E+04, 4.2844895098E+01, 5.0730814402E+00, 2.3380423662E+01, 3.7989636727E+00, 9.7929968867E-01],
	[4.8660000000E+04, 4.2852735286E+01, 5.0731270991E+00, 2.3388245948E+01, 3.7992573771E+00, 9.7930725221E-01],
	[4.8665000000E+04, 4.2860576104E+01, 5.0731727538E+00, 2.3396070046E+01, 3.7995510162E+00, 9.7931481259E-01],
	[4.8670000000E+04, 4.2868417550E+01, 5.0732184041E+00, 2.3403895957E+01, 3.7998445899E+00, 9.7932236979E-01],
	[4.8675000000E+04, 4.2876259626E+01, 5.0732640502E+00, 2.3411723680E+01, 3.8001380983E+00, 9.7932992383E-01],
	[4.8680000000E+04, 4.2884102330E+01, 5.0733096920E+00, 2.3419553215E+01, 3.8004315414E+00, 9.7933747470E-01],
	[4.8685000000E+04, 4.2891945663E+01, 5.0733553295E+00, 2.3427384563E+01, 3.8007249192E+00, 9.7934502241E-01],
	[4.8690000000E+04, 4.2899789624E+01, 5.0734009627E+00, 2.3435217724E+01, 3.8010182318E+00, 9.7935256696E-01],
	[4.8695000000E+04, 4.2907634215E+01, 5.0734465917E+00, 2.3443052699E+01, 3.8013114790E+00, 9.7936010835E-01],
	[4.8700000000E+04, 4.2915479434E+01, 5.0734922164E+00, 2.3450889487E+01, 3.8016046610E+00, 9.7936764658E-01],
	[4.8705000000E+04, 4.2923325282E+01, 5.0735378368E+00, 2.3458728089E+01, 3.8018977777E+00, 9.7937518166E-01],
	[4.8710000000E+04, 4.2931171759E+01, 5.0735834530E+00, 2.3466568505E+01, 3.8021908293E+00, 9.7938271358E-01],
	[4.8715000000E+04, 4.2939018865E+01, 5.0736290649E+00, 2.3474410735E+01, 3.8024838156E+00, 9.7939024235E-01],
	[4.8720000000E+04, 4.2946866599E+01, 5.0736746725E+00, 2.3482254780E+01, 3.8027767367E+00, 9.7939776796E-01],
	[4.8725000000E+04, 4.2954714962E+01, 5.0737202758E+00, 2.3490100639E+01, 3.8030695927E+00, 9.7940529042E-01],
	[4.8730000000E+04, 4.2962563954E+01, 5.0737658749E+00, 2.3497948313E+01, 3.8033623835E+00, 9.7941280974E-01],
	[4.8735000000E+04, 4.2970413575E+01, 5.0738114697E+00, 2.3505797802E+01, 3.8036551091E+00, 9.7942032590E-01],
	[4.8740000000E+04, 4.2978263824E+01, 5.0738570602E+00, 2.3513649107E+01, 3.8039477697E+00, 9.7942783892E-01],
	[4.8745000000E+04, 4.2986114701E+01, 5.0739026464E+00, 2.3521502228E+01, 3.8042403651E+00, 9.7943534880E-01],
	[4.8750000000E+04, 4.2993966208E+01, 5.0739482284E+00, 2.3529357164E+01, 3.8045328954E+00, 9.7944285553E-01],
	[4.8755000000E+04, 4.3001818343E+01, 5.0739938062E+00, 2.3537213916E+01, 3.8048253606E+00, 9.7945035912E-01],
	[4.8760000000E+04, 4.3009671107E+01, 5.0740393796E+00, 2.3545072485E+01, 3.8051177607E+00, 9.7945785957E-01],
	[4.8765000000E+04, 4.3017524499E+01, 5.0740849488E+00, 2.3552932870E+01, 3.8054100958E+00, 9.7946535688E-01],
	[4.8770000000E+04, 4.3025378520E+01, 5.0741305138E+00, 2.3560795072E+01, 3.8057023659E+00, 9.7947285106E-01],
	[4.8775000000E+04, 4.3033233169E+01, 5.0741760744E+00, 2.3568659091E+01, 3.8059945709E+00, 9.7948034210E-01],
	[4.8780000000E+04, 4.3041088447E+01, 5.0742216309E+00, 2.3576524928E+01, 3.8062867110E+00, 9.7948783000E-01],
	[4.8785000000E+04, 4.3048944354E+01, 5.0742671830E+00, 2.3584392582E+01, 3.8065787860E+00, 9.7949531477E-01],
	[4.8790000000E+04, 4.3056800889E+01, 5.0743127309E+00, 2.3592262053E+01, 3.8068707961E+00, 9.7950279641E-01],
	[4.8795000000E+04, 4.3064658053E+01, 5.0743582745E+00, 2.3600133343E+01, 3.8071627412E+00, 9.7951027492E-01],
	[4.8800000000E+04, 4.3072515845E+01, 5.0744038139E+00, 2.3608006451E+01, 3.8074546213E+00, 9.7951775031E-01],
	[4.8805000000E+04, 4.3080374265E+01, 5.0744493490E+00, 2.3615881377E+01, 3.8077464366E+00, 9.7952522256E-01],
	[4.8810000000E+04, 4.3088233315E+01, 5.0744948799E+00, 2.3623758122E+01, 3.8080381869E+00, 9.7953269169E-01],
	[4.8815000000E+04, 4.3096092992E+01, 5.0745404065E+00, 2.3631636686E+01, 3.8083298723E+00, 9.7954015770E-01],
	[4.8820000000E+04, 4.3103953298E+01, 5.0745859289E+00, 2.3639517068E+01, 3.8086214928E+00, 9.7954762058E-01],
	[4.8825000000E+04, 4.3111814233E+01, 5.0746314470E+00, 2.3647399271E+01, 3.8089130485E+00, 9.7955508034E-01],
	[4.8830000000E+04, 4.3119675795E+01, 5.0746769608E+00, 2.3655283293E+01, 3.8092045393E+00, 9.7956253699E-01],
	[4.8835000000E+04, 4.3127537987E+01, 5.0747224704E+00, 2.3663169134E+01, 3.8094959652E+00, 9.7956999051E-01],
	[4.8840000000E+04, 4.3135400806E+01, 5.0747679758E+00, 2.3671056796E+01, 3.8097873264E+00, 9.7957744092E-01],
	[4.8845000000E+04, 4.3143264254E+01, 5.0748134768E+00, 2.3678946278E+01, 3.8100786227E+00, 9.7958488821E-01],
	[4.8850000000E+04, 4.3151128331E+01, 5.0748589737E+00, 2.3686837581E+01, 3.8103698542E+00, 9.7959233239E-01],
	[4.8855000000E+04, 4.3158993036E+01, 5.0749044663E+00, 2.3694730704E+01, 3.8106610210E+00, 9.7959977346E-01],
	[4.8860000000E+04, 4.3166858369E+01, 5.0749499546E+00, 2.3702625648E+01, 3.8109521230E+00, 9.7960721142E-01],
	[4.8865000000E+04, 4.3174724330E+01, 5.0749954387E+00, 2.3710522414E+01, 3.8112431603E+00, 9.7961464627E-01],
	[4.8870000000E+04, 4.3182590920E+01, 5.0750409186E+00, 2.3718421001E+01, 3.8115341328E+00, 9.7962207801E-01],
	[4.8875000000E+04, 4.3190458138E+01, 5.0750863942E+00, 2.3726321410E+01, 3.8118250406E+00, 9.7962950665E-01],
	[4.8880000000E+04, 4.3198325984E+01, 5.0751318656E+00, 2.3734223641E+01, 3.8121158837E+00, 9.7963693218E-01],
	[4.8885000000E+04, 4.3206194459E+01, 5.0751773327E+00, 2.3742127693E+01, 3.8124066621E+00, 9.7964435461E-01],
	[4.8890000000E+04, 4.3214063562E+01, 5.0752227956E+00, 2.3750033569E+01, 3.8126973759E+00, 9.7965177393E-01],
	[4.8895000000E+04, 4.3221933293E+01, 5.0752682542E+00, 2.3757941267E+01, 3.8129880250E+00, 9.7965919016E-01],
	[4.8900000000E+04, 4.3229803652E+01, 5.0753137086E+00, 2.3765850787E+01, 3.8132786095E+00, 9.7966660328E-01],
	[4.8905000000E+04, 4.3237674639E+01, 5.0753591587E+00, 2.3773762131E+01, 3.8135691293E+00, 9.7967401331E-01],
	[4.8910000000E+04, 4.3245546255E+01, 5.0754046047E+00, 2.3781675298E+01, 3.8138595845E+00, 9.7968142025E-01],
	[4.8915000000E+04, 4.3253418499E+01, 5.0754500463E+00, 2.3789590289E+01, 3.8141499752E+00, 9.7968882409E-01],
	[4.8920000000E+04, 4.3261291371E+01, 5.0754954838E+00, 2.3797507104E+01, 3.8144403012E+00, 9.7969622484E-01],
	[4.8925000000E+04, 4.3269164871E+01, 5.0755409170E+00, 2.3805425742E+01, 3.8147305627E+00, 9.7970362249E-01],
	[4.8930000000E+04, 4.3277038999E+01, 5.0755863459E+00, 2.3813346205E+01, 3.8150207597E+00, 9.7971101706E-01],
	[4.8935000000E+04, 4.3284913756E+01, 5.0756317707E+00, 2.3821268493E+01, 3.8153108921E+00, 9.7971840854E-01],
	[4.8940000000E+04, 4.3292789140E+01, 5.0756771912E+00, 2.3829192605E+01, 3.8156009600E+00, 9.7972579693E-01],
	[4.8945000000E+04, 4.3300665153E+01, 5.0757226074E+00, 2.3837118542E+01, 3.8158909634E+00, 9.7973318223E-01],
	[4.8950000000E+04, 4.3308541794E+01, 5.0757680195E+00, 2.3845046304E+01, 3.8161809023E+00, 9.7974056445E-01],
	[4.8955000000E+04, 4.3316419063E+01, 5.0758134272E+00, 2.3852975892E+01, 3.8164707767E+00, 9.7974794359E-01],
	[4.8960000000E+04, 4.3324296959E+01, 5.0758588308E+00, 2.3860907305E+01, 3.8167605867E+00, 9.7975531965E-01],
	[4.8965000000E+04, 4.3332175484E+01, 5.0759042301E+00, 2.3868840544E+01, 3.8170503323E+00, 9.7976269263E-01],
	[4.8970000000E+04, 4.3340054637E+01, 5.0759496253E+00, 2.3876775610E+01, 3.8173400134E+00, 9.7977006253E-01],
	[4.8975000000E+04, 4.3347934418E+01, 5.0759950161E+00, 2.3884712501E+01, 3.8176296301E+00, 9.7977742936E-01],
	[4.8980000000E+04, 4.3355814827E+01, 5.0760404028E+00, 2.3892651220E+01, 3.8179191824E+00, 9.7978479310E-01],
	[4.8985000000E+04, 4.3363695864E+01, 5.0760857852E+00, 2.3900591765E+01, 3.8182086704E+00, 9.7979215378E-01],
	[4.8990000000E+04, 4.3371577529E+01, 5.0761311634E+00, 2.3908534137E+01, 3.8184980940E+00, 9.7979951138E-01],
	[4.8995000000E+04, 4.3379459822E+01, 5.0761765374E+00, 2.3916478337E+01, 3.8187874532E+00, 9.7980686592E-01],
	[4.9000000000E+04, 4.3387342743E+01, 5.0762219071E+00, 2.3924424364E+01, 3.8190767481E+00, 9.7981421738E-01],
	[4.9005000000E+04, 4.3395226291E+01, 5.0762672726E+00, 2.3932372219E+01, 3.8193659787E+00, 9.7982156577E-01],
	[4.9010000000E+04, 4.3403110468E+01, 5.0763126339E+00, 2.3940321902E+01, 3.8196551449E+00, 9.7982891110E-01],
	[4.9015000000E+04, 4.3410995272E+01, 5.0763579910E+00, 2.3948273413E+01, 3.8199442469E+00, 9.7983625337E-01],
	[4.9020000000E+04, 4.3418880705E+01, 5.0764033438E+00, 2.3956226752E+01, 3.8202332847E+00, 9.7984359257E-01],
	[4.9025000000E+04, 4.3426766765E+01, 5.0764486925E+00, 2.3964181921E+01, 3.8205222581E+00, 9.7985092871E-01],
	[4.9030000000E+04, 4.3434653453E+01, 5.0764940369E+00, 2.3972138918E+01, 3.8208111673E+00, 9.7985826179E-01],
	[4.9035000000E+04, 4.3442540769E+01, 5.0765393771E+00, 2.3980097744E+01, 3.8211000123E+00, 9.7986559181E-01],
	[4.9040000000E+04, 4.3450428713E+01, 5.0765847131E+00, 2.3988058400E+01, 3.8213887931E+00, 9.7987291877E-01],
	[4.9045000000E+04, 4.3458317285E+01, 5.0766300448E+00, 2.3996020885E+01, 3.8216775097E+00, 9.7988024268E-01],
	[4.9050000000E+04, 4.3466206484E+01, 5.0766753724E+00, 2.4003985201E+01, 3.8219661621E+00, 9.7988756353E-01],
	[4.9055000000E+04, 4.3474096311E+01, 5.0767206957E+00, 2.4011951346E+01, 3.8222547504E+00, 9.7989488133E-01],
	[4.9060000000E+04, 4.3481986766E+01, 5.0767660148E+00, 2.4019919322E+01, 3.8225432745E+00, 9.7990219607E-01],
	[4.9065000000E+04, 4.3489877849E+01, 5.0768113297E+00, 2.4027889128E+01, 3.8228317344E+00, 9.7990950777E-01],
	[4.9070000000E+04, 4.3497776679E+01, 5.0768574085E+00, 2.4035860765E+01, 3.8231206208E+00, 9.7991681642E-01],
	[4.9075000000E+04, 4.3505683978E+01, 5.0769043285E+00, 2.4043834233E+01, 3.8234099833E+00, 9.7992412202E-01],
	[4.9080000000E+04, 4.3513591909E+01, 5.0769512443E+00, 2.4051809533E+01, 3.8236992819E+00, 9.7993142457E-01],
	[4.9085000000E+04, 4.3521500471E+01, 5.0769981556E+00, 2.4059786664E+01, 3.8239885165E+00, 9.7993872409E-01],
	[4.9090000000E+04, 4.3529409665E+01, 5.0770450627E+00, 2.4067765626E+01, 3.8242776872E+00, 9.7994602055E-01],
	[4.9095000000E+04, 4.3537319490E+01, 5.0770919654E+00, 2.4075746421E+01, 3.8245667941E+00, 9.7995331398E-01],
	[4.9100000000E+04, 4.3545229947E+01, 5.0771388637E+00, 2.4083729048E+01, 3.8248558370E+00, 9.7996060437E-01],
	[4.9105000000E+04, 4.3553141036E+01, 5.0771857577E+00, 2.4091713507E+01, 3.8251448161E+00, 9.7996789171E-01],
	[4.9110000000E+04, 4.3561052756E+01, 5.0772326474E+00, 2.4099699799E+01, 3.8254337313E+00, 9.7997517602E-01],
	[4.9115000000E+04, 4.3568965108E+01, 5.0772795327E+00, 2.4107687924E+01, 3.8257225827E+00, 9.7998245730E-01],
	[4.9120000000E+04, 4.3576878091E+01, 5.0773264137E+00, 2.4115677882E+01, 3.8260113703E+00, 9.7998973554E-01],
	[4.9125000000E+04, 4.3584791706E+01, 5.0773732903E+00, 2.4123669673E+01, 3.8263000941E+00, 9.7999701075E-01],
	[4.9130000000E+04, 4.3592705952E+01, 5.0774201626E+00, 2.4131663298E+01, 3.8265887541E+00, 9.8000428293E-01],
	[4.9135000000E+04, 4.3600620830E+01, 5.0774670306E+00, 2.4139658757E+01, 3.8268773503E+00, 9.8001155207E-01],
	[4.9140000000E+04, 4.3608536339E+01, 5.0775138942E+00, 2.4147656050E+01, 3.8271658828E+00, 9.8001881819E-01],
	[4.9145000000E+04, 4.3616452479E+01, 5.0775607535E+00, 2.4155655177E+01, 3.8274543515E+00, 9.8002608128E-01],
	[4.9150000000E+04, 4.3624369251E+01, 5.0776076085E+00, 2.4163656139E+01, 3.8277427565E+00, 9.8003334135E-01],
	[4.9155000000E+04, 4.3632286655E+01, 5.0776544591E+00, 2.4171658936E+01, 3.8280310977E+00, 9.8004059839E-01],
	[4.9160000000E+04, 4.3640204689E+01, 5.0777013054E+00, 2.4179663567E+01, 3.8283193753E+00, 9.8004785241E-01],
	[4.9165000000E+04, 4.3648123356E+01, 5.0777481474E+00, 2.4187670034E+01, 3.8286075892E+00, 9.8005510341E-01],
	[4.9170000000E+04, 4.3656042653E+01, 5.0777949850E+00, 2.4195678336E+01, 3.8288957394E+00, 9.8006235139E-01],
	[4.9175000000E+04, 4.3663962582E+01, 5.0778418183E+00, 2.4203688474E+01, 3.8291838260E+00, 9.8006959635E-01],
	[4.9180000000E+04, 4.3671883142E+01, 5.0778886473E+00, 2.4211700448E+01, 3.8294718489E+00, 9.8007683830E-01],
	[4.9185000000E+04, 4.3679804334E+01, 5.0779354719E+00, 2.4219714258E+01, 3.8297598082E+00, 9.8008407722E-01],
	[4.9190000000E+04, 4.3687726157E+01, 5.0779822922E+00, 2.4227729905E+01, 3.8300477039E+00, 9.8009131314E-01],
	[4.9195000000E+04, 4.3695648611E+01, 5.0780291082E+00, 2.4235747388E+01, 3.8303355360E+00, 9.8009854604E-01],
	[4.9200000000E+04, 4.3703571697E+01, 5.0780759199E+00, 2.4243766708E+01, 3.8306233046E+00, 9.8010577593E-01],
	[4.9205000000E+04, 4.3711495414E+01, 5.0781227272E+00, 2.4251787865E+01, 3.8309110096E+00, 9.8011300282E-01],
	[4.9210000000E+04, 4.3719419762E+01, 5.0781695302E+00, 2.4259810860E+01, 3.8311986510E+00, 9.8012022669E-01],
	[4.9215000000E+04, 4.3727344741E+01, 5.0782163289E+00, 2.4267835692E+01, 3.8314862289E+00, 9.8012744756E-01],
	[4.9220000000E+04, 4.3735270352E+01, 5.0782631232E+00, 2.4275862362E+01, 3.8317737433E+00, 9.8013466542E-01],
	[4.9225000000E+04, 4.3743196593E+01, 5.0783099133E+00, 2.4283890870E+01, 3.8320611941E+00, 9.8014188028E-01],
	[4.9230000000E+04, 4.3751123466E+01, 5.0783566990E+00, 2.4291921216E+01, 3.8323485815E+00, 9.8014909213E-01],
	[4.9235000000E+04, 4.3759050971E+01, 5.0784034804E+00, 2.4299953401E+01, 3.8326359055E+00, 9.8015630099E-01],
	[4.9240000000E+04, 4.3766979106E+01, 5.0784502575E+00, 2.4307987424E+01, 3.8329231659E+00, 9.8016350685E-01],
	[4.9245000000E+04, 4.3774907872E+01, 5.0784970302E+00, 2.4316023287E+01, 3.8332103630E+00, 9.8017070970E-01],
	[4.9250000000E+04, 4.3782837270E+01, 5.0785437987E+00, 2.4324060988E+01, 3.8334974966E+00, 9.8017790956E-01],
	[4.9255000000E+04, 4.3790767299E+01, 5.0785905628E+00, 2.4332100529E+01, 3.8337845668E+00, 9.8018510643E-01],
	[4.9260000000E+04, 4.3798697959E+01, 5.0786373226E+00, 2.4340141910E+01, 3.8340715736E+00, 9.8019230030E-01],
	[4.9265000000E+04, 4.3806629250E+01, 5.0786840781E+00, 2.4348185131E+01, 3.8343585170E+00, 9.8019949118E-01],
	[4.9270000000E+04, 4.3814561172E+01, 5.0787308293E+00, 2.4356230192E+01, 3.8346453970E+00, 9.8020667907E-01],
	[4.9275000000E+04, 4.3822493725E+01, 5.0787775761E+00, 2.4364277093E+01, 3.8349322137E+00, 9.8021386397E-01],
	[4.9280000000E+04, 4.3830426910E+01, 5.0788243187E+00, 2.4372325835E+01, 3.8352189671E+00, 9.8022104589E-01],
	[4.9285000000E+04, 4.3838360725E+01, 5.0788710569E+00, 2.4380376418E+01, 3.8355056571E+00, 9.8022822481E-01],
	[4.9290000000E+04, 4.3846295172E+01, 5.0789177908E+00, 2.4388428842E+01, 3.8357922839E+00, 9.8023540075E-01],
	[4.9295000000E+04, 4.3854230249E+01, 5.0789645205E+00, 2.4396483107E+01, 3.8360788473E+00, 9.8024257371E-01],
	[4.9300000000E+04, 4.3862165958E+01, 5.0790112458E+00, 2.4404539214E+01, 3.8363653475E+00, 9.8024974369E-01],
	[4.9305000000E+04, 4.3870102297E+01, 5.0790579668E+00, 2.4412597162E+01, 3.8366517844E+00, 9.8025691068E-01],
	[4.9310000000E+04, 4.3878039268E+01, 5.0791046835E+00, 2.4420656953E+01, 3.8369381581E+00, 9.8026407470E-01],
	[4.9315000000E+04, 4.3885976869E+01, 5.0791513958E+00, 2.4428718586E+01, 3.8372244686E+00, 9.8027123573E-01],
	[4.9320000000E+04, 4.3893915101E+01, 5.0791981039E+00, 2.4436782061E+01, 3.8375107158E+00, 9.8027839379E-01],
	[4.9325000000E+04, 4.3901853965E+01, 5.0792448077E+00, 2.4444847379E+01, 3.8377968998E+00, 9.8028554888E-01],
	[4.9330000000E+04, 4.3909793459E+01, 5.0792915072E+00, 2.4452914540E+01, 3.8380830207E+00, 9.8029270099E-01],
	[4.9335000000E+04, 4.3917733584E+01, 5.0793382023E+00, 2.4460983544E+01, 3.8383690784E+00, 9.8029985013E-01],
	[4.9340000000E+04, 4.3925674340E+01, 5.0793848932E+00, 2.4469054392E+01, 3.8386550729E+00, 9.8030699630E-01],
	[4.9345000000E+04, 4.3933615727E+01, 5.0794315797E+00, 2.4477127083E+01, 3.8389410043E+00, 9.8031413950E-01],
	[4.9350000000E+04, 4.3941557745E+01, 5.0794782620E+00, 2.4485201618E+01, 3.8392268726E+00, 9.8032127973E-01],
	[4.9355000000E+04, 4.3949500394E+01, 5.0795249399E+00, 2.4493277998E+01, 3.8395126777E+00, 9.8032841700E-01],
	[4.9360000000E+04, 4.3957443674E+01, 5.0795716136E+00, 2.4501356221E+01, 3.8397984198E+00, 9.8033555130E-01],
	[4.9365000000E+04, 4.3965387584E+01, 5.0796182830E+00, 2.4509436290E+01, 3.8400840988E+00, 9.8034268264E-01],
	[4.9370000000E+04, 4.3973332125E+01, 5.0796649480E+00, 2.4517518203E+01, 3.8403697147E+00, 9.8034981101E-01],
	[4.9375000000E+04, 4.3981277297E+01, 5.0797116088E+00, 2.4525601961E+01, 3.8406552676E+00, 9.8035693643E-01],
	[4.9380000000E+04, 4.3989223100E+01, 5.0797582652E+00, 2.4533687564E+01, 3.8409407574E+00, 9.8036405888E-01],
	[4.9385000000E+04, 4.3997169534E+01, 5.0798049174E+00, 2.4541775013E+01, 3.8412261843E+00, 9.8037117838E-01],
	[4.9390000000E+04, 4.4005116598E+01, 5.0798515653E+00, 2.4549864308E+01, 3.8415115481E+00, 9.8037829492E-01],
	[4.9395000000E+04, 4.4013064293E+01, 5.0798982089E+00, 2.4557955449E+01, 3.8417968489E+00, 9.8038540851E-01],
	[4.9400000000E+04, 4.4021012619E+01, 5.0799448481E+00, 2.4566048436E+01, 3.8420820868E+00, 9.8039251914E-01],
	[4.9405000000E+04, 4.4028961576E+01, 5.0799914831E+00, 2.4574143269E+01, 3.8423672617E+00, 9.8039962682E-01],
	[4.9410000000E+04, 4.4036911163E+01, 5.0800381138E+00, 2.4582239950E+01, 3.8426523737E+00, 9.8040673155E-01],
	[4.9415000000E+04, 4.4044861381E+01, 5.0800847403E+00, 2.4590338477E+01, 3.8429374227E+00, 9.8041383333E-01],
	[4.9420000000E+04, 4.4052812230E+01, 5.0801313624E+00, 2.4598438851E+01, 3.8432224089E+00, 9.8042093216E-01],
	[4.9425000000E+04, 4.4060763709E+01, 5.0801779802E+00, 2.4606541073E+01, 3.8435073321E+00, 9.8042802805E-01],
	[4.9430000000E+04, 4.4068715819E+01, 5.0802245938E+00, 2.4614645142E+01, 3.8437921924E+00, 9.8043512099E-01],
	[4.9435000000E+04, 4.4076668560E+01, 5.0802712030E+00, 2.4622751059E+01, 3.8440769899E+00, 9.8044221099E-01],
	[4.9440000000E+04, 4.4084621931E+01, 5.0803178080E+00, 2.4630858825E+01, 3.8443617246E+00, 9.8044929804E-01],
	[4.9445000000E+04, 4.4092575933E+01, 5.0803644087E+00, 2.4638968438E+01, 3.8446463963E+00, 9.8045638216E-01],
	[4.9450000000E+04, 4.4100530566E+01, 5.0804110051E+00, 2.4647079900E+01, 3.8449310053E+00, 9.8046346333E-01],
	[4.9455000000E+04, 4.4108485829E+01, 5.0804575972E+00, 2.4655193211E+01, 3.8452155515E+00, 9.8047054157E-01],
	[4.9460000000E+04, 4.4116441723E+01, 5.0805041850E+00, 2.4663308372E+01, 3.8455000349E+00, 9.8047761687E-01],
	[4.9465000000E+04, 4.4124398247E+01, 5.0805507686E+00, 2.4671425381E+01, 3.8457844555E+00, 9.8048468923E-01],
	[4.9470000000E+04, 4.4132355402E+01, 5.0805973479E+00, 2.4679544240E+01, 3.8460688133E+00, 9.8049175867E-01],
	[4.9475000000E+04, 4.4140313187E+01, 5.0806439229E+00, 2.4687664948E+01, 3.8463531084E+00, 9.8049882517E-01],
	[4.9480000000E+04, 4.4148271603E+01, 5.0806904936E+00, 2.4695787507E+01, 3.8466373408E+00, 9.8050588873E-01],
	[4.9485000000E+04, 4.4156230649E+01, 5.0807370600E+00, 2.4703911916E+01, 3.8469215104E+00, 9.8051294937E-01],
	[4.9490000000E+04, 4.4164190326E+01, 5.0807836222E+00, 2.4712038175E+01, 3.8472056173E+00, 9.8052000708E-01],
	[4.9495000000E+04, 4.4172150633E+01, 5.0808301800E+00, 2.4720166285E+01, 3.8474896616E+00, 9.8052706187E-01],
	[4.9500000000E+04, 4.4180111571E+01, 5.0808767336E+00, 2.4728296246E+01, 3.8477736432E+00, 9.8053411373E-01],
	[4.9505000000E+04, 4.4188073139E+01, 5.0809232830E+00, 2.4736428058E+01, 3.8480575621E+00, 9.8054116266E-01],
	[4.9510000000E+04, 4.4196035338E+01, 5.0809698280E+00, 2.4744561721E+01, 3.8483414184E+00, 9.8054820868E-01],
	[4.9515000000E+04, 4.4203998167E+01, 5.0810163688E+00, 2.4752697236E+01, 3.8486252121E+00, 9.8055525177E-01],
	[4.9520000000E+04, 4.4211961627E+01, 5.0810629053E+00, 2.4760834603E+01, 3.8489089431E+00, 9.8056229194E-01],
	[4.9525000000E+04, 4.4219925717E+01, 5.0811094375E+00, 2.4768973822E+01, 3.8491926116E+00, 9.8056932919E-01],
	[4.9530000000E+04, 4.4227890437E+01, 5.0811559655E+00, 2.4777114893E+01, 3.8494762174E+00, 9.8057636353E-01],
	[4.9535000000E+04, 4.4235855787E+01, 5.0812024892E+00, 2.4785257817E+01, 3.8497597608E+00, 9.8058339495E-01],
	[4.9540000000E+04, 4.4243821768E+01, 5.0812490086E+00, 2.4793402594E+01, 3.8500432415E+00, 9.8059042346E-01],
	[4.9545000000E+04, 4.4251788380E+01, 5.0812955238E+00, 2.4801549223E+01, 3.8503266597E+00, 9.8059744906E-01],
	[4.9550000000E+04, 4.4259755621E+01, 5.0813420346E+00, 2.4809697706E+01, 3.8506100154E+00, 9.8060447174E-01],
	[4.9555000000E+04, 4.4267723493E+01, 5.0813885412E+00, 2.4817848043E+01, 3.8508933086E+00, 9.8061149152E-01],
	[4.9560000000E+04, 4.4275691996E+01, 5.0814350436E+00, 2.4826000233E+01, 3.8511765393E+00, 9.8061850838E-01],
	[4.9565000000E+04, 4.4283661128E+01, 5.0814815417E+00, 2.4834154277E+01, 3.8514597076E+00, 9.8062552234E-01],
	[4.9570000000E+04, 4.4291630891E+01, 5.0815280355E+00, 2.4842310175E+01, 3.8517428133E+00, 9.8063253340E-01],
	[4.9575000000E+04, 4.4299601284E+01, 5.0815745250E+00, 2.4850467928E+01, 3.8520258567E+00, 9.8063954155E-01],
	[4.9580000000E+04, 4.4307572308E+01, 5.0816210103E+00, 2.4858627535E+01, 3.8523088375E+00, 9.8064654679E-01],
	[4.9585000000E+04, 4.4315543961E+01, 5.0816674914E+00, 2.4866788997E+01, 3.8525917560E+00, 9.8065354914E-01],
	[4.9590000000E+04, 4.4323516245E+01, 5.0817139681E+00, 2.4874952315E+01, 3.8528746121E+00, 9.8066054858E-01],
	[4.9595000000E+04, 4.4331489159E+01, 5.0817604406E+00, 2.4883117488E+01, 3.8531574058E+00, 9.8066754513E-01],
	[4.9600000000E+04, 4.4339462703E+01, 5.0818069089E+00, 2.4891284516E+01, 3.8534401371E+00, 9.8067453878E-01],
	[4.9605000000E+04, 4.4347436878E+01, 5.0818533729E+00, 2.4899453400E+01, 3.8537228061E+00, 9.8068152954E-01],
	[4.9610000000E+04, 4.4355411682E+01, 5.0818998326E+00, 2.4907624140E+01, 3.8540054127E+00, 9.8068851740E-01],
	[4.9615000000E+04, 4.4363387117E+01, 5.0819462881E+00, 2.4915796737E+01, 3.8542879570E+00, 9.8069550237E-01],
	[4.9620000000E+04, 4.4371363181E+01, 5.0819927393E+00, 2.4923971190E+01, 3.8545704390E+00, 9.8070248444E-01],
	[4.9625000000E+04, 4.4379339876E+01, 5.0820391862E+00, 2.4932147500E+01, 3.8548528587E+00, 9.8070946363E-01],
	[4.9630000000E+04, 4.4387317201E+01, 5.0820856289E+00, 2.4940325667E+01, 3.8551352161E+00, 9.8071643993E-01],
	[4.9635000000E+04, 4.4395295157E+01, 5.0821320674E+00, 2.4948505691E+01, 3.8554175112E+00, 9.8072341334E-01],
	[4.9640000000E+04, 4.4403273742E+01, 5.0821785016E+00, 2.4956687572E+01, 3.8556997441E+00, 9.8073038386E-01],
	[4.9645000000E+04, 4.4411252957E+01, 5.0822249315E+00, 2.4964871312E+01, 3.8559819148E+00, 9.8073735150E-01],
	[4.9650000000E+04, 4.4419232802E+01, 5.0822713572E+00, 2.4973056909E+01, 3.8562640232E+00, 9.8074431626E-01],
	[4.9655000000E+04, 4.4427213278E+01, 5.0823177786E+00, 2.4981244364E+01, 3.8565460695E+00, 9.8075127813E-01],
	[4.9660000000E+04, 4.4435194383E+01, 5.0823641958E+00, 2.4989433678E+01, 3.8568280535E+00, 9.8075823713E-01],
	[4.9665000000E+04, 4.4443176118E+01, 5.0824106088E+00, 2.4997624851E+01, 3.8571099754E+00, 9.8076519324E-01],
	[4.9670000000E+04, 4.4451158484E+01, 5.0824570175E+00, 2.5005817882E+01, 3.8573918351E+00, 9.8077214648E-01],
	[4.9675000000E+04, 4.4459141479E+01, 5.0825034219E+00, 2.5014012772E+01, 3.8576736326E+00, 9.8077909684E-01],
	[4.9680000000E+04, 4.4467125105E+01, 5.0825498221E+00, 2.5022209522E+01, 3.8579553681E+00, 9.8078604433E-01],
	[4.9685000000E+04, 4.4475109360E+01, 5.0825962180E+00, 2.5030408131E+01, 3.8582370414E+00, 9.8079298894E-01],
	[4.9690000000E+04, 4.4483094245E+01, 5.0826426097E+00, 2.5038608601E+01, 3.8585186526E+00, 9.8079993069E-01],
	[4.9695000000E+04, 4.4491079760E+01, 5.0826889972E+00, 2.5046810930E+01, 3.8588002017E+00, 9.8080686956E-01],
	[4.9700000000E+04, 4.4499065905E+01, 5.0827353804E+00, 2.5055015119E+01, 3.8590816888E+00, 9.8081380556E-01],
	[4.9705000000E+04, 4.4507052680E+01, 5.0827817594E+00, 2.5063221169E+01, 3.8593631138E+00, 9.8082073869E-01],
	[4.9710000000E+04, 4.4515040085E+01, 5.0828281341E+00, 2.5071429080E+01, 3.8596444767E+00, 9.8082766896E-01],
	[4.9715000000E+04, 4.4523028120E+01, 5.0828745046E+00, 2.5079638852E+01, 3.8599257777E+00, 9.8083459637E-01],
	[4.9720000000E+04, 4.4531016785E+01, 5.0829208709E+00, 2.5087850485E+01, 3.8602070166E+00, 9.8084152091E-01],
	[4.9725000000E+04, 4.4539006079E+01, 5.0829672329E+00, 2.5096063980E+01, 3.8604881935E+00, 9.8084844258E-01],
	[4.9730000000E+04, 4.4546996003E+01, 5.0830135906E+00, 2.5104279336E+01, 3.8607693085E+00, 9.8085536140E-01],
	[4.9735000000E+04, 4.4554986557E+01, 5.0830599442E+00, 2.5112496554E+01, 3.8610503615E+00, 9.8086227736E-01],
	[4.9740000000E+04, 4.4562977741E+01, 5.0831062935E+00, 2.5120715634E+01, 3.8613313525E+00, 9.8086919046E-01],
	[4.9745000000E+04, 4.4570969555E+01, 5.0831526385E+00, 2.5128936577E+01, 3.8616122816E+00, 9.8087610070E-01],
	[4.9750000000E+04, 4.4578961999E+01, 5.0831989793E+00, 2.5137159382E+01, 3.8618931487E+00, 9.8088300809E-01],
	[4.9755000000E+04, 4.4586955072E+01, 5.0832453159E+00, 2.5145384050E+01, 3.8621739540E+00, 9.8088991262E-01],
	[4.9760000000E+04, 4.4594948775E+01, 5.0832916483E+00, 2.5153610581E+01, 3.8624546974E+00, 9.8089681430E-01],
	[4.9765000000E+04, 4.4602943108E+01, 5.0833379764E+00, 2.5161838976E+01, 3.8627353789E+00, 9.8090371313E-01],
	[4.9770000000E+04, 4.4610938070E+01, 5.0833843003E+00, 2.5170069234E+01, 3.8630159985E+00, 9.8091060911E-01],
	[4.9775000000E+04, 4.4618933662E+01, 5.0834306200E+00, 2.5178301356E+01, 3.8632965563E+00, 9.8091750224E-01],
	[4.9780000000E+04, 4.4626929884E+01, 5.0834769354E+00, 2.5186535342E+01, 3.8635770523E+00, 9.8092439252E-01],
	[4.9785000000E+04, 4.4634926736E+01, 5.0835232466E+00, 2.5194771192E+01, 3.8638574864E+00, 9.8093127996E-01],
	[4.9790000000E+04, 4.4642924217E+01, 5.0835695536E+00, 2.5203008907E+01, 3.8641378588E+00, 9.8093816456E-01],
	[4.9795000000E+04, 4.4650922328E+01, 5.0836158563E+00, 2.5211248486E+01, 3.8644181693E+00, 9.8094504631E-01],
	[4.9800000000E+04, 4.4658921068E+01, 5.0836621548E+00, 2.5219489931E+01, 3.8646984181E+00, 9.8095192522E-01],
	[4.9805000000E+04, 4.4666920438E+01, 5.0837084491E+00, 2.5227733240E+01, 3.8649786051E+00, 9.8095880129E-01],
	[4.9810000000E+04, 4.4674920438E+01, 5.0837547392E+00, 2.5235978416E+01, 3.8652587304E+00, 9.8096567452E-01],
	[4.9815000000E+04, 4.4682921067E+01, 5.0838010250E+00, 2.5244225456E+01, 3.8655387940E+00, 9.8097254491E-01],
	[4.9820000000E+04, 4.4690922326E+01, 5.0838473066E+00, 2.5252474363E+01, 3.8658187958E+00, 9.8097941247E-01],
	[4.9825000000E+04, 4.4698924215E+01, 5.0838935840E+00, 2.5260725136E+01, 3.8660987359E+00, 9.8098627720E-01],
	[4.9830000000E+04, 4.4706926733E+01, 5.0839398571E+00, 2.5268977775E+01, 3.8663786144E+00, 9.8099313909E-01],
	[4.9835000000E+04, 4.4714929881E+01, 5.0839861261E+00, 2.5277232281E+01, 3.8666584312E+00, 9.8099999814E-01],
	[4.9840000000E+04, 4.4722933658E+01, 5.0840323908E+00, 2.5285488654E+01, 3.8669381864E+00, 9.8100685437E-01],
	[4.9845000000E+04, 4.4730938064E+01, 5.0840786513E+00, 2.5293746893E+01, 3.8672178799E+00, 9.8101370777E-01],
	[4.9850000000E+04, 4.4738943101E+01, 5.0841249076E+00, 2.5302007000E+01, 3.8674975118E+00, 9.8102055834E-01],
	[4.9855000000E+04, 4.4746948766E+01, 5.0841711597E+00, 2.5310268975E+01, 3.8677770820E+00, 9.8102740609E-01],
	[4.9860000000E+04, 4.4754962406E+01, 5.0842181840E+00, 2.5318532817E+01, 3.8680570950E+00, 9.8103425101E-01],
	[4.9865000000E+04, 4.4762984274E+01, 5.0842660072E+00, 2.5326798528E+01, 3.8683375681E+00, 9.8104109310E-01],
	[4.9870000000E+04, 4.4771006776E+01, 5.0843138260E+00, 2.5335066107E+01, 3.8686179798E+00, 9.8104793238E-01],
	[4.9875000000E+04, 4.4779029910E+01, 5.0843616404E+00, 2.5343335554E+01, 3.8688983301E+00, 9.8105476883E-01],
	[4.9880000000E+04, 4.4787053678E+01, 5.0844094505E+00, 2.5351606870E+01, 3.8691786190E+00, 9.8106160246E-01],
	[4.9885000000E+04, 4.4795078080E+01, 5.0844572563E+00, 2.5359880055E+01, 3.8694588464E+00, 9.8106843328E-01],
	[4.9890000000E+04, 4.4803103114E+01, 5.0845050577E+00, 2.5368155109E+01, 3.8697390126E+00, 9.8107526128E-01],
	[4.9895000000E+04, 4.4811128782E+01, 5.0845528547E+00, 2.5376432032E+01, 3.8700191173E+00, 9.8108208646E-01],
	[4.9900000000E+04, 4.4819155083E+01, 5.0846006475E+00, 2.5384710825E+01, 3.8702991608E+00, 9.8108890883E-01],
	[4.9905000000E+04, 4.4827182017E+01, 5.0846484359E+00, 2.5392991488E+01, 3.8705791429E+00, 9.8109572839E-01],
	[4.9910000000E+04, 4.4835209584E+01, 5.0846962199E+00, 2.5401274022E+01, 3.8708590637E+00, 9.8110254513E-01],
	[4.9915000000E+04, 4.4843237785E+01, 5.0847439996E+00, 2.5409558425E+01, 3.8711389232E+00, 9.8110935907E-01],
	[4.9920000000E+04, 4.4851266619E+01, 5.0847917750E+00, 2.5417844699E+01, 3.8714187214E+00, 9.8111617019E-01],
	[4.9925000000E+04, 4.4859296085E+01, 5.0848395461E+00, 2.5426132844E+01, 3.8716984584E+00, 9.8112297851E-01],
	[4.9930000000E+04, 4.4867326185E+01, 5.0848873128E+00, 2.5434422860E+01, 3.8719781341E+00, 9.8112978403E-01],
	[4.9935000000E+04, 4.4875356919E+01, 5.0849350751E+00, 2.5442714748E+01, 3.8722577486E+00, 9.8113658674E-01],
	[4.9940000000E+04, 4.4883388285E+01, 5.0849828332E+00, 2.5451008507E+01, 3.8725373019E+00, 9.8114338664E-01],
	[4.9945000000E+04, 4.4891420284E+01, 5.0850305869E+00, 2.5459304137E+01, 3.8728167940E+00, 9.8115018375E-01],
	[4.9950000000E+04, 4.4899452916E+01, 5.0850783363E+00, 2.5467601640E+01, 3.8730962249E+00, 9.8115697805E-01],
	[4.9955000000E+04, 4.4907486182E+01, 5.0851260813E+00, 2.5475901015E+01, 3.8733755946E+00, 9.8116376956E-01],
	[4.9960000000E+04, 4.4915520081E+01, 5.0851738220E+00, 2.5484202262E+01, 3.8736549031E+00, 9.8117055826E-01],
	[4.9965000000E+04, 4.4923554612E+01, 5.0852215584E+00, 2.5492505382E+01, 3.8739341505E+00, 9.8117734418E-01],
	[4.9970000000E+04, 4.4931589777E+01, 5.0852692904E+00, 2.5500810375E+01, 3.8742133368E+00, 9.8118412729E-01],
	[4.9975000000E+04, 4.4939625574E+01, 5.0853170182E+00, 2.5509117242E+01, 3.8744924620E+00, 9.8119090761E-01],
	[4.9980000000E+04, 4.4947662005E+01, 5.0853647416E+00, 2.5517425981E+01, 3.8747715260E+00, 9.8119768514E-01],
	[4.9985000000E+04, 4.4955699069E+01, 5.0854124606E+00, 2.5525736595E+01, 3.8750505290E+00, 9.8120445988E-01],
	[4.9990000000E+04, 4.4963736765E+01, 5.0854601754E+00, 2.5534049082E+01, 3.8753294709E+00, 9.8121123183E-01],
	[4.9995000000E+04, 4.4971775095E+01, 5.0855078858E+00, 2.5542363443E+01, 3.8756083517E+00, 9.8121800100E-01],
	[5.0000000000E+04, 4.4979814058E+01, 5.0855555919E+00, 2.5550679679E+01, 3.8758871715E+00, 9.8122476737E-01],
	[5.0005000000E+04, 4.4987853653E+01, 5.0856032937E+00, 2.5559010473E+01, 3.8761662220E+00, 9.8123153096E-01],
	[5.0010000000E+04, 4.4995893881E+01, 5.0856509912E+00, 2.5567343149E+01, 3.8764452114E+00, 9.8123829177E-01],
	[5.0015000000E+04, 4.5003934743E+01, 5.0856986843E+00, 2.5575677707E+01, 3.8767241396E+00, 9.8124504979E-01],
	[5.0020000000E+04, 4.5011976237E+01, 5.0857463731E+00, 2.5584014147E+01, 3.8770030067E+00, 9.8125180503E-01],
	[5.0025000000E+04, 4.50200183