import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

adipose_ICRP110_MFP = np.array([
	[5.0000000000E+03, 2.5898159840E+00, 7.6108081130E+00, 4.1123972213E-02, 4.0266991005E-02, 3.4008429339E-01],
	[5.0050000000E+03, 2.5927758533E+00, 7.6080957358E+00, 4.1250148495E-02, 4.0388598202E-02, 3.4033769907E-01],
	[5.0100000000E+03, 2.5957361449E+00, 7.6053870321E+00, 4.1376585092E-02, 4.0510445695E-02, 3.4059089159E-01],
	[5.0150000000E+03, 2.5986968584E+00, 7.6026819933E+00, 4.1503282278E-02, 4.0632533691E-02, 3.4084387155E-01],
	[5.0200000000E+03, 2.6016579935E+00, 7.5999806108E+00, 4.1630240330E-02, 4.0754862397E-02, 3.4109663956E-01],
	[5.0250000000E+03, 2.6046195498E+00, 7.5972828760E+00, 4.1757459523E-02, 4.0877432018E-02, 3.4134919623E-01],
	[5.0300000000E+03, 2.6075815269E+00, 7.5945887803E+00, 4.1884940134E-02, 4.1000242762E-02, 3.4160154215E-01],
	[5.0350000000E+03, 2.6105439246E+00, 7.5918983153E+00, 4.2012682437E-02, 4.1123294833E-02, 3.4185367794E-01],
	[5.0400000000E+03, 2.6135067423E+00, 7.5892114724E+00, 4.2140686708E-02, 4.1246588438E-02, 3.4210560418E-01],
	[5.0450000000E+03, 2.6164699799E+00, 7.5865282432E+00, 4.2268953224E-02, 4.1370123783E-02, 3.4235732147E-01],
	[5.0500000000E+03, 2.6194336369E+00, 7.5838486193E+00, 4.2397482260E-02, 4.1493901074E-02, 3.4260883041E-01],
	[5.0550000000E+03, 2.6223977129E+00, 7.5811725921E+00, 4.2526274091E-02, 4.1617920515E-02, 3.4286013165E-01],
	[5.0600000000E+03, 2.6253622077E+00, 7.5785001535E+00, 4.2655328994E-02, 4.1742182312E-02, 3.4311122587E-01],
	[5.0650000000E+03, 2.6283271208E+00, 7.5758312949E+00, 4.2784647244E-02, 4.1866686670E-02, 3.4336211369E-01],
	[5.0700000000E+03, 2.6312924520E+00, 7.5731660082E+00, 4.2914229117E-02, 4.1991433794E-02, 3.4361279576E-01],
	[5.0750000000E+03, 2.6342582008E+00, 7.5705042849E+00, 4.3044074889E-02, 4.2116423889E-02, 3.4386327269E-01],
	[5.0800000000E+03, 2.6372243668E+00, 7.5678461169E+00, 4.3174184835E-02, 4.2241657159E-02, 3.4411354511E-01],
	[5.0850000000E+03, 2.6402041758E+00, 7.5652252460E+00, 4.3304559232E-02, 4.2367138273E-02, 3.4436361364E-01],
	[5.0900000000E+03, 2.6431857027E+00, 7.5626111304E+00, 4.3435198356E-02, 4.2492863448E-02, 3.4461347891E-01],
	[5.0950000000E+03, 2.6461676643E+00, 7.5600004834E+00, 4.3566102482E-02, 4.2618832458E-02, 3.4486314153E-01],
	[5.1000000000E+03, 2.6491500601E+00, 7.5573932971E+00, 4.3697271886E-02, 4.2745045505E-02, 3.4511260211E-01],
	[5.1050000000E+03, 2.6521328899E+00, 7.5547895633E+00, 4.3828706844E-02, 4.2871502796E-02, 3.4536186127E-01],
	[5.1100000000E+03, 2.6551161532E+00, 7.5521892742E+00, 4.3960407632E-02, 4.2998204532E-02, 3.4561091963E-01],
	[5.1150000000E+03, 2.6580998497E+00, 7.5495924219E+00, 4.4092374525E-02, 4.3125150919E-02, 3.4585977779E-01],
	[5.1200000000E+03, 2.6610839791E+00, 7.5469989984E+00, 4.4224607801E-02, 4.3252342159E-02, 3.4610843636E-01],
	[5.1250000000E+03, 2.6640685409E+00, 7.5444089959E+00, 4.4357107735E-02, 4.3379778456E-02, 3.4635689595E-01],
	[5.1300000000E+03, 2.6670535349E+00, 7.5418224066E+00, 4.4489874602E-02, 4.3507460014E-02, 3.4660515716E-01],
	[5.1350000000E+03, 2.6700389606E+00, 7.5392392226E+00, 4.4622908679E-02, 4.3635387034E-02, 3.4685322059E-01],
	[5.1400000000E+03, 2.6730248177E+00, 7.5366594361E+00, 4.4756210242E-02, 4.3763559721E-02, 3.4710108684E-01],
	[5.1450000000E+03, 2.6760111058E+00, 7.5340830394E+00, 4.4889779567E-02, 4.3891978277E-02, 3.4734875651E-01],
	[5.1500000000E+03, 2.6789978247E+00, 7.5315100247E+00, 4.5023616929E-02, 4.4020642904E-02, 3.4759623020E-01],
	[5.1550000000E+03, 2.6819849739E+00, 7.5289403843E+00, 4.5157722605E-02, 4.4149553805E-02, 3.4784350851E-01],
	[5.1600000000E+03, 2.6849725530E+00, 7.5263741106E+00, 4.5292096872E-02, 4.4278711183E-02, 3.4809059201E-01],
	[5.1650000000E+03, 2.6879683100E+00, 7.5238309385E+00, 4.5426740004E-02, 4.4408118041E-02, 3.4833748131E-01],
	[5.1700000000E+03, 2.6909707508E+00, 7.5213069740E+00, 4.5561652278E-02, 4.4537774073E-02, 3.4858417699E-01],
	[5.1750000000E+03, 2.6939736382E+00, 7.5187862946E+00, 4.5696833971E-02, 4.4667677233E-02, 3.4883067964E-01],
	[5.1800000000E+03, 2.6969769717E+00, 7.5162688931E+00, 4.5832285358E-02, 4.4797827724E-02, 3.4907698984E-01],
	[5.1850000000E+03, 2.6999807510E+00, 7.5137547620E+00, 4.5968006715E-02, 4.4928225747E-02, 3.4932310818E-01],
	[5.1900000000E+03, 2.7029849757E+00, 7.5112438939E+00, 4.6103998319E-02, 4.5058871504E-02, 3.4956903523E-01],
	[5.1950000000E+03, 2.7059896455E+00, 7.5087362815E+00, 4.6240260445E-02, 4.5189765196E-02, 3.4981477158E-01],
	[5.2000000000E+03, 2.7089947600E+00, 7.5062319173E+00, 4.6376793371E-02, 4.5320907023E-02, 3.5006031780E-01],
	[5.2050000000E+03, 2.7120003189E+00, 7.5037307940E+00, 4.6513597372E-02, 4.5452297188E-02, 3.5030567447E-01],
	[5.2100000000E+03, 2.7150063217E+00, 7.5012329044E+00, 4.6650672723E-02, 4.5583935891E-02, 3.5055084217E-01],
	[5.2150000000E+03, 2.7180127682E+00, 7.4987382412E+00, 4.6788019703E-02, 4.5715823332E-02, 3.5079582145E-01],
	[5.2200000000E+03, 2.7210196580E+00, 7.4962467971E+00, 4.6925638586E-02, 4.5847959713E-02, 3.5104061290E-01],
	[5.2250000000E+03, 2.7240269906E+00, 7.4937585649E+00, 4.7063529649E-02, 4.5980345233E-02, 3.5128521709E-01],
	[5.2300000000E+03, 2.7270347658E+00, 7.4912735374E+00, 4.7201693169E-02, 4.6112980092E-02, 3.5152963457E-01],
	[5.2350000000E+03, 2.7300429832E+00, 7.4887917074E+00, 4.7340129421E-02, 4.6245864491E-02, 3.5177386591E-01],
	[5.2400000000E+03, 2.7330516425E+00, 7.4863130677E+00, 4.7478838681E-02, 4.6378998629E-02, 3.5201791168E-01],
	[5.2450000000E+03, 2.7360607432E+00, 7.4838376112E+00, 4.7617821227E-02, 4.6512382707E-02, 3.5226177244E-01],
	[5.2500000000E+03, 2.7390828546E+00, 7.4813973167E+00, 4.7757077335E-02, 4.6646021811E-02, 3.5250544874E-01],
	[5.2550000000E+03, 2.7421063270E+00, 7.4789624384E+00, 4.7896607280E-02, 4.6779911651E-02, 3.5274894115E-01],
	[5.2600000000E+03, 2.7451302567E+00, 7.4765306670E+00, 4.8036411339E-02, 4.6914052075E-02, 3.5299225021E-01],
	[5.2650000000E+03, 2.7481546432E+00, 7.4741019957E+00, 4.8176489788E-02, 4.7048443284E-02, 3.5323537650E-01],
	[5.2700000000E+03, 2.7511794863E+00, 7.4716764175E+00, 4.8316842905E-02, 4.7183085475E-02, 3.5347832055E-01],
	[5.2750000000E+03, 2.7542047855E+00, 7.4692539256E+00, 4.8457470964E-02, 4.7317978848E-02, 3.5372108291E-01],
	[5.2800000000E+03, 2.7572305404E+00, 7.4668345132E+00, 4.8598374243E-02, 4.7453123601E-02, 3.5396366415E-01],
	[5.2850000000E+03, 2.7602567508E+00, 7.4644181733E+00, 4.8739553018E-02, 4.7588519934E-02, 3.5420606480E-01],
	[5.2900000000E+03, 2.7632834163E+00, 7.4620048992E+00, 4.8881007566E-02, 4.7724168044E-02, 3.5444828541E-01],
	[5.2950000000E+03, 2.7663105364E+00, 7.4595946841E+00, 4.9022738162E-02, 4.7860068129E-02, 3.5469032653E-01],
	[5.3000000000E+03, 2.7693381109E+00, 7.4571875213E+00, 4.9164745084E-02, 4.7996220388E-02, 3.5493218869E-01],
	[5.3050000000E+03, 2.7723661393E+00, 7.4547834040E+00, 4.9307028608E-02, 4.8132625019E-02, 3.5517387244E-01],
	[5.3100000000E+03, 2.7753946214E+00, 7.4523823255E+00, 4.9449589009E-02, 4.8269282219E-02, 3.5541537833E-01],
	[5.3150000000E+03, 2.7784235567E+00, 7.4499842791E+00, 4.9592426566E-02, 4.8406192185E-02, 3.5565670687E-01],
	[5.3200000000E+03, 2.7814529449E+00, 7.4475892582E+00, 4.9735541554E-02, 4.8543355115E-02, 3.5589785862E-01],
	[5.3250000000E+03, 2.7844827856E+00, 7.4451972560E+00, 4.9878934249E-02, 4.8680771207E-02, 3.5613883411E-01],
	[5.3300000000E+03, 2.7875136527E+00, 7.4428097298E+00, 5.0022604929E-02, 4.8818440895E-02, 3.5637963393E-01],
	[5.3350000000E+03, 2.7905573518E+00, 7.4404567244E+00, 5.0166553870E-02, 4.8956369316E-02, 3.5662025863E-01],
	[5.3400000000E+03, 2.7936015184E+00, 7.4381066660E+00, 5.0310781348E-02, 4.9094551536E-02, 3.5686070877E-01],
	[5.3450000000E+03, 2.7966461522E+00, 7.4357595483E+00, 5.0455287640E-02, 4.9232987753E-02, 3.5710098489E-01],
	[5.3500000000E+03, 2.7996912528E+00, 7.4334153648E+00, 5.0600073022E-02, 4.9371678163E-02, 3.5734108754E-01],
	[5.3550000000E+03, 2.8027368198E+00, 7.4310741091E+00, 5.0745137772E-02, 4.9510622962E-02, 3.5758101725E-01],
	[5.3600000000E+03, 2.8057828529E+00, 7.4287357747E+00, 5.0890482166E-02, 4.9649822347E-02, 3.5782077458E-01],
	[5.3650000000E+03, 2.8088293516E+00, 7.4264003554E+00, 5.1036106480E-02, 4.9789276514E-02, 3.5806036006E-01],
	[5.3700000000E+03, 2.8118763157E+00, 7.4240678448E+00, 5.1182010991E-02, 4.9928985659E-02, 3.5829977422E-01],
	[5.3750000000E+03, 2.8149237447E+00, 7.4217382366E+00, 5.1328195976E-02, 5.0068949977E-02, 3.5853901761E-01],
	[5.3800000000E+03, 2.8179716384E+00, 7.4194115245E+00, 5.1474661711E-02, 5.0209169663E-02, 3.5877809076E-01],
	[5.3850000000E+03, 2.8210199963E+00, 7.4170877021E+00, 5.1621408474E-02, 5.0349644914E-02, 3.5901699420E-01],
	[5.3900000000E+03, 2.8240688181E+00, 7.4147667632E+00, 5.1768436540E-02, 5.0490375924E-02, 3.5925572847E-01],
	[5.3950000000E+03, 2.8271181034E+00, 7.4124487016E+00, 5.1915746186E-02, 5.0631362888E-02, 3.5949429408E-01],
	[5.4000000000E+03, 2.8301678519E+00, 7.4101335110E+00, 5.2063337690E-02, 5.0772606001E-02, 3.5973269158E-01],
	[5.4050000000E+03, 2.8332180632E+00, 7.4078211852E+00, 5.2211211328E-02, 5.0914105457E-02, 3.5997092149E-01],
	[5.4100000000E+03, 2.8362687370E+00, 7.4055117181E+00, 5.2359367377E-02, 5.1055861452E-02, 3.6020898433E-01],
	[5.4150000000E+03, 2.8393198728E+00, 7.4032051034E+00, 5.2507806113E-02, 5.1197874179E-02, 3.6044688063E-01],
	[5.4200000000E+03, 2.8423824580E+00, 7.4009293759E+00, 5.2656527813E-02, 5.1340148766E-02, 3.6068461091E-01],
	[5.4250000000E+03, 2.8454469620E+00, 7.3986601251E+00, 5.2805532754E-02, 5.1482681168E-02, 3.6092217568E-01],
	[5.4300000000E+03, 2.8485119422E+00, 7.3963936596E+00, 5.2954821213E-02, 5.1625470933E-02, 3.6115957548E-01],
	[5.4350000000E+03, 2.8515773983E+00, 7.3941299735E+00, 5.3104393467E-02, 5.1768518256E-02, 3.6139681081E-01],
	[5.4400000000E+03, 2.8546433301E+00, 7.3918690608E+00, 5.3254249792E-02, 5.1911823329E-02, 3.6163388219E-01],
	[5.4450000000E+03, 2.8577097370E+00, 7.3896109155E+00, 5.3404390466E-02, 5.2055386346E-02, 3.6187079013E-01],
	[5.4500000000E+03, 2.8607766188E+00, 7.3873555318E+00, 5.3554815765E-02, 5.2199207501E-02, 3.6210753516E-01],
	[5.4550000000E+03, 2.8638439750E+00, 7.3851029037E+00, 5.3705525966E-02, 5.2343286986E-02, 3.6234411778E-01],
	[5.4600000000E+03, 2.8669118053E+00, 7.3828530254E+00, 5.3856521346E-02, 5.2487624995E-02, 3.6258053849E-01],
	[5.4650000000E+03, 2.8699801094E+00, 7.3806058909E+00, 5.4007802181E-02, 5.2632221720E-02, 3.6281679782E-01],
	[5.4700000000E+03, 2.8730488869E+00, 7.3783614945E+00, 5.4159368750E-02, 5.2777077354E-02, 3.6305289626E-01],
	[5.4750000000E+03, 2.8761181374E+00, 7.3761198302E+00, 5.4311221328E-02, 5.2922192089E-02, 3.6328883432E-01],
	[5.4800000000E+03, 2.8791878606E+00, 7.3738808923E+00, 5.4463739842E-02, 5.3067926557E-02, 3.6352461251E-01],
	[5.4850000000E+03, 2.8822580561E+00, 7.3716446750E+00, 5.4616853098E-02, 5.3214212984E-02, 3.6376023133E-01],
	[5.4900000000E+03, 2.8853287236E+00, 7.3694111725E+00, 5.4770256469E-02, 5.3360762054E-02, 3.6399569127E-01],
	[5.4950000000E+03, 2.8883998626E+00, 7.3671803790E+00, 5.4923950240E-02, 5.3507573965E-02, 3.6423099285E-01],
	[5.5000000000E+03, 2.8914714729E+00, 7.3649522887E+00, 5.5077934694E-02, 5.3654648913E-02, 3.6446613655E-01],
	[5.5050000000E+03, 2.8945488776E+00, 7.3627405423E+00, 5.5232210116E-02, 5.3801989663E-02, 3.6470112288E-01],
	[5.5100000000E+03, 2.8976333431E+00, 7.3605483213E+00, 5.5386776789E-02, 5.3949597054E-02, 3.6493595232E-01],
	[5.5150000000E+03, 2.9007182934E+00, 7.3583587406E+00, 5.5541634998E-02, 5.4097468122E-02, 3.6517062538E-01],
	[5.5200000000E+03, 2.9038037279E+00, 7.3561717945E+00, 5.5696785027E-02, 5.4245603063E-02, 3.6540514255E-01],
	[5.5250000000E+03, 2.9068896464E+00, 7.3539874776E+00, 5.5852227159E-02, 5.4394002074E-02, 3.6563950432E-01],
	[5.5300000000E+03, 2.9099760485E+00, 7.3518057842E+00, 5.6007961680E-02, 5.4542665351E-02, 3.6587371118E-01],
	[5.5350000000E+03, 2.9130629338E+00, 7.3496267089E+00, 5.6163988873E-02, 5.4691593089E-02, 3.6610776362E-01],
	[5.5400000000E+03, 2.9161503019E+00, 7.3474502462E+00, 5.6320309022E-02, 5.4840785485E-02, 3.6634166212E-01],
	[5.5450000000E+03, 2.9192381526E+00, 7.3452763906E+00, 5.6476922413E-02, 5.4990242734E-02, 3.6657540717E-01],
	[5.5500000000E+03, 2.9223264853E+00, 7.3431051366E+00, 5.6633829328E-02, 5.5139965030E-02, 3.6680899926E-01],
	[5.5550000000E+03, 2.9254152999E+00, 7.3409364787E+00, 5.6791030052E-02, 5.5289952570E-02, 3.6704243887E-01],
	[5.5600000000E+03, 2.9285045959E+00, 7.3387704116E+00, 5.6948524870E-02, 5.5440205549E-02, 3.6727572648E-01],
	[5.5650000000E+03, 2.9315943729E+00, 7.3366069297E+00, 5.7106314066E-02, 5.5590724160E-02, 3.6750886258E-01],
	[5.5700000000E+03, 2.9346846307E+00, 7.3344460278E+00, 5.7264397923E-02, 5.5741508599E-02, 3.6774184764E-01],
	[5.5750000000E+03, 2.9377753688E+00, 7.3322877004E+00, 5.7422776727E-02, 5.5892559060E-02, 3.6797468213E-01],
	[5.5800000000E+03, 2.9408665869E+00, 7.3301319421E+00, 5.7581450762E-02, 5.6043875737E-02, 3.6820736655E-01],
	[5.5850000000E+03, 2.9439582846E+00, 7.3279787475E+00, 5.7740420311E-02, 5.6195458824E-02, 3.6843990136E-01],
	[5.5900000000E+03, 2.9470504616E+00, 7.3258281115E+00, 5.7899685660E-02, 5.6347308515E-02, 3.6867228704E-01],
	[5.5950000000E+03, 2.9501514224E+00, 7.3237014309E+00, 5.8059247093E-02, 5.6499429323E-02, 3.6890452406E-01],
	[5.6000000000E+03, 2.9532559481E+00, 7.3215851840E+00, 5.8219104894E-02, 5.6651818766E-02, 3.6913661290E-01],
	[5.6050000000E+03, 2.9563609658E+00, 7.3194714363E+00, 5.8379259348E-02, 5.6804475444E-02, 3.6936855401E-01],
	[5.6100000000E+03, 2.9594664750E+00, 7.3173601829E+00, 5.8539710739E-02, 5.6957399551E-02, 3.6960034789E-01],
	[5.6150000000E+03, 2.9625724755E+00, 7.3152514184E+00, 5.8700459351E-02, 5.7110591280E-02, 3.6983199498E-01],
	[5.6200000000E+03, 2.9656789668E+00, 7.3131451379E+00, 5.8861505469E-02, 5.7264050823E-02, 3.7006349576E-01],
	[5.6250000000E+03, 2.9687859486E+00, 7.3110413360E+00, 5.9022849378E-02, 5.7417778374E-02, 3.7029485070E-01],
	[5.6300000000E+03, 2.9718934205E+00, 7.3089400078E+00, 5.9184491362E-02, 5.7571774126E-02, 3.7052606026E-01],
	[5.6350000000E+03, 2.9750013823E+00, 7.3068411481E+00, 5.9346431705E-02, 5.7726038270E-02, 3.7075712490E-01],
	[5.6400000000E+03, 2.9781098334E+00, 7.3047447518E+00, 5.9508670692E-02, 5.7880570999E-02, 3.7098804509E-01],
	[5.6450000000E+03, 2.9812187737E+00, 7.3026508139E+00, 5.9671208608E-02, 5.8035372505E-02, 3.7121882128E-01],
	[5.6500000000E+03, 2.9843282026E+00, 7.3005593293E+00, 5.9834045737E-02, 5.8190442979E-02, 3.7144945394E-01],
	[5.6550000000E+03, 2.9874381199E+00, 7.2984702929E+00, 5.9997182364E-02, 5.8345782613E-02, 3.7167994352E-01],
	[5.6600000000E+03, 2.9905485253E+00, 7.2963836998E+00, 6.0160618774E-02, 5.8501391600E-02, 3.7191029049E-01],
	[5.6650000000E+03, 2.9936594182E+00, 7.2942995449E+00, 6.0324355250E-02, 5.8657270129E-02, 3.7214049529E-01],
	[5.6700000000E+03, 2.9967707985E+00, 7.2922178232E+00, 6.0488392078E-02, 5.8813418393E-02, 3.7237055839E-01],
	[5.6750000000E+03, 2.9998826657E+00, 7.2901385298E+00, 6.0652729543E-02, 5.8969836581E-02, 3.7260048024E-01],
	[5.6800000000E+03, 3.0029950195E+00, 7.2880616597E+00, 6.0817367928E-02, 5.9126524885E-02, 3.7283026128E-01],
	[5.6850000000E+03, 3.0061157503E+00, 7.2860077021E+00, 6.0982307520E-02, 5.9283487920E-02, 3.7305990199E-01],
	[5.6900000000E+03, 3.0092399383E+00, 7.2839638113E+00, 6.1147548601E-02, 5.9440723157E-02, 3.7328940279E-01],
	[5.6950000000E+03, 3.0123646249E+00, 7.2819222882E+00, 6.1313091458E-02, 5.9598229133E-02, 3.7351876415E-01],
	[5.7000000000E+03, 3.0154898096E+00, 7.2798831283E+00, 6.1478936375E-02, 5.9756006036E-02, 3.7374798651E-01],
	[5.7050000000E+03, 3.0186154920E+00, 7.2778463265E+00, 6.1645083636E-02, 5.9914054058E-02, 3.7397707032E-01],
	[5.7100000000E+03, 3.0217416719E+00, 7.2758118782E+00, 6.1811533527E-02, 6.0072373388E-02, 3.7420601602E-01],
	[5.7150000000E+03, 3.0248683489E+00, 7.2737797785E+00, 6.1978286333E-02, 6.0230964217E-02, 3.7443482407E-01],
	[5.7200000000E+03, 3.0279955225E+00, 7.2717500228E+00, 6.2145342337E-02, 6.0389826732E-02, 3.7466349490E-01],
	[5.7250000000E+03, 3.0311231925E+00, 7.2697226061E+00, 6.2312701825E-02, 6.0548961124E-02, 3.7489202896E-01],
	[5.7300000000E+03, 3.0342513585E+00, 7.2676975240E+00, 6.2480365082E-02, 6.0708367581E-02, 3.7512042669E-01],
	[5.7350000000E+03, 3.0373800202E+00, 7.2656747715E+00, 6.2648332393E-02, 6.0868046293E-02, 3.7534868853E-01],
	[5.7400000000E+03, 3.0405091771E+00, 7.2636543439E+00, 6.2816604042E-02, 6.1027997447E-02, 3.7557681492E-01],
	[5.7450000000E+03, 3.0436388290E+00, 7.2616362367E+00, 6.2985180315E-02, 6.1188221233E-02, 3.7580480629E-01],
	[5.7500000000E+03, 3.0467689754E+00, 7.2596204451E+00, 6.3154061496E-02, 6.1348717838E-02, 3.7603266310E-01],
	[5.7550000000E+03, 3.0498996161E+00, 7.2576069644E+00, 6.3323247870E-02, 6.1509487451E-02, 3.7626038577E-01],
	[5.7600000000E+03, 3.0530307507E+00, 7.2555957901E+00, 6.3492739723E-02, 6.1670530260E-02, 3.7648797474E-01],
	[5.7650000000E+03, 3.0561623788E+00, 7.2535869173E+00, 6.3662537338E-02, 6.1831846452E-02, 3.7671543044E-01],
	[5.7700000000E+03, 3.0592945000E+00, 7.2515803416E+00, 6.3832641002E-02, 6.1993436214E-02, 3.7694275331E-01],
	[5.7750000000E+03, 3.0624316001E+00, 7.2495878324E+00, 6.4003050999E-02, 6.2155302447E-02, 3.7716994379E-01],
	[5.7800000000E+03, 3.0655750338E+00, 7.2476128917E+00, 6.4173767615E-02, 6.2317446191E-02, 3.7739700229E-01],
	[5.7850000000E+03, 3.0687189719E+00, 7.2456401960E+00, 6.4344791133E-02, 6.2479864119E-02, 3.7762392926E-01],
	[5.7900000000E+03, 3.0718634139E+00, 7.2436697408E+00, 6.4516121840E-02, 6.2642556418E-02, 3.7785072512E-01],
	[5.7950000000E+03, 3.0750083596E+00, 7.2417015217E+00, 6.4687760020E-02, 6.2805523275E-02, 3.7807739030E-01],
	[5.8000000000E+03, 3.0781538085E+00, 7.2397355341E+00, 6.4859705959E-02, 6.2968764876E-02, 3.7830392522E-01],
	[5.8050000000E+03, 3.0812997604E+00, 7.2377717737E+00, 6.5031959941E-02, 6.3132281408E-02, 3.7853033033E-01],
	[5.8100000000E+03, 3.0844462148E+00, 7.2358102360E+00, 6.5204522252E-02, 6.3296073057E-02, 3.7875660603E-01],
	[5.8150000000E+03, 3.0875931715E+00, 7.2338509165E+00, 6.5377393177E-02, 6.3460140009E-02, 3.7898275276E-01],
	[5.8200000000E+03, 3.0907406300E+00, 7.2318938109E+00, 6.5550573001E-02, 6.3624482449E-02, 3.7920877094E-01],
	[5.8250000000E+03, 3.0938885900E+00, 7.2299389147E+00, 6.5724062009E-02, 6.3789100563E-02, 3.7943466100E-01],
	[5.8300000000E+03, 3.0970370512E+00, 7.2279862236E+00, 6.5897860486E-02, 6.3953994537E-02, 3.7966042334E-01],
	[5.8350000000E+03, 3.1001860131E+00, 7.2260357332E+00, 6.6071968718E-02, 6.4119164556E-02, 3.7988605845E-01],
	[5.8400000000E+03, 3.1033354756E+00, 7.2240874391E+00, 6.6246386989E-02, 6.4284610804E-02, 3.8011156688E-01],
	[5.8450000000E+03, 3.1064854381E+00, 7.2221413370E+00, 6.6421115585E-02, 6.4450333466E-02, 3.8033694903E-01],
	[5.8500000000E+03, 3.1096359005E+00, 7.2201974225E+00, 6.6596154792E-02, 6.4616332728E-02, 3.8056220531E-01],
	[5.8550000000E+03, 3.1127868622E+00, 7.2182556913E+00, 6.6771504894E-02, 6.4782608772E-02, 3.8078733610E-01],
	[5.8600000000E+03, 3.1159383230E+00, 7.2163161391E+00, 6.6947166177E-02, 6.4949161784E-02, 3.8101234180E-01],
	[5.8650000000E+03, 3.1190902825E+00, 7.2143787616E+00, 6.7123138927E-02, 6.5115991948E-02, 3.8123722281E-01],
	[5.8700000000E+03, 3.1222510385E+00, 7.2124656013E+00, 6.7299423427E-02, 6.5283104881E-02, 3.8146197951E-01],
	[5.8750000000E+03, 3.1254137925E+00, 7.2105585312E+00, 6.7476019964E-02, 6.5450496357E-02, 3.8168661230E-01],
	[5.8800000000E+03, 3.1285770557E+00, 7.2086535870E+00, 6.7652928824E-02, 6.5618165587E-02, 3.8191112156E-01],
	[5.8850000000E+03, 3.1317408277E+00, 7.2067507646E+00, 6.7830150291E-02, 6.5786112757E-02, 3.8213550769E-01],
	[5.8900000000E+03, 3.1349051080E+00, 7.2048500599E+00, 6.8007684650E-02, 6.5954338048E-02, 3.8235977108E-01],
	[5.8950000000E+03, 3.1380698965E+00, 7.2029514686E+00, 6.8185532188E-02, 6.6122841644E-02, 3.8258391211E-01],
	[5.9000000000E+03, 3.1412351927E+00, 7.2010549866E+00, 6.8363693190E-02, 6.6291623727E-02, 3.8280793117E-01],
	[5.9050000000E+03, 3.1444009963E+00, 7.1991606099E+00, 6.8542167941E-02, 6.6460684481E-02, 3.8303182864E-01],
	[5.9100000000E+03, 3.1475673069E+00, 7.1972683342E+00, 6.8720956726E-02, 6.6630024087E-02, 3.8325560491E-01],
	[5.9150000000E+03, 3.1507341242E+00, 7.1953781555E+00, 6.8900059832E-02, 6.6799642729E-02, 3.8347926037E-01],
	[5.9200000000E+03, 3.1539014479E+00, 7.1934900697E+00, 6.9079477543E-02, 6.6969540587E-02, 3.8370279539E-01],
	[5.9250000000E+03, 3.1570692775E+00, 7.1916040727E+00, 6.9259210144E-02, 6.7139717843E-02, 3.8392621036E-01],
	[5.9300000000E+03, 3.1602376128E+00, 7.1897201604E+00, 6.9439257923E-02, 6.7310174680E-02, 3.8414950566E-01],
	[5.9350000000E+03, 3.1634064534E+00, 7.1878383288E+00, 6.9619621163E-02, 6.7480911278E-02, 3.8437268167E-01],
	[5.9400000000E+03, 3.1665757990E+00, 7.1859585739E+00, 6.9800300152E-02, 6.7651927820E-02, 3.8459573878E-01],
	[5.9450000000E+03, 3.1697456491E+00, 7.1840808915E+00, 6.9981295173E-02, 6.7823224485E-02, 3.8481867735E-01],
	[5.9500000000E+03, 3.1729160035E+00, 7.1822052777E+00, 7.0162606513E-02, 6.7994801454E-02, 3.8504149777E-01],
	[5.9550000000E+03, 3.1760868619E+00, 7.1803317284E+00, 7.0344234457E-02, 6.8166658909E-02, 3.8526420042E-01],
	[5.9600000000E+03, 3.1792582238E+00, 7.1784602397E+00, 7.0526179292E-02, 6.8338797029E-02, 3.8548678567E-01],
	[5.9650000000E+03, 3.1824389922E+00, 7.1766148166E+00, 7.0708441302E-02, 6.8511222310E-02, 3.8570925389E-01],
	[5.9700000000E+03, 3.1856206289E+00, 7.1747723700E+00, 7.0891020773E-02, 6.8683928920E-02, 3.8593160547E-01],
	[5.9750000000E+03, 3.1888027789E+00, 7.1729319382E+00, 7.1073917991E-02, 6.8856916789E-02, 3.8615384077E-01],
	[5.9800000000E+03, 3.1919854418E+00, 7.1710935173E+00, 7.1257133242E-02, 6.9030186097E-02, 3.8637596017E-01],
	[5.9850000000E+03, 3.1951686172E+00, 7.1692571035E+00, 7.1440666811E-02, 6.9203737023E-02, 3.8659796404E-01],
	[5.9900000000E+03, 3.1983523049E+00, 7.1674226930E+00, 7.1624518984E-02, 6.9377569747E-02, 3.8681985275E-01],
	[5.9950000000E+03, 3.2015365045E+00, 7.1655902819E+00, 7.1808690047E-02, 6.9551684448E-02, 3.8704162668E-01],
	[6.0000000000E+03, 3.2047212156E+00, 7.1637598663E+00, 7.1993180285E-02, 6.9726081305E-02, 3.8726328619E-01],
	[6.0050000000E+03, 3.2079064379E+00, 7.1619314423E+00, 7.2179139927E-02, 6.9901839023E-02, 3.8748483165E-01],
	[6.0100000000E+03, 3.2110921711E+00, 7.1601050063E+00, 7.2365424269E-02, 7.0077883630E-02, 3.8770626343E-01],
	[6.0150000000E+03, 3.2142784147E+00, 7.1582805543E+00, 7.2552033606E-02, 7.0254215314E-02, 3.8792758190E-01],
	[6.0200000000E+03, 3.2174651686E+00, 7.1564580826E+00, 7.2738968234E-02, 7.0430834258E-02, 3.8814878743E-01],
	[6.0250000000E+03, 3.2206524322E+00, 7.1546375874E+00, 7.2926228448E-02, 7.0607740648E-02, 3.8836988037E-01],
	[6.0300000000E+03, 3.2238402054E+00, 7.1528190648E+00, 7.3113814543E-02, 7.0784934667E-02, 3.8859086110E-01],
	[6.0350000000E+03, 3.2270284877E+00, 7.1510025111E+00, 7.3301726815E-02, 7.0962416501E-02, 3.8881172998E-01],
	[6.0400000000E+03, 3.2302172787E+00, 7.1491879227E+00, 7.3489965560E-02, 7.1140186333E-02, 3.8903248738E-01],
	[6.0450000000E+03, 3.2334065783E+00, 7.1473752956E+00, 7.3678531072E-02, 7.1318244348E-02, 3.8925313365E-01],
	[6.0500000000E+03, 3.2365963859E+00, 7.1455646262E+00, 7.3867423648E-02, 7.1496590729E-02, 3.8947366916E-01],
	[6.0550000000E+03, 3.2397867014E+00, 7.1437559107E+00, 7.4056643582E-02, 7.1675225659E-02, 3.8969409427E-01],
	[6.0600000000E+03, 3.2429843299E+00, 7.1419676321E+00, 7.4246191172E-02, 7.1854154535E-02, 3.8991440934E-01],
	[6.0650000000E+03, 3.2461844903E+00, 7.1401867479E+00, 7.4436066711E-02, 7.2033373919E-02, 3.9013461474E-01],
	[6.0700000000E+03, 3.2493851677E+00, 7.1384077748E+00, 7.4626270497E-02, 7.2212882456E-02, 3.9035471081E-01],
	[6.0750000000E+03, 3.2525863615E+00, 7.1366307091E+00, 7.4816802824E-02, 7.2392680330E-02, 3.9057469792E-01],
	[6.0800000000E+03, 3.2557880715E+00, 7.1348555474E+00, 7.5007663987E-02, 7.2572767723E-02, 3.9079457644E-01],
	[6.0850000000E+03, 3.2589902974E+00, 7.1330822858E+00, 7.5198854284E-02, 7.2753144818E-02, 3.9101434670E-01],
	[6.0900000000E+03, 3.2621930388E+00, 7.1313109209E+00, 7.5390374010E-02, 7.2933811796E-02, 3.9123400908E-01],
	[6.0950000000E+03, 3.2653962953E+00, 7.1295414491E+00, 7.5582223459E-02, 7.3114768841E-02, 3.9145356392E-01],
	[6.1000000000E+03, 3.2686000667E+00, 7.1277738668E+00, 7.5774402929E-02, 7.3296016134E-02, 3.9167301158E-01],
	[6.1050000000E+03, 3.2718043525E+00, 7.1260081704E+00, 7.5966912714E-02, 7.3477553855E-02, 3.9189235242E-01],
	[6.1100000000E+03, 3.2750091525E+00, 7.1242443564E+00, 7.6159753111E-02, 7.3659382188E-02, 3.9211158679E-01],
	[6.1150000000E+03, 3.2782144663E+00, 7.1224824212E+00, 7.6352924415E-02, 7.3841501313E-02, 3.9233071504E-01],
	[6.1200000000E+03, 3.2814202935E+00, 7.1207223613E+00, 7.6546426922E-02, 7.4023911410E-02, 3.9254973752E-01],
	[6.1250000000E+03, 3.2846266339E+00, 7.1189641732E+00, 7.6740260929E-02, 7.4206612662E-02, 3.9276865459E-01],
	[6.1300000000E+03, 3.2878334871E+00, 7.1172078534E+00, 7.6934426730E-02, 7.4389605247E-02, 3.9298746660E-01],
	[6.1350000000E+03, 3.2910408527E+00, 7.1154533982E+00, 7.7128924623E-02, 7.4572889348E-02, 3.9320617389E-01],
	[6.1400000000E+03, 3.2942487304E+00, 7.1137008044E+00, 7.7323754902E-02, 7.4756465142E-02, 3.9342477682E-01],
	[6.1450000000E+03, 3.2974571199E+00, 7.1119500683E+00, 7.7518917864E-02, 7.4940332812E-02, 3.9364327574E-01],
	[6.1500000000E+03, 3.3006660209E+00, 7.1102011865E+00, 7.7714413804E-02, 7.5124492536E-02, 3.9386167098E-01],
	[6.1550000000E+03, 3.3038777369E+00, 7.1084604175E+00, 7.7910243019E-02, 7.5308946393E-02, 3.9407996291E-01],
	[6.1600000000E+03, 3.3070961256E+00, 7.1067382079E+00, 7.8106405805E-02, 7.5493697775E-02, 3.9429815187E-01],
	[6.1650000000E+03, 3.3103150343E+00, 7.1050178124E+00, 7.8302902457E-02, 7.5678741804E-02, 3.9451623820E-01],
	[6.1700000000E+03, 3.3135344627E+00, 7.1032992276E+00, 7.8499733272E-02, 7.5864078660E-02, 3.9473422225E-01],
	[6.1750000000E+03, 3.3167544104E+00, 7.1015824501E+00, 7.8696898546E-02, 7.6049708522E-02, 3.9495210437E-01],
	[6.1800000000E+03, 3.3199748772E+00, 7.0998674766E+00, 7.8894398575E-02, 7.6235631568E-02, 3.9516988489E-01],
	[6.1850000000E+03, 3.3231958626E+00, 7.0981543036E+00, 7.9092233655E-02, 7.6421847976E-02, 3.9538756417E-01],
	[6.1900000000E+03, 3.3264173664E+00, 7.0964429280E+00, 7.9290404082E-02, 7.6608357925E-02, 3.9560514255E-01],
	[6.1950000000E+03, 3.3296393882E+00, 7.0947333462E+00, 7.9488910152E-02, 7.6795161593E-02, 3.9582262036E-01],
	[6.2000000000E+03, 3.3328619276E+00, 7.0930255551E+00, 7.9687752161E-02, 7.6982259158E-02, 3.9603999795E-01],
	[6.2050000000E+03, 3.3360849844E+00, 7.0913195513E+00, 7.9886930407E-02, 7.7169650796E-02, 3.9625727566E-01],
	[6.2100000000E+03, 3.3393085582E+00, 7.0896153314E+00, 8.0086445184E-02, 7.7357336686E-02, 3.9647445383E-01],
	[6.2150000000E+03, 3.3425326487E+00, 7.0879128922E+00, 8.0286296789E-02, 7.7545317004E-02, 3.9669153281E-01],
	[6.2200000000E+03, 3.3457572555E+00, 7.0862122304E+00, 8.0486485518E-02, 7.7733591927E-02, 3.9690851293E-01],
	[6.2250000000E+03, 3.3489823783E+00, 7.0845133427E+00, 8.0687011668E-02, 7.7922161632E-02, 3.9712539452E-01],
	[6.2300000000E+03, 3.3522080168E+00, 7.0828162258E+00, 8.0887875535E-02, 7.8111026296E-02, 3.9734217794E-01],
	[6.2350000000E+03, 3.3554341706E+00, 7.0811208765E+00, 8.1089077415E-02, 7.8300186094E-02, 3.9755886351E-01],
	[6.2400000000E+03, 3.3586608395E+00, 7.0794272915E+00, 8.1290617604E-02, 7.8489641202E-02, 3.9777545157E-01],
	[6.2450000000E+03, 3.3618880230E+00, 7.0777354676E+00, 8.1492496399E-02, 7.8679391797E-02, 3.9799194246E-01],
	[6.2500000000E+03, 3.3651157209E+00, 7.0760454015E+00, 8.1694714097E-02, 7.8869438053E-02, 3.9820833652E-01],
	[6.2550000000E+03, 3.3683476538E+00, 7.0743672150E+00, 8.1897270993E-02, 7.9059783461E-02, 3.9842463408E-01],
	[6.2600000000E+03, 3.3715844876E+00, 7.0727026786E+00, 8.2100167384E-02, 7.9250428824E-02, 3.9864083547E-01],
	[6.2650000000E+03, 3.3748218438E+00, 7.0710398624E+00, 8.2303403567E-02, 7.9441370431E-02, 3.9885694103E-01],
	[6.2700000000E+03, 3.3780597221E+00, 7.0693787631E+00, 8.2506979838E-02, 7.9632608456E-02, 3.9907295110E-01],
	[6.2750000000E+03, 3.3812981222E+00, 7.0677193778E+00, 8.2710896493E-02, 7.9824143075E-02, 3.9928886599E-01],
	[6.2800000000E+03, 3.3845370437E+00, 7.0660617032E+00, 8.2915153829E-02, 8.0015974462E-02, 3.9950468606E-01],
	[6.2850000000E+03, 3.3877764863E+00, 7.0644057361E+00, 8.3119752143E-02, 8.0208102790E-02, 3.9972041163E-01],
	[6.2900000000E+03, 3.3910164496E+00, 7.0627514736E+00, 8.3324691731E-02, 8.0400528235E-02, 3.9993604302E-01],
	[6.2950000000E+03, 3.3942569334E+00, 7.0610989125E+00, 8.3529972889E-02, 8.0593250970E-02, 4.0015158058E-01],
	[6.3000000000E+03, 3.3974979374E+00, 7.0594480496E+00, 8.3735595914E-02, 8.0786271168E-02, 4.0036702463E-01],
	[6.3050000000E+03, 3.4007394611E+00, 7.0577988820E+00, 8.3941561103E-02, 8.0979589002E-02, 4.0058237553E-01],
	[6.3100000000E+03, 3.4039815042E+00, 7.0561514064E+00, 8.4147868752E-02, 8.1173204647E-02, 4.0079763356E-01],
	[6.3150000000E+03, 3.4072240665E+00, 7.0545056199E+00, 8.4354519159E-02, 8.1367118274E-02, 4.0101279902E-01],
	[6.3200000000E+03, 3.4104671476E+00, 7.0528615194E+00, 8.4561512619E-02, 8.1561330056E-02, 4.0122787220E-01],
	[6.3250000000E+03, 3.4137107472E+00, 7.0512191018E+00, 8.4768849429E-02, 8.1755840167E-02, 4.0144285337E-01],
	[6.3300000000E+03, 3.4169548649E+00, 7.0495783640E+00, 8.4976529887E-02, 8.1950648777E-02, 4.0165774282E-01],
	[6.3350000000E+03, 3.4201995004E+00, 7.0479393031E+00, 8.5184554288E-02, 8.2145756059E-02, 4.0187254083E-01],
	[6.3400000000E+03, 3.4234446534E+00, 7.0463019159E+00, 8.5392922930E-02, 8.2341162184E-02, 4.0208724768E-01],
	[6.3450000000E+03, 3.4266903236E+00, 7.0446661996E+00, 8.5601636109E-02, 8.2536867325E-02, 4.0230186366E-01],
	[6.3500000000E+03, 3.4299365106E+00, 7.0430321509E+00, 8.5810694122E-02, 8.2732871653E-02, 4.0251638904E-01],
	[6.3550000000E+03, 3.4331857474E+00, 7.0414066830E+00, 8.6020097266E-02, 8.2929177775E-02, 4.0273082412E-01],
	[6.3600000000E+03, 3.4364407127E+00, 7.0397970737E+00, 8.6229845837E-02, 8.3125788473E-02, 4.0294516916E-01],
	[6.3650000000E+03, 3.4396962025E+00, 7.0381890968E+00, 8.6439940134E-02, 8.3322698928E-02, 4.0315942445E-01],
	[6.3700000000E+03, 3.4429522164E+00, 7.0365827494E+00, 8.6650380451E-02, 8.3519909311E-02, 4.0337359026E-01],
	[6.3750000000E+03, 3.4462087541E+00, 7.0349780286E+00, 8.6861167087E-02, 8.3717419791E-02, 4.0358766689E-01],
	[6.3800000000E+03, 3.4494658152E+00, 7.0333749314E+00, 8.7072300338E-02, 8.3915230539E-02, 4.0380165460E-01],
	[6.3850000000E+03, 3.4527233994E+00, 7.0317734550E+00, 8.7283780501E-02, 8.4113341725E-02, 4.0401555367E-01],
	[6.3900000000E+03, 3.4559815064E+00, 7.0301735963E+00, 8.7495607874E-02, 8.4311753519E-02, 4.0422936438E-01],
	[6.3950000000E+03, 3.4592401359E+00, 7.0285753527E+00, 8.7707782752E-02, 8.4510466090E-02, 4.0444308702E-01],
	[6.4000000000E+03, 3.4624992876E+00, 7.0269787210E+00, 8.7920305433E-02, 8.4709479607E-02, 4.0465672185E-01],
	[6.4050000000E+03, 3.4657589610E+00, 7.0253836985E+00, 8.8133176215E-02, 8.4908794240E-02, 4.0487026915E-01],
	[6.4100000000E+03, 3.4690191560E+00, 7.0237902823E+00, 8.8346395393E-02, 8.5108410157E-02, 4.0508372919E-01],
	[6.4150000000E+03, 3.4722798721E+00, 7.0221984695E+00, 8.8559963266E-02, 8.5308327526E-02, 4.0529710226E-01],
	[6.4200000000E+03, 3.4755411091E+00, 7.0206082572E+00, 8.8773880129E-02, 8.5508546517E-02, 4.0551038863E-01],
	[6.4250000000E+03, 3.4788028666E+00, 7.0190196426E+00, 8.8988146281E-02, 8.5709067297E-02, 4.0572358858E-01],
	[6.4300000000E+03, 3.4820651444E+00, 7.0174326229E+00, 8.9202762019E-02, 8.5909890035E-02, 4.0593670237E-01],
	[6.4350000000E+03, 3.4853279420E+00, 7.0158471951E+00, 8.9417727638E-02, 8.6111014897E-02, 4.0614973028E-01],
	[6.4400000000E+03, 3.4885912592E+00, 7.0142633566E+00, 8.9633043438E-02, 8.6312442051E-02, 4.0636267258E-01],
	[6.4450000000E+03, 3.4918550956E+00, 7.0126811044E+00, 8.9848709714E-02, 8.6514171664E-02, 4.0657552956E-01],
	[6.4500000000E+03, 3.4951194509E+00, 7.0111004357E+00, 9.0064726764E-02, 8.6716203904E-02, 4.0678830147E-01],
	[6.4550000000E+03, 3.4983843248E+00, 7.0095213478E+00, 9.0281094886E-02, 8.6918538937E-02, 4.0700098860E-01],
	[6.4600000000E+03, 3.5016561457E+00, 7.0079614686E+00, 9.0497814376E-02, 8.7121183634E-02, 4.0721359121E-01],
	[6.4650000000E+03, 3.5049294425E+00, 7.0064057480E+00, 9.0714885531E-02, 8.7324132502E-02, 4.0742610958E-01],
	[6.4700000000E+03, 3.5082032650E+00, 7.0048515751E+00, 9.0932308650E-02, 8.7527384721E-02, 4.0763854397E-01],
	[6.4750000000E+03, 3.5114776129E+00, 7.0032989472E+00, 9.1150084028E-02, 8.7730940457E-02, 4.0785089466E-01],
	[6.4800000000E+03, 3.5147524859E+00, 7.0017478614E+00, 9.1368211964E-02, 8.7934799876E-02, 4.0806316192E-01],
	[6.4850000000E+03, 3.5180278836E+00, 7.0001983152E+00, 9.1586701121E-02, 8.8138970889E-02, 4.0827534601E-01],
	[6.4900000000E+03, 3.5213038057E+00, 6.9986503057E+00, 9.1805544920E-02, 8.8343447295E-02, 4.0848744721E-01],
	[6.4950000000E+03, 3.5245802520E+00, 6.9971038304E+00, 9.2024742211E-02, 8.8548227916E-02, 4.0869946579E-01],
	[6.5000000000E+03, 3.5278572220E+00, 6.9955588864E+00, 9.2244293290E-02, 8.8753312916E-02, 4.0891140201E-01],
	[6.5050000000E+03, 3.5311347154E+00, 6.9940154711E+00, 9.2464198456E-02, 8.8958702460E-02, 4.0912325614E-01],
	[6.5100000000E+03, 3.5344127321E+00, 6.9924735818E+00, 9.2684458004E-02, 8.9164396712E-02, 4.0933502846E-01],
	[6.5150000000E+03, 3.5376912715E+00, 6.9909332158E+00, 9.2905072234E-02, 8.9370395837E-02, 4.0954671922E-01],
	[6.5200000000E+03, 3.5409703335E+00, 6.9893943705E+00, 9.3126041442E-02, 8.9576699999E-02, 4.0975832869E-01],
	[6.5250000000E+03, 3.5442499176E+00, 6.9878570432E+00, 9.3347365927E-02, 8.9783309361E-02, 4.0996985715E-01],
	[6.5300000000E+03, 3.5475300236E+00, 6.9863212312E+00, 9.3569045985E-02, 8.9990224087E-02, 4.1018130485E-01],
	[6.5350000000E+03, 3.5508106512E+00, 6.9847869318E+00, 9.3791081914E-02, 9.0197444341E-02, 4.1039267207E-01],
	[6.5400000000E+03, 3.5540918000E+00, 6.9832541425E+00, 9.4013474013E-02, 9.0404970285E-02, 4.1060395906E-01],
	[6.5450000000E+03, 3.5573734698E+00, 6.9817228606E+00, 9.4236222578E-02, 9.0612802082E-02, 4.1081516610E-01],
	[6.5500000000E+03, 3.5606556601E+00, 6.9801930835E+00, 9.4459327907E-02, 9.0820939894E-02, 4.1102629345E-01],
	[6.5550000000E+03, 3.5639383708E+00, 6.9786648084E+00, 9.4682790298E-02, 9.1029383885E-02, 4.1123734138E-01],
	[6.5600000000E+03, 3.5672222028E+00, 6.9771396962E+00, 9.4906610049E-02, 9.1238134893E-02, 4.1144831014E-01],
	[6.5650000000E+03, 3.5705129680E+00, 6.9756337943E+00, 9.5130787457E-02, 9.1447199660E-02, 4.1165920000E-01],
	[6.5700000000E+03, 3.5738042600E+00, 6.9741293635E+00, 9.5355322820E-02, 9.1656571150E-02, 4.1187001122E-01],
	[6.5750000000E+03, 3.5770960787E+00, 6.9726264012E+00, 9.5580216436E-02, 9.1866249524E-02, 4.1208074408E-01],
	[6.5800000000E+03, 3.5803884236E+00, 6.9711249050E+00, 9.5805468603E-02, 9.2076234945E-02, 4.1229139882E-01],
	[6.5850000000E+03, 3.5836812946E+00, 6.9696248723E+00, 9.6031079618E-02, 9.2286527574E-02, 4.1250197572E-01],
	[6.5900000000E+03, 3.5869746912E+00, 6.9681263006E+00, 9.6257049779E-02, 9.2497127570E-02, 4.1271247503E-01],
	[6.5950000000E+03, 3.5902686131E+00, 6.9666291872E+00, 9.6483379385E-02, 9.2708035096E-02, 4.1292289702E-01],
	[6.6000000000E+03, 3.5935630601E+00, 6.9651335298E+00, 9.6710068732E-02, 9.2919250311E-02, 4.1313324195E-01],
	[6.6050000000E+03, 3.5968580318E+00, 6.9636393257E+00, 9.6937118119E-02, 9.3130773375E-02, 4.1334351008E-01],
	[6.6100000000E+03, 3.6001535279E+00, 6.9621465725E+00, 9.7164527845E-02, 9.3342604449E-02, 4.1355370166E-01],
	[6.6150000000E+03, 3.6034495480E+00, 6.9606552677E+00, 9.7392298205E-02, 9.3554743693E-02, 4.1376381697E-01],
	[6.6200000000E+03, 3.6067460920E+00, 6.9591654087E+00, 9.7620429500E-02, 9.3767191265E-02, 4.1397385625E-01],
	[6.6250000000E+03, 3.6100431594E+00, 6.9576769931E+00, 9.7848922025E-02, 9.3979947325E-02, 4.1418381978E-01],
	[6.6300000000E+03, 3.6133407500E+00, 6.9561900184E+00, 9.8077776081E-02, 9.4193012033E-02, 4.1439370780E-01],
	[6.6350000000E+03, 3.6166388634E+00, 6.9547044822E+00, 9.8306991964E-02, 9.4406385546E-02, 4.1460352058E-01],
	[6.6400000000E+03, 3.6199374994E+00, 6.9532203818E+00, 9.8536569972E-02, 9.4620068024E-02, 4.1481325838E-01],
	[6.6450000000E+03, 3.6232366576E+00, 6.9517377149E+00, 9.8766510405E-02, 9.4834059624E-02, 4.1502292145E-01],
	[6.6500000000E+03, 3.6265363376E+00, 6.9502564790E+00, 9.8996813558E-02, 9.5048360504E-02, 4.1523251006E-01],
	[6.6550000000E+03, 3.6298365393E+00, 6.9487766717E+00, 9.9227479732E-02, 9.5262970824E-02, 4.1544202445E-01],
	[6.6600000000E+03, 3.6331372623E+00, 6.9472982905E+00, 9.9458509223E-02, 9.5477890739E-02, 4.1565146489E-01],
	[6.6650000000E+03, 3.6364385062E+00, 6.9458213329E+00, 9.9689902330E-02, 9.5693120407E-02, 4.1586083164E-01],
	[6.6700000000E+03, 3.6397466896E+00, 6.9443637107E+00, 9.9921659352E-02, 9.5908667860E-02, 4.1607012495E-01],
	[6.6750000000E+03, 3.6430556280E+00, 6.9429081212E+00, 1.0015378059E-01, 9.6124525718E-02, 4.1627934508E-01],
	[6.6800000000E+03, 3.6463650935E+00, 6.9414539263E+00, 1.0038626633E-01, 9.6340693861E-02, 4.1648849228E-01],
	[6.6850000000E+03, 3.6496750859E+00, 6.9400011238E+00, 1.0061911688E-01, 9.6557172445E-02, 4.1669756681E-01],
	[6.6900000000E+03, 3.6529856047E+00, 6.9385497112E+00, 1.0085233254E-01, 9.6773961626E-02, 4.1690656893E-01],
	[6.6950000000E+03, 3.6562966498E+00, 6.9370996861E+00, 1.0108591360E-01, 9.6991061560E-02, 4.1711549889E-01],
	[6.7000000000E+03, 3.6596082208E+00, 6.9356510463E+00, 1.0131986037E-01, 9.7208472404E-02, 4.1732435694E-01],
	[6.7050000000E+03, 3.6629203173E+00, 6.9342037893E+00, 1.0155417314E-01, 9.7426194313E-02, 4.1753314335E-01],
	[6.7100000000E+03, 3.6662329392E+00, 6.9327579128E+00, 1.0178885221E-01, 9.7644227442E-02, 4.1774185836E-01],
	[6.7150000000E+03, 3.6695460860E+00, 6.9313134145E+00, 1.0202389788E-01, 9.7862571947E-02, 4.1795050223E-01],
	[6.7200000000E+03, 3.6728597575E+00, 6.9298702919E+00, 1.0225931044E-01, 9.8081227982E-02, 4.1815907521E-01],
	[6.7250000000E+03, 3.6761739533E+00, 6.9284285429E+00, 1.0249509020E-01, 9.8300195702E-02, 4.1836757755E-01],
	[6.7300000000E+03, 3.6794886732E+00, 6.9269881650E+00, 1.0273123745E-01, 9.8519475261E-02, 4.1857600952E-01],
	[6.7350000000E+03, 3.6828039168E+00, 6.9255491559E+00, 1.0296775249E-01, 9.8739066814E-02, 4.1878437136E-01],
	[6.7400000000E+03, 3.6861196839E+00, 6.9241115133E+00, 1.0320463563E-01, 9.8958970514E-02, 4.1899266329E-01],
	[6.7450000000E+03, 3.6894359741E+00, 6.9226752350E+00, 1.0344188715E-01, 9.9179186515E-02, 4.1920088552E-01],
	[6.7500000000E+03, 3.6927527871E+00, 6.9212403186E+00, 1.0367950736E-01, 9.9399714971E-02, 4.1940903825E-01],
	[6.7550000000E+03, 3.6960701227E+00, 6.9198067617E+00, 1.0391749655E-01, 9.9620556035E-02, 4.1961712169E-01],
	[6.7600000000E+03, 3.6993879805E+00, 6.9183745622E+00, 1.0415585503E-01, 9.9841709858E-02, 4.1982513602E-01],
	[6.7650000000E+03, 3.7027063602E+00, 6.9169437177E+00, 1.0439458308E-01, 1.0006317660E-01, 4.2003308147E-01],
	[6.7700000000E+03, 3.7060252615E+00, 6.9155142259E+00, 1.0463368102E-01, 1.0028495640E-01, 4.2024095823E-01],
	[6.7750000000E+03, 3.7093478574E+00, 6.9140950616E+00, 1.0487314914E-01, 1.0050705365E-01, 4.2044876650E-01],
	[6.7800000000E+03, 3.7126740810E+00, 6.9126860043E+00, 1.0511298774E-01, 1.0072946844E-01, 4.2065650649E-01],
	[6.7850000000E+03, 3.7160008319E+00, 6.9112782725E+00, 1.0535319711E-01, 1.0095219682E-01, 4.2086417839E-01],
	[6.7900000000E+03, 3.7193281097E+00, 6.9098718642E+00, 1.0559377756E-01, 1.0117523893E-01, 4.2107178241E-01],
	[6.7950000000E+03, 3.7226559143E+00, 6.9084667769E+00, 1.0583472939E-01, 1.0139859492E-01, 4.2127931875E-01],
	[6.8000000000E+03, 3.7259842453E+00, 6.9070630086E+00, 1.0607605288E-01, 1.0162226496E-01, 4.2148678762E-01],
	[6.8050000000E+03, 3.7293131023E+00, 6.9056605570E+00, 1.0631774835E-01, 1.0184624918E-01, 4.2169418921E-01],
	[6.8100000000E+03, 3.7326424852E+00, 6.9042594200E+00, 1.0655981608E-01, 1.0207054774E-01, 4.2190152372E-01],
	[6.8150000000E+03, 3.7359723935E+00, 6.9028595953E+00, 1.0680225638E-01, 1.0229516079E-01, 4.2210879135E-01],
	[6.8200000000E+03, 3.7393028270E+00, 6.9014610807E+00, 1.0704506955E-01, 1.0252008848E-01, 4.2231599231E-01],
	[6.8250000000E+03, 3.7426337854E+00, 6.9000638741E+00, 1.0728825589E-01, 1.0274533096E-01, 4.2252312679E-01],
	[6.8300000000E+03, 3.7459652684E+00, 6.8986679732E+00, 1.0753181569E-01, 1.0297088837E-01, 4.2273019500E-01],
	[6.8350000000E+03, 3.7492972756E+00, 6.8972733760E+00, 1.0777574925E-01, 1.0319676088E-01, 4.2293719713E-01],
	[6.8400000000E+03, 3.7526298069E+00, 6.8958800802E+00, 1.0802005688E-01, 1.0342294862E-01, 4.2314413338E-01],
	[6.8450000000E+03, 3.7559628618E+00, 6.8944880836E+00, 1.0826473887E-01, 1.0364945175E-01, 4.2335100396E-01],
	[6.8500000000E+03, 3.7592964400E+00, 6.8930973842E+00, 1.0850979551E-01, 1.0387627041E-01, 4.2355780906E-01],
	[6.8550000000E+03, 3.7626305414E+00, 6.8917079797E+00, 1.0875522712E-01, 1.0410340476E-01, 4.2376454889E-01],
	[6.8600000000E+03, 3.7659651655E+00, 6.8903198680E+00, 1.0900103398E-01, 1.0433085494E-01, 4.2397122363E-01],
	[6.8650000000E+03, 3.7693003121E+00, 6.8889330470E+00, 1.0924721639E-01, 1.0455862110E-01, 4.2417783349E-01],
	[6.8700000000E+03, 3.7726359809E+00, 6.8875475145E+00, 1.0949377467E-01, 1.0478670338E-01, 4.2438437867E-01],
	[6.8750000000E+03, 3.7759721715E+00, 6.8861632683E+00, 1.0974070909E-01, 1.0501510194E-01, 4.2459085937E-01],
	[6.8800000000E+03, 3.7793088838E+00, 6.8847803065E+00, 1.0998801997E-01, 1.0524381693E-01, 4.2479727577E-01],
	[6.8850000000E+03, 3.7826502508E+00, 6.8834105104E+00, 1.1023570761E-01, 1.0547285448E-01, 4.2500362810E-01],
	[6.8900000000E+03, 3.7859939139E+00, 6.8820470663E+00, 1.1048377229E-01, 1.0570221138E-01, 4.2520991653E-01],
	[6.8950000000E+03, 3.7893381038E+00, 6.8806848811E+00, 1.1073221432E-01, 1.0593188519E-01, 4.2541614126E-01],
	[6.9000000000E+03, 3.7926828203E+00, 6.8793239526E+00, 1.1098103400E-01, 1.0616187608E-01, 4.2562230250E-01],
	[6.9050000000E+03, 3.7960280629E+00, 6.8779642788E+00, 1.1123023163E-01, 1.0639218419E-01, 4.2582840045E-01],
	[6.9100000000E+03, 3.7993738315E+00, 6.8766058576E+00, 1.1147980751E-01, 1.0662280965E-01, 4.2603443529E-01],
	[6.9150000000E+03, 3.8027201257E+00, 6.8752486871E+00, 1.1172976193E-01, 1.0685375263E-01, 4.2624040722E-01],
	[6.9200000000E+03, 3.8060669453E+00, 6.8738927651E+00, 1.1198009520E-01, 1.0708501326E-01, 4.2644631645E-01],
	[6.9250000000E+03, 3.8094142899E+00, 6.8725380895E+00, 1.1223080761E-01, 1.0731659168E-01, 4.2665216317E-01],
	[6.9300000000E+03, 3.8127621592E+00, 6.8711846584E+00, 1.1248189946E-01, 1.0754848805E-01, 4.2685794757E-01],
	[6.9350000000E+03, 3.8161105530E+00, 6.8698324697E+00, 1.1273337106E-01, 1.0778070251E-01, 4.2706366985E-01],
	[6.9400000000E+03, 3.8194594709E+00, 6.8684815214E+00, 1.1298522270E-01, 1.0801323521E-01, 4.2726933020E-01],
	[6.9450000000E+03, 3.8228089127E+00, 6.8671318113E+00, 1.1323745468E-01, 1.0824608627E-01, 4.2747492883E-01],
	[6.9500000000E+03, 3.8261588780E+00, 6.8657833376E+00, 1.1349006730E-01, 1.0847925586E-01, 4.2768046593E-01],
	[6.9550000000E+03, 3.8295093666E+00, 6.8644360982E+00, 1.1374306085E-01, 1.0871274411E-01, 4.2788594169E-01],
	[6.9600000000E+03, 3.8328603781E+00, 6.8630900911E+00, 1.1399643565E-01, 1.0894655117E-01, 4.2809135631E-01],
	[6.9650000000E+03, 3.8362119123E+00, 6.8617453142E+00, 1.1425019198E-01, 1.0918067718E-01, 4.2829670998E-01],
	[6.9700000000E+03, 3.8395639689E+00, 6.8604017655E+00, 1.1450433016E-01, 1.0941512229E-01, 4.2850200290E-01],
	[6.9750000000E+03, 3.8429165476E+00, 6.8590594431E+00, 1.1475885046E-01, 1.0964988663E-01, 4.2870723527E-01],
	[6.9800000000E+03, 3.8462696481E+00, 6.8577183450E+00, 1.1501375321E-01, 1.0988497035E-01, 4.2891240727E-01],
	[6.9850000000E+03, 3.8496232701E+00, 6.8563784691E+00, 1.1526903868E-01, 1.1012037358E-01, 4.2911751910E-01],
	[6.9900000000E+03, 3.8529774133E+00, 6.8550398135E+00, 1.1552470720E-01, 1.1035609648E-01, 4.2932257096E-01],
	[6.9950000000E+03, 3.8563350998E+00, 6.8537112020E+00, 1.1578075904E-01, 1.1059214397E-01, 4.2952756304E-01],
	[7.0000000000E+03, 3.8596958484E+00, 6.8523912016E+00, 1.1603719452E-01, 1.1082851547E-01, 4.2973249554E-01],
	[7.0050000000E+03, 3.8630571230E+00, 6.8510723976E+00, 1.1629595747E-01, 1.1106697981E-01, 4.2993736864E-01],
	[7.0100000000E+03, 3.8664189234E+00, 6.8497547882E+00, 1.1655511195E-01, 1.1130577054E-01, 4.3014218255E-01],
	[7.0150000000E+03, 3.8697812492E+00, 6.8484383714E+00, 1.1681465827E-01, 1.1154488782E-01, 4.3034693745E-01],
	[7.0200000000E+03, 3.8731441002E+00, 6.8471231453E+00, 1.1707459675E-01, 1.1178433179E-01, 4.3055163354E-01],
	[7.0250000000E+03, 3.8765074761E+00, 6.8458091079E+00, 1.1733492770E-01, 1.1202410260E-01, 4.3075627101E-01],
	[7.0300000000E+03, 3.8798713765E+00, 6.8444962574E+00, 1.1759565143E-01, 1.1226420040E-01, 4.3096085006E-01],
	[7.0350000000E+03, 3.8832358013E+00, 6.8431845918E+00, 1.1785676825E-01, 1.1250462533E-01, 4.3116537087E-01],
	[7.0400000000E+03, 3.8866007500E+00, 6.8418741092E+00, 1.1811827847E-01, 1.1274537754E-01, 4.3136983364E-01],
	[7.0450000000E+03, 3.8899662224E+00, 6.8405648077E+00, 1.1838018241E-01, 1.1298645718E-01, 4.3157423857E-01],
	[7.0500000000E+03, 3.8933322182E+00, 6.8392566854E+00, 1.1864248038E-01, 1.1322786439E-01, 4.3177858584E-01],
	[7.0550000000E+03, 3.8966987371E+00, 6.8379497404E+00, 1.1890517268E-01, 1.1346959932E-01, 4.3198287566E-01],
	[7.0600000000E+03, 3.9000657789E+00, 6.8366439708E+00, 1.1916825964E-01, 1.1371166212E-01, 4.3218710820E-01],
	[7.0650000000E+03, 3.9034333432E+00, 6.8353393747E+00, 1.1943174156E-01, 1.1395405293E-01, 4.3239128366E-01],
	[7.0700000000E+03, 3.9068014298E+00, 6.8340359503E+00, 1.1969561876E-01, 1.1419677189E-01, 4.3259540223E-01],
	[7.0750000000E+03, 3.9101700383E+00, 6.8327336957E+00, 1.1995989155E-01, 1.1443981916E-01, 4.3279946412E-01],
	[7.0800000000E+03, 3.9135391685E+00, 6.8314326089E+00, 1.2022456024E-01, 1.1468319487E-01, 4.3300346950E-01],
	[7.0850000000E+03, 3.9169088201E+00, 6.8301326881E+00, 1.2048962515E-01, 1.1492689918E-01, 4.3320741856E-01],
	[7.0900000000E+03, 3.9202789928E+00, 6.8288339315E+00, 1.2075508657E-01, 1.1517093222E-01, 4.3341131151E-01],
	[7.0950000000E+03, 3.9236496863E+00, 6.8275363372E+00, 1.2102094484E-01, 1.1541529414E-01, 4.3361514853E-01],
	[7.1000000000E+03, 3.9270209004E+00, 6.8262399032E+00, 1.2128720026E-01, 1.1565998508E-01, 4.3381892981E-01],
	[7.1050000000E+03, 3.9303927979E+00, 6.8249451019E+00, 1.2155385314E-01, 1.1590500547E-01, 4.3402265554E-01],
	[7.1100000000E+03, 3.9337704217E+00, 6.8236665631E+00, 1.2182090379E-01, 1.1615036408E-01, 4.3422632592E-01],
	[7.1150000000E+03, 3.9371485706E+00, 6.8223891624E+00, 1.2208835253E-01, 1.1639605221E-01, 4.3442994113E-01],
	[7.1200000000E+03, 3.9405272444E+00, 6.8211128980E+00, 1.2235619967E-01, 1.1664207001E-01, 4.3463350137E-01],
	[7.1250000000E+03, 3.9439064427E+00, 6.8198377680E+00, 1.2262444552E-01, 1.1688841760E-01, 4.3483700682E-01],
	[7.1300000000E+03, 3.9472861652E+00, 6.8185637706E+00, 1.2289309040E-01, 1.1713509514E-01, 4.3504045767E-01],
	[7.1350000000E+03, 3.9506664117E+00, 6.8172909041E+00, 1.2316213462E-01, 1.1738210277E-01, 4.3524385413E-01],
	[7.1400000000E+03, 3.9540471819E+00, 6.8160191666E+00, 1.2343157848E-01, 1.1762944063E-01, 4.3544719636E-01],
	[7.1450000000E+03, 3.9574284754E+00, 6.8147485564E+00, 1.2370142231E-01, 1.1787710885E-01, 4.3565048457E-01],
	[7.1500000000E+03, 3.9608102921E+00, 6.8134790716E+00, 1.2397166641E-01, 1.1812510759E-01, 4.3585371888E-01],
	[7.1550000000E+03, 3.9641926316E+00, 6.8122107105E+00, 1.2424231110E-01, 1.1837343699E-01, 4.3605689943E-01],
	[7.1600000000E+03, 3.9675754936E+00, 6.8109434713E+00, 1.2451335669E-01, 1.1862209717E-01, 4.3626002636E-01],
	[7.1650000000E+03, 3.9709588779E+00, 6.8096773522E+00, 1.2478480349E-01, 1.1887108829E-01, 4.3646309983E-01],
	[7.1700000000E+03, 3.9743427841E+00, 6.8084123515E+00, 1.2505665182E-01, 1.1912041049E-01, 4.3666611996E-01],
	[7.1750000000E+03, 3.9777272120E+00, 6.8071484674E+00, 1.2532890198E-01, 1.1937006390E-01, 4.3686908691E-01],
	[7.1800000000E+03, 3.9811121613E+00, 6.8058856981E+00, 1.2560155430E-01, 1.1962004866E-01, 4.3707200083E-01],
	[7.1850000000E+03, 3.9844976317E+00, 6.8046240418E+00, 1.2587460908E-01, 1.1987036491E-01, 4.3727486184E-01],
	[7.1900000000E+03, 3.9878836230E+00, 6.8033634969E+00, 1.2614806664E-01, 1.2012101280E-01, 4.3747767010E-01],
	[7.1950000000E+03, 3.9912701348E+00, 6.8021040615E+00, 1.2642192728E-01, 1.2037199246E-01, 4.3768042575E-01],
	[7.2000000000E+03, 3.9946571668E+00, 6.8008457340E+00, 1.2669619133E-01, 1.2062330403E-01, 4.3788312892E-01],
	[7.2050000000E+03, 3.9980447189E+00, 6.7995885125E+00, 1.2697085909E-01, 1.2087494764E-01, 4.3808577978E-01],
	[7.2100000000E+03, 4.0014327907E+00, 6.7983323953E+00, 1.2724593088E-01, 1.2112692344E-01, 4.3828837845E-01],
	[7.2150000000E+03, 4.0048213819E+00, 6.7970773808E+00, 1.2752140701E-01, 1.2137923157E-01, 4.3849092508E-01],
	[7.2200000000E+03, 4.0082113002E+00, 6.7958257845E+00, 1.2779728779E-01, 1.2163187364E-01, 4.3869341981E-01],
	[7.2250000000E+03, 4.0116061547E+00, 6.7945879379E+00, 1.2807357354E-01, 1.2188485647E-01, 4.3889586279E-01],
	[7.2300000000E+03, 4.0150015329E+00, 6.7933511729E+00, 1.2835026457E-01, 1.2213817210E-01, 4.3909825416E-01],
	[7.2350000000E+03, 4.0183974347E+00, 6.7921154877E+00, 1.2862736119E-01, 1.2239182067E-01, 4.3930059405E-01],
	[7.2400000000E+03, 4.0217938597E+00, 6.7908808808E+00, 1.2890486372E-01, 1.2264580231E-01, 4.3950288262E-01],
	[7.2450000000E+03, 4.0251908077E+00, 6.7896473504E+00, 1.2918277246E-01, 1.2290011717E-01, 4.3970512001E-01],
	[7.2500000000E+03, 4.0285882783E+00, 6.7884148948E+00, 1.2946108774E-01, 1.2315476537E-01, 4.3990730635E-01],
	[7.2550000000E+03, 4.0319862714E+00, 6.7871835123E+00, 1.2973980986E-01, 1.2340974706E-01, 4.4010944179E-01],
	[7.2600000000E+03, 4.0353847866E+00, 6.7859532014E+00, 1.3001893914E-01, 1.2366506236E-01, 4.4031152647E-01],
	[7.2650000000E+03, 4.0387838236E+00, 6.7847239603E+00, 1.3029847589E-01, 1.2392071142E-01, 4.4051356054E-01],
	[7.2700000000E+03, 4.0421833822E+00, 6.7834957873E+00, 1.3057842042E-01, 1.2417669437E-01, 4.4071554413E-01],
	[7.2750000000E+03, 4.0455834621E+00, 6.7822686808E+00, 1.3085877306E-01, 1.2443301134E-01, 4.4091747740E-01],
	[7.2800000000E+03, 4.0489840629E+00, 6.7810426392E+00, 1.3113953410E-01, 1.2468966247E-01, 4.4111936047E-01],
	[7.2850000000E+03, 4.0523851845E+00, 6.7798176607E+00, 1.3142070386E-01, 1.2494664790E-01, 4.4132119349E-01],
	[7.2900000000E+03, 4.0557868266E+00, 6.7785937438E+00, 1.3170228266E-01, 1.2520396774E-01, 4.4152297661E-01],
	[7.2950000000E+03, 4.0591889888E+00, 6.7773708867E+00, 1.3198427081E-01, 1.2546162215E-01, 4.4172470996E-01],
	[7.3000000000E+03, 4.0625916709E+00, 6.7761490879E+00, 1.3226666863E-01, 1.2571961125E-01, 4.4192639369E-01],
	[7.3050000000E+03, 4.0659948727E+00, 6.7749283457E+00, 1.3254947642E-01, 1.2597793518E-01, 4.4212802794E-01],
	[7.3100000000E+03, 4.0693985938E+00, 6.7737086584E+00, 1.3283269450E-01, 1.2623659406E-01, 4.4232961285E-01],
	[7.3150000000E+03, 4.0728028339E+00, 6.7724900245E+00, 1.3311632319E-01, 1.2649558803E-01, 4.4253114856E-01],
	[7.3200000000E+03, 4.0762075929E+00, 6.7712724422E+00, 1.3340036279E-01, 1.2675491723E-01, 4.4273263521E-01],
	[7.3250000000E+03, 4.0796128703E+00, 6.7700559101E+00, 1.3368481362E-01, 1.2701458178E-01, 4.4293407295E-01],
	[7.3300000000E+03, 4.0830186660E+00, 6.7688404264E+00, 1.3396967600E-01, 1.2727458182E-01, 4.4313546191E-01],
	[7.3350000000E+03, 4.0864249797E+00, 6.7676259895E+00, 1.3425495023E-01, 1.2753491747E-01, 4.4333680224E-01],
	[7.3400000000E+03, 4.0898364363E+00, 6.7664256949E+00, 1.3454063663E-01, 1.2779559806E-01, 4.4353809408E-01],
	[7.3450000000E+03, 4.0932488681E+00, 6.7652277125E+00, 1.3482673552E-01, 1.2805661550E-01, 4.4373933757E-01],
	[7.3500000000E+03, 4.0966618221E+00, 6.7640307573E+00, 1.3511324721E-01, 1.2831796901E-01, 4.4394053285E-01],
	[7.3550000000E+03, 4.1000752980E+00, 6.7628348276E+00, 1.3540017200E-01, 1.2857965874E-01, 4.4414168006E-01],
	[7.3600000000E+03, 4.1034892954E+00, 6.7616399218E+00, 1.3568751022E-01, 1.2884168480E-01, 4.4434277934E-01],
	[7.3650000000E+03, 4.1069038142E+00, 6.7604460385E+00, 1.3597526218E-01, 1.2910404733E-01, 4.4454383084E-01],
	[7.3700000000E+03, 4.1103188541E+00, 6.7592531759E+00, 1.3626342820E-01, 1.2936674646E-01, 4.4474483469E-01],
	[7.3750000000E+03, 4.1137344147E+00, 6.7580613327E+00, 1.3655200857E-01, 1.2962978232E-01, 4.4494579104E-01],
	[7.3800000000E+03, 4.1171504958E+00, 6.7568705071E+00, 1.3684100363E-01, 1.2989315504E-01, 4.4514670003E-01],
	[7.3850000000E+03, 4.1205670971E+00, 6.7556806976E+00, 1.3713041368E-01, 1.3015686474E-01, 4.4534756179E-01],
	[7.3900000000E+03, 4.1239842184E+00, 6.7544919028E+00, 1.3742023904E-01, 1.3042091156E-01, 4.4554837647E-01],
	[7.3950000000E+03, 4.1274018594E+00, 6.7533041210E+00, 1.3771048002E-01, 1.3068529562E-01, 4.4574914420E-01],
	[7.4000000000E+03, 4.1308200198E+00, 6.7521173506E+00, 1.3800113693E-01, 1.3095001704E-01, 4.4594986514E-01],
	[7.4050000000E+03, 4.1342386993E+00, 6.7509315903E+00, 1.3829221009E-01, 1.3121507597E-01, 4.4615053941E-01],
	[7.4100000000E+03, 4.1376578977E+00, 6.7497468383E+00, 1.3858369981E-01, 1.3148047252E-01, 4.4635116717E-01],
	[7.4150000000E+03, 4.1410776147E+00, 6.7485630932E+00, 1.3887560641E-01, 1.3174620683E-01, 4.4655174855E-01],
	[7.4200000000E+03, 4.1444978500E+00, 6.7473803534E+00, 1.3916793020E-01, 1.3201227901E-01, 4.4675228369E-01],
	[7.4250000000E+03, 4.1479186034E+00, 6.7461986174E+00, 1.3946067149E-01, 1.3227868920E-01, 4.4695277272E-01],
	[7.4300000000E+03, 4.1513398745E+00, 6.7450178837E+00, 1.3975383060E-01, 1.3254543752E-01, 4.4715321580E-01],
	[7.4350000000E+03, 4.1547616631E+00, 6.7438381507E+00, 1.4004740784E-01, 1.3281252410E-01, 4.4735361307E-01],
	[7.4400000000E+03, 4.1581839690E+00, 6.7426594170E+00, 1.4034140353E-01, 1.3307994906E-01, 4.4755396465E-01],
	[7.4450000000E+03, 4.1616067919E+00, 6.7414816810E+00, 1.4063581797E-01, 1.3334771253E-01, 4.4775427070E-01],
	[7.4500000000E+03, 4.1650301315E+00, 6.7403049411E+00, 1.4093065149E-01, 1.3361581463E-01, 4.4795453135E-01],
	[7.4550000000E+03, 4.1684554302E+00, 6.7391332379E+00, 1.4122590440E-01, 1.3388425858E-01, 4.4815474674E-01],
	[7.4600000000E+03, 4.1718847354E+00, 6.7379722883E+00, 1.4152157701E-01, 1.3415304890E-01, 4.4835491702E-01],
	[7.4650000000E+03, 4.1753145613E+00, 6.7368123164E+00, 1.4181766963E-01, 1.3442217830E-01, 4.4855504231E-01],
	[7.4700000000E+03, 4.1787449077E+00, 6.7356533206E+00, 1.4211418259E-01, 1.3469164691E-01, 4.4875512277E-01],
	[7.4750000000E+03, 4.1821757742E+00, 6.7344952996E+00, 1.4241111618E-01, 1.3496145484E-01, 4.4895515854E-01],
	[7.4800000000E+03, 4.1856071605E+00, 6.7333382517E+00, 1.4270847074E-01, 1.3523160222E-01, 4.4915514974E-01],
	[7.4850000000E+03, 4.1890390665E+00, 6.7321821757E+00, 1.4300624657E-01, 1.3550208918E-01, 4.4935509653E-01],
	[7.4900000000E+03, 4.1924714919E+00, 6.7310270699E+00, 1.4330444398E-01, 1.3577291583E-01, 4.4955499904E-01],
	[7.4950000000E+03, 4.1959044363E+00, 6.7298729330E+00, 1.4360306329E-01, 1.3604408230E-01, 4.4975485742E-01],
	[7.5000000000E+03, 4.1993378995E+00, 6.7287197634E+00, 1.4390210482E-01, 1.3631558870E-01, 4.4995467179E-01],
	[7.5050000000E+03, 4.2027718813E+00, 6.7275675598E+00, 1.4420156888E-01, 1.3658743518E-01, 4.5015444231E-01],
	[7.5100000000E+03, 4.2062063814E+00, 6.7264163206E+00, 1.4450145578E-01, 1.3685962183E-01, 4.5035416911E-01],
	[7.5150000000E+03, 4.2096413994E+00, 6.7252660445E+00, 1.4480176584E-01, 1.3713214880E-01, 4.5055385232E-01],
	[7.5200000000E+03, 4.2130769352E+00, 6.7241167299E+00, 1.4510249938E-01, 1.3740501619E-01, 4.5075349210E-01],
	[7.5250000000E+03, 4.2165129885E+00, 6.7229683755E+00, 1.4540365669E-01, 1.3767822413E-01, 4.5095308858E-01],
	[7.5300000000E+03, 4.2199495590E+00, 6.7218209797E+00, 1.4570523811E-01, 1.3795177274E-01, 4.5115264190E-01],
	[7.5350000000E+03, 4.2233866464E+00, 6.7206745413E+00, 1.4600724395E-01, 1.3822566214E-01, 4.5135215215E-01],
	[7.5400000000E+03, 4.2268242506E+00, 6.7195290586E+00, 1.4630967451E-01, 1.3849989245E-01, 4.5155161942E-01],
	[7.5450000000E+03, 4.2302623711E+00, 6.7183845304E+00, 1.4661253012E-01, 1.3877446378E-01, 4.5175104381E-01],
	[7.5500000000E+03, 4.2337010078E+00, 6.7172409551E+00, 1.4691581109E-01, 1.3904937627E-01, 4.5195042543E-01],
	[7.5550000000E+03, 4.2371401604E+00, 6.7160983313E+00, 1.4721951773E-01, 1.3932463003E-01, 4.5214976436E-01],
	[7.5600000000E+03, 4.2405798286E+00, 6.7149566577E+00, 1.4752365035E-01, 1.3960022517E-01, 4.5234906072E-01],
	[7.5650000000E+03, 4.2440200121E+00, 6.7138159328E+00, 1.4782820928E-01, 1.3987616182E-01, 4.5254831459E-01],
	[7.5700000000E+03, 4.2474607108E+00, 6.7126761552E+00, 1.4813319483E-01, 1.4015244009E-01, 4.5274752609E-01],
	[7.5750000000E+03, 4.2509033316E+00, 6.7115412246E+00, 1.4843860731E-01, 1.4042906335E-01, 4.5294669530E-01],
	[7.5800000000E+03, 4.2543498448E+00, 6.7104165849E+00, 1.4874444703E-01, 1.4070603630E-01, 4.5314582232E-01],
	[7.5850000000E+03, 4.2577968769E+00, 6.7092928750E+00, 1.4905071431E-01, 1.4098335129E-01, 4.5334490726E-01],
	[7.5900000000E+03, 4.2612444276E+00, 6.7081700937E+00, 1.4935740947E-01, 1.4126100846E-01, 4.5354395021E-01],
	[7.5950000000E+03, 4.2646924967E+00, 6.7070482394E+00, 1.4966453282E-01, 1.4153900791E-01, 4.5374295128E-01],
	[7.6000000000E+03, 4.2681410839E+00, 6.7059273109E+00, 1.4997208468E-01, 1.4181734976E-01, 4.5394191056E-01],
	[7.6050000000E+03, 4.2715901889E+00, 6.7048073067E+00, 1.5028006535E-01, 1.4209603414E-01, 4.5414082815E-01],
	[7.6100000000E+03, 4.2750398115E+00, 6.7036882256E+00, 1.5058847516E-01, 1.4237506114E-01, 4.5433970416E-01],
	[7.6150000000E+03, 4.2784899514E+00, 6.7025700661E+00, 1.5089731441E-01, 1.4265443090E-01, 4.5453853867E-01],
	[7.6200000000E+03, 4.2819406084E+00, 6.7014528268E+00, 1.5120658343E-01, 1.4293414353E-01, 4.5473733179E-01],
	[7.6250000000E+03, 4.2853917822E+00, 6.7003365064E+00, 1.5151628253E-01, 1.4321419914E-01, 4.5493608362E-01],
	[7.6300000000E+03, 4.2888434725E+00, 6.6992211036E+00, 1.5182641202E-01, 1.4349459784E-01, 4.5513479426E-01],
	[7.6350000000E+03, 4.2922956791E+00, 6.6981066170E+00, 1.5213697222E-01, 1.4377533976E-01, 4.5533346380E-01],
	[7.6400000000E+03, 4.2957484017E+00, 6.6969930452E+00, 1.5244796344E-01, 1.4405642501E-01, 4.5553209235E-01],
	[7.6450000000E+03, 4.2992016400E+00, 6.6958803869E+00, 1.5275938600E-01, 1.4433785370E-01, 4.5573068001E-01],
	[7.6500000000E+03, 4.3026553938E+00, 6.6947686408E+00, 1.5307124022E-01, 1.4461962594E-01, 4.5592922687E-01],
	[7.6550000000E+03, 4.3061096629E+00, 6.6936578054E+00, 1.5338352640E-01, 1.4490174185E-01, 4.5612773303E-01],
	[7.6600000000E+03, 4.3095644469E+00, 6.6925478795E+00, 1.5369624487E-01, 1.4518420154E-01, 4.5632619859E-01],
	[7.6650000000E+03, 4.3130197456E+00, 6.6914388618E+00, 1.5400939593E-01, 1.4546700513E-01, 4.5652462366E-01],
	[7.6700000000E+03, 4.3164755588E+00, 6.6903307508E+00, 1.5432297990E-01, 1.4575015273E-01, 4.5672300833E-01],
	[7.6750000000E+03, 4.3199318862E+00, 6.6892235453E+00, 1.5463699711E-01, 1.4603364444E-01, 4.5692135269E-01],
	[7.6800000000E+03, 4.3233887275E+00, 6.6881172439E+00, 1.5495144785E-01, 1.4631748039E-01, 4.5711965686E-01],
	[7.6850000000E+03, 4.3268460825E+00, 6.6870118453E+00, 1.5526633246E-01, 1.4660166069E-01, 4.5731792093E-01],
	[7.6900000000E+03, 4.3303039509E+00, 6.6859073482E+00, 1.5558165124E-01, 1.4688618544E-01, 4.5751614499E-01],
	[7.6950000000E+03, 4.3337623324E+00, 6.6848037512E+00, 1.5589740450E-01, 1.4717105475E-01, 4.5771432915E-01],
	[7.7000000000E+03, 4.3372254425E+00, 6.6837126178E+00, 1.5621359257E-01, 1.4745627925E-01, 4.5791247351E-01],
	[7.7050000000E+03, 4.3406894886E+00, 6.6826235195E+00, 1.5653021576E-01, 1.4774184965E-01, 4.5811057816E-01],
	[7.7100000000E+03, 4.3441540513E+00, 6.6815353051E+00, 1.5684727439E-01, 1.4802776503E-01, 4.5830864321E-01],
	[7.7150000000E+03, 4.3476191306E+00, 6.6804479731E+00, 1.5716476876E-01, 1.4831402549E-01, 4.5850666875E-01],
	[7.7200000000E+03, 4.3510847262E+00, 6.6793615224E+00, 1.5748269919E-01, 1.4860063115E-01, 4.5870465489E-01],
	[7.7250000000E+03, 4.3545508377E+00, 6.6782759516E+00, 1.5780106601E-01, 1.4888758211E-01, 4.5890260172E-01],
	[7.7300000000E+03, 4.3580174650E+00, 6.6771912596E+00, 1.5811986952E-01, 1.4917487849E-01, 4.5910050934E-01],
	[7.7350000000E+03, 4.3614846078E+00, 6.6761074449E+00, 1.5843911004E-01, 1.4946252039E-01, 4.5929837785E-01],
	[7.7400000000E+03, 4.3649522658E+00, 6.6750245063E+00, 1.5875878789E-01, 1.4975050793E-01, 4.5949620735E-01],
	[7.7450000000E+03, 4.3684204388E+00, 6.6739424425E+00, 1.5907890338E-01, 1.5003884120E-01, 4.5969399794E-01],
	[7.7500000000E+03, 4.3718891265E+00, 6.6728612524E+00, 1.5939945683E-01, 1.5032752033E-01, 4.5989174972E-01],
	[7.7550000000E+03, 4.3753583286E+00, 6.6717809345E+00, 1.5972044854E-01, 1.5061654541E-01, 4.6008946279E-01],
	[7.7600000000E+03, 4.3788280450E+00, 6.6707014877E+00, 1.6004187885E-01, 1.5090591656E-01, 4.6028713725E-01],
	[7.7650000000E+03, 4.3822982753E+00, 6.6696229106E+00, 1.6036374805E-01, 1.5119563388E-01, 4.6048477320E-01],
	[7.7700000000E+03, 4.3857690193E+00, 6.6685452021E+00, 1.6068605648E-01, 1.5148569748E-01, 4.6068237073E-01],
	[7.7750000000E+03, 4.3892402768E+00, 6.6674683608E+00, 1.6100880444E-01, 1.5177610747E-01, 4.6087992995E-01],
	[7.7800000000E+03, 4.3927120474E+00, 6.6663923855E+00, 1.6133199225E-01, 1.5206686395E-01, 4.6107745096E-01],
	[7.7850000000E+03, 4.3961843310E+00, 6.6653172750E+00, 1.6165562022E-01, 1.5235796703E-01, 4.6127493385E-01],
	[7.7900000000E+03, 4.3996571272E+00, 6.6642430279E+00, 1.6197968868E-01, 1.5264941681E-01, 4.6147237872E-01],
	[7.7950000000E+03, 4.4031304359E+00, 6.6631696431E+00, 1.6230419793E-01, 1.5294121340E-01, 4.6166978568E-01],
	[7.8000000000E+03, 4.4066042567E+00, 6.6620971194E+00, 1.6262914829E-01, 1.5323335692E-01, 4.6186715482E-01],
	[7.8050000000E+03, 4.4100785895E+00, 6.6610254553E+00, 1.6295454008E-01, 1.5352584745E-01, 4.6206448625E-01],
	[7.8100000000E+03, 4.4135534339E+00, 6.6599546499E+00, 1.6328037361E-01, 1.5381868510E-01, 4.6226178005E-01],
	[7.8150000000E+03, 4.4170287897E+00, 6.6588847017E+00, 1.6360664920E-01, 1.5411186999E-01, 4.6245903634E-01],
	[7.8200000000E+03, 4.4205052500E+00, 6.6578172236E+00, 1.6393336717E-01, 1.5440540380E-01, 4.6265625521E-01],
	[7.8250000000E+03, 4.4239861135E+00, 6.6567611772E+00, 1.6426052782E-01, 1.5469929554E-01, 4.6285343676E-01],
	[7.8300000000E+03, 4.4274674918E+00, 6.6557059727E+00, 1.6458813148E-01, 1.5499353489E-01, 4.6305058109E-01],
	[7.8350000000E+03, 4.4309493847E+00, 6.6546516089E+00, 1.6491617846E-01, 1.5528812196E-01, 4.6324768830E-01],
	[7.8400000000E+03, 4.4344317920E+00, 6.6535980847E+00, 1.6524466908E-01, 1.5558305686E-01, 4.6344475849E-01],
	[7.8450000000E+03, 4.4379147134E+00, 6.6525453987E+00, 1.6557360366E-01, 1.5587833969E-01, 4.6364179176E-01],
	[7.8500000000E+03, 4.4413981486E+00, 6.6514935498E+00, 1.6590298250E-01, 1.5617397055E-01, 4.6383878821E-01],
	[7.8550000000E+03, 4.4448820973E+00, 6.6504425369E+00, 1.6623280593E-01, 1.5646994954E-01, 4.6403574793E-01],
	[7.8600000000E+03, 4.4483665595E+00, 6.6493923586E+00, 1.6656307426E-01, 1.5676627677E-01, 4.6423267104E-01],
	[7.8650000000E+03, 4.4518515347E+00, 6.6483430139E+00, 1.6689378780E-01, 1.5706295233E-01, 4.6442955762E-01],
	[7.8700000000E+03, 4.4553370227E+00, 6.6472945015E+00, 1.6722494688E-01, 1.5735997633E-01, 4.6462640777E-01],
	[7.8750000000E+03, 4.4588230233E+00, 6.6462468203E+00, 1.6755655180E-01, 1.5765734887E-01, 4.6482322161E-01],
	[7.8800000000E+03, 4.4623095362E+00, 6.6451999689E+00, 1.6788860289E-01, 1.5795507005E-01, 4.6501999922E-01],
	[7.8850000000E+03, 4.4657965613E+00, 6.6441539464E+00, 1.6822110047E-01, 1.5825313997E-01, 4.6521674070E-01],
	[7.8900000000E+03, 4.4692840981E+00, 6.6431087514E+00, 1.6855404483E-01, 1.5855155873E-01, 4.6541344617E-01],
	[7.8950000000E+03, 4.4727721466E+00, 6.6420643829E+00, 1.6888743631E-01, 1.5885032643E-01, 4.6561011570E-01],
	[7.9000000000E+03, 4.4762607064E+00, 6.6410208396E+00, 1.6922127522E-01, 1.5914944317E-01, 4.6580674940E-01],
	[7.9050000000E+03, 4.4797497772E+00, 6.6399781203E+00, 1.6955556188E-01, 1.5944890905E-01, 4.6600334730E-01],
	[7.9100000000E+03, 4.4832393589E+00, 6.6389362239E+00, 1.6989029659E-01, 1.5974872416E-01, 4.6619990948E-01],
	[7.9150000000E+03, 4.4867294512E+00, 6.6378951493E+00, 1.7022547968E-01, 1.6004888861E-01, 4.6639643600E-01],
	[7.9200000000E+03, 4.4902200538E+00, 6.6368548952E+00, 1.7056111147E-01, 1.6034940250E-01, 4.6659292693E-01],
	[7.9250000000E+03, 4.4937111666E+00, 6.6358154605E+00, 1.7089719226E-01, 1.6065026592E-01, 4.6678938233E-01],
	[7.9300000000E+03, 4.4972027891E+00, 6.6347768440E+00, 1.7123372238E-01, 1.6095147897E-01, 4.6698580226E-01],
	[7.9350000000E+03, 4.5006949213E+00, 6.6337390446E+00, 1.7157070215E-01, 1.6125304174E-01, 4.6718218680E-01],
	[7.9400000000E+03, 4.5041875628E+00, 6.6327020610E+00, 1.7190813187E-01, 1.6155495434E-01, 4.6737853601E-01],
	[7.9450000000E+03, 4.5076807134E+00, 6.6316658923E+00, 1.7224601186E-01, 1.6185721687E-01, 4.6757484995E-01],
	[7.9500000000E+03, 4.5111785237E+00, 6.6306417161E+00, 1.7258434244E-01, 1.6215984145E-01, 4.6777112869E-01],
	[7.9550000000E+03, 4.5146770367E+00, 6.6296188539E+00, 1.7292312394E-01, 1.6246281679E-01, 4.6796737230E-01],
	[7.9600000000E+03, 4.5181760620E+00, 6.6285967921E+00, 1.7326235665E-01, 1.6276614241E-01, 4.6816358084E-01],
	[7.9650000000E+03, 4.5216755995E+00, 6.6275755294E+00, 1.7360204091E-01, 1.6306981842E-01, 4.6835975438E-01],
	[7.9700000000E+03, 4.5251756488E+00, 6.6265550648E+00, 1.7394217702E-01, 1.6337384491E-01, 4.6855589299E-01],
	[7.9750000000E+03, 4.5286762098E+00, 6.6255353972E+00, 1.7428276530E-01, 1.6367822197E-01, 4.6875199672E-01],
	[7.9800000000E+03, 4.5321772821E+00, 6.6245165255E+00, 1.7462380607E-01, 1.6398294971E-01, 4.6894806566E-01],
	[7.9850000000E+03, 4.5356788656E+00, 6.6234984485E+00, 1.7496529965E-01, 1.6428802821E-01, 4.6914409985E-01],
	[7.9900000000E+03, 4.5391809599E+00, 6.6224811650E+00, 1.7530724635E-01, 1.6459345757E-01, 4.6934009938E-01],
	[7.9950000000E+03, 4.5426835649E+00, 6.6214646741E+00, 1.7564964648E-01, 1.6489923789E-01, 4.6953606430E-01],
	[8.0000000000E+03, 4.5461866803E+00, 6.6204489746E+00, 1.7599250037E-01, 1.6520536925E-01, 4.6973199469E-01],
	[8.0050000000E+03, 4.5496903058E+00, 6.6194340653E+00, 1.7633802116E-01, 1.6551380126E-01, 4.6992789060E-01],
	[8.0100000000E+03, 4.5531944413E+00, 6.6184199452E+00, 1.7668400357E-01, 1.6582259012E-01, 4.7012375211E-01],
	[8.0150000000E+03, 4.5566990864E+00, 6.6174066131E+00, 1.7703044792E-01, 1.6613173594E-01, 4.7031957928E-01],
	[8.0200000000E+03, 4.5602042409E+00, 6.6163940680E+00, 1.7737735454E-01, 1.6644123880E-01, 4.7051537218E-01],
	[8.0250000000E+03, 4.5637099046E+00, 6.6153823088E+00, 1.7772472376E-01, 1.6675109882E-01, 4.7071113088E-01],
	[8.0300000000E+03, 4.5672160773E+00, 6.6143713343E+00, 1.7807255591E-01, 1.6706131607E-01, 4.7090685543E-01],
	[8.0350000000E+03, 4.5707227586E+00, 6.6133611435E+00, 1.7842085132E-01, 1.6737189067E-01, 4.7110254591E-01],
	[8.0400000000E+03, 4.5742299483E+00, 6.6123517352E+00, 1.7876961030E-01, 1.6768282270E-01, 4.7129820239E-01],
	[8.0450000000E+03, 4.5777376463E+00, 6.6113431084E+00, 1.7911883320E-01, 1.6799411227E-01, 4.7149382493E-01],
	[8.0500000000E+03, 4.5812458523E+00, 6.6103352620E+00, 1.7946852033E-01, 1.6830575946E-01, 4.7168941360E-01],
	[8.0550000000E+03, 4.5847545659E+00, 6.6093281948E+00, 1.7981867203E-01, 1.6861776437E-01, 4.7188496846E-01],
	[8.0600000000E+03, 4.5882637871E+00, 6.6083219059E+00, 1.8016928862E-01, 1.6893012710E-01, 4.7208048958E-01],
	[8.0650000000E+03, 4.5917735154E+00, 6.6073163941E+00, 1.8052037042E-01, 1.6924284774E-01, 4.7227597703E-01],
	[8.0700000000E+03, 4.5952837508E+00, 6.6063116584E+00, 1.8087191778E-01, 1.6955592639E-01, 4.7247143088E-01],
	[8.0750000000E+03, 4.5987961093E+00, 6.6053119197E+00, 1.8122393101E-01, 1.6986936813E-01, 4.7266685119E-01],
	[8.0800000000E+03, 4.6023116741E+00, 6.6043199922E+00, 1.8157641044E-01, 1.7018317647E-01, 4.7286223803E-01],
	[8.0850000000E+03, 4.6058277490E+00, 6.6033288272E+00, 1.8192935640E-01, 1.7049734317E-01, 4.7305759147E-01],
	[8.0900000000E+03, 4.6093443339E+00, 6.6023384236E+00, 1.8228276921E-01, 1.7081186834E-01, 4.7325291157E-01],
	[8.0950000000E+03, 4.6128614285E+00, 6.6013487803E+00, 1.8263664922E-01, 1.7112675206E-01, 4.7344819840E-01],
	[8.1000000000E+03, 4.6163790326E+00, 6.6003598963E+00, 1.8299099673E-01, 1.7144199443E-01, 4.7364345203E-01],
	[8.1050000000E+03, 4.6198971459E+00, 6.5993717706E+00, 1.8334581209E-01, 1.7175759553E-01, 4.7383867253E-01],
	[8.1100000000E+03, 4.6234157682E+00, 6.5983844020E+00, 1.8370109561E-01, 1.7207355548E-01, 4.7403385995E-01],
	[8.1150000000E+03, 4.6269348992E+00, 6.5973977895E+00, 1.8405684763E-01, 1.7238987434E-01, 4.7422901438E-01],
	[8.1200000000E+03, 4.6304545388E+00, 6.5964119322E+00, 1.8441306847E-01, 1.7270655222E-01, 4.7442413588E-01],
	[8.1250000000E+03, 4.6339746866E+00, 6.5954268289E+00, 1.8476975847E-01, 1.7302358920E-01, 4.7461922450E-01],
	[8.1300000000E+03, 4.6374953424E+00, 6.5944424786E+00, 1.8512691795E-01, 1.7334098539E-01, 4.7481428034E-01],
	[8.1350000000E+03, 4.6410165060E+00, 6.5934588802E+00, 1.8548454723E-01, 1.7365874085E-01, 4.7500930344E-01],
	[8.1400000000E+03, 4.6445381771E+00, 6.5924760329E+00, 1.8584264665E-01, 1.7397685570E-01, 4.7520429387E-01],
	[8.1450000000E+03, 4.6480603556E+00, 6.5914939354E+00, 1.8620121653E-01, 1.7429533001E-01, 4.7539925171E-01],
	[8.1500000000E+03, 4.6515830412E+00, 6.5905125867E+00, 1.8656025720E-01, 1.7461416387E-01, 4.7559417703E-01],
	[8.1550000000E+03, 4.6551062335E+00, 6.5895319860E+00, 1.8691976899E-01, 1.7493335738E-01, 4.7578906988E-01],
	[8.1600000000E+03, 4.6586299325E+00, 6.5885521320E+00, 1.8727975223E-01, 1.7525291062E-01, 4.7598393034E-01],
	[8.1650000000E+03, 4.6621541378E+00, 6.5875730238E+00, 1.8764020725E-01, 1.7557282368E-01, 4.7617875848E-01],
	[8.1700000000E+03, 4.6656788493E+00, 6.5865946604E+00, 1.8800113437E-01, 1.7589309666E-01, 4.7637355436E-01],
	[8.1750000000E+03, 4.6692040666E+00, 6.5856170407E+00, 1.8836253392E-01, 1.7621372962E-01, 4.7656831805E-01],
	[8.1800000000E+03, 4.6727297896E+00, 6.5846401638E+00, 1.8872440623E-01, 1.7653472268E-01, 4.7676304962E-01],
	[8.1850000000E+03, 4.6762560180E+00, 6.5836640285E+00, 1.8908675163E-01, 1.7685607590E-01, 4.7695774913E-01],
	[8.1900000000E+03, 4.6797827515E+00, 6.5826886340E+00, 1.8944957045E-01, 1.7717778938E-01, 4.7715241666E-01],
	[8.1950000000E+03, 4.6833099900E+00, 6.5817139791E+00, 1.8981286301E-01, 1.7749986320E-01, 4.7734705227E-01],
	[8.2000000000E+03, 4.6868377332E+00, 6.5807400628E+00, 1.9017662964E-01, 1.7782229746E-01, 4.7754165603E-01],
	[8.2050000000E+03, 4.6903676541E+00, 6.5797710420E+00, 1.9054087067E-01, 1.7814509769E-01, 4.7773622801E-01],
	[8.2100000000E+03, 4.6939007948E+00, 6.5788094924E+00, 1.9090558643E-01, 1.7846826744E-01, 4.7793076827E-01],
	[8.2150000000E+03, 4.6974344434E+00, 6.5778486686E+00, 1.9127077725E-01, 1.7879179796E-01, 4.7812527689E-01],
	[8.2200000000E+03, 4.7009685997E+00, 6.5768885697E+00, 1.9163644346E-01, 1.7911568934E-01, 4.7831975394E-01],
	[8.2250000000E+03, 4.7045032634E+00, 6.5759291945E+00, 1.9200258538E-01, 1.7943994167E-01, 4.7851419947E-01],
	[8.2300000000E+03, 4.7080384344E+00, 6.5749705423E+00, 1.9236920334E-01, 1.7976455502E-01, 4.7870861356E-01],
	[8.2350000000E+03, 4.7115741124E+00, 6.5740126118E+00, 1.9273629768E-01, 1.8008952949E-01, 4.7890299628E-01],
	[8.2400000000E+03, 4.7151102971E+00, 6.5730554023E+00, 1.9310386871E-01, 1.8041486515E-01, 4.7909734770E-01],
	[8.2450000000E+03, 4.7186469883E+00, 6.5720989127E+00, 1.9347191678E-01, 1.8074056209E-01, 4.7929166788E-01],
	[8.2500000000E+03, 4.7221841858E+00, 6.5711431419E+00, 1.9384044219E-01, 1.8106662040E-01, 4.7948595688E-01],
	[8.2550000000E+03, 4.7257218893E+00, 6.5701880892E+00, 1.9420944530E-01, 1.8139304015E-01, 4.7968021475E-01],
	[8.2600000000E+03, 4.7292600986E+00, 6.5692337534E+00, 1.9457892642E-01, 1.8171982142E-01, 4.7987444150E-01],
	[8.2650000000E+03, 4.7327988135E+00, 6.5682801336E+00, 1.9494888588E-01, 1.8204696431E-01, 4.8006863719E-01],
	[8.2700000000E+03, 4.7363380338E+00, 6.5673272288E+00, 1.9531932401E-01, 1.8237446889E-01, 4.8026280185E-01],
	[8.2750000000E+03, 4.7398777591E+00, 6.5663750382E+00, 1.9569024114E-01, 1.8270233524E-01, 4.8045693552E-01],
	[8.2800000000E+03, 4.7434179893E+00, 6.5654235606E+00, 1.9606163760E-01, 1.8303056345E-01, 4.8065103825E-01],
	[8.2850000000E+03, 4.7469587242E+00, 6.5644727951E+00, 1.9643351371E-01, 1.8335915359E-01, 4.8084511007E-01],
	[8.2900000000E+03, 4.7504999635E+00, 6.5635227409E+00, 1.9680586981E-01, 1.8368810575E-01, 4.8103915103E-01],
	[8.2950000000E+03, 4.7540417069E+00, 6.5625733968E+00, 1.9717870623E-01, 1.8401742000E-01, 4.8123316116E-01],
	[8.3000000000E+03, 4.7575839543E+00, 6.5616247620E+00, 1.9755202329E-01, 1.8434709643E-01, 4.8142714051E-01],
	[8.3050000000E+03, 4.7611267054E+00, 6.5606768355E+00, 1.9792582132E-01, 1.8467713511E-01, 4.8162108911E-01],
	[8.3100000000E+03, 4.7646699600E+00, 6.5597296163E+00, 1.9830010065E-01, 1.8500753613E-01, 4.8181500702E-01],
	[8.3150000000E+03, 4.7682137178E+00, 6.5587831035E+00, 1.9867486161E-01, 1.8533829956E-01, 4.8200889426E-01],
	[8.3200000000E+03, 4.7717579787E+00, 6.5578372962E+00, 1.9905010453E-01, 1.8566942548E-01, 4.8220275088E-01],
	[8.3250000000E+03, 4.7753027423E+00, 6.5568921934E+00, 1.9942582974E-01, 1.8600091397E-01, 4.8239657692E-01],
	[8.3300000000E+03, 4.7788480085E+00, 6.5559477941E+00, 1.9980203756E-01, 1.8633276511E-01, 4.8259037242E-01],
	[8.3350000000E+03, 4.7823937770E+00, 6.5550040973E+00, 2.0017872833E-01, 1.8666497897E-01, 4.8278413743E-01],
	[8.3400000000E+03, 4.7859443761E+00, 6.5540713244E+00, 2.0055590237E-01, 1.8699757056E-01, 4.8297787198E-01],
	[8.3450000000E+03, 4.7894956160E+00, 6.5531395618E+00, 2.0093356001E-01, 1.8733052559E-01, 4.8317157611E-01],
	[8.3500000000E+03, 4.7930473615E+00, 6.5522084897E+00, 2.0131170159E-01, 1.8766384367E-01, 4.8336524987E-01],
	[8.3550000000E+03, 4.7965996123E+00, 6.5512781071E+00, 2.0169032743E-01, 1.8799752487E-01, 4.8355889330E-01],
	[8.3600000000E+03, 4.8001523682E+00, 6.5503484131E+00, 2.0206943786E-01, 1.8833156928E-01, 4.8375250643E-01],
	[8.3650000000E+03, 4.8037056290E+00, 6.5494194068E+00, 2.0244903320E-01, 1.8866597696E-01, 4.8394608932E-01],
	[8.3700000000E+03, 4.8072593944E+00, 6.5484910873E+00, 2.0282911380E-01, 1.8900074799E-01, 4.8413964199E-01],
	[8.3750000000E+03, 4.8108136643E+00, 6.5475634536E+00, 2.0320967998E-01, 1.8933588245E-01, 4.8433316450E-01],
	[8.3800000000E+03, 4.8143684384E+00, 6.5466365049E+00, 2.0359073206E-01, 1.8967138041E-01, 4.8452665689E-01],
	[8.3850000000E+03, 4.8179237164E+00, 6.5457102401E+00, 2.0397227037E-01, 1.9000724195E-01, 4.8472011918E-01],
	[8.3900000000E+03, 4.8214794982E+00, 6.5447846585E+00, 2.0435429526E-01, 1.9034346714E-01, 4.8491355144E-01],
	[8.3950000000E+03, 4.8250357834E+00, 6.5438597591E+00, 2.0473680703E-01, 1.9068005605E-01, 4.8510695370E-01],
	[8.4000000000E+03, 4.8285925720E+00, 6.5429355409E+00, 2.0511980603E-01, 1.9101700877E-01, 4.8530032600E-01],
	[8.4050000000E+03, 4.8321498636E+00, 6.5420120032E+00, 2.0550329259E-01, 1.9135432535E-01, 4.8549366838E-01],
	[8.4100000000E+03, 4.8357076580E+00, 6.5410891449E+00, 2.0588726702E-01, 1.9169200588E-01, 4.8568698089E-01],
	[8.4150000000E+03, 4.8392659550E+00, 6.5401669652E+00, 2.0627172967E-01, 1.9203005043E-01, 4.8588026356E-01],
	[8.4200000000E+03, 4.8428247544E+00, 6.5392454631E+00, 2.0665668086E-01, 1.9236845906E-01, 4.8607351645E-01],
	[8.4250000000E+03, 4.8463840560E+00, 6.5383246379E+00, 2.0704212092E-01, 1.9270723186E-01, 4.8626673958E-01],
	[8.4300000000E+03, 4.8499438594E+00, 6.5374044885E+00, 2.0742805018E-01, 1.9304636889E-01, 4.8645993301E-01],
	[8.4350000000E+03, 4.8535041645E+00, 6.5364850140E+00, 2.0781446896E-01, 1.9338587022E-01, 4.8665309677E-01],
	[8.4400000000E+03, 4.8570649711E+00, 6.5355662137E+00, 2.0820137761E-01, 1.9372573593E-01, 4.8684623092E-01],
	[8.4450000000E+03, 4.8606262789E+00, 6.5346480865E+00, 2.0858877645E-01, 1.9406596608E-01, 4.8703933548E-01],
	[8.4500000000E+03, 4.8641880877E+00, 6.5337306317E+00, 2.0897666580E-01, 1.9440656075E-01, 4.8723241051E-01],
	[8.4550000000E+03, 4.8677503973E+00, 6.5328138482E+00, 2.0936504600E-01, 1.9474752000E-01, 4.8742545604E-01],
	[8.4600000000E+03, 4.8713132075E+00, 6.5318977353E+00, 2.0975391738E-01, 1.9508884391E-01, 4.8761847212E-01],
	[8.4650000000E+03, 4.8748765179E+00, 6.5309822920E+00, 2.1014328027E-01, 1.9543053254E-01, 4.8781145879E-01],
	[8.4700000000E+03, 4.8784409314E+00, 6.5300688723E+00, 2.1053313499E-01, 1.9577258815E-01, 4.8800441609E-01],
	[8.4750000000E+03, 4.8820097829E+00, 6.5291649602E+00, 2.1092348187E-01, 1.9611502297E-01, 4.8819734407E-01],
	[8.4800000000E+03, 4.8855791380E+00, 6.5282617061E+00, 2.1131432126E-01, 1.9645782281E-01, 4.8839024276E-01],
	[8.4850000000E+03, 4.8891489965E+00, 6.5273591094E+00, 2.1170565346E-01, 1.9680098775E-01, 4.8858311222E-01],
	[8.4900000000E+03, 4.8927193581E+00, 6.5264571691E+00, 2.1209755942E-01, 1.9714458749E-01, 4.8877595248E-01],
	[8.4950000000E+03, 4.8962902226E+00, 6.5255558842E+00, 2.1248996393E-01, 1.9748855680E-01, 4.8896876359E-01],
	[8.5000000000E+03, 4.8998615899E+00, 6.5246552541E+00, 2.1288286256E-01, 1.9783289164E-01, 4.8916154559E-01],
	[8.5050000000E+03, 4.9034334596E+00, 6.5237552778E+00, 2.1327625562E-01, 1.9817759207E-01, 4.8935429852E-01],
	[8.5100000000E+03, 4.9070058316E+00, 6.5228559545E+00, 2.1367014346E-01, 1.9852265815E-01, 4.8954702243E-01],
	[8.5150000000E+03, 4.9105787056E+00, 6.5219572832E+00, 2.1406452640E-01, 1.9886808996E-01, 4.8973971736E-01],
	[8.5200000000E+03, 4.9141520815E+00, 6.5210592632E+00, 2.1445940477E-01, 1.9921388756E-01, 4.8993238335E-01],
	[8.5250000000E+03, 4.9177259589E+00, 6.5201618936E+00, 2.1485477891E-01, 1.9956005101E-01, 4.9012502044E-01],
	[8.5300000000E+03, 4.9213003376E+00, 6.5192651735E+00, 2.1525064914E-01, 1.9990658038E-01, 4.9031762869E-01],
	[8.5350000000E+03, 4.9248752175E+00, 6.5183691022E+00, 2.1564701579E-01, 2.0025347574E-01, 4.9051020812E-01],
	[8.5400000000E+03, 4.9284505984E+00, 6.5174736786E+00, 2.1604387920E-01, 2.0060073715E-01, 4.9070275879E-01],
	[8.5450000000E+03, 4.9320264799E+00, 6.5165789021E+00, 2.1644123969E-01, 2.0094836467E-01, 4.9089528074E-01],
	[8.5500000000E+03, 4.9356028618E+00, 6.5156847717E+00, 2.1683909759E-01, 2.0129635837E-01, 4.9108777402E-01],
	[8.5550000000E+03, 4.9391797441E+00, 6.5147912866E+00, 2.1723745325E-01, 2.0164471831E-01, 4.9128023866E-01],
	[8.5600000000E+03, 4.9427571263E+00, 6.5138984460E+00, 2.1763630698E-01, 2.0199344456E-01, 4.9147267471E-01],
	[8.5650000000E+03, 4.9463350083E+00, 6.5130062490E+00, 2.1803565912E-01, 2.0234253718E-01, 4.9166508221E-01],
	[8.5700000000E+03, 4.9499133899E+00, 6.5121146948E+00, 2.1843550999E-01, 2.0269199623E-01, 4.9185746121E-01],
	[8.5750000000E+03, 4.9534922709E+00, 6.5112237825E+00, 2.1883585994E-01, 2.0304182178E-01, 4.9204981175E-01],
	[8.5800000000E+03, 4.9570716510E+00, 6.5103335114E+00, 2.1923670928E-01, 2.0339201387E-01, 4.9224213387E-01],
	[8.5850000000E+03, 4.9606515300E+00, 6.5094438805E+00, 2.1963805835E-01, 2.0374257259E-01, 4.9243442763E-01],
	[8.5900000000E+03, 4.9642319077E+00, 6.5085548890E+00, 2.2003990749E-01, 2.0409349799E-01, 4.9262669303E-01],
	[8.5950000000E+03, 4.9678127839E+00, 6.5076665362E+00, 2.2044225701E-01, 2.0444479012E-01, 4.9281893009E-01],
	[8.6000000000E+03, 4.9713941583E+00, 6.5067788211E+00, 2.2084510726E-01, 2.0479644906E-01, 4.9301113884E-01],
	[8.6050000000E+03, 4.9749760308E+00, 6.5058917430E+00, 2.2124845856E-01, 2.0514847486E-01, 4.9320331929E-01],
	[8.6100000000E+03, 4.9785623902E+00, 6.5050138198E+00, 2.2165231124E-01, 2.0550088288E-01, 4.9339547147E-01],
	[8.6150000000E+03, 4.9821498795E+00, 6.5041378664E+00, 2.2205666564E-01, 2.0585366038E-01, 4.9358759539E-01],
	[8.6200000000E+03, 4.9857378702E+00, 6.5032625390E+00, 2.2246152209E-01, 2.0620680503E-01, 4.9377969108E-01],
	[8.6250000000E+03, 4.9893263619E+00, 6.5023878369E+00, 2.2286688091E-01, 2.0656031688E-01, 4.9397175856E-01],
	[8.6300000000E+03, 4.9929153546E+00, 6.5015137593E+00, 2.2327274244E-01, 2.0691419599E-01, 4.9416379785E-01],
	[8.6350000000E+03, 4.9965048479E+00, 6.5006403054E+00, 2.2367910700E-01, 2.0726844242E-01, 4.9435580897E-01],
	[8.6400000000E+03, 5.0000948417E+00, 6.4997674743E+00, 2.2408597494E-01, 2.0762305623E-01, 4.9454779194E-01],
	[8.6450000000E+03, 5.0036853357E+00, 6.4988952653E+00, 2.2449334658E-01, 2.0797803748E-01, 4.9473974679E-01],
	[8.6500000000E+03, 5.0072763297E+00, 6.4980236775E+00, 2.2490122225E-01, 2.0833338622E-01, 4.9493167353E-01],
	[8.6550000000E+03, 5.0108678236E+00, 6.4971527102E+00, 2.2530960228E-01, 2.0868910251E-01, 4.9512357218E-01],
	[8.6600000000E+03, 5.0144598170E+00, 6.4962823625E+00, 2.2571848700E-01, 2.0904518641E-01, 4.9531544278E-01],
	[8.6650000000E+03, 5.0180523097E+00, 6.4954126337E+00, 2.2612787675E-01, 2.0940163797E-01, 4.9550728533E-01],
	[8.6700000000E+03, 5.0216453016E+00, 6.4945435229E+00, 2.2653777186E-01, 2.0975845726E-01, 4.9569909987E-01],
	[8.6750000000E+03, 5.0252387924E+00, 6.4936750295E+00, 2.2694817265E-01, 2.1011564432E-01, 4.9589088641E-01],
	[8.6800000000E+03, 5.0288327819E+00, 6.4928071524E+00, 2.2735907946E-01, 2.1047319922E-01, 4.9608264497E-01],
	[8.6850000000E+03, 5.0324272699E+00, 6.4919398911E+00, 2.2777049262E-01, 2.1083112200E-01, 4.9627437558E-01],
	[8.6900000000E+03, 5.0360222562E+00, 6.4910732446E+00, 2.2818241246E-01, 2.1118941273E-01, 4.9646607826E-01],
	[8.6950000000E+03, 5.0396177405E+00, 6.4902072123E+00, 2.2859483932E-01, 2.1154807145E-01, 4.9665775304E-01],
	[8.7000000000E+03, 5.0432137227E+00, 6.4893417932E+00, 2.2900777351E-01, 2.1190709823E-01, 4.9684939992E-01],
	[8.7050000000E+03, 5.0468102024E+00, 6.4884769867E+00, 2.2942121539E-01, 2.1226649311E-01, 4.9704101894E-01],
	[8.7100000000E+03, 5.0504071796E+00, 6.4876127919E+00, 2.2983516526E-01, 2.1262625615E-01, 4.9723261012E-01],
	[8.7150000000E+03, 5.0540046539E+00, 6.4867492081E+00, 2.3024962348E-01, 2.1298638740E-01, 4.9742417348E-01],
	[8.7200000000E+03, 5.0576026252E+00, 6.4858862344E+00, 2.3066459036E-01, 2.1334688692E-01, 4.9761570905E-01],
	[8.7250000000E+03, 5.0612010932E+00, 6.4850238701E+00, 2.3108006624E-01, 2.1370775476E-01, 4.9780721683E-01],
	[8.7300000000E+03, 5.0648000578E+00, 6.4841621144E+00, 2.3149605146E-01, 2.1406899096E-01, 4.9799869687E-01],
	[8.7350000000E+03, 5.0683995186E+00, 6.4833009666E+00, 2.3191254634E-01, 2.1443059559E-01, 4.9819014917E-01],
	[8.7400000000E+03, 5.0719994756E+00, 6.4824404258E+00, 2.3232955121E-01, 2.1479256869E-01, 4.9838157377E-01],
	[8.7450000000E+03, 5.0756006605E+00, 6.4815819786E+00, 2.3274706641E-01, 2.1515491327E-01, 4.9857297069E-01],
	[8.7500000000E+03, 5.0792063059E+00, 6.4807321833E+00, 2.3316509226E-01, 2.1551764248E-01, 4.9876433994E-01],
	[8.7550000000E+03, 5.0828124507E+00, 6.4798829847E+00, 2.3358362911E-01, 2.1588074042E-01, 4.9895568155E-01],
	[8.7600000000E+03, 5.0864190947E+00, 6.4790343821E+00, 2.3400267727E-01, 2.1624420715E-01, 4.9914699555E-01],
	[8.7650000000E+03, 5.0900262377E+00, 6.4781863748E+00, 2.3442223709E-01, 2.1660804271E-01, 4.9933828196E-01],
	[8.7700000000E+03, 5.0936338795E+00, 6.4773389620E+00, 2.3484230889E-01, 2.1697224716E-01, 4.9952954080E-01],
	[8.7750000000E+03, 5.0972420199E+00, 6.4764921429E+00, 2.3526289301E-01, 2.1733682054E-01, 4.9972077208E-01],
	[8.7800000000E+03, 5.1008506586E+00, 6.4756459168E+00, 2.3568398978E-01, 2.1770176290E-01, 4.9991197585E-01],
	[8.7850000000E+03, 5.1044597955E+00, 6.4748002830E+00, 2.3610559952E-01, 2.1806707430E-01, 5.0010315212E-01],
	[8.7900000000E+03, 5.1080694303E+00, 6.4739552407E+00, 2.3652772257E-01, 2.1843275477E-01, 5.0029430091E-01],
	[8.7950000000E+03, 5.1116795628E+00, 6.4731107891E+00, 2.3695035927E-01, 2.1879880438E-01, 5.0048542224E-01],
	[8.8000000000E+03, 5.1152901928E+00, 6.4722669275E+00, 2.3737350994E-01, 2.1916522316E-01, 5.0067651615E-01],
	[8.8050000000E+03, 5.1189013200E+00, 6.4714236551E+00, 2.3779717492E-01, 2.1953201116E-01, 5.0086758265E-01],
	[8.8100000000E+03, 5.1225129444E+00, 6.4705809712E+00, 2.3822135454E-01, 2.1989916843E-01, 5.0105862177E-01],
	[8.8150000000E+03, 5.1261250655E+00, 6.4697388752E+00, 2.3864604912E-01, 2.2026669502E-01, 5.0124963353E-01],
	[8.8200000000E+03, 5.1297376834E+00, 6.4688973661E+00, 2.3907125901E-01, 2.2063459097E-01, 5.0144061795E-01],
	[8.8250000000E+03, 5.1333507976E+00, 6.4680564433E+00, 2.3949698453E-01, 2.2100285634E-01, 5.0163157506E-01],
	[8.8300000000E+03, 5.1369644081E+00, 6.4672161060E+00, 2.3992322601E-01, 2.2137149116E-01, 5.0182250489E-01],
	[8.8350000000E+03, 5.1405785146E+00, 6.4663763535E+00, 2.4034998380E-01, 2.2174049547E-01, 5.0201340745E-01],
	[8.8400000000E+03, 5.1441931168E+00, 6.4655371851E+00, 2.4077725821E-01, 2.2210986934E-01, 5.0220428277E-01],
	[8.8450000000E+03, 5.1478082146E+00, 6.4646985999E+00, 2.4120504959E-01, 2.2247961279E-01, 5.0239513087E-01],
	[8.8500000000E+03, 5.1514238078E+00, 6.4638605974E+00, 2.4163335825E-01, 2.2284972588E-01, 5.0258595178E-01],
	[8.8550000000E+03, 5.1550398962E+00, 6.4630231767E+00, 2.4206218455E-01, 2.2322020865E-01, 5.0277674553E-01],
	[8.8600000000E+03, 5.1586564795E+00, 6.4621863372E+00, 2.4249152880E-01, 2.2359106114E-01, 5.0296751213E-01],
	[8.8650000000E+03, 5.1622735575E+00, 6.4613500780E+00, 2.4292139134E-01, 2.2396228340E-01, 5.0315825161E-01],
	[8.8700000000E+03, 5.1658911300E+00, 6.4605143985E+00, 2.4335177250E-01, 2.2433387546E-01, 5.0334896400E-01],
	[8.8750000000E+03, 5.1695091968E+00, 6.4596792979E+00, 2.4378267262E-01, 2.2470583738E-01, 5.0353964931E-01],
	[8.8800000000E+03, 5.1731277577E+00, 6.4588447755E+00, 2.4421409203E-01, 2.2507816918E-01, 5.0373030758E-01],
	[8.8850000000E+03, 5.1767468217E+00, 6.4580108483E+00, 2.4464603105E-01, 2.2545087097E-01, 5.0392093883E-01],
	[8.8900000000E+03, 5.1803711455E+00, 6.4571866988E+00, 2.4507849002E-01, 2.2582396304E-01, 5.0411154308E-01],
	[8.8950000000E+03, 5.1839959667E+00, 6.4563631177E+00, 2.4551146927E-01, 2.2619742524E-01, 5.0430212036E-01],
	[8.9000000000E+03, 5.1876212852E+00, 6.4555401044E+00, 2.4594496915E-01, 2.2657125761E-01, 5.0449267070E-01],
	[8.9050000000E+03, 5.1912471007E+00, 6.4547176582E+00, 2.4637898996E-01, 2.2694546020E-01, 5.0468319410E-01],
	[8.9100000000E+03, 5.1948734130E+00, 6.4538957783E+00, 2.4681353206E-01, 2.2732003304E-01, 5.0487369064E-01],
	[8.9150000000E+03, 5.1985002219E+00, 6.4530744641E+00, 2.4724859577E-01, 2.2769497617E-01, 5.0506416047E-01],
	[8.9200000000E+03, 5.2021275272E+00, 6.4522537148E+00, 2.4768418143E-01, 2.2807028964E-01, 5.0525460364E-01],
	[8.9250000000E+03, 5.2057553287E+00, 6.4514335298E+00, 2.4812028936E-01, 2.2844597348E-01, 5.0544502015E-01],
	[8.9300000000E+03, 5.2093836262E+00, 6.4506139082E+00, 2.4855691990E-01, 2.2882202773E-01, 5.0563540998E-01],
	[8.9350000000E+03, 5.2130124195E+00, 6.4497948495E+00, 2.4899407338E-01, 2.2919845244E-01, 5.0582577315E-01],
	[8.9400000000E+03, 5.2166417083E+00, 6.4489763530E+00, 2.4943175014E-01, 2.2957524764E-01, 5.0601610965E-01],
	[8.9450000000E+03, 5.2202714925E+00, 6.4481584178E+00, 2.4986995050E-01, 2.2995241336E-01, 5.0620641947E-01],
	[8.9500000000E+03, 5.2239017718E+00, 6.4473410434E+00, 2.5030867481E-01, 2.3032994965E-01, 5.0639670262E-01],
	[8.9550000000E+03, 5.2275325460E+00, 6.4465242290E+00, 2.5074792338E-01, 2.3070785654E-01, 5.0658695909E-01],
	[8.9600000000E+03, 5.2311638149E+00, 6.4457079740E+00, 2.5118769656E-01, 2.3108613407E-01, 5.0677718889E-01],
	[8.9650000000E+03, 5.2347955784E+00, 6.4448922776E+00, 2.5162799468E-01, 2.3146478228E-01, 5.0696739201E-01],
	[8.9700000000E+03, 5.2384278362E+00, 6.4440771391E+00, 2.5206881807E-01, 2.3184380121E-01, 5.0715756844E-01],
	[8.9750000000E+03, 5.2420605880E+00, 6.4432625579E+00, 2.5251016705E-01, 2.3222319088E-01, 5.0734771819E-01],
	[8.9800000000E+03, 5.2456938338E+00, 6.4424485332E+00, 2.5295204198E-01, 2.3260295133E-01, 5.0753784126E-01],
	[8.9850000000E+03, 5.2493275732E+00, 6.4416350645E+00, 2.5339444317E-01, 2.3298308261E-01, 5.0772793765E-01],
	[8.9900000000E+03, 5.2529618061E+00, 6.4408221509E+00, 2.5383737096E-01, 2.3336358474E-01, 5.0791800735E-01],
	[8.9950000000E+03, 5.2565965323E+00, 6.4400097918E+00, 2.5428082569E-01, 2.3374445777E-01, 5.0810805036E-01],
	[9.0000000000E+03, 5.2602317515E+00, 6.4391979865E+00, 2.5472480768E-01, 2.3412570171E-01, 5.0829806669E-01],
	[9.0050000000E+03, 5.2638674636E+00, 6.4383867343E+00, 2.5517101914E-01, 2.3450875404E-01, 5.0848805632E-01],
	[9.0100000000E+03, 5.2675036683E+00, 6.4375760346E+00, 2.5561776360E-01, 2.3489218097E-01, 5.0867801927E-01],
	[9.0150000000E+03, 5.2711403654E+00, 6.4367658866E+00, 2.5606504138E-01, 2.3527598252E-01, 5.0886795553E-01],
	[9.0200000000E+03, 5.2747775548E+00, 6.4359562898E+00, 2.5651285283E-01, 2.3566015875E-01, 5.0905786510E-01],
	[9.0250000000E+03, 5.2784152362E+00, 6.4351472433E+00, 2.5696119828E-01, 2.3604470968E-01, 5.0924774797E-01],
	[9.0300000000E+03, 5.2820553446E+00, 6.4343422730E+00, 2.5741007808E-01, 2.3642964398E-01, 5.0943760416E-01],
	[9.0350000000E+03, 5.2856989153E+00, 6.4335432553E+00, 2.5785949257E-01, 2.3681496639E-01, 5.0962743365E-01],
	[9.0400000000E+03, 5.2893429816E+00, 6.4327447788E+00, 2.5830944208E-01, 2.3720066373E-01, 5.0981723645E-01],
	[9.0450000000E+03, 5.2929875431E+00, 6.4319468429E+00, 2.5875992695E-01, 2.3758673602E-01, 5.1000701256E-01],
	[9.0500000000E+03, 5.2966325996E+00, 6.4311494468E+00, 2.5921094753E-01, 2.3797318331E-01, 5.1019676198E-01],
	[9.0550000000E+03, 5.3002781509E+00, 6.4303525899E+00, 2.5966250416E-01, 2.3836000563E-01, 5.1038648470E-01],
	[9.0600000000E+03, 5.3039241969E+00, 6.4295562716E+00, 2.6011459717E-01, 2.3874720300E-01, 5.1057618073E-01],
	[9.0650000000E+03, 5.3075707373E+00, 6.4287604911E+00, 2.6056722691E-01, 2.3913477546E-01, 5.1076585007E-01],
	[9.0700000000E+03, 5.3112177718E+00, 6.4279652479E+00, 2.6102039371E-01, 2.3952272305E-01, 5.1095549272E-01],
	[9.0750000000E+03, 5.3148653004E+00, 6.4271705412E+00, 2.6147409791E-01, 2.3991104579E-01, 5.1114510867E-01],
	[9.0800000000E+03, 5.3185133228E+00, 6.4263763705E+00, 2.6192833987E-01, 2.4029974371E-01, 5.1133469793E-01],
	[9.0850000000E+03, 5.3221618388E+00, 6.4255827349E+00, 2.6238311990E-01, 2.4068881685E-01, 5.1152426050E-01],
	[9.0900000000E+03, 5.3258108482E+00, 6.4247896340E+00, 2.6283843837E-01, 2.4107826524E-01, 5.1171379638E-01],
	[9.0950000000E+03, 5.3294603508E+00, 6.4239970670E+00, 2.6329429560E-01, 2.4146808891E-01, 5.1190330557E-01],
	[9.1000000000E+03, 5.3331103463E+00, 6.4232050333E+00, 2.6375069193E-01, 2.4185828788E-01, 5.1209278807E-01],
	[9.1050000000E+03, 5.3367608347E+00, 6.4224135323E+00, 2.6420762772E-01, 2.4224886219E-01, 5.1228224388E-01],
	[9.1100000000E+03, 5.3404118156E+00, 6.4216225632E+00, 2.6466510328E-01, 2.4263981186E-01, 5.1247167300E-01],
	[9.1150000000E+03, 5.3440632888E+00, 6.4208321255E+00, 2.6512311898E-01, 2.4303113693E-01, 5.1266107543E-01],
	[9.1200000000E+03, 5.3477152543E+00, 6.4200422184E+00, 2.6558167514E-01, 2.4342283743E-01, 5.1285045118E-01],
	[9.1250000000E+03, 5.3513677117E+00, 6.4192528414E+00, 2.6604077211E-01, 2.4381491337E-01, 5.1303980024E-01],
	[9.1300000000E+03, 5.3550206608E+00, 6.4184639938E+00, 2.6650041023E-01, 2.4420736479E-01, 5.1322912261E-01],
	[9.1350000000E+03, 5.3586741015E+00, 6.4176756749E+00, 2.6696058983E-01, 2.4460019172E-01, 5.1341841830E-01],
	[9.1400000000E+03, 5.3623280336E+00, 6.4168878842E+00, 2.6742131127E-01, 2.4499339418E-01, 5.1360768731E-01],
	[9.1450000000E+03, 5.3659824568E+00, 6.4161006209E+00, 2.6788257487E-01, 2.4538697220E-01, 5.1379692964E-01],
	[9.1500000000E+03, 5.3696373710E+00, 6.4153138844E+00, 2.6834438099E-01, 2.4578092581E-01, 5.1398614529E-01],
	[9.1550000000E+03, 5.3732927759E+00, 6.4145276741E+00, 2.6880672995E-01, 2.4617525502E-01, 5.1417533425E-01],
	[9.1600000000E+03, 5.3769486713E+00, 6.4137419894E+00, 2.6926962210E-01, 2.4656995988E-01, 5.1436449654E-01],
	[9.1650000000E+03, 5.3806050571E+00, 6.4129568295E+00, 2.6973305779E-01, 2.4696504040E-01, 5.1455363216E-01],
	[9.1700000000E+03, 5.3842619330E+00, 6.4121721940E+00, 2.7019703734E-01, 2.4736049660E-01, 5.1474274110E-01],
	[9.1750000000E+03, 5.3879209808E+00, 6.4113909276E+00, 2.7066156111E-01, 2.4775633632E-01, 5.1493182337E-01],
	[9.1800000000E+03, 5.3915839844E+00, 6.4106160390E+00, 2.7112662943E-01, 2.4815256794E-01, 5.1512087897E-01],
	[9.1850000000E+03, 5.3952474818E+00, 6.4098416660E+00, 2.7159224265E-01, 2.4854917544E-01, 5.1530990789E-01],
	[9.1900000000E+03, 5.3989114726E+00, 6.4090678078E+00, 2.7205840110E-01, 2.4894615886E-01, 5.1549891016E-01],
	[9.1950000000E+03, 5.4025759568E+00, 6.4082944640E+00, 2.7252510512E-01, 2.4934351821E-01, 5.1568788575E-01],
	[9.2000000000E+03, 5.4062409341E+00, 6.4075216338E+00, 2.7299235506E-01, 2.4974125352E-01, 5.1587683469E-01],
	[9.2050000000E+03, 5.4099064043E+00, 6.4067493166E+00, 2.7346015126E-01, 2.5013936481E-01, 5.1606575696E-01],
	[9.2100000000E+03, 5.4135723672E+00, 6.4059775118E+00, 2.7392849405E-01, 2.5053785210E-01, 5.1625465257E-01],
	[9.2150000000E+03, 5.4172388226E+00, 6.4052062188E+00, 2.7439738378E-01, 2.5093671542E-01, 5.1644352153E-01],
	[9.2200000000E+03, 5.4209057703E+00, 6.4044354370E+00, 2.7486682079E-01, 2.5133595479E-01, 5.1663236383E-01],
	[9.2250000000E+03, 5.4245732102E+00, 6.4036651657E+00, 2.7533680542E-01, 2.5173557022E-01, 5.1682117948E-01],
	[9.2300000000E+03, 5.4282411419E+00, 6.4028954044E+00, 2.7580733802E-01, 2.5213556175E-01, 5.1700996848E-01],
	[9.2350000000E+03, 5.4319095654E+00, 6.4021261524E+00, 2.7627841891E-01, 2.5253592938E-01, 5.1719873084E-01],
	[9.2400000000E+03, 5.4355784803E+00, 6.4013574092E+00, 2.7675004844E-01, 2.5293667315E-01, 5.1738746655E-01],
	[9.2450000000E+03, 5.4392478866E+00, 6.4005891740E+00, 2.7722222696E-01, 2.5333779306E-01, 5.1757617562E-01],
	[9.2500000000E+03, 5.4429177839E+00, 6.3998214464E+00, 2.7769495480E-01, 2.5373928915E-01, 5.1776485805E-01],
	[9.2550000000E+03, 5.4465881722E+00, 6.3990542256E+00, 2.7816823231E-01, 2.5414116142E-01, 5.1795351384E-01],
	[9.2600000000E+03, 5.4502590511E+00, 6.3982875111E+00, 2.7864205983E-01, 2.5454340990E-01, 5.1814214300E-01],
	[9.2650000000E+03, 5.4539304206E+00, 6.3975213023E+00, 2.7911643769E-01, 2.5494603461E-01, 5.1833074553E-01],
	[9.2700000000E+03, 5.4576022804E+00, 6.3967555985E+00, 2.7959136624E-01, 2.5534903556E-01, 5.1851932144E-01],
	[9.2750000000E+03, 5.4612746303E+00, 6.3959903992E+00, 2.8006684582E-01, 2.5575241277E-01, 5.1870787071E-01],
	[9.2800000000E+03, 5.4649474701E+00, 6.3952257038E+00, 2.8054287678E-01, 2.5615616626E-01, 5.1889639337E-01],
	[9.2850000000E+03, 5.4686207996E+00, 6.3944615116E+00, 2.8101945944E-01, 2.5656029605E-01, 5.1908488941E-01],
	[9.2900000000E+03, 5.4722946186E+00, 6.3936978221E+00, 2.8149659416E-01, 2.5696480215E-01, 5.1927335884E-01],
	[9.2950000000E+03, 5.4759689269E+00, 6.3929346346E+00, 2.8197428127E-01, 2.5736968458E-01, 5.1946180165E-01],
	[9.3000000000E+03, 5.4796437244E+00, 6.3921719486E+00, 2.8245252112E-01, 2.5777494335E-01, 5.1965021786E-01],
	[9.3050000000E+03, 5.4833190108E+00, 6.3914097634E+00, 2.8293131405E-01, 2.5818057849E-01, 5.1983860746E-01],
	[9.3100000000E+03, 5.4869947859E+00, 6.3906480785E+00, 2.8341066039E-01, 2.5858659000E-01, 5.2002697046E-01],
	[9.3150000000E+03, 5.4906710495E+00, 6.3898868932E+00, 2.8389056050E-01, 2.5899297790E-01, 5.2021530686E-01],
	[9.3200000000E+03, 5.4943478014E+00, 6.3891262070E+00, 2.8437101470E-01, 2.5939974221E-01, 5.2040361667E-01],
	[9.3250000000E+03, 5.4980293184E+00, 6.3883727325E+00, 2.8485202335E-01, 2.5980690358E-01, 5.2059189989E-01],
	[9.3300000000E+03, 5.5017124562E+00, 6.3876215221E+00, 2.8533358678E-01, 2.6021444697E-01, 5.2078015652E-01],
	[9.3350000000E+03, 5.5053960862E+00, 6.3868708025E+00, 2.8581570534E-01, 2.6062236694E-01, 5.2096838657E-01],
	[9.3400000000E+03, 5.5090802080E+00, 6.3861205730E+00, 2.8629837937E-01, 2.6103066351E-01, 5.2115659004E-01],
	[9.3450000000E+03, 5.5127648214E+00, 6.3853708332E+00, 2.8678160920E-01, 2.6143933669E-01, 5.2134476694E-01],
	[9.3500000000E+03, 5.5164499264E+00, 6.3846215823E+00, 2.8726539519E-01, 2.6184838649E-01, 5.2153291727E-01],
	[9.3550000000E+03, 5.5201355226E+00, 6.3838728198E+00, 2.8774973766E-01, 2.6225781292E-01, 5.2172104103E-01],
	[9.3600000000E+03, 5.5238216100E+00, 6.3831245451E+00, 2.8823463697E-01, 2.6266761600E-01, 5.2190913823E-01],
	[9.3650000000E+03, 5.5275081882E+00, 6.3823767577E+00, 2.8872009345E-01, 2.6307779575E-01, 5.2209720887E-01],
	[9.3700000000E+03, 5.5311952571E+00, 6.3816294569E+00, 2.8920610745E-01, 2.6348835216E-01, 5.2228525296E-01],
	[9.3750000000E+03, 5.5348828164E+00, 6.3808826423E+00, 2.8969267931E-01, 2.6389928525E-01, 5.2247327050E-01],
	[9.3800000000E+03, 5.5385708661E+00, 6.3801363132E+00, 2.9017980937E-01, 2.6431059504E-01, 5.2266126150E-01],
	[9.3850000000E+03, 5.5422594059E+00, 6.3793904690E+00, 2.9066749797E-01, 2.6472228152E-01, 5.2284922595E-01],
	[9.3900000000E+03, 5.5459484356E+00, 6.3786451092E+00, 2.9115574545E-01, 2.6513434472E-01, 5.2303716387E-01],
	[9.3950000000E+03, 5.5496379550E+00, 6.3779002332E+00, 2.9164455216E-01, 2.6554678464E-01, 5.2322507526E-01],
	[9.4000000000E+03, 5.5533279639E+00, 6.3771558404E+00, 2.9213391843E-01, 2.6595960129E-01, 5.2341296012E-01],
	[9.4050000000E+03, 5.5570184621E+00, 6.3764119303E+00, 2.9262384462E-01, 2.6637279468E-01, 5.2360081846E-01],
	[9.4100000000E+03, 5.5607094495E+00, 6.3756685023E+00, 2.9311433105E-01, 2.6678636482E-01, 5.2378865029E-01],
	[9.4150000000E+03, 5.5644009258E+00, 6.3749255558E+00, 2.9360537808E-01, 2.6720031172E-01, 5.2397645560E-01],
	[9.4200000000E+03, 5.5680928908E+00, 6.3741830902E+00, 2.9409698604E-01, 2.6761463537E-01, 5.2416423441E-01],
	[9.4250000000E+03, 5.5717853443E+00, 6.3734411051E+00, 2.9458915527E-01, 2.6802933580E-01, 5.2435198671E-01],
	[9.4300000000E+03, 5.5754782862E+00, 6.3726995998E+00, 2.9508188613E-01, 2.6844441300E-01, 5.2453971252E-01],
	[9.4350000000E+03, 5.5791717162E+00, 6.3719585737E+00, 2.9557517894E-01, 2.6885986699E-01, 5.2472741184E-01],
	[9.4400000000E+03, 5.5828656342E+00, 6.3712180263E+00, 2.9606903406E-01, 2.6927569777E-01, 5.2491508467E-01],
	[9.4450000000E+03, 5.5865600400E+00, 6.3704779571E+00, 2.9656345182E-01, 2.6969190535E-01, 5.2510273102E-01],
	[9.4500000000E+03, 5.5902549333E+00, 6.3697383654E+00, 2.9705843256E-01, 2.7010848973E-01, 5.2529035090E-01],
	[9.4550000000E+03, 5.5939503140E+00, 6.3689992507E+00, 2.9755397664E-01, 2.7052545091E-01, 5.2547794430E-01],
	[9.4600000000E+03, 5.5976461818E+00, 6.3682606125E+00, 2.9805008438E-01, 2.7094278891E-01, 5.2566551124E-01],
	[9.4650000000E+03, 5.6013425367E+00, 6.3675224502E+00, 2.9854675614E-01, 2.7136050372E-01, 5.2585305172E-01],
	[9.4700000000E+03, 5.6050393783E+00, 6.3667847632E+00, 2.9904399225E-01, 2.7177859536E-01, 5.2604056575E-01],
	[9.4750000000E+03, 5.6087411271E+00, 6.3660540033E+00, 2.9954179306E-01, 2.7219708602E-01, 5.2622805333E-01],
	[9.4800000000E+03, 5.6124446136E+00, 6.3653255327E+00, 3.0004015891E-01, 2.7261595991E-01, 5.2641551447E-01],
	[9.4850000000E+03, 5.6161485908E+00, 6.3645975295E+00, 3.0053909014E-01, 2.7303521078E-01, 5.2660294917E-01],
	[9.4900000000E+03, 5.6198530585E+00, 6.3638699932E+00, 3.0103858709E-01, 2.7345483862E-01, 5.2679035744E-01],
	[9.4950000000E+03, 5.6235580165E+00, 6.3631429232E+00, 3.0153865011E-01, 2.7387484345E-01, 5.2697773928E-01],
	[9.5000000000E+03, 5.6272634646E+00, 6.3624163190E+00, 3.0203927954E-01, 2.7429522527E-01, 5.2716509471E-01],
	[9.5050000000E+03, 5.6309694027E+00, 6.3616901799E+00, 3.0254047571E-01, 2.7471598407E-01, 5.2735242373E-01],
	[9.5100000000E+03, 5.6346758305E+00, 6.3609645056E+00, 3.0304223898E-01, 2.7513711986E-01, 5.2753972633E-01],
	[9.5150000000E+03, 5.6383827478E+00, 6.3602392954E+00, 3.0354456969E-01, 2.7555863264E-01, 5.2772700254E-01],
	[9.5200000000E+03, 5.6420901545E+00, 6.3595145489E+00, 3.0404746817E-01, 2.7598052241E-01, 5.2791425235E-01],
	[9.5250000000E+03, 5.6457980504E+00, 6.3587902653E+00, 3.0455093477E-01, 2.7640278917E-01, 5.2810147577E-01],
	[9.5300000000E+03, 5.6495064352E+00, 6.3580664443E+00, 3.0505496984E-01, 2.7682543292E-01, 5.2828867271E-01],
	[9.5350000000E+03, 5.6532153088E+00, 6.3573430853E+00, 3.0555957371E-01, 2.7724845367E-01, 5.2847584315E-01],
	[9.5400000000E+03, 5.6569246709E+00, 6.3566201878E+00, 3.0606474673E-01, 2.7767185140E-01, 5.2866298705E-01],
	[9.5450000000E+03, 5.6606345215E+00, 6.3558977512E+00, 3.0657048923E-01, 2.7809562613E-01, 5.2885010441E-01],
	[9.5500000000E+03, 5.6643448602E+00, 6.3551757749E+00, 3.0707680157E-01, 2.7851977784E-01, 5.2903719520E-01],
	[9.5550000000E+03, 5.6680556869E+00, 6.3544542585E+00, 3.0758368409E-01, 2.7894430654E-01, 5.2922425941E-01],
	[9.5600000000E+03, 5.6717670015E+00, 6.3537332014E+00, 3.0809113712E-01, 2.7936921223E-01, 5.2941129701E-01],
	[9.5650000000E+03, 5.6754788037E+00, 6.3530126031E+00, 3.0859916102E-01, 2.7979449490E-01, 5.2959830799E-01],
	[9.5700000000E+03, 5.6791910933E+00, 6.3522924630E+00, 3.0910775611E-01, 2.8022015454E-01, 5.2978529233E-01],
	[9.5750000000E+03, 5.6829038701E+00, 6.3515727806E+00, 3.0961692276E-01, 2.8064619117E-01, 5.2997225000E-01],
	[9.5800000000E+03, 5.6866171340E+00, 6.3508535555E+00, 3.1012666129E-01, 2.8107260477E-01, 5.3015918100E-01],
	[9.5850000000E+03, 5.6903308848E+00, 6.3501347869E+00, 3.1063697205E-01, 2.8149939533E-01, 5.3034608530E-01],
	[9.5900000000E+03, 5.6940451222E+00, 6.3494164746E+00, 3.1114785539E-01, 2.8192656287E-01, 5.3053296287E-01],
	[9.5950000000E+03, 5.6977598461E+00, 6.3486986178E+00, 3.1165931164E-01, 2.8235410736E-01, 5.3071981372E-01],
	[9.6000000000E+03, 5.7014750563E+00, 6.3479812161E+00, 3.1217134115E-01, 2.8278202881E-01, 5.3090663781E-01],
	[9.6050000000E+03, 5.7051907526E+00, 6.3472642689E+00, 3.1268394427E-01, 2.8321032721E-01, 5.3109343512E-01],
	[9.6100000000E+03, 5.7089069348E+00, 6.3465477758E+00, 3.1319712133E-01, 2.8363900255E-01, 5.3128020565E-01],
	[9.6150000000E+03, 5.7126236028E+00, 6.3458317362E+00, 3.1371087268E-01, 2.8406805484E-01, 5.3146694936E-01],
	[9.6200000000E+03, 5.7163407562E+00, 6.3451161496E+00, 3.1422519866E-01, 2.8449748405E-01, 5.3165366625E-01],
	[9.6250000000E+03, 5.7200600886E+00, 6.3444033191E+00, 3.1474009962E-01, 2.8492729904E-01, 5.3184035629E-01],
	[9.6300000000E+03, 5.7237841464E+00, 6.3436967004E+00, 3.1525557589E-01, 2.8535751319E-01, 5.3202701947E-01],
	[9.6350000000E+03, 5.7275086937E+00, 6.3429905270E+00, 3.1577162782E-01, 2.8578810440E-01, 5.3221365577E-01],
	[9.6400000000E+03, 5.7312337304E+00, 6.3422847986E+00, 3.1628825576E-01, 2.8621907268E-01, 5.3240026517E-01],
	[9.6450000000E+03, 5.7349592564E+00, 6.3415795146E+00, 3.1680546004E-01, 2.8665041801E-01, 5.3258684765E-01],
	[9.6500000000E+03, 5.7386852714E+00, 6.3408746745E+00, 3.1732324101E-01, 2.8708214038E-01, 5.3277340320E-01],
	[9.6550000000E+03, 5.7424117752E+00, 6.3401702778E+00, 3.1784159902E-01, 2.8751423978E-01, 5.3295993179E-01],
	[9.6600000000E+03, 5.7461387677E+00, 6.3394663240E+00, 3.1836053440E-01, 2.8794671622E-01, 5.3314643342E-01],
	[9.6650000000E+03, 5.7498662487E+00, 6.3387628125E+00, 3.1888004749E-01, 2.8837956967E-01, 5.3333290805E-01],
	[9.6700000000E+03, 5.7535942179E+00, 6.3380597429E+00, 3.1940013866E-01, 2.8881280013E-01, 5.3351935568E-01],
	[9.6750000000E+03, 5.7573226752E+00, 6.3373571147E+00, 3.1992080822E-01, 2.8924640758E-01, 5.3370577630E-01],
	[9.6800000000E+03, 5.7610516204E+00, 6.3366549273E+00, 3.2044205654E-01, 2.8968039203E-01, 5.3389216987E-01],
	[9.6850000000E+03, 5.7647810533E+00, 6.3359531803E+00, 3.2096388394E-01, 2.9011475345E-01, 5.3407853638E-01],
	[9.6900000000E+03, 5.7685109737E+00, 6.3352518731E+00, 3.2148629078E-01, 2.9054949184E-01, 5.3426487582E-01],
	[9.6950000000E+03, 5.7722413815E+00, 6.3345510052E+00, 3.2200927740E-01, 2.9098460719E-01, 5.3445118817E-01],
	[9.7000000000E+03, 5.7759722764E+00, 6.3338505762E+00, 3.2253284414E-01, 2.9142009947E-01, 5.3463747341E-01],
	[9.7050000000E+03, 5.7797036583E+00, 6.3331505856E+00, 3.2305699135E-01, 2.9185596869E-01, 5.3482373153E-01],
	[9.7100000000E+03, 5.7834355269E+00, 6.3324510327E+00, 3.2358171936E-01, 2.9229221483E-01, 5.3500996251E-01],
	[9.7150000000E+03, 5.7871678822E+00, 6.3317519173E+00, 3.2410702853E-01, 2.9272883787E-01, 5.3519616633E-01],
	[9.7200000000E+03, 5.7909007238E+00, 6.3310532386E+00, 3.2463291919E-01, 2.9316583781E-01, 5.3538234297E-01],
	[9.7250000000E+03, 5.7946340516E+00, 6.3303549963E+00, 3.2515939169E-01, 2.9360321462E-01, 5.3556849243E-01],
	[9.7300000000E+03, 5.7983678655E+00, 6.3296571899E+00, 3.2568644637E-01, 2.9404096831E-01, 5.3575461467E-01],
	[9.7350000000E+03, 5.8021021652E+00, 6.3289598188E+00, 3.2621408358E-01, 2.9447909884E-01, 5.3594070969E-01],
	[9.7400000000E+03, 5.8058369505E+00, 6.3282628826E+00, 3.2674230366E-01, 2.9491760621E-01, 5.3612677747E-01],
	[9.7450000000E+03, 5.8095722213E+00, 6.3275663807E+00, 3.2727110695E-01, 2.9535649040E-01, 5.3631281800E-01],
	[9.7500000000E+03, 5.8133079774E+00, 6.3268703127E+00, 3.2780049379E-01, 2.9579575139E-01, 5.3649883125E-01],
	[9.7550000000E+03, 5.8170442186E+00, 6.3261746781E+00, 3.2833046454E-01, 2.9623538918E-01, 5.3668481721E-01],
	[9.7600000000E+03, 5.8207809446E+00, 6.3254794764E+00, 3.2886101953E-01, 2.9667540374E-01, 5.3687077587E-01],
	[9.7650000000E+03, 5.8245181554E+00, 6.3247847071E+00, 3.2939215911E-01, 2.9711579506E-01, 5.3705670720E-01],
	[9.7700000000E+03, 5.8282558508E+00, 6.3240903696E+00, 3.2992388361E-01, 2.9755656312E-01, 5.3724261120E-01],
	[9.7750000000E+03, 5.8319940305E+00, 6.3233964636E+00, 3.3045619340E-01, 2.9799770790E-01, 5.3742848785E-01],
	[9.7800000000E+03, 5.8357345552E+00, 6.3227053503E+00, 3.3098908880E-01, 2.9843923952E-01, 5.3761433712E-01],
	[9.7850000000E+03, 5.8394799032E+00, 6.3220201673E+00, 3.3152257016E-01, 2.9888117154E-01, 5.3780015901E-01],
	[9.7900000000E+03, 5.8432257398E+00, 6.3213354085E+00, 3.3205663783E-01, 2.9932348040E-01, 5.3798595351E-01],
	[9.7950000000E+03, 5.8469720648E+00, 6.3206510735E+00, 3.3259129215E-01, 2.9976616607E-01, 5.3817172058E-01],
	[9.8000000000E+03, 5.8507188780E+00, 6.3199671617E+00, 3.3312653346E-01, 3.0020922854E-01, 5.3835746022E-01],
	[9.8050000000E+03, 5.8544661792E+00, 6.3192836727E+00, 3.3366236212E-01, 3.0065266780E-01, 5.3854317242E-01],
	[9.8100000000E+03, 5.8582139683E+00, 6.3186006060E+00, 3.3419877845E-01, 3.0109648381E-01, 5.3872885716E-01],
	[9.8150000000E+03, 5.8619622450E+00, 6.3179179612E+00, 3.3473578281E-01, 3.0154067657E-01, 5.3891451442E-01],
	[9.8200000000E+03, 5.8657110091E+00, 6.3172357377E+00, 3.3527337553E-01, 3.0198524605E-01, 5.3910014418E-01],
	[9.8250000000E+03, 5.8694602606E+00, 6.3165539351E+00, 3.3581155697E-01, 3.0243019223E-01, 5.3928574644E-01],
	[9.8300000000E+03, 5.8732099991E+00, 6.3158725529E+00, 3.3635032747E-01, 3.0287551509E-01, 5.3947132117E-01],
	[9.8350000000E+03, 5.8769602245E+00, 6.3151915907E+00, 3.3688968737E-01, 3.0332121461E-01, 5.3965686837E-01],
	[9.8400000000E+03, 5.8807109367E+00, 6.3145110479E+00, 3.3742963701E-01, 3.0376729077E-01, 5.3984238801E-01],
	[9.8450000000E+03, 5.8844621354E+00, 6.3138309241E+00, 3.3797017675E-01, 3.0421374355E-01, 5.4002788009E-01],
	[9.8500000000E+03, 5.8882138204E+00, 6.3131512189E+00, 3.3851130691E-01, 3.0466057292E-01, 5.4021334458E-01],
	[9.8550000000E+03, 5.8919659916E+00, 6.3124719317E+00, 3.3905302786E-01, 3.0510777886E-01, 5.4039878148E-01],
	[9.8600000000E+03, 5.8957186488E+00, 6.3117930621E+00, 3.3959533993E-01, 3.0555536135E-01, 5.4058419076E-01],
	[9.8650000000E+03, 5.8994717918E+00, 6.3111146096E+00, 3.4013824346E-01, 3.0600332037E-01, 5.4076957242E-01],
	[9.8700000000E+03, 5.9032254204E+00, 6.3104365738E+00, 3.4068173880E-01, 3.0645165589E-01, 5.4095492644E-01],
	[9.8750000000E+03, 5.9069795345E+00, 6.3097589542E+00, 3.4122582630E-01, 3.0690036789E-01, 5.4114025280E-01],
	[9.8800000000E+03, 5.9107341338E+00, 6.3090817502E+00, 3.4177050629E-01, 3.0734945634E-01, 5.4132555149E-01],
	[9.8850000000E+03, 5.9144892182E+00, 6.3084049616E+00, 3.4231577913E-01, 3.0779892123E-01, 5.4151082250E-01],
	[9.8900000000E+03, 5.9182447875E+00, 6.3077285877E+00, 3.4286164516E-01, 3.0824876251E-01, 5.4169606580E-01],
	[9.8950000000E+03, 5.9220008414E+00, 6.3070526281E+00, 3.4340810471E-01, 3.0869898018E-01, 5.4188128140E-01],
	[9.9000000000E+03, 5.9257573799E+00, 6.3063770825E+00, 3.4395515815E-01, 3.0914957420E-01, 5.4206646927E-01],
	[9.9050000000E+03, 5.9295144028E+00, 6.3057019502E+00, 3.4450280580E-01, 3.0960054455E-01, 5.4225162939E-01],
	[9.9100000000E+03, 5.9332719098E+00, 6.3050272308E+00, 3.4505104802E-01, 3.1005189119E-01, 5.4243676177E-01],
	[9.9150000000E+03, 5.9370299007E+00, 6.3043529240E+00, 3.4559988514E-01, 3.1050361411E-01, 5.4262186637E-01],
	[9.9200000000E+03, 5.9407883755E+00, 6.3036790291E+00, 3.4614931752E-01, 3.1095571328E-01, 5.4280694319E-01],
	[9.9250000000E+03, 5.9445473339E+00, 6.3030055458E+00, 3.4669934550E-01, 3.1140818866E-01, 5.4299199222E-01],
	[9.9300000000E+03, 5.9483067757E+00, 6.3023324736E+00, 3.4724996942E-01, 3.1186104024E-01, 5.4317701343E-01],
	[9.9350000000E+03, 5.9520667008E+00, 6.3016598121E+00, 3.4780118963E-01, 3.1231426798E-01, 5.4336200682E-01],
	[9.9400000000E+03, 5.9558323941E+00, 6.3009938211E+00, 3.4835300647E-01, 3.1276790185E-01, 5.4354697237E-01],
	[9.9450000000E+03, 5.9595997653E+00, 6.3003296450E+00, 3.4890542028E-01, 3.1322191875E-01, 5.4373191008E-01],
	[9.9500000000E+03, 5.9633676240E+00, 6.2996658726E+00, 3.4945843142E-01, 3.1367631189E-01, 5.4391681991E-01],
	[9.9550000000E+03, 5.9671359703E+00, 6.2990025036E+00, 3.5001204022E-01, 3.1413108126E-01, 5.4410170187E-01],
	[9.9600000000E+03, 5.9709048038E+00, 6.2983395374E+00, 3.5056624703E-01, 3.1458622683E-01, 5.4428655594E-01],
	[9.9650000000E+03, 5.9746741243E+00, 6.2976769738E+00, 3.5112105220E-01, 3.1504174856E-01, 5.4447138211E-01],
	[9.9700000000E+03, 5.9784439318E+00, 6.2970148121E+00, 3.5167645606E-01, 3.1549764641E-01, 5.4465618035E-01],
	[9.9750000000E+03, 5.9822142260E+00, 6.2963530520E+00, 3.5223245897E-01, 3.1595392038E-01, 5.4484095067E-01],
	[9.9800000000E+03, 5.9859850068E+00, 6.2956916930E+00, 3.5278906127E-01, 3.1641057041E-01, 5.4502569304E-01],
	[9.9850000000E+03, 5.9897562739E+00, 6.2950307347E+00, 3.5334626330E-01, 3.1686759648E-01, 5.4521040745E-01],
	[9.9900000000E+03, 5.9935280272E+00, 6.2943701766E+00, 3.5390406541E-01, 3.1732499856E-01, 5.4539509390E-01],
	[9.9950000000E+03, 5.9973002665E+00, 6.2937100184E+00, 3.5446246794E-01, 3.1778277662E-01, 5.4557975236E-01],
	[1.0000000000E+04, 6.0010729916E+00, 6.2930502594E+00, 3.5502147124E-01, 3.1824093062E-01, 5.4576438283E-01],
	[1.0005000000E+04, 6.0048462023E+00, 6.2923908994E+00, 3.5558455128E-01, 3.1870225255E-01, 5.4594898529E-01],
	[1.0010000000E+04, 6.0086198986E+00, 6.2917319378E+00, 3.5614824200E-01, 3.1916395624E-01, 5.4613355973E-01],
	[1.0015000000E+04, 6.0123940800E+00, 6.2910733743E+00, 3.5671254376E-01, 3.1962604166E-01, 5.4631810613E-01],
	[1.0020000000E+04, 6.0161687466E+00, 6.2904152084E+00, 3.5727745690E-01, 3.2008850879E-01, 5.4650262449E-01],
	[1.0025000000E+04, 6.0199438981E+00, 6.2897574396E+00, 3.5784298179E-01, 3.2055135758E-01, 5.4668711479E-01],
	[1.0030000000E+04, 6.0237195344E+00, 6.2891000675E+00, 3.5840911877E-01, 3.2101458800E-01, 5.4687157702E-01],
	[1.0035000000E+04, 6.0274956552E+00, 6.2884430917E+00, 3.5897586822E-01, 3.2147820002E-01, 5.4705601117E-01],
	[1.0040000000E+04, 6.0312722604E+00, 6.2877865117E+00, 3.5954323047E-01, 3.2194219361E-01, 5.4724041722E-01],
	[1.0045000000E+04, 6.0350493498E+00, 6.2871303271E+00, 3.6011120590E-01, 3.2240656873E-01, 5.4742479516E-01],
	[1.0050000000E+04, 6.0388269232E+00, 6.2864745375E+00, 3.6067979485E-01, 3.2287132535E-01, 5.4760914498E-01],
	[1.0055000000E+04, 6.0426049805E+00, 6.2858191424E+00, 3.6124899769E-01, 3.2333646344E-01, 5.4779346667E-01],
	[1.0060000000E+04, 6.0463835214E+00, 6.2851641415E+00, 3.6181881476E-01, 3.2380198295E-01, 5.4797776022E-01],
	[1.0065000000E+04, 6.0501625458E+00, 6.2845095342E+00, 3.6238924643E-01, 3.2426788385E-01, 5.4816202561E-01],
	[1.0070000000E+04, 6.0539420536E+00, 6.2838553201E+00, 3.6296029305E-01, 3.2473416611E-01, 5.4834626283E-01],
	[1.0075000000E+04, 6.0577220444E+00, 6.2832014989E+00, 3.6353195498E-01, 3.2520082969E-01, 5.4853047188E-01],
	[1.0080000000E+04, 6.0615025182E+00, 6.2825480700E+00, 3.6410423257E-01, 3.2566787455E-01, 5.4871465273E-01],
	[1.0085000000E+04, 6.0652834748E+00, 6.2818950330E+00, 3.6467712618E-01, 3.2613530066E-01, 5.4889880537E-01],
	[1.0090000000E+04, 6.0690649140E+00, 6.2812423876E+00, 3.6525063618E-01, 3.2660310798E-01, 5.4908292981E-01],
	[1.0095000000E+04, 6.0728468356E+00, 6.2805901333E+00, 3.6582476290E-01, 3.2707129647E-01, 5.4926702601E-01],
	[1.0100000000E+04, 6.0766349233E+00, 6.2799444851E+00, 3.6639950672E-01, 3.2753989951E-01, 5.4945109398E-01],
	[1.0105000000E+04, 6.0804247017E+00, 6.2793005387E+00, 3.6697486798E-01, 3.2800889090E-01, 5.4963513368E-01],
	[1.0110000000E+04, 6.0842149672E+00, 6.2786569769E+00, 3.6755084704E-01, 3.2847826354E-01, 5.4981914504E-01],
	[1.0115000000E+04, 6.0880057195E+00, 6.2780137992E+00, 3.6812744427E-01, 3.2894801739E-01, 5.5000312803E-01],
	[1.0120000000E+04, 6.0917969585E+00, 6.2773710051E+00, 3.6870466002E-01, 3.2941815240E-01, 5.5018708264E-01],
	[1.0125000000E+04, 6.0955886841E+00, 6.2767285944E+00, 3.6928249463E-01, 3.2988866854E-01, 5.5037100882E-01],
	[1.0130000000E+04, 6.0993808960E+00, 6.2760865665E+00, 3.6986094848E-01, 3.3035956578E-01, 5.5055490656E-01],
	[1.0135000000E+04, 6.1031735940E+00, 6.2754449210E+00, 3.7044002192E-01, 3.3083084406E-01, 5.5073877582E-01],
	[1.0140000000E+04, 6.1069667781E+00, 6.2748036576E+00, 3.7101971530E-01, 3.3130250335E-01, 5.5092261657E-01],
	[1.0145000000E+04, 6.1107604479E+00, 6.2741627757E+00, 3.7160002899E-01, 3.3177454361E-01, 5.5110642879E-01],
	[1.0150000000E+04, 6.1145546035E+00, 6.2735222751E+00, 3.7218096333E-01, 3.3224696479E-01, 5.5129021244E-01],
	[1.0155000000E+04, 6.1183492444E+00, 6.2728821552E+00, 3.7276251868E-01, 3.3271976686E-01, 5.5147396750E-01],
	[1.0160000000E+04, 6.1221443707E+00, 6.2722424157E+00, 3.7334469541E-01, 3.3319294977E-01, 5.5165769395E-01],
	[1.0165000000E+04, 6.1259399820E+00, 6.2716030562E+00, 3.7392749387E-01, 3.3366651347E-01, 5.5184139174E-01],
	[1.0170000000E+04, 6.1297360783E+00, 6.2709640762E+00, 3.7451091441E-01, 3.3414045794E-01, 5.5202506087E-01],
	[1.0175000000E+04, 6.1335326593E+00, 6.2703254753E+00, 3.7509495740E-01, 3.3461478312E-01, 5.5220870128E-01],
	[1.0180000000E+04, 6.1373297249E+00, 6.2696872531E+00, 3.7567962319E-01, 3.3508948896E-01, 5.5239231297E-01],
	[1.0185000000E+04, 6.1411272749E+00, 6.2690494092E+00, 3.7626491213E-01, 3.3556457544E-01, 5.5257589590E-01],
	[1.0190000000E+04, 6.1449253092E+00, 6.2684119433E+00, 3.7685082459E-01, 3.3604004249E-01, 5.5275945004E-01],
	[1.0195000000E+04, 6.1487238275E+00, 6.2677748548E+00, 3.7743736092E-01, 3.3651589008E-01, 5.5294297537E-01],
	[1.0200000000E+04, 6.1525228296E+00, 6.2671381434E+00, 3.7802452148E-01, 3.3699211816E-01, 5.5312647185E-01],
	[1.0205000000E+04, 6.1563223155E+00, 6.2665018086E+00, 3.7861230662E-01, 3.3746872669E-01, 5.5330993947E-01],
	[1.0210000000E+04, 6.1601222848E+00, 6.2658658502E+00, 3.7920071671E-01, 3.3794571561E-01, 5.5349337819E-01],
	[1.0215000000E+04, 6.1639227375E+00, 6.2652302675E+00, 3.7978975210E-01, 3.3842308489E-01, 5.5367678798E-01],
	[1.0220000000E+04, 6.1677236734E+00, 6.2645950604E+00, 3.8037941314E-01, 3.3890083447E-01, 5.5386016883E-01],
	[1.0225000000E+04, 6.1715250923E+00, 6.2639602282E+00, 3.8096970020E-01, 3.3937896432E-01, 5.5404352069E-01],
	[1.0230000000E+04, 6.1753269940E+00, 6.2633257708E+00, 3.8156061364E-01, 3.3985747437E-01, 5.5422684355E-01],
	[1.0235000000E+04, 6.1791293784E+00, 6.2626916875E+00, 3.8215215380E-01, 3.4033636459E-01, 5.5441013738E-01],
	[1.0240000000E+04, 6.1829322452E+00, 6.2620579781E+00, 3.8274432105E-01, 3.4081563493E-01, 5.5459340214E-01],
	[1.0245000000E+04, 6.1867355943E+00, 6.2614246421E+00, 3.8333711575E-01, 3.4129528533E-01, 5.5477663782E-01],
	[1.0250000000E+04, 6.1905394255E+00, 6.2607916792E+00, 3.8393053824E-01, 3.4177531576E-01, 5.5495984439E-01],
	[1.0255000000E+04, 6.1943437387E+00, 6.2601590888E+00, 3.8452458890E-01, 3.4225572615E-01, 5.5514302182E-01],
	[1.0260000000E+04, 6.1981508978E+00, 6.2595292445E+00, 3.8511926807E-01, 3.4273653081E-01, 5.5532617008E-01],
	[1.0265000000E+04, 6.2019635830E+00, 6.2589048305E+00, 3.8571457612E-01, 3.4321774606E-01, 5.5550928914E-01],
	[1.0270000000E+04, 6.2057767551E+00, 6.2582807827E+00, 3.8631051340E-01, 3.4369934134E-01, 5.5569237899E-01],
	[1.0275000000E+04, 6.2095904140E+00, 6.2576571008E+00, 3.8690708027E-01, 3.4418131659E-01, 5.5587543959E-01],
	[1.0280000000E+04, 6.2134045594E+00, 6.2570337845E+00, 3.8750427709E-01, 3.4466367178E-01, 5.5605847091E-01],
	[1.0285000000E+04, 6.2172191912E+00, 6.2564108333E+00, 3.8810210421E-01, 3.4514640683E-01, 5.5624147294E-01],
	[1.0290000000E+04, 6.2210343093E+00, 6.2557882468E+00, 3.8870056199E-01, 3.4562952171E-01, 5.5642444564E-01],
	[1.0295000000E+04, 6.2248499134E+00, 6.2551660247E+00, 3.8929965080E-01, 3.4611301637E-01, 5.5660738899E-01],
	[1.0300000000E+04, 6.2286660033E+00, 6.2545441666E+00, 3.8989937098E-01, 3.4659689074E-01, 5.5679030296E-01],
	[1.0305000000E+04, 6.2324825790E+00, 6.2539226721E+00, 3.9049972290E-01, 3.4708114478E-01, 5.5697318753E-01],
	[1.0310000000E+04, 6.2362996402E+00, 6.2533015407E+00, 3.9110070692E-01, 3.4756577844E-01, 5.5715604267E-01],
	[1.0315000000E+04, 6.2401171867E+00, 6.2526807722E+00, 3.9170232338E-01, 3.4805079165E-01, 5.5733886835E-01],
	[1.0320000000E+04, 6.2439352184E+00, 6.2520603660E+00, 3.9230457266E-01, 3.4853618437E-01, 5.5752166455E-01],
	[1.0325000000E+04, 6.2477537351E+00, 6.2514403219E+00, 3.9290745510E-01, 3.4902195655E-01, 5.5770443125E-01],
	[1.0330000000E+04, 6.2515727366E+00, 6.2508206394E+00, 3.9351097106E-01, 3.4950810813E-01, 5.5788716841E-01],
	[1.0335000000E+04, 6.2553922228E+00, 6.2502013182E+00, 3.9411512092E-01, 3.4999463905E-01, 5.5806987601E-01],
	[1.0340000000E+04, 6.2592121935E+00, 6.2495823578E+00, 3.9471990501E-01, 3.5048154926E-01, 5.5825255403E-01],
	[1.0345000000E+04, 6.2630326485E+00, 6.2489637579E+00, 3.9532532370E-01, 3.5096883871E-01, 5.5843520244E-01],
	[1.0350000000E+04, 6.2668535876E+00, 6.2483455182E+00, 3.9593137734E-01, 3.5145650733E-01, 5.5861782121E-01],
	[1.0355000000E+04, 6.2706750107E+00, 6.2477276381E+00, 3.9653806631E-01, 3.5194455508E-01, 5.5880041033E-01],
	[1.0360000000E+04, 6.2744969175E+00, 6.2471101174E+00, 3.9714539094E-01, 3.5243298189E-01, 5.5898296976E-01],
	[1.0365000000E+04, 6.2783193080E+00, 6.2464929556E+00, 3.9775335161E-01, 3.5292178771E-01, 5.5916549948E-01],
	[1.0370000000E+04, 6.2821421820E+00, 6.2458761524E+00, 3.9836194867E-01, 3.5341097248E-01, 5.5934799946E-01],
	[1.0375000000E+04, 6.2859655392E+00, 6.2452597073E+00, 3.9897118247E-01, 3.5390053615E-01, 5.5953046968E-01],
	[1.0380000000E+04, 6.2897893795E+00, 6.2446436201E+00, 3.9958105338E-01, 3.5439047865E-01, 5.5971291012E-01],
	[1.0385000000E+04, 6.2936137028E+00, 6.2440278903E+00, 4.0019156176E-01, 3.5488079993E-01, 5.5989532074E-01],
	[1.0390000000E+04, 6.2974385088E+00, 6.2434125176E+00, 4.0080270796E-01, 3.5537149993E-01, 5.6007770153E-01],
	[1.0395000000E+04, 6.3012637974E+00, 6.2427975015E+00, 4.0141449233E-01, 3.5586257858E-01, 5.6026005246E-01],
	[1.0400000000E+04, 6.3050895684E+00, 6.2421828417E+00, 4.0202691525E-01, 3.5635403584E-01, 5.6044237350E-01],
	[1.0405000000E+04, 6.3089158216E+00, 6.2415685379E+00, 4.0263997706E-01, 3.5684587163E-01, 5.6062466464E-01],
	[1.0410000000E+04, 6.3127425570E+00, 6.2409545895E+00, 4.0325367813E-01, 3.5733808591E-01, 5.6080692584E-01],
	[1.0415000000E+04, 6.3165697742E+00, 6.2403409964E+00, 4.0386801882E-01, 3.5783067860E-01, 5.6098915708E-01],
	[1.0420000000E+04, 6.3203974732E+00, 6.2397277580E+00, 4.0448299947E-01, 3.5832364966E-01, 5.6117135834E-01],
	[1.0425000000E+04, 6.3242279535E+00, 6.2391170026E+00, 4.0509862046E-01, 3.5881701345E-01, 5.6135352960E-01],
	[1.0430000000E+04, 6.3280645499E+00, 6.2385118096E+00, 4.0571488214E-01, 3.5931079098E-01, 5.6153567082E-01],
	[1.0435000000E+04, 6.3319016333E+00, 6.2379069654E+00, 4.0633178486E-01, 3.5980494692E-01, 5.6171778198E-01],
	[1.0440000000E+04, 6.3357392036E+00, 6.2373024695E+00, 4.0694932899E-01, 3.6029948119E-01, 5.6189986307E-01],
	[1.0445000000E+04, 6.3395772605E+00, 6.2366983216E+00, 4.0756751489E-01, 3.6079439373E-01, 5.6208191405E-01],
	[1.0450000000E+04, 6.3434158040E+00, 6.2360945213E+00, 4.0818634291E-01, 3.6128968448E-01, 5.6226393490E-01],
	[1.0455000000E+04, 6.3472548338E+00, 6.2354910683E+00, 4.0880581341E-01, 3.6178535338E-01, 5.6244592560E-01],
	[1.0460000000E+04, 6.3510943498E+00, 6.2348879621E+00, 4.0942592675E-01, 3.6228140036E-01, 5.6262788613E-01],
	[1.0465000000E+04, 6.3549343518E+00, 6.2342852024E+00, 4.1004668329E-01, 3.6277782536E-01, 5.6280981645E-01],
	[1.0470000000E+04, 6.3587748396E+00, 6.2336827889E+00, 4.1066808339E-01, 3.6327462832E-01, 5.6299171655E-01],
	[1.0475000000E+04, 6.3626158131E+00, 6.2330807212E+00, 4.1129012741E-01, 3.6377180917E-01, 5.6317358641E-01],
	[1.0480000000E+04, 6.3664572721E+00, 6.2324789989E+00, 4.1191281570E-01, 3.6426936784E-01, 5.6335542599E-01],
	[1.0485000000E+04, 6.3702992164E+00, 6.2318776217E+00, 4.1253614863E-01, 3.6476730428E-01, 5.6353723528E-01],
	[1.0490000000E+04, 6.3741416458E+00, 6.2312765891E+00, 4.1316012655E-01, 3.6526561841E-01, 5.6371901426E-01],
	[1.0495000000E+04, 6.3779845602E+00, 6.2306759009E+00, 4.1378474982E-01, 3.6576431017E-01, 5.6390076289E-01],
	[1.0500000000E+04, 6.3818279594E+00, 6.2300755567E+00, 4.1441001880E-01, 3.6626337949E-01, 5.6408248116E-01],
	[1.0505000000E+04, 6.3856718433E+00, 6.2294755561E+00, 4.1503593386E-01, 3.6676282631E-01, 5.6426416904E-01],
	[1.0510000000E+04, 6.3895162116E+00, 6.2288758987E+00, 4.1566249534E-01, 3.6726265056E-01, 5.6444582651E-01],
	[1.0515000000E+04, 6.3933610643E+00, 6.2282765843E+00, 4.1628970361E-01, 3.6776285217E-01, 5.6462745354E-01],
	[1.0520000000E+04, 6.3972064010E+00, 6.2276776123E+00, 4.1691755902E-01, 3.6826343108E-01, 5.6480905012E-01],
	[1.0525000000E+04, 6.4010522218E+00, 6.2270789826E+00, 4.1754606194E-01, 3.6876438721E-01, 5.6499061622E-01],
	[1.0530000000E+04, 6.4048985263E+00, 6.2264806946E+00, 4.1817521273E-01, 3.6926572049E-01, 5.6517215182E-01],
	[1.0535000000E+04, 6.4087453144E+00, 6.2258827482E+00, 4.1880501174E-01, 3.6976743087E-01, 5.6535365689E-01],
	[1.0540000000E+04, 6.4125925860E+00, 6.2252851428E+00, 4.1943545933E-01, 3.7026951826E-01, 5.6553513141E-01],
	[1.0545000000E+04, 6.4164403409E+00, 6.2246878782E+00, 4.2006655587E-01, 3.7077198260E-01, 5.6571657536E-01],
	[1.0550000000E+04, 6.4202885789E+00, 6.2240909540E+00, 4.2069830170E-01, 3.7127482382E-01, 5.6589798872E-01],
	[1.0555000000E+04, 6.4241372999E+00, 6.2234943698E+00, 4.2133069720E-01, 3.7177804185E-01, 5.6607937146E-01],
	[1.0560000000E+04, 6.4279865036E+00, 6.2228981253E+00, 4.2196374271E-01, 3.7228163662E-01, 5.6626072356E-01],
	[1.0565000000E+04, 6.4318361900E+00, 6.2223022201E+00, 4.2259743861E-01, 3.7278560805E-01, 5.6644204500E-01],
	[1.0570000000E+04, 6.4356863587E+00, 6.2217066539E+00, 4.2323178524E-01, 3.7328995608E-01, 5.6662333576E-01],
	[1.0575000000E+04, 6.4395370098E+00, 6.2211114263E+00, 4.2386678297E-01, 3.7379468063E-01, 5.6680459581E-01],
	[1.0580000000E+04, 6.4433881430E+00, 6.2205165370E+00, 4.2450243216E-01, 3.7429978163E-01, 5.6698582513E-01],
	[1.0585000000E+04, 6.4472397581E+00, 6.2199219856E+00, 4.2513873316E-01, 3.7480525901E-01, 5.6716702370E-01],
	[1.0590000000E+04, 6.4510918550E+00, 6.2193277718E+00, 4.2577568633E-01, 3.7531111269E-01, 5.6734819150E-01],
	[1.0595000000E+04, 6.4549506026E+00, 6.2187391767E+00, 4.2641329204E-01, 3.7581738281E-01, 5.6752932850E-01],
	[1.0600000000E+04, 6.4588121303E+00, 6.2181528777E+00, 4.2705155065E-01, 3.7632404423E-01, 5.6771043469E-01],
	[1.0605000000E+04, 6.4626741454E+00, 6.2175669105E+00, 4.2769046251E-01, 3.7683108198E-01, 5.6789151003E-01],
	[1.0610000000E+04, 6.4665366477E+00, 6.2169812746E+00, 4.2833002798E-01, 3.7733849599E-01, 5.6807255452E-01],
	[1.0615000000E+04, 6.4703996371E+00, 6.2163959698E+00, 4.2897024742E-01, 3.7784628617E-01, 5.6825356813E-01],
	[1.0620000000E+04, 6.4742631133E+00, 6.2158109957E+00, 4.2961112120E-01, 3.7835445246E-01, 5.6843455083E-01],
	[1.0625000000E+04, 6.4781270763E+00, 6.2152263519E+00, 4.3025264967E-01, 3.7886299477E-01, 5.6861550260E-01],
	[1.0630000000E+04, 6.4819915258E+00, 6.2146420382E+00, 4.3089483319E-01, 3.7937191304E-01, 5.6879642343E-01],
	[1.0635000000E+04, 6.4858564617E+00, 6.2140580541E+00, 4.3153767211E-01, 3.7988120719E-01, 5.6897731329E-01],
	[1.0640000000E+04, 6.4897218838E+00, 6.2134743994E+00, 4.3218116681E-01, 3.8039087713E-01, 5.6915817215E-01],
	[1.0645000000E+04, 6.4935877920E+00, 6.2128910736E+00, 4.3282531764E-01, 3.8090092280E-01, 5.6933900001E-01],
	[1.0650000000E+04, 6.4974541861E+00, 6.2123080765E+00, 4.3347012496E-01, 3.8141134412E-01, 5.6951979682E-01],
	[1.0655000000E+04, 6.5013210658E+00, 6.2117254077E+00, 4.3411558913E-01, 3.8192214101E-01, 5.6970056254E-01],
	[1.0660000000E+04, 6.5051884311E+00, 6.2111430669E+00, 4.3476171051E-01, 3.8243331339E-01, 5.6988129713E-01],
	[1.0665000000E+04, 6.5090562818E+00, 6.2105610537E+00, 4.3540848945E-01, 3.8294486118E-01, 5.7006200056E-01],
	[1.0670000000E+04, 6.5129246177E+00, 6.2099793678E+00, 4.3605592633E-01, 3.8345678431E-01, 5.7024267279E-01],
	[1.0675000000E+04, 6.5167934387E+00, 6.2093980089E+00, 4.3670402149E-01, 3.8396908270E-01, 5.7042331379E-01],
	[1.0680000000E+04, 6.5206627445E+00, 6.2088169766E+00, 4.3735277530E-01, 3.8448175627E-01, 5.7060392352E-01],
	[1.0685000000E+04, 6.5245325351E+00, 6.2082362706E+00, 4.3800218812E-01, 3.8499480494E-01, 5.7078450196E-01],
	[1.0690000000E+04, 6.5284028102E+00, 6.2076558905E+00, 4.3865226031E-01, 3.8550822863E-01, 5.7096504908E-01],
	[1.0695000000E+04, 6.5322735697E+00, 6.2070758361E+00, 4.3930299223E-01, 3.8602202725E-01, 5.7114556483E-01],
	[1.0700000000E+04, 6.5361448134E+00, 6.2064961069E+00, 4.3995438423E-01, 3.8653620074E-01, 5.7132604918E-01],
	[1.0705000000E+04, 6.5400165411E+00, 6.2059167027E+00, 4.4060643669E-01, 3.8705074900E-01, 5.7150650211E-01],
	[1.0710000000E+04, 6.5438887527E+00, 6.2053376230E+00, 4.4125914995E-01, 3.8756567196E-01, 5.7168692358E-01],
	[1.0715000000E+04, 6.5477614481E+00, 6.2047588677E+00, 4.4191252438E-01, 3.8808096953E-01, 5.7186731355E-01],
	[1.0720000000E+04, 6.5516346270E+00, 6.2041804363E+00, 4.4256656033E-01, 3.8859664164E-01, 5.7204767201E-01],
	[1.0725000000E+04, 6.5555082893E+00, 6.2036023285E+00, 4.4322125818E-01, 3.8911268820E-01, 5.7222799890E-01],
	[1.0730000000E+04, 6.5593824348E+00, 6.2030245441E+00, 4.4387661827E-01, 3.8962910913E-01, 5.7240829421E-01],
	[1.0735000000E+04, 6.5632570634E+00, 6.2024470825E+00, 4.4453264097E-01, 3.9014590434E-01, 5.7258855789E-01],
	[1.0740000000E+04, 6.5671321749E+00, 6.2018699436E+00, 4.4518932665E-01, 3.9066307375E-01, 5.7276878992E-01],
	[1.0745000000E+04, 6.5710077691E+00, 6.2012931269E+00, 4.4584667565E-01, 3.9118061728E-01, 5.7294899027E-01],
	[1.0750000000E+04, 6.5748838459E+00, 6.2007166323E+00, 4.4650468833E-01, 3.9169853484E-01, 5.7312915889E-01],
	[1.0755000000E+04, 6.5787604050E+00, 6.2001404592E+00, 4.4716336507E-01, 3.9221682635E-01, 5.7330929577E-01],
	[1.0760000000E+04, 6.5826374464E+00, 6.1995646075E+00, 4.4782270622E-01, 3.9273549173E-01, 5.7348940086E-01],
	[1.0765000000E+04, 6.5865206177E+00, 6.1989935663E+00, 4.4848271214E-01, 3.9325456908E-01, 5.7366947415E-01],
	[1.0770000000E+04, 6.5904076257E+00, 6.1984255045E+00, 4.4914338319E-01, 3.9377404300E-01, 5.7384951558E-01],
	[1.0775000000E+04, 6.5942951218E+00, 6.1978577585E+00, 4.4980471973E-01, 3.9429389079E-01, 5.7402952514E-01],
	[1.0780000000E+04, 6.5981831060E+00, 6.1972903279E+00, 4.5046672212E-01, 3.9481411235E-01, 5.7420950279E-01],
	[1.0785000000E+04, 6.6020715779E+00, 6.1967232122E+00, 4.5112939072E-01, 3.9533470762E-01, 5.7438944851E-01],
	[1.0790000000E+04, 6.6059605376E+00, 6.1961564113E+00, 4.5179272590E-01, 3.9585567649E-01, 5.7456936225E-01],
	[1.0795000000E+04, 6.6098499848E+00, 6.1955899248E+00, 4.5245672800E-01, 3.9637701889E-01, 5.7474924399E-01],
	[1.0800000000E+04, 6.6137399193E+00, 6.1950237524E+00, 4.5312139740E-01, 3.9689873472E-01, 5.7492909369E-01],
	[1.0805000000E+04, 6.6176303410E+00, 6.1944578937E+00, 4.5378673446E-01, 3.9742082390E-01, 5.7510891133E-01],
	[1.0810000000E+04, 6.6215212497E+00, 6.1938923485E+00, 4.5445273953E-01, 3.9794328634E-01, 5.7528869687E-01],
	[1.0815000000E+04, 6.6254126453E+00, 6.1933271164E+00, 4.5511941297E-01, 3.9846612196E-01, 5.7546845029E-01],
	[1.0820000000E+04, 6.6293045275E+00, 6.1927621971E+00, 4.5578675515E-01, 3.9898933065E-01, 5.7564817155E-01],
	[1.0825000000E+04, 6.6331968963E+00, 6.1921975902E+00, 4.5645476642E-01, 3.9951291234E-01, 5.7582786061E-01],
	[1.0830000000E+04, 6.6370897514E+00, 6.1916332956E+00, 4.5712344715E-01, 4.0003686694E-01, 5.7600751746E-01],
	[1.0835000000E+04, 6.6409830928E+00, 6.1910693128E+00, 4.5779279770E-01, 4.0056119435E-01, 5.7618714206E-01],
	[1.0840000000E+04, 6.6448769201E+00, 6.1905056415E+00, 4.5846281843E-01, 4.0108589448E-01, 5.7636673438E-01],
	[1.0845000000E+04, 6.6487712334E+00, 6.1899422815E+00, 4.5913350969E-01, 4.0161096725E-01, 5.7654629438E-01],
	[1.0850000000E+04, 6.6526660323E+00, 6.1893792323E+00, 4.5980487186E-01, 4.0213641257E-01, 5.7672582204E-01],
	[1.0855000000E+04, 6.6565613168E+00, 6.1888164938E+00, 4.6047690528E-01, 4.0266223033E-01, 5.7690531733E-01],
	[1.0860000000E+04, 6.6604570866E+00, 6.1882540655E+00, 4.6114961033E-01, 4.0318842046E-01, 5.7708478022E-01],
	[1.0865000000E+04, 6.6643533417E+00, 6.1876919472E+00, 4.6182298736E-01, 4.0371498286E-01, 5.7726421067E-01],
	[1.0870000000E+04, 6.6682500818E+00, 6.1871301386E+00, 4.6249703673E-01, 4.0424191743E-01, 5.7744360865E-01],
	[1.0875000000E+04, 6.6721473069E+00, 6.1865686392E+00, 4.6317175880E-01, 4.0476922408E-01, 5.7762297415E-01],
	[1.0880000000E+04, 6.6760450166E+00, 6.1860074489E+00, 4.6384715394E-01, 4.0529690273E-01, 5.7780230712E-01],
	[1.0885000000E+04, 6.6799432109E+00, 6.1854465674E+00, 4.6452322251E-01, 4.0582495327E-01, 5.7798160753E-01],
	[1.0890000000E+04, 6.6838418896E+00, 6.1848859942E+00, 4.6519996486E-01, 4.0635337562E-01, 5.7816087536E-01],
	[1.0895000000E+04, 6.6877410526E+00, 6.1843257291E+00, 4.6587738136E-01, 4.0688216968E-01, 5.7834011057E-01],
	[1.0900000000E+04, 6.6916406996E+00, 6.1837657717E+00, 4.6655547237E-01, 4.0741133535E-01, 5.7851931314E-01],
	[1.0905000000E+04, 6.6955408305E+00, 6.1832061219E+00, 4.6723423825E-01, 4.0794087254E-01, 5.7869848304E-01],
	[1.0910000000E+04, 6.6994414452E+00, 6.1826467792E+00, 4.6791367936E-01, 4.0847078116E-01, 5.7887762023E-01],
	[1.0915000000E+04, 6.7033425435E+00, 6.1820877434E+00, 4.6859379607E-01, 4.0900106110E-01, 5.7905672469E-01],
	[1.0920000000E+04, 6.7072441252E+00, 6.1815290141E+00, 4.6927458872E-01, 4.0953171228E-01, 5.7923579639E-01],
	[1.0925000000E+04, 6.7111461902E+00, 6.1809705910E+00, 4.6995605769E-01, 4.1006273460E-01, 5.7941483529E-01],
	[1.0930000000E+04, 6.7150487383E+00, 6.1804124739E+00, 4.7063820334E-01, 4.1059412796E-01, 5.7959384137E-01],
	[1.0935000000E+04, 6.7189517694E+00, 6.1798546623E+00, 4.7132102602E-01, 4.1112589226E-01, 5.7977281461E-01],
	[1.0940000000E+04, 6.7228646067E+00, 6.1793040566E+00, 4.7200452611E-01, 4.1165809299E-01, 5.7995175496E-01],
	[1.0945000000E+04, 6.7267781485E+00, 6.1787539105E+00, 4.7268870395E-01, 4.1219066626E-01, 5.8013066240E-01],
	[1.0950000000E+04, 6.7306921794E+00, 6.1782040647E+00, 4.7337355991E-01, 4.1272361046E-01, 5.8030953690E-01],
	[1.0955000000E+04, 6.7346066993E+00, 6.1776545188E+00, 4.7405909435E-01, 4.1325692549E-01, 5.8048837843E-01],
	[1.0960000000E+04, 6.7385217081E+00, 6.1771052725E+00, 4.7474530764E-01, 4.1379061126E-01, 5.8066718697E-01],
	[1.0965000000E+04, 6.7424372057E+00, 6.1765563255E+00, 4.7543220014E-01, 4.1432466767E-01, 5.8084596248E-01],
	[1.0970000000E+04, 6.7463531917E+00, 6.1760076776E+00, 4.7611977219E-01, 4.1485909462E-01, 5.8102470494E-01],
	[1.0975000000E+04, 6.7502696662E+00, 6.1754593283E+00, 4.7680802418E-01, 4.1539389200E-01, 5.8120341431E-01],
	[1.0980000000E+04, 6.7541866288E+00, 6.1749112775E+00, 4.7749695646E-01, 4.1592905973E-01, 5.8138209057E-01],
	[1.0985000000E+04, 6.7581040796E+00, 6.1743635247E+00, 4.7818656939E-01, 4.1646459769E-01, 5.8156073369E-01],
	[1.0990000000E+04, 6.7620220182E+00, 6.1738160698E+00, 4.7887686333E-01, 4.1700050579E-01, 5.8173934364E-01],
	[1.0995000000E+04, 6.7659404446E+00, 6.1732689124E+00, 4.7956783864E-01, 4.1753678393E-01, 5.8191792039E-01],
	[1.1000000000E+04, 6.7698593585E+00, 6.1727220523E+00, 4.8025949569E-01, 4.1807343201E-01, 5.8209646392E-01],
	[1.1005000000E+04, 6.7737787598E+00, 6.1721754890E+00, 4.8095183483E-01, 4.1861044992E-01, 5.8227497419E-01],
	[1.1010000000E+04, 6.7776986485E+00, 6.1716292224E+00, 4.8164485644E-01, 4.1914783757E-01, 5.8245345118E-01],
	[1.1015000000E+04, 6.7816190242E+00, 6.1710832521E+00, 4.8233856086E-01, 4.1968559485E-01, 5.8263189485E-01],
	[1.1020000000E+04, 6.7855398868E+00, 6.1705375779E+00, 4.8303294847E-01, 4.2022372166E-01, 5.8281030519E-01],
	[1.1025000000E+04, 6.7894612362E+00, 6.1699921994E+00, 4.8372801962E-01, 4.2076221789E-01, 5.8298868216E-01],
	[1.1030000000E+04, 6.7933830722E+00, 6.1694471164E+00, 4.8442377468E-01, 4.2130108345E-01, 5.8316702573E-01],
	[1.1035000000E+04, 6.7973053947E+00, 6.1689023285E+00, 4.8512021400E-01, 4.2184031823E-01, 5.8334533588E-01],
	[1.1040000000E+04, 6.8012282035E+00, 6.1683578355E+00, 4.8581733796E-01, 4.2237992213E-01, 5.8352361258E-01],
	[1.1045000000E+04, 6.8051514983E+00, 6.1678136370E+00, 4.8651514690E-01, 4.2291989503E-01, 5.8370185580E-01],
	[1.1050000000E+04, 6.8090752792E+00, 6.1672697329E+00, 4.8721364120E-01, 4.2346023685E-01, 5.8388006551E-01],
	[1.1055000000E+04, 6.8129995459E+00, 6.1667261227E+00, 4.8791282121E-01, 4.2400094746E-01, 5.8405824168E-01],
	[1.1060000000E+04, 6.8169242982E+00, 6.1661828062E+00, 4.8861268730E-01, 4.2454202677E-01, 5.8423638430E-01],
	[1.1065000000E+04, 6.8208495360E+00, 6.1656397831E+00, 4.8931323982E-01, 4.2508347468E-01, 5.8441449332E-01],
	[1.1070000000E+04, 6.8247752592E+00, 6.1650970532E+00, 4.9001447915E-01, 4.2562529107E-01, 5.8459256873E-01],
	[1.1075000000E+04, 6.8287014675E+00, 6.1645546160E+00, 4.9071640564E-01, 4.2616747583E-01, 5.8477061049E-01],
	[1.1080000000E+04, 6.8326281609E+00, 6.1640124714E+00, 4.9141901965E-01, 4.2671002887E-01, 5.8494861857E-01],
	[1.1085000000E+04, 6.8365553391E+00, 6.1634706190E+00, 4.9212232155E-01, 4.2725295008E-01, 5.8512659296E-01],
	[1.1090000000E+04, 6.8404830020E+00, 6.1629290586E+00, 4.9282631170E-01, 4.2779623934E-01, 5.8530453362E-01],
	[1.1095000000E+04, 6.8444111494E+00, 6.1623877898E+00, 4.9353099046E-01, 4.2833989655E-01, 5.8548244053E-01],
	[1.1100000000E+04, 6.8483397812E+00, 6.1618468124E+00, 4.9423635819E-01, 4.2888392160E-01, 5.8566031365E-01],
	[1.1105000000E+04, 6.8522688973E+00, 6.1613061261E+00, 4.9494241526E-01, 4.2942831438E-01, 5.8583815297E-01],
	[1.1110000000E+04, 6.8561984974E+00, 6.1607657306E+00, 4.9564916202E-01, 4.2997307479E-01, 5.8601595845E-01],
	[1.1115000000E+04, 6.8601363389E+00, 6.1602309878E+00, 4.9635659885E-01, 4.3051825945E-01, 5.8619373007E-01],
	[1.1120000000E+04, 6.8640769959E+00, 6.1596981387E+00, 4.9706472609E-01, 4.3106382880E-01, 5.8637146780E-01],
	[1.1125000000E+04, 6.8680181435E+00, 6.1591655752E+00, 4.9777354412E-01, 4.3160976574E-01, 5.8654917162E-01],
	[1.1130000000E+04, 6.8719597816E+00, 6.1586332970E+00, 4.9848305329E-01, 4.3215607017E-01, 5.8672684149E-01],
	[1.1135000000E+04, 6.8759019099E+00, 6.1581013039E+00, 4.9919325398E-01, 4.3270274197E-01, 5.8690447739E-01],
	[1.1140000000E+04, 6.8798445285E+00, 6.1575695955E+00, 4.9990414653E-01, 4.3324978104E-01, 5.8708207930E-01],
	[1.1145000000E+04, 6.8837876370E+00, 6.1570381716E+00, 5.0061573132E-01, 4.3379718727E-01, 5.8725964718E-01],
	[1.1150000000E+04, 6.8877312353E+00, 6.1565070318E+00, 5.0132800870E-01, 4.3434496054E-01, 5.8743718102E-01],
	[1.1155000000E+04, 6.8916753233E+00, 6.1559761760E+00, 5.0204097904E-01, 4.3489310074E-01, 5.8761468078E-01],
	[1.1160000000E+04, 6.8956199007E+00, 6.1554456038E+00, 5.0275464270E-01, 4.3544160777E-01, 5.8779214644E-01],
	[1.1165000000E+04, 6.8995649676E+00, 6.1549153150E+00, 5.0346900004E-01, 4.3599048150E-01, 5.8796957797E-01],
	[1.1170000000E+04, 6.9035105236E+00, 6.1543853093E+00, 5.0418405142E-01, 4.3653972183E-01, 5.8814697534E-01],
	[1.1175000000E+04, 6.9074565687E+00, 6.1538555863E+00, 5.0489979722E-01, 4.3708932865E-01, 5.8832433851E-01],
	[1.1180000000E+04, 6.9114031026E+00, 6.1533261459E+00, 5.0561623778E-01, 4.3763930183E-01, 5.8850166743E-01],
	[1.1185000000E+04, 6.9153501252E+00, 6.1527969877E+00, 5.0633620513E-01, 4.3819176203E-01, 5.8867896208E-01],
	[1.1190000000E+04, 6.9192976364E+00, 6.1522681115E+00, 5.0705705579E-01, 4.3874472763E-01, 5.8885622242E-01],
	[1.1195000000E+04, 6.9232456360E+00, 6.1517395170E+00, 5.0777860961E-01, 4.3929806326E-01, 5.8903344841E-01],
	[1.1200000000E+04, 6.9271941238E+00, 6.1512112039E+00, 5.0850086696E-01, 4.3985176881E-01, 5.8921064002E-01],
	[1.1205000000E+04, 6.9311430997E+00, 6.1506831720E+00, 5.0922382821E-01, 4.4040584416E-01, 5.8938779722E-01],
	[1.1210000000E+04, 6.9350925636E+00, 6.1501554209E+00, 5.0994749373E-01, 4.4096028921E-01, 5.8956491997E-01],
	[1.1215000000E+04, 6.9390425152E+00, 6.1496279504E+00, 5.1067186389E-01, 4.4151510383E-01, 5.8974200824E-01],
	[1.1220000000E+04, 6.9429929544E+00, 6.1491007603E+00, 5.1139693906E-01, 4.4207028791E-01, 5.8991906199E-01],
	[1.1225000000E+04, 6.9469438811E+00, 6.1485738501E+00, 5.1212271961E-01, 4.4262584133E-01, 5.9009608119E-01],
	[1.1230000000E+04, 6.9508952950E+00, 6.1480472198E+00, 5.1284920592E-01, 4.4318176397E-01, 5.9027306580E-01],
	[1.1235000000E+04, 6.9548471961E+00, 6.1475208690E+00, 5.1357639836E-01, 4.4373805572E-01, 5.9045001580E-01],
	[1.1240000000E+04, 6.9587995842E+00, 6.1469947973E+00, 5.1430429729E-01, 4.4429471647E-01, 5.9062693115E-01],
	[1.1245000000E+04, 6.9627524591E+00, 6.1464690047E+00, 5.1503290309E-01, 4.4485174609E-01, 5.9080381181E-01],
	[1.1250000000E+04, 6.9667058207E+00, 6.1459434907E+00, 5.1576221613E-01, 4.4540914446E-01, 5.9098065775E-01],
	[1.1255000000E+04, 6.9706596688E+00, 6.1454182551E+00, 5.1649223677E-01, 4.4596691147E-01, 5.9115746894E-01],
	[1.1260000000E+04, 6.9746140033E+00, 6.1448932977E+00, 5.1722296540E-01, 4.4652504699E-01, 5.9133424534E-01],
	[1.1265000000E+04, 6.9785688239E+00, 6.1443686181E+00, 5.1795440238E-01, 4.4708355091E-01, 5.9151098692E-01],
	[1.1270000000E+04, 6.9825241306E+00, 6.1438442161E+00, 5.1868654809E-01, 4.4764242312E-01, 5.9168769365E-01],
	[1.1275000000E+04, 6.9864799232E+00, 6.1433200915E+00, 5.1941940288E-01, 4.4820166348E-01, 5.9186436550E-01],
	[1.1280000000E+04, 6.9904362015E+00, 6.1427962439E+00, 5.2015296715E-01, 4.4876127188E-01, 5.9204100242E-01],
	[1.1285000000E+04, 6.9943929654E+00, 6.1422726731E+00, 5.2088724125E-01, 4.4932124819E-01, 5.9221760440E-01],
	[1.1290000000E+04, 6.9983502147E+00, 6.1417493788E+00, 5.2162222556E-01, 4.4988159231E-01, 5.9239417138E-01],
	[1.1295000000E+04, 7.0023185246E+00, 6.1412332025E+00, 5.2235792045E-01, 4.5044238466E-01, 5.9257070335E-01],
	[1.1300000000E+04, 7.0062873857E+00, 6.1407173359E+00, 5.2309432629E-01, 4.5100354535E-01, 5.9274720027E-01],
	[1.1305000000E+04, 7.0102567391E+00, 6.1402017408E+00, 5.2383144345E-01, 4.5156507378E-01, 5.9292366210E-01],
	[1.1310000000E+04, 7.0142265846E+00, 6.1396864170E+00, 5.2456927231E-01, 4.5212696986E-01, 5.9310008882E-01],
	[1.1315000000E+04, 7.0181969221E+00, 6.1391713641E+00, 5.2530781324E-01, 4.5268923344E-01, 5.9327648039E-01],
	[1.1320000000E+04, 7.0221677514E+00, 6.1386565820E+00, 5.2604706660E-01, 4.5325186442E-01, 5.9345283678E-01],
	[1.1325000000E+04, 7.0261390723E+00, 6.1381420703E+00, 5.2678703277E-01, 4.5381486266E-01, 5.9362915795E-01],
	[1.1330000000E+04, 7.0301108848E+00, 6.1376278289E+00, 5.2752771212E-01, 4.5437822804E-01, 5.9380544387E-01],
	[1.1335000000E+04, 7.0340831886E+00, 6.1371138574E+00, 5.2826910502E-01, 4.5494196045E-01, 5.9398169452E-01],
	[1.1340000000E+04, 7.0380559835E+00, 6.1366001556E+00, 5.2901121185E-01, 4.5550605975E-01, 5.9415790985E-01],
	[1.1345000000E+04, 7.0420292696E+00, 6.1360867232E+00, 5.2975403297E-01, 4.5607052583E-01, 5.9433408984E-01],
	[1.1350000000E+04, 7.0460030464E+00, 6.1355735599E+00, 5.3049756876E-01, 4.5663535855E-01, 5.9451023446E-01],
	[1.1355000000E+04, 7.0499773141E+00, 6.1350606656E+00, 5.3124181958E-01, 4.5720055780E-01, 5.9468634366E-01],
	[1.1360000000E+04, 7.0539520722E+00, 6.1345480399E+00, 5.3198678582E-01, 4.5776612344E-01, 5.9486241743E-01],
	[1.1365000000E+04, 7.0579273208E+00, 6.1340356826E+00, 5.3273246784E-01, 4.5833205536E-01, 5.9503845572E-01],
	[1.1370000000E+04, 7.0619030596E+00, 6.1335235934E+00, 5.3347886602E-01, 4.5889835342E-01, 5.9521445851E-01],
	[1.1375000000E+04, 7.0658792886E+00, 6.1330117720E+00, 5.3422598072E-01, 4.5946501750E-01, 5.9539042577E-01],
	[1.1380000000E+04, 7.0698560075E+00, 6.1325002183E+00, 5.3497381231E-01, 4.6003204748E-01, 5.9556635746E-01],
	[1.1385000000E+04, 7.0738332161E+00, 6.1319889319E+00, 5.3572236118E-01, 4.6059944322E-01, 5.9574225355E-01],
	[1.1390000000E+04, 7.0778109145E+00, 6.1314779127E+00, 5.3647162769E-01, 4.6116720459E-01, 5.9591811400E-01],
	[1.1395000000E+04, 7.0817891022E+00, 6.1309671602E+00, 5.3722161222E-01, 4.6173533148E-01, 5.9609393880E-01],
	[1.1400000000E+04, 7.0857677794E+00, 6.1304566744E+00, 5.3797231512E-01, 4.6230382375E-01, 5.9626972790E-01],
	[1.1405000000E+04, 7.0897469456E+00, 6.1299464549E+00, 5.3872373679E-01, 4.6287268127E-01, 5.9644548128E-01],
	[1.1410000000E+04, 7.0937266009E+00, 6.1294365014E+00, 5.3947587759E-01, 4.6344190392E-01, 5.9662119890E-01],
	[1.1415000000E+04, 7.0977067451E+00, 6.1289268137E+00, 5.4022873788E-01, 4.6401149157E-01, 5.9679688074E-01],
	[1.1420000000E+04, 7.1016873780E+00, 6.1284173917E+00, 5.4098231806E-01, 4.6458144407E-01, 5.9697252675E-01],
	[1.1425000000E+04, 7.1056684994E+00, 6.1279082349E+00, 5.4173661847E-01, 4.6515176132E-01, 5.9714813692E-01],
	[1.1430000000E+04, 7.1096501092E+00, 6.1273993431E+00, 5.4249163951E-01, 4.6572244317E-01, 5.9732371121E-01],
	[1.1435000000E+04, 7.1136322073E+00, 6.1268907162E+00, 5.4324738154E-01, 4.6629348950E-01, 5.9749924958E-01],
	[1.1440000000E+04, 7.1176147935E+00, 6.1263823538E+00, 5.4400384493E-01, 4.6686490017E-01, 5.9767475201E-01],
	[1.1445000000E+04, 7.1215978676E+00, 6.1258742557E+00, 5.4476103005E-01, 4.6743667506E-01, 5.9785021847E-01],
	[1.1450000000E+04, 7.1255814295E+00, 6.1253664216E+00, 5.4551893728E-01, 4.6800881402E-01, 5.9802564893E-01],
	[1.1455000000E+04, 7.1295654790E+00, 6.1248588514E+00, 5.4627756699E-01, 4.6858131694E-01, 5.9820104335E-01],
	[1.1460000000E+04, 7.1335500160E+00, 6.1243515446E+00, 5.4703691955E-01, 4.6915418367E-01, 5.9837640170E-01],
	[1.1465000000E+04, 7.1375350403E+00, 6.1238445012E+00, 5.4779699534E-01, 4.6972741408E-01, 5.9855172396E-01],
	[1.1470000000E+04, 7.1415205519E+00, 6.1233377207E+00, 5.4855779472E-01, 4.7030100805E-01, 5.9872701010E-01],
	[1.1475000000E+04, 7.1455137519E+00, 6.1228355749E+00, 5.4931931807E-01, 4.7087502256E-01, 5.9890226008E-01],
	[1.1480000000E+04, 7.1495114319E+00, 6.1223361086E+00, 5.5008156576E-01, 4.7144943227E-01, 5.9907747387E-01],
	[1.1485000000E+04, 7.1535096062E+00, 6.1218369004E+00, 5.5084453817E-01, 4.7202420548E-01, 5.9925265144E-01],
	[1.1490000000E+04, 7.1575082748E+00, 6.1213379503E+00, 5.5160823566E-01, 4.7259934205E-01, 5.9942779277E-01],
	[1.1495000000E+04, 7.1615074373E+00, 6.1208392578E+00, 5.5237265861E-01, 4.7317484185E-01, 5.9960289781E-01],
	[1.1500000000E+04, 7.1655070938E+00, 6.1203408228E+00, 5.5313780739E-01, 4.7375070475E-01, 5.9977796656E-01],
	[1.1505000000E+04, 7.1695072439E+00, 6.1198426451E+00, 5.5390368238E-01, 4.7432693060E-01, 5.9995299896E-01],
	[1.1510000000E+04, 7.1735078876E+00, 6.1193447243E+00, 5.5467028394E-01, 4.7490351928E-01, 6.0012799500E-01],
	[1.1515000000E+04, 7.1775090248E+00, 6.1188470602E+00, 5.5543761246E-01, 4.7548047065E-01, 6.0030295464E-01],
	[1.1520000000E+04, 7.1815106552E+00, 6.1183496527E+00, 5.5620566829E-01, 4.7605778457E-01, 6.0047787785E-01],
	[1.1525000000E+04, 7.1855127787E+00, 6.1178525014E+00, 5.5697445182E-01, 4.7663546091E-01, 6.0065276461E-01],
	[1.1530000000E+04, 7.1895153951E+00, 6.1173556061E+00, 5.5774396342E-01, 4.7721349953E-01, 6.0082761488E-01],
	[1.1535000000E+04, 7.1935185044E+00, 6.1168589666E+00, 5.5851420345E-01, 4.7779190029E-01, 6.0100242863E-01],
	[1.1540000000E+04, 7.1975221063E+00, 6.1163625826E+00, 5.5928517230E-01, 4.7837066306E-01, 6.0117720584E-01],
	[1.1545000000E+04, 7.2015262007E+00, 6.1158664539E+00, 5.6005687034E-01, 4.7894978770E-01, 6.0135194648E-01],
	[1.1550000000E+04, 7.2055307875E+00, 6.1153705802E+00, 5.6082929793E-01, 4.7952927407E-01, 6.0152665051E-01],
	[1.1555000000E+04, 7.2095358665E+00, 6.1148749613E+00, 5.6160245546E-01, 4.8010912203E-01, 6.0170131791E-01],
	[1.1560000000E+04, 7.2135414375E+00, 6.1143795970E+00, 5.6237634329E-01, 4.8068933145E-01, 6.0187594864E-01],
	[1.1565000000E+04, 7.2175475003E+00, 6.1138844869E+00, 5.6315096179E-01, 4.8126990218E-01, 6.0205054269E-01],
	[1.1570000000E+04, 7.2215540549E+00, 6.1133896310E+00, 5.6392631135E-01, 4.8185083409E-01, 6.0222510001E-01],
	[1.1575000000E+04, 7.2255611011E+00, 6.1128950289E+00, 5.6470239233E-01, 4.8243212703E-01, 6.0239962059E-01],
	[1.1580000000E+04, 7.2295686388E+00, 6.1124006804E+00, 5.6547920511E-01, 4.8301378087E-01, 6.0257410439E-01],
	[1.1585000000E+04, 7.2335766677E+00, 6.1119065852E+00, 5.6625675005E-01, 4.8359579546E-01, 6.0274855137E-01],
	[1.1590000000E+04, 7.2375851877E+00, 6.1114127432E+00, 5.6703502754E-01, 4.8417817067E-01, 6.0292296153E-01],
	[1.1595000000E+04, 7.2415941987E+00, 6.1109191540E+00, 5.6781403794E-01, 4.8476090636E-01, 6.0309733482E-01],
	[1.1600000000E+04, 7.2456037005E+00, 6.1104258175E+00, 5.6859378163E-01, 4.8534400237E-01, 6.0327167121E-01],
	[1.1605000000E+04, 7.2496136930E+00, 6.1099327333E+00, 5.6937425899E-01, 4.8592745858E-01, 6.0344597068E-01],
	[1.1610000000E+04, 7.2536241760E+00, 6.1094399014E+00, 5.7015547038E-01, 4.8651127483E-01, 6.0362023320E-01],
	[1.1615000000E+04, 7.2576351494E+00, 6.1089473213E+00, 5.7093741617E-01, 4.8709545099E-01, 6.0379445875E-01],
	[1.1620000000E+04, 7.2616466130E+00, 6.1084549930E+00, 5.7172009675E-01, 4.8767998692E-01, 6.0396864728E-01],
	[1.1625000000E+04, 7.2656585667E+00, 6.1079629161E+00, 5.7250351249E-01, 4.8826488246E-01, 6.0414279878E-01],
	[1.1630000000E+04, 7.2696710103E+00, 6.1074710904E+00, 5.7328766375E-01, 4.8885013748E-01, 6.0431691322E-01],
	[1.1635000000E+04, 7.2736839436E+00, 6.1069795157E+00, 5.7407255091E-01, 4.8943575184E-01, 6.0449099056E-01],
	[1.1640000000E+04, 7.2776973666E+00, 6.1064881918E+00, 5.7485817435E-01, 4.9002172538E-01, 6.0466503078E-01],
	[1.1645000000E+04, 7.2817112790E+00, 6.1059971183E+00, 5.7564453443E-01, 4.9060805796E-01, 6.0483903386E-01],
	[1.1650000000E+04, 7.2857256808E+00, 6.1055062951E+00, 5.7643163154E-01, 4.9119474945E-01, 6.0501299976E-01],
	[1.1655000000E+04, 7.2897405717E+00, 6.1050157220E+00, 5.7721946604E-01, 4.9178179969E-01, 6.0518692845E-01],
	[1.1660000000E+04, 7.2937642662E+00, 6.1045301434E+00, 5.7800803831E-01, 4.9236927729E-01, 6.0536081991E-01],
	[1.1665000000E+04, 7.2977918913E+00, 6.1040467712E+00, 5.7879734872E-01, 4.9295714208E-01, 6.0553467412E-01],
	[1.1670000000E+04, 7.3018200130E+00, 6.1035636443E+00, 5.7958739765E-01, 4.9354536556E-01, 6.0570849109E-01],
	[1.1675000000E+04, 7.3058486312E+00, 6.1030807627E+00, 5.8037818546E-01, 4.9413394758E-01, 6.0588227079E-01],
	[1.1680000000E+04, 7.3098777457E+00, 6.1025981259E+00, 5.8116971254E-01, 4.9472288799E-01, 6.0605601319E-01],
	[1.1685000000E+04, 7.3139073564E+00, 6.1021157339E+00, 5.8196197926E-01, 4.9531218665E-01, 6.0622971826E-01],
	[1.1690000000E+04, 7.3179374631E+00, 6.1016335864E+00, 5.8275498598E-01, 4.9590184342E-01, 6.0640338596E-01],
	[1.1695000000E+04, 7.3219680657E+00, 6.1011516831E+00, 5.8354873309E-01, 4.9649185814E-01, 6.0657701626E-01],
	[1.1700000000E+04, 7.3259991640E+00, 6.1006700238E+00, 5.8434322096E-01, 4.9708223066E-01, 6.0675060911E-01],
	[1.1705000000E+04, 7.3300307579E+00, 6.1001886084E+00, 5.8513844995E-01, 4.9767296085E-01, 6.0692416448E-01],
	[1.1710000000E+04, 7.3340628472E+00, 6.0997074365E+00, 5.8593442045E-01, 4.9826404855E-01, 6.0709768235E-01],
	[1.1715000000E+04, 7.3380954318E+00, 6.0992265079E+00, 5.8673113283E-01, 4.9885549361E-01, 6.0727116266E-01],
	[1.1720000000E+04, 7.3421285115E+00, 6.0987458224E+00, 5.8752858746E-01, 4.9944729588E-01, 6.0744460540E-01],
	[1.1725000000E+04, 7.3461620861E+00, 6.0982653799E+00, 5.8832678472E-01, 5.0003945522E-01, 6.0761801051E-01],
	[1.1730000000E+04, 7.3501961556E+00, 6.0977851800E+00, 5.8912572498E-01, 5.0063197148E-01, 6.0779137798E-01],
	[1.1735000000E+04, 7.3542307197E+00, 6.0973052225E+00, 5.8992540861E-01, 5.0122484449E-01, 6.0796470776E-01],
	[1.1740000000E+04, 7.3582657783E+00, 6.0968255072E+00, 5.9072583599E-01, 5.0181807413E-01, 6.0813799981E-01],
	[1.1745000000E+04, 7.3623013314E+00, 6.0963460339E+00, 5.9152700749E-01, 5.0241166023E-01, 6.0831125411E-01],
	[1.1750000000E+04, 7.3663373786E+00, 6.0958668024E+00, 5.9232892349E-01, 5.0300560264E-01, 6.0848447062E-01],
	[1.1755000000E+04, 7.3703739199E+00, 6.0953878124E+00, 5.9313158435E-01, 5.0359990121E-01, 6.0865764930E-01],
	[1.1760000000E+04, 7.3744109551E+00, 6.0949090637E+00, 5.9393499046E-01, 5.0419455580E-01, 6.0883079012E-01],
	[1.1765000000E+04, 7.3784484841E+00, 6.0944305561E+00, 5.9473914219E-01, 5.0478956624E-01, 6.0900389304E-01],
	[1.1770000000E+04, 7.3824865067E+00, 6.0939522894E+00, 5.9554403991E-01, 5.0538493239E-01, 6.0917695804E-01],
	[1.1775000000E+04, 7.3865250227E+00, 6.0934742633E+00, 5.9634968400E-01, 5.0598065409E-01, 6.0934998507E-01],
	[1.1780000000E+04, 7.3905640321E+00, 6.0929964776E+00, 5.9715607482E-01, 5.0657673119E-01, 6.0952297411E-01],
	[1.1785000000E+04, 7.3946035347E+00, 6.0925189321E+00, 5.9796321276E-01, 5.0717316355E-01, 6.0969592511E-01],
	[1.1790000000E+04, 7.3986435302E+00, 6.0920416266E+00, 5.9877109819E-01, 5.0776995099E-01, 6.0986883804E-01],
	[1.1795000000E+04, 7.4026840187E+00, 6.0915645608E+00, 5.9957973148E-01, 5.0836709337E-01, 6.1004171288E-01],
	[1.1800000000E+04, 7.4067249998E+00, 6.0910877345E+00, 6.0038911301E-01, 5.0896459054E-01, 6.1021454958E-01],
	[1.1805000000E+04, 7.4107664736E+00, 6.0906111476E+00, 6.0119924315E-01, 5.0956244235E-01, 6.1038734812E-01],
	[1.1810000000E+04, 7.4148084397E+00, 6.0901347997E+00, 6.0201012228E-01, 5.1016064862E-01, 6.1056010845E-01],
	[1.1815000000E+04, 7.4188508982E+00, 6.0896586907E+00, 6.0282175076E-01, 5.1075920922E-01, 6.1073283055E-01],
	[1.1820000000E+04, 7.4228938487E+00, 6.0891828203E+00, 6.0363412898E-01, 5.1135812398E-01, 6.1090551437E-01],
	[1.1825000000E+04, 7.4269372913E+00, 6.0887071884E+00, 6.0444725731E-01, 5.1195739275E-01, 6.1107815990E-01],
	[1.1830000000E+04, 7.4309812257E+00, 6.0882317946E+00, 6.0526113612E-01, 5.1255701538E-01, 6.1125076709E-01],
	[1.1835000000E+04, 7.4350256517E+00, 6.0877566389E+00, 6.0607576579E-01, 5.1315699170E-01, 6.1142333591E-01],
	[1.1840000000E+04, 7.4390705693E+00, 6.0872817208E+00, 6.0689114669E-01, 5.1375732156E-01, 6.1159586633E-01],
	[1.1845000000E+04, 7.4431181581E+00, 6.0868082122E+00, 6.0770727920E-01, 5.1435802358E-01, 6.1176835831E-01],
	[1.1850000000E+04, 7.4471763771E+00, 6.0863403868E+00, 6.0852416369E-01, 5.1495916635E-01, 6.1194081182E-01],
	[1.1855000000E+04, 7.4512350954E+00, 6.0858727947E+00, 6.0934180053E-01, 5.1556066259E-01, 6.1211322683E-01],
	[1.1860000000E+04, 7.4552943129E+00, 6.0854054357E+00, 6.1016019011E-01, 5.1616251213E-01, 6.1228560330E-01],
	[1.1865000000E+04, 7.4593540294E+00, 6.0849383095E+00, 6.1097933279E-01, 5.1676471481E-01, 6.1245794121E-01],
	[1.1870000000E+04, 7.4634142447E+00, 6.0844714159E+00, 6.1179922895E-01, 5.1736727049E-01, 6.1263024051E-01],
	[1.1875000000E+04, 7.4674749587E+00, 6.0840047548E+00, 6.1261987896E-01, 5.1797017899E-01, 6.1280250119E-01],
	[1.1880000000E+04, 7.4715361713E+00, 6.0835383259E+00, 6.1344128320E-01, 5.1857344016E-01, 6.1297472319E-01],
	[1.1885000000E+04, 7.4755978823E+00, 6.0830721290E+00, 6.1426344205E-01, 5.1917705384E-01, 6.1314690650E-01],
	[1.1890000000E+04, 7.4796600915E+00, 6.0826061639E+00, 6.1508635587E-01, 5.1978101988E-01, 6.1331905107E-01],
	[1.1895000000E+04, 7.4837227989E+00, 6.0821404304E+00, 6.1591002505E-01, 5.2038533810E-01, 6.1349115688E-01],
	[1.1900000000E+04, 7.4877860042E+00, 6.0816749282E+00, 6.1673444996E-01, 5.2099000836E-01, 6.1366322389E-01],
	[1.1905000000E+04, 7.4918497073E+00, 6.0812096572E+00, 6.1755963097E-01, 5.2159503049E-01, 6.1383525207E-01],
	[1.1910000000E+04, 7.4959139081E+00, 6.0807446172E+00, 6.1838556845E-01, 5.2220040432E-01, 6.1400724139E-01],
	[1.1915000000E+04, 7.4999786064E+00, 6.0802798078E+00, 6.1921226279E-01, 5.2280612971E-01, 6.1417919182E-01],
	[1.1920000000E+04, 7.5040438020E+00, 6.0798152290E+00, 6.2003971436E-01, 5.2341220648E-01, 6.1435110332E-01],
	[1.1925000000E+04, 7.5081094949E+00, 6.0793508805E+00, 6.2086792353E-01, 5.2401863448E-01, 6.1452297587E-01],
	[1.1930000000E+04, 7.5121756849E+00, 6.0788867621E+00, 6.2169689068E-01, 5.2462541354E-01, 6.1469480942E-01],
	[1.1935000000E+04, 7.5162423718E+00, 6.0784228736E+00, 6.2252661617E-01, 5.2523254350E-01, 6.1486660395E-01],
	[1.1940000000E+04, 7.5203095554E+00, 6.0779592147E+00, 6.2335710040E-01, 5.2584002420E-01, 6.1503835943E-01],
	[1.1945000000E+04, 7.5243772357E+00, 6.0774957853E+00, 6.2418834373E-01, 5.2644785547E-01, 6.1521007582E-01],
	[1.1950000000E+04, 7.5284454125E+00, 6.0770325852E+00, 6.2502034654E-01, 5.2705603716E-01, 6.1538175310E-01],
	[1.1955000000E+04, 7.5325140856E+00, 6.0765696141E+00, 6.2585310920E-01, 5.2766456909E-01, 6.1555339122E-01],
	[1.1960000000E+04, 7.5365832549E+00, 6.0761068719E+00, 6.2668663209E-01, 5.2827345110E-01, 6.1572499017E-01],
	[1.1965000000E+04, 7.5406529203E+00, 6.0756443583E+00, 6.2752091558E-01, 5.2888268303E-01, 6.1589654990E-01],
	[1.1970000000E+04, 7.5447230815E+00, 6.0751820731E+00, 6.2835596005E-01, 5.2949226472E-01, 6.1606807040E-01],
	[1.1975000000E+04, 7.5487937385E+00, 6.0747200161E+00, 6.2919176587E-01, 5.3010219599E-01, 6.1623955161E-01],
	[1.1980000000E+04, 7.5528648911E+00, 6.0742581872E+00, 6.3002833343E-01, 5.3071247669E-01, 6.1641099352E-01],
	[1.1985000000E+04, 7.5569365391E+00, 6.0737965860E+00, 6.3086566308E-01, 5.3132310664E-01, 6.1658239610E-01],
	[1.1990000000E+04, 7.5610086825E+00, 6.0733352124E+00, 6.3170375522E-01, 5.3193408569E-01, 6.1675375930E-01],
	[1.1995000000E+04, 7.5650813210E+00, 6.0728740662E+00, 6.3254261021E-01, 5.3254541366E-01, 6.1692508311E-01],
	[1.2000000000E+04, 7.5691544545E+00, 6.0724131472E+00, 6.3338222843E-01, 5.3315709039E-01, 6.1709636748E-01],
	[1.2005000000E+04, 7.5732280829E+00, 6.0719524552E+00, 6.3422261026E-01, 5.3376911570E-01, 6.1726761240E-01],
	[1.2010000000E+04, 7.5773022060E+00, 6.0714919899E+00, 6.3506375607E-01, 5.3438148944E-01, 6.1743881782E-01],
	[1.2015000000E+04, 7.5813768237E+00, 6.0710317512E+00, 6.3590566623E-01, 5.3499421144E-01, 6.1760998372E-01],
	[1.2020000000E+04, 7.5854519359E+00, 6.0705717388E+00, 6.3674834113E-01, 5.3560728152E-01, 6.1778111006E-01],
	[1.2025000000E+04, 7.5895275423E+00, 6.0701119526E+00, 6.3759178113E-01, 5.3622069953E-01, 6.1795219682E-01],
	[1.2030000000E+04, 7.5936036428E+00, 6.0696523923E+00, 6.3843598662E-01, 5.3683446528E-01, 6.1812324397E-01],
	[1.2035000000E+04, 7.5976807811E+00, 6.0691933335E+00, 6.3928095796E-01, 5.3744858350E-01, 6.1829425147E-01],
	[1.2040000000E+04, 7.6017707596E+00, 6.0687407580E+00, 6.4012669554E-01, 5.3806316019E-01, 6.1846521930E-01],
	[1.2045000000E+04, 7.6058612403E+00, 6.0682884041E+00, 6.4097319973E-01, 5.3867808454E-01, 6.1863614742E-01],
	[1.2050000000E+04, 7.6099522230E+00, 6.0678362716E+00, 6.4182047090E-01, 5.3929335639E-01, 6.1880703580E-01],
	[1.2055000000E+04, 7.6140437077E+00, 6.0673843604E+00, 6.4266850944E-01, 5.3990897556E-01, 6.1897788442E-01],
	[1.2060000000E+04, 7.6181356941E+00, 6.0669326702E+00, 6.4351731571E-01, 5.4052494189E-01, 6.1914869324E-01],
	[1.2065000000E+04, 7.6222281821E+00, 6.0664812009E+00, 6.4436689010E-01, 5.4114125520E-01, 6.1931946223E-01],
	[1.2070000000E+04, 7.6263211716E+00, 6.0660299522E+00, 6.4521723297E-01, 5.4175791532E-01, 6.1949019137E-01],
	[1.2075000000E+04, 7.6304146624E+00, 6.0655789239E+00, 6.4606834471E-01, 5.4237492208E-01, 6.1966088062E-01],
	[1.2080000000E+04, 7.6345086544E+00, 6.0651281158E+00, 6.4692022569E-01, 5.4299227531E-01, 6.1983152996E-01],
	[1.2085000000E+04, 7.6386031474E+00, 6.0646775278E+00, 6.4777287628E-01, 5.4360997485E-01, 6.2000213935E-01],
	[1.2090000000E+04, 7.6426981413E+00, 6.0642271597E+00, 6.4862629686E-01, 5.4422802051E-01, 6.2017270876E-01],
	[1.2095000000E+04, 7.6467936359E+00, 6.0637770112E+00, 6.4948048782E-01, 5.4484641212E-01, 6.2034323817E-01],
	[1.2100000000E+04, 7.6508896312E+00, 6.0633270821E+00, 6.5033544951E-01, 5.4546514952E-01, 6.2051372754E-01],
	[1.2105000000E+04, 7.6549861268E+00, 6.0628773722E+00, 6.5119118233E-01, 5.4608423253E-01, 6.2068417685E-01],
	[1.2110000000E+04, 7.6590831228E+00, 6.0624278815E+00, 6.5204768664E-01, 5.4670366097E-01, 6.2085458607E-01],
	[1.2115000000E+04, 7.6631806189E+00, 6.0619786095E+00, 6.5290496282E-01, 5.4732343468E-01, 6.2102495516E-01],
	[1.2120000000E+04, 7.6672786150E+00, 6.0615295563E+00, 6.5376301125E-01, 5.4794355348E-01, 6.2119528410E-01],
	[1.2125000000E+04, 7.6713771110E+00, 6.0610807214E+00, 6.5462183230E-01, 5.4856401719E-01, 6.2136557285E-01],
	[1.2130000000E+04, 7.6754761067E+00, 6.0606321049E+00, 6.5548142635E-01, 5.4918482565E-01, 6.2153582140E-01],
	[1.2135000000E+04, 7.6795756020E+00, 6.0601837064E+00, 6.5634179378E-01, 5.4980597867E-01, 6.2170602971E-01],
	[1.2140000000E+04, 7.6836755967E+00, 6.0597355258E+00, 6.5720293495E-01, 5.5042747608E-01, 6.2187619774E-01],
	[1.2145000000E+04, 7.6877760907E+00, 6.0592875628E+00, 6.5806485026E-01, 5.5104931771E-01, 6.2204632548E-01],
	[1.2150000000E+04, 7.6918770839E+00, 6.0588398174E+00, 6.5892754007E-01, 5.5167150338E-01, 6.2221641290E-01],
	[1.2155000000E+04, 7.6959785760E+00, 6.0583922892E+00, 6.5979100476E-01, 5.5229403292E-01, 6.2238645995E-01],
	[1.2160000000E+04, 7.7000805669E+00, 6.0579449781E+00, 6.6065524471E-01, 5.5291690614E-01, 6.2255646663E-01],
	[1.2165000000E+04, 7.7041830566E+00, 6.0574978839E+00, 6.6152026029E-01, 5.5354012288E-01, 6.2272643289E-01],
	[1.2170000000E+04, 7.7082860449E+00, 6.0570510064E+00, 6.6238605188E-01, 5.5416368294E-01, 6.2289635871E-01],
	[1.2175000000E+04, 7.7123895315E+00, 6.0566043454E+00, 6.6325261986E-01, 5.5478758617E-01, 6.2306624406E-01],
	[1.2180000000E+04, 7.7164935164E+00, 6.0561579008E+00, 6.6411996459E-01, 5.5541183238E-01, 6.2323608891E-01],
	[1.2185000000E+04, 7.7205979995E+00, 6.0557116722E+00, 6.6498808647E-01, 5.5603642138E-01, 6.2340589323E-01],
	[1.2190000000E+04, 7.7247029805E+00, 6.0552656596E+00, 6.6585698586E-01, 5.5666135302E-01, 6.2357565700E-01],
	[1.2195000000E+04, 7.7288084594E+00, 6.0548198627E+00, 6.6672666314E-01, 5.5728662709E-01, 6.2374538018E-01],
	[1.2200000000E+04, 7.7329144359E+00, 6.0543742814E+00, 6.6759711869E-01, 5.5791224344E-01, 6.2391506276E-01],
	[1.2205000000E+04, 7.7370209101E+00, 6.0539289154E+00, 6.6846835288E-01, 5.5853820187E-01, 6.2408470469E-01],
	[1.2210000000E+04, 7.7411278816E+00, 6.0534837645E+00, 6.6934036609E-01, 5.5916450221E-01, 6.2425430596E-01],
	[1.2215000000E+04, 7.7452353504E+00, 6.0530388287E+00, 6.7021315870E-01, 5.5979114427E-01, 6.2442386653E-01],
	[1.2220000000E+04, 7.7493433163E+00, 6.0525941075E+00, 6.7108673109E-01, 5.6041812789E-01, 6.2459338638E-01],
	[1.2225000000E+04, 7.7534517792E+00, 6.0521496010E+00, 6.7196108362E-01, 5.6104545287E-01, 6.2476286548E-01],
	[1.2230000000E+04, 7.7575646902E+00, 6.0517072020E+00, 6.7283621668E-01, 5.6167315606E-01, 6.2493230380E-01],
	[1.2235000000E+04, 7.7616876173E+00, 6.0512695730E+00, 6.7371213065E-01, 5.6230128968E-01, 6.2510170131E-01],
	[1.2240000000E+04, 7.7658110497E+00, 6.0508321544E+00, 6.7458882589E-01, 5.6292976458E-01, 6.2527105798E-01],
	[1.2245000000E+04, 7.7699349873E+00, 6.0503949461E+00, 6.7546630279E-01, 5.6355858056E-01, 6.2544037380E-01],
	[1.2250000000E+04, 7.7740594299E+00, 6.0499579478E+00, 6.7634456173E-01, 5.6418773745E-01, 6.2560964873E-01],
	[1.2255000000E+04, 7.7781843774E+00, 6.0495211595E+00, 6.7722360307E-01, 5.6481723507E-01, 6.2577888274E-01],
	[1.2260000000E+04, 7.7823098297E+00, 6.0490845808E+00, 6.7810342720E-01, 5.6544707324E-01, 6.2594807580E-01],
	[1.2265000000E+04, 7.7864357866E+00, 6.0486482116E+00, 6.7898403450E-01, 5.6607725177E-01, 6.2611722789E-01],
	[1.2270000000E+04, 7.7905622479E+00, 6.0482120517E+00, 6.7986542534E-01, 5.6670777048E-01, 6.2628633899E-01],
	[1.2275000000E+04, 7.7946892136E+00, 6.0477761009E+00, 6.8074760010E-01, 5.6733862919E-01, 6.2645540906E-01],
	[1.2280000000E+04, 7.7988166835E+00, 6.0473403591E+00, 6.8163055915E-01, 5.6796982772E-01, 6.2662443808E-01],
	[1.2285000000E+04, 7.8029446574E+00, 6.0469048261E+00, 6.8251430287E-01, 5.6860136588E-01, 6.2679342601E-01],
	[1.2290000000E+04, 7.8070731351E+00, 6.0464695016E+00, 6.8339883164E-01, 5.6923324348E-01, 6.2696237284E-01],
	[1.2295000000E+04, 7.8112021167E+00, 6.0460343855E+00, 6.8428414583E-01, 5.6986546035E-01, 6.2713127854E-01],
	[1.2300000000E+04, 7.8153316018E+00, 6.0455994776E+00, 6.8517024583E-01, 5.7049801630E-01, 6.2730014308E-01],
	[1.2305000000E+04, 7.8194615904E+00, 6.0451647778E+00, 6.8605713201E-01, 5.7113091115E-01, 6.2746896643E-01],
	[1.2310000000E+04, 7.8235920823E+00, 6.0447302857E+00, 6.8694480474E-01, 5.7176414471E-01, 6.2763774856E-01],
	[1.2315000000E+04, 7.8277230773E+00, 6.0442960014E+00, 6.8783326441E-01, 5.7239771679E-01, 6.2780648946E-01],
	[1.2320000000E+04, 7.8318545754E+00, 6.0438619245E+00, 6.8872251139E-01, 5.7303162722E-01, 6.2797518909E-01],
	[1.2325000000E+04, 7.8359865764E+00, 6.0434280549E+00, 6.8961254606E-01, 5.7366587579E-01, 6.2814384742E-01],
	[1.2330000000E+04, 7.8401190802E+00, 6.0429943923E+00, 6.9050336879E-01, 5.7430046234E-01, 6.2831246444E-01],
	[1.2335000000E+04, 7.8442520865E+00, 6.0425609368E+00, 6.9139497997E-01, 5.7493538667E-01, 6.2848104011E-01],
	[1.2340000000E+04, 7.8483855953E+00, 6.0421276879E+00, 6.9228737996E-01, 5.7557064859E-01, 6.2864957441E-01],
	[1.2345000000E+04, 7.8525196064E+00, 6.0416946456E+00, 6.9318056915E-01, 5.7620624792E-01, 6.2881806730E-01],
	[1.2350000000E+04, 7.8566541197E+00, 6.0412618097E+00, 6.9407454792E-01, 5.7684218448E-01, 6.2898651878E-01],
	[1.2355000000E+04, 7.8607891350E+00, 6.0408291800E+00, 6.9496931663E-01, 5.7747845806E-01, 6.2915492880E-01],
	[1.2360000000E+04, 7.8649246522E+00, 6.0403967562E+00, 6.9586487568E-01, 5.7811506849E-01, 6.2932329735E-01],
	[1.2365000000E+04, 7.8690606711E+00, 6.0399645383E+00, 6.9676122543E-01, 5.7875201558E-01, 6.2949162439E-01],
	[1.2370000000E+04, 7.8731971917E+00, 6.0395325261E+00, 6.9765836627E-01, 5.7938929913E-01, 6.2965990991E-01],
	[1.2375000000E+04, 7.8773342137E+00, 6.0391007193E+00, 6.9855629856E-01, 5.8002691897E-01, 6.2982815387E-01],
	[1.2380000000E+04, 7.8814717371E+00, 6.0386691178E+00, 6.9945502270E-01, 5.8066487489E-01, 6.2999635625E-01],
	[1.2385000000E+04, 7.8856097616E+00, 6.0382377215E+00, 7.0035453905E-01, 5.8130316672E-01, 6.3016451703E-01],
	[1.2390000000E+04, 7.8897482871E+00, 6.0378065300E+00, 7.0125484799E-01, 5.8194179425E-01, 6.3033263617E-01],
	[1.2395000000E+04, 7.8938873136E+00, 6.0373755433E+00, 7.0215594990E-01, 5.8258075731E-01, 6.3050071366E-01],
	[1.2400000000E+04, 7.8980268408E+00, 6.0369447611E+00, 7.0305784517E-01, 5.8322005569E-01, 6.3066874946E-01],
	[1.2405000000E+04, 7.9021668686E+00, 6.0365141834E+00, 7.0396053415E-01, 5.8385968922E-01, 6.3083674356E-01],
	[1.2410000000E+04, 7.9063073969E+00, 6.0360838098E+00, 7.0486401725E-01, 5.8449965770E-01, 6.3100469593E-01],
	[1.2415000000E+04, 7.9104484255E+00, 6.0356536403E+00, 7.0576829482E-01, 5.8513996093E-01, 6.3117260653E-01],
	[1.2420000000E+04, 7.9145899543E+00, 6.0352236746E+00, 7.0667336725E-01, 5.8578059873E-01, 6.3134047536E-01],
	[1.2425000000E+04, 7.9187319832E+00, 6.0347939126E+00, 7.0757923492E-01, 5.8642157090E-01, 6.3150830237E-01],
	[1.2430000000E+04, 7.9228874554E+00, 6.0343702197E+00, 7.0848589820E-01, 5.8706300383E-01, 6.3167608755E-01],
	[1.2435000000E+04, 7.9270445477E+00, 6.0339472306E+00, 7.0939335748E-01, 5.8770478208E-01, 6.3184383087E-01],
	[1.2440000000E+04, 7.9312021488E+00, 6.0335244411E+00, 7.1030161312E-01, 5.8834689460E-01, 6.3201153231E-01],
	[1.2445000000E+04, 7.9353602583E+00, 6.0331018511E+00, 7.1121066551E-01, 5.8898934120E-01, 6.3217919184E-01],
	[1.2450000000E+04, 7.9395188764E+00, 6.0326794605E+00, 7.1212051503E-01, 5.8963212169E-01, 6.3234680944E-01],
	[1.2455000000E+04, 7.9436780026E+00, 6.0322572690E+00, 7.1303116205E-01, 5.9027523586E-01, 6.3251438508E-01],
	[1.2460000000E+04, 7.9478376370E+00, 6.0318352765E+00, 7.1394260695E-01, 5.9091868354E-01, 6.3268191874E-01],
	[1.2465000000E+04, 7.9519977794E+00, 6.0314134829E+00, 7.1485485011E-01, 5.9156246452E-01, 6.3284941038E-01],
	[1.2470000000E+04, 7.9561584296E+00, 6.0309918878E+00, 7.1576789191E-01, 5.9220657862E-01, 6.3301686000E-01],
	[1.2475000000E+04, 7.9603195875E+00, 6.0305704912E+00, 7.1668173272E-01, 5.9285102563E-01, 6.3318426756E-01],
	[1.2480000000E+04, 7.9644812530E+00, 6.0301492929E+00, 7.1759637292E-01, 5.9349580537E-01, 6.3335163304E-01],
	[1.2485000000E+04, 7.9686434259E+00, 6.0297282927E+00, 7.1851181290E-01, 5.9414091763E-01, 6.3351895642E-01],
	[1.2490000000E+04, 7.9728061061E+00, 6.0293074905E+00, 7.1942805302E-01, 5.9478636223E-01, 6.3368623766E-01],
	[1.2495000000E+04, 7.9769692934E+00, 6.0288868860E+00, 7.2034509367E-01, 5.9543213897E-01, 6.3385347675E-01],
	[1.2500000000E+04, 7.9811329877E+00, 6.0284664792E+00, 7.2126293523E-01, 5.9607824765E-01, 6.3402067367E-01],
	[1.2505000000E+04, 7.9852971889E+00, 6.0280462697E+00, 7.2218494294E-01, 5.9672698541E-01, 6.3418782838E-01],
	[1.2510000000E+04, 7.9894618967E+00, 6.0276262575E+00, 7.2310775949E-01, 5.9737605788E-01, 6.3435494087E-01],
	[1.2515000000E+04, 7.9936271112E+00, 6.0272064424E+00, 7.2403138528E-01, 5.9802546487E-01, 6.3452201110E-01],
	[1.2520000000E+04, 7.9977928320E+00, 6.0267868243E+00, 7.2495582067E-01, 5.9867520617E-01, 6.3468903907E-01],
	[1.2525000000E+04, 8.0019590592E+00, 6.0263674028E+00, 7.2588106606E-01, 5.9932528159E-01, 6.3485602473E-01],
	[1.2530000000E+04, 8.0061257925E+00, 6.0259481779E+00, 7.2680712184E-01, 5.9997569092E-01, 6.3502296807E-01],
	[1.2535000000E+04, 8.0102930318E+00, 6.0255291495E+00, 7.2773398839E-01, 6.0062643398E-01, 6.3518986907E-01],
	[1.2540000000E+04, 8.0144607769E+00, 6.0251103172E+00, 7.2866166609E-01, 6.0127751056E-01, 6.3535672770E-01],
	[1.2545000000E+04, 8.0186290278E+00, 6.0246916810E+00, 7.2959015533E-01, 6.0192892046E-01, 6.3552354394E-01],
	[1.2550000000E+04, 8.0227977843E+00, 6.0242732408E+00, 7.3051945650E-01, 6.0258066348E-01, 6.3569031776E-01],
	[1.2555000000E+04, 8.0269670463E+00, 6.0238549962E+00, 7.3144956997E-01, 6.0323273942E-01, 6.3585704914E-01],
	[1.2560000000E+04, 8.0311368135E+00, 6.0234369472E+00, 7.3238049615E-01, 6.0388514808E-01, 6.3602373806E-01],
	[1.2565000000E+04, 8.0353070859E+00, 6.0230190935E+00, 7.3331223540E-01, 6.0453788926E-01, 6.3619038450E-01],
	[1.2570000000E+04, 8.0394778633E+00, 6.0226014351E+00, 7.3424478813E-01, 6.0519096276E-01, 6.3635698842E-01],
	[1.2575000000E+04, 8.0436491457E+00, 6.0221839717E+00, 7.3517815470E-01, 6.0584436838E-01, 6.3652354981E-01],
	[1.2580000000E+04, 8.0478209327E+00, 6.0217667032E+00, 7.3611233552E-01, 6.0649810592E-01, 6.3669006865E-01],
	[1.2585000000E+04, 8.0519932244E+00, 6.0213496294E+00, 7.3704733095E-01, 6.0715217516E-01, 6.3685654491E-01],
	[1.2590000000E+04, 8.0561660205E+00, 6.0209327502E+00, 7.3798314140E-01, 6.0780657592E-01, 6.3702297856E-01],
	[1.2595000000E+04, 8.0603393210E+00, 6.0205160653E+00, 7.3891976725E-01, 6.0846130799E-01, 6.3718936960E-01],
	[1.2600000000E+04, 8.0645131257E+00, 6.0200995746E+00, 7.3985720887E-01, 6.0911637117E-01, 6.3735571799E-01],
	[1.2605000000E+04, 8.0686874344E+00, 6.0196832780E+00, 7.4079546666E-01, 6.0977176524E-01, 6.3752202380E-01],
	[1.2610000000E+04, 8.0728622470E+00, 6.0192671752E+00, 7.4173454101E-01, 6.1042749002E-01, 6.3768828700E-01],
	[1.2615000000E+04, 8.0770375634E+00, 6.0188512661E+00, 7.4267443229E-01, 6.1108354529E-01, 6.3785450757E-01],
	[1.2620000000E+04, 8.0812133834E+00, 6.0184355506E+00, 7.4361514089E-01, 6.1173993085E-01, 6.3802068547E-01],
	[1.2625000000E+04, 8.0853897069E+00, 6.0180200284E+00, 7.4455666721E-01, 6.1239664651E-01, 6.3818682068E-01],
	[1.2630000000E+04, 8.0895799665E+00, 6.0176104736E+00, 7.4549901162E-01, 6.1305382911E-01, 6.3835291315E-01],
	[1.2635000000E+04, 8.0937719939E+00, 6.0172016483E+00, 7.4644217452E-01, 6.1371135470E-01, 6.3851896287E-01],
	[1.2640000000E+04, 8.0979645338E+00, 6.0167930125E+00, 7.4738615628E-01, 6.1436921026E-01, 6.3868496980E-01],
	[1.2645000000E+04, 8.1021575860E+00, 6.0163845660E+00, 7.4833095730E-01, 6.1502739559E-01, 6.3885093391E-01],
	[1.2650000000E+04, 8.1063511504E+00, 6.0159763088E+00, 7.4927657795E-01, 6.1568591050E-01, 6.3901685516E-01],
	[1.2655000000E+04, 8.1105452268E+00, 6.0155682405E+00, 7.5022301863E-01, 6.1634475476E-01, 6.3918273354E-01],
	[1.2660000000E+04, 8.1147398151E+00, 6.0151603612E+00, 7.5117027973E-01, 6.1700392819E-01, 6.3934856901E-01],
	[1.2665000000E+04, 8.1189349151E+00, 6.0147526705E+00, 7.5211836162E-01, 6.1766343057E-01, 6.3951436154E-01],
	[1.2670000000E+04, 8.1231305268E+00, 6.0143451683E+00, 7.5306726469E-01, 6.1832326170E-01, 6.3968011110E-01],
	[1.2675000000E+04, 8.1273266500E+00, 6.0139378546E+00, 7.5401698934E-01, 6.1898342136E-01, 6.3984581766E-01],
	[1.2680000000E+04, 8.1315232845E+00, 6.0135307290E+00, 7.5496753594E-01, 6.1964390936E-01, 6.4001148118E-01],
	[1.2685000000E+04, 8.1357204302E+00, 6.0131237915E+00, 7.5591890488E-01, 6.2030472548E-01, 6.4017710165E-01],
	[1.2690000000E+04, 8.1399180869E+00, 6.0127170419E+00, 7.5687109655E-01, 6.2096586953E-01, 6.4034267903E-01],
	[1.2695000000E+04, 8.1441162546E+00, 6.0123104800E+00, 7.5782411134E-01, 6.2162734128E-01, 6.4050821328E-01],
	[1.2700000000E+04, 8.1483149330E+00, 6.0119041057E+00, 7.5877794962E-01, 6.2228914054E-01, 6.4067370439E-01],
	[1.2705000000E+04, 8.1525141221E+00, 6.0114979188E+00, 7.5973261180E-01, 6.2295126709E-01, 6.4083915232E-01],
	[1.2710000000E+04, 8.1567138217E+00, 6.0110919191E+00, 7.6068809825E-01, 6.2361372073E-01, 6.4100455704E-01],
	[1.2715000000E+04, 8.1609140317E+00, 6.0106861065E+00, 7.6164440936E-01, 6.2427650125E-01, 6.4116991853E-01],
	[1.2720000000E+04, 8.1651147519E+00, 6.0102804809E+00, 7.6260154551E-01, 6.2493960844E-01, 6.4133523674E-01],
	[1.2725000000E+04, 8.1693159822E+00, 6.0098750420E+00, 7.6355950710E-01, 6.2560304208E-01, 6.4150051166E-01],
	[1.2730000000E+04, 8.1735177224E+00, 6.0094697898E+00, 7.6451829451E-01, 6.2626680198E-01, 6.4166574326E-01],
	[1.2735000000E+04, 8.1777199724E+00, 6.0090647239E+00, 7.6547790812E-01, 6.2693088791E-01, 6.4183093150E-01],
	[1.2740000000E+04, 8.1819227321E+00, 6.0086598444E+00, 7.6643834833E-01, 6.2759529968E-01, 6.4199607636E-01],
	[1.2745000000E+04, 8.1861260014E+00, 6.0082551510E+00, 7.6739961551E-01, 6.2826003707E-01, 6.4216117780E-01],
	[1.2750000000E+04, 8.1903297800E+00, 6.0078506436E+00, 7.6836171006E-01, 6.2892509986E-01, 6.4232623581E-01],
	[1.2755000000E+04, 8.1945340679E+00, 6.0074463220E+00, 7.6932463236E-01, 6.2959048785E-01, 6.4249125034E-01],
	[1.2760000000E+04, 8.1987388649E+00, 6.0070421861E+00, 7.7028838280E-01, 6.3025620083E-01, 6.4265622138E-01],
	[1.2765000000E+04, 8.2029441709E+00, 6.0066382357E+00, 7.7125296177E-01, 6.3092223858E-01, 6.4282114889E-01],
	[1.2770000000E+04, 8.2071499857E+00, 6.0062344706E+00, 7.7221836964E-01, 6.3158860089E-01, 6.4298603284E-01],
	[1.2775000000E+04, 8.2113563093E+00, 6.0058308907E+00, 7.7318460682E-01, 6.3225528756E-01, 6.4315087321E-01],
	[1.2780000000E+04, 8.2155631414E+00, 6.0054274958E+00, 7.7415167368E-01, 6.3292229836E-01, 6.4331566996E-01],
	[1.2785000000E+04, 8.2197704820E+00, 6.0050242858E+00, 7.7511957061E-01, 6.3358963308E-01, 6.4348042307E-01],
	[1.2790000000E+04, 8.2239783308E+00, 6.0046212605E+00, 7.7608829801E-01, 6.3425729152E-01, 6.4364513252E-01],
	[1.2795000000E+04, 8.2281866878E+00, 6.0042184198E+00, 7.7705785624E-01, 6.3492527346E-01, 6.4380979827E-01],
	[1.2800000000E+04, 8.2323955528E+00, 6.0038157635E+00, 7.7802824571E-01, 6.3559357868E-01, 6.4397442029E-01],
	[1.2805000000E+04, 8.2366049257E+00, 6.0034132914E+00, 7.7899946680E-01, 6.3626220698E-01, 6.4413899855E-01],
	[1.2810000000E+04, 8.2408148063E+00, 6.0030110034E+00, 7.7997151990E-01, 6.3693115813E-01, 6.4430353304E-01],
	[1.2815000000E+04, 8.2450251946E+00, 6.0026088993E+00, 7.8094440539E-01, 6.3760043192E-01, 6.4446802371E-01],
	[1.2820000000E+04, 8.2492360903E+00, 6.0022069790E+00, 7.8191812365E-01, 6.3827002814E-01, 6.4463247055E-01],
	[1.2825000000E+04, 8.2534474934E+00, 6.0018052423E+00, 7.8289267509E-01, 6.3893994657E-01, 6.4479687352E-01],
	[1.2830000000E+04, 8.2576634582E+00, 6.0014053466E+00, 7.8386806008E-01, 6.3961023016E-01, 6.4496123260E-01],
	[1.2835000000E+04, 8.2618912357E+00, 6.0010102512E+00, 7.8484427901E-01, 6.4028095612E-01, 6.4512554776E-01],
	[1.2840000000E+04, 8.2661195299E+00, 6.0006153357E+00, 7.8582133227E-01, 6.4095200418E-01, 6.4528981897E-01],
	[1.2845000000E+04, 8.2703483405E+00, 6.0002205999E+00, 7.8679922024E-01, 6.4162337414E-01, 6.4545404620E-01],
	[1.2850000000E+04, 8.2745776675E+00, 5.9998260437E+00, 7.8777794332E-01, 6.4229506576E-01, 6.4561822943E-01],
	[1.2855000000E+04, 8.2788075107E+00, 5.9994316669E+00, 7.8875750189E-01, 6.4296707884E-01, 6.4578236863E-01],
	[1.2860000000E+04, 8.2830378700E+00, 5.9990374694E+00, 7.8973789633E-01, 6.4363941317E-01, 6.4594646377E-01],
	[1.2865000000E+04, 8.2872687452E+00, 5.9986434510E+00, 7.9071912704E-01, 6.4431206851E-01, 6.4611051483E-01],
	[1.2870000000E+04, 8.2915001362E+00, 5.9982496116E+00, 7.9170119439E-01, 6.4498504467E-01, 6.4627452178E-01],
	[1.2875000000E+04, 8.2957320429E+00, 5.9978559510E+00, 7.9268409879E-01, 6.4565834141E-01, 6.4643848458E-01],
	[1.2880000000E+04, 8.2999644652E+00, 5.9974624691E+00, 7.9366784061E-01, 6.4633195853E-01, 6.4660240322E-01],
	[1.2885000000E+04, 8.3041974028E+00, 5.9970691656E+00, 7.9465242025E-01, 6.4700589581E-01, 6.4676627767E-01],
	[1.2890000000E+04, 8.3084308557E+00, 5.9966760406E+00, 7.9563783808E-01, 6.4768015302E-01, 6.4693010789E-01],
	[1.2895000000E+04, 8.3126648237E+00, 5.9962830938E+00, 7.9662409451E-01, 6.4835472995E-01, 6.4709389387E-01],
	[1.2900000000E+04, 8.3168993066E+00, 5.9958903250E+00, 7.9761118990E-01, 6.4902962638E-01, 6.4725763558E-01],
	[1.2905000000E+04, 8.3211343044E+00, 5.9954977342E+00, 7.9859912466E-01, 6.4970484210E-01, 6.4742133298E-01],
	[1.2910000000E+04, 8.3253698170E+00, 5.9951053211E+00, 7.9958789918E-01, 6.5038037688E-01, 6.4758498606E-01],
	[1.2915000000E+04, 8.3296058441E+00, 5.9947130856E+00, 8.0057751382E-01, 6.5105623050E-01, 6.4774859479E-01],
	[1.2920000000E+04, 8.3338423856E+00, 5.9943210276E+00, 8.0156796900E-01, 6.5173240275E-01, 6.4791215914E-01],
	[1.2925000000E+04, 8.3380794414E+00, 5.9939291470E+00, 8.0255926508E-01, 6.5240889340E-01, 6.4807567908E-01],
	[1.2930000000E+04, 8.3423170114E+00, 5.9935374435E+00, 8.0355140247E-01, 6.5308570224E-01, 6.4823915459E-01],
	[1.2935000000E+04, 8.3465550954E+00, 5.9931459170E+00, 8.0454438154E-01, 6.5376282905E-01, 6.4840258564E-01],
	[1.2940000000E+04, 8.3507936933E+00, 5.9927545674E+00, 8.0553820269E-01, 6.5444027359E-01, 6.4856597221E-01],
	[1.2945000000E+04, 8.3550328049E+00, 5.9923633946E+00, 8.0653286630E-01, 6.5511803567E-01, 6.4872931426E-01],
	[1.2950000000E+04, 8.3592724301E+00, 5.9919723983E+00, 8.0752837277E-01, 6.5579611504E-01, 6.4889261178E-01],
	[1.2955000000E+04, 8.3635125689E+00, 5.9915815785E+00, 8.0852472247E-01, 6.5647451150E-01, 6.4905586474E-01],
	[1.2960000000E+04, 8.3677532209E+00, 5.9911909349E+00, 8.0952191580E-01, 6.5715322481E-01, 6.4921907311E-01],
	[1.2965000000E+04, 8.3719943862E+00, 5.9908004675E+00, 8.1051995314E-01, 6.5783225476E-01, 6.4938223686E-01],
	[1.2970000000E+04, 8.3762360646E+00, 5.9904101760E+00, 8.1151883488E-01, 6.5851160113E-01, 6.4954535598E-01],
	[1.2975000000E+04, 8.3804782559E+00, 5.9900200604E+00, 8.1251856141E-01, 6.5919126369E-01, 6.4970843043E-01],
	[1.2980000000E+04, 8.3847209599E+00, 5.9896301205E+00, 8.1351913312E-01, 6.5987124222E-01, 6.4987146018E-01],
	[1.2985000000E+04, 8.3889641767E+00, 5.9892403562E+00, 8.1452055040E-01, 6.6055153650E-01, 6.5003444523E-01],
	[1.2990000000E+04, 8.3932079060E+00, 5.9888507672E+00, 8.1552281362E-01, 6.6123214630E-01, 6.5019738553E-01],
	[1.2995000000E+04, 8.3974521476E+00, 5.9884613535E+00, 8.1652592319E-01, 6.6191307140E-01, 6.5036028106E-01],
	[1.3000000000E+04, 8.4016969015E+00, 5.9880721150E+00, 8.1752987949E-01, 6.6259431158E-01, 6.5052313180E-01],
	[1.3005000000E+04, 8.4059421676E+00, 5.9876830513E+00, 8.1853468291E-01, 6.6327586661E-01, 6.5068593773E-01],
	[1.3010000000E+04, 8.4101879456E+00, 5.9872941625E+00, 8.1954033383E-01, 6.6395773626E-01, 6.5084869881E-01],
	[1.3015000000E+04, 8.4144342355E+00, 5.9869054484E+00, 8.2054683264E-01, 6.6463992032E-01, 6.5101141502E-01],
	[1.3020000000E+04, 8.4186810371E+00, 5.9865169088E+00, 8.2155417974E-01, 6.6532241856E-01, 6.5117408634E-01],
	[1.3025000000E+04, 8.4229283503E+00, 5.9861285436E+00, 8.2256237550E-01, 6.6600523075E-01, 6.5133671274E-01],
	[1.3030000000E+04, 8.4271761749E+00, 5.9857403526E+00, 8.2357142032E-01, 6.6668835667E-01, 6.5149929420E-01],
	[1.3035000000E+04, 8.4314245108E+00, 5.9853523357E+00, 8.2458131459E-01, 6.6737179609E-01, 6.5166183069E-01],
	[1.3040000000E+04, 8.4356887385E+00, 5.9849704754E+00, 8.2559205869E-01, 6.6805571979E-01, 6.5182432219E-01],
	[1.3045000000E+04, 8.4399541409E+00, 5.9845890401E+00, 8.2660365301E-01, 6.6873996437E-01, 6.5198676868E-01],
	[1.3050000000E+04, 8.4442200642E+00, 5.9842077753E+00, 8.2761609794E-01, 6.6942452234E-01, 6.5214917012E-01],
	[1.3055000000E+04, 8.4484865084E+00, 5.9838266808E+00, 8.2862939387E-01, 6.7010939348E-01, 6.5231152649E-01],
	[1.3060000000E+04, 8.4527534732E+00, 5.9834457565E+00, 8.2964354119E-01, 6.7079457756E-01, 6.5247383778E-01],
	[1.3065000000E+04, 8.4570209586E+00, 5.9830650023E+00, 8.3065854028E-01, 6.7148007436E-01, 6.5263610395E-01],
	[1.3070000000E+04, 8.4612889644E+00, 5.9826844179E+00, 8.3167439154E-01, 6.7216588365E-01, 6.5279832498E-01],
	[1.3075000000E+04, 8.4655574904E+00, 5.9823040033E+00, 8.3269109535E-01, 6.7285200520E-01, 6.5296050085E-01],
	[1.3080000000E+04, 8.4698265365E+00, 5.9819237583E+00, 8.3370865210E-01, 6.7353843878E-01, 6.5312263153E-01],
	[1.3085000000E+04, 8.4740961027E+00, 5.9815436829E+00, 8.3472706217E-01, 6.7422518418E-01, 6.5328471700E-01],
	[1.3090000000E+04, 8.4783661887E+00, 5.9811637767E+00, 8.3574632597E-01, 6.7491224115E-01, 6.5344675723E-01],
	[1.3095000000E+04, 8.4826367944E+00, 5.9807840397E+00, 8.3676644387E-01, 6.7559960947E-01, 6.5360875220E-01],
	[1.3100000000E+04, 8.4869079197E+00, 5.9804044719E+00, 8.3778741626E-01, 6.7628728892E-01, 6.5377070189E-01],
	[1.3105000000E+04, 8.4911795644E+00, 5.9800250729E+00, 8.3880924354E-01, 6.7697527926E-01, 6.5393260628E-01],
	[1.3110000000E+04, 8.4954517285E+00, 5.9796458427E+00, 8.3983192608E-01, 6.7766358027E-01, 6.5409446533E-01],
	[1.3115000000E+04, 8.4997244118E+00, 5.9792667812E+00, 8.4085546429E-01, 6.7835219172E-01, 6.5425627903E-01],
	[1.3120000000E+04, 8.5039976140E+00, 5.9788878881E+00, 8.4187985855E-01, 6.7904111337E-01, 6.5441804734E-01],
	[1.3125000000E+04, 8.5082713353E+00, 5.9785091634E+00, 8.4290510924E-01, 6.7973034500E-01, 6.5457977026E-01],
	[1.3130000000E+04, 8.5125455752E+00, 5.9781306070E+00, 8.4393121676E-01, 6.8041988638E-01, 6.5474144775E-01],
	[1.3135000000E+04, 8.5168203339E+00, 5.9777522186E+00, 8.4495818149E-01, 6.8110973728E-01, 6.5490307979E-01],
	[1.3140000000E+04, 8.5210956110E+00, 5.9773739982E+00, 8.4598600383E-01, 6.8179989746E-01, 6.5506466636E-01],
	[1.3145000000E+04, 8.5253714065E+00, 5.9769959456E+00, 8.4701468416E-01, 6.8249036671E-01, 6.5522620744E-01],
	[1.3150000000E+04, 8.5296477202E+00, 5.9766180606E+00, 8.4804422287E-01, 6.8318114478E-01, 6.5538770299E-01],
	[1.3155000000E+04, 8.5339245521E+00, 5.9762403432E+00, 8.4907462035E-01, 6.8387223144E-01, 6.5554915301E-01],
	[1.3160000000E+04, 8.5382019019E+00, 5.9758627932E+00, 8.5010587698E-01, 6.8456362647E-01, 6.5571055746E-01],
	[1.3165000000E+04, 8.5424797695E+00, 5.9754854105E+00, 8.5113799317E-01, 6.8525532963E-01, 6.5587191632E-01],
	[1.3170000000E+04, 8.5467581549E+00, 5.9751081948E+00, 8.5217096929E-01, 6.8594734069E-01, 6.5603322957E-01],
	[1.3175000000E+04, 8.5510370578E+00, 5.9747311462E+00, 8.5320480574E-01, 6.8663965942E-01, 6.5619449719E-01],
	[1.3180000000E+04, 8.5553164781E+00, 5.9743542644E+00, 8.5423950290E-01, 6.8733228558E-01, 6.5635571915E-01],
	[1.3185000000E+04, 8.5595964158E+00, 5.9739775492E+00, 8.5527506116E-01, 6.8802521895E-01, 6.5651689543E-01],
	[1.3190000000E+04, 8.5638768706E+00, 5.9736010007E+00, 8.5631148091E-01, 6.8871845928E-01, 6.5667802601E-01],
	[1.3195000000E+04, 8.5681578425E+00, 5.9732246186E+00, 8.5734876255E-01, 6.8941200635E-01, 6.5683911086E-01],
	[1.3200000000E+04, 8.5724393312E+00, 5.9728484028E+00, 8.5838690646E-01, 6.9010585993E-01, 6.5700014997E-01],
	[1.3205000000E+04, 8.5767213367E+00, 5.9724723532E+00, 8.5942591302E-01, 6.9080001977E-01, 6.5716114330E-01],
	[1.3210000000E+04, 8.5810038589E+00, 5.9720964696E+00, 8.6046578264E-01, 6.9149448566E-01, 6.5732209085E-01],
	[1.3215000000E+04, 8.5852868975E+00, 5.9717207518E+00, 8.6150651569E-01, 6.9218925734E-01, 6.5748299258E-01],
	[1.3220000000E+04, 8.5895704525E+00, 5.9713451999E+00, 8.6254811257E-01, 6.9288433459E-01, 6.5764384848E-01],
	[1.3225000000E+04, 8.5938545238E+00, 5.9709698135E+00, 8.6359057367E-01, 6.9357971717E-01, 6.5780465851E-01],
	[1.3230000000E+04, 8.5981391111E+00, 5.9705945926E+00, 8.6463389937E-01, 6.9427540485E-01, 6.5796542267E-01],
	[1.3235000000E+04, 8.6024242144E+00, 5.9702195371E+00, 8.6567809006E-01, 6.9497139738E-01, 6.5812614092E-01],
	[1.3240000000E+04, 8.6067098336E+00, 5.9698446468E+00, 8.6672314614E-01, 6.9566769455E-01, 6.5828681324E-01],
	[1.3245000000E+04, 8.6109959684E+00, 5.9694699215E+00, 8.6776906799E-01, 6.9636429611E-01, 6.5844743962E-01],
	[1.3250000000E+04, 8.6152991611E+00, 5.9691014937E+00, 8.6881585601E-01, 6.9706139374E-01, 6.5860802003E-01],
	[1.3255000000E+04, 8.6196030566E+00, 5.9687332931E+00, 8.6986351058E-01, 6.9775879795E-01, 6.5876855446E-01],
	[1.3260000000E+04, 8.6239074777E+00, 5.9683652541E+00, 8.7091203208E-01, 6.9845650644E-01, 6.5892904286E-01],
	[1.3265000000E+04, 8.6282124243E+00, 5.9679973766E+00, 8.7196142092E-01, 6.9915451898E-01, 6.5908948524E-01],
	[1.3270000000E+04, 8.6325178964E+00, 5.9676296603E+00, 8.7301167748E-01, 6.9985283534E-01, 6.5924988155E-01],
	[1.3275000000E+04, 8.6368238937E+00, 5.9672621053E+00, 8.7406280215E-01, 7.0055145528E-01, 6.5941023180E-01],
	[1.3280000000E+04, 8.6411304161E+00, 5.9668947112E+00, 8.7511479532E-01, 7.0125037856E-01, 6.5957053594E-01],
	[1.3285000000E+04, 8.6454374635E+00, 5.9665274781E+00, 8.7616765737E-01, 7.0194960495E-01, 6.5973079396E-01],
	[1.3290000000E+04, 8.6497450358E+00, 5.9661604057E+00, 8.7722138871E-01, 7.0264913421E-01, 6.5989100584E-01],
	[1.3295000000E+04, 8.6540531328E+00, 5.9657934940E+00, 8.7827598971E-01, 7.0334896609E-01, 6.6005117156E-01],
	[1.3300000000E+04, 8.6583617544E+00, 5.9654267428E+00, 8.7933146077E-01, 7.0404910037E-01, 6.6021129109E-01],
	[1.3305000000E+04, 8.6626709005E+00, 5.9650601520E+00, 8.8038780227E-01, 7.0474953681E-01, 6.6037136442E-01],
	[1.3310000000E+04, 8.6669805709E+00, 5.9646937215E+00, 8.8144501462E-01, 7.0545027516E-01, 6.6053139152E-01],
	[1.3315000000E+04, 8.6712907655E+00, 5.9643274510E+00, 8.8250309819E-01, 7.0615131519E-01, 6.6069137238E-01],
	[1.3320000000E+04, 8.6756014841E+00, 5.9639613406E+00, 8.8356205337E-01, 7.0685265667E-01, 6.6085130697E-01],
	[1.3325000000E+04, 8.6799127267E+00, 5.9635953900E+00, 8.8462188057E-01, 7.0755429934E-01, 6.6101119527E-01],
	[1.3330000000E+04, 8.6842244930E+00, 5.9632295992E+00, 8.8568258015E-01, 7.0825624298E-01, 6.6117103725E-01],
	[1.3335000000E+04, 8.6885367831E+00, 5.9628639679E+00, 8.8674415253E-01, 7.0895848734E-01, 6.6133083291E-01],
	[1.3340000000E+04, 8.6928495966E+00, 5.9624984961E+00, 8.8780659807E-01, 7.0966103218E-01, 6.6149058222E-01],
	[1.3345000000E+04, 8.6971629336E+00, 5.9621331837E+00, 8.8886991719E-01, 7.1036387727E-01, 6.6165028516E-01],
	[1.3350000000E+04, 8.7014767938E+00, 5.9617680305E+00, 8.8993411026E-01, 7.1106702236E-01, 6.6180994170E-01],
	[1.3355000000E+04, 8.7057911771E+00, 5.9614030364E+00, 8.9099917767E-01, 7.1177046722E-01, 6.6196955183E-01],
	[1.3360000000E+04, 8.7101060835E+00, 5.9610382012E+00, 8.9206511982E-01, 7.1247421160E-01, 6.6212911552E-01],
	[1.3365000000E+04, 8.7144215127E+00, 5.9606735249E+00, 8.9313193710E-01, 7.1317825526E-01, 6.6228863277E-01],
	[1.3370000000E+04, 8.7187374646E+00, 5.9603090073E+00, 8.9419962988E-01, 7.1388259796E-01, 6.6244810354E-01],
	[1.3375000000E+04, 8.7230539392E+00, 5.9599446482E+00, 8.9526819858E-01, 7.1458723947E-01, 6.6260752781E-01],
	[1.3380000000E+04, 8.7273709362E+00, 5.9595804476E+00, 8.9633764357E-01, 7.1529217953E-01, 6.6276690557E-01],
	[1.3385000000E+04, 8.7316884555E+00, 5.9592164053E+00, 8.9740796524E-01, 7.1599741791E-01, 6.6292623680E-01],
	[1.3390000000E+04, 8.7360064971E+00, 5.9588525212E+00, 8.9847916399E-01, 7.1670295436E-01, 6.6308552147E-01],
	[1.3395000000E+04, 8.7403250607E+00, 5.9584887952E+00, 8.9955124021E-01, 7.1740878864E-01, 6.6324475956E-01],
	[1.3400000000E+04, 8.7446441463E+00, 5.9581252271E+00, 9.0062419428E-01, 7.1811492052E-01, 6.6340395106E-01],
	[1.3405000000E+04, 8.7489637537E+00, 5.9577618168E+00, 9.0169802659E-01, 7.1882134974E-01, 6.6356309595E-01],
	[1.3410000000E+04, 8.7532838827E+00, 5.9573985641E+00, 9.0277273755E-01, 7.1952807607E-01, 6.6372219421E-01],
	[1.3415000000E+04, 8.7576045334E+00, 5.9570354691E+00, 9.0384832752E-01, 7.2023509926E-01, 6.6388124581E-01],
	[1.3420000000E+04, 8.7619257054E+00, 5.9566725314E+00, 9.0492479692E-01, 7.2094241907E-01, 6.6404025073E-01],
	[1.3425000000E+04, 8.7662473987E+00, 5.9563097511E+00, 9.0600214612E-01, 7.2165003525E-01, 6.6419920897E-01],
	[1.3430000000E+04, 8.7705696131E+00, 5.9559471279E+00, 9.0708037552E-01, 7.2235794756E-01, 6.6435812049E-01],
	[1.3435000000E+04, 8.7748923486E+00, 5.9555846617E+00, 9.0815948551E-01, 7.2306615576E-01, 6.6451698528E-01],
	[1.3440000000E+04, 8.7792156050E+00, 5.9552223525E+00, 9.0923947647E-01, 7.2377465959E-01, 6.6467580331E-01],
	[1.3445000000E+04, 8.7835393821E+00, 5.9548602001E+00, 9.1032034880E-01, 7.2448345883E-01, 6.6483457458E-01],
	[1.3450000000E+04, 8.7878636799E+00, 5.9544982043E+00, 9.1140210289E-01, 7.2519255322E-01, 6.6499329906E-01],
	[1.3455000000E+04, 8.7921884981E+00, 5.9541363651E+00, 9.1248473914E-01, 7.2590194251E-01, 6.6515197672E-01],
	[1.3460000000E+04, 8.7965198244E+00, 5.9537768009E+00, 9.1356825792E-01, 7.2661169888E-01, 6.6531060756E-01],
	[1.3465000000E+04, 8.8008630990E+00, 5.9534214321E+00, 9.1465265963E-01, 7.2732188821E-01, 6.6546919155E-01],
	[1.3470000000E+04, 8.8052069044E+00, 5.9530662163E+00, 9.1573794466E-01, 7.2803237235E-01, 6.6562772868E-01],
	[1.3475000000E+04, 8.8095512404E+00, 5.9527111536E+00, 9.1682411340E-01, 7.2874315105E-01, 6.6578621889E-01],
	[1.3480000000E+04, 8.8138961070E+00, 5.9523562438E+00, 9.1791116624E-01, 7.2945422407E-01, 6.6594466218E-01],
	[1.3485000000E+04, 8.8182415040E+00, 5.9520014868E+00, 9.1899910358E-01, 7.3016559117E-01, 6.6610305850E-01],
	[1.3490000000E+04, 8.8225874312E+00, 5.9516468824E+00, 9.2008792580E-01, 7.3087725210E-01, 6.6626140785E-01],
	[1.3495000000E+04, 8.8269338886E+00, 5.9512924305E+00, 9.2117763330E-01, 7.3158920660E-01, 6.6641971019E-01],
	[1.3500000000E+04, 8.8312808760E+00, 5.9509381310E+00, 9.2226822645E-01, 7.3230145445E-01, 6.6657796551E-01],
	[1.3505000000E+04, 8.8356283932E+00, 5.9505839838E+00, 9.2335970567E-01, 7.3301399538E-01, 6.6673617378E-01],
	[1.3510000000E+04, 8.8399764402E+00, 5.9502299888E+00, 9.2445207133E-01, 7.3372682915E-01, 6.6689433497E-01],
	[1.3515000000E+04, 8.8443250168E+00, 5.9498761458E+00, 9.2554532382E-01, 7.3443995552E-01, 6.6705244907E-01],
	[1.3520000000E+04, 8.8486741229E+00, 5.9495224547E+00, 9.2663946355E-01, 7.3515337424E-01, 6.6721051605E-01],
	[1.3525000000E+04, 8.8530237583E+00, 5.9491689154E+00, 9.2773449089E-01, 7.3586708506E-01, 6.6736853588E-01],
	[1.3530000000E+04, 8.8573739229E+00, 5.9488155277E+00, 9.2883040624E-01, 7.3658108773E-01, 6.6752650855E-01],
	[1.3535000000E+04, 8.8617246166E+00, 5.9484622916E+00, 9.2992721000E-01, 7.3729538201E-01, 6.6768443402E-01],
	[1.3540000000E+04, 8.8660758392E+00, 5.9481092070E+00, 9.3102490254E-01, 7.3800996765E-01, 6.6784231229E-01],
	[1.3545000000E+04, 8.8704275906E+00, 5.9477562736E+00, 9.3212348427E-01, 7.3872484439E-01, 6.6800014332E-01],
	[1.3550000000E+04, 8.8747798708E+00, 5.9474034915E+00, 9.3322295557E-01, 7.3944001199E-01, 6.6815792709E-01],
	[1.3555000000E+04, 8.8791326795E+00, 5.9470508604E+00, 9.3432331683E-01, 7.4015547021E-01, 6.6831566358E-01],
	[1.3560000000E+04, 8.8834860166E+00, 5.9466983803E+00, 9.3542456845E-01, 7.4087121879E-01, 6.6847335276E-01],
	[1.3565000000E+04, 8.8878398820E+00, 5.9463460509E+00, 9.3652671081E-01, 7.4158725748E-01, 6.6863099462E-01],
	[1.3570000000E+04, 8.8921942756E+00, 5.9459938723E+00, 9.3762974432E-01, 7.4230358603E-01, 6.6878858914E-01],
	[1.3575000000E+04, 8.8965491972E+00, 5.9456418443E+00, 9.3873366935E-01, 7.4302020420E-01, 6.6894613628E-01],
	[1.3580000000E+04, 8.9009046467E+00, 5.9452899667E+00, 9.3983848630E-01, 7.4373711173E-01, 6.6910363602E-01],
	[1.3585000000E+04, 8.9052606240E+00, 5.9449382395E+00, 9.4094419556E-01, 7.4445430838E-01, 6.6926108836E-01],
	[1.3590000000E+04, 8.9096171290E+00, 5.9445866625E+00, 9.4205079752E-01, 7.4517179389E-01, 6.6941849325E-01],
	[1.3595000000E+04, 8.9139741614E+00, 5.9442352357E+00, 9.4315829258E-01, 7.4588956801E-01, 6.6957585068E-01],
	[1.3600000000E+04, 8.9183317212E+00, 5.9438839588E+00, 9.4426668112E-01, 7.4660763049E-01, 6.6973316063E-01],
	[1.3605000000E+04, 8.9226898083E+00, 5.9435328318E+00, 9.4537596353E-01, 7.4732598109E-01, 6.6989042308E-01],
	[1.3610000000E+04, 8.9270484225E+00, 5.9431818545E+00, 9.4648614022E-01, 7.4804461954E-01, 6.7004763800E-01],
	[1.3615000000E+04, 8.9314075637E+00, 5.9428310269E+00, 9.4759721156E-01, 7.4876354560E-01, 6.7020480537E-01],
	[1.3620000000E+04, 8.9357672317E+00, 5.9424803487E+00, 9.4870917795E-01, 7.4948275902E-01, 6.7036192517E-01],
	[1.3625000000E+04, 8.9401274265E+00, 5.9421298200E+00, 9.4982203978E-01, 7.5020225954E-01, 6.7051899738E-01],
	[1.3630000000E+04, 8.9444881479E+00, 5.9417794406E+00, 9.5093579744E-01, 7.5092204691E-01, 6.7067602198E-01],
	[1.3635000000E+04, 8.9488493957E+00, 5.9414292103E+00, 9.5205045133E-01, 7.5164212088E-01, 6.7083299894E-01],
	[1.3640000000E+04, 8.9532111699E+00, 5.9410791290E+00, 9.5316600184E-01, 7.5236248120E-01, 6.7098992824E-01],
	[1.3645000000E+04, 8.9575734703E+00, 5.9407291967E+00, 9.5428244935E-01, 7.5308312762E-01, 6.7114680987E-01],
	[1.3650000000E+04, 8.9619362968E+00, 5.9403794131E+00, 9.5539979426E-01, 7.5380405987E-01, 6.7130364380E-01],
	[1.3655000000E+04, 8.9662996493E+00, 5.9400297783E+00, 9.5651803695E-01, 7.5452527771E-01, 6.7146043000E-01],
	[1.3660000000E+04, 8.9706635275E+00, 5.9396802920E+00, 9.5763717784E-01, 7.5524678089E-01, 6.7161716847E-01],
	[1.3665000000E+04, 8.9750279315E+00, 5.9393309542E+00, 9.5875721729E-01, 7.5596856914E-01, 6.7177385917E-01],
	[1.3670000000E+04, 8.9793928611E+00, 5.9389817647E+00, 9.5987815571E-01, 7.5669064223E-01, 6.7193050209E-01],
	[1.3675000000E+04, 8.9837585324E+00, 5.9386327966E+00, 9.6099999348E-01, 7.5741300261E-01, 6.7208709720E-01],
	[1.3680000000E+04, 8.9881426259E+00, 5.9382900224E+00, 9.6212273100E-01, 7.5813587319E-01, 6.7224364448E-01],
	[1.3685000000E+04, 8.9925272556E+00, 5.9379473932E+00, 9.6324636866E-01, 7.5885902851E-01, 6.7240014392E-01],
	[1.3690000000E+04, 8.9969124213E+00, 5.9376049090E+00, 9.6437090686E-01, 7.5958246831E-01, 6.7255659549E-01],
	[1.3695000000E+04, 9.0012981230E+00, 5.9372625695E+00, 9.6549810954E-01, 7.6030728597E-01, 6.7271299917E-01],
	[1.3700000000E+04, 9.0056843604E+00, 5.9369203748E+00, 9.6662909731E-01, 7.6103417418E-01, 6.7286935493E-01],
	[1.3705000000E+04, 9.0100711336E+00, 5.9365783246E+00, 9.6776099606E-01, 7.6176134938E-01, 6.7302566277E-01],
	[1.3710000000E+04, 9.0144584423E+00, 5.9362364189E+00, 9.6889380619E-01, 7.6248881132E-01, 6.7318192266E-01],
	[1.3715000000E+04, 9.0188462864E+00, 5.9358946576E+00, 9.7002752809E-01, 7.6321655973E-01, 6.7333813458E-01],
	[1.3720000000E+04, 9.0232346657E+00, 5.9355530405E+00, 9.7116216217E-01, 7.6394459436E-01, 6.7349429850E-01],
	[1.3725000000E+04, 9.0276235803E+00, 5.9352115675E+00, 9.7229770882E-01, 7.6467291494E-01, 6.7365041442E-01],
	[1.3730000000E+04, 9.0320130298E+00, 5.9348702385E+00, 9.7343416846E-01, 7.6540152123E-01, 6.7380648230E-01],
	[1.3735000000E+04, 9.0364030143E+00, 5.9345290534E+00, 9.7457154147E-01, 7.6613041296E-01, 6.7396250212E-01],
	[1.3740000000E+04, 9.0407935335E+00, 5.9341880121E+00, 9.7570982825E-01, 7.6685958988E-01, 6.7411847388E-01],
	[1.3745000000E+04, 9.0451845874E+00, 5.9338471144E+00, 9.7684902922E-01, 7.6758905173E-01, 6.7427439754E-01],
	[1.3750000000E+04, 9.0495761757E+00, 5.9335063604E+00, 9.7798914477E-01, 7.6831879824E-01, 6.7443027309E-01],
	[1.3755000000E+04, 9.0539682984E+00, 5.9331657497E+00, 9.7913017530E-01, 7.6904882916E-01, 6.7458610050E-01],
	[1.3760000000E+04, 9.0583609554E+00, 5.9328252824E+00, 9.8027212121E-01, 7.6977914423E-01, 6.7474187976E-01],
	[1.3765000000E+04, 9.0627541465E+00, 5.9324849584E+00, 9.8141498290E-01, 7.7050974319E-01, 6.7489761085E-01],
	[1.3770000000E+04, 9.0671478716E+00, 5.9321447774E+00, 9.8255876077E-01, 7.7124062578E-01, 6.7505329375E-01],
	[1.3775000000E+04, 9.0715421305E+00, 5.9318047394E+00, 9.8370345523E-01, 7.7197179174E-01, 6.7520892843E-01],
	[1.3780000000E+04, 9.0759369232E+00, 5.9314648443E+00, 9.8484906668E-01, 7.7270324081E-01, 6.7536451488E-01],
	[1.3785000000E+04, 9.0803322495E+00, 5.9311250920E+00, 9.8599559551E-01, 7.7343497273E-01, 6.7552005308E-01],
	[1.3790000000E+04, 9.0847281092E+00, 5.9307854824E+00, 9.8714304212E-01, 7.7416698724E-01, 6.7567554301E-01],
	[1.3795000000E+04, 9.0891245023E+00, 5.9304460153E+00, 9.8829140693E-01, 7.7489928407E-01, 6.7583098465E-01],
	[1.3800000000E+04, 9.0935214286E+00, 5.9301066906E+00, 9.8944069032E-01, 7.7563186297E-01, 6.7598637798E-01],
	[1.3805000000E+04, 9.0979188880E+00, 5.9297675082E+00, 9.9059089270E-01, 7.7636472368E-01, 6.7614172298E-01],
	[1.3810000000E+04, 9.1023168804E+00, 5.9294284681E+00, 9.9174201447E-01, 7.7709786594E-01, 6.7629701963E-01],
	[1.3815000000E+04, 9.1067154056E+00, 5.9290895701E+00, 9.9289405604E-01, 7.7783128947E-01, 6.7645226792E-01],
	[1.3820000000E+04, 9.1111144634E+00, 5.9287508141E+00, 9.9404701779E-01, 7.7856499403E-01, 6.7660746782E-01],
	[1.3825000000E+04, 9.1155140539E+00, 5.9284121999E+00, 9.9520090014E-01, 7.7929897934E-01, 6.7676261931E-01],
	[1.3830000000E+04, 9.1199141768E+00, 5.9280737275E+00, 9.9635570349E-01, 7.8003324515E-01, 6.7691772238E-01],
	[1.3835000000E+04, 9.1243148320E+00, 5.9277353968E+00, 9.9751142823E-01, 7.8076779120E-01, 6.7707277700E-01],
	[1.3840000000E+04, 9.1287160194E+00, 5.9273972076E+00, 9.9866807477E-01, 7.8150261721E-01, 6.7722778317E-01],
	[1.3845000000E+04, 9.1331177389E+00, 5.9270591599E+00, 9.9982564351E-01, 7.8223772294E-01, 6.7738274085E-01],
	[1.3850000000E+04, 9.1375199903E+00, 5.9267212535E+00, 1.0009841348E+00, 7.8297310811E-01, 6.7753765003E-01],
	[1.3855000000E+04, 9.1419227735E+00, 5.9263834883E+00, 1.0021435492E+00, 7.8370877246E-01, 6.7769251069E-01],
	[1.3860000000E+04, 9.1463260884E+00, 5.9260458643E+00, 1.0033038869E+00, 7.8444471572E-01, 6.7784732282E-01],
	[1.3865000000E+04, 9.1507299348E+00, 5.9257083812E+00, 1.0044651485E+00, 7.8518093765E-01, 6.7800208639E-01],
	[1.3870000000E+04, 9.1551343127E+00, 5.9253710390E+00, 1.0056273342E+00, 7.8591743796E-01, 6.7815680139E-01],
	[1.3875000000E+04, 9.1595392218E+00, 5.9250338376E+00, 1.0067904446E+00, 7.8665421640E-01, 6.7831146780E-01],
	[1.3880000000E+04, 9.1639446621E+00, 5.9246967769E+00, 1.0079544799E+00, 7.8739127270E-01, 6.7846608559E-01],
	[1.3885000000E+04, 9.1683506335E+00, 5.9243598568E+00, 1.0091194407E+00, 7.8812860659E-01, 6.7862065476E-01],
	[1.3890000000E+04, 9.1727571358E+00, 5.9240230770E+00, 1.0102853273E+00, 7.8886621782E-01, 6.7877517528E-01],
	[1.3895000000E+04, 9.1771641688E+00, 5.9236864377E+00, 1.0114521401E+00, 7.8960410612E-01, 6.7892964714E-01],
	[1.3900000000E+04, 9.1815902231E+00, 5.9233559103E+00, 1.0126198795E+00, 7.9034251454E-01, 6.7908407031E-01],
	[1.3905000000E+04, 9.1860171511E+00, 5.9230256275E+00, 1.0137885459E+00, 7.9108120457E-01, 6.7923844478E-01],
	[1.3910000000E+04, 9.1904446209E+00, 5.9226954818E+00, 1.0149581398E+00, 7.9182017159E-01, 6.7939277054E-01],
	[1.3915000000E+04, 9.1948726322E+00, 5.9223654731E+00, 1.0161286615E+00, 7.9255941534E-01, 6.7954704756E-01],
	[1.3920000000E+04, 9.1993011851E+00, 5.9220356014E+00, 1.0173001113E+00, 7.9329893554E-01, 6.7970127582E-01],
	[1.3925000000E+04, 9.2037302793E+00, 5.9217058665E+00, 1.0184724899E+00, 7.9403873193E-01, 6.7985545531E-01],
	[1.3930000000E+04, 9.2081599147E+00, 5.9213762683E+00, 1.0196457974E+00, 7.9477880424E-01, 6.8000958601E-01],
	[1.3935000000E+04, 9.2125900913E+00, 5.9210468068E+00, 1.0208200344E+00, 7.9551915222E-01, 6.8016366791E-01],
	[1.3940000000E+04, 9.2170208088E+00, 5.9207174817E+00, 1.0219952011E+00, 7.9625977559E-01, 6.8031770098E-01],
	[1.3945000000E+04, 9.2214520671E+00, 5.9203882931E+00, 1.0231712982E+00, 7.9700067409E-01, 6.8047168520E-01],
	[1.3950000000E+04, 9.2258838662E+00, 5.9200592408E+00, 1.0243483258E+00, 7.9774184744E-01, 6.8062562057E-01],
	[1.3955000000E+04, 9.2303162058E+00, 5.9197303247E+00, 1.0255262845E+00, 7.9848329540E-01, 6.8077950706E-01],
	[1.3960000000E+04, 9.2347490860E+00, 5.9194015446E+00, 1.0267051746E+00, 7.9922501768E-01, 6.8093334466E-01],
	[1.3965000000E+04, 9.2391825064E+00, 5.9190729006E+00, 1.0278849966E+00, 7.9996701402E-01, 6.8108713335E-01],
	[1.3970000000E+04, 9.2436164671E+00, 5.9187443924E+00, 1.0290657508E+00, 8.0070928416E-01, 6.8124087311E-01],
	[1.3975000000E+04, 9.2480509678E+00, 5.9184160200E+00, 1.0302474376E+00, 8.0145182782E-01, 6.8139456392E-01],
	[1.3980000000E+04, 9.2524860085E+00, 5.9180877833E+00, 1.0314300575E+00, 8.0219464474E-01, 6.8154820577E-01],
	[1.3985000000E+04, 9.2569215890E+00, 5.9177596822E+00, 1.0326136108E+00, 8.0293773465E-01, 6.8170179864E-01],
	[1.3990000000E+04, 9.2613577092E+00, 5.9174317165E+00, 1.0337980980E+00, 8.0368109729E-01, 6.8185534252E-01],
	[1.3995000000E+04, 9.2657943690E+00, 5.9171038862E+00, 1.0349835194E+00, 8.0442473238E-01, 6.8200883738E-01],
	[1.4000000000E+04, 9.2702315682E+00, 5.9167761911E+00, 1.0361698755E+00, 8.0516863966E-01, 6.8216228321E-01],
	[1.4005000000E+04, 9.2746693067E+00, 5.9164486312E+00, 1.0373571666E+00, 8.0591281886E-01, 6.8231568000E-01],
	[1.4010000000E+04, 9.2791075844E+00, 5.9161212063E+00, 1.0385453932E+00, 8.0665726970E-01, 6.8246902772E-01],
	[1.4015000000E+04, 9.2835464012E+00, 5.9157939164E+00, 1.0397345556E+00, 8.0740199193E-01, 6.8262232637E-01],
	[1.4020000000E+04, 9.2879857569E+00, 5.9154667613E+00, 1.0409246543E+00, 8.0814698526E-01, 6.8277557592E-01],
	[1.4025000000E+04, 9.2924256514E+00, 5.9151397409E+00, 1.0421156897E+00, 8.0889224944E-01, 6.8292877635E-01],
	[1.4030000000E+04, 9.2968660846E+00, 5.9148128552E+00, 1.0433076621E+00, 8.0963778419E-01, 6.8308192766E-01],
	[1.4035000000E+04, 9.3013070564E+00, 5.9144861040E+00, 1.0445005720E+00, 8.1038358925E-01, 6.8323502983E-01],
	[1.4040000000E+04, 9.3057485666E+00, 5.9141594873E+00, 1.0456944198E+00, 8.1112966434E-01, 6.8338808283E-01],
	[1.4045000000E+04, 9.3101906151E+00, 5.9138330048E+00, 1.0468892058E+00, 8.1187600919E-01, 6.8354108665E-01],
	[1.4050000000E+04, 9.3146332017E+00, 5.9135066566E+00, 1.0480849306E+00, 8.1262262353E-01, 6.8369404129E-01],
	[1.4055000000E+04, 9.3190763264E+00, 5.9131804425E+00, 1.0492815944E+00, 8.1336950709E-01, 6.8384694671E-01],
	[1.4060000000E+04, 9.3235199890E+00, 5.9128543624E+00, 1.0504791976E+00, 8.1411665961E-01, 6.8399980291E-01],
	[1.4065000000E+04, 9.3279641895E+00, 5.9125284163E+00, 1.0516777408E+00, 8.1486408080E-01, 6.8415260986E-01],
	[1.4070000000E+04, 9.3324089276E+00, 5.9122026039E+00, 1.0528772242E+00, 8.1561177040E-01, 6.8430536756E-01],
	[1.4075000000E+04, 9.3368542032E+00, 5.9118769252E+00, 1.0540776484E+00, 8.1635972815E-01, 6.8445807599E-01],
	[1.4080000000E+04, 9.3413000162E+00, 5.9115513802E+00, 1.0552790136E+00, 8.1710795376E-01, 6.8461073513E-01],
	[1.4085000000E+04, 9.3457463666E+00, 5.9112259686E+00, 1.0564813203E+00, 8.1785644696E-01, 6.8476334496E-01],
	[1.4090000000E+04, 9.3501932541E+00, 5.9109006905E+00, 1.0576845689E+00, 8.1860520748E-01, 6.8491590547E-01],
	[1.4095000000E+04, 9.3546406786E+00, 5.9105755456E+00, 1.0588887598E+00, 8.1935423506E-01, 6.8506841665E-01],
	[1.4100000000E+04, 9.3590886401E+00, 5.9102505340E+00, 1.0600938934E+00, 8.2010352942E-01, 6.8522087848E-01],
	[1.4105000000E+04, 9.3635371383E+00, 5.9099256554E+00, 1.0612999701E+00, 8.2085309028E-01, 6.8537329094E-01],
	[1.4110000000E+04, 9.3679861732E+00, 5.9096009098E+00, 1.0625069903E+00, 8.2160291737E-01, 6.8552565403E-01],
	[1.4115000000E+04, 9.3724357447E+00, 5.9092762971E+00, 1.0637149544E+00, 8.2235301043E-01, 6.8567796771E-01],
	[1.4120000000E+04, 9.3768906188E+00, 5.9089532907E+00, 1.0649238629E+00, 8.2310343449E-01, 6.8583023198E-01],
	[1.4125000000E+04, 9.3813608068E+00, 5.9086349815E+00, 1.0661337160E+00, 8.2385432684E-01, 6.8598244683E-01],
	[1.4130000000E+04, 9.3858315427E+00, 5.9083168020E+00, 1.0673445143E+00, 8.2460548509E-01, 6.8613461223E-01],
	[1.4135000000E+04, 9.3903028262E+00, 5.9079987522E+00, 1.0685562581E+00, 8.2535690896E-01, 6.8628672818E-01],
	[1.4140000000E+04, 9.3947746573E+00, 5.9076808320E+00, 1.0697689478E+00, 8.2610859818E-01, 6.8643879466E-01],
	[1.4145000000E+04, 9.3992470359E+00, 5.9073630413E+00, 1.0709825838E+00, 8.2686055247E-01, 6.8659081165E-01],
	[1.4150000000E+04, 9.4037199618E+00, 5.9070453800E+00, 1.0721971666E+00, 8.2761277156E-01, 6.8674277913E-01],
	[1.4155000000E+04, 9.4081934348E+00, 5.9067278481E+00, 1.0734126965E+00, 8.2836525519E-01, 6.8689469710E-01],
	[1.4160000000E+04, 9.4126674550E+00, 5.9064104453E+00, 1.0746291740E+00, 8.2911800307E-01, 6.8704656554E-01],
	[1.4165000000E+04, 9.4171420221E+00, 5.9060931716E+00, 1.0758465993E+00, 8.2987101493E-01, 6.8719838443E-01],
	[1.4170000000E+04, 9.4216171360E+00, 5.9057760269E+00, 1.0770649731E+00, 8.3062429049E-01, 6.8735015377E-01],
	[1.4175000000E+04, 9.4260927966E+00, 5.9054590112E+00, 1.0782842955E+00, 8.3137782949E-01, 6.8750187353E-01],
	[1.4180000000E+04, 9.4305690037E+00, 5.9051421242E+00, 1.0795045671E+00, 8.3213163165E-01, 6.8765354370E-01],
	[1.4185000000E+04, 9.4350457573E+00, 5.9048253660E+00, 1.0807257883E+00, 8.3288569670E-01, 6.8780516426E-01],
	[1.4190000000E+04, 9.4395230572E+00, 5.9045087363E+00, 1.0819479594E+00, 8.3364002435E-01, 6.8795673521E-01],
	[1.4195000000E+04, 9.4440009033E+00, 5.9041922352E+00, 1.0831710809E+00, 8.3439461434E-01, 6.8810825652E-01],
	[1.4200000000E+04, 9.4484792954E+00, 5.9038758625E+00, 1.0843951531E+00, 8.3514946639E-01, 6.8825972819E-01],
	[1.4205000000E+04, 9.4529582335E+00, 5.9035596182E+00, 1.0856201765E+00, 8.3590458022E-01, 6.8841115020E-01],
	[1.4210000000E+04, 9.4574377174E+00, 5.9032435020E+00, 1.0868461515E+00, 8.3665995556E-01, 6.8856252253E-01],
	[1.4215000000E+04, 9.4619177470E+00, 5.9029275140E+00, 1.0880730784E+00, 8.3741559214E-01, 6.8871384518E-01],
	[1.4220000000E+04, 9.4663983221E+00, 5.9026116541E+00, 1.0893009578E+00, 8.3817148968E-01, 6.8886511812E-01],
	[1.4225000000E+04, 9.4708794426E+00, 5.9022959220E+00, 1.0905297898E+00, 8.3892764790E-01, 6.8901634134E-01],
	[1.4230000000E+04, 9.4753611085E+00, 5.9019803178E+00, 1.0917595751E+00, 8.3968406652E-01, 6.8916751484E-01],
	[1.4235000000E+04, 9.4798433195E+00, 5.9016648413E+00, 1.0929903140E+00, 8.4044074527E-01, 6.8931863859E-01],
	[1.4240000000E+04, 9.4843260756E+00, 5.9013494925E+00, 1.0942220068E+00, 8.4119768388E-01, 6.8946971258E-01],
	[1.4245000000E+04, 9.4888093767E+00, 5.9010342713E+00, 1.0954546541E+00, 8.4195488207E-01, 6.8962073680E-01],
	[1.4250000000E+04, 9.4932932225E+00, 5.9007191774E+00, 1.0966882561E+00, 8.4271233955E-01, 6.8977171123E-01],
	[1.4255000000E+04, 9.4977776130E+00, 5.9004042110E+00, 1.0979228133E+00, 8.4347005606E-01, 6.8992263587E-01],
	[1.4260000000E+04, 9.5022625481E+00, 5.9000893718E+00, 1.0991583262E+00, 8.4422803131E-01, 6.9007351069E-01],
	[1.4265000000E+04, 9.5067480276E+00, 5.8997746597E+00, 1.1003947950E+00, 8.4498626504E-01, 6.9022433569E-01],
	[1.4270000000E+04, 9.5112340514E+00, 5.8994600748E+00, 1.1016322203E+00, 8.4574475695E-01, 6.9037511085E-01],
	[1.4275000000E+04, 9.5157206193E+00, 5.8991456168E+00, 1.1028706024E+00, 8.4650350678E-01, 6.9052583616E-01],
	[1.4280000000E+04, 9.5202077314E+00, 5.8988312856E+00, 1.1041099417E+00, 8.4726251424E-01, 6.9067651160E-01],
	[1.4285000000E+04, 9.5246953873E+00, 5.8985170813E+00, 1.1053502386E+00, 8.4802177906E-01, 6.9082713716E-01],
	[1.4290000000E+04, 9.5291835871E+00, 5.8982030036E+00, 1.1065914935E+00, 8.4878130096E-01, 6.9097771283E-01],
	[1.4295000000E+04, 9.5336723306E+00, 5.8978890526E+00, 1.1078337069E+00, 8.4954107966E-01, 6.9112823857E-01],
	[1.4300000000E+04, 9.5381616176E+00, 5.8975752280E+00, 1.1090768791E+00, 8.5030111488E-01, 6.9127871438E-01],
	[1.4305000000E+04, 9.5426514480E+00, 5.8972615298E+00, 1.1103210105E+00, 8.5106140635E-01, 6.9142914024E-01],
	[1.4310000000E+04, 9.5471418218E+00, 5.8969479579E+00, 1.1115661016E+00, 8.5182195378E-01, 6.9157951613E-01],
	[1.4315000000E+04, 9.5516327388E+00, 5.8966345123E+00, 1.1128121527E+00, 8.5258275689E-01, 6.9172984203E-01],
	[1.4320000000E+04, 9.5561241988E+00, 5.8963211927E+00, 1.1140591643E+00, 8.5334381542E-01, 6.9188011793E-01],
	[1.4325000000E+04, 9.5606162017E+00, 5.8960079992E+00, 1.1153071367E+00, 8.5410512907E-01, 6.9203034382E-01],
	[1.4330000000E+04, 9.5651087475E+00, 5.8956949316E+00, 1.1165560704E+00, 8.5486669757E-01, 6.9218051967E-01],
	[1.4335000000E+04, 9.5696018359E+00, 5.8953819898E+00, 1.1178059657E+00, 8.5562852063E-01, 6.9233064547E-01],
	[1.4340000000E+04, 9.5740954669E+00, 5.8950691738E+00, 1.1190568231E+00, 8.5639059799E-01, 6.9248072120E-01],
	[1.4345000000E+04, 9.5785896404E+00, 5.8947564834E+00, 1.1203086430E+00, 8.5715292935E-01, 6.9263074685E-01],
	[1.4350000000E+04, 9.5831002729E+00, 5.8944486292E+00, 1.1215614258E+00, 8.5791574179E-01, 6.9278072240E-01],
	[1.4355000000E+04, 9.5876158089E+00, 5.8941421857E+00, 1.1228151718E+00, 8.5867887053E-01, 6.9293064784E-01],
	[1.4360000000E+04, 9.5921318989E+00, 5.8938358648E+00, 1.1240698815E+00, 8.5944225323E-01, 6.9308052315E-01],
	[1.4365000000E+04, 9.5966485430E+00, 5.8935296665E+00, 1.1253255553E+00, 8.6020588960E-01, 6.9323034831E-01],
	[1.4370000000E+04, 9.6011657408E+00, 5.8932235906E+00, 1.1265821936E+00, 8.6096977937E-01, 6.9338012331E-01],
	[1.4375000000E+04, 9.6056834923E+00, 5.8929176370E+00, 1.1278397968E+00, 8.6173392226E-01, 6.9352984814E-01],
	[1.4380000000E+04, 9.6102017974E+00, 5.8926118058E+00, 1.1290983652E+00, 8.6249831799E-01, 6.9367952277E-01],
	[1.4385000000E+04, 9.6147206559E+00, 5.8923060967E+00, 1.1303578994E+00, 8.6326296627E-01, 6.9382914719E-01],
	[1.4390000000E+04, 9.6192400677E+00, 5.8920005098E+00, 1.1316183997E+00, 8.6402786682E-01, 6.9397872139E-01],
	[1.4395000000E+04, 9.6237600327E+00, 5.8916950448E+00, 1.1328798665E+00, 8.6479301938E-01, 6.9412824535E-01],
	[1.4400000000E+04, 9.6282805508E+00, 5.8913897017E+00, 1.1341423002E+00, 8.6555842364E-01, 6.9427771906E-01],
	[1.4405000000E+04, 9.6328016218E+00, 5.8910844805E+00, 1.1354057013E+00, 8.6632407934E-01, 6.9442714249E-01],
	[1.4410000000E+04, 9.6373232457E+00, 5.8907793810E+00, 1.1366700700E+00, 8.6708998619E-01, 6.9457651564E-01],
	[1.4415000000E+04, 9.6418454222E+00, 5.8904744031E+00, 1.1379354069E+00, 8.6785614391E-01, 6.9472583849E-01],
	[1.4420000000E+04, 9.6463681513E+00, 5.8901695468E+00, 1.1392017124E+00, 8.6862255221E-01, 6.9487511103E-01],
	[1.4425000000E+04, 9.6508914328E+00, 5.8898648119E+00, 1.1404689867E+00, 8.6938921083E-01, 6.9502433323E-01],
	[1.4430000000E+04, 9.6554152667E+00, 5.8895601984E+00, 1.1417372304E+00, 8.7015611947E-01, 6.9517350509E-01],
	[1.4435000000E+04, 9.6599396528E+00, 5.8892557062E+00, 1.1430064439E+00, 8.7092327785E-01, 6.9532262659E-01],
	[1.4440000000E+04, 9.6644645909E+00, 5.8889513352E+00, 1.1442766275E+00, 8.7169068569E-01, 6.9547169772E-01],
	[1.4445000000E+04, 9.6689900810E+00, 5.8886470852E+00, 1.1455477817E+00, 8.7245834270E-01, 6.9562071846E-01],
	[1.4450000000E+04, 9.6735161229E+00, 5.8883429563E+00, 1.1468199068E+00, 8.7322624862E-01, 6.9576968879E-01],
	[1.4455000000E+04, 9.6780427165E+00, 5.8880389483E+00, 1.1480930033E+00, 8.7399440314E-01, 6.9591860870E-01],
	[1.4460000000E+04, 9.6825698617E+00, 5.8877350611E+00, 1.1493670716E+00, 8.7476280599E-01, 6.9606747818E-01],
	[1.4465000000E+04, 9.6870975584E+00, 5.8874312946E+00, 1.1506421121E+00, 8.7553145689E-01, 6.9621629722E-01],
	[1.4470000000E+04, 9.6916258063E+00, 5.8871276488E+00, 1.1519181251E+00, 8.7630035556E-01, 6.9636506579E-01],
	[1.4475000000E+04, 9.6961546055E+00, 5.8868241236E+00, 1.1531951111E+00, 8.7706950170E-01, 6.9651378388E-01],
	[1.4480000000E+04, 9.7006839558E+00, 5.8865207188E+00, 1.1544730705E+00, 8.7783889504E-01, 6.9666245148E-01],
	[1.4485000000E+04, 9.7052138570E+00, 5.8862174344E+00, 1.1557520037E+00, 8.7860853529E-01, 6.9681106858E-01],
	[1.4490000000E+04, 9.7097443091E+00, 5.8859142703E+00, 1.1570319111E+00, 8.7937842216E-01, 6.9695963516E-01],
	[1.4495000000E+04, 9.7142753119E+00, 5.8856112264E+00, 1.1583127931E+00, 8.8014855539E-01, 6.9710815121E-01],
	[1.4500000000E+04, 9.7188068652E+00, 5.8853083025E+00, 1.1595946502E+00, 8.8091893467E-01, 6.9725661671E-01],
	[1.4505000000E+04, 9.7233389691E+00, 5.8850054988E+00, 1.1608774826E+00, 8.8168955973E-01, 6.9740503165E-01],
	[1.4510000000E+04, 9.7278716232E+00, 5.8847028149E+00, 1.1621612909E+00, 8.8246043028E-01, 6.9755339601E-01],
	[1.4515000000E+04, 9.7324048277E+00, 5.8844002509E+00, 1.1634460753E+00, 8.8323154603E-01, 6.9770170978E-01],
	[1.4520000000E+04, 9.7369385822E+00, 5.8840978066E+00, 1.1647318365E+00, 8.8400290671E-01, 6.9784997296E-01],
	[1.4525000000E+04, 9.7414728866E+00, 5.8837954820E+00, 1.1660185746E+00, 8.8477451202E-01, 6.9799818551E-01],
	[1.4530000000E+04, 9.7460077410E+00, 5.8834932770E+00, 1.1673062902E+00, 8.8554636169E-01, 6.9814634744E-01],
	[1.4535000000E+04, 9.7505431451E+00, 5.8831911915E+00, 1.1685949837E+00, 8.8631845542E-01, 6.9829445872E-01],
	[1.4540000000E+04, 9.7550790987E+00, 5.8828892254E+00, 1.1698846553E+00, 8.8709079293E-01, 6.9844251934E-01],
	[1.4545000000E+04, 9.7596156019E+00, 5.8825873786E+00, 1.1711753057E+00, 8.8786337394E-01, 6.9859052930E-01],
	[1.4550000000E+04, 9.7641526544E+00, 5.8822856510E+00, 1.1724669351E+00, 8.8863619816E-01, 6.9873848857E-01],
	[1.4555000000E+04, 9.7686902562E+00, 5.8819840426E+00, 1.1737595440E+00, 8.8940926530E-01, 6.9888639714E-01],
	[1.4560000000E+04, 9.7732284071E+00, 5.8816825532E+00, 1.1750531328E+00, 8.9018257508E-01, 6.9903425500E-01],
	[1.4565000000E+04, 9.7777671070E+00, 5.8813811827E+00, 1.1763477018E+00, 8.9095612721E-01, 6.9918206214E-01],
	[1.4570000000E+04, 9.7823063558E+00, 5.8810799312E+00, 1.1776432515E+00, 8.9172992140E-01, 6.9932981855E-01],
	[1.4575000000E+04, 9.7868461533E+00, 5.8807787984E+00, 1.1789397823E+00, 8.9250395737E-01, 6.9947752420E-01],
	[1.4580000000E+04, 9.7913989940E+00, 5.8804813284E+00, 1.1802372946E+00, 8.9327842062E-01, 6.9962517909E-01],
	[1.4585000000E+04, 9.7959609017E+00, 5.8801863885E+00, 1.1815357888E+00, 8.9405325223E-01, 6.9977278320E-01],
	[1.4590000000E+04, 9.8005233701E+00, 5.8798915644E+00, 1.1828352653E+00, 8.9482832560E-01, 6.9992033653E-01],
	[1.4595000000E+04, 9.8050863991E+00, 5.8795968562E+00, 1.1841357245E+00, 8.9560364042E-01, 7.0006783905E-01],
	[1.4600000000E+04, 9.8096499885E+00, 5.8793022636E+00, 1.1854371669E+00, 8.9637919642E-01, 7.0021529076E-01],
	[1.4605000000E+04, 9.8142141383E+00, 5.8790077867E+00, 1.1867395927E+00, 8.9715499331E-01, 7.0036269164E-01],
	[1.4610000000E+04, 9.8187788483E+00, 5.8787134253E+00, 1.1880430025E+00, 8.9793103079E-01, 7.0051004168E-01],
	[1.4615000000E+04, 9.8233441184E+00, 5.8784191793E+00, 1.1893473966E+00, 8.9870730860E-01, 7.0065734088E-01],
	[1.4620000000E+04, 9.8279099484E+00, 5.8781250488E+00, 1.1906527755E+00, 8.9948382643E-01, 7.0080458920E-01],
	[1.4625000000E+04, 9.8324763384E+00, 5.8778310335E+00, 1.1919591395E+00, 9.0026058400E-01, 7.0095178665E-01],
	[1.4630000000E+04, 9.8370432880E+00, 5.8775371334E+00, 1.1932664891E+00, 9.0103758102E-01, 7.0109893321E-01],
	[1.4635000000E+04, 9.8416107972E+00, 5.8772433484E+00, 1.1945748246E+00, 9.0181481721E-01, 7.0124602887E-01],
	[1.4640000000E+04, 9.8461788659E+00, 5.8769496784E+00, 1.1958841465E+00, 9.0259229228E-01, 7.0139307361E-01],
	[1.4645000000E+04, 9.8507474940E+00, 5.8766561234E+00, 1.1971944551E+00, 9.0337000594E-01, 7.0154006743E-01],
	[1.4650000000E+04, 9.8553166813E+00, 5.8763626833E+00, 1.1985057509E+00, 9.0414795791E-01, 7.0168701031E-01],
	[1.4655000000E+04, 9.8598864277E+00, 5.8760693580E+00, 1.1998180343E+00, 9.0492614789E-01, 7.0183390223E-01],
	[1.4660000000E+04, 9.8644567331E+00, 5.8757761473E+00, 1.2011313057E+00, 9.0570457559E-01, 7.0198074320E-01],
	[1.4665000000E+04, 9.8690275974E+00, 5.8754830512E+00, 1.2024455655E+00, 9.0648324074E-01, 7.0212753319E-01],
	[1.4670000000E+04, 9.8735990204E+00, 5.8751900697E+00, 1.2037608140E+00, 9.0726214304E-01, 7.0227427220E-01],
	[1.4675000000E+04, 9.8781710020E+00, 5.8748972026E+00, 1.2050770518E+00, 9.0804128220E-01, 7.0242096020E-01],
	[1.4680000000E+04, 9.8827435422E+00, 5.8746044499E+00, 1.2063942792E+00, 9.0882065793E-01, 7.0256759720E-01],
	[1.4685000000E+04, 9.8873166407E+00, 5.8743118114E+00, 1.2077124966E+00, 9.0960026995E-01, 7.0271418317E-01],
	[1.4690000000E+04, 9.8918902974E+00, 5.8740192872E+00, 1.2090317044E+00, 9.1038011796E-01, 7.0286071812E-01],
	[1.4695000000E+04, 9.8964645123E+00, 5.8737268770E+00, 1.2103519031E+00, 9.1116020168E-01, 7.0300720201E-01],
	[1.4700000000E+04, 9.9010392853E+00, 5.8734345809E+00, 1.2116730930E+00, 9.1194052082E-01, 7.0315363485E-01],
	[1.4705000000E+04, 9.9056146161E+00, 5.8731423987E+00, 1.2129952745E+00, 9.1272107509E-01, 7.0330001663E-01],
	[1.4710000000E+04, 9.9101905046E+00, 5.8728503304E+00, 1.2143184480E+00, 9.1350186420E-01, 7.0344634732E-01],
	[1.4715000000E+04, 9.9147669509E+00, 5.8725583758E+00, 1.2156426141E+00, 9.1428288786E-01, 7.0359262692E-01],
	[1.4720000000E+04, 9.9193439546E+00, 5.8722665350E+00, 1.2169677730E+00, 9.1506414577E-01, 7.0373885542E-01],
	[1.4725000000E+04, 9.9239215158E+00, 5.8719748077E+00, 1.2182939251E+00, 9.1584563766E-01, 7.0388503281E-01],
	[1.4730000000E+04, 9.9284996342E+00, 5.8716831940E+00, 1.2196210709E+00, 9.1662736323E-01, 7.0403115908E-01],
	[1.4735000000E+04, 9.9330783098E+00, 5.8713916937E+00, 1.2209492108E+00, 9.1740932219E-01, 7.0417723420E-01],
	[1.4740000000E+04, 9.9376575424E+00, 5.8711003068E+00, 1.2222783452E+00, 9.1819151424E-01, 7.0432325819E-01],
	[1.4745000000E+04, 9.9422373320E+00, 5.8708090332E+00, 1.2236084745E+00, 9.1897393911E-01, 7.0446923101E-01],
	[1.4750000000E+04, 9.9468176783E+00, 5.8705178727E+00, 1.2249395990E+00, 9.1975659650E-01, 7.0461515267E-01],
	[1.4755000000E+04, 9.9513985814E+00, 5.8702268254E+00, 1.2262717193E+00, 9.2053948611E-01, 7.0476102315E-01],
	[1.4760000000E+04, 9.9559800409E+00, 5.8699358911E+00, 1.2276048357E+00, 9.2132260766E-01, 7.0490684243E-01],
	[1.4765000000E+04, 9.9605620570E+00, 5.8696450698E+00, 1.2289389485E+00, 9.2210596086E-01, 7.0505261052E-01],
	[1.4770000000E+04, 9.9651446293E+00, 5.8693543613E+00, 1.2302740584E+00, 9.2288954541E-01, 7.0519832739E-01],
	[1.4775000000E+04, 9.9697277578E+00, 5.8690637656E+00, 1.2316101655E+00, 9.2367336103E-01, 7.0534399305E-01],
	[1.4780000000E+04, 9.9743114424E+00, 5.8687732826E+00, 1.2329472704E+00, 9.2445740742E-01, 7.0548960747E-01],
	[1.4785000000E+04, 9.9788956830E+00, 5.8684829123E+00, 1.2342853734E+00, 9.2524168429E-01, 7.0563517065E-01],
	[1.4790000000E+04, 9.9834804793E+00, 5.8681926544E+00, 1.2356244750E+00, 9.2602619135E-01, 7.0578068257E-01],
	[1.4795000000E+04, 9.9880658314E+00, 5.8679025091E+00, 1.2369645755E+00, 9.2681092830E-01, 7.0592614323E-01],
	[1.4800000000E+04, 9.9926517391E+00, 5.8676124761E+00, 1.2383056754E+00, 9.2759589487E-01, 7.0607155262E-01],
	[1.4805000000E+04, 9.9972382023E+00, 5.8673225554E+00, 1.2396477750E+00, 9.2838109075E-01, 7.0621691072E-01],
	[1.4810000000E+04, 1.0001825221E+01, 5.8670327469E+00, 1.2409908749E+00, 9.2916651565E-01, 7.0636221753E-01],
	[1.4815000000E+04, 1.0006427168E+01, 5.8667469603E+00, 1.2423349753E+00, 9.2995239166E-01, 7.0650747303E-01],
	[1.4820000000E+04, 1.0011037057E+01, 5.8664632903E+00, 1.2436800767E+00, 9.3073861096E-01, 7.0665267722E-01],
	[1.4825000000E+04, 1.0015647514E+01, 5.8661797297E+00, 1.2450261795E+00, 9.3152505927E-01, 7.0679783008E-01],
	[1.4830000000E+04, 1.0020258539E+01, 5.8658962784E+00, 1.2463732841E+00, 9.3231173631E-01, 7.0694293161E-01],
	[1.4835000000E+04, 1.0024870131E+01, 5.8656129364E+00, 1.2477213909E+00, 9.3309864177E-01, 7.0708798179E-01],
	[1.4840000000E+04, 1.0029482290E+01, 5.8653297035E+00, 1.2490705003E+00, 9.3388577537E-01, 7.0723298062E-01],
	[1.4845000000E+04, 1.0034095017E+01, 5.8650465797E+00, 1.2504206128E+00, 9.3467313681E-01, 7.0737792809E-01],
	[1.4850000000E+04, 1.0038708310E+01, 5.8647635649E+00, 1.2517717286E+00, 9.3546072580E-01, 7.0752282418E-01],
	[1.4855000000E+04, 1.0043322170E+01, 5.8644806590E+00, 1.2531238484E+00, 9.3624854206E-01, 7.0766766888E-01],
	[1.4860000000E+04, 1.0047936598E+01, 5.8641978620E+00, 1.2544769723E+00, 9.3703658528E-01, 7.0781246220E-01],
	[1.4865000000E+04, 1.0052551591E+01, 5.8639151737E+00, 1.2558311009E+00, 9.3782485517E-01, 7.0795720411E-01],
	[1.4870000000E+04, 1.0057167152E+01, 5.8636325942E+00, 1.2571862346E+00, 9.3861335145E-01, 7.0810189460E-01],
	[1.4875000000E+04, 1.0061783278E+01, 5.8633501232E+00, 1.2585423737E+00, 9.3940207382E-01, 7.0824653368E-01],
	[1.4880000000E+04, 1.0066399972E+01, 5.8630677608E+00, 1.2598995187E+00, 9.4019102198E-01, 7.0839112132E-01],
	[1.4885000000E+04, 1.0071017231E+01, 5.8627855068E+00, 1.2612576700E+00, 9.4098019565E-01, 7.0853565753E-01],
	[1.4890000000E+04, 1.0075635056E+01, 5.8625033612E+00, 1.2626168280E+00, 9.4176959453E-01, 7.0868014228E-01],
	[1.4895000000E+04, 1.0080253447E+01, 5.8622213239E+00, 1.2639769930E+00, 9.4255921832E-01, 7.0882457558E-01],
	[1.4900000000E+04, 1.0084872405E+01, 5.8619393948E+00, 1.2653381656E+00, 9.4334906674E-01, 7.0896895741E-01],
	[1.4905000000E+04, 1.0089491927E+01, 5.8616575739E+00, 1.2667003461E+00, 9.4413913948E-01, 7.0911328776E-01],
	[1.4910000000E+04, 1.0094112016E+01, 5.8613758610E+00, 1.2680635349E+00, 9.4492943626E-01, 7.0925756662E-01],
	[1.4915000000E+04, 1.0098732670E+01, 5.8610942561E+00, 1.2694277324E+00, 9.4571995679E-01, 7.0940179399E-01],
	[1.4920000000E+04, 1.0103353889E+01, 5.8608127592E+00, 1.2707929390E+00, 9.4651070076E-01, 7.0954596985E-01],
	[1.4925000000E+04, 1.0107975673E+01, 5.8605313700E+00, 1.2721591552E+00, 9.4730166788E-01, 7.0969009420E-01],
	[1.4930000000E+04, 1.0112598023E+01, 5.8602500887E+00, 1.2735263813E+00, 9.4809285787E-01, 7.0983416703E-01],
	[1.4935000000E+04, 1.0117220937E+01, 5.8599689150E+00, 1.2748946178E+00, 9.4888427042E-01, 7.0997818833E-01],
	[1.4940000000E+04, 1.0121844416E+01, 5.8596878488E+00, 1.2762638651E+00, 9.4967590524E-01, 7.1012215809E-01],
	[1.4945000000E+04, 1.0126468461E+01, 5.8594068903E+00, 1.2776341235E+00, 9.5046776204E-01, 7.1026607630E-01],
	[1.4950000000E+04, 1.0131093069E+01, 5.8591260391E+00, 1.2790053934E+00, 9.5125984052E-01, 7.1040994296E-01],
	[1.4955000000E+04, 1.0135718242E+01, 5.8588452954E+00, 1.2803776754E+00, 9.5205214038E-01, 7.1055375805E-01],
	[1.4960000000E+04, 1.0140343980E+01, 5.8585646589E+00, 1.2817509698E+00, 9.5284466134E-01, 7.1069752157E-01],
	[1.4965000000E+04, 1.0144970282E+01, 5.8582841296E+00, 1.2831252769E+00, 9.5363740310E-01, 7.1084123350E-01],
	[1.4970000000E+04, 1.0149597148E+01, 5.8580037075E+00, 1.2845005973E+00, 9.5443036535E-01, 7.1098489385E-01],
	[1.4975000000E+04, 1.0154224578E+01, 5.8577233925E+00, 1.2858769312E+00, 9.5522354782E-01, 7.1112850259E-01],
	[1.4980000000E+04, 1.0158852572E+01, 5.8574431844E+00, 1.2872542792E+00, 9.5601695019E-01, 7.1127205973E-01],
	[1.4985000000E+04, 1.0163481129E+01, 5.8571630832E+00, 1.2886326416E+00, 9.5681057219E-01, 7.1141556526E-01],
	[1.4990000000E+04, 1.0168110251E+01, 5.8568830889E+00, 1.2900120189E+00, 9.5760441350E-01, 7.1155901916E-01],
	[1.4995000000E+04, 1.0172739935E+01, 5.8566032013E+00, 1.2913924114E+00, 9.5839847384E-01, 7.1170242143E-01],
	[1.5000000000E+04, 1.0177370184E+01, 5.8563234204E+00, 1.2927738195E+00, 9.5919275290E-01, 7.1184577206E-01],
	[1.5005000000E+04, 1.0182000995E+01, 5.8560437461E+00, 1.2941602550E+00, 9.5998945762E-01, 7.1198907105E-01],
	[1.5010000000E+04, 1.0186632370E+01, 5.8557641784E+00, 1.2955477143E+00, 9.6078638235E-01, 7.1213231837E-01],
	[1.5015000000E+04, 1.0191264308E+01, 5.8554847171E+00, 1.2969361978E+00, 9.6158352679E-01, 7.1227551404E-01],
	[1.5020000000E+04, 1.0195896809E+01, 5.8552053621E+00, 1.2983257058E+00, 9.6238089064E-01, 7.1241865804E-01],
	[1.5025000000E+04, 1.0200529872E+01, 5.8549261135E+00, 1.2997162388E+00, 9.6317847361E-01, 7.1256175036E-01],
	[1.5030000000E+04, 1.0205163498E+01, 5.8546469711E+00, 1.3011077972E+00, 9.6397627538E-01, 7.1270479099E-01],
	[1.5035000000E+04, 1.0209797687E+01, 5.8543679348E+00, 1.3025003814E+00, 9.6477429568E-01, 7.1284777993E-01],
	[1.5040000000E+04, 1.0214432439E+01, 5.8540890046E+00, 1.3038939918E+00, 9.6557253419E-01, 7.1299071716E-01],
	[1.5045000000E+04, 1.0219067752E+01, 5.8538101805E+00, 1.3052886289E+00, 9.6637099062E-01, 7.1313360269E-01],
	[1.5050000000E+04, 1.0223703628E+01, 5.8535314622E+00, 1.3066842930E+00, 9.6716966466E-01, 7.1327643651E-01],
	[1.5055000000E+04, 1.0228361859E+01, 5.8532585523E+00, 1.3080809846E+00, 9.6796890715E-01, 7.1341921860E-01],
	[1.5060000000E+04, 1.0233021310E+01, 5.8529859148E+00, 1.3094787041E+00, 9.6876837797E-01, 7.1356194895E-01],
	[1.5065000000E+04, 1.0237681337E+01, 5.8527133805E+00, 1.3108774519E+00, 9.6956806641E-01, 7.1370462757E-01],
	[1.5070000000E+04, 1.0242341937E+01, 5.8524409493E+00, 1.3122772283E+00, 9.7036797218E-01, 7.1384725443E-01],
	[1.5075000000E+04, 1.0247003113E+01, 5.8521686211E+00, 1.3136780340E+00, 9.7116809498E-01, 7.1398982952E-01],
	[1.5080000000E+04, 1.0251664863E+01, 5.8518963959E+00, 1.3150798691E+00, 9.7196843452E-01, 7.1413235284E-01],
	[1.5085000000E+04, 1.0256327187E+01, 5.8516242737E+00, 1.3164827342E+00, 9.7276899048E-01, 7.1427482437E-01],
	[1.5090000000E+04, 1.0260990086E+01, 5.8513522542E+00, 1.3178866297E+00, 9.7356976258E-01, 7.1441724411E-01],
	[1.5095000000E+04, 1.0265653558E+01, 5.8510803375E+00, 1.3192915560E+00, 9.7437075051E-01, 7.1455961204E-01],
	[1.5100000000E+04, 1.0270317605E+01, 5.8508085235E+00, 1.3206975135E+00, 9.7517195398E-01, 7.1470192815E-01],
	[1.5105000000E+04, 1.0274982225E+01, 5.8505368121E+00, 1.3221045026E+00, 9.7597337268E-01, 7.1484419245E-01],
	[1.5110000000E+04, 1.0279647419E+01, 5.8502652033E+00, 1.3235125237E+00, 9.7677500632E-01, 7.1498640490E-01],
	[1.5115000000E+04, 1.0284313187E+01, 5.8499936969E+00, 1.3249215772E+00, 9.7757685459E-01, 7.1512856552E-01],
	[1.5120000000E+04, 1.0288979528E+01, 5.8497222929E+00, 1.3263316636E+00, 9.7837891720E-01, 7.1527067428E-01],
	[1.5125000000E+04, 1.0293646443E+01, 5.8494509912E+00, 1.3277427833E+00, 9.7918119385E-01, 7.1541273118E-01],
	[1.5130000000E+04, 1.0298313931E+01, 5.8491797918E+00, 1.3291549367E+00, 9.7998368423E-01, 7.1555473620E-01],
	[1.5135000000E+04, 1.0302981992E+01, 5.8489086945E+00, 1.3305681242E+00, 9.8078638805E-01, 7.1569668934E-01],
	[1.5140000000E+04, 1.0307650626E+01, 5.8486376994E+00, 1.3319823462E+00, 9.8158930500E-01, 7.1583859059E-01],
	[1.5145000000E+04, 1.0312319833E+01, 5.8483668063E+00, 1.3333976031E+00, 9.8239243479E-01, 7.1598043994E-01],
	[1.5150000000E+04, 1.0316989613E+01, 5.8480960151E+00, 1.3348138954E+00, 9.8319577711E-01, 7.1612223739E-01],
	[1.5155000000E+04, 1.0321659965E+01, 5.8478253259E+00, 1.3362312234E+00, 9.8399933167E-01, 7.1626398291E-01],
	[1.5160000000E+04, 1.0326330890E+01, 5.8475547384E+00, 1.3376495876E+00, 9.8480309817E-01, 7.1640567650E-01],
	[1.5165000000E+04, 1.0331002388E+01, 5.8472842527E+00, 1.3390689884E+00, 9.8560707629E-01, 7.1654731816E-01],
	[1.5170000000E+04, 1.0335674457E+01, 5.8470138686E+00, 1.3404894262E+00, 9.8641126575E-01, 7.1668890787E-01],
	[1.5175000000E+04, 1.0340347099E+01, 5.8467435862E+00, 1.3419109014E+00, 9.8721566624E-01, 7.1683044563E-01],
	[1.5180000000E+04, 1.0345020313E+01, 5.8464734053E+00, 1.3433334144E+00, 9.8802027746E-01, 7.1697193142E-01],
	[1.5185000000E+04, 1.0349694099E+01, 5.8462033258E+00, 1.3447569657E+00, 9.8882509911E-01, 7.1711336524E-01],
	[1.5190000000E+04, 1.0354368457E+01, 5.8459333478E+00, 1.3461815557E+00, 9.8963013089E-01, 7.1725474708E-01],
	[1.5195000000E+04, 1.0359043386E+01, 5.8456634710E+00, 1.3476071847E+00, 9.9043537250E-01, 7.1739607693E-01],
	[1.5200000000E+04, 1.0363718887E+01, 5.8453936955E+00, 1.3490338533E+00, 9.9124082363E-01, 7.1753735478E-01],
	[1.5205000000E+04, 1.0368394960E+01, 5.8451240212E+00, 1.3504615617E+00, 9.9204648399E-01, 7.1767858062E-01],
	[1.5210000000E+04, 1.0373071604E+01, 5.8448544479E+00, 1.3518903105E+00, 9.9285235326E-01, 7.1781975445E-01],
	[1.5215000000E+04, 1.0377748819E+01, 5.8445849757E+00, 1.3533201000E+00, 9.9365843116E-01, 7.1796087625E-01],
	[1.5220000000E+04, 1.0382426605E+01, 5.8443156044E+00, 1.3547509307E+00, 9.9446471738E-01, 7.1810194602E-01],
	[1.5225000000E+04, 1.0387104963E+01, 5.8440463341E+00, 1.3561828029E+00, 9.9527121161E-01, 7.1824296375E-01],
	[1.5230000000E+04, 1.0391783891E+01, 5.8437771645E+00, 1.3576157172E+00, 9.9607791356E-01, 7.1838392943E-01],
	[1.5235000000E+04, 1.0396463390E+01, 5.8435080957E+00, 1.3590496738E+00, 9.9688482292E-01, 7.1852484305E-01],
	[1.5240000000E+04, 1.0401143459E+01, 5.8432391276E+00, 1.3604846732E+00, 9.9769193939E-01, 7.1866570461E-01],
	[1.5245000000E+04, 1.0405824100E+01, 5.8429702601E+00, 1.3619207159E+00, 9.9849926267E-01, 7.1880651410E-01],
	[1.5250000000E+04, 1.0410505310E+01, 5.8427014931E+00, 1.3633578022E+00, 9.9930679246E-01, 7.1894727150E-01],
	[1.5255000000E+04, 1.0415187091E+01, 5.8424328265E+00, 1.3647959326E+00, 1.0001145285E+00, 7.1908797682E-01],
	[1.5260000000E+04, 1.0419869442E+01, 5.8421642604E+00, 1.3662351075E+00, 1.0009224703E+00, 7.1922863003E-01],
	[1.5265000000E+04, 1.0424552363E+01, 5.8418957946E+00, 1.3676753273E+00, 1.0017306178E+00, 7.1936923115E-01],
	[1.5270000000E+04, 1.0429235854E+01, 5.8416274290E+00, 1.3691165923E+00, 1.0025389706E+00, 7.1950978014E-01],
	[1.5275000000E+04, 1.0433919915E+01, 5.8413591636E+00, 1.3705589031E+00, 1.0033475284E+00, 7.1965027702E-01],
	[1.5280000000E+04, 1.0438604546E+01, 5.8410909983E+00, 1.3720022600E+00, 1.0041562909E+00, 7.1979072177E-01],
	[1.5285000000E+04, 1.0443289746E+01, 5.8408229331E+00, 1.3734466635E+00, 1.0049652577E+00, 7.1993111439E-01],
	[1.5290000000E+04, 1.0447975516E+01, 5.8405549678E+00, 1.3748921140E+00, 1.0057744286E+00, 7.2007145486E-01],
	[1.5295000000E+04, 1.0452673662E+01, 5.8402900936E+00, 1.3763386118E+00, 1.0065840017E+00, 7.2021174318E-01],
	[1.5300000000E+04, 1.0457383559E+01, 5.8400281472E+00, 1.3777861575E+00, 1.0073939666E+00, 7.2035197934E-01],
	[1.5305000000E+04, 1.0462094037E+01, 5.8397662982E+00, 1.3792347513E+00, 1.0082041356E+00, 7.2049216333E-01],
	[1.5310000000E+04, 1.0466805098E+01, 5.8395045465E+00, 1.3806843938E+00, 1.0090145085E+00, 7.2063229516E-01],
	[1.5315000000E+04, 1.0471516741E+01, 5.8392428920E+00, 1.3821350854E+00, 1.0098250848E+00, 7.2077237480E-01],
	[1.5320000000E+04, 1.0476228966E+01, 5.8389813346E+00, 1.3835868264E+00, 1.0106358644E+00, 7.2091240225E-01],
	[1.5325000000E+04, 1.0480941772E+01, 5.8387198742E+00, 1.3850396173E+00, 1.0114468468E+00, 7.2105237751E-01],
	[1.5330000000E+04, 1.0485655160E+01, 5.8384585109E+00, 1.3864934585E+00, 1.0122580319E+00, 7.2119230057E-01],
	[1.5335000000E+04, 1.0490369130E+01, 5.8381972444E+00, 1.3879483504E+00, 1.0130694192E+00, 7.2133217142E-01],
	[1.5340000000E+04, 1.0495083682E+01, 5.8379360749E+00, 1.3894042934E+00, 1.0138810086E+00, 7.2147199005E-01],
	[1.5345000000E+04, 1.0499798814E+01, 5.8376750021E+00, 1.3908612880E+00, 1.0146927996E+00, 7.2161175646E-01],
	[1.5350000000E+04, 1.0504514528E+01, 5.8374140260E+00, 1.3923193345E+00, 1.0155047920E+00, 7.2175147064E-01],
	[1.5355000000E+04, 1.0509230823E+01, 5.8371531466E+00, 1.3937784334E+00, 1.0163169855E+00, 7.2189113258E-01],
	[1.5360000000E+04, 1.0513947699E+01, 5.8368923638E+00, 1.3952385851E+00, 1.0171293798E+00, 7.2203074229E-01],
	[1.5365000000E+04, 1.0518665155E+01, 5.8366316775E+00, 1.3966997900E+00, 1.0179419746E+00, 7.2217029974E-01],
	[1.5370000000E+04, 1.0523383193E+01, 5.8363710877E+00, 1.3981620486E+00, 1.0187547695E+00, 7.2230980493E-01],
	[1.5375000000E+04, 1.0528101811E+01, 5.8361105942E+00, 1.3996253611E+00, 1.0195677643E+00, 7.2244925786E-01],
	[1.5380000000E+04, 1.0532821010E+01, 5.8358501971E+00, 1.4010897282E+00, 1.0203809587E+00, 7.2258865852E-01],
	[1.5385000000E+04, 1.0537540789E+01, 5.8355898962E+00, 1.4025551501E+00, 1.0211943523E+00, 7.2272800691E-01],
	[1.5390000000E+04, 1.0542261148E+01, 5.8353296916E+00, 1.4040216273E+00, 1.0220079449E+00, 7.2286730301E-01],
	[1.5395000000E+04, 1.0546982087E+01, 5.8350695830E+00, 1.4054891602E+00, 1.0228217362E+00, 7.2300654683E-01],
	[1.5400000000E+04, 1.0551703607E+01, 5.8348095705E+00, 1.4069577492E+00, 1.0236357258E+00, 7.2314573835E-01],
	[1.5405000000E+04, 1.0556425706E+01, 5.8345496539E+00, 1.4084273947E+00, 1.0244499134E+00, 7.2328487756E-01],
	[1.5410000000E+04, 1.0561148385E+01, 5.8342898333E+00, 1.4098980972E+00, 1.0252642988E+00, 7.2342396447E-01],
	[1.5415000000E+04, 1.0565871644E+01, 5.8340301086E+00, 1.4113698571E+00, 1.0260788816E+00, 7.2356299907E-01],
	[1.5420000000E+04, 1.0570595483E+01, 5.8337704796E+00, 1.4128426748E+00, 1.0268936616E+00, 7.2370198135E-01],
	[1.5425000000E+04, 1.0575319900E+01, 5.8335109464E+00, 1.4143165506E+00, 1.0277086384E+00, 7.2384091130E-01],
	[1.5430000000E+04, 1.0580044898E+01, 5.8332515088E+00, 1.4157914851E+00, 1.0285238117E+00, 7.2397978892E-01],
	[1.5435000000E+04, 1.0584770474E+01, 5.8329921668E+00, 1.4172674786E+00, 1.0293391812E+00, 7.2411861420E-01],
	[1.5440000000E+04, 1.0589496630E+01, 5.8327329203E+00, 1.4187445316E+00, 1.0301547467E+00, 7.2425738714E-01],
	[1.5445000000E+04, 1.0594223364E+01, 5.8324737693E+00, 1.4202226444E+00, 1.0309705077E+00, 7.2439610772E-01],
	[1.5450000000E+04, 1.0598950677E+01, 5.8322147136E+00, 1.4217018176E+00, 1.0317864641E+00, 7.2453477596E-01],
	[1.5455000000E+04, 1.0603678570E+01, 5.8319557533E+00, 1.4231820514E+00, 1.0326026154E+00, 7.2467339183E-01],
	[1.5460000000E+04, 1.0608407040E+01, 5.8316968883E+00, 1.4246633463E+00, 1.0334189615E+00, 7.2481195534E-01],
	[1.5465000000E+04, 1.0613136090E+01, 5.8314381184E+00, 1.4261457028E+00, 1.0342355019E+00, 7.2495046647E-01],
	[1.5470000000E+04, 1.0617865717E+01, 5.8311794437E+00, 1.4276291212E+00, 1.0350522364E+00, 7.2508892523E-01],
	[1.5475000000E+04, 1.0622595923E+01, 5.8309208640E+00, 1.4291136020E+00, 1.0358691647E+00, 7.2522733160E-01],
	[1.5480000000E+04, 1.0627326708E+01, 5.8306623793E+00, 1.4305991456E+00, 1.0366862865E+00, 7.2536568559E-01],
	[1.5485000000E+04, 1.0632058070E+01, 5.8304039896E+00, 1.4320857524E+00, 1.0375036014E+00, 7.2550398718E-01],
	[1.5490000000E+04, 1.0636790010E+01, 5.8301456947E+00, 1.4335734228E+00, 1.0383211092E+00, 7.2564223638E-01],
	[1.5495000000E+04, 1.0641522528E+01, 5.8298874946E+00, 1.4350621572E+00, 1.0391388096E+00, 7.2578043317E-01],
	[1.5500000000E+04, 1.0646255624E+01, 5.8296293892E+00, 1.4365519561E+00, 1.0399567022E+00, 7.2591857754E-01],
	[1.5505000000E+04, 1.0650989297E+01, 5.8293713785E+00, 1.4380428198E+00, 1.0407747867E+00, 7.2605666951E-01],
	[1.5510000000E+04, 1.0655723548E+01, 5.8291134625E+00, 1.4395347489E+00, 1.0415930629E+00, 7.2619470906E-01],
	[1.5515000000E+04, 1.0660458376E+01, 5.8288556409E+00, 1.4410277436E+00, 1.0424115304E+00, 7.2633269618E-01],
	[1.5520000000E+04, 1.0665193781E+01, 5.8285979138E+00, 1.4425218045E+00, 1.0432301890E+00, 7.2647063087E-01],
	[1.5525000000E+04, 1.0669929763E+01, 5.8283402812E+00, 1.4440169318E+00, 1.0440490382E+00, 7.2660851313E-01],
	[1.5530000000E+04, 1.0674666323E+01, 5.8280827428E+00, 1.4455131262E+00, 1.0448680779E+00, 7.2674634294E-01],
	[1.5535000000E+04, 1.0679403459E+01, 5.8278252988E+00, 1.4470103879E+00, 1.0456873077E+00, 7.2688412032E-01],
	[1.5540000000E+04, 1.0684147669E+01, 5.8275695435E+00, 1.4485087174E+00, 1.0465068410E+00, 7.2702184524E-01],
	[1.5545000000E+04, 1.0688909474E+01, 5.8273180559E+00, 1.4500081151E+00, 1.0473268623E+00, 7.2715951771E-01],
	[1.5550000000E+04, 1.0693671870E+01, 5.8270666600E+00, 1.4515085814E+00, 1.0481470738E+00, 7.2729713772E-01],
	[1.5555000000E+04, 1.0698434854E+01, 5.8268153557E+00, 1.4530101168E+00, 1.0489674751E+00, 7.2743470527E-01],
	[1.5560000000E+04, 1.0703198429E+01, 5.8265641430E+00, 1.4545127216E+00, 1.0497880660E+00, 7.2757222036E-01],
	[1.5565000000E+04, 1.0707962593E+01, 5.8263130219E+00, 1.4560163962E+00, 1.0506088461E+00, 7.2770968297E-01],
	[1.5570000000E+04, 1.0712727346E+01, 5.8260619922E+00, 1.4575211412E+00, 1.0514298151E+00, 7.2784709310E-01],
	[1.5575000000E+04, 1.0717492689E+01, 5.8258110540E+00, 1.4590269569E+00, 1.0522509728E+00, 7.2798445076E-01],
	[1.5580000000E+04, 1.0722258621E+01, 5.8255602071E+00, 1.4605338437E+00, 1.0530723188E+00, 7.2812175592E-01],
	[1.5585000000E+04, 1.0727025142E+01, 5.8253094515E+00, 1.4620418020E+00, 1.0538938529E+00, 7.2825900860E-01],
	[1.5590000000E+04, 1.0731792252E+01, 5.8250587871E+00, 1.4635508323E+00, 1.0547155746E+00, 7.2839620879E-01],
	[1.5595000000E+04, 1.0736559951E+01, 5.8248082139E+00, 1.4650609350E+00, 1.0555374838E+00, 7.2853335648E-01],
	[1.5600000000E+04, 1.0741328238E+01, 5.8245577317E+00, 1.4665721105E+00, 1.0563595800E+00, 7.2867045166E-01],
	[1.5605000000E+04, 1.0746097114E+01, 5.8243073406E+00, 1.4680843591E+00, 1.0571818631E+00, 7.2880749434E-01],
	[1.5610000000E+04, 1.0750866579E+01, 5.8240570405E+00, 1.4695976814E+00, 1.0580043326E+00, 7.2894448451E-01],
	[1.5615000000E+04, 1.0755636632E+01, 5.8238068313E+00, 1.4711120778E+00, 1.0588269884E+00, 7.2908142217E-01],
	[1.5620000000E+04, 1.0760407273E+01, 5.8235567129E+00, 1.4726275486E+00, 1.0596498300E+00, 7.2921830731E-01],
	[1.5625000000E+04, 1.0765178503E+01, 5.8233066854E+00, 1.4741440943E+00, 1.0604728572E+00, 7.2935513993E-01],
	[1.5630000000E+04, 1.0769950320E+01, 5.8230567485E+00, 1.4756617153E+00, 1.0612960696E+00, 7.2949192002E-01],
	[1.5635000000E+04, 1.0774722725E+01, 5.8228069023E+00, 1.4771804120E+00, 1.0621194670E+00, 7.2962864758E-01],
	[1.5640000000E+04, 1.0779495718E+01, 5.8225571468E+00, 1.4787001848E+00, 1.0629430491E+00, 7.2976532261E-01],
	[1.5645000000E+04, 1.0784269299E+01, 5.8223074817E+00, 1.4802210342E+00, 1.0637668155E+00, 7.2990194511E-01],
	[1.5650000000E+04, 1.0789043468E+01, 5.8220579071E+00, 1.4817429605E+00, 1.0645907659E+00, 7.3003851506E-01],
	[1.5655000000E+04, 1.0793818223E+01, 5.8218084230E+00, 1.4832659643E+00, 1.0654149001E+00, 7.3017503247E-01],
	[1.5660000000E+04, 1.0798593567E+01, 5.8215590292E+00, 1.4847900458E+00, 1.0662392177E+00, 7.3031149734E-01],
	[1.5665000000E+04, 1.0803369497E+01, 5.8213097257E+00, 1.4863152056E+00, 1.0670637184E+00, 7.3044790965E-01],
	[1.5670000000E+04, 1.0808146014E+01, 5.8210605124E+00, 1.4878414439E+00, 1.0678884019E+00, 7.3058426941E-01],
	[1.5675000000E+04, 1.0812923119E+01, 5.8208113893E+00, 1.4893687614E+00, 1.0687132680E+00, 7.3072057661E-01],
	[1.5680000000E+04, 1.0817700810E+01, 5.8205623564E+00, 1.4908971583E+00, 1.0695383162E+00, 7.3085683125E-01],
	[1.5685000000E+04, 1.0822479088E+01, 5.8203134134E+00, 1.4924266351E+00, 1.0703635463E+00, 7.3099303333E-01],
	[1.5690000000E+04, 1.0827257953E+01, 5.8200645605E+00, 1.4939571923E+00, 1.0711889580E+00, 7.3112918284E-01],
	[1.5695000000E+04, 1.0832037404E+01, 5.8198157974E+00, 1.4954888301E+00, 1.0720145509E+00, 7.3126527979E-01],
	[1.5700000000E+04, 1.0836817442E+01, 5.8195671243E+00, 1.4970215491E+00, 1.0728403249E+00, 7.3140132415E-01],
	[1.5705000000E+04, 1.0841598066E+01, 5.8193185409E+00, 1.4985553497E+00, 1.0736662795E+00, 7.3153731595E-01],
	[1.5710000000E+04, 1.0846379276E+01, 5.8190700473E+00, 1.5000902322E+00, 1.0744924144E+00, 7.3167325516E-01],
	[1.5715000000E+04, 1.0851161072E+01, 5.8188216434E+00, 1.5016261971E+00, 1.0753187294E+00, 7.3180914179E-01],
	[1.5720000000E+04, 1.0855943455E+01, 5.8185733290E+00, 1.5031632449E+00, 1.0761452241E+00, 7.3194497584E-01],
	[1.5725000000E+04, 1.0860726423E+01, 5.8183251043E+00, 1.5047013759E+00, 1.0769718982E+00, 7.3208075730E-01],
	[1.5730000000E+04, 1.0865509976E+01, 5.8180769690E+00, 1.5062405905E+00, 1.0777987515E+00, 7.3221648617E-01],
	[1.5735000000E+04, 1.0870294116E+01, 5.8178289232E+00, 1.5077808892E+00, 1.0786257836E+00, 7.3235216245E-01],
	[1.5740000000E+04, 1.0875078841E+01, 5.8175809668E+00, 1.5093222724E+00, 1.0794529941E+00, 7.3248778613E-01],
	[1.5745000000E+04, 1.0879864151E+01, 5.8173330996E+00, 1.5108647406E+00, 1.0802803829E+00, 7.3262335721E-01],
	[1.5750000000E+04, 1.0884650046E+01, 5.8170853218E+00, 1.5124082940E+00, 1.0811079496E+00, 7.3275887569E-01],
	[1.5755000000E+04, 1.0889436527E+01, 5.8168376331E+00, 1.5139529332E+00, 1.0819356938E+00, 7.3289434157E-01],
	[1.5760000000E+04, 1.0894223593E+01, 5.8165900335E+00, 1.5154986585E+00, 1.0827636153E+00, 7.3302975484E-01],
	[1.5765000000E+04, 1.0899011243E+01, 5.8163425231E+00, 1.5170454704E+00, 1.0835917138E+00, 7.3316511551E-01],
	[1.5770000000E+04, 1.0903799479E+01, 5.8160951016E+00, 1.5185933694E+00, 1.0844199889E+00, 7.3330042356E-01],
	[1.5775000000E+04, 1.0908588299E+01, 5.8158477691E+00, 1.5201423557E+00, 1.0852484404E+00, 7.3343567901E-01],
	[1.5780000000E+04, 1.0913377704E+01, 5.8156005255E+00, 1.5216924299E+00, 1.0860770679E+00, 7.3357088183E-01],
	[1.5785000000E+04, 1.0918167693E+01, 5.8153533708E+00, 1.5232435923E+00, 1.0869058712E+00, 7.3370603204E-01],
	[1.5790000000E+04, 1.0922964188E+01, 5.8151077129E+00, 1.5247958434E+00, 1.0877349578E+00, 7.3384112963E-01],
	[1.5795000000E+04, 1.0927779399E+01, 5.8148664522E+00, 1.5263491836E+00, 1.0885645507E+00, 7.3397617460E-01],
	[1.5800000000E+04, 1.0932595208E+01, 5.8146252779E+00, 1.5279036133E+00, 1.0893943195E+00, 7.3411116694E-01],
	[1.5805000000E+04, 1.0937411615E+01, 5.8143841899E+00, 1.5294591329E+00, 1.0902242637E+00, 7.3424610665E-01],
	[1.5810000000E+04, 1.0942228619E+01, 5.8141431882E+00, 1.5310157429E+00, 1.0910543831E+00, 7.3438099372E-01],
	[1.5815000000E+04, 1.0947046220E+01, 5.8139022726E+00, 1.5325734436E+00, 1.0918846775E+00, 7.3451582815E-01],
	[1.5820000000E+04, 1.0951864418E+01, 5.8136614432E+00, 1.5341322355E+00, 1.0927151464E+00, 7.3465060993E-01],
	[1.5825000000E+04, 1.0956683214E+01, 5.8134206999E+00, 1.5356921190E+00, 1.0935457895E+00, 7.3478533906E-01],
	[1.5830000000E+04, 1.0961502606E+01, 5.8131800425E+00, 1.5372530946E+00, 1.0943766067E+00, 7.3492001554E-01],
	[1.5835000000E+04, 1.0966322596E+01, 5.8129394712E+00, 1.5388151625E+00, 1.0952075975E+00, 7.3505463936E-01],
	[1.5840000000E+04, 1.0971143182E+01, 5.8126989857E+00, 1.5403783234E+00, 1.0960387616E+00, 7.3518921052E-01],
	[1.5845000000E+04, 1.0975964365E+01, 5.8124585861E+00, 1.5419425775E+00, 1.0968700988E+00, 7.3532372901E-01],
	[1.5850000000E+04, 1.0980786144E+01, 5.8122182722E+00, 1.5435079253E+00, 1.0977016087E+00, 7.3545819483E-01],
	[1.5855000000E+04, 1.0985608520E+01, 5.8119780441E+00, 1.5450743672E+00, 1.0985332911E+00, 7.3559260797E-01],
	[1.5860000000E+04, 1.0990431492E+01, 5.8117379017E+00, 1.5466419037E+00, 1.0993651455E+00, 7.3572696844E-01],
	[1.5865000000E+04, 1.0995255060E+01, 5.8114978448E+00, 1.5482105351E+00, 1.1001971718E+00, 7.3586127622E-01],
	[1.5870000000E+04, 1.1000079224E+01, 5.8112578736E+00, 1.5497802618E+00, 1.1010293695E+00, 7.3599553132E-01],
	[1.5875000000E+04, 1.1004903984E+01, 5.8110179878E+00, 1.5513510844E+00, 1.1018617385E+00, 7.3612973372E-01],
	[1.5880000000E+04, 1.1009729340E+01, 5.8107781875E+00, 1.5529230032E+00, 1.1026942783E+00, 7.3626388343E-01],
	[1.5885000000E+04, 1.1014555291E+01, 5.8105384725E+00, 1.5544960186E+00, 1.1035269887E+00, 7.3639798045E-01],
	[1.5890000000E+04, 1.1019381839E+01, 5.8102988429E+00, 1.5560701310E+00, 1.1043598694E+00, 7.3653202476E-01],
	[1.5895000000E+04, 1.1024208981E+01, 5.8100592985E+00, 1.5576453409E+00, 1.1051929200E+00, 7.3666601637E-01],
	[1.5900000000E+04, 1.1029036719E+01, 5.8098198394E+00, 1.5592216487E+00, 1.1060261403E+00, 7.3679995527E-01],
	[1.5905000000E+04, 1.1033865053E+01, 5.8095804654E+00, 1.5607990548E+00, 1.1068595299E+00, 7.3693384146E-01],
	[1.5910000000E+04, 1.1038693981E+01, 5.8093411765E+00, 1.5623775596E+00, 1.1076930886E+00, 7.3706767493E-01],
	[1.5915000000E+04, 1.1043523505E+01, 5.8091019726E+00, 1.5639571636E+00, 1.1085268159E+00, 7.3720145568E-01],
	[1.5920000000E+04, 1.1048353623E+01, 5.8088628538E+00, 1.5655378671E+00, 1.1093607117E+00, 7.3733518371E-01],
	[1.5925000000E+04, 1.1053184336E+01, 5.8086238198E+00, 1.5671196706E+00, 1.1101947756E+00, 7.3746885902E-01],
	[1.5930000000E+04, 1.1058015644E+01, 5.8083848707E+00, 1.5687025745E+00, 1.1110290073E+00, 7.3760248160E-01],
	[1.5935000000E+04, 1.1062847547E+01, 5.8081460065E+00, 1.5702865792E+00, 1.1118634065E+00, 7.3773605144E-01],
	[1.5940000000E+04, 1.1067680044E+01, 5.8079072270E+00, 1.5718716852E+00, 1.1126979728E+00, 7.3786956856E-01],
	[1.5945000000E+04, 1.1072513135E+01, 5.8076685322E+00, 1.5734578928E+00, 1.1135327060E+00, 7.3800303293E-01],
	[1.5950000000E+04, 1.1077346821E+01, 5.8074299220E+00, 1.5750452024E+00, 1.1143676058E+00, 7.3813644457E-01],
	[1.5955000000E+04, 1.1082181100E+01, 5.8071913964E+00, 1.5766336146E+00, 1.1152026718E+00, 7.3826980346E-01],
	[1.5960000000E+04, 1.1087015974E+01, 5.8069529554E+00, 1.5782231297E+00, 1.1160379038E+00, 7.3840310960E-01],
	[1.5965000000E+04, 1.1091851441E+01, 5.8067145988E+00, 1.5798137481E+00, 1.1168733014E+00, 7.3853636300E-01],
	[1.5970000000E+04, 1.1096687503E+01, 5.8064763266E+00, 1.5814054703E+00, 1.1177088643E+00, 7.3866956364E-01],
	[1.5975000000E+04, 1.1101524158E+01, 5.8062381388E+00, 1.5829982967E+00, 1.1185445922E+00, 7.3880271153E-01],
	[1.5980000000E+04, 1.1106361406E+01, 5.8060000354E+00, 1.5845922276E+00, 1.1193804849E+00, 7.3893580666E-01],
	[1.5985000000E+04, 1.1111199248E+01, 5.8057620161E+00, 1.5861872636E+00, 1.1202165419E+00, 7.3906884904E-01],
	[1.5990000000E+04, 1.1116037684E+01, 5.8055240811E+00, 1.5877834049E+00, 1.1210527631E+00, 7.3920183865E-01],
	[1.5995000000E+04, 1.1120876712E+01, 5.8052862301E+00, 1.5893806522E+00, 1.1218891480E+00, 7.3933477549E-01],
	[1.6000000000E+04, 1.1125716334E+01, 5.8050484633E+00, 1.5909790057E+00, 1.1227256963E+00, 7.3946765957E-01],
	[1.6005000000E+04, 1.1130556548E+01, 5.8048107805E+00, 1.5925784659E+00, 1.1235624079E+00, 7.3960049088E-01],
	[1.6010000000E+04, 1.1135397356E+01, 5.8045731817E+00, 1.5941790332E+00, 1.1243992822E+00, 7.3973326941E-01],
	[1.6015000000E+04, 1.1140238756E+01, 5.8043356667E+00, 1.5957807080E+00, 1.1252363192E+00, 7.3986599518E-01],
	[1.6020000000E+04, 1.1145080749E+01, 5.8040982357E+00, 1.5973834908E+00, 1.1260735183E+00, 7.3999866816E-01],
	[1.6025000000E+04, 1.1149923335E+01, 5.8038608884E+00, 1.5989873819E+00, 1.1269108794E+00, 7.4013128837E-01],
	[1.6030000000E+04, 1.1154766512E+01, 5.8036236249E+00, 1.6005923819E+00, 1.1277484021E+00, 7.4026385579E-01],
	[1.6035000000E+04, 1.1159610283E+01, 5.8033864450E+00, 1.6021984910E+00, 1.1285860861E+00, 7.4039637044E-01],
	[1.6040000000E+04, 1.1164454645E+01, 5.8031493488E+00, 1.6038057098E+00, 1.1294239310E+00, 7.4052883230E-01],
	[1.6045000000E+04, 1.1169309701E+01, 5.8029146636E+00, 1.6054140386E+00, 1.1302621284E+00, 7.4066124137E-01],
	[1.6050000000E+04, 1.1174179850E+01, 5.8026833995E+00, 1.6070234779E+00, 1.1311007620E+00, 7.4079359765E-01],
	[1.6055000000E+04, 1.1179050605E+01, 5.8024522167E+00, 1.6086340280E+00, 1.1319395567E+00, 7.4092590114E-01],
	[1.6060000000E+04, 1.1183921966E+01, 5.8022211151E+00, 1.6102456895E+00, 1.1327785122E+00, 7.4105815184E-01],
	[1.6065000000E+04, 1.1188793931E+01, 5.8019900946E+00, 1.6118584627E+00, 1.1336176281E+00, 7.4119034975E-01],
	[1.6070000000E+04, 1.1193666502E+01, 5.8017591552E+00, 1.6134723481E+00, 1.1344569043E+00, 7.4132249486E-01],
	[1.6075000000E+04, 1.1198539679E+01, 5.8015282968E+00, 1.6150873460E+00, 1.1352963403E+00, 7.4145458717E-01],
	[1.6080000000E+04, 1.1203413460E+01, 5.8012975194E+00, 1.6167034569E+00, 1.1361359358E+00, 7.4158662669E-01],
	[1.6085000000E+04, 1.1208287846E+01, 5.8010668229E+00, 1.6183206812E+00, 1.1369756906E+00, 7.4171861340E-01],
	[1.6090000000E+04, 1.1213162837E+01, 5.8008362073E+00, 1.6199390193E+00, 1.1378156044E+00, 7.4185054731E-01],
	[1.6095000000E+04, 1.1218038433E+01, 5.8006056725E+00, 1.6215584717E+00, 1.1386556768E+00, 7.4198242842E-01],
	[1.6100000000E+04, 1.1222914633E+01, 5.8003752185E+00, 1.6231790388E+00, 1.1394959075E+00, 7.4211425672E-01],
	[1.6105000000E+04, 1.1227791438E+01, 5.8001448452E+00, 1.6248007209E+00, 1.1403362962E+00, 7.4224603221E-01],
	[1.6110000000E+04, 1.1232668847E+01, 5.7999145525E+00, 1.6264235186E+00, 1.1411768426E+00, 7.4237775490E-01],
	[1.6115000000E+04, 1.1237546860E+01, 5.7996843404E+00, 1.6280474321E+00, 1.1420175464E+00, 7.4250942478E-01],
	[1.6120000000E+04, 1.1242425477E+01, 5.7994542089E+00, 1.6296724621E+00, 1.1428584073E+00, 7.4264104185E-01],
	[1.6125000000E+04, 1.1247304699E+01, 5.7992241579E+00, 1.6312986088E+00, 1.1436994250E+00, 7.4277260610E-01],
	[1.6130000000E+04, 1.1252184524E+01, 5.7989941873E+00, 1.6329258726E+00, 1.1445405991E+00, 7.4290411755E-01],
	[1.6135000000E+04, 1.1257064953E+01, 5.7987642972E+00, 1.6345542541E+00, 1.1453819294E+00, 7.4303557618E-01],
	[1.6140000000E+04, 1.1261945986E+01, 5.7985344873E+00, 1.6361837536E+00, 1.1462234155E+00, 7.4316698199E-01],
	[1.6145000000E+04, 1.1266827622E+01, 5.7983047578E+00, 1.6378143716E+00, 1.1470650572E+00, 7.4329833499E-01],
	[1.6150000000E+04, 1.1271709862E+01, 5.7980751085E+00, 1.6394461084E+00, 1.1479068541E+00, 7.4342963518E-01],
	[1.6155000000E+04, 1.1276592705E+01, 5.7978455393E+00, 1.6410789646E+00, 1.1487488060E+00, 7.4356088255E-01],
	[1.6160000000E+04, 1.1281476152E+01, 5.7976160503E+00, 1.6427129404E+00, 1.1495909124E+00, 7.4369207710E-01],
	[1.6165000000E+04, 1.1286360201E+01, 5.7973866414E+00, 1.6443480364E+00, 1.1504331731E+00, 7.4382321883E-01],
	[1.6170000000E+04, 1.1291244854E+01, 5.7971573124E+00, 1.6459842529E+00, 1.1512755879E+00, 7.4395430774E-01],
	[1.6175000000E+04, 1.1296130109E+01, 5.7969280635E+00, 1.6476215904E+00, 1.1521181563E+00, 7.4408534383E-01],
	[1.6180000000E+04, 1.1301015967E+01, 5.7966988944E+00, 1.6492600492E+00, 1.1529608781E+00, 7.4421632710E-01],
	[1.6185000000E+04, 1.1305902428E+01, 5.7964698053E+00, 1.6508996299E+00, 1.1538037529E+00, 7.4434725755E-01],
	[1.6190000000E+04, 1.1310789491E+01, 5.7962407959E+00, 1.6525403329E+00, 1.1546467805E+00, 7.4447813517E-01],
	[1.6195000000E+04, 1.1315677157E+01, 5.7960118663E+00, 1.6541821584E+00, 1.1554899606E+00, 7.4460895998E-01],
	[1.6200000000E+04, 1.1320565425E+01, 5.7957830164E+00, 1.6558251071E+00, 1.1563332928E+00, 7.4473973196E-01],
	[1.6205000000E+04, 1.1325454296E+01, 5.7955542462E+00, 1.6574691793E+00, 1.1571767768E+00, 7.4487045112E-01],
	[1.6210000000E+04, 1.1330343768E+01, 5.7953255555E+00, 1.6591143753E+00, 1.1580204123E+00, 7.4500111745E-01],
	[1.6215000000E+04, 1.1335233842E+01, 5.7950969444E+00, 1.6607606957E+00, 1.1588641990E+00, 7.4513173097E-01],
	[1.6220000000E+04, 1.1340124519E+01, 5.7948684128E+00, 1.6624081409E+00, 1.1597081367E+00, 7.4526229166E-01],
	[1.6225000000E+04, 1.1345015797E+01, 5.7946399607E+00, 1.6640567112E+00, 1.1605522249E+00, 7.4539279952E-01],
	[1.6230000000E+04, 1.1349907677E+01, 5.7944115879E+00, 1.6657064072E+00, 1.1613964634E+00, 7.4552325456E-01],
	[1.6235000000E+04, 1.1354800158E+01, 5.7941832945E+00, 1.6673572291E+00, 1.1622408518E+00, 7.4565365678E-01],
	[1.6240000000E+04, 1.1359693241E+01, 5.7939550803E+00, 1.6690091776E+00, 1.1630853900E+00, 7.4578400617E-01],
	[1.6245000000E+04, 1.1364586925E+01, 5.7937269455E+00, 1.6706622528E+00, 1.1639300774E+00, 7.4591430274E-01],
	[1.6250000000E+04, 1.1369481210E+01, 5.7934988897E+00, 1.6723164554E+00, 1.1647749139E+00, 7.4604454648E-01],
	[1.6255000000E+04, 1.1374376096E+01, 5.7932709132E+00, 1.6739717856E+00, 1.1656198992E+00, 7.4617473740E-01],
	[1.6260000000E+04, 1.1379271584E+01, 5.7930430157E+00, 1.6756282440E+00, 1.1664650328E+00, 7.4630487550E-01],
	[1.6265000000E+04, 1.1384167672E+01, 5.7928151972E+00, 1.6772858309E+00, 1.1673103146E+00, 7.4643496077E-01],
	[1.6270000000E+04, 1.1389064361E+01, 5.7925874577E+00, 1.6789445468E+00, 1.1681557441E+00, 7.4656499322E-01],
	[1.6275000000E+04, 1.1393961651E+01, 5.7923597971E+00, 1.6806043921E+00, 1.1690013212E+00, 7.4669497285E-01],
	[1.6280000000E+04, 1.1398859541E+01, 5.7921322155E+00, 1.6822653672E+00, 1.1698470454E+00, 7.4682489965E-01],
	[1.6285000000E+04, 1.1403758032E+01, 5.7919047126E+00, 1.6839274725E+00, 1.1706929165E+00, 7.4695477363E-01],
	[1.6290000000E+04, 1.1408657123E+01, 5.7916772885E+00, 1.6855907085E+00, 1.1715389342E+00, 7.4708459480E-01],
	[1.6295000000E+04, 1.1413556814E+01, 5.7914499431E+00, 1.6872550755E+00, 1.1723850981E+00, 7.4721436313E-01],
	[1.6300000000E+04, 1.1418457105E+01, 5.7912226764E+00, 1.6889205741E+00, 1.1732314080E+00, 7.4734407865E-01],
	[1.6305000000E+04, 1.1423377031E+01, 5.7909997380E+00, 1.6905872045E+00, 1.1740782392E+00, 7.4747374135E-01],
	[1.6310000000E+04, 1.1428303686E+01, 5.7907782418E+00, 1.6922549673E+00, 1.1749253375E+00, 7.4760335123E-01],
	[1.6315000000E+04, 1.1433230954E+01, 5.7905568220E+00, 1.6939238629E+00, 1.1757725818E+00, 7.4773290829E-01],
	[1.6320000000E+04, 1.1438158837E+01, 5.7903354785E+00, 1.6955938916E+00, 1.1766199719E+00, 7.4786241254E-01],
	[1.6325000000E+04, 1.1443087332E+01, 5.7901142113E+00, 1.6972650539E+00, 1.1774675075E+00, 7.4799186396E-01],
	[1.6330000000E+04, 1.1448016441E+01, 5.7898930203E+00, 1.6989373503E+00, 1.1783151882E+00, 7.4812126257E-01],
	[1.6335000000E+04, 1.1452946163E+01, 5.7896719054E+00, 1.7006107811E+00, 1.1791630138E+00, 7.4825060837E-01],
	[1.6340000000E+04, 1.1457876499E+01, 5.7894508666E+00, 1.7022853467E+00, 1.1800109839E+00, 7.4837990135E-01],
	[1.6345000000E+04, 1.1462807447E+01, 5.7892299040E+00, 1.7039610477E+00, 1.1808590982E+00, 7.4850914152E-01],
	[1.6350000000E+04, 1.1467739008E+01, 5.7890090173E+00, 1.7056378843E+00, 1.1817073565E+00, 7.4863832887E-01],
	[1.6355000000E+04, 1.1472671182E+01, 5.7887882066E+00, 1.7073158571E+00, 1.1825557584E+00, 7.4876746342E-01],
	[1.6360000000E+04, 1.1477603969E+01, 5.7885674718E+00, 1.7089949664E+00, 1.1834043035E+00, 7.4889654515E-01],
	[1.6365000000E+04, 1.1482537368E+01, 5.7883468128E+00, 1.7106752127E+00, 1.1842529917E+00, 7.4902557407E-01],
	[1.6370000000E+04, 1.1487471380E+01, 5.7881262297E+00, 1.7123565964E+00, 1.1851018225E+00, 7.4915455019E-01],
	[1.6375000000E+04, 1.1492406004E+01, 5.7879057224E+00, 1.7140391179E+00, 1.1859507957E+00, 7.4928347350E-01],
	[1.6380000000E+04, 1.1497341241E+01, 5.7876852907E+00, 1.7157227777E+00, 1.1867999110E+00, 7.4941234401E-01],
	[1.6385000000E+04, 1.1502277090E+01, 5.7874649348E+00, 1.7174075761E+00, 1.1876491681E+00, 7.4954116171E-01],
	[1.6390000000E+04, 1.1507213550E+01, 5.7872446544E+00, 1.7190935136E+00, 1.1884985665E+00, 7.4966992661E-01],
	[1.6395000000E+04, 1.1512150623E+01, 5.7870244496E+00, 1.7207805906E+00, 1.1893481062E+00, 7.4979863870E-01],
	[1.6400000000E+04, 1.1517088307E+01, 5.7868043204E+00, 1.7224688075E+00, 1.1901977866E+00, 7.4992729800E-01],
	[1.6405000000E+04, 1.1522026603E+01, 5.7865842666E+00, 1.7241581648E+00, 1.1910476076E+00, 7.5005590450E-01],
	[1.6410000000E+04, 1.1526965511E+01, 5.7863642882E+00, 1.7258486628E+00, 1.1918975687E+00, 7.5018445821E-01],
	[1.6415000000E+04, 1.1531905030E+01, 5.7861443852E+00, 1.7275403020E+00, 1.1927476698E+00, 7.5031295912E-01],
	[1.6420000000E+04, 1.1536845160E+01, 5.7859245576E+00, 1.7292330828E+00, 1.1935979105E+00, 7.5044140724E-01],
	[1.6425000000E+04, 1.1541785902E+01, 5.7857048052E+00, 1.7309270057E+00, 1.1944482904E+00, 7.5056980256E-01],
	[1.6430000000E+04, 1.1546727255E+01, 5.7854851280E+00, 1.7326220710E+00, 1.1952988094E+00, 7.5069814510E-01],
	[1.6435000000E+04, 1.1551669219E+01, 5.7852655260E+00, 1.7343182792E+00, 1.1961494669E+00, 7.5082643485E-01],
	[1.6440000000E+04, 1.1556611793E+01, 5.7850459992E+00, 1.7360156307E+00, 1.1970002629E+00, 7.5095467181E-01],
	[1.6445000000E+04, 1.1561554979E+01, 5.7848265474E+00, 1.7377141259E+00, 1.1978511969E+00, 7.5108285599E-01],
	[1.6450000000E+04, 1.1566498775E+01, 5.7846071707E+00, 1.7394137653E+00, 1.1987022686E+00, 7.5121098738E-01],
	[1.6455000000E+04, 1.1571443182E+01, 5.7843878689E+00, 1.7411145492E+00, 1.1995534777E+00, 7.5133906600E-01],
	[1.6460000000E+04, 1.1576388200E+01, 5.7841686421E+00, 1.7428164781E+00, 1.2004048240E+00, 7.5146709184E-01],
	[1.6465000000E+04, 1.1581333827E+01, 5.7839494902E+00, 1.7445195524E+00, 1.2012563071E+00, 7.5159506490E-01],
	[1.6470000000E+04, 1.1586280065E+01, 5.7837304131E+00, 1.7462237726E+00, 1.2021079267E+00, 7.5172298519E-01],
	[1.6475000000E+04, 1.1591226913E+01, 5.7835114108E+00, 1.7479291390E+00, 1.2029596824E+00, 7.5185085271E-01],
	[1.6480000000E+04, 1.1596174372E+01, 5.7832924833E+00, 1.7496356520E+00, 1.2038115741E+00, 7.5197866746E-01],
	[1.6485000000E+04, 1.1601122440E+01, 5.7830736304E+00, 1.7513433122E+00, 1.2046636013E+00, 7.5210642944E-01],
	[1.6490000000E+04, 1.1606071118E+01, 5.7828548522E+00, 1.7530521199E+00, 1.2055157638E+00, 7.5223413866E-01],
	[1.6495000000E+04, 1.1611020405E+01, 5.7826361486E+00, 1.7547620756E+00, 1.2063680613E+00, 7.5236179511E-01],
	[1.6500000000E+04, 1.1615970303E+01, 5.7824175196E+00, 1.7564731796E+00, 1.2072204934E+00, 7.5248939885E-01],
	[1.6505000000E+04, 1.1620920809E+01, 5.7821989650E+00, 1.7581854323E+00, 1.2080730598E+00, 7.5261694991E-01],
	[1.6510000000E+04, 1.1625871926E+01, 5.7819804849E+00, 1.7598988343E+00, 1.2089257602E+00, 7.5274444827E-01],
	[1.6515000000E+04, 1.1630823651E+01, 5.7817620792E+00, 1.7616133860E+00, 1.2097785944E+00, 7.5287189394E-01],
	[1.6520000000E+04, 1.1635775986E+01, 5.7815437479E+00, 1.7633290877E+00, 1.2106315620E+00, 7.5299928691E-01],
	[1.6525000000E+04, 1.1640728929E+01, 5.7813254909E+00, 1.7650459398E+00, 1.2114846627E+00, 7.5312662720E-01],
	[1.6530000000E+04, 1.1645682482E+01, 5.7811073081E+00, 1.7667639429E+00, 1.2123378961E+00, 7.5325391479E-01],
	[1.6535000000E+04, 1.1650636643E+01, 5.7808891996E+00, 1.7684830973E+00, 1.2131912621E+00, 7.5338114968E-01],
	[1.6540000000E+04, 1.1655591413E+01, 5.7806711652E+00, 1.7702034034E+00, 1.2140447602E+00, 7.5350833188E-01],
	[1.6545000000E+04, 1.1660546792E+01, 5.7804532050E+00, 1.7719248617E+00, 1.2148983902E+00, 7.5363546138E-01],
	[1.6550000000E+04, 1.1665502779E+01, 5.7802353188E+00, 1.7736474725E+00, 1.2157521518E+00, 7.5376253819E-01],
	[1.6555000000E+04, 1.1670459375E+01, 5.7800175067E+00, 1.7753712364E+00, 1.2166060446E+00, 7.5388956229E-01],
	[1.6560000000E+04, 1.1675416579E+01, 5.7797997685E+00, 1.7770961538E+00, 1.2174600683E+00, 7.5401653370E-01],
	[1.6565000000E+04, 1.1680381368E+01, 5.7795836142E+00, 1.7788222249E+00, 1.2183143657E+00, 7.5414345241E-01],
	[1.6570000000E+04, 1.1685365510E+01, 5.7793715876E+00, 1.7805494504E+00, 1.2191691781E+00, 7.5427031842E-01],
	[1.6575000000E+04, 1.1690350274E+01, 5.7791596328E+00, 1.7822778306E+00, 1.2200241216E+00, 7.5439713174E-01],
	[1.6580000000E+04, 1.1695335660E+01, 5.7789477496E+00, 1.7840073658E+00, 1.2208791959E+00, 7.5452389235E-01],
	[1.6585000000E+04, 1.1700321668E+01, 5.7787359382E+00, 1.7857380567E+00, 1.2217344007E+00, 7.5465060026E-01],
	[1.6590000000E+04, 1.1705308297E+01, 5.7785241983E+00, 1.7874699035E+00, 1.2225897357E+00, 7.5477725548E-01],
	[1.6595000000E+04, 1.1710295549E+01, 5.7783125299E+00, 1.7892029067E+00, 1.2234452006E+00, 7.5490385799E-01],
	[1.6600000000E+04, 1.1715283421E+01, 5.7781009331E+00, 1.7909370667E+00, 1.2243007950E+00, 7.5503040780E-01],
	[1.6605000000E+04, 1.1720271916E+01, 5.7778894078E+00, 1.7926723840E+00, 1.2251565187E+00, 7.5515690492E-01],
	[1.6610000000E+04, 1.1725261031E+01, 5.7776779539E+00, 1.7944088589E+00, 1.2260123714E+00, 7.5528334933E-01],
	[1.6615000000E+04, 1.1730250768E+01, 5.7774665713E+00, 1.7961464919E+00, 1.2268683527E+00, 7.5540974104E-01],
	[1.6620000000E+04, 1.1735241126E+01, 5.7772552601E+00, 1.7978852834E+00, 1.2277244623E+00, 7.5553608005E-01],
	[1.6625000000E+04, 1.1740232105E+01, 5.7770440202E+00, 1.7996252338E+00, 1.2285807000E+00, 7.5566236637E-01],
	[1.6630000000E+04, 1.1745223705E+01, 5.7768328515E+00, 1.8013663436E+00, 1.2294370654E+00, 7.5578859998E-01],
	[1.6635000000E+04, 1.1750215925E+01, 5.7766217541E+00, 1.8031086132E+00, 1.2302935582E+00, 7.5591478089E-01],
	[1.6640000000E+04, 1.1755208766E+01, 5.7764107277E+00, 1.8048520429E+00, 1.2311501781E+00, 7.5604090911E-01],
	[1.6645000000E+04, 1.1760202228E+01, 5.7761997725E+00, 1.8065966333E+00, 1.2320069248E+00, 7.5616698462E-01],
	[1.6650000000E+04, 1.1765196310E+01, 5.7759888883E+00, 1.8083423848E+00, 1.2328637980E+00, 7.5629300744E-01],
	[1.6655000000E+04, 1.1770191013E+01, 5.7757780752E+00, 1.8100892977E+00, 1.2337207974E+00, 7.5641897756E-01],
	[1.6660000000E+04, 1.1775186335E+01, 5.7755673330E+00, 1.8118373725E+00, 1.2345779227E+00, 7.5654489499E-01],
	[1.6665000000E+04, 1.1780182278E+01, 5.7753566618E+00, 1.8135866096E+00, 1.2354351735E+00, 7.5667075971E-01],
	[1.6670000000E+04, 1.1785178841E+01, 5.7751460614E+00, 1.8153370094E+00, 1.2362925496E+00, 7.5679657174E-01],
	[1.6675000000E+04, 1.1790176024E+01, 5.7749355318E+00, 1.8170885724E+00, 1.2371500506E+00, 7.5692233108E-01],
	[1.6680000000E+04, 1.1795173826E+01, 5.7747250731E+00, 1.8188412990E+00, 1.2380076762E+00, 7.5704803772E-01],
	[1.6685000000E+04, 1.1800172248E+01, 5.7745146851E+00, 1.8205951896E+00, 1.2388654262E+00, 7.5717369167E-01],
	[1.6690000000E+04, 1.1805171290E+01, 5.7743043678E+00, 1.8223502447E+00, 1.2397233003E+00, 7.5729929292E-01],
	[1.6695000000E+04, 1.1810170951E+01, 5.7740941211E+00, 1.8241064646E+00, 1.2405812980E+00, 7.5742484148E-01],
	[1.6700000000E+04, 1.1815171232E+01, 5.7738839451E+00, 1.8258638497E+00, 1.2414394192E+00, 7.5755033735E-01],
	[1.6705000000E+04, 1.1820172132E+01, 5.7736738396E+00, 1.8276224006E+00, 1.2422976634E+00, 7.5767578054E-01],
	[1.6710000000E+04, 1.1825173651E+01, 5.7734638046E+00, 1.8293821176E+00, 1.2431560305E+00, 7.5780117103E-01],
	[1.6715000000E+04, 1.1830175789E+01, 5.7732538401E+00, 1.8311430011E+00, 1.2440145200E+00, 7.5792650883E-01],
	[1.6720000000E+04, 1.1835178546E+01, 5.7730439461E+00, 1.8329050516E+00, 1.2448731317E+00, 7.5805179395E-01],
	[1.6725000000E+04, 1.1840181921E+01, 5.7728341224E+00, 1.8346682696E+00, 1.2457318653E+00, 7.5817702638E-01],
	[1.6730000000E+04, 1.1845185916E+01, 5.7726243691E+00, 1.8364326553E+00, 1.2465907204E+00, 7.5830220612E-01],
	[1.6735000000E+04, 1.1850190529E+01, 5.7724146860E+00, 1.8381982093E+00, 1.2474496968E+00, 7.5842733319E-01],
	[1.6740000000E+04, 1.1855195760E+01, 5.7722050733E+00, 1.8399649319E+00, 1.2483087942E+00, 7.5855240757E-01],
	[1.6745000000E+04, 1.1860201610E+01, 5.7719955307E+00, 1.8417328236E+00, 1.2491680122E+00, 7.5867742927E-01],
	[1.6750000000E+04, 1.1865208078E+01, 5.7717860583E+00, 1.8435018849E+00, 1.2500273505E+00, 7.5880239829E-01],
	[1.6755000000E+04, 1.1870215164E+01, 5.7715766560E+00, 1.8452721160E+00, 1.2508868088E+00, 7.5892731463E-01],
	[1.6760000000E+04, 1.1875222868E+01, 5.7713673237E+00, 1.8470435176E+00, 1.2517463869E+00, 7.5905217830E-01],
	[1.6765000000E+04, 1.1880231191E+01, 5.7711580616E+00, 1.8488160899E+00, 1.2526060844E+00, 7.5917698929E-01],
	[1.6770000000E+04, 1.1885240131E+01, 5.7709488694E+00, 1.8505898334E+00, 1.2534659010E+00, 7.5930174761E-01],
	[1.6775000000E+04, 1.1890249688E+01, 5.7707397471E+00, 1.8523647486E+00, 1.2543258363E+00, 7.5942645326E-01],
	[1.6780000000E+04, 1.1895259864E+01, 5.7705306947E+00, 1.8541408358E+00, 1.2551858902E+00, 7.5955110623E-01],
	[1.6785000000E+04, 1.1900270657E+01, 5.7703217122E+00, 1.8559180955E+00, 1.2560460622E+00, 7.5967570654E-01],
	[1.6790000000E+04, 1.1905282067E+01, 5.7701127995E+00, 1.8576965281E+00, 1.2569063521E+00, 7.5980025419E-01],
	[1.6795000000E+04, 1.1910294095E+01, 5.7699039566E+00, 1.8594761340E+00, 1.2577667596E+00, 7.5992474917E-01],
	[1.6800000000E+04, 1.1915306739E+01, 5.7696951833E+00, 1.8612569137E+00, 1.2586272843E+00, 7.6004919148E-01],
	[1.6805000000E+04, 1.1920320001E+01, 5.7694864798E+00, 1.8630388675E+00, 1.2594879260E+00, 7.6017358114E-01],
	[1.6810000000E+04, 1.1925333880E+01, 5.7692778459E+00, 1.8648219960E+00, 1.2603486844E+00, 7.6029791814E-01],
	[1.6815000000E+04, 1.1930348376E+01, 5.7690692816E+00, 1.8666062995E+00, 1.2612095590E+00, 7.6042220248E-01],
	[1.6820000000E+04, 1.1935363488E+01, 5.7688607868E+00, 1.8683917784E+00, 1.2620705497E+00, 7.6054643417E-01],
	[1.6825000000E+04, 1.1940379217E+01, 5.7686523615E+00, 1.8701784332E+00, 1.2629316561E+00, 7.6067061320E-01],
	[1.6830000000E+04, 1.1945395563E+01, 5.7684440057E+00, 1.8719662642E+00, 1.2637928780E+00, 7.6079473959E-01],
	[1.6835000000E+04, 1.1950437263E+01, 5.7682409075E+00, 1.8737552720E+00, 1.2646547413E+00, 7.6091881332E-01],
	[1.6840000000E+04, 1.1955481147E+01, 5.7680382025E+00, 1.8755454570E+00, 1.2655167536E+00, 7.6104283441E-01],
	[1.6845000000E+04, 1.1960525662E+01, 5.7678355648E+00, 1.8773368195E+00, 1.2663788816E+00, 7.6116680286E-01],
	[1.6850000000E+04, 1.1965570807E+01, 5.7676329944E+00, 1.8791293600E+00, 1.2672411248E+00, 7.6129071867E-01],
	[1.6855000000E+04, 1.1970616582E+01, 5.7674304912E+00, 1.8809230789E+00, 1.2681034831E+00, 7.6141458184E-01],
	[1.6860000000E+04, 1.1975662988E+01, 5.7672280552E+00, 1.8827179767E+00, 1.2689659561E+00, 7.6153839237E-01],
	[1.6865000000E+04, 1.1980710023E+01, 5.7670256863E+00, 1.8845140537E+00, 1.2698285434E+00, 7.6166215027E-01],
	[1.6870000000E+04, 1.1985757689E+01, 5.7668233844E+00, 1.8863113104E+00, 1.2706912449E+00, 7.6178585554E-01],
	[1.6875000000E+04, 1.1990805984E+01, 5.7666211497E+00, 1.8881097472E+00, 1.2715540602E+00, 7.6190950817E-01],
	[1.6880000000E+04, 1.1995854910E+01, 5.7664189819E+00, 1.8899093646E+00, 1.2724169889E+00, 7.6203310819E-01],
	[1.6885000000E+04, 1.2000904465E+01, 5.7662168811E+00, 1.8917101629E+00, 1.2732800308E+00, 7.6215665558E-01],
	[1.6890000000E+04, 1.2005954649E+01, 5.7660148472E+00, 1.8935121426E+00, 1.2741431856E+00, 7.6228015035E-01],
	[1.6895000000E+04, 1.2011005463E+01, 5.7658128801E+00, 1.8953153041E+00, 1.2750064529E+00, 7.6240359250E-01],
	[1.6900000000E+04, 1.2016056907E+01, 5.7656109800E+00, 1.8971196479E+00, 1.2758698325E+00, 7.6252698204E-01],
	[1.6905000000E+04, 1.2021108979E+01, 5.7654091466E+00, 1.8989251743E+00, 1.2767333240E+00, 7.6265031897E-01],
	[1.6910000000E+04, 1.2026161681E+01, 5.7652073799E+00, 1.9007318838E+00, 1.2775969272E+00, 7.6277360328E-01],
	[1.6915000000E+04, 1.2031215012E+01, 5.7650056800E+00, 1.9025397768E+00, 1.2784606417E+00, 7.6289683500E-01],
	[1.6920000000E+04, 1.2036268972E+01, 5.7648040467E+00, 1.9043488537E+00, 1.2793244672E+00, 7.6302001411E-01],
	[1.6925000000E+04, 1.2041323560E+01, 5.7646024801E+00, 1.9061591150E+00, 1.2801884035E+00, 7.6314314061E-01],
	[1.6930000000E+04, 1.2046378777E+01, 5.7644009800E+00, 1.9079705611E+00, 1.2810524502E+00, 7.6326621453E-01],
	[1.6935000000E+04, 1.2051434623E+01, 5.7641995465E+00, 1.9097831924E+00, 1.2819166070E+00, 7.6338923584E-01],
	[1.6940000000E+04, 1.2056491098E+01, 5.7639981794E+00, 1.9115970093E+00, 1.2827808736E+00, 7.6351220457E-01],
	[1.6945000000E+04, 1.2061548200E+01, 5.7637968789E+00, 1.9134120122E+00, 1.2836452497E+00, 7.6363512071E-01],
	[1.6950000000E+04, 1.2066605931E+01, 5.7635956447E+00, 1.9152282017E+00, 1.2845097350E+00, 7.6375798427E-01],
	[1.6955000000E+04, 1.2071664290E+01, 5.7633944769E+00, 1.9170455780E+00, 1.2853743292E+00, 7.6388079525E-01],
	[1.6960000000E+04, 1.2076723278E+01, 5.7631933755E+00, 1.9188641417E+00, 1.2862390320E+00, 7.6400355365E-01],
	[1.6965000000E+04, 1.2081782893E+01, 5.7629923403E+00, 1.9206838931E+00, 1.2871038431E+00, 7.6412625947E-01],
	[1.6970000000E+04, 1.2086843136E+01, 5.7627913715E+00, 1.9225048327E+00, 1.2879687621E+00, 7.6424891273E-01],
	[1.6975000000E+04, 1.2091904007E+01, 5.7625904688E+00, 1.9243269609E+00, 1.2888337888E+00, 7.6437151342E-01],
	[1.6980000000E+04, 1.2096965505E+01, 5.7623896322E+00, 1.9261502782E+00, 1.2896989229E+00, 7.6449406154E-01],
	[1.6985000000E+04, 1.2102027631E+01, 5.7621888618E+00, 1.9279747849E+00, 1.2905641640E+00, 7.6461655711E-01],
	[1.6990000000E+04, 1.2107090384E+01, 5.7619881575E+00, 1.9298004814E+00, 1.2914295119E+00, 7.6473900012E-01],
	[1.6995000000E+04, 1.2112153765E+01, 5.7617875193E+00, 1.9316273683E+00, 1.2922949662E+00, 7.6486139057E-01],
	[1.7000000000E+04, 1.2117217773E+01, 5.7615869470E+00, 1.9334554459E+00, 1.2931605266E+00, 7.6498372848E-01],
	[1.7005000000E+04, 1.2122282408E+01, 5.7613864407E+00, 1.9352847147E+00, 1.2940261929E+00, 7.6510601385E-01],
	[1.7010000000E+04, 1.2127347669E+01, 5.7611860003E+00, 1.9371151750E+00, 1.2948919648E+00, 7.6522824667E-01],
	[1.7015000000E+04, 1.2132413558E+01, 5.7609856258E+00, 1.9389468273E+00, 1.2957578418E+00, 7.6535042696E-01],
	[1.7020000000E+04, 1.2137480074E+01, 5.7607853172E+00, 1.9407796721E+00, 1.2966238238E+00, 7.6547255471E-01],
	[1.7025000000E+04, 1.2142547216E+01, 5.7605850743E+00, 1.9426137097E+00, 1.2974899104E+00, 7.6559462993E-01],
	[1.7030000000E+04, 1.2147614985E+01, 5.7603848972E+00, 1.9444489406E+00, 1.2983561013E+00, 7.6571665263E-01],
	[1.7035000000E+04, 1.2152683380E+01, 5.7601847858E+00, 1.9462853652E+00, 1.2992223962E+00, 7.6583862281E-01],
	[1.7040000000E+04, 1.2157752402E+01, 5.7599847401E+00, 1.9481229840E+00, 1.3000887948E+00, 7.6596054047E-01],
	[1.7045000000E+04, 1.2162822050E+01, 5.7597847600E+00, 1.9499617972E+00, 1.3009552968E+00, 7.6608240562E-01],
	[1.7050000000E+04, 1.2167892324E+01, 5.7595848456E+00, 1.9518018055E+00, 1.3018219019E+00, 7.6620421825E-01],
	[1.7055000000E+04, 1.2172963224E+01, 5.7593849966E+00, 1.9536430092E+00, 1.3026886098E+00, 7.6632597839E-01],
	[1.7060000000E+04, 1.2178034750E+01, 5.7591852132E+00, 1.9554854087E+00, 1.3035554201E+00, 7.6644768602E-01],
	[1.7065000000E+04, 1.2183106902E+01, 5.7589854953E+00, 1.9573290044E+00, 1.3044223327E+00, 7.6656934116E-01],
	[1.7070000000E+04, 1.2188179679E+01, 5.7587858427E+00, 1.9591737968E+00, 1.3052893471E+00, 7.6669094381E-01],
	[1.7075000000E+04, 1.2193253082E+01, 5.7585862556E+00, 1.9610197864E+00, 1.3061564630E+00, 7.6681249396E-01],
	[1.7080000000E+04, 1.2198327111E+01, 5.7583867338E+00, 1.9628669735E+00, 1.3070236803E+00, 7.6693399164E-01],
	[1.7085000000E+04, 1.2203401765E+01, 5.7581872774E+00, 1.9647153585E+00, 1.3078909985E+00, 7.6705543684E-01],
	[1.7090000000E+04, 1.2208477044E+01, 5.7579878862E+00, 1.9665649419E+00, 1.3087584173E+00, 7.6717682956E-01],
	[1.7095000000E+04, 1.2213552949E+01, 5.7577885602E+00, 1.9684157241E+00, 1.3096259365E+00, 7.6729816982E-01],
	[1.7100000000E+04, 1.2218629478E+01, 5.7575892994E+00, 1.9702677055E+00, 1.3104935557E+00, 7.6741945760E-01],
	[1.7105000000E+04, 1.2223726841E+01, 5.7573942125E+00, 1.9721208866E+00, 1.3113617204E+00, 7.6754069293E-01],
	[1.7110000000E+04, 1.2228831507E+01, 5.7572005445E+00, 1.9739752678E+00, 1.3122301326E+00, 7.6766187581E-01],
	[1.7115000000E+04, 1.2233936813E+01, 5.7570069395E+00, 1.9758308495E+00, 1.3130986451E+00, 7.6778300623E-01],
	[1.7120000000E+04, 1.2239042757E+01, 5.7568133976E+00, 1.9776876322E+00, 1.3139672576E+00, 7.6790408421E-01],
	[1.7125000000E+04, 1.2244149341E+01, 5.7566199187E+00, 1.9795456161E+00, 1.3148359698E+00, 7.6802510975E-01],
	[1.7130000000E+04, 1.2249256564E+01, 5.7564265028E+00, 1.9814048019E+00, 1.3157047813E+00, 7.6814608285E-01],
	[1.7135000000E+04, 1.2254364426E+01, 5.7562331499E+00, 1.9832651899E+00, 1.3165736919E+00, 7.6826700352E-01],
	[1.7140000000E+04, 1.2259472927E+01, 5.7560398598E+00, 1.9851267805E+00, 1.3174427013E+00, 7.6838787176E-01],
	[1.7145000000E+04, 1.2264582066E+01, 5.7558466326E+00, 1.9869895742E+00, 1.3183118091E+00, 7.6850868758E-01],
	[1.7150000000E+04, 1.2269691843E+01, 5.7556534683E+00, 1.9888535714E+00, 1.3191810152E+00, 7.6862945099E-01],
	[1.7155000000E+04, 1.2274802260E+01, 5.7554603667E+00, 1.9907187725E+00, 1.3200503191E+00, 7.6875016198E-01],
	[1.7160000000E+04, 1.2279913314E+01, 5.7552673279E+00, 1.9925851779E+00, 1.3209197205E+00, 7.6887082057E-01],
	[1.7165000000E+04, 1.2285025007E+01, 5.7550743517E+00, 1.9944527881E+00, 1.3217892192E+00, 7.6899142675E-01],
	[1.7170000000E+04, 1.2290137338E+01, 5.7548814383E+00, 1.9963216035E+00, 1.3226588148E+00, 7.6911198054E-01],
	[1.7175000000E+04, 1.2295250306E+01, 5.7546885875E+00, 1.9981916245E+00, 1.3235285071E+00, 7.6923248194E-01],
	[1.7180000000E+04, 1.2300363913E+01, 5.7544957993E+00, 2.0000628516E+00, 1.3243982958E+00, 7.6935293096E-01],
	[1.7185000000E+04, 1.2305478158E+01, 5.7543030736E+00, 2.0019352851E+00, 1.3252681805E+00, 7.6947332759E-01],
	[1.7190000000E+04, 1.2310593040E+01, 5.7541104105E+00, 2.0038089255E+00, 1.3261381609E+00, 7.6959367186E-01],
	[1.7195000000E+04, 1.2315708560E+01, 5.7539178098E+00, 2.0056837732E+00, 1.3270082368E+00, 7.6971396375E-01],
	[1.7200000000E+04, 1.2320824717E+01, 5.7537252716E+00, 2.0075598287E+00, 1.3278784078E+00, 7.6983420327E-01],
	[1.7205000000E+04, 1.2325941512E+01, 5.7535327958E+00, 2.0094370924E+00, 1.3287486736E+00, 7.6995439044E-01],
	[1.7210000000E+04, 1.2331058943E+01, 5.7533403823E+00, 2.0113155646E+00, 1.3296190340E+00, 7.7007452526E-01],
	[1.7215000000E+04, 1.2336177013E+01, 5.7531480312E+00, 2.0131952459E+00, 1.3304894886E+00, 7.7019460773E-01],
	[1.7220000000E+04, 1.2341295719E+01, 5.7529557423E+00, 2.0150761367E+00, 1.3313600371E+00, 7.7031463786E-01],
	[1.7225000000E+04, 1.2346415062E+01, 5.7527635157E+00, 2.0169582373E+00, 1.3322306793E+00, 7.7043461565E-01],
	[1.7230000000E+04, 1.2351535042E+01, 5.7525713513E+00, 2.0188415482E+00, 1.3331014147E+00, 7.7055454111E-01],
	[1.7235000000E+04, 1.2356655658E+01, 5.7523792491E+00, 2.0207260698E+00, 1.3339722432E+00, 7.7067441425E-01],
	[1.7240000000E+04, 1.2361776912E+01, 5.7521872091E+00, 2.0226118026E+00, 1.3348431644E+00, 7.7079423506E-01],
	[1.7245000000E+04, 1.2366898802E+01, 5.7519952311E+00, 2.0244987470E+00, 1.3357141780E+00, 7.7091400357E-01],
	[1.7250000000E+04, 1.2372021328E+01, 5.7518033151E+00, 2.0263869034E+00, 1.3365852838E+00, 7.7103371977E-01],
	[1.7255000000E+04, 1.2377144490E+01, 5.7516114612E+00, 2.0282762722E+00, 1.3374564813E+00, 7.7115338366E-01],
	[1.7260000000E+04, 1.2382268289E+01, 5.7514196693E+00, 2.0301668539E+00, 1.3383277703E+00, 7.7127299527E-01],
	[1.7265000000E+04, 1.2387392724E+01, 5.7512279394E+00, 2.0320586489E+00, 1.3391991506E+00, 7.7139255458E-01],
	[1.7270000000E+04, 1.2392517795E+01, 5.7510362713E+00, 2.0339516576E+00, 1.3400706217E+00, 7.7151206161E-01],
	[1.7275000000E+04, 1.2397643502E+01, 5.7508446651E+00, 2.0358458804E+00, 1.3409421835E+00, 7.7163151636E-01],
	[1.7280000000E+04, 1.2402769844E+01, 5.7506531207E+00, 2.0377413178E+00, 1.3418138355E+00, 7.7175091884E-01],
	[1.7285000000E+04, 1.2407896823E+01, 5.7504616381E+00, 2.0396379702E+00, 1.3426855776E+00, 7.7187026905E-01],
	[1.7290000000E+04, 1.2413024437E+01, 5.7502702173E+00, 2.0415358380E+00, 1.3435574093E+00, 7.7198956701E-01],
	[1.7295000000E+04, 1.2418152686E+01, 5.7500788582E+00, 2.0434349217E+00, 1.3444293304E+00, 7.7210881271E-01],
	[1.7300000000E+04, 1.2423281571E+01, 5.7498875608E+00, 2.0453352216E+00, 1.3453013407E+00, 7.7222800617E-01],
	[1.7305000000E+04, 1.2428411091E+01, 5.7496963250E+00, 2.0472367383E+00, 1.3461734397E+00, 7.7234714739E-01],
	[1.7310000000E+04, 1.2433541246E+01, 5.7495051508E+00, 2.0491394720E+00, 1.3470456272E+00, 7.7246623637E-01],
	[1.7315000000E+04, 1.2438672036E+01, 5.7493140382E+00, 2.0510434233E+00, 1.3479179029E+00, 7.7258527313E-01],
	[1.7320000000E+04, 1.2443803461E+01, 5.7491229871E+00, 2.0529485926E+00, 1.3487902665E+00, 7.7270425766E-01],
	[1.7325000000E+04, 1.2448935521E+01, 5.7489319975E+00, 2.0548549803E+00, 1.3496627176E+00, 7.7282318998E-01],
	[1.7330000000E+04, 1.2454068216E+01, 5.7487410694E+00, 2.0567625868E+00, 1.3505352561E+00, 7.7294207009E-01],
	[1.7335000000E+04, 1.2459201545E+01, 5.7485502027E+00, 2.0586714126E+00, 1.3514078815E+00, 7.7306089800E-01],
	[1.7340000000E+04, 1.2464335509E+01, 5.7483593973E+00, 2.0605814581E+00, 1.3522805936E+00, 7.7317967372E-01],
	[1.7345000000E+04, 1.2469470107E+01, 5.7481686533E+00, 2.0624927237E+00, 1.3531533921E+00, 7.7329839724E-01],
	[1.7350000000E+04, 1.2474605340E+01, 5.7479779706E+00, 2.0644052098E+00, 1.3540262767E+00, 7.7341706859E-01],
	[1.7355000000E+04, 1.2479741207E+01, 5.7477873492E+00, 2.0663189169E+00, 1.3548992470E+00, 7.7353568776E-01],
	[1.7360000000E+04, 1.2484877708E+01, 5.7475967890E+00, 2.0682338454E+00, 1.3557723028E+00, 7.7365425476E-01],
	[1.7365000000E+04, 1.2490014843E+01, 5.7474062900E+00, 2.0701499957E+00, 1.3566454438E+00, 7.7377276960E-01],
	[1.7370000000E+04, 1.2495152612E+01, 5.7472158521E+00, 2.0720673682E+00, 1.3575186697E+00, 7.7389123228E-01],
	[1.7375000000E+04, 1.2500291015E+01, 5.7470254754E+00, 2.0739859634E+00, 1.3583919802E+00, 7.7400964282E-01],
	[1.7380000000E+04, 1.2505449014E+01, 5.7468388989E+00, 2.0759057817E+00, 1.3592658081E+00, 7.7412800121E-01],
	[1.7385000000E+04, 1.2510616154E+01, 5.7466540570E+00, 2.0778268236E+00, 1.3601399151E+00, 7.7424630748E-01],
	[1.7390000000E+04, 1.2515783943E+01, 5.7464692742E+00, 2.0797490894E+00, 1.3610141070E+00, 7.7436456161E-01],
	[1.7395000000E+04, 1.2520952380E+01, 5.7462845505E+00, 2.0816725796E+00, 1.3618883834E+00, 7.7448276362E-01],
	[1.7400000000E+04, 1.2526121464E+01, 5.7460998858E+00, 2.0835972946E+00, 1.3627627441E+00, 7.7460091352E-01],
	[1.7405000000E+04, 1.2531291197E+01, 5.7459152801E+00, 2.0855232348E+00, 1.3636371887E+00, 7.7471901132E-01],
	[1.7410000000E+04, 1.2536461578E+01, 5.7457307334E+00, 2.0874504007E+00, 1.3645117170E+00, 7.7483705701E-01],
	[1.7415000000E+04, 1.2541632606E+01, 5.7455462456E+00, 2.0893787927E+00, 1.3653863287E+00, 7.7495505061E-01],
	[1.7420000000E+04, 1.2546804282E+01, 5.7453618166E+00, 2.0913084112E+00, 1.3662610234E+00, 7.7507299213E-01],
	[1.7425000000E+04, 1.2551976605E+01, 5.7451774465E+00, 2.0932392566E+00, 1.3671358009E+00, 7.7519088157E-01],
	[1.7430000000E+04, 1.2557149576E+01, 5.7449931352E+00, 2.0951713294E+00, 1.3680106608E+00, 7.7530871894E-01],
	[1.7435000000E+04, 1.2562323194E+01, 5.7448088827E+00, 2.0971046300E+00, 1.3688856029E+00, 7.7542650425E-01],
	[1.7440000000E+04, 1.2567497459E+01, 5.7446246889E+00, 2.0990391589E+00, 1.3697606269E+00, 7.7554423750E-01],
	[1.7445000000E+04, 1.2572672371E+01, 5.7444405539E+00, 2.1009749163E+00, 1.3706357324E+00, 7.7566191870E-01],
	[1.7450000000E+04, 1.2577847930E+01, 5.7442564775E+00, 2.1029119029E+00, 1.3715109193E+00, 7.7577954786E-01],
	[1.7455000000E+04, 1.2583024136E+01, 5.7440724597E+00, 2.1048501190E+00, 1.3723861870E+00, 7.7589712499E-01],
	[1.7460000000E+04, 1.2588200989E+01, 5.7438885005E+00, 2.1067895650E+00, 1.3732615355E+00, 7.7601465009E-01],
	[1.7465000000E+04, 1.2593378488E+01, 5.7437045999E+00, 2.1087302414E+00, 1.3741369643E+00, 7.7613212317E-01],
	[1.7470000000E+04, 1.2598556634E+01, 5.7435207578E+00, 2.1106721485E+00, 1.3750124731E+00, 7.7624954424E-01],
	[1.7475000000E+04, 1.2603735427E+01, 5.7433369742E+00, 2.1126152869E+00, 1.3758880618E+00, 7.7636691331E-01],
	[1.7480000000E+04, 1.2608914865E+01, 5.7431532491E+00, 2.1145596569E+00, 1.3767637299E+00, 7.7648423038E-01],
	[1.7485000000E+04, 1.2614094950E+01, 5.7429695824E+00, 2.1165052590E+00, 1.3776394772E+00, 7.7660149546E-01],
	[1.7490000000E+04, 1.2619275681E+01, 5.7427859740E+00, 2.1184520936E+00, 1.3785153034E+00, 7.7671870857E-01],
	[1.7495000000E+04, 1.2624457058E+01, 5.7426024241E+00, 2.1204001611E+00, 1.3793912081E+00, 7.7683586970E-01],
	[1.7500000000E+04, 1.2629639081E+01, 5.7424189324E+00, 2.1223494620E+00, 1.3802671911E+00, 7.7695297886E-01],
	[1.7505000000E+04, 1.2634821750E+01, 5.7422354990E+00, 2.1243145272E+00, 1.3811493944E+00, 7.7707003607E-01],
	[1.7510000000E+04, 1.2640005065E+01, 5.7420521239E+00, 2.1262808493E+00, 1.3820316779E+00, 7.7718704133E-01],
	[1.7515000000E+04, 1.2645189025E+01, 5.7418688069E+00, 2.1282484287E+00, 1.3829140413E+00, 7.7730399464E-01],
	[1.7520000000E+04, 1.2650373631E+01, 5.7416855482E+00, 2.1302172659E+00, 1.3837964844E+00, 7.7742089603E-01],
	[1.7525000000E+04, 1.2655558882E+01, 5.7415023475E+00, 2.1321873614E+00, 1.3846790069E+00, 7.7753774548E-01],
	[1.7530000000E+04, 1.2660744778E+01, 5.7413192050E+00, 2.1341587156E+00, 1.3855616084E+00, 7.7765454302E-01],
	[1.7535000000E+04, 1.2665931319E+01, 5.7411361206E+00, 2.1361313289E+00, 1.3864442886E+00, 7.7777128865E-01],
	[1.7540000000E+04, 1.2671118506E+01, 5.7409530941E+00, 2.1381052017E+00, 1.3873270473E+00, 7.7788798238E-01],
	[1.7545000000E+04, 1.2676306338E+01, 5.7407701257E+00, 2.1400803346E+00, 1.3882098841E+00, 7.7800462421E-01],
	[1.7550000000E+04, 1.2681494814E+01, 5.7405872153E+00, 2.1420567280E+00, 1.3890927987E+00, 7.7812121416E-01],
	[1.7555000000E+04, 1.2686683935E+01, 5.7404043627E+00, 2.1440343823E+00, 1.3899757909E+00, 7.7823775223E-01],
	[1.7560000000E+04, 1.2691873701E+01, 5.7402215681E+00, 2.1460132979E+00, 1.3908588603E+00, 7.7835423843E-01],
	[1.7565000000E+04, 1.2697064112E+01, 5.7400388313E+00, 2.1479934753E+00, 1.3917420066E+00, 7.7847067278E-01],
	[1.7570000000E+04, 1.2702255167E+01, 5.7398561524E+00, 2.1499749150E+00, 1.3926252295E+00, 7.7858705526E-01],
	[1.7575000000E+04, 1.2707446866E+01, 5.7396735312E+00, 2.1519576174E+00, 1.3935085287E+00, 7.7870338591E-01],
	[1.7580000000E+04, 1.2712639209E+01, 5.7394909678E+00, 2.1539415829E+00, 1.3943919039E+00, 7.7881966472E-01],
	[1.7585000000E+04, 1.2717832197E+01, 5.7393084621E+00, 2.1559268119E+00, 1.3952753548E+00, 7.7893589170E-01],
	[1.7590000000E+04, 1.2723025829E+01, 5.7391260141E+00, 2.1579133050E+00, 1.3961588812E+00, 7.7905206686E-01],
	[1.7595000000E+04, 1.2728220105E+01, 5.7389436238E+00, 2.1599010626E+00, 1.3970424826E+00, 7.7916819021E-01],
	[1.7600000000E+04, 1.2733415024E+01, 5.7387612911E+00, 2.1618900850E+00, 1.3979261588E+00, 7.7928426176E-01],
	[1.7605000000E+04, 1.2738610587E+01, 5.7385790159E+00, 2.1638803729E+00, 1.3988099095E+00, 7.7940028151E-01],
	[1.7610000000E+04, 1.2743806794E+01, 5.7383967983E+00, 2.1658719265E+00, 1.3996937343E+00, 7.7951624948E-01],
	[1.7615000000E+04, 1.2749003645E+01, 5.7382146382E+00, 2.1678647463E+00, 1.4005776331E+00, 7.7963216567E-01],
	[1.7620000000E+04, 1.2754201139E+01, 5.7380325356E+00, 2.1698588329E+00, 1.4014616054E+00, 7.7974803010E-01],
	[1.7625000000E+04, 1.2759399276E+01, 5.7378504905E+00, 2.1718541866E+00, 1.4023456510E+00, 7.7986384276E-01],
	[1.7630000000E+04, 1.2764598056E+01, 5.7376685027E+00, 2.1738508079E+00, 1.4032297696E+00, 7.7997960367E-01],
	[1.7635000000E+04, 1.2769797480E+01, 5.7374865723E+00, 2.1758486972E+00, 1.4041139608E+00, 7.8009531285E-01],
	[1.7640000000E+04, 1.2774997546E+01, 5.7373046993E+00, 2.1778478549E+00, 1.4049982244E+00, 7.8021097028E-01],
	[1.7645000000E+04, 1.2780198256E+01, 5.7371228836E+00, 2.1798482816E+00, 1.4058825601E+00, 7.8032657600E-01],
	[1.7650000000E+04, 1.2785399608E+01, 5.7369411251E+00, 2.1818499777E+00, 1.4067669675E+00, 7.8044213000E-01],
	[1.7655000000E+04, 1.2790601603E+01, 5.7367594239E+00, 2.1838529435E+00, 1.4076514464E+00, 7.8055763229E-01],
	[1.7660000000E+04, 1.2795824952E+01, 5.7365817630E+00, 2.1858571796E+00, 1.4085364875E+00, 7.8067308288E-01],
	[1.7665000000E+04, 1.2801056125E+01, 5.7364055364E+00, 2.1878626864E+00, 1.4094217706E+00, 7.8078848179E-01],
	[1.7670000000E+04, 1.2806287956E+01, 5.7362293652E+00, 2.1898694643E+00, 1.4103071254E+00, 7.8090382901E-01],
	[1.7675000000E+04, 1.2811520444E+01, 5.7360532492E+00, 2.1918775138E+00, 1.4111925517E+00, 7.8101912456E-01],
	[1.7680000000E+04, 1.2816753588E+01, 5.7358771884E+00, 2.1938868354E+00, 1.4120780491E+00, 7.8113436846E-01],
	[1.7685000000E+04, 1.2821987390E+01, 5.7357011828E+00, 2.1958974294E+00, 1.4129636175E+00, 7.8124956069E-01],
	[1.7690000000E+04, 1.2827221849E+01, 5.7355252323E+00, 2.1979092963E+00, 1.4138492563E+00, 7.8136470129E-01],
	[1.7695000000E+04, 1.2832456964E+01, 5.7353493370E+00, 2.1999224366E+00, 1.4147349655E+00, 7.8147979025E-01],
	[1.7700000000E+04, 1.2837692736E+01, 5.7351734967E+00, 2.2019368508E+00, 1.4156207446E+00, 7.8159482758E-01],
	[1.7705000000E+04, 1.2842929164E+01, 5.7349977116E+00, 2.2039525391E+00, 1.4165065933E+00, 7.8170981330E-01],
	[1.7710000000E+04, 1.2848166249E+01, 5.7348219814E+00, 2.2059695022E+00, 1.4173925115E+00, 7.8182474741E-01],
	[1.7715000000E+04, 1.2853403991E+01, 5.7346463062E+00, 2.2079877404E+00, 1.4182784987E+00, 7.8193962992E-01],
	[1.7720000000E+04, 1.2858642388E+01, 5.7344706860E+00, 2.2100072542E+00, 1.4191645546E+00, 7.8205446084E-01],
	[1.7725000000E+04, 1.2863881441E+01, 5.7342951207E+00, 2.2120280441E+00, 1.4200506790E+00, 7.8216924019E-01],
	[1.7730000000E+04, 1.2869121151E+01, 5.7341196103E+00, 2.2140501104E+00, 1.4209368715E+00, 7.8228396796E-01],
	[1.7735000000E+04, 1.2874361516E+01, 5.7339441547E+00, 2.2160734537E+00, 1.4218231320E+00, 7.8239864417E-01],
	[1.7740000000E+04, 1.2879602537E+01, 5.7337687540E+00, 2.2180980743E+00, 1.4227094599E+00, 7.8251326884E-01],
	[1.7745000000E+04, 1.2884844214E+01, 5.7335934080E+00, 2.2201239728E+00, 1.4235958551E+00, 7.8262784196E-01],
	[1.7750000000E+04, 1.2890086547E+01, 5.7334181169E+00, 2.2221511495E+00, 1.4244823173E+00, 7.8274236354E-01],
	[1.7755000000E+04, 1.2895329535E+01, 5.7332428804E+00, 2.2241796049E+00, 1.4253688461E+00, 7.8285683361E-01],
	[1.7760000000E+04, 1.2900573178E+01, 5.7330676987E+00, 2.2262093395E+00, 1.4262554413E+00, 7.8297125216E-01],
	[1.7765000000E+04, 1.2905817477E+01, 5.7328925716E+00, 2.2282403537E+00, 1.4271421025E+00, 7.8308561921E-01],
	[1.7770000000E+04, 1.2911062431E+01, 5.7327174991E+00, 2.2302726479E+00, 1.4280288295E+00, 7.8319993476E-01],
	[1.7775000000E+04, 1.2916308040E+01, 5.7325424813E+00, 2.2323062227E+00, 1.4289156220E+00, 7.8331419883E-01],
	[1.7780000000E+04, 1.2921554304E+01, 5.7323675180E+00, 2.2343410783E+00, 1.4298024796E+00, 7.8342841143E-01],
	[1.7785000000E+04, 1.2926801222E+01, 5.7321926092E+00, 2.2363772154E+00, 1.4306894020E+00, 7.8354257256E-01],
	[1.7790000000E+04, 1.2932048796E+01, 5.7320177549E+00, 2.2384146343E+00, 1.4315763890E+00, 7.8365668224E-01],
	[1.7795000000E+04, 1.2937297024E+01, 5.7318429551E+00, 2.2404533355E+00, 1.4324634403E+00, 7.8377074046E-01],
	[1.7800000000E+04, 1.2942545907E+01, 5.7316682098E+00, 2.2424933193E+00, 1.4333505555E+00, 7.8388474726E-01],
	[1.7805000000E+04, 1.2947795444E+01, 5.7314935188E+00, 2.2445345864E+00, 1.4342377343E+00, 7.8399870263E-01],
	[1.7810000000E+04, 1.2953045636E+01, 5.7313188822E+00, 2.2465771371E+00, 1.4351249766E+00, 7.8411260658E-01],
	[1.7815000000E+04, 1.2958296482E+01, 5.7311443000E+00, 2.2486209718E+00, 1.4360122818E+00, 7.8422645913E-01],
	[1.7820000000E+04, 1.2963547982E+01, 5.7309697721E+00, 2.2506660910E+00, 1.4368996499E+00, 7.8434026025E-01],
	[1.7825000000E+04, 1.2968800136E+01, 5.7307952984E+00, 2.2527124952E+00, 1.4377870804E+00, 7.8445400990E-01],
	[1.7830000000E+04, 1.2974052944E+01, 5.7306208790E+00, 2.2547601848E+00, 1.4386745730E+00, 7.8456770810E-01],
	[1.7835000000E+04, 1.2979306406E+01, 5.7304465138E+00, 2.2568091602E+00, 1.4395621276E+00, 7.8468135486E-01],
	[1.7840000000E+04, 1.2984560521E+01, 5.7302722028E+00, 2.2588594220E+00, 1.4404497436E+00, 7.8479495016E-01],
	[1.7845000000E+04, 1.2989815291E+01, 5.7300979459E+00, 2.2609109704E+00, 1.4413374210E+00, 7.8490849404E-01],
	[1.7850000000E+04, 1.2995070713E+01, 5.7299237431E+00, 2.2629638061E+00, 1.4422251593E+00, 7.8502198648E-01],
	[1.7855000000E+04, 1.3000326790E+01, 5.7297495944E+00, 2.2650179293E+00, 1.4431129583E+00, 7.8513542751E-01],
	[1.7860000000E+04, 1.3005583519E+01, 5.7295754998E+00, 2.2670733407E+00, 1.4440008176E+00, 7.8524881712E-01],
	[1.7865000000E+04, 1.3010840902E+01, 5.7294014592E+00, 2.2691300405E+00, 1.4448887370E+00, 7.8536215533E-01],
	[1.7870000000E+04, 1.3016098938E+01, 5.7292274726E+00, 2.2711880294E+00, 1.4457767162E+00, 7.8547544214E-01],
	[1.7875000000E+04, 1.3021357627E+01, 5.7290535399E+00, 2.2732473076E+00, 1.4466647549E+00, 7.8558867756E-01],
	[1.7880000000E+04, 1.3026616969E+01, 5.7288796612E+00, 2.2753078757E+00, 1.4475528527E+00, 7.8570186160E-01],
	[1.7885000000E+04, 1.3031876964E+01, 5.7287058363E+00, 2.2773697342E+00, 1.4484410094E+00, 7.8581499427E-01],
	[1.7890000000E+04, 1.3037137612E+01, 5.7285320653E+00, 2.2794328833E+00, 1.4493292247E+00, 7.8592807556E-01],
	[1.7895000000E+04, 1.3042398912E+01, 5.7283583482E+00, 2.2814973237E+00, 1.4502174983E+00, 7.8604110550E-01],
	[1.7900000000E+04, 1.3047660865E+01, 5.7281846848E+00, 2.2835630557E+00, 1.4511058298E+00, 7.8615408409E-01],
	[1.7905000000E+04, 1.3052923470E+01, 5.7280110752E+00, 2.2856300798E+00, 1.4519942191E+00, 7.8626701133E-01],
	[1.7910000000E+04, 1.3058186727E+01, 5.7278375194E+00, 2.2876983965E+00, 1.4528826657E+00, 7.8637988724E-01],
	[1.7915000000E+04, 1.3063450637E+01, 5.7276640172E+00, 2.2897680061E+00, 1.4537711694E+00, 7.8649271182E-01],
	[1.7920000000E+04, 1.3068715199E+01, 5.7274905687E+00, 2.2918389092E+00, 1.4546597299E+00, 7.8660548508E-01],
	[1.7925000000E+04, 1.3073980413E+01, 5.7273171738E+00, 2.2939111061E+00, 1.4555483469E+00, 7.8671820703E-01],
	[1.7930000000E+04, 1.3079246279E+01, 5.7271438326E+00, 2.2959845974E+00, 1.4564370202E+00, 7.8683087768E-01],
	[1.7935000000E+04, 1.3084512796E+01, 5.7269705449E+00, 2.2980593834E+00, 1.4573257493E+00, 7.8694349703E-01],
	[1.7940000000E+04, 1.3089779966E+01, 5.7267973108E+00, 2.3001354647E+00, 1.4582145340E+00, 7.8705606509E-01],
	[1.7945000000E+04, 1.3095072975E+01, 5.7266288772E+00, 2.3022128416E+00, 1.4591039949E+00, 7.8716858188E-01],
	[1.7950000000E+04, 1.3100369623E+01, 5.7264610558E+00, 2.3042915146E+00, 1.4599935853E+00, 7.8728104739E-01],
	[1.7955000000E+04, 1.3105666937E+01, 5.7262932860E+00, 2.3063714842E+00, 1.4608832317E+00, 7.8739346164E-01],
	[1.7960000000E+04, 1.3110964918E+01, 5.7261255679E+00, 2.3084527508E+00, 1.4617729337E+00, 7.8750582464E-01],
	[1.7965000000E+04, 1.3116263564E+01, 5.7259579013E+00, 2.3105353149E+00, 1.4626626911E+00, 7.8761813639E-01],
	[1.7970000000E+04, 1.3121562877E+01, 5.7257902863E+00, 2.3126191768E+00, 1.4635525035E+00, 7.8773039690E-01],
	[1.7975000000E+04, 1.3126862855E+01, 5.7256227229E+00, 2.3147043371E+00, 1.4644423708E+00, 7.8784260618E-01],
	[1.7980000000E+04, 1.3132163500E+01, 5.7254552109E+00, 2.3167907962E+00, 1.4653322924E+00, 7.8795476424E-01],
	[1.7985000000E+04, 1.3137464810E+01, 5.7252877505E+00, 2.3188785545E+00, 1.4662222683E+00, 7.8806687109E-01],
	[1.7990000000E+04, 1.3142766785E+01, 5.7251203414E+00, 2.3209676125E+00, 1.4671122981E+00, 7.8817892673E-01],
	[1.7995000000E+04, 1.3148069426E+01, 5.7249529838E+00, 2.3230579707E+00, 1.4680023814E+00, 7.8829093118E-01],
	[1.8000000000E+04, 1.3153372733E+01, 5.7247856776E+00, 2.3251496294E+00, 1.4688925181E+00, 7.8840288444E-01],
	[1.8005000000E+04, 1.3158676704E+01, 5.7246184227E+00, 2.3272425892E+00, 1.4697827077E+00, 7.8851478652E-01],
	[1.8010000000E+04, 1.3163981341E+01, 5.7244512192E+00, 2.3293368504E+00, 1.4706729501E+00, 7.8862663743E-01],
	[1.8015000000E+04, 1.3169286643E+01, 5.7242840669E+00, 2.3314324136E+00, 1.4715632448E+00, 7.8873843718E-01],
	[1.8020000000E+04, 1.3174592610E+01, 5.7241169659E+00, 2.3335292791E+00, 1.4724535917E+00, 7.8885018578E-01],
	[1.8025000000E+04, 1.3179899242E+01, 5.7239499162E+00, 2.3356274475E+00, 1.4733439904E+00, 7.8896188323E-01],
	[1.8030000000E+04, 1.3185206538E+01, 5.7237829176E+00, 2.3377269191E+00, 1.4742344406E+00, 7.8907352955E-01],
	[1.8035000000E+04, 1.3190514500E+01, 5.7236159703E+00, 2.3398276944E+00, 1.4751249420E+00, 7.8918512474E-01],
	[1.8040000000E+04, 1.3195823125E+01, 5.7234490740E+00, 2.3419297739E+00, 1.4760154944E+00, 7.8929666882E-01],
	[1.8045000000E+04, 1.3201132416E+01, 5.7232822289E+00, 2.3440331579E+00, 1.4769060974E+00, 7.8940816178E-01],
	[1.8050000000E+04, 1.3206442370E+01, 5.7231154349E+00, 2.3461378471E+00, 1.4777967508E+00, 7.8951960365E-01],
	[1.8055000000E+04, 1.3211752989E+01, 5.7229486919E+00, 2.3482438417E+00, 1.4786874542E+00, 7.8963099442E-01],
	[1.8060000000E+04, 1.3217064272E+01, 5.7227820000E+00, 2.3503511423E+00, 1.4795782074E+00, 7.8974233411E-01],
	[1.8065000000E+04, 1.3222376219E+01, 5.7226153590E+00, 2.3524597493E+00, 1.4804690101E+00, 7.8985362273E-01],
	[1.8070000000E+04, 1.3227688830E+01, 5.7224487691E+00, 2.3545696631E+00, 1.4813598619E+00, 7.8996486029E-01],
	[1.8075000000E+04, 1.3233002105E+01, 5.7222822300E+00, 2.3566808842E+00, 1.4822507626E+00, 7.9007604679E-01],
	[1.8080000000E+04, 1.3238316044E+01, 5.7221157419E+00, 2.3587934131E+00, 1.4831417119E+00, 7.9018718224E-01],
	[1.8085000000E+04, 1.3243630646E+01, 5.7219493046E+00, 2.3609072501E+00, 1.4840327094E+00, 7.9029826666E-01],
	[1.8090000000E+04, 1.3248945912E+01, 5.7217829182E+00, 2.3630223958E+00, 1.4849237550E+00, 7.9040930005E-01],
	[1.8095000000E+04, 1.3254261841E+01, 5.7216165826E+00, 2.3651388505E+00, 1.4858148483E+00, 7.9052028243E-01],
	[1.8100000000E+04, 1.3259578434E+01, 5.7214502978E+00, 2.3672566148E+00, 1.4867059890E+00, 7.9063121379E-01],
	[1.8105000000E+04, 1.3264895690E+01, 5.7212840638E+00, 2.3693756890E+00, 1.4875971768E+00, 7.9074209416E-01],
	[1.8110000000E+04, 1.3270213609E+01, 5.7211178805E+00, 2.3714960737E+00, 1.4884884114E+00, 7.9085292353E-01],
	[1.8115000000E+04, 1.3275532191E+01, 5.7209517478E+00, 2.3736177693E+00, 1.4893796926E+00, 7.9096370192E-01],
	[1.8120000000E+04, 1.3280851436E+01, 5.7207856659E+00, 2.3757407761E+00, 1.4902710200E+00, 7.9107442934E-01],
	[1.8125000000E+04, 1.3286171344E+01, 5.7206196346E+00, 2.3778650948E+00, 1.4911623934E+00, 7.9118510580E-01],
	[1.8130000000E+04, 1.3291491915E+01, 5.7204536539E+00, 2.3799907256E+00, 1.4920538124E+00, 7.9129573131E-01],
	[1.8135000000E+04, 1.3296813149E+01, 5.7202877238E+00, 2.3821176691E+00, 1.4929452768E+00, 7.9140630588E-01],
	[1.8140000000E+04, 1.3302135044E+01, 5.7201218442E+00, 2.3842459257E+00, 1.4938367862E+00, 7.9151682951E-01],
	[1.8145000000E+04, 1.3307457603E+01, 5.7199560152E+00, 2.3863754959E+00, 1.4947283405E+00, 7.9162730221E-01],
	[1.8150000000E+04, 1.3312780824E+01, 5.7197902367E+00, 2.3885063801E+00, 1.4956199392E+00, 7.9173772400E-01],
	[1.8155000000E+04, 1.3318104707E+01, 5.7196245086E+00, 2.3906385787E+00, 1.4965115821E+00, 7.9184809489E-01],
	[1.8160000000E+04, 1.3323429252E+01, 5.7194588310E+00, 2.3927720922E+00, 1.4974032689E+00, 7.9195841488E-01],
	[1.8165000000E+04, 1.3328754459E+01, 5.7192932037E+00, 2.3949069211E+00, 1.4982949993E+00, 7.9206868399E-01],
	[1.8170000000E+04, 1.3334080328E+01, 5.7191276269E+00, 2.3970430658E+00, 1.4991867731E+00, 7.9217890222E-01],
	[1.8175000000E+04, 1.3339406859E+01, 5.7189621004E+00, 2.3991805267E+00, 1.5000785898E+00, 7.9228906958E-01],
	[1.8180000000E+04, 1.3344734052E+01, 5.7187966242E+00, 2.4013193043E+00, 1.5009704493E+00, 7.9239918609E-01],
	[1.8185000000E+04, 1.3350061906E+01, 5.7186311983E+00, 2.4034593991E+00, 1.5018623513E+00, 7.9250925175E-01],
	[1.8190000000E+04, 1.3355390422E+01, 5.7184658227E+00, 2.4056008115E+00, 1.5027542954E+00, 7.9261926657E-01],
	[1.8195000000E+04, 1.3360719600E+01, 5.7183004973E+00, 2.4077435418E+00, 1.5036462814E+00, 7.9272923057E-01],
	[1.8200000000E+04, 1.3366049438E+01, 5.7181352221E+00, 2.4098875907E+00, 1.5045383089E+00, 7.9283914375E-01],
	[1.8205000000E+04, 1.3371379939E+01, 5.7179699971E+00, 2.4120329585E+00, 1.5054303777E+00, 7.9294900613E-01],
	[1.8210000000E+04, 1.3376711100E+01, 5.7178048222E+00, 2.4141796457E+00, 1.5063224876E+00, 7.9305881771E-01],
	[1.8215000000E+04, 1.3382042922E+01, 5.7176396975E+00, 2.4163276527E+00, 1.5072146381E+00, 7.9316857850E-01],
	[1.8220000000E+04, 1.3387375405E+01, 5.7174746228E+00, 2.4184769800E+00, 1.5081068290E+00, 7.9327828851E-01],
	[1.8225000000E+04, 1.3392708549E+01, 5.7173095982E+00, 2.4206276281E+00, 1.5089990600E+00, 7.9338794776E-01],
	[1.8230000000E+04, 1.3398046074E+01, 5.7171453108E+00, 2.4227795973E+00, 1.5098914261E+00, 7.9349755625E-01],
	[1.8235000000E+04, 1.3403408985E+01, 5.7169856394E+00, 2.4249328881E+00, 1.5107844648E+00, 7.9360711400E-01],
	[1.8240000000E+04, 1.3408772571E+01, 5.7168260162E+00, 2.4270875010E+00, 1.5116775441E+00, 7.9371662101E-01],
	[1.8245000000E+04, 1.3414136833E+01, 5.7166664413E+00, 2.4292434364E+00, 1.5125706635E+00, 7.9382607729E-01],
	[1.8250000000E+04, 1.3419501770E+01, 5.7165069145E+00, 2.4314006948E+00, 1.5134638229E+00, 7.9393548286E-01],
	[1.8255000000E+04, 1.3424867382E+01, 5.7163474358E+00, 2.4335592766E+00, 1.5143570219E+00, 7.9404483772E-01],
	[1.8260000000E+04, 1.3430233669E+01, 5.7161880053E+00, 2.4357191823E+00, 1.5152502603E+00, 7.9415414188E-01],
	[1.8265000000E+04, 1.3435600631E+01, 5.7160286229E+00, 2.4378804123E+00, 1.5161435377E+00, 7.9426339537E-01],
	[1.8270000000E+04, 1.3440968268E+01, 5.7158692885E+00, 2.4400429671E+00, 1.5170368539E+00, 7.9437259817E-01],
	[1.8275000000E+04, 1.3446336580E+01, 5.7157100022E+00, 2.4422068470E+00, 1.5179302086E+00, 7.9448175032E-01],
	[1.8280000000E+04, 1.3451705567E+01, 5.7155507638E+00, 2.4443720527E+00, 1.5188236014E+00, 7.9459085181E-01],
	[1.8285000000E+04, 1.3457075228E+01, 5.7153915735E+00, 2.4465385844E+00, 1.5197170322E+00, 7.9469990266E-01],
	[1.8290000000E+04, 1.3462445563E+01, 5.7152324311E+00, 2.4487064427E+00, 1.5206105005E+00, 7.9480890287E-01],
	[1.8295000000E+04, 1.3467816573E+01, 5.7150733367E+00, 2.4508756280E+00, 1.5215040062E+00, 7.9491785246E-01],
	[1.8300000000E+04, 1.3473188257E+01, 5.7149142901E+00, 2.4530461408E+00, 1.5223975490E+00, 7.9502675144E-01],
	[1.8305000000E+04, 1.3478560616E+01, 5.7147552915E+00, 2.4552179814E+00, 1.5232911284E+00, 7.9513559983E-01],
	[1.8310000000E+04, 1.3483933648E+01, 5.7145963406E+00, 2.4573911504E+00, 1.5241847444E+00, 7.9524439762E-01],
	[1.8315000000E+04, 1.3489307354E+01, 5.7144374376E+00, 2.4595656483E+00, 1.5250783965E+00, 7.9535314483E-01],
	[1.8320000000E+04, 1.3494681735E+01, 5.7142785824E+00, 2.4617414753E+00, 1.5259720845E+00, 7.9546184147E-01],
	[1.8325000000E+04, 1.3500056789E+01, 5.7141197750E+00, 2.4639186321E+00, 1.5268658081E+00, 7.9557048755E-01],
	[1.8330000000E+04, 1.3505432516E+01, 5.7139610153E+00, 2.4660971190E+00, 1.5277595670E+00, 7.9567908309E-01],
	[1.8335000000E+04, 1.3510808917E+01, 5.7138023033E+00, 2.4682769366E+00, 1.5286533609E+00, 7.9578762809E-01],
	[1.8340000000E+04, 1.3516185992E+01, 5.7136436389E+00, 2.4704580851E+00, 1.5295471896E+00, 7.9589612257E-01],
	[1.8345000000E+04, 1.3521563740E+01, 5.7134850223E+00, 2.4726405652E+00, 1.5304410527E+00, 7.9600456653E-01],
	[1.8350000000E+04, 1.3526942161E+01, 5.7133264532E+00, 2.4748243772E+00, 1.5313349499E+00, 7.9611295998E-01],
	[1.8355000000E+04, 1.3532321256E+01, 5.7131679318E+00, 2.4770095216E+00, 1.5322288811E+00, 7.9622130295E-01],
	[1.8360000000E+04, 1.3537701023E+01, 5.7130094579E+00, 2.4791959988E+00, 1.5331228458E+00, 7.9632959543E-01],
	[1.8365000000E+04, 1.3543081464E+01, 5.7128510316E+00, 2.4813838094E+00, 1.5340168438E+00, 7.9643783744E-01],
	[1.8370000000E+04, 1.3548462577E+01, 5.7126926528E+00, 2.4835729537E+00, 1.5349108749E+00, 7.9654602899E-01],
	[1.8375000000E+04, 1.3553844363E+01, 5.7125343215E+00, 2.4857634321E+00, 1.5358049387E+00, 7.9665417009E-01],
	[1.8380000000E+04, 1.3559226822E+01, 5.7123760376E+00, 2.4879552453E+00, 1.5366990349E+00, 7.9676226075E-01],
	[1.8385000000E+04, 1.3564609954E+01, 5.7122178012E+00, 2.4901483935E+00, 1.5375931632E+00, 7.9687030098E-01],
	[1.8390000000E+04, 1.3569993758E+01, 5.7120596122E+00, 2.4923428772E+00, 1.5384873235E+00, 7.9697829080E-01],
	[1.8395000000E+04, 1.3575378234E+01, 5.7119014706E+00, 2.4945386969E+00, 1.5393815153E+00, 7.9708623022E-01],
	[1.8400000000E+04, 1.3580763382E+01, 5.7117433763E+00, 2.4967358531E+00, 1.5402757384E+00, 7.9719411924E-01],
	[1.8405000000E+04, 1.3586149203E+01, 5.7115853294E+00, 2.4989343461E+00, 1.5411699925E+00, 7.9730195788E-01],
	[1.8410000000E+04, 1.3591535696E+01, 5.7114273297E+00, 2.5011341765E+00, 1.5420642774E+00, 7.9740974615E-01],
	[1.8415000000E+04, 1.3596922861E+01, 5.7112693774E+00, 2.5033353447E+00, 1.5429585927E+00, 7.9751748406E-01],
	[1.8420000000E+04, 1.3602310697E+01, 5.7111114723E+00, 2.5055378511E+00, 1.5438529381E+00, 7.9762517162E-01],
	[1.8425000000E+04, 1.3607699206E+01, 5.7109536144E+00, 2.5077416962E+00, 1.5447473134E+00, 7.9773280884E-01],
	[1.8430000000E+04, 1.3613088386E+01, 5.7107958037E+00, 2.5099468804E+00, 1.5456417183E+00, 7.9784039574E-01],
	[1.8435000000E+04, 1.3618478238E+01, 5.7106380401E+00, 2.5121534042E+00, 1.5465361525E+00, 7.9794793233E-01],
	[1.8440000000E+04, 1.3623868761E+01, 5.7104803237E+00, 2.5143612681E+00, 1.5474306157E+00, 7.9805541861E-01],
	[1.8445000000E+04, 1.3629259955E+01, 5.7103226545E+00, 2.5165704724E+00, 1.5483251077E+00, 7.9816285460E-01],
	[1.8450000000E+04, 1.3634651821E+01, 5.7101650323E+00, 2.5187810177E+00, 1.5492196281E+00, 7.9827024031E-01],
	[1.8455000000E+04, 1.3640044358E+01, 5.7100074571E+00, 2.5209929043E+00, 1.5501141766E+00, 7.9837757575E-01],
	[1.8460000000E+04, 1.3645437567E+01, 5.7098499290E+00, 2.5232061328E+00, 1.5510087531E+00, 7.9848486093E-01],
	[1.8465000000E+04, 1.3650831446E+01, 5.7096924479E+00, 2.5254207035E+00, 1.5519033571E+00, 7.9859209587E-01],
	[1.8470000000E+04, 1.3656225996E+01, 5.7095350138E+00, 2.5276366170E+00, 1.5527979884E+00, 7.9869928058E-01],
	[1.8475000000E+04, 1.3661621217E+01, 5.7093776267E+00, 2.5298538737E+00, 1.5536926467E+00, 7.9880641506E-01],
	[1.8480000000E+04, 1.3667017108E+01, 5.7092202864E+00, 2.5320724740E+00, 1.5545873318E+00, 7.9891349933E-01],
	[1.8485000000E+04, 1.3672413671E+01, 5.7090629931E+00, 2.5342924184E+00, 1.5554820434E+00, 7.9902053341E-01],
	[1.8490000000E+04, 1.3677810903E+01, 5.7089057466E+00, 2.5365137073E+00, 1.5563767811E+00, 7.9912751729E-01],
	[1.8495000000E+04, 1.3683208806E+01, 5.7087485470E+00, 2.5387363412E+00, 1.5572715447E+00, 7.9923445101E-01],
	[1.8500000000E+04, 1.3688607380E+01, 5.7085913942E+00, 2.5409603205E+00, 1.5581663339E+00, 7.9934133455E-01],
	[1.8505000000E+04, 1.3694006624E+01, 5.7084342882E+00, 2.5431856457E+00, 1.5590611484E+00, 7.9944816795E-01],
	[1.8510000000E+04, 1.3699406537E+01, 5.7082772289E+00, 2.5454123172E+00, 1.5599559880E+00, 7.9955495121E-01],
	[1.8515000000E+04, 1.3704807121E+01, 5.7081202164E+00, 2.5476403355E+00, 1.5608508523E+00, 7.9966168434E-01],
	[1.8520000000E+04, 1.3710208375E+01, 5.7079632506E+00, 2.5498697011E+00, 1.5617457411E+00, 7.9976836735E-01],
	[1.8525000000E+04, 1.3715622860E+01, 5.7078086056E+00, 2.5521004143E+00, 1.5626409876E+00, 7.9987500026E-01],
	[1.8530000000E+04, 1.3721054190E+01, 5.7076569324E+00, 2.5543324756E+00, 1.5635366881E+00, 7.9998158307E-01],
	[1.8535000000E+04, 1.3726486205E+01, 5.7075053042E+00, 2.5565658856E+00, 1.5644324134E+00, 8.0008811581E-01],
	[1.8540000000E+04, 1.3731918905E+01, 5.7073537209E+00, 2.5588006445E+00, 1.5653281634E+00, 8.0019459848E-01],
	[1.8545000000E+04, 1.3737352289E+01, 5.7072021825E+00, 2.5610367530E+00, 1.5662239377E+00, 8.0030103109E-01],
	[1.8550000000E+04, 1.3742786357E+01, 5.7070506890E+00, 2.5632742113E+00, 1.5671197361E+00, 8.0040741366E-01],
	[1.8555000000E+04, 1.3748221110E+01, 5.7068992404E+00, 2.5655130201E+00, 1.5680155582E+00, 8.0051374619E-01],
	[1.8560000000E+04, 1.3753656546E+01, 5.7067478365E+00, 2.5677531797E+00, 1.5689114038E+00, 8.0062002871E-01],
	[1.8565000000E+04, 1.3759092667E+01, 5.7065964775E+00, 2.5699946905E+00, 1.5698072726E+00, 8.0072626121E-01],
	[1.8570000000E+04, 1.3764529471E+01, 5.7064451632E+00, 2.5722375531E+00, 1.5707031644E+00, 8.0083244373E-01],
	[1.8575000000E+04, 1.3769966959E+01, 5.7062938937E+00, 2.5744817679E+00, 1.5715990788E+00, 8.0093857625E-01],
	[1.8580000000E+04, 1.3775405131E+01, 5.7061426689E+00, 2.5767273353E+00, 1.5724950155E+00, 8.0104465881E-01],
	[1.8585000000E+04, 1.3780843987E+01, 5.7059914888E+00, 2.5789742558E+00, 1.5733909743E+00, 8.0115069141E-01],
	[1.8590000000E+04, 1.3786283525E+01, 5.7058403533E+00, 2.5812225298E+00, 1.5742869549E+00, 8.0125667406E-01],
	[1.8595000000E+04, 1.3791723748E+01, 5.7056892625E+00, 2.5834721579E+00, 1.5751829571E+00, 8.0136260678E-01],
	[1.8600000000E+04, 1.3797164653E+01, 5.7055382164E+00, 2.5857231403E+00, 1.5760789804E+00, 8.0146848957E-01],
	[1.8605000000E+04, 1.3802606242E+01, 5.7053872148E+00, 2.5879754776E+00, 1.5769750248E+00, 8.0157432245E-01],
	[1.8610000000E+04, 1.3808048514E+01, 5.7052362578E+00, 2.5902291703E+00, 1.5778710898E+00, 8.0168010544E-01],
	[1.8615000000E+04, 1.3813491469E+01, 5.7050853453E+00, 2.5924842188E+00, 1.5787671752E+00, 8.0178583854E-01],
	[1.8620000000E+04, 1.3818935106E+01, 5.7049344774E+00, 2.5947406234E+00, 1.5796632807E+00, 8.0189152177E-01],
	[1.8625000000E+04, 1.3824379427E+01, 5.7047836540E+00, 2.5969983848E+00, 1.5805594061E+00, 8.0199715514E-01],
	[1.8630000000E+04, 1.3829824430E+01, 5.7046328750E+00, 2.5992575033E+00, 1.5814555510E+00, 8.0210273867E-01],
	[1.8635000000E+04, 1.3835270116E+01, 5.7044821405E+00, 2.6015179794E+00, 1.5823517152E+00, 8.0220827235E-01],
	[1.8640000000E+04, 1.3840716484E+01, 5.7043314503E+00, 2.6037798136E+00, 1.5832478984E+00, 8.0231375622E-01],
	[1.8645000000E+04, 1.3846163535E+01, 5.7041808046E+00, 2.6060430062E+00, 1.5841441004E+00, 8.0241919027E-01],
	[1.8650000000E+04, 1.3851611268E+01, 5.7040302033E+00, 2.6083075578E+00, 1.5850403207E+00, 8.0252457453E-01],
	[1.8655000000E+04, 1.3857059683E+01, 5.7038796463E+00, 2.6105734687E+00, 1.5859365592E+00, 8.0262990900E-01],
	[1.8660000000E+04, 1.3862508780E+01, 5.7037291336E+00, 2.6128407395E+00, 1.5868328157E+00, 8.0273519370E-01],
	[1.8665000000E+04, 1.3867958560E+01, 5.7035786652E+00, 2.6151093706E+00, 1.5877290897E+00, 8.0284042864E-01],
	[1.8670000000E+04, 1.3873409021E+01, 5.7034282411E+00, 2.6173793625E+00, 1.5886253810E+00, 8.0294561384E-01],
	[1.8675000000E+04, 1.3878860164E+01, 5.7032778612E+00, 2.6196507155E+00, 1.5895216894E+00, 8.0305074930E-01],
	[1.8680000000E+04, 1.3884311989E+01, 5.7031275256E+00, 2.6219234302E+00, 1.5904180145E+00, 8.0315583504E-01],
	[1.8685000000E+04, 1.3889764495E+01, 5.7029772341E+00, 2.6241975070E+00, 1.5913143562E+00, 8.0326087107E-01],
	[1.8690000000E+04, 1.3895217683E+01, 5.7028269868E+00, 2.6264729463E+00, 1.5922107141E+00, 8.0336585740E-01],
	[1.8695000000E+04, 1.3900671553E+01, 5.7026767837E+00, 2.6287497486E+00, 1.5931070878E+00, 8.0347079406E-01],
	[1.8700000000E+04, 1.3906126104E+01, 5.7025266247E+00, 2.6310279144E+00, 1.5940034773E+00, 8.0357568104E-01],
	[1.8705000000E+04, 1.3911581336E+01, 5.7023765098E+00, 2.6333074441E+00, 1.5948998821E+00, 8.0368051837E-01],
	[1.8710000000E+04, 1.3917037249E+01, 5.7022264389E+00, 2.6355883381E+00, 1.5957963021E+00, 8.0378530605E-01],
	[1.8715000000E+04, 1.3922493843E+01, 5.7020764121E+00, 2.6378705970E+00, 1.5966927368E+00, 8.0389004410E-01],
	[1.8720000000E+04, 1.3927951118E+01, 5.7019264293E+00, 2.6401542211E+00, 1.5975891861E+00, 8.0399473253E-01],
	[1.8725000000E+04, 1.3933409074E+01, 5.7017764906E+00, 2.6424392108E+00, 1.5984856497E+00, 8.0409937136E-01],
	[1.8730000000E+04, 1.3938867711E+01, 5.7016265958E+00, 2.6447255668E+00, 1.5993821273E+00, 8.0420396059E-01],
	[1.8735000000E+04, 1.3944327028E+01, 5.7014767449E+00, 2.6470132894E+00, 1.6002786185E+00, 8.0430850025E-01],
	[1.8740000000E+04, 1.3949787026E+01, 5.7013269380E+00, 2.6493023790E+00, 1.6011751233E+00, 8.0441299034E-01],
	[1.8745000000E+04, 1.3955247704E+01, 5.7011771749E+00, 2.6515928361E+00, 1.6020716411E+00, 8.0451743087E-01],
	[1.8750000000E+04, 1.3960709063E+01, 5.7010274558E+00, 2.6538846612E+00, 1.6029681719E+00, 8.0462182187E-01],
	[1.8755000000E+04, 1.3966171102E+01, 5.7008777804E+00, 2.6561778547E+00, 1.6038647153E+00, 8.0472616334E-01],
	[1.8760000000E+04, 1.3971633821E+01, 5.7007281490E+00, 2.6584724171E+00, 1.6047612710E+00, 8.0483045529E-01],
	[1.8765000000E+04, 1.3977097221E+01, 5.7005785613E+00, 2.6607683487E+00, 1.6056578388E+00, 8.0493469775E-01],
	[1.8770000000E+04, 1.3982561300E+01, 5.7004290174E+00, 2.6630656502E+00, 1.6065544183E+00, 8.0503889072E-01],
	[1.8775000000E+04, 1.3988026059E+01, 5.7002795172E+00, 2.6653643219E+00, 1.6074510094E+00, 8.0514303421E-01],
	[1.8780000000E+04, 1.3993491498E+01, 5.7001300608E+00, 2.6676643642E+00, 1.6083476117E+00, 8.0524712825E-01],
	[1.8785000000E+04, 1.3998957617E+01, 5.6999806480E+00, 2.6699657777E+00, 1.6092442249E+00, 8.0535117283E-01],
	[1.8790000000E+04, 1.4004424415E+01, 5.6998312790E+00, 2.6722685627E+00, 1.6101408488E+00, 8.0545516798E-01],
	[1.8795000000E+04, 1.4009891892E+01, 5.6996819536E+00, 2.6745727198E+00, 1.6110374832E+00, 8.0555911372E-01],
	[1.8800000000E+04, 1.4015360050E+01, 5.6995326718E+00, 2.6768782493E+00, 1.6119341276E+00, 8.0566301004E-01],
	[1.8805000000E+04, 1.4020828886E+01, 5.6993834337E+00, 2.6791851518E+00, 1.6128307819E+00, 8.0576685697E-01],
	[1.8810000000E+04, 1.4026298402E+01, 5.6992342391E+00, 2.6814934276E+00, 1.6137274458E+00, 8.0587065452E-01],
	[1.8815000000E+04, 1.4031768596E+01, 5.6990850881E+00, 2.6838030773E+00, 1.6146241190E+00, 8.0597440270E-01],
	[1.8820000000E+04, 1.4037239470E+01, 5.6989359806E+00, 2.6861141012E+00, 1.6155208012E+00, 8.0607810153E-01],
	[1.8825000000E+04, 1.4042734208E+01, 5.6987910286E+00, 2.6884264999E+00, 1.6164181302E+00, 8.0618175102E-01],
	[1.8830000000E+04, 1.4048235476E+01, 5.6986471540E+00, 2.6907402738E+00, 1.6173156295E+00, 8.0628535118E-01],
	[1.8835000000E+04, 1.4053737438E+01, 5.6985033212E+00, 2.6930554233E+00, 1.6182131383E+00, 8.0638890203E-01],
	[1.8840000000E+04, 1.4059240093E+01, 5.6983595303E+00, 2.6953719490E+00, 1.6191106562E+00, 8.0649240358E-01],
	[1.8845000000E+04, 1.4064743442E+01, 5.6982157811E+00, 2.6976898511E+00, 1.6200081832E+00, 8.0659585584E-01],
	[1.8850000000E+04, 1.4070247484E+01, 5.6980720737E+00, 2.7000091303E+00, 1.6209057188E+00, 8.0669925883E-01],
	[1.8855000000E+04, 1.4075752219E+01, 5.6979284080E+00, 2.7023297869E+00, 1.6218032627E+00, 8.0680261256E-01],
	[1.8860000000E+04, 1.4081257648E+01, 5.6977847840E+00, 2.7046518214E+00, 1.6227008149E+00, 8.0690591705E-01],
	[1.8865000000E+04, 1.4086763770E+01, 5.6976412017E+00, 2.7069752342E+00, 1.6235983748E+00, 8.0700917230E-01],
	[1.8870000000E+04, 1.4092270584E+01, 5.6974976611E+00, 2.7093000258E+00, 1.6244959423E+00, 8.0711237834E-01],
	[1.8875000000E+04, 1.4097778092E+01, 5.6973541621E+00, 2.7116261967E+00, 1.6253935172E+00, 8.0721553517E-01],
	[1.8880000000E+04, 1.4103286293E+01, 5.6972107048E+00, 2.7139537473E+00, 1.6262910991E+00, 8.0731864282E-01],
	[1.8885000000E+04, 1.4108795186E+01, 5.6970672890E+00, 2.7162826781E+00, 1.6271886877E+00, 8.0742170128E-01],
	[1.8890000000E+04, 1.4114304772E+01, 5.6969239149E+00, 2.7186129895E+00, 1.6280862828E+00, 8.0752471058E-01],
	[1.8895000000E+04, 1.4119815050E+01, 5.6967805822E+00, 2.7209446819E+00, 1.6289838841E+00, 8.0762767074E-01],
	[1.8900000000E+04, 1.4125326021E+01, 5.6966372911E+00, 2.7232777559E+00, 1.6298814914E+00, 8.0773058176E-01],
	[1.8905000000E+04, 1.4130837684E+01, 5.6964940415E+00, 2.7256122118E+00, 1.6307791044E+00, 8.0783344366E-01],
	[1.8910000000E+04, 1.4136350040E+01, 5.6963508334E+00, 2.7279480501E+00, 1.6316767227E+00, 8.0793625645E-01],
	[1.8915000000E+04, 1.4141863088E+01, 5.6962076668E+00, 2.7302852713E+00, 1.6325743462E+00, 8.0803902014E-01],
	[1.8920000000E+04, 1.4147376827E+01, 5.6960645416E+00, 2.7326238759E+00, 1.6334719745E+00, 8.0814173476E-01],
	[1.8925000000E+04, 1.4152891259E+01, 5.6959214578E+00, 2.7349638642E+00, 1.6343696074E+00, 8.0824440031E-01],
	[1.8930000000E+04, 1.4158406382E+01, 5.6957784153E+00, 2.7373052367E+00, 1.6352672447E+00, 8.0834701681E-01],
	[1.8935000000E+04, 1.4163922198E+01, 5.6956354143E+00, 2.7396479940E+00, 1.6361648859E+00, 8.0844958427E-01],
	[1.8940000000E+04, 1.4169438705E+01, 5.6954924546E+00, 2.7419921363E+00, 1.6370625310E+00, 8.0855210271E-01],
	[1.8945000000E+04, 1.4174955903E+01, 5.6953495362E+00, 2.7443376642E+00, 1.6379601795E+00, 8.0865457214E-01],
	[1.8950000000E+04, 1.4180473793E+01, 5.6952066591E+00, 2.7466845782E+00, 1.6388578313E+00, 8.0875699258E-01],
	[1.8955000000E+04, 1.4185992375E+01, 5.6950638233E+00, 2.7490328787E+00, 1.6397554861E+00, 8.0885936403E-01],
	[1.8960000000E+04, 1.4191511647E+01, 5.6949210288E+00, 2.7513825661E+00, 1.6406531435E+00, 8.0896168651E-01],
	[1.8965000000E+04, 1.4197031611E+01, 5.6947782755E+00, 2.7537336409E+00, 1.6415508034E+00, 8.0906396005E-01],
	[1.8970000000E+04, 1.4202552266E+01, 5.6946355634E+00, 2.7560861036E+00, 1.6424484654E+00, 8.0916618464E-01],
	[1.8975000000E+04, 1.4208073612E+01, 5.6944928925E+00, 2.7584399545E+00, 1.6433461292E+00, 8.0926836031E-01],
	[1.8980000000E+04, 1.4213595649E+01, 5.6943502627E+00, 2.7607951942E+00, 1.6442437947E+00, 8.0937048706E-01],
	[1.8985000000E+04, 1.4219118377E+01, 5.6942076741E+00, 2.7631518231E+00, 1.6451414616E+00, 8.0947256493E-01],
	[1.8990000000E+04, 1.4224641795E+01, 5.6940651266E+00, 2.7655098417E+00, 1.6460391295E+00, 8.0957459390E-01],
	[1.8995000000E+04, 1.4230165904E+01, 5.6939226202E+00, 2.7678692504E+00, 1.6469367982E+00, 8.0967657401E-01],
	[1.9000000000E+04, 1.4235690704E+01, 5.6937801548E+00, 2.7702300496E+00, 1.6478344674E+00, 8.0977850527E-01],
	[1.9005000000E+04, 1.4241216194E+01, 5.6936377305E+00, 2.7725922399E+00, 1.6487321370E+00, 8.0988038769E-01],
	[1.9010000000E+04, 1.4246742374E+01, 5.6934953473E+00, 2.7749558216E+00, 1.6496298065E+00, 8.0998222128E-01],
	[1.9015000000E+04, 1.4252269245E+01, 5.6933530050E+00, 2.7773207953E+00, 1.6505274757E+00, 8.1008400607E-01],
	[1.9020000000E+04, 1.4257796806E+01, 5.6932107037E+00, 2.7796871613E+00, 1.6514251444E+00, 8.1018574205E-01],
	[1.9025000000E+04, 1.4263325056E+01, 5.6930684434E+00, 2.7820549202E+00, 1.6523228123E+00, 8.1028742926E-01],
	[1.9030000000E+04, 1.4268853997E+01, 5.6929262240E+00, 2.7844240723E+00, 1.6532204791E+00, 8.1038906769E-01],
	[1.9035000000E+04, 1.4274383628E+01, 5.6927840456E+00, 2.7867946182E+00, 1.6541181446E+00, 8.1049065738E-01],
	[1.9040000000E+04, 1.4279913948E+01, 5.6926419080E+00, 2.7891665583E+00, 1.6550158084E+00, 8.1059219832E-01],
	[1.9045000000E+04, 1.4285444958E+01, 5.6924998113E+00, 2.7915398930E+00, 1.6559134704E+00, 8.1069369054E-01],
	[1.9050000000E+04, 1.4290976658E+01, 5.6923577554E+00, 2.7939146227E+00, 1.6568111302E+00, 8.1079513409E-01],
	[1.9055000000E+04, 1.4296509047E+01, 5.6922157404E+00, 2.7962907481E+00, 1.6577087876E+00, 8.1089652903E-01],
	[1.9060000000E+04, 1.4302042125E+01, 5.6920737661E+00, 2.7986682694E+00, 1.6586064423E+00, 8.1099787537E-01],
	[1.9065000000E+04, 1.4307575893E+01, 5.6919318327E+00, 2.8010471872E+00, 1.6595040941E+00, 8.1109917314E-01],
	[1.9070000000E+04, 1.4313110350E+01, 5.6917899400E+00, 2.8034275019E+00, 1.6604017426E+00, 8.1120042233E-01],
	[1.9075000000E+04, 1.4318645496E+01, 5.6916480880E+00, 2.8058092140E+00, 1.6612993877E+00, 8.1130162296E-01],
	[1.9080000000E+04, 1.4324181331E+01, 5.6915062767E+00, 2.8081923238E+00, 1.6621970290E+00, 8.1140277505E-01],
	[1.9085000000E+04, 1.4329717855E+01, 5.6913645062E+00, 2.8105768320E+00, 1.6630946663E+00, 8.1150387859E-01],
	[1.9090000000E+04, 1.4335255067E+01, 5.6912227763E+00, 2.8129627388E+00, 1.6639922993E+00, 8.1160493360E-01],
	[1.9095000000E+04, 1.4340792969E+01, 5.6910810870E+00, 2.8153500448E+00, 1.6648899278E+00, 8.1170594010E-01],
	[1.9100000000E+04, 1.4346331559E+01, 5.6909394384E+00, 2.8177387505E+00, 1.6657875514E+00, 8.1180689808E-01],
	[1.9105000000E+04, 1.4351870838E+01, 5.6907978304E+00, 2.8201288562E+00, 1.6666851700E+00, 8.1190780758E-01],
	[1.9110000000E+04, 1.4357410805E+01, 5.6906562629E+00, 2.8225203625E+00, 1.6675827832E+00, 8.1200866858E-01],
	[1.9115000000E+04, 1.4362951460E+01, 5.6905147360E+00, 2.8249132697E+00, 1.6684803908E+00, 8.1210948111E-01],
	[1.9120000000E+04, 1.4368492804E+01, 5.6903732496E+00, 2.8273075784E+00, 1.6693779925E+00, 8.1221024518E-01],
	[1.9125000000E+04, 1.4374040709E+01, 5.6902328246E+00, 2.8297032889E+00, 1.6702757554E+00, 8.1231096079E-01],
	[1.9130000000E+04, 1.4379612756E+01, 5.6900965139E+00, 2.8321004019E+00, 1.6711741802E+00, 8.1241162797E-01],
	[1.9135000000E+04, 1.4385185507E+01, 5.6899602420E+00, 2.8344989176E+00, 1.6720725997E+00, 8.1251224671E-01],
	[1.9140000000E+04, 1.4390758960E+01, 5.6898240090E+00, 2.8368988365E+00, 1.6729710135E+00, 8.1261281703E-01],
	[1.9145000000E+04, 1.4396333116E+01, 5.6896878148E+00, 2.8393001592E+00, 1.6738694214E+00, 8.1271333894E-01],
	[1.9150000000E+04, 1.4401907975E+01, 5.6895516594E+00, 2.8417028860E+00, 1.6747678232E+00, 8.1281381246E-01],
	[1.9155000000E+04, 1.4407483536E+01, 5.6894155429E+00, 2.8441070175E+00, 1.6756662185E+00, 8.1291423759E-01],
	[1.9160000000E+04, 1.4413059800E+01, 5.6892794651E+00, 2.8465125540E+00, 1.6765646071E+00, 8.1301461434E-01],
	[1.9165000000E+04, 1.4418636766E+01, 5.6891434261E+00, 2.8489194960E+00, 1.6774629887E+00, 8.1311494274E-01],
	[1.9170000000E+04, 1.4424214434E+01, 5.6890074258E+00, 2.8513278440E+00, 1.6783613631E+00, 8.1321522277E-01],
	[1.9175000000E+04, 1.4429792805E+01, 5.6888714643E+00, 2.8537375984E+00, 1.6792597300E+00, 8.1331545447E-01],
	[1.9180000000E+04, 1.4435371878E+01, 5.6887355414E+00, 2.8561487597E+00, 1.6801580891E+00, 8.1341563784E-01],
	[1.9185000000E+04, 1.4440951653E+01, 5.6885996572E+00, 2.8585613284E+00, 1.6810564403E+00, 8.1351577289E-01],
	[1.9190000000E+04, 1.4446532129E+01, 5.6884638117E+00, 2.8609753048E+00, 1.6819547831E+00, 8.1361585963E-01],
	[1.9195000000E+04, 1.4452113308E+01, 5.6883280048E+00, 2.8633906895E+00, 1.6828531174E+00, 8.1371589807E-01],
	[1.9200000000E+04, 1.4457695188E+01, 5.6881922365E+00, 2.8658074828E+00, 1.6837514429E+00, 8.1381588824E-01],
	[1.9205000000E+04, 1.4463277770E+01, 5.6880565068E+00, 2.8682256854E+00, 1.6846497593E+00, 8.1391583012E-01],
	[1.9210000000E+04, 1.4468861054E+01, 5.6879208157E+00, 2.8706452975E+00, 1.6855480663E+00, 8.1401572375E-01],
	[1.9215000000E+04, 1.4474445039E+01, 5.6877851631E+00, 2.8730663197E+00, 1.6864463638E+00, 8.1411556913E-01],
	[1.9220000000E+04, 1.4480029725E+01, 5.6876495491E+00, 2.8754887523E+00, 1.6873446514E+00, 8.1421536627E-01],
	[1.9225000000E+04, 1.4485615112E+01, 5.6875139735E+00, 2.8779125960E+00, 1.6882429289E+00, 8.1431511518E-01],
	[1.9230000000E+04, 1.4491201201E+01, 5.6873784365E+00, 2.8803378511E+00, 1.6891411960E+00, 8.1441481587E-01],
	[1.9235000000E+04, 1.4496787991E+01, 5.6872429379E+00, 2.8827645180E+00, 1.6900394524E+00, 8.1451446837E-01],
	[1.9240000000E+04, 1.4502375482E+01, 5.6871074777E+00, 2.8851925973E+00, 1.6909376979E+00, 8.1461407267E-01],
	[1.9245000000E+04, 1.4507963673E+01, 5.6869720560E+00, 2.8876220894E+00, 1.6918359323E+00, 8.1471362879E-01],
	[1.9250000000E+04, 1.4513552566E+01, 5.6868366727E+00, 2.8900529947E+00, 1.6927341552E+00, 8.1481313674E-01],
	[1.9255000000E+04, 1.4519142159E+01, 5.6867013278E+00, 2.8924853137E+00, 1.6936323665E+00, 8.1491259654E-01],
	[1.9260000000E+04, 1.4524732452E+01, 5.6865660212E+00, 2.8949190468E+00, 1.6945305658E+00, 8.1501200819E-01],
	[1.9265000000E+04, 1.4530323447E+01, 5.6864307530E+00, 2.8973541945E+00, 1.6954287529E+00, 8.1511137171E-01],
	[1.9270000000E+04, 1.4535915141E+01, 5.6862955230E+00, 2.8997907573E+00, 1.6963269275E+00, 8.1521068710E-01],
	[1.9275000000E+04, 1.4541507536E+01, 5.6861603314E+00, 2.9022287356E+00, 1.6972250893E+00, 8.1530995439E-01],
	[1.9280000000E+04, 1.4547100631E+01, 5.6860251781E+00, 2.9046681298E+00, 1.6981232382E+00, 8.1540917358E-01],
	[1.9285000000E+04, 1.4552694427E+01, 5.6858900630E+00, 2.9071089405E+00, 1.6990213738E+00, 8.1550834469E-01],
	[1.9290000000E+04, 1.4558288922E+01, 5.6857549862E+00, 2.9095511680E+00, 1.6999194959E+00, 8.1560746772E-01],
	[1.9295000000E+04, 1.4563884117E+01, 5.6856199475E+00, 2.9119948129E+00, 1.7008176042E+00, 8.1570654269E-01],
	[1.9300000000E+04, 1.4569480012E+01, 5.6854849471E+00, 2.9144398755E+00, 1.7017156985E+00, 8.1580556961E-01],
	[1.9305000000E+04, 1.4575076607E+01, 5.6853499848E+00, 2.9168863564E+00, 1.7026137785E+00, 8.1590454849E-01],
	[1.9310000000E+04, 1.4580673902E+01, 5.6852150607E+00, 2.9193342560E+00, 1.7035118440E+00, 8.1600347935E-01],
	[1.9315000000E+04, 1.4586271896E+01, 5.6850801747E+00, 2.9217835747E+00, 1.7044098946E+00, 8.1610236219E-01],
	[1.9320000000E+04, 1.4591870589E+01, 5.6849453269E+00, 2.9242343130E+00, 1.7053079301E+00, 8.1620119703E-01],
	[1.9325000000E+04, 1.4597469982E+01, 5.6848105171E+00, 2.9266864713E+00, 1.7062059504E+00, 8.1629998388E-01],
	[1.9330000000E+04, 1.4603070075E+01, 5.6846757454E+00, 2.9291400502E+00, 1.7071039550E+00, 8.1639872276E-01],
	[1.9335000000E+04, 1.4608670866E+01, 5.6845410117E+00, 2.9315950500E+00, 1.7080019438E+00, 8.1649741367E-01],
	[1.9340000000E+04, 1.4614272357E+01, 5.6844063161E+00, 2.9340514712E+00, 1.7088999164E+00, 8.1659605663E-01],
	[1.9345000000E+04, 1.4619874546E+01, 5.6842716585E+00, 2.9365093143E+00, 1.7097978727E+00, 8.1669465165E-01],
	[1.9350000000E+04, 1.4625477435E+01, 5.6841370389E+00, 2.9389685797E+00, 1.7106958124E+00, 8.1679319874E-01],
	[1.9355000000E+04, 1.4631081022E+01, 5.6840024572E+00, 2.9414292679E+00, 1.7115937352E+00, 8.1689169792E-01],
	[1.9360000000E+04, 1.4636685308E+01, 5.6838679135E+00, 2.9438913794E+00, 1.7124916409E+00, 8.1699014919E-01],
	[1.9365000000E+04, 1.4642290292E+01, 5.6837334077E+00, 2.9463549145E+00, 1.7133895291E+00, 8.1708855258E-01],
	[1.9370000000E+04, 1.4647895976E+01, 5.6835989398E+00, 2.9488198738E+00, 1.7142873997E+00, 8.1718690808E-01],
	[1.9375000000E+04, 1.4653502357E+01, 5.6834645098E+00, 2.9512862576E+00, 1.7151852524E+00, 8.1728521572E-01],
	[1.9380000000E+04, 1.4659109437E+01, 5.6833301177E+00, 2.9537540665E+00, 1.7160830869E+00, 8.1738347550E-01],
	[1.9385000000E+04, 1.4664717215E+01, 5.6831957634E+00, 2.9562233010E+00, 1.7169809030E+00, 8.1748168745E-01],
	[1.9390000000E+04, 1.4670325692E+01, 5.6830614470E+00, 2.9586939614E+00, 1.7178787004E+00, 8.1757985156E-01],
	[1.9395000000E+04, 1.4675934866E+01, 5.6829271683E+00, 2.9611660482E+00, 1.7187764789E+00, 8.1767796786E-01],
	[1.9400000000E+04, 1.4681544739E+01, 5.6827929274E+00, 2.9636395618E+00, 1.7196742382E+00, 8.1777603636E-01],
	[1.9405000000E+04, 1.4687155309E+01, 5.6826587243E+00, 2.9661145029E+00, 1.7205719780E+00, 8.1787405706E-01],
	[1.9410000000E+04, 1.4692766577E+01, 5.6825245590E+00, 2.9685908716E+00, 1.7214696981E+00, 8.1797202999E-01],
	[1.9415000000E+04, 1.4698378543E+01, 5.6823904313E+00, 2.9710686687E+00, 1.7223673982E+00, 8.1806995515E-01],
	[1.9420000000E+04, 1.4703991206E+01, 5.6822563414E+00, 2.9735478944E+00, 1.7232650781E+00, 8.1816783256E-01],
	[1.9425000000E+04, 1.4709604567E+01, 5.6821222891E+00, 2.9760285492E+00, 1.7241627375E+00, 8.1826566223E-01],
	[1.9430000000E+04, 1.4715218626E+01, 5.6819882745E+00, 2.9785106337E+00, 1.7250603762E+00, 8.1836344417E-01],
	[1.9435000000E+04, 1.4720851937E+01, 5.6818574562E+00, 2.9809941482E+00, 1.7259585405E+00, 8.1846117840E-01],
	[1.9440000000E+04, 1.4726497030E+01, 5.6817285590E+00, 2.9834790933E+00, 1.7268570107E+00, 8.1855886492E-01],
	[1.9445000000E+04, 1.4732142836E+01, 5.6815996980E+00, 2.9859654693E+00, 1.7277554607E+00, 8.1865650376E-01],
	[1.9450000000E+04, 1.4737789354E+01, 5.6814708730E+00, 2.9884532767E+00, 1.7286538902E+00, 8.1875409492E-01],
	[1.9455000000E+04, 1.4743436584E+01, 5.6813420840E+00, 2.9909425160E+00, 1.7295522990E+00, 8.1885163842E-01],
	[1.9460000000E+04, 1.4749084526E+01, 5.6812133311E+00, 2.9934331877E+00, 1.7304506869E+00, 8.1894913426E-01],
	[1.9465000000E+04, 1.4754733179E+01, 5.6810846141E+00, 2.9959252921E+00, 1.7313490535E+00, 8.1904658247E-01],
	[1.9470000000E+04, 1.4760382544E+01, 5.6809559331E+00, 2.9984188298E+00, 1.7322473987E+00, 8.1914398306E-01],
	[1.9475000000E+04, 1.4766032621E+01, 5.6808272881E+00, 3.0009138011E+00, 1.7331457222E+00, 8.1924133603E-01],
	[1.9480000000E+04, 1.4771683410E+01, 5.6806986790E+00, 3.0034102067E+00, 1.7340440236E+00, 8.1933864140E-01],
	[1.9485000000E+04, 1.4777334909E+01, 5.6805701058E+00, 3.0059080468E+00, 1.7349423029E+00, 8.1943589919E-01],
	[1.9490000000E+04, 1.4782987121E+01, 5.6804415685E+00, 3.0084073220E+00, 1.7358405596E+00, 8.1953310941E-01],
	[1.9495000000E+04, 1.4788640043E+01, 5.6803130671E+00, 3.0109080327E+00, 1.7367387937E+00, 8.1963027207E-01],
	[1.9500000000E+04, 1.4794293677E+01, 5.6801846016E+00, 3.0134101795E+00, 1.7376370047E+00, 8.1972738718E-01],
	[1.9505000000E+04, 1.4799948021E+01, 5.6800561719E+00, 3.0159137626E+00, 1.7385351925E+00, 8.1982445475E-01],
	[1.9510000000E+04, 1.4805603077E+01, 5.6799277780E+00, 3.0184187826E+00, 1.7394333568E+00, 8.1992147481E-01],
	[1.9515000000E+04, 1.4811258843E+01, 5.6797994199E+00, 3.0209252400E+00, 1.7403314973E+00, 8.2001844736E-01],
	[1.9520000000E+04, 1.4816915321E+01, 5.6796710976E+00, 3.0234331352E+00, 1.7412296138E+00, 8.2011537242E-01],
	[1.9525000000E+04, 1.4822572509E+01, 5.6795428110E+00, 3.0259424686E+00, 1.7421277061E+00, 8.2021225000E-01],
	[1.9530000000E+04, 1.4828230407E+01, 5.6794145603E+00, 3.0284532407E+00, 1.7430257739E+00, 8.2030908010E-01],
	[1.9535000000E+04, 1.4833889016E+01, 5.6792863452E+00, 3.0309654520E+00, 1.7439238169E+00, 8.2040586276E-01],
	[1.9540000000E+04, 1.4839548336E+01, 5.6791581658E+00, 3.0334791029E+00, 1.7448218349E+00, 8.2050259797E-01],
	[1.9545000000E+04, 1.4845208366E+01, 5.6790300221E+00, 3.0359941939E+00, 1.7457198276E+00, 8.2059928576E-01],
	[1.9550000000E+04, 1.4850869106E+01, 5.6789019141E+00, 3.0385107255E+00, 1.7466177948E+00, 8.2069592613E-01],
	[1.9555000000E+04, 1.4856530556E+01, 5.6787738418E+00, 3.0410286980E+00, 1.7475157363E+00, 8.2079251911E-01],
	[1.9560000000E+04, 1.4862192716E+01, 5.6786458050E+00, 3.0435481120E+00, 1.7484136517E+00, 8.2088906469E-01],
	[1.9565000000E+04, 1.4867855587E+01, 5.6785178039E+00, 3.0460689678E+00, 1.7493115408E+00, 8.2098556290E-01],
	[1.9570000000E+04, 1.4873519167E+01, 5.6783898384E+00, 3.0485912660E+00, 1.7502094035E+00, 8.2108201376E-01],
	[1.9575000000E+04, 1.4879183456E+01, 5.6782619084E+00, 3.0511150071E+00, 1.7511072394E+00, 8.2117841726E-01],
	[1.9580000000E+04, 1.4884848456E+01, 5.6781340140E+00, 3.0536401914E+00, 1.7520050482E+00, 8.2127477343E-01],
	[1.9585000000E+04, 1.4890514165E+01, 5.6780061552E+00, 3.0561668194E+00, 1.7529028298E+00, 8.2137108228E-01],
	[1.9590000000E+04, 1.4896180584E+01, 5.6778783318E+00, 3.0586948916E+00, 1.7538005838E+00, 8.2146734383E-01],
	[1.9595000000E+04, 1.4901847712E+01, 5.6777505440E+00, 3.0612244085E+00, 1.7546983101E+00, 8.2156355808E-01],
	[1.9600000000E+04, 1.4907515549E+01, 5.6776227916E+00, 3.0637553704E+00, 1.7555960084E+00, 8.2165972505E-01],
	[1.9605000000E+04, 1.4913184095E+01, 5.6774950747E+00, 3.0662877779E+00, 1.7564936784E+00, 8.2175584476E-01],
	[1.9610000000E+04, 1.4918853351E+01, 5.6773673932E+00, 3.0688216314E+00, 1.7573913199E+00, 8.2185191721E-01],
	[1.9615000000E+04, 1.4924523316E+01, 5.6772397472E+00, 3.0713569314E+00, 1.7582889326E+00, 8.2194794243E-01],
	[1.9620000000E+04, 1.4930193989E+01, 5.6771121365E+00, 3.0738936782E+00, 1.7591865162E+00, 8.2204392042E-01],
	[1.9625000000E+04, 1.4935865372E+01, 5.6769845612E+00, 3.0764318725E+00, 1.7600840706E+00, 8.2213985121E-01],
	[1.9630000000E+04, 1.4941537463E+01, 5.6768570213E+00, 3.0789715145E+00, 1.7609815955E+00, 8.2223573479E-01],
	[1.9635000000E+04, 1.4947210263E+01, 5.6767295168E+00, 3.0815126049E+00, 1.7618790907E+00, 8.2233157119E-01],
	[1.9640000000E+04, 1.4952883771E+01, 5.6766020475E+00, 3.0840551440E+00, 1.7627765558E+00, 8.2242736042E-01],
	[1.9645000000E+04, 1.4958557988E+01, 5.6764746136E+00, 3.0865991323E+00, 1.7636739906E+00, 8.2252310250E-01],
	[1.9650000000E+04, 1.4964232913E+01, 5.6763472150E+00, 3.0891445703E+00, 1.7645713950E+00, 8.2261879744E-01],
	[1.9655000000E+04, 1.4969908547E+01, 5.6762198516E+00, 3.0916914583E+00, 1.7654687685E+00, 8.2271444524E-01],
	[1.9660000000E+04, 1.4975584889E+01, 5.6760925235E+00, 3.0942397970E+00, 1.7663661111E+00, 8.2281004593E-01],
	[1.9665000000E+04, 1.4981261939E+01, 5.6759652307E+00, 3.0967895866E+00, 1.7672634224E+00, 8.2290559953E-01],
	[1.9670000000E+04, 1.4986939696E+01, 5.6758379730E+00, 3.0993408277E+00, 1.7681607022E+00, 8.2300110603E-01],
	[1.9675000000E+04, 1.4992618162E+01, 5.6757107505E+00, 3.1018935208E+00, 1.7690579503E+00, 8.2309656546E-01],
	[1.9680000000E+04, 1.4998297336E+01, 5.6755835632E+00, 3.1044476663E+00, 1.7699551663E+00, 8.2319197784E-01],
	[1.9685000000E+04, 1.5003977217E+01, 5.6754564111E+00, 3.1070032646E+00, 1.7708523501E+00, 8.2328734317E-01],
	[1.9690000000E+04, 1.5009657806E+01, 5.6753292941E+00, 3.1095603162E+00, 1.7717495015E+00, 8.2338266147E-01],
	[1.9695000000E+04, 1.5015339103E+01, 5.6752022123E+00, 3.1121188216E+00, 1.7726466200E+00, 8.2347793275E-01],
	[1.9700000000E+04, 1.5021021107E+01, 5.6750751655E+00, 3.1146787812E+00, 1.7735437056E+00, 8.2357315703E-01],
	[1.9705000000E+04, 1.5026703819E+01, 5.6749481538E+00, 3.1172401955E+00, 1.7744407580E+00, 8.2366833432E-01],
	[1.9710000000E+04, 1.5032387237E+01, 5.6748211772E+00, 3.1198030649E+00, 1.7753377769E+00, 8.2376346464E-01],
	[1.9715000000E+04, 1.5038071363E+01, 5.6746942356E+00, 3.1223673899E+00, 1.7762347620E+00, 8.2385854800E-01],
	[1.9720000000E+04, 1.5043756196E+01, 5.6745673291E+00, 3.1249331709E+00, 1.7771317132E+00, 8.2395358441E-01],
	[1.9725000000E+04, 1.5049441737E+01, 5.6744404576E+00, 3.1275004085E+00, 1.7780286302E+00, 8.2404857389E-01],
	[1.9730000000E+04, 1.5055127983E+01, 5.6743136210E+00, 3.1300691030E+00, 1.7789255127E+00, 8.2414351646E-01],
	[1.9735000000E+04, 1.5060814937E+01, 5.6741868195E+00, 3.1326392549E+00, 1.7798223605E+00, 8.2423841212E-01],
	[1.9740000000E+04, 1.5066502598E+01, 5.6740600529E+00, 3.1352108647E+00, 1.7807191734E+00, 8.2433326089E-01],
	[1.9745000000E+04, 1.5072192790E+01, 5.6739336255E+00, 3.1377839328E+00, 1.7816160065E+00, 8.2442806278E-01],
	[1.9750000000E+04, 1.5077911809E+01, 5.6738119206E+00, 3.1403584597E+00, 1.7825136600E+00, 8.2452281782E-01],
	[1.9755000000E+04, 1.5083631549E+01, 5.6736902491E+00, 3.1429344458E+00, 1.7834112790E+00, 8.2461752601E-01],
	[1.9760000000E+04, 1.5089352011E+01, 5.6735686110E+00, 3.1455118917E+00, 1.7843088635E+00, 8.2471218737E-01],
	[1.9765000000E+04, 1.5095073194E+01, 5.6734470063E+00, 3.1480907977E+00, 1.7852064131E+00, 8.2480680191E-01],
	[1.9770000000E+04, 1.5100795098E+01, 5.6733254349E+00, 3.1506711643E+00, 1.7861039275E+00, 8.2490136965E-01],
	[1.9775000000E+04, 1.5106517724E+01, 5.6732038969E+00, 3.1532529920E+00, 1.7870014066E+00, 8.2499589059E-01],
	[1.9780000000E+04, 1.5112241071E+01, 5.6730823922E+00, 3.1558362812E+00, 1.7878988502E+00, 8.2509036477E-01],
	[1.9785000000E+04, 1.5117965138E+01, 5.6729609208E+00, 3.1584210324E+00, 1.7887962578E+00, 8.2518479218E-01],
	[1.9790000000E+04, 1.5123689927E+01, 5.6728394828E+00, 3.1610072461E+00, 1.7896936294E+00, 8.2527917285E-01],
	[1.9795000000E+04, 1.5129415436E+01, 5.6727180780E+00, 3.1635949226E+00, 1.7905909647E+00, 8.2537350679E-01],
	[1.9800000000E+04, 1.5135141667E+01, 5.6725967064E+00, 3.1661840625E+00, 1.7914882633E+00, 8.2546779401E-01],
	[1.9805000000E+04, 1.5140868617E+01, 5.6724753681E+00, 3.1687746663E+00, 1.7923855252E+00, 8.2556203453E-01],
	[1.9810000000E+04, 1.5146596289E+01, 5.6723540630E+00, 3.1713667342E+00, 1.7932827500E+00, 8.2565622836E-01],
	[1.9815000000E+04, 1.5152324680E+01, 5.6722327912E+00, 3.1739602670E+00, 1.7941799375E+00, 8.2575037552E-01],
	[1.9820000000E+04, 1.5158053792E+01, 5.6721115525E+00, 3.1765552649E+00, 1.7950770875E+00, 8.2584447602E-01],
	[1.9825000000E+04, 1.5163783625E+01, 5.6719903470E+00, 3.1791517284E+00, 1.7959741997E+00, 8.2593852988E-01],
	[1.9830000000E+04, 1.5169514177E+01, 5.6718691746E+00, 3.1817496580E+00, 1.7968712738E+00, 8.2603253711E-01],
	[1.9835000000E+04, 1.5175245450E+01, 5.6717480354E+00, 3.1843490542E+00, 1.7977683097E+00, 8.2612649772E-01],
	[1.9840000000E+04, 1.5180977443E+01, 5.6716269293E+00, 3.1869499175E+00, 1.7986653070E+00, 8.2622041173E-01],
	[1.9845000000E+04, 1.5186710155E+01, 5.6715058563E+00, 3.1895522481E+00, 1.7995622657E+00, 8.2631427916E-01],
	[1.9850000000E+04, 1.5192443587E+01, 5.6713848164E+00, 3.1921560468E+00, 1.8004591853E+00, 8.2640810002E-01],
	[1.9855000000E+04, 1.5198177739E+01, 5.6712638096E+00, 3.1947613138E+00, 1.8013560657E+00, 8.2650187433E-01],
	[1.9860000000E+04, 1.5203912611E+01, 5.6711428358E+00, 3.1973680496E+00, 1.8022529066E+00, 8.2659560209E-01],
	[1.9865000000E+04, 1.5209648202E+01, 5.6710218950E+00, 3.1999762547E+00, 1.8031497078E+00, 8.2668928333E-01],
	[1.9870000000E+04, 1.5215384513E+01, 5.6709009873E+00, 3.2025859296E+00, 1.8040464690E+00, 8.2678291805E-01],
	[1.9875000000E+04, 1.5221121543E+01, 5.6707801125E+00, 3.2051970748E+00, 1.8049431900E+00, 8.2687650628E-01],
	[1.9880000000E+04, 1.5226859292E+01, 5.6706592707E+00, 3.2078096906E+00, 1.8058398706E+00, 8.2697004803E-01],
	[1.9885000000E+04, 1.5232597760E+01, 5.6705384619E+00, 3.2104237775E+00, 1.8067365105E+00, 8.2706354331E-01],
	[1.9890000000E+04, 1.5238336948E+01, 5.6704176861E+00, 3.2130393360E+00, 1.8076331095E+00, 8.2715699214E-01],
	[1.9895000000E+04, 1.5244076854E+01, 5.6702969431E+00, 3.2156563666E+00, 1.8085296673E+00, 8.2725039453E-01],
	[1.9900000000E+04, 1.5249817479E+01, 5.6701762331E+00, 3.2182748696E+00, 1.8094261838E+00, 8.2734375050E-01],
	[1.9905000000E+04, 1.5255558824E+01, 5.6700555560E+00, 3.2208948457E+00, 1.8103226586E+00, 8.2743706007E-01],
	[1.9910000000E+04, 1.5261300887E+01, 5.6699349117E+00, 3.2235162951E+00, 1.8112190915E+00, 8.2753032324E-01],
	[1.9915000000E+04, 1.5267043668E+01, 5.6698143003E+00, 3.2261392184E+00, 1.8121154823E+00, 8.2762354003E-01],
	[1.9920000000E+04, 1.5272787168E+01, 5.6696937218E+00, 3.2287636161E+00, 1.8130118307E+00, 8.2771671046E-01],
	[1.9925000000E+04, 1.5278531387E+01, 5.6695731761E+00, 3.2313894885E+00, 1.8139081366E+00, 8.2780983455E-01],
	[1.9930000000E+04, 1.5284276323E+01, 5.6694526632E+00, 3.2340168362E+00, 1.8148043996E+00, 8.2790291230E-01],
	[1.9935000000E+04, 1.5290021978E+01, 5.6693321830E+00, 3.2366456597E+00, 1.8157006195E+00, 8.2799594374E-01],
	[1.9940000000E+04, 1.5295768352E+01, 5.6692117357E+00, 3.2392759592E+00, 1.8165967962E+00, 8.2808892887E-01],
	[1.9945000000E+04, 1.5301515443E+01, 5.6690913211E+00, 3.2419077354E+00, 1.8174929293E+00, 8.2818186772E-01],
	[1.9950000000E+04, 1.5307263252E+01, 5.6689709392E+00, 3.2445409887E+00, 1.8183890186E+00, 8.2827476030E-01],
	[1.9955000000E+04, 1.5313011780E+01, 5.6688505901E+00, 3.2471757196E+00, 1.8192850638E+00, 8.2836760661E-01],
	[1.9960000000E+04, 1.5318761025E+01, 5.6687302737E+00, 3.2498119284E+00, 1.8201810648E+00, 8.2846040669E-01],
	[1.9965000000E+04, 1.5324510988E+01, 5.6686099899E+00, 3.2524496157E+00, 1.8210770213E+00, 8.2855316054E-01],
	[1.9970000000E+04, 1.5330261668E+01, 5.6684897389E+00, 3.2550887819E+00, 1.8219729331E+00, 8.2864586818E-01],
	[1.9975000000E+04, 1.5336013066E+01, 5.6683695205E+00, 3.2577294274E+00, 1.8228687999E+00, 8.2873852963E-01],
	[1.9980000000E+04, 1.5341765181E+01, 5.6682493347E+00, 3.2603715528E+00, 1.8237646215E+00, 8.2883114489E-01],
	[1.9985000000E+04, 1.5347518014E+01, 5.6681291815E+00, 3.2630151585E+00, 1.8246603977E+00, 8.2892371399E-01],
	[1.9990000000E+04, 1.5353271564E+01, 5.6680090610E+00, 3.2656602449E+00, 1.8255561281E+00, 8.2901623694E-01],
	[1.9995000000E+04, 1.5359025831E+01, 5.6678889730E+00, 3.2683068126E+00, 1.8264518126E+00, 8.2910871375E-01],
	[2.0000000000E+04, 1.5364780816E+01, 5.6677689176E+00, 3.2709548619E+00, 1.8273474510E+00, 8.2920114445E-01],
	[2.0005000000E+04, 1.5370536517E+01, 5.6676488948E+00, 3.2736087950E+00, 1.8282444159E+00, 8.2929352904E-01],
	[2.0010000000E+04, 1.5376292935E+01, 5.6675289045E+00, 3.2762642168E+00, 1.8291413343E+00, 8.2938586754E-01],
	[2.0015000000E+04, 1.5382050070E+01, 5.6674089467E+00, 3.2789211277E+00, 1.8300382059E+00, 8.2947815997E-01],
	[2.0020000000E+04, 1.5387807922E+01, 5.6672890214E+00, 3.2815795281E+00, 1.8309350306E+00, 8.2957040634E-01],
	[2.0025000000E+04, 1.5393566491E+01, 5.6671691286E+00, 3.2842394186E+00, 1.8318318081E+00, 8.2966260666E-01],
	[2.0030000000E+04, 1.5399325775E+01, 5.6670492682E+00, 3.2869007995E+00, 1.8327285381E+00, 8.2975476096E-01],
	[2.0035000000E+04, 1.5405085777E+01, 5.6669294403E+00, 3.2895636714E+00, 1.8336252204E+00, 8.2984686925E-01],
	[2.0040000000E+04, 1.5410846495E+01, 5.6668096449E+00, 3.2922280347E+00, 1.8345218548E+00, 8.2993893154E-01],
	[2.0045000000E+04, 1.5416607929E+01, 5.6666898819E+00, 3.2948938898E+00, 1.8354184411E+00, 8.3003094785E-01],
	[2.0050000000E+04, 1.5422370079E+01, 5.6665701512E+00, 3.2975612373E+00, 1.8363149790E+00, 8.3012291820E-01],
	[2.0055000000E+04, 1.5428132946E+01, 5.6664504530E+00, 3.3002300776E+00, 1.8372114682E+00, 8.3021484259E-01],
	[2.0060000000E+04, 1.5433896528E+01, 5.6663307871E+00, 3.3029004111E+00, 1.8381079086E+00, 8.3030672105E-01],
	[2.0065000000E+04, 1.5439675558E+01, 5.6662135635E+00, 3.3055722383E+00, 1.8390047627E+00, 8.3039855360E-01],
	[2.0070000000E+04, 1.5445470747E+01, 5.6660988957E+00, 3.3082455597E+00, 1.8399020533E+00, 8.3049034024E-01],
	[2.0075000000E+04, 1.5451266666E+01, 5.6659842587E+00, 3.3109203758E+00, 1.8407992957E+00, 8.3058208099E-01],
	[2.0080000000E+04, 1.5457063316E+01, 5.6658696526E+00, 3.3135966870E+00, 1.8416964896E+00, 8.3067377587E-01],
	[2.0085000000E+04, 1.5462860697E+01, 5.6657550773E+00, 3.3162744937E+00, 1.8425936348E+00, 8.3076542489E-01],
	[2.0090000000E+04, 1.5468658808E+01, 5.6656405329E+00, 3.3189537965E+00, 1.8434907310E+00, 8.3085702807E-01],
	[2.0095000000E+04, 1.5474457650E+01, 5.6655260193E+00, 3.3216345957E+00, 1.8443877780E+00, 8.3094858543E-01],
	[2.0100000000E+04, 1.5480257222E+01, 5.6654115365E+00, 3.3243168919E+00, 1.8452847756E+00, 8.3104009698E-01],
	[2.0105000000E+04, 1.5486057524E+01, 5.6652970844E+00, 3.3270006855E+00, 1.8461817235E+00, 8.3113156273E-01],
	[2.0110000000E+04, 1.5491858556E+01, 5.6651826632E+00, 3.3296859771E+00, 1.8470786215E+00, 8.3122298271E-01],
	[2.0115000000E+04, 1.5497660319E+01, 5.6650682727E+00, 3.3323727669E+00, 1.8479754694E+00, 8.3131435692E-01],
	[2.0120000000E+04, 1.5503462811E+01, 5.6649539129E+00, 3.3350610556E+00, 1.8488722670E+00, 8.3140568539E-01],
	[2.0125000000E+04, 1.5509266034E+01, 5.6648395839E+00, 3.3377508435E+00, 1.8497690140E+00, 8.3149696813E-01],
	[2.0130000000E+04, 1.5515069986E+01, 5.6647252856E+00, 3.3404421311E+00, 1.8506657101E+00, 8.3158820515E-01],
	[2.0135000000E+04, 1.5520874668E+01, 5.6646110180E+00, 3.3431349190E+00, 1.8515623552E+00, 8.3167939647E-01],
	[2.0140000000E+04, 1.5526680080E+01, 5.6644967810E+00, 3.3458292075E+00, 1.8524589490E+00, 8.3177054211E-01],
	[2.0145000000E+04, 1.5532486221E+01, 5.6643825747E+00, 3.3485249971E+00, 1.8533554912E+00, 8.3186164208E-01],
	[2.0150000000E+04, 1.5538293092E+01, 5.6642683991E+00, 3.3512222883E+00, 1.8542519818E+00, 8.3195269640E-01],
	[2.0155000000E+04, 1.5544100692E+01, 5.6641542540E+00, 3.3539210816E+00, 1.8551484203E+00, 8.3204370509E-01],
	[2.0160000000E+04, 1.5549909021E+01, 5.6640401396E+00, 3.3566213773E+00, 1.8560448066E+00, 8.3213466815E-01],
	[2.0165000000E+04, 1.5555718080E+01, 5.6639260558E+00, 3.3593231761E+00, 1.8569411405E+00, 8.3222558561E-01],
	[2.0170000000E+04, 1.5561527868E+01, 5.6638120026E+00, 3.3620264782E+00, 1.8578374217E+00, 8.3231645748E-01],
	[2.0175000000E+04, 1.5567338384E+01, 5.6636979799E+00, 3.3647312843E+00, 1.8587336500E+00, 8.3240728378E-01],
	[2.0180000000E+04, 1.5573149630E+01, 5.6635839878E+00, 3.3674375947E+00, 1.8596298251E+00, 8.3249806452E-01],
	[2.0185000000E+04, 1.5578961605E+01, 5.6634700262E+00, 3.3701454100E+00, 1.8605259468E+00, 8.3258879973E-01],
	[2.0190000000E+04, 1.5584774308E+01, 5.6633560951E+00, 3.3728547305E+00, 1.8614220150E+00, 8.3267948940E-01],
	[2.0195000000E+04, 1.5590587740E+01, 5.6632421946E+00, 3.3755655568E+00, 1.8623180293E+00, 8.3277013357E-01],
	[2.0200000000E+04, 1.5596401900E+01, 5.6631283245E+00, 3.3782778893E+00, 1.8632139896E+00, 8.3286073225E-01],
	[2.0205000000E+04, 1.5602216789E+01, 5.6630144849E+00, 3.3809917285E+00, 1.8641098956E+00, 8.3295128543E-01],
	[2.0210000000E+04, 1.5608032407E+01, 5.6629006758E+00, 3.3837070748E+00, 1.8650057470E+00, 8.3304179306E-01],
	[2.0215000000E+04, 1.5613848752E+01, 5.6627868970E+00, 3.3864239287E+00, 1.8659015437E+00, 8.3313225517E-01],
	[2.0220000000E+04, 1.5619665826E+01, 5.6626731488E+00, 3.3891422907E+00, 1.8667972854E+00, 8.3322267177E-01],
	[2.0225000000E+04, 1.5625483628E+01, 5.6625594309E+00, 3.3918621612E+00, 1.8676929719E+00, 8.3331304287E-01],
	[2.0230000000E+04, 1.5631302158E+01, 5.6624457434E+00, 3.3945835407E+00, 1.8685886029E+00, 8.3340336849E-01],
	[2.0235000000E+04, 1.5637121416E+01, 5.6623320863E+00, 3.3973064297E+00, 1.8694841783E+00, 8.3349364864E-01],
	[2.0240000000E+04, 1.5642941402E+01, 5.6622184595E+00, 3.4000308286E+00, 1.8703796977E+00, 8.3358388334E-01],
	[2.0245000000E+04, 1.5648762116E+01, 5.6621048631E+00, 3.4027567379E+00, 1.8712751611E+00, 8.3367407260E-01],
	[2.0250000000E+04, 1.5654583557E+01, 5.6619912971E+00, 3.4054841580E+00, 1.8721705680E+00, 8.3376421644E-01],
	[2.0255000000E+04, 1.5660405726E+01, 5.6618777613E+00, 3.4082130894E+00, 1.8730659184E+00, 8.3385431487E-01],
	[2.0260000000E+04, 1.5666228622E+01, 5.6617642558E+00, 3.4109435326E+00, 1.8739612120E+00, 8.3394436791E-01],
	[2.0265000000E+04, 1.5672052246E+01, 5.6616507807E+00, 3.4136754881E+00, 1.8748564485E+00, 8.3403437557E-01],
	[2.0270000000E+04, 1.5677876597E+01, 5.6615373358E+00, 3.4164089562E+00, 1.8757516278E+00, 8.3412433787E-01],
	[2.0275000000E+04, 1.5683701676E+01, 5.6614239211E+00, 3.4191439375E+00, 1.8766467496E+00, 8.3421425482E-01],
	[2.0280000000E+04, 1.5689527481E+01, 5.6613105367E+00, 3.4218804325E+00, 1.8775418136E+00, 8.3430412644E-01],
	[2.0285000000E+04, 1.5695354014E+01, 5.6611971825E+00, 3.4246184415E+00, 1.8784368197E+00, 8.3439395274E-01],
	[2.0290000000E+04, 1.5701181274E+01, 5.6610838585E+00, 3.4273579651E+00, 1.8793317676E+00, 8.3448373374E-01],
	[2.0295000000E+04, 1.5707009260E+01, 5.6609705647E+00, 3.4300990037E+00, 1.8802266571E+00, 8.3457346945E-01],
	[2.0300000000E+04, 1.5712837974E+01, 5.6608573011E+00, 3.4328415578E+00, 1.8811214880E+00, 8.3466315989E-01],
	[2.0305000000E+04, 1.5718667414E+01, 5.6607440676E+00, 3.4355856278E+00, 1.8820162600E+00, 8.3475280507E-01],
	[2.0310000000E+04, 1.5724497580E+01, 5.6606308643E+00, 3.4383312143E+00, 1.8829109729E+00, 8.3484240501E-01],
	[2.0315000000E+04, 1.5730328473E+01, 5.6605176911E+00, 3.4410783176E+00, 1.8838056265E+00, 8.3493195972E-01],
	[2.0320000000E+04, 1.5736160093E+01, 5.6604045480E+00, 3.4438269382E+00, 1.8847002205E+00, 8.3502146922E-01],
	[2.0325000000E+04, 1.5741992439E+01, 5.6602914350E+00, 3.4465770767E+00, 1.8855947548E+00, 8.3511093353E-01],
	[2.0330000000E+04, 1.5747825511E+01, 5.6601783521E+00, 3.4493287334E+00, 1.8864892291E+00, 8.3520035266E-01],
	[2.0335000000E+04, 1.5753659310E+01, 5.6600652993E+00, 3.4520819089E+00, 1.8873836432E+00, 8.3528972662E-01],
	[2.0340000000E+04, 1.5759493834E+01, 5.6599522765E+00, 3.4548366035E+00, 1.8882779968E+00, 8.3537905543E-01],
	[2.0345000000E+04, 1.5765329085E+01, 5.6598392838E+00, 3.4575928179E+00, 1.8891722898E+00, 8.3546833910E-01],
	[2.0350000000E+04, 1.5771165061E+01, 5.6597263210E+00, 3.4603505523E+00, 1.8900665219E+00, 8.3555757765E-01],
	[2.0355000000E+04, 1.5777001763E+01, 5.6596133883E+00, 3.4631098073E+00, 1.8909606928E+00, 8.3564677111E-01],
	[2.0360000000E+04, 1.5782839191E+01, 5.6595004856E+00, 3.4658705834E+00, 1.8918548025E+00, 8.3573591947E-01],
	[2.0365000000E+04, 1.5788677345E+01, 5.6593876128E+00, 3.4686328810E+00, 1.8927488505E+00, 8.3582502275E-01],
	[2.0370000000E+04, 1.5794516224E+01, 5.6592747700E+00, 3.4713967005E+00, 1.8936428368E+00, 8.3591408098E-01],
	[2.0375000000E+04, 1.5800355829E+01, 5.6591619572E+00, 3.4741620425E+00, 1.8945367610E+00, 8.3600309417E-01],
	[2.0380000000E+04, 1.5806196159E+01, 5.6590491743E+00, 3.4769289075E+00, 1.8954306230E+00, 8.3609206233E-01],
	[2.0385000000E+04, 1.5812037214E+01, 5.6589364212E+00, 3.4796972958E+00, 1.8963244226E+00, 8.3618098548E-01],
	[2.0390000000E+04, 1.5817905923E+01, 5.6588280363E+00, 3.4824672079E+00, 1.8972190345E+00, 8.3626986363E-01],
	[2.0395000000E+04, 1.5823778616E+01, 5.6587202028E+00, 3.4852386443E+00, 1.8981136901E+00, 8.3635869680E-01],
	[2.0400000000E+04, 1.5829652049E+01, 5.6586123978E+00, 3.4880116055E+00, 1.8990082840E+00, 8.3644748501E-01],
	[2.0405000000E+04, 1.5835526223E+01, 5.6585046213E+00, 3.4907860919E+00, 1.8999028157E+00, 8.3653622826E-01],
	[2.0410000000E+04, 1.5841401136E+01, 5.6583968732E+00, 3.4935621040E+00, 1.9007972853E+00, 8.3662492658E-01],
	[2.0415000000E+04, 1.5847276788E+01, 5.6582891536E+00, 3.4963396423E+00, 1.9016916923E+00, 8.3671357999E-01],
	[2.0420000000E+04, 1.5853153181E+01, 5.6581814624E+00, 3.4991187072E+00, 1.9025860366E+00, 8.3680218848E-01],
	[2.0425000000E+04, 1.5859030313E+01, 5.6580737996E+00, 3.5018992991E+00, 1.9034803180E+00, 8.3689075210E-01],
	[2.0430000000E+04, 1.5864908184E+01, 5.6579661652E+00, 3.5046814186E+00, 1.9043745362E+00, 8.3697927084E-01],
	[2.0435000000E+04, 1.5870786795E+01, 5.6578585592E+00, 3.5074650662E+00, 1.9052686910E+00, 8.3706774472E-01],
	[2.0440000000E+04, 1.5876666145E+01, 5.6577509816E+00, 3.5102502422E+00, 1.9061627822E+00, 8.3715617376E-01],
	[2.0445000000E+04, 1.5882546234E+01, 5.6576434323E+00, 3.5130369472E+00, 1.9070568096E+00, 8.3724455798E-01],
	[2.0450000000E+04, 1.5888427062E+01, 5.6575359114E+00, 3.5158251815E+00, 1.9079507730E+00, 8.3733289739E-01],
	[2.0455000000E+04, 1.5894308630E+01, 5.6574284188E+00, 3.5186149458E+00, 1.9088446721E+00, 8.3742119200E-01],
	[2.0460000000E+04, 1.5900190936E+01, 5.6573209545E+00, 3.5214062404E+00, 1.9097385067E+00, 8.3750944184E-01],
	[2.0465000000E+04, 1.5906073981E+01, 5.6572135185E+00, 3.5241990657E+00, 1.9106322766E+00, 8.3759764691E-01],
	[2.0470000000E+04, 1.5911957765E+01, 5.6571061108E+00, 3.5269934224E+00, 1.9115259816E+00, 8.3768580724E-01],
	[2.0475000000E+04, 1.5917842287E+01, 5.6569987314E+00, 3.5297893108E+00, 1.9124196214E+00, 8.3777392284E-01],
	[2.0480000000E+04, 1.5923727548E+01, 5.6568913802E+00, 3.5325867313E+00, 1.9133131958E+00, 8.3786199372E-01],
	[2.0485000000E+04, 1.5929613548E+01, 5.6567840573E+00, 3.5353856846E+00, 1.9142067047E+00, 8.3795001990E-01],
	[2.0490000000E+04, 1.5935500286E+01, 5.6566767626E+00, 3.5381861709E+00, 1.9151001477E+00, 8.3803800140E-01],
	[2.0495000000E+04, 1.5941387762E+01, 5.6565694961E+00, 3.5409881909E+00, 1.9159935247E+00, 8.3812593824E-01],
	[2.0500000000E+04, 1.5947275976E+01, 5.6564622578E+00, 3.5437917449E+00, 1.9168868355E+00, 8.3821383042E-01],
	[2.0505000000E+04, 1.5953164929E+01, 5.6563550477E+00, 3.5465968335E+00, 1.9177800798E+00, 8.3830167796E-01],
	[2.0510000000E+04, 1.5959054620E+01, 5.6562478657E+00, 3.5494034570E+00, 1.9186732574E+00, 8.3838948089E-01],
	[2.0515000000E+04, 1.5964945048E+01, 5.6561407120E+00, 3.5522116159E+00, 1.9195663681E+00, 8.3847723921E-01],
	[2.0520000000E+04, 1.5970836215E+01, 5.6560335863E+00, 3.5550213108E+00, 1.9204594117E+00, 8.3856495295E-01],
	[2.0525000000E+04, 1.5976728119E+01, 5.6559264888E+00, 3.5578325421E+00, 1.9213523879E+00, 8.3865262211E-01],
	[2.0530000000E+04, 1.5982620761E+01, 5.6558194194E+00, 3.5606453102E+00, 1.9222452966E+00, 8.3874024671E-01],
	[2.0535000000E+04, 1.5988514141E+01, 5.6557123781E+00, 3.5634596156E+00, 1.9231381375E+00, 8.3882782678E-01],
	[2.0540000000E+04, 1.5994408258E+01, 5.6556053649E+00, 3.5662754588E+00, 1.9240309104E+00, 8.3891536232E-01],
	[2.0545000000E+04, 1.6000303113E+01, 5.6554983798E+00, 3.5690928402E+00, 1.9249236151E+00, 8.3900285336E-01],
	[2.0550000000E+04, 1.6006198705E+01, 5.6553914227E+00, 3.5719117604E+00, 1.9258162513E+00, 8.3909029990E-01],
	[2.0555000000E+04, 1.6012095034E+01, 5.6552844936E+00, 3.5747322197E+00, 1.9267088189E+00, 8.3917770196E-01],
	[2.0560000000E+04, 1.6017992100E+01, 5.6551775926E+00, 3.5775542187E+00, 1.9276013176E+00, 8.3926505957E-01],
	[2.0565000000E+04, 1.6023889904E+01, 5.6550707196E+00, 3.5803777577E+00, 1.9284937473E+00, 8.3935237273E-01],
	[2.0570000000E+04, 1.6029788444E+01, 5.6549638746E+00, 3.5832028373E+00, 1.9293861076E+00, 8.3943964146E-01],
	[2.0575000000E+04, 1.6035687722E+01, 5.6548570576E+00, 3.5860294580E+00, 1.9302783984E+00, 8.3952686579E-01],
	[2.0580000000E+04, 1.6041587736E+01, 5.6547502686E+00, 3.5888576201E+00, 1.9311706195E+00, 8.3961404571E-01],
	[2.0585000000E+04, 1.6047488487E+01, 5.6546435075E+00, 3.5916873242E+00, 1.9320627706E+00, 8.3970118126E-01],
	[2.0590000000E+04, 1.6053389975E+01, 5.6545367743E+00, 3.5945185707E+00, 1.9329548516E+00, 8.3978827244E-01],
	[2.0595000000E+04, 1.6059292199E+01, 5.6544300691E+00, 3.5973513602E+00, 1.9338468621E+00, 8.3987531928E-01],
	[2.0600000000E+04, 1.6065195159E+01, 5.6543233918E+00, 3.6001856930E+00, 1.9347388021E+00, 8.3996232178E-01],
	[2.0605000000E+04, 1.6071098856E+01, 5.6542167424E+00, 3.6030215696E+00, 1.9356306713E+00, 8.4004927997E-01],
	[2.0610000000E+04, 1.6077003290E+01, 5.6541101209E+00, 3.6058589905E+00, 1.9365224694E+00, 8.4013619386E-01],
	[2.0615000000E+04, 1.6082908459E+01, 5.6540035273E+00, 3.6086979561E+00, 1.9374141963E+00, 8.4022306347E-01],
	[2.0620000000E+04, 1.6088814365E+01, 5.6538969615E+00, 3.6115384670E+00, 1.9383058517E+00, 8.4030988882E-01],
	[2.0625000000E+04, 1.6094721007E+01, 5.6537904236E+00, 3.6143805236E+00, 1.9391974354E+00, 8.4039666991E-01],
	[2.0630000000E+04, 1.6100628385E+01, 5.6536839135E+00, 3.6172241263E+00, 1.9400889473E+00, 8.4048340677E-01],
	[2.0635000000E+04, 1.6106536498E+01, 5.6535774312E+00, 3.6200692756E+00, 1.9409803870E+00, 8.4057009941E-01],
	[2.0640000000E+04, 1.6112445348E+01, 5.6534709767E+00, 3.6229159720E+00, 1.9418717544E+00, 8.4065674785E-01],
	[2.0645000000E+04, 1.6118354933E+01, 5.6533645500E+00, 3.6257642160E+00, 1.9427630493E+00, 8.4074335211E-01],
	[2.0650000000E+04, 1.6124265254E+01, 5.6532581511E+00, 3.6286140079E+00, 1.9436542714E+00, 8.4082991220E-01],
	[2.0655000000E+04, 1.6130176310E+01, 5.6531517799E+00, 3.6314653484E+00, 1.9445454206E+00, 8.4091642813E-01],
	[2.0660000000E+04, 1.6136088102E+01, 5.6530454365E+00, 3.6343182378E+00, 1.9454364966E+00, 8.4100289993E-01],
	[2.0665000000E+04, 1.6142000629E+01, 5.6529391209E+00, 3.6371726766E+00, 1.9463274992E+00, 8.4108932761E-01],
	[2.0670000000E+04, 1.6147913891E+01, 5.6528328329E+00, 3.6400286652E+00, 1.9472184282E+00, 8.4117571119E-01],
	[2.0675000000E+04, 1.6153827888E+01, 5.6527265727E+00, 3.6428862043E+00, 1.9481092834E+00, 8.4126205068E-01],
	[2.0680000000E+04, 1.6159742621E+01, 5.6526203401E+00, 3.6457452941E+00, 1.9490000645E+00, 8.4134834610E-01],
	[2.0685000000E+04, 1.6165658089E+01, 5.6525141352E+00, 3.6486059352E+00, 1.9498907714E+00, 8.4143459747E-01],
	[2.0690000000E+04, 1.6171574291E+01, 5.6524079580E+00, 3.6514681281E+00, 1.9507814039E+00, 8.4152080480E-01],
	[2.0695000000E+04, 1.6177491229E+01, 5.6523018084E+00, 3.6543318731E+00, 1.9516719617E+00, 8.4160696811E-01],
	[2.0700000000E+04, 1.6183408901E+01, 5.6521956865E+00, 3.6571971708E+00, 1.9525624446E+00, 8.4169308742E-01],
	[2.0705000000E+04, 1.6189327307E+01, 5.6520895922E+00, 3.6600640217E+00, 1.9534528524E+00, 8.4177916273E-01],
	[2.0710000000E+04, 1.6195246449E+01, 5.6519835255E+00, 3.6629324261E+00, 1.9543431849E+00, 8.4186519408E-01],
	[2.0715000000E+04, 1.6201174059E+01, 5.6518787146E+00, 3.6658023847E+00, 1.9552337015E+00, 8.4195118147E-01],
	[2.0720000000E+04, 1.6207124826E+01, 5.6517774899E+00, 3.6686738977E+00, 1.9561248957E+00, 8.4203712493E-01],
	[2.0725000000E+04, 1.6213076342E+01, 5.6516762913E+00, 3.6715469658E+00, 1.9570160152E+00, 8.4212302446E-01],
	[2.0730000000E+04, 1.6219028607E+01, 5.6515751190E+00, 3.6744215894E+00, 1.9579070598E+00, 8.4220888008E-01],
	[2.0735000000E+04, 1.6224981621E+01, 5.6514739728E+00, 3.6772977688E+00, 1.9587980294E+00, 8.4229469182E-01],
	[2.0740000000E+04, 1.6230935384E+01, 5.6513728529E+00, 3.6801755047E+00, 1.9596889237E+00, 8.4238045969E-01],
	[2.0745000000E+04, 1.6236889896E+01, 5.6512717592E+00, 3.6830547974E+00, 1.9605797426E+00, 8.4246618370E-01],
	[2.0750000000E+04, 1.6242845156E+01, 5.6511706916E+00, 3.6859356475E+00, 1.9614704857E+00, 8.4255186387E-01],
	[2.0755000000E+04, 1.6248801165E+01, 5.6510696502E+00, 3.6888180554E+00, 1.9623611530E+00, 8.4263750022E-01],
	[2.0760000000E+04, 1.6254757922E+01, 5.6509686349E+00, 3.6917020215E+00, 1.9632517441E+00, 8.4272309276E-01],
	[2.0765000000E+04, 1.6260715428E+01, 5.6508676458E+00, 3.6945875464E+00, 1.9641422589E+00, 8.4280864152E-01],
	[2.0770000000E+04, 1.6266673683E+01, 5.6507666827E+00, 3.6974746304E+00, 1.9650326972E+00, 8.4289414650E-01],
	[2.0775000000E+04, 1.6272632685E+01, 5.6506657458E+00, 3.7003632741E+00, 1.9659230587E+00, 8.4297960773E-01],
	[2.0780000000E+04, 1.6278592436E+01, 5.6505648350E+00, 3.7032534780E+00, 1.9668133433E+00, 8.4306502521E-01],
	[2.0785000000E+04, 1.6284552935E+01, 5.6504639502E+00, 3.7061452425E+00, 1.9677035507E+00, 8.4315039898E-01],
	[2.0790000000E+04, 1.6290514182E+01, 5.6503630916E+00, 3.7090385680E+00, 1.9685936808E+00, 8.4323572904E-01],
	[2.0795000000E+04, 1.6296476176E+01, 5.6502622589E+00, 3.7119334550E+00, 1.9694837333E+00, 8.4332101541E-01],
	[2.0800000000E+04, 1.6302438919E+01, 5.6501614524E+00, 3.7148299040E+00, 1.9703737080E+00, 8.4340625812E-01],
	[2.0805000000E+04, 1.6308402409E+01, 5.6500606718E+00, 3.7177279155E+00, 1.9712636047E+00, 8.4349145716E-01],
	[2.0810000000E+04, 1.6314366647E+01, 5.6499599172E+00, 3.7206274900E+00, 1.9721534232E+00, 8.4357661257E-01],
	[2.0815000000E+04, 1.6320331633E+01, 5.6498591887E+00, 3.7235286278E+00, 1.9730431633E+00, 8.4366172435E-01],
	[2.0820000000E+04, 1.6326297366E+01, 5.6497584862E+00, 3.7264313295E+00, 1.9739328247E+00, 8.4374679254E-01],
	[2.0825000000E+04, 1.6332263847E+01, 5.6496578096E+00, 3.7293355955E+00, 1.9748224074E+00, 8.4383181713E-01],
	[2.0830000000E+04, 1.6338231074E+01, 5.6495571590E+00, 3.7322414263E+00, 1.9757119110E+00, 8.4391679815E-01],
	[2.0835000000E+04, 1.6344199049E+01, 5.6494565343E+00, 3.7351488224E+00, 1.9766013354E+00, 8.4400173562E-01],
	[2.0840000000E+04, 1.6350167772E+01, 5.6493559356E+00, 3.7380577842E+00, 1.9774906803E+00, 8.4408662955E-01],
	[2.0845000000E+04, 1.6356137241E+01, 5.6492553628E+00, 3.7409683122E+00, 1.9783799456E+00, 8.4417147996E-01],
	[2.0850000000E+04, 1.6362107457E+01, 5.6491548159E+00, 3.7438804068E+00, 1.9792691310E+00, 8.4425628687E-01],
	[2.0855000000E+04, 1.6368078420E+01, 5.6490542949E+00, 3.7467940686E+00, 1.9801582364E+00, 8.4434105029E-01],
	[2.0860000000E+04, 1.6374050130E+01, 5.6489537997E+00, 3.7497092980E+00, 1.9810472615E+00, 8.4442577024E-01],
	[2.0865000000E+04, 1.6380022587E+01, 5.6488533305E+00, 3.7526260954E+00, 1.9819362061E+00, 8.4451044674E-01],
	[2.0870000000E+04, 1.6385995790E+01, 5.6487528871E+00, 3.7555444614E+00, 1.9828250700E+00, 8.4459507980E-01],
	[2.0875000000E+04, 1.6391969740E+01, 5.6486524696E+00, 3.7584643964E+00, 1.9837138531E+00, 8.4467966944E-01],
	[2.0880000000E+04, 1.6397944437E+01, 5.6485520779E+00, 3.7613859008E+00, 1.9846025550E+00, 8.4476421568E-01],
	[2.0885000000E+04, 1.6403919879E+01, 5.6484517120E+00, 3.7643089751E+00, 1.9854911756E+00, 8.4484871854E-01],
	[2.0890000000E+04, 1.6409896068E+01, 5.6483513719E+00, 3.7672336199E+00, 1.9863797148E+00, 8.4493317803E-01],
	[2.0895000000E+04, 1.6415873003E+01, 5.6482510577E+00, 3.7701598355E+00, 1.9872681722E+00, 8.4501759416E-01],
	[2.0900000000E+04, 1.6421850685E+01, 5.6481507692E+00, 3.7730876225E+00, 1.9881565477E+00, 8.4510196696E-01],
	[2.0905000000E+04, 1.6427829112E+01, 5.6480505064E+00, 3.7760169812E+00, 1.9890448411E+00, 8.4518629645E-01],
	[2.0910000000E+04, 1.6433808285E+01, 5.6479502695E+00, 3.7789479122E+00, 1.9899330521E+00, 8.4527058264E-01],
	[2.0915000000E+04, 1.6439788205E+01, 5.6478500583E+00, 3.7818804160E+00, 1.9908211807E+00, 8.4535482554E-01],
	[2.0920000000E+04, 1.6445768870E+01, 5.6477498728E+00, 3.7848144929E+00, 1.9917092265E+00, 8.4543902518E-01],
	[2.0925000000E+04, 1.6451750280E+01, 5.6476497130E+00, 3.7877501435E+00, 1.9925971893E+00, 8.4552318156E-01],
	[2.0930000000E+04, 1.6457732437E+01, 5.6475495789E+00, 3.7906873683E+00, 1.9934850690E+00, 8.4560729472E-01],
	[2.0935000000E+04, 1.6463715338E+01, 5.6474494705E+00, 3.7936261676E+00, 1.9943728654E+00, 8.4569136466E-01],
	[2.0940000000E+04, 1.6469698986E+01, 5.6473493878E+00, 3.7965665420E+00, 1.9952605782E+00, 8.4577539141E-01],
	[2.0945000000E+04, 1.6475683378E+01, 5.6472493308E+00, 3.7995084919E+00, 1.9961482073E+00, 8.4585937497E-01],
	[2.0950000000E+04, 1.6481668516E+01, 5.6471492995E+00, 3.8024520179E+00, 1.9970357524E+00, 8.4594331537E-01],
	[2.0955000000E+04, 1.6487654399E+01, 5.6470492937E+00, 3.8053971203E+00, 1.9979232134E+00, 8.4602721262E-01],
	[2.0960000000E+04, 1.6493641027E+01, 5.6469493136E+00, 3.8083437996E+00, 1.9988105900E+00, 8.4611106675E-01],
	[2.0965000000E+04, 1.6499628400E+01, 5.6468493591E+00, 3.8112920564E+00, 1.9996978821E+00, 8.4619487776E-01],
	[2.0970000000E+04, 1.6505616519E+01, 5.6467494303E+00, 3.8142418910E+00, 2.0005850894E+00, 8.4627864568E-01],
	[2.0975000000E+04, 1.6511605381E+01, 5.6466495270E+00, 3.8171933040E+00, 2.0014722117E+00, 8.4636237052E-01],
	[2.0980000000E+04, 1.6517594989E+01, 5.6465496493E+00, 3.8201462958E+00, 2.0023592488E+00, 8.4644605230E-01],
	[2.0985000000E+04, 1.6523585342E+01, 5.6464497971E+00, 3.8231008668E+00, 2.0032462006E+00, 8.4652969104E-01],
	[2.0990000000E+04, 1.6529576439E+01, 5.6463499705E+00, 3.8260570176E+00, 2.0041330668E+00, 8.4661328676E-01],
	[2.0995000000E+04, 1.6535568280E+01, 5.6462501695E+00, 3.8290147486E+00, 2.0050198473E+00, 8.4669683946E-01],
	[2.1000000000E+04, 1.6541560866E+01, 5.6461503940E+00, 3.8319740602E+00, 2.0059065418E+00, 8.4678034917E-01],
	[2.1005000000E+04, 1.6547554196E+01, 5.6460506440E+00, 3.8349349531E+00, 2.0067931501E+00, 8.4686381591E-01],
	[2.1010000000E+04, 1.6553548271E+01, 5.6459509195E+00, 3.8378974275E+00, 2.0076796720E+00, 8.4694723969E-01],
	[2.1015000000E+04, 1.6559543089E+01, 5.6458512205E+00, 3.8408614840E+00, 2.0085661073E+00, 8.4703062053E-01],
	[2.1020000000E+04, 1.6565538652E+01, 5.6457515469E+00, 3.8438271230E+00, 2.0094524559E+00, 8.4711395845E-01],
	[2.1025000000E+04, 1.6571534959E+01, 5.6456518989E+00, 3.8467943451E+00, 2.0103387175E+00, 8.4719725347E-01],
	[2.1030000000E+04, 1.6577532009E+01, 5.6455522762E+00, 3.8497631506E+00, 2.0112248919E+00, 8.4728050560E-01],
	[2.1035000000E+04, 1.6583529804E+01, 5.6454526791E+00, 3.8527335401E+00, 2.0121109790E+00, 8.4736371485E-01],
	[2.1040000000E+04, 1.6589528342E+01, 5.6453531073E+00, 3.8557055140E+00, 2.0129969785E+00, 8.4744688126E-01],
	[2.1045000000E+04, 1.6595527624E+01, 5.6452535610E+00, 3.8586790728E+00, 2.0138828902E+00, 8.4753000483E-01],
	[2.1050000000E+04, 1.6601544643E+01, 5.6451566993E+00, 3.8616542170E+00, 2.0147693029E+00, 8.4761308558E-01],
	[2.1055000000E+04, 1.6607575553E+01, 5.6450619176E+00, 3.8646309469E+00, 2.0156560838E+00, 8.4769612353E-01],
	[2.1060000000E+04, 1.6613607221E+01, 5.6449671600E+00, 3.8676092632E+00, 2.0165427776E+00, 8.4777911869E-01],
	[2.1065000000E+04, 1.6619639647E+01, 5.6448724265E+00, 3.8705891662E+00, 2.0174293842E+00, 8.4786207109E-01],
	[2.1070000000E+04, 1.6625672831E+01, 5.6447777170E+00, 3.8735706565E+00, 2.0183159032E+00, 8.4794498074E-01],
	[2.1075000000E+04, 1.6631706773E+01, 5.6446830316E+00, 3.8765537344E+00, 2.0192023346E+00, 8.4802784766E-01],
	[2.1080000000E+04, 1.6637741472E+01, 5.6445883703E+00, 3.8795384005E+00, 2.0200886781E+00, 8.4811067187E-01],
	[2.1085000000E+04, 1.6643776929E+01, 5.6444937329E+00, 3.8825246552E+00, 2.0209749335E+00, 8.4819345338E-01],
	[2.1090000000E+04, 1.6649813144E+01, 5.6443991197E+00, 3.8855124990E+00, 2.0218611007E+00, 8.4827619221E-01],
	[2.1095000000E+04, 1.6655850116E+01, 5.6443045304E+00, 3.8885019324E+00, 2.0227471793E+00, 8.4835888837E-01],
	[2.1100000000E+04, 1.6661887846E+01, 5.6442099651E+00, 3.8914929558E+00, 2.0236331694E+00, 8.4844154190E-01],
	[2.1105000000E+04, 1.6667926333E+01, 5.6441154238E+00, 3.8944855697E+00, 2.0245190705E+00, 8.4852415280E-01],
	[2.1110000000E+04, 1.6673965577E+01, 5.6440209065E+00, 3.8974797746E+00, 2.0254048826E+00, 8.4860672108E-01],
	[2.1115000000E+04, 1.6680005578E+01, 5.6439264132E+00, 3.9004755709E+00, 2.0262906055E+00, 8.4868924678E-01],
	[2.1120000000E+04, 1.6686046337E+01, 5.6438319438E+00, 3.9034729591E+00, 2.0271762388E+00, 8.4877172990E-01],
	[2.1125000000E+04, 1.6692087852E+01, 5.6437374984E+00, 3.9064719397E+00, 2.0280617826E+00, 8.4885417047E-01],
	[2.1130000000E+04, 1.6698130124E+01, 5.6436430768E+00, 3.9094725131E+00, 2.0289472365E+00, 8.4893656850E-01],
	[2.1135000000E+04, 1.6704173154E+01, 5.6435486793E+00, 3.9124746799E+00, 2.0298326003E+00, 8.4901892400E-01],
	[2.1140000000E+04, 1.6710216939E+01, 5.6434543056E+00, 3.9154784404E+00, 2.0307178739E+00, 8.4910123700E-01],
	[2.1145000000E+04, 1.6716261482E+01, 5.6433599558E+00, 3.9184837952E+00, 2.0316030571E+00, 8.4918350752E-01],
	[2.1150000000E+04, 1.6722306781E+01, 5.6432656299E+00, 3.9214907446E+00, 2.0324881496E+00, 8.4926573556E-01],
	[2.1155000000E+04, 1.6728352836E+01, 5.6431713279E+00, 3.9244992893E+00, 2.0333731514E+00, 8.4934792116E-01],
	[2.1160000000E+04, 1.6734399648E+01, 5.6430770497E+00, 3.9275094296E+00, 2.0342580621E+00, 8.4943006432E-01],
	[2.1165000000E+04, 1.6740447216E+01, 5.6429827954E+00, 3.9305211661E+00, 2.0351428816E+00, 8.4951216506E-01],
	[2.1170000000E+04, 1.6746495541E+01, 5.6428885649E+00, 3.9335344991E+00, 2.0360276096E+00, 8.4959422341E-01],
	[2.1175000000E+04, 1.6752544621E+01, 5.6427943582E+00, 3.9365494292E+00, 2.0369122461E+00, 8.4967623937E-01],
	[2.1180000000E+04, 1.6758594458E+01, 5.6427001754E+00, 3.9395659568E+00, 2.0377967908E+00, 8.4975821297E-01],
	[2.1185000000E+04, 1.6764645051E+01, 5.6426060164E+00, 3.9425840824E+00, 2.0386812435E+00, 8.4984014423E-01],
	[2.1190000000E+04, 1.6770696399E+01, 5.6425118811E+00, 3.9456038064E+00, 2.0395656040E+00, 8.4992203315E-01],
	[2.1195000000E+04, 1.6776748504E+01, 5.6424177696E+00, 3.9486251294E+00, 2.0404498721E+00, 8.5000387977E-01],
	[2.1200000000E+04, 1.6782801364E+01, 5.6423236819E+00, 3.9516480518E+00, 2.0413340476E+00, 8.5008568409E-01],
	[2.1205000000E+04, 1.6788854979E+01, 5.6422296180E+00, 3.9546725740E+00, 2.0422181304E+00, 8.5016744614E-01],
	[2.1210000000E+04, 1.6794909350E+01, 5.6421355778E+00, 3.9576986966E+00, 2.0431021202E+00, 8.5024916593E-01],
	[2.1215000000E+04, 1.6800964477E+01, 5.6420415613E+00, 3.9607264200E+00, 2.0439860169E+00, 8.5033084348E-01],
	[2.1220000000E+04, 1.6807020359E+01, 5.6419475686E+00, 3.9637557447E+00, 2.0448698202E+00, 8.5041247881E-01],
	[2.1225000000E+04, 1.6813076997E+01, 5.6418535995E+00, 3.9667866711E+00, 2.0457535299E+00, 8.5049407194E-01],
	[2.1230000000E+04, 1.6819134389E+01, 5.6417596542E+00, 3.9698191997E+00, 2.0466371460E+00, 8.5057562287E-01],
	[2.1235000000E+04, 1.6825192537E+01, 5.6416657326E+00, 3.9728533310E+00, 2.0475206681E+00, 8.5065713164E-01],
	[2.1240000000E+04, 1.6831251440E+01, 5.6415718346E+00, 3.9758890655E+00, 2.0484040961E+00, 8.5073859826E-01],
	[2.1245000000E+04, 1.6837311097E+01, 5.6414779603E+00, 3.9789264036E+00, 2.0492874298E+00, 8.5082002274E-01],
	[2.1250000000E+04, 1.6843371510E+01, 5.6413841096E+00, 3.9819653457E+00, 2.0501706690E+00, 8.5090140511E-01],
	[2.1255000000E+04, 1.6849432678E+01, 5.6412902826E+00, 3.9850058924E+00, 2.0510538135E+00, 8.5098274538E-01],
	[2.1260000000E+04, 1.6855494600E+01, 5.6411964792E+00, 3.9880480442E+00, 2.0519368631E+00, 8.5106404357E-01],
	[2.1265000000E+04, 1.6861557276E+01, 5.6411026994E+00, 3.9910918014E+00, 2.0528198176E+00, 8.5114529970E-01],
	[2.1270000000E+04, 1.6867620708E+01, 5.6410089433E+00, 3.9941371646E+00, 2.0537026769E+00, 8.5122651378E-01],
	[2.1275000000E+04, 1.6873684894E+01, 5.6409152107E+00, 3.9971841342E+00, 2.0545854407E+00, 8.5130768584E-01],
	[2.1280000000E+04, 1.6879749834E+01, 5.6408215017E+00, 4.0002327107E+00, 2.0554681089E+00, 8.5138881588E-01],
	[2.1285000000E+04, 1.6885815528E+01, 5.6407278163E+00, 4.0032828946E+00, 2.0563506812E+00, 8.5146990394E-01],
	[2.1290000000E+04, 1.6891881977E+01, 5.6406341544E+00, 4.0063346863E+00, 2.0572331575E+00, 8.5155095002E-01],
	[2.1295000000E+04, 1.6897949180E+01, 5.6405405161E+00, 4.0093880864E+00, 2.0581155376E+00, 8.5163195415E-01],
	[2.1300000000E+04, 1.6904017137E+01, 5.6404469014E+00, 4.0124430952E+00, 2.0589978213E+00, 8.5171291635E-01],
	[2.1305000000E+04, 1.6910085847E+01, 5.6403533101E+00, 4.0154997132E+00, 2.0598800084E+00, 8.5179383664E-01],
	[2.1310000000E+04, 1.6916155312E+01, 5.6402597424E+00, 4.0185579410E+00, 2.0607620987E+00, 8.5187471505E-01],
	[2.1315000000E+04, 1.6922225531E+01, 5.6401661982E+00, 4.0216177790E+00, 2.0616440920E+00, 8.5195555157E-01],
	[2.1320000000E+04, 1.6928296503E+01, 5.6400726774E+00, 4.0246792276E+00, 2.0625259882E+00, 8.5203634624E-01],
	[2.1325000000E+04, 1.6934368229E+01, 5.6399791802E+00, 4.0277422873E+00, 2.0634077870E+00, 8.5211709905E-01],
	[2.1330000000E+04, 1.6940440708E+01, 5.6398857064E+00, 4.0308069586E+00, 2.0642894883E+00, 8.5219781003E-01],
	[2.1335000000E+04, 1.6946513941E+01, 5.6397922561E+00, 4.0338732420E+00, 2.0651710918E+00, 8.5227847920E-01],
	[2.1340000000E+04, 1.6952587927E+01, 5.6396988292E+00, 4.0369411379E+00, 2.0660525974E+00, 8.5235910656E-01],
	[2.1345000000E+04, 1.6958662667E+01, 5.6396054257E+00, 4.0400106468E+00, 2.0669340049E+00, 8.5243969213E-01],
	[2.1350000000E+04, 1.6964738160E+01, 5.6395120457E+00, 4.0430817692E+00, 2.0678153141E+00, 8.5252023592E-01],
	[2.1355000000E+04, 1.6970814406E+01, 5.6394186891E+00, 4.0461545055E+00, 2.0686965248E+00, 8.5260073796E-01],
	[2.1360000000E+04, 1.6976891405E+01, 5.6393253559E+00, 4.0492288563E+00, 2.0695776369E+00, 8.5268119825E-01],
	[2.1365000000E+04, 1.6982969157E+01, 5.6392320461E+00, 4.0523048219E+00, 2.0704586501E+00, 8.5276161681E-01],
	[2.1370000000E+04, 1.6989047661E+01, 5.6391387596E+00, 4.0553824028E+00, 2.0713395642E+00, 8.5284199366E-01],
	[2.1375000000E+04, 1.6995126919E+01, 5.6390454966E+00, 4.0584615996E+00, 2.0722203791E+00, 8.5292232880E-01],
	[2.1380000000E+04, 1.7001206929E+01, 5.6389522568E+00, 4.0615424126E+00, 2.0731010946E+00, 8.5300262226E-01],
	[2.1385000000E+04, 1.7007287692E+01, 5.6388590405E+00, 4.0646248424E+00, 2.0739817105E+00, 8.5308287405E-01],
	[2.1390000000E+04, 1.7013393233E+01, 5.6387695521E+00, 4.0677088895E+00, 2.0748630855E+00, 8.5316308418E-01],
	[2.1395000000E+04, 1.7019505626E+01, 5.6386810248E+00, 4.0707945542E+00, 2.0757445793E+00, 8.5324325267E-01],
	[2.1400000000E+04, 1.7025618786E+01, 5.6385925195E+00, 4.0738818371E+00, 2.0766259743E+00, 8.5332337953E-01],
	[2.1405000000E+04, 1.7031732714E+01, 5.6385040363E+00, 4.0769707386E+00, 2.0775072702E+00, 8.5340346478E-01],
	[2.1410000000E+04, 1.7037847408E+01, 5.6384155752E+00, 4.0800612593E+00, 2.0783884668E+00, 8.5348350844E-01],
	[2.1415000000E+04, 1.7043962868E+01, 5.6383271361E+00, 4.0831533995E+00, 2.0792695639E+00, 8.5356351051E-01],
	[2.1420000000E+04, 1.7050079095E+01, 5.6382387190E+00, 4.0862471597E+00, 2.0801505614E+00, 8.5364347101E-01],
	[2.1425000000E+04, 1.7056196089E+01, 5.6381503239E+00, 4.0893425405E+00, 2.0810314592E+00, 8.5372338997E-01],
	[2.1430000000E+04, 1.7062313849E+01, 5.6380619509E+00, 4.0924395422E+00, 2.0819122569E+00, 8.5380326738E-01],
	[2.1435000000E+04, 1.7068432376E+01, 5.6379735998E+00, 4.0955381654E+00, 2.0827929544E+00, 8.5388310328E-01],
	[2.1440000000E+04, 1.7074551669E+01, 5.6378852708E+00, 4.0986384105E+00, 2.0836735515E+00, 8.5396289767E-01],
	[2.1445000000E+04, 1.7080671728E+01, 5.6377969637E+00, 4.1017402780E+00, 2.0845540481E+00, 8.5404265056E-01],
	[2.1450000000E+04, 1.7086792553E+01, 5.6377086786E+00, 4.1048437684E+00, 2.0854344439E+00, 8.5412236198E-01],
	[2.1455000000E+04, 1.7092914144E+01, 5.6376204155E+00, 4.1079488821E+00, 2.0863147389E+00, 8.5420203194E-01],
	[2.1460000000E+04, 1.7099036501E+01, 5.6375321743E+00, 4.1110556196E+00, 2.0871949327E+00, 8.5428166045E-01],
	[2.1465000000E+04, 1.7105159624E+01, 5.6374439550E+00, 4.1141639814E+00, 2.0880750252E+00, 8.5436124753E-01],
	[2.1470000000E+04, 1.7111283513E+01, 5.6373557577E+00, 4.1172739679E+00, 2.0889550162E+00, 8.5444079319E-01],
	[2.1475000000E+04, 1.7117408167E+01, 5.6372675823E+00, 4.1203855797E+00, 2.0898349056E+00, 8.5452029745E-01],
	[2.1480000000E+04, 1.7123533587E+01, 5.6371794288E+00, 4.1234988171E+00, 2.0907146931E+00, 8.5459976032E-01],
	[2.1485000000E+04, 1.7129659773E+01, 5.6370912972E+00, 4.1266136806E+00, 2.0915943786E+00, 8.5467918182E-01],
	[2.1490000000E+04, 1.7135786724E+01, 5.6370031875E+00, 4.1297301708E+00, 2.0924739619E+00, 8.5475856197E-01],
	[2.1495000000E+04, 1.7141914440E+01, 5.6369150996E+00, 4.1328482881E+00, 2.0933534428E+00, 8.5483790078E-01],
	[2.1500000000E+04, 1.7148042921E+01, 5.6368270336E+00, 4.1359680330E+00, 2.0942328211E+00, 8.5491719826E-01],
	[2.1505000000E+04, 1.7154172168E+01, 5.6367389895E+00, 4.1390894058E+00, 2.0951120967E+00, 8.5499645443E-01],
	[2.1510000000E+04, 1.7160302180E+01, 5.6366509672E+00, 4.1422124072E+00, 2.0959912693E+00, 8.5507566930E-01],
	[2.1515000000E+04, 1.7166432957E+01, 5.6365629667E+00, 4.1453370376E+00, 2.0968703389E+00, 8.5515484290E-01],
	[2.1520000000E+04, 1.7172564499E+01, 5.6364749881E+00, 4.1484632974E+00, 2.0977493051E+00, 8.5523397523E-01],
	[2.1525000000E+04, 1.7178696806E+01, 5.6363870313E+00, 4.1515911871E+00, 2.0986281678E+00, 8.5531306631E-01],
	[2.1530000000E+04, 1.7184829877E+01, 5.6362990963E+00, 4.1547207072E+00, 2.0995069268E+00, 8.5539211616E-01],
	[2.1535000000E+04, 1.7190963713E+01, 5.6362111830E+00, 4.1578518581E+00, 2.1003855821E+00, 8.5547112479E-01],
	[2.1540000000E+04, 1.7197098314E+01, 5.6361232916E+00, 4.1609846404E+00, 2.1012641332E+00, 8.5555009221E-01],
	[2.1545000000E+04, 1.7203233680E+01, 5.6360354219E+00, 4.1641190545E+00, 2.1021425802E+00, 8.5562901845E-01],
	[2.1550000000E+04, 1.7209369809E+01, 5.6359475740E+00, 4.1672551008E+00, 2.1030209228E+00, 8.5570790351E-01],
	[2.1555000000E+04, 1.7215506704E+01, 5.6358597478E+00, 4.1703927799E+00, 2.1038991608E+00, 8.5578674742E-01],
	[2.1560000000E+04, 1.7221644362E+01, 5.6357719434E+00, 4.1735320922E+00, 2.1047772941E+00, 8.5586555019E-01],
	[2.1565000000E+04, 1.7227782785E+01, 5.6356841606E+00, 4.1766730381E+00, 2.1056553224E+00, 8.5594431183E-01],
	[2.1570000000E+04, 1.7233921972E+01, 5.6355963997E+00, 4.1798156182E+00, 2.1065332456E+00, 8.5602303235E-01],
	[2.1575000000E+04, 1.7240061922E+01, 5.6355086604E+00, 4.1829598329E+00, 2.1074110636E+00, 8.5610171179E-01],
	[2.1580000000E+04, 1.7246202637E+01, 5.6354209428E+00, 4.1861056828E+00, 2.1082887760E+00, 8.5618035014E-01],
	[2.1585000000E+04, 1.7252344116E+01, 5.6353332469E+00, 4.1892531681E+00, 2.1091663828E+00, 8.5625894743E-01],
	[2.1590000000E+04, 1.7258486358E+01, 5.6352455727E+00, 4.1924022895E+00, 2.1100438838E+00, 8.5633750367E-01],
	[2.1595000000E+04, 1.7264629365E+01, 5.6351579201E+00, 4.1955530474E+00, 2.1109212788E+00, 8.5641601887E-01],
	[2.1600000000E+04, 1.7270773134E+01, 5.6350702892E+00, 4.1987054423E+00, 2.1117985676E+00, 8.5649449306E-01],
	[2.1605000000E+04, 1.7276917668E+01, 5.6349826799E+00, 4.2018594746E+00, 2.1126757501E+00, 8.5657292624E-01],
	[2.1610000000E+04, 1.7283062965E+01, 5.6348950923E+00, 4.2050151449E+00, 2.1135528259E+00, 8.5665131844E-01],
	[2.1615000000E+04, 1.7289209025E+01, 5.6348075263E+00, 4.2081724535E+00, 2.1144297951E+00, 8.5672966966E-01],
	[2.1620000000E+04, 1.7295355848E+01, 5.6347199819E+00, 4.2113314009E+00, 2.1153066574E+00, 8.5680797993E-01],
	[2.1625000000E+04, 1.7301503435E+01, 5.6346324591E+00, 4.2144919877E+00, 2.1161834126E+00, 8.5688624926E-01],
	[2.1630000000E+04, 1.7307651785E+01, 5.6345449580E+00, 4.2176542143E+00, 2.1170600605E+00, 8.5696447767E-01],
	[2.1635000000E+04, 1.7313800898E+01, 5.6344574783E+00, 4.2208180812E+00, 2.1179366011E+00, 8.5704266516E-01],
	[2.1640000000E+04, 1.7319950774E+01, 5.6343700203E+00, 4.2239835888E+00, 2.1188130340E+00, 8.5712081177E-01],
	[2.1645000000E+04, 1.7326101413E+01, 5.6342825838E+00, 4.2271507376E+00, 2.1196893591E+00, 8.5719891749E-01],
	[2.1650000000E+04, 1.7332252815E+01, 5.6341951689E+00, 4.2303195281E+00, 2.1205655762E+00, 8.5727698235E-01],
	[2.1655000000E+04, 1.7338404979E+01, 5.6341077755E+00, 4.2334899607E+00, 2.1214416853E+00, 8.5735500637E-01],
	[2.1660000000E+04, 1.7344557906E+01, 5.6340204037E+00, 4.2366620360E+00, 2.1223176860E+00, 8.5743298955E-01],
	[2.1665000000E+04, 1.7350711596E+01, 5.6339330534E+00, 4.2398357543E+00, 2.1231935782E+00, 8.5751093192E-01],
	[2.1670000000E+04, 1.7356866048E+01, 5.6338457246E+00, 4.2430111162E+00, 2.1240693617E+00, 8.5758883349E-01],
	[2.1675000000E+04, 1.7363021262E+01, 5.6337584172E+00, 4.2461881222E+00, 2.1249450364E+00, 8.5766669428E-01],
	[2.1680000000E+04, 1.7369177239E+01, 5.6336711314E+00, 4.2493667726E+00, 2.1258206021E+00, 8.5774451430E-01],
	[2.1685000000E+04, 1.7375333978E+01, 5.6335838671E+00, 4.2525470681E+00, 2.1266960586E+00, 8.5782229357E-01],
	[2.1690000000E+04, 1.7381491479E+01, 5.6334966242E+00, 4.2557290089E+00, 2.1275714057E+00, 8.5790003210E-01],
	[2.1695000000E+04, 1.7387649743E+01, 5.6334094028E+00, 4.2589125957E+00, 2.1284466433E+00, 8.5797772991E-01],
	[2.1700000000E+04, 1.7393808768E+01, 5.6333222028E+00, 4.2620978289E+00, 2.1293217712E+00, 8.5805538701E-01],
	[2.1705000000E+04, 1.7399968555E+01, 5.6332350243E+00, 4.2652847090E+00, 2.1301967891E+00, 8.5813300343E-01],
	[2.1710000000E+04, 1.7406129104E+01, 5.6331478672E+00, 4.2684732364E+00, 2.1310716970E+00, 8.5821057917E-01],
	[2.1715000000E+04, 1.7412290415E+01, 5.6330607315E+00, 4.2716634116E+00, 2.1319464946E+00, 8.5828811426E-01],
	[2.1720000000E+04, 1.7418452488E+01, 5.6329736172E+00, 4.2748552350E+00, 2.1328211819E+00, 8.5836560871E-01],
	[2.1725000000E+04, 1.7424615322E+01, 5.6328865244E+00, 4.2780487072E+00, 2.1336957585E+00, 8.5844306252E-01],
	[2.1730000000E+04, 1.7430778918E+01, 5.6327994529E+00, 4.2812438287E+00, 2.1345702244E+00, 8.5852047573E-01],
	[2.1735000000E+04, 1.7436971586E+01, 5.6327167051E+00, 4.2844405998E+00, 2.1354456223E+00, 8.5859784835E-01],
	[2.1740000000E+04, 1.7443166814E+01, 5.6326342487E+00, 4.2876390211E+00, 2.1363209760E+00, 8.5867518039E-01],
	[2.1745000000E+04, 1.7449362817E+01, 5.6325518125E+00, 4.2908390930E+00, 2.1371962198E+00, 8.5875247187E-01],
	[2.1750000000E+04, 1.7455559597E+01, 5.6324693965E+00, 4.2940408160E+00, 2.1380713533E+00, 8.5882972280E-01],
	[2.1755000000E+04, 1.7461757152E+01, 5.6323870006E+00, 4.2972441906E+00, 2.1389463764E+00, 8.5890693320E-01],
	[2.1760000000E+04, 1.7467955482E+01, 5.6323046249E+00, 4.3004492173E+00, 2.1398212891E+00, 8.5898410308E-01],
	[2.1765000000E+04, 1.7474154588E+01, 5.6322222692E+00, 4.3036558964E+00, 2.1406960910E+00, 8.5906123247E-01],
	[2.1770000000E+04, 1.7480354468E+01, 5.6321399338E+00, 4.3068642286E+00, 2.1415707820E+00, 8.5913832138E-01],
	[2.1775000000E+04, 1.7486555125E+01, 5.6320576184E+00, 4.3100742142E+00, 2.1424453619E+00, 8.5921536982E-01],
	[2.1780000000E+04, 1.7492756556E+01, 5.6319753231E+00, 4.3132858538E+00, 2.1433198306E+00, 8.5929237781E-01],
	[2.1785000000E+04, 1.7498958762E+01, 5.6318930479E+00, 4.3164991477E+00, 2.1441941879E+00, 8.5936934537E-01],
	[2.1790000000E+04, 1.7505161743E+01, 5.6318107928E+00, 4.3197140966E+00, 2.1450684337E+00, 8.5944627250E-01],
	[2.1795000000E+04, 1.7511365499E+01, 5.6317285577E+00, 4.3229307007E+00, 2.1459425677E+00, 8.5952315924E-01],
	[2.1800000000E+04, 1.7517570030E+01, 5.6316463428E+00, 4.3261489607E+00, 2.1468165897E+00, 8.5960000559E-01],
	[2.1805000000E+04, 1.7523775336E+01, 5.6315641479E+00, 4.3293688770E+00, 2.1476904997E+00, 8.5967681157E-01],
	[2.1810000000E+04, 1.7529981416E+01, 5.6314819730E+00, 4.3325904501E+00, 2.1485642974E+00, 8.5975357720E-01],
	[2.1815000000E+04, 1.7536188270E+01, 5.6313998182E+00, 4.3358136804E+00, 2.1494379827E+00, 8.5983030249E-01],
	[2.1820000000E+04, 1.7542395900E+01, 5.6313176833E+00, 4.3390385684E+00, 2.1503115553E+00, 8.5990698746E-01],
	[2.1825000000E+04, 1.7548604303E+01, 5.6312355685E+00, 4.3422651146E+00, 2.1511850152E+00, 8.5998363212E-01],
	[2.1830000000E+04, 1.7554813481E+01, 5.6311534738E+00, 4.3454933194E+00, 2.1520583622E+00, 8.6006023650E-01],
	[2.1835000000E+04, 1.7561023433E+01, 5.6310713990E+00, 4.3487231834E+00, 2.1529315960E+00, 8.6013680060E-01],
	[2.1840000000E+04, 1.7567234159E+01, 5.6309893442E+00, 4.3519547069E+00, 2.1538047166E+00, 8.6021332444E-01],
	[2.1845000000E+04, 1.7573445660E+01, 5.6309073093E+00, 4.3551878906E+00, 2.1546777237E+00, 8.6028980805E-01],
	[2.1850000000E+04, 1.7579657934E+01, 5.6308252945E+00, 4.3584227347E+00, 2.1555506171E+00, 8.6036625143E-01],
	[2.1855000000E+04, 1.7585870982E+01, 5.6307432996E+00, 4.3616592399E+00, 2.1564233968E+00, 8.6044265460E-01],
	[2.1860000000E+04, 1.7592084804E+01, 5.6306613246E+00, 4.3648974065E+00, 2.1572960625E+00, 8.6051901758E-01],
	[2.1865000000E+04, 1.7598299400E+01, 5.6305793696E+00, 4.3681372352E+00, 2.1581686141E+00, 8.6059534038E-01],
	[2.1870000000E+04, 1.7604514769E+01, 5.6304974346E+00, 4.3713787262E+00, 2.1590410514E+00, 8.6067162302E-01],
	[2.1875000000E+04, 1.7610730912E+01, 5.6304155194E+00, 4.3746218801E+00, 2.1599133742E+00, 8.6074786553E-01],
	[2.1880000000E+04, 1.7616947828E+01, 5.6303336242E+00, 4.3778666974E+00, 2.1607855824E+00, 8.6082406790E-01],
	[2.1885000000E+04, 1.7623165518E+01, 5.6302517488E+00, 4.3811131786E+00, 2.1616576758E+00, 8.6090023016E-01],
	[2.1890000000E+04, 1.7629383981E+01, 5.6301698934E+00, 4.3843613241E+00, 2.1625296542E+00, 8.6097635233E-01],
	[2.1895000000E+04, 1.7635603218E+01, 5.6300880579E+00, 4.3876111343E+00, 2.1634015174E+00, 8.6105243442E-01],
	[2.1900000000E+04, 1.7641823227E+01, 5.6300062422E+00, 4.3908626098E+00, 2.1642732654E+00, 8.6112847645E-01],
	[2.1905000000E+04, 1.7648044010E+01, 5.6299244464E+00, 4.3941157511E+00, 2.1651448978E+00, 8.6120447843E-01],
	[2.1910000000E+04, 1.7654265565E+01, 5.6298426704E+00, 4.3973705586E+00, 2.1660164147E+00, 8.6128044039E-01],
	[2.1915000000E+04, 1.7660487894E+01, 5.6297609143E+00, 4.4006270327E+00, 2.1668878157E+00, 8.6135636233E-01],
	[2.1920000000E+04, 1.7666710996E+01, 5.6296791780E+00, 4.4038851740E+00, 2.1677591007E+00, 8.6143224428E-01],
	[2.1925000000E+04, 1.7672934870E+01, 5.6295974616E+00, 4.4071449829E+00, 2.1686302696E+00, 8.6150808624E-01],
	[2.1930000000E+04, 1.7679159517E+01, 5.6295157649E+00, 4.4104064599E+00, 2.1695013222E+00, 8.6158388824E-01],
	[2.1935000000E+04, 1.7685384936E+01, 5.6294340881E+00, 4.4136696054E+00, 2.1703722583E+00, 8.6165965030E-01],
	[2.1940000000E+04, 1.7691611128E+01, 5.6293524311E+00, 4.4169344201E+00, 2.1712430778E+00, 8.6173537242E-01],
	[2.1945000000E+04, 1.7697838093E+01, 5.6292707939E+00, 4.4202009042E+00, 2.1721137805E+00, 8.6181105463E-01],
	[2.1950000000E+04, 1.7704065830E+01, 5.6291891764E+00, 4.4234690583E+00, 2.1729843662E+00, 8.6188669694E-01],
	[2.1955000000E+04, 1.7710294339E+01, 5.6291075788E+00, 4.4267388828E+00, 2.1738548347E+00, 8.6196229937E-01],
	[2.1960000000E+04, 1.7716523620E+01, 5.6290260009E+00, 4.4300103783E+00, 2.1747251859E+00, 8.6203786193E-01],
	[2.1965000000E+04, 1.7722753674E+01, 5.6289444427E+00, 4.4332835452E+00, 2.1755954197E+00, 8.6211338465E-01],
	[2.1970000000E+04, 1.7728984499E+01, 5.6288629043E+00, 4.4365583840E+00, 2.1764655358E+00, 8.6218886753E-01],
	[2.1975000000E+04, 1.7735216097E+01, 5.6287813856E+00, 4.4398348951E+00, 2.1773355342E+00, 8.6226431060E-01],
	[2.1980000000E+04, 1.7741448466E+01, 5.6286998867E+00, 4.4431130791E+00, 2.1782054145E+00, 8.6233971387E-01],
	[2.1985000000E+04, 1.7747681607E+01, 5.6286184074E+00, 4.4463929363E+00, 2.1790751768E+00, 8.6241507735E-01],
	[2.1990000000E+04, 1.7753915520E+01, 5.6285369479E+00, 4.4496744673E+00, 2.1799448207E+00, 8.6249040107E-01],
	[2.1995000000E+04, 1.7760150205E+01, 5.6284555081E+00, 4.4529576725E+00, 2.1808143462E+00, 8.6256568504E-01],
	[2.2000000000E+04, 1.7766385661E+01, 5.6283740880E+00, 4.4562425525E+00, 2.1816837530E+00, 8.6264092928E-01],
	[2.2005000000E+04, 1.7772621889E+01, 5.6282926875E+00, 4.4595291076E+00, 2.1825530411E+00, 8.6271613380E-01],
	[2.2010000000E+04, 1.7778858888E+01, 5.6282113067E+00, 4.4628173384E+00, 2.1834222102E+00, 8.6279129862E-01],
	[2.2015000000E+04, 1.7785096658E+01, 5.6281299456E+00, 4.4661072453E+00, 2.1842912602E+00, 8.6286642376E-01],
	[2.2020000000E+04, 1.7791335200E+01, 5.6280486041E+00, 4.4693988288E+00, 2.1851601910E+00, 8.6294150922E-01],
	[2.2025000000E+04, 1.7797574512E+01, 5.6279672823E+00, 4.4726920894E+00, 2.1860290023E+00, 8.6301655504E-01],
	[2.2030000000E+04, 1.7803814596E+01, 5.6278859801E+00, 4.4759870275E+00, 2.1868976940E+00, 8.6309156123E-01],
	[2.2035000000E+04, 1.7810055451E+01, 5.6278046975E+00, 4.4792836437E+00, 2.1877662659E+00, 8.6316652780E-01],
	[2.2040000000E+04, 1.7816297077E+01, 5.6277234346E+00, 4.4825819383E+00, 2.1886347179E+00, 8.6324145477E-01],
	[2.2045000000E+04, 1.7822539474E+01, 5.6276421912E+00, 4.4858819120E+00, 2.1895030498E+00, 8.6331634215E-01],
	[2.2050000000E+04, 1.7828782641E+01, 5.6275609675E+00, 4.4891835650E+00, 2.1903712615E+00, 8.6339118997E-01],
	[2.2055000000E+04, 1.7835026579E+01, 5.6274797633E+00, 4.4924868980E+00, 2.1912393527E+00, 8.6346599824E-01],
	[2.2060000000E+04, 1.7841271288E+01, 5.6273985787E+00, 4.4957919114E+00, 2.1921073234E+00, 8.6354076697E-01],
	[2.2065000000E+04, 1.7847516767E+01, 5.6273174137E+00, 4.4990986056E+00, 2.1929751733E+00, 8.6361549618E-01],
	[2.2070000000E+04, 1.7853763017E+01, 5.6272362683E+00, 4.5024069811E+00, 2.1938429023E+00, 8.6369018590E-01],
	[2.2075000000E+04, 1.7860010037E+01, 5.6271551424E+00, 4.5057170385E+00, 2.1947105103E+00, 8.6376483613E-01],
	[2.2080000000E+04, 1.7866257827E+01, 5.6270740360E+00, 4.5090287781E+00, 2.1955779971E+00, 8.6383944690E-01],
	[2.2085000000E+04, 1.7872535717E+01, 5.6269973418E+00, 4.5123422005E+00, 2.1964464747E+00, 8.6391401821E-01],
	[2.2090000000E+04, 1.7878815141E+01, 5.6269207783E+00, 4.5156573061E+00, 2.1973148605E+00, 8.6398855009E-01],
	[2.2095000000E+04, 1.7885095350E+01, 5.6268442331E+00, 4.5189740955E+00, 2.1981831258E+00, 8.6406304255E-01],
	[2.2100000000E+04, 1.7891376342E+01, 5.6267677063E+00, 4.5222925689E+00, 2.1990512704E+00, 8.6413749562E-01],
	[2.2105000000E+04, 1.7897658119E+01, 5.6266911979E+00, 4.5256127271E+00, 2.1999192943E+00, 8.6421190930E-01],
	[2.2110000000E+04, 1.7903940680E+01, 5.6266147078E+00, 4.5289345703E+00, 2.2007871973E+00, 8.6428628361E-01],
	[2.2115000000E+04, 1.7910224025E+01, 5.6265382361E+00, 4.5322580992E+00, 2.2016549792E+00, 8.6436061857E-01],
	[2.2120000000E+04, 1.7916508154E+01, 5.6264617826E+00, 4.5355833141E+00, 2.2025226398E+00, 8.6443491420E-01],
	[2.2125000000E+04, 1.7922793066E+01, 5.6263853475E+00, 4.5389102155E+00, 2.2033901790E+00, 8.6450917052E-01],
	[2.2130000000E+04, 1.7929078763E+01, 5.6263089307E+00, 4.5422388040E+00, 2.2042575966E+00, 8.6458338753E-01],
	[2.2135000000E+04, 1.7935365243E+01, 5.6262325323E+00, 4.5455690799E+00, 2.2051248925E+00, 8.6465756526E-01],
	[2.2140000000E+04, 1.7941652507E+01, 5.6261561521E+00, 4.5489010438E+00, 2.2059920665E+00, 8.6473170373E-01],
	[2.2145000000E+04, 1.7947940554E+01, 5.6260797901E+00, 4.5522346961E+00, 2.2068591185E+00, 8.6480580294E-01],
	[2.2150000000E+04, 1.7954229385E+01, 5.6260034465E+00, 4.5555700374E+00, 2.2077260482E+00, 8.6487986293E-01],
	[2.2155000000E+04, 1.7960518999E+01, 5.6259271211E+00, 4.5589070680E+00, 2.2085928556E+00, 8.6495388370E-01],
	[2.2160000000E+04, 1.7966809396E+01, 5.6258508140E+00, 4.5622457885E+00, 2.2094595404E+00, 8.6502786527E-01],
	[2.2165000000E+04, 1.7973100577E+01, 5.6257745251E+00, 4.5655861993E+00, 2.2103261025E+00, 8.6510180765E-01],
	[2.2170000000E+04, 1.7979392541E+01, 5.6256982545E+00, 4.5689283008E+00, 2.2111925419E+00, 8.6517571088E-01],
	[2.2175000000E+04, 1.7985685287E+01, 5.6256220021E+00, 4.5722720937E+00, 2.2120588582E+00, 8.6524957495E-01],
	[2.2180000000E+04, 1.7991978817E+01, 5.6255457679E+00, 4.5756175783E+00, 2.2129250513E+00, 8.6532339990E-01],
	[2.2185000000E+04, 1.7998273130E+01, 5.6254695520E+00, 4.5789647552E+00, 2.2137911212E+00, 8.6539718573E-01],
	[2.2190000000E+04, 1.8004568226E+01, 5.6253933543E+00, 4.5823136247E+00, 2.2146570675E+00, 8.6547093246E-01],
	[2.2195000000E+04, 1.8010864104E+01, 5.6253171747E+00, 4.5856641874E+00, 2.2155228903E+00, 8.6554464011E-01],
	[2.2200000000E+04, 1.8017160765E+01, 5.6252410134E+00, 4.5890164438E+00, 2.2163885892E+00, 8.6561830870E-01],
	[2.2205000000E+04, 1.8023458208E+01, 5.6251648702E+00, 4.5923703942E+00, 2.2172541642E+00, 8.6569193825E-01],
	[2.2210000000E+04, 1.8029756434E+01, 5.6250887452E+00, 4.5957260393E+00, 2.2181196151E+00, 8.6576552876E-01],
	[2.2215000000E+04, 1.8036055443E+01, 5.6250126384E+00, 4.5990833794E+00, 2.2189849418E+00, 8.6583908026E-01],
	[2.2220000000E+04, 1.8042355234E+01, 5.6249365497E+00, 4.6024424150E+00, 2.2198501441E+00, 8.6591259277E-01],
	[2.2225000000E+04, 1.8048655807E+01, 5.6248604792E+00, 4.6058031467E+00, 2.2207152217E+00, 8.6598606629E-01],
	[2.2230000000E+04, 1.8054957162E+01, 5.6247844268E+00, 4.6091655749E+00, 2.2215801747E+00, 8.6605950086E-01],
	[2.2235000000E+04, 1.8061259299E+01, 5.6247083925E+00, 4.6125297000E+00, 2.2224450028E+00, 8.6613289648E-01],
	[2.2240000000E+04, 1.8067562219E+01, 5.6246323764E+00, 4.6158955225E+00, 2.2233097058E+00, 8.6620625317E-01],
	[2.2245000000E+04, 1.8073865920E+01, 5.6245563784E+00, 4.6192630430E+00, 2.2241742837E+00, 8.6627957095E-01],
	[2.2250000000E+04, 1.8080170403E+01, 5.6244803985E+00, 4.6226322618E+00, 2.2250387362E+00, 8.6635284984E-01],
	[2.2255000000E+04, 1.8086475668E+01, 5.6244044366E+00, 4.6260031795E+00, 2.2259030633E+00, 8.6642608985E-01],
	[2.2260000000E+04, 1.8092781715E+01, 5.6243284929E+00, 4.6293757965E+00, 2.2267672646E+00, 8.6649929100E-01],
	[2.2265000000E+04, 1.8099088543E+01, 5.6242525673E+00, 4.6327501133E+00, 2.2276313402E+00, 8.6657245331E-01],
	[2.2270000000E+04, 1.8105396153E+01, 5.6241766597E+00, 4.6361261305E+00, 2.2284952898E+00, 8.6664557680E-01],
	[2.2275000000E+04, 1.8111704545E+01, 5.6241007702E+00, 4.6395038483E+00, 2.2293591133E+00, 8.6671866147E-01],
	[2.2280000000E+04, 1.8118013717E+01, 5.6240248988E+00, 4.6428832674E+00, 2.2302228105E+00, 8.6679170736E-01],
	[2.2285000000E+04, 1.8124323672E+01, 5.6239490454E+00, 4.6462643882E+00, 2.2310863813E+00, 8.6686471447E-01],
	[2.2290000000E+04, 1.8130634407E+01, 5.6238732100E+00, 4.6496472111E+00, 2.2319498256E+00, 8.6693768282E-01],
	[2.2295000000E+04, 1.8136945924E+01, 5.6237973927E+00, 4.6530317367E+00, 2.2328131431E+00, 8.6701061243E-01],
	[2.2300000000E+04, 1.8143258221E+01, 5.6237215934E+00, 4.6564179655E+00, 2.2336763337E+00, 8.6708350332E-01],
	[2.2305000000E+04, 1.8149571300E+01, 5.6236458121E+00, 4.6598058978E+00, 2.2345393973E+00, 8.6715635550E-01],
	[2.2310000000E+04, 1.8155885159E+01, 5.6235700488E+00, 4.6631955342E+00, 2.2354023337E+00, 8.6722916899E-01],
	[2.2315000000E+04, 1.8162199800E+01, 5.6234943035E+00, 4.6665868752E+00, 2.2362651428E+00, 8.6730194382E-01],
	[2.2320000000E+04, 1.8168515221E+01, 5.6234185762E+00, 4.6699799211E+00, 2.2371278244E+00, 8.6737467998E-01],
	[2.2325000000E+04, 1.8174831423E+01, 5.6233428669E+00, 4.6733746726E+00, 2.2379903783E+00, 8.6744737751E-01],
	[2.2330000000E+04, 1.8181148405E+01, 5.6232671756E+00, 4.6767711300E+00, 2.2388528045E+00, 8.6752003642E-01],
	[2.2335000000E+04, 1.8187466168E+01, 5.6231915022E+00, 4.6801692939E+00, 2.2397151027E+00, 8.6759265673E-01],
	[2.2340000000E+04, 1.8193784712E+01, 5.6231158468E+00, 4.6835691647E+00, 2.2405772728E+00, 8.6766523845E-01],
	[2.2345000000E+04, 1.8200104036E+01, 5.6230402093E+00, 4.6869707429E+00, 2.2414393146E+00, 8.6773778159E-01],
	[2.2350000000E+04, 1.8206424140E+01, 5.6229645898E+00, 4.6903740290E+00, 2.2423012281E+00, 8.6781028618E-01],
	[2.2355000000E+04, 1.8212745024E+01, 5.6228889882E+00, 4.6937790234E+00, 2.2431630130E+00, 8.6788275222E-01],
	[2.2360000000E+04, 1.8219066689E+01, 5.6228134045E+00, 4.6971857266E+00, 2.2440246692E+00, 8.6795517974E-01],
	[2.2365000000E+04, 1.8225389134E+01, 5.6227378388E+00, 4.7006075763E+00, 2.2448892613E+00, 8.6802756874E-01],
	[2.2370000000E+04, 1.8231712358E+01, 5.6226622909E+00, 4.7040333413E+00, 2.2457542228E+00, 8.6809991925E-01],
	[2.2375000000E+04, 1.8238036363E+01, 5.6225867610E+00, 4.7074608359E+00, 2.2466190547E+00, 8.6817223127E-01],
	[2.2380000000E+04, 1.8244361147E+01, 5.6225112489E+00, 4.7108900606E+00, 2.2474837569E+00, 8.6824450483E-01],
	[2.2385000000E+04, 1.8250686711E+01, 5.6224357547E+00, 4.7143210159E+00, 2.2483483291E+00, 8.6831673993E-01],
	[2.2390000000E+04, 1.8257013055E+01, 5.6223602784E+00, 4.7177537023E+00, 2.2492127713E+00, 8.6838893660E-01],
	[2.2395000000E+04, 1.8263340179E+01, 5.6222848200E+00, 4.7211881202E+00, 2.2500770832E+00, 8.6846109484E-01],
	[2.2400000000E+04, 1.8269668081E+01, 5.6222093794E+00, 4.7246242702E+00, 2.2509412648E+00, 8.6853321468E-01],
	[2.2405000000E+04, 1.8275996764E+01, 5.6221339567E+00, 4.7280621528E+00, 2.2518053158E+00, 8.6860529613E-01],
	[2.2410000000E+04, 1.8282326226E+01, 5.6220585518E+00, 4.7315017683E+00, 2.2526692361E+00, 8.6867733921E-01],
	[2.2415000000E+04, 1.8288656467E+01, 5.6219831647E+00, 4.7349431174E+00, 2.2535330256E+00, 8.6874934392E-01],
	[2.2420000000E+04, 1.8294987487E+01, 5.6219077955E+00, 4.7383862004E+00, 2.2543966841E+00, 8.6882131029E-01],
	[2.2425000000E+04, 1.8301319286E+01, 5.6218324441E+00, 4.7418310180E+00, 2.2552602115E+00, 8.6889323832E-01],
	[2.2430000000E+04, 1.8307651865E+01, 5.6217571105E+00, 4.7452775705E+00, 2.2561236076E+00, 8.6896512805E-01],
	[2.2435000000E+04, 1.8313985222E+01, 5.6216817947E+00, 4.7487258584E+00, 2.2569868722E+00, 8.6903697947E-01],
	[2.2440000000E+04, 1.8320345906E+01, 5.6216104154E+00, 4.7521758823E+00, 2.2578510407E+00, 8.6910879261E-01],
	[2.2445000000E+04, 1.8326710897E+01, 5.6215395718E+00, 4.7556276426E+00, 2.2587152156E+00, 8.6918056748E-01],
	[2.2450000000E+04, 1.8333076682E+01, 5.6214687449E+00, 4.7590811399E+00, 2.2595792599E+00, 8.6925230410E-01],
	[2.2455000000E+04, 1.8339443259E+01, 5.6213979346E+00, 4.7625363745E+00, 2.2604431734E+00, 8.6932400248E-01],
	[2.2460000000E+04, 1.8345810628E+01, 5.6213271410E+00, 4.7659933470E+00, 2.2613069560E+00, 8.6939566264E-01],
	[2.2465000000E+04, 1.8352178791E+01, 5.6212563640E+00, 4.7694520579E+00, 2.2621706074E+00, 8.6946728460E-01],
	[2.2470000000E+04, 1.8358547746E+01, 5.6211856037E+00, 4.7729125076E+00, 2.2630341276E+00, 8.6953886836E-01],
	[2.2475000000E+04, 1.8364917493E+01, 5.6211148600E+00, 4.7763746967E+00, 2.2638975164E+00, 8.6961041394E-01],
	[2.2480000000E+04, 1.8371288033E+01, 5.6210441329E+00, 4.7798386257E+00, 2.2647607736E+00, 8.6968192137E-01],
	[2.2485000000E+04, 1.8377659365E+01, 5.6209734225E+00, 4.7833042949E+00, 2.2656238992E+00, 8.6975339064E-01],
	[2.2490000000E+04, 1.8384031490E+01, 5.6209027287E+00, 4.7867717049E+00, 2.2664868929E+00, 8.6982482179E-01],
	[2.2495000000E+04, 1.8390404407E+01, 5.6208320514E+00, 4.7902408563E+00, 2.2673497546E+00, 8.6989621483E-01],
	[2.2500000000E+04, 1.8396778115E+01, 5.6207613908E+00, 4.7937117494E+00, 2.2682124841E+00, 8.6996756977E-01],
	[2.2505000000E+04, 1.8403152616E+01, 5.6206907467E+00, 4.7971843848E+00, 2.2690750814E+00, 8.7003888662E-01],
	[2.2510000000E+04, 1.8409527909E+01, 5.6206201193E+00, 4.8006587629E+00, 2.2699375462E+00, 8.7011016541E-01],
	[2.2515000000E+04, 1.8415903994E+01, 5.6205495084E+00, 4.8041348843E+00, 2.2707998784E+00, 8.7018140614E-01],
	[2.2520000000E+04, 1.8422280870E+01, 5.6204789141E+00, 4.8076127494E+00, 2.2716620779E+00, 8.7025260884E-01],
	[2.2525000000E+04, 1.8428658538E+01, 5.6204083363E+00, 4.8110923587E+00, 2.2725241446E+00, 8.7032377352E-01],
	[2.2530000000E+04, 1.8435036998E+01, 5.6203377751E+00, 4.8145737127E+00, 2.2733860781E+00, 8.7039490019E-01],
	[2.2535000000E+04, 1.8441416249E+01, 5.6202672304E+00, 4.8180568119E+00, 2.2742478786E+00, 8.7046598887E-01],
	[2.2540000000E+04, 1.8447796292E+01, 5.6201967023E+00, 4.8215416567E+00, 2.2751095457E+00, 8.7053703958E-01],
	[2.2545000000E+04, 1.8454177126E+01, 5.6201261907E+00, 4.8250282478E+00, 2.2759710793E+00, 8.7060805233E-01],
	[2.2550000000E+04, 1.8460558752E+01, 5.6200556956E+00, 4.8285165854E+00, 2.2768324793E+00, 8.7067902714E-01],
	[2.2555000000E+04, 1.8466941169E+01, 5.6199852170E+00, 4.8320066702E+00, 2.2776937455E+00, 8.7074996402E-01],
	[2.2560000000E+04, 1.8473324377E+01, 5.6199147549E+00, 4.8354985027E+00, 2.2785548779E+00, 8.7082086299E-01],
	[2.2565000000E+04, 1.8479708376E+01, 5.6198443093E+00, 4.8389920832E+00, 2.2794158761E+00, 8.7089172406E-01],
	[2.2570000000E+04, 1.8486093166E+01, 5.6197738803E+00, 4.8424874123E+00, 2.2802767402E+00, 8.7096254725E-01],
	[2.2575000000E+04, 1.8492478747E+01, 5.6197034677E+00, 4.8459844905E+00, 2.2811374700E+00, 8.7103333258E-01],
	[2.2580000000E+04, 1.8498865119E+01, 5.6196330715E+00, 4.8494833183E+00, 2.2819980652E+00, 8.7110408006E-01],
	[2.2585000000E+04, 1.8505252282E+01, 5.6195626919E+00, 4.8529838961E+00, 2.2828585258E+00, 8.7117478970E-01],
	[2.2590000000E+04, 1.8511640235E+01, 5.6194923287E+00, 4.8564862245E+00, 2.2837188517E+00, 8.7124546153E-01],
	[2.2595000000E+04, 1.8518028979E+01, 5.6194219819E+00, 4.8599903039E+00, 2.2845790426E+00, 8.7131609556E-01],
	[2.2600000000E+04, 1.8524418514E+01, 5.6193516516E+00, 4.8634961348E+00, 2.2854390984E+00, 8.7138669180E-01],
	[2.2605000000E+04, 1.8530808839E+01, 5.6192813378E+00, 4.8670037178E+00, 2.2862990191E+00, 8.7145725027E-01],
	[2.2610000000E+04, 1.8537199954E+01, 5.6192110404E+00, 4.8705130532E+00, 2.2871588043E+00, 8.7152777098E-01],
	[2.2615000000E+04, 1.8543591860E+01, 5.6191407594E+00, 4.8740241416E+00, 2.2880184541E+00, 8.7159825396E-01],
	[2.2620000000E+04, 1.8549984556E+01, 5.6190704948E+00, 4.8775369834E+00, 2.2888779682E+00, 8.7166869921E-01],
	[2.2625000000E+04, 1.8556378043E+01, 5.6190002466E+00, 4.8810515792E+00, 2.2897373465E+00, 8.7173910676E-01],
	[2.2630000000E+04, 1.8562772319E+01, 5.6189300148E+00, 4.8845679295E+00, 2.2905965889E+00, 8.7180947661E-01],
	[2.2635000000E+04, 1.8569167385E+01, 5.6188597994E+00, 4.8880860347E+00, 2.2914556953E+00, 8.7187980879E-01],
	[2.2640000000E+04, 1.8575563242E+01, 5.6187896004E+00, 4.8916058953E+00, 2.2923146654E+00, 8.7195010331E-01],
	[2.2645000000E+04, 1.8581959888E+01, 5.6187194178E+00, 4.8951275118E+00, 2.2931734991E+00, 8.7202036019E-01],
	[2.2650000000E+04, 1.8588357324E+01, 5.6186492515E+00, 4.8986508847E+00, 2.2940321964E+00, 8.7209057943E-01],
	[2.2655000000E+04, 1.8594755549E+01, 5.6185791016E+00, 4.9021760145E+00, 2.2948907570E+00, 8.7216076107E-01],
	[2.2660000000E+04, 1.8601154565E+01, 5.6185089681E+00, 4.9057029016E+00, 2.2957491808E+00, 8.7223090511E-01],
	[2.2665000000E+04, 1.8607554370E+01, 5.6184388509E+00, 4.9092315466E+00, 2.2966074676E+00, 8.7230101157E-01],
	[2.2670000000E+04, 1.8613954964E+01, 5.6183687501E+00, 4.9127619499E+00, 2.2974656174E+00, 8.7237108046E-01],
	[2.2675000000E+04, 1.8620356348E+01, 5.6182986656E+00, 4.9162941121E+00, 2.2983236300E+00, 8.7244111181E-01],
	[2.2680000000E+04, 1.8626758521E+01, 5.6182285974E+00, 4.9198280336E+00, 2.2991815053E+00, 8.7251110562E-01],
	[2.2685000000E+04, 1.8633161483E+01, 5.6181585455E+00, 4.9233637149E+00, 2.3000392430E+00, 8.7258106192E-01],
	[2.2690000000E+04, 1.8639565235E+01, 5.6180885100E+00, 4.9269011564E+00, 2.3008968431E+00, 8.7265098071E-01],
	[2.2695000000E+04, 1.8645969775E+01, 5.6180184907E+00, 4.9304403588E+00, 2.3017543054E+00, 8.7272086202E-01],
	[2.2700000000E+04, 1.8652375105E+01, 5.6179484878E+00, 4.9339813224E+00, 2.3026116298E+00, 8.7279070586E-01],
	[2.2705000000E+04, 1.8658781224E+01, 5.6178785011E+00, 4.9375240478E+00, 2.3034688161E+00, 8.7286051225E-01],
	[2.2710000000E+04, 1.8665188131E+01, 5.6178085307E+00, 4.9410685354E+00, 2.3043258642E+00, 8.7293028120E-01],
	[2.2715000000E+04, 1.8671595827E+01, 5.6177385766E+00, 4.9446147858E+00, 2.3051827740E+00, 8.7300001273E-01],
	[2.2720000000E+04, 1.8678004312E+01, 5.6176686388E+00, 4.9481627993E+00, 2.3060395453E+00, 8.7306970686E-01],
	[2.2725000000E+04, 1.8684413586E+01, 5.6175987172E+00, 4.9517125766E+00, 2.3068961780E+00, 8.7313936359E-01],
	[2.2730000000E+04, 1.8690823648E+01, 5.6175288119E+00, 4.9552641181E+00, 2.3077526719E+00, 8.7320898296E-01],
	[2.2735000000E+04, 1.8697234499E+01, 5.6174589228E+00, 4.9588174242E+00, 2.3086090269E+00, 8.7327856496E-01],
	[2.2740000000E+04, 1.8703646138E+01, 5.6173890500E+00, 4.9623724956E+00, 2.3094652429E+00, 8.7334810963E-01],
	[2.2745000000E+04, 1.8710058565E+01, 5.6173191933E+00, 4.9659293325E+00, 2.3103213197E+00, 8.7341761697E-01],
	[2.2750000000E+04, 1.8716471781E+01, 5.6172493530E+00, 4.9694879357E+00, 2.3111772571E+00, 8.7348708700E-01],
	[2.2755000000E+04, 1.8722885784E+01, 5.6171795288E+00, 4.9730483054E+00, 2.3120330551E+00, 8.7355651973E-01],
	[2.2760000000E+04, 1.8729300576E+01, 5.6171097208E+00, 4.9766104423E+00, 2.3128887136E+00, 8.7362591520E-01],
	[2.2765000000E+04, 1.8735716156E+01, 5.6170399291E+00, 4.9801743468E+00, 2.3137442322E+00, 8.7369527340E-01],
	[2.2770000000E+04, 1.8742132524E+01, 5.6169701535E+00, 4.9837400194E+00, 2.3145996110E+00, 8.7376459435E-01],
	[2.2775000000E+04, 1.8748549680E+01, 5.6169003941E+00, 4.9873074606E+00, 2.3154548498E+00, 8.7383387808E-01],
	[2.2780000000E+04, 1.8754967624E+01, 5.6168306509E+00, 4.9908766709E+00, 2.3163099485E+00, 8.7390312459E-01],
	[2.2785000000E+04, 1.8761386355E+01, 5.6167609239E+00, 4.9944476507E+00, 2.3171649068E+00, 8.7397233391E-01],
	[2.2790000000E+04, 1.8767805874E+01, 5.6166912130E+00, 4.9980204006E+00, 2.3180197247E+00, 8.7404150605E-01],
	[2.2795000000E+04, 1.8774226180E+01, 5.6166215183E+00, 5.0015949210E+00, 2.3188744021E+00, 8.7411064102E-01],
	[2.2800000000E+04, 1.8780666702E+01, 5.6165546665E+00, 5.0051712124E+00, 2.3197297174E+00, 8.7417973885E-01],
	[2.2805000000E+04, 1.8787118642E+01, 5.6164893749E+00, 5.0087492754E+00, 2.3205853183E+00, 8.7424879954E-01],
	[2.2810000000E+04, 1.8793571383E+01, 5.6164240984E+00, 5.0123291104E+00, 2.3214407795E+00, 8.7431782312E-01],
	[2.2815000000E+04, 1.8800024925E+01, 5.6163588369E+00, 5.0159107178E+00, 2.3222961008E+00, 8.7438680960E-01],
	[2.2820000000E+04, 1.8806479268E+01, 5.6162935905E+00, 5.0194940983E+00, 2.3231512821E+00, 8.7445575900E-01],
	[2.2825000000E+04, 1.8812934412E+01, 5.6162283592E+00, 5.0230792522E+00, 2.3240063232E+00, 8.7452467132E-01],
	[2.2830000000E+04, 1.8819390358E+01, 5.6161631429E+00, 5.0266661801E+00, 2.3248612240E+00, 8.7459354660E-01],
	[2.2835000000E+04, 1.8825847104E+01, 5.6160979416E+00, 5.0302548824E+00, 2.3257159843E+00, 8.7466238485E-01],
	[2.2840000000E+04, 1.8832304651E+01, 5.6160327554E+00, 5.0338453596E+00, 2.3265706041E+00, 8.7473118607E-01],
	[2.2845000000E+04, 1.8838762999E+01, 5.6159675842E+00, 5.0374376123E+00, 2.3274250832E+00, 8.7479995029E-01],
	[2.2850000000E+04, 1.8845222148E+01, 5.6159024280E+00, 5.0410316409E+00, 2.3282794214E+00, 8.7486867753E-01],
	[2.2855000000E+04, 1.8851682097E+01, 5.6158372869E+00, 5.0446274459E+00, 2.3291336186E+00, 8.7493736780E-01],
	[2.2860000000E+04, 1.8858142847E+01, 5.6157721607E+00, 5.0482250278E+00, 2.3299876747E+00, 8.7500602111E-01],
	[2.2865000000E+04, 1.8864604398E+01, 5.6157070495E+00, 5.0518243870E+00, 2.3308415896E+00, 8.7507463749E-01],
	[2.2870000000E+04, 1.8871066749E+01, 5.6156419534E+00, 5.0554255242E+00, 2.3316953630E+00, 8.7514321694E-01],
	[2.2875000000E+04, 1.8877529900E+01, 5.6155768722E+00, 5.0590284397E+00, 2.3325489950E+00, 8.7521175949E-01],
	[2.2880000000E+04, 1.8883993852E+01, 5.6155118060E+00, 5.0626331340E+00, 2.3334024852E+00, 8.7528026515E-01],
	[2.2885000000E+04, 1.8890458604E+01, 5.6154467547E+00, 5.0662396077E+00, 2.3342558337E+00, 8.7534873394E-01],
	[2.2890000000E+04, 1.8896924156E+01, 5.6153817184E+00, 5.0698478612E+00, 2.3351090403E+00, 8.7541716588E-01],
	[2.2895000000E+04, 1.8903390508E+01, 5.6153166971E+00, 5.0734578950E+00, 2.3359621048E+00, 8.7548556097E-01],
	[2.2900000000E+04, 1.8909857660E+01, 5.6152516907E+00, 5.0770697096E+00, 2.3368150271E+00, 8.7555391925E-01],
	[2.2905000000E+04, 1.8916325612E+01, 5.6151866993E+00, 5.0806833055E+00, 2.3376678070E+00, 8.7562224071E-01],
	[2.2910000000E+04, 1.8922794363E+01, 5.6151217228E+00, 5.0842986831E+00, 2.3385204445E+00, 8.7569052538E-01],
	[2.2915000000E+04, 1.8929263915E+01, 5.6150567613E+00, 5.0879158431E+00, 2.3393729394E+00, 8.7575877328E-01],
	[2.2920000000E+04, 1.8935734266E+01, 5.6149918146E+00, 5.0915347858E+00, 2.3402252916E+00, 8.7582698443E-01],
	[2.2925000000E+04, 1.8942205417E+01, 5.6149268829E+00, 5.0951555117E+00, 2.3410775009E+00, 8.7589515883E-01],
	[2.2930000000E+04, 1.8948677367E+01, 5.6148619661E+00, 5.0987780214E+00, 2.3419295672E+00, 8.7596329650E-01],
	[2.2935000000E+04, 1.8955150117E+01, 5.6147970642E+00, 5.1024023153E+00, 2.3427814904E+00, 8.7603139747E-01],
	[2.2940000000E+04, 1.8961623666E+01, 5.6147321772E+00, 5.1060283939E+00, 2.3436332703E+00, 8.7609946174E-01],
	[2.2945000000E+04, 1.8968098014E+01, 5.6146673051E+00, 5.1096562577E+00, 2.3444849068E+00, 8.7616748934E-01],
	[2.2950000000E+04, 1.8974573162E+01, 5.6146024479E+00, 5.1132859072E+00, 2.3453363998E+00, 8.7623548028E-01],
	[2.2955000000E+04, 1.8981049109E+01, 5.6145376055E+00, 5.1169173429E+00, 2.3461877492E+00, 8.7630343458E-01],
	[2.2960000000E+04, 1.8987525855E+01, 5.6144727781E+00, 5.1205505652E+00, 2.3470389548E+00, 8.7637135225E-01],
	[2.2965000000E+04, 1.8994003399E+01, 5.6144079654E+00, 5.1241855747E+00, 2.3478900164E+00, 8.7643923331E-01],
	[2.2970000000E+04, 1.9000481743E+01, 5.6143431677E+00, 5.1278223719E+00, 2.3487409340E+00, 8.7650707777E-01],
	[2.2975000000E+04, 1.9006960886E+01, 5.6142783848E+00, 5.1314609572E+00, 2.3495917074E+00, 8.7657488566E-01],
	[2.2980000000E+04, 1.9013440827E+01, 5.6142136167E+00, 5.1351013311E+00, 2.3504423365E+00, 8.7664265699E-01],
	[2.2985000000E+04, 1.9019921567E+01, 5.6141488635E+00, 5.1387434941E+00, 2.3512928211E+00, 8.7671039177E-01],
	[2.2990000000E+04, 1.9026403106E+01, 5.6140841251E+00, 5.1423874468E+00, 2.3521431612E+00, 8.7677809003E-01],
	[2.2995000000E+04, 1.9032885443E+01, 5.6140194015E+00, 5.1460331895E+00, 2.3529933566E+00, 8.7684575177E-01],
	[2.3000000000E+04, 1.9039368579E+01, 5.6139546928E+00, 5.1496807228E+00, 2.3538434071E+00, 8.7691337702E-01],
	[2.3005000000E+04, 1.9045852513E+01, 5.6138899988E+00, 5.1533300472E+00, 2.3546933127E+00, 8.7698096579E-01],
	[2.3010000000E+04, 1.9052337245E+01, 5.6138253197E+00, 5.1569811632E+00, 2.3555430731E+00, 8.7704851809E-01],
	[2.3015000000E+04, 1.9058822776E+01, 5.6137606554E+00, 5.1606340712E+00, 2.3563926884E+00, 8.7711603395E-01],
	[2.3020000000E+04, 1.9065309105E+01, 5.6136960058E+00, 5.1642887717E+00, 2.3572421583E+00, 8.7718351339E-01],
	[2.3025000000E+04, 1.9071796232E+01, 5.6136313711E+00, 5.1679452653E+00, 2.3580914827E+00, 8.7725095641E-01],
	[2.3030000000E+04, 1.9078284157E+01, 5.6135667511E+00, 5.1716035524E+00, 2.3589406614E+00, 8.7731836303E-01],
	[2.3035000000E+04, 1.9084772880E+01, 5.6135021459E+00, 5.1752636335E+00, 2.3597896945E+00, 8.7738573327E-01],
	[2.3040000000E+04, 1.9091262400E+01, 5.6134375554E+00, 5.1789255091E+00, 2.3606385817E+00, 8.7745306715E-01],
	[2.3045000000E+04, 1.9097752719E+01, 5.6133729797E+00, 5.1825891797E+00, 2.3614873228E+00, 8.7752036469E-01],
	[2.3050000000E+04, 1.9104243835E+01, 5.6133084188E+00, 5.1862546458E+00, 2.3623359179E+00, 8.7758762589E-01],
	[2.3055000000E+04, 1.9110735749E+01, 5.6132438726E+00, 5.1899219078E+00, 2.3631843667E+00, 8.7765485079E-01],
	[2.3060000000E+04, 1.9117228461E+01, 5.6131793412E+00, 5.1935909663E+00, 2.3640326691E+00, 8.7772203938E-01],
	[2.3065000000E+04, 1.9123721970E+01, 5.6131148244E+00, 5.1972618218E+00, 2.3648808250E+00, 8.7778919169E-01],
	[2.3070000000E+04, 1.9130216276E+01, 5.6130503224E+00, 5.2009344747E+00, 2.3657288342E+00, 8.7785630775E-01],
	[2.3075000000E+04, 1.9136711380E+01, 5.6129858352E+00, 5.2046089255E+00, 2.3665766967E+00, 8.7792338755E-01],
	[2.3080000000E+04, 1.9143207281E+01, 5.6129213626E+00, 5.2082851747E+00, 2.3674244123E+00, 8.7799043112E-01],
	[2.3085000000E+04, 1.9149703979E+01, 5.6128569048E+00, 5.2119632228E+00, 2.3682719809E+00, 8.7805743848E-01],
	[2.3090000000E+04, 1.9156201474E+01, 5.6127924616E+00, 5.2156430704E+00, 2.3691194023E+00, 8.7812440964E-01],
	[2.3095000000E+04, 1.9162699767E+01, 5.6127280331E+00, 5.2193247178E+00, 2.3699666764E+00, 8.7819134462E-01],
	[2.3100000000E+04, 1.9169198856E+01, 5.6126636194E+00, 5.2230081656E+00, 2.3708138031E+00, 8.7825824344E-01],
	[2.3105000000E+04, 1.9175698742E+01, 5.6125992203E+00, 5.2266934143E+00, 2.3716607823E+00, 8.7832510611E-01],
	[2.3110000000E+04, 1.9182199425E+01, 5.6125348358E+00, 5.2303804643E+00, 2.3725076139E+00, 8.7839193265E-01],
	[2.3115000000E+04, 1.9188700905E+01, 5.6124704661E+00, 5.2340693162E+00, 2.3733542977E+00, 8.7845872308E-01],
	[2.3120000000E+04, 1.9195203181E+01, 5.6124061110E+00, 5.2377599704E+00, 2.3742008335E+00, 8.7852547740E-01],
	[2.3125000000E+04, 1.9201706255E+01, 5.6123417705E+00, 5.2414524274E+00, 2.3750472213E+00, 8.7859219565E-01],
	[2.3130000000E+04, 1.9208210124E+01, 5.6122774447E+00, 5.2451466878E+00, 2.3758934610E+00, 8.7865887783E-01],
	[2.3135000000E+04, 1.9214714790E+01, 5.6122131336E+00, 5.2488427519E+00, 2.3767395524E+00, 8.7872552397E-01],
	[2.3140000000E+04, 1.9221220252E+01, 5.6121488371E+00, 5.2525406204E+00, 2.3775854953E+00, 8.7879213407E-01],
	[2.3145000000E+04, 1.9227726511E+01, 5.6120845552E+00, 5.2562402937E+00, 2.3784312897E+00, 8.7885870816E-01],
	[2.3150000000E+04, 1.9234233566E+01, 5.6120202879E+00, 5.2599417722E+00, 2.3792769355E+00, 8.7892524625E-01],
	[2.3155000000E+04, 1.9240741417E+01, 5.6119560352E+00, 5.2636450565E+00, 2.3801224325E+00, 8.7899174836E-01],
	[2.3160000000E+04, 1.9247250064E+01, 5.6118917972E+00, 5.2673501470E+00, 2.3809677806E+00, 8.7905821451E-01],
	[2.3165000000E+04, 1.9253766931E+01, 5.6118286385E+00, 5.2710570443E+00, 2.3818132850E+00, 8.7912464471E-01],
	[2.3170000000E+04, 1.9260307209E+01, 5.6117687361E+00, 5.2747657489E+00, 2.3826595710E+00, 8.7919103898E-01],
	[2.3175000000E+04, 1.9266848296E+01, 5.6117088472E+00, 5.2784762611E+00, 2.3835057090E+00, 8.7925739733E-01],
	[2.3180000000E+04, 1.9273390193E+01, 5.6116489719E+00, 5.2821885816E+00, 2.3843516987E+00, 8.7932371979E-01],
	[2.3185000000E+04, 1.9279932899E+01, 5.6115891101E+00, 5.2859027108E+00, 2.3851975401E+00, 8.7939000637E-01],
	[2.3190000000E+04, 1.9286476415E+01, 5.6115292618E+00, 5.2896186492E+00, 2.3860432331E+00, 8.7945625708E-01],
	[2.3195000000E+04, 1.9293020740E+01, 5.6114694271E+00, 5.2933363973E+00, 2.3868887774E+00, 8.7952247194E-01],
	[2.3200000000E+04, 1.9299565875E+01, 5.6114096060E+00, 5.2970559556E+00, 2.3877341730E+00, 8.7958865098E-01],
	[2.3205000000E+04, 1.9306111819E+01, 5.6113497984E+00, 5.3007773246E+00, 2.3885794198E+00, 8.7965479420E-01],
	[2.3210000000E+04, 1.9312658572E+01, 5.6112900042E+00, 5.3045005047E+00, 2.3894245177E+00, 8.7972090163E-01],
	[2.3215000000E+04, 1.9319206134E+01, 5.6112302237E+00, 5.3082254964E+00, 2.3902694665E+00, 8.7978697327E-01],
	[2.3220000000E+04, 1.9325754505E+01, 5.6111704566E+00, 5.3119523004E+00, 2.3911142660E+00, 8.7985300915E-01],
	[2.3225000000E+04, 1.9332303686E+01, 5.6111107030E+00, 5.3156809169E+00, 2.3919589163E+00, 8.7991900929E-01],
	[2.3230000000E+04, 1.9338853675E+01, 5.6110509629E+00, 5.3194113466E+00, 2.3928034171E+00, 8.7998497369E-01],
	[2.3235000000E+04, 1.9345404473E+01, 5.6109912363E+00, 5.3231435899E+00, 2.3936477683E+00, 8.8005090238E-01],
	[2.3240000000E+04, 1.9351956080E+01, 5.6109315232E+00, 5.3268776472E+00, 2.3944919699E+00, 8.8011679538E-01],
	[2.3245000000E+04, 1.9358508495E+01, 5.6108718236E+00, 5.3306135192E+00, 2.3953360216E+00, 8.8018265269E-01],
	[2.3250000000E+04, 1.9365061719E+01, 5.6108121375E+00, 5.3343512063E+00, 2.3961799234E+00, 8.8024847435E-01],
	[2.3255000000E+04, 1.9371615752E+01, 5.6107524648E+00, 5.3380907090E+00, 2.3970236752E+00, 8.8031426035E-01],
	[2.3260000000E+04, 1.9378170593E+01, 5.6106928056E+00, 5.3418320277E+00, 2.3978672767E+00, 8.8038001073E-01],
	[2.3265000000E+04, 1.9384726242E+01, 5.6106331599E+00, 5.3455751630E+00, 2.3987107280E+00, 8.8044572550E-01],
	[2.3270000000E+04, 1.9391282700E+01, 5.6105735276E+00, 5.3493201153E+00, 2.3995540289E+00, 8.8051140467E-01],
	[2.3275000000E+04, 1.9397839966E+01, 5.6105139087E+00, 5.3530668852E+00, 2.4003971792E+00, 8.8057704826E-01],
	[2.3280000000E+04, 1.9404398040E+01, 5.6104543033E+00, 5.3568154731E+00, 2.4012401788E+00, 8.8064265629E-01],
	[2.3285000000E+04, 1.9410956922E+01, 5.6103947113E+00, 5.3605658795E+00, 2.4020830277E+00, 8.8070822877E-01],
	[2.3290000000E+04, 1.9417516612E+01, 5.6103351327E+00, 5.3643181050E+00, 2.4029257257E+00, 8.8077376573E-01],
	[2.3295000000E+04, 1.9424077110E+01, 5.6102755676E+00, 5.3680721500E+00, 2.4037682727E+00, 8.8083926718E-01],
	[2.3300000000E+04, 1.9430638416E+01, 5.6102160159E+00, 5.3718280149E+00, 2.4046106685E+00, 8.8090473313E-01],
	[2.3305000000E+04, 1.9437200530E+01, 5.6101564776E+00, 5.3755857004E+00, 2.4054529130E+00, 8.8097016360E-01],
	[2.3310000000E+04, 1.9443763452E+01, 5.6100969527E+00, 5.3793452068E+00, 2.4062950062E+00, 8.8103555861E-01],
	[2.3315000000E+04, 1.9450327181E+01, 5.6100374412E+00, 5.3831065347E+00, 2.4071369479E+00, 8.8110091818E-01],
	[2.3320000000E+04, 1.9456891718E+01, 5.6099779431E+00, 5.3868696845E+00, 2.4079787379E+00, 8.8116624232E-01],
	[2.3325000000E+04, 1.9463457062E+01, 5.6099184583E+00, 5.3906346568E+00, 2.4088203763E+00, 8.8123153105E-01],
	[2.3330000000E+04, 1.9470023214E+01, 5.6098589870E+00, 5.3944014521E+00, 2.4096618627E+00, 8.8129678439E-01],
	[2.3335000000E+04, 1.9476590173E+01, 5.6097995290E+00, 5.3981700708E+00, 2.4105031972E+00, 8.8136200235E-01],
	[2.3340000000E+04, 1.9483157939E+01, 5.6097400844E+00, 5.4019405134E+00, 2.4113443796E+00, 8.8142718494E-01],
	[2.3345000000E+04, 1.9489726512E+01, 5.6096806532E+00, 5.4057127804E+00, 2.4121854098E+00, 8.8149233219E-01],
	[2.3350000000E+04, 1.9496295893E+01, 5.6096212353E+00, 5.4094868723E+00, 2.4130262876E+00, 8.8155744410E-01],
	[2.3355000000E+04, 1.9502866081E+01, 5.6095618308E+00, 5.4132627897E+00, 2.4138670130E+00, 8.8162252070E-01],
	[2.3360000000E+04, 1.9509437075E+01, 5.6095024396E+00, 5.4170405329E+00, 2.4147075859E+00, 8.8168756199E-01],
	[2.3365000000E+04, 1.9516008877E+01, 5.6094430617E+00, 5.4208201025E+00, 2.4155480060E+00, 8.8175256799E-01],
	[2.3370000000E+04, 1.9522581485E+01, 5.6093836972E+00, 5.4246014990E+00, 2.4163882734E+00, 8.8181753872E-01],
	[2.3375000000E+04, 1.9529154900E+01, 5.6093243460E+00, 5.4283847229E+00, 2.4172283878E+00, 8.8188247419E-01],
	[2.3380000000E+04, 1.9535729122E+01, 5.6092650082E+00, 5.4321697746E+00, 2.4180683492E+00, 8.8194737442E-01],
	[2.3385000000E+04, 1.9542304151E+01, 5.6092056836E+00, 5.4359566546E+00, 2.4189081575E+00, 8.8201223942E-01],
	[2.3390000000E+04, 1.9548879986E+01, 5.6091463724E+00, 5.4397453635E+00, 2.4197478124E+00, 8.8207706921E-01],
	[2.3395000000E+04, 1.9555456627E+01, 5.6090870745E+00, 5.4435359018E+00, 2.4205873140E+00, 8.8214186380E-01],
	[2.3400000000E+04, 1.9562034075E+01, 5.6090277898E+00, 5.4473282698E+00, 2.4214266621E+00, 8.8220662322E-01],
	[2.3405000000E+04, 1.9568612329E+01, 5.6089685185E+00, 5.4511224682E+00, 2.4222658566E+00, 8.8227134746E-01],
	[2.3410000000E+04, 1.9575191390E+01, 5.6089092604E+00, 5.4549184974E+00, 2.4231048973E+00, 8.8233603655E-01],
	[2.3415000000E+04, 1.9581771256E+01, 5.6088500156E+00, 5.4587163578E+00, 2.4239437842E+00, 8.8240069051E-01],
	[2.3420000000E+04, 1.9588351929E+01, 5.6087907841E+00, 5.4625160501E+00, 2.4247825171E+00, 8.8246530934E-01],
	[2.3425000000E+04, 1.9594933408E+01, 5.6087315659E+00, 5.4663175746E+00, 2.4256210959E+00, 8.8252989307E-01],
	[2.3430000000E+04, 1.9601515692E+01, 5.6086723610E+00, 5.4701209320E+00, 2.4264595206E+00, 8.8259444171E-01],
	[2.3435000000E+04, 1.9608098783E+01, 5.6086131692E+00, 5.4739261225E+00, 2.4272977909E+00, 8.8265895528E-01],
	[2.3440000000E+04, 1.9614682679E+01, 5.6085539908E+00, 5.4777331469E+00, 2.4281359068E+00, 8.8272343378E-01],
	[2.3445000000E+04, 1.9621267381E+01, 5.6084948256E+00, 5.4815420055E+00, 2.4289738681E+00, 8.8278787724E-01],
	[2.3450000000E+04, 1.9627852889E+01, 5.6084356736E+00, 5.4853526988E+00, 2.4298116748E+00, 8.8285228567E-01],
	[2.3455000000E+04, 1.9634439202E+01, 5.6083765349E+00, 5.4891652274E+00, 2.4306493267E+00, 8.8291665909E-01],
	[2.3460000000E+04, 1.9641026321E+01, 5.6083174094E+00, 5.4929795916E+00, 2.4314868238E+00, 8.8298099751E-01],
	[2.3465000000E+04, 1.9647614245E+01, 5.6082582971E+00, 5.4967957921E+00, 2.4323241658E+00, 8.8304530094E-01],
	[2.3470000000E+04, 1.9654202975E+01, 5.6081991980E+00, 5.5006138294E+00, 2.4331613527E+00, 8.8310956941E-01],
	[2.3475000000E+04, 1.9660792510E+01, 5.6081401122E+00, 5.5044337038E+00, 2.4339983844E+00, 8.8317380292E-01],
	[2.3480000000E+04, 1.9667382850E+01, 5.6080810395E+00, 5.5082554159E+00, 2.4348352607E+00, 8.8323800150E-01],
	[2.3485000000E+04, 1.9673973995E+01, 5.6080219801E+00, 5.5120789661E+00, 2.4356719816E+00, 8.8330216516E-01],
	[2.3490000000E+04, 1.9680565945E+01, 5.6079629338E+00, 5.5159043551E+00, 2.4365085470E+00, 8.8336629391E-01],
	[2.3495000000E+04, 1.9687158701E+01, 5.6079039008E+00, 5.5197315832E+00, 2.4373449566E+00, 8.8343038776E-01],
	[2.3500000000E+04, 1.9693752261E+01, 5.6078448809E+00, 5.5235606510E+00, 2.4381812104E+00, 8.8349444675E-01],
	[2.3505000000E+04, 1.9700346626E+01, 5.6077858742E+00, 5.5273915590E+00, 2.4390173084E+00, 8.8355847087E-01],
	[2.3510000000E+04, 1.9706941796E+01, 5.6077268806E+00, 5.5312243075E+00, 2.4398532503E+00, 8.8362246015E-01],
	[2.3515000000E+04, 1.9713537771E+01, 5.6076679003E+00, 5.5350588973E+00, 2.4406890360E+00, 8.8368641460E-01],
	[2.3520000000E+04, 1.9720134550E+01, 5.6076089331E+00, 5.5388953286E+00, 2.4415246656E+00, 8.8375033423E-01],
	[2.3525000000E+04, 1.9726732134E+01, 5.6075499790E+00, 5.5427336021E+00, 2.4423601387E+00, 8.8381421907E-01],
	[2.3530000000E+04, 1.9733330522E+01, 5.6074910381E+00, 5.5465737182E+00, 2.4431954554E+00, 8.8387806912E-01],
	[2.3535000000E+04, 1.9739929715E+01, 5.6074321103E+00, 5.5504156773E+00, 2.4440306155E+00, 8.8394188441E-01],
	[2.3540000000E+04, 1.9746549711E+01, 5.6073760225E+00, 5.5542594801E+00, 2.4448664629E+00, 8.8400566494E-01],
	[2.3545000000E+04, 1.9753180543E+01, 5.6073213633E+00, 5.5581051270E+00, 2.4457025773E+00, 8.8406941074E-01],
	[2.3550000000E+04, 1.9759812193E+01, 5.6072667163E+00, 5.5619526185E+00, 2.4465385360E+00, 8.8413312182E-01],
	[2.3555000000E+04, 1.9766444661E+01, 5.6072120814E+00, 5.5658019550E+00, 2.4473743388E+00, 8.8419679819E-01],
	[2.3560000000E+04, 1.9773077947E+01, 5.6071574586E+00, 5.5696531371E+00, 2.4482099856E+00, 8.8426043987E-01],
	[2.3565000000E+04, 1.9779712051E+01, 5.6071028479E+00, 5.5735061652E+00, 2.4490454764E+00, 8.8432404688E-01],
	[2.3570000000E+04, 1.9786346972E+01, 5.6070482494E+00, 5.5773610400E+00, 2.4498808110E+00, 8.8438761922E-01],
	[2.3575000000E+04, 1.9792982711E+01, 5.6069936630E+00, 5.5812177617E+00, 2.4507159892E+00, 8.8445115693E-01],
	[2.3580000000E+04, 1.9799619267E+01, 5.6069390886E+00, 5.5850763310E+00, 2.4515510111E+00, 8.8451466000E-01],
	[2.3585000000E+04, 1.9806256640E+01, 5.6068845264E+00, 5.5889367483E+00, 2.4523858764E+00, 8.8457812847E-01],
	[2.3590000000E+04, 1.9812894831E+01, 5.6068299763E+00, 5.5927990142E+00, 2.4532205851E+00, 8.8464156233E-01],
	[2.3595000000E+04, 1.9819533840E+01, 5.6067754383E+00, 5.5966631290E+00, 2.4540551371E+00, 8.8470496162E-01],
	[2.3600000000E+04, 1.9826173665E+01, 5.6067209123E+00, 5.6005290934E+00, 2.4548895322E+00, 8.8476832634E-01],
	[2.3605000000E+04, 1.9832814308E+01, 5.6066663985E+00, 5.6043969078E+00, 2.4557237703E+00, 8.8483165651E-01],
	[2.3610000000E+04, 1.9839455767E+01, 5.6066118967E+00, 5.6082665726E+00, 2.4565578514E+00, 8.8489495214E-01],
	[2.3615000000E+04, 1.9846098044E+01, 5.6065574070E+00, 5.6121380885E+00, 2.4573917752E+00, 8.8495821326E-01],
	[2.3620000000E+04, 1.9852741138E+01, 5.6065029293E+00, 5.6160114558E+00, 2.4582255418E+00, 8.8502143987E-01],
	[2.3625000000E+04, 1.9859385048E+01, 5.6064484637E+00, 5.6198866751E+00, 2.4590591510E+00, 8.8508463199E-01],
	[2.3630000000E+04, 1.9866029775E+01, 5.6063940102E+00, 5.6237637469E+00, 2.4598926027E+00, 8.8514778965E-01],
	[2.3635000000E+04, 1.9872675319E+01, 5.6063395687E+00, 5.6276426716E+00, 2.4607258968E+00, 8.8521091284E-01],
	[2.3640000000E+04, 1.9879321680E+01, 5.6062851392E+00, 5.6315234497E+00, 2.4615590331E+00, 8.8527400160E-01],
	[2.3645000000E+04, 1.9885968857E+01, 5.6062307218E+00, 5.6354060818E+00, 2.4623920116E+00, 8.8533705593E-01],
	[2.3650000000E+04, 1.9892616850E+01, 5.6061763165E+00, 5.6392905684E+00, 2.4632248322E+00, 8.8540007585E-01],
	[2.3655000000E+04, 1.9899265660E+01, 5.6061219231E+00, 5.6431769098E+00, 2.4640574947E+00, 8.8546306137E-01],
	[2.3660000000E+04, 1.9905915287E+01, 5.6060675418E+00, 5.6470651067E+00, 2.4648899990E+00, 8.8552601252E-01],
	[2.3665000000E+04, 1.9912565729E+01, 5.6060131725E+00, 5.6509551595E+00, 2.4657223451E+00, 8.8558892931E-01],
	[2.3670000000E+04, 1.9919216988E+01, 5.6059588152E+00, 5.6548470688E+00, 2.4665545328E+00, 8.8565181175E-01],
	[2.3675000000E+04, 1.9925869063E+01, 5.6059044699E+00, 5.6587408349E+00, 2.4673865620E+00, 8.8571465985E-01],
	[2.3680000000E+04, 1.9932521954E+01, 5.6058501367E+00, 5.6626364584E+00, 2.4682184327E+00, 8.8577747365E-01],
	[2.3685000000E+04, 1.9939175661E+01, 5.6057958154E+00, 5.6665339398E+00, 2.4690501446E+00, 8.8584025314E-01],
	[2.3690000000E+04, 1.9945830184E+01, 5.6057415061E+00, 5.6704332795E+00, 2.4698816978E+00, 8.8590299834E-01],
	[2.3695000000E+04, 1.9952485522E+01, 5.6056872088E+00, 5.6743344782E+00, 2.4707130920E+00, 8.8596570928E-01],
	[2.3700000000E+04, 1.9959141677E+01, 5.6056329235E+00, 5.6782375362E+00, 2.4715443272E+00, 8.8602838597E-01],
	[2.3705000000E+04, 1.9965798647E+01, 5.6055786501E+00, 5.6821424541E+00, 2.4723754033E+00, 8.8609102842E-01],
	[2.3710000000E+04, 1.9972456433E+01, 5.6055243888E+00, 5.6860492323E+00, 2.4732063202E+00, 8.8615363665E-01],
	[2.3715000000E+04, 1.9979115034E+01, 5.6054701394E+00, 5.6899578713E+00, 2.4740370777E+00, 8.8621621067E-01],
	[2.3720000000E+04, 1.9985774451E+01, 5.6054159019E+00, 5.6938683717E+00, 2.4748676758E+00, 8.8627875050E-01],
	[2.3725000000E+04, 1.9992434683E+01, 5.6053616764E+00, 5.6977807340E+00, 2.4756981143E+00, 8.8634125616E-01],
	[2.3730000000E+04, 1.9999095730E+01, 5.6053074629E+00, 5.7016949585E+00, 2.4765283932E+00, 8.8640372766E-01],
	[2.3735000000E+04, 2.0005757593E+01, 5.6052532613E+00, 5.7056110459E+00, 2.4773585124E+00, 8.8646616502E-01],
	[2.3740000000E+04, 2.0012420271E+01, 5.6051990717E+00, 5.7095289966E+00, 2.4781884716E+00, 8.8652856825E-01],
	[2.3745000000E+04, 2.0019083764E+01, 5.6051448940E+00, 5.7134488111E+00, 2.4790182709E+00, 8.8659093737E-01],
	[2.3750000000E+04, 2.0025748072E+01, 5.6050907282E+00, 5.7173704899E+00, 2.4798479102E+00, 8.8665327240E-01],
	[2.3755000000E+04, 2.0032413195E+01, 5.6050365743E+00, 5.7212940335E+00, 2.4806773892E+00, 8.8671557335E-01],
	[2.3760000000E+04, 2.0039079133E+01, 5.6049824324E+00, 5.7252194423E+00, 2.4815067080E+00, 8.8677784023E-01],
	[2.3765000000E+04, 2.0045745886E+01, 5.6049283024E+00, 5.7291467170E+00, 2.4823358664E+00, 8.8684007306E-01],
	[2.3770000000E+04, 2.0052413453E+01, 5.6048741843E+00, 5.7330758579E+00, 2.4831648643E+00, 8.8690227187E-01],
	[2.3775000000E+04, 2.0059081836E+01, 5.6048200781E+00, 5.7370068656E+00, 2.4839937016E+00, 8.8696443665E-01],
	[2.3780000000E+04, 2.0065751032E+01, 5.6047659838E+00, 5.7409397405E+00, 2.4848223782E+00, 8.8702656744E-01],
	[2.3785000000E+04, 2.0072421044E+01, 5.6047119014E+00, 5.7448744832E+00, 2.4856508940E+00, 8.8708866424E-01],
	[2.3790000000E+04, 2.0079091870E+01, 5.6046578308E+00, 5.7488110942E+00, 2.4864792489E+00, 8.8715072708E-01],
	[2.3795000000E+04, 2.0085763510E+01, 5.6046037722E+00, 5.7527495739E+00, 2.4873074428E+00, 8.8721275596E-01],
	[2.3800000000E+04, 2.0092435964E+01, 5.6045497254E+00, 5.7566899228E+00, 2.4881354756E+00, 8.8727475090E-01],
	[2.3805000000E+04, 2.0099109233E+01, 5.6044956906E+00, 5.7606321415E+00, 2.4889633471E+00, 8.8733671192E-01],
	[2.3810000000E+04, 2.0105783316E+01, 5.6044416676E+00, 5.7645762303E+00, 2.4897910574E+00, 8.8739863904E-01],
	[2.3815000000E+04, 2.0112458213E+01, 5.6043876564E+00, 5.7685221899E+00, 2.4906186062E+00, 8.8746053227E-01],
	[2.3820000000E+04, 2.0119133924E+01, 5.6043336571E+00, 5.7724700207E+00, 2.4914459935E+00, 8.8752239162E-01],
	[2.3825000000E+04, 2.0125810449E+01, 5.6042796697E+00, 5.7764197232E+00, 2.4922732192E+00, 8.8758421712E-01],
	[2.3830000000E+04, 2.0132487788E+01, 5.6042256941E+00, 5.7803712979E+00, 2.4931002831E+00, 8.8764600878E-01],
	[2.3835000000E+04, 2.0139165941E+01, 5.6041717303E+00, 5.7843247453E+00, 2.4939271853E+00, 8.8770776661E-01],
	[2.3840000000E+04, 2.0145844907E+01, 5.6041177784E+00, 5.7882800659E+00, 2.4947539254E+00, 8.8776949063E-01],
	[2.3845000000E+04, 2.0152524688E+01, 5.6040638384E+00, 5.7922372601E+00, 2.4955805036E+00, 8.8783118085E-01],
	[2.3850000000E+04, 2.0159205281E+01, 5.6040099101E+00, 5.7961963285E+00, 2.4964069196E+00, 8.8789283730E-01],
	[2.3855000000E+04, 2.0165886689E+01, 5.6039559937E+00, 5.8001572716E+00, 2.4972331734E+00, 8.8795445999E-01],
	[2.3860000000E+04, 2.0172568909E+01, 5.6039020891E+00, 5.8041200899E+00, 2.4980592649E+00, 8.8801604893E-01],
	[2.3865000000E+04, 2.0179251944E+01, 5.6038481963E+00, 5.8080847838E+00, 2.4988851939E+00, 8.8807760414E-01],
	[2.3870000000E+04, 2.0185935791E+01, 5.6037943153E+00, 5.8120513538E+00, 2.4997109603E+00, 8.8813912563E-01],
	[2.3875000000E+04, 2.0192620452E+01, 5.6037404462E+00, 5.8160198005E+00, 2.5005365642E+00, 8.8820061343E-01],
	[2.3880000000E+04, 2.0199305926E+01, 5.6036865888E+00, 5.8199901244E+00, 2.5013620053E+00, 8.8826206754E-01],
	[2.3885000000E+04, 2.0205992213E+01, 5.6036327432E+00, 5.8239623258E+00, 2.5021872835E+00, 8.8832348799E-01],
	[2.3890000000E+04, 2.0212679313E+01, 5.6035789094E+00, 5.8279364054E+00, 2.5030123988E+00, 8.8838487479E-01],
	[2.3895000000E+04, 2.0219367226E+01, 5.6035250874E+00, 5.8319123636E+00, 2.5038373511E+00, 8.8844622795E-01],
	[2.3900000000E+04, 2.0226055952E+01, 5.6034712771E+00, 5.8358902010E+00, 2.5046621402E+00, 8.8850754749E-01],
	[2.3905000000E+04, 2.0232745491E+01, 5.6034174787E+00, 5.8398699179E+00, 2.5054867661E+00, 8.8856883344E-01],
	[2.3910000000E+04, 2.0239435842E+01, 5.6033636920E+00, 5.8438515149E+00, 2.5063112287E+00, 8.8863008579E-01],
	[2.3915000000E+04, 2.0246127006E+01, 5.6033099170E+00, 5.8478349925E+00, 2.5071355278E+00, 8.8869130458E-01],
	[2.3920000000E+04, 2.0252845527E+01, 5.6032598517E+00, 5.8518203513E+00, 2.5079608112E+00, 8.8875248981E-01],
	[2.3925000000E+04, 2.0259568337E+01, 5.6032102799E+00, 5.8558075916E+00, 2.5087860819E+00, 8.8881364150E-01],
	[2.3930000000E+04, 2.0266291974E+01, 5.6031607189E+00, 5.8597967139E+00, 2.5096111900E+00, 8.8887475966E-01],
	[2.3935000000E+04, 2.0273016436E+01, 5.6031111687E+00, 5.8637877189E+00, 2.5104361354E+00, 8.8893584433E-01],
	[2.3940000000E+04, 2.0279741725E+01, 5.6030616292E+00, 5.8677806069E+00, 2.5112609180E+00, 8.8899689550E-01],
	[2.3945000000E+04, 2.0286467839E+01, 5.6030121006E+00, 5.8717753785E+00, 2.5120855377E+00, 8.8905791319E-01],
	[2.3950000000E+04, 2.0293194779E+01, 5.6029625827E+00, 5.8757720342E+00, 2.5129099945E+00, 8.8911889743E-01],
	[2.3955000000E+04, 2.0299922545E+01, 5.6029130756E+00, 5.8797705744E+00, 2.5137342881E+00, 8.8917984823E-01],
	[2.3960000000E+04, 2.0306651136E+01, 5.6028635793E+00, 5.8837709996E+00, 2.5145584186E+00, 8.8924076560E-01],
	[2.3965000000E+04, 2.0313380553E+01, 5.6028140937E+00, 5.8877733104E+00, 2.5153823858E+00, 8.8930164955E-01],
	[2.3970000000E+04, 2.0320110796E+01, 5.6027646189E+00, 5.8917775072E+00, 2.5162061896E+00, 8.8936250012E-01],
	[2.3975000000E+04, 2.0326841864E+01, 5.6027151549E+00, 5.8957835905E+00, 2.5170298299E+00, 8.8942331730E-01],
	[2.3980000000E+04, 2.0333573757E+01, 5.6026657016E+00, 5.8997915609E+00, 2.5178533067E+00, 8.8948410113E-01],
	[2.3985000000E+04, 2.0340306476E+01, 5.6026162590E+00, 5.9038014188E+00, 2.5186766198E+00, 8.8954485160E-01],
	[2.3990000000E+04, 2.0347040020E+01, 5.6025668272E+00, 5.9078131647E+00, 2.5194997691E+00, 8.8960556875E-01],
	[2.3995000000E+04, 2.0353774388E+01, 5.6025174062E+00, 5.9118267991E+00, 2.5203227545E+00, 8.8966625258E-01],
	[2.4000000000E+04, 2.0360509583E+01, 5.6024679958E+00, 5.9158423225E+00, 2.5211455760E+00, 8.8972690312E-01],
	[2.4005000000E+04, 2.0367245602E+01, 5.6024185962E+00, 5.9198597355E+00, 2.5219682335E+00, 8.8978752037E-01],
	[2.4010000000E+04, 2.0373982445E+01, 5.6023692074E+00, 5.9238790384E+00, 2.5227907267E+00, 8.8984810435E-01],
	[2.4015000000E+04, 2.0380720114E+01, 5.6023198292E+00, 5.9279002318E+00, 2.5236130558E+00, 8.8990865509E-01],
	[2.4020000000E+04, 2.0387458608E+01, 5.6022704617E+00, 5.9319233161E+00, 2.5244352204E+00, 8.8996917259E-01],
	[2.4025000000E+04, 2.0394197926E+01, 5.6022211050E+00, 5.9359482920E+00, 2.5252572207E+00, 8.9002965688E-01],
	[2.4030000000E+04, 2.0400938069E+01, 5.6021717590E+00, 5.9399751598E+00, 2.5260790564E+00, 8.9009010796E-01],
	[2.4035000000E+04, 2.0407679037E+01, 5.6021224236E+00, 5.9440039201E+00, 2.5269007274E+00, 8.9015052586E-01],
	[2.4040000000E+04, 2.0414420829E+01, 5.6020730990E+00, 5.9480345734E+00, 2.5277222337E+00, 8.9021091059E-01],
	[2.4045000000E+04, 2.0421163445E+01, 5.6020237851E+00, 5.9520671201E+00, 2.5285435752E+00, 8.9027126216E-01],
	[2.4050000000E+04, 2.0427906886E+01, 5.6019744818E+00, 5.9561015608E+00, 2.5293647518E+00, 8.9033158060E-01],
	[2.4055000000E+04, 2.0434651151E+01, 5.6019251892E+00, 5.9601378959E+00, 2.5301857633E+00, 8.9039186592E-01],
	[2.4060000000E+04, 2.0441396241E+01, 5.6018759073E+00, 5.9641761259E+00, 2.5310066098E+00, 8.9045211813E-01],
	[2.4065000000E+04, 2.0448142154E+01, 5.6018266361E+00, 5.9682162514E+00, 2.5318272910E+00, 8.9051233725E-01],
	[2.4070000000E+04, 2.0454888892E+01, 5.6017773756E+00, 5.9722582728E+00, 2.5326478069E+00, 8.9057252330E-01],
	[2.4075000000E+04, 2.0461636454E+01, 5.6017281257E+00, 5.9763021907E+00, 2.5334681574E+00, 8.9063267630E-01],
	[2.4080000000E+04, 2.0468384839E+01, 5.6016788865E+00, 5.9803480055E+00, 2.5342883424E+00, 8.9069279625E-01],
	[2.4085000000E+04, 2.0475134049E+01, 5.6016296579E+00, 5.9843957177E+00, 2.5351083619E+00, 8.9075288318E-01],
	[2.4090000000E+04, 2.0481884082E+01, 5.6015804400E+00, 5.9884453278E+00, 2.5359282157E+00, 8.9081293710E-01],
	[2.4095000000E+04, 2.0488634939E+01, 5.6015312327E+00, 5.9924968363E+00, 2.5367479036E+00, 8.9087295803E-01],
	[2.4100000000E+04, 2.0495386620E+01, 5.6014820361E+00, 5.9965502437E+00, 2.5375674258E+00, 8.9093294598E-01],
	[2.4105000000E+04, 2.0502139124E+01, 5.6014328501E+00, 6.0006055505E+00, 2.5383867819E+00, 8.9099290098E-01],
	[2.4110000000E+04, 2.0508892452E+01, 5.6013836747E+00, 6.0046627572E+00, 2.5392059720E+00, 8.9105282303E-01],
	[2.4115000000E+04, 2.0515646603E+01, 5.6013345100E+00, 6.0087218643E+00, 2.5400249960E+00, 8.9111271215E-01],
	[2.4120000000E+04, 2.0522401577E+01, 5.6012853559E+00, 6.0127828723E+00, 2.5408438537E+00, 8.9117256836E-01],
	[2.4125000000E+04, 2.0529157375E+01, 5.6012362124E+00, 6.0168457817E+00, 2.5416625451E+00, 8.9123239168E-01],
	[2.4130000000E+04, 2.0535913996E+01, 5.6011870795E+00, 6.0209105929E+00, 2.5424810700E+00, 8.9129218212E-01],
	[2.4135000000E+04, 2.0542671441E+01, 5.6011379573E+00, 6.0249773065E+00, 2.5432994285E+00, 8.9135193970E-01],
	[2.4140000000E+04, 2.0549429708E+01, 5.6010888456E+00, 6.0290459230E+00, 2.5441176203E+00, 8.9141166442E-01],
	[2.4145000000E+04, 2.0556188799E+01, 5.6010397446E+00, 6.0331164428E+00, 2.5449356454E+00, 8.9147135632E-01],
	[2.4150000000E+04, 2.0562948712E+01, 5.6009906541E+00, 6.0371888665E+00, 2.5457535037E+00, 8.9153101541E-01],
	[2.4155000000E+04, 2.0569709448E+01, 5.6009415742E+00, 6.0412631946E+00, 2.5465711951E+00, 8.9159064170E-01],
	[2.4160000000E+04, 2.0576471007E+01, 5.6008925050E+00, 6.0453394275E+00, 2.5473887196E+00, 8.9165023520E-01],
	[2.4165000000E+04, 2.0583233389E+01, 5.6008434463E+00, 6.0494175657E+00, 2.5482060770E+00, 8.9170979594E-01],
	[2.4170000000E+04, 2.0589996594E+01, 5.6007943982E+00, 6.0534976098E+00, 2.5490232672E+00, 8.9176932393E-01],
	[2.4175000000E+04, 2.0596760621E+01, 5.6007453606E+00, 6.0575795603E+00, 2.5498402902E+00, 8.9182881919E-01],
	[2.4180000000E+04, 2.0603525470E+01, 5.6006963337E+00, 6.0616634175E+00, 2.5506571458E+00, 8.9188828173E-01],
	[2.4185000000E+04, 2.0610291143E+01, 5.6006473173E+00, 6.0657491821E+00, 2.5514738340E+00, 8.9194771158E-01],
	[2.4190000000E+04, 2.0617057637E+01, 5.6005983114E+00, 6.0698368545E+00, 2.5522903546E+00, 8.9200710873E-01],
	[2.4195000000E+04, 2.0623824954E+01, 5.6005493161E+00, 6.0739264352E+00, 2.5531067076E+00, 8.9206647322E-01],
	[2.4200000000E+04, 2.0630593093E+01, 5.6005003314E+00, 6.0780179247E+00, 2.5539228930E+00, 8.9212580506E-01],
	[2.4205000000E+04, 2.0637362054E+01, 5.6004513572E+00, 6.0821113236E+00, 2.5547389105E+00, 8.9218510426E-01],
	[2.4210000000E+04, 2.0644131838E+01, 5.6004023936E+00, 6.0862066322E+00, 2.5555547601E+00, 8.9224437084E-01],
	[2.4215000000E+04, 2.0650902443E+01, 5.6003534405E+00, 6.0903038512E+00, 2.5563704418E+00, 8.9230360482E-01],
	[2.4220000000E+04, 2.0657673871E+01, 5.6003044979E+00, 6.0944029809E+00, 2.5571859554E+00, 8.9236280621E-01],
	[2.4225000000E+04, 2.0664446120E+01, 5.6002555659E+00, 6.0985040220E+00, 2.5580013008E+00, 8.9242197503E-01],
	[2.4230000000E+04, 2.0671219191E+01, 5.6002066444E+00, 6.1026069748E+00, 2.5588164780E+00, 8.9248111130E-01],
	[2.4235000000E+04, 2.0677993084E+01, 5.6001577334E+00, 6.1067118399E+00, 2.5596314868E+00, 8.9254021503E-01],
	[2.4240000000E+04, 2.0684767799E+01, 5.6001088329E+00, 6.1108186178E+00, 2.5604463272E+00, 8.9259928623E-01],
	[2.4245000000E+04, 2.0691543335E+01, 5.6000599430E+00, 6.1149273090E+00, 2.5612609991E+00, 8.9265832493E-01],
	[2.4250000000E+04, 2.0698319693E+01, 5.6000110635E+00, 6.1190379140E+00, 2.5620755024E+00, 8.9271733115E-01],
	[2.4255000000E+04, 2.0705096872E+01, 5.5999621946E+00, 6.1231504332E+00, 2.5628898370E+00, 8.9277630488E-01],
	[2.4260000000E+04, 2.0711874873E+01, 5.5999133361E+00, 6.1272648672E+00, 2.5637040028E+00, 8.9283524616E-01],
	[2.4265000000E+04, 2.0718653695E+01, 5.5998644882E+00, 6.1313812164E+00, 2.5645179998E+00, 8.9289415501E-01],
	[2.4270000000E+04, 2.0725433338E+01, 5.5998156507E+00, 6.1354994814E+00, 2.5653318277E+00, 8.9295303142E-01],
	[2.4275000000E+04, 2.0732213803E+01, 5.5997668237E+00, 6.1396196627E+00, 2.5661454867E+00, 8.9301187543E-01],
	[2.4280000000E+04, 2.0738995089E+01, 5.5997180072E+00, 6.1437417607E+00, 2.5669589765E+00, 8.9307068705E-01],
	[2.4285000000E+04, 2.0745777196E+01, 5.5996692012E+00, 6.1478657760E+00, 2.5677722971E+00, 8.9312946629E-01],
	[2.4290000000E+04, 2.0752560123E+01, 5.5996204057E+00, 6.1519917090E+00, 2.5685854483E+00, 8.9318821316E-01],
	[2.4295000000E+04, 2.0759343872E+01, 5.5995716206E+00, 6.1561195602E+00, 2.5693984302E+00, 8.9324692769E-01],
	[2.4300000000E+04, 2.0766128442E+01, 5.5995228460E+00, 6.1602493302E+00, 2.5702112426E+00, 8.9330560989E-01],
	[2.4305000000E+04, 2.0772940316E+01, 5.5994777186E+00, 6.1643810194E+00, 2.5710250578E+00, 8.9336425977E-01],
	[2.4310000000E+04, 2.0779756536E+01, 5.5994330832E+00, 6.1685146283E+00, 2.5718388599E+00, 8.9342287735E-01],
	[2.4315000000E+04, 2.0786573590E+01, 5.5993884573E+00, 6.1726501575E+00, 2.5726524934E+00, 8.9348146264E-01],
	[2.4320000000E+04, 2.0793391478E+01, 5.5993438410E+00, 6.1767876074E+00, 2.5734659581E+00, 8.9354001565E-01],
	[2.4325000000E+04, 2.0800210200E+01, 5.5992992341E+00, 6.1809269785E+00, 2.5742792541E+00, 8.9359853641E-01],
	[2.4330000000E+04, 2.0807029756E+01, 5.5992546368E+00, 6.1850682713E+00, 2.5750923812E+00, 8.9365702492E-01],
	[2.4335000000E+04, 2.0813850146E+01, 5.5992100490E+00, 6.1892114863E+00, 2.5759053393E+00, 8.9371548120E-01],
	[2.4340000000E+04, 2.0820671370E+01, 5.5991654708E+00, 6.1933566240E+00, 2.5767181283E+00, 8.9377390527E-01],
	[2.4345000000E+04, 2.0827493427E+01, 5.5991209020E+00, 6.1975036850E+00, 2.5775307482E+00, 8.9383229714E-01],
	[2.4350000000E+04, 2.0834316319E+01, 5.5990763428E+00, 6.2016526696E+00, 2.5783431989E+00, 8.9389065682E-01],
	[2.4355000000E+04, 2.0841140043E+01, 5.5990317930E+00, 6.2058035784E+00, 2.5791554802E+00, 8.9394898433E-01],
	[2.4360000000E+04, 2.0847964601E+01, 5.5989872528E+00, 6.2099564120E+00, 2.5799675922E+00, 8.9400727969E-01],
	[2.4365000000E+04, 2.0854789993E+01, 5.5989427220E+00, 6.2141111707E+00, 2.5807795346E+00, 8.9406554291E-01],
	[2.4370000000E+04, 2.0861616218E+01, 5.5988982008E+00, 6.2182678551E+00, 2.5815913075E+00, 8.9412377400E-01],
	[2.4375000000E+04, 2.0868443276E+01, 5.5988536890E+00, 6.2224264657E+00, 2.5824029107E+00, 8.9418197298E-01],
	[2.4380000000E+04, 2.0875271167E+01, 5.5988091867E+00, 6.2265870029E+00, 2.5832143441E+00, 8.9424013987E-01],
	[2.4385000000E+04, 2.0882099892E+01, 5.5987646939E+00, 6.2307494674E+00, 2.5840256078E+00, 8.9429827467E-01],
	[2.4390000000E+04, 2.0888929450E+01, 5.5987202106E+00, 6.2349138595E+00, 2.5848367015E+00, 8.9435637741E-01],
	[2.4395000000E+04, 2.0895759840E+01, 5.5986757367E+00, 6.2390801798E+00, 2.5856476252E+00, 8.9441444810E-01],
	[2.4400000000E+04, 2.0902591064E+01, 5.5986312723E+00, 6.2432484287E+00, 2.5864583788E+00, 8.9447248675E-01],
	[2.4405000000E+04, 2.0909423120E+01, 5.5985868174E+00, 6.2474186068E+00, 2.5872689622E+00, 8.9453049338E-01],
	[2.4410000000E+04, 2.0916256010E+01, 5.5985423719E+00, 6.2515907146E+00, 2.5880793754E+00, 8.9458846800E-01],
	[2.4415000000E+04, 2.0923089732E+01, 5.5984979359E+00, 6.2557647525E+00, 2.5888896183E+00, 8.9464641063E-01],
	[2.4420000000E+04, 2.0929924286E+01, 5.5984535093E+00, 6.2599407211E+00, 2.5896996907E+00, 8.9470432129E-01],
	[2.4425000000E+04, 2.0936759674E+01, 5.5984090922E+00, 6.2641186209E+00, 2.5905095926E+00, 8.9476219998E-01],
	[2.4430000000E+04, 2.0943595894E+01, 5.5983646845E+00, 6.2682984523E+00, 2.5913193240E+00, 8.9482004672E-01],
	[2.4435000000E+04, 2.0950432946E+01, 5.5983202863E+00, 6.2724802158E+00, 2.5921288846E+00, 8.9487786154E-01],
	[2.4440000000E+04, 2.0957270831E+01, 5.5982758975E+00, 6.2766639120E+00, 2.5929382745E+00, 8.9493564443E-01],
	[2.4445000000E+04, 2.0964109548E+01, 5.5982315181E+00, 6.2808495413E+00, 2.5937474936E+00, 8.9499339543E-01],
	[2.4450000000E+04, 2.0970949097E+01, 5.5981871482E+00, 6.2850371042E+00, 2.5945565417E+00, 8.9505111454E-01],
	[2.4455000000E+04, 2.0977789478E+01, 5.5981427877E+00, 6.2892266013E+00, 2.5953654189E+00, 8.9510880177E-01],
	[2.4460000000E+04, 2.0984630692E+01, 5.5980984366E+00, 6.2934180331E+00, 2.5961741249E+00, 8.9516645715E-01],
	[2.4465000000E+04, 2.0991472737E+01, 5.5980540949E+00, 6.2976113999E+00, 2.5969826598E+00, 8.9522408068E-01],
	[2.4470000000E+04, 2.0998315615E+01, 5.5980097627E+00, 6.3018067024E+00, 2.5977910234E+00, 8.9528167239E-01],
	[2.4475000000E+04, 2.1005159324E+01, 5.5979654398E+00, 6.3060039410E+00, 2.5985992157E+00, 8.9533923229E-01],
	[2.4480000000E+04, 2.1012003866E+01, 5.5979211263E+00, 6.3102031162E+00, 2.5994072365E+00, 8.9539676039E-01],
	[2.4485000000E+04, 2.1018849239E+01, 5.5978768223E+00, 6.3144042285E+00, 2.6002150859E+00, 8.9545425670E-01],
	[2.4490000000E+04, 2.1025695444E+01, 5.5978325276E+00, 6.3186072785E+00, 2.6010227636E+00, 8.9551172125E-01],
	[2.4495000000E+04, 2.1032542480E+01, 5.5977882424E+00, 6.3228122665E+00, 2.6018302698E+00, 8.9556915405E-01],
	[2.4500000000E+04, 2.1039390348E+01, 5.5977439665E+00, 6.3270191932E+00, 2.6026376041E+00, 8.9562655511E-01],
	[2.4505000000E+04, 2.1046239048E+01, 5.5976997000E+00, 6.3312280590E+00, 2.6034447666E+00, 8.9568392444E-01],
	[2.4510000000E+04, 2.1053088578E+01, 5.5976554429E+00, 6.3354388643E+00, 2.6042517573E+00, 8.9574126207E-01],
	[2.4515000000E+04, 2.1059938941E+01, 5.5976111952E+00, 6.3396516098E+00, 2.6050585759E+00, 8.9579856801E-01],
	[2.4520000000E+04, 2.1066790134E+01, 5.5975669568E+00, 6.3438662959E+00, 2.6058652225E+00, 8.9585584227E-01],
	[2.4525000000E+04, 2.1073642159E+01, 5.5975227279E+00, 6.3480829231E+00, 2.6066716969E+00, 8.9591308487E-01],
	[2.4530000000E+04, 2.1080495015E+01, 5.5974785082E+00, 6.3523014918E+00, 2.6074779991E+00, 8.9597029582E-01],
	[2.4535000000E+04, 2.1087348702E+01, 5.5974342980E+00, 6.3565220027E+00, 2.6082841289E+00, 8.9602747513E-01],
	[2.4540000000E+04, 2.1094203220E+01, 5.5973900971E+00, 6.3607444561E+00, 2.6090900864E+00, 8.9608462284E-01],
	[2.4545000000E+04, 2.1101058569E+01, 5.5973459055E+00, 6.3649688527E+00, 2.6098958714E+00, 8.9614173893E-01],
	[2.4550000000E+04, 2.1107914749E+01, 5.5973017233E+00, 6.3691951928E+00, 2.6107014839E+00, 8.9619882345E-01],
	[2.4555000000E+04, 2.1114771759E+01, 5.5972575505E+00, 6.3734234770E+00, 2.6115069237E+00, 8.9625587639E-01],
	[2.4560000000E+04, 2.1121629601E+01, 5.5972133870E+00, 6.3776537058E+00, 2.6123121908E+00, 8.9631289777E-01],
	[2.4565000000E+04, 2.1128488273E+01, 5.5971692328E+00, 6.3818858796E+00, 2.6131172851E+00, 8.9636988761E-01],
	[2.4570000000E+04, 2.1135347776E+01, 5.5971250880E+00, 6.3861199991E+00, 2.6139222065E+00, 8.9642684593E-01],
	[2.4575000000E+04, 2.1142208109E+01, 5.5970809525E+00, 6.3903560646E+00, 2.6147269550E+00, 8.9648377273E-01],
	[2.4580000000E+04, 2.1149069272E+01, 5.5970368263E+00, 6.3945940766E+00, 2.6155315305E+00, 8.9654066804E-01],
	[2.4585000000E+04, 2.1155931267E+01, 5.5969927094E+00, 6.3988340358E+00, 2.6163359328E+00, 8.9659753186E-01],
	[2.4590000000E+04, 2.1162794091E+01, 5.5969486019E+00, 6.4030759425E+00, 2.6171401620E+00, 8.9665436422E-01],
	[2.4595000000E+04, 2.1169657746E+01, 5.5969045037E+00, 6.4073197972E+00, 2.6179442179E+00, 8.9671116513E-01],
	[2.4600000000E+04, 2.1176522230E+01, 5.5968604148E+00, 6.4115656006E+00, 2.6187481004E+00, 8.9676793460E-01],
	[2.4605000000E+04, 2.1183387545E+01, 5.5968163352E+00, 6.4158133530E+00, 2.6195518096E+00, 8.9682467265E-01],
	[2.4610000000E+04, 2.1190253690E+01, 5.5967722649E+00, 6.4200630549E+00, 2.6203553452E+00, 8.9688137930E-01],
	[2.4615000000E+04, 2.1197120665E+01, 5.5967282039E+00, 6.4243147069E+00, 2.6211587073E+00, 8.9693805455E-01],
	[2.4620000000E+04, 2.1203988470E+01, 5.5966841522E+00, 6.4285683095E+00, 2.6219618956E+00, 8.9699469843E-01],
	[2.4625000000E+04, 2.1210857105E+01, 5.5966401098E+00, 6.4328238631E+00, 2.6227649103E+00, 8.9705131095E-01],
	[2.4630000000E+04, 2.1217726570E+01, 5.5965960767E+00, 6.4370813682E+00, 2.6235677511E+00, 8.9710789212E-01],
	[2.4635000000E+04, 2.1224596864E+01, 5.5965520528E+00, 6.4413408254E+00, 2.6243704181E+00, 8.9716444197E-01],
	[2.4640000000E+04, 2.1231467988E+01, 5.5965080383E+00, 6.4456022352E+00, 2.6251729111E+00, 8.9722096050E-01],
	[2.4645000000E+04, 2.1238339941E+01, 5.5964640330E+00, 6.4498655980E+00, 2.6259752300E+00, 8.9727744773E-01],
	[2.4650000000E+04, 2.1245212724E+01, 5.5964200370E+00, 6.4541309143E+00, 2.6267773749E+00, 8.9733390367E-01],
	[2.4655000000E+04, 2.1252086337E+01, 5.5963760502E+00, 6.4583981847E+00, 2.6275793455E+00, 8.9739032835E-01],
	[2.4660000000E+04, 2.1258960779E+01, 5.5963320728E+00, 6.4626674096E+00, 2.6283811418E+00, 8.9744672177E-01],
	[2.4665000000E+04, 2.1265836050E+01, 5.5962881046E+00, 6.4669385895E+00, 2.6291827638E+00, 8.9750308395E-01],
	[2.4670000000E+04, 2.1272712150E+01, 5.5962441456E+00, 6.4712117250E+00, 2.6299842114E+00, 8.9755941491E-01],
	[2.4675000000E+04, 2.1279589080E+01, 5.5962001959E+00, 6.4754868165E+00, 2.6307854845E+00, 8.9761571466E-01],
	[2.4680000000E+04, 2.1286466839E+01, 5.5961562555E+00, 6.4797638646E+00, 2.6315865830E+00, 8.9767198321E-01],
	[2.4685000000E+04, 2.1293345426E+01, 5.5961123242E+00, 6.4840428696E+00, 2.6323875068E+00, 8.9772822059E-01],
	[2.4690000000E+04, 2.1300224843E+01, 5.5960684023E+00, 6.4883238322E+00, 2.6331882559E+00, 8.9778442681E-01],
	[2.4695000000E+04, 2.1307124326E+01, 5.5960270939E+00, 6.4926067529E+00, 2.6339897011E+00, 8.9784060187E-01],
	[2.4700000000E+04, 2.1314035394E+01, 5.5959872486E+00, 6.4968916320E+00, 2.6347914589E+00, 8.9789674581E-01],
	[2.4705000000E+04, 2.1320947304E+01, 5.5959474117E+00, 6.5011784702E+00, 2.6355930428E+00, 8.9795285862E-01],
	[2.4710000000E+04, 2.1327860056E+01, 5.5959075831E+00, 6.5054672679E+00, 2.6363944527E+00, 8.9800894034E-01],
	[2.4715000000E+04, 2.1334773650E+01, 5.5958677629E+00, 6.5097580256E+00, 2.6371956887E+00, 8.9806499097E-01],
	[2.4720000000E+04, 2.1341688086E+01, 5.5958279510E+00, 6.5140507438E+00, 2.6379967505E+00, 8.9812101052E-01],
	[2.4725000000E+04, 2.1348603364E+01, 5.5957881475E+00, 6.5183454231E+00, 2.6387976382E+00, 8.9817699902E-01],
	[2.4730000000E+04, 2.1355519484E+01, 5.5957483522E+00, 6.5226420638E+00, 2.6395983516E+00, 8.9823295648E-01],
	[2.4735000000E+04, 2.1362436445E+01, 5.5957085653E+00, 6.5269406666E+00, 2.6403988907E+00, 8.9828888291E-01],
	[2.4740000000E+04, 2.1369354248E+01, 5.5956687868E+00, 6.5312412319E+00, 2.6411992555E+00, 8.9834477834E-01],
	[2.4745000000E+04, 2.1376272892E+01, 5.5956290165E+00, 6.5355437602E+00, 2.6419994457E+00, 8.9840064276E-01],
	[2.4750000000E+04, 2.1383192378E+01, 5.5955892546E+00, 6.5398482520E+00, 2.6427994615E+00, 8.9845647621E-01],
	[2.4755000000E+04, 2.1390112705E+01, 5.5955495010E+00, 6.5441547078E+00, 2.6435993026E+00, 8.9851227869E-01],
	[2.4760000000E+04, 2.1397033874E+01, 5.5955097557E+00, 6.5484631281E+00, 2.6443989690E+00, 8.9856805022E-01],
	[2.4765000000E+04, 2.1403955884E+01, 5.5954700187E+00, 6.5527735134E+00, 2.6451984606E+00, 8.9862379082E-01],
	[2.4770000000E+04, 2.1410878735E+01, 5.5954302900E+00, 6.5570858643E+00, 2.6459977775E+00, 8.9867950050E-01],
	[2.4775000000E+04, 2.1417802428E+01, 5.5953905696E+00, 6.5614001811E+00, 2.6467969194E+00, 8.9873517927E-01],
	[2.4780000000E+04, 2.1424726961E+01, 5.5953508575E+00, 6.5657164644E+00, 2.6475958863E+00, 8.9879082716E-01],
	[2.4785000000E+04, 2.1431652335E+01, 5.5953111537E+00, 6.5700347148E+00, 2.6483946782E+00, 8.9884644417E-01],
	[2.4790000000E+04, 2.1438578551E+01, 5.5952714582E+00, 6.5743549326E+00, 2.6491932949E+00, 8.9890203032E-01],
	[2.4795000000E+04, 2.1445505607E+01, 5.5952317709E+00, 6.5786771184E+00, 2.6499917365E+00, 8.9895758564E-01],
	[2.4800000000E+04, 2.1452433504E+01, 5.5951920920E+00, 6.5830012728E+00, 2.6507900028E+00, 8.9901311012E-01],
	[2.4805000000E+04, 2.1459362242E+01, 5.5951524213E+00, 6.5873273961E+00, 2.6515880937E+00, 8.9906860379E-01],
	[2.4810000000E+04, 2.1466291820E+01, 5.5951127589E+00, 6.5916554889E+00, 2.6523860092E+00, 8.9912406667E-01],
	[2.4815000000E+04, 2.1473222239E+01, 5.5950731048E+00, 6.5959855517E+00, 2.6531837492E+00, 8.9917949876E-01],
	[2.4820000000E+04, 2.1480153499E+01, 5.5950334590E+00, 6.6003175850E+00, 2.6539813136E+00, 8.9923490009E-01],
	[2.4825000000E+04, 2.1487085599E+01, 5.5949938214E+00, 6.6046515893E+00, 2.6547787024E+00, 8.9929027067E-01],
	[2.4830000000E+04, 2.1494018540E+01, 5.5949541921E+00, 6.6089875651E+00, 2.6555759155E+00, 8.9934561051E-01],
	[2.4835000000E+04, 2.1500952320E+01, 5.5949145710E+00, 6.6133255129E+00, 2.6563729528E+00, 8.9940091963E-01],
	[2.4840000000E+04, 2.1507886942E+01, 5.5948749583E+00, 6.6176654331E+00, 2.6571698143E+00, 8.9945619804E-01],
	[2.4845000000E+04, 2.1514822403E+01, 5.5948353537E+00, 6.6220073264E+00, 2.6579664998E+00, 8.9951144577E-01],
	[2.4850000000E+04, 2.1521758704E+01, 5.5947957574E+00, 6.6263511931E+00, 2.6587630094E+00, 8.9956666282E-01],
	[2.4855000000E+04, 2.1528695846E+01, 5.5947561694E+00, 6.6306970338E+00, 2.6595593428E+00, 8.9962184922E-01],
	[2.4860000000E+04, 2.1535633827E+01, 5.5947165896E+00, 6.6350448491E+00, 2.6603555002E+00, 8.9967700497E-01],
	[2.4865000000E+04, 2.1542572649E+01, 5.5946770180E+00, 6.6393946393E+00, 2.6611514813E+00, 8.9973213009E-01],
	[2.4870000000E+04, 2.1549512310E+01, 5.5946374547E+00, 6.6437464049E+00, 2.6619472861E+00, 8.9978722460E-01],
	[2.4875000000E+04, 2.1556452811E+01, 5.5945978996E+00, 6.6481001466E+00, 2.6627429146E+00, 8.9984228851E-01],
	[2.4880000000E+04, 2.1563394152E+01, 5.5945583527E+00, 6.6524558647E+00, 2.6635383667E+00, 8.9989732184E-01],
	[2.4885000000E+04, 2.1570336333E+01, 5.5945188141E+00, 6.6568135599E+00, 2.6643336423E+00, 8.9995232460E-01],
	[2.4890000000E+04, 2.1577279353E+01, 5.5944792837E+00, 6.6611732325E+00, 2.6651287413E+00, 9.0000729681E-01],
	[2.4895000000E+04, 2.1584223213E+01, 5.5944397615E+00, 6.6655348831E+00, 2.6659236637E+00, 9.0006223848E-01],
	[2.4900000000E+04, 2.1591167912E+01, 5.5944002475E+00, 6.6698985121E+00, 2.6667184094E+00, 9.0011714964E-01],
	[2.4905000000E+04, 2.1598113450E+01, 5.5943607417E+00, 6.6742641202E+00, 2.6675129783E+00, 9.0017203028E-01],
	[2.4910000000E+04, 2.1605059828E+01, 5.5943212442E+00, 6.6786317077E+00, 2.6683073703E+00, 9.0022688044E-01],
	[2.4915000000E+04, 2.1612007045E+01, 5.5942817548E+00, 6.6830012752E+00, 2.6691015855E+00, 9.0028170013E-01],
	[2.4920000000E+04, 2.1618955102E+01, 5.5942422737E+00, 6.6873728232E+00, 2.6698956237E+00, 9.0033648935E-01],
	[2.4925000000E+04, 2.1625903997E+01, 5.5942028007E+00, 6.6917463522E+00, 2.6706894848E+00, 9.0039124813E-01],
	[2.4930000000E+04, 2.1632853732E+01, 5.5941633360E+00, 6.6961218626E+00, 2.6714831688E+00, 9.0044597648E-01],
	[2.4935000000E+04, 2.1639804305E+01, 5.5941238794E+00, 6.7004993550E+00, 2.6722766756E+00, 9.0050067442E-01],
	[2.4940000000E+04, 2.1646755718E+01, 5.5940844310E+00, 6.7048788299E+00, 2.6730700052E+00, 9.0055534196E-01],
	[2.4945000000E+04, 2.1653707969E+01, 5.5940449908E+00, 6.7092602878E+00, 2.6738631574E+00, 9.0060997912E-01],
	[2.4950000000E+04, 2.1660661059E+01, 5.5940055588E+00, 6.7136437291E+00, 2.6746561323E+00, 9.0066458591E-01],
	[2.4955000000E+04, 2.1667614988E+01, 5.5939661350E+00, 6.7180291545E+00, 2.6754489296E+00, 9.0071916235E-01],
	[2.4960000000E+04, 2.1674569755E+01, 5.5939267194E+00, 6.7224165642E+00, 2.6762415495E+00, 9.0077370846E-01],
	[2.4965000000E+04, 2.1681525361E+01, 5.5938873119E+00, 6.7268059590E+00, 2.6770339917E+00, 9.0082822424E-01],
	[2.4970000000E+04, 2.1688481806E+01, 5.5938479126E+00, 6.7311973393E+00, 2.6778262563E+00, 9.0088270972E-01],
	[2.4975000000E+04, 2.1695439089E+01, 5.5938085214E+00, 6.7355907055E+00, 2.6786183431E+00, 9.0093716491E-01],
	[2.4980000000E+04, 2.1702397211E+01, 5.5937691385E+00, 6.7399860582E+00, 2.6794102522E+00, 9.0099158982E-01],
	[2.4985000000E+04, 2.1709356170E+01, 5.5937297636E+00, 6.7443833978E+00, 2.6802019834E+00, 9.0104598448E-01],
	[2.4990000000E+04, 2.1716315968E+01, 5.5936903970E+00, 6.7487827250E+00, 2.6809935366E+00, 9.0110034889E-01],
	[2.4995000000E+04, 2.1723276605E+01, 5.5936510385E+00, 6.7531840401E+00, 2.6817849118E+00, 9.0115468307E-01],
	[2.5000000000E+04, 2.1730238079E+01, 5.5936116881E+00, 6.7575873437E+00, 2.6825761090E+00, 9.0120898704E-01],
	[2.5005000000E+04, 2.1737200392E+01, 5.5935723459E+00, 6.7620053430E+00, 2.6833691290E+00, 9.0126326081E-01],
	[2.5010000000E+04, 2.1744163542E+01, 5.5935330118E+00, 6.7664253459E+00, 2.6841619702E+00, 9.0131750440E-01],
	[2.5015000000E+04, 2.1751127530E+01, 5.5934936859E+00, 6.7708473528E+00, 2.6849546324E+00, 9.0137171783E-01],
	[2.5020000000E+04, 2.1758092357E+01, 5.5934543681E+00, 6.7752713643E+00, 2.6857471156E+00, 9.0142590110E-01],
	[2.5025000000E+04, 2.1765058021E+01, 5.5934150584E+00, 6.7796973807E+00, 2.6865394198E+00, 9.0148005423E-01],
	[2.5030000000E+04, 2.1772024522E+01, 5.5933757569E+00, 6.7841254028E+00, 2.6873315449E+00, 9.0153417725E-01],
	[2.5035000000E+04, 2.1778991862E+01, 5.5933364635E+00, 6.7885554308E+00, 2.6881234908E+00, 9.0158827016E-01],
	[2.5040000000E+04, 2.1785960039E+01, 5.5932971782E+00, 6.7929874655E+00, 2.6889152574E+00, 9.0164233298E-01],
	[2.5045000000E+04, 2.1792929053E+01, 5.5932579010E+00, 6.7974215072E+00, 2.6897068447E+00, 9.0169636573E-01],
	[2.5050000000E+04, 2.1799898905E+01, 5.5932186320E+00, 6.8018575564E+00, 2.6904982526E+00, 9.0175036842E-01],
	[2.5055000000E+04, 2.1806869595E+01, 5.5931793711E+00, 6.8062956138E+00, 2.6912894810E+00, 9.0180434107E-01],
	[2.5060000000E+04, 2.1813841121E+01, 5.5931401182E+00, 6.8107356797E+00, 2.6920805299E+00, 9.0185828369E-01],
	[2.5065000000E+04, 2.1820813485E+01, 5.5931008735E+00, 6.8151777548E+00, 2.6928713992E+00, 9.0191219629E-01],
	[2.5070000000E+04, 2.1827786686E+01, 5.5930616369E+00, 6.8196218394E+00, 2.6936620889E+00, 9.0196607890E-01],
	[2.5075000000E+04, 2.1834760725E+01, 5.5930224084E+00, 6.8240679342E+00, 2.6944525989E+00, 9.0201993153E-01],
	[2.5080000000E+04, 2.1841735600E+01, 5.5929831880E+00, 6.8285160396E+00, 2.6952429290E+00, 9.0207375419E-01],
	[2.5085000000E+04, 2.1848711312E+01, 5.5929439756E+00, 6.8329661561E+00, 2.6960330793E+00, 9.0212754691E-01],
	[2.5090000000E+04, 2.1855692070E+01, 5.5929053336E+00, 6.8374182842E+00, 2.6968232445E+00, 9.0218130968E-01],
	[2.5095000000E+04, 2.1862699359E+01, 5.5928701305E+00, 6.8418724245E+00, 2.6976144192E+00, 9.0223504254E-01],
	[2.5100000000E+04, 2.1869707499E+01, 5.5928349346E+00, 6.8463285775E+00, 2.6984054149E+00, 9.0228874549E-01],
	[2.5105000000E+04, 2.1876716488E+01, 5.5927997460E+00, 6.8507867436E+00, 2.6991962316E+00, 9.0234241856E-01],
	[2.5110000000E+04, 2.1883726326E+01, 5.5927645646E+00, 6.8552469233E+00, 2.6999868692E+00, 9.0239606175E-01],
	[2.5115000000E+04, 2.1890737015E+01, 5.5927293904E+00, 6.8597091173E+00, 2.7007773276E+00, 9.0244967508E-01],
	[2.5120000000E+04, 2.1897748553E+01, 5.5926942235E+00, 6.8641733259E+00, 2.7015676067E+00, 9.0250325858E-01],
	[2.5125000000E+04, 2.1904760941E+01, 5.5926590637E+00, 6.8686395497E+00, 2.7023577065E+00, 9.0255681224E-01],
	[2.5130000000E+04, 2.1911774179E+01, 5.5926239112E+00, 6.8731077892E+00, 2.7031476270E+00, 9.0261033610E-01],
	[2.5135000000E+04, 2.1918788266E+01, 5.5925887659E+00, 6.8775780449E+00, 2.7039373681E+00, 9.0266383015E-01],
	[2.5140000000E+04, 2.1925803202E+01, 5.5925536278E+00, 6.8820503173E+00, 2.7047269296E+00, 9.0271729443E-01],
	[2.5145000000E+04, 2.1932818988E+01, 5.5925184970E+00, 6.8865246070E+00, 2.7055163116E+00, 9.0277072894E-01],
	[2.5150000000E+04, 2.1939835623E+01, 5.5924833733E+00, 6.8910009144E+00, 2.7063055139E+00, 9.0282413371E-01],
	[2.5155000000E+04, 2.1946853108E+01, 5.5924482568E+00, 6.8954792400E+00, 2.7070945366E+00, 9.0287750874E-01],
	[2.5160000000E+04, 2.1953871441E+01, 5.5924131475E+00, 6.8999595843E+00, 2.7078833795E+00, 9.0293085405E-01],
	[2.5165000000E+04, 2.1960890624E+01, 5.5923780455E+00, 6.9044419479E+00, 2.7086720425E+00, 9.0298416966E-01],
	[2.5170000000E+04, 2.1967910656E+01, 5.5923429506E+00, 6.9089263313E+00, 2.7094605257E+00, 9.0303745558E-01],
	[2.5175000000E+04, 2.1974931536E+01, 5.5923078629E+00, 6.9134127350E+00, 2.7102488290E+00, 9.0309071183E-01],
	[2.5180000000E+04, 2.1981953266E+01, 5.5922727824E+00, 6.9179011594E+00, 2.7110369522E+00, 9.0314393842E-01],
	[2.5185000000E+04, 2.1988975844E+01, 5.5922377091E+00, 6.9223916051E+00, 2.7118248954E+00, 9.0319713537E-01],
	[2.5190000000E+04, 2.1995999272E+01, 5.5922026429E+00, 6.9268840726E+00, 2.7126126584E+00, 9.0325030270E-01],
	[2.5195000000E+04, 2.2003023548E+01, 5.5921675840E+00, 6.9313785624E+00, 2.7134002413E+00, 9.0330344042E-01],
	[2.5200000000E+04, 2.2010048672E+01, 5.5921325322E+00, 6.9358750750E+00, 2.7141876438E+00, 9.0335654854E-01],
	[2.5205000000E+04, 2.2017074645E+01, 5.5920974876E+00, 6.9403736110E+00, 2.7149748661E+00, 9.0340962708E-01],
	[2.5210000000E+04, 2.2024101467E+01, 5.5920624502E+00, 6.9448741707E+00, 2.7157619080E+00, 9.0346267605E-01],
	[2.5215000000E+04, 2.2031129137E+01, 5.5920274199E+00, 6.9493767548E+00, 2.7165487694E+00, 9.0351569547E-01],
	[2.5220000000E+04, 2.2038157655E+01, 5.5919923968E+00, 6.9538813638E+00, 2.7173354503E+00, 9.0356868535E-01],
	[2.5225000000E+04, 2.2045187022E+01, 5.5919573808E+00, 6.9583879981E+00, 2.7181219506E+00, 9.0362164571E-01],
	[2.5230000000E+04, 2.2052217237E+01, 5.5919223721E+00, 6.9628966583E+00, 2.7189082704E+00, 9.0367457656E-01],
	[2.5235000000E+04, 2.2059248301E+01, 5.5918873704E+00, 6.9674073448E+00, 2.7196944094E+00, 9.0372747791E-01],
	[2.5240000000E+04, 2.2066280212E+01, 5.5918523760E+00, 6.9719200582E+00, 2.7204803676E+00, 9.0378034978E-01],
	[2.5245000000E+04, 2.2073312971E+01, 5.5918173887E+00, 6.9764347990E+00, 2.7212661451E+00, 9.0383319218E-01],
	[2.5250000000E+04, 2.2080346579E+01, 5.5917824085E+00, 6.9809515677E+00, 2.7220517416E+00, 9.0388600513E-01],
	[2.5255000000E+04, 2.2087381034E+01, 5.5917474355E+00, 6.9854703648E+00, 2.7228371573E+00, 9.0393878863E-01],
	[2.5260000000E+04, 2.2094416337E+01, 5.5917124696E+00, 6.9899911908E+00, 2.7236223919E+00, 9.0399154272E-01],
	[2.5265000000E+04, 2.2101452488E+01, 5.5916775108E+00, 6.9945140462E+00, 2.7244074454E+00, 9.0404426739E-01],
	[2.5270000000E+04, 2.2108489487E+01, 5.5916425592E+00, 6.9990389316E+00, 2.7251923179E+00, 9.0409696266E-01],
	[2.5275000000E+04, 2.2115527333E+01, 5.5916076147E+00, 7.0035658474E+00, 2.7259770091E+00, 9.0414962856E-01],
	[2.5280000000E+04, 2.2122566027E+01, 5.5915726774E+00, 7.0080947941E+00, 2.7267615191E+00, 9.0420226508E-01],
	[2.5285000000E+04, 2.2129605568E+01, 5.5915377472E+00, 7.0126257723E+00, 2.7275458479E+00, 9.0425487225E-01],
	[2.5290000000E+04, 2.2136645957E+01, 5.5915028241E+00, 7.0171587825E+00, 2.7283299952E+00, 9.0430745008E-01],
	[2.5295000000E+04, 2.2143687194E+01, 5.5914679081E+00, 7.0216938251E+00, 2.7291139611E+00, 9.0435999858E-01],
	[2.5300000000E+04, 2.2150729277E+01, 5.5914329992E+00, 7.0262309008E+00, 2.7298977456E+00, 9.0441251778E-01],
	[2.5305000000E+04, 2.2157772208E+01, 5.5913980975E+00, 7.0307700099E+00, 2.7306813485E+00, 9.0446500767E-01],
	[2.5310000000E+04, 2.2164815986E+01, 5.5913632029E+00, 7.0353111530E+00, 2.7314647697E+00, 9.0451746828E-01],
	[2.5315000000E+04, 2.2171860611E+01, 5.5913283154E+00, 7.0398543306E+00, 2.7322480094E+00, 9.0456989963E-01],
	[2.5320000000E+04, 2.2178906084E+01, 5.5912934350E+00, 7.0443995432E+00, 2.7330310673E+00, 9.0462230172E-01],
	[2.5325000000E+04, 2.2185952403E+01, 5.5912585617E+00, 7.0489467914E+00, 2.7338139434E+00, 9.0467467457E-01],
	[2.5330000000E+04, 2.2192999569E+01, 5.5912236955E+00, 7.0534960756E+00, 2.7345966377E+00, 9.0472701819E-01],
	[2.5335000000E+04, 2.2200047582E+01, 5.5911888364E+00, 7.0580473963E+00, 2.7353791501E+00, 9.0477933260E-01],
	[2.5340000000E+04, 2.2207096442E+01, 5.5911539844E+00, 7.0626007541E+00, 2.7361614805E+00, 9.0483161781E-01],
	[2.5345000000E+04, 2.2214146149E+01, 5.5911191395E+00, 7.0671561495E+00, 2.7369436289E+00, 9.0488387384E-01],
	[2.5350000000E+04, 2.2221196702E+01, 5.5910843016E+00, 7.0717135829E+00, 2.7377255953E+00, 9.0493610070E-01],
	[2.5355000000E+04, 2.2228248102E+01, 5.5910494709E+00, 7.0762730550E+00, 2.7385073795E+00, 9.0498829841E-01],
	[2.5360000000E+04, 2.2235300349E+01, 5.5910146473E+00, 7.0808345661E+00, 2.7392889815E+00, 9.0504046698E-01],
	[2.5365000000E+04, 2.2242353442E+01, 5.5909798307E+00, 7.0853981168E+00, 2.7400704013E+00, 9.0509260642E-01],
	[2.5370000000E+04, 2.2249407381E+01, 5.5909450212E+00, 7.0899637076E+00, 2.7408516388E+00, 9.0514471675E-01],
	[2.5375000000E+04, 2.2256462167E+01, 5.5909102188E+00, 7.0945313390E+00, 2.7416326939E+00, 9.0519679798E-01],
	[2.5380000000E+04, 2.2263517799E+01, 5.5908754235E+00, 7.0991010116E+00, 2.7424135665E+00, 9.0524885013E-01],
	[2.5385000000E+04, 2.2270574277E+01, 5.5908406352E+00, 7.1036727257E+00, 2.7431942567E+00, 9.0530087321E-01],
	[2.5390000000E+04, 2.2277631601E+01, 5.5908058540E+00, 7.1082464821E+00, 2.7439747644E+00, 9.0535286723E-01],
	[2.5395000000E+04, 2.2284689772E+01, 5.5907710799E+00, 7.1128222811E+00, 2.7447550895E+00, 9.0540483222E-01],
	[2.5400000000E+04, 2.2291748788E+01, 5.5907363128E+00, 7.1174001232E+00, 2.7455352319E+00, 9.0545676818E-01],
	[2.5405000000E+04, 2.2298808651E+01, 5.5907015528E+00, 7.1219800091E+00, 2.7463151916E+00, 9.0550867512E-01],
	[2.5410000000E+04, 2.2305869359E+01, 5.5906667998E+00, 7.1265619391E+00, 2.7470949686E+00, 9.0556055307E-01],
	[2.5415000000E+04, 2.2312930913E+01, 5.5906320539E+00, 7.1311459138E+00, 2.7478745627E+00, 9.0561240204E-01],
	[2.5420000000E+04, 2.2319993313E+01, 5.5905973151E+00, 7.1357319337E+00, 2.7486539739E+00, 9.0566422204E-01],
	[2.5425000000E+04, 2.2327056559E+01, 5.5905625833E+00, 7.1403199993E+00, 2.7494332022E+00, 9.0571601308E-01],
	[2.5430000000E+04, 2.2334120650E+01, 5.5905278585E+00, 7.1449101111E+00, 2.7502122475E+00, 9.0576777519E-01],
	[2.5435000000E+04, 2.2341185587E+01, 5.5904931408E+00, 7.1495022697E+00, 2.7509911098E+00, 9.0581950837E-01],
	[2.5440000000E+04, 2.2348251369E+01, 5.5904584301E+00, 7.1540964755E+00, 2.7517697890E+00, 9.0587121264E-01],
	[2.5445000000E+04, 2.2355317997E+01, 5.5904237265E+00, 7.1586927290E+00, 2.7525482850E+00, 9.0592288801E-01],
	[2.5450000000E+04, 2.2362385470E+01, 5.5903890299E+00, 7.1632910308E+00, 2.7533265978E+00, 9.0597453450E-01],
	[2.5455000000E+04, 2.2369453789E+01, 5.5903543403E+00, 7.1678913814E+00, 2.7541047273E+00, 9.0602615212E-01],
	[2.5460000000E+04, 2.2376522953E+01, 5.5903196578E+00, 7.1724937813E+00, 2.7548826735E+00, 9.0607774088E-01],
	[2.5465000000E+04, 2.2383592961E+01, 5.5902849822E+00, 7.1770982309E+00, 2.7556604363E+00, 9.0612930081E-01],
	[2.5470000000E+04, 2.2390663815E+01, 5.5902503138E+00, 7.1817047309E+00, 2.7564380157E+00, 9.0618083192E-01],
	[2.5475000000E+04, 2.2397735514E+01, 5.5902156523E+00, 7.1863132816E+00, 2.7572154116E+00, 9.0623233421E-01],
	[2.5480000000E+04, 2.2404808058E+01, 5.5901809978E+00, 7.1909238837E+00, 2.7579926239E+00, 9.0628380770E-01],
	[2.5485000000E+04, 2.2411881447E+01, 5.5901463504E+00, 7.1955365376E+00, 2.7587696527E+00, 9.0633525242E-01],
	[2.5490000000E+04, 2.2418955681E+01, 5.5901117099E+00, 7.2001512438E+00, 2.7595464978E+00, 9.0638666837E-01],
	[2.5495000000E+04, 2.2426041440E+01, 5.5900784865E+00, 7.2047680029E+00, 2.7603236647E+00, 9.0643805556E-01],
	[2.5500000000E+04, 2.2433147031E+01, 5.5900477755E+00, 7.2093868153E+00, 2.7611015472E+00, 9.0648941402E-01],
	[2.5505000000E+04, 2.2440253481E+01, 5.5900170706E+00, 7.2140076816E+00, 2.7618792469E+00, 9.0654074375E-01],
	[2.5510000000E+04, 2.2447360787E+01, 5.5899863719E+00, 7.2186306023E+00, 2.7626567637E+00, 9.0659204477E-01],
	[2.5515000000E+04, 2.2454468952E+01, 5.5899556794E+00, 7.2232555778E+00, 2.7634340977E+00, 9.0664331710E-01],
	[2.5520000000E+04, 2.2461577973E+01, 5.5899249930E+00, 7.2278826088E+00, 2.7642112487E+00, 9.0669456074E-01],
	[2.5525000000E+04, 2.2468687852E+01, 5.5898943129E+00, 7.2325116957E+00, 2.7649882166E+00, 9.0674577572E-01],
	[2.5530000000E+04, 2.2475798589E+01, 5.5898636389E+00, 7.2371428389E+00, 2.7657650016E+00, 9.0679696205E-01],
	[2.5535000000E+04, 2.2482910182E+01, 5.5898329711E+00, 7.2417760391E+00, 2.7665416034E+00, 9.0684811974E-01],
	[2.5540000000E+04, 2.2490022633E+01, 5.5898023095E+00, 7.2464112968E+00, 2.7673180220E+00, 9.0689924881E-01],
	[2.5545000000E+04, 2.2497135941E+01, 5.5897716540E+00, 7.2510486124E+00, 2.7680942575E+00, 9.0695034926E-01],
	[2.5550000000E+04, 2.2504250105E+01, 5.5897410047E+00, 7.2556879864E+00, 2.7688703096E+00, 9.0700142113E-01],
	[2.5555000000E+04, 2.2511365127E+01, 5.5897103616E+00, 7.2603294194E+00, 2.7696461785E+00, 9.0705246441E-01],
	[2.5560000000E+04, 2.2518481006E+01, 5.5896797246E+00, 7.2649729119E+00, 2.7704218639E+00, 9.0710347913E-01],
	[2.5565000000E+04, 2.2525597741E+01, 5.5896490938E+00, 7.2696184643E+00, 2.7711973660E+00, 9.0715446530E-01],
	[2.5570000000E+04, 2.2532715333E+01, 5.5896184692E+00, 7.2742660773E+00, 2.7719726845E+00, 9.0720542293E-01],
	[2.5575000000E+04, 2.2539833782E+01, 5.5895878507E+00, 7.2789157513E+00, 2.7727478195E+00, 9.0725635203E-01],
	[2.5580000000E+04, 2.2546953088E+01, 5.5895572384E+00, 7.2835674868E+00, 2.7735227709E+00, 9.0730725264E-01],
	[2.5585000000E+04, 2.2554073250E+01, 5.5895266322E+00, 7.2882212843E+00, 2.7742975387E+00, 9.0735812474E-01],
	[2.5590000000E+04, 2.2561194268E+01, 5.5894960322E+00, 7.2928771443E+00, 2.7750721228E+00, 9.0740896837E-01],
	[2.5595000000E+04, 2.2568316143E+01, 5.5894654383E+00, 7.2975350675E+00, 2.7758465231E+00, 9.0745978354E-01],
	[2.5600000000E+04, 2.2575438875E+01, 5.5894348505E+00, 7.3021950541E+00, 2.7766207396E+00, 9.0751057025E-01],
	[2.5605000000E+04, 2.2582562462E+01, 5.5894042689E+00, 7.3068571048E+00, 2.7773947723E+00, 9.0756132853E-01],
	[2.5610000000E+04, 2.2589686906E+01, 5.5893736935E+00, 7.3115212202E+00, 2.7781686210E+00, 9.0761205839E-01],
	[2.5615000000E+04, 2.2596812206E+01, 5.5893431241E+00, 7.3161874006E+00, 2.7789422859E+00, 9.0766275984E-01],
	[2.5620000000E+04, 2.2603938363E+01, 5.5893125609E+00, 7.3208556466E+00, 2.7797157667E+00, 9.0771343290E-01],
	[2.5625000000E+04, 2.2611065375E+01, 5.5892820039E+00, 7.3255259587E+00, 2.7804890634E+00, 9.0776407758E-01],
	[2.5630000000E+04, 2.2618193243E+01, 5.5892514529E+00, 7.3301983374E+00, 2.7812621760E+00, 9.0781469390E-01],
	[2.5635000000E+04, 2.2625321967E+01, 5.5892209081E+00, 7.3348727833E+00, 2.7820351045E+00, 9.0786528187E-01],
	[2.5640000000E+04, 2.2632451547E+01, 5.5891903694E+00, 7.3395492968E+00, 2.7828078488E+00, 9.0791584151E-01],
	[2.5645000000E+04, 2.2639581983E+01, 5.5891598369E+00, 7.3442278785E+00, 2.7835804088E+00, 9.0796637283E-01],
	[2.5650000000E+04, 2.2646713275E+01, 5.5891293104E+00, 7.3489085288E+00, 2.7843527845E+00, 9.0801687584E-01],
	[2.5655000000E+04, 2.2653845422E+01, 5.5890987901E+00, 7.3535912483E+00, 2.7851249758E+00, 9.0806735056E-01],
	[2.5660000000E+04, 2.2660978425E+01, 5.5890682759E+00, 7.3582760375E+00, 2.7858969827E+00, 9.0811779701E-01],
	[2.5665000000E+04, 2.2668112283E+01, 5.5890377678E+00, 7.3629628969E+00, 2.7866688051E+00, 9.0816821519E-01],
	[2.5670000000E+04, 2.2675246997E+01, 5.5890072658E+00, 7.3676518270E+00, 2.7874404430E+00, 9.0821860513E-01],
	[2.5675000000E+04, 2.2682382566E+01, 5.5889767699E+00, 7.3723428283E+00, 2.7882118964E+00, 9.0826896683E-01],
	[2.5680000000E+04, 2.2689518991E+01, 5.5889462801E+00, 7.3770359013E+00, 2.7889831651E+00, 9.0831930032E-01],
	[2.5685000000E+04, 2.2696656270E+01, 5.5889157964E+00, 7.3817310466E+00, 2.7897542492E+00, 9.0836960560E-01],
	[2.5690000000E+04, 2.2703794405E+01, 5.5888853188E+00, 7.3864282646E+00, 2.7905251485E+00, 9.0841988270E-01],
	[2.5695000000E+04, 2.2710933396E+01, 5.5888548474E+00, 7.3911275559E+00, 2.7912958631E+00, 9.0847013162E-01],
	[2.5700000000E+04, 2.2718073241E+01, 5.5888243820E+00, 7.3958289210E+00, 2.7920663929E+00, 9.0852035238E-01],
	[2.5705000000E+04, 2.2725213941E+01, 5.5887939227E+00, 7.4005323603E+00, 2.7928367378E+00, 9.0857054499E-01],
	[2.5710000000E+04, 2.2732355497E+01, 5.5887634695E+00, 7.4052378744E+00, 2.7936068978E+00, 9.0862070947E-01],
	[2.5715000000E+04, 2.2739497907E+01, 5.5887330223E+00, 7.4099454639E+00, 2.7943768728E+00, 9.0867084584E-01],
	[2.5720000000E+04, 2.2746641172E+01, 5.5887025813E+00, 7.4146551291E+00, 2.7951466628E+00, 9.0872095411E-01],
	[2.5725000000E+04, 2.2753785292E+01, 5.5886721464E+00, 7.4193668707E+00, 2.7959162678E+00, 9.0877103428E-01],
	[2.5730000000E+04, 2.2760930266E+01, 5.5886417175E+00, 7.4240806892E+00, 2.7966856876E+00, 9.0882108639E-01],
	[2.5735000000E+04, 2.2768076095E+01, 5.5886112947E+00, 7.4287965849E+00, 2.7974549223E+00, 9.0887111044E-01],
	[2.5740000000E+04, 2.2775222779E+01, 5.5885808780E+00, 7.4335145586E+00, 2.7982239718E+00, 9.0892110644E-01],
	[2.5745000000E+04, 2.2782370317E+01, 5.5885504674E+00, 7.4382346106E+00, 2.7989928360E+00, 9.0897107441E-01],
	[2.5750000000E+04, 2.2789518710E+01, 5.5885200628E+00, 7.4429567415E+00, 2.7997615149E+00, 9.0902101437E-01],
	[2.5755000000E+04, 2.2796667957E+01, 5.5884896643E+00, 7.4476809517E+00, 2.8005300085E+00, 9.0907092633E-01],
	[2.5760000000E+04, 2.2803818058E+01, 5.5884592718E+00, 7.4524072419E+00, 2.8012983166E+00, 9.0912081030E-01],
	[2.5765000000E+04, 2.2810969014E+01, 5.5884288855E+00, 7.4571356125E+00, 2.8020664393E+00, 9.0917066630E-01],
	[2.5770000000E+04, 2.2818120824E+01, 5.5883985052E+00, 7.4618660641E+00, 2.8028343765E+00, 9.0922049435E-01],
	[2.5775000000E+04, 2.2825273488E+01, 5.5883681309E+00, 7.4665985970E+00, 2.8036021282E+00, 9.0927029445E-01],
	[2.5780000000E+04, 2.2832427006E+01, 5.5883377627E+00, 7.4713332120E+00, 2.8043696943E+00, 9.0932006663E-01],
	[2.5785000000E+04, 2.2839581378E+01, 5.5883074006E+00, 7.4760699093E+00, 2.8051370747E+00, 9.0936981089E-01],
	[2.5790000000E+04, 2.2846736604E+01, 5.5882770445E+00, 7.4808086897E+00, 2.8059042695E+00, 9.0941952726E-01],
	[2.5795000000E+04, 2.2853892684E+01, 5.5882466944E+00, 7.4855495535E+00, 2.8066712785E+00, 9.0946921574E-01],
	[2.5800000000E+04, 2.2861049617E+01, 5.5882163505E+00, 7.4902925014E+00, 2.8074381018E+00, 9.0951887635E-01],
	[2.5805000000E+04, 2.2868207405E+01, 5.5881860125E+00, 7.4950375337E+00, 2.8082047392E+00, 9.0956850911E-01],
	[2.5810000000E+04, 2.2875366046E+01, 5.5881556806E+00, 7.4997846511E+00, 2.8089711907E+00, 9.0961811403E-01],
	[2.5815000000E+04, 2.2882525540E+01, 5.5881253547E+00, 7.5045338540E+00, 2.8097374563E+00, 9.0966769112E-01],
	[2.5820000000E+04, 2.2889685889E+01, 5.5880950349E+00, 7.5092851429E+00, 2.8105035360E+00, 9.0971724040E-01],
	[2.5825000000E+04, 2.2896847090E+01, 5.5880647211E+00, 7.5140385184E+00, 2.8112694296E+00, 9.0976676188E-01],
	[2.5830000000E+04, 2.2904009146E+01, 5.5880344134E+00, 7.5187939809E+00, 2.8120351372E+00, 9.0981625559E-01],
	[2.5835000000E+04, 2.2911172054E+01, 5.5880041116E+00, 7.5235515311E+00, 2.8128006587E+00, 9.0986572152E-01],
	[2.5840000000E+04, 2.2918335816E+01, 5.5879738159E+00, 7.5283111693E+00, 2.8135659940E+00, 9.0991515970E-01],
	[2.5845000000E+04, 2.2925500431E+01, 5.5879435263E+00, 7.5330728961E+00, 2.8143311432E+00, 9.0996457015E-01],
	[2.5850000000E+04, 2.2932665899E+01, 5.5879132426E+00, 7.5378367120E+00, 2.8150961060E+00, 9.1001395287E-01],
	[2.5855000000E+04, 2.2939832221E+01, 5.5878829650E+00, 7.5426026176E+00, 2.8158608826E+00, 9.1006330788E-01],
	[2.5860000000E+04, 2.2946999395E+01, 5.5878526934E+00, 7.5473706133E+00, 2.8166254729E+00, 9.1011263520E-01],
	[2.5865000000E+04, 2.2954167423E+01, 5.5878224278E+00, 7.5521406996E+00, 2.8173898768E+00, 9.1016193483E-01],
	[2.5870000000E+04, 2.2961336303E+01, 5.5877921682E+00, 7.5569128771E+00, 2.8181540942E+00, 9.1021120681E-01],
	[2.5875000000E+04, 2.2968506036E+01, 5.5877619146E+00, 7.5616871463E+00, 2.8189181252E+00, 9.1026045113E-01],
	[2.5880000000E+04, 2.2975676622E+01, 5.5877316671E+00, 7.5664635076E+00, 2.8196819697E+00, 9.1030966781E-01],
	[2.5885000000E+04, 2.2982848061E+01, 5.5877014255E+00, 7.5712419617E+00, 2.8204456276E+00, 9.1035885688E-01],
	[2.5890000000E+04, 2.2990020352E+01, 5.5876711900E+00, 7.5760225089E+00, 2.8212090989E+00, 9.1040801833E-01],
	[2.5895000000E+04, 2.2997193496E+01, 5.5876409604E+00, 7.5808051499E+00, 2.8219723836E+00, 9.1045715220E-01],
	[2.5900000000E+04, 2.3004367493E+01, 5.5876107369E+00, 7.5855898851E+00, 2.8227354816E+00, 9.1050625848E-01],
	[2.5905000000E+04, 2.3011550542E+01, 5.5875815899E+00, 7.5903767150E+00, 2.8234987896E+00, 9.1055533721E-01],
	[2.5910000000E+04, 2.3018755649E+01, 5.5875552163E+00, 7.5951656402E+00, 2.8242629374E+00, 9.1060438838E-01],
	[2.5915000000E+04, 2.3025961622E+01, 5.5875288479E+00, 7.5999566612E+00, 2.8250268994E+00, 9.1065341202E-01],
	[2.5920000000E+04, 2.3033168460E+01, 5.5875024847E+00, 7.6047497784E+00, 2.8257906755E+00, 9.1070240814E-01],
	[2.5925000000E+04, 2.3040376162E+01, 5.5874761267E+00, 7.6095449924E+00, 2.8265542657E+00, 9.1075137676E-01],
	[2.5930000000E+04, 2.3047584730E+01, 5.5874497739E+00, 7.6143423037E+00, 2.8273176699E+00, 9.1080031789E-01],
	[2.5935000000E+04, 2.3054794162E+01, 5.5874234264E+00, 7.6191417129E+00, 2.8280808881E+00, 9.1084923154E-01],
	[2.5940000000E+04, 2.3062004459E+01, 5.5873970840E+00, 7.6239432204E+00, 2.8288439203E+00, 9.1089811772E-01],
	[2.5945000000E+04, 2.3069215621E+01, 5.5873707468E+00, 7.6287468267E+00, 2.8296067664E+00, 9.1094697647E-01],
	[2.5950000000E+04, 2.3076427647E+01, 5.5873444148E+00, 7.6335525323E+00, 2.8303694263E+00, 9.1099580778E-01],
	[2.5955000000E+04, 2.3083640538E+01, 5.5873180881E+00, 7.6383603379E+00, 2.8311319001E+00, 9.1104461167E-01],
	[2.5960000000E+04, 2.3090854293E+01, 5.5872917665E+00, 7.6431702438E+00, 2.8318941876E+00, 9.1109338816E-01],
	[2.5965000000E+04, 2.3098068913E+01, 5.5872654501E+00, 7.6479822505E+00, 2.8326562889E+00, 9.1114213726E-01],
	[2.5970000000E+04, 2.3105284397E+01, 5.5872391389E+00, 7.6527963587E+00, 2.8334182039E+00, 9.1119085899E-01],
	[2.5975000000E+04, 2.3112500745E+01, 5.5872128329E+00, 7.6576125688E+00, 2.8341799325E+00, 9.1123955336E-01],
	[2.5980000000E+04, 2.3119717958E+01, 5.5871865321E+00, 7.6624308814E+00, 2.8349414747E+00, 9.1128822039E-01],
	[2.5985000000E+04, 2.3126936035E+01, 5.5871602364E+00, 7.6672512968E+00, 2.8357028304E+00, 9.1133686008E-01],
	[2.5990000000E+04, 2.3134154976E+01, 5.5871339460E+00, 7.6720738157E+00, 2.8364639997E+00, 9.1138547247E-01],
	[2.5995000000E+04, 2.3141374781E+01, 5.5871076607E+00, 7.6768984386E+00, 2.8372249825E+00, 9.1143405755E-01],
	[2.6000000000E+04, 2.3148595450E+01, 5.5870813806E+00, 7.6817251660E+00, 2.8379857787E+00, 9.1148261534E-01],
	[2.6005000000E+04, 2.3155816982E+01, 5.5870551057E+00, 7.6865539983E+00, 2.8387463883E+00, 9.1153114586E-01],
	[2.6010000000E+04, 2.3163039379E+01, 5.5870288360E+00, 7.6913849361E+00, 2.8395068112E+00, 9.1157964913E-01],
	[2.6015000000E+04, 2.3170262640E+01, 5.5870025714E+00, 7.6962179800E+00, 2.8402670475E+00, 9.1162812515E-01],
	[2.6020000000E+04, 2.3177486764E+01, 5.5869763120E+00, 7.7010531304E+00, 2.8410270970E+00, 9.1167657395E-01],
	[2.6025000000E+04, 2.3184711752E+01, 5.5869500578E+00, 7.7058903878E+00, 2.8417869597E+00, 9.1172499553E-01],
	[2.6030000000E+04, 2.3191937603E+01, 5.5869238087E+00, 7.7107297527E+00, 2.8425466357E+00, 9.1177338992E-01],
	[2.6035000000E+04, 2.3199164318E+01, 5.5868975648E+00, 7.7155712258E+00, 2.8433061247E+00, 9.1182175712E-01],
	[2.6040000000E+04, 2.3206391897E+01, 5.5868713261E+00, 7.7204148074E+00, 2.8440654269E+00, 9.1187009715E-01],
	[2.6045000000E+04, 2.3213620339E+01, 5.5868450925E+00, 7.7252604981E+00, 2.8448245421E+00, 9.1191841003E-01],
	[2.6050000000E+04, 2.3220849644E+01, 5.5868188641E+00, 7.7301082984E+00, 2.8455834703E+00, 9.1196669576E-01],
	[2.6055000000E+04, 2.3228079812E+01, 5.5867926409E+00, 7.7349582088E+00, 2.8463422115E+00, 9.1201495438E-01],
	[2.6060000000E+04, 2.3235310844E+01, 5.5867664228E+00, 7.7398102298E+00, 2.8471007657E+00, 9.1206318588E-01],
	[2.6065000000E+04, 2.3242542739E+01, 5.5867402098E+00, 7.7446643620E+00, 2.8478591327E+00, 9.1211139028E-01],
	[2.6070000000E+04, 2.3249775497E+01, 5.5867140020E+00, 7.7495206058E+00, 2.8486173126E+00, 9.1215956761E-01],
	[2.6075000000E+04, 2.3257009118E+01, 5.5866877994E+00, 7.7543789618E+00, 2.8493753053E+00, 9.1220771786E-01],
	[2.6080000000E+04, 2.3264243602E+01, 5.5866616019E+00, 7.7592394304E+00, 2.8501331108E+00, 9.1225584107E-01],
	[2.6085000000E+04, 2.3271478949E+01, 5.5866354095E+00, 7.7641020123E+00, 2.8508907290E+00, 9.1230393723E-01],
	[2.6090000000E+04, 2.3278715159E+01, 5.5866092223E+00, 7.7689667079E+00, 2.8516481599E+00, 9.1235200637E-01],
	[2.6095000000E+04, 2.3285952232E+01, 5.5865830402E+00, 7.7738335176E+00, 2.8524054034E+00, 9.1240004850E-01],
	[2.6100000000E+04, 2.3293190167E+01, 5.5865568633E+00, 7.7787024422E+00, 2.8531624596E+00, 9.1244806363E-01],
	[2.6105000000E+04, 2.3300428965E+01, 5.5865306915E+00, 7.7835734819E+00, 2.8539193283E+00, 9.1249605178E-01],
	[2.6110000000E+04, 2.3307668626E+01, 5.5865045248E+00, 7.7884466374E+00, 2.8546760096E+00, 9.1254401296E-01],
	[2.6115000000E+04, 2.3314909149E+01, 5.5864783633E+00, 7.7933219092E+00, 2.8554325033E+00, 9.1259194717E-01],
	[2.6120000000E+04, 2.3322150534E+01, 5.5864522069E+00, 7.7981992978E+00, 2.8561888095E+00, 9.1263985445E-01],
	[2.6125000000E+04, 2.3329392782E+01, 5.5864260556E+00, 7.8030788036E+00, 2.8569449281E+00, 9.1268773479E-01],
	[2.6130000000E+04, 2.3336635893E+01, 5.5863999095E+00, 7.8079604273E+00, 2.8577008591E+00, 9.1273558821E-01],
	[2.6135000000E+04, 2.3343879866E+01, 5.5863737685E+00, 7.8128441693E+00, 2.8584566025E+00, 9.1278341473E-01],
	[2.6140000000E+04, 2.3351124700E+01, 5.5863476326E+00, 7.8177300301E+00, 2.8592121581E+00, 9.1283121436E-01],
	[2.6145000000E+04, 2.3358370398E+01, 5.5863215018E+00, 7.8226180102E+00, 2.8599675260E+00, 9.1287898712E-01],
	[2.6150000000E+04, 2.3365616957E+01, 5.5862953762E+00, 7.8275081103E+00, 2.8607227061E+00, 9.1292673301E-01],
	[2.6155000000E+04, 2.3372864378E+01, 5.5862692556E+00, 7.8324003307E+00, 2.8614776983E+00, 9.1297445204E-01],
	[2.6160000000E+04, 2.3380112661E+01, 5.5862431402E+00, 7.8372946720E+00, 2.8622325028E+00, 9.1302214425E-01],
	[2.6165000000E+04, 2.3387361806E+01, 5.5862170299E+00, 7.8421911347E+00, 2.8629871193E+00, 9.1306980963E-01],
	[2.6170000000E+04, 2.3394611813E+01, 5.5861909247E+00, 7.8470897193E+00, 2.8637415479E+00, 9.1311744820E-01],
	[2.6175000000E+04, 2.3401862682E+01, 5.5861648246E+00, 7.8519904263E+00, 2.8644957885E+00, 9.1316505997E-01],
	[2.6180000000E+04, 2.3409114412E+01, 5.5861387296E+00, 7.8568932563E+00, 2.8652498411E+00, 9.1321264496E-01],
	[2.6185000000E+04, 2.3416367005E+01, 5.5861126397E+00, 7.8617982097E+00, 2.8660037056E+00, 9.1326020318E-01],
	[2.6190000000E+04, 2.3423620458E+01, 5.5860865550E+00, 7.8667052871E+00, 2.8667573821E+00, 9.1330773464E-01],
	[2.6195000000E+04, 2.3430874774E+01, 5.5860604753E+00, 7.8716144890E+00, 2.8675108704E+00, 9.1335523937E-01],
	[2.6200000000E+04, 2.3438129951E+01, 5.5860344007E+00, 7.8765258159E+00, 2.8682641706E+00, 9.1340271736E-01],
	[2.6205000000E+04, 2.3445385989E+01, 5.5860083312E+00, 7.8814392683E+00, 2.8690172826E+00, 9.1345016864E-01],
	[2.6210000000E+04, 2.3452642888E+01, 5.5859822669E+00, 7.8863548467E+00, 2.8697702063E+00, 9.1349759322E-01],
	[2.6215000000E+04, 2.3459900649E+01, 5.5859562076E+00, 7.8912725516E+00, 2.8705229418E+00, 9.1354499111E-01],
	[2.6220000000E+04, 2.3467159271E+01, 5.5859301534E+00, 7.8961923836E+00, 2.8712754889E+00, 9.1359236232E-01],
	[2.6225000000E+04, 2.3474418754E+01, 5.5859041043E+00, 7.9011143432E+00, 2.8720278477E+00, 9.1363970687E-01],
	[2.6230000000E+04, 2.3481679099E+01, 5.5858780603E+00, 7.9060384308E+00, 2.8727800181E+00, 9.1368702478E-01],
	[2.6235000000E+04, 2.3488940304E+01, 5.5858520213E+00, 7.9109646470E+00, 2.8735320001E+00, 9.1373431605E-01],
	[2.6240000000E+04, 2.3496202371E+01, 5.5858259875E+00, 7.9158929924E+00, 2.8742837936E+00, 9.1378158070E-01],
	[2.6245000000E+04, 2.3503465298E+01, 5.5857999587E+00, 7.9208234673E+00, 2.8750353987E+00, 9.1382881874E-01],
	[2.6250000000E+04, 2.3510729086E+01, 5.5857739350E+00, 7.9257560724E+00, 2.8757868152E+00, 9.1387603019E-01],
	[2.6255000000E+04, 2.3517993735E+01, 5.5857479164E+00, 7.9306908081E+00, 2.8765380431E+00, 9.1392321506E-01],
	[2.6260000000E+04, 2.3525259245E+01, 5.5857219029E+00, 7.9356276750E+00, 2.8772890825E+00, 9.1397037336E-01],
	[2.6265000000E+04, 2.3532525615E+01, 5.5856958944E+00, 7.9405666736E+00, 2.8780399331E+00, 9.1401750511E-01],
	[2.6270000000E+04, 2.3539792846E+01, 5.5856698910E+00, 7.9455078043E+00, 2.8787905952E+00, 9.1406461033E-01],
	[2.6275000000E+04, 2.3547060938E+01, 5.5856438927E+00, 7.9504510678E+00, 2.8795410685E+00, 9.1411168901E-01],
	[2.6280000000E+04, 2.3554329890E+01, 5.5856178994E+00, 7.9553964644E+00, 2.8802913530E+00, 9.1415874118E-01],
	[2.6285000000E+04, 2.3561599702E+01, 5.5855919113E+00, 7.9603439948E+00, 2.8810414488E+00, 9.1420576686E-01],
	[2.6290000000E+04, 2.3568870375E+01, 5.5855659281E+00, 7.9652936595E+00, 2.8817913557E+00, 9.1425276604E-01],
	[2.6295000000E+04, 2.3576141908E+01, 5.5855399501E+00, 7.9702454589E+00, 2.8825410738E+00, 9.1429973876E-01],
	[2.6300000000E+04, 2.3583414302E+01, 5.5855139771E+00, 7.9751993935E+00, 2.8832906030E+00, 9.1434668502E-01],
	[2.6305000000E+04, 2.3590687555E+01, 5.5854880091E+00, 7.9801554640E+00, 2.8840399433E+00, 9.1439360483E-01],
	[2.6310000000E+04, 2.3597961669E+01, 5.5854620462E+00, 7.9851136707E+00, 2.8847890946E+00, 9.1444049822E-01],
	[2.6315000000E+04, 2.3605236643E+01, 5.5854360884E+00, 7.9900740143E+00, 2.8855380570E+00, 9.1448736518E-01],
	[2.6320000000E+04, 2.3612512476E+01, 5.5854101356E+00, 7.9950364952E+00, 2.8862868303E+00, 9.1453420574E-01],
	[2.6325000000E+04, 2.3619814704E+01, 5.5853874851E+00, 8.0000011139E+00, 2.8870366769E+00, 9.1458101992E-01],
	[2.6330000000E+04, 2.3627121405E+01, 5.5853653042E+00, 8.0049678710E+00, 2.8877865135E+00, 9.1462780771E-01],
	[2.6335000000E+04, 2.3634428978E+01, 5.5853431275E+00, 8.0099367670E+00, 2.8885361619E+00, 9.1467456914E-01],
	[2.6340000000E+04, 2.3641737424E+01, 5.5853209551E+00, 8.0149078023E+00, 2.8892856220E+00, 9.1472130423E-01],
	[2.6345000000E+04, 2.3649046741E+01, 5.5852987870E+00, 8.0198809776E+00, 2.8900348940E+00, 9.1476801297E-01],
	[2.6350000000E+04, 2.3656356931E+01, 5.5852766233E+00, 8.0248562932E+00, 2.8907839776E+00, 9.1481469540E-01],
	[2.6355000000E+04, 2.3663667993E+01, 5.5852544638E+00, 8.0298337498E+00, 2.8915328730E+00, 9.1486135151E-01],
	[2.6360000000E+04, 2.3670979926E+01, 5.5852323086E+00, 8.0348133478E+00, 2.8922815800E+00, 9.1490798133E-01],
	[2.6365000000E+04, 2.3678292732E+01, 5.5852101577E+00, 8.0397950878E+00, 2.8930300986E+00, 9.1495458487E-01],
	[2.6370000000E+04, 2.3685606410E+01, 5.5851880110E+00, 8.0447789703E+00, 2.8937784288E+00, 9.1500116214E-01],
	[2.6375000000E+04, 2.3692920959E+01, 5.5851658687E+00, 8.0497649957E+00, 2.8945265706E+00, 9.1504771316E-01],
	[2.6380000000E+04, 2.3700236380E+01, 5.5851437307E+00, 8.0547531646E+00, 2.8952745239E+00, 9.1509423793E-01],
	[2.6385000000E+04, 2.3707552672E+01, 5.5851215969E+00, 8.0597434776E+00, 2.8960222887E+00, 9.1514073648E-01],
	[2.6390000000E+04, 2.3714869837E+01, 5.5850994674E+00, 8.0647359350E+00, 2.8967698649E+00, 9.1518720882E-01],
	[2.6395000000E+04, 2.3722187872E+01, 5.5850773422E+00, 8.0697305376E+00, 2.8975172525E+00, 9.1523365495E-01],
	[2.6400000000E+04, 2.3729506779E+01, 5.5850552213E+00, 8.0747272856E+00, 2.8982644516E+00, 9.1528007490E-01],
	[2.6405000000E+04, 2.3736826558E+01, 5.5850331046E+00, 8.0797261798E+00, 2.8990114620E+00, 9.1532646868E-01],
	[2.6410000000E+04, 2.3744147208E+01, 5.5850109923E+00, 8.0847272205E+00, 2.8997582837E+00, 9.1537283629E-01],
	[2.6415000000E+04, 2.3751468729E+01, 5.5849888842E+00, 8.0897304084E+00, 2.9005049167E+00, 9.1541917776E-01],
	[2.6420000000E+04, 2.3758791122E+01, 5.5849667803E+00, 8.0947357438E+00, 2.9012513609E+00, 9.1546549310E-01],
	[2.6425000000E+04, 2.3766114385E+01, 5.5849446808E+00, 8.0997432274E+00, 2.9019976164E+00, 9.1551178232E-01],
	[2.6430000000E+04, 2.3773438520E+01, 5.5849225855E+00, 8.1047528596E+00, 2.9027436830E+00, 9.1555804544E-01],
	[2.6435000000E+04, 2.3780763526E+01, 5.5849004945E+00, 8.1097646410E+00, 2.9034895608E+00, 9.1560428247E-01],
	[2.6440000000E+04, 2.3788089402E+01, 5.5848784077E+00, 8.1147785721E+00, 2.9042352498E+00, 9.1565049341E-01],
	[2.6445000000E+04, 2.3795416150E+01, 5.5848563252E+00, 8.1197946533E+00, 2.9049807498E+00, 9.1569667830E-01],
	[2.6450000000E+04, 2.3802743768E+01, 5.5848342470E+00, 8.1248128853E+00, 2.9057260609E+00, 9.1574283713E-01],
	[2.6455000000E+04, 2.3810072258E+01, 5.5848121730E+00, 8.1298332685E+00, 2.9064711830E+00, 9.1578896993E-01],
	[2.6460000000E+04, 2.3817401618E+01, 5.5847901033E+00, 8.1348558034E+00, 2.9072161161E+00, 9.1583507670E-01],
	[2.6465000000E+04, 2.3824731848E+01, 5.5847680378E+00, 8.1398804905E+00, 2.9079608601E+00, 9.1588115747E-01],
	[2.6470000000E+04, 2.3832062949E+01, 5.5847459766E+00, 8.1449073305E+00, 2.9087054151E+00, 9.1592721224E-01],
	[2.6475000000E+04, 2.3839394921E+01, 5.5847239197E+00, 8.1499363237E+00, 2.9094497810E+00, 9.1597324103E-01],
	[2.6480000000E+04, 2.3846727764E+01, 5.5847018670E+00, 8.1549674707E+00, 2.9101939578E+00, 9.1601924385E-01],
	[2.6485000000E+04, 2.3854061476E+01, 5.5846798186E+00, 8.1600007720E+00, 2.9109379454E+00, 9.1606522071E-01],
	[2.6490000000E+04, 2.3861396059E+01, 5.5846577744E+00, 8.1650362281E+00, 2.9116817438E+00, 9.1611117164E-01],
	[2.6495000000E+04, 2.3868731513E+01, 5.5846357344E+00, 8.1700738395E+00, 2.9124253530E+00, 9.1615709663E-01],
	[2.6500000000E+04, 2.3876067836E+01, 5.5846136987E+00, 8.1751136069E+00, 2.9131687729E+00, 9.1620299572E-01],
	[2.6505000000E+04, 2.3883405030E+01, 5.5845916673E+00, 8.1801555306E+00, 2.9139120035E+00, 9.1624886890E-01],
	[2.6510000000E+04, 2.3890743094E+01, 5.5845696401E+00, 8.1851996111E+00, 2.9146550448E+00, 9.1629471619E-01],
	[2.6515000000E+04, 2.3898082028E+01, 5.5845476171E+00, 8.1902458491E+00, 2.9153978968E+00, 9.1634053762E-01],
	[2.6520000000E+04, 2.3905421832E+01, 5.5845255983E+00, 8.1952942450E+00, 2.9161405594E+00, 9.1638633318E-01],
	[2.6525000000E+04, 2.3912762506E+01, 5.5845035839E+00, 8.2003447993E+00, 2.9168830326E+00, 9.1643210290E-01],
	[2.6530000000E+04, 2.3920104050E+01, 5.5844815736E+00, 8.2053975126E+00, 2.9176253163E+00, 9.1647784679E-01],
	[2.6535000000E+04, 2.3927446464E+01, 5.5844595676E+00, 8.2104523853E+00, 2.9183674105E+00, 9.1652356486E-01],
	[2.6540000000E+04, 2.3934789747E+01, 5.5844375658E+00, 8.2155094180E+00, 2.9191093153E+00, 9.1656925712E-01],
	[2.6545000000E+04, 2.3942133900E+01, 5.5844155682E+00, 8.2205686112E+00, 2.9198510305E+00, 9.1661492359E-01],
	[2.6550000000E+04, 2.3949478923E+01, 5.5843935749E+00, 8.2256299654E+00, 2.9205925562E+00, 9.1666056429E-01],
	[2.6555000000E+04, 2.3956824815E+01, 5.5843715858E+00, 8.2306934811E+00, 2.9213338923E+00, 9.1670617922E-01],
	[2.6560000000E+04, 2.3964171577E+01, 5.5843496009E+00, 8.2357591588E+00, 2.9220750387E+00, 9.1675176840E-01],
	[2.6565000000E+04, 2.3971519208E+01, 5.5843276203E+00, 8.2408269991E+00, 2.9228159955E+00, 9.1679733185E-01],
	[2.6570000000E+04, 2.3978867709E+01, 5.5843056438E+00, 8.2458970025E+00, 2.9235567626E+00, 9.1684286957E-01],
	[2.6575000000E+04, 2.3986217079E+01, 5.5842836716E+00, 8.2509691694E+00, 2.9242973400E+00, 9.1688838159E-01],
	[2.6580000000E+04, 2.3993567318E+01, 5.5842617036E+00, 8.2560435005E+00, 2.9250377277E+00, 9.1693386791E-01],
	[2.6585000000E+04, 2.4000918427E+01, 5.5842397399E+00, 8.2611199961E+00, 2.9257779256E+00, 9.1697932855E-01],
	[2.6590000000E+04, 2.4008270404E+01, 5.5842177803E+00, 8.2661986569E+00, 2.9265179337E+00, 9.1702476352E-01],
	[2.6595000000E+04, 2.4015623251E+01, 5.5841958250E+00, 8.2712794834E+00, 2.9272577520E+00, 9.1707017283E-01],
	[2.6600000000E+04, 2.4022976967E+01, 5.5841738739E+00, 8.2763624760E+00, 2.9279973804E+00, 9.1711555651E-01],
	[2.6605000000E+04, 2.4030331551E+01, 5.5841519270E+00, 8.2814476353E+00, 2.9287368189E+00, 9.1716091456E-01],
	[2.6610000000E+04, 2.4037687005E+01, 5.5841299843E+00, 8.2865349617E+00, 2.9294760676E+00, 9.1720624699E-01],
	[2.6615000000E+04, 2.4045043327E+01, 5.5841080458E+00, 8.2916244559E+00, 2.9302151262E+00, 9.1725155383E-01],
	[2.6620000000E+04, 2.4052400519E+01, 5.5840861115E+00, 8.2967161183E+00, 2.9309539950E+00, 9.1729683508E-01],
	[2.6625000000E+04, 2.4059758578E+01, 5.5840641814E+00, 8.3018099494E+00, 2.9316926737E+00, 9.1734209076E-01],
	[2.6630000000E+04, 2.4067117507E+01, 5.5840422555E+00, 8.3069059498E+00, 2.9324311624E+00, 9.1738732088E-01],
	[2.6635000000E+04, 2.4074477304E+01, 5.5840203339E+00, 8.3120041200E+00, 2.9331694610E+00, 9.1743252545E-01],
	[2.6640000000E+04, 2.4081837970E+01, 5.5839984164E+00, 8.3171044604E+00, 2.9339075696E+00, 9.1747770449E-01],
	[2.6645000000E+04, 2.4089199504E+01, 5.5839765031E+00, 8.3222069717E+00, 2.9346454880E+00, 9.1752285802E-01],
	[2.6650000000E+04, 2.4096561907E+01, 5.5839545940E+00, 8.3273116542E+00, 2.9353832163E+00, 9.1756798604E-01],
	[2.6655000000E+04, 2.4103925178E+01, 5.5839326892E+00, 8.3324185086E+00, 2.9361207544E+00, 9.1761308857E-01],
	[2.6660000000E+04, 2.4111289317E+01, 5.5839107885E+00, 8.3375275354E+00, 2.9368581024E+00, 9.1765816563E-01],
	[2.6665000000E+04, 2.4118654325E+01, 5.5838888920E+00, 8.3426387350E+00, 2.9375952601E+00, 9.1770321722E-01],
	[2.6670000000E+04, 2.4126020201E+01, 5.5838669997E+00, 8.3477521080E+00, 2.9383322276E+00, 9.1774824336E-01],
	[2.6675000000E+04, 2.4133386944E+01, 5.5838451116E+00, 8.3528676549E+00, 2.9390690048E+00, 9.1779324407E-01],
	[2.6680000000E+04, 2.4140754556E+01, 5.5838232277E+00, 8.3579853762E+00, 2.9398055917E+00, 9.1783821936E-01],
	[2.6685000000E+04, 2.4148123036E+01, 5.5838013479E+00, 8.3631052724E+00, 2.9405419883E+00, 9.1788316924E-01],
	[2.6690000000E+04, 2.4155492384E+01, 5.5837794724E+00, 8.3682273441E+00, 2.9412781945E+00, 9.1792809372E-01],
	[2.6695000000E+04, 2.4162862600E+01, 5.5837576010E+00, 8.3733515917E+00, 2.9420142103E+00, 9.1797299282E-01],
	[2.6700000000E+04, 2.4170233683E+01, 5.5837357338E+00, 8.3784780158E+00, 2.9427500357E+00, 9.1801786656E-01],
	[2.6705000000E+04, 2.4177605635E+01, 5.5837138708E+00, 8.3836066170E+00, 2.9434856707E+00, 9.1806271494E-01],
	[2.6710000000E+04, 2.4184978454E+01, 5.5836920120E+00, 8.3887373956E+00, 2.9442211153E+00, 9.1810753799E-01],
	[2.6715000000E+04, 2.4192352140E+01, 5.5836701573E+00, 8.3938703522E+00, 2.9449563693E+00, 9.1815233571E-01],
	[2.6720000000E+04, 2.4199726694E+01, 5.5836483069E+00, 8.3990054874E+00, 2.9456914328E+00, 9.1819710811E-01],
	[2.6725000000E+04, 2.4207102116E+01, 5.5836264606E+00, 8.4041428017E+00, 2.9464263058E+00, 9.1824185522E-01],
	[2.6730000000E+04, 2.4214478405E+01, 5.5836046184E+00, 8.4092822955E+00, 2.9471609882E+00, 9.1828657704E-01],
	[2.6735000000E+04, 2.4221855562E+01, 5.5835827805E+00, 8.4144239694E+00, 2.9478954800E+00, 9.1833127359E-01],
	[2.6740000000E+04, 2.4229233586E+01, 5.5835609467E+00, 8.4195678239E+00, 2.9486297812E+00, 9.1837594489E-01],
	[2.6745000000E+04, 2.4236616261E+01, 5.5835396008E+00, 8.4247138595E+00, 2.9493640828E+00, 9.1842059093E-01],
	[2.6750000000E+04, 2.4244024887E+01, 5.5835214635E+00, 8.4298620768E+00, 2.9500994598E+00, 9.1846521175E-01],
	[2.6755000000E+04, 2.4251434391E+01, 5.5835033296E+00, 8.4350124763E+00, 2.9508346470E+00, 9.1850980736E-01],
	[2.6760000000E+04, 2.4258844775E+01, 5.5834851992E+00, 8.4401650584E+00, 2.9515696444E+00, 9.1855437776E-01],
	[2.6765000000E+04, 2.4266256039E+01, 5.5834670722E+00, 8.4453198237E+00, 2.9523044520E+00, 9.1859892297E-01],
	[2.6770000000E+04, 2.4273668181E+01, 5.5834489487E+00, 8.4504767727E+00, 2.9530390697E+00, 9.1864344301E-01],
	[2.6775000000E+04, 2.4281081202E+01, 5.5834308286E+00, 8.4556359059E+00, 2.9537734975E+00, 9.1868793788E-01],
	[2.6780000000E+04, 2.4288495103E+01, 5.5834127120E+00, 8.4607972239E+00, 2.9545077355E+00, 9.1873240761E-01],
	[2.6785000000E+04, 2.4295909883E+01, 5.5833945988E+00, 8.4659607271E+00, 2.9552417835E+00, 9.1877685220E-01],
	[2.6790000000E+04, 2.4303325541E+01, 5.5833764890E+00, 8.4711264161E+00, 2.9559756416E+00, 9.1882127167E-01],
	[2.6795000000E+04, 2.4310742079E+01, 5.5833583827E+00, 8.4762942913E+00, 2.9567093098E+00, 9.1886566604E-01],
	[2.6800000000E+04, 2.4318159495E+01, 5.5833402798E+00, 8.4814643534E+00, 2.9574427879E+00, 9.1891003531E-01],
	[2.6805000000E+04, 2.4325577790E+01, 5.5833221804E+00, 8.4866366028E+00, 2.9581760760E+00, 9.1895437950E-01],
	[2.6810000000E+04, 2.4332996964E+01, 5.5833040844E+00, 8.4918110401E+00, 2.9589091740E+00, 9.1899869863E-01],
	[2.6815000000E+04, 2.4340417016E+01, 5.5832859918E+00, 8.4969876657E+00, 2.9596420820E+00, 9.1904299270E-01],
	[2.6820000000E+04, 2.4347837947E+01, 5.5832679026E+00, 8.5021664801E+00, 2.9603747999E+00, 9.1908726174E-01],
	[2.6825000000E+04, 2.4355259756E+01, 5.5832498169E+00, 8.5073474840E+00, 2.9611073276E+00, 9.1913150575E-01],
	[2.6830000000E+04, 2.4362682444E+01, 5.5832317346E+00, 8.5125306777E+00, 2.9618396652E+00, 9.1917572475E-01],
	[2.6835000000E+04, 2.4370106011E+01, 5.5832136558E+00, 8.5177160619E+00, 2.9625718127E+00, 9.1921991875E-01],
	[2.6840000000E+04, 2.4377530455E+01, 5.5831955804E+00, 8.5229036370E+00, 2.9633037699E+00, 9.1926408777E-01],
	[2.6845000000E+04, 2.4384955778E+01, 5.5831775083E+00, 8.5280934036E+00, 2.9640355369E+00, 9.1930823182E-01],
	[2.6850000000E+04, 2.4392381980E+01, 5.5831594398E+00, 8.5332853622E+00, 2.9647671137E+00, 9.1935235091E-01],
	[2.6855000000E+04, 2.4399809059E+01, 5.5831413746E+00, 8.5384795132E+00, 2.9654985002E+00, 9.1939644506E-01],
	[2.6860000000E+04, 2.4407237016E+01, 5.5831233129E+00, 8.5436758572E+00, 2.9662296964E+00, 9.1944051428E-01],
	[2.6865000000E+04, 2.4414665852E+01, 5.5831052545E+00, 8.5488743948E+00, 2.9669607023E+00, 9.1948455859E-01],
	[2.6870000000E+04, 2.4422095566E+01, 5.5830871996E+00, 8.5540751264E+00, 2.9676915179E+00, 9.1952857800E-01],
	[2.6875000000E+04, 2.4429526157E+01, 5.5830691482E+00, 8.5592780525E+00, 2.9684221431E+00, 9.1957257251E-01],
	[2.6880000000E+04, 2.4436957626E+01, 5.5830511001E+00, 8.5644831738E+00, 2.9691525780E+00, 9.1961654215E-01],
	[2.6885000000E+04, 2.4444389974E+01, 5.5830330554E+00, 8.5696904906E+00, 2.9698828224E+00, 9.1966048694E-01],
	[2.6890000000E+04, 2.4451823198E+01, 5.5830150142E+00, 8.5749000035E+00, 2.9706128764E+00, 9.1970440687E-01],
	[2.6895000000E+04, 2.4459257301E+01, 5.5829969764E+00, 8.5801117131E+00, 2.9713427399E+00, 9.1974830197E-01],
	[2.6900000000E+04, 2.4466692281E+01, 5.5829789420E+00, 8.5853256198E+00, 2.9720724130E+00, 9.1979217226E-01],
	[2.6905000000E+04, 2.4474128139E+01, 5.5829609110E+00, 8.5905417241E+00, 2.9728018955E+00, 9.1983601773E-01],
	[2.6910000000E+04, 2.4481564874E+01, 5.5829428834E+00, 8.5957600267E+00, 2.9735311876E+00, 9.1987983842E-01],
	[2.6915000000E+04, 2.4489002487E+01, 5.5829248592E+00, 8.6009805279E+00, 2.9742602891E+00, 9.1992363433E-01],
	[2.6920000000E+04, 2.4496440977E+01, 5.5829068384E+00, 8.6062032283E+00, 2.9749892000E+00, 9.1996740547E-01],
	[2.6925000000E+04, 2.4503880345E+01, 5.5828888210E+00, 8.6114281285E+00, 2.9757179203E+00, 9.2001115186E-01],
	[2.6930000000E+04, 2.4511320590E+01, 5.5828708071E+00, 8.6166552289E+00, 2.9764464501E+00, 9.2005487351E-01],
	[2.6935000000E+04, 2.4518761712E+01, 5.5828527965E+00, 8.6218845300E+00, 2.9771747892E+00, 9.2009857044E-01],
	[2.6940000000E+04, 2.4526203711E+01, 5.5828347893E+00, 8.6271160325E+00, 2.9779029376E+00, 9.2014224269E-01],
	[2.6945000000E+04, 2.4533646587E+01, 5.5828167856E+00, 8.6323497367E+00, 2.9786308954E+00, 9.2018589027E-01],
	[2.6950000000E+04, 2.4541090340E+01, 5.5827987852E+00, 8.6375856433E+00, 2.9793586624E+00, 9.2022951322E-01],
	[2.6955000000E+04, 2.4548534970E+01, 5.5827807882E+00, 8.6428237527E+00, 2.9800862388E+00, 9.2027311153E-01],
	[2.6960000000E+04, 2.4555980478E+01, 5.5827627947E+00, 8.6480640654E+00, 2.9808136244E+00, 9.2031668522E-01],
	[2.6965000000E+04, 2.4563426862E+01, 5.5827448045E+00, 8.6533065820E+00, 2.9815408192E+00, 9.2036023430E-01],
	[2.6970000000E+04, 2.4570874123E+01, 5.5827268177E+00, 8.6585513030E+00, 2.9822678233E+00, 9.2040375879E-01],
	[2.6975000000E+04, 2.4578322260E+01, 5.5827088343E+00, 8.6637982289E+00, 2.9829946365E+00, 9.2044725869E-01],
	[2.6980000000E+04, 2.4585771274E+01, 5.5826908543E+00, 8.6690473602E+00, 2.9837212589E+00, 9.2049073402E-01],
	[2.6985000000E+04, 2.4593221165E+01, 5.5826728777E+00, 8.6742986975E+00, 2.9844476905E+00, 9.2053418479E-01],
	[2.6990000000E+04, 2.4600671933E+01, 5.5826549044E+00, 8.6795522411E+00, 2.9851739312E+00, 9.2057761102E-01],
	[2.6995000000E+04, 2.4608123577E+01, 5.5826369346E+00, 8.6848079918E+00, 2.9858999810E+00, 9.2062101270E-01],
	[2.7000000000E+04, 2.4615576097E+01, 5.5826189681E+00, 8.6900659500E+00, 2.9866258399E+00, 9.2066438987E-01],
	[2.7005000000E+04, 2.4623029494E+01, 5.5826010051E+00, 8.6953261161E+00, 2.9873515079E+00, 9.2070774252E-01],
	[2.7010000000E+04, 2.4630483767E+01, 5.5825830454E+00, 8.7005884908E+00, 2.9880769849E+00, 9.2075107067E-01],
	[2.7015000000E+04, 2.4637938916E+01, 5.5825650891E+00, 8.7058530746E+00, 2.9888022709E+00, 9.2079437434E-01],
	[2.7020000000E+04, 2.4645394942E+01, 5.5825471362E+00, 8.7111198679E+00, 2.9895273660E+00, 9.2083765353E-01],
	[2.7025000000E+04, 2.4652851844E+01, 5.5825291866E+00, 8.7163888712E+00, 2.9902522700E+00, 9.2088090826E-01],
	[2.7030000000E+04, 2.4660309621E+01, 5.5825112405E+00, 8.7216600852E+00, 2.9909769830E+00, 9.2092413854E-01],
	[2.7035000000E+04, 2.4667768275E+01, 5.5824932977E+00, 8.7269335103E+00, 2.9917015050E+00, 9.2096734437E-01],
	[2.7040000000E+04, 2.4675227805E+01, 5.5824753583E+00, 8.7322091470E+00, 2.9924258358E+00, 9.2101052578E-01],
	[2.7045000000E+04, 2.4682688211E+01, 5.5824574222E+00, 8.7374869958E+00, 2.9931499756E+00, 9.2105368278E-01],
	[2.7050000000E+04, 2.4690149492E+01, 5.5824394896E+00, 8.7427670574E+00, 2.9938739243E+00, 9.2109681537E-01],
	[2.7055000000E+04, 2.4697611650E+01, 5.5824215603E+00, 8.7480493321E+00, 2.9945976818E+00, 9.2113992358E-01],
	[2.7060000000E+04, 2.4705074683E+01, 5.5824036344E+00, 8.7533338205E+00, 2.9953212482E+00, 9.2118300740E-01],
	[2.7065000000E+04, 2.4712538592E+01, 5.5823857118E+00, 8.7586205231E+00, 2.9960446234E+00, 9.2122606686E-01],
	[2.7070000000E+04, 2.4720003376E+01, 5.5823677926E+00, 8.7639094405E+00, 2.9967678074E+00, 9.2126910197E-01],
	[2.7075000000E+04, 2.4727469036E+01, 5.5823498768E+00, 8.7692005731E+00, 2.9974908002E+00, 9.2131211273E-01],
	[2.7080000000E+04, 2.4734935572E+01, 5.5823319643E+00, 8.7744939215E+00, 2.9982136017E+00, 9.2135509916E-01],
	[2.7085000000E+04, 2.4742402982E+01, 5.5823140553E+00, 8.7797894862E+00, 2.9989362120E+00, 9.2139806128E-01],
	[2.7090000000E+04, 2.4749871269E+01, 5.5822961495E+00, 8.7850872677E+00, 2.9996586311E+00, 9.2144099909E-01],
	[2.7095000000E+04, 2.4757340430E+01, 5.5822782472E+00, 8.7903872665E+00, 3.0003808588E+00, 9.2148391260E-01],
	[2.7100000000E+04, 2.4764810467E+01, 5.5822603482E+00, 8.7956894832E+00, 3.0011028953E+00, 9.2152680184E-01],
	[2.7105000000E+04, 2.4772281379E+01, 5.5822424525E+00, 8.8009939183E+00, 3.0018247404E+00, 9.2156966681E-01],
	[2.7110000000E+04, 2.4779753167E+01, 5.5822245603E+00, 8.8063005722E+00, 3.0025463942E+00, 9.2161250752E-01],
	[2.7115000000E+04, 2.4787225829E+01, 5.5822066713E+00, 8.8116094455E+00, 3.0032678566E+00, 9.2165532398E-01],
	[2.7120000000E+04, 2.4794699366E+01, 5.5821887858E+00, 8.8169205388E+00, 3.0039891277E+00, 9.2169811621E-01],
	[2.7125000000E+04, 2.4802173778E+01, 5.5821709035E+00, 8.8222338524E+00, 3.0047102073E+00, 9.2174088423E-01],
	[2.7130000000E+04, 2.4809649066E+01, 5.5821530247E+00, 8.8275493871E+00, 3.0054310955E+00, 9.2178362803E-01],
	[2.7135000000E+04, 2.4817125228E+01, 5.5821351492E+00, 8.8328671432E+00, 3.0061517923E+00, 9.2182634764E-01],
	[2.7140000000E+04, 2.4824602265E+01, 5.5821172770E+00, 8.8381871213E+00, 3.0068722977E+00, 9.2186904306E-01],
	[2.7145000000E+04, 2.4832080176E+01, 5.5820994082E+00, 8.8435093219E+00, 3.0075926115E+00, 9.2191171431E-01],
	[2.7150000000E+04, 2.4839558962E+01, 5.5820815427E+00, 8.8488337456E+00, 3.0083127339E+00, 9.2195436141E-01],
	[2.7155000000E+04, 2.4847038623E+01, 5.5820636806E+00, 8.8541603928E+00, 3.0090326648E+00, 9.2199698435E-01],
	[2.7160000000E+04, 2.4854519159E+01, 5.5820458219E+00, 8.8594892640E+00, 3.0097524041E+00, 9.2203958316E-01],
	[2.7165000000E+04, 2.4862000569E+01, 5.5820279664E+00, 8.8648203599E+00, 3.0104719519E+00, 9.2208215785E-01],
	[2.7170000000E+04, 2.4869482853E+01, 5.5820101144E+00, 8.8701536808E+00, 3.0111913082E+00, 9.2212470843E-01],
	[2.7175000000E+04, 2.4876966630E+01, 5.5819923438E+00, 8.8754892274E+00, 3.0119105047E+00, 9.2216723491E-01],
	[2.7180000000E+04, 2.4884479252E+01, 5.5819781141E+00, 8.8808270001E+00, 3.0126309499E+00, 9.2220973730E-01],
	[2.7185000000E+04, 2.4891992760E+01, 5.5819638871E+00, 8.8861669995E+00, 3.0133512045E+00, 9.2225221562E-01],
	[2.7190000000E+04, 2.4899507154E+01, 5.5819496627E+00, 8.8915092260E+00, 3.0140712684E+00, 9.2229466988E-01],
	[2.7195000000E+04, 2.4907022434E+01, 5.5819354410E+00, 8.8968536803E+00, 3.0147911414E+00, 9.2233710008E-01],
	[2.7200000000E+04, 2.4914538601E+01, 5.5819212219E+00, 8.9022003627E+00, 3.0155108237E+00, 9.2237950625E-01],
	[2.7205000000E+04, 2.4922055653E+01, 5.5819070055E+00, 8.9075492739E+00, 3.0162303153E+00, 9.2242188840E-01],
	[2.7210000000E+04, 2.4929573591E+01, 5.5818927917E+00, 8.9129004143E+00, 3.0169496160E+00, 9.2246424653E-01],
	[2.7215000000E+04, 2.4937092415E+01, 5.5818785806E+00, 8.9182537845E+00, 3.0176687258E+00, 9.2250658066E-01],
	[2.7220000000E+04, 2.4944612125E+01, 5.5818643721E+00, 8.9236093850E+00, 3.0183876449E+00, 9.2254889081E-01],
	[2.7225000000E+04, 2.4952132721E+01, 5.5818501663E+00, 8.9289672163E+00, 3.0191063731E+00, 9.2259117697E-01],
	[2.7230000000E+04, 2.4959654203E+01, 5.5818359631E+00, 8.9343272790E+00, 3.0198249104E+00, 9.2263343918E-01],
	[2.7235000000E+04, 2.4967176570E+01, 5.5818217625E+00, 8.9396895735E+00, 3.0205432568E+00, 9.2267567743E-01],
	[2.7240000000E+04, 2.4974699823E+01, 5.5818075646E+00, 8.9450541003E+00, 3.0212614123E+00, 9.2271789174E-01],
	[2.7245000000E+04, 2.4982223961E+01, 5.5817933693E+00, 8.9504208600E+00, 3.0219793769E+00, 9.2276008213E-01],
	[2.7250000000E+04, 2.4989748985E+01, 5.5817791767E+00, 8.9557898531E+00, 3.0226971505E+00, 9.2280224860E-01],
	[2.7255000000E+04, 2.4997274894E+01, 5.5817649867E+00, 8.9611610802E+00, 3.0234147332E+00, 9.2284439116E-01],
	[2.7260000000E+04, 2.5004801688E+01, 5.5817507994E+00, 8.9665345417E+00, 3.0241321249E+00, 9.2288650984E-01],
	[2.7265000000E+04, 2.5012329368E+01, 5.5817366147E+00, 8.9719102381E+00, 3.0248493256E+00, 9.2292860464E-01],
	[2.7270000000E+04, 2.5019857933E+01, 5.5817224326E+00, 8.9772881700E+00, 3.0255663353E+00, 9.2297067557E-01],
	[2.7275000000E+04, 2.5027387383E+01, 5.5817082532E+00, 8.9826683380E+00, 3.0262831540E+00, 9.2301272265E-01],
	[2.7280000000E+04, 2.5034917719E+01, 5.5816940764E+00, 8.9880507424E+00, 3.0269997817E+00, 9.2305474589E-01],
	[2.7285000000E+04, 2.5042448939E+01, 5.5816799022E+00, 8.9934353839E+00, 3.0277162183E+00, 9.2309674530E-01],
	[2.7290000000E+04, 2.5049981044E+01, 5.5816657307E+00, 8.9988222629E+00, 3.0284324638E+00, 9.2313872089E-01],
	[2.7295000000E+04, 2.5057514035E+01, 5.5816515618E+00, 9.0042113800E+00, 3.0291485183E+00, 9.2318067268E-01],
	[2.7300000000E+04, 2.5065047910E+01, 5.5816373955E+00, 9.0096027357E+00, 3.0298643817E+00, 9.2322260068E-01],
	[2.7305000000E+04, 2.5072582670E+01, 5.5816232319E+00, 9.0149963305E+00, 3.0305800539E+00, 9.2326450489E-01],
	[2.7310000000E+04, 2.5080118315E+01, 5.5816090708E+00, 9.0203921649E+00, 3.0312955350E+00, 9.2330638534E-01],
	[2.7315000000E+04, 2.5087654845E+01, 5.5815949125E+00, 9.0257902395E+00, 3.0320108250E+00, 9.2334824204E-01],
	[2.7320000000E+04, 2.5095192259E+01, 5.5815807567E+00, 9.0311905547E+00, 3.0327259238E+00, 9.2339007499E-01],
	[2.7325000000E+04, 2.5102730558E+01, 5.5815666036E+00, 9.0365931112E+00, 3.0334408314E+00, 9.2343188421E-01],
	[2.7330000000E+04, 2.5110269741E+01, 5.5815524531E+00, 9.0419979093E+00, 3.0341555479E+00, 9.2347366971E-01],
	[2.7335000000E+04, 2.5117809809E+01, 5.5815383052E+00, 9.0474049497E+00, 3.0348700731E+00, 9.2351543150E-01],
	[2.7340000000E+04, 2.5125350761E+01, 5.5815241600E+00, 9.0528142328E+00, 3.0355844072E+00, 9.2355716960E-01],
	[2.7345000000E+04, 2.5132892598E+01, 5.5815100173E+00, 9.0582257592E+00, 3.0362985500E+00, 9.2359888402E-01],
	[2.7350000000E+04, 2.5140435319E+01, 5.5814958773E+00, 9.0636395293E+00, 3.0370125015E+00, 9.2364057477E-01],
	[2.7355000000E+04, 2.5147978924E+01, 5.5814817399E+00, 9.0690555438E+00, 3.0377262618E+00, 9.2368224187E-01],
	[2.7360000000E+04, 2.5155523414E+01, 5.5814676052E+00, 9.0744738031E+00, 3.0384398308E+00, 9.2372388531E-01],
	[2.7365000000E+04, 2.5163068787E+01, 5.5814534730E+00, 9.0798943077E+00, 3.0391532086E+00, 9.2376550513E-01],
	[2.7370000000E+04, 2.5170615045E+01, 5.5814393435E+00, 9.0853170582E+00, 3.0398663950E+00, 9.2380710133E-01],
	[2.7375000000E+04, 2.5178162186E+01, 5.5814252165E+00, 9.0907420551E+00, 3.0405793901E+00, 9.2384867392E-01],
	[2.7380000000E+04, 2.5185710212E+01, 5.5814110922E+00, 9.0961692989E+00, 3.0412921939E+00, 9.2389022291E-01],
	[2.7385000000E+04, 2.5193259122E+01, 5.5813969706E+00, 9.1015987901E+00, 3.0420048063E+00, 9.2393174832E-01],
	[2.7390000000E+04, 2.5200808915E+01, 5.5813828515E+00, 9.1070312103E+00, 3.0427173034E+00, 9.2397325016E-01],
	[2.7395000000E+04, 2.5208359592E+01, 5.5813687350E+00, 9.1124660720E+00, 3.0434296306E+00, 9.2401472844E-01],
	[2.7400000000E+04, 2.5215911153E+01, 5.5813546212E+00, 9.1179031836E+00, 3.0441417663E+00, 9.2405618318E-01],
	[2.7405000000E+04, 2.5223463598E+01, 5.5813405099E+00, 9.1233425456E+00, 3.0448537106E+00, 9.2409761438E-01],
	[2.7410000000E+04, 2.5231016926E+01, 5.5813264013E+00, 9.1287841586E+00, 3.0455654634E+00, 9.2413902206E-01],
	[2.7415000000E+04, 2.5238571138E+01, 5.5813122953E+00, 9.1342280230E+00, 3.0462770248E+00, 9.2418040623E-01],
	[2.7420000000E+04, 2.5246126233E+01, 5.5812981919E+00, 9.1396741395E+00, 3.0469883947E+00, 9.2422176690E-01],
	[2.7425000000E+04, 2.5253682212E+01, 5.5812840911E+00, 9.1451225085E+00, 3.0476995731E+00, 9.2426310409E-01],
	[2.7430000000E+04, 2.5261239074E+01, 5.5812699929E+00, 9.1505731305E+00, 3.0484105601E+00, 9.2430441781E-01],
	[2.7435000000E+04, 2.5268796819E+01, 5.5812558973E+00, 9.1560260061E+00, 3.0491213555E+00, 9.2434570807E-01],
	[2.7440000000E+04, 2.5276355448E+01, 5.5812418043E+00, 9.1614811358E+00, 3.0498319594E+00, 9.2438697488E-01],
	[2.7445000000E+04, 2.5283914960E+01, 5.5812277139E+00, 9.1669385200E+00, 3.0505423717E+00, 9.2442821826E-01],
	[2.7450000000E+04, 2.5291475355E+01, 5.5812136262E+00, 9.1723981594E+00, 3.0512525925E+00, 9.2446943821E-01],
	[2.7455000000E+04, 2.5299036633E+01, 5.5811995410E+00, 9.1778600545E+00, 3.0519626217E+00, 9.2451063475E-01],
	[2.7460000000E+04, 2.5306598794E+01, 5.5811854584E+00, 9.1833242057E+00, 3.0526724594E+00, 9.2455180790E-01],
	[2.7465000000E+04, 2.5314161838E+01, 5.5811713784E+00, 9.1887906136E+00, 3.0533821055E+00, 9.2459295766E-01],
	[2.7470000000E+04, 2.5321725765E+01, 5.5811573010E+00, 9.1942592787E+00, 3.0540915599E+00, 9.2463408404E-01],
	[2.7475000000E+04, 2.5329290575E+01, 5.5811432262E+00, 9.1997302015E+00, 3.0548008228E+00, 9.2467518707E-01],
	[2.7480000000E+04, 2.5336856268E+01, 5.5811291541E+00, 9.2052033826E+00, 3.0555098940E+00, 9.2471626675E-01],
	[2.7485000000E+04, 2.5344422843E+01, 5.5811150845E+00, 9.2106788224E+00, 3.0562187736E+00, 9.2475732309E-01],
	[2.7490000000E+04, 2.5351990301E+01, 5.5811010175E+00, 9.2161565216E+00, 3.0569274616E+00, 9.2479835610E-01],
	[2.7495000000E+04, 2.5359558642E+01, 5.5810869531E+00, 9.2216364805E+00, 3.0576359579E+00, 9.2483936581E-01],
	[2.7500000000E+04, 2.5367127866E+01, 5.5810728913E+00, 9.2271186998E+00, 3.0583442625E+00, 9.2488035221E-01],
	[2.7505000000E+04, 2.5374697972E+01, 5.5810588320E+00, 9.2326031799E+00, 3.0590523754E+00, 9.2492131533E-01],
	[2.7510000000E+04, 2.5382268960E+01, 5.5810447754E+00, 9.2380899214E+00, 3.0597602967E+00, 9.2496225518E-01],
	[2.7515000000E+04, 2.5389840831E+01, 5.5810307214E+00, 9.2435789248E+00, 3.0604680262E+00, 9.2500317176E-01],
	[2.7520000000E+04, 2.5397413584E+01, 5.5810166699E+00, 9.2490701905E+00, 3.0611755641E+00, 9.2504406510E-01],
	[2.7525000000E+04, 2.5404987219E+01, 5.5810026211E+00, 9.2545637193E+00, 3.0618829102E+00, 9.2508493519E-01],
	[2.7530000000E+04, 2.5412561737E+01, 5.5809885748E+00, 9.2600595114E+00, 3.0625900645E+00, 9.2512578206E-01],
	[2.7535000000E+04, 2.5420137137E+01, 5.5809745311E+00, 9.2655575676E+00, 3.0632970271E+00, 9.2516660572E-01],
	[2.7540000000E+04, 2.5427713419E+01, 5.5809604900E+00, 9.2710578882E+00, 3.0640037980E+00, 9.2520740618E-01],
	[2.7545000000E+04, 2.5435290583E+01, 5.5809464515E+00, 9.2765604739E+00, 3.0647103771E+00, 9.2524818345E-01],
	[2.7550000000E+04, 2.5442868629E+01, 5.5809324156E+00, 9.2820653251E+00, 3.0654167644E+00, 9.2528893755E-01],
	[2.7555000000E+04, 2.5450447557E+01, 5.5809183822E+00, 9.2875724423E+00, 3.0661229599E+00, 9.2532966848E-01],
	[2.7560000000E+04, 2.5458027366E+01, 5.5809043514E+00, 9.2930818262E+00, 3.0668289636E+00, 9.2537037626E-01],
	[2.7565000000E+04, 2.5465608058E+01, 5.5808903233E+00, 9.2985934771E+00, 3.0675347755E+00, 9.2541106091E-01],
	[2.7570000000E+04, 2.5473189632E+01, 5.5808762976E+00, 9.3041073956E+00, 3.0682403955E+00, 9.2545172242E-01],
	[2.7575000000E+04, 2.5480772087E+01, 5.5808622746E+00, 9.3096235823E+00, 3.0689458238E+00, 9.2549236083E-01],
	[2.7580000000E+04, 2.5488355423E+01, 5.5808482542E+00, 9.3151420377E+00, 3.0696510602E+00, 9.2553297613E-01],
	[2.7585000000E+04, 2.5495939642E+01, 5.5808342363E+00, 9.3206627622E+00, 3.0703561047E+00, 9.2557356834E-01],
	[2.7590000000E+04, 2.5503524742E+01, 5.5808202210E+00, 9.3261857565E+00, 3.0710609574E+00, 9.2561413748E-01],
	[2.7595000000E+04, 2.5511110723E+01, 5.5808062083E+00, 9.3317110209E+00, 3.0717656182E+00, 9.2565468356E-01],
	[2.7600000000E+04, 2.5518697586E+01, 5.5807921981E+00, 9.3372385561E+00, 3.0724700871E+00, 9.2569520658E-01],
	[2.7605000000E+04, 2.5526285330E+01, 5.5807781905E+00, 9.3427683626E+00, 3.0731743641E+00, 9.2573570656E-01],
	[2.7610000000E+04, 2.5533873956E+01, 5.5807641855E+00, 9.3483004409E+00, 3.0738784493E+00, 9.2577618352E-01],
	[2.7615000000E+04, 2.5541478347E+01, 5.5807520473E+00, 9.3538347915E+00, 3.0745831240E+00, 9.2581663746E-01],
	[2.7620000000E+04, 2.5549097047E+01, 5.5807415919E+00, 9.3593714149E+00, 3.0752883120E+00, 9.2585706840E-01],
	[2.7625000000E+04, 2.5556716640E+01, 5.5807311384E+00, 9.3649103116E+00, 3.0759933090E+00, 9.2589747635E-01],
	[2.7630000000E+04, 2.5564337125E+01, 5.5807206868E+00, 9.3704514823E+00, 3.0766981148E+00, 9.2593786133E-01],
	[2.7635000000E+04, 2.5571958504E+01, 5.5807102371E+00, 9.3759949273E+00, 3.0774027296E+00, 9.2597822333E-01],
	[2.7640000000E+04, 2.5579580775E+01, 5.5806997893E+00, 9.3815406472E+00, 3.0781071533E+00, 9.2601856239E-01],
	[2.7645000000E+04, 2.5587203938E+01, 5.5806893435E+00, 9.3870886426E+00, 3.0788113858E+00, 9.2605887851E-01],
	[2.7650000000E+04, 2.5594827995E+01, 5.5806788995E+00, 9.3926389140E+00, 3.0795154272E+00, 9.2609917169E-01],
	[2.7655000000E+04, 2.5602452944E+01, 5.5806684575E+00, 9.3981914618E+00, 3.0802192775E+00, 9.2613944197E-01],
	[2.7660000000E+04, 2.5610078785E+01, 5.5806580173E+00, 9.4037462866E+00, 3.0809229366E+00, 9.2617968934E-01],
	[2.7665000000E+04, 2.5617705519E+01, 5.5806475791E+00, 9.4093033890E+00, 3.0816264046E+00, 9.2621991382E-01],
	[2.7670000000E+04, 2.5625333145E+01, 5.5806371428E+00, 9.4148627694E+00, 3.0823296815E+00, 9.2626011542E-01],
	[2.7675000000E+04, 2.5632961663E+01, 5.5806267083E+00, 9.4204244283E+00, 3.0830327671E+00, 9.2630029416E-01],
	[2.7680000000E+04, 2.5640591074E+01, 5.5806162758E+00, 9.4259883664E+00, 3.0837356616E+00, 9.2634045004E-01],
	[2.7685000000E+04, 2.5648221377E+01, 5.5806058452E+00, 9.4315545840E+00, 3.0844383649E+00, 9.2638058308E-01],
	[2.7690000000E+04, 2.5655852572E+01, 5.5805954165E+00, 9.4371230818E+00, 3.0851408770E+00, 9.2642069329E-01],
	[2.7695000000E+04, 2.5663484659E+01, 5.5805849897E+00, 9.4426938603E+00, 3.0858431979E+00, 9.2646078069E-01],
	[2.7700000000E+04, 2.5671117638E+01, 5.5805745648E+00, 9.4482669199E+00, 3.0865453275E+00, 9.2650084529E-01],
	[2.7705000000E+04, 2.5678751509E+01, 5.5805641418E+00, 9.4538422612E+00, 3.0872472660E+00, 9.2654088709E-01],
	[2.7710000000E+04, 2.5686386272E+01, 5.5805537207E+00, 9.4594198847E+00, 3.0879490132E+00, 9.2658090611E-01],
	[2.7715000000E+04, 2.5694021927E+01, 5.5805433015E+00, 9.4649997910E+00, 3.0886505692E+00, 9.2662090237E-01],
	[2.7720000000E+04, 2.5701658473E+01, 5.5805328841E+00, 9.4705819805E+00, 3.0893519339E+00, 9.2666087587E-01],
	[2.7725000000E+04, 2.5709295912E+01, 5.5805224687E+00, 9.4761664538E+00, 3.0900531074E+00, 9.2670082663E-01],
	[2.7730000000E+04, 2.5716934242E+01, 5.5805120552E+00, 9.4817532115E+00, 3.0907540896E+00, 9.2674075467E-01],
	[2.7735000000E+04, 2.5724573463E+01, 5.5805016436E+00, 9.4873422539E+00, 3.0914548806E+00, 9.2678065998E-01],
	[2.7740000000E+04, 2.5732213576E+01, 5.5804912339E+00, 9.4929335817E+00, 3.0921554802E+00, 9.2682054259E-01],
	[2.7745000000E+04, 2.5739854581E+01, 5.5804808261E+00, 9.4985271954E+00, 3.0928558886E+00, 9.2686040251E-01],
	[2.7750000000E+04, 2.5747496477E+01, 5.5804704201E+00, 9.5041230954E+00, 3.0935561057E+00, 9.2690023975E-01],
	[2.7755000000E+04, 2.5755139265E+01, 5.5804600161E+00, 9.5097212824E+00, 3.0942561315E+00, 9.2694005433E-01],
	[2.7760000000E+04, 2.5762782943E+01, 5.5804496140E+00, 9.5153217568E+00, 3.0949559660E+00, 9.2697984624E-01],
	[2.7765000000E+04, 2.5770427514E+01, 5.5804392137E+00, 9.5209245191E+00, 3.0956556092E+00, 9.2701961552E-01],
	[2.7770000000E+04, 2.5778072975E+01, 5.5804288154E+00, 9.5265295700E+00, 3.0963550610E+00, 9.2705936217E-01],
	[2.7775000000E+04, 2.5785719327E+01, 5.5804184189E+00, 9.5321369098E+00, 3.0970543215E+00, 9.2709908619E-01],
	[2.7780000000E+04, 2.5793366571E+01, 5.5804080243E+00, 9.5377465392E+00, 3.0977533907E+00, 9.2713878762E-01],
	[2.7785000000E+04, 2.5801014706E+01, 5.5803976317E+00, 9.5433584586E+00, 3.0984522686E+00, 9.2717846645E-01],
	[2.7790000000E+04, 2.5808663731E+01, 5.5803872409E+00, 9.5489726686E+00, 3.0991509551E+00, 9.2721812270E-01],
	[2.7795000000E+04, 2.5816313648E+01, 5.5803768520E+00, 9.5545891696E+00, 3.0998494502E+00, 9.2725775638E-01],
	[2.7800000000E+04, 2.5823964455E+01, 5.5803664649E+00, 9.5602079623E+00, 3.1005477539E+00, 9.2729736750E-01],
	[2.7805000000E+04, 2.5831616154E+01, 5.5803560798E+00, 9.5658290471E+00, 3.1012458663E+00, 9.2733695609E-01],
	[2.7810000000E+04, 2.5839268743E+01, 5.5803456966E+00, 9.5714524246E+00, 3.1019437874E+00, 9.2737652214E-01],
	[2.7815000000E+04, 2.5846922223E+01, 5.5803353152E+00, 9.5770780952E+00, 3.1026415170E+00, 9.2741606567E-01],
	[2.7820000000E+04, 2.5854576593E+01, 5.5803249357E+00, 9.5827060596E+00, 3.1033390552E+00, 9.2745558670E-01],
	[2.7825000000E+04, 2.5862231854E+01, 5.5803145582E+00, 9.5883363181E+00, 3.1040364021E+00, 9.2749508524E-01],
	[2.7830000000E+04, 2.5869888006E+01, 5.5803041825E+00, 9.5939688715E+00, 3.1047335575E+00, 9.2753456129E-01],
	[2.7835000000E+04, 2.5877545048E+01, 5.5802938086E+00, 9.5996037200E+00, 3.1054305216E+00, 9.2757401488E-01],
	[2.7840000000E+04, 2.5885202980E+01, 5.5802834367E+00, 9.6052408644E+00, 3.1061272942E+00, 9.2761344600E-01],
	[2.7845000000E+04, 2.5892861803E+01, 5.5802730666E+00, 9.6108803051E+00, 3.1068238754E+00, 9.2765285469E-01],
	[2.7850000000E+04, 2.5900521516E+01, 5.5802626985E+00, 9.6165220426E+00, 3.1075202652E+00, 9.2769224094E-01],
	[2.7855000000E+04, 2.5908182120E+01, 5.5802523322E+00, 9.6221660775E+00, 3.1082164635E+00, 9.2773160478E-01],
	[2.7860000000E+04, 2.5915843614E+01, 5.5802419678E+00, 9.6278124102E+00, 3.1089124704E+00, 9.2777094621E-01],
	[2.7865000000E+04, 2.5923505997E+01, 5.5802316052E+00, 9.6334610414E+00, 3.1096082859E+00, 9.2781026524E-01],
	[2.7870000000E+04, 2.5931169271E+01, 5.5802212446E+00, 9.6391119715E+00, 3.1103039099E+00, 9.2784956189E-01],
	[2.7875000000E+04, 2.5938833435E+01, 5.5802108858E+00, 9.6447652010E+00, 3.1109993425E+00, 9.2788883617E-01],
	[2.7880000000E+04, 2.5946498489E+01, 5.5802005289E+00, 9.6504207305E+00, 3.1116945836E+00, 9.2792808810E-01],
	[2.7885000000E+04, 2.5954164433E+01, 5.5801901739E+00, 9.6560785605E+00, 3.1123896332E+00, 9.2796731768E-01],
	[2.7890000000E+04, 2.5961831267E+01, 5.5801798207E+00, 9.6617386915E+00, 3.1130844914E+00, 9.2800652493E-01],
	[2.7895000000E+04, 2.5969498990E+01, 5.5801694694E+00, 9.6674011240E+00, 3.1137791581E+00, 9.2804570986E-01],
	[2.7900000000E+04, 2.5977167604E+01, 5.5801591200E+00, 9.6730658586E+00, 3.1144736333E+00, 9.2808487248E-01],
	[2.7905000000E+04, 2.5984837107E+01, 5.5801487725E+00, 9.6787328958E+00, 3.1151679170E+00, 9.2812401281E-01],
	[2.7910000000E+04, 2.5992507499E+01, 5.5801384269E+00, 9.6844022361E+00, 3.1158620092E+00, 9.2816313085E-01],
	[2.7915000000E+04, 2.6000178782E+01, 5.5801280831E+00, 9.6900738800E+00, 3.1165559100E+00, 9.2820222663E-01],
	[2.7920000000E+04, 2.6007850953E+01, 5.5801177412E+00, 9.6957478280E+00, 3.1172496192E+00, 9.2824130014E-01],
	[2.7925000000E+04, 2.6015524015E+01, 5.5801074011E+00, 9.7014240808E+00, 3.1179431370E+00, 9.2828035141E-01],
	[2.7930000000E+04, 2.6023197965E+01, 5.5800970630E+00, 9.7071026387E+00, 3.1186364632E+00, 9.2831938045E-01],
	[2.7935000000E+04, 2.6030872805E+01, 5.5800867267E+00, 9.7127835024E+00, 3.1193295979E+00, 9.2835838727E-01],
	[2.7940000000E+04, 2.6038548535E+01, 5.5800763923E+00, 9.7184666722E+00, 3.1200225411E+00, 9.2839737188E-01],
	[2.7945000000E+04, 2.6046225153E+01, 5.5800660597E+00, 9.7241521489E+00, 3.1207152928E+00, 9.2843633429E-01],
	[2.7950000000E+04, 2.6053902661E+01, 5.5800557290E+00, 9.7298399328E+00, 3.1214078529E+00, 9.2847527452E-01],
	[2.7955000000E+04, 2.6061581058E+01, 5.5800454002E+00, 9.7355300246E+00, 3.1221002216E+00, 9.2851419258E-01],
	[2.7960000000E+04, 2.6069260344E+01, 5.5800350732E+00, 9.7412224247E+00, 3.1227923986E+00, 9.2855308848E-01],
	[2.7965000000E+04, 2.6076940519E+01, 5.5800247481E+00, 9.7469171336E+00, 3.1234843842E+00, 9.2859196224E-01],
	[2.7970000000E+04, 2.6084621583E+01, 5.5800144249E+00, 9.7526141519E+00, 3.1241761782E+00, 9.2863081386E-01],
	[2.7975000000E+04, 2.6092303536E+01, 5.5800041035E+00, 9.7583134801E+00, 3.1248677807E+00, 9.2866964336E-01],
	[2.7980000000E+04, 2.6099986378E+01, 5.5799937840E+00, 9.7640151188E+00, 3.1255591916E+00, 9.2870845075E-01],
	[2.7985000000E+04, 2.6107670108E+01, 5.5799834664E+00, 9.7697190683E+00, 3.1262504110E+00, 9.2874723604E-01],
	[2.7990000000E+04, 2.6115354727E+01, 5.5799731506E+00, 9.7754253294E+00, 3.1269414388E+00, 9.2878599925E-01],
	[2.7995000000E+04, 2.6123040235E+01, 5.5799628367E+00, 9.7811339025E+00, 3.1276322750E+00, 9.2882474039E-01],
	[2.8000000000E+04, 2.6130726632E+01, 5.5799525247E+00, 9.7868447880E+00, 3.1283229197E+00, 9.2886345947E-01],
	[2.8005000000E+04, 2.6138413917E+01, 5.5799422145E+00, 9.7925579866E+00, 3.1290133728E+00, 9.2890215650E-01],
	[2.8010000000E+04, 2.6146102091E+01, 5.5799319061E+00, 9.7982734988E+00, 3.1297036344E+00, 9.2894083150E-01],
	[2.8015000000E+04, 2.6153791153E+01, 5.5799215997E+00, 9.8039913251E+00, 3.1303937044E+00, 9.2897948447E-01],
	[2.8020000000E+04, 2.6161481104E+01, 5.5799112950E+00, 9.8097114659E+00, 3.1310835828E+00, 9.2901811544E-01],
	[2.8025000000E+04, 2.6169171943E+01, 5.5799009923E+00, 9.8154339219E+00, 3.1317732696E+00, 9.2905672440E-01],
	[2.8030000000E+04, 2.6176863670E+01, 5.5798906914E+00, 9.8211586936E+00, 3.1324627649E+00, 9.2909531139E-01],
	[2.8035000000E+04, 2.6184556285E+01, 5.5798803923E+00, 9.8268857814E+00, 3.1331520685E+00, 9.2913387640E-01],
	[2.8040000000E+04, 2.6192249789E+01, 5.5798700952E+00, 9.8326151860E+00, 3.1338411806E+00, 9.2917241945E-01],
	[2.8045000000E+04, 2.6199944181E+01, 5.5798597998E+00, 9.8383469077E+00, 3.1345301011E+00, 9.2921094055E-01],
	[2.8050000000E+04, 2.6207639461E+01, 5.5798495063E+00, 9.8440809472E+00, 3.1352188300E+00, 9.2924943972E-01],
	[2.8055000000E+04, 2.6215335629E+01, 5.5798392147E+00, 9.8498173050E+00, 3.1359073673E+00, 9.2928791696E-01],
	[2.8060000000E+04, 2.6223050098E+01, 5.5798310852E+00, 9.8555559816E+00, 3.1365966448E+00, 9.2932637229E-01],
	[2.8065000000E+04, 2.6230776066E+01, 5.5798242723E+00, 9.8612969775E+00, 3.1372862986E+00, 9.2936480573E-01],
	[2.8070000000E+04, 2.6238502933E+01, 5.5798174606E+00, 9.8670402932E+00, 3.1379757616E+00, 9.2940321728E-01],
	[2.8075000000E+04, 2.6246230700E+01, 5.5798106501E+00, 9.8727859294E+00, 3.1386650339E+00, 9.2944160695E-01],
	[2.8080000000E+04, 2.6253959365E+01, 5.5798038409E+00, 9.8785338864E+00, 3.1393541153E+00, 9.2947997476E-01],
	[2.8085000000E+04, 2.6261688930E+01, 5.5797970329E+00, 9.8842841648E+00, 3.1400430060E+00, 9.2951832073E-01],
	[2.8090000000E+04, 2.6269419394E+01, 5.5797902261E+00, 9.8900367651E+00, 3.1407317059E+00, 9.2955664486E-01],
	[2.8095000000E+04, 2.6277150758E+01, 5.5797834205E+00, 9.8957916879E+00, 3.1414202149E+00, 9.2959494716E-01],
	[2.8100000000E+04, 2.6284883020E+01, 5.5797766161E+00, 9.9015489337E+00, 3.1421085332E+00, 9.2963322765E-01],
	[2.8105000000E+04, 2.6292616181E+01, 5.5797698130E+00, 9.9073085030E+00, 3.1427966607E+00, 9.2967148635E-01],
	[2.8110000000E+04, 2.6300350241E+01, 5.5797630111E+00, 9.9130703964E+00, 3.1434845974E+00, 9.2970972325E-01],
	[2.8115000000E+04, 2.6308085200E+01, 5.5797562103E+00, 9.9188346142E+00, 3.1441723433E+00, 9.2974793839E-01],
	[2.8120000000E+04, 2.6315821057E+01, 5.5797494109E+00, 9.9246011572E+00, 3.1448598984E+00, 9.2978613176E-01],
	[2.8125000000E+04, 2.6323557814E+01, 5.5797426126E+00, 9.9303700258E+00, 3.1455472626E+00, 9.2982430338E-01],
	[2.8130000000E+04, 2.6331295469E+01, 5.5797358155E+00, 9.9361412205E+00, 3.1462344361E+00, 9.2986245326E-01],
	[2.8135000000E+04, 2.6339034022E+01, 5.5797290197E+00, 9.9419147418E+00, 3.1469214187E+00, 9.2990058142E-01],
	[2.8140000000E+04, 2.6346773475E+01, 5.5797222251E+00, 9.9476905903E+00, 3.1476082106E+00, 9.2993868786E-01],
	[2.8145000000E+04, 2.6354513825E+01, 5.5797154316E+00, 9.9534687666E+00, 3.1482948116E+00, 9.2997677261E-01],
	[2.8150000000E+04, 2.6362255074E+01, 5.5797086395E+00, 9.9592492710E+00, 3.1489812218E+00, 9.3001483566E-01],
	[2.8155000000E+04, 2.6369997222E+01, 5.5797018485E+00, 9.9650321042E+00, 3.1496674412E+00, 9.3005287704E-01],
	[2.8160000000E+04, 2.6377740268E+01, 5.5796950587E+00, 9.9708172666E+00, 3.1503534698E+00, 9.3009089676E-01],
	[2.8165000000E+04, 2.6385484212E+01, 5.5796882702E+00, 9.9766047589E+00, 3.1510393075E+00, 9.3012889483E-01],
	[2.8170000000E+04, 2.6393229054E+01, 5.5796814828E+00, 9.9823945814E+00, 3.1517249544E+00, 9.3016687125E-01],
	[2.8175000000E+04, 2.6400974795E+01, 5.5796746967E+00, 9.9881867349E+00, 3.1524104106E+00, 9.3020482606E-01],
	[2.8180000000E+04, 2.6408721434E+01, 5.5796679118E+00, 9.9939812196E+00, 3.1530956759E+00, 9.3024275924E-01],
	[2.8185000000E+04, 2.6416468970E+01, 5.5796611281E+00, 9.9997780363E+00, 3.1537807503E+00, 9.3028067083E-01],
	[2.8190000000E+04, 2.6424217405E+01, 5.5796543456E+00, 1.0005577185E+01, 3.1544656340E+00, 9.3031856083E-01],
	[2.8195000000E+04, 2.6431966738E+01, 5.5796475643E+00, 1.0011378667E+01, 3.1551503268E+00, 9.3035642925E-01],
	[2.8200000000E+04, 2.6439716968E+01, 5.5796407842E+00, 1.0017182483E+01, 3.1558348288E+00, 9.3039427610E-01],
	[2.8205000000E+04, 2.6447468097E+01, 5.5796340054E+00, 1.0022988632E+01, 3.1565191400E+00, 9.3043210141E-01],
	[2.8210000000E+04, 2.6455220123E+01, 5.5796272277E+00, 1.0028797116E+01, 3.1572032603E+00, 9.3046990517E-01],
	[2.8215000000E+04, 2.6462973047E+01, 5.5796204513E+00, 1.0034607935E+01, 3.1578871899E+00, 9.3050768741E-01],
	[2.8220000000E+04, 2.6470726869E+01, 5.5796136761E+00, 1.0040421090E+01, 3.1585709286E+00, 9.3054544813E-01],
	[2.8225000000E+04, 2.6478481588E+01, 5.5796069020E+00, 1.0046236580E+01, 3.1592544765E+00, 9.3058318735E-01],
	[2.8230000000E+04, 2.6486237205E+01, 5.5796001292E+00, 1.0052054408E+01, 3.1599378335E+00, 9.3062090507E-01],
	[2.8235000000E+04, 2.6493993719E+01, 5.5795933576E+00, 1.0057874572E+01, 3.1606209997E+00, 9.3065860132E-01],
	[2.8240000000E+04, 2.6501751131E+01, 5.5795865872E+00, 1.0063697074E+01, 3.1613039751E+00, 9.3069627611E-01],
	[2.8245000000E+04, 2.6509509440E+01, 5.5795798180E+00, 1.0069521914E+01, 3.1619867597E+00, 9.3073392944E-01],
	[2.8250000000E+04, 2.6517268647E+01, 5.5795730500E+00, 1.0075349093E+01, 3.1626693535E+00, 9.3077156133E-01],
	[2.8255000000E+04, 2.6525028750E+01, 5.5795662833E+00, 1.0081178611E+01, 3.1633517564E+00, 9.3080917179E-01],
	[2.8260000000E+04, 2.6532789752E+01, 5.5795595177E+00, 1.0087010469E+01, 3.1640339685E+00, 9.3084676084E-01],
	[2.8265000000E+04, 2.6540551650E+01, 5.5795527533E+00, 1.0092844667E+01, 3.1647159898E+00, 9.3088432848E-01],
	[2.8270000000E+04, 2.6548314445E+01, 5.5795459902E+00, 1.0098681206E+01, 3.1653978202E+00, 9.3092187473E-01],
	[2.8275000000E+04, 2.6556078138E+01, 5.5795392282E+00, 1.0104520087E+01, 3.1660794598E+00, 9.3095939960E-01],
	[2.8280000000E+04, 2.6563842727E+01, 5.5795324674E+00, 1.0110361309E+01, 3.1667609086E+00, 9.3099690310E-01],
	[2.8285000000E+04, 2.6571608213E+01, 5.5795257079E+00, 1.0116204873E+01, 3.1674421666E+00, 9.3103438525E-01],
	[2.8290000000E+04, 2.6579374597E+01, 5.5795189495E+00, 1.0122050781E+01, 3.1681232338E+00, 9.3107184605E-01],
	[2.8295000000E+04, 2.6587141877E+01, 5.5795121924E+00, 1.0127899032E+01, 3.1688041101E+00, 9.3110928553E-01],
	[2.8300000000E+04, 2.6594910054E+01, 5.5795054365E+00, 1.0133749626E+01, 3.1694847957E+00, 9.3114670368E-01],
	[2.8305000000E+04, 2.6602679128E+01, 5.5794986817E+00, 1.0139602566E+01, 3.1701652904E+00, 9.3118410053E-01],
	[2.8310000000E+04, 2.6610449098E+01, 5.5794919282E+00, 1.0145457850E+01, 3.1708455943E+00, 9.3122147609E-01],
	[2.8315000000E+04, 2.6618219965E+01, 5.5794851758E+00, 1.0151315480E+01, 3.1715257073E+00, 9.3125883037E-01],
	[2.8320000000E+04, 2.6625991729E+01, 5.5794784247E+00, 1.0157175456E+01, 3.1722056296E+00, 9.3129616338E-01],
	[2.8325000000E+04, 2.6633764389E+01, 5.5794716747E+00, 1.0163037778E+01, 3.1728853611E+00, 9.3133347513E-01],
	[2.8330000000E+04, 2.6641537945E+01, 5.5794649260E+00, 1.0168902447E+01, 3.1735649017E+00, 9.3137076564E-01],
	[2.8335000000E+04, 2.6649312398E+01, 5.5794581785E+00, 1.0174769465E+01, 3.1742442515E+00, 9.3140803492E-01],
	[2.8340000000E+04, 2.6657087748E+01, 5.5794514321E+00, 1.0180638830E+01, 3.1749234105E+00, 9.3144528297E-01],
	[2.8345000000E+04, 2.6664863993E+01, 5.5794446870E+00, 1.0186510544E+01, 3.1756023787E+00, 9.3148250982E-01],
	[2.8350000000E+04, 2.6672641135E+01, 5.5794379430E+00, 1.0192384607E+01, 3.1762811562E+00, 9.3151971548E-01],
	[2.8355000000E+04, 2.6680419173E+01, 5.5794312003E+00, 1.0198261020E+01, 3.1769597428E+00, 9.3155689995E-01],
	[2.8360000000E+04, 2.6688198107E+01, 5.5794244587E+00, 1.0204139783E+01, 3.1776381386E+00, 9.3159406325E-01],
	[2.8365000000E+04, 2.6695977938E+01, 5.5794177184E+00, 1.0210020897E+01, 3.1783163436E+00, 9.3163120540E-01],
	[2.8370000000E+04, 2.6703758664E+01, 5.5794109792E+00, 1.0215904362E+01, 3.1789943578E+00, 9.3166832640E-01],
	[2.8375000000E+04, 2.6711540286E+01, 5.5794042413E+00, 1.0221790179E+01, 3.1796721812E+00, 9.3170542626E-01],
	[2.8380000000E+04, 2.6719322805E+01, 5.5793975045E+00, 1.0227678348E+01, 3.1803498138E+00, 9.3174250501E-01],
	[2.8385000000E+04, 2.6727106219E+01, 5.5793907689E+00, 1.0233568870E+01, 3.1810272556E+00, 9.3177956264E-01],
	[2.8390000000E+04, 2.6734890529E+01, 5.5793840345E+00, 1.0239461746E+01, 3.1817045067E+00, 9.3181659918E-01],
	[2.8395000000E+04, 2.6742675734E+01, 5.5793773013E+00, 1.0245356976E+01, 3.1823815669E+00, 9.3185361464E-01],
	[2.8400000000E+04, 2.6750461836E+01, 5.5793705694E+00, 1.0251254559E+01, 3.1830584364E+00, 9.3189060902E-01],
	[2.8405000000E+04, 2.6758248833E+01, 5.5793638386E+00, 1.0257154498E+01, 3.1837351151E+00, 9.3192758234E-01],
	[2.8410000000E+04, 2.6766036725E+01, 5.5793571090E+00, 1.0263056793E+01, 3.1844116030E+00, 9.3196453462E-01],
	[2.8415000000E+04, 2.6773825513E+01, 5.5793503805E+00, 1.0268961443E+01, 3.1850879001E+00, 9.3200146586E-01],
	[2.8420000000E+04, 2.6781615197E+01, 5.5793436533E+00, 1.0274868450E+01, 3.1857640065E+00, 9.3203837608E-01],
	[2.8425000000E+04, 2.6789405776E+01, 5.5793369273E+00, 1.0280777814E+01, 3.1864399221E+00, 9.3207526528E-01],
	[2.8430000000E+04, 2.6797197250E+01, 5.5793302025E+00, 1.0286689536E+01, 3.1871156469E+00, 9.3211213349E-01],
	[2.8435000000E+04, 2.6804989620E+01, 5.5793234788E+00, 1.0292603616E+01, 3.1877911810E+00, 9.3214898072E-01],
	[2.8440000000E+04, 2.6812782885E+01, 5.5793167563E+00, 1.0298520054E+01, 3.1884665243E+00, 9.3218580696E-01],
	[2.8445000000E+04, 2.6820577045E+01, 5.5793100351E+00, 1.0304438852E+01, 3.1891416769E+00, 9.3222261225E-01],
	[2.8450000000E+04, 2.6828372101E+01, 5.5793033150E+00, 1.0310360009E+01, 3.1898166387E+00, 9.3225939659E-01],
	[2.8455000000E+04, 2.6836168051E+01, 5.5792965961E+00, 1.0316283527E+01, 3.1904914097E+00, 9.3229615999E-01],
	[2.8460000000E+04, 2.6843964897E+01, 5.5792898784E+00, 1.0322209405E+01, 3.1911659900E+00, 9.3233290246E-01],
	[2.8465000000E+04, 2.6851762637E+01, 5.5792831619E+00, 1.0328137644E+01, 3.1918403795E+00, 9.3236962403E-01],
	[2.8470000000E+04, 2.6859561272E+01, 5.5792764466E+00, 1.0334068246E+01, 3.1925145784E+00, 9.3240632469E-01],
	[2.8475000000E+04, 2.6867360803E+01, 5.5792697324E+00, 1.0340001209E+01, 3.1931885864E+00, 9.3244300446E-01],
	[2.8480000000E+04, 2.6875161228E+01, 5.5792630195E+00, 1.0345936536E+01, 3.1938624038E+00, 9.3247966336E-01],
	[2.8485000000E+04, 2.6882962548E+01, 5.5792563077E+00, 1.0351874226E+01, 3.1945360304E+00, 9.3251630140E-01],
	[2.8490000000E+04, 2.6890764762E+01, 5.5792495971E+00, 1.0357814280E+01, 3.1952094663E+00, 9.3255291858E-01],
	[2.8495000000E+04, 2.6898567872E+01, 5.5792428878E+00, 1.0363756698E+01, 3.1958827114E+00, 9.3258951492E-01],
	[2.8500000000E+04, 2.6906371876E+01, 5.5792361796E+00, 1.0369701481E+01, 3.1965557659E+00, 9.3262609044E-01],
	[2.8505000000E+04, 2.6914176774E+01, 5.5792294725E+00, 1.0375648630E+01, 3.1972286296E+00, 9.3266264514E-01],
	[2.8510000000E+04, 2.6921990494E+01, 5.5792237413E+00, 1.0381598144E+01, 3.1979017347E+00, 9.3269917904E-01],
	[2.8515000000E+04, 2.6929824907E+01, 5.5792204440E+00, 1.0387550025E+01, 3.1985757282E+00, 9.3273569215E-01],
	[2.8520000000E+04, 2.6937660225E+01, 5.5792171473E+00, 1.0393504274E+01, 3.1992495317E+00, 9.3277218448E-01],
	[2.8525000000E+04, 2.6945496449E+01, 5.5792138511E+00, 1.0399460889E+01, 3.1999231454E+00, 9.3280865605E-01],
	[2.8530000000E+04, 2.6953333578E+01, 5.5792105556E+00, 1.0405419873E+01, 3.2005965691E+00, 9.3284510686E-01],
	[2.8535000000E+04, 2.6961171613E+01, 5.5792072606E+00, 1.0411381226E+01, 3.2012698029E+00, 9.3288153693E-01],
	[2.8540000000E+04, 2.6969010553E+01, 5.5792039662E+00, 1.0417344948E+01, 3.2019428469E+00, 9.3291794627E-01],
	[2.8545000000E+04, 2.6976850398E+01, 5.5792006723E+00, 1.0423311039E+01, 3.2026157009E+00, 9.3295433489E-01],
	[2.8550000000E+04, 2.6984691149E+01, 5.5791973791E+00, 1.0429279501E+01, 3.2032883650E+00, 9.3299070281E-01],
	[2.8555000000E+04, 2.6992532805E+01, 5.5791940864E+00, 1.0435250333E+01, 3.2039608392E+00, 9.3302705004E-01],
	[2.8560000000E+04, 2.7000375366E+01, 5.5791907943E+00, 1.0441223537E+01, 3.2046331236E+00, 9.3306337658E-01],
	[2.8565000000E+04, 2.7008218833E+01, 5.5791875028E+00, 1.0447199112E+01, 3.2053052180E+00, 9.3309968246E-01],
	[2.8570000000E+04, 2.7016063204E+01, 5.5791842118E+00, 1.0453177060E+01, 3.2059771226E+00, 9.3313596768E-01],
	[2.8575000000E+04, 2.7023908481E+01, 5.5791809215E+00, 1.0459157380E+01, 3.2066488374E+00, 9.3317223225E-01],
	[2.8580000000E+04, 2.7031754662E+01, 5.5791776317E+00, 1.0465140074E+01, 3.2073203622E+00, 9.3320847619E-01],
	[2.8585000000E+04, 2.7039601749E+01, 5.5791743425E+00, 1.0471125142E+01, 3.2079916972E+00, 9.3324469950E-01],
	[2.8590000000E+04, 2.7047449740E+01, 5.5791710538E+00, 1.0477112584E+01, 3.2086628423E+00, 9.3328090220E-01],
	[2.8595000000E+04, 2.7055298636E+01, 5.5791677658E+00, 1.0483102401E+01, 3.2093337976E+00, 9.3331708429E-01],
	[2.8600000000E+04, 2.7063148437E+01, 5.5791644783E+00, 1.0489094594E+01, 3.2100045630E+00, 9.3335324579E-01],
	[2.8605000000E+04, 2.7070999143E+01, 5.5791611914E+00, 1.0495089162E+01, 3.2106751386E+00, 9.3338938671E-01],
	[2.8610000000E+04, 2.7078850753E+01, 5.5791579051E+00, 1.0501086107E+01, 3.2113455244E+00, 9.3342550705E-01],
	[2.8615000000E+04, 2.7086703268E+01, 5.5791546193E+00, 1.0507085430E+01, 3.2120157203E+00, 9.3346160683E-01],
	[2.8620000000E+04, 2.7094556687E+01, 5.5791513341E+00, 1.0513087129E+01, 3.2126857264E+00, 9.3349768606E-01],
	[2.8625000000E+04, 2.7102411011E+01, 5.5791480496E+00, 1.0519091207E+01, 3.2133555426E+00, 9.3353374475E-01],
	[2.8630000000E+04, 2.7110266239E+01, 5.5791447655E+00, 1.0525097664E+01, 3.2140251691E+00, 9.3356978291E-01],
	[2.8635000000E+04, 2.7118122372E+01, 5.5791414821E+00, 1.0531106499E+01, 3.2146946057E+00, 9.3360580054E-01],
	[2.8640000000E+04, 2.7125979409E+01, 5.5791381992E+00, 1.0537117715E+01, 3.2153638525E+00, 9.3364179767E-01],
	[2.8645000000E+04, 2.7133837351E+01, 5.5791349169E+00, 1.0543131310E+01, 3.2160329096E+00, 9.3367777430E-01],
	[2.8650000000E+04, 2.7141696196E+01, 5.5791316352E+00, 1.0549147286E+01, 3.2167017768E+00, 9.3371373045E-01],
	[2.8655000000E+04, 2.7149555946E+01, 5.5791283540E+00, 1.0555165644E+01, 3.2173704543E+00, 9.3374966611E-01],
	[2.8660000000E+04, 2.7157416600E+01, 5.5791250735E+00, 1.0561186383E+01, 3.2180389419E+00, 9.3378558131E-01],
	[2.8665000000E+04, 2.7165278158E+01, 5.5791217935E+00, 1.0567209505E+01, 3.2187072398E+00, 9.3382147605E-01],
	[2.8670000000E+04, 2.7173140620E+01, 5.5791185140E+00, 1.0573235009E+01, 3.2193753479E+00, 9.3385735035E-01],
	[2.8675000000E+04, 2.7181003986E+01, 5.5791152352E+00, 1.0579262897E+01, 3.2200432663E+00, 9.3389320422E-01],
	[2.8680000000E+04, 2.7188868256E+01, 5.5791119569E+00, 1.0585293168E+01, 3.2207109949E+00, 9.3392903765E-01],
	[2.8685000000E+04, 2.7196733429E+01, 5.5791086792E+00, 1.0591325824E+01, 3.2213785337E+00, 9.3396485068E-01],
	[2.8690000000E+04, 2.7204599507E+01, 5.5791054021E+00, 1.0597360865E+01, 3.2220458828E+00, 9.3400064330E-01],
	[2.8695000000E+04, 2.7212466488E+01, 5.5791021255E+00, 1.0603398292E+01, 3.2227130422E+00, 9.3403641554E-01],
	[2.8700000000E+04, 2.7220334373E+01, 5.5790988495E+00, 1.0609438104E+01, 3.2233800118E+00, 9.3407216739E-01],
	[2.8705000000E+04, 2.7228203162E+01, 5.5790955741E+00, 1.0615480303E+01, 3.2240467917E+00, 9.3410789887E-01],
	[2.8710000000E+04, 2.7236072854E+01, 5.5790922993E+00, 1.0621524889E+01, 3.2247133819E+00, 9.3414360998E-01],
	[2.8715000000E+04, 2.7243943450E+01, 5.5790890250E+00, 1.0627571863E+01, 3.2253797823E+00, 9.3417930075E-01],
	[2.8720000000E+04, 2.7251814949E+01, 5.5790857513E+00, 1.0633621225E+01, 3.2260459931E+00, 9.3421497119E-01],
	[2.8725000000E+04, 2.7259687351E+01, 5.5790824782E+00, 1.0639672975E+01, 3.2267120141E+00, 9.3425062129E-01],
	[2.8730000000E+04, 2.7267560657E+01, 5.5790792057E+00, 1.0645727115E+01, 3.2273778455E+00, 9.3428625107E-01],
	[2.8735000000E+04, 2.7275434867E+01, 5.5790759337E+00, 1.0651783644E+01, 3.2280434872E+00, 9.3432186055E-01],
	[2.8740000000E+04, 2.7283309979E+01, 5.5790726623E+00, 1.0657842563E+01, 3.2287089392E+00, 9.3435744974E-01],
	[2.8745000000E+04, 2.7291185995E+01, 5.5790693914E+00, 1.0663903873E+01, 3.2293742015E+00, 9.3439301863E-01],
	[2.8750000000E+04, 2.7299062914E+01, 5.5790661212E+00, 1.0669967575E+01, 3.2300392741E+00, 9.3442856726E-01],
	[2.8755000000E+04, 2.7306940736E+01, 5.5790628515E+00, 1.0676033668E+01, 3.2307041571E+00, 9.3446409562E-01],
	[2.8760000000E+04, 2.7314819461E+01, 5.5790595823E+00, 1.0682102153E+01, 3.2313688505E+00, 9.3449960372E-01],
	[2.8765000000E+04, 2.7322699089E+01, 5.5790563138E+00, 1.0688173032E+01, 3.2320333542E+00, 9.3453509158E-01],
	[2.8770000000E+04, 2.7330579620E+01, 5.5790530458E+00, 1.0694246303E+01, 3.2326976683E+00, 9.3457055921E-01],
	[2.8775000000E+04, 2.7338461054E+01, 5.5790497784E+00, 1.0700321969E+01, 3.2333617927E+00, 9.3460600662E-01],
	[2.8780000000E+04, 2.7346343391E+01, 5.5790465115E+00, 1.0706400029E+01, 3.2340257275E+00, 9.3464143382E-01],
	[2.8785000000E+04, 2.7354226630E+01, 5.5790432453E+00, 1.0712480484E+01, 3.2346894727E+00, 9.3467684082E-01],
	[2.8790000000E+04, 2.7362110773E+01, 5.5790399795E+00, 1.0718563334E+01, 3.2353530283E+00, 9.3471222763E-01],
	[2.8795000000E+04, 2.7369995818E+01, 5.5790367144E+00, 1.0724648581E+01, 3.2360163943E+00, 9.3474759426E-01],
	[2.8800000000E+04, 2.7377881765E+01, 5.5790334498E+00, 1.0730736224E+01, 3.2366795707E+00, 9.3478294072E-01],
	[2.8805000000E+04, 2.7385768615E+01, 5.5790301858E+00, 1.0736826264E+01, 3.2373425575E+00, 9.3481826703E-01],
	[2.8810000000E+04, 2.7393656368E+01, 5.5790269224E+00, 1.0742918701E+01, 3.2380053547E+00, 9.3485357319E-01],
	[2.8815000000E+04, 2.7401545023E+01, 5.5790236595E+00, 1.0749013537E+01, 3.2386679624E+00, 9.3488885921E-01],
	[2.8820000000E+04, 2.7409434581E+01, 5.5790203972E+00, 1.0755110772E+01, 3.2393303805E+00, 9.3492412511E-01],
	[2.8825000000E+04, 2.7417325040E+01, 5.5790171355E+00, 1.0761210405E+01, 3.2399926091E+00, 9.3495937089E-01],
	[2.8830000000E+04, 2.7425216403E+01, 5.5790138743E+00, 1.0767312438E+01, 3.2406546481E+00, 9.3499459657E-01],
	[2.8835000000E+04, 2.7433108667E+01, 5.5790106137E+00, 1.0773416872E+01, 3.2413164976E+00, 9.3502980216E-01],
	[2.8840000000E+04, 2.7441001834E+01, 5.5790073537E+00, 1.0779523706E+01, 3.2419781576E+00, 9.3506498766E-01],
	[2.8845000000E+04, 2.7448895902E+01, 5.5790040943E+00, 1.0785632941E+01, 3.2426396280E+00, 9.3510015309E-01],
	[2.8850000000E+04, 2.7456790873E+01, 5.5790008354E+00, 1.0791744579E+01, 3.2433009089E+00, 9.3513529847E-01],
	[2.8855000000E+04, 2.7464686746E+01, 5.5789975770E+00, 1.0797858618E+01, 3.2439620004E+00, 9.3517042379E-01],
	[2.8860000000E+04, 2.7472583521E+01, 5.5789943193E+00, 1.0803975061E+01, 3.2446229023E+00, 9.3520552907E-01],
	[2.8865000000E+04, 2.7480481198E+01, 5.5789910621E+00, 1.0810093906E+01, 3.2452836148E+00, 9.3524061432E-01],
	[2.8870000000E+04, 2.7488379776E+01, 5.5789878055E+00, 1.0816215156E+01, 3.2459441377E+00, 9.3527567956E-01],
	[2.8875000000E+04, 2.7496279257E+01, 5.5789845494E+00, 1.0822338810E+01, 3.2466044712E+00, 9.3531072478E-01],
	[2.8880000000E+04, 2.7504179639E+01, 5.5789812939E+00, 1.0828464870E+01, 3.2472646153E+00, 9.3534575001E-01],
	[2.8885000000E+04, 2.7512080923E+01, 5.5789780390E+00, 1.0834593334E+01, 3.2479245699E+00, 9.3538075526E-01],
	[2.8890000000E+04, 2.7519983109E+01, 5.5789747846E+00, 1.0840724205E+01, 3.2485843351E+00, 9.3541574053E-01],
	[2.8895000000E+04, 2.7527886196E+01, 5.5789715308E+00, 1.0846857482E+01, 3.2492439108E+00, 9.3545070583E-01],
	[2.8900000000E+04, 2.7535790185E+01, 5.5789682776E+00, 1.0852993166E+01, 3.2499032971E+00, 9.3548565118E-01],
	[2.8905000000E+04, 2.7543695075E+01, 5.5789650249E+00, 1.0859131258E+01, 3.2505624940E+00, 9.3552057659E-01],
	[2.8910000000E+04, 2.7551600867E+01, 5.5789617728E+00, 1.0865271758E+01, 3.2512215015E+00, 9.3555548206E-01],
	[2.8915000000E+04, 2.7559507560E+01, 5.5789585213E+00, 1.0871414667E+01, 3.2518803196E+00, 9.3559036762E-01],
	[2.8920000000E+04, 2.7567415154E+01, 5.5789552703E+00, 1.0877559985E+01, 3.2525389483E+00, 9.3562523326E-01],
	[2.8925000000E+04, 2.7575323650E+01, 5.5789520199E+00, 1.0883707712E+01, 3.2531973877E+00, 9.3566007900E-01],
	[2.8930000000E+04, 2.7583233047E+01, 5.5789487700E+00, 1.0889857850E+01, 3.2538556377E+00, 9.3569490485E-01],
	[2.8935000000E+04, 2.7591143345E+01, 5.5789455207E+00, 1.0896010399E+01, 3.2545136983E+00, 9.3572971083E-01],
	[2.8940000000E+04, 2.7599054545E+01, 5.5789422720E+00, 1.0902165359E+01, 3.2551715696E+00, 9.3576449693E-01],
	[2.8945000000E+04, 2.7606966645E+01, 5.5789390238E+00, 1.0908322730E+01, 3.2558292515E+00, 9.3579926318E-01],
	[2.8950000000E+04, 2.7614879646E+01, 5.5789357762E+00, 1.0914482514E+01, 3.2564867441E+00, 9.3583400958E-01],
	[2.8955000000E+04, 2.7622793549E+01, 5.5789325292E+00, 1.0920644711E+01, 3.2571440474E+00, 9.3586873615E-01],
	[2.8960000000E+04, 2.7630708352E+01, 5.5789292827E+00, 1.0926809322E+01, 3.2578011614E+00, 9.3590344289E-01],
	[2.8965000000E+04, 2.7638624056E+01, 5.5789260368E+00, 1.0932976346E+01, 3.2584580861E+00, 9.3593812981E-01],
	[2.8970000000E+04, 2.7646554265E+01, 5.5789244493E+00, 1.0939145785E+01, 3.2591155763E+00, 9.3597279693E-01],
	[2.8975000000E+04, 2.7654499196E+01, 5.5789245453E+00, 1.0945317638E+01, 3.2597736443E+00, 9.3600744426E-01],
	[2.8980000000E+04, 2.7662445039E+01, 5.5789246413E+00, 1.0951491908E+01, 3.2604315237E+00, 9.3604207181E-01],
	[2.8985000000E+04, 2.7670391794E+01, 5.5789247373E+00, 1.0957668593E+01, 3.2610892147E+00, 9.3607667958E-01],
	[2.8990000000E+04, 2.7678339460E+01, 5.5789248333E+00, 1.0963847695E+01, 3.2617467171E+00, 9.3611126760E-01],
	[2.8995000000E+04, 2.7686288038E+01, 5.5789249293E+00, 1.0970029214E+01, 3.2624040310E+00, 9.3614583586E-01],
	[2.9000000000E+04, 2.7694237527E+01, 5.5789250252E+00, 1.0976213150E+01, 3.2630611565E+00, 9.3618038438E-01],
	[2.9005000000E+04, 2.7702187928E+01, 5.5789251211E+00, 1.0982399505E+01, 3.2637180935E+00, 9.3621491318E-01],
	[2.9010000000E+04, 2.7710139240E+01, 5.5789252170E+00, 1.0988588278E+01, 3.2643748420E+00, 9.3624942226E-01],
	[2.9015000000E+04, 2.7718091463E+01, 5.5789253129E+00, 1.0994779471E+01, 3.2650314021E+00, 9.3628391163E-01],
	[2.9020000000E+04, 2.7726044598E+01, 5.5789254088E+00, 1.1000973084E+01, 3.2656877737E+00, 9.3631838130E-01],
	[2.9025000000E+04, 2.7733998644E+01, 5.5789255046E+00, 1.1007169116E+01, 3.2663439569E+00, 9.3635283129E-01],
	[2.9030000000E+04, 2.7741953601E+01, 5.5789256005E+00, 1.1013367570E+01, 3.2669999517E+00, 9.3638726160E-01],
	[2.9035000000E+04, 2.7749909469E+01, 5.5789256963E+00, 1.1019568444E+01, 3.2676557581E+00, 9.3642167225E-01],
	[2.9040000000E+04, 2.7757866249E+01, 5.5789257921E+00, 1.1025771741E+01, 3.2683113761E+00, 9.3645606325E-01],
	[2.9045000000E+04, 2.7765823939E+01, 5.5789258879E+00, 1.1031977460E+01, 3.2689668057E+00, 9.3649043460E-01],
	[2.9050000000E+04, 2.7773782540E+01, 5.5789259837E+00, 1.1038185602E+01, 3.2696220469E+00, 9.3652478632E-01],
	[2.9055000000E+04, 2.7781742052E+01, 5.5789260794E+00, 1.1044396168E+01, 3.2702770997E+00, 9.3655911842E-01],
	[2.9060000000E+04, 2.7789702476E+01, 5.5789261751E+00, 1.1050609157E+01, 3.2709319642E+00, 9.3659343091E-01],
	[2.9065000000E+04, 2.7797663809E+01, 5.5789262709E+00, 1.1056824571E+01, 3.2715866404E+00, 9.3662772379E-01],
	[2.9070000000E+04, 2.7805626054E+01, 5.5789263666E+00, 1.1063042410E+01, 3.2722411282E+00, 9.3666199709E-01],
	[2.9075000000E+04, 2.7813589209E+01, 5.5789264623E+00, 1.1069262674E+01, 3.2728954276E+00, 9.3669625082E-01],
	[2.9080000000E+04, 2.7821553275E+01, 5.5789265579E+00, 1.1075485365E+01, 3.2735495388E+00, 9.3673048497E-01],
	[2.9085000000E+04, 2.7829518252E+01, 5.5789266536E+00, 1.1081710482E+01, 3.2742034617E+00, 9.3676469957E-01],
	[2.9090000000E+04, 2.7837484139E+01, 5.5789267492E+00, 1.1087938026E+01, 3.2748571963E+00, 9.3679889462E-01],
	[2.9095000000E+04, 2.7845450937E+01, 5.5789268449E+00, 1.1094167998E+01, 3.2755107426E+00, 9.3683307013E-01],
	[2.9100000000E+04, 2.7853418645E+01, 5.5789269405E+00, 1.1100400398E+01, 3.2761641006E+00, 9.3686722612E-01],
	[2.9105000000E+04, 2.7861387263E+01, 5.5789270361E+00, 1.1106635227E+01, 3.2768172704E+00, 9.3690136260E-01],
	[2.9110000000E+04, 2.7869356792E+01, 5.5789271316E+00, 1.1112872485E+01, 3.2774702519E+00, 9.3693547957E-01],
	[2.9115000000E+04, 2.7877327231E+01, 5.5789272272E+00, 1.1119112173E+01, 3.2781230452E+00, 9.3696957705E-01],
	[2.9120000000E+04, 2.7885298581E+01, 5.5789273227E+00, 1.1125354291E+01, 3.2787756503E+00, 9.3700365505E-01],
	[2.9125000000E+04, 2.7893270840E+01, 5.5789274183E+00, 1.1131598840E+01, 3.2794280671E+00, 9.3703771358E-01],
	[2.9130000000E+04, 2.7901244010E+01, 5.5789275138E+00, 1.1137845820E+01, 3.2800802958E+00, 9.3707175265E-01],
	[2.9135000000E+04, 2.7909218090E+01, 5.5789276093E+00, 1.1144095233E+01, 3.2807323363E+00, 9.3710577227E-01],
	[2.9140000000E+04, 2.7917193079E+01, 5.5789277047E+00, 1.1150347077E+01, 3.2813841886E+00, 9.3713977245E-01],
	[2.9145000000E+04, 2.7925168979E+01, 5.5789278002E+00, 1.1156601355E+01, 3.2820358527E+00, 9.3717375320E-01],
	[2.9150000000E+04, 2.7933145789E+01, 5.5789278956E+00, 1.1162858066E+01, 3.2826873287E+00, 9.3720771453E-01],
	[2.9155000000E+04, 2.7941123508E+01, 5.5789279911E+00, 1.1169117211E+01, 3.2833386166E+00, 9.3724165646E-01],
	[2.9160000000E+04, 2.7949102138E+01, 5.5789280865E+00, 1.1175378791E+01, 3.2839897163E+00, 9.3727557899E-01],
	[2.9165000000E+04, 2.7957081677E+01, 5.5789281819E+00, 1.1181642806E+01, 3.2846406279E+00, 9.3730948214E-01],
	[2.9170000000E+04, 2.7965062126E+01, 5.5789282772E+00, 1.1187909256E+01, 3.2852913514E+00, 9.3734336591E-01],
	[2.9175000000E+04, 2.7973043484E+01, 5.5789283726E+00, 1.1194178143E+01, 3.2859418868E+00, 9.3737723032E-01],
	[2.9180000000E+04, 2.7981025752E+01, 5.5789284679E+00, 1.1200449466E+01, 3.2865922341E+00, 9.3741107538E-01],
	[2.9185000000E+04, 2.7989008930E+01, 5.5789285633E+00, 1.1206723226E+01, 3.2872423934E+00, 9.3744490109E-01],
	[2.9190000000E+04, 2.7996993017E+01, 5.5789286586E+00, 1.1212999424E+01, 3.2878923646E+00, 9.3747870748E-01],
	[2.9195000000E+04, 2.8004978013E+01, 5.5789287539E+00, 1.1219278061E+01, 3.2885421477E+00, 9.3751249454E-01],
	[2.9200000000E+04, 2.8012963919E+01, 5.5789288492E+00, 1.1225559136E+01, 3.2891917429E+00, 9.3754626229E-01],
	[2.9205000000E+04, 2.8020950735E+01, 5.5789289444E+00, 1.1231842650E+01, 3.2898411500E+00, 9.3758001075E-01],
	[2.9210000000E+04, 2.8028938459E+01, 5.5789290397E+00, 1.1238128604E+01, 3.2904903691E+00, 9.3761373991E-01],
	[2.9215000000E+04, 2.8036927093E+01, 5.5789291349E+00, 1.1244416999E+01, 3.2911394002E+00, 9.3764744980E-01],
	[2.9220000000E+04, 2.8044916636E+01, 5.5789292301E+00, 1.1250707834E+01, 3.2917882433E+00, 9.3768114042E-01],
	[2.9225000000E+04, 2.8052907088E+01, 5.5789293253E+00, 1.1257001111E+01, 3.2924368985E+00, 9.3771481179E-01],
	[2.9230000000E+04, 2.8060898450E+01, 5.5789294205E+00, 1.1263296830E+01, 3.2930853657E+00, 9.3774846391E-01],
	[2.9235000000E+04, 2.8068890720E+01, 5.5789295157E+00, 1.1269594991E+01, 3.2937336450E+00, 9.3778209679E-01],
	[2.9240000000E+04, 2.8076883899E+01, 5.5789296108E+00, 1.1275895595E+01, 3.2943817363E+00, 9.3781571045E-01],
	[2.9245000000E+04, 2.8084877987E+01, 5.5789297059E+00, 1.1282198643E+01, 3.2950296398E+00, 9.3784930490E-01],
	[2.9250000000E+04, 2.8092872984E+01, 5.5789298011E+00, 1.1288504135E+01, 3.2956773553E+00, 9.3788288015E-01],
	[2.9255000000E+04, 2.8100868890E+01, 5.5789298962E+00, 1.1294812071E+01, 3.2963248829E+00, 9.3791643620E-01],
	[2.9260000000E+04, 2.8108865705E+01, 5.5789299912E+00, 1.1301122453E+01, 3.2969722227E+00, 9.3794997308E-01],
	[2.9265000000E+04, 2.8116863428E+01, 5.5789300863E+00, 1.1307435280E+01, 3.2976193746E+00, 9.3798349078E-01],
	[2.9270000000E+04, 2.8124862061E+01, 5.5789301814E+00, 1.1313750553E+01, 3.2982663387E+00, 9.3801698932E-01],
	[2.9275000000E+04, 2.8132861601E+01, 5.5789302764E+00, 1.1320068273E+01, 3.2989131149E+00, 9.3805046872E-01],
	[2.9280000000E+04, 2.8140862050E+01, 5.5789303714E+00, 1.1326388441E+01, 3.2995597033E+00, 9.3808392897E-01],
	[2.9285000000E+04, 2.8148863408E+01, 5.5789304664E+00, 1.1332711056E+01, 3.3002061039E+00, 9.3811737010E-01],
	[2.9290000000E+04, 2.8156865674E+01, 5.5789305614E+00, 1.1339036119E+01, 3.3008523167E+00, 9.3815079212E-01],
	[2.9295000000E+04, 2.8164868849E+01, 5.5789306564E+00, 1.1345363631E+01, 3.3014983417E+00, 9.3818419502E-01],
	[2.9300000000E+04, 2.8172872932E+01, 5.5789307513E+00, 1.1351693593E+01, 3.3021441789E+00, 9.3821757884E-01],
	[2.9305000000E+04, 2.8180877923E+01, 5.5789308463E+00, 1.1358026004E+01, 3.3027898284E+00, 9.3825094357E-01],
	[2.9310000000E+04, 2.8188883823E+01, 5.5789309412E+00, 1.1364360866E+01, 3.3034352902E+00, 9.3828428922E-01],
	[2.9315000000E+04, 2.8196890631E+01, 5.5789310361E+00, 1.1370698179E+01, 3.3040805642E+00, 9.3831761581E-01],
	[2.9320000000E+04, 2.8204898347E+01, 5.5789311310E+00, 1.1377037943E+01, 3.3047256505E+00, 9.3835092335E-01],
	[2.9325000000E+04, 2.8212906971E+01, 5.5789312259E+00, 1.1383380160E+01, 3.3053705491E+00, 9.3838421185E-01],
	[2.9330000000E+04, 2.8220916503E+01, 5.5789313207E+00, 1.1389724828E+01, 3.3060152601E+00, 9.3841748132E-01],
	[2.9335000000E+04, 2.8228926943E+01, 5.5789314156E+00, 1.1396071950E+01, 3.3066597833E+00, 9.3845073177E-01],
	[2.9340000000E+04, 2.8236938291E+01, 5.5789315104E+00, 1.1402421526E+01, 3.3073041190E+00, 9.3848396320E-01],
	[2.9345000000E+04, 2.8244950546E+01, 5.5789316052E+00, 1.1408773555E+01, 3.3079482669E+00, 9.3851717565E-01],
	[2.9350000000E+04, 2.8252963710E+01, 5.5789317000E+00, 1.1415128039E+01, 3.3085922273E+00, 9.3855036910E-01],
	[2.9355000000E+04, 2.8260977782E+01, 5.5789317948E+00, 1.1421484979E+01, 3.3092360000E+00, 9.3858354357E-01],
	[2.9360000000E+04, 2.8268992761E+01, 5.5789318895E+00, 1.1427844374E+01, 3.3098795851E+00, 9.3861669908E-01],
	[2.9365000000E+04, 2.8277008648E+01, 5.5789319843E+00, 1.1434206225E+01, 3.3105229827E+00, 9.3864983564E-01],
	[2.9370000000E+04, 2.8285025442E+01, 5.5789320790E+00, 1.1440570533E+01, 3.3111661926E+00, 9.3868295325E-01],
	[2.9375000000E+04, 2.8293043144E+01, 5.5789321737E+00, 1.1446937299E+01, 3.3118092151E+00, 9.3871605192E-01],
	[2.9380000000E+04, 2.8301061754E+01, 5.5789322684E+00, 1.1453306522E+01, 3.3124520499E+00, 9.3874913167E-01],
	[2.9385000000E+04, 2.8309081271E+01, 5.5789323631E+00, 1.1459678204E+01, 3.3130946973E+00, 9.3878219251E-01],
	[2.9390000000E+04, 2.8317101696E+01, 5.5789324578E+00, 1.1466052344E+01, 3.3137371571E+00, 9.3881523445E-01],
	[2.9395000000E+04, 2.8325123027E+01, 5.5789325524E+00, 1.1472428944E+01, 3.3143794295E+00, 9.3884825750E-01],
	[2.9400000000E+04, 2.8333145267E+01, 5.5789326470E+00, 1.1478808004E+01, 3.3150215144E+00, 9.3888126166E-01],
	[2.9405000000E+04, 2.8341168413E+01, 5.5789327416E+00, 1.1485189524E+01, 3.3156634118E+00, 9.3891424696E-01],
	[2.9410000000E+04, 2.8349192467E+01, 5.5789328362E+00, 1.1491573506E+01, 3.3163051217E+00, 9.3894721340E-01],
	[2.9415000000E+04, 2.8357217428E+01, 5.5789329308E+00, 1.1497959948E+01, 3.3169466442E+00, 9.3898016099E-01],
	[2.9420000000E+04, 2.8365243296E+01, 5.5789330254E+00, 1.1504348853E+01, 3.3175879793E+00, 9.3901308974E-01],
	[2.9425000000E+04, 2.8373270071E+01, 5.5789331199E+00, 1.1510740221E+01, 3.3182291270E+00, 9.3904599966E-01],
	[2.9430000000E+04, 2.8381297753E+01, 5.5789332145E+00, 1.1517134052E+01, 3.3188700873E+00, 9.3907889077E-01],
	[2.9435000000E+04, 2.8389332540E+01, 5.5789340581E+00, 1.1523530346E+01, 3.3195112102E+00, 9.3911176308E-01],
	[2.9440000000E+04, 2.8397389149E+01, 5.5789374286E+00, 1.1529929104E+01, 3.3201533267E+00, 9.3914461659E-01],
	[2.9445000000E+04, 2.8405446677E+01, 5.5789407985E+00, 1.1536330328E+01, 3.3207952567E+00, 9.3917745131E-01],
	[2.9450000000E+04, 2.8413505121E+01, 5.5789441679E+00, 1.1542734016E+01, 3.3214370000E+00, 9.3921026726E-01],
	[2.9455000000E+04, 2.8421564484E+01, 5.5789475366E+00, 1.1549140170E+01, 3.3220785566E+00, 9.3924306445E-01],
	[2.9460000000E+04, 2.8429624763E+01, 5.5789509048E+00, 1.1555548791E+01, 3.3227199267E+00, 9.3927584289E-01],
	[2.9465000000E+04, 2.8437685960E+01, 5.5789542725E+00, 1.1561959878E+01, 3.3233611103E+00, 9.3930860259E-01],
	[2.9470000000E+04, 2.8445748075E+01, 5.5789576395E+00, 1.1568373433E+01, 3.3240021073E+00, 9.3934134355E-01],
	[2.9475000000E+04, 2.8453811106E+01, 5.5789610060E+00, 1.1574789456E+01, 3.3246429177E+00, 9.3937406580E-01],
	[2.9480000000E+04, 2.8461875055E+01, 5.5789643719E+00, 1.1581207947E+01, 3.3252835416E+00, 9.3940676934E-01],
	[2.9485000000E+04, 2.8469939922E+01, 5.5789677373E+00, 1.1587628907E+01, 3.3259239790E+00, 9.3943945417E-01],
	[2.9490000000E+04, 2.8478005705E+01, 5.5789711021E+00, 1.1594052336E+01, 3.3265642299E+00, 9.3947212033E-01],
	[2.9495000000E+04, 2.8486072405E+01, 5.5789744663E+00, 1.1600478236E+01, 3.3272042943E+00, 9.3950476780E-01],
	[2.9500000000E+04, 2.8494140023E+01, 5.5789778299E+00, 1.1606906606E+01, 3.3278441723E+00, 9.3953739661E-01],
	[2.9505000000E+04, 2.8502208557E+01, 5.5789811930E+00, 1.1613337447E+01, 3.3284838638E+00, 9.3957000676E-01],
	[2.9510000000E+04, 2.8510278009E+01, 5.5789845555E+00, 1.1619770760E+01, 3.3291233688E+00, 9.3960259827E-01],
	[2.9515000000E+04, 2.8518348377E+01, 5.5789879175E+00, 1.1626206545E+01, 3.3297626875E+00, 9.3963517115E-01],
	[2.9520000000E+04, 2.8526419662E+01, 5.5789912788E+00, 1.1632644802E+01, 3.3304018198E+00, 9.3966772540E-01],
	[2.9525000000E+04, 2.8534491864E+01, 5.5789946397E+00, 1.1639085533E+01, 3.3310407656E+00, 9.3970026104E-01],
	[2.9530000000E+04, 2.8542564983E+01, 5.5789979999E+00, 1.1645528738E+01, 3.3316795251E+00, 9.3973277807E-01],
	[2.9535000000E+04, 2.8550639018E+01, 5.5790013596E+00, 1.1651974417E+01, 3.3323180983E+00, 9.3976527652E-01],
	[2.9540000000E+04, 2.8558713970E+01, 5.5790047187E+00, 1.1658422570E+01, 3.3329564851E+00, 9.3979775638E-01],
	[2.9545000000E+04, 2.8566789839E+01, 5.5790080772E+00, 1.1664873199E+01, 3.3335946856E+00, 9.3983021768E-01],
	[2.9550000000E+04, 2.8574866624E+01, 5.5790114352E+00, 1.1671326304E+01, 3.3342326998E+00, 9.3986266041E-01],
	[2.9555000000E+04, 2.8582944325E+01, 5.5790147926E+00, 1.1677781885E+01, 3.3348705277E+00, 9.3989508460E-01],
	[2.9560000000E+04, 2.8591022943E+01, 5.5790181495E+00, 1.1684239943E+01, 3.3355081693E+00, 9.3992749025E-01],
	[2.9565000000E+04, 2.8599102478E+01, 5.5790215057E+00, 1.1690700479E+01, 3.3361456247E+00, 9.3995987737E-01],
	[2.9570000000E+04, 2.8607182929E+01, 5.5790248614E+00, 1.1697163492E+01, 3.3367828938E+00, 9.3999224598E-01],
	[2.9575000000E+04, 2.8615264296E+01, 5.5790282166E+00, 1.1703628984E+01, 3.3374199767E+00, 9.4002459608E-01],
	[2.9580000000E+04, 2.8623346579E+01, 5.5790315712E+00, 1.1710096955E+01, 3.3380568734E+00, 9.4005692769E-01],
	[2.9585000000E+04, 2.8631429778E+01, 5.5790349252E+00, 1.1716567406E+01, 3.3386935839E+00, 9.4008924081E-01],
	[2.9590000000E+04, 2.8639513894E+01, 5.5790382786E+00, 1.1723040337E+01, 3.3393301082E+00, 9.4012153545E-01],
	[2.9595000000E+04, 2.8647598925E+01, 5.5790416315E+00, 1.1729515748E+01, 3.3399664464E+00, 9.4015381164E-01],
	[2.9600000000E+04, 2.8655684873E+01, 5.5790449839E+00, 1.1735993640E+01, 3.3406025984E+00, 9.4018606937E-01],
	[2.9605000000E+04, 2.8663771737E+01, 5.5790483356E+00, 1.1742474015E+01, 3.3412385643E+00, 9.4021830866E-01],
	[2.9610000000E+04, 2.8671859516E+01, 5.5790516868E+00, 1.1748956871E+01, 3.3418743441E+00, 9.4025052952E-01],
	[2.9615000000E+04, 2.8679948212E+01, 5.5790550374E+00, 1.1755442210E+01, 3.3425099379E+00, 9.4028273196E-01],
	[2.9620000000E+04, 2.8688037823E+01, 5.5790583875E+00, 1.1761930033E+01, 3.3431453455E+00, 9.4031491599E-01],
	[2.9625000000E+04, 2.8696128350E+01, 5.5790617370E+00, 1.1768420339E+01, 3.3437805671E+00, 9.4034708162E-01],
	[2.9630000000E+04, 2.8704219793E+01, 5.5790650860E+00, 1.1774913130E+01, 3.3444156026E+00, 9.4037922886E-01],
	[2.9635000000E+04, 2.8712312151E+01, 5.5790684343E+00, 1.1781408405E+01, 3.3450504521E+00, 9.4041135773E-01],
	[2.9640000000E+04, 2.8720405425E+01, 5.5790717821E+00, 1.1787906166E+01, 3.3456851157E+00, 9.4044346822E-01],
	[2.9645000000E+04, 2.8728499614E+01, 5.5790751294E+00, 1.1794406413E+01, 3.3463195932E+00, 9.4047556036E-01],
	[2.9650000000E+04, 2.8736594719E+01, 5.5790784761E+00, 1.1800909146E+01, 3.3469538847E+00, 9.4050763416E-01],
	[2.9655000000E+04, 2.8744690740E+01, 5.5790818222E+00, 1.1807414367E+01, 3.3475879903E+00, 9.4053968962E-01],
	[2.9660000000E+04, 2.8752787676E+01, 5.5790851678E+00, 1.1813922075E+01, 3.3482219100E+00, 9.4057172676E-01],
	[2.9665000000E+04, 2.8760885527E+01, 5.5790885128E+00, 1.1820432271E+01, 3.3488556438E+00, 9.4060374558E-01],
	[2.9670000000E+04, 2.8768984294E+01, 5.5790918572E+00, 1.1826944955E+01, 3.3494891916E+00, 9.4063574610E-01],
	[2.9675000000E+04, 2.8777083976E+01, 5.5790952011E+00, 1.1833460129E+01, 3.3501225536E+00, 9.4066772833E-01],
	[2.9680000000E+04, 2.8785184573E+01, 5.5790985444E+00, 1.1839977792E+01, 3.3507557297E+00, 9.4069969227E-01],
	[2.9685000000E+04, 2.8793286085E+01, 5.5791018872E+00, 1.1846497946E+01, 3.3513887199E+00, 9.4073163795E-01],
	[2.9690000000E+04, 2.8801388512E+01, 5.5791052294E+00, 1.1853020590E+01, 3.3520215244E+00, 9.4076356536E-01],
	[2.9695000000E+04, 2.8809491855E+01, 5.5791085710E+00, 1.1859545726E+01, 3.3526541430E+00, 9.4079547453E-01],
	[2.9700000000E+04, 2.8817596112E+01, 5.5791119121E+00, 1.1866073353E+01, 3.3532865758E+00, 9.4082736545E-01],
	[2.9705000000E+04, 2.8825701285E+01, 5.5791152526E+00, 1.1872603472E+01, 3.3539188228E+00, 9.4085923815E-01],
	[2.9710000000E+04, 2.8833807372E+01, 5.5791185926E+00, 1.1879136085E+01, 3.3545508841E+00, 9.4089109263E-01],
	[2.9715000000E+04, 2.8841914374E+01, 5.5791219320E+00, 1.1885671191E+01, 3.3551827596E+00, 9.4092292890E-01],
	[2.9720000000E+04, 2.8850022291E+01, 5.5791252708E+00, 1.1892208790E+01, 3.3558144494E+00, 9.4095474698E-01],
	[2.9725000000E+04, 2.8858131123E+01, 5.5791286091E+00, 1.1898748885E+01, 3.3564459536E+00, 9.4098654687E-01],
	[2.9730000000E+04, 2.8866240869E+01, 5.5791319468E+00, 1.1905291474E+01, 3.3570772720E+00, 9.4101832858E-01],
	[2.9735000000E+04, 2.8874351530E+01, 5.5791352839E+00, 1.1911836558E+01, 3.3577084047E+00, 9.4105009213E-01],
	[2.9740000000E+04, 2.8882463106E+01, 5.5791386205E+00, 1.1918384139E+01, 3.3583393518E+00, 9.4108183752E-01],
	[2.9745000000E+04, 2.8890575596E+01, 5.5791419566E+00, 1.1924934216E+01, 3.3589701133E+00, 9.4111356478E-01],
	[2.9750000000E+04, 2.8898689001E+01, 5.5791452920E+00, 1.1931486791E+01, 3.3596006892E+00, 9.4114527390E-01],
	[2.9755000000E+04, 2.8906803320E+01, 5.5791486270E+00, 1.1938041863E+01, 3.3602310794E+00, 9.4117696489E-01],
	[2.9760000000E+04, 2.8914918553E+01, 5.5791519613E+00, 1.1944599433E+01, 3.3608612841E+00, 9.4120863778E-01],
	[2.9765000000E+04, 2.8923034701E+01, 5.5791552951E+00, 1.1951159502E+01, 3.3614913032E+00, 9.4124029256E-01],
	[2.9770000000E+04, 2.8931151763E+01, 5.5791586284E+00, 1.1957722070E+01, 3.3621211368E+00, 9.4127192926E-01],
	[2.9775000000E+04, 2.8939269740E+01, 5.5791619611E+00, 1.1964287138E+01, 3.3627507849E+00, 9.4130354787E-01],
	[2.9780000000E+04, 2.8947388630E+01, 5.5791652932E+00, 1.1970854706E+01, 3.3633802474E+00, 9.4133514842E-01],
	[2.9785000000E+04, 2.8955508435E+01, 5.5791686248E+00, 1.1977424775E+01, 3.3640095245E+00, 9.4136673091E-01],
	[2.9790000000E+04, 2.8963629154E+01, 5.5791719558E+00, 1.1983997345E+01, 3.3646386161E+00, 9.4139829535E-01],
	[2.9795000000E+04, 2.8971750787E+01, 5.5791752862E+00, 1.1990572417E+01, 3.3652675223E+00, 9.4142984175E-01],
	[2.9800000000E+04, 2.8979873334E+01, 5.5791786161E+00, 1.1997149992E+01, 3.3658962430E+00, 9.4146137013E-01],
	[2.9805000000E+04, 2.8987996795E+01, 5.5791819455E+00, 1.2003730069E+01, 3.3665247783E+00, 9.4149288049E-01],
	[2.9810000000E+04, 2.8996121169E+01, 5.5791852743E+00, 1.2010312650E+01, 3.3671531282E+00, 9.4152437284E-01],
	[2.9815000000E+04, 2.9004246458E+01, 5.5791886025E+00, 1.2016897735E+01, 3.3677812928E+00, 9.4155584720E-01],
	[2.9820000000E+04, 2.9012372660E+01, 5.5791919302E+00, 1.2023485325E+01, 3.3684092720E+00, 9.4158730358E-01],
	[2.9825000000E+04, 2.9020499776E+01, 5.5791952573E+00, 1.2030075420E+01, 3.3690370659E+00, 9.4161874198E-01],
	[2.9830000000E+04, 2.9028627806E+01, 5.5791985839E+00, 1.2036668020E+01, 3.3696646744E+00, 9.4165016242E-01],
	[2.9835000000E+04, 2.9036756749E+01, 5.5792019099E+00, 1.2043263126E+01, 3.3702920977E+00, 9.4168156490E-01],
	[2.9840000000E+04, 2.9044886606E+01, 5.5792052353E+00, 1.2049860739E+01, 3.3709193357E+00, 9.4171294945E-01],
	[2.9845000000E+04, 2.9053017377E+01, 5.5792085602E+00, 1.2056460860E+01, 3.3715463884E+00, 9.4174431606E-01],
	[2.9850000000E+04, 2.9061149061E+01, 5.5792118846E+00, 1.2063063488E+01, 3.3721732559E+00, 9.4177566476E-01],
	[2.9855000000E+04, 2.9069281659E+01, 5.5792152084E+00, 1.2069668624E+01, 3.3727999382E+00, 9.4180699554E-01],
	[2.9860000000E+04, 2.9077415169E+01, 5.5792185316E+00, 1.2076276269E+01, 3.3734264353E+00, 9.4183830842E-01],
	[2.9865000000E+04, 2.9085549594E+01, 5.5792218543E+00, 1.2082886424E+01, 3.3740527472E+00, 9.4186960342E-01],
	[2.9870000000E+04, 2.9093684931E+01, 5.5792251764E+00, 1.2089499088E+01, 3.3746788740E+00, 9.4190088053E-01],
	[2.9875000000E+04, 2.9101821182E+01, 5.5792284980E+00, 1.2096114262E+01, 3.3753048156E+00, 9.4193213978E-01],
	[2.9880000000E+04, 2.9109958346E+01, 5.5792318190E+00, 1.2102731948E+01, 3.3759305721E+00, 9.4196338117E-01],
	[2.9885000000E+04, 2.9118096423E+01, 5.5792351395E+00, 1.2109352145E+01, 3.3765561434E+00, 9.4199460472E-01],
	[2.9890000000E+04, 2.9126235413E+01, 5.5792384594E+00, 1.2115974854E+01, 3.3771815298E+00, 9.4202581043E-01],
	[2.9895000000E+04, 2.9134375316E+01, 5.5792417787E+00, 1.2122600076E+01, 3.3778067310E+00, 9.4205699831E-01],
	[2.9900000000E+04, 2.9142516132E+01, 5.5792450975E+00, 1.2129227810E+01, 3.3784317472E+00, 9.4208816838E-01],
	[2.9905000000E+04, 2.9150657861E+01, 5.5792484158E+00, 1.2135858059E+01, 3.3790565784E+00, 9.4211932064E-01],
	[2.9910000000E+04, 2.9158812822E+01, 5.5792532098E+00, 1.2142490821E+01, 3.3796819318E+00, 9.4215045511E-01],
	[2.9915000000E+04, 2.9166983185E+01, 5.5792597383E+00, 1.2149126098E+01, 3.3803079321E+00, 9.4218157180E-01],
	[2.9920000000E+04, 2.9175154471E+01, 5.5792662658E+00, 1.2155763890E+01, 3.3809337481E+00, 9.4221267071E-01],
	[2.9925000000E+04, 2.9183326680E+01, 5.5792727922E+00, 1.2162404198E+01, 3.3815593798E+00, 9.4224375187E-01],
	[2.9930000000E+04, 2.9191499812E+01, 5.5792793175E+00, 1.2169047022E+01, 3.3821848273E+00, 9.4227481527E-01],
	[2.9935000000E+04, 2.9199673868E+01, 5.5792858417E+00, 1.2175692363E+01, 3.3828100906E+00, 9.4230586093E-01],
	[2.9940000000E+04, 2.9207848847E+01, 5.5792923648E+00, 1.2182340221E+01, 3.3834351697E+00, 9.4233688886E-01],
	[2.9945000000E+04, 2.9216024748E+01, 5.5792988868E+00, 1.2188990598E+01, 3.3840600645E+00, 9.4236789907E-01],
	[2.9950000000E+04, 2.9224201573E+01, 5.5793054078E+00, 1.2195643492E+01, 3.3846847753E+00, 9.4239889157E-01],
	[2.9955000000E+04, 2.9232379321E+01, 5.5793119277E+00, 1.2202298905E+01, 3.3853093018E+00, 9.4242986637E-01],
	[2.9960000000E+04, 2.9240557991E+01, 5.5793184465E+00, 1.2208956838E+01, 3.3859336443E+00, 9.4246082348E-01],
	[2.9965000000E+04, 2.9248737584E+01, 5.5793249642E+00, 1.2215617291E+01, 3.3865578027E+00, 9.4249176291E-01],
	[2.9970000000E+04, 2.9256918101E+01, 5.5793314809E+00, 1.2222280264E+01, 3.3871817769E+00, 9.4252268468E-01],
	[2.9975000000E+04, 2.9265099540E+01, 5.5793379964E+00, 1.2228945759E+01, 3.3878055671E+00, 9.4255358879E-01],
	[2.9980000000E+04, 2.9273281901E+01, 5.5793445109E+00, 1.2235613775E+01, 3.3884291733E+00, 9.4258447526E-01],
	[2.9985000000E+04, 2.9281465186E+01, 5.5793510243E+00, 1.2242284313E+01, 3.3890525954E+00, 9.4261534409E-01],
	[2.9990000000E+04, 2.9289649392E+01, 5.5793575367E+00, 1.2248957374E+01, 3.3896758336E+00, 9.4264619529E-01],
	[2.9995000000E+04, 2.9297834522E+01, 5.5793640479E+00, 1.2255632957E+01, 3.3902988877E+00, 9.4267702888E-01],
	[3.0000000000E+04, 2.9306020574E+01, 5.5793705581E+00, 1.2262311065E+01, 3.3909217579E+00, 9.4270784487E-01],
	[3.0005000000E+04, 2.9314207548E+01, 5.5793770672E+00, 1.2269025423E+01, 3.3915470213E+00, 9.4273864326E-01],
	[3.0010000000E+04, 2.9322395445E+01, 5.5793835752E+00, 1.2275742337E+01, 3.3921720995E+00, 9.4276942407E-01],
	[3.0015000000E+04, 2.9330584264E+01, 5.5793900821E+00, 1.2282461808E+01, 3.3927969924E+00, 9.4280018730E-01],
	[3.0020000000E+04, 2.9338774005E+01, 5.5793965880E+00, 1.2289183836E+01, 3.3934217001E+00, 9.4283093297E-01],
	[3.0025000000E+04, 2.9346964669E+01, 5.5794030928E+00, 1.2295908421E+01, 3.3940462226E+00, 9.4286166110E-01],
	[3.0030000000E+04, 2.9355156255E+01, 5.5794095965E+00, 1.2302635565E+01, 3.3946705599E+00, 9.4289237168E-01],
	[3.0035000000E+04, 2.9363348763E+01, 5.5794160991E+00, 1.2309365268E+01, 3.3952947121E+00, 9.4292306473E-01],
	[3.0040000000E+04, 2.9371542193E+01, 5.5794226007E+00, 1.2316097529E+01, 3.3959186791E+00, 9.4295374026E-01],
	[3.0045000000E+04, 2.9379736545E+01, 5.5794291012E+00, 1.2322832351E+01, 3.3965424610E+00, 9.4298439828E-01],
	[3.0050000000E+04, 2.9387931820E+01, 5.5794356006E+00, 1.2329569733E+01, 3.3971660578E+00, 9.4301503880E-01],
	[3.0055000000E+04, 2.9396128016E+01, 5.5794420990E+00, 1.2336309676E+01, 3.3977894695E+00, 9.4304566183E-01],
	[3.0060000000E+04, 2.9404325134E+01, 5.5794485962E+00, 1.2343052180E+01, 3.3984126961E+00, 9.4307626739E-01],
	[3.0065000000E+04, 2.9412523174E+01, 5.5794550924E+00, 1.2349797246E+01, 3.3990357377E+00, 9.4310685548E-01],
	[3.0070000000E+04, 2.9420722135E+01, 5.5794615875E+00, 1.2356544875E+01, 3.3996585943E+00, 9.4313742611E-01],
	[3.0075000000E+04, 2.9428922019E+01, 5.5794680816E+00, 1.2363295067E+01, 3.4002812659E+00, 9.4316797929E-01],
	[3.0080000000E+04, 2.9437122824E+01, 5.5794745746E+00, 1.2370047823E+01, 3.4009037525E+00, 9.4319851504E-01],
	[3.0085000000E+04, 2.9445324551E+01, 5.5794810665E+00, 1.2376803143E+01, 3.4015260542E+00, 9.4322903336E-01],
	[3.0090000000E+04, 2.9453527199E+01, 5.5794875573E+00, 1.2383561027E+01, 3.4021481709E+00, 9.4325953426E-01],
	[3.0095000000E+04, 2.9461730769E+01, 5.5794940471E+00, 1.2390321477E+01, 3.4027701027E+00, 9.4329001777E-01],
	[3.0100000000E+04, 2.9469935261E+01, 5.5795005358E+00, 1.2397084493E+01, 3.4033918497E+00, 9.4332048387E-01],
	[3.0105000000E+04, 2.9478140673E+01, 5.5795070234E+00, 1.2403850075E+01, 3.4040134117E+00, 9.4335093260E-01],
	[3.0110000000E+04, 2.9486347008E+01, 5.5795135099E+00, 1.2410618224E+01, 3.4046347890E+00, 9.4338136395E-01],
	[3.0115000000E+04, 2.9494554263E+01, 5.5795199954E+00, 1.2417388941E+01, 3.4052559814E+00, 9.4341177793E-01],
	[3.0120000000E+04, 2.9502762440E+01, 5.5795264798E+00, 1.2424162226E+01, 3.4058769890E+00, 9.4344217456E-01],
	[3.0125000000E+04, 2.9510971539E+01, 5.5795329632E+00, 1.2430938079E+01, 3.4064978118E+00, 9.4347255385E-01],
	[3.0130000000E+04, 2.9519181558E+01, 5.5795394455E+00, 1.2437716501E+01, 3.4071184498E+00, 9.4350291580E-01],
	[3.0135000000E+04, 2.9527392499E+01, 5.5795459267E+00, 1.2444497493E+01, 3.4077389031E+00, 9.4353326043E-01],
	[3.0140000000E+04, 2.9535604360E+01, 5.5795524068E+00, 1.2451281055E+01, 3.4083591717E+00, 9.4356358773E-01],
	[3.0145000000E+04, 2.9543817143E+01, 5.5795588859E+00, 1.2458067188E+01, 3.4089792556E+00, 9.4359389773E-01],
	[3.0150000000E+04, 2.9552030847E+01, 5.5795653639E+00, 1.2464855893E+01, 3.4095991549E+00, 9.4362419043E-01],
	[3.0155000000E+04, 2.9560245472E+01, 5.5795718408E+00, 1.2471647169E+01, 3.4102188695E+00, 9.4365446584E-01],
	[3.0160000000E+04, 2.9568461017E+01, 5.5795783167E+00, 1.2478441018E+01, 3.4108383994E+00, 9.4368472396E-01],
	[3.0165000000E+04, 2.9576677484E+01, 5.5795847915E+00, 1.2485237439E+01, 3.4114577448E+00, 9.4371496482E-01],
	[3.0170000000E+04, 2.9584894871E+01, 5.5795912653E+00, 1.2492036434E+01, 3.4120769055E+00, 9.4374518841E-01],
	[3.0175000000E+04, 2.9593113179E+01, 5.5795977379E+00, 1.2498838003E+01, 3.4126958817E+00, 9.4377539475E-01],
	[3.0180000000E+04, 2.9601332408E+01, 5.5796042096E+00, 1.2505642147E+01, 3.4133146734E+00, 9.4380558385E-01],
	[3.0185000000E+04, 2.9609552558E+01, 5.5796106801E+00, 1.2512448866E+01, 3.4139332805E+00, 9.4383575571E-01],
	[3.0190000000E+04, 2.9617773628E+01, 5.5796171496E+00, 1.2519258160E+01, 3.4145517032E+00, 9.4386591035E-01],
	[3.0195000000E+04, 2.9625995618E+01, 5.5796236180E+00, 1.2526070031E+01, 3.4151699413E+00, 9.4389604777E-01],
	[3.0200000000E+04, 2.9634218529E+01, 5.5796300854E+00, 1.2532884479E+01, 3.4157879950E+00, 9.4392616798E-01],
	[3.0205000000E+04, 2.9642442361E+01, 5.5796365517E+00, 1.2539701504E+01, 3.4164058643E+00, 9.4395627099E-01],
	[3.0210000000E+04, 2.9650667113E+01, 5.5796430169E+00, 1.2546521106E+01, 3.4170235492E+00, 9.4398635682E-01],
	[3.0215000000E+04, 2.9658892786E+01, 5.5796494811E+00, 1.2553343288E+01, 3.4176410497E+00, 9.4401642547E-01],
	[3.0220000000E+04, 2.9667119378E+01, 5.5796559442E+00, 1.2560168048E+01, 3.4182583659E+00, 9.4404647695E-01],
	[3.0225000000E+04, 2.9675346891E+01, 5.5796624062E+00, 1.2566995388E+01, 3.4188754977E+00, 9.4407651126E-01],
	[3.0230000000E+04, 2.9683575324E+01, 5.5796688672E+00, 1.2573825307E+01, 3.4194924452E+00, 9.4410652843E-01],
	[3.0235000000E+04, 2.9691804678E+01, 5.5796753271E+00, 1.2580657808E+01, 3.4201092083E+00, 9.4413652845E-01],
	[3.0240000000E+04, 2.9700034951E+01, 5.5796817860E+00, 1.2587492889E+01, 3.4207257873E+00, 9.4416651134E-01],
	[3.0245000000E+04, 2.9708266145E+01, 5.5796882438E+00, 1.2594330553E+01, 3.4213421819E+00, 9.4419647711E-01],
	[3.0250000000E+04, 2.9716498259E+01, 5.5796947005E+00, 1.2601170798E+01, 3.4219583924E+00, 9.4422642576E-01],
	[3.0255000000E+04, 2.9724731292E+01, 5.5797011562E+00, 1.2608013627E+01, 3.4225744186E+00, 9.4425635730E-01],
	[3.0260000000E+04, 2.9732965246E+01, 5.5797076108E+00, 1.2614859039E+01, 3.4231902607E+00, 9.4428627175E-01],
	[3.0265000000E+04, 2.9741200119E+01, 5.5797140644E+00, 1.2621707034E+01, 3.4238059186E+00, 9.4431616912E-01],
	[3.0270000000E+04, 2.9749435912E+01, 5.5797205169E+00, 1.2628557614E+01, 3.4244213924E+00, 9.4434604940E-01],
	[3.0275000000E+04, 2.9757672625E+01, 5.5797269683E+00, 1.2635410779E+01, 3.4250366820E+00, 9.4437591262E-01],
	[3.0280000000E+04, 2.9765910258E+01, 5.5797334187E+00, 1.2642266530E+01, 3.4256517876E+00, 9.4440575878E-01],
	[3.0285000000E+04, 2.9774148810E+01, 5.5797398680E+00, 1.2649124867E+01, 3.4262667091E+00, 9.4443558788E-01],
	[3.0290000000E+04, 2.9782388282E+01, 5.5797463163E+00, 1.2655985790E+01, 3.4268814466E+00, 9.4446539995E-01],
	[3.0295000000E+04, 2.9790628674E+01, 5.5797527635E+00, 1.2662849301E+01, 3.4274960001E+00, 9.4449519499E-01],
	[3.0300000000E+04, 2.9798869985E+01, 5.5797592097E+00, 1.2669715399E+01, 3.4281103695E+00, 9.4452497300E-01],
	[3.0305000000E+04, 2.9807112215E+01, 5.5797656548E+00, 1.2676584086E+01, 3.4287245550E+00, 9.4455473400E-01],
	[3.0310000000E+04, 2.9815355366E+01, 5.5797720988E+00, 1.2683455361E+01, 3.4293385566E+00, 9.4458447800E-01],
	[3.0315000000E+04, 2.9823599435E+01, 5.5797785418E+00, 1.2690329226E+01, 3.4299523742E+00, 9.4461420501E-01],
	[3.0320000000E+04, 2.9831844424E+01, 5.5797849838E+00, 1.2697205681E+01, 3.4305660079E+00, 9.4464391502E-01],
	[3.0325000000E+04, 2.9840090332E+01, 5.5797914247E+00, 1.2704084726E+01, 3.4311794577E+00, 9.4467360807E-01],
	[3.0330000000E+04, 2.9848337159E+01, 5.5797978645E+00, 1.2710966363E+01, 3.4317927237E+00, 9.4470328414E-01],
	[3.0335000000E+04, 2.9856584905E+01, 5.5798043033E+00, 1.2717850590E+01, 3.4324058059E+00, 9.4473294326E-01],
	[3.0340000000E+04, 2.9864833571E+01, 5.5798107410E+00, 1.2724737410E+01, 3.4330187042E+00, 9.4476258543E-01],
	[3.0345000000E+04, 2.9873083156E+01, 5.5798171776E+00, 1.2731626823E+01, 3.4336314188E+00, 9.4479221067E-01],
	[3.0350000000E+04, 2.9881333659E+01, 5.5798236133E+00, 1.2738518829E+01, 3.4342439496E+00, 9.4482181897E-01],
	[3.0355000000E+04, 2.9889585082E+01, 5.5798300478E+00, 1.2745413429E+01, 3.4348562967E+00, 9.4485141035E-01],
	[3.0360000000E+04, 2.9897837424E+01, 5.5798364813E+00, 1.2752310623E+01, 3.4354684600E+00, 9.4488098482E-01],
	[3.0365000000E+04, 2.9906090684E+01, 5.5798429138E+00, 1.2759210412E+01, 3.4360804397E+00, 9.4491054239E-01],
	[3.0370000000E+04, 2.9914344864E+01, 5.5798493452E+00, 1.2766112796E+01, 3.4366922357E+00, 9.4494008307E-01],
	[3.0375000000E+04, 2.9922599962E+01, 5.5798557755E+00, 1.2773017776E+01, 3.4373038481E+00, 9.4496960686E-01],
	[3.0380000000E+04, 2.9930855979E+01, 5.5798622048E+00, 1.2779925353E+01, 3.4379152768E+00, 9.4499911378E-01],
	[3.0385000000E+04, 2.9939112914E+01, 5.5798686331E+00, 1.2786835527E+01, 3.4385265220E+00, 9.4502860384E-01],
	[3.0390000000E+04, 2.9947375148E+01, 5.5798755788E+00, 1.2793748298E+01, 3.4391378383E+00, 9.4505807704E-01],
	[3.0395000000E+04, 2.9955660468E+01, 5.5798851472E+00, 1.2800663668E+01, 3.4397502606E+00, 9.4508753339E-01],
	[3.0400000000E+04, 2.9963946718E+01, 5.5798947141E+00, 1.2807581636E+01, 3.4403625000E+00, 9.4511697291E-01],
	[3.0405000000E+04, 2.9972233896E+01, 5.5799042795E+00, 1.2814502204E+01, 3.4409745566E+00, 9.4514639560E-01],
	[3.0410000000E+04, 2.9980522003E+01, 5.5799138433E+00, 1.2821425371E+01, 3.4415864303E+00, 9.4517580147E-01],
	[3.0415000000E+04, 2.9988811039E+01, 5.5799234055E+00, 1.2828351139E+01, 3.4421981213E+00, 9.4520519053E-01],
	[3.0420000000E+04, 2.9997101003E+01, 5.5799329661E+00, 1.2835279507E+01, 3.4428096294E+00, 9.4523456279E-01],
	[3.0425000000E+04, 3.0005391896E+01, 5.5799425253E+00, 1.2842210477E+01, 3.4434209548E+00, 9.4526391826E-01],
	[3.0430000000E+04, 3.0013683718E+01, 5.5799520828E+00, 1.2849144049E+01, 3.4440320975E+00, 9.4529325695E-01],
	[3.0435000000E+04, 3.0021976468E+01, 5.5799616388E+00, 1.2856080224E+01, 3.4446430575E+00, 9.4532257887E-01],
	[3.0440000000E+04, 3.0030270146E+01, 5.5799711933E+00, 1.2863019002E+01, 3.4452538348E+00, 9.4535188402E-01],
	[3.0445000000E+04, 3.0038564753E+01, 5.5799807462E+00, 1.2869960383E+01, 3.4458644294E+00, 9.4538117243E-01],
	[3.0450000000E+04, 3.0046860288E+01, 5.5799902975E+00, 1.2876904368E+01, 3.4464748414E+00, 9.4541044408E-01],
	[3.0455000000E+04, 3.0055156752E+01, 5.5799998473E+00, 1.2883850959E+01, 3.4470850708E+00, 9.4543969901E-01],
	[3.0460000000E+04, 3.0063454144E+01, 5.5800093955E+00, 1.2890800154E+01, 3.4476951176E+00, 9.4546893720E-01],
	[3.0465000000E+04, 3.0071752464E+01, 5.5800189422E+00, 1.2897751956E+01, 3.4483049819E+00, 9.4549815868E-01],
	[3.0470000000E+04, 3.0080051712E+01, 5.5800284874E+00, 1.2904706363E+01, 3.4489146636E+00, 9.4552736345E-01],
	[3.0475000000E+04, 3.0088351888E+01, 5.5800380310E+00, 1.2911663378E+01, 3.4495241628E+00, 9.4555655153E-01],
	[3.0480000000E+04, 3.0096652992E+01, 5.5800475730E+00, 1.2918623000E+01, 3.4501334795E+00, 9.4558572291E-01],
	[3.0485000000E+04, 3.0104955025E+01, 5.5800571135E+00, 1.2925585230E+01, 3.4507426138E+00, 9.4561487762E-01],
	[3.0490000000E+04, 3.0113257985E+01, 5.5800666524E+00, 1.2932550069E+01, 3.4513515656E+00, 9.4564401566E-01],
	[3.0495000000E+04, 3.0121561874E+01, 5.5800761898E+00, 1.2939517517E+01, 3.4519603351E+00, 9.4567313703E-01],
	[3.0500000000E+04, 3.0129866690E+01, 5.5800857257E+00, 1.2946487575E+01, 3.4525689221E+00, 9.4570224176E-01],
	[3.0505000000E+04, 3.0138172434E+01, 5.5800952600E+00, 1.2953460243E+01, 3.4531773267E+00, 9.4573132984E-01],
	[3.0510000000E+04, 3.0146479105E+01, 5.5801047927E+00, 1.2960435521E+01, 3.4537855491E+00, 9.4576040129E-01],
	[3.0515000000E+04, 3.0154786705E+01, 5.5801143240E+00, 1.2967413411E+01, 3.4543935891E+00, 9.4578945611E-01],
	[3.0520000000E+04, 3.0163095232E+01, 5.5801238536E+00, 1.2974393913E+01, 3.4550014468E+00, 9.4581849432E-01],
	[3.0525000000E+04, 3.0171404687E+01, 5.5801333817E+00, 1.2981377027E+01, 3.4556091223E+00, 9.4584751593E-01],
	[3.0530000000E+04, 3.0179715069E+01, 5.5801429083E+00, 1.2988362754E+01, 3.4562166155E+00, 9.4587652094E-01],
	[3.0535000000E+04, 3.0188026379E+01, 5.5801524333E+00, 1.2995351095E+01, 3.4568239265E+00, 9.4590550936E-01],
	[3.0540000000E+04, 3.0196338616E+01, 5.5801619568E+00, 1.3002342050E+01, 3.4574310553E+00, 9.4593448120E-01],
	[3.0545000000E+04, 3.0204651781E+01, 5.5801714788E+00, 1.3009335619E+01, 3.4580380020E+00, 9.4596343648E-01],
	[3.0550000000E+04, 3.0212965873E+01, 5.5801809992E+00, 1.3016331804E+01, 3.4586447665E+00, 9.4599237520E-01],
	[3.0555000000E+04, 3.0221280893E+01, 5.5801905180E+00, 1.3023330604E+01, 3.4592513489E+00, 9.4602129736E-01],
	[3.0560000000E+04, 3.0229596840E+01, 5.5802000354E+00, 1.3030332021E+01, 3.4598577492E+00, 9.4605020299E-01],
	[3.0565000000E+04, 3.0237913714E+01, 5.5802095511E+00, 1.3037336054E+01, 3.4604639675E+00, 9.4607909209E-01],
	[3.0570000000E+04, 3.0246231515E+01, 5.5802190654E+00, 1.3044342705E+01, 3.4610700037E+00, 9.4610796466E-01],
	[3.0575000000E+04, 3.0254550244E+01, 5.5802285781E+00, 1.3051351974E+01, 3.4616758579E+00, 9.4613682072E-01],
	[3.0580000000E+04, 3.0262869899E+01, 5.5802380892E+00, 1.3058363861E+01, 3.4622815301E+00, 9.4616566028E-01],
	[3.0585000000E+04, 3.0271190482E+01, 5.5802475989E+00, 1.3065378367E+01, 3.4628870204E+00, 9.4619448335E-01],
	[3.0590000000E+04, 3.0279511991E+01, 5.5802571069E+00, 1.3072395493E+01, 3.4634923287E+00, 9.4622328992E-01],
	[3.0595000000E+04, 3.0287834428E+01, 5.5802666135E+00, 1.3079415238E+01, 3.4640974551E+00, 9.4625208003E-01],
	[3.0600000000E+04, 3.0296157791E+01, 5.5802761185E+00, 1.3086437605E+01, 3.4647023996E+00, 9.4628085366E-01],
	[3.0605000000E+04, 3.0304482082E+01, 5.5802856220E+00, 1.3093462593E+01, 3.4653071623E+00, 9.4630961084E-01],
	[3.0610000000E+04, 3.0312807299E+01, 5.5802951239E+00, 1.3100490202E+01, 3.4659117431E+00, 9.4633835158E-01],
	[3.0615000000E+04, 3.0321133443E+01, 5.5803046243E+00, 1.3107520434E+01, 3.4665161421E+00, 9.4636707587E-01],
	[3.0620000000E+04, 3.0329460513E+01, 5.5803141232E+00, 1.3114553289E+01, 3.4671203593E+00, 9.4639578373E-01],
	[3.0625000000E+04, 3.0337788510E+01, 5.5803236205E+00, 1.3121588767E+01, 3.4677243948E+00, 9.4642447518E-01],
	[3.0630000000E+04, 3.0346117434E+01, 5.5803331163E+00, 1.3128626869E+01, 3.4683282485E+00, 9.4645315021E-01],
	[3.0635000000E+04, 3.0354447285E+01, 5.5803426105E+00, 1.3135667595E+01, 3.4689319206E+00, 9.4648180884E-01],
	[3.0640000000E+04, 3.0362778062E+01, 5.5803521033E+00, 1.3142710947E+01, 3.4695354109E+00, 9.4651045108E-01],
	[3.0645000000E+04, 3.0371109765E+01, 5.5803615945E+00, 1.3149756924E+01, 3.4701387196E+00, 9.4653907694E-01],
	[3.0650000000E+04, 3.0379442395E+01, 5.5803710841E+00, 1.3156805527E+01, 3.4707418467E+00, 9.4656768642E-01],
	[3.0655000000E+04, 3.0387775951E+01, 5.5803805723E+00, 1.3163856757E+01, 3.4713447922E+00, 9.4659627954E-01],
	[3.0660000000E+04, 3.0396110434E+01, 5.5803900589E+00, 1.3170910615E+01, 3.4719475561E+00, 9.4662485630E-01],
	[3.0665000000E+04, 3.0404445843E+01, 5.5803995439E+00, 1.3177967100E+01, 3.4725501384E+00, 9.4665341672E-01],
	[3.0670000000E+04, 3.0412782178E+01, 5.5804090275E+00, 1.3185026213E+01, 3.4731525392E+00, 9.4668196080E-01],
	[3.0675000000E+04, 3.0421119439E+01, 5.5804185095E+00, 1.3192087955E+01, 3.4737547586E+00, 9.4671048856E-01],
	[3.0680000000E+04, 3.0429457626E+01, 5.5804279900E+00, 1.3199152327E+01, 3.4743567964E+00, 9.4673899999E-01],
	[3.0685000000E+04, 3.0437796740E+01, 5.5804374689E+00, 1.3206219329E+01, 3.4749586528E+00, 9.4676749512E-01],
	[3.0690000000E+04, 3.0446136779E+01, 5.5804469463E+00, 1.3213288962E+01, 3.4755603278E+00, 9.4679597394E-01],
	[3.0695000000E+04, 3.0454477745E+01, 5.5804564222E+00, 1.3220361225E+01, 3.4761618214E+00, 9.4682443648E-01],
	[3.0700000000E+04, 3.0462819636E+01, 5.5804658966E+00, 1.3227436120E+01, 3.4767631336E+00, 9.4685288273E-01],
	[3.0705000000E+04, 3.0471162453E+01, 5.5804753694E+00, 1.3234513648E+01, 3.4773642645E+00, 9.4688131271E-01],
	[3.0710000000E+04, 3.0479506197E+01, 5.5804848407E+00, 1.3241593808E+01, 3.4779652141E+00, 9.4690972643E-01],
	[3.0715000000E+04, 3.0487850866E+01, 5.5804943105E+00, 1.3248676601E+01, 3.4785659824E+00, 9.4693812390E-01],
	[3.0720000000E+04, 3.0496196460E+01, 5.5805037788E+00, 1.3255762028E+01, 3.4791665694E+00, 9.4696650512E-01],
	[3.0725000000E+04, 3.0504542981E+01, 5.5805132455E+00, 1.3262850090E+01, 3.4797669752E+00, 9.4699487011E-01],
	[3.0730000000E+04, 3.0512890427E+01, 5.5805227107E+00, 1.3269940787E+01, 3.4803671997E+00, 9.4702321887E-01],
	[3.0735000000E+04, 3.0521238799E+01, 5.5805321744E+00, 1.3277034119E+01, 3.4809672431E+00, 9.4705155141E-01],
	[3.0740000000E+04, 3.0529588096E+01, 5.5805416366E+00, 1.3284130087E+01, 3.4815671054E+00, 9.4707986775E-01],
	[3.0745000000E+04, 3.0537938319E+01, 5.5805510972E+00, 1.3291228692E+01, 3.4821667865E+00, 9.4710816789E-01],
	[3.0750000000E+04, 3.0546289467E+01, 5.5805605564E+00, 1.3298329934E+01, 3.4827662865E+00, 9.4713645184E-01],
	[3.0755000000E+04, 3.0554641540E+01, 5.5805700140E+00, 1.3305433814E+01, 3.4833656054E+00, 9.4716471961E-01],
	[3.0760000000E+04, 3.0562994539E+01, 5.5805794700E+00, 1.3312540331E+01, 3.4839647433E+00, 9.4719297121E-01],
	[3.0765000000E+04, 3.0571348464E+01, 5.5805889246E+00, 1.3319649488E+01, 3.4845637002E+00, 9.4722120665E-01],
	[3.0770000000E+04, 3.0579703313E+01, 5.5805983776E+00, 1.3326761284E+01, 3.4851624761E+00, 9.4724942594E-01],
	[3.0775000000E+04, 3.0588059088E+01, 5.5806078291E+00, 1.3333875720E+01, 3.4857610710E+00, 9.4727762909E-01],
	[3.0780000000E+04, 3.0596415788E+01, 5.5806172791E+00, 1.3340992797E+01, 3.4863594849E+00, 9.4730581610E-01],
	[3.0785000000E+04, 3.0604773413E+01, 5.5806267276E+00, 1.3348112514E+01, 3.4869577180E+00, 9.4733398699E-01],
	[3.0790000000E+04, 3.0613131963E+01, 5.5806361746E+00, 1.3355234873E+01, 3.4875557701E+00, 9.4736214176E-01],
	[3.0795000000E+04, 3.0621491439E+01, 5.5806456200E+00, 1.3362359874E+01, 3.4881536414E+00, 9.4739028043E-01],
	[3.0800000000E+04, 3.0629851839E+01, 5.5806550639E+00, 1.3369487518E+01, 3.4887513319E+00, 9.4741840300E-01],
	[3.0805000000E+04, 3.0638213164E+01, 5.5806645063E+00, 1.3376617805E+01, 3.4893488416E+00, 9.4744650948E-01],
	[3.0810000000E+04, 3.0646575414E+01, 5.5806739472E+00, 1.3383750736E+01, 3.4899461705E+00, 9.4747459989E-01],
	[3.0815000000E+04, 3.0654938589E+01, 5.5806833866E+00, 1.3390886311E+01, 3.4905433186E+00, 9.4750267423E-01],
	[3.0820000000E+04, 3.0663302689E+01, 5.5806928245E+00, 1.3398024531E+01, 3.4911402860E+00, 9.4753073250E-01],
	[3.0825000000E+04, 3.0671667713E+01, 5.5807022608E+00, 1.3405165396E+01, 3.4917370727E+00, 9.4755877473E-01],
	[3.0830000000E+04, 3.0680033662E+01, 5.5807116956E+00, 1.3412308908E+01, 3.4923336788E+00, 9.4758680092E-01],
	[3.0835000000E+04, 3.0688400536E+01, 5.5807211289E+00, 1.3419455066E+01, 3.4929301042E+00, 9.4761481107E-01],
	[3.0840000000E+04, 3.0696768334E+01, 5.5807305607E+00, 1.3426603870E+01, 3.4935263490E+00, 9.4764280521E-01],
	[3.0845000000E+04, 3.0705137057E+01, 5.5807399910E+00, 1.3433755323E+01, 3.4941224132E+00, 9.4767078333E-01],
	[3.0850000000E+04, 3.0713506705E+01, 5.5807494198E+00, 1.3440909424E+01, 3.4947182969E+00, 9.4769874544E-01],
	[3.0855000000E+04, 3.0721877276E+01, 5.5807588471E+00, 1.3448066173E+01, 3.4953140000E+00, 9.4772669156E-01],
	[3.0860000000E+04, 3.0730248773E+01, 5.5807682728E+00, 1.3455225572E+01, 3.4959095226E+00, 9.4775462170E-01],
	[3.0865000000E+04, 3.0738621193E+01, 5.5807776971E+00, 1.3462387620E+01, 3.4965048647E+00, 9.4778253586E-01],
	[3.0870000000E+04, 3.0746994538E+01, 5.5807871198E+00, 1.3469552319E+01, 3.4971000264E+00, 9.4781043405E-01],
	[3.0875000000E+04, 3.0755368808E+01, 5.5807965410E+00, 1.3476719669E+01, 3.4976950077E+00, 9.4783831628E-01],
	[3.0880000000E+04, 3.0763752422E+01, 5.5808069442E+00, 1.3483889670E+01, 3.4982903039E+00, 9.4786618256E-01],
	[3.0885000000E+04, 3.0772154852E+01, 5.5808194342E+00, 1.3491062323E+01, 3.4988864721E+00, 9.4789403291E-01],
	[3.0890000000E+04, 3.0780558215E+01, 5.5808319223E+00, 1.3498237629E+01, 3.4994824606E+00, 9.4792186732E-01],
	[3.0895000000E+04, 3.0788962513E+01, 5.5808444084E+00, 1.3505415588E+01, 3.5000782694E+00, 9.4794968582E-01],
	[3.0900000000E+04, 3.0797367745E+01, 5.5808568924E+00, 1.3512596201E+01, 3.5006738986E+00, 9.4797748840E-01],
	[3.0905000000E+04, 3.0805773912E+01, 5.5808693745E+00, 1.3519779468E+01, 3.5012693481E+00, 9.4800527508E-01],
	[3.0910000000E+04, 3.0814181012E+01, 5.5808818546E+00, 1.3526965389E+01, 3.5018646179E+00, 9.4803304586E-01],
	[3.0915000000E+04, 3.0822589046E+01, 5.5808943327E+00, 1.3534153966E+01, 3.5024597082E+00, 9.4806080077E-01],
	[3.0920000000E+04, 3.0830998014E+01, 5.5809068088E+00, 1.3541345199E+01, 3.5030546189E+00, 9.4808853979E-01],
	[3.0925000000E+04, 3.0839407916E+01, 5.5809192829E+00, 1.3548539088E+01, 3.5036493501E+00, 9.4811626295E-01],
	[3.0930000000E+04, 3.0847818752E+01, 5.5809317550E+00, 1.3555735635E+01, 3.5042439018E+00, 9.4814397026E-01],
	[3.0935000000E+04, 3.0856230521E+01, 5.5809442251E+00, 1.3562934838E+01, 3.5048382740E+00, 9.4817166171E-01],
	[3.0940000000E+04, 3.0864643224E+01, 5.5809566933E+00, 1.3570136700E+01, 3.5054324668E+00, 9.4819933733E-01],
	[3.0945000000E+04, 3.0873056861E+01, 5.5809691594E+00, 1.3577341221E+01, 3.5060264801E+00, 9.4822699712E-01],
	[3.0950000000E+04, 3.0881471432E+01, 5.5809816236E+00, 1.3584548400E+01, 3.5066203141E+00, 9.4825464109E-01],
	[3.0955000000E+04, 3.0889886936E+01, 5.5809940858E+00, 1.3591758240E+01, 3.5072139687E+00, 9.4828226925E-01],
	[3.0960000000E+04, 3.0898303374E+01, 5.5810065460E+00, 1.3598970739E+01, 3.5078074439E+00, 9.4830988161E-01],
	[3.0965000000E+04, 3.0906720745E+01, 5.5810190042E+00, 1.3606185900E+01, 3.5084007399E+00, 9.4833747817E-01],
	[3.0970000000E+04, 3.0915139050E+01, 5.5810314604E+00, 1.3613403722E+01, 3.5089938565E+00, 9.4836505895E-01],
	[3.0975000000E+04, 3.0923558288E+01, 5.5810439147E+00, 1.3620624206E+01, 3.5095867939E+00, 9.4839262396E-01],
	[3.0980000000E+04, 3.0931978460E+01, 5.5810563670E+00, 1.3627847352E+01, 3.5101795521E+00, 9.4842017320E-01],
	[3.0985000000E+04, 3.0940399565E+01, 5.5810688172E+00, 1.3635073161E+01, 3.5107721311E+00, 9.4844770669E-01],
	[3.0990000000E+04, 3.0948821603E+01, 5.5810812656E+00, 1.3642301634E+01, 3.5113645309E+00, 9.4847522443E-01],
	[3.0995000000E+04, 3.0957244574E+01, 5.5810937119E+00, 1.3649532772E+01, 3.5119567516E+00, 9.4850272644E-01],
	[3.1000000000E+04, 3.0965668478E+01, 5.5811061562E+00, 1.3656766573E+01, 3.5125487931E+00, 9.4853021272E-01],
	[3.1005000000E+04, 3.0974093316E+01, 5.5811185986E+00, 1.3664003040E+01, 3.5131406556E+00, 9.4855768327E-01],
	[3.1010000000E+04, 3.0982519087E+01, 5.5811310390E+00, 1.3671242173E+01, 3.5137323390E+00, 9.4858513812E-01],
	[3.1015000000E+04, 3.0990945790E+01, 5.5811434774E+00, 1.3678483973E+01, 3.5143238434E+00, 9.4861257727E-01],
	[3.1020000000E+04, 3.0999373427E+01, 5.5811559138E+00, 1.3685728439E+01, 3.5149151688E+00, 9.4864000073E-01],
	[3.1025000000E+04, 3.1007801997E+01, 5.5811683483E+00, 1.3692975572E+01, 3.5155063152E+00, 9.4866740850E-01],
	[3.1030000000E+04, 3.1016231499E+01, 5.5811807808E+00, 1.3700225374E+01, 3.5160972827E+00, 9.4869480060E-01],
	[3.1035000000E+04, 3.1024661935E+01, 5.5811932113E+00, 1.3707477844E+01, 3.5166880713E+00, 9.4872217704E-01],
	[3.1040000000E+04, 3.1033093303E+01, 5.5812056398E+00, 1.3714732983E+01, 3.5172786809E+00, 9.4874953783E-01],
	[3.1045000000E+04, 3.1041525604E+01, 5.5812180663E+00, 1.3721990792E+01, 3.5178691118E+00, 9.4877688297E-01],
	[3.1050000000E+04, 3.1049958837E+01, 5.5812304909E+00, 1.3729251271E+01, 3.5184593638E+00, 9.4880421247E-01],
	[3.1055000000E+04, 3.1058393003E+01, 5.5812429135E+00, 1.3736514421E+01, 3.5190494369E+00, 9.4883152634E-01],
	[3.1060000000E+04, 3.1066828102E+01, 5.5812553342E+00, 1.3743780243E+01, 3.5196393314E+00, 9.4885882460E-01],
	[3.1065000000E+04, 3.1075264134E+01, 5.5812677528E+00, 1.3751048736E+01, 3.5202290471E+00, 9.4888610725E-01],
	[3.1070000000E+04, 3.1083701098E+01, 5.5812801695E+00, 1.3758319901E+01, 3.5208185840E+00, 9.4891337430E-01],
	[3.1075000000E+04, 3.1092138994E+01, 5.5812925842E+00, 1.3765593740E+01, 3.5214079423E+00, 9.4894062576E-01],
	[3.1080000000E+04, 3.1100577823E+01, 5.5813049970E+00, 1.3772870252E+01, 3.5219971219E+00, 9.4896786164E-01],
	[3.1085000000E+04, 3.1109017584E+01, 5.5813174078E+00, 1.3780149438E+01, 3.5225861229E+00, 9.4899508195E-01],
	[3.1090000000E+04, 3.1117458278E+01, 5.5813298166E+00, 1.3787431298E+01, 3.5231749453E+00, 9.4902228669E-01],
	[3.1095000000E+04, 3.1125899903E+01, 5.5813422234E+00, 1.3794715834E+01, 3.5237635892E+00, 9.4904947588E-01],
	[3.1100000000E+04, 3.1134342461E+01, 5.5813546283E+00, 1.3802003046E+01, 3.5243520545E+00, 9.4907664953E-01],
	[3.1105000000E+04, 3.1142785952E+01, 5.5813670312E+00, 1.3809292934E+01, 3.5249403412E+00, 9.4910380764E-01],
	[3.1110000000E+04, 3.1151230374E+01, 5.5813794322E+00, 1.3816585499E+01, 3.5255284495E+00, 9.4913095022E-01],
	[3.1115000000E+04, 3.1159675728E+01, 5.5813918312E+00, 1.3823880741E+01, 3.5261163794E+00, 9.4915807729E-01],
	[3.1120000000E+04, 3.1168122015E+01, 5.5814042282E+00, 1.3831178661E+01, 3.5267041308E+00, 9.4918518885E-01],
	[3.1125000000E+04, 3.1176569233E+01, 5.5814166232E+00, 1.3838479259E+01, 3.5272917038E+00, 9.4921228491E-01],
	[3.1130000000E+04, 3.1185017384E+01, 5.5814290163E+00, 1.3845782537E+01, 3.5278790985E+00, 9.4923936548E-01],
	[3.1135000000E+04, 3.1193466466E+01, 5.5814414075E+00, 1.3853088494E+01, 3.5284663148E+00, 9.4926643057E-01],
	[3.1140000000E+04, 3.1201916480E+01, 5.5814537966E+00, 1.3860397131E+01, 3.5290533529E+00, 9.4929348019E-01],
	[3.1145000000E+04, 3.1210367426E+01, 5.5814661838E+00, 1.3867708449E+01, 3.5296402126E+00, 9.4932051434E-01],
	[3.1150000000E+04, 3.1218819304E+01, 5.5814785691E+00, 1.3875022449E+01, 3.5302268941E+00, 9.4934753305E-01],
	[3.1155000000E+04, 3.1227272113E+01, 5.5814909523E+00, 1.3882339130E+01, 3.5308133974E+00, 9.4937453631E-01],
	[3.1160000000E+04, 3.1235725854E+01, 5.5815033337E+00, 1.3889658493E+01, 3.5313997224E+00, 9.4940152413E-01],
	[3.1165000000E+04, 3.1244180527E+01, 5.5815157130E+00, 1.3896980540E+01, 3.5319858694E+00, 9.4942849653E-01],
	[3.1170000000E+04, 3.1252636131E+01, 5.5815280904E+00, 1.3904305269E+01, 3.5325718382E+00, 9.4945545351E-01],
	[3.1175000000E+04, 3.1261092667E+01, 5.5815404659E+00, 1.3911632683E+01, 3.5331576289E+00, 9.4948239509E-01],
	[3.1180000000E+04, 3.1269550135E+01, 5.5815528394E+00, 1.3918962782E+01, 3.5337432415E+00, 9.4950932126E-01],
	[3.1185000000E+04, 3.1278008533E+01, 5.5815652109E+00, 1.3926295565E+01, 3.5343286761E+00, 9.4953623205E-01],
	[3.1190000000E+04, 3.1286467864E+01, 5.5815775805E+00, 1.3933631034E+01, 3.5349139326E+00, 9.4956312746E-01],
	[3.1195000000E+04, 3.1294928125E+01, 5.5815899481E+00, 1.3940969190E+01, 3.5354990112E+00, 9.4959000750E-01],
	[3.1200000000E+04, 3.1303389318E+01, 5.5816023138E+00, 1.3948310032E+01, 3.5360839118E+00, 9.4961687217E-01],
	[3.1205000000E+04, 3.1311851442E+01, 5.5816146775E+00, 1.3955653562E+01, 3.5366686345E+00, 9.4964372150E-01],
	[3.1210000000E+04, 3.1320314497E+01, 5.5816270392E+00, 1.3962999779E+01, 3.5372531793E+00, 9.4967055547E-01],
	[3.1215000000E+04, 3.1328778483E+01, 5.5816393991E+00, 1.3970348685E+01, 3.5378375463E+00, 9.4969737412E-01],
	[3.1220000000E+04, 3.1337243401E+01, 5.5816517569E+00, 1.3977700280E+01, 3.5384217354E+00, 9.4972417744E-01],
	[3.1225000000E+04, 3.1345709249E+01, 5.5816641128E+00, 1.3985054564E+01, 3.5390057467E+00, 9.4975096544E-01],
	[3.1230000000E+04, 3.1354176029E+01, 5.5816764668E+00, 1.3992411538E+01, 3.5395895802E+00, 9.4977773814E-01],
	[3.1235000000E+04, 3.1362643740E+01, 5.5816888188E+00, 1.3999771203E+01, 3.5401732360E+00, 9.4980449553E-01],
	[3.1240000000E+04, 3.1371112381E+01, 5.5817011688E+00, 1.4007133560E+01, 3.5407567141E+00, 9.4983123764E-01],
	[3.1245000000E+04, 3.1379581953E+01, 5.5817135169E+00, 1.4014498608E+01, 3.5413400145E+00, 9.4985796447E-01],
	[3.1250000000E+04, 3.1388052456E+01, 5.5817258631E+00, 1.4021866348E+01, 3.5419231372E+00, 9.4988467603E-01],
	[3.1255000000E+04, 3.1396523890E+01, 5.5817382073E+00, 1.4029236781E+01, 3.5425060823E+00, 9.4991137233E-01],
	[3.1260000000E+04, 3.1404996255E+01, 5.5817505495E+00, 1.4036609908E+01, 3.5430888498E+00, 9.4993805337E-01],
	[3.1265000000E+04, 3.1413469550E+01, 5.5817628898E+00, 1.4043985728E+01, 3.5436714398E+00, 9.4996471917E-01],
	[3.1270000000E+04, 3.1421943776E+01, 5.5817752282E+00, 1.4051364243E+01, 3.5442538522E+00, 9.4999136974E-01],
	[3.1275000000E+04, 3.1430418933E+01, 5.5817875646E+00, 1.4058745453E+01, 3.5448360871E+00, 9.5001800508E-01],
	[3.1280000000E+04, 3.1438895020E+01, 5.5817998991E+00, 1.4066129359E+01, 3.5454181445E+00, 9.5004462520E-01],
	[3.1285000000E+04, 3.1447372038E+01, 5.5818122316E+00, 1.4073515961E+01, 3.5460000245E+00, 9.5007123012E-01],
	[3.1290000000E+04, 3.1455849986E+01, 5.5818245622E+00, 1.4080905260E+01, 3.5465817271E+00, 9.5009781984E-01],
	[3.1295000000E+04, 3.1464328864E+01, 5.5818368909E+00, 1.4088297256E+01, 3.5471632523E+00, 9.5012439437E-01],
	[3.1300000000E+04, 3.1472808673E+01, 5.5818492176E+00, 1.4095691949E+01, 3.5477446001E+00, 9.5015095372E-01],
	[3.1305000000E+04, 3.1481289412E+01, 5.5818615423E+00, 1.4103089341E+01, 3.5483257706E+00, 9.5017749790E-01],
	[3.1310000000E+04, 3.1489771082E+01, 5.5818738651E+00, 1.4110489433E+01, 3.5489067638E+00, 9.5020402692E-01],
	[3.1315000000E+04, 3.1498253681E+01, 5.5818861860E+00, 1.4117892223E+01, 3.5494875798E+00, 9.5023054079E-01],
	[3.1320000000E+04, 3.1506737211E+01, 5.5818985050E+00, 1.4125297714E+01, 3.5500682185E+00, 9.5025703951E-01],
	[3.1325000000E+04, 3.1515221671E+01, 5.5819108220E+00, 1.4132705905E+01, 3.5506486801E+00, 9.5028352310E-01],
	[3.1330000000E+04, 3.1523707061E+01, 5.5819231370E+00, 1.4140116797E+01, 3.5512289644E+00, 9.5030999156E-01],
	[3.1335000000E+04, 3.1532193381E+01, 5.5819354501E+00, 1.4147530391E+01, 3.5518090716E+00, 9.5033644491E-01],
	[3.1340000000E+04, 3.1540680631E+01, 5.5819477613E+00, 1.4154946687E+01, 3.5523890017E+00, 9.5036288314E-01],
	[3.1345000000E+04, 3.1549168811E+01, 5.5819600706E+00, 1.4162365686E+01, 3.5529687548E+00, 9.5038930628E-01],
	[3.1350000000E+04, 3.1557657921E+01, 5.5819723779E+00, 1.4169787389E+01, 3.5535483308E+00, 9.5041571434E-01],
	[3.1355000000E+04, 3.1566147961E+01, 5.5819846833E+00, 1.4177211795E+01, 3.5541277297E+00, 9.5044210731E-01],
	[3.1360000000E+04, 3.1574638930E+01, 5.5819969867E+00, 1.4184638906E+01, 3.5547069517E+00, 9.5046848521E-01],
	[3.1365000000E+04, 3.1583130829E+01, 5.5820092882E+00, 1.4192068722E+01, 3.5552859967E+00, 9.5049484804E-01],
	[3.1370000000E+04, 3.1591623658E+01, 5.5820215878E+00, 1.4199501243E+01, 3.5558648648E+00, 9.5052119583E-01],
	[3.1375000000E+04, 3.1600117417E+01, 5.5820338854E+00, 1.4206936471E+01, 3.5564435560E+00, 9.5054752857E-01],
	[3.1380000000E+04, 3.1608635566E+01, 5.5820488843E+00, 1.4214374405E+01, 3.5570234651E+00, 9.5057384627E-01],
	[3.1385000000E+04, 3.1617157258E+01, 5.5820641809E+00, 1.4221815046E+01, 3.5576033527E+00, 9.5060014895E-01],
	[3.1390000000E+04, 3.1625679889E+01, 5.5820794750E+00, 1.4229258396E+01, 3.5581830641E+00, 9.5062643662E-01],
	[3.1395000000E+04, 3.1634203460E+01, 5.5820947668E+00, 1.4236704453E+01, 3.5587625993E+00, 9.5065270927E-01],
	[3.1400000000E+04, 3.1642727970E+01, 5.5821100562E+00, 1.4244153220E+01, 3.5593419584E+00, 9.5067896693E-01],
	[3.1405000000E+04, 3.1651253420E+01, 5.5821253432E+00, 1.4251604696E+01, 3.5599211413E+00, 9.5070520960E-01],
	[3.1410000000E+04, 3.1659779808E+01, 5.5821406277E+00, 1.4259058881E+01, 3.5605001481E+00, 9.5073143728E-01],
	[3.1415000000E+04, 3.1668307136E+01, 5.5821559099E+00, 1.4266515778E+01, 3.5610789788E+00, 9.5075765000E-01],
	[3.1420000000E+04, 3.1676835403E+01, 5.5821711898E+00, 1.4273975385E+01, 3.5616576335E+00, 9.5078384775E-01],
	[3.1425000000E+04, 3.1685364609E+01, 5.5821864672E+00, 1.4281437705E+01, 3.5622361122E+00, 9.5081003055E-01],
	[3.1430000000E+04, 3.1693894754E+01, 5.5822017422E+00, 1.4288902736E+01, 3.5628144149E+00, 9.5083619840E-01],
	[3.1435000000E+04, 3.1702425838E+01, 5.5822170149E+00, 1.4296370480E+01, 3.5633925417E+00, 9.5086235132E-01],
	[3.1440000000E+04, 3.1710957861E+01, 5.5822322851E+00, 1.4303840938E+01, 3.5639704925E+00, 9.5088848931E-01],
	[3.1445000000E+04, 3.1719490823E+01, 5.5822475530E+00, 1.4311314109E+01, 3.5645482675E+00, 9.5091461238E-01],
	[3.1450000000E+04, 3.1728024723E+01, 5.5822628185E+00, 1.4318789995E+01, 3.5651258666E+00, 9.5094072054E-01],
	[3.1455000000E+04, 3.1736559563E+01, 5.5822780816E+00, 1.4326268596E+01, 3.5657032899E+00, 9.5096681381E-01],
	[3.1460000000E+04, 3.1745095341E+01, 5.5822933423E+00, 1.4333749912E+01, 3.5662805373E+00, 9.5099289218E-01],
	[3.1465000000E+04, 3.1753632058E+01, 5.5823086006E+00, 1.4341233945E+01, 3.5668576091E+00, 9.5101895568E-01],
	[3.1470000000E+04, 3.1762169713E+01, 5.5823238566E+00, 1.4348720694E+01, 3.5674345051E+00, 9.5104500430E-01],
	[3.1475000000E+04, 3.1770708308E+01, 5.5823391101E+00, 1.4356210160E+01, 3.5680112254E+00, 9.5107103805E-01],
	[3.1480000000E+04, 3.1779247841E+01, 5.5823543613E+00, 1.4363702344E+01, 3.5685877700E+00, 9.5109705696E-01],
	[3.1485000000E+04, 3.1787788312E+01, 5.5823696101E+00, 1.4371197246E+01, 3.5691641390E+00, 9.5112306101E-01],
	[3.1490000000E+04, 3.1796329722E+01, 5.5823848566E+00, 1.4378694867E+01, 3.5697403324E+00, 9.5114905023E-01],
	[3.1495000000E+04, 3.1804872070E+01, 5.5824001006E+00, 1.4386195208E+01, 3.5703163502E+00, 9.5117502462E-01],
	[3.1500000000E+04, 3.1813415357E+01, 5.5824153423E+00, 1.4393698268E+01, 3.5708921925E+00, 9.5120098420E-01],
	[3.1505000000E+04, 3.1821959582E+01, 5.5824305816E+00, 1.4401204050E+01, 3.5714678592E+00, 9.5122692896E-01],
	[3.1510000000E+04, 3.1830504745E+01, 5.5824458185E+00, 1.4408712552E+01, 3.5720433505E+00, 9.5125285892E-01],
	[3.1515000000E+04, 3.1839050846E+01, 5.5824610530E+00, 1.4416223775E+01, 3.5726186663E+00, 9.5127877409E-01],
	[3.1520000000E+04, 3.1847597886E+01, 5.5824762852E+00, 1.4423737721E+01, 3.5731938067E+00, 9.5130467448E-01],
	[3.1525000000E+04, 3.1856145864E+01, 5.5824915150E+00, 1.4431254390E+01, 3.5737687718E+00, 9.5133056010E-01],
	[3.1530000000E+04, 3.1864694780E+01, 5.5825067424E+00, 1.4438773782E+01, 3.5743435614E+00, 9.5135643095E-01],
	[3.1535000000E+04, 3.1873244634E+01, 5.5825219674E+00, 1.4446295898E+01, 3.5749181758E+00, 9.5138228704E-01],
	[3.1540000000E+04, 3.1881795426E+01, 5.5825371901E+00, 1.4453820738E+01, 3.5754926148E+00, 9.5140812839E-01],
	[3.1545000000E+04, 3.1890347156E+01, 5.5825524104E+00, 1.4461348303E+01, 3.5760668786E+00, 9.5143395500E-01],
	[3.1550000000E+04, 3.1898899824E+01, 5.5825676283E+00, 1.4468878594E+01, 3.5766409672E+00, 9.5145976688E-01],
	[3.1555000000E+04, 3.1907453430E+01, 5.5825828439E+00, 1.4476411611E+01, 3.5772148806E+00, 9.5148556404E-01],
	[3.1560000000E+04, 3.1916007974E+01, 5.5825980571E+00, 1.4483947354E+01, 3.5777886188E+00, 9.5151134649E-01],
	[3.1565000000E+04, 3.1924563456E+01, 5.5826132679E+00, 1.4491485825E+01, 3.5783621818E+00, 9.5153711423E-01],
	[3.1570000000E+04, 3.1933119875E+01, 5.5826284763E+00, 1.4499027023E+01, 3.5789355698E+00, 9.5156286729E-01],
	[3.1575000000E+04, 3.1941677232E+01, 5.5826436824E+00, 1.4506570949E+01, 3.5795087827E+00, 9.5158860566E-01],
	[3.1580000000E+04, 3.1950235527E+01, 5.5826588862E+00, 1.4514117605E+01, 3.5800818205E+00, 9.5161432935E-01],
	[3.1585000000E+04, 3.1958794759E+01, 5.5826740875E+00, 1.4521666989E+01, 3.5806546834E+00, 9.5164003838E-01],
	[3.1590000000E+04, 3.1967354929E+01, 5.5826892865E+00, 1.4529219104E+01, 3.5812273712E+00, 9.5166573275E-01],
	[3.1595000000E+04, 3.1975916036E+01, 5.5827044831E+00, 1.4536773949E+01, 3.5817998841E+00, 9.5169141246E-01],
	[3.1600000000E+04, 3.1984478081E+01, 5.5827196774E+00, 1.4544331525E+01, 3.5823722222E+00, 9.5171707754E-01],
	[3.1605000000E+04, 3.1993041063E+01, 5.5827348693E+00, 1.4551891833E+01, 3.5829443853E+00, 9.5174272798E-01],
	[3.1610000000E+04, 3.2001604983E+01, 5.5827500588E+00, 1.4559454873E+01, 3.5835163736E+00, 9.5176836379E-01],
	[3.1615000000E+04, 3.2010169840E+01, 5.5827652460E+00, 1.4567020646E+01, 3.5840881870E+00, 9.5179398499E-01],
	[3.1620000000E+04, 3.2018735634E+01, 5.5827804308E+00, 1.4574589152E+01, 3.5846598257E+00, 9.5181959157E-01],
	[3.1625000000E+04, 3.2027302365E+01, 5.5827956133E+00, 1.4582160392E+01, 3.5852312896E+00, 9.5184518355E-01],
	[3.1630000000E+04, 3.2035870034E+01, 5.5828107934E+00, 1.4589734366E+01, 3.5858025788E+00, 9.5187076093E-01],
	[3.1635000000E+04, 3.2044438640E+01, 5.5828259711E+00, 1.4597311075E+01, 3.5863736934E+00, 9.5189632373E-01],
	[3.1640000000E+04, 3.2053008183E+01, 5.5828411465E+00, 1.4604890519E+01, 3.5869446332E+00, 9.5192187195E-01],
	[3.1645000000E+04, 3.2061578663E+01, 5.5828563195E+00, 1.4612472700E+01, 3.5875153985E+00, 9.5194740559E-01],
	[3.1650000000E+04, 3.2070150080E+01, 5.5828714902E+00, 1.4620057617E+01, 3.5880859891E+00, 9.5197292468E-01],
	[3.1655000000E+04, 3.2078722434E+01, 5.5828866585E+00, 1.4627645272E+01, 3.5886564052E+00, 9.5199842921E-01],
	[3.1660000000E+04, 3.2087295725E+01, 5.5829018244E+00, 1.4635235664E+01, 3.5892266467E+00, 9.5202391919E-01],
	[3.1665000000E+04, 3.2095869953E+01, 5.5829169880E+00, 1.4642828794E+01, 3.5897967138E+00, 9.5204939463E-01],
	[3.1670000000E+04, 3.2104445118E+01, 5.5829321493E+00, 1.4650424663E+01, 3.5903666064E+00, 9.5207485554E-01],
	[3.1675000000E+04, 3.2113021219E+01, 5.5829473082E+00, 1.4658023272E+01, 3.5909363246E+00, 9.5210030192E-01],
	[3.1680000000E+04, 3.2121598257E+01, 5.5829624647E+00, 1.4665624620E+01, 3.5915058683E+00, 9.5212573380E-01],
	[3.1685000000E+04, 3.2130176232E+01, 5.5829776189E+00, 1.4673228709E+01, 3.5920752377E+00, 9.5215115116E-01],
	[3.1690000000E+04, 3.2138755144E+01, 5.5829927708E+00, 1.4680835539E+01, 3.5926444328E+00, 9.5217655402E-01],
	[3.1695000000E+04, 3.2147334992E+01, 5.5830079203E+00, 1.4688445110E+01, 3.5932134536E+00, 9.5220194240E-01],
	[3.1700000000E+04, 3.2155915777E+01, 5.5830230674E+00, 1.4696057424E+01, 3.5937823001E+00, 9.5222731629E-01],
	[3.1705000000E+04, 3.2164497498E+01, 5.5830382122E+00, 1.4703672480E+01, 3.5943509723E+00, 9.5225267570E-01],
	[3.1710000000E+04, 3.2173080156E+01, 5.5830533547E+00, 1.4711290280E+01, 3.5949194704E+00, 9.5227802065E-01],
	[3.1715000000E+04, 3.2181663750E+01, 5.5830684948E+00, 1.4718910823E+01, 3.5954877943E+00, 9.5230335114E-01],
	[3.1720000000E+04, 3.2190248280E+01, 5.5830836325E+00, 1.4726534111E+01, 3.5960559440E+00, 9.5232866717E-01],
	[3.1725000000E+04, 3.2198833747E+01, 5.5830987680E+00, 1.4734160144E+01, 3.5966239196E+00, 9.5235396876E-01],
	[3.1730000000E+04, 3.2207420150E+01, 5.5831139010E+00, 1.4741788922E+01, 3.5971917212E+00, 9.5237925592E-01],
	[3.1735000000E+04, 3.2216007490E+01, 5.5831290318E+00, 1.4749420446E+01, 3.5977593487E+00, 9.5240452865E-01],
	[3.1740000000E+04, 3.2224595765E+01, 5.5831441601E+00, 1.4757054717E+01, 3.5983268022E+00, 9.5242978696E-01],
	[3.1745000000E+04, 3.2233184977E+01, 5.5831592862E+00, 1.4764691735E+01, 3.5988940818E+00, 9.5245503085E-01],
	[3.1750000000E+04, 3.2241775125E+01, 5.5831744099E+00, 1.4772331501E+01, 3.5994611874E+00, 9.5248026035E-01],
	[3.1755000000E+04, 3.2250366209E+01, 5.5831895313E+00, 1.4779974014E+01, 3.6000281191E+00, 9.5250547545E-01],
	[3.1760000000E+04, 3.2258958229E+01, 5.5832046503E+00, 1.4787619277E+01, 3.6005948769E+00, 9.5253067616E-01],
	[3.1765000000E+04, 3.2267551185E+01, 5.5832197670E+00, 1.4795267289E+01, 3.6011614608E+00, 9.5255586249E-01],
	[3.1770000000E+04, 3.2276145076E+01, 5.5832348813E+00, 1.4802918051E+01, 3.6017278710E+00, 9.5258103445E-01],
	[3.1775000000E+04, 3.2284739904E+01, 5.5832499933E+00, 1.4810571563E+01, 3.6022941073E+00, 9.5260619204E-01],
	[3.1780000000E+04, 3.2293335668E+01, 5.5832651030E+00, 1.4818227827E+01, 3.6028601700E+00, 9.5263133528E-01],
	[3.1785000000E+04, 3.2301932367E+01, 5.5832802103E+00, 1.4825886842E+01, 3.6034260589E+00, 9.5265646417E-01],
	[3.1790000000E+04, 3.2310530002E+01, 5.5832953153E+00, 1.4833548609E+01, 3.6039917741E+00, 9.5268157872E-01],
	[3.1795000000E+04, 3.2319128573E+01, 5.5833104180E+00, 1.4841213129E+01, 3.6045573157E+00, 9.5270667894E-01],
	[3.1800000000E+04, 3.2327728079E+01, 5.5833255183E+00, 1.4848880402E+01, 3.6051226836E+00, 9.5273176484E-01],
	[3.1805000000E+04, 3.2336328521E+01, 5.5833406163E+00, 1.4856550429E+01, 3.6056878780E+00, 9.5275683642E-01],
	[3.1810000000E+04, 3.2344929899E+01, 5.5833557120E+00, 1.4864223210E+01, 3.6062528989E+00, 9.5278189369E-01],
	[3.1815000000E+04, 3.2353532212E+01, 5.5833708053E+00, 1.4871898746E+01, 3.6068177462E+00, 9.5280693667E-01],
	[3.1820000000E+04, 3.2362135461E+01, 5.5833858963E+00, 1.4879577038E+01, 3.6073824200E+00, 9.5283196535E-01],
	[3.1825000000E+04, 3.2370739645E+01, 5.5834009850E+00, 1.4887258085E+01, 3.6079469204E+00, 9.5285697974E-01],
	[3.1830000000E+04, 3.2379344764E+01, 5.5834160713E+00, 1.4894941890E+01, 3.6085112474E+00, 9.5288197986E-01],
	[3.1835000000E+04, 3.2387950819E+01, 5.5834311553E+00, 1.4902628451E+01, 3.6090754010E+00, 9.5290696572E-01],
	[3.1840000000E+04, 3.2396557809E+01, 5.5834462370E+00, 1.4910317770E+01, 3.6096393812E+00, 9.5293193731E-01],
	[3.1845000000E+04, 3.2405165734E+01, 5.5834613164E+00, 1.4918009847E+01, 3.6102031882E+00, 9.5295689465E-01],
	[3.1850000000E+04, 3.2413774595E+01, 5.5834763934E+00, 1.4925704683E+01, 3.6107668218E+00, 9.5298183775E-01],
	[3.1855000000E+04, 3.2422384390E+01, 5.5834914681E+00, 1.4933402279E+01, 3.6113302822E+00, 9.5300676661E-01],
	[3.1860000000E+04, 3.2430995121E+01, 5.5835065405E+00, 1.4941102634E+01, 3.6118935694E+00, 9.5303168124E-01],
	[3.1865000000E+04, 3.2439606787E+01, 5.5835216105E+00, 1.4948805750E+01, 3.6124566834E+00, 9.5305658165E-01],
	[3.1870000000E+04, 3.2448219388E+01, 5.5835366783E+00, 1.4956511627E+01, 3.6130196242E+00, 9.5308146785E-01],
	[3.1875000000E+04, 3.2456832923E+01, 5.5835517437E+00, 1.4964220265E+01, 3.6135823919E+00, 9.5310633985E-01],
	[3.1880000000E+04, 3.2465447394E+01, 5.5835668068E+00, 1.4971931666E+01, 3.6141449866E+00, 9.5313119765E-01],
	[3.1885000000E+04, 3.2474085504E+01, 5.5835844498E+00, 1.4979645829E+01, 3.6147087717E+00, 9.5315604126E-01],
	[3.1890000000E+04, 3.2482727669E+01, 5.5836024438E+00, 1.4987362755E+01, 3.6152725711E+00, 9.5318087069E-01],
	[3.1895000000E+04, 3.2491370778E+01, 5.5836204351E+00, 1.4995082446E+01, 3.6158361981E+00, 9.5320568595E-01],
	[3.1900000000E+04, 3.2500014831E+01, 5.5836384236E+00, 1.5002804900E+01, 3.6163996527E+00, 9.5323048704E-01],
	[3.1905000000E+04, 3.2508659829E+01, 5.5836564093E+00, 1.5010530120E+01, 3.6169629349E+00, 9.5325527398E-01],
	[3.1910000000E+04, 3.2517305771E+01, 5.5836743923E+00, 1.5018258105E+01, 3.6175260448E+00, 9.5328004677E-01],
	[3.1915000000E+04, 3.2525952657E+01, 5.5836923725E+00, 1.5025988856E+01, 3.6180889823E+00, 9.5330480542E-01],
	[3.1920000000E+04, 3.2534600488E+01, 5.5837103499E+00, 1.5033722374E+01, 3.6186517476E+00, 9.5332954994E-01],
	[3.1925000000E+04, 3.2543249262E+01, 5.5837283246E+00, 1.5041458658E+01, 3.6192143407E+00, 9.5335428033E-01],
	[3.1930000000E+04, 3.2551898981E+01, 5.5837462965E+00, 1.5049197711E+01, 3.6197767616E+00, 9.5337899661E-01],
	[3.1935000000E+04, 3.2560549644E+01, 5.5837642657E+00, 1.5056939532E+01, 3.6203390102E+00, 9.5340369877E-01],
	[3.1940000000E+04, 3.2569201251E+01, 5.5837822321E+00, 1.5064684121E+01, 3.6209010868E+00, 9.5342838684E-01],
	[3.1945000000E+04, 3.2577853802E+01, 5.5838001958E+00, 1.5072431480E+01, 3.6214629912E+00, 9.5345306082E-01],
	[3.1950000000E+04, 3.2586507297E+01, 5.5838181567E+00, 1.5080181609E+01, 3.6220247236E+00, 9.5347772071E-01],
	[3.1955000000E+04, 3.2595161736E+01, 5.5838361149E+00, 1.5087934508E+01, 3.6225862839E+00, 9.5350236652E-01],
	[3.1960000000E+04, 3.2603817119E+01, 5.5838540703E+00, 1.5095690178E+01, 3.6231476722E+00, 9.5352699827E-01],
	[3.1965000000E+04, 3.2612473446E+01, 5.5838720229E+00, 1.5103448620E+01, 3.6237088886E+00, 9.5355161595E-01],
	[3.1970000000E+04, 3.2621130716E+01, 5.5838899729E+00, 1.5111209834E+01, 3.6242699330E+00, 9.5357621958E-01],
	[3.1975000000E+04, 3.2629788930E+01, 5.5839079200E+00, 1.5118973821E+01, 3.6248308055E+00, 9.5360080917E-01],
	[3.1980000000E+04, 3.2638448088E+01, 5.5839258644E+00, 1.5126740581E+01, 3.6253915062E+00, 9.5362538472E-01],
	[3.1985000000E+04, 3.2647108190E+01, 5.5839438061E+00, 1.5134510115E+01, 3.6259520350E+00, 9.5364994624E-01],
	[3.1990000000E+04, 3.2655769235E+01, 5.5839617450E+00, 1.5142282423E+01, 3.6265123920E+00, 9.5367449374E-01],
	[3.1995000000E+04, 3.2664431224E+01, 5.5839796812E+00, 1.5150057506E+01, 3.6270725773E+00, 9.5369902723E-01],
	[3.2000000000E+04, 3.2673094156E+01, 5.5839976146E+00, 1.5157835365E+01, 3.6276325908E+00, 9.5372354672E-01],
	[3.2005000000E+04, 3.2681758032E+01, 5.5840155453E+00, 1.5165615999E+01, 3.6281924326E+00, 9.5374805220E-01],
	[3.2010000000E+04, 3.2690422851E+01, 5.5840334732E+00, 1.5173399410E+01, 3.6287521027E+00, 9.5377254370E-01],
	[3.2015000000E+04, 3.2699088614E+01, 5.5840513984E+00, 1.5181185599E+01, 3.6293116012E+00, 9.5379702122E-01],
	[3.2020000000E+04, 3.2707755320E+01, 5.5840693209E+00, 1.5188974565E+01, 3.6298709281E+00, 9.5382148476E-01],
	[3.2025000000E+04, 3.2716422969E+01, 5.5840872406E+00, 1.5196766309E+01, 3.6304300834E+00, 9.5384593434E-01],
	[3.2030000000E+04, 3.2725091561E+01, 5.5841051575E+00, 1.5204560832E+01, 3.6309890672E+00, 9.5387036996E-01],
	[3.2035000000E+04, 3.2733761097E+01, 5.5841230718E+00, 1.5212358135E+01, 3.6315478795E+00, 9.5389479163E-01],
	[3.2040000000E+04, 3.2742431576E+01, 5.5841409833E+00, 1.5220158217E+01, 3.6321065204E+00, 9.5391919937E-01],
	[3.2045000000E+04, 3.2751102998E+01, 5.5841588920E+00, 1.5227961080E+01, 3.6326649898E+00, 9.5394359316E-01],
	[3.2050000000E+04, 3.2759775363E+01, 5.5841767981E+00, 1.5235766724E+01, 3.6332232878E+00, 9.5396797304E-01],
	[3.2055000000E+04, 3.2768448671E+01, 5.5841947013E+00, 1.5243575150E+01, 3.6337814145E+00, 9.5399233899E-01],
	[3.2060000000E+04, 3.2777122922E+01, 5.5842126019E+00, 1.5251386358E+01, 3.6343393698E+00, 9.5401669104E-01],
	[3.2065000000E+04, 3.2785798116E+01, 5.5842304997E+00, 1.5259200348E+01, 3.6348971538E+00, 9.5404102919E-01],
	[3.2070000000E+04, 3.2794474253E+01, 5.5842483948E+00, 1.5267017122E+01, 3.6354547666E+00, 9.5406535344E-01],
	[3.2075000000E+04, 3.2803151333E+01, 5.5842662871E+00, 1.5274836679E+01, 3.6360122081E+00, 9.5408966380E-01],
	[3.2080000000E+04, 3.2811829356E+01, 5.5842841767E+00, 1.5282659021E+01, 3.6365694784E+00, 9.5411396029E-01],
	[3.2085000000E+04, 3.2820508321E+01, 5.5843020636E+00, 1.5290484148E+01, 3.6371265776E+00, 9.5413824291E-01],
	[3.2090000000E+04, 3.2829188229E+01, 5.5843199478E+00, 1.5298312061E+01, 3.6376835057E+00, 9.5416251167E-01],
	[3.2095000000E+04, 3.2837869080E+01, 5.5843378292E+00, 1.5306142759E+01, 3.6382402627E+00, 9.5418676657E-01],
	[3.2100000000E+04, 3.2846550873E+01, 5.5843557079E+00, 1.5313976244E+01, 3.6387968486E+00, 9.5421100763E-01],
	[3.2105000000E+04, 3.2855233609E+01, 5.5843735839E+00, 1.5321812516E+01, 3.6393532635E+00, 9.5423523485E-01],
	[3.2110000000E+04, 3.2863917288E+01, 5.5843914571E+00, 1.5329651576E+01, 3.6399095074E+00, 9.5425944825E-01],
	[3.2115000000E+04, 3.2872601909E+01, 5.5844093277E+00, 1.5337493425E+01, 3.6404655803E+00, 9.5428364781E-01],
	[3.2120000000E+04, 3.2881287472E+01, 5.5844271954E+00, 1.5345338062E+01, 3.6410214824E+00, 9.5430783357E-01],
	[3.2125000000E+04, 3.2889973978E+01, 5.5844450605E+00, 1.5353185488E+01, 3.6415772135E+00, 9.5433200552E-01],
	[3.2130000000E+04, 3.2898661426E+01, 5.5844629229E+00, 1.5361035705E+01, 3.6421327738E+00, 9.5435616367E-01],
	[3.2135000000E+04, 3.2907349817E+01, 5.5844807825E+00, 1.5368888712E+01, 3.6426881633E+00, 9.5438030803E-01],
	[3.2140000000E+04, 3.2916039150E+01, 5.5844986394E+00, 1.5376744510E+01, 3.6432433820E+00, 9.5440443861E-01],
	[3.2145000000E+04, 3.2924729425E+01, 5.5845164936E+00, 1.5384603099E+01, 3.6437984300E+00, 9.5442855542E-01],
	[3.2150000000E+04, 3.2933420642E+01, 5.5845343450E+00, 1.5392464481E+01, 3.6443533072E+00, 9.5445265846E-01],
	[3.2155000000E+04, 3.2942112802E+01, 5.5845521938E+00, 1.5400328656E+01, 3.6449080138E+00, 9.5447674774E-01],
	[3.2160000000E+04, 3.2950805903E+01, 5.5845700398E+00, 1.5408195623E+01, 3.6454625497E+00, 9.5450082327E-01],
	[3.2165000000E+04, 3.2959499947E+01, 5.5845878831E+00, 1.5416065385E+01, 3.6460169150E+00, 9.5452488506E-01],
	[3.2170000000E+04, 3.2968194933E+01, 5.5846057237E+00, 1.5423937941E+01, 3.6465711098E+00, 9.5454893311E-01],
	[3.2175000000E+04, 3.2976890860E+01, 5.5846235616E+00, 1.5431813292E+01, 3.6471251340E+00, 9.5457296744E-01],
	[3.2180000000E+04, 3.2985587730E+01, 5.5846413968E+00, 1.5439691439E+01, 3.6476789876E+00, 9.5459698805E-01],
	[3.2185000000E+04, 3.2994285541E+01, 5.5846592292E+00, 1.5447572382E+01, 3.6482326709E+00, 9.5462099495E-01],
	[3.2190000000E+04, 3.3002984294E+01, 5.5846770589E+00, 1.5455456121E+01, 3.6487861837E+00, 9.5464498814E-01],
	[3.2195000000E+04, 3.3011683989E+01, 5.5846948860E+00, 1.5463342658E+01, 3.6493395260E+00, 9.5466896764E-01],
	[3.2200000000E+04, 3.3020384626E+01, 5.5847127103E+00, 1.5471231992E+01, 3.6498926981E+00, 9.5469293346E-01],
	[3.2205000000E+04, 3.3029086204E+01, 5.5847305319E+00, 1.5479124125E+01, 3.6504456997E+00, 9.5471688559E-01],
	[3.2210000000E+04, 3.3037788724E+01, 5.5847483508E+00, 1.5487019056E+01, 3.6509985311E+00, 9.5474082406E-01],
	[3.2215000000E+04, 3.3046492186E+01, 5.5847661669E+00, 1.5494916787E+01, 3.6515511923E+00, 9.5476474886E-01],
	[3.2220000000E+04, 3.3055196589E+01, 5.5847839804E+00, 1.5502817318E+01, 3.6521036832E+00, 9.5478866000E-01],
	[3.2225000000E+04, 3.3063901934E+01, 5.5848017912E+00, 1.5510720649E+01, 3.6526560039E+00, 9.5481255750E-01],
	[3.2230000000E+04, 3.3072608220E+01, 5.5848195992E+00, 1.5518626782E+01, 3.6532081544E+00, 9.5483644136E-01],
	[3.2235000000E+04, 3.3081315448E+01, 5.5848374046E+00, 1.5526535716E+01, 3.6537601348E+00, 9.5486031159E-01],
	[3.2240000000E+04, 3.3090023617E+01, 5.5848552072E+00, 1.5534447452E+01, 3.6543119452E+00, 9.5488416820E-01],
	[3.2245000000E+04, 3.3098732728E+01, 5.5848730072E+00, 1.5542361992E+01, 3.6548635854E+00, 9.5490801119E-01],
	[3.2250000000E+04, 3.3107442779E+01, 5.5848908044E+00, 1.5550279334E+01, 3.6554150557E+00, 9.5493184057E-01],
	[3.2255000000E+04, 3.3116153772E+01, 5.5849085990E+00, 1.5558199481E+01, 3.6559663560E+00, 9.5495565635E-01],
	[3.2260000000E+04, 3.3124865707E+01, 5.5849263908E+00, 1.5566122431E+01, 3.6565174863E+00, 9.5497945854E-01],
	[3.2265000000E+04, 3.3133578582E+01, 5.5849441799E+00, 1.5574048187E+01, 3.6570684467E+00, 9.5500324715E-01],
	[3.2270000000E+04, 3.3142292399E+01, 5.5849619664E+00, 1.5581976749E+01, 3.6576192373E+00, 9.5502702218E-01],
	[3.2275000000E+04, 3.3151007156E+01, 5.5849797501E+00, 1.5589908116E+01, 3.6581698580E+00, 9.5505078364E-01],
	[3.2280000000E+04, 3.3159722855E+01, 5.5849975312E+00, 1.5597842290E+01, 3.6587203088E+00, 9.5507453155E-01],
	[3.2285000000E+04, 3.3168439494E+01, 5.5850153095E+00, 1.5605779272E+01, 3.6592705900E+00, 9.5509826590E-01],
	[3.2290000000E+04, 3.3177157075E+01, 5.5850330851E+00, 1.5613719061E+01, 3.6598207013E+00, 9.5512198670E-01],
	[3.2295000000E+04, 3.3185875596E+01, 5.5850508581E+00, 1.5621661659E+01, 3.6603706430E+00, 9.5514569397E-01],
	[3.2300000000E+04, 3.3194595059E+01, 5.5850686284E+00, 1.5629607065E+01, 3.6609204150E+00, 9.5516938772E-01],
	[3.2305000000E+04, 3.3203315462E+01, 5.5850863959E+00, 1.5637555281E+01, 3.6614700174E+00, 9.5519306794E-01],
	[3.2310000000E+04, 3.3212036806E+01, 5.5851041608E+00, 1.5645506307E+01, 3.6620194501E+00, 9.5521673465E-01],
	[3.2315000000E+04, 3.3220759091E+01, 5.5851219230E+00, 1.5653460144E+01, 3.6625687133E+00, 9.5524038785E-01],
	[3.2320000000E+04, 3.3229482316E+01, 5.5851396824E+00, 1.5661416791E+01, 3.6631178070E+00, 9.5526402756E-01],
	[3.2325000000E+04, 3.3238206482E+01, 5.5851574392E+00, 1.5669376251E+01, 3.6636667312E+00, 9.5528765378E-01],
	[3.2330000000E+04, 3.3246931588E+01, 5.5851751933E+00, 1.5677338522E+01, 3.6642154860E+00, 9.5531126652E-01],
	[3.2335000000E+04, 3.3255657636E+01, 5.5851929448E+00, 1.5685303607E+01, 3.6647640713E+00, 9.5533486578E-01],
	[3.2340000000E+04, 3.3264384623E+01, 5.5852106935E+00, 1.5693271505E+01, 3.6653124872E+00, 9.5535845158E-01],
	[3.2345000000E+04, 3.3273112551E+01, 5.5852284395E+00, 1.5701242216E+01, 3.6658607338E+00, 9.5538202392E-01],
	[3.2350000000E+04, 3.3281841420E+01, 5.5852461829E+00, 1.5709215743E+01, 3.6664088110E+00, 9.5540558281E-01],
	[3.2355000000E+04, 3.3290571229E+01, 5.5852639235E+00, 1.5717192084E+01, 3.6669567190E+00, 9.5542912827E-01],
	[3.2360000000E+04, 3.3299301978E+01, 5.5852816615E+00, 1.5725171241E+01, 3.6675044577E+00, 9.5545266028E-01],
	[3.2365000000E+04, 3.3308033667E+01, 5.5852993968E+00, 1.5733153214E+01, 3.6680520273E+00, 9.5547617887E-01],
	[3.2370000000E+04, 3.3316766297E+01, 5.5853171294E+00, 1.5741138004E+01, 3.6685994276E+00, 9.5549968405E-01],
	[3.2375000000E+04, 3.3325499867E+01, 5.5853348594E+00, 1.5749125611E+01, 3.6691466588E+00, 9.5552317581E-01],
	[3.2380000000E+04, 3.3334234377E+01, 5.5853525866E+00, 1.5757116036E+01, 3.6696937209E+00, 9.5554665418E-01],
	[3.2385000000E+04, 3.3342969827E+01, 5.5853703112E+00, 1.5765109279E+01, 3.6702406140E+00, 9.5557011914E-01],
	[3.2390000000E+04, 3.3351706218E+01, 5.5853880331E+00, 1.5773105341E+01, 3.6707873380E+00, 9.5559357073E-01],
	[3.2395000000E+04, 3.3360449494E+01, 5.5854064201E+00, 1.5781104223E+01, 3.6713342536E+00, 9.5561700893E-01],
	[3.2400000000E+04, 3.3369213325E+01, 5.5854270068E+00, 1.5789105925E+01, 3.6718821896E+00, 9.5564043376E-01],
	[3.2405000000E+04, 3.3377978106E+01, 5.5854475904E+00, 1.5797110949E+01, 3.6724299843E+00, 9.5566384523E-01],
	[3.2410000000E+04, 3.3386743836E+01, 5.5854681708E+00, 1.5805120223E+01, 3.6729776879E+00, 9.5568724335E-01],
	[3.2415000000E+04, 3.3395510515E+01, 5.5854887482E+00, 1.5813132321E+01, 3.6735252230E+00, 9.5571062812E-01],
	[3.2420000000E+04, 3.3404278144E+01, 5.5855093225E+00, 1.5821147242E+01, 3.6740725897E+00, 9.5573399954E-01],
	[3.2425000000E+04, 3.3413046722E+01, 5.5855298937E+00, 1.5829164989E+01, 3.6746197881E+00, 9.5575735764E-01],
	[3.2430000000E+04, 3.3421816249E+01, 5.5855504617E+00, 1.5837185560E+01, 3.6751668183E+00, 9.5578070242E-01],
	[3.2435000000E+04, 3.3430586725E+01, 5.5855710267E+00, 1.5845208958E+01, 3.6757136802E+00, 9.5580403388E-01],
	[3.2440000000E+04, 3.3439358151E+01, 5.5855915886E+00, 1.5853235181E+01, 3.6762603738E+00, 9.5582735203E-01],
	[3.2445000000E+04, 3.3448130525E+01, 5.5856121474E+00, 1.5861264232E+01, 3.6768068993E+00, 9.5585065688E-01],
	[3.2450000000E+04, 3.3456903849E+01, 5.5856327031E+00, 1.5869296110E+01, 3.6773532567E+00, 9.5587394844E-01],
	[3.2455000000E+04, 3.3465678121E+01, 5.5856532557E+00, 1.5877330816E+01, 3.6778994459E+00, 9.5589722672E-01],
	[3.2460000000E+04, 3.3474453342E+01, 5.5856738053E+00, 1.5885368351E+01, 3.6784454670E+00, 9.5592049172E-01],
	[3.2465000000E+04, 3.3483229512E+01, 5.5856943517E+00, 1.5893408714E+01, 3.6789913202E+00, 9.5594374345E-01],
	[3.2470000000E+04, 3.3492006631E+01, 5.5857148950E+00, 1.5901451908E+01, 3.6795370053E+00, 9.5596698193E-01],
	[3.2475000000E+04, 3.3500784699E+01, 5.5857354353E+00, 1.5909497931E+01, 3.6800825224E+00, 9.5599020715E-01],
	[3.2480000000E+04, 3.3509563716E+01, 5.5857559725E+00, 1.5917546785E+01, 3.6806278716E+00, 9.5601341912E-01],
	[3.2485000000E+04, 3.3518343681E+01, 5.5857765066E+00, 1.5925598471E+01, 3.6811730529E+00, 9.5603661786E-01],
	[3.2490000000E+04, 3.3527124595E+01, 5.5857970376E+00, 1.5933652989E+01, 3.6817180664E+00, 9.5605980337E-01],
	[3.2495000000E+04, 3.3535906457E+01, 5.5858175655E+00, 1.5941710339E+01, 3.6822629120E+00, 9.5608297566E-01],
	[3.2500000000E+04, 3.3544689268E+01, 5.5858380903E+00, 1.5949770522E+01, 3.6828075898E+00, 9.5610613473E-01],
	[3.2505000000E+04, 3.3553473028E+01, 5.5858586121E+00, 1.5957833539E+01, 3.6833520999E+00, 9.5612928060E-01],
	[3.2510000000E+04, 3.3562257736E+01, 5.5858791308E+00, 1.5965899389E+01, 3.6838964423E+00, 9.5615241327E-01],
	[3.2515000000E+04, 3.3571043392E+01, 5.5858996463E+00, 1.5973968075E+01, 3.6844406170E+00, 9.5617553275E-01],
	[3.2520000000E+04, 3.3579829997E+01, 5.5859201589E+00, 1.5982039596E+01, 3.6849846240E+00, 9.5619863905E-01],
	[3.2525000000E+04, 3.3588617550E+01, 5.5859406683E+00, 1.5990113952E+01, 3.6855284634E+00, 9.5622173218E-01],
	[3.2530000000E+04, 3.3597406052E+01, 5.5859611746E+00, 1.5998191146E+01, 3.6860721352E+00, 9.5624481214E-01],
	[3.2535000000E+04, 3.3606195502E+01, 5.5859816779E+00, 1.6006271175E+01, 3.6866156395E+00, 9.5626787894E-01],
	[3.2540000000E+04, 3.3614985900E+01, 5.5860021781E+00, 1.6014354043E+01, 3.6871589763E+00, 9.5629093259E-01],
	[3.2545000000E+04, 3.3623777246E+01, 5.5860226753E+00, 1.6022439749E+01, 3.6877021457E+00, 9.5631397310E-01],
	[3.2550000000E+04, 3.3632569540E+01, 5.5860431693E+00, 1.6030528293E+01, 3.6882451476E+00, 9.5633700048E-01],
	[3.2555000000E+04, 3.3641362783E+01, 5.5860636603E+00, 1.6038619676E+01, 3.6887879821E+00, 9.5636001472E-01],
	[3.2560000000E+04, 3.3650156973E+01, 5.5860841482E+00, 1.6046713899E+01, 3.6893306492E+00, 9.5638301585E-01],
	[3.2565000000E+04, 3.3658952112E+01, 5.5861046331E+00, 1.6054810963E+01, 3.6898731490E+00, 9.5640600387E-01],
	[3.2570000000E+04, 3.3667748198E+01, 5.5861251148E+00, 1.6062910867E+01, 3.6904154816E+00, 9.5642897878E-01],
	[3.2575000000E+04, 3.3676545233E+01, 5.5861455935E+00, 1.6071013613E+01, 3.6909576468E+00, 9.5645194060E-01],
	[3.2580000000E+04, 3.3685343215E+01, 5.5861660692E+00, 1.6079119200E+01, 3.6914996449E+00, 9.5647488933E-01],
	[3.2585000000E+04, 3.3694142145E+01, 5.5861865417E+00, 1.6087227631E+01, 3.6920414758E+00, 9.5649782498E-01],
	[3.2590000000E+04, 3.3702942023E+01, 5.5862070112E+00, 1.6095338904E+01, 3.6925831395E+00, 9.5652074755E-01],
	[3.2595000000E+04, 3.3711742848E+01, 5.5862274777E+00, 1.6103453021E+01, 3.6931246361E+00, 9.5654365706E-01],
	[3.2600000000E+04, 3.3720544622E+01, 5.5862479411E+00, 1.6111569982E+01, 3.6936659657E+00, 9.5656655352E-01],
	[3.2605000000E+04, 3.3729347343E+01, 5.5862684014E+00, 1.6119689788E+01, 3.6942071282E+00, 9.5658943693E-01],
	[3.2610000000E+04, 3.3738151011E+01, 5.5862888586E+00, 1.6127812440E+01, 3.6947481237E+00, 9.5661230729E-01],
	[3.2615000000E+04, 3.3746955627E+01, 5.5863093128E+00, 1.6135937937E+01, 3.6952889522E+00, 9.5663516462E-01],
	[3.2620000000E+04, 3.3755761191E+01, 5.5863297639E+00, 1.6144066281E+01, 3.6958296139E+00, 9.5665800893E-01],
	[3.2625000000E+04, 3.3764567702E+01, 5.5863502120E+00, 1.6152197471E+01, 3.6963701086E+00, 9.5668084022E-01],
	[3.2630000000E+04, 3.3773375161E+01, 5.5863706570E+00, 1.6160331510E+01, 3.6969104365E+00, 9.5670365850E-01],
	[3.2635000000E+04, 3.3782183567E+01, 5.5863910989E+00, 1.6168468396E+01, 3.6974505975E+00, 9.5672646378E-01],
	[3.2640000000E+04, 3.3790992920E+01, 5.5864115378E+00, 1.6176608131E+01, 3.6979905918E+00, 9.5674925606E-01],
	[3.2645000000E+04, 3.3799803221E+01, 5.5864319737E+00, 1.6184750716E+01, 3.6985304193E+00, 9.5677203536E-01],
	[3.2650000000E+04, 3.3808614469E+01, 5.5864524064E+00, 1.6192896150E+01, 3.6990700801E+00, 9.5679480168E-01],
	[3.2655000000E+04, 3.3817426664E+01, 5.5864728362E+00, 1.6201044435E+01, 3.6996095743E+00, 9.5681755502E-01],
	[3.2660000000E+04, 3.3826239806E+01, 5.5864932628E+00, 1.6209195570E+01, 3.7001489018E+00, 9.5684029541E-01],
	[3.2665000000E+04, 3.3835053896E+01, 5.5865136865E+00, 1.6217349558E+01, 3.7006880627E+00, 9.5686302284E-01],
	[3.2670000000E+04, 3.3843868933E+01, 5.5865341070E+00, 1.6225506397E+01, 3.7012270570E+00, 9.5688573732E-01],
	[3.2675000000E+04, 3.3852684916E+01, 5.5865545246E+00, 1.6233666089E+01, 3.7017658848E+00, 9.5690843886E-01],
	[3.2680000000E+04, 3.3861501847E+01, 5.5865749390E+00, 1.6241828634E+01, 3.7023045461E+00, 9.5693112747E-01],
	[3.2685000000E+04, 3.3870319724E+01, 5.5865953504E+00, 1.6249994033E+01, 3.7028430410E+00, 9.5695380316E-01],
	[3.2690000000E+04, 3.3879138549E+01, 5.5866157588E+00, 1.6258162286E+01, 3.7033813694E+00, 9.5697646593E-01],
	[3.2695000000E+04, 3.3887958320E+01, 5.5866361641E+00, 1.6266333394E+01, 3.7039195315E+00, 9.5699911579E-01],
	[3.2700000000E+04, 3.3896779039E+01, 5.5866565664E+00, 1.6274507357E+01, 3.7044575272E+00, 9.5702175275E-01],
	[3.2705000000E+04, 3.3905600704E+01, 5.5866769657E+00, 1.6282684176E+01, 3.7049953566E+00, 9.5704437682E-01],
	[3.2710000000E+04, 3.3914423316E+01, 5.5866973619E+00, 1.6290863852E+01, 3.7055330197E+00, 9.5706698800E-01],
	[3.2715000000E+04, 3.3923246874E+01, 5.5867177550E+00, 1.6299046385E+01, 3.7060705166E+00, 9.5708958630E-01],
	[3.2720000000E+04, 3.3932071379E+01, 5.5867381451E+00, 1.6307231776E+01, 3.7066078473E+00, 9.5711217174E-01],
	[3.2725000000E+04, 3.3940896831E+01, 5.5867585322E+00, 1.6315420025E+01, 3.7071450118E+00, 9.5713474431E-01],
	[3.2730000000E+04, 3.3949723229E+01, 5.5867789162E+00, 1.6323611133E+01, 3.7076820102E+00, 9.5715730403E-01],
	[3.2735000000E+04, 3.3958550574E+01, 5.5867992972E+00, 1.6331805100E+01, 3.7082188425E+00, 9.5717985090E-01],
	[3.2740000000E+04, 3.3967378866E+01, 5.5868196751E+00, 1.6340001927E+01, 3.7087555088E+00, 9.5720238493E-01],
	[3.2745000000E+04, 3.3976208103E+01, 5.5868400500E+00, 1.6348201615E+01, 3.7092920090E+00, 9.5722490614E-01],
	[3.2750000000E+04, 3.3985038288E+01, 5.5868604219E+00, 1.6356404163E+01, 3.7098283432E+00, 9.5724741452E-01],
	[3.2755000000E+04, 3.3993869418E+01, 5.5868807908E+00, 1.6364609573E+01, 3.7103645115E+00, 9.5726991008E-01],
	[3.2760000000E+04, 3.4002701495E+01, 5.5869011566E+00, 1.6372817846E+01, 3.7109005139E+00, 9.5729239284E-01],
	[3.2765000000E+04, 3.4011534518E+01, 5.5869215193E+00, 1.6381028981E+01, 3.7114363505E+00, 9.5731486279E-01],
	[3.2770000000E+04, 3.4020368488E+01, 5.5869418791E+00, 1.6389242979E+01, 3.7119720212E+00, 9.5733731995E-01],
	[3.2775000000E+04, 3.4029203403E+01, 5.5869622358E+00, 1.6397459841E+01, 3.7125075261E+00, 9.5735976433E-01],
	[3.2780000000E+04, 3.4038039265E+01, 5.5869825894E+00, 1.6405679568E+01, 3.7130428652E+00, 9.5738219594E-01],
	[3.2785000000E+04, 3.4046876073E+01, 5.5870029401E+00, 1.6413902160E+01, 3.7135780386E+00, 9.5740461477E-01],
	[3.2790000000E+04, 3.4055713827E+01, 5.5870232877E+00, 1.6422127617E+01, 3.7141130464E+00, 9.5742702084E-01],
	[3.2795000000E+04, 3.4064552527E+01, 5.5870436323E+00, 1.6430355940E+01, 3.7146478884E+00, 9.5744941416E-01],
	[3.2800000000E+04, 3.4073392173E+01, 5.5870639738E+00, 1.6438587130E+01, 3.7151825649E+00, 9.5747179473E-01],
	[3.2805000000E+04, 3.4082232765E+01, 5.5870843124E+00, 1.6446821187E+01, 3.7157170758E+00, 9.5749416257E-01],
	[3.2810000000E+04, 3.4091074303E+01, 5.5871046479E+00, 1.6455058111E+01, 3.7162514211E+00, 9.5751651767E-01],
	[3.2815000000E+04, 3.4099916786E+01, 5.5871249804E+00, 1.6463297905E+01, 3.7167856010E+00, 9.5753886006E-01],
	[3.2820000000E+04, 3.4108760216E+01, 5.5871453098E+00, 1.6471540567E+01, 3.7173196154E+00, 9.5756118972E-01],
	[3.2825000000E+04, 3.4117604591E+01, 5.5871656363E+00, 1.6479786098E+01, 3.7178534643E+00, 9.5758350668E-01],
	[3.2830000000E+04, 3.4126449912E+01, 5.5871859597E+00, 1.6488034500E+01, 3.7183871479E+00, 9.5760581094E-01],
	[3.2835000000E+04, 3.4135296178E+01, 5.5872062801E+00, 1.6496285772E+01, 3.7189206661E+00, 9.5762810251E-01],
	[3.2840000000E+04, 3.4144143390E+01, 5.5872265974E+00, 1.6504539915E+01, 3.7194540190E+00, 9.5765038140E-01],
	[3.2845000000E+04, 3.4152991548E+01, 5.5872469118E+00, 1.6512796930E+01, 3.7199872066E+00, 9.5767264761E-01],
	[3.2850000000E+04, 3.4161840651E+01, 5.5872672231E+00, 1.6521056817E+01, 3.7205202290E+00, 9.5769490115E-01],
	[3.2855000000E+04, 3.4170690700E+01, 5.5872875314E+00, 1.6529319577E+01, 3.7210530861E+00, 9.5771714202E-01],
	[3.2860000000E+04, 3.4179541695E+01, 5.5873078367E+00, 1.6537585210E+01, 3.7215857781E+00, 9.5773937025E-01],
	[3.2865000000E+04, 3.4188393634E+01, 5.5873281390E+00, 1.6545853718E+01, 3.7221183050E+00, 9.5776158583E-01],
	[3.2870000000E+04, 3.4197246519E+01, 5.5873484383E+00, 1.6554125099E+01, 3.7226506668E+00, 9.5778378877E-01],
	[3.2875000000E+04, 3.4206100350E+01, 5.5873687345E+00, 1.6562399356E+01, 3.7231828635E+00, 9.5780597908E-01],
	[3.2880000000E+04, 3.4214955125E+01, 5.5873890278E+00, 1.6570676489E+01, 3.7237148952E+00, 9.5782815677E-01],
	[3.2885000000E+04, 3.4223810846E+01, 5.5874093180E+00, 1.6578956498E+01, 3.7242467619E+00, 9.5785032185E-01],
	[3.2890000000E+04, 3.4232667512E+01, 5.5874296052E+00, 1.6587239383E+01, 3.7247784636E+00, 9.5787247432E-01],
	[3.2895000000E+04, 3.4241525124E+01, 5.5874498894E+00, 1.6595525146E+01, 3.7253100005E+00, 9.5789461419E-01],
	[3.2900000000E+04, 3.4250383680E+01, 5.5874701706E+00, 1.6603813786E+01, 3.7258413725E+00, 9.5791674146E-01],
	[3.2905000000E+04, 3.4259243182E+01, 5.5874904488E+00, 1.6612105306E+01, 3.7263725796E+00, 9.5793885616E-01],
	[3.2910000000E+04, 3.4268103628E+01, 5.5875107240E+00, 1.6620399704E+01, 3.7269036219E+00, 9.5796095827E-01],
	[3.2915000000E+04, 3.4276965020E+01, 5.5875309962E+00, 1.6628696981E+01, 3.7274344995E+00, 9.5798304782E-01],
	[3.2920000000E+04, 3.4285850965E+01, 5.5875538843E+00, 1.6636997139E+01, 3.7279666573E+00, 9.5800512481E-01],
	[3.2925000000E+04, 3.4294739550E+01, 5.5875769561E+00, 1.6645300178E+01, 3.7284987541E+00, 9.5802718924E-01],
	[3.2930000000E+04, 3.4303629090E+01, 5.5876000245E+00, 1.6653606097E+01, 3.7290306867E+00, 9.5804924113E-01],
	[3.2935000000E+04, 3.4312519583E+01, 5.5876230894E+00, 1.6661914899E+01, 3.7295624552E+00, 9.5807128048E-01],
	[3.2940000000E+04, 3.4321411031E+01, 5.5876461510E+00, 1.6670226583E+01, 3.7300940596E+00, 9.5809330730E-01],
	[3.2945000000E+04, 3.4330303432E+01, 5.5876692092E+00, 1.6678541149E+01, 3.7306254999E+00, 9.5811532160E-01],
	[3.2950000000E+04, 3.4339196788E+01, 5.5876922639E+00, 1.6686858600E+01, 3.7311567763E+00, 9.5813732338E-01],
	[3.2955000000E+04, 3.4348091097E+01, 5.5877153153E+00, 1.6695178934E+01, 3.7316878886E+00, 9.5815931265E-01],
	[3.2960000000E+04, 3.4356986361E+01, 5.5877383633E+00, 1.6703502153E+01, 3.7322188370E+00, 9.5818128943E-01],
	[3.2965000000E+04, 3.4365882578E+01, 5.5877614078E+00, 1.6711828257E+01, 3.7327496215E+00, 9.5820325371E-01],
	[3.2970000000E+04, 3.4374779748E+01, 5.5877844490E+00, 1.6720157247E+01, 3.7332802421E+00, 9.5822520551E-01],
	[3.2975000000E+04, 3.4383677873E+01, 5.5878074867E+00, 1.6728489123E+01, 3.7338106989E+00, 9.5824714483E-01],
	[3.2980000000E+04, 3.4392576951E+01, 5.5878305211E+00, 1.6736823886E+01, 3.7343409919E+00, 9.5826907169E-01],
	[3.2985000000E+04, 3.4401476983E+01, 5.5878535520E+00, 1.6745161537E+01, 3.7348711211E+00, 9.5829098608E-01],
	[3.2990000000E+04, 3.4410377969E+01, 5.5878765796E+00, 1.6753502075E+01, 3.7354010867E+00, 9.5831288802E-01],
	[3.2995000000E+04, 3.4419279908E+01, 5.5878996038E+00, 1.6761845502E+01, 3.7359308885E+00, 9.5833477751E-01],
	[3.3000000000E+04, 3.4428182801E+01, 5.5879226245E+00, 1.6770191818E+01, 3.7364605267E+00, 9.5835665456E-01],
	[3.3005000000E+04, 3.4437086647E+01, 5.5879456419E+00, 1.6778541024E+01, 3.7369900013E+00, 9.5837851917E-01],
	[3.3010000000E+04, 3.4445991446E+01, 5.5879686559E+00, 1.6786893120E+01, 3.7375193123E+00, 9.5840037136E-01],
	[3.3015000000E+04, 3.4454897199E+01, 5.5879916665E+00, 1.6795248107E+01, 3.7380484598E+00, 9.5842221113E-01],
	[3.3020000000E+04, 3.4463803905E+01, 5.5880146737E+00, 1.6803605985E+01, 3.7385774437E+00, 9.5844403849E-01],
	[3.3025000000E+04, 3.4472711565E+01, 5.5880376776E+00, 1.6811966755E+01, 3.7391062643E+00, 9.5846585344E-01],
	[3.3030000000E+04, 3.4481620178E+01, 5.5880606780E+00, 1.6820330418E+01, 3.7396349214E+00, 9.5848765600E-01],
	[3.3035000000E+04, 3.4490529744E+01, 5.5880836750E+00, 1.6828696973E+01, 3.7401634151E+00, 9.5850944616E-01],
	[3.3040000000E+04, 3.4499440263E+01, 5.5881066687E+00, 1.6837066423E+01, 3.7406917454E+00, 9.5853122393E-01],
	[3.3045000000E+04, 3.4508351736E+01, 5.5881296590E+00, 1.6845438766E+01, 3.7412199125E+00, 9.5855298933E-01],
	[3.3050000000E+04, 3.4517264161E+01, 5.5881526459E+00, 1.6853814004E+01, 3.7417479163E+00, 9.5857474235E-01],
	[3.3055000000E+04, 3.4526177540E+01, 5.5881756294E+00, 1.6862192138E+01, 3.7422757568E+00, 9.5859648301E-01],
	[3.3060000000E+04, 3.4535091871E+01, 5.5881986095E+00, 1.6870573167E+01, 3.7428034342E+00, 9.5861821131E-01],
	[3.3065000000E+04, 3.4544007156E+01, 5.5882215863E+00, 1.6878957093E+01, 3.7433309483E+00, 9.5863992726E-01],
	[3.3070000000E+04, 3.4552923393E+01, 5.5882445596E+00, 1.6887343915E+01, 3.7438582994E+00, 9.5866163087E-01],
	[3.3075000000E+04, 3.4561840584E+01, 5.5882675296E+00, 1.6895733636E+01, 3.7443854874E+00, 9.5868332214E-01],
	[3.3080000000E+04, 3.4570758727E+01, 5.5882904962E+00, 1.6904126254E+01, 3.7449125123E+00, 9.5870500108E-01],
	[3.3085000000E+04, 3.4579677823E+01, 5.5883134595E+00, 1.6912521771E+01, 3.7454393742E+00, 9.5872666769E-01],
	[3.3090000000E+04, 3.4588597872E+01, 5.5883364193E+00, 1.6920920187E+01, 3.7459660732E+00, 9.5874832199E-01],
	[3.3095000000E+04, 3.4597518873E+01, 5.5883593758E+00, 1.6929321503E+01, 3.7464926092E+00, 9.5876996398E-01],
	[3.3100000000E+04, 3.4606440827E+01, 5.5883823289E+00, 1.6937725719E+01, 3.7470189823E+00, 9.5879159366E-01],
	[3.3105000000E+04, 3.4615363734E+01, 5.5884052786E+00, 1.6946132837E+01, 3.7475451926E+00, 9.5881321105E-01],
	[3.3110000000E+04, 3.4624287593E+01, 5.5884282250E+00, 1.6954542856E+01, 3.7480712400E+00, 9.5883481615E-01],
	[3.3115000000E+04, 3.4633212405E+01, 5.5884511680E+00, 1.6962955776E+01, 3.7485971246E+00, 9.5885640897E-01],
	[3.3120000000E+04, 3.4642138170E+01, 5.5884741076E+00, 1.6971371600E+01, 3.7491228465E+00, 9.5887798952E-01],
	[3.3125000000E+04, 3.4651064887E+01, 5.5884970439E+00, 1.6979790326E+01, 3.7496484057E+00, 9.5889955779E-01],
	[3.3130000000E+04, 3.4659992556E+01, 5.5885199768E+00, 1.6988211957E+01, 3.7501738022E+00, 9.5892111380E-01],
	[3.3135000000E+04, 3.4668921178E+01, 5.5885429063E+00, 1.6996636491E+01, 3.7506990361E+00, 9.5894265756E-01],
	[3.3140000000E+04, 3.4677850752E+01, 5.5885658325E+00, 1.7005063931E+01, 3.7512241074E+00, 9.5896418907E-01],
	[3.3145000000E+04, 3.4686781278E+01, 5.5885887552E+00, 1.7013494276E+01, 3.7517490161E+00, 9.5898570834E-01],
	[3.3150000000E+04, 3.4695712757E+01, 5.5886116747E+00, 1.7021927527E+01, 3.7522737623E+00, 9.5900721538E-01],
	[3.3155000000E+04, 3.4704645187E+01, 5.5886345907E+00, 1.7030363684E+01, 3.7527983460E+00, 9.5902871019E-01],
	[3.3160000000E+04, 3.4713578570E+01, 5.5886575034E+00, 1.7038802749E+01, 3.7533227673E+00, 9.5905019277E-01],
	[3.3165000000E+04, 3.4722512906E+01, 5.5886804128E+00, 1.7047244721E+01, 3.7538470261E+00, 9.5907166315E-01],
	[3.3170000000E+04, 3.4731448193E+01, 5.5887033188E+00, 1.7055689601E+01, 3.7543711226E+00, 9.5909312132E-01],
	[3.3175000000E+04, 3.4740384432E+01, 5.5887262214E+00, 1.7064137391E+01, 3.7548950568E+00, 9.5911456728E-01],
	[3.3180000000E+04, 3.4749321623E+01, 5.5887491207E+00, 1.7072588089E+01, 3.7554188286E+00, 9.5913600106E-01],
	[3.3185000000E+04, 3.4758259766E+01, 5.5887720166E+00, 1.7081041698E+01, 3.7559424382E+00, 9.5915742265E-01],
	[3.3190000000E+04, 3.4767198861E+01, 5.5887949091E+00, 1.7089498217E+01, 3.7564658856E+00, 9.5917883206E-01],
	[3.3195000000E+04, 3.4776138908E+01, 5.5888177983E+00, 1.7097957647E+01, 3.7569891708E+00, 9.5920022929E-01],
	[3.3200000000E+04, 3.4785079907E+01, 5.5888406842E+00, 1.7106419988E+01, 3.7575122939E+00, 9.5922161437E-01],
	[3.3205000000E+04, 3.4794021858E+01, 5.5888635667E+00, 1.7114885242E+01, 3.7580352548E+00, 9.5924298728E-01],
	[3.3210000000E+04, 3.4802964760E+01, 5.5888864458E+00, 1.7123353409E+01, 3.7585580537E+00, 9.5926434804E-01],
	[3.3215000000E+04, 3.4811908614E+01, 5.5889093216E+00, 1.7131824489E+01, 3.7590806906E+00, 9.5928569666E-01],
	[3.3220000000E+04, 3.4820853420E+01, 5.5889321940E+00, 1.7140298482E+01, 3.7596031654E+00, 9.5930703314E-01],
	[3.3225000000E+04, 3.4829799177E+01, 5.5889550631E+00, 1.7148775390E+01, 3.7601254784E+00, 9.5932835749E-01],
	[3.3230000000E+04, 3.4838745886E+01, 5.5889779289E+00, 1.7157255214E+01, 3.7606476293E+00, 9.5934966971E-01],
	[3.3235000000E+04, 3.4847693547E+01, 5.5890007913E+00, 1.7165737952E+01, 3.7611696185E+00, 9.5937096982E-01],
	[3.3240000000E+04, 3.4856642159E+01, 5.5890236503E+00, 1.7174223607E+01, 3.7616914457E+00, 9.5939225781E-01],
	[3.3245000000E+04, 3.4865591722E+01, 5.5890465060E+00, 1.7182712179E+01, 3.7622131112E+00, 9.5941353371E-01],
	[3.3250000000E+04, 3.4874542237E+01, 5.5890693584E+00, 1.7191203667E+01, 3.7627346149E+00, 9.5943479750E-01],
	[3.3255000000E+04, 3.4883493703E+01, 5.5890922074E+00, 1.7199698074E+01, 3.7632559569E+00, 9.5945604921E-01],
	[3.3260000000E+04, 3.4892446121E+01, 5.5891150531E+00, 1.7208195399E+01, 3.7637771372E+00, 9.5947728883E-01],
	[3.3265000000E+04, 3.4901399489E+01, 5.5891378954E+00, 1.7216695643E+01, 3.7642981558E+00, 9.5949851638E-01],
	[3.3270000000E+04, 3.4910353809E+01, 5.5891607344E+00, 1.7225198806E+01, 3.7648190129E+00, 9.5951973186E-01],
	[3.3275000000E+04, 3.4919309081E+01, 5.5891835701E+00, 1.7233704889E+01, 3.7653397083E+00, 9.5954093527E-01],
	[3.3280000000E+04, 3.4928265303E+01, 5.5892064024E+00, 1.7242213893E+01, 3.7658602422E+00, 9.5956212663E-01],
	[3.3285000000E+04, 3.4937222477E+01, 5.5892292314E+00, 1.7250725819E+01, 3.7663806147E+00, 9.5958330594E-01],
	[3.3290000000E+04, 3.4946180601E+01, 5.5892520570E+00, 1.7259240666E+01, 3.7669008256E+00, 9.5960447321E-01],
	[3.3295000000E+04, 3.4955139677E+01, 5.5892748794E+00, 1.7267758435E+01, 3.7674208752E+00, 9.5962562845E-01],
	[3.3300000000E+04, 3.4964099704E+01, 5.5892976983E+00, 1.7276279127E+01, 3.7679407633E+00, 9.5964677165E-01],
	[3.3305000000E+04, 3.4973060681E+01, 5.5893205140E+00, 1.7284802742E+01, 3.7684604901E+00, 9.5966790284E-01],
	[3.3310000000E+04, 3.4982022610E+01, 5.5893433263E+00, 1.7293329282E+01, 3.7689800556E+00, 9.5968902201E-01],
	[3.3315000000E+04, 3.4990985489E+01, 5.5893661353E+00, 1.7301858746E+01, 3.7694994599E+00, 9.5971012917E-01],
	[3.3320000000E+04, 3.4999949319E+01, 5.5893889409E+00, 1.7310391135E+01, 3.7700187029E+00, 9.5973122434E-01],
	[3.3325000000E+04, 3.5008914100E+01, 5.5894117433E+00, 1.7318926450E+01, 3.7705377847E+00, 9.5975230751E-01],
	[3.3330000000E+04, 3.5017879832E+01, 5.5894345423E+00, 1.7327464692E+01, 3.7710567054E+00, 9.5977337869E-01],
	[3.3335000000E+04, 3.5026846514E+01, 5.5894573379E+00, 1.7336005860E+01, 3.7715754649E+00, 9.5979443789E-01],
	[3.3340000000E+04, 3.5035814148E+01, 5.5894801303E+00, 1.7344549955E+01, 3.7720940634E+00, 9.5981548512E-01],
	[3.3345000000E+04, 3.5044782731E+01, 5.5895029193E+00, 1.7353096978E+01, 3.7726125008E+00, 9.5983652038E-01],
	[3.3350000000E+04, 3.5053752266E+01, 5.5895257050E+00, 1.7361646930E+01, 3.7731307772E+00, 9.5985754368E-01],
	[3.3355000000E+04, 3.5062722750E+01, 5.5895484874E+00, 1.7370199811E+01, 3.7736488927E+00, 9.5987855503E-01],
	[3.3360000000E+04, 3.5071694186E+01, 5.5895712664E+00, 1.7378755622E+01, 3.7741668472E+00, 9.5989955444E-01],
	[3.3365000000E+04, 3.5080666571E+01, 5.5895940422E+00, 1.7387314363E+01, 3.7746846409E+00, 9.5992054190E-01],
	[3.3370000000E+04, 3.5089639908E+01, 5.5896168146E+00, 1.7395876034E+01, 3.7752022737E+00, 9.5994151744E-01],
	[3.3375000000E+04, 3.5098614194E+01, 5.5896395837E+00, 1.7404440637E+01, 3.7757197457E+00, 9.5996248104E-01],
	[3.3380000000E+04, 3.5107589431E+01, 5.5896623494E+00, 1.7413008172E+01, 3.7762370569E+00, 9.5998343273E-01],
	[3.3385000000E+04, 3.5116565618E+01, 5.5896851119E+00, 1.7421578639E+01, 3.7767542074E+00, 9.6000437251E-01],
	[3.3390000000E+04, 3.5125542756E+01, 5.5897078710E+00, 1.7430152039E+01, 3.7772711972E+00, 9.6002530038E-01],
	[3.3395000000E+04, 3.5134520843E+01, 5.5897306269E+00, 1.7438728373E+01, 3.7777880264E+00, 9.6004621636E-01],
	[3.3400000000E+04, 3.5143499881E+01, 5.5897533794E+00, 1.7447307641E+01, 3.7783046949E+00, 9.6006712044E-01],
	[3.3405000000E+04, 3.5152479869E+01, 5.5897761286E+00, 1.7455889844E+01, 3.7788212028E+00, 9.6008801264E-01],
	[3.3410000000E+04, 3.5161460807E+01, 5.5897988744E+00, 1.7464474982E+01, 3.7793375502E+00, 9.6010889297E-01],
	[3.3415000000E+04, 3.5170442695E+01, 5.5898216170E+00, 1.7473063056E+01, 3.7798537371E+00, 9.6012976142E-01],
	[3.3420000000E+04, 3.5179425533E+01, 5.5898443563E+00, 1.7481654066E+01, 3.7803697636E+00, 9.6015061801E-01],
	[3.3425000000E+04, 3.5188409320E+01, 5.5898670922E+00, 1.7490248013E+01, 3.7808856296E+00, 9.6017146274E-01],
	[3.3430000000E+04, 3.5197394058E+01, 5.5898898249E+00, 1.7498844898E+01, 3.7814013352E+00, 9.6019229562E-01],
	[3.3435000000E+04, 3.5206379746E+01, 5.5899125542E+00, 1.7507444721E+01, 3.7819168805E+00, 9.6021311666E-01],
	[3.3440000000E+04, 3.5215366383E+01, 5.5899352802E+00, 1.7516047482E+01, 3.7824322655E+00, 9.6023392586E-01],
	[3.3445000000E+04, 3.5224353971E+01, 5.5899580030E+00, 1.7524653183E+01, 3.7829474902E+00, 9.6025472324E-01],
	[3.3450000000E+04, 3.5233366404E+01, 5.5899833419E+00, 1.7533261823E+01, 3.7834640303E+00, 9.6027550879E-01],
	[3.3455000000E+04, 3.5242380924E+01, 5.5900088009E+00, 1.7541873404E+01, 3.7839804802E+00, 9.6029628252E-01],
	[3.3460000000E+04, 3.5251396403E+01, 5.5900342562E+00, 1.7550487926E+01, 3.7844967705E+00, 9.6031704445E-01],
	[3.3465000000E+04, 3.5260412840E+01, 5.5900597078E+00, 1.7559105389E+01, 3.7850129010E+00, 9.6033779457E-01],
	[3.3470000000E+04, 3.5269430236E+01, 5.5900851557E+00, 1.7567725794E+01, 3.7855288720E+00, 9.6035853290E-01],
	[3.3475000000E+04, 3.5278448590E+01, 5.5901105999E+00, 1.7576349142E+01, 3.7860446834E+00, 9.6037925944E-01],
	[3.3480000000E+04, 3.5287467904E+01, 5.5901360404E+00, 1.7584975433E+01, 3.7865603352E+00, 9.6039997420E-01],
	[3.3485000000E+04, 3.5296488175E+01, 5.5901614772E+00, 1.7593604668E+01, 3.7870758275E+00, 9.6042067718E-01],
	[3.3490000000E+04, 3.5305509405E+01, 5.5901869104E+00, 1.7602236847E+01, 3.7875911603E+00, 9.6044136839E-01],
	[3.3495000000E+04, 3.5314531594E+01, 5.5902123399E+00, 1.7610871971E+01, 3.7881063338E+00, 9.6046204785E-01],
	[3.3500000000E+04, 3.5323554740E+01, 5.5902377657E+00, 1.7619510041E+01, 3.7886213478E+00, 9.6048271555E-01],
	[3.3505000000E+04, 3.5332578845E+01, 5.5902631878E+00, 1.7628151056E+01, 3.7891362024E+00, 9.6050337150E-01],
	[3.3510000000E+04, 3.5341603909E+01, 5.5902886062E+00, 1.7636795018E+01, 3.7896508978E+00, 9.6052401571E-01],
	[3.3515000000E+04, 3.5350629931E+01, 5.5903140210E+00, 1.7645441927E+01, 3.7901654338E+00, 9.6054464819E-01],
	[3.3520000000E+04, 3.5359656911E+01, 5.5903394321E+00, 1.7654091784E+01, 3.7906798106E+00, 9.6056526894E-01],
	[3.3525000000E+04, 3.5368684849E+01, 5.5903648395E+00, 1.7662744589E+01, 3.7911940282E+00, 9.6058587797E-01],
	[3.3530000000E+04, 3.5377713745E+01, 5.5903902433E+00, 1.7671400343E+01, 3.7917080867E+00, 9.6060647529E-01],
	[3.3535000000E+04, 3.5386743599E+01, 5.5904156433E+00, 1.7680059046E+01, 3.7922219860E+00, 9.6062706090E-01],
	[3.3540000000E+04, 3.5395774411E+01, 5.5904410397E+00, 1.7688720700E+01, 3.7927357263E+00, 9.6064763481E-01],
	[3.3545000000E+04, 3.5404806182E+01, 5.5904664325E+00, 1.7697385303E+01, 3.7932493074E+00, 9.6066819703E-01],
	[3.3550000000E+04, 3.5413838910E+01, 5.5904918215E+00, 1.7706052858E+01, 3.7937627296E+00, 9.6068874756E-01],
	[3.3555000000E+04, 3.5422872596E+01, 5.5905172069E+00, 1.7714723365E+01, 3.7942759928E+00, 9.6070928641E-01],
	[3.3560000000E+04, 3.5431907240E+01, 5.5905425886E+00, 1.7723396823E+01, 3.7947890971E+00, 9.6072981359E-01],
	[3.3565000000E+04, 3.5440942842E+01, 5.5905679667E+00, 1.7732073235E+01, 3.7953020425E+00, 9.6075032911E-01],
	[3.3570000000E+04, 3.5449979402E+01, 5.5905933411E+00, 1.7740752599E+01, 3.7958148290E+00, 9.6077083296E-01],
	[3.3575000000E+04, 3.5459016919E+01, 5.5906187118E+00, 1.7749434918E+01, 3.7963274567E+00, 9.6079132517E-01],
	[3.3580000000E+04, 3.5468055395E+01, 5.5906440789E+00, 1.7758120191E+01, 3.7968399256E+00, 9.6081180573E-01],
	[3.3585000000E+04, 3.5477094827E+01, 5.5906694423E+00, 1.7766808419E+01, 3.7973522358E+00, 9.6083227465E-01],
	[3.3590000000E+04, 3.5486135218E+01, 5.5906948020E+00, 1.7775499603E+01, 3.7978643873E+00, 9.6085273193E-01],
	[3.3595000000E+04, 3.5495176566E+01, 5.5907201581E+00, 1.7784193743E+01, 3.7983763801E+00, 9.6087317760E-01],
	[3.3600000000E+04, 3.5504218872E+01, 5.5907455105E+00, 1.7792890840E+01, 3.7988882143E+00, 9.6089361164E-01],
	[3.3605000000E+04, 3.5513262135E+01, 5.5907708593E+00, 1.7801590893E+01, 3.7993998899E+00, 9.6091403408E-01],
	[3.3610000000E+04, 3.5522306355E+01, 5.5907962044E+00, 1.7810293905E+01, 3.7999114070E+00, 9.6093444491E-01],
	[3.3615000000E+04, 3.5531351533E+01, 5.5908215459E+00, 1.7818999875E+01, 3.8004227655E+00, 9.6095484414E-01],
	[3.3620000000E+04, 3.5540397669E+01, 5.5908468837E+00, 1.7827708805E+01, 3.8009339656E+00, 9.6097523178E-01],
	[3.3625000000E+04, 3.5549444762E+01, 5.5908722178E+00, 1.7836420693E+01, 3.8014450073E+00, 9.6099560784E-01],
	[3.3630000000E+04, 3.5558492812E+01, 5.5908975483E+00, 1.7845135542E+01, 3.8019558905E+00, 9.6101597232E-01],
	[3.3635000000E+04, 3.5567541819E+01, 5.5909228752E+00, 1.7853853352E+01, 3.8024666154E+00, 9.6103632523E-01],
	[3.3640000000E+04, 3.5576591784E+01, 5.5909481984E+00, 1.7862574122E+01, 3.8029771820E+00, 9.6105666657E-01],
	[3.3645000000E+04, 3.5585642705E+01, 5.5909735179E+00, 1.7871297855E+01, 3.8034875903E+00, 9.6107699636E-01],
	[3.3650000000E+04, 3.5594694584E+01, 5.5909988338E+00, 1.7880024550E+01, 3.8039978404E+00, 9.6109731460E-01],
	[3.3655000000E+04, 3.5603747420E+01, 5.5910241461E+00, 1.7888754208E+01, 3.8045079323E+00, 9.6111762130E-01],
	[3.3660000000E+04, 3.5612801213E+01, 5.5910494547E+00, 1.7897486829E+01, 3.8050178660E+00, 9.6113791646E-01],
	[3.3665000000E+04, 3.5621855963E+01, 5.5910747596E+00, 1.7906222415E+01, 3.8055276416E+00, 9.6115820009E-01],
	[3.3670000000E+04, 3.5630911670E+01, 5.5911000609E+00, 1.7914960965E+01, 3.8060372591E+00, 9.6117847219E-01],
	[3.3675000000E+04, 3.5639968334E+01, 5.5911253586E+00, 1.7923702480E+01, 3.8065467186E+00, 9.6119873278E-01],
	[3.3680000000E+04, 3.5649025955E+01, 5.5911506526E+00, 1.7932446961E+01, 3.8070560200E+00, 9.6121898186E-01],
	[3.3685000000E+04, 3.5658084533E+01, 5.5911759430E+00, 1.7941194409E+01, 3.8075651635E+00, 9.6123921944E-01],
	[3.3690000000E+04, 3.5667144067E+01, 5.5912012298E+00, 1.7949944823E+01, 3.8080741491E+00, 9.6125944553E-01],
	[3.3695000000E+04, 3.5676204559E+01, 5.5912265129E+00, 1.7958698205E+01, 3.8085829768E+00, 9.6127966012E-01],
	[3.3700000000E+04, 3.5685266007E+01, 5.5912517924E+00, 1.7967454555E+01, 3.8090916466E+00, 9.6129986323E-01],
	[3.3705000000E+04, 3.5694328411E+01, 5.5912770682E+00, 1.7976213873E+01, 3.8096001586E+00, 9.6132005487E-01],
	[3.3710000000E+04, 3.5703391773E+01, 5.5913023404E+00, 1.7984976160E+01, 3.8101085129E+00, 9.6134023504E-01],
	[3.3715000000E+04, 3.5712456091E+01, 5.5913276090E+00, 1.7993741418E+01, 3.8106167094E+00, 9.6136040374E-01],
	[3.3720000000E+04, 3.5721521365E+01, 5.5913528740E+00, 1.8002509645E+01, 3.8111247482E+00, 9.6138056099E-01],
	[3.3725000000E+04, 3.5730587596E+01, 5.5913781353E+00, 1.8011280844E+01, 3.8116326294E+00, 9.6140070679E-01],
	[3.3730000000E+04, 3.5739654784E+01, 5.5914033929E+00, 1.8020055014E+01, 3.8121403530E+00, 9.6142084115E-01],
	[3.3735000000E+04, 3.5748722928E+01, 5.5914286470E+00, 1.8028832155E+01, 3.8126479189E+00, 9.6144096408E-01],
	[3.3740000000E+04, 3.5757792028E+01, 5.5914538974E+00, 1.8037612270E+01, 3.8131553274E+00, 9.6146107558E-01],
	[3.3745000000E+04, 3.5766862085E+01, 5.5914791442E+00, 1.8046395357E+01, 3.8136625783E+00, 9.6148117566E-01],
	[3.3750000000E+04, 3.5775933098E+01, 5.5915043874E+00, 1.8055181418E+01, 3.8141696718E+00, 9.6150126432E-01],
	[3.3755000000E+04, 3.5785005067E+01, 5.5915296269E+00, 1.8063970454E+01, 3.8146766079E+00, 9.6152134157E-01],
	[3.3760000000E+04, 3.5794077993E+01, 5.5915548628E+00, 1.8072762464E+01, 3.8151833865E+00, 9.6154140742E-01],
	[3.3765000000E+04, 3.5803151875E+01, 5.5915800951E+00, 1.8081557450E+01, 3.8156900079E+00, 9.6156146188E-01],
	[3.3770000000E+04, 3.5812226713E+01, 5.5916053238E+00, 1.8090355411E+01, 3.8161964719E+00, 9.6158150495E-01],
	[3.3775000000E+04, 3.5821302507E+01, 5.5916305488E+00, 1.8099156349E+01, 3.8167027787E+00, 9.6160153665E-01],
	[3.3780000000E+04, 3.5830379257E+01, 5.5916557703E+00, 1.8107960264E+01, 3.8172089282E+00, 9.6162155696E-01],
	[3.3785000000E+04, 3.5839456963E+01, 5.5916809881E+00, 1.8116767157E+01, 3.8177149206E+00, 9.6164156591E-01],
	[3.3790000000E+04, 3.5848535625E+01, 5.5917062023E+00, 1.8125577028E+01, 3.8182207558E+00, 9.6166156350E-01],
	[3.3795000000E+04, 3.5857615243E+01, 5.5917314128E+00, 1.8134389878E+01, 3.8187264339E+00, 9.6168154974E-01],
	[3.3800000000E+04, 3.5866695817E+01, 5.5917566198E+00, 1.8143205707E+01, 3.8192319549E+00, 9.6170152462E-01],
	[3.3805000000E+04, 3.5875777347E+01, 5.5917818231E+00, 1.8152024516E+01, 3.8197373189E+00, 9.6172148817E-01],
	[3.3810000000E+04, 3.5884859833E+01, 5.5918070229E+00, 1.8160846306E+01, 3.8202425259E+00, 9.6174144039E-01],
	[3.3815000000E+04, 3.5893943274E+01, 5.5918322190E+00, 1.8169671076E+01, 3.8207475760E+00, 9.6176138128E-01],
	[3.3820000000E+04, 3.5903027672E+01, 5.5918574115E+00, 1.8178498828E+01, 3.8212524691E+00, 9.6178131084E-01],
	[3.3825000000E+04, 3.5912113025E+01, 5.5918826004E+00, 1.8187329562E+01, 3.8217572054E+00, 9.6180122910E-01],
	[3.3830000000E+04, 3.5921199333E+01, 5.5919077857E+00, 1.8196163279E+01, 3.8222617848E+00, 9.6182113605E-01],
	[3.3835000000E+04, 3.5930286598E+01, 5.5919329673E+00, 1.8204999980E+01, 3.8227662075E+00, 9.6184103170E-01],
	[3.3840000000E+04, 3.5939374817E+01, 5.5919581454E+00, 1.8213839664E+01, 3.8232704734E+00, 9.6186091605E-01],
	[3.3845000000E+04, 3.5948463993E+01, 5.5919833199E+00, 1.8222682333E+01, 3.8237745825E+00, 9.6188078912E-01],
	[3.3850000000E+04, 3.5957554124E+01, 5.5920084907E+00, 1.8231527986E+01, 3.8242785350E+00, 9.6190065091E-01],
	[3.3855000000E+04, 3.5966645210E+01, 5.5920336580E+00, 1.8240376625E+01, 3.8247823309E+00, 9.6192050143E-01],
	[3.3860000000E+04, 3.5975737252E+01, 5.5920588216E+00, 1.8249228251E+01, 3.8252859702E+00, 9.6194034068E-01],
	[3.3865000000E+04, 3.5984830249E+01, 5.5920839817E+00, 1.8258082863E+01, 3.8257894528E+00, 9.6196016867E-01],
	[3.3870000000E+04, 3.5993924202E+01, 5.5921091381E+00, 1.8266940462E+01, 3.8262927790E+00, 9.6197998541E-01],
	[3.3875000000E+04, 3.6003019109E+01, 5.5921342910E+00, 1.8275801049E+01, 3.8267959487E+00, 9.6199979090E-01],
	[3.3880000000E+04, 3.6012114972E+01, 5.5921594402E+00, 1.8284664625E+01, 3.8272989620E+00, 9.6201958515E-01],
	[3.3885000000E+04, 3.6021211791E+01, 5.5921845859E+00, 1.8293531189E+01, 3.8278018188E+00, 9.6203936817E-01],
	[3.3890000000E+04, 3.6030309564E+01, 5.5922097279E+00, 1.8302400743E+01, 3.8283045193E+00, 9.6205913997E-01],
	[3.3895000000E+04, 3.6039408293E+01, 5.5922348664E+00, 1.8311273287E+01, 3.8288070635E+00, 9.6207890054E-01],
	[3.3900000000E+04, 3.6048507977E+01, 5.5922600012E+00, 1.8320148822E+01, 3.8293094513E+00, 9.6209864991E-01],
	[3.3905000000E+04, 3.6057608615E+01, 5.5922851325E+00, 1.8329027348E+01, 3.8298116830E+00, 9.6211838806E-01],
	[3.3910000000E+04, 3.6066710209E+01, 5.5923102602E+00, 1.8337908866E+01, 3.8303137584E+00, 9.6213811502E-01],
	[3.3915000000E+04, 3.6075812758E+01, 5.5923353842E+00, 1.8346793376E+01, 3.8308156777E+00, 9.6215783079E-01],
	[3.3920000000E+04, 3.6084916262E+01, 5.5923605047E+00, 1.8355680879E+01, 3.8313174408E+00, 9.6217753537E-01],
	[3.3925000000E+04, 3.6094020720E+01, 5.5923856216E+00, 1.8364571375E+01, 3.8318190478E+00, 9.6219722877E-01],
	[3.3930000000E+04, 3.6103126134E+01, 5.5924107349E+00, 1.8373464866E+01, 3.8323204988E+00, 9.6221691100E-01],
	[3.3935000000E+04, 3.6112232502E+01, 5.5924358447E+00, 1.8382361351E+01, 3.8328217938E+00, 9.6223658207E-01],
	[3.3940000000E+04, 3.6121339825E+01, 5.5924609508E+00, 1.8391260832E+01, 3.8333229328E+00, 9.6225624198E-01],
	[3.3945000000E+04, 3.6130448103E+01, 5.5924860533E+00, 1.8400163308E+01, 3.8338239159E+00, 9.6227589073E-01],
	[3.3950000000E+04, 3.6139557335E+01, 5.5925111523E+00, 1.8409068780E+01, 3.8343247431E+00, 9.6229552834E-01],
	[3.3955000000E+04, 3.6148667522E+01, 5.5925362477E+00, 1.8417977250E+01, 3.8348254145E+00, 9.6231515481E-01],
	[3.3960000000E+04, 3.6157778664E+01, 5.5925613395E+00, 1.8426888717E+01, 3.8353259300E+00, 9.6233477015E-01],
	[3.3965000000E+04, 3.6166890760E+01, 5.5925864277E+00, 1.8435803182E+01, 3.8358262898E+00, 9.6235437436E-01],
	[3.3970000000E+04, 3.6176003811E+01, 5.5926115123E+00, 1.8444720645E+01, 3.8363264938E+00, 9.6237396746E-01],
	[3.3975000000E+04, 3.6185117816E+01, 5.5926365934E+00, 1.8453641108E+01, 3.8368265421E+00, 9.6239354944E-01],
	[3.3980000000E+04, 3.6194232776E+01, 5.5926616709E+00, 1.8462564570E+01, 3.8373264348E+00, 9.6241312032E-01],
	[3.3985000000E+04, 3.6203355381E+01, 5.5926874700E+00, 1.8471491033E+01, 3.8378265885E+00, 9.6243268010E-01],
	[3.3990000000E+04, 3.6212496998E+01, 5.5927152220E+00, 1.8480420496E+01, 3.8383277113E+00, 9.6245222878E-01],
	[3.3995000000E+04, 3.6221639578E+01, 5.5927429701E+00, 1.8489352961E+01, 3.8388286789E+00, 9.6247176639E-01],
	[3.4000000000E+04, 3.6230783122E+01, 5.5927707143E+00, 1.8498288428E+01, 3.8393294915E+00, 9.6249129291E-01],
	[3.4005000000E+04, 3.6239927629E+01, 5.5927984545E+00, 1.8507226897E+01, 3.8398301490E+00, 9.6251080836E-01],
	[3.4010000000E+04, 3.6249073098E+01, 5.5928261908E+00, 1.8516168370E+01, 3.8403306516E+00, 9.6253031275E-01],
	[3.4015000000E+04, 3.6258219531E+01, 5.5928539232E+00, 1.8525112846E+01, 3.8408309992E+00, 9.6254980608E-01],
	[3.4020000000E+04, 3.6267366926E+01, 5.5928816516E+00, 1.8534060327E+01, 3.8413311918E+00, 9.6256928836E-01],
	[3.4025000000E+04, 3.6276515285E+01, 5.5929093760E+00, 1.8543010812E+01, 3.8418312296E+00, 9.6258875959E-01],
	[3.4030000000E+04, 3.6285664606E+01, 5.5929370966E+00, 1.8551964303E+01, 3.8423311126E+00, 9.6260821978E-01],
	[3.4035000000E+04, 3.6294814891E+01, 5.5929648131E+00, 1.8560920800E+01, 3.8428308408E+00, 9.6262766895E-01],
	[3.4040000000E+04, 3.6303966138E+01, 5.5929925258E+00, 1.8569880303E+01, 3.8433304142E+00, 9.6264710708E-01],
	[3.4045000000E+04, 3.6313118348E+01, 5.5930202345E+00, 1.8578842813E+01, 3.8438298329E+00, 9.6266653420E-01],
	[3.4050000000E+04, 3.6322271520E+01, 5.5930479393E+00, 1.8587808331E+01, 3.8443290969E+00, 9.6268595031E-01],
	[3.4055000000E+04, 3.6331425655E+01, 5.5930756402E+00, 1.8596776858E+01, 3.8448282062E+00, 9.6270535541E-01],
	[3.4060000000E+04, 3.6340580753E+01, 5.5931033371E+00, 1.8605748393E+01, 3.8453271610E+00, 9.6272474952E-01],
	[3.4065000000E+04, 3.6349736814E+01, 5.5931310301E+00, 1.8614722937E+01, 3.8458259612E+00, 9.6274413263E-01],
	[3.4070000000E+04, 3.6358893837E+01, 5.5931587192E+00, 1.8623700491E+01, 3.8463246069E+00, 9.6276350475E-01],
	[3.4075000000E+04, 3.6368051822E+01, 5.5931864044E+00, 1.8632681056E+01, 3.8468230981E+00, 9.6278286590E-01],
	[3.4080000000E+04, 3.6377210770E+01, 5.5932140856E+00, 1.8641664632E+01, 3.8473214348E+00, 9.6280221608E-01],
	[3.4085000000E+04, 3.6386370681E+01, 5.5932417629E+00, 1.8650651220E+01, 3.8478196172E+00, 9.6282155529E-01],
	[3.4090000000E+04, 3.6395531554E+01, 5.5932694363E+00, 1.8659640819E+01, 3.8483176452E+00, 9.6284088354E-01],
	[3.4095000000E+04, 3.6404693389E+01, 5.5932971057E+00, 1.8668633432E+01, 3.8488155189E+00, 9.6286020084E-01],
	[3.4100000000E+04, 3.6413856187E+01, 5.5933247713E+00, 1.8677629058E+01, 3.8493132382E+00, 9.6287950720E-01],
	[3.4105000000E+04, 3.6423019946E+01, 5.5933524329E+00, 1.8686627697E+01, 3.8498108034E+00, 9.6289880262E-01],
	[3.4110000000E+04, 3.6432184669E+01, 5.5933800906E+00, 1.8695629352E+01, 3.8503082143E+00, 9.6291808710E-01],
	[3.4115000000E+04, 3.6441350353E+01, 5.5934077444E+00, 1.8704634021E+01, 3.8508054711E+00, 9.6293736066E-01],
	[3.4120000000E+04, 3.6450516999E+01, 5.5934353943E+00, 1.8713641706E+01, 3.8513025737E+00, 9.6295662331E-01],
	[3.4125000000E+04, 3.6459684608E+01, 5.5934630402E+00, 1.8722652407E+01, 3.8517995222E+00, 9.6297587503E-01],
	[3.4130000000E+04, 3.6468853179E+01, 5.5934906822E+00, 1.8731666124E+01, 3.8522963167E+00, 9.6299511586E-01],
	[3.4135000000E+04, 3.6478022711E+01, 5.5935183204E+00, 1.8740682859E+01, 3.8527929572E+00, 9.6301434578E-01],
	[3.4140000000E+04, 3.6487193206E+01, 5.5935459546E+00, 1.8749702612E+01, 3.8532894437E+00, 9.6303356482E-01],
	[3.4145000000E+04, 3.6496364663E+01, 5.5935735849E+00, 1.8758725383E+01, 3.8537857763E+00, 9.6305277297E-01],
	[3.4150000000E+04, 3.6505537081E+01, 5.5936012113E+00, 1.8767751174E+01, 3.8542819550E+00, 9.6307197023E-01],
	[3.4155000000E+04, 3.6514710462E+01, 5.5936288338E+00, 1.8776779984E+01, 3.8547779798E+00, 9.6309115663E-01],
	[3.4160000000E+04, 3.6523884804E+01, 5.5936564524E+00, 1.8785811814E+01, 3.8552738509E+00, 9.6311033216E-01],
	[3.4165000000E+04, 3.6533060108E+01, 5.5936840670E+00, 1.8794846664E+01, 3.8557695681E+00, 9.6312949683E-01],
	[3.4170000000E+04, 3.6542236374E+01, 5.5937116778E+00, 1.8803884536E+01, 3.8562651316E+00, 9.6314865065E-01],
	[3.4175000000E+04, 3.6551413602E+01, 5.5937392847E+00, 1.8812925430E+01, 3.8567605415E+00, 9.6316779363E-01],
	[3.4180000000E+04, 3.6560591791E+01, 5.5937668876E+00, 1.8821969347E+01, 3.8572557976E+00, 9.6318692576E-01],
	[3.4185000000E+04, 3.6569770942E+01, 5.5937944867E+00, 1.8831016286E+01, 3.8577509002E+00, 9.6320604706E-01],
	[3.4190000000E+04, 3.6578951055E+01, 5.5938220819E+00, 1.8840066249E+01, 3.8582458492E+00, 9.6322515754E-01],
	[3.4195000000E+04, 3.6588132129E+01, 5.5938496731E+00, 1.8849119236E+01, 3.8587406446E+00, 9.6324425719E-01],
	[3.4200000000E+04, 3.6597314164E+01, 5.5938772605E+00, 1.8858175247E+01, 3.8592352866E+00, 9.6326334604E-01],
	[3.4205000000E+04, 3.6606497161E+01, 5.5939048440E+00, 1.8867234284E+01, 3.8597297751E+00, 9.6328242408E-01],
	[3.4210000000E+04, 3.6615681120E+01, 5.5939324235E+00, 1.8876296347E+01, 3.8602241102E+00, 9.6330149131E-01],
	[3.4215000000E+04, 3.6624866040E+01, 5.5939599992E+00, 1.8885361436E+01, 3.8607182919E+00, 9.6332054776E-01],
	[3.4220000000E+04, 3.6634051921E+01, 5.5939875710E+00, 1.8894429552E+01, 3.8612123202E+00, 9.6333959342E-01],
	[3.4225000000E+04, 3.6643238764E+01, 5.5940151389E+00, 1.8903500695E+01, 3.8617061953E+00, 9.6335862830E-01],
	[3.4230000000E+04, 3.6652426568E+01, 5.5940427029E+00, 1.8912574867E+01, 3.8621999171E+00, 9.6337765240E-01],
	[3.4235000000E+04, 3.6661615333E+01, 5.5940702630E+00, 1.8921652067E+01, 3.8626934857E+00, 9.6339666574E-01],
	[3.4240000000E+04, 3.6670805059E+01, 5.5940978192E+00, 1.8930732296E+01, 3.8631869011E+00, 9.6341566832E-01],
	[3.4245000000E+04, 3.6679995747E+01, 5.5941253715E+00, 1.8939815556E+01, 3.8636801634E+00, 9.6343466014E-01],
	[3.4250000000E+04, 3.6689187396E+01, 5.5941529200E+00, 1.8948901845E+01, 3.8641732725E+00, 9.6345364122E-01],
	[3.4255000000E+04, 3.6698380005E+01, 5.5941804645E+00, 1.8957991166E+01, 3.8646662287E+00, 9.6347261156E-01],
	[3.4260000000E+04, 3.6707573576E+01, 5.5942080052E+00, 1.8967083518E+01, 3.8651590317E+00, 9.6349157116E-01],
	[3.4265000000E+04, 3.6716768108E+01, 5.5942355420E+00, 1.8976178902E+01, 3.8656516819E+00, 9.6351052004E-01],
	[3.4270000000E+04, 3.6725963601E+01, 5.5942630749E+00, 1.8985277319E+01, 3.8661441790E+00, 9.6352945820E-01],
	[3.4275000000E+04, 3.6735160054E+01, 5.5942906040E+00, 1.8994378769E+01, 3.8666365233E+00, 9.6354838564E-01],
	[3.4280000000E+04, 3.6744357469E+01, 5.5943181291E+00, 1.9003483253E+01, 3.8671287147E+00, 9.6356730237E-01],
	[3.4285000000E+04, 3.6753555844E+01, 5.5943456504E+00, 1.9012590771E+01, 3.8676207533E+00, 9.6358620841E-01],
	[3.4290000000E+04, 3.6762755181E+01, 5.5943731678E+00, 1.9021701324E+01, 3.8681126391E+00, 9.6360510375E-01],
	[3.4295000000E+04, 3.6771955478E+01, 5.5944006813E+00, 1.9030814912E+01, 3.8686043722E+00, 9.6362398840E-01],
	[3.4300000000E+04, 3.6781156735E+01, 5.5944281909E+00, 1.9039931536E+01, 3.8690959525E+00, 9.6364286237E-01],
	[3.4305000000E+04, 3.6790358954E+01, 5.5944556967E+00, 1.9049051197E+01, 3.8695873802E+00, 9.6366172567E-01],
	[3.4310000000E+04, 3.6799562133E+01, 5.5944831986E+00, 1.9058173896E+01, 3.8700786553E+00, 9.6368057830E-01],
	[3.4315000000E+04, 3.6808766272E+01, 5.5945106966E+00, 1.9067299632E+01, 3.8705697778E+00, 9.6369942026E-01],
	[3.4320000000E+04, 3.6817971373E+01, 5.5945381907E+00, 1.9076428406E+01, 3.8710607477E+00, 9.6371825157E-01],
	[3.4325000000E+04, 3.6827177433E+01, 5.5945656810E+00, 1.9085560219E+01, 3.8715515652E+00, 9.6373707224E-01],
	[3.4330000000E+04, 3.6836384455E+01, 5.5945931674E+00, 1.9094695072E+01, 3.8720422301E+00, 9.6375588226E-01],
	[3.4335000000E+04, 3.6845592436E+01, 5.5946206500E+00, 1.9103832964E+01, 3.8725327427E+00, 9.6377468164E-01],
	[3.4340000000E+04, 3.6854801378E+01, 5.5946481286E+00, 1.9112973898E+01, 3.8730231029E+00, 9.6379347040E-01],
	[3.4345000000E+04, 3.6864011281E+01, 5.5946756034E+00, 1.9122117872E+01, 3.8735133107E+00, 9.6381224853E-01],
	[3.4350000000E+04, 3.6873222144E+01, 5.5947030744E+00, 1.9131264888E+01, 3.8740033662E+00, 9.6383101605E-01],
	[3.4355000000E+04, 3.6882433967E+01, 5.5947305415E+00, 1.9140414947E+01, 3.8744932695E+00, 9.6384977295E-01],
	[3.4360000000E+04, 3.6891646750E+01, 5.5947580047E+00, 1.9149568048E+01, 3.8749830205E+00, 9.6386851925E-01],
	[3.4365000000E+04, 3.6900860494E+01, 5.5947854640E+00, 1.9158724193E+01, 3.8754726193E+00, 9.6388725495E-01],
	[3.4370000000E+04, 3.6910075197E+01, 5.5948129195E+00, 1.9167883381E+01, 3.8759620660E+00, 9.6390598005E-01],
	[3.4375000000E+04, 3.6919290861E+01, 5.5948403712E+00, 1.9177045615E+01, 3.8764513606E+00, 9.6392469457E-01],
	[3.4380000000E+04, 3.6928507485E+01, 5.5948678189E+00, 1.9186210893E+01, 3.8769405032E+00, 9.6394339850E-01],
	[3.4385000000E+04, 3.6937725069E+01, 5.5948952629E+00, 1.9195379217E+01, 3.8774294937E+00, 9.6396209186E-01],
	[3.4390000000E+04, 3.6946943613E+01, 5.5949227029E+00, 1.9204550587E+01, 3.8779183322E+00, 9.6398077465E-01],
	[3.4395000000E+04, 3.6956163117E+01, 5.5949501391E+00, 1.9213725005E+01, 3.8784070188E+00, 9.6399944687E-01],
	[3.4400000000E+04, 3.6965383581E+01, 5.5949775715E+00, 1.9222902469E+01, 3.8788955534E+00, 9.6401810854E-01],
	[3.4405000000E+04, 3.6974605005E+01, 5.5950050000E+00, 1.9232082982E+01, 3.8793839362E+00, 9.6403675965E-01],
	[3.4410000000E+04, 3.6983827388E+01, 5.5950324246E+00, 1.9241266543E+01, 3.8798721672E+00, 9.6405540022E-01],
	[3.4415000000E+04, 3.6993050732E+01, 5.5950598454E+00, 1.9250453153E+01, 3.8803602464E+00, 9.6407403025E-01],
	[3.4420000000E+04, 3.7002275035E+01, 5.5950872624E+00, 1.9259642813E+01, 3.8808481738E+00, 9.6409264974E-01],
	[3.4425000000E+04, 3.7011500298E+01, 5.5951146755E+00, 1.9268835523E+01, 3.8813359496E+00, 9.6411125870E-01],
	[3.4430000000E+04, 3.7020726521E+01, 5.5951420848E+00, 1.9278031284E+01, 3.8818235736E+00, 9.6412985714E-01],
	[3.4435000000E+04, 3.7029953703E+01, 5.5951694902E+00, 1.9287230097E+01, 3.8823110461E+00, 9.6414844507E-01],
	[3.4440000000E+04, 3.7039181845E+01, 5.5951968917E+00, 1.9296431961E+01, 3.8827983669E+00, 9.6416702248E-01],
	[3.4445000000E+04, 3.7048410947E+01, 5.5952242895E+00, 1.9305636878E+01, 3.8832855362E+00, 9.6418558939E-01],
	[3.4450000000E+04, 3.7057641008E+01, 5.5952516833E+00, 1.9314844848E+01, 3.8837725540E+00, 9.6420414580E-01],
	[3.4455000000E+04, 3.7066872028E+01, 5.5952790734E+00, 1.9324055871E+01, 3.8842594204E+00, 9.6422269171E-01],
	[3.4460000000E+04, 3.7076104008E+01, 5.5953064596E+00, 1.9333269949E+01, 3.8847461353E+00, 9.6424122714E-01],
	[3.4465000000E+04, 3.7085336948E+01, 5.5953338419E+00, 1.9342487082E+01, 3.8852326988E+00, 9.6425975209E-01],
	[3.4470000000E+04, 3.7094570847E+01, 5.5953612205E+00, 1.9351707270E+01, 3.8857191110E+00, 9.6427826656E-01],
	[3.4475000000E+04, 3.7103805705E+01, 5.5953885951E+00, 1.9360930514E+01, 3.8862053718E+00, 9.6429677057E-01],
	[3.4480000000E+04, 3.7113041522E+01, 5.5954159660E+00, 1.9370156815E+01, 3.8866914814E+00, 9.6431526411E-01],
	[3.4485000000E+04, 3.7122278299E+01, 5.5954433330E+00, 1.9379386172E+01, 3.8871774398E+00, 9.6433374719E-01],
	[3.4490000000E+04, 3.7131516035E+01, 5.5954706962E+00, 1.9388618587E+01, 3.8876632470E+00, 9.6435221982E-01],
	[3.4495000000E+04, 3.7140754730E+01, 5.5954980555E+00, 1.9397854061E+01, 3.8881489030E+00, 9.6437068200E-01],
	[3.4500000000E+04, 3.7149994384E+01, 5.5955254111E+00, 1.9407092593E+01, 3.8886344080E+00, 9.6438913375E-01],
	[3.4505000000E+04, 3.7159234998E+01, 5.5955527627E+00, 1.9416334185E+01, 3.8891197618E+00, 9.6440757506E-01],
	[3.4510000000E+04, 3.7168476570E+01, 5.5955801106E+00, 1.9425578836E+01, 3.8896049647E+00, 9.6442600595E-01],
	[3.4515000000E+04, 3.7177719101E+01, 5.5956074546E+00, 1.9434826548E+01, 3.8900900165E+00, 9.6444442641E-01],
	[3.4520000000E+04, 3.7186962592E+01, 5.5956347948E+00, 1.9444077321E+01, 3.8905749174E+00, 9.6446283645E-01],
	[3.4525000000E+04, 3.7196207041E+01, 5.5956621312E+00, 1.9453331156E+01, 3.8910596674E+00, 9.6448123609E-01],
	[3.4530000000E+04, 3.7205452450E+01, 5.5956894637E+00, 1.9462588053E+01, 3.8915442666E+00, 9.6449962532E-01],
	[3.4535000000E+04, 3.7214719664E+01, 5.5957190271E+00, 1.9471848012E+01, 3.8920300239E+00, 9.6451800415E-01],
	[3.4540000000E+04, 3.7223991457E+01, 5.5957489735E+00, 1.9481111035E+01, 3.8925158577E+00, 9.6453637260E-01],
	[3.4545000000E+04, 3.7233264218E+01, 5.5957789158E+00, 1.9490377122E+01, 3.8930015412E+00, 9.6455473065E-01],
	[3.4550000000E+04, 3.7242537947E+01, 5.5958088538E+00, 1.9499646274E+01, 3.8934870743E+00, 9.6457307832E-01],
	[3.4555000000E+04, 3.7251812643E+01, 5.5958387877E+00, 1.9508918490E+01, 3.8939724572E+00, 9.6459141562E-01],
	[3.4560000000E+04, 3.7261088306E+01, 5.5958687175E+00, 1.9518193772E+01, 3.8944576898E+00, 9.6460974255E-01],
	[3.4565000000E+04, 3.7270364936E+01, 5.5958986430E+00, 1.9527472120E+01, 3.8949427723E+00, 9.6462805912E-01],
	[3.4570000000E+04, 3.7279642534E+01, 5.5959285644E+00, 1.9536753535E+01, 3.8954277046E+00, 9.6464636533E-01],
	[3.4575000000E+04, 3.7288921098E+01, 5.5959584816E+00, 1.9546038018E+01, 3.8959124868E+00, 9.6466466119E-01],
	[3.4580000000E+04, 3.7298200630E+01, 5.5959883947E+00, 1.9555325568E+01, 3.8963971189E+00, 9.6468294671E-01],
	[3.4585000000E+04, 3.7307481129E+01, 5.5960183036E+00, 1.9564616186E+01, 3.8968816010E+00, 9.6470122189E-01],
	[3.4590000000E+04, 3.7316762595E+01, 5.5960482083E+00, 1.9573909874E+01, 3.8973659331E+00, 9.6471948673E-01],
	[3.4595000000E+04, 3.7326045028E+01, 5.5960781089E+00, 1.9583206631E+01, 3.8978501152E+00, 9.6473774125E-01],
	[3.4600000000E+04, 3.7335328428E+01, 5.5961080053E+00, 1.9592506459E+01, 3.8983341475E+00, 9.6475598544E-01],
	[3.4605000000E+04, 3.7344612795E+01, 5.5961378975E+00, 1.9601809357E+01, 3.8988180298E+00, 9.6477421932E-01],
	[3.4610000000E+04, 3.7353898129E+01, 5.5961677856E+00, 1.9611115327E+01, 3.8993017624E+00, 9.6479244289E-01],
	[3.4615000000E+04, 3.7363184430E+01, 5.5961976696E+00, 1.9620424368E+01, 3.8997853451E+00, 9.6481065615E-01],
	[3.4620000000E+04, 3.7372471698E+01, 5.5962275493E+00, 1.9629736482E+01, 3.9002687781E+00, 9.6482885912E-01],
	[3.4625000000E+04, 3.7381759932E+01, 5.5962574249E+00, 1.9639051669E+01, 3.9007520614E+00, 9.6484705180E-01],
	[3.4630000000E+04, 3.7391049133E+01, 5.5962872964E+00, 1.9648369929E+01, 3.9012351950E+00, 9.6486523419E-01],
	[3.4635000000E+04, 3.7400339301E+01, 5.5963171637E+00, 1.9657691264E+01, 3.9017181790E+00, 9.6488340630E-01],
	[3.4640000000E+04, 3.7409630436E+01, 5.5963470269E+00, 1.9667015673E+01, 3.9022010134E+00, 9.6490156814E-01],
	[3.4645000000E+04, 3.7418922537E+01, 5.5963768859E+00, 1.9676343158E+01, 3.9026836982E+00, 9.6491971970E-01],
	[3.4650000000E+04, 3.7428215605E+01, 5.5964067407E+00, 1.9685673718E+01, 3.9031662335E+00, 9.6493786101E-01],
	[3.4655000000E+04, 3.7437509639E+01, 5.5964365914E+00, 1.9695007355E+01, 3.9036486194E+00, 9.6495599206E-01],
	[3.4660000000E+04, 3.7446804640E+01, 5.5964664380E+00, 1.9704344069E+01, 3.9041308558E+00, 9.6497411286E-01],
	[3.4665000000E+04, 3.7456100607E+01, 5.5964962804E+00, 1.9713683861E+01, 3.9046129428E+00, 9.6499222341E-01],
	[3.4670000000E+04, 3.7465397541E+01, 5.5965261187E+00, 1.9723026731E+01, 3.9050948805E+00, 9.6501032373E-01],
	[3.4675000000E+04, 3.7474695441E+01, 5.5965559528E+00, 1.9732372679E+01, 3.9055766689E+00, 9.6502841381E-01],
	[3.4680000000E+04, 3.7483994308E+01, 5.5965857828E+00, 1.9741721707E+01, 3.9060583080E+00, 9.6504649367E-01],
	[3.4685000000E+04, 3.7493294141E+01, 5.5966156086E+00, 1.9751073814E+01, 3.9065397978E+00, 9.6506456330E-01],
	[3.4690000000E+04, 3.7502594940E+01, 5.5966454303E+00, 1.9760429002E+01, 3.9070211385E+00, 9.6508262272E-01],
	[3.4695000000E+04, 3.7511896706E+01, 5.5966752479E+00, 1.9769787271E+01, 3.9075023300E+00, 9.6510067193E-01],
	[3.4700000000E+04, 3.7521199437E+01, 5.5967050613E+00, 1.9779148622E+01, 3.9079833724E+00, 9.6511871094E-01],
	[3.4705000000E+04, 3.7530503135E+01, 5.5967348706E+00, 1.9788513055E+01, 3.9084642657E+00, 9.6513673975E-01],
	[3.4710000000E+04, 3.7539807799E+01, 5.5967646758E+00, 1.9797880570E+01, 3.9089450100E+00, 9.6515475837E-01],
	[3.4715000000E+04, 3.7549113429E+01, 5.5967944768E+00, 1.9807251169E+01, 3.9094256053E+00, 9.6517276680E-01],
	[3.4720000000E+04, 3.7558420025E+01, 5.5968242737E+00, 1.9816624851E+01, 3.9099060517E+00, 9.6519076506E-01],
	[3.4725000000E+04, 3.7567727587E+01, 5.5968540664E+00, 1.9826001618E+01, 3.9103863491E+00, 9.6520875313E-01],
	[3.4730000000E+04, 3.7577036115E+01, 5.5968838550E+00, 1.9835381470E+01, 3.9108664977E+00, 9.6522673105E-01],
	[3.4735000000E+04, 3.7586345609E+01, 5.5969136395E+00, 1.9844764408E+01, 3.9113464974E+00, 9.6524469880E-01],
	[3.4740000000E+04, 3.7595656069E+01, 5.5969434199E+00, 1.9854150431E+01, 3.9118263484E+00, 9.6526265639E-01],
	[3.4745000000E+04, 3.7604967495E+01, 5.5969731961E+00, 1.9863539542E+01, 3.9123060505E+00, 9.6528060383E-01],
	[3.4750000000E+04, 3.7614279887E+01, 5.5970029682E+00, 1.9872931739E+01, 3.9127856040E+00, 9.6529854113E-01],
	[3.4755000000E+04, 3.7623593244E+01, 5.5970327362E+00, 1.9882327025E+01, 3.9132650088E+00, 9.6531646829E-01],
	[3.4760000000E+04, 3.7632907567E+01, 5.5970625001E+00, 1.9891725399E+01, 3.9137442650E+00, 9.6533438532E-01],
	[3.4765000000E+04, 3.7642222856E+01, 5.5970922598E+00, 1.9901126861E+01, 3.9142233726E+00, 9.6535229222E-01],
	[3.4770000000E+04, 3.7651539110E+01, 5.5971220154E+00, 1.9910531414E+01, 3.9147023316E+00, 9.6537018900E-01],
	[3.4775000000E+04, 3.7660856330E+01, 5.5971517669E+00, 1.9919939056E+01, 3.9151811421E+00, 9.6538807566E-01],
	[3.4780000000E+04, 3.7670174516E+01, 5.5971815143E+00, 1.9929349790E+01, 3.9156598042E+00, 9.6540595222E-01],
	[3.4785000000E+04, 3.7679493667E+01, 5.5972112576E+00, 1.9938763614E+01, 3.9161383178E+00, 9.6542381867E-01],
	[3.4790000000E+04, 3.7688813784E+01, 5.5972409967E+00, 1.9948180530E+01, 3.9166166830E+00, 9.6544167502E-01],
	[3.4795000000E+04, 3.7698134866E+01, 5.5972707317E+00, 1.9957600539E+01, 3.9170948999E+00, 9.6545952129E-01],
	[3.4800000000E+04, 3.7707456914E+01, 5.5973004626E+00, 1.9967023641E+01, 3.9175729685E+00, 9.6547735747E-01],
	[3.4805000000E+04, 3.7716779927E+01, 5.5973301894E+00, 1.9976449836E+01, 3.9180508887E+00, 9.6549518356E-01],
	[3.4810000000E+04, 3.7726103906E+01, 5.5973599121E+00, 1.9985879125E+01, 3.9185286608E+00, 9.6551299959E-01],
	[3.4815000000E+04, 3.7735428849E+01, 5.5973896307E+00, 1.9995311509E+01, 3.9190062847E+00, 9.6553080554E-01],
	[3.4820000000E+04, 3.7744754758E+01, 5.5974193451E+00, 2.0004746989E+01, 3.9194837604E+00, 9.6554860144E-01],
	[3.4825000000E+04, 3.7754081632E+01, 5.5974490555E+00, 2.0014185564E+01, 3.9199610880E+00, 9.6556638728E-01],
	[3.4830000000E+04, 3.7763409472E+01, 5.5974787617E+00, 2.0023627235E+01, 3.9204382675E+00, 9.6558416306E-01],
	[3.4835000000E+04, 3.7772738277E+01, 5.5975084639E+00, 2.0033072004E+01, 3.9209152990E+00, 9.6560192881E-01],
	[3.4840000000E+04, 3.7782068046E+01, 5.5975381619E+00, 2.0042519870E+01, 3.9213921826E+00, 9.6561968451E-01],
	[3.4845000000E+04, 3.7791398781E+01, 5.5975678559E+00, 2.0051970834E+01, 3.9218689181E+00, 9.6563743018E-01],
	[3.4850000000E+04, 3.7800730481E+01, 5.5975975457E+00, 2.0061424896E+01, 3.9223455058E+00, 9.6565516583E-01],
	[3.4855000000E+04, 3.7810063146E+01, 5.5976272314E+00, 2.0070882059E+01, 3.9228219456E+00, 9.6567289145E-01],
	[3.4860000000E+04, 3.7819396776E+01, 5.5976569130E+00, 2.0080342320E+01, 3.9232982375E+00, 9.6569060706E-01],
	[3.4865000000E+04, 3.7828731370E+01, 5.5976865906E+00, 2.0089805683E+01, 3.9237743817E+00, 9.6570831266E-01],
	[3.4870000000E+04, 3.7838066930E+01, 5.5977162640E+00, 2.0099272146E+01, 3.9242503781E+00, 9.6572600826E-01],
	[3.4875000000E+04, 3.7847403455E+01, 5.5977459333E+00, 2.0108741711E+01, 3.9247262268E+00, 9.6574369385E-01],
	[3.4880000000E+04, 3.7856740944E+01, 5.5977755985E+00, 2.0118214378E+01, 3.9252019278E+00, 9.6576136946E-01],
	[3.4885000000E+04, 3.7866079398E+01, 5.5978052597E+00, 2.0127690147E+01, 3.9256774812E+00, 9.6577903508E-01],
	[3.4890000000E+04, 3.7875418817E+01, 5.5978349167E+00, 2.0137169020E+01, 3.9261528871E+00, 9.6579669072E-01],
	[3.4895000000E+04, 3.7884759200E+01, 5.5978645697E+00, 2.0146650996E+01, 3.9266281453E+00, 9.6581433639E-01],
	[3.4900000000E+04, 3.7894100548E+01, 5.5978942185E+00, 2.0156136077E+01, 3.9271032561E+00, 9.6583197209E-01],
	[3.4905000000E+04, 3.7903442861E+01, 5.5979238633E+00, 2.0165624263E+01, 3.9275782194E+00, 9.6584959782E-01],
	[3.4910000000E+04, 3.7912786139E+01, 5.5979535040E+00, 2.0175115555E+01, 3.9280530353E+00, 9.6586721360E-01],
	[3.4915000000E+04, 3.7922130381E+01, 5.5979831406E+00, 2.0184609952E+01, 3.9285277037E+00, 9.6588481943E-01],
	[3.4920000000E+04, 3.7931475587E+01, 5.5980127731E+00, 2.0194107457E+01, 3.9290022249E+00, 9.6590241531E-01],
	[3.4925000000E+04, 3.7940821758E+01, 5.5980424015E+00, 2.0203608068E+01, 3.9294765987E+00, 9.6592000126E-01],
	[3.4930000000E+04, 3.7950168893E+01, 5.5980720258E+00, 2.0213111787E+01, 3.9299508252E+00, 9.6593757727E-01],
	[3.4935000000E+04, 3.7959516993E+01, 5.5981016461E+00, 2.0222618615E+01, 3.9304249046E+00, 9.6595514335E-01],
	[3.4940000000E+04, 3.7968866057E+01, 5.5981312623E+00, 2.0232128552E+01, 3.9308988367E+00, 9.6597269952E-01],
	[3.4945000000E+04, 3.7978216085E+01, 5.5981608743E+00, 2.0241641598E+01, 3.9313726217E+00, 9.6599024576E-01],
	[3.4950000000E+04, 3.7987567078E+01, 5.5981904824E+00, 2.0251157754E+01, 3.9318462596E+00, 9.6600778210E-01],
	[3.4955000000E+04, 3.7996919035E+01, 5.5982200863E+00, 2.0260677021E+01, 3.9323197504E+00, 9.6602530853E-01],
	[3.4960000000E+04, 3.8006271956E+01, 5.5982496861E+00, 2.0270199399E+01, 3.9327930942E+00, 9.6604282507E-01],
	[3.4965000000E+04, 3.8015625841E+01, 5.5982792819E+00, 2.0279724889E+01, 3.9332662910E+00, 9.6606033171E-01],
	[3.4970000000E+04, 3.8024980691E+01, 5.5983088736E+00, 2.0289253492E+01, 3.9337393409E+00, 9.6607782846E-01],
	[3.4975000000E+04, 3.8034336504E+01, 5.5983384612E+00, 2.0298785207E+01, 3.9342122439E+00, 9.6609531534E-01],
	[3.4980000000E+04, 3.8043693282E+01, 5.5983680448E+00, 2.0308320036E+01, 3.9346850000E+00, 9.6611279234E-01],
	[3.4985000000E+04, 3.8053051023E+01, 5.5983976243E+00, 2.0317857979E+01, 3.9351576093E+00, 9.6613025947E-01],
	[3.4990000000E+04, 3.8062409729E+01, 5.5984271997E+00, 2.0327399037E+01, 3.9356300718E+00, 9.6614771674E-01],
	[3.4995000000E+04, 3.8071769398E+01, 5.5984567710E+00, 2.0336943209E+01, 3.9361023875E+00, 9.6616516415E-01],
	[3.5000000000E+04, 3.8081130031E+01, 5.5984863383E+00, 2.0346490498E+01, 3.9365745565E+00, 9.6618260171E-01],
	[3.5005000000E+04, 3.8090491628E+01, 5.5985159015E+00, 2.0356056022E+01, 3.9370471445E+00, 9.6620002942E-01],
	[3.5010000000E+04, 3.8099854189E+01, 5.5985454606E+00, 2.0365624675E+01, 3.9375195854E+00, 9.6621744730E-01],
	[3.5015000000E+04, 3.8109217714E+01, 5.5985750157E+00, 2.0375196457E+01, 3.9379918795E+00, 9.6623485534E-01],
	[3.5020000000E+04, 3.8118582202E+01, 5.5986045667E+00, 2.0384771369E+01, 3.9384640266E+00, 9.6625225355E-01],
	[3.5025000000E+04, 3.8127947655E+01, 5.5986341136E+00, 2.0394349412E+01, 3.9389360269E+00, 9.6626964194E-01],
	[3.5030000000E+04, 3.8137314070E+01, 5.5986636565E+00, 2.0403930586E+01, 3.9394078805E+00, 9.6628702051E-01],
	[3.5035000000E+04, 3.8146681450E+01, 5.5986931953E+00, 2.0413514893E+01, 3.9398795872E+00, 9.6630438927E-01],
	[3.5040000000E+04, 3.8156049793E+01, 5.5987227301E+00, 2.0423102331E+01, 3.9403511472E+00, 9.6632174823E-01],
	[3.5045000000E+04, 3.8165419099E+01, 5.5987522608E+00, 2.0432692903E+01, 3.9408225606E+00, 9.6633909739E-01],
	[3.5050000000E+04, 3.8174789369E+01, 5.5987817875E+00, 2.0442286608E+01, 3.9412938273E+00, 9.6635643675E-01],
	[3.5055000000E+04, 3.8184160603E+01, 5.5988113100E+00, 2.0451883447E+01, 3.9417649474E+00, 9.6637376633E-01],
	[3.5060000000E+04, 3.8193532800E+01, 5.5988408286E+00, 2.0461483421E+01, 3.9422359209E+00, 9.6639108612E-01],
	[3.5065000000E+04, 3.8202905960E+01, 5.5988703431E+00, 2.0471086531E+01, 3.9427067479E+00, 9.6640839614E-01],
	[3.5070000000E+04, 3.8212280084E+01, 5.5988998535E+00, 2.0480692776E+01, 3.9431774285E+00, 9.6642569639E-01],
	[3.5075000000E+04, 3.8221655171E+01, 5.5989293599E+00, 2.0490302158E+01, 3.9436479626E+00, 9.6644298688E-01],
	[3.5080000000E+04, 3.8231031221E+01, 5.5989588622E+00, 2.0499914676E+01, 3.9441183503E+00, 9.6646026760E-01],
	[3.5085000000E+04, 3.8240408235E+01, 5.5989883605E+00, 2.0509530333E+01, 3.9445885917E+00, 9.6647753858E-01],
	[3.5090000000E+04, 3.8249802497E+01, 5.5990195798E+00, 2.0519149127E+01, 3.9450597164E+00, 9.6649479981E-01],
	[3.5095000000E+04, 3.8259205653E+01, 5.5990516340E+00, 2.0528771061E+01, 3.9455311960E+00, 9.6651205129E-01],
	[3.5100000000E+04, 3.8268609780E+01, 5.5990836838E+00, 2.0538396133E+01, 3.9460025298E+00, 9.6652929304E-01],
	[3.5105000000E+04, 3.8278014878E+01, 5.5991157293E+00, 2.0548024346E+01, 3.9464737178E+00, 9.6654652507E-01],
	[3.5110000000E+04, 3.8287420949E+01, 5.5991477703E+00, 2.0557655699E+01, 3.9469447600E+00, 9.6656374736E-01],
	[3.5115000000E+04, 3.8296827990E+01, 5.5991798070E+00, 2.0567290193E+01, 3.9474156564E+00, 9.6658095994E-01],
	[3.5120000000E+04, 3.8306236003E+01, 5.5992118393E+00, 2.0576927829E+01, 3.9478864072E+00, 9.6659816281E-01],
	[3.5125000000E+04, 3.8315644988E+01, 5.5992438672E+00, 2.0586568607E+01, 3.9483570122E+00, 9.6661535597E-01],
	[3.5130000000E+04, 3.8325054943E+01, 5.5992758908E+00, 2.0596212527E+01, 3.9488274717E+00, 9.6663253944E-01],
	[3.5135000000E+04, 3.8334465870E+01, 5.5993079099E+00, 2.0605859592E+01, 3.9492977856E+00, 9.6664971320E-01],
	[3.5140000000E+04, 3.8343877768E+01, 5.5993399247E+00, 2.0615509800E+01, 3.9497679539E+00, 9.6666687728E-01],
	[3.5145000000E+04, 3.8353290638E+01, 5.5993719352E+00, 2.0625163152E+01, 3.9502379767E+00, 9.6668403168E-01],
	[3.5150000000E+04, 3.8362704478E+01, 5.5994039412E+00, 2.0634819650E+01, 3.9507078541E+00, 9.6670117639E-01],
	[3.5155000000E+04, 3.8372119290E+01, 5.5994359429E+00, 2.0644479293E+01, 3.9511775860E+00, 9.6671831144E-01],
	[3.5160000000E+04, 3.8381535073E+01, 5.5994679402E+00, 2.0654142083E+01, 3.9516471726E+00, 9.6673543682E-01],
	[3.5165000000E+04, 3.8390951827E+01, 5.5994999332E+00, 2.0663808020E+01, 3.9521166138E+00, 9.6675255254E-01],
	[3.5170000000E+04, 3.8400369552E+01, 5.5995319218E+00, 2.0673477104E+01, 3.9525859097E+00, 9.6676965861E-01],
	[3.5175000000E+04, 3.8409788248E+01, 5.5995639060E+00, 2.0683149335E+01, 3.9530550604E+00, 9.6678675503E-01],
	[3.5180000000E+04, 3.8419207915E+01, 5.5995958858E+00, 2.0692824716E+01, 3.9535240658E+00, 9.6680384180E-01],
	[3.5185000000E+04, 3.8428628553E+01, 5.5996278613E+00, 2.0702503246E+01, 3.9539929261E+00, 9.6682091894E-01],
	[3.5190000000E+04, 3.8438050161E+01, 5.5996598325E+00, 2.0712184925E+01, 3.9544616412E+00, 9.6683798645E-01],
	[3.5195000000E+04, 3.8447472741E+01, 5.5996917992E+00, 2.0721869755E+01, 3.9549302112E+00, 9.6685504433E-01],
	[3.5200000000E+04, 3.8456896291E+01, 5.5997237617E+00, 2.0731557735E+01, 3.9553986361E+00, 9.6687209259E-01],
	[3.5205000000E+04, 3.8466320812E+01, 5.5997557197E+00, 2.0741248867E+01, 3.9558669161E+00, 9.6688913124E-01],
	[3.5210000000E+04, 3.8475746304E+01, 5.5997876734E+00, 2.0750943151E+01, 3.9563350510E+00, 9.6690616028E-01],
	[3.5215000000E+04, 3.8485172766E+01, 5.5998196228E+00, 2.0760640588E+01, 3.9568030410E+00, 9.6692317972E-01],
	[3.5220000000E+04, 3.8494600200E+01, 5.5998515678E+00, 2.0770341177E+01, 3.9572708861E+00, 9.6694018956E-01],
	[3.5225000000E+04, 3.8504028603E+01, 5.5998835084E+00, 2.0780044921E+01, 3.9577385864E+00, 9.6695718982E-01],
	[3.5230000000E+04, 3.8513457978E+01, 5.5999154447E+00, 2.0789751819E+01, 3.9582061418E+00, 9.6697418048E-01],
	[3.5235000000E+04, 3.8522888322E+01, 5.5999473766E+00, 2.0799461871E+01, 3.9586735525E+00, 9.6699116157E-01],
	[3.5240000000E+04, 3.8532319638E+01, 5.5999793042E+00, 2.0809175080E+01, 3.9591408184E+00, 9.6700813308E-01],
	[3.5245000000E+04, 3.8541751924E+01, 5.6000112275E+00, 2.0818891444E+01, 3.9596079396E+00, 9.6702509503E-01],
	[3.5250000000E+04, 3.8551185180E+01, 5.6000431464E+00, 2.0828610965E+01, 3.9600749162E+00, 9.6704204742E-01],
	[3.5255000000E+04, 3.8560619406E+01, 5.6000750609E+00, 2.0838333643E+01, 3.9605417481E+00, 9.6705899024E-01],
	[3.5260000000E+04, 3.8570054603E+01, 5.6001069711E+00, 2.0848059479E+01, 3.9610084355E+00, 9.6707592352E-01],
	[3.5265000000E+04, 3.8579490771E+01, 5.6001388770E+00, 2.0857788473E+01, 3.9614749783E+00, 9.6709284726E-01],
	[3.5270000000E+04, 3.8588927908E+01, 5.6001707785E+00, 2.0867520627E+01, 3.9619413767E+00, 9.6710976145E-01],
	[3.5275000000E+04, 3.8598366016E+01, 5.6002026757E+00, 2.0877255940E+01, 3.9624076306E+00, 9.6712666611E-01],
	[3.5280000000E+04, 3.8607805094E+01, 5.6002345685E+00, 2.0886994412E+01, 3.9628737400E+00, 9.6714356125E-01],
	[3.5285000000E+04, 3.8617245142E+01, 5.6002664570E+00, 2.0896736046E+01, 3.9633397051E+00, 9.6716044686E-01],
	[3.5290000000E+04, 3.8626686160E+01, 5.6002983412E+00, 2.0906480841E+01, 3.9638055259E+00, 9.6717732296E-01],
	[3.5295000000E+04, 3.8636128148E+01, 5.6003302210E+00, 2.0916228798E+01, 3.9642712023E+00, 9.6719418954E-01],
	[3.5300000000E+04, 3.8645571107E+01, 5.6003620965E+00, 2.0925979917E+01, 3.9647367346E+00, 9.6721104662E-01],
	[3.5305000000E+04, 3.8655015035E+01, 5.6003939677E+00, 2.0935734199E+01, 3.9652021225E+00, 9.6722789421E-01],
	[3.5310000000E+04, 3.8664459933E+01, 5.6004258345E+00, 2.0945491645E+01, 3.9656673664E+00, 9.6724473230E-01],
	[3.5315000000E+04, 3.8673905802E+01, 5.6004576970E+00, 2.0955252254E+01, 3.9661324661E+00, 9.6726156090E-01],
	[3.5320000000E+04, 3.8683352640E+01, 5.6004895552E+00, 2.0965016029E+01, 3.9665974217E+00, 9.6727838002E-01],
	[3.5325000000E+04, 3.8692800448E+01, 5.6005214091E+00, 2.0974782969E+01, 3.9670622332E+00, 9.6729518967E-01],
	[3.5330000000E+04, 3.8702249226E+01, 5.6005532586E+00, 2.0984553075E+01, 3.9675269007E+00, 9.6731198984E-01],
	[3.5335000000E+04, 3.8711698973E+01, 5.6005851038E+00, 2.0994326347E+01, 3.9679914243E+00, 9.6732878055E-01],
	[3.5340000000E+04, 3.8721149691E+01, 5.6006169446E+00, 2.1004102786E+01, 3.9684558039E+00, 9.6734556181E-01],
	[3.5345000000E+04, 3.8730601378E+01, 5.6006487812E+00, 2.1013882393E+01, 3.9689200397E+00, 9.6736233361E-01],
	[3.5350000000E+04, 3.8740054034E+01, 5.6006806134E+00, 2.1023665168E+01, 3.9693841315E+00, 9.6737909596E-01],
	[3.5355000000E+04, 3.8749507661E+01, 5.6007124413E+00, 2.1033451112E+01, 3.9698480796E+00, 9.6739584887E-01],
	[3.5360000000E+04, 3.8758962256E+01, 5.6007442649E+00, 2.1043240225E+01, 3.9703118839E+00, 9.6741259235E-01],
	[3.5365000000E+04, 3.8768417822E+01, 5.6007760841E+00, 2.1053032508E+01, 3.9707755445E+00, 9.6742932639E-01],
	[3.5370000000E+04, 3.8777874357E+01, 5.6008078991E+00, 2.1062827961E+01, 3.9712390614E+00, 9.6744605101E-01],
	[3.5375000000E+04, 3.8787331861E+01, 5.6008397097E+00, 2.1072626586E+01, 3.9717024346E+00, 9.6746276622E-01],
	[3.5380000000E+04, 3.8796790335E+01, 5.6008715160E+00, 2.1082428382E+01, 3.9721656643E+00, 9.6747947201E-01],
	[3.5385000000E+04, 3.8806249778E+01, 5.6009033180E+00, 2.1092233351E+01, 3.9726287503E+00, 9.6749616839E-01],
	[3.5390000000E+04, 3.8815710191E+01, 5.6009351157E+00, 2.1102041492E+01, 3.9730916928E+00, 9.6751285537E-01],
	[3.5395000000E+04, 3.8825171573E+01, 5.6009669091E+00, 2.1111852807E+01, 3.9735544919E+00, 9.6752953296E-01],
	[3.5400000000E+04, 3.8834633924E+01, 5.6009986981E+00, 2.1121667296E+01, 3.9740171475E+00, 9.6754620115E-01],
	[3.5405000000E+04, 3.8844097245E+01, 5.6010304829E+00, 2.1131484959E+01, 3.9744796597E+00, 9.6756285996E-01],
	[3.5410000000E+04, 3.8853561535E+01, 5.6010622633E+00, 2.1141305797E+01, 3.9749420285E+00, 9.6757950940E-01],
	[3.5415000000E+04, 3.8863026794E+01, 5.6010940395E+00, 2.1151129811E+01, 3.9754042540E+00, 9.6759614945E-01],
	[3.5420000000E+04, 3.8872493022E+01, 5.6011258113E+00, 2.1160957001E+01, 3.9758663362E+00, 9.6761278015E-01],
	[3.5425000000E+04, 3.8881960219E+01, 5.6011575788E+00, 2.1170787369E+01, 3.9763282752E+00, 9.6762940148E-01],
	[3.5430000000E+04, 3.8891428385E+01, 5.6011893420E+00, 2.1180620913E+01, 3.9767900710E+00, 9.6764601345E-01],
	[3.5435000000E+04, 3.8900897520E+01, 5.6012211010E+00, 2.1190457636E+01, 3.9772517236E+00, 9.6766261608E-01],
	[3.5440000000E+04, 3.8910367624E+01, 5.6012528556E+00, 2.1200297537E+01, 3.9777132330E+00, 9.6767920936E-01],
	[3.5445000000E+04, 3.8919838698E+01, 5.6012846059E+00, 2.1210140618E+01, 3.9781745994E+00, 9.6769579330E-01],
	[3.5450000000E+04, 3.8929310740E+01, 5.6013163519E+00, 2.1219986878E+01, 3.9786358228E+00, 9.6771236791E-01],
	[3.5455000000E+04, 3.8938783751E+01, 5.6013480937E+00, 2.1229836318E+01, 3.9790969031E+00, 9.6772893319E-01],
	[3.5460000000E+04, 3.8948257730E+01, 5.6013798311E+00, 2.1239688939E+01, 3.9795578405E+00, 9.6774548915E-01],
	[3.5465000000E+04, 3.8957732679E+01, 5.6014115642E+00, 2.1249544742E+01, 3.9800186350E+00, 9.6776203579E-01],
	[3.5470000000E+04, 3.8967208596E+01, 5.6014432931E+00, 2.1259403727E+01, 3.9804792866E+00, 9.6777857312E-01],
	[3.5475000000E+04, 3.8976685482E+01, 5.6014750176E+00, 2.1269265895E+01, 3.9809397953E+00, 9.6779510115E-01],
	[3.5480000000E+04, 3.8986163337E+01, 5.6015067379E+00, 2.1279131245E+01, 3.9814001612E+00, 9.6781161988E-01],
	[3.5485000000E+04, 3.8995642161E+01, 5.6015384538E+00, 2.1288999780E+01, 3.9818603844E+00, 9.6782812932E-01],
	[3.5490000000E+04, 3.9005121953E+01, 5.6015701655E+00, 2.1298871499E+01, 3.9823204649E+00, 9.6784462946E-01],
	[3.5495000000E+04, 3.9014602713E+01, 5.6016018729E+00, 2.1308746403E+01, 3.9827804027E+00, 9.6786112033E-01],
	[3.5500000000E+04, 3.9024084442E+01, 5.6016335760E+00, 2.1318624492E+01, 3.9832401978E+00, 9.6787760192E-01],
	[3.5505000000E+04, 3.9033567140E+01, 5.6016652748E+00, 2.1328505768E+01, 3.9836998504E+00, 9.6789407424E-01],
	[3.5510000000E+04, 3.9043050806E+01, 5.6016969693E+00, 2.1338390230E+01, 3.9841593603E+00, 9.6791053729E-01],
	[3.5515000000E+04, 3.9052535441E+01, 5.6017286596E+00, 2.1348277879E+01, 3.9846187278E+00, 9.6792699109E-01],
	[3.5520000000E+04, 3.9062021043E+01, 5.6017603456E+00, 2.1358168716E+01, 3.9850779528E+00, 9.6794343563E-01],
	[3.5525000000E+04, 3.9071507615E+01, 5.6017920272E+00, 2.1368062742E+01, 3.9855370354E+00, 9.6795987092E-01],
	[3.5530000000E+04, 3.9080995154E+01, 5.6018237046E+00, 2.1377959957E+01, 3.9859959755E+00, 9.6797629697E-01],
	[3.5535000000E+04, 3.9090483662E+01, 5.6018553778E+00, 2.1387860361E+01, 3.9864547733E+00, 9.6799271379E-01],
	[3.5540000000E+04, 3.9099973138E+01, 5.6018870466E+00, 2.1397763955E+01, 3.9869134288E+00, 9.6800912137E-01],
	[3.5545000000E+04, 3.9109463583E+01, 5.6019187112E+00, 2.1407670741E+01, 3.9873719420E+00, 9.6802551973E-01],
	[3.5550000000E+04, 3.9118954995E+01, 5.6019503715E+00, 2.1417580717E+01, 3.9878303130E+00, 9.6804190886E-01],
	[3.5555000000E+04, 3.9128447376E+01, 5.6019820275E+00, 2.1427493885E+01, 3.9882885418E+00, 9.6805828879E-01],
	[3.5560000000E+04, 3.9137940724E+01, 5.6020136793E+00, 2.1437410246E+01, 3.9887466284E+00, 9.6807465950E-01],
	[3.5565000000E+04, 3.9147435041E+01, 5.6020453268E+00, 2.1447329800E+01, 3.9892045729E+00, 9.6809102101E-01],
	[3.5570000000E+04, 3.9156930326E+01, 5.6020769700E+00, 2.1457252547E+01, 3.9896623754E+00, 9.6810737333E-01],
	[3.5575000000E+04, 3.9166426578E+01, 5.6021086089E+00, 2.1467178489E+01, 3.9901200358E+00, 9.6812371645E-01],
	[3.5580000000E+04, 3.9175923799E+01, 5.6021402436E+00, 2.1477107626E+01, 3.9905775542E+00, 9.6814005039E-01],
	[3.5585000000E+04, 3.9185421988E+01, 5.6021718740E+00, 2.1487039957E+01, 3.9910349307E+00, 9.6815637514E-01],
	[3.5590000000E+04, 3.9194921144E+01, 5.6022035001E+00, 2.1496975485E+01, 3.9914921652E+00, 9.6817269072E-01],
	[3.5595000000E+04, 3.9204421268E+01, 5.6022351220E+00, 2.1506914209E+01, 3.9919492579E+00, 9.6818899714E-01],
	[3.5600000000E+04, 3.9213922360E+01, 5.6022667396E+00, 2.1516856131E+01, 3.9924062088E+00, 9.6820529439E-01],
	[3.5605000000E+04, 3.9223424420E+01, 5.6022983530E+00, 2.1526801250E+01, 3.9928630179E+00, 9.6822158248E-01],
	[3.5610000000E+04, 3.9232927447E+01, 5.6023299621E+00, 2.1536749567E+01, 3.9933196852E+00, 9.6823786142E-01],
	[3.5615000000E+04, 3.9242431443E+01, 5.6023615669E+00, 2.1546701083E+01, 3.9937762108E+00, 9.6825413121E-01],
	[3.5620000000E+04, 3.9251936405E+01, 5.6023931675E+00, 2.1556655799E+01, 3.9942325947E+00, 9.6827039186E-01],
	[3.5625000000E+04, 3.9261442336E+01, 5.6024247638E+00, 2.1566613714E+01, 3.9946888371E+00, 9.6828664338E-01],
	[3.5630000000E+04, 3.9270949234E+01, 5.6024563559E+00, 2.1576574831E+01, 3.9951449378E+00, 9.6830288577E-01],
	[3.5635000000E+04, 3.9280457099E+01, 5.6024879437E+00, 2.1586539148E+01, 3.9956008970E+00, 9.6831911903E-01],
	[3.5640000000E+04, 3.9289965932E+01, 5.6025195272E+00, 2.1596506667E+01, 3.9960567147E+00, 9.6833534317E-01],
	[3.5645000000E+04, 3.9299475733E+01, 5.6025511065E+00, 2.1606477388E+01, 3.9965123909E+00, 9.6835155820E-01],
	[3.5650000000E+04, 3.9308986500E+01, 5.6025826816E+00, 2.1616451312E+01, 3.9969679257E+00, 9.6836776412E-01],
	[3.5655000000E+04, 3.9318515160E+01, 5.6026160182E+00, 2.1626428440E+01, 3.9974243929E+00, 9.6838396094E-01],
	[3.5660000000E+04, 3.9328051933E+01, 5.6026500952E+00, 2.1636408772E+01, 3.9978811721E+00, 9.6840014866E-01],
	[3.5665000000E+04, 3.9337589682E+01, 5.6026841676E+00, 2.1646392308E+01, 3.9983378104E+00, 9.6841632728E-01],
	[3.5670000000E+04, 3.9347128406E+01, 5.6027182355E+00, 2.1656379049E+01, 3.9987943078E+00, 9.6843249681E-01],
	[3.5675000000E+04, 3.9356668106E+01, 5.6027522988E+00, 2.1666368997E+01, 3.9992506642E+00, 9.6844865727E-01],
	[3.5680000000E+04, 3.9366208782E+01, 5.6027863575E+00, 2.1676362150E+01, 3.9997068799E+00, 9.6846480864E-01],
	[3.5685000000E+04, 3.9375750433E+01, 5.6028204116E+00, 2.1686358511E+01, 4.0001629547E+00, 9.6848095094E-01],
	[3.5690000000E+04, 3.9385293059E+01, 5.6028544612E+00, 2.1696358079E+01, 4.0006188888E+00, 9.6849708417E-01],
	[3.5695000000E+04, 3.9394836660E+01, 5.6028885062E+00, 2.1706360855E+01, 4.0010746821E+00, 9.6851320834E-01],
	[3.5700000000E+04, 3.9404381237E+01, 5.6029225467E+00, 2.1716366840E+01, 4.0015303348E+00, 9.6852932345E-01],
	[3.5705000000E+04, 3.9413926789E+01, 5.6029565826E+00, 2.1726376034E+01, 4.0019858469E+00, 9.6854542951E-01],
	[3.5710000000E+04, 3.9423473317E+01, 5.6029906139E+00, 2.1736388438E+01, 4.0024412183E+00, 9.6856152652E-01],
	[3.5715000000E+04, 3.9433020820E+01, 5.6030246407E+00, 2.1746404053E+01, 4.0028964492E+00, 9.6857761449E-01],
	[3.5720000000E+04, 3.9442569297E+01, 5.6030586630E+00, 2.1756422878E+01, 4.0033515396E+00, 9.6859369342E-01],
	[3.5725000000E+04, 3.9452118750E+01, 5.6030926806E+00, 2.1766444915E+01, 4.0038064896E+00, 9.6860976332E-01],
	[3.5730000000E+04, 3.9461669179E+01, 5.6031266937E+00, 2.1776470164E+01, 4.0042612990E+00, 9.6862582419E-01],
	[3.5735000000E+04, 3.9471220582E+01, 5.6031607023E+00, 2.1786498626E+01, 4.0047159681E+00, 9.6864187604E-01],
	[3.5740000000E+04, 3.9480772960E+01, 5.6031947063E+00, 2.1796530301E+01, 4.0051704969E+00, 9.6865791888E-01],
	[3.5745000000E+04, 3.9490326313E+01, 5.6032287058E+00, 2.1806565190E+01, 4.0056248853E+00, 9.6867395270E-01],
	[3.5750000000E+04, 3.9499880641E+01, 5.6032627007E+00, 2.1816603294E+01, 4.0060791334E+00, 9.6868997751E-01],
	[3.5755000000E+04, 3.9509435944E+01, 5.6032966911E+00, 2.1826644612E+01, 4.0065332414E+00, 9.6870599333E-01],
	[3.5760000000E+04, 3.9518992222E+01, 5.6033306769E+00, 2.1836689146E+01, 4.0069872091E+00, 9.6872200014E-01],
	[3.5765000000E+04, 3.9528549475E+01, 5.6033646582E+00, 2.1846736897E+01, 4.0074410367E+00, 9.6873799797E-01],
	[3.5770000000E+04, 3.9538107703E+01, 5.6033986349E+00, 2.1856787864E+01, 4.0078947241E+00, 9.6875398681E-01],
	[3.5775000000E+04, 3.9547666905E+01, 5.6034326071E+00, 2.1866842048E+01, 4.0083482715E+00, 9.6876996667E-01],
	[3.5780000000E+04, 3.9557227082E+01, 5.6034665747E+00, 2.1876899451E+01, 4.0088016789E+00, 9.6878593755E-01],
	[3.5785000000E+04, 3.9566788234E+01, 5.6035005378E+00, 2.1886960072E+01, 4.0092549462E+00, 9.6880189946E-01],
	[3.5790000000E+04, 3.9576350361E+01, 5.6035344964E+00, 2.1897023912E+01, 4.0097080736E+00, 9.6881785241E-01],
	[3.5795000000E+04, 3.9585913462E+01, 5.6035684504E+00, 2.1907090972E+01, 4.0101610611E+00, 9.6883379639E-01],
	[3.5800000000E+04, 3.9595477538E+01, 5.6036023999E+00, 2.1917161252E+01, 4.0106139088E+00, 9.6884973142E-01],
	[3.5805000000E+04, 3.9605042588E+01, 5.6036363449E+00, 2.1927234753E+01, 4.0110666166E+00, 9.6886565750E-01],
	[3.5810000000E+04, 3.9614608613E+01, 5.6036702853E+00, 2.1937311475E+01, 4.0115191846E+00, 9.6888157464E-01],
	[3.5815000000E+04, 3.9624175612E+01, 5.6037042212E+00, 2.1947391420E+01, 4.0119716129E+00, 9.6889748283E-01],
	[3.5820000000E+04, 3.9633743586E+01, 5.6037381525E+00, 2.1957474586E+01, 4.0124239014E+00, 9.6891338209E-01],
	[3.5825000000E+04, 3.9643312534E+01, 5.6037720793E+00, 2.1967560977E+01, 4.0128760503E+00, 9.6892927242E-01],
	[3.5830000000E+04, 3.9652882456E+01, 5.6038060016E+00, 2.1977650590E+01, 4.0133280596E+00, 9.6894515382E-01],
	[3.5835000000E+04, 3.9662453353E+01, 5.6038399194E+00, 2.1987743429E+01, 4.0137799292E+00, 9.6896102631E-01],
	[3.5840000000E+04, 3.9672025224E+01, 5.6038738326E+00, 2.1997839492E+01, 4.0142316593E+00, 9.6897688988E-01],
	[3.5845000000E+04, 3.9681598070E+01, 5.6039077414E+00, 2.2007938780E+01, 4.0146832499E+00, 9.6899274454E-01],
	[3.5850000000E+04, 3.9691171889E+01, 5.6039416456E+00, 2.2018041295E+01, 4.0151347011E+00, 9.6900859030E-01],
	[3.5855000000E+04, 3.9700746683E+01, 5.6039755452E+00, 2.2028147036E+01, 4.0155860128E+00, 9.6902442715E-01],
	[3.5860000000E+04, 3.9710322451E+01, 5.6040094404E+00, 2.2038256004E+01, 4.0160371851E+00, 9.6904025512E-01],
	[3.5865000000E+04, 3.9719899193E+01, 5.6040433310E+00, 2.2048368201E+01, 4.0164882181E+00, 9.6905607419E-01],
	[3.5870000000E+04, 3.9729476909E+01, 5.6040772171E+00, 2.2058483625E+01, 4.0169391118E+00, 9.6907188438E-01],
	[3.5875000000E+04, 3.9739055599E+01, 5.6041110987E+00, 2.2068602279E+01, 4.0173898662E+00, 9.6908768569E-01],
	[3.5880000000E+04, 3.9748635264E+01, 5.6041449757E+00, 2.2078724162E+01, 4.0178404813E+00, 9.6910347813E-01],
	[3.5885000000E+04, 3.9758215902E+01, 5.6041788483E+00, 2.2088849276E+01, 4.0182909573E+00, 9.6911926170E-01],
	[3.5890000000E+04, 3.9767797514E+01, 5.6042127163E+00, 2.2098977619E+01, 4.0187412942E+00, 9.6913503640E-01],
	[3.5895000000E+04, 3.9777380100E+01, 5.6042465799E+00, 2.2109109195E+01, 4.0191914919E+00, 9.6915080225E-01],
	[3.5900000000E+04, 3.9786963660E+01, 5.6042804389E+00, 2.2119244002E+01, 4.0196415506E+00, 9.6916655924E-01],
	[3.5905000000E+04, 3.9796548193E+01, 5.6043142934E+00, 2.2129382041E+01, 4.0200914702E+00, 9.6918230739E-01],
	[3.5910000000E+04, 3.9806133701E+01, 5.6043481434E+00, 2.2139523314E+01, 4.0205412509E+00, 9.6919804669E-01],
	[3.5915000000E+04, 3.9815720182E+01, 5.6043819889E+00, 2.2149667820E+01, 4.0209908926E+00, 9.6921377715E-01],
	[3.5920000000E+04, 3.9825307637E+01, 5.6044158298E+00, 2.2159815561E+01, 4.0214403954E+00, 9.6922949878E-01],
	[3.5925000000E+04, 3.9834896065E+01, 5.6044496663E+00, 2.2169966536E+01, 4.0218897594E+00, 9.6924521159E-01],
	[3.5930000000E+04, 3.9844485468E+01, 5.6044834983E+00, 2.2180120746E+01, 4.0223389845E+00, 9.6926091557E-01],
	[3.5935000000E+04, 3.9854075843E+01, 5.6045173257E+00, 2.2190278193E+01, 4.0227880708E+00, 9.6927661073E-01],
	[3.5940000000E+04, 3.9863667193E+01, 5.6045511487E+00, 2.2200438876E+01, 4.0232370184E+00, 9.6929229708E-01],
	[3.5945000000E+04, 3.9873259516E+01, 5.6045849672E+00, 2.2210602796E+01, 4.0236858273E+00, 9.6930797462E-01],
	[3.5950000000E+04, 3.9882852812E+01, 5.6046187811E+00, 2.2220769953E+01, 4.0241344976E+00, 9.6932364336E-01],
	[3.5955000000E+04, 3.9892447082E+01, 5.6046525906E+00, 2.2230940349E+01, 4.0245830292E+00, 9.6933930330E-01],
	[3.5960000000E+04, 3.9902042325E+01, 5.6046863955E+00, 2.2241113984E+01, 4.0250314222E+00, 9.6935495445E-01],
	[3.5965000000E+04, 3.9911638542E+01, 5.6047201960E+00, 2.2251290858E+01, 4.0254796767E+00, 9.6937059681E-01],
	[3.5970000000E+04, 3.9921235731E+01, 5.6047539920E+00, 2.2261470972E+01, 4.0259277927E+00, 9.6938623039E-01],
	[3.5975000000E+04, 3.9930833895E+01, 5.6047877835E+00, 2.2271654327E+01, 4.0263757702E+00, 9.6940185520E-01],
	[3.5980000000E+04, 3.9940433031E+01, 5.6048215704E+00, 2.2281840923E+01, 4.0268236093E+00, 9.6941747123E-01],
	[3.5985000000E+04, 3.9950033141E+01, 5.6048553529E+00, 2.2292030761E+01, 4.0272713100E+00, 9.6943307849E-01],
	[3.5990000000E+04, 3.9959634224E+01, 5.6048891309E+00, 2.2302223840E+01, 4.0277188724E+00, 9.6944867700E-01],
	[3.5995000000E+04, 3.9969236280E+01, 5.6049229045E+00, 2.2312420163E+01, 4.0281662964E+00, 9.6946426674E-01],
	[3.6000000000E+04, 3.9978839309E+01, 5.6049566735E+00, 2.2322619730E+01, 4.0286135823E+00, 9.6947984774E-01],
	[3.6005000000E+04, 3.9988443312E+01, 5.6049904380E+00, 2.2332822540E+01, 4.0290607298E+00, 9.6949541999E-01],
	[3.6010000000E+04, 3.9998048287E+01, 5.6050241981E+00, 2.2343028595E+01, 4.0295077393E+00, 9.6951098349E-01],
	[3.6015000000E+04, 4.0007654235E+01, 5.6050579537E+00, 2.2353237895E+01, 4.0299546105E+00, 9.6952653826E-01],
	[3.6020000000E+04, 4.0017261157E+01, 5.6050917047E+00, 2.2363450441E+01, 4.0304013437E+00, 9.6954208430E-01],
	[3.6025000000E+04, 4.0026869051E+01, 5.6051254514E+00, 2.2373666233E+01, 4.0308479388E+00, 9.6955762162E-01],
	[3.6030000000E+04, 4.0036477918E+01, 5.6051591935E+00, 2.2383885272E+01, 4.0312943959E+00, 9.6957315021E-01],
	[3.6035000000E+04, 4.0046087758E+01, 5.6051929311E+00, 2.2394107559E+01, 4.0317407150E+00, 9.6958867008E-01],
	[3.6040000000E+04, 4.0055698571E+01, 5.6052266643E+00, 2.2404333094E+01, 4.0321868962E+00, 9.6960418125E-01],
	[3.6045000000E+04, 4.0065310357E+01, 5.6052603930E+00, 2.2414561878E+01, 4.0326329395E+00, 9.6961968371E-01],
	[3.6050000000E+04, 4.0074923116E+01, 5.6052941172E+00, 2.2424793911E+01, 4.0330788449E+00, 9.6963517746E-01],
	[3.6055000000E+04, 4.0084536847E+01, 5.6053278370E+00, 2.2435029194E+01, 4.0335246125E+00, 9.6965066253E-01],
	[3.6060000000E+04, 4.0094151551E+01, 5.6053615522E+00, 2.2445267727E+01, 4.0339702424E+00, 9.6966613890E-01],
	[3.6065000000E+04, 4.0103767227E+01, 5.6053952630E+00, 2.2455509511E+01, 4.0344157344E+00, 9.6968160658E-01],
	[3.6070000000E+04, 4.0113383876E+01, 5.6054289694E+00, 2.2465754547E+01, 4.0348610888E+00, 9.6969706559E-01],
	[3.6075000000E+04, 4.0123001498E+01, 5.6054626712E+00, 2.2476002835E+01, 4.0353063056E+00, 9.6971251592E-01],
	[3.6080000000E+04, 4.0132620092E+01, 5.6054963686E+00, 2.2486254376E+01, 4.0357513847E+00, 9.6972795758E-01],
	[3.6085000000E+04, 4.0142239659E+01, 5.6055300615E+00, 2.2496509170E+01, 4.0361963262E+00, 9.6974339057E-01],
	[3.6090000000E+04, 4.0151860198E+01, 5.6055637500E+00, 2.2506767218E+01, 4.0366411303E+00, 9.6975881491E-01],
	[3.6095000000E+04, 4.0161481710E+01, 5.6055974340E+00, 2.2517028520E+01, 4.0370857968E+00, 9.6977423058E-01],
	[3.6100000000E+04, 4.0171104194E+01, 5.6056311135E+00, 2.2527293078E+01, 4.0375303258E+00, 9.6978963761E-01],
	[3.6105000000E+04, 4.0180727650E+01, 5.6056647886E+00, 2.2537560891E+01, 4.0379747175E+00, 9.6980503599E-01],
	[3.6110000000E+04, 4.0190352079E+01, 5.6056984592E+00, 2.2547831961E+01, 4.0384189717E+00, 9.6982042574E-01],
	[3.6115000000E+04, 4.0199977480E+01, 5.6057321254E+00, 2.2558106287E+01, 4.0388630887E+00, 9.6983580684E-01],
	[3.6120000000E+04, 4.0209603853E+01, 5.6057657870E+00, 2.2568383871E+01, 4.0393070683E+00, 9.6985117932E-01],
	[3.6125000000E+04, 4.0219231199E+01, 5.6057994443E+00, 2.2578664713E+01, 4.0397509107E+00, 9.6986654318E-01],
	[3.6130000000E+04, 4.0228859516E+01, 5.6058330971E+00, 2.2588948813E+01, 4.0401946159E+00, 9.6988189841E-01],
	[3.6135000000E+04, 4.0238488806E+01, 5.6058667454E+00, 2.2599236173E+01, 4.0406381839E+00, 9.6989724503E-01],
	[3.6140000000E+04, 4.0248119068E+01, 5.6059003892E+00, 2.2609526792E+01, 4.0410816148E+00, 9.6991258303E-01],
	[3.6145000000E+04, 4.0257750302E+01, 5.6059340287E+00, 2.2619820671E+01, 4.0415249085E+00, 9.6992791244E-01],
	[3.6150000000E+04, 4.0267382508E+01, 5.6059676636E+00, 2.2630117812E+01, 4.0419680653E+00, 9.6994323324E-01],
	[3.6155000000E+04, 4.0277015686E+01, 5.6060012941E+00, 2.2640418214E+01, 4.0424110850E+00, 9.6995854545E-01],
	[3.6160000000E+04, 4.0286649836E+01, 5.6060349202E+00, 2.2650721878E+01, 4.0428539677E+00, 9.6997384907E-01],
	[3.6165000000E+04, 4.0296284958E+01, 5.6060685418E+00, 2.2661028804E+01, 4.0432967135E+00, 9.6998914411E-01],
	[3.6170000000E+04, 4.0305921051E+01, 5.6061021590E+00, 2.2671338994E+01, 4.0437393224E+00, 9.7000443056E-01],
	[3.6175000000E+04, 4.0315558117E+01, 5.6061357717E+00, 2.2681652448E+01, 4.0441817945E+00, 9.7001970844E-01],
	[3.6180000000E+04, 4.0325196154E+01, 5.6061693800E+00, 2.2691969166E+01, 4.0446241297E+00, 9.7003497776E-01],
	[3.6185000000E+04, 4.0334835163E+01, 5.6062029838E+00, 2.2702289149E+01, 4.0450663282E+00, 9.7005023850E-01],
	[3.6190000000E+04, 4.0344475144E+01, 5.6062365832E+00, 2.2712612398E+01, 4.0455083900E+00, 9.7006549069E-01],
	[3.6195000000E+04, 4.0354116097E+01, 5.6062701782E+00, 2.2722938912E+01, 4.0459503150E+00, 9.7008073433E-01],
	[3.6200000000E+04, 4.0363758021E+01, 5.6063037687E+00, 2.2733268694E+01, 4.0463921034E+00, 9.7009596941E-01],
	[3.6205000000E+04, 4.0373400917E+01, 5.6063373548E+00, 2.2743601742E+01, 4.0468337552E+00, 9.7011119595E-01],
	[3.6210000000E+04, 4.0383044784E+01, 5.6063709364E+00, 2.2753938059E+01, 4.0472752705E+00, 9.7012641395E-01],
	[3.6215000000E+04, 4.0392689624E+01, 5.6064045136E+00, 2.2764277644E+01, 4.0477166492E+00, 9.7014162342E-01],
	[3.6220000000E+04, 4.0402335434E+01, 5.6064380864E+00, 2.2774620498E+01, 4.0481578914E+00, 9.7015682436E-01],
	[3.6225000000E+04, 4.0411982216E+01, 5.6064716548E+00, 2.2784966622E+01, 4.0485989972E+00, 9.7017201677E-01],
	[3.6230000000E+04, 4.0421651873E+01, 5.6065074690E+00, 2.2795316016E+01, 4.0490413600E+00, 9.7018720067E-01],
	[3.6235000000E+04, 4.0431324538E+01, 5.6065434868E+00, 2.2805668681E+01, 4.0494837158E+00, 9.7020237605E-01],
	[3.6240000000E+04, 4.0440998183E+01, 5.6065795000E+00, 2.2816024617E+01, 4.0499259357E+00, 9.7021754292E-01],
	[3.6245000000E+04, 4.0450672806E+01, 5.6066155083E+00, 2.2826383825E+01, 4.0503680195E+00, 9.7023270129E-01],
	[3.6250000000E+04, 4.0460348410E+01, 5.6066515120E+00, 2.2836746305E+01, 4.0508099675E+00, 9.7024785116E-01],
	[3.6255000000E+04, 4.0470024992E+01, 5.6066875109E+00, 2.2847112059E+01, 4.0512517795E+00, 9.7026299254E-01],
	[3.6260000000E+04, 4.0479702554E+01, 5.6067235051E+00, 2.2857481086E+01, 4.0516934557E+00, 9.7027812542E-01],
	[3.6265000000E+04, 4.0489381096E+01, 5.6067594946E+00, 2.2867853388E+01, 4.0521349961E+00, 9.7029324982E-01],
	[3.6270000000E+04, 4.0499060616E+01, 5.6067954793E+00, 2.2878228964E+01, 4.0525764008E+00, 9.7030836575E-01],
	[3.6275000000E+04, 4.0508741116E+01, 5.6068314593E+00, 2.2888607816E+01, 4.0530176697E+00, 9.7032347320E-01],
	[3.6280000000E+04, 4.0518422595E+01, 5.6068674345E+00, 2.2898989944E+01, 4.0534588029E+00, 9.7033857218E-01],
	[3.6285000000E+04, 4.0528105053E+01, 5.6069034051E+00, 2.2909375349E+01, 4.0538998005E+00, 9.7035366270E-01],
	[3.6290000000E+04, 4.0537788491E+01, 5.6069393709E+00, 2.2919764030E+01, 4.0543406625E+00, 9.7036874476E-01],
	[3.6295000000E+04, 4.0547472908E+01, 5.6069753320E+00, 2.2930155990E+01, 4.0547813889E+00, 9.7038381836E-01],
	[3.6300000000E+04, 4.0557158303E+01, 5.6070112884E+00, 2.2940551228E+01, 4.0552219798E+00, 9.7039888352E-01],
	[3.6305000000E+04, 4.0566844678E+01, 5.6070472400E+00, 2.2950949745E+01, 4.0556624352E+00, 9.7041394023E-01],
	[3.6310000000E+04, 4.0576532032E+01, 5.6070831869E+00, 2.2961351541E+01, 4.0561027551E+00, 9.7042898851E-01],
	[3.6315000000E+04, 4.0586220364E+01, 5.6071191291E+00, 2.2971756617E+01, 4.0565429397E+00, 9.7044402835E-01],
	[3.6320000000E+04, 4.0595909676E+01, 5.6071550666E+00, 2.2982164974E+01, 4.0569829888E+00, 9.7045905976E-01],
	[3.6325000000E+04, 4.0605599966E+01, 5.6071909994E+00, 2.2992576613E+01, 4.0574229027E+00, 9.7047408275E-01],
	[3.6330000000E+04, 4.0615291236E+01, 5.6072269274E+00, 2.3002991533E+01, 4.0578626813E+00, 9.7048909732E-01],
	[3.6335000000E+04, 4.0624983484E+01, 5.6072628508E+00, 2.3013409735E+01, 4.0583023246E+00, 9.7050410347E-01],
	[3.6340000000E+04, 4.0634676711E+01, 5.6072987694E+00, 2.3023831221E+01, 4.0587418327E+00, 9.7051910122E-01],
	[3.6345000000E+04, 4.0644370917E+01, 5.6073346833E+00, 2.3034255990E+01, 4.0591812057E+00, 9.7053409056E-01],
	[3.6350000000E+04, 4.0654066101E+01, 5.6073705925E+00, 2.3044684043E+01, 4.0596204435E+00, 9.7054907151E-01],
	[3.6355000000E+04, 4.0663762265E+01, 5.6074064970E+00, 2.3055115381E+01, 4.0600595463E+00, 9.7056404406E-01],
	[3.6360000000E+04, 4.0673459406E+01, 5.6074423968E+00, 2.3065550005E+01, 4.0604985140E+00, 9.7057900822E-01],
	[3.6365000000E+04, 4.0683157527E+01, 5.6074782919E+00, 2.3075987914E+01, 4.0609373467E+00, 9.7059396400E-01],
	[3.6370000000E+04, 4.0692856626E+01, 5.6075141823E+00, 2.3086429110E+01, 4.0613760444E+00, 9.7060891140E-01],
	[3.6375000000E+04, 4.0702556703E+01, 5.6075500679E+00, 2.3096873593E+01, 4.0618146072E+00, 9.7062385043E-01],
	[3.6380000000E+04, 4.0712257759E+01, 5.6075859489E+00, 2.3107321364E+01, 4.0622530351E+00, 9.7063878108E-01],
	[3.6385000000E+04, 4.0721959794E+01, 5.6076218252E+00, 2.3117772422E+01, 4.0626913282E+00, 9.7065370338E-01],
	[3.6390000000E+04, 4.0731662807E+01, 5.6076576967E+00, 2.3128226770E+01, 4.0631294865E+00, 9.7066861731E-01],
	[3.6395000000E+04, 4.0741366798E+01, 5.6076935636E+00, 2.3138684407E+01, 4.0635675100E+00, 9.7068352289E-01],
	[3.6400000000E+04, 4.0751071768E+01, 5.6077294258E+00, 2.3149145334E+01, 4.0640053988E+00, 9.7069842013E-01],
	[3.6405000000E+04, 4.0760777716E+01, 5.6077652833E+00, 2.3159609552E+01, 4.0644431529E+00, 9.7071330902E-01],
	[3.6410000000E+04, 4.0770484643E+01, 5.6078011360E+00, 2.3170077060E+01, 4.0648807723E+00, 9.7072818957E-01],
	[3.6415000000E+04, 4.0780192547E+01, 5.6078369841E+00, 2.3180547861E+01, 4.0653182571E+00, 9.7074306178E-01],
	[3.6420000000E+04, 4.0789901430E+01, 5.6078728275E+00, 2.3191021954E+01, 4.0657556074E+00, 9.7075792567E-01],
	[3.6425000000E+04, 4.0799611291E+01, 5.6079086662E+00, 2.3201499340E+01, 4.0661928232E+00, 9.7077278124E-01],
	[3.6430000000E+04, 4.0809322130E+01, 5.6079445002E+00, 2.3211980019E+01, 4.0666299044E+00, 9.7078762848E-01],
	[3.6435000000E+04, 4.0819033948E+01, 5.6079803296E+00, 2.3222463992E+01, 4.0670668512E+00, 9.7080246741E-01],
	[3.6440000000E+04, 4.0828746743E+01, 5.6080161542E+00, 2.3232951260E+01, 4.0675036636E+00, 9.7081729804E-01],
	[3.6445000000E+04, 4.0838460516E+01, 5.6080519741E+00, 2.3243441823E+01, 4.0679403417E+00, 9.7083212036E-01],
	[3.6450000000E+04, 4.0848175268E+01, 5.6080877894E+00, 2.3253935682E+01, 4.0683768854E+00, 9.7084693438E-01],
	[3.6455000000E+04, 4.0857890997E+01, 5.6081236000E+00, 2.3264432838E+01, 4.0688132948E+00, 9.7086174010E-01],
	[3.6460000000E+04, 4.0867607704E+01, 5.6081594059E+00, 2.3274933290E+01, 4.0692495700E+00, 9.7087653754E-01],
	[3.6465000000E+04, 4.0877325390E+01, 5.6081952071E+00, 2.3285437040E+01, 4.0696857110E+00, 9.7089132669E-01],
	[3.6470000000E+04, 4.0887044053E+01, 5.6082310036E+00, 2.3295944088E+01, 4.0701217178E+00, 9.7090610757E-01],
	[3.6475000000E+04, 4.0896763694E+01, 5.6082667955E+00, 2.3306454435E+01, 4.0705575905E+00, 9.7092088017E-01],
	[3.6480000000E+04, 4.0906484312E+01, 5.6083025827E+00, 2.3316968081E+01, 4.0709933291E+00, 9.7093564450E-01],
	[3.6485000000E+04, 4.0916205909E+01, 5.6083383652E+00, 2.3327485027E+01, 4.0714289336E+00, 9.7095040056E-01],
	[3.6490000000E+04, 4.0925928483E+01, 5.6083741430E+00, 2.3338005274E+01, 4.0718644042E+00, 9.7096514837E-01],
	[3.6495000000E+04, 4.0935652035E+01, 5.6084099161E+00, 2.3348528821E+01, 4.0722997408E+00, 9.7097988792E-01],
	[3.6500000000E+04, 4.0945376565E+01, 5.6084456846E+00, 2.3359055671E+01, 4.0727349434E+00, 9.7099461923E-01],
	[3.6505000000E+04, 4.0955102072E+01, 5.6084814484E+00, 2.3369585822E+01, 4.0731700122E+00, 9.7100934229E-01],
	[3.6510000000E+04, 4.0964828556E+01, 5.6085172076E+00, 2.3380119276E+01, 4.0736049471E+00, 9.7102405711E-01],
	[3.6515000000E+04, 4.0974556019E+01, 5.6085529620E+00, 2.3390656034E+01, 4.0740397482E+00, 9.7103876369E-01],
	[3.6520000000E+04, 4.0984284458E+01, 5.6085887118E+00, 2.3401196096E+01, 4.0744744155E+00, 9.7105346205E-01],
	[3.6525000000E+04, 4.0994013876E+01, 5.6086244570E+00, 2.3411739462E+01, 4.0749089492E+00, 9.7106815218E-01],
	[3.6530000000E+04, 4.1003744270E+01, 5.6086601974E+00, 2.3422286133E+01, 4.0753433491E+00, 9.7108283410E-01],
	[3.6535000000E+04, 4.1013475642E+01, 5.6086959333E+00, 2.3432836110E+01, 4.0757776154E+00, 9.7109750779E-01],
	[3.6540000000E+04, 4.1023207992E+01, 5.6087316644E+00, 2.3443389394E+01, 4.0762117480E+00, 9.7111217328E-01],
	[3.6545000000E+04, 4.1032941319E+01, 5.6087673909E+00, 2.3453945984E+01, 4.0766457471E+00, 9.7112683057E-01],
	[3.6550000000E+04, 4.1042675623E+01, 5.6088031127E+00, 2.3464505882E+01, 4.0770796127E+00, 9.7114147965E-01],
	[3.6555000000E+04, 4.1052410904E+01, 5.6088388299E+00, 2.3475069088E+01, 4.0775133448E+00, 9.7115612054E-01],
	[3.6560000000E+04, 4.1062147163E+01, 5.6088745424E+00, 2.3485635602E+01, 4.0779469435E+00, 9.7117075324E-01],
	[3.6565000000E+04, 4.1071884398E+01, 5.6089102502E+00, 2.3496205426E+01, 4.0783804087E+00, 9.7118537775E-01],
	[3.6570000000E+04, 4.1081622611E+01, 5.6089459534E+00, 2.3506778559E+01, 4.0788137405E+00, 9.7119999409E-01],
	[3.6575000000E+04, 4.1091361801E+01, 5.6089816520E+00, 2.3517355003E+01, 4.0792469391E+00, 9.7121460225E-01],
	[3.6580000000E+04, 4.1101101968E+01, 5.6090173458E+00, 2.3527934758E+01, 4.0796800043E+00, 9.7122920223E-01],
	[3.6585000000E+04, 4.1110843112E+01, 5.6090530351E+00, 2.3538517824E+01, 4.0801129363E+00, 9.7124379406E-01],
	[3.6590000000E+04, 4.1120585234E+01, 5.6090887197E+00, 2.3549104203E+01, 4.0805457351E+00, 9.7125837772E-01],
	[3.6595000000E+04, 4.1130328332E+01, 5.6091243996E+00, 2.3559693894E+01, 4.0809784007E+00, 9.7127295323E-01],
	[3.6600000000E+04, 4.1140072407E+01, 5.6091600749E+00, 2.3570286899E+01, 4.0814109332E+00, 9.7128752059E-01],
	[3.6605000000E+04, 4.1149817459E+01, 5.6091957455E+00, 2.3580883217E+01, 4.0818433326E+00, 9.7130207980E-01],
	[3.6610000000E+04, 4.1159563487E+01, 5.6092314115E+00, 2.3591482850E+01, 4.0822755990E+00, 9.7131663087E-01],
	[3.6615000000E+04, 4.1169310493E+01, 5.6092670729E+00, 2.3602085798E+01, 4.0827077323E+00, 9.7133117381E-01],
	[3.6620000000E+04, 4.1179058476E+01, 5.6093027296E+00, 2.3612692062E+01, 4.0831397327E+00, 9.7134570861E-01],
	[3.6625000000E+04, 4.1188807435E+01, 5.6093383817E+00, 2.3623301642E+01, 4.0835716002E+00, 9.7136023529E-01],
	[3.6630000000E+04, 4.1198557371E+01, 5.6093740291E+00, 2.3633914539E+01, 4.0840033347E+00, 9.7137475385E-01],
	[3.6635000000E+04, 4.1208308283E+01, 5.6094096719E+00, 2.3644530753E+01, 4.0844349364E+00, 9.7138926430E-01],
	[3.6640000000E+04, 4.1218060173E+01, 5.6094453100E+00, 2.3655150285E+01, 4.0848664053E+00, 9.7140376663E-01],
	[3.6645000000E+04, 4.1227813038E+01, 5.6094809436E+00, 2.3665773135E+01, 4.0852977415E+00, 9.7141826085E-01],
	[3.6650000000E+04, 4.1237566881E+01, 5.6095165724E+00, 2.3676399305E+01, 4.0857289449E+00, 9.7143274698E-01],
	[3.6655000000E+04, 4.1247321700E+01, 5.6095521967E+00, 2.3687028795E+01, 4.0861600156E+00, 9.7144722501E-01],
	[3.6660000000E+04, 4.1257077496E+01, 5.6095878163E+00, 2.3697661604E+01, 4.0865909536E+00, 9.7146169494E-01],
	[3.6665000000E+04, 4.1266834268E+01, 5.6096234313E+00, 2.3708297735E+01, 4.0870217591E+00, 9.7147615679E-01],
	[3.6670000000E+04, 4.1276592016E+01, 5.6096590416E+00, 2.3718937187E+01, 4.0874524320E+00, 9.7149061056E-01],
	[3.6675000000E+04, 4.1286350741E+01, 5.6096946473E+00, 2.3729579961E+01, 4.0878829723E+00, 9.7150505625E-01],
	[3.6680000000E+04, 4.1296110442E+01, 5.6097302484E+00, 2.3740226058E+01, 4.0883133802E+00, 9.7151949388E-01],
	[3.6685000000E+04, 4.1305871120E+01, 5.6097658449E+00, 2.3750875478E+01, 4.0887436556E+00, 9.7153392343E-01],
	[3.6690000000E+04, 4.1315632774E+01, 5.6098014368E+00, 2.3761528222E+01, 4.0891737986E+00, 9.7154834492E-01],
	[3.6695000000E+04, 4.1325395404E+01, 5.6098370240E+00, 2.3772184291E+01, 4.0896038092E+00, 9.7156275836E-01],
	[3.6700000000E+04, 4.1335159010E+01, 5.6098726066E+00, 2.3782843684E+01, 4.0900336875E+00, 9.7157716374E-01],
	[3.6705000000E+04, 4.1344923593E+01, 5.6099081845E+00, 2.3793506403E+01, 4.0904634335E+00, 9.7159156107E-01],
	[3.6710000000E+04, 4.1354689151E+01, 5.6099437579E+00, 2.3804172448E+01, 4.0908930472E+00, 9.7160595037E-01],
	[3.6715000000E+04, 4.1364455686E+01, 5.6099793266E+00, 2.3814841820E+01, 4.0913225288E+00, 9.7162033162E-01],
	[3.6720000000E+04, 4.1374223197E+01, 5.6100148907E+00, 2.3825514519E+01, 4.0917518781E+00, 9.7163470484E-01],
	[3.6725000000E+04, 4.1383991684E+01, 5.6100504502E+00, 2.3836190546E+01, 4.0921810954E+00, 9.7164907004E-01],
	[3.6730000000E+04, 4.1393761147E+01, 5.6100860051E+00, 2.3846869901E+01, 4.0926101805E+00, 9.7166342721E-01],
	[3.6735000000E+04, 4.1403531586E+01, 5.6101215554E+00, 2.3857552586E+01, 4.0930391336E+00, 9.7167777637E-01],
	[3.6740000000E+04, 4.1413303001E+01, 5.6101571010E+00, 2.3868238600E+01, 4.0934679547E+00, 9.7169211751E-01],
	[3.6745000000E+04, 4.1423075392E+01, 5.6101926421E+00, 2.3878927944E+01, 4.0938966438E+00, 9.7170645064E-01],
	[3.6750000000E+04, 4.1432848758E+01, 5.6102281785E+00, 2.3889620619E+01, 4.0943252010E+00, 9.7172077577E-01],
	[3.6755000000E+04, 4.1442623101E+01, 5.6102637103E+00, 2.3900316626E+01, 4.0947536263E+00, 9.7173509290E-01],
	[3.6760000000E+04, 4.1452398419E+01, 5.6102992376E+00, 2.3911015965E+01, 4.0951819197E+00, 9.7174940204E-01],
	[3.6765000000E+04, 4.1462174713E+01, 5.6103347602E+00, 2.3921718636E+01, 4.0956100813E+00, 9.7176370319E-01],
	[3.6770000000E+04, 4.1471951983E+01, 5.6103702782E+00, 2.3932424640E+01, 4.0960381111E+00, 9.7177799635E-01],
	[3.6775000000E+04, 4.1481730229E+01, 5.6104057916E+00, 2.3943133978E+01, 4.0964660092E+00, 9.7179228154E-01],
	[3.6780000000E+04, 4.1491509450E+01, 5.6104413004E+00, 2.3953846651E+01, 4.0968937756E+00, 9.7180655875E-01],
	[3.6785000000E+04, 4.1501289647E+01, 5.6104768045E+00, 2.3964562658E+01, 4.0973214104E+00, 9.7182082800E-01],
	[3.6790000000E+04, 4.1511070819E+01, 5.6105123041E+00, 2.3975282001E+01, 4.0977489135E+00, 9.7183508928E-01],
	[3.6795000000E+04, 4.1520852967E+01, 5.6105477991E+00, 2.3986004679E+01, 4.0981762851E+00, 9.7184934259E-01],
	[3.6800000000E+04, 4.1530636091E+01, 5.6105832895E+00, 2.3996730695E+01, 4.0986035252E+00, 9.7186358796E-01],
	[3.6805000000E+04, 4.1540420190E+01, 5.6106187753E+00, 2.4007460048E+01, 4.0990306337E+00, 9.7187782537E-01],
	[3.6810000000E+04, 4.1550211908E+01, 5.6106549289E+00, 2.4018192738E+01, 4.0994580344E+00, 9.7189205485E-01],
	[3.6815000000E+04, 4.1560021755E+01, 5.6106928132E+00, 2.4028928767E+01, 4.0998863974E+00, 9.7190627638E-01],
	[3.6820000000E+04, 4.1569832586E+01, 5.6107306927E+00, 2.4039668135E+01, 4.1003146292E+00, 9.7192048997E-01],
	[3.6825000000E+04, 4.1579644400E+01, 5.6107685672E+00, 2.4050410843E+01, 4.1007427301E+00, 9.7193469564E-01],
	[3.6830000000E+04, 4.1589457198E+01, 5.6108064368E+00, 2.4061156891E+01, 4.1011706999E+00, 9.7194889338E-01],
	[3.6835000000E+04, 4.1599270978E+01, 5.6108443016E+00, 2.4071906279E+01, 4.1015985388E+00, 9.7196308319E-01],
	[3.6840000000E+04, 4.1609085742E+01, 5.6108821615E+00, 2.4082659009E+01, 4.1020262467E+00, 9.7197726510E-01],
	[3.6845000000E+04, 4.1618901489E+01, 5.6109200165E+00, 2.4093415081E+01, 4.1024538238E+00, 9.7199143909E-01],
	[3.6850000000E+04, 4.1628718219E+01, 5.6109578666E+00, 2.4104174495E+01, 4.1028812701E+00, 9.7200560518E-01],
	[3.6855000000E+04, 4.1638535933E+01, 5.6109957119E+00, 2.4114937253E+01, 4.1033085855E+00, 9.7201976336E-01],
	[3.6860000000E+04, 4.1648354629E+01, 5.6110335522E+00, 2.4125703354E+01, 4.1037357702E+00, 9.7203391365E-01],
	[3.6865000000E+04, 4.1658174309E+01, 5.6110713877E+00, 2.4136472799E+01, 4.1041628242E+00, 9.7204805605E-01],
	[3.6870000000E+04, 4.1667994971E+01, 5.6111092183E+00, 2.4147245589E+01, 4.1045897475E+00, 9.7206219056E-01],
	[3.6875000000E+04, 4.1677816617E+01, 5.6111470440E+00, 2.4158021725E+01, 4.1050165402E+00, 9.7207631719E-01],
	[3.6880000000E+04, 4.1687639245E+01, 5.6111848649E+00, 2.4168801206E+01, 4.1054432022E+00, 9.7209043594E-01],
	[3.6885000000E+04, 4.1697462856E+01, 5.6112226809E+00, 2.4179584034E+01, 4.1058697337E+00, 9.7210454682E-01],
	[3.6890000000E+04, 4.1707287451E+01, 5.6112604920E+00, 2.4190370210E+01, 4.1062961347E+00, 9.7211864983E-01],
	[3.6895000000E+04, 4.1717113028E+01, 5.6112982982E+00, 2.4201159733E+01, 4.1067224052E+00, 9.7213274498E-01],
	[3.6900000000E+04, 4.1726939588E+01, 5.6113360996E+00, 2.4211952604E+01, 4.1071485452E+00, 9.7214683227E-01],
	[3.6905000000E+04, 4.1736767130E+01, 5.6113738961E+00, 2.4222748825E+01, 4.1075745549E+00, 9.7216091170E-01],
	[3.6910000000E+04, 4.1746595656E+01, 5.6114116878E+00, 2.4233548395E+01, 4.1080004341E+00, 9.7217498328E-01],
	[3.6915000000E+04, 4.1756425164E+01, 5.6114494746E+00, 2.4244351315E+01, 4.1084261831E+00, 9.7218904702E-01],
	[3.6920000000E+04, 4.1766255655E+01, 5.6114872565E+00, 2.4255157586E+01, 4.1088518018E+00, 9.7220310292E-01],
	[3.6925000000E+04, 4.1776087128E+01, 5.6115250335E+00, 2.4265967208E+01, 4.1092772902E+00, 9.7221715098E-01],
	[3.6930000000E+04, 4.1785919584E+01, 5.6115628057E+00, 2.4276780181E+01, 4.1097026484E+00, 9.7223119121E-01],
	[3.6935000000E+04, 4.1795753023E+01, 5.6116005731E+00, 2.4287596508E+01, 4.1101278765E+00, 9.7224522361E-01],
	[3.6940000000E+04, 4.1805587444E+01, 5.6116383355E+00, 2.4298416187E+01, 4.1105529744E+00, 9.7225924818E-01],
	[3.6945000000E+04, 4.1815422847E+01, 5.6116760931E+00, 2.4309239220E+01, 4.1109779423E+00, 9.7227326494E-01],
	[3.6950000000E+04, 4.1825259233E+01, 5.6117138459E+00, 2.4320065607E+01, 4.1114027801E+00, 9.7228727388E-01],
	[3.6955000000E+04, 4.1835096602E+01, 5.6117515938E+00, 2.4330895349E+01, 4.1118274879E+00, 9.7230127501E-01],
	[3.6960000000E+04, 4.1844934953E+01, 5.6117893369E+00, 2.4341728446E+01, 4.1122520657E+00, 9.7231526834E-01],
	[3.6965000000E+04, 4.1854774286E+01, 5.6118270751E+00, 2.4352564900E+01, 4.1126765136E+00, 9.7232925386E-01],
	[3.6970000000E+04, 4.1864614602E+01, 5.6118648084E+00, 2.4363404709E+01, 4.1131008316E+00, 9.7234323159E-01],
	[3.6975000000E+04, 4.1874455900E+01, 5.6119025369E+00, 2.4374247876E+01, 4.1135250197E+00, 9.7235720153E-01],
	[3.6980000000E+04, 4.1884298180E+01, 5.6119402606E+00, 2.4385094401E+01, 4.1139490781E+00, 9.7237116367E-01],
	[3.6985000000E+04, 4.1894141442E+01, 5.6119779794E+00, 2.4395944284E+01, 4.1143730066E+00, 9.7238511804E-01],
	[3.6990000000E+04, 4.1903985687E+01, 5.6120156934E+00, 2.4406797526E+01, 4.1147968055E+00, 9.7239906462E-01],
	[3.6995000000E+04, 4.1913830913E+01, 5.6120534025E+00, 2.4417654127E+01, 4.1152204746E+00, 9.7241300343E-01],
	[3.7000000000E+04, 4.1923677122E+01, 5.6120911068E+00, 2.4428514088E+01, 4.1156440141E+00, 9.7242693447E-01],
	[3.7005000000E+04, 4.1933524313E+01, 5.6121288062E+00, 2.4439377410E+01, 4.1160674240E+00, 9.7244085774E-01],
	[3.7010000000E+04, 4.1943372486E+01, 5.6121665008E+00, 2.4450244094E+01, 4.1164907043E+00, 9.7245477325E-01],
	[3.7015000000E+04, 4.1953221641E+01, 5.6122041905E+00, 2.4461114138E+01, 4.1169138551E+00, 9.7246868101E-01],
	[3.7020000000E+04, 4.1963071778E+01, 5.6122418755E+00, 2.4471987546E+01, 4.1173368764E+00, 9.7248258101E-01],
	[3.7025000000E+04, 4.1972922896E+01, 5.6122795555E+00, 2.4482864316E+01, 4.1177597682E+00, 9.7249647326E-01],
	[3.7030000000E+04, 4.1982774997E+01, 5.6123172308E+00, 2.4493744450E+01, 4.1181825306E+00, 9.7251035777E-01],
	[3.7035000000E+04, 4.1992628080E+01, 5.6123549012E+00, 2.4504627948E+01, 4.1186051636E+00, 9.7252423454E-01],
	[3.7040000000E+04, 4.2002482144E+01, 5.6123925668E+00, 2.4515514811E+01, 4.1190276673E+00, 9.7253810358E-01],
	[3.7045000000E+04, 4.2012337190E+01, 5.6124302275E+00, 2.4526405039E+01, 4.1194500417E+00, 9.7255196488E-01],
	[3.7050000000E+04, 4.2022193219E+01, 5.6124678835E+00, 2.4537298633E+01, 4.1198722869E+00, 9.7256581846E-01],
	[3.7055000000E+04, 4.2032050228E+01, 5.6125055345E+00, 2.4548195594E+01, 4.1202944028E+00, 9.7257966432E-01],
	[3.7060000000E+04, 4.2041908220E+01, 5.6125431808E+00, 2.4559095921E+01, 4.1207163895E+00, 9.7259350246E-01],
	[3.7065000000E+04, 4.2051767193E+01, 5.6125808222E+00, 2.4569999616E+01, 4.1211382471E+00, 9.7260733289E-01],
	[3.7070000000E+04, 4.2061627148E+01, 5.6126184589E+00, 2.4580906680E+01, 4.1215599756E+00, 9.7262115560E-01],
	[3.7075000000E+04, 4.2071488084E+01, 5.6126560906E+00, 2.4591817112E+01, 4.1219815750E+00, 9.7263497062E-01],
	[3.7080000000E+04, 4.2081350002E+01, 5.6126937176E+00, 2.4602730914E+01, 4.1224030455E+00, 9.7264877793E-01],
	[3.7085000000E+04, 4.2091212901E+01, 5.6127313397E+00, 2.4613648086E+01, 4.1228243869E+00, 9.7266257755E-01],
	[3.7090000000E+04, 4.2101076782E+01, 5.6127689571E+00, 2.4624568628E+01, 4.1232455994E+00, 9.7267636948E-01],
	[3.7095000000E+04, 4.2110941644E+01, 5.6128065696E+00, 2.4635492541E+01, 4.1236666830E+00, 9.7269015372E-01],
	[3.7100000000E+04, 4.2120807488E+01, 5.6128441773E+00, 2.4646419827E+01, 4.1240876377E+00, 9.7270393028E-01],
	[3.7105000000E+04, 4.2130674313E+01, 5.6128817801E+00, 2.4657350484E+01, 4.1245084636E+00, 9.7271769917E-01],
	[3.7110000000E+04, 4.2140542120E+01, 5.6129193782E+00, 2.4668284515E+01, 4.1249291607E+00, 9.7273146038E-01],
	[3.7115000000E+04, 4.2150410908E+01, 5.6129569714E+00, 2.4679221919E+01, 4.1253497290E+00, 9.7274521392E-01],
	[3.7120000000E+04, 4.2160280677E+01, 5.6129945599E+00, 2.4690162697E+01, 4.1257701687E+00, 9.7275895979E-01],
	[3.7125000000E+04, 4.2170151427E+01, 5.6130321435E+00, 2.4701106850E+01, 4.1261904797E+00, 9.7277269801E-01],
	[3.7130000000E+04, 4.2180023159E+01, 5.6130697223E+00, 2.4712054378E+01, 4.1266106620E+00, 9.7278642857E-01],
	[3.7135000000E+04, 4.2189895872E+01, 5.6131072963E+00, 2.4723005282E+01, 4.1270307158E+00, 9.7280015148E-01],
	[3.7140000000E+04, 4.2199769565E+01, 5.6131448655E+00, 2.4733959562E+01, 4.1274506410E+00, 9.7281386675E-01],
	[3.7145000000E+04, 4.2209644240E+01, 5.6131824299E+00, 2.4744917220E+01, 4.1278704378E+00, 9.7282757437E-01],
	[3.7150000000E+04, 4.2219519896E+01, 5.6132199895E+00, 2.4755878255E+01, 4.1282901060E+00, 9.7284127435E-01],
	[3.7155000000E+04, 4.2229396534E+01, 5.6132575442E+00, 2.4766842668E+01, 4.1287096458E+00, 9.7285496670E-01],
	[3.7160000000E+04, 4.2239274152E+01, 5.6132950942E+00, 2.4777810460E+01, 4.1291290572E+00, 9.7286865142E-01],
	[3.7165000000E+04, 4.2249152751E+01, 5.6133326394E+00, 2.4788781631E+01, 4.1295483403E+00, 9.7288232852E-01],
	[3.7170000000E+04, 4.2259032331E+01, 5.6133701798E+00, 2.4799756183E+01, 4.1299674950E+00, 9.7289599799E-01],
	[3.7175000000E+04, 4.2268912892E+01, 5.6134077153E+00, 2.4810734115E+01, 4.1303865215E+00, 9.7290965985E-01],
	[3.7180000000E+04, 4.2278794434E+01, 5.6134452461E+00, 2.4821715428E+01, 4.1308054198E+00, 9.7292331410E-01],
	[3.7185000000E+04, 4.2288676956E+01, 5.6134827721E+00, 2.4832700122E+01, 4.1312241898E+00, 9.7293696074E-01],
	[3.7190000000E+04, 4.2298560460E+01, 5.6135202933E+00, 2.4843688199E+01, 4.1316428317E+00, 9.7295059978E-01],
	[3.7195000000E+04, 4.2308444944E+01, 5.6135578097E+00, 2.4854679659E+01, 4.1320613455E+00, 9.7296423123E-01],
	[3.7200000000E+04, 4.2318330409E+01, 5.6135953213E+00, 2.4865674503E+01, 4.1324797312E+00, 9.7297785507E-01],
	[3.7205000000E+04, 4.2328216854E+01, 5.6136328281E+00, 2.4876672730E+01, 4.1328979888E+00, 9.7299147133E-01],
	[3.7210000000E+04, 4.2338104281E+01, 5.6136703301E+00, 2.4887674342E+01, 4.1333161185E+00, 9.7300508000E-01],
	[3.7215000000E+04, 4.2347992687E+01, 5.6137078274E+00, 2.4898679340E+01, 4.1337341202E+00, 9.7301868110E-01],
	[3.7220000000E+04, 4.2357882075E+01, 5.6137453198E+00, 2.4909687723E+01, 4.1341519940E+00, 9.7303227461E-01],
	[3.7225000000E+04, 4.2367772443E+01, 5.6137828075E+00, 2.4920699492E+01, 4.1345697399E+00, 9.7304586056E-01],
	[3.7230000000E+04, 4.2377663791E+01, 5.6138202904E+00, 2.4931714649E+01, 4.1349873580E+00, 9.7305943893E-01],
	[3.7235000000E+04, 4.2387556121E+01, 5.6138577685E+00, 2.4942733193E+01, 4.1354048482E+00, 9.7307300975E-01],
	[3.7240000000E+04, 4.2397449430E+01, 5.6138952418E+00, 2.4953755125E+01, 4.1358222107E+00, 9.7308657300E-01],
	[3.7245000000E+04, 4.2407343720E+01, 5.6139327103E+00, 2.4964780447E+01, 4.1362394455E+00, 9.7310012870E-01],
	[3.7250000000E+04, 4.2417238990E+01, 5.6139701741E+00, 2.4975809157E+01, 4.1366565526E+00, 9.7311367685E-01],
	[3.7255000000E+04, 4.2427135241E+01, 5.6140076330E+00, 2.4986841257E+01, 4.1370735320E+00, 9.7312721746E-01],
	[3.7260000000E+04, 4.2437032472E+01, 5.6140450872E+00, 2.4997876748E+01, 4.1374903838E+00, 9.7314075052E-01],
	[3.7265000000E+04, 4.2446930683E+01, 5.6140825366E+00, 2.5008915630E+01, 4.1379071081E+00, 9.7315427605E-01],
	[3.7270000000E+04, 4.2456829875E+01, 5.6141199813E+00, 2.5019957904E+01, 4.1383237049E+00, 9.7316779404E-01],
	[3.7275000000E+04, 4.2466730046E+01, 5.6141574212E+00, 2.5031003570E+01, 4.1387401741E+00, 9.7318130451E-01],
	[3.7280000000E+04, 4.2476631198E+01, 5.6141948563E+00, 2.5042052628E+01, 4.1391565159E+00, 9.7319480745E-01],
	[3.7285000000E+04, 4.2486533330E+01, 5.6142322866E+00, 2.5053105081E+01, 4.1395727303E+00, 9.7320830288E-01],
	[3.7290000000E+04, 4.2496436442E+01, 5.6142697121E+00, 2.5064160927E+01, 4.1399888173E+00, 9.7322179079E-01],
	[3.7295000000E+04, 4.2506340534E+01, 5.6143071329E+00, 2.5075220168E+01, 4.1404047770E+00, 9.7323527119E-01],
	[3.7300000000E+04, 4.2516245607E+01, 5.6143445490E+00, 2.5086282804E+01, 4.1408206094E+00, 9.7324874408E-01],
	[3.7305000000E+04, 4.2526151659E+01, 5.6143819602E+00, 2.5097348835E+01, 4.1412363146E+00, 9.7326220947E-01],
	[3.7310000000E+04, 4.2536058691E+01, 5.6144193667E+00, 2.5108418264E+01, 4.1416518925E+00, 9.7327566737E-01],
	[3.7315000000E+04, 4.2545966703E+01, 5.6144567684E+00, 2.5119491089E+01, 4.1420673433E+00, 9.7328911777E-01],
	[3.7320000000E+04, 4.2555875695E+01, 5.6144941654E+00, 2.5130567311E+01, 4.1424826669E+00, 9.7330256068E-01],
	[3.7325000000E+04, 4.2565785667E+01, 5.6145315576E+00, 2.5141646932E+01, 4.1428978635E+00, 9.7331599611E-01],
	[3.7330000000E+04, 4.2575696619E+01, 5.6145689451E+00, 2.5152729952E+01, 4.1433129329E+00, 9.7332942406E-01],
	[3.7335000000E+04, 4.2585608550E+01, 5.6146063278E+00, 2.5163816371E+01, 4.1437278754E+00, 9.7334284453E-01],
	[3.7340000000E+04, 4.2595521462E+01, 5.6146437057E+00, 2.5174906189E+01, 4.1441426909E+00, 9.7335625753E-01],
	[3.7345000000E+04, 4.2605435353E+01, 5.6146810789E+00, 2.5185999409E+01, 4.1445573794E+00, 9.7336966307E-01],
	[3.7350000000E+04, 4.2615350223E+01, 5.6147184473E+00, 2.5197096029E+01, 4.1449719411E+00, 9.7338306114E-01],
	[3.7355000000E+04, 4.2625266074E+01, 5.6147558109E+00, 2.5208196051E+01, 4.1453863759E+00, 9.7339645176E-01],
	[3.7360000000E+04, 4.2635182904E+01, 5.6147931699E+00, 2.5219299475E+01, 4.1458006838E+00, 9.7340983492E-01],
	[3.7365000000E+04, 4.2645100713E+01, 5.6148305240E+00, 2.5230406302E+01, 4.1462148650E+00, 9.7342321063E-01],
	[3.7370000000E+04, 4.2655019503E+01, 5.6148678734E+00, 2.5241516533E+01, 4.1466289195E+00, 9.7343657890E-01],
	[3.7375000000E+04, 4.2664939271E+01, 5.6149052181E+00, 2.5252630167E+01, 4.1470428472E+00, 9.7344993973E-01],
	[3.7380000000E+04, 4.2674860019E+01, 5.6149425580E+00, 2.5263747206E+01, 4.1474566483E+00, 9.7346329312E-01],
	[3.7385000000E+04, 4.2684781747E+01, 5.6149798932E+00, 2.5274867650E+01, 4.1478703227E+00, 9.7347663908E-01],
	[3.7390000000E+04, 4.2694704454E+01, 5.6150172236E+00, 2.5285991500E+01, 4.1482838706E+00, 9.7348997762E-01],
	[3.7395000000E+04, 4.2704628141E+01, 5.6150545493E+00, 2.5297118757E+01, 4.1486972919E+00, 9.7350330872E-01],
	[3.7400000000E+04, 4.2714552806E+01, 5.6150918703E+00, 2.5308249420E+01, 4.1491105867E+00, 9.7351663242E-01],
	[3.7405000000E+04, 4.2724496559E+01, 5.6151309917E+00, 2.5319383491E+01, 4.1495249117E+00, 9.7352994869E-01],
	[3.7410000000E+04, 4.2734446842E+01, 5.6151706609E+00, 2.5330520970E+01, 4.1499394647E+00, 9.7354325756E-01],
	[3.7415000000E+04, 4.2744398113E+01, 5.6152103252E+00, 2.5341661857E+01, 4.1503538916E+00, 9.7355655902E-01],
	[3.7420000000E+04, 4.2754350370E+01, 5.6152499844E+00, 2.5352806154E+01, 4.1507681925E+00, 9.7356985308E-01],
	[3.7425000000E+04, 4.2764303615E+01, 5.6152896386E+00, 2.5363953861E+01, 4.1511823672E+00, 9.7358313974E-01],
	[3.7430000000E+04, 4.2774257847E+01, 5.6153292878E+00, 2.5375104978E+01, 4.1515964160E+00, 9.7359641901E-01],
	[3.7435000000E+04, 4.2784213065E+01, 5.6153689319E+00, 2.5386259506E+01, 4.1520103389E+00, 9.7360969090E-01],
	[3.7440000000E+04, 4.2794169271E+01, 5.6154085711E+00, 2.5397417446E+01, 4.1524241358E+00, 9.7362295540E-01],
	[3.7445000000E+04, 4.2804126463E+01, 5.6154482052E+00, 2.5408578798E+01, 4.1528378069E+00, 9.7363621251E-01],
	[3.7450000000E+04, 4.2814084643E+01, 5.6154878344E+00, 2.5419743563E+01, 4.1532513521E+00, 9.7364946226E-01],
	[3.7455000000E+04, 4.2824043809E+01, 5.6155274585E+00, 2.5430911742E+01, 4.1536647715E+00, 9.7366270463E-01],
	[3.7460000000E+04, 4.2834003962E+01, 5.6155670776E+00, 2.5442083334E+01, 4.1540780651E+00, 9.7367593964E-01],
	[3.7465000000E+04, 4.2843965101E+01, 5.6156066917E+00, 2.5453258341E+01, 4.1544912331E+00, 9.7368916728E-01],
	[3.7470000000E+04, 4.2853927227E+01, 5.6156463008E+00, 2.5464436763E+01, 4.1549042753E+00, 9.7370238757E-01],
	[3.7475000000E+04, 4.2863890341E+01, 5.6156859048E+00, 2.5475618601E+01, 4.1553171919E+00, 9.7371560051E-01],
	[3.7480000000E+04, 4.2873854440E+01, 5.6157255039E+00, 2.5486803855E+01, 4.1557299829E+00, 9.7372880609E-01],
	[3.7485000000E+04, 4.2883819526E+01, 5.6157650980E+00, 2.5497992526E+01, 4.1561426484E+00, 9.7374200433E-01],
	[3.7490000000E+04, 4.2893785599E+01, 5.6158046871E+00, 2.5509184614E+01, 4.1565551883E+00, 9.7375519523E-01],
	[3.7495000000E+04, 4.2903752659E+01, 5.6158442711E+00, 2.5520380121E+01, 4.1569676027E+00, 9.7376837880E-01],
	[3.7500000000E+04, 4.2913720705E+01, 5.6158838502E+00, 2.5531579046E+01, 4.1573798916E+00, 9.7378155503E-01],
	[3.7505000000E+04, 4.2923689737E+01, 5.6159234243E+00, 2.5542781391E+01, 4.1577920552E+00, 9.7379472393E-01],
	[3.7510000000E+04, 4.2933659756E+01, 5.6159629934E+00, 2.5553987155E+01, 4.1582040934E+00, 9.7380788552E-01],
	[3.7515000000E+04, 4.2943630761E+01, 5.6160025574E+00, 2.5565196340E+01, 4.1586160062E+00, 9.7382103978E-01],
	[3.7520000000E+04, 4.2953602753E+01, 5.6160421165E+00, 2.5576408946E+01, 4.1590277938E+00, 9.7383418673E-01],
	[3.7525000000E+04, 4.2963575731E+01, 5.6160816706E+00, 2.5587624973E+01, 4.1594394561E+00, 9.7384732637E-01],
	[3.7530000000E+04, 4.2973549695E+01, 5.6161212197E+00, 2.5598844423E+01, 4.1598509932E+00, 9.7386045870E-01],
	[3.7535000000E+04, 4.2983524646E+01, 5.6161607638E+00, 2.5610067296E+01, 4.1602624051E+00, 9.7387358373E-01],
	[3.7540000000E+04, 4.2993500582E+01, 5.6162003030E+00, 2.5621293592E+01, 4.1606736918E+00, 9.7388670147E-01],
	[3.7545000000E+04, 4.3003477505E+01, 5.6162398371E+00, 2.5632523311E+01, 4.1610848535E+00, 9.7389981191E-01],
	[3.7550000000E+04, 4.3013455415E+01, 5.6162793663E+00, 2.5643756456E+01, 4.1614958901E+00, 9.7391291506E-01],
	[3.7555000000E+04, 4.3023434310E+01, 5.6163188904E+00, 2.5654993025E+01, 4.1619068017E+00, 9.7392601094E-01],
	[3.7560000000E+04, 4.3033414191E+01, 5.6163584096E+00, 2.5666233021E+01, 4.1623175883E+00, 9.7393909953E-01],
	[3.7565000000E+04, 4.3043395059E+01, 5.6163979238E+00, 2.5677476442E+01, 4.1627282499E+00, 9.7395218084E-01],
	[3.7570000000E+04, 4.3053376912E+01, 5.6164374330E+00, 2.5688723291E+01, 4.1631387867E+00, 9.7396525489E-01],
	[3.7575000000E+04, 4.3063359752E+01, 5.6164769373E+00, 2.5699973567E+01, 4.1635491986E+00, 9.7397832166E-01],
	[3.7580000000E+04, 4.3073343578E+01, 5.6165164365E+00, 2.5711227271E+01, 4.1639594856E+00, 9.7399138118E-01],
	[3.7585000000E+04, 4.3083328389E+01, 5.6165559308E+00, 2.5722484404E+01, 4.1643696479E+00, 9.7400443343E-01],
	[3.7590000000E+04, 4.3093314186E+01, 5.6165954201E+00, 2.5733744966E+01, 4.1647796854E+00, 9.7401747844E-01],
	[3.7595000000E+04, 4.3103300970E+01, 5.6166349044E+00, 2.5745008958E+01, 4.1651895982E+00, 9.7403051619E-01],
	[3.7600000000E+04, 4.3113288739E+01, 5.6166743838E+00, 2.5756276380E+01, 4.1655993863E+00, 9.7404354670E-01],
	[3.7605000000E+04, 4.3123277494E+01, 5.6167138582E+00, 2.5767547233E+01, 4.1660090498E+00, 9.7405656997E-01],
	[3.7610000000E+04, 4.3133267234E+01, 5.6167533276E+00, 2.5778821518E+01, 4.1664185887E+00, 9.7406958600E-01],
	[3.7615000000E+04, 4.3143257961E+01, 5.6167927921E+00, 2.5790099235E+01, 4.1668280030E+00, 9.7408259480E-01],
	[3.7620000000E+04, 4.3153249673E+01, 5.6168322515E+00, 2.5801380385E+01, 4.1672372928E+00, 9.7409559637E-01],
	[3.7625000000E+04, 4.3163242370E+01, 5.6168717060E+00, 2.5812664969E+01, 4.1676464582E+00, 9.7410859072E-01],
	[3.7630000000E+04, 4.3173236054E+01, 5.6169111556E+00, 2.5823952986E+01, 4.1680554990E+00, 9.7412157785E-01],
	[3.7635000000E+04, 4.3183230723E+01, 5.6169506002E+00, 2.5835244438E+01, 4.1684644155E+00, 9.7413455776E-01],
	[3.7640000000E+04, 4.3193226377E+01, 5.6169900398E+00, 2.5846539325E+01, 4.1688732077E+00, 9.7414753046E-01],
	[3.7645000000E+04, 4.3203223017E+01, 5.6170294744E+00, 2.5857837647E+01, 4.1692818755E+00, 9.7416049596E-01],
	[3.7650000000E+04, 4.3213220643E+01, 5.6170689041E+00, 2.5869139406E+01, 4.1696904190E+00, 9.7417345425E-01],
	[3.7655000000E+04, 4.3223219254E+01, 5.6171083289E+00, 2.5880444602E+01, 4.1700988383E+00, 9.7418640535E-01],
	[3.7660000000E+04, 4.3233218850E+01, 5.6171477487E+00, 2.5891753236E+01, 4.1705071333E+00, 9.7419934925E-01],
	[3.7665000000E+04, 4.3243219432E+01, 5.6171871635E+00, 2.5903065307E+01, 4.1709153042E+00, 9.7421228597E-01],
	[3.7670000000E+04, 4.3253221000E+01, 5.6172265733E+00, 2.5914380817E+01, 4.1713233510E+00, 9.7422521549E-01],
	[3.7675000000E+04, 4.3263223552E+01, 5.6172659783E+00, 2.5925699767E+01, 4.1717312736E+00, 9.7423813784E-01],
	[3.7680000000E+04, 4.3273227090E+01, 5.6173053782E+00, 2.5937022156E+01, 4.1721390722E+00, 9.7425105302E-01],
	[3.7685000000E+04, 4.3283231613E+01, 5.6173447732E+00, 2.5948347985E+01, 4.1725467468E+00, 9.7426396102E-01],
	[3.7690000000E+04, 4.3293237121E+01, 5.6173841633E+00, 2.5959677256E+01, 4.1729542975E+00, 9.7427686185E-01],
	[3.7695000000E+04, 4.3303243615E+01, 5.6174235484E+00, 2.5971009968E+01, 4.1733617241E+00, 9.7428975552E-01],
	[3.7700000000E+04, 4.3313251094E+01, 5.6174629285E+00, 2.5982346123E+01, 4.1737690269E+00, 9.7430264203E-01],
	[3.7705000000E+04, 4.3323259558E+01, 5.6175023038E+00, 2.5993685720E+01, 4.1741762059E+00, 9.7431552138E-01],
	[3.7710000000E+04, 4.3333269006E+01, 5.6175416740E+00, 2.6005028761E+01, 4.1745832610E+00, 9.7432839359E-01],
	[3.7715000000E+04, 4.3343279440E+01, 5.6175810394E+00, 2.6016375245E+01, 4.1749901923E+00, 9.7434125865E-01],
	[3.7720000000E+04, 4.3353290859E+01, 5.6176203997E+00, 2.6027725175E+01, 4.1753969998E+00, 9.7435411656E-01],
	[3.7725000000E+04, 4.3363303263E+01, 5.6176597552E+00, 2.6039078549E+01, 4.1758036837E+00, 9.7436696734E-01],
	[3.7730000000E+04, 4.3373316652E+01, 5.6176991057E+00, 2.6050435369E+01, 4.1762102439E+00, 9.7437981099E-01],
	[3.7735000000E+04, 4.3383331026E+01, 5.6177384512E+00, 2.6061795635E+01, 4.1766166805E+00, 9.7439264750E-01],
	[3.7740000000E+04, 4.3393346385E+01, 5.6177777919E+00, 2.6073159348E+01, 4.1770229935E+00, 9.7440547689E-01],
	[3.7745000000E+04, 4.3403362729E+01, 5.6178171276E+00, 2.6084526509E+01, 4.1774291829E+00, 9.7441829917E-01],
	[3.7750000000E+04, 4.3413380057E+01, 5.6178564583E+00, 2.6095897118E+01, 4.1778352488E+00, 9.7443111432E-01],
	[3.7755000000E+04, 4.3423398370E+01, 5.6178957841E+00, 2.6107271175E+01, 4.1782411913E+00, 9.7444392236E-01],
	[3.7760000000E+04, 4.3433417668E+01, 5.6179351050E+00, 2.6118648682E+01, 4.1786470103E+00, 9.7445672330E-01],
	[3.7765000000E+04, 4.3443437951E+01, 5.6179744210E+00, 2.6130029639E+01, 4.1790527059E+00, 9.7446951713E-01],
	[3.7770000000E+04, 4.3453459219E+01, 5.6180137320E+00, 2.6141414046E+01, 4.1794582781E+00, 9.7448230386E-01],
	[3.7775000000E+04, 4.3463481471E+01, 5.6180530381E+00, 2.6152801904E+01, 4.1798637271E+00, 9.7449508350E-01],
	[3.7780000000E+04, 4.3473504707E+01, 5.6180923393E+00, 2.6164193213E+01, 4.1802690527E+00, 9.7450785605E-01],
	[3.7785000000E+04, 4.3483528929E+01, 5.6181316355E+00, 2.6175587975E+01, 4.1806742551E+00, 9.7452062151E-01],
	[3.7790000000E+04, 4.3493554134E+01, 5.6181709268E+00, 2.6186986190E+01, 4.1810793343E+00, 9.7453337988E-01],
	[3.7795000000E+04, 4.3503580325E+01, 5.6182102132E+00, 2.6198387858E+01, 4.1814842904E+00, 9.7454613118E-01],
	[3.7800000000E+04, 4.3513607500E+01, 5.6182494947E+00, 2.6209792980E+01, 4.1818891233E+00, 9.7455887541E-01],
	[3.7805000000E+04, 4.3523635659E+01, 5.6182887712E+00, 2.6221201556E+01, 4.1822938331E+00, 9.7457161257E-01],
	[3.7810000000E+04, 4.3533664803E+01, 5.6183280429E+00, 2.6232613588E+01, 4.1826984199E+00, 9.7458434266E-01],
	[3.7815000000E+04, 4.3543694931E+01, 5.6183673096E+00, 2.6244029076E+01, 4.1831028836E+00, 9.7459706569E-01],
	[3.7820000000E+04, 4.3553726043E+01, 5.6184065714E+00, 2.6255448019E+01, 4.1835072244E+00, 9.7460978167E-01],
	[3.7825000000E+04, 4.3563758140E+01, 5.6184458283E+00, 2.6266870420E+01, 4.1839114423E+00, 9.7462249059E-01],
	[3.7830000000E+04, 4.3573791221E+01, 5.6184850802E+00, 2.6278296278E+01, 4.1843155373E+00, 9.7463519246E-01],
	[3.7835000000E+04, 4.3583825287E+01, 5.6185243273E+00, 2.6289725594E+01, 4.1847195094E+00, 9.7464788729E-01],
	[3.7840000000E+04, 4.3593860336E+01, 5.6185635694E+00, 2.6301158369E+01, 4.1851233587E+00, 9.7466057508E-01],
	[3.7845000000E+04, 4.3603896370E+01, 5.6186028067E+00, 2.6312594604E+01, 4.1855270852E+00, 9.7467325584E-01],
	[3.7850000000E+04, 4.3613933388E+01, 5.6186420390E+00, 2.6324034298E+01, 4.1859306889E+00, 9.7468592956E-01],
	[3.7855000000E+04, 4.3623971390E+01, 5.6186812664E+00, 2.6335477452E+01, 4.1863341700E+00, 9.7469859626E-01],
	[3.7860000000E+04, 4.3634010376E+01, 5.6187204889E+00, 2.6346924068E+01, 4.1867375284E+00, 9.7471125594E-01],
	[3.7865000000E+04, 4.3644050346E+01, 5.6187597065E+00, 2.6358374145E+01, 4.1871407642E+00, 9.7472390859E-01],
	[3.7870000000E+04, 4.3654091300E+01, 5.6187989192E+00, 2.6369827684E+01, 4.1875438774E+00, 9.7473655424E-01],
	[3.7875000000E+04, 4.3664133238E+01, 5.6188381270E+00, 2.6381284686E+01, 4.1879468680E+00, 9.7474919287E-01],
	[3.7880000000E+04, 4.3674176160E+01, 5.6188773299E+00, 2.6392745152E+01, 4.1883497361E+00, 9.7476182450E-01],
	[3.7885000000E+04, 4.3684220066E+01, 5.6189165279E+00, 2.6404209081E+01, 4.1887524818E+00, 9.7477444912E-01],
	[3.7890000000E+04, 4.3694264956E+01, 5.6189557209E+00, 2.6415676476E+01, 4.1891551050E+00, 9.7478706675E-01],
	[3.7895000000E+04, 4.3704310830E+01, 5.6189949091E+00, 2.6427147335E+01, 4.1895576059E+00, 9.7479967739E-01],
	[3.7900000000E+04, 4.3714357688E+01, 5.6190340924E+00, 2.6438621660E+01, 4.1899599843E+00, 9.7481228104E-01],
	[3.7905000000E+04, 4.3724405529E+01, 5.6190732708E+00, 2.6450099451E+01, 4.1903622405E+00, 9.7482487770E-01],
	[3.7910000000E+04, 4.3734454354E+01, 5.6191124443E+00, 2.6461580709E+01, 4.1907643744E+00, 9.7483746738E-01],
	[3.7915000000E+04, 4.3744504163E+01, 5.6191516129E+00, 2.6473065435E+01, 4.1911663860E+00, 9.7485005009E-01],
	[3.7920000000E+04, 4.3754554956E+01, 5.6191907767E+00, 2.6484553629E+01, 4.1915682754E+00, 9.7486262582E-01],
	[3.7925000000E+04, 4.3764606732E+01, 5.6192299355E+00, 2.6496045292E+01, 4.1919700427E+00, 9.7487519459E-01],
	[3.7930000000E+04, 4.3774659491E+01, 5.6192690894E+00, 2.6507540424E+01, 4.1923716879E+00, 9.7488775640E-01],
	[3.7935000000E+04, 4.3784713235E+01, 5.6193082385E+00, 2.6519039025E+01, 4.1927732109E+00, 9.7490031124E-01],
	[3.7940000000E+04, 4.3794767962E+01, 5.6193473826E+00, 2.6530541098E+01, 4.1931746119E+00, 9.7491285913E-01],
	[3.7945000000E+04, 4.3804823672E+01, 5.6193865219E+00, 2.6542046641E+01, 4.1935758909E+00, 9.7492540007E-01],
	[3.7950000000E+04, 4.3814880366E+01, 5.6194256563E+00, 2.6553555656E+01, 4.1939770480E+00, 9.7493793406E-01],
	[3.7955000000E+04, 4.3824938043E+01, 5.6194647858E+00, 2.6565068143E+01, 4.1943780831E+00, 9.7495046112E-01],
	[3.7960000000E+04, 4.3834996704E+01, 5.6195039104E+00, 2.6576584103E+01, 4.1947789963E+00, 9.7496298123E-01],
	[3.7965000000E+04, 4.3845056348E+01, 5.6195430302E+00, 2.6588103536E+01, 4.1951797876E+00, 9.7497549441E-01],
	[3.7970000000E+04, 4.3855116976E+01, 5.6195821450E+00, 2.6599626444E+01, 4.1955804571E+00, 9.7498800066E-01],
	[3.7975000000E+04, 4.3865178587E+01, 5.6196212550E+00, 2.6611152826E+01, 4.1959810049E+00, 9.7500049998E-01],
	[3.7980000000E+04, 4.3875241181E+01, 5.6196603601E+00, 2.6622682683E+01, 4.1963814309E+00, 9.7501299239E-01],
	[3.7985000000E+04, 4.3885304758E+01, 5.6196994604E+00, 2.6634216016E+01, 4.1967817352E+00, 9.7502547787E-01],
	[3.7990000000E+04, 4.3895369319E+01, 5.6197385557E+00, 2.6645752825E+01, 4.1971819179E+00, 9.7503795645E-01],
	[3.7995000000E+04, 4.3905434863E+01, 5.6197776462E+00, 2.6657293111E+01, 4.1975819789E+00, 9.7505042811E-01],
	[3.8000000000E+04, 4.3915501390E+01, 5.6198167318E+00, 2.6668836875E+01, 4.1979819183E+00, 9.7506289287E-01],
	[3.8005000000E+04, 4.3925576984E+01, 5.6198566070E+00, 2.6680384117E+01, 4.1983822534E+00, 9.7507535073E-01],
	[3.8010000000E+04, 4.3935668986E+01, 5.6198979920E+00, 2.6691934837E+01, 4.1987834535E+00, 9.7508780170E-01],
	[3.8015000000E+04, 4.3945761978E+01, 5.6199393720E+00, 2.6703489037E+01, 4.1991845324E+00, 9.7510024577E-01],
	[3.8020000000E+04, 4.3955855961E+01, 5.6199807468E+00, 2.6715046717E+01, 4.1995854902E+00, 9.7511268296E-01],
	[3.8025000000E+04, 4.3965950935E+01, 5.6200221165E+00, 2.6726607877E+01, 4.1999863268E+00, 9.7512511326E-01],
	[3.8030000000E+04, 4.3976046899E+01, 5.6200634810E+00, 2.6738172518E+01, 4.2003870423E+00, 9.7513753668E-01],
	[3.8035000000E+04, 4.3986143854E+01, 5.6201048404E+00, 2.6749740642E+01, 4.2007876367E+00, 9.7514995323E-01],
	[3.8040000000E+04, 4.3996241799E+01, 5.6201461947E+00, 2.6761312247E+01, 4.2011881101E+00, 9.7516236291E-01],
	[3.8045000000E+04, 4.4006340736E+01, 5.6201875438E+00, 2.6772887335E+01, 4.2015884626E+00, 9.7517476572E-01],
	[3.8050000000E+04, 4.4016440662E+01, 5.6202288878E+00, 2.6784465906E+01, 4.2019886941E+00, 9.7518716167E-01],
	[3.8055000000E+04, 4.4026541579E+01, 5.6202702267E+00, 2.6796047962E+01, 4.2023888047E+00, 9.7519955076E-01],
	[3.8060000000E+04, 4.4036643487E+01, 5.6203115605E+00, 2.6807633502E+01, 4.2027887944E+00, 9.7521193300E-01],
	[3.8065000000E+04, 4.4046746385E+01, 5.6203528891E+00, 2.6819222528E+01, 4.2031886632E+00, 9.7522430838E-01],
	[3.8070000000E+04, 4.4056850273E+01, 5.6203942126E+00, 2.6830815039E+01, 4.2035884113E+00, 9.7523667693E-01],
	[3.8075000000E+04, 4.4066955152E+01, 5.6204355310E+00, 2.6842411036E+01, 4.2039880387E+00, 9.7524903863E-01],
	[3.8080000000E+04, 4.4077061021E+01, 5.6204768442E+00, 2.6854010521E+01, 4.2043875453E+00, 9.7526139349E-01],
	[3.8085000000E+04, 4.4087167880E+01, 5.6205181524E+00, 2.6865613493E+01, 4.2047869312E+00, 9.7527374152E-01],
	[3.8090000000E+04, 4.4097275729E+01, 5.6205594554E+00, 2.6877219953E+01, 4.2051861965E+00, 9.7528608272E-01],
	[3.8095000000E+04, 4.4107384569E+01, 5.6206007533E+00, 2.6888829902E+01, 4.2055853412E+00, 9.7529841710E-01],
	[3.8100000000E+04, 4.4117494399E+01, 5.6206420461E+00, 2.6900443340E+01, 4.2059843653E+00, 9.7531074468E-01],
	[3.8105000000E+04, 4.4127605219E+01, 5.6206833338E+00, 2.6912060269E+01, 4.2063832689E+00, 9.7532306545E-01],
	[3.8110000000E+04, 4.4137717029E+01, 5.6207246163E+00, 2.6923680688E+01, 4.2067820520E+00, 9.7533537943E-01],
	[3.8115000000E+04, 4.4147829830E+01, 5.6207658938E+00, 2.6935304597E+01, 4.2071807146E+00, 9.7534768662E-01],
	[3.8120000000E+04, 4.4157943620E+01, 5.6208071661E+00, 2.6946931999E+01, 4.2075792569E+00, 9.7535998703E-01],
	[3.8125000000E+04, 4.4168058400E+01, 5.6208484333E+00, 2.6958562893E+01, 4.2079776787E+00, 9.7537228064E-01],
	[3.8130000000E+04, 4.4178174171E+01, 5.6208896954E+00, 2.6970197280E+01, 4.2083759802E+00, 9.7538456748E-01],
	[3.8135000000E+04, 4.4188290931E+01, 5.6209309524E+00, 2.6981835160E+01, 4.2087741615E+00, 9.7539684754E-01],
	[3.8140000000E+04, 4.4198408681E+01, 5.6209722043E+00, 2.6993476534E+01, 4.2091722224E+00, 9.7540912082E-01],
	[3.8145000000E+04, 4.4208527421E+01, 5.6210134511E+00, 2.7005121403E+01, 4.2095701631E+00, 9.7542138733E-01],
	[3.8150000000E+04, 4.4218647151E+01, 5.6210546928E+00, 2.7016769767E+01, 4.2099679837E+00, 9.7543364708E-01],
	[3.8155000000E+04, 4.4228767871E+01, 5.6210959294E+00, 2.7028421627E+01, 4.2103656841E+00, 9.7544590007E-01],
	[3.8160000000E+04, 4.4238889580E+01, 5.6211371609E+00, 2.7040076983E+01, 4.2107632644E+00, 9.7545814629E-01],
	[3.8165000000E+04, 4.4249012280E+01, 5.6211783873E+00, 2.7051735837E+01, 4.2111607246E+00, 9.7547038576E-01],
	[3.8170000000E+04, 4.4259135969E+01, 5.6212196086E+00, 2.7063398188E+01, 4.2115580648E+00, 9.7548261848E-01],
	[3.8175000000E+04, 4.4269260647E+01, 5.6212608247E+00, 2.7075064037E+01, 4.2119552850E+00, 9.7549484445E-01],
	[3.8180000000E+04, 4.4279386316E+01, 5.6213020358E+00, 2.7086733385E+01, 4.2123523852E+00, 9.7550706368E-01],
	[3.8185000000E+04, 4.4289512974E+01, 5.6213432418E+00, 2.7098406232E+01, 4.2127493655E+00, 9.7551927616E-01],
	[3.8190000000E+04, 4.4299640621E+01, 5.6213844428E+00, 2.7110082580E+01, 4.2131462260E+00, 9.7553148191E-01],
	[3.8195000000E+04, 4.4309769258E+01, 5.6214256386E+00, 2.7121762427E+01, 4.2135429665E+00, 9.7554368092E-01],
	[3.8200000000E+04, 4.4319898885E+01, 5.6214668293E+00, 2.7133445776E+01, 4.2139395873E+00, 9.7555587321E-01],
	[3.8205000000E+04, 4.4330029501E+01, 5.6215080149E+00, 2.7145132627E+01, 4.2143360883E+00, 9.7556805876E-01],
	[3.8210000000E+04, 4.4340161107E+01, 5.6215491955E+00, 2.7156822980E+01, 4.2147324696E+00, 9.7558023760E-01],
	[3.8215000000E+04, 4.4350293702E+01, 5.6215903709E+00, 2.7168516836E+01, 4.2151287312E+00, 9.7559240972E-01],
	[3.8220000000E+04, 4.4360427286E+01, 5.6216315413E+00, 2.7180214195E+01, 4.2155248731E+00, 9.7560457512E-01],
	[3.8225000000E+04, 4.4370561860E+01, 5.6216727066E+00, 2.7191915059E+01, 4.2159208955E+00, 9.7561673381E-01],
	[3.8230000000E+04, 4.4380697423E+01, 5.6217138668E+00, 2.7203619427E+01, 4.2163167982E+00, 9.7562888579E-01],
	[3.8235000000E+04, 4.4390833976E+01, 5.6217550219E+00, 2.7215327301E+01, 4.2167125814E+00, 9.7564103106E-01],
	[3.8240000000E+04, 4.4400971517E+01, 5.6217961720E+00, 2.7227038680E+01, 4.2171082451E+00, 9.7565316964E-01],
	[3.8245000000E+04, 4.4411110048E+01, 5.6218373170E+00, 2.7238753566E+01, 4.2175037893E+00, 9.7566530152E-01],
	[3.8250000000E+04, 4.4421249568E+01, 5.6218784569E+00, 2.7250471959E+01, 4.2178992141E+00, 9.7567742671E-01],
	[3.8255000000E+04, 4.4431390078E+01, 5.6219195917E+00, 2.7262193859E+01, 4.2182945195E+00, 9.7568954520E-01],
	[3.8260000000E+04, 4.4441531576E+01, 5.6219607214E+00, 2.7273919268E+01, 4.2186897056E+00, 9.7570165701E-01],
	[3.8265000000E+04, 4.4451674063E+01, 5.6220018461E+00, 2.7285648186E+01, 4.2190847723E+00, 9.7571376214E-01],
	[3.8270000000E+04, 4.4461817540E+01, 5.6220429657E+00, 2.7297380613E+01, 4.2194797198E+00, 9.7572586059E-01],
	[3.8275000000E+04, 4.4471962006E+01, 5.6220840802E+00, 2.7309116550E+01, 4.2198745481E+00, 9.7573795236E-01],
	[3.8280000000E+04, 4.4482107460E+01, 5.6221251896E+00, 2.7320855997E+01, 4.2202692571E+00, 9.7575003746E-01],
	[3.8285000000E+04, 4.4492253904E+01, 5.6221662940E+00, 2.7332598956E+01, 4.2206638470E+00, 9.7576211590E-01],
	[3.8290000000E+04, 4.4502401336E+01, 5.6222073933E+00, 2.7344345426E+01, 4.2210583177E+00, 9.7577418767E-01],
	[3.8295000000E+04, 4.4512549758E+01, 5.6222484876E+00, 2.7356095409E+01, 4.2214526694E+00, 9.7578625278E-01],
	[3.8300000000E+04, 4.4522699168E+01, 5.6222895768E+00, 2.7367848905E+01, 4.2218469020E+00, 9.7579831123E-01],
	[3.8305000000E+04, 4.4532849567E+01, 5.6223306609E+00, 2.7379605915E+01, 4.2222410156E+00, 9.7581036303E-01],
	[3.8310000000E+04, 4.4543000955E+01, 5.6223717399E+00, 2.7391366438E+01, 4.2226350102E+00, 9.7582240818E-01],
	[3.8315000000E+04, 4.4553153331E+01, 5.6224128139E+00, 2.7403130476E+01, 4.2230288859E+00, 9.7583444669E-01],
	[3.8320000000E+04, 4.4563306697E+01, 5.6224538829E+00, 2.7414898030E+01, 4.2234226427E+00, 9.7584647855E-01],
	[3.8325000000E+04, 4.4573461051E+01, 5.6224949468E+00, 2.7426669099E+01, 4.2238162807E+00, 9.7585850377E-01],
	[3.8330000000E+04, 4.4583616394E+01, 5.6225360056E+00, 2.7438443685E+01, 4.2242097998E+00, 9.7587052236E-01],
	[3.8335000000E+04, 4.4593772725E+01, 5.6225770593E+00, 2.7450221789E+01, 4.2246032001E+00, 9.7588253432E-01],
	[3.8340000000E+04, 4.4603930045E+01, 5.6226181081E+00, 2.7462003409E+01, 4.2249964817E+00, 9.7589453965E-01],
	[3.8345000000E+04, 4.4614088354E+01, 5.6226591517E+00, 2.7473788548E+01, 4.2253896446E+00, 9.7590653835E-01],
	[3.8350000000E+04, 4.4624247651E+01, 5.6227001903E+00, 2.7485577206E+01, 4.2257826888E+00, 9.7591853044E-01],
	[3.8355000000E+04, 4.4634407937E+01, 5.6227412239E+00, 2.7497369384E+01, 4.2261756144E+00, 9.7593051591E-01],
	[3.8360000000E+04, 4.4644569211E+01, 5.6227822524E+00, 2.7509165081E+01, 4.2265684214E+00, 9.7594249476E-01],
	[3.8365000000E+04, 4.4654731473E+01, 5.6228232758E+00, 2.7520964299E+01, 4.2269611098E+00, 9.7595446701E-01],
	[3.8370000000E+04, 4.4664894724E+01, 5.6228642943E+00, 2.7532767039E+01, 4.2273536797E+00, 9.7596643265E-01],
	[3.8375000000E+04, 4.4675058964E+01, 5.6229053076E+00, 2.7544573300E+01, 4.2277461311E+00, 9.7597839169E-01],
	[3.8380000000E+04, 4.4685224191E+01, 5.6229463159E+00, 2.7556383083E+01, 4.2281384641E+00, 9.7599034413E-01],
	[3.8385000000E+04, 4.4695390407E+01, 5.6229873192E+00, 2.7568196390E+01, 4.2285306787E+00, 9.7600228997E-01],
	[3.8390000000E+04, 4.4705557612E+01, 5.6230283175E+00, 2.7580013220E+01, 4.2289227749E+00, 9.7601422922E-01],
	[3.8395000000E+04, 4.4715725804E+01, 5.6230693107E+00, 2.7591833574E+01, 4.2293147527E+00, 9.7602616189E-01],
	[3.8400000000E+04, 4.4725894985E+01, 5.6231102988E+00, 2.7603657453E+01, 4.2297066123E+00, 9.7603808797E-01],
	[3.8405000000E+04, 4.4736065154E+01, 5.6231512819E+00, 2.7615484858E+01, 4.2300983536E+00, 9.7605000747E-01],
	[3.8410000000E+04, 4.4746236311E+01, 5.6231922600E+00, 2.7627315788E+01, 4.2304899768E+00, 9.7606192040E-01],
	[3.8415000000E+04, 4.4756408456E+01, 5.6232332331E+00, 2.7639150245E+01, 4.2308814817E+00, 9.7607382675E-01],
	[3.8420000000E+04, 4.4766581590E+01, 5.6232742011E+00, 2.7650988230E+01, 4.2312728685E+00, 9.7608572654E-01],
	[3.8425000000E+04, 4.4776755711E+01, 5.6233151641E+00, 2.7662829742E+01, 4.2316641371E+00, 9.7609761975E-01],
	[3.8430000000E+04, 4.4786930820E+01, 5.6233561220E+00, 2.7674674782E+01, 4.2320552878E+00, 9.7610950641E-01],
	[3.8435000000E+04, 4.4797106918E+01, 5.6233970749E+00, 2.7686523351E+01, 4.2324463203E+00, 9.7612138651E-01],
	[3.8440000000E+04, 4.4807284003E+01, 5.6234380228E+00, 2.7698375450E+01, 4.2328372349E+00, 9.7613326005E-01],
	[3.8445000000E+04, 4.4817462076E+01, 5.6234789657E+00, 2.7710231078E+01, 4.2332280316E+00, 9.7614512704E-01],
	[3.8450000000E+04, 4.4827641137E+01, 5.6235199035E+00, 2.7722090238E+01, 4.2336187103E+00, 9.7615698748E-01],
	[3.8455000000E+04, 4.4837821186E+01, 5.6235608363E+00, 2.7733952929E+01, 4.2340092711E+00, 9.7616884138E-01],
	[3.8460000000E+04, 4.4848002223E+01, 5.6236017641E+00, 2.7745819151E+01, 4.2343997141E+00, 9.7618068874E-01],
	[3.8465000000E+04, 4.4858184247E+01, 5.6236426869E+00, 2.7757688906E+01, 4.2347900393E+00, 9.7619252957E-01],
	[3.8470000000E+04, 4.4868367260E+01, 5.6236836046E+00, 2.7769562195E+01, 4.2351802468E+00, 9.7620436386E-01],
	[3.8475000000E+04, 4.4878551260E+01, 5.6237245173E+00, 2.7781439016E+01, 4.2355703365E+00, 9.7621619162E-01],
	[3.8480000000E+04, 4.4888736248E+01, 5.6237654250E+00, 2.7793319372E+01, 4.2359603085E+00, 9.7622801286E-01],
	[3.8485000000E+04, 4.4898922223E+01, 5.6238063277E+00, 2.7805203263E+01, 4.2363501628E+00, 9.7623982757E-01],
	[3.8490000000E+04, 4.4909109186E+01, 5.6238472254E+00, 2.7817090690E+01, 4.2367398996E+00, 9.7625163577E-01],
	[3.8495000000E+04, 4.4919297137E+01, 5.6238881180E+00, 2.7828981652E+01, 4.2371295188E+00, 9.7626343745E-01],
	[3.8500000000E+04, 4.4929486075E+01, 5.6239290057E+00, 2.7840876151E+01, 4.2375190204E+00, 9.7627523262E-01],
	[3.8505000000E+04, 4.4939676001E+01, 5.6239698883E+00, 2.7852774187E+01, 4.2379084045E+00, 9.7628702128E-01],
	[3.8510000000E+04, 4.4949866914E+01, 5.6240107659E+00, 2.7864675761E+01, 4.2382976712E+00, 9.7629880344E-01],
	[3.8515000000E+04, 4.4960058815E+01, 5.6240516385E+00, 2.7876580874E+01, 4.2386868204E+00, 9.7631057910E-01],
	[3.8520000000E+04, 4.4970251703E+01, 5.6240925061E+00, 2.7888489525E+01, 4.2390758523E+00, 9.7632234826E-01],
	[3.8525000000E+04, 4.4980445578E+01, 5.6241333687E+00, 2.7900401716E+01, 4.2394647667E+00, 9.7633411093E-01],
	[3.8530000000E+04, 4.4990640441E+01, 5.6241742263E+00, 2.7912317447E+01, 4.2398535639E+00, 9.7634586711E-01],
	[3.8535000000E+04, 4.5000836291E+01, 5.6242150789E+00, 2.7924236719E+01, 4.2402422438E+00, 9.7635761681E-01],
	[3.8540000000E+04, 4.5011033129E+01, 5.6242559264E+00, 2.7936159532E+01, 4.2406308065E+00, 9.7636936002E-01],
	[3.8545000000E+04, 4.5021230954E+01, 5.6242967690E+00, 2.7948085887E+01, 4.2410192519E+00, 9.7638109676E-01],
	[3.8550000000E+04, 4.5031429766E+01, 5.6243376066E+00, 2.7960015785E+01, 4.2414075802E+00, 9.7639282702E-01],
	[3.8555000000E+04, 4.5041629565E+01, 5.6243784392E+00, 2.7971949226E+01, 4.2417957914E+00, 9.7640455081E-01],
	[3.8560000000E+04, 4.5051830351E+01, 5.6244192667E+00, 2.7983886210E+01, 4.2421838855E+00, 9.7641626813E-01],
	[3.8565000000E+04, 4.5062032125E+01, 5.6244600893E+00, 2.7995826739E+01, 4.2425718625E+00, 9.7642797899E-01],
	[3.8570000000E+04, 4.5072234885E+01, 5.6245009069E+00, 2.8007770813E+01, 4.2429597225E+00, 9.7643968338E-01],
	[3.8575000000E+04, 4.5082438633E+01, 5.6245417195E+00, 2.8019718432E+01, 4.2433474655E+00, 9.7645138133E-01],
	[3.8580000000E+04, 4.5092643368E+01, 5.6245825271E+00, 2.8031669598E+01, 4.2437350916E+00, 9.7646307281E-01],
	[3.8585000000E+04, 4.5102849090E+01, 5.6246233297E+00, 2.8043624310E+01, 4.2441226008E+00, 9.7647475785E-01],
	[3.8590000000E+04, 4.5113055798E+01, 5.6246641273E+00, 2.8055582569E+01, 4.2445099932E+00, 9.7648643645E-01],
	[3.8595000000E+04, 4.5123263494E+01, 5.6247049199E+00, 2.8067544376E+01, 4.2448972686E+00, 9.7649810860E-01],
	[3.8600000000E+04, 4.5133472177E+01, 5.6247457075E+00, 2.8079509732E+01, 4.2452844274E+00, 9.7650977431E-01],
	[3.8605000000E+04, 4.5143681846E+01, 5.6247864902E+00, 2.8091478636E+01, 4.2456714693E+00, 9.7652143359E-01],
	[3.8610000000E+04, 4.5153892503E+01, 5.6248272678E+00, 2.8103451091E+01, 4.2460583946E+00, 9.7653308644E-01],
	[3.8615000000E+04, 4.5164104146E+01, 5.6248680405E+00, 2.8115427095E+01, 4.2464452031E+00, 9.7654473286E-01],
	[3.8620000000E+04, 4.5174339750E+01, 5.6249110331E+00, 2.8127406651E+01, 4.2468333664E+00, 9.7655637286E-01],
	[3.8625000000E+04, 4.5184576727E+01, 5.6249540572E+00, 2.8139389757E+01, 4.2472214375E+00, 9.7656800644E-01],
	[3.8630000000E+04, 4.5194814698E+01, 5.6249970760E+00, 2.8151376416E+01, 4.2476093923E+00, 9.7657963360E-01],
	[3.8635000000E+04, 4.5205053664E+01, 5.6250400896E+00, 2.8163366628E+01, 4.2479972309E+00, 9.7659125434E-01],
	[3.8640000000E+04, 4.5215293624E+01, 5.6250830980E+00, 2.8175360392E+01, 4.2483849532E+00, 9.7660286868E-01],
	[3.8645000000E+04, 4.5225534578E+01, 5.6251261011E+00, 2.8187357711E+01, 4.2487725593E+00, 9.7661447662E-01],
	[3.8650000000E+04, 4.5235776526E+01, 5.6251690990E+00, 2.8199358583E+01, 4.2491600492E+00, 9.7662607815E-01],
	[3.8655000000E+04, 4.5246019469E+01, 5.6252120917E+00, 2.8211363011E+01, 4.2495474229E+00, 9.7663767328E-01],
	[3.8660000000E+04, 4.5256263405E+01, 5.6252550791E+00, 2.8223370994E+01, 4.2499346806E+00, 9.7664926202E-01],
	[3.8665000000E+04, 4.5266508336E+01, 5.6252980613E+00, 2.8235382534E+01, 4.2503218222E+00, 9.7666084436E-01],
	[3.8670000000E+04, 4.5276754260E+01, 5.6253410383E+00, 2.8247397630E+01, 4.2507088477E+00, 9.7667242032E-01],
	[3.8675000000E+04, 4.5287001179E+01, 5.6253840100E+00, 2.8259416284E+01, 4.2510957573E+00, 9.7668398990E-01],
	[3.8680000000E+04, 4.5297249091E+01, 5.6254269765E+00, 2.8271438495E+01, 4.2514825509E+00, 9.7669555309E-01],
	[3.8685000000E+04, 4.5307497997E+01, 5.6254699378E+00, 2.8283464265E+01, 4.2518692286E+00, 9.7670710991E-01],
	[3.8690000000E+04, 4.5317747897E+01, 5.6255128939E+00, 2.8295493594E+01, 4.2522557905E+00, 9.7671866035E-01],
	[3.8695000000E+04, 4.5327998792E+01, 5.6255558447E+00, 2.8307526483E+01, 4.2526422364E+00, 9.7673020443E-01],
	[3.8700000000E+04, 4.5338250679E+01, 5.6255987904E+00, 2.8319562932E+01, 4.2530285666E+00, 9.7674174214E-01],
	[3.8705000000E+04, 4.5348503561E+01, 5.6256417308E+00, 2.8331602942E+01, 4.2534147810E+00, 9.7675327349E-01],
	[3.8710000000E+04, 4.5358757436E+01, 5.6256846659E+00, 2.8343646514E+01, 4.2538008797E+00, 9.7676479848E-01],
	[3.8715000000E+04, 4.5369012306E+01, 5.6257275959E+00, 2.8355693647E+01, 4.2541868627E+00, 9.7677631711E-01],
	[3.8720000000E+04, 4.5379268168E+01, 5.6257705207E+00, 2.8367744344E+01, 4.2545727300E+00, 9.7678782939E-01],
	[3.8725000000E+04, 4.5389525025E+01, 5.6258134402E+00, 2.8379798603E+01, 4.2549584817E+00, 9.7679933533E-01],
	[3.8730000000E+04, 4.5399782875E+01, 5.6258563545E+00, 2.8391856427E+01, 4.2553441178E+00, 9.7681083492E-01],
	[3.8735000000E+04, 4.5410041719E+01, 5.6258992636E+00, 2.8403917815E+01, 4.2557296384E+00, 9.7682232817E-01],
	[3.8740000000E+04, 4.5420301556E+01, 5.6259421675E+00, 2.8415982768E+01, 4.2561150435E+00, 9.7683381508E-01],
	[3.8745000000E+04, 4.5430562387E+01, 5.6259850662E+00, 2.8428051286E+01, 4.2565003331E+00, 9.7684529567E-01],
	[3.8750000000E+04, 4.5440824211E+01, 5.6260279597E+00, 2.8440123371E+01, 4.2568855072E+00, 9.7685676992E-01],
	[3.8755000000E+04, 4.5451087029E+01, 5.6260708479E+00, 2.8452199023E+01, 4.2572705660E+00, 9.7686823784E-01],
	[3.8760000000E+04, 4.5461350840E+01, 5.6261137310E+00, 2.8464278242E+01, 4.2576555094E+00, 9.7687969944E-01],
	[3.8765000000E+04, 4.5471615644E+01, 5.6261566089E+00, 2.8476361029E+01, 4.2580403375E+00, 9.7689115473E-01],
	[3.8770000000E+04, 4.5481881442E+01, 5.6261994815E+00, 2.8488447385E+01, 4.2584250503E+00, 9.7690260370E-01],
	[3.8775000000E+04, 4.5492148234E+01, 5.6262423490E+00, 2.8500537310E+01, 4.2588096478E+00, 9.7691404635E-01],
	[3.8780000000E+04, 4.5502416018E+01, 5.6262852112E+00, 2.8512630805E+01, 4.2591941302E+00, 9.7692548270E-01],
	[3.8785000000E+04, 4.5512684796E+01, 5.6263280683E+00, 2.8524727870E+01, 4.2595784973E+00, 9.7693691275E-01],
	[3.8790000000E+04, 4.5522954567E+01, 5.6263709201E+00, 2.8536828506E+01, 4.2599627493E+00, 9.7694833649E-01],
	[3.8795000000E+04, 4.5533225331E+01, 5.6264137668E+00, 2.8548932713E+01, 4.2603468862E+00, 9.7695975394E-01],
	[3.8800000000E+04, 4.5543497089E+01, 5.6264566082E+00, 2.8561040493E+01, 4.2607309081E+00, 9.7697116509E-01],
	[3.8805000000E+04, 4.5553769839E+01, 5.6264994445E+00, 2.8573151846E+01, 4.2611148149E+00, 9.7698256996E-01],
	[3.8810000000E+04, 4.5564043583E+01, 5.6265422756E+00, 2.8585266772E+01, 4.2614986068E+00, 9.7699396853E-01],
	[3.8815000000E+04, 4.5574318320E+01, 5.6265851015E+00, 2.8597385272E+01, 4.2618822837E+00, 9.7700536083E-01],
	[3.8820000000E+04, 4.5584594050E+01, 5.6266279222E+00, 2.8609507346E+01, 4.2622658456E+00, 9.7701674684E-01],
	[3.8825000000E+04, 4.5594870773E+01, 5.6266707377E+00, 2.8621632996E+01, 4.2626492927E+00, 9.7702812659E-01],
	[3.8830000000E+04, 4.5605148489E+01, 5.6267135480E+00, 2.8633762221E+01, 4.2630326250E+00, 9.7703950005E-01],
	[3.8835000000E+04, 4.5615427197E+01, 5.6267563531E+00, 2.8645895023E+01, 4.2634158424E+00, 9.7705086725E-01],
	[3.8840000000E+04, 4.5625706899E+01, 5.6267991531E+00, 2.8658031401E+01, 4.2637989451E+00, 9.7706222819E-01],
	[3.8845000000E+04, 4.5635987594E+01, 5.6268419478E+00, 2.8670171357E+01, 4.2641819330E+00, 9.7707358286E-01],
	[3.8850000000E+04, 4.5646269281E+01, 5.6268847374E+00, 2.8682314891E+01, 4.2645648063E+00, 9.7708493128E-01],
	[3.8855000000E+04, 4.5656551962E+01, 5.6269275218E+00, 2.8694462004E+01, 4.2649475649E+00, 9.7709627344E-01],
	[3.8860000000E+04, 4.5666835635E+01, 5.6269703010E+00, 2.8706612696E+01, 4.2653302088E+00, 9.7710760936E-01],
	[3.8865000000E+04, 4.5677120301E+01, 5.6270130750E+00, 2.8718766968E+01, 4.2657127382E+00, 9.7711893902E-01],
	[3.8870000000E+04, 4.5687405959E+01, 5.6270558439E+00, 2.8730924821E+01, 4.2660951531E+00, 9.7713026244E-01],
	[3.8875000000E+04, 4.5697692610E+01, 5.6270986076E+00, 2.8743086254E+01, 4.2664774534E+00, 9.7714157963E-01],
	[3.8880000000E+04, 4.5707980254E+01, 5.6271413661E+00, 2.8755251269E+01, 4.2668596392E+00, 9.7715289058E-01],
	[3.8885000000E+04, 4.5718268891E+01, 5.6271841194E+00, 2.8767419867E+01, 4.2672417107E+00, 9.7716419529E-01],
	[3.8890000000E+04, 4.5728558520E+01, 5.6272268676E+00, 2.8779592047E+01, 4.2676236677E+00, 9.7717549378E-01],
	[3.8895000000E+04, 4.5738849142E+01, 5.6272696106E+00, 2.8791767811E+01, 4.2680055103E+00, 9.7718678604E-01],
	[3.8900000000E+04, 4.5749140756E+01, 5.6273123484E+00, 2.8803947159E+01, 4.2683872387E+00, 9.7719807208E-01],
	[3.8905000000E+04, 4.5759433363E+01, 5.6273550811E+00, 2.8816130091E+01, 4.2687688527E+00, 9.7720935190E-01],
	[3.8910000000E+04, 4.5769726962E+01, 5.6273978085E+00, 2.8828316609E+01, 4.2691503525E+00, 9.7722062551E-01],
	[3.8915000000E+04, 4.5780021554E+01, 5.6274405309E+00, 2.8840506712E+01, 4.2695317381E+00, 9.7723189291E-01],
	[3.8920000000E+04, 4.5790317138E+01, 5.6274832480E+00, 2.8852700402E+01, 4.2699130095E+00, 9.7724315410E-01],
	[3.8925000000E+04, 4.5800613715E+01, 5.6275259600E+00, 2.8864897679E+01, 4.2702941667E+00, 9.7725440908E-01],
	[3.8930000000E+04, 4.5810911283E+01, 5.6275686668E+00, 2.8877098543E+01, 4.2706752099E+00, 9.7726565787E-01],
	[3.8935000000E+04, 4.5821209845E+01, 5.6276113685E+00, 2.8889302996E+01, 4.2710561390E+00, 9.7727690046E-01],
	[3.8940000000E+04, 4.5831509398E+01, 5.6276540650E+00, 2.8901511038E+01, 4.2714369540E+00, 9.7728813686E-01],
	[3.8945000000E+04, 4.5841809944E+01, 5.6276967564E+00, 2.8913722668E+01, 4.2718176551E+00, 9.7729936707E-01],
	[3.8950000000E+04, 4.5852111482E+01, 5.6277394426E+00, 2.8925937889E+01, 4.2721982422E+00, 9.7731059109E-01],
	[3.8955000000E+04, 4.5862414012E+01, 5.6277821236E+00, 2.8938156701E+01, 4.2725787154E+00, 9.7732180893E-01],
	[3.8960000000E+04, 4.5872717534E+01, 5.6278247995E+00, 2.8950379103E+01, 4.2729590747E+00, 9.7733302059E-01],
	[3.8965000000E+04, 4.5883022048E+01, 5.6278674702E+00, 2.8962605097E+01, 4.2733393202E+00, 9.7734422608E-01],
	[3.8970000000E+04, 4.5893327555E+01, 5.6279101358E+00, 2.8974834684E+01, 4.2737194518E+00, 9.7735542539E-01],
	[3.8975000000E+04, 4.5903634053E+01, 5.6279527962E+00, 2.8987067864E+01, 4.2740994697E+00, 9.7736661854E-01],
	[3.8980000000E+04, 4.5913941544E+01, 5.6279954515E+00, 2.8999304637E+01, 4.2744793738E+00, 9.7737780553E-01],
	[3.8985000000E+04, 4.5924250027E+01, 5.6280381017E+00, 2.9011545004E+01, 4.2748591642E+00, 9.7738898635E-01],
	[3.8990000000E+04, 4.5934559501E+01, 5.6280807466E+00, 2.9023788966E+01, 4.2752388410E+00, 9.7740016102E-01],
	[3.8995000000E+04, 4.5944869968E+01, 5.6281233865E+00, 2.9036036523E+01, 4.2756184042E+00, 9.7741132953E-01],
	[3.9000000000E+04, 4.5955181426E+01, 5.6281660212E+00, 2.9048287676E+01, 4.2759978537E+00, 9.7742249189E-01],
	[3.9005000000E+04, 4.5965493876E+01, 5.6282086507E+00, 2.9060542426E+01, 4.2763771897E+00, 9.7743364811E-01],
	[3.9010000000E+04, 4.5975807318E+01, 5.6282512752E+00, 2.9072800773E+01, 4.2767564122E+00, 9.7744479819E-01],
	[3.9015000000E+04, 4.5986121752E+01, 5.6282938944E+00, 2.9085062717E+01, 4.2771355212E+00, 9.7745594212E-01],
	[3.9020000000E+04, 4.5996437178E+01, 5.6283365086E+00, 2.9097328260E+01, 4.2775145168E+00, 9.7746707992E-01],
	[3.9025000000E+04, 4.6006753595E+01, 5.6283791176E+00, 2.9109597402E+01, 4.2778933990E+00, 9.7747821159E-01],
	[3.9030000000E+04, 4.6017071004E+01, 5.6284217214E+00, 2.9121870143E+01, 4.2782721678E+00, 9.7748933713E-01],
	[3.9035000000E+04, 4.6027389405E+01, 5.6284643201E+00, 2.9134146484E+01, 4.2786508232E+00, 9.7750045654E-01],
	[3.9040000000E+04, 4.6037708798E+01, 5.6285069137E+00, 2.9146426426E+01, 4.2790293654E+00, 9.7751156984E-01],
	[3.9045000000E+04, 4.6048029182E+01, 5.6285495022E+00, 2.9158709969E+01, 4.2794077943E+00, 9.7752267701E-01],
	[3.9050000000E+04, 4.6058350557E+01, 5.6285920855E+00, 2.9170997114E+01, 4.2797861100E+00, 9.7753377808E-01],
	[3.9055000000E+04, 4.6068672924E+01, 5.6286346637E+00, 2.9183287862E+01, 4.2801643125E+00, 9.7754487303E-01],
	[3.9060000000E+04, 4.6078996283E+01, 5.6286772368E+00, 2.9195582212E+01, 4.2805424018E+00, 9.7755596187E-01],
	[3.9065000000E+04, 4.6089320633E+01, 5.6287198047E+00, 2.9207880166E+01, 4.2809203780E+00, 9.7756704461E-01],
	[3.9070000000E+04, 4.6099645975E+01, 5.6287623675E+00, 2.9220181725E+01, 4.2812982412E+00, 9.7757812126E-01],
	[3.9075000000E+04, 4.6109972308E+01, 5.6288049252E+00, 2.9232486888E+01, 4.2816759913E+00, 9.7758919180E-01],
	[3.9080000000E+04, 4.6120299633E+01, 5.6288474778E+00, 2.9244795657E+01, 4.2820536284E+00, 9.7760025625E-01],
	[3.9085000000E+04, 4.6130627948E+01, 5.6288900253E+00, 2.9257108031E+01, 4.2824311526E+00, 9.7761131462E-01],
	[3.9090000000E+04, 4.6140957256E+01, 5.6289325676E+00, 2.9269424012E+01, 4.2828085638E+00, 9.7762236689E-01],
	[3.9095000000E+04, 4.6151287554E+01, 5.6289751048E+00, 2.9281743601E+01, 4.2831858621E+00, 9.7763341309E-01],
	[3.9100000000E+04, 4.6161618844E+01, 5.6290176369E+00, 2.9294066797E+01, 4.2835630476E+00, 9.7764445321E-01],
	[3.9105000000E+04, 4.6171951125E+01, 5.6290601638E+00, 2.9306393602E+01, 4.2839401203E+00, 9.7765548725E-01],
	[3.9110000000E+04, 4.6182284397E+01, 5.6291026857E+00, 2.9318724015E+01, 4.2843170801E+00, 9.7766651522E-01],
	[3.9115000000E+04, 4.6192618660E+01, 5.6291452024E+00, 2.9331058039E+01, 4.2846939273E+00, 9.7767753712E-01],
	[3.9120000000E+04, 4.6202953915E+01, 5.6291877140E+00, 2.9343395672E+01, 4.2850706617E+00, 9.7768855296E-01],
	[3.9125000000E+04, 4.6213290160E+01, 5.6292302206E+00, 2.9355736916E+01, 4.2854472834E+00, 9.7769956274E-01],
	[3.9130000000E+04, 4.6223627397E+01, 5.6292727220E+00, 2.9368081772E+01, 4.2858237925E+00, 9.7771056646E-01],
	[3.9135000000E+04, 4.6233965625E+01, 5.6293152183E+00, 2.9380430239E+01, 4.2862001890E+00, 9.7772156413E-01],
	[3.9140000000E+04, 4.6244304844E+01, 5.6293577094E+00, 2.9392782319E+01, 4.2865764730E+00, 9.7773255575E-01],
	[3.9145000000E+04, 4.6254645053E+01, 5.6294001955E+00, 2.9405138012E+01, 4.2869526444E+00, 9.7774354132E-01],
	[3.9150000000E+04, 4.6264986254E+01, 5.6294426765E+00, 2.9417497319E+01, 4.2873287033E+00, 9.7775452085E-01],
	[3.9155000000E+04, 4.6275328446E+01, 5.6294851524E+00, 2.9429860241E+01, 4.2877046498E+00, 9.7776549434E-01],
	[3.9160000000E+04, 4.6285671628E+01, 5.6295276231E+00, 2.9442226777E+01, 4.2880804838E+00, 9.7777646179E-01],
	[3.9165000000E+04, 4.6296015801E+01, 5.6295700888E+00, 2.9454596929E+01, 4.2884562055E+00, 9.7778742321E-01],
	[3.9170000000E+04, 4.6306360966E+01, 5.6296125493E+00, 2.9466970697E+01, 4.2888318148E+00, 9.7779837861E-01],
	[3.9175000000E+04, 4.6316707121E+01, 5.6296550048E+00, 2.9479348081E+01, 4.2892073119E+00, 9.7780932797E-01],
	[3.9180000000E+04, 4.6327054266E+01, 5.6296974552E+00, 2.9491729083E+01, 4.2895826966E+00, 9.7782027132E-01],
	[3.9185000000E+04, 4.6337402403E+01, 5.6297399004E+00, 2.9504113703E+01, 4.2899579691E+00, 9.7783120865E-01],
	[3.9190000000E+04, 4.6347751530E+01, 5.6297823406E+00, 2.9516501941E+01, 4.2903331294E+00, 9.7784213996E-01],
	[3.9195000000E+04, 4.6358101648E+01, 5.6298247757E+00, 2.9528893799E+01, 4.2907081776E+00, 9.7785306526E-01],
	[3.9200000000E+04, 4.6368452756E+01, 5.6298672056E+00, 2.9541289276E+01, 4.2910831136E+00, 9.7786398456E-01],
	[3.9205000000E+04, 4.6378804855E+01, 5.6299096305E+00, 2.9553688373E+01, 4.2914579376E+00, 9.7787489785E-01],
	[3.9210000000E+04, 4.6389157945E+01, 5.6299520503E+00, 2.9566091091E+01, 4.2918326495E+00, 9.7788580514E-01],
	[3.9215000000E+04, 4.6399512025E+01, 5.6299944650E+00, 2.9578497431E+01, 4.2922072493E+00, 9.7789670643E-01],
	[3.9220000000E+04, 4.6409867096E+01, 5.6300368747E+00, 2.9590907393E+01, 4.2925817372E+00, 9.7790760173E-01],
	[3.9225000000E+04, 4.6420223157E+01, 5.6300792792E+00, 2.9603320977E+01, 4.2929561132E+00, 9.7791849105E-01],
	[3.9230000000E+04, 4.6430580208E+01, 5.6301216787E+00, 2.9615738185E+01, 4.2933303772E+00, 9.7792937437E-01],
	[3.9235000000E+04, 4.6440938250E+01, 5.6301640730E+00, 2.9628159017E+01, 4.2937045294E+00, 9.7794025171E-01],
	[3.9240000000E+04, 4.6451312445E+01, 5.6302079103E+00, 2.9640583473E+01, 4.2940795416E+00, 9.7795112307E-01],
	[3.9245000000E+04, 4.6461695667E+01, 5.6302525093E+00, 2.9653011554E+01, 4.2944549569E+00, 9.7796198846E-01],
	[3.9250000000E+04, 4.6472079887E+01, 5.6302971030E+00, 2.9665443261E+01, 4.2948302608E+00, 9.7797284788E-01],
	[3.9255000000E+04, 4.6482465105E+01, 5.6303416914E+00, 2.9677878594E+01, 4.2952054531E+00, 9.7798370132E-01],
	[3.9260000000E+04, 4.6492851321E+01, 5.6303862744E+00, 2.9690317554E+01, 4.2955805340E+00, 9.7799454880E-01],
	[3.9265000000E+04, 4.6503238534E+01, 5.6304308521E+00, 2.9702760141E+01, 4.2959555034E+00, 9.7800539032E-01],
	[3.9270000000E+04, 4.6513626745E+01, 5.6304754245E+00, 2.9715206356E+01, 4.2963303615E+00, 9.7801622589E-01],
	[3.9275000000E+04, 4.6524015953E+01, 5.6305199916E+00, 2.9727656200E+01, 4.2967051082E+00, 9.7802705549E-01],
	[3.9280000000E+04, 4.6534406159E+01, 5.6305645534E+00, 2.9740109673E+01, 4.2970797435E+00, 9.7803787915E-01],
	[3.9285000000E+04, 4.6544797362E+01, 5.6306091098E+00, 2.9752566776E+01, 4.2974542676E+00, 9.7804869686E-01],
	[3.9290000000E+04, 4.6555189563E+01, 5.6306536609E+00, 2.9765027510E+01, 4.2978286804E+00, 9.7805950862E-01],
	[3.9295000000E+04, 4.6565582762E+01, 5.6306982067E+00, 2.9777491874E+01, 4.2982029820E+00, 9.7807031445E-01],
	[3.9300000000E+04, 4.6575976957E+01, 5.6307427472E+00, 2.9789959870E+01, 4.2985771724E+00, 9.7808111434E-01],
	[3.9305000000E+04, 4.6586372150E+01, 5.6307872823E+00, 2.9802431498E+01, 4.2989512517E+00, 9.7809190829E-01],
	[3.9310000000E+04, 4.6596768341E+01, 5.6308318122E+00, 2.9814906759E+01, 4.2993252199E+00, 9.7810269632E-01],
	[3.9315000000E+04, 4.6607165529E+01, 5.6308763367E+00, 2.9827385653E+01, 4.2996990770E+00, 9.7811347842E-01],
	[3.9320000000E+04, 4.6617563714E+01, 5.6309208560E+00, 2.9839868182E+01, 4.3000728231E+00, 9.7812425459E-01],
	[3.9325000000E+04, 4.6627962896E+01, 5.6309653699E+00, 2.9852354345E+01, 4.3004464582E+00, 9.7813502485E-01],
	[3.9330000000E+04, 4.6638363075E+01, 5.6310098785E+00, 2.9864844143E+01, 4.3008199823E+00, 9.7814578919E-01],
	[3.9335000000E+04, 4.6648764252E+01, 5.6310543818E+00, 2.9877337576E+01, 4.3011933955E+00, 9.7815654762E-01],
	[3.9340000000E+04, 4.6659166426E+01, 5.6310988798E+00, 2.9889834647E+01, 4.3015666978E+00, 9.7816730014E-01],
	[3.9345000000E+04, 4.6669569597E+01, 5.6311433725E+00, 2.9902335354E+01, 4.3019398892E+00, 9.7817804675E-01],
	[3.9350000000E+04, 4.6679973765E+01, 5.6311878599E+00, 2.9914839698E+01, 4.3023129698E+00, 9.7818878747E-01],
	[3.9355000000E+04, 4.6690378930E+01, 5.6312323420E+00, 2.9927347681E+01, 4.3026859397E+00, 9.7819952228E-01],
	[3.9360000000E+04, 4.6700785092E+01, 5.6312768188E+00, 2.9939859303E+01, 4.3030587988E+00, 9.7821025120E-01],
	[3.9365000000E+04, 4.6711192252E+01, 5.6313212903E+00, 2.9952374564E+01, 4.3034315471E+00, 9.7822097423E-01],
	[3.9370000000E+04, 4.6721600408E+01, 5.6313657565E+00, 2.9964893464E+01, 4.3038041849E+00, 9.7823169137E-01],
	[3.9375000000E+04, 4.6732009561E+01, 5.6314102174E+00, 2.9977416006E+01, 4.3041767119E+00, 9.7824240263E-01],
	[3.9380000000E+04, 4.6742419711E+01, 5.6314546731E+00, 2.9989942188E+01, 4.3045491284E+00, 9.7825310800E-01],
	[3.9385000000E+04, 4.6752830858E+01, 5.6314991234E+00, 3.0002472013E+01, 4.3049214343E+00, 9.7826380750E-01],
	[3.9390000000E+04, 4.6763243001E+01, 5.6315435684E+00, 3.0015005479E+01, 4.3052936297E+00, 9.7827450113E-01],
	[3.9395000000E+04, 4.6773656142E+01, 5.6315880081E+00, 3.0027542589E+01, 4.3056657146E+00, 9.7828518889E-01],
	[3.9400000000E+04, 4.6784070279E+01, 5.6316324426E+00, 3.0040083341E+01, 4.3060376890E+00, 9.7829587077E-01],
	[3.9405000000E+04, 4.6794485413E+01, 5.6316768717E+00, 3.0052627739E+01, 4.3064095530E+00, 9.7830654680E-01],
	[3.9410000000E+04, 4.6804901544E+01, 5.6317212956E+00, 3.0065175780E+01, 4.3067813066E+00, 9.7831721697E-01],
	[3.9415000000E+04, 4.6815318672E+01, 5.6317657142E+00, 3.0077727467E+01, 4.3071529499E+00, 9.7832788128E-01],
	[3.9420000000E+04, 4.6825736796E+01, 5.6318101275E+00, 3.0090282800E+01, 4.3075244828E+00, 9.7833853973E-01],
	[3.9425000000E+04, 4.6836155917E+01, 5.6318545355E+00, 3.0102841780E+01, 4.3078959055E+00, 9.7834919234E-01],
	[3.9430000000E+04, 4.6846576034E+01, 5.6318989383E+00, 3.0115404406E+01, 4.3082672179E+00, 9.7835983910E-01],
	[3.9435000000E+04, 4.6856997148E+01, 5.6319433357E+00, 3.0127970681E+01, 4.3086384201E+00, 9.7837048002E-01],
	[3.9440000000E+04, 4.6867419259E+01, 5.6319877279E+00, 3.0140540603E+01, 4.3090095122E+00, 9.7838111511E-01],
	[3.9445000000E+04, 4.6877842366E+01, 5.6320321148E+00, 3.0153114174E+01, 4.3093804941E+00, 9.7839174435E-01],
	[3.9450000000E+04, 4.6888266469E+01, 5.6320764964E+00, 3.0165691395E+01, 4.3097513659E+00, 9.7840236777E-01],
	[3.9455000000E+04, 4.6898691569E+01, 5.6321208728E+00, 3.0178272266E+01, 4.3101221277E+00, 9.7841298535E-01],
	[3.9460000000E+04, 4.6909117666E+01, 5.6321652439E+00, 3.0190856788E+01, 4.3104927794E+00, 9.7842359712E-01],
	[3.9465000000E+04, 4.6919544758E+01, 5.6322096097E+00, 3.0203444960E+01, 4.3108633211E+00, 9.7843420306E-01],
	[3.9470000000E+04, 4.6929972847E+01, 5.6322539702E+00, 3.0216036785E+01, 4.3112337529E+00, 9.7844480318E-01],
	[3.9475000000E+04, 4.6940401933E+01, 5.6322983255E+00, 3.0228632262E+01, 4.3116040748E+00, 9.7845539749E-01],
	[3.9480000000E+04, 4.6950832015E+01, 5.6323426755E+00, 3.0241231392E+01, 4.3119742868E+00, 9.7846598598E-01],
	[3.9485000000E+04, 4.6961263093E+01, 5.6323870202E+00, 3.0253834176E+01, 4.3123443889E+00, 9.7847656867E-01],
	[3.9490000000E+04, 4.6971695167E+01, 5.6324313597E+00, 3.0266440614E+01, 4.3127143812E+00, 9.7848714556E-01],
	[3.9495000000E+04, 4.6982128237E+01, 5.6324756939E+00, 3.0279050707E+01, 4.3130842638E+00, 9.7849771665E-01],
	[3.9500000000E+04, 4.6992562304E+01, 5.6325200228E+00, 3.0291664455E+01, 4.3134540366E+00, 9.7850828194E-01],
	[3.9505000000E+04, 4.7002997366E+01, 5.6325643465E+00, 3.0304281860E+01, 4.3138236997E+00, 9.7851884143E-01],
	[3.9510000000E+04, 4.7013433425E+01, 5.6326086649E+00, 3.0316902921E+01, 4.3141932531E+00, 9.7852939514E-01],
	[3.9515000000E+04, 4.7023870480E+01, 5.6326529780E+00, 3.0329527639E+01, 4.3145626969E+00, 9.7853994306E-01],
	[3.9520000000E+04, 4.7034308531E+01, 5.6326972859E+00, 3.0342156015E+01, 4.3149320311E+00, 9.7855048519E-01],
	[3.9525000000E+04, 4.7044747578E+01, 5.6327415886E+00, 3.0354788049E+01, 4.3153012558E+00, 9.7856102155E-01],
	[3.9530000000E+04, 4.7055187621E+01, 5.6327858859E+00, 3.0367423743E+01, 4.3156703709E+00, 9.7857155213E-01],
	[3.9535000000E+04, 4.7065628660E+01, 5.6328301781E+00, 3.0380063096E+01, 4.3160393765E+00, 9.7858207694E-01],
	[3.9540000000E+04, 4.7076070694E+01, 5.6328744649E+00, 3.0392706109E+01, 4.3164082727E+00, 9.7859259597E-01],
	[3.9545000000E+04, 4.7086513725E+01, 5.6329187466E+00, 3.0405352783E+01, 4.3167770594E+00, 9.7860310925E-01],
	[3.9550000000E+04, 4.7096957751E+01, 5.6329630229E+00, 3.0418003118E+01, 4.3171457368E+00, 9.7861361676E-01],
	[3.9555000000E+04, 4.7107402774E+01, 5.6330072941E+00, 3.0430657115E+01, 4.3175143048E+00, 9.7862411851E-01],
	[3.9560000000E+04, 4.7117848792E+01, 5.6330515599E+00, 3.0443314775E+01, 4.3178827636E+00, 9.7863461451E-01],
	[3.9565000000E+04, 4.7128295806E+01, 5.6330958206E+00, 3.0455976099E+01, 4.3182511130E+00, 9.7864510475E-01],
	[3.9570000000E+04, 4.7138743815E+01, 5.6331400759E+00, 3.0468641086E+01, 4.3186193532E+00, 9.7865558925E-01],
	[3.9575000000E+04, 4.7149192821E+01, 5.6331843261E+00, 3.0481309737E+01, 4.3189874842E+00, 9.7866606800E-01],
	[3.9580000000E+04, 4.7159642822E+01, 5.6332285710E+00, 3.0493982053E+01, 4.3193555060E+00, 9.7867654101E-01],
	[3.9585000000E+04, 4.7170093818E+01, 5.6332728106E+00, 3.0506658035E+01, 4.3197234187E+00, 9.7868700828E-01],
	[3.9590000000E+04, 4.7180545811E+01, 5.6333170450E+00, 3.0519337683E+01, 4.3200912223E+00, 9.7869746982E-01],
	[3.9595000000E+04, 4.7190998798E+01, 5.6333612742E+00, 3.0532020998E+01, 4.3204589169E+00, 9.7870792563E-01],
	[3.9600000000E+04, 4.7201452782E+01, 5.6334054981E+00, 3.0544707980E+01, 4.3208265024E+00, 9.7871837570E-01],
	[3.9605000000E+04, 4.7211907761E+01, 5.6334497169E+00, 3.0557398630E+01, 4.3211939789E+00, 9.7872882006E-01],
	[3.9610000000E+04, 4.7222363735E+01, 5.6334939303E+00, 3.0570092949E+01, 4.3215613465E+00, 9.7873925869E-01],
	[3.9615000000E+04, 4.7232820705E+01, 5.6335381385E+00, 3.0582790936E+01, 4.3219286052E+00, 9.7874969161E-01],
	[3.9620000000E+04, 4.7243278670E+01, 5.6335823415E+00, 3.0595492594E+01, 4.3222957549E+00, 9.7876011881E-01],
	[3.9625000000E+04, 4.7253737631E+01, 5.6336265393E+00, 3.0608197922E+01, 4.3226627959E+00, 9.7877054030E-01],
	[3.9630000000E+04, 4.7264197587E+01, 5.6336707319E+00, 3.0620906921E+01, 4.3230297280E+00, 9.7878095609E-01],
	[3.9635000000E+04, 4.7274658538E+01, 5.6337149192E+00, 3.0633619591E+01, 4.3233965513E+00, 9.7879136617E-01],
	[3.9640000000E+04, 4.7285120485E+01, 5.6337591012E+00, 3.0646335934E+01, 4.3237632659E+00, 9.7880177055E-01],
	[3.9645000000E+04, 4.7295583426E+01, 5.6338032781E+00, 3.0659055949E+01, 4.3241298718E+00, 9.7881216924E-01],
	[3.9650000000E+04, 4.7306047364E+01, 5.6338474497E+00, 3.0671779637E+01, 4.3244963691E+00, 9.7882256223E-01],
	[3.9655000000E+04, 4.7316512296E+01, 5.6338916161E+00, 3.0684507000E+01, 4.3248627577E+00, 9.7883294953E-01],
	[3.9660000000E+04, 4.7326978223E+01, 5.6339357773E+00, 3.0697238037E+01, 4.3252290377E+00, 9.7884333115E-01],
	[3.9665000000E+04, 4.7337445146E+01, 5.6339799333E+00, 3.0709972749E+01, 4.3255952091E+00, 9.7885370708E-01],
	[3.9670000000E+04, 4.7347913064E+01, 5.6340240840E+00, 3.0722711137E+01, 4.3259612720E+00, 9.7886407733E-01],
	[3.9675000000E+04, 4.7358381977E+01, 5.6340682296E+00, 3.0735453201E+01, 4.3263272264E+00, 9.7887444191E-01],
	[3.9680000000E+04, 4.7368851885E+01, 5.6341123699E+00, 3.0748198942E+01, 4.3266930724E+00, 9.7888480082E-01],
	[3.9685000000E+04, 4.7379322787E+01, 5.6341565050E+00, 3.0760948360E+01, 4.3270588099E+00, 9.7889515405E-01],
	[3.9690000000E+04, 4.7389794685E+01, 5.6342006348E+00, 3.0773701457E+01, 4.3274244391E+00, 9.7890550162E-01],
	[3.9695000000E+04, 4.7400267578E+01, 5.6342447595E+00, 3.0786458232E+01, 4.3277899599E+00, 9.7891584353E-01],
	[3.9700000000E+04, 4.7410741466E+01, 5.6342888790E+00, 3.0799218687E+01, 4.3281553724E+00, 9.7892617978E-01],
	[3.9705000000E+04, 4.7421216349E+01, 5.6343329932E+00, 3.0811982822E+01, 4.3285206766E+00, 9.7893651037E-01],
	[3.9710000000E+04, 4.7431692226E+01, 5.6343771022E+00, 3.0824750637E+01, 4.3288858726E+00, 9.7894683532E-01],
	[3.9715000000E+04, 4.7442169099E+01, 5.6344212061E+00, 3.0837522133E+01, 4.3292509604E+00, 9.7895715461E-01],
	[3.9720000000E+04, 4.7452646966E+01, 5.6344653047E+00, 3.0850297311E+01, 4.3296159400E+00, 9.7896746826E-01],
	[3.9725000000E+04, 4.7463125828E+01, 5.6345093981E+00, 3.0863076171E+01, 4.3299808115E+00, 9.7897777626E-01],
	[3.9730000000E+04, 4.7473605685E+01, 5.6345534863E+00, 3.0875858714E+01, 4.3303455748E+00, 9.7898807863E-01],
	[3.9735000000E+04, 4.7484086536E+01, 5.6345975693E+00, 3.0888644940E+01, 4.3307102302E+00, 9.7899837536E-01],
	[3.9740000000E+04, 4.7494568382E+01, 5.6346416471E+00, 3.0901434851E+01, 4.3310747774E+00, 9.7900866646E-01],
	[3.9745000000E+04, 4.7505051223E+01, 5.6346857197E+00, 3.0914228446E+01, 4.3314392167E+00, 9.7901895194E-01],
	[3.9750000000E+04, 4.7515535058E+01, 5.6347297871E+00, 3.0927025726E+01, 4.3318035480E+00, 9.7902923179E-01],
	[3.9755000000E+04, 4.7526019888E+01, 5.6347738493E+00, 3.0939826693E+01, 4.3321677714E+00, 9.7903950601E-01],
	[3.9760000000E+04, 4.7536505713E+01, 5.6348179063E+00, 3.0952631346E+01, 4.3325318870E+00, 9.7904977462E-01],
	[3.9765000000E+04, 4.7546992532E+01, 5.6348619581E+00, 3.0965439685E+01, 4.3328958946E+00, 9.7906003762E-01],
	[3.9770000000E+04, 4.7557480346E+01, 5.6349060047E+00, 3.0978251713E+01, 4.3332597945E+00, 9.7907029500E-01],
	[3.9775000000E+04, 4.7567969154E+01, 5.6349500462E+00, 3.0991067429E+01, 4.3336235865E+00, 9.7908054678E-01],
	[3.9780000000E+04, 4.7578458956E+01, 5.6349940824E+00, 3.1003886833E+01, 4.3339872709E+00, 9.7909079295E-01],
	[3.9785000000E+04, 4.7588949753E+01, 5.6350381134E+00, 3.1016709927E+01, 4.3343508475E+00, 9.7910103352E-01],
	[3.9790000000E+04, 4.7599441544E+01, 5.6350821393E+00, 3.1029536712E+01, 4.3347143164E+00, 9.7911126850E-01],
	[3.9795000000E+04, 4.7609934330E+01, 5.6351261599E+00, 3.1042367186E+01, 4.3350776777E+00, 9.7912149788E-01],
	[3.9800000000E+04, 4.7620428110E+01, 5.6351701754E+00, 3.1055201352E+01, 4.3354409314E+00, 9.7913172167E-01],
	[3.9805000000E+04, 4.7630922884E+01, 5.6352141857E+00, 3.1068039210E+01, 4.3358040775E+00, 9.7914193987E-01],
	[3.9810000000E+04, 4.7641418652E+01, 5.6352581908E+00, 3.1080880761E+01, 4.3361671161E+00, 9.7915215249E-01],
	[3.9815000000E+04, 4.7651915415E+01, 5.6353021907E+00, 3.1093726004E+01, 4.3365300472E+00, 9.7916235953E-01],
	[3.9820000000E+04, 4.7662413172E+01, 5.6353461855E+00, 3.1106574941E+01, 4.3368928709E+00, 9.7917256099E-01],
	[3.9825000000E+04, 4.7672911923E+01, 5.6353901750E+00, 3.1119427572E+01, 4.3372555871E+00, 9.7918275688E-01],
	[3.9830000000E+04, 4.7683411668E+01, 5.6354341594E+00, 3.1132283898E+01, 4.3376181959E+00, 9.7919294719E-01],
	[3.9835000000E+04, 4.7693912407E+01, 5.6354781386E+00, 3.1145143920E+01, 4.3379806973E+00, 9.7920313194E-01],
	[3.9840000000E+04, 4.7704414141E+01, 5.6355221127E+00, 3.1158007637E+01, 4.3383430915E+00, 9.7921331113E-01],
	[3.9845000000E+04, 4.7714916868E+01, 5.6355660815E+00, 3.1170875051E+01, 4.3387053783E+00, 9.7922348476E-01],
	[3.9850000000E+04, 4.7725420589E+01, 5.6356100452E+00, 3.1183746163E+01, 4.3390675579E+00, 9.7923365283E-01],
	[3.9855000000E+04, 4.7735925305E+01, 5.6356540037E+00, 3.1196620972E+01, 4.3394296303E+00, 9.7924381535E-01],
	[3.9860000000E+04, 4.7746431014E+01, 5.6356979570E+00, 3.1209499479E+01, 4.3397915955E+00, 9.7925397231E-01],
	[3.9865000000E+04, 4.7756937717E+01, 5.6357419052E+00, 3.1222381686E+01, 4.3401534536E+00, 9.7926412373E-01],
	[3.9870000000E+04, 4.7767452836E+01, 5.6357865469E+00, 3.1235267592E+01, 4.3405156803E+00, 9.7927426961E-01],
	[3.9875000000E+04, 4.7777984573E+01, 5.6358326537E+00, 3.1248157198E+01, 4.3408788012E+00, 9.7928440995E-01],
	[3.9880000000E+04, 4.7788517311E+01, 5.6358787550E+00, 3.1261050506E+01, 4.3412418152E+00, 9.7929454475E-01],
	[3.9885000000E+04, 4.7799051050E+01, 5.6359248510E+00, 3.1273947514E+01, 4.3416047225E+00, 9.7930467402E-01],
	[3.9890000000E+04, 4.7809585790E+01, 5.6359709415E+00, 3.1286848225E+01, 4.3419675229E+00, 9.7931479776E-01],
	[3.9895000000E+04, 4.7820121531E+01, 5.6360170267E+00, 3.1299752638E+01, 4.3423302167E+00, 9.7932491597E-01],
	[3.9900000000E+04, 4.7830658273E+01, 5.6360631064E+00, 3.1312660755E+01, 4.3426928038E+00, 9.7933502866E-01],
	[3.9905000000E+04, 4.7841196016E+01, 5.6361091808E+00, 3.1325572575E+01, 4.3430552842E+00, 9.7934513583E-01],
	[3.9910000000E+04, 4.7851734759E+01, 5.6361552497E+00, 3.1338488099E+01, 4.3434176579E+00, 9.7935523749E-01],
	[3.9915000000E+04, 4.7862274504E+01, 5.6362013133E+00, 3.1351407329E+01, 4.3437799251E+00, 9.7936533363E-01],
	[3.9920000000E+04, 4.7872815249E+01, 5.6362473715E+00, 3.1364330264E+01, 4.3441420858E+00, 9.7937542426E-01],
	[3.9925000000E+04, 4.7883356996E+01, 5.6362934243E+00, 3.1377256906E+01, 4.3445041399E+00, 9.7938550939E-01],
	[3.9930000000E+04, 4.7893899743E+01, 5.6363394717E+00, 3.1390187254E+01, 4.3448660875E+00, 9.7939558901E-01],
	[3.9935000000E+04, 4.7904443490E+01, 5.6363855137E+00, 3.1403121309E+01, 4.3452279287E+00, 9.7940566314E-01],
	[3.9940000000E+04, 4.7914988239E+01, 5.6364315503E+00, 3.1416059073E+01, 4.3455896634E+00, 9.7941573177E-01],
	[3.9945000000E+04, 4.7925533988E+01, 5.6364775815E+00, 3.1429000545E+01, 4.3459512918E+00, 9.7942579491E-01],
	[3.9950000000E+04, 4.7936080738E+01, 5.6365236073E+00, 3.1441945726E+01, 4.3463128138E+00, 9.7943585255E-01],
	[3.9955000000E+04, 4.7946628488E+01, 5.6365696278E+00, 3.1454894617E+01, 4.3466742296E+00, 9.7944590471E-01],
	[3.9960000000E+04, 4.7957177239E+01, 5.6366156428E+00, 3.1467847219E+01, 4.3470355390E+00, 9.7945595139E-01],
	[3.9965000000E+04, 4.7967726991E+01, 5.6366616525E+00, 3.1480803531E+01, 4.3473967422E+00, 9.7946599259E-01],
	[3.9970000000E+04, 4.7978277743E+01, 5.6367076568E+00, 3.1493763555E+01, 4.3477578392E+00, 9.7947602832E-01],
	[3.9975000000E+04, 4.7988829496E+01, 5.6367536558E+00, 3.1506727291E+01, 4.3481188301E+00, 9.7948605857E-01],
	[3.9980000000E+04, 4.7999382249E+01, 5.6367996493E+00, 3.1519694740E+01, 4.3484797148E+00, 9.7949608335E-01],
	[3.9985000000E+04, 4.8009936003E+01, 5.6368456375E+00, 3.1532665903E+01, 4.3488404934E+00, 9.7950610267E-01],
	[3.9990000000E+04, 4.8020490757E+01, 5.6368916203E+00, 3.1545640779E+01, 4.3492011659E+00, 9.7951611652E-01],
	[3.9995000000E+04, 4.8031046511E+01, 5.6369375977E+00, 3.1558619370E+01, 4.3495617324E+00, 9.7952612492E-01],
	[4.0000000000E+04, 4.8041603266E+01, 5.6369835698E+00, 3.1571601676E+01, 4.3499221929E+00, 9.7953612786E-01],
	[4.0005000000E+04, 4.8052161021E+01, 5.6370295365E+00, 3.1584618670E+01, 4.3502831350E+00, 9.7954612535E-01],
	[4.0010000000E+04, 4.8062719776E+01, 5.6370754978E+00, 3.1597639402E+01, 4.3506439709E+00, 9.7955611739E-01],
	[4.0015000000E+04, 4.8073279532E+01, 5.6371214537E+00, 3.1610663873E+01, 4.3510047004E+00, 9.7956610398E-01],
	[4.0020000000E+04, 4.8083840288E+01, 5.6371674043E+00, 3.1623692083E+01, 4.3513653238E+00, 9.7957608513E-01],
	[4.0025000000E+04, 4.8094402044E+01, 5.6372133495E+00, 3.1636724034E+01, 4.3517258410E+00, 9.7958606085E-01],
	[4.0030000000E+04, 4.8104964800E+01, 5.6372592894E+00, 3.1649759725E+01, 4.3520862520E+00, 9.7959603112E-01],
	[4.0035000000E+04, 4.8115528556E+01, 5.6373052238E+00, 3.1662799157E+01, 4.3524465569E+00, 9.7960599597E-01],
	[4.0040000000E+04, 4.8126093313E+01, 5.6373511530E+00, 3.1675842331E+01, 4.3528067558E+00, 9.7961595538E-01],
	[4.0045000000E+04, 4.8136659069E+01, 5.6373970767E+00, 3.1688889247E+01, 4.3531668486E+00, 9.7962590937E-01],
	[4.0050000000E+04, 4.8147225826E+01, 5.6374429951E+00, 3.1701939907E+01, 4.3535268354E+00, 9.7963585794E-01],
	[4.0055000000E+04, 4.8157793583E+01, 5.6374889082E+00, 3.1714994310E+01, 4.3538867163E+00, 9.7964580109E-01],
	[4.0060000000E+04, 4.8168362339E+01, 5.6375348158E+00, 3.1728052457E+01, 4.3542464912E+00, 9.7965573882E-01],
	[4.0065000000E+04, 4.8178932096E+01, 5.6375807182E+00, 3.1741114349E+01, 4.3546061602E+00, 9.7966567114E-01],
	[4.0070000000E+04, 4.8189502852E+01, 5.6376266152E+00, 3.1754179986E+01, 4.3549657233E+00, 9.7967559806E-01],
	[4.0075000000E+04, 4.8200074609E+01, 5.6376725068E+00, 3.1767249370E+01, 4.3553251806E+00, 9.7968551956E-01],
	[4.0080000000E+04, 4.8210647365E+01, 5.6377183930E+00, 3.1780322500E+01, 4.3556845321E+00, 9.7969543567E-01],
	[4.0085000000E+04, 4.8221221121E+01, 5.6377642740E+00, 3.1793399378E+01, 4.3560437779E+00, 9.7970534637E-01],
	[4.0090000000E+04, 4.8231795877E+01, 5.6378101495E+00, 3.1806480003E+01, 4.3564029179E+00, 9.7971525168E-01],
	[4.0095000000E+04, 4.8242371633E+01, 5.6378560198E+00, 3.1819564377E+01, 4.3567619522E+00, 9.7972515160E-01],
	[4.0100000000E+04, 4.8252948389E+01, 5.6379018846E+00, 3.1832652500E+01, 4.3571208809E+00, 9.7973504613E-01],
	[4.0105000000E+04, 4.8263526144E+01, 5.6379477442E+00, 3.1845744372E+01, 4.3574797040E+00, 9.7974493527E-01],
	[4.0110000000E+04, 4.8274104899E+01, 5.6379935983E+00, 3.1858839995E+01, 4.3578384215E+00, 9.7975481904E-01],
	[4.0115000000E+04, 4.8284684653E+01, 5.6380394472E+00, 3.1871939369E+01, 4.3581970334E+00, 9.7976469742E-01],
	[4.0120000000E+04, 4.8295265407E+01, 5.6380852907E+00, 3.1885042494E+01, 4.3585555398E+00, 9.7977457042E-01],
	[4.0125000000E+04, 4.8305847161E+01, 5.6381311288E+00, 3.1898149372E+01, 4.3589139407E+00, 9.7978443806E-01],
	[4.0130000000E+04, 4.8316429915E+01, 5.6381769617E+00, 3.1911260002E+01, 4.3592722362E+00, 9.7979430032E-01],
	[4.0135000000E+04, 4.8327013668E+01, 5.6382227891E+00, 3.1924374385E+01, 4.3596304262E+00, 9.7980415722E-01],
	[4.0140000000E+04, 4.8337598420E+01, 5.6382686113E+00, 3.1937492523E+01, 4.3599885109E+00, 9.7981400876E-01],
	[4.0145000000E+04, 4.8348184172E+01, 5.6383144281E+00, 3.1950614415E+01, 4.3603464903E+00, 9.7982385493E-01],
	[4.0150000000E+04, 4.8358770923E+01, 5.6383602396E+00, 3.1963740062E+01, 4.3607043643E+00, 9.7983369576E-01],
	[4.0155000000E+04, 4.8369358674E+01, 5.6384060457E+00, 3.1976869465E+01, 4.3610621331E+00, 9.7984353122E-01],
	[4.0160000000E+04, 4.8379947424E+01, 5.6384518465E+00, 3.1990002624E+01, 4.3614197966E+00, 9.7985336134E-01],
	[4.0165000000E+04, 4.8390537174E+01, 5.6384976420E+00, 3.2003139540E+01, 4.3617773549E+00, 9.7986318612E-01],
	[4.0170000000E+04, 4.8401127922E+01, 5.6385434322E+00, 3.2016280214E+01, 4.3621348081E+00, 9.7987300555E-01],
	[4.0175000000E+04, 4.8411719671E+01, 5.6385892170E+00, 3.2029424646E+01, 4.3624921561E+00, 9.7988281964E-01],
	[4.0180000000E+04, 4.8422312418E+01, 5.6386349965E+00, 3.2042572836E+01, 4.3628493990E+00, 9.7989262840E-01],
	[4.0185000000E+04, 4.8432906165E+01, 5.6386807707E+00, 3.2055724786E+01, 4.3632065369E+00, 9.7990243182E-01],
	[4.0190000000E+04, 4.8443500910E+01, 5.6387265396E+00, 3.2068880496E+01, 4.3635635697E+00, 9.7991222991E-01],
	[4.0195000000E+04, 4.8454096656E+01, 5.6387723031E+00, 3.2082039967E+01, 4.3639204976E+00, 9.7992202268E-01],
	[4.0200000000E+04, 4.8464693400E+01, 5.6388180613E+00, 3.2095203199E+01, 4.3642773204E+00, 9.7993181012E-01],
	[4.0205000000E+04, 4.8475291143E+01, 5.6388638142E+00, 3.2108370192E+01, 4.3646340384E+00, 9.7994159225E-01],
	[4.0210000000E+04, 4.8485889885E+01, 5.6389095618E+00, 3.2121540949E+01, 4.3649906515E+00, 9.7995136906E-01],
	[4.0215000000E+04, 4.8496489627E+01, 5.6389553040E+00, 3.2134715468E+01, 4.3653471597E+00, 9.7996114055E-01],
	[4.0220000000E+04, 4.8507090367E+01, 5.6390010410E+00, 3.2147893750E+01, 4.3657035630E+00, 9.7997090674E-01],
	[4.0225000000E+04, 4.8517692107E+01, 5.6390467726E+00, 3.2161075797E+01, 4.3660598616E+00, 9.7998066762E-01],
	[4.0230000000E+04, 4.8528294845E+01, 5.6390924989E+00, 3.2174261609E+01, 4.3664160555E+00, 9.7999042319E-01],
	[4.0235000000E+04, 4.8538898583E+01, 5.6391382199E+00, 3.2187451187E+01, 4.3667721446E+00, 9.8000017347E-01],
	[4.0240000000E+04, 4.8549503319E+01, 5.6391839356E+00, 3.2200644530E+01, 4.3671281291E+00, 9.8000991845E-01],
	[4.0245000000E+04, 4.8560109054E+01, 5.6392296460E+00, 3.2213841640E+01, 4.3674840089E+00, 9.8001965814E-01],
	[4.0250000000E+04, 4.8570715788E+01, 5.6392753510E+00, 3.2227042517E+01, 4.3678397841E+00, 9.8002939253E-01],
	[4.0255000000E+04, 4.8581323521E+01, 5.6393210508E+00, 3.2240247162E+01, 4.3681954547E+00, 9.8003912164E-01],
	[4.0260000000E+04, 4.8591932252E+01, 5.6393667453E+00, 3.2253455576E+01, 4.3685510207E+00, 9.8004884547E-01],
	[4.0265000000E+04, 4.8602541983E+01, 5.6394124344E+00, 3.2266667759E+01, 4.3689064823E+00, 9.8005856401E-01],
	[4.0270000000E+04, 4.8613152712E+01, 5.6394581183E+00, 3.2279883711E+01, 4.3692618394E+00, 9.8006827728E-01],
	[4.0275000000E+04, 4.8623764440E+01, 5.6395037968E+00, 3.2293103434E+01, 4.3696170920E+00, 9.8007798528E-01],
	[4.0280000000E+04, 4.8634377166E+01, 5.6395494701E+00, 3.2306326928E+01, 4.3699722403E+00, 9.8008768800E-01],
	[4.0285000000E+04, 4.8644990891E+01, 5.6395951380E+00, 3.2319554193E+01, 4.3703272841E+00, 9.8009738546E-01],
	[4.0290000000E+04, 4.8655605615E+01, 5.6396408007E+00, 3.2332785230E+01, 4.3706822237E+00, 9.8010707765E-01],
	[4.0295000000E+04, 4.8666221337E+01, 5.6396864580E+00, 3.2346020040E+01, 4.3710370589E+00, 9.8011676459E-01],
	[4.0300000000E+04, 4.8676838058E+01, 5.6397321101E+00, 3.2359258624E+01, 4.3713917899E+00, 9.8012644626E-01],
	[4.0305000000E+04, 4.8687455777E+01, 5.6397777568E+00, 3.2372500981E+01, 4.3717464166E+00, 9.8013612268E-01],
	[4.0310000000E+04, 4.8698074495E+01, 5.6398233983E+00, 3.2385747113E+01, 4.3721009391E+00, 9.8014579385E-01],
	[4.0315000000E+04, 4.8708694212E+01, 5.6398690345E+00, 3.2398997020E+01, 4.3724553575E+00, 9.8015545978E-01],
	[4.0320000000E+04, 4.8719314926E+01, 5.6399146654E+00, 3.2412250703E+01, 4.3728096717E+00, 9.8016512046E-01],
	[4.0325000000E+04, 4.8729936639E+01, 5.6399602910E+00, 3.2425508162E+01, 4.3731638819E+00, 9.8017477589E-01],
	[4.0330000000E+04, 4.8740559351E+01, 5.6400059113E+00, 3.2438769399E+01, 4.3735179880E+00, 9.8018442609E-01],
	[4.0335000000E+04, 4.8751183061E+01, 5.6400515263E+00, 3.2452034412E+01, 4.3738719900E+00, 9.8019407106E-01],
	[4.0340000000E+04, 4.8761807769E+01, 5.6400971361E+00, 3.2465303204E+01, 4.3742258881E+00, 9.8020371079E-01],
	[4.0345000000E+04, 4.8772433475E+01, 5.6401427405E+00, 3.2478575775E+01, 4.3745796822E+00, 9.8021334530E-01],
	[4.0350000000E+04, 4.8783060180E+01, 5.6401883397E+00, 3.2491852126E+01, 4.3749333724E+00, 9.8022297458E-01],
	[4.0355000000E+04, 4.8793687883E+01, 5.6402339336E+00, 3.2505132256E+01, 4.3752869587E+00, 9.8023259864E-01],
	[4.0360000000E+04, 4.8804316584E+01, 5.6402795222E+00, 3.2518416167E+01, 4.3756404412E+00, 9.8024221748E-01],
	[4.0365000000E+04, 4.8814946283E+01, 5.6403251055E+00, 3.2531703859E+01, 4.3759938198E+00, 9.8025183110E-01],
	[4.0370000000E+04, 4.8825576980E+01, 5.6403706836E+00, 3.2544995333E+01, 4.3763470947E+00, 9.8026143952E-01],
	[4.0375000000E+04, 4.8836208676E+01, 5.6404162564E+00, 3.2558290589E+01, 4.3767002658E+00, 9.8027104272E-01],
	[4.0380000000E+04, 4.8846841369E+01, 5.6404618239E+00, 3.2571589629E+01, 4.3770533331E+00, 9.8028064072E-01],
	[4.0385000000E+04, 4.8857475061E+01, 5.6405073861E+00, 3.2584892452E+01, 4.3774062969E+00, 9.8029023352E-01],
	[4.0390000000E+04, 4.8868109751E+01, 5.6405529431E+00, 3.2598199060E+01, 4.3777591569E+00, 9.8029982112E-01],
	[4.0395000000E+04, 4.8878745438E+01, 5.6405984947E+00, 3.2611509452E+01, 4.3781119134E+00, 9.8030940352E-01],
	[4.0400000000E+04, 4.8889382124E+01, 5.6406440412E+00, 3.2624823630E+01, 4.3784645662E+00, 9.8031898073E-01],
	[4.0405000000E+04, 4.8900019807E+01, 5.6406895823E+00, 3.2638141594E+01, 4.3788171156E+00, 9.8032855275E-01],
	[4.0410000000E+04, 4.8910658488E+01, 5.6407351182E+00, 3.2651463344E+01, 4.3791695614E+00, 9.8033811959E-01],
	[4.0415000000E+04, 4.8921298168E+01, 5.6407806488E+00, 3.2664788882E+01, 4.3795219037E+00, 9.8034768124E-01],
	[4.0420000000E+04, 4.8931938845E+01, 5.6408261742E+00, 3.2678118208E+01, 4.3798741427E+00, 9.8035723770E-01],
	[4.0425000000E+04, 4.8942580519E+01, 5.6408716942E+00, 3.2691451322E+01, 4.3802262782E+00, 9.8036678899E-01],
	[4.0430000000E+04, 4.8953223192E+01, 5.6409172091E+00, 3.2704788226E+01, 4.3805783103E+00, 9.8037633510E-01],
	[4.0435000000E+04, 4.8963866862E+01, 5.6409627186E+00, 3.2718128919E+01, 4.3809302391E+00, 9.8038587604E-01],
	[4.0440000000E+04, 4.8974511530E+01, 5.6410082229E+00, 3.2731473403E+01, 4.3812820646E+00, 9.8039541180E-01],
	[4.0445000000E+04, 4.8985157196E+01, 5.6410537220E+00, 3.2744821677E+01, 4.3816337868E+00, 9.8040494240E-01],
	[4.0450000000E+04, 4.8995803859E+01, 5.6410992157E+00, 3.2758173744E+01, 4.3819854058E+00, 9.8041446784E-01],
	[4.0455000000E+04, 4.9006451520E+01, 5.6411447043E+00, 3.2771529602E+01, 4.3823369216E+00, 9.8042398811E-01],
	[4.0460000000E+04, 4.9017100179E+01, 5.6411901875E+00, 3.2784889253E+01, 4.3826883342E+00, 9.8043350322E-01],
	[4.0465000000E+04, 4.9027749835E+01, 5.6412356656E+00, 3.2798252697E+01, 4.3830396437E+00, 9.8044301317E-01],
	[4.0470000000E+04, 4.9038400488E+01, 5.6412811383E+00, 3.2811619936E+01, 4.3833908501E+00, 9.8045251797E-01],
	[4.0475000000E+04, 4.9049052140E+01, 5.6413266058E+00, 3.2824990969E+01, 4.3837419535E+00, 9.8046201762E-01],
	[4.0480000000E+04, 4.9059704788E+01, 5.6413720681E+00, 3.2838365797E+01, 4.3840929538E+00, 9.8047151213E-01],
	[4.0485000000E+04, 4.9070358434E+01, 5.6414175251E+00, 3.2851744421E+01, 4.3844438511E+00, 9.8048100148E-01],
	[4.0490000000E+04, 4.9081013078E+01, 5.6414629769E+00, 3.2865126842E+01, 4.3847946454E+00, 9.8049048569E-01],
	[4.0495000000E+04, 4.9091668719E+01, 5.6415084234E+00, 3.2878513060E+01, 4.3851453369E+00, 9.8049996477E-01],
	[4.0500000000E+04, 4.9102325357E+01, 5.6415538647E+00, 3.2891903075E+01, 4.3854959254E+00, 9.8050943870E-01],
	[4.0505000000E+04, 4.9112982992E+01, 5.6415993007E+00, 3.2905296888E+01, 4.3858464111E+00, 9.8051890750E-01],
	[4.0510000000E+04, 4.9123641625E+01, 5.6416447315E+00, 3.2918694501E+01, 4.3861967940E+00, 9.8052837117E-01],
	[4.0515000000E+04, 4.9134323244E+01, 5.6416921870E+00, 3.2932095912E+01, 4.3865484765E+00, 9.8053782971E-01],
	[4.0520000000E+04, 4.9145006861E+01, 5.6417397287E+00, 3.2945501124E+01, 4.3869001198E+00, 9.8054728312E-01],
	[4.0525000000E+04, 4.9155691482E+01, 5.6417872649E+00, 3.2958910137E+01, 4.3872516605E+00, 9.8055673142E-01],
	[4.0530000000E+04, 4.9166377107E+01, 5.6418347957E+00, 3.2972322951E+01, 4.3876030988E+00, 9.8056617459E-01],
	[4.0535000000E+04, 4.9177063737E+01, 5.6418823210E+00, 3.2985739566E+01, 4.3879544346E+00, 9.8057561264E-01],
	[4.0540000000E+04, 4.9187751371E+01, 5.6419298409E+00, 3.2999159985E+01, 4.3883056680E+00, 9.8058504558E-01],
	[4.0545000000E+04, 4.9198440009E+01, 5.6419773553E+00, 3.3012584206E+01, 4.3886567989E+00, 9.8059447340E-01],
	[4.0550000000E+04, 4.9209129651E+01, 5.6420248642E+00, 3.3026012231E+01, 4.3890078275E+00, 9.8060389612E-01],
	[4.0555000000E+04, 4.9219820298E+01, 5.6420723677E+00, 3.3039444061E+01, 4.3893587538E+00, 9.8061331373E-01],
	[4.0560000000E+04, 4.9230511948E+01, 5.6421198657E+00, 3.3052879695E+01, 4.3897095778E+00, 9.8062272623E-01],
	[4.0565000000E+04, 4.9241204603E+01, 5.6421673583E+00, 3.3066319135E+01, 4.3900602995E+00, 9.8063213364E-01],
	[4.0570000000E+04, 4.9251898262E+01, 5.6422148454E+00, 3.3079762381E+01, 4.3904109191E+00, 9.8064153595E-01],
	[4.0575000000E+04, 4.9262592925E+01, 5.6422623271E+00, 3.3093209434E+01, 4.3907614364E+00, 9.8065093316E-01],
	[4.0580000000E+04, 4.9273288592E+01, 5.6423098033E+00, 3.3106660294E+01, 4.3911118515E+00, 9.8066032528E-01],
	[4.0585000000E+04, 4.9283985263E+01, 5.6423572741E+00, 3.3120114962E+01, 4.3914621645E+00, 9.8066971231E-01],
	[4.0590000000E+04, 4.9294682938E+01, 5.6424047394E+00, 3.3133573439E+01, 4.3918123755E+00, 9.8067909425E-01],
	[4.0595000000E+04, 4.9305381616E+01, 5.6424521993E+00, 3.3147035725E+01, 4.3921624844E+00, 9.8068847111E-01],
	[4.0600000000E+04, 4.9316081299E+01, 5.6424996537E+00, 3.3160501821E+01, 4.3925124912E+00, 9.8069784288E-01],
	[4.0605000000E+04, 4.9326781986E+01, 5.6425471027E+00, 3.3173971727E+01, 4.3928623961E+00, 9.8070720958E-01],
	[4.0610000000E+04, 4.9337483676E+01, 5.6425945462E+00, 3.3187445444E+01, 4.3932121990E+00, 9.8071657121E-01],
	[4.0615000000E+04, 4.9348186371E+01, 5.6426419843E+00, 3.3200922973E+01, 4.3935619000E+00, 9.8072592775E-01],
	[4.0620000000E+04, 4.9358890069E+01, 5.6426894169E+00, 3.3214404314E+01, 4.3939114991E+00, 9.8073527923E-01],
	[4.0625000000E+04, 4.9369594771E+01, 5.6427368441E+00, 3.3227889468E+01, 4.3942609963E+00, 9.8074462565E-01],
	[4.0630000000E+04, 4.9380300476E+01, 5.6427842659E+00, 3.3241378436E+01, 4.3946103918E+00, 9.8075396699E-01],
	[4.0635000000E+04, 4.9391007185E+01, 5.6428316822E+00, 3.3254871217E+01, 4.3949596854E+00, 9.8076330328E-01],
	[4.0640000000E+04, 4.9401714898E+01, 5.6428790931E+00, 3.3268367814E+01, 4.3953088773E+00, 9.8077263450E-01],
	[4.0645000000E+04, 4.9412423615E+01, 5.6429264986E+00, 3.3281868225E+01, 4.3956579675E+00, 9.8078196067E-01],
	[4.0650000000E+04, 4.9423133335E+01, 5.6429738986E+00, 3.3295372452E+01, 4.3960069560E+00, 9.8079128179E-01],
	[4.0655000000E+04, 4.9433844059E+01, 5.6430212932E+00, 3.3308880496E+01, 4.3963558428E+00, 9.8080059785E-01],
	[4.0660000000E+04, 4.9444555786E+01, 5.6430686824E+00, 3.3322392357E+01, 4.3967046280E+00, 9.8080990887E-01],
	[4.0665000000E+04, 4.9455268517E+01, 5.6431160662E+00, 3.3335908036E+01, 4.3970533117E+00, 9.8081921484E-01],
	[4.0670000000E+04, 4.9465982252E+01, 5.6431634445E+00, 3.3349427533E+01, 4.3974018938E+00, 9.8082851577E-01],
	[4.0675000000E+04, 4.9476696989E+01, 5.6432108174E+00, 3.3362950849E+01, 4.3977503743E+00, 9.8083781166E-01],
	[4.0680000000E+04, 4.9487412731E+01, 5.6432581848E+00, 3.3376477984E+01, 4.3980987534E+00, 9.8084710252E-01],
	[4.0685000000E+04, 4.9498129475E+01, 5.6433055468E+00, 3.3390008940E+01, 4.3984470311E+00, 9.8085638834E-01],
	[4.0690000000E+04, 4.9508847224E+01, 5.6433529035E+00, 3.3403543716E+01, 4.3987952073E+00, 9.8086566913E-01],
	[4.0695000000E+04, 4.9519565975E+01, 5.6434002547E+00, 3.3417082314E+01, 4.3991432822E+00, 9.8087494489E-01],
	[4.0700000000E+04, 4.9530285730E+01, 5.6434476004E+00, 3.3430624734E+01, 4.3994912557E+00, 9.8088421562E-01],
	[4.0705000000E+04, 4.9541006488E+01, 5.6434949408E+00, 3.3444170976E+01, 4.3998391279E+00, 9.8089348133E-01],
	[4.0710000000E+04, 4.9551728249E+01, 5.6435422757E+00, 3.3457721042E+01, 4.4001868988E+00, 9.8090274202E-01],
	[4.0715000000E+04, 4.9562451014E+01, 5.6435896052E+00, 3.3471274931E+01, 4.4005345684E+00, 9.8091199770E-01],
	[4.0720000000E+04, 4.9573174781E+01, 5.6436369293E+00, 3.3484832645E+01, 4.4008821369E+00, 9.8092124835E-01],
	[4.0725000000E+04, 4.9583899552E+01, 5.6436842480E+00, 3.3498394183E+01, 4.4012296042E+00, 9.8093049400E-01],
	[4.0730000000E+04, 4.9594625326E+01, 5.6437315613E+00, 3.3511959548E+01, 4.4015769703E+00, 9.8093973464E-01],
	[4.0735000000E+04, 4.9605352103E+01, 5.6437788692E+00, 3.3525528739E+01, 4.4019242353E+00, 9.8094897027E-01],
	[4.0740000000E+04, 4.9616079884E+01, 5.6438261716E+00, 3.3539101756E+01, 4.4022713993E+00, 9.8095820090E-01],
	[4.0745000000E+04, 4.9626808667E+01, 5.6438734687E+00, 3.3552678601E+01, 4.4026184622E+00, 9.8096742653E-01],
	[4.0750000000E+04, 4.9637538453E+01, 5.6439207603E+00, 3.3566259274E+01, 4.4029654241E+00, 9.8097664716E-01],
	[4.0755000000E+04, 4.9648269242E+01, 5.6439680466E+00, 3.3579843776E+01, 4.4033122850E+00, 9.8098586280E-01],
	[4.0760000000E+04, 4.9659001035E+01, 5.6440153274E+00, 3.3593432107E+01, 4.4036590450E+00, 9.8099507344E-01],
	[4.0765000000E+04, 4.9669733830E+01, 5.6440626028E+00, 3.3607024268E+01, 4.4040057040E+00, 9.8100427909E-01],
	[4.0770000000E+04, 4.9680467628E+01, 5.6441098728E+00, 3.3620620259E+01, 4.4043522622E+00, 9.8101347976E-01],
	[4.0775000000E+04, 4.9691202429E+01, 5.6441571375E+00, 3.3634220081E+01, 4.4046987196E+00, 9.8102267544E-01],
	[4.0780000000E+04, 4.9701938233E+01, 5.6442043967E+00, 3.3647823736E+01, 4.4050450761E+00, 9.8103186614E-01],
	[4.0785000000E+04, 4.9712675040E+01, 5.6442516505E+00, 3.3661431222E+01, 4.4053913319E+00, 9.8104105187E-01],
	[4.0790000000E+04, 4.9723412849E+01, 5.6442988989E+00, 3.3675042542E+01, 4.4057374869E+00, 9.8105023261E-01],
	[4.0795000000E+04, 4.9734151661E+01, 5.6443461420E+00, 3.3688657695E+01, 4.4060835412E+00, 9.8105940839E-01],
	[4.0800000000E+04, 4.9744891476E+01, 5.6443933796E+00, 3.3702276682E+01, 4.4064294949E+00, 9.8106857919E-01],
	[4.0805000000E+04, 4.9755632294E+01, 5.6444406118E+00, 3.3715899504E+01, 4.4067753479E+00, 9.8107774503E-01],
	[4.0810000000E+04, 4.9766374114E+01, 5.6444878387E+00, 3.3729526161E+01, 4.4071211003E+00, 9.8108690590E-01],
	[4.0815000000E+04, 4.9777116937E+01, 5.6445350602E+00, 3.3743156655E+01, 4.4074667521E+00, 9.8109606182E-01],
	[4.0820000000E+04, 4.9787860763E+01, 5.6445822762E+00, 3.3756790985E+01, 4.4078123034E+00, 9.8110521277E-01],
	[4.0825000000E+04, 4.9798605591E+01, 5.6446294869E+00, 3.3770429152E+01, 4.4081577542E+00, 9.8111435876E-01],
	[4.0830000000E+04, 4.9809351422E+01, 5.6446766922E+00, 3.3784071157E+01, 4.4085031045E+00, 9.8112349981E-01],
	[4.0835000000E+04, 4.9820098255E+01, 5.6447238921E+00, 3.3797717000E+01, 4.4088483544E+00, 9.8113263590E-01],
	[4.0840000000E+04, 4.9830846091E+01, 5.6447710866E+00, 3.3811366683E+01, 4.4091935038E+00, 9.8114176704E-01],
	[4.0845000000E+04, 4.9841594929E+01, 5.6448182758E+00, 3.3825020205E+01, 4.4095385529E+00, 9.8115089324E-01],
	[4.0850000000E+04, 4.9852344770E+01, 5.6448654595E+00, 3.3838677567E+01, 4.4098835017E+00, 9.8116001450E-01],
	[4.0855000000E+04, 4.9863095613E+01, 5.6449126379E+00, 3.3852338770E+01, 4.4102283501E+00, 9.8116913081E-01],
	[4.0860000000E+04, 4.9873847459E+01, 5.6449598109E+00, 3.3866003815E+01, 4.4105730983E+00, 9.8117824219E-01],
	[4.0865000000E+04, 4.9884600306E+01, 5.6450069786E+00, 3.3879672702E+01, 4.4109177463E+00, 9.8118734864E-01],
	[4.0870000000E+04, 4.9895354157E+01, 5.6450541408E+00, 3.3893345431E+01, 4.4112622940E+00, 9.8119645015E-01],
	[4.0875000000E+04, 4.9906109009E+01, 5.6451012977E+00, 3.3907022004E+01, 4.4116067416E+00, 9.8120554674E-01],
	[4.0880000000E+04, 4.9916864864E+01, 5.6451484492E+00, 3.3920702420E+01, 4.4119510890E+00, 9.8121463840E-01],
	[4.0885000000E+04, 4.9927621721E+01, 5.6451955953E+00, 3.3934386682E+01, 4.4122953363E+00, 9.8122372514E-01],
	[4.0890000000E+04, 4.9938379580E+01, 5.6452427360E+00, 3.3948074788E+01, 4.4126394836E+00, 9.8123280695E-01],
	[4.0895000000E+04, 4.9949138441E+01, 5.6452898714E+00, 3.3961766740E+01, 4.4129835308E+00, 9.8124188385E-01],
	[4.0900000000E+04, 4.9959898305E+01, 5.6453370014E+00, 3.3975462538E+01, 4.4133274780E+00, 9.8125095584E-01],
	[4.0905000000E+04, 4.9970659170E+01, 5.6453841261E+00, 3.3989162184E+01, 4.4136713253E+00, 9.8126002291E-01],
	[4.0910000000E+04, 4.9981421038E+01, 5.6454312454E+00, 3.4002865676E+01, 4.4140150726E+00, 9.8126908508E-01],
	[4.0915000000E+04, 4.9992183908E+01, 5.6454783593E+00, 3.4016573018E+01, 4.4143587200E+00, 9.8127814233E-01],
	[4.0920000000E+04, 5.0002947780E+01, 5.6455254678E+00, 3.4030284207E+01, 4.4147022675E+00, 9.8128719469E-01],
	[4.0925000000E+04, 5.0013712653E+01, 5.6455725710E+00, 3.4043999247E+01, 4.4150457152E+00, 9.8129624214E-01],
	[4.0930000000E+04, 5.0024478529E+01, 5.6456196688E+00, 3.4057718136E+01, 4.4153890631E+00, 9.8130528470E-01],
	[4.0935000000E+04, 5.0035245407E+01, 5.6456667613E+00, 3.4071440876E+01, 4.4157323112E+00, 9.8131432236E-01],
	[4.0940000000E+04, 5.0046013287E+01, 5.6457138484E+00, 3.4085167467E+01, 4.4160754596E+00, 9.8132335512E-01],
	[4.0945000000E+04, 5.0056782168E+01, 5.6457609302E+00, 3.4098897910E+01, 4.4164185083E+00, 9.8133238300E-01],
	[4.0950000000E+04, 5.0067552052E+01, 5.6458080065E+00, 3.4112632205E+01, 4.4167614573E+00, 9.8134140599E-01],
	[4.0955000000E+04, 5.0078322937E+01, 5.6458550776E+00, 3.4126370354E+01, 4.4171043067E+00, 9.8135042410E-01],
	[4.0960000000E+04, 5.0089094824E+01, 5.6459021433E+00, 3.4140112356E+01, 4.4174470565E+00, 9.8135943732E-01],
	[4.0965000000E+04, 5.0099867713E+01, 5.6459492036E+00, 3.4153858213E+01, 4.4177897067E+00, 9.8136844567E-01],
	[4.0970000000E+04, 5.0110641603E+01, 5.6459962586E+00, 3.4167607924E+01, 4.4181322573E+00, 9.8137744914E-01],
	[4.0975000000E+04, 5.0121416495E+01, 5.6460433082E+00, 3.4181361491E+01, 4.4184747085E+00, 9.8138644774E-01],
	[4.0980000000E+04, 5.0132192389E+01, 5.6460903525E+00, 3.4195118914E+01, 4.4188170602E+00, 9.8139544146E-01],
	[4.0985000000E+04, 5.0142969285E+01, 5.6461373914E+00, 3.4208880193E+01, 4.4191593124E+00, 9.8140443032E-01],
	[4.0990000000E+04, 5.0153747182E+01, 5.6461844250E+00, 3.4222645330E+01, 4.4195014653E+00, 9.8141341431E-01],
	[4.0995000000E+04, 5.0164526081E+01, 5.6462314532E+00, 3.4236414325E+01, 4.4198435188E+00, 9.8142239344E-01],
	[4.1000000000E+04, 5.0175305981E+01, 5.6462784761E+00, 3.4250187178E+01, 4.4201854729E+00, 9.8143136772E-01],
	[4.1005000000E+04, 5.0186086883E+01, 5.6463254937E+00, 3.4263963891E+01, 4.4205273278E+00, 9.8144033713E-01],
	[4.1010000000E+04, 5.0196868786E+01, 5.6463725059E+00, 3.4277744463E+01, 4.4208690833E+00, 9.8144930169E-01],
	[4.1015000000E+04, 5.0207651691E+01, 5.6464195128E+00, 3.4291528896E+01, 4.4212107397E+00, 9.8145826140E-01],
	[4.1020000000E+04, 5.0218435598E+01, 5.6464665143E+00, 3.4305317190E+01, 4.4215522968E+00, 9.8146721626E-01],
	[4.1025000000E+04, 5.0229220505E+01, 5.6465135105E+00, 3.4319109345E+01, 4.4218937547E+00, 9.8147616628E-01],
	[4.1030000000E+04, 5.0240006415E+01, 5.6465605013E+00, 3.4332905363E+01, 4.4222351136E+00, 9.8148511145E-01],
	[4.1035000000E+04, 5.0250793325E+01, 5.6466074869E+00, 3.4346705243E+01, 4.4225763733E+00, 9.8149405179E-01],
	[4.1040000000E+04, 5.0261581237E+01, 5.6466544671E+00, 3.4360508987E+01, 4.4229175339E+00, 9.8150298728E-01],
	[4.1045000000E+04, 5.0272370150E+01, 5.6467014419E+00, 3.4374316595E+01, 4.4232585955E+00, 9.8151191794E-01],
	[4.1050000000E+04, 5.0283160064E+01, 5.6467484114E+00, 3.4388128067E+01, 4.4235995581E+00, 9.8152084377E-01],
	[4.1055000000E+04, 5.0293950980E+01, 5.6467953756E+00, 3.4401943405E+01, 4.4239404217E+00, 9.8152976477E-01],
	[4.1060000000E+04, 5.0304742897E+01, 5.6468423345E+00, 3.4415762609E+01, 4.4242811864E+00, 9.8153868094E-01],
	[4.1065000000E+04, 5.0315535815E+01, 5.6468892881E+00, 3.4429585679E+01, 4.4246218522E+00, 9.8154759229E-01],
	[4.1070000000E+04, 5.0326329734E+01, 5.6469362363E+00, 3.4443412616E+01, 4.4249624191E+00, 9.8155649882E-01],
	[4.1075000000E+04, 5.0337124655E+01, 5.6469831792E+00, 3.4457243421E+01, 4.4253028872E+00, 9.8156540053E-01],
	[4.1080000000E+04, 5.0347920576E+01, 5.6470301167E+00, 3.4471078094E+01, 4.4256432564E+00, 9.8157429742E-01],
	[4.1085000000E+04, 5.0358717499E+01, 5.6470770490E+00, 3.4484916636E+01, 4.4259835269E+00, 9.8158318951E-01],
	[4.1090000000E+04, 5.0369515422E+01, 5.6471239759E+00, 3.4498759048E+01, 4.4263236987E+00, 9.8159207678E-01],
	[4.1095000000E+04, 5.0380314347E+01, 5.6471708975E+00, 3.4512605330E+01, 4.4266637717E+00, 9.8160095924E-01],
	[4.1100000000E+04, 5.0391114272E+01, 5.6472178138E+00, 3.4526455482E+01, 4.4270037461E+00, 9.8160983690E-01],
	[4.1105000000E+04, 5.0401915199E+01, 5.6472647247E+00, 3.4540309506E+01, 4.4273436218E+00, 9.8161870976E-01],
	[4.1110000000E+04, 5.0412717126E+01, 5.6473116304E+00, 3.4554167402E+01, 4.4276833989E+00, 9.8162757782E-01],
	[4.1115000000E+04, 5.0423520055E+01, 5.6473585307E+00, 3.4568029171E+01, 4.4280230774E+00, 9.8163644109E-01],
	[4.1120000000E+04, 5.0434323984E+01, 5.6474054257E+00, 3.4581894812E+01, 4.4283626574E+00, 9.8164529956E-01],
	[4.1125000000E+04, 5.0445128914E+01, 5.6474523154E+00, 3.4595764328E+01, 4.4287021389E+00, 9.8165415323E-01],
	[4.1130000000E+04, 5.0455934845E+01, 5.6474991998E+00, 3.4609637718E+01, 4.4290415219E+00, 9.8166300213E-01],
	[4.1135000000E+04, 5.0466741776E+01, 5.6475460789E+00, 3.4623514983E+01, 4.4293808065E+00, 9.8167184623E-01],
	[4.1140000000E+04, 5.0477549709E+01, 5.6475929527E+00, 3.4637396123E+01, 4.4297199927E+00, 9.8168068556E-01],
	[4.1145000000E+04, 5.0488358642E+01, 5.6476398212E+00, 3.4651281140E+01, 4.4300590805E+00, 9.8168952010E-01],
	[4.1150000000E+04, 5.0499168576E+01, 5.6476866843E+00, 3.4665170034E+01, 4.4303980699E+00, 9.8169834986E-01],
	[4.1155000000E+04, 5.0509979510E+01, 5.6477335422E+00, 3.4679062805E+01, 4.4307369610E+00, 9.8170717486E-01],
	[4.1160000000E+04, 5.0520791445E+01, 5.6477803947E+00, 3.4692959454E+01, 4.4310757539E+00, 9.8171599508E-01],
	[4.1165000000E+04, 5.0531616433E+01, 5.6478283308E+00, 3.4706859982E+01, 4.4314152114E+00, 9.8172481053E-01],
	[4.1170000000E+04, 5.0542453336E+01, 5.6478772468E+00, 3.4720764389E+01, 4.4317552615E+00, 9.8173362121E-01],
	[4.1175000000E+04, 5.0553291246E+01, 5.6479261573E+00, 3.4734672677E+01, 4.4320952136E+00, 9.8174242714E-01],
	[4.1180000000E+04, 5.0564130163E+01, 5.6479750623E+00, 3.4748584844E+01, 4.4324350677E+00, 9.8175122830E-01],
	[4.1185000000E+04, 5.0574970089E+01, 5.6480239617E+00, 3.4762500893E+01, 4.4327748238E+00, 9.8176002470E-01],
	[4.1190000000E+04, 5.0585811021E+01, 5.6480728557E+00, 3.4776420824E+01, 4.4331144821E+00, 9.8176881635E-01],
	[4.1195000000E+04, 5.0596652962E+01, 5.6481217442E+00, 3.4790344637E+01, 4.4334540424E+00, 9.8177760325E-01],
	[4.1200000000E+04, 5.0607495909E+01, 5.6481706271E+00, 3.4804272333E+01, 4.4337935049E+00, 9.8178638539E-01],
	[4.1205000000E+04, 5.0618339864E+01, 5.6482195045E+00, 3.4818203912E+01, 4.4341328696E+00, 9.8179516279E-01],
	[4.1210000000E+04, 5.0629184827E+01, 5.6482683764E+00, 3.4832139376E+01, 4.4344721366E+00, 9.8180393545E-01],
	[4.1215000000E+04, 5.0640030797E+01, 5.6483172429E+00, 3.4846078724E+01, 4.4348113057E+00, 9.8181270336E-01],
	[4.1220000000E+04, 5.0650877774E+01, 5.6483661038E+00, 3.4860021958E+01, 4.4351503772E+00, 9.8182146653E-01],
	[4.1225000000E+04, 5.0661725758E+01, 5.6484149592E+00, 3.4873969078E+01, 4.4354893510E+00, 9.8183022497E-01],
	[4.1230000000E+04, 5.0672574750E+01, 5.6484638091E+00, 3.4887920085E+01, 4.4358282271E+00, 9.8183897868E-01],
	[4.1235000000E+04, 5.0683424749E+01, 5.6485126535E+00, 3.4901874979E+01, 4.4361670057E+00, 9.8184772765E-01],
	[4.1240000000E+04, 5.0694275755E+01, 5.6485614924E+00, 3.4915833760E+01, 4.4365056866E+00, 9.8185647190E-01],
	[4.1245000000E+04, 5.0705127769E+01, 5.6486103258E+00, 3.4929796430E+01, 4.4368442700E+00, 9.8186521142E-01],
	[4.1250000000E+04, 5.0715980789E+01, 5.6486591537E+00, 3.4943762990E+01, 4.4371827559E+00, 9.8187394622E-01],
	[4.1255000000E+04, 5.0726834817E+01, 5.6487079761E+00, 3.4957733439E+01, 4.4375211443E+00, 9.8188267630E-01],
	[4.1260000000E+04, 5.0737689852E+01, 5.6487567930E+00, 3.4971707778E+01, 4.4378594352E+00, 9.8189140166E-01],
	[4.1265000000E+04, 5.0748545894E+01, 5.6488056045E+00, 3.4985686008E+01, 4.4381976287E+00, 9.8190012231E-01],
	[4.1270000000E+04, 5.0759402943E+01, 5.6488544104E+00, 3.4999668130E+01, 4.4385357248E+00, 9.8190883824E-01],
	[4.1275000000E+04, 5.0770260999E+01, 5.6489032108E+00, 3.5013654144E+01, 4.4388737236E+00, 9.8191754947E-01],
	[4.1280000000E+04, 5.0781120062E+01, 5.6489520058E+00, 3.5027644050E+01, 4.4392116251E+00, 9.8192625599E-01],
	[4.1285000000E+04, 5.0791980132E+01, 5.6490007952E+00, 3.5041637850E+01, 4.4395494292E+00, 9.8193495781E-01],
	[4.1290000000E+04, 5.0802841209E+01, 5.6490495792E+00, 3.5055635544E+01, 4.4398871361E+00, 9.8194365493E-01],
	[4.1295000000E+04, 5.0813703293E+01, 5.6490983577E+00, 3.5069637132E+01, 4.4402247458E+00, 9.8195234735E-01],
	[4.1300000000E+04, 5.0824566384E+01, 5.6491471307E+00, 3.5083642616E+01, 4.4405622583E+00, 9.8196103507E-01],
	[4.1305000000E+04, 5.0835430481E+01, 5.6491958982E+00, 3.5097651996E+01, 4.4408996737E+00, 9.8196971810E-01],
	[4.1310000000E+04, 5.0846295586E+01, 5.6492446603E+00, 3.5111665272E+01, 4.4412369919E+00, 9.8197839644E-01],
	[4.1315000000E+04, 5.0857161697E+01, 5.6492934168E+00, 3.5125682444E+01, 4.4415742130E+00, 9.8198707010E-01],
	[4.1320000000E+04, 5.0868028815E+01, 5.6493421679E+00, 3.5139703515E+01, 4.4419113370E+00, 9.8199573907E-01],
	[4.1325000000E+04, 5.0878896940E+01, 5.6493909135E+00, 3.5153728484E+01, 4.4422483641E+00, 9.8200440335E-01],
	[4.1330000000E+04, 5.0889766071E+01, 5.6494396536E+00, 3.5167757352E+01, 4.4425852941E+00, 9.8201306296E-01],
	[4.1335000000E+04, 5.0900636209E+01, 5.6494883883E+00, 3.5181790119E+01, 4.4429221271E+00, 9.8202171790E-01],
	[4.1340000000E+04, 5.0911507354E+01, 5.6495371174E+00, 3.5195826786E+01, 4.4432588633E+00, 9.8203036816E-01],
	[4.1345000000E+04, 5.0922379505E+01, 5.6495858411E+00, 3.5209867354E+01, 4.4435955025E+00, 9.8203901374E-01],
	[4.1350000000E+04, 5.0933252663E+01, 5.6496345594E+00, 3.5223911823E+01, 4.4439320449E+00, 9.8204765466E-01],
	[4.1355000000E+04, 5.0944126828E+01, 5.6496832721E+00, 3.5237960195E+01, 4.4442684904E+00, 9.8205629092E-01],
	[4.1360000000E+04, 5.0955001999E+01, 5.6497319794E+00, 3.5252012468E+01, 4.4446048392E+00, 9.8206492251E-01],
	[4.1365000000E+04, 5.0965878177E+01, 5.6497806812E+00, 3.5266068645E+01, 4.4449410911E+00, 9.8207354944E-01],
	[4.1370000000E+04, 5.0976755361E+01, 5.6498293776E+00, 3.5280128726E+01, 4.4452772464E+00, 9.8208217172E-01],
	[4.1375000000E+04, 5.0987633551E+01, 5.6498780685E+00, 3.5294192711E+01, 4.4456133049E+00, 9.8209078934E-01],
	[4.1380000000E+04, 5.0998512748E+01, 5.6499267539E+00, 3.5308260601E+01, 4.4459492667E+00, 9.8209940231E-01],
	[4.1385000000E+04, 5.1009392952E+01, 5.6499754338E+00, 3.5322332396E+01, 4.4462851320E+00, 9.8210801063E-01],
	[4.1390000000E+04, 5.1020274162E+01, 5.6500241083E+00, 3.5336408098E+01, 4.4466209006E+00, 9.8211661430E-01],
	[4.1395000000E+04, 5.1031156378E+01, 5.6500727774E+00, 3.5350487707E+01, 4.4469565726E+00, 9.8212521333E-01],
	[4.1400000000E+04, 5.1042039600E+01, 5.6501214410E+00, 3.5364571223E+01, 4.4472921481E+00, 9.8213380772E-01],
	[4.1405000000E+04, 5.1052923829E+01, 5.6501700991E+00, 3.5378658647E+01, 4.4476276271E+00, 9.8214239747E-01],
	[4.1410000000E+04, 5.1063809064E+01, 5.6502187517E+00, 3.5392749980E+01, 4.4479630096E+00, 9.8215098258E-01],
	[4.1415000000E+04, 5.1074695305E+01, 5.6502673989E+00, 3.5406845222E+01, 4.4482982957E+00, 9.8215956306E-01],
	[4.1420000000E+04, 5.1085582552E+01, 5.6503160407E+00, 3.5420944374E+01, 4.4486334853E+00, 9.8216813891E-01],
	[4.1425000000E+04, 5.1096470806E+01, 5.6503646770E+00, 3.5435047436E+01, 4.4489685786E+00, 9.8217671013E-01],
	[4.1430000000E+04, 5.1107360066E+01, 5.6504133079E+00, 3.5449154409E+01, 4.4493035755E+00, 9.8218527673E-01],
	[4.1435000000E+04, 5.1118250331E+01, 5.6504619333E+00, 3.5463265295E+01, 4.4496384761E+00, 9.8219383871E-01],
	[4.1440000000E+04, 5.1129141603E+01, 5.6505105532E+00, 3.5477380092E+01, 4.4499732804E+00, 9.8220239606E-01],
	[4.1445000000E+04, 5.1140033881E+01, 5.6505591677E+00, 3.5491498802E+01, 4.4503079885E+00, 9.8221094880E-01],
	[4.1450000000E+04, 5.1150927165E+01, 5.6506077768E+00, 3.5505621426E+01, 4.4506426004E+00, 9.8221949693E-01],
	[4.1455000000E+04, 5.1161821455E+01, 5.6506563804E+00, 3.5519747965E+01, 4.4509771160E+00, 9.8222804044E-01],
	[4.1460000000E+04, 5.1172716751E+01, 5.6507049786E+00, 3.5533878418E+01, 4.4513115356E+00, 9.8223657935E-01],
	[4.1465000000E+04, 5.1183613053E+01, 5.6507535713E+00, 3.5548012786E+01, 4.4516458590E+00, 9.8224511365E-01],
	[4.1470000000E+04, 5.1194510361E+01, 5.6508021586E+00, 3.5562151070E+01, 4.4519800863E+00, 9.8225364334E-01],
	[4.1475000000E+04, 5.1205408674E+01, 5.6508507404E+00, 3.5576293271E+01, 4.4523142175E+00, 9.8226216844E-01],
	[4.1480000000E+04, 5.1216307994E+01, 5.6508993168E+00, 3.5590439389E+01, 4.4526482527E+00, 9.8227068893E-01],
	[4.1485000000E+04, 5.1227208319E+01, 5.6509478878E+00, 3.5604589425E+01, 4.4529821920E+00, 9.8227920484E-01],
	[4.1490000000E+04, 5.1238109650E+01, 5.6509964533E+00, 3.5618743380E+01, 4.4533160352E+00, 9.8228771615E-01],
	[4.1495000000E+04, 5.1249011987E+01, 5.6510450134E+00, 3.5632901253E+01, 4.4536497826E+00, 9.8229622286E-01],
	[4.1500000000E+04, 5.1259915330E+01, 5.6510935681E+00, 3.5647063046E+01, 4.4539834340E+00, 9.8230472500E-01],
	[4.1505000000E+04, 5.1270819679E+01, 5.6511421173E+00, 3.5661228760E+01, 4.4543169896E+00, 9.8231322254E-01],
	[4.1510000000E+04, 5.1281725033E+01, 5.6511906611E+00, 3.5675398394E+01, 4.4546504494E+00, 9.8232171551E-01],
	[4.1515000000E+04, 5.1292631392E+01, 5.6512391995E+00, 3.5689571950E+01, 4.4549838133E+00, 9.8233020390E-01],
	[4.1520000000E+04, 5.1303538758E+01, 5.6512877324E+00, 3.5703749428E+01, 4.4553170815E+00, 9.8233868771E-01],
	[4.1525000000E+04, 5.1314447129E+01, 5.6513362599E+00, 3.5717930829E+01, 4.4556502540E+00, 9.8234716694E-01],
	[4.1530000000E+04, 5.1325356505E+01, 5.6513847820E+00, 3.5732116153E+01, 4.4559833307E+00, 9.8235564161E-01],
	[4.1535000000E+04, 5.1336266887E+01, 5.6514332987E+00, 3.5746305401E+01, 4.4563163118E+00, 9.8236411170E-01],
	[4.1540000000E+04, 5.1347178275E+01, 5.6514818099E+00, 3.5760498573E+01, 4.4566491973E+00, 9.8237257724E-01],
	[4.1545000000E+04, 5.1358090668E+01, 5.6515303157E+00, 3.5774695671E+01, 4.4569819871E+00, 9.8238103820E-01],
	[4.1550000000E+04, 5.1369004067E+01, 5.6515788161E+00, 3.5788896694E+01, 4.4573146814E+00, 9.8238949461E-01],
	[4.1555000000E+04, 5.1379918471E+01, 5.6516273111E+00, 3.5803101644E+01, 4.4576472801E+00, 9.8239794646E-01],
	[4.1560000000E+04, 5.1390833880E+01, 5.6516758007E+00, 3.5817310521E+01, 4.4579797833E+00, 9.8240639375E-01],
	[4.1565000000E+04, 5.1401750295E+01, 5.6517242848E+00, 3.5831523326E+01, 4.4583121911E+00, 9.8241483650E-01],
	[4.1570000000E+04, 5.1412667715E+01, 5.6517727635E+00, 3.5845740059E+01, 4.4586445033E+00, 9.8242327469E-01],
	[4.1575000000E+04, 5.1423586140E+01, 5.6518212368E+00, 3.5859960721E+01, 4.4589767202E+00, 9.8243170833E-01],
	[4.1580000000E+04, 5.1434505571E+01, 5.6518697047E+00, 3.5874185312E+01, 4.4593088417E+00, 9.8244013744E-01],
	[4.1585000000E+04, 5.1445426007E+01, 5.6519181672E+00, 3.5888413833E+01, 4.4596408679E+00, 9.8244856199E-01],
	[4.1590000000E+04, 5.1456347448E+01, 5.6519666243E+00, 3.5902646285E+01, 4.4599727987E+00, 9.8245698202E-01],
	[4.1595000000E+04, 5.1467269895E+01, 5.6520150759E+00, 3.5916882668E+01, 4.4603046343E+00, 9.8246539750E-01],
	[4.1600000000E+04, 5.1478193346E+01, 5.6520635222E+00, 3.5931122983E+01, 4.4606363745E+00, 9.8247380845E-01],
	[4.1605000000E+04, 5.1489117803E+01, 5.6521119630E+00, 3.5945367231E+01, 4.4609680196E+00, 9.8248221487E-01],
	[4.1610000000E+04, 5.1500043265E+01, 5.6521603985E+00, 3.5959615412E+01, 4.4612995695E+00, 9.8249061676E-01],
	[4.1615000000E+04, 5.1510969732E+01, 5.6522088285E+00, 3.5973867527E+01, 4.4616310242E+00, 9.8249901412E-01],
	[4.1620000000E+04, 5.1521897204E+01, 5.6522572531E+00, 3.5988123576E+01, 4.4619623838E+00, 9.8250740697E-01],
	[4.1625000000E+04, 5.1532825681E+01, 5.6523056724E+00, 3.6002383560E+01, 4.4622936483E+00, 9.8251579529E-01],
	[4.1630000000E+04, 5.1543755163E+01, 5.6523540862E+00, 3.6016647479E+01, 4.4626248178E+00, 9.8252417909E-01],
	[4.1635000000E+04, 5.1554685650E+01, 5.6524024946E+00, 3.6030915335E+01, 4.4629558922E+00, 9.8253255838E-01],
	[4.1640000000E+04, 5.1565617142E+01, 5.6524508977E+00, 3.6045187128E+01, 4.4632868716E+00, 9.8254093316E-01],
	[4.1645000000E+04, 5.1576549639E+01, 5.6524992953E+00, 3.6059462858E+01, 4.4636177561E+00, 9.8254930342E-01],
	[4.1650000000E+04, 5.1587483140E+01, 5.6525476875E+00, 3.6073742526E+01, 4.4639485456E+00, 9.8255766918E-01],
	[4.1655000000E+04, 5.1598417647E+01, 5.6525960744E+00, 3.6088026133E+01, 4.4642792403E+00, 9.8256603044E-01],
	[4.1660000000E+04, 5.1609353159E+01, 5.6526444558E+00, 3.6102313679E+01, 4.4646098400E+00, 9.8257438719E-01],
	[4.1665000000E+04, 5.1620289675E+01, 5.6526928319E+00, 3.6116605165E+01, 4.4649403449E+00, 9.8258273945E-01],
	[4.1670000000E+04, 5.1631227196E+01, 5.6527412025E+00, 3.6130900591E+01, 4.4652707550E+00, 9.8259108721E-01],
	[4.1675000000E+04, 5.1642165722E+01, 5.6527895678E+00, 3.6145199959E+01, 4.4656010704E+00, 9.8259943047E-01],
	[4.1680000000E+04, 5.1653105252E+01, 5.6528379277E+00, 3.6159503268E+01, 4.4659312910E+00, 9.8260776924E-01],
	[4.1685000000E+04, 5.1664045788E+01, 5.6528862822E+00, 3.6173810520E+01, 4.4662614169E+00, 9.8261610353E-01],
	[4.1690000000E+04, 5.1674987328E+01, 5.6529346313E+00, 3.6188121714E+01, 4.4665914481E+00, 9.8262443333E-01],
	[4.1695000000E+04, 5.1685929872E+01, 5.6529829750E+00, 3.6202436853E+01, 4.4669213847E+00, 9.8263275864E-01],
	[4.1700000000E+04, 5.1696873421E+01, 5.6530313134E+00, 3.6216755935E+01, 4.4672512266E+00, 9.8264107948E-01],
	[4.1705000000E+04, 5.1707817975E+01, 5.6530796463E+00, 3.6231078962E+01, 4.4675809740E+00, 9.8264939584E-01],
	[4.1710000000E+04, 5.1718763533E+01, 5.6531279739E+00, 3.6245405935E+01, 4.4679106268E+00, 9.8265770772E-01],
	[4.1715000000E+04, 5.1729710096E+01, 5.6531762961E+00, 3.6259736853E+01, 4.4682401851E+00, 9.8266601513E-01],
	[4.1720000000E+04, 5.1740657663E+01, 5.6532246129E+00, 3.6274071718E+01, 4.4685696489E+00, 9.8267431807E-01],
	[4.1725000000E+04, 5.1751606235E+01, 5.6532729244E+00, 3.6288410531E+01, 4.4688990183E+00, 9.8268261654E-01],
	[4.1730000000E+04, 5.1762555811E+01, 5.6533212304E+00, 3.6302753291E+01, 4.4692282933E+00, 9.8269091055E-01],
	[4.1735000000E+04, 5.1773506392E+01, 5.6533695311E+00, 3.6317100000E+01, 4.4695574738E+00, 9.8269920010E-01],
	[4.1740000000E+04, 5.1784457977E+01, 5.6534178265E+00, 3.6331450658E+01, 4.4698865600E+00, 9.8270748518E-01],
	[4.1745000000E+04, 5.1795410566E+01, 5.6534661164E+00, 3.6345805265E+01, 4.4702155519E+00, 9.8271576581E-01],
	[4.1750000000E+04, 5.1806364160E+01, 5.6535144010E+00, 3.6360163823E+01, 4.4705444494E+00, 9.8272404199E-01],
	[4.1755000000E+04, 5.1817318758E+01, 5.6535626802E+00, 3.6374526332E+01, 4.4708732528E+00, 9.8273231371E-01],
	[4.1760000000E+04, 5.1828274360E+01, 5.6536109540E+00, 3.6388892793E+01, 4.4712019618E+00, 9.8274058099E-01],
	[4.1765000000E+04, 5.1839230967E+01, 5.6536592225E+00, 3.6403263205E+01, 4.4715305767E+00, 9.8274884382E-01],
	[4.1770000000E+04, 5.1850188578E+01, 5.6537074856E+00, 3.6417637570E+01, 4.4718590974E+00, 9.8275710220E-01],
	[4.1775000000E+04, 5.1861147193E+01, 5.6537557433E+00, 3.6432015889E+01, 4.4721875240E+00, 9.8276535615E-01],
	[4.1780000000E+04, 5.1872106812E+01, 5.6538039957E+00, 3.6446398162E+01, 4.4725158565E+00, 9.8277360566E-01],
	[4.1785000000E+04, 5.1883067435E+01, 5.6538522427E+00, 3.6460784389E+01, 4.4728440949E+00, 9.8278185073E-01],
	[4.1790000000E+04, 5.1894029062E+01, 5.6539004844E+00, 3.6475174571E+01, 4.4731722392E+00, 9.8279009137E-01],
	[4.1795000000E+04, 5.1904991694E+01, 5.6539487207E+00, 3.6489568710E+01, 4.4735002895E+00, 9.8279832757E-01],
	[4.1800000000E+04, 5.1915955329E+01, 5.6539969516E+00, 3.6503966805E+01, 4.4738282459E+00, 9.8280655936E-01],
	[4.1805000000E+04, 5.1926919969E+01, 5.6540451772E+00, 3.6518368856E+01, 4.4741561083E+00, 9.8281478671E-01],
	[4.1810000000E+04, 5.1937885612E+01, 5.6540933974E+00, 3.6532774866E+01, 4.4744838768E+00, 9.8282300964E-01],
	[4.1815000000E+04, 5.1948852259E+01, 5.6541416123E+00, 3.6547184834E+01, 4.4748115515E+00, 9.8283122816E-01],
	[4.1820000000E+04, 5.1959819911E+01, 5.6541898218E+00, 3.6561598761E+01, 4.4751391322E+00, 9.8283944225E-01],
	[4.1825000000E+04, 5.1970788566E+01, 5.6542380259E+00, 3.6576016647E+01, 4.4754666192E+00, 9.8284765193E-01],
	[4.1830000000E+04, 5.1981781011E+01, 5.6542882388E+00, 3.6590438493E+01, 4.4757954433E+00, 9.8285585720E-01],
	[4.1835000000E+04, 5.1992774620E+01, 5.6543384599E+00, 3.6604864300E+01, 4.4761241835E+00, 9.8286405807E-01],
	[4.1840000000E+04, 5.2003769241E+01, 5.6543886753E+00, 3.6619294069E+01, 4.4764528302E+00, 9.8287225452E-01],
	[4.1845000000E+04, 5.2014764873E+01, 5.6544388853E+00, 3.6633727799E+01, 4.4767813833E+00, 9.8288044657E-01],
	[4.1850000000E+04, 5.2025761515E+01, 5.6544890896E+00, 3.6648165492E+01, 4.4771098429E+00, 9.8288863422E-01],
	[4.1855000000E+04, 5.2036759168E+01, 5.6545392884E+00, 3.6662607148E+01, 4.4774382091E+00, 9.8289681747E-01],
	[4.1860000000E+04, 5.2047757831E+01, 5.6545894817E+00, 3.6677052769E+01, 4.4777664818E+00, 9.8290499632E-01],
	[4.1865000000E+04, 5.2058757505E+01, 5.6546396694E+00, 3.6691502353E+01, 4.4780946611E+00, 9.8291317078E-01],
	[4.1870000000E+04, 5.2069758190E+01, 5.6546898516E+00, 3.6705955903E+01, 4.4784227470E+00, 9.8292134085E-01],
	[4.1875000000E+04, 5.2080759885E+01, 5.6547400282E+00, 3.6720413418E+01, 4.4787507395E+00, 9.8292950653E-01],
	[4.1880000000E+04, 5.2091762591E+01, 5.6547901993E+00, 3.6734874899E+01, 4.4790786388E+00, 9.8293766782E-01],
	[4.1885000000E+04, 5.2102766308E+01, 5.6548403648E+00, 3.6749340348E+01, 4.4794064447E+00, 9.8294582474E-01],
	[4.1890000000E+04, 5.2113771034E+01, 5.6548905248E+00, 3.6763809763E+01, 4.4797341574E+00, 9.8295397727E-01],
	[4.1895000000E+04, 5.2124776772E+01, 5.6549406792E+00, 3.6778283147E+01, 4.4800617769E+00, 9.8296212542E-01],
	[4.1900000000E+04, 5.2135783520E+01, 5.6549908281E+00, 3.6792760500E+01, 4.4803893032E+00, 9.8297026920E-01],
	[4.1905000000E+04, 5.2146791278E+01, 5.6550409715E+00, 3.6807241822E+01, 4.4807167363E+00, 9.8297840860E-01],
	[4.1910000000E+04, 5.2157800046E+01, 5.6550911093E+00, 3.6821727114E+01, 4.4810440763E+00, 9.8298654364E-01],
	[4.1915000000E+04, 5.2168809825E+01, 5.6551412416E+00, 3.6836216377E+01, 4.4813713232E+00, 9.8299467431E-01],
	[4.1920000000E+04, 5.2179820615E+01, 5.6551913683E+00, 3.6850709610E+01, 4.4816984771E+00, 9.8300280061E-01],
	[4.1925000000E+04, 5.2190832414E+01, 5.6552414896E+00, 3.6865206816E+01, 4.4820255379E+00, 9.8301092255E-01],
	[4.1930000000E+04, 5.2201845224E+01, 5.6552916052E+00, 3.6879707994E+01, 4.4823525057E+00, 9.8301904013E-01],
	[4.1935000000E+04, 5.2212859044E+01, 5.6553417154E+00, 3.6894213145E+01, 4.4826793805E+00, 9.8302715336E-01],
	[4.1940000000E+04, 5.2223873874E+01, 5.6553918200E+00, 3.6908722269E+01, 4.4830061624E+00, 9.8303526223E-01],
	[4.1945000000E+04, 5.2234889715E+01, 5.6554419191E+00, 3.6923235368E+01, 4.4833328514E+00, 9.8304336675E-01],
	[4.1950000000E+04, 5.2245906565E+01, 5.6554920127E+00, 3.6937752442E+01, 4.4836594475E+00, 9.8305146692E-01],
	[4.1955000000E+04, 5.2256924426E+01, 5.6555421007E+00, 3.6952273491E+01, 4.4839859507E+00, 9.8305956274E-01],
	[4.1960000000E+04, 5.2267943297E+01, 5.6555921832E+00, 3.6966798516E+01, 4.4843123612E+00, 9.8306765422E-01],
	[4.1965000000E+04, 5.2278963178E+01, 5.6556422602E+00, 3.6981327518E+01, 4.4846386788E+00, 9.8307574136E-01],
	[4.1970000000E+04, 5.2289984069E+01, 5.6556923317E+00, 3.6995860498E+01, 4.4849649037E+00, 9.8308382416E-01],
	[4.1975000000E+04, 5.2301005970E+01, 5.6557423976E+00, 3.7010397455E+01, 4.4852910359E+00, 9.8309190262E-01],
	[4.1980000000E+04, 5.2312028881E+01, 5.6557924580E+00, 3.7024938391E+01, 4.4856170754E+00, 9.8309997675E-01],
	[4.1985000000E+04, 5.2323052802E+01, 5.6558425129E+00, 3.7039483306E+01, 4.4859430223E+00, 9.8310804655E-01],
	[4.1990000000E+04, 5.2334077733E+01, 5.6558925623E+00, 3.7054032201E+01, 4.4862688765E+00, 9.8311611201E-01],
	[4.1995000000E+04, 5.2345103674E+01, 5.6559426062E+00, 3.7068585076E+01, 4.4865946381E+00, 9.8312417316E-01],
	[4.2000000000E+04, 5.2356130624E+01, 5.6559926446E+00, 3.7083141932E+01, 4.4869203071E+00, 9.8313222998E-01],
	[4.2005000000E+04, 5.2367158585E+01, 5.6560426774E+00, 3.7097702770E+01, 4.4872458836E+00, 9.8314028248E-01],
	[4.2010000000E+04, 5.2378187555E+01, 5.6560927047E+00, 3.7112267590E+01, 4.4875713676E+00, 9.8314833066E-01],
	[4.2015000000E+04, 5.2389217536E+01, 5.6561427265E+00, 3.7126836393E+01, 4.4878967592E+00, 9.8315637453E-01],
	[4.2020000000E+04, 5.2400248526E+01, 5.6561927429E+00, 3.7141409179E+01, 4.4882220583E+00, 9.8316441408E-01],
	[4.2025000000E+04, 5.2411280525E+01, 5.6562427537E+00, 3.7155985950E+01, 4.4885472649E+00, 9.8317244933E-01],
	[4.2030000000E+04, 5.2422313535E+01, 5.6562927589E+00, 3.7170566705E+01, 4.4888723792E+00, 9.8318048026E-01],
	[4.2035000000E+04, 5.2433347554E+01, 5.6563427587E+00, 3.7185151445E+01, 4.4891974012E+00, 9.8318850689E-01],
	[4.2040000000E+04, 5.2444382583E+01, 5.6563927530E+00, 3.7199740172E+01, 4.4895223308E+00, 9.8319652922E-01],
	[4.2045000000E+04, 5.2455418621E+01, 5.6564427418E+00, 3.7214332885E+01, 4.4898471682E+00, 9.8320454725E-01],
	[4.2050000000E+04, 5.2466455669E+01, 5.6564927251E+00, 3.7228929585E+01, 4.4901719133E+00, 9.8321256098E-01],
	[4.2055000000E+04, 5.2477493726E+01, 5.6565427028E+00, 3.7243530273E+01, 4.4904965662E+00, 9.8322057042E-01],
	[4.2060000000E+04, 5.2488532794E+01, 5.6565926751E+00, 3.7258134949E+01, 4.4908211269E+00, 9.8322857556E-01],
	[4.2065000000E+04, 5.2499572870E+01, 5.6566426419E+00, 3.7272743614E+01, 4.4911455954E+00, 9.8323657642E-01],
	[4.2070000000E+04, 5.2510613956E+01, 5.6566926031E+00, 3.7287356269E+01, 4.4914699718E+00, 9.8324457299E-01],
	[4.2075000000E+04, 5.2521656052E+01, 5.6567425589E+00, 3.7301972914E+01, 4.4917942561E+00, 9.8325256527E-01],
	[4.2080000000E+04, 5.2532699157E+01, 5.6567925092E+00, 3.7316593550E+01, 4.4921184483E+00, 9.8326055327E-01],
	[4.2085000000E+04, 5.2543743271E+01, 5.6568424540E+00, 3.7331218178E+01, 4.4924425485E+00, 9.8326853700E-01],
	[4.2090000000E+04, 5.2554788395E+01, 5.6568923933E+00, 3.7345846797E+01, 4.4927665567E+00, 9.8327651644E-01],
	[4.2095000000E+04, 5.2565834528E+01, 5.6569423271E+00, 3.7360479410E+01, 4.4930904729E+00, 9.8328449161E-01],
	[4.2100000000E+04, 5.2576881671E+01, 5.6569922554E+00, 3.7375116015E+01, 4.4934142972E+00, 9.8329246251E-01],
	[4.2105000000E+04, 5.2587929823E+01, 5.6570421782E+00, 3.7389756615E+01, 4.4937380296E+00, 9.8330042914E-01],
	[4.2110000000E+04, 5.2598978984E+01, 5.6570920956E+00, 3.7404401209E+01, 4.4940616701E+00, 9.8330839151E-01],
	[4.2115000000E+04, 5.2610029154E+01, 5.6571420074E+00, 3.7419049798E+01, 4.4943852187E+00, 9.8331634961E-01],
	[4.2120000000E+04, 5.2621080334E+01, 5.6571919138E+00, 3.7433702383E+01, 4.4947086755E+00, 9.8332430345E-01],
	[4.2125000000E+04, 5.2632132523E+01, 5.6572418147E+00, 3.7448358964E+01, 4.4950320405E+00, 9.8333225303E-01],
	[4.2130000000E+04, 5.2643185720E+01, 5.6572917101E+00, 3.7463019542E+01, 4.4953553138E+00, 9.8334019836E-01],
	[4.2135000000E+04, 5.2654239927E+01, 5.6573416000E+00, 3.7477684118E+01, 4.4956784953E+00, 9.8334813943E-01],
	[4.2140000000E+04, 5.2665295144E+01, 5.6573914844E+00, 3.7492352692E+01, 4.4960015852E+00, 9.8335607625E-01],
	[4.2145000000E+04, 5.2676351369E+01, 5.6574413634E+00, 3.7507025265E+01, 4.4963245834E+00, 9.8336400882E-01],
	[4.2150000000E+04, 5.2687408603E+01, 5.6574912369E+00, 3.7521701837E+01, 4.4966474899E+00, 9.8337193715E-01],
	[4.2155000000E+04, 5.2698466846E+01, 5.6575411049E+00, 3.7536382410E+01, 4.4969703049E+00, 9.8337986123E-01],
	[4.2160000000E+04, 5.2709526099E+01, 5.6575909674E+00, 3.7551066983E+01, 4.4972930282E+00, 9.8338778107E-01],
	[4.2165000000E+04, 5.2720586360E+01, 5.6576408245E+00, 3.7565755558E+01, 4.4976156601E+00, 9.8339569668E-01],
	[4.2170000000E+04, 5.2731647630E+01, 5.6576906761E+00, 3.7580448134E+01, 4.4979382004E+00, 9.8340360805E-01],
	[4.2175000000E+04, 5.2742709909E+01, 5.6577405222E+00, 3.7595144713E+01, 4.4982606492E+00, 9.8341151518E-01],
	[4.2180000000E+04, 5.2753773197E+01, 5.6577903628E+00, 3.7609845295E+01, 4.4985830066E+00, 9.8341941809E-01],
	[4.2185000000E+04, 5.2764837494E+01, 5.6578401980E+00, 3.7624549881E+01, 4.4989052726E+00, 9.8342731676E-01],
	[4.2190000000E+04, 5.2775902800E+01, 5.6578900277E+00, 3.7639258471E+01, 4.4992274472E+00, 9.8343521121E-01],
	[4.2195000000E+04, 5.2786969114E+01, 5.6579398520E+00, 3.7653971066E+01, 4.4995495305E+00, 9.8344310144E-01],
	[4.2200000000E+04, 5.2798036438E+01, 5.6579896707E+00, 3.7668687667E+01, 4.4998715224E+00, 9.8345098745E-01],
	[4.2205000000E+04, 5.2809104770E+01, 5.6580394841E+00, 3.7683408274E+01, 4.5001934230E+00, 9.8345886924E-01],
	[4.2210000000E+04, 5.2820174110E+01, 5.6580892919E+00, 3.7698132888E+01, 4.5005152324E+00, 9.8346674682E-01],
	[4.2215000000E+04, 5.2831244460E+01, 5.6581390943E+00, 3.7712861509E+01, 4.5008369505E+00, 9.8347462018E-01],
	[4.2220000000E+04, 5.2842315818E+01, 5.6581888912E+00, 3.7727594139E+01, 4.5011585774E+00, 9.8348248933E-01],
	[4.2225000000E+04, 5.2853388185E+01, 5.6582386827E+00, 3.7742330777E+01, 4.5014801132E+00, 9.8349035428E-01],
	[4.2230000000E+04, 5.2864461560E+01, 5.6582884687E+00, 3.7757071424E+01, 4.5018015578E+00, 9.8349821502E-01],
	[4.2235000000E+04, 5.2875535944E+01, 5.6583382493E+00, 3.7771816081E+01, 4.5021229113E+00, 9.8350607156E-01],
	[4.2240000000E+04, 5.2886611336E+01, 5.6583880244E+00, 3.7786564749E+01, 4.5024441738E+00, 9.8351392389E-01],
	[4.2245000000E+04, 5.2897687737E+01, 5.6584377940E+00, 3.7801317428E+01, 4.5027653451E+00, 9.8352177204E-01],
	[4.2250000000E+04, 5.2908765147E+01, 5.6584875582E+00, 3.7816074119E+01, 4.5030864255E+00, 9.8352961598E-01],
	[4.2255000000E+04, 5.2919843565E+01, 5.6585373170E+00, 3.7830834822E+01, 4.5034074149E+00, 9.8353745573E-01],
	[4.2260000000E+04, 5.2930922991E+01, 5.6585870703E+00, 3.7845599538E+01, 4.5037283133E+00, 9.8354529130E-01],
	[4.2265000000E+04, 5.2942003426E+01, 5.6586368181E+00, 3.7860368268E+01, 4.5040491208E+00, 9.8355312267E-01],
	[4.2270000000E+04, 5.2953084869E+01, 5.6586865605E+00, 3.7875141012E+01, 4.5043698375E+00, 9.8356094987E-01],
	[4.2275000000E+04, 5.2964167321E+01, 5.6587362975E+00, 3.7889917771E+01, 4.5046904632E+00, 9.8356877288E-01],
	[4.2280000000E+04, 5.2975250781E+01, 5.6587860290E+00, 3.7904698545E+01, 4.5050109981E+00, 9.8357659171E-01],
	[4.2285000000E+04, 5.2986335249E+01, 5.6588357550E+00, 3.7919483335E+01, 4.5053314423E+00, 9.8358440636E-01],
	[4.2290000000E+04, 5.2997420726E+01, 5.6588854756E+00, 3.7934272142E+01, 4.5056517956E+00, 9.8359221684E-01],
	[4.2295000000E+04, 5.3008507210E+01, 5.6589351908E+00, 3.7949064967E+01, 4.5059720582E+00, 9.8360002314E-01],
	[4.2300000000E+04, 5.3019594703E+01, 5.6589849006E+00, 3.7963861809E+01, 4.5062922301E+00, 9.8360782528E-01],
	[4.2305000000E+04, 5.3030683204E+01, 5.6590346049E+00, 3.7978662670E+01, 4.5066123113E+00, 9.8361562325E-01],
	[4.2310000000E+04, 5.3041772714E+01, 5.6590843037E+00, 3.7993467550E+01, 4.5069323019E+00, 9.8362341706E-01],
	[4.2315000000E+04, 5.3052863231E+01, 5.6591339971E+00, 3.8008276449E+01, 4.5072522019E+00, 9.8363120670E-01],
	[4.2320000000E+04, 5.3063954757E+01, 5.6591836851E+00, 3.8023089369E+01, 4.5075720112E+00, 9.8363899218E-01],
	[4.2325000000E+04, 5.3075047291E+01, 5.6592333677E+00, 3.8037906311E+01, 4.5078917301E+00, 9.8364677351E-01],
	[4.2330000000E+04, 5.3086140832E+01, 5.6592830448E+00, 3.8052727273E+01, 4.5082113584E+00, 9.8365455069E-01],
	[4.2335000000E+04, 5.3097235382E+01, 5.6593327165E+00, 3.8067552258E+01, 4.5085308962E+00, 9.8366232371E-01],
	[4.2340000000E+04, 5.3108330940E+01, 5.6593823828E+00, 3.8082381266E+01, 4.5088503435E+00, 9.8367009258E-01],
	[4.2345000000E+04, 5.3119427506E+01, 5.6594320436E+00, 3.8097214297E+01, 4.5091697004E+00, 9.8367785730E-01],
	[4.2350000000E+04, 5.3130525079E+01, 5.6594816990E+00, 3.8112051353E+01, 4.5094889669E+00, 9.8368561789E-01],
	[4.2355000000E+04, 5.3141623661E+01, 5.6595313490E+00, 3.8126892433E+01, 4.5098081430E+00, 9.8369337432E-01],
	[4.2360000000E+04, 5.3152723251E+01, 5.6595809935E+00, 3.8141737538E+01, 4.5101272288E+00, 9.8370112663E-01],
	[4.2365000000E+04, 5.3163823848E+01, 5.6596306327E+00, 3.8156586669E+01, 4.5104462243E+00, 9.8370887479E-01],
	[4.2370000000E+04, 5.3174925453E+01, 5.6596802664E+00, 3.8171439827E+01, 4.5107651295E+00, 9.8371661882E-01],
	[4.2375000000E+04, 5.3186028066E+01, 5.6597298947E+00, 3.8186297012E+01, 4.5110839444E+00, 9.8372435872E-01],
	[4.2380000000E+04, 5.3197131687E+01, 5.6597795175E+00, 3.8201158225E+01, 4.5114026691E+00, 9.8373209448E-01],
	[4.2385000000E+04, 5.3208236316E+01, 5.6598291350E+00, 3.8216023466E+01, 4.5117213037E+00, 9.8373982613E-01],
	[4.2390000000E+04, 5.3219341952E+01, 5.6598787470E+00, 3.8230892736E+01, 4.5120398481E+00, 9.8374755364E-01],
	[4.2395000000E+04, 5.3230448596E+01, 5.6599283536E+00, 3.8245766036E+01, 4.5123583023E+00, 9.8375527704E-01],
	[4.2400000000E+04, 5.3241556248E+01, 5.6599779548E+00, 3.8260643366E+01, 4.5126766665E+00, 9.8376299632E-01],
	[4.2405000000E+04, 5.3252664907E+01, 5.6600275506E+00, 3.8275524727E+01, 4.5129949406E+00, 9.8377071148E-01],
	[4.2410000000E+04, 5.3263774574E+01, 5.6600771409E+00, 3.8290410119E+01, 4.5133131246E+00, 9.8377842252E-01],
	[4.2415000000E+04, 5.3274885249E+01, 5.6601267259E+00, 3.8305299543E+01, 4.5136312187E+00, 9.8378612946E-01],
	[4.2420000000E+04, 5.3285996931E+01, 5.6601763054E+00, 3.8320193000E+01, 4.5139492227E+00, 9.8379383229E-01],
	[4.2425000000E+04, 5.3297109620E+01, 5.6602258796E+00, 3.8335090491E+01, 4.5142671369E+00, 9.8380153100E-01],
	[4.2430000000E+04, 5.3308223318E+01, 5.6602754483E+00, 3.8349992015E+01, 4.5145849611E+00, 9.8380922562E-01],
	[4.2435000000E+04, 5.3319338022E+01, 5.6603250116E+00, 3.8364897574E+01, 4.5149026954E+00, 9.8381691613E-01],
	[4.2440000000E+04, 5.3330453734E+01, 5.6603745696E+00, 3.8379807168E+01, 4.5152203399E+00, 9.8382460255E-01],
	[4.2445000000E+04, 5.3341570454E+01, 5.6604241221E+00, 3.8394720798E+01, 4.5155378945E+00, 9.8383228487E-01],
	[4.2450000000E+04, 5.3352688181E+01, 5.6604736692E+00, 3.8409638465E+01, 4.5158553594E+00, 9.8383996309E-01],
	[4.2455000000E+04, 5.3363806915E+01, 5.6605232109E+00, 3.8424560168E+01, 4.5161727345E+00, 9.8384763722E-01],
	[4.2460000000E+04, 5.3374926657E+01, 5.6605727472E+00, 3.8439485909E+01, 4.5164900199E+00, 9.8385530726E-01],
	[4.2465000000E+04, 5.3386047406E+01, 5.6606222781E+00, 3.8454415688E+01, 4.5168072155E+00, 9.8386297322E-01],
	[4.2470000000E+04, 5.3397169162E+01, 5.6606718036E+00, 3.8469349506E+01, 4.5171243215E+00, 9.8387063509E-01],
	[4.2475000000E+04, 5.3408291926E+01, 5.6607213237E+00, 3.8484287364E+01, 4.5174413379E+00, 9.8387829288E-01],
	[4.2480000000E+04, 5.3419415696E+01, 5.6607708384E+00, 3.8499229261E+01, 4.5177582646E+00, 9.8388594660E-01],
	[4.2485000000E+04, 5.3430540474E+01, 5.6608203477E+00, 3.8514175200E+01, 4.5180751018E+00, 9.8389359623E-01],
	[4.2490000000E+04, 5.3441666260E+01, 5.6608698517E+00, 3.8529125180E+01, 4.5183918494E+00, 9.8390124179E-01],
	[4.2495000000E+04, 5.3452793052E+01, 5.6609193502E+00, 3.8544079201E+01, 4.5187085075E+00, 9.8390888328E-01],
	[4.2500000000E+04, 5.3463928368E+01, 5.6609694937E+00, 3.8559037265E+01, 4.5190255443E+00, 9.8391652070E-01],
	[4.2505000000E+04, 5.3475080091E+01, 5.6610209637E+00, 3.8573999373E+01, 4.5193434505E+00, 9.8392415406E-01],
	[4.2510000000E+04, 5.3486232829E+01, 5.6610724282E+00, 3.8588965524E+01, 4.5196612675E+00, 9.8393178334E-01],
	[4.2515000000E+04, 5.3497386581E+01, 5.6611238871E+00, 3.8603935720E+01, 4.5199789952E+00, 9.8393940857E-01],
	[4.2520000000E+04, 5.3508541346E+01, 5.6611753404E+00, 3.8618909960E+01, 4.5202966337E+00, 9.8394702974E-01],
	[4.2525000000E+04, 5.3519697125E+01, 5.6612267882E+00, 3.8633888247E+01, 4.5206141830E+00, 9.8395464685E-01],
	[4.2530000000E+04, 5.3530853918E+01, 5.6612782303E+00, 3.8648870579E+01, 4.5209316431E+00, 9.8396225991E-01],
	[4.2535000000E+04, 5.3542011725E+01, 5.6613296669E+00, 3.8663856959E+01, 4.5212490141E+00, 9.8396986891E-01],
	[4.2540000000E+04, 5.3553170546E+01, 5.6613810979E+00, 3.8678847386E+01, 4.5215662960E+00, 9.8397747387E-01],
	[4.2545000000E+04, 5.3564330380E+01, 5.6614325233E+00, 3.8693841861E+01, 4.5218834888E+00, 9.8398507478E-01],
	[4.2550000000E+04, 5.3575491229E+01, 5.6614839432E+00, 3.8708840385E+01, 4.5222005926E+00, 9.8399267165E-01],
	[4.2555000000E+04, 5.3586653090E+01, 5.6615353574E+00, 3.8723842958E+01, 4.5225176073E+00, 9.8400026447E-01],
	[4.2560000000E+04, 5.3597815966E+01, 5.6615867661E+00, 3.8738849581E+01, 4.5228345331E+00, 9.8400785325E-01],
	[4.2565000000E+04, 5.3608979855E+01, 5.6616381692E+00, 3.8753860255E+01, 4.5231513699E+00, 9.8401543800E-01],
	[4.2570000000E+04, 5.3620144758E+01, 5.6616895668E+00, 3.8768874980E+01, 4.5234681178E+00, 9.8402301871E-01],
	[4.2575000000E+04, 5.3631310674E+01, 5.6617409588E+00, 3.8783893757E+01, 4.5237847768E+00, 9.8403059539E-01],
	[4.2580000000E+04, 5.3642477604E+01, 5.6617923452E+00, 3.8798916586E+01, 4.5241013469E+00, 9.8403816804E-01],
	[4.2585000000E+04, 5.3653645547E+01, 5.6618437260E+00, 3.8813943468E+01, 4.5244178282E+00, 9.8404573666E-01],
	[4.2590000000E+04, 5.3664814504E+01, 5.6618951013E+00, 3.8828974404E+01, 4.5247342207E+00, 9.8405330126E-01],
	[4.2595000000E+04, 5.3675984474E+01, 5.6619464710E+00, 3.8844009395E+01, 4.5250505244E+00, 9.8406086184E-01],
	[4.2600000000E+04, 5.3687155458E+01, 5.6619978352E+00, 3.8859048440E+01, 4.5253667394E+00, 9.8406841839E-01],
	[4.2605000000E+04, 5.3698327455E+01, 5.6620491937E+00, 3.8874091540E+01, 4.5256828657E+00, 9.8407597093E-01],
	[4.2610000000E+04, 5.3709500465E+01, 5.6621005468E+00, 3.8889138697E+01, 4.5259989033E+00, 9.8408351945E-01],
	[4.2615000000E+04, 5.3720674489E+01, 5.6621518942E+00, 3.8904189911E+01, 4.5263148522E+00, 9.8409106395E-01],
	[4.2620000000E+04, 5.3731849526E+01, 5.6622032361E+00, 3.8919245182E+01, 4.5266307125E+00, 9.8409860445E-01],
	[4.2625000000E+04, 5.3743025577E+01, 5.6622545725E+00, 3.8934304511E+01, 4.5269464842E+00, 9.8410614093E-01],
	[4.2630000000E+04, 5.3754202641E+01, 5.6623059033E+00, 3.8949367898E+01, 4.5272621673E+00, 9.8411367340E-01],
	[4.2635000000E+04, 5.3765380718E+01, 5.6623572285E+00, 3.8964435345E+01, 4.5275777619E+00, 9.8412120187E-01],
	[4.2640000000E+04, 5.3776559808E+01, 5.6624085482E+00, 3.8979506852E+01, 4.5278932680E+00, 9.8412872634E-01],
	[4.2645000000E+04, 5.3787739912E+01, 5.6624598623E+00, 3.8994582419E+01, 4.5282086856E+00, 9.8413624680E-01],
	[4.2650000000E+04, 5.3798921028E+01, 5.6625111709E+00, 3.9009662047E+01, 4.5285240148E+00, 9.8414376327E-01],
	[4.2655000000E+04, 5.3810103158E+01, 5.6625624739E+00, 3.9024745737E+01, 4.5288392556E+00, 9.8415127573E-01],
	[4.2660000000E+04, 5.3821286301E+01, 5.6626137714E+00, 3.9039833489E+01, 4.5291544080E+00, 9.8415878421E-01],
	[4.2665000000E+04, 5.3832470457E+01, 5.6626650634E+00, 3.9054925304E+01, 4.5294694720E+00, 9.8416628869E-01],
	[4.2670000000E+04, 5.3843655626E+01, 5.6627163497E+00, 3.9070021183E+01, 4.5297844477E+00, 9.8417378918E-01],
	[4.2675000000E+04, 5.3854841808E+01, 5.6627676306E+00, 3.9085121125E+01, 4.5300993351E+00, 9.8418128568E-01],
	[4.2680000000E+04, 5.3866029003E+01, 5.6628189059E+00, 3.9100225133E+01, 4.5304141342E+00, 9.8418877819E-01],
	[4.2685000000E+04, 5.3877217211E+01, 5.6628701756E+00, 3.9115333206E+01, 4.5307288451E+00, 9.8419626672E-01],
	[4.2690000000E+04, 5.3888406432E+01, 5.6629214399E+00, 3.9130445345E+01, 4.5310434678E+00, 9.8420375127E-01],
	[4.2695000000E+04, 5.3899596666E+01, 5.6629726985E+00, 3.9145561551E+01, 4.5313580024E+00, 9.8421123184E-01],
	[4.2700000000E+04, 5.3910787913E+01, 5.6630239517E+00, 3.9160681823E+01, 4.5316724488E+00, 9.8421870843E-01],
	[4.2705000000E+04, 5.3921980172E+01, 5.6630751993E+00, 3.9175806164E+01, 4.5319868070E+00, 9.8422618104E-01],
	[4.2710000000E+04, 5.3933173445E+01, 5.6631264413E+00, 3.9190934573E+01, 4.5323010772E+00, 9.8423364968E-01],
	[4.2715000000E+04, 5.3944367730E+01, 5.6631776779E+00, 3.9206067052E+01, 4.5326152593E+00, 9.8424111435E-01],
	[4.2720000000E+04, 5.3955563028E+01, 5.6632289089E+00, 3.9221203600E+01, 4.5329293534E+00, 9.8424857506E-01],
	[4.2725000000E+04, 5.3966759339E+01, 5.6632801343E+00, 3.9236344218E+01, 4.5332433595E+00, 9.8425603179E-01],
	[4.2730000000E+04, 5.3977956663E+01, 5.6633313543E+00, 3.9251488908E+01, 4.5335572776E+00, 9.8426348456E-01],
	[4.2735000000E+04, 5.3989154999E+01, 5.6633825687E+00, 3.9266637669E+01, 4.5338711078E+00, 9.8427093337E-01],
	[4.2740000000E+04, 5.4000354348E+01, 5.6634337775E+00, 3.9281790502E+01, 4.5341848501E+00, 9.8427837821E-01],
	[4.2745000000E+04, 5.4011554710E+01, 5.6634849809E+00, 3.9296947408E+01, 4.5344985045E+00, 9.8428581910E-01],
	[4.2750000000E+04, 5.4022756084E+01, 5.6635361787E+00, 3.9312108387E+01, 4.5348120711E+00, 9.8429325604E-01],
	[4.2755000000E+04, 5.4033958471E+01, 5.6635873710E+00, 3.9327273440E+01, 4.5351255498E+00, 9.8430068901E-01],
	[4.2760000000E+04, 5.4045161871E+01, 5.6636385578E+00, 3.9342442569E+01, 4.5354389408E+00, 9.8430811804E-01],
	[4.2765000000E+04, 5.4056366283E+01, 5.6636897390E+00, 3.9357615772E+01, 4.5357522440E+00, 9.8431554312E-01],
	[4.2770000000E+04, 5.4067571707E+01, 5.6637409147E+00, 3.9372793051E+01, 4.5360654594E+00, 9.8432296425E-01],
	[4.2775000000E+04, 5.4078778145E+01, 5.6637920849E+00, 3.9387974407E+01, 4.5363785872E+00, 9.8433038143E-01],
	[4.2780000000E+04, 5.4089985594E+01, 5.6638432496E+00, 3.9403159840E+01, 4.5366916273E+00, 9.8433779467E-01],
	[4.2785000000E+04, 5.4101194056E+01, 5.6638944088E+00, 3.9418349351E+01, 4.5370045798E+00, 9.8434520397E-01],
	[4.2790000000E+04, 5.4112403530E+01, 5.6639455625E+00, 3.9433542940E+01, 4.5373174446E+00, 9.8435260934E-01],
	[4.2795000000E+04, 5.4123614017E+01, 5.6639967106E+00, 3.9448740608E+01, 4.5376302219E+00, 9.8436001076E-01],
	[4.2800000000E+04, 5.4134825516E+01, 5.6640478532E+00, 3.9463942355E+01, 4.5379429116E+00, 9.8436740825E-01],
	[4.2805000000E+04, 5.4146038028E+01, 5.6640989903E+00, 3.9479148183E+01, 4.5382555138E+00, 9.8437480181E-01],
	[4.2810000000E+04, 5.4157251552E+01, 5.6641501219E+00, 3.9494358092E+01, 4.5385680285E+00, 9.8438219144E-01],
	[4.2815000000E+04, 5.4168466088E+01, 5.6642012480E+00, 3.9509572082E+01, 4.5388804558E+00, 9.8438957714E-01],
	[4.2820000000E+04, 5.4179681636E+01, 5.6642523686E+00, 3.9524790154E+01, 4.5391927956E+00, 9.8439695891E-01],
	[4.2825000000E+04, 5.4190898197E+01, 5.6643034837E+00, 3.9540012309E+01, 4.5395050480E+00, 9.8440433676E-01],
	[4.2830000000E+04, 5.4202115769E+01, 5.6643545933E+00, 3.9555238547E+01, 4.5398172130E+00, 9.8441171069E-01],
	[4.2835000000E+04, 5.4213334354E+01, 5.6644056973E+00, 3.9570468869E+01, 4.5401292907E+00, 9.8441908070E-01],
	[4.2840000000E+04, 5.4224553951E+01, 5.6644567959E+00, 3.9585703276E+01, 4.5404412811E+00, 9.8442644679E-01],
	[4.2845000000E+04, 5.4235774561E+01, 5.6645078889E+00, 3.9600941768E+01, 4.5407531842E+00, 9.8443380897E-01],
	[4.2850000000E+04, 5.4246996182E+01, 5.6645589765E+00, 3.9616184346E+01, 4.5410650000E+00, 9.8444116723E-01],
	[4.2855000000E+04, 5.4258218815E+01, 5.6646100586E+00, 3.9631431010E+01, 4.5413767286E+00, 9.8444852158E-01],
	[4.2860000000E+04, 5.4269442461E+01, 5.6646611351E+00, 3.9646681761E+01, 4.5416883701E+00, 9.8445587203E-01],
	[4.2865000000E+04, 5.4280667118E+01, 5.6647122062E+00, 3.9661936600E+01, 4.5419999243E+00, 9.8446321857E-01],
	[4.2870000000E+04, 5.4291892787E+01, 5.6647632717E+00, 3.9677195527E+01, 4.5423113914E+00, 9.8447056120E-01],
	[4.2875000000E+04, 5.4303119469E+01, 5.6648143318E+00, 3.9692458543E+01, 4.5426227714E+00, 9.8447789993E-01],
	[4.2880000000E+04, 5.4314347162E+01, 5.6648653864E+00, 3.9707725648E+01, 4.5429340644E+00, 9.8448523476E-01],
	[4.2885000000E+04, 5.4325575867E+01, 5.6649164355E+00, 3.9722996843E+01, 4.5432452703E+00, 9.8449256569E-01],
	[4.2890000000E+04, 5.4336805584E+01, 5.6649674791E+00, 3.9738272130E+01, 4.5435563891E+00, 9.8449989273E-01],
	[4.2895000000E+04, 5.4348036313E+01, 5.6650185172E+00, 3.9753551507E+01, 4.5438674210E+00, 9.8450721588E-01],
	[4.2900000000E+04, 5.4359268054E+01, 5.6650695498E+00, 3.9768834977E+01, 4.5441783659E+00, 9.8451453513E-01],
	[4.2905000000E+04, 5.4370500806E+01, 5.6651205769E+00, 3.9784122539E+01, 4.5444892239E+00, 9.8452185049E-01],
	[4.2910000000E+04, 5.4381734571E+01, 5.6651715985E+00, 3.9799414194E+01, 4.5447999950E+00, 9.8452916197E-01],
	[4.2915000000E+04, 5.4392969347E+01, 5.6652226147E+00, 3.9814709943E+01, 4.5451106792E+00, 9.8453646956E-01],
	[4.2920000000E+04, 5.4404205134E+01, 5.6652736253E+00, 3.9830009787E+01, 4.5454212766E+00, 9.8454377326E-01],
	[4.2925000000E+04, 5.4415441934E+01, 5.6653246305E+00, 3.9845313726E+01, 4.5457317872E+00, 9.8455107309E-01],
	[4.2930000000E+04, 5.4426679745E+01, 5.6653756302E+00, 3.9860621760E+01, 4.5460422110E+00, 9.8455836904E-01],
	[4.2935000000E+04, 5.4437918568E+01, 5.6654266244E+00, 3.9875933890E+01, 4.5463525480E+00, 9.8456566111E-01],
	[4.2940000000E+04, 5.4449158402E+01, 5.6654776132E+00, 3.9891250118E+01, 4.5466627983E+00, 9.8457294931E-01],
	[4.2945000000E+04, 5.4460399248E+01, 5.6655285964E+00, 3.9906570443E+01, 4.5469729619E+00, 9.8458023364E-01],
	[4.2950000000E+04, 5.4471641106E+01, 5.6655795742E+00, 3.9921894866E+01, 4.5472830389E+00, 9.8458751409E-01],
	[4.2955000000E+04, 5.4482883975E+01, 5.6656305465E+00, 3.9937223388E+01, 4.5475930292E+00, 9.8459479068E-01],
	[4.2960000000E+04, 5.4494127855E+01, 5.6656815134E+00, 3.9952556010E+01, 4.5479029329E+00, 9.8460206340E-01],
	[4.2965000000E+04, 5.4505372747E+01, 5.6657324747E+00, 3.9967892731E+01, 4.5482127500E+00, 9.8460933226E-01],
	[4.2970000000E+04, 5.4516618651E+01, 5.6657834306E+00, 3.9983233553E+01, 4.5485224806E+00, 9.8461659726E-01],
	[4.2975000000E+04, 5.4527865566E+01, 5.6658343811E+00, 3.9998578476E+01, 4.5488321247E+00, 9.8462385839E-01],
	[4.2980000000E+04, 5.4539113492E+01, 5.6658853260E+00, 4.0013927502E+01, 4.5491416823E+00, 9.8463111567E-01],
	[4.2985000000E+04, 5.4550362429E+01, 5.6659362655E+00, 4.0029280629E+01, 4.5494511534E+00, 9.8463836910E-01],
	[4.2990000000E+04, 5.4561612378E+01, 5.6659871995E+00, 4.0044637860E+01, 4.5497605381E+00, 9.8464561867E-01],
	[4.2995000000E+04, 5.4572863339E+01, 5.6660381281E+00, 4.0059999194E+01, 4.5500698364E+00, 9.8465286439E-01],
	[4.3000000000E+04, 5.4584115310E+01, 5.6660890511E+00, 4.0075364633E+01, 4.5503790483E+00, 9.8466010627E-01],
	[4.3005000000E+04, 5.4595368293E+01, 5.6661399688E+00, 4.0090734177E+01, 4.5506881739E+00, 9.8466734429E-01],
	[4.3010000000E+04, 5.4606622287E+01, 5.6661908809E+00, 4.0106107826E+01, 4.5509972131E+00, 9.8467457847E-01],
	[4.3015000000E+04, 5.4617877293E+01, 5.6662417876E+00, 4.0121485582E+01, 4.5513061661E+00, 9.8468180881E-01],
	[4.3020000000E+04, 5.4629133309E+01, 5.6662926889E+00, 4.0136867444E+01, 4.5516150328E+00, 9.8468903531E-01],
	[4.3025000000E+04, 5.4640390337E+01, 5.6663435846E+00, 4.0152253414E+01, 4.5519238134E+00, 9.8469625798E-01],
	[4.3030000000E+04, 5.4651648376E+01, 5.6663944750E+00, 4.0167643492E+01, 4.5522325077E+00, 9.8470347680E-01],
	[4.3035000000E+04, 5.4662907425E+01, 5.6664453598E+00, 4.0183037678E+01, 4.5525411158E+00, 9.8471069180E-01],
	[4.3040000000E+04, 5.4674167486E+01, 5.6664962392E+00, 4.0198435974E+01, 4.5528496378E+00, 9.8471790296E-01],
	[4.3045000000E+04, 5.4685428558E+01, 5.6665471132E+00, 4.0213838380E+01, 4.5531580737E+00, 9.8472511029E-01],
	[4.3050000000E+04, 5.4696690641E+01, 5.6665979817E+00, 4.0229244896E+01, 4.5534664235E+00, 9.8473231379E-01],
	[4.3055000000E+04, 5.4707953735E+01, 5.6666488448E+00, 4.0244655523E+01, 4.5537746873E+00, 9.8473951347E-01],
	[4.3060000000E+04, 5.4719217840E+01, 5.6666997024E+00, 4.0260070262E+01, 4.5540828651E+00, 9.8474670933E-01],
	[4.3065000000E+04, 5.4730482956E+01, 5.6667505545E+00, 4.0275489114E+01, 4.5543909568E+00, 9.8475390137E-01],
	[4.3070000000E+04, 5.4741749083E+01, 5.6668014012E+00, 4.0290912078E+01, 4.5546989626E+00, 9.8476108958E-01],
	[4.3075000000E+04, 5.4753016221E+01, 5.6668522425E+00, 4.0306339157E+01, 4.5550068825E+00, 9.8476827398E-01],
	[4.3080000000E+04, 5.4764284370E+01, 5.6669030783E+00, 4.0321770349E+01, 4.5553147164E+00, 9.8477545457E-01],
	[4.3085000000E+04, 5.4775553529E+01, 5.6669539087E+00, 4.0337205656E+01, 4.5556224645E+00, 9.8478263134E-01],
	[4.3090000000E+04, 5.4786823699E+01, 5.6670047336E+00, 4.0352645079E+01, 4.5559301268E+00, 9.8478980431E-01],
	[4.3095000000E+04, 5.4798094880E+01, 5.6670555531E+00, 4.0368088618E+01, 4.5562377032E+00, 9.8479697346E-01],
	[4.3100000000E+04, 5.4809367072E+01, 5.6671063672E+00, 4.0383536273E+01, 4.5565451938E+00, 9.8480413881E-01],
	[4.3105000000E+04, 5.4820640275E+01, 5.6671571758E+00, 4.0398988046E+01, 4.5568525987E+00, 9.8481130036E-01],
	[4.3110000000E+04, 5.4831914488E+01, 5.6672079790E+00, 4.0414443937E+01, 4.5571599179E+00, 9.8481845810E-01],
	[4.3115000000E+04, 5.4843189712E+01, 5.6672587767E+00, 4.0429903946E+01, 4.5574671513E+00, 9.8482561205E-01],
	[4.3120000000E+04, 5.4854465946E+01, 5.6673095690E+00, 4.0445368075E+01, 4.5577742991E+00, 9.8483276220E-01],
	[4.3125000000E+04, 5.4865743191E+01, 5.6673603559E+00, 4.0460836323E+01, 4.5580813613E+00, 9.8483990855E-01],
	[4.3130000000E+04, 5.4877021447E+01, 5.6674111373E+00, 4.0476308692E+01, 4.5583883378E+00, 9.8484705111E-01],
	[4.3135000000E+04, 5.4888300713E+01, 5.6674619133E+00, 4.0491785182E+01, 4.5586952288E+00, 9.8485418987E-01],
	[4.3140000000E+04, 5.4899580990E+01, 5.6675126839E+00, 4.0507265794E+01, 4.5590020342E+00, 9.8486132485E-01],
	[4.3145000000E+04, 5.4910862278E+01, 5.6675634490E+00, 4.0522750528E+01, 4.5593087540E+00, 9.8486845605E-01],
	[4.3150000000E+04, 5.4922144576E+01, 5.6676142087E+00, 4.0538239385E+01, 4.5596153884E+00, 9.8487558345E-01],
	[4.3155000000E+04, 5.4933427884E+01, 5.6676649630E+00, 4.0553732365E+01, 4.5599219373E+00, 9.8488270708E-01],
	[4.3160000000E+04, 5.4944712203E+01, 5.6677157119E+00, 4.0569229469E+01, 4.5602284008E+00, 9.8488982693E-01],
	[4.3165000000E+04, 5.4955997532E+01, 5.6677664553E+00, 4.0584730699E+01, 4.5605347789E+00, 9.8489694299E-01],
	[4.3170000000E+04, 5.4967283871E+01, 5.6678171933E+00, 4.0600236053E+01, 4.5608410716E+00, 9.8490405528E-01],
	[4.3175000000E+04, 5.4978571221E+01, 5.6678679259E+00, 4.0615745534E+01, 4.5611472789E+00, 9.8491116380E-01],
	[4.3180000000E+04, 5.4989859582E+01, 5.6679186531E+00, 4.0631259141E+01, 4.5614534009E+00, 9.8491826855E-01],
	[4.3185000000E+04, 5.5001160278E+01, 5.6679703339E+00, 4.0646776876E+01, 4.5617601368E+00, 9.8492536952E-01],
	[4.3190000000E+04, 5.5012473549E+01, 5.6680229882E+00, 4.0662298738E+01, 4.5620675012E+00, 9.8493246673E-01],
	[4.3195000000E+04, 5.5023787838E+01, 5.6680756368E+00, 4.0677824729E+01, 4.5623747804E+00, 9.8493956017E-01],
	[4.3200000000E+04, 5.5035103143E+01, 5.6681282798E+00, 4.0693354849E+01, 4.5626819746E+00, 9.8494664985E-01],
	[4.3205000000E+04, 5.5046419465E+01, 5.6681809172E+00, 4.0708889099E+01, 4.5629890837E+00, 9.8495373577E-01],
	[4.3210000000E+04, 5.5057736804E+01, 5.6682335490E+00, 4.0724427479E+01, 4.5632961078E+00, 9.8496081793E-01],
	[4.3215000000E+04, 5.5069055160E+01, 5.6682861752E+00, 4.0739969990E+01, 4.5636030469E+00, 9.8496789633E-01],
	[4.3220000000E+04, 5.5080374533E+01, 5.6683387958E+00, 4.0755516632E+01, 4.5639099010E+00, 9.8497497097E-01],
	[4.3225000000E+04, 5.5091694923E+01, 5.6683914108E+00, 4.0771067407E+01, 4.5642166702E+00, 9.8498204187E-01],
	[4.3230000000E+04, 5.5103016329E+01, 5.6684440202E+00, 4.0786622315E+01, 4.5645233546E+00, 9.8498910901E-01],
	[4.3235000000E+04, 5.5114338753E+01, 5.6684966240E+00, 4.0802181356E+01, 4.5648299540E+00, 9.8499617240E-01],
	[4.3240000000E+04, 5.5125662193E+01, 5.6685492222E+00, 4.0817744531E+01, 4.5651364686E+00, 9.8500323205E-01],
	[4.3245000000E+04, 5.5136986650E+01, 5.6686018148E+00, 4.0833311841E+01, 4.5654428983E+00, 9.8501028796E-01],
	[4.3250000000E+04, 5.5148312123E+01, 5.6686544019E+00, 4.0848883286E+01, 4.5657492433E+00, 9.8501734012E-01],
	[4.3255000000E+04, 5.5159638614E+01, 5.6687069833E+00, 4.0864458867E+01, 4.5660555035E+00, 9.8502438854E-01],
	[4.3260000000E+04, 5.5170966121E+01, 5.6687595591E+00, 4.0880038585E+01, 4.5663616790E+00, 9.8503143322E-01],
	[4.3265000000E+04, 5.5182294644E+01, 5.6688121294E+00, 4.0895622440E+01, 4.5666677698E+00, 9.8503847417E-01],
	[4.3270000000E+04, 5.5193624185E+01, 5.6688646941E+00, 4.0911210432E+01, 4.5669737759E+00, 9.8504551139E-01],
	[4.3275000000E+04, 5.5204954741E+01, 5.6689172531E+00, 4.0926802563E+01, 4.5672796974E+00, 9.8505254487E-01],
	[4.3280000000E+04, 5.5216286315E+01, 5.6689698066E+00, 4.0942398833E+01, 4.5675855342E+00, 9.8505957462E-01],
	[4.3285000000E+04, 5.5227618905E+01, 5.6690223545E+00, 4.0957999243E+01, 4.5678912865E+00, 9.8506660065E-01],
	[4.3290000000E+04, 5.5238952511E+01, 5.6690748969E+00, 4.0973603793E+01, 4.5681969542E+00, 9.8507362295E-01],
	[4.3295000000E+04, 5.5250287134E+01, 5.6691274336E+00, 4.0989212483E+01, 4.5685025374E+00, 9.8508064153E-01],
	[4.3300000000E+04, 5.5261622773E+01, 5.6691799648E+00, 4.1004825316E+01, 4.5688080360E+00, 9.8508765638E-01],
	[4.3305000000E+04, 5.5272959429E+01, 5.6692324904E+00, 4.1020442290E+01, 4.5691134502E+00, 9.8509466752E-01],
	[4.3310000000E+04, 5.5284297101E+01, 5.6692850104E+00, 4.1036063407E+01, 4.5694187800E+00, 9.8510167494E-01],
	[4.3315000000E+04, 5.5295635790E+01, 5.6693375248E+00, 4.1051688668E+01, 4.5697240253E+00, 9.8510867865E-01],
	[4.3320000000E+04, 5.5306975495E+01, 5.6693900337E+00, 4.1067318072E+01, 4.5700291863E+00, 9.8511567864E-01],
	[4.3325000000E+04, 5.5318316216E+01, 5.6694425370E+00, 4.1082951621E+01, 4.5703342628E+00, 9.8512267492E-01],
	[4.3330000000E+04, 5.5329657953E+01, 5.6694950347E+00, 4.1098589316E+01, 4.5706392551E+00, 9.8512966750E-01],
	[4.3335000000E+04, 5.5341000707E+01, 5.6695475268E+00, 4.1114231156E+01, 4.5709441631E+00, 9.8513665636E-01],
	[4.3340000000E+04, 5.5352344477E+01, 5.6696000134E+00, 4.1129877143E+01, 4.5712489867E+00, 9.8514364153E-01],
	[4.3345000000E+04, 5.5363689263E+01, 5.6696524944E+00, 4.1145527276E+01, 4.5715537262E+00, 9.8515062299E-01],
	[4.3350000000E+04, 5.5375035066E+01, 5.6697049698E+00, 4.1161181558E+01, 4.5718583814E+00, 9.8515760075E-01],
	[4.3355000000E+04, 5.5386381884E+01, 5.6697574397E+00, 4.1176839988E+01, 4.5721629524E+00, 9.8516457482E-01],
	[4.3360000000E+04, 5.5397729719E+01, 5.6698099040E+00, 4.1192502566E+01, 4.5724674393E+00, 9.8517154518E-01],
	[4.3365000000E+04, 5.5409078570E+01, 5.6698623627E+00, 4.1208169295E+01, 4.5727718421E+00, 9.8517851186E-01],
	[4.3370000000E+04, 5.5420428437E+01, 5.6699148159E+00, 4.1223840173E+01, 4.5730761607E+00, 9.8518547484E-01],
	[4.3375000000E+04, 5.5431779320E+01, 5.6699672635E+00, 4.1239515202E+01, 4.5733803953E+00, 9.8519243414E-01],
	[4.3380000000E+04, 5.5443131219E+01, 5.6700197056E+00, 4.1255194383E+01, 4.5736845458E+00, 9.8519938974E-01],
	[4.3385000000E+04, 5.5454484134E+01, 5.6700721421E+00, 4.1270877716E+01, 4.5739886123E+00, 9.8520634166E-01],
	[4.3390000000E+04, 5.5465838065E+01, 5.6701245730E+00, 4.1286565201E+01, 4.5742925948E+00, 9.8521328990E-01],
	[4.3395000000E+04, 5.5477193012E+01, 5.6701769984E+00, 4.1302256840E+01, 4.5745964934E+00, 9.8522023446E-01],
	[4.3400000000E+04, 5.5488548975E+01, 5.6702294182E+00, 4.1317952632E+01, 4.5749003080E+00, 9.8522717534E-01],
	[4.3405000000E+04, 5.5499905954E+01, 5.6702818325E+00, 4.1333652580E+01, 4.5752040388E+00, 9.8523411254E-01],
	[4.3410000000E+04, 5.5511263948E+01, 5.6703342412E+00, 4.1349356682E+01, 4.5755076856E+00, 9.8524104606E-01],
	[4.3415000000E+04, 5.5522622959E+01, 5.6703866444E+00, 4.1365064940E+01, 4.5758112487E+00, 9.8524797592E-01],
	[4.3420000000E+04, 5.5533982985E+01, 5.6704390420E+00, 4.1380777354E+01, 4.5761147279E+00, 9.8525490210E-01],
	[4.3425000000E+04, 5.5545344027E+01, 5.6704914340E+00, 4.1396493926E+01, 4.5764181233E+00, 9.8526182461E-01],
	[4.3430000000E+04, 5.5556706085E+01, 5.6705438206E+00, 4.1412214655E+01, 4.5767214349E+00, 9.8526874346E-01],
	[4.3435000000E+04, 5.5568069159E+01, 5.6705962015E+00, 4.1427939542E+01, 4.5770246628E+00, 9.8527565865E-01],
	[4.3440000000E+04, 5.5579433248E+01, 5.6706485770E+00, 4.1443668588E+01, 4.5773278070E+00, 9.8528257017E-01],
	[4.3445000000E+04, 5.5590798354E+01, 5.6707009468E+00, 4.1459401794E+01, 4.5776308676E+00, 9.8528947803E-01],
	[4.3450000000E+04, 5.5602164474E+01, 5.6707533112E+00, 4.1475139160E+01, 4.5779338445E+00, 9.8529638223E-01],
	[4.3455000000E+04, 5.5613531611E+01, 5.6708056700E+00, 4.1490880686E+01, 4.5782367378E+00, 9.8530328278E-01],
	[4.3460000000E+04, 5.5624899763E+01, 5.6708580232E+00, 4.1506626374E+01, 4.5785395474E+00, 9.8531017968E-01],
	[4.3465000000E+04, 5.5636268930E+01, 5.6709103709E+00, 4.1522376224E+01, 4.5788422736E+00, 9.8531707292E-01],
	[4.3470000000E+04, 5.5647639114E+01, 5.6709627131E+00, 4.1538130237E+01, 4.5791449162E+00, 9.8532396251E-01],
	[4.3475000000E+04, 5.5659010312E+01, 5.6710150497E+00, 4.1553888412E+01, 4.5794474753E+00, 9.8533084846E-01],
	[4.3480000000E+04, 5.5670382527E+01, 5.6710673809E+00, 4.1569650752E+01, 4.5797499509E+00, 9.8533773076E-01],
	[4.3485000000E+04, 5.5681755756E+01, 5.6711197064E+00, 4.1585417256E+01, 4.5800523430E+00, 9.8534460941E-01],
	[4.3490000000E+04, 5.5693130001E+01, 5.6711720265E+00, 4.1601187925E+01, 4.5803546518E+00, 9.8535148443E-01],
	[4.3495000000E+04, 5.5704505262E+01, 5.6712243410E+00, 4.1616962760E+01, 4.5806568771E+00, 9.8535835581E-01],
	[4.3500000000E+04, 5.5715881538E+01, 5.6712766499E+00, 4.1632741761E+01, 4.5809590191E+00, 9.8536522355E-01],
	[4.3505000000E+04, 5.5727258829E+01, 5.6713289534E+00, 4.1648524929E+01, 4.5812610778E+00, 9.8537208765E-01],
	[4.3510000000E+04, 5.5738637136E+01, 5.6713812513E+00, 4.1664312265E+01, 4.5815630531E+00, 9.8537894812E-01],
	[4.3515000000E+04, 5.5750016458E+01, 5.6714335437E+00, 4.1680103768E+01, 4.5818649452E+00, 9.8538580496E-01],
	[4.3520000000E+04, 5.5761396796E+01, 5.6714858305E+00, 4.1695899441E+01, 4.5821667541E+00, 9.8539265817E-01],
	[4.3525000000E+04, 5.5772778148E+01, 5.6715381119E+00, 4.1711699283E+01, 4.5824684797E+00, 9.8539950776E-01],
	[4.3530000000E+04, 5.5784160516E+01, 5.6715903877E+00, 4.1727503295E+01, 4.5827701221E+00, 9.8540635372E-01],
	[4.3535000000E+04, 5.5795543899E+01, 5.6716426580E+00, 4.1743311478E+01, 4.5830716813E+00, 9.8541319606E-01],
	[4.3540000000E+04, 5.5806928298E+01, 5.6716949227E+00, 4.1759123832E+01, 4.5833731574E+00, 9.8542003478E-01],
	[4.3545000000E+04, 5.5818313711E+01, 5.6717471820E+00, 4.1774940358E+01, 4.5836745504E+00, 9.8542686988E-01],
	[4.3550000000E+04, 5.5829700140E+01, 5.6717994357E+00, 4.1790761056E+01, 4.5839758604E+00, 9.8543370136E-01],
	[4.3555000000E+04, 5.5841087584E+01, 5.6718516839E+00, 4.1806585928E+01, 4.5842770872E+00, 9.8544052923E-01],
	[4.3560000000E+04, 5.5852476043E+01, 5.6719039266E+00, 4.1822414973E+01, 4.5845782311E+00, 9.8544735349E-01],
	[4.3565000000E+04, 5.5863865517E+01, 5.6719561638E+00, 4.1838248193E+01, 4.5848792919E+00, 9.8545417413E-01],
	[4.3570000000E+04, 5.5875256006E+01, 5.6720083955E+00, 4.1854085588E+01, 4.5851802698E+00, 9.8546099117E-01],
	[4.3575000000E+04, 5.5886647510E+01, 5.6720606216E+00, 4.1869927159E+01, 4.5854811648E+00, 9.8546780460E-01],
	[4.3580000000E+04, 5.5898040029E+01, 5.6721128422E+00, 4.1885772905E+01, 4.5857819768E+00, 9.8547461443E-01],
	[4.3585000000E+04, 5.5909433563E+01, 5.6721650574E+00, 4.1901622829E+01, 4.5860827060E+00, 9.8548142066E-01],
	[4.3590000000E+04, 5.5920828111E+01, 5.6722172670E+00, 4.1917476930E+01, 4.5863833523E+00, 9.8548822329E-01],
	[4.3595000000E+04, 5.5932223675E+01, 5.6722694711E+00, 4.1933335209E+01, 4.5866839157E+00, 9.8549502232E-01],
	[4.3600000000E+04, 5.5943620254E+01, 5.6723216697E+00, 4.1949197667E+01, 4.5869843964E+00, 9.8550181776E-01],
	[4.3605000000E+04, 5.5955017847E+01, 5.6723738628E+00, 4.1965064305E+01, 4.5872847943E+00, 9.8550860960E-01],
	[4.3610000000E+04, 5.5966416456E+01, 5.6724260504E+00, 4.1980935122E+01, 4.5875851095E+00, 9.8551539785E-01],
	[4.3615000000E+04, 5.5977816079E+01, 5.6724782325E+00, 4.1996810120E+01, 4.5878853419E+00, 9.8552218251E-01],
	[4.3620000000E+04, 5.5989216717E+01, 5.6725304091E+00, 4.2012689299E+01, 4.5881854917E+00, 9.8552896359E-01],
	[4.3625000000E+04, 5.6000618370E+01, 5.6725825802E+00, 4.2028572660E+01, 4.5884855588E+00, 9.8553574108E-01],
	[4.3630000000E+04, 5.6012021037E+01, 5.6726347458E+00, 4.2044460203E+01, 4.5887855433E+00, 9.8554251498E-01],
	[4.3635000000E+04, 5.6023424719E+01, 5.6726869059E+00, 4.2060351930E+01, 4.5890854452E+00, 9.8554928531E-01],
	[4.3640000000E+04, 5.6034829416E+01, 5.6727390605E+00, 4.2076247840E+01, 4.5893852645E+00, 9.8555605205E-01],
	[4.3645000000E+04, 5.6046235128E+01, 5.6727912096E+00, 4.2092147935E+01, 4.5896850012E+00, 9.8556281522E-01],
	[4.3650000000E+04, 5.6057641854E+01, 5.6728433532E+00, 4.2108052215E+01, 4.5899846555E+00, 9.8556957482E-01],
	[4.3655000000E+04, 5.6069049595E+01, 5.6728954913E+00, 4.2123960680E+01, 4.5902842272E+00, 9.8557633084E-01],
	[4.3660000000E+04, 5.6080458350E+01, 5.6729476239E+00, 4.2139873331E+01, 4.5905837165E+00, 9.8558308329E-01],
	[4.3665000000E+04, 5.6091868120E+01, 5.6729997511E+00, 4.2155790169E+01, 4.5908831234E+00, 9.8558983218E-01],
	[4.3670000000E+04, 5.6103278904E+01, 5.6730518727E+00, 4.2171711195E+01, 4.5911824478E+00, 9.8559657749E-01],
	[4.3675000000E+04, 5.6114690703E+01, 5.6731039888E+00, 4.2187636409E+01, 4.5914816899E+00, 9.8560331924E-01],
	[4.3680000000E+04, 5.6126103516E+01, 5.6731560995E+00, 4.2203565811E+01, 4.5917808496E+00, 9.8561005743E-01],
	[4.3685000000E+04, 5.6137517344E+01, 5.6732082047E+00, 4.2219499403E+01, 4.5920799270E+00, 9.8561679206E-01],
	[4.3690000000E+04, 5.6148932186E+01, 5.6732603044E+00, 4.2235437184E+01, 4.5923789222E+00, 9.8562352314E-01],
	[4.3695000000E+04, 5.6160348043E+01, 5.6733123986E+00, 4.2251379156E+01, 4.5926778350E+00, 9.8563025065E-01],
	[4.3700000000E+04, 5.6171764914E+01, 5.6733644873E+00, 4.2267325320E+01, 4.5929766656E+00, 9.8563697461E-01],
	[4.3705000000E+04, 5.6183182799E+01, 5.6734165706E+00, 4.2283275675E+01, 4.5932754140E+00, 9.8564369502E-01],
	[4.3710000000E+04, 5.6194601699E+01, 5.6734686483E+00, 4.2299230223E+01, 4.5935740802E+00, 9.8565041188E-01],
	[4.3715000000E+04, 5.6206021613E+01, 5.6735207206E+00, 4.2315188963E+01, 4.5938726643E+00, 9.8565712519E-01],
	[4.3720000000E+04, 5.6217442541E+01, 5.6735727874E+00, 4.2331151897E+01, 4.5941711663E+00, 9.8566383496E-01],
	[4.3725000000E+04, 5.6228864483E+01, 5.6736248488E+00, 4.2347119026E+01, 4.5944695861E+00, 9.8567054118E-01],
	[4.3730000000E+04, 5.6240287440E+01, 5.6736769046E+00, 4.2363090349E+01, 4.5947679239E+00, 9.8567724386E-01],
	[4.3735000000E+04, 5.6251711411E+01, 5.6737289550E+00, 4.2379065868E+01, 4.5950661796E+00, 9.8568394300E-01],
	[4.3740000000E+04, 5.6263136396E+01, 5.6737809999E+00, 4.2395045584E+01, 4.5953643533E+00, 9.8569063860E-01],
	[4.3745000000E+04, 5.6274562395E+01, 5.6738330394E+00, 4.2411029495E+01, 4.5956624451E+00, 9.8569733067E-01],
	[4.3750000000E+04, 5.6285989408E+01, 5.6738850733E+00, 4.2427017605E+01, 4.5959604549E+00, 9.8570401920E-01],
	[4.3755000000E+04, 5.6297417435E+01, 5.6739371018E+00, 4.2443009912E+01, 4.5962583827E+00, 9.8571070421E-01],
	[4.3760000000E+04, 5.6308846477E+01, 5.6739891249E+00, 4.2459006418E+01, 4.5965562287E+00, 9.8571738568E-01],
	[4.3765000000E+04, 5.6320276532E+01, 5.6740411424E+00, 4.2475007123E+01, 4.5968539927E+00, 9.8572406363E-01],
	[4.3770000000E+04, 5.6331707602E+01, 5.6740931545E+00, 4.2491012028E+01, 4.5971516750E+00, 9.8573073805E-01],
	[4.3775000000E+04, 5.6343139685E+01, 5.6741451611E+00, 4.2507021134E+01, 4.5974492754E+00, 9.8573740894E-01],
	[4.3780000000E+04, 5.6354572782E+01, 5.6741971623E+00, 4.2523034441E+01, 4.5977467940E+00, 9.8574407632E-01],
	[4.3785000000E+04, 5.6366006893E+01, 5.6742491580E+00, 4.2539051949E+01, 4.5980442308E+00, 9.8575074018E-01],
	[4.3790000000E+04, 5.6377442019E+01, 5.6743011483E+00, 4.2555073660E+01, 4.5983415860E+00, 9.8575740052E-01],
	[4.3795000000E+04, 5.6388878158E+01, 5.6743531331E+00, 4.2571099574E+01, 4.5986388594E+00, 9.8576405734E-01],
	[4.3800000000E+04, 5.6400315310E+01, 5.6744051124E+00, 4.2587129691E+01, 4.5989360511E+00, 9.8577071065E-01],
	[4.3805000000E+04, 5.6411753477E+01, 5.6744570863E+00, 4.2603164013E+01, 4.5992331612E+00, 9.8577736045E-01],
	[4.3810000000E+04, 5.6423192658E+01, 5.6745090547E+00, 4.2619202539E+01, 4.5995301896E+00, 9.8578400674E-01],
	[4.3815000000E+04, 5.6434632852E+01, 5.6745610176E+00, 4.2635245271E+01, 4.5998271365E+00, 9.8579064953E-01],
	[4.3820000000E+04, 5.6446074060E+01, 5.6746129751E+00, 4.2651292210E+01, 4.6001240018E+00, 9.8579728881E-01],
	[4.3825000000E+04, 5.6457516282E+01, 5.6746649272E+00, 4.2667343354E+01, 4.6004207856E+00, 9.8580392459E-01],
	[4.3830000000E+04, 5.6468959517E+01, 5.6747168738E+00, 4.2683398707E+01, 4.6007174878E+00, 9.8581055686E-01],
	[4.3835000000E+04, 5.6480403766E+01, 5.6747688150E+00, 4.2699458267E+01, 4.6010141085E+00, 9.8581718564E-01],
	[4.3840000000E+04, 5.6491849029E+01, 5.6748207507E+00, 4.2715522035E+01, 4.6013106478E+00, 9.8582381092E-01],
	[4.3845000000E+04, 5.6503295305E+01, 5.6748726809E+00, 4.2731590013E+01, 4.6016071057E+00, 9.8583043271E-01],
	[4.3850000000E+04, 5.6514742595E+01, 5.6749246057E+00, 4.2747662201E+01, 4.6019034822E+00, 9.8583705100E-01],
	[4.3855000000E+04, 5.6526190898E+01, 5.6749765251E+00, 4.2763738599E+01, 4.6021997773E+00, 9.8584366581E-01],
	[4.3860000000E+04, 5.6537640216E+01, 5.6750284390E+00, 4.2779819209E+01, 4.6024959910E+00, 9.8585027712E-01],
	[4.3865000000E+04, 5.6549090546E+01, 5.6750803475E+00, 4.2795904030E+01, 4.6027921234E+00, 9.8585688495E-01],
	[4.3870000000E+04, 5.6560541890E+01, 5.6751322505E+00, 4.2811993063E+01, 4.6030881746E+00, 9.8586348930E-01],
	[4.3875000000E+04, 5.6571994248E+01, 5.6751841481E+00, 4.2828086309E+01, 4.6033841445E+00, 9.8587009016E-01],
	[4.3880000000E+04, 5.6583458107E+01, 5.6752369097E+00, 4.2844183769E+01, 4.6036806746E+00, 9.8587668754E-01],
	[4.3885000000E+04, 5.6594935350E+01, 5.6752906909E+00, 4.2860285443E+01, 4.6039778801E+00, 9.8588328144E-01],
	[4.3890000000E+04, 5.6606413614E+01, 5.6753444665E+00, 4.2876391332E+01, 4.6042750045E+00, 9.8588987187E-01],
	[4.3895000000E+04, 5.6617892898E+01, 5.6753982364E+00, 4.2892501437E+01, 4.6045720479E+00, 9.8589645882E-01],
	[4.3900000000E+04, 5.6629373202E+01, 5.6754520007E+00, 4.2908615757E+01, 4.6048690103E+00, 9.8590304231E-01],
	[4.3905000000E+04, 5.6640854525E+01, 5.6755057594E+00, 4.2924734294E+01, 4.6051658917E+00, 9.8590962232E-01],
	[4.3910000000E+04, 5.6652336869E+01, 5.6755595125E+00, 4.2940857048E+01, 4.6054626921E+00, 9.8591619886E-01],
	[4.3915000000E+04, 5.6663820233E+01, 5.6756132600E+00, 4.2956984021E+01, 4.6057594116E+00, 9.8592277194E-01],
	[4.3920000000E+04, 5.6675304616E+01, 5.6756670019E+00, 4.2973115212E+01, 4.6060560503E+00, 9.8592934155E-01],
	[4.3925000000E+04, 5.6686790019E+01, 5.6757207382E+00, 4.2989250622E+01, 4.6063526080E+00, 9.8593590770E-01],
	[4.3930000000E+04, 5.6698276442E+01, 5.6757744688E+00, 4.3005390251E+01, 4.6066490849E+00, 9.8594247039E-01],
	[4.3935000000E+04, 5.6709763885E+01, 5.6758281939E+00, 4.3021534102E+01, 4.6069454810E+00, 9.8594902962E-01],
	[4.3940000000E+04, 5.6721252348E+01, 5.6758819133E+00, 4.3037682173E+01, 4.6072417963E+00, 9.8595558540E-01],
	[4.3945000000E+04, 5.6732741831E+01, 5.6759356271E+00, 4.3053834466E+01, 4.6075380308E+00, 9.8596213772E-01],
	[4.3950000000E+04, 5.6744232333E+01, 5.6759893354E+00, 4.3069990981E+01, 4.6078341846E+00, 9.8596868659E-01],
	[4.3955000000E+04, 5.6755723855E+01, 5.6760430380E+00, 4.3086151719E+01, 4.6081302577E+00, 9.8597523201E-01],
	[4.3960000000E+04, 5.6767216396E+01, 5.6760967351E+00, 4.3102316681E+01, 4.6084262501E+00, 9.8598177399E-01],
	[4.3965000000E+04, 5.6778709958E+01, 5.6761504265E+00, 4.3118485867E+01, 4.6087221618E+00, 9.8598831251E-01],
	[4.3970000000E+04, 5.6790204539E+01, 5.6762041123E+00, 4.3134659277E+01, 4.6090179929E+00, 9.8599484760E-01],
	[4.3975000000E+04, 5.6801700139E+01, 5.6762577926E+00, 4.3150836913E+01, 4.6093137435E+00, 9.8600137924E-01],
	[4.3980000000E+04, 5.6813196759E+01, 5.6763114672E+00, 4.3167018775E+01, 4.6096094134E+00, 9.8600790744E-01],
	[4.3985000000E+04, 5.6824694399E+01, 5.6763651363E+00, 4.3183204864E+01, 4.6099050028E+00, 9.8601443220E-01],
	[4.3990000000E+04, 5.6836193058E+01, 5.6764187997E+00, 4.3199395180E+01, 4.6102005117E+00, 9.8602095353E-01],
	[4.3995000000E+04, 5.6847692737E+01, 5.6764724576E+00, 4.3215589724E+01, 4.6104959402E+00, 9.8602747143E-01],
	[4.4000000000E+04, 5.6859193435E+01, 5.6765261099E+00, 4.3231788496E+01, 4.6107912881E+00, 9.8603398589E-01],
	[4.4005000000E+04, 5.6870695153E+01, 5.6765797566E+00, 4.3247991498E+01, 4.6110865556E+00, 9.8604049692E-01],
	[4.4010000000E+04, 5.6882197890E+01, 5.6766333977E+00, 4.3264198729E+01, 4.6113817427E+00, 9.8604700453E-01],
	[4.4015000000E+04, 5.6893701646E+01, 5.6766870332E+00, 4.3280410190E+01, 4.6116768495E+00, 9.8605350871E-01],
	[4.4020000000E+04, 5.6905206422E+01, 5.6767406631E+00, 4.3296625883E+01, 4.6119718758E+00, 9.8606000947E-01],
	[4.4025000000E+04, 5.6916712217E+01, 5.6767942874E+00, 4.3312845807E+01, 4.6122668219E+00, 9.8606650680E-01],
	[4.4030000000E+04, 5.6928219032E+01, 5.6768479062E+00, 4.3329069964E+01, 4.6125616877E+00, 9.8607300072E-01],
	[4.4035000000E+04, 5.6939726865E+01, 5.6769015194E+00, 4.3345298353E+01, 4.6128564731E+00, 9.8607949121E-01],
	[4.4040000000E+04, 5.6951235719E+01, 5.6769551270E+00, 4.3361530976E+01, 4.6131511784E+00, 9.8608597830E-01],
	[4.4045000000E+04, 5.6962745591E+01, 5.6770087290E+00, 4.3377767833E+01, 4.6134458034E+00, 9.8609246197E-01],
	[4.4050000000E+04, 5.6974256483E+01, 5.6770623254E+00, 4.3394008925E+01, 4.6137403483E+00, 9.8609894222E-01],
	[4.4055000000E+04, 5.6985768393E+01, 5.6771159163E+00, 4.3410254252E+01, 4.6140348129E+00, 9.8610541907E-01],
	[4.4060000000E+04, 5.6997281323E+01, 5.6771695016E+00, 4.3426503815E+01, 4.6143291975E+00, 9.8611189251E-01],
	[4.4065000000E+04, 5.7008795272E+01, 5.6772230813E+00, 4.3442757615E+01, 4.6146235019E+00, 9.8611836255E-01],
	[4.4070000000E+04, 5.7020310241E+01, 5.6772766554E+00, 4.3459015652E+01, 4.6149177263E+00, 9.8612482918E-01],
	[4.4075000000E+04, 5.7031826228E+01, 5.6773302240E+00, 4.3475277927E+01, 4.6152118706E+00, 9.8613129241E-01],
	[4.4080000000E+04, 5.7043343234E+01, 5.6773837869E+00, 4.3491544440E+01, 4.6155059349E+00, 9.8613775224E-01],
	[4.4085000000E+04, 5.7054861260E+01, 5.6774373444E+00, 4.3507815193E+01, 4.6157999192E+00, 9.8614420867E-01],
	[4.4090000000E+04, 5.7066380304E+01, 5.6774908962E+00, 4.3524090185E+01, 4.6160938235E+00, 9.8615066171E-01],
	[4.4095000000E+04, 5.7077900368E+01, 5.6775444425E+00, 4.3540369417E+01, 4.6163876478E+00, 9.8615711135E-01],
	[4.4100000000E+04, 5.7089421450E+01, 5.6775979832E+00, 4.3556652891E+01, 4.6166813923E+00, 9.8616355760E-01],
	[4.4105000000E+04, 5.7100943551E+01, 5.6776515184E+00, 4.3572940606E+01, 4.6169750569E+00, 9.8617000047E-01],
	[4.4110000000E+04, 5.7112466672E+01, 5.6777050480E+00, 4.3589232563E+01, 4.6172686416E+00, 9.8617643994E-01],
	[4.4115000000E+04, 5.7123990811E+01, 5.6777585720E+00, 4.3605528763E+01, 4.6175621464E+00, 9.8618287603E-01],
	[4.4120000000E+04, 5.7135515969E+01, 5.6778120905E+00, 4.3621829207E+01, 4.6178555715E+00, 9.8618930874E-01],
	[4.4125000000E+04, 5.7147042146E+01, 5.6778656034E+00, 4.3638133895E+01, 4.6181489168E+00, 9.8619573806E-01],
	[4.4130000000E+04, 5.7158569342E+01, 5.6779191107E+00, 4.3654442827E+01, 4.6184421823E+00, 9.8620216401E-01],
	[4.4135000000E+04, 5.7170097556E+01, 5.6779726125E+00, 4.3670756005E+01, 4.6187353681E+00, 9.8620858658E-01],
	[4.4140000000E+04, 5.7181626789E+01, 5.6780261087E+00, 4.3687073429E+01, 4.6190284742E+00, 9.8621500577E-01],
	[4.4145000000E+04, 5.7193157041E+01, 5.6780795994E+00, 4.3703395099E+01, 4.6193215006E+00, 9.8622142159E-01],
	[4.4150000000E+04, 5.7204688312E+01, 5.6781330845E+00, 4.3719721017E+01, 4.6196144474E+00, 9.8622783404E-01],
	[4.4155000000E+04, 5.7216220602E+01, 5.6781865641E+00, 4.3736051182E+01, 4.6199073146E+00, 9.8623424312E-01],
	[4.4160000000E+04, 5.7227753910E+01, 5.6782400381E+00, 4.3752385596E+01, 4.6202001021E+00, 9.8624064883E-01],
	[4.4165000000E+04, 5.7239288236E+01, 5.6782935066E+00, 4.3768724259E+01, 4.6204928101E+00, 9.8624705117E-01],
	[4.4170000000E+04, 5.7250823582E+01, 5.6783469695E+00, 4.3785067172E+01, 4.6207854386E+00, 9.8625345015E-01],
	[4.4175000000E+04, 5.7262359946E+01, 5.6784004268E+00, 4.3801414335E+01, 4.6210779876E+00, 9.8625984577E-01],
	[4.4180000000E+04, 5.7273897328E+01, 5.6784538787E+00, 4.3817765749E+01, 4.6213704571E+00, 9.8626623804E-01],
	[4.4185000000E+04, 5.7285435729E+01, 5.6785073249E+00, 4.3834121414E+01, 4.6216628471E+00, 9.8627262694E-01],
	[4.4190000000E+04, 5.7296975149E+01, 5.6785607657E+00, 4.3850481332E+01, 4.6219551577E+00, 9.8627901249E-01],
	[4.4195000000E+04, 5.7308515587E+01, 5.6786142008E+00, 4.3866845503E+01, 4.6222473889E+00, 9.8628539468E-01],
	[4.4200000000E+04, 5.7320057043E+01, 5.6786676305E+00, 4.3883213927E+01, 4.6225395407E+00, 9.8629177352E-01],
	[4.4205000000E+04, 5.7331599518E+01, 5.6787210546E+00, 4.3899586605E+01, 4.6228316131E+00, 9.8629814902E-01],
	[4.4210000000E+04, 5.7343143012E+01, 5.6787744731E+00, 4.3915963538E+01, 4.6231236063E+00, 9.8630452116E-01],
	[4.4215000000E+04, 5.7354687523E+01, 5.6788278862E+00, 4.3932344726E+01, 4.6234155201E+00, 9.8631088996E-01],
	[4.4220000000E+04, 5.7366233053E+01, 5.6788812936E+00, 4.3948730170E+01, 4.6237073547E+00, 9.8631725542E-01],
	[4.4225000000E+04, 5.7377779602E+01, 5.6789346956E+00, 4.3965119871E+01, 4.6239991101E+00, 9.8632361753E-01],
	[4.4230000000E+04, 5.7389327169E+01, 5.6789880920E+00, 4.3981513828E+01, 4.6242907862E+00, 9.8632997631E-01],
	[4.4235000000E+04, 5.7400875754E+01, 5.6790414829E+00, 4.3997912044E+01, 4.6245823832E+00, 9.8633633174E-01],
	[4.4240000000E+04, 5.7412425357E+01, 5.6790948682E+00, 4.4014314518E+01, 4.6248739009E+00, 9.8634268385E-01],
	[4.4245000000E+04, 5.7423975979E+01, 5.6791482481E+00, 4.4030721251E+01, 4.6251653396E+00, 9.8634903261E-01],
	[4.4250000000E+04, 5.7435527618E+01, 5.6792016223E+00, 4.4047132244E+01, 4.6254566992E+00, 9.8635537805E-01],
	[4.4255000000E+04, 5.7447080276E+01, 5.6792549911E+00, 4.4063547497E+01, 4.6257479796E+00, 9.8636172016E-01],
	[4.4260000000E+04, 5.7458633952E+01, 5.6793083543E+00, 4.4079967011E+01, 4.6260391810E+00, 9.8636805893E-01],
	[4.4265000000E+04, 5.7470188647E+01, 5.6793617120E+00, 4.4096390787E+01, 4.6263303034E+00, 9.8637439439E-01],
	[4.4270000000E+04, 5.7481744359E+01, 5.6794150642E+00, 4.4112818825E+01, 4.6266213468E+00, 9.8638072652E-01],
	[4.4275000000E+04, 5.7493301089E+01, 5.6794684109E+00, 4.4129251126E+01, 4.6269123113E+00, 9.8638705532E-01],
	[4.4280000000E+04, 5.7504858838E+01, 5.6795217520E+00, 4.4145687690E+01, 4.6272031967E+00, 9.8639338081E-01],
	[4.4285000000E+04, 5.7516417604E+01, 5.6795750876E+00, 4.4162128518E+01, 4.6274940033E+00, 9.8639970298E-01],
	[4.4290000000E+04, 5.7527977389E+01, 5.6796284177E+00, 4.4178573611E+01, 4.6277847310E+00, 9.8640602183E-01],
	[4.4295000000E+04, 5.7539538191E+01, 5.6796817422E+00, 4.4195022969E+01, 4.6280753798E+00, 9.8641233737E-01],
	[4.4300000000E+04, 5.7551100012E+01, 5.6797350613E+00, 4.4211476593E+01, 4.6283659498E+00, 9.8641864960E-01],
	[4.4305000000E+04, 5.7562662850E+01, 5.6797883748E+00, 4.4227934484E+01, 4.6286564409E+00, 9.8642495852E-01],
	[4.4310000000E+04, 5.7574226706E+01, 5.6798416828E+00, 4.4244396642E+01, 4.6289468533E+00, 9.8643126413E-01],
	[4.4315000000E+04, 5.7585791581E+01, 5.6798949853E+00, 4.4260863067E+01, 4.6292371869E+00, 9.8643756643E-01],
	[4.4320000000E+04, 5.7597357473E+01, 5.6799482823E+00, 4.4277333761E+01, 4.6295274418E+00, 9.8644386543E-01],
	[4.4325000000E+04, 5.7608924382E+01, 5.6800015738E+00, 4.4293808724E+01, 4.6298176180E+00, 9.8645016113E-01],
	[4.4330000000E+04, 5.7620492310E+01, 5.6800548598E+00, 4.4310287957E+01, 4.6301077155E+00, 9.8645645352E-01],
	[4.4335000000E+04, 5.7632061256E+01, 5.6801081402E+00, 4.4326771460E+01, 4.6303977344E+00, 9.8646274262E-01],
	[4.4340000000E+04, 5.7643631219E+01, 5.6801614152E+00, 4.4343259234E+01, 4.6306876746E+00, 9.8646902842E-01],
	[4.4345000000E+04, 5.7655202200E+01, 5.6802146846E+00, 4.4359751280E+01, 4.6309775362E+00, 9.8647531093E-01],
	[4.4350000000E+04, 5.7666774198E+01, 5.6802679485E+00, 4.4376247598E+01, 4.6312673193E+00, 9.8648159015E-01],
	[4.4355000000E+04, 5.7678347215E+01, 5.6803212069E+00, 4.4392748188E+01, 4.6315570238E+00, 9.8648786607E-01],
	[4.4360000000E+04, 5.7689921249E+01, 5.6803744599E+00, 4.4409253052E+01, 4.6318466499E+00, 9.8649413871E-01],
	[4.4365000000E+04, 5.7701496300E+01, 5.6804277073E+00, 4.4425762190E+01, 4.6321361974E+00, 9.8650040806E-01],
	[4.4370000000E+04, 5.7713072369E+01, 5.6804809492E+00, 4.4442275603E+01, 4.6324256664E+00, 9.8650667413E-01],
	[4.4375000000E+04, 5.7724649456E+01, 5.6805341856E+00, 4.4458793291E+01, 4.6327150571E+00, 9.8651293691E-01],
	[4.4380000000E+04, 5.7736227560E+01, 5.6805874165E+00, 4.4475315255E+01, 4.6330043693E+00, 9.8651919641E-01],
	[4.4385000000E+04, 5.7747806682E+01, 5.6806406420E+00, 4.4491841495E+01, 4.6332936031E+00, 9.8652545264E-01],
	[4.4390000000E+04, 5.7759386822E+01, 5.6806938619E+00, 4.4508372013E+01, 4.6335827586E+00, 9.8653170558E-01],
	[4.4395000000E+04, 5.7770967979E+01, 5.6807470763E+00, 4.4524906808E+01, 4.6338718358E+00, 9.8653795526E-01],
	[4.4400000000E+04, 5.7782550153E+01, 5.6808002852E+00, 4.4541445882E+01, 4.6341608346E+00, 9.8654420166E-01],
	[4.4405000000E+04, 5.7794133345E+01, 5.6808534887E+00, 4.4557989235E+01, 4.6344497552E+00, 9.8655044479E-01],
	[4.4410000000E+04, 5.7805717554E+01, 5.6809066866E+00, 4.4574536867E+01, 4.6347385975E+00, 9.8655668465E-01],
	[4.4415000000E+04, 5.7817302780E+01, 5.6809598791E+00, 4.4591088780E+01, 4.6350273616E+00, 9.8656292124E-01],
	[4.4420000000E+04, 5.7828889024E+01, 5.6810130660E+00, 4.4607644974E+01, 4.6353160475E+00, 9.8656915457E-01],
	[4.4425000000E+04, 5.7840476285E+01, 5.6810662475E+00, 4.4624205449E+01, 4.6356046552E+00, 9.8657538463E-01],
	[4.4430000000E+04, 5.7852064564E+01, 5.6811194235E+00, 4.4640770207E+01, 4.6358931848E+00, 9.8658161144E-01],
	[4.4435000000E+04, 5.7863653859E+01, 5.6811725940E+00, 4.4657339247E+01, 4.6361816363E+00, 9.8658783498E-01],
	[4.4440000000E+04, 5.7875244172E+01, 5.6812257590E+00, 4.4673912571E+01, 4.6364700097E+00, 9.8659405527E-01],
	[4.4445000000E+04, 5.7886835503E+01, 5.6812789186E+00, 4.4690490179E+01, 4.6367583050E+00, 9.8660027231E-01],
	[4.4450000000E+04, 5.7898427850E+01, 5.6813320726E+00, 4.4707072071E+01, 4.6370465223E+00, 9.8660648609E-01],
	[4.4455000000E+04, 5.7910021215E+01, 5.6813852212E+00, 4.4723658249E+01, 4.6373346616E+00, 9.8661269661E-01],
	[4.4460000000E+04, 5.7921615596E+01, 5.6814383643E+00, 4.4740248712E+01, 4.6376227229E+00, 9.8661890389E-01],
	[4.4465000000E+04, 5.7933210995E+01, 5.6814915019E+00, 4.4756843462E+01, 4.6379107062E+00, 9.8662510793E-01],
	[4.4470000000E+04, 5.7944807411E+01, 5.6815446340E+00, 4.4773442500E+01, 4.6381986116E+00, 9.8663130871E-01],
	[4.4475000000E+04, 5.7956404844E+01, 5.6815977607E+00, 4.4790045825E+01, 4.6384864391E+00, 9.8663750625E-01],
	[4.4480000000E+04, 5.7968003294E+01, 5.6816508818E+00, 4.4806653438E+01, 4.6387741887E+00, 9.8664370056E-01],
	[4.4485000000E+04, 5.7979602761E+01, 5.6817039975E+00, 4.4823265341E+01, 4.6390618605E+00, 9.8664989162E-01],
	[4.4490000000E+04, 5.7991203246E+01, 5.6817571078E+00, 4.4839881533E+01, 4.6393494544E+00, 9.8665607944E-01],
	[4.4495000000E+04, 5.8002804747E+01, 5.6818102125E+00, 4.4856502016E+01, 4.6396369706E+00, 9.8666226403E-01],
	[4.4500000000E+04, 5.8014407265E+01, 5.6818633118E+00, 4.4873126789E+01, 4.6399244090E+00, 9.8666844538E-01],
	[4.4505000000E+04, 5.8026010800E+01, 5.6819164056E+00, 4.4889755854E+01, 4.6402117696E+00, 9.8667462351E-01],
	[4.4510000000E+04, 5.8037615352E+01, 5.6819694940E+00, 4.4906389211E+01, 4.6404990525E+00, 9.8668079840E-01],
	[4.4515000000E+04, 5.8049220920E+01, 5.6820225769E+00, 4.4923026861E+01, 4.6407862577E+00, 9.8668697006E-01],
	[4.4520000000E+04, 5.8060827506E+01, 5.6820756543E+00, 4.4939668805E+01, 4.6410733853E+00, 9.8669313850E-01],
	[4.4525000000E+04, 5.8072435108E+01, 5.6821287263E+00, 4.4956315042E+01, 4.6413604352E+00, 9.8669930372E-01],
	[4.4530000000E+04, 5.8084043727E+01, 5.6821817927E+00, 4.4972965574E+01, 4.6416474075E+00, 9.8670546571E-01],
	[4.4535000000E+04, 5.8095653363E+01, 5.6822348538E+00, 4.4989620402E+01, 4.6419343022E+00, 9.8671162448E-01],
	[4.4540000000E+04, 5.8107264016E+01, 5.6822879093E+00, 4.5006279525E+01, 4.6422211194E+00, 9.8671778003E-01],
	[4.4545000000E+04, 5.8118875686E+01, 5.6823409594E+00, 4.5022942945E+01, 4.6425078590E+00, 9.8672393237E-01],
	[4.4550000000E+04, 5.8130488372E+01, 5.6823940041E+00, 4.5039610662E+01, 4.6427945211E+00, 9.8673008149E-01],
	[4.4555000000E+04, 5.8142102075E+01, 5.6824470433E+00, 4.5056282676E+01, 4.6430811058E+00, 9.8673622740E-01],
	[4.4560000000E+04, 5.8153716794E+01, 5.6825000770E+00, 4.5072958990E+01, 4.6433676130E+00, 9.8674237010E-01],
	[4.4565000000E+04, 5.8165332530E+01, 5.6825531053E+00, 4.5089639602E+01, 4.6436540427E+00, 9.8674850959E-01],
	[4.4570000000E+04, 5.8176949283E+01, 5.6826061281E+00, 4.5106324514E+01, 4.6439403951E+00, 9.8675464587E-01],
	[4.4575000000E+04, 5.8188567052E+01, 5.6826591455E+00, 4.5123013726E+01, 4.6442266700E+00, 9.8676077895E-01],
	[4.4580000000E+04, 5.8200185838E+01, 5.6827121574E+00, 4.5139707239E+01, 4.6445128677E+00, 9.8676690883E-01],
	[4.4585000000E+04, 5.8211809854E+01, 5.6827655058E+00, 4.5156405054E+01, 4.6447992433E+00, 9.8677303550E-01],
	[4.4590000000E+04, 5.8223453498E+01, 5.6828203590E+00, 4.5173107171E+01, 4.6450866690E+00, 9.8677915898E-01],
	[4.4595000000E+04, 5.8235098166E+01, 5.6828752064E+00, 4.5189813590E+01, 4.6453740176E+00, 9.8678527926E-01],
	[4.4600000000E+04, 5.8246743856E+01, 5.6829300483E+00, 4.5206524314E+01, 4.6456612891E+00, 9.8679139634E-01],
	[4.4605000000E+04, 5.8258390569E+01, 5.6829848846E+00, 4.5223239341E+01, 4.6459484834E+00, 9.8679751023E-01],
	[4.4610000000E+04, 5.8270038305E+01, 5.6830397152E+00, 4.5239958672E+01, 4.6462356006E+00, 9.8680362093E-01],
	[4.4615000000E+04, 5.8281687064E+01, 5.6830945402E+00, 4.5256682310E+01, 4.6465226408E+00, 9.8680972843E-01],
	[4.4620000000E+04, 5.8293336846E+01, 5.6831493596E+00, 4.5273410253E+01, 4.6468096039E+00, 9.8681583276E-01],
	[4.4625000000E+04, 5.8304987651E+01, 5.6832041734E+00, 4.5290142502E+01, 4.6470964901E+00, 9.8682193389E-01],
	[4.4630000000E+04, 5.8316639479E+01, 5.6832589816E+00, 4.5306879059E+01, 4.6473832992E+00, 9.8682803184E-01],
	[4.4635000000E+04, 5.8328292330E+01, 5.6833137841E+00, 4.5323619924E+01, 4.6476700314E+00, 9.8683412661E-01],
	[4.4640000000E+04, 5.8339946203E+01, 5.6833685811E+00, 4.5340365097E+01, 4.6479566867E+00, 9.8684021820E-01],
	[4.4645000000E+04, 5.8351601099E+01, 5.6834233724E+00, 4.5357114579E+01, 4.6482432651E+00, 9.8684630661E-01],
	[4.4650000000E+04, 5.8363257018E+01, 5.6834781582E+00, 4.5373868370E+01, 4.6485297666E+00, 9.8685239185E-01],
	[4.4655000000E+04, 5.8374913960E+01, 5.6835329383E+00, 4.5390626472E+01, 4.6488161912E+00, 9.8685847391E-01],
	[4.4660000000E+04, 5.8386571924E+01, 5.6835877128E+00, 4.5407388885E+01, 4.6491025390E+00, 9.8686455280E-01],
	[4.4665000000E+04, 5.8398230911E+01, 5.6836424817E+00, 4.5424155610E+01, 4.6493888100E+00, 9.8687062852E-01],
	[4.4670000000E+04, 5.8409890921E+01, 5.6836972450E+00, 4.5440926646E+01, 4.6496750042E+00, 9.8687670107E-01],
	[4.4675000000E+04, 5.8421551954E+01, 5.6837520028E+00, 4.5457701996E+01, 4.6499611217E+00, 9.8688277045E-01],
	[4.4680000000E+04, 5.8433214009E+01, 5.6838067549E+00, 4.5474481659E+01, 4.6502471625E+00, 9.8688883667E-01],
	[4.4685000000E+04, 5.8444877086E+01, 5.6838615014E+00, 4.5491265636E+01, 4.6505331266E+00, 9.8689489972E-01],
	[4.4690000000E+04, 5.8456541186E+01, 5.6839162423E+00, 4.5508053928E+01, 4.6508190140E+00, 9.8690095961E-01],
	[4.4695000000E+04, 5.8468206309E+01, 5.6839709776E+00, 4.5524846535E+01, 4.6511048247E+00, 9.8690701634E-01],
	[4.4700000000E+04, 5.8479872454E+01, 5.6840257073E+00, 4.5541643457E+01, 4.6513905589E+00, 9.8691306992E-01],
	[4.4705000000E+04, 5.8491539622E+01, 5.6840804315E+00, 4.5558444697E+01, 4.6516762164E+00, 9.8691912033E-01],
	[4.4710000000E+04, 5.8503207812E+01, 5.6841351500E+00, 4.5575250254E+01, 4.6519617974E+00, 9.8692516759E-01],
	[4.4715000000E+04, 5.8514877024E+01, 5.6841898629E+00, 4.5592060128E+01, 4.6522473019E+00, 9.8693121170E-01],
	[4.4720000000E+04, 5.8526547259E+01, 5.6842445703E+00, 4.5608874321E+01, 4.6525327298E+00, 9.8693725265E-01],
	[4.4725000000E+04, 5.8538218517E+01, 5.6842992721E+00, 4.5625692833E+01, 4.6528180812E+00, 9.8694329045E-01],
	[4.4730000000E+04, 5.8549890797E+01, 5.6843539682E+00, 4.5642515665E+01, 4.6531033562E+00, 9.8694932511E-01],
	[4.4735000000E+04, 5.8561564099E+01, 5.6844086588E+00, 4.5659342817E+01, 4.6533885548E+00, 9.8695535662E-01],
	[4.4740000000E+04, 5.8573238423E+01, 5.6844633438E+00, 4.5676174290E+01, 4.6536736769E+00, 9.8696138498E-01],
	[4.4745000000E+04, 5.8584913770E+01, 5.6845180232E+00, 4.5693010084E+01, 4.6539587227E+00, 9.8696741020E-01],
	[4.4750000000E+04, 5.8596590139E+01, 5.6845726971E+00, 4.5709850201E+01, 4.6542436921E+00, 9.8697343228E-01],
	[4.4755000000E+04, 5.8608267530E+01, 5.6846273653E+00, 4.5726694640E+01, 4.6545285852E+00, 9.8697945122E-01],
	[4.4760000000E+04, 5.8619945943E+01, 5.6846820280E+00, 4.5743543403E+01, 4.6548134019E+00, 9.8698546701E-01],
	[4.4765000000E+04, 5.8631625379E+01, 5.6847366850E+00, 4.5760396490E+01, 4.6550981424E+00, 9.8699147968E-01],
	[4.4770000000E+04, 5.8643305837E+01, 5.6847913366E+00, 4.5777253902E+01, 4.6553828066E+00, 9.8699748920E-01],
	[4.4775000000E+04, 5.8654987317E+01, 5.6848459825E+00, 4.5794115639E+01, 4.6556673946E+00, 9.8700349560E-01],
	[4.4780000000E+04, 5.8666669819E+01, 5.6849006228E+00, 4.5810981702E+01, 4.6559519064E+00, 9.8700949886E-01],
	[4.4785000000E+04, 5.8678353343E+01, 5.6849552576E+00, 4.5827852092E+01, 4.6562363421E+00, 9.8701549899E-01],
	[4.4790000000E+04, 5.8690037889E+01, 5.6850098868E+00, 4.5844726809E+01, 4.6565207015E+00, 9.8702149599E-01],
	[4.4795000000E+04, 5.8701723457E+01, 5.6850645104E+00, 4.5861605853E+01, 4.6568049849E+00, 9.8702748987E-01],
	[4.4800000000E+04, 5.8713410047E+01, 5.6851191285E+00, 4.5878489226E+01, 4.6570891921E+00, 9.8703348062E-01],
	[4.4805000000E+04, 5.8725097659E+01, 5.6851737410E+00, 4.5895376929E+01, 4.6573733233E+00, 9.8703946825E-01],
	[4.4810000000E+04, 5.8736786294E+01, 5.6852283479E+00, 4.5912268960E+01, 4.6576573785E+00, 9.8704545276E-01],
	[4.4815000000E+04, 5.8748475950E+01, 5.6852829492E+00, 4.5929165323E+01, 4.6579413576E+00, 9.8705143415E-01],
	[4.4820000000E+04, 5.8760166628E+01, 5.6853375450E+00, 4.5946066016E+01, 4.6582252607E+00, 9.8705741242E-01],
	[4.4825000000E+04, 5.8771858328E+01, 5.6853921352E+00, 4.5962971041E+01, 4.6585090878E+00, 9.8706338757E-01],
	[4.4830000000E+04, 5.8783551050E+01, 5.6854467199E+00, 4.5979880398E+01, 4.6587928390E+00, 9.8706935961E-01],
	[4.4835000000E+04, 5.8795244793E+01, 5.6855012990E+00, 4.5996794087E+01, 4.6590765143E+00, 9.8707532853E-01],
	[4.4840000000E+04, 5.8806939559E+01, 5.6855558725E+00, 4.6013712111E+01, 4.6593601137E+00, 9.8708129435E-01],
	[4.4845000000E+04, 5.8818635346E+01, 5.6856104405E+00, 4.6030634468E+01, 4.6596436372E+00, 9.8708725705E-01],
	[4.4850000000E+04, 5.8830332155E+01, 5.6856650029E+00, 4.6047561160E+01, 4.6599270849E+00, 9.8709321665E-01],
	[4.4855000000E+04, 5.8842029986E+01, 5.6857195597E+00, 4.6064492188E+01, 4.6602104568E+00, 9.8709917313E-01],
	[4.4860000000E+04, 5.8853728838E+01, 5.6857741110E+00, 4.6081427551E+01, 4.6604937529E+00, 9.8710512652E-01],
	[4.4865000000E+04, 5.8865428713E+01, 5.6858286567E+00, 4.6098367251E+01, 4.6607769732E+00, 9.8711107680E-01],
	[4.4870000000E+04, 5.8877129609E+01, 5.6858831969E+00, 4.6115311289E+01, 4.6610601178E+00, 9.8711702398E-01],
	[4.4875000000E+04, 5.8888831526E+01, 5.6859377315E+00, 4.6132259664E+01, 4.6613431867E+00, 9.8712296806E-01],
	[4.4880000000E+04, 5.8900534465E+01, 5.6859922606E+00, 4.6149212377E+01, 4.6616261798E+00, 9.8712890904E-01],
	[4.4885000000E+04, 5.8912238426E+01, 5.6860467841E+00, 4.6166169430E+01, 4.6619090974E+00, 9.8713484693E-01],
	[4.4890000000E+04, 5.8923943408E+01, 5.6861013021E+00, 4.6183130823E+01, 4.6621919393E+00, 9.8714078172E-01],
	[4.4895000000E+04, 5.8935649412E+01, 5.6861558145E+00, 4.6200096555E+01, 4.6624747055E+00, 9.8714671342E-01],
	[4.4900000000E+04, 5.8947356438E+01, 5.6862103213E+00, 4.6217066629E+01, 4.6627573962E+00, 9.8715264203E-01],
	[4.4905000000E+04, 5.8959064484E+01, 5.6862648227E+00, 4.6234041045E+01, 4.6630400114E+00, 9.8715856755E-01],
	[4.4910000000E+04, 5.8970773553E+01, 5.6863193184E+00, 4.6251019802E+01, 4.6633225510E+00, 9.8716448998E-01],
	[4.4915000000E+04, 5.8982483643E+01, 5.6863738087E+00, 4.6268002903E+01, 4.6636050151E+00, 9.8717040932E-01],
	[4.4920000000E+04, 5.8994194754E+01, 5.6864282933E+00, 4.6284990347E+01, 4.6638874037E+00, 9.8717632558E-01],
	[4.4925000000E+04, 5.9005906887E+01, 5.6864827725E+00, 4.6301982135E+01, 4.6641697169E+00, 9.8718223876E-01],
	[4.4930000000E+04, 5.9017620041E+01, 5.6865372461E+00, 4.6318978268E+01, 4.6644519546E+00, 9.8718814885E-01],
	[4.4935000000E+04, 5.9029334216E+01, 5.6865917141E+00, 4.6335978746E+01, 4.6647341170E+00, 9.8719405587E-01],
	[4.4940000000E+04, 5.9041049413E+01, 5.6866461767E+00, 4.6352983570E+01, 4.6650162039E+00, 9.8719995981E-01],
	[4.4945000000E+04, 5.9052765631E+01, 5.6867006337E+00, 4.6369992741E+01, 4.6652982155E+00, 9.8720586067E-01],
	[4.4950000000E+04, 5.9064482870E+01, 5.6867550851E+00, 4.6387006260E+01, 4.6655801518E+00, 9.8721175846E-01],
	[4.4955000000E+04, 5.9076201130E+01, 5.6868095310E+00, 4.6404024126E+01, 4.6658620128E+00, 9.8721765318E-01],
	[4.4960000000E+04, 5.9087920412E+01, 5.6868639714E+00, 4.6421046340E+01, 4.6661437985E+00, 9.8722354482E-01],
	[4.4965000000E+04, 5.9099640715E+01, 5.6869184062E+00, 4.6438072904E+01, 4.6664255089E+00, 9.8722943340E-01],
	[4.4970000000E+04, 5.9111362039E+01, 5.6869728356E+00, 4.6455103817E+01, 4.6667071442E+00, 9.8723531890E-01],
	[4.4975000000E+04, 5.9123084385E+01, 5.6870272593E+00, 4.6472139081E+01, 4.6669887042E+00, 9.8724120134E-01],
	[4.4980000000E+04, 5.9134807751E+01, 5.6870816776E+00, 4.6489178696E+01, 4.6672701890E+00, 9.8724708072E-01],
	[4.4985000000E+04, 5.9146532139E+01, 5.6871360903E+00, 4.6506222663E+01, 4.6675515987E+00, 9.8725295704E-01],
	[4.4990000000E+04, 5.9158257547E+01, 5.6871904975E+00, 4.6523270981E+01, 4.6678329333E+00, 9.8725883029E-01],
	[4.4995000000E+04, 5.9169983977E+01, 5.6872448992E+00, 4.6540323653E+01, 4.6681141928E+00, 9.8726470048E-01],
	[4.5000000000E+04, 5.9181711428E+01, 5.6872992954E+00, 4.6557380678E+01, 4.6683953772E+00, 9.8727056762E-01],
	[4.5005000000E+04, 5.9193439899E+01, 5.6873536860E+00, 4.6574466458E+01, 4.6686767318E+00, 9.8727643170E-01],
	[4.5010000000E+04, 5.9205169392E+01, 5.6874080711E+00, 4.6591556607E+01, 4.6689580112E+00, 9.8728229273E-01],
	[4.5015000000E+04, 5.9216899906E+01, 5.6874624507E+00, 4.6608651128E+01, 4.6692392154E+00, 9.8728815070E-01],
	[4.5020000000E+04, 5.9228631440E+01, 5.6875168247E+00, 4.6625750019E+01, 4.6695203445E+00, 9.8729400562E-01],
	[4.5025000000E+04, 5.9240363996E+01, 5.6875711933E+00, 4.6642853283E+01, 4.6698013986E+00, 9.8729985750E-01],
	[4.5030000000E+04, 5.9252097572E+01, 5.6876255563E+00, 4.6659960920E+01, 4.6700823776E+00, 9.8730570632E-01],
	[4.5035000000E+04, 5.9263832170E+01, 5.6876799138E+00, 4.6677072929E+01, 4.6703632815E+00, 9.8731155211E-01],
	[4.5040000000E+04, 5.9275567788E+01, 5.6877342658E+00, 4.6694189313E+01, 4.6706441104E+00, 9.8731739484E-01],
	[4.5045000000E+04, 5.9287304427E+01, 5.6877886123E+00, 4.6711310071E+01, 4.6709248643E+00, 9.8732323454E-01],
	[4.5050000000E+04, 5.9299042086E+01, 5.6878429532E+00, 4.6728435205E+01, 4.6712055433E+00, 9.8732907119E-01],
	[4.5055000000E+04, 5.9310780767E+01, 5.6878972887E+00, 4.6745564714E+01, 4.6714861474E+00, 9.8733490480E-01],
	[4.5060000000E+04, 5.9322520468E+01, 5.6879516186E+00, 4.6762698599E+01, 4.6717666765E+00, 9.8734073538E-01],
	[4.5065000000E+04, 5.9334261190E+01, 5.6880059431E+00, 4.6779836862E+01, 4.6720471307E+00, 9.8734656292E-01],
	[4.5070000000E+04, 5.9346002932E+01, 5.6880602620E+00, 4.6796979503E+01, 4.6723275101E+00, 9.8735238742E-01],
	[4.5075000000E+04, 5.9357745696E+01, 5.6881145754E+00, 4.6814126521E+01, 4.6726078146E+00, 9.8735820890E-01],
	[4.5080000000E+04, 5.9369489479E+01, 5.6881688833E+00, 4.6831277919E+01, 4.6728880444E+00, 9.8736402734E-01],
	[4.5085000000E+04, 5.9381234284E+01, 5.6882231858E+00, 4.6848433696E+01, 4.6731681993E+00, 9.8736984275E-01],
	[4.5090000000E+04, 5.9392980109E+01, 5.6882774827E+00, 4.6865593854E+01, 4.6734482795E+00, 9.8737565514E-01],
	[4.5095000000E+04, 5.9404726955E+01, 5.6883317741E+00, 4.6882758392E+01, 4.6737282850E+00, 9.8738146450E-01],
	[4.5100000000E+04, 5.9416474821E+01, 5.6883860600E+00, 4.6899927312E+01, 4.6740082157E+00, 9.8738727084E-01],
	[4.5105000000E+04, 5.9428223708E+01, 5.6884403404E+00, 4.6917100614E+01, 4.6742880718E+00, 9.8739307415E-01],
	[4.5110000000E+04, 5.9439973615E+01, 5.6884946153E+00, 4.6934278299E+01, 4.6745678532E+00, 9.8739887444E-01],
	[4.5115000000E+04, 5.9451724543E+01, 5.6885488847E+00, 4.6951460367E+01, 4.6748475600E+00, 9.8740467172E-01],
	[4.5120000000E+04, 5.9463476491E+01, 5.6886031486E+00, 4.6968646820E+01, 4.6751271922E+00, 9.8741046597E-01],
	[4.5125000000E+04, 5.9475229459E+01, 5.6886574070E+00, 4.6985837657E+01, 4.6754067498E+00, 9.8741625721E-01],
	[4.5130000000E+04, 5.9486983448E+01, 5.6887116599E+00, 4.7003032879E+01, 4.6756862328E+00, 9.8742204544E-01],
	[4.5135000000E+04, 5.9498738458E+01, 5.6887659073E+00, 4.7020232487E+01, 4.6759656413E+00, 9.8742783065E-01],
	[4.5140000000E+04, 5.9510494487E+01, 5.6888201493E+00, 4.7037436482E+01, 4.6762449753E+00, 9.8743361286E-01],
	[4.5145000000E+04, 5.9522251537E+01, 5.6888743857E+00, 4.7054644864E+01, 4.6765242348E+00, 9.8743939205E-01],
	[4.5150000000E+04, 5.9534009607E+01, 5.6889286167E+00, 4.7071857633E+01, 4.6768034199E+00, 9.8744516824E-01],
	[4.5155000000E+04, 5.9545768698E+01, 5.6889828421E+00, 4.7089074791E+01, 4.6770825305E+00, 9.8745094142E-01],
	[4.5160000000E+04, 5.9557528809E+01, 5.6890370621E+00, 4.7106296339E+01, 4.6773615668E+00, 9.8745671159E-01],
	[4.5165000000E+04, 5.9569289940E+01, 5.6890912766E+00, 4.7123522276E+01, 4.6776405286E+00, 9.8746247877E-01],
	[4.5170000000E+04, 5.9581052091E+01, 5.6891454856E+00, 4.7140752603E+01, 4.6779194161E+00, 9.8746824294E-01],
	[4.5175000000E+04, 5.9592815262E+01, 5.6891996891E+00, 4.7157987321E+01, 4.6781982293E+00, 9.8747400411E-01],
	[4.5180000000E+04, 5.9604579454E+01, 5.6892538872E+00, 4.7175226431E+01, 4.6784769682E+00, 9.8747976229E-01],
	[4.5185000000E+04, 5.9616344666E+01, 5.6893080797E+00, 4.7192469933E+01, 4.6787556328E+00, 9.8748551747E-01],
	[4.5190000000E+04, 5.9628110897E+01, 5.6893622668E+00, 4.7209717828E+01, 4.6790342232E+00, 9.8749126966E-01],
	[4.5195000000E+04, 5.9639878149E+01, 5.6894164484E+00, 4.7226970117E+01, 4.6793127393E+00, 9.8749701885E-01],
	[4.5200000000E+04, 5.9651646421E+01, 5.6894706245E+00, 4.7244226800E+01, 4.6795911812E+00, 9.8750276506E-01],
	[4.5205000000E+04, 5.9663415713E+01, 5.6895247952E+00, 4.7261487877E+01, 4.6798695490E+00, 9.8750850827E-01],
	[4.5210000000E+04, 5.9675186025E+01, 5.6895789604E+00, 4.7278753350E+01, 4.6801478426E+00, 9.8751424850E-01],
	[4.5215000000E+04, 5.9686957357E+01, 5.6896331200E+00, 4.7296023219E+01, 4.6804260620E+00, 9.8751998574E-01],
	[4.5220000000E+04, 5.9698729709E+01, 5.6896872743E+00, 4.7313297485E+01, 4.6807042074E+00, 9.8752571999E-01],
	[4.5225000000E+04, 5.9710503081E+01, 5.6897414230E+00, 4.7330576148E+01, 4.6809822787E+00, 9.8753145127E-01],
	[4.5230000000E+04, 5.9722277472E+01, 5.6897955663E+00, 4.7347859209E+01, 4.6812602759E+00, 9.8753717956E-01],
	[4.5235000000E+04, 5.9734052884E+01, 5.6898497041E+00, 4.7365146668E+01, 4.6815381992E+00, 9.8754290488E-01],
	[4.5240000000E+04, 5.9745829315E+01, 5.6899038364E+00, 4.7382438527E+01, 4.6818160484E+00, 9.8754862721E-01],
	[4.5245000000E+04, 5.9757606767E+01, 5.6899579633E+00, 4.7399734785E+01, 4.6820938236E+00, 9.8755434657E-01],
	[4.5250000000E+04, 5.9769385238E+01, 5.6900120847E+00, 4.7417035444E+01, 4.6823715249E+00, 9.8756006296E-01],
	[4.5255000000E+04, 5.9781164729E+01, 5.6900662007E+00, 4.7434340504E+01, 4.6826491523E+00, 9.8756577637E-01],
	[4.5260000000E+04, 5.9792945239E+01, 5.6901203111E+00, 4.7451649966E+01, 4.6829267058E+00, 9.8757148681E-01],
	[4.5265000000E+04, 5.9804726770E+01, 5.6901744162E+00, 4.7468963830E+01, 4.6832041854E+00, 9.8757719429E-01],
	[4.5270000000E+04, 5.9816509320E+01, 5.6902285157E+00, 4.7486282098E+01, 4.6834815912E+00, 9.8758289879E-01],
	[4.5275000000E+04, 5.9828292889E+01, 5.6902826098E+00, 4.7503604768E+01, 4.6837589231E+00, 9.8758860033E-01],
	[4.5280000000E+04, 5.9840077479E+01, 5.6903366984E+00, 4.7520931843E+01, 4.6840361812E+00, 9.8759429891E-01],
	[4.5285000000E+04, 5.9851863088E+01, 5.6903907816E+00, 4.7538263324E+01, 4.6843133656E+00, 9.8759999452E-01],
	[4.5290000000E+04, 5.9863649717E+01, 5.6904448593E+00, 4.7555599209E+01, 4.6845904762E+00, 9.8760568717E-01],
	[4.5295000000E+04, 5.9875437365E+01, 5.6904989316E+00, 4.7572939501E+01, 4.6848675131E+00, 9.8761137687E-01],
	[4.5300000000E+04, 5.9887226033E+01, 5.6905529984E+00, 4.7590284199E+01, 4.6851444763E+00, 9.8761706360E-01],
	[4.5305000000E+04, 5.9899030253E+01, 5.6906082134E+00, 4.7607633305E+01, 4.6854222369E+00, 9.8762274738E-01],
	[4.5310000000E+04, 5.9910843812E+01, 5.6906640830E+00, 4.7624986819E+01, 4.6857004222E+00, 9.8762842821E-01],
	[4.5315000000E+04, 5.9922658398E+01, 5.6907199469E+00, 4.7642344742E+01, 4.6859785341E+00, 9.8763410608E-01],
	[4.5320000000E+04, 5.9934474010E+01, 5.6907758053E+00, 4.7659707074E+01, 4.6862565724E+00, 9.8763978100E-01],
	[4.5325000000E+04, 5.9946290648E+01, 5.6908316580E+00, 4.7677073816E+01, 4.6865345372E+00, 9.8764545297E-01],
	[4.5330000000E+04, 5.9958108311E+01, 5.6908875051E+00, 4.7694444969E+01, 4.6868124286E+00, 9.8765112199E-01],
	[4.5335000000E+04, 5.9969927001E+01, 5.6909433466E+00, 4.7711820533E+01, 4.6870902466E+00, 9.8765678807E-01],
	[4.5340000000E+04, 5.9981746716E+01, 5.6909991824E+00, 4.7729200508E+01, 4.6873679912E+00, 9.8766245120E-01],
	[4.5345000000E+04, 5.9993567457E+01, 5.6910550127E+00, 4.7746584897E+01, 4.6876456624E+00, 9.8766811139E-01],
	[4.5350000000E+04, 6.0005389224E+01, 5.6911108374E+00, 4.7763973698E+01, 4.6879232602E+00, 9.8767376864E-01],
	[4.5355000000E+04, 6.0017212017E+01, 5.6911666564E+00, 4.7781366913E+01, 4.6882007847E+00, 9.8767942295E-01],
	[4.5360000000E+04, 6.0029035835E+01, 5.6912224699E+00, 4.7798764543E+01, 4.6884782359E+00, 9.8768507432E-01],
	[4.5365000000E+04, 6.0040860679E+01, 5.6912782777E+00, 4.7816166587E+01, 4.6887556138E+00, 9.8769072276E-01],
	[4.5370000000E+04, 6.0052686549E+01, 5.6913340799E+00, 4.7833573048E+01, 4.6890329185E+00, 9.8769636826E-01],
	[4.5375000000E+04, 6.0064513445E+01, 5.6913898766E+00, 4.7850983924E+01, 4.6893101500E+00, 9.8770201083E-01],
	[4.5380000000E+04, 6.0076341366E+01, 5.6914456676E+00, 4.7868399218E+01, 4.6895873082E+00, 9.8770765046E-01],
	[4.5385000000E+04, 6.0088170313E+01, 5.6915014531E+00, 4.7885818929E+01, 4.6898643932E+00, 9.8771328717E-01],
	[4.5390000000E+04, 6.0100000285E+01, 5.6915572329E+00, 4.7903243058E+01, 4.6901414052E+00, 9.8771892095E-01],
	[4.5395000000E+04, 6.0111831283E+01, 5.6916130071E+00, 4.7920671606E+01, 4.6904183439E+00, 9.8772455180E-01],
	[4.5400000000E+04, 6.0123663307E+01, 5.6916687758E+00, 4.7938104574E+01, 4.6906952096E+00, 9.8773017973E-01],
	[4.5405000000E+04, 6.0135496356E+01, 5.6917245388E+00, 4.7955541961E+01, 4.6909720022E+00, 9.8773580473E-01],
	[4.5410000000E+04, 6.0147330431E+01, 5.6917802963E+00, 4.7972983770E+01, 4.6912487217E+00, 9.8774142681E-01],
	[4.5415000000E+04, 6.0159165531E+01, 5.6918360481E+00, 4.7990429999E+01, 4.6915253682E+00, 9.8774704598E-01],
	[4.5420000000E+04, 6.0171001657E+01, 5.6918917944E+00, 4.8007880651E+01, 4.6918019417E+00, 9.8775266222E-01],
	[4.5425000000E+04, 6.0182838808E+01, 5.6919475351E+00, 4.8025335725E+01, 4.6920784422E+00, 9.8775827555E-01],
	[4.5430000000E+04, 6.0194676984E+01, 5.6920032702E+00, 4.8042795223E+01, 4.6923548698E+00, 9.8776388597E-01],
	[4.5435000000E+04, 6.0206516186E+01, 5.6920589997E+00, 4.8060259145E+01, 4.6926312244E+00, 9.8776949347E-01],
	[4.5440000000E+04, 6.0218356414E+01, 5.6921147236E+00, 4.8077727491E+01, 4.6929075061E+00, 9.8777509806E-01],
	[4.5445000000E+04, 6.0230197666E+01, 5.6921704419E+00, 4.8095200262E+01, 4.6931837150E+00, 9.8778069973E-01],
	[4.5450000000E+04, 6.0242039944E+01, 5.6922261547E+00, 4.8112677459E+01, 4.6934598509E+00, 9.8778629851E-01],
	[4.5455000000E+04, 6.0253883247E+01, 5.6922818618E+00, 4.8130159083E+01, 4.6937359141E+00, 9.8779189437E-01],
	[4.5460000000E+04, 6.0265727576E+01, 5.6923375634E+00, 4.8147645133E+01, 4.6940119044E+00, 9.8779748733E-01],
	[4.5465000000E+04, 6.0277572930E+01, 5.6923932594E+00, 4.8165135611E+01, 4.6942878220E+00, 9.8780307738E-01],
	[4.5470000000E+04, 6.0289419309E+01, 5.6924489498E+00, 4.8182630518E+01, 4.6945636668E+00, 9.8780866454E-01],
	[4.5475000000E+04, 6.0301266713E+01, 5.6925046346E+00, 4.8200129854E+01, 4.6948394389E+00, 9.8781424879E-01],
	[4.5480000000E+04, 6.0313115142E+01, 5.6925603139E+00, 4.8217633619E+01, 4.6951151382E+00, 9.8781983015E-01],
	[4.5485000000E+04, 6.0324964597E+01, 5.6926159876E+00, 4.8235141814E+01, 4.6953907649E+00, 9.8782540861E-01],
	[4.5490000000E+04, 6.0336815077E+01, 5.6926716557E+00, 4.8252654440E+01, 4.6956663189E+00, 9.8783098417E-01],
	[4.5495000000E+04, 6.0348666581E+01, 5.6927273182E+00, 4.8270171498E+01, 4.6959418003E+00, 9.8783655684E-01],
	[4.5500000000E+04, 6.0360519111E+01, 5.6927829752E+00, 4.8287692988E+01, 4.6962172090E+00, 9.8784212662E-01],
	[4.5505000000E+04, 6.0372372666E+01, 5.6928386266E+00, 4.8305218911E+01, 4.6964925452E+00, 9.8784769350E-01],
	[4.5510000000E+04, 6.0384227246E+01, 5.6928942724E+00, 4.8322749267E+01, 4.6967678088E+00, 9.8785325750E-01],
	[4.5515000000E+04, 6.0396082851E+01, 5.6929499127E+00, 4.8340284057E+01, 4.6970429999E+00, 9.8785881861E-01],
	[4.5520000000E+04, 6.0407939481E+01, 5.6930055473E+00, 4.8357823282E+01, 4.6973181185E+00, 9.8786437684E-01],
	[4.5525000000E+04, 6.0419797136E+01, 5.6930611764E+00, 4.8375366942E+01, 4.6975931646E+00, 9.8786993218E-01],
	[4.5530000000E+04, 6.0431655816E+01, 5.6931168000E+00, 4.8392915038E+01, 4.6978681382E+00, 9.8787548464E-01],
	[4.5535000000E+04, 6.0443515521E+01, 5.6931724180E+00, 4.8410467571E+01, 4.6981430394E+00, 9.8788103422E-01],
	[4.5540000000E+04, 6.0455376250E+01, 5.6932280304E+00, 4.8428024541E+01, 4.6984178682E+00, 9.8788658092E-01],
	[4.5545000000E+04, 6.0467238005E+01, 5.6932836373E+00, 4.8445585948E+01, 4.6986926245E+00, 9.8789212475E-01],
	[4.5550000000E+04, 6.0479100784E+01, 5.6933392386E+00, 4.8463151794E+01, 4.6989673086E+00, 9.8789766570E-01],
	[4.5555000000E+04, 6.0490964588E+01, 5.6933948343E+00, 4.8480722080E+01, 4.6992419202E+00, 9.8790320377E-01],
	[4.5560000000E+04, 6.0502829417E+01, 5.6934504245E+00, 4.8498296805E+01, 4.6995164596E+00, 9.8790873897E-01],
	[4.5565000000E+04, 6.0514695271E+01, 5.6935060091E+00, 4.8515875970E+01, 4.6997909267E+00, 9.8791427130E-01],
	[4.5570000000E+04, 6.0526562150E+01, 5.6935615881E+00, 4.8533459577E+01, 4.7000653215E+00, 9.8791980077E-01],
	[4.5575000000E+04, 6.0538430053E+01, 5.6936171617E+00, 4.8551047625E+01, 4.7003396440E+00, 9.8792532736E-01],
	[4.5580000000E+04, 6.0550298981E+01, 5.6936727296E+00, 4.8568640115E+01, 4.7006138944E+00, 9.8793085109E-01],
	[4.5585000000E+04, 6.0562168933E+01, 5.6937282920E+00, 4.8586237048E+01, 4.7008880725E+00, 9.8793637195E-01],
	[4.5590000000E+04, 6.0574039911E+01, 5.6937838489E+00, 4.8603838425E+01, 4.7011621785E+00, 9.8794188996E-01],
	[4.5595000000E+04, 6.0585911913E+01, 5.6938394002E+00, 4.8621444246E+01, 4.7014362124E+00, 9.8794740510E-01],
	[4.5600000000E+04, 6.0597784939E+01, 5.6938949459E+00, 4.8639054512E+01, 4.7017101741E+00, 9.8795291738E-01],
	[4.5605000000E+04, 6.0609658990E+01, 5.6939504861E+00, 4.8656669223E+01, 4.7019840637E+00, 9.8795842680E-01],
	[4.5610000000E+04, 6.0621534066E+01, 5.6940060208E+00, 4.8674288381E+01, 4.7022578813E+00, 9.8796393337E-01],
	[4.5615000000E+04, 6.0633410166E+01, 5.6940615499E+00, 4.8691911985E+01, 4.7025316268E+00, 9.8796943708E-01],
	[4.5620000000E+04, 6.0645287291E+01, 5.6941170734E+00, 4.8709540036E+01, 4.7028053003E+00, 9.8797493794E-01],
	[4.5625000000E+04, 6.0657165440E+01, 5.6941725914E+00, 4.8727172536E+01, 4.7030789018E+00, 9.8798043595E-01],
	[4.5630000000E+04, 6.0669044613E+01, 5.6942281039E+00, 4.8744809484E+01, 4.7033524313E+00, 9.8798593111E-01],
	[4.5635000000E+04, 6.0680924811E+01, 5.6942836109E+00, 4.8762450881E+01, 4.7036258889E+00, 9.8799142342E-01],
	[4.5640000000E+04, 6.0692806034E+01, 5.6943391122E+00, 4.8780096728E+01, 4.7038992745E+00, 9.8799691289E-01],
	[4.5645000000E+04, 6.0704688281E+01, 5.6943946081E+00, 4.8797747026E+01, 4.7041725883E+00, 9.8800239951E-01],
	[4.5650000000E+04, 6.0716571552E+01, 5.6944500984E+00, 4.8815401775E+01, 4.7044458301E+00, 9.8800788329E-01],
	[4.5655000000E+04, 6.0728455848E+01, 5.6945055832E+00, 4.8833060976E+01, 4.7047190002E+00, 9.8801336422E-01],
	[4.5660000000E+04, 6.0740341167E+01, 5.6945610624E+00, 4.8850724629E+01, 4.7049920984E+00, 9.8801884232E-01],
	[4.5665000000E+04, 6.0752227512E+01, 5.6946165361E+00, 4.8868392735E+01, 4.7052651248E+00, 9.8802431758E-01],
	[4.5670000000E+04, 6.0764114880E+01, 5.6946720043E+00, 4.8886065295E+01, 4.7055380794E+00, 9.8802979000E-01],
	[4.5675000000E+04, 6.0776003273E+01, 5.6947274670E+00, 4.8903742309E+01, 4.7058109623E+00, 9.8803525958E-01],
	[4.5680000000E+04, 6.0787892690E+01, 5.6947829241E+00, 4.8921423778E+01, 4.7060837734E+00, 9.8804072634E-01],
	[4.5685000000E+04, 6.0799783131E+01, 5.6948383757E+00, 4.8939109703E+01, 4.7063565128E+00, 9.8804619026E-01],
	[4.5690000000E+04, 6.0811674596E+01, 5.6948938217E+00, 4.8956800084E+01, 4.7066291806E+00, 9.8805165135E-01],
	[4.5695000000E+04, 6.0823567085E+01, 5.6949492622E+00, 4.8974494922E+01, 4.7069017767E+00, 9.8805710961E-01],
	[4.5700000000E+04, 6.0835460599E+01, 5.6950046972E+00, 4.8992194217E+01, 4.7071743012E+00, 9.8806256504E-01],
	[4.5705000000E+04, 6.0847355137E+01, 5.6950601267E+00, 4.9009897971E+01, 4.7074467540E+00, 9.8806801765E-01],
	[4.5710000000E+04, 6.0859250698E+01, 5.6951155507E+00, 4.9027606183E+01, 4.7077191353E+00, 9.8807346744E-01],
	[4.5715000000E+04, 6.0871147284E+01, 5.6951709691E+00, 4.9045318855E+01, 4.7079914450E+00, 9.8807891440E-01],
	[4.5720000000E+04, 6.0883044894E+01, 5.6952263820E+00, 4.9063035987E+01, 4.7082636832E+00, 9.8808435855E-01],
	[4.5725000000E+04, 6.0894943528E+01, 5.6952817894E+00, 4.9080757579E+01, 4.7085358499E+00, 9.8808979987E-01],
	[4.5730000000E+04, 6.0906843186E+01, 5.6953371913E+00, 4.9098483633E+01, 4.7088079451E+00, 9.8809523838E-01],
	[4.5735000000E+04, 6.0918743867E+01, 5.6953925876E+00, 4.9116214149E+01, 4.7090799689E+00, 9.8810067407E-01],
	[4.5740000000E+04, 6.0930645573E+01, 5.6954479784E+00, 4.9133949127E+01, 4.7093519212E+00, 9.8810610695E-01],
	[4.5745000000E+04, 6.0942548303E+01, 5.6955033637E+00, 4.9151688569E+01, 4.7096238020E+00, 9.8811153701E-01],
	[4.5750000000E+04, 6.0954452056E+01, 5.6955587435E+00, 4.9169432474E+01, 4.7098956115E+00, 9.8811696426E-01],
	[4.5755000000E+04, 6.0966356833E+01, 5.6956141178E+00, 4.9187180844E+01, 4.7101673497E+00, 9.8812238871E-01],
	[4.5760000000E+04, 6.0978262635E+01, 5.6956694866E+00, 4.9204933679E+01, 4.7104390165E+00, 9.8812781035E-01],
	[4.5765000000E+04, 6.0990169460E+01, 5.6957248499E+00, 4.9222690980E+01, 4.7107106119E+00, 9.8813322918E-01],
	[4.5770000000E+04, 6.1002077308E+01, 5.6957802076E+00, 4.9240452747E+01, 4.7109821361E+00, 9.8813864520E-01],
	[4.5775000000E+04, 6.1013986181E+01, 5.6958355599E+00, 4.9258218982E+01, 4.7112535891E+00, 9.8814405843E-01],
	[4.5780000000E+04, 6.1025896077E+01, 5.6958909066E+00, 4.9275989683E+01, 4.7115249707E+00, 9.8814946885E-01],
	[4.5785000000E+04, 6.1037806997E+01, 5.6959462478E+00, 4.9293764854E+01, 4.7117962812E+00, 9.8815487647E-01],
	[4.5790000000E+04, 6.1049718941E+01, 5.6960015835E+00, 4.9311544493E+01, 4.7120675205E+00, 9.8816028130E-01],
	[4.5795000000E+04, 6.1061631908E+01, 5.6960569138E+00, 4.9329328601E+01, 4.7123386886E+00, 9.8816568333E-01],
	[4.5800000000E+04, 6.1073545900E+01, 5.6961122385E+00, 4.9347117180E+01, 4.7126097855E+00, 9.8817108256E-01],
	[4.5805000000E+04, 6.1085460914E+01, 5.6961675577E+00, 4.9364910230E+01, 4.7128808113E+00, 9.8817647900E-01],
	[4.5810000000E+04, 6.1097376952E+01, 5.6962228714E+00, 4.9382707751E+01, 4.7131517661E+00, 9.8818187265E-01],
	[4.5815000000E+04, 6.1109294014E+01, 5.6962781796E+00, 4.9400509745E+01, 4.7134226497E+00, 9.8818726351E-01],
	[4.5820000000E+04, 6.1121212100E+01, 5.6963334823E+00, 4.9418316211E+01, 4.7136934623E+00, 9.8819265158E-01],
	[4.5825000000E+04, 6.1133131209E+01, 5.6963887795E+00, 4.9436127150E+01, 4.7139642039E+00, 9.8819803686E-01],
	[4.5830000000E+04, 6.1145051341E+01, 5.6964440713E+00, 4.9453942564E+01, 4.7142348745E+00, 9.8820341936E-01],
	[4.5835000000E+04, 6.1156972497E+01, 5.6964993575E+00, 4.9471762452E+01, 4.7145054741E+00, 9.8820879908E-01],
	[4.5840000000E+04, 6.1168894676E+01, 5.6965546382E+00, 4.9489586815E+01, 4.7147760027E+00, 9.8821417601E-01],
	[4.5845000000E+04, 6.1180817879E+01, 5.6966099134E+00, 4.9507415654E+01, 4.7150464604E+00, 9.8821955016E-01],
	[4.5850000000E+04, 6.1192742105E+01, 5.6966651832E+00, 4.9525248970E+01, 4.7153168473E+00, 9.8822492154E-01],
	[4.5855000000E+04, 6.1204667355E+01, 5.6967204474E+00, 4.9543086763E+01, 4.7155871632E+00, 9.8823029013E-01],
	[4.5860000000E+04, 6.1216593628E+01, 5.6967757062E+00, 4.9560929034E+01, 4.7158574083E+00, 9.8823565595E-01],
	[4.5865000000E+04, 6.1228520924E+01, 5.6968309595E+00, 4.9578775784E+01, 4.7161275825E+00, 9.8824101900E-01],
	[4.5870000000E+04, 6.1240449244E+01, 5.6968862073E+00, 4.9596627012E+01, 4.7163976859E+00, 9.8824637927E-01],
	[4.5875000000E+04, 6.1252378587E+01, 5.6969414496E+00, 4.9614482720E+01, 4.7166677186E+00, 9.8825173678E-01],
	[4.5880000000E+04, 6.1264308953E+01, 5.6969966864E+00, 4.9632342909E+01, 4.7169376805E+00, 9.8825709151E-01],
	[4.5885000000E+04, 6.1276240343E+01, 5.6970519177E+00, 4.9650207579E+01, 4.7172075716E+00, 9.8826244348E-01],
	[4.5890000000E+04, 6.1288172755E+01, 5.6971071436E+00, 4.9668076730E+01, 4.7174773921E+00, 9.8826779268E-01],
	[4.5895000000E+04, 6.1300106191E+01, 5.6971623639E+00, 4.9685950363E+01, 4.7177471418E+00, 9.8827313912E-01],
	[4.5900000000E+04, 6.1312040650E+01, 5.6972175788E+00, 4.9703828480E+01, 4.7180168209E+00, 9.8827848279E-01],
	[4.5905000000E+04, 6.1323976132E+01, 5.6972727882E+00, 4.9721711080E+01, 4.7182864294E+00, 9.8828382370E-01],
	[4.5910000000E+04, 6.1335912638E+01, 5.6973279922E+00, 4.9739598164E+01, 4.7185559672E+00, 9.8828916185E-01],
	[4.5915000000E+04, 6.1347850166E+01, 5.6973831906E+00, 4.9757489733E+01, 4.7188254344E+00, 9.8829449725E-01],
	[4.5920000000E+04, 6.1359788718E+01, 5.6974383836E+00, 4.9775385787E+01, 4.7190948311E+00, 9.8829982989E-01],
	[4.5925000000E+04, 6.1371728292E+01, 5.6974935711E+00, 4.9793286328E+01, 4.7193641572E+00, 9.8830515977E-01],
	[4.5930000000E+04, 6.1383668890E+01, 5.6975487531E+00, 4.9811191355E+01, 4.7196334128E+00, 9.8831048690E-01],
	[4.5935000000E+04, 6.1395610510E+01, 5.6976039297E+00, 4.9829100869E+01, 4.7199025979E+00, 9.8831581128E-01],
	[4.5940000000E+04, 6.1407553154E+01, 5.6976591008E+00, 4.9847014872E+01, 4.7201717126E+00, 9.8832113290E-01],
	[4.5945000000E+04, 6.1419496820E+01, 5.6977142664E+00, 4.9864933363E+01, 4.7204407567E+00, 9.8832645178E-01],
	[4.5950000000E+04, 6.1431441510E+01, 5.6977694265E+00, 4.9882856344E+01, 4.7207097305E+00, 9.8833176792E-01],
	[4.5955000000E+04, 6.1443387222E+01, 5.6978245812E+00, 4.9900783814E+01, 4.7209786339E+00, 9.8833708130E-01],
	[4.5960000000E+04, 6.1455333957E+01, 5.6978797304E+00, 4.9918715775E+01, 4.7212474668E+00, 9.8834239195E-01],
	[4.5965000000E+04, 6.1467281716E+01, 5.6979348742E+00, 4.9936652227E+01, 4.7215162295E+00, 9.8834769985E-01],
	[4.5970000000E+04, 6.1479230497E+01, 5.6979900124E+00, 4.9954593171E+01, 4.7217849218E+00, 9.8835300501E-01],
	[4.5975000000E+04, 6.1491180300E+01, 5.6980451453E+00, 4.9972538607E+01, 4.7220535438E+00, 9.8835830743E-01],
	[4.5980000000E+04, 6.1503131127E+01, 5.6981002726E+00, 4.9990488537E+01, 4.7223220955E+00, 9.8836360711E-01],
	[4.5985000000E+04, 6.1515082976E+01, 5.6981553945E+00, 5.0008442960E+01, 4.7225905769E+00, 9.8836890406E-01],
	[4.5990000000E+04, 6.1527035848E+01, 5.6982105109E+00, 5.0026401877E+01, 4.7228589881E+00, 9.8837419827E-01],
	[4.5995000000E+04, 6.1538989743E+01, 5.6982656219E+00, 5.0044365290E+01, 4.7231273292E+00, 9.8837948975E-01],
	[4.6000000000E+04, 6.1550944661E+01, 5.6983207274E+00, 5.0062333198E+01, 4.7233956000E+00, 9.8838477850E-01],
	[4.6005000000E+04, 6.1562900601E+01, 5.6983758275E+00, 5.0080305602E+01, 4.7236638006E+00, 9.8839006452E-01],
	[4.6010000000E+04, 6.1574857564E+01, 5.6984309221E+00, 5.0098282503E+01, 4.7239319312E+00, 9.8839534781E-01],
	[4.6015000000E+04, 6.1586815549E+01, 5.6984860112E+00, 5.0116263902E+01, 4.7241999916E+00, 9.8840062838E-01],
	[4.6020000000E+04, 6.1598774557E+01, 5.6985410949E+00, 5.0134249799E+01, 4.7244679819E+00, 9.8840590622E-01],
	[4.6025000000E+04, 6.1610734588E+01, 5.6985961732E+00, 5.0152240195E+01, 4.7247359021E+00, 9.8841118134E-01],
	[4.6030000000E+04, 6.1622695641E+01, 5.6986512460E+00, 5.0170235090E+01, 4.7250037523E+00, 9.8841645373E-01],
	[4.6035000000E+04, 6.1634675535E+01, 5.6987076956E+00, 5.0188234485E+01, 4.7252725876E+00, 9.8842172341E-01],
	[4.6040000000E+04, 6.1646661585E+01, 5.6987645374E+00, 5.0206238381E+01, 4.7255416566E+00, 9.8842699037E-01],
	[4.6045000000E+04, 6.1658648664E+01, 5.6988213736E+00, 5.0224246779E+01, 4.7258106557E+00, 9.8843225461E-01],
	[4.6050000000E+04, 6.1670636772E+01, 5.6988782042E+00, 5.0242259678E+01, 4.7260795850E+00, 9.8843751613E-01],
	[4.6055000000E+04, 6.1682625909E+01, 5.6989350292E+00, 5.0260277080E+01, 4.7263484444E+00, 9.8844277494E-01],
	[4.6060000000E+04, 6.1694616074E+01, 5.6989918485E+00, 5.0278298985E+01, 4.7266172340E+00, 9.8844803104E-01],
	[4.6065000000E+04, 6.1706607269E+01, 5.6990486623E+00, 5.0296325394E+01, 4.7268859537E+00, 9.8845328443E-01],
	[4.6070000000E+04, 6.1718599492E+01, 5.6991054705E+00, 5.0314356308E+01, 4.7271546038E+00, 9.8845853511E-01],
	[4.6075000000E+04, 6.1730592744E+01, 5.6991622731E+00, 5.0332391727E+01, 4.7274231840E+00, 9.8846378308E-01],
	[4.6080000000E+04, 6.1742587024E+01, 5.6992190701E+00, 5.0350431651E+01, 4.7276916946E+00, 9.8846902835E-01],
	[4.6085000000E+04, 6.1754582334E+01, 5.6992758615E+00, 5.0368476082E+01, 4.7279601355E+00, 9.8847427091E-01],
	[4.6090000000E+04, 6.1766578672E+01, 5.6993326472E+00, 5.0386525021E+01, 4.7282285066E+00, 9.8847951077E-01],
	[4.6095000000E+04, 6.1778576038E+01, 5.6993894274E+00, 5.0404578466E+01, 4.7284968082E+00, 9.8848474792E-01],
	[4.6100000000E+04, 6.1790574434E+01, 5.6994462020E+00, 5.0422636421E+01, 4.7287650401E+00, 9.8848998238E-01],
	[4.6105000000E+04, 6.1802573858E+01, 5.6995029711E+00, 5.0440698884E+01, 4.7290332024E+00, 9.8849521414E-01],
	[4.6110000000E+04, 6.1814574310E+01, 5.6995597345E+00, 5.0458765856E+01, 4.7293012951E+00, 9.8850044320E-01],
	[4.6115000000E+04, 6.1826575792E+01, 5.6996164923E+00, 5.0476837339E+01, 4.7295693182E+00, 9.8850566957E-01],
	[4.6120000000E+04, 6.1838578301E+01, 5.6996732445E+00, 5.0494913333E+01, 4.7298372719E+00, 9.8851089324E-01],
	[4.6125000000E+04, 6.1850581840E+01, 5.6997299912E+00, 5.0512993839E+01, 4.7301051560E+00, 9.8851611423E-01],
	[4.6130000000E+04, 6.1862586406E+01, 5.6997867323E+00, 5.0531078856E+01, 4.7303729706E+00, 9.8852133252E-01],
	[4.6135000000E+04, 6.1874592002E+01, 5.6998434678E+00, 5.0549168387E+01, 4.7306407158E+00, 9.8852654812E-01],
	[4.6140000000E+04, 6.1886598626E+01, 5.6999001977E+00, 5.0567262431E+01, 4.7309083915E+00, 9.8853176104E-01],
	[4.6145000000E+04, 6.1898606278E+01, 5.6999569220E+00, 5.0585360989E+01, 4.7311759978E+00, 9.8853697127E-01],
	[4.6150000000E+04, 6.1910614958E+01, 5.7000136407E+00, 5.0603464061E+01, 4.7314435348E+00, 9.8854217882E-01],
	[4.6155000000E+04, 6.1922624667E+01, 5.7000703539E+00, 5.0621571649E+01, 4.7317110023E+00, 9.8854738368E-01],
	[4.6160000000E+04, 6.1934635405E+01, 5.7001270614E+00, 5.0639683753E+01, 4.7319784005E+00, 9.8855258586E-01],
	[4.6165000000E+04, 6.1946647170E+01, 5.7001837634E+00, 5.0657800374E+01, 4.7322457294E+00, 9.8855778537E-01],
	[4.6170000000E+04, 6.1958659965E+01, 5.7002404599E+00, 5.0675921512E+01, 4.7325129890E+00, 9.8856298219E-01],
	[4.6175000000E+04, 6.1970673787E+01, 5.7002971507E+00, 5.0694047167E+01, 4.7327801793E+00, 9.8856817634E-01],
	[4.6180000000E+04, 6.1982688638E+01, 5.7003538360E+00, 5.0712177342E+01, 4.7330473004E+00, 9.8857336782E-01],
	[4.6185000000E+04, 6.1994704516E+01, 5.7004105157E+00, 5.0730312035E+01, 4.7333143522E+00, 9.8857855662E-01],
	[4.6190000000E+04, 6.2006721424E+01, 5.7004671898E+00, 5.0748451248E+01, 4.7335813348E+00, 9.8858374275E-01],
	[4.6195000000E+04, 6.2018739359E+01, 5.7005238584E+00, 5.0766594982E+01, 4.7338482483E+00, 9.8858892621E-01],
	[4.6200000000E+04, 6.2030758322E+01, 5.7005805213E+00, 5.0784743237E+01, 4.7341150926E+00, 9.8859410701E-01],
	[4.6205000000E+04, 6.2042778314E+01, 5.7006371787E+00, 5.0802896013E+01, 4.7343818677E+00, 9.8859928513E-01],
	[4.6210000000E+04, 6.2054799334E+01, 5.7006938306E+00, 5.0821053312E+01, 4.7346485738E+00, 9.8860446059E-01],
	[4.6215000000E+04, 6.2066821382E+01, 5.7007504769E+00, 5.0839215134E+01, 4.7349152107E+00, 9.8860963339E-01],
	[4.6220000000E+04, 6.2078844458E+01, 5.7008071176E+00, 5.0857381479E+01, 4.7351817786E+00, 9.8861480352E-01],
	[4.6225000000E+04, 6.2090868562E+01, 5.7008637527E+00, 5.0875552349E+01, 4.7354482775E+00, 9.8861997100E-01],
	[4.6230000000E+04, 6.2102893694E+01, 5.7009203823E+00, 5.0893727744E+01, 4.7357147073E+00, 9.8862513581E-01],
	[4.6235000000E+04, 6.2114919854E+01, 5.7009770064E+00, 5.0911907664E+01, 4.7359810682E+00, 9.8863029797E-01],
	[4.6240000000E+04, 6.2126947042E+01, 5.7010336248E+00, 5.0930092110E+01, 4.7362473600E+00, 9.8863545747E-01],
	[4.6245000000E+04, 6.2138975259E+01, 5.7010902377E+00, 5.0948281083E+01, 4.7365135830E+00, 9.8864061431E-01],
	[4.6250000000E+04, 6.2151004503E+01, 5.7011468451E+00, 5.0966474584E+01, 4.7367797370E+00, 9.8864576851E-01],
	[4.6255000000E+04, 6.2163034775E+01, 5.7012034469E+00, 5.0984672612E+01, 4.7370458221E+00, 9.8865092005E-01],
	[4.6260000000E+04, 6.2175066075E+01, 5.7012600431E+00, 5.1002875170E+01, 4.7373118383E+00, 9.8865606894E-01],
	[4.6265000000E+04, 6.2187098402E+01, 5.7013166338E+00, 5.1021082256E+01, 4.7375777856E+00, 9.8866121518E-01],
	[4.6270000000E+04, 6.2199131758E+01, 5.7013732189E+00, 5.1039293873E+01, 4.7378436642E+00, 9.8866635878E-01],
	[4.6275000000E+04, 6.2211166142E+01, 5.7014297985E+00, 5.1057510020E+01, 4.7381094739E+00, 9.8867149973E-01],
	[4.6280000000E+04, 6.2223201553E+01, 5.7014863725E+00, 5.1075730699E+01, 4.7383752149E+00, 9.8867663804E-01],
	[4.6285000000E+04, 6.2235237992E+01, 5.7015429410E+00, 5.1093955909E+01, 4.7386408871E+00, 9.8868177371E-01],
	[4.6290000000E+04, 6.2247275459E+01, 5.7015995039E+00, 5.1112185652E+01, 4.7389064905E+00, 9.8868690673E-01],
	[4.6295000000E+04, 6.2259313953E+01, 5.7016560612E+00, 5.1130419929E+01, 4.7391720252E+00, 9.8869203712E-01],
	[4.6300000000E+04, 6.2271353476E+01, 5.7017126131E+00, 5.1148658739E+01, 4.7394374913E+00, 9.8869716487E-01],
	[4.6305000000E+04, 6.2283394026E+01, 5.7017691593E+00, 5.1166902083E+01, 4.7397028887E+00, 9.8870228998E-01],
	[4.6310000000E+04, 6.2295435603E+01, 5.7018257001E+00, 5.1185149963E+01, 4.7399682174E+00, 9.8870741246E-01],
	[4.6315000000E+04, 6.2307478209E+01, 5.7018822353E+00, 5.1203402378E+01, 4.7402334775E+00, 9.8871253231E-01],
	[4.6320000000E+04, 6.2319521842E+01, 5.7019387649E+00, 5.1221659330E+01, 4.7404986690E+00, 9.8871764952E-01],
	[4.6325000000E+04, 6.2331566502E+01, 5.7019952890E+00, 5.1239920818E+01, 4.7407637920E+00, 9.8872276410E-01],
	[4.6330000000E+04, 6.2343612190E+01, 5.7020518076E+00, 5.1258186845E+01, 4.7410288463E+00, 9.8872787606E-01],
	[4.6335000000E+04, 6.2355658906E+01, 5.7021083206E+00, 5.1276457409E+01, 4.7412938322E+00, 9.8873298539E-01],
	[4.6340000000E+04, 6.2367706649E+01, 5.7021648281E+00, 5.1294732513E+01, 4.7415587496E+00, 9.8873809210E-01],
	[4.6345000000E+04, 6.2379755420E+01, 5.7022213300E+00, 5.1313012156E+01, 4.7418235984E+00, 9.8874319618E-01],
	[4.6350000000E+04, 6.2391805218E+01, 5.7022778265E+00, 5.1331296339E+01, 4.7420883788E+00, 9.8874829764E-01],
	[4.6355000000E+04, 6.2403856044E+01, 5.7023343173E+00, 5.1349585063E+01, 4.7423530908E+00, 9.8875339647E-01],
	[4.6360000000E+04, 6.2415907897E+01, 5.7023908027E+00, 5.1367878329E+01, 4.7426177344E+00, 9.8875849269E-01],
	[4.6365000000E+04, 6.2427960778E+01, 5.7024472825E+00, 5.1386176136E+01, 4.7428823096E+00, 9.8876358630E-01],
	[4.6370000000E+04, 6.2440014686E+01, 5.7025037568E+00, 5.1404478487E+01, 4.7431468164E+00, 9.8876867728E-01],
	[4.6375000000E+04, 6.2452069621E+01, 5.7025602255E+00, 5.1422785381E+01, 4.7434112548E+00, 9.8877376565E-01],
	[4.6380000000E+04, 6.2464125584E+01, 5.7026166888E+00, 5.1441096818E+01, 4.7436756250E+00, 9.8877885141E-01],
	[4.6385000000E+04, 6.2476182574E+01, 5.7026731465E+00, 5.1459412801E+01, 4.7439399268E+00, 9.8878393456E-01],
	[4.6390000000E+04, 6.2488240591E+01, 5.7027295986E+00, 5.1477733328E+01, 4.7442041604E+00, 9.8878901510E-01],
	[4.6395000000E+04, 6.2500299636E+01, 5.7027860453E+00, 5.1496058402E+01, 4.7444683257E+00, 9.8879409303E-01],
	[4.6400000000E+04, 6.2512359707E+01, 5.7028424864E+00, 5.1514388022E+01, 4.7447324228E+00, 9.8879916835E-01],
	[4.6405000000E+04, 6.2524420807E+01, 5.7028989220E+00, 5.1532722190E+01, 4.7449964517E+00, 9.8880424107E-01],
	[4.6410000000E+04, 6.2536482933E+01, 5.7029553521E+00, 5.1551060905E+01, 4.7452604125E+00, 9.8880931118E-01],
	[4.6415000000E+04, 6.2548546086E+01, 5.7030117766E+00, 5.1569404169E+01, 4.7455243050E+00, 9.8881437869E-01],
	[4.6420000000E+04, 6.2560610267E+01, 5.7030681957E+00, 5.1587751981E+01, 4.7457881294E+00, 9.8881944360E-01],
	[4.6425000000E+04, 6.2572675475E+01, 5.7031246092E+00, 5.1606104344E+01, 4.7460518857E+00, 9.8882450592E-01],
	[4.6430000000E+04, 6.2584741710E+01, 5.7031810172E+00, 5.1624461257E+01, 4.7463155740E+00, 9.8882956563E-01],
	[4.6435000000E+04, 6.2596808971E+01, 5.7032374197E+00, 5.1642822721E+01, 4.7465791941E+00, 9.8883462275E-01],
	[4.6440000000E+04, 6.2608877261E+01, 5.7032938166E+00, 5.1661188736E+01, 4.7468427462E+00, 9.8883967727E-01],
	[4.6445000000E+04, 6.2620946577E+01, 5.7033502081E+00, 5.1679559304E+01, 4.7471062303E+00, 9.8884472920E-01],
	[4.6450000000E+04, 6.2633016920E+01, 5.7034065940E+00, 5.1697934425E+01, 4.7473696464E+00, 9.8884977854E-01],
	[4.6455000000E+04, 6.2645088290E+01, 5.7034629745E+00, 5.1716314100E+01, 4.7476329945E+00, 9.8885482529E-01],
	[4.6460000000E+04, 6.2657160687E+01, 5.7035193494E+00, 5.1734698328E+01, 4.7478962747E+00, 9.8885986945E-01],
	[4.6465000000E+04, 6.2669234111E+01, 5.7035757188E+00, 5.1753087112E+01, 4.7481594870E+00, 9.8886491103E-01],
	[4.6470000000E+04, 6.2681308562E+01, 5.7036320827E+00, 5.1771480451E+01, 4.7484226313E+00, 9.8886995001E-01],
	[4.6475000000E+04, 6.2693384040E+01, 5.7036884411E+00, 5.1789878346E+01, 4.7486857078E+00, 9.8887498642E-01],
	[4.6480000000E+04, 6.2705460544E+01, 5.7037447940E+00, 5.1808280798E+01, 4.7489487164E+00, 9.8888002024E-01],
	[4.6485000000E+04, 6.2717538076E+01, 5.7038011413E+00, 5.1826687807E+01, 4.7492116571E+00, 9.8888505148E-01],
	[4.6490000000E+04, 6.2729616635E+01, 5.7038574832E+00, 5.1845099375E+01, 4.7494745301E+00, 9.8889008014E-01],
	[4.6495000000E+04, 6.2741696220E+01, 5.7039138196E+00, 5.1863515501E+01, 4.7497373352E+00, 9.8889510623E-01],
	[4.6500000000E+04, 6.2753776832E+01, 5.7039701505E+00, 5.1881936186E+01, 4.7500000726E+00, 9.8890012974E-01],
	[4.6505000000E+04, 6.2765858471E+01, 5.7040264758E+00, 5.1900361431E+01, 4.7502627423E+00, 9.8890515067E-01],
	[4.6510000000E+04, 6.2777941136E+01, 5.7040827957E+00, 5.1918791237E+01, 4.7505253442E+00, 9.8891016903E-01],
	[4.6515000000E+04, 6.2790024829E+01, 5.7041391101E+00, 5.1937225604E+01, 4.7507878785E+00, 9.8891518482E-01],
	[4.6520000000E+04, 6.2802109547E+01, 5.7041954190E+00, 5.1955664533E+01, 4.7510503450E+00, 9.8892019804E-01],
	[4.6525000000E+04, 6.2814195293E+01, 5.7042517224E+00, 5.1974108025E+01, 4.7513127439E+00, 9.8892520869E-01],
	[4.6530000000E+04, 6.2826282065E+01, 5.7043080202E+00, 5.1992556080E+01, 4.7515750752E+00, 9.8893021677E-01],
	[4.6535000000E+04, 6.2838369864E+01, 5.7043643126E+00, 5.2011008698E+01, 4.7518373389E+00, 9.8893522228E-01],
	[4.6540000000E+04, 6.2850458690E+01, 5.7044205995E+00, 5.2029465881E+01, 4.7520995350E+00, 9.8894022524E-01],
	[4.6545000000E+04, 6.2862548542E+01, 5.7044768809E+00, 5.2047927629E+01, 4.7523616635E+00, 9.8894522563E-01],
	[4.6550000000E+04, 6.2874639421E+01, 5.7045331569E+00, 5.2066393943E+01, 4.7526237245E+00, 9.8895022345E-01],
	[4.6555000000E+04, 6.2886731326E+01, 5.7045894273E+00, 5.2084864822E+01, 4.7528857179E+00, 9.8895521872E-01],
	[4.6560000000E+04, 6.2898824258E+01, 5.7046456922E+00, 5.2103340269E+01, 4.7531476439E+00, 9.8896021143E-01],
	[4.6565000000E+04, 6.2910918216E+01, 5.7047019517E+00, 5.2121820284E+01, 4.7534095024E+00, 9.8896520159E-01],
	[4.6570000000E+04, 6.2923013201E+01, 5.7047582057E+00, 5.2140304867E+01, 4.7536712935E+00, 9.8897018919E-01],
	[4.6575000000E+04, 6.2935109212E+01, 5.7048144541E+00, 5.2158794018E+01, 4.7539330171E+00, 9.8897517423E-01],
	[4.6580000000E+04, 6.2947206249E+01, 5.7048706971E+00, 5.2177287740E+01, 4.7541946734E+00, 9.8898015673E-01],
	[4.6585000000E+04, 6.2959304313E+01, 5.7049269347E+00, 5.2195786031E+01, 4.7544562622E+00, 9.8898513667E-01],
	[4.6590000000E+04, 6.2971403404E+01, 5.7049831667E+00, 5.2214288893E+01, 4.7547177838E+00, 9.8899011406E-01],
	[4.6595000000E+04, 6.2983503520E+01, 5.7050393932E+00, 5.2232796327E+01, 4.7549792379E+00, 9.8899508891E-01],
	[4.6600000000E+04, 6.2995604663E+01, 5.7050956143E+00, 5.2251308333E+01, 4.7552406248E+00, 9.8900006121E-01],
	[4.6605000000E+04, 6.3007706833E+01, 5.7051518299E+00, 5.2269824911E+01, 4.7555019444E+00, 9.8900503096E-01],
	[4.6610000000E+04, 6.3019810028E+01, 5.7052080400E+00, 5.2288346063E+01, 4.7557631967E+00, 9.8900999818E-01],
	[4.6615000000E+04, 6.3031914250E+01, 5.7052642447E+00, 5.2306871789E+01, 4.7560243818E+00, 9.8901496285E-01],
	[4.6620000000E+04, 6.3044019498E+01, 5.7053204439E+00, 5.2325402089E+01, 4.7562854996E+00, 9.8901992498E-01],
	[4.6625000000E+04, 6.3056125773E+01, 5.7053766376E+00, 5.2343936965E+01, 4.7565465503E+00, 9.8902488457E-01],
	[4.6630000000E+04, 6.3068233073E+01, 5.7054328258E+00, 5.2362476416E+01, 4.7568075338E+00, 9.8902984162E-01],
	[4.6635000000E+04, 6.3080341400E+01, 5.7054890085E+00, 5.2381020444E+01, 4.7570684501E+00, 9.8903479614E-01],
	[4.6640000000E+04, 6.3092450753E+01, 5.7055451858E+00, 5.2399569050E+01, 4.7573292993E+00, 9.8903974813E-01],
	[4.6645000000E+04, 6.3104561132E+01, 5.7056013576E+00, 5.2418122233E+01, 4.7575900814E+00, 9.8904469758E-01],
	[4.6650000000E+04, 6.3116672537E+01, 5.7056575240E+00, 5.2436679995E+01, 4.7578507965E+00, 9.8904964450E-01],
	[4.6655000000E+04, 6.3128784968E+01, 5.7057136849E+00, 5.2455242335E+01, 4.7581114444E+00, 9.8905458889E-01],
	[4.6660000000E+04, 6.3140898425E+01, 5.7057698403E+00, 5.2473809256E+01, 4.7583720254E+00, 9.8905953076E-01],
	[4.6665000000E+04, 6.3153012908E+01, 5.7058259902E+00, 5.2492380757E+01, 4.7586325393E+00, 9.8906447009E-01],
	[4.6670000000E+04, 6.3165128417E+01, 5.7058821347E+00, 5.2510956839E+01, 4.7588929862E+00, 9.8906940690E-01],
	[4.6675000000E+04, 6.3177244952E+01, 5.7059382737E+00, 5.2529537502E+01, 4.7591533662E+00, 9.8907434119E-01],
	[4.6680000000E+04, 6.3189362514E+01, 5.7059944073E+00, 5.2548122748E+01, 4.7594136792E+00, 9.8907927295E-01],
	[4.6685000000E+04, 6.3201481101E+01, 5.7060505354E+00, 5.2566712577E+01, 4.7596739253E+00, 9.8908420219E-01],
	[4.6690000000E+04, 6.3213600714E+01, 5.7061066580E+00, 5.2585306989E+01, 4.7599341044E+00, 9.8908912891E-01],
	[4.6695000000E+04, 6.3225721353E+01, 5.7061627752E+00, 5.2603905986E+01, 4.7601942168E+00, 9.8909405311E-01],
	[4.6700000000E+04, 6.3237843017E+01, 5.7062188870E+00, 5.2622509567E+01, 4.7604542622E+00, 9.8909897480E-01],
	[4.6705000000E+04, 6.3249965708E+01, 5.7062749932E+00, 5.2641117734E+01, 4.7607142408E+00, 9.8910389397E-01],
	[4.6710000000E+04, 6.3262089424E+01, 5.7063310940E+00, 5.2659730487E+01, 4.7609741526E+00, 9.8910881062E-01],
	[4.6715000000E+04, 6.3274214166E+01, 5.7063871894E+00, 5.2678347827E+01, 4.7612339977E+00, 9.8911372476E-01],
	[4.6720000000E+04, 6.3286339934E+01, 5.7064432793E+00, 5.2696969754E+01, 4.7614937759E+00, 9.8911863638E-01],
	[4.6725000000E+04, 6.3298466728E+01, 5.7064993638E+00, 5.2715596269E+01, 4.7617534874E+00, 9.8912354550E-01],
	[4.6730000000E+04, 6.3310594548E+01, 5.7065554428E+00, 5.2734227373E+01, 4.7620131322E+00, 9.8912845210E-01],
	[4.6735000000E+04, 6.3322723393E+01, 5.7066115164E+00, 5.2752863067E+01, 4.7622727103E+00, 9.8913335620E-01],
	[4.6740000000E+04, 6.3334853264E+01, 5.7066675845E+00, 5.2771503350E+01, 4.7625322218E+00, 9.8913825779E-01],
	[4.6745000000E+04, 6.3346984160E+01, 5.7067236471E+00, 5.2790148224E+01, 4.7627916665E+00, 9.8914315687E-01],
	[4.6750000000E+04, 6.3359116082E+01, 5.7067797044E+00, 5.2808797689E+01, 4.7630510447E+00, 9.8914805345E-01],
	[4.6755000000E+04, 6.3371249030E+01, 5.7068357561E+00, 5.2827451746E+01, 4.7633103562E+00, 9.8915294753E-01],
	[4.6760000000E+04, 6.3383383004E+01, 5.7068918025E+00, 5.2846110395E+01, 4.7635696012E+00, 9.8915783910E-01],
	[4.6765000000E+04, 6.3395518003E+01, 5.7069478434E+00, 5.2864773638E+01, 4.7638287796E+00, 9.8916272818E-01],
	[4.6770000000E+04, 6.3407654027E+01, 5.7070038788E+00, 5.2883441474E+01, 4.7640878914E+00, 9.8916761475E-01],
	[4.6775000000E+04, 6.3419804189E+01, 5.7070609028E+00, 5.2902113905E+01, 4.7643477035E+00, 9.8917249883E-01],
	[4.6780000000E+04, 6.3431965317E+01, 5.7071186745E+00, 5.2920790931E+01, 4.7646080301E+00, 9.8917738041E-01],
	[4.6785000000E+04, 6.3444127478E+01, 5.7071764405E+00, 5.2939472553E+01, 4.7648682904E+00, 9.8918225950E-01],
	[4.6790000000E+04, 6.3456290670E+01, 5.7072342010E+00, 5.2958158771E+01, 4.7651284842E+00, 9.8918713609E-01],
	[4.6795000000E+04, 6.3468454894E+01, 5.7072919560E+00, 5.2976849586E+01, 4.7653886118E+00, 9.8919201019E-01],
	[4.6800000000E+04, 6.3480620150E+01, 5.7073497053E+00, 5.2995544999E+01, 4.7656486730E+00, 9.8919688180E-01],
	[4.6805000000E+04, 6.3492786438E+01, 5.7074074490E+00, 5.3014245010E+01, 4.7659086679E+00, 9.8920175092E-01],
	[4.6810000000E+04, 6.3504953757E+01, 5.7074651872E+00, 5.3032949619E+01, 4.7661685965E+00, 9.8920661755E-01],
	[4.6815000000E+04, 6.3517122108E+01, 5.7075229198E+00, 5.3051658829E+01, 4.7664284588E+00, 9.8921148169E-01],
	[4.6820000000E+04, 6.3529291491E+01, 5.7075806468E+00, 5.3070372638E+01, 4.7666882549E+00, 9.8921634335E-01],
	[4.6825000000E+04, 6.3541461905E+01, 5.7076383682E+00, 5.3089091049E+01, 4.7669479848E+00, 9.8922120252E-01],
	[4.6830000000E+04, 6.3553633351E+01, 5.7076960840E+00, 5.3107814061E+01, 4.7672076485E+00, 9.8922605922E-01],
	[4.6835000000E+04, 6.3565805829E+01, 5.7077537942E+00, 5.3126541675E+01, 4.7674672460E+00, 9.8923091342E-01],
	[4.6840000000E+04, 6.3577979338E+01, 5.7078114989E+00, 5.3145273891E+01, 4.7677267774E+00, 9.8923576515E-01],
	[4.6845000000E+04, 6.3590153879E+01, 5.7078691980E+00, 5.3164010712E+01, 4.7679862427E+00, 9.8924061440E-01],
	[4.6850000000E+04, 6.3602329451E+01, 5.7079268915E+00, 5.3182752136E+01, 4.7682456418E+00, 9.8924546118E-01],
	[4.6855000000E+04, 6.3614506055E+01, 5.7079845795E+00, 5.3201498165E+01, 4.7685049749E+00, 9.8925030547E-01],
	[4.6860000000E+04, 6.3626683691E+01, 5.7080422619E+00, 5.3220248799E+01, 4.7687642419E+00, 9.8925514729E-01],
	[4.6865000000E+04, 6.3638862358E+01, 5.7080999387E+00, 5.3239004039E+01, 4.7690234428E+00, 9.8925998664E-01],
	[4.6870000000E+04, 6.3651042056E+01, 5.7081576099E+00, 5.3257763885E+01, 4.7692825778E+00, 9.8926482351E-01],
	[4.6875000000E+04, 6.3663222786E+01, 5.7082152756E+00, 5.3276528339E+01, 4.7695416467E+00, 9.8926965792E-01],
	[4.6880000000E+04, 6.3675404547E+01, 5.7082729357E+00, 5.3295297401E+01, 4.7698006497E+00, 9.8927448985E-01],
	[4.6885000000E+04, 6.3687587340E+01, 5.7083305902E+00, 5.3314071071E+01, 4.7700595867E+00, 9.8927931932E-01],
	[4.6890000000E+04, 6.3699771164E+01, 5.7083882392E+00, 5.3332849350E+01, 4.7703184578E+00, 9.8928414632E-01],
	[4.6895000000E+04, 6.3711956019E+01, 5.7084458826E+00, 5.3351632240E+01, 4.7705772630E+00, 9.8928897085E-01],
	[4.6900000000E+04, 6.3724141905E+01, 5.7085035204E+00, 5.3370419739E+01, 4.7708360023E+00, 9.8929379292E-01],
	[4.6905000000E+04, 6.3736328823E+01, 5.7085611527E+00, 5.3389211850E+01, 4.7710946758E+00, 9.8929861252E-01],
	[4.6910000000E+04, 6.3748516773E+01, 5.7086187794E+00, 5.3408008572E+01, 4.7713532834E+00, 9.8930342967E-01],
	[4.6915000000E+04, 6.3760705753E+01, 5.7086764006E+00, 5.3426809907E+01, 4.7716118252E+00, 9.8930824435E-01],
	[4.6920000000E+04, 6.3772895765E+01, 5.7087340162E+00, 5.3445615854E+01, 4.7718703012E+00, 9.8931305658E-01],
	[4.6925000000E+04, 6.3785086808E+01, 5.7087916262E+00, 5.3464426416E+01, 4.7721287114E+00, 9.8931786634E-01],
	[4.6930000000E+04, 6.3797278882E+01, 5.7088492307E+00, 5.3483241591E+01, 4.7723870559E+00, 9.8932267365E-01],
	[4.6935000000E+04, 6.3809471987E+01, 5.7089068296E+00, 5.3502061382E+01, 4.7726453347E+00, 9.8932747851E-01],
	[4.6940000000E+04, 6.3821666123E+01, 5.7089644230E+00, 5.3520885788E+01, 4.7729035477E+00, 9.8933228091E-01],
	[4.6945000000E+04, 6.3833861291E+01, 5.7090220108E+00, 5.3539714810E+01, 4.7731616951E+00, 9.8933708086E-01],
	[4.6950000000E+04, 6.3846057489E+01, 5.7090795930E+00, 5.3558548449E+01, 4.7734197768E+00, 9.8934187836E-01],
	[4.6955000000E+04, 6.3858254719E+01, 5.7091371697E+00, 5.3577386705E+01, 4.7736777929E+00, 9.8934667341E-01],
	[4.6960000000E+04, 6.3870452980E+01, 5.7091947409E+00, 5.3596229580E+01, 4.7739357433E+00, 9.8935146601E-01],
	[4.6965000000E+04, 6.3882652272E+01, 5.7092523065E+00, 5.3615077073E+01, 4.7741936282E+00, 9.8935625616E-01],
	[4.6970000000E+04, 6.3894852594E+01, 5.7093098666E+00, 5.3633929186E+01, 4.7744514475E+00, 9.8936104387E-01],
	[4.6975000000E+04, 6.3907053948E+01, 5.7093674211E+00, 5.3652785918E+01, 4.7747092012E+00, 9.8936582913E-01],
	[4.6980000000E+04, 6.3919256333E+01, 5.7094249701E+00, 5.3671647272E+01, 4.7749668894E+00, 9.8937061195E-01],
	[4.6985000000E+04, 6.3931459748E+01, 5.7094825135E+00, 5.3690513246E+01, 4.7752245121E+00, 9.8937539233E-01],
	[4.6990000000E+04, 6.3943664195E+01, 5.7095400514E+00, 5.3709383843E+01, 4.7754820693E+00, 9.8938017026E-01],
	[4.6995000000E+04, 6.3955869672E+01, 5.7095975837E+00, 5.3728259062E+01, 4.7757395611E+00, 9.8938494576E-01],
	[4.7000000000E+04, 6.3968076181E+01, 5.7096551105E+00, 5.3747138904E+01, 4.7759969874E+00, 9.8938971882E-01],
	[4.7005000000E+04, 6.3980283720E+01, 5.7097126318E+00, 5.3766023370E+01, 4.7762543483E+00, 9.8939448944E-01],
	[4.7010000000E+04, 6.3992492290E+01, 5.7097701475E+00, 5.3784912461E+01, 4.7765116438E+00, 9.8939925763E-01],
	[4.7015000000E+04, 6.4004701890E+01, 5.7098276577E+00, 5.3803806177E+01, 4.7767688740E+00, 9.8940402339E-01],
	[4.7020000000E+04, 6.4016912522E+01, 5.7098851623E+00, 5.3822704518E+01, 4.7770260387E+00, 9.8940878671E-01],
	[4.7025000000E+04, 6.4029124184E+01, 5.7099426615E+00, 5.3841607486E+01, 4.7772831382E+00, 9.8941354760E-01],
	[4.7030000000E+04, 6.4041336877E+01, 5.7100001550E+00, 5.3860515081E+01, 4.7775401723E+00, 9.8941830606E-01],
	[4.7035000000E+04, 6.4053550601E+01, 5.7100576431E+00, 5.3879427304E+01, 4.7777971412E+00, 9.8942306209E-01],
	[4.7040000000E+04, 6.4065765355E+01, 5.7101151256E+00, 5.3898344155E+01, 4.7780540448E+00, 9.8942781570E-01],
	[4.7045000000E+04, 6.4077981141E+01, 5.7101726026E+00, 5.3917265635E+01, 4.7783108831E+00, 9.8943256688E-01],
	[4.7050000000E+04, 6.4090197956E+01, 5.7102300740E+00, 5.3936191745E+01, 4.7785676563E+00, 9.8943731563E-01],
	[4.7055000000E+04, 6.4102415803E+01, 5.7102875399E+00, 5.3955122485E+01, 4.7788243642E+00, 9.8944206197E-01],
	[4.7060000000E+04, 6.4114634680E+01, 5.7103450003E+00, 5.3974057856E+01, 4.7790810070E+00, 9.8944680587E-01],
	[4.7065000000E+04, 6.4126854587E+01, 5.7104024552E+00, 5.3992997858E+01, 4.7793375846E+00, 9.8945154736E-01],
	[4.7070000000E+04, 6.4139075525E+01, 5.7104599045E+00, 5.4011942493E+01, 4.7795940971E+00, 9.8945628643E-01],
	[4.7075000000E+04, 6.4151297494E+01, 5.7105173484E+00, 5.4030891760E+01, 4.7798505444E+00, 9.8946102308E-01],
	[4.7080000000E+04, 6.4163520493E+01, 5.7105747867E+00, 5.4049845661E+01, 4.7801069267E+00, 9.8946575732E-01],
	[4.7085000000E+04, 6.4175744523E+01, 5.7106322194E+00, 5.4068804196E+01, 4.7803632439E+00, 9.8947048914E-01],
	[4.7090000000E+04, 6.4187969583E+01, 5.7106896467E+00, 5.4087767366E+01, 4.7806194961E+00, 9.8947521854E-01],
	[4.7095000000E+04, 6.4200195673E+01, 5.7107470684E+00, 5.4106735171E+01, 4.7808756833E+00, 9.8947994554E-01],
	[4.7100000000E+04, 6.4212422794E+01, 5.7108044846E+00, 5.4125707612E+01, 4.7811318054E+00, 9.8948467012E-01],
	[4.7105000000E+04, 6.4224650945E+01, 5.7108618953E+00, 5.4144684690E+01, 4.7813878626E+00, 9.8948939229E-01],
	[4.7110000000E+04, 6.4236880127E+01, 5.7109193005E+00, 5.4163666405E+01, 4.7816438548E+00, 9.8949411205E-01],
	[4.7115000000E+04, 6.4249110339E+01, 5.7109767002E+00, 5.4182652758E+01, 4.7818997821E+00, 9.8949882941E-01],
	[4.7120000000E+04, 6.4261341581E+01, 5.7110340943E+00, 5.4201643749E+01, 4.7821556445E+00, 9.8950354436E-01],
	[4.7125000000E+04, 6.4273573854E+01, 5.7110914829E+00, 5.4220639380E+01, 4.7824114420E+00, 9.8950825690E-01],
	[4.7130000000E+04, 6.4285807157E+01, 5.7111488661E+00, 5.4239639651E+01, 4.7826671746E+00, 9.8951296704E-01],
	[4.7135000000E+04, 6.4298041490E+01, 5.7112062437E+00, 5.4258644562E+01, 4.7829228424E+00, 9.8951767478E-01],
	[4.7140000000E+04, 6.4310276854E+01, 5.7112636158E+00, 5.4277654114E+01, 4.7831784453E+00, 9.8952238012E-01],
	[4.7145000000E+04, 6.4322513247E+01, 5.7113209824E+00, 5.4296668308E+01, 4.7834339834E+00, 9.8952708305E-01],
	[4.7150000000E+04, 6.4334750671E+01, 5.7113783435E+00, 5.4315687145E+01, 4.7836894568E+00, 9.8953178359E-01],
	[4.7155000000E+04, 6.4346989125E+01, 5.7114356990E+00, 5.4334710625E+01, 4.7839448654E+00, 9.8953648174E-01],
	[4.7160000000E+04, 6.4359228609E+01, 5.7114930491E+00, 5.4353738748E+01, 4.7842002093E+00, 9.8954117748E-01],
	[4.7165000000E+04, 6.4371469124E+01, 5.7115503937E+00, 5.4372771515E+01, 4.7844554884E+00, 9.8954587084E-01],
	[4.7170000000E+04, 6.4383710668E+01, 5.7116077327E+00, 5.4391808928E+01, 4.7847107029E+00, 9.8955056180E-01],
	[4.7175000000E+04, 6.4395953243E+01, 5.7116650663E+00, 5.4410850986E+01, 4.7849658527E+00, 9.8955525037E-01],
	[4.7180000000E+04, 6.4408196847E+01, 5.7117223944E+00, 5.4429897691E+01, 4.7852209378E+00, 9.8955993654E-01],
	[4.7185000000E+04, 6.4420441482E+01, 5.7117797169E+00, 5.4448949042E+01, 4.7854759583E+00, 9.8956462033E-01],
	[4.7190000000E+04, 6.4432687146E+01, 5.7118370340E+00, 5.4468005041E+01, 4.7857309142E+00, 9.8956930173E-01],
	[4.7195000000E+04, 6.4444933841E+01, 5.7118943456E+00, 5.4487065689E+01, 4.7859858056E+00, 9.8957398075E-01],
	[4.7200000000E+04, 6.4457181565E+01, 5.7119516516E+00, 5.4506130985E+01, 4.7862406323E+00, 9.8957865738E-01],
	[4.7205000000E+04, 6.4469430320E+01, 5.7120089522E+00, 5.4525200930E+01, 4.7864953945E+00, 9.8958333162E-01],
	[4.7210000000E+04, 6.4481680104E+01, 5.7120662473E+00, 5.4544275526E+01, 4.7867500922E+00, 9.8958800349E-01],
	[4.7215000000E+04, 6.4493930919E+01, 5.7121235369E+00, 5.4563354772E+01, 4.7870047254E+00, 9.8959267297E-01],
	[4.7220000000E+04, 6.4506182763E+01, 5.7121808210E+00, 5.4582438670E+01, 4.7872592942E+00, 9.8959734007E-01],
	[4.7225000000E+04, 6.4518435637E+01, 5.7122380996E+00, 5.4601527220E+01, 4.7875137984E+00, 9.8960200479E-01],
	[4.7230000000E+04, 6.4530689541E+01, 5.7122953727E+00, 5.4620620422E+01, 4.7877682383E+00, 9.8960666714E-01],
	[4.7235000000E+04, 6.4542944474E+01, 5.7123526403E+00, 5.4639718278E+01, 4.7880226137E+00, 9.8961132711E-01],
	[4.7240000000E+04, 6.4555200438E+01, 5.7124099025E+00, 5.4658820788E+01, 4.7882769247E+00, 9.8961598471E-01],
	[4.7245000000E+04, 6.4567457431E+01, 5.7124671591E+00, 5.4677927952E+01, 4.7885311714E+00, 9.8962063993E-01],
	[4.7250000000E+04, 6.4579715454E+01, 5.7125244103E+00, 5.4697039772E+01, 4.7887853537E+00, 9.8962529278E-01],
	[4.7255000000E+04, 6.4591974506E+01, 5.7125816560E+00, 5.4716156247E+01, 4.7890394718E+00, 9.8962994326E-01],
	[4.7260000000E+04, 6.4604234589E+01, 5.7126388962E+00, 5.4735277379E+01, 4.7892935255E+00, 9.8963459137E-01],
	[4.7265000000E+04, 6.4616495701E+01, 5.7126961309E+00, 5.4754403169E+01, 4.7895475149E+00, 9.8963923711E-01],
	[4.7270000000E+04, 6.4628757843E+01, 5.7127533601E+00, 5.4773533616E+01, 4.7898014401E+00, 9.8964388049E-01],
	[4.7275000000E+04, 6.4641021014E+01, 5.7128105839E+00, 5.4792668721E+01, 4.7900553010E+00, 9.8964852150E-01],
	[4.7280000000E+04, 6.4653285215E+01, 5.7128678022E+00, 5.4811808485E+01, 4.7903090977E+00, 9.8965316014E-01],
	[4.7285000000E+04, 6.4665550445E+01, 5.7129250150E+00, 5.4830952910E+01, 4.7905628302E+00, 9.8965779642E-01],
	[4.7290000000E+04, 6.4677816705E+01, 5.7129822223E+00, 5.4850101994E+01, 4.7908164986E+00, 9.8966243035E-01],
	[4.7295000000E+04, 6.4690083995E+01, 5.7130394241E+00, 5.4869255740E+01, 4.7910701028E+00, 9.8966706191E-01],
	[4.7300000000E+04, 6.4702352314E+01, 5.7130966205E+00, 5.4888414147E+01, 4.7913236428E+00, 9.8967169111E-01],
	[4.7305000000E+04, 6.4714621663E+01, 5.7131538114E+00, 5.4907577217E+01, 4.7915771188E+00, 9.8967631795E-01],
	[4.7310000000E+04, 6.4726892041E+01, 5.7132109968E+00, 5.4926744950E+01, 4.7918305307E+00, 9.8968094244E-01],
	[4.7315000000E+04, 6.4739163448E+01, 5.7132681768E+00, 5.4945917346E+01, 4.7920838785E+00, 9.8968556457E-01],
	[4.7320000000E+04, 6.4751435885E+01, 5.7133253513E+00, 5.4965094406E+01, 4.7923371623E+00, 9.8969018435E-01],
	[4.7325000000E+04, 6.4763709352E+01, 5.7133825203E+00, 5.4984276131E+01, 4.7925903820E+00, 9.8969480178E-01],
	[4.7330000000E+04, 6.4775983848E+01, 5.7134396839E+00, 5.5003462522E+01, 4.7928435378E+00, 9.8969941686E-01],
	[4.7335000000E+04, 6.4788259373E+01, 5.7134968419E+00, 5.5022653579E+01, 4.7930966296E+00, 9.8970402958E-01],
	[4.7340000000E+04, 6.4800535927E+01, 5.7135539946E+00, 5.5041849302E+01, 4.7933496574E+00, 9.8970863996E-01],
	[4.7345000000E+04, 6.4812813511E+01, 5.7136111417E+00, 5.5061049693E+01, 4.7936026213E+00, 9.8971324799E-01],
	[4.7350000000E+04, 6.4825092124E+01, 5.7136682834E+00, 5.5080254752E+01, 4.7938555213E+00, 9.8971785367E-01],
	[4.7355000000E+04, 6.4837371766E+01, 5.7137254196E+00, 5.5099464480E+01, 4.7941083573E+00, 9.8972245701E-01],
	[4.7360000000E+04, 6.4849652438E+01, 5.7137825504E+00, 5.5118678877E+01, 4.7943611296E+00, 9.8972705801E-01],
	[4.7365000000E+04, 6.4861934139E+01, 5.7138396757E+00, 5.5137897945E+01, 4.7946138379E+00, 9.8973165666E-01],
	[4.7370000000E+04, 6.4874216869E+01, 5.7138967956E+00, 5.5157121682E+01, 4.7948664825E+00, 9.8973625297E-01],
	[4.7375000000E+04, 6.4886500628E+01, 5.7139539099E+00, 5.5176350092E+01, 4.7951190632E+00, 9.8974084695E-01],
	[4.7380000000E+04, 6.4898785416E+01, 5.7140110189E+00, 5.5195583173E+01, 4.7953715802E+00, 9.8974543858E-01],
	[4.7385000000E+04, 6.4911071234E+01, 5.7140681224E+00, 5.5214820926E+01, 4.7956240333E+00, 9.8975002788E-01],
	[4.7390000000E+04, 6.4923358080E+01, 5.7141252204E+00, 5.5234063353E+01, 4.7958764228E+00, 9.8975461485E-01],
	[4.7395000000E+04, 6.4935645956E+01, 5.7141823129E+00, 5.5253310453E+01, 4.7961287485E+00, 9.8975919947E-01],
	[4.7400000000E+04, 6.4947934861E+01, 5.7142394001E+00, 5.5272562229E+01, 4.7963810106E+00, 9.8976378177E-01],
	[4.7405000000E+04, 6.4960224795E+01, 5.7142964817E+00, 5.5291818679E+01, 4.7966332089E+00, 9.8976836173E-01],
	[4.7410000000E+04, 6.4972515757E+01, 5.7143535579E+00, 5.5311079805E+01, 4.7968853436E+00, 9.8977293937E-01],
	[4.7415000000E+04, 6.4984807749E+01, 5.7144106287E+00, 5.5330345607E+01, 4.7971374147E+00, 9.8977751467E-01],
	[4.7420000000E+04, 6.4997100770E+01, 5.7144676940E+00, 5.5349616086E+01, 4.7973894222E+00, 9.8978208765E-01],
	[4.7425000000E+04, 6.5009394820E+01, 5.7145247539E+00, 5.5368891244E+01, 4.7976413660E+00, 9.8978665830E-01],
	[4.7430000000E+04, 6.5021689899E+01, 5.7145818083E+00, 5.5388171079E+01, 4.7978932463E+00, 9.8979122663E-01],
	[4.7435000000E+04, 6.5033986006E+01, 5.7146388573E+00, 5.5407455593E+01, 4.7981450631E+00, 9.8979579263E-01],
	[4.7440000000E+04, 6.5046283143E+01, 5.7146959009E+00, 5.5426744788E+01, 4.7983968163E+00, 9.8980035631E-01],
	[4.7445000000E+04, 6.5058581308E+01, 5.7147529389E+00, 5.5446038662E+01, 4.7986485060E+00, 9.8980491766E-01],
	[4.7450000000E+04, 6.5070880502E+01, 5.7148099716E+00, 5.5465337217E+01, 4.7989001323E+00, 9.8980947670E-01],
	[4.7455000000E+04, 6.5083180725E+01, 5.7148669988E+00, 5.5484640454E+01, 4.7991516951E+00, 9.8981403342E-01],
	[4.7460000000E+04, 6.5095481977E+01, 5.7149240206E+00, 5.5503948373E+01, 4.7994031944E+00, 9.8981858782E-01],
	[4.7465000000E+04, 6.5107784258E+01, 5.7149810369E+00, 5.5523260974E+01, 4.7996546303E+00, 9.8982313991E-01],
	[4.7470000000E+04, 6.5120087567E+01, 5.7150380478E+00, 5.5542578260E+01, 4.7999060028E+00, 9.8982768968E-01],
	[4.7475000000E+04, 6.5132391905E+01, 5.7150950533E+00, 5.5561900229E+01, 4.8001573120E+00, 9.8983223713E-01],
	[4.7480000000E+04, 6.5144697272E+01, 5.7151520533E+00, 5.5581226883E+01, 4.8004085578E+00, 9.8983678228E-01],
	[4.7485000000E+04, 6.5157003668E+01, 5.7152090479E+00, 5.5600558223E+01, 4.8006597402E+00, 9.8984132511E-01],
	[4.7490000000E+04, 6.5169311092E+01, 5.7152660371E+00, 5.5619894248E+01, 4.8009108594E+00, 9.8984586563E-01],
	[4.7495000000E+04, 6.5181619545E+01, 5.7153230208E+00, 5.5639234960E+01, 4.8011619152E+00, 9.8985040385E-01],
	[4.7500000000E+04, 6.5193929026E+01, 5.7153799991E+00, 5.5658580360E+01, 4.8014129078E+00, 9.8985493976E-01],
	[4.7505000000E+04, 6.5206239536E+01, 5.7154369720E+00, 5.5677930447E+01, 4.8016638372E+00, 9.8985947336E-01],
	[4.7510000000E+04, 6.5218551075E+01, 5.7154939394E+00, 5.5697285223E+01, 4.8019147033E+00, 9.8986400466E-01],
	[4.7515000000E+04, 6.5230863642E+01, 5.7155509014E+00, 5.5716644689E+01, 4.8021655062E+00, 9.8986853365E-01],
	[4.7520000000E+04, 6.5243177237E+01, 5.7156078580E+00, 5.5736008844E+01, 4.8024162459E+00, 9.8987306035E-01],
	[4.7525000000E+04, 6.5255491862E+01, 5.7156648092E+00, 5.5755377690E+01, 4.8026669224E+00, 9.8987758474E-01],
	[4.7530000000E+04, 6.5267830094E+01, 5.7157234275E+00, 5.5774751227E+01, 4.8029188392E+00, 9.8988210683E-01],
	[4.7535000000E+04, 6.5280169934E+01, 5.7157820827E+00, 5.5794129455E+01, 4.8031707259E+00, 9.8988662662E-01],
	[4.7540000000E+04, 6.5292510808E+01, 5.7158407323E+00, 5.5813512376E+01, 4.8034225496E+00, 9.8989114412E-01],
	[4.7545000000E+04, 6.5304852718E+01, 5.7158993764E+00, 5.5832899991E+01, 4.8036743102E+00, 9.8989565932E-01],
	[4.7550000000E+04, 6.5317195662E+01, 5.7159580149E+00, 5.5852292299E+01, 4.8039260079E+00, 9.8990017223E-01],
	[4.7555000000E+04, 6.5329539640E+01, 5.7160166478E+00, 5.5871689301E+01, 4.8041776427E+00, 9.8990468285E-01],
	[4.7560000000E+04, 6.5341884654E+01, 5.7160752752E+00, 5.5891090999E+01, 4.8044292144E+00, 9.8990919117E-01],
	[4.7565000000E+04, 6.5354230702E+01, 5.7161338970E+00, 5.5910497392E+01, 4.8046807233E+00, 9.8991369720E-01],
	[4.7570000000E+04, 6.5366577784E+01, 5.7161925132E+00, 5.5929908481E+01, 4.8049321692E+00, 9.8991820094E-01],
	[4.7575000000E+04, 6.5378925901E+01, 5.7162511239E+00, 5.5949324267E+01, 4.8051835523E+00, 9.8992270240E-01],
	[4.7580000000E+04, 6.5391275053E+01, 5.7163097290E+00, 5.5968744751E+01, 4.8054348724E+00, 9.8992720157E-01],
	[4.7585000000E+04, 6.5403625239E+01, 5.7163683286E+00, 5.5988169934E+01, 4.8056861298E+00, 9.8993169845E-01],
	[4.7590000000E+04, 6.5415976460E+01, 5.7164269226E+00, 5.6007599815E+01, 4.8059373243E+00, 9.8993619305E-01],
	[4.7595000000E+04, 6.5428328715E+01, 5.7164855111E+00, 5.6027034395E+01, 4.8061884561E+00, 9.8994068537E-01],
	[4.7600000000E+04, 6.5440682005E+01, 5.7165440940E+00, 5.6046473676E+01, 4.8064395250E+00, 9.8994517541E-01],
	[4.7605000000E+04, 6.5453036330E+01, 5.7166026713E+00, 5.6065917658E+01, 4.8066905312E+00, 9.8994966316E-01],
	[4.7610000000E+04, 6.5465391688E+01, 5.7166612431E+00, 5.6085366341E+01, 4.8069414747E+00, 9.8995414864E-01],
	[4.7615000000E+04, 6.5477748081E+01, 5.7167198094E+00, 5.6104819726E+01, 4.8071923554E+00, 9.8995863184E-01],
	[4.7620000000E+04, 6.5490105509E+01, 5.7167783700E+00, 5.6124277814E+01, 4.8074431735E+00, 9.8996311276E-01],
	[4.7625000000E+04, 6.5502463971E+01, 5.7168369252E+00, 5.6143740605E+01, 4.8076939288E+00, 9.8996759141E-01],
	[4.7630000000E+04, 6.5514823467E+01, 5.7168954748E+00, 5.6163208100E+01, 4.8079446216E+00, 9.8997206778E-01],
	[4.7635000000E+04, 6.5527183998E+01, 5.7169540188E+00, 5.6182680300E+01, 4.8081952517E+00, 9.8997654188E-01],
	[4.7640000000E+04, 6.5539545563E+01, 5.7170125574E+00, 5.6202157205E+01, 4.8084458191E+00, 9.8998101371E-01],
	[4.7645000000E+04, 6.5551908162E+01, 5.7170710903E+00, 5.6221638816E+01, 4.8086963240E+00, 9.8998548327E-01],
	[4.7650000000E+04, 6.5564271796E+01, 5.7171296177E+00, 5.6241125134E+01, 4.8089467664E+00, 9.8998995056E-01],
	[4.7655000000E+04, 6.5576636463E+01, 5.7171881396E+00, 5.6260616159E+01, 4.8091971461E+00, 9.8999441559E-01],
	[4.7660000000E+04, 6.5589002165E+01, 5.7172466559E+00, 5.6280111892E+01, 4.8094474634E+00, 9.8999887835E-01],
	[4.7665000000E+04, 6.5601368901E+01, 5.7173051667E+00, 5.6299612333E+01, 4.8096977181E+00, 9.9000333884E-01],
	[4.7670000000E+04, 6.5613736672E+01, 5.7173636720E+00, 5.6319117484E+01, 4.8099479104E+00, 9.9000779707E-01],
	[4.7675000000E+04, 6.5626105476E+01, 5.7174221717E+00, 5.6338627344E+01, 4.8101980402E+00, 9.9001225304E-01],
	[4.7680000000E+04, 6.5638475315E+01, 5.7174806659E+00, 5.6358141915E+01, 4.8104481076E+00, 9.9001670674E-01],
	[4.7685000000E+04, 6.5650846188E+01, 5.7175391546E+00, 5.6377661197E+01, 4.8106981125E+00, 9.9002115819E-01],
	[4.7690000000E+04, 6.5663218095E+01, 5.7175976377E+00, 5.6397185190E+01, 4.8109480551E+00, 9.9002560738E-01],
	[4.7695000000E+04, 6.5675591036E+01, 5.7176561153E+00, 5.6416713896E+01, 4.8111979352E+00, 9.9003005431E-01],
	[4.7700000000E+04, 6.5687965011E+01, 5.7177145873E+00, 5.6436247315E+01, 4.8114477530E+00, 9.9003449898E-01],
	[4.7705000000E+04, 6.5700340020E+01, 5.7177730538E+00, 5.6455785448E+01, 4.8116975085E+00, 9.9003894140E-01],
	[4.7710000000E+04, 6.5712716063E+01, 5.7178315148E+00, 5.6475328295E+01, 4.8119472017E+00, 9.9004338157E-01],
	[4.7715000000E+04, 6.5725093140E+01, 5.7178899703E+00, 5.6494875857E+01, 4.8121968325E+00, 9.9004781948E-01],
	[4.7720000000E+04, 6.5737471251E+01, 5.7179484202E+00, 5.6514428134E+01, 4.8124464011E+00, 9.9005225515E-01],
	[4.7725000000E+04, 6.5749850395E+01, 5.7180068646E+00, 5.6533985128E+01, 4.8126959074E+00, 9.9005668856E-01],
	[4.7730000000E+04, 6.5762230574E+01, 5.7180653035E+00, 5.6553546839E+01, 4.8129453515E+00, 9.9006111973E-01],
	[4.7735000000E+04, 6.5774611787E+01, 5.7181237368E+00, 5.6573113267E+01, 4.8131947334E+00, 9.9006554865E-01],
	[4.7740000000E+04, 6.5786994034E+01, 5.7181821647E+00, 5.6592684413E+01, 4.8134440531E+00, 9.9006997532E-01],
	[4.7745000000E+04, 6.5799377314E+01, 5.7182405870E+00, 5.6612260278E+01, 4.8136933106E+00, 9.9007439975E-01],
	[4.7750000000E+04, 6.5811761628E+01, 5.7182990038E+00, 5.6631840863E+01, 4.8139425060E+00, 9.9007882193E-01],
	[4.7755000000E+04, 6.5824146976E+01, 5.7183574150E+00, 5.6651426168E+01, 4.8141916393E+00, 9.9008324188E-01],
	[4.7760000000E+04, 6.5836533358E+01, 5.7184158208E+00, 5.6671016193E+01, 4.8144407104E+00, 9.9008765958E-01],
	[4.7765000000E+04, 6.5848920774E+01, 5.7184742210E+00, 5.6690610940E+01, 4.8146897195E+00, 9.9009207504E-01],
	[4.7770000000E+04, 6.5861309223E+01, 5.7185326157E+00, 5.6710210408E+01, 4.8149386665E+00, 9.9009648827E-01],
	[4.7775000000E+04, 6.5873698706E+01, 5.7185910049E+00, 5.6729814600E+01, 4.8151875514E+00, 9.9010089926E-01],
	[4.7780000000E+04, 6.5886089223E+01, 5.7186493886E+00, 5.6749423515E+01, 4.8154363743E+00, 9.9010530801E-01],
	[4.7785000000E+04, 6.5898480773E+01, 5.7187077668E+00, 5.6769037153E+01, 4.8156851352E+00, 9.9010971453E-01],
	[4.7790000000E+04, 6.5910873357E+01, 5.7187661395E+00, 5.6788655516E+01, 4.8159338342E+00, 9.9011411881E-01],
	[4.7795000000E+04, 6.5923266975E+01, 5.7188245066E+00, 5.6808278605E+01, 4.8161824712E+00, 9.9011852087E-01],
	[4.7800000000E+04, 6.5935661627E+01, 5.7188828683E+00, 5.6827906419E+01, 4.8164310462E+00, 9.9012292069E-01],
	[4.7805000000E+04, 6.5948057311E+01, 5.7189412244E+00, 5.6847538960E+01, 4.8166795593E+00, 9.9012731828E-01],
	[4.7810000000E+04, 6.5960454030E+01, 5.7189995750E+00, 5.6867176228E+01, 4.8169280105E+00, 9.9013171365E-01],
	[4.7815000000E+04, 6.5972851782E+01, 5.7190579201E+00, 5.6886818224E+01, 4.8171763999E+00, 9.9013610679E-01],
	[4.7820000000E+04, 6.5985250568E+01, 5.7191162597E+00, 5.6906464949E+01, 4.8174247273E+00, 9.9014049770E-01],
	[4.7825000000E+04, 6.5997650387E+01, 5.7191745938E+00, 5.6926116402E+01, 4.8176729930E+00, 9.9014488639E-01],
	[4.7830000000E+04, 6.6010051239E+01, 5.7192329224E+00, 5.6945772585E+01, 4.8179211968E+00, 9.9014927285E-01],
	[4.7835000000E+04, 6.6022453125E+01, 5.7192912455E+00, 5.6965433499E+01, 4.8181693389E+00, 9.9015365710E-01],
	[4.7840000000E+04, 6.6034856045E+01, 5.7193495631E+00, 5.6985099143E+01, 4.8184174191E+00, 9.9015803912E-01],
	[4.7845000000E+04, 6.6047259997E+01, 5.7194078752E+00, 5.7004769520E+01, 4.8186654376E+00, 9.9016241892E-01],
	[4.7850000000E+04, 6.6059664984E+01, 5.7194661818E+00, 5.7024444628E+01, 4.8189133944E+00, 9.9016679651E-01],
	[4.7855000000E+04, 6.6072071003E+01, 5.7195244829E+00, 5.7044124470E+01, 4.8191612895E+00, 9.9017117188E-01],
	[4.7860000000E+04, 6.6084478056E+01, 5.7195827785E+00, 5.7063809045E+01, 4.8194091228E+00, 9.9017554503E-01],
	[4.7865000000E+04, 6.6096886142E+01, 5.7196410687E+00, 5.7083498354E+01, 4.8196568945E+00, 9.9017991597E-01],
	[4.7870000000E+04, 6.6109295262E+01, 5.7196993533E+00, 5.7103192398E+01, 4.8199046046E+00, 9.9018428470E-01],
	[4.7875000000E+04, 6.6121705415E+01, 5.7197576324E+00, 5.7122891178E+01, 4.8201522530E+00, 9.9018865121E-01],
	[4.7880000000E+04, 6.6134116601E+01, 5.7198159060E+00, 5.7142594694E+01, 4.8203998398E+00, 9.9019301552E-01],
	[4.7885000000E+04, 6.6146528820E+01, 5.7198741742E+00, 5.7162302947E+01, 4.8206473650E+00, 9.9019737761E-01],
	[4.7890000000E+04, 6.6158942073E+01, 5.7199324368E+00, 5.7182015937E+01, 4.8208948287E+00, 9.9020173750E-01],
	[4.7895000000E+04, 6.6171356359E+01, 5.7199906940E+00, 5.7201733665E+01, 4.8211422308E+00, 9.9020609518E-01],
	[4.7900000000E+04, 6.6183771678E+01, 5.7200489456E+00, 5.7221456132E+01, 4.8213895714E+00, 9.9021045066E-01],
	[4.7905000000E+04, 6.6196188030E+01, 5.7201071918E+00, 5.7241183339E+01, 4.8216368505E+00, 9.9021480393E-01],
	[4.7910000000E+04, 6.6208605415E+01, 5.7201654325E+00, 5.7260915285E+01, 4.8218840681E+00, 9.9021915500E-01],
	[4.7915000000E+04, 6.6221023833E+01, 5.7202236677E+00, 5.7280651973E+01, 4.8221312242E+00, 9.9022350386E-01],
	[4.7920000000E+04, 6.6233443285E+01, 5.7202818974E+00, 5.7300393401E+01, 4.8223783189E+00, 9.9022785053E-01],
	[4.7925000000E+04, 6.6245863769E+01, 5.7203401217E+00, 5.7320139572E+01, 4.8226253522E+00, 9.9023219499E-01],
	[4.7930000000E+04, 6.6258285286E+01, 5.7203983404E+00, 5.7339890485E+01, 4.8228723240E+00, 9.9023653726E-01],
	[4.7935000000E+04, 6.6270707837E+01, 5.7204565537E+00, 5.7359646141E+01, 4.8231192345E+00, 9.9024087733E-01],
	[4.7940000000E+04, 6.6283131420E+01, 5.7205147615E+00, 5.7379406541E+01, 4.8233660836E+00, 9.9024521521E-01],
	[4.7945000000E+04, 6.6295556037E+01, 5.7205729638E+00, 5.7399171686E+01, 4.8236128714E+00, 9.9024955089E-01],
	[4.7950000000E+04, 6.6307981686E+01, 5.7206311607E+00, 5.7418941576E+01, 4.8238595979E+00, 9.9025388438E-01],
	[4.7955000000E+04, 6.6320408369E+01, 5.7206893521E+00, 5.7438716212E+01, 4.8241062630E+00, 9.9025821568E-01],
	[4.7960000000E+04, 6.6332836084E+01, 5.7207475380E+00, 5.7458495594E+01, 4.8243528669E+00, 9.9026254479E-01],
	[4.7965000000E+04, 6.6345264832E+01, 5.7208057184E+00, 5.7478279723E+01, 4.8245994095E+00, 9.9026687171E-01],
	[4.7970000000E+04, 6.6357694613E+01, 5.7208638933E+00, 5.7498068601E+01, 4.8248458909E+00, 9.9027119644E-01],
	[4.7975000000E+04, 6.6370125427E+01, 5.7209220628E+00, 5.7517862226E+01, 4.8250923111E+00, 9.9027551898E-01],
	[4.7980000000E+04, 6.6382557274E+01, 5.7209802268E+00, 5.7537660601E+01, 4.8253386701E+00, 9.9027983934E-01],
	[4.7985000000E+04, 6.6394990153E+01, 5.7210383853E+00, 5.7557463725E+01, 4.8255849679E+00, 9.9028415751E-01],
	[4.7990000000E+04, 6.6407424066E+01, 5.7210965384E+00, 5.7577271600E+01, 4.8258312045E+00, 9.9028847350E-01],
	[4.7995000000E+04, 6.6419859011E+01, 5.7211546860E+00, 5.7597084225E+01, 4.8260773800E+00, 9.9029278731E-01],
	[4.8000000000E+04, 6.6432294988E+01, 5.7212128281E+00, 5.7616901603E+01, 4.8263234944E+00, 9.9029709894E-01],
	[4.8005000000E+04, 6.6444731999E+01, 5.7212709648E+00, 5.7636723732E+01, 4.8265695477E+00, 9.9030140839E-01],
	[4.8010000000E+04, 6.6457170042E+01, 5.7213290960E+00, 5.7656550614E+01, 4.8268155400E+00, 9.9030571566E-01],
	[4.8015000000E+04, 6.6469609118E+01, 5.7213872218E+00, 5.7676382250E+01, 4.8270614711E+00, 9.9031002076E-01],
	[4.8020000000E+04, 6.6482049226E+01, 5.7214453420E+00, 5.7696218641E+01, 4.8273073413E+00, 9.9031432368E-01],
	[4.8025000000E+04, 6.6494490367E+01, 5.7215034569E+00, 5.7716059786E+01, 4.8275531504E+00, 9.9031862442E-01],
	[4.8030000000E+04, 6.6506932541E+01, 5.7215615662E+00, 5.7735905686E+01, 4.8277988986E+00, 9.9032292299E-01],
	[4.8035000000E+04, 6.6519375747E+01, 5.7216196701E+00, 5.7755756343E+01, 4.8280445857E+00, 9.9032721939E-01],
	[4.8040000000E+04, 6.6531819986E+01, 5.7216777685E+00, 5.7775611756E+01, 4.8282902119E+00, 9.9033151362E-01],
	[4.8045000000E+04, 6.6544265258E+01, 5.7217358615E+00, 5.7795471927E+01, 4.8285357772E+00, 9.9033580568E-01],
	[4.8050000000E+04, 6.6556711562E+01, 5.7217939491E+00, 5.7815336856E+01, 4.8287812816E+00, 9.9034009558E-01],
	[4.8055000000E+04, 6.6569158898E+01, 5.7218520311E+00, 5.7835206544E+01, 4.8290267251E+00, 9.9034438330E-01],
	[4.8060000000E+04, 6.6581607267E+01, 5.7219101078E+00, 5.7855080991E+01, 4.8292721077E+00, 9.9034866886E-01],
	[4.8065000000E+04, 6.6594056668E+01, 5.7219681789E+00, 5.7874960198E+01, 4.8295174295E+00, 9.9035295226E-01],
	[4.8070000000E+04, 6.6606507102E+01, 5.7220262446E+00, 5.7894844165E+01, 4.8297626905E+00, 9.9035723349E-01],
	[4.8075000000E+04, 6.6618958568E+01, 5.7220843049E+00, 5.7914732894E+01, 4.8300078906E+00, 9.9036151256E-01],
	[4.8080000000E+04, 6.6631411067E+01, 5.7221423597E+00, 5.7934626385E+01, 4.8302530299E+00, 9.9036578947E-01],
	[4.8085000000E+04, 6.6643864598E+01, 5.7222004091E+00, 5.7954524638E+01, 4.8304981085E+00, 9.9037006422E-01],
	[4.8090000000E+04, 6.6656319161E+01, 5.7222584530E+00, 5.7974427655E+01, 4.8307431264E+00, 9.9037433681E-01],
	[4.8095000000E+04, 6.6668774756E+01, 5.7223164915E+00, 5.7994335436E+01, 4.8309880835E+00, 9.9037860725E-01],
	[4.8100000000E+04, 6.6681231384E+01, 5.7223745245E+00, 5.8014247981E+01, 4.8312329799E+00, 9.9038287553E-01],
	[4.8105000000E+04, 6.6693689044E+01, 5.7224325521E+00, 5.8034165291E+01, 4.8314778156E+00, 9.9038714165E-01],
	[4.8110000000E+04, 6.6706147737E+01, 5.7224905742E+00, 5.8054087367E+01, 4.8317225907E+00, 9.9039140563E-01],
	[4.8115000000E+04, 6.6718607461E+01, 5.7225485910E+00, 5.8074014209E+01, 4.8319673051E+00, 9.9039566745E-01],
	[4.8120000000E+04, 6.6731068218E+01, 5.7226066022E+00, 5.8093945819E+01, 4.8322119589E+00, 9.9039992711E-01],
	[4.8125000000E+04, 6.6743530007E+01, 5.7226646080E+00, 5.8113882196E+01, 4.8324565521E+00, 9.9040418463E-01],
	[4.8130000000E+04, 6.6755992829E+01, 5.7227226084E+00, 5.8133823342E+01, 4.8327010847E+00, 9.9040844001E-01],
	[4.8135000000E+04, 6.6768456682E+01, 5.7227806034E+00, 5.8153769256E+01, 4.8329455567E+00, 9.9041269323E-01],
	[4.8140000000E+04, 6.6780921567E+01, 5.7228385929E+00, 5.8173719941E+01, 4.8331899682E+00, 9.9041694431E-01],
	[4.8145000000E+04, 6.6793387485E+01, 5.7228965770E+00, 5.8193675395E+01, 4.8334343192E+00, 9.9042119324E-01],
	[4.8150000000E+04, 6.6805854435E+01, 5.7229545556E+00, 5.8213635621E+01, 4.8336786096E+00, 9.9042544003E-01],
	[4.8155000000E+04, 6.6818322416E+01, 5.7230125288E+00, 5.8233600618E+01, 4.8339228396E+00, 9.9042968468E-01],
	[4.8160000000E+04, 6.6830791430E+01, 5.7230704966E+00, 5.8253570387E+01, 4.8341670092E+00, 9.9043392719E-01],
	[4.8165000000E+04, 6.6843261476E+01, 5.7231284589E+00, 5.8273544930E+01, 4.8344111183E+00, 9.9043816756E-01],
	[4.8170000000E+04, 6.6855732554E+01, 5.7231864158E+00, 5.8293524246E+01, 4.8346551669E+00, 9.9044240579E-01],
	[4.8175000000E+04, 6.6868204663E+01, 5.7232443673E+00, 5.8313508336E+01, 4.8348991552E+00, 9.9044664188E-01],
	[4.8180000000E+04, 6.6880677805E+01, 5.7233023134E+00, 5.8333497201E+01, 4.8351430831E+00, 9.9045087583E-01],
	[4.8185000000E+04, 6.6893151979E+01, 5.7233602540E+00, 5.8353490841E+01, 4.8353869506E+00, 9.9045510765E-01],
	[4.8190000000E+04, 6.6905627184E+01, 5.7234181892E+00, 5.8373489257E+01, 4.8356307578E+00, 9.9045933734E-01],
	[4.8195000000E+04, 6.6918103422E+01, 5.7234761190E+00, 5.8393492451E+01, 4.8358745047E+00, 9.9046356490E-01],
	[4.8200000000E+04, 6.6930580691E+01, 5.7235340434E+00, 5.8413500421E+01, 4.8361181912E+00, 9.9046779032E-01],
	[4.8205000000E+04, 6.6943058992E+01, 5.7235919623E+00, 5.8433513170E+01, 4.8363618175E+00, 9.9047201362E-01],
	[4.8210000000E+04, 6.6955538325E+01, 5.7236498758E+00, 5.8453530697E+01, 4.8366053835E+00, 9.9047623478E-01],
	[4.8215000000E+04, 6.6968018690E+01, 5.7237077839E+00, 5.8473553004E+01, 4.8368488893E+00, 9.9048045382E-01],
	[4.8220000000E+04, 6.6980500086E+01, 5.7237656866E+00, 5.8493580091E+01, 4.8370923349E+00, 9.9048467073E-01],
	[4.8225000000E+04, 6.6992982514E+01, 5.7238235839E+00, 5.8513611958E+01, 4.8373357203E+00, 9.9048888552E-01],
	[4.8230000000E+04, 6.7005465974E+01, 5.7238814757E+00, 5.8533648606E+01, 4.8375790455E+00, 9.9049309818E-01],
	[4.8235000000E+04, 6.7017950466E+01, 5.7239393621E+00, 5.8553690037E+01, 4.8378223105E+00, 9.9049730872E-01],
	[4.8240000000E+04, 6.7030435990E+01, 5.7239972431E+00, 5.8573736250E+01, 4.8380655154E+00, 9.9050151714E-01],
	[4.8245000000E+04, 6.7042922545E+01, 5.7240551187E+00, 5.8593787246E+01, 4.8383086602E+00, 9.9050572344E-01],
	[4.8250000000E+04, 6.7055410131E+01, 5.7241129889E+00, 5.8613843026E+01, 4.8385517448E+00, 9.9050992762E-01],
	[4.8255000000E+04, 6.7067898750E+01, 5.7241708537E+00, 5.8633903591E+01, 4.8387947694E+00, 9.9051412968E-01],
	[4.8260000000E+04, 6.7080388400E+01, 5.7242287131E+00, 5.8653968941E+01, 4.8390377340E+00, 9.9051832963E-01],
	[4.8265000000E+04, 6.7092879081E+01, 5.7242865670E+00, 5.8674039076E+01, 4.8392806385E+00, 9.9052252746E-01],
	[4.8270000000E+04, 6.7105370794E+01, 5.7243444156E+00, 5.8694113998E+01, 4.8395234830E+00, 9.9052672318E-01],
	[4.8275000000E+04, 6.7117863539E+01, 5.7244022587E+00, 5.8714193707E+01, 4.8397662675E+00, 9.9053091678E-01],
	[4.8280000000E+04, 6.7130357315E+01, 5.7244600964E+00, 5.8734278204E+01, 4.8400089920E+00, 9.9053510827E-01],
	[4.8285000000E+04, 6.7142852123E+01, 5.7245179287E+00, 5.8754367489E+01, 4.8402516566E+00, 9.9053929765E-01],
	[4.8290000000E+04, 6.7155347962E+01, 5.7245757557E+00, 5.8774461564E+01, 4.8404942612E+00, 9.9054348493E-01],
	[4.8295000000E+04, 6.7167867095E+01, 5.7246351888E+00, 5.8794560427E+01, 4.8407380739E+00, 9.9054767009E-01],
	[4.8300000000E+04, 6.7180388258E+01, 5.7246946883E+00, 5.8814664082E+01, 4.8409818833E+00, 9.9055185315E-01],
	[4.8305000000E+04, 6.7192910460E+01, 5.7247541822E+00, 5.8834772527E+01, 4.8412256329E+00, 9.9055603410E-01],
	[4.8310000000E+04, 6.7205433698E+01, 5.7248136706E+00, 5.8854885763E+01, 4.8414693227E+00, 9.9056021295E-01],
	[4.8315000000E+04, 6.7217957975E+01, 5.7248731534E+00, 5.8875003792E+01, 4.8417129527E+00, 9.9056438970E-01],
	[4.8320000000E+04, 6.7230483289E+01, 5.7249326307E+00, 5.8895126614E+01, 4.8419565230E+00, 9.9056856434E-01],
	[4.8325000000E+04, 6.7243009640E+01, 5.7249921025E+00, 5.8915254229E+01, 4.8422000335E+00, 9.9057273688E-01],
	[4.8330000000E+04, 6.7255537029E+01, 5.7250515687E+00, 5.8935386639E+01, 4.8424434843E+00, 9.9057690732E-01],
	[4.8335000000E+04, 6.7268065456E+01, 5.7251110295E+00, 5.8955523843E+01, 4.8426868754E+00, 9.9058107567E-01],
	[4.8340000000E+04, 6.7280594920E+01, 5.7251704846E+00, 5.8975665843E+01, 4.8429302068E+00, 9.9058524192E-01],
	[4.8345000000E+04, 6.7293125422E+01, 5.7252299343E+00, 5.8995812639E+01, 4.8431734786E+00, 9.9058940607E-01],
	[4.8350000000E+04, 6.7305656961E+01, 5.7252893784E+00, 5.9015964232E+01, 4.8434166908E+00, 9.9059356813E-01],
	[4.8355000000E+04, 6.7318189538E+01, 5.7253488169E+00, 5.9036120622E+01, 4.8436598433E+00, 9.9059772809E-01],
	[4.8360000000E+04, 6.7330723152E+01, 5.7254082500E+00, 5.9056281810E+01, 4.8439029362E+00, 9.9060188596E-01],
	[4.8365000000E+04, 6.7343257803E+01, 5.7254676775E+00, 5.9076447797E+01, 4.8441459695E+00, 9.9060604174E-01],
	[4.8370000000E+04, 6.7355793492E+01, 5.7255270995E+00, 5.9096618583E+01, 4.8443889433E+00, 9.9061019543E-01],
	[4.8375000000E+04, 6.7368330218E+01, 5.7255865160E+00, 5.9116794169E+01, 4.8446318576E+00, 9.9061434703E-01],
	[4.8380000000E+04, 6.7380867981E+01, 5.7256459269E+00, 5.9136974556E+01, 4.8448747123E+00, 9.9061849655E-01],
	[4.8385000000E+04, 6.7393406782E+01, 5.7257053323E+00, 5.9157159744E+01, 4.8451175075E+00, 9.9062264398E-01],
	[4.8390000000E+04, 6.7405946620E+01, 5.7257647322E+00, 5.9177349734E+01, 4.8453602433E+00, 9.9062678932E-01],
	[4.8395000000E+04, 6.7418487496E+01, 5.7258241266E+00, 5.9197544527E+01, 4.8456029196E+00, 9.9063093258E-01],
	[4.8400000000E+04, 6.7431029408E+01, 5.7258835155E+00, 5.9217744122E+01, 4.8458455364E+00, 9.9063507376E-01],
	[4.8405000000E+04, 6.7443572358E+01, 5.7259428988E+00, 5.9237948522E+01, 4.8460880939E+00, 9.9063921286E-01],
	[4.8410000000E+04, 6.7456116345E+01, 5.7260022766E+00, 5.9258157726E+01, 4.8463305919E+00, 9.9064334987E-01],
	[4.8415000000E+04, 6.7468661370E+01, 5.7260616489E+00, 5.9278371736E+01, 4.8465730306E+00, 9.9064748481E-01],
	[4.8420000000E+04, 6.7481207431E+01, 5.7261210157E+00, 5.9298590551E+01, 4.8468154099E+00, 9.9065161767E-01],
	[4.8425000000E+04, 6.7493754530E+01, 5.7261803770E+00, 5.9318814172E+01, 4.8470577298E+00, 9.9065574845E-01],
	[4.8430000000E+04, 6.7506302666E+01, 5.7262397328E+00, 5.9339042601E+01, 4.8472999905E+00, 9.9065987716E-01],
	[4.8435000000E+04, 6.7518851838E+01, 5.7262990830E+00, 5.9359275837E+01, 4.8475421918E+00, 9.9066400379E-01],
	[4.8440000000E+04, 6.7531402048E+01, 5.7263584277E+00, 5.9379513882E+01, 4.8477843339E+00, 9.9066812835E-01],
	[4.8445000000E+04, 6.7543953295E+01, 5.7264177670E+00, 5.9399756736E+01, 4.8480264167E+00, 9.9067225084E-01],
	[4.8450000000E+04, 6.7556505579E+01, 5.7264771007E+00, 5.9420004399E+01, 4.8482684402E+00, 9.9067637126E-01],
	[4.8455000000E+04, 6.7569058900E+01, 5.7265364289E+00, 5.9440256873E+01, 4.8485104046E+00, 9.9068048961E-01],
	[4.8460000000E+04, 6.7581613259E+01, 5.7265957516E+00, 5.9460514158E+01, 4.8487523097E+00, 9.9068460589E-01],
	[4.8465000000E+04, 6.7594168654E+01, 5.7266550688E+00, 5.9480776254E+01, 4.8489941557E+00, 9.9068872010E-01],
	[4.8470000000E+04, 6.7606725086E+01, 5.7267143805E+00, 5.9501043163E+01, 4.8492359425E+00, 9.9069283225E-01],
	[4.8475000000E+04, 6.7619282554E+01, 5.7267736867E+00, 5.9521314884E+01, 4.8494776701E+00, 9.9069694233E-01],
	[4.8480000000E+04, 6.7631841060E+01, 5.7268329873E+00, 5.9541591419E+01, 4.8497193387E+00, 9.9070105035E-01],
	[4.8485000000E+04, 6.7644400603E+01, 5.7268922825E+00, 5.9561872768E+01, 4.8499609481E+00, 9.9070515631E-01],
	[4.8490000000E+04, 6.7656961183E+01, 5.7269515722E+00, 5.9582158932E+01, 4.8502024984E+00, 9.9070926020E-01],
	[4.8495000000E+04, 6.7669522799E+01, 5.7270108564E+00, 5.9602449912E+01, 4.8504439897E+00, 9.9071336204E-01],
	[4.8500000000E+04, 6.7682085452E+01, 5.7270701351E+00, 5.9622745708E+01, 4.8506854220E+00, 9.9071746182E-01],
	[4.8505000000E+04, 6.7694649143E+01, 5.7271294082E+00, 5.9643046320E+01, 4.8509267952E+00, 9.9072155954E-01],
	[4.8510000000E+04, 6.7707213869E+01, 5.7271886759E+00, 5.9663351750E+01, 4.8511681094E+00, 9.9072565520E-01],
	[4.8515000000E+04, 6.7719779633E+01, 5.7272479381E+00, 5.9683661998E+01, 4.8514093647E+00, 9.9072974881E-01],
	[4.8520000000E+04, 6.7732346433E+01, 5.7273071948E+00, 5.9703977065E+01, 4.8516505609E+00, 9.9073384037E-01],
	[4.8525000000E+04, 6.7744914271E+01, 5.7273664460E+00, 5.9724296951E+01, 4.8518916983E+00, 9.9073792987E-01],
	[4.8530000000E+04, 6.7757483144E+01, 5.7274256917E+00, 5.9744621657E+01, 4.8521327767E+00, 9.9074201732E-01],
	[4.8535000000E+04, 6.7770053055E+01, 5.7274849320E+00, 5.9764951184E+01, 4.8523737962E+00, 9.9074610272E-01],
	[4.8540000000E+04, 6.7782624002E+01, 5.7275441667E+00, 5.9785285532E+01, 4.8526147568E+00, 9.9075018607E-01],
	[4.8545000000E+04, 6.7795195986E+01, 5.7276033959E+00, 5.9805624702E+01, 4.8528556585E+00, 9.9075426738E-01],
	[4.8550000000E+04, 6.7807769006E+01, 5.7276626197E+00, 5.9825968694E+01, 4.8530965014E+00, 9.9075834664E-01],
	[4.8555000000E+04, 6.7820343063E+01, 5.7277218380E+00, 5.9846317510E+01, 4.8533372855E+00, 9.9076242385E-01],
	[4.8560000000E+04, 6.7832918157E+01, 5.7277810508E+00, 5.9866671150E+01, 4.8535780108E+00, 9.9076649902E-01],
	[4.8565000000E+04, 6.7845494287E+01, 5.7278402581E+00, 5.9887029614E+01, 4.8538186772E+00, 9.9077057214E-01],
	[4.8570000000E+04, 6.7858071454E+01, 5.7278994599E+00, 5.9907392903E+01, 4.8540592850E+00, 9.9077464322E-01],
	[4.8575000000E+04, 6.7870649657E+01, 5.7279586562E+00, 5.9927761019E+01, 4.8542998339E+00, 9.9077871226E-01],
	[4.8580000000E+04, 6.7883228896E+01, 5.7280178471E+00, 5.9948133960E+01, 4.8545403242E+00, 9.9078277926E-01],
	[4.8585000000E+04, 6.7895809173E+01, 5.7280770324E+00, 5.9968511729E+01, 4.8547807557E+00, 9.9078684422E-01],
	[4.8590000000E+04, 6.7908390485E+01, 5.7281362123E+00, 5.9988894326E+01, 4.8550211285E+00, 9.9079090715E-01],
	[4.8595000000E+04, 6.7920972834E+01, 5.7281953867E+00, 6.0009281751E+01, 4.8552614427E+00, 9.9079496803E-01],
	[4.8600000000E+04, 6.7933556220E+01, 5.7282545557E+00, 6.0029674005E+01, 4.8555016982E+00, 9.9079902688E-01],
	[4.8605000000E+04, 6.7946140641E+01, 5.7283137191E+00, 6.0050071088E+01, 4.8557418951E+00, 9.9080308370E-01],
	[4.8610000000E+04, 6.7958726100E+01, 5.7283728771E+00, 6.0070473003E+01, 4.8559820334E+00, 9.9080713848E-01],
	[4.8615000000E+04, 6.7971312594E+01, 5.7284320296E+00, 6.0090879748E+01, 4.8562221131E+00, 9.9081119123E-01],
	[4.8620000000E+04, 6.7983900125E+01, 5.7284911767E+00, 6.0111291324E+01, 4.8564621342E+00, 9.9081524195E-01],
	[4.8625000000E+04, 6.7996488692E+01, 5.7285503183E+00, 6.0131707733E+01, 4.8567020968E+00, 9.9081929064E-01],
	[4.8630000000E+04, 6.8009078295E+01, 5.7286094544E+00, 6.0152128975E+01, 4.8569420008E+00, 9.9082333729E-01],
	[4.8635000000E+04, 6.8021668935E+01, 5.7286685850E+00, 6.0172555051E+01, 4.8571818464E+00, 9.9082738192E-01],
	[4.8640000000E+04, 6.8034260611E+01, 5.7287277101E+00, 6.0192985961E+01, 4.8574216334E+00, 9.9083142452E-01],
	[4.8645000000E+04, 6.8046853323E+01, 5.7287868298E+00, 6.0213421705E+01, 4.8576613619E+00, 9.9083546510E-01],
	[4.8650000000E+04, 6.8059447071E+01, 5.7288459441E+00, 6.0233862286E+01, 4.8579010320E+00, 9.9083950365E-01],
	[4.8655000000E+04, 6.8072041856E+01, 5.7289050528E+00, 6.0254307702E+01, 4.8581406437E+00, 9.9084354018E-01],
	[4.8660000000E+04, 6.8084637676E+01, 5.7289641561E+00, 6.0274757955E+01, 4.8583801970E+00, 9.9084757468E-01],
	[4.8665000000E+04, 6.8097234533E+01, 5.7290232540E+00, 6.0295213046E+01, 4.8586196918E+00, 9.9085160716E-01],
	[4.8670000000E+04, 6.8109832426E+01, 5.7290823463E+00, 6.0315672975E+01, 4.8588591283E+00, 9.9085563762E-01],
	[4.8675000000E+04, 6.8122431355E+01, 5.7291414332E+00, 6.0336137742E+01, 4.8590985064E+00, 9.9085966606E-01],
	[4.8680000000E+04, 6.8135031320E+01, 5.7292005147E+00, 6.0356607349E+01, 4.8593378262E+00, 9.9086369248E-01],
	[4.8685000000E+04, 6.8147632321E+01, 5.7292595907E+00, 6.0377081796E+01, 4.8595770877E+00, 9.9086771689E-01],
	[4.8690000000E+04, 6.8160234358E+01, 5.7293186612E+00, 6.0397561084E+01, 4.8598162908E+00, 9.9087173927E-01],
	[4.8695000000E+04, 6.8172837431E+01, 5.7293777263E+00, 6.0418045213E+01, 4.8600554357E+00, 9.9087575965E-01],
	[4.8700000000E+04, 6.8185441540E+01, 5.7294367859E+00, 6.0438534184E+01, 4.8602945224E+00, 9.9087977800E-01],
	[4.8705000000E+04, 6.8198046685E+01, 5.7294958401E+00, 6.0459027997E+01, 4.8605335508E+00, 9.9088379435E-01],
	[4.8710000000E+04, 6.8210652865E+01, 5.7295548888E+00, 6.0479526654E+01, 4.8607725209E+00, 9.9088780868E-01],
	[4.8715000000E+04, 6.8223260082E+01, 5.7296139321E+00, 6.0500030155E+01, 4.8610114329E+00, 9.9089182100E-01],
	[4.8720000000E+04, 6.8235868335E+01, 5.7296729699E+00, 6.0520538500E+01, 4.8612502867E+00, 9.9089583131E-01],
	[4.8725000000E+04, 6.8248477624E+01, 5.7297320022E+00, 6.0541051691E+01, 4.8614890823E+00, 9.9089983961E-01],
	[4.8730000000E+04, 6.8261087948E+01, 5.7297910292E+00, 6.0561569727E+01, 4.8617278198E+00, 9.9090384590E-01],
	[4.8735000000E+04, 6.8273699308E+01, 5.7298500506E+00, 6.0582092611E+01, 4.8619664992E+00, 9.9090785019E-01],
	[4.8740000000E+04, 6.8286311704E+01, 5.7299090666E+00, 6.0602620341E+01, 4.8622051204E+00, 9.9091185247E-01],
	[4.8745000000E+04, 6.8298925136E+01, 5.7299680772E+00, 6.0623152919E+01, 4.8624436836E+00, 9.9091585274E-01],
	[4.8750000000E+04, 6.8311539604E+01, 5.7300270823E+00, 6.0643690345E+01, 4.8626821887E+00, 9.9091985101E-01],
	[4.8755000000E+04, 6.8324155107E+01, 5.7300860820E+00, 6.0664232621E+01, 4.8629206358E+00, 9.9092384728E-01],
	[4.8760000000E+04, 6.8336771646E+01, 5.7301450762E+00, 6.0684779746E+01, 4.8631590248E+00, 9.9092784155E-01],
	[4.8765000000E+04, 6.8349389221E+01, 5.7302040650E+00, 6.0705331722E+01, 4.8633973558E+00, 9.9093183381E-01],
	[4.8770000000E+04, 6.8362007831E+01, 5.7302630484E+00, 6.0725888549E+01, 4.8636356289E+00, 9.9093582408E-01],
	[4.8775000000E+04, 6.8374627478E+01, 5.7303220263E+00, 6.0746450227E+01, 4.8638738439E+00, 9.9093981235E-01],
	[4.8780000000E+04, 6.8387248159E+01, 5.7303809988E+00, 6.0767016758E+01, 4.8641120011E+00, 9.9094379862E-01],
	[4.8785000000E+04, 6.8399869877E+01, 5.7304399658E+00, 6.0787588142E+01, 4.8643501002E+00, 9.9094778289E-01],
	[4.8790000000E+04, 6.8412492630E+01, 5.7304989274E+00, 6.0808164379E+01, 4.8645881415E+00, 9.9095176517E-01],
	[4.8795000000E+04, 6.8425116418E+01, 5.7305578836E+00, 6.0828745471E+01, 4.8648261249E+00, 9.9095574545E-01],
	[4.8800000000E+04, 6.8437741242E+01, 5.7306168343E+00, 6.0849331418E+01, 4.8650640504E+00, 9.9095972374E-01],
	[4.8805000000E+04, 6.8450367102E+01, 5.7306757796E+00, 6.0869922220E+01, 4.8653019181E+00, 9.9096370004E-01],
	[4.8810000000E+04, 6.8462993997E+01, 5.7307347195E+00, 6.0890517878E+01, 4.8655397279E+00, 9.9096767435E-01],
	[4.8815000000E+04, 6.8475621928E+01, 5.7307936539E+00, 6.0911118394E+01, 4.8657774799E+00, 9.9097164667E-01],
	[4.8820000000E+04, 6.8488250894E+01, 5.7308525829E+00, 6.0931723767E+01, 4.8660151742E+00, 9.9097561700E-01],
	[4.8825000000E+04, 6.8500880896E+01, 5.7309115065E+00, 6.0952333998E+01, 4.8662528106E+00, 9.9097958534E-01],
	[4.8830000000E+04, 6.8513511933E+01, 5.7309704247E+00, 6.0972949088E+01, 4.8664903893E+00, 9.9098355169E-01],
	[4.8835000000E+04, 6.8526144005E+01, 5.7310293374E+00, 6.0993569037E+01, 4.8667279103E+00, 9.9098751606E-01],
	[4.8840000000E+04, 6.8538777113E+01, 5.7310882447E+00, 6.1014193846E+01, 4.8669653735E+00, 9.9099147844E-01],
	[4.8845000000E+04, 6.8551411256E+01, 5.7311471465E+00, 6.1034823517E+01, 4.8672027790E+00, 9.9099543884E-01],
	[4.8850000000E+04, 6.8564046434E+01, 5.7312060430E+00, 6.1055458048E+01, 4.8674401269E+00, 9.9099939726E-01],
	[4.8855000000E+04, 6.8576682648E+01, 5.7312649340E+00, 6.1076097442E+01, 4.8676774171E+00, 9.9100335370E-01],
	[4.8860000000E+04, 6.8589319897E+01, 5.7313238196E+00, 6.1096741698E+01, 4.8679146496E+00, 9.9100730815E-01],
	[4.8865000000E+04, 6.8601958182E+01, 5.7313826998E+00, 6.1117390818E+01, 4.8681518246E+00, 9.9101126063E-01],
	[4.8870000000E+04, 6.8614597501E+01, 5.7314415745E+00, 6.1138044802E+01, 4.8683889419E+00, 9.9101521113E-01],
	[4.8875000000E+04, 6.8627237856E+01, 5.7315004439E+00, 6.1158703650E+01, 4.8686260017E+00, 9.9101915965E-01],
	[4.8880000000E+04, 6.8639879246E+01, 5.7315593078E+00, 6.1179367364E+01, 4.8688630039E+00, 9.9102310619E-01],
	[4.8885000000E+04, 6.8652521672E+01, 5.7316181663E+00, 6.1200035943E+01, 4.8690999485E+00, 9.9102705076E-01],
	[4.8890000000E+04, 6.8665165132E+01, 5.7316770194E+00, 6.1220709389E+01, 4.8693368356E+00, 9.9103099335E-01],
	[4.8895000000E+04, 6.8677809628E+01, 5.7317358671E+00, 6.1241387703E+01, 4.8695736652E+00, 9.9103493398E-01],
	[4.8900000000E+04, 6.8690455159E+01, 5.7317947094E+00, 6.1262070884E+01, 4.8698104373E+00, 9.9103887263E-01],
	[4.8905000000E+04, 6.8703101724E+01, 5.7318535462E+00, 6.1282758934E+01, 4.8700471520E+00, 9.9104280931E-01],
	[4.8910000000E+04, 6.8715749325E+01, 5.7319123777E+00, 6.1303451853E+01, 4.8702838092E+00, 9.9104674401E-01],
	[4.8915000000E+04, 6.8728397961E+01, 5.7319712037E+00, 6.1324149642E+01, 4.8705204090E+00, 9.9105067676E-01],
	[4.8920000000E+04, 6.8741047633E+01, 5.7320300243E+00, 6.1344852301E+01, 4.8707569514E+00, 9.9105460753E-01],
	[4.8925000000E+04, 6.8753698339E+01, 5.7320888395E+00, 6.1365559831E+01, 4.8709934363E+00, 9.9105853633E-01],
	[4.8930000000E+04, 6.8766350080E+01, 5.7321476493E+00, 6.1386272233E+01, 4.8712298639E+00, 9.9106246317E-01],
	[4.8935000000E+04, 6.8779002856E+01, 5.7322064537E+00, 6.1406989508E+01, 4.8714662342E+00, 9.9106638805E-01],
	[4.8940000000E+04, 6.8791656667E+01, 5.7322652527E+00, 6.1427711656E+01, 4.8717025471E+00, 9.9107031096E-01],
	[4.8945000000E+04, 6.8804311513E+01, 5.7323240463E+00, 6.1448438677E+01, 4.8719388027E+00, 9.9107423191E-01],
	[4.8950000000E+04, 6.8816967394E+01, 5.7323828345E+00, 6.1469170573E+01, 4.8721750010E+00, 9.9107815090E-01],
	[4.8955000000E+04, 6.8829624310E+01, 5.7324416173E+00, 6.1489907343E+01, 4.8724111420E+00, 9.9108206793E-01],
	[4.8960000000E+04, 6.8842282260E+01, 5.7325003947E+00, 6.1510648990E+01, 4.8726472258E+00, 9.9108598300E-01],
	[4.8965000000E+04, 6.8854941246E+01, 5.7325591667E+00, 6.1531395512E+01, 4.8728832523E+00, 9.9108989611E-01],
	[4.8970000000E+04, 6.8867601266E+01, 5.7326179333E+00, 6.1552146912E+01, 4.8731192216E+00, 9.9109380726E-01],
	[4.8975000000E+04, 6.8880262321E+01, 5.7326766945E+00, 6.1572903189E+01, 4.8733551338E+00, 9.9109771646E-01],
	[4.8980000000E+04, 6.8892924411E+01, 5.7327354502E+00, 6.1593664345E+01, 4.8735909887E+00, 9.9110162370E-01],
	[4.8985000000E+04, 6.8905587536E+01, 5.7327942006E+00, 6.1614430379E+01, 4.8738267865E+00, 9.9110552899E-01],
	[4.8990000000E+04, 6.8918251696E+01, 5.7328529456E+00, 6.1635201293E+01, 4.8740625271E+00, 9.9110943232E-01],
	[4.8995000000E+04, 6.8930916890E+01, 5.7329116853E+00, 6.1655977087E+01, 4.8742982106E+00, 9.9111333371E-01],
	[4.9000000000E+04, 6.8943583119E+01, 5.7329704195E+00, 6.1676757762E+01, 4.8745338370E+00, 9.9111723314E-01],
	[4.9005000000E+04, 6.8956250383E+01, 5.7330291483E+00, 6.1697543318E+01, 4.8747694063E+00, 9.9112113062E-01],
	[4.9010000000E+04, 6.8968918681E+01, 5.7330878717E+00, 6.1718333757E+01, 4.8750049185E+00, 9.9112502615E-01],
	[4.9015000000E+04, 6.8981588014E+01, 5.7331465898E+00, 6.1739129078E+01, 4.8752403737E+00, 9.9112891974E-01],
	[4.9020000000E+04, 6.8994258381E+01, 5.7332053024E+00, 6.1759929283E+01, 4.8754757719E+00, 9.9113281138E-01],
	[4.9025000000E+04, 6.9006929784E+01, 5.7332640097E+00, 6.1780734372E+01, 4.8757111131E+00, 9.9113670107E-01],
	[4.9030000000E+04, 6.9019602220E+01, 5.7333227116E+00, 6.1801544346E+01, 4.8759463972E+00, 9.9114058882E-01],
	[4.9035000000E+04, 6.9032275692E+01, 5.7333814081E+00, 6.1822359205E+01, 4.8761816244E+00, 9.9114447463E-01],
	[4.9040000000E+04, 6.9044950198E+01, 5.7334400992E+00, 6.1843178950E+01, 4.8764167946E+00, 9.9114835849E-01],
	[4.9045000000E+04, 6.9057625738E+01, 5.7334987850E+00, 6.1864003581E+01, 4.8766519080E+00, 9.9115224041E-01],
	[4.9050000000E+04, 6.9070302313E+01, 5.7335574653E+00, 6.1884833100E+01, 4.8768869643E+00, 9.9115612039E-01],
	[4.9055000000E+04, 6.9082979922E+01, 5.7336161403E+00, 6.1905667507E+01, 4.8771219638E+00, 9.9115999843E-01],
	[4.9060000000E+04, 6.9095658566E+01, 5.7336748099E+00, 6.1926506803E+01, 4.8773569065E+00, 9.9116387454E-01],
	[4.9065000000E+04, 6.9108338245E+01, 5.7337334741E+00, 6.1947350987E+01, 4.8775917922E+00, 9.9116774870E-01],
	[4.9070000000E+04, 6.9121030075E+01, 5.7337929195E+00, 6.1968200062E+01, 4.8778272458E+00, 9.9117162094E-01],
	[4.9075000000E+04, 6.9133735183E+01, 5.7338532255E+00, 6.1989054028E+01, 4.8780633302E+00, 9.9117549123E-01],
	[4.9080000000E+04, 6.9146441332E+01, 5.7339135259E+00, 6.2009912884E+01, 4.8782993580E+00, 9.9117935959E-01],
	[4.9085000000E+04, 6.9159148522E+01, 5.7339738209E+00, 6.2030776632E+01, 4.8785353290E+00, 9.9118322602E-01],
	[4.9090000000E+04, 6.9171856753E+01, 5.7340341103E+00, 6.2051645273E+01, 4.8787712433E+00, 9.9118709052E-01],
	[4.9095000000E+04, 6.9184566023E+01, 5.7340943943E+00, 6.2072518807E+01, 4.8790071008E+00, 9.9119095308E-01],
	[4.9100000000E+04, 6.9197276335E+01, 5.7341546727E+00, 6.2093397235E+01, 4.8792429018E+00, 9.9119481372E-01],
	[4.9105000000E+04, 6.9209987686E+01, 5.7342149456E+00, 6.2114280557E+01, 4.8794786460E+00, 9.9119867242E-01],
	[4.9110000000E+04, 6.9222700079E+01, 5.7342752130E+00, 6.2135168775E+01, 4.8797143337E+00, 9.9120252920E-01],
	[4.9115000000E+04, 6.9235413511E+01, 5.7343354750E+00, 6.2156061888E+01, 4.8799499647E+00, 9.9120638405E-01],
	[4.9120000000E+04, 6.9248127984E+01, 5.7343957314E+00, 6.2176959897E+01, 4.8801855391E+00, 9.9121023698E-01],
	[4.9125000000E+04, 6.9260843498E+01, 5.7344559823E+00, 6.2197862804E+01, 4.8804210569E+00, 9.9121408798E-01],
	[4.9130000000E+04, 6.9273560052E+01, 5.7345162277E+00, 6.2218770608E+01, 4.8806565182E+00, 9.9121793706E-01],
	[4.9135000000E+04, 6.9286277646E+01, 5.7345764676E+00, 6.2239683311E+01, 4.8808919229E+00, 9.9122178422E-01],
	[4.9140000000E+04, 6.9298996280E+01, 5.7346367021E+00, 6.2260600913E+01, 4.8811272711E+00, 9.9122562945E-01],
	[4.9145000000E+04, 6.9311715955E+01, 5.7346969310E+00, 6.2281523414E+01, 4.8813625628E+00, 9.9122947276E-01],
	[4.9150000000E+04, 6.9324436670E+01, 5.7347571544E+00, 6.2302450815E+01, 4.8815977980E+00, 9.9123331416E-01],
	[4.9155000000E+04, 6.9337158425E+01, 5.7348173724E+00, 6.2323383118E+01, 4.8818329768E+00, 9.9123715363E-01],
	[4.9160000000E+04, 6.9349881221E+01, 5.7348775848E+00, 6.2344320322E+01, 4.8820680990E+00, 9.9124099119E-01],
	[4.9165000000E+04, 6.9362605057E+01, 5.7349377918E+00, 6.2365262428E+01, 4.8823031649E+00, 9.9124482683E-01],
	[4.9170000000E+04, 6.9375329933E+01, 5.7349979932E+00, 6.2386209437E+01, 4.8825381744E+00, 9.9124866056E-01],
	[4.9175000000E+04, 6.9388055849E+01, 5.7350581892E+00, 6.2407161350E+01, 4.8827731274E+00, 9.9125249237E-01],
	[4.9180000000E+04, 6.9400782805E+01, 5.7351183797E+00, 6.2428118167E+01, 4.8830080241E+00, 9.9125632227E-01],
	[4.9185000000E+04, 6.9413510801E+01, 5.7351785647E+00, 6.2449079889E+01, 4.8832428644E+00, 9.9126015026E-01],
	[4.9190000000E+04, 6.9426239838E+01, 5.7352387442E+00, 6.2470046516E+01, 4.8834776484E+00, 9.9126397634E-01],
	[4.9195000000E+04, 6.9438969915E+01, 5.7352989182E+00, 6.2491018049E+01, 4.8837123761E+00, 9.9126780050E-01],
	[4.9200000000E+04, 6.9451701031E+01, 5.7353590868E+00, 6.2511994489E+01, 4.8839470475E+00, 9.9127162276E-01],
	[4.9205000000E+04, 6.9464433188E+01, 5.7354192498E+00, 6.2532975837E+01, 4.8841816626E+00, 9.9127544311E-01],
	[4.9210000000E+04, 6.9477166385E+01, 5.7354794074E+00, 6.2553962093E+01, 4.8844162214E+00, 9.9127926155E-01],
	[4.9215000000E+04, 6.9489900622E+01, 5.7355395595E+00, 6.2574953257E+01, 4.8846507240E+00, 9.9128307809E-01],
	[4.9220000000E+04, 6.9502635899E+01, 5.7355997061E+00, 6.2595949331E+01, 4.8848851704E+00, 9.9128689272E-01],
	[4.9225000000E+04, 6.9515372215E+01, 5.7356598472E+00, 6.2616950314E+01, 4.8851195606E+00, 9.9129070545E-01],
	[4.9230000000E+04, 6.9528109572E+01, 5.7357199829E+00, 6.2637956209E+01, 4.8853538946E+00, 9.9129451627E-01],
	[4.9235000000E+04, 6.9540847969E+01, 5.7357801131E+00, 6.2658967014E+01, 4.8855881724E+00, 9.9129832520E-01],
	[4.9240000000E+04, 6.9553587405E+01, 5.7358402378E+00, 6.2679982732E+01, 4.8858223940E+00, 9.9130213222E-01],
	[4.9245000000E+04, 6.9566327882E+01, 5.7359003570E+00, 6.2701003362E+01, 4.8860565596E+00, 9.9130593734E-01],
	[4.9250000000E+04, 6.9579069398E+01, 5.7359604708E+00, 6.2722028906E+01, 4.8862906690E+00, 9.9130974057E-01],
	[4.9255000000E+04, 6.9591811954E+01, 5.7360205791E+00, 6.2743059363E+01, 4.8865247223E+00, 9.9131354189E-01],
	[4.9260000000E+04, 6.9604555550E+01, 5.7360806819E+00, 6.2764094736E+01, 4.8867587195E+00, 9.9131734132E-01],
	[4.9265000000E+04, 6.9617300186E+01, 5.7361407792E+00, 6.2785135023E+01, 4.8869926607E+00, 9.9132113886E-01],
	[4.9270000000E+04, 6.9630045861E+01, 5.7362008711E+00, 6.2806180226E+01, 4.8872265459E+00, 9.9132493450E-01],
	[4.9275000000E+04, 6.9642792577E+01, 5.7362609575E+00, 6.2827230346E+01, 4.8874603750E+00, 9.9132872825E-01],
	[4.9280000000E+04, 6.9655540332E+01, 5.7363210384E+00, 6.2848285382E+01, 4.8876941482E+00, 9.9133252010E-01],
	[4.9285000000E+04, 6.9668289127E+01, 5.7363811139E+00, 6.2869345337E+01, 4.8879278653E+00, 9.9133631006E-01],
	[4.9290000000E+04, 6.9681038961E+01, 5.7364411839E+00, 6.2890410210E+01, 4.8881615265E+00, 9.9134009814E-01],
	[4.9295000000E+04, 6.9693789835E+01, 5.7365012484E+00, 6.2911480002E+01, 4.8883951317E+00, 9.9134388432E-01],
	[4.9300000000E+04, 6.9706541749E+01, 5.7365613075E+00, 6.2932554714E+01, 4.8886286811E+00, 9.9134766862E-01],
	[4.9305000000E+04, 6.9719294703E+01, 5.7366213611E+00, 6.2953634346E+01, 4.8888621745E+00, 9.9135145103E-01],
	[4.9310000000E+04, 6.9732048696E+01, 5.7366814093E+00, 6.2974718900E+01, 4.8890956120E+00, 9.9135523155E-01],
	[4.9315000000E+04, 6.9744803728E+01, 5.7367414520E+00, 6.2995808375E+01, 4.8893289936E+00, 9.9135901018E-01],
	[4.9320000000E+04, 6.9757559801E+01, 5.7368014892E+00, 6.3016902772E+01, 4.8895623194E+00, 9.9136278694E-01],
	[4.9325000000E+04, 6.9770316912E+01, 5.7368615210E+00, 6.3038002093E+01, 4.8897955894E+00, 9.9136656181E-01],
	[4.9330000000E+04, 6.9783075064E+01, 5.7369215473E+00, 6.3059106337E+01, 4.8900288036E+00, 9.9137033480E-01],
	[4.9335000000E+04, 6.9795834255E+01, 5.7369815682E+00, 6.3080215505E+01, 4.8902619619E+00, 9.9137410590E-01],
	[4.9340000000E+04, 6.9808594485E+01, 5.7370415836E+00, 6.3101329599E+01, 4.8904950645E+00, 9.9137787513E-01],
	[4.9345000000E+04, 6.9821355755E+01, 5.7371015935E+00, 6.3122448618E+01, 4.8907281113E+00, 9.9138164248E-01],
	[4.9350000000E+04, 6.9834118064E+01, 5.7371615981E+00, 6.3143572563E+01, 4.8909611024E+00, 9.9138540795E-01],
	[4.9355000000E+04, 6.9846881413E+01, 5.7372215971E+00, 6.3164701435E+01, 4.8911940377E+00, 9.9138917154E-01],
	[4.9360000000E+04, 6.9859645801E+01, 5.7372815907E+00, 6.3185835235E+01, 4.8914269174E+00, 9.9139293326E-01],
	[4.9365000000E+04, 6.9872411228E+01, 5.7373415789E+00, 6.3206973963E+01, 4.8916597413E+00, 9.9139669310E-01],
	[4.9370000000E+04, 6.9885177695E+01, 5.7374015616E+00, 6.3228117619E+01, 4.8918925096E+00, 9.9140045107E-01],
	[4.9375000000E+04, 6.9897945202E+01, 5.7374615388E+00, 6.3249266206E+01, 4.8921252223E+00, 9.9140420716E-01],
	[4.9380000000E+04, 6.9910713747E+01, 5.7375215106E+00, 6.3270419722E+01, 4.8923578793E+00, 9.9140796139E-01],
	[4.9385000000E+04, 6.9923483332E+01, 5.7375814770E+00, 6.3291578169E+01, 4.8925904807E+00, 9.9141171374E-01],
	[4.9390000000E+04, 6.9936253956E+01, 5.7376414379E+00, 6.3312741548E+01, 4.8928230265E+00, 9.9141546423E-01],
	[4.9395000000E+04, 6.9949025620E+01, 5.7377013934E+00, 6.3333909858E+01, 4.8930555167E+00, 9.9141921284E-01],
	[4.9400000000E+04, 6.9961798322E+01, 5.7377613434E+00, 6.3355083102E+01, 4.8932879514E+00, 9.9142295959E-01],
	[4.9405000000E+04, 6.9974572064E+01, 5.7378212880E+00, 6.3376261279E+01, 4.8935203305E+00, 9.9142670447E-01],
	[4.9410000000E+04, 6.9987346845E+01, 5.7378812272E+00, 6.3397444390E+01, 4.8937526542E+00, 9.9143044749E-01],
	[4.9415000000E+04, 7.0000122665E+01, 5.7379411609E+00, 6.3418632435E+01, 4.8939849223E+00, 9.9143418864E-01],
	[4.9420000000E+04, 7.0012899525E+01, 5.7380010891E+00, 6.3439825416E+01, 4.8942171349E+00, 9.9143792792E-01],
	[4.9425000000E+04, 7.0025677423E+01, 5.7380610120E+00, 6.3461023333E+01, 4.8944492921E+00, 9.9144166535E-01],
	[4.9430000000E+04, 7.0038456361E+01, 5.7381209294E+00, 6.3482226187E+01, 4.8946813938E+00, 9.9144540091E-01],
	[4.9435000000E+04, 7.0051236338E+01, 5.7381808413E+00, 6.3503433978E+01, 4.8949134401E+00, 9.9144913462E-01],
	[4.9440000000E+04, 7.0064017354E+01, 5.7382407479E+00, 6.3524646706E+01, 4.8951454310E+00, 9.9145286646E-01],
	[4.9445000000E+04, 7.0076799409E+01, 5.7383006490E+00, 6.3545864374E+01, 4.8953773665E+00, 9.9145659644E-01],
	[4.9450000000E+04, 7.0089582503E+01, 5.7383605446E+00, 6.3567086981E+01, 4.8956092466E+00, 9.9146032457E-01],
	[4.9455000000E+04, 7.0102366636E+01, 5.7384204349E+00, 6.3588314527E+01, 4.8958410714E+00, 9.9146405084E-01],
	[4.9460000000E+04, 7.0115151808E+01, 5.7384803197E+00, 6.3609547014E+01, 4.8960728408E+00, 9.9146777526E-01],
	[4.9465000000E+04, 7.0127938019E+01, 5.7385401991E+00, 6.3630784442E+01, 4.8963045549E+00, 9.9147149782E-01],
	[4.9470000000E+04, 7.0140725269E+01, 5.7386000730E+00, 6.3652026813E+01, 4.8965362137E+00, 9.9147521853E-01],
	[4.9475000000E+04, 7.0153513558E+01, 5.7386599415E+00, 6.3673274125E+01, 4.8967678173E+00, 9.9147893739E-01],
	[4.9480000000E+04, 7.0166302885E+01, 5.7387198046E+00, 6.3694526381E+01, 4.8969993656E+00, 9.9148265439E-01],
	[4.9485000000E+04, 7.0179093252E+01, 5.7387796623E+00, 6.3715783581E+01, 4.8972308586E+00, 9.9148636955E-01],
	[4.9490000000E+04, 7.0191884658E+01, 5.7388395146E+00, 6.3737045725E+01, 4.8974622964E+00, 9.9149008285E-01],
	[4.9495000000E+04, 7.0204677102E+01, 5.7388993614E+00, 6.3758312814E+01, 4.8976936790E+00, 9.9149379431E-01],
	[4.9500000000E+04, 7.0217470585E+01, 5.7389592028E+00, 6.3779584848E+01, 4.8979250064E+00, 9.9149750392E-01],
	[4.9505000000E+04, 7.0230265107E+01, 5.7390190388E+00, 6.3800861830E+01, 4.8981562786E+00, 9.9150121169E-01],
	[4.9510000000E+04, 7.0243060668E+01, 5.7390788694E+00, 6.3822143758E+01, 4.8983874957E+00, 9.9150491761E-01],
	[4.9515000000E+04, 7.0255857268E+01, 5.7391386945E+00, 6.3843430634E+01, 4.8986186577E+00, 9.9150862168E-01],
	[4.9520000000E+04, 7.0268654906E+01, 5.7391985142E+00, 6.3864722458E+01, 4.8988497645E+00, 9.9151232392E-01],
	[4.9525000000E+04, 7.0281453583E+01, 5.7392583286E+00, 6.3886019232E+01, 4.8990808162E+00, 9.9151602431E-01],
	[4.9530000000E+04, 7.0294253299E+01, 5.7393181375E+00, 6.3907320955E+01, 4.8993118129E+00, 9.9151972286E-01],
	[4.9535000000E+04, 7.0307054054E+01, 5.7393779409E+00, 6.3928627628E+01, 4.8995427545E+00, 9.9152341957E-01],
	[4.9540000000E+04, 7.0319855847E+01, 5.7394377390E+00, 6.3949939252E+01, 4.8997736410E+00, 9.9152711444E-01],
	[4.9545000000E+04, 7.0332658679E+01, 5.7394975317E+00, 6.3971255828E+01, 4.9000044725E+00, 9.9153080747E-01],
	[4.9550000000E+04, 7.0345462549E+01, 5.7395573189E+00, 6.3992577356E+01, 4.9002352491E+00, 9.9153449867E-01],
	[4.9555000000E+04, 7.0358267458E+01, 5.7396171008E+00, 6.4013903837E+01, 4.9004659706E+00, 9.9153818803E-01],
	[4.9560000000E+04, 7.0371073406E+01, 5.7396768772E+00, 6.4035235271E+01, 4.9006966372E+00, 9.9154187555E-01],
	[4.9565000000E+04, 7.0383880392E+01, 5.7397366482E+00, 6.4056571660E+01, 4.9009272488E+00, 9.9154556124E-01],
	[4.9570000000E+04, 7.0396688417E+01, 5.7397964138E+00, 6.4077913003E+01, 4.9011578054E+00, 9.9154924510E-01],
	[4.9575000000E+04, 7.0409497480E+01, 5.7398561740E+00, 6.4099259302E+01, 4.9013883072E+00, 9.9155292713E-01],
	[4.9580000000E+04, 7.0422307582E+01, 5.7399159288E+00, 6.4120610558E+01, 4.9016187541E+00, 9.9155660732E-01],
	[4.9585000000E+04, 7.0435118722E+01, 5.7399756782E+00, 6.4141966769E+01, 4.9018491460E+00, 9.9156028569E-01],
	[4.9590000000E+04, 7.0447930901E+01, 5.7400354222E+00, 6.4163327939E+01, 4.9020794832E+00, 9.9156396222E-01],
	[4.9595000000E+04, 7.0460744118E+01, 5.7400951608E+00, 6.4184694066E+01, 4.9023097654E+00, 9.9156763693E-01],
	[4.9600000000E+04, 7.0473558374E+01, 5.7401548940E+00, 6.4206065153E+01, 4.9025399929E+00, 9.9157130982E-01],
	[4.9605000000E+04, 7.0486373668E+01, 5.7402146218E+00, 6.4227441198E+01, 4.9027701655E+00, 9.9157498087E-01],
	[4.9610000000E+04, 7.0499190000E+01, 5.7402743442E+00, 6.4248822204E+01, 4.9030002834E+00, 9.9157865011E-01],
	[4.9615000000E+04, 7.0512007371E+01, 5.7403340612E+00, 6.4270208170E+01, 4.9032303465E+00, 9.9158231751E-01],
	[4.9620000000E+04, 7.0524825780E+01, 5.7403937728E+00, 6.4291599098E+01, 4.9034603548E+00, 9.9158598310E-01],
	[4.9625000000E+04, 7.0537645227E+01, 5.7404534790E+00, 6.4312994988E+01, 4.9036903084E+00, 9.9158964686E-01],
	[4.9630000000E+04, 7.0550465713E+01, 5.7405131799E+00, 6.4334395840E+01, 4.9039202073E+00, 9.9159330881E-01],
	[4.9635000000E+04, 7.0563287237E+01, 5.7405728753E+00, 6.4355801656E+01, 4.9041500515E+00, 9.9159696893E-01],
	[4.9640000000E+04, 7.0576109799E+01, 5.7406325653E+00, 6.4377212436E+01, 4.9043798410E+00, 9.9160062723E-01],
	[4.9645000000E+04, 7.0588933400E+01, 5.7406922499E+00, 6.4398628180E+01, 4.9046095758E+00, 9.9160428372E-01],
	[4.9650000000E+04, 7.0601758038E+01, 5.7407519292E+00, 6.4420048889E+01, 4.9048392560E+00, 9.9160793839E-01],
	[4.9655000000E+04, 7.0614583715E+01, 5.7408116030E+00, 6.4441474565E+01, 4.9050688816E+00, 9.9161159125E-01],
	[4.9660000000E+04, 7.0627410430E+01, 5.7408712715E+00, 6.4462905207E+01, 4.9052984526E+00, 9.9161524229E-01],
	[4.9665000000E+04, 7.0640238184E+01, 5.7409309346E+00, 6.4484340816E+01, 4.9055279690E+00, 9.9161889152E-01],
	[4.9670000000E+04, 7.0653066975E+01, 5.7409905923E+00, 6.4505781393E+01, 4.9057574308E+00, 9.9162253893E-01],
	[4.9675000000E+04, 7.0665896804E+01, 5.7410502446E+00, 6.4527226938E+01, 4.9059868380E+00, 9.9162618453E-01],
	[4.9680000000E+04, 7.0678727672E+01, 5.7411098915E+00, 6.4548677453E+01, 4.9062161908E+00, 9.9162982832E-01],
	[4.9685000000E+04, 7.0691559578E+01, 5.7411695331E+00, 6.4570132938E+01, 4.9064454890E+00, 9.9163347031E-01],
	[4.9690000000E+04, 7.0704392521E+01, 5.7412291692E+00, 6.4591593392E+01, 4.9066747327E+00, 9.9163711048E-01],
	[4.9695000000E+04, 7.0717226503E+01, 5.7412888000E+00, 6.4613058819E+01, 4.9069039219E+00, 9.9164074885E-01],
	[4.9700000000E+04, 7.0730061523E+01, 5.7413484254E+00, 6.4634529216E+01, 4.9071330567E+00, 9.9164438541E-01],
	[4.9705000000E+04, 7.0742897581E+01, 5.7414080454E+00, 6.4656004587E+01, 4.9073621370E+00, 9.9164802016E-01],
	[4.9710000000E+04, 7.0755734676E+01, 5.7414676601E+00, 6.4677484930E+01, 4.9075911629E+00, 9.9165165311E-01],
	[4.9715000000E+04, 7.0768572810E+01, 5.7415272693E+00, 6.4698970247E+01, 4.9078201343E+00, 9.9165528426E-01],
	[4.9720000000E+04, 7.0781411981E+01, 5.7415868732E+00, 6.4720460538E+01, 4.9080490514E+00, 9.9165891360E-01],
	[4.9725000000E+04, 7.0794252191E+01, 5.7416464717E+00, 6.4741955805E+01, 4.9082779142E+00, 9.9166254114E-01],
	[4.9730000000E+04, 7.0807093438E+01, 5.7417060649E+00, 6.4763456047E+01, 4.9085067225E+00, 9.9166616688E-01],
	[4.9735000000E+04, 7.0819935724E+01, 5.7417656526E+00, 6.4784961265E+01, 4.9087354765E+00, 9.9166979083E-01],
	[4.9740000000E+04, 7.0832779047E+01, 5.7418252350E+00, 6.4806471460E+01, 4.9089641763E+00, 9.9167341297E-01],
	[4.9745000000E+04, 7.0845623408E+01, 5.7418848120E+00, 6.4827986633E+01, 4.9091928217E+00, 9.9167703332E-01],
	[4.9750000000E+04, 7.0858468806E+01, 5.7419443837E+00, 6.4849506785E+01, 4.9094214128E+00, 9.9168065187E-01],
	[4.9755000000E+04, 7.0871315243E+01, 5.7420039500E+00, 6.4871031915E+01, 4.9096499496E+00, 9.9168426862E-01],
	[4.9760000000E+04, 7.0884162717E+01, 5.7420635109E+00, 6.4892562024E+01, 4.9098784323E+00, 9.9168788358E-01],
	[4.9765000000E+04, 7.0897011229E+01, 5.7421230664E+00, 6.4914097114E+01, 4.9101068606E+00, 9.9169149675E-01],
	[4.9770000000E+04, 7.0909860779E+01, 5.7421826166E+00, 6.4935637185E+01, 4.9103352348E+00, 9.9169510812E-01],
	[4.9775000000E+04, 7.0922711366E+01, 5.7422421614E+00, 6.4957182237E+01, 4.9105635548E+00, 9.9169871770E-01],
	[4.9780000000E+04, 7.0935562992E+01, 5.7423017009E+00, 6.4978732272E+01, 4.9107918206E+00, 9.9170232550E-01],
	[4.9785000000E+04, 7.0948415654E+01, 5.7423612350E+00, 6.5000287289E+01, 4.9110200323E+00, 9.9170593150E-01],
	[4.9790000000E+04, 7.0961269355E+01, 5.7424207637E+00, 6.5021847290E+01, 4.9112481898E+00, 9.9170953571E-01],
	[4.9795000000E+04, 7.0974124093E+01, 5.7424802871E+00, 6.5043412275E+01, 4.9114762932E+00, 9.9171313814E-01],
	[4.9800000000E+04, 7.0986979869E+01, 5.7425398051E+00, 6.5064982245E+01, 4.9117043424E+00, 9.9171673878E-01],
	[4.9805000000E+04, 7.0999836682E+01, 5.7425993178E+00, 6.5086557200E+01, 4.9119323376E+00, 9.9172033763E-01],
	[4.9810000000E+04, 7.1012694533E+01, 5.7426588251E+00, 6.5108137141E+01, 4.9121602788E+00, 9.9172393470E-01],
	[4.9815000000E+04, 7.1025553421E+01, 5.7427183270E+00, 6.5129722069E+01, 4.9123881659E+00, 9.9172752999E-01],
	[4.9820000000E+04, 7.1038413347E+01, 5.7427778236E+00, 6.5151311985E+01, 4.9126159989E+00, 9.9173112349E-01],
	[4.9825000000E+04, 7.1051274310E+01, 5.7428373148E+00, 6.5172906888E+01, 4.9128437779E+00, 9.9173471522E-01],
	[4.9830000000E+04, 7.1064136311E+01, 5.7428968007E+00, 6.5194506780E+01, 4.9130715030E+00, 9.9173830516E-01],
	[4.9835000000E+04, 7.1076999350E+01, 5.7429562812E+00, 6.5216111661E+01, 4.9132991740E+00, 9.9174189332E-01],
	[4.9840000000E+04, 7.1089863425E+01, 5.7430157564E+00, 6.5237721533E+01, 4.9135267911E+00, 9.9174547970E-01],
	[4.9845000000E+04, 7.1102728538E+01, 5.7430752262E+00, 6.5259336395E+01, 4.9137543543E+00, 9.9174906431E-01],
	[4.9850000000E+04, 7.1115594689E+01, 5.7431346907E+00, 6.5280956248E+01, 4.9139818635E+00, 9.9175264714E-01],
	[4.9855000000E+04, 7.1128461877E+01, 5.7431941498E+00, 6.5302581094E+01, 4.9142093189E+00, 9.9175622820E-01],
	[4.9860000000E+04, 7.1141341636E+01, 5.7432544011E+00, 6.5324210931E+01, 4.9144373593E+00, 9.9175980748E-01],
	[4.9865000000E+04, 7.1154234365E+01, 5.7433154717E+00, 6.5345845763E+01, 4.9146660067E+00, 9.9176338498E-01],
	[4.9870000000E+04, 7.1167128138E+01, 5.7433765369E+00, 6.5367485588E+01, 4.9148946003E+00, 9.9176696072E-01],
	[4.9875000000E+04, 7.1180022954E+01, 5.7434375966E+00, 6.5389130407E+01, 4.9151231402E+00, 9.9177053468E-01],
	[4.9880000000E+04, 7.1192918813E+01, 5.7434986508E+00, 6.5410780222E+01, 4.9153516262E+00, 9.9177410687E-01],
	[4.9885000000E+04, 7.1205815716E+01, 5.7435596996E+00, 6.5432435033E+01, 4.9155800585E+00, 9.9177767729E-01],
	[4.9890000000E+04, 7.1218713662E+01, 5.7436207429E+00, 6.5454094840E+01, 4.9158084371E+00, 9.9178124595E-01],
	[4.9895000000E+04, 7.1231612651E+01, 5.7436817807E+00, 6.5475759644E+01, 4.9160367619E+00, 9.9178481283E-01],
	[4.9900000000E+04, 7.1244512684E+01, 5.7437428130E+00, 6.5497429446E+01, 4.9162650331E+00, 9.9178837795E-01],
	[4.9905000000E+04, 7.1257413760E+01, 5.7438038399E+00, 6.5519104247E+01, 4.9164932505E+00, 9.9179194131E-01],
	[4.9910000000E+04, 7.1270315880E+01, 5.7438648613E+00, 6.5540784047E+01, 4.9167214143E+00, 9.9179550290E-01],
	[4.9915000000E+04, 7.1283219042E+01, 5.7439258773E+00, 6.5562468846E+01, 4.9169495245E+00, 9.9179906272E-01],
	[4.9920000000E+04, 7.1296123248E+01, 5.7439868878E+00, 6.5584158646E+01, 4.9171775810E+00, 9.9180262079E-01],
	[4.9925000000E+04, 7.1309028498E+01, 5.7440478928E+00, 6.5605853447E+01, 4.9174055839E+00, 9.9180617709E-01],
	[4.9930000000E+04, 7.1321934790E+01, 5.7441088924E+00, 6.5627553249E+01, 4.9176335332E+00, 9.9180973163E-01],
	[4.9935000000E+04, 7.1334842126E+01, 5.7441698865E+00, 6.5649258055E+01, 4.9178614289E+00, 9.9181328441E-01],
	[4.9940000000E+04, 7.1347750505E+01, 5.7442308751E+00, 6.5670967863E+01, 4.9180892711E+00, 9.9181683543E-01],
	[4.9945000000E+04, 7.1360659927E+01, 5.7442918583E+00, 6.5692682674E+01, 4.9183170597E+00, 9.9182038470E-01],
	[4.9950000000E+04, 7.1373570392E+01, 5.7443528361E+00, 6.5714402490E+01, 4.9185447948E+00, 9.9182393221E-01],
	[4.9955000000E+04, 7.1386481900E+01, 5.7444138083E+00, 6.5736127311E+01, 4.9187724764E+00, 9.9182747796E-01],
	[4.9960000000E+04, 7.1399394451E+01, 5.7444747751E+00, 6.5757857138E+01, 4.9190001045E+00, 9.9183102196E-01],
	[4.9965000000E+04, 7.1412308046E+01, 5.7445357365E+00, 6.5779591971E+01, 4.9192276791E+00, 9.9183456420E-01],
	[4.9970000000E+04, 7.1425222683E+01, 5.7445966924E+00, 6.5801331811E+01, 4.9194552003E+00, 9.9183810470E-01],
	[4.9975000000E+04, 7.1438138364E+01, 5.7446576429E+00, 6.5823076658E+01, 4.9196826680E+00, 9.9184164344E-01],
	[4.9980000000E+04, 7.1451055087E+01, 5.7447185879E+00, 6.5844826514E+01, 4.9199100823E+00, 9.9184518043E-01],
	[4.9985000000E+04, 7.1463972854E+01, 5.7447795274E+00, 6.5866581379E+01, 4.9201374433E+00, 9.9184871566E-01],
	[4.9990000000E+04, 7.1476891663E+01, 5.7448404615E+00, 6.5888341253E+01, 4.9203647508E+00, 9.9185224916E-01],
	[4.9995000000E+04, 7.1489811515E+01, 5.7449013902E+00, 6.5910106137E+01, 4.9205920050E+00, 9.9185578090E-01],
	[5.0000000000E+04, 7.1502732411E+01, 5.7449623134E+00, 6.5931876032E+01, 4.9208192058E+00, 9.9185931090E-01],
	[5.0005000000E+04, 7.1515654349E+01, 5.7450232312E+00, 6.5953668196E+01, 4.9210464493E+00, 9.9186283915E-01],
	[5.0010000000E+04, 7.1528577330E+01, 5.7450841435E+00, 6.5975465382E+01, 4.9212736395E+00, 9.9186636565E-01],
	[5.0015000000E+04, 7.1541501354E+01, 5.7451450504E+00, 6.5997267590E+01, 4.9215007764E+00, 9.9186989041E-01],
	[5.0020000000E+04, 7.1554426421E+01, 5.7452059518E+00, 6.6019074822E+01, 4.9217278599E+00, 9.9187341343E-01],
	[5.0025000000E+04, 7.1567352531