# Valiant
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)
[![Default CI workflow](https://github.com/pomes/valiant/workflows/Default%20CI%20workflow/badge.svg)](https://github.com/pomes/valiant/actions?query=workflow%3A%22Default+CI+workflow%22)

The Valiant project aims to provide auditing tools that help project teams
track their dependencies in terms of licensing, security, and dependability.

The goal is to help reduce the fragility of the "input side" of software development
by making it easy to assess and track dependencies. Further work will also aim to
check dependencies against policy documents to help integrate Valiant into developer
and release workflows.

The system is written in Python 3 and targets Python codebases.

Please check out the [project site](http://pomes.github.io/valiant)
for documentation.

## Key resources

| Resource | Description |
| -------- | ----------- |
| [Codebase](https://github.com/pomes/valiant) | GitHub project |
| [Security policy](https://github.com/pomes/valiant/blob/master/SECURITY.md) | Please refer to this if you need to report a security concern |
| [Project tracker](https://github.com/pomes/valiant/projects/1) | Structured to provide fulfilment of [project milestones](https://github.com/pomes/valiant/milestones) |
| [Issue tracker](https://github.com/pomes/valiant/issues) | GitHub issues |
| [Documentation](http://pomes.github.io/valiant) | Project site |
| [License](https://github.com/pomes/valiant/blob/master/LICENSE) | Project licence (MIT) |
| [Contributing](https://github.com/pomes/valiant/blob/master/CONTRIBUTING.md) | Want to join in? |

## Attribution

I have used the [Poetry](https://github.com/python-poetry/poetry) library to package
this project and guide my implementation efforts.

The [Hypermodern Python series](https://cjolowicz.github.io/posts/hypermodern-python-01-setup/) by
Claudio Jolowicz is a great resource and you'll see his guidance instilled in this codebase.

[ ~ Dependencies scanned by PyUp.io ~ ]
