---
myst:
  html_meta:
    "description": "Available content rules in a Plone site can be listed and queried by accessing the /@content-rules endpoint on any context. Access requires the ManageContentRules permission."
    "property=og:description": "Available content rules in a Plone site can be listed and queried by accessing the /@content-rules endpoint on any context. Access requires the ManageContentRules permission."
    "property=og:title": "Content Rules"
    "keywords": "Plone, plone.restapi, REST, API, ContentRules, Rules"
---

(content-rules)=

# Content Rules

A content rule will automatically perform an action when a certain event, known as a {term}`trigger`, takes place.

Content rules can perform routine tasks, including the following.

-   Move content from one folder to another when that content item is published.
-   Send email when a content item is deleted.
-   Delete content after a certain date.

```{seealso}
[Using Content Rules](https://docs.plone.org/working-with-content/managing-content/contentrules.html)
```

```{note}
These docs are generated by code tests, therefore you will see some `test` rules appear here.
```

Available content rules in a Plone site can be listed and queried by accessing the `/@content-rules` endpoint in any context.
Access requires the `ManageContentRules` permission.

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../../src/plone/restapi/tests/http-examples/rules_get.req
```

```{literalinclude} ../../../src/plone/restapi/tests/http-examples/rules_get.resp
:language: http
```

The API consumer can assign, unassign, enable, disable,
apply to subfolders, or disable apply to subfolders any of the rules available in the portal.

| Verb    | URL              | Action                                             |
| ------- | ---------------- | -------------------------------------------------- |
| `POST`  | `/@content-rules/{rule-id}`| Add rule to context                                          |
| `GET`   | `/@content-rules/`         | Get acquired, assignable, and assigned rules                      |
| `PATCH` | `/@content-rules/` with RAW Body | enable or disable,
apply to subfolders or disable apply to subfolders, move down or move up |
| `DELETE`| `/@content-rules/` with RAW Body | Unassign rule on context                                  |


## Assigning a new Content rule with `POST`

To assign a content rule to a context, send a `POST` request to the `<context>/@content-rules` endpoint:

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../../src/plone/restapi/tests/http-examples/rules_add.req
```

Response:

```{literalinclude} ../../../src/plone/restapi/tests/http-examples/rules_add.resp
:language: http
```

## Getting content rule for a context with `GET`

To get content rules that are assigned, assignable, or acquired for a context, send a `GET`
request to the `<context>/@content-rules` endpoint:

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../../src/plone/restapi/tests/http-examples/rules_get.req
```

Response:

```{literalinclude} ../../../src/plone/restapi/tests/http-examples/rules_get.resp
:language: http
```

## Changing content rules for a context with `PATCH`

To make changes on content rule assignments for a context, send a `PATCH`
request to the `<context>/@content-rules` endpoint:

### Apply on subfolders

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../../src/plone/restapi/tests/http-examples/rules_apply_subfolders.req
```

Response:

```{literalinclude} ../../../src/plone/restapi/tests/http-examples/rules_apply_subfolders.resp
:language: http
```

### Disable apply on subfolders

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../../src/plone/restapi/tests/http-examples/rules_disable_apply_subfolders.req
```

Response:

```{literalinclude} ../../../src/plone/restapi/tests/http-examples/rules_disable_apply_subfolders.resp
:language: http
```

### Enable

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../../src/plone/restapi/tests/http-examples/rules_enable.req
```

Response:

```{literalinclude} ../../../src/plone/restapi/tests/http-examples/rules_enable.resp
:language: http
```

### Disable

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../../src/plone/restapi/tests/http-examples/rules_disable.req
```

Response:

```{literalinclude} ../../../src/plone/restapi/tests/http-examples/rules_disable.resp
:language: http
```

### Move up

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../../src/plone/restapi/tests/http-examples/rules_move_up.req
```

Response:

```{literalinclude} ../../../src/plone/restapi/tests/http-examples/rules_move_up.resp
:language: http
```

### Move down

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../../src/plone/restapi/tests/http-examples/rules_move_down.req
```

Response:

```{literalinclude} ../../../src/plone/restapi/tests/http-examples/rules_move_down.resp
:language: http
```

## Unassign content rules with `DELETE`

To unassign content rules on a context, send a `DELETE` request to the `<context>/@content-rules` endpoint:

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../../src/plone/restapi/tests/http-examples/rules_delete.req
```

Response:

```{literalinclude} ../../../src/plone/restapi/tests/http-examples/rules_delete.resp
:language: http
```
