# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ScheduleKeyVersionDeletionRequest(JDCloudRequest):
    """
    计划在以后的是个时间点删除指定版本密钥，默认为7天
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ScheduleKeyVersionDeletionRequest, self).__init__(
            '/key/{keyId}/version/{version}:delete', 'DELETE', header, version)
        self.parameters = parameters


class ScheduleKeyVersionDeletionParameters(object):

    def __init__(self, keyId, version, ):
        """
        :param keyId: 密钥ID
        :param version: 密钥版本
        """

        self.keyId = keyId
        self.version = version
        self.delayDays = None

    def setDelayDays(self, delayDays):
        """
        :param delayDays: (Optional) 延迟删除时间，单位（天），默认为7天；支持时间范围：7~30天
        """
        self.delayDays = delayDays

