# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class ClusterModel(object):

    def __init__(self, name=None, password=None, version=None, payType=None, masterNodeNumber=None, masterNodeDiskType=None, masterNodeDiskVolume=None, masterInstanceType=None, slaveNodeNumber=None, slaveNodeDiskType=None, slaveNodeDiskVolume=None, coreInstanceType=None, dataCenter=None, softwareList=None, jssFlag=None, haFlag=None, vpcId=None, vpcSubnetId=None, bandwidth=None):
        """
        :param name: (Optional) 集群名称，长度为6到32个字符，支持中文、数字、大小写字母、英文下划线“_”及中划线“-”
        :param password: (Optional) "集群密码"
"1.必须包含大写字母、小写字母、数字及特殊字符中三类，且不能少于8字符不能超过30字符"
"2.特殊字符如下!@#$%^*"
"3.不能出现的字符或完整单词，如下：jd、JD、360、bug、BUG、com、COM、jcloud、JCLOUD、cloud、CLOUD、password、PASSWORD"
"4.不能出现连续数字，例：123、987"
"5.不能出现连续或键位连续字母，例：abc、CBA、bcde、qaz、tfc、zaq、qwer"
"6.密码中不能出现自己的用户名"

        :param version: (Optional) "软件服务版本，请填写以下列表中的一个："
"JMR1.0.0"
"JMR1.0.1"
"JMR1.0.2"
"JMR2.0.0"
"JMR_BD-OS-1.0"

        :param payType: (Optional) "付费类型，请填写以下列表中的一个："
"按量"

        :param masterNodeNumber: (Optional) Master节点数量
        :param masterNodeDiskType: (Optional) "Master节点云盘类型，可传类型为（以下以“/”分割各类型）"
"NBD/NBD_SATA"
"分别代表：性能型/容量型"

        :param masterNodeDiskVolume: (Optional) Master节点云盘容量，必须是10的整数倍，且大于20小于3000
        :param masterInstanceType: (Optional) Master节点规格，比如：g.n1.xlarge，更多规格请参考[文档](https://www.jdcloud.com/help/detail/296/isCatalog/1)
        :param slaveNodeNumber: (Optional) Slave节点数量
        :param slaveNodeDiskType: (Optional) "Slave节点云盘类型，可传类型为（以下以“/”分割各类型）"
"NBD/NBD_SATA"
"分别代表：性能型/容量型"

        :param slaveNodeDiskVolume: (Optional) Slave节点云盘容量，必须是10的整数倍，且大于20小于3000
        :param coreInstanceType: (Optional) Core节点规格，比如：g.n1.xlarge，更多规格请参考[文档](https://www.jdcloud.com/help/detail/296/isCatalog/1)
        :param dataCenter: (Optional) 地域，同regionID
        :param softwareList: (Optional) 软件清单，不同软件之间以英文逗号(,)分割，参考[文档](https://www.jdcloud.com/help/detail/1323/isCatalog/1)
        :param jssFlag: (Optional) 是否关联对象存储
        :param haFlag: (Optional) 集群是否为高可用模式
        :param vpcId: (Optional) 私有网络ID
        :param vpcSubnetId: (Optional) 子网UUID，可以通过查询子网列表获得
        :param bandwidth: (Optional) 网络带宽上限
        """

        self.name = name
        self.password = password
        self.version = version
        self.payType = payType
        self.masterNodeNumber = masterNodeNumber
        self.masterNodeDiskType = masterNodeDiskType
        self.masterNodeDiskVolume = masterNodeDiskVolume
        self.masterInstanceType = masterInstanceType
        self.slaveNodeNumber = slaveNodeNumber
        self.slaveNodeDiskType = slaveNodeDiskType
        self.slaveNodeDiskVolume = slaveNodeDiskVolume
        self.coreInstanceType = coreInstanceType
        self.dataCenter = dataCenter
        self.softwareList = softwareList
        self.jssFlag = jssFlag
        self.haFlag = haFlag
        self.vpcId = vpcId
        self.vpcSubnetId = vpcSubnetId
        self.bandwidth = bandwidth
