from dataclasses import dataclass, field, asdict
from typing import Dict, List, Generic, TypeVar
from abc import ABC, abstractmethod

from nerualpha.providers.voice.contracts.IUpdateUserPayload import IUpdateUserPayload

@dataclass
class UpdateUserPayload(IUpdateUserPayload):
    name: str = None
    display_name: str = None
    image_url: str = None
    channels: object = None
    def __init__(self,name = None,display_name = None,image_url = None,channels = None):
        self.name = name
        self.display_name = display_name
        self.image_url = image_url
        self.channels = channels
    
    def reprJSON(self):
        result = {}
        dict = asdict(self)
        keywordsMap = {"from_":"from","del_":"del","import_":"import","type_":"type"}
        for key in dict:
            val = getattr(self, key)

            if val is not None:
                if type(val) is list:
                    parsedList = []
                    for i in val:
                        if hasattr(i,'reprJSON'):
                            parsedList.append(i.reprJSON())
                        else:
                            parsedList.append(i)
                    val = parsedList

                if hasattr(val,'reprJSON'):
                    val = val.reprJSON()
                if key in keywordsMap:
                    key = keywordsMap[key]
                result.__setitem__(key.replace('_hyphen_', '-'), val)
        return result
