#  Licensed under the Apache License, Version 2.0 (the "License"); you may
#  not use this file except in compliance with the License. You may obtain
#  a copy of the License at
#
#       https://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#  License for the specific language governing permissions and limitations
#  under the License.

"""linebot.models.delivery_context module."""


from abc import ABCMeta

from future.utils import with_metaclass

from .base import Base


class DeliveryContext(with_metaclass(ABCMeta, Base)):
    """Abstract Base Class of DeliveryContext."""

    def __init__(self, is_redelivery=None, **kwargs):
        """__init__ method.

        :param bool is_redelivery: Whether the webhook event is a redelivered one or not
        :param kwargs:
        """
        super(DeliveryContext, self).__init__(**kwargs)

        self.is_redelivery = is_redelivery
