# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from lightly.openapi_generated.swagger_client.configuration import Configuration


class VideoFrameData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source_video': 'str',
        'source_video_frame_index': 'float',
        'source_video_frame_timestamp': 'float'
    }

    attribute_map = {
        'source_video': 'sourceVideo',
        'source_video_frame_index': 'sourceVideoFrameIndex',
        'source_video_frame_timestamp': 'sourceVideoFrameTimestamp'
    }

    def __init__(self, source_video=None, source_video_frame_index=None, source_video_frame_timestamp=None, _configuration=None):  # noqa: E501
        """VideoFrameData - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._source_video = None
        self._source_video_frame_index = None
        self._source_video_frame_timestamp = None
        self.discriminator = None

        if source_video is not None:
            self.source_video = source_video
        if source_video_frame_index is not None:
            self.source_video_frame_index = source_video_frame_index
        if source_video_frame_timestamp is not None:
            self.source_video_frame_timestamp = source_video_frame_timestamp

    @property
    def source_video(self):
        """Gets the source_video of this VideoFrameData.  # noqa: E501

        Name of the source video.  # noqa: E501

        :return: The source_video of this VideoFrameData.  # noqa: E501
        :rtype: str
        """
        return self._source_video

    @source_video.setter
    def source_video(self, source_video):
        """Sets the source_video of this VideoFrameData.

        Name of the source video.  # noqa: E501

        :param source_video: The source_video of this VideoFrameData.  # noqa: E501
        :type: str
        """

        self._source_video = source_video

    @property
    def source_video_frame_index(self):
        """Gets the source_video_frame_index of this VideoFrameData.  # noqa: E501

        Index of the frame in the source video.  # noqa: E501

        :return: The source_video_frame_index of this VideoFrameData.  # noqa: E501
        :rtype: float
        """
        return self._source_video_frame_index

    @source_video_frame_index.setter
    def source_video_frame_index(self, source_video_frame_index):
        """Sets the source_video_frame_index of this VideoFrameData.

        Index of the frame in the source video.  # noqa: E501

        :param source_video_frame_index: The source_video_frame_index of this VideoFrameData.  # noqa: E501
        :type: float
        """

        self._source_video_frame_index = source_video_frame_index

    @property
    def source_video_frame_timestamp(self):
        """Gets the source_video_frame_timestamp of this VideoFrameData.  # noqa: E501

        Timestamp of the frame in the source video.  # noqa: E501

        :return: The source_video_frame_timestamp of this VideoFrameData.  # noqa: E501
        :rtype: float
        """
        return self._source_video_frame_timestamp

    @source_video_frame_timestamp.setter
    def source_video_frame_timestamp(self, source_video_frame_timestamp):
        """Sets the source_video_frame_timestamp of this VideoFrameData.

        Timestamp of the frame in the source video.  # noqa: E501

        :param source_video_frame_timestamp: The source_video_frame_timestamp of this VideoFrameData.  # noqa: E501
        :type: float
        """

        self._source_video_frame_timestamp = source_video_frame_timestamp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(VideoFrameData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoFrameData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoFrameData):
            return True

        return self.to_dict() != other.to_dict()
