# coding: utf-8

"""

    Copyright (c) 2020 Aspose.BarCode for Cloud

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.

"""

from __future__ import absolute_import, division

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from aspose_barcode_cloud.api_client import ApiClient


class FolderApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def copy_folder(
        self, src_path, dest_path, src_storage_name=None, dest_storage_name=None, async_req=False, **kwargs
    ):
        """Copy folder

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = FolderApi().copy_folder(src_path, dest_path, async_req=True)
        >>> result = thread.get()

        :param str src_path: Source folder path e.g. '/src' # noqa: E501
        :param str dest_path: Destination folder path e.g. '/dst' # noqa: E501
        :param str src_storage_name: Source storage name # noqa: E501
        :param str dest_storage_name: Destination storage name # noqa: E501
        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.copy_folder_with_http_info(
                src_path, dest_path, src_storage_name=src_storage_name, dest_storage_name=dest_storage_name, **kwargs
            )
        else:
            (data) = self.copy_folder_with_http_info(
                src_path, dest_path, src_storage_name=src_storage_name, dest_storage_name=dest_storage_name, **kwargs
            )
            return data

    def copy_folder_with_http_info(self, src_path, dest_path, **kwargs):
        """Copy folder

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = FolderApi().copy_folder_with_http_info(src_path, dest_path, async_req=True)
        >>> result = thread.get()

        :param str src_path: Source folder path e.g. '/src' # noqa: E501
        :param str dest_path: Destination folder path e.g. '/dst' # noqa: E501
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {"src_path", "dest_path", "src_storage_name", "dest_storage_name"}
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method copy_folder" % key)
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]
        # verify the required parameter "src_path" is set
        if "src_path" not in params or params["src_path"] is None:
            raise ValueError("Missing the required parameter 'src_path' when calling 'copy_folder'")
        # verify the required parameter "dest_path" is set
        if "dest_path" not in params or params["dest_path"] is None:
            raise ValueError("Missing the required parameter 'dest_path' when calling 'copy_folder'")

        collection_formats = {}

        path_params = {}
        if "src_path" in params:
            path_params["srcPath"] = params["src_path"]

        query_params = []
        if "dest_path" in params:
            query_params.append(("destPath", params["dest_path"]))
        if "src_storage_name" in params:
            query_params.append(("srcStorageName", params["src_storage_name"]))
        if "dest_storage_name" in params:
            query_params.append(("destStorageName", params["dest_storage_name"]))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/storage/folder/copy/{srcPath}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_folder(self, path, storage_name=None, async_req=False, **kwargs):
        """Create the folder

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = FolderApi().create_folder(path, async_req=True)
        >>> result = thread.get()

        :param str path: Folder path to create e.g. 'folder_1/folder_2/' # noqa: E501
        :param str storage_name: Storage name # noqa: E501
        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.create_folder_with_http_info(path, storage_name=storage_name, **kwargs)
        else:
            (data) = self.create_folder_with_http_info(path, storage_name=storage_name, **kwargs)
            return data

    def create_folder_with_http_info(self, path, **kwargs):
        """Create the folder

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = FolderApi().create_folder_with_http_info(path, async_req=True)
        >>> result = thread.get()

        :param str path: Folder path to create e.g. 'folder_1/folder_2/' # noqa: E501
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {"path", "storage_name"}
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method create_folder" % key)
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]
        # verify the required parameter "path" is set
        if "path" not in params or params["path"] is None:
            raise ValueError("Missing the required parameter 'path' when calling 'create_folder'")

        collection_formats = {}

        path_params = {}
        if "path" in params:
            path_params["path"] = params["path"]

        query_params = []
        if "storage_name" in params:
            query_params.append(("storageName", params["storage_name"]))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/storage/folder/{path}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_folder(self, path, storage_name=None, recursive=None, async_req=False, **kwargs):
        """Delete folder

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = FolderApi().delete_folder(path, async_req=True)
        >>> result = thread.get()

        :param str path: Folder path e.g. '/folder' # noqa: E501
        :param str storage_name: Storage name # noqa: E501
        :param bool recursive: Enable to delete folders, subfolders and files # noqa: E501
        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.delete_folder_with_http_info(path, storage_name=storage_name, recursive=recursive, **kwargs)
        else:
            (data) = self.delete_folder_with_http_info(path, storage_name=storage_name, recursive=recursive, **kwargs)
            return data

    def delete_folder_with_http_info(self, path, **kwargs):
        """Delete folder

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = FolderApi().delete_folder_with_http_info(path, async_req=True)
        >>> result = thread.get()

        :param str path: Folder path e.g. '/folder' # noqa: E501
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {"path", "storage_name", "recursive"}
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method delete_folder" % key)
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]
        # verify the required parameter "path" is set
        if "path" not in params or params["path"] is None:
            raise ValueError("Missing the required parameter 'path' when calling 'delete_folder'")

        collection_formats = {}

        path_params = {}
        if "path" in params:
            path_params["path"] = params["path"]

        query_params = []
        if "storage_name" in params:
            query_params.append(("storageName", params["storage_name"]))
        if "recursive" in params:
            query_params.append(("recursive", params["recursive"]))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/storage/folder/{path}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_files_list(self, path, storage_name=None, async_req=False, **kwargs):
        """Get all files and folders within a folder

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = FolderApi().get_files_list(path, async_req=True)
        >>> result = thread.get()

        :param str path: Folder path e.g. '/folder' # noqa: E501
        :param str storage_name: Storage name # noqa: E501
        :param async_req bool
        :return: FilesList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.get_files_list_with_http_info(path, storage_name=storage_name, **kwargs)
        else:
            (data) = self.get_files_list_with_http_info(path, storage_name=storage_name, **kwargs)
            return data

    def get_files_list_with_http_info(self, path, **kwargs):
        """Get all files and folders within a folder

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = FolderApi().get_files_list_with_http_info(path, async_req=True)
        >>> result = thread.get()

        :param str path: Folder path e.g. '/folder' # noqa: E501
        :return: FilesList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {"path", "storage_name"}
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method get_files_list" % key)
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]
        # verify the required parameter "path" is set
        if "path" not in params or params["path"] is None:
            raise ValueError("Missing the required parameter 'path' when calling 'get_files_list'")

        collection_formats = {}

        path_params = {}
        if "path" in params:
            path_params["path"] = params["path"]

        query_params = []
        if "storage_name" in params:
            query_params.append(("storageName", params["storage_name"]))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/storage/folder/{path}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FilesList",
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def move_folder(
        self, src_path, dest_path, src_storage_name=None, dest_storage_name=None, async_req=False, **kwargs
    ):
        """Move folder

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = FolderApi().move_folder(src_path, dest_path, async_req=True)
        >>> result = thread.get()

        :param str src_path: Folder path to move e.g. '/folder' # noqa: E501
        :param str dest_path: Destination folder path to move to e.g '/dst' # noqa: E501
        :param str src_storage_name: Source storage name # noqa: E501
        :param str dest_storage_name: Destination storage name # noqa: E501
        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.move_folder_with_http_info(
                src_path, dest_path, src_storage_name=src_storage_name, dest_storage_name=dest_storage_name, **kwargs
            )
        else:
            (data) = self.move_folder_with_http_info(
                src_path, dest_path, src_storage_name=src_storage_name, dest_storage_name=dest_storage_name, **kwargs
            )
            return data

    def move_folder_with_http_info(self, src_path, dest_path, **kwargs):
        """Move folder

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = FolderApi().move_folder_with_http_info(src_path, dest_path, async_req=True)
        >>> result = thread.get()

        :param str src_path: Folder path to move e.g. '/folder' # noqa: E501
        :param str dest_path: Destination folder path to move to e.g '/dst' # noqa: E501
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {"src_path", "dest_path", "src_storage_name", "dest_storage_name"}
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method move_folder" % key)
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]
        # verify the required parameter "src_path" is set
        if "src_path" not in params or params["src_path"] is None:
            raise ValueError("Missing the required parameter 'src_path' when calling 'move_folder'")
        # verify the required parameter "dest_path" is set
        if "dest_path" not in params or params["dest_path"] is None:
            raise ValueError("Missing the required parameter 'dest_path' when calling 'move_folder'")

        collection_formats = {}

        path_params = {}
        if "src_path" in params:
            path_params["srcPath"] = params["src_path"]

        query_params = []
        if "dest_path" in params:
            query_params.append(("destPath", params["dest_path"]))
        if "src_storage_name" in params:
            query_params.append(("srcStorageName", params["src_storage_name"]))
        if "dest_storage_name" in params:
            query_params.append(("destStorageName", params["dest_storage_name"]))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/storage/folder/move/{srcPath}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
