# coding: utf-8

"""

    Copyright (c) 2020 Aspose.BarCode for Cloud

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.

"""

from __future__ import absolute_import, division

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from aspose_barcode_cloud.api_client import ApiClient


class BarcodeApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_barcode_generate(
        self,
        type,
        text,
        two_d_display_text=None,
        text_location=None,
        text_alignment=None,
        text_color=None,
        font_size_mode=None,
        resolution=None,
        resolution_x=None,
        resolution_y=None,
        dimension_x=None,
        text_space=None,
        units=None,
        size_mode=None,
        bar_height=None,
        image_height=None,
        image_width=None,
        rotation_angle=None,
        back_color=None,
        bar_color=None,
        border_color=None,
        border_width=None,
        border_dash_style=None,
        border_visible=None,
        enable_checksum=None,
        enable_escape=None,
        filled_bars=None,
        always_show_checksum=None,
        wide_narrow_ratio=None,
        validate_text=None,
        supplement_data=None,
        supplement_space=None,
        bar_width_reduction=None,
        format=None,
        async_req=False,
        **kwargs
    ):
        """Generate barcode.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().get_barcode_generate(type, text, async_req=True)
        >>> result = thread.get()

        :param str type: Type of barcode to generate. # noqa: E501
        :param str text: Text to encode. # noqa: E501
        :param str two_d_display_text: Text that will be displayed instead of codetext in 2D barcodes. Used for: Aztec, Pdf417, DataMatrix, QR, MaxiCode, DotCode # noqa: E501
        :param str text_location: Specify the displaying Text Location, set to CodeLocation.None to hide CodeText. Default value: CodeLocation.Below. # noqa: E501
        :param str text_alignment: Text alignment. # noqa: E501
        :param str text_color: Specify the displaying CodeText's Color. Default value: Color.Black. # noqa: E501
        :param str font_size_mode: Specify FontSizeMode. If FontSizeMode is set to Auto, font size will be calculated automatically based on xDimension value. It is recommended to use FontSizeMode.Auto especially in AutoSizeMode.Nearest or AutoSizeMode.Interpolation. Default value: FontSizeMode.Auto. # noqa: E501
        :param float resolution: Resolution of the BarCode image. One value for both dimensions. Default value: 96 dpi. # noqa: E501
        :param float resolution_x: DEPRECATED: Use 'Resolution' instead. # noqa: E501
        :param float resolution_y: DEPRECATED: Use 'Resolution' instead. # noqa: E501
        :param float dimension_x: The smallest width of the unit of BarCode bars or spaces. Increase this will increase the whole barcode image width. Ignored if AutoSizeMode property is set to AutoSizeMode.Nearest or AutoSizeMode.Interpolation. # noqa: E501
        :param float text_space: Space between the CodeText and the BarCode in Unit value. Default value: 2pt. Ignored for EAN8, EAN13, UPCE, UPCA, ISBN, ISMN, ISSN, UpcaGs1DatabarCoupon. # noqa: E501
        :param str units: Common Units for all measuring in query. Default units: pixel. # noqa: E501
        :param str size_mode: Specifies the different types of automatic sizing modes. Default value: AutoSizeMode.None. # noqa: E501
        :param float bar_height: Height of the barcode in given units. Default units: pixel. # noqa: E501
        :param float image_height: Height of the barcode image in given units. Default units: pixel. # noqa: E501
        :param float image_width: Width of the barcode image in given units. Default units: pixel. # noqa: E501
        :param float rotation_angle: BarCode image rotation angle, measured in degree, e.g. RotationAngle = 0 or RotationAngle = 360 means no rotation. If RotationAngle NOT equal to 90, 180, 270 or 0, it may increase the difficulty for the scanner to read the image. Default value: 0. # noqa: E501
        :param str back_color: Background color of the barcode image. Default value: Color.White. # noqa: E501
        :param str bar_color: Bars color. Default value: Color.Black. # noqa: E501
        :param str border_color: Border color. Default value: Color.Black. # noqa: E501
        :param float border_width: Border width. Default value: 0. Ignored if Visible is set to false. # noqa: E501
        :param str border_dash_style: Border dash style. Default value: BorderDashStyle.Solid. # noqa: E501
        :param bool border_visible: Border visibility. If false than parameter Width is always ignored (0). Default value: false. # noqa: E501
        :param str enable_checksum: Enable checksum during generation 1D barcodes. Default is treated as Yes for symbology which must contain checksum, as No where checksum only possible. Checksum is possible: Code39 Standard/Extended, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, DeutschePostIdentcode, DeutschePostLeitcode, VIN, Codabar Checksum always used: Rest symbology # noqa: E501
        :param bool enable_escape: Indicates whether explains the character \"\\\" as an escape character in CodeText property. Used for Pdf417, DataMatrix, Code128 only If the EnableEscape is true, \"\\\" will be explained as a special escape character. Otherwise, \"\\\" acts as normal characters. Aspose.BarCode supports input decimal ascii code and mnemonic for ASCII control-code characters. For example, \\013 and \\\\CR stands for CR. # noqa: E501
        :param bool filled_bars: Value indicating whether bars are filled. Only for 1D barcodes. Default value: true. # noqa: E501
        :param bool always_show_checksum: Always display checksum digit in the human readable text for Code128 and GS1Code128 barcodes. # noqa: E501
        :param float wide_narrow_ratio: Wide bars to Narrow bars ratio. Default value: 3, that is, wide bars are 3 times as wide as narrow bars. Used for ITF, PZN, PharmaCode, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, IATA2of5, VIN, DeutschePost, OPC, Code32, DataLogic2of5, PatchCode, Code39Extended, Code39Standard # noqa: E501
        :param bool validate_text: Only for 1D barcodes. If codetext is incorrect and value set to true - exception will be thrown. Otherwise codetext will be corrected to match barcode's specification. Exception always will be thrown for: Databar symbology if codetext is incorrect. Exception always will not be thrown for: AustraliaPost, SingaporePost, Code39Extended, Code93Extended, Code16K, Code128 symbology if codetext is incorrect. # noqa: E501
        :param str supplement_data: Supplement parameters. Used for Interleaved2of5, Standard2of5, EAN13, EAN8, UPCA, UPCE, ISBN, ISSN, ISMN. # noqa: E501
        :param float supplement_space: Space between main the BarCode and supplement BarCode. # noqa: E501
        :param float bar_width_reduction: Bars reduction value that is used to compensate ink spread while printing. # noqa: E501
        :param str format: Result image format. # noqa: E501
        :param async_req bool
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.get_barcode_generate_with_http_info(
                type,
                text,
                two_d_display_text=two_d_display_text,
                text_location=text_location,
                text_alignment=text_alignment,
                text_color=text_color,
                font_size_mode=font_size_mode,
                resolution=resolution,
                resolution_x=resolution_x,
                resolution_y=resolution_y,
                dimension_x=dimension_x,
                text_space=text_space,
                units=units,
                size_mode=size_mode,
                bar_height=bar_height,
                image_height=image_height,
                image_width=image_width,
                rotation_angle=rotation_angle,
                back_color=back_color,
                bar_color=bar_color,
                border_color=border_color,
                border_width=border_width,
                border_dash_style=border_dash_style,
                border_visible=border_visible,
                enable_checksum=enable_checksum,
                enable_escape=enable_escape,
                filled_bars=filled_bars,
                always_show_checksum=always_show_checksum,
                wide_narrow_ratio=wide_narrow_ratio,
                validate_text=validate_text,
                supplement_data=supplement_data,
                supplement_space=supplement_space,
                bar_width_reduction=bar_width_reduction,
                format=format,
                **kwargs
            )
        else:
            (data) = self.get_barcode_generate_with_http_info(
                type,
                text,
                two_d_display_text=two_d_display_text,
                text_location=text_location,
                text_alignment=text_alignment,
                text_color=text_color,
                font_size_mode=font_size_mode,
                resolution=resolution,
                resolution_x=resolution_x,
                resolution_y=resolution_y,
                dimension_x=dimension_x,
                text_space=text_space,
                units=units,
                size_mode=size_mode,
                bar_height=bar_height,
                image_height=image_height,
                image_width=image_width,
                rotation_angle=rotation_angle,
                back_color=back_color,
                bar_color=bar_color,
                border_color=border_color,
                border_width=border_width,
                border_dash_style=border_dash_style,
                border_visible=border_visible,
                enable_checksum=enable_checksum,
                enable_escape=enable_escape,
                filled_bars=filled_bars,
                always_show_checksum=always_show_checksum,
                wide_narrow_ratio=wide_narrow_ratio,
                validate_text=validate_text,
                supplement_data=supplement_data,
                supplement_space=supplement_space,
                bar_width_reduction=bar_width_reduction,
                format=format,
                **kwargs
            )
            return data

    def get_barcode_generate_with_http_info(self, type, text, **kwargs):
        """Generate barcode.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().get_barcode_generate_with_http_info(type, text, async_req=True)
        >>> result = thread.get()

        :param str type: Type of barcode to generate. # noqa: E501
        :param str text: Text to encode. # noqa: E501
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {
            "type",
            "text",
            "two_d_display_text",
            "text_location",
            "text_alignment",
            "text_color",
            "font_size_mode",
            "resolution",
            "resolution_x",
            "resolution_y",
            "dimension_x",
            "text_space",
            "units",
            "size_mode",
            "bar_height",
            "image_height",
            "image_width",
            "rotation_angle",
            "back_color",
            "bar_color",
            "border_color",
            "border_width",
            "border_dash_style",
            "border_visible",
            "enable_checksum",
            "enable_escape",
            "filled_bars",
            "always_show_checksum",
            "wide_narrow_ratio",
            "validate_text",
            "supplement_data",
            "supplement_space",
            "bar_width_reduction",
            "format",
        }
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method get_barcode_generate" % key)
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]
        # verify the required parameter "type" is set
        if "type" not in params or params["type"] is None:
            raise ValueError("Missing the required parameter 'type' when calling 'get_barcode_generate'")
        # verify the required parameter "text" is set
        if "text" not in params or params["text"] is None:
            raise ValueError("Missing the required parameter 'text' when calling 'get_barcode_generate'")

        collection_formats = {}

        path_params = {}

        query_params = []
        if "type" in params:
            query_params.append(("Type", params["type"]))
        if "text" in params:
            query_params.append(("Text", params["text"]))
        if "two_d_display_text" in params:
            query_params.append(("TwoDDisplayText", params["two_d_display_text"]))
        if "text_location" in params:
            query_params.append(("TextLocation", params["text_location"]))
        if "text_alignment" in params:
            query_params.append(("TextAlignment", params["text_alignment"]))
        if "text_color" in params:
            query_params.append(("TextColor", params["text_color"]))
        if "font_size_mode" in params:
            query_params.append(("FontSizeMode", params["font_size_mode"]))
        if "resolution" in params:
            query_params.append(("Resolution", params["resolution"]))
        if "resolution_x" in params:
            query_params.append(("ResolutionX", params["resolution_x"]))
        if "resolution_y" in params:
            query_params.append(("ResolutionY", params["resolution_y"]))
        if "dimension_x" in params:
            query_params.append(("DimensionX", params["dimension_x"]))
        if "text_space" in params:
            query_params.append(("TextSpace", params["text_space"]))
        if "units" in params:
            query_params.append(("Units", params["units"]))
        if "size_mode" in params:
            query_params.append(("SizeMode", params["size_mode"]))
        if "bar_height" in params:
            query_params.append(("BarHeight", params["bar_height"]))
        if "image_height" in params:
            query_params.append(("ImageHeight", params["image_height"]))
        if "image_width" in params:
            query_params.append(("ImageWidth", params["image_width"]))
        if "rotation_angle" in params:
            query_params.append(("RotationAngle", params["rotation_angle"]))
        if "back_color" in params:
            query_params.append(("BackColor", params["back_color"]))
        if "bar_color" in params:
            query_params.append(("BarColor", params["bar_color"]))
        if "border_color" in params:
            query_params.append(("BorderColor", params["border_color"]))
        if "border_width" in params:
            query_params.append(("BorderWidth", params["border_width"]))
        if "border_dash_style" in params:
            query_params.append(("BorderDashStyle", params["border_dash_style"]))
        if "border_visible" in params:
            query_params.append(("BorderVisible", params["border_visible"]))
        if "enable_checksum" in params:
            query_params.append(("EnableChecksum", params["enable_checksum"]))
        if "enable_escape" in params:
            query_params.append(("EnableEscape", params["enable_escape"]))
        if "filled_bars" in params:
            query_params.append(("FilledBars", params["filled_bars"]))
        if "always_show_checksum" in params:
            query_params.append(("AlwaysShowChecksum", params["always_show_checksum"]))
        if "wide_narrow_ratio" in params:
            query_params.append(("WideNarrowRatio", params["wide_narrow_ratio"]))
        if "validate_text" in params:
            query_params.append(("ValidateText", params["validate_text"]))
        if "supplement_data" in params:
            query_params.append(("SupplementData", params["supplement_data"]))
        if "supplement_space" in params:
            query_params.append(("SupplementSpace", params["supplement_space"]))
        if "bar_width_reduction" in params:
            query_params.append(("BarWidthReduction", params["bar_width_reduction"]))
        if "format" in params:
            query_params.append(("format", params["format"]))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(
            ["image/png", "image/bmp", "image/gif", "image/jpeg", "image/svg+xml", "image/tiff"]
        )

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/generate",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="file",
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", False),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_barcode_recognize(
        self,
        name,
        type=None,
        checksum_validation=None,
        detect_encoding=None,
        preset=None,
        rect_x=None,
        rect_y=None,
        rect_width=None,
        rect_height=None,
        strip_fnc=None,
        timeout=None,
        median_smoothing_window_size=None,
        allow_median_smoothing=None,
        allow_complex_background=None,
        allow_datamatrix_industrial_barcodes=None,
        allow_decreased_image=None,
        allow_detect_scan_gap=None,
        allow_incorrect_barcodes=None,
        allow_invert_image=None,
        allow_micro_white_spots_removing=None,
        allow_one_d_fast_barcodes_detector=None,
        allow_one_d_wiped_bars_restoration=None,
        allow_qr_micro_qr_restoration=None,
        allow_regular_image=None,
        allow_salt_and_pepper_filtering=None,
        allow_white_spots_removing=None,
        region_likelihood_threshold_percent=None,
        scan_window_sizes=None,
        similarity=None,
        skip_diagonal_search=None,
        read_tiny_barcodes=None,
        australian_post_encoding_table=None,
        rectangle_region=None,
        storage=None,
        folder=None,
        async_req=False,
        **kwargs
    ):
        """Recognize barcode from a file on server.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().get_barcode_recognize(name, async_req=True)
        >>> result = thread.get()

        :param str name: The image file name. # noqa: E501
        :param str type: The type of barcode to read. # noqa: E501
        :param str checksum_validation: Enable checksum validation during recognition for 1D barcodes. Default is treated as Yes for symbologies which must contain checksum, as No where checksum only possible. Checksum never used: Codabar Checksum is possible: Code39 Standard/Extended, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, DeutschePostIdentcode, DeutschePostLeitcode, VIN Checksum always used: Rest symbologies # noqa: E501
        :param bool detect_encoding: A flag which force engine to detect codetext encoding for Unicode. # noqa: E501
        :param str preset: Preset allows to configure recognition quality and speed manually. You can quickly set up Preset by embedded presets: HighPerformance, NormalQuality, HighQuality, MaxBarCodes or you can manually configure separate options. Default value of Preset is NormalQuality. # noqa: E501
        :param int rect_x: Set X for area for recognition. # noqa: E501
        :param int rect_y: Set Y for area for recognition. # noqa: E501
        :param int rect_width: Set Width of area for recognition. # noqa: E501
        :param int rect_height: Set Height of area for recognition. # noqa: E501
        :param bool strip_fnc: Value indicating whether FNC symbol strip must be done. # noqa: E501
        :param int timeout: Timeout of recognition process. # noqa: E501
        :param int median_smoothing_window_size: Window size for median smoothing. Typical values are 3 or 4. Default value is 3. AllowMedianSmoothing must be set. # noqa: E501
        :param bool allow_median_smoothing: Allows engine to enable median smoothing as additional scan. Mode helps to recognize noised barcodes. # noqa: E501
        :param bool allow_complex_background: Allows engine to recognize color barcodes on color background as additional scan. Extremely slow mode. # noqa: E501
        :param bool allow_datamatrix_industrial_barcodes: Allows engine for Datamatrix to recognize dashed industrial Datamatrix barcodes. Slow mode which helps only for dashed barcodes which consist from spots. # noqa: E501
        :param bool allow_decreased_image: Allows engine to recognize decreased image as additional scan. Size for decreasing is selected by internal engine algorithms. Mode helps to recognize barcodes which are noised and blurred but captured with high resolution. # noqa: E501
        :param bool allow_detect_scan_gap: Allows engine to use gap between scans to increase recognition speed. Mode can make recognition problems with low height barcodes. # noqa: E501
        :param bool allow_incorrect_barcodes: Allows engine to recognize barcodes which has incorrect checksum or incorrect values. Mode can be used to recognize damaged barcodes with incorrect text. # noqa: E501
        :param bool allow_invert_image: Allows engine to recognize inverse color image as additional scan. Mode can be used when barcode is white on black background. # noqa: E501
        :param bool allow_micro_white_spots_removing: Allows engine for Postal barcodes to recognize slightly noised images. Mode helps to recognize slightly damaged Postal barcodes. # noqa: E501
        :param bool allow_one_d_fast_barcodes_detector: Allows engine for 1D barcodes to quickly recognize high quality barcodes which fill almost whole image. Mode helps to quickly recognize generated barcodes from Internet. # noqa: E501
        :param bool allow_one_d_wiped_bars_restoration: Allows engine for 1D barcodes to recognize barcodes with single wiped/glued bars in pattern. # noqa: E501
        :param bool allow_qr_micro_qr_restoration: Allows engine for QR/MicroQR to recognize damaged MicroQR barcodes. # noqa: E501
        :param bool allow_regular_image: Allows engine to recognize regular image without any restorations as main scan. Mode to recognize image as is. # noqa: E501
        :param bool allow_salt_and_pepper_filtering: Allows engine to recognize barcodes with salt and pepper noise type. Mode can remove small noise with white and black dots. # noqa: E501
        :param bool allow_white_spots_removing: Allows engine to recognize image without small white spots as additional scan. Mode helps to recognize noised image as well as median smoothing filtering. # noqa: E501
        :param float region_likelihood_threshold_percent: Sets threshold for detected regions that may contain barcodes. Value 0.7 means that bottom 70% of possible regions are filtered out and not processed further. Region likelihood threshold must be between [0.05, 0.9] Use high values for clear images with few barcodes. Use low values for images with many barcodes or for noisy images. Low value may lead to a bigger recognition time. # noqa: E501
        :param list[int] scan_window_sizes: Scan window sizes in pixels. Allowed sizes are 10, 15, 20, 25, 30. Scanning with small window size takes more time and provides more accuracy but may fail in detecting very big barcodes. Combining of several window sizes can improve detection quality. # noqa: E501
        :param float similarity: Similarity coefficient depends on how homogeneous barcodes are. Use high value for for clear barcodes. Use low values to detect barcodes that ara partly damaged or not lighten evenly. Similarity coefficient must be between [0.5, 0.9] # noqa: E501
        :param bool skip_diagonal_search: Allows detector to skip search for diagonal barcodes. Setting it to false will increase detection time but allow to find diagonal barcodes that can be missed otherwise. Enabling of diagonal search leads to a bigger detection time. # noqa: E501
        :param bool read_tiny_barcodes: Allows engine to recognize tiny barcodes on large images. Ignored if AllowIncorrectBarcodes is set to True. Default value: False. # noqa: E501
        :param str australian_post_encoding_table: Interpreting Type for the Customer Information of AustralianPost BarCode.Default is CustomerInformationInterpretingType.Other. # noqa: E501
        :param str rectangle_region: # noqa: E501
        :param str storage: The image storage. # noqa: E501
        :param str folder: The image folder. # noqa: E501
        :param async_req bool
        :return: BarcodeResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.get_barcode_recognize_with_http_info(
                name,
                type=type,
                checksum_validation=checksum_validation,
                detect_encoding=detect_encoding,
                preset=preset,
                rect_x=rect_x,
                rect_y=rect_y,
                rect_width=rect_width,
                rect_height=rect_height,
                strip_fnc=strip_fnc,
                timeout=timeout,
                median_smoothing_window_size=median_smoothing_window_size,
                allow_median_smoothing=allow_median_smoothing,
                allow_complex_background=allow_complex_background,
                allow_datamatrix_industrial_barcodes=allow_datamatrix_industrial_barcodes,
                allow_decreased_image=allow_decreased_image,
                allow_detect_scan_gap=allow_detect_scan_gap,
                allow_incorrect_barcodes=allow_incorrect_barcodes,
                allow_invert_image=allow_invert_image,
                allow_micro_white_spots_removing=allow_micro_white_spots_removing,
                allow_one_d_fast_barcodes_detector=allow_one_d_fast_barcodes_detector,
                allow_one_d_wiped_bars_restoration=allow_one_d_wiped_bars_restoration,
                allow_qr_micro_qr_restoration=allow_qr_micro_qr_restoration,
                allow_regular_image=allow_regular_image,
                allow_salt_and_pepper_filtering=allow_salt_and_pepper_filtering,
                allow_white_spots_removing=allow_white_spots_removing,
                region_likelihood_threshold_percent=region_likelihood_threshold_percent,
                scan_window_sizes=scan_window_sizes,
                similarity=similarity,
                skip_diagonal_search=skip_diagonal_search,
                read_tiny_barcodes=read_tiny_barcodes,
                australian_post_encoding_table=australian_post_encoding_table,
                rectangle_region=rectangle_region,
                storage=storage,
                folder=folder,
                **kwargs
            )
        else:
            (data) = self.get_barcode_recognize_with_http_info(
                name,
                type=type,
                checksum_validation=checksum_validation,
                detect_encoding=detect_encoding,
                preset=preset,
                rect_x=rect_x,
                rect_y=rect_y,
                rect_width=rect_width,
                rect_height=rect_height,
                strip_fnc=strip_fnc,
                timeout=timeout,
                median_smoothing_window_size=median_smoothing_window_size,
                allow_median_smoothing=allow_median_smoothing,
                allow_complex_background=allow_complex_background,
                allow_datamatrix_industrial_barcodes=allow_datamatrix_industrial_barcodes,
                allow_decreased_image=allow_decreased_image,
                allow_detect_scan_gap=allow_detect_scan_gap,
                allow_incorrect_barcodes=allow_incorrect_barcodes,
                allow_invert_image=allow_invert_image,
                allow_micro_white_spots_removing=allow_micro_white_spots_removing,
                allow_one_d_fast_barcodes_detector=allow_one_d_fast_barcodes_detector,
                allow_one_d_wiped_bars_restoration=allow_one_d_wiped_bars_restoration,
                allow_qr_micro_qr_restoration=allow_qr_micro_qr_restoration,
                allow_regular_image=allow_regular_image,
                allow_salt_and_pepper_filtering=allow_salt_and_pepper_filtering,
                allow_white_spots_removing=allow_white_spots_removing,
                region_likelihood_threshold_percent=region_likelihood_threshold_percent,
                scan_window_sizes=scan_window_sizes,
                similarity=similarity,
                skip_diagonal_search=skip_diagonal_search,
                read_tiny_barcodes=read_tiny_barcodes,
                australian_post_encoding_table=australian_post_encoding_table,
                rectangle_region=rectangle_region,
                storage=storage,
                folder=folder,
                **kwargs
            )
            return data

    def get_barcode_recognize_with_http_info(self, name, **kwargs):
        """Recognize barcode from a file on server.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().get_barcode_recognize_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param str name: The image file name. # noqa: E501
        :return: BarcodeResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {
            "name",
            "type",
            "checksum_validation",
            "detect_encoding",
            "preset",
            "rect_x",
            "rect_y",
            "rect_width",
            "rect_height",
            "strip_fnc",
            "timeout",
            "median_smoothing_window_size",
            "allow_median_smoothing",
            "allow_complex_background",
            "allow_datamatrix_industrial_barcodes",
            "allow_decreased_image",
            "allow_detect_scan_gap",
            "allow_incorrect_barcodes",
            "allow_invert_image",
            "allow_micro_white_spots_removing",
            "allow_one_d_fast_barcodes_detector",
            "allow_one_d_wiped_bars_restoration",
            "allow_qr_micro_qr_restoration",
            "allow_regular_image",
            "allow_salt_and_pepper_filtering",
            "allow_white_spots_removing",
            "region_likelihood_threshold_percent",
            "scan_window_sizes",
            "similarity",
            "skip_diagonal_search",
            "read_tiny_barcodes",
            "australian_post_encoding_table",
            "rectangle_region",
            "storage",
            "folder",
        }
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method get_barcode_recognize" % key)
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]
        # verify the required parameter "name" is set
        if "name" not in params or params["name"] is None:
            raise ValueError("Missing the required parameter 'name' when calling 'get_barcode_recognize'")

        collection_formats = {}

        path_params = {}
        if "name" in params:
            path_params["name"] = params["name"]

        query_params = []
        if "type" in params:
            query_params.append(("Type", params["type"]))
        if "checksum_validation" in params:
            query_params.append(("ChecksumValidation", params["checksum_validation"]))
        if "detect_encoding" in params:
            query_params.append(("DetectEncoding", params["detect_encoding"]))
        if "preset" in params:
            query_params.append(("Preset", params["preset"]))
        if "rect_x" in params:
            query_params.append(("RectX", params["rect_x"]))
        if "rect_y" in params:
            query_params.append(("RectY", params["rect_y"]))
        if "rect_width" in params:
            query_params.append(("RectWidth", params["rect_width"]))
        if "rect_height" in params:
            query_params.append(("RectHeight", params["rect_height"]))
        if "strip_fnc" in params:
            query_params.append(("StripFNC", params["strip_fnc"]))
        if "timeout" in params:
            query_params.append(("Timeout", params["timeout"]))
        if "median_smoothing_window_size" in params:
            query_params.append(("MedianSmoothingWindowSize", params["median_smoothing_window_size"]))
        if "allow_median_smoothing" in params:
            query_params.append(("AllowMedianSmoothing", params["allow_median_smoothing"]))
        if "allow_complex_background" in params:
            query_params.append(("AllowComplexBackground", params["allow_complex_background"]))
        if "allow_datamatrix_industrial_barcodes" in params:
            query_params.append(("AllowDatamatrixIndustrialBarcodes", params["allow_datamatrix_industrial_barcodes"]))
        if "allow_decreased_image" in params:
            query_params.append(("AllowDecreasedImage", params["allow_decreased_image"]))
        if "allow_detect_scan_gap" in params:
            query_params.append(("AllowDetectScanGap", params["allow_detect_scan_gap"]))
        if "allow_incorrect_barcodes" in params:
            query_params.append(("AllowIncorrectBarcodes", params["allow_incorrect_barcodes"]))
        if "allow_invert_image" in params:
            query_params.append(("AllowInvertImage", params["allow_invert_image"]))
        if "allow_micro_white_spots_removing" in params:
            query_params.append(("AllowMicroWhiteSpotsRemoving", params["allow_micro_white_spots_removing"]))
        if "allow_one_d_fast_barcodes_detector" in params:
            query_params.append(("AllowOneDFastBarcodesDetector", params["allow_one_d_fast_barcodes_detector"]))
        if "allow_one_d_wiped_bars_restoration" in params:
            query_params.append(("AllowOneDWipedBarsRestoration", params["allow_one_d_wiped_bars_restoration"]))
        if "allow_qr_micro_qr_restoration" in params:
            query_params.append(("AllowQRMicroQrRestoration", params["allow_qr_micro_qr_restoration"]))
        if "allow_regular_image" in params:
            query_params.append(("AllowRegularImage", params["allow_regular_image"]))
        if "allow_salt_and_pepper_filtering" in params:
            query_params.append(("AllowSaltAndPepperFiltering", params["allow_salt_and_pepper_filtering"]))
        if "allow_white_spots_removing" in params:
            query_params.append(("AllowWhiteSpotsRemoving", params["allow_white_spots_removing"]))
        if "region_likelihood_threshold_percent" in params:
            query_params.append(("RegionLikelihoodThresholdPercent", params["region_likelihood_threshold_percent"]))
        if "scan_window_sizes" in params:
            query_params.append(("ScanWindowSizes", params["scan_window_sizes"]))
            collection_formats["ScanWindowSizes"] = "multi"
        if "similarity" in params:
            query_params.append(("Similarity", params["similarity"]))
        if "skip_diagonal_search" in params:
            query_params.append(("SkipDiagonalSearch", params["skip_diagonal_search"]))
        if "read_tiny_barcodes" in params:
            query_params.append(("ReadTinyBarcodes", params["read_tiny_barcodes"]))
        if "australian_post_encoding_table" in params:
            query_params.append(("AustralianPostEncodingTable", params["australian_post_encoding_table"]))
        if "rectangle_region" in params:
            query_params.append(("RectangleRegion", params["rectangle_region"]))
        if "storage" in params:
            query_params.append(("storage", params["storage"]))
        if "folder" in params:
            query_params.append(("folder", params["folder"]))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/{name}/recognize",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BarcodeResponseList",
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def post_barcode_recognize_from_url_or_content(
        self,
        type=None,
        checksum_validation=None,
        detect_encoding=None,
        preset=None,
        rect_x=None,
        rect_y=None,
        rect_width=None,
        rect_height=None,
        strip_fnc=None,
        timeout=None,
        median_smoothing_window_size=None,
        allow_median_smoothing=None,
        allow_complex_background=None,
        allow_datamatrix_industrial_barcodes=None,
        allow_decreased_image=None,
        allow_detect_scan_gap=None,
        allow_incorrect_barcodes=None,
        allow_invert_image=None,
        allow_micro_white_spots_removing=None,
        allow_one_d_fast_barcodes_detector=None,
        allow_one_d_wiped_bars_restoration=None,
        allow_qr_micro_qr_restoration=None,
        allow_regular_image=None,
        allow_salt_and_pepper_filtering=None,
        allow_white_spots_removing=None,
        region_likelihood_threshold_percent=None,
        scan_window_sizes=None,
        similarity=None,
        skip_diagonal_search=None,
        read_tiny_barcodes=None,
        australian_post_encoding_table=None,
        rectangle_region=None,
        url=None,
        image=None,
        async_req=False,
        **kwargs
    ):
        """Recognize barcode from an url or from request body. Request body can contain raw data bytes of the image or encoded with base64.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().post_barcode_recognize_from_url_or_content(async_req=True)
        >>> result = thread.get()

        :param str type: The type of barcode to read. # noqa: E501
        :param str checksum_validation: Enable checksum validation during recognition for 1D barcodes. Default is treated as Yes for symbologies which must contain checksum, as No where checksum only possible. Checksum never used: Codabar Checksum is possible: Code39 Standard/Extended, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, DeutschePostIdentcode, DeutschePostLeitcode, VIN Checksum always used: Rest symbologies # noqa: E501
        :param bool detect_encoding: A flag which force engine to detect codetext encoding for Unicode. # noqa: E501
        :param str preset: Preset allows to configure recognition quality and speed manually. You can quickly set up Preset by embedded presets: HighPerformance, NormalQuality, HighQuality, MaxBarCodes or you can manually configure separate options. Default value of Preset is NormalQuality. # noqa: E501
        :param int rect_x: Set X for area for recognition. # noqa: E501
        :param int rect_y: Set Y for area for recognition. # noqa: E501
        :param int rect_width: Set Width of area for recognition. # noqa: E501
        :param int rect_height: Set Height of area for recognition. # noqa: E501
        :param bool strip_fnc: Value indicating whether FNC symbol strip must be done. # noqa: E501
        :param int timeout: Timeout of recognition process. # noqa: E501
        :param int median_smoothing_window_size: Window size for median smoothing. Typical values are 3 or 4. Default value is 3. AllowMedianSmoothing must be set. # noqa: E501
        :param bool allow_median_smoothing: Allows engine to enable median smoothing as additional scan. Mode helps to recognize noised barcodes. # noqa: E501
        :param bool allow_complex_background: Allows engine to recognize color barcodes on color background as additional scan. Extremely slow mode. # noqa: E501
        :param bool allow_datamatrix_industrial_barcodes: Allows engine for Datamatrix to recognize dashed industrial Datamatrix barcodes. Slow mode which helps only for dashed barcodes which consist from spots. # noqa: E501
        :param bool allow_decreased_image: Allows engine to recognize decreased image as additional scan. Size for decreasing is selected by internal engine algorithms. Mode helps to recognize barcodes which are noised and blurred but captured with high resolution. # noqa: E501
        :param bool allow_detect_scan_gap: Allows engine to use gap between scans to increase recognition speed. Mode can make recognition problems with low height barcodes. # noqa: E501
        :param bool allow_incorrect_barcodes: Allows engine to recognize barcodes which has incorrect checksum or incorrect values. Mode can be used to recognize damaged barcodes with incorrect text. # noqa: E501
        :param bool allow_invert_image: Allows engine to recognize inverse color image as additional scan. Mode can be used when barcode is white on black background. # noqa: E501
        :param bool allow_micro_white_spots_removing: Allows engine for Postal barcodes to recognize slightly noised images. Mode helps to recognize slightly damaged Postal barcodes. # noqa: E501
        :param bool allow_one_d_fast_barcodes_detector: Allows engine for 1D barcodes to quickly recognize high quality barcodes which fill almost whole image. Mode helps to quickly recognize generated barcodes from Internet. # noqa: E501
        :param bool allow_one_d_wiped_bars_restoration: Allows engine for 1D barcodes to recognize barcodes with single wiped/glued bars in pattern. # noqa: E501
        :param bool allow_qr_micro_qr_restoration: Allows engine for QR/MicroQR to recognize damaged MicroQR barcodes. # noqa: E501
        :param bool allow_regular_image: Allows engine to recognize regular image without any restorations as main scan. Mode to recognize image as is. # noqa: E501
        :param bool allow_salt_and_pepper_filtering: Allows engine to recognize barcodes with salt and pepper noise type. Mode can remove small noise with white and black dots. # noqa: E501
        :param bool allow_white_spots_removing: Allows engine to recognize image without small white spots as additional scan. Mode helps to recognize noised image as well as median smoothing filtering. # noqa: E501
        :param float region_likelihood_threshold_percent: Sets threshold for detected regions that may contain barcodes. Value 0.7 means that bottom 70% of possible regions are filtered out and not processed further. Region likelihood threshold must be between [0.05, 0.9] Use high values for clear images with few barcodes. Use low values for images with many barcodes or for noisy images. Low value may lead to a bigger recognition time. # noqa: E501
        :param list[int] scan_window_sizes: Scan window sizes in pixels. Allowed sizes are 10, 15, 20, 25, 30. Scanning with small window size takes more time and provides more accuracy but may fail in detecting very big barcodes. Combining of several window sizes can improve detection quality. # noqa: E501
        :param float similarity: Similarity coefficient depends on how homogeneous barcodes are. Use high value for for clear barcodes. Use low values to detect barcodes that ara partly damaged or not lighten evenly. Similarity coefficient must be between [0.5, 0.9] # noqa: E501
        :param bool skip_diagonal_search: Allows detector to skip search for diagonal barcodes. Setting it to false will increase detection time but allow to find diagonal barcodes that can be missed otherwise. Enabling of diagonal search leads to a bigger detection time. # noqa: E501
        :param bool read_tiny_barcodes: Allows engine to recognize tiny barcodes on large images. Ignored if AllowIncorrectBarcodes is set to True. Default value: False. # noqa: E501
        :param str australian_post_encoding_table: Interpreting Type for the Customer Information of AustralianPost BarCode.Default is CustomerInformationInterpretingType.Other. # noqa: E501
        :param str rectangle_region: # noqa: E501
        :param str url: The image file url. # noqa: E501
        :param file image: Image data # noqa: E501
        :param async_req bool
        :return: BarcodeResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.post_barcode_recognize_from_url_or_content_with_http_info(
                type=type,
                checksum_validation=checksum_validation,
                detect_encoding=detect_encoding,
                preset=preset,
                rect_x=rect_x,
                rect_y=rect_y,
                rect_width=rect_width,
                rect_height=rect_height,
                strip_fnc=strip_fnc,
                timeout=timeout,
                median_smoothing_window_size=median_smoothing_window_size,
                allow_median_smoothing=allow_median_smoothing,
                allow_complex_background=allow_complex_background,
                allow_datamatrix_industrial_barcodes=allow_datamatrix_industrial_barcodes,
                allow_decreased_image=allow_decreased_image,
                allow_detect_scan_gap=allow_detect_scan_gap,
                allow_incorrect_barcodes=allow_incorrect_barcodes,
                allow_invert_image=allow_invert_image,
                allow_micro_white_spots_removing=allow_micro_white_spots_removing,
                allow_one_d_fast_barcodes_detector=allow_one_d_fast_barcodes_detector,
                allow_one_d_wiped_bars_restoration=allow_one_d_wiped_bars_restoration,
                allow_qr_micro_qr_restoration=allow_qr_micro_qr_restoration,
                allow_regular_image=allow_regular_image,
                allow_salt_and_pepper_filtering=allow_salt_and_pepper_filtering,
                allow_white_spots_removing=allow_white_spots_removing,
                region_likelihood_threshold_percent=region_likelihood_threshold_percent,
                scan_window_sizes=scan_window_sizes,
                similarity=similarity,
                skip_diagonal_search=skip_diagonal_search,
                read_tiny_barcodes=read_tiny_barcodes,
                australian_post_encoding_table=australian_post_encoding_table,
                rectangle_region=rectangle_region,
                url=url,
                image=image,
                **kwargs
            )
        else:
            (data) = self.post_barcode_recognize_from_url_or_content_with_http_info(
                type=type,
                checksum_validation=checksum_validation,
                detect_encoding=detect_encoding,
                preset=preset,
                rect_x=rect_x,
                rect_y=rect_y,
                rect_width=rect_width,
                rect_height=rect_height,
                strip_fnc=strip_fnc,
                timeout=timeout,
                median_smoothing_window_size=median_smoothing_window_size,
                allow_median_smoothing=allow_median_smoothing,
                allow_complex_background=allow_complex_background,
                allow_datamatrix_industrial_barcodes=allow_datamatrix_industrial_barcodes,
                allow_decreased_image=allow_decreased_image,
                allow_detect_scan_gap=allow_detect_scan_gap,
                allow_incorrect_barcodes=allow_incorrect_barcodes,
                allow_invert_image=allow_invert_image,
                allow_micro_white_spots_removing=allow_micro_white_spots_removing,
                allow_one_d_fast_barcodes_detector=allow_one_d_fast_barcodes_detector,
                allow_one_d_wiped_bars_restoration=allow_one_d_wiped_bars_restoration,
                allow_qr_micro_qr_restoration=allow_qr_micro_qr_restoration,
                allow_regular_image=allow_regular_image,
                allow_salt_and_pepper_filtering=allow_salt_and_pepper_filtering,
                allow_white_spots_removing=allow_white_spots_removing,
                region_likelihood_threshold_percent=region_likelihood_threshold_percent,
                scan_window_sizes=scan_window_sizes,
                similarity=similarity,
                skip_diagonal_search=skip_diagonal_search,
                read_tiny_barcodes=read_tiny_barcodes,
                australian_post_encoding_table=australian_post_encoding_table,
                rectangle_region=rectangle_region,
                url=url,
                image=image,
                **kwargs
            )
            return data

    def post_barcode_recognize_from_url_or_content_with_http_info(self, **kwargs):
        """Recognize barcode from an url or from request body. Request body can contain raw data bytes of the image or encoded with base64.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().post_barcode_recognize_from_url_or_content_with_http_info(async_req=True)
        >>> result = thread.get()

        :return: BarcodeResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {
            "type",
            "checksum_validation",
            "detect_encoding",
            "preset",
            "rect_x",
            "rect_y",
            "rect_width",
            "rect_height",
            "strip_fnc",
            "timeout",
            "median_smoothing_window_size",
            "allow_median_smoothing",
            "allow_complex_background",
            "allow_datamatrix_industrial_barcodes",
            "allow_decreased_image",
            "allow_detect_scan_gap",
            "allow_incorrect_barcodes",
            "allow_invert_image",
            "allow_micro_white_spots_removing",
            "allow_one_d_fast_barcodes_detector",
            "allow_one_d_wiped_bars_restoration",
            "allow_qr_micro_qr_restoration",
            "allow_regular_image",
            "allow_salt_and_pepper_filtering",
            "allow_white_spots_removing",
            "region_likelihood_threshold_percent",
            "scan_window_sizes",
            "similarity",
            "skip_diagonal_search",
            "read_tiny_barcodes",
            "australian_post_encoding_table",
            "rectangle_region",
            "url",
            "image",
        }
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_barcode_recognize_from_url_or_content" % key
                )
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "type" in params:
            query_params.append(("Type", params["type"]))
        if "checksum_validation" in params:
            query_params.append(("ChecksumValidation", params["checksum_validation"]))
        if "detect_encoding" in params:
            query_params.append(("DetectEncoding", params["detect_encoding"]))
        if "preset" in params:
            query_params.append(("Preset", params["preset"]))
        if "rect_x" in params:
            query_params.append(("RectX", params["rect_x"]))
        if "rect_y" in params:
            query_params.append(("RectY", params["rect_y"]))
        if "rect_width" in params:
            query_params.append(("RectWidth", params["rect_width"]))
        if "rect_height" in params:
            query_params.append(("RectHeight", params["rect_height"]))
        if "strip_fnc" in params:
            query_params.append(("StripFNC", params["strip_fnc"]))
        if "timeout" in params:
            query_params.append(("Timeout", params["timeout"]))
        if "median_smoothing_window_size" in params:
            query_params.append(("MedianSmoothingWindowSize", params["median_smoothing_window_size"]))
        if "allow_median_smoothing" in params:
            query_params.append(("AllowMedianSmoothing", params["allow_median_smoothing"]))
        if "allow_complex_background" in params:
            query_params.append(("AllowComplexBackground", params["allow_complex_background"]))
        if "allow_datamatrix_industrial_barcodes" in params:
            query_params.append(("AllowDatamatrixIndustrialBarcodes", params["allow_datamatrix_industrial_barcodes"]))
        if "allow_decreased_image" in params:
            query_params.append(("AllowDecreasedImage", params["allow_decreased_image"]))
        if "allow_detect_scan_gap" in params:
            query_params.append(("AllowDetectScanGap", params["allow_detect_scan_gap"]))
        if "allow_incorrect_barcodes" in params:
            query_params.append(("AllowIncorrectBarcodes", params["allow_incorrect_barcodes"]))
        if "allow_invert_image" in params:
            query_params.append(("AllowInvertImage", params["allow_invert_image"]))
        if "allow_micro_white_spots_removing" in params:
            query_params.append(("AllowMicroWhiteSpotsRemoving", params["allow_micro_white_spots_removing"]))
        if "allow_one_d_fast_barcodes_detector" in params:
            query_params.append(("AllowOneDFastBarcodesDetector", params["allow_one_d_fast_barcodes_detector"]))
        if "allow_one_d_wiped_bars_restoration" in params:
            query_params.append(("AllowOneDWipedBarsRestoration", params["allow_one_d_wiped_bars_restoration"]))
        if "allow_qr_micro_qr_restoration" in params:
            query_params.append(("AllowQRMicroQrRestoration", params["allow_qr_micro_qr_restoration"]))
        if "allow_regular_image" in params:
            query_params.append(("AllowRegularImage", params["allow_regular_image"]))
        if "allow_salt_and_pepper_filtering" in params:
            query_params.append(("AllowSaltAndPepperFiltering", params["allow_salt_and_pepper_filtering"]))
        if "allow_white_spots_removing" in params:
            query_params.append(("AllowWhiteSpotsRemoving", params["allow_white_spots_removing"]))
        if "region_likelihood_threshold_percent" in params:
            query_params.append(("RegionLikelihoodThresholdPercent", params["region_likelihood_threshold_percent"]))
        if "scan_window_sizes" in params:
            query_params.append(("ScanWindowSizes", params["scan_window_sizes"]))
            collection_formats["ScanWindowSizes"] = "multi"
        if "similarity" in params:
            query_params.append(("Similarity", params["similarity"]))
        if "skip_diagonal_search" in params:
            query_params.append(("SkipDiagonalSearch", params["skip_diagonal_search"]))
        if "read_tiny_barcodes" in params:
            query_params.append(("ReadTinyBarcodes", params["read_tiny_barcodes"]))
        if "australian_post_encoding_table" in params:
            query_params.append(("AustralianPostEncodingTable", params["australian_post_encoding_table"]))
        if "rectangle_region" in params:
            query_params.append(("RectangleRegion", params["rectangle_region"]))
        if "url" in params:
            query_params.append(("url", params["url"]))

        header_params = {}

        form_params = []
        local_var_files = {}
        if "image" in params:
            local_var_files["image"] = params["image"]

        body_params = None
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["multipart/form-data", "application/octet-stream"]
        )

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/recognize",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BarcodeResponseList",
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def post_generate_multiple(self, generator_params_list, format="png", async_req=False, **kwargs):
        """Generate multiple barcodes and return in response stream

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().post_generate_multiple(generator_params_list, async_req=True)
        >>> result = thread.get()

        :param GeneratorParamsList generator_params_list: List of barcodes # noqa: E501
        :param str format: Format to return stream in # noqa: E501
        :param async_req bool
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.post_generate_multiple_with_http_info(generator_params_list, format=format, **kwargs)
        else:
            (data) = self.post_generate_multiple_with_http_info(generator_params_list, format=format, **kwargs)
            return data

    def post_generate_multiple_with_http_info(self, generator_params_list, **kwargs):
        """Generate multiple barcodes and return in response stream

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().post_generate_multiple_with_http_info(generator_params_list, async_req=True)
        >>> result = thread.get()

        :param GeneratorParamsList generator_params_list: List of barcodes # noqa: E501
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {"generator_params_list", "format"}
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method post_generate_multiple" % key)
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]
        # verify the required parameter "generator_params_list" is set
        if "generator_params_list" not in params or params["generator_params_list"] is None:
            raise ValueError(
                "Missing the required parameter 'generator_params_list' when calling 'post_generate_multiple'"
            )

        collection_formats = {}

        path_params = {}

        query_params = []
        if "format" in params:
            query_params.append(("format", params["format"]))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "generator_params_list" in params:
            body_params = params["generator_params_list"]
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(
            ["image/png", "image/bmp", "image/gif", "image/jpeg", "image/svg+xml", "image/tiff"]
        )

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json", "application/xml"]
        )

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/generateMultiple",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="file",
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", False),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def put_barcode_generate_file(
        self,
        name,
        type,
        text,
        two_d_display_text=None,
        text_location=None,
        text_alignment=None,
        text_color=None,
        font_size_mode=None,
        resolution=None,
        resolution_x=None,
        resolution_y=None,
        dimension_x=None,
        text_space=None,
        units=None,
        size_mode=None,
        bar_height=None,
        image_height=None,
        image_width=None,
        rotation_angle=None,
        back_color=None,
        bar_color=None,
        border_color=None,
        border_width=None,
        border_dash_style=None,
        border_visible=None,
        enable_checksum=None,
        enable_escape=None,
        filled_bars=None,
        always_show_checksum=None,
        wide_narrow_ratio=None,
        validate_text=None,
        supplement_data=None,
        supplement_space=None,
        bar_width_reduction=None,
        storage=None,
        folder=None,
        format=None,
        async_req=False,
        **kwargs
    ):
        """Generate barcode and save on server (from query params or from file with json or xml content)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().put_barcode_generate_file(name, type, text, async_req=True)
        >>> result = thread.get()

        :param str name: The image file name. # noqa: E501
        :param str type: Type of barcode to generate. # noqa: E501
        :param str text: Text to encode. # noqa: E501
        :param str two_d_display_text: Text that will be displayed instead of codetext in 2D barcodes. Used for: Aztec, Pdf417, DataMatrix, QR, MaxiCode, DotCode # noqa: E501
        :param str text_location: Specify the displaying Text Location, set to CodeLocation.None to hide CodeText. Default value: CodeLocation.Below. # noqa: E501
        :param str text_alignment: Text alignment. # noqa: E501
        :param str text_color: Specify the displaying CodeText's Color. Default value: Color.Black. # noqa: E501
        :param str font_size_mode: Specify FontSizeMode. If FontSizeMode is set to Auto, font size will be calculated automatically based on xDimension value. It is recommended to use FontSizeMode.Auto especially in AutoSizeMode.Nearest or AutoSizeMode.Interpolation. Default value: FontSizeMode.Auto. # noqa: E501
        :param float resolution: Resolution of the BarCode image. One value for both dimensions. Default value: 96 dpi. # noqa: E501
        :param float resolution_x: DEPRECATED: Use 'Resolution' instead. # noqa: E501
        :param float resolution_y: DEPRECATED: Use 'Resolution' instead. # noqa: E501
        :param float dimension_x: The smallest width of the unit of BarCode bars or spaces. Increase this will increase the whole barcode image width. Ignored if AutoSizeMode property is set to AutoSizeMode.Nearest or AutoSizeMode.Interpolation. # noqa: E501
        :param float text_space: Space between the CodeText and the BarCode in Unit value. Default value: 2pt. Ignored for EAN8, EAN13, UPCE, UPCA, ISBN, ISMN, ISSN, UpcaGs1DatabarCoupon. # noqa: E501
        :param str units: Common Units for all measuring in query. Default units: pixel. # noqa: E501
        :param str size_mode: Specifies the different types of automatic sizing modes. Default value: AutoSizeMode.None. # noqa: E501
        :param float bar_height: Height of the barcode in given units. Default units: pixel. # noqa: E501
        :param float image_height: Height of the barcode image in given units. Default units: pixel. # noqa: E501
        :param float image_width: Width of the barcode image in given units. Default units: pixel. # noqa: E501
        :param float rotation_angle: BarCode image rotation angle, measured in degree, e.g. RotationAngle = 0 or RotationAngle = 360 means no rotation. If RotationAngle NOT equal to 90, 180, 270 or 0, it may increase the difficulty for the scanner to read the image. Default value: 0. # noqa: E501
        :param str back_color: Background color of the barcode image. Default value: Color.White. # noqa: E501
        :param str bar_color: Bars color. Default value: Color.Black. # noqa: E501
        :param str border_color: Border color. Default value: Color.Black. # noqa: E501
        :param float border_width: Border width. Default value: 0. Ignored if Visible is set to false. # noqa: E501
        :param str border_dash_style: Border dash style. Default value: BorderDashStyle.Solid. # noqa: E501
        :param bool border_visible: Border visibility. If false than parameter Width is always ignored (0). Default value: false. # noqa: E501
        :param str enable_checksum: Enable checksum during generation 1D barcodes. Default is treated as Yes for symbology which must contain checksum, as No where checksum only possible. Checksum is possible: Code39 Standard/Extended, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, DeutschePostIdentcode, DeutschePostLeitcode, VIN, Codabar Checksum always used: Rest symbology # noqa: E501
        :param bool enable_escape: Indicates whether explains the character \"\\\" as an escape character in CodeText property. Used for Pdf417, DataMatrix, Code128 only If the EnableEscape is true, \"\\\" will be explained as a special escape character. Otherwise, \"\\\" acts as normal characters. Aspose.BarCode supports input decimal ascii code and mnemonic for ASCII control-code characters. For example, \\013 and \\\\CR stands for CR. # noqa: E501
        :param bool filled_bars: Value indicating whether bars are filled. Only for 1D barcodes. Default value: true. # noqa: E501
        :param bool always_show_checksum: Always display checksum digit in the human readable text for Code128 and GS1Code128 barcodes. # noqa: E501
        :param float wide_narrow_ratio: Wide bars to Narrow bars ratio. Default value: 3, that is, wide bars are 3 times as wide as narrow bars. Used for ITF, PZN, PharmaCode, Standard2of5, Interleaved2of5, Matrix2of5, ItalianPost25, IATA2of5, VIN, DeutschePost, OPC, Code32, DataLogic2of5, PatchCode, Code39Extended, Code39Standard # noqa: E501
        :param bool validate_text: Only for 1D barcodes. If codetext is incorrect and value set to true - exception will be thrown. Otherwise codetext will be corrected to match barcode's specification. Exception always will be thrown for: Databar symbology if codetext is incorrect. Exception always will not be thrown for: AustraliaPost, SingaporePost, Code39Extended, Code93Extended, Code16K, Code128 symbology if codetext is incorrect. # noqa: E501
        :param str supplement_data: Supplement parameters. Used for Interleaved2of5, Standard2of5, EAN13, EAN8, UPCA, UPCE, ISBN, ISSN, ISMN. # noqa: E501
        :param float supplement_space: Space between main the BarCode and supplement BarCode. # noqa: E501
        :param float bar_width_reduction: Bars reduction value that is used to compensate ink spread while printing. # noqa: E501
        :param str storage: Image's storage. # noqa: E501
        :param str folder: Image's folder. # noqa: E501
        :param str format: The image format. # noqa: E501
        :param async_req bool
        :return: ResultImageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.put_barcode_generate_file_with_http_info(
                name,
                type,
                text,
                two_d_display_text=two_d_display_text,
                text_location=text_location,
                text_alignment=text_alignment,
                text_color=text_color,
                font_size_mode=font_size_mode,
                resolution=resolution,
                resolution_x=resolution_x,
                resolution_y=resolution_y,
                dimension_x=dimension_x,
                text_space=text_space,
                units=units,
                size_mode=size_mode,
                bar_height=bar_height,
                image_height=image_height,
                image_width=image_width,
                rotation_angle=rotation_angle,
                back_color=back_color,
                bar_color=bar_color,
                border_color=border_color,
                border_width=border_width,
                border_dash_style=border_dash_style,
                border_visible=border_visible,
                enable_checksum=enable_checksum,
                enable_escape=enable_escape,
                filled_bars=filled_bars,
                always_show_checksum=always_show_checksum,
                wide_narrow_ratio=wide_narrow_ratio,
                validate_text=validate_text,
                supplement_data=supplement_data,
                supplement_space=supplement_space,
                bar_width_reduction=bar_width_reduction,
                storage=storage,
                folder=folder,
                format=format,
                **kwargs
            )
        else:
            (data) = self.put_barcode_generate_file_with_http_info(
                name,
                type,
                text,
                two_d_display_text=two_d_display_text,
                text_location=text_location,
                text_alignment=text_alignment,
                text_color=text_color,
                font_size_mode=font_size_mode,
                resolution=resolution,
                resolution_x=resolution_x,
                resolution_y=resolution_y,
                dimension_x=dimension_x,
                text_space=text_space,
                units=units,
                size_mode=size_mode,
                bar_height=bar_height,
                image_height=image_height,
                image_width=image_width,
                rotation_angle=rotation_angle,
                back_color=back_color,
                bar_color=bar_color,
                border_color=border_color,
                border_width=border_width,
                border_dash_style=border_dash_style,
                border_visible=border_visible,
                enable_checksum=enable_checksum,
                enable_escape=enable_escape,
                filled_bars=filled_bars,
                always_show_checksum=always_show_checksum,
                wide_narrow_ratio=wide_narrow_ratio,
                validate_text=validate_text,
                supplement_data=supplement_data,
                supplement_space=supplement_space,
                bar_width_reduction=bar_width_reduction,
                storage=storage,
                folder=folder,
                format=format,
                **kwargs
            )
            return data

    def put_barcode_generate_file_with_http_info(self, name, type, text, **kwargs):
        """Generate barcode and save on server (from query params or from file with json or xml content)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().put_barcode_generate_file_with_http_info(name, type, text, async_req=True)
        >>> result = thread.get()

        :param str name: The image file name. # noqa: E501
        :param str type: Type of barcode to generate. # noqa: E501
        :param str text: Text to encode. # noqa: E501
        :return: ResultImageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {
            "name",
            "type",
            "text",
            "two_d_display_text",
            "text_location",
            "text_alignment",
            "text_color",
            "font_size_mode",
            "resolution",
            "resolution_x",
            "resolution_y",
            "dimension_x",
            "text_space",
            "units",
            "size_mode",
            "bar_height",
            "image_height",
            "image_width",
            "rotation_angle",
            "back_color",
            "bar_color",
            "border_color",
            "border_width",
            "border_dash_style",
            "border_visible",
            "enable_checksum",
            "enable_escape",
            "filled_bars",
            "always_show_checksum",
            "wide_narrow_ratio",
            "validate_text",
            "supplement_data",
            "supplement_space",
            "bar_width_reduction",
            "storage",
            "folder",
            "format",
        }
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method put_barcode_generate_file" % key)
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]
        # verify the required parameter "name" is set
        if "name" not in params or params["name"] is None:
            raise ValueError("Missing the required parameter 'name' when calling 'put_barcode_generate_file'")
        # verify the required parameter "type" is set
        if "type" not in params or params["type"] is None:
            raise ValueError("Missing the required parameter 'type' when calling 'put_barcode_generate_file'")
        # verify the required parameter "text" is set
        if "text" not in params or params["text"] is None:
            raise ValueError("Missing the required parameter 'text' when calling 'put_barcode_generate_file'")

        collection_formats = {}

        path_params = {}
        if "name" in params:
            path_params["name"] = params["name"]

        query_params = []
        if "type" in params:
            query_params.append(("Type", params["type"]))
        if "text" in params:
            query_params.append(("Text", params["text"]))
        if "two_d_display_text" in params:
            query_params.append(("TwoDDisplayText", params["two_d_display_text"]))
        if "text_location" in params:
            query_params.append(("TextLocation", params["text_location"]))
        if "text_alignment" in params:
            query_params.append(("TextAlignment", params["text_alignment"]))
        if "text_color" in params:
            query_params.append(("TextColor", params["text_color"]))
        if "font_size_mode" in params:
            query_params.append(("FontSizeMode", params["font_size_mode"]))
        if "resolution" in params:
            query_params.append(("Resolution", params["resolution"]))
        if "resolution_x" in params:
            query_params.append(("ResolutionX", params["resolution_x"]))
        if "resolution_y" in params:
            query_params.append(("ResolutionY", params["resolution_y"]))
        if "dimension_x" in params:
            query_params.append(("DimensionX", params["dimension_x"]))
        if "text_space" in params:
            query_params.append(("TextSpace", params["text_space"]))
        if "units" in params:
            query_params.append(("Units", params["units"]))
        if "size_mode" in params:
            query_params.append(("SizeMode", params["size_mode"]))
        if "bar_height" in params:
            query_params.append(("BarHeight", params["bar_height"]))
        if "image_height" in params:
            query_params.append(("ImageHeight", params["image_height"]))
        if "image_width" in params:
            query_params.append(("ImageWidth", params["image_width"]))
        if "rotation_angle" in params:
            query_params.append(("RotationAngle", params["rotation_angle"]))
        if "back_color" in params:
            query_params.append(("BackColor", params["back_color"]))
        if "bar_color" in params:
            query_params.append(("BarColor", params["bar_color"]))
        if "border_color" in params:
            query_params.append(("BorderColor", params["border_color"]))
        if "border_width" in params:
            query_params.append(("BorderWidth", params["border_width"]))
        if "border_dash_style" in params:
            query_params.append(("BorderDashStyle", params["border_dash_style"]))
        if "border_visible" in params:
            query_params.append(("BorderVisible", params["border_visible"]))
        if "enable_checksum" in params:
            query_params.append(("EnableChecksum", params["enable_checksum"]))
        if "enable_escape" in params:
            query_params.append(("EnableEscape", params["enable_escape"]))
        if "filled_bars" in params:
            query_params.append(("FilledBars", params["filled_bars"]))
        if "always_show_checksum" in params:
            query_params.append(("AlwaysShowChecksum", params["always_show_checksum"]))
        if "wide_narrow_ratio" in params:
            query_params.append(("WideNarrowRatio", params["wide_narrow_ratio"]))
        if "validate_text" in params:
            query_params.append(("ValidateText", params["validate_text"]))
        if "supplement_data" in params:
            query_params.append(("SupplementData", params["supplement_data"]))
        if "supplement_space" in params:
            query_params.append(("SupplementSpace", params["supplement_space"]))
        if "bar_width_reduction" in params:
            query_params.append(("BarWidthReduction", params["bar_width_reduction"]))
        if "storage" in params:
            query_params.append(("storage", params["storage"]))
        if "folder" in params:
            query_params.append(("folder", params["folder"]))
        if "format" in params:
            query_params.append(("format", params["format"]))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json", "application/xml", "multipart/form-data"]
        )

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/{name}/generate",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ResultImageInfo",
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def put_barcode_recognize_from_body(
        self, name, reader_params, type=None, storage=None, folder=None, async_req=False, **kwargs
    ):
        """Recognition of a barcode from file on server with parameters in body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().put_barcode_recognize_from_body(name, reader_params, async_req=True)
        >>> result = thread.get()

        :param str name: The image file name. # noqa: E501
        :param ReaderParams reader_params: BarcodeReader object with parameters. # noqa: E501
        :param str type: # noqa: E501
        :param str storage: The storage name # noqa: E501
        :param str folder: The image folder. # noqa: E501
        :param async_req bool
        :return: BarcodeResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.put_barcode_recognize_from_body_with_http_info(
                name, reader_params, type=type, storage=storage, folder=folder, **kwargs
            )
        else:
            (data) = self.put_barcode_recognize_from_body_with_http_info(
                name, reader_params, type=type, storage=storage, folder=folder, **kwargs
            )
            return data

    def put_barcode_recognize_from_body_with_http_info(self, name, reader_params, **kwargs):
        """Recognition of a barcode from file on server with parameters in body.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().put_barcode_recognize_from_body_with_http_info(name, reader_params, async_req=True)
        >>> result = thread.get()

        :param str name: The image file name. # noqa: E501
        :param ReaderParams reader_params: BarcodeReader object with parameters. # noqa: E501
        :return: BarcodeResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {"name", "reader_params", "type", "storage", "folder"}
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method put_barcode_recognize_from_body" % key
                )
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]
        # verify the required parameter "name" is set
        if "name" not in params or params["name"] is None:
            raise ValueError("Missing the required parameter 'name' when calling 'put_barcode_recognize_from_body'")
        # verify the required parameter "reader_params" is set
        if "reader_params" not in params or params["reader_params"] is None:
            raise ValueError(
                "Missing the required parameter 'reader_params' when calling 'put_barcode_recognize_from_body'"
            )

        collection_formats = {}

        path_params = {}
        if "name" in params:
            path_params["name"] = params["name"]

        query_params = []
        if "type" in params:
            query_params.append(("type", params["type"]))
        if "storage" in params:
            query_params.append(("storage", params["storage"]))
        if "folder" in params:
            query_params.append(("folder", params["folder"]))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "reader_params" in params:
            body_params = params["reader_params"]
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/{name}/recognize",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="BarcodeResponseList",
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def put_generate_multiple(
        self, name, generator_params_list, format="png", folder=None, storage=None, async_req=False, **kwargs
    ):
        """Generate image with multiple barcodes and put new file on server

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().put_generate_multiple(name, generator_params_list, async_req=True)
        >>> result = thread.get()

        :param str name: New filename # noqa: E501
        :param GeneratorParamsList generator_params_list: List of barcodes # noqa: E501
        :param str format: Format of file # noqa: E501
        :param str folder: Folder to place file to # noqa: E501
        :param str storage: The storage name # noqa: E501
        :param async_req bool
        :return: ResultImageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if async_req:
            return self.put_generate_multiple_with_http_info(
                name, generator_params_list, format=format, folder=folder, storage=storage, **kwargs
            )
        else:
            (data) = self.put_generate_multiple_with_http_info(
                name, generator_params_list, format=format, folder=folder, storage=storage, **kwargs
            )
            return data

    def put_generate_multiple_with_http_info(self, name, generator_params_list, **kwargs):
        """Generate image with multiple barcodes and put new file on server

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = BarcodeApi().put_generate_multiple_with_http_info(name, generator_params_list, async_req=True)
        >>> result = thread.get()

        :param str name: New filename # noqa: E501
        :param GeneratorParamsList generator_params_list: List of barcodes # noqa: E501
        :return: ResultImageInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = {"name", "generator_params_list", "format", "folder", "storage"}
        all_params.add("async_req")
        all_params.add("_return_http_data_only")
        all_params.add("_preload_content")
        all_params.add("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'" " to method put_generate_multiple" % key)
            if val is None:
                continue

            params[key] = val
        del params["kwargs"]
        # verify the required parameter "name" is set
        if "name" not in params or params["name"] is None:
            raise ValueError("Missing the required parameter 'name' when calling 'put_generate_multiple'")
        # verify the required parameter "generator_params_list" is set
        if "generator_params_list" not in params or params["generator_params_list"] is None:
            raise ValueError(
                "Missing the required parameter 'generator_params_list' when calling 'put_generate_multiple'"
            )

        collection_formats = {}

        path_params = {}
        if "name" in params:
            path_params["name"] = params["name"]

        query_params = []
        if "format" in params:
            query_params.append(("format", params["format"]))
        if "folder" in params:
            query_params.append(("folder", params["folder"]))
        if "storage" in params:
            query_params.append(("storage", params["storage"]))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "generator_params_list" in params:
            body_params = params["generator_params_list"]
        # HTTP header "Accept"
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header "Content-Type"
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json", "application/xml"]
        )

        # Authentication setting
        auth_settings = ["JWT"]

        return self.api_client.call_api(
            "/barcode/{name}/generateMultiple",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ResultImageInfo",
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
