from base64 import urlsafe_b64decode
from tempfile import mktemp
from pathlib import Path
import azure.durable_functions as df
import logging
import os


def info(msg: str):
    logging.info(f"orchestrator: {msg}")


def _orchestrator(context: df.DurableOrchestrationContext):
    """Orchestrates the execution of a pipeline's SAME steps."""
    input = context.get_input()
    if input is None:  # should never happen, it's only triggered by us
        raise Exception("no input provided to orchestrator.")

    # TODO: handle multiple steps, requirements, docker image etc.
    # TODO: validate the input here, even though initator should have done so.
    # TODO: pass through a GUID generated by initiator for consistent logging.

    if "code" not in input:
        raise Exception("input requires a 'code' field")
    else:
        try:
            code = urlsafe_b64decode(input["code"]).decode("utf-8")
        except Exception as err:
            raise Exception(
                f"'code' field of input should be urlsafe_b64encoded string: {err}")

    info("passing code to executor...")
    result = yield context.call_activity("executor", {
        "code": code,
    })

    info(f"code successfully executed: {result}")
    return result

orchestrator = df.Orchestrator.create(_orchestrator)
